<?php
// This file was auto-generated from sdk-root/src/data/account/2021-02-01/docs-2.json
return [ 'version' => '2.0', 'service' => '<p>Operations for Amazon Web Services Account Management</p>', 'operations' => [ 'DeleteAlternateContact' => '<p>Deletes the specified alternate contact from an Amazon Web Services account.</p> <p>For complete details about how to use the alternate contact operations, see <a href="https://docs.aws.amazon.com/accounts/latest/reference/manage-acct-update-contact.html">Access or updating the alternate contacts</a>.</p> <note> <p>Before you can update the alternate contact information for an Amazon Web Services account that is managed by Organizations, you must first enable integration between Amazon Web Services Account Management and Organizations. For more information, see <a href="https://docs.aws.amazon.com/accounts/latest/reference/using-orgs-trusted-access.html">Enabling trusted access for Amazon Web Services Account Management</a>.</p> </note>', 'GetAlternateContact' => '<p>Retrieves the specified alternate contact attached to an Amazon Web Services account.</p> <p>For complete details about how to use the alternate contact operations, see <a href="https://docs.aws.amazon.com/accounts/latest/reference/manage-acct-update-contact.html">Access or updating the alternate contacts</a>.</p> <note> <p>Before you can update the alternate contact information for an Amazon Web Services account that is managed by Organizations, you must first enable integration between Amazon Web Services Account Management and Organizations. For more information, see <a href="https://docs.aws.amazon.com/accounts/latest/reference/using-orgs-trusted-access.html">Enabling trusted access for Amazon Web Services Account Management</a>.</p> </note>', 'GetContactInformation' => '<p>Retrieves the primary contact information of an Amazon Web Services account.</p> <p>For complete details about how to use the primary contact operations, see <a href="https://docs.aws.amazon.com/accounts/latest/reference/manage-acct-update-contact.html">Update the primary and alternate contact information</a>.</p>', 'PutAlternateContact' => '<p>Modifies the specified alternate contact attached to an Amazon Web Services account.</p> <p>For complete details about how to use the alternate contact operations, see <a href="https://docs.aws.amazon.com/accounts/latest/reference/manage-acct-update-contact.html">Access or updating the alternate contacts</a>.</p> <note> <p>Before you can update the alternate contact information for an Amazon Web Services account that is managed by Organizations, you must first enable integration between Amazon Web Services Account Management and Organizations. For more information, see <a href="https://docs.aws.amazon.com/accounts/latest/reference/using-orgs-trusted-access.html">Enabling trusted access for Amazon Web Services Account Management</a>.</p> </note>', 'PutContactInformation' => '<p>Updates the primary contact information of an Amazon Web Services account.</p> <p>For complete details about how to use the primary contact operations, see <a href="https://docs.aws.amazon.com/accounts/latest/reference/manage-acct-update-contact.html">Update the primary and alternate contact information</a>.</p>', ], 'shapes' => [ 'AccessDeniedException' => [ 'base' => '<p>The operation failed because the calling identity doesn\'t have the minimum required permissions.</p>', 'refs' => [], ], 'AccountId' => [ 'base' => NULL, 'refs' => [ 'DeleteAlternateContactRequest$AccountId' => '<p>Specifies the 12 digit account ID number of the Amazon Web Services account that you want to access or modify with this operation.</p> <p>If you do not specify this parameter, it defaults to the Amazon Web Services account of the identity used to call the operation.</p> <p>To use this parameter, the caller must be an identity in the <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_getting-started_concepts.html#account">organization\'s management account</a> or a delegated administrator account, and the specified account ID must be a member account in the same organization. The organization must have <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_org_support-all-features.html">all features enabled</a>, and the organization must have <a href="https://docs.aws.amazon.com/organizations/latest/userguide/using-orgs-trusted-access.html">trusted access</a> enabled for the Account Management service, and optionally a <a href="https://docs.aws.amazon.com/organizations/latest/userguide/using-orgs-delegated-admin.html">delegated admin</a> account assigned.</p> <note> <p>The management account can\'t specify its own <code>AccountId</code>; it must call the operation in standalone context by not including the <code>AccountId</code> parameter.</p> </note> <p>To call this operation on an account that is not a member of an organization, then don\'t specify this parameter, and call the operation using an identity belonging to the account whose contacts you wish to retrieve or modify.</p>', 'GetAlternateContactRequest$AccountId' => '<p>Specifies the 12 digit account ID number of the Amazon Web Services account that you want to access or modify with this operation.</p> <p>If you do not specify this parameter, it defaults to the Amazon Web Services account of the identity used to call the operation.</p> <p>To use this parameter, the caller must be an identity in the <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_getting-started_concepts.html#account">organization\'s management account</a> or a delegated administrator account, and the specified account ID must be a member account in the same organization. The organization must have <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_org_support-all-features.html">all features enabled</a>, and the organization must have <a href="https://docs.aws.amazon.com/organizations/latest/userguide/using-orgs-trusted-access.html">trusted access</a> enabled for the Account Management service, and optionally a <a href="https://docs.aws.amazon.com/organizations/latest/userguide/using-orgs-delegated-admin.html">delegated admin</a> account assigned.</p> <note> <p>The management account can\'t specify its own <code>AccountId</code>; it must call the operation in standalone context by not including the <code>AccountId</code> parameter.</p> </note> <p>To call this operation on an account that is not a member of an organization, then don\'t specify this parameter, and call the operation using an identity belonging to the account whose contacts you wish to retrieve or modify.</p>', 'GetContactInformationRequest$AccountId' => '<p>Specifies the 12-digit account ID number of the Amazon Web Services account that you want to access or modify with this operation. If you don\'t specify this parameter, it defaults to the Amazon Web Services account of the identity used to call the operation. To use this parameter, the caller must be an identity in the <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_getting-started_concepts.html#account">organization\'s management account</a> or a delegated administrator account. The specified account ID must also be a member account in the same organization. The organization must have <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_org_support-all-features.html">all features enabled</a>, and the organization must have <a href="https://docs.aws.amazon.com/organizations/latest/userguide/using-orgs-trusted-access.html">trusted access</a> enabled for the Account Management service, and optionally a <a href="https://docs.aws.amazon.com/organizations/latest/userguide/using-orgs-delegated-admin.html">delegated admin</a> account assigned.</p> <note> <p>The management account can\'t specify its own <code>AccountId</code>. It must call the operation in standalone context by not including the <code>AccountId</code> parameter.</p> </note> <p>To call this operation on an account that is not a member of an organization, don\'t specify this parameter. Instead, call the operation using an identity belonging to the account whose contacts you wish to retrieve or modify.</p>', 'PutAlternateContactRequest$AccountId' => '<p>Specifies the 12 digit account ID number of the Amazon Web Services account that you want to access or modify with this operation.</p> <p>If you do not specify this parameter, it defaults to the Amazon Web Services account of the identity used to call the operation.</p> <p>To use this parameter, the caller must be an identity in the <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_getting-started_concepts.html#account">organization\'s management account</a> or a delegated administrator account, and the specified account ID must be a member account in the same organization. The organization must have <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_org_support-all-features.html">all features enabled</a>, and the organization must have <a href="https://docs.aws.amazon.com/organizations/latest/userguide/using-orgs-trusted-access.html">trusted access</a> enabled for the Account Management service, and optionally a <a href="https://docs.aws.amazon.com/organizations/latest/userguide/using-orgs-delegated-admin.html">delegated admin</a> account assigned.</p> <note> <p>The management account can\'t specify its own <code>AccountId</code>; it must call the operation in standalone context by not including the <code>AccountId</code> parameter.</p> </note> <p>To call this operation on an account that is not a member of an organization, then don\'t specify this parameter, and call the operation using an identity belonging to the account whose contacts you wish to retrieve or modify.</p>', 'PutContactInformationRequest$AccountId' => '<p>Specifies the 12-digit account ID number of the Amazon Web Services account that you want to access or modify with this operation. If you don\'t specify this parameter, it defaults to the Amazon Web Services account of the identity used to call the operation. To use this parameter, the caller must be an identity in the <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_getting-started_concepts.html#account">organization\'s management account</a> or a delegated administrator account. The specified account ID must also be a member account in the same organization. The organization must have <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_org_support-all-features.html">all features enabled</a>, and the organization must have <a href="https://docs.aws.amazon.com/organizations/latest/userguide/using-orgs-trusted-access.html">trusted access</a> enabled for the Account Management service, and optionally a <a href="https://docs.aws.amazon.com/organizations/latest/userguide/using-orgs-delegated-admin.html">delegated admin</a> account assigned.</p> <note> <p>The management account can\'t specify its own <code>AccountId</code>. It must call the operation in standalone context by not including the <code>AccountId</code> parameter.</p> </note> <p>To call this operation on an account that is not a member of an organization, don\'t specify this parameter. Instead, call the operation using an identity belonging to the account whose contacts you wish to retrieve or modify.</p>', ], ], 'AddressLine' => [ 'base' => NULL, 'refs' => [ 'ContactInformation$AddressLine1' => '<p>The first line of the primary contact address.</p>', 'ContactInformation$AddressLine2' => '<p>The second line of the primary contact address, if any.</p>', 'ContactInformation$AddressLine3' => '<p>The third line of the primary contact address, if any.</p>', ], ], 'AlternateContact' => [ 'base' => '<p>A structure that contains the details of an alternate contact associated with an Amazon Web Services account</p>', 'refs' => [ 'GetAlternateContactResponse$AlternateContact' => '<p>A structure that contains the details for the specified alternate contact.</p>', ], ], 'AlternateContactType' => [ 'base' => NULL, 'refs' => [ 'AlternateContact$AlternateContactType' => '<p>The type of alternate contact.</p>', 'DeleteAlternateContactRequest$AlternateContactType' => '<p>Specifies which of the alternate contacts to delete. </p>', 'GetAlternateContactRequest$AlternateContactType' => '<p>Specifies which alternate contact you want to retrieve.</p>', 'PutAlternateContactRequest$AlternateContactType' => '<p>Specifies which alternate contact you want to create or update.</p>', ], ], 'City' => [ 'base' => NULL, 'refs' => [ 'ContactInformation$City' => '<p>The city of the primary contact address.</p>', ], ], 'CompanyName' => [ 'base' => NULL, 'refs' => [ 'ContactInformation$CompanyName' => '<p>The name of the company associated with the primary contact information, if any.</p>', ], ], 'ContactInformation' => [ 'base' => '<p>Contains the details of the primary contact information associated with an Amazon Web Services account.</p>', 'refs' => [ 'GetContactInformationResponse$ContactInformation' => '<p>Contains the details of the primary contact information associated with an Amazon Web Services account.</p>', 'PutContactInformationRequest$ContactInformation' => '<p>Contains the details of the primary contact information associated with an Amazon Web Services account.</p>', ], ], 'ContactInformationPhoneNumber' => [ 'base' => NULL, 'refs' => [ 'ContactInformation$PhoneNumber' => '<p>The phone number of the primary contact information. The number will be validated and, in some countries, checked for activation.</p>', ], ], 'CountryCode' => [ 'base' => NULL, 'refs' => [ 'ContactInformation$CountryCode' => '<p>The ISO-3166 two-letter country code for the primary contact address.</p>', ], ], 'DeleteAlternateContactRequest' => [ 'base' => NULL, 'refs' => [], ], 'DistrictOrCounty' => [ 'base' => NULL, 'refs' => [ 'ContactInformation$DistrictOrCounty' => '<p>The district or county of the primary contact address, if any.</p>', ], ], 'EmailAddress' => [ 'base' => NULL, 'refs' => [ 'AlternateContact$EmailAddress' => '<p>The email address associated with this alternate contact.</p>', 'PutAlternateContactRequest$EmailAddress' => '<p>Specifies an email address for the alternate contact. </p>', ], ], 'FullName' => [ 'base' => NULL, 'refs' => [ 'ContactInformation$FullName' => '<p>The full name of the primary contact address.</p>', ], ], 'GetAlternateContactRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetAlternateContactResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetContactInformationRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetContactInformationResponse' => [ 'base' => NULL, 'refs' => [], ], 'InternalServerException' => [ 'base' => '<p>The operation failed because of an error internal to Amazon Web Services. Try your operation again later.</p>', 'refs' => [], ], 'Name' => [ 'base' => NULL, 'refs' => [ 'AlternateContact$Name' => '<p>The name associated with this alternate contact.</p>', 'PutAlternateContactRequest$Name' => '<p>Specifies a name for the alternate contact.</p>', ], ], 'PhoneNumber' => [ 'base' => NULL, 'refs' => [ 'AlternateContact$PhoneNumber' => '<p>The phone number associated with this alternate contact.</p>', 'PutAlternateContactRequest$PhoneNumber' => '<p>Specifies a phone number for the alternate contact.</p>', ], ], 'PostalCode' => [ 'base' => NULL, 'refs' => [ 'ContactInformation$PostalCode' => '<p>The postal code of the primary contact address.</p>', ], ], 'PutAlternateContactRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutContactInformationRequest' => [ 'base' => NULL, 'refs' => [], ], 'ResourceNotFoundException' => [ 'base' => '<p>The operation failed because it specified a resource that can\'t be found.</p>', 'refs' => [], ], 'StateOrRegion' => [ 'base' => NULL, 'refs' => [ 'ContactInformation$StateOrRegion' => '<p>The state or region of the primary contact address. This field is required in selected countries.</p>', ], ], 'String' => [ 'base' => NULL, 'refs' => [ 'AccessDeniedException$message' => NULL, 'InternalServerException$message' => NULL, 'ResourceNotFoundException$message' => NULL, 'TooManyRequestsException$message' => NULL, 'ValidationException$message' => NULL, ], ], 'Title' => [ 'base' => NULL, 'refs' => [ 'AlternateContact$Title' => '<p>The title associated with this alternate contact.</p>', 'PutAlternateContactRequest$Title' => '<p>Specifies a title for the alternate contact.</p>', ], ], 'TooManyRequestsException' => [ 'base' => '<p>The operation failed because it was called too frequently and exceeded a throttle limit.</p>', 'refs' => [], ], 'ValidationException' => [ 'base' => '<p>The operation failed because one of the input parameters was invalid.</p>', 'refs' => [], ], 'WebsiteUrl' => [ 'base' => NULL, 'refs' => [ 'ContactInformation$WebsiteUrl' => '<p>The URL of the website associated with the primary contact information, if any.</p>', ], ], ],];
