<?php
// This file was auto-generated from sdk-root/src/data/timestream-write/2018-11-01/docs-2.json
return [ 'version' => '2.0', 'service' => '<fullname>Amazon Timestream Write</fullname> <p>Amazon Timestream is a fast, scalable, fully managed time series database service that makes it easy to store and analyze trillions of time series data points per day. With Timestream, you can easily store and analyze IoT sensor data to derive insights from your IoT applications. You can analyze industrial telemetry to streamline equipment management and maintenance. You can also store and analyze log data and metrics to improve the performance and availability of your applications. Timestream is built from the ground up to effectively ingest, process, and store time series data. It organizes data to optimize query processing. It automatically scales based on the volume of data ingested and on the query volume to ensure you receive optimal performance while inserting and querying data. As your data grows over time, Timestream’s adaptive query processing engine spans across storage tiers to provide fast analysis while reducing costs.</p>', 'operations' => [ 'CreateDatabase' => '<p>Creates a new Timestream database. If the KMS key is not specified, the database will be encrypted with a Timestream managed KMS key located in your account. Refer to <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#aws-managed-cmk">Amazon Web Services managed KMS keys</a> for more info. <a href="https://docs.aws.amazon.com/timestream/latest/developerguide/ts-limits.html">Service quotas apply</a>. See <a href="https://docs.aws.amazon.com/timestream/latest/developerguide/code-samples.create-db.html">code sample</a> for details. </p>', 'CreateTable' => '<p>The CreateTable operation adds a new table to an existing database in your account. In an Amazon Web Services account, table names must be at least unique within each Region if they are in the same database. You may have identical table names in the same Region if the tables are in separate databases. While creating the table, you must specify the table name, database name, and the retention properties. <a href="https://docs.aws.amazon.com/timestream/latest/developerguide/ts-limits.html">Service quotas apply</a>. See <a href="https://docs.aws.amazon.com/timestream/latest/developerguide/code-samples.create-table.html">code sample</a> for details. </p>', 'DeleteDatabase' => '<p>Deletes a given Timestream database. <i>This is an irreversible operation. After a database is deleted, the time series data from its tables cannot be recovered.</i> </p> <note> <p>All tables in the database must be deleted first, or a ValidationException error will be thrown. </p> <p>Due to the nature of distributed retries, the operation can return either success or a ResourceNotFoundException. Clients should consider them equivalent.</p> </note> <p>See <a href="https://docs.aws.amazon.com/timestream/latest/developerguide/code-samples.delete-db.html">code sample</a> for details.</p>', 'DeleteTable' => '<p>Deletes a given Timestream table. This is an irreversible operation. After a Timestream database table is deleted, the time series data stored in the table cannot be recovered. </p> <note> <p>Due to the nature of distributed retries, the operation can return either success or a ResourceNotFoundException. Clients should consider them equivalent.</p> </note> <p>See <a href="https://docs.aws.amazon.com/timestream/latest/developerguide/code-samples.delete-table.html">code sample</a> for details.</p>', 'DescribeDatabase' => '<p>Returns information about the database, including the database name, time that the database was created, and the total number of tables found within the database. <a href="https://docs.aws.amazon.com/timestream/latest/developerguide/ts-limits.html">Service quotas apply</a>. See <a href="https://docs.aws.amazon.com/timestream/latest/developerguide/code-samples.describe-db.html">code sample</a> for details.</p>', 'DescribeEndpoints' => '<p>DescribeEndpoints returns a list of available endpoints to make Timestream API calls against. This API is available through both Write and Query.</p> <p>Because the Timestream SDKs are designed to transparently work with the service’s architecture, including the management and mapping of the service endpoints, <i>it is not recommended that you use this API unless</i>:</p> <ul> <li> <p>You are using <a href="https://docs.aws.amazon.com/timestream/latest/developerguide/VPCEndpoints">VPC endpoints (Amazon Web Services PrivateLink) with Timestream</a> </p> </li> <li> <p>Your application uses a programming language that does not yet have SDK support</p> </li> <li> <p>You require better control over the client-side implementation</p> </li> </ul> <p>For detailed information on how and when to use and implement DescribeEndpoints, see <a href="https://docs.aws.amazon.com/timestream/latest/developerguide/Using.API.html#Using-API.endpoint-discovery">The Endpoint Discovery Pattern</a>.</p>', 'DescribeTable' => '<p>Returns information about the table, including the table name, database name, retention duration of the memory store and the magnetic store. <a href="https://docs.aws.amazon.com/timestream/latest/developerguide/ts-limits.html">Service quotas apply</a>. See <a href="https://docs.aws.amazon.com/timestream/latest/developerguide/code-samples.describe-table.html">code sample</a> for details. </p>', 'ListDatabases' => '<p>Returns a list of your Timestream databases. <a href="https://docs.aws.amazon.com/timestream/latest/developerguide/ts-limits.html">Service quotas apply</a>. See <a href="https://docs.aws.amazon.com/timestream/latest/developerguide/code-samples.list-db.html">code sample</a> for details. </p>', 'ListTables' => '<p>A list of tables, along with the name, status and retention properties of each table. See <a href="https://docs.aws.amazon.com/timestream/latest/developerguide/code-samples.list-table.html">code sample</a> for details. </p>', 'ListTagsForResource' => '<p> List all tags on a Timestream resource. </p>', 'TagResource' => '<p> Associate a set of tags with a Timestream resource. You can then activate these user-defined tags so that they appear on the Billing and Cost Management console for cost allocation tracking. </p>', 'UntagResource' => '<p> Removes the association of tags from a Timestream resource. </p>', 'UpdateDatabase' => '<p> Modifies the KMS key for an existing database. While updating the database, you must specify the database name and the identifier of the new KMS key to be used (<code>KmsKeyId</code>). If there are any concurrent <code>UpdateDatabase</code> requests, first writer wins. </p> <p>See <a href="https://docs.aws.amazon.com/timestream/latest/developerguide/code-samples.update-db.html">code sample</a> for details.</p>', 'UpdateTable' => '<p>Modifies the retention duration of the memory store and magnetic store for your Timestream table. Note that the change in retention duration takes effect immediately. For example, if the retention period of the memory store was initially set to 2 hours and then changed to 24 hours, the memory store will be capable of holding 24 hours of data, but will be populated with 24 hours of data 22 hours after this change was made. Timestream does not retrieve data from the magnetic store to populate the memory store. </p> <p>See <a href="https://docs.aws.amazon.com/timestream/latest/developerguide/code-samples.update-table.html">code sample</a> for details.</p>', 'WriteRecords' => '<p>The WriteRecords operation enables you to write your time series data into Timestream. You can specify a single data point or a batch of data points to be inserted into the system. Timestream offers you with a flexible schema that auto detects the column names and data types for your Timestream tables based on the dimension names and data types of the data points you specify when invoking writes into the database. Timestream support eventual consistency read semantics. This means that when you query data immediately after writing a batch of data into Timestream, the query results might not reflect the results of a recently completed write operation. The results may also include some stale data. If you repeat the query request after a short time, the results should return the latest data. <a href="https://docs.aws.amazon.com/timestream/latest/developerguide/ts-limits.html">Service quotas apply</a>. </p> <p>See <a href="https://docs.aws.amazon.com/timestream/latest/developerguide/code-samples.write.html">code sample</a> for details.</p> <p> <b>Upserts</b> </p> <p>You can use the <code>Version</code> parameter in a <code>WriteRecords</code> request to update data points. Timestream tracks a version number with each record. <code>Version</code> defaults to <code>1</code> when not specified for the record in the request. Timestream will update an existing record’s measure value along with its <code>Version</code> upon receiving a write request with a higher <code>Version</code> number for that record. Upon receiving an update request where the measure value is the same as that of the existing record, Timestream still updates <code>Version</code>, if it is greater than the existing value of <code>Version</code>. You can update a data point as many times as desired, as long as the value of <code>Version</code> continuously increases. </p> <p> For example, suppose you write a new record without indicating <code>Version</code> in the request. Timestream will store this record, and set <code>Version</code> to <code>1</code>. Now, suppose you try to update this record with a <code>WriteRecords</code> request of the same record with a different measure value but, like before, do not provide <code>Version</code>. In this case, Timestream will reject this update with a <code>RejectedRecordsException</code> since the updated record’s version is not greater than the existing value of Version. However, if you were to resend the update request with <code>Version</code> set to <code>2</code>, Timestream would then succeed in updating the record’s value, and the <code>Version</code> would be set to <code>2</code>. Next, suppose you sent a <code>WriteRecords</code> request with this same record and an identical measure value, but with <code>Version</code> set to <code>3</code>. In this case, Timestream would only update <code>Version</code> to <code>3</code>. Any further updates would need to send a version number greater than <code>3</code>, or the update requests would receive a <code>RejectedRecordsException</code>. </p>', ], 'shapes' => [ 'AccessDeniedException' => [ 'base' => '<p>You are not authorized to perform this action.</p>', 'refs' => [], ], 'AmazonResourceName' => [ 'base' => NULL, 'refs' => [ 'ListTagsForResourceRequest$ResourceARN' => '<p> The Timestream resource with tags to be listed. This value is an Amazon Resource Name (ARN). </p>', 'TagResourceRequest$ResourceARN' => '<p> Identifies the Timestream resource to which tags should be added. This value is an Amazon Resource Name (ARN). </p>', 'UntagResourceRequest$ResourceARN' => '<p> The Timestream resource that the tags will be removed from. This value is an Amazon Resource Name (ARN). </p>', ], ], 'Boolean' => [ 'base' => NULL, 'refs' => [ 'MagneticStoreWriteProperties$EnableMagneticStoreWrites' => '<p>A flag to enable magnetic store writes.</p>', ], ], 'ConflictException' => [ 'base' => '<p>Timestream was unable to process this request because it contains resource that already exists.</p>', 'refs' => [], ], 'CreateDatabaseRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateDatabaseResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateTableRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateTableResponse' => [ 'base' => NULL, 'refs' => [], ], 'Database' => [ 'base' => '<p>A top level container for a table. Databases and tables are the fundamental management concepts in Amazon Timestream. All tables in a database are encrypted with the same KMS key.</p>', 'refs' => [ 'CreateDatabaseResponse$Database' => '<p>The newly created Timestream database.</p>', 'DatabaseList$member' => NULL, 'DescribeDatabaseResponse$Database' => '<p>The name of the Timestream table.</p>', 'UpdateDatabaseResponse$Database' => NULL, ], ], 'DatabaseList' => [ 'base' => NULL, 'refs' => [ 'ListDatabasesResponse$Databases' => '<p>A list of database names.</p>', ], ], 'Date' => [ 'base' => NULL, 'refs' => [ 'Database$CreationTime' => '<p>The time when the database was created, calculated from the Unix epoch time.</p>', 'Database$LastUpdatedTime' => '<p> The last time that this database was updated. </p>', 'Table$CreationTime' => '<p>The time when the Timestream table was created. </p>', 'Table$LastUpdatedTime' => '<p>The time when the Timestream table was last updated.</p>', ], ], 'DeleteDatabaseRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteTableRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeDatabaseRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeDatabaseResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeEndpointsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeEndpointsResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeTableRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeTableResponse' => [ 'base' => NULL, 'refs' => [], ], 'Dimension' => [ 'base' => '<p>Dimension represents the meta data attributes of the time series. For example, the name and availability zone of an EC2 instance or the name of the manufacturer of a wind turbine are dimensions. </p>', 'refs' => [ 'Dimensions$member' => NULL, ], ], 'DimensionValueType' => [ 'base' => NULL, 'refs' => [ 'Dimension$DimensionValueType' => '<p>The data type of the dimension for the time series data point.</p>', ], ], 'Dimensions' => [ 'base' => NULL, 'refs' => [ 'Record$Dimensions' => '<p>Contains the list of dimensions for time series data points.</p>', ], ], 'Endpoint' => [ 'base' => '<p>Represents an available endpoint against which to make API calls agaisnt, as well as the TTL for that endpoint.</p>', 'refs' => [ 'Endpoints$member' => NULL, ], ], 'Endpoints' => [ 'base' => NULL, 'refs' => [ 'DescribeEndpointsResponse$Endpoints' => '<p>An <code>Endpoints</code> object is returned when a <code>DescribeEndpoints</code> request is made.</p>', ], ], 'ErrorMessage' => [ 'base' => NULL, 'refs' => [ 'AccessDeniedException$Message' => NULL, 'ConflictException$Message' => NULL, 'InternalServerException$Message' => NULL, 'InvalidEndpointException$Message' => NULL, 'RejectedRecord$Reason' => '<p> The reason why a record was not successfully inserted into Timestream. Possible causes of failure include: </p> <ul> <li> <p>Records with duplicate data where there are multiple records with the same dimensions, timestamps, and measure names but: </p> <ul> <li> <p>Measure values are different</p> </li> <li> <p>Version is not present in the request <i>or</i> the value of version in the new record is equal to or lower than the existing value</p> </li> </ul> <p> If Timestream rejects data for this case, the <code>ExistingVersion</code> field in the <code>RejectedRecords</code> response will indicate the current record’s version. To force an update, you can resend the request with a version for the record set to a value greater than the <code>ExistingVersion</code>.</p> </li> <li> <p> Records with timestamps that lie outside the retention duration of the memory store </p> <note> <p>When the retention window is updated, you will receive a <code>RejectedRecords</code> exception if you immediately try to ingest data within the new window. To avoid a <code>RejectedRecords</code> exception, wait until the duration of the new window to ingest new data. For further information, see <a href="https://docs.aws.amazon.com/timestream/latest/developerguide/best-practices.html#configuration"> Best Practices for Configuring Timestream</a> and <a href="https://docs.aws.amazon.com/timestream/latest/developerguide/storage.html">the explanation of how storage works in Timestream</a>.</p> </note> </li> <li> <p> Records with dimensions or measures that exceed the Timestream defined limits. </p> </li> </ul> <p> For more information, see <a href="https://docs.aws.amazon.com/timestream/latest/developerguide/ts-limits.html">Access Management</a> in the Timestream Developer Guide. </p>', 'RejectedRecordsException$Message' => NULL, 'ResourceNotFoundException$Message' => NULL, 'ServiceQuotaExceededException$Message' => NULL, 'ThrottlingException$Message' => NULL, 'ValidationException$Message' => NULL, ], ], 'Integer' => [ 'base' => NULL, 'refs' => [ 'RecordsIngested$Total' => '<p>Total count of successfully ingested records.</p>', 'RecordsIngested$MemoryStore' => '<p>Count of records ingested into the memory store.</p>', 'RecordsIngested$MagneticStore' => '<p>Count of records ingested into the magnetic store.</p>', ], ], 'InternalServerException' => [ 'base' => '<p> Timestream was unable to fully process this request because of an internal server error.</p>', 'refs' => [], ], 'InvalidEndpointException' => [ 'base' => '<p>The requested endpoint was invalid.</p>', 'refs' => [], ], 'ListDatabasesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListDatabasesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTablesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTablesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'Long' => [ 'base' => NULL, 'refs' => [ 'Database$TableCount' => '<p>The total number of tables found within a Timestream database. </p>', 'Endpoint$CachePeriodInMinutes' => '<p>The TTL for the endpoint, in minutes.</p>', ], ], 'MagneticStoreRejectedDataLocation' => [ 'base' => '<p>The location to write error reports for records rejected, asynchronously, during magnetic store writes.</p>', 'refs' => [ 'MagneticStoreWriteProperties$MagneticStoreRejectedDataLocation' => '<p>The location to write error reports for records rejected asynchronously during magnetic store writes.</p>', ], ], 'MagneticStoreRetentionPeriodInDays' => [ 'base' => NULL, 'refs' => [ 'RetentionProperties$MagneticStoreRetentionPeriodInDays' => '<p>The duration for which data must be stored in the magnetic store. </p>', ], ], 'MagneticStoreWriteProperties' => [ 'base' => '<p>The set of properties on a table for configuring magnetic store writes.</p>', 'refs' => [ 'CreateTableRequest$MagneticStoreWriteProperties' => '<p>Contains properties to set on the table when enabling magnetic store writes.</p>', 'Table$MagneticStoreWriteProperties' => '<p>Contains properties to set on the table when enabling magnetic store writes.</p>', 'UpdateTableRequest$MagneticStoreWriteProperties' => '<p>Contains properties to set on the table when enabling magnetic store writes.</p>', ], ], 'MeasureValue' => [ 'base' => '<p> MeasureValue represents the data attribute of the time series. For example, the CPU utilization of an EC2 instance or the RPM of a wind turbine are measures. MeasureValue has both name and value. </p> <p> MeasureValue is only allowed for type <code>MULTI</code>. Using <code>MULTI</code> type, you can pass multiple data attributes associated with the same time series in a single record </p>', 'refs' => [ 'MeasureValues$member' => NULL, ], ], 'MeasureValueType' => [ 'base' => NULL, 'refs' => [ 'MeasureValue$Type' => '<p>Contains the data type of the MeasureValue for the time series data point.</p>', 'Record$MeasureValueType' => '<p> Contains the data type of the measure value for the time series data point. Default type is <code>DOUBLE</code>. </p>', ], ], 'MeasureValues' => [ 'base' => NULL, 'refs' => [ 'Record$MeasureValues' => '<p> Contains the list of MeasureValue for time series data points. </p> <p> This is only allowed for type <code>MULTI</code>. For scalar values, use <code>MeasureValue</code> attribute of the Record directly. </p>', ], ], 'MemoryStoreRetentionPeriodInHours' => [ 'base' => NULL, 'refs' => [ 'RetentionProperties$MemoryStoreRetentionPeriodInHours' => '<p>The duration for which data must be stored in the memory store. </p>', ], ], 'PaginationLimit' => [ 'base' => NULL, 'refs' => [ 'ListDatabasesRequest$MaxResults' => '<p>The total number of items to return in the output. If the total number of items available is more than the value specified, a NextToken is provided in the output. To resume pagination, provide the NextToken value as argument of a subsequent API invocation.</p>', 'ListTablesRequest$MaxResults' => '<p>The total number of items to return in the output. If the total number of items available is more than the value specified, a NextToken is provided in the output. To resume pagination, provide the NextToken value as argument of a subsequent API invocation.</p>', ], ], 'Record' => [ 'base' => '<p>Record represents a time series data point being written into Timestream. Each record contains an array of dimensions. Dimensions represent the meta data attributes of a time series data point such as the instance name or availability zone of an EC2 instance. A record also contains the measure name which is the name of the measure being collected for example the CPU utilization of an EC2 instance. A record also contains the measure value and the value type which is the data type of the measure value. In addition, the record contains the timestamp when the measure was collected that the timestamp unit which represents the granularity of the timestamp. </p> <p> Records have a <code>Version</code> field, which is a 64-bit <code>long</code> that you can use for updating data points. Writes of a duplicate record with the same dimension, timestamp, and measure name but different measure value will only succeed if the <code>Version</code> attribute of the record in the write request is higher than that of the existing record. Timestream defaults to a <code>Version</code> of <code>1</code> for records without the <code>Version</code> field. </p>', 'refs' => [ 'Records$member' => NULL, 'WriteRecordsRequest$CommonAttributes' => '<p>A record containing the common measure, dimension, time, and version attributes shared across all the records in the request. The measure and dimension attributes specified will be merged with the measure and dimension attributes in the records object when the data is written into Timestream. Dimensions may not overlap, or a <code>ValidationException</code> will be thrown. In other words, a record must contain dimensions with unique names. </p>', ], ], 'RecordIndex' => [ 'base' => NULL, 'refs' => [ 'RejectedRecord$RecordIndex' => '<p> The index of the record in the input request for WriteRecords. Indexes begin with 0. </p>', ], ], 'RecordVersion' => [ 'base' => NULL, 'refs' => [ 'Record$Version' => '<p>64-bit attribute used for record updates. Write requests for duplicate data with a higher version number will update the existing measure value and version. In cases where the measure value is the same, <code>Version</code> will still be updated . Default value is <code>1</code>.</p> <note> <p> <code>Version</code> must be <code>1</code> or greater, or you will receive a <code>ValidationException</code> error.</p> </note>', 'RejectedRecord$ExistingVersion' => '<p>The existing version of the record. This value is populated in scenarios where an identical record exists with a higher version than the version in the write request.</p>', ], ], 'Records' => [ 'base' => NULL, 'refs' => [ 'WriteRecordsRequest$Records' => '<p>An array of records containing the unique measure, dimension, time, and version attributes for each time series data point. </p>', ], ], 'RecordsIngested' => [ 'base' => '<p>Information on the records ingested by this request.</p>', 'refs' => [ 'WriteRecordsResponse$RecordsIngested' => '<p>Information on the records ingested by this request.</p>', ], ], 'RejectedRecord' => [ 'base' => '<p> Records that were not successfully inserted into Timestream due to data validation issues that must be resolved prior to reinserting time series data into the system. </p>', 'refs' => [ 'RejectedRecords$member' => NULL, ], ], 'RejectedRecords' => [ 'base' => NULL, 'refs' => [ 'RejectedRecordsException$RejectedRecords' => NULL, ], ], 'RejectedRecordsException' => [ 'base' => '<p> WriteRecords would throw this exception in the following cases: </p> <ul> <li> <p>Records with duplicate data where there are multiple records with the same dimensions, timestamps, and measure names but: </p> <ul> <li> <p>Measure values are different</p> </li> <li> <p>Version is not present in the request <i>or</i> the value of version in the new record is equal to or lower than the existing value</p> </li> </ul> <p> In this case, if Timestream rejects data, the <code>ExistingVersion</code> field in the <code>RejectedRecords</code> response will indicate the current record’s version. To force an update, you can resend the request with a version for the record set to a value greater than the <code>ExistingVersion</code>.</p> </li> <li> <p> Records with timestamps that lie outside the retention duration of the memory store </p> </li> <li> <p> Records with dimensions or measures that exceed the Timestream defined limits. </p> </li> </ul> <p> For more information, see <a href="https://docs.aws.amazon.com/timestream/latest/developerguide/ts-limits.html">Quotas</a> in the Timestream Developer Guide. </p>', 'refs' => [], ], 'ResourceCreateAPIName' => [ 'base' => NULL, 'refs' => [ 'CreateDatabaseRequest$DatabaseName' => '<p>The name of the Timestream database.</p>', 'CreateTableRequest$DatabaseName' => '<p>The name of the Timestream database.</p>', 'CreateTableRequest$TableName' => '<p>The name of the Timestream table.</p>', ], ], 'ResourceName' => [ 'base' => NULL, 'refs' => [ 'Database$DatabaseName' => '<p>The name of the Timestream database.</p>', 'DeleteDatabaseRequest$DatabaseName' => '<p>The name of the Timestream database to be deleted.</p>', 'DeleteTableRequest$DatabaseName' => '<p>The name of the database where the Timestream database is to be deleted.</p>', 'DeleteTableRequest$TableName' => '<p>The name of the Timestream table to be deleted.</p>', 'DescribeDatabaseRequest$DatabaseName' => '<p>The name of the Timestream database.</p>', 'DescribeTableRequest$DatabaseName' => '<p>The name of the Timestream database.</p>', 'DescribeTableRequest$TableName' => '<p>The name of the Timestream table.</p>', 'ListTablesRequest$DatabaseName' => '<p>The name of the Timestream database.</p>', 'Table$TableName' => '<p>The name of the Timestream table.</p>', 'Table$DatabaseName' => '<p>The name of the Timestream database that contains this table.</p>', 'UpdateDatabaseRequest$DatabaseName' => '<p> The name of the database. </p>', 'UpdateTableRequest$DatabaseName' => '<p>The name of the Timestream database.</p>', 'UpdateTableRequest$TableName' => '<p>The name of the Timestream table.</p>', 'WriteRecordsRequest$DatabaseName' => '<p>The name of the Timestream database.</p>', 'WriteRecordsRequest$TableName' => '<p>The name of the Timestream table.</p>', ], ], 'ResourceNotFoundException' => [ 'base' => '<p>The operation tried to access a nonexistent resource. The resource might not be specified correctly, or its status might not be ACTIVE.</p>', 'refs' => [], ], 'RetentionProperties' => [ 'base' => '<p>Retention properties contain the duration for which your time series data must be stored in the magnetic store and the memory store. </p>', 'refs' => [ 'CreateTableRequest$RetentionProperties' => '<p>The duration for which your time series data must be stored in the memory store and the magnetic store.</p>', 'Table$RetentionProperties' => '<p>The retention duration for the memory store and magnetic store.</p>', 'UpdateTableRequest$RetentionProperties' => '<p>The retention duration of the memory store and the magnetic store.</p>', ], ], 'S3BucketName' => [ 'base' => NULL, 'refs' => [ 'S3Configuration$BucketName' => '<p>&gt;Bucket name of the customer S3 bucket.</p>', ], ], 'S3Configuration' => [ 'base' => '<p>Configuration specifing an S3 location.</p>', 'refs' => [ 'MagneticStoreRejectedDataLocation$S3Configuration' => '<p>Configuration of an S3 location to write error reports for records rejected, asynchronously, during magnetic store writes.</p>', ], ], 'S3EncryptionOption' => [ 'base' => NULL, 'refs' => [ 'S3Configuration$EncryptionOption' => '<p>Encryption option for the customer s3 location. Options are S3 server side encryption with an S3-managed key or KMS managed key.</p>', ], ], 'S3ObjectKeyPrefix' => [ 'base' => NULL, 'refs' => [ 'S3Configuration$ObjectKeyPrefix' => '<p>Object key preview for the customer S3 location.</p>', ], ], 'SchemaName' => [ 'base' => NULL, 'refs' => [ 'Dimension$Name' => '<p> Dimension represents the meta data attributes of the time series. For example, the name and availability zone of an EC2 instance or the name of the manufacturer of a wind turbine are dimensions. </p> <p>For constraints on Dimension names, see <a href="https://docs.aws.amazon.com/timestream/latest/developerguide/ts-limits.html#limits.naming">Naming Constraints</a>.</p>', 'MeasureValue$Name' => '<p> Name of the MeasureValue. </p> <p> For constraints on MeasureValue names, refer to <a href="https://docs.aws.amazon.com/timestream/latest/developerguide/ts-limits.html#limits.naming"> Naming Constraints</a> in the Timestream developer guide.</p>', 'Record$MeasureName' => '<p>Measure represents the data attribute of the time series. For example, the CPU utilization of an EC2 instance or the RPM of a wind turbine are measures. </p>', ], ], 'SchemaValue' => [ 'base' => NULL, 'refs' => [ 'Dimension$Value' => '<p>The value of the dimension.</p>', ], ], 'ServiceQuotaExceededException' => [ 'base' => '<p> Instance quota of resource exceeded for this account.</p>', 'refs' => [], ], 'String' => [ 'base' => NULL, 'refs' => [ 'Database$Arn' => '<p>The Amazon Resource Name that uniquely identifies this database.</p>', 'Endpoint$Address' => '<p>An endpoint address.</p>', 'ListDatabasesRequest$NextToken' => '<p>The pagination token. To resume pagination, provide the NextToken value as argument of a subsequent API invocation.</p>', 'ListDatabasesResponse$NextToken' => '<p>The pagination token. This parameter is returned when the response is truncated.</p>', 'ListTablesRequest$NextToken' => '<p>The pagination token. To resume pagination, provide the NextToken value as argument of a subsequent API invocation.</p>', 'ListTablesResponse$NextToken' => '<p>A token to specify where to start paginating. This is the NextToken from a previously truncated response.</p>', 'Table$Arn' => '<p>The Amazon Resource Name that uniquely identifies this table.</p>', ], ], 'StringValue2048' => [ 'base' => NULL, 'refs' => [ 'CreateDatabaseRequest$KmsKeyId' => '<p>The KMS key for the database. If the KMS key is not specified, the database will be encrypted with a Timestream managed KMS key located in your account. Refer to <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#aws-managed-cmk">Amazon Web Services managed KMS keys</a> for more info.</p>', 'Database$KmsKeyId' => '<p>The identifier of the KMS key used to encrypt the data stored in the database.</p>', 'MeasureValue$Value' => '<p> Value for the MeasureValue. </p>', 'Record$MeasureValue' => '<p> Contains the measure value for the time series data point. </p>', 'S3Configuration$KmsKeyId' => '<p>KMS key id for the customer s3 location when encrypting with a KMS managed key.</p>', 'UpdateDatabaseRequest$KmsKeyId' => '<p> The identifier of the new KMS key (<code>KmsKeyId</code>) to be used to encrypt the data stored in the database. If the <code>KmsKeyId</code> currently registered with the database is the same as the <code>KmsKeyId</code> in the request, there will not be any update. </p> <p>You can specify the <code>KmsKeyId</code> using any of the following:</p> <ul> <li> <p>Key ID: <code>1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li> <li> <p>Key ARN: <code>arn:aws:kms:us-east-1:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li> <li> <p>Alias name: <code>alias/ExampleAlias</code> </p> </li> <li> <p>Alias ARN: <code>arn:aws:kms:us-east-1:111122223333:alias/ExampleAlias</code> </p> </li> </ul>', ], ], 'StringValue256' => [ 'base' => NULL, 'refs' => [ 'Record$Time' => '<p> Contains the time at which the measure value for the data point was collected. The time value plus the unit provides the time elapsed since the epoch. For example, if the time value is <code>12345</code> and the unit is <code>ms</code>, then <code>12345 ms</code> have elapsed since the epoch. </p>', ], ], 'Table' => [ 'base' => '<p>Table represents a database table in Timestream. Tables contain one or more related time series. You can modify the retention duration of the memory store and the magnetic store for a table. </p>', 'refs' => [ 'CreateTableResponse$Table' => '<p>The newly created Timestream table.</p>', 'DescribeTableResponse$Table' => '<p>The Timestream table.</p>', 'TableList$member' => NULL, 'UpdateTableResponse$Table' => '<p>The updated Timestream table.</p>', ], ], 'TableList' => [ 'base' => NULL, 'refs' => [ 'ListTablesResponse$Tables' => '<p>A list of tables.</p>', ], ], 'TableStatus' => [ 'base' => NULL, 'refs' => [ 'Table$TableStatus' => '<p>The current state of the table:</p> <ul> <li> <p> <code>DELETING</code> - The table is being deleted.</p> </li> <li> <p> <code>ACTIVE</code> - The table is ready for use.</p> </li> </ul>', ], ], 'Tag' => [ 'base' => '<p> A tag is a label that you assign to a Timestream database and/or table. Each tag consists of a key and an optional value, both of which you define. Tags enable you to categorize databases and/or tables, for example, by purpose, owner, or environment. </p>', 'refs' => [ 'TagList$member' => NULL, ], ], 'TagKey' => [ 'base' => NULL, 'refs' => [ 'Tag$Key' => '<p> The key of the tag. Tag keys are case sensitive. </p>', 'TagKeyList$member' => NULL, ], ], 'TagKeyList' => [ 'base' => NULL, 'refs' => [ 'UntagResourceRequest$TagKeys' => '<p> A list of tags keys. Existing tags of the resource whose keys are members of this list will be removed from the Timestream resource. </p>', ], ], 'TagList' => [ 'base' => NULL, 'refs' => [ 'CreateDatabaseRequest$Tags' => '<p> A list of key-value pairs to label the table. </p>', 'CreateTableRequest$Tags' => '<p> A list of key-value pairs to label the table. </p>', 'ListTagsForResourceResponse$Tags' => '<p> The tags currently associated with the Timestream resource. </p>', 'TagResourceRequest$Tags' => '<p> The tags to be assigned to the Timestream resource. </p>', ], ], 'TagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'TagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'TagValue' => [ 'base' => NULL, 'refs' => [ 'Tag$Value' => '<p> The value of the tag. Tag values are case-sensitive and can be null. </p>', ], ], 'ThrottlingException' => [ 'base' => '<p> Too many requests were made by a user exceeding service quotas. The request was throttled.</p>', 'refs' => [], ], 'TimeUnit' => [ 'base' => NULL, 'refs' => [ 'Record$TimeUnit' => '<p> The granularity of the timestamp unit. It indicates if the time value is in seconds, milliseconds, nanoseconds or other supported values. Default is <code>MILLISECONDS</code>. </p>', ], ], 'UntagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'UntagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateDatabaseRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateDatabaseResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateTableRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateTableResponse' => [ 'base' => NULL, 'refs' => [], ], 'ValidationException' => [ 'base' => '<p> Invalid or malformed request.</p>', 'refs' => [], ], 'WriteRecordsRequest' => [ 'base' => NULL, 'refs' => [], ], 'WriteRecordsResponse' => [ 'base' => NULL, 'refs' => [], ], ],];
