<?php
// This file was auto-generated from sdk-root/src/data/support/2013-04-15/docs-2.json
return [ 'version' => '2.0', 'service' => '<fullname>Amazon Web Services Support</fullname> <p>The <i>Amazon Web Services Support API Reference</i> is intended for programmers who need detailed information about the Amazon Web Services Support operations and data types. You can use the API to manage your support cases programmatically. The Amazon Web Services Support API uses HTTP methods that return results in JSON format.</p> <note> <ul> <li> <p>You must have a Business, Enterprise On-Ramp, or Enterprise Support plan to use the Amazon Web Services Support API. </p> </li> <li> <p>If you call the Amazon Web Services Support API from an account that does not have a Business, Enterprise On-Ramp, or Enterprise Support plan, the <code>SubscriptionRequiredException</code> error message appears. For information about changing your support plan, see <a href="http://aws.amazon.com/premiumsupport/">Amazon Web Services Support</a>.</p> </li> </ul> </note> <p>The Amazon Web Services Support service also exposes a set of <a href="http://aws.amazon.com/premiumsupport/trustedadvisor/">Trusted Advisor</a> features. You can retrieve a list of checks and their descriptions, get check results, specify checks to refresh, and get the refresh status of checks.</p> <p>The following list describes the Amazon Web Services Support case management operations:</p> <ul> <li> <p> Service names, issue categories, and available severity levels - The <a>DescribeServices</a> and <a>DescribeSeverityLevels</a> operations return Amazon Web Services service names, service codes, service categories, and problem severity levels. You use these values when you call the <a>CreateCase</a> operation.</p> </li> <li> <p> Case creation, case details, and case resolution - The <a>CreateCase</a>, <a>DescribeCases</a>, <a>DescribeAttachment</a>, and <a>ResolveCase</a> operations create Amazon Web Services Support cases, retrieve information about cases, and resolve cases.</p> </li> <li> <p> Case communication - The <a>DescribeCommunications</a>, <a>AddCommunicationToCase</a>, and <a>AddAttachmentsToSet</a> operations retrieve and add communications and attachments to Amazon Web Services Support cases.</p> </li> </ul> <p>The following list describes the operations available from the Amazon Web Services Support service for Trusted Advisor:</p> <ul> <li> <p> <a>DescribeTrustedAdvisorChecks</a> returns the list of checks that run against your Amazon Web Services resources.</p> </li> <li> <p>Using the <code>checkId</code> for a specific check returned by <a>DescribeTrustedAdvisorChecks</a>, you can call <a>DescribeTrustedAdvisorCheckResult</a> to obtain the results for the check that you specified.</p> </li> <li> <p> <a>DescribeTrustedAdvisorCheckSummaries</a> returns summarized results for one or more Trusted Advisor checks.</p> </li> <li> <p> <a>RefreshTrustedAdvisorCheck</a> requests that Trusted Advisor rerun a specified check.</p> </li> <li> <p> <a>DescribeTrustedAdvisorCheckRefreshStatuses</a> reports the refresh status of one or more checks.</p> </li> </ul> <p>For authentication of requests, Amazon Web Services Support uses <a href="https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html">Signature Version 4 Signing Process</a>.</p> <p>See <a href="https://docs.aws.amazon.com/awssupport/latest/user/Welcome.html">About the Amazon Web Services Support API</a> in the <i>Amazon Web Services Support User Guide</i> for information about how to use this service to create and manage your support cases, and how to call Trusted Advisor for results of checks on your resources.</p>', 'operations' => [ 'AddAttachmentsToSet' => '<p>Adds one or more attachments to an attachment set. </p> <p>An attachment set is a temporary container for attachments that you add to a case or case communication. The set is available for 1 hour after it\'s created. The <code>expiryTime</code> returned in the response is when the set expires. </p> <note> <ul> <li> <p>You must have a Business, Enterprise On-Ramp, or Enterprise Support plan to use the Amazon Web Services Support API. </p> </li> <li> <p>If you call the Amazon Web Services Support API from an account that does not have a Business, Enterprise On-Ramp, or Enterprise Support plan, the <code>SubscriptionRequiredException</code> error message appears. For information about changing your support plan, see <a href="http://aws.amazon.com/premiumsupport/">Amazon Web Services Support</a>.</p> </li> </ul> </note>', 'AddCommunicationToCase' => '<p>Adds additional customer communication to an Amazon Web Services Support case. Use the <code>caseId</code> parameter to identify the case to which to add communication. You can list a set of email addresses to copy on the communication by using the <code>ccEmailAddresses</code> parameter. The <code>communicationBody</code> value contains the text of the communication.</p> <note> <ul> <li> <p>You must have a Business, Enterprise On-Ramp, or Enterprise Support plan to use the Amazon Web Services Support API. </p> </li> <li> <p>If you call the Amazon Web Services Support API from an account that does not have a Business, Enterprise On-Ramp, or Enterprise Support plan, the <code>SubscriptionRequiredException</code> error message appears. For information about changing your support plan, see <a href="http://aws.amazon.com/premiumsupport/">Amazon Web Services Support</a>.</p> </li> </ul> </note>', 'CreateCase' => '<p>Creates a case in the Amazon Web Services Support Center. This operation is similar to how you create a case in the Amazon Web Services Support Center <a href="https://console.aws.amazon.com/support/home#/case/create">Create Case</a> page.</p> <p>The Amazon Web Services Support API doesn\'t support requesting service limit increases. You can submit a service limit increase in the following ways: </p> <ul> <li> <p>Submit a request from the Amazon Web Services Support Center <a href="https://console.aws.amazon.com/support/home#/case/create">Create Case</a> page.</p> </li> <li> <p>Use the Service Quotas <a href="https://docs.aws.amazon.com/servicequotas/2019-06-24/apireference/API_RequestServiceQuotaIncrease.html">RequestServiceQuotaIncrease</a> operation.</p> </li> </ul> <p>A successful <code>CreateCase</code> request returns an Amazon Web Services Support case number. You can use the <a>DescribeCases</a> operation and specify the case number to get existing Amazon Web Services Support cases. After you create a case, use the <a>AddCommunicationToCase</a> operation to add additional communication or attachments to an existing case.</p> <p>The <code>caseId</code> is separate from the <code>displayId</code> that appears in the <a href="https://console.aws.amazon.com/support">Amazon Web Services Support Center</a>. Use the <a>DescribeCases</a> operation to get the <code>displayId</code>.</p> <note> <ul> <li> <p>You must have a Business, Enterprise On-Ramp, or Enterprise Support plan to use the Amazon Web Services Support API. </p> </li> <li> <p>If you call the Amazon Web Services Support API from an account that does not have a Business, Enterprise On-Ramp, or Enterprise Support plan, the <code>SubscriptionRequiredException</code> error message appears. For information about changing your support plan, see <a href="http://aws.amazon.com/premiumsupport/">Amazon Web Services Support</a>.</p> </li> </ul> </note>', 'DescribeAttachment' => '<p>Returns the attachment that has the specified ID. Attachments can include screenshots, error logs, or other files that describe your issue. Attachment IDs are generated by the case management system when you add an attachment to a case or case communication. Attachment IDs are returned in the <a>AttachmentDetails</a> objects that are returned by the <a>DescribeCommunications</a> operation.</p> <note> <ul> <li> <p>You must have a Business, Enterprise On-Ramp, or Enterprise Support plan to use the Amazon Web Services Support API. </p> </li> <li> <p>If you call the Amazon Web Services Support API from an account that does not have a Business, Enterprise On-Ramp, or Enterprise Support plan, the <code>SubscriptionRequiredException</code> error message appears. For information about changing your support plan, see <a href="http://aws.amazon.com/premiumsupport/">Amazon Web Services Support</a>.</p> </li> </ul> </note>', 'DescribeCases' => '<p>Returns a list of cases that you specify by passing one or more case IDs. You can use the <code>afterTime</code> and <code>beforeTime</code> parameters to filter the cases by date. You can set values for the <code>includeResolvedCases</code> and <code>includeCommunications</code> parameters to specify how much information to return.</p> <p>The response returns the following in JSON format:</p> <ul> <li> <p>One or more <a href="https://docs.aws.amazon.com/awssupport/latest/APIReference/API_CaseDetails.html">CaseDetails</a> data types.</p> </li> <li> <p>One or more <code>nextToken</code> values, which specify where to paginate the returned records represented by the <code>CaseDetails</code> objects.</p> </li> </ul> <p>Case data is available for 12 months after creation. If a case was created more than 12 months ago, a request might return an error.</p> <note> <ul> <li> <p>You must have a Business, Enterprise On-Ramp, or Enterprise Support plan to use the Amazon Web Services Support API. </p> </li> <li> <p>If you call the Amazon Web Services Support API from an account that does not have a Business, Enterprise On-Ramp, or Enterprise Support plan, the <code>SubscriptionRequiredException</code> error message appears. For information about changing your support plan, see <a href="http://aws.amazon.com/premiumsupport/">Amazon Web Services Support</a>.</p> </li> </ul> </note>', 'DescribeCommunications' => '<p>Returns communications and attachments for one or more support cases. Use the <code>afterTime</code> and <code>beforeTime</code> parameters to filter by date. You can use the <code>caseId</code> parameter to restrict the results to a specific case.</p> <p>Case data is available for 12 months after creation. If a case was created more than 12 months ago, a request for data might cause an error.</p> <p>You can use the <code>maxResults</code> and <code>nextToken</code> parameters to control the pagination of the results. Set <code>maxResults</code> to the number of cases that you want to display on each page, and use <code>nextToken</code> to specify the resumption of pagination.</p> <note> <ul> <li> <p>You must have a Business, Enterprise On-Ramp, or Enterprise Support plan to use the Amazon Web Services Support API. </p> </li> <li> <p>If you call the Amazon Web Services Support API from an account that does not have a Business, Enterprise On-Ramp, or Enterprise Support plan, the <code>SubscriptionRequiredException</code> error message appears. For information about changing your support plan, see <a href="http://aws.amazon.com/premiumsupport/">Amazon Web Services Support</a>.</p> </li> </ul> </note>', 'DescribeServices' => '<p>Returns the current list of Amazon Web Services services and a list of service categories for each service. You then use service names and categories in your <a>CreateCase</a> requests. Each Amazon Web Services service has its own set of categories.</p> <p>The service codes and category codes correspond to the values that appear in the <b>Service</b> and <b>Category</b> lists on the Amazon Web Services Support Center <a href="https://console.aws.amazon.com/support/home#/case/create">Create Case</a> page. The values in those fields don\'t necessarily match the service codes and categories returned by the <code>DescribeServices</code> operation. Always use the service codes and categories that the <code>DescribeServices</code> operation returns, so that you have the most recent set of service and category codes.</p> <note> <ul> <li> <p>You must have a Business, Enterprise On-Ramp, or Enterprise Support plan to use the Amazon Web Services Support API. </p> </li> <li> <p>If you call the Amazon Web Services Support API from an account that does not have a Business, Enterprise On-Ramp, or Enterprise Support plan, the <code>SubscriptionRequiredException</code> error message appears. For information about changing your support plan, see <a href="http://aws.amazon.com/premiumsupport/">Amazon Web Services Support</a>.</p> </li> </ul> </note>', 'DescribeSeverityLevels' => '<p>Returns the list of severity levels that you can assign to a support case. The severity level for a case is also a field in the <a>CaseDetails</a> data type that you include for a <a>CreateCase</a> request.</p> <note> <ul> <li> <p>You must have a Business, Enterprise On-Ramp, or Enterprise Support plan to use the Amazon Web Services Support API. </p> </li> <li> <p>If you call the Amazon Web Services Support API from an account that does not have a Business, Enterprise On-Ramp, or Enterprise Support plan, the <code>SubscriptionRequiredException</code> error message appears. For information about changing your support plan, see <a href="http://aws.amazon.com/premiumsupport/">Amazon Web Services Support</a>.</p> </li> </ul> </note>', 'DescribeTrustedAdvisorCheckRefreshStatuses' => '<p>Returns the refresh status of the Trusted Advisor checks that have the specified check IDs. You can get the check IDs by calling the <a>DescribeTrustedAdvisorChecks</a> operation.</p> <p>Some checks are refreshed automatically, and you can\'t return their refresh statuses by using the <code>DescribeTrustedAdvisorCheckRefreshStatuses</code> operation. If you call this operation for these checks, you might see an <code>InvalidParameterValue</code> error.</p> <note> <ul> <li> <p>You must have a Business, Enterprise On-Ramp, or Enterprise Support plan to use the Amazon Web Services Support API. </p> </li> <li> <p>If you call the Amazon Web Services Support API from an account that does not have a Business, Enterprise On-Ramp, or Enterprise Support plan, the <code>SubscriptionRequiredException</code> error message appears. For information about changing your support plan, see <a href="http://aws.amazon.com/premiumsupport/">Amazon Web Services Support</a>.</p> </li> </ul> </note>', 'DescribeTrustedAdvisorCheckResult' => '<p>Returns the results of the Trusted Advisor check that has the specified check ID. You can get the check IDs by calling the <a>DescribeTrustedAdvisorChecks</a> operation.</p> <p>The response contains a <a>TrustedAdvisorCheckResult</a> object, which contains these three objects:</p> <ul> <li> <p> <a>TrustedAdvisorCategorySpecificSummary</a> </p> </li> <li> <p> <a>TrustedAdvisorResourceDetail</a> </p> </li> <li> <p> <a>TrustedAdvisorResourcesSummary</a> </p> </li> </ul> <p>In addition, the response contains these fields:</p> <ul> <li> <p> <b>status</b> - The alert status of the check can be <code>ok</code> (green), <code>warning</code> (yellow), <code>error</code> (red), or <code>not_available</code>.</p> </li> <li> <p> <b>timestamp</b> - The time of the last refresh of the check.</p> </li> <li> <p> <b>checkId</b> - The unique identifier for the check.</p> </li> </ul> <note> <ul> <li> <p>You must have a Business, Enterprise On-Ramp, or Enterprise Support plan to use the Amazon Web Services Support API. </p> </li> <li> <p>If you call the Amazon Web Services Support API from an account that does not have a Business, Enterprise On-Ramp, or Enterprise Support plan, the <code>SubscriptionRequiredException</code> error message appears. For information about changing your support plan, see <a href="http://aws.amazon.com/premiumsupport/">Amazon Web Services Support</a>.</p> </li> </ul> </note>', 'DescribeTrustedAdvisorCheckSummaries' => '<p>Returns the results for the Trusted Advisor check summaries for the check IDs that you specified. You can get the check IDs by calling the <a>DescribeTrustedAdvisorChecks</a> operation.</p> <p>The response contains an array of <a>TrustedAdvisorCheckSummary</a> objects.</p> <note> <ul> <li> <p>You must have a Business, Enterprise On-Ramp, or Enterprise Support plan to use the Amazon Web Services Support API. </p> </li> <li> <p>If you call the Amazon Web Services Support API from an account that does not have a Business, Enterprise On-Ramp, or Enterprise Support plan, the <code>SubscriptionRequiredException</code> error message appears. For information about changing your support plan, see <a href="http://aws.amazon.com/premiumsupport/">Amazon Web Services Support</a>.</p> </li> </ul> </note>', 'DescribeTrustedAdvisorChecks' => '<p>Returns information about all available Trusted Advisor checks, including the name, ID, category, description, and metadata. You must specify a language code. The Amazon Web Services Support API currently supports English ("en") and Japanese ("ja"). The response contains a <a>TrustedAdvisorCheckDescription</a> object for each check. You must set the Amazon Web Services Region to us-east-1.</p> <note> <ul> <li> <p>You must have a Business, Enterprise On-Ramp, or Enterprise Support plan to use the Amazon Web Services Support API. </p> </li> <li> <p>If you call the Amazon Web Services Support API from an account that does not have a Business, Enterprise On-Ramp, or Enterprise Support plan, the <code>SubscriptionRequiredException</code> error message appears. For information about changing your support plan, see <a href="http://aws.amazon.com/premiumsupport/">Amazon Web Services Support</a>.</p> </li> <li> <p>The names and descriptions for Trusted Advisor checks are subject to change. We recommend that you specify the check ID in your code to uniquely identify a check.</p> </li> </ul> </note>', 'RefreshTrustedAdvisorCheck' => '<p>Refreshes the Trusted Advisor check that you specify using the check ID. You can get the check IDs by calling the <a>DescribeTrustedAdvisorChecks</a> operation.</p> <note> <p>Some checks are refreshed automatically. If you call the <code>RefreshTrustedAdvisorCheck</code> operation to refresh them, you might see the <code>InvalidParameterValue</code> error.</p> </note> <p>The response contains a <a>TrustedAdvisorCheckRefreshStatus</a> object.</p> <note> <ul> <li> <p>You must have a Business, Enterprise On-Ramp, or Enterprise Support plan to use the Amazon Web Services Support API. </p> </li> <li> <p>If you call the Amazon Web Services Support API from an account that does not have a Business, Enterprise On-Ramp, or Enterprise Support plan, the <code>SubscriptionRequiredException</code> error message appears. For information about changing your support plan, see <a href="http://aws.amazon.com/premiumsupport/">Amazon Web Services Support</a>.</p> </li> </ul> </note>', 'ResolveCase' => '<p>Resolves a support case. This operation takes a <code>caseId</code> and returns the initial and final state of the case.</p> <note> <ul> <li> <p>You must have a Business, Enterprise On-Ramp, or Enterprise Support plan to use the Amazon Web Services Support API. </p> </li> <li> <p>If you call the Amazon Web Services Support API from an account that does not have a Business, Enterprise On-Ramp, or Enterprise Support plan, the <code>SubscriptionRequiredException</code> error message appears. For information about changing your support plan, see <a href="http://aws.amazon.com/premiumsupport/">Amazon Web Services Support</a>.</p> </li> </ul> </note>', ], 'shapes' => [ 'AddAttachmentsToSetRequest' => [ 'base' => NULL, 'refs' => [], ], 'AddAttachmentsToSetResponse' => [ 'base' => '<p>The ID and expiry time of the attachment set returned by the <a>AddAttachmentsToSet</a> operation.</p>', 'refs' => [], ], 'AddCommunicationToCaseRequest' => [ 'base' => NULL, 'refs' => [], ], 'AddCommunicationToCaseResponse' => [ 'base' => '<p>The result of the <a>AddCommunicationToCase</a> operation.</p>', 'refs' => [], ], 'AfterTime' => [ 'base' => NULL, 'refs' => [ 'DescribeCasesRequest$afterTime' => '<p>The start date for a filtered date search on support case communications. Case communications are available for 12 months after creation.</p>', 'DescribeCommunicationsRequest$afterTime' => '<p>The start date for a filtered date search on support case communications. Case communications are available for 12 months after creation.</p>', ], ], 'Attachment' => [ 'base' => '<p>An attachment to a case communication. The attachment consists of the file name and the content of the file.</p>', 'refs' => [ 'Attachments$member' => NULL, 'DescribeAttachmentResponse$attachment' => '<p>This object includes the attachment content and file name.</p> <p>In the previous response syntax, the value for the <code>data</code> parameter appears as <code>blob</code>, which is represented as a base64-encoded string. The value for <code>fileName</code> is the name of the attachment, such as <code>troubleshoot-screenshot.png</code>.</p>', ], ], 'AttachmentDetails' => [ 'base' => '<p>The file name and ID of an attachment to a case communication. You can use the ID to retrieve the attachment with the <a>DescribeAttachment</a> operation.</p>', 'refs' => [ 'AttachmentSet$member' => NULL, ], ], 'AttachmentId' => [ 'base' => NULL, 'refs' => [ 'AttachmentDetails$attachmentId' => '<p>The ID of the attachment.</p>', 'DescribeAttachmentRequest$attachmentId' => '<p>The ID of the attachment to return. Attachment IDs are returned by the <a>DescribeCommunications</a> operation.</p>', ], ], 'AttachmentIdNotFound' => [ 'base' => '<p>An attachment with the specified ID could not be found.</p>', 'refs' => [], ], 'AttachmentLimitExceeded' => [ 'base' => '<p>The limit for the number of attachment sets created in a short period of time has been exceeded.</p>', 'refs' => [], ], 'AttachmentSet' => [ 'base' => NULL, 'refs' => [ 'Communication$attachmentSet' => '<p>Information about the attachments to the case communication.</p>', ], ], 'AttachmentSetExpired' => [ 'base' => '<p>The expiration time of the attachment set has passed. The set expires 1 hour after it is created.</p>', 'refs' => [], ], 'AttachmentSetId' => [ 'base' => NULL, 'refs' => [ 'AddAttachmentsToSetRequest$attachmentSetId' => '<p>The ID of the attachment set. If an <code>attachmentSetId</code> is not specified, a new attachment set is created, and the ID of the set is returned in the response. If an <code>attachmentSetId</code> is specified, the attachments are added to the specified set, if it exists.</p>', 'AddAttachmentsToSetResponse$attachmentSetId' => '<p>The ID of the attachment set. If an <code>attachmentSetId</code> was not specified, a new attachment set is created, and the ID of the set is returned in the response. If an <code>attachmentSetId</code> was specified, the attachments are added to the specified set, if it exists.</p>', 'AddCommunicationToCaseRequest$attachmentSetId' => '<p>The ID of a set of one or more attachments for the communication to add to the case. Create the set by calling <a>AddAttachmentsToSet</a> </p>', 'CreateCaseRequest$attachmentSetId' => '<p>The ID of a set of one or more attachments for the case. Create the set by using the <a>AddAttachmentsToSet</a> operation.</p>', ], ], 'AttachmentSetIdNotFound' => [ 'base' => '<p>An attachment set with the specified ID could not be found.</p>', 'refs' => [], ], 'AttachmentSetSizeLimitExceeded' => [ 'base' => '<p>A limit for the size of an attachment set has been exceeded. The limits are three attachments and 5 MB per attachment.</p>', 'refs' => [], ], 'Attachments' => [ 'base' => NULL, 'refs' => [ 'AddAttachmentsToSetRequest$attachments' => '<p>One or more attachments to add to the set. You can add up to three attachments per set. The size limit is 5 MB per attachment.</p> <p>In the <code>Attachment</code> object, use the <code>data</code> parameter to specify the contents of the attachment file. In the previous request syntax, the value for <code>data</code> appear as <code>blob</code>, which is represented as a base64-encoded string. The value for <code>fileName</code> is the name of the attachment, such as <code>troubleshoot-screenshot.png</code>.</p>', ], ], 'BeforeTime' => [ 'base' => NULL, 'refs' => [ 'DescribeCasesRequest$beforeTime' => '<p>The end date for a filtered date search on support case communications. Case communications are available for 12 months after creation.</p>', 'DescribeCommunicationsRequest$beforeTime' => '<p>The end date for a filtered date search on support case communications. Case communications are available for 12 months after creation.</p>', ], ], 'Boolean' => [ 'base' => NULL, 'refs' => [ 'TrustedAdvisorCheckSummary$hasFlaggedResources' => '<p>Specifies whether the Trusted Advisor check has flagged resources.</p>', 'TrustedAdvisorResourceDetail$isSuppressed' => '<p>Specifies whether the Amazon Web Services resource was ignored by Trusted Advisor because it was marked as suppressed by the user.</p>', ], ], 'CaseCreationLimitExceeded' => [ 'base' => '<p>The case creation limit for the account has been exceeded.</p>', 'refs' => [], ], 'CaseDetails' => [ 'base' => '<p>A JSON-formatted object that contains the metadata for a support case. It is contained in the response from a <a>DescribeCases</a> request. <b>CaseDetails</b> contains the following fields:</p> <ul> <li> <p> <b>caseId</b> - The support case ID requested or returned in the call. The case ID is an alphanumeric string formatted as shown in this example: case-<i>12345678910-2013-c4c1d2bf33c5cf47</i>.</p> </li> <li> <p> <b>categoryCode</b> - The category of problem for the support case. Corresponds to the <code>CategoryCode</code> values returned by a call to <a>DescribeServices</a>.</p> </li> <li> <p> <b>displayId</b> - The identifier for the case on pages in the Amazon Web Services Support Center.</p> </li> <li> <p> <b>language</b> - The ISO 639-1 code for the language in which Amazon Web Services provides support. Amazon Web Services Support currently supports English ("en") and Japanese ("ja"). Language parameters must be passed explicitly for operations that take them.</p> </li> <li> <p> <b>nextToken</b> - A resumption point for pagination.</p> </li> <li> <p> <b>recentCommunications</b> - One or more <a>Communication</a> objects. Fields of these objects are <code>attachments</code>, <code>body</code>, <code>caseId</code>, <code>submittedBy</code>, and <code>timeCreated</code>.</p> </li> <li> <p> <b>serviceCode</b> - The identifier for the Amazon Web Services service that corresponds to the service code defined in the call to <a>DescribeServices</a>.</p> </li> <li> <p> <b>severityCode</b> - The severity code assigned to the case. Contains one of the values returned by the call to <a>DescribeSeverityLevels</a>. The possible values are: <code>low</code>, <code>normal</code>, <code>high</code>, <code>urgent</code>, and <code>critical</code>.</p> </li> <li> <p> <b>status</b> - The status of the case in the Amazon Web Services Support Center. Valid values:</p> <ul> <li> <p> <code>opened</code> </p> </li> <li> <p> <code>pending-customer-action</code> </p> </li> <li> <p> <code>reopened</code> </p> </li> <li> <p> <code>resolved</code> </p> </li> <li> <p> <code>unassigned</code> </p> </li> <li> <p> <code>work-in-progress</code> </p> </li> </ul> </li> <li> <p> <b>subject</b> - The subject line of the case.</p> </li> <li> <p> <b>submittedBy</b> - The email address of the account that submitted the case.</p> </li> <li> <p> <b>timeCreated</b> - The time the case was created, in ISO-8601 format.</p> </li> </ul>', 'refs' => [ 'CaseList$member' => NULL, ], ], 'CaseId' => [ 'base' => NULL, 'refs' => [ 'AddCommunicationToCaseRequest$caseId' => '<p>The support case ID requested or returned in the call. The case ID is an alphanumeric string formatted as shown in this example: case-<i>12345678910-2013-c4c1d2bf33c5cf47</i> </p>', 'CaseDetails$caseId' => '<p>The support case ID requested or returned in the call. The case ID is an alphanumeric string formatted as shown in this example: case-<i>12345678910-2013-c4c1d2bf33c5cf47</i> </p>', 'CaseIdList$member' => NULL, 'Communication$caseId' => '<p>The support case ID requested or returned in the call. The case ID is an alphanumeric string formatted as shown in this example: case-<i>12345678910-2013-c4c1d2bf33c5cf47</i> </p>', 'CreateCaseResponse$caseId' => '<p>The support case ID requested or returned in the call. The case ID is an alphanumeric string in the following format: case-<i>12345678910-2013-c4c1d2bf33c5cf47</i> </p>', 'DescribeCommunicationsRequest$caseId' => '<p>The support case ID requested or returned in the call. The case ID is an alphanumeric string formatted as shown in this example: case-<i>12345678910-2013-c4c1d2bf33c5cf47</i> </p>', 'ResolveCaseRequest$caseId' => '<p>The support case ID requested or returned in the call. The case ID is an alphanumeric string formatted as shown in this example: case-<i>12345678910-2013-c4c1d2bf33c5cf47</i> </p>', ], ], 'CaseIdList' => [ 'base' => NULL, 'refs' => [ 'DescribeCasesRequest$caseIdList' => '<p>A list of ID numbers of the support cases you want returned. The maximum number of cases is 100.</p>', ], ], 'CaseIdNotFound' => [ 'base' => '<p>The requested <code>caseId</code> couldn\'t be located.</p>', 'refs' => [], ], 'CaseList' => [ 'base' => NULL, 'refs' => [ 'DescribeCasesResponse$cases' => '<p>The details for the cases that match the request.</p>', ], ], 'CaseStatus' => [ 'base' => NULL, 'refs' => [ 'ResolveCaseResponse$initialCaseStatus' => '<p>The status of the case when the <a>ResolveCase</a> request was sent.</p>', 'ResolveCaseResponse$finalCaseStatus' => '<p>The status of the case after the <a>ResolveCase</a> request was processed.</p>', ], ], 'Category' => [ 'base' => '<p>A JSON-formatted name/value pair that represents the category name and category code of the problem, selected from the <a>DescribeServices</a> response for each Amazon Web Services service.</p>', 'refs' => [ 'CategoryList$member' => NULL, ], ], 'CategoryCode' => [ 'base' => NULL, 'refs' => [ 'CaseDetails$categoryCode' => '<p>The category of problem for the support case.</p>', 'Category$code' => '<p>The category code for the support case.</p>', 'CreateCaseRequest$categoryCode' => '<p>The category of problem for the support case. You also use the <a>DescribeServices</a> operation to get the category code for a service. Each Amazon Web Services service defines its own set of category codes.</p>', ], ], 'CategoryList' => [ 'base' => NULL, 'refs' => [ 'Service$categories' => '<p>A list of categories that describe the type of support issue a case describes. Categories consist of a category name and a category code. Category names and codes are passed to Amazon Web Services Support when you call <a>CreateCase</a>.</p>', ], ], 'CategoryName' => [ 'base' => NULL, 'refs' => [ 'Category$name' => '<p>The category name for the support case.</p>', ], ], 'CcEmailAddress' => [ 'base' => NULL, 'refs' => [ 'CcEmailAddressList$member' => NULL, ], ], 'CcEmailAddressList' => [ 'base' => NULL, 'refs' => [ 'AddCommunicationToCaseRequest$ccEmailAddresses' => '<p>The email addresses in the CC line of an email to be added to the support case.</p>', 'CaseDetails$ccEmailAddresses' => '<p>The email addresses that receive copies of communication about the case.</p>', 'CreateCaseRequest$ccEmailAddresses' => '<p>A list of email addresses that Amazon Web Services Support copies on case correspondence. Amazon Web Services Support identifies the account that creates the case when you specify your Amazon Web Services credentials in an HTTP POST method or use the <a href="http://aws.amazon.com/tools/">Amazon Web Services SDKs</a>. </p>', ], ], 'Communication' => [ 'base' => '<p>A communication associated with a support case. The communication consists of the case ID, the message body, attachment information, the submitter of the communication, and the date and time of the communication.</p>', 'refs' => [ 'CommunicationList$member' => NULL, ], ], 'CommunicationBody' => [ 'base' => NULL, 'refs' => [ 'AddCommunicationToCaseRequest$communicationBody' => '<p>The body of an email communication to add to the support case.</p>', 'Communication$body' => '<p>The text of the communication between the customer and Amazon Web Services Support.</p>', 'CreateCaseRequest$communicationBody' => '<p>The communication body text that describes the issue. This text appears in the <b>Description</b> field on the Amazon Web Services Support Center <a href="https://console.aws.amazon.com/support/home#/case/create">Create Case</a> page.</p>', ], ], 'CommunicationList' => [ 'base' => NULL, 'refs' => [ 'DescribeCommunicationsResponse$communications' => '<p>The communications for the case.</p>', 'RecentCaseCommunications$communications' => '<p>The five most recent communications associated with the case.</p>', ], ], 'CreateCaseRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateCaseResponse' => [ 'base' => '<p>The support case ID returned by a successful completion of the <a>CreateCase</a> operation.</p>', 'refs' => [], ], 'Data' => [ 'base' => NULL, 'refs' => [ 'Attachment$data' => '<p>The content of the attachment file.</p>', ], ], 'DescribeAttachmentLimitExceeded' => [ 'base' => '<p>The limit for the number of <a>DescribeAttachment</a> requests in a short period of time has been exceeded.</p>', 'refs' => [], ], 'DescribeAttachmentRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAttachmentResponse' => [ 'base' => '<p>The content and file name of the attachment returned by the <a>DescribeAttachment</a> operation.</p>', 'refs' => [], ], 'DescribeCasesRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeCasesResponse' => [ 'base' => '<p>Returns an array of <a href="https://docs.aws.amazon.com/awssupport/latest/APIReference/API_CaseDetails.html">CaseDetails</a> objects and a <code>nextToken</code> that defines a point for pagination in the result set.</p>', 'refs' => [], ], 'DescribeCommunicationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeCommunicationsResponse' => [ 'base' => '<p>The communications returned by the <a>DescribeCommunications</a> operation.</p>', 'refs' => [], ], 'DescribeServicesRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeServicesResponse' => [ 'base' => '<p>The list of Amazon Web Services services returned by the <a>DescribeServices</a> operation.</p>', 'refs' => [], ], 'DescribeSeverityLevelsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeSeverityLevelsResponse' => [ 'base' => '<p>The list of severity levels returned by the <a>DescribeSeverityLevels</a> operation.</p>', 'refs' => [], ], 'DescribeTrustedAdvisorCheckRefreshStatusesRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeTrustedAdvisorCheckRefreshStatusesResponse' => [ 'base' => '<p>The statuses of the Trusted Advisor checks returned by the <a>DescribeTrustedAdvisorCheckRefreshStatuses</a> operation.</p>', 'refs' => [], ], 'DescribeTrustedAdvisorCheckResultRequest' => [ 'base' => '<p/>', 'refs' => [], ], 'DescribeTrustedAdvisorCheckResultResponse' => [ 'base' => '<p>The result of the Trusted Advisor check returned by the <a>DescribeTrustedAdvisorCheckResult</a> operation.</p>', 'refs' => [], ], 'DescribeTrustedAdvisorCheckSummariesRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeTrustedAdvisorCheckSummariesResponse' => [ 'base' => '<p>The summaries of the Trusted Advisor checks returned by the <a>DescribeTrustedAdvisorCheckSummaries</a> operation.</p>', 'refs' => [], ], 'DescribeTrustedAdvisorChecksRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeTrustedAdvisorChecksResponse' => [ 'base' => '<p>Information about the Trusted Advisor checks returned by the <a>DescribeTrustedAdvisorChecks</a> operation.</p>', 'refs' => [], ], 'DisplayId' => [ 'base' => NULL, 'refs' => [ 'CaseDetails$displayId' => '<p>The ID displayed for the case in the Amazon Web Services Support Center. This is a numeric string.</p>', 'DescribeCasesRequest$displayId' => '<p>The ID displayed for a case in the Amazon Web Services Support Center user interface.</p>', ], ], 'Double' => [ 'base' => NULL, 'refs' => [ 'TrustedAdvisorCostOptimizingSummary$estimatedMonthlySavings' => '<p>The estimated monthly savings that might be realized if the recommended operations are taken.</p>', 'TrustedAdvisorCostOptimizingSummary$estimatedPercentMonthlySavings' => '<p>The estimated percentage of savings that might be realized if the recommended operations are taken.</p>', ], ], 'ErrorMessage' => [ 'base' => NULL, 'refs' => [ 'AttachmentIdNotFound$message' => '<p>An attachment with the specified ID could not be found.</p>', 'AttachmentLimitExceeded$message' => '<p>The limit for the number of attachment sets created in a short period of time has been exceeded.</p>', 'AttachmentSetExpired$message' => '<p>The expiration time of the attachment set has passed. The set expires one hour after it is created.</p>', 'AttachmentSetIdNotFound$message' => '<p>An attachment set with the specified ID could not be found.</p>', 'AttachmentSetSizeLimitExceeded$message' => '<p>A limit for the size of an attachment set has been exceeded. The limits are three attachments and 5 MB per attachment.</p>', 'CaseCreationLimitExceeded$message' => '<p>An error message that indicates that you have exceeded the number of cases you can have open.</p>', 'CaseIdNotFound$message' => '<p>The requested <code>CaseId</code> could not be located.</p>', 'DescribeAttachmentLimitExceeded$message' => '<p>The limit for the number of <a>DescribeAttachment</a> requests in a short period of time has been exceeded.</p>', 'InternalServerError$message' => '<p>An internal server error occurred.</p>', ], ], 'ExpiryTime' => [ 'base' => NULL, 'refs' => [ 'AddAttachmentsToSetResponse$expiryTime' => '<p>The time and date when the attachment set expires.</p>', ], ], 'FileName' => [ 'base' => NULL, 'refs' => [ 'Attachment$fileName' => '<p>The name of the attachment file.</p>', 'AttachmentDetails$fileName' => '<p>The file name of the attachment.</p>', ], ], 'IncludeCommunications' => [ 'base' => NULL, 'refs' => [ 'DescribeCasesRequest$includeCommunications' => '<p>Specifies whether to include communications in the <code>DescribeCases</code> response. By default, communications are included.</p>', ], ], 'IncludeResolvedCases' => [ 'base' => NULL, 'refs' => [ 'DescribeCasesRequest$includeResolvedCases' => '<p>Specifies whether to include resolved support cases in the <code>DescribeCases</code> response. By default, resolved cases aren\'t included.</p>', ], ], 'InternalServerError' => [ 'base' => '<p>An internal server error occurred.</p>', 'refs' => [], ], 'IssueType' => [ 'base' => NULL, 'refs' => [ 'CreateCaseRequest$issueType' => '<p>The type of issue for the case. You can specify <code>customer-service</code> or <code>technical</code>. If you don\'t specify a value, the default is <code>technical</code>.</p>', ], ], 'Language' => [ 'base' => NULL, 'refs' => [ 'CaseDetails$language' => '<p>The ISO 639-1 code for the language in which Amazon Web Services provides support. Amazon Web Services Support currently supports English ("en") and Japanese ("ja"). Language parameters must be passed explicitly for operations that take them.</p>', 'CreateCaseRequest$language' => '<p>The language in which Amazon Web Services Support handles the case. You must specify the ISO 639-1 code for the <code>language</code> parameter if you want support in that language. Currently, English ("en") and Japanese ("ja") are supported.</p>', 'DescribeCasesRequest$language' => '<p>The ISO 639-1 code for the language in which Amazon Web Services provides support. Amazon Web Services Support currently supports English ("en") and Japanese ("ja"). Language parameters must be passed explicitly for operations that take them.</p>', 'DescribeServicesRequest$language' => '<p>The ISO 639-1 code for the language in which Amazon Web Services provides support. Amazon Web Services Support currently supports English ("en") and Japanese ("ja"). Language parameters must be passed explicitly for operations that take them.</p>', 'DescribeSeverityLevelsRequest$language' => '<p>The ISO 639-1 code for the language in which Amazon Web Services provides support. Amazon Web Services Support currently supports English ("en") and Japanese ("ja"). Language parameters must be passed explicitly for operations that take them.</p>', ], ], 'Long' => [ 'base' => NULL, 'refs' => [ 'TrustedAdvisorCheckRefreshStatus$millisUntilNextRefreshable' => '<p>The amount of time, in milliseconds, until the Trusted Advisor check is eligible for refresh.</p>', 'TrustedAdvisorResourcesSummary$resourcesProcessed' => '<p>The number of Amazon Web Services resources that were analyzed by the Trusted Advisor check.</p>', 'TrustedAdvisorResourcesSummary$resourcesFlagged' => '<p>The number of Amazon Web Services resources that were flagged (listed) by the Trusted Advisor check.</p>', 'TrustedAdvisorResourcesSummary$resourcesIgnored' => '<p>The number of Amazon Web Services resources ignored by Trusted Advisor because information was unavailable.</p>', 'TrustedAdvisorResourcesSummary$resourcesSuppressed' => '<p>The number of Amazon Web Services resources ignored by Trusted Advisor because they were marked as suppressed by the user.</p>', ], ], 'MaxResults' => [ 'base' => NULL, 'refs' => [ 'DescribeCasesRequest$maxResults' => '<p>The maximum number of results to return before paginating.</p>', 'DescribeCommunicationsRequest$maxResults' => '<p>The maximum number of results to return before paginating.</p>', ], ], 'NextToken' => [ 'base' => NULL, 'refs' => [ 'DescribeCasesRequest$nextToken' => '<p>A resumption point for pagination.</p>', 'DescribeCasesResponse$nextToken' => '<p>A resumption point for pagination.</p>', 'DescribeCommunicationsRequest$nextToken' => '<p>A resumption point for pagination.</p>', 'DescribeCommunicationsResponse$nextToken' => '<p>A resumption point for pagination.</p>', 'RecentCaseCommunications$nextToken' => '<p>A resumption point for pagination.</p>', ], ], 'RecentCaseCommunications' => [ 'base' => '<p>The five most recent communications associated with the case.</p>', 'refs' => [ 'CaseDetails$recentCommunications' => '<p>The five most recent communications between you and Amazon Web Services Support Center, including the IDs of any attachments to the communications. Also includes a <code>nextToken</code> that you can use to retrieve earlier communications.</p>', ], ], 'RefreshTrustedAdvisorCheckRequest' => [ 'base' => '<p/>', 'refs' => [], ], 'RefreshTrustedAdvisorCheckResponse' => [ 'base' => '<p>The current refresh status of a Trusted Advisor check.</p>', 'refs' => [], ], 'ResolveCaseRequest' => [ 'base' => NULL, 'refs' => [], ], 'ResolveCaseResponse' => [ 'base' => '<p>The status of the case returned by the <a>ResolveCase</a> operation.</p>', 'refs' => [], ], 'Result' => [ 'base' => NULL, 'refs' => [ 'AddCommunicationToCaseResponse$result' => '<p>True if <a>AddCommunicationToCase</a> succeeds. Otherwise, returns an error.</p>', ], ], 'Service' => [ 'base' => '<p>Information about an Amazon Web Services service returned by the <a>DescribeServices</a> operation.</p>', 'refs' => [ 'ServiceList$member' => NULL, ], ], 'ServiceCode' => [ 'base' => NULL, 'refs' => [ 'CaseDetails$serviceCode' => '<p>The code for the Amazon Web Services service. You can get a list of codes and the corresponding service names by calling <a>DescribeServices</a>.</p>', 'CreateCaseRequest$serviceCode' => '<p>The code for the Amazon Web Services service. You can use the <a>DescribeServices</a> operation to get the possible <code>serviceCode</code> values.</p>', 'Service$code' => '<p>The code for an Amazon Web Services service returned by the <a>DescribeServices</a> response. The <code>name</code> element contains the corresponding friendly name.</p>', 'ServiceCodeList$member' => NULL, ], ], 'ServiceCodeList' => [ 'base' => NULL, 'refs' => [ 'DescribeServicesRequest$serviceCodeList' => '<p>A JSON-formatted list of service codes available for Amazon Web Services services.</p>', ], ], 'ServiceList' => [ 'base' => NULL, 'refs' => [ 'DescribeServicesResponse$services' => '<p>A JSON-formatted list of Amazon Web Services services.</p>', ], ], 'ServiceName' => [ 'base' => NULL, 'refs' => [ 'Service$name' => '<p>The friendly name for an Amazon Web Services service. The <code>code</code> element contains the corresponding code.</p>', ], ], 'SeverityCode' => [ 'base' => NULL, 'refs' => [ 'CaseDetails$severityCode' => '<p>The code for the severity level returned by the call to <a>DescribeSeverityLevels</a>.</p>', 'CreateCaseRequest$severityCode' => '<p>A value that indicates the urgency of the case. This value determines the response time according to your service level agreement with Amazon Web Services Support. You can use the <a>DescribeSeverityLevels</a> operation to get the possible values for <code>severityCode</code>. </p> <p>For more information, see <a>SeverityLevel</a> and <a href="https://docs.aws.amazon.com/awssupport/latest/user/getting-started.html#choosing-severity">Choosing a Severity</a> in the <i>Amazon Web Services Support User Guide</i>.</p> <note> <p>The availability of severity levels depends on the support plan for the Amazon Web Services account.</p> </note>', ], ], 'SeverityLevel' => [ 'base' => '<p>A code and name pair that represents the severity level of a support case. The available values depend on the support plan for the account. For more information, see <a href="https://docs.aws.amazon.com/awssupport/latest/user/case-management.html#choosing-severity">Choosing a severity</a> in the <i>Amazon Web Services Support User Guide</i>.</p>', 'refs' => [ 'SeverityLevelsList$member' => NULL, ], ], 'SeverityLevelCode' => [ 'base' => NULL, 'refs' => [ 'SeverityLevel$code' => '<p>The code for case severity level.</p> <p>Valid values: <code>low</code> | <code>normal</code> | <code>high</code> | <code>urgent</code> | <code>critical</code> </p>', ], ], 'SeverityLevelName' => [ 'base' => NULL, 'refs' => [ 'SeverityLevel$name' => '<p>The name of the severity level that corresponds to the severity level code.</p> <note> <p>The values returned by the API are different from the values that appear in the Amazon Web Services Support Center. For example, the API uses the code <code>low</code>, but the name appears as General guidance in Support Center. </p> <p>The following are the API code names and how they appear in the console:</p> <ul> <li> <p> <code>low</code> - General guidance</p> </li> <li> <p> <code>normal</code> - System impaired</p> </li> <li> <p> <code>high</code> - Production system impaired</p> </li> <li> <p> <code>urgent</code> - Production system down</p> </li> <li> <p> <code>critical</code> - Business-critical system down</p> </li> </ul> </note> <p>For more information, see <a href="https://docs.aws.amazon.com/awssupport/latest/user/case-management.html#choosing-severity">Choosing a severity</a> in the <i>Amazon Web Services Support User Guide</i>.</p>', ], ], 'SeverityLevelsList' => [ 'base' => NULL, 'refs' => [ 'DescribeSeverityLevelsResponse$severityLevels' => '<p>The available severity levels for the support case. Available severity levels are defined by your service level agreement with Amazon Web Services.</p>', ], ], 'Status' => [ 'base' => NULL, 'refs' => [ 'CaseDetails$status' => '<p>The status of the case.</p> <p>Valid values:</p> <ul> <li> <p> <code>opened</code> </p> </li> <li> <p> <code>pending-customer-action</code> </p> </li> <li> <p> <code>reopened</code> </p> </li> <li> <p> <code>resolved</code> </p> </li> <li> <p> <code>unassigned</code> </p> </li> <li> <p> <code>work-in-progress</code> </p> </li> </ul>', ], ], 'String' => [ 'base' => NULL, 'refs' => [ 'DescribeTrustedAdvisorCheckResultRequest$checkId' => '<p>The unique identifier for the Trusted Advisor check.</p>', 'DescribeTrustedAdvisorCheckResultRequest$language' => '<p>The ISO 639-1 code for the language in which Amazon Web Services provides support. Amazon Web Services Support currently supports English ("en") and Japanese ("ja"). Language parameters must be passed explicitly for operations that take them.</p>', 'DescribeTrustedAdvisorChecksRequest$language' => '<p>The ISO 639-1 code for the language in which Amazon Web Services provides support. Amazon Web Services Support currently supports English ("en") and Japanese ("ja"). Language parameters must be passed explicitly for operations that take them.</p>', 'RefreshTrustedAdvisorCheckRequest$checkId' => '<p>The unique identifier for the Trusted Advisor check to refresh.</p> <note> <p>Specifying the check ID of a check that is automatically refreshed causes an <code>InvalidParameterValue</code> error.</p> </note>', 'StringList$member' => NULL, 'TrustedAdvisorCheckDescription$id' => '<p>The unique identifier for the Trusted Advisor check.</p>', 'TrustedAdvisorCheckDescription$name' => '<p>The display name for the Trusted Advisor check.</p>', 'TrustedAdvisorCheckDescription$description' => '<p>The description of the Trusted Advisor check, which includes the alert criteria and recommended operations (contains HTML markup).</p>', 'TrustedAdvisorCheckDescription$category' => '<p>The category of the Trusted Advisor check.</p>', 'TrustedAdvisorCheckRefreshStatus$checkId' => '<p>The unique identifier for the Trusted Advisor check.</p>', 'TrustedAdvisorCheckRefreshStatus$status' => '<p>The status of the Trusted Advisor check for which a refresh has been requested: </p> <ul> <li> <p> <code>none</code> - The check is not refreshed or the non-success status exceeds the timeout</p> </li> <li> <p> <code>enqueued</code> - The check refresh requests has entered the refresh queue</p> </li> <li> <p> <code>processing</code> - The check refresh request is picked up by the rule processing engine</p> </li> <li> <p> <code>success</code> - The check is successfully refreshed</p> </li> <li> <p> <code>abandoned</code> - The check refresh has failed</p> </li> </ul>', 'TrustedAdvisorCheckResult$checkId' => '<p>The unique identifier for the Trusted Advisor check.</p>', 'TrustedAdvisorCheckResult$timestamp' => '<p>The time of the last refresh of the check.</p>', 'TrustedAdvisorCheckResult$status' => '<p>The alert status of the check: "ok" (green), "warning" (yellow), "error" (red), or "not_available".</p>', 'TrustedAdvisorCheckSummary$checkId' => '<p>The unique identifier for the Trusted Advisor check.</p>', 'TrustedAdvisorCheckSummary$timestamp' => '<p>The time of the last refresh of the check.</p>', 'TrustedAdvisorCheckSummary$status' => '<p>The alert status of the check: "ok" (green), "warning" (yellow), "error" (red), or "not_available".</p>', 'TrustedAdvisorResourceDetail$status' => '<p>The status code for the resource identified in the Trusted Advisor check.</p>', 'TrustedAdvisorResourceDetail$region' => '<p>The Amazon Web Services Region in which the identified resource is located.</p>', 'TrustedAdvisorResourceDetail$resourceId' => '<p>The unique identifier for the identified resource.</p>', ], ], 'StringList' => [ 'base' => NULL, 'refs' => [ 'DescribeTrustedAdvisorCheckRefreshStatusesRequest$checkIds' => '<p>The IDs of the Trusted Advisor checks to get the status.</p> <note> <p>If you specify the check ID of a check that is automatically refreshed, you might see an <code>InvalidParameterValue</code> error.</p> </note>', 'DescribeTrustedAdvisorCheckSummariesRequest$checkIds' => '<p>The IDs of the Trusted Advisor checks.</p>', 'TrustedAdvisorCheckDescription$metadata' => '<p>The column headings for the data returned by the Trusted Advisor check. The order of the headings corresponds to the order of the data in the <b>Metadata</b> element of the <a>TrustedAdvisorResourceDetail</a> for the check. <b>Metadata</b> contains all the data that is shown in the Excel download, even in those cases where the UI shows just summary data. </p>', 'TrustedAdvisorResourceDetail$metadata' => '<p>Additional information about the identified resource. The exact metadata and its order can be obtained by inspecting the <a>TrustedAdvisorCheckDescription</a> object returned by the call to <a>DescribeTrustedAdvisorChecks</a>. <b>Metadata</b> contains all the data that is shown in the Excel download, even in those cases where the UI shows just summary data.</p>', ], ], 'Subject' => [ 'base' => NULL, 'refs' => [ 'CaseDetails$subject' => '<p>The subject line for the case in the Amazon Web Services Support Center.</p>', 'CreateCaseRequest$subject' => '<p>The title of the support case. The title appears in the <b>Subject</b> field on the Amazon Web Services Support Center <a href="https://console.aws.amazon.com/support/home#/case/create">Create Case</a> page.</p>', ], ], 'SubmittedBy' => [ 'base' => NULL, 'refs' => [ 'CaseDetails$submittedBy' => '<p>The email address of the account that submitted the case.</p>', 'Communication$submittedBy' => '<p>The identity of the account that submitted, or responded to, the support case. Customer entries include the role or IAM user as well as the email address. For example, "AdminRole (Role) &lt;janedoe@example.com&gt;. Entries from the Amazon Web Services Support team display "Amazon Web Services," and don\'t show an email address. </p>', ], ], 'TimeCreated' => [ 'base' => NULL, 'refs' => [ 'CaseDetails$timeCreated' => '<p>The time that the case was created in the Amazon Web Services Support Center.</p>', 'Communication$timeCreated' => '<p>The time the communication was created.</p>', ], ], 'TrustedAdvisorCategorySpecificSummary' => [ 'base' => '<p>The container for summary information that relates to the category of the Trusted Advisor check.</p>', 'refs' => [ 'TrustedAdvisorCheckResult$categorySpecificSummary' => '<p>Summary information that relates to the category of the check. Cost Optimizing is the only category that is currently supported.</p>', 'TrustedAdvisorCheckSummary$categorySpecificSummary' => '<p>Summary information that relates to the category of the check. Cost Optimizing is the only category that is currently supported.</p>', ], ], 'TrustedAdvisorCheckDescription' => [ 'base' => '<p>The description and metadata for a Trusted Advisor check.</p>', 'refs' => [ 'TrustedAdvisorCheckList$member' => NULL, ], ], 'TrustedAdvisorCheckList' => [ 'base' => NULL, 'refs' => [ 'DescribeTrustedAdvisorChecksResponse$checks' => '<p>Information about all available Trusted Advisor checks.</p>', ], ], 'TrustedAdvisorCheckRefreshStatus' => [ 'base' => '<p>The refresh status of a Trusted Advisor check.</p>', 'refs' => [ 'RefreshTrustedAdvisorCheckResponse$status' => '<p>The current refresh status for a check, including the amount of time until the check is eligible for refresh.</p>', 'TrustedAdvisorCheckRefreshStatusList$member' => NULL, ], ], 'TrustedAdvisorCheckRefreshStatusList' => [ 'base' => NULL, 'refs' => [ 'DescribeTrustedAdvisorCheckRefreshStatusesResponse$statuses' => '<p>The refresh status of the specified Trusted Advisor checks.</p>', ], ], 'TrustedAdvisorCheckResult' => [ 'base' => '<p>The results of a Trusted Advisor check returned by <a>DescribeTrustedAdvisorCheckResult</a>.</p>', 'refs' => [ 'DescribeTrustedAdvisorCheckResultResponse$result' => '<p>The detailed results of the Trusted Advisor check.</p>', ], ], 'TrustedAdvisorCheckSummary' => [ 'base' => '<p>A summary of a Trusted Advisor check result, including the alert status, last refresh, and number of resources examined.</p>', 'refs' => [ 'TrustedAdvisorCheckSummaryList$member' => NULL, ], ], 'TrustedAdvisorCheckSummaryList' => [ 'base' => NULL, 'refs' => [ 'DescribeTrustedAdvisorCheckSummariesResponse$summaries' => '<p>The summary information for the requested Trusted Advisor checks.</p>', ], ], 'TrustedAdvisorCostOptimizingSummary' => [ 'base' => '<p>The estimated cost savings that might be realized if the recommended operations are taken.</p>', 'refs' => [ 'TrustedAdvisorCategorySpecificSummary$costOptimizing' => '<p>The summary information about cost savings for a Trusted Advisor check that is in the Cost Optimizing category.</p>', ], ], 'TrustedAdvisorResourceDetail' => [ 'base' => '<p>Contains information about a resource identified by a Trusted Advisor check.</p>', 'refs' => [ 'TrustedAdvisorResourceDetailList$member' => NULL, ], ], 'TrustedAdvisorResourceDetailList' => [ 'base' => NULL, 'refs' => [ 'TrustedAdvisorCheckResult$flaggedResources' => '<p>The details about each resource listed in the check result.</p>', ], ], 'TrustedAdvisorResourcesSummary' => [ 'base' => '<p>Details about Amazon Web Services resources that were analyzed in a call to Trusted Advisor <a>DescribeTrustedAdvisorCheckSummaries</a>.</p>', 'refs' => [ 'TrustedAdvisorCheckResult$resourcesSummary' => NULL, 'TrustedAdvisorCheckSummary$resourcesSummary' => NULL, ], ], ],];
