<?php
// This file was auto-generated from sdk-root/src/data/sms/2016-10-24/docs-2.json
return [ 'version' => '2.0', 'service' => '<important> <p> <b>Product update</b> </p> <p>We recommend <a href="http://aws.amazon.com/application-migration-service">Amazon Web Services Application Migration Service</a> (Amazon Web Services MGN) as the primary migration service for lift-and-shift migrations. If Amazon Web Services MGN is unavailable in a specific Amazon Web Services Region, you can use the Server Migration Service APIs through March 2023.</p> </important> <p>Server Migration Service (Server Migration Service) makes it easier and faster for you to migrate your on-premises workloads to Amazon Web Services. To learn more about Server Migration Service, see the following resources:</p> <ul> <li> <p> <a href="http://aws.amazon.com/server-migration-service/">Server Migration Service product page</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/server-migration-service/latest/userguide/">Server Migration Service User Guide</a> </p> </li> </ul>', 'operations' => [ 'CreateApp' => '<p>Creates an application. An application consists of one or more server groups. Each server group contain one or more servers.</p>', 'CreateReplicationJob' => '<p>Creates a replication job. The replication job schedules periodic replication runs to replicate your server to Amazon Web Services. Each replication run creates an Amazon Machine Image (AMI).</p>', 'DeleteApp' => '<p>Deletes the specified application. Optionally deletes the launched stack associated with the application and all Server Migration Service replication jobs for servers in the application.</p>', 'DeleteAppLaunchConfiguration' => '<p>Deletes the launch configuration for the specified application.</p>', 'DeleteAppReplicationConfiguration' => '<p>Deletes the replication configuration for the specified application.</p>', 'DeleteAppValidationConfiguration' => '<p>Deletes the validation configuration for the specified application.</p>', 'DeleteReplicationJob' => '<p>Deletes the specified replication job.</p> <p>After you delete a replication job, there are no further replication runs. Amazon Web Services deletes the contents of the Amazon S3 bucket used to store Server Migration Service artifacts. The AMIs created by the replication runs are not deleted.</p>', 'DeleteServerCatalog' => '<p>Deletes all servers from your server catalog.</p>', 'DisassociateConnector' => '<p>Disassociates the specified connector from Server Migration Service.</p> <p>After you disassociate a connector, it is no longer available to support replication jobs.</p>', 'GenerateChangeSet' => '<p>Generates a target change set for a currently launched stack and writes it to an Amazon S3 object in the customer’s Amazon S3 bucket.</p>', 'GenerateTemplate' => '<p>Generates an CloudFormation template based on the current launch configuration and writes it to an Amazon S3 object in the customer’s Amazon S3 bucket.</p>', 'GetApp' => '<p>Retrieve information about the specified application.</p>', 'GetAppLaunchConfiguration' => '<p>Retrieves the application launch configuration associated with the specified application.</p>', 'GetAppReplicationConfiguration' => '<p>Retrieves the application replication configuration associated with the specified application.</p>', 'GetAppValidationConfiguration' => '<p>Retrieves information about a configuration for validating an application.</p>', 'GetAppValidationOutput' => '<p>Retrieves output from validating an application.</p>', 'GetConnectors' => '<p>Describes the connectors registered with the Server Migration Service.</p>', 'GetReplicationJobs' => '<p>Describes the specified replication job or all of your replication jobs.</p>', 'GetReplicationRuns' => '<p>Describes the replication runs for the specified replication job.</p>', 'GetServers' => '<p>Describes the servers in your server catalog.</p> <p>Before you can describe your servers, you must import them using <a>ImportServerCatalog</a>.</p>', 'ImportAppCatalog' => '<p>Allows application import from Migration Hub.</p>', 'ImportServerCatalog' => '<p>Gathers a complete list of on-premises servers. Connectors must be installed and monitoring all servers to import.</p> <p>This call returns immediately, but might take additional time to retrieve all the servers.</p>', 'LaunchApp' => '<p>Launches the specified application as a stack in CloudFormation.</p>', 'ListApps' => '<p>Retrieves summaries for all applications.</p>', 'NotifyAppValidationOutput' => '<p>Provides information to Server Migration Service about whether application validation is successful.</p>', 'PutAppLaunchConfiguration' => '<p>Creates or updates the launch configuration for the specified application.</p>', 'PutAppReplicationConfiguration' => '<p>Creates or updates the replication configuration for the specified application.</p>', 'PutAppValidationConfiguration' => '<p>Creates or updates a validation configuration for the specified application.</p>', 'StartAppReplication' => '<p>Starts replicating the specified application by creating replication jobs for each server in the application.</p>', 'StartOnDemandAppReplication' => '<p>Starts an on-demand replication run for the specified application.</p>', 'StartOnDemandReplicationRun' => '<p>Starts an on-demand replication run for the specified replication job. This replication run starts immediately. This replication run is in addition to the ones already scheduled.</p> <p>There is a limit on the number of on-demand replications runs that you can request in a 24-hour period.</p>', 'StopAppReplication' => '<p>Stops replicating the specified application by deleting the replication job for each server in the application.</p>', 'TerminateApp' => '<p>Terminates the stack for the specified application.</p>', 'UpdateApp' => '<p>Updates the specified application.</p>', 'UpdateReplicationJob' => '<p>Updates the specified settings for the specified replication job.</p>', ], 'shapes' => [ 'AmiId' => [ 'base' => NULL, 'refs' => [ 'ReplicationJob$latestAmiId' => '<p>The ID of the latest Amazon Machine Image (AMI).</p>', 'ReplicationRun$amiId' => '<p>The ID of the Amazon Machine Image (AMI) from the replication run.</p>', ], ], 'AppDescription' => [ 'base' => NULL, 'refs' => [ 'AppSummary$description' => '<p>The description of the application.</p>', 'CreateAppRequest$description' => '<p>The description of the new application</p>', 'UpdateAppRequest$description' => '<p>The new description of the application.</p>', ], ], 'AppId' => [ 'base' => NULL, 'refs' => [ 'AppIds$member' => NULL, 'AppSummary$appId' => '<p>The unique ID of the application.</p>', 'DeleteAppLaunchConfigurationRequest$appId' => '<p>The ID of the application.</p>', 'DeleteAppReplicationConfigurationRequest$appId' => '<p>The ID of the application.</p>', 'DeleteAppRequest$appId' => '<p>The ID of the application.</p>', 'GenerateChangeSetRequest$appId' => '<p>The ID of the application associated with the change set.</p>', 'GenerateTemplateRequest$appId' => '<p>The ID of the application associated with the CloudFormation template.</p>', 'GetAppLaunchConfigurationRequest$appId' => '<p>The ID of the application.</p>', 'GetAppLaunchConfigurationResponse$appId' => '<p>The ID of the application.</p>', 'GetAppReplicationConfigurationRequest$appId' => '<p>The ID of the application.</p>', 'GetAppRequest$appId' => '<p>The ID of the application.</p>', 'LaunchAppRequest$appId' => '<p>The ID of the application.</p>', 'PutAppLaunchConfigurationRequest$appId' => '<p>The ID of the application.</p>', 'PutAppReplicationConfigurationRequest$appId' => '<p>The ID of the application.</p>', 'StartAppReplicationRequest$appId' => '<p>The ID of the application.</p>', 'StartOnDemandAppReplicationRequest$appId' => '<p>The ID of the application.</p>', 'StopAppReplicationRequest$appId' => '<p>The ID of the application.</p>', 'TerminateAppRequest$appId' => '<p>The ID of the application.</p>', 'UpdateAppRequest$appId' => '<p>The ID of the application.</p>', ], ], 'AppIdWithValidation' => [ 'base' => NULL, 'refs' => [ 'DeleteAppValidationConfigurationRequest$appId' => '<p>The ID of the application.</p>', 'GetAppValidationConfigurationRequest$appId' => '<p>The ID of the application.</p>', 'GetAppValidationOutputRequest$appId' => '<p>The ID of the application.</p>', 'NotifyAppValidationOutputRequest$appId' => '<p>The ID of the application.</p>', 'PutAppValidationConfigurationRequest$appId' => '<p>The ID of the application.</p>', ], ], 'AppIds' => [ 'base' => NULL, 'refs' => [ 'ListAppsRequest$appIds' => '<p>The unique application IDs.</p>', ], ], 'AppLaunchConfigurationStatus' => [ 'base' => NULL, 'refs' => [ 'AppSummary$launchConfigurationStatus' => '<p>Status of the launch configuration.</p>', ], ], 'AppLaunchStatus' => [ 'base' => NULL, 'refs' => [ 'AppSummary$launchStatus' => '<p>The launch status of the application.</p>', ], ], 'AppLaunchStatusMessage' => [ 'base' => NULL, 'refs' => [ 'AppSummary$launchStatusMessage' => '<p>A message related to the launch status of the application.</p>', ], ], 'AppName' => [ 'base' => NULL, 'refs' => [ 'AppSummary$name' => '<p>The name of the application.</p>', 'CreateAppRequest$name' => '<p>The name of the new application.</p>', 'UpdateAppRequest$name' => '<p>The new name of the application.</p>', ], ], 'AppReplicationConfigurationStatus' => [ 'base' => NULL, 'refs' => [ 'AppSummary$replicationConfigurationStatus' => '<p>Status of the replication configuration.</p>', ], ], 'AppReplicationStatus' => [ 'base' => NULL, 'refs' => [ 'AppSummary$replicationStatus' => '<p>The replication status of the application.</p>', ], ], 'AppReplicationStatusMessage' => [ 'base' => NULL, 'refs' => [ 'AppSummary$replicationStatusMessage' => '<p>A message related to the replication status of the application.</p>', ], ], 'AppStatus' => [ 'base' => NULL, 'refs' => [ 'AppSummary$status' => '<p>Status of the application.</p>', ], ], 'AppStatusMessage' => [ 'base' => NULL, 'refs' => [ 'AppSummary$statusMessage' => '<p>A message related to the status of the application</p>', ], ], 'AppSummary' => [ 'base' => '<p>Information about the application.</p>', 'refs' => [ 'Apps$member' => NULL, 'CreateAppResponse$appSummary' => '<p>A summary description of the application.</p>', 'GetAppResponse$appSummary' => '<p>Information about the application.</p>', 'UpdateAppResponse$appSummary' => '<p>A summary description of the application.</p>', ], ], 'AppValidationConfiguration' => [ 'base' => '<p>Configuration for validating an application.</p>', 'refs' => [ 'AppValidationConfigurations$member' => NULL, ], ], 'AppValidationConfigurations' => [ 'base' => NULL, 'refs' => [ 'GetAppValidationConfigurationResponse$appValidationConfigurations' => '<p>The configuration for application validation.</p>', 'PutAppValidationConfigurationRequest$appValidationConfigurations' => '<p>The configuration for application validation.</p>', ], ], 'AppValidationOutput' => [ 'base' => '<p>Output from validating an application.</p>', 'refs' => [ 'ValidationOutput$appValidationOutput' => '<p>The output from validating an application.</p>', ], ], 'AppValidationStrategy' => [ 'base' => NULL, 'refs' => [ 'AppValidationConfiguration$appValidationStrategy' => '<p>The validation strategy.</p>', ], ], 'Apps' => [ 'base' => NULL, 'refs' => [ 'ListAppsResponse$apps' => '<p>The application summaries.</p>', ], ], 'AssociatePublicIpAddress' => [ 'base' => NULL, 'refs' => [ 'ServerLaunchConfiguration$associatePublicIpAddress' => '<p>Indicates whether a publicly accessible IP address is created when launching the server.</p>', ], ], 'AutoLaunch' => [ 'base' => NULL, 'refs' => [ 'GetAppLaunchConfigurationResponse$autoLaunch' => '<p>Indicates whether the application is configured to launch automatically after replication is complete.</p>', 'PutAppLaunchConfigurationRequest$autoLaunch' => '<p>Indicates whether the application is configured to launch automatically after replication is complete.</p>', ], ], 'BucketName' => [ 'base' => NULL, 'refs' => [ 'SSMValidationParameters$outputS3BucketName' => '<p>The name of the S3 bucket for output.</p>', ], ], 'ClientToken' => [ 'base' => NULL, 'refs' => [ 'CreateAppRequest$clientToken' => '<p>A unique, case-sensitive identifier that you provide to ensure the idempotency of application creation.</p>', ], ], 'Command' => [ 'base' => NULL, 'refs' => [ 'SSMValidationParameters$command' => '<p>The command to run the validation script.</p>', ], ], 'Connector' => [ 'base' => '<p>Represents a connector.</p>', 'refs' => [ 'ConnectorList$member' => NULL, ], ], 'ConnectorCapability' => [ 'base' => NULL, 'refs' => [ 'ConnectorCapabilityList$member' => NULL, ], ], 'ConnectorCapabilityList' => [ 'base' => NULL, 'refs' => [ 'Connector$capabilityList' => '<p>The capabilities of the connector.</p>', ], ], 'ConnectorId' => [ 'base' => NULL, 'refs' => [ 'Connector$connectorId' => '<p>The ID of the connector.</p>', 'DisassociateConnectorRequest$connectorId' => '<p>The ID of the connector.</p>', ], ], 'ConnectorList' => [ 'base' => NULL, 'refs' => [ 'GetConnectorsResponse$connectorList' => '<p>Information about the registered connectors.</p>', ], ], 'ConnectorStatus' => [ 'base' => NULL, 'refs' => [ 'Connector$status' => '<p>The status of the connector.</p>', ], ], 'ConnectorVersion' => [ 'base' => NULL, 'refs' => [ 'Connector$version' => '<p>The connector version.</p>', ], ], 'CreateAppRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateAppResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateReplicationJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateReplicationJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteAppLaunchConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteAppLaunchConfigurationResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteAppReplicationConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteAppReplicationConfigurationResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteAppRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteAppResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteAppValidationConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteAppValidationConfigurationResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteReplicationJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteReplicationJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteServerCatalogRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteServerCatalogResponse' => [ 'base' => NULL, 'refs' => [], ], 'Description' => [ 'base' => NULL, 'refs' => [ 'CreateReplicationJobRequest$description' => '<p>The description of the replication job.</p>', 'ReplicationJob$description' => '<p>The description of the replication job.</p>', 'ReplicationRun$description' => '<p>The description of the replication run.</p>', 'StartOnDemandAppReplicationRequest$description' => '<p>The description of the replication run.</p>', 'StartOnDemandReplicationRunRequest$description' => '<p>The description of the replication run.</p>', 'UpdateReplicationJobRequest$description' => '<p>The description of the replication job.</p>', ], ], 'DisassociateConnectorRequest' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateConnectorResponse' => [ 'base' => NULL, 'refs' => [], ], 'DryRunOperationException' => [ 'base' => '<p>The user has the required permissions, so the request would have succeeded, but a dry run was performed.</p>', 'refs' => [], ], 'EC2KeyName' => [ 'base' => NULL, 'refs' => [ 'ServerLaunchConfiguration$ec2KeyName' => '<p>The name of the Amazon EC2 SSH key to be used for connecting to the launched server.</p>', ], ], 'Encrypted' => [ 'base' => NULL, 'refs' => [ 'CreateReplicationJobRequest$encrypted' => '<p>Indicates whether the replication job produces encrypted AMIs.</p>', 'ReplicationJob$encrypted' => '<p>Indicates whether the replication job should produce encrypted AMIs.</p>', 'ReplicationRun$encrypted' => '<p>Indicates whether the replication run should produce an encrypted AMI.</p>', 'ServerReplicationParameters$encrypted' => '<p>Indicates whether the replication job produces encrypted AMIs.</p>', 'UpdateReplicationJobRequest$encrypted' => '<p>When true, the replication job produces encrypted AMIs. For more information, <code>KmsKeyId</code>.</p>', ], ], 'ErrorMessage' => [ 'base' => NULL, 'refs' => [ 'DryRunOperationException$message' => NULL, 'InternalError$message' => NULL, 'InvalidParameterException$message' => NULL, 'MissingRequiredParameterException$message' => NULL, 'NoConnectorsAvailableException$message' => NULL, 'OperationNotPermittedException$message' => NULL, 'ReplicationJobAlreadyExistsException$message' => NULL, 'ReplicationJobNotFoundException$message' => NULL, 'ReplicationRunLimitExceededException$message' => NULL, 'ServerCannotBeReplicatedException$message' => NULL, 'UnauthorizedOperationException$message' => NULL, ], ], 'ExecutionTimeoutSeconds' => [ 'base' => NULL, 'refs' => [ 'SSMValidationParameters$executionTimeoutSeconds' => '<p>The timeout interval, in seconds.</p>', ], ], 'ForceStopAppReplication' => [ 'base' => NULL, 'refs' => [ 'DeleteAppRequest$forceStopAppReplication' => '<p>Indicates whether to stop all replication jobs corresponding to the servers in the application while deleting the application.</p>', ], ], 'ForceTerminateApp' => [ 'base' => NULL, 'refs' => [ 'DeleteAppRequest$forceTerminateApp' => '<p>Indicates whether to terminate the stack corresponding to the application while deleting the application.</p>', ], ], 'Frequency' => [ 'base' => NULL, 'refs' => [ 'CreateReplicationJobRequest$frequency' => '<p>The time between consecutive replication runs, in hours.</p>', 'ReplicationJob$frequency' => '<p>The time between consecutive replication runs, in hours.</p>', 'ServerReplicationParameters$frequency' => '<p>The frequency of creating replication jobs for the server.</p>', 'UpdateReplicationJobRequest$frequency' => '<p>The time between consecutive replication runs, in hours.</p>', ], ], 'GenerateChangeSetRequest' => [ 'base' => NULL, 'refs' => [], ], 'GenerateChangeSetResponse' => [ 'base' => NULL, 'refs' => [], ], 'GenerateTemplateRequest' => [ 'base' => NULL, 'refs' => [], ], 'GenerateTemplateResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetAppLaunchConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetAppLaunchConfigurationResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetAppReplicationConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetAppReplicationConfigurationResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetAppRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetAppResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetAppValidationConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetAppValidationConfigurationResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetAppValidationOutputRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetAppValidationOutputResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetConnectorsRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetConnectorsResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetReplicationJobsRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetReplicationJobsResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetReplicationRunsRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetReplicationRunsResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetServersRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetServersResponse' => [ 'base' => NULL, 'refs' => [], ], 'ImportAppCatalogRequest' => [ 'base' => NULL, 'refs' => [], ], 'ImportAppCatalogResponse' => [ 'base' => NULL, 'refs' => [], ], 'ImportServerCatalogRequest' => [ 'base' => NULL, 'refs' => [], ], 'ImportServerCatalogResponse' => [ 'base' => NULL, 'refs' => [], ], 'ImportedAppId' => [ 'base' => NULL, 'refs' => [ 'AppSummary$importedAppId' => '<p>The ID of the application.</p>', ], ], 'InstanceId' => [ 'base' => NULL, 'refs' => [ 'SSMValidationParameters$instanceId' => '<p>The ID of the instance. The instance must have the following tag: UserForSMSApplicationValidation=true.</p>', ], ], 'InstanceType' => [ 'base' => NULL, 'refs' => [ 'ServerLaunchConfiguration$instanceType' => '<p>The instance type to use when launching the server.</p>', ], ], 'InternalError' => [ 'base' => '<p>An internal error occurred.</p>', 'refs' => [], ], 'InvalidParameterException' => [ 'base' => '<p>A specified parameter is not valid.</p>', 'refs' => [], ], 'IpAddress' => [ 'base' => NULL, 'refs' => [ 'Connector$ipAddress' => '<p>The IP address of the connector.</p>', ], ], 'KmsKeyId' => [ 'base' => NULL, 'refs' => [ 'CreateReplicationJobRequest$kmsKeyId' => '<p>The ID of the KMS key for replication jobs that produce encrypted AMIs. This value can be any of the following:</p> <ul> <li> <p>KMS key ID</p> </li> <li> <p>KMS key alias</p> </li> <li> <p>ARN referring to the KMS key ID</p> </li> <li> <p>ARN referring to the KMS key alias</p> </li> </ul> <p> If encrypted is <i>true</i> but a KMS key ID is not specified, the customer\'s default KMS key for Amazon EBS is used. </p>', 'ReplicationJob$kmsKeyId' => '<p>The ID of the KMS key for replication jobs that produce encrypted AMIs. This value can be any of the following: </p> <ul> <li> <p>KMS key ID</p> </li> <li> <p>KMS key alias</p> </li> <li> <p>ARN referring to the KMS key ID</p> </li> <li> <p>ARN referring to the KMS key alias</p> </li> </ul> <p>If encrypted is enabled but a KMS key ID is not specified, the customer\'s default KMS key for Amazon EBS is used.</p>', 'ReplicationRun$kmsKeyId' => '<p>The ID of the KMS key for replication jobs that produce encrypted AMIs. This value can be any of the following:</p> <ul> <li> <p>KMS key ID</p> </li> <li> <p>KMS key alias</p> </li> <li> <p>ARN referring to the KMS key ID</p> </li> <li> <p>ARN referring to the KMS key alias</p> </li> </ul> <p> If encrypted is <i>true</i> but a KMS key ID is not specified, the customer\'s default KMS key for Amazon EBS is used. </p>', 'ServerReplicationParameters$kmsKeyId' => '<p>The ID of the KMS key for replication jobs that produce encrypted AMIs. This value can be any of the following:</p> <ul> <li> <p>KMS key ID</p> </li> <li> <p>KMS key alias</p> </li> <li> <p>ARN referring to the KMS key ID</p> </li> <li> <p>ARN referring to the KMS key alias</p> </li> </ul> <p>If encrypted is enabled but a KMS key ID is not specified, the customer\'s default KMS key for Amazon EBS is used.</p>', 'UpdateReplicationJobRequest$kmsKeyId' => '<p>The ID of the KMS key for replication jobs that produce encrypted AMIs. This value can be any of the following:</p> <ul> <li> <p>KMS key ID</p> </li> <li> <p>KMS key alias</p> </li> <li> <p>ARN referring to the KMS key ID</p> </li> <li> <p>ARN referring to the KMS key alias</p> </li> </ul> <p>If encrypted is enabled but a KMS key ID is not specified, the customer\'s default KMS key for Amazon EBS is used.</p>', ], ], 'LaunchAppRequest' => [ 'base' => NULL, 'refs' => [], ], 'LaunchAppResponse' => [ 'base' => NULL, 'refs' => [], ], 'LaunchDetails' => [ 'base' => '<p>Details about the latest launch of an application.</p>', 'refs' => [ 'AppSummary$launchDetails' => '<p>Details about the latest launch of the application.</p>', ], ], 'LaunchOrder' => [ 'base' => NULL, 'refs' => [ 'ServerGroupLaunchConfiguration$launchOrder' => '<p>The launch order of servers in the server group.</p>', ], ], 'LicenseType' => [ 'base' => NULL, 'refs' => [ 'CreateReplicationJobRequest$licenseType' => '<p>The license type to be used for the AMI created by a successful replication run.</p>', 'ReplicationJob$licenseType' => '<p>The license type to be used for the AMI created by a successful replication run.</p>', 'ServerReplicationParameters$licenseType' => '<p>The license type for creating a replication job for the server.</p>', 'UpdateReplicationJobRequest$licenseType' => '<p>The license type to be used for the AMI created by a successful replication run.</p>', ], ], 'ListAppsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListAppsResponse' => [ 'base' => NULL, 'refs' => [], ], 'LogicalId' => [ 'base' => NULL, 'refs' => [ 'ServerLaunchConfiguration$logicalId' => '<p>The logical ID of the server in the CloudFormation template.</p>', ], ], 'MacAddress' => [ 'base' => NULL, 'refs' => [ 'Connector$macAddress' => '<p>The MAC address of the connector.</p>', ], ], 'MaxResults' => [ 'base' => NULL, 'refs' => [ 'GetConnectorsRequest$maxResults' => '<p>The maximum number of results to return in a single call. The default value is 50. To retrieve the remaining results, make another call with the returned <code>NextToken</code> value.</p>', 'GetReplicationJobsRequest$maxResults' => '<p>The maximum number of results to return in a single call. The default value is 50. To retrieve the remaining results, make another call with the returned <code>NextToken</code> value.</p>', 'GetReplicationRunsRequest$maxResults' => '<p>The maximum number of results to return in a single call. The default value is 50. To retrieve the remaining results, make another call with the returned <code>NextToken</code> value.</p>', 'GetServersRequest$maxResults' => '<p>The maximum number of results to return in a single call. The default value is 50. To retrieve the remaining results, make another call with the returned <code>NextToken</code> value.</p>', 'ListAppsRequest$maxResults' => '<p>The maximum number of results to return in a single call. The default value is 100. To retrieve the remaining results, make another call with the returned <code>NextToken</code> value. </p>', ], ], 'MissingRequiredParameterException' => [ 'base' => '<p>A required parameter is missing.</p>', 'refs' => [], ], 'NextToken' => [ 'base' => NULL, 'refs' => [ 'GetConnectorsRequest$nextToken' => '<p>The token for the next set of results.</p>', 'GetConnectorsResponse$nextToken' => '<p>The token required to retrieve the next set of results. This value is null when there are no more results to return.</p>', 'GetReplicationJobsRequest$nextToken' => '<p>The token for the next set of results.</p>', 'GetReplicationJobsResponse$nextToken' => '<p>The token required to retrieve the next set of results. This value is null when there are no more results to return.</p>', 'GetReplicationRunsRequest$nextToken' => '<p>The token for the next set of results.</p>', 'GetReplicationRunsResponse$nextToken' => '<p>The token required to retrieve the next set of results. This value is null when there are no more results to return.</p>', 'GetServersRequest$nextToken' => '<p>The token for the next set of results.</p>', 'GetServersResponse$nextToken' => '<p>The token required to retrieve the next set of results. This value is null when there are no more results to return.</p>', 'ListAppsRequest$nextToken' => '<p>The token for the next set of results.</p>', 'ListAppsResponse$nextToken' => '<p>The token required to retrieve the next set of results. This value is null when there are no more results to return.</p>', ], ], 'NoConnectorsAvailableException' => [ 'base' => '<p>There are no connectors available.</p>', 'refs' => [], ], 'NonEmptyStringWithMaxLen255' => [ 'base' => NULL, 'refs' => [ 'AppValidationConfiguration$name' => '<p>The name of the configuration.</p>', 'ServerValidationConfiguration$name' => '<p>The name of the configuration.</p>', 'ValidationOutput$name' => '<p>The name of the validation.</p>', ], ], 'NotificationContext' => [ 'base' => '<p>Contains the status of validating an application.</p>', 'refs' => [ 'NotifyAppValidationOutputRequest$notificationContext' => '<p>The notification information.</p>', ], ], 'NotifyAppValidationOutputRequest' => [ 'base' => NULL, 'refs' => [], ], 'NotifyAppValidationOutputResponse' => [ 'base' => NULL, 'refs' => [], ], 'NumberOfRecentAmisToKeep' => [ 'base' => NULL, 'refs' => [ 'CreateReplicationJobRequest$numberOfRecentAmisToKeep' => '<p>The maximum number of SMS-created AMIs to retain. The oldest is deleted after the maximum number is reached and a new AMI is created.</p>', 'ReplicationJob$numberOfRecentAmisToKeep' => '<p>The number of recent AMIs to keep in the customer\'s account for a replication job. By default, the value is set to zero, meaning that all AMIs are kept.</p>', 'ServerReplicationParameters$numberOfRecentAmisToKeep' => '<p>The number of recent AMIs to keep when creating a replication job for this server.</p>', 'UpdateReplicationJobRequest$numberOfRecentAmisToKeep' => '<p>The maximum number of SMS-created AMIs to retain. The oldest is deleted after the maximum number is reached and a new AMI is created.</p>', ], ], 'OperationNotPermittedException' => [ 'base' => '<p>This operation is not allowed.</p>', 'refs' => [], ], 'OutputFormat' => [ 'base' => NULL, 'refs' => [ 'GenerateChangeSetRequest$changesetFormat' => '<p>The format for the change set.</p>', 'GenerateTemplateRequest$templateFormat' => '<p>The format for generating the CloudFormation template.</p>', ], ], 'PutAppLaunchConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutAppLaunchConfigurationResponse' => [ 'base' => NULL, 'refs' => [], ], 'PutAppReplicationConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutAppReplicationConfigurationResponse' => [ 'base' => NULL, 'refs' => [], ], 'PutAppValidationConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutAppValidationConfigurationResponse' => [ 'base' => NULL, 'refs' => [], ], 'ReplicationJob' => [ 'base' => '<p>Represents a replication job.</p>', 'refs' => [ 'GetReplicationRunsResponse$replicationJob' => '<p>Information about the replication job.</p>', 'ReplicationJobList$member' => NULL, ], ], 'ReplicationJobAlreadyExistsException' => [ 'base' => '<p>The specified replication job already exists.</p>', 'refs' => [], ], 'ReplicationJobId' => [ 'base' => NULL, 'refs' => [ 'CreateReplicationJobResponse$replicationJobId' => '<p>The unique identifier of the replication job.</p>', 'DeleteReplicationJobRequest$replicationJobId' => '<p>The ID of the replication job.</p>', 'GetReplicationJobsRequest$replicationJobId' => '<p>The ID of the replication job.</p>', 'GetReplicationRunsRequest$replicationJobId' => '<p>The ID of the replication job.</p>', 'ReplicationJob$replicationJobId' => '<p>The ID of the replication job.</p>', 'Server$replicationJobId' => '<p>The ID of the replication job.</p>', 'StartOnDemandReplicationRunRequest$replicationJobId' => '<p>The ID of the replication job.</p>', 'UpdateReplicationJobRequest$replicationJobId' => '<p>The ID of the replication job.</p>', ], ], 'ReplicationJobList' => [ 'base' => NULL, 'refs' => [ 'GetReplicationJobsResponse$replicationJobList' => '<p>Information about the replication jobs.</p>', ], ], 'ReplicationJobNotFoundException' => [ 'base' => '<p>The specified replication job does not exist.</p>', 'refs' => [], ], 'ReplicationJobState' => [ 'base' => NULL, 'refs' => [ 'ReplicationJob$state' => '<p>The state of the replication job.</p>', ], ], 'ReplicationJobStatusMessage' => [ 'base' => NULL, 'refs' => [ 'ReplicationJob$statusMessage' => '<p>The description of the current status of the replication job.</p>', ], ], 'ReplicationJobTerminated' => [ 'base' => NULL, 'refs' => [ 'Server$replicationJobTerminated' => '<p>Indicates whether the replication job is deleted or failed.</p>', ], ], 'ReplicationRun' => [ 'base' => '<p>Represents a replication run.</p>', 'refs' => [ 'ReplicationRunList$member' => NULL, ], ], 'ReplicationRunId' => [ 'base' => NULL, 'refs' => [ 'ReplicationRun$replicationRunId' => '<p>The ID of the replication run.</p>', 'StartOnDemandReplicationRunResponse$replicationRunId' => '<p>The ID of the replication run.</p>', ], ], 'ReplicationRunLimitExceededException' => [ 'base' => '<p>You have exceeded the number of on-demand replication runs you can request in a 24-hour period.</p>', 'refs' => [], ], 'ReplicationRunList' => [ 'base' => NULL, 'refs' => [ 'GetReplicationRunsResponse$replicationRunList' => '<p>Information about the replication runs.</p>', 'ReplicationJob$replicationRunList' => '<p>Information about the replication runs.</p>', ], ], 'ReplicationRunStage' => [ 'base' => NULL, 'refs' => [ 'ReplicationRunStageDetails$stage' => '<p>The current stage of a replication run.</p>', ], ], 'ReplicationRunStageDetails' => [ 'base' => '<p>Details of the current stage of a replication run.</p>', 'refs' => [ 'ReplicationRun$stageDetails' => '<p>Details about the current stage of the replication run.</p>', ], ], 'ReplicationRunStageProgress' => [ 'base' => NULL, 'refs' => [ 'ReplicationRunStageDetails$stageProgress' => '<p>The progress of the current stage of a replication run.</p>', ], ], 'ReplicationRunState' => [ 'base' => NULL, 'refs' => [ 'ReplicationRun$state' => '<p>The state of the replication run.</p>', ], ], 'ReplicationRunStatusMessage' => [ 'base' => NULL, 'refs' => [ 'ReplicationRun$statusMessage' => '<p>The description of the current status of the replication job.</p>', ], ], 'ReplicationRunType' => [ 'base' => NULL, 'refs' => [ 'ReplicationRun$type' => '<p>The type of replication run.</p>', ], ], 'RoleName' => [ 'base' => NULL, 'refs' => [ 'AppSummary$roleName' => '<p>The name of the service role in the customer\'s account used by Server Migration Service.</p>', 'CreateAppRequest$roleName' => '<p>The name of the service role in the customer\'s account to be used by Server Migration Service.</p>', 'CreateReplicationJobRequest$roleName' => '<p>The name of the IAM role to be used by the Server Migration Service.</p>', 'GetAppLaunchConfigurationResponse$roleName' => '<p>The name of the service role in the customer\'s account that CloudFormation uses to launch the application.</p>', 'ImportAppCatalogRequest$roleName' => '<p>The name of the service role. If you omit this parameter, we create a service-linked role for Migration Hub in your account. Otherwise, the role that you provide must have the <a href="https://docs.aws.amazon.com/migrationhub/latest/ug/new-customer-setup.html#sms-managed">policy and trust policy</a> described in the <i>Migration Hub User Guide</i>.</p>', 'PutAppLaunchConfigurationRequest$roleName' => '<p>The name of service role in the customer\'s account that CloudFormation uses to launch the application.</p>', 'ReplicationJob$roleName' => '<p>The name of the IAM role to be used by Server Migration Service.</p>', 'ServerLaunchConfiguration$iamInstanceProfileName' => '<p>The name of the IAM instance profile.</p>', 'UpdateAppRequest$roleName' => '<p>The name of the service role in the customer\'s account used by Server Migration Service.</p>', 'UpdateReplicationJobRequest$roleName' => '<p>The name of the IAM role to be used by Server Migration Service.</p>', ], ], 'RunOnce' => [ 'base' => NULL, 'refs' => [ 'CreateReplicationJobRequest$runOnce' => '<p>Indicates whether to run the replication job one time.</p>', 'ReplicationJob$runOnce' => '<p>Indicates whether to run the replication job one time.</p>', 'ServerReplicationParameters$runOnce' => '<p>Indicates whether to run the replication job one time.</p>', ], ], 'S3BucketName' => [ 'base' => NULL, 'refs' => [ 'S3Location$bucket' => '<p>The Amazon S3 bucket name.</p>', ], ], 'S3KeyName' => [ 'base' => NULL, 'refs' => [ 'S3Location$key' => '<p>The Amazon S3 bucket key.</p>', ], ], 'S3Location' => [ 'base' => '<p>Location of an Amazon S3 object.</p>', 'refs' => [ 'GenerateChangeSetResponse$s3Location' => '<p>The location of the Amazon S3 object.</p>', 'GenerateTemplateResponse$s3Location' => '<p>The location of the Amazon S3 object.</p>', 'SSMOutput$s3Location' => NULL, 'ServerLaunchConfiguration$configureScript' => NULL, 'Source$s3Location' => NULL, 'UserData$s3Location' => '<p>Amazon S3 location of the user-data script.</p>', ], ], 'SSMOutput' => [ 'base' => '<p>Contains the location of validation output.</p>', 'refs' => [ 'AppValidationOutput$ssmOutput' => '<p>Output from using SSM to validate the application.</p>', ], ], 'SSMValidationParameters' => [ 'base' => '<p>Contains validation parameters.</p>', 'refs' => [ 'AppValidationConfiguration$ssmValidationParameters' => '<p>The validation parameters.</p>', ], ], 'ScriptType' => [ 'base' => NULL, 'refs' => [ 'SSMValidationParameters$scriptType' => '<p>The type of validation script.</p>', 'ServerLaunchConfiguration$configureScriptType' => '<p>The type of configuration script.</p>', 'UserDataValidationParameters$scriptType' => '<p>The type of validation script.</p>', ], ], 'SecurityGroup' => [ 'base' => NULL, 'refs' => [ 'ServerLaunchConfiguration$securityGroup' => '<p>The ID of the security group that applies to the launched server.</p>', ], ], 'Server' => [ 'base' => '<p>Represents a server.</p>', 'refs' => [ 'ServerLaunchConfiguration$server' => '<p>The ID of the server with which the launch configuration is associated.</p>', 'ServerList$member' => NULL, 'ServerReplicationConfiguration$server' => '<p>The ID of the server with which this replication configuration is associated.</p>', 'ServerValidationConfiguration$server' => NULL, 'ServerValidationOutput$server' => NULL, ], ], 'ServerCannotBeReplicatedException' => [ 'base' => '<p>The specified server cannot be replicated.</p>', 'refs' => [], ], 'ServerCatalogStatus' => [ 'base' => NULL, 'refs' => [ 'GetServersResponse$serverCatalogStatus' => '<p>The status of the server catalog.</p>', ], ], 'ServerGroup' => [ 'base' => '<p>Logical grouping of servers.</p>', 'refs' => [ 'ServerGroups$member' => NULL, ], ], 'ServerGroupId' => [ 'base' => NULL, 'refs' => [ 'ServerGroup$serverGroupId' => '<p>The ID of a server group.</p>', 'ServerGroupLaunchConfiguration$serverGroupId' => '<p>The ID of the server group with which the launch configuration is associated.</p>', 'ServerGroupReplicationConfiguration$serverGroupId' => '<p>The ID of the server group with which this replication configuration is associated.</p>', 'ServerGroupValidationConfiguration$serverGroupId' => '<p>The ID of the server group.</p>', ], ], 'ServerGroupLaunchConfiguration' => [ 'base' => '<p>Launch configuration for a server group.</p>', 'refs' => [ 'ServerGroupLaunchConfigurations$member' => NULL, ], ], 'ServerGroupLaunchConfigurations' => [ 'base' => NULL, 'refs' => [ 'GetAppLaunchConfigurationResponse$serverGroupLaunchConfigurations' => '<p>The launch configurations for server groups in this application.</p>', 'PutAppLaunchConfigurationRequest$serverGroupLaunchConfigurations' => '<p>Information about the launch configurations for server groups in the application.</p>', ], ], 'ServerGroupName' => [ 'base' => NULL, 'refs' => [ 'ServerGroup$name' => '<p>The name of a server group.</p>', ], ], 'ServerGroupReplicationConfiguration' => [ 'base' => '<p>Replication configuration for a server group.</p>', 'refs' => [ 'ServerGroupReplicationConfigurations$member' => NULL, ], ], 'ServerGroupReplicationConfigurations' => [ 'base' => NULL, 'refs' => [ 'GetAppReplicationConfigurationResponse$serverGroupReplicationConfigurations' => '<p>The replication configurations associated with server groups in this application.</p>', 'PutAppReplicationConfigurationRequest$serverGroupReplicationConfigurations' => '<p>Information about the replication configurations for server groups in the application.</p>', ], ], 'ServerGroupValidationConfiguration' => [ 'base' => '<p>Configuration for validating an instance.</p>', 'refs' => [ 'ServerGroupValidationConfigurations$member' => NULL, ], ], 'ServerGroupValidationConfigurations' => [ 'base' => NULL, 'refs' => [ 'GetAppValidationConfigurationResponse$serverGroupValidationConfigurations' => '<p>The configuration for instance validation.</p>', 'PutAppValidationConfigurationRequest$serverGroupValidationConfigurations' => '<p>The configuration for instance validation.</p>', ], ], 'ServerGroups' => [ 'base' => NULL, 'refs' => [ 'CreateAppRequest$serverGroups' => '<p>The server groups to include in the application.</p>', 'CreateAppResponse$serverGroups' => '<p>The server groups included in the application.</p>', 'GetAppResponse$serverGroups' => '<p>The server groups that belong to the application.</p>', 'UpdateAppRequest$serverGroups' => '<p>The server groups in the application to update.</p>', 'UpdateAppResponse$serverGroups' => '<p>The updated server groups in the application.</p>', ], ], 'ServerId' => [ 'base' => NULL, 'refs' => [ 'CreateReplicationJobRequest$serverId' => '<p>The ID of the server.</p>', 'ReplicationJob$serverId' => '<p>The ID of the server.</p>', 'Server$serverId' => '<p>The ID of the server.</p>', ], ], 'ServerLaunchConfiguration' => [ 'base' => '<p>Launch configuration for a server.</p>', 'refs' => [ 'ServerLaunchConfigurations$member' => NULL, ], ], 'ServerLaunchConfigurations' => [ 'base' => NULL, 'refs' => [ 'ServerGroupLaunchConfiguration$serverLaunchConfigurations' => '<p>The launch configuration for servers in the server group.</p>', ], ], 'ServerList' => [ 'base' => NULL, 'refs' => [ 'GetServersResponse$serverList' => '<p>Information about the servers.</p>', 'ServerGroup$serverList' => '<p>The servers that belong to a server group.</p>', ], ], 'ServerReplicationConfiguration' => [ 'base' => '<p>Replication configuration of a server.</p>', 'refs' => [ 'ServerReplicationConfigurations$member' => NULL, ], ], 'ServerReplicationConfigurations' => [ 'base' => NULL, 'refs' => [ 'ServerGroupReplicationConfiguration$serverReplicationConfigurations' => '<p>The replication configuration for servers in the server group.</p>', ], ], 'ServerReplicationParameters' => [ 'base' => '<p>The replication parameters for replicating a server.</p>', 'refs' => [ 'ServerReplicationConfiguration$serverReplicationParameters' => '<p>The parameters for replicating the server.</p>', ], ], 'ServerType' => [ 'base' => NULL, 'refs' => [ 'ReplicationJob$serverType' => '<p>The type of server.</p>', 'Server$serverType' => '<p>The type of server.</p>', ], ], 'ServerValidationConfiguration' => [ 'base' => '<p>Configuration for validating an instance.</p>', 'refs' => [ 'ServerValidationConfigurations$member' => NULL, ], ], 'ServerValidationConfigurations' => [ 'base' => NULL, 'refs' => [ 'ServerGroupValidationConfiguration$serverValidationConfigurations' => '<p>The validation configuration.</p>', ], ], 'ServerValidationOutput' => [ 'base' => '<p>Contains output from validating an instance.</p>', 'refs' => [ 'ValidationOutput$serverValidationOutput' => '<p>The output from validation an instance.</p>', ], ], 'ServerValidationStrategy' => [ 'base' => NULL, 'refs' => [ 'ServerValidationConfiguration$serverValidationStrategy' => '<p>The validation strategy.</p>', ], ], 'Source' => [ 'base' => '<p>Contains the location of a validation script.</p>', 'refs' => [ 'SSMValidationParameters$source' => '<p>The location of the validation script.</p>', 'UserDataValidationParameters$source' => '<p>The location of the validation script.</p>', ], ], 'StackId' => [ 'base' => NULL, 'refs' => [ 'LaunchDetails$stackId' => '<p>The ID of the latest stack launched for this application.</p>', ], ], 'StackName' => [ 'base' => NULL, 'refs' => [ 'LaunchDetails$stackName' => '<p>The name of the latest stack launched for this application.</p>', ], ], 'StartAppReplicationRequest' => [ 'base' => NULL, 'refs' => [], ], 'StartAppReplicationResponse' => [ 'base' => NULL, 'refs' => [], ], 'StartOnDemandAppReplicationRequest' => [ 'base' => NULL, 'refs' => [], ], 'StartOnDemandAppReplicationResponse' => [ 'base' => NULL, 'refs' => [], ], 'StartOnDemandReplicationRunRequest' => [ 'base' => NULL, 'refs' => [], ], 'StartOnDemandReplicationRunResponse' => [ 'base' => NULL, 'refs' => [], ], 'StopAppReplicationRequest' => [ 'base' => NULL, 'refs' => [], ], 'StopAppReplicationResponse' => [ 'base' => NULL, 'refs' => [], ], 'Subnet' => [ 'base' => NULL, 'refs' => [ 'ServerLaunchConfiguration$subnet' => '<p>The ID of the subnet the server should be launched into.</p>', ], ], 'Tag' => [ 'base' => '<p>Key/value pair that can be assigned to an application.</p>', 'refs' => [ 'Tags$member' => NULL, ], ], 'TagKey' => [ 'base' => NULL, 'refs' => [ 'Tag$key' => '<p>The tag key.</p>', ], ], 'TagValue' => [ 'base' => NULL, 'refs' => [ 'Tag$value' => '<p>The tag value.</p>', ], ], 'Tags' => [ 'base' => NULL, 'refs' => [ 'CreateAppRequest$tags' => '<p>The tags to be associated with the application.</p>', 'CreateAppResponse$tags' => '<p>The tags associated with the application.</p>', 'GetAppResponse$tags' => '<p>The tags associated with the application.</p>', 'UpdateAppRequest$tags' => '<p>The tags to associate with the application.</p>', 'UpdateAppResponse$tags' => '<p>The tags associated with the application.</p>', ], ], 'TemporarilyUnavailableException' => [ 'base' => '<p>The service is temporarily unavailable.</p>', 'refs' => [], ], 'TerminateAppRequest' => [ 'base' => NULL, 'refs' => [], ], 'TerminateAppResponse' => [ 'base' => NULL, 'refs' => [], ], 'Timestamp' => [ 'base' => NULL, 'refs' => [ 'AppSummary$latestReplicationTime' => '<p>The timestamp of the application\'s most recent successful replication.</p>', 'AppSummary$creationTime' => '<p>The creation time of the application.</p>', 'AppSummary$lastModified' => '<p>The last modified time of the application.</p>', 'Connector$associatedOn' => '<p>The time the connector was associated.</p>', 'CreateReplicationJobRequest$seedReplicationTime' => '<p>The seed replication time.</p>', 'GetServersResponse$lastModifiedOn' => '<p>The time when the server was last modified.</p>', 'LaunchDetails$latestLaunchTime' => '<p>The latest time that this application was launched successfully.</p>', 'ReplicationJob$seedReplicationTime' => '<p>The seed replication time.</p>', 'ReplicationJob$nextReplicationRunStartTime' => '<p>The start time of the next replication run.</p>', 'ReplicationRun$scheduledStartTime' => '<p>The start time of the next replication run.</p>', 'ReplicationRun$completedTime' => '<p>The completion time of the last replication run.</p>', 'ServerReplicationParameters$seedTime' => '<p>The seed time for creating a replication job for the server.</p>', 'UpdateReplicationJobRequest$nextReplicationRunStartTime' => '<p>The start time of the next replication run.</p>', 'ValidationOutput$latestValidationTime' => '<p>The latest time that the validation was performed.</p>', ], ], 'TotalServerGroups' => [ 'base' => NULL, 'refs' => [ 'AppSummary$totalServerGroups' => '<p>The number of server groups present in the application.</p>', ], ], 'TotalServers' => [ 'base' => NULL, 'refs' => [ 'AppSummary$totalServers' => '<p>The number of servers present in the application.</p>', ], ], 'UnauthorizedOperationException' => [ 'base' => '<p>You lack permissions needed to perform this operation. Check your IAM policies, and ensure that you are using the correct access keys.</p>', 'refs' => [], ], 'UpdateAppRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateAppResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateReplicationJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateReplicationJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'UserData' => [ 'base' => '<p>A script that runs on first launch of an Amazon EC2 instance. Used for configuring the server during launch.</p>', 'refs' => [ 'ServerLaunchConfiguration$userData' => '<p>Location of the user-data script to be executed when launching the server.</p>', ], ], 'UserDataValidationParameters' => [ 'base' => '<p>Contains validation parameters.</p>', 'refs' => [ 'ServerValidationConfiguration$userDataValidationParameters' => '<p>The validation parameters.</p>', ], ], 'VPC' => [ 'base' => NULL, 'refs' => [ 'ServerLaunchConfiguration$vpc' => '<p>The ID of the VPC into which the server should be launched.</p>', ], ], 'ValidationId' => [ 'base' => NULL, 'refs' => [ 'AppValidationConfiguration$validationId' => '<p>The ID of the validation.</p>', 'NotificationContext$validationId' => '<p>The ID of the validation.</p>', 'ServerValidationConfiguration$validationId' => '<p>The ID of the validation.</p>', 'ValidationOutput$validationId' => '<p>The ID of the validation.</p>', ], ], 'ValidationOutput' => [ 'base' => '<p>Contains validation output.</p>', 'refs' => [ 'ValidationOutputList$member' => NULL, ], ], 'ValidationOutputList' => [ 'base' => NULL, 'refs' => [ 'GetAppValidationOutputResponse$validationOutputList' => '<p>The validation output.</p>', ], ], 'ValidationStatus' => [ 'base' => NULL, 'refs' => [ 'NotificationContext$status' => '<p>The status of the validation.</p>', 'ValidationOutput$status' => '<p>The status of the validation.</p>', ], ], 'ValidationStatusMessage' => [ 'base' => NULL, 'refs' => [ 'NotificationContext$statusMessage' => '<p>The status message.</p>', 'ValidationOutput$statusMessage' => '<p>The status message.</p>', ], ], 'VmId' => [ 'base' => NULL, 'refs' => [ 'VmServerAddress$vmId' => '<p>The ID of the VM.</p>', ], ], 'VmManagerId' => [ 'base' => NULL, 'refs' => [ 'Connector$vmManagerId' => '<p>The ID of the VM manager.</p>', 'VmServerAddress$vmManagerId' => '<p>The ID of the VM manager.</p>', ], ], 'VmManagerName' => [ 'base' => NULL, 'refs' => [ 'Connector$vmManagerName' => '<p>The name of the VM manager.</p>', 'VmServer$vmManagerName' => '<p>The name of the VM manager.</p>', ], ], 'VmManagerType' => [ 'base' => NULL, 'refs' => [ 'Connector$vmManagerType' => '<p>The VM management product.</p>', 'VmServer$vmManagerType' => '<p>The type of VM management product.</p>', ], ], 'VmName' => [ 'base' => NULL, 'refs' => [ 'VmServer$vmName' => '<p>The name of the VM.</p>', ], ], 'VmPath' => [ 'base' => NULL, 'refs' => [ 'VmServer$vmPath' => '<p>The VM folder path in the vCenter Server virtual machine inventory tree.</p>', ], ], 'VmServer' => [ 'base' => '<p>Represents a VM server.</p>', 'refs' => [ 'ReplicationJob$vmServer' => '<p>Information about the VM server.</p>', 'Server$vmServer' => '<p>Information about the VM server.</p>', ], ], 'VmServerAddress' => [ 'base' => '<p>Represents a VM server location.</p>', 'refs' => [ 'VmServer$vmServerAddress' => '<p>The VM server location.</p>', 'VmServerAddressList$member' => NULL, ], ], 'VmServerAddressList' => [ 'base' => NULL, 'refs' => [ 'GetServersRequest$vmServerAddressList' => '<p>The server addresses.</p>', ], ], ],];
