<?php
// This file was auto-generated from sdk-root/src/data/route53-recovery-cluster/2019-12-02/docs-2.json
return [ 'version' => '2.0', 'service' => '<p>Welcome to the Routing Control (Recovery Cluster) API Reference Guide for Amazon Route 53 Application Recovery Controller.</p> <p>With Route 53 ARC, you can use routing control with extreme reliability to recover applications by rerouting traffic across Availability Zones or Amazon Web Services Regions. Routing controls are simple on/off switches hosted on a highly available cluster in Route 53 ARC. A cluster provides a set of five redundant Regional endpoints against which you can run API calls to get or update the state of routing controls. To implement failover, you set one routing control On and another one Off, to reroute traffic from one Availability Zone or Amazon Web Services Region to another. </p> <p> <i>Be aware that you must specify a Regional endpoint for a cluster when you work with API cluster operations to get or update routing control states in Route 53 ARC.</i> In addition, you must specify the US West (Oregon) Region for Route 53 ARC API calls. For example, use the parameter <code>--region us-west-2</code> with AWS CLI commands. For more information, see <a href="https://docs.aws.amazon.com/r53recovery/latest/dg/routing-control.update.api.html"> Get and update routing control states using the API</a> in the Amazon Route 53 Application Recovery Controller Developer Guide.</p> <p>This API guide includes information about the API operations for how to get and update routing control states in Route 53 ARC. To work with routing control in Route 53 ARC, you must first create the required components (clusters, control panels, and routing controls) using the recovery cluster configuration API.</p> <p>For more information about working with routing control in Route 53 ARC, see the following:</p> <ul> <li> <p>Create clusters, control panels, and routing controls by using API operations. For more information, see the <a href="https://docs.aws.amazon.com/recovery-cluster/latest/api/">Recovery Control Configuration API Reference Guide for Amazon Route 53 Application Recovery Controller</a>.</p> </li> <li> <p>Learn about the components in recovery control, including clusters, routing controls, and control panels, and how to work with Route 53 ARC in the Amazon Web Services console. For more information, see <a href="https://docs.aws.amazon.com/r53recovery/latest/dg/introduction-components.html#introduction-components-routing"> Recovery control components</a> in the Amazon Route 53 Application Recovery Controller Developer Guide.</p> </li> <li> <p>Route 53 ARC also provides readiness checks that continually audit resources to help make sure that your applications are scaled and ready to handle failover traffic. For more information about the related API operations, see the <a href="https://docs.aws.amazon.com/recovery-readiness/latest/api/">Recovery Readiness API Reference Guide for Amazon Route 53 Application Recovery Controller</a>.</p> </li> <li> <p>For more information about creating resilient applications and preparing for recovery readiness with Route 53 ARC, see the <a href="https://docs.aws.amazon.com/r53recovery/latest/dg/">Amazon Route 53 Application Recovery Controller Developer Guide</a>.</p> </li> </ul>', 'operations' => [ 'GetRoutingControlState' => '<p>Get the state for a routing control. A routing control is a simple on/off switch that you can use to route traffic to cells. When a routing control state is On, traffic flows to a cell. When the state is Off, traffic does not flow. </p> <p>Before you can create a routing control, you must first create a cluster, and then host the control in a control panel on the cluster. For more information, see <a href="https://docs.aws.amazon.com/r53recovery/latest/dg/routing-control.create.html"> Create routing control structures</a> in the Amazon Route 53 Application Recovery Controller Developer Guide. You access one of the endpoints for the cluster to get or update the routing control state to redirect traffic for your application. </p> <p> <i>You must specify Regional endpoints when you work with API cluster operations to get or update routing control states in Route 53 ARC.</i> </p> <p>To see a code example for getting a routing control state, including accessing Regional cluster endpoints in sequence, see <a href="https://docs.aws.amazon.com/r53recovery/latest/dg/service_code_examples_actions.html">API examples</a> in the Amazon Route 53 Application Recovery Controller Developer Guide.</p> <p>Learn more about working with routing controls in the following topics in the Amazon Route 53 Application Recovery Controller Developer Guide:</p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/r53recovery/latest/dg/routing-control.update.html"> Viewing and updating routing control states</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/r53recovery/latest/dg/routing-control.html">Working with routing controls in Route 53 ARC</a> </p> </li> </ul>', 'ListRoutingControls' => '<p>List routing control names and Amazon Resource Names (ARNs), as well as the routing control state for each routing control, along with the control panel name and control panel ARN for the routing controls. If you specify a control panel ARN, this call lists the routing controls in the control panel. Otherwise, it lists all the routing controls in the cluster.</p> <p>A routing control is a simple on/off switch in Route 53 ARC that you can use to route traffic to cells. When a routing control state is On, traffic flows to a cell. When the state is Off, traffic does not flow.</p> <p>Before you can create a routing control, you must first create a cluster, and then host the control in a control panel on the cluster. For more information, see <a href="https://docs.aws.amazon.com/r53recovery/latest/dg/routing-control.create.html"> Create routing control structures</a> in the Amazon Route 53 Application Recovery Controller Developer Guide. You access one of the endpoints for the cluster to get or update the routing control state to redirect traffic for your application. </p> <p> <i>You must specify Regional endpoints when you work with API cluster operations to use this API operation to list routing controls in Route 53 ARC.</i> </p> <p>Learn more about working with routing controls in the following topics in the Amazon Route 53 Application Recovery Controller Developer Guide:</p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/r53recovery/latest/dg/routing-control.update.html"> Viewing and updating routing control states</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/r53recovery/latest/dg/routing-control.html">Working with routing controls in Route 53 ARC</a> </p> </li> </ul>', 'UpdateRoutingControlState' => '<p>Set the state of the routing control to reroute traffic. You can set the value to be On or Off. When the state is On, traffic flows to a cell. When the state is Off, traffic does not flow.</p> <p>With Route 53 ARC, you can add safety rules for routing controls, which are safeguards for routing control state updates that help prevent unexpected outcomes, like fail open traffic routing. However, there are scenarios when you might want to bypass the routing control safeguards that are enforced with safety rules that you\'ve configured. For example, you might want to fail over quickly for disaster recovery, and one or more safety rules might be unexpectedly preventing you from updating a routing control state to reroute traffic. In a "break glass" scenario like this, you can override one or more safety rules to change a routing control state and fail over your application.</p> <p>The <code>SafetyRulesToOverride</code> property enables you override one or more safety rules and update routing control states. For more information, see <a href="https://docs.aws.amazon.com/r53recovery/latest/dg/routing-control.override-safety-rule.html"> Override safety rules to reroute traffic</a> in the Amazon Route 53 Application Recovery Controller Developer Guide.</p> <p> <i>You must specify Regional endpoints when you work with API cluster operations to get or update routing control states in Route 53 ARC.</i> </p> <p>To see a code example for getting a routing control state, including accessing Regional cluster endpoints in sequence, see <a href="https://docs.aws.amazon.com/r53recovery/latest/dg/service_code_examples_actions.html">API examples</a> in the Amazon Route 53 Application Recovery Controller Developer Guide.</p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/r53recovery/latest/dg/routing-control.update.html"> Viewing and updating routing control states</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/r53recovery/latest/dg/routing-control.html">Working with routing controls overall</a> </p> </li> </ul>', 'UpdateRoutingControlStates' => '<p>Set multiple routing control states. You can set the value for each state to be On or Off. When the state is On, traffic flows to a cell. When it\'s Off, traffic does not flow.</p> <p>With Route 53 ARC, you can add safety rules for routing controls, which are safeguards for routing control state updates that help prevent unexpected outcomes, like fail open traffic routing. However, there are scenarios when you might want to bypass the routing control safeguards that are enforced with safety rules that you\'ve configured. For example, you might want to fail over quickly for disaster recovery, and one or more safety rules might be unexpectedly preventing you from updating a routing control state to reroute traffic. In a "break glass" scenario like this, you can override one or more safety rules to change a routing control state and fail over your application.</p> <p>The <code>SafetyRulesToOverride</code> property enables you override one or more safety rules and update routing control states. For more information, see <a href="https://docs.aws.amazon.com/r53recovery/latest/dg/routing-control.override-safety-rule.html"> Override safety rules to reroute traffic</a> in the Amazon Route 53 Application Recovery Controller Developer Guide.</p> <p> <i>You must specify Regional endpoints when you work with API cluster operations to get or update routing control states in Route 53 ARC.</i> </p> <p>To see a code example for getting a routing control state, including accessing Regional cluster endpoints in sequence, see <a href="https://docs.aws.amazon.com/r53recovery/latest/dg/service_code_examples_actions.html">API examples</a> in the Amazon Route 53 Application Recovery Controller Developer Guide.</p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/r53recovery/latest/dg/routing-control.update.html"> Viewing and updating routing control states</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/r53recovery/latest/dg/routing-control.html">Working with routing controls overall</a> </p> </li> </ul>', ], 'shapes' => [ 'AccessDeniedException' => [ 'base' => '<p>You don\'t have sufficient permissions to perform this action.</p>', 'refs' => [], ], 'Arn' => [ 'base' => NULL, 'refs' => [ 'Arns$member' => NULL, 'GetRoutingControlStateRequest$RoutingControlArn' => '<p>The Amazon Resource Name (ARN) for the routing control that you want to get the state for.</p>', 'GetRoutingControlStateResponse$RoutingControlArn' => '<p>The Amazon Resource Name (ARN) of the response.</p>', 'ListRoutingControlsRequest$ControlPanelArn' => '<p>The Amazon Resource Name (ARN) of the control panel of the routing controls to list.</p>', 'RoutingControl$ControlPanelArn' => '<p>The Amazon Resource Name (ARN) of the control panel where the routing control is located.</p>', 'RoutingControl$RoutingControlArn' => '<p>The Amazon Resource Name (ARN) of the routing control.</p>', 'UpdateRoutingControlStateEntry$RoutingControlArn' => '<p>The Amazon Resource Name (ARN) for a routing control state entry.</p>', 'UpdateRoutingControlStateRequest$RoutingControlArn' => '<p>The Amazon Resource Name (ARN) for the routing control that you want to update the state for.</p>', ], ], 'Arns' => [ 'base' => NULL, 'refs' => [ 'UpdateRoutingControlStateRequest$SafetyRulesToOverride' => '<p>The Amazon Resource Names (ARNs) for the safety rules that you want to override when you\'re updating the state of a routing control. You can override one safety rule or multiple safety rules by including one or more ARNs, separated by commas.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/r53recovery/latest/dg/routing-control.override-safety-rule.html"> Override safety rules to reroute traffic</a> in the Amazon Route 53 Application Recovery Controller Developer Guide.</p>', 'UpdateRoutingControlStatesRequest$SafetyRulesToOverride' => '<p>The Amazon Resource Names (ARNs) for the safety rules that you want to override when you\'re updating routing control states. You can override one safety rule or multiple safety rules by including one or more ARNs, separated by commas.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/r53recovery/latest/dg/routing-control.override-safety-rule.html"> Override safety rules to reroute traffic</a> in the Amazon Route 53 Application Recovery Controller Developer Guide.</p>', ], ], 'ConflictException' => [ 'base' => '<p>There was a conflict with this request. Try again.</p>', 'refs' => [], ], 'ControlPanelName' => [ 'base' => NULL, 'refs' => [ 'RoutingControl$ControlPanelName' => '<p>The name of the control panel where the routing control is located.</p>', ], ], 'EndpointTemporarilyUnavailableException' => [ 'base' => '<p>The cluster endpoint isn\'t available. Try another cluster endpoint.</p>', 'refs' => [], ], 'GetRoutingControlStateRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetRoutingControlStateResponse' => [ 'base' => NULL, 'refs' => [], ], 'InternalServerException' => [ 'base' => '<p>There was an unexpected error during processing of the request.</p>', 'refs' => [], ], 'ListRoutingControlsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListRoutingControlsResponse' => [ 'base' => NULL, 'refs' => [], ], 'MaxResults' => [ 'base' => NULL, 'refs' => [ 'ListRoutingControlsRequest$MaxResults' => '<p>The number of routing controls objects that you want to return with this call. The default value is 500.</p>', ], ], 'PageToken' => [ 'base' => NULL, 'refs' => [ 'ListRoutingControlsRequest$NextToken' => '<p>The token for the next set of results. You receive this token from a previous call.</p>', 'ListRoutingControlsResponse$NextToken' => '<p>The token for the next set of results. You receive this token from a previous call.</p>', ], ], 'ResourceNotFoundException' => [ 'base' => '<p>The request references a routing control or control panel that was not found.</p>', 'refs' => [], ], 'RetryAfterSeconds' => [ 'base' => 'Advice to clients on when the call can be safely retried', 'refs' => [ 'InternalServerException$retryAfterSeconds' => NULL, 'ThrottlingException$retryAfterSeconds' => NULL, ], ], 'RoutingControl' => [ 'base' => '<p>A routing control, which is a simple on/off switch that you can use to route traffic to cells. When a routing control state is On, traffic flows to a cell. When the state is Off, traffic does not flow. </p>', 'refs' => [ 'RoutingControls$member' => NULL, ], ], 'RoutingControlName' => [ 'base' => NULL, 'refs' => [ 'GetRoutingControlStateResponse$RoutingControlName' => '<p>The routing control name.</p>', 'RoutingControl$RoutingControlName' => '<p>The name of the routing control.</p>', ], ], 'RoutingControlState' => [ 'base' => NULL, 'refs' => [ 'GetRoutingControlStateResponse$RoutingControlState' => '<p>The state of the routing control.</p>', 'RoutingControl$RoutingControlState' => '<p>The current state of the routing control. When a routing control state is On, traffic flows to a cell. When the state is Off, traffic does not flow. </p>', 'UpdateRoutingControlStateEntry$RoutingControlState' => '<p>The routing control state in a set of routing control state entries.</p>', 'UpdateRoutingControlStateRequest$RoutingControlState' => '<p>The state of the routing control. You can set the value to be On or Off.</p>', ], ], 'RoutingControls' => [ 'base' => NULL, 'refs' => [ 'ListRoutingControlsResponse$RoutingControls' => '<p>The list of routing controls.</p>', ], ], 'ServiceLimitExceededException' => [ 'base' => '<p>The request can\'t update that many routing control states at the same time. Try again with fewer routing control states.</p>', 'refs' => [], ], 'String' => [ 'base' => NULL, 'refs' => [ 'AccessDeniedException$message' => NULL, 'ConflictException$message' => 'Description of the ConflictException error', 'ConflictException$resourceId' => 'Identifier of the resource in use', 'ConflictException$resourceType' => 'Type of the resource in use', 'EndpointTemporarilyUnavailableException$message' => NULL, 'InternalServerException$message' => NULL, 'ResourceNotFoundException$message' => NULL, 'ResourceNotFoundException$resourceId' => 'Hypothetical resource identifier that was not found', 'ResourceNotFoundException$resourceType' => 'Hypothetical resource type that was not found', 'ServiceLimitExceededException$message' => NULL, 'ServiceLimitExceededException$resourceId' => '<p>The resource identifier of the limit that was exceeded.</p>', 'ServiceLimitExceededException$resourceType' => '<p>The resource type of the limit that was exceeded.</p>', 'ServiceLimitExceededException$limitCode' => '<p>The code of the limit that was exceeded.</p>', 'ServiceLimitExceededException$serviceCode' => '<p>The service code of the limit that was exceeded.</p>', 'ThrottlingException$message' => NULL, 'ValidationException$message' => NULL, 'ValidationExceptionField$name' => '<p>The field that had the validation exception.</p>', 'ValidationExceptionField$message' => '<p>Information about the validation exception.</p>', ], ], 'ThrottlingException' => [ 'base' => '<p>The request was denied because of request throttling.</p>', 'refs' => [], ], 'UpdateRoutingControlStateEntries' => [ 'base' => NULL, 'refs' => [ 'UpdateRoutingControlStatesRequest$UpdateRoutingControlStateEntries' => '<p>A set of routing control entries that you want to update.</p>', ], ], 'UpdateRoutingControlStateEntry' => [ 'base' => '<p>A routing control state entry.</p>', 'refs' => [ 'UpdateRoutingControlStateEntries$member' => NULL, ], ], 'UpdateRoutingControlStateRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateRoutingControlStateResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateRoutingControlStatesRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateRoutingControlStatesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ValidationException' => [ 'base' => '<p>There was a validation error on the request.</p>', 'refs' => [], ], 'ValidationExceptionField' => [ 'base' => '<p>There was a validation error on the request.</p>', 'refs' => [ 'ValidationExceptionFieldList$member' => NULL, ], ], 'ValidationExceptionFieldList' => [ 'base' => 'The fields that caused the error, if applicable', 'refs' => [ 'ValidationException$fields' => NULL, ], ], 'ValidationExceptionReason' => [ 'base' => 'Reason the request failed validation', 'refs' => [ 'ValidationException$reason' => NULL, ], ], ],];
