<?php
// This file was auto-generated from sdk-root/src/data/rbin/2021-06-15/docs-2.json
return [ 'version' => '2.0', 'service' => '<p>This is the <i>Recycle Bin API Reference</i>. This documentation provides descriptions and syntax for each of the actions and data types in Recycle Bin.</p> <p>Recycle Bin is a resource recovery feature that enables you to restore accidentally deleted snapshots and EBS-backed AMIs. When using Recycle Bin, if your resources are deleted, they are retained in the Recycle Bin for a time period that you specify.</p> <p>You can restore a resource from the Recycle Bin at any time before its retention period expires. After you restore a resource from the Recycle Bin, the resource is removed from the Recycle Bin, and you can then use it in the same way you use any other resource of that type in your account. If the retention period expires and the resource is not restored, the resource is permanently deleted from the Recycle Bin and is no longer available for recovery. For more information about Recycle Bin, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/snapshot-recycle-bin.html"> Recycle Bin</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>', 'operations' => [ 'CreateRule' => '<p>Creates a Recycle Bin retention rule. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/recycle-bin-working-with-rules.html#recycle-bin-create-rule"> Create Recycle Bin retention rules</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>', 'DeleteRule' => '<p>Deletes a Recycle Bin retention rule. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/recycle-bin-working-with-rules.html#recycle-bin-delete-rule"> Delete Recycle Bin retention rules</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>', 'GetRule' => '<p>Gets information about a Recycle Bin retention rule.</p>', 'ListRules' => '<p>Lists the Recycle Bin retention rules in the Region.</p>', 'ListTagsForResource' => '<p>Lists the tags assigned to a retention rule.</p>', 'TagResource' => '<p>Assigns tags to the specified retention rule.</p>', 'UntagResource' => '<p>Unassigns a tag from a retention rule.</p>', 'UpdateRule' => '<p>Updates an existing Recycle Bin retention rule. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/recycle-bin-working-with-rules.html#recycle-bin-update-rule"> Update Recycle Bin retention rules</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>', ], 'shapes' => [ 'CreateRuleRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateRuleResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteRuleRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteRuleResponse' => [ 'base' => NULL, 'refs' => [], ], 'Description' => [ 'base' => NULL, 'refs' => [ 'CreateRuleRequest$Description' => '<p>The retention rule description.</p>', 'CreateRuleResponse$Description' => '<p>The retention rule description.</p>', 'GetRuleResponse$Description' => '<p>The retention rule description.</p>', 'RuleSummary$Description' => '<p>The retention rule description.</p>', 'UpdateRuleRequest$Description' => '<p>The retention rule description.</p>', 'UpdateRuleResponse$Description' => '<p>The retention rule description.</p>', ], ], 'ErrorMessage' => [ 'base' => NULL, 'refs' => [ 'InternalServerException$Message' => NULL, 'ResourceNotFoundException$Message' => NULL, 'ServiceQuotaExceededException$Message' => NULL, 'ValidationException$Message' => NULL, ], ], 'GetRuleRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetRuleResponse' => [ 'base' => NULL, 'refs' => [], ], 'InternalServerException' => [ 'base' => '<p>The service could not respond to the request due to an internal problem.</p>', 'refs' => [], ], 'ListRulesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListRulesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'MaxResults' => [ 'base' => NULL, 'refs' => [ 'ListRulesRequest$MaxResults' => '<p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>NextToken</code> value.</p>', ], ], 'NextToken' => [ 'base' => NULL, 'refs' => [ 'ListRulesRequest$NextToken' => '<p>The token for the next page of results.</p>', 'ListRulesResponse$NextToken' => '<p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>', ], ], 'ResourceNotFoundException' => [ 'base' => '<p>The specified resource was not found.</p>', 'refs' => [], ], 'ResourceNotFoundExceptionReason' => [ 'base' => NULL, 'refs' => [ 'ResourceNotFoundException$Reason' => '<p>The reason for the exception.</p>', ], ], 'ResourceTag' => [ 'base' => '<p>Information about the resource tags used to identify resources that are retained by the retention rule.</p>', 'refs' => [ 'ResourceTags$member' => NULL, ], ], 'ResourceTagKey' => [ 'base' => NULL, 'refs' => [ 'ResourceTag$ResourceTagKey' => '<p>The tag key.</p>', ], ], 'ResourceTagValue' => [ 'base' => NULL, 'refs' => [ 'ResourceTag$ResourceTagValue' => '<p>The tag value.</p>', ], ], 'ResourceTags' => [ 'base' => NULL, 'refs' => [ 'CreateRuleRequest$ResourceTags' => '<p>Specifies the resource tags to use to identify resources that are to be retained by a tag-level retention rule. For tag-level retention rules, only deleted resources, of the specified resource type, that have one or more of the specified tag key and value pairs are retained. If a resource is deleted, but it does not have any of the specified tag key and value pairs, it is immediately deleted without being retained by the retention rule.</p> <p>You can add the same tag key and value pair to a maximum or five retention rules.</p> <p>To create a Region-level retention rule, omit this parameter. A Region-level retention rule does not have any resource tags specified. It retains all deleted resources of the specified resource type in the Region in which the rule is created, even if the resources are not tagged.</p>', 'CreateRuleResponse$ResourceTags' => '<p>Information about the resource tags used to identify resources that are retained by the retention rule.</p>', 'GetRuleResponse$ResourceTags' => '<p>Information about the resource tags used to identify resources that are retained by the retention rule.</p>', 'ListRulesRequest$ResourceTags' => '<p>Information about the resource tags used to identify resources that are retained by the retention rule.</p>', 'UpdateRuleRequest$ResourceTags' => '<p>Specifies the resource tags to use to identify resources that are to be retained by a tag-level retention rule. For tag-level retention rules, only deleted resources, of the specified resource type, that have one or more of the specified tag key and value pairs are retained. If a resource is deleted, but it does not have any of the specified tag key and value pairs, it is immediately deleted without being retained by the retention rule.</p> <p>You can add the same tag key and value pair to a maximum or five retention rules.</p> <p>To create a Region-level retention rule, omit this parameter. A Region-level retention rule does not have any resource tags specified. It retains all deleted resources of the specified resource type in the Region in which the rule is created, even if the resources are not tagged.</p>', 'UpdateRuleResponse$ResourceTags' => '<p>Information about the resource tags used to identify resources that are retained by the retention rule.</p>', ], ], 'ResourceType' => [ 'base' => NULL, 'refs' => [ 'CreateRuleRequest$ResourceType' => '<p>The resource type to be retained by the retention rule. Currently, only Amazon EBS snapshots and EBS-backed AMIs are supported. To retain snapshots, specify <code>EBS_SNAPSHOT</code>. To retain EBS-backed AMIs, specify <code>EC2_IMAGE</code>.</p>', 'CreateRuleResponse$ResourceType' => '<p>The resource type retained by the retention rule.</p>', 'GetRuleResponse$ResourceType' => '<p>The resource type retained by the retention rule.</p>', 'ListRulesRequest$ResourceType' => '<p>The resource type retained by the retention rule. Only retention rules that retain the specified resource type are listed. Currently, only Amazon EBS snapshots and EBS-backed AMIs are supported. To list retention rules that retain snapshots, specify <code>EBS_SNAPSHOT</code>. To list retention rules that retain EBS-backed AMIs, specify <code>EC2_IMAGE</code>.</p>', 'UpdateRuleRequest$ResourceType' => '<p>The resource type to be retained by the retention rule. Currently, only Amazon EBS snapshots and EBS-backed AMIs are supported. To retain snapshots, specify <code>EBS_SNAPSHOT</code>. To retain EBS-backed AMIs, specify <code>EC2_IMAGE</code>.</p>', 'UpdateRuleResponse$ResourceType' => '<p>The resource type retained by the retention rule.</p>', ], ], 'RetentionPeriod' => [ 'base' => '<p>Information about the retention period for which the retention rule is to retain resources.</p>', 'refs' => [ 'CreateRuleRequest$RetentionPeriod' => '<p>Information about the retention period for which the retention rule is to retain resources.</p>', 'CreateRuleResponse$RetentionPeriod' => NULL, 'GetRuleResponse$RetentionPeriod' => '<p>Information about the retention period for which the retention rule is to retain resources.</p>', 'RuleSummary$RetentionPeriod' => '<p>Information about the retention period for which the retention rule is to retain resources.</p>', 'UpdateRuleRequest$RetentionPeriod' => '<p>Information about the retention period for which the retention rule is to retain resources.</p>', 'UpdateRuleResponse$RetentionPeriod' => NULL, ], ], 'RetentionPeriodUnit' => [ 'base' => NULL, 'refs' => [ 'RetentionPeriod$RetentionPeriodUnit' => '<p>The unit of time in which the retention period is measured. Currently, only <code>DAYS</code> is supported.</p>', ], ], 'RetentionPeriodValue' => [ 'base' => NULL, 'refs' => [ 'RetentionPeriod$RetentionPeriodValue' => '<p>The period value for which the retention rule is to retain resources. The period is measured using the unit specified for <b>RetentionPeriodUnit</b>.</p>', ], ], 'RuleArn' => [ 'base' => NULL, 'refs' => [ 'ListTagsForResourceRequest$ResourceArn' => '<p>The Amazon Resource Name (ARN) of the retention rule.</p>', 'TagResourceRequest$ResourceArn' => '<p>The Amazon Resource Name (ARN) of the retention rule.</p>', 'UntagResourceRequest$ResourceArn' => '<p>The Amazon Resource Name (ARN) of the retention rule.</p>', ], ], 'RuleIdentifier' => [ 'base' => NULL, 'refs' => [ 'CreateRuleResponse$Identifier' => '<p>The unique ID of the retention rule.</p>', 'DeleteRuleRequest$Identifier' => '<p>The unique ID of the retention rule.</p>', 'GetRuleRequest$Identifier' => '<p>The unique ID of the retention rule.</p>', 'GetRuleResponse$Identifier' => '<p>The unique ID of the retention rule.</p>', 'RuleSummary$Identifier' => '<p>The unique ID of the retention rule.</p>', 'UpdateRuleRequest$Identifier' => '<p>The unique ID of the retention rule.</p>', 'UpdateRuleResponse$Identifier' => '<p>The unique ID of the retention rule.</p>', ], ], 'RuleStatus' => [ 'base' => NULL, 'refs' => [ 'CreateRuleResponse$Status' => '<p>The state of the retention rule. Only retention rules that are in the <code>available</code> state retain resources.</p>', 'GetRuleResponse$Status' => '<p>The state of the retention rule. Only retention rules that are in the <code>available</code> state retain resources.</p>', 'UpdateRuleResponse$Status' => '<p>The state of the retention rule. Only retention rules that are in the <code>available</code> state retain resources.</p>', ], ], 'RuleSummary' => [ 'base' => '<p>Information about a Recycle Bin retention rule.</p>', 'refs' => [ 'RuleSummaryList$member' => NULL, ], ], 'RuleSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListRulesResponse$Rules' => '<p>Information about the retention rules.</p>', ], ], 'ServiceQuotaExceededException' => [ 'base' => '<p>The request would cause a service quota for the number of tags per resource to be exceeded.</p>', 'refs' => [], ], 'ServiceQuotaExceededExceptionReason' => [ 'base' => NULL, 'refs' => [ 'ServiceQuotaExceededException$Reason' => '<p>The reason for the exception.</p>', ], ], 'Tag' => [ 'base' => '<p>Information about the tags to assign to the retention rule.</p>', 'refs' => [ 'TagList$member' => NULL, ], ], 'TagKey' => [ 'base' => NULL, 'refs' => [ 'Tag$Key' => '<p>The tag key.</p>', 'TagKeyList$member' => NULL, ], ], 'TagKeyList' => [ 'base' => NULL, 'refs' => [ 'UntagResourceRequest$TagKeys' => '<p>The tag keys of the tags to unassign. All tags that have the specified tag key are unassigned.</p>', ], ], 'TagList' => [ 'base' => NULL, 'refs' => [ 'CreateRuleRequest$Tags' => '<p>Information about the tags to assign to the retention rule.</p>', 'CreateRuleResponse$Tags' => '<p>Information about the tags assigned to the retention rule.</p>', 'ListTagsForResourceResponse$Tags' => '<p>Information about the tags assigned to the retention rule.</p>', 'TagResourceRequest$Tags' => '<p>Information about the tags to assign to the retention rule.</p>', ], ], 'TagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'TagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'TagValue' => [ 'base' => NULL, 'refs' => [ 'Tag$Value' => '<p>The tag value.</p>', ], ], 'UntagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'UntagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateRuleRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateRuleResponse' => [ 'base' => NULL, 'refs' => [], ], 'ValidationException' => [ 'base' => '<p>One or more of the parameters in the request is not valid.</p>', 'refs' => [], ], 'ValidationExceptionReason' => [ 'base' => NULL, 'refs' => [ 'ValidationException$Reason' => '<p>The reason for the exception.</p>', ], ], ],];
