<?php
// This file was auto-generated from sdk-root/src/data/opensearch/2021-01-01/docs-2.json
return [ 'version' => '2.0', 'service' => '<fullname>Amazon OpenSearch Configuration Service</fullname> <p>Use the Amazon OpenSearch configuration API to create, configure, and manage Amazon OpenSearch Service domains.</p> <p>For sample code that uses the configuration API, see the <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/opensearch-configuration-samples.html"> Amazon OpenSearch Service Developer Guide</a>. The guide also contains <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/request-signing.html"> sample code for sending signed HTTP requests to the OpenSearch APIs</a>. </p> <p>The endpoint for configuration service requests is region-specific: es.<i>region</i>.amazonaws.com. For example, es.us-east-1.amazonaws.com. For a current list of supported regions and endpoints, see <a href="http://docs.aws.amazon.com/general/latest/gr/rande.html#service-regions" target="_blank">Regions and Endpoints</a>. </p>', 'operations' => [ 'AcceptInboundConnection' => '<p>Allows the remote domain owner to accept an inbound cross-cluster connection request.</p>', 'AddTags' => '<p>Attaches tags to an existing domain. Tags are a set of case-sensitive key value pairs. An domain can have up to 10 tags. See <a href="http://docs.aws.amazon.com/opensearch-service/latest/developerguide/managedomains.html#managedomains-awsresorcetagging" target="_blank"> Tagging Amazon OpenSearch Service domains</a> for more information. </p>', 'AssociatePackage' => '<p>Associates a package with an Amazon OpenSearch Service domain.</p>', 'CancelServiceSoftwareUpdate' => '<p>Cancels a scheduled service software update for an Amazon OpenSearch Service domain. You can only perform this operation before the <code>AutomatedUpdateDate</code> and when the <code>UpdateStatus</code> is in the <code>PENDING_UPDATE</code> state. </p>', 'CreateDomain' => '<p>Creates a new Amazon OpenSearch Service domain. For more information, see <a href="http://docs.aws.amazon.com/opensearch-service/latest/developerguide/createupdatedomains.html" target="_blank">Creating and managing Amazon OpenSearch Service domains </a> in the <i>Amazon OpenSearch Service Developer Guide</i>. </p>', 'CreateOutboundConnection' => '<p>Creates a new cross-cluster connection from a local OpenSearch domain to a remote OpenSearch domain.</p>', 'CreatePackage' => '<p>Create a package for use with Amazon OpenSearch Service domains.</p>', 'DeleteDomain' => '<p>Permanently deletes the specified domain and all of its data. Once a domain is deleted, it cannot be recovered. </p>', 'DeleteInboundConnection' => '<p>Allows the remote domain owner to delete an existing inbound cross-cluster connection.</p>', 'DeleteOutboundConnection' => '<p>Allows the local domain owner to delete an existing outbound cross-cluster connection.</p>', 'DeletePackage' => '<p>Deletes the package.</p>', 'DescribeDomain' => '<p>Returns domain configuration information about the specified domain, including the domain ID, domain endpoint, and domain ARN. </p>', 'DescribeDomainAutoTunes' => '<p>Provides scheduled Auto-Tune action details for the domain, such as Auto-Tune action type, description, severity, and scheduled date. </p>', 'DescribeDomainChangeProgress' => '<p>Returns information about the current blue/green deployment happening on a domain, including a change ID, status, and progress stages.</p>', 'DescribeDomainConfig' => '<p>Provides cluster configuration information about the specified domain, such as the state, creation date, update version, and update date for cluster options. </p>', 'DescribeDomains' => '<p>Returns domain configuration information about the specified domains, including the domain ID, domain endpoint, and domain ARN. </p>', 'DescribeInboundConnections' => '<p>Lists all the inbound cross-cluster connections for a remote domain.</p>', 'DescribeInstanceTypeLimits' => '<p> Describe the limits for a given instance type and OpenSearch or Elasticsearch version. When modifying an existing domain, specify the <code> <a>DomainName</a> </code> to see which limits you can modify. </p>', 'DescribeOutboundConnections' => '<p>Lists all the outbound cross-cluster connections for a local domain.</p>', 'DescribePackages' => '<p>Describes all packages available to Amazon OpenSearch Service domains. Includes options for filtering, limiting the number of results, and pagination. </p>', 'DescribeReservedInstanceOfferings' => '<p>Lists available reserved OpenSearch instance offerings.</p>', 'DescribeReservedInstances' => '<p>Returns information about reserved OpenSearch instances for this account.</p>', 'DissociatePackage' => '<p>Dissociates a package from the Amazon OpenSearch Service domain.</p>', 'GetCompatibleVersions' => '<p> Returns a list of upgrade-compatible versions of OpenSearch/Elasticsearch. You can optionally pass a <code> <a>DomainName</a> </code> to get all upgrade-compatible versions of OpenSearch/Elasticsearch for that specific domain. </p>', 'GetPackageVersionHistory' => '<p>Returns a list of package versions, along with their creation time and commit message.</p>', 'GetUpgradeHistory' => '<p>Retrieves the complete history of the last 10 upgrades performed on the domain.</p>', 'GetUpgradeStatus' => '<p>Retrieves the latest status of the last upgrade or upgrade eligibility check performed on the domain. </p>', 'ListDomainNames' => '<p>Returns the names of all domains owned by the current user\'s account.</p>', 'ListDomainsForPackage' => '<p>Lists all Amazon OpenSearch Service domains associated with the package.</p>', 'ListInstanceTypeDetails' => NULL, 'ListPackagesForDomain' => '<p>Lists all packages associated with the Amazon OpenSearch Service domain.</p>', 'ListTags' => '<p>Returns all tags for the given domain.</p>', 'ListVersions' => '<p>List all supported versions of OpenSearch and Elasticsearch.</p>', 'PurchaseReservedInstanceOffering' => '<p>Allows you to purchase reserved OpenSearch instances.</p>', 'RejectInboundConnection' => '<p>Allows the remote domain owner to reject an inbound cross-cluster connection request.</p>', 'RemoveTags' => '<p>Removes the specified set of tags from the given domain.</p>', 'StartServiceSoftwareUpdate' => '<p>Schedules a service software update for an Amazon OpenSearch Service domain.</p>', 'UpdateDomainConfig' => '<p>Modifies the cluster configuration of the specified domain, such as setting the instance type and the number of instances. </p>', 'UpdatePackage' => '<p>Updates a package for use with Amazon OpenSearch Service domains.</p>', 'UpgradeDomain' => '<p>Allows you to either upgrade your domain or perform an upgrade eligibility check to a compatible version of OpenSearch or Elasticsearch. </p>', ], 'shapes' => [ 'ARN' => [ 'base' => '<p>The Amazon Resource Name (ARN) of the domain. See <a href="http://docs.aws.amazon.com/IAM/latest/UserGuide/index.html" target="_blank">Identifiers for IAM Entities </a> in <i>Using AWS Identity and Access Management</i> for more information. </p>', 'refs' => [ 'AddTagsRequest$ARN' => '<p>Specify the <code>ARN</code> of the domain you want to add tags to. </p>', 'DomainEndpointOptions$CustomEndpointCertificateArn' => '<p>The ACM certificate ARN for your custom endpoint.</p>', 'DomainStatus$ARN' => '<p>The Amazon Resource Name (ARN) of a domain. See <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html" target="_blank">IAM identifiers </a> in the <i>AWS Identity and Access Management User Guide</i> for more information. </p>', 'ListTagsRequest$ARN' => '<p>Specify the <code>ARN</code> of the domain that the tags you want to view are attached to. </p>', 'MasterUserOptions$MasterUserARN' => '<p>ARN for the master user (if IAM is enabled).</p>', 'RemoveTagsRequest$ARN' => '<p>The <code>ARN</code> of the domain from which you want to delete the specified tags. </p>', ], ], 'AWSDomainInformation' => [ 'base' => NULL, 'refs' => [ 'DomainInformationContainer$AWSDomainInformation' => NULL, ], ], 'AcceptInboundConnectionRequest' => [ 'base' => '<p>Container for the parameters to the <code> <a>AcceptInboundConnection</a> </code> operation. </p>', 'refs' => [], ], 'AcceptInboundConnectionResponse' => [ 'base' => '<p>The result of an <code> <a>AcceptInboundConnection</a> </code> operation. Contains details about the accepted inbound connection. </p>', 'refs' => [], ], 'AccessDeniedException' => [ 'base' => '<p>An error occurred because user does not have permissions to access the resource. Returns HTTP status code 403.</p>', 'refs' => [], ], 'AccessPoliciesStatus' => [ 'base' => '<p>The configured access rules for the domain\'s document and search endpoints, and the current status of those rules. </p>', 'refs' => [ 'DomainConfig$AccessPolicies' => '<p>IAM access policy as a JSON-formatted string.</p>', ], ], 'AddTagsRequest' => [ 'base' => '<p>Container for the parameters to the <code> <a>AddTags</a> </code> operation. Specifies the tags to attach to the domain. </p>', 'refs' => [], ], 'AdditionalLimit' => [ 'base' => '<p> List of limits that are specific to a given InstanceType and for each of its <code> <a>InstanceRole</a> </code> . </p>', 'refs' => [ 'AdditionalLimitList$member' => NULL, ], ], 'AdditionalLimitList' => [ 'base' => NULL, 'refs' => [ 'Limits$AdditionalLimits' => '<p> List of additional limits that are specific to a given InstanceType and for each of its <code> <a>InstanceRole</a> </code> . </p>', ], ], 'AdvancedOptions' => [ 'base' => '<p>Exposes select native OpenSearch configuration values from <code>opensearch.yml</code>. Currently, the following advanced options are available: </p> <ul> <li>Option to allow references to indices in an HTTP request body. Must be <code>false</code> when configuring access to individual sub-resources. By default, the value is <code>true</code>. See <a href="http://docs.aws.amazon.com/opensearch-service/latest/developerguide/createupdatedomains.html#createdomain-configure-advanced-options" target="_blank">Advanced cluster parameters </a> for more information. </li> <li>Option to specify the percentage of heap space allocated to field data. By default, this setting is unbounded. </li> </ul> <p>For more information, see <a href="http://docs.aws.amazon.com/opensearch-service/latest/developerguide/createupdatedomains.html#createdomain-configure-advanced-options"> Advanced cluster parameters</a>. </p>', 'refs' => [ 'AdvancedOptionsStatus$Options' => '<p>The status of advanced options for the specified domain.</p>', 'CreateDomainRequest$AdvancedOptions' => '<p>Option to allow references to indices in an HTTP request body. Must be <code>false</code> when configuring access to individual sub-resources. By default, the value is <code>true</code>. See <a href="http://docs.aws.amazon.com/opensearch-service/latest/developerguide/createupdatedomains.html#createdomain-configure-advanced-options" target="_blank">Advanced cluster parameters </a> for more information. </p>', 'DomainStatus$AdvancedOptions' => '<p>The status of the <code>AdvancedOptions</code>. </p>', 'UpdateDomainConfigRequest$AdvancedOptions' => '<p>Modifies the advanced option to allow references to indices in an HTTP request body. Must be <code>false</code> when configuring access to individual sub-resources. By default, the value is <code>true</code>. See <a href="http://docs.aws.amazon.com/opensearch-service/latest/developerguide/createupdatedomains.html#createdomain-configure-advanced-options" target="_blank">Advanced options </a> for more information. </p>', 'UpgradeDomainRequest$AdvancedOptions' => NULL, 'UpgradeDomainResponse$AdvancedOptions' => NULL, ], ], 'AdvancedOptionsStatus' => [ 'base' => '<p>Status of the advanced options for the specified domain. Currently, the following advanced options are available: </p> <ul> <li>Option to allow references to indices in an HTTP request body. Must be <code>false</code> when configuring access to individual sub-resources. By default, the value is <code>true</code>. See <a href="http://docs.aws.amazon.com/opensearch-service/latest/developerguide/createupdatedomains.html#createdomain-configure-advanced-options" target="_blank">Advanced cluster parameters </a> for more information. </li> <li>Option to specify the percentage of heap space allocated to field data. By default, this setting is unbounded. </li> </ul> <p>For more information, see <a href="http://docs.aws.amazon.com/opensearch-service/latest/developerguide/createupdatedomains.html#createdomain-configure-advanced-options"> Advanced cluster parameters</a>. </p>', 'refs' => [ 'DomainConfig$AdvancedOptions' => '<p>The <code>AdvancedOptions</code> for the domain. See <a href="http://docs.aws.amazon.com/opensearch-service/latest/developerguide/createupdatedomains.html#createdomain-configure-advanced-options" target="_blank">Advanced options </a> for more information. </p>', ], ], 'AdvancedSecurityOptions' => [ 'base' => '<p>The advanced security configuration: whether advanced security is enabled, whether the internal database option is enabled. </p>', 'refs' => [ 'AdvancedSecurityOptionsStatus$Options' => '<p>Advanced security options for the specified domain.</p>', 'DomainStatus$AdvancedSecurityOptions' => '<p>The current status of the domain\'s advanced security options.</p>', ], ], 'AdvancedSecurityOptionsInput' => [ 'base' => '<p>The advanced security configuration: whether advanced security is enabled, whether the internal database option is enabled, master username and password (if internal database is enabled), and master user ARN (if IAM is enabled). </p>', 'refs' => [ 'CreateDomainRequest$AdvancedSecurityOptions' => '<p>Specifies advanced security options.</p>', 'UpdateDomainConfigRequest$AdvancedSecurityOptions' => '<p>Specifies advanced security options.</p>', ], ], 'AdvancedSecurityOptionsStatus' => [ 'base' => '<p>The status of advanced security options for the specified domain.</p>', 'refs' => [ 'DomainConfig$AdvancedSecurityOptions' => '<p>Specifies <code>AdvancedSecurityOptions</code> for the domain. </p>', ], ], 'AssociatePackageRequest' => [ 'base' => '<p> Container for the request parameters to the <code> <a>AssociatePackage</a> </code> operation. </p>', 'refs' => [], ], 'AssociatePackageResponse' => [ 'base' => '<p> Container for the response returned by <code> <a>AssociatePackage</a> </code> operation. </p>', 'refs' => [], ], 'AutoTune' => [ 'base' => '<p>Specifies the Auto-Tune type and Auto-Tune action details.</p>', 'refs' => [ 'AutoTuneList$member' => NULL, ], ], 'AutoTuneDate' => [ 'base' => '<p>The timestamp of the Auto-Tune action scheduled for the domain.</p>', 'refs' => [ 'ScheduledAutoTuneDetails$Date' => '<p>The timestamp of the Auto-Tune action scheduled for the domain.</p>', ], ], 'AutoTuneDesiredState' => [ 'base' => '<p>The Auto-Tune desired state. Valid values are ENABLED and DISABLED.</p>', 'refs' => [ 'AutoTuneOptions$DesiredState' => '<p>The Auto-Tune desired state. Valid values are ENABLED and DISABLED.</p>', 'AutoTuneOptionsInput$DesiredState' => '<p>The Auto-Tune desired state. Valid values are ENABLED and DISABLED.</p>', ], ], 'AutoTuneDetails' => [ 'base' => '<p>Specifies details about the Auto-Tune action. See <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/auto-tune.html" target="_blank"> Auto-Tune for Amazon OpenSearch Service </a> for more information. </p>', 'refs' => [ 'AutoTune$AutoTuneDetails' => '<p>Specifies details about the Auto-Tune action. See <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/auto-tune.html" target="_blank"> Auto-Tune for Amazon OpenSearch Service </a> for more information. </p>', ], ], 'AutoTuneList' => [ 'base' => NULL, 'refs' => [ 'DescribeDomainAutoTunesResponse$AutoTunes' => '<p>The list of setting adjustments that Auto-Tune has made to the domain. See <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/auto-tune.html" target="_blank"> Auto-Tune for Amazon OpenSearch Service </a> for more information. </p>', ], ], 'AutoTuneMaintenanceSchedule' => [ 'base' => '<p>Specifies the Auto-Tune maintenance schedule. See <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/auto-tune.html" target="_blank"> Auto-Tune for Amazon OpenSearch Service </a> for more information. </p>', 'refs' => [ 'AutoTuneMaintenanceScheduleList$member' => NULL, ], ], 'AutoTuneMaintenanceScheduleList' => [ 'base' => NULL, 'refs' => [ 'AutoTuneOptions$MaintenanceSchedules' => '<p>A list of maintenance schedules. See <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/auto-tune.html" target="_blank"> Auto-Tune for Amazon OpenSearch Service </a> for more information. </p>', 'AutoTuneOptionsInput$MaintenanceSchedules' => '<p>A list of maintenance schedules. See <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/auto-tune.html" target="_blank"> Auto-Tune for Amazon OpenSearch Service </a> for more information. </p>', ], ], 'AutoTuneOptions' => [ 'base' => '<p>The Auto-Tune options: the Auto-Tune desired state for the domain, rollback state when disabling Auto-Tune options and list of maintenance schedules. </p>', 'refs' => [ 'AutoTuneOptionsStatus$Options' => '<p>Specifies Auto-Tune options for the domain.</p>', 'UpdateDomainConfigRequest$AutoTuneOptions' => '<p>Specifies Auto-Tune options.</p>', ], ], 'AutoTuneOptionsInput' => [ 'base' => '<p>The Auto-Tune options: the Auto-Tune desired state for the domain and list of maintenance schedules. </p>', 'refs' => [ 'CreateDomainRequest$AutoTuneOptions' => '<p>Specifies Auto-Tune options.</p>', ], ], 'AutoTuneOptionsOutput' => [ 'base' => '<p>The Auto-Tune options: the Auto-Tune desired state for the domain and list of maintenance schedules. </p>', 'refs' => [ 'DomainStatus$AutoTuneOptions' => '<p>The current status of the domain\'s Auto-Tune options.</p>', ], ], 'AutoTuneOptionsStatus' => [ 'base' => '<p>The Auto-Tune status for the domain.</p>', 'refs' => [ 'DomainConfig$AutoTuneOptions' => '<p>Specifies <code>AutoTuneOptions</code> for the domain. </p>', ], ], 'AutoTuneState' => [ 'base' => '<p>The Auto-Tune state for the domain. For valid states see <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/auto-tune.html" target="_blank"> Auto-Tune for Amazon OpenSearch Service</a>. </p>', 'refs' => [ 'AutoTuneOptionsOutput$State' => '<p>The <code>AutoTuneState</code> for the domain. </p>', 'AutoTuneStatus$State' => '<p>The <code>AutoTuneState</code> for the domain. </p>', ], ], 'AutoTuneStatus' => [ 'base' => '<p>Provides the current Auto-Tune status for the domain.</p>', 'refs' => [ 'AutoTuneOptionsStatus$Status' => '<p>The status of the Auto-Tune options for the domain.</p>', ], ], 'AutoTuneType' => [ 'base' => '<p>Specifies the Auto-Tune type. Valid value is SCHEDULED_ACTION.</p>', 'refs' => [ 'AutoTune$AutoTuneType' => '<p>Specifies the Auto-Tune type. Valid value is SCHEDULED_ACTION.</p>', ], ], 'BackendRole' => [ 'base' => NULL, 'refs' => [ 'SAMLOptionsInput$MasterBackendRole' => '<p>The backend role that the SAML master user is mapped to.</p>', ], ], 'BaseException' => [ 'base' => '<p>An error occurred while processing the request.</p>', 'refs' => [], ], 'Boolean' => [ 'base' => NULL, 'refs' => [ 'AdvancedSecurityOptions$Enabled' => '<p>True if advanced security is enabled.</p>', 'AdvancedSecurityOptions$InternalUserDatabaseEnabled' => '<p>True if the internal user database is enabled.</p>', 'AdvancedSecurityOptions$AnonymousAuthEnabled' => '<p>True if Anonymous auth is enabled. Anonymous auth can be enabled only when AdvancedSecurity is enabled on existing domains.</p>', 'AdvancedSecurityOptionsInput$Enabled' => '<p>True if advanced security is enabled.</p>', 'AdvancedSecurityOptionsInput$InternalUserDatabaseEnabled' => '<p>True if the internal user database is enabled.</p>', 'AdvancedSecurityOptionsInput$AnonymousAuthEnabled' => '<p>True if Anonymous auth is enabled. Anonymous auth can be enabled only when AdvancedSecurity is enabled on existing domains.</p>', 'AutoTuneStatus$PendingDeletion' => '<p>Indicates whether the domain is being deleted.</p>', 'ClusterConfig$DedicatedMasterEnabled' => '<p>A boolean value to indicate whether a dedicated master node is enabled. See <a href="http://docs.aws.amazon.com/opensearch-service/latest/developerguide/managedomains.html#managedomains-dedicatedmasternodes" target="_blank">Dedicated master nodes in Amazon OpenSearch Service </a> for more information. </p>', 'ClusterConfig$ZoneAwarenessEnabled' => '<p>A boolean value to indicate whether zone awareness is enabled. See <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/managedomains-multiaz.html" target="_blank">Configuring a multi-AZ domain in Amazon OpenSearch Service </a> for more information. </p>', 'ClusterConfig$WarmEnabled' => '<p>True to enable UltraWarm storage.</p>', 'CognitoOptions$Enabled' => '<p>The option to enable Cognito for OpenSearch Dashboards authentication.</p>', 'ColdStorageOptions$Enabled' => '<p>Enable cold storage option. Accepted values true or false</p>', 'DomainEndpointOptions$EnforceHTTPS' => '<p>Whether only HTTPS endpoint should be enabled for the domain.</p>', 'DomainEndpointOptions$CustomEndpointEnabled' => '<p>Whether to enable a custom endpoint for the domain.</p>', 'DomainStatus$Created' => '<p>The domain creation status. <code>True</code> if the creation of a domain is complete. <code> False </code> if domain creation is still in progress. </p>', 'DomainStatus$Deleted' => '<p>The domain deletion status. <code>True</code> if a delete request has been received for the domain but resource cleanup is still in progress. <code>False</code> if the domain has not been deleted. Once domain deletion is complete, the status of the domain is no longer returned. </p>', 'DomainStatus$Processing' => '<p>The status of the domain configuration. <code>True</code> if Amazon OpenSearch Service is processing configuration changes. <code>False</code> if the configuration is active. </p>', 'DomainStatus$UpgradeProcessing' => '<p>The status of a domain version upgrade. <code>True</code> if Amazon OpenSearch Service is undergoing a version upgrade. <code>False</code> if the configuration is active. </p>', 'EBSOptions$EBSEnabled' => '<p>Whether EBS-based storage is enabled.</p>', 'EncryptionAtRestOptions$Enabled' => '<p>The option to enable encryption at rest.</p>', 'InstanceTypeDetails$EncryptionEnabled' => NULL, 'InstanceTypeDetails$CognitoEnabled' => NULL, 'InstanceTypeDetails$AppLogsEnabled' => NULL, 'InstanceTypeDetails$AdvancedSecurityEnabled' => NULL, 'InstanceTypeDetails$WarmEnabled' => NULL, 'LogPublishingOption$Enabled' => '<p>Whether the given log publishing option is enabled or not.</p>', 'NodeToNodeEncryptionOptions$Enabled' => '<p>True to enable node-to-node encryption.</p>', 'OptionStatus$PendingDeletion' => '<p>Indicates whether the domain is being deleted.</p>', 'SAMLOptionsInput$Enabled' => '<p>True if SAML is enabled.</p>', 'SAMLOptionsOutput$Enabled' => '<p>True if SAML is enabled.</p>', 'ServiceSoftwareOptions$UpdateAvailable' => '<p> <code>True</code> if you\'re able to update your service software version. <code>False</code> if you can\'t update your service software version. </p>', 'ServiceSoftwareOptions$Cancellable' => '<p> <code>True</code> if you\'re able to cancel your service software version update. <code>False</code> if you can\'t cancel your service software update. </p>', 'ServiceSoftwareOptions$OptionalDeployment' => '<p> <code>True</code> if a service software is never automatically updated. <code>False</code> if a service software is automatically updated after <code>AutomatedUpdateDate</code>. </p>', 'UpgradeDomainRequest$PerformCheckOnly' => '<p> When true, indicates that an upgrade eligibility check needs to be performed. Does not actually perform the upgrade. </p>', 'UpgradeDomainResponse$PerformCheckOnly' => '<p> When true, indicates that an upgrade eligibility check needs to be performed. Does not actually perform the upgrade. </p>', ], ], 'CancelServiceSoftwareUpdateRequest' => [ 'base' => '<p>Container for the parameters to the <code> <a>CancelServiceSoftwareUpdate</a> </code> operation. Specifies the name of the domain that you wish to cancel a service software update on. </p>', 'refs' => [], ], 'CancelServiceSoftwareUpdateResponse' => [ 'base' => '<p>The result of a <code>CancelServiceSoftwareUpdate</code> operation. Contains the status of the update. </p>', 'refs' => [], ], 'ChangeProgressDetails' => [ 'base' => '<p>Specifies change details of the domain configuration change.</p>', 'refs' => [ 'DomainConfig$ChangeProgressDetails' => '<p>Specifies change details of the domain configuration change.</p>', 'DomainStatus$ChangeProgressDetails' => '<p>Specifies change details of the domain configuration change.</p>', 'UpgradeDomainResponse$ChangeProgressDetails' => NULL, ], ], 'ChangeProgressStage' => [ 'base' => '<p>A progress stage details of a specific domain configuration change.</p>', 'refs' => [ 'ChangeProgressStageList$member' => NULL, ], ], 'ChangeProgressStageList' => [ 'base' => '<p>The list of progress stages of a specific domain configuration change.</p>', 'refs' => [ 'ChangeProgressStatusDetails$ChangeProgressStages' => '<p>The specific stages that the domain is going through to perform the configuration change.</p>', ], ], 'ChangeProgressStageName' => [ 'base' => NULL, 'refs' => [ 'ChangeProgressStage$Name' => '<p>The name of the specific progress stage.</p>', ], ], 'ChangeProgressStageStatus' => [ 'base' => NULL, 'refs' => [ 'ChangeProgressStage$Status' => '<p>The overall status of a specific progress stage.</p>', ], ], 'ChangeProgressStatusDetails' => [ 'base' => '<p>The progress details of a specific domain configuration change.</p>', 'refs' => [ 'DescribeDomainChangeProgressResponse$ChangeProgressStatus' => '<p>Progress information for the configuration change that is requested in the <code>DescribeDomainChangeProgress</code> request. </p>', ], ], 'CloudWatchLogsLogGroupArn' => [ 'base' => '<p>ARN of the Cloudwatch log group to publish logs to.</p>', 'refs' => [ 'LogPublishingOption$CloudWatchLogsLogGroupArn' => NULL, ], ], 'ClusterConfig' => [ 'base' => '<p>The configuration for the domain cluster, such as the type and number of instances.</p>', 'refs' => [ 'ClusterConfigStatus$Options' => '<p>The cluster configuration for the specified domain.</p>', 'CreateDomainRequest$ClusterConfig' => '<p>Configuration options for a domain. Specifies the instance type and number of instances in the domain. </p>', 'DomainStatus$ClusterConfig' => '<p>The type and number of instances in the domain.</p>', 'UpdateDomainConfigRequest$ClusterConfig' => '<p>The type and number of instances to instantiate for the domain cluster.</p>', ], ], 'ClusterConfigStatus' => [ 'base' => '<p>The configuration status for the specified domain.</p>', 'refs' => [ 'DomainConfig$ClusterConfig' => '<p>The <code>ClusterConfig</code> for the domain. </p>', ], ], 'CognitoOptions' => [ 'base' => '<p>Options to specify the Cognito user and identity pools for OpenSearch Dashboards authentication. For more information, see <a href="http://docs.aws.amazon.com/opensearch-service/latest/developerguide/cognito-auth.html" target="_blank">Configuring Amazon Cognito authentication for OpenSearch Dashboards</a>. </p>', 'refs' => [ 'CognitoOptionsStatus$Options' => '<p>Cognito options for the specified domain.</p>', 'CreateDomainRequest$CognitoOptions' => '<p>Options to specify the Cognito user and identity pools for OpenSearch Dashboards authentication. For more information, see <a href="http://docs.aws.amazon.com/opensearch-service/latest/developerguide/cognito-auth.html" target="_blank">Configuring Amazon Cognito authentication for OpenSearch Dashboards</a>. </p>', 'DomainStatus$CognitoOptions' => '<p>The <code>CognitoOptions</code> for the specified domain. For more information, see <a href="http://docs.aws.amazon.com/opensearch-service/latest/developerguide/cognito-auth.html" target="_blank">Configuring Amazon Cognito authentication for OpenSearch Dashboards</a>. </p>', 'UpdateDomainConfigRequest$CognitoOptions' => '<p>Options to specify the Cognito user and identity pools for OpenSearch Dashboards authentication. For more information, see <a href="http://docs.aws.amazon.com/opensearch-service/latest/developerguide/cognito-auth.html" target="_blank">Configuring Amazon Cognito authentication for OpenSearch Dashboards</a>. </p>', ], ], 'CognitoOptionsStatus' => [ 'base' => '<p>The status of the Cognito options for the specified domain.</p>', 'refs' => [ 'DomainConfig$CognitoOptions' => '<p>The <code>CognitoOptions</code> for the specified domain. For more information, see <a href="http://docs.aws.amazon.com/opensearch-service/latest/developerguide/cognito-auth.html" target="_blank">Configuring Amazon Cognito authentication for OpenSearch Dashboards</a>. </p>', ], ], 'ColdStorageOptions' => [ 'base' => '<p>Specifies the configuration for cold storage options such as enabled</p>', 'refs' => [ 'ClusterConfig$ColdStorageOptions' => '<p>Specifies the <code>ColdStorageOptions</code> config for a Domain</p>', ], ], 'CommitMessage' => [ 'base' => NULL, 'refs' => [ 'PackageVersionHistory$CommitMessage' => '<p>A message associated with the package version.</p>', 'UpdatePackageRequest$CommitMessage' => '<p>A commit message for the new version which is shown as part of <code>GetPackageVersionHistoryResponse</code>. </p>', ], ], 'CompatibleVersionsList' => [ 'base' => NULL, 'refs' => [ 'GetCompatibleVersionsResponse$CompatibleVersions' => '<p> A map of compatible OpenSearch versions returned as part of the <code> <a>GetCompatibleVersions</a> </code> operation. </p>', ], ], 'CompatibleVersionsMap' => [ 'base' => '<p> A map from an <code> <a>EngineVersion</a> </code> to a list of compatible <code> <a>EngineVersion</a> </code> s to which the domain can be upgraded. </p>', 'refs' => [ 'CompatibleVersionsList$member' => NULL, ], ], 'ConflictException' => [ 'base' => '<p>An error occurred because the client attempts to remove a resource that is currently in use. Returns HTTP status code 409.</p>', 'refs' => [], ], 'ConnectionAlias' => [ 'base' => NULL, 'refs' => [ 'CreateOutboundConnectionRequest$ConnectionAlias' => '<p>The connection alias used used by the customer for this cross-cluster connection.</p>', 'CreateOutboundConnectionResponse$ConnectionAlias' => '<p>The connection alias provided during the create connection request.</p>', 'OutboundConnection$ConnectionAlias' => '<p>The connection alias for the outbound cross-cluster connection.</p>', ], ], 'ConnectionId' => [ 'base' => NULL, 'refs' => [ 'AcceptInboundConnectionRequest$ConnectionId' => '<p>The ID of the inbound connection you want to accept.</p>', 'CreateOutboundConnectionResponse$ConnectionId' => '<p>The unique ID for the created outbound connection, which is used for subsequent operations on the connection.</p>', 'DeleteInboundConnectionRequest$ConnectionId' => '<p>The ID of the inbound connection to permanently delete.</p>', 'DeleteOutboundConnectionRequest$ConnectionId' => '<p>The ID of the outbound connection you want to permanently delete.</p>', 'InboundConnection$ConnectionId' => '<p>The connection ID for the inbound cross-cluster connection.</p>', 'OutboundConnection$ConnectionId' => '<p>The connection ID for the outbound cross-cluster connection.</p>', 'RejectInboundConnectionRequest$ConnectionId' => '<p>The ID of the inbound connection to reject.</p>', ], ], 'ConnectionStatusMessage' => [ 'base' => NULL, 'refs' => [ 'InboundConnectionStatus$Message' => '<p>Verbose information for the inbound connection status.</p>', 'OutboundConnectionStatus$Message' => '<p>Verbose information for the outbound connection status.</p>', ], ], 'CreateDomainRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateDomainResponse' => [ 'base' => '<p>The result of a <code>CreateDomain</code> operation. Contains the status of the newly created Amazon OpenSearch Service domain. </p>', 'refs' => [], ], 'CreateOutboundConnectionRequest' => [ 'base' => '<p>Container for the parameters to the <code> <a>CreateOutboundConnection</a> </code> operation. </p>', 'refs' => [], ], 'CreateOutboundConnectionResponse' => [ 'base' => '<p>The result of a <code> <a>CreateOutboundConnection</a> </code> request. Contains the details about the newly created cross-cluster connection. </p>', 'refs' => [], ], 'CreatePackageRequest' => [ 'base' => '<p> Container for request parameters to the <code> <a>CreatePackage</a> </code> operation. </p>', 'refs' => [], ], 'CreatePackageResponse' => [ 'base' => '<p> Container for the response returned by the <code> <a>CreatePackage</a> </code> operation. </p>', 'refs' => [], ], 'CreatedAt' => [ 'base' => NULL, 'refs' => [ 'PackageDetails$CreatedAt' => '<p>The timestamp of when the package was created.</p>', 'PackageVersionHistory$CreatedAt' => '<p>The timestamp of when the package was created.</p>', ], ], 'DeleteDomainRequest' => [ 'base' => '<p>Container for the parameters to the <code> <a>DeleteDomain</a> </code> operation. Specifies the name of the domain you want to delete. </p>', 'refs' => [], ], 'DeleteDomainResponse' => [ 'base' => '<p>The result of a <code>DeleteDomain</code> request. Contains the status of the pending deletion, or a "domain not found" error if the domain and all of its resources have been deleted. </p>', 'refs' => [], ], 'DeleteInboundConnectionRequest' => [ 'base' => '<p>Container for the parameters to the <code> <a>DeleteInboundConnection</a> </code> operation. </p>', 'refs' => [], ], 'DeleteInboundConnectionResponse' => [ 'base' => '<p>The result of a <code> <a>DeleteInboundConnection</a> </code> operation. Contains details about the deleted inbound connection. </p>', 'refs' => [], ], 'DeleteOutboundConnectionRequest' => [ 'base' => '<p>Container for the parameters to the <code> <a>DeleteOutboundConnection</a> </code> operation. </p>', 'refs' => [], ], 'DeleteOutboundConnectionResponse' => [ 'base' => '<p>The result of a <code> <a>DeleteOutboundConnection</a> </code> operation. Contains details about the deleted outbound connection. </p>', 'refs' => [], ], 'DeletePackageRequest' => [ 'base' => '<p> Container for the request parameters to the <code> <a>DeletePackage</a> </code> operation. </p>', 'refs' => [], ], 'DeletePackageResponse' => [ 'base' => '<p> Container for the response parameters to the <code> <a>DeletePackage</a> </code> operation. </p>', 'refs' => [], ], 'DeploymentCloseDateTimeStamp' => [ 'base' => NULL, 'refs' => [ 'ServiceSoftwareOptions$AutomatedUpdateDate' => '<p>The timestamp, in Epoch time, until which you can manually request a service software update. After this date, we automatically update your service software. </p>', ], ], 'DeploymentStatus' => [ 'base' => NULL, 'refs' => [ 'ServiceSoftwareOptions$UpdateStatus' => '<p>The status of your service software update. This field can take the following values: <code> ELIGIBLE</code>, <code>PENDING_UPDATE</code>, <code>IN_PROGRESS</code>, <code>COMPLETED</code>, and <code> NOT_ELIGIBLE</code>. </p>', ], ], 'DeploymentType' => [ 'base' => NULL, 'refs' => [ 'DryRunResults$DeploymentType' => '<p> Specifies the way in which Amazon OpenSearch Service applies the update. Possible responses are <code>Blue/Green</code> (the update requires a blue/green deployment), <code>DynamicUpdate</code> (no blue/green required), <code>Undetermined</code> (the domain is undergoing an update and can\'t predict the deployment type; try again after the update is complete), and <code>None</code> (the request doesn\'t include any configuration changes). </p>', ], ], 'DescribeDomainAutoTunesRequest' => [ 'base' => '<p>Container for the parameters to the <code>DescribeDomainAutoTunes</code> operation. </p>', 'refs' => [], ], 'DescribeDomainAutoTunesResponse' => [ 'base' => '<p>The result of a <code>DescribeDomainAutoTunes</code> request. See <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/auto-tune.html" target="_blank"> Auto-Tune for Amazon OpenSearch Service </a> for more information. </p>', 'refs' => [], ], 'DescribeDomainChangeProgressRequest' => [ 'base' => '<p>Container for the parameters to the <code>DescribeDomainChangeProgress</code> operation. Specifies the domain name and optional change specific identity for which you want progress information. </p>', 'refs' => [], ], 'DescribeDomainChangeProgressResponse' => [ 'base' => '<p>The result of a <code>DescribeDomainChangeProgress</code> request. Contains the progress information of the requested domain change. </p>', 'refs' => [], ], 'DescribeDomainConfigRequest' => [ 'base' => '<p>Container for the parameters to the <code>DescribeDomainConfig</code> operation. Specifies the domain name for which you want configuration information. </p>', 'refs' => [], ], 'DescribeDomainConfigResponse' => [ 'base' => '<p>The result of a <code>DescribeDomainConfig</code> request. Contains the configuration information of the requested domain. </p>', 'refs' => [], ], 'DescribeDomainRequest' => [ 'base' => '<p>Container for the parameters to the <code> <a>DescribeDomain</a> </code> operation. </p>', 'refs' => [], ], 'DescribeDomainResponse' => [ 'base' => '<p>The result of a <code>DescribeDomain</code> request. Contains the status of the domain specified in the request. </p>', 'refs' => [], ], 'DescribeDomainsRequest' => [ 'base' => '<p>Container for the parameters to the <code> <a>DescribeDomains</a> </code> operation. By default, the API returns the status of all domains. </p>', 'refs' => [], ], 'DescribeDomainsResponse' => [ 'base' => '<p>The result of a <code>DescribeDomains</code> request. Contains the status of the specified domains or all domains owned by the account. </p>', 'refs' => [], ], 'DescribeInboundConnectionsRequest' => [ 'base' => '<p>Container for the parameters to the <code> <a>DescribeInboundConnections</a> </code> operation. </p>', 'refs' => [], ], 'DescribeInboundConnectionsResponse' => [ 'base' => '<p>The result of a <code> <a>DescribeInboundConnections</a> </code> request. Contains a list of connections matching the filter criteria. </p>', 'refs' => [], ], 'DescribeInstanceTypeLimitsRequest' => [ 'base' => '<p> Container for the parameters to the <code> <a>DescribeInstanceTypeLimits</a> </code> operation. </p>', 'refs' => [], ], 'DescribeInstanceTypeLimitsResponse' => [ 'base' => '<p> Container for the parameters received from the <code> <a>DescribeInstanceTypeLimits</a> </code> operation. </p>', 'refs' => [], ], 'DescribeOutboundConnectionsRequest' => [ 'base' => '<p>Container for the parameters to the <code> <a>DescribeOutboundConnections</a> </code> operation. </p>', 'refs' => [], ], 'DescribeOutboundConnectionsResponse' => [ 'base' => '<p>The result of a <code> <a>DescribeOutboundConnections</a> </code> request. Contains the list of connections matching the filter criteria. </p>', 'refs' => [], ], 'DescribePackagesFilter' => [ 'base' => '<p>A filter to apply to the <code>DescribePackage</code> response. </p>', 'refs' => [ 'DescribePackagesFilterList$member' => NULL, ], ], 'DescribePackagesFilterList' => [ 'base' => '<p>A list of <code>DescribePackagesFilter</code> to filter the packages included in a <code>DescribePackages</code> response. </p>', 'refs' => [ 'DescribePackagesRequest$Filters' => '<p>Only returns packages that match the <code>DescribePackagesFilterList</code> values. </p>', ], ], 'DescribePackagesFilterName' => [ 'base' => NULL, 'refs' => [ 'DescribePackagesFilter$Name' => '<p>Any field from <code>PackageDetails</code>. </p>', ], ], 'DescribePackagesFilterValue' => [ 'base' => NULL, 'refs' => [ 'DescribePackagesFilterValues$member' => NULL, ], ], 'DescribePackagesFilterValues' => [ 'base' => NULL, 'refs' => [ 'DescribePackagesFilter$Value' => '<p>A list of values for the specified field.</p>', ], ], 'DescribePackagesRequest' => [ 'base' => '<p> Container for the request parameters to the <code> <a>DescribePackage</a> </code> operation. </p>', 'refs' => [], ], 'DescribePackagesResponse' => [ 'base' => '<p> Container for the response returned by the <code> <a>DescribePackages</a> </code> operation. </p>', 'refs' => [], ], 'DescribeReservedInstanceOfferingsRequest' => [ 'base' => '<p>Container for parameters to <code>DescribeReservedInstanceOfferings</code> </p>', 'refs' => [], ], 'DescribeReservedInstanceOfferingsResponse' => [ 'base' => '<p>Container for results from <code>DescribeReservedInstanceOfferings</code> </p>', 'refs' => [], ], 'DescribeReservedInstancesRequest' => [ 'base' => '<p>Container for parameters to <code>DescribeReservedInstances</code> </p>', 'refs' => [], ], 'DescribeReservedInstancesResponse' => [ 'base' => '<p>Container for results from <code>DescribeReservedInstances</code> </p>', 'refs' => [], ], 'Description' => [ 'base' => NULL, 'refs' => [ 'ChangeProgressStage$Description' => '<p>The description of the progress stage.</p>', ], ], 'DisableTimestamp' => [ 'base' => NULL, 'refs' => [ 'AdvancedSecurityOptions$AnonymousAuthDisableDate' => '<p>Specifies the Anonymous Auth Disable Date when Anonymous Auth is enabled.</p>', ], ], 'DisabledOperationException' => [ 'base' => '<p>An error occured because the client wanted to access a not supported operation. Gives http status code of 409.</p>', 'refs' => [], ], 'DissociatePackageRequest' => [ 'base' => '<p> Container for the request parameters to the <code> <a>DissociatePackage</a> </code> operation. </p>', 'refs' => [], ], 'DissociatePackageResponse' => [ 'base' => '<p> Container for the response returned by <code> <a>DissociatePackage</a> </code> operation. </p>', 'refs' => [], ], 'DomainConfig' => [ 'base' => '<p>The configuration of a domain.</p>', 'refs' => [ 'DescribeDomainConfigResponse$DomainConfig' => '<p>The configuration information of the domain requested in the <code>DescribeDomainConfig</code> request. </p>', 'UpdateDomainConfigResponse$DomainConfig' => '<p>The status of the updated domain.</p>', ], ], 'DomainEndpointOptions' => [ 'base' => '<p>Options to configure the endpoint for the domain.</p>', 'refs' => [ 'CreateDomainRequest$DomainEndpointOptions' => '<p>Options to specify configurations that will be applied to the domain endpoint.</p>', 'DomainEndpointOptionsStatus$Options' => '<p>Options to configure the endpoint for the domain.</p>', 'DomainStatus$DomainEndpointOptions' => '<p>The current status of the domain\'s endpoint options.</p>', 'UpdateDomainConfigRequest$DomainEndpointOptions' => '<p>Options to specify configuration that will be applied to the domain endpoint.</p>', ], ], 'DomainEndpointOptionsStatus' => [ 'base' => '<p>The configured endpoint options for the domain and their current status.</p>', 'refs' => [ 'DomainConfig$DomainEndpointOptions' => '<p>The <code>DomainEndpointOptions</code> for the domain. </p>', ], ], 'DomainId' => [ 'base' => '<p>Unique identifier for the domain.</p>', 'refs' => [ 'DomainStatus$DomainId' => '<p>The unique identifier for the specified domain.</p>', ], ], 'DomainInfo' => [ 'base' => NULL, 'refs' => [ 'DomainInfoList$member' => NULL, ], ], 'DomainInfoList' => [ 'base' => '<p>Contains the list of domain information.</p>', 'refs' => [ 'ListDomainNamesResponse$DomainNames' => '<p>List of domain names and respective engine types.</p>', ], ], 'DomainInformationContainer' => [ 'base' => NULL, 'refs' => [ 'CreateOutboundConnectionRequest$LocalDomainInfo' => '<p>The <code> <a>AWSDomainInformation</a> </code> for the local OpenSearch domain. </p>', 'CreateOutboundConnectionRequest$RemoteDomainInfo' => '<p>The <code> <a>AWSDomainInformation</a> </code> for the remote OpenSearch domain. </p>', 'CreateOutboundConnectionResponse$LocalDomainInfo' => '<p>The <code> <a>AWSDomainInformation</a> </code> for the local OpenSearch domain. </p>', 'CreateOutboundConnectionResponse$RemoteDomainInfo' => '<p>The <code> <a>AWSDomainInformation</a> </code> for the remote OpenSearch domain. </p>', 'InboundConnection$LocalDomainInfo' => '<p>The <code> <a>AWSDomainInformation</a> </code> for the local OpenSearch domain. </p>', 'InboundConnection$RemoteDomainInfo' => '<p>The <code> <a>AWSDomainInformation</a> </code> for the remote OpenSearch domain. </p>', 'OutboundConnection$LocalDomainInfo' => '<p>The <code> <a>DomainInformation</a> </code> for the local OpenSearch domain. </p>', 'OutboundConnection$RemoteDomainInfo' => '<p>The <code> <a>DomainInformation</a> </code> for the remote OpenSearch domain. </p>', ], ], 'DomainName' => [ 'base' => '<p>The name of an domain. Domain names are unique across the domains owned by an account within an AWS region. Domain names start with a letter or number and can contain the following characters: a-z (lowercase), 0-9, and - (hyphen). </p>', 'refs' => [ 'AWSDomainInformation$DomainName' => NULL, 'AssociatePackageRequest$DomainName' => '<p>The name of the domain to associate the package with.</p>', 'CancelServiceSoftwareUpdateRequest$DomainName' => '<p>The name of the domain that you want to stop the latest service software update on.</p>', 'CreateDomainRequest$DomainName' => '<p>The name of the Amazon OpenSearch Service domain you\'re creating. Domain names are unique across the domains owned by an account within an AWS region. Domain names must start with a lowercase letter and can contain the following characters: a-z (lowercase), 0-9, and - (hyphen). </p>', 'DeleteDomainRequest$DomainName' => '<p>The name of the domain you want to permanently delete.</p>', 'DescribeDomainAutoTunesRequest$DomainName' => '<p>The domain name for which you want Auto-Tune action details.</p>', 'DescribeDomainChangeProgressRequest$DomainName' => '<p>The domain you want to get the progress information about.</p>', 'DescribeDomainConfigRequest$DomainName' => '<p>The domain you want to get information about.</p>', 'DescribeDomainRequest$DomainName' => '<p>The name of the domain for which you want information.</p>', 'DescribeInstanceTypeLimitsRequest$DomainName' => '<p> The name of the domain you want to modify. Only include this value if you\'re querying OpenSearch <code> <a>Limits</a> </code> for an existing domain. </p>', 'DissociatePackageRequest$DomainName' => '<p>The name of the domain to associate the package with.</p>', 'DomainInfo$DomainName' => '<p>The <code>DomainName</code>. </p>', 'DomainNameList$member' => NULL, 'DomainPackageDetails$DomainName' => '<p>The name of the domain you\'ve associated a package with.</p>', 'DomainStatus$DomainName' => '<p>The name of a domain. Domain names are unique across the domains owned by an account within an AWS region. Domain names start with a letter or number and can contain the following characters: a-z (lowercase), 0-9, and - (hyphen). </p>', 'GetCompatibleVersionsRequest$DomainName' => NULL, 'GetUpgradeHistoryRequest$DomainName' => NULL, 'GetUpgradeStatusRequest$DomainName' => NULL, 'ListInstanceTypeDetailsRequest$DomainName' => NULL, 'ListPackagesForDomainRequest$DomainName' => '<p>The name of the domain for which you want to list associated packages.</p>', 'StartServiceSoftwareUpdateRequest$DomainName' => '<p>The name of the domain that you want to update to the latest service software.</p>', 'UpdateDomainConfigRequest$DomainName' => '<p>The name of the domain you\'re updating.</p>', 'UpgradeDomainRequest$DomainName' => NULL, 'UpgradeDomainResponse$DomainName' => NULL, ], ], 'DomainNameFqdn' => [ 'base' => NULL, 'refs' => [ 'DomainEndpointOptions$CustomEndpoint' => '<p>The fully qualified domain for your custom endpoint.</p>', ], ], 'DomainNameList' => [ 'base' => '<p>A list of domain names.</p>', 'refs' => [ 'DescribeDomainsRequest$DomainNames' => '<p>The domains for which you want information.</p>', ], ], 'DomainPackageDetails' => [ 'base' => '<p>Information on a package associated with a domain.</p>', 'refs' => [ 'AssociatePackageResponse$DomainPackageDetails' => '<p> <code>DomainPackageDetails</code> </p>', 'DissociatePackageResponse$DomainPackageDetails' => '<p> <code>DomainPackageDetails</code> </p>', 'DomainPackageDetailsList$member' => NULL, ], ], 'DomainPackageDetailsList' => [ 'base' => NULL, 'refs' => [ 'ListDomainsForPackageResponse$DomainPackageDetailsList' => '<p>List of <code>DomainPackageDetails</code> objects. </p>', 'ListPackagesForDomainResponse$DomainPackageDetailsList' => '<p>List of <code>DomainPackageDetails</code> objects. </p>', ], ], 'DomainPackageStatus' => [ 'base' => NULL, 'refs' => [ 'DomainPackageDetails$DomainPackageStatus' => '<p>State of the association. Values are ASSOCIATING, ASSOCIATION_FAILED, ACTIVE, DISSOCIATING, and DISSOCIATION_FAILED.</p>', ], ], 'DomainStatus' => [ 'base' => '<p>The current status of a domain.</p>', 'refs' => [ 'CreateDomainResponse$DomainStatus' => '<p>The status of the newly created domain.</p>', 'DeleteDomainResponse$DomainStatus' => '<p>The status of the domain being deleted.</p>', 'DescribeDomainResponse$DomainStatus' => '<p>The current status of the domain.</p>', 'DomainStatusList$member' => NULL, ], ], 'DomainStatusList' => [ 'base' => '<p>A list that contains the status of each requested domain.</p>', 'refs' => [ 'DescribeDomainsResponse$DomainStatusList' => '<p>The status of the domains requested in the <code>DescribeDomains</code> request. </p>', ], ], 'Double' => [ 'base' => NULL, 'refs' => [ 'RecurringCharge$RecurringChargeAmount' => '<p>The monetary amount of the recurring charge.</p>', 'ReservedInstance$FixedPrice' => '<p>The upfront fixed charge you will paid to purchase the specific reserved OpenSearch instance offering.</p>', 'ReservedInstance$UsagePrice' => '<p>The rate you are charged for each hour for the domain that is using this reserved instance.</p>', 'ReservedInstanceOffering$FixedPrice' => '<p>The upfront fixed charge you will pay to purchase the specific reserved OpenSearch instance offering.</p>', 'ReservedInstanceOffering$UsagePrice' => '<p>The rate you are charged for each hour the domain that is using the offering is running.</p>', 'UpgradeStepItem$ProgressPercent' => '<p>The floating point value representing the progress percentage of a particular step.</p>', ], ], 'DryRun' => [ 'base' => NULL, 'refs' => [ 'UpdateDomainConfigRequest$DryRun' => '<p>This flag, when set to True, specifies whether the <code>UpdateDomain</code> request should return the results of validation checks (DryRunResults) without actually applying the change.</p>', ], ], 'DryRunResults' => [ 'base' => NULL, 'refs' => [ 'UpdateDomainConfigResponse$DryRunResults' => '<p>Contains result of DryRun. </p>', ], ], 'Duration' => [ 'base' => '<p>The maintenance schedule duration: duration value and duration unit. See <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/auto-tune.html" target="_blank"> Auto-Tune for Amazon OpenSearch Service </a> for more information. </p>', 'refs' => [ 'AutoTuneMaintenanceSchedule$Duration' => '<p>Specifies maintenance schedule duration: duration value and duration unit. See <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/auto-tune.html" target="_blank"> Auto-Tune for Amazon OpenSearch Service </a> for more information. </p>', ], ], 'DurationValue' => [ 'base' => '<p>Integer to specify the value of a maintenance schedule duration. See <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/auto-tune.html" target="_blank"> Auto-Tune for Amazon OpenSearch Service </a> for more information. </p>', 'refs' => [ 'Duration$Value' => '<p>Integer to specify the value of a maintenance schedule duration. See <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/auto-tune.html" target="_blank"> Auto-Tune for Amazon OpenSearch Service </a> for more information. </p>', ], ], 'EBSOptions' => [ 'base' => '<p>Options to enable, disable, and specify the properties of EBS storage volumes.</p>', 'refs' => [ 'CreateDomainRequest$EBSOptions' => '<p>Options to enable, disable, and specify the type and size of EBS storage volumes.</p>', 'DomainStatus$EBSOptions' => '<p>The <code>EBSOptions</code> for the specified domain. </p>', 'EBSOptionsStatus$Options' => '<p>The EBS options for the specified domain.</p>', 'UpdateDomainConfigRequest$EBSOptions' => '<p>Specify the type and size of the EBS volume to use.</p>', ], ], 'EBSOptionsStatus' => [ 'base' => '<p>Status of the EBS options for the specified domain.</p>', 'refs' => [ 'DomainConfig$EBSOptions' => '<p>The <code>EBSOptions</code> for the domain. </p>', ], ], 'EncryptionAtRestOptions' => [ 'base' => '<p>Specifies encryption at rest options.</p>', 'refs' => [ 'CreateDomainRequest$EncryptionAtRestOptions' => '<p>Options for encryption of data at rest.</p>', 'DomainStatus$EncryptionAtRestOptions' => '<p>The status of the <code>EncryptionAtRestOptions</code>. </p>', 'EncryptionAtRestOptionsStatus$Options' => '<p>The Encryption At Rest options for the specified domain.</p>', 'UpdateDomainConfigRequest$EncryptionAtRestOptions' => '<p>Specifies encryption of data at rest options.</p>', ], ], 'EncryptionAtRestOptionsStatus' => [ 'base' => '<p>Status of the encryption At Rest options for the specified domain.</p>', 'refs' => [ 'DomainConfig$EncryptionAtRestOptions' => '<p>The <code>EncryptionAtRestOptions</code> for the domain. </p>', ], ], 'EndpointsMap' => [ 'base' => NULL, 'refs' => [ 'DomainStatus$Endpoints' => '<p>Map containing the domain endpoints used to submit index and search requests. Example <code>key, value</code>: <code>\'vpc\',\'vpc-endpoint-h2dsd34efgyghrtguk5gt6j2foh4.us-east-1.es.amazonaws.com\'</code>. </p>', ], ], 'EngineType' => [ 'base' => NULL, 'refs' => [ 'DomainInfo$EngineType' => '<p> Specifies the <code>EngineType</code> of the domain.</p>', 'ListDomainNamesRequest$EngineType' => '<p> Optional parameter to filter the output by domain engine type. Acceptable values are \'Elasticsearch\' and \'OpenSearch\'. </p>', ], ], 'ErrorDetails' => [ 'base' => NULL, 'refs' => [ 'DomainPackageDetails$ErrorDetails' => '<p>Additional information if the package is in an error state. Null otherwise.</p>', 'PackageDetails$ErrorDetails' => '<p>Additional information if the package is in an error state. Null otherwise.</p>', ], ], 'ErrorMessage' => [ 'base' => NULL, 'refs' => [ 'BaseException$message' => '<p>A description of the error.</p>', 'ErrorDetails$ErrorMessage' => NULL, ], ], 'ErrorType' => [ 'base' => NULL, 'refs' => [ 'ErrorDetails$ErrorType' => NULL, ], ], 'Filter' => [ 'base' => '<p> A filter used to limit results when describing inbound or outbound cross-cluster connections. Multiple values can be specified per filter. A cross-cluster connection must match at least one of the specified values for it to be returned from an operation. </p>', 'refs' => [ 'FilterList$member' => NULL, ], ], 'FilterList' => [ 'base' => NULL, 'refs' => [ 'DescribeInboundConnectionsRequest$Filters' => '<p> A list of filters used to match properties for inbound cross-cluster connections. Available <code> <a>Filter</a> </code> values are: <ul> <li>connection-id</li> <li>local-domain-info.domain-name</li> <li>local-domain-info.owner-id</li> <li>local-domain-info.region</li> <li>remote-domain-info.domain-name</li> </ul> </p>', 'DescribeOutboundConnectionsRequest$Filters' => '<p> A list of filters used to match properties for outbound cross-cluster connections. Available <code> <a>Filter</a> </code> names for this operation are: <ul> <li>connection-id</li> <li>remote-domain-info.domain-name</li> <li>remote-domain-info.owner-id</li> <li>remote-domain-info.region</li> <li>local-domain-info.domain-name</li> </ul> </p>', ], ], 'GUID' => [ 'base' => NULL, 'refs' => [ 'ChangeProgressDetails$ChangeId' => '<p>The unique change identifier associated with a specific domain configuration change.</p>', 'ChangeProgressStatusDetails$ChangeId' => '<p>The unique change identifier associated with a specific domain configuration change.</p>', 'DescribeDomainChangeProgressRequest$ChangeId' => '<p>The specific change ID for which you want to get progress information. This is an optional parameter. If omitted, the service returns information about the most recent configuration change. </p>', 'DescribeReservedInstanceOfferingsRequest$ReservedInstanceOfferingId' => '<p>The offering identifier filter value. Use this parameter to show only the available offering that matches the specified reservation identifier. </p>', 'DescribeReservedInstancesRequest$ReservedInstanceId' => '<p>The reserved instance identifier filter value. Use this parameter to show only the reservation that matches the specified reserved OpenSearch instance ID. </p>', 'PurchaseReservedInstanceOfferingRequest$ReservedInstanceOfferingId' => '<p>The ID of the reserved OpenSearch instance offering to purchase.</p>', 'PurchaseReservedInstanceOfferingResponse$ReservedInstanceId' => '<p>Details of the reserved OpenSearch instance which was purchased.</p>', 'ReservedInstance$ReservedInstanceId' => '<p>The unique identifier for the reservation.</p>', 'ReservedInstanceOffering$ReservedInstanceOfferingId' => '<p>The OpenSearch reserved instance offering identifier.</p>', ], ], 'GetCompatibleVersionsRequest' => [ 'base' => '<p> Container for the request parameters to <code> <a>GetCompatibleVersions</a> </code> operation. </p>', 'refs' => [], ], 'GetCompatibleVersionsResponse' => [ 'base' => '<p> Container for the response returned by the <code> <a>GetCompatibleVersions</a> </code> operation. </p>', 'refs' => [], ], 'GetPackageVersionHistoryRequest' => [ 'base' => '<p> Container for the request parameters to the <code> <a>GetPackageVersionHistory</a> </code> operation. </p>', 'refs' => [], ], 'GetPackageVersionHistoryResponse' => [ 'base' => '<p> Container for response returned by <code> <a>GetPackageVersionHistory</a> </code> operation. </p>', 'refs' => [], ], 'GetUpgradeHistoryRequest' => [ 'base' => '<p> Container for the request parameters to the <code> <a>GetUpgradeHistory</a> </code> operation. </p>', 'refs' => [], ], 'GetUpgradeHistoryResponse' => [ 'base' => '<p> Container for the response returned by the <code> <a>GetUpgradeHistory</a> </code> operation. </p>', 'refs' => [], ], 'GetUpgradeStatusRequest' => [ 'base' => '<p> Container for the request parameters to the <code> <a>GetUpgradeStatus</a> </code> operation. </p>', 'refs' => [], ], 'GetUpgradeStatusResponse' => [ 'base' => '<p> Container for the response returned by the <code> <a>GetUpgradeStatus</a> </code> operation. </p>', 'refs' => [], ], 'IdentityPoolId' => [ 'base' => NULL, 'refs' => [ 'CognitoOptions$IdentityPoolId' => '<p>The Cognito identity pool ID for OpenSearch Dashboards authentication.</p>', ], ], 'InboundConnection' => [ 'base' => '<p>Details of an inbound connection.</p>', 'refs' => [ 'AcceptInboundConnectionResponse$Connection' => '<p>The <code> <a>InboundConnection</a> </code> of the accepted inbound connection. </p>', 'DeleteInboundConnectionResponse$Connection' => '<p>The <code> <a>InboundConnection</a> </code> of the deleted inbound connection. </p>', 'InboundConnections$member' => NULL, 'RejectInboundConnectionResponse$Connection' => '<p>The <code> <a>InboundConnection</a> </code> of the rejected inbound connection. </p>', ], ], 'InboundConnectionStatus' => [ 'base' => '<p>The connection status of an inbound cross-cluster connection.</p>', 'refs' => [ 'InboundConnection$ConnectionStatus' => '<p>The <code> <a>InboundConnectionStatus</a> </code> for the outbound connection. </p>', ], ], 'InboundConnectionStatusCode' => [ 'base' => NULL, 'refs' => [ 'InboundConnectionStatus$StatusCode' => '<p>The state code for the inbound connection. Can be one of the following:</p> <ul> <li>PENDING_ACCEPTANCE: Inbound connection is not yet accepted by the remote domain owner.</li> <li>APPROVED: Inbound connection is pending acceptance by the remote domain owner.</li> <li>PROVISIONING: Inbound connection provisioning is in progress.</li> <li>ACTIVE: Inbound connection is active and ready to use.</li> <li>REJECTING: Inbound connection rejection is in process.</li> <li>REJECTED: Inbound connection is rejected.</li> <li>DELETING: Inbound connection deletion is in progress.</li> <li>DELETED: Inbound connection is deleted and can no longer be used.</li> </ul>', ], ], 'InboundConnections' => [ 'base' => NULL, 'refs' => [ 'DescribeInboundConnectionsResponse$Connections' => '<p>A list of <code> <a>InboundConnection</a> </code> matching the specified filter criteria. </p>', ], ], 'InstanceCount' => [ 'base' => '<p>The number of EC2 instances in the domain.</p>', 'refs' => [ 'PurchaseReservedInstanceOfferingRequest$InstanceCount' => '<p>The number of OpenSearch instances to reserve.</p>', ], ], 'InstanceCountLimits' => [ 'base' => '<p> InstanceCountLimits represents the limits on the number of instances that can be created in Amazon OpenSearch Service for a given InstanceType. </p>', 'refs' => [ 'InstanceLimits$InstanceCountLimits' => NULL, ], ], 'InstanceLimits' => [ 'base' => '<p>InstanceLimits represents the list of instance-related attributes that are available for a given InstanceType. </p>', 'refs' => [ 'Limits$InstanceLimits' => NULL, ], ], 'InstanceRole' => [ 'base' => NULL, 'refs' => [ 'InstanceRoleList$member' => NULL, 'LimitsByRole$key' => NULL, ], ], 'InstanceRoleList' => [ 'base' => NULL, 'refs' => [ 'InstanceTypeDetails$InstanceRole' => NULL, ], ], 'InstanceTypeDetails' => [ 'base' => NULL, 'refs' => [ 'InstanceTypeDetailsList$member' => NULL, ], ], 'InstanceTypeDetailsList' => [ 'base' => NULL, 'refs' => [ 'ListInstanceTypeDetailsResponse$InstanceTypeDetails' => NULL, ], ], 'Integer' => [ 'base' => NULL, 'refs' => [ 'ReservedInstance$Duration' => '<p>The duration, in seconds, for which the OpenSearch instance is reserved.</p>', 'ReservedInstance$InstanceCount' => '<p>The number of OpenSearch instances that have been reserved.</p>', 'ReservedInstanceOffering$Duration' => '<p>The duration, in seconds, for which the offering will reserve the OpenSearch instance.</p>', ], ], 'IntegerClass' => [ 'base' => NULL, 'refs' => [ 'ClusterConfig$InstanceCount' => '<p>The number of instances in the specified domain cluster.</p>', 'ClusterConfig$DedicatedMasterCount' => '<p>Total number of dedicated master nodes, active and on standby, for the cluster.</p>', 'ClusterConfig$WarmCount' => '<p>The number of UltraWarm nodes in the cluster.</p>', 'EBSOptions$VolumeSize' => '<p>Integer to specify the size of an EBS volume.</p>', 'EBSOptions$Iops' => '<p>The IOPD for a Provisioned IOPS EBS volume (SSD).</p>', 'SAMLOptionsInput$SessionTimeoutMinutes' => '<p>The duration, in minutes, after which a user session becomes inactive. Acceptable values are between 1 and 1440, and the default value is 60. </p>', 'SAMLOptionsOutput$SessionTimeoutMinutes' => '<p>The duration, in minutes, after which a user session becomes inactive.</p>', 'SnapshotOptions$AutomatedSnapshotStartHour' => '<p>The time, in UTC format, when the service takes a daily automated snapshot of the specified domain. Default is <code>0</code> hours. </p>', 'ZoneAwarenessConfig$AvailabilityZoneCount' => '<p>An integer value to indicate the number of availability zones for a domain when zone awareness is enabled. This should be equal to number of subnets if VPC endpoints is enabled. </p>', ], ], 'InternalException' => [ 'base' => '<p>The request processing has failed because of an unknown error, exception or failure (the failure is internal to the service) . Gives http status code of 500.</p>', 'refs' => [], ], 'InvalidPaginationTokenException' => [ 'base' => '<p>The request processing has failed because of invalid pagination token provided by customer. Returns an HTTP status code of 400. </p>', 'refs' => [], ], 'InvalidTypeException' => [ 'base' => '<p>An exception for trying to create or access sub-resource that is either invalid or not supported. Gives http status code of 409.</p>', 'refs' => [], ], 'Issue' => [ 'base' => NULL, 'refs' => [ 'Issues$member' => NULL, ], ], 'Issues' => [ 'base' => NULL, 'refs' => [ 'UpgradeStepItem$Issues' => '<p>A list of strings containing detailed information about the errors encountered in a particular step.</p>', ], ], 'KmsKeyId' => [ 'base' => NULL, 'refs' => [ 'EncryptionAtRestOptions$KmsKeyId' => '<p>The KMS key ID for encryption at rest options.</p>', ], ], 'LastUpdated' => [ 'base' => NULL, 'refs' => [ 'ChangeProgressStage$LastUpdated' => '<p>The last updated timestamp of the progress stage.</p>', 'DomainPackageDetails$LastUpdated' => '<p>The timestamp of the most recent update to the package association status.</p>', 'PackageDetails$LastUpdatedAt' => NULL, ], ], 'LimitExceededException' => [ 'base' => '<p>An exception for trying to create more than allowed resources or sub-resources. Gives http status code of 409.</p>', 'refs' => [], ], 'LimitName' => [ 'base' => NULL, 'refs' => [ 'AdditionalLimit$LimitName' => '<p> Additional limit is specific to a given InstanceType and for each of its <code> <a>InstanceRole</a> </code> etc. <br/> Attributes and their details: <br/> <ul> <li>MaximumNumberOfDataNodesSupported</li> This attribute is present on the master node only to specify how much data nodes up to which given <code> <a>ESPartitionInstanceType</a> </code> can support as master node. <li>MaximumNumberOfDataNodesWithoutMasterNode</li> This attribute is present on data node only to specify how much data nodes of given <code> <a>ESPartitionInstanceType</a> </code> up to which you don\'t need any master nodes to govern them. </ul> </p>', 'StorageTypeLimit$LimitName' => '<p> Name of storage limits that are applicable for the given storage type. If <code> <a>StorageType</a> </code> is "ebs", the following storage options are applicable: <ol> <li>MinimumVolumeSize</li> Minimum amount of volume size that is applicable for the given storage type. Can be empty if not applicable. <li>MaximumVolumeSize</li> Maximum amount of volume size that is applicable for the given storage type. Can be empty if not applicable. <li>MaximumIops</li> Maximum amount of Iops that is applicable for given the storage type. Can be empty if not applicable. <li>MinimumIops</li> Minimum amount of Iops that is applicable for given the storage type. Can be empty if not applicable. </ol> </p>', ], ], 'LimitValue' => [ 'base' => NULL, 'refs' => [ 'LimitValueList$member' => NULL, ], ], 'LimitValueList' => [ 'base' => NULL, 'refs' => [ 'AdditionalLimit$LimitValues' => '<p> Value for a given <code> <a>AdditionalLimit$LimitName</a> </code> . </p>', 'StorageTypeLimit$LimitValues' => '<p> Values for the <code> <a>StorageTypeLimit$LimitName</a> </code> . </p>', ], ], 'Limits' => [ 'base' => '<p> Limits for a given InstanceType and for each of its roles. <br/> Limits contains the following: <code> <a>StorageTypes</a> </code>, <code> <a>InstanceLimits</a> </code>, and <code> <a>AdditionalLimits</a> </code> </p>', 'refs' => [ 'LimitsByRole$value' => NULL, ], ], 'LimitsByRole' => [ 'base' => '<p> The role of a given instance and all applicable limits. The role performed by a given OpenSearch instance can be one of the following: <ul> <li>data: If the given InstanceType is used as a data node</li> <li>master: If the given InstanceType is used as a master node</li> <li>ultra_warm: If the given InstanceType is used as a warm node</li> </ul> </p>', 'refs' => [ 'DescribeInstanceTypeLimitsResponse$LimitsByRole' => NULL, ], ], 'ListDomainNamesRequest' => [ 'base' => '<p> Container for the parameters to the <code><a>ListDomainNames</a></code> operation.</p>', 'refs' => [], ], 'ListDomainNamesResponse' => [ 'base' => '<p>The result of a <code>ListDomainNames</code> operation. Contains the names of all domains owned by this account and their respective engine types.</p>', 'refs' => [], ], 'ListDomainsForPackageRequest' => [ 'base' => '<p> Container for the request parameters to the <code> <a>ListDomainsForPackage</a> </code> operation. </p>', 'refs' => [], ], 'ListDomainsForPackageResponse' => [ 'base' => '<p> Container for the response parameters to the <code> <a>ListDomainsForPackage</a> </code> operation. </p>', 'refs' => [], ], 'ListInstanceTypeDetailsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListInstanceTypeDetailsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListPackagesForDomainRequest' => [ 'base' => '<p> Container for the request parameters to the <code> <a>ListPackagesForDomain</a> </code> operation. </p>', 'refs' => [], ], 'ListPackagesForDomainResponse' => [ 'base' => '<p> Container for the response parameters to the <code> <a>ListPackagesForDomain</a> </code> operation. </p>', 'refs' => [], ], 'ListTagsRequest' => [ 'base' => '<p>Container for the parameters to the <code> <a>ListTags</a> </code> operation. Specify the <code>ARN</code> of the domain that the tags you want to view are attached to. </p>', 'refs' => [], ], 'ListTagsResponse' => [ 'base' => '<p>The result of a <code>ListTags</code> operation. Contains tags for all requested domains. </p>', 'refs' => [], ], 'ListVersionsRequest' => [ 'base' => '<p> Container for the parameters to the <code> <a>ListVersions</a> </code> operation. <p> Use <code> <a>MaxResults</a> </code> to control the maximum number of results to retrieve in a single call. </p> <p> Use <code> <a>NextToken</a> </code> in response to retrieve more results. If the received response does not contain a NextToken, there are no more results to retrieve. </p> </p>', 'refs' => [], ], 'ListVersionsResponse' => [ 'base' => '<p> Container for the parameters for response received from the <code> <a>ListVersions</a> </code> operation. </p>', 'refs' => [], ], 'LogPublishingOption' => [ 'base' => '<p>Log Publishing option that is set for a given domain. <br/>Attributes and their details: <ul> <li>CloudWatchLogsLogGroupArn: ARN of the Cloudwatch log group to publish logs to.</li> <li>Enabled: Whether the log publishing for a given log type is enabled or not.</li> </ul> </p>', 'refs' => [ 'LogPublishingOptions$value' => NULL, ], ], 'LogPublishingOptions' => [ 'base' => NULL, 'refs' => [ 'CreateDomainRequest$LogPublishingOptions' => '<p>Map of <code>LogType</code> and <code>LogPublishingOption</code>, each containing options to publish a given type of OpenSearch log. </p>', 'DomainStatus$LogPublishingOptions' => '<p>Log publishing options for the given domain.</p>', 'LogPublishingOptionsStatus$Options' => '<p>The log publishing options configured for the domain.</p>', 'UpdateDomainConfigRequest$LogPublishingOptions' => '<p>Map of <code>LogType</code> and <code>LogPublishingOption</code>, each containing options to publish a given type of OpenSearch log. </p>', ], ], 'LogPublishingOptionsStatus' => [ 'base' => '<p>The configured log publishing options for the domain and their current status.</p>', 'refs' => [ 'DomainConfig$LogPublishingOptions' => '<p>Log publishing options for the given domain.</p>', ], ], 'LogType' => [ 'base' => '<p>Type of log file. Can be one of the following: <ul> <li>INDEX_SLOW_LOGS: Index slow logs contain insert requests that took more time than configured index query log threshold to execute. </li> <li>SEARCH_SLOW_LOGS: Search slow logs contain search queries that took more time than configured search query log threshold to execute. </li> <li>ES_APPLICATION_LOGS: OpenSearch application logs contain information about errors and warnings raised during the operation of the service and can be useful for troubleshooting. </li> <li>AUDIT_LOGS: Audit logs contain records of user requests for access from the domain.</li> </ul> </p>', 'refs' => [ 'LogPublishingOptions$key' => NULL, ], ], 'Long' => [ 'base' => NULL, 'refs' => [ 'ReservedInstance$BillingSubscriptionId' => NULL, ], ], 'MasterUserOptions' => [ 'base' => '<p>Credentials for the master user: username and password, ARN, or both.</p>', 'refs' => [ 'AdvancedSecurityOptionsInput$MasterUserOptions' => '<p>Credentials for the master user: username and password, ARN, or both.</p>', ], ], 'MaxResults' => [ 'base' => '<p> Set this value to limit the number of results returned. </p>', 'refs' => [ 'DescribeDomainAutoTunesRequest$MaxResults' => '<p>Set this value to limit the number of results returned. If not specified, defaults to 100.</p>', 'DescribeInboundConnectionsRequest$MaxResults' => '<p>Set this value to limit the number of results returned. If not specified, defaults to 100.</p>', 'DescribeOutboundConnectionsRequest$MaxResults' => '<p>Set this value to limit the number of results returned. If not specified, defaults to 100.</p>', 'DescribePackagesRequest$MaxResults' => '<p>Limits results to a maximum number of packages.</p>', 'DescribeReservedInstanceOfferingsRequest$MaxResults' => '<p>Set this value to limit the number of results returned. If not specified, defaults to 100.</p>', 'DescribeReservedInstancesRequest$MaxResults' => '<p>Set this value to limit the number of results returned. If not specified, defaults to 100.</p>', 'GetPackageVersionHistoryRequest$MaxResults' => '<p>Limits results to a maximum number of package versions.</p>', 'GetUpgradeHistoryRequest$MaxResults' => NULL, 'ListDomainsForPackageRequest$MaxResults' => '<p>Limits the results to a maximum number of domains.</p>', 'ListInstanceTypeDetailsRequest$MaxResults' => NULL, 'ListPackagesForDomainRequest$MaxResults' => '<p>Limits results to a maximum number of packages.</p>', 'ListVersionsRequest$MaxResults' => '<p> Set this value to limit the number of results returned. Value must be greater than 10 or it won\'t be honored. </p>', ], ], 'MaximumInstanceCount' => [ 'base' => '<p> Maximum number of instances that can be instantiated for a given InstanceType. </p>', 'refs' => [ 'InstanceCountLimits$MaximumInstanceCount' => NULL, ], ], 'Message' => [ 'base' => NULL, 'refs' => [ 'ChangeProgressDetails$Message' => '<p>Contains an optional message associated with the domain configuration change.</p>', 'DryRunResults$Message' => '<p>Contains an optional message associated with the DryRunResults.</p>', ], ], 'MinimumInstanceCount' => [ 'base' => '<p> Minimum number of instances that can be instantiated for a given InstanceType. </p>', 'refs' => [ 'InstanceCountLimits$MinimumInstanceCount' => NULL, ], ], 'NextToken' => [ 'base' => '<p> Paginated APIs accept the NextToken input to return the next page of results and provide a NextToken output in the response, which you can use to retrieve more results. </p>', 'refs' => [ 'DescribeDomainAutoTunesRequest$NextToken' => '<p>NextToken is sent in case the earlier API call results contain the NextToken. Used for pagination.</p>', 'DescribeDomainAutoTunesResponse$NextToken' => '<p>An identifier to allow retrieval of paginated results.</p>', 'DescribeInboundConnectionsRequest$NextToken' => '<p>If more results are available and NextToken is present, make the next request to the same API with the received NextToken to paginate the remaining results.</p>', 'DescribeInboundConnectionsResponse$NextToken' => '<p>If more results are available and NextToken is present, make the next request to the same API with the received NextToken to paginate the remaining results. </p>', 'DescribeOutboundConnectionsRequest$NextToken' => '<p>NextToken is sent in case the earlier API call results contain the NextToken parameter. Used for pagination.</p>', 'DescribeOutboundConnectionsResponse$NextToken' => '<p>If more results are available and NextToken is present, make the next request to the same API with the received NextToken to paginate the remaining results. </p>', 'DescribePackagesRequest$NextToken' => '<p>Used for pagination. Only necessary if a previous API call includes a non-null NextToken value. If provided, returns results for the next page. </p>', 'DescribeReservedInstanceOfferingsRequest$NextToken' => '<p>Provides an identifier to allow retrieval of paginated results. </p>', 'DescribeReservedInstanceOfferingsResponse$NextToken' => '<p>Provides an identifier to allow retrieval of paginated results.</p>', 'DescribeReservedInstancesRequest$NextToken' => '<p>Provides an identifier to allow retrieval of paginated results. </p>', 'GetPackageVersionHistoryRequest$NextToken' => '<p>Used for pagination. Only necessary if a previous API call includes a non-null NextToken value. If provided, returns results for the next page. </p>', 'GetUpgradeHistoryRequest$NextToken' => NULL, 'ListDomainsForPackageRequest$NextToken' => '<p>Used for pagination. Only necessary if a previous API call includes a non-null NextToken value. If provided, returns results for the next page. </p>', 'ListInstanceTypeDetailsRequest$NextToken' => NULL, 'ListInstanceTypeDetailsResponse$NextToken' => NULL, 'ListPackagesForDomainRequest$NextToken' => '<p>Used for pagination. Only necessary if a previous API call includes a non-null NextToken value. If provided, returns results for the next page. </p>', 'ListVersionsRequest$NextToken' => NULL, 'ListVersionsResponse$NextToken' => NULL, ], ], 'NodeToNodeEncryptionOptions' => [ 'base' => '<p>The node-to-node encryption options.</p>', 'refs' => [ 'CreateDomainRequest$NodeToNodeEncryptionOptions' => '<p>Node-to-node encryption options.</p>', 'DomainStatus$NodeToNodeEncryptionOptions' => '<p>The status of the <code>NodeToNodeEncryptionOptions</code>. </p>', 'NodeToNodeEncryptionOptionsStatus$Options' => '<p>The node-to-node encryption options for the specified domain.</p>', 'UpdateDomainConfigRequest$NodeToNodeEncryptionOptions' => '<p>Specifies node-to-node encryption options.</p>', ], ], 'NodeToNodeEncryptionOptionsStatus' => [ 'base' => '<p>Status of the node-to-node encryption options for the specified domain.</p>', 'refs' => [ 'DomainConfig$NodeToNodeEncryptionOptions' => '<p>The <code>NodeToNodeEncryptionOptions</code> for the domain. </p>', ], ], 'NonEmptyString' => [ 'base' => NULL, 'refs' => [ 'Filter$Name' => '<p> The name of the filter. </p>', 'ValueStringList$member' => NULL, ], ], 'OpenSearchPartitionInstanceType' => [ 'base' => NULL, 'refs' => [ 'ClusterConfig$InstanceType' => '<p>The instance type for an OpenSearch cluster. UltraWarm instance types are not supported for data instances. </p>', 'ClusterConfig$DedicatedMasterType' => '<p>The instance type for a dedicated master node.</p>', 'DescribeInstanceTypeLimitsRequest$InstanceType' => '<p> The instance type for an OpenSearch cluster for which OpenSearch <code> <a>Limits</a> </code> are needed. </p>', 'InstanceTypeDetails$InstanceType' => NULL, 'ReservedInstance$InstanceType' => '<p>The OpenSearch instance type offered by the reserved instance offering.</p>', 'ReservedInstanceOffering$InstanceType' => '<p>The OpenSearch instance type offered by the reserved instance offering.</p>', ], ], 'OpenSearchWarmPartitionInstanceType' => [ 'base' => NULL, 'refs' => [ 'ClusterConfig$WarmType' => '<p>The instance type for the OpenSearch cluster\'s warm nodes.</p>', ], ], 'OptionState' => [ 'base' => '<p>The state of a requested change. One of the following:</p> <ul> <li>Processing: The request change is still in progress.</li> <li>Active: The request change is processed and deployed to the domain.</li> </ul>', 'refs' => [ 'OptionStatus$State' => '<p>Provides the <code>OptionState</code> for the domain. </p>', ], ], 'OptionStatus' => [ 'base' => '<p>Provides the current status of the entity.</p>', 'refs' => [ 'AccessPoliciesStatus$Status' => '<p>The status of the access policy for the domain. See <code>OptionStatus</code> for the status information that\'s included. </p>', 'AdvancedOptionsStatus$Status' => '<p>The <code>OptionStatus</code> for advanced options for the specified domain. </p>', 'AdvancedSecurityOptionsStatus$Status' => '<p>Status of the advanced security options for the specified domain.</p>', 'ClusterConfigStatus$Status' => '<p>The cluster configuration status for the specified domain.</p>', 'CognitoOptionsStatus$Status' => '<p>The status of the Cognito options for the specified domain.</p>', 'DomainEndpointOptionsStatus$Status' => '<p>The status of the endpoint options for the domain. See <code>OptionStatus</code> for the status information that\'s included. </p>', 'EBSOptionsStatus$Status' => '<p>The status of the EBS options for the specified domain.</p>', 'EncryptionAtRestOptionsStatus$Status' => '<p>The status of the Encryption At Rest options for the specified domain.</p>', 'LogPublishingOptionsStatus$Status' => '<p>The status of the log publishing options for the domain. See <code>OptionStatus</code> for the status information that\'s included. </p>', 'NodeToNodeEncryptionOptionsStatus$Status' => '<p>The status of the node-to-node encryption options for the specified domain.</p>', 'SnapshotOptionsStatus$Status' => '<p>The status of a daily automated snapshot.</p>', 'VPCDerivedInfoStatus$Status' => '<p>The status of the VPC options for the specified domain.</p>', 'VersionStatus$Status' => '<p>The status of the OpenSearch version options for the specified OpenSearch domain.</p>', ], ], 'OutboundConnection' => [ 'base' => '<p>Specifies details about an outbound connection.</p>', 'refs' => [ 'DeleteOutboundConnectionResponse$Connection' => '<p>The <code> <a>OutboundConnection</a> </code> of the deleted outbound connection. </p>', 'OutboundConnections$member' => NULL, ], ], 'OutboundConnectionStatus' => [ 'base' => '<p>The connection status of an outbound cross-cluster connection.</p>', 'refs' => [ 'CreateOutboundConnectionResponse$ConnectionStatus' => '<p>The <code> <a>OutboundConnectionStatus</a> </code> for the newly created connection. </p>', 'OutboundConnection$ConnectionStatus' => '<p>The <code> <a>OutboundConnectionStatus</a> </code> for the outbound connection. </p>', ], ], 'OutboundConnectionStatusCode' => [ 'base' => NULL, 'refs' => [ 'OutboundConnectionStatus$StatusCode' => '<p>The state code for the outbound connection. Can be one of the following:</p> <ul> <li>VALIDATING: The outbound connection request is being validated.</li> <li>VALIDATION_FAILED: Validation failed for the connection request.</li> <li>PENDING_ACCEPTANCE: Outbound connection request is validated and is not yet accepted by the remote domain owner. </li> <li>APPROVED: Outbound connection has been approved by the remote domain owner for getting provisioned.</li> <li>PROVISIONING: Outbound connection request is in process.</li> <li>ACTIVE: Outbound connection is active and ready to use.</li> <li>REJECTING: Outbound connection rejection by remote domain owner is in progress.</li> <li>REJECTED: Outbound connection request is rejected by remote domain owner.</li> <li>DELETING: Outbound connection deletion is in progress.</li> <li>DELETED: Outbound connection is deleted and can no longer be used.</li> </ul>', ], ], 'OutboundConnections' => [ 'base' => NULL, 'refs' => [ 'DescribeOutboundConnectionsResponse$Connections' => '<p>A list of <code> <a>OutboundConnection</a> </code> matching the specified filter criteria. </p>', ], ], 'OverallChangeStatus' => [ 'base' => '<p>The overall status value of the domain configuration change.</p>', 'refs' => [ 'ChangeProgressStatusDetails$Status' => '<p>The overall status of the domain configuration change. This field can take the following values: <code>PENDING</code>, <code>PROCESSING</code>, <code>COMPLETED</code> and <code>FAILED</code></p>', ], ], 'OwnerId' => [ 'base' => NULL, 'refs' => [ 'AWSDomainInformation$OwnerId' => NULL, ], ], 'PackageDescription' => [ 'base' => NULL, 'refs' => [ 'CreatePackageRequest$PackageDescription' => '<p>Description of the package.</p>', 'PackageDetails$PackageDescription' => '<p>User-specified description of the package.</p>', 'UpdatePackageRequest$PackageDescription' => '<p>A new description of the package.</p>', ], ], 'PackageDetails' => [ 'base' => '<p>Basic information about a package.</p>', 'refs' => [ 'CreatePackageResponse$PackageDetails' => '<p>Information about the package. </p>', 'DeletePackageResponse$PackageDetails' => '<p> <code>PackageDetails</code> </p>', 'PackageDetailsList$member' => NULL, 'UpdatePackageResponse$PackageDetails' => '<p>Information about the package. </p>', ], ], 'PackageDetailsList' => [ 'base' => NULL, 'refs' => [ 'DescribePackagesResponse$PackageDetailsList' => '<p>List of <code>PackageDetails</code> objects. </p>', ], ], 'PackageID' => [ 'base' => NULL, 'refs' => [ 'AssociatePackageRequest$PackageID' => '<p>Internal ID of the package to associate with a domain. Use <code>DescribePackages</code> to find this value. </p>', 'DeletePackageRequest$PackageID' => '<p>The internal ID of the package you want to delete. Use <code>DescribePackages</code> to find this value. </p>', 'DissociatePackageRequest$PackageID' => '<p>The internal ID of the package to associate with a domain. Use <code>DescribePackages</code> to find this value. </p>', 'DomainPackageDetails$PackageID' => '<p>The internal ID of the package.</p>', 'GetPackageVersionHistoryRequest$PackageID' => '<p>Returns an audit history of package versions.</p>', 'GetPackageVersionHistoryResponse$PackageID' => NULL, 'ListDomainsForPackageRequest$PackageID' => '<p>The package for which to list associated domains.</p>', 'PackageDetails$PackageID' => '<p>Internal ID of the package.</p>', 'UpdatePackageRequest$PackageID' => '<p>The unique identifier for the package.</p>', ], ], 'PackageName' => [ 'base' => NULL, 'refs' => [ 'CreatePackageRequest$PackageName' => '<p>Unique identifier for the package.</p>', 'DomainPackageDetails$PackageName' => '<p>User-specified name of the package.</p>', 'PackageDetails$PackageName' => '<p>User-specified name of the package.</p>', ], ], 'PackageSource' => [ 'base' => '<p>The Amazon S3 location for importing the package specified as <code>S3BucketName</code> and <code>S3Key</code> </p>', 'refs' => [ 'CreatePackageRequest$PackageSource' => '<p>The Amazon S3 location from which to import the package. </p>', 'UpdatePackageRequest$PackageSource' => NULL, ], ], 'PackageStatus' => [ 'base' => NULL, 'refs' => [ 'PackageDetails$PackageStatus' => '<p>Current state of the package. Values are COPYING, COPY_FAILED, AVAILABLE, DELETING, and DELETE_FAILED.</p>', ], ], 'PackageType' => [ 'base' => NULL, 'refs' => [ 'CreatePackageRequest$PackageType' => '<p>Type of package. Currently supports only TXT-DICTIONARY.</p>', 'DomainPackageDetails$PackageType' => '<p>Currently supports only TXT-DICTIONARY.</p>', 'PackageDetails$PackageType' => '<p>Currently supports only TXT-DICTIONARY.</p>', ], ], 'PackageVersion' => [ 'base' => NULL, 'refs' => [ 'DomainPackageDetails$PackageVersion' => NULL, 'PackageDetails$AvailablePackageVersion' => NULL, 'PackageVersionHistory$PackageVersion' => '<p>The package version.</p>', ], ], 'PackageVersionHistory' => [ 'base' => '<p>Details of a package version.</p>', 'refs' => [ 'PackageVersionHistoryList$member' => NULL, ], ], 'PackageVersionHistoryList' => [ 'base' => NULL, 'refs' => [ 'GetPackageVersionHistoryResponse$PackageVersionHistoryList' => '<p>List of <code>PackageVersionHistory</code> objects. </p>', ], ], 'Password' => [ 'base' => NULL, 'refs' => [ 'MasterUserOptions$MasterUserPassword' => '<p>The master user\'s password, which is stored in the Amazon OpenSearch Service domain\'s internal database.</p>', ], ], 'PolicyDocument' => [ 'base' => '<p>Access policy rules for a domain service endpoints. For more information, see <a href="http://docs.aws.amazon.com/opensearch-service/latest/developerguide/createupdatedomains.html#createdomain-configure-access-policies" target="_blank">Configuring access policies </a>. The maximum size of a policy document is 100 KB. </p>', 'refs' => [ 'AccessPoliciesStatus$Options' => '<p>The access policy configured for the domain. Access policies can be resource-based, IP-based, or IAM-based. See <a href="http://docs.aws.amazon.com/opensearch-service/latest/developerguide/createupdatedomains.html#createdomain-configure-access-policies" target="_blank"> Configuring access policies</a>for more information. </p>', 'CreateDomainRequest$AccessPolicies' => '<p>IAM access policy as a JSON-formatted string.</p>', 'DomainStatus$AccessPolicies' => '<p>IAM access policy as a JSON-formatted string.</p>', 'UpdateDomainConfigRequest$AccessPolicies' => '<p>IAM access policy as a JSON-formatted string.</p>', ], ], 'PurchaseReservedInstanceOfferingRequest' => [ 'base' => '<p>Container for parameters to <code>PurchaseReservedInstanceOffering</code> </p>', 'refs' => [], ], 'PurchaseReservedInstanceOfferingResponse' => [ 'base' => '<p>Represents the output of a <code>PurchaseReservedInstanceOffering</code> operation. </p>', 'refs' => [], ], 'RecurringCharge' => [ 'base' => '<p>Contains the specific price and frequency of a recurring charges for a reserved OpenSearch instance, or for a reserved OpenSearch instance offering. </p>', 'refs' => [ 'RecurringChargeList$member' => NULL, ], ], 'RecurringChargeList' => [ 'base' => NULL, 'refs' => [ 'ReservedInstance$RecurringCharges' => '<p>The charge to your account regardless of whether you are creating any domains using the instance offering.</p>', 'ReservedInstanceOffering$RecurringCharges' => '<p>The charge to your account regardless of whether you are creating any domains using the instance offering.</p>', ], ], 'ReferencePath' => [ 'base' => NULL, 'refs' => [ 'DomainPackageDetails$ReferencePath' => '<p>The relative path on Amazon OpenSearch Service nodes, which can be used as synonym_path when the package is a synonym file.</p>', ], ], 'Region' => [ 'base' => NULL, 'refs' => [ 'AWSDomainInformation$Region' => NULL, ], ], 'RejectInboundConnectionRequest' => [ 'base' => '<p>Container for the parameters to the <code> <a>RejectInboundConnection</a> </code> operation. </p>', 'refs' => [], ], 'RejectInboundConnectionResponse' => [ 'base' => '<p>The result of a <code> <a>RejectInboundConnection</a> </code> operation. Contains details about the rejected inbound connection. </p>', 'refs' => [], ], 'RemoveTagsRequest' => [ 'base' => '<p>Container for the parameters to the <code> <a>RemoveTags</a> </code> operation. Specify the <code>ARN</code> for the domain from which you want to remove the specified <code>TagKey</code>. </p>', 'refs' => [], ], 'ReservationToken' => [ 'base' => NULL, 'refs' => [ 'PurchaseReservedInstanceOfferingRequest$ReservationName' => '<p>A customer-specified identifier to track this reservation.</p>', 'PurchaseReservedInstanceOfferingResponse$ReservationName' => '<p>The customer-specified identifier used to track this reservation.</p>', 'ReservedInstance$ReservationName' => '<p>The customer-specified identifier to track this reservation.</p>', ], ], 'ReservedInstance' => [ 'base' => '<p>Details of a reserved OpenSearch instance.</p>', 'refs' => [ 'ReservedInstanceList$member' => NULL, ], ], 'ReservedInstanceList' => [ 'base' => NULL, 'refs' => [ 'DescribeReservedInstancesResponse$ReservedInstances' => '<p>List of reserved OpenSearch instances.</p>', ], ], 'ReservedInstanceOffering' => [ 'base' => '<p>Details of a reserved OpenSearch instance offering.</p>', 'refs' => [ 'ReservedInstanceOfferingList$member' => NULL, ], ], 'ReservedInstanceOfferingList' => [ 'base' => NULL, 'refs' => [ 'DescribeReservedInstanceOfferingsResponse$ReservedInstanceOfferings' => '<p>List of reserved OpenSearch instance offerings</p>', ], ], 'ReservedInstancePaymentOption' => [ 'base' => NULL, 'refs' => [ 'ReservedInstance$PaymentOption' => '<p>The payment option as defined in the reserved OpenSearch instance offering.</p>', 'ReservedInstanceOffering$PaymentOption' => '<p>Payment option for the reserved OpenSearch instance offering</p>', ], ], 'ResourceAlreadyExistsException' => [ 'base' => '<p>An exception for creating a resource that already exists. Gives http status code of 400.</p>', 'refs' => [], ], 'ResourceNotFoundException' => [ 'base' => '<p>An exception for accessing or deleting a resource that does not exist. Gives http status code of 400.</p>', 'refs' => [], ], 'RoleArn' => [ 'base' => NULL, 'refs' => [ 'CognitoOptions$RoleArn' => '<p>The role ARN that provides OpenSearch permissions for accessing Cognito resources.</p>', ], ], 'RollbackOnDisable' => [ 'base' => '<p>The rollback state while disabling Auto-Tune for the domain. Valid values are NO_ROLLBACK and DEFAULT_ROLLBACK. </p>', 'refs' => [ 'AutoTuneOptions$RollbackOnDisable' => '<p>The rollback state while disabling Auto-Tune for the domain. Valid values are NO_ROLLBACK and DEFAULT_ROLLBACK. </p>', ], ], 'S3BucketName' => [ 'base' => NULL, 'refs' => [ 'PackageSource$S3BucketName' => '<p>The name of the Amazon S3 bucket containing the package.</p>', ], ], 'S3Key' => [ 'base' => NULL, 'refs' => [ 'PackageSource$S3Key' => '<p>Key (file name) of the package.</p>', ], ], 'SAMLEntityId' => [ 'base' => NULL, 'refs' => [ 'SAMLIdp$EntityId' => '<p>The unique entity ID of the application in SAML identity provider.</p>', ], ], 'SAMLIdp' => [ 'base' => '<p>The SAML identity povider\'s information.</p>', 'refs' => [ 'SAMLOptionsInput$Idp' => '<p>The SAML Identity Provider\'s information.</p>', 'SAMLOptionsOutput$Idp' => '<p>Describes the SAML identity provider\'s information.</p>', ], ], 'SAMLMetadata' => [ 'base' => NULL, 'refs' => [ 'SAMLIdp$MetadataContent' => '<p>The metadata of the SAML application in XML format.</p>', ], ], 'SAMLOptionsInput' => [ 'base' => '<p>The SAML application configuration for the domain.</p>', 'refs' => [ 'AdvancedSecurityOptionsInput$SAMLOptions' => '<p>The SAML application configuration for the domain.</p>', ], ], 'SAMLOptionsOutput' => [ 'base' => '<p>Describes the SAML application configured for the domain.</p>', 'refs' => [ 'AdvancedSecurityOptions$SAMLOptions' => '<p>Describes the SAML application configured for a domain.</p>', ], ], 'ScheduledAutoTuneActionType' => [ 'base' => '<p>The Auto-Tune action type. Valid values are JVM_HEAP_SIZE_TUNING, and JVM_YOUNG_GEN_TUNING.</p>', 'refs' => [ 'ScheduledAutoTuneDetails$ActionType' => '<p>The Auto-Tune action type. Valid values are JVM_HEAP_SIZE_TUNING and JVM_YOUNG_GEN_TUNING.</p>', ], ], 'ScheduledAutoTuneDescription' => [ 'base' => '<p>The Auto-Tune action description.</p>', 'refs' => [ 'ScheduledAutoTuneDetails$Action' => '<p>The Auto-Tune action description.</p>', ], ], 'ScheduledAutoTuneDetails' => [ 'base' => '<p>Specifies details about the scheduled Auto-Tune action. See <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/auto-tune.html" target="_blank"> Auto-Tune for Amazon OpenSearch Service </a> for more information. </p>', 'refs' => [ 'AutoTuneDetails$ScheduledAutoTuneDetails' => NULL, ], ], 'ScheduledAutoTuneSeverityType' => [ 'base' => '<p>The Auto-Tune action severity. Valid values are LOW, MEDIUM, and HIGH.</p>', 'refs' => [ 'ScheduledAutoTuneDetails$Severity' => '<p>The Auto-Tune action severity. Valid values are LOW, MEDIUM, and HIGH.</p>', ], ], 'ServiceSoftwareOptions' => [ 'base' => '<p>The current options of an domain service software options.</p>', 'refs' => [ 'CancelServiceSoftwareUpdateResponse$ServiceSoftwareOptions' => '<p>The current status of the OpenSearch service software update.</p>', 'DomainStatus$ServiceSoftwareOptions' => '<p>The current status of the domain\'s service software.</p>', 'StartServiceSoftwareUpdateResponse$ServiceSoftwareOptions' => '<p>The current status of the OpenSearch service software update.</p>', ], ], 'ServiceUrl' => [ 'base' => '<p>The endpoint to which service requests are submitted. For example, <code> search-imdb-movies-oopcnjfn6ugofer3zx5iadxxca.eu-west-1.es.amazonaws.com </code> or <code>doc-imdb-movies-oopcnjfn6ugofer3zx5iadxxca.eu-west-1.es.amazonaws.com</code>. </p>', 'refs' => [ 'DomainStatus$Endpoint' => '<p>The domain endpoint that you use to submit index and search requests.</p>', 'EndpointsMap$value' => NULL, ], ], 'SnapshotOptions' => [ 'base' => '<p>The time, in UTC format, when the service takes a daily automated snapshot of the specified domain. Default is <code>0</code> hours. </p>', 'refs' => [ 'CreateDomainRequest$SnapshotOptions' => '<p>Option to set time, in UTC format, of the daily automated snapshot. Default value is 0 hours.</p>', 'DomainStatus$SnapshotOptions' => '<p>The status of the <code>SnapshotOptions</code>. </p>', 'SnapshotOptionsStatus$Options' => '<p>The daily snapshot options specified for the domain.</p>', 'UpdateDomainConfigRequest$SnapshotOptions' => '<p>Option to set the time, in UTC format, for the daily automated snapshot. Default value is <code>0</code> hours. </p>', ], ], 'SnapshotOptionsStatus' => [ 'base' => '<p>Status of a daily automated snapshot.</p>', 'refs' => [ 'DomainConfig$SnapshotOptions' => '<p>The <code>SnapshotOptions</code> for the domain. </p>', ], ], 'StartAt' => [ 'base' => NULL, 'refs' => [ 'AutoTuneMaintenanceSchedule$StartAt' => '<p>The timestamp at which the Auto-Tune maintenance schedule starts.</p>', ], ], 'StartServiceSoftwareUpdateRequest' => [ 'base' => '<p>Container for the parameters to the <code> <a>StartServiceSoftwareUpdate</a> </code> operation. Specifies the name of the domain to schedule a service software update for. </p>', 'refs' => [], ], 'StartServiceSoftwareUpdateResponse' => [ 'base' => '<p>The result of a <code>StartServiceSoftwareUpdate</code> operation. Contains the status of the update. </p>', 'refs' => [], ], 'StartTimestamp' => [ 'base' => NULL, 'refs' => [ 'UpgradeHistory$StartTimestamp' => '<p>UTC timestamp at which the upgrade API call was made in "yyyy-MM-ddTHH:mm:ssZ" format.</p>', ], ], 'StorageSubTypeName' => [ 'base' => '<p> Sub-type of the given storage type. List of available sub-storage options: "instance" storageType has no storageSubType. "ebs" storageType has the following valid storageSubTypes: <ol> <li>standard</li> <li>gp2</li> <li>io1</li> </ol> See <code> <a>VolumeType</a> </code> for more information regarding each EBS storage option. </p>', 'refs' => [ 'StorageType$StorageSubTypeName' => NULL, ], ], 'StorageType' => [ 'base' => '<p>StorageTypes represents the list of storage-related types and their attributes that are available for a given InstanceType. </p>', 'refs' => [ 'StorageTypeList$member' => NULL, ], ], 'StorageTypeLimit' => [ 'base' => '<p>Limits that are applicable for the given storage type. </p>', 'refs' => [ 'StorageTypeLimitList$member' => NULL, ], ], 'StorageTypeLimitList' => [ 'base' => NULL, 'refs' => [ 'StorageType$StorageTypeLimits' => '<p>Limits that are applicable for the given storage type. </p>', ], ], 'StorageTypeList' => [ 'base' => NULL, 'refs' => [ 'Limits$StorageTypes' => '<p>Storage-related types and attributes that are available for a given InstanceType. </p>', ], ], 'StorageTypeName' => [ 'base' => '<p> Type of storage. List of available storage options: <ol> <li>instance</li> Built-in storage available for the instance <li>ebs</li> Elastic block storage attached to the instance </ol> </p>', 'refs' => [ 'StorageType$StorageTypeName' => NULL, ], ], 'String' => [ 'base' => NULL, 'refs' => [ 'AdvancedOptions$key' => NULL, 'AdvancedOptions$value' => NULL, 'AutoTuneMaintenanceSchedule$CronExpressionForRecurrence' => '<p>A cron expression for a recurring maintenance schedule. See <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/auto-tune.html" target="_blank"> Auto-Tune for Amazon OpenSearch Service </a> for more information. </p>', 'AutoTuneOptionsOutput$ErrorMessage' => '<p>The error message while enabling or disabling Auto-Tune.</p>', 'AutoTuneStatus$ErrorMessage' => '<p>The error message while enabling or disabling Auto-Tune.</p>', 'DescribePackagesResponse$NextToken' => NULL, 'DescribeReservedInstancesResponse$NextToken' => '<p>Provides an identifier to allow retrieval of paginated results.</p>', 'EndpointsMap$key' => NULL, 'GetPackageVersionHistoryResponse$NextToken' => NULL, 'GetUpgradeHistoryResponse$NextToken' => '<p>Pagination token that needs to be supplied to the next call to get the next page of results.</p>', 'ListDomainsForPackageResponse$NextToken' => NULL, 'ListPackagesForDomainResponse$NextToken' => '<p>Pagination token to supply to the next call to get the next page of results.</p>', 'RecurringCharge$RecurringChargeFrequency' => '<p>The frequency of the recurring charge.</p>', 'ReservedInstance$ReservedInstanceOfferingId' => '<p>The offering identifier.</p>', 'ReservedInstance$CurrencyCode' => '<p>The currency code for the reserved OpenSearch instance offering.</p>', 'ReservedInstance$State' => '<p>The state of the reserved OpenSearch instance.</p>', 'ReservedInstanceOffering$CurrencyCode' => '<p>The currency code for the reserved OpenSearch instance offering.</p>', 'SAMLOptionsInput$SubjectKey' => '<p>Element of the SAML assertion to use for username. Default is NameID.</p>', 'SAMLOptionsInput$RolesKey' => '<p>Element of the SAML assertion to use for backend roles. Default is roles.</p>', 'SAMLOptionsOutput$SubjectKey' => '<p>The key used for matching the SAML subject attribute.</p>', 'SAMLOptionsOutput$RolesKey' => '<p>The key used for matching the SAML roles attribute.</p>', 'ServiceSoftwareOptions$CurrentVersion' => '<p>The current service software version present on the domain.</p>', 'ServiceSoftwareOptions$NewVersion' => '<p>The new service software version if one is available.</p>', 'ServiceSoftwareOptions$Description' => '<p>The description of the <code>UpdateStatus</code>. </p>', 'StringList$member' => NULL, 'UpgradeDomainResponse$UpgradeId' => NULL, 'VPCDerivedInfo$VPCId' => '<p>The VPC ID for the domain. Exists only if the domain was created with <code>VPCOptions</code>.</p>', ], ], 'StringList' => [ 'base' => NULL, 'refs' => [ 'ChangeProgressStatusDetails$PendingProperties' => '<p>The list of properties involved in the domain configuration change that are still in pending.</p>', 'ChangeProgressStatusDetails$CompletedProperties' => '<p>The list of properties involved in the domain configuration change that are completed.</p>', 'RemoveTagsRequest$TagKeys' => '<p>The <code>TagKey</code> list you want to remove from the domain. </p>', 'VPCDerivedInfo$SubnetIds' => '<p>The subnets for the VPC endpoint.</p>', 'VPCDerivedInfo$AvailabilityZones' => '<p>The Availability Zones for the domain. Exists only if the domain was created with <code>VPCOptions</code>.</p>', 'VPCDerivedInfo$SecurityGroupIds' => '<p>The security groups for the VPC endpoint.</p>', 'VPCOptions$SubnetIds' => '<p>The subnets for the VPC endpoint.</p>', 'VPCOptions$SecurityGroupIds' => '<p>The security groups for the VPC endpoint.</p>', ], ], 'TLSSecurityPolicy' => [ 'base' => NULL, 'refs' => [ 'DomainEndpointOptions$TLSSecurityPolicy' => '<p>Specify the TLS security policy to apply to the HTTPS endpoint of the domain. <br/> Can be one of the following values: <ul> <li> <b>Policy-Min-TLS-1-0-2019-07:</b> TLS security policy which supports TLSv1.0 and higher. </li> <li> <b>Policy-Min-TLS-1-2-2019-07:</b> TLS security policy which supports only TLSv1.2 </li> </ul> </p>', ], ], 'Tag' => [ 'base' => '<p>A key value pair for a resource tag.</p>', 'refs' => [ 'TagList$member' => NULL, ], ], 'TagKey' => [ 'base' => '<p>A string of length from 1 to 128 characters that specifies the key for a tag. Tag keys must be unique for the domain to which they\'re attached. </p>', 'refs' => [ 'Tag$Key' => '<p>The <code>TagKey</code>, the name of the tag. Tag keys must be unique for the domain to which they are attached. </p>', ], ], 'TagList' => [ 'base' => '<p>A list of <code>Tag</code>. </p>', 'refs' => [ 'AddTagsRequest$TagList' => '<p>List of <code>Tag</code> to add to the domain. </p>', 'CreateDomainRequest$TagList' => '<p>A list of <code>Tag</code> added during domain creation. </p>', 'ListTagsResponse$TagList' => '<p>List of <code>Tag</code> for the requested domain. </p>', ], ], 'TagValue' => [ 'base' => '<p>A string of length from 0 to 256 characters that specifies the value for a tag. Tag values can be null and don\'t have to be unique in a tag set. </p>', 'refs' => [ 'Tag$Value' => '<p>The <code>TagValue</code>, the value assigned to the corresponding tag key. Tag values can be null and don\'t have to be unique in a tag set. For example, you can have a key value pair in a tag set of <code>project : Trinity</code> and <code>cost-center : Trinity</code> </p>', ], ], 'TimeUnit' => [ 'base' => '<p>The unit of a maintenance schedule duration. Valid value is HOUR. See <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/auto-tune.html" target="_blank"> Auto-Tune for Amazon OpenSearch Service </a> for more information. </p>', 'refs' => [ 'Duration$Unit' => '<p>The unit of a maintenance schedule duration. Valid value is HOURS. See <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/auto-tune.html" target="_blank"> Auto-Tune for Amazon OpenSearch Service </a> for more information. </p>', ], ], 'TotalNumberOfStages' => [ 'base' => NULL, 'refs' => [ 'ChangeProgressStatusDetails$TotalNumberOfStages' => '<p>The total number of stages required for the configuration change.</p>', ], ], 'UIntValue' => [ 'base' => NULL, 'refs' => [ 'AutoTuneStatus$UpdateVersion' => '<p>The latest version of the Auto-Tune options.</p>', 'OptionStatus$UpdateVersion' => '<p>The latest version of the entity.</p>', ], ], 'UpdateDomainConfigRequest' => [ 'base' => '<p>Container for the parameters to the <code> <a>UpdateDomain</a> </code> operation. Specifies the type and number of instances in the domain cluster. </p>', 'refs' => [], ], 'UpdateDomainConfigResponse' => [ 'base' => '<p>The result of an <code>UpdateDomain</code> request. Contains the status of the domain being updated. </p>', 'refs' => [], ], 'UpdatePackageRequest' => [ 'base' => '<p> Container for request parameters to the <code> <a>UpdatePackage</a> </code> operation. </p>', 'refs' => [], ], 'UpdatePackageResponse' => [ 'base' => '<p> Container for the response returned by the <code> <a>UpdatePackage</a> </code> operation. </p>', 'refs' => [], ], 'UpdateTimestamp' => [ 'base' => NULL, 'refs' => [ 'AutoTuneStatus$CreationDate' => '<p>The timestamp of the Auto-Tune options creation date.</p>', 'AutoTuneStatus$UpdateDate' => '<p>The timestamp of when the Auto-Tune options were last updated.</p>', 'ChangeProgressStatusDetails$StartTime' => '<p>The time at which the configuration change is made on the domain.</p>', 'OptionStatus$CreationDate' => '<p>The timestamp of when the entity was created.</p>', 'OptionStatus$UpdateDate' => '<p>The timestamp of the last time the entity was updated.</p>', 'ReservedInstance$StartTime' => '<p>The time the reservation started.</p>', ], ], 'UpgradeDomainRequest' => [ 'base' => '<p> Container for the request parameters to <code> <a>UpgradeDomain</a> </code> operation. </p>', 'refs' => [], ], 'UpgradeDomainResponse' => [ 'base' => '<p> Container for response returned by <code> <a>UpgradeDomain</a> </code> operation. </p>', 'refs' => [], ], 'UpgradeHistory' => [ 'base' => '<p>History of the last 10 upgrades and upgrade eligibility checks.</p>', 'refs' => [ 'UpgradeHistoryList$member' => NULL, ], ], 'UpgradeHistoryList' => [ 'base' => NULL, 'refs' => [ 'GetUpgradeHistoryResponse$UpgradeHistories' => '<p> A list of <code> <a>UpgradeHistory</a> </code> objects corresponding to each upgrade or upgrade eligibility check performed on a domain returned as part of the <code> <a>GetUpgradeHistoryResponse</a> </code> object. </p>', ], ], 'UpgradeName' => [ 'base' => NULL, 'refs' => [ 'GetUpgradeStatusResponse$UpgradeName' => '<p>A string that briefly describes the update.</p>', 'UpgradeHistory$UpgradeName' => '<p>A string that briefly describes the upgrade.</p>', ], ], 'UpgradeStatus' => [ 'base' => NULL, 'refs' => [ 'GetUpgradeStatusResponse$StepStatus' => '<p> One of four statuses an upgrade have, returned as part of the <code> <a>GetUpgradeStatusResponse</a> </code> object. The status can take one of the following values: <ul> <li>In Progress</li> <li>Succeeded</li> <li>Succeeded with Issues</li> <li>Failed</li> </ul> </p>', 'UpgradeHistory$UpgradeStatus' => '<p> The current status of the upgrade. The status can take one of the following values: <ul> <li>In Progress</li> <li>Succeeded</li> <li>Succeeded with Issues</li> <li>Failed</li> </ul> </p>', 'UpgradeStepItem$UpgradeStepStatus' => '<p> The current status of the upgrade. The status can take one of the following values: <ul> <li>In Progress</li> <li>Succeeded</li> <li>Succeeded with Issues</li> <li>Failed</li> </ul> </p>', ], ], 'UpgradeStep' => [ 'base' => NULL, 'refs' => [ 'GetUpgradeStatusResponse$UpgradeStep' => '<p> One of three steps an upgrade or upgrade eligibility check goes through: <ul> <li>PreUpgradeCheck</li> <li>Snapshot</li> <li>Upgrade</li> </ul> </p>', 'UpgradeStepItem$UpgradeStep' => '<p> One of three steps an upgrade or upgrade eligibility check goes through: <ul> <li>PreUpgradeCheck</li> <li>Snapshot</li> <li>Upgrade</li> </ul> </p>', ], ], 'UpgradeStepItem' => [ 'base' => '<p>Represents a single step of the upgrade or upgrade eligibility check workflow.</p>', 'refs' => [ 'UpgradeStepsList$member' => NULL, ], ], 'UpgradeStepsList' => [ 'base' => NULL, 'refs' => [ 'UpgradeHistory$StepsList' => '<p> A list of <code> <a>UpgradeStepItem</a> </code> s representing information about each step performed as part of a specific upgrade or upgrade eligibility check. </p>', ], ], 'UserPoolId' => [ 'base' => NULL, 'refs' => [ 'CognitoOptions$UserPoolId' => '<p>The Cognito user pool ID for OpenSearch Dashboards authentication.</p>', ], ], 'Username' => [ 'base' => NULL, 'refs' => [ 'MasterUserOptions$MasterUserName' => '<p>The master user\'s username, which is stored in the Amazon OpenSearch Service domain\'s internal database.</p>', 'SAMLOptionsInput$MasterUserName' => '<p>The SAML master username, which is stored in the Amazon OpenSearch Service domain\'s internal database.</p>', ], ], 'VPCDerivedInfo' => [ 'base' => '<p>Options to specify the subnets and security groups for the VPC endpoint. For more information, see <a href="http://docs.aws.amazon.com/opensearch-service/latest/developerguide/vpc.html" target="_blank"> Launching your Amazon OpenSearch Service domains using a VPC</a>. </p>', 'refs' => [ 'DomainStatus$VPCOptions' => '<p>The <code>VPCOptions</code> for the specified domain. For more information, see <a href="http://docs.aws.amazon.com/opensearch-service/latest/developerguide/vpc.html" target="_blank"> Launching your Amazon OpenSearch Service domains using a VPC</a>. </p>', 'VPCDerivedInfoStatus$Options' => '<p>The VPC options for the specified domain.</p>', ], ], 'VPCDerivedInfoStatus' => [ 'base' => '<p>Status of the VPC options for the specified domain.</p>', 'refs' => [ 'DomainConfig$VPCOptions' => '<p>The <code>VPCOptions</code> for the specified domain. For more information, see <a href="http://docs.aws.amazon.com/opensearch-service/latest/developerguide/vpc.html" target="_blank"> Launching your Amazon OpenSearch Service domains using a VPC</a>. </p>', ], ], 'VPCOptions' => [ 'base' => '<p>Options to specify the subnets and security groups for the VPC endpoint. For more information, see <a href="http://docs.aws.amazon.com/opensearch-service/latest/developerguide/vpc.html" target="_blank"> Launching your Amazon OpenSearch Service domains using a VPC</a>. </p>', 'refs' => [ 'CreateDomainRequest$VPCOptions' => '<p>Options to specify the subnets and security groups for a VPC endpoint. For more information, see <a href="http://docs.aws.amazon.com/opensearch-service/latest/developerguide/vpc.html" target="_blank">Launching your Amazon OpenSearch Service domains using a VPC </a>. </p>', 'UpdateDomainConfigRequest$VPCOptions' => '<p>Options to specify the subnets and security groups for the VPC endpoint. For more information, see <a href="http://docs.aws.amazon.com/opensearch-service/latest/developerguide/vpc.html" target="_blank">Launching your Amazon OpenSearch Service domains using a VPC </a>. </p>', ], ], 'ValidationException' => [ 'base' => '<p>An exception for missing / invalid input fields. Gives http status code of 400.</p>', 'refs' => [], ], 'ValueStringList' => [ 'base' => NULL, 'refs' => [ 'Filter$Values' => '<p> Contains one or more values for the filter. </p>', ], ], 'VersionList' => [ 'base' => '<p>List of supported OpenSearch versions. </p>', 'refs' => [ 'CompatibleVersionsMap$TargetVersions' => NULL, 'ListVersionsResponse$Versions' => NULL, ], ], 'VersionStatus' => [ 'base' => '<p>The status of the OpenSearch version options for the specified OpenSearch domain.</p>', 'refs' => [ 'DomainConfig$EngineVersion' => '<p>String of format Elasticsearch_X.Y or OpenSearch_X.Y to specify the engine version for the OpenSearch or Elasticsearch domain.</p>', ], ], 'VersionString' => [ 'base' => NULL, 'refs' => [ 'CompatibleVersionsMap$SourceVersion' => '<p>The current version of OpenSearch a domain is on.</p>', 'CreateDomainRequest$EngineVersion' => '<p>String of format Elasticsearch_X.Y or OpenSearch_X.Y to specify the engine version for the Amazon OpenSearch Service domain. For example, "OpenSearch_1.0" or "Elasticsearch_7.9". For more information, see <a href="http://docs.aws.amazon.com/opensearch-service/latest/developerguide/createupdatedomains.html#createdomains" target="_blank">Creating and managing Amazon OpenSearch Service domains </a>. </p>', 'DescribeInstanceTypeLimitsRequest$EngineVersion' => '<p> Version of OpenSearch for which <code> <a>Limits</a> </code> are needed. </p>', 'DomainStatus$EngineVersion' => NULL, 'ListInstanceTypeDetailsRequest$EngineVersion' => NULL, 'UpgradeDomainRequest$TargetVersion' => '<p>The version of OpenSearch you intend to upgrade the domain to.</p>', 'UpgradeDomainResponse$TargetVersion' => '<p>The version of OpenSearch that you intend to upgrade the domain to.</p>', 'VersionList$member' => NULL, 'VersionStatus$Options' => '<p>The OpenSearch version for the specified OpenSearch domain.</p>', ], ], 'VolumeType' => [ 'base' => '<p>The type of EBS volume, standard, gp2, or io1. See <a href="http://docs.aws.amazon.com/opensearch-service/latest/developerguide/opensearch-createupdatedomains.html#opensearch-createdomain-configure-ebs" target="_blank">Configuring EBS-based Storage</a> for more information. </p>', 'refs' => [ 'EBSOptions$VolumeType' => '<p>The volume type for EBS-based storage.</p>', ], ], 'ZoneAwarenessConfig' => [ 'base' => '<p>The zone awareness configuration for the domain cluster, such as the number of availability zones.</p>', 'refs' => [ 'ClusterConfig$ZoneAwarenessConfig' => '<p>The zone awareness configuration for a domain when zone awareness is enabled.</p>', ], ], ],];
