<?php
// This file was auto-generated from sdk-root/src/data/models.lex.v2/2020-08-07/docs-2.json
return [ 'version' => '2.0', 'service' => '<p/>', 'operations' => [ 'BuildBotLocale' => '<p>Builds a bot, its intents, and its slot types into a specific locale. A bot can be built into multiple locales. At runtime the locale is used to choose a specific build of the bot.</p>', 'CreateBot' => '<p>Creates an Amazon Lex conversational bot. </p>', 'CreateBotAlias' => '<p>Creates an alias for the specified version of a bot. Use an alias to enable you to change the version of a bot without updating applications that use the bot.</p> <p>For example, you can create an alias called "PROD" that your applications use to call the Amazon Lex bot. </p>', 'CreateBotLocale' => '<p>Creates a locale in the bot. The locale contains the intents and slot types that the bot uses in conversations with users in the specified language and locale. You must add a locale to a bot before you can add intents and slot types to the bot.</p>', 'CreateBotVersion' => '<p>Creates a new version of the bot based on the <code>DRAFT</code> version. If the <code>DRAFT</code> version of this resource hasn\'t changed since you created the last version, Amazon Lex doesn\'t create a new version, it returns the last created version.</p> <p>When you create the first version of a bot, Amazon Lex sets the version to 1. Subsequent versions increment by 1.</p>', 'CreateExport' => '<p>Creates a zip archive containing the contents of a bot or a bot locale. The archive contains a directory structure that contains JSON files that define the bot.</p> <p>You can create an archive that contains the complete definition of a bot, or you can specify that the archive contain only the definition of a single bot locale.</p> <p>For more information about exporting bots, and about the structure of the export archive, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/importing-exporting.html"> Importing and exporting bots </a> </p>', 'CreateIntent' => '<p>Creates an intent.</p> <p>To define the interaction between the user and your bot, you define one or more intents. For example, for a pizza ordering bot you would create an <code>OrderPizza</code> intent.</p> <p>When you create an intent, you must provide a name. You can optionally provide the following:</p> <ul> <li> <p>Sample utterances. For example, "I want to order a pizza" and "Can I order a pizza." You can\'t provide utterances for built-in intents.</p> </li> <li> <p>Information to be gathered. You specify slots for the information that you bot requests from the user. You can specify standard slot types, such as date and time, or custom slot types for your application.</p> </li> <li> <p>How the intent is fulfilled. You can provide a Lambda function or configure the intent to return the intent information to your client application. If you use a Lambda function, Amazon Lex invokes the function when all of the intent information is available.</p> </li> <li> <p>A confirmation prompt to send to the user to confirm an intent. For example, "Shall I order your pizza?"</p> </li> <li> <p>A conclusion statement to send to the user after the intent is fulfilled. For example, "I ordered your pizza."</p> </li> <li> <p>A follow-up prompt that asks the user for additional activity. For example, "Do you want a drink with your pizza?"</p> </li> </ul>', 'CreateResourcePolicy' => '<p>Creates a new resource policy with the specified policy statements.</p>', 'CreateResourcePolicyStatement' => '<p>Adds a new resource policy statement to a bot or bot alias. If a resource policy exists, the statement is added to the current resource policy. If a policy doesn\'t exist, a new policy is created.</p> <p>You can\'t create a resource policy statement that allows cross-account access.</p>', 'CreateSlot' => '<p>Creates a slot in an intent. A slot is a variable needed to fulfill an intent. For example, an <code>OrderPizza</code> intent might need slots for size, crust, and number of pizzas. For each slot, you define one or more utterances that Amazon Lex uses to elicit a response from the user. </p>', 'CreateSlotType' => '<p>Creates a custom slot type</p> <p> To create a custom slot type, specify a name for the slot type and a set of enumeration values, the values that a slot of this type can assume. </p>', 'CreateUploadUrl' => '<p>Gets a pre-signed S3 write URL that you use to upload the zip archive when importing a bot or a bot locale. </p>', 'DeleteBot' => '<p>Deletes all versions of a bot, including the <code>Draft</code> version. To delete a specific version, use the <code>DeleteBotVersion</code> operation.</p> <p>When you delete a bot, all of the resources contained in the bot are also deleted. Deleting a bot removes all locales, intents, slot, and slot types defined for the bot.</p> <p>If a bot has an alias, the <code>DeleteBot</code> operation returns a <code>ResourceInUseException</code> exception. If you want to delete the bot and the alias, set the <code>skipResourceInUseCheck</code> parameter to <code>true</code>.</p>', 'DeleteBotAlias' => '<p>Deletes the specified bot alias.</p>', 'DeleteBotLocale' => '<p>Removes a locale from a bot.</p> <p>When you delete a locale, all intents, slots, and slot types defined for the locale are also deleted.</p>', 'DeleteBotVersion' => '<p>Deletes a specific version of a bot. To delete all version of a bot, use the <a href="https://docs.aws.amazon.com/lexv2/latest/dg/API_DeleteBot.html">DeleteBot</a> operation.</p>', 'DeleteCustomVocabulary' => '<p>Removes a custom vocabulary from the specified locale in the specified bot.</p>', 'DeleteExport' => '<p>Removes a previous export and the associated files stored in an S3 bucket.</p>', 'DeleteImport' => '<p>Removes a previous import and the associated file stored in an S3 bucket.</p>', 'DeleteIntent' => '<p>Removes the specified intent.</p> <p>Deleting an intent also deletes the slots associated with the intent.</p>', 'DeleteResourcePolicy' => '<p>Removes an existing policy from a bot or bot alias. If the resource doesn\'t have a policy attached, Amazon Lex returns an exception.</p>', 'DeleteResourcePolicyStatement' => '<p>Deletes a policy statement from a resource policy. If you delete the last statement from a policy, the policy is deleted. If you specify a statement ID that doesn\'t exist in the policy, or if the bot or bot alias doesn\'t have a policy attached, Amazon Lex returns an exception.</p>', 'DeleteSlot' => '<p>Deletes the specified slot from an intent.</p>', 'DeleteSlotType' => '<p>Deletes a slot type from a bot locale.</p> <p>If a slot is using the slot type, Amazon Lex throws a <code>ResourceInUseException</code> exception. To avoid the exception, set the <code>skipResourceInUseCheck</code> parameter to <code>true</code>.</p>', 'DeleteUtterances' => '<p>Deletes stored utterances.</p> <p>Amazon Lex stores the utterances that users send to your bot. Utterances are stored for 15 days for use with the <a href="https://docs.aws.amazon.com/lexv2/latest/dg/API_ListAggregatedUtterances.html">ListAggregatedUtterances</a> operation, and then stored indefinitely for use in improving the ability of your bot to respond to user input..</p> <p>Use the <code>DeleteUtterances</code> operation to manually delete utterances for a specific session. When you use the <code>DeleteUtterances</code> operation, utterances stored for improving your bot\'s ability to respond to user input are deleted immediately. Utterances stored for use with the <code>ListAggregatedUtterances</code> operation are deleted after 15 days.</p>', 'DescribeBot' => '<p>Provides metadata information about a bot. </p>', 'DescribeBotAlias' => '<p>Get information about a specific bot alias.</p>', 'DescribeBotLocale' => '<p>Describes the settings that a bot has for a specific locale. </p>', 'DescribeBotRecommendation' => '<p>Provides metadata information about a bot recommendation. This information will enable you to get a description on the request inputs, to download associated transcripts after processing is complete, and to download intents and slot-types generated by the bot recommendation.</p>', 'DescribeBotVersion' => '<p>Provides metadata about a version of a bot.</p>', 'DescribeCustomVocabularyMetadata' => '<p>Provides metadata information about a custom vocabulary.</p>', 'DescribeExport' => '<p>Gets information about a specific export.</p>', 'DescribeImport' => '<p>Gets information about a specific import.</p>', 'DescribeIntent' => '<p>Returns metadata about an intent.</p>', 'DescribeResourcePolicy' => '<p>Gets the resource policy and policy revision for a bot or bot alias.</p>', 'DescribeSlot' => '<p>Gets metadata information about a slot.</p>', 'DescribeSlotType' => '<p>Gets metadata information about a slot type.</p>', 'ListAggregatedUtterances' => '<p>Provides a list of utterances that users have sent to the bot.</p> <p>Utterances are aggregated by the text of the utterance. For example, all instances where customers used the phrase "I want to order pizza" are aggregated into the same line in the response.</p> <p>You can see both detected utterances and missed utterances. A detected utterance is where the bot properly recognized the utterance and activated the associated intent. A missed utterance was not recognized by the bot and didn\'t activate an intent.</p> <p>Utterances can be aggregated for a bot alias or for a bot version, but not both at the same time.</p> <p>Utterances statistics are not generated under the following conditions:</p> <ul> <li> <p>The <code>childDirected</code> field was set to true when the bot was created.</p> </li> <li> <p>You are using slot obfuscation with one or more slots.</p> </li> <li> <p>You opted out of participating in improving Amazon Lex.</p> </li> </ul>', 'ListBotAliases' => '<p>Gets a list of aliases for the specified bot.</p>', 'ListBotLocales' => '<p>Gets a list of locales for the specified bot.</p>', 'ListBotRecommendations' => '<p>Get a list of bot recommendations that meet the specified criteria.</p>', 'ListBotVersions' => '<p>Gets information about all of the versions of a bot.</p> <p>The <code>ListBotVersions</code> operation returns a summary of each version of a bot. For example, if a bot has three numbered versions, the <code>ListBotVersions</code> operation returns for summaries, one for each numbered version and one for the <code>DRAFT</code> version.</p> <p>The <code>ListBotVersions</code> operation always returns at least one version, the <code>DRAFT</code> version.</p>', 'ListBots' => '<p>Gets a list of available bots.</p>', 'ListBuiltInIntents' => '<p>Gets a list of built-in intents provided by Amazon Lex that you can use in your bot. </p> <p>To use a built-in intent as a the base for your own intent, include the built-in intent signature in the <code>parentIntentSignature</code> parameter when you call the <code>CreateIntent</code> operation. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/API_CreateIntent.html">CreateIntent</a>.</p>', 'ListBuiltInSlotTypes' => '<p>Gets a list of built-in slot types that meet the specified criteria.</p>', 'ListExports' => '<p>Lists the exports for a bot, bot locale, or custom vocabulary. Exports are kept in the list for 7 days.</p>', 'ListImports' => '<p>Lists the imports for a bot, bot locale, or custom vocabulary. Imports are kept in the list for 7 days.</p>', 'ListIntents' => '<p>Get a list of intents that meet the specified criteria.</p>', 'ListRecommendedIntents' => '<p>Gets a list of recommended intents provided by the bot recommendation that you can use in your bot.</p>', 'ListSlotTypes' => '<p>Gets a list of slot types that match the specified criteria.</p>', 'ListSlots' => '<p>Gets a list of slots that match the specified criteria.</p>', 'ListTagsForResource' => '<p>Gets a list of tags associated with a resource. Only bots, bot aliases, and bot channels can have tags associated with them.</p>', 'SearchAssociatedTranscripts' => '<p>Search for associated transcripts that meet the specified criteria.</p>', 'StartBotRecommendation' => '<p>Use this to provide your transcript data, and to start the bot recommendation process.</p>', 'StartImport' => '<p>Starts importing a bot, bot locale, or custom vocabulary from a zip archive that you uploaded to an S3 bucket.</p>', 'TagResource' => '<p>Adds the specified tags to the specified resource. If a tag key already exists, the existing value is replaced with the new value.</p>', 'UntagResource' => '<p>Removes tags from a bot, bot alias, or bot channel.</p>', 'UpdateBot' => '<p>Updates the configuration of an existing bot. </p>', 'UpdateBotAlias' => '<p>Updates the configuration of an existing bot alias.</p>', 'UpdateBotLocale' => '<p>Updates the settings that a bot has for a specific locale.</p>', 'UpdateBotRecommendation' => '<p>Updates an existing bot recommendation request.</p>', 'UpdateExport' => '<p>Updates the password used to protect an export zip archive.</p> <p>The password is not required. If you don\'t supply a password, Amazon Lex generates a zip file that is not protected by a password. This is the archive that is available at the pre-signed S3 URL provided by the <a href="https://docs.aws.amazon.com/lexv2/latest/dg/API_DescribeExport.html">DescribeExport</a> operation.</p>', 'UpdateIntent' => '<p>Updates the settings for an intent.</p>', 'UpdateResourcePolicy' => '<p>Replaces the existing resource policy for a bot or bot alias with a new one. If the policy doesn\'t exist, Amazon Lex returns an exception.</p>', 'UpdateSlot' => '<p>Updates the settings for a slot.</p>', 'UpdateSlotType' => '<p>Updates the configuration of an existing slot type.</p>', ], 'shapes' => [ 'AdvancedRecognitionSetting' => [ 'base' => '<p>Provides settings that enable advanced recognition settings for slot values.</p>', 'refs' => [ 'SlotValueSelectionSetting$advancedRecognitionSetting' => '<p>Provides settings that enable advanced recognition settings for slot values.</p>', ], ], 'AggregatedUtterancesFilter' => [ 'base' => '<p>Filters responses returned by the <code>ListAggregatedUtterances</code> operation.</p>', 'refs' => [ 'AggregatedUtterancesFilters$member' => NULL, ], ], 'AggregatedUtterancesFilterName' => [ 'base' => NULL, 'refs' => [ 'AggregatedUtterancesFilter$name' => '<p>The name of the field to filter the utterance list.</p>', ], ], 'AggregatedUtterancesFilterOperator' => [ 'base' => NULL, 'refs' => [ 'AggregatedUtterancesFilter$operator' => '<p>The operator to use for the filter. Specify <code>EQ</code> when the <code>ListAggregatedUtterances</code> operation should return only utterances that equal the specified value. Specify <code>CO</code> when the <code>ListAggregatedUtterances</code> operation should return utterances that contain the specified value.</p>', ], ], 'AggregatedUtterancesFilters' => [ 'base' => NULL, 'refs' => [ 'ListAggregatedUtterancesRequest$filters' => '<p>Provides the specification of a filter used to limit the utterances in the response to only those that match the filter specification. You can only specify one filter and one string to filter on.</p>', ], ], 'AggregatedUtterancesSortAttribute' => [ 'base' => NULL, 'refs' => [ 'AggregatedUtterancesSortBy$attribute' => '<p>The utterance attribute to sort by.</p>', ], ], 'AggregatedUtterancesSortBy' => [ 'base' => '<p>Specifies attributes for sorting a list of utterances.</p>', 'refs' => [ 'ListAggregatedUtterancesRequest$sortBy' => '<p>Specifies sorting parameters for the list of utterances. You can sort by the hit count, the missed count, or the number of distinct sessions the utterance appeared in.</p>', ], ], 'AggregatedUtterancesSummary' => [ 'base' => '<p>Provides summary information for aggregated utterances. The <code>ListAggregatedUtterances</code> operations combines all instances of the same utterance into a single aggregated summary.</p>', 'refs' => [ 'AggregatedUtterancesSummaryList$member' => NULL, ], ], 'AggregatedUtterancesSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListAggregatedUtterancesResponse$aggregatedUtterancesSummaries' => '<p>Summaries of the aggregated utterance data. Each response contains information about the number of times that the utterance was seen during the time period, whether it was detected or missed, and when it was seen during the time period.</p>', ], ], 'AmazonResourceName' => [ 'base' => NULL, 'refs' => [ 'CreateResourcePolicyRequest$resourceArn' => '<p>The Amazon Resource Name (ARN) of the bot or bot alias that the resource policy is attached to.</p>', 'CreateResourcePolicyResponse$resourceArn' => '<p>The Amazon Resource Name (ARN) of the bot or bot alias that the resource policy was attached to.</p>', 'CreateResourcePolicyStatementRequest$resourceArn' => '<p>The Amazon Resource Name (ARN) of the bot or bot alias that the resource policy is attached to.</p>', 'CreateResourcePolicyStatementResponse$resourceArn' => '<p>The Amazon Resource Name (ARN) of the bot or bot alias that the resource policy is attached to.</p>', 'DeleteResourcePolicyRequest$resourceArn' => '<p>The Amazon Resource Name (ARN) of the bot or bot alias that has the resource policy attached.</p>', 'DeleteResourcePolicyResponse$resourceArn' => '<p>The Amazon Resource Name (ARN) of the bot or bot alias that the resource policy was deleted from.</p>', 'DeleteResourcePolicyStatementRequest$resourceArn' => '<p>The Amazon Resource Name (ARN) of the bot or bot alias that the resource policy is attached to.</p>', 'DeleteResourcePolicyStatementResponse$resourceArn' => '<p>The Amazon Resource Name (ARN) of the bot or bot alias that the resource policy statement was removed from.</p>', 'DescribeResourcePolicyRequest$resourceArn' => '<p>The Amazon Resource Name (ARN) of the bot or bot alias that the resource policy is attached to.</p>', 'DescribeResourcePolicyResponse$resourceArn' => '<p>The Amazon Resource Name (ARN) of the bot or bot alias that the resource policy is attached to.</p>', 'ListTagsForResourceRequest$resourceARN' => '<p>The Amazon Resource Name (ARN) of the resource to get a list of tags for.</p>', 'TagResourceRequest$resourceARN' => '<p>The Amazon Resource Name (ARN) of the bot, bot alias, or bot channel to tag.</p>', 'UntagResourceRequest$resourceARN' => '<p>The Amazon Resource Name (ARN) of the resource to remove the tags from.</p>', 'UpdateResourcePolicyRequest$resourceArn' => '<p>The Amazon Resource Name (ARN) of the bot or bot alias that the resource policy is attached to.</p>', 'UpdateResourcePolicyResponse$resourceArn' => '<p>The Amazon Resource Name (ARN) of the bot or bot alias that the resource policy is attached to.</p>', ], ], 'AssociatedTranscript' => [ 'base' => '<p>The object containing information that associates the recommended intent/slot type with a conversation.</p>', 'refs' => [ 'AssociatedTranscriptList$member' => NULL, ], ], 'AssociatedTranscriptFilter' => [ 'base' => '<p>Filters to search for the associated transcript.</p>', 'refs' => [ 'AssociatedTranscriptFilters$member' => NULL, ], ], 'AssociatedTranscriptFilterName' => [ 'base' => NULL, 'refs' => [ 'AssociatedTranscriptFilter$name' => '<p>The name of the field to use for filtering. The allowed names are IntentId and SlotTypeId.</p>', ], ], 'AssociatedTranscriptFilters' => [ 'base' => NULL, 'refs' => [ 'SearchAssociatedTranscriptsRequest$filters' => '<p>A list of filter objects.</p>', ], ], 'AssociatedTranscriptList' => [ 'base' => NULL, 'refs' => [ 'SearchAssociatedTranscriptsResponse$associatedTranscripts' => '<p>The object that contains the associated transcript that meet the criteria you specified.</p>', ], ], 'AttachmentTitle' => [ 'base' => NULL, 'refs' => [ 'ImageResponseCard$title' => '<p>The title to display on the response card. The format of the title is determined by the platform displaying the response card.</p>', 'ImageResponseCard$subtitle' => '<p>The subtitle to display on the response card. The format of the subtitle is determined by the platform displaying the response card.</p>', ], ], 'AttachmentUrl' => [ 'base' => NULL, 'refs' => [ 'ImageResponseCard$imageUrl' => '<p>The URL of an image to display on the response card. The image URL must be publicly available so that the platform displaying the response card has access to the image.</p>', ], ], 'AudioLogDestination' => [ 'base' => '<p>The location of audio log files collected when conversation logging is enabled for a bot.</p>', 'refs' => [ 'AudioLogSetting$destination' => NULL, ], ], 'AudioLogSetting' => [ 'base' => '<p>Settings for logging audio of conversations between Amazon Lex and a user. You specify whether to log audio and the Amazon S3 bucket where the audio file is stored.</p>', 'refs' => [ 'AudioLogSettingsList$member' => NULL, ], ], 'AudioLogSettingsList' => [ 'base' => NULL, 'refs' => [ 'ConversationLogSettings$audioLogSettings' => '<p>The Amazon S3 settings for logging audio to an S3 bucket.</p>', ], ], 'AudioRecognitionStrategy' => [ 'base' => NULL, 'refs' => [ 'AdvancedRecognitionSetting$audioRecognitionStrategy' => '<p>Enables using the slot values as a custom vocabulary for recognizing user utterances.</p>', ], ], 'Boolean' => [ 'base' => NULL, 'refs' => [ 'AudioLogSetting$enabled' => '<p>Determines whether audio logging in enabled for the bot.</p>', 'BotAliasLocaleSettings$enabled' => '<p>Determines whether the locale is enabled for the bot. If the value is <code>false</code>, the locale isn\'t available for use.</p>', 'DialogCodeHookSettings$enabled' => '<p>Enables the dialog code hook so that it processes user requests.</p>', 'FulfillmentCodeHookSettings$enabled' => '<p>Indicates whether a Lambda function should be invoked to fulfill a specific intent.</p>', 'KendraConfiguration$queryFilterStringEnabled' => '<p>Determines whether the AMAZON.KendraSearchIntent intent uses a custom query string to query the Amazon Kendra index.</p>', 'MultipleValuesSetting$allowMultipleValues' => '<p>Indicates whether a slot can return multiple values. When <code>true</code>, the slot may return more than one value in a response. When <code>false</code>, the slot returns only a single value.</p> <p>Multi-value slots are only available in the en-US locale. If you set this value to <code>true</code> in any other locale, Amazon Lex throws a <code>ValidationException</code>.</p> <p>If the <code>allowMutlipleValues</code> is not set, the default value is <code>false</code>.</p>', 'SentimentAnalysisSettings$detectSentiment' => '<p>Sets whether Amazon Lex uses Amazon Comprehend to detect the sentiment of user utterances.</p>', 'TextLogSetting$enabled' => '<p>Determines whether conversation logs should be stored for an alias.</p>', ], ], 'BotAliasHistoryEvent' => [ 'base' => '<p>Provides a record of an event that affects a bot alias. For example, when the version of a bot that the alias points to changes.</p>', 'refs' => [ 'BotAliasHistoryEventsList$member' => NULL, ], ], 'BotAliasHistoryEventsList' => [ 'base' => NULL, 'refs' => [ 'DescribeBotAliasResponse$botAliasHistoryEvents' => '<p>A list of events that affect a bot alias. For example, an event is recorded when the version that the alias points to changes.</p>', ], ], 'BotAliasId' => [ 'base' => NULL, 'refs' => [ 'BotAliasSummary$botAliasId' => '<p>The unique identifier assigned to the bot alias. You can use this ID to get detailed information about the alias using the <a href="https://docs.aws.amazon.com/lexv2/latest/dg/API_DescribeBotAlias.html">DescribeBotAlias</a> operation.</p>', 'CreateBotAliasResponse$botAliasId' => '<p>The unique identifier of the bot alias.</p>', 'DeleteBotAliasRequest$botAliasId' => '<p>The unique identifier of the bot alias to delete.</p>', 'DeleteBotAliasResponse$botAliasId' => '<p>The unique identifier of the bot alias to delete.</p>', 'DescribeBotAliasRequest$botAliasId' => '<p>The identifier of the bot alias to describe.</p>', 'DescribeBotAliasResponse$botAliasId' => '<p>The identifier of the bot alias.</p>', 'ListAggregatedUtterancesRequest$botAliasId' => '<p>The identifier of the bot alias associated with this request. If you specify the bot alias, you can\'t specify the bot version.</p>', 'ListAggregatedUtterancesResponse$botAliasId' => '<p>The identifier of the bot alias that contains the utterances. If you specified the bot version, the bot alias ID isn\'t returned.</p>', 'UpdateBotAliasRequest$botAliasId' => '<p>The unique identifier of the bot alias.</p>', 'UpdateBotAliasResponse$botAliasId' => '<p>The identifier of the updated bot alias.</p>', ], ], 'BotAliasLocaleSettings' => [ 'base' => '<p>Specifies settings that are unique to a locale. For example, you can use different Lambda function depending on the bot\'s locale.</p>', 'refs' => [ 'BotAliasLocaleSettingsMap$value' => NULL, ], ], 'BotAliasLocaleSettingsMap' => [ 'base' => NULL, 'refs' => [ 'CreateBotAliasRequest$botAliasLocaleSettings' => '<p>Maps configuration information to a specific locale. You can use this parameter to specify a specific Lambda function to run different functions in different locales.</p>', 'CreateBotAliasResponse$botAliasLocaleSettings' => '<p>Configuration information for a specific locale.</p>', 'DescribeBotAliasResponse$botAliasLocaleSettings' => '<p>The locale settings that are unique to the alias.</p>', 'UpdateBotAliasRequest$botAliasLocaleSettings' => '<p>The new Lambda functions to use in each locale for the bot alias.</p>', 'UpdateBotAliasResponse$botAliasLocaleSettings' => '<p>The updated Lambda functions to use in each locale for the bot alias.</p>', ], ], 'BotAliasStatus' => [ 'base' => NULL, 'refs' => [ 'BotAliasSummary$botAliasStatus' => '<p>The current state of the bot alias. If the status is <code>Available</code>, the alias is ready for use.</p>', 'CreateBotAliasResponse$botAliasStatus' => '<p>The current status of the alias. The alias is first put into the <code>Creating</code> state. When the alias is ready to be used, it is put into the <code>Available</code> state. You can use the <code>DescribeBotAlias</code> operation to get the current state of an alias.</p>', 'DeleteBotAliasResponse$botAliasStatus' => '<p>The current status of the alias. The status is <code>Deleting</code> while the alias is in the process of being deleted. Once the alias is deleted, it will no longer appear in the list of aliases returned by the <code>ListBotAliases</code> operation.</p>', 'DescribeBotAliasResponse$botAliasStatus' => '<p>The current status of the alias. When the alias is <code>Available</code>, the alias is ready for use with your bot.</p>', 'UpdateBotAliasResponse$botAliasStatus' => '<p>The current status of the bot alias. When the status is <code>Available</code> the alias is ready for use.</p>', ], ], 'BotAliasSummary' => [ 'base' => '<p>Summary information about bot aliases returned from the <a href="https://docs.aws.amazon.com/lexv2/latest/dg/API_ListBotAliases.html">ListBotAliases</a> operation.</p>', 'refs' => [ 'BotAliasSummaryList$member' => NULL, ], ], 'BotAliasSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListBotAliasesResponse$botAliasSummaries' => '<p>Summary information for the bot aliases that meet the filter criteria specified in the request. The length of the list is specified in the <code>maxResults</code> parameter of the request. If there are more aliases available, the <code>nextToken</code> field contains a token to get the next page of results.</p>', ], ], 'BotExportSpecification' => [ 'base' => '<p>Provides the identity of a the bot that was exported.</p>', 'refs' => [ 'ExportResourceSpecification$botExportSpecification' => '<p>Parameters for exporting a bot.</p>', ], ], 'BotFilter' => [ 'base' => '<p>Filters the responses returned by the <code>ListBots</code> operation.</p>', 'refs' => [ 'BotFilters$member' => NULL, ], ], 'BotFilterName' => [ 'base' => NULL, 'refs' => [ 'BotFilter$name' => '<p>The name of the field to filter the list of bots.</p>', ], ], 'BotFilterOperator' => [ 'base' => NULL, 'refs' => [ 'BotFilter$operator' => '<p>The operator to use for the filter. Specify <code>EQ</code> when the <code>ListBots</code> operation should return only aliases that equal the specified value. Specify <code>CO</code> when the <code>ListBots</code> operation should return aliases that contain the specified value.</p>', ], ], 'BotFilters' => [ 'base' => NULL, 'refs' => [ 'ListBotsRequest$filters' => '<p>Provides the specification of a filter used to limit the bots in the response to only those that match the filter specification. You can only specify one filter and one string to filter on.</p>', ], ], 'BotImportSpecification' => [ 'base' => '<p>Provides the bot parameters required for importing a bot.</p>', 'refs' => [ 'ImportResourceSpecification$botImportSpecification' => '<p>Parameters for importing a bot.</p>', ], ], 'BotLocaleExportSpecification' => [ 'base' => '<p>Provides the bot locale parameters required for exporting a bot locale.</p>', 'refs' => [ 'ExportResourceSpecification$botLocaleExportSpecification' => '<p>Parameters for exporting a bot locale.</p>', ], ], 'BotLocaleFilter' => [ 'base' => '<p>Filters responses returned by the <code>ListBotLocales</code> operation.</p>', 'refs' => [ 'BotLocaleFilters$member' => NULL, ], ], 'BotLocaleFilterName' => [ 'base' => NULL, 'refs' => [ 'BotLocaleFilter$name' => '<p>The name of the field to filter the list of bots.</p>', ], ], 'BotLocaleFilterOperator' => [ 'base' => NULL, 'refs' => [ 'BotLocaleFilter$operator' => '<p>The operator to use for the filter. Specify <code>EQ</code> when the <code>ListBotLocales</code> operation should return only aliases that equal the specified value. Specify <code>CO</code> when the <code>ListBotLocales</code> operation should return aliases that contain the specified value.</p>', ], ], 'BotLocaleFilters' => [ 'base' => NULL, 'refs' => [ 'ListBotLocalesRequest$filters' => '<p>Provides the specification for a filter used to limit the response to only those locales that match the filter specification. You can only specify one filter and one value to filter on.</p>', ], ], 'BotLocaleHistoryEvent' => [ 'base' => '<p>Provides information about an event that occurred affecting the bot locale.</p>', 'refs' => [ 'BotLocaleHistoryEventsList$member' => NULL, ], ], 'BotLocaleHistoryEventDescription' => [ 'base' => NULL, 'refs' => [ 'BotLocaleHistoryEvent$event' => '<p>A description of the event that occurred.</p>', ], ], 'BotLocaleHistoryEventsList' => [ 'base' => NULL, 'refs' => [ 'DescribeBotLocaleResponse$botLocaleHistoryEvents' => '<p>History of changes, such as when a locale is used in an alias, that have taken place for the locale.</p>', ], ], 'BotLocaleImportSpecification' => [ 'base' => '<p>Provides the bot locale parameters required for importing a bot locale.</p>', 'refs' => [ 'ImportResourceSpecification$botLocaleImportSpecification' => '<p>Parameters for importing a bot locale.</p>', ], ], 'BotLocaleSortAttribute' => [ 'base' => NULL, 'refs' => [ 'BotLocaleSortBy$attribute' => '<p>The bot locale attribute to sort by.</p>', ], ], 'BotLocaleSortBy' => [ 'base' => '<p>Specifies attributes for sorting a list of bot locales.</p>', 'refs' => [ 'ListBotLocalesRequest$sortBy' => '<p>Specifies sorting parameters for the list of locales. You can sort by locale name in ascending or descending order.</p>', ], ], 'BotLocaleStatus' => [ 'base' => NULL, 'refs' => [ 'BotLocaleSummary$botLocaleStatus' => '<p>The current status of the bot locale. When the status is <code>Built</code> the locale is ready for use.</p>', 'BuildBotLocaleResponse$botLocaleStatus' => '<p>The bot\'s build status. When the status is <code>ReadyExpressTesting</code> you can test the bot using the utterances defined for the intents and slot types. When the status is <code>Built</code>, the bot is ready for use and can be tested using any utterance.</p>', 'CreateBotLocaleResponse$botLocaleStatus' => '<p>The status of the bot.</p> <p>When the status is <code>Creating</code> the bot locale is being configured. When the status is <code>Building</code> Amazon Lex is building the bot for testing and use.</p> <p>If the status of the bot is <code>ReadyExpressTesting</code>, you can test the bot using the exact utterances specified in the bots\' intents. When the bot is ready for full testing or to run, the status is <code>Built</code>.</p> <p>If there was a problem with building the bot, the status is <code>Failed</code>. If the bot was saved but not built, the status is <code>NotBuilt</code>.</p>', 'DeleteBotLocaleResponse$botLocaleStatus' => '<p>The status of deleting the bot locale. The locale first enters the <code>Deleting</code> status. Once the locale is deleted it no longer appears in the list of locales for the bot.</p>', 'DescribeBotLocaleResponse$botLocaleStatus' => '<p>The status of the bot. If the status is <code>Failed</code>, the reasons for the failure are listed in the <code>failureReasons</code> field.</p>', 'UpdateBotLocaleResponse$botLocaleStatus' => '<p>The current status of the locale. When the bot status is <code>Built</code> the locale is ready for use.</p>', ], ], 'BotLocaleSummary' => [ 'base' => '<p>Summary information about bot locales returned by the <a href="https://docs.aws.amazon.com/lexv2/latest/dg/API_ListBotLocales.html">ListBotLocales</a> operation.</p>', 'refs' => [ 'BotLocaleSummaryList$member' => NULL, ], ], 'BotLocaleSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListBotLocalesResponse$botLocaleSummaries' => '<p>Summary information for the locales that meet the filter criteria specified in the request. The length of the list is specified in the <code>maxResults</code> parameter of the request. If there are more locales available, the <code>nextToken</code> field contains a token to get the next page of results.</p>', ], ], 'BotRecommendationResultStatistics' => [ 'base' => '<p>A statistical summary of the bot recommendation results.</p>', 'refs' => [ 'BotRecommendationResults$statistics' => '<p>The statistical summary of the bot recommendation results.</p>', ], ], 'BotRecommendationResults' => [ 'base' => '<p>The object representing the URL of the bot definition, the URL of the associated transcript and a statistical summary of the bot recommendation results.</p>', 'refs' => [ 'DescribeBotRecommendationResponse$botRecommendationResults' => '<p>The object representing the URL of the bot definition, the URL of the associated transcript and a statistical summary of the bot recommendation results.</p>', ], ], 'BotRecommendationStatus' => [ 'base' => NULL, 'refs' => [ 'BotRecommendationSummary$botRecommendationStatus' => '<p>The status of the bot recommendation.</p> <p>If the status is Failed, then the reasons for the failure are listed in the failureReasons field. </p>', 'DescribeBotRecommendationResponse$botRecommendationStatus' => '<p>The status of the bot recommendation. If the status is Failed, then the reasons for the failure are listed in the failureReasons field. </p>', 'StartBotRecommendationResponse$botRecommendationStatus' => '<p>The status of the bot recommendation.</p> <p>If the status is Failed, then the reasons for the failure are listed in the failureReasons field. </p>', 'UpdateBotRecommendationResponse$botRecommendationStatus' => '<p>The status of the bot recommendation.</p> <p>If the status is Failed, then the reasons for the failure are listed in the failureReasons field. </p>', ], ], 'BotRecommendationSummary' => [ 'base' => '<p>A summary of the bot recommendation.</p>', 'refs' => [ 'BotRecommendationSummaryList$member' => NULL, ], ], 'BotRecommendationSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListBotRecommendationsResponse$botRecommendationSummaries' => '<p>Summary information for the bot recommendations that meet the filter specified in this request. The length of the list is specified in the maxResults parameter of the request. If there are more bot recommendations available, the nextToken field contains a token to get the next page of results.</p>', ], ], 'BotSortAttribute' => [ 'base' => NULL, 'refs' => [ 'BotSortBy$attribute' => '<p>The attribute to use to sort the list of bots.</p>', ], ], 'BotSortBy' => [ 'base' => '<p>Specifies attributes for sorting a list of bots.</p>', 'refs' => [ 'ListBotsRequest$sortBy' => '<p>Specifies sorting parameters for the list of bots. You can specify that the list be sorted by bot name in ascending or descending order.</p>', ], ], 'BotStatus' => [ 'base' => NULL, 'refs' => [ 'BotSummary$botStatus' => '<p>The current status of the bot. When the status is <code>Available</code> the bot is ready for use.</p>', 'BotVersionSummary$botStatus' => '<p>The status of the bot. When the status is available, the version of the bot is ready for use.</p>', 'CreateBotResponse$botStatus' => '<p>Shows the current status of the bot. The bot is first in the <code>Creating</code> status. Once the bot is read for use, it changes to the <code>Available</code> status. After the bot is created, you can use the <code>Draft</code> version of the bot.</p>', 'CreateBotVersionResponse$botStatus' => '<p>When you send a request to create or update a bot, Amazon Lex sets the status response element to <code>Creating</code>. After Amazon Lex builds the bot, it sets status to <code>Available</code>. If Amazon Lex can\'t build the bot, it sets status to <code>Failed</code>.</p>', 'DeleteBotResponse$botStatus' => '<p>The current status of the bot. The status is <code>Deleting</code> while the bot and its associated resources are being deleted.</p>', 'DeleteBotVersionResponse$botStatus' => '<p>The current status of the bot. </p>', 'DescribeBotResponse$botStatus' => '<p>The current status of the bot. When the status is <code>Available</code> the bot is ready to be used in conversations with users.</p>', 'DescribeBotVersionResponse$botStatus' => '<p>The current status of the bot. When the status is <code>Available</code>, the bot version is ready for use.</p>', 'UpdateBotResponse$botStatus' => '<p>Shows the current status of the bot. The bot is first in the <code>Creating</code> status. Once the bot is read for use, it changes to the <code>Available</code> status. After the bot is created, you can use the <code>DRAFT</code> version of the bot.</p>', ], ], 'BotSummary' => [ 'base' => '<p>Summary information about a bot returned by the <a href="https://docs.aws.amazon.com/lexv2/latest/dg/API_ListBots.html">ListBots</a> operation.</p>', 'refs' => [ 'BotSummaryList$member' => NULL, ], ], 'BotSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListBotsResponse$botSummaries' => '<p>Summary information for the bots that meet the filter criteria specified in the request. The length of the list is specified in the <code>maxResults</code> parameter of the request. If there are more bots available, the <code>nextToken</code> field contains a token to the next page of results.</p>', ], ], 'BotVersion' => [ 'base' => NULL, 'refs' => [ 'BotAliasHistoryEvent$botVersion' => '<p>The version of the bot that was used in the event. </p>', 'BotAliasSummary$botVersion' => '<p>The version of the bot that the bot alias references.</p>', 'BotExportSpecification$botVersion' => '<p>The version of the bot that was exported. This will be either <code>DRAFT</code> or the version number.</p>', 'BotLocaleExportSpecification$botVersion' => '<p>The version of the bot to export.</p>', 'BotVersionLocaleDetails$sourceBotVersion' => '<p>The version of a bot used for a bot locale.</p>', 'BotVersionSummary$botVersion' => '<p>The numeric version of the bot, or <code>DRAFT</code> to indicate that this is the version of the bot that can be updated..</p>', 'CustomVocabularyExportSpecification$botVersion' => '<p>The version of the bot that contains the custom vocabulary to export.</p>', 'DescribeBotAliasResponse$botVersion' => '<p>The version of the bot associated with the bot alias.</p>', 'DescribeBotLocaleRequest$botVersion' => '<p>The identifier of the version of the bot associated with the locale.</p>', 'DescribeBotLocaleResponse$botVersion' => '<p>The identifier of the version of the bot associated with the locale.</p>', 'DescribeCustomVocabularyMetadataRequest$botVersion' => '<p>The bot version of the bot to return metadata for.</p>', 'DescribeCustomVocabularyMetadataResponse$botVersion' => '<p>The version of the bot that contains the custom vocabulary to describe.</p>', 'DescribeIntentRequest$botVersion' => '<p>The version of the bot associated with the intent.</p>', 'DescribeSlotRequest$botVersion' => '<p>The version of the bot associated with the slot.</p>', 'DescribeSlotResponse$botVersion' => '<p>The version of the bot associated with the slot.</p>', 'DescribeSlotTypeRequest$botVersion' => '<p>The version of the bot associated with the slot type.</p>', 'DescribeSlotTypeResponse$botVersion' => '<p>The version of the bot associated with the slot type.</p>', 'ListAggregatedUtterancesRequest$botVersion' => '<p>The identifier of the bot version associated with this request. If you specify the bot version, you can\'t specify the bot alias.</p>', 'ListAggregatedUtterancesResponse$botVersion' => '<p>The identifier of the bot version that contains the utterances. If you specified the bot alias, the bot version isn\'t returned.</p>', 'ListBotLocalesRequest$botVersion' => '<p>The version of the bot to list locales for.</p>', 'ListBotLocalesResponse$botVersion' => '<p>The version of the bot.</p>', 'ListExportsRequest$botVersion' => '<p>The version of the bot to list exports for. </p>', 'ListExportsResponse$botVersion' => '<p>The version of the bot that was exported.</p>', 'ListIntentsRequest$botVersion' => '<p>The version of the bot that contains the intent.</p>', 'ListIntentsResponse$botVersion' => '<p>The version of the bot that contains the intent.</p>', 'ListSlotTypesRequest$botVersion' => '<p>The version of the bot that contains the slot type.</p>', 'ListSlotTypesResponse$botVersion' => '<p>The version of the bot that contains the slot types.</p>', 'ListSlotsRequest$botVersion' => '<p>The version of the bot that contains the slot.</p>', 'ListSlotsResponse$botVersion' => '<p>The version of the bot that contains the slots.</p>', 'SearchAssociatedTranscriptsRequest$botVersion' => '<p>The version of the bot containing the transcripts that you are searching.</p>', 'SearchAssociatedTranscriptsResponse$botVersion' => '<p>The version of the bot containing the transcripts that you are searching.</p>', 'UpdateBotAliasRequest$botVersion' => '<p>The new bot version to assign to the bot alias.</p>', 'UpdateBotAliasResponse$botVersion' => '<p>The updated version of the bot that the alias points to.</p>', ], ], 'BotVersionLocaleDetails' => [ 'base' => '<p>The version of a bot used for a bot locale.</p>', 'refs' => [ 'BotVersionLocaleSpecification$value' => NULL, ], ], 'BotVersionLocaleSpecification' => [ 'base' => NULL, 'refs' => [ 'CreateBotVersionRequest$botVersionLocaleSpecification' => '<p>Specifies the locales that Amazon Lex adds to this version. You can choose the <code>Draft</code> version or any other previously published version for each locale. When you specify a source version, the locale data is copied from the source version to the new version.</p>', 'CreateBotVersionResponse$botVersionLocaleSpecification' => '<p>The source versions used for each locale in the new version.</p>', ], ], 'BotVersionSortAttribute' => [ 'base' => NULL, 'refs' => [ 'BotVersionSortBy$attribute' => '<p>The attribute to use to sort the list of versions.</p>', ], ], 'BotVersionSortBy' => [ 'base' => '<p>Specifies attributes for sorting a list of bot versions.</p>', 'refs' => [ 'ListBotVersionsRequest$sortBy' => '<p>Specifies sorting parameters for the list of versions. You can specify that the list be sorted by version name in either ascending or descending order.</p>', ], ], 'BotVersionSummary' => [ 'base' => '<p>Summary information about a bot version returned by the <a href="https://docs.aws.amazon.com/lexv2/latest/dg/API_ListBotVersions.html">ListBotVersions</a> operation.</p>', 'refs' => [ 'BotVersionSummaryList$member' => NULL, ], ], 'BotVersionSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListBotVersionsResponse$botVersionSummaries' => '<p>Summary information for the bot versions that meet the filter criteria specified in the request. The length of the list is specified in the <code>maxResults</code> parameter of the request. If there are more versions available, the <code>nextToken</code> field contains a token to get the next page of results.</p>', ], ], 'BoxedBoolean' => [ 'base' => NULL, 'refs' => [ 'AggregatedUtterancesSummary$containsDataFromDeletedResources' => '<p>Aggregated utterance data may contain utterances from versions of your bot that have since been deleted. When the aggregated contains this kind of data, this field is set to true.</p>', 'FulfillmentStartResponseSpecification$allowInterrupt' => '<p>Determines whether the user can interrupt the start message while it is playing.</p>', 'FulfillmentUpdateResponseSpecification$allowInterrupt' => '<p>Determines whether the user can interrupt an update message while it is playing.</p>', 'FulfillmentUpdatesSpecification$active' => '<p>Determines whether fulfillment updates are sent to the user. When this field is true, updates are sent.</p> <p>If the <code>active</code> field is set to true, the <code>startResponse</code>, <code>updateResponse</code>, and <code>timeoutInSeconds</code> fields are required.</p>', 'IntentClosingSetting$active' => '<p>Specifies whether an intent\'s closing response is used. When this field is false, the closing response isn\'t sent to the user. If the <code>active</code> field isn\'t specified, the default is true.</p>', 'IntentConfirmationSetting$active' => '<p>Specifies whether the intent\'s confirmation is sent to the user. When this field is false, confirmation and declination responses aren\'t sent. If the <code>active</code> field isn\'t specified, the default is true.</p>', 'PromptSpecification$allowInterrupt' => '<p>Indicates whether the user can interrupt a speech prompt from the bot.</p>', 'ResponseSpecification$allowInterrupt' => '<p>Indicates whether the user can interrupt a speech response from Amazon Lex.</p>', 'StillWaitingResponseSpecification$allowInterrupt' => '<p>Indicates that the user can interrupt the response by speaking while the message is being played.</p>', 'WaitAndContinueSpecification$active' => '<p>Specifies whether the bot will wait for a user to respond. When this field is false, wait and continue responses for a slot aren\'t used. If the <code>active</code> field isn\'t specified, the default is true.</p>', ], ], 'BuildBotLocaleRequest' => [ 'base' => NULL, 'refs' => [], ], 'BuildBotLocaleResponse' => [ 'base' => NULL, 'refs' => [], ], 'BuiltInIntentSortAttribute' => [ 'base' => NULL, 'refs' => [ 'BuiltInIntentSortBy$attribute' => '<p>The attribute to use to sort the list of built-in intents.</p>', ], ], 'BuiltInIntentSortBy' => [ 'base' => '<p>Specifies attributes for sorting a list of built-in intents.</p>', 'refs' => [ 'ListBuiltInIntentsRequest$sortBy' => '<p>Specifies sorting parameters for the list of built-in intents. You can specify that the list be sorted by the built-in intent signature in either ascending or descending order.</p>', ], ], 'BuiltInIntentSummary' => [ 'base' => '<p>Provides summary information about a built-in intent for the <a href="https://docs.aws.amazon.com/lexv2/latest/dg/API_ListBuiltInIntents.html"> ListBuiltInIntents </a> operation.</p>', 'refs' => [ 'BuiltInIntentSummaryList$member' => NULL, ], ], 'BuiltInIntentSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListBuiltInIntentsResponse$builtInIntentSummaries' => '<p>Summary information for the built-in intents that meet the filter criteria specified in the request. The length of the list is specified in the <code>maxResults</code> parameter of the request. If there are more intents available, the <code>nextToken</code> field contains a token to get the next page of results.</p>', ], ], 'BuiltInOrCustomSlotTypeId' => [ 'base' => NULL, 'refs' => [ 'CreateSlotRequest$slotTypeId' => '<p>The unique identifier for the slot type associated with this slot. The slot type determines the values that can be entered into the slot.</p>', 'CreateSlotResponse$slotTypeId' => '<p>The unique identifier of the slot type associated with this slot.</p>', 'DescribeSlotResponse$slotTypeId' => '<p>The identifier of the slot type that determines the values entered into the slot.</p>', 'SlotSummary$slotTypeId' => '<p>The unique identifier for the slot type that defines the values for the slot.</p>', 'UpdateSlotRequest$slotTypeId' => '<p>The unique identifier of the new slot type to associate with this slot. </p>', 'UpdateSlotResponse$slotTypeId' => '<p>The updated identifier of the slot type that provides values for the slot.</p>', ], ], 'BuiltInSlotTypeSortAttribute' => [ 'base' => NULL, 'refs' => [ 'BuiltInSlotTypeSortBy$attribute' => '<p>The attribute to use to sort the list of built-in intents.</p>', ], ], 'BuiltInSlotTypeSortBy' => [ 'base' => '<p>Specifies attributes for sorting a list of built-in slot types.</p>', 'refs' => [ 'ListBuiltInSlotTypesRequest$sortBy' => '<p>Determines the sort order for the response from the <code>ListBuiltInSlotTypes</code> operation. You can choose to sort by the slot type signature in either ascending or descending order.</p>', ], ], 'BuiltInSlotTypeSummary' => [ 'base' => '<p>Provides summary information about a built-in slot type for the <a href="https://docs.aws.amazon.com/lexv2/latest/dg/API_ListBuiltInSlotTypes.html"> ListBuiltInSlotTypes </a> operation.</p>', 'refs' => [ 'BuiltInSlotTypeSummaryList$member' => NULL, ], ], 'BuiltInSlotTypeSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListBuiltInSlotTypesResponse$builtInSlotTypeSummaries' => '<p>Summary information for the built-in slot types that meet the filter criteria specified in the request. The length of the list is specified in the <code>maxResults</code> parameter of the request. If there are more slot types available, the <code>nextToken</code> field contains a token to get the next page of results.</p>', ], ], 'BuiltInsMaxResults' => [ 'base' => NULL, 'refs' => [ 'ListBuiltInIntentsRequest$maxResults' => '<p>The maximum number of built-in intents to return in each page of results. If there are fewer results than the max page size, only the actual number of results are returned.</p>', 'ListBuiltInSlotTypesRequest$maxResults' => '<p>The maximum number of built-in slot types to return in each page of results. If there are fewer results than the max page size, only the actual number of results are returned.</p>', ], ], 'Button' => [ 'base' => '<p>Describes a button to use on a response card used to gather slot values from a user.</p>', 'refs' => [ 'ButtonsList$member' => NULL, ], ], 'ButtonText' => [ 'base' => NULL, 'refs' => [ 'Button$text' => '<p>The text that appears on the button. Use this to tell the user what value is returned when they choose this button.</p>', ], ], 'ButtonValue' => [ 'base' => NULL, 'refs' => [ 'Button$value' => '<p>The value returned to Amazon Lex when the user chooses this button. This must be one of the slot values configured for the slot.</p>', ], ], 'ButtonsList' => [ 'base' => NULL, 'refs' => [ 'ImageResponseCard$buttons' => '<p>A list of buttons that should be displayed on the response card. The arrangement of the buttons is determined by the platform that displays the button.</p>', ], ], 'ChildDirected' => [ 'base' => NULL, 'refs' => [ 'DataPrivacy$childDirected' => '<p>For each Amazon Lex bot created with the Amazon Lex Model Building Service, you must specify whether your use of Amazon Lex is related to a website, program, or other application that is directed or targeted, in whole or in part, to children under age 13 and subject to the Children\'s Online Privacy Protection Act (COPPA) by specifying <code>true</code> or <code>false</code> in the <code>childDirected</code> field. By specifying <code>true</code> in the <code>childDirected</code> field, you confirm that your use of Amazon Lex <b>is</b> related to a website, program, or other application that is directed or targeted, in whole or in part, to children under age 13 and subject to COPPA. By specifying <code>false</code> in the <code>childDirected</code> field, you confirm that your use of Amazon Lex <b>is not</b> related to a website, program, or other application that is directed or targeted, in whole or in part, to children under age 13 and subject to COPPA. You may not specify a default value for the <code>childDirected</code> field that does not accurately reflect whether your use of Amazon Lex is related to a website, program, or other application that is directed or targeted, in whole or in part, to children under age 13 and subject to COPPA. If your use of Amazon Lex relates to a website, program, or other application that is directed in whole or in part, to children under age 13, you must obtain any required verifiable parental consent under COPPA. For information regarding the use of Amazon Lex in connection with websites, programs, or other applications that are directed or targeted, in whole or in part, to children under age 13, see the <a href="https://aws.amazon.com/lex/faqs#data-security">Amazon Lex FAQ</a>.</p>', ], ], 'CloudWatchLogGroupArn' => [ 'base' => NULL, 'refs' => [ 'CloudWatchLogGroupLogDestination$cloudWatchLogGroupArn' => '<p>The Amazon Resource Name (ARN) of the log group where text and metadata logs are delivered.</p>', ], ], 'CloudWatchLogGroupLogDestination' => [ 'base' => '<p>The Amazon CloudWatch Logs log group where the text and metadata logs are delivered. The log group must exist before you enable logging.</p>', 'refs' => [ 'TextLogDestination$cloudWatch' => '<p>Defines the Amazon CloudWatch Logs log group where text and metadata logs are delivered.</p>', ], ], 'CodeHookInterfaceVersion' => [ 'base' => NULL, 'refs' => [ 'LambdaCodeHook$codeHookInterfaceVersion' => '<p>The version of the request-response that you want Amazon Lex to use to invoke your Lambda function.</p>', ], ], 'CodeHookSpecification' => [ 'base' => '<p>Contains information about code hooks that Amazon Lex calls during a conversation.</p>', 'refs' => [ 'BotAliasLocaleSettings$codeHookSpecification' => '<p>Specifies the Lambda function that should be used in the locale.</p>', ], ], 'ConditionKey' => [ 'base' => NULL, 'refs' => [ 'ConditionKeyValueMap$key' => NULL, ], ], 'ConditionKeyValueMap' => [ 'base' => NULL, 'refs' => [ 'ConditionMap$value' => NULL, ], ], 'ConditionMap' => [ 'base' => NULL, 'refs' => [ 'CreateResourcePolicyStatementRequest$condition' => '<p>Specifies a condition when the policy is in effect. If the principal of the policy is a service principal, you must provide two condition blocks, one with a SourceAccount global condition key and one with a SourceArn global condition key.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition.html">IAM JSON policy elements: Condition </a>.</p>', ], ], 'ConditionOperator' => [ 'base' => NULL, 'refs' => [ 'ConditionMap$key' => NULL, ], ], 'ConditionValue' => [ 'base' => NULL, 'refs' => [ 'ConditionKeyValueMap$value' => NULL, ], ], 'ConfidenceThreshold' => [ 'base' => NULL, 'refs' => [ 'BotLocaleImportSpecification$nluIntentConfidenceThreshold' => '<p>Determines the threshold where Amazon Lex will insert the <code>AMAZON.FallbackIntent</code>, <code>AMAZON.KendraSearchIntent</code>, or both when returning alternative intents. <code>AMAZON.FallbackIntent</code> and <code>AMAZON.KendraSearchIntent</code> are only inserted if they are configured for the bot. </p> <p>For example, suppose a bot is configured with the confidence threshold of 0.80 and the <code>AMAZON.FallbackIntent</code>. Amazon Lex returns three alternative intents with the following confidence scores: IntentA (0.70), IntentB (0.60), IntentC (0.50). The response from the <code>PostText</code> operation would be:</p> <ul> <li> <p> <code>AMAZON.FallbackIntent</code> </p> </li> <li> <p> <code>IntentA</code> </p> </li> <li> <p> <code>IntentB</code> </p> </li> <li> <p> <code>IntentC</code> </p> </li> </ul>', 'CreateBotLocaleRequest$nluIntentConfidenceThreshold' => '<p>Determines the threshold where Amazon Lex will insert the <code>AMAZON.FallbackIntent</code>, <code>AMAZON.KendraSearchIntent</code>, or both when returning alternative intents. <code>AMAZON.FallbackIntent</code> and <code>AMAZON.KendraSearchIntent</code> are only inserted if they are configured for the bot.</p> <p>For example, suppose a bot is configured with the confidence threshold of 0.80 and the <code>AMAZON.FallbackIntent</code>. Amazon Lex returns three alternative intents with the following confidence scores: IntentA (0.70), IntentB (0.60), IntentC (0.50). The response from the <code>RecognizeText</code> operation would be:</p> <ul> <li> <p>AMAZON.FallbackIntent</p> </li> <li> <p>IntentA</p> </li> <li> <p>IntentB</p> </li> <li> <p>IntentC</p> </li> </ul>', 'CreateBotLocaleResponse$nluIntentConfidenceThreshold' => '<p>The specified confidence threshold for inserting the <code>AMAZON.FallbackIntent</code> and <code>AMAZON.KendraSearchIntent</code> intents.</p>', 'DescribeBotLocaleResponse$nluIntentConfidenceThreshold' => '<p>The confidence threshold where Amazon Lex inserts the <code>AMAZON.FallbackIntent</code> and <code>AMAZON.KendraSearchIntent</code> intents in the list of possible intents for an utterance.</p>', 'UpdateBotLocaleRequest$nluIntentConfidenceThreshold' => '<p>The new confidence threshold where Amazon Lex inserts the <code>AMAZON.FallbackIntent</code> and <code>AMAZON.KendraSearchIntent</code> intents in the list of possible intents for an utterance.</p>', 'UpdateBotLocaleResponse$nluIntentConfidenceThreshold' => '<p>The updated confidence threshold for inserting the <code>AMAZON.FallbackIntent</code> and <code>AMAZON.KendraSearchIntent</code> intents in the list of possible intents for an utterance.</p>', ], ], 'ConflictException' => [ 'base' => '<p>The action that you tried to perform couldn\'t be completed because the resource is in a conflicting state. For example, deleting a bot that is in the CREATING state. Try your request again. </p>', 'refs' => [], ], 'ContextTimeToLiveInSeconds' => [ 'base' => NULL, 'refs' => [ 'OutputContext$timeToLiveInSeconds' => '<p>The amount of time, in seconds, that the output context should remain active. The time is figured from the first time the context is sent to the user.</p>', ], ], 'ContextTurnsToLive' => [ 'base' => NULL, 'refs' => [ 'OutputContext$turnsToLive' => '<p>The number of conversation turns that the output context should remain active. The number of turns is counted from the first time that the context is sent to the user.</p>', ], ], 'ConversationLogSettings' => [ 'base' => '<p>Configures conversation logging that saves audio, text, and metadata for the conversations with your users.</p>', 'refs' => [ 'CreateBotAliasRequest$conversationLogSettings' => '<p>Specifies whether Amazon Lex logs text and audio for a conversation with the bot. When you enable conversation logs, text logs store text input, transcripts of audio input, and associated metadata in Amazon CloudWatch Logs. Audio logs store audio input in Amazon S3.</p>', 'CreateBotAliasResponse$conversationLogSettings' => '<p>The conversation log settings specified for the alias.</p>', 'DescribeBotAliasResponse$conversationLogSettings' => '<p>Specifics of how Amazon Lex logs text and audio conversations with the bot associated with the alias.</p>', 'UpdateBotAliasRequest$conversationLogSettings' => '<p>The new settings for storing conversation logs in Amazon CloudWatch Logs and Amazon S3 buckets.</p>', 'UpdateBotAliasResponse$conversationLogSettings' => '<p>The updated settings for storing conversation logs in Amazon CloudWatch Logs and Amazon S3 buckets.</p>', ], ], 'Count' => [ 'base' => NULL, 'refs' => [ 'IntentStatistics$discoveredIntentCount' => '<p>The number of recommended intents associated with the bot recommendation.</p>', 'SlotTypeStatistics$discoveredSlotTypeCount' => '<p>The number of recommended slot types associated with the bot recommendation.</p>', ], ], 'CreateBotAliasRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateBotAliasResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateBotLocaleRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateBotLocaleResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateBotRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateBotResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateBotVersionRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateBotVersionResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateExportRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateExportResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateIntentRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateIntentResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateResourcePolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateResourcePolicyResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateResourcePolicyStatementRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateResourcePolicyStatementResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateSlotRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateSlotResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateSlotTypeRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateSlotTypeResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateUploadUrlRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateUploadUrlResponse' => [ 'base' => NULL, 'refs' => [], ], 'CustomPayload' => [ 'base' => '<p>A custom response string that Amazon Lex sends to your application. You define the content and structure the string.</p>', 'refs' => [ 'Message$customPayload' => '<p>A message in a custom format defined by the client application.</p>', ], ], 'CustomPayloadValue' => [ 'base' => NULL, 'refs' => [ 'CustomPayload$value' => '<p>The string that is sent to your application.</p>', ], ], 'CustomVocabularyExportSpecification' => [ 'base' => '<p>Provides the parameters required for exporting a custom vocabulary.</p>', 'refs' => [ 'ExportResourceSpecification$customVocabularyExportSpecification' => '<p>The parameters required to export a custom vocabulary.</p>', ], ], 'CustomVocabularyImportSpecification' => [ 'base' => '<p>Provides the parameters required for importing a custom vocabulary.</p>', 'refs' => [ 'ImportResourceSpecification$customVocabularyImportSpecification' => NULL, ], ], 'CustomVocabularyStatus' => [ 'base' => NULL, 'refs' => [ 'DeleteCustomVocabularyResponse$customVocabularyStatus' => '<p>The status of removing the custom vocabulary.</p>', 'DescribeCustomVocabularyMetadataResponse$customVocabularyStatus' => '<p>The status of the custom vocabulary. If the status is <code>Ready</code> the custom vocabulary is ready to use.</p>', ], ], 'DataPrivacy' => [ 'base' => '<p>By default, data stored by Amazon Lex is encrypted. The <code>DataPrivacy</code> structure provides settings that determine how Amazon Lex handles special cases of securing the data for your bot. </p>', 'refs' => [ 'BotImportSpecification$dataPrivacy' => NULL, 'CreateBotRequest$dataPrivacy' => '<p>Provides information on additional privacy protections Amazon Lex should use with the bot\'s data.</p>', 'CreateBotResponse$dataPrivacy' => '<p>The data privacy settings specified for the bot.</p>', 'DescribeBotResponse$dataPrivacy' => '<p>Settings for managing data privacy of the bot and its conversations with users.</p>', 'DescribeBotVersionResponse$dataPrivacy' => '<p>Data privacy settings for the bot version.</p>', 'UpdateBotRequest$dataPrivacy' => '<p>Provides information on additional privacy protections Amazon Lex should use with the bot\'s data.</p>', 'UpdateBotResponse$dataPrivacy' => '<p>The data privacy settings for the bot after the update.</p>', ], ], 'DateRangeFilter' => [ 'base' => '<p>The object used for specifying the data range that the customer wants Amazon Lex to read through in the input transcripts.</p>', 'refs' => [ 'LexTranscriptFilter$dateRangeFilter' => '<p>The object that contains a date range filter that will be applied to the transcript. Specify this object if you want Amazon Lex to only read the files that are within the date range.</p>', ], ], 'DeleteBotAliasRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteBotAliasResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteBotLocaleRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteBotLocaleResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteBotRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteBotResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteBotVersionRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteBotVersionResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteCustomVocabularyRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteCustomVocabularyResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteExportRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteExportResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteImportRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteImportResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteIntentRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteResourcePolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteResourcePolicyResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteResourcePolicyStatementRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteResourcePolicyStatementResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteSlotRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteSlotTypeRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteUtterancesRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteUtterancesResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeBotAliasRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeBotAliasResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeBotLocaleRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeBotLocaleResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeBotRecommendationRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeBotRecommendationResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeBotRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeBotResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeBotVersionRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeBotVersionResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeCustomVocabularyMetadataRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeCustomVocabularyMetadataResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeExportRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeExportResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeImportRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeImportResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeIntentRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeIntentResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeResourcePolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeResourcePolicyResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeSlotRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeSlotResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeSlotTypeRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeSlotTypeResponse' => [ 'base' => NULL, 'refs' => [], ], 'Description' => [ 'base' => NULL, 'refs' => [ 'BotAliasSummary$description' => '<p>The description of the bot alias.</p>', 'BotLocaleSummary$description' => '<p>The description of the bot locale.</p>', 'BotSummary$description' => '<p>The description of the bot.</p>', 'BotVersionSummary$description' => '<p>The description of the version.</p>', 'BuiltInIntentSummary$description' => '<p>The description of the intent.</p>', 'BuiltInSlotTypeSummary$description' => '<p>The description of the built-in slot type.</p>', 'CreateBotAliasRequest$description' => '<p>A description of the alias. Use this description to help identify the alias.</p>', 'CreateBotAliasResponse$description' => '<p>The description specified for the bot alias.</p>', 'CreateBotLocaleRequest$description' => '<p>A description of the bot locale. Use this to help identify the bot locale in lists.</p>', 'CreateBotLocaleResponse$description' => '<p>The specified description of the bot locale.</p>', 'CreateBotRequest$description' => '<p>A description of the bot. It appears in lists to help you identify a particular bot.</p>', 'CreateBotResponse$description' => '<p>The description specified for the bot.</p>', 'CreateBotVersionRequest$description' => '<p>A description of the version. Use the description to help identify the version in lists.</p>', 'CreateBotVersionResponse$description' => '<p>The description of the version specified in the request.</p>', 'CreateIntentRequest$description' => '<p>A description of the intent. Use the description to help identify the intent in lists.</p>', 'CreateIntentResponse$description' => '<p>The description specified for the intent.</p>', 'CreateSlotRequest$description' => '<p>A description of the slot. Use this to help identify the slot in lists.</p>', 'CreateSlotResponse$description' => '<p>The description associated with the slot.</p>', 'CreateSlotTypeRequest$description' => '<p>A description of the slot type. Use the description to help identify the slot type in lists.</p>', 'CreateSlotTypeResponse$description' => '<p>The description specified for the slot type.</p>', 'DescribeBotAliasResponse$description' => '<p>The description of the bot alias.</p>', 'DescribeBotLocaleResponse$description' => '<p>The description of the locale.</p>', 'DescribeBotResponse$description' => '<p>The description of the bot. </p>', 'DescribeBotVersionResponse$description' => '<p>The description specified for the bot.</p>', 'DescribeIntentResponse$description' => '<p>The description of the intent.</p>', 'DescribeSlotResponse$description' => '<p>The description specified for the slot.</p>', 'DescribeSlotTypeResponse$description' => '<p>The description specified for the slot type.</p>', 'IntentSummary$description' => '<p>The description of the intent.</p>', 'SlotSummary$description' => '<p>The description of the slot.</p>', 'SlotTypeSummary$description' => '<p>The description of the slot type.</p>', 'UpdateBotAliasRequest$description' => '<p>The new description to assign to the bot alias.</p>', 'UpdateBotAliasResponse$description' => '<p>The updated description of the bot alias.</p>', 'UpdateBotLocaleRequest$description' => '<p>The new description of the locale.</p>', 'UpdateBotLocaleResponse$description' => '<p>The updated description of the locale.</p>', 'UpdateBotRequest$description' => '<p>A description of the bot.</p>', 'UpdateBotResponse$description' => '<p>The description of the bot after the update.</p>', 'UpdateIntentRequest$description' => '<p>The new description of the intent.</p>', 'UpdateIntentResponse$description' => '<p>The updated description of the intent.</p>', 'UpdateSlotRequest$description' => '<p>The new description for the slot.</p>', 'UpdateSlotResponse$description' => '<p>The updated description of the bot.</p>', 'UpdateSlotTypeRequest$description' => '<p>The new description of the slot type.</p>', 'UpdateSlotTypeResponse$description' => '<p>The updated description of the slot type.</p>', ], ], 'DialogCodeHookSettings' => [ 'base' => '<p>Settings that determine the Lambda function that Amazon Lex uses for processing user responses.</p>', 'refs' => [ 'CreateIntentRequest$dialogCodeHook' => '<p>Specifies that Amazon Lex invokes the alias Lambda function for each user input. You can invoke this Lambda function to personalize user interaction.</p> <p>For example, suppose that your bot determines that the user\'s name is John. You Lambda function might retrieve John\'s information from a backend database and prepopulate some of the values. For example, if you find that John is gluten intolerant, you might set the corresponding intent slot, <code>glutenIntolerant</code> to <code>true</code>. You might find John\'s phone number and set the corresponding session attribute.</p>', 'CreateIntentResponse$dialogCodeHook' => '<p>The dialog Lambda function specified for the intent.</p>', 'DescribeIntentResponse$dialogCodeHook' => '<p>The Lambda function called during each turn of a conversation with the intent.</p>', 'UpdateIntentRequest$dialogCodeHook' => '<p>The new Lambda function to use between each turn of the conversation with the bot.</p>', 'UpdateIntentResponse$dialogCodeHook' => '<p>The updated Lambda function called during each turn of the conversation with the user.</p>', ], ], 'DraftBotVersion' => [ 'base' => NULL, 'refs' => [ 'BotLocaleImportSpecification$botVersion' => '<p>The version of the bot to import the locale to. This can only be the <code>DRAFT</code> version of the bot.</p>', 'BuildBotLocaleRequest$botVersion' => '<p>The version of the bot to build. This can only be the draft version of the bot.</p>', 'BuildBotLocaleResponse$botVersion' => '<p>The version of the bot that was built. This is only the draft version of the bot.</p>', 'CreateBotLocaleRequest$botVersion' => '<p>The version of the bot to create the locale for. This can only be the draft version of the bot.</p>', 'CreateBotLocaleResponse$botVersion' => '<p>The specified bot version.</p>', 'CreateIntentRequest$botVersion' => '<p>The identifier of the version of the bot associated with this intent.</p>', 'CreateIntentResponse$botVersion' => '<p>The identifier of the version of the bot associated with the intent.</p>', 'CreateSlotRequest$botVersion' => '<p>The version of the bot associated with the slot.</p>', 'CreateSlotResponse$botVersion' => '<p>The version of the bot associated with the slot.</p>', 'CreateSlotTypeRequest$botVersion' => '<p>The identifier of the bot version associated with this slot type.</p>', 'CreateSlotTypeResponse$botVersion' => '<p>The version of the bot associated with the slot type.</p>', 'CustomVocabularyImportSpecification$botVersion' => '<p>The version of the bot to import the custom vocabulary to.</p>', 'DeleteBotLocaleRequest$botVersion' => '<p>The version of the bot that contains the locale. </p>', 'DeleteBotLocaleResponse$botVersion' => '<p>The version of the bot that contained the deleted locale.</p>', 'DeleteCustomVocabularyRequest$botVersion' => '<p>The version of the bot to remove the custom vocabulary from.</p>', 'DeleteCustomVocabularyResponse$botVersion' => '<p>The version of the bot that the custom vocabulary was removed from.</p>', 'DeleteIntentRequest$botVersion' => '<p>The version of the bot associated with the intent.</p>', 'DeleteSlotRequest$botVersion' => '<p>The version of the bot associated with the slot to delete.</p>', 'DeleteSlotTypeRequest$botVersion' => '<p>The version of the bot associated with the slot type.</p>', 'DescribeBotRecommendationRequest$botVersion' => '<p>The version of the bot associated with the bot recommendation.</p>', 'DescribeBotRecommendationResponse$botVersion' => '<p>The version of the bot associated with the bot recommendation.</p>', 'DescribeIntentResponse$botVersion' => '<p>The version of the bot associated with the intent.</p>', 'ListBotRecommendationsRequest$botVersion' => '<p>The version of the bot that contains the bot recommendation list.</p>', 'ListBotRecommendationsResponse$botVersion' => '<p>The version of the bot that contains the bot recommendation list.</p>', 'ListImportsRequest$botVersion' => '<p>The version of the bot to list imports for.</p>', 'ListImportsResponse$botVersion' => '<p>The version of the bot that was imported. It will always be <code>DRAFT</code>.</p>', 'ListRecommendedIntentsRequest$botVersion' => '<p>The version of the bot that contains the recommended intents.</p>', 'ListRecommendedIntentsResponse$botVersion' => '<p>The version of the bot that contains the intent.</p>', 'StartBotRecommendationRequest$botVersion' => '<p>The version of the bot containing the bot recommendation.</p>', 'StartBotRecommendationResponse$botVersion' => '<p>The version of the bot containing the bot recommendation.</p>', 'UpdateBotLocaleRequest$botVersion' => '<p>The version of the bot that contains the locale to be updated. The version can only be the <code>DRAFT</code> version.</p>', 'UpdateBotLocaleResponse$botVersion' => '<p>The version of the bot that contains the updated locale.</p>', 'UpdateBotRecommendationRequest$botVersion' => '<p>The version of the bot containing the bot recommendation to be updated.</p>', 'UpdateBotRecommendationResponse$botVersion' => '<p>The version of the bot containing the bot recommendation that has been updated.</p>', 'UpdateIntentRequest$botVersion' => '<p>The version of the bot that contains the intent. Must be <code>DRAFT</code>.</p>', 'UpdateIntentResponse$botVersion' => '<p>The version of the bot that contains the intent. Will always be <code>DRAFT</code>.</p>', 'UpdateSlotRequest$botVersion' => '<p>The version of the bot that contains the slot. Must always be <code>DRAFT</code>.</p>', 'UpdateSlotResponse$botVersion' => '<p>The identifier of the slot version that contains the slot. Will always be <code>DRAFT</code>.</p>', 'UpdateSlotTypeRequest$botVersion' => '<p>The version of the bot that contains the slot type. Must be <code>DRAFT</code>.</p>', 'UpdateSlotTypeResponse$botVersion' => '<p>The version of the bot that contains the slot type. This is always <code>DRAFT</code>.</p>', ], ], 'Effect' => [ 'base' => NULL, 'refs' => [ 'CreateResourcePolicyStatementRequest$effect' => '<p>Determines whether the statement allows or denies access to the resource.</p>', ], ], 'EncryptionSetting' => [ 'base' => '<p>The object representing the passwords that were used to encrypt the data related to the bot recommendation, as well as the KMS key ARN used to encrypt the associated metadata.</p>', 'refs' => [ 'DescribeBotRecommendationResponse$encryptionSetting' => '<p>The object representing the passwords that were used to encrypt the data related to the bot recommendation results, as well as the KMS key ARN used to encrypt the associated metadata.</p>', 'StartBotRecommendationRequest$encryptionSetting' => '<p>The object representing the passwords that will be used to encrypt the data related to the bot recommendation results, as well as the KMS key ARN used to encrypt the associated metadata.</p>', 'StartBotRecommendationResponse$encryptionSetting' => '<p>The object representing the passwords that were used to encrypt the data related to the bot recommendation results, as well as the KMS key ARN used to encrypt the associated metadata.</p>', 'UpdateBotRecommendationRequest$encryptionSetting' => '<p>The object representing the passwords that will be used to encrypt the data related to the bot recommendation results, as well as the KMS key ARN used to encrypt the associated metadata.</p>', 'UpdateBotRecommendationResponse$encryptionSetting' => '<p>The object representing the passwords that were used to encrypt the data related to the bot recommendation results, as well as the KMS key ARN used to encrypt the associated metadata.</p>', ], ], 'ExceptionMessage' => [ 'base' => NULL, 'refs' => [ 'ConflictException$message' => NULL, 'InternalServerException$message' => NULL, 'PreconditionFailedException$message' => NULL, 'ResourceNotFoundException$message' => NULL, 'ServiceQuotaExceededException$message' => NULL, 'ThrottlingException$message' => NULL, 'ValidationException$message' => NULL, ], ], 'ExportFilter' => [ 'base' => '<p>Filters the response form the <a href="https://docs.aws.amazon.com/lexv2/latest/dg/API_ListExports.html">ListExports</a> operation</p>', 'refs' => [ 'ExportFilters$member' => NULL, ], ], 'ExportFilterName' => [ 'base' => NULL, 'refs' => [ 'ExportFilter$name' => '<p>The name of the field to use for filtering.</p>', ], ], 'ExportFilterOperator' => [ 'base' => NULL, 'refs' => [ 'ExportFilter$operator' => '<p>The operator to use for the filter. Specify EQ when the <code>ListExports</code> operation should return only resource types that equal the specified value. Specify CO when the <code>ListExports</code> operation should return resource types that contain the specified value.</p>', ], ], 'ExportFilters' => [ 'base' => NULL, 'refs' => [ 'ListExportsRequest$filters' => '<p>Provides the specification of a filter used to limit the exports in the response to only those that match the filter specification. You can only specify one filter and one string to filter on.</p>', ], ], 'ExportResourceSpecification' => [ 'base' => '<p>Provides information about the bot or bot locale that you want to export. You can specify the <code>botExportSpecification</code> or the <code>botLocaleExportSpecification</code>, but not both.</p>', 'refs' => [ 'CreateExportRequest$resourceSpecification' => '<p>Specifies the type of resource to export, either a bot or a bot locale. You can only specify one type of resource to export.</p>', 'CreateExportResponse$resourceSpecification' => '<p>A description of the type of resource that was exported, either a bot or a bot locale.</p>', 'DescribeExportResponse$resourceSpecification' => '<p>The bot, bot ID, and optional locale ID of the exported bot or bot locale.</p>', 'ExportSummary$resourceSpecification' => '<p>Information about the bot or bot locale that was exported.</p>', 'UpdateExportResponse$resourceSpecification' => '<p>A description of the type of resource that was exported, either a bot or a bot locale.</p>', ], ], 'ExportSortAttribute' => [ 'base' => NULL, 'refs' => [ 'ExportSortBy$attribute' => '<p>The export field to use for sorting.</p>', ], ], 'ExportSortBy' => [ 'base' => '<p>Provides information about sorting a list of exports.</p>', 'refs' => [ 'ListExportsRequest$sortBy' => '<p>Determines the field that the list of exports is sorted by. You can sort by the <code>LastUpdatedDateTime</code> field in ascending or descending order.</p>', ], ], 'ExportStatus' => [ 'base' => NULL, 'refs' => [ 'CreateExportResponse$exportStatus' => '<p>The status of the export. When the status is <code>Completed</code>, you can use the <a href="https://docs.aws.amazon.com/latest/dg/API_DescribeExport.html">DescribeExport</a> operation to get the pre-signed S3 URL link to your exported bot or bot locale.</p>', 'DeleteExportResponse$exportStatus' => '<p>The current status of the deletion. When the deletion is complete, the export will no longer be returned by the <a href="https://docs.aws.amazon.com/lexv2/latest/dg/API_ListExports.html">ListExports</a> operation and calls to the <a href="https://docs.aws.amazon.com/lexv2/latest/dg/API_DescribeExport.html"> DescribeExport</a> operation with the export identifier will fail.</p>', 'DescribeExportResponse$exportStatus' => '<p>The status of the export. When the status is <code>Complete</code> the export archive file is available for download.</p>', 'ExportSummary$exportStatus' => '<p>The status of the export. When the status is <code>Completed</code> the export is ready to download.</p>', 'UpdateExportResponse$exportStatus' => '<p>The status of the export. When the status is <code>Completed</code> the export archive is available for download.</p>', ], ], 'ExportSummary' => [ 'base' => '<p>Provides summary information about an export in an export list. </p>', 'refs' => [ 'ExportSummaryList$member' => NULL, ], ], 'ExportSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListExportsResponse$exportSummaries' => '<p>Summary information for the exports that meet the filter criteria specified in the request. The length of the list is specified in the <code>maxResults</code> parameter. If there are more exports available, the <code>nextToken</code> field contains a token to get the next page of results.</p>', ], ], 'ExternalSourceSetting' => [ 'base' => '<p>Provides information about the external source of the slot type\'s definition.</p>', 'refs' => [ 'CreateSlotTypeRequest$externalSourceSetting' => '<p>Sets the type of external information used to create the slot type.</p>', 'CreateSlotTypeResponse$externalSourceSetting' => '<p>The type of external information used to create the slot type.</p>', 'DescribeSlotTypeResponse$externalSourceSetting' => NULL, 'UpdateSlotTypeRequest$externalSourceSetting' => NULL, 'UpdateSlotTypeResponse$externalSourceSetting' => NULL, ], ], 'FailureReason' => [ 'base' => NULL, 'refs' => [ 'FailureReasons$member' => NULL, ], ], 'FailureReasons' => [ 'base' => NULL, 'refs' => [ 'DescribeBotLocaleResponse$failureReasons' => '<p>if <code>botLocaleStatus</code> is <code>Failed</code>, Amazon Lex explains why it failed to build the bot.</p>', 'DescribeBotRecommendationResponse$failureReasons' => '<p>If botRecommendationStatus is Failed, Amazon Lex explains why.</p>', 'DescribeBotVersionResponse$failureReasons' => '<p>If the <code>botStatus</code> is <code>Failed</code>, this contains a list of reasons that the version couldn\'t be built.</p>', 'DescribeExportResponse$failureReasons' => '<p>If the <code>exportStatus</code> is failed, contains one or more reasons why the export could not be completed.</p>', 'DescribeImportResponse$failureReasons' => '<p>If the <code>importStatus</code> field is <code>Failed</code>, this provides one or more reasons for the failure.</p>', 'UpdateBotLocaleResponse$failureReasons' => '<p>If the <code>botLocaleStatus</code> is <code>Failed</code>, the <code>failureReasons</code> field lists the errors that occurred while building the bot.</p>', ], ], 'FilePassword' => [ 'base' => NULL, 'refs' => [ 'EncryptionSetting$botLocaleExportPassword' => '<p>The password used to encrypt the recommended bot recommendation file.</p>', 'EncryptionSetting$associatedTranscriptsPassword' => '<p>The password used to encrypt the associated transcript file.</p>', ], ], 'FilterValue' => [ 'base' => NULL, 'refs' => [ 'FilterValues$member' => NULL, ], ], 'FilterValues' => [ 'base' => NULL, 'refs' => [ 'AggregatedUtterancesFilter$values' => '<p>The value to use for filtering the list of bots.</p>', 'AssociatedTranscriptFilter$values' => '<p>The values to use to filter the transcript.</p>', 'BotFilter$values' => '<p>The value to use for filtering the list of bots.</p>', 'BotLocaleFilter$values' => '<p>The value to use for filtering the list of bots.</p>', 'ExportFilter$values' => '<p>The values to use to filter the response. The values must be <code>Bot</code>, <code>BotLocale</code>, or <code>CustomVocabulary</code>.</p>', 'ImportFilter$values' => '<p>The values to use to filter the response. The values must be <code>Bot</code>, <code>BotLocale</code>, or <code>CustomVocabulary</code>.</p>', 'IntentFilter$values' => '<p>The value to use for the filter.</p>', 'SlotFilter$values' => '<p>The value to use to filter the response.</p>', 'SlotTypeFilter$values' => '<p>The value to use to filter the response.</p>', ], ], 'FulfillmentCodeHookSettings' => [ 'base' => '<p>Determines if a Lambda function should be invoked for a specific intent.</p>', 'refs' => [ 'CreateIntentRequest$fulfillmentCodeHook' => '<p>Specifies that Amazon Lex invokes the alias Lambda function when the intent is ready for fulfillment. You can invoke this function to complete the bot\'s transaction with the user.</p> <p>For example, in a pizza ordering bot, the Lambda function can look up the closest pizza restaurant to the customer\'s location and then place an order on the customer\'s behalf.</p>', 'CreateIntentResponse$fulfillmentCodeHook' => '<p>The fulfillment Lambda function specified for the intent.</p>', 'DescribeIntentResponse$fulfillmentCodeHook' => '<p>The Lambda function called when the intent is complete and ready for fulfillment.</p>', 'UpdateIntentRequest$fulfillmentCodeHook' => '<p>The new Lambda function to call when all of the intents required slots are provided and the intent is ready for fulfillment.</p>', 'UpdateIntentResponse$fulfillmentCodeHook' => '<p>The updated Lambda function called when the intent is ready for fulfillment.</p>', ], ], 'FulfillmentStartResponseDelay' => [ 'base' => NULL, 'refs' => [ 'FulfillmentStartResponseSpecification$delayInSeconds' => '<p>The delay between when the Lambda fulfillment function starts running and the start message is played. If the Lambda function returns before the delay is over, the start message isn\'t played.</p>', ], ], 'FulfillmentStartResponseSpecification' => [ 'base' => '<p>Provides settings for a message that is sent to the user when a fulfillment Lambda function starts running.</p>', 'refs' => [ 'FulfillmentUpdatesSpecification$startResponse' => '<p>Provides configuration information for the message sent to users when the fulfillment Lambda functions starts running.</p>', ], ], 'FulfillmentTimeout' => [ 'base' => NULL, 'refs' => [ 'FulfillmentUpdatesSpecification$timeoutInSeconds' => '<p>The length of time that the fulfillment Lambda function should run before it times out.</p>', ], ], 'FulfillmentUpdateResponseFrequency' => [ 'base' => NULL, 'refs' => [ 'FulfillmentUpdateResponseSpecification$frequencyInSeconds' => '<p>The frequency that a message is sent to the user. When the period ends, Amazon Lex chooses a message from the message groups and plays it to the user. If the fulfillment Lambda returns before the first period ends, an update message is not played to the user.</p>', ], ], 'FulfillmentUpdateResponseSpecification' => [ 'base' => '<p>Provides settings for a message that is sent periodically to the user while a fulfillment Lambda function is running.</p>', 'refs' => [ 'FulfillmentUpdatesSpecification$updateResponse' => '<p>Provides configuration information for messages sent periodically to the user while the fulfillment Lambda function is running.</p>', ], ], 'FulfillmentUpdatesSpecification' => [ 'base' => '<p>Provides information for updating the user on the progress of fulfilling an intent.</p>', 'refs' => [ 'FulfillmentCodeHookSettings$fulfillmentUpdatesSpecification' => '<p>Provides settings for update messages sent to the user for long-running Lambda fulfillment functions. Fulfillment updates can be used only with streaming conversations.</p>', ], ], 'GrammarSlotTypeSetting' => [ 'base' => '<p>Settings requried for a slot type based on a grammar that you provide.</p>', 'refs' => [ 'ExternalSourceSetting$grammarSlotTypeSetting' => '<p>Settings required for a slot type based on a grammar that you provide.</p>', ], ], 'GrammarSlotTypeSource' => [ 'base' => '<p>Describes the Amazon S3 bucket name and location for the grammar that is the source for the slot type.</p>', 'refs' => [ 'GrammarSlotTypeSetting$source' => '<p>The source of the grammar used to create the slot type.</p>', ], ], 'HitCount' => [ 'base' => NULL, 'refs' => [ 'AggregatedUtterancesSummary$hitCount' => '<p>The number of times that the utterance was detected by Amazon Lex during the time period. When an utterance is detected, it activates an intent or a slot.</p>', ], ], 'Id' => [ 'base' => NULL, 'refs' => [ 'BotExportSpecification$botId' => '<p>The identifier of the bot assigned by Amazon Lex.</p>', 'BotLocaleExportSpecification$botId' => '<p>The identifier of the bot to create the locale for.</p>', 'BotLocaleImportSpecification$botId' => '<p>The identifier of the bot to import the locale to.</p>', 'BotRecommendationSummary$botRecommendationId' => '<p>The unique identifier of the bot recommendation to be updated.</p>', 'BotSummary$botId' => '<p>The unique identifier assigned to the bot. Use this ID to get detailed information about the bot with the <a href="https://docs.aws.amazon.com/lexv2/latest/dg/API_DescribeBot.html">DescribeBot</a> operation.</p>', 'BuildBotLocaleRequest$botId' => '<p>The identifier of the bot to build. The identifier is returned in the response from the <a href="https://docs.aws.amazon.com/lexv2/latest/dg/API_CreateBot.html">CreateBot</a> operation.</p>', 'BuildBotLocaleResponse$botId' => '<p>The identifier of the specified bot.</p>', 'CreateBotAliasRequest$botId' => '<p>The unique identifier of the bot that the alias applies to.</p>', 'CreateBotAliasResponse$botId' => '<p>The unique identifier of the bot that this alias applies to.</p>', 'CreateBotLocaleRequest$botId' => '<p>The identifier of the bot to create the locale for.</p>', 'CreateBotLocaleResponse$botId' => '<p>The specified bot identifier.</p>', 'CreateBotResponse$botId' => '<p>A unique identifier for a particular bot. You use this to identify the bot when you call other Amazon Lex API operations.</p>', 'CreateBotVersionRequest$botId' => '<p>The identifier of the bot to create the version for.</p>', 'CreateBotVersionResponse$botId' => '<p>The bot identifier specified in the request.</p>', 'CreateExportResponse$exportId' => '<p>An identifier for a specific request to create an export.</p>', 'CreateIntentRequest$botId' => '<p>The identifier of the bot associated with this intent.</p>', 'CreateIntentResponse$intentId' => '<p>A unique identifier for the intent.</p>', 'CreateIntentResponse$botId' => '<p>The identifier of the bot associated with the intent.</p>', 'CreateSlotRequest$botId' => '<p>The identifier of the bot associated with the slot.</p>', 'CreateSlotRequest$intentId' => '<p>The identifier of the intent that contains the slot.</p>', 'CreateSlotResponse$slotId' => '<p>The unique identifier associated with the slot. Use this to identify the slot when you update or delete it.</p>', 'CreateSlotResponse$botId' => '<p>The unique identifier of the bot associated with the slot.</p>', 'CreateSlotResponse$intentId' => '<p>The unique identifier of the intent associated with the slot.</p>', 'CreateSlotTypeRequest$botId' => '<p>The identifier of the bot associated with this slot type.</p>', 'CreateSlotTypeResponse$slotTypeId' => '<p>The unique identifier assigned to the slot type. Use this to identify the slot type in the <code>UpdateSlotType</code> and <code>DeleteSlotType</code> operations.</p>', 'CreateSlotTypeResponse$botId' => '<p>The identifier for the bot associated with the slot type.</p>', 'CreateUploadUrlResponse$importId' => '<p>An identifier for a unique import job. Use it when you call the <a href="https://docs.aws.amazon.com/lexv2/latest/dg/API_StartImport.html">StartImport</a> operation.</p>', 'CustomVocabularyExportSpecification$botId' => '<p>The identifier of the bot that contains the custom vocabulary to export.</p>', 'CustomVocabularyImportSpecification$botId' => '<p>The identifier of the bot to import the custom vocabulary to.</p>', 'DeleteBotAliasRequest$botId' => '<p>The unique identifier of the bot associated with the alias to delete.</p>', 'DeleteBotAliasResponse$botId' => '<p>The unique identifier of the bot that contains the alias to delete.</p>', 'DeleteBotLocaleRequest$botId' => '<p>The unique identifier of the bot that contains the locale.</p>', 'DeleteBotLocaleResponse$botId' => '<p>The identifier of the bot that contained the deleted locale.</p>', 'DeleteBotRequest$botId' => '<p>The identifier of the bot to delete. </p>', 'DeleteBotResponse$botId' => '<p>The unique identifier of the bot that Amazon Lex is deleting.</p>', 'DeleteBotVersionRequest$botId' => '<p>The identifier of the bot that contains the version.</p>', 'DeleteBotVersionResponse$botId' => '<p>The identifier of the bot that is being deleted.</p>', 'DeleteCustomVocabularyRequest$botId' => '<p>The unique identifier of the bot to remove the custom vocabulary from.</p>', 'DeleteCustomVocabularyResponse$botId' => '<p>The identifier of the bot that the custom vocabulary was removed from.</p>', 'DeleteExportRequest$exportId' => '<p>The unique identifier of the export to delete.</p>', 'DeleteExportResponse$exportId' => '<p>The unique identifier of the deleted export.</p>', 'DeleteImportRequest$importId' => '<p>The unique identifier of the import to delete.</p>', 'DeleteImportResponse$importId' => '<p>The unique identifier of the deleted import.</p>', 'DeleteIntentRequest$intentId' => '<p>The unique identifier of the intent to delete.</p>', 'DeleteIntentRequest$botId' => '<p>The identifier of the bot associated with the intent.</p>', 'DeleteSlotRequest$slotId' => '<p>The identifier of the slot to delete. </p>', 'DeleteSlotRequest$botId' => '<p>The identifier of the bot associated with the slot to delete.</p>', 'DeleteSlotRequest$intentId' => '<p>The identifier of the intent associated with the slot.</p>', 'DeleteSlotTypeRequest$slotTypeId' => '<p>The identifier of the slot type to delete.</p>', 'DeleteSlotTypeRequest$botId' => '<p>The identifier of the bot associated with the slot type.</p>', 'DeleteUtterancesRequest$botId' => '<p>The unique identifier of the bot that contains the utterances.</p>', 'DescribeBotAliasRequest$botId' => '<p>The identifier of the bot associated with the bot alias to describe.</p>', 'DescribeBotAliasResponse$botId' => '<p>The identifier of the bot associated with the bot alias.</p>', 'DescribeBotLocaleRequest$botId' => '<p>The identifier of the bot associated with the locale.</p>', 'DescribeBotLocaleResponse$botId' => '<p>The identifier of the bot associated with the locale.</p>', 'DescribeBotRecommendationRequest$botId' => '<p>The unique identifier of the bot associated with the bot recommendation.</p>', 'DescribeBotRecommendationRequest$botRecommendationId' => '<p>The identifier of the bot recommendation to describe.</p>', 'DescribeBotRecommendationResponse$botId' => '<p>The identifier of the bot associated with the bot recommendation.</p>', 'DescribeBotRecommendationResponse$botRecommendationId' => '<p>The identifier of the bot recommendation being described.</p>', 'DescribeBotRequest$botId' => '<p>The unique identifier of the bot to describe.</p>', 'DescribeBotResponse$botId' => '<p>The unique identifier of the bot.</p>', 'DescribeBotVersionRequest$botId' => '<p>The identifier of the bot containing the version to return metadata for.</p>', 'DescribeBotVersionResponse$botId' => '<p>The identifier of the bot that contains the version.</p>', 'DescribeCustomVocabularyMetadataRequest$botId' => '<p>The unique identifier of the bot that contains the custom vocabulary.</p>', 'DescribeCustomVocabularyMetadataResponse$botId' => '<p>The identifier of the bot that contains the custom vocabulary.</p>', 'DescribeExportRequest$exportId' => '<p>The unique identifier of the export to describe.</p>', 'DescribeExportResponse$exportId' => '<p>The unique identifier of the described export.</p>', 'DescribeImportRequest$importId' => '<p>The unique identifier of the import to describe.</p>', 'DescribeImportResponse$importId' => '<p>The unique identifier of the described import.</p>', 'DescribeIntentRequest$intentId' => '<p>The identifier of the intent to describe.</p>', 'DescribeIntentRequest$botId' => '<p>The identifier of the bot associated with the intent.</p>', 'DescribeIntentResponse$intentId' => '<p>The unique identifier assigned to the intent when it was created.</p>', 'DescribeIntentResponse$botId' => '<p>The identifier of the bot associated with the intent.</p>', 'DescribeSlotRequest$slotId' => '<p>The unique identifier for the slot.</p>', 'DescribeSlotRequest$botId' => '<p>The identifier of the bot associated with the slot.</p>', 'DescribeSlotRequest$intentId' => '<p>The identifier of the intent that contains the slot.</p>', 'DescribeSlotResponse$slotId' => '<p>The unique identifier generated for the slot.</p>', 'DescribeSlotResponse$botId' => '<p>The identifier of the bot associated with the slot.</p>', 'DescribeSlotResponse$intentId' => '<p>The identifier of the intent associated with the slot.</p>', 'DescribeSlotTypeRequest$slotTypeId' => '<p>The identifier of the slot type.</p>', 'DescribeSlotTypeRequest$botId' => '<p>The identifier of the bot associated with the slot type.</p>', 'DescribeSlotTypeResponse$slotTypeId' => '<p>The unique identifier for the slot type.</p>', 'DescribeSlotTypeResponse$botId' => '<p>The identifier of the bot associated with the slot type.</p>', 'ExportSummary$exportId' => '<p>The unique identifier that Amazon Lex assigned to the export.</p>', 'ImportSummary$importId' => '<p>The unique identifier that Amazon Lex assigned to the import.</p>', 'IntentSummary$intentId' => '<p>The unique identifier assigned to the intent. Use this ID to get detailed information about the intent with the <code>DescribeIntent</code> operation.</p>', 'ListAggregatedUtterancesRequest$botId' => '<p>The unique identifier of the bot associated with this request.</p>', 'ListAggregatedUtterancesResponse$botId' => '<p>The identifier of the bot that contains the utterances.</p>', 'ListBotAliasesRequest$botId' => '<p>The identifier of the bot to list aliases for.</p>', 'ListBotAliasesResponse$botId' => '<p>The identifier of the bot associated with the aliases.</p>', 'ListBotLocalesRequest$botId' => '<p>The identifier of the bot to list locales for.</p>', 'ListBotLocalesResponse$botId' => '<p>The identifier of the bot to list locales for.</p>', 'ListBotRecommendationsRequest$botId' => '<p>The unique identifier of the bot that contains the bot recommendation list.</p>', 'ListBotRecommendationsResponse$botId' => '<p>The unique identifier of the bot that contains the bot recommendation list.</p>', 'ListBotVersionsRequest$botId' => '<p>The identifier of the bot to list versions for.</p>', 'ListBotVersionsResponse$botId' => '<p>The identifier of the bot to list versions for.</p>', 'ListExportsRequest$botId' => '<p>The unique identifier that Amazon Lex assigned to the bot.</p>', 'ListExportsResponse$botId' => '<p>The unique identifier assigned to the bot by Amazon Lex.</p>', 'ListImportsRequest$botId' => '<p>The unique identifier that Amazon Lex assigned to the bot.</p>', 'ListImportsResponse$botId' => '<p>The unique identifier assigned by Amazon Lex to the bot.</p>', 'ListIntentsRequest$botId' => '<p>The unique identifier of the bot that contains the intent.</p>', 'ListIntentsResponse$botId' => '<p>The identifier of the bot that contains the intent.</p>', 'ListRecommendedIntentsRequest$botId' => '<p>The unique identifier of the bot associated with the recommended intents.</p>', 'ListRecommendedIntentsRequest$botRecommendationId' => '<p>The identifier of the bot recommendation that contains the recommended intents.</p>', 'ListRecommendedIntentsResponse$botId' => '<p>The unique identifier of the bot associated with the recommended intent.</p>', 'ListRecommendedIntentsResponse$botRecommendationId' => '<p>The identifier of the bot recommendation that contains the recommended intent.</p>', 'ListSlotTypesRequest$botId' => '<p>The unique identifier of the bot that contains the slot types.</p>', 'ListSlotTypesResponse$botId' => '<p>The identifier of the bot that contains the slot types.</p>', 'ListSlotsRequest$botId' => '<p>The identifier of the bot that contains the slot.</p>', 'ListSlotsRequest$intentId' => '<p>The unique identifier of the intent that contains the slot.</p>', 'ListSlotsResponse$botId' => '<p>The identifier of the bot that contains the slots.</p>', 'ListSlotsResponse$intentId' => '<p>The identifier of the intent that contains the slots.</p>', 'RecommendedIntentSummary$intentId' => '<p>The unique identifier of a recommended intent associated with the bot recommendation.</p>', 'SearchAssociatedTranscriptsRequest$botId' => '<p>The unique identifier of the bot associated with the transcripts that you are searching.</p>', 'SearchAssociatedTranscriptsRequest$botRecommendationId' => '<p>The unique identifier of the bot recommendation associated with the transcripts to search.</p>', 'SearchAssociatedTranscriptsResponse$botId' => '<p>The unique identifier of the bot associated with the transcripts that you are searching.</p>', 'SearchAssociatedTranscriptsResponse$botRecommendationId' => '<p> The unique identifier of the bot recommendation associated with the transcripts to search.</p>', 'SlotPriority$slotId' => '<p>The unique identifier of the slot.</p>', 'SlotSummary$slotId' => '<p>The unique identifier of the slot.</p>', 'SlotTypeSummary$slotTypeId' => '<p>The unique identifier assigned to the slot type.</p>', 'StartBotRecommendationRequest$botId' => '<p>The unique identifier of the bot containing the bot recommendation.</p>', 'StartBotRecommendationResponse$botId' => '<p>The unique identifier of the bot containing the bot recommendation.</p>', 'StartBotRecommendationResponse$botRecommendationId' => '<p>The identifier of the bot recommendation that you have created.</p>', 'StartImportRequest$importId' => '<p>The unique identifier for the import. It is included in the response from the <a href="https://docs.aws.amazon.com/lexv2/latest/dg/API_CreateUploadUrl.html">CreateUploadUrl</a> operation.</p>', 'StartImportResponse$importId' => '<p>A unique identifier for the import.</p>', 'UpdateBotAliasRequest$botId' => '<p>The identifier of the bot with the updated alias.</p>', 'UpdateBotAliasResponse$botId' => '<p>The identifier of the bot with the updated alias.</p>', 'UpdateBotLocaleRequest$botId' => '<p>The unique identifier of the bot that contains the locale.</p>', 'UpdateBotLocaleResponse$botId' => '<p>The identifier of the bot that contains the updated locale.</p>', 'UpdateBotRecommendationRequest$botId' => '<p>The unique identifier of the bot containing the bot recommendation to be updated.</p>', 'UpdateBotRecommendationRequest$botRecommendationId' => '<p>The unique identifier of the bot recommendation to be updated.</p>', 'UpdateBotRecommendationResponse$botId' => '<p>The unique identifier of the bot containing the bot recommendation that has been updated.</p>', 'UpdateBotRecommendationResponse$botRecommendationId' => '<p>The unique identifier of the bot recommendation to be updated.</p>', 'UpdateBotRequest$botId' => '<p>The unique identifier of the bot to update. This identifier is returned by the <a href="https://docs.aws.amazon.com/lexv2/latest/dg/API_CreateBot.html">CreateBot</a> operation.</p>', 'UpdateBotResponse$botId' => '<p>The unique identifier of the bot that was updated.</p>', 'UpdateExportRequest$exportId' => '<p>The unique identifier Amazon Lex assigned to the export.</p>', 'UpdateExportResponse$exportId' => '<p>The unique identifier Amazon Lex assigned to the export.</p>', 'UpdateIntentRequest$intentId' => '<p>The unique identifier of the intent to update.</p>', 'UpdateIntentRequest$botId' => '<p>The identifier of the bot that contains the intent.</p>', 'UpdateIntentResponse$intentId' => '<p>The identifier of the intent that was updated.</p>', 'UpdateIntentResponse$botId' => '<p>The identifier of the bot that contains the intent.</p>', 'UpdateSlotRequest$slotId' => '<p>The unique identifier for the slot to update.</p>', 'UpdateSlotRequest$botId' => '<p>The unique identifier of the bot that contains the slot.</p>', 'UpdateSlotRequest$intentId' => '<p>The identifier of the intent that contains the slot.</p>', 'UpdateSlotResponse$slotId' => '<p>The unique identifier of the slot that was updated.</p>', 'UpdateSlotResponse$botId' => '<p>The identifier of the bot that contains the slot.</p>', 'UpdateSlotResponse$intentId' => '<p>The intent that contains the slot.</p>', 'UpdateSlotTypeRequest$slotTypeId' => '<p>The unique identifier of the slot type to update.</p>', 'UpdateSlotTypeRequest$botId' => '<p>The identifier of the bot that contains the slot type.</p>', 'UpdateSlotTypeResponse$slotTypeId' => '<p>The unique identifier of the updated slot type.</p>', 'UpdateSlotTypeResponse$botId' => '<p>The identifier of the bot that contains the slot type.</p>', ], ], 'ImageResponseCard' => [ 'base' => '<p>A card that is shown to the user by a messaging platform. You define the contents of the card, the card is displayed by the platform. </p> <p>When you use a response card, the response from the user is constrained to the text associated with a button on the card.</p>', 'refs' => [ 'Message$imageResponseCard' => '<p>A message that defines a response card that the client application can show to the user.</p>', ], ], 'ImportExportFileFormat' => [ 'base' => NULL, 'refs' => [ 'CreateExportRequest$fileFormat' => '<p>The file format of the bot or bot locale definition files.</p>', 'CreateExportResponse$fileFormat' => '<p>The file format used for the bot or bot locale definition files.</p>', 'DescribeExportResponse$fileFormat' => '<p>The file format used in the files that describe the resource. </p>', 'ExportSummary$fileFormat' => '<p>The file format used in the export files.</p>', 'UpdateExportResponse$fileFormat' => '<p>The file format used for the files that define the resource. The <code>TSV</code> format is required to export a custom vocabulary only; otherwise use <code>LexJson</code> format.</p>', ], ], 'ImportExportFilePassword' => [ 'base' => NULL, 'refs' => [ 'CreateExportRequest$filePassword' => '<p>An password to use to encrypt the exported archive. Using a password is optional, but you should encrypt the archive to protect the data in transit between Amazon Lex and your local computer.</p>', 'StartImportRequest$filePassword' => '<p>The password used to encrypt the zip archive that contains the resource definition. You should always encrypt the zip archive to protect it during transit between your site and Amazon Lex.</p>', 'UpdateExportRequest$filePassword' => '<p>The new password to use to encrypt the export zip archive.</p>', ], ], 'ImportFilter' => [ 'base' => '<p>Filters the response from the <a href="https://docs.aws.amazon.com/lexv2/latest/dg/API_ListImports.html">ListImports</a> operation.</p>', 'refs' => [ 'ImportFilters$member' => NULL, ], ], 'ImportFilterName' => [ 'base' => NULL, 'refs' => [ 'ImportFilter$name' => '<p>The name of the field to use for filtering.</p>', ], ], 'ImportFilterOperator' => [ 'base' => NULL, 'refs' => [ 'ImportFilter$operator' => '<p>The operator to use for the filter. Specify EQ when the <code>ListImports</code> operation should return only resource types that equal the specified value. Specify CO when the <code>ListImports</code> operation should return resource types that contain the specified value.</p>', ], ], 'ImportFilters' => [ 'base' => NULL, 'refs' => [ 'ListImportsRequest$filters' => '<p>Provides the specification of a filter used to limit the bots in the response to only those that match the filter specification. You can only specify one filter and one string to filter on.</p>', ], ], 'ImportResourceSpecification' => [ 'base' => '<p>Provides information about the bot or bot locale that you want to import. You can specify the <code>botImportSpecification</code> or the <code>botLocaleImportSpecification</code>, but not both.</p>', 'refs' => [ 'DescribeImportResponse$resourceSpecification' => '<p>The specifications of the imported bot, bot locale, or custom vocabulary.</p>', 'StartImportRequest$resourceSpecification' => '<p>Parameters for creating the bot, bot locale or custom vocabulary.</p>', 'StartImportResponse$resourceSpecification' => '<p>The parameters used when importing the resource.</p>', ], ], 'ImportResourceType' => [ 'base' => NULL, 'refs' => [ 'ImportSummary$importedResourceType' => '<p>The type of resource that was imported.</p>', ], ], 'ImportSortAttribute' => [ 'base' => NULL, 'refs' => [ 'ImportSortBy$attribute' => '<p>The export field to use for sorting.</p>', ], ], 'ImportSortBy' => [ 'base' => '<p>Provides information for sorting a list of imports.</p>', 'refs' => [ 'ListImportsRequest$sortBy' => '<p>Determines the field that the list of imports is sorted by. You can sort by the <code>LastUpdatedDateTime</code> field in ascending or descending order.</p>', ], ], 'ImportStatus' => [ 'base' => NULL, 'refs' => [ 'DeleteImportResponse$importStatus' => '<p>The current status of the deletion. When the deletion is complete, the import will no longer be returned by the <a href="https://docs.aws.amazon.com/lexv2/latest/dg/API_ListImports.html">ListImports</a> operation and calls to the <a href="https://docs.aws.amazon.com/lexv2/latest/dg/API_DescribeImport.html">DescribeImport</a> operation with the import identifier will fail.</p>', 'DescribeImportResponse$importStatus' => '<p>The status of the import process. When the status is <code>Completed</code> the resource is imported and ready for use.</p>', 'ImportSummary$importStatus' => '<p>The status of the resource. When the status is <code>Completed</code> the resource is ready to build.</p>', 'StartImportResponse$importStatus' => '<p>The current status of the import. When the status is <code>Complete</code> the bot, bot alias, or custom vocabulary is ready to use.</p>', ], ], 'ImportSummary' => [ 'base' => '<p>Provides summary information about an import in an import list.</p>', 'refs' => [ 'ImportSummaryList$member' => NULL, ], ], 'ImportSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListImportsResponse$importSummaries' => '<p>Summary information for the imports that meet the filter criteria specified in the request. The length of the list is specified in the <code>maxResults</code> parameter. If there are more imports available, the <code>nextToken</code> field contains a token to get the next page of results.</p>', ], ], 'ImportedResourceId' => [ 'base' => NULL, 'refs' => [ 'DescribeImportResponse$importedResourceId' => '<p>The unique identifier that Amazon Lex assigned to the resource created by the import.</p>', 'ImportSummary$importedResourceId' => '<p>The unique identifier that Amazon Lex assigned to the imported resource.</p>', ], ], 'InputContext' => [ 'base' => '<p>The name of a context that must be active for an intent to be selected by Amazon Lex.</p>', 'refs' => [ 'InputContextsList$member' => NULL, ], ], 'InputContextsList' => [ 'base' => NULL, 'refs' => [ 'CreateIntentRequest$inputContexts' => '<p>A list of contexts that must be active for this intent to be considered by Amazon Lex.</p> <p>When an intent has an input context list, Amazon Lex only considers using the intent in an interaction with the user when the specified contexts are included in the active context list for the session. If the contexts are not active, then Amazon Lex will not use the intent.</p> <p>A context can be automatically activated using the <code>outputContexts</code> property or it can be set at runtime.</p> <p> For example, if there are two intents with different input contexts that respond to the same utterances, only the intent with the active context will respond.</p> <p>An intent may have up to 5 input contexts. If an intent has multiple input contexts, all of the contexts must be active to consider the intent.</p>', 'CreateIntentResponse$inputContexts' => '<p>The list of input contexts specified for the intent.</p>', 'DescribeIntentResponse$inputContexts' => '<p>A list of contexts that must be active for the intent to be considered for sending to the user.</p>', 'IntentSummary$inputContexts' => '<p>The input contexts that must be active for this intent to be considered for recognition.</p>', 'UpdateIntentRequest$inputContexts' => '<p>A new list of contexts that must be active in order for Amazon Lex to consider the intent.</p>', 'UpdateIntentResponse$inputContexts' => '<p>The updated list of contexts that must be active for the intent to be considered by Amazon Lex.</p>', ], ], 'IntentClosingSetting' => [ 'base' => '<p>Provides a statement the Amazon Lex conveys to the user when the intent is successfully fulfilled.</p>', 'refs' => [ 'CreateIntentRequest$intentClosingSetting' => '<p>Sets the response that Amazon Lex sends to the user when the intent is closed.</p>', 'CreateIntentResponse$intentClosingSetting' => '<p>The closing setting specified for the intent.</p>', 'DescribeIntentResponse$intentClosingSetting' => '<p>The response that Amazon Lex sends to when the intent is closed.</p>', 'UpdateIntentRequest$intentClosingSetting' => '<p>The new response that Amazon Lex sends the user when the intent is closed.</p>', 'UpdateIntentResponse$intentClosingSetting' => '<p>The updated response that Amazon Lex sends the user when the intent is closed.</p>', ], ], 'IntentConfirmationSetting' => [ 'base' => '<p>Provides a prompt for making sure that the user is ready for the intent to be fulfilled.</p>', 'refs' => [ 'CreateIntentRequest$intentConfirmationSetting' => '<p>Provides prompts that Amazon Lex sends to the user to confirm the completion of an intent. If the user answers "no," the settings contain a statement that is sent to the user to end the intent.</p>', 'CreateIntentResponse$intentConfirmationSetting' => '<p>The confirmation setting specified for the intent.</p>', 'DescribeIntentResponse$intentConfirmationSetting' => '<p>Prompts that Amazon Lex sends to the user to confirm completion of an intent.</p>', 'UpdateIntentRequest$intentConfirmationSetting' => '<p>New prompts that Amazon Lex sends to the user to confirm the completion of an intent.</p>', 'UpdateIntentResponse$intentConfirmationSetting' => '<p>The updated prompts that Amazon Lex sends to the user to confirm the completion of an intent.</p>', ], ], 'IntentFilter' => [ 'base' => '<p>Filters the response from the <code>ListIntents</code> operation.</p>', 'refs' => [ 'IntentFilters$member' => NULL, ], ], 'IntentFilterName' => [ 'base' => NULL, 'refs' => [ 'IntentFilter$name' => '<p>The name of the field to use for the filter.</p>', ], ], 'IntentFilterOperator' => [ 'base' => NULL, 'refs' => [ 'IntentFilter$operator' => '<p>The operator to use for the filter. Specify <code>EQ</code> when the <code>ListIntents</code> operation should return only aliases that equal the specified value. Specify <code>CO</code> when the <code>ListIntents</code> operation should return aliases that contain the specified value.</p>', ], ], 'IntentFilters' => [ 'base' => NULL, 'refs' => [ 'ListIntentsRequest$filters' => '<p>Provides the specification of a filter used to limit the intents in the response to only those that match the filter specification. You can only specify one filter and only one string to filter on.</p>', ], ], 'IntentSignature' => [ 'base' => NULL, 'refs' => [ 'BuiltInIntentSummary$intentSignature' => '<p>The signature of the built-in intent. Use this to specify the parent intent of a derived intent.</p>', 'CreateIntentRequest$parentIntentSignature' => '<p>A unique identifier for the built-in intent to base this intent on.</p>', 'CreateIntentResponse$parentIntentSignature' => '<p>The signature of the parent intent specified for the intent.</p>', 'DescribeIntentResponse$parentIntentSignature' => '<p>The identifier of the built-in intent that this intent is derived from, if any.</p>', 'IntentSummary$parentIntentSignature' => '<p>If this intent is derived from a built-in intent, the name of the parent intent.</p>', 'UpdateIntentRequest$parentIntentSignature' => '<p>The signature of the new built-in intent to use as the parent of this intent.</p>', 'UpdateIntentResponse$parentIntentSignature' => '<p>The updated built-in intent that is the parent of this intent.</p>', ], ], 'IntentSortAttribute' => [ 'base' => NULL, 'refs' => [ 'IntentSortBy$attribute' => '<p>The attribute to use to sort the list of intents.</p>', ], ], 'IntentSortBy' => [ 'base' => '<p>Specifies attributes for sorting a list of intents.</p>', 'refs' => [ 'ListIntentsRequest$sortBy' => '<p>Determines the sort order for the response from the <code>ListIntents</code> operation. You can choose to sort by the intent name or last updated date in either ascending or descending order.</p>', ], ], 'IntentStatistics' => [ 'base' => '<p>The object that contains the statistical summary of recommended intents associated with the bot recommendation.</p>', 'refs' => [ 'BotRecommendationResultStatistics$intents' => '<p>Statistical information about about the intents associated with the bot recommendation results.</p>', ], ], 'IntentSummary' => [ 'base' => '<p>Summary information about an intent returned by the <code>ListIntents</code> operation.</p>', 'refs' => [ 'IntentSummaryList$member' => NULL, ], ], 'IntentSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListIntentsResponse$intentSummaries' => '<p>Summary information for the intents that meet the filter criteria specified in the request. The length of the list is specified in the <code>maxResults</code> parameter of the request. If there are more intents available, the <code>nextToken</code> field contains a token to get the next page of results.</p>', ], ], 'InternalServerException' => [ 'base' => '<p>The service encountered an unexpected condition. Try your request again.</p>', 'refs' => [], ], 'KendraConfiguration' => [ 'base' => '<p>Provides configuration information for the AMAZON.KendraSearchIntent intent. When you use this intent, Amazon Lex searches the specified Amazon Kendra index and returns documents from the index that match the user\'s utterance.</p>', 'refs' => [ 'CreateIntentRequest$kendraConfiguration' => '<p>Configuration information required to use the <code>AMAZON.KendraSearchIntent</code> intent to connect to an Amazon Kendra index. The <code>AMAZON.KendraSearchIntent</code> intent is called when Amazon Lex can\'t determine another intent to invoke.</p>', 'CreateIntentResponse$kendraConfiguration' => '<p>Configuration for searching a Amazon Kendra index specified for the intent.</p>', 'DescribeIntentResponse$kendraConfiguration' => '<p>Configuration information required to use the <code>AMAZON.KendraSearchIntent</code> intent.</p>', 'UpdateIntentRequest$kendraConfiguration' => '<p>New configuration settings for connecting to an Amazon Kendra index.</p>', 'UpdateIntentResponse$kendraConfiguration' => '<p>The updated configuration for connecting to an Amazon Kendra index with the <code>AMAZON.KendraSearchIntent</code> intent.</p>', ], ], 'KendraIndexArn' => [ 'base' => NULL, 'refs' => [ 'KendraConfiguration$kendraIndex' => '<p>The Amazon Resource Name (ARN) of the Amazon Kendra index that you want the AMAZON.KendraSearchIntent intent to search. The index must be in the same account and Region as the Amazon Lex bot.</p>', ], ], 'KmsKeyArn' => [ 'base' => NULL, 'refs' => [ 'EncryptionSetting$kmsKeyArn' => '<p>The KMS key ARN used to encrypt the metadata associated with the bot recommendation.</p>', 'GrammarSlotTypeSource$kmsKeyArn' => '<p>The Amazon KMS key required to decrypt the contents of the grammar, if any.</p>', 'S3BucketLogDestination$kmsKeyArn' => '<p>The Amazon Resource Name (ARN) of an AWS Key Management Service (KMS) key for encrypting audio log files stored in an S3 bucket.</p>', 'S3BucketTranscriptSource$kmsKeyArn' => '<p>The ARN of the KMS key that customer use to encrypt their Amazon S3 bucket. Only use this field if your bucket is encrypted using a customer managed KMS key.</p>', ], ], 'LambdaARN' => [ 'base' => NULL, 'refs' => [ 'LambdaCodeHook$lambdaARN' => '<p>The Amazon Resource Name (ARN) of the Lambda function.</p>', ], ], 'LambdaCodeHook' => [ 'base' => '<p>Specifies a Lambda function that verifies requests to a bot or fulfills the user\'s request to a bot.</p>', 'refs' => [ 'CodeHookSpecification$lambdaCodeHook' => NULL, ], ], 'LexTranscriptFilter' => [ 'base' => '<p>The object that contains transcript filter details that are associated with a bot recommendation.</p>', 'refs' => [ 'TranscriptFilter$lexTranscriptFilter' => '<p>The object representing the filter that Amazon Lex will use to select the appropriate transcript when the transcript format is the Amazon Lex format.</p>', ], ], 'ListAggregatedUtterancesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListAggregatedUtterancesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListBotAliasesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListBotAliasesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListBotLocalesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListBotLocalesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListBotRecommendationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListBotRecommendationsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListBotVersionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListBotVersionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListBotsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListBotsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListBuiltInIntentsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListBuiltInIntentsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListBuiltInSlotTypesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListBuiltInSlotTypesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListExportsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListExportsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListImportsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListImportsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListIntentsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListIntentsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListRecommendedIntentsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListRecommendedIntentsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListSlotTypesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListSlotTypesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListSlotsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListSlotsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'LocaleId' => [ 'base' => NULL, 'refs' => [ 'BotAliasLocaleSettingsMap$key' => NULL, 'BotLocaleExportSpecification$localeId' => '<p>The identifier of the language and locale to export. The string must match one of the locales in the bot.</p>', 'BotLocaleImportSpecification$localeId' => '<p>The identifier of the language and locale that the bot will be used in. The string must match one of the supported locales. All of the intents, slot types, and slots used in the bot must have the same locale. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>', 'BotLocaleSummary$localeId' => '<p>The language and locale of the bot locale.</p>', 'BotVersionLocaleSpecification$key' => NULL, 'BuildBotLocaleRequest$localeId' => '<p>The identifier of the language and locale that the bot will be used in. The string must match one of the supported locales. All of the intents, slot types, and slots used in the bot must have the same locale. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>', 'BuildBotLocaleResponse$localeId' => '<p>The language and locale specified of where the bot can be used.</p>', 'CreateBotLocaleRequest$localeId' => '<p>The identifier of the language and locale that the bot will be used in. The string must match one of the supported locales. All of the intents, slot types, and slots used in the bot must have the same locale. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>', 'CreateBotLocaleResponse$localeId' => '<p>The specified locale identifier.</p>', 'CreateIntentRequest$localeId' => '<p>The identifier of the language and locale where this intent is used. All of the bots, slot types, and slots used by the intent must have the same locale. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>', 'CreateIntentResponse$localeId' => '<p>The locale that the intent is specified to use.</p>', 'CreateSlotRequest$localeId' => '<p>The identifier of the language and locale that the slot will be used in. The string must match one of the supported locales. All of the bots, intents, slot types used by the slot must have the same locale. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>', 'CreateSlotResponse$localeId' => '<p>The language and local specified for the slot.</p>', 'CreateSlotTypeRequest$localeId' => '<p>The identifier of the language and locale that the slot type will be used in. The string must match one of the supported locales. All of the bots, intents, and slots used by the slot type must have the same locale. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>', 'CreateSlotTypeResponse$localeId' => '<p>The specified language and local specified for the slot type.</p>', 'CustomVocabularyExportSpecification$localeId' => '<p>The locale of the bot that contains the custom vocabulary to export.</p>', 'CustomVocabularyImportSpecification$localeId' => '<p>The identifier of the local to import the custom vocabulary to. The value must be <code>en_GB</code>.</p>', 'DeleteBotLocaleRequest$localeId' => '<p>The identifier of the language and locale that will be deleted. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>', 'DeleteBotLocaleResponse$localeId' => '<p>The language and locale of the deleted locale.</p>', 'DeleteCustomVocabularyRequest$localeId' => '<p>The locale identifier for the locale that contains the custom vocabulary to remove.</p>', 'DeleteCustomVocabularyResponse$localeId' => '<p>The locale identifier for the locale that the custom vocabulary was removed from.</p>', 'DeleteIntentRequest$localeId' => '<p>The identifier of the language and locale where the bot will be deleted. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>', 'DeleteSlotRequest$localeId' => '<p>The identifier of the language and locale that the slot will be deleted from. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>', 'DeleteSlotTypeRequest$localeId' => '<p>The identifier of the language and locale that the slot type will be deleted from. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>', 'DeleteUtterancesRequest$localeId' => '<p>The identifier of the language and locale where the utterances were collected. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>', 'DescribeBotLocaleRequest$localeId' => '<p>The unique identifier of the locale to describe. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>. </p>', 'DescribeBotLocaleResponse$localeId' => '<p>The unique identifier of the described locale.</p>', 'DescribeBotRecommendationRequest$localeId' => '<p>The identifier of the language and locale of the bot recommendation to describe. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>', 'DescribeBotRecommendationResponse$localeId' => '<p>The identifier of the language and locale of the bot recommendation to describe.</p>', 'DescribeCustomVocabularyMetadataRequest$localeId' => '<p>The locale to return the custom vocabulary information for. The locale must be <code>en_GB</code>.</p>', 'DescribeCustomVocabularyMetadataResponse$localeId' => '<p>The locale that contains the custom vocabulary to describe.</p>', 'DescribeIntentRequest$localeId' => '<p>The identifier of the language and locale of the intent to describe. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>', 'DescribeIntentResponse$localeId' => '<p>The language and locale specified for the intent.</p>', 'DescribeSlotRequest$localeId' => '<p>The identifier of the language and locale of the slot to describe. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>', 'DescribeSlotResponse$localeId' => '<p>The language and locale specified for the slot.</p>', 'DescribeSlotTypeRequest$localeId' => '<p>The identifier of the language and locale of the slot type to describe. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>', 'DescribeSlotTypeResponse$localeId' => '<p>The language and locale specified for the slot type.</p>', 'ListAggregatedUtterancesRequest$localeId' => '<p>The identifier of the language and locale where the utterances were collected. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>', 'ListAggregatedUtterancesResponse$localeId' => '<p>The identifier of the language and locale that the utterances are in.</p>', 'ListBotRecommendationsRequest$localeId' => '<p>The identifier of the language and locale of the bot recommendation list.</p>', 'ListBotRecommendationsResponse$localeId' => '<p>The identifier of the language and locale of the bot recommendation list.</p>', 'ListBuiltInIntentsRequest$localeId' => '<p>The identifier of the language and locale of the intents to list. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>', 'ListBuiltInIntentsResponse$localeId' => '<p>The language and locale of the intents in the list.</p>', 'ListBuiltInSlotTypesRequest$localeId' => '<p>The identifier of the language and locale of the slot types to list. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>', 'ListBuiltInSlotTypesResponse$localeId' => '<p>The language and locale of the slot types in the list.</p>', 'ListExportsRequest$localeId' => '<p>Specifies the resources that should be exported. If you don\'t specify a resource type in the <code>filters</code> parameter, both bot locales and custom vocabularies are exported.</p>', 'ListExportsResponse$localeId' => '<p>The locale specified in the request.</p>', 'ListImportsRequest$localeId' => '<p>Specifies the locale that should be present in the list. If you don\'t specify a resource type in the <code>filters</code> parameter, the list contains both bot locales and custom vocabularies.</p>', 'ListImportsResponse$localeId' => '<p>The locale specified in the request.</p>', 'ListIntentsRequest$localeId' => '<p>The identifier of the language and locale of the intents to list. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>', 'ListIntentsResponse$localeId' => '<p>The language and locale of the intents in the list.</p>', 'ListRecommendedIntentsRequest$localeId' => '<p>The identifier of the language and locale of the recommended intents.</p>', 'ListRecommendedIntentsResponse$localeId' => '<p>The identifier of the language and locale of the intents to list. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>', 'ListSlotTypesRequest$localeId' => '<p>The identifier of the language and locale of the slot types to list. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>', 'ListSlotTypesResponse$localeId' => '<p>The language and local of the slot types in the list.</p>', 'ListSlotsRequest$localeId' => '<p>The identifier of the language and locale of the slots to list. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>', 'ListSlotsResponse$localeId' => '<p>The language and locale of the slots in the list.</p>', 'SearchAssociatedTranscriptsRequest$localeId' => '<p>The identifier of the language and locale of the transcripts to search. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a> </p>', 'SearchAssociatedTranscriptsResponse$localeId' => '<p>The identifier of the language and locale of the transcripts to search. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a> </p>', 'StartBotRecommendationRequest$localeId' => '<p>The identifier of the language and locale of the bot recommendation to start. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a> </p>', 'StartBotRecommendationResponse$localeId' => '<p>The identifier of the language and locale of the bot recommendation to start. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a> </p>', 'UpdateBotLocaleRequest$localeId' => '<p>The identifier of the language and locale to update. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>', 'UpdateBotLocaleResponse$localeId' => '<p>The language and locale of the updated bot locale.</p>', 'UpdateBotRecommendationRequest$localeId' => '<p>The identifier of the language and locale of the bot recommendation to update. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a> </p>', 'UpdateBotRecommendationResponse$localeId' => '<p>The identifier of the language and locale of the bot recommendation to update. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a> </p>', 'UpdateIntentRequest$localeId' => '<p>The identifier of the language and locale where this intent is used. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>', 'UpdateIntentResponse$localeId' => '<p>The updated language and locale of the intent.</p>', 'UpdateSlotRequest$localeId' => '<p>The identifier of the language and locale that contains the slot. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>', 'UpdateSlotResponse$localeId' => '<p>The locale that contains the slot.</p>', 'UpdateSlotTypeRequest$localeId' => '<p>The identifier of the language and locale that contains the slot type. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>', 'UpdateSlotTypeResponse$localeId' => '<p>The language and locale of the updated slot type.</p>', ], ], 'LocaleName' => [ 'base' => NULL, 'refs' => [ 'BotLocaleSummary$localeName' => '<p>The name of the bot locale.</p>', 'CreateBotLocaleResponse$localeName' => '<p>The specified locale name.</p>', 'DescribeBotLocaleResponse$localeName' => '<p>The name of the locale.</p>', 'UpdateBotLocaleResponse$localeName' => '<p>The updated locale name for the locale.</p>', ], ], 'LogPrefix' => [ 'base' => NULL, 'refs' => [ 'CloudWatchLogGroupLogDestination$logPrefix' => '<p>The prefix of the log stream name within the log group that you specified </p>', 'S3BucketLogDestination$logPrefix' => '<p>The S3 prefix to assign to audio log files.</p>', ], ], 'MaxResults' => [ 'base' => NULL, 'refs' => [ 'ListAggregatedUtterancesRequest$maxResults' => '<p>The maximum number of utterances to return in each page of results. If there are fewer results than the maximum page size, only the actual number of results are returned. If you don\'t specify the <code>maxResults</code> parameter, 1,000 results are returned.</p>', 'ListBotAliasesRequest$maxResults' => '<p>The maximum number of aliases to return in each page of results. If there are fewer results than the max page size, only the actual number of results are returned.</p>', 'ListBotLocalesRequest$maxResults' => '<p>The maximum number of aliases to return in each page of results. If there are fewer results than the max page size, only the actual number of results are returned.</p>', 'ListBotRecommendationsRequest$maxResults' => '<p>The maximum number of bot recommendations to return in each page of results. If there are fewer results than the max page size, only the actual number of results are returned.</p>', 'ListBotVersionsRequest$maxResults' => '<p>The maximum number of versions to return in each page of results. If there are fewer results than the max page size, only the actual number of results are returned.</p>', 'ListBotsRequest$maxResults' => '<p>The maximum number of bots to return in each page of results. If there are fewer results than the maximum page size, only the actual number of results are returned.</p>', 'ListExportsRequest$maxResults' => '<p>The maximum number of exports to return in each page of results. If there are fewer results than the max page size, only the actual number of results are returned.</p>', 'ListImportsRequest$maxResults' => '<p>The maximum number of imports to return in each page of results. If there are fewer results than the max page size, only the actual number of results are returned.</p>', 'ListIntentsRequest$maxResults' => '<p>The maximum number of intents to return in each page of results. If there are fewer results than the max page size, only the actual number of results are returned.</p>', 'ListRecommendedIntentsRequest$maxResults' => '<p>The maximum number of bot recommendations to return in each page of results. If there are fewer results than the max page size, only the actual number of results are returned.</p>', 'ListSlotTypesRequest$maxResults' => '<p>The maximum number of slot types to return in each page of results. If there are fewer results than the max page size, only the actual number of results are returned.</p>', 'ListSlotsRequest$maxResults' => '<p>The maximum number of slots to return in each page of results. If there are fewer results than the max page size, only the actual number of results are returned.</p>', 'SearchAssociatedTranscriptsRequest$maxResults' => '<p>The maximum number of bot recommendations to return in each page of results. If there are fewer results than the max page size, only the actual number of results are returned.</p>', 'SearchAssociatedTranscriptsResponse$totalResults' => '<p>The total number of transcripts returned by the search.</p>', ], ], 'MergeStrategy' => [ 'base' => NULL, 'refs' => [ 'DescribeImportResponse$mergeStrategy' => '<p>The strategy used when there was a name conflict between the imported resource and an existing resource. When the merge strategy is <code>FailOnConflict</code> existing resources are not overwritten and the import fails.</p>', 'ImportSummary$mergeStrategy' => '<p>The strategy used to merge existing bot or bot locale definitions with the imported definition.</p>', 'StartImportRequest$mergeStrategy' => '<p>The strategy to use when there is a name conflict between the imported resource and an existing resource. When the merge strategy is <code>FailOnConflict</code> existing resources are not overwritten and the import fails.</p>', 'StartImportResponse$mergeStrategy' => '<p>The strategy used when there was a name conflict between the imported resource and an existing resource. When the merge strategy is <code>FailOnConflict</code> existing resources are not overwritten and the import fails.</p>', ], ], 'Message' => [ 'base' => '<p>The object that provides message text and it\'s type.</p>', 'refs' => [ 'MessageGroup$message' => '<p>The primary message that Amazon Lex should send to the user.</p>', 'MessageVariationsList$member' => NULL, ], ], 'MessageGroup' => [ 'base' => '<p>Provides one or more messages that Amazon Lex should send to the user.</p>', 'refs' => [ 'MessageGroupsList$member' => NULL, ], ], 'MessageGroupsList' => [ 'base' => NULL, 'refs' => [ 'FulfillmentStartResponseSpecification$messageGroups' => '<p>One to 5 message groups that contain start messages. Amazon Lex chooses one of the messages to play to the user.</p>', 'FulfillmentUpdateResponseSpecification$messageGroups' => '<p>One to 5 message groups that contain update messages. Amazon Lex chooses one of the messages to play to the user.</p>', 'PromptSpecification$messageGroups' => '<p>A collection of messages that Amazon Lex can send to the user. Amazon Lex chooses the actual message to send at runtime.</p>', 'ResponseSpecification$messageGroups' => '<p>A collection of responses that Amazon Lex can send to the user. Amazon Lex chooses the actual response to send at runtime.</p>', 'StillWaitingResponseSpecification$messageGroups' => '<p>One or more message groups, each containing one or more messages, that define the prompts that Amazon Lex sends to the user.</p>', ], ], 'MessageVariationsList' => [ 'base' => NULL, 'refs' => [ 'MessageGroup$variations' => '<p>Message variations to send to the user. When variations are defined, Amazon Lex chooses the primary message or one of the variations to send to the user.</p>', ], ], 'MissedCount' => [ 'base' => NULL, 'refs' => [ 'AggregatedUtterancesSummary$missedCount' => '<p>The number of times that the utterance was missed by Amazon Lex An utterance is missed when it doesn\'t activate an intent or slot.</p>', ], ], 'MultipleValuesSetting' => [ 'base' => '<p>Indicates whether a slot can return multiple values.</p>', 'refs' => [ 'CreateSlotRequest$multipleValuesSetting' => '<p>Indicates whether the slot returns multiple values in one response. Multi-value slots are only available in the en-US locale. If you set this value to <code>true</code> in any other locale, Amazon Lex throws a <code>ValidationException</code>. </p> <p>If the <code>multipleValuesSetting</code> is not set, the default value is <code>false</code>.</p>', 'CreateSlotResponse$multipleValuesSetting' => '<p>Indicates whether the slot returns multiple values in one response.</p>', 'DescribeSlotResponse$multipleValuesSetting' => '<p>Indicates whether the slot accepts multiple values in a single utterance.</p> <p>If the <code>multipleValuesSetting</code> is not set, the default value is <code>false</code>.</p>', 'UpdateSlotRequest$multipleValuesSetting' => '<p>Determines whether the slot accepts multiple values in one response. Multiple value slots are only available in the en-US locale. If you set this value to <code>true</code> in any other locale, Amazon Lex throws a <code>ValidationException</code>.</p> <p>If the <code>multipleValuesSetting</code> is not set, the default value is <code>false</code>.</p>', 'UpdateSlotResponse$multipleValuesSetting' => '<p>Indicates whether the slot accepts multiple values in one response.</p>', ], ], 'Name' => [ 'base' => NULL, 'refs' => [ 'BotAliasSummary$botAliasName' => '<p>The name of the bot alias.</p>', 'BotImportSpecification$botName' => '<p>The name that Amazon Lex should use for the bot.</p>', 'BotSummary$botName' => '<p>The name of the bot.</p>', 'BotVersionSummary$botName' => '<p>The name of the bot associated with the version.</p>', 'CreateBotAliasRequest$botAliasName' => '<p>The alias to create. The name must be unique for the bot.</p>', 'CreateBotAliasResponse$botAliasName' => '<p>The name specified for the bot alias.</p>', 'CreateBotRequest$botName' => '<p>The name of the bot. The bot name must be unique in the account that creates the bot.</p>', 'CreateBotResponse$botName' => '<p>The name specified for the bot.</p>', 'CreateIntentRequest$intentName' => '<p>The name of the intent. Intent names must be unique in the locale that contains the intent and cannot match the name of any built-in intent.</p>', 'CreateIntentResponse$intentName' => '<p>The name specified for the intent.</p>', 'CreateResourcePolicyStatementRequest$statementId' => '<p>The name of the statement. The ID is the same as the <code>Sid</code> IAM property. The statement name must be unique within the policy. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html">IAM JSON policy elements: Sid</a>. </p>', 'CreateSlotRequest$slotName' => '<p>The name of the slot. Slot names must be unique within the bot that contains the slot.</p>', 'CreateSlotResponse$slotName' => '<p>The name specified for the slot.</p>', 'CreateSlotTypeRequest$slotTypeName' => '<p>The name for the slot. A slot type name must be unique within the account.</p>', 'CreateSlotTypeResponse$slotTypeName' => '<p>The name specified for the slot type.</p>', 'DeleteResourcePolicyStatementRequest$statementId' => '<p>The name of the statement (SID) to delete from the policy.</p>', 'DescribeBotAliasResponse$botAliasName' => '<p>The name of the bot alias.</p>', 'DescribeBotResponse$botName' => '<p>The name of the bot.</p>', 'DescribeBotVersionResponse$botName' => '<p>The name of the bot that contains the version.</p>', 'DescribeImportResponse$importedResourceName' => '<p>The name of the imported resource.</p>', 'DescribeIntentResponse$intentName' => '<p>The name specified for the intent.</p>', 'DescribeSlotResponse$slotName' => '<p>The name specified for the slot.</p>', 'DescribeSlotTypeResponse$slotTypeName' => '<p>The name specified for the slot type.</p>', 'ImportSummary$importedResourceName' => '<p>The name that you gave the imported resource.</p>', 'InputContext$name' => '<p>The name of the context.</p>', 'IntentSummary$intentName' => '<p>The name of the intent.</p>', 'OutputContext$name' => '<p>The name of the output context.</p>', 'RecommendedIntentSummary$intentName' => '<p>The name of a recommended intent associated with the bot recommendation.</p>', 'SlotSummary$slotName' => '<p>The name given to the slot.</p>', 'SlotTypeSummary$slotTypeName' => '<p>The name of the slot type.</p>', 'UpdateBotAliasRequest$botAliasName' => '<p>The new name to assign to the bot alias.</p>', 'UpdateBotAliasResponse$botAliasName' => '<p>The updated name of the bot alias.</p>', 'UpdateBotRequest$botName' => '<p>The new name of the bot. The name must be unique in the account that creates the bot.</p>', 'UpdateBotResponse$botName' => '<p>The name of the bot after the update.</p>', 'UpdateIntentRequest$intentName' => '<p>The new name for the intent.</p>', 'UpdateIntentResponse$intentName' => '<p>The updated name of the intent.</p>', 'UpdateSlotRequest$slotName' => '<p>The new name for the slot.</p>', 'UpdateSlotResponse$slotName' => '<p>The updated name of the slot.</p>', 'UpdateSlotTypeRequest$slotTypeName' => '<p>The new name of the slot type.</p>', 'UpdateSlotTypeResponse$slotTypeName' => '<p>The updated name of the slot type.</p>', ], ], 'NextIndex' => [ 'base' => NULL, 'refs' => [ 'SearchAssociatedTranscriptsRequest$nextIndex' => '<p>If the response from the SearchAssociatedTranscriptsRequest operation contains more results than specified in the maxResults parameter, an index is returned in the response. Use that index in the nextIndex parameter to return the next page of results.</p>', 'SearchAssociatedTranscriptsResponse$nextIndex' => '<p>A index that indicates whether there are more results to return in a response to the SearchAssociatedTranscripts operation. If the nextIndex field is present, you send the contents as the nextIndex parameter of a SearchAssociatedTranscriptsRequest operation to get the next page of results.</p>', ], ], 'NextToken' => [ 'base' => NULL, 'refs' => [ 'ListAggregatedUtterancesRequest$nextToken' => '<p>If the response from the <code>ListAggregatedUtterances</code> operation contains more results that specified in the <code>maxResults</code> parameter, a token is returned in the response. Use that token in the <code>nextToken</code> parameter to return the next page of results.</p>', 'ListAggregatedUtterancesResponse$nextToken' => '<p>A token that indicates whether there are more results to return in a response to the <code>ListAggregatedUtterances</code> operation. If the <code>nextToken</code> field is present, you send the contents as the <code>nextToken</code> parameter of a <code>ListAggregatedUtterances</code> operation request to get the next page of results.</p>', 'ListBotAliasesRequest$nextToken' => '<p>If the response from the <code>ListBotAliases</code> operation contains more results than specified in the <code>maxResults</code> parameter, a token is returned in the response. Use that token in the <code>nextToken</code> parameter to return the next page of results.</p>', 'ListBotAliasesResponse$nextToken' => '<p>A token that indicates whether there are more results to return in a response to the <code>ListBotAliases</code> operation. If the <code>nextToken</code> field is present, you send the contents as the <code>nextToken</code> parameter of a <code>ListBotAliases</code> operation request to get the next page of results.</p>', 'ListBotLocalesRequest$nextToken' => '<p>If the response from the <code>ListBotLocales</code> operation contains more results than specified in the <code>maxResults</code> parameter, a token is returned in the response. Use that token as the <code>nextToken</code> parameter to return the next page of results. </p>', 'ListBotLocalesResponse$nextToken' => '<p>A token that indicates whether there are more results to return in a response to the <code>ListBotLocales</code> operation. If the <code>nextToken</code> field is present, you send the contents as the <code>nextToken</code> parameter of a <code>ListBotLocales</code> operation request to get the next page of results.</p>', 'ListBotRecommendationsRequest$nextToken' => '<p>If the response from the ListBotRecommendation operation contains more results than specified in the maxResults parameter, a token is returned in the response. Use that token in the nextToken parameter to return the next page of results.</p>', 'ListBotRecommendationsResponse$nextToken' => '<p>A token that indicates whether there are more results to return in a response to the ListBotRecommendations operation. If the nextToken field is present, you send the contents as the nextToken parameter of a ListBotRecommendations operation request to get the next page of results. </p>', 'ListBotVersionsRequest$nextToken' => '<p>If the response to the <code>ListBotVersion</code> operation contains more results than specified in the <code>maxResults</code> parameter, a token is returned in the response. Use that token in the <code>nextToken</code> parameter to return the next page of results.</p>', 'ListBotVersionsResponse$nextToken' => '<p>A token that indicates whether there are more results to return in a response to the <code>ListBotVersions</code> operation. If the <code>nextToken</code> field is present, you send the contents as the <code>nextToken</code> parameter of a <code>ListBotAliases</code> operation request to get the next page of results.</p>', 'ListBotsRequest$nextToken' => '<p>If the response from the <code>ListBots</code> operation contains more results than specified in the <code>maxResults</code> parameter, a token is returned in the response. </p> <p>Use the returned token in the <code>nextToken</code> parameter of a <code>ListBots</code> request to return the next page of results. For a complete set of results, call the <code>ListBots</code> operation until the <code>nextToken</code> returned in the response is null.</p>', 'ListBotsResponse$nextToken' => '<p>A token that indicates whether there are more results to return in a response to the <code>ListBots</code> operation. If the <code>nextToken</code> field is present, you send the contents as the <code>nextToken</code> parameter of a <code>ListBots</code> operation request to get the next page of results.</p>', 'ListBuiltInIntentsRequest$nextToken' => '<p>If the response from the <code>ListBuiltInIntents</code> operation contains more results than specified in the <code>maxResults</code> parameter, a token is returned in the response. Use that token in the <code>nextToken</code> parameter to return the next page of results.</p>', 'ListBuiltInIntentsResponse$nextToken' => '<p>A token that indicates whether there are more results to return in a response to the <code>ListBuiltInIntents</code> operation. If the <code>nextToken</code> field is present, you send the contents as the <code>nextToken</code> parameter of a <code>ListBotAliases</code> operation request to get the next page of results.</p>', 'ListBuiltInSlotTypesRequest$nextToken' => '<p>If the response from the <code>ListBuiltInSlotTypes</code> operation contains more results than specified in the <code>maxResults</code> parameter, a token is returned in the response. Use that token in the <code>nextToken</code> parameter to return the next page of results.</p>', 'ListBuiltInSlotTypesResponse$nextToken' => '<p>A token that indicates whether there are more results to return in a response to the <code>ListBuiltInSlotTypes</code> operation. If the <code>nextToken</code> field is present, you send the contents as the <code>nextToken</code> parameter of a <code>LIstBuiltInSlotTypes</code> operation request to get the next page of results.</p>', 'ListExportsRequest$nextToken' => '<p>If the response from the <code>ListExports</code> operation contains more results that specified in the <code>maxResults</code> parameter, a token is returned in the response. </p> <p>Use the returned token in the <code>nextToken</code> parameter of a <code>ListExports</code> request to return the next page of results. For a complete set of results, call the <code>ListExports</code> operation until the <code>nextToken</code> returned in the response is null.</p>', 'ListExportsResponse$nextToken' => '<p>A token that indicates whether there are more results to return in a response to the <code>ListExports</code> operation. If the <code>nextToken</code> field is present, you send the contents as the <code>nextToken</code> parameter of a <code>ListExports</code> operation request to get the next page of results.</p>', 'ListImportsRequest$nextToken' => '<p>If the response from the <code>ListImports</code> operation contains more results than specified in the <code>maxResults</code> parameter, a token is returned in the response.</p> <p>Use the returned token in the <code>nextToken</code> parameter of a <code>ListImports</code> request to return the next page of results. For a complete set of results, call the <code>ListImports</code> operation until the <code>nextToken</code> returned in the response is null.</p>', 'ListImportsResponse$nextToken' => '<p>A token that indicates whether there are more results to return in a response to the <code>ListImports</code> operation. If the <code>nextToken</code> field is present, you send the contents as the <code>nextToken</code> parameter of a <code>ListImports</code> operation request to get the next page of results.</p>', 'ListIntentsRequest$nextToken' => '<p>If the response from the <code>ListIntents</code> operation contains more results than specified in the <code>maxResults</code> parameter, a token is returned in the response.</p> <p>Use the returned token in the <code>nextToken</code> parameter of a <code>ListIntents</code> request to return the next page of results. For a complete set of results, call the <code>ListIntents</code> operation until the <code>nextToken</code> returned in the response is null.</p>', 'ListIntentsResponse$nextToken' => '<p>A token that indicates whether there are more results to return in a response to the <code>ListIntents</code> operation. If the <code>nextToken</code> field is present, you send the contents as the <code>nextToken</code> parameter of a <code>ListIntents</code> operation request to get the next page of results.</p>', 'ListRecommendedIntentsRequest$nextToken' => '<p>If the response from the ListRecommendedIntents operation contains more results than specified in the maxResults parameter, a token is returned in the response. Use that token in the nextToken parameter to return the next page of results.</p>', 'ListRecommendedIntentsResponse$nextToken' => '<p>A token that indicates whether there are more results to return in a response to the ListRecommendedIntents operation. If the nextToken field is present, you send the contents as the nextToken parameter of a ListRecommendedIntents operation request to get the next page of results.</p>', 'ListSlotTypesRequest$nextToken' => '<p>If the response from the <code>ListSlotTypes</code> operation contains more results than specified in the <code>maxResults</code> parameter, a token is returned in the response. Use that token in the <code>nextToken</code> parameter to return the next page of results.</p>', 'ListSlotTypesResponse$nextToken' => '<p>A token that indicates whether there are more results to return in a response to the <code>ListSlotTypes</code> operation. If the <code>nextToken</code> field is present, you send the contents as the <code>nextToken</code> parameter of a <code>ListSlotTypes</code> operation request to get the next page of results.</p>', 'ListSlotsRequest$nextToken' => '<p>If the response from the <code>ListSlots</code> operation contains more results than specified in the <code>maxResults</code> parameter, a token is returned in the response. Use that token in the <code>nextToken</code> parameter to return the next page of results.</p>', 'ListSlotsResponse$nextToken' => '<p>A token that indicates whether there are more results to return in a response to the <code>ListSlots</code> operation. If the <code>nextToken</code> field is present, you send the contents as the <code>nextToken</code> parameter of a <code>ListSlots</code> operation request to get the next page of results.</p>', ], ], 'NumericalBotVersion' => [ 'base' => NULL, 'refs' => [ 'BotSummary$latestBotVersion' => '<p>The latest numerical version in use for the bot.</p>', 'CreateBotAliasRequest$botVersion' => '<p>The version of the bot that this alias points to. You can use the <a href="https://docs.aws.amazon.com/lexv2/latest/dg/API_UpdateBotAlias.html">UpdateBotAlias</a> operation to change the bot version associated with the alias.</p>', 'CreateBotAliasResponse$botVersion' => '<p>The version of the bot associated with this alias.</p>', 'CreateBotVersionResponse$botVersion' => '<p>The version number assigned to the version.</p>', 'DeleteBotVersionRequest$botVersion' => '<p>The version of the bot to delete.</p>', 'DeleteBotVersionResponse$botVersion' => '<p>The version of the bot that is being deleted.</p>', 'DescribeBotVersionRequest$botVersion' => '<p>The version of the bot to return metadata for.</p>', 'DescribeBotVersionResponse$botVersion' => '<p>The version of the bot to describe.</p>', ], ], 'ObfuscationSetting' => [ 'base' => '<p>Determines whether Amazon Lex obscures slot values in conversation logs. </p>', 'refs' => [ 'CreateSlotRequest$obfuscationSetting' => '<p>Determines how slot values are used in Amazon CloudWatch logs. If the value of the <code>obfuscationSetting</code> parameter is <code>DefaultObfuscation</code>, slot values are obfuscated in the log output. If the value is <code>None</code>, the actual value is present in the log output.</p> <p>The default is to obfuscate values in the CloudWatch logs.</p>', 'CreateSlotResponse$obfuscationSetting' => '<p>Indicates whether the slot is configured to obfuscate values in Amazon CloudWatch logs.</p>', 'DescribeSlotResponse$obfuscationSetting' => '<p>Whether slot values are shown in Amazon CloudWatch logs. If the value is <code>None</code>, the actual value of the slot is shown in logs.</p>', 'UpdateSlotRequest$obfuscationSetting' => '<p>New settings that determine how slot values are formatted in Amazon CloudWatch logs. </p>', 'UpdateSlotResponse$obfuscationSetting' => '<p>The updated setting that determines whether the slot value is obfuscated in the Amazon CloudWatch logs.</p>', ], ], 'ObfuscationSettingType' => [ 'base' => NULL, 'refs' => [ 'ObfuscationSetting$obfuscationSettingType' => '<p>Value that determines whether Amazon Lex obscures slot values in conversation logs. The default is to obscure the values.</p>', ], ], 'ObjectPrefix' => [ 'base' => NULL, 'refs' => [ 'ObjectPrefixes$member' => NULL, ], ], 'ObjectPrefixes' => [ 'base' => NULL, 'refs' => [ 'PathFormat$objectPrefixes' => '<p>A list of Amazon S3 prefixes that points to sub-folders in the Amazon S3 bucket. Specify this list if you only want Lex to read the files under this set of sub-folders.</p>', ], ], 'Operation' => [ 'base' => NULL, 'refs' => [ 'OperationList$member' => NULL, ], ], 'OperationList' => [ 'base' => NULL, 'refs' => [ 'CreateResourcePolicyStatementRequest$action' => '<p>The Amazon Lex action that this policy either allows or denies. The action must apply to the resource type of the specified ARN. For more information, see <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonlexv2.html"> Actions, resources, and condition keys for Amazon Lex V2</a>.</p>', ], ], 'OutputContext' => [ 'base' => '<p>Describes a session context that is activated when an intent is fulfilled.</p>', 'refs' => [ 'OutputContextsList$member' => NULL, ], ], 'OutputContextsList' => [ 'base' => NULL, 'refs' => [ 'CreateIntentRequest$outputContexts' => '<p>A lists of contexts that the intent activates when it is fulfilled.</p> <p>You can use an output context to indicate the intents that Amazon Lex should consider for the next turn of the conversation with a customer. </p> <p>When you use the <code>outputContextsList</code> property, all of the contexts specified in the list are activated when the intent is fulfilled. You can set up to 10 output contexts. You can also set the number of conversation turns that the context should be active, or the length of time that the context should be active.</p>', 'CreateIntentResponse$outputContexts' => '<p>The list of output contexts specified for the intent.</p>', 'DescribeIntentResponse$outputContexts' => '<p>A list of contexts that are activated when the intent is fulfilled.</p>', 'IntentSummary$outputContexts' => '<p>The output contexts that are activated when this intent is fulfilled.</p>', 'UpdateIntentRequest$outputContexts' => '<p>A new list of contexts that Amazon Lex activates when the intent is fulfilled.</p>', 'UpdateIntentResponse$outputContexts' => '<p>The updated list of contexts that Amazon Lex activates when the intent is fulfilled.</p>', ], ], 'PathFormat' => [ 'base' => '<p>The object that contains a path format that will be applied when Amazon Lex reads the transcript file in the bucket you provide. Specify this object if you only want Lex to read a subset of files in your Amazon S3 bucket.</p>', 'refs' => [ 'S3BucketTranscriptSource$pathFormat' => '<p>The object that contains a path format that will be applied when Amazon Lex reads the transcript file in the bucket you provide. Specify this object if you only want Lex to read a subset of files in your Amazon S3 bucket.</p>', ], ], 'PlainTextMessage' => [ 'base' => '<p>Defines an ASCII text message to send to the user.</p>', 'refs' => [ 'Message$plainTextMessage' => '<p>A message in plain text format.</p>', ], ], 'PlainTextMessageValue' => [ 'base' => NULL, 'refs' => [ 'PlainTextMessage$value' => '<p>The message to send to the user.</p>', ], ], 'Policy' => [ 'base' => NULL, 'refs' => [ 'CreateResourcePolicyRequest$policy' => '<p>A resource policy to add to the resource. The policy is a JSON structure that contains one or more statements that define the policy. The policy must follow the IAM syntax. For more information about the contents of a JSON policy document, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies.html"> IAM JSON policy reference </a>. </p> <p>If the policy isn\'t valid, Amazon Lex returns a validation exception.</p>', 'DescribeResourcePolicyResponse$policy' => '<p>The JSON structure that contains the resource policy. For more information about the contents of a JSON policy document, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies.html"> IAM JSON policy reference </a>.</p>', 'UpdateResourcePolicyRequest$policy' => '<p>A resource policy to add to the resource. The policy is a JSON structure that contains one or more statements that define the policy. The policy must follow the IAM syntax. For more information about the contents of a JSON policy document, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies.html"> IAM JSON policy reference </a>. </p> <p>If the policy isn\'t valid, Amazon Lex returns a validation exception.</p>', ], ], 'PostFulfillmentStatusSpecification' => [ 'base' => '<p>Provides a setting that determines whether the post-fulfillment response is sent to the user. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/streaming-progress.html#progress-complete">https://docs.aws.amazon.com/lexv2/latest/dg/streaming-progress.html#progress-complete</a> </p>', 'refs' => [ 'FulfillmentCodeHookSettings$postFulfillmentStatusSpecification' => '<p>Provides settings for messages sent to the user for after the Lambda fulfillment function completes. Post-fulfillment messages can be sent for both streaming and non-streaming conversations.</p>', ], ], 'PreconditionFailedException' => [ 'base' => '<p>Your request couldn\'t be completed because one or more request fields aren\'t valid. Check the fields in your request and try again.</p>', 'refs' => [], ], 'PresignedS3Url' => [ 'base' => NULL, 'refs' => [ 'BotRecommendationResults$botLocaleExportUrl' => '<p>The presigned URL link of the recommended bot definition.</p>', 'BotRecommendationResults$associatedTranscriptsUrl' => '<p>The presigned url link of the associated transcript.</p>', 'CreateUploadUrlResponse$uploadUrl' => '<p>A pre-signed S3 write URL. Upload the zip archive file that contains the definition of your bot or bot locale.</p>', 'DescribeExportResponse$downloadUrl' => '<p>A pre-signed S3 URL that points to the bot or bot locale archive. The URL is only available for 5 minutes after calling the <code>DescribeExport</code> operation.</p>', ], ], 'Principal' => [ 'base' => '<p>The IAM principal that you allowing or denying access to an Amazon Lex action. You must provide a <code>service</code> or an <code>arn</code>, but not both in the same statement. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_principal.html"> AWS JSON policy elements: Principal </a>.</p>', 'refs' => [ 'PrincipalList$member' => NULL, ], ], 'PrincipalArn' => [ 'base' => NULL, 'refs' => [ 'Principal$arn' => '<p>The Amazon Resource Name (ARN) of the principal.</p>', ], ], 'PrincipalList' => [ 'base' => NULL, 'refs' => [ 'CreateResourcePolicyStatementRequest$principal' => '<p>An IAM principal, such as an IAM users, IAM roles, or AWS services that is allowed or denied access to a resource. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_principal.html">AWS JSON policy elements: Principal</a>.</p>', ], ], 'PriorityValue' => [ 'base' => NULL, 'refs' => [ 'SlotPriority$priority' => '<p>The priority that a slot should be elicited.</p>', ], ], 'PromptMaxRetries' => [ 'base' => NULL, 'refs' => [ 'PromptSpecification$maxRetries' => '<p>The maximum number of times the bot tries to elicit a response from the user using this prompt.</p>', ], ], 'PromptSpecification' => [ 'base' => '<p>Specifies a list of message groups that Amazon Lex sends to a user to elicit a response.</p>', 'refs' => [ 'IntentConfirmationSetting$promptSpecification' => '<p>Prompts the user to confirm the intent. This question should have a yes or no answer.</p> <p>Amazon Lex uses this prompt to ensure that the user acknowledges that the intent is ready for fulfillment. For example, with the <code>OrderPizza</code> intent, you might want to confirm that the order is correct before placing it. For other intents, such as intents that simply respond to user questions, you might not need to ask the user for confirmation before providing the information. </p>', 'SlotSummary$valueElicitationPromptSpecification' => '<p>Prompts that are sent to the user to elicit a value for the slot.</p>', 'SlotValueElicitationSetting$promptSpecification' => '<p>The prompt that Amazon Lex uses to elicit the slot value from the user.</p>', ], ], 'QueryFilterString' => [ 'base' => NULL, 'refs' => [ 'KendraConfiguration$queryFilterString' => '<p>A query filter that Amazon Lex sends to Amazon Kendra to filter the response from a query. The filter is in the format defined by Amazon Kendra. For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/filtering.html">Filtering queries</a>.</p>', ], ], 'RecommendedAction' => [ 'base' => NULL, 'refs' => [ 'RecommendedActions$member' => NULL, ], ], 'RecommendedActions' => [ 'base' => NULL, 'refs' => [ 'DescribeBotLocaleResponse$recommendedActions' => '<p>Recommended actions to take to resolve an error in the <code>failureReasons</code> field.</p>', 'UpdateBotLocaleResponse$recommendedActions' => '<p>Recommended actions to take to resolve an error in the <code>failureReasons</code> field.</p>', ], ], 'RecommendedIntentSummary' => [ 'base' => '<p>An object that contains a summary of a recommended intent.</p>', 'refs' => [ 'RecommendedIntentSummaryList$member' => NULL, ], ], 'RecommendedIntentSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListRecommendedIntentsResponse$summaryList' => '<p>Summary information for the intents that meet the filter criteria specified in the request. The length of the list is specified in the maxResults parameter of the request. If there are more intents available, the nextToken field contains a token to get the next page of results.</p>', ], ], 'RegexPattern' => [ 'base' => NULL, 'refs' => [ 'SlotValueRegexFilter$pattern' => '<p>A regular expression used to validate the value of a slot.</p> <p> Use a standard regular expression. Amazon Lex supports the following characters in the regular expression: </p> <ul> <li> <p>A-Z, a-z</p> </li> <li> <p>0-9</p> </li> <li> <p>Unicode characters ("\\ u&lt;Unicode&gt;")</p> </li> </ul> <p> Represent Unicode characters with four digits, for example "\\u0041" or "\\u005A". </p> <p> The following regular expression operators are not supported: </p> <ul> <li> <p>Infinite repeaters: *, +, or {x,} with no upper bound.</p> </li> <li> <p>Wild card (.)</p> </li> </ul>', ], ], 'RelativeAggregationDuration' => [ 'base' => '<p>Specifies the time window that utterance statistics are returned for. The time window is always relative to the last time that the that utterances were aggregated. For example, if the <code>ListAggregatedUtterances</code> operation is called at 1600, the time window is set to 1 hour, and the last refresh time was 1530, only utterances made between 1430 and 1530 are returned.</p> <p>You can choose the time window that statistics should be returned for.</p> <ul> <li> <p> <b>Hours</b> - You can request utterance statistics for 1, 3, 6, 12, or 24 hour time windows. Statistics are refreshed every half hour for 1 hour time windows, and hourly for the other time windows.</p> </li> <li> <p> <b>Days</b> - You can request utterance statistics for 3 days. Statistics are refreshed every 6 hours.</p> </li> <li> <p> <b>Weeks</b> - You can see statistics for one or two weeks. Statistics are refreshed every 12 hours for one week time windows, and once per day for two week time windows.</p> </li> </ul>', 'refs' => [ 'UtteranceAggregationDuration$relativeAggregationDuration' => '<p>The desired time window for aggregating utterances. </p>', ], ], 'ResourceCount' => [ 'base' => NULL, 'refs' => [ 'DescribeBotLocaleResponse$intentsCount' => '<p>The number of intents defined for the locale.</p>', 'DescribeBotLocaleResponse$slotTypesCount' => '<p>The number of slot types defined for the locale.</p>', ], ], 'ResourceNotFoundException' => [ 'base' => '<p>You asked to describe a resource that doesn\'t exist. Check the resource that you are requesting and try again.</p>', 'refs' => [], ], 'ResponseSpecification' => [ 'base' => '<p>Specifies a list of message groups that Amazon Lex uses to respond the user input.</p>', 'refs' => [ 'IntentClosingSetting$closingResponse' => '<p>The response that Amazon Lex sends to the user when the intent is complete.</p>', 'IntentConfirmationSetting$declinationResponse' => '<p>When the user answers "no" to the question defined in <code>promptSpecification</code>, Amazon Lex responds with this response to acknowledge that the intent was canceled. </p>', 'PostFulfillmentStatusSpecification$successResponse' => NULL, 'PostFulfillmentStatusSpecification$failureResponse' => NULL, 'PostFulfillmentStatusSpecification$timeoutResponse' => NULL, 'WaitAndContinueSpecification$waitingResponse' => '<p>The response that Amazon Lex sends to indicate that the bot is waiting for the conversation to continue.</p>', 'WaitAndContinueSpecification$continueResponse' => '<p>The response that Amazon Lex sends to indicate that the bot is ready to continue the conversation.</p>', ], ], 'RetryAfterSeconds' => [ 'base' => NULL, 'refs' => [ 'ThrottlingException$retryAfterSeconds' => NULL, ], ], 'RevisionId' => [ 'base' => NULL, 'refs' => [ 'CreateResourcePolicyResponse$revisionId' => '<p>The current revision of the resource policy. Use the revision ID to make sure that you are updating the most current version of a resource policy when you add a policy statement to a resource, delete a resource, or update a resource.</p>', 'CreateResourcePolicyStatementRequest$expectedRevisionId' => '<p>The identifier of the revision of the policy to edit. If this revision ID doesn\'t match the current revision ID, Amazon Lex throws an exception.</p> <p>If you don\'t specify a revision, Amazon Lex overwrites the contents of the policy with the new values.</p>', 'CreateResourcePolicyStatementResponse$revisionId' => '<p>The current revision of the resource policy. Use the revision ID to make sure that you are updating the most current version of a resource policy when you add a policy statement to a resource, delete a resource, or update a resource.</p>', 'DeleteResourcePolicyRequest$expectedRevisionId' => '<p>The identifier of the revision to edit. If this ID doesn\'t match the current revision number, Amazon Lex returns an exception</p> <p>If you don\'t specify a revision ID, Amazon Lex will delete the current policy.</p>', 'DeleteResourcePolicyResponse$revisionId' => '<p>The current revision of the resource policy. Use the revision ID to make sure that you are updating the most current version of a resource policy when you add a policy statement to a resource, delete a resource, or update a resource.</p>', 'DeleteResourcePolicyStatementRequest$expectedRevisionId' => '<p>The identifier of the revision of the policy to delete the statement from. If this revision ID doesn\'t match the current revision ID, Amazon Lex throws an exception.</p> <p>If you don\'t specify a revision, Amazon Lex removes the current contents of the statement. </p>', 'DeleteResourcePolicyStatementResponse$revisionId' => '<p>The current revision of the resource policy. Use the revision ID to make sure that you are updating the most current version of a resource policy when you add a policy statement to a resource, delete a resource, or update a resource.</p>', 'DescribeResourcePolicyResponse$revisionId' => '<p>The current revision of the resource policy. Use the revision ID to make sure that you are updating the most current version of a resource policy when you add a policy statement to a resource, delete a resource, or update a resource.</p>', 'UpdateResourcePolicyRequest$expectedRevisionId' => '<p>The identifier of the revision of the policy to update. If this revision ID doesn\'t match the current revision ID, Amazon Lex throws an exception.</p> <p>If you don\'t specify a revision, Amazon Lex overwrites the contents of the policy with the new values.</p>', 'UpdateResourcePolicyResponse$revisionId' => '<p>The current revision of the resource policy. Use the revision ID to make sure that you are updating the most current version of a resource policy when you add a policy statement to a resource, delete a resource, or update a resource.</p>', ], ], 'RoleArn' => [ 'base' => NULL, 'refs' => [ 'BotImportSpecification$roleArn' => '<p>The Amazon Resource Name (ARN) of the IAM role used to build and run the bot.</p>', 'CreateBotRequest$roleArn' => '<p>The Amazon Resource Name (ARN) of an IAM role that has permission to access the bot.</p>', 'CreateBotResponse$roleArn' => '<p>The IAM role specified for the bot.</p>', 'DescribeBotResponse$roleArn' => '<p>The Amazon Resource Name (ARN) of an IAM role that has permission to access the bot.</p>', 'DescribeBotVersionResponse$roleArn' => '<p>The Amazon Resource Name (ARN) of an IAM role that has permission to access the bot version.</p>', 'UpdateBotRequest$roleArn' => '<p>The Amazon Resource Name (ARN) of an IAM role that has permissions to access the bot.</p>', 'UpdateBotResponse$roleArn' => '<p>The Amazon Resource Name (ARN) of the IAM role used by the bot after the update.</p>', ], ], 'S3BucketArn' => [ 'base' => NULL, 'refs' => [ 'S3BucketLogDestination$s3BucketArn' => '<p>The Amazon Resource Name (ARN) of an Amazon S3 bucket where audio log files are stored.</p>', ], ], 'S3BucketLogDestination' => [ 'base' => '<p>Specifies an Amazon S3 bucket for logging audio conversations</p>', 'refs' => [ 'AudioLogDestination$s3Bucket' => '<p>The Amazon S3 bucket where the audio log files are stored. The IAM role specified in the <code>roleArn</code> parameter of the <a href="https://docs.aws.amazon.com/lexv2/latest/dg/API_CreateBot.html">CreateBot</a> operation must have permission to write to this bucket.</p>', ], ], 'S3BucketName' => [ 'base' => NULL, 'refs' => [ 'GrammarSlotTypeSource$s3BucketName' => '<p>The name of the S3 bucket that contains the grammar source.</p>', 'S3BucketTranscriptSource$s3BucketName' => '<p>The name of the bucket containing the transcript and the associated metadata.</p>', ], ], 'S3BucketTranscriptSource' => [ 'base' => '<p>The object representing the Amazon S3 bucket containing the transcript, as well as the associated metadata.</p>', 'refs' => [ 'TranscriptSourceSetting$s3BucketTranscriptSource' => '<p>Indicates the setting of the Amazon S3 bucket where the transcript is stored.</p>', ], ], 'S3ObjectPath' => [ 'base' => NULL, 'refs' => [ 'GrammarSlotTypeSource$s3ObjectKey' => '<p>The path to the grammar in the S3 bucket.</p>', ], ], 'SSMLMessage' => [ 'base' => '<p>Defines a Speech Synthesis Markup Language (SSML) prompt.</p>', 'refs' => [ 'Message$ssmlMessage' => '<p>A message in Speech Synthesis Markup Language (SSML).</p>', ], ], 'SSMLMessageValue' => [ 'base' => NULL, 'refs' => [ 'SSMLMessage$value' => '<p>The SSML text that defines the prompt.</p>', ], ], 'SampleUtterance' => [ 'base' => '<p>A sample utterance that invokes an intent or respond to a slot elicitation prompt.</p>', 'refs' => [ 'SampleUtterancesList$member' => NULL, ], ], 'SampleUtterancesCount' => [ 'base' => NULL, 'refs' => [ 'RecommendedIntentSummary$sampleUtterancesCount' => '<p>The count of sample utterances of a recommended intent that is associated with a bot recommendation.</p>', ], ], 'SampleUtterancesList' => [ 'base' => NULL, 'refs' => [ 'CreateIntentRequest$sampleUtterances' => '<p>An array of strings that a user might say to signal the intent. For example, "I want a pizza", or "I want a {PizzaSize} pizza". </p> <p>In an utterance, slot names are enclosed in curly braces ("{", "}") to indicate where they should be displayed in the utterance shown to the user.. </p>', 'CreateIntentResponse$sampleUtterances' => '<p>The sample utterances specified for the intent.</p>', 'DescribeIntentResponse$sampleUtterances' => '<p>User utterances that trigger this intent.</p>', 'SlotValueElicitationSetting$sampleUtterances' => '<p>If you know a specific pattern that users might respond to an Amazon Lex request for a slot value, you can provide those utterances to improve accuracy. This is optional. In most cases, Amazon Lex is capable of understanding user utterances.</p>', 'UpdateIntentRequest$sampleUtterances' => '<p>New utterances used to invoke the intent.</p>', 'UpdateIntentResponse$sampleUtterances' => '<p>The updated list of sample utterances for the intent.</p>', ], ], 'SampleValue' => [ 'base' => '<p>Defines one of the values for a slot type.</p>', 'refs' => [ 'SlotTypeValue$sampleValue' => '<p>The value of the slot type entry.</p>', 'SynonymList$member' => NULL, ], ], 'SearchAssociatedTranscriptsRequest' => [ 'base' => NULL, 'refs' => [], ], 'SearchAssociatedTranscriptsResponse' => [ 'base' => NULL, 'refs' => [], ], 'SearchOrder' => [ 'base' => NULL, 'refs' => [ 'SearchAssociatedTranscriptsRequest$searchOrder' => '<p>How SearchResults are ordered. Valid values are Ascending or Descending. The default is Descending.</p>', ], ], 'SentimentAnalysisSettings' => [ 'base' => '<p>Determines whether Amazon Lex will use Amazon Comprehend to detect the sentiment of user utterances.</p>', 'refs' => [ 'CreateBotAliasRequest$sentimentAnalysisSettings' => NULL, 'CreateBotAliasResponse$sentimentAnalysisSettings' => NULL, 'DescribeBotAliasResponse$sentimentAnalysisSettings' => NULL, 'UpdateBotAliasRequest$sentimentAnalysisSettings' => NULL, 'UpdateBotAliasResponse$sentimentAnalysisSettings' => NULL, ], ], 'ServicePrincipal' => [ 'base' => NULL, 'refs' => [ 'Principal$service' => '<p>The name of the AWS service that should allowed or denied access to an Amazon Lex action.</p>', ], ], 'ServiceQuotaExceededException' => [ 'base' => '<p>You have reached a quota for your bot. </p>', 'refs' => [], ], 'SessionId' => [ 'base' => NULL, 'refs' => [ 'DeleteUtterancesRequest$sessionId' => '<p>The unique identifier of the session with the user. The ID is returned in the response from the <a href="https://docs.aws.amazon.com/lexv2/latest/dg/API_runtime_RecognizeText.html">RecognizeText</a> and <a href="https://docs.aws.amazon.com/lexv2/latest/dg/API_runtime_RecognizeUtterance.html">RecognizeUtterance</a> operations.</p>', ], ], 'SessionTTL' => [ 'base' => NULL, 'refs' => [ 'BotImportSpecification$idleSessionTTLInSeconds' => '<p>The time, in seconds, that Amazon Lex should keep information about a user\'s conversation with the bot. </p> <p>A user interaction remains active for the amount of time specified. If no conversation occurs during this time, the session expires and Amazon Lex deletes any data provided before the timeout.</p> <p>You can specify between 60 (1 minute) and 86,400 (24 hours) seconds.</p>', 'CreateBotRequest$idleSessionTTLInSeconds' => '<p>The time, in seconds, that Amazon Lex should keep information about a user\'s conversation with the bot. </p> <p>A user interaction remains active for the amount of time specified. If no conversation occurs during this time, the session expires and Amazon Lex deletes any data provided before the timeout.</p> <p>You can specify between 60 (1 minute) and 86,400 (24 hours) seconds.</p>', 'CreateBotResponse$idleSessionTTLInSeconds' => '<p>The session idle time specified for the bot.</p>', 'DescribeBotResponse$idleSessionTTLInSeconds' => '<p>The maximum time in seconds that Amazon Lex retains the data gathered in a conversation.</p>', 'DescribeBotVersionResponse$idleSessionTTLInSeconds' => '<p>The number of seconds that a session with the bot remains active before it is discarded by Amazon Lex.</p>', 'UpdateBotRequest$idleSessionTTLInSeconds' => '<p>The time, in seconds, that Amazon Lex should keep information about a user\'s conversation with the bot.</p> <p>A user interaction remains active for the amount of time specified. If no conversation occurs during this time, the session expires and Amazon Lex deletes any data provided before the timeout.</p> <p>You can specify between 60 (1 minute) and 86,400 (24 hours) seconds.</p>', 'UpdateBotResponse$idleSessionTTLInSeconds' => '<p>The session timeout, in seconds, for the bot after the update.</p>', ], ], 'SkipResourceInUseCheck' => [ 'base' => NULL, 'refs' => [ 'DeleteBotAliasRequest$skipResourceInUseCheck' => '<p>When this parameter is true, Amazon Lex doesn\'t check to see if any other resource is using the alias before it is deleted.</p>', 'DeleteBotRequest$skipResourceInUseCheck' => '<p>When <code>true</code>, Amazon Lex doesn\'t check to see if another resource, such as an alias, is using the bot before it is deleted.</p>', 'DeleteBotVersionRequest$skipResourceInUseCheck' => '<p>By default, the <code>DeleteBotVersion</code> operations throws a <code>ResourceInUseException</code> exception if you try to delete a bot version that has an alias pointing at it. Set the <code>skipResourceInUseCheck</code> parameter to <code>true</code> to skip this check and remove the version even if an alias points to it.</p>', 'DeleteSlotTypeRequest$skipResourceInUseCheck' => '<p>By default, the <code>DeleteSlotType</code> operations throws a <code>ResourceInUseException</code> exception if you try to delete a slot type used by a slot. Set the <code>skipResourceInUseCheck</code> parameter to <code>true</code> to skip this check and remove the slot type even if a slot uses it.</p>', ], ], 'SlotConstraint' => [ 'base' => NULL, 'refs' => [ 'SlotSummary$slotConstraint' => '<p>Whether the slot is required or optional. An intent is complete when all required slots are filled.</p>', 'SlotValueElicitationSetting$slotConstraint' => '<p>Specifies whether the slot is required or optional.</p>', ], ], 'SlotDefaultValue' => [ 'base' => '<p>Specifies the default value to use when a user doesn\'t provide a value for a slot.</p>', 'refs' => [ 'SlotDefaultValueList$member' => NULL, ], ], 'SlotDefaultValueList' => [ 'base' => NULL, 'refs' => [ 'SlotDefaultValueSpecification$defaultValueList' => '<p>A list of default values. Amazon Lex chooses the default value to use in the order that they are presented in the list.</p>', ], ], 'SlotDefaultValueSpecification' => [ 'base' => '<p>Defines a list of values that Amazon Lex should use as the default value for a slot.</p>', 'refs' => [ 'SlotValueElicitationSetting$defaultValueSpecification' => '<p>A list of default values for a slot. Default values are used when Amazon Lex hasn\'t determined a value for a slot. You can specify default values from context variables, session attributes, and defined values.</p>', ], ], 'SlotDefaultValueString' => [ 'base' => NULL, 'refs' => [ 'SlotDefaultValue$defaultValue' => '<p>The default value to use when a user doesn\'t provide a value for a slot.</p>', ], ], 'SlotFilter' => [ 'base' => '<p>Filters the response from the <code>ListSlots</code> operation.</p>', 'refs' => [ 'SlotFilters$member' => NULL, ], ], 'SlotFilterName' => [ 'base' => NULL, 'refs' => [ 'SlotFilter$name' => '<p>The name of the field to use for filtering.</p>', ], ], 'SlotFilterOperator' => [ 'base' => NULL, 'refs' => [ 'SlotFilter$operator' => '<p>The operator to use for the filter. Specify <code>EQ</code> when the <code>ListSlots</code> operation should return only aliases that equal the specified value. Specify <code>CO</code> when the <code>ListSlots</code> operation should return aliases that contain the specified value.</p>', ], ], 'SlotFilters' => [ 'base' => NULL, 'refs' => [ 'ListSlotsRequest$filters' => '<p>Provides the specification of a filter used to limit the slots in the response to only those that match the filter specification. You can only specify one filter and only one string to filter on.</p>', ], ], 'SlotPrioritiesList' => [ 'base' => NULL, 'refs' => [ 'DescribeIntentResponse$slotPriorities' => '<p>The list that determines the priority that slots should be elicited from the user.</p>', 'UpdateIntentRequest$slotPriorities' => '<p>A new list of slots and their priorities that are contained by the intent.</p>', 'UpdateIntentResponse$slotPriorities' => '<p>The updated list of slots and their priorities that are elicited from the user for the intent.</p>', ], ], 'SlotPriority' => [ 'base' => '<p>Sets the priority that Amazon Lex should use when eliciting slot values from a user.</p>', 'refs' => [ 'SlotPrioritiesList$member' => NULL, ], ], 'SlotSortAttribute' => [ 'base' => NULL, 'refs' => [ 'SlotSortBy$attribute' => '<p>The attribute to use to sort the list.</p>', ], ], 'SlotSortBy' => [ 'base' => '<p>Specifies attributes for sorting a list of bots.</p>', 'refs' => [ 'ListSlotsRequest$sortBy' => '<p>Determines the sort order for the response from the <code>ListSlots</code> operation. You can choose to sort by the slot name or last updated date in either ascending or descending order.</p>', ], ], 'SlotSummary' => [ 'base' => '<p>Summary information about a slot, a value that the bot elicits from the user.</p>', 'refs' => [ 'SlotSummaryList$member' => NULL, ], ], 'SlotSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListSlotsResponse$slotSummaries' => '<p>Summary information for the slots that meet the filter criteria specified in the request. The length of the list is specified in the <code>maxResults</code> parameter of the request. If there are more slots available, the <code>nextToken</code> field contains a token to get the next page of results.</p>', ], ], 'SlotTypeCategory' => [ 'base' => NULL, 'refs' => [ 'SlotTypeSummary$slotTypeCategory' => '<p>Indicates the type of the slot type.</p> <ul> <li> <p> <code>Custom</code> - A slot type that you created using custom values. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/custom-slot-types.html">Creating custom slot types</a>.</p> </li> <li> <p> <code>Extended</code> - A slot type created by extending the AMAZON.AlphaNumeric built-in slot type. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/built-in-slot-alphanumerice.html">AMAZON.AlphaNumeric</a>.</p> </li> <li> <p> <code>ExternalGrammar</code> - A slot type using a custom GRXML grammar to define values. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/building-grxml.html">Using a custom grammar slot type</a>.</p> </li> </ul>', ], ], 'SlotTypeFilter' => [ 'base' => '<p>Filters the response from the <code>ListSlotTypes</code> operation.</p>', 'refs' => [ 'SlotTypeFilters$member' => NULL, ], ], 'SlotTypeFilterName' => [ 'base' => NULL, 'refs' => [ 'SlotTypeFilter$name' => '<p>The name of the field to use for filtering.</p>', ], ], 'SlotTypeFilterOperator' => [ 'base' => NULL, 'refs' => [ 'SlotTypeFilter$operator' => '<p>The operator to use for the filter. Specify <code>EQ</code> when the <code>ListSlotTypes</code> operation should return only aliases that equal the specified value. Specify <code>CO</code> when the <code>ListSlotTypes</code> operation should return aliases that contain the specified value.</p>', ], ], 'SlotTypeFilters' => [ 'base' => NULL, 'refs' => [ 'ListSlotTypesRequest$filters' => '<p>Provides the specification of a filter used to limit the slot types in the response to only those that match the filter specification. You can only specify one filter and only one string to filter on.</p>', ], ], 'SlotTypeSignature' => [ 'base' => NULL, 'refs' => [ 'BuiltInSlotTypeSummary$slotTypeSignature' => '<p>The signature of the built-in slot type. Use this to specify the parent slot type of a derived slot type.</p>', 'CreateSlotTypeRequest$parentSlotTypeSignature' => '<p>The built-in slot type used as a parent of this slot type. When you define a parent slot type, the new slot type has the configuration of the parent slot type.</p> <p>Only <code>AMAZON.AlphaNumeric</code> is supported.</p>', 'CreateSlotTypeResponse$parentSlotTypeSignature' => '<p>The signature of the base slot type specified for the slot type.</p>', 'DescribeSlotTypeResponse$parentSlotTypeSignature' => '<p>The built in slot type used as a parent to this slot type.</p>', 'SlotTypeSummary$parentSlotTypeSignature' => '<p>If the slot type is derived from a built-on slot type, the name of the parent slot type.</p>', 'UpdateSlotTypeRequest$parentSlotTypeSignature' => '<p>The new built-in slot type that should be used as the parent of this slot type.</p>', 'UpdateSlotTypeResponse$parentSlotTypeSignature' => '<p>The updated signature of the built-in slot type that is the parent of this slot type.</p>', ], ], 'SlotTypeSortAttribute' => [ 'base' => NULL, 'refs' => [ 'SlotTypeSortBy$attribute' => '<p>The attribute to use to sort the list of slot types.</p>', ], ], 'SlotTypeSortBy' => [ 'base' => '<p>Specifies attributes for sorting a list of slot types.</p>', 'refs' => [ 'ListSlotTypesRequest$sortBy' => '<p>Determines the sort order for the response from the <code>ListSlotTypes</code> operation. You can choose to sort by the slot type name or last updated date in either ascending or descending order.</p>', ], ], 'SlotTypeStatistics' => [ 'base' => '<p>The object that contains the statistical summary of the recommended slot type associated with the bot recommendation.</p>', 'refs' => [ 'BotRecommendationResultStatistics$slotTypes' => '<p>Statistical information about the slot types associated with the bot recommendation results.</p>', ], ], 'SlotTypeSummary' => [ 'base' => '<p>Provides summary information about a slot type.</p>', 'refs' => [ 'SlotTypeSummaryList$member' => NULL, ], ], 'SlotTypeSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListSlotTypesResponse$slotTypeSummaries' => '<p>Summary information for the slot types that meet the filter criteria specified in the request. The length of the list is specified in the <code>maxResults</code> parameter of the request. If there are more slot types available, the <code>nextToken</code> field contains a token to get the next page of results.</p>', ], ], 'SlotTypeValue' => [ 'base' => '<p>Each slot type can have a set of values. Each <code>SlotTypeValue</code> represents a value that the slot type can take.</p>', 'refs' => [ 'SlotTypeValues$member' => NULL, ], ], 'SlotTypeValues' => [ 'base' => NULL, 'refs' => [ 'CreateSlotTypeRequest$slotTypeValues' => '<p>A list of <code>SlotTypeValue</code> objects that defines the values that the slot type can take. Each value can have a list of synonyms, additional values that help train the machine learning model about the values that it resolves for a slot.</p>', 'CreateSlotTypeResponse$slotTypeValues' => '<p>The list of values that the slot type can assume.</p>', 'DescribeSlotTypeResponse$slotTypeValues' => '<p>The values that the slot type can take. Includes any synonyms for the slot type values.</p>', 'UpdateSlotTypeRequest$slotTypeValues' => '<p>A new list of values and their optional synonyms that define the values that the slot type can take.</p>', 'UpdateSlotTypeResponse$slotTypeValues' => '<p>The updated values that the slot type provides.</p>', ], ], 'SlotValueElicitationSetting' => [ 'base' => '<p>Settings that you can use for eliciting a slot value.</p>', 'refs' => [ 'CreateSlotRequest$valueElicitationSetting' => '<p>Specifies prompts that Amazon Lex sends to the user to elicit a response that provides the value for the slot. </p>', 'CreateSlotResponse$valueElicitationSetting' => '<p>The value elicitation settings specified for the slot.</p>', 'DescribeSlotResponse$valueElicitationSetting' => '<p>Prompts that Amazon Lex uses to elicit a value for the slot.</p>', 'UpdateSlotRequest$valueElicitationSetting' => '<p>A new set of prompts that Amazon Lex sends to the user to elicit a response the provides a value for the slot.</p>', 'UpdateSlotResponse$valueElicitationSetting' => '<p>The updated prompts that Amazon Lex sends to the user to elicit a response that provides a value for the slot.</p>', ], ], 'SlotValueRegexFilter' => [ 'base' => '<p>Provides a regular expression used to validate the value of a slot.</p>', 'refs' => [ 'SlotValueSelectionSetting$regexFilter' => '<p>A regular expression used to validate the value of a slot.</p>', ], ], 'SlotValueResolutionStrategy' => [ 'base' => NULL, 'refs' => [ 'SlotValueSelectionSetting$resolutionStrategy' => '<p>Determines the slot resolution strategy that Amazon Lex uses to return slot type values. The field can be set to one of the following values:</p> <ul> <li> <p>OriginalValue - Returns the value entered by the user, if the user value is similar to the slot value.</p> </li> <li> <p>TopResolution - If there is a resolution list for the slot, return the first value in the resolution list as the slot type value. If there is no resolution list, null is returned.</p> </li> </ul> <p>If you don\'t specify the valueSelectionStrategy, the default is OriginalValue. </p>', ], ], 'SlotValueSelectionSetting' => [ 'base' => '<p>Contains settings used by Amazon Lex to select a slot value.</p>', 'refs' => [ 'CreateSlotTypeRequest$valueSelectionSetting' => '<p>Determines the strategy that Amazon Lex uses to select a value from the list of possible values. The field can be set to one of the following values:</p> <ul> <li> <p> <code>OriginalValue</code> - Returns the value entered by the user, if the user value is similar to the slot value.</p> </li> <li> <p> <code>TopResolution</code> - If there is a resolution list for the slot, return the first value in the resolution list. If there is no resolution list, return null.</p> </li> </ul> <p>If you don\'t specify the <code>valueSelectionSetting</code> parameter, the default is <code>OriginalValue</code>.</p>', 'CreateSlotTypeResponse$valueSelectionSetting' => '<p>The strategy that Amazon Lex uses to select a value from the list of possible values.</p>', 'DescribeSlotTypeResponse$valueSelectionSetting' => '<p>The strategy that Amazon Lex uses to choose a value from a list of possible values.</p>', 'UpdateSlotTypeRequest$valueSelectionSetting' => '<p>The strategy that Amazon Lex should use when deciding on a value from the list of slot type values.</p>', 'UpdateSlotTypeResponse$valueSelectionSetting' => '<p>The updated strategy that Amazon Lex uses to determine which value to select from the slot type.</p>', ], ], 'SortOrder' => [ 'base' => NULL, 'refs' => [ 'AggregatedUtterancesSortBy$order' => '<p>Specifies whether to sort the aggregated utterances in ascending or descending order.</p>', 'BotLocaleSortBy$order' => '<p>Specifies whether to sort the bot locales in ascending or descending order.</p>', 'BotSortBy$order' => '<p>The order to sort the list. You can choose ascending or descending.</p>', 'BotVersionSortBy$order' => '<p>The order to sort the list. You can specify ascending or descending order.</p>', 'BuiltInIntentSortBy$order' => '<p>The order to sort the list. You can specify ascending or descending order.</p>', 'BuiltInSlotTypeSortBy$order' => '<p>The order to sort the list. You can choose ascending or descending.</p>', 'ExportSortBy$order' => '<p>The order to sort the list.</p>', 'ImportSortBy$order' => '<p>The order to sort the list.</p>', 'IntentSortBy$order' => '<p>The order to sort the list. You can choose ascending or descending.</p>', 'SlotSortBy$order' => '<p>The order to sort the list. You can choose ascending or descending.</p>', 'SlotTypeSortBy$order' => '<p>The order to sort the list. You can say ascending or descending.</p>', ], ], 'StartBotRecommendationRequest' => [ 'base' => NULL, 'refs' => [], ], 'StartBotRecommendationResponse' => [ 'base' => NULL, 'refs' => [], ], 'StartImportRequest' => [ 'base' => NULL, 'refs' => [], ], 'StartImportResponse' => [ 'base' => NULL, 'refs' => [], ], 'StillWaitingResponseFrequency' => [ 'base' => NULL, 'refs' => [ 'StillWaitingResponseSpecification$frequencyInSeconds' => '<p>How often a message should be sent to the user. Minimum of 1 second, maximum of 5 minutes.</p>', ], ], 'StillWaitingResponseSpecification' => [ 'base' => '<p>Defines the messages that Amazon Lex sends to a user to remind them that the bot is waiting for a response.</p>', 'refs' => [ 'WaitAndContinueSpecification$stillWaitingResponse' => '<p>A response that Amazon Lex sends periodically to the user to indicate that the bot is still waiting for input from the user.</p>', ], ], 'StillWaitingResponseTimeout' => [ 'base' => NULL, 'refs' => [ 'StillWaitingResponseSpecification$timeoutInSeconds' => '<p>If Amazon Lex waits longer than this length of time for a response, it will stop sending messages.</p>', ], ], 'SynonymList' => [ 'base' => NULL, 'refs' => [ 'SlotTypeValue$synonyms' => '<p>Additional values related to the slot type entry.</p>', ], ], 'TagKey' => [ 'base' => NULL, 'refs' => [ 'TagKeyList$member' => NULL, 'TagMap$key' => NULL, ], ], 'TagKeyList' => [ 'base' => NULL, 'refs' => [ 'UntagResourceRequest$tagKeys' => '<p>A list of tag keys to remove from the resource. If a tag key does not exist on the resource, it is ignored.</p>', ], ], 'TagMap' => [ 'base' => NULL, 'refs' => [ 'BotImportSpecification$botTags' => '<p>A list of tags to add to the bot. You can only add tags when you import a bot. You can\'t use the <code>UpdateBot</code> operation to update tags. To update tags, use the <code>TagResource</code> operation.</p>', 'BotImportSpecification$testBotAliasTags' => '<p>A list of tags to add to the test alias for a bot. You can only add tags when you import a bot. You can\'t use the <code>UpdateAlias</code> operation to update tags. To update tags on the test alias, use the <code>TagResource</code> operation.</p>', 'CreateBotAliasRequest$tags' => '<p>A list of tags to add to the bot alias. You can only add tags when you create an alias, you can\'t use the <code>UpdateBotAlias</code> operation to update the tags on a bot alias. To update tags, use the <code>TagResource</code> operation.</p>', 'CreateBotAliasResponse$tags' => '<p>A list of tags associated with the bot alias.</p>', 'CreateBotRequest$botTags' => '<p>A list of tags to add to the bot. You can only add tags when you create a bot. You can\'t use the <code>UpdateBot</code> operation to update tags. To update tags, use the <code>TagResource</code> operation.</p>', 'CreateBotRequest$testBotAliasTags' => '<p>A list of tags to add to the test alias for a bot. You can only add tags when you create a bot. You can\'t use the <code>UpdateAlias</code> operation to update tags. To update tags on the test alias, use the <code>TagResource</code> operation.</p>', 'CreateBotResponse$botTags' => '<p>A list of tags associated with the bot.</p>', 'CreateBotResponse$testBotAliasTags' => '<p>A list of tags associated with the test alias for the bot.</p>', 'ListTagsForResourceResponse$tags' => '<p>The tags associated with a resource.</p>', 'TagResourceRequest$tags' => '<p>A list of tag keys to add to the resource. If a tag key already exists, the existing value is replaced with the new value.</p>', ], ], 'TagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'TagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'TagValue' => [ 'base' => NULL, 'refs' => [ 'TagMap$value' => NULL, ], ], 'TextLogDestination' => [ 'base' => '<p>Defines the Amazon CloudWatch Logs destination log group for conversation text logs.</p>', 'refs' => [ 'TextLogSetting$destination' => NULL, ], ], 'TextLogSetting' => [ 'base' => '<p>Defines settings to enable text conversation logs.</p>', 'refs' => [ 'TextLogSettingsList$member' => NULL, ], ], 'TextLogSettingsList' => [ 'base' => NULL, 'refs' => [ 'ConversationLogSettings$textLogSettings' => '<p>The Amazon CloudWatch Logs settings for logging text and metadata.</p>', ], ], 'ThrottlingException' => [ 'base' => '<p>Your request rate is too high. Reduce the frequency of requests.</p>', 'refs' => [], ], 'TimeDimension' => [ 'base' => NULL, 'refs' => [ 'RelativeAggregationDuration$timeDimension' => '<p>The type of time period that the <code>timeValue</code> field represents. </p>', ], ], 'TimeValue' => [ 'base' => NULL, 'refs' => [ 'RelativeAggregationDuration$timeValue' => '<p>The period of the time window to gather statistics for. The valid value depends on the setting of the <code>timeDimension</code> field.</p> <ul> <li> <p> <code>Hours</code> - 1/3/6/12/24</p> </li> <li> <p> <code>Days</code> - 3</p> </li> <li> <p> <code>Weeks</code> - 1/2</p> </li> </ul>', ], ], 'Timestamp' => [ 'base' => NULL, 'refs' => [ 'AggregatedUtterancesSummary$utteranceFirstRecordedInAggregationDuration' => '<p>The date and time that the utterance was first recorded in the time window for aggregation. An utterance may have been sent to Amazon Lex before that time, but only utterances within the time window are counted.</p>', 'AggregatedUtterancesSummary$utteranceLastRecordedInAggregationDuration' => '<p>The last date and time that an utterance was recorded in the time window for aggregation. An utterance may be sent to Amazon Lex after that time, but only utterances within the time window are counted.</p>', 'BotAliasHistoryEvent$startDate' => '<p>The date and time that the event started.</p>', 'BotAliasHistoryEvent$endDate' => '<p>The date and time that the event ended.</p>', 'BotAliasSummary$creationDateTime' => '<p>A timestamp of the date and time that the bot alias was created.</p>', 'BotAliasSummary$lastUpdatedDateTime' => '<p>A timestamp of the date and time that the bot alias was last updated.</p>', 'BotLocaleHistoryEvent$eventDate' => '<p>A timestamp of the date and time that the event occurred.</p>', 'BotLocaleSummary$lastUpdatedDateTime' => '<p>A timestamp of the date and time that the bot locale was last updated.</p>', 'BotLocaleSummary$lastBuildSubmittedDateTime' => '<p>A timestamp of the date and time that the bot locale was last built.</p>', 'BotRecommendationSummary$creationDateTime' => '<p>A timestamp of the date and time that the bot recommendation was created.</p>', 'BotRecommendationSummary$lastUpdatedDateTime' => '<p>A timestamp of the date and time that the bot recommendation was last updated.</p>', 'BotSummary$lastUpdatedDateTime' => '<p>The date and time that the bot was last updated.</p>', 'BotVersionSummary$creationDateTime' => '<p>A timestamp of the date and time that the version was created.</p>', 'BuildBotLocaleResponse$lastBuildSubmittedDateTime' => '<p>A timestamp indicating the date and time that the bot was last built for this locale.</p>', 'CreateBotAliasResponse$creationDateTime' => '<p>A Unix timestamp indicating the date and time that the bot alias was created.</p>', 'CreateBotLocaleResponse$creationDateTime' => '<p>A timestamp specifying the date and time that the bot locale was created.</p>', 'CreateBotResponse$creationDateTime' => '<p>A timestamp indicating the date and time that the bot was created.</p>', 'CreateBotVersionResponse$creationDateTime' => '<p>A timestamp of the date and time that the version was created.</p>', 'CreateExportResponse$creationDateTime' => '<p>The date and time that the request to export a bot was created.</p>', 'CreateIntentResponse$creationDateTime' => '<p>A timestamp of the date and time that the intent was created.</p>', 'CreateSlotResponse$creationDateTime' => '<p>The timestamp of the date and time that the slot was created.</p>', 'CreateSlotTypeResponse$creationDateTime' => '<p>A timestamp of the date and time that the slot type was created.</p>', 'DateRangeFilter$startDateTime' => '<p>A timestamp indicating the start date for the date range filter.</p>', 'DateRangeFilter$endDateTime' => '<p>A timestamp indicating the end date for the date range filter.</p>', 'DescribeBotAliasResponse$creationDateTime' => '<p>A timestamp of the date and time that the alias was created.</p>', 'DescribeBotAliasResponse$lastUpdatedDateTime' => '<p>A timestamp of the date and time that the alias was last updated.</p>', 'DescribeBotLocaleResponse$creationDateTime' => '<p>The date and time that the locale was created.</p>', 'DescribeBotLocaleResponse$lastUpdatedDateTime' => '<p>The date and time that the locale was last updated.</p>', 'DescribeBotLocaleResponse$lastBuildSubmittedDateTime' => '<p>The date and time that the locale was last submitted for building.</p>', 'DescribeBotRecommendationResponse$creationDateTime' => '<p>The date and time that the bot recommendation was created.</p>', 'DescribeBotRecommendationResponse$lastUpdatedDateTime' => '<p>The date and time that the bot recommendation was last updated.</p>', 'DescribeBotResponse$creationDateTime' => '<p>A timestamp of the date and time that the bot was created.</p>', 'DescribeBotResponse$lastUpdatedDateTime' => '<p>A timestamp of the date and time that the bot was last updated.</p>', 'DescribeBotVersionResponse$creationDateTime' => '<p>A timestamp of the date and time that the bot version was created.</p>', 'DescribeCustomVocabularyMetadataResponse$creationDateTime' => '<p>The date and time that the custom vocabulary was created.</p>', 'DescribeCustomVocabularyMetadataResponse$lastUpdatedDateTime' => '<p>The date and time that the custom vocabulary was last updated.</p>', 'DescribeExportResponse$creationDateTime' => '<p>The date and time that the export was created.</p>', 'DescribeExportResponse$lastUpdatedDateTime' => '<p>The last date and time that the export was updated.</p>', 'DescribeImportResponse$creationDateTime' => '<p>The date and time that the import was created.</p>', 'DescribeImportResponse$lastUpdatedDateTime' => '<p>The date and time that the import was last updated.</p>', 'DescribeIntentResponse$creationDateTime' => '<p>A timestamp of the date and time that the intent was created.</p>', 'DescribeIntentResponse$lastUpdatedDateTime' => '<p>A timestamp of the date and time that the intent was last updated.</p>', 'DescribeSlotResponse$creationDateTime' => '<p>A timestamp of the date and time that the slot was created.</p>', 'DescribeSlotResponse$lastUpdatedDateTime' => '<p>A timestamp of the date and time that the slot was last updated.</p>', 'DescribeSlotTypeResponse$creationDateTime' => '<p>A timestamp of the date and time that the slot type was created.</p>', 'DescribeSlotTypeResponse$lastUpdatedDateTime' => '<p>A timestamp of the date and time that the slot type was last updated.</p>', 'ExportSummary$creationDateTime' => '<p>The date and time that the export was created.</p>', 'ExportSummary$lastUpdatedDateTime' => '<p>The date and time that the export was last updated.</p>', 'ImportSummary$creationDateTime' => '<p>The date and time that the import was created.</p>', 'ImportSummary$lastUpdatedDateTime' => '<p>The date and time that the import was last updated.</p>', 'IntentSummary$lastUpdatedDateTime' => '<p>The timestamp of the date and time that the intent was last updated.</p>', 'ListAggregatedUtterancesResponse$aggregationWindowStartTime' => '<p>The date and time that the aggregation window begins. Only data collected after this time is returned in the results.</p>', 'ListAggregatedUtterancesResponse$aggregationWindowEndTime' => '<p>The date and time that the aggregation window ends. Only data collected between the start time and the end time are returned in the results. </p>', 'ListAggregatedUtterancesResponse$aggregationLastRefreshedDateTime' => '<p>The last date and time that the aggregated data was collected. The time period depends on the length of the aggregation window.</p> <ul> <li> <p> <b>Hours</b> - for 1 hour time window, every half hour; otherwise every hour.</p> </li> <li> <p> <b>Days</b> - every 6 hours</p> </li> <li> <p> <b>Weeks</b> - for a one week time window, every 12 hours; otherwise, every day</p> </li> </ul>', 'SlotSummary$lastUpdatedDateTime' => '<p>The timestamp of the last date and time that the slot was updated.</p>', 'SlotTypeSummary$lastUpdatedDateTime' => '<p>A timestamp of the date and time that the slot type was last updated.</p>', 'StartBotRecommendationResponse$creationDateTime' => '<p>A timestamp of the date and time that the bot recommendation was created.</p>', 'StartImportResponse$creationDateTime' => '<p>The date and time that the import request was created.</p>', 'UpdateBotAliasResponse$creationDateTime' => '<p>A timestamp of the date and time that the bot was created.</p>', 'UpdateBotAliasResponse$lastUpdatedDateTime' => '<p>A timestamp of the date and time that the bot was last updated.</p>', 'UpdateBotLocaleResponse$creationDateTime' => '<p>A timestamp of the date and time that the locale was created.</p>', 'UpdateBotLocaleResponse$lastUpdatedDateTime' => '<p>A timestamp of the date and time that the locale was last updated.</p>', 'UpdateBotRecommendationResponse$creationDateTime' => '<p>A timestamp of the date and time that the bot recommendation was created.</p>', 'UpdateBotRecommendationResponse$lastUpdatedDateTime' => '<p>A timestamp of the date and time that the bot recommendation was last updated.</p>', 'UpdateBotResponse$creationDateTime' => '<p>A timestamp of the date and time that the bot was created.</p>', 'UpdateBotResponse$lastUpdatedDateTime' => '<p>A timestamp of the date and time that the bot was last updated.</p>', 'UpdateExportResponse$creationDateTime' => '<p>The date and time that the export was created.</p>', 'UpdateExportResponse$lastUpdatedDateTime' => '<p>The date and time that the export was last updated.</p>', 'UpdateIntentResponse$creationDateTime' => '<p>A timestamp of when the intent was created.</p>', 'UpdateIntentResponse$lastUpdatedDateTime' => '<p>A timestamp of the last time that the intent was modified.</p>', 'UpdateSlotResponse$creationDateTime' => '<p>The timestamp of the date and time that the slot was created.</p>', 'UpdateSlotResponse$lastUpdatedDateTime' => '<p>The timestamp of the date and time that the slot was last updated.</p>', 'UpdateSlotTypeResponse$creationDateTime' => '<p>The timestamp of the date and time that the slot type was created.</p>', 'UpdateSlotTypeResponse$lastUpdatedDateTime' => '<p>A timestamp of the date and time that the slot type was last updated.</p>', ], ], 'Transcript' => [ 'base' => NULL, 'refs' => [ 'AssociatedTranscript$transcript' => '<p>The content of the transcript that meets the search filter criteria. For the JSON format of the transcript, see <a href="https://docs.aws.amazon.com/lex/latest/dg/designing-output-format.html">Output transcript format</a>.</p>', ], ], 'TranscriptFilter' => [ 'base' => '<p>The object representing the filter that Amazon Lex will use to select the appropriate transcript.</p>', 'refs' => [ 'S3BucketTranscriptSource$transcriptFilter' => '<p>The object that contains the filter which will be applied when Amazon Lex reads through the Amazon S3 bucket. Specify this object if you want Amazon Lex to read only a subset of the Amazon S3 bucket based on the filter you provide.</p>', ], ], 'TranscriptFormat' => [ 'base' => NULL, 'refs' => [ 'S3BucketTranscriptSource$transcriptFormat' => '<p>The format of the transcript content. Currently, Genie only supports the Amazon Lex transcript format.</p>', ], ], 'TranscriptSourceSetting' => [ 'base' => '<p>Indicates the setting of the location where the transcript is stored.</p>', 'refs' => [ 'DescribeBotRecommendationResponse$transcriptSourceSetting' => '<p>The object representing the Amazon S3 bucket containing the transcript, as well as the associated metadata.</p>', 'StartBotRecommendationRequest$transcriptSourceSetting' => '<p>The object representing the Amazon S3 bucket containing the transcript, as well as the associated metadata.</p>', 'StartBotRecommendationResponse$transcriptSourceSetting' => '<p>The object representing the Amazon S3 bucket containing the transcript, as well as the associated metadata.</p>', 'UpdateBotRecommendationResponse$transcriptSourceSetting' => '<p>The object representing the Amazon S3 bucket containing the transcript, as well as the associated metadata.</p>', ], ], 'UntagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'UntagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateBotAliasRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateBotAliasResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateBotLocaleRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateBotLocaleResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateBotRecommendationRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateBotRecommendationResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateBotRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateBotResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateExportRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateExportResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateIntentRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateIntentResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateResourcePolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateResourcePolicyResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateSlotRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateSlotResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateSlotTypeRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateSlotTypeResponse' => [ 'base' => NULL, 'refs' => [], ], 'Utterance' => [ 'base' => NULL, 'refs' => [ 'AggregatedUtterancesSummary$utterance' => '<p>The text of the utterance. If the utterance was used with the <code>RecognizeUtterance</code> operation, the text is the transcription of the audio utterance.</p>', 'SampleUtterance$utterance' => '<p>The sample utterance that Amazon Lex uses to build its machine-learning model to recognize intents.</p>', ], ], 'UtteranceAggregationDuration' => [ 'base' => '<p>Provides parameters for setting the time window and duration for aggregating utterance data.</p>', 'refs' => [ 'ListAggregatedUtterancesRequest$aggregationDuration' => '<p>The time window for aggregating the utterance information. You can specify a time between one hour and two weeks.</p>', 'ListAggregatedUtterancesResponse$aggregationDuration' => '<p>The time period used to aggregate the utterance data.</p>', ], ], 'ValidationException' => [ 'base' => '<p>One of the input parameters in your request isn\'t valid. Check the parameters and try your request again.</p>', 'refs' => [], ], 'Value' => [ 'base' => NULL, 'refs' => [ 'SampleValue$value' => '<p>The value that can be used for a slot type.</p>', ], ], 'VoiceEngine' => [ 'base' => NULL, 'refs' => [ 'VoiceSettings$engine' => '<p>Indicates the type of Amazon Polly voice that Amazon Lex should use for voice interaction with the user. For more information, see the <a href="https://docs.aws.amazon.com/polly/latest/dg/API_SynthesizeSpeech.html#polly-SynthesizeSpeech-request-Engine"> <code>engine</code> parameter of the <code>SynthesizeSpeech</code> operation</a> in the <i>Amazon Polly developer guide</i>.</p> <p>If you do not specify a value, the default is <code>standard</code>.</p>', ], ], 'VoiceId' => [ 'base' => NULL, 'refs' => [ 'VoiceSettings$voiceId' => '<p>The identifier of the Amazon Polly voice to use.</p>', ], ], 'VoiceSettings' => [ 'base' => '<p>Defines settings for using an Amazon Polly voice to communicate with a user.</p>', 'refs' => [ 'BotLocaleImportSpecification$voiceSettings' => NULL, 'CreateBotLocaleRequest$voiceSettings' => '<p>The Amazon Polly voice ID that Amazon Lex uses for voice interaction with the user.</p>', 'CreateBotLocaleResponse$voiceSettings' => '<p>The Amazon Polly voice ID that Amazon Lex uses for voice interaction with the user.</p>', 'DescribeBotLocaleResponse$voiceSettings' => '<p>The Amazon Polly voice Amazon Lex uses for voice interaction with the user.</p>', 'UpdateBotLocaleRequest$voiceSettings' => '<p>The new Amazon Polly voice Amazon Lex should use for voice interaction with the user.</p>', 'UpdateBotLocaleResponse$voiceSettings' => '<p>The updated Amazon Polly voice to use for voice interaction with the user.</p>', ], ], 'WaitAndContinueSpecification' => [ 'base' => '<p>Specifies the prompts that Amazon Lex uses while a bot is waiting for customer input. </p>', 'refs' => [ 'SlotValueElicitationSetting$waitAndContinueSpecification' => NULL, ], ], ],];
