<?php
// This file was auto-generated from sdk-root/src/data/mediastore/2017-09-01/docs-2.json
return [ 'version' => '2.0', 'service' => '<p>An AWS Elemental MediaStore container is a namespace that holds folders and objects. You use a container endpoint to create, read, and delete objects. </p>', 'operations' => [ 'CreateContainer' => '<p>Creates a storage container to hold objects. A container is similar to a bucket in the Amazon S3 service.</p>', 'DeleteContainer' => '<p>Deletes the specified container. Before you make a <code>DeleteContainer</code> request, delete any objects in the container or in any folders in the container. You can delete only empty containers. </p>', 'DeleteContainerPolicy' => '<p>Deletes the access policy that is associated with the specified container.</p>', 'DeleteCorsPolicy' => '<p>Deletes the cross-origin resource sharing (CORS) configuration information that is set for the container.</p> <p>To use this operation, you must have permission to perform the <code>MediaStore:DeleteCorsPolicy</code> action. The container owner has this permission by default and can grant this permission to others.</p>', 'DeleteLifecyclePolicy' => '<p>Removes an object lifecycle policy from a container. It takes up to 20 minutes for the change to take effect.</p>', 'DeleteMetricPolicy' => '<p>Deletes the metric policy that is associated with the specified container. If there is no metric policy associated with the container, MediaStore doesn\'t send metrics to CloudWatch.</p>', 'DescribeContainer' => '<p>Retrieves the properties of the requested container. This request is commonly used to retrieve the endpoint of a container. An endpoint is a value assigned by the service when a new container is created. A container\'s endpoint does not change after it has been assigned. The <code>DescribeContainer</code> request returns a single <code>Container</code> object based on <code>ContainerName</code>. To return all <code>Container</code> objects that are associated with a specified AWS account, use <a>ListContainers</a>.</p>', 'GetContainerPolicy' => '<p>Retrieves the access policy for the specified container. For information about the data that is included in an access policy, see the <a href="https://aws.amazon.com/documentation/iam/">AWS Identity and Access Management User Guide</a>.</p>', 'GetCorsPolicy' => '<p>Returns the cross-origin resource sharing (CORS) configuration information that is set for the container.</p> <p>To use this operation, you must have permission to perform the <code>MediaStore:GetCorsPolicy</code> action. By default, the container owner has this permission and can grant it to others.</p>', 'GetLifecyclePolicy' => '<p>Retrieves the object lifecycle policy that is assigned to a container.</p>', 'GetMetricPolicy' => '<p>Returns the metric policy for the specified container. </p>', 'ListContainers' => '<p>Lists the properties of all containers in AWS Elemental MediaStore. </p> <p>You can query to receive all the containers in one response. Or you can include the <code>MaxResults</code> parameter to receive a limited number of containers in each response. In this case, the response includes a token. To get the next set of containers, send the command again, this time with the <code>NextToken</code> parameter (with the returned token as its value). The next set of responses appears, with a token if there are still more containers to receive. </p> <p>See also <a>DescribeContainer</a>, which gets the properties of one container. </p>', 'ListTagsForResource' => '<p>Returns a list of the tags assigned to the specified container. </p>', 'PutContainerPolicy' => '<p>Creates an access policy for the specified container to restrict the users and clients that can access it. For information about the data that is included in an access policy, see the <a href="https://aws.amazon.com/documentation/iam/">AWS Identity and Access Management User Guide</a>.</p> <p>For this release of the REST API, you can create only one policy for a container. If you enter <code>PutContainerPolicy</code> twice, the second command modifies the existing policy. </p>', 'PutCorsPolicy' => '<p>Sets the cross-origin resource sharing (CORS) configuration on a container so that the container can service cross-origin requests. For example, you might want to enable a request whose origin is http://www.example.com to access your AWS Elemental MediaStore container at my.example.container.com by using the browser\'s XMLHttpRequest capability.</p> <p>To enable CORS on a container, you attach a CORS policy to the container. In the CORS policy, you configure rules that identify origins and the HTTP methods that can be executed on your container. The policy can contain up to 398,000 characters. You can add up to 100 rules to a CORS policy. If more than one rule applies, the service uses the first applicable rule listed.</p> <p>To learn more about CORS, see <a href="https://docs.aws.amazon.com/mediastore/latest/ug/cors-policy.html">Cross-Origin Resource Sharing (CORS) in AWS Elemental MediaStore</a>.</p>', 'PutLifecyclePolicy' => '<p>Writes an object lifecycle policy to a container. If the container already has an object lifecycle policy, the service replaces the existing policy with the new policy. It takes up to 20 minutes for the change to take effect.</p> <p>For information about how to construct an object lifecycle policy, see <a href="https://docs.aws.amazon.com/mediastore/latest/ug/policies-object-lifecycle-components.html">Components of an Object Lifecycle Policy</a>.</p>', 'PutMetricPolicy' => '<p>The metric policy that you want to add to the container. A metric policy allows AWS Elemental MediaStore to send metrics to Amazon CloudWatch. It takes up to 20 minutes for the new policy to take effect.</p>', 'StartAccessLogging' => '<p>Starts access logging on the specified container. When you enable access logging on a container, MediaStore delivers access logs for objects stored in that container to Amazon CloudWatch Logs.</p>', 'StopAccessLogging' => '<p>Stops access logging on the specified container. When you stop access logging on a container, MediaStore stops sending access logs to Amazon CloudWatch Logs. These access logs are not saved and are not retrievable.</p>', 'TagResource' => '<p>Adds tags to the specified AWS Elemental MediaStore container. Tags are key:value pairs that you can associate with AWS resources. For example, the tag key might be "customer" and the tag value might be "companyA." You can specify one or more tags to add to each container. You can add up to 50 tags to each container. For more information about tagging, including naming and usage conventions, see <a href="https://docs.aws.amazon.com/mediastore/latest/ug/tagging.html">Tagging Resources in MediaStore</a>.</p>', 'UntagResource' => '<p>Removes tags from the specified container. You can specify one or more tags to remove. </p>', ], 'shapes' => [ 'AllowedHeaders' => [ 'base' => NULL, 'refs' => [ 'CorsRule$AllowedHeaders' => '<p>Specifies which headers are allowed in a preflight <code>OPTIONS</code> request through the <code>Access-Control-Request-Headers</code> header. Each header name that is specified in <code>Access-Control-Request-Headers</code> must have a corresponding entry in the rule. Only the headers that were requested are sent back. </p> <p>This element can contain only one wildcard character (*).</p>', ], ], 'AllowedMethods' => [ 'base' => NULL, 'refs' => [ 'CorsRule$AllowedMethods' => '<p>Identifies an HTTP method that the origin that is specified in the rule is allowed to execute.</p> <p>Each CORS rule must contain at least one <code>AllowedMethods</code> and one <code>AllowedOrigins</code> element.</p>', ], ], 'AllowedOrigins' => [ 'base' => NULL, 'refs' => [ 'CorsRule$AllowedOrigins' => '<p>One or more response headers that you want users to be able to access from their applications (for example, from a JavaScript <code>XMLHttpRequest</code> object).</p> <p>Each CORS rule must have at least one <code>AllowedOrigins</code> element. The string value can include only one wildcard character (*), for example, http://*.example.com. Additionally, you can specify only one wildcard character to allow cross-origin access for all origins.</p>', ], ], 'Container' => [ 'base' => '<p>This section describes operations that you can perform on an AWS Elemental MediaStore container.</p>', 'refs' => [ 'ContainerList$member' => NULL, 'CreateContainerOutput$Container' => '<p>ContainerARN: The Amazon Resource Name (ARN) of the newly created container. The ARN has the following format: arn:aws:&lt;region&gt;:&lt;account that owns this container&gt;:container/&lt;name of container&gt;. For example: arn:aws:mediastore:us-west-2:111122223333:container/movies </p> <p>ContainerName: The container name as specified in the request.</p> <p>CreationTime: Unix time stamp.</p> <p>Status: The status of container creation or deletion. The status is one of the following: <code>CREATING</code>, <code>ACTIVE</code>, or <code>DELETING</code>. While the service is creating the container, the status is <code>CREATING</code>. When an endpoint is available, the status changes to <code>ACTIVE</code>.</p> <p>The return value does not include the container\'s endpoint. To make downstream requests, you must obtain this value by using <a>DescribeContainer</a> or <a>ListContainers</a>.</p>', 'DescribeContainerOutput$Container' => '<p>The name of the queried container.</p>', ], ], 'ContainerARN' => [ 'base' => NULL, 'refs' => [ 'Container$ARN' => '<p>The Amazon Resource Name (ARN) of the container. The ARN has the following format:</p> <p>arn:aws:&lt;region&gt;:&lt;account that owns this container&gt;:container/&lt;name of container&gt; </p> <p>For example: arn:aws:mediastore:us-west-2:111122223333:container/movies </p>', 'ListTagsForResourceInput$Resource' => '<p>The Amazon Resource Name (ARN) for the container.</p>', 'TagResourceInput$Resource' => '<p>The Amazon Resource Name (ARN) for the container. </p>', 'UntagResourceInput$Resource' => '<p>The Amazon Resource Name (ARN) for the container.</p>', ], ], 'ContainerAccessLoggingEnabled' => [ 'base' => NULL, 'refs' => [ 'Container$AccessLoggingEnabled' => '<p>The state of access logging on the container. This value is <code>false</code> by default, indicating that AWS Elemental MediaStore does not send access logs to Amazon CloudWatch Logs. When you enable access logging on the container, MediaStore changes this value to <code>true</code>, indicating that the service delivers access logs for objects stored in that container to CloudWatch Logs.</p>', ], ], 'ContainerInUseException' => [ 'base' => '<p>The container that you specified in the request already exists or is being updated.</p>', 'refs' => [], ], 'ContainerLevelMetrics' => [ 'base' => NULL, 'refs' => [ 'MetricPolicy$ContainerLevelMetrics' => '<p>A setting to enable or disable metrics at the container level.</p>', ], ], 'ContainerList' => [ 'base' => NULL, 'refs' => [ 'ListContainersOutput$Containers' => '<p>The names of the containers.</p>', ], ], 'ContainerListLimit' => [ 'base' => NULL, 'refs' => [ 'ListContainersInput$MaxResults' => '<p>Enter the maximum number of containers in the response. Use from 1 to 255 characters. </p>', ], ], 'ContainerName' => [ 'base' => NULL, 'refs' => [ 'Container$Name' => '<p>The name of the container.</p>', 'CreateContainerInput$ContainerName' => '<p>The name for the container. The name must be from 1 to 255 characters. Container names must be unique to your AWS account within a specific region. As an example, you could create a container named <code>movies</code> in every region, as long as you don’t have an existing container with that name.</p>', 'DeleteContainerInput$ContainerName' => '<p>The name of the container to delete. </p>', 'DeleteContainerPolicyInput$ContainerName' => '<p>The name of the container that holds the policy.</p>', 'DeleteCorsPolicyInput$ContainerName' => '<p>The name of the container to remove the policy from.</p>', 'DeleteLifecyclePolicyInput$ContainerName' => '<p>The name of the container that holds the object lifecycle policy.</p>', 'DeleteMetricPolicyInput$ContainerName' => '<p>The name of the container that is associated with the metric policy that you want to delete.</p>', 'DescribeContainerInput$ContainerName' => '<p>The name of the container to query.</p>', 'GetContainerPolicyInput$ContainerName' => '<p>The name of the container. </p>', 'GetCorsPolicyInput$ContainerName' => '<p>The name of the container that the policy is assigned to.</p>', 'GetLifecyclePolicyInput$ContainerName' => '<p>The name of the container that the object lifecycle policy is assigned to.</p>', 'GetMetricPolicyInput$ContainerName' => '<p>The name of the container that is associated with the metric policy.</p>', 'PutContainerPolicyInput$ContainerName' => '<p>The name of the container.</p>', 'PutCorsPolicyInput$ContainerName' => '<p>The name of the container that you want to assign the CORS policy to.</p>', 'PutLifecyclePolicyInput$ContainerName' => '<p>The name of the container that you want to assign the object lifecycle policy to.</p>', 'PutMetricPolicyInput$ContainerName' => '<p>The name of the container that you want to add the metric policy to.</p>', 'StartAccessLoggingInput$ContainerName' => '<p>The name of the container that you want to start access logging on.</p>', 'StopAccessLoggingInput$ContainerName' => '<p>The name of the container that you want to stop access logging on.</p>', ], ], 'ContainerNotFoundException' => [ 'base' => '<p>The container that you specified in the request does not exist.</p>', 'refs' => [], ], 'ContainerPolicy' => [ 'base' => NULL, 'refs' => [ 'GetContainerPolicyOutput$Policy' => '<p>The contents of the access policy.</p>', 'PutContainerPolicyInput$Policy' => '<p>The contents of the policy, which includes the following: </p> <ul> <li> <p>One <code>Version</code> tag</p> </li> <li> <p>One <code>Statement</code> tag that contains the standard tags for the policy.</p> </li> </ul>', ], ], 'ContainerStatus' => [ 'base' => NULL, 'refs' => [ 'Container$Status' => '<p>The status of container creation or deletion. The status is one of the following: <code>CREATING</code>, <code>ACTIVE</code>, or <code>DELETING</code>. While the service is creating the container, the status is <code>CREATING</code>. When the endpoint is available, the status changes to <code>ACTIVE</code>.</p>', ], ], 'CorsPolicy' => [ 'base' => '<p>The CORS policy of the container. </p>', 'refs' => [ 'GetCorsPolicyOutput$CorsPolicy' => '<p>The CORS policy assigned to the container.</p>', 'PutCorsPolicyInput$CorsPolicy' => '<p>The CORS policy to apply to the container. </p>', ], ], 'CorsPolicyNotFoundException' => [ 'base' => '<p>The CORS policy that you specified in the request does not exist.</p>', 'refs' => [], ], 'CorsRule' => [ 'base' => '<p>A rule for a CORS policy. You can add up to 100 rules to a CORS policy. If more than one rule applies, the service uses the first applicable rule listed.</p>', 'refs' => [ 'CorsPolicy$member' => NULL, ], ], 'CreateContainerInput' => [ 'base' => NULL, 'refs' => [], ], 'CreateContainerOutput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteContainerInput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteContainerOutput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteContainerPolicyInput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteContainerPolicyOutput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteCorsPolicyInput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteCorsPolicyOutput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteLifecyclePolicyInput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteLifecyclePolicyOutput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteMetricPolicyInput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteMetricPolicyOutput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeContainerInput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeContainerOutput' => [ 'base' => NULL, 'refs' => [], ], 'Endpoint' => [ 'base' => NULL, 'refs' => [ 'Container$Endpoint' => '<p>The DNS endpoint of the container. Use the endpoint to identify the specific container when sending requests to the data plane. The service assigns this value when the container is created. Once the value has been assigned, it does not change.</p>', ], ], 'ErrorMessage' => [ 'base' => NULL, 'refs' => [ 'ContainerInUseException$Message' => NULL, 'ContainerNotFoundException$Message' => NULL, 'CorsPolicyNotFoundException$Message' => NULL, 'InternalServerError$Message' => NULL, 'LimitExceededException$Message' => NULL, 'PolicyNotFoundException$Message' => NULL, ], ], 'ExposeHeaders' => [ 'base' => NULL, 'refs' => [ 'CorsRule$ExposeHeaders' => '<p>One or more headers in the response that you want users to be able to access from their applications (for example, from a JavaScript <code>XMLHttpRequest</code> object).</p> <p>This element is optional for each rule.</p>', ], ], 'GetContainerPolicyInput' => [ 'base' => NULL, 'refs' => [], ], 'GetContainerPolicyOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetCorsPolicyInput' => [ 'base' => NULL, 'refs' => [], ], 'GetCorsPolicyOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetLifecyclePolicyInput' => [ 'base' => NULL, 'refs' => [], ], 'GetLifecyclePolicyOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetMetricPolicyInput' => [ 'base' => NULL, 'refs' => [], ], 'GetMetricPolicyOutput' => [ 'base' => NULL, 'refs' => [], ], 'Header' => [ 'base' => NULL, 'refs' => [ 'AllowedHeaders$member' => NULL, 'ExposeHeaders$member' => NULL, ], ], 'InternalServerError' => [ 'base' => '<p>The service is temporarily unavailable.</p>', 'refs' => [], ], 'LifecyclePolicy' => [ 'base' => NULL, 'refs' => [ 'GetLifecyclePolicyOutput$LifecyclePolicy' => '<p>The object lifecycle policy that is assigned to the container.</p>', 'PutLifecyclePolicyInput$LifecyclePolicy' => '<p>The object lifecycle policy to apply to the container.</p>', ], ], 'LimitExceededException' => [ 'base' => '<p>A service limit has been exceeded.</p>', 'refs' => [], ], 'ListContainersInput' => [ 'base' => NULL, 'refs' => [], ], 'ListContainersOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceInput' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceOutput' => [ 'base' => NULL, 'refs' => [], ], 'MaxAgeSeconds' => [ 'base' => NULL, 'refs' => [ 'CorsRule$MaxAgeSeconds' => '<p>The time in seconds that your browser caches the preflight response for the specified resource.</p> <p>A CORS rule can have only one <code>MaxAgeSeconds</code> element.</p>', ], ], 'MethodName' => [ 'base' => NULL, 'refs' => [ 'AllowedMethods$member' => NULL, ], ], 'MetricPolicy' => [ 'base' => '<p>The metric policy that is associated with the container. A metric policy allows AWS Elemental MediaStore to send metrics to Amazon CloudWatch. In the policy, you must indicate whether you want MediaStore to send container-level metrics. You can also include rules to define groups of objects that you want MediaStore to send object-level metrics for.</p> <p>To view examples of how to construct a metric policy for your use case, see <a href="https://docs.aws.amazon.com/mediastore/latest/ug/policies-metric-examples.html">Example Metric Policies</a>.</p>', 'refs' => [ 'GetMetricPolicyOutput$MetricPolicy' => '<p>The metric policy that is associated with the specific container.</p>', 'PutMetricPolicyInput$MetricPolicy' => '<p>The metric policy that you want to associate with the container. In the policy, you must indicate whether you want MediaStore to send container-level metrics. You can also include up to five rules to define groups of objects that you want MediaStore to send object-level metrics for. If you include rules in the policy, construct each rule with both of the following:</p> <ul> <li> <p>An object group that defines which objects to include in the group. The definition can be a path or a file name, but it can\'t have more than 900 characters. Valid characters are: a-z, A-Z, 0-9, _ (underscore), = (equal), : (colon), . (period), - (hyphen), ~ (tilde), / (forward slash), and * (asterisk). Wildcards (*) are acceptable.</p> </li> <li> <p>An object group name that allows you to refer to the object group. The name can\'t have more than 30 characters. Valid characters are: a-z, A-Z, 0-9, and _ (underscore).</p> </li> </ul>', ], ], 'MetricPolicyRule' => [ 'base' => '<p>A setting that enables metrics at the object level. Each rule contains an object group and an object group name. If the policy includes the MetricPolicyRules parameter, you must include at least one rule. Each metric policy can include up to five rules by default. You can also <a href="https://console.aws.amazon.com/servicequotas/home?region=us-east-1#!/services/mediastore/quotas">request a quota increase</a> to allow up to 300 rules per policy.</p>', 'refs' => [ 'MetricPolicyRules$member' => NULL, ], ], 'MetricPolicyRules' => [ 'base' => NULL, 'refs' => [ 'MetricPolicy$MetricPolicyRules' => '<p>A parameter that holds an array of rules that enable metrics at the object level. This parameter is optional, but if you choose to include it, you must also include at least one rule. By default, you can include up to five rules. You can also <a href="https://console.aws.amazon.com/servicequotas/home?region=us-east-1#!/services/mediastore/quotas">request a quota increase</a> to allow up to 300 rules per policy.</p>', ], ], 'ObjectGroup' => [ 'base' => NULL, 'refs' => [ 'MetricPolicyRule$ObjectGroup' => '<p>A path or file name that defines which objects to include in the group. Wildcards (*) are acceptable.</p>', ], ], 'ObjectGroupName' => [ 'base' => NULL, 'refs' => [ 'MetricPolicyRule$ObjectGroupName' => '<p>A name that allows you to refer to the object group.</p>', ], ], 'Origin' => [ 'base' => NULL, 'refs' => [ 'AllowedOrigins$member' => NULL, ], ], 'PaginationToken' => [ 'base' => NULL, 'refs' => [ 'ListContainersInput$NextToken' => '<p>Only if you used <code>MaxResults</code> in the first command, enter the token (which was included in the previous response) to obtain the next set of containers. This token is included in a response only if there actually are more containers to list.</p>', 'ListContainersOutput$NextToken' => '<p> <code>NextToken</code> is the token to use in the next call to <code>ListContainers</code>. This token is returned only if you included the <code>MaxResults</code> tag in the original command, and only if there are still containers to return. </p>', ], ], 'PolicyNotFoundException' => [ 'base' => '<p>The policy that you specified in the request does not exist.</p>', 'refs' => [], ], 'PutContainerPolicyInput' => [ 'base' => NULL, 'refs' => [], ], 'PutContainerPolicyOutput' => [ 'base' => NULL, 'refs' => [], ], 'PutCorsPolicyInput' => [ 'base' => NULL, 'refs' => [], ], 'PutCorsPolicyOutput' => [ 'base' => NULL, 'refs' => [], ], 'PutLifecyclePolicyInput' => [ 'base' => NULL, 'refs' => [], ], 'PutLifecyclePolicyOutput' => [ 'base' => NULL, 'refs' => [], ], 'PutMetricPolicyInput' => [ 'base' => NULL, 'refs' => [], ], 'PutMetricPolicyOutput' => [ 'base' => NULL, 'refs' => [], ], 'StartAccessLoggingInput' => [ 'base' => NULL, 'refs' => [], ], 'StartAccessLoggingOutput' => [ 'base' => NULL, 'refs' => [], ], 'StopAccessLoggingInput' => [ 'base' => NULL, 'refs' => [], ], 'StopAccessLoggingOutput' => [ 'base' => NULL, 'refs' => [], ], 'Tag' => [ 'base' => '<p>A collection of tags associated with a container. Each tag consists of a key:value pair, which can be anything you define. Typically, the tag key represents a category (such as "environment") and the tag value represents a specific value within that category (such as "test," "development," or "production"). You can add up to 50 tags to each container. For more information about tagging, including naming and usage conventions, see <a href="https://docs.aws.amazon.com/mediastore/latest/ug/tagging.html">Tagging Resources in MediaStore</a>.</p>', 'refs' => [ 'TagList$member' => NULL, ], ], 'TagKey' => [ 'base' => NULL, 'refs' => [ 'Tag$Key' => '<p>Part of the key:value pair that defines a tag. You can use a tag key to describe a category of information, such as "customer." Tag keys are case-sensitive.</p>', 'TagKeyList$member' => NULL, ], ], 'TagKeyList' => [ 'base' => NULL, 'refs' => [ 'UntagResourceInput$TagKeys' => '<p>A comma-separated list of keys for tags that you want to remove from the container. For example, if your container has two tags (customer:CompanyA and priority:High) and you want to remove one of the tags (priority:High), you specify the key for the tag that you want to remove (priority).</p>', ], ], 'TagList' => [ 'base' => NULL, 'refs' => [ 'CreateContainerInput$Tags' => '<p>An array of key:value pairs that you define. These values can be anything that you want. Typically, the tag key represents a category (such as "environment") and the tag value represents a specific value within that category (such as "test," "development," or "production"). You can add up to 50 tags to each container. For more information about tagging, including naming and usage conventions, see <a href="https://docs.aws.amazon.com/mediastore/latest/ug/tagging.html">Tagging Resources in MediaStore</a>.</p>', 'ListTagsForResourceOutput$Tags' => '<p>An array of key:value pairs that are assigned to the container.</p>', 'TagResourceInput$Tags' => '<p>An array of key:value pairs that you want to add to the container. You need to specify only the tags that you want to add or update. For example, suppose a container already has two tags (customer:CompanyA and priority:High). You want to change the priority tag and also add a third tag (type:Contract). For TagResource, you specify the following tags: priority:Medium, type:Contract. The result is that your container has three tags: customer:CompanyA, priority:Medium, and type:Contract.</p>', ], ], 'TagResourceInput' => [ 'base' => NULL, 'refs' => [], ], 'TagResourceOutput' => [ 'base' => NULL, 'refs' => [], ], 'TagValue' => [ 'base' => NULL, 'refs' => [ 'Tag$Value' => '<p>Part of the key:value pair that defines a tag. You can use a tag value to describe a specific value within a category, such as "companyA" or "companyB." Tag values are case-sensitive.</p>', ], ], 'TimeStamp' => [ 'base' => NULL, 'refs' => [ 'Container$CreationTime' => '<p>Unix timestamp.</p>', ], ], 'UntagResourceInput' => [ 'base' => NULL, 'refs' => [], ], 'UntagResourceOutput' => [ 'base' => NULL, 'refs' => [], ], ],];
