<?php
// This file was auto-generated from sdk-root/src/data/mediastore-data/2017-09-01/docs-2.json
return [ 'version' => '2.0', 'service' => '<p>An AWS Elemental MediaStore asset is an object, similar to an object in the Amazon S3 service. Objects are the fundamental entities that are stored in AWS Elemental MediaStore.</p>', 'operations' => [ 'DeleteObject' => '<p>Deletes an object at the specified path.</p>', 'DescribeObject' => '<p>Gets the headers for an object at the specified path.</p>', 'GetObject' => '<p>Downloads the object at the specified path. If the object’s upload availability is set to <code>streaming</code>, AWS Elemental MediaStore downloads the object even if it’s still uploading the object.</p>', 'ListItems' => '<p>Provides a list of metadata entries about folders and objects in the specified folder.</p>', 'PutObject' => '<p>Uploads an object to the specified path. Object sizes are limited to 25 MB for standard upload availability and 10 MB for streaming upload availability.</p>', ], 'shapes' => [ 'ContainerNotFoundException' => [ 'base' => '<p>The specified container was not found for the specified account.</p>', 'refs' => [], ], 'ContentRangePattern' => [ 'base' => NULL, 'refs' => [ 'GetObjectResponse$ContentRange' => '<p>The range of bytes to retrieve.</p>', ], ], 'ContentType' => [ 'base' => NULL, 'refs' => [ 'DescribeObjectResponse$ContentType' => '<p>The content type of the object.</p>', 'GetObjectResponse$ContentType' => '<p>The content type of the object.</p>', 'Item$ContentType' => '<p>The content type of the item.</p>', 'PutObjectRequest$ContentType' => '<p>The content type of the object.</p>', ], ], 'DeleteObjectRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteObjectResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeObjectRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeObjectResponse' => [ 'base' => NULL, 'refs' => [], ], 'ETag' => [ 'base' => NULL, 'refs' => [ 'DescribeObjectResponse$ETag' => '<p>The ETag that represents a unique instance of the object.</p>', 'GetObjectResponse$ETag' => '<p>The ETag that represents a unique instance of the object.</p>', 'Item$ETag' => '<p>The ETag that represents a unique instance of the item.</p>', 'PutObjectResponse$ETag' => '<p>Unique identifier of the object in the container.</p>', ], ], 'ErrorMessage' => [ 'base' => NULL, 'refs' => [ 'ContainerNotFoundException$Message' => NULL, 'InternalServerError$Message' => NULL, 'ObjectNotFoundException$Message' => NULL, 'RequestedRangeNotSatisfiableException$Message' => NULL, ], ], 'GetObjectRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetObjectResponse' => [ 'base' => NULL, 'refs' => [], ], 'InternalServerError' => [ 'base' => '<p>The service is temporarily unavailable.</p>', 'refs' => [], ], 'Item' => [ 'base' => '<p>A metadata entry for a folder or object.</p>', 'refs' => [ 'ItemList$member' => NULL, ], ], 'ItemList' => [ 'base' => NULL, 'refs' => [ 'ListItemsResponse$Items' => '<p>The metadata entries for the folders and objects at the requested path.</p>', ], ], 'ItemName' => [ 'base' => NULL, 'refs' => [ 'Item$Name' => '<p>The name of the item.</p>', ], ], 'ItemType' => [ 'base' => NULL, 'refs' => [ 'Item$Type' => '<p>The item type (folder or object).</p>', ], ], 'ListItemsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListItemsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListLimit' => [ 'base' => NULL, 'refs' => [ 'ListItemsRequest$MaxResults' => '<p>The maximum number of results to return per API request. For example, you submit a <code>ListItems</code> request with <code>MaxResults</code> set at 500. Although 2,000 items match your request, the service returns no more than the first 500 items. (The service also returns a <code>NextToken</code> value that you can use to fetch the next batch of results.) The service might return fewer results than the <code>MaxResults</code> value.</p> <p>If <code>MaxResults</code> is not included in the request, the service defaults to pagination with a maximum of 1,000 results per page.</p>', ], ], 'ListPathNaming' => [ 'base' => NULL, 'refs' => [ 'ListItemsRequest$Path' => '<p>The path in the container from which to retrieve items. Format: &lt;folder name&gt;/&lt;folder name&gt;/&lt;file name&gt;</p>', ], ], 'NonNegativeLong' => [ 'base' => NULL, 'refs' => [ 'DescribeObjectResponse$ContentLength' => '<p>The length of the object in bytes.</p>', 'GetObjectResponse$ContentLength' => '<p>The length of the object in bytes.</p>', 'Item$ContentLength' => '<p>The length of the item in bytes.</p>', ], ], 'ObjectNotFoundException' => [ 'base' => '<p>Could not perform an operation on an object that does not exist.</p>', 'refs' => [], ], 'PaginationToken' => [ 'base' => NULL, 'refs' => [ 'ListItemsRequest$NextToken' => '<p>The token that identifies which batch of results that you want to see. For example, you submit a <code>ListItems</code> request with <code>MaxResults</code> set at 500. The service returns the first batch of results (up to 500) and a <code>NextToken</code> value. To see the next batch of results, you can submit the <code>ListItems</code> request a second time and specify the <code>NextToken</code> value.</p> <p>Tokens expire after 15 minutes.</p>', 'ListItemsResponse$NextToken' => '<p>The token that can be used in a request to view the next set of results. For example, you submit a <code>ListItems</code> request that matches 2,000 items with <code>MaxResults</code> set at 500. The service returns the first batch of results (up to 500) and a <code>NextToken</code> value that can be used to fetch the next batch of results.</p>', ], ], 'PathNaming' => [ 'base' => NULL, 'refs' => [ 'DeleteObjectRequest$Path' => '<p>The path (including the file name) where the object is stored in the container. Format: &lt;folder name&gt;/&lt;folder name&gt;/&lt;file name&gt;</p>', 'DescribeObjectRequest$Path' => '<p>The path (including the file name) where the object is stored in the container. Format: &lt;folder name&gt;/&lt;folder name&gt;/&lt;file name&gt;</p>', 'GetObjectRequest$Path' => '<p>The path (including the file name) where the object is stored in the container. Format: &lt;folder name&gt;/&lt;folder name&gt;/&lt;file name&gt;</p> <p>For example, to upload the file <code>mlaw.avi</code> to the folder path <code>premium\\canada</code> in the container <code>movies</code>, enter the path <code>premium/canada/mlaw.avi</code>.</p> <p>Do not include the container name in this path.</p> <p>If the path includes any folders that don\'t exist yet, the service creates them. For example, suppose you have an existing <code>premium/usa</code> subfolder. If you specify <code>premium/canada</code>, the service creates a <code>canada</code> subfolder in the <code>premium</code> folder. You then have two subfolders, <code>usa</code> and <code>canada</code>, in the <code>premium</code> folder. </p> <p>There is no correlation between the path to the source and the path (folders) in the container in AWS Elemental MediaStore.</p> <p>For more information about folders and how they exist in a container, see the <a href="http://docs.aws.amazon.com/mediastore/latest/ug/">AWS Elemental MediaStore User Guide</a>.</p> <p>The file name is the name that is assigned to the file that you upload. The file can have the same name inside and outside of AWS Elemental MediaStore, or it can have the same name. The file name can include or omit an extension. </p>', 'PutObjectRequest$Path' => '<p>The path (including the file name) where the object is stored in the container. Format: &lt;folder name&gt;/&lt;folder name&gt;/&lt;file name&gt;</p> <p>For example, to upload the file <code>mlaw.avi</code> to the folder path <code>premium\\canada</code> in the container <code>movies</code>, enter the path <code>premium/canada/mlaw.avi</code>.</p> <p>Do not include the container name in this path.</p> <p>If the path includes any folders that don\'t exist yet, the service creates them. For example, suppose you have an existing <code>premium/usa</code> subfolder. If you specify <code>premium/canada</code>, the service creates a <code>canada</code> subfolder in the <code>premium</code> folder. You then have two subfolders, <code>usa</code> and <code>canada</code>, in the <code>premium</code> folder. </p> <p>There is no correlation between the path to the source and the path (folders) in the container in AWS Elemental MediaStore.</p> <p>For more information about folders and how they exist in a container, see the <a href="http://docs.aws.amazon.com/mediastore/latest/ug/">AWS Elemental MediaStore User Guide</a>.</p> <p>The file name is the name that is assigned to the file that you upload. The file can have the same name inside and outside of AWS Elemental MediaStore, or it can have the same name. The file name can include or omit an extension. </p>', ], ], 'PayloadBlob' => [ 'base' => NULL, 'refs' => [ 'GetObjectResponse$Body' => '<p>The bytes of the object. </p>', 'PutObjectRequest$Body' => '<p>The bytes to be stored. </p>', ], ], 'PutObjectRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutObjectResponse' => [ 'base' => NULL, 'refs' => [], ], 'RangePattern' => [ 'base' => NULL, 'refs' => [ 'GetObjectRequest$Range' => '<p>The range bytes of an object to retrieve. For more information about the <code>Range</code> header, see <a href="http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.35">http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.35</a>. AWS Elemental MediaStore ignores this header for partially uploaded objects that have streaming upload availability.</p>', ], ], 'RequestedRangeNotSatisfiableException' => [ 'base' => '<p>The requested content range is not valid.</p>', 'refs' => [], ], 'SHA256Hash' => [ 'base' => NULL, 'refs' => [ 'PutObjectResponse$ContentSHA256' => '<p>The SHA256 digest of the object that is persisted.</p>', ], ], 'StorageClass' => [ 'base' => NULL, 'refs' => [ 'PutObjectRequest$StorageClass' => '<p>Indicates the storage class of a <code>Put</code> request. Defaults to high-performance temporal storage class, and objects are persisted into durable storage shortly after being received.</p>', 'PutObjectResponse$StorageClass' => '<p>The storage class where the object was persisted. The class should be “Temporal”.</p>', ], ], 'StringPrimitive' => [ 'base' => NULL, 'refs' => [ 'DescribeObjectResponse$CacheControl' => '<p>An optional <code>CacheControl</code> header that allows the caller to control the object\'s cache behavior. Headers can be passed in as specified in the HTTP at <a href="https://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.9">https://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.9</a>.</p> <p>Headers with a custom user-defined value are also accepted.</p>', 'GetObjectResponse$CacheControl' => '<p>An optional <code>CacheControl</code> header that allows the caller to control the object\'s cache behavior. Headers can be passed in as specified in the HTTP spec at <a href="https://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.9">https://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.9</a>.</p> <p>Headers with a custom user-defined value are also accepted.</p>', 'PutObjectRequest$CacheControl' => '<p>An optional <code>CacheControl</code> header that allows the caller to control the object\'s cache behavior. Headers can be passed in as specified in the HTTP at <a href="https://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.9">https://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.9</a>.</p> <p>Headers with a custom user-defined value are also accepted.</p>', ], ], 'TimeStamp' => [ 'base' => NULL, 'refs' => [ 'DescribeObjectResponse$LastModified' => '<p>The date and time that the object was last modified.</p>', 'GetObjectResponse$LastModified' => '<p>The date and time that the object was last modified.</p>', 'Item$LastModified' => '<p>The date and time that the item was last modified.</p>', ], ], 'UploadAvailability' => [ 'base' => NULL, 'refs' => [ 'PutObjectRequest$UploadAvailability' => '<p>Indicates the availability of an object while it is still uploading. If the value is set to <code>streaming</code>, the object is available for downloading after some initial buffering but before the object is uploaded completely. If the value is set to <code>standard</code>, the object is available for downloading only when it is uploaded completely. The default value for this header is <code>standard</code>.</p> <p>To use this header, you must also set the HTTP <code>Transfer-Encoding</code> header to <code>chunked</code>.</p>', ], ], 'statusCode' => [ 'base' => NULL, 'refs' => [ 'GetObjectResponse$StatusCode' => '<p>The HTML status code of the request. Status codes ranging from 200 to 299 indicate success. All other status codes indicate the type of error that occurred.</p>', ], ], ],];
