<?php
// This file was auto-generated from sdk-root/src/data/keyspaces/2022-02-10/docs-2.json
return [ 'version' => '2.0', 'service' => '<p>Amazon Keyspaces (for Apache Cassandra) is a scalable, highly available, and managed Apache Cassandra-compatible database service. Amazon Keyspaces makes it easy to migrate, run, and scale Cassandra workloads in the Amazon Web Services Cloud. With just a few clicks on the Amazon Web Services Management Console or a few lines of code, you can create keyspaces and tables in Amazon Keyspaces, without deploying any infrastructure or installing software. </p> <p>In addition to supporting Cassandra Query Language (CQL) requests via open-source Cassandra drivers, Amazon Keyspaces supports data definition language (DDL) operations to manage keyspaces and tables using the Amazon Web Services SDK and CLI. This API reference describes the supported DDL operations in detail.</p> <p>For the list of all supported CQL APIs, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/cassandra-apis.html">Supported Cassandra APIs, operations, and data types in Amazon Keyspaces</a> in the <i>Amazon Keyspaces Developer Guide</i>.</p> <p>To learn how Amazon Keyspaces API actions are recorded with CloudTrail, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/logging-using-cloudtrail.html#service-name-info-in-cloudtrail">Amazon Keyspaces information in CloudTrail</a> in the <i>Amazon Keyspaces Developer Guide</i>.</p> <p>For more information about Amazon Web Services APIs, for example how to implement retry logic or how to sign Amazon Web Services API requests, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-apis.html">Amazon Web Services APIs</a> in the <i>General Reference</i>.</p>', 'operations' => [ 'CreateKeyspace' => '<p>The <code>CreateKeyspace</code> operation adds a new keyspace to your account. In an Amazon Web Services account, keyspace names must be unique within each Region.</p> <p> <code>CreateKeyspace</code> is an asynchronous operation. You can monitor the creation status of the new keyspace by using the <code>GetKeyspace</code> operation.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/working-with-keyspaces.html#keyspaces-create">Creating keyspaces</a> in the <i>Amazon Keyspaces Developer Guide</i>.</p>', 'CreateTable' => '<p>The <code>CreateTable</code> operation adds a new table to the specified keyspace. Within a keyspace, table names must be unique.</p> <p> <code>CreateTable</code> is an asynchronous operation. When the request is received, the status of the table is set to <code>CREATING</code>. You can monitor the creation status of the new table by using the <code>GetTable</code> operation, which returns the current <code>status</code> of the table. You can start using a table when the status is <code>ACTIVE</code>.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/working-with-tables.html#tables-create">Creating tables</a> in the <i>Amazon Keyspaces Developer Guide</i>.</p>', 'DeleteKeyspace' => '<p>The <code>DeleteKeyspace</code> operation deletes a keyspace and all of its tables. </p>', 'DeleteTable' => '<p>The <code>DeleteTable</code> operation deletes a table and all of its data. After a <code>DeleteTable</code> request is received, the specified table is in the <code>DELETING</code> state until Amazon Keyspaces completes the deletion. If the table is in the <code>ACTIVE</code> state, you can delete it. If a table is either in the <code>CREATING</code> or <code>UPDATING</code> states, then Amazon Keyspaces returns a <code>ResourceInUseException</code>. If the specified table does not exist, Amazon Keyspaces returns a <code>ResourceNotFoundException</code>. If the table is already in the <code>DELETING</code> state, no error is returned.</p>', 'GetKeyspace' => '<p>Returns the name and the Amazon Resource Name (ARN) of the specified table.</p>', 'GetTable' => '<p>Returns information about the table, including the table\'s name and current status, the keyspace name, configuration settings, and metadata.</p> <p>To read table metadata using <code>GetTable</code>, <code>Select</code> action permissions for the table and system tables are required to complete the operation.</p>', 'ListKeyspaces' => '<p>Returns a list of keyspaces.</p>', 'ListTables' => '<p>Returns a list of tables for a specified keyspace.</p>', 'ListTagsForResource' => '<p>Returns a list of all tags associated with the specified Amazon Keyspaces resource.</p>', 'RestoreTable' => '<p>Restores the specified table to the specified point in time within the <code>earliest_restorable_timestamp</code> and the current time. For more information about restore points, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/PointInTimeRecovery_HowItWorks.html#howitworks_backup_window"> Time window for PITR continuous backups</a> in the <i>Amazon Keyspaces Developer Guide</i>. </p> <p>Any number of users can execute up to 4 concurrent restores (any type of restore) in a given account.</p> <p>When you restore using point in time recovery, Amazon Keyspaces restores your source table\'s schema and data to the state based on the selected timestamp <code>(day:hour:minute:second)</code> to a new table. The Time to Live (TTL) settings are also restored to the state based on the selected timestamp.</p> <p>In addition to the table\'s schema, data, and TTL settings, <code>RestoreTable</code> restores the capacity mode, encryption, and point-in-time recovery settings from the source table. Unlike the table\'s schema data and TTL settings, which are restored based on the selected timestamp, these settings are always restored based on the table\'s settings as of the current time or when the table was deleted.</p> <p>You can also overwrite these settings during restore:</p> <p>• Read/write capacity mode</p> <p>• Provisioned throughput capacity settings</p> <p>• Point-in-time (PITR) settings</p> <p>• Tags</p> <p>For more information, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/PointInTimeRecovery_HowItWorks.html#howitworks_backup_settings">PITR restore settings</a> in the <i>Amazon Keyspaces Developer Guide</i>.</p> <p>Note that the following settings are not restored, and you must configure them manually for the new table:</p> <p>• Automatic scaling policies (for tables that use provisioned capacity mode)</p> <p>• Identity and Access Management (IAM) policies</p> <p>• Amazon CloudWatch metrics and alarms</p>', 'TagResource' => '<p>Associates a set of tags with a Amazon Keyspaces resource. You can then activate these user-defined tags so that they appear on the Cost Management Console for cost allocation tracking. For more information, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/tagging-keyspaces.html">Adding tags and labels to Amazon Keyspaces resources</a> in the <i>Amazon Keyspaces Developer Guide</i>.</p> <p>For IAM policy examples that show how to control access to Amazon Keyspaces resources based on tags, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/security_iam_id-based-policy-examples-tags">Amazon Keyspaces resource access based on tags</a> in the <i>Amazon Keyspaces Developer Guide</i>.</p>', 'UntagResource' => '<p>Removes the association of tags from a Amazon Keyspaces resource.</p>', 'UpdateTable' => '<p>Adds new columns to the table or updates one of the table\'s settings, for example capacity mode, encryption, point-in-time recovery, or ttl settings. Note that you can only update one specific table setting per update operation.</p>', ], 'shapes' => [ 'ARN' => [ 'base' => NULL, 'refs' => [ 'CreateKeyspaceResponse$resourceArn' => '<p>The unique identifier of the keyspace in the format of an Amazon Resource Name (ARN).</p>', 'CreateTableResponse$resourceArn' => '<p>The unique identifier of the table in the format of an Amazon Resource Name (ARN).</p>', 'GetKeyspaceResponse$resourceArn' => '<p>The ARN of the keyspace.</p>', 'GetTableResponse$resourceArn' => '<p>The Amazon Resource Name (ARN) of the specified table.</p>', 'KeyspaceSummary$resourceArn' => '<p>The unique identifier of the keyspace in the format of an Amazon Resource Name (ARN).</p>', 'ListTagsForResourceRequest$resourceArn' => '<p>The Amazon Resource Name (ARN) of the Amazon Keyspaces resource.</p>', 'ResourceNotFoundException$resourceArn' => '<p>The unique identifier in the format of Amazon Resource Name (ARN), for the resource not found.</p>', 'RestoreTableResponse$restoredTableARN' => '<p>The Amazon Resource Name (ARN) of the restored table.</p>', 'TableSummary$resourceArn' => '<p>The unique identifier of the table in the format of an Amazon Resource Name (ARN).</p>', 'TagResourceRequest$resourceArn' => '<p>The Amazon Resource Name (ARN) of the Amazon Keyspaces resource to which to add tags.</p>', 'UntagResourceRequest$resourceArn' => '<p>The Amazon Keyspaces resource that the tags will be removed from. This value is an Amazon Resource Name (ARN).</p>', 'UpdateTableResponse$resourceArn' => '<p>The Amazon Resource Name (ARN) of the modified table.</p>', ], ], 'AccessDeniedException' => [ 'base' => '<p>You do not have sufficient access to perform this action. </p>', 'refs' => [], ], 'CapacitySpecification' => [ 'base' => '<p>Amazon Keyspaces has two read/write capacity modes for processing reads and writes on your tables: </p> <p>• On-demand (default)</p> <p>• Provisioned</p> <p> The read/write capacity mode that you choose controls how you are charged for read and write throughput and how table throughput capacity is managed.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/ReadWriteCapacityMode.html">Read/write capacity modes</a> in the <i>Amazon Keyspaces Developer Guide</i>.</p>', 'refs' => [ 'CreateTableRequest$capacitySpecification' => '<p>Specifies the read/write throughput capacity mode for the table. The options are:</p> <p>• <code>throughputMode:PAY_PER_REQUEST</code> and </p> <p>• <code>throughputMode:PROVISIONED</code> - Provisioned capacity mode requires <code>readCapacityUnits</code> and <code>writeCapacityUnits</code> as input.</p> <p>The default is <code>throughput_mode:PAY_PER_REQUEST</code>.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/ReadWriteCapacityMode.html">Read/write capacity modes</a> in the <i>Amazon Keyspaces Developer Guide</i>.</p>', 'RestoreTableRequest$capacitySpecificationOverride' => '<p>Specifies the read/write throughput capacity mode for the target table. The options are:</p> <p>• <code>throughputMode:PAY_PER_REQUEST</code> </p> <p>• <code>throughputMode:PROVISIONED</code> - Provisioned capacity mode requires <code>readCapacityUnits</code> and <code>writeCapacityUnits</code> as input.</p> <p>The default is <code>throughput_mode:PAY_PER_REQUEST</code>.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/ReadWriteCapacityMode.html">Read/write capacity modes</a> in the <i>Amazon Keyspaces Developer Guide</i>.</p>', 'UpdateTableRequest$capacitySpecification' => '<p>Modifies the read/write throughput capacity mode for the table. The options are:</p> <p>• <code>throughputMode:PAY_PER_REQUEST</code> and </p> <p>• <code>throughputMode:PROVISIONED</code> - Provisioned capacity mode requires <code>readCapacityUnits</code> and <code>writeCapacityUnits</code> as input.</p> <p>The default is <code>throughput_mode:PAY_PER_REQUEST</code>.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/ReadWriteCapacityMode.html">Read/write capacity modes</a> in the <i>Amazon Keyspaces Developer Guide</i>.</p>', ], ], 'CapacitySpecificationSummary' => [ 'base' => '<p>The read/write throughput capacity mode for a table. The options are:</p> <p>• <code>throughputMode:PAY_PER_REQUEST</code> and </p> <p>• <code>throughputMode:PROVISIONED</code>.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/ReadWriteCapacityMode.html">Read/write capacity modes</a> in the <i>Amazon Keyspaces Developer Guide</i>.</p>', 'refs' => [ 'GetTableResponse$capacitySpecification' => '<p>The read/write throughput capacity mode for a table. The options are:</p> <p>• <code>throughputMode:PAY_PER_REQUEST</code> </p> <p>• <code>throughputMode:PROVISIONED</code> </p>', ], ], 'CapacityUnits' => [ 'base' => NULL, 'refs' => [ 'CapacitySpecification$readCapacityUnits' => '<p>The throughput capacity specified for <code>read</code> operations defined in <code>read capacity units</code> <code>(RCUs)</code>.</p>', 'CapacitySpecification$writeCapacityUnits' => '<p>The throughput capacity specified for <code>write</code> operations defined in <code>write capacity units</code> <code>(WCUs)</code>.</p>', 'CapacitySpecificationSummary$readCapacityUnits' => '<p>The throughput capacity specified for <code>read</code> operations defined in <code>read capacity units</code> <code>(RCUs)</code>.</p>', 'CapacitySpecificationSummary$writeCapacityUnits' => '<p>The throughput capacity specified for <code>write</code> operations defined in <code>write capacity units</code> <code>(WCUs)</code>.</p>', ], ], 'ClusteringKey' => [ 'base' => '<p>The optional clustering column portion of your primary key determines how the data is clustered and sorted within each partition.</p>', 'refs' => [ 'ClusteringKeyList$member' => NULL, ], ], 'ClusteringKeyList' => [ 'base' => NULL, 'refs' => [ 'SchemaDefinition$clusteringKeys' => '<p>The columns that are part of the clustering key of the table.</p>', ], ], 'ColumnDefinition' => [ 'base' => '<p>The names and data types of regular columns.</p>', 'refs' => [ 'ColumnDefinitionList$member' => NULL, ], ], 'ColumnDefinitionList' => [ 'base' => NULL, 'refs' => [ 'SchemaDefinition$allColumns' => '<p>The regular columns of the table.</p>', 'UpdateTableRequest$addColumns' => '<p>For each column to be added to the specified table:</p> <p>• <code>name</code> - The name of the column.</p> <p>• <code>type</code> - An Amazon Keyspaces data type. For more information, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/cql.elements.html#cql.data-types">Data types</a> in the <i>Amazon Keyspaces Developer Guide</i>.</p>', ], ], 'Comment' => [ 'base' => '<p>An optional comment that describes the table.</p>', 'refs' => [ 'CreateTableRequest$comment' => '<p>This parameter allows to enter a description of the table.</p>', 'GetTableResponse$comment' => '<p>The the description of the specified table.</p>', ], ], 'ConflictException' => [ 'base' => '<p>Amazon Keyspaces could not complete the requested action. This error may occur if you try to perform an action and the same or a different action is already in progress, or if you try to create a resource that already exists. </p>', 'refs' => [], ], 'CreateKeyspaceRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateKeyspaceResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateTableRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateTableResponse' => [ 'base' => NULL, 'refs' => [], ], 'DefaultTimeToLive' => [ 'base' => NULL, 'refs' => [ 'CreateTableRequest$defaultTimeToLive' => '<p>The default Time to Live setting in seconds for the table.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/TTL-how-it-works.html#ttl-howitworks_default_ttl">Setting the default TTL value for a table</a> in the <i>Amazon Keyspaces Developer Guide</i>.</p>', 'GetTableResponse$defaultTimeToLive' => '<p>The default Time to Live settings of the specified table.</p>', 'UpdateTableRequest$defaultTimeToLive' => '<p>The default Time to Live setting in seconds for the table.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/TTL-how-it-works.html#ttl-howitworks_default_ttl">Setting the default TTL value for a table</a> in the <i>Amazon Keyspaces Developer Guide</i>.</p>', ], ], 'DeleteKeyspaceRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteKeyspaceResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteTableRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteTableResponse' => [ 'base' => NULL, 'refs' => [], ], 'EncryptionSpecification' => [ 'base' => '<p>Amazon Keyspaces encrypts and decrypts the table data at rest transparently and integrates with Key Management Service for storing and managing the encryption key. You can choose one of the following KMS keys (KMS keys):</p> <p>• Amazon Web Services owned key - This is the default encryption type. The key is owned by Amazon Keyspaces (no additional charge). </p> <p>• Customer managed key - This key is stored in your account and is created, owned, and managed by you. You have full control over the customer managed key (KMS charges apply).</p> <p>For more information about encryption at rest in Amazon Keyspaces, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/EncryptionAtRest.html">Encryption at rest</a> in the <i>Amazon Keyspaces Developer Guide</i>.</p> <p>For more information about KMS, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/EncryptionAtRest.html">KMS management service concepts</a> in the <i>Key Management Service Developer Guide</i>.</p>', 'refs' => [ 'CreateTableRequest$encryptionSpecification' => '<p>Specifies how the encryption key for encryption at rest is managed for the table. You can choose one of the following KMS key (KMS key):</p> <p>• <code>type:AWS_OWNED_KMS_KEY</code> - This key is owned by Amazon Keyspaces. </p> <p>• <code>type:CUSTOMER_MANAGED_KMS_KEY</code> - This key is stored in your account and is created, owned, and managed by you. This option requires the <code>kms_key_identifier</code> of the KMS key in Amazon Resource Name (ARN) format as input.</p> <p>The default is <code>type:AWS_OWNED_KMS_KEY</code>. </p> <p>For more information, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/EncryptionAtRest.html">Encryption at rest</a> in the <i>Amazon Keyspaces Developer Guide</i>.</p>', 'GetTableResponse$encryptionSpecification' => '<p>The encryption settings of the specified table.</p>', 'RestoreTableRequest$encryptionSpecificationOverride' => '<p>Specifies the encryption settings for the target table. You can choose one of the following KMS key (KMS key):</p> <p>• <code>type:AWS_OWNED_KMS_KEY</code> - This key is owned by Amazon Keyspaces. </p> <p>• <code>type:CUSTOMER_MANAGED_KMS_KEY</code> - This key is stored in your account and is created, owned, and managed by you. This option requires the <code>kms_key_identifier</code> of the KMS key in Amazon Resource Name (ARN) format as input. </p> <p>The default is <code>type:AWS_OWNED_KMS_KEY</code>.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/EncryptionAtRest.html">Encryption at rest</a> in the <i>Amazon Keyspaces Developer Guide</i>.</p>', 'UpdateTableRequest$encryptionSpecification' => '<p>Modifies the encryption settings of the table. You can choose one of the following KMS key (KMS key):</p> <p>• <code>type:AWS_OWNED_KMS_KEY</code> - This key is owned by Amazon Keyspaces. </p> <p>• <code>type:CUSTOMER_MANAGED_KMS_KEY</code> - This key is stored in your account and is created, owned, and managed by you. This option requires the <code>kms_key_identifier</code> of the KMS key in Amazon Resource Name (ARN) format as input. </p> <p>The default is <code>AWS_OWNED_KMS_KEY</code>.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/EncryptionAtRest.html">Encryption at rest</a> in the <i>Amazon Keyspaces Developer Guide</i>.</p>', ], ], 'EncryptionType' => [ 'base' => NULL, 'refs' => [ 'EncryptionSpecification$type' => '<p>The encryption option specified for the table. You can choose one of the following KMS keys (KMS keys):</p> <p>• <code>type:AWS_OWNED_KMS_KEY</code> - This key is owned by Amazon Keyspaces. </p> <p>• <code>type:CUSTOMER_MANAGED_KMS_KEY</code> - This key is stored in your account and is created, owned, and managed by you. This option requires the <code>kms_key_identifier</code> of the KMS key in Amazon Resource Name (ARN) format as input. </p> <p>The default is <code>type:AWS_OWNED_KMS_KEY</code>. </p> <p>For more information, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/EncryptionAtRest.html">Encryption at rest</a> in the <i>Amazon Keyspaces Developer Guide</i>.</p>', ], ], 'GenericString' => [ 'base' => NULL, 'refs' => [ 'ClusteringKey$name' => '<p>The name(s) of the clustering column(s).</p>', 'ColumnDefinition$name' => '<p>The name of the column.</p>', 'ColumnDefinition$type' => '<p>The data type of the column. For a list of available data types, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/cql.elements.html#cql.data-types">Data types</a> in the <i>Amazon Keyspaces Developer Guide</i>.</p>', 'PartitionKey$name' => '<p>The name(s) of the partition key column(s).</p>', 'StaticColumn$name' => '<p>The name of the static column.</p>', ], ], 'GetKeyspaceRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetKeyspaceResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetTableRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetTableResponse' => [ 'base' => NULL, 'refs' => [], ], 'InternalServerException' => [ 'base' => '<p>Amazon Keyspaces was unable to fully process this request because of an internal server error.</p>', 'refs' => [], ], 'KeyspaceName' => [ 'base' => NULL, 'refs' => [ 'CreateKeyspaceRequest$keyspaceName' => '<p>The name of the keyspace to be created.</p>', 'CreateTableRequest$keyspaceName' => '<p>The name of the keyspace that the table is going to be created in.</p>', 'DeleteKeyspaceRequest$keyspaceName' => '<p>The name of the keyspace to be deleted.</p>', 'DeleteTableRequest$keyspaceName' => '<p>The name of the keyspace of the to be deleted table.</p>', 'GetKeyspaceRequest$keyspaceName' => '<p>The name of the keyspace.</p>', 'GetKeyspaceResponse$keyspaceName' => '<p>The name of the keyspace.</p>', 'GetTableRequest$keyspaceName' => '<p>The name of the keyspace that the table is stored in.</p>', 'GetTableResponse$keyspaceName' => '<p>The name of the keyspace that the specified table is stored in.</p>', 'KeyspaceSummary$keyspaceName' => '<p>The name of the keyspace.</p>', 'ListTablesRequest$keyspaceName' => '<p>The name of the keyspace.</p>', 'RestoreTableRequest$sourceKeyspaceName' => '<p>The keyspace name of the source table.</p>', 'RestoreTableRequest$targetKeyspaceName' => '<p>The name of the target keyspace.</p>', 'TableSummary$keyspaceName' => '<p>The name of the keyspace that the table is stored in.</p>', 'UpdateTableRequest$keyspaceName' => '<p>The name of the keyspace the specified table is stored in.</p>', ], ], 'KeyspaceSummary' => [ 'base' => '<p>Represents the properties of a keyspace.</p>', 'refs' => [ 'KeyspaceSummaryList$member' => NULL, ], ], 'KeyspaceSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListKeyspacesResponse$keyspaces' => '<p>A list of keyspaces.</p>', ], ], 'ListKeyspacesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListKeyspacesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTablesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTablesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'MaxResults' => [ 'base' => NULL, 'refs' => [ 'ListKeyspacesRequest$maxResults' => '<p>The total number of keyspaces to return in the output. If the total number of keyspaces available is more than the value specified, a <code>NextToken</code> is provided in the output. To resume pagination, provide the <code>NextToken</code> value as an argument of a subsequent API invocation.</p>', 'ListTablesRequest$maxResults' => '<p>The total number of tables to return in the output. If the total number of tables available is more than the value specified, a <code>NextToken</code> is provided in the output. To resume pagination, provide the <code>NextToken</code> value as an argument of a subsequent API invocation.</p>', 'ListTagsForResourceRequest$maxResults' => '<p>The total number of tags to return in the output. If the total number of tags available is more than the value specified, a <code>NextToken</code> is provided in the output. To resume pagination, provide the <code>NextToken</code> value as an argument of a subsequent API invocation.</p>', ], ], 'NextToken' => [ 'base' => NULL, 'refs' => [ 'ListKeyspacesRequest$nextToken' => '<p>The pagination token. To resume pagination, provide the <code>NextToken</code> value as argument of a subsequent API invocation.</p>', 'ListKeyspacesResponse$nextToken' => '<p>A token to specify where to start paginating. This is the <code>NextToken</code> from a previously truncated response.</p>', 'ListTablesRequest$nextToken' => '<p>The pagination token. To resume pagination, provide the <code>NextToken</code> value as an argument of a subsequent API invocation.</p>', 'ListTablesResponse$nextToken' => '<p>A token to specify where to start paginating. This is the <code>NextToken</code> from a previously truncated response.</p>', 'ListTagsForResourceRequest$nextToken' => '<p>The pagination token. To resume pagination, provide the <code>NextToken</code> value as argument of a subsequent API invocation.</p>', 'ListTagsForResourceResponse$nextToken' => '<p>A token to specify where to start paginating. This is the <code>NextToken</code> from a previously truncated response.</p>', ], ], 'PartitionKey' => [ 'base' => '<p>The partition key portion of the primary key is required and determines how Amazon Keyspaces stores the data. The partition key can be a single column, or it can be a compound value composed of two or more columns.</p>', 'refs' => [ 'PartitionKeyList$member' => NULL, ], ], 'PartitionKeyList' => [ 'base' => NULL, 'refs' => [ 'SchemaDefinition$partitionKeys' => '<p>The columns that are part of the partition key of the table .</p>', ], ], 'PointInTimeRecovery' => [ 'base' => '<p>Point-in-time recovery (PITR) helps protect your Amazon Keyspaces tables from accidental write or delete operations by providing you continuous backups of your table data.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/PointInTimeRecovery.html">Point-in-time recovery</a> in the <i>Amazon Keyspaces Developer Guide</i>.</p>', 'refs' => [ 'CreateTableRequest$pointInTimeRecovery' => '<p>Specifies if <code>pointInTimeRecovery</code> is enabled or disabled for the table. The options are:</p> <p>• <code>ENABLED</code> </p> <p>• <code>DISABLED</code> </p> <p>If it\'s not specified, the default is <code>DISABLED</code>.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/PointInTimeRecovery.html">Point-in-time recovery</a> in the <i>Amazon Keyspaces Developer Guide</i>.</p>', 'RestoreTableRequest$pointInTimeRecoveryOverride' => '<p>Specifies the <code>pointInTimeRecovery</code> settings for the target table. The options are:</p> <p>• <code>ENABLED</code> </p> <p>• <code>DISABLED</code> </p> <p>If it\'s not specified, the default is <code>DISABLED</code>.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/PointInTimeRecovery.html">Point-in-time recovery</a> in the <i>Amazon Keyspaces Developer Guide</i>.</p>', 'UpdateTableRequest$pointInTimeRecovery' => '<p>Modifies the <code>pointInTimeRecovery</code> settings of the table. The options are:</p> <p>• <code>ENABLED</code> </p> <p>• <code>DISABLED</code> </p> <p>If it\'s not specified, the default is <code>DISABLED</code>.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/PointInTimeRecovery.html">Point-in-time recovery</a> in the <i>Amazon Keyspaces Developer Guide</i>.</p>', ], ], 'PointInTimeRecoveryStatus' => [ 'base' => NULL, 'refs' => [ 'PointInTimeRecovery$status' => '<p>The options are:</p> <p>• <code>ENABLED</code> </p> <p>• <code>DISABLED</code> </p>', 'PointInTimeRecoverySummary$status' => '<p>Shows if point-in-time recovery is enabled or disabled for the specified table.</p>', ], ], 'PointInTimeRecoverySummary' => [ 'base' => '<p>The point-in-time recovery status of the specified table.</p>', 'refs' => [ 'GetTableResponse$pointInTimeRecovery' => '<p>The point-in-time recovery status of the specified table.</p>', ], ], 'ResourceNotFoundException' => [ 'base' => '<p>The operation tried to access a keyspace or table that doesn\'t exist. The resource might not be specified correctly, or its status might not be <code>ACTIVE</code>.</p>', 'refs' => [], ], 'RestoreTableRequest' => [ 'base' => NULL, 'refs' => [], ], 'RestoreTableResponse' => [ 'base' => NULL, 'refs' => [], ], 'SchemaDefinition' => [ 'base' => '<p>Describes the schema of the table.</p>', 'refs' => [ 'CreateTableRequest$schemaDefinition' => '<p>The <code>schemaDefinition</code> consists of the following parameters.</p> <p>For each column to be created:</p> <p>• <code>name</code> - The name of the column.</p> <p>• <code>type</code> - An Amazon Keyspaces data type. For more information, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/cql.elements.html#cql.data-types">Data types</a> in the <i>Amazon Keyspaces Developer Guide</i>.</p> <p>The primary key of the table consists of the following columns:</p> <p>• <code>partitionKeys</code> - The partition key can be a single column, or it can be a compound value composed of two or more columns. The partition key portion of the primary key is required and determines how Amazon Keyspaces stores your data.</p> <p>• <code>name</code> - The name of each partition key column.</p> <p>• <code>clusteringKeys</code> - The optional clustering column portion of your primary key determines how the data is clustered and sorted within each partition.</p> <p>• <code>name</code> - The name of the clustering column. </p> <p>• <code>orderBy</code> - Sets the ascendant (<code>ASC</code>) or descendant (<code>DESC</code>) order modifier.</p> <p>To define a column as static use <code>staticColumns</code> - Static columns store values that are shared by all rows in the same partition:</p> <p>• <code>name</code> - The name of the column.</p> <p>• <code>type</code> - An Amazon Keyspaces data type.</p>', 'GetTableResponse$schemaDefinition' => '<p>The schema definition of the specified table.</p>', ], ], 'ServiceQuotaExceededException' => [ 'base' => '<p>The operation exceeded the service quota for this resource. For more information on service quotas, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/quotas.html">Quotas</a> in the <i>Amazon Keyspaces Developer Guide</i>.</p>', 'refs' => [], ], 'SortOrder' => [ 'base' => NULL, 'refs' => [ 'ClusteringKey$orderBy' => '<p>Sets the ascendant (<code>ASC</code>) or descendant (<code>DESC</code>) order modifier.</p>', ], ], 'StaticColumn' => [ 'base' => '<p>The static columns of the table. Static columns store values that are shared by all rows in the same partition.</p>', 'refs' => [ 'StaticColumnList$member' => NULL, ], ], 'StaticColumnList' => [ 'base' => NULL, 'refs' => [ 'SchemaDefinition$staticColumns' => '<p>The columns that have been defined as <code>STATIC</code>. Static columns store values that are shared by all rows in the same partition.</p>', ], ], 'String' => [ 'base' => NULL, 'refs' => [ 'AccessDeniedException$message' => NULL, 'Comment$message' => '<p>An optional description of the table.</p>', 'ConflictException$message' => NULL, 'InternalServerException$message' => NULL, 'ResourceNotFoundException$message' => NULL, 'ServiceQuotaExceededException$message' => NULL, 'ValidationException$message' => NULL, ], ], 'TableName' => [ 'base' => NULL, 'refs' => [ 'CreateTableRequest$tableName' => '<p>The name of the table.</p>', 'DeleteTableRequest$tableName' => '<p>The name of the table to be deleted.</p>', 'GetTableRequest$tableName' => '<p>The name of the table.</p>', 'GetTableResponse$tableName' => '<p>The name of the specified table.</p>', 'RestoreTableRequest$sourceTableName' => '<p>The name of the source table.</p>', 'RestoreTableRequest$targetTableName' => '<p>The name of the target table.</p>', 'TableSummary$tableName' => '<p>The name of the table.</p>', 'UpdateTableRequest$tableName' => '<p>The name of the table.</p>', ], ], 'TableStatus' => [ 'base' => NULL, 'refs' => [ 'GetTableResponse$status' => '<p>The current status of the specified table.</p>', ], ], 'TableSummary' => [ 'base' => '<p>Returns the name of the specified table, the keyspace it is stored in, and the unique identifier in the format of an Amazon Resource Name (ARN).</p>', 'refs' => [ 'TableSummaryList$member' => NULL, ], ], 'TableSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListTablesResponse$tables' => '<p>A list of tables.</p>', ], ], 'Tag' => [ 'base' => '<p>Describes a tag. A tag is a key-value pair. You can add up to 50 tags to a single Amazon Keyspaces resource.</p> <p>Amazon Web Services-assigned tag names and values are automatically assigned the <code>aws:</code> prefix, which the user cannot assign. Amazon Web Services-assigned tag names do not count towards the tag limit of 50. User-assigned tag names have the prefix <code>user:</code> in the Cost Allocation Report. You cannot backdate the application of a tag.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/tagging-keyspaces.html">Adding tags and labels to Amazon Keyspaces resources</a> in the <i>Amazon Keyspaces Developer Guide</i>.</p>', 'refs' => [ 'TagList$member' => NULL, ], ], 'TagKey' => [ 'base' => NULL, 'refs' => [ 'Tag$key' => '<p>The key of the tag. Tag keys are case sensitive. Each Amazon Keyspaces resource can only have up to one tag with the same key. If you try to add an existing tag (same key), the existing tag value will be updated to the new value.</p>', ], ], 'TagList' => [ 'base' => NULL, 'refs' => [ 'CreateKeyspaceRequest$tags' => '<p>A list of key-value pair tags to be attached to the keyspace.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/tagging-keyspaces.html">Adding tags and labels to Amazon Keyspaces resources</a> in the <i>Amazon Keyspaces Developer Guide</i>.</p>', 'CreateTableRequest$tags' => '<p>A list of key-value pair tags to be attached to the resource. </p> <p>For more information, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/tagging-keyspaces.html">Adding tags and labels to Amazon Keyspaces resources</a> in the <i>Amazon Keyspaces Developer Guide</i>.</p>', 'ListTagsForResourceResponse$tags' => '<p>A list of tags.</p>', 'RestoreTableRequest$tagsOverride' => '<p>A list of key-value pair tags to be attached to the restored table. </p> <p>For more information, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/tagging-keyspaces.html">Adding tags and labels to Amazon Keyspaces resources</a> in the <i>Amazon Keyspaces Developer Guide</i>.</p>', 'TagResourceRequest$tags' => '<p>The tags to be assigned to the Amazon Keyspaces resource.</p>', 'UntagResourceRequest$tags' => '<p>A list of existing tags to be removed from the Amazon Keyspaces resource.</p>', ], ], 'TagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'TagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'TagValue' => [ 'base' => NULL, 'refs' => [ 'Tag$value' => '<p>The value of the tag. Tag values are case-sensitive and can be null.</p>', ], ], 'ThroughputMode' => [ 'base' => NULL, 'refs' => [ 'CapacitySpecification$throughputMode' => '<p>The read/write throughput capacity mode for a table. The options are:</p> <p>• <code>throughputMode:PAY_PER_REQUEST</code> and </p> <p>• <code>throughputMode:PROVISIONED</code> - Provisioned capacity mode requires <code>readCapacityUnits</code> and <code>writeCapacityUnits</code> as input.</p> <p>The default is <code>throughput_mode:PAY_PER_REQUEST</code>.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/ReadWriteCapacityMode.html">Read/write capacity modes</a> in the <i>Amazon Keyspaces Developer Guide</i>.</p>', 'CapacitySpecificationSummary$throughputMode' => '<p>The read/write throughput capacity mode for a table. The options are:</p> <p>• <code>throughputMode:PAY_PER_REQUEST</code> and </p> <p>• <code>throughputMode:PROVISIONED</code> - Provisioned capacity mode requires <code>readCapacityUnits</code> and <code>writeCapacityUnits</code> as input. </p> <p>The default is <code>throughput_mode:PAY_PER_REQUEST</code>.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/ReadWriteCapacityMode.html">Read/write capacity modes</a> in the <i>Amazon Keyspaces Developer Guide</i>.</p>', ], ], 'TimeToLive' => [ 'base' => '<p>Enable custom Time to Live (TTL) settings for rows and columns without setting a TTL default for the specified table.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/TTL-how-it-works.html#ttl-howitworks_enabling">Enabling TTL on tables</a> in the <i>Amazon Keyspaces Developer Guide</i>.</p>', 'refs' => [ 'CreateTableRequest$ttl' => '<p>Enables Time to Live custom settings for the table. The options are:</p> <p>• <code>status:enabled</code> </p> <p>• <code>status:disabled</code> </p> <p>The default is <code>status:disabled</code>. After <code>ttl</code> is enabled, you can\'t disable it for the table.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/TTL.html">Expiring data by using Amazon Keyspaces Time to Live (TTL)</a> in the <i>Amazon Keyspaces Developer Guide</i>.</p>', 'GetTableResponse$ttl' => '<p>The custom Time to Live settings of the specified table.</p>', 'UpdateTableRequest$ttl' => '<p>Modifies Time to Live custom settings for the table. The options are:</p> <p>• <code>status:enabled</code> </p> <p>• <code>status:disabled</code> </p> <p>The default is <code>status:disabled</code>. After <code>ttl</code> is enabled, you can\'t disable it for the table.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/TTL.html">Expiring data by using Amazon Keyspaces Time to Live (TTL)</a> in the <i>Amazon Keyspaces Developer Guide</i>.</p>', ], ], 'TimeToLiveStatus' => [ 'base' => NULL, 'refs' => [ 'TimeToLive$status' => '<p>Shows how to enable custom Time to Live (TTL) settings for the specified table.</p>', ], ], 'Timestamp' => [ 'base' => NULL, 'refs' => [ 'CapacitySpecificationSummary$lastUpdateToPayPerRequestTimestamp' => '<p>The timestamp of the last operation that changed the provisioned throughput capacity of a table.</p>', 'GetTableResponse$creationTimestamp' => '<p>The creation timestamp of the specified table.</p>', 'PointInTimeRecoverySummary$earliestRestorableTimestamp' => '<p>Specifies the earliest possible restore point of the table in ISO 8601 format.</p>', 'RestoreTableRequest$restoreTimestamp' => '<p>The restore timestamp in ISO 8601 format.</p>', ], ], 'UntagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'UntagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateTableRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateTableResponse' => [ 'base' => NULL, 'refs' => [], ], 'ValidationException' => [ 'base' => '<p>The operation failed due to an invalid or malformed request.</p>', 'refs' => [], ], 'kmsKeyARN' => [ 'base' => NULL, 'refs' => [ 'EncryptionSpecification$kmsKeyIdentifier' => '<p>The Amazon Resource Name (ARN) of the customer managed KMS key, for example <code>kms_key_identifier:ARN</code>.</p>', ], ], ],];
