<?php
// This file was auto-generated from sdk-root/src/data/iottwinmaker/2021-11-29/docs-2.json
return [ 'version' => '2.0', 'service' => '<p>IoT TwinMaker is a service that enables you to build operational digital twins of physical systems. IoT TwinMaker overlays measurements and analysis from real-world sensors, cameras, and enterprise applications so you can create data visualizations to monitor your physical factory, building, or industrial plant. You can use this real-world data to monitor operations and diagnose and repair errors.</p>', 'operations' => [ 'BatchPutPropertyValues' => '<p>Sets values for multiple time series properties.</p>', 'CreateComponentType' => '<p>Creates a component type.</p>', 'CreateEntity' => '<p>Creates an entity.</p>', 'CreateScene' => '<p>Creates a scene.</p>', 'CreateWorkspace' => '<p>Creates a workplace.</p>', 'DeleteComponentType' => '<p>Deletes a component type.</p>', 'DeleteEntity' => '<p>Deletes an entity.</p>', 'DeleteScene' => '<p>Deletes a scene.</p>', 'DeleteWorkspace' => '<p>Deletes a workspace.</p>', 'GetComponentType' => '<p>Retrieves information about a component type.</p>', 'GetEntity' => '<p>Retrieves information about an entity.</p>', 'GetPropertyValue' => '<p>Gets the property values for a component, component type, entity, or workspace.</p> <p>You must specify a value for either <code>componentName</code>, <code>componentTypeId</code>, <code>entityId</code>, or <code>workspaceId</code>.</p>', 'GetPropertyValueHistory' => '<p>Retrieves information about the history of a time series property value for a component, component type, entity, or workspace.</p> <p>You must specify a value for <code>workspaceId</code>. For entity-specific queries, specify values for <code>componentName</code> and <code>entityId</code>. For cross-entity quries, specify a value for <code>componentTypeId</code>.</p>', 'GetScene' => '<p>Retrieves information about a scene.</p>', 'GetWorkspace' => '<p>Retrieves information about a workspace.</p>', 'ListComponentTypes' => '<p>Lists all component types in a workspace.</p>', 'ListEntities' => '<p>Lists all entities in a workspace.</p>', 'ListScenes' => '<p>Lists all scenes in a workspace.</p>', 'ListTagsForResource' => '<p>Lists all tags associated with a resource.</p>', 'ListWorkspaces' => '<p>Retrieves information about workspaces in the current account.</p>', 'TagResource' => '<p>Adds tags to a resource.</p>', 'UntagResource' => '<p>Removes tags from a resource.</p>', 'UpdateComponentType' => '<p>Updates information in a component type.</p>', 'UpdateEntity' => '<p>Updates an entity.</p>', 'UpdateScene' => '<p>Updates a scene.</p>', 'UpdateWorkspace' => '<p>Updates a workspace.</p>', ], 'shapes' => [ 'AccessDeniedException' => [ 'base' => '<p>Access is denied.</p>', 'refs' => [], ], 'BatchPutPropertyError' => [ 'base' => '<p>An error returned by the <code>BatchPutProperty</code> action.</p>', 'refs' => [ 'Errors$member' => NULL, ], ], 'BatchPutPropertyErrorEntry' => [ 'base' => '<p>An object that contains information about errors returned by the <code>BatchPutProperty</code> action.</p>', 'refs' => [ 'ErrorEntries$member' => NULL, ], ], 'BatchPutPropertyValuesRequest' => [ 'base' => NULL, 'refs' => [], ], 'BatchPutPropertyValuesResponse' => [ 'base' => NULL, 'refs' => [], ], 'Boolean' => [ 'base' => NULL, 'refs' => [ 'CreateComponentTypeRequest$isSingleton' => '<p>A Boolean value that specifies whether an entity can have more than one component of this type.</p>', 'DataConnector$isNative' => '<p>A Boolean value that specifies whether the data connector is native to IoT TwinMaker.</p>', 'DataValue$booleanValue' => '<p>A Boolean value.</p>', 'DeleteEntityRequest$isRecursive' => '<p>A Boolean value that specifies whether the operation deletes child entities.</p>', 'EntitySummary$hasChildEntities' => '<p>A Boolean value that specifies whether the entity has child entities or not.</p>', 'FunctionResponse$isInherited' => '<p>Indicates whether this function is inherited.</p>', 'GetComponentTypeResponse$isAbstract' => '<p>A Boolean value that specifies whether the component type is abstract.</p>', 'GetComponentTypeResponse$isSchemaInitialized' => '<p>A Boolean value that specifies whether the component type has a schema initializer and that the schema initializer has run.</p>', 'GetComponentTypeResponse$isSingleton' => '<p>A Boolean value that specifies whether an entity can have more than one component of this type.</p>', 'GetEntityResponse$hasChildEntities' => '<p>A Boolean value that specifies whether the entity has associated child entities.</p>', 'ListComponentTypesFilter$isAbstract' => '<p>A Boolean value that specifies whether the component types in the list are abstract.</p>', 'PropertyDefinitionRequest$isExternalId' => '<p>A Boolean value that specifies whether the property ID comes from an external data store.</p>', 'PropertyDefinitionRequest$isRequiredInEntity' => '<p>A Boolean value that specifies whether the property is required.</p>', 'PropertyDefinitionRequest$isStoredExternally' => '<p>A Boolean value that specifies whether the property is stored externally.</p>', 'PropertyDefinitionRequest$isTimeSeries' => '<p>A Boolean value that specifies whether the property consists of time series data.</p>', 'PropertyDefinitionResponse$isExternalId' => '<p>A Boolean value that specifies whether the property ID comes from an external data store.</p>', 'PropertyDefinitionResponse$isFinal' => '<p>A Boolean value that specifies whether the property definition can be updated.</p>', 'PropertyDefinitionResponse$isImported' => '<p>A Boolean value that specifies whether the property definition is imported from an external data store.</p>', 'PropertyDefinitionResponse$isInherited' => '<p>A Boolean value that specifies whether the property definition is inherited from a parent entity.</p>', 'PropertyDefinitionResponse$isRequiredInEntity' => '<p>A Boolean value that specifies whether the property is required in an entity.</p>', 'PropertyDefinitionResponse$isStoredExternally' => '<p>A Boolean value that specifies whether the property is stored externally.</p>', 'PropertyDefinitionResponse$isTimeSeries' => '<p>A Boolean value that specifies whether the property consists of time series data.</p>', 'UpdateComponentTypeRequest$isSingleton' => '<p>A Boolean value that specifies whether an entity can have more than one component of this type.</p>', ], ], 'ComponentRequest' => [ 'base' => '<p>An object that sets information about a component type create or update request.</p>', 'refs' => [ 'ComponentsMapRequest$value' => NULL, ], ], 'ComponentResponse' => [ 'base' => '<p>An object that returns information about a component type create or update request.</p>', 'refs' => [ 'ComponentsMap$value' => NULL, ], ], 'ComponentTypeId' => [ 'base' => NULL, 'refs' => [ 'ComponentRequest$componentTypeId' => '<p>The ID of the component type.</p>', 'ComponentResponse$componentTypeId' => '<p>The ID of the component type.</p>', 'ComponentTypeSummary$componentTypeId' => '<p>The ID of the component type.</p>', 'ComponentUpdateRequest$componentTypeId' => '<p>The ID of the component type.</p>', 'CreateComponentTypeRequest$componentTypeId' => '<p>The ID of the component type.</p>', 'DeleteComponentTypeRequest$componentTypeId' => '<p>The ID of the component type to delete.</p>', 'ExtendsFrom$member' => NULL, 'GetComponentTypeRequest$componentTypeId' => '<p>The ID of the component type.</p>', 'GetComponentTypeResponse$componentTypeId' => '<p>The ID of the component type.</p>', 'GetPropertyValueHistoryRequest$componentTypeId' => '<p>The ID of the component type.</p>', 'GetPropertyValueRequest$componentTypeId' => '<p>The ID of the component type whose property values the operation returns.</p>', 'ListComponentTypesFilter$extendsFrom' => '<p>The component type that the component types in the list extend.</p>', 'ListEntitiesFilter$componentTypeId' => '<p>The ID of the component type in the entities in the list.</p>', 'Relationship$targetComponentTypeId' => '<p>The ID of the target component type associated with this relationship.</p>', 'UpdateComponentTypeRequest$componentTypeId' => '<p>The ID of the component type.</p>', 'UpdateComponentTypeResponse$componentTypeId' => '<p>The ID of the component type.</p>', ], ], 'ComponentTypeSummaries' => [ 'base' => NULL, 'refs' => [ 'ListComponentTypesResponse$componentTypeSummaries' => '<p>A list of objects that contain information about the component types.</p>', ], ], 'ComponentTypeSummary' => [ 'base' => '<p>An object that contains information about a component type.</p>', 'refs' => [ 'ComponentTypeSummaries$member' => NULL, ], ], 'ComponentUpdateRequest' => [ 'base' => '<p>The component update request.</p>', 'refs' => [ 'ComponentUpdatesMapRequest$value' => NULL, ], ], 'ComponentUpdateType' => [ 'base' => NULL, 'refs' => [ 'ComponentUpdateRequest$updateType' => '<p>The update type of the component update request.</p>', ], ], 'ComponentUpdatesMapRequest' => [ 'base' => NULL, 'refs' => [ 'UpdateEntityRequest$componentUpdates' => '<p>An object that maps strings to the component updates in the request. Each string in the mapping must be unique to this object.</p>', ], ], 'ComponentsMap' => [ 'base' => NULL, 'refs' => [ 'GetEntityResponse$components' => '<p>An object that maps strings to the components in the entity. Each string in the mapping must be unique to this object.</p>', ], ], 'ComponentsMapRequest' => [ 'base' => NULL, 'refs' => [ 'CreateEntityRequest$components' => '<p>An object that maps strings to the components in the entity. Each string in the mapping must be unique to this object.</p>', ], ], 'Configuration' => [ 'base' => NULL, 'refs' => [ 'PropertyDefinitionRequest$configuration' => '<p>A mapping that specifies configuration information about the property. Use this field to specify information that you read from and write to an external source.</p>', 'PropertyDefinitionResponse$configuration' => '<p>A mapping that specifies configuration information about the property.</p>', ], ], 'ConflictException' => [ 'base' => '<p>A conflict occurred.</p>', 'refs' => [], ], 'ConnectorFailureException' => [ 'base' => '<p>The connector failed.</p>', 'refs' => [], ], 'ConnectorTimeoutException' => [ 'base' => '<p>The connector timed out.</p>', 'refs' => [], ], 'CreateComponentTypeRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateComponentTypeResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateEntityRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateEntityResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateSceneRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateSceneResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateWorkspaceRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateWorkspaceResponse' => [ 'base' => NULL, 'refs' => [], ], 'DataConnector' => [ 'base' => '<p>The data connector.</p>', 'refs' => [ 'FunctionRequest$implementedBy' => '<p>The data connector.</p>', 'FunctionResponse$implementedBy' => '<p>The data connector.</p>', ], ], 'DataType' => [ 'base' => '<p>An object that specifies the data type of a property.</p>', 'refs' => [ 'DataType$nestedType' => '<p>The nested type in the data type.</p>', 'PropertyDefinitionRequest$dataType' => '<p>An object that contains information about the data type.</p>', 'PropertyDefinitionResponse$dataType' => '<p>An object that contains information about the data type.</p>', ], ], 'DataValue' => [ 'base' => '<p>An object that specifies a value for a property.</p>', 'refs' => [ 'DataValueList$member' => NULL, 'DataValueMap$value' => NULL, 'PropertyDefinitionRequest$defaultValue' => '<p>An object that contains the default value.</p>', 'PropertyDefinitionResponse$defaultValue' => '<p>An object that contains the default value.</p>', 'PropertyFilter$value' => '<p>The value associated with this property filter.</p>', 'PropertyLatestValue$propertyValue' => '<p>The value of the property.</p>', 'PropertyRequest$value' => '<p>The value of the property.</p>', 'PropertyResponse$value' => '<p>The value of the property.</p>', 'PropertyValue$value' => '<p>An object that specifies a value for a time series property.</p>', ], ], 'DataValueList' => [ 'base' => NULL, 'refs' => [ 'DataType$allowedValues' => '<p>The allowed values for this data type.</p>', 'DataValue$listValue' => '<p>A list of multiple values.</p>', ], ], 'DataValueMap' => [ 'base' => NULL, 'refs' => [ 'DataValue$mapValue' => '<p>An object that maps strings to multiple <code>DataValue</code> objects.</p>', ], ], 'DeleteComponentTypeRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteComponentTypeResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteEntityRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteEntityResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteSceneRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteSceneResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteWorkspaceRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteWorkspaceResponse' => [ 'base' => NULL, 'refs' => [], ], 'Description' => [ 'base' => NULL, 'refs' => [ 'ComponentRequest$description' => '<p>The description of the component request.</p>', 'ComponentResponse$description' => '<p>The description of the component type.</p>', 'ComponentTypeSummary$description' => '<p>The description of the component type.</p>', 'ComponentUpdateRequest$description' => '<p>The description of the component type.</p>', 'CreateComponentTypeRequest$description' => '<p>The description of the component type.</p>', 'CreateEntityRequest$description' => '<p>The description of the entity.</p>', 'CreateSceneRequest$description' => '<p>The description for this scene.</p>', 'CreateWorkspaceRequest$description' => '<p>The description of the workspace.</p>', 'EntitySummary$description' => '<p>The description of the entity.</p>', 'GetComponentTypeResponse$description' => '<p>The description of the component type.</p>', 'GetEntityResponse$description' => '<p>The description of the entity.</p>', 'GetSceneResponse$description' => '<p>The description of the scene.</p>', 'GetWorkspaceResponse$description' => '<p>The description of the workspace.</p>', 'SceneSummary$description' => '<p>The scene description.</p>', 'UpdateComponentTypeRequest$description' => '<p>The description of the component type.</p>', 'UpdateEntityRequest$description' => '<p>The description of the entity.</p>', 'UpdateSceneRequest$description' => '<p>The description of this scene.</p>', 'UpdateWorkspaceRequest$description' => '<p>The description of the workspace.</p>', 'WorkspaceSummary$description' => '<p>The description of the workspace.</p>', ], ], 'Double' => [ 'base' => NULL, 'refs' => [ 'DataValue$doubleValue' => '<p>A double value.</p>', ], ], 'EntityId' => [ 'base' => NULL, 'refs' => [ 'CreateEntityRequest$entityId' => '<p>The ID of the entity.</p>', 'CreateEntityResponse$entityId' => '<p>The ID of the entity.</p>', 'DeleteEntityRequest$entityId' => '<p>The ID of the entity to delete.</p>', 'EntityPropertyReference$entityId' => '<p>The ID of the entity.</p>', 'EntitySummary$entityId' => '<p>The ID of the entity.</p>', 'GetEntityRequest$entityId' => '<p>The ID of the entity.</p>', 'GetEntityResponse$entityId' => '<p>The ID of the entity.</p>', 'GetPropertyValueHistoryRequest$entityId' => '<p>The ID of the entity.</p>', 'GetPropertyValueRequest$entityId' => '<p>The ID of the entity whose property values the operation returns.</p>', 'RelationshipValue$targetEntityId' => '<p>The ID of the target entity associated with this relationship value.</p>', 'UpdateEntityRequest$entityId' => '<p>The ID of the entity.</p>', ], ], 'EntityName' => [ 'base' => NULL, 'refs' => [ 'CreateEntityRequest$entityName' => '<p>The name of the entity.</p>', 'EntitySummary$entityName' => '<p>The name of the entity.</p>', 'GetEntityResponse$entityName' => '<p>The name of the entity.</p>', 'UpdateEntityRequest$entityName' => '<p>The name of the entity.</p>', ], ], 'EntityPropertyReference' => [ 'base' => '<p>An object that uniquely identifies an entity property.</p>', 'refs' => [ 'PropertyLatestValue$propertyReference' => '<p>An object that specifies information about a property.&gt;</p>', 'PropertyValueEntry$entityPropertyReference' => '<p>An object that contains information about the entity that has the property.</p>', 'PropertyValueHistory$entityPropertyReference' => '<p>An object that uniquely identifies an entity property.</p>', ], ], 'EntitySummaries' => [ 'base' => NULL, 'refs' => [ 'ListEntitiesResponse$entitySummaries' => '<p>A list of objects that contain information about the entities.</p>', ], ], 'EntitySummary' => [ 'base' => '<p>An object that contains information about an entity.</p>', 'refs' => [ 'EntitySummaries$member' => NULL, ], ], 'Entries' => [ 'base' => NULL, 'refs' => [ 'BatchPutPropertyValuesRequest$entries' => '<p>An object that maps strings to the property value entries to set. Each string in the mapping must be unique to this object.</p>', ], ], 'ErrorCode' => [ 'base' => NULL, 'refs' => [ 'ErrorDetails$code' => '<p>The error code.</p>', ], ], 'ErrorDetails' => [ 'base' => '<p>The error details.</p>', 'refs' => [ 'Status$error' => '<p>The error message.</p>', ], ], 'ErrorEntries' => [ 'base' => NULL, 'refs' => [ 'BatchPutPropertyValuesResponse$errorEntries' => '<p>Entries that caused errors in the batch put operation.</p>', ], ], 'ErrorMessage' => [ 'base' => NULL, 'refs' => [ 'AccessDeniedException$message' => NULL, 'ConflictException$message' => NULL, 'ConnectorFailureException$message' => NULL, 'ConnectorTimeoutException$message' => NULL, 'ErrorDetails$message' => '<p>The error message.</p>', 'InternalServerException$message' => NULL, 'ResourceNotFoundException$message' => NULL, 'ServiceQuotaExceededException$message' => NULL, 'ThrottlingException$message' => NULL, 'ValidationException$message' => NULL, ], ], 'Errors' => [ 'base' => NULL, 'refs' => [ 'BatchPutPropertyErrorEntry$errors' => '<p>A list of objects that contain information about errors returned by the <code>BatchPutProperty</code> action.</p>', ], ], 'ExceptionMessage' => [ 'base' => NULL, 'refs' => [ 'TooManyTagsException$message' => NULL, ], ], 'Expression' => [ 'base' => NULL, 'refs' => [ 'DataValue$expression' => '<p>An expression that produces the value.</p>', ], ], 'ExtendsFrom' => [ 'base' => NULL, 'refs' => [ 'CreateComponentTypeRequest$extendsFrom' => '<p>Specifies the parent component type to extend.</p>', 'GetComponentTypeResponse$extendsFrom' => '<p>The name of the parent component type that this component type extends.</p>', 'UpdateComponentTypeRequest$extendsFrom' => '<p>Specifies the component type that this component type extends.</p>', ], ], 'ExternalIdProperty' => [ 'base' => NULL, 'refs' => [ 'EntityPropertyReference$externalIdProperty' => '<p>A mapping of external IDs to property names. External IDs uniquely identify properties from external data stores.</p>', ], ], 'FunctionRequest' => [ 'base' => '<p>The function request body.</p>', 'refs' => [ 'FunctionsRequest$value' => NULL, ], ], 'FunctionResponse' => [ 'base' => '<p>The function response.</p>', 'refs' => [ 'FunctionsResponse$value' => NULL, ], ], 'FunctionsRequest' => [ 'base' => NULL, 'refs' => [ 'CreateComponentTypeRequest$functions' => '<p>An object that maps strings to the functions in the component type. Each string in the mapping must be unique to this object.</p>', 'UpdateComponentTypeRequest$functions' => '<p>An object that maps strings to the functions in the component type. Each string in the mapping must be unique to this object.</p>', ], ], 'FunctionsResponse' => [ 'base' => NULL, 'refs' => [ 'GetComponentTypeResponse$functions' => '<p>An object that maps strings to the functions in the component type. Each string in the mapping must be unique to this object.</p>', ], ], 'GetComponentTypeRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetComponentTypeResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetEntityRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetEntityResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetPropertyValueHistoryRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetPropertyValueHistoryResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetPropertyValueRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetPropertyValueResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetSceneRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetSceneResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetWorkspaceRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetWorkspaceResponse' => [ 'base' => NULL, 'refs' => [], ], 'Id' => [ 'base' => NULL, 'refs' => [ 'BatchPutPropertyValuesRequest$workspaceId' => '<p>The ID of the workspace that contains the properties to set.</p>', 'CreateComponentTypeRequest$workspaceId' => '<p>The ID of the workspace that contains the component type.</p>', 'CreateEntityRequest$workspaceId' => '<p>The ID of the workspace that contains the entity.</p>', 'CreateSceneRequest$sceneId' => '<p>The ID of the scene.</p>', 'CreateSceneRequest$workspaceId' => '<p>The ID of the workspace that contains the scene.</p>', 'CreateWorkspaceRequest$workspaceId' => '<p>The ID of the workspace.</p>', 'DeleteComponentTypeRequest$workspaceId' => '<p>The ID of the workspace that contains the component type.</p>', 'DeleteEntityRequest$workspaceId' => '<p>The ID of the workspace that contains the entity to delete.</p>', 'DeleteSceneRequest$sceneId' => '<p>The ID of the scene to delete.</p>', 'DeleteSceneRequest$workspaceId' => '<p>The ID of the workspace.</p>', 'DeleteWorkspaceRequest$workspaceId' => '<p>The ID of the workspace to delete.</p>', 'GetComponentTypeRequest$workspaceId' => '<p>The ID of the workspace that contains the component type.</p>', 'GetComponentTypeResponse$workspaceId' => '<p>The ID of the workspace that contains the component type.</p>', 'GetEntityRequest$workspaceId' => '<p>The ID of the workspace.</p>', 'GetEntityResponse$workspaceId' => '<p>The ID of the workspace.</p>', 'GetPropertyValueHistoryRequest$workspaceId' => '<p>The ID of the workspace.</p>', 'GetPropertyValueRequest$workspaceId' => '<p>The ID of the workspace whose values the operation returns.</p>', 'GetSceneRequest$sceneId' => '<p>The ID of the scene.</p>', 'GetSceneRequest$workspaceId' => '<p>The ID of the workspace that contains the scene.</p>', 'GetSceneResponse$sceneId' => '<p>The ID of the scene.</p>', 'GetSceneResponse$workspaceId' => '<p>The ID of the workspace that contains the scene.</p>', 'GetWorkspaceResponse$workspaceId' => '<p>The ID of the workspace.</p>', 'ListComponentTypesRequest$workspaceId' => '<p>The ID of the workspace.</p>', 'ListComponentTypesResponse$workspaceId' => '<p>The ID of the workspace.</p>', 'ListEntitiesRequest$workspaceId' => '<p>The ID of the workspace.</p>', 'ListScenesRequest$workspaceId' => '<p>The ID of the workspace that contains the scenes.</p>', 'SceneSummary$sceneId' => '<p>The ID of the scene.</p>', 'UpdateComponentTypeRequest$workspaceId' => '<p>The ID of the workspace that contains the component type.</p>', 'UpdateComponentTypeResponse$workspaceId' => '<p>The ID of the workspace that contains the component type.</p>', 'UpdateEntityRequest$workspaceId' => '<p>The ID of the workspace that contains the entity.</p>', 'UpdateSceneRequest$sceneId' => '<p>The ID of the scene.</p>', 'UpdateSceneRequest$workspaceId' => '<p>The ID of the workspace that contains the scene.</p>', 'UpdateWorkspaceRequest$workspaceId' => '<p>The ID of the workspace.</p>', 'WorkspaceSummary$workspaceId' => '<p>The ID of the workspace.</p>', ], ], 'IdOrArn' => [ 'base' => NULL, 'refs' => [ 'GetWorkspaceRequest$workspaceId' => '<p>The ID of the workspace.</p>', ], ], 'Integer' => [ 'base' => NULL, 'refs' => [ 'DataValue$integerValue' => '<p>An integer value.</p>', ], ], 'InternalServerException' => [ 'base' => '<p>An unexpected error has occurred.</p>', 'refs' => [], ], 'InterpolationParameters' => [ 'base' => '<p>An object that specifies how to interpolate data in a list.</p>', 'refs' => [ 'GetPropertyValueHistoryRequest$interpolation' => '<p>An object that specifies the interpolation type and the interval over which to interpolate data.</p>', ], ], 'InterpolationType' => [ 'base' => NULL, 'refs' => [ 'InterpolationParameters$interpolationType' => '<p>The interpolation type.</p>', ], ], 'IntervalInSeconds' => [ 'base' => NULL, 'refs' => [ 'InterpolationParameters$intervalInSeconds' => '<p>The interpolation time interval in seconds.</p>', ], ], 'LambdaArn' => [ 'base' => NULL, 'refs' => [ 'LambdaFunction$arn' => '<p>The ARN of the Lambda function.</p>', ], ], 'LambdaFunction' => [ 'base' => '<p>The Lambda function.</p>', 'refs' => [ 'DataConnector$lambda' => '<p>The Lambda function associated with this data connector.</p>', ], ], 'ListComponentTypesFilter' => [ 'base' => '<p>An object that filters items in a list of component types.</p> <note> <p>Only one object is accepted as a valid input.</p> </note>', 'refs' => [ 'ListComponentTypesFilters$member' => NULL, ], ], 'ListComponentTypesFilters' => [ 'base' => NULL, 'refs' => [ 'ListComponentTypesRequest$filters' => '<p>A list of objects that filter the request.</p>', ], ], 'ListComponentTypesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListComponentTypesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListEntitiesFilter' => [ 'base' => '<p>An object that filters items in a list of entities.</p>', 'refs' => [ 'ListEntitiesFilters$member' => NULL, ], ], 'ListEntitiesFilters' => [ 'base' => NULL, 'refs' => [ 'ListEntitiesRequest$filters' => '<p>A list of objects that filter the request.</p> <note> <p>Only one object is accepted as a valid input.</p> </note>', ], ], 'ListEntitiesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListEntitiesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListScenesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListScenesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListWorkspacesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListWorkspacesResponse' => [ 'base' => NULL, 'refs' => [], ], 'Long' => [ 'base' => NULL, 'refs' => [ 'DataValue$longValue' => '<p>A long value.</p>', ], ], 'MaxResults' => [ 'base' => NULL, 'refs' => [ 'GetPropertyValueHistoryRequest$maxResults' => '<p>The maximum number of results to return.</p>', 'ListComponentTypesRequest$maxResults' => '<p>The maximum number of results to display.</p>', 'ListComponentTypesResponse$maxResults' => '<p>Specifies the maximum number of results to display.</p>', 'ListEntitiesRequest$maxResults' => '<p>The maximum number of results to display.</p>', 'ListScenesRequest$maxResults' => '<p>Specifies the maximum number of results to display.</p>', 'ListTagsForResourceRequest$maxResults' => '<p>The maximum number of results to display.</p>', 'ListWorkspacesRequest$maxResults' => '<p>The maximum number of results to display.</p>', ], ], 'Name' => [ 'base' => NULL, 'refs' => [ 'ComponentResponse$componentName' => '<p>The name of the component.</p>', 'ComponentUpdatesMapRequest$key' => NULL, 'ComponentsMap$key' => NULL, 'ComponentsMapRequest$key' => NULL, 'Configuration$key' => NULL, 'EntityPropertyReference$componentName' => '<p>The name of the component.</p>', 'EntityPropertyReference$propertyName' => '<p>The name of the property.</p>', 'FunctionsRequest$key' => NULL, 'FunctionsResponse$key' => NULL, 'GetPropertyValueHistoryRequest$componentName' => '<p>The name of the component.</p>', 'GetPropertyValueRequest$componentName' => '<p>The name of the component whose property values the operation returns.</p>', 'PropertyDefinitionsRequest$key' => NULL, 'PropertyDefinitionsResponse$key' => NULL, 'PropertyLatestValueMap$key' => NULL, 'PropertyRequests$key' => NULL, 'PropertyResponses$key' => NULL, 'RelationshipValue$targetComponentName' => '<p>The name of the target component associated with the relationship value.</p>', 'RequiredProperties$member' => NULL, ], ], 'NextToken' => [ 'base' => NULL, 'refs' => [ 'GetPropertyValueHistoryRequest$nextToken' => '<p>The string that specifies the next page of results.</p>', 'GetPropertyValueHistoryResponse$nextToken' => '<p>The string that specifies the next page of results.</p>', 'ListComponentTypesRequest$nextToken' => '<p>The string that specifies the next page of results.</p>', 'ListComponentTypesResponse$nextToken' => '<p>The string that specifies the next page of results.</p>', 'ListEntitiesRequest$nextToken' => '<p>The string that specifies the next page of results.</p>', 'ListEntitiesResponse$nextToken' => '<p>The string that specifies the next page of results.</p>', 'ListScenesRequest$nextToken' => '<p>The string that specifies the next page of results.</p>', 'ListScenesResponse$nextToken' => '<p>The string that specifies the next page of results.</p>', 'ListTagsForResourceRequest$nextToken' => '<p>The string that specifies the next page of results.</p>', 'ListTagsForResourceResponse$nextToken' => '<p>The string that specifies the next page of results.</p>', 'ListWorkspacesRequest$nextToken' => '<p>The string that specifies the next page of results.</p>', 'ListWorkspacesResponse$nextToken' => '<p>The string that specifies the next page of results.</p>', ], ], 'OrderByTime' => [ 'base' => NULL, 'refs' => [ 'GetPropertyValueHistoryRequest$orderByTime' => '<p>The time direction to use in the result order.</p>', ], ], 'ParentEntityId' => [ 'base' => NULL, 'refs' => [ 'CreateEntityRequest$parentEntityId' => '<p>The ID of the entity\'s parent entity.</p>', 'EntitySummary$parentEntityId' => '<p>The ID of the parent entity.</p>', 'GetEntityResponse$parentEntityId' => '<p>The ID of the parent entity for this entity.</p>', 'ListEntitiesFilter$parentEntityId' => '<p>The parent of the entities in the list.</p>', 'ParentEntityUpdateRequest$parentEntityId' => '<p>The ID of the parent entity.</p>', ], ], 'ParentEntityUpdateRequest' => [ 'base' => '<p>The parent entity update request.</p>', 'refs' => [ 'UpdateEntityRequest$parentEntityUpdate' => '<p>An object that describes the update request for a parent entity.</p>', ], ], 'ParentEntityUpdateType' => [ 'base' => NULL, 'refs' => [ 'ParentEntityUpdateRequest$updateType' => '<p>The type of the update.</p>', ], ], 'PropertyDefinitionRequest' => [ 'base' => '<p>An object that sets information about a property.</p>', 'refs' => [ 'PropertyDefinitionsRequest$value' => NULL, 'PropertyRequest$definition' => '<p>An object that specifies information about a property.</p>', ], ], 'PropertyDefinitionResponse' => [ 'base' => '<p>An object that contains response data from a property definition request.</p>', 'refs' => [ 'PropertyDefinitionsResponse$value' => NULL, 'PropertyResponse$definition' => '<p>An object that specifies information about a property.</p>', ], ], 'PropertyDefinitionsRequest' => [ 'base' => NULL, 'refs' => [ 'CreateComponentTypeRequest$propertyDefinitions' => '<p>An object that maps strings to the property definitions in the component type. Each string in the mapping must be unique to this object.</p>', 'UpdateComponentTypeRequest$propertyDefinitions' => '<p>An object that maps strings to the property definitions in the component type. Each string in the mapping must be unique to this object.</p>', ], ], 'PropertyDefinitionsResponse' => [ 'base' => NULL, 'refs' => [ 'GetComponentTypeResponse$propertyDefinitions' => '<p>An object that maps strings to the property definitions in the component type. Each string in the mapping must be unique to this object.</p>', ], ], 'PropertyFilter' => [ 'base' => '<p>An object that filters items returned by a property request.</p>', 'refs' => [ 'PropertyFilters$member' => NULL, ], ], 'PropertyFilters' => [ 'base' => NULL, 'refs' => [ 'GetPropertyValueHistoryRequest$propertyFilters' => '<p>A list of objects that filter the property value history request.</p>', ], ], 'PropertyLatestValue' => [ 'base' => '<p>The latest value of the property.</p>', 'refs' => [ 'PropertyLatestValueMap$value' => NULL, ], ], 'PropertyLatestValueMap' => [ 'base' => NULL, 'refs' => [ 'GetPropertyValueResponse$propertyValues' => '<p>An object that maps strings to the properties and latest property values in the response. Each string in the mapping must be unique to this object.</p>', ], ], 'PropertyRequest' => [ 'base' => '<p>An object that sets information about a property.</p>', 'refs' => [ 'PropertyRequests$value' => NULL, ], ], 'PropertyRequests' => [ 'base' => NULL, 'refs' => [ 'ComponentRequest$properties' => '<p>An object that maps strings to the properties to set in the component type. Each string in the mapping must be unique to this object.</p>', 'ComponentUpdateRequest$propertyUpdates' => '<p>An object that maps strings to the properties to set in the component type update. Each string in the mapping must be unique to this object.</p>', ], ], 'PropertyResponse' => [ 'base' => '<p>An object that contains information about a property response.</p>', 'refs' => [ 'PropertyResponses$value' => NULL, ], ], 'PropertyResponses' => [ 'base' => NULL, 'refs' => [ 'ComponentResponse$properties' => '<p>An object that maps strings to the properties to set in the component type. Each string in the mapping must be unique to this object.</p>', ], ], 'PropertyUpdateType' => [ 'base' => NULL, 'refs' => [ 'PropertyRequest$updateType' => '<p>The update type of the update property request.</p>', ], ], 'PropertyValue' => [ 'base' => '<p>An object that contains information about a value for a time series property.</p>', 'refs' => [ 'PropertyValues$member' => NULL, 'Values$member' => NULL, ], ], 'PropertyValueEntry' => [ 'base' => '<p>An object that specifies information about time series property values. This object is used and consumed by the <a href="https://docs.aws.amazon.com/iot-twinmaker/latest/apireference/API_BatchPutPropertyValues.html">BatchPutPropertyValues</a> action.</p>', 'refs' => [ 'BatchPutPropertyError$entry' => '<p>An object that contains information about errors returned by the <code>BatchPutProperty</code> action.</p>', 'Entries$member' => NULL, ], ], 'PropertyValueHistory' => [ 'base' => '<p>The history of values for a time series property.</p>', 'refs' => [ 'PropertyValueList$member' => NULL, ], ], 'PropertyValueList' => [ 'base' => NULL, 'refs' => [ 'GetPropertyValueHistoryResponse$propertyValues' => '<p>An object that maps strings to the property definitions in the component type. Each string in the mapping must be unique to this object.</p>', ], ], 'PropertyValues' => [ 'base' => NULL, 'refs' => [ 'PropertyValueEntry$propertyValues' => '<p>A list of objects that specify time series property values.</p>', ], ], 'Relationship' => [ 'base' => '<p>An object that specifies a relationship with another component type.</p>', 'refs' => [ 'DataType$relationship' => '<p>A relationship that associates a component with another component.</p>', ], ], 'RelationshipValue' => [ 'base' => '<p>A value that associates a component and an entity.</p>', 'refs' => [ 'DataValue$relationshipValue' => '<p>A value that relates a component to another component.</p>', ], ], 'RequiredProperties' => [ 'base' => NULL, 'refs' => [ 'FunctionRequest$requiredProperties' => '<p>The required properties of the function.</p>', 'FunctionResponse$requiredProperties' => '<p>The required properties of the function.</p>', ], ], 'ResourceNotFoundException' => [ 'base' => '<p>The resource wasn\'t found.</p>', 'refs' => [], ], 'RoleArn' => [ 'base' => NULL, 'refs' => [ 'CreateWorkspaceRequest$role' => '<p>The ARN of the execution role associated with the workspace.</p>', 'GetWorkspaceResponse$role' => '<p>The ARN of the execution role associated with the workspace.</p>', 'UpdateWorkspaceRequest$role' => '<p>The ARN of the execution role associated with the workspace.</p>', ], ], 'S3Location' => [ 'base' => NULL, 'refs' => [ 'CreateWorkspaceRequest$s3Location' => '<p>The ARN of the S3 bucket where resources associated with the workspace are stored.</p>', 'GetWorkspaceResponse$s3Location' => '<p>The ARN of the S3 bucket where resources associated with the workspace are stored.</p>', ], ], 'S3Url' => [ 'base' => NULL, 'refs' => [ 'CreateSceneRequest$contentLocation' => '<p>The relative path that specifies the location of the content definition file.</p>', 'GetSceneResponse$contentLocation' => '<p>The relative path that specifies the location of the content definition file.</p>', 'SceneSummary$contentLocation' => '<p>The relative path that specifies the location of the content definition file.</p>', 'UpdateSceneRequest$contentLocation' => '<p>The relative path that specifies the location of the content definition file.</p>', ], ], 'SceneCapabilities' => [ 'base' => NULL, 'refs' => [ 'CreateSceneRequest$capabilities' => '<p>A list of capabilities that the scene uses to render itself.</p>', 'GetSceneResponse$capabilities' => '<p>A list of capabilities that the scene uses to render.</p>', 'UpdateSceneRequest$capabilities' => '<p>A list of capabilities that the scene uses to render.</p>', ], ], 'SceneCapability' => [ 'base' => NULL, 'refs' => [ 'SceneCapabilities$member' => NULL, ], ], 'SceneSummaries' => [ 'base' => NULL, 'refs' => [ 'ListScenesResponse$sceneSummaries' => '<p>A list of objects that contain information about the scenes.</p>', ], ], 'SceneSummary' => [ 'base' => '<p>An object that contains information about a scene.</p>', 'refs' => [ 'SceneSummaries$member' => NULL, ], ], 'Scope' => [ 'base' => NULL, 'refs' => [ 'FunctionRequest$scope' => '<p>The scope of the function.</p>', 'FunctionResponse$scope' => '<p>The scope of the function.</p>', ], ], 'SelectedPropertyList' => [ 'base' => NULL, 'refs' => [ 'GetPropertyValueHistoryRequest$selectedProperties' => '<p>A list of properties whose value histories the request retrieves.</p>', 'GetPropertyValueRequest$selectedProperties' => '<p>The properties whose values the operation returns.</p>', ], ], 'ServiceQuotaExceededException' => [ 'base' => '<p>The service quota was exceeded.</p>', 'refs' => [], ], 'State' => [ 'base' => NULL, 'refs' => [ 'CreateComponentTypeResponse$state' => '<p>The current state of the component type.</p>', 'CreateEntityResponse$state' => '<p>The current state of the entity.</p>', 'DeleteComponentTypeResponse$state' => '<p>The current state of the component type to be deleted.</p>', 'DeleteEntityResponse$state' => '<p>The current state of the deleted entity.</p>', 'Status$state' => '<p>The current state of the entity, component, component type, or workspace.</p>', 'UpdateComponentTypeResponse$state' => '<p>The current state of the component type.</p>', 'UpdateEntityResponse$state' => '<p>The current state of the entity update.</p>', ], ], 'Status' => [ 'base' => '<p>An object that represents the status of an entity, component, component type, or workspace.</p>', 'refs' => [ 'ComponentResponse$status' => '<p>The status of the component type.</p>', 'ComponentTypeSummary$status' => '<p>The current status of the component type.</p>', 'EntitySummary$status' => '<p>The current status of the entity.</p>', 'GetComponentTypeResponse$status' => '<p>The current status of the component type.</p>', 'GetEntityResponse$status' => '<p>The current status of the entity.</p>', ], ], 'String' => [ 'base' => NULL, 'refs' => [ 'BatchPutPropertyError$errorCode' => '<p>The error code.</p>', 'BatchPutPropertyError$errorMessage' => '<p>The error message.</p>', 'ComponentResponse$definedIn' => '<p>The name of the property definition set in the request.</p>', 'DataType$unitOfMeasure' => '<p>The unit of measure used in this data type.</p>', 'DataValue$stringValue' => '<p>A string value.</p>', 'DataValueMap$key' => NULL, 'ExternalIdProperty$key' => NULL, 'ExternalIdProperty$value' => NULL, 'ListComponentTypesFilter$namespace' => '<p>The namespace to which the component types in the list belong.</p>', 'ListEntitiesFilter$externalId' => '<p>The external-Id property of a component. The external-Id property is the primary key of an external storage system.</p>', 'PropertyFilter$operator' => '<p>The operator associated with this property filter.</p>', 'PropertyFilter$propertyName' => '<p>The property name associated with this property filter.</p>', 'Relationship$relationshipType' => '<p>The type of the relationship.</p>', 'SelectedPropertyList$member' => NULL, ], ], 'TagKey' => [ 'base' => NULL, 'refs' => [ 'TagKeyList$member' => NULL, 'TagMap$key' => NULL, ], ], 'TagKeyList' => [ 'base' => NULL, 'refs' => [ 'UntagResourceRequest$tagKeys' => '<p>A list of tag key names to remove from the resource. You don\'t specify the value. Both the key and its associated value are removed.</p>', ], ], 'TagMap' => [ 'base' => NULL, 'refs' => [ 'CreateComponentTypeRequest$tags' => '<p>Metadata that you can use to manage the component type.</p>', 'CreateEntityRequest$tags' => '<p>Metadata that you can use to manage the entity.</p>', 'CreateSceneRequest$tags' => '<p>Metadata that you can use to manage the scene.</p>', 'CreateWorkspaceRequest$tags' => '<p>Metadata that you can use to manage the workspace</p>', 'ListTagsForResourceResponse$tags' => '<p>Metadata that you can use to manage a resource.</p>', 'TagResourceRequest$tags' => '<p>Metadata to add to this resource.</p>', ], ], 'TagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'TagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'TagValue' => [ 'base' => NULL, 'refs' => [ 'TagMap$value' => NULL, ], ], 'ThrottlingException' => [ 'base' => '<p>The rate exceeds the limit.</p>', 'refs' => [], ], 'Time' => [ 'base' => '<p>Timestamp represented in ISO 8601 format</p>', 'refs' => [ 'GetPropertyValueHistoryRequest$endTime' => '<p>The ISO8601 DateTime of the latest property value to return.</p> <p>For more information about the ISO8601 DateTime format, see the data type <a href="https://docs.aws.amazon.com/roci/latest/roci-api/API_PropertyValue.html">PropertyValue</a>.</p>', 'GetPropertyValueHistoryRequest$startTime' => '<p>The ISO8601 DateTime of the earliest property value to return.</p> <p>For more information about the ISO8601 DateTime format, see the data type <a href="https://docs.aws.amazon.com/roci/latest/roci-api/API_PropertyValue.html">PropertyValue</a>.</p>', 'PropertyValue$time' => '<p>ISO8601 DateTime of a value for a time series property.</p> <p>The time for when the property value was recorded in ISO 8601 format: <i>YYYY-MM-DDThh:mm:ss[.SSSSSSSSS][Z/±HH:mm]</i>.</p> <ul> <li> <p> <i>[YYYY]</i>: year</p> </li> <li> <p> <i>[MM]</i>: month</p> </li> <li> <p> <i>[DD]</i>: day</p> </li> <li> <p> <i>[hh]</i>: hour</p> </li> <li> <p> <i>[mm]</i>: minute</p> </li> <li> <p> <i>[ss]</i>: seconds</p> </li> <li> <p> <i>[.SSSSSSSSS]</i>: additional precision, where precedence is maintained. For example: [.573123] is equal to 573123000 nanoseconds.</p> </li> <li> <p> <i>Z</i>: default timezone UTC</p> </li> <li> <p> <i>± HH:mm</i>: time zone offset in Hours and Minutes.</p> </li> </ul> <p> <i>Required sub-fields</i>: YYYY-MM-DDThh:mm:ss and [Z/±HH:mm]</p>', ], ], 'Timestamp' => [ 'base' => '<p>supports epoch seconds value</p>', 'refs' => [ 'ComponentTypeSummary$creationDateTime' => '<p>The date and time when the component type was created.</p>', 'ComponentTypeSummary$updateDateTime' => '<p>The date and time when the component type was last updated.</p>', 'CreateComponentTypeResponse$creationDateTime' => '<p>The date and time when the entity was created.</p>', 'CreateEntityResponse$creationDateTime' => '<p>The date and time when the entity was created.</p>', 'CreateSceneResponse$creationDateTime' => '<p>The date and time when the scene was created.</p>', 'CreateWorkspaceResponse$creationDateTime' => '<p>The date and time when the workspace was created.</p>', 'EntitySummary$creationDateTime' => '<p>The date and time when the entity was created.</p>', 'EntitySummary$updateDateTime' => '<p>The last date and time when the entity was updated.</p>', 'GetComponentTypeResponse$creationDateTime' => '<p>The date and time when the component type was created.</p>', 'GetComponentTypeResponse$updateDateTime' => '<p>The date and time when the component was last updated.</p>', 'GetEntityResponse$creationDateTime' => '<p>The date and time when the entity was created.</p>', 'GetEntityResponse$updateDateTime' => '<p>The date and time when the entity was last updated.</p>', 'GetPropertyValueHistoryRequest$endDateTime' => '<p>The date and time of the latest property value to return.</p>', 'GetPropertyValueHistoryRequest$startDateTime' => '<p>The date and time of the earliest property value to return.</p>', 'GetSceneResponse$creationDateTime' => '<p>The date and time when the scene was created.</p>', 'GetSceneResponse$updateDateTime' => '<p>The date and time when the scene was last updated.</p>', 'GetWorkspaceResponse$creationDateTime' => '<p>The date and time when the workspace was created.</p>', 'GetWorkspaceResponse$updateDateTime' => '<p>The date and time when the workspace was last updated.</p>', 'PropertyValue$timestamp' => '<p>The timestamp of a value for a time series property.</p>', 'SceneSummary$creationDateTime' => '<p>The date and time when the scene was created.</p>', 'SceneSummary$updateDateTime' => '<p>The date and time when the scene was last updated.</p>', 'UpdateEntityResponse$updateDateTime' => '<p>The date and time when the entity was last updated.</p>', 'UpdateSceneResponse$updateDateTime' => '<p>The date and time when the scene was last updated.</p>', 'UpdateWorkspaceResponse$updateDateTime' => '<p>The date and time of the current update.</p>', 'WorkspaceSummary$creationDateTime' => '<p>The date and time when the workspace was created.</p>', 'WorkspaceSummary$updateDateTime' => '<p>The date and time when the workspace was last updated.</p>', ], ], 'TooManyTagsException' => [ 'base' => '<p>The number of tags exceeds the limit.</p>', 'refs' => [], ], 'TwinMakerArn' => [ 'base' => NULL, 'refs' => [ 'ComponentTypeSummary$arn' => '<p>The ARN of the component type.</p>', 'CreateComponentTypeResponse$arn' => '<p>The ARN of the component type.</p>', 'CreateEntityResponse$arn' => '<p>The ARN of the entity.</p>', 'CreateSceneResponse$arn' => '<p>The ARN of the scene.</p>', 'CreateWorkspaceResponse$arn' => '<p>The ARN of the workspace.</p>', 'EntitySummary$arn' => '<p>The ARN of the entity.</p>', 'GetComponentTypeResponse$arn' => '<p>The ARN of the component type.</p>', 'GetEntityResponse$arn' => '<p>The ARN of the entity.</p>', 'GetSceneResponse$arn' => '<p>The ARN of the scene.</p>', 'GetWorkspaceResponse$arn' => '<p>The ARN of the workspace.</p>', 'ListTagsForResourceRequest$resourceARN' => '<p>The ARN of the resource.</p>', 'SceneSummary$arn' => '<p>The ARN of the scene.</p>', 'TagResourceRequest$resourceARN' => '<p>The ARN of the resource.</p>', 'UntagResourceRequest$resourceARN' => '<p>The ARN of the resource.</p>', 'UpdateComponentTypeResponse$arn' => '<p>The ARN of the component type.</p>', 'WorkspaceSummary$arn' => '<p>The ARN of the workspace.</p>', ], ], 'Type' => [ 'base' => NULL, 'refs' => [ 'DataType$type' => '<p>The underlying type of the data type.</p>', ], ], 'UntagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'UntagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateComponentTypeRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateComponentTypeResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateEntityRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateEntityResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateSceneRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateSceneResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateWorkspaceRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateWorkspaceResponse' => [ 'base' => NULL, 'refs' => [], ], 'ValidationException' => [ 'base' => '<p>Failed</p>', 'refs' => [], ], 'Value' => [ 'base' => NULL, 'refs' => [ 'Configuration$value' => NULL, ], ], 'Values' => [ 'base' => NULL, 'refs' => [ 'PropertyValueHistory$values' => '<p>A list of objects that contain information about the values in the history of a time series property.</p>', ], ], 'WorkspaceSummaries' => [ 'base' => NULL, 'refs' => [ 'ListWorkspacesResponse$workspaceSummaries' => '<p>A list of objects that contain information about the workspaces.</p>', ], ], 'WorkspaceSummary' => [ 'base' => '<p>An object that contains information about a workspace.</p>', 'refs' => [ 'WorkspaceSummaries$member' => NULL, ], ], ],];
