<?php
// This file was auto-generated from sdk-root/src/data/greengrassv2/2020-11-30/docs-2.json
return [ 'version' => '2.0', 'service' => '<p>IoT Greengrass brings local compute, messaging, data management, sync, and ML inference capabilities to edge devices. This enables devices to collect and analyze data closer to the source of information, react autonomously to local events, and communicate securely with each other on local networks. Local devices can also communicate securely with Amazon Web Services IoT Core and export IoT data to the Amazon Web Services Cloud. IoT Greengrass developers can use Lambda functions and components to create and deploy applications to fleets of edge devices for local operation.</p> <p>IoT Greengrass Version 2 provides a new major version of the IoT Greengrass Core software, new APIs, and a new console. Use this API reference to learn how to use the IoT Greengrass V2 API operations to manage components, manage deployments, and core devices.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/what-is-iot-greengrass.html">What is IoT Greengrass?</a> in the <i>IoT Greengrass V2 Developer Guide</i>.</p>', 'operations' => [ 'AssociateServiceRoleToAccount' => '<p>Associates a Greengrass service role with IoT Greengrass for your Amazon Web Services account in this Amazon Web Services Region. IoT Greengrass uses this role to verify the identity of client devices and manage core device connectivity information. The role must include the <a href="https://console.aws.amazon.com/iam/home#/policies/arn:awsiam::aws:policy/service-role/AWSGreengrassResourceAccessRolePolicy">AWSGreengrassResourceAccessRolePolicy</a> managed policy or a custom policy that defines equivalent permissions for the IoT Greengrass features that you use. For more information, see <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/greengrass-service-role.html">Greengrass service role</a> in the <i>IoT Greengrass Version 2 Developer Guide</i>.</p>', 'BatchAssociateClientDeviceWithCoreDevice' => '<p>Associates a list of client devices with a core device. Use this API operation to specify which client devices can discover a core device through cloud discovery. With cloud discovery, client devices connect to IoT Greengrass to retrieve associated core devices\' connectivity information and certificates. For more information, see <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/configure-cloud-discovery.html">Configure cloud discovery</a> in the <i>IoT Greengrass V2 Developer Guide</i>.</p> <note> <p>Client devices are local IoT devices that connect to and communicate with an IoT Greengrass core device over MQTT. You can connect client devices to a core device to sync MQTT messages and data to Amazon Web Services IoT Core and interact with client devices in Greengrass components. For more information, see <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/interact-with-local-iot-devices.html">Interact with local IoT devices</a> in the <i>IoT Greengrass V2 Developer Guide</i>.</p> </note>', 'BatchDisassociateClientDeviceFromCoreDevice' => '<p>Disassociates a list of client devices from a core device. After you disassociate a client device from a core device, the client device won\'t be able to use cloud discovery to retrieve the core device\'s connectivity information and certificates.</p>', 'CancelDeployment' => '<p>Cancels a deployment. This operation cancels the deployment for devices that haven\'t yet received it. If a device already received the deployment, this operation doesn\'t change anything for that device.</p>', 'CreateComponentVersion' => '<p>Creates a component. Components are software that run on Greengrass core devices. After you develop and test a component on your core device, you can use this operation to upload your component to IoT Greengrass. Then, you can deploy the component to other core devices.</p> <p>You can use this operation to do the following:</p> <ul> <li> <p> <b>Create components from recipes</b> </p> <p>Create a component from a recipe, which is a file that defines the component\'s metadata, parameters, dependencies, lifecycle, artifacts, and platform capability. For more information, see <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/component-recipe-reference.html">IoT Greengrass component recipe reference</a> in the <i>IoT Greengrass V2 Developer Guide</i>.</p> <p>To create a component from a recipe, specify <code>inlineRecipe</code> when you call this operation.</p> </li> <li> <p> <b>Create components from Lambda functions</b> </p> <p>Create a component from an Lambda function that runs on IoT Greengrass. This creates a recipe and artifacts from the Lambda function\'s deployment package. You can use this operation to migrate Lambda functions from IoT Greengrass V1 to IoT Greengrass V2.</p> <p>This function only accepts Lambda functions that use the following runtimes:</p> <ul> <li> <p>Python 2.7 – <code>python2.7</code> </p> </li> <li> <p>Python 3.7 – <code>python3.7</code> </p> </li> <li> <p>Python 3.8 – <code>python3.8</code> </p> </li> <li> <p>Java 8 – <code>java8</code> </p> </li> <li> <p>Node.js 10 – <code>nodejs10.x</code> </p> </li> <li> <p>Node.js 12 – <code>nodejs12.x</code> </p> </li> </ul> <p>To create a component from a Lambda function, specify <code>lambdaFunction</code> when you call this operation.</p> <note> <p>IoT Greengrass currently supports Lambda functions on only Linux core devices.</p> </note> </li> </ul>', 'CreateDeployment' => '<p>Creates a continuous deployment for a target, which is a Greengrass core device or group of core devices. When you add a new core device to a group of core devices that has a deployment, IoT Greengrass deploys that group\'s deployment to the new device.</p> <p>You can define one deployment for each target. When you create a new deployment for a target that has an existing deployment, you replace the previous deployment. IoT Greengrass applies the new deployment to the target devices.</p> <p>Every deployment has a revision number that indicates how many deployment revisions you define for a target. Use this operation to create a new revision of an existing deployment.</p> <p>For more information, see the <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/create-deployments.html">Create deployments</a> in the <i>IoT Greengrass V2 Developer Guide</i>.</p>', 'DeleteComponent' => '<p>Deletes a version of a component from IoT Greengrass.</p> <note> <p>This operation deletes the component\'s recipe and artifacts. As a result, deployments that refer to this component version will fail. If you have deployments that use this component version, you can remove the component from the deployment or update the deployment to use a valid version.</p> </note>', 'DeleteCoreDevice' => '<p>Deletes a Greengrass core device, which is an IoT thing. This operation removes the core device from the list of core devices. This operation doesn\'t delete the IoT thing. For more information about how to delete the IoT thing, see <a href="https://docs.aws.amazon.com/iot/latest/apireference/API_DeleteThing.html">DeleteThing</a> in the <i>IoT API Reference</i>.</p>', 'DescribeComponent' => '<p>Retrieves metadata for a version of a component.</p>', 'DisassociateServiceRoleFromAccount' => '<p>Disassociates the Greengrass service role from IoT Greengrass for your Amazon Web Services account in this Amazon Web Services Region. Without a service role, IoT Greengrass can\'t verify the identity of client devices or manage core device connectivity information. For more information, see <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/greengrass-service-role.html">Greengrass service role</a> in the <i>IoT Greengrass Version 2 Developer Guide</i>.</p>', 'GetComponent' => '<p>Gets the recipe for a version of a component. Core devices can call this operation to identify the artifacts and requirements to install a component.</p>', 'GetComponentVersionArtifact' => '<p>Gets the pre-signed URL to download a public component artifact. Core devices call this operation to identify the URL that they can use to download an artifact to install.</p>', 'GetConnectivityInfo' => '<p>Retrieves connectivity information for a Greengrass core device.</p> <p>Connectivity information includes endpoints and ports where client devices can connect to an MQTT broker on the core device. When a client device calls the <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/greengrass-discover-api.html">IoT Greengrass discovery API</a>, IoT Greengrass returns connectivity information for all of the core devices where the client device can connect. For more information, see <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/connect-client-devices.html">Connect client devices to core devices</a> in the <i>IoT Greengrass Version 2 Developer Guide</i>.</p>', 'GetCoreDevice' => '<p>Retrieves metadata for a Greengrass core device.</p>', 'GetDeployment' => '<p>Gets a deployment. Deployments define the components that run on Greengrass core devices.</p>', 'GetServiceRoleForAccount' => '<p>Gets the service role associated with IoT Greengrass for your Amazon Web Services account in this Amazon Web Services Region. IoT Greengrass uses this role to verify the identity of client devices and manage core device connectivity information. For more information, see <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/greengrass-service-role.html">Greengrass service role</a> in the <i>IoT Greengrass Version 2 Developer Guide</i>.</p>', 'ListClientDevicesAssociatedWithCoreDevice' => '<p>Retrieves a paginated list of client devices that are associated with a core device.</p>', 'ListComponentVersions' => '<p>Retrieves a paginated list of all versions for a component. Greater versions are listed first.</p>', 'ListComponents' => '<p>Retrieves a paginated list of component summaries. This list includes components that you have permission to view.</p>', 'ListCoreDevices' => '<p>Retrieves a paginated list of Greengrass core devices.</p>', 'ListDeployments' => '<p>Retrieves a paginated list of deployments.</p>', 'ListEffectiveDeployments' => '<p>Retrieves a paginated list of deployment jobs that IoT Greengrass sends to Greengrass core devices.</p>', 'ListInstalledComponents' => '<p>Retrieves a paginated list of the components that a Greengrass core device runs.</p>', 'ListTagsForResource' => '<p>Retrieves the list of tags for an IoT Greengrass resource.</p>', 'ResolveComponentCandidates' => '<p>Retrieves a list of components that meet the component, version, and platform requirements of a deployment. Greengrass core devices call this operation when they receive a deployment to identify the components to install.</p> <p>This operation identifies components that meet all dependency requirements for a deployment. If the requirements conflict, then this operation returns an error and the deployment fails. For example, this occurs if component <code>A</code> requires version <code>&gt;2.0.0</code> and component <code>B</code> requires version <code>&lt;2.0.0</code> of a component dependency.</p> <p>When you specify the component candidates to resolve, IoT Greengrass compares each component\'s digest from the core device with the component\'s digest in the Amazon Web Services Cloud. If the digests don\'t match, then IoT Greengrass specifies to use the version from the Amazon Web Services Cloud.</p> <important> <p>To use this operation, you must use the data plane API endpoint and authenticate with an IoT device certificate. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/greengrass.html">IoT Greengrass endpoints and quotas</a>.</p> </important>', 'TagResource' => '<p>Adds tags to an IoT Greengrass resource. If a tag already exists for the resource, this operation updates the tag\'s value.</p>', 'UntagResource' => '<p>Removes a tag from an IoT Greengrass resource.</p>', 'UpdateConnectivityInfo' => '<p>Updates connectivity information for a Greengrass core device.</p> <p>Connectivity information includes endpoints and ports where client devices can connect to an MQTT broker on the core device. When a client device calls the <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/greengrass-discover-api.html">IoT Greengrass discovery API</a>, IoT Greengrass returns connectivity information for all of the core devices where the client device can connect. For more information, see <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/connect-client-devices.html">Connect client devices to core devices</a> in the <i>IoT Greengrass Version 2 Developer Guide</i>.</p>', ], 'shapes' => [ 'AccessDeniedException' => [ 'base' => '<p>You don\'t have permission to perform the action.</p>', 'refs' => [], ], 'AssociateClientDeviceWithCoreDeviceEntry' => [ 'base' => '<p>Contains a request to associate a client device with a core device. The <a href="https://docs.aws.amazon.com/greengrass/v2/APIReference/API_BatchAssociateClientDeviceWithCoreDevice.html">BatchAssociateClientDeviceWithCoreDevice</a> operation consumes a list of these requests.</p>', 'refs' => [ 'AssociateClientDeviceWithCoreDeviceEntryList$member' => NULL, ], ], 'AssociateClientDeviceWithCoreDeviceEntryList' => [ 'base' => NULL, 'refs' => [ 'BatchAssociateClientDeviceWithCoreDeviceRequest$entries' => '<p>The list of client devices to associate.</p>', ], ], 'AssociateClientDeviceWithCoreDeviceErrorEntry' => [ 'base' => '<p>Contains an error that occurs from a request to associate a client device with a core device. The <a href="https://docs.aws.amazon.com/greengrass/v2/APIReference/API_BatchAssociateClientDeviceWithCoreDevice.html">BatchAssociateClientDeviceWithCoreDevice</a> operation returns a list of these errors.</p>', 'refs' => [ 'AssociateClientDeviceWithCoreDeviceErrorList$member' => NULL, ], ], 'AssociateClientDeviceWithCoreDeviceErrorList' => [ 'base' => NULL, 'refs' => [ 'BatchAssociateClientDeviceWithCoreDeviceResponse$errorEntries' => '<p>The list of any errors for the entries in the request. Each error entry contains the name of the IoT thing that failed to associate.</p>', ], ], 'AssociateServiceRoleToAccountRequest' => [ 'base' => NULL, 'refs' => [], ], 'AssociateServiceRoleToAccountResponse' => [ 'base' => NULL, 'refs' => [], ], 'AssociatedClientDevice' => [ 'base' => '<p>Contains information about a client device that is associated to a core device for cloud discovery.</p>', 'refs' => [ 'AssociatedClientDeviceList$member' => NULL, ], ], 'AssociatedClientDeviceList' => [ 'base' => NULL, 'refs' => [ 'ListClientDevicesAssociatedWithCoreDeviceResponse$associatedClientDevices' => '<p>A list that describes the client devices that are associated with the core device.</p>', ], ], 'BatchAssociateClientDeviceWithCoreDeviceRequest' => [ 'base' => NULL, 'refs' => [], ], 'BatchAssociateClientDeviceWithCoreDeviceResponse' => [ 'base' => NULL, 'refs' => [], ], 'BatchDisassociateClientDeviceFromCoreDeviceRequest' => [ 'base' => NULL, 'refs' => [], ], 'BatchDisassociateClientDeviceFromCoreDeviceResponse' => [ 'base' => NULL, 'refs' => [], ], 'CPU' => [ 'base' => NULL, 'refs' => [ 'SystemResourceLimits$cpus' => '<p>The maximum amount of CPU time that a component\'s processes can use on the core device. A core device\'s total CPU time is equivalent to the device\'s number of CPU cores. For example, on a core device with 4 CPU cores, you can set this value to <code>2</code> to limit the component\'s processes to 50 percent usage of each CPU core. On a device with 1 CPU core, you can set this value to <code>0.25</code> to limit the component\'s processes to 25 percent usage of the CPU. If you set this value to a number greater than the number of CPU cores, the IoT Greengrass Core software doesn\'t limit the component\'s CPU usage.</p>', ], ], 'CancelDeploymentRequest' => [ 'base' => NULL, 'refs' => [], ], 'CancelDeploymentResponse' => [ 'base' => NULL, 'refs' => [], ], 'ClientTokenString' => [ 'base' => NULL, 'refs' => [ 'CreateComponentVersionRequest$clientToken' => '<p>A unique, case-sensitive identifier that you can provide to ensure that the request is idempotent. Idempotency means that the request is successfully processed only once, even if you send the request multiple times. When a request succeeds, and you specify the same client token for subsequent successful requests, the IoT Greengrass V2 service returns the successful response that it caches from the previous request. IoT Greengrass V2 caches successful responses for idempotent requests for up to 8 hours.</p>', 'CreateDeploymentRequest$clientToken' => '<p>A unique, case-sensitive identifier that you can provide to ensure that the request is idempotent. Idempotency means that the request is successfully processed only once, even if you send the request multiple times. When a request succeeds, and you specify the same client token for subsequent successful requests, the IoT Greengrass V2 service returns the successful response that it caches from the previous request. IoT Greengrass V2 caches successful responses for idempotent requests for up to 8 hours.</p>', ], ], 'CloudComponentState' => [ 'base' => NULL, 'refs' => [ 'CloudComponentStatus$componentState' => '<p>The state of the component.</p>', ], ], 'CloudComponentStatus' => [ 'base' => '<p>Contains the status of a component in the IoT Greengrass service.</p>', 'refs' => [ 'CreateComponentVersionResponse$status' => '<p>The status of the component version in IoT Greengrass V2. This status is different from the status of the component on a core device.</p>', 'DescribeComponentResponse$status' => '<p>The status of the component version in IoT Greengrass V2. This status is different from the status of the component on a core device.</p>', ], ], 'Component' => [ 'base' => '<p>Contains information about a component.</p>', 'refs' => [ 'ComponentList$member' => NULL, ], ], 'ComponentARN' => [ 'base' => NULL, 'refs' => [ 'Component$arn' => '<p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the component version.</p>', 'ListComponentVersionsRequest$arn' => '<p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the component version.</p>', ], ], 'ComponentCandidate' => [ 'base' => '<p>Contains information about a component that is a candidate to deploy to a Greengrass core device.</p>', 'refs' => [ 'ComponentCandidateList$member' => NULL, ], ], 'ComponentCandidateList' => [ 'base' => NULL, 'refs' => [ 'ResolveComponentCandidatesRequest$componentCandidates' => '<p>The list of components to resolve.</p>', ], ], 'ComponentConfigurationPath' => [ 'base' => NULL, 'refs' => [ 'ComponentConfigurationPathList$member' => NULL, ], ], 'ComponentConfigurationPathList' => [ 'base' => NULL, 'refs' => [ 'ComponentConfigurationUpdate$reset' => '<p>The list of configuration nodes to reset to default values on target devices. Use JSON pointers to specify each node to reset. JSON pointers start with a forward slash (<code>/</code>) and use forward slashes to separate the key for each level in the object. For more information, see the <a href="https://tools.ietf.org/html/rfc6901">JSON pointer specification</a> and <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/update-component-configurations.html#reset-configuration-update">Reset configuration updates</a> in the <i>IoT Greengrass V2 Developer Guide</i>.</p>', ], ], 'ComponentConfigurationString' => [ 'base' => NULL, 'refs' => [ 'ComponentConfigurationUpdate$merge' => '<p>A serialized JSON string that contains the configuration object to merge to target devices. The core device merges this configuration with the component\'s existing configuration. If this is the first time a component deploys on a device, the core device merges this configuration with the component\'s default configuration. This means that the core device keeps it\'s existing configuration for keys and values that you don\'t specify in this object. For more information, see <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/update-component-configurations.html#merge-configuration-update">Merge configuration updates</a> in the <i>IoT Greengrass V2 Developer Guide</i>.</p>', ], ], 'ComponentConfigurationUpdate' => [ 'base' => '<p>Contains information about a deployment\'s update to a component\'s configuration on Greengrass core devices. For more information, see <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/update-component-configurations.html">Update component configurations</a> in the <i>IoT Greengrass V2 Developer Guide</i>.</p>', 'refs' => [ 'ComponentDeploymentSpecification$configurationUpdate' => '<p>The configuration updates to deploy for the component. You can define <i>reset</i> updates and <i>merge</i> updates. A reset updates the keys that you specify to the default configuration for the component. A merge updates the core device\'s component configuration with the keys and values that you specify. The IoT Greengrass Core software applies reset updates before it applies merge updates. For more information, see <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/update-component-configurations.html">Update component configurations</a> in the <i>IoT Greengrass V2 Developer Guide</i>.</p>', ], ], 'ComponentDependencyMap' => [ 'base' => NULL, 'refs' => [ 'LambdaFunctionRecipeSource$componentDependencies' => '<p>The component versions on which this Lambda function component depends.</p>', ], ], 'ComponentDependencyRequirement' => [ 'base' => '<p>Contains information about a component dependency for a Lambda function component.</p>', 'refs' => [ 'ComponentDependencyMap$value' => NULL, ], ], 'ComponentDependencyType' => [ 'base' => NULL, 'refs' => [ 'ComponentDependencyRequirement$dependencyType' => '<p>The type of this dependency. Choose from the following options:</p> <ul> <li> <p> <code>SOFT</code> – The component doesn\'t restart if the dependency changes state.</p> </li> <li> <p> <code>HARD</code> – The component restarts if the dependency changes state.</p> </li> </ul> <p>Default: <code>HARD</code> </p>', ], ], 'ComponentDeploymentSpecification' => [ 'base' => '<p>Contains information about a component to deploy.</p>', 'refs' => [ 'ComponentDeploymentSpecifications$value' => NULL, ], ], 'ComponentDeploymentSpecifications' => [ 'base' => NULL, 'refs' => [ 'CreateDeploymentRequest$components' => '<p>The components to deploy. This is a dictionary, where each key is the name of a component, and each key\'s value is the version and configuration to deploy for that component.</p>', 'GetDeploymentResponse$components' => '<p>The components to deploy. This is a dictionary, where each key is the name of a component, and each key\'s value is the version and configuration to deploy for that component.</p>', ], ], 'ComponentLatestVersion' => [ 'base' => '<p>Contains information about the latest version of a component.</p>', 'refs' => [ 'Component$latestVersion' => '<p>The latest version of the component and its details.</p>', ], ], 'ComponentList' => [ 'base' => NULL, 'refs' => [ 'ListComponentsResponse$components' => '<p>A list that summarizes each component.</p>', ], ], 'ComponentNameString' => [ 'base' => NULL, 'refs' => [ 'Component$componentName' => '<p>The name of the component.</p>', 'ComponentCandidate$componentName' => '<p>The name of the component.</p>', 'ComponentVersionListItem$componentName' => '<p>The name of the component.</p>', 'CreateComponentVersionResponse$componentName' => '<p>The name of the component.</p>', 'DescribeComponentResponse$componentName' => '<p>The name of the component.</p>', 'InstalledComponent$componentName' => '<p>The name of the component.</p>', 'LambdaFunctionRecipeSource$componentName' => '<p>The name of the component.</p> <p>Defaults to the name of the Lambda function.</p>', 'ResolvedComponentVersion$componentName' => '<p>The name of the component.</p>', ], ], 'ComponentPlatform' => [ 'base' => '<p>Contains information about a platform that a component supports.</p>', 'refs' => [ 'ComponentPlatformList$member' => NULL, 'ResolveComponentCandidatesRequest$platform' => '<p>The platform to use to resolve compatible components.</p>', ], ], 'ComponentPlatformList' => [ 'base' => NULL, 'refs' => [ 'ComponentLatestVersion$platforms' => '<p>The platforms that the component version supports.</p>', 'DescribeComponentResponse$platforms' => '<p>The platforms that the component version supports.</p>', 'LambdaFunctionRecipeSource$componentPlatforms' => '<p>The platforms that the component version supports.</p>', ], ], 'ComponentRunWith' => [ 'base' => '<p>Contains information system user and group that the IoT Greengrass Core software uses to run component processes on the core device. For more information, see <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/configure-greengrass-core-v2.html#configure-component-user">Configure the user and group that run components</a> in the <i>IoT Greengrass V2 Developer Guide</i>.</p>', 'refs' => [ 'ComponentDeploymentSpecification$runWith' => '<p>The system user and group that the IoT Greengrass Core software uses to run component processes on the core device. If you omit this parameter, the IoT Greengrass Core software uses the system user and group that you configure for the core device. For more information, see <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/configure-greengrass-core-v2.html#configure-component-user">Configure the user and group that run components</a> in the <i>IoT Greengrass V2 Developer Guide</i>.</p>', ], ], 'ComponentVersionARN' => [ 'base' => NULL, 'refs' => [ 'ComponentLatestVersion$arn' => '<p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the component version.</p>', 'CreateComponentVersionResponse$arn' => '<p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the component version.</p>', 'DeleteComponentRequest$arn' => '<p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the component version.</p>', 'DescribeComponentRequest$arn' => '<p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the component version.</p>', 'DescribeComponentResponse$arn' => '<p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the component version.</p>', 'GetComponentRequest$arn' => '<p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the component version.</p>', 'GetComponentVersionArtifactRequest$arn' => '<p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the component version. Specify the ARN of a public component version.</p>', 'ResolvedComponentVersion$arn' => '<p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the component version.</p>', ], ], 'ComponentVersionList' => [ 'base' => NULL, 'refs' => [ 'ListComponentVersionsResponse$componentVersions' => '<p>A list of versions that exist for the component.</p>', ], ], 'ComponentVersionListItem' => [ 'base' => '<p>Contains information about a component version in a list.</p>', 'refs' => [ 'ComponentVersionList$member' => NULL, ], ], 'ComponentVersionRequirementMap' => [ 'base' => NULL, 'refs' => [ 'ComponentCandidate$versionRequirements' => '<p>The version requirements for the component\'s dependencies. Greengrass core devices get the version requirements from component recipes.</p> <p>IoT Greengrass V2 uses semantic version constraints. For more information, see <a href="https://semver.org/">Semantic Versioning</a>.</p>', ], ], 'ComponentVersionString' => [ 'base' => NULL, 'refs' => [ 'ComponentCandidate$componentVersion' => '<p>The version of the component.</p>', 'ComponentDeploymentSpecification$componentVersion' => '<p>The version of the component.</p>', 'ComponentLatestVersion$componentVersion' => '<p>The version of the component.</p>', 'ComponentVersionListItem$componentVersion' => '<p>The version of the component.</p>', 'CreateComponentVersionResponse$componentVersion' => '<p>The version of the component.</p>', 'DescribeComponentResponse$componentVersion' => '<p>The version of the component.</p>', 'InstalledComponent$componentVersion' => '<p>The version of the component.</p>', 'LambdaFunctionRecipeSource$componentVersion' => '<p>The version of the component.</p> <p>Defaults to the version of the Lambda function as a semantic version. For example, if your function version is <code>3</code>, the component version becomes <code>3.0.0</code>.</p>', 'ResolvedComponentVersion$componentVersion' => '<p>The version of the component.</p>', ], ], 'ComponentVisibilityScope' => [ 'base' => NULL, 'refs' => [ 'ListComponentsRequest$scope' => '<p>The scope of the components to list.</p> <p>Default: <code>PRIVATE</code> </p>', ], ], 'ConflictException' => [ 'base' => '<p>Your request has conflicting operations. This can occur if you\'re trying to perform more than one operation on the same resource at the same time.</p>', 'refs' => [], ], 'ConnectivityInfo' => [ 'base' => '<p>Contains information about an endpoint and port where client devices can connect to an MQTT broker on a Greengrass core device.</p>', 'refs' => [ 'connectivityInfoList$member' => NULL, ], ], 'CoreDevice' => [ 'base' => '<p>Contains information about a Greengrass core device, which is an IoT thing that runs the IoT Greengrass Core software.</p>', 'refs' => [ 'CoreDevicesList$member' => NULL, ], ], 'CoreDeviceArchitectureString' => [ 'base' => NULL, 'refs' => [ 'GetCoreDeviceResponse$architecture' => '<p>The computer architecture of the core device.</p>', ], ], 'CoreDevicePlatformString' => [ 'base' => NULL, 'refs' => [ 'GetCoreDeviceResponse$platform' => '<p>The operating system platform that the core device runs.</p>', ], ], 'CoreDeviceStatus' => [ 'base' => NULL, 'refs' => [ 'CoreDevice$status' => '<p>The status of the core device. Core devices can have the following statuses:</p> <ul> <li> <p> <code>HEALTHY</code> – The IoT Greengrass Core software and all components run on the core device without issue.</p> </li> <li> <p> <code>UNHEALTHY</code> – The IoT Greengrass Core software or a component is in a failed state on the core device.</p> </li> </ul>', 'GetCoreDeviceResponse$status' => '<p>The status of the core device. The core device status can be:</p> <ul> <li> <p> <code>HEALTHY</code> – The IoT Greengrass Core software and all components run on the core device without issue.</p> </li> <li> <p> <code>UNHEALTHY</code> – The IoT Greengrass Core software or a component is in a failed state on the core device.</p> </li> </ul>', 'ListCoreDevicesRequest$status' => '<p>The core device status by which to filter. If you specify this parameter, the list includes only core devices that have this status. Choose one of the following options:</p> <ul> <li> <p> <code>HEALTHY</code> – The IoT Greengrass Core software and all components run on the core device without issue.</p> </li> <li> <p> <code>UNHEALTHY</code> – The IoT Greengrass Core software or a component is in a failed state on the core device.</p> </li> </ul>', ], ], 'CoreDeviceThingName' => [ 'base' => NULL, 'refs' => [ 'CoreDevice$coreDeviceThingName' => '<p>The name of the core device. This is also the name of the IoT thing.</p>', 'DeleteCoreDeviceRequest$coreDeviceThingName' => '<p>The name of the core device. This is also the name of the IoT thing.</p>', 'GetConnectivityInfoRequest$thingName' => '<p>The name of the core device. This is also the name of the IoT thing.</p>', 'GetCoreDeviceRequest$coreDeviceThingName' => '<p>The name of the core device. This is also the name of the IoT thing.</p>', 'GetCoreDeviceResponse$coreDeviceThingName' => '<p>The name of the core device. This is also the name of the IoT thing.</p>', 'ListEffectiveDeploymentsRequest$coreDeviceThingName' => '<p>The name of the core device. This is also the name of the IoT thing.</p>', 'ListInstalledComponentsRequest$coreDeviceThingName' => '<p>The name of the core device. This is also the name of the IoT thing.</p>', 'UpdateConnectivityInfoRequest$thingName' => '<p>The name of the core device. This is also the name of the IoT thing.</p>', ], ], 'CoreDevicesList' => [ 'base' => NULL, 'refs' => [ 'ListCoreDevicesResponse$coreDevices' => '<p>A list that summarizes each core device.</p>', ], ], 'CreateComponentVersionRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateComponentVersionResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateDeploymentRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateDeploymentResponse' => [ 'base' => NULL, 'refs' => [], ], 'DefaultMaxResults' => [ 'base' => NULL, 'refs' => [ 'ListClientDevicesAssociatedWithCoreDeviceRequest$maxResults' => '<p>The maximum number of results to be returned per paginated request.</p>', 'ListComponentVersionsRequest$maxResults' => '<p>The maximum number of results to be returned per paginated request.</p>', 'ListComponentsRequest$maxResults' => '<p>The maximum number of results to be returned per paginated request.</p>', 'ListCoreDevicesRequest$maxResults' => '<p>The maximum number of results to be returned per paginated request.</p>', 'ListDeploymentsRequest$maxResults' => '<p>The maximum number of results to be returned per paginated request.</p>', 'ListEffectiveDeploymentsRequest$maxResults' => '<p>The maximum number of results to be returned per paginated request.</p>', 'ListInstalledComponentsRequest$maxResults' => '<p>The maximum number of results to be returned per paginated request.</p>', ], ], 'DeleteComponentRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteCoreDeviceRequest' => [ 'base' => NULL, 'refs' => [], ], 'Deployment' => [ 'base' => '<p>Contains information about a deployment.</p>', 'refs' => [ 'DeploymentList$member' => NULL, ], ], 'DeploymentComponentUpdatePolicy' => [ 'base' => '<p>Contains information about a deployment\'s policy that defines when components are safe to update.</p> <p>Each component on a device can report whether or not it\'s ready to update. After a component and its dependencies are ready, they can apply the update in the deployment. You can configure whether or not the deployment notifies components of an update and waits for a response. You specify the amount of time each component has to respond to the update notification.</p>', 'refs' => [ 'DeploymentPolicies$componentUpdatePolicy' => '<p>The component update policy for the configuration deployment. This policy defines when it\'s safe to deploy the configuration to devices.</p>', ], ], 'DeploymentComponentUpdatePolicyAction' => [ 'base' => NULL, 'refs' => [ 'DeploymentComponentUpdatePolicy$action' => '<p>Whether or not to notify components and wait for components to become safe to update. Choose from the following options:</p> <ul> <li> <p> <code>NOTIFY_COMPONENTS</code> – The deployment notifies each component before it stops and updates that component. Components can use the <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/interprocess-communication.html#ipc-operation-subscribetocomponentupdates">SubscribeToComponentUpdates</a> IPC operation to receive these notifications. Then, components can respond with the <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/interprocess-communication.html#ipc-operation-defercomponentupdate">DeferComponentUpdate</a> IPC operation. For more information, see <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/create-deployments.html">Create deployments</a> in the <i>IoT Greengrass V2 Developer Guide</i>.</p> </li> <li> <p> <code>SKIP_NOTIFY_COMPONENTS</code> – The deployment doesn\'t notify components or wait for them to be safe to update.</p> </li> </ul> <p>Default: <code>NOTIFY_COMPONENTS</code> </p>', ], ], 'DeploymentConfigurationValidationPolicy' => [ 'base' => '<p>Contains information about how long a component on a core device can validate its configuration updates before it times out. Components can use the <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/interprocess-communication.html#ipc-operation-subscribetovalidateconfigurationupdates">SubscribeToValidateConfigurationUpdates</a> IPC operation to receive notifications when a deployment specifies a configuration update. Then, components can respond with the <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/interprocess-communication.html#ipc-operation-sendconfigurationvalidityreport">SendConfigurationValidityReport</a> IPC operation. For more information, see <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/create-deployments.html">Create deployments</a> in the <i>IoT Greengrass V2 Developer Guide</i>.</p>', 'refs' => [ 'DeploymentPolicies$configurationValidationPolicy' => '<p>The configuration validation policy for the configuration deployment. This policy defines how long each component has to validate its configure updates.</p>', ], ], 'DeploymentFailureHandlingPolicy' => [ 'base' => NULL, 'refs' => [ 'DeploymentPolicies$failureHandlingPolicy' => '<p>The failure handling policy for the configuration deployment. This policy defines what to do if the deployment fails.</p> <p>Default: <code>ROLLBACK</code> </p>', ], ], 'DeploymentHistoryFilter' => [ 'base' => NULL, 'refs' => [ 'ListDeploymentsRequest$historyFilter' => '<p>The filter for the list of deployments. Choose one of the following options:</p> <ul> <li> <p> <code>ALL</code> – The list includes all deployments.</p> </li> <li> <p> <code>LATEST_ONLY</code> – The list includes only the latest revision of each deployment.</p> </li> </ul> <p>Default: <code>LATEST_ONLY</code> </p>', ], ], 'DeploymentID' => [ 'base' => NULL, 'refs' => [ 'EffectiveDeployment$deploymentId' => '<p>The ID of the deployment.</p>', ], ], 'DeploymentIoTJobConfiguration' => [ 'base' => '<p>Contains information about an IoT job configuration.</p>', 'refs' => [ 'CreateDeploymentRequest$iotJobConfiguration' => '<p>The job configuration for the deployment configuration. The job configuration specifies the rollout, timeout, and stop configurations for the deployment configuration.</p>', 'GetDeploymentResponse$iotJobConfiguration' => '<p>The job configuration for the deployment configuration. The job configuration specifies the rollout, timeout, and stop configurations for the deployment configuration.</p>', ], ], 'DeploymentList' => [ 'base' => NULL, 'refs' => [ 'ListDeploymentsResponse$deployments' => '<p>A list that summarizes each deployment.</p>', ], ], 'DeploymentName' => [ 'base' => NULL, 'refs' => [ 'EffectiveDeployment$deploymentName' => '<p>The name of the deployment.</p>', ], ], 'DeploymentPolicies' => [ 'base' => '<p>Contains information about policies that define how a deployment updates components and handles failure.</p>', 'refs' => [ 'CreateDeploymentRequest$deploymentPolicies' => '<p>The deployment policies for the deployment. These policies define how the deployment updates components and handles failure.</p>', 'GetDeploymentResponse$deploymentPolicies' => '<p>The deployment policies for the deployment. These policies define how the deployment updates components and handles failure.</p>', ], ], 'DeploymentStatus' => [ 'base' => NULL, 'refs' => [ 'Deployment$deploymentStatus' => '<p>The status of the deployment.</p>', 'GetDeploymentResponse$deploymentStatus' => '<p>The status of the deployment.</p>', ], ], 'DescribeComponentRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeComponentResponse' => [ 'base' => NULL, 'refs' => [], ], 'Description' => [ 'base' => NULL, 'refs' => [ 'EffectiveDeployment$description' => '<p>The description of the deployment job.</p>', ], ], 'DescriptionString' => [ 'base' => NULL, 'refs' => [ 'DescribeComponentResponse$description' => '<p>The description of the component version.</p>', ], ], 'DisassociateClientDeviceFromCoreDeviceEntry' => [ 'base' => '<p>Contains a request to disassociate a client device from a core device. The <a href="https://docs.aws.amazon.com/greengrass/v2/APIReference/API_BatchDisassociateClientDeviceWithCoreDevice.html">BatchDisassociateClientDeviceWithCoreDevice</a> operation consumes a list of these requests.</p>', 'refs' => [ 'DisassociateClientDeviceFromCoreDeviceEntryList$member' => NULL, ], ], 'DisassociateClientDeviceFromCoreDeviceEntryList' => [ 'base' => NULL, 'refs' => [ 'BatchDisassociateClientDeviceFromCoreDeviceRequest$entries' => '<p>The list of client devices to disassociate.</p>', ], ], 'DisassociateClientDeviceFromCoreDeviceErrorEntry' => [ 'base' => '<p>Contains an error that occurs from a request to disassociate a client device from a core device. The <a href="https://docs.aws.amazon.com/greengrass/v2/APIReference/API_BatchDisassociateClientDeviceWithCoreDevice.html">BatchDisassociateClientDeviceWithCoreDevice</a> operation returns a list of these errors.</p>', 'refs' => [ 'DisassociateClientDeviceFromCoreDeviceErrorList$member' => NULL, ], ], 'DisassociateClientDeviceFromCoreDeviceErrorList' => [ 'base' => NULL, 'refs' => [ 'BatchDisassociateClientDeviceFromCoreDeviceResponse$errorEntries' => '<p>The list of any errors for the entries in the request. Each error entry contains the name of the IoT thing that failed to disassociate.</p>', ], ], 'DisassociateServiceRoleFromAccountRequest' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateServiceRoleFromAccountResponse' => [ 'base' => NULL, 'refs' => [], ], 'EffectiveDeployment' => [ 'base' => '<p>Contains information about a deployment job that IoT Greengrass sends to a Greengrass core device.</p>', 'refs' => [ 'EffectiveDeploymentsList$member' => NULL, ], ], 'EffectiveDeploymentExecutionStatus' => [ 'base' => NULL, 'refs' => [ 'EffectiveDeployment$coreDeviceExecutionStatus' => '<p>The status of the deployment job on the Greengrass core device.</p>', ], ], 'EffectiveDeploymentsList' => [ 'base' => NULL, 'refs' => [ 'ListEffectiveDeploymentsResponse$effectiveDeployments' => '<p>A list that summarizes each deployment on the core device.</p>', ], ], 'FileSystemPath' => [ 'base' => NULL, 'refs' => [ 'LambdaDeviceMount$path' => '<p>The mount path for the device in the file system.</p>', 'LambdaVolumeMount$sourcePath' => '<p>The path to the physical volume in the file system.</p>', 'LambdaVolumeMount$destinationPath' => '<p>The path to the logical volume in the file system.</p>', ], ], 'GGCVersion' => [ 'base' => NULL, 'refs' => [ 'GetCoreDeviceResponse$coreVersion' => '<p>The version of the IoT Greengrass Core software that the core device runs. This version is equivalent to the version of the Greengrass nucleus component that runs on the core device. For more information, see the <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/greengrass-nucleus-component.html">Greengrass nucleus component</a> in the <i>IoT Greengrass V2 Developer Guide</i>.</p>', ], ], 'GenericV2ARN' => [ 'base' => NULL, 'refs' => [ 'ListTagsForResourceRequest$resourceArn' => '<p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the resource.</p>', 'TagResourceRequest$resourceArn' => '<p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the resource to tag.</p>', 'UntagResourceRequest$resourceArn' => '<p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the resource to untag.</p>', ], ], 'GetComponentRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetComponentResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetComponentVersionArtifactRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetComponentVersionArtifactResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetConnectivityInfoRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetConnectivityInfoResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetCoreDeviceRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetCoreDeviceResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetDeploymentRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetDeploymentResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetServiceRoleForAccountRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetServiceRoleForAccountResponse' => [ 'base' => NULL, 'refs' => [], ], 'InstalledComponent' => [ 'base' => '<p>Contains information about a component on a Greengrass core device.</p>', 'refs' => [ 'InstalledComponentList$member' => NULL, ], ], 'InstalledComponentLifecycleState' => [ 'base' => NULL, 'refs' => [ 'InstalledComponent$lifecycleState' => '<p>The lifecycle state of the component.</p>', ], ], 'InstalledComponentList' => [ 'base' => NULL, 'refs' => [ 'ListInstalledComponentsResponse$installedComponents' => '<p>A list that summarizes each component on the core device.</p>', ], ], 'InternalServerException' => [ 'base' => '<p>IoT Greengrass can\'t process your request right now. Try again later.</p>', 'refs' => [], ], 'IoTJobARN' => [ 'base' => NULL, 'refs' => [ 'CreateDeploymentResponse$iotJobArn' => '<p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the IoT job that applies the deployment to target devices.</p>', 'EffectiveDeployment$iotJobArn' => '<p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the IoT job that applies the deployment to target devices.</p>', 'GetDeploymentResponse$iotJobArn' => '<p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the IoT job that applies the deployment to target devices.</p>', ], ], 'IoTJobAbortAction' => [ 'base' => NULL, 'refs' => [ 'IoTJobAbortCriteria$action' => '<p>The action to perform when the criteria are met.</p>', ], ], 'IoTJobAbortConfig' => [ 'base' => '<p>Contains a list of criteria that define when and how to cancel a configuration deployment.</p>', 'refs' => [ 'DeploymentIoTJobConfiguration$abortConfig' => '<p>The stop configuration for the job. This configuration defines when and how to stop a job rollout.</p>', ], ], 'IoTJobAbortCriteria' => [ 'base' => '<p>Contains criteria that define when and how to cancel a job.</p> <p>The deployment stops if the following conditions are true:</p> <ol> <li> <p>The number of things that receive the deployment exceeds the <code>minNumberOfExecutedThings</code>.</p> </li> <li> <p>The percentage of failures with type <code>failureType</code> exceeds the <code>thresholdPercentage</code>.</p> </li> </ol>', 'refs' => [ 'IoTJobAbortCriteriaList$member' => NULL, ], ], 'IoTJobAbortCriteriaList' => [ 'base' => NULL, 'refs' => [ 'IoTJobAbortConfig$criteriaList' => '<p>The list of criteria that define when and how to cancel the configuration deployment.</p>', ], ], 'IoTJobAbortThresholdPercentage' => [ 'base' => NULL, 'refs' => [ 'IoTJobAbortCriteria$thresholdPercentage' => '<p>The minimum percentage of <code>failureType</code> failures that occur before the job can cancel.</p> <p>This parameter supports up to two digits after the decimal (for example, you can specify <code>10.9</code> or <code>10.99</code>, but not <code>10.999</code>).</p>', ], ], 'IoTJobExecutionFailureType' => [ 'base' => NULL, 'refs' => [ 'IoTJobAbortCriteria$failureType' => '<p>The type of job deployment failure that can cancel a job.</p>', ], ], 'IoTJobExecutionsRolloutConfig' => [ 'base' => '<p>Contains information about the rollout configuration for a job. This configuration defines the rate at which the job deploys a configuration to a fleet of target devices.</p>', 'refs' => [ 'DeploymentIoTJobConfiguration$jobExecutionsRolloutConfig' => '<p>The rollout configuration for the job. This configuration defines the rate at which the job rolls out to the fleet of target devices.</p>', ], ], 'IoTJobExponentialRolloutRate' => [ 'base' => '<p>Contains information about an exponential rollout rate for a configuration deployment job.</p>', 'refs' => [ 'IoTJobExecutionsRolloutConfig$exponentialRate' => '<p>The exponential rate to increase the job rollout rate.</p>', ], ], 'IoTJobId' => [ 'base' => NULL, 'refs' => [ 'EffectiveDeployment$iotJobId' => '<p>The ID of the IoT job that applies the deployment to target devices.</p>', ], ], 'IoTJobInProgressTimeoutInMinutes' => [ 'base' => NULL, 'refs' => [ 'IoTJobTimeoutConfig$inProgressTimeoutInMinutes' => '<p>The amount of time, in minutes, that devices have to complete the job. The timer starts when the job status is set to <code>IN_PROGRESS</code>. If the job status doesn\'t change to a terminal state before the time expires, then the job status is set to <code>TIMED_OUT</code>.</p> <p>The timeout interval must be between 1 minute and 7 days (10080 minutes).</p>', ], ], 'IoTJobMaxExecutionsPerMin' => [ 'base' => NULL, 'refs' => [ 'IoTJobExecutionsRolloutConfig$maximumPerMinute' => '<p>The maximum number of devices that receive a pending job notification, per minute.</p>', ], ], 'IoTJobMinimumNumberOfExecutedThings' => [ 'base' => NULL, 'refs' => [ 'IoTJobAbortCriteria$minNumberOfExecutedThings' => '<p>The minimum number of things that receive the configuration before the job can cancel.</p>', ], ], 'IoTJobNumberOfThings' => [ 'base' => NULL, 'refs' => [ 'IoTJobRateIncreaseCriteria$numberOfNotifiedThings' => '<p>The number of devices to receive the job notification before the rollout rate increases.</p>', 'IoTJobRateIncreaseCriteria$numberOfSucceededThings' => '<p>The number of devices to successfully run the configuration job before the rollout rate increases.</p>', ], ], 'IoTJobRateIncreaseCriteria' => [ 'base' => '<p>Contains information about criteria to meet before a job increases its rollout rate. Specify either <code>numberOfNotifiedThings</code> or <code>numberOfSucceededThings</code>.</p>', 'refs' => [ 'IoTJobExponentialRolloutRate$rateIncreaseCriteria' => '<p>The criteria to increase the rollout rate for the job.</p>', ], ], 'IoTJobRolloutBaseRatePerMinute' => [ 'base' => NULL, 'refs' => [ 'IoTJobExponentialRolloutRate$baseRatePerMinute' => '<p>The minimum number of devices that receive a pending job notification, per minute, when the job starts. This parameter defines the initial rollout rate of the job.</p>', ], ], 'IoTJobRolloutIncrementFactor' => [ 'base' => NULL, 'refs' => [ 'IoTJobExponentialRolloutRate$incrementFactor' => '<p>The exponential factor to increase the rollout rate for the job.</p> <p>This parameter supports up to one digit after the decimal (for example, you can specify <code>1.5</code>, but not <code>1.55</code>).</p>', ], ], 'IoTJobTimeoutConfig' => [ 'base' => '<p>Contains information about the timeout configuration for a job.</p>', 'refs' => [ 'DeploymentIoTJobConfiguration$timeoutConfig' => '<p>The timeout configuration for the job. This configuration defines the amount of time each device has to complete the job.</p>', ], ], 'IoTThingName' => [ 'base' => NULL, 'refs' => [ 'AssociateClientDeviceWithCoreDeviceEntry$thingName' => '<p>The name of the IoT thing that represents the client device to associate.</p>', 'AssociateClientDeviceWithCoreDeviceErrorEntry$thingName' => '<p>The name of the IoT thing whose associate request failed.</p>', 'AssociatedClientDevice$thingName' => '<p>The name of the IoT thing that represents the associated client device.</p>', 'BatchAssociateClientDeviceWithCoreDeviceRequest$coreDeviceThingName' => '<p>The name of the core device. This is also the name of the IoT thing.</p>', 'BatchDisassociateClientDeviceFromCoreDeviceRequest$coreDeviceThingName' => '<p>The name of the core device. This is also the name of the IoT thing.</p>', 'DisassociateClientDeviceFromCoreDeviceEntry$thingName' => '<p>The name of the IoT thing that represents the client device to disassociate.</p>', 'DisassociateClientDeviceFromCoreDeviceErrorEntry$thingName' => '<p>The name of the IoT thing whose disassociate request failed.</p>', 'ListClientDevicesAssociatedWithCoreDeviceRequest$coreDeviceThingName' => '<p>The name of the core device. This is also the name of the IoT thing.</p>', ], ], 'IsLatestForTarget' => [ 'base' => NULL, 'refs' => [ 'Deployment$isLatestForTarget' => '<p>Whether or not the deployment is the latest revision for its target.</p>', 'GetDeploymentResponse$isLatestForTarget' => '<p>Whether or not the deployment is the latest revision for its target.</p>', ], ], 'IsRoot' => [ 'base' => NULL, 'refs' => [ 'InstalledComponent$isRoot' => '<p>Whether or not the component is a root component.</p>', ], ], 'LambdaContainerParams' => [ 'base' => '<p>Contains information about a container in which Lambda functions run on Greengrass core devices.</p>', 'refs' => [ 'LambdaLinuxProcessParams$containerParams' => '<p>The parameters for the container in which the Lambda function runs.</p>', ], ], 'LambdaDeviceList' => [ 'base' => NULL, 'refs' => [ 'LambdaContainerParams$devices' => '<p>The list of system devices that the container can access.</p>', ], ], 'LambdaDeviceMount' => [ 'base' => '<p>Contains information about a device that Linux processes in a container can access.</p>', 'refs' => [ 'LambdaDeviceList$member' => NULL, ], ], 'LambdaEnvironmentVariables' => [ 'base' => NULL, 'refs' => [ 'LambdaExecutionParameters$environmentVariables' => '<p>The map of environment variables that are available to the Lambda function when it runs.</p>', ], ], 'LambdaEventSource' => [ 'base' => '<p>Contains information about an event source for an Lambda function. The event source defines the topics on which this Lambda function subscribes to receive messages that run the function.</p>', 'refs' => [ 'LambdaEventSourceList$member' => NULL, ], ], 'LambdaEventSourceList' => [ 'base' => NULL, 'refs' => [ 'LambdaExecutionParameters$eventSources' => '<p>The list of event sources to which to subscribe to receive work messages. The Lambda function runs when it receives a message from an event source. You can subscribe this function to local publish/subscribe messages and Amazon Web Services IoT Core MQTT messages.</p>', ], ], 'LambdaEventSourceType' => [ 'base' => NULL, 'refs' => [ 'LambdaEventSource$type' => '<p>The type of event source. Choose from the following options:</p> <ul> <li> <p> <code>PUB_SUB</code> – Subscribe to local publish/subscribe messages. This event source type doesn\'t support MQTT wildcards (<code>+</code> and <code>#</code>) in the event source topic.</p> </li> <li> <p> <code>IOT_CORE</code> – Subscribe to Amazon Web Services IoT Core MQTT messages. This event source type supports MQTT wildcards (<code>+</code> and <code>#</code>) in the event source topic.</p> </li> </ul>', ], ], 'LambdaExecArg' => [ 'base' => NULL, 'refs' => [ 'LambdaExecArgsList$member' => NULL, ], ], 'LambdaExecArgsList' => [ 'base' => NULL, 'refs' => [ 'LambdaExecutionParameters$execArgs' => '<p>The list of arguments to pass to the Lambda function when it runs.</p>', ], ], 'LambdaExecutionParameters' => [ 'base' => '<p>Contains parameters for a Lambda function that runs on IoT Greengrass.</p>', 'refs' => [ 'LambdaFunctionRecipeSource$componentLambdaParameters' => '<p>The system and runtime parameters for the Lambda function as it runs on the Greengrass core device.</p>', ], ], 'LambdaFilesystemPermission' => [ 'base' => NULL, 'refs' => [ 'LambdaDeviceMount$permission' => '<p>The permission to access the device: read/only (<code>ro</code>) or read/write (<code>rw</code>).</p> <p>Default: <code>ro</code> </p>', 'LambdaVolumeMount$permission' => '<p>The permission to access the volume: read/only (<code>ro</code>) or read/write (<code>rw</code>).</p> <p>Default: <code>ro</code> </p>', ], ], 'LambdaFunctionARNWithVersionNumber' => [ 'base' => NULL, 'refs' => [ 'LambdaFunctionRecipeSource$lambdaArn' => '<p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the Lambda function. The ARN must include the version of the function to import. You can\'t use version aliases like <code>$LATEST</code>.</p>', ], ], 'LambdaFunctionRecipeSource' => [ 'base' => '<p>Contains information about an Lambda function to import to create a component.</p>', 'refs' => [ 'CreateComponentVersionRequest$lambdaFunction' => '<p>The parameters to create a component from a Lambda function.</p> <p>You must specify either <code>inlineRecipe</code> or <code>lambdaFunction</code>.</p>', ], ], 'LambdaInputPayloadEncodingType' => [ 'base' => NULL, 'refs' => [ 'LambdaExecutionParameters$inputPayloadEncodingType' => '<p>The encoding type that the Lambda function supports.</p> <p>Default: <code>json</code> </p>', ], ], 'LambdaIsolationMode' => [ 'base' => NULL, 'refs' => [ 'LambdaLinuxProcessParams$isolationMode' => '<p>The isolation mode for the process that contains the Lambda function. The process can run in an isolated runtime environment inside the IoT Greengrass container, or as a regular process outside any container.</p> <p>Default: <code>GreengrassContainer</code> </p>', ], ], 'LambdaLinuxProcessParams' => [ 'base' => '<p>Contains parameters for a Linux process that contains an Lambda function.</p>', 'refs' => [ 'LambdaExecutionParameters$linuxProcessParams' => '<p>The parameters for the Linux process that contains the Lambda function.</p>', ], ], 'LambdaVolumeList' => [ 'base' => NULL, 'refs' => [ 'LambdaContainerParams$volumes' => '<p>The list of volumes that the container can access.</p>', ], ], 'LambdaVolumeMount' => [ 'base' => '<p>Contains information about a volume that Linux processes in a container can access. When you define a volume, the IoT Greengrass Core software mounts the source files to the destination inside the container.</p>', 'refs' => [ 'LambdaVolumeList$member' => NULL, ], ], 'LifecycleStateDetails' => [ 'base' => NULL, 'refs' => [ 'InstalledComponent$lifecycleStateDetails' => '<p>The details about the lifecycle state of the component.</p>', ], ], 'ListClientDevicesAssociatedWithCoreDeviceRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListClientDevicesAssociatedWithCoreDeviceResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListComponentVersionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListComponentVersionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListComponentsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListComponentsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListCoreDevicesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListCoreDevicesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListDeploymentsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListDeploymentsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListEffectiveDeploymentsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListEffectiveDeploymentsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListInstalledComponentsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListInstalledComponentsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'Memory' => [ 'base' => NULL, 'refs' => [ 'SystemResourceLimits$memory' => '<p>The maximum amount of RAM, expressed in kilobytes, that a component\'s processes can use on the core device.</p>', ], ], 'NextTokenString' => [ 'base' => NULL, 'refs' => [ 'ListClientDevicesAssociatedWithCoreDeviceRequest$nextToken' => '<p>The token to be used for the next set of paginated results.</p>', 'ListClientDevicesAssociatedWithCoreDeviceResponse$nextToken' => '<p>The token for the next set of results, or null if there are no additional results.</p>', 'ListComponentVersionsRequest$nextToken' => '<p>The token to be used for the next set of paginated results.</p>', 'ListComponentVersionsResponse$nextToken' => '<p>The token for the next set of results, or null if there are no additional results.</p>', 'ListComponentsRequest$nextToken' => '<p>The token to be used for the next set of paginated results.</p>', 'ListComponentsResponse$nextToken' => '<p>The token for the next set of results, or null if there are no additional results.</p>', 'ListCoreDevicesRequest$nextToken' => '<p>The token to be used for the next set of paginated results.</p>', 'ListCoreDevicesResponse$nextToken' => '<p>The token for the next set of results, or null if there are no additional results.</p>', 'ListDeploymentsRequest$nextToken' => '<p>The token to be used for the next set of paginated results.</p>', 'ListDeploymentsResponse$nextToken' => '<p>The token for the next set of results, or null if there are no additional results.</p>', 'ListEffectiveDeploymentsRequest$nextToken' => '<p>The token to be used for the next set of paginated results.</p>', 'ListEffectiveDeploymentsResponse$nextToken' => '<p>The token for the next set of results, or null if there are no additional results.</p>', 'ListInstalledComponentsRequest$nextToken' => '<p>The token to be used for the next set of paginated results.</p>', 'ListInstalledComponentsResponse$nextToken' => '<p>The token for the next set of results, or null if there are no additional results.</p>', ], ], 'NonEmptyString' => [ 'base' => NULL, 'refs' => [ 'AssociateClientDeviceWithCoreDeviceErrorEntry$code' => '<p>The error code for the request.</p>', 'AssociateClientDeviceWithCoreDeviceErrorEntry$message' => '<p>A message that provides additional information about the error.</p>', 'CancelDeploymentRequest$deploymentId' => '<p>The ID of the deployment.</p>', 'CancelDeploymentResponse$message' => '<p>A message that communicates if the cancel was successful.</p>', 'CloudComponentStatus$message' => '<p>A message that communicates details, such as errors, about the status of the component.</p>', 'ComponentDependencyMap$key' => NULL, 'ComponentDependencyRequirement$versionRequirement' => '<p>The component version requirement for the component dependency.</p> <p>IoT Greengrass V2 uses semantic version constraints. For more information, see <a href="https://semver.org/">Semantic Versioning</a>.</p>', 'ComponentDeploymentSpecifications$key' => NULL, 'ComponentLatestVersion$description' => '<p>The description of the component version.</p>', 'ComponentLatestVersion$publisher' => '<p>The publisher of the component version.</p>', 'ComponentPlatform$name' => '<p>The friendly name of the platform. This name helps you identify the platform.</p> <p>If you omit this parameter, IoT Greengrass creates a friendly name from the <code>os</code> and <code>architecture</code> of the platform.</p>', 'ComponentRunWith$posixUser' => '<p>The POSIX system user and, optionally, group to use to run this component on Linux core devices. The user, and group if specified, must exist on each Linux core device. Specify the user and group separated by a colon (<code>:</code>) in the following format: <code>user:group</code>. The group is optional. If you don\'t specify a group, the IoT Greengrass Core software uses the primary user for the group.</p> <p>If you omit this parameter, the IoT Greengrass Core software uses the default system user and group that you configure on the Greengrass nucleus component. For more information, see <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/configure-greengrass-core-v2.html#configure-component-user">Configure the user and group that run components</a>.</p>', 'ComponentRunWith$windowsUser' => '<p>The Windows user to use to run this component on Windows core devices. The user must exist on each Windows core device, and its name and password must be in the LocalSystem account\'s Credentials Manager instance.</p> <p>If you omit this parameter, the IoT Greengrass Core software uses the default Windows user that you configure on the Greengrass nucleus component. For more information, see <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/configure-greengrass-core-v2.html#configure-component-user">Configure the user and group that run components</a>.</p>', 'ComponentVersionListItem$arn' => '<p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the component version.</p>', 'ComponentVersionRequirementMap$key' => NULL, 'ComponentVersionRequirementMap$value' => NULL, 'CreateDeploymentRequest$deploymentName' => '<p>The name of the deployment.</p>', 'CreateDeploymentResponse$deploymentId' => '<p>The ID of the deployment.</p>', 'CreateDeploymentResponse$iotJobId' => '<p>The ID of the IoT job that applies the deployment to target devices.</p>', 'Deployment$revisionId' => '<p>The revision number of the deployment.</p>', 'Deployment$deploymentId' => '<p>The ID of the deployment.</p>', 'Deployment$deploymentName' => '<p>The name of the deployment.</p>', 'DisassociateClientDeviceFromCoreDeviceErrorEntry$code' => '<p>The error code for the request.</p>', 'DisassociateClientDeviceFromCoreDeviceErrorEntry$message' => '<p>A message that provides additional information about the error.</p>', 'GetComponentVersionArtifactRequest$artifactName' => '<p>The name of the artifact.</p> <p>You can use the <a href="https://docs.aws.amazon.com/greengrass/v2/APIReference/API_GetComponent.html">GetComponent</a> operation to download the component recipe, which includes the URI of the artifact. The artifact name is the section of the URI after the scheme. For example, in the artifact URI <code>greengrass:SomeArtifact.zip</code>, the artifact name is <code>SomeArtifact.zip</code>.</p>', 'GetComponentVersionArtifactResponse$preSignedUrl' => '<p>The URL of the artifact.</p>', 'GetDeploymentRequest$deploymentId' => '<p>The ID of the deployment.</p>', 'GetDeploymentResponse$revisionId' => '<p>The revision number of the deployment.</p>', 'GetDeploymentResponse$deploymentId' => '<p>The ID of the deployment.</p>', 'LambdaEnvironmentVariables$key' => NULL, 'PlatformAttributesMap$key' => NULL, 'PlatformAttributesMap$value' => NULL, 'StringMap$key' => NULL, 'StringMap$value' => NULL, ], ], 'NullableString' => [ 'base' => NULL, 'refs' => [ 'GetDeploymentResponse$deploymentName' => '<p>The name of the deployment.</p>', 'GetDeploymentResponse$iotJobId' => '<p>The ID of the IoT job that applies the deployment to target devices.</p>', ], ], 'OptionalBoolean' => [ 'base' => NULL, 'refs' => [ 'LambdaContainerParams$mountROSysfs' => '<p>Whether or not the container can read information from the device\'s <code>/sys</code> folder.</p> <p>Default: <code>false</code> </p>', 'LambdaDeviceMount$addGroupOwner' => '<p>Whether or not to add the component\'s system user as an owner of the device.</p> <p>Default: <code>false</code> </p>', 'LambdaExecutionParameters$pinned' => '<p>Whether or not the Lambda function is pinned, or long-lived.</p> <ul> <li> <p>A pinned Lambda function starts when IoT Greengrass starts and keeps running in its own container.</p> </li> <li> <p>A non-pinned Lambda function starts only when it receives a work item and exists after it idles for <code>maxIdleTimeInSeconds</code>. If the function has multiple work items, the IoT Greengrass Core software creates multiple instances of the function.</p> </li> </ul> <p>Default: <code>true</code> </p>', 'LambdaVolumeMount$addGroupOwner' => '<p>Whether or not to add the IoT Greengrass user group as an owner of the volume.</p> <p>Default: <code>false</code> </p>', ], ], 'OptionalInteger' => [ 'base' => NULL, 'refs' => [ 'DeploymentComponentUpdatePolicy$timeoutInSeconds' => '<p>The amount of time in seconds that each component on a device has to report that it\'s safe to update. If the component waits for longer than this timeout, then the deployment proceeds on the device.</p> <p>Default: <code>60</code> </p>', 'DeploymentConfigurationValidationPolicy$timeoutInSeconds' => '<p>The amount of time in seconds that a component can validate its configuration updates. If the validation time exceeds this timeout, then the deployment proceeds for the device.</p> <p>Default: <code>30</code> </p>', 'LambdaContainerParams$memorySizeInKB' => '<p>The memory size of the container, expressed in kilobytes.</p> <p>Default: <code>16384</code> (16 MB)</p>', 'LambdaExecutionParameters$maxQueueSize' => '<p>The maximum size of the message queue for the Lambda function component. The IoT Greengrass core stores messages in a FIFO (first-in-first-out) queue until it can run the Lambda function to consume each message.</p>', 'LambdaExecutionParameters$maxInstancesCount' => '<p>The maximum number of instances that a non-pinned Lambda function can run at the same time.</p>', 'LambdaExecutionParameters$maxIdleTimeInSeconds' => '<p>The maximum amount of time in seconds that a non-pinned Lambda function can idle before the IoT Greengrass Core software stops its process.</p>', 'LambdaExecutionParameters$timeoutInSeconds' => '<p>The maximum amount of time in seconds that the Lambda function can process a work item.</p>', 'LambdaExecutionParameters$statusTimeoutInSeconds' => '<p>The interval in seconds at which a pinned (also known as long-lived) Lambda function component sends status updates to the Lambda manager component.</p>', ], ], 'PlatformAttributesMap' => [ 'base' => NULL, 'refs' => [ 'ComponentPlatform$attributes' => '<p>A dictionary of attributes for the platform. The IoT Greengrass Core software defines the <code>os</code> and <code>platform</code> by default. You can specify additional platform attributes for a core device when you deploy the Greengrass nucleus component. For more information, see the <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/greengrass-nucleus-component.html">Greengrass nucleus component</a> in the <i>IoT Greengrass V2 Developer Guide</i>.</p>', ], ], 'PortNumberInt' => [ 'base' => NULL, 'refs' => [ 'ConnectivityInfo$portNumber' => '<p>The port where the MQTT broker operates on the core device. This port is typically 8883, which is the default port for the MQTT broker component that runs on core devices.</p>', ], ], 'PublisherString' => [ 'base' => NULL, 'refs' => [ 'DescribeComponentResponse$publisher' => '<p>The publisher of the component version.</p>', ], ], 'Reason' => [ 'base' => NULL, 'refs' => [ 'EffectiveDeployment$reason' => '<p>The reason code for the update, if the job was updated.</p>', ], ], 'RecipeBlob' => [ 'base' => NULL, 'refs' => [ 'CreateComponentVersionRequest$inlineRecipe' => '<p>The recipe to use to create the component. The recipe defines the component\'s metadata, parameters, dependencies, lifecycle, artifacts, and platform compatibility.</p> <p>You must specify either <code>inlineRecipe</code> or <code>lambdaFunction</code>.</p>', 'GetComponentResponse$recipe' => '<p>The recipe of the component version.</p>', 'ResolvedComponentVersion$recipe' => '<p>The recipe of the component version.</p>', ], ], 'RecipeOutputFormat' => [ 'base' => NULL, 'refs' => [ 'GetComponentRequest$recipeOutputFormat' => '<p>The format of the recipe.</p>', 'GetComponentResponse$recipeOutputFormat' => '<p>The format of the recipe.</p>', ], ], 'RequestAlreadyInProgressException' => [ 'base' => '<p>The request is already in progress. This exception occurs when you use a client token for multiple requests while IoT Greengrass is still processing an earlier request that uses the same client token.</p>', 'refs' => [], ], 'ResolveComponentCandidatesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ResolveComponentCandidatesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ResolvedComponentVersion' => [ 'base' => '<p>Contains information about a component version that is compatible to run on a Greengrass core device.</p>', 'refs' => [ 'ResolvedComponentVersionsList$member' => NULL, ], ], 'ResolvedComponentVersionsList' => [ 'base' => NULL, 'refs' => [ 'ResolveComponentCandidatesResponse$resolvedComponentVersions' => '<p>A list of components that meet the requirements that you specify in the request. This list includes each component\'s recipe that you can use to install the component.</p>', ], ], 'ResourceNotFoundException' => [ 'base' => '<p>The requested resource can\'t be found.</p>', 'refs' => [], ], 'RetryAfterSeconds' => [ 'base' => NULL, 'refs' => [ 'InternalServerException$retryAfterSeconds' => '<p>The amount of time to wait before you retry the request.</p>', 'ThrottlingException$retryAfterSeconds' => '<p>The amount of time to wait before you retry the request.</p>', ], ], 'ServiceQuotaExceededException' => [ 'base' => '<p>Your request exceeds a service quota. For example, you might have the maximum number of components that you can create.</p>', 'refs' => [], ], 'String' => [ 'base' => NULL, 'refs' => [ 'AccessDeniedException$message' => NULL, 'AssociateServiceRoleToAccountRequest$roleArn' => '<p>The Amazon Resource Name (ARN) of the service role to associate with IoT Greengrass for your Amazon Web Services account in this Amazon Web Services Region.</p>', 'AssociateServiceRoleToAccountResponse$associatedAt' => '<p>The time when the service role was associated with IoT Greengrass for your Amazon Web Services account in this Amazon Web Services Region.</p>', 'ConflictException$message' => NULL, 'ConflictException$resourceId' => '<p>The ID of the resource that conflicts with the request.</p>', 'ConflictException$resourceType' => '<p>The type of the resource that conflicts with the request.</p>', 'ConnectivityInfo$id' => '<p>An ID for the connectivity information.</p>', 'ConnectivityInfo$hostAddress' => '<p>The IP address or DNS address where client devices can connect to an MQTT broker on the Greengrass core device.</p>', 'ConnectivityInfo$metadata' => '<p>Additional metadata to provide to client devices that connect to this core device.</p>', 'DisassociateServiceRoleFromAccountResponse$disassociatedAt' => '<p>The time when the service role was disassociated from IoT Greengrass for your Amazon Web Services account in this Amazon Web Services Region.</p>', 'GetConnectivityInfoResponse$message' => '<p>A message about the connectivity information request.</p>', 'GetServiceRoleForAccountResponse$associatedAt' => '<p>The time when the service role was associated with IoT Greengrass for your Amazon Web Services account in this Amazon Web Services Region.</p>', 'GetServiceRoleForAccountResponse$roleArn' => '<p>The ARN of the service role that is associated with IoT Greengrass for your Amazon Web Services account in this Amazon Web Services Region.</p>', 'InternalServerException$message' => NULL, 'LambdaEnvironmentVariables$value' => NULL, 'RequestAlreadyInProgressException$message' => NULL, 'ResourceNotFoundException$message' => NULL, 'ResourceNotFoundException$resourceId' => '<p>The ID of the resource that isn\'t found.</p>', 'ResourceNotFoundException$resourceType' => '<p>The type of the resource that isn\'t found.</p>', 'ServiceQuotaExceededException$message' => NULL, 'ServiceQuotaExceededException$resourceId' => '<p>The ID of the resource that exceeds the service quota.</p>', 'ServiceQuotaExceededException$resourceType' => '<p>The type of the resource that exceeds the service quota.</p>', 'ServiceQuotaExceededException$quotaCode' => '<p>The code for the quota in <a href="https://docs.aws.amazon.com/servicequotas/latest/userguide/intro.html">Service Quotas</a>.</p>', 'ServiceQuotaExceededException$serviceCode' => '<p>The code for the service in <a href="https://docs.aws.amazon.com/servicequotas/latest/userguide/intro.html">Service Quotas</a>.</p>', 'ThrottlingException$message' => NULL, 'ThrottlingException$quotaCode' => '<p>The code for the quota in <a href="https://docs.aws.amazon.com/servicequotas/latest/userguide/intro.html">Service Quotas</a>.</p>', 'ThrottlingException$serviceCode' => '<p>The code for the service in <a href="https://docs.aws.amazon.com/servicequotas/latest/userguide/intro.html">Service Quotas</a>.</p>', 'UpdateConnectivityInfoResponse$version' => '<p>The new version of the connectivity information for the core device.</p>', 'UpdateConnectivityInfoResponse$message' => '<p>A message about the connectivity information update request.</p>', 'ValidationException$message' => NULL, 'ValidationExceptionField$name' => '<p>The name of the exception field.</p>', 'ValidationExceptionField$message' => '<p>The message of the exception field.</p>', ], ], 'StringMap' => [ 'base' => NULL, 'refs' => [ 'CloudComponentStatus$errors' => '<p>A dictionary of errors that communicate why the component is in an error state. For example, if IoT Greengrass can\'t access an artifact for the component, then <code>errors</code> contains the artifact\'s URI as a key, and the error message as the value for that key.</p>', ], ], 'SystemResourceLimits' => [ 'base' => '<p>Contains information about system resource limits that the IoT Greengrass Core software applies to a component\'s processes. For more information, see <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/configure-greengrass-core-v2.html#configure-component-system-resource-limits">Configure system resource limits for components</a>.</p>', 'refs' => [ 'ComponentRunWith$systemResourceLimits' => '<p>The system resource limits to apply to this component\'s process on the core device. IoT Greengrass currently supports this feature on only Linux core devices.</p> <p>If you omit this parameter, the IoT Greengrass Core software uses the default system resource limits that you configure on the Greengrass nucleus component. For more information, see <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/configure-greengrass-core-v2.html#configure-component-system-resource-limits">Configure system resource limits for components</a>.</p>', ], ], 'TagKey' => [ 'base' => NULL, 'refs' => [ 'TagKeyList$member' => NULL, 'TagMap$key' => NULL, ], ], 'TagKeyList' => [ 'base' => NULL, 'refs' => [ 'UntagResourceRequest$tagKeys' => '<p>A list of keys for tags to remove from the resource.</p>', ], ], 'TagMap' => [ 'base' => NULL, 'refs' => [ 'CreateComponentVersionRequest$tags' => '<p>A list of key-value pairs that contain metadata for the resource. For more information, see <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/tag-resources.html">Tag your resources</a> in the <i>IoT Greengrass V2 Developer Guide</i>.</p>', 'CreateDeploymentRequest$tags' => '<p>A list of key-value pairs that contain metadata for the resource. For more information, see <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/tag-resources.html">Tag your resources</a> in the <i>IoT Greengrass V2 Developer Guide</i>.</p>', 'DescribeComponentResponse$tags' => '<p>A list of key-value pairs that contain metadata for the resource. For more information, see <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/tag-resources.html">Tag your resources</a> in the <i>IoT Greengrass V2 Developer Guide</i>.</p>', 'GetComponentResponse$tags' => '<p>A list of key-value pairs that contain metadata for the resource. For more information, see <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/tag-resources.html">Tag your resources</a> in the <i>IoT Greengrass V2 Developer Guide</i>.</p>', 'GetCoreDeviceResponse$tags' => '<p>A list of key-value pairs that contain metadata for the resource. For more information, see <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/tag-resources.html">Tag your resources</a> in the <i>IoT Greengrass V2 Developer Guide</i>.</p>', 'GetDeploymentResponse$tags' => '<p>A list of key-value pairs that contain metadata for the resource. For more information, see <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/tag-resources.html">Tag your resources</a> in the <i>IoT Greengrass V2 Developer Guide</i>.</p>', 'ListTagsForResourceResponse$tags' => '<p>A list of key-value pairs that contain metadata for the resource. For more information, see <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/tag-resources.html">Tag your resources</a> in the <i>IoT Greengrass V2 Developer Guide</i>.</p>', 'TagResourceRequest$tags' => '<p>A list of key-value pairs that contain metadata for the resource. For more information, see <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/tag-resources.html">Tag your resources</a> in the <i>IoT Greengrass V2 Developer Guide</i>.</p>', ], ], 'TagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'TagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'TagValue' => [ 'base' => NULL, 'refs' => [ 'TagMap$value' => NULL, ], ], 'TargetARN' => [ 'base' => NULL, 'refs' => [ 'CreateDeploymentRequest$targetArn' => '<p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the target IoT thing or thing group.</p>', 'Deployment$targetArn' => '<p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the target IoT thing or thing group.</p>', 'EffectiveDeployment$targetArn' => '<p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the target IoT thing or thing group.</p>', 'GetDeploymentResponse$targetArn' => '<p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the target IoT thing or thing group.</p>', 'ListDeploymentsRequest$targetArn' => '<p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the target IoT thing or thing group.</p>', ], ], 'ThingGroupARN' => [ 'base' => NULL, 'refs' => [ 'ListCoreDevicesRequest$thingGroupArn' => '<p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the IoT thing group by which to filter. If you specify this parameter, the list includes only core devices that are members of this thing group.</p>', ], ], 'ThrottlingException' => [ 'base' => '<p>Your request exceeded a request rate quota. For example, you might have exceeded the amount of times that you can retrieve device or deployment status per second.</p>', 'refs' => [], ], 'Timestamp' => [ 'base' => NULL, 'refs' => [ 'AssociatedClientDevice$associationTimestamp' => '<p>The time that the client device was associated, expressed in ISO 8601 format.</p>', 'ComponentLatestVersion$creationTimestamp' => '<p>The time at which the component was created, expressed in ISO 8601 format.</p>', 'CoreDevice$lastStatusUpdateTimestamp' => '<p>The time at which the core device\'s status last updated, expressed in ISO 8601 format.</p>', 'CreateComponentVersionResponse$creationTimestamp' => '<p>The time at which the component was created, expressed in ISO 8601 format.</p>', 'Deployment$creationTimestamp' => '<p>The time at which the deployment was created, expressed in ISO 8601 format.</p>', 'DescribeComponentResponse$creationTimestamp' => '<p>The time at which the component was created, expressed in ISO 8601 format.</p>', 'EffectiveDeployment$creationTimestamp' => '<p>The time at which the deployment was created, expressed in ISO 8601 format.</p>', 'EffectiveDeployment$modifiedTimestamp' => '<p>The time at which the deployment job was last modified, expressed in ISO 8601 format.</p>', 'GetCoreDeviceResponse$lastStatusUpdateTimestamp' => '<p>The time at which the core device\'s status last updated, expressed in ISO 8601 format.</p>', 'GetDeploymentResponse$creationTimestamp' => '<p>The time at which the deployment was created, expressed in ISO 8601 format.</p>', ], ], 'TopicString' => [ 'base' => NULL, 'refs' => [ 'LambdaEventSource$topic' => '<p>The topic to which to subscribe to receive event messages.</p>', ], ], 'UntagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'UntagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateConnectivityInfoRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateConnectivityInfoResponse' => [ 'base' => NULL, 'refs' => [], ], 'ValidationException' => [ 'base' => '<p>The request isn\'t valid. This can occur if your request contains malformed JSON or unsupported characters.</p>', 'refs' => [], ], 'ValidationExceptionField' => [ 'base' => '<p>Contains information about a validation exception field.</p>', 'refs' => [ 'ValidationExceptionFieldList$member' => NULL, ], ], 'ValidationExceptionFieldList' => [ 'base' => NULL, 'refs' => [ 'ValidationException$fields' => '<p>The list of fields that failed to validate.</p>', ], ], 'ValidationExceptionReason' => [ 'base' => NULL, 'refs' => [ 'ValidationException$reason' => '<p>The reason for the validation exception.</p>', ], ], 'connectivityInfoList' => [ 'base' => NULL, 'refs' => [ 'GetConnectivityInfoResponse$connectivityInfo' => '<p>The connectivity information for the core device.</p>', 'UpdateConnectivityInfoRequest$connectivityInfo' => '<p>The connectivity information for the core device.</p>', ], ], ],];
