<?php
// This file was auto-generated from sdk-root/src/data/finspace-data/2020-07-13/docs-2.json
return [ 'version' => '2.0', 'service' => '<p> The FinSpace APIs let you take actions inside the FinSpace.</p>', 'operations' => [ 'CreateChangeset' => '<p>Creates a new Changeset in a FinSpace Dataset.</p>', 'CreateDataView' => '<p>Creates a Dataview for a Dataset.</p>', 'CreateDataset' => '<p>Creates a new FinSpace Dataset.</p>', 'CreatePermissionGroup' => '<p>Creates a group of permissions for various actions that a user can perform in FinSpace.</p>', 'CreateUser' => '<p>Creates a new user in FinSpace.</p>', 'DeleteDataset' => '<p>Deletes a FinSpace Dataset.</p>', 'DeletePermissionGroup' => '<p>Deletes a permission group. This action is irreversible.</p>', 'DisableUser' => '<p>Denies access to the FinSpace web application and API for the specified user.</p>', 'EnableUser' => '<p> Allows the specified user to access the FinSpace web application and API.</p>', 'GetChangeset' => '<p>Get information about a Changeset.</p>', 'GetDataView' => '<p>Gets information about a Dataview.</p>', 'GetDataset' => '<p>Returns information about a Dataset.</p>', 'GetProgrammaticAccessCredentials' => '<p>Request programmatic credentials to use with FinSpace SDK.</p>', 'GetUser' => '<p>Retrieves details for a specific user.</p>', 'GetWorkingLocation' => '<p>A temporary Amazon S3 location, where you can copy your files from a source location to stage or use as a scratch space in FinSpace notebook.</p>', 'ListChangesets' => '<p>Lists the FinSpace Changesets for a Dataset.</p>', 'ListDataViews' => '<p>Lists all available Dataviews for a Dataset.</p>', 'ListDatasets' => '<p>Lists all of the active Datasets that a user has access to.</p>', 'ListPermissionGroups' => '<p>Lists all available permission groups in FinSpace.</p>', 'ListUsers' => '<p>Lists all available user accounts in FinSpace.</p>', 'ResetUserPassword' => '<p>Resets the password for a specified user ID and generates a temporary one. Only a superuser can reset password for other users. Resetting the password immediately invalidates the previous password associated with the user.</p>', 'UpdateChangeset' => '<p>Updates a FinSpace Changeset.</p>', 'UpdateDataset' => '<p>Updates a FinSpace Dataset.</p>', 'UpdatePermissionGroup' => '<p>Modifies the details of a permission group. You cannot modify a <code>permissionGroupID</code>.</p>', 'UpdateUser' => '<p>Modifies the details of the specified user account. You cannot update the <code>userId</code> for a user.</p>', ], 'shapes' => [ 'AccessDeniedException' => [ 'base' => '<p>You do not have sufficient access to perform this action.</p>', 'refs' => [], ], 'AliasString' => [ 'base' => NULL, 'refs' => [ 'CreateDatasetRequest$alias' => '<p>The unique resource identifier for a Dataset.</p>', 'Dataset$alias' => '<p>The unique resource identifier for a Dataset.</p>', 'GetDatasetResponse$alias' => '<p>The unique resource identifier for a Dataset.</p>', 'UpdateDatasetRequest$alias' => '<p>The unique resource identifier for a Dataset.</p>', ], ], 'ApiAccess' => [ 'base' => NULL, 'refs' => [ 'CreateUserRequest$ApiAccess' => '<p>The option to indicate whether the user can use the <code>GetProgrammaticAccessCredentials</code> API to obtain credentials that can then be used to access other FinSpace Data API operations.</p> <ul> <li> <p> <code>ENABLED</code> – The user has permissions to use the APIs.</p> </li> <li> <p> <code>DISABLED</code> – The user does not have permissions to use any APIs.</p> </li> </ul>', 'GetUserResponse$apiAccess' => '<p>Indicates whether the user can use the <code>GetProgrammaticAccessCredentials</code> API to obtain credentials that can then be used to access other FinSpace Data API operations. </p> <ul> <li> <p> <code>ENABLED</code> – The user has permissions to use the APIs.</p> </li> <li> <p> <code>DISABLED</code> – The user does not have permissions to use any APIs.</p> </li> </ul>', 'UpdateUserRequest$apiAccess' => '<p>The option to indicate whether the user can use the <code>GetProgrammaticAccessCredentials</code> API to obtain credentials that can then be used to access other FinSpace Data API operations.</p> <ul> <li> <p> <code>ENABLED</code> – The user has permissions to use the APIs.</p> </li> <li> <p> <code>DISABLED</code> – The user does not have permissions to use any APIs.</p> </li> </ul>', 'User$apiAccess' => '<p>Indicates whether the user can use the <code>GetProgrammaticAccessCredentials</code> API to obtain credentials that can then be used to access other FinSpace Data API operations.</p> <ul> <li> <p> <code>ENABLED</code> – The user has permissions to use the APIs.</p> </li> <li> <p> <code>DISABLED</code> – The user does not have permissions to use any APIs.</p> </li> </ul>', ], ], 'ApplicationPermission' => [ 'base' => NULL, 'refs' => [ 'ApplicationPermissionList$member' => NULL, ], ], 'ApplicationPermissionList' => [ 'base' => NULL, 'refs' => [ 'CreatePermissionGroupRequest$applicationPermissions' => '<p>The option to indicate FinSpace application permissions that are granted to a specific group.</p> <ul> <li> <p> <code>CreateDataset</code> – Group members can create new datasets.</p> </li> <li> <p> <code>ManageClusters</code> – Group members can manage Apache Spark clusters from FinSpace notebooks.</p> </li> <li> <p> <code>ManageUsersAndGroups</code> – Group members can manage users and permission groups.</p> </li> <li> <p> <code>ManageAttributeSets</code> – Group members can manage attribute sets.</p> </li> <li> <p> <code>ViewAuditData</code> – Group members can view audit data.</p> </li> <li> <p> <code>AccessNotebooks</code> – Group members will have access to FinSpace notebooks.</p> </li> <li> <p> <code>GetTemporaryCredentials</code> – Group members can get temporary API credentials.</p> </li> </ul>', 'PermissionGroup$applicationPermissions' => '<p>Indicates the permissions that are granted to a specific group for accessing the FinSpace application.</p> <ul> <li> <p> <code>CreateDataset</code> – Group members can create new datasets.</p> </li> <li> <p> <code>ManageClusters</code> – Group members can manage Apache Spark clusters from FinSpace notebooks.</p> </li> <li> <p> <code>ManageUsersAndGroups</code> – Group members can manage users and permission groups.</p> </li> <li> <p> <code>ManageAttributeSets</code> – Group members can manage attribute sets.</p> </li> <li> <p> <code>ViewAuditData</code> – Group members can view audit data.</p> </li> <li> <p> <code>AccessNotebooks</code> – Group members will have access to FinSpace notebooks.</p> </li> <li> <p> <code>GetTemporaryCredentials</code> – Group members can get temporary API credentials.</p> </li> </ul>', 'UpdatePermissionGroupRequest$applicationPermissions' => '<p>The permissions that are granted to a specific group for accessing the FinSpace application.</p> <ul> <li> <p> <code>CreateDataset</code> – Group members can create new datasets.</p> </li> <li> <p> <code>ManageClusters</code> – Group members can manage Apache Spark clusters from FinSpace notebooks.</p> </li> <li> <p> <code>ManageUsersAndGroups</code> – Group members can manage users and permission groups.</p> </li> <li> <p> <code>ManageAttributeSets</code> – Group members can manage attribute sets.</p> </li> <li> <p> <code>ViewAuditData</code> – Group members can view audit data.</p> </li> <li> <p> <code>AccessNotebooks</code> – Group members will have access to FinSpace notebooks.</p> </li> <li> <p> <code>GetTemporaryCredentials</code> – Group members can get temporary API credentials.</p> </li> </ul>', ], ], 'Boolean' => [ 'base' => 'Common Boolean data type', 'refs' => [ 'CreateDataViewRequest$autoUpdate' => '<p>Flag to indicate Dataview should be updated automatically.</p>', 'DataViewSummary$autoUpdate' => '<p>The flag to indicate Dataview should be updated automatically.</p>', 'GetDataViewResponse$autoUpdate' => '<p>Flag to indicate Dataview should be updated automatically.</p>', ], ], 'ChangeType' => [ 'base' => 'Indicates how the given change will be applied to the dataset.', 'refs' => [ 'ChangesetSummary$changeType' => '<p>Type that indicates how a Changeset is applied to a Dataset.</p> <ul> <li> <p> <code>REPLACE</code> – Changeset is considered as a replacement to all prior loaded Changesets.</p> </li> <li> <p> <code>APPEND</code> – Changeset is considered as an addition to the end of all prior loaded Changesets.</p> </li> <li> <p> <code>MODIFY</code> – Changeset is considered as a replacement to a specific prior ingested Changeset.</p> </li> </ul>', 'CreateChangesetRequest$changeType' => '<p>The option to indicate how a Changeset will be applied to a Dataset.</p> <ul> <li> <p> <code>REPLACE</code> – Changeset will be considered as a replacement to all prior loaded Changesets.</p> </li> <li> <p> <code>APPEND</code> – Changeset will be considered as an addition to the end of all prior loaded Changesets.</p> </li> <li> <p> <code>MODIFY</code> – Changeset is considered as a replacement to a specific prior ingested Changeset.</p> </li> </ul>', 'GetChangesetResponse$changeType' => '<p>Type that indicates how a Changeset is applied to a Dataset.</p> <ul> <li> <p> <code>REPLACE</code> – Changeset is considered as a replacement to all prior loaded Changesets.</p> </li> <li> <p> <code>APPEND</code> – Changeset is considered as an addition to the end of all prior loaded Changesets.</p> </li> <li> <p> <code>MODIFY</code> – Changeset is considered as a replacement to a specific prior ingested Changeset.</p> </li> </ul>', ], ], 'ChangesetArn' => [ 'base' => 'Arn for a given Changeset', 'refs' => [ 'ChangesetSummary$changesetArn' => '<p>The ARN identifier of the Changeset.</p>', 'GetChangesetResponse$changesetArn' => '<p>The ARN identifier of the Changeset.</p>', ], ], 'ChangesetErrorInfo' => [ 'base' => '<p>The structure with error messages.</p>', 'refs' => [ 'ChangesetSummary$errorInfo' => '<p>The structure with error messages.</p>', 'GetChangesetResponse$errorInfo' => '<p>The structure with error messages.</p>', ], ], 'ChangesetId' => [ 'base' => 'ID used to identify a Changeset', 'refs' => [ 'ChangesetSummary$changesetId' => '<p>The unique identifier for a Changeset.</p>', 'ChangesetSummary$updatesChangesetId' => '<p>The unique identifier of the Changeset that is updated.</p>', 'ChangesetSummary$updatedByChangesetId' => '<p>The unique identifier of the updated Changeset.</p>', 'CreateChangesetResponse$changesetId' => '<p>The unique identifier of the Changeset that is created.</p>', 'GetChangesetRequest$changesetId' => '<p>The unique identifier of the Changeset for which to get data.</p>', 'GetChangesetResponse$changesetId' => '<p>The unique identifier for a Changeset.</p>', 'GetChangesetResponse$updatesChangesetId' => '<p>The unique identifier of the Changeset that is being updated.</p>', 'GetChangesetResponse$updatedByChangesetId' => '<p>The unique identifier of the updated Changeset.</p>', 'UpdateChangesetRequest$changesetId' => '<p>The unique identifier for the Changeset to update.</p>', 'UpdateChangesetResponse$changesetId' => '<p>The unique identifier for the Changeset to update.</p>', ], ], 'ChangesetList' => [ 'base' => 'List of Changeset Summaries', 'refs' => [ 'ListChangesetsResponse$changesets' => '<p>List of Changesets found.</p>', ], ], 'ChangesetSummary' => [ 'base' => '<p>A Changeset is unit of data in a Dataset.</p>', 'refs' => [ 'ChangesetList$member' => NULL, ], ], 'ClientToken' => [ 'base' => 'Idempotence Token for API operations', 'refs' => [ 'CreateChangesetRequest$clientToken' => '<p>A token that ensures idempotency. This token expires in 10 minutes.</p>', 'CreateDataViewRequest$clientToken' => '<p>A token that ensures idempotency. This token expires in 10 minutes.</p>', 'CreateDatasetRequest$clientToken' => '<p>A token that ensures idempotency. This token expires in 10 minutes.</p>', 'CreatePermissionGroupRequest$clientToken' => '<p>A token that ensures idempotency. This token expires in 10 minutes.</p>', 'CreateUserRequest$clientToken' => '<p>A token that ensures idempotency. This token expires in 10 minutes.</p>', 'DeleteDatasetRequest$clientToken' => '<p>A token that ensures idempotency. This token expires in 10 minutes.</p>', 'DeletePermissionGroupRequest$clientToken' => '<p>A token that ensures idempotency. This token expires in 10 minutes.</p>', 'DisableUserRequest$clientToken' => '<p>A token that ensures idempotency. This token expires in 10 minutes.</p>', 'EnableUserRequest$clientToken' => '<p>A token that ensures idempotency. This token expires in 10 minutes.</p>', 'ResetUserPasswordRequest$clientToken' => '<p>A token that ensures idempotency. This token expires in 10 minutes.</p>', 'UpdateChangesetRequest$clientToken' => '<p>A token that ensures idempotency. This token expires in 10 minutes.</p>', 'UpdateDatasetRequest$clientToken' => '<p>A token that ensures idempotency. This token expires in 10 minutes.</p>', 'UpdatePermissionGroupRequest$clientToken' => '<p>A token that ensures idempotency. This token expires in 10 minutes.</p>', 'UpdateUserRequest$clientToken' => '<p>A token that ensures idempotency. This token expires in 10 minutes.</p>', ], ], 'ColumnDataType' => [ 'base' => 'Data type of a column.', 'refs' => [ 'ColumnDefinition$dataType' => '<p>Data type of a column.</p> <ul> <li> <p> <code>STRING</code> – A String data type.</p> <p> <code>CHAR</code> – A char data type.</p> <p> <code>INTEGER</code> – An integer data type.</p> <p> <code>TINYINT</code> – A tinyint data type.</p> <p> <code>SMALLINT</code> – A smallint data type.</p> <p> <code>BIGINT</code> – A bigint data type.</p> <p> <code>FLOAT</code> – A float data type.</p> <p> <code>DOUBLE</code> – A double data type.</p> <p> <code>DATE</code> – A date data type.</p> <p> <code>DATETIME</code> – A datetime data type.</p> <p> <code>BOOLEAN</code> – A boolean data type.</p> <p> <code>BINARY</code> – A binary data type.</p> </li> </ul>', ], ], 'ColumnDefinition' => [ 'base' => '<p>The definition of a column in a tabular Dataset.</p>', 'refs' => [ 'ColumnList$member' => NULL, ], ], 'ColumnDescription' => [ 'base' => 'Column Description', 'refs' => [ 'ColumnDefinition$columnDescription' => '<p>Description for a column.</p>', ], ], 'ColumnList' => [ 'base' => 'List of Column Definitions', 'refs' => [ 'SchemaDefinition$columns' => '<p>List of column definitions.</p>', ], ], 'ColumnName' => [ 'base' => 'Column Name', 'refs' => [ 'ColumnDefinition$columnName' => '<p>The name of a column.</p>', 'ColumnNameList$member' => NULL, ], ], 'ColumnNameList' => [ 'base' => 'List of Column Names', 'refs' => [ 'SchemaDefinition$primaryKeyColumns' => '<p>List of column names used for primary key.</p>', ], ], 'ConflictException' => [ 'base' => '<p>The request conflicts with an existing resource.</p>', 'refs' => [], ], 'CreateChangesetRequest' => [ 'base' => 'The request for a CreateChangeset operation.', 'refs' => [], ], 'CreateChangesetResponse' => [ 'base' => 'The response from a CreateChangeset operation.', 'refs' => [], ], 'CreateDataViewRequest' => [ 'base' => 'Request for creating a data view.', 'refs' => [], ], 'CreateDataViewResponse' => [ 'base' => 'Response for creating a data view.', 'refs' => [], ], 'CreateDatasetRequest' => [ 'base' => 'The request for a CreateDataset operation', 'refs' => [], ], 'CreateDatasetResponse' => [ 'base' => 'The response from a CreateDataset operation', 'refs' => [], ], 'CreatePermissionGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreatePermissionGroupResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateUserRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateUserResponse' => [ 'base' => NULL, 'refs' => [], ], 'Credentials' => [ 'base' => '<p>Short term API credentials.</p>', 'refs' => [ 'GetProgrammaticAccessCredentialsResponse$credentials' => '<p>Returns the programmatic credentials.</p>', ], ], 'DataViewArn' => [ 'base' => 'Arn of a DataView', 'refs' => [ 'DataViewSummary$dataViewArn' => '<p>The ARN identifier of the Dataview.</p>', 'GetDataViewResponse$dataViewArn' => '<p>The ARN identifier of the Dataview.</p>', ], ], 'DataViewDestinationType' => [ 'base' => 'DataView Destination Type', 'refs' => [ 'DataViewDestinationTypeParams$destinationType' => '<p>Destination type for a Dataview.</p> <ul> <li> <p> <code>GLUE_TABLE</code> – Glue table destination type.</p> </li> <li> <p> <code>S3</code> – S3 destination type.</p> </li> </ul>', ], ], 'DataViewDestinationTypeParams' => [ 'base' => '<p>Structure for the Dataview destination type parameters.</p>', 'refs' => [ 'CreateDataViewRequest$destinationTypeParams' => '<p>Options that define the destination type for the Dataview.</p>', 'DataViewSummary$destinationTypeProperties' => '<p>Information about the Dataview destination.</p>', 'GetDataViewResponse$destinationTypeParams' => '<p>Options that define the destination type for the Dataview.</p>', ], ], 'DataViewErrorInfo' => [ 'base' => '<p>The structure with error messages.</p>', 'refs' => [ 'DataViewSummary$errorInfo' => '<p>The structure with error messages.</p>', 'GetDataViewResponse$errorInfo' => '<p>Information about an error that occurred for the Dataview.</p>', ], ], 'DataViewId' => [ 'base' => 'DataView ID', 'refs' => [ 'CreateDataViewResponse$dataViewId' => '<p>The unique identifier for the created Dataview.</p>', 'DataViewSummary$dataViewId' => '<p>The unique identifier for the Dataview.</p>', 'GetDataViewRequest$dataViewId' => '<p>The unique identifier for the Dataview.</p>', 'GetDataViewResponse$dataViewId' => '<p>The unique identifier for the Dataview.</p>', ], ], 'DataViewList' => [ 'base' => 'List of Data Views', 'refs' => [ 'ListDataViewsResponse$dataViews' => '<p>A list of Dataviews.</p>', ], ], 'DataViewStatus' => [ 'base' => 'Status of a DataView', 'refs' => [ 'DataViewSummary$status' => '<p>The status of a Dataview creation.</p> <ul> <li> <p> <code>RUNNING</code> – Dataview creation is running.</p> </li> <li> <p> <code>STARTING</code> – Dataview creation is starting.</p> </li> <li> <p> <code>FAILED</code> – Dataview creation has failed.</p> </li> <li> <p> <code>CANCELLED</code> – Dataview creation has been cancelled.</p> </li> <li> <p> <code>TIMEOUT</code> – Dataview creation has timed out.</p> </li> <li> <p> <code>SUCCESS</code> – Dataview creation has succeeded.</p> </li> <li> <p> <code>PENDING</code> – Dataview creation is pending.</p> </li> <li> <p> <code>FAILED_CLEANUP_FAILED</code> – Dataview creation failed and resource cleanup failed.</p> </li> </ul>', 'GetDataViewResponse$status' => '<p>The status of a Dataview creation.</p> <ul> <li> <p> <code>RUNNING</code> – Dataview creation is running.</p> </li> <li> <p> <code>STARTING</code> – Dataview creation is starting.</p> </li> <li> <p> <code>FAILED</code> – Dataview creation has failed.</p> </li> <li> <p> <code>CANCELLED</code> – Dataview creation has been cancelled.</p> </li> <li> <p> <code>TIMEOUT</code> – Dataview creation has timed out.</p> </li> <li> <p> <code>SUCCESS</code> – Dataview creation has succeeded.</p> </li> <li> <p> <code>PENDING</code> – Dataview creation is pending.</p> </li> <li> <p> <code>FAILED_CLEANUP_FAILED</code> – Dataview creation failed and resource cleanup failed.</p> </li> </ul>', ], ], 'DataViewSummary' => [ 'base' => '<p>Structure for the summary of a Dataview.</p>', 'refs' => [ 'DataViewList$member' => NULL, ], ], 'Dataset' => [ 'base' => '<p>The structure for a Dataset.</p>', 'refs' => [ 'DatasetList$member' => NULL, ], ], 'DatasetArn' => [ 'base' => 'Arn of a Dataset', 'refs' => [ 'Dataset$datasetArn' => '<p>The ARN identifier of the Dataset.</p>', 'GetDatasetResponse$datasetArn' => '<p>The ARN identifier of the Dataset.</p>', ], ], 'DatasetDescription' => [ 'base' => 'Description of a dataset', 'refs' => [ 'CreateDatasetRequest$datasetDescription' => '<p>Description of a Dataset.</p>', 'Dataset$datasetDescription' => '<p>Description for a Dataset.</p>', 'GetDatasetResponse$datasetDescription' => '<p>A description of the Dataset.</p>', 'UpdateDatasetRequest$datasetDescription' => '<p>A description for the Dataset.</p>', ], ], 'DatasetId' => [ 'base' => 'ID for a given Dataset', 'refs' => [ 'ChangesetSummary$datasetId' => '<p>The unique identifier for the FinSpace Dataset in which the Changeset is created.</p>', 'CreateChangesetRequest$datasetId' => '<p>The unique identifier for the FinSpace Dataset where the Changeset will be created. </p>', 'CreateChangesetResponse$datasetId' => '<p>The unique identifier for the FinSpace Dataset where the Changeset is created.</p>', 'CreateDataViewRequest$datasetId' => '<p>The unique Dataset identifier that is used to create a Dataview.</p>', 'CreateDataViewResponse$datasetId' => '<p>The unique identifier of the Dataset used for the Dataview.</p>', 'CreateDatasetResponse$datasetId' => '<p>The unique identifier for the created Dataset.</p>', 'DataViewSummary$datasetId' => '<p>Th unique identifier for the Dataview Dataset.</p>', 'Dataset$datasetId' => '<p>An identifier for a Dataset.</p>', 'DeleteDatasetRequest$datasetId' => '<p>The unique identifier of the Dataset to be deleted.</p>', 'DeleteDatasetResponse$datasetId' => '<p>The unique identifier for the deleted Dataset.</p>', 'GetChangesetRequest$datasetId' => '<p>The unique identifier for the FinSpace Dataset where the Changeset is created.</p>', 'GetChangesetResponse$datasetId' => '<p>The unique identifier for the FinSpace Dataset where the Changeset is created.</p>', 'GetDataViewRequest$datasetId' => '<p>The unique identifier for the Dataset used in the Dataview.</p>', 'GetDataViewResponse$datasetId' => '<p>The unique identifier for the Dataset used in the Dataview.</p>', 'GetDatasetResponse$datasetId' => '<p>The unique identifier for a Dataset.</p>', 'ListChangesetsRequest$datasetId' => '<p>The unique identifier for the FinSpace Dataset to which the Changeset belongs.</p>', 'ListDataViewsRequest$datasetId' => '<p>The unique identifier of the Dataset for which to retrieve Dataviews.</p>', 'UpdateChangesetRequest$datasetId' => '<p>The unique identifier for the FinSpace Dataset in which the Changeset is created.</p>', 'UpdateChangesetResponse$datasetId' => '<p>The unique identifier for the FinSpace Dataset in which the Changeset is created.</p>', 'UpdateDatasetRequest$datasetId' => '<p>The unique identifier for the Dataset to update.</p>', 'UpdateDatasetResponse$datasetId' => '<p>The unique identifier for updated Dataset.</p>', ], ], 'DatasetKind' => [ 'base' => 'Dataset Kind', 'refs' => [ 'CreateDatasetRequest$kind' => '<p>The format in which Dataset data is structured.</p> <ul> <li> <p> <code>TABULAR</code> – Data is structured in a tabular format.</p> </li> <li> <p> <code>NON_TABULAR</code> – Data is structured in a non-tabular format.</p> </li> </ul>', 'Dataset$kind' => '<p>The format in which Dataset data is structured.</p> <ul> <li> <p> <code>TABULAR</code> – Data is structured in a tabular format.</p> </li> <li> <p> <code>NON_TABULAR</code> – Data is structured in a non-tabular format.</p> </li> </ul>', 'GetDatasetResponse$kind' => '<p>The format in which Dataset data is structured.</p> <ul> <li> <p> <code>TABULAR</code> – Data is structured in a tabular format.</p> </li> <li> <p> <code>NON_TABULAR</code> – Data is structured in a non-tabular format.</p> </li> </ul>', 'UpdateDatasetRequest$kind' => '<p>The format in which the Dataset data is structured.</p> <ul> <li> <p> <code>TABULAR</code> – Data is structured in a tabular format.</p> </li> <li> <p> <code>NON_TABULAR</code> – Data is structured in a non-tabular format.</p> </li> </ul>', ], ], 'DatasetList' => [ 'base' => 'List of Dataset structures', 'refs' => [ 'ListDatasetsResponse$datasets' => '<p>List of Datasets.</p>', ], ], 'DatasetOwnerInfo' => [ 'base' => '<p>A structure for Dataset owner info.</p>', 'refs' => [ 'CreateDatasetRequest$ownerInfo' => '<p>Contact information for a Dataset owner.</p>', 'Dataset$ownerInfo' => '<p>Contact information for a Dataset owner.</p>', ], ], 'DatasetStatus' => [ 'base' => 'Status of the dataset process returned from scheduler service.', 'refs' => [ 'GetDatasetResponse$status' => '<p>Status of the Dataset creation.</p> <ul> <li> <p> <code>PENDING</code> – Dataset is pending creation.</p> </li> <li> <p> <code>FAILED</code> – Dataset creation has failed.</p> </li> <li> <p> <code>SUCCESS</code> – Dataset creation has succeeded.</p> </li> <li> <p> <code>RUNNING</code> – Dataset creation is running.</p> </li> </ul>', ], ], 'DatasetTitle' => [ 'base' => 'Title for a given Dataset', 'refs' => [ 'CreateDatasetRequest$datasetTitle' => '<p>Display title for a FinSpace Dataset.</p>', 'Dataset$datasetTitle' => '<p>Display title for a Dataset.</p>', 'GetDatasetResponse$datasetTitle' => '<p>Display title for a Dataset.</p>', 'UpdateDatasetRequest$datasetTitle' => '<p>A display title for the Dataset.</p>', ], ], 'DeleteDatasetRequest' => [ 'base' => 'The request for a DeleteDataset operation.', 'refs' => [], ], 'DeleteDatasetResponse' => [ 'base' => 'The response from an DeleteDataset operation', 'refs' => [], ], 'DeletePermissionGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeletePermissionGroupResponse' => [ 'base' => NULL, 'refs' => [], ], 'DisableUserRequest' => [ 'base' => NULL, 'refs' => [], ], 'DisableUserResponse' => [ 'base' => NULL, 'refs' => [], ], 'Email' => [ 'base' => NULL, 'refs' => [ 'CreateUserRequest$emailAddress' => '<p>The email address of the user that you want to register. The email address serves as a uniquer identifier for each user and cannot be changed after it\'s created.</p>', 'DatasetOwnerInfo$email' => '<p>Email address for the Dataset owner.</p>', 'GetUserResponse$emailAddress' => '<p>The email address that is associated with the user.</p>', 'User$emailAddress' => '<p>The email address of the user. The email address serves as a uniquer identifier for each user and cannot be changed after it\'s created.</p>', ], ], 'EnableUserRequest' => [ 'base' => NULL, 'refs' => [], ], 'EnableUserResponse' => [ 'base' => NULL, 'refs' => [], ], 'ErrorCategory' => [ 'base' => 'Changeset Error Category', 'refs' => [ 'ChangesetErrorInfo$errorCategory' => '<p>The category of the error.</p> <ul> <li> <p> <code>VALIDATION</code> – The inputs to this request are invalid.</p> </li> <li> <p> <code>SERVICE_QUOTA_EXCEEDED</code> – Service quotas have been exceeded. Please contact AWS support to increase quotas.</p> </li> <li> <p> <code>ACCESS_DENIED</code> – Missing required permission to perform this request.</p> </li> <li> <p> <code>RESOURCE_NOT_FOUND</code> – One or more inputs to this request were not found.</p> </li> <li> <p> <code>THROTTLING</code> – The system temporarily lacks sufficient resources to process the request.</p> </li> <li> <p> <code>INTERNAL_SERVICE_EXCEPTION</code> – An internal service error has occurred.</p> </li> <li> <p> <code>CANCELLED</code> – Cancelled.</p> </li> <li> <p> <code>USER_RECOVERABLE</code> – A user recoverable error has occurred.</p> </li> </ul>', 'DataViewErrorInfo$errorCategory' => '<p>The category of the error.</p> <ul> <li> <p> <code>VALIDATION</code> – The inputs to this request are invalid.</p> </li> <li> <p> <code>SERVICE_QUOTA_EXCEEDED</code> – Service quotas have been exceeded. Please contact AWS support to increase quotas.</p> </li> <li> <p> <code>ACCESS_DENIED</code> – Missing required permission to perform this request.</p> </li> <li> <p> <code>RESOURCE_NOT_FOUND</code> – One or more inputs to this request were not found.</p> </li> <li> <p> <code>THROTTLING</code> – The system temporarily lacks sufficient resources to process the request.</p> </li> <li> <p> <code>INTERNAL_SERVICE_EXCEPTION</code> – An internal service error has occurred.</p> </li> <li> <p> <code>CANCELLED</code> – Cancelled.</p> </li> <li> <p> <code>USER_RECOVERABLE</code> – A user recoverable error has occurred.</p> </li> </ul>', ], ], 'ErrorMessage' => [ 'base' => 'Changeset Error Message', 'refs' => [ 'ChangesetErrorInfo$errorMessage' => '<p>The text of the error message.</p>', 'DataViewErrorInfo$errorMessage' => '<p>The text of the error message.</p>', ], ], 'ExportFileFormat' => [ 'base' => 'Data View Export File Format', 'refs' => [ 'DataViewDestinationTypeParams$s3DestinationExportFileFormat' => '<p>Data view export file format.</p> <ul> <li> <p> <code>PARQUET</code> – Parquet export file format.</p> </li> <li> <p> <code>DELIMITED_TEXT</code> – Delimited text export file format.</p> </li> </ul>', ], ], 'FirstName' => [ 'base' => NULL, 'refs' => [ 'CreateUserRequest$firstName' => '<p>The first name of the user that you want to register.</p>', 'GetUserResponse$firstName' => '<p>The first name of the user.</p>', 'UpdateUserRequest$firstName' => '<p>The first name of the user.</p>', 'User$firstName' => '<p>The first name of the user.</p>', ], ], 'FormatParams' => [ 'base' => 'Format Parameters of a Changeset', 'refs' => [ 'ChangesetSummary$formatParams' => '<p>Options that define the structure of the source file(s).</p>', 'CreateChangesetRequest$formatParams' => '<p>Options that define the structure of the source file(s) including the format type (<code>formatType</code>), header row (<code>withHeader</code>), data separation character (<code>separator</code>) and the type of compression (<code>compression</code>). </p> <p> <code>formatType</code> is a required attribute and can have the following values: </p> <ul> <li> <p> <code>PARQUET</code> – Parquet source file format.</p> </li> <li> <p> <code>CSV</code> – CSV source file format.</p> </li> <li> <p> <code>JSON</code> – JSON source file format.</p> </li> <li> <p> <code>XML</code> – XML source file format.</p> </li> </ul> <p>Here is an example of how you could specify the <code>formatParams</code>:</p> <p> <code> "formatParams": { "formatType": "CSV", "withHeader": "true", "separator": ",", "compression":"None" } </code> </p> <p>Note that if you only provide <code>formatType</code> as <code>CSV</code>, the rest of the attributes will automatically default to CSV values as following:</p> <p> <code> { "withHeader": "true", "separator": "," } </code> </p> <p> For more information about supported file formats, see <a href="https://docs.aws.amazon.com/finspace/latest/userguide/supported-data-types.html">Supported Data Types and File Formats</a> in the FinSpace User Guide.</p>', 'GetChangesetResponse$formatParams' => '<p>Structure of the source file(s).</p>', 'UpdateChangesetRequest$formatParams' => '<p>Options that define the structure of the source file(s) including the format type (<code>formatType</code>), header row (<code>withHeader</code>), data separation character (<code>separator</code>) and the type of compression (<code>compression</code>). </p> <p> <code>formatType</code> is a required attribute and can have the following values: </p> <ul> <li> <p> <code>PARQUET</code> – Parquet source file format.</p> </li> <li> <p> <code>CSV</code> – CSV source file format.</p> </li> <li> <p> <code>JSON</code> – JSON source file format.</p> </li> <li> <p> <code>XML</code> – XML source file format.</p> </li> </ul> <p>Here is an example of how you could specify the <code>formatParams</code>:</p> <p> <code> "formatParams": { "formatType": "CSV", "withHeader": "true", "separator": ",", "compression":"None" } </code> </p> <p>Note that if you only provide <code>formatType</code> as <code>CSV</code>, the rest of the attributes will automatically default to CSV values as following:</p> <p> <code> { "withHeader": "true", "separator": "," } </code> </p> <p> For more information about supported file formats, see <a href="https://docs.aws.amazon.com/finspace/latest/userguide/supported-data-types.html">Supported Data Types and File Formats</a> in the FinSpace User Guide.</p>', ], ], 'GetChangesetRequest' => [ 'base' => 'Request to describe a changeset.', 'refs' => [], ], 'GetChangesetResponse' => [ 'base' => 'The response from a describe changeset operation', 'refs' => [], ], 'GetDataViewRequest' => [ 'base' => 'Request for retrieving a data view detail. Grouped / accessible within a dataset by its dataset id.', 'refs' => [], ], 'GetDataViewResponse' => [ 'base' => 'Response from retrieving a dataview, which includes details on the target database and table name', 'refs' => [], ], 'GetDatasetRequest' => [ 'base' => 'Request for the GetDataset operation.', 'refs' => [], ], 'GetDatasetResponse' => [ 'base' => 'Response for the GetDataset operation', 'refs' => [], ], 'GetProgrammaticAccessCredentialsRequest' => [ 'base' => 'Request for GetProgrammaticAccessCredentials operation', 'refs' => [], ], 'GetProgrammaticAccessCredentialsResponse' => [ 'base' => 'Response for GetProgrammaticAccessCredentials operation', 'refs' => [], ], 'GetUserRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetUserResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetWorkingLocationRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetWorkingLocationResponse' => [ 'base' => NULL, 'refs' => [], ], 'IdType' => [ 'base' => NULL, 'refs' => [ 'GetProgrammaticAccessCredentialsRequest$environmentId' => '<p>The FinSpace environment identifier.</p>', ], ], 'IngestionStatus' => [ 'base' => 'Status of the ingestion process returned from scheduler service.', 'refs' => [ 'ChangesetSummary$status' => '<p>Status of the Changeset ingestion.</p> <ul> <li> <p> <code>PENDING</code> – Changeset is pending creation.</p> </li> <li> <p> <code>FAILED</code> – Changeset creation has failed.</p> </li> <li> <p> <code>SUCCESS</code> – Changeset creation has succeeded.</p> </li> <li> <p> <code>RUNNING</code> – Changeset creation is running.</p> </li> <li> <p> <code>STOP_REQUESTED</code> – User requested Changeset creation to stop.</p> </li> </ul>', 'GetChangesetResponse$status' => '<p>The status of Changeset creation operation.</p>', ], ], 'InternalServerException' => [ 'base' => '<p>The request processing has failed because of an unknown error, exception or failure.</p>', 'refs' => [], ], 'LastName' => [ 'base' => NULL, 'refs' => [ 'CreateUserRequest$lastName' => '<p>The last name of the user that you want to register.</p>', 'GetUserResponse$lastName' => '<p>The last name of the user.</p>', 'UpdateUserRequest$lastName' => '<p>The last name of the user.</p>', 'User$lastName' => '<p> The last name of the user.</p>', ], ], 'LimitExceededException' => [ 'base' => '<p>A limit has exceeded.</p>', 'refs' => [], ], 'ListChangesetsRequest' => [ 'base' => 'Request to ListChangesetsRequest. It exposes minimal query filters.', 'refs' => [], ], 'ListChangesetsResponse' => [ 'base' => 'Response to ListChangesetsResponse. This returns a list of dataset changesets that match the query criteria.', 'refs' => [], ], 'ListDataViewsRequest' => [ 'base' => 'Request for a list data views.', 'refs' => [], ], 'ListDataViewsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListDatasetsRequest' => [ 'base' => 'Request for the ListDatasets operation.', 'refs' => [], ], 'ListDatasetsResponse' => [ 'base' => 'Response for the ListDatasets operation', 'refs' => [], ], 'ListPermissionGroupsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListPermissionGroupsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListUsersRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListUsersResponse' => [ 'base' => NULL, 'refs' => [], ], 'OwnerName' => [ 'base' => '1 - 250 character String', 'refs' => [ 'DatasetOwnerInfo$name' => '<p>The name of the Dataset owner.</p>', ], ], 'PaginationToken' => [ 'base' => 'Pagination token for list operations', 'refs' => [ 'ListChangesetsRequest$nextToken' => '<p>A token that indicates where a results page should begin.</p>', 'ListChangesetsResponse$nextToken' => '<p>A token that indicates where a results page should begin.</p>', 'ListDataViewsRequest$nextToken' => '<p>A token that indicates where a results page should begin.</p>', 'ListDataViewsResponse$nextToken' => '<p>A token that indicates where a results page should begin.</p>', 'ListDatasetsRequest$nextToken' => '<p>A token that indicates where a results page should begin.</p>', 'ListDatasetsResponse$nextToken' => '<p>A token that indicates where a results page should begin.</p>', 'ListPermissionGroupsRequest$nextToken' => '<p>A token that indicates where a results page should begin.</p>', 'ListPermissionGroupsResponse$nextToken' => '<p>A token that indicates where a results page should begin.</p>', 'ListUsersRequest$nextToken' => '<p>A token that indicates where a results page should begin.</p>', 'ListUsersResponse$nextToken' => '<p>A token that indicates where a results page should begin.</p>', ], ], 'PartitionColumnList' => [ 'base' => 'DataView Partition Column List', 'refs' => [ 'CreateDataViewRequest$partitionColumns' => '<p>Ordered set of column names used to partition data.</p>', 'DataViewSummary$partitionColumns' => '<p>Ordered set of column names used to partition data.</p>', 'GetDataViewResponse$partitionColumns' => '<p>Ordered set of column names used to partition data.</p>', ], ], 'Password' => [ 'base' => NULL, 'refs' => [ 'ResetUserPasswordResponse$temporaryPassword' => '<p>A randomly generated temporary password for the requested user account. This password expires in 7 days.</p>', ], ], 'PermissionGroup' => [ 'base' => '<p>The structure for a permission group.</p>', 'refs' => [ 'PermissionGroupList$member' => NULL, ], ], 'PermissionGroupDescription' => [ 'base' => NULL, 'refs' => [ 'CreatePermissionGroupRequest$description' => '<p>A brief description for the permission group.</p>', 'PermissionGroup$description' => '<p> A brief description for the permission group.</p>', 'UpdatePermissionGroupRequest$description' => '<p>A brief description for the permission group.</p>', ], ], 'PermissionGroupId' => [ 'base' => NULL, 'refs' => [ 'CreatePermissionGroupResponse$permissionGroupId' => '<p>The unique identifier for the permission group.</p>', 'DeletePermissionGroupRequest$permissionGroupId' => '<p>The unique identifier for the permission group that you want to delete.</p>', 'DeletePermissionGroupResponse$permissionGroupId' => '<p>The unique identifier for the deleted permission group.</p>', 'PermissionGroup$permissionGroupId' => '<p> The unique identifier for the permission group.</p>', 'PermissionGroupParams$permissionGroupId' => '<p>The unique identifier for the <code>PermissionGroup</code>.</p>', 'UpdatePermissionGroupRequest$permissionGroupId' => '<p>The unique identifier for the permission group to update.</p>', 'UpdatePermissionGroupResponse$permissionGroupId' => '<p>The unique identifier for the updated permission group.</p>', ], ], 'PermissionGroupList' => [ 'base' => NULL, 'refs' => [ 'ListPermissionGroupsResponse$permissionGroups' => '<p>A list of all the permission groups.</p>', ], ], 'PermissionGroupName' => [ 'base' => NULL, 'refs' => [ 'CreatePermissionGroupRequest$name' => '<p>The name of the permission group.</p>', 'PermissionGroup$name' => '<p>The name of the permission group.</p>', 'UpdatePermissionGroupRequest$name' => '<p>The name of the permission group.</p>', ], ], 'PermissionGroupParams' => [ 'base' => '<p>Permission group parameters for Dataset permissions.</p> <p>Here is an example of how you could specify the <code>PermissionGroupParams</code>:</p> <p> <code> { "permissionGroupId": "0r6fCRtSTUk4XPfXQe3M0g", "datasetPermissions": [ {"permission": "ViewDatasetDetails"}, {"permission": "AddDatasetData"}, {"permission": "EditDatasetMetadata"}, {"permission": "DeleteDataset"} ] } </code> </p>', 'refs' => [ 'CreateDatasetRequest$permissionGroupParams' => '<p>Permission group parameters for Dataset permissions.</p>', ], ], 'PhoneNumber' => [ 'base' => 'PhoneNumber of Dataset Owner', 'refs' => [ 'DatasetOwnerInfo$phoneNumber' => '<p>Phone number for the Dataset owner.</p>', ], ], 'ResetUserPasswordRequest' => [ 'base' => NULL, 'refs' => [], ], 'ResetUserPasswordResponse' => [ 'base' => NULL, 'refs' => [], ], 'ResourceNotFoundException' => [ 'base' => '<p>One or more resources can\'t be found.</p>', 'refs' => [], ], 'ResourcePermission' => [ 'base' => '<p>Resource permission for a dataset. When you create a dataset, all the other members of the same user group inherit access to the dataset. You can only create a dataset if your user group has application permission for Create Datasets.</p> <p>The following is a list of valid dataset permissions that you can apply: </p> <ul> <li> <p> <code>ViewDatasetDetails</code> </p> </li> <li> <p> <code>ReadDatasetDetails</code> </p> </li> <li> <p> <code>AddDatasetData</code> </p> </li> <li> <p> <code>CreateSnapshot</code> </p> </li> <li> <p> <code>EditDatasetMetadata</code> </p> </li> <li> <p> <code>DeleteDataset</code> </p> </li> </ul> <p>For more information on the dataset permissions, see <a href="https://docs.aws.amazon.com/finspace/latest/userguide/managing-user-permissions.html#supported-dataset-permissions">Supported Dataset Permissions</a> in the FinSpace User Guide.</p>', 'refs' => [ 'ResourcePermissionsList$member' => NULL, ], ], 'ResourcePermissionsList' => [ 'base' => 'List of Resource Permissions', 'refs' => [ 'PermissionGroupParams$datasetPermissions' => '<p>List of resource permissions.</p>', ], ], 'ResultLimit' => [ 'base' => 'Maximum number of results to be returned as part of a list operation', 'refs' => [ 'ListChangesetsRequest$maxResults' => '<p>The maximum number of results per page.</p>', 'ListDataViewsRequest$maxResults' => '<p>The maximum number of results per page.</p>', 'ListDatasetsRequest$maxResults' => '<p>The maximum number of results per page.</p>', 'ListPermissionGroupsRequest$maxResults' => '<p>The maximum number of results per page.</p>', 'ListUsersRequest$maxResults' => '<p>The maximum number of results per page.</p>', ], ], 'RoleArn' => [ 'base' => NULL, 'refs' => [ 'CreateUserRequest$apiAccessPrincipalArn' => '<p>The ARN identifier of an AWS user or role that is allowed to call the <code>GetProgrammaticAccessCredentials</code> API to obtain a credentials token for a specific FinSpace user. This must be an IAM role within your FinSpace account.</p>', 'GetUserResponse$apiAccessPrincipalArn' => '<p>The ARN identifier of an AWS user or role that is allowed to call the <code>GetProgrammaticAccessCredentials</code> API to obtain a credentials token for a specific FinSpace user. This must be an IAM role within your FinSpace account.</p>', 'UpdateUserRequest$apiAccessPrincipalArn' => '<p>The ARN identifier of an AWS user or role that is allowed to call the <code>GetProgrammaticAccessCredentials</code> API to obtain a credentials token for a specific FinSpace user. This must be an IAM role within your FinSpace account.</p>', 'User$apiAccessPrincipalArn' => '<p>The ARN identifier of an AWS user or role that is allowed to call the <code>GetProgrammaticAccessCredentials</code> API to obtain a credentials token for a specific FinSpace user. This must be an IAM role within your FinSpace account.</p>', ], ], 'S3DestinationFormatOptions' => [ 'base' => NULL, 'refs' => [ 'DataViewDestinationTypeParams$s3DestinationExportFileFormatOptions' => '<p>Format Options for S3 Destination type.</p> <p>Here is an example of how you could specify the <code>s3DestinationExportFileFormatOptions</code> </p> <p> <code> { "header": "true", "delimiter": ",", "compression": "gzip" }</code> </p>', ], ], 'SchemaDefinition' => [ 'base' => '<p>Definition for a schema on a tabular Dataset.</p>', 'refs' => [ 'SchemaUnion$tabularSchemaConfig' => '<p>The configuration for a schema on a tabular Dataset.</p>', ], ], 'SchemaUnion' => [ 'base' => '<p>A union of schema types.</p>', 'refs' => [ 'CreateDatasetRequest$schemaDefinition' => '<p>Definition for a schema on a tabular Dataset.</p>', 'Dataset$schemaDefinition' => '<p>Definition for a schema on a tabular Dataset.</p>', 'GetDatasetResponse$schemaDefinition' => '<p>Definition for a schema on a tabular Dataset.</p>', 'UpdateDatasetRequest$schemaDefinition' => '<p>Definition for a schema on a tabular Dataset.</p>', ], ], 'SessionDuration' => [ 'base' => NULL, 'refs' => [ 'GetProgrammaticAccessCredentialsRequest$durationInMinutes' => '<p>The time duration in which the credentials remain valid. </p>', 'GetProgrammaticAccessCredentialsResponse$durationInMinutes' => '<p>Returns the duration in which the credentials will remain valid.</p>', ], ], 'SortColumnList' => [ 'base' => 'DataView Sort Column List', 'refs' => [ 'CreateDataViewRequest$sortColumns' => '<p>Columns to be used for sorting the data.</p>', 'DataViewSummary$sortColumns' => '<p>Columns to be used for sorting the data.</p>', 'GetDataViewResponse$sortColumns' => '<p>Columns to be used for sorting the data.</p>', ], ], 'SourceParams' => [ 'base' => 'Source Parameters of a Changeset', 'refs' => [ 'ChangesetSummary$sourceParams' => '<p>Options that define the location of the data being ingested.</p>', 'CreateChangesetRequest$sourceParams' => '<p>Options that define the location of the data being ingested (<code>s3SourcePath</code>) and the source of the changeset (<code>sourceType</code>).</p> <p>Both <code>s3SourcePath</code> and <code>sourceType</code> are required attributes.</p> <p>Here is an example of how you could specify the <code>sourceParams</code>:</p> <p> <code> "sourceParams": { "s3SourcePath": "s3://finspace-landing-us-east-2-bk7gcfvitndqa6ebnvys4d/scratch/wr5hh8pwkpqqkxa4sxrmcw/ingestion/equity.csv", "sourceType": "S3" } </code> </p> <p>The S3 path that you specify must allow the FinSpace role access. To do that, you first need to configure the IAM policy on S3 bucket. For more information, see <a href="https://docs.aws.amazon.com/finspace/latest/data-api/fs-using-the-finspace-api.html#access-s3-buckets">Loading data from an Amazon S3 Bucket using the FinSpace API</a> section.</p>', 'GetChangesetResponse$sourceParams' => '<p>Options that define the location of the data being ingested.</p>', 'UpdateChangesetRequest$sourceParams' => '<p>Options that define the location of the data being ingested (<code>s3SourcePath</code>) and the source of the changeset (<code>sourceType</code>).</p> <p>Both <code>s3SourcePath</code> and <code>sourceType</code> are required attributes.</p> <p>Here is an example of how you could specify the <code>sourceParams</code>:</p> <p> <code> "sourceParams": { "s3SourcePath": "s3://finspace-landing-us-east-2-bk7gcfvitndqa6ebnvys4d/scratch/wr5hh8pwkpqqkxa4sxrmcw/ingestion/equity.csv", "sourceType": "S3" } </code> </p> <p>The S3 path that you specify must allow the FinSpace role access. To do that, you first need to configure the IAM policy on S3 bucket. For more information, see <a href="https://docs.aws.amazon.com/finspace/latest/data-api/fs-using-the-finspace-api.html#access-s3-buckets">Loading data from an Amazon S3 Bucket using the FinSpace API</a>section.</p>', ], ], 'StringMapKey' => [ 'base' => NULL, 'refs' => [ 'FormatParams$key' => NULL, 'S3DestinationFormatOptions$key' => NULL, 'SourceParams$key' => NULL, ], ], 'StringMapValue' => [ 'base' => NULL, 'refs' => [ 'FormatParams$value' => NULL, 'S3DestinationFormatOptions$value' => NULL, 'SourceParams$value' => NULL, ], ], 'StringValueLength1to250' => [ 'base' => '1 - 250 character String', 'refs' => [ 'ResourcePermission$permission' => '<p>Permission for a resource.</p>', ], ], 'StringValueLength1to255' => [ 'base' => '1 - 255 character String', 'refs' => [ 'GetDatasetRequest$datasetId' => '<p>The unique identifier for a Dataset.</p>', 'PartitionColumnList$member' => NULL, 'SortColumnList$member' => NULL, ], ], 'ThrottlingException' => [ 'base' => '<p>The request was denied due to request throttling.</p>', 'refs' => [], ], 'TimestampEpoch' => [ 'base' => 'Milliseconds since UTC epoch', 'refs' => [ 'ChangesetSummary$createTime' => '<p>The timestamp at which the Changeset was created in FinSpace. The value is determined as epoch time in milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.</p>', 'ChangesetSummary$activeUntilTimestamp' => '<p>Time until which the Changeset is active. The value is determined as epoch time in milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.</p>', 'ChangesetSummary$activeFromTimestamp' => '<p>Beginning time from which the Changeset is active. The value is determined as epoch time in milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.</p>', 'CreateDataViewRequest$asOfTimestamp' => '<p>Beginning time to use for the Dataview. The value is determined as epoch time in milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.</p>', 'DataViewSummary$asOfTimestamp' => '<p>Time range to use for the Dataview. The value is determined as epoch time in milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.</p>', 'DataViewSummary$createTime' => '<p>The timestamp at which the Dataview was created in FinSpace. The value is determined as epoch time in milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.</p>', 'DataViewSummary$lastModifiedTime' => '<p>The last time that a Dataview was modified. The value is determined as epoch time in milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.</p>', 'Dataset$createTime' => '<p>The timestamp at which the Dataset was created in FinSpace. The value is determined as epoch time in milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.</p>', 'Dataset$lastModifiedTime' => '<p>The last time that the Dataset was modified. The value is determined as epoch time in milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.</p>', 'GetChangesetResponse$createTime' => '<p>The timestamp at which the Changeset was created in FinSpace. The value is determined as epoch time in milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.</p>', 'GetChangesetResponse$activeUntilTimestamp' => '<p>Time until which the Changeset is active. The value is determined as epoch time in milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.</p>', 'GetChangesetResponse$activeFromTimestamp' => '<p>Beginning time from which the Changeset is active. The value is determined as epoch time in milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.</p>', 'GetDataViewResponse$asOfTimestamp' => '<p>Time range to use for the Dataview. The value is determined as epoch time in milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.</p>', 'GetDataViewResponse$lastModifiedTime' => '<p>The last time that a Dataview was modified. The value is determined as epoch time in milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.</p>', 'GetDataViewResponse$createTime' => '<p>The timestamp at which the Dataview was created in FinSpace. The value is determined as epoch time in milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.</p>', 'GetDatasetResponse$createTime' => '<p>The timestamp at which the Dataset was created in FinSpace. The value is determined as epoch time in milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.</p>', 'GetDatasetResponse$lastModifiedTime' => '<p>The last time that the Dataset was modified. The value is determined as epoch time in milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.</p>', 'GetUserResponse$createTime' => '<p>The timestamp at which the user account was created in FinSpace. The value is determined as epoch time in milliseconds. </p>', 'GetUserResponse$lastEnabledTime' => '<p>Describes the last time the user account was enabled. The value is determined as epoch time in milliseconds.</p>', 'GetUserResponse$lastDisabledTime' => '<p>Describes the last time the user account was disabled. The value is determined as epoch time in milliseconds.</p>', 'GetUserResponse$lastModifiedTime' => '<p>Describes the last time the user account was updated. The value is determined as epoch time in milliseconds.</p>', 'GetUserResponse$lastLoginTime' => '<p>Describes the last time that the user logged into their account. The value is determined as epoch time in milliseconds.</p>', 'PermissionGroup$createTime' => '<p>The timestamp at which the group was created in FinSpace. The value is determined as epoch time in milliseconds. </p>', 'PermissionGroup$lastModifiedTime' => '<p>Describes the last time the permission group was updated. The value is determined as epoch time in milliseconds. </p>', 'User$createTime' => '<p>The timestamp at which the user account was created in FinSpace. The value is determined as epoch time in milliseconds. </p>', 'User$lastEnabledTime' => '<p> Describes the last time the user account was enabled. The value is determined as epoch time in milliseconds. </p>', 'User$lastDisabledTime' => '<p>Describes the last time the user account was disabled. The value is determined as epoch time in milliseconds.</p>', 'User$lastModifiedTime' => '<p>Describes the last time the user account was updated. The value is determined as epoch time in milliseconds. </p>', 'User$lastLoginTime' => '<p>Describes the last time that the user logged into their account. The value is determined as epoch time in milliseconds. </p>', ], ], 'UpdateChangesetRequest' => [ 'base' => 'Request to update an existing changeset.', 'refs' => [], ], 'UpdateChangesetResponse' => [ 'base' => 'The response from a update changeset operation.', 'refs' => [], ], 'UpdateDatasetRequest' => [ 'base' => 'The request for an UpdateDataset operation', 'refs' => [], ], 'UpdateDatasetResponse' => [ 'base' => 'The response from an UpdateDataset operation', 'refs' => [], ], 'UpdatePermissionGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdatePermissionGroupResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateUserRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateUserResponse' => [ 'base' => NULL, 'refs' => [], ], 'User' => [ 'base' => '<p>The details of the user account.</p>', 'refs' => [ 'UserList$member' => NULL, ], ], 'UserId' => [ 'base' => NULL, 'refs' => [ 'CreateUserResponse$userId' => '<p>The unique identifier for the user.</p>', 'DisableUserRequest$userId' => '<p>The unique identifier for the user account that you want to disable.</p>', 'DisableUserResponse$userId' => '<p>The unique identifier for the disabled user account.</p>', 'EnableUserRequest$userId' => '<p>The unique identifier for the user account that you want to enable.</p>', 'EnableUserResponse$userId' => '<p>The unique identifier for the enabled user account.</p>', 'GetUserRequest$userId' => '<p>The unique identifier of the user to get data for.</p>', 'GetUserResponse$userId' => '<p>The unique identifier for the user account that is retrieved.</p>', 'ResetUserPasswordRequest$userId' => '<p>The unique identifier of the user that a temporary password is requested for.</p>', 'ResetUserPasswordResponse$userId' => '<p>The unique identifier of the user that a new password is generated for.</p>', 'UpdateUserRequest$userId' => '<p>The unique identifier for the user account to update.</p>', 'UpdateUserResponse$userId' => '<p>The unique identifier of the updated user account.</p>', 'User$userId' => '<p>The unique identifier for the user.</p>', ], ], 'UserList' => [ 'base' => NULL, 'refs' => [ 'ListUsersResponse$users' => '<p>A list of all the user accounts.</p>', ], ], 'UserStatus' => [ 'base' => NULL, 'refs' => [ 'GetUserResponse$status' => '<p>The current status of the user account. </p> <ul> <li> <p> <code>CREATING</code> – The user account creation is in progress.</p> </li> <li> <p> <code>ENABLED</code> – The user account is created and is currently active.</p> </li> <li> <p> <code>DISABLED</code> – The user account is currently inactive.</p> </li> </ul>', 'User$status' => '<p>The current status of the user account. </p> <ul> <li> <p> <code>CREATING</code> – The user account creation is in progress.</p> </li> <li> <p> <code>ENABLED</code> – The user account is created and is currently active.</p> </li> <li> <p> <code>DISABLED</code> – The user account is currently inactive.</p> </li> </ul>', ], ], 'UserType' => [ 'base' => NULL, 'refs' => [ 'CreateUserRequest$type' => '<p>The option to indicate the type of user. Use one of the following options to specify this parameter:</p> <ul> <li> <p> <code>SUPER_USER</code> – A user with permission to all the functionality and data in FinSpace.</p> </li> <li> <p> <code>APP_USER</code> – A user with specific permissions in FinSpace. The users are assigned permissions by adding them to a permission group.</p> </li> </ul>', 'GetUserResponse$type' => '<p>Indicates the type of user. </p> <ul> <li> <p> <code>SUPER_USER</code> – A user with permission to all the functionality and data in FinSpace.</p> </li> </ul> <ul> <li> <p> <code>APP_USER</code> – A user with specific permissions in FinSpace. The users are assigned permissions by adding them to a permissions group.</p> </li> </ul>', 'UpdateUserRequest$type' => '<p>The option to indicate the type of user.</p> <ul> <li> <p> <code>SUPER_USER</code>– A user with permission to all the functionality and data in FinSpace.</p> </li> <li> <p> <code>APP_USER</code> – A user with specific permissions in FinSpace. The users are assigned permissions by adding them to a permissions group.</p> </li> </ul>', 'User$type' => '<p> Indicates the type of user.</p> <ul> <li> <p> <code>SUPER_USER</code> – A user with permission to all the functionality and data in FinSpace.</p> </li> <li> <p> <code>APP_USER</code> – A user with specific permissions in FinSpace. The users are assigned permissions by adding them to a permissions group.</p> </li> </ul>', ], ], 'ValidationException' => [ 'base' => '<p>The input fails to satisfy the constraints specified by an AWS service.</p>', 'refs' => [], ], 'errorMessage' => [ 'base' => NULL, 'refs' => [ 'AccessDeniedException$message' => NULL, 'ConflictException$message' => NULL, 'ConflictException$reason' => NULL, 'InternalServerException$message' => NULL, 'LimitExceededException$message' => NULL, 'ResourceNotFoundException$message' => NULL, 'ResourceNotFoundException$reason' => NULL, 'ValidationException$message' => NULL, 'ValidationException$reason' => NULL, ], ], 'locationType' => [ 'base' => NULL, 'refs' => [ 'GetWorkingLocationRequest$locationType' => '<p>Specify the type of the working location.</p> <ul> <li> <p> <code>SAGEMAKER</code> – Use the Amazon S3 location as a temporary location to store data content when working with FinSpace Notebooks that run on SageMaker studio.</p> </li> <li> <p> <code>INGESTION</code> – Use the Amazon S3 location as a staging location to copy your data content and then use the location with the Changeset creation operation.</p> </li> </ul>', ], ], 'stringValueLength1to1024' => [ 'base' => NULL, 'refs' => [ 'GetWorkingLocationResponse$s3Uri' => '<p>Returns the Amazon S3 URI for the working location.</p>', 'GetWorkingLocationResponse$s3Path' => '<p>Returns the Amazon S3 Path for the working location.</p>', ], ], 'stringValueLength1to255' => [ 'base' => NULL, 'refs' => [ 'Credentials$accessKeyId' => '<p>The access key identifier.</p>', ], ], 'stringValueLength1to63' => [ 'base' => NULL, 'refs' => [ 'GetWorkingLocationResponse$s3Bucket' => '<p>Returns the Amazon S3 bucket name for the working location.</p>', ], ], 'stringValueMaxLength1000' => [ 'base' => NULL, 'refs' => [ 'Credentials$secretAccessKey' => '<p>The access key.</p>', 'Credentials$sessionToken' => '<p>The session token.</p>', ], ], ],];
