<?php
// This file was auto-generated from sdk-root/src/data/dynamodb/2012-08-10/docs-2.json
return [ 'version' => '2.0', 'service' => '<fullname>Amazon DynamoDB</fullname> <p>Amazon DynamoDB is a fully managed NoSQL database service that provides fast and predictable performance with seamless scalability. DynamoDB lets you offload the administrative burdens of operating and scaling a distributed database, so that you don\'t have to worry about hardware provisioning, setup and configuration, replication, software patching, or cluster scaling.</p> <p>With DynamoDB, you can create database tables that can store and retrieve any amount of data, and serve any level of request traffic. You can scale up or scale down your tables\' throughput capacity without downtime or performance degradation, and use the Amazon Web Services Management Console to monitor resource utilization and performance metrics.</p> <p>DynamoDB automatically spreads the data and traffic for your tables over a sufficient number of servers to handle your throughput and storage requirements, while maintaining consistent and fast performance. All of your data is stored on solid state disks (SSDs) and automatically replicated across multiple Availability Zones in an Amazon Web Services Region, providing built-in high availability and data durability.</p>', 'operations' => [ 'BatchExecuteStatement' => '<p>This operation allows you to perform batch reads or writes on data stored in DynamoDB, using PartiQL.</p> <note> <p>The entire batch must consist of either read statements or write statements, you cannot mix both in one batch.</p> </note>', 'BatchGetItem' => '<p>The <code>BatchGetItem</code> operation returns the attributes of one or more items from one or more tables. You identify requested items by primary key.</p> <p>A single operation can retrieve up to 16 MB of data, which can contain as many as 100 items. <code>BatchGetItem</code> returns a partial result if the response size limit is exceeded, the table\'s provisioned throughput is exceeded, or an internal processing failure occurs. If a partial result is returned, the operation returns a value for <code>UnprocessedKeys</code>. You can use this value to retry the operation starting with the next item to get.</p> <important> <p>If you request more than 100 items, <code>BatchGetItem</code> returns a <code>ValidationException</code> with the message "Too many items requested for the BatchGetItem call."</p> </important> <p>For example, if you ask to retrieve 100 items, but each individual item is 300 KB in size, the system returns 52 items (so as not to exceed the 16 MB limit). It also returns an appropriate <code>UnprocessedKeys</code> value so you can get the next page of results. If desired, your application can include its own logic to assemble the pages of results into one dataset.</p> <p>If <i>none</i> of the items can be processed due to insufficient provisioned throughput on all of the tables in the request, then <code>BatchGetItem</code> returns a <code>ProvisionedThroughputExceededException</code>. If <i>at least one</i> of the items is successfully processed, then <code>BatchGetItem</code> completes successfully, while returning the keys of the unread items in <code>UnprocessedKeys</code>.</p> <important> <p>If DynamoDB returns any unprocessed items, you should retry the batch operation on those items. However, <i>we strongly recommend that you use an exponential backoff algorithm</i>. If you retry the batch operation immediately, the underlying read or write requests can still fail due to throttling on the individual tables. If you delay the batch operation using exponential backoff, the individual requests in the batch are much more likely to succeed.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ErrorHandling.html#BatchOperations">Batch Operations and Error Handling</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p> </important> <p>By default, <code>BatchGetItem</code> performs eventually consistent reads on every table in the request. If you want strongly consistent reads instead, you can set <code>ConsistentRead</code> to <code>true</code> for any or all tables.</p> <p>In order to minimize response latency, <code>BatchGetItem</code> retrieves items in parallel.</p> <p>When designing your application, keep in mind that DynamoDB does not return items in any particular order. To help parse the response by item, include the primary key values for the items in your request in the <code>ProjectionExpression</code> parameter.</p> <p>If a requested item does not exist, it is not returned in the result. Requests for nonexistent items consume the minimum read capacity units according to the type of read. For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/WorkingWithTables.html#CapacityUnitCalculations">Working with Tables</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>', 'BatchWriteItem' => '<p>The <code>BatchWriteItem</code> operation puts or deletes multiple items in one or more tables. A single call to <code>BatchWriteItem</code> can transmit up to 16MB of data over the network, consisting of up to 25 item put or delete operations. While individual items can be up to 400 KB once stored, it\'s important to note that an item\'s representation might be greater than 400KB while being sent in DynamoDB\'s JSON format for the API call. For more details on this distinction, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.NamingRulesDataTypes.html">Naming Rules and Data Types</a>.</p> <note> <p> <code>BatchWriteItem</code> cannot update items. To update items, use the <code>UpdateItem</code> action.</p> </note> <p>The individual <code>PutItem</code> and <code>DeleteItem</code> operations specified in <code>BatchWriteItem</code> are atomic; however <code>BatchWriteItem</code> as a whole is not. If any requested operations fail because the table\'s provisioned throughput is exceeded or an internal processing failure occurs, the failed operations are returned in the <code>UnprocessedItems</code> response parameter. You can investigate and optionally resend the requests. Typically, you would call <code>BatchWriteItem</code> in a loop. Each iteration would check for unprocessed items and submit a new <code>BatchWriteItem</code> request with those unprocessed items until all items have been processed.</p> <p>If <i>none</i> of the items can be processed due to insufficient provisioned throughput on all of the tables in the request, then <code>BatchWriteItem</code> returns a <code>ProvisionedThroughputExceededException</code>.</p> <important> <p>If DynamoDB returns any unprocessed items, you should retry the batch operation on those items. However, <i>we strongly recommend that you use an exponential backoff algorithm</i>. If you retry the batch operation immediately, the underlying read or write requests can still fail due to throttling on the individual tables. If you delay the batch operation using exponential backoff, the individual requests in the batch are much more likely to succeed.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ErrorHandling.html#Programming.Errors.BatchOperations">Batch Operations and Error Handling</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p> </important> <p>With <code>BatchWriteItem</code>, you can efficiently write or delete large amounts of data, such as from Amazon EMR, or copy data from another database into DynamoDB. In order to improve performance with these large-scale operations, <code>BatchWriteItem</code> does not behave in the same way as individual <code>PutItem</code> and <code>DeleteItem</code> calls would. For example, you cannot specify conditions on individual put and delete requests, and <code>BatchWriteItem</code> does not return deleted items in the response.</p> <p>If you use a programming language that supports concurrency, you can use threads to write items in parallel. Your application must include the necessary logic to manage the threads. With languages that don\'t support threading, you must update or delete the specified items one at a time. In both situations, <code>BatchWriteItem</code> performs the specified put and delete operations in parallel, giving you the power of the thread pool approach without having to introduce complexity into your application.</p> <p>Parallel processing reduces latency, but each specified put and delete request consumes the same number of write capacity units whether it is processed in parallel or not. Delete operations on nonexistent items consume one write capacity unit.</p> <p>If one or more of the following is true, DynamoDB rejects the entire batch write operation:</p> <ul> <li> <p>One or more tables specified in the <code>BatchWriteItem</code> request does not exist.</p> </li> <li> <p>Primary key attributes specified on an item in the request do not match those in the corresponding table\'s primary key schema.</p> </li> <li> <p>You try to perform multiple operations on the same item in the same <code>BatchWriteItem</code> request. For example, you cannot put and delete the same item in the same <code>BatchWriteItem</code> request. </p> </li> <li> <p> Your request contains at least two items with identical hash and range keys (which essentially is two put operations). </p> </li> <li> <p>There are more than 25 requests in the batch.</p> </li> <li> <p>Any individual item in a batch exceeds 400 KB.</p> </li> <li> <p>The total request size exceeds 16 MB.</p> </li> </ul>', 'CreateBackup' => '<p>Creates a backup for an existing table.</p> <p> Each time you create an on-demand backup, the entire table data is backed up. There is no limit to the number of on-demand backups that can be taken. </p> <p> When you create an on-demand backup, a time marker of the request is cataloged, and the backup is created asynchronously, by applying all changes until the time of the request to the last full table snapshot. Backup requests are processed instantaneously and become available for restore within minutes. </p> <p>You can call <code>CreateBackup</code> at a maximum rate of 50 times per second.</p> <p>All backups in DynamoDB work without consuming any provisioned throughput on the table.</p> <p> If you submit a backup request on 2018-12-14 at 14:25:00, the backup is guaranteed to contain all data committed to the table up to 14:24:00, and data committed after 14:26:00 will not be. The backup might contain data modifications made between 14:24:00 and 14:26:00. On-demand backup does not support causal consistency. </p> <p> Along with data, the following are also included on the backups: </p> <ul> <li> <p>Global secondary indexes (GSIs)</p> </li> <li> <p>Local secondary indexes (LSIs)</p> </li> <li> <p>Streams</p> </li> <li> <p>Provisioned read and write capacity</p> </li> </ul>', 'CreateGlobalTable' => '<p>Creates a global table from an existing table. A global table creates a replication relationship between two or more DynamoDB tables with the same table name in the provided Regions. </p> <note> <p>This operation only applies to <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/globaltables.V1.html">Version 2017.11.29</a> of global tables.</p> </note> <p>If you want to add a new replica table to a global table, each of the following conditions must be true:</p> <ul> <li> <p>The table must have the same primary key as all of the other replicas.</p> </li> <li> <p>The table must have the same name as all of the other replicas.</p> </li> <li> <p>The table must have DynamoDB Streams enabled, with the stream containing both the new and the old images of the item.</p> </li> <li> <p>None of the replica tables in the global table can contain any data.</p> </li> </ul> <p> If global secondary indexes are specified, then the following conditions must also be met: </p> <ul> <li> <p> The global secondary indexes must have the same name. </p> </li> <li> <p> The global secondary indexes must have the same hash key and sort key (if present). </p> </li> </ul> <p> If local secondary indexes are specified, then the following conditions must also be met: </p> <ul> <li> <p> The local secondary indexes must have the same name. </p> </li> <li> <p> The local secondary indexes must have the same hash key and sort key (if present). </p> </li> </ul> <important> <p> Write capacity settings should be set consistently across your replica tables and secondary indexes. DynamoDB strongly recommends enabling auto scaling to manage the write capacity settings for all of your global tables replicas and indexes. </p> <p> If you prefer to manage write capacity settings manually, you should provision equal replicated write capacity units to your replica tables. You should also provision equal replicated write capacity units to matching secondary indexes across your global table. </p> </important>', 'CreateTable' => '<p>The <code>CreateTable</code> operation adds a new table to your account. In an Amazon Web Services account, table names must be unique within each Region. That is, you can have two tables with same name if you create the tables in different Regions.</p> <p> <code>CreateTable</code> is an asynchronous operation. Upon receiving a <code>CreateTable</code> request, DynamoDB immediately returns a response with a <code>TableStatus</code> of <code>CREATING</code>. After the table is created, DynamoDB sets the <code>TableStatus</code> to <code>ACTIVE</code>. You can perform read and write operations only on an <code>ACTIVE</code> table. </p> <p>You can optionally define secondary indexes on the new table, as part of the <code>CreateTable</code> operation. If you want to create multiple tables with secondary indexes on them, you must create the tables sequentially. Only one table with secondary indexes can be in the <code>CREATING</code> state at any given time.</p> <p>You can use the <code>DescribeTable</code> action to check the table status.</p>', 'DeleteBackup' => '<p>Deletes an existing backup of a table.</p> <p>You can call <code>DeleteBackup</code> at a maximum rate of 10 times per second.</p>', 'DeleteItem' => '<p>Deletes a single item in a table by primary key. You can perform a conditional delete operation that deletes the item if it exists, or if it has an expected attribute value.</p> <p>In addition to deleting an item, you can also return the item\'s attribute values in the same operation, using the <code>ReturnValues</code> parameter.</p> <p>Unless you specify conditions, the <code>DeleteItem</code> is an idempotent operation; running it multiple times on the same item or attribute does <i>not</i> result in an error response.</p> <p>Conditional deletes are useful for deleting items only if specific conditions are met. If those conditions are met, DynamoDB performs the delete. Otherwise, the item is not deleted.</p>', 'DeleteTable' => '<p>The <code>DeleteTable</code> operation deletes a table and all of its items. After a <code>DeleteTable</code> request, the specified table is in the <code>DELETING</code> state until DynamoDB completes the deletion. If the table is in the <code>ACTIVE</code> state, you can delete it. If a table is in <code>CREATING</code> or <code>UPDATING</code> states, then DynamoDB returns a <code>ResourceInUseException</code>. If the specified table does not exist, DynamoDB returns a <code>ResourceNotFoundException</code>. If table is already in the <code>DELETING</code> state, no error is returned. </p> <note> <p>DynamoDB might continue to accept data read and write operations, such as <code>GetItem</code> and <code>PutItem</code>, on a table in the <code>DELETING</code> state until the table deletion is complete.</p> </note> <p>When you delete a table, any indexes on that table are also deleted.</p> <p>If you have DynamoDB Streams enabled on the table, then the corresponding stream on that table goes into the <code>DISABLED</code> state, and the stream is automatically deleted after 24 hours.</p> <p>Use the <code>DescribeTable</code> action to check the status of the table. </p>', 'DescribeBackup' => '<p>Describes an existing backup of a table.</p> <p>You can call <code>DescribeBackup</code> at a maximum rate of 10 times per second.</p>', 'DescribeContinuousBackups' => '<p>Checks the status of continuous backups and point in time recovery on the specified table. Continuous backups are <code>ENABLED</code> on all tables at table creation. If point in time recovery is enabled, <code>PointInTimeRecoveryStatus</code> will be set to ENABLED.</p> <p> After continuous backups and point in time recovery are enabled, you can restore to any point in time within <code>EarliestRestorableDateTime</code> and <code>LatestRestorableDateTime</code>. </p> <p> <code>LatestRestorableDateTime</code> is typically 5 minutes before the current time. You can restore your table to any point in time during the last 35 days. </p> <p>You can call <code>DescribeContinuousBackups</code> at a maximum rate of 10 times per second.</p>', 'DescribeContributorInsights' => '<p>Returns information about contributor insights, for a given table or global secondary index.</p>', 'DescribeEndpoints' => '<p>Returns the regional endpoint information.</p>', 'DescribeExport' => '<p>Describes an existing table export.</p>', 'DescribeGlobalTable' => '<p>Returns information about the specified global table.</p> <note> <p>This operation only applies to <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/globaltables.V1.html">Version 2017.11.29</a> of global tables. If you are using global tables <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/globaltables.V2.html">Version 2019.11.21</a> you can use <a href="https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_DescribeTable.html">DescribeTable</a> instead.</p> </note>', 'DescribeGlobalTableSettings' => '<p>Describes Region-specific settings for a global table.</p> <note> <p>This operation only applies to <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/globaltables.V1.html">Version 2017.11.29</a> of global tables.</p> </note>', 'DescribeKinesisStreamingDestination' => '<p>Returns information about the status of Kinesis streaming.</p>', 'DescribeLimits' => '<p>Returns the current provisioned-capacity quotas for your Amazon Web Services account in a Region, both for the Region as a whole and for any one DynamoDB table that you create there.</p> <p>When you establish an Amazon Web Services account, the account has initial quotas on the maximum read capacity units and write capacity units that you can provision across all of your DynamoDB tables in a given Region. Also, there are per-table quotas that apply when you create a table there. For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Limits.html">Service, Account, and Table Quotas</a> page in the <i>Amazon DynamoDB Developer Guide</i>.</p> <p>Although you can increase these quotas by filing a case at <a href="https://console.aws.amazon.com/support/home#/">Amazon Web Services Support Center</a>, obtaining the increase is not instantaneous. The <code>DescribeLimits</code> action lets you write code to compare the capacity you are currently using to those quotas imposed by your account so that you have enough time to apply for an increase before you hit a quota.</p> <p>For example, you could use one of the Amazon Web Services SDKs to do the following:</p> <ol> <li> <p>Call <code>DescribeLimits</code> for a particular Region to obtain your current account quotas on provisioned capacity there.</p> </li> <li> <p>Create a variable to hold the aggregate read capacity units provisioned for all your tables in that Region, and one to hold the aggregate write capacity units. Zero them both.</p> </li> <li> <p>Call <code>ListTables</code> to obtain a list of all your DynamoDB tables.</p> </li> <li> <p>For each table name listed by <code>ListTables</code>, do the following:</p> <ul> <li> <p>Call <code>DescribeTable</code> with the table name.</p> </li> <li> <p>Use the data returned by <code>DescribeTable</code> to add the read capacity units and write capacity units provisioned for the table itself to your variables.</p> </li> <li> <p>If the table has one or more global secondary indexes (GSIs), loop over these GSIs and add their provisioned capacity values to your variables as well.</p> </li> </ul> </li> <li> <p>Report the account quotas for that Region returned by <code>DescribeLimits</code>, along with the total current provisioned capacity levels you have calculated.</p> </li> </ol> <p>This will let you see whether you are getting close to your account-level quotas.</p> <p>The per-table quotas apply only when you are creating a new table. They restrict the sum of the provisioned capacity of the new table itself and all its global secondary indexes.</p> <p>For existing tables and their GSIs, DynamoDB doesn\'t let you increase provisioned capacity extremely rapidly, but the only quota that applies is that the aggregate provisioned capacity over all your tables and GSIs cannot exceed either of the per-account quotas.</p> <note> <p> <code>DescribeLimits</code> should only be called periodically. You can expect throttling errors if you call it more than once in a minute.</p> </note> <p>The <code>DescribeLimits</code> Request element has no content.</p>', 'DescribeTable' => '<p>Returns information about the table, including the current status of the table, when it was created, the primary key schema, and any indexes on the table.</p> <note> <p>If you issue a <code>DescribeTable</code> request immediately after a <code>CreateTable</code> request, DynamoDB might return a <code>ResourceNotFoundException</code>. This is because <code>DescribeTable</code> uses an eventually consistent query, and the metadata for your table might not be available at that moment. Wait for a few seconds, and then try the <code>DescribeTable</code> request again.</p> </note>', 'DescribeTableReplicaAutoScaling' => '<p>Describes auto scaling settings across replicas of the global table at once.</p> <note> <p>This operation only applies to <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/globaltables.V2.html">Version 2019.11.21</a> of global tables.</p> </note>', 'DescribeTimeToLive' => '<p>Gives a description of the Time to Live (TTL) status on the specified table. </p>', 'DisableKinesisStreamingDestination' => '<p>Stops replication from the DynamoDB table to the Kinesis data stream. This is done without deleting either of the resources.</p>', 'EnableKinesisStreamingDestination' => '<p>Starts table data replication to the specified Kinesis data stream at a timestamp chosen during the enable workflow. If this operation doesn\'t return results immediately, use DescribeKinesisStreamingDestination to check if streaming to the Kinesis data stream is ACTIVE.</p>', 'ExecuteStatement' => '<p>This operation allows you to perform reads and singleton writes on data stored in DynamoDB, using PartiQL.</p> <p>For PartiQL reads (<code>SELECT</code> statement), if the total number of processed items exceeds the maximum dataset size limit of 1 MB, the read stops and results are returned to the user as a <code>LastEvaluatedKey</code> value to continue the read in a subsequent operation. If the filter criteria in <code>WHERE</code> clause does not match any data, the read will return an empty result set.</p> <p>A single <code>SELECT</code> statement response can return up to the maximum number of items (if using the Limit parameter) or a maximum of 1 MB of data (and then apply any filtering to the results using <code>WHERE</code> clause). If <code>LastEvaluatedKey</code> is present in the response, you need to paginate the result set.</p>', 'ExecuteTransaction' => '<p>This operation allows you to perform transactional reads or writes on data stored in DynamoDB, using PartiQL.</p> <note> <p>The entire transaction must consist of either read statements or write statements, you cannot mix both in one transaction. The EXISTS function is an exception and can be used to check the condition of specific attributes of the item in a similar manner to <code>ConditionCheck</code> in the <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/transaction-apis.html#transaction-apis-txwriteitems">TransactWriteItems</a> API.</p> </note>', 'ExportTableToPointInTime' => '<p>Exports table data to an S3 bucket. The table must have point in time recovery enabled, and you can export data from any time within the point in time recovery window.</p>', 'GetItem' => '<p>The <code>GetItem</code> operation returns a set of attributes for the item with the given primary key. If there is no matching item, <code>GetItem</code> does not return any data and there will be no <code>Item</code> element in the response.</p> <p> <code>GetItem</code> provides an eventually consistent read by default. If your application requires a strongly consistent read, set <code>ConsistentRead</code> to <code>true</code>. Although a strongly consistent read might take more time than an eventually consistent read, it always returns the last updated value.</p>', 'ListBackups' => '<p>List backups associated with an Amazon Web Services account. To list backups for a given table, specify <code>TableName</code>. <code>ListBackups</code> returns a paginated list of results with at most 1 MB worth of items in a page. You can also specify a maximum number of entries to be returned in a page.</p> <p>In the request, start time is inclusive, but end time is exclusive. Note that these boundaries are for the time at which the original backup was requested.</p> <p>You can call <code>ListBackups</code> a maximum of five times per second.</p>', 'ListContributorInsights' => '<p>Returns a list of ContributorInsightsSummary for a table and all its global secondary indexes.</p>', 'ListExports' => '<p>Lists completed exports within the past 90 days.</p>', 'ListGlobalTables' => '<p>Lists all global tables that have a replica in the specified Region.</p> <note> <p>This operation only applies to <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/globaltables.V1.html">Version 2017.11.29</a> of global tables.</p> </note>', 'ListTables' => '<p>Returns an array of table names associated with the current account and endpoint. The output from <code>ListTables</code> is paginated, with each page returning a maximum of 100 table names.</p>', 'ListTagsOfResource' => '<p>List all tags on an Amazon DynamoDB resource. You can call ListTagsOfResource up to 10 times per second, per account.</p> <p>For an overview on tagging DynamoDB resources, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Tagging.html">Tagging for DynamoDB</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>', 'PutItem' => '<p>Creates a new item, or replaces an old item with a new item. If an item that has the same primary key as the new item already exists in the specified table, the new item completely replaces the existing item. You can perform a conditional put operation (add a new item if one with the specified primary key doesn\'t exist), or replace an existing item if it has certain attribute values. You can return the item\'s attribute values in the same operation, using the <code>ReturnValues</code> parameter.</p> <important> <p>This topic provides general information about the <code>PutItem</code> API.</p> <p>For information on how to call the <code>PutItem</code> API using the Amazon Web Services SDK in specific languages, see the following:</p> <ul> <li> <p> <a href="http://docs.aws.amazon.com/goto/aws-cli/dynamodb-2012-08-10/PutItem"> PutItem in the Command Line Interface</a> </p> </li> <li> <p> <a href="http://docs.aws.amazon.com/goto/DotNetSDKV3/dynamodb-2012-08-10/PutItem"> PutItem in the SDK for .NET</a> </p> </li> <li> <p> <a href="http://docs.aws.amazon.com/goto/SdkForCpp/dynamodb-2012-08-10/PutItem"> PutItem in the SDK for C++</a> </p> </li> <li> <p> <a href="http://docs.aws.amazon.com/goto/SdkForGoV1/dynamodb-2012-08-10/PutItem"> PutItem in the SDK for Go</a> </p> </li> <li> <p> <a href="http://docs.aws.amazon.com/goto/SdkForJava/dynamodb-2012-08-10/PutItem"> PutItem in the SDK for Java</a> </p> </li> <li> <p> <a href="http://docs.aws.amazon.com/goto/AWSJavaScriptSDK/dynamodb-2012-08-10/PutItem"> PutItem in the SDK for JavaScript</a> </p> </li> <li> <p> <a href="http://docs.aws.amazon.com/goto/SdkForPHPV3/dynamodb-2012-08-10/PutItem"> PutItem in the SDK for PHP V3</a> </p> </li> <li> <p> <a href="http://docs.aws.amazon.com/goto/boto3/dynamodb-2012-08-10/PutItem"> PutItem in the SDK for Python (Boto)</a> </p> </li> <li> <p> <a href="http://docs.aws.amazon.com/goto/SdkForRubyV2/dynamodb-2012-08-10/PutItem"> PutItem in the SDK for Ruby V2</a> </p> </li> </ul> </important> <p>When you add an item, the primary key attributes are the only required attributes. Attribute values cannot be null.</p> <p>Empty String and Binary attribute values are allowed. Attribute values of type String and Binary must have a length greater than zero if the attribute is used as a key attribute for a table or index. Set type attributes cannot be empty. </p> <p>Invalid Requests with empty values will be rejected with a <code>ValidationException</code> exception.</p> <note> <p>To prevent a new item from replacing an existing item, use a conditional expression that contains the <code>attribute_not_exists</code> function with the name of the attribute being used as the partition key for the table. Since every record must contain that attribute, the <code>attribute_not_exists</code> function will only succeed if no matching item exists.</p> </note> <p>For more information about <code>PutItem</code>, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/WorkingWithItems.html">Working with Items</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>', 'Query' => '<p>You must provide the name of the partition key attribute and a single value for that attribute. <code>Query</code> returns all items with that partition key value. Optionally, you can provide a sort key attribute and use a comparison operator to refine the search results.</p> <p>Use the <code>KeyConditionExpression</code> parameter to provide a specific value for the partition key. The <code>Query</code> operation will return all of the items from the table or index with that partition key value. You can optionally narrow the scope of the <code>Query</code> operation by specifying a sort key value and a comparison operator in <code>KeyConditionExpression</code>. To further refine the <code>Query</code> results, you can optionally provide a <code>FilterExpression</code>. A <code>FilterExpression</code> determines which items within the results should be returned to you. All of the other results are discarded. </p> <p> A <code>Query</code> operation always returns a result set. If no matching items are found, the result set will be empty. Queries that do not return results consume the minimum number of read capacity units for that type of read operation. </p> <note> <p> DynamoDB calculates the number of read capacity units consumed based on item size, not on the amount of data that is returned to an application. The number of capacity units consumed will be the same whether you request all of the attributes (the default behavior) or just some of them (using a projection expression). The number will also be the same whether or not you use a <code>FilterExpression</code>. </p> </note> <p> <code>Query</code> results are always sorted by the sort key value. If the data type of the sort key is Number, the results are returned in numeric order; otherwise, the results are returned in order of UTF-8 bytes. By default, the sort order is ascending. To reverse the order, set the <code>ScanIndexForward</code> parameter to false. </p> <p> A single <code>Query</code> operation will read up to the maximum number of items set (if using the <code>Limit</code> parameter) or a maximum of 1 MB of data and then apply any filtering to the results using <code>FilterExpression</code>. If <code>LastEvaluatedKey</code> is present in the response, you will need to paginate the result set. For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Query.html#Query.Pagination">Paginating the Results</a> in the <i>Amazon DynamoDB Developer Guide</i>. </p> <p> <code>FilterExpression</code> is applied after a <code>Query</code> finishes, but before the results are returned. A <code>FilterExpression</code> cannot contain partition key or sort key attributes. You need to specify those attributes in the <code>KeyConditionExpression</code>. </p> <note> <p> A <code>Query</code> operation can return an empty result set and a <code>LastEvaluatedKey</code> if all the items read for the page of results are filtered out. </p> </note> <p>You can query a table, a local secondary index, or a global secondary index. For a query on a table or on a local secondary index, you can set the <code>ConsistentRead</code> parameter to <code>true</code> and obtain a strongly consistent result. Global secondary indexes support eventually consistent reads only, so do not specify <code>ConsistentRead</code> when querying a global secondary index.</p>', 'RestoreTableFromBackup' => '<p>Creates a new table from an existing backup. Any number of users can execute up to 4 concurrent restores (any type of restore) in a given account. </p> <p>You can call <code>RestoreTableFromBackup</code> at a maximum rate of 10 times per second.</p> <p>You must manually set up the following on the restored table:</p> <ul> <li> <p>Auto scaling policies</p> </li> <li> <p>IAM policies</p> </li> <li> <p>Amazon CloudWatch metrics and alarms</p> </li> <li> <p>Tags</p> </li> <li> <p>Stream settings</p> </li> <li> <p>Time to Live (TTL) settings</p> </li> </ul>', 'RestoreTableToPointInTime' => '<p>Restores the specified table to the specified point in time within <code>EarliestRestorableDateTime</code> and <code>LatestRestorableDateTime</code>. You can restore your table to any point in time during the last 35 days. Any number of users can execute up to 4 concurrent restores (any type of restore) in a given account. </p> <p> When you restore using point in time recovery, DynamoDB restores your table data to the state based on the selected date and time (day:hour:minute:second) to a new table. </p> <p> Along with data, the following are also included on the new restored table using point in time recovery: </p> <ul> <li> <p>Global secondary indexes (GSIs)</p> </li> <li> <p>Local secondary indexes (LSIs)</p> </li> <li> <p>Provisioned read and write capacity</p> </li> <li> <p>Encryption settings</p> <important> <p> All these settings come from the current settings of the source table at the time of restore. </p> </important> </li> </ul> <p>You must manually set up the following on the restored table:</p> <ul> <li> <p>Auto scaling policies</p> </li> <li> <p>IAM policies</p> </li> <li> <p>Amazon CloudWatch metrics and alarms</p> </li> <li> <p>Tags</p> </li> <li> <p>Stream settings</p> </li> <li> <p>Time to Live (TTL) settings</p> </li> <li> <p>Point in time recovery settings</p> </li> </ul>', 'Scan' => '<p>The <code>Scan</code> operation returns one or more items and item attributes by accessing every item in a table or a secondary index. To have DynamoDB return fewer items, you can provide a <code>FilterExpression</code> operation.</p> <p>If the total number of scanned items exceeds the maximum dataset size limit of 1 MB, the scan stops and results are returned to the user as a <code>LastEvaluatedKey</code> value to continue the scan in a subsequent operation. The results also include the number of items exceeding the limit. A scan can result in no table data meeting the filter criteria. </p> <p>A single <code>Scan</code> operation reads up to the maximum number of items set (if using the <code>Limit</code> parameter) or a maximum of 1 MB of data and then apply any filtering to the results using <code>FilterExpression</code>. If <code>LastEvaluatedKey</code> is present in the response, you need to paginate the result set. For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Scan.html#Scan.Pagination">Paginating the Results</a> in the <i>Amazon DynamoDB Developer Guide</i>. </p> <p> <code>Scan</code> operations proceed sequentially; however, for faster performance on a large table or secondary index, applications can request a parallel <code>Scan</code> operation by providing the <code>Segment</code> and <code>TotalSegments</code> parameters. For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Scan.html#Scan.ParallelScan">Parallel Scan</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p> <p> <code>Scan</code> uses eventually consistent reads when accessing the data in a table; therefore, the result set might not include the changes to data in the table immediately before the operation began. If you need a consistent copy of the data, as of the time that the <code>Scan</code> begins, you can set the <code>ConsistentRead</code> parameter to <code>true</code>.</p>', 'TagResource' => '<p>Associate a set of tags with an Amazon DynamoDB resource. You can then activate these user-defined tags so that they appear on the Billing and Cost Management console for cost allocation tracking. You can call TagResource up to five times per second, per account. </p> <p>For an overview on tagging DynamoDB resources, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Tagging.html">Tagging for DynamoDB</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>', 'TransactGetItems' => '<p> <code>TransactGetItems</code> is a synchronous operation that atomically retrieves multiple items from one or more tables (but not from indexes) in a single account and Region. A <code>TransactGetItems</code> call can contain up to 25 <code>TransactGetItem</code> objects, each of which contains a <code>Get</code> structure that specifies an item to retrieve from a table in the account and Region. A call to <code>TransactGetItems</code> cannot retrieve items from tables in more than one Amazon Web Services account or Region. The aggregate size of the items in the transaction cannot exceed 4 MB.</p> <p>DynamoDB rejects the entire <code>TransactGetItems</code> request if any of the following is true:</p> <ul> <li> <p>A conflicting operation is in the process of updating an item to be read.</p> </li> <li> <p>There is insufficient provisioned capacity for the transaction to be completed.</p> </li> <li> <p>There is a user error, such as an invalid data format.</p> </li> <li> <p>The aggregate size of the items in the transaction cannot exceed 4 MB.</p> </li> </ul>', 'TransactWriteItems' => '<p> <code>TransactWriteItems</code> is a synchronous write operation that groups up to 25 action requests. These actions can target items in different tables, but not in different Amazon Web Services accounts or Regions, and no two actions can target the same item. For example, you cannot both <code>ConditionCheck</code> and <code>Update</code> the same item. The aggregate size of the items in the transaction cannot exceed 4 MB.</p> <p>The actions are completed atomically so that either all of them succeed, or all of them fail. They are defined by the following objects:</p> <ul> <li> <p> <code>Put</code>  —   Initiates a <code>PutItem</code> operation to write a new item. This structure specifies the primary key of the item to be written, the name of the table to write it in, an optional condition expression that must be satisfied for the write to succeed, a list of the item\'s attributes, and a field indicating whether to retrieve the item\'s attributes if the condition is not met.</p> </li> <li> <p> <code>Update</code>  —   Initiates an <code>UpdateItem</code> operation to update an existing item. This structure specifies the primary key of the item to be updated, the name of the table where it resides, an optional condition expression that must be satisfied for the update to succeed, an expression that defines one or more attributes to be updated, and a field indicating whether to retrieve the item\'s attributes if the condition is not met.</p> </li> <li> <p> <code>Delete</code>  —   Initiates a <code>DeleteItem</code> operation to delete an existing item. This structure specifies the primary key of the item to be deleted, the name of the table where it resides, an optional condition expression that must be satisfied for the deletion to succeed, and a field indicating whether to retrieve the item\'s attributes if the condition is not met.</p> </li> <li> <p> <code>ConditionCheck</code>  —   Applies a condition to an item that is not being modified by the transaction. This structure specifies the primary key of the item to be checked, the name of the table where it resides, a condition expression that must be satisfied for the transaction to succeed, and a field indicating whether to retrieve the item\'s attributes if the condition is not met.</p> </li> </ul> <p>DynamoDB rejects the entire <code>TransactWriteItems</code> request if any of the following is true:</p> <ul> <li> <p>A condition in one of the condition expressions is not met.</p> </li> <li> <p>An ongoing operation is in the process of updating the same item.</p> </li> <li> <p>There is insufficient provisioned capacity for the transaction to be completed.</p> </li> <li> <p>An item size becomes too large (bigger than 400 KB), a local secondary index (LSI) becomes too large, or a similar validation error occurs because of changes made by the transaction.</p> </li> <li> <p>The aggregate size of the items in the transaction exceeds 4 MB.</p> </li> <li> <p>There is a user error, such as an invalid data format.</p> </li> </ul>', 'UntagResource' => '<p>Removes the association of tags from an Amazon DynamoDB resource. You can call <code>UntagResource</code> up to five times per second, per account. </p> <p>For an overview on tagging DynamoDB resources, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Tagging.html">Tagging for DynamoDB</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>', 'UpdateContinuousBackups' => '<p> <code>UpdateContinuousBackups</code> enables or disables point in time recovery for the specified table. A successful <code>UpdateContinuousBackups</code> call returns the current <code>ContinuousBackupsDescription</code>. Continuous backups are <code>ENABLED</code> on all tables at table creation. If point in time recovery is enabled, <code>PointInTimeRecoveryStatus</code> will be set to ENABLED.</p> <p> Once continuous backups and point in time recovery are enabled, you can restore to any point in time within <code>EarliestRestorableDateTime</code> and <code>LatestRestorableDateTime</code>. </p> <p> <code>LatestRestorableDateTime</code> is typically 5 minutes before the current time. You can restore your table to any point in time during the last 35 days. </p>', 'UpdateContributorInsights' => '<p>Updates the status for contributor insights for a specific table or index. CloudWatch Contributor Insights for DynamoDB graphs display the partition key and (if applicable) sort key of frequently accessed items and frequently throttled items in plaintext. If you require the use of Amazon Web Services Key Management Service (KMS) to encrypt this table’s partition key and sort key data with an Amazon Web Services managed key or customer managed key, you should not enable CloudWatch Contributor Insights for DynamoDB for this table.</p>', 'UpdateGlobalTable' => '<p>Adds or removes replicas in the specified global table. The global table must already exist to be able to use this operation. Any replica to be added must be empty, have the same name as the global table, have the same key schema, have DynamoDB Streams enabled, and have the same provisioned and maximum write capacity units.</p> <note> <p>Although you can use <code>UpdateGlobalTable</code> to add replicas and remove replicas in a single request, for simplicity we recommend that you issue separate requests for adding or removing replicas.</p> </note> <p> If global secondary indexes are specified, then the following conditions must also be met: </p> <ul> <li> <p> The global secondary indexes must have the same name. </p> </li> <li> <p> The global secondary indexes must have the same hash key and sort key (if present). </p> </li> <li> <p> The global secondary indexes must have the same provisioned and maximum write capacity units. </p> </li> </ul>', 'UpdateGlobalTableSettings' => '<p>Updates settings for a global table.</p>', 'UpdateItem' => '<p>Edits an existing item\'s attributes, or adds a new item to the table if it does not already exist. You can put, delete, or add attribute values. You can also perform a conditional update on an existing item (insert a new attribute name-value pair if it doesn\'t exist, or replace an existing name-value pair if it has certain expected attribute values).</p> <p>You can also return the item\'s attribute values in the same <code>UpdateItem</code> operation using the <code>ReturnValues</code> parameter.</p>', 'UpdateTable' => '<p>Modifies the provisioned throughput settings, global secondary indexes, or DynamoDB Streams settings for a given table.</p> <p>You can only perform one of the following operations at once:</p> <ul> <li> <p>Modify the provisioned throughput settings of the table.</p> </li> <li> <p>Enable or disable DynamoDB Streams on the table.</p> </li> <li> <p>Remove a global secondary index from the table.</p> </li> <li> <p>Create a new global secondary index on the table. After the index begins backfilling, you can use <code>UpdateTable</code> to perform other operations.</p> </li> </ul> <p> <code>UpdateTable</code> is an asynchronous operation; while it is executing, the table status changes from <code>ACTIVE</code> to <code>UPDATING</code>. While it is <code>UPDATING</code>, you cannot issue another <code>UpdateTable</code> request. When the table returns to the <code>ACTIVE</code> state, the <code>UpdateTable</code> operation is complete.</p>', 'UpdateTableReplicaAutoScaling' => '<p>Updates auto scaling settings on your global tables at once.</p> <note> <p>This operation only applies to <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/globaltables.V2.html">Version 2019.11.21</a> of global tables.</p> </note>', 'UpdateTimeToLive' => '<p>The <code>UpdateTimeToLive</code> method enables or disables Time to Live (TTL) for the specified table. A successful <code>UpdateTimeToLive</code> call returns the current <code>TimeToLiveSpecification</code>. It can take up to one hour for the change to fully process. Any additional <code>UpdateTimeToLive</code> calls for the same table during this one hour duration result in a <code>ValidationException</code>. </p> <p>TTL compares the current time in epoch time format to the time stored in the TTL attribute of an item. If the epoch time value stored in the attribute is less than the current time, the item is marked as expired and subsequently deleted.</p> <note> <p> The epoch time format is the number of seconds elapsed since 12:00:00 AM January 1, 1970 UTC. </p> </note> <p>DynamoDB deletes expired items on a best-effort basis to ensure availability of throughput for other data operations. </p> <important> <p>DynamoDB typically deletes expired items within two days of expiration. The exact duration within which an item gets deleted after expiration is specific to the nature of the workload. Items that have expired and not been deleted will still show up in reads, queries, and scans.</p> </important> <p>As items are deleted, they are removed from any local secondary index and global secondary index immediately in the same eventually consistent way as a standard delete operation.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/TTL.html">Time To Live</a> in the Amazon DynamoDB Developer Guide. </p>', ], 'shapes' => [ 'ArchivalReason' => [ 'base' => NULL, 'refs' => [ 'ArchivalSummary$ArchivalReason' => '<p>The reason DynamoDB archived the table. Currently, the only possible value is:</p> <ul> <li> <p> <code>INACCESSIBLE_ENCRYPTION_CREDENTIALS</code> - The table was archived due to the table\'s KMS key being inaccessible for more than seven days. An On-Demand backup was created at the archival time.</p> </li> </ul>', ], ], 'ArchivalSummary' => [ 'base' => '<p>Contains details of a table archival operation.</p>', 'refs' => [ 'TableDescription$ArchivalSummary' => '<p>Contains information about the table archive.</p>', ], ], 'AttributeAction' => [ 'base' => NULL, 'refs' => [ 'AttributeValueUpdate$Action' => '<p>Specifies how to perform the update. Valid values are <code>PUT</code> (default), <code>DELETE</code>, and <code>ADD</code>. The behavior depends on whether the specified primary key already exists in the table.</p> <p> <b>If an item with the specified <i>Key</i> is found in the table:</b> </p> <ul> <li> <p> <code>PUT</code> - Adds the specified attribute to the item. If the attribute already exists, it is replaced by the new value. </p> </li> <li> <p> <code>DELETE</code> - If no value is specified, the attribute and its value are removed from the item. The data type of the specified value must match the existing value\'s data type.</p> <p>If a <i>set</i> of values is specified, then those values are subtracted from the old set. For example, if the attribute value was the set <code>[a,b,c]</code> and the <code>DELETE</code> action specified <code>[a,c]</code>, then the final attribute value would be <code>[b]</code>. Specifying an empty set is an error.</p> </li> <li> <p> <code>ADD</code> - If the attribute does not already exist, then the attribute and its values are added to the item. If the attribute does exist, then the behavior of <code>ADD</code> depends on the data type of the attribute:</p> <ul> <li> <p>If the existing attribute is a number, and if <code>Value</code> is also a number, then the <code>Value</code> is mathematically added to the existing attribute. If <code>Value</code> is a negative number, then it is subtracted from the existing attribute.</p> <note> <p> If you use <code>ADD</code> to increment or decrement a number value for an item that doesn\'t exist before the update, DynamoDB uses 0 as the initial value.</p> <p>In addition, if you use <code>ADD</code> to update an existing item, and intend to increment or decrement an attribute value which does not yet exist, DynamoDB uses <code>0</code> as the initial value. For example, suppose that the item you want to update does not yet have an attribute named <i>itemcount</i>, but you decide to <code>ADD</code> the number <code>3</code> to this attribute anyway, even though it currently does not exist. DynamoDB will create the <i>itemcount</i> attribute, set its initial value to <code>0</code>, and finally add <code>3</code> to it. The result will be a new <i>itemcount</i> attribute in the item, with a value of <code>3</code>.</p> </note> </li> <li> <p>If the existing data type is a set, and if the <code>Value</code> is also a set, then the <code>Value</code> is added to the existing set. (This is a <i>set</i> operation, not mathematical addition.) For example, if the attribute value was the set <code>[1,2]</code>, and the <code>ADD</code> action specified <code>[3]</code>, then the final attribute value would be <code>[1,2,3]</code>. An error occurs if an Add action is specified for a set attribute and the attribute type specified does not match the existing set type. </p> <p>Both sets must have the same primitive data type. For example, if the existing data type is a set of strings, the <code>Value</code> must also be a set of strings. The same holds true for number sets and binary sets.</p> </li> </ul> <p>This action is only valid for an existing attribute whose data type is number or is a set. Do not use <code>ADD</code> for any other data types.</p> </li> </ul> <p> <b>If no item with the specified <i>Key</i> is found:</b> </p> <ul> <li> <p> <code>PUT</code> - DynamoDB creates a new item with the specified primary key, and then adds the attribute. </p> </li> <li> <p> <code>DELETE</code> - Nothing happens; there is no attribute to delete.</p> </li> <li> <p> <code>ADD</code> - DynamoDB creates an item with the supplied primary key and number (or set of numbers) for the attribute value. The only data types allowed are number and number set; no other data types can be specified.</p> </li> </ul>', ], ], 'AttributeDefinition' => [ 'base' => '<p>Represents an attribute for describing the key schema for the table and indexes.</p>', 'refs' => [ 'AttributeDefinitions$member' => NULL, ], ], 'AttributeDefinitions' => [ 'base' => NULL, 'refs' => [ 'CreateTableInput$AttributeDefinitions' => '<p>An array of attributes that describe the key schema for the table and indexes.</p>', 'TableDescription$AttributeDefinitions' => '<p>An array of <code>AttributeDefinition</code> objects. Each of these objects describes one attribute in the table and index key schema.</p> <p>Each <code>AttributeDefinition</code> object in this array is composed of:</p> <ul> <li> <p> <code>AttributeName</code> - The name of the attribute.</p> </li> <li> <p> <code>AttributeType</code> - The data type for the attribute.</p> </li> </ul>', 'UpdateTableInput$AttributeDefinitions' => '<p>An array of attributes that describe the key schema for the table and indexes. If you are adding a new global secondary index to the table, <code>AttributeDefinitions</code> must include the key element(s) of the new index.</p>', ], ], 'AttributeMap' => [ 'base' => NULL, 'refs' => [ 'BatchStatementResponse$Item' => '<p> A DynamoDB item associated with a BatchStatementResponse </p>', 'CancellationReason$Item' => '<p>Item in the request which caused the transaction to get cancelled.</p>', 'DeleteItemOutput$Attributes' => '<p>A map of attribute names to <code>AttributeValue</code> objects, representing the item as it appeared before the <code>DeleteItem</code> operation. This map appears in the response only if <code>ReturnValues</code> was specified as <code>ALL_OLD</code> in the request.</p>', 'GetItemOutput$Item' => '<p>A map of attribute names to <code>AttributeValue</code> objects, as specified by <code>ProjectionExpression</code>.</p>', 'ItemList$member' => NULL, 'ItemResponse$Item' => '<p>Map of attribute data consisting of the data type and attribute value.</p>', 'PutItemOutput$Attributes' => '<p>The attribute values as they appeared before the <code>PutItem</code> operation, but only if <code>ReturnValues</code> is specified as <code>ALL_OLD</code> in the request. Each element consists of an attribute name and an attribute value.</p>', 'UpdateItemOutput$Attributes' => '<p>A map of attribute values as they appear before or after the <code>UpdateItem</code> operation, as determined by the <code>ReturnValues</code> parameter.</p> <p>The <code>Attributes</code> map is only present if <code>ReturnValues</code> was specified as something other than <code>NONE</code> in the request. Each element represents one attribute.</p>', ], ], 'AttributeName' => [ 'base' => NULL, 'refs' => [ 'AttributeMap$key' => NULL, 'AttributeNameList$member' => NULL, 'AttributeUpdates$key' => NULL, 'ExpectedAttributeMap$key' => NULL, 'ExpressionAttributeNameMap$value' => NULL, 'FilterConditionMap$key' => NULL, 'ItemCollectionKeyAttributeMap$key' => NULL, 'Key$key' => NULL, 'KeyConditions$key' => NULL, 'MapAttributeValue$key' => NULL, 'PutItemInputAttributeMap$key' => NULL, ], ], 'AttributeNameList' => [ 'base' => NULL, 'refs' => [ 'GetItemInput$AttributesToGet' => '<p>This is a legacy parameter. Use <code>ProjectionExpression</code> instead. For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.AttributesToGet.html">AttributesToGet</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>', 'KeysAndAttributes$AttributesToGet' => '<p>This is a legacy parameter. Use <code>ProjectionExpression</code> instead. For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.html">Legacy Conditional Parameters</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>', 'QueryInput$AttributesToGet' => '<p>This is a legacy parameter. Use <code>ProjectionExpression</code> instead. For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.AttributesToGet.html">AttributesToGet</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>', 'ScanInput$AttributesToGet' => '<p>This is a legacy parameter. Use <code>ProjectionExpression</code> instead. For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.AttributesToGet.html">AttributesToGet</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>', ], ], 'AttributeUpdates' => [ 'base' => NULL, 'refs' => [ 'UpdateItemInput$AttributeUpdates' => '<p>This is a legacy parameter. Use <code>UpdateExpression</code> instead. For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.AttributeUpdates.html">AttributeUpdates</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>', ], ], 'AttributeValue' => [ 'base' => '<p>Represents the data for an attribute.</p> <p>Each attribute value is described as a name-value pair. The name is the data type, and the value is the data itself.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.NamingRulesDataTypes.html#HowItWorks.DataTypes">Data Types</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>', 'refs' => [ 'AttributeMap$value' => NULL, 'AttributeValueList$member' => NULL, 'AttributeValueUpdate$Value' => '<p>Represents the data for an attribute.</p> <p>Each attribute value is described as a name-value pair. The name is the data type, and the value is the data itself.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.NamingRulesDataTypes.html#HowItWorks.DataTypes">Data Types</a> in the <i>Amazon DynamoDB Developer Guide</i>. </p>', 'ExpectedAttributeValue$Value' => '<p>Represents the data for the expected attribute.</p> <p>Each attribute value is described as a name-value pair. The name is the data type, and the value is the data itself.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.NamingRulesDataTypes.html#HowItWorks.DataTypes">Data Types</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>', 'ExpressionAttributeValueMap$value' => NULL, 'ItemCollectionKeyAttributeMap$value' => NULL, 'Key$value' => NULL, 'ListAttributeValue$member' => NULL, 'MapAttributeValue$value' => NULL, 'PreparedStatementParameters$member' => NULL, 'PutItemInputAttributeMap$value' => NULL, ], ], 'AttributeValueList' => [ 'base' => NULL, 'refs' => [ 'Condition$AttributeValueList' => '<p>One or more values to evaluate against the supplied attribute. The number of values in the list depends on the <code>ComparisonOperator</code> being used.</p> <p>For type Number, value comparisons are numeric.</p> <p>String value comparisons for greater than, equals, or less than are based on ASCII character code values. For example, <code>a</code> is greater than <code>A</code>, and <code>a</code> is greater than <code>B</code>. For a list of code values, see <a href="http://en.wikipedia.org/wiki/ASCII#ASCII_printable_characters">http://en.wikipedia.org/wiki/ASCII#ASCII_printable_characters</a>.</p> <p>For Binary, DynamoDB treats each byte of the binary data as unsigned when it compares binary values.</p>', 'ExpectedAttributeValue$AttributeValueList' => '<p>One or more values to evaluate against the supplied attribute. The number of values in the list depends on the <code>ComparisonOperator</code> being used.</p> <p>For type Number, value comparisons are numeric.</p> <p>String value comparisons for greater than, equals, or less than are based on ASCII character code values. For example, <code>a</code> is greater than <code>A</code>, and <code>a</code> is greater than <code>B</code>. For a list of code values, see <a href="http://en.wikipedia.org/wiki/ASCII#ASCII_printable_characters">http://en.wikipedia.org/wiki/ASCII#ASCII_printable_characters</a>.</p> <p>For Binary, DynamoDB treats each byte of the binary data as unsigned when it compares binary values.</p> <p>For information on specifying data types in JSON, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/DataFormat.html">JSON Data Format</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>', ], ], 'AttributeValueUpdate' => [ 'base' => '<p>For the <code>UpdateItem</code> operation, represents the attributes to be modified, the action to perform on each, and the new value for each.</p> <note> <p>You cannot use <code>UpdateItem</code> to update any primary key attributes. Instead, you will need to delete the item, and then use <code>PutItem</code> to create a new item with new attributes.</p> </note> <p>Attribute values cannot be null; string and binary type attributes must have lengths greater than zero; and set type attributes must not be empty. Requests with empty values will be rejected with a <code>ValidationException</code> exception.</p>', 'refs' => [ 'AttributeUpdates$value' => NULL, ], ], 'AutoScalingPolicyDescription' => [ 'base' => '<p>Represents the properties of the scaling policy.</p>', 'refs' => [ 'AutoScalingPolicyDescriptionList$member' => NULL, ], ], 'AutoScalingPolicyDescriptionList' => [ 'base' => NULL, 'refs' => [ 'AutoScalingSettingsDescription$ScalingPolicies' => '<p>Information about the scaling policies.</p>', ], ], 'AutoScalingPolicyName' => [ 'base' => NULL, 'refs' => [ 'AutoScalingPolicyDescription$PolicyName' => '<p>The name of the scaling policy.</p>', 'AutoScalingPolicyUpdate$PolicyName' => '<p>The name of the scaling policy.</p>', ], ], 'AutoScalingPolicyUpdate' => [ 'base' => '<p>Represents the auto scaling policy to be modified.</p>', 'refs' => [ 'AutoScalingSettingsUpdate$ScalingPolicyUpdate' => '<p>The scaling policy to apply for scaling target global table or global secondary index capacity units.</p>', ], ], 'AutoScalingRoleArn' => [ 'base' => NULL, 'refs' => [ 'AutoScalingSettingsUpdate$AutoScalingRoleArn' => '<p>Role ARN used for configuring auto scaling policy.</p>', ], ], 'AutoScalingSettingsDescription' => [ 'base' => '<p>Represents the auto scaling settings for a global table or global secondary index.</p>', 'refs' => [ 'ReplicaAutoScalingDescription$ReplicaProvisionedReadCapacityAutoScalingSettings' => NULL, 'ReplicaAutoScalingDescription$ReplicaProvisionedWriteCapacityAutoScalingSettings' => NULL, 'ReplicaGlobalSecondaryIndexAutoScalingDescription$ProvisionedReadCapacityAutoScalingSettings' => NULL, 'ReplicaGlobalSecondaryIndexAutoScalingDescription$ProvisionedWriteCapacityAutoScalingSettings' => NULL, 'ReplicaGlobalSecondaryIndexSettingsDescription$ProvisionedReadCapacityAutoScalingSettings' => '<p>Auto scaling settings for a global secondary index replica\'s read capacity units.</p>', 'ReplicaGlobalSecondaryIndexSettingsDescription$ProvisionedWriteCapacityAutoScalingSettings' => '<p>Auto scaling settings for a global secondary index replica\'s write capacity units.</p>', 'ReplicaSettingsDescription$ReplicaProvisionedReadCapacityAutoScalingSettings' => '<p>Auto scaling settings for a global table replica\'s read capacity units.</p>', 'ReplicaSettingsDescription$ReplicaProvisionedWriteCapacityAutoScalingSettings' => '<p>Auto scaling settings for a global table replica\'s write capacity units.</p>', ], ], 'AutoScalingSettingsUpdate' => [ 'base' => '<p>Represents the auto scaling settings to be modified for a global table or global secondary index.</p>', 'refs' => [ 'GlobalSecondaryIndexAutoScalingUpdate$ProvisionedWriteCapacityAutoScalingUpdate' => NULL, 'GlobalTableGlobalSecondaryIndexSettingsUpdate$ProvisionedWriteCapacityAutoScalingSettingsUpdate' => '<p>Auto scaling settings for managing a global secondary index\'s write capacity units.</p>', 'ReplicaAutoScalingUpdate$ReplicaProvisionedReadCapacityAutoScalingUpdate' => NULL, 'ReplicaGlobalSecondaryIndexAutoScalingUpdate$ProvisionedReadCapacityAutoScalingUpdate' => NULL, 'ReplicaGlobalSecondaryIndexSettingsUpdate$ProvisionedReadCapacityAutoScalingSettingsUpdate' => '<p>Auto scaling settings for managing a global secondary index replica\'s read capacity units.</p>', 'ReplicaSettingsUpdate$ReplicaProvisionedReadCapacityAutoScalingSettingsUpdate' => '<p>Auto scaling settings for managing a global table replica\'s read capacity units.</p>', 'UpdateGlobalTableSettingsInput$GlobalTableProvisionedWriteCapacityAutoScalingSettingsUpdate' => '<p>Auto scaling settings for managing provisioned write capacity for the global table.</p>', 'UpdateTableReplicaAutoScalingInput$ProvisionedWriteCapacityAutoScalingUpdate' => NULL, ], ], 'AutoScalingTargetTrackingScalingPolicyConfigurationDescription' => [ 'base' => '<p>Represents the properties of a target tracking scaling policy.</p>', 'refs' => [ 'AutoScalingPolicyDescription$TargetTrackingScalingPolicyConfiguration' => '<p>Represents a target tracking scaling policy configuration.</p>', ], ], 'AutoScalingTargetTrackingScalingPolicyConfigurationUpdate' => [ 'base' => '<p>Represents the settings of a target tracking scaling policy that will be modified.</p>', 'refs' => [ 'AutoScalingPolicyUpdate$TargetTrackingScalingPolicyConfiguration' => '<p>Represents a target tracking scaling policy configuration.</p>', ], ], 'Backfilling' => [ 'base' => NULL, 'refs' => [ 'GlobalSecondaryIndexDescription$Backfilling' => '<p>Indicates whether the index is currently backfilling. <i>Backfilling</i> is the process of reading items from the table and determining whether they can be added to the index. (Not all items will qualify: For example, a partition key cannot have any duplicate values.) If an item can be added to the index, DynamoDB will do so. After all items have been processed, the backfilling operation is complete and <code>Backfilling</code> is false.</p> <p>You can delete an index that is being created during the <code>Backfilling</code> phase when <code>IndexStatus</code> is set to CREATING and <code>Backfilling</code> is true. You can\'t delete the index that is being created when <code>IndexStatus</code> is set to CREATING and <code>Backfilling</code> is false. </p> <note> <p>For indexes that were created during a <code>CreateTable</code> operation, the <code>Backfilling</code> attribute does not appear in the <code>DescribeTable</code> output.</p> </note>', ], ], 'BackupArn' => [ 'base' => NULL, 'refs' => [ 'ArchivalSummary$ArchivalBackupArn' => '<p>The Amazon Resource Name (ARN) of the backup the table was archived to, when applicable in the archival reason. If you wish to restore this backup to the same table name, you will need to delete the original table.</p>', 'BackupDetails$BackupArn' => '<p>ARN associated with the backup.</p>', 'BackupSummary$BackupArn' => '<p>ARN associated with the backup.</p>', 'DeleteBackupInput$BackupArn' => '<p>The ARN associated with the backup.</p>', 'DescribeBackupInput$BackupArn' => '<p>The Amazon Resource Name (ARN) associated with the backup.</p>', 'ListBackupsInput$ExclusiveStartBackupArn' => '<p> <code>LastEvaluatedBackupArn</code> is the Amazon Resource Name (ARN) of the backup last evaluated when the current page of results was returned, inclusive of the current page of results. This value may be specified as the <code>ExclusiveStartBackupArn</code> of a new <code>ListBackups</code> operation in order to fetch the next page of results. </p>', 'ListBackupsOutput$LastEvaluatedBackupArn' => '<p> The ARN of the backup last evaluated when the current page of results was returned, inclusive of the current page of results. This value may be specified as the <code>ExclusiveStartBackupArn</code> of a new <code>ListBackups</code> operation in order to fetch the next page of results. </p> <p> If <code>LastEvaluatedBackupArn</code> is empty, then the last page of results has been processed and there are no more results to be retrieved. </p> <p> If <code>LastEvaluatedBackupArn</code> is not empty, this may or may not indicate that there is more data to be returned. All results are guaranteed to have been returned if and only if no value for <code>LastEvaluatedBackupArn</code> is returned. </p>', 'RestoreSummary$SourceBackupArn' => '<p>The Amazon Resource Name (ARN) of the backup from which the table was restored.</p>', 'RestoreTableFromBackupInput$BackupArn' => '<p>The Amazon Resource Name (ARN) associated with the backup.</p>', ], ], 'BackupCreationDateTime' => [ 'base' => NULL, 'refs' => [ 'BackupDetails$BackupCreationDateTime' => '<p>Time at which the backup was created. This is the request time of the backup. </p>', 'BackupSummary$BackupCreationDateTime' => '<p>Time at which the backup was created.</p>', ], ], 'BackupDescription' => [ 'base' => '<p>Contains the description of the backup created for the table.</p>', 'refs' => [ 'DeleteBackupOutput$BackupDescription' => '<p>Contains the description of the backup created for the table.</p>', 'DescribeBackupOutput$BackupDescription' => '<p>Contains the description of the backup created for the table.</p>', ], ], 'BackupDetails' => [ 'base' => '<p>Contains the details of the backup created for the table.</p>', 'refs' => [ 'BackupDescription$BackupDetails' => '<p>Contains the details of the backup created for the table. </p>', 'CreateBackupOutput$BackupDetails' => '<p>Contains the details of the backup created for the table.</p>', ], ], 'BackupInUseException' => [ 'base' => '<p>There is another ongoing conflicting backup control plane operation on the table. The backup is either being created, deleted or restored to a table.</p>', 'refs' => [], ], 'BackupName' => [ 'base' => NULL, 'refs' => [ 'BackupDetails$BackupName' => '<p>Name of the requested backup.</p>', 'BackupSummary$BackupName' => '<p>Name of the specified backup.</p>', 'CreateBackupInput$BackupName' => '<p>Specified name for the backup.</p>', ], ], 'BackupNotFoundException' => [ 'base' => '<p>Backup not found for the given BackupARN. </p>', 'refs' => [], ], 'BackupSizeBytes' => [ 'base' => NULL, 'refs' => [ 'BackupDetails$BackupSizeBytes' => '<p>Size of the backup in bytes.</p>', 'BackupSummary$BackupSizeBytes' => '<p>Size of the backup in bytes.</p>', ], ], 'BackupStatus' => [ 'base' => NULL, 'refs' => [ 'BackupDetails$BackupStatus' => '<p>Backup can be in one of the following states: CREATING, ACTIVE, DELETED. </p>', 'BackupSummary$BackupStatus' => '<p>Backup can be in one of the following states: CREATING, ACTIVE, DELETED.</p>', ], ], 'BackupSummaries' => [ 'base' => NULL, 'refs' => [ 'ListBackupsOutput$BackupSummaries' => '<p>List of <code>BackupSummary</code> objects.</p>', ], ], 'BackupSummary' => [ 'base' => '<p>Contains details for the backup.</p>', 'refs' => [ 'BackupSummaries$member' => NULL, ], ], 'BackupType' => [ 'base' => NULL, 'refs' => [ 'BackupDetails$BackupType' => '<p>BackupType:</p> <ul> <li> <p> <code>USER</code> - You create and manage these using the on-demand backup feature.</p> </li> <li> <p> <code>SYSTEM</code> - If you delete a table with point-in-time recovery enabled, a <code>SYSTEM</code> backup is automatically created and is retained for 35 days (at no additional cost). System backups allow you to restore the deleted table to the state it was in just before the point of deletion. </p> </li> <li> <p> <code>AWS_BACKUP</code> - On-demand backup created by you from Backup service.</p> </li> </ul>', 'BackupSummary$BackupType' => '<p>BackupType:</p> <ul> <li> <p> <code>USER</code> - You create and manage these using the on-demand backup feature.</p> </li> <li> <p> <code>SYSTEM</code> - If you delete a table with point-in-time recovery enabled, a <code>SYSTEM</code> backup is automatically created and is retained for 35 days (at no additional cost). System backups allow you to restore the deleted table to the state it was in just before the point of deletion. </p> </li> <li> <p> <code>AWS_BACKUP</code> - On-demand backup created by you from Backup service.</p> </li> </ul>', ], ], 'BackupTypeFilter' => [ 'base' => NULL, 'refs' => [ 'ListBackupsInput$BackupType' => '<p>The backups from the table specified by <code>BackupType</code> are listed.</p> <p>Where <code>BackupType</code> can be:</p> <ul> <li> <p> <code>USER</code> - On-demand backup created by you.</p> </li> <li> <p> <code>SYSTEM</code> - On-demand backup automatically created by DynamoDB.</p> </li> <li> <p> <code>ALL</code> - All types of on-demand backups (USER and SYSTEM).</p> </li> </ul>', ], ], 'BackupsInputLimit' => [ 'base' => NULL, 'refs' => [ 'ListBackupsInput$Limit' => '<p>Maximum number of backups to return at once.</p>', ], ], 'BatchExecuteStatementInput' => [ 'base' => NULL, 'refs' => [], ], 'BatchExecuteStatementOutput' => [ 'base' => NULL, 'refs' => [], ], 'BatchGetItemInput' => [ 'base' => '<p>Represents the input of a <code>BatchGetItem</code> operation.</p>', 'refs' => [], ], 'BatchGetItemOutput' => [ 'base' => '<p>Represents the output of a <code>BatchGetItem</code> operation.</p>', 'refs' => [], ], 'BatchGetRequestMap' => [ 'base' => NULL, 'refs' => [ 'BatchGetItemInput$RequestItems' => '<p>A map of one or more table names and, for each table, a map that describes one or more items to retrieve from that table. Each table name can be used only once per <code>BatchGetItem</code> request.</p> <p>Each element in the map of items to retrieve consists of the following:</p> <ul> <li> <p> <code>ConsistentRead</code> - If <code>true</code>, a strongly consistent read is used; if <code>false</code> (the default), an eventually consistent read is used.</p> </li> <li> <p> <code>ExpressionAttributeNames</code> - One or more substitution tokens for attribute names in the <code>ProjectionExpression</code> parameter. The following are some use cases for using <code>ExpressionAttributeNames</code>:</p> <ul> <li> <p>To access an attribute whose name conflicts with a DynamoDB reserved word.</p> </li> <li> <p>To create a placeholder for repeating occurrences of an attribute name in an expression.</p> </li> <li> <p>To prevent special characters in an attribute name from being misinterpreted in an expression.</p> </li> </ul> <p>Use the <b>#</b> character in an expression to dereference an attribute name. For example, consider the following attribute name:</p> <ul> <li> <p> <code>Percentile</code> </p> </li> </ul> <p>The name of this attribute conflicts with a reserved word, so it cannot be used directly in an expression. (For the complete list of reserved words, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ReservedWords.html">Reserved Words</a> in the <i>Amazon DynamoDB Developer Guide</i>). To work around this, you could specify the following for <code>ExpressionAttributeNames</code>:</p> <ul> <li> <p> <code>{"#P":"Percentile"}</code> </p> </li> </ul> <p>You could then use this substitution in an expression, as in this example:</p> <ul> <li> <p> <code>#P = :val</code> </p> </li> </ul> <note> <p>Tokens that begin with the <b>:</b> character are <i>expression attribute values</i>, which are placeholders for the actual value at runtime.</p> </note> <p>For more information about expression attribute names, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html">Accessing Item Attributes</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p> </li> <li> <p> <code>Keys</code> - An array of primary key attribute values that define specific items in the table. For each primary key, you must provide <i>all</i> of the key attributes. For example, with a simple primary key, you only need to provide the partition key value. For a composite key, you must provide <i>both</i> the partition key value and the sort key value.</p> </li> <li> <p> <code>ProjectionExpression</code> - A string that identifies one or more attributes to retrieve from the table. These attributes can include scalars, sets, or elements of a JSON document. The attributes in the expression must be separated by commas.</p> <p>If no attribute names are specified, then all attributes are returned. If any of the requested attributes are not found, they do not appear in the result.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html">Accessing Item Attributes</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p> </li> <li> <p> <code>AttributesToGet</code> - This is a legacy parameter. Use <code>ProjectionExpression</code> instead. For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.AttributesToGet.html">AttributesToGet</a> in the <i>Amazon DynamoDB Developer Guide</i>. </p> </li> </ul>', 'BatchGetItemOutput$UnprocessedKeys' => '<p>A map of tables and their respective keys that were not processed with the current response. The <code>UnprocessedKeys</code> value is in the same form as <code>RequestItems</code>, so the value can be provided directly to a subsequent <code>BatchGetItem</code> operation. For more information, see <code>RequestItems</code> in the Request Parameters section.</p> <p>Each element consists of:</p> <ul> <li> <p> <code>Keys</code> - An array of primary key attribute values that define specific items in the table.</p> </li> <li> <p> <code>ProjectionExpression</code> - One or more attributes to be retrieved from the table or index. By default, all attributes are returned. If a requested attribute is not found, it does not appear in the result.</p> </li> <li> <p> <code>ConsistentRead</code> - The consistency of a read operation. If set to <code>true</code>, then a strongly consistent read is used; otherwise, an eventually consistent read is used.</p> </li> </ul> <p>If there are no unprocessed keys remaining, the response contains an empty <code>UnprocessedKeys</code> map.</p>', ], ], 'BatchGetResponseMap' => [ 'base' => NULL, 'refs' => [ 'BatchGetItemOutput$Responses' => '<p>A map of table name to a list of items. Each object in <code>Responses</code> consists of a table name, along with a map of attribute data consisting of the data type and attribute value.</p>', ], ], 'BatchStatementError' => [ 'base' => '<p> An error associated with a statement in a PartiQL batch that was run. </p>', 'refs' => [ 'BatchStatementResponse$Error' => '<p> The error associated with a failed PartiQL batch statement. </p>', ], ], 'BatchStatementErrorCodeEnum' => [ 'base' => NULL, 'refs' => [ 'BatchStatementError$Code' => '<p> The error code associated with the failed PartiQL batch statement. </p>', ], ], 'BatchStatementRequest' => [ 'base' => '<p> A PartiQL batch statement request. </p>', 'refs' => [ 'PartiQLBatchRequest$member' => NULL, ], ], 'BatchStatementResponse' => [ 'base' => '<p> A PartiQL batch statement response.. </p>', 'refs' => [ 'PartiQLBatchResponse$member' => NULL, ], ], 'BatchWriteItemInput' => [ 'base' => '<p>Represents the input of a <code>BatchWriteItem</code> operation.</p>', 'refs' => [], ], 'BatchWriteItemOutput' => [ 'base' => '<p>Represents the output of a <code>BatchWriteItem</code> operation.</p>', 'refs' => [], ], 'BatchWriteItemRequestMap' => [ 'base' => NULL, 'refs' => [ 'BatchWriteItemInput$RequestItems' => '<p>A map of one or more table names and, for each table, a list of operations to be performed (<code>DeleteRequest</code> or <code>PutRequest</code>). Each element in the map consists of the following:</p> <ul> <li> <p> <code>DeleteRequest</code> - Perform a <code>DeleteItem</code> operation on the specified item. The item to be deleted is identified by a <code>Key</code> subelement:</p> <ul> <li> <p> <code>Key</code> - A map of primary key attribute values that uniquely identify the item. Each entry in this map consists of an attribute name and an attribute value. For each primary key, you must provide <i>all</i> of the key attributes. For example, with a simple primary key, you only need to provide a value for the partition key. For a composite primary key, you must provide values for <i>both</i> the partition key and the sort key.</p> </li> </ul> </li> <li> <p> <code>PutRequest</code> - Perform a <code>PutItem</code> operation on the specified item. The item to be put is identified by an <code>Item</code> subelement:</p> <ul> <li> <p> <code>Item</code> - A map of attributes and their values. Each entry in this map consists of an attribute name and an attribute value. Attribute values must not be null; string and binary type attributes must have lengths greater than zero; and set type attributes must not be empty. Requests that contain empty values are rejected with a <code>ValidationException</code> exception.</p> <p>If you specify any attributes that are part of an index key, then the data types for those attributes must match those of the schema in the table\'s attribute definition.</p> </li> </ul> </li> </ul>', 'BatchWriteItemOutput$UnprocessedItems' => '<p>A map of tables and requests against those tables that were not processed. The <code>UnprocessedItems</code> value is in the same form as <code>RequestItems</code>, so you can provide this value directly to a subsequent <code>BatchGetItem</code> operation. For more information, see <code>RequestItems</code> in the Request Parameters section.</p> <p>Each <code>UnprocessedItems</code> entry consists of a table name and, for that table, a list of operations to perform (<code>DeleteRequest</code> or <code>PutRequest</code>).</p> <ul> <li> <p> <code>DeleteRequest</code> - Perform a <code>DeleteItem</code> operation on the specified item. The item to be deleted is identified by a <code>Key</code> subelement:</p> <ul> <li> <p> <code>Key</code> - A map of primary key attribute values that uniquely identify the item. Each entry in this map consists of an attribute name and an attribute value.</p> </li> </ul> </li> <li> <p> <code>PutRequest</code> - Perform a <code>PutItem</code> operation on the specified item. The item to be put is identified by an <code>Item</code> subelement:</p> <ul> <li> <p> <code>Item</code> - A map of attributes and their values. Each entry in this map consists of an attribute name and an attribute value. Attribute values must not be null; string and binary type attributes must have lengths greater than zero; and set type attributes must not be empty. Requests that contain empty values will be rejected with a <code>ValidationException</code> exception.</p> <p>If you specify any attributes that are part of an index key, then the data types for those attributes must match those of the schema in the table\'s attribute definition.</p> </li> </ul> </li> </ul> <p>If there are no unprocessed items remaining, the response contains an empty <code>UnprocessedItems</code> map.</p>', ], ], 'BilledSizeBytes' => [ 'base' => NULL, 'refs' => [ 'ExportDescription$BilledSizeBytes' => '<p>The billable size of the table export.</p>', ], ], 'BillingMode' => [ 'base' => NULL, 'refs' => [ 'BillingModeSummary$BillingMode' => '<p>Controls how you are charged for read and write throughput and how you manage capacity. This setting can be changed later.</p> <ul> <li> <p> <code>PROVISIONED</code> - Sets the read/write capacity mode to <code>PROVISIONED</code>. We recommend using <code>PROVISIONED</code> for predictable workloads.</p> </li> <li> <p> <code>PAY_PER_REQUEST</code> - Sets the read/write capacity mode to <code>PAY_PER_REQUEST</code>. We recommend using <code>PAY_PER_REQUEST</code> for unpredictable workloads. </p> </li> </ul>', 'CreateTableInput$BillingMode' => '<p>Controls how you are charged for read and write throughput and how you manage capacity. This setting can be changed later.</p> <ul> <li> <p> <code>PROVISIONED</code> - We recommend using <code>PROVISIONED</code> for predictable workloads. <code>PROVISIONED</code> sets the billing mode to <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.ReadWriteCapacityMode.html#HowItWorks.ProvisionedThroughput.Manual">Provisioned Mode</a>.</p> </li> <li> <p> <code>PAY_PER_REQUEST</code> - We recommend using <code>PAY_PER_REQUEST</code> for unpredictable workloads. <code>PAY_PER_REQUEST</code> sets the billing mode to <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.ReadWriteCapacityMode.html#HowItWorks.OnDemand">On-Demand Mode</a>. </p> </li> </ul>', 'RestoreTableFromBackupInput$BillingModeOverride' => '<p>The billing mode of the restored table.</p>', 'RestoreTableToPointInTimeInput$BillingModeOverride' => '<p>The billing mode of the restored table.</p>', 'SourceTableDetails$BillingMode' => '<p>Controls how you are charged for read and write throughput and how you manage capacity. This setting can be changed later.</p> <ul> <li> <p> <code>PROVISIONED</code> - Sets the read/write capacity mode to <code>PROVISIONED</code>. We recommend using <code>PROVISIONED</code> for predictable workloads.</p> </li> <li> <p> <code>PAY_PER_REQUEST</code> - Sets the read/write capacity mode to <code>PAY_PER_REQUEST</code>. We recommend using <code>PAY_PER_REQUEST</code> for unpredictable workloads. </p> </li> </ul>', 'UpdateGlobalTableSettingsInput$GlobalTableBillingMode' => '<p>The billing mode of the global table. If <code>GlobalTableBillingMode</code> is not specified, the global table defaults to <code>PROVISIONED</code> capacity billing mode.</p> <ul> <li> <p> <code>PROVISIONED</code> - We recommend using <code>PROVISIONED</code> for predictable workloads. <code>PROVISIONED</code> sets the billing mode to <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.ReadWriteCapacityMode.html#HowItWorks.ProvisionedThroughput.Manual">Provisioned Mode</a>.</p> </li> <li> <p> <code>PAY_PER_REQUEST</code> - We recommend using <code>PAY_PER_REQUEST</code> for unpredictable workloads. <code>PAY_PER_REQUEST</code> sets the billing mode to <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.ReadWriteCapacityMode.html#HowItWorks.OnDemand">On-Demand Mode</a>. </p> </li> </ul>', 'UpdateTableInput$BillingMode' => '<p>Controls how you are charged for read and write throughput and how you manage capacity. When switching from pay-per-request to provisioned capacity, initial provisioned capacity values must be set. The initial provisioned capacity values are estimated based on the consumed read and write capacity of your table and global secondary indexes over the past 30 minutes.</p> <ul> <li> <p> <code>PROVISIONED</code> - We recommend using <code>PROVISIONED</code> for predictable workloads. <code>PROVISIONED</code> sets the billing mode to <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.ReadWriteCapacityMode.html#HowItWorks.ProvisionedThroughput.Manual">Provisioned Mode</a>.</p> </li> <li> <p> <code>PAY_PER_REQUEST</code> - We recommend using <code>PAY_PER_REQUEST</code> for unpredictable workloads. <code>PAY_PER_REQUEST</code> sets the billing mode to <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.ReadWriteCapacityMode.html#HowItWorks.OnDemand">On-Demand Mode</a>. </p> </li> </ul>', ], ], 'BillingModeSummary' => [ 'base' => '<p>Contains the details for the read/write capacity mode.</p>', 'refs' => [ 'ReplicaSettingsDescription$ReplicaBillingModeSummary' => '<p>The read/write capacity mode of the replica.</p>', 'TableDescription$BillingModeSummary' => '<p>Contains the details for the read/write capacity mode.</p>', ], ], 'BinaryAttributeValue' => [ 'base' => NULL, 'refs' => [ 'AttributeValue$B' => '<p>An attribute of type Binary. For example:</p> <p> <code>"B": "dGhpcyB0ZXh0IGlzIGJhc2U2NC1lbmNvZGVk"</code> </p>', 'BinarySetAttributeValue$member' => NULL, ], ], 'BinarySetAttributeValue' => [ 'base' => NULL, 'refs' => [ 'AttributeValue$BS' => '<p>An attribute of type Binary Set. For example:</p> <p> <code>"BS": ["U3Vubnk=", "UmFpbnk=", "U25vd3k="]</code> </p>', ], ], 'BooleanAttributeValue' => [ 'base' => NULL, 'refs' => [ 'AttributeValue$BOOL' => '<p>An attribute of type Boolean. For example:</p> <p> <code>"BOOL": true</code> </p>', ], ], 'BooleanObject' => [ 'base' => NULL, 'refs' => [ 'AutoScalingSettingsDescription$AutoScalingDisabled' => '<p>Disabled auto scaling for this global table or global secondary index.</p>', 'AutoScalingSettingsUpdate$AutoScalingDisabled' => '<p>Disabled auto scaling for this global table or global secondary index.</p>', 'AutoScalingTargetTrackingScalingPolicyConfigurationDescription$DisableScaleIn' => '<p>Indicates whether scale in by the target tracking policy is disabled. If the value is true, scale in is disabled and the target tracking policy won\'t remove capacity from the scalable resource. Otherwise, scale in is enabled and the target tracking policy can remove capacity from the scalable resource. The default value is false.</p>', 'AutoScalingTargetTrackingScalingPolicyConfigurationUpdate$DisableScaleIn' => '<p>Indicates whether scale in by the target tracking policy is disabled. If the value is true, scale in is disabled and the target tracking policy won\'t remove capacity from the scalable resource. Otherwise, scale in is enabled and the target tracking policy can remove capacity from the scalable resource. The default value is false.</p>', 'ExpectedAttributeValue$Exists' => '<p>Causes DynamoDB to evaluate the value before attempting a conditional operation:</p> <ul> <li> <p>If <code>Exists</code> is <code>true</code>, DynamoDB will check to see if that attribute value already exists in the table. If it is found, then the operation succeeds. If it is not found, the operation fails with a <code>ConditionCheckFailedException</code>.</p> </li> <li> <p>If <code>Exists</code> is <code>false</code>, DynamoDB assumes that the attribute value does not exist in the table. If in fact the value does not exist, then the assumption is valid and the operation succeeds. If the value is found, despite the assumption that it does not exist, the operation fails with a <code>ConditionCheckFailedException</code>.</p> </li> </ul> <p>The default setting for <code>Exists</code> is <code>true</code>. If you supply a <code>Value</code> all by itself, DynamoDB assumes the attribute exists: You don\'t have to set <code>Exists</code> to <code>true</code>, because it is implied.</p> <p>DynamoDB returns a <code>ValidationException</code> if:</p> <ul> <li> <p> <code>Exists</code> is <code>true</code> but there is no <code>Value</code> to check. (You expect a value to exist, but don\'t specify what that value is.)</p> </li> <li> <p> <code>Exists</code> is <code>false</code> but you also provide a <code>Value</code>. (You cannot expect an attribute to have a value, while also expecting it not to exist.)</p> </li> </ul>', 'PointInTimeRecoverySpecification$PointInTimeRecoveryEnabled' => '<p>Indicates whether point in time recovery is enabled (true) or disabled (false) on the table.</p>', 'QueryInput$ScanIndexForward' => '<p>Specifies the order for index traversal: If <code>true</code> (default), the traversal is performed in ascending order; if <code>false</code>, the traversal is performed in descending order. </p> <p>Items with the same partition key value are stored in sorted order by sort key. If the sort key data type is Number, the results are stored in numeric order. For type String, the results are stored in order of UTF-8 bytes. For type Binary, DynamoDB treats each byte of the binary data as unsigned.</p> <p>If <code>ScanIndexForward</code> is <code>true</code>, DynamoDB returns the results in the order in which they are stored (by sort key value). This is the default behavior. If <code>ScanIndexForward</code> is <code>false</code>, DynamoDB reads the results in reverse order by sort key value, and then returns the results to the client.</p>', 'RestoreTableToPointInTimeInput$UseLatestRestorableTime' => '<p>Restore the table to the latest possible time. <code>LatestRestorableDateTime</code> is typically 5 minutes before the current time. </p>', ], ], 'CancellationReason' => [ 'base' => '<p>An ordered list of errors for each item in the request which caused the transaction to get cancelled. The values of the list are ordered according to the ordering of the <code>TransactWriteItems</code> request parameter. If no error occurred for the associated item an error with a Null code and Null message will be present. </p>', 'refs' => [ 'CancellationReasonList$member' => NULL, ], ], 'CancellationReasonList' => [ 'base' => NULL, 'refs' => [ 'TransactionCanceledException$CancellationReasons' => '<p>A list of cancellation reasons.</p>', ], ], 'Capacity' => [ 'base' => '<p>Represents the amount of provisioned throughput capacity consumed on a table or an index.</p>', 'refs' => [ 'ConsumedCapacity$Table' => '<p>The amount of throughput consumed on the table affected by the operation.</p>', 'SecondaryIndexesCapacityMap$value' => NULL, ], ], 'ClientRequestToken' => [ 'base' => NULL, 'refs' => [ 'ExecuteTransactionInput$ClientRequestToken' => '<p>Set this value to get remaining results, if <code>NextToken</code> was returned in the statement response.</p>', 'TransactWriteItemsInput$ClientRequestToken' => '<p>Providing a <code>ClientRequestToken</code> makes the call to <code>TransactWriteItems</code> idempotent, meaning that multiple identical calls have the same effect as one single call.</p> <p>Although multiple identical calls using the same client request token produce the same result on the server (no side effects), the responses to the calls might not be the same. If the <code>ReturnConsumedCapacity&gt;</code> parameter is set, then the initial <code>TransactWriteItems</code> call returns the amount of write capacity units consumed in making the changes. Subsequent <code>TransactWriteItems</code> calls with the same client token return the number of read capacity units consumed in reading the item.</p> <p>A client request token is valid for 10 minutes after the first request that uses it is completed. After 10 minutes, any request with the same client token is treated as a new request. Do not resubmit the same request with the same client token for more than 10 minutes, or the result might not be idempotent.</p> <p>If you submit a request with the same client token but a change in other parameters within the 10-minute idempotency window, DynamoDB returns an <code>IdempotentParameterMismatch</code> exception.</p>', ], ], 'ClientToken' => [ 'base' => NULL, 'refs' => [ 'ExportDescription$ClientToken' => '<p>The client token that was provided for the export task. A client token makes calls to <code>ExportTableToPointInTimeInput</code> idempotent, meaning that multiple identical calls have the same effect as one single call.</p>', 'ExportTableToPointInTimeInput$ClientToken' => '<p>Providing a <code>ClientToken</code> makes the call to <code>ExportTableToPointInTimeInput</code> idempotent, meaning that multiple identical calls have the same effect as one single call.</p> <p>A client token is valid for 8 hours after the first request that uses it is completed. After 8 hours, any request with the same client token is treated as a new request. Do not resubmit the same request with the same client token for more than 8 hours, or the result might not be idempotent.</p> <p>If you submit a request with the same client token but a change in other parameters within the 8-hour idempotency window, DynamoDB returns an <code>IdempotentParameterMismatch</code> exception.</p>', ], ], 'Code' => [ 'base' => NULL, 'refs' => [ 'CancellationReason$Code' => '<p>Status code for the result of the cancelled transaction.</p>', ], ], 'ComparisonOperator' => [ 'base' => NULL, 'refs' => [ 'Condition$ComparisonOperator' => '<p>A comparator for evaluating attributes. For example, equals, greater than, less than, etc.</p> <p>The following comparison operators are available:</p> <p> <code>EQ | NE | LE | LT | GE | GT | NOT_NULL | NULL | CONTAINS | NOT_CONTAINS | BEGINS_WITH | IN | BETWEEN</code> </p> <p>The following are descriptions of each comparison operator.</p> <ul> <li> <p> <code>EQ</code> : Equal. <code>EQ</code> is supported for all data types, including lists and maps.</p> <p> <code>AttributeValueList</code> can contain only one <code>AttributeValue</code> element of type String, Number, Binary, String Set, Number Set, or Binary Set. If an item contains an <code>AttributeValue</code> element of a different type than the one provided in the request, the value does not match. For example, <code>{"S":"6"}</code> does not equal <code>{"N":"6"}</code>. Also, <code>{"N":"6"}</code> does not equal <code>{"NS":["6", "2", "1"]}</code>.</p> <p/> </li> <li> <p> <code>NE</code> : Not equal. <code>NE</code> is supported for all data types, including lists and maps.</p> <p> <code>AttributeValueList</code> can contain only one <code>AttributeValue</code> of type String, Number, Binary, String Set, Number Set, or Binary Set. If an item contains an <code>AttributeValue</code> of a different type than the one provided in the request, the value does not match. For example, <code>{"S":"6"}</code> does not equal <code>{"N":"6"}</code>. Also, <code>{"N":"6"}</code> does not equal <code>{"NS":["6", "2", "1"]}</code>.</p> <p/> </li> <li> <p> <code>LE</code> : Less than or equal. </p> <p> <code>AttributeValueList</code> can contain only one <code>AttributeValue</code> element of type String, Number, or Binary (not a set type). If an item contains an <code>AttributeValue</code> element of a different type than the one provided in the request, the value does not match. For example, <code>{"S":"6"}</code> does not equal <code>{"N":"6"}</code>. Also, <code>{"N":"6"}</code> does not compare to <code>{"NS":["6", "2", "1"]}</code>.</p> <p/> </li> <li> <p> <code>LT</code> : Less than. </p> <p> <code>AttributeValueList</code> can contain only one <code>AttributeValue</code> of type String, Number, or Binary (not a set type). If an item contains an <code>AttributeValue</code> element of a different type than the one provided in the request, the value does not match. For example, <code>{"S":"6"}</code> does not equal <code>{"N":"6"}</code>. Also, <code>{"N":"6"}</code> does not compare to <code>{"NS":["6", "2", "1"]}</code>.</p> <p/> </li> <li> <p> <code>GE</code> : Greater than or equal. </p> <p> <code>AttributeValueList</code> can contain only one <code>AttributeValue</code> element of type String, Number, or Binary (not a set type). If an item contains an <code>AttributeValue</code> element of a different type than the one provided in the request, the value does not match. For example, <code>{"S":"6"}</code> does not equal <code>{"N":"6"}</code>. Also, <code>{"N":"6"}</code> does not compare to <code>{"NS":["6", "2", "1"]}</code>.</p> <p/> </li> <li> <p> <code>GT</code> : Greater than. </p> <p> <code>AttributeValueList</code> can contain only one <code>AttributeValue</code> element of type String, Number, or Binary (not a set type). If an item contains an <code>AttributeValue</code> element of a different type than the one provided in the request, the value does not match. For example, <code>{"S":"6"}</code> does not equal <code>{"N":"6"}</code>. Also, <code>{"N":"6"}</code> does not compare to <code>{"NS":["6", "2", "1"]}</code>.</p> <p/> </li> <li> <p> <code>NOT_NULL</code> : The attribute exists. <code>NOT_NULL</code> is supported for all data types, including lists and maps.</p> <note> <p>This operator tests for the existence of an attribute, not its data type. If the data type of attribute "<code>a</code>" is null, and you evaluate it using <code>NOT_NULL</code>, the result is a Boolean <code>true</code>. This result is because the attribute "<code>a</code>" exists; its data type is not relevant to the <code>NOT_NULL</code> comparison operator.</p> </note> </li> <li> <p> <code>NULL</code> : The attribute does not exist. <code>NULL</code> is supported for all data types, including lists and maps.</p> <note> <p>This operator tests for the nonexistence of an attribute, not its data type. If the data type of attribute "<code>a</code>" is null, and you evaluate it using <code>NULL</code>, the result is a Boolean <code>false</code>. This is because the attribute "<code>a</code>" exists; its data type is not relevant to the <code>NULL</code> comparison operator.</p> </note> </li> <li> <p> <code>CONTAINS</code> : Checks for a subsequence, or value in a set.</p> <p> <code>AttributeValueList</code> can contain only one <code>AttributeValue</code> element of type String, Number, or Binary (not a set type). If the target attribute of the comparison is of type String, then the operator checks for a substring match. If the target attribute of the comparison is of type Binary, then the operator looks for a subsequence of the target that matches the input. If the target attribute of the comparison is a set ("<code>SS</code>", "<code>NS</code>", or "<code>BS</code>"), then the operator evaluates to true if it finds an exact match with any member of the set.</p> <p>CONTAINS is supported for lists: When evaluating "<code>a CONTAINS b</code>", "<code>a</code>" can be a list; however, "<code>b</code>" cannot be a set, a map, or a list.</p> </li> <li> <p> <code>NOT_CONTAINS</code> : Checks for absence of a subsequence, or absence of a value in a set.</p> <p> <code>AttributeValueList</code> can contain only one <code>AttributeValue</code> element of type String, Number, or Binary (not a set type). If the target attribute of the comparison is a String, then the operator checks for the absence of a substring match. If the target attribute of the comparison is Binary, then the operator checks for the absence of a subsequence of the target that matches the input. If the target attribute of the comparison is a set ("<code>SS</code>", "<code>NS</code>", or "<code>BS</code>"), then the operator evaluates to true if it <i>does not</i> find an exact match with any member of the set.</p> <p>NOT_CONTAINS is supported for lists: When evaluating "<code>a NOT CONTAINS b</code>", "<code>a</code>" can be a list; however, "<code>b</code>" cannot be a set, a map, or a list.</p> </li> <li> <p> <code>BEGINS_WITH</code> : Checks for a prefix. </p> <p> <code>AttributeValueList</code> can contain only one <code>AttributeValue</code> of type String or Binary (not a Number or a set type). The target attribute of the comparison must be of type String or Binary (not a Number or a set type).</p> <p/> </li> <li> <p> <code>IN</code> : Checks for matching elements in a list.</p> <p> <code>AttributeValueList</code> can contain one or more <code>AttributeValue</code> elements of type String, Number, or Binary. These attributes are compared against an existing attribute of an item. If any elements of the input are equal to the item attribute, the expression evaluates to true.</p> </li> <li> <p> <code>BETWEEN</code> : Greater than or equal to the first value, and less than or equal to the second value. </p> <p> <code>AttributeValueList</code> must contain two <code>AttributeValue</code> elements of the same type, either String, Number, or Binary (not a set type). A target attribute matches if the target value is greater than, or equal to, the first element and less than, or equal to, the second element. If an item contains an <code>AttributeValue</code> element of a different type than the one provided in the request, the value does not match. For example, <code>{"S":"6"}</code> does not compare to <code>{"N":"6"}</code>. Also, <code>{"N":"6"}</code> does not compare to <code>{"NS":["6", "2", "1"]}</code> </p> </li> </ul> <p>For usage examples of <code>AttributeValueList</code> and <code>ComparisonOperator</code>, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.html">Legacy Conditional Parameters</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>', 'ExpectedAttributeValue$ComparisonOperator' => '<p>A comparator for evaluating attributes in the <code>AttributeValueList</code>. For example, equals, greater than, less than, etc.</p> <p>The following comparison operators are available:</p> <p> <code>EQ | NE | LE | LT | GE | GT | NOT_NULL | NULL | CONTAINS | NOT_CONTAINS | BEGINS_WITH | IN | BETWEEN</code> </p> <p>The following are descriptions of each comparison operator.</p> <ul> <li> <p> <code>EQ</code> : Equal. <code>EQ</code> is supported for all data types, including lists and maps.</p> <p> <code>AttributeValueList</code> can contain only one <code>AttributeValue</code> element of type String, Number, Binary, String Set, Number Set, or Binary Set. If an item contains an <code>AttributeValue</code> element of a different type than the one provided in the request, the value does not match. For example, <code>{"S":"6"}</code> does not equal <code>{"N":"6"}</code>. Also, <code>{"N":"6"}</code> does not equal <code>{"NS":["6", "2", "1"]}</code>.</p> <p/> </li> <li> <p> <code>NE</code> : Not equal. <code>NE</code> is supported for all data types, including lists and maps.</p> <p> <code>AttributeValueList</code> can contain only one <code>AttributeValue</code> of type String, Number, Binary, String Set, Number Set, or Binary Set. If an item contains an <code>AttributeValue</code> of a different type than the one provided in the request, the value does not match. For example, <code>{"S":"6"}</code> does not equal <code>{"N":"6"}</code>. Also, <code>{"N":"6"}</code> does not equal <code>{"NS":["6", "2", "1"]}</code>.</p> <p/> </li> <li> <p> <code>LE</code> : Less than or equal. </p> <p> <code>AttributeValueList</code> can contain only one <code>AttributeValue</code> element of type String, Number, or Binary (not a set type). If an item contains an <code>AttributeValue</code> element of a different type than the one provided in the request, the value does not match. For example, <code>{"S":"6"}</code> does not equal <code>{"N":"6"}</code>. Also, <code>{"N":"6"}</code> does not compare to <code>{"NS":["6", "2", "1"]}</code>.</p> <p/> </li> <li> <p> <code>LT</code> : Less than. </p> <p> <code>AttributeValueList</code> can contain only one <code>AttributeValue</code> of type String, Number, or Binary (not a set type). If an item contains an <code>AttributeValue</code> element of a different type than the one provided in the request, the value does not match. For example, <code>{"S":"6"}</code> does not equal <code>{"N":"6"}</code>. Also, <code>{"N":"6"}</code> does not compare to <code>{"NS":["6", "2", "1"]}</code>.</p> <p/> </li> <li> <p> <code>GE</code> : Greater than or equal. </p> <p> <code>AttributeValueList</code> can contain only one <code>AttributeValue</code> element of type String, Number, or Binary (not a set type). If an item contains an <code>AttributeValue</code> element of a different type than the one provided in the request, the value does not match. For example, <code>{"S":"6"}</code> does not equal <code>{"N":"6"}</code>. Also, <code>{"N":"6"}</code> does not compare to <code>{"NS":["6", "2", "1"]}</code>.</p> <p/> </li> <li> <p> <code>GT</code> : Greater than. </p> <p> <code>AttributeValueList</code> can contain only one <code>AttributeValue</code> element of type String, Number, or Binary (not a set type). If an item contains an <code>AttributeValue</code> element of a different type than the one provided in the request, the value does not match. For example, <code>{"S":"6"}</code> does not equal <code>{"N":"6"}</code>. Also, <code>{"N":"6"}</code> does not compare to <code>{"NS":["6", "2", "1"]}</code>.</p> <p/> </li> <li> <p> <code>NOT_NULL</code> : The attribute exists. <code>NOT_NULL</code> is supported for all data types, including lists and maps.</p> <note> <p>This operator tests for the existence of an attribute, not its data type. If the data type of attribute "<code>a</code>" is null, and you evaluate it using <code>NOT_NULL</code>, the result is a Boolean <code>true</code>. This result is because the attribute "<code>a</code>" exists; its data type is not relevant to the <code>NOT_NULL</code> comparison operator.</p> </note> </li> <li> <p> <code>NULL</code> : The attribute does not exist. <code>NULL</code> is supported for all data types, including lists and maps.</p> <note> <p>This operator tests for the nonexistence of an attribute, not its data type. If the data type of attribute "<code>a</code>" is null, and you evaluate it using <code>NULL</code>, the result is a Boolean <code>false</code>. This is because the attribute "<code>a</code>" exists; its data type is not relevant to the <code>NULL</code> comparison operator.</p> </note> </li> <li> <p> <code>CONTAINS</code> : Checks for a subsequence, or value in a set.</p> <p> <code>AttributeValueList</code> can contain only one <code>AttributeValue</code> element of type String, Number, or Binary (not a set type). If the target attribute of the comparison is of type String, then the operator checks for a substring match. If the target attribute of the comparison is of type Binary, then the operator looks for a subsequence of the target that matches the input. If the target attribute of the comparison is a set ("<code>SS</code>", "<code>NS</code>", or "<code>BS</code>"), then the operator evaluates to true if it finds an exact match with any member of the set.</p> <p>CONTAINS is supported for lists: When evaluating "<code>a CONTAINS b</code>", "<code>a</code>" can be a list; however, "<code>b</code>" cannot be a set, a map, or a list.</p> </li> <li> <p> <code>NOT_CONTAINS</code> : Checks for absence of a subsequence, or absence of a value in a set.</p> <p> <code>AttributeValueList</code> can contain only one <code>AttributeValue</code> element of type String, Number, or Binary (not a set type). If the target attribute of the comparison is a String, then the operator checks for the absence of a substring match. If the target attribute of the comparison is Binary, then the operator checks for the absence of a subsequence of the target that matches the input. If the target attribute of the comparison is a set ("<code>SS</code>", "<code>NS</code>", or "<code>BS</code>"), then the operator evaluates to true if it <i>does not</i> find an exact match with any member of the set.</p> <p>NOT_CONTAINS is supported for lists: When evaluating "<code>a NOT CONTAINS b</code>", "<code>a</code>" can be a list; however, "<code>b</code>" cannot be a set, a map, or a list.</p> </li> <li> <p> <code>BEGINS_WITH</code> : Checks for a prefix. </p> <p> <code>AttributeValueList</code> can contain only one <code>AttributeValue</code> of type String or Binary (not a Number or a set type). The target attribute of the comparison must be of type String or Binary (not a Number or a set type).</p> <p/> </li> <li> <p> <code>IN</code> : Checks for matching elements in a list.</p> <p> <code>AttributeValueList</code> can contain one or more <code>AttributeValue</code> elements of type String, Number, or Binary. These attributes are compared against an existing attribute of an item. If any elements of the input are equal to the item attribute, the expression evaluates to true.</p> </li> <li> <p> <code>BETWEEN</code> : Greater than or equal to the first value, and less than or equal to the second value. </p> <p> <code>AttributeValueList</code> must contain two <code>AttributeValue</code> elements of the same type, either String, Number, or Binary (not a set type). A target attribute matches if the target value is greater than, or equal to, the first element and less than, or equal to, the second element. If an item contains an <code>AttributeValue</code> element of a different type than the one provided in the request, the value does not match. For example, <code>{"S":"6"}</code> does not compare to <code>{"N":"6"}</code>. Also, <code>{"N":"6"}</code> does not compare to <code>{"NS":["6", "2", "1"]}</code> </p> </li> </ul>', ], ], 'Condition' => [ 'base' => '<p>Represents the selection criteria for a <code>Query</code> or <code>Scan</code> operation:</p> <ul> <li> <p>For a <code>Query</code> operation, <code>Condition</code> is used for specifying the <code>KeyConditions</code> to use when querying a table or an index. For <code>KeyConditions</code>, only the following comparison operators are supported:</p> <p> <code>EQ | LE | LT | GE | GT | BEGINS_WITH | BETWEEN</code> </p> <p> <code>Condition</code> is also used in a <code>QueryFilter</code>, which evaluates the query results and returns only the desired values.</p> </li> <li> <p>For a <code>Scan</code> operation, <code>Condition</code> is used in a <code>ScanFilter</code>, which evaluates the scan results and returns only the desired values.</p> </li> </ul>', 'refs' => [ 'FilterConditionMap$value' => NULL, 'KeyConditions$value' => NULL, ], ], 'ConditionCheck' => [ 'base' => '<p>Represents a request to perform a check that an item exists or to check the condition of specific attributes of the item.</p>', 'refs' => [ 'TransactWriteItem$ConditionCheck' => '<p>A request to perform a check item operation.</p>', ], ], 'ConditionExpression' => [ 'base' => NULL, 'refs' => [ 'ConditionCheck$ConditionExpression' => '<p>A condition that must be satisfied in order for a conditional update to succeed.</p>', 'Delete$ConditionExpression' => '<p>A condition that must be satisfied in order for a conditional delete to succeed.</p>', 'DeleteItemInput$ConditionExpression' => '<p>A condition that must be satisfied in order for a conditional <code>DeleteItem</code> to succeed.</p> <p>An expression can contain any of the following:</p> <ul> <li> <p>Functions: <code>attribute_exists | attribute_not_exists | attribute_type | contains | begins_with | size</code> </p> <p>These function names are case-sensitive.</p> </li> <li> <p>Comparison operators: <code>= | &lt;&gt; | &lt; | &gt; | &lt;= | &gt;= | BETWEEN | IN </code> </p> </li> <li> <p> Logical operators: <code>AND | OR | NOT</code> </p> </li> </ul> <p>For more information about condition expressions, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.SpecifyingConditions.html">Condition Expressions</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>', 'Put$ConditionExpression' => '<p>A condition that must be satisfied in order for a conditional update to succeed.</p>', 'PutItemInput$ConditionExpression' => '<p>A condition that must be satisfied in order for a conditional <code>PutItem</code> operation to succeed.</p> <p>An expression can contain any of the following:</p> <ul> <li> <p>Functions: <code>attribute_exists | attribute_not_exists | attribute_type | contains | begins_with | size</code> </p> <p>These function names are case-sensitive.</p> </li> <li> <p>Comparison operators: <code>= | &lt;&gt; | &lt; | &gt; | &lt;= | &gt;= | BETWEEN | IN </code> </p> </li> <li> <p> Logical operators: <code>AND | OR | NOT</code> </p> </li> </ul> <p>For more information on condition expressions, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.SpecifyingConditions.html">Condition Expressions</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>', 'QueryInput$FilterExpression' => '<p>A string that contains conditions that DynamoDB applies after the <code>Query</code> operation, but before the data is returned to you. Items that do not satisfy the <code>FilterExpression</code> criteria are not returned.</p> <p>A <code>FilterExpression</code> does not allow key attributes. You cannot define a filter expression based on a partition key or a sort key.</p> <note> <p>A <code>FilterExpression</code> is applied after the items have already been read; the process of filtering does not consume any additional read capacity units.</p> </note> <p>For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/QueryAndScan.html#FilteringResults">Filter Expressions</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>', 'ScanInput$FilterExpression' => '<p>A string that contains conditions that DynamoDB applies after the <code>Scan</code> operation, but before the data is returned to you. Items that do not satisfy the <code>FilterExpression</code> criteria are not returned.</p> <note> <p>A <code>FilterExpression</code> is applied after the items have already been read; the process of filtering does not consume any additional read capacity units.</p> </note> <p>For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/QueryAndScan.html#FilteringResults">Filter Expressions</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>', 'Update$ConditionExpression' => '<p>A condition that must be satisfied in order for a conditional update to succeed.</p>', 'UpdateItemInput$ConditionExpression' => '<p>A condition that must be satisfied in order for a conditional update to succeed.</p> <p>An expression can contain any of the following:</p> <ul> <li> <p>Functions: <code>attribute_exists | attribute_not_exists | attribute_type | contains | begins_with | size</code> </p> <p>These function names are case-sensitive.</p> </li> <li> <p>Comparison operators: <code>= | &lt;&gt; | &lt; | &gt; | &lt;= | &gt;= | BETWEEN | IN </code> </p> </li> <li> <p> Logical operators: <code>AND | OR | NOT</code> </p> </li> </ul> <p>For more information about condition expressions, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.SpecifyingConditions.html">Specifying Conditions</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>', ], ], 'ConditionalCheckFailedException' => [ 'base' => '<p>A condition specified in the operation could not be evaluated.</p>', 'refs' => [], ], 'ConditionalOperator' => [ 'base' => NULL, 'refs' => [ 'DeleteItemInput$ConditionalOperator' => '<p>This is a legacy parameter. Use <code>ConditionExpression</code> instead. For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.ConditionalOperator.html">ConditionalOperator</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>', 'PutItemInput$ConditionalOperator' => '<p>This is a legacy parameter. Use <code>ConditionExpression</code> instead. For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.ConditionalOperator.html">ConditionalOperator</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>', 'QueryInput$ConditionalOperator' => '<p>This is a legacy parameter. Use <code>FilterExpression</code> instead. For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.ConditionalOperator.html">ConditionalOperator</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>', 'ScanInput$ConditionalOperator' => '<p>This is a legacy parameter. Use <code>FilterExpression</code> instead. For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.ConditionalOperator.html">ConditionalOperator</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>', 'UpdateItemInput$ConditionalOperator' => '<p>This is a legacy parameter. Use <code>ConditionExpression</code> instead. For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.ConditionalOperator.html">ConditionalOperator</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>', ], ], 'ConsistentRead' => [ 'base' => NULL, 'refs' => [ 'BatchStatementRequest$ConsistentRead' => '<p> The read consistency of the PartiQL batch request. </p>', 'ExecuteStatementInput$ConsistentRead' => '<p>The consistency of a read operation. If set to <code>true</code>, then a strongly consistent read is used; otherwise, an eventually consistent read is used.</p>', 'GetItemInput$ConsistentRead' => '<p>Determines the read consistency model: If set to <code>true</code>, then the operation uses strongly consistent reads; otherwise, the operation uses eventually consistent reads.</p>', 'KeysAndAttributes$ConsistentRead' => '<p>The consistency of a read operation. If set to <code>true</code>, then a strongly consistent read is used; otherwise, an eventually consistent read is used.</p>', 'QueryInput$ConsistentRead' => '<p>Determines the read consistency model: If set to <code>true</code>, then the operation uses strongly consistent reads; otherwise, the operation uses eventually consistent reads.</p> <p>Strongly consistent reads are not supported on global secondary indexes. If you query a global secondary index with <code>ConsistentRead</code> set to <code>true</code>, you will receive a <code>ValidationException</code>.</p>', 'ScanInput$ConsistentRead' => '<p>A Boolean value that determines the read consistency model during the scan:</p> <ul> <li> <p>If <code>ConsistentRead</code> is <code>false</code>, then the data returned from <code>Scan</code> might not contain the results from other recently completed write operations (<code>PutItem</code>, <code>UpdateItem</code>, or <code>DeleteItem</code>).</p> </li> <li> <p>If <code>ConsistentRead</code> is <code>true</code>, then all of the write operations that completed before the <code>Scan</code> began are guaranteed to be contained in the <code>Scan</code> response.</p> </li> </ul> <p>The default setting for <code>ConsistentRead</code> is <code>false</code>.</p> <p>The <code>ConsistentRead</code> parameter is not supported on global secondary indexes. If you scan a global secondary index with <code>ConsistentRead</code> set to true, you will receive a <code>ValidationException</code>.</p>', ], ], 'ConsumedCapacity' => [ 'base' => '<p>The capacity units consumed by an operation. The data returned includes the total provisioned throughput consumed, along with statistics for the table and any indexes involved in the operation. <code>ConsumedCapacity</code> is only returned if the request asked for it. For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ProvisionedThroughputIntro.html">Provisioned Throughput</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>', 'refs' => [ 'ConsumedCapacityMultiple$member' => NULL, 'DeleteItemOutput$ConsumedCapacity' => '<p>The capacity units consumed by the <code>DeleteItem</code> operation. The data returned includes the total provisioned throughput consumed, along with statistics for the table and any indexes involved in the operation. <code>ConsumedCapacity</code> is only returned if the <code>ReturnConsumedCapacity</code> parameter was specified. For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ProvisionedThroughputIntro.html">Provisioned Mode</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>', 'ExecuteStatementOutput$ConsumedCapacity' => NULL, 'GetItemOutput$ConsumedCapacity' => '<p>The capacity units consumed by the <code>GetItem</code> operation. The data returned includes the total provisioned throughput consumed, along with statistics for the table and any indexes involved in the operation. <code>ConsumedCapacity</code> is only returned if the <code>ReturnConsumedCapacity</code> parameter was specified. For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ProvisionedThroughputIntro.html">Read/Write Capacity Mode</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>', 'PutItemOutput$ConsumedCapacity' => '<p>The capacity units consumed by the <code>PutItem</code> operation. The data returned includes the total provisioned throughput consumed, along with statistics for the table and any indexes involved in the operation. <code>ConsumedCapacity</code> is only returned if the <code>ReturnConsumedCapacity</code> parameter was specified. For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ProvisionedThroughputIntro.html">Read/Write Capacity Mode</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>', 'QueryOutput$ConsumedCapacity' => '<p>The capacity units consumed by the <code>Query</code> operation. The data returned includes the total provisioned throughput consumed, along with statistics for the table and any indexes involved in the operation. <code>ConsumedCapacity</code> is only returned if the <code>ReturnConsumedCapacity</code> parameter was specified. For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ProvisionedThroughputIntro.html">Provisioned Throughput</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>', 'ScanOutput$ConsumedCapacity' => '<p>The capacity units consumed by the <code>Scan</code> operation. The data returned includes the total provisioned throughput consumed, along with statistics for the table and any indexes involved in the operation. <code>ConsumedCapacity</code> is only returned if the <code>ReturnConsumedCapacity</code> parameter was specified. For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ProvisionedThroughputIntro.html">Provisioned Throughput</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>', 'UpdateItemOutput$ConsumedCapacity' => '<p>The capacity units consumed by the <code>UpdateItem</code> operation. The data returned includes the total provisioned throughput consumed, along with statistics for the table and any indexes involved in the operation. <code>ConsumedCapacity</code> is only returned if the <code>ReturnConsumedCapacity</code> parameter was specified. For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ProvisionedThroughputIntro.html">Provisioned Throughput</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>', ], ], 'ConsumedCapacityMultiple' => [ 'base' => NULL, 'refs' => [ 'BatchExecuteStatementOutput$ConsumedCapacity' => '<p>The capacity units consumed by the entire operation. The values of the list are ordered according to the ordering of the statements.</p>', 'BatchGetItemOutput$ConsumedCapacity' => '<p>The read capacity units consumed by the entire <code>BatchGetItem</code> operation.</p> <p>Each element consists of:</p> <ul> <li> <p> <code>TableName</code> - The table that consumed the provisioned throughput.</p> </li> <li> <p> <code>CapacityUnits</code> - The total number of capacity units consumed.</p> </li> </ul>', 'BatchWriteItemOutput$ConsumedCapacity' => '<p>The capacity units consumed by the entire <code>BatchWriteItem</code> operation.</p> <p>Each element consists of:</p> <ul> <li> <p> <code>TableName</code> - The table that consumed the provisioned throughput.</p> </li> <li> <p> <code>CapacityUnits</code> - The total number of capacity units consumed.</p> </li> </ul>', 'ExecuteTransactionOutput$ConsumedCapacity' => '<p>The capacity units consumed by the entire operation. The values of the list are ordered according to the ordering of the statements.</p>', 'TransactGetItemsOutput$ConsumedCapacity' => '<p>If the <i>ReturnConsumedCapacity</i> value was <code>TOTAL</code>, this is an array of <code>ConsumedCapacity</code> objects, one for each table addressed by <code>TransactGetItem</code> objects in the <i>TransactItems</i> parameter. These <code>ConsumedCapacity</code> objects report the read-capacity units consumed by the <code>TransactGetItems</code> call in that table.</p>', 'TransactWriteItemsOutput$ConsumedCapacity' => '<p>The capacity units consumed by the entire <code>TransactWriteItems</code> operation. The values of the list are ordered according to the ordering of the <code>TransactItems</code> request parameter. </p>', ], ], 'ConsumedCapacityUnits' => [ 'base' => NULL, 'refs' => [ 'Capacity$ReadCapacityUnits' => '<p>The total number of read capacity units consumed on a table or an index.</p>', 'Capacity$WriteCapacityUnits' => '<p>The total number of write capacity units consumed on a table or an index.</p>', 'Capacity$CapacityUnits' => '<p>The total number of capacity units consumed on a table or an index.</p>', 'ConsumedCapacity$CapacityUnits' => '<p>The total number of capacity units consumed by the operation.</p>', 'ConsumedCapacity$ReadCapacityUnits' => '<p>The total number of read capacity units consumed by the operation.</p>', 'ConsumedCapacity$WriteCapacityUnits' => '<p>The total number of write capacity units consumed by the operation.</p>', ], ], 'ContinuousBackupsDescription' => [ 'base' => '<p>Represents the continuous backups and point in time recovery settings on the table.</p>', 'refs' => [ 'DescribeContinuousBackupsOutput$ContinuousBackupsDescription' => '<p>Represents the continuous backups and point in time recovery settings on the table.</p>', 'UpdateContinuousBackupsOutput$ContinuousBackupsDescription' => '<p>Represents the continuous backups and point in time recovery settings on the table.</p>', ], ], 'ContinuousBackupsStatus' => [ 'base' => NULL, 'refs' => [ 'ContinuousBackupsDescription$ContinuousBackupsStatus' => '<p> <code>ContinuousBackupsStatus</code> can be one of the following states: ENABLED, DISABLED</p>', ], ], 'ContinuousBackupsUnavailableException' => [ 'base' => '<p>Backups have not yet been enabled for this table.</p>', 'refs' => [], ], 'ContributorInsightsAction' => [ 'base' => NULL, 'refs' => [ 'UpdateContributorInsightsInput$ContributorInsightsAction' => '<p>Represents the contributor insights action.</p>', ], ], 'ContributorInsightsRule' => [ 'base' => NULL, 'refs' => [ 'ContributorInsightsRuleList$member' => NULL, ], ], 'ContributorInsightsRuleList' => [ 'base' => NULL, 'refs' => [ 'DescribeContributorInsightsOutput$ContributorInsightsRuleList' => '<p>List of names of the associated contributor insights rules.</p>', ], ], 'ContributorInsightsStatus' => [ 'base' => NULL, 'refs' => [ 'ContributorInsightsSummary$ContributorInsightsStatus' => '<p>Describes the current status for contributor insights for the given table and index, if applicable.</p>', 'DescribeContributorInsightsOutput$ContributorInsightsStatus' => '<p>Current status of contributor insights.</p>', 'UpdateContributorInsightsOutput$ContributorInsightsStatus' => '<p>The status of contributor insights</p>', ], ], 'ContributorInsightsSummaries' => [ 'base' => NULL, 'refs' => [ 'ListContributorInsightsOutput$ContributorInsightsSummaries' => '<p>A list of ContributorInsightsSummary.</p>', ], ], 'ContributorInsightsSummary' => [ 'base' => '<p>Represents a Contributor Insights summary entry.</p>', 'refs' => [ 'ContributorInsightsSummaries$member' => NULL, ], ], 'CreateBackupInput' => [ 'base' => NULL, 'refs' => [], ], 'CreateBackupOutput' => [ 'base' => NULL, 'refs' => [], ], 'CreateGlobalSecondaryIndexAction' => [ 'base' => '<p>Represents a new global secondary index to be added to an existing table.</p>', 'refs' => [ 'GlobalSecondaryIndexUpdate$Create' => '<p>The parameters required for creating a global secondary index on an existing table:</p> <ul> <li> <p> <code>IndexName </code> </p> </li> <li> <p> <code>KeySchema </code> </p> </li> <li> <p> <code>AttributeDefinitions </code> </p> </li> <li> <p> <code>Projection </code> </p> </li> <li> <p> <code>ProvisionedThroughput </code> </p> </li> </ul>', ], ], 'CreateGlobalTableInput' => [ 'base' => NULL, 'refs' => [], ], 'CreateGlobalTableOutput' => [ 'base' => NULL, 'refs' => [], ], 'CreateReplicaAction' => [ 'base' => '<p>Represents a replica to be added.</p>', 'refs' => [ 'ReplicaUpdate$Create' => '<p>The parameters required for creating a replica on an existing global table.</p>', ], ], 'CreateReplicationGroupMemberAction' => [ 'base' => '<p>Represents a replica to be created.</p>', 'refs' => [ 'ReplicationGroupUpdate$Create' => '<p>The parameters required for creating a replica for the table.</p>', ], ], 'CreateTableInput' => [ 'base' => '<p>Represents the input of a <code>CreateTable</code> operation.</p>', 'refs' => [], ], 'CreateTableOutput' => [ 'base' => '<p>Represents the output of a <code>CreateTable</code> operation.</p>', 'refs' => [], ], 'Date' => [ 'base' => NULL, 'refs' => [ 'ArchivalSummary$ArchivalDateTime' => '<p>The date and time when table archival was initiated by DynamoDB, in UNIX epoch time format.</p>', 'BackupDetails$BackupExpiryDateTime' => '<p>Time at which the automatic on-demand backup created by DynamoDB will expire. This <code>SYSTEM</code> on-demand backup expires automatically 35 days after its creation.</p>', 'BackupSummary$BackupExpiryDateTime' => '<p>Time at which the automatic on-demand backup created by DynamoDB will expire. This <code>SYSTEM</code> on-demand backup expires automatically 35 days after its creation.</p>', 'BillingModeSummary$LastUpdateToPayPerRequestDateTime' => '<p>Represents the time when <code>PAY_PER_REQUEST</code> was last set as the read/write capacity mode.</p>', 'GlobalTableDescription$CreationDateTime' => '<p>The creation time of the global table.</p>', 'PointInTimeRecoveryDescription$EarliestRestorableDateTime' => '<p>Specifies the earliest point in time you can restore your table to. You can restore your table to any point in time during the last 35 days. </p>', 'PointInTimeRecoveryDescription$LatestRestorableDateTime' => '<p> <code>LatestRestorableDateTime</code> is typically 5 minutes before the current time. </p>', 'ProvisionedThroughputDescription$LastIncreaseDateTime' => '<p>The date and time of the last provisioned throughput increase for this table.</p>', 'ProvisionedThroughputDescription$LastDecreaseDateTime' => '<p>The date and time of the last provisioned throughput decrease for this table.</p>', 'ReplicaDescription$ReplicaInaccessibleDateTime' => '<p>The time at which the replica was first detected as inaccessible. To determine cause of inaccessibility check the <code>ReplicaStatus</code> property.</p>', 'RestoreSummary$RestoreDateTime' => '<p>Point in time or source backup time.</p>', 'RestoreTableToPointInTimeInput$RestoreDateTime' => '<p>Time in the past to restore the table to.</p>', 'SSEDescription$InaccessibleEncryptionDateTime' => '<p>Indicates the time, in UNIX epoch date format, when DynamoDB detected that the table\'s KMS key was inaccessible. This attribute will automatically be cleared when DynamoDB detects that the table\'s KMS key is accessible again. DynamoDB will initiate the table archival process when table\'s KMS key remains inaccessible for more than seven days from this date.</p>', 'TableClassSummary$LastUpdateDateTime' => '<p>The date and time at which the table class was last updated.</p>', 'TableDescription$CreationDateTime' => '<p>The date and time when the table was created, in <a href="http://www.epochconverter.com/">UNIX epoch time</a> format.</p>', ], ], 'Delete' => [ 'base' => '<p>Represents a request to perform a <code>DeleteItem</code> operation.</p>', 'refs' => [ 'TransactWriteItem$Delete' => '<p>A request to perform a <code>DeleteItem</code> operation.</p>', ], ], 'DeleteBackupInput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteBackupOutput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteGlobalSecondaryIndexAction' => [ 'base' => '<p>Represents a global secondary index to be deleted from an existing table.</p>', 'refs' => [ 'GlobalSecondaryIndexUpdate$Delete' => '<p>The name of an existing global secondary index to be removed.</p>', ], ], 'DeleteItemInput' => [ 'base' => '<p>Represents the input of a <code>DeleteItem</code> operation.</p>', 'refs' => [], ], 'DeleteItemOutput' => [ 'base' => '<p>Represents the output of a <code>DeleteItem</code> operation.</p>', 'refs' => [], ], 'DeleteReplicaAction' => [ 'base' => '<p>Represents a replica to be removed.</p>', 'refs' => [ 'ReplicaUpdate$Delete' => '<p>The name of the existing replica to be removed.</p>', ], ], 'DeleteReplicationGroupMemberAction' => [ 'base' => '<p>Represents a replica to be deleted.</p>', 'refs' => [ 'ReplicationGroupUpdate$Delete' => '<p>The parameters required for deleting a replica for the table.</p>', ], ], 'DeleteRequest' => [ 'base' => '<p>Represents a request to perform a <code>DeleteItem</code> operation on an item.</p>', 'refs' => [ 'WriteRequest$DeleteRequest' => '<p>A request to perform a <code>DeleteItem</code> operation.</p>', ], ], 'DeleteTableInput' => [ 'base' => '<p>Represents the input of a <code>DeleteTable</code> operation.</p>', 'refs' => [], ], 'DeleteTableOutput' => [ 'base' => '<p>Represents the output of a <code>DeleteTable</code> operation.</p>', 'refs' => [], ], 'DescribeBackupInput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeBackupOutput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeContinuousBackupsInput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeContinuousBackupsOutput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeContributorInsightsInput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeContributorInsightsOutput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeEndpointsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeEndpointsResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeExportInput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeExportOutput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeGlobalTableInput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeGlobalTableOutput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeGlobalTableSettingsInput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeGlobalTableSettingsOutput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeKinesisStreamingDestinationInput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeKinesisStreamingDestinationOutput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeLimitsInput' => [ 'base' => '<p>Represents the input of a <code>DescribeLimits</code> operation. Has no content.</p>', 'refs' => [], ], 'DescribeLimitsOutput' => [ 'base' => '<p>Represents the output of a <code>DescribeLimits</code> operation.</p>', 'refs' => [], ], 'DescribeTableInput' => [ 'base' => '<p>Represents the input of a <code>DescribeTable</code> operation.</p>', 'refs' => [], ], 'DescribeTableOutput' => [ 'base' => '<p>Represents the output of a <code>DescribeTable</code> operation.</p>', 'refs' => [], ], 'DescribeTableReplicaAutoScalingInput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeTableReplicaAutoScalingOutput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeTimeToLiveInput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeTimeToLiveOutput' => [ 'base' => NULL, 'refs' => [], ], 'DestinationStatus' => [ 'base' => NULL, 'refs' => [ 'KinesisDataStreamDestination$DestinationStatus' => '<p>The current status of replication.</p>', 'KinesisStreamingDestinationOutput$DestinationStatus' => '<p>The current status of the replication.</p>', ], ], 'Double' => [ 'base' => NULL, 'refs' => [ 'AutoScalingTargetTrackingScalingPolicyConfigurationDescription$TargetValue' => '<p>The target value for the metric. The range is 8.515920e-109 to 1.174271e+108 (Base 10) or 2e-360 to 2e360 (Base 2).</p>', 'AutoScalingTargetTrackingScalingPolicyConfigurationUpdate$TargetValue' => '<p>The target value for the metric. The range is 8.515920e-109 to 1.174271e+108 (Base 10) or 2e-360 to 2e360 (Base 2).</p>', ], ], 'DuplicateItemException' => [ 'base' => '<p> There was an attempt to insert an item with the same primary key as an item that already exists in the DynamoDB table.</p>', 'refs' => [], ], 'Endpoint' => [ 'base' => '<p>An endpoint information details.</p>', 'refs' => [ 'Endpoints$member' => NULL, ], ], 'Endpoints' => [ 'base' => NULL, 'refs' => [ 'DescribeEndpointsResponse$Endpoints' => '<p>List of endpoints.</p>', ], ], 'ErrorMessage' => [ 'base' => NULL, 'refs' => [ 'BackupInUseException$message' => NULL, 'BackupNotFoundException$message' => NULL, 'CancellationReason$Message' => '<p>Cancellation reason message description.</p>', 'ConditionalCheckFailedException$message' => '<p>The conditional request failed.</p>', 'ContinuousBackupsUnavailableException$message' => NULL, 'DuplicateItemException$message' => NULL, 'ExportConflictException$message' => NULL, 'ExportNotFoundException$message' => NULL, 'GlobalTableAlreadyExistsException$message' => NULL, 'GlobalTableNotFoundException$message' => NULL, 'IdempotentParameterMismatchException$Message' => NULL, 'IndexNotFoundException$message' => NULL, 'InternalServerError$message' => '<p>The server encountered an internal error trying to fulfill the request.</p>', 'InvalidExportTimeException$message' => NULL, 'InvalidRestoreTimeException$message' => NULL, 'ItemCollectionSizeLimitExceededException$message' => '<p>The total size of an item collection has exceeded the maximum limit of 10 gigabytes.</p>', 'LimitExceededException$message' => '<p>Too many operations for a given subscriber.</p>', 'PointInTimeRecoveryUnavailableException$message' => NULL, 'ProvisionedThroughputExceededException$message' => '<p>You exceeded your maximum allowed provisioned throughput.</p>', 'ReplicaAlreadyExistsException$message' => NULL, 'ReplicaNotFoundException$message' => NULL, 'RequestLimitExceeded$message' => NULL, 'ResourceInUseException$message' => '<p>The resource which is being attempted to be changed is in use.</p>', 'ResourceNotFoundException$message' => '<p>The resource which is being requested does not exist.</p>', 'TableAlreadyExistsException$message' => NULL, 'TableInUseException$message' => NULL, 'TableNotFoundException$message' => NULL, 'TransactionCanceledException$Message' => NULL, 'TransactionConflictException$message' => NULL, 'TransactionInProgressException$Message' => NULL, ], ], 'ExceptionDescription' => [ 'base' => NULL, 'refs' => [ 'FailureException$ExceptionDescription' => '<p>Description of the failure.</p>', ], ], 'ExceptionName' => [ 'base' => NULL, 'refs' => [ 'FailureException$ExceptionName' => '<p>Exception name.</p>', ], ], 'ExecuteStatementInput' => [ 'base' => NULL, 'refs' => [], ], 'ExecuteStatementOutput' => [ 'base' => NULL, 'refs' => [], ], 'ExecuteTransactionInput' => [ 'base' => NULL, 'refs' => [], ], 'ExecuteTransactionOutput' => [ 'base' => NULL, 'refs' => [], ], 'ExpectedAttributeMap' => [ 'base' => NULL, 'refs' => [ 'DeleteItemInput$Expected' => '<p>This is a legacy parameter. Use <code>ConditionExpression</code> instead. For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.Expected.html">Expected</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>', 'PutItemInput$Expected' => '<p>This is a legacy parameter. Use <code>ConditionExpression</code> instead. For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.Expected.html">Expected</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>', 'UpdateItemInput$Expected' => '<p>This is a legacy parameter. Use <code>ConditionExpression</code> instead. For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.Expected.html">Expected</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>', ], ], 'ExpectedAttributeValue' => [ 'base' => '<p>Represents a condition to be compared with an attribute value. This condition can be used with <code>DeleteItem</code>, <code>PutItem</code>, or <code>UpdateItem</code> operations; if the comparison evaluates to true, the operation succeeds; if not, the operation fails. You can use <code>ExpectedAttributeValue</code> in one of two different ways:</p> <ul> <li> <p>Use <code>AttributeValueList</code> to specify one or more values to compare against an attribute. Use <code>ComparisonOperator</code> to specify how you want to perform the comparison. If the comparison evaluates to true, then the conditional operation succeeds.</p> </li> <li> <p>Use <code>Value</code> to specify a value that DynamoDB will compare against an attribute. If the values match, then <code>ExpectedAttributeValue</code> evaluates to true and the conditional operation succeeds. Optionally, you can also set <code>Exists</code> to false, indicating that you <i>do not</i> expect to find the attribute value in the table. In this case, the conditional operation succeeds only if the comparison evaluates to false.</p> </li> </ul> <p> <code>Value</code> and <code>Exists</code> are incompatible with <code>AttributeValueList</code> and <code>ComparisonOperator</code>. Note that if you use both sets of parameters at once, DynamoDB will return a <code>ValidationException</code> exception.</p>', 'refs' => [ 'ExpectedAttributeMap$value' => NULL, ], ], 'ExportArn' => [ 'base' => NULL, 'refs' => [ 'DescribeExportInput$ExportArn' => '<p>The Amazon Resource Name (ARN) associated with the export.</p>', 'ExportDescription$ExportArn' => '<p>The Amazon Resource Name (ARN) of the table export.</p>', 'ExportSummary$ExportArn' => '<p>The Amazon Resource Name (ARN) of the export.</p>', ], ], 'ExportConflictException' => [ 'base' => '<p>There was a conflict when writing to the specified S3 bucket.</p>', 'refs' => [], ], 'ExportDescription' => [ 'base' => '<p>Represents the properties of the exported table.</p>', 'refs' => [ 'DescribeExportOutput$ExportDescription' => '<p>Represents the properties of the export.</p>', 'ExportTableToPointInTimeOutput$ExportDescription' => '<p>Contains a description of the table export.</p>', ], ], 'ExportEndTime' => [ 'base' => NULL, 'refs' => [ 'ExportDescription$EndTime' => '<p>The time at which the export task completed.</p>', ], ], 'ExportFormat' => [ 'base' => NULL, 'refs' => [ 'ExportDescription$ExportFormat' => '<p>The format of the exported data. Valid values for <code>ExportFormat</code> are <code>DYNAMODB_JSON</code> or <code>ION</code>.</p>', 'ExportTableToPointInTimeInput$ExportFormat' => '<p>The format for the exported data. Valid values for <code>ExportFormat</code> are <code>DYNAMODB_JSON</code> or <code>ION</code>.</p>', ], ], 'ExportManifest' => [ 'base' => NULL, 'refs' => [ 'ExportDescription$ExportManifest' => '<p>The name of the manifest file for the export task.</p>', ], ], 'ExportNextToken' => [ 'base' => NULL, 'refs' => [ 'ListExportsInput$NextToken' => '<p>An optional string that, if supplied, must be copied from the output of a previous call to <code>ListExports</code>. When provided in this manner, the API fetches the next page of results.</p>', 'ListExportsOutput$NextToken' => '<p>If this value is returned, there are additional results to be displayed. To retrieve them, call <code>ListExports</code> again, with <code>NextToken</code> set to this value.</p>', ], ], 'ExportNotFoundException' => [ 'base' => '<p>The specified export was not found.</p>', 'refs' => [], ], 'ExportStartTime' => [ 'base' => NULL, 'refs' => [ 'ExportDescription$StartTime' => '<p>The time at which the export task began.</p>', ], ], 'ExportStatus' => [ 'base' => NULL, 'refs' => [ 'ExportDescription$ExportStatus' => '<p>Export can be in one of the following states: IN_PROGRESS, COMPLETED, or FAILED.</p>', 'ExportSummary$ExportStatus' => '<p>Export can be in one of the following states: IN_PROGRESS, COMPLETED, or FAILED.</p>', ], ], 'ExportSummaries' => [ 'base' => NULL, 'refs' => [ 'ListExportsOutput$ExportSummaries' => '<p>A list of <code>ExportSummary</code> objects.</p>', ], ], 'ExportSummary' => [ 'base' => '<p>Summary information about an export task.</p>', 'refs' => [ 'ExportSummaries$member' => NULL, ], ], 'ExportTableToPointInTimeInput' => [ 'base' => NULL, 'refs' => [], ], 'ExportTableToPointInTimeOutput' => [ 'base' => NULL, 'refs' => [], ], 'ExportTime' => [ 'base' => NULL, 'refs' => [ 'ExportDescription$ExportTime' => '<p>Point in time from which table data was exported.</p>', 'ExportTableToPointInTimeInput$ExportTime' => '<p>Time in the past from which to export table data. The table export will be a snapshot of the table\'s state at this point in time.</p>', ], ], 'ExpressionAttributeNameMap' => [ 'base' => NULL, 'refs' => [ 'ConditionCheck$ExpressionAttributeNames' => '<p>One or more substitution tokens for attribute names in an expression.</p>', 'Delete$ExpressionAttributeNames' => '<p>One or more substitution tokens for attribute names in an expression.</p>', 'DeleteItemInput$ExpressionAttributeNames' => '<p>One or more substitution tokens for attribute names in an expression. The following are some use cases for using <code>ExpressionAttributeNames</code>:</p> <ul> <li> <p>To access an attribute whose name conflicts with a DynamoDB reserved word.</p> </li> <li> <p>To create a placeholder for repeating occurrences of an attribute name in an expression.</p> </li> <li> <p>To prevent special characters in an attribute name from being misinterpreted in an expression.</p> </li> </ul> <p>Use the <b>#</b> character in an expression to dereference an attribute name. For example, consider the following attribute name:</p> <ul> <li> <p> <code>Percentile</code> </p> </li> </ul> <p>The name of this attribute conflicts with a reserved word, so it cannot be used directly in an expression. (For the complete list of reserved words, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ReservedWords.html">Reserved Words</a> in the <i>Amazon DynamoDB Developer Guide</i>). To work around this, you could specify the following for <code>ExpressionAttributeNames</code>:</p> <ul> <li> <p> <code>{"#P":"Percentile"}</code> </p> </li> </ul> <p>You could then use this substitution in an expression, as in this example:</p> <ul> <li> <p> <code>#P = :val</code> </p> </li> </ul> <note> <p>Tokens that begin with the <b>:</b> character are <i>expression attribute values</i>, which are placeholders for the actual value at runtime.</p> </note> <p>For more information on expression attribute names, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html">Specifying Item Attributes</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>', 'Get$ExpressionAttributeNames' => '<p>One or more substitution tokens for attribute names in the ProjectionExpression parameter.</p>', 'GetItemInput$ExpressionAttributeNames' => '<p>One or more substitution tokens for attribute names in an expression. The following are some use cases for using <code>ExpressionAttributeNames</code>:</p> <ul> <li> <p>To access an attribute whose name conflicts with a DynamoDB reserved word.</p> </li> <li> <p>To create a placeholder for repeating occurrences of an attribute name in an expression.</p> </li> <li> <p>To prevent special characters in an attribute name from being misinterpreted in an expression.</p> </li> </ul> <p>Use the <b>#</b> character in an expression to dereference an attribute name. For example, consider the following attribute name:</p> <ul> <li> <p> <code>Percentile</code> </p> </li> </ul> <p>The name of this attribute conflicts with a reserved word, so it cannot be used directly in an expression. (For the complete list of reserved words, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ReservedWords.html">Reserved Words</a> in the <i>Amazon DynamoDB Developer Guide</i>). To work around this, you could specify the following for <code>ExpressionAttributeNames</code>:</p> <ul> <li> <p> <code>{"#P":"Percentile"}</code> </p> </li> </ul> <p>You could then use this substitution in an expression, as in this example:</p> <ul> <li> <p> <code>#P = :val</code> </p> </li> </ul> <note> <p>Tokens that begin with the <b>:</b> character are <i>expression attribute values</i>, which are placeholders for the actual value at runtime.</p> </note> <p>For more information on expression attribute names, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html">Specifying Item Attributes</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>', 'KeysAndAttributes$ExpressionAttributeNames' => '<p>One or more substitution tokens for attribute names in an expression. The following are some use cases for using <code>ExpressionAttributeNames</code>:</p> <ul> <li> <p>To access an attribute whose name conflicts with a DynamoDB reserved word.</p> </li> <li> <p>To create a placeholder for repeating occurrences of an attribute name in an expression.</p> </li> <li> <p>To prevent special characters in an attribute name from being misinterpreted in an expression.</p> </li> </ul> <p>Use the <b>#</b> character in an expression to dereference an attribute name. For example, consider the following attribute name:</p> <ul> <li> <p> <code>Percentile</code> </p> </li> </ul> <p>The name of this attribute conflicts with a reserved word, so it cannot be used directly in an expression. (For the complete list of reserved words, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ReservedWords.html">Reserved Words</a> in the <i>Amazon DynamoDB Developer Guide</i>). To work around this, you could specify the following for <code>ExpressionAttributeNames</code>:</p> <ul> <li> <p> <code>{"#P":"Percentile"}</code> </p> </li> </ul> <p>You could then use this substitution in an expression, as in this example:</p> <ul> <li> <p> <code>#P = :val</code> </p> </li> </ul> <note> <p>Tokens that begin with the <b>:</b> character are <i>expression attribute values</i>, which are placeholders for the actual value at runtime.</p> </note> <p>For more information on expression attribute names, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html">Accessing Item Attributes</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>', 'Put$ExpressionAttributeNames' => '<p>One or more substitution tokens for attribute names in an expression.</p>', 'PutItemInput$ExpressionAttributeNames' => '<p>One or more substitution tokens for attribute names in an expression. The following are some use cases for using <code>ExpressionAttributeNames</code>:</p> <ul> <li> <p>To access an attribute whose name conflicts with a DynamoDB reserved word.</p> </li> <li> <p>To create a placeholder for repeating occurrences of an attribute name in an expression.</p> </li> <li> <p>To prevent special characters in an attribute name from being misinterpreted in an expression.</p> </li> </ul> <p>Use the <b>#</b> character in an expression to dereference an attribute name. For example, consider the following attribute name:</p> <ul> <li> <p> <code>Percentile</code> </p> </li> </ul> <p>The name of this attribute conflicts with a reserved word, so it cannot be used directly in an expression. (For the complete list of reserved words, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ReservedWords.html">Reserved Words</a> in the <i>Amazon DynamoDB Developer Guide</i>). To work around this, you could specify the following for <code>ExpressionAttributeNames</code>:</p> <ul> <li> <p> <code>{"#P":"Percentile"}</code> </p> </li> </ul> <p>You could then use this substitution in an expression, as in this example:</p> <ul> <li> <p> <code>#P = :val</code> </p> </li> </ul> <note> <p>Tokens that begin with the <b>:</b> character are <i>expression attribute values</i>, which are placeholders for the actual value at runtime.</p> </note> <p>For more information on expression attribute names, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html">Specifying Item Attributes</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>', 'QueryInput$ExpressionAttributeNames' => '<p>One or more substitution tokens for attribute names in an expression. The following are some use cases for using <code>ExpressionAttributeNames</code>:</p> <ul> <li> <p>To access an attribute whose name conflicts with a DynamoDB reserved word.</p> </li> <li> <p>To create a placeholder for repeating occurrences of an attribute name in an expression.</p> </li> <li> <p>To prevent special characters in an attribute name from being misinterpreted in an expression.</p> </li> </ul> <p>Use the <b>#</b> character in an expression to dereference an attribute name. For example, consider the following attribute name:</p> <ul> <li> <p> <code>Percentile</code> </p> </li> </ul> <p>The name of this attribute conflicts with a reserved word, so it cannot be used directly in an expression. (For the complete list of reserved words, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ReservedWords.html">Reserved Words</a> in the <i>Amazon DynamoDB Developer Guide</i>). To work around this, you could specify the following for <code>ExpressionAttributeNames</code>:</p> <ul> <li> <p> <code>{"#P":"Percentile"}</code> </p> </li> </ul> <p>You could then use this substitution in an expression, as in this example:</p> <ul> <li> <p> <code>#P = :val</code> </p> </li> </ul> <note> <p>Tokens that begin with the <b>:</b> character are <i>expression attribute values</i>, which are placeholders for the actual value at runtime.</p> </note> <p>For more information on expression attribute names, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html">Specifying Item Attributes</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>', 'ScanInput$ExpressionAttributeNames' => '<p>One or more substitution tokens for attribute names in an expression. The following are some use cases for using <code>ExpressionAttributeNames</code>:</p> <ul> <li> <p>To access an attribute whose name conflicts with a DynamoDB reserved word.</p> </li> <li> <p>To create a placeholder for repeating occurrences of an attribute name in an expression.</p> </li> <li> <p>To prevent special characters in an attribute name from being misinterpreted in an expression.</p> </li> </ul> <p>Use the <b>#</b> character in an expression to dereference an attribute name. For example, consider the following attribute name:</p> <ul> <li> <p> <code>Percentile</code> </p> </li> </ul> <p>The name of this attribute conflicts with a reserved word, so it cannot be used directly in an expression. (For the complete list of reserved words, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ReservedWords.html">Reserved Words</a> in the <i>Amazon DynamoDB Developer Guide</i>). To work around this, you could specify the following for <code>ExpressionAttributeNames</code>:</p> <ul> <li> <p> <code>{"#P":"Percentile"}</code> </p> </li> </ul> <p>You could then use this substitution in an expression, as in this example:</p> <ul> <li> <p> <code>#P = :val</code> </p> </li> </ul> <note> <p>Tokens that begin with the <b>:</b> character are <i>expression attribute values</i>, which are placeholders for the actual value at runtime.</p> </note> <p>For more information on expression attribute names, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html">Specifying Item Attributes</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>', 'Update$ExpressionAttributeNames' => '<p>One or more substitution tokens for attribute names in an expression.</p>', 'UpdateItemInput$ExpressionAttributeNames' => '<p>One or more substitution tokens for attribute names in an expression. The following are some use cases for using <code>ExpressionAttributeNames</code>:</p> <ul> <li> <p>To access an attribute whose name conflicts with a DynamoDB reserved word.</p> </li> <li> <p>To create a placeholder for repeating occurrences of an attribute name in an expression.</p> </li> <li> <p>To prevent special characters in an attribute name from being misinterpreted in an expression.</p> </li> </ul> <p>Use the <b>#</b> character in an expression to dereference an attribute name. For example, consider the following attribute name:</p> <ul> <li> <p> <code>Percentile</code> </p> </li> </ul> <p>The name of this attribute conflicts with a reserved word, so it cannot be used directly in an expression. (For the complete list of reserved words, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ReservedWords.html">Reserved Words</a> in the <i>Amazon DynamoDB Developer Guide</i>.) To work around this, you could specify the following for <code>ExpressionAttributeNames</code>:</p> <ul> <li> <p> <code>{"#P":"Percentile"}</code> </p> </li> </ul> <p>You could then use this substitution in an expression, as in this example:</p> <ul> <li> <p> <code>#P = :val</code> </p> </li> </ul> <note> <p>Tokens that begin with the <b>:</b> character are <i>expression attribute values</i>, which are placeholders for the actual value at runtime.</p> </note> <p>For more information about expression attribute names, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html">Specifying Item Attributes</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>', ], ], 'ExpressionAttributeNameVariable' => [ 'base' => NULL, 'refs' => [ 'ExpressionAttributeNameMap$key' => NULL, ], ], 'ExpressionAttributeValueMap' => [ 'base' => NULL, 'refs' => [ 'ConditionCheck$ExpressionAttributeValues' => '<p>One or more values that can be substituted in an expression.</p>', 'Delete$ExpressionAttributeValues' => '<p>One or more values that can be substituted in an expression.</p>', 'DeleteItemInput$ExpressionAttributeValues' => '<p>One or more values that can be substituted in an expression.</p> <p>Use the <b>:</b> (colon) character in an expression to dereference an attribute value. For example, suppose that you wanted to check whether the value of the <i>ProductStatus</i> attribute was one of the following: </p> <p> <code>Available | Backordered | Discontinued</code> </p> <p>You would first need to specify <code>ExpressionAttributeValues</code> as follows:</p> <p> <code>{ ":avail":{"S":"Available"}, ":back":{"S":"Backordered"}, ":disc":{"S":"Discontinued"} }</code> </p> <p>You could then use these values in an expression, such as this:</p> <p> <code>ProductStatus IN (:avail, :back, :disc)</code> </p> <p>For more information on expression attribute values, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.SpecifyingConditions.html">Condition Expressions</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>', 'Put$ExpressionAttributeValues' => '<p>One or more values that can be substituted in an expression.</p>', 'PutItemInput$ExpressionAttributeValues' => '<p>One or more values that can be substituted in an expression.</p> <p>Use the <b>:</b> (colon) character in an expression to dereference an attribute value. For example, suppose that you wanted to check whether the value of the <i>ProductStatus</i> attribute was one of the following: </p> <p> <code>Available | Backordered | Discontinued</code> </p> <p>You would first need to specify <code>ExpressionAttributeValues</code> as follows:</p> <p> <code>{ ":avail":{"S":"Available"}, ":back":{"S":"Backordered"}, ":disc":{"S":"Discontinued"} }</code> </p> <p>You could then use these values in an expression, such as this:</p> <p> <code>ProductStatus IN (:avail, :back, :disc)</code> </p> <p>For more information on expression attribute values, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.SpecifyingConditions.html">Condition Expressions</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>', 'QueryInput$ExpressionAttributeValues' => '<p>One or more values that can be substituted in an expression.</p> <p>Use the <b>:</b> (colon) character in an expression to dereference an attribute value. For example, suppose that you wanted to check whether the value of the <i>ProductStatus</i> attribute was one of the following: </p> <p> <code>Available | Backordered | Discontinued</code> </p> <p>You would first need to specify <code>ExpressionAttributeValues</code> as follows:</p> <p> <code>{ ":avail":{"S":"Available"}, ":back":{"S":"Backordered"}, ":disc":{"S":"Discontinued"} }</code> </p> <p>You could then use these values in an expression, such as this:</p> <p> <code>ProductStatus IN (:avail, :back, :disc)</code> </p> <p>For more information on expression attribute values, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.SpecifyingConditions.html">Specifying Conditions</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>', 'ScanInput$ExpressionAttributeValues' => '<p>One or more values that can be substituted in an expression.</p> <p>Use the <b>:</b> (colon) character in an expression to dereference an attribute value. For example, suppose that you wanted to check whether the value of the <code>ProductStatus</code> attribute was one of the following: </p> <p> <code>Available | Backordered | Discontinued</code> </p> <p>You would first need to specify <code>ExpressionAttributeValues</code> as follows:</p> <p> <code>{ ":avail":{"S":"Available"}, ":back":{"S":"Backordered"}, ":disc":{"S":"Discontinued"} }</code> </p> <p>You could then use these values in an expression, such as this:</p> <p> <code>ProductStatus IN (:avail, :back, :disc)</code> </p> <p>For more information on expression attribute values, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.SpecifyingConditions.html">Condition Expressions</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>', 'Update$ExpressionAttributeValues' => '<p>One or more values that can be substituted in an expression.</p>', 'UpdateItemInput$ExpressionAttributeValues' => '<p>One or more values that can be substituted in an expression.</p> <p>Use the <b>:</b> (colon) character in an expression to dereference an attribute value. For example, suppose that you wanted to check whether the value of the <code>ProductStatus</code> attribute was one of the following: </p> <p> <code>Available | Backordered | Discontinued</code> </p> <p>You would first need to specify <code>ExpressionAttributeValues</code> as follows:</p> <p> <code>{ ":avail":{"S":"Available"}, ":back":{"S":"Backordered"}, ":disc":{"S":"Discontinued"} }</code> </p> <p>You could then use these values in an expression, such as this:</p> <p> <code>ProductStatus IN (:avail, :back, :disc)</code> </p> <p>For more information on expression attribute values, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.SpecifyingConditions.html">Condition Expressions</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>', ], ], 'ExpressionAttributeValueVariable' => [ 'base' => NULL, 'refs' => [ 'ExpressionAttributeValueMap$key' => NULL, ], ], 'FailureCode' => [ 'base' => NULL, 'refs' => [ 'ExportDescription$FailureCode' => '<p>Status code for the result of the failed export.</p>', ], ], 'FailureException' => [ 'base' => '<p>Represents a failure a contributor insights operation.</p>', 'refs' => [ 'DescribeContributorInsightsOutput$FailureException' => '<p>Returns information about the last failure that was encountered.</p> <p>The most common exceptions for a FAILED status are:</p> <ul> <li> <p>LimitExceededException - Per-account Amazon CloudWatch Contributor Insights rule limit reached. Please disable Contributor Insights for other tables/indexes OR disable Contributor Insights rules before retrying.</p> </li> <li> <p>AccessDeniedException - Amazon CloudWatch Contributor Insights rules cannot be modified due to insufficient permissions.</p> </li> <li> <p>AccessDeniedException - Failed to create service-linked role for Contributor Insights due to insufficient permissions.</p> </li> <li> <p>InternalServerError - Failed to create Amazon CloudWatch Contributor Insights rules. Please retry request.</p> </li> </ul>', ], ], 'FailureMessage' => [ 'base' => NULL, 'refs' => [ 'ExportDescription$FailureMessage' => '<p>Export failure reason description.</p>', ], ], 'FilterConditionMap' => [ 'base' => NULL, 'refs' => [ 'QueryInput$QueryFilter' => '<p>This is a legacy parameter. Use <code>FilterExpression</code> instead. For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.QueryFilter.html">QueryFilter</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>', 'ScanInput$ScanFilter' => '<p>This is a legacy parameter. Use <code>FilterExpression</code> instead. For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.ScanFilter.html">ScanFilter</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>', ], ], 'Get' => [ 'base' => '<p>Specifies an item and related attribute values to retrieve in a <code>TransactGetItem</code> object.</p>', 'refs' => [ 'TransactGetItem$Get' => '<p>Contains the primary key that identifies the item to get, together with the name of the table that contains the item, and optionally the specific attributes of the item to retrieve.</p>', ], ], 'GetItemInput' => [ 'base' => '<p>Represents the input of a <code>GetItem</code> operation.</p>', 'refs' => [], ], 'GetItemOutput' => [ 'base' => '<p>Represents the output of a <code>GetItem</code> operation.</p>', 'refs' => [], ], 'GlobalSecondaryIndex' => [ 'base' => '<p>Represents the properties of a global secondary index.</p>', 'refs' => [ 'GlobalSecondaryIndexList$member' => NULL, ], ], 'GlobalSecondaryIndexAutoScalingUpdate' => [ 'base' => '<p>Represents the auto scaling settings of a global secondary index for a global table that will be modified.</p>', 'refs' => [ 'GlobalSecondaryIndexAutoScalingUpdateList$member' => NULL, ], ], 'GlobalSecondaryIndexAutoScalingUpdateList' => [ 'base' => NULL, 'refs' => [ 'UpdateTableReplicaAutoScalingInput$GlobalSecondaryIndexUpdates' => '<p>Represents the auto scaling settings of the global secondary indexes of the replica to be updated.</p>', ], ], 'GlobalSecondaryIndexDescription' => [ 'base' => '<p>Represents the properties of a global secondary index.</p>', 'refs' => [ 'GlobalSecondaryIndexDescriptionList$member' => NULL, ], ], 'GlobalSecondaryIndexDescriptionList' => [ 'base' => NULL, 'refs' => [ 'TableDescription$GlobalSecondaryIndexes' => '<p>The global secondary indexes, if any, on the table. Each index is scoped to a given partition key value. Each element is composed of:</p> <ul> <li> <p> <code>Backfilling</code> - If true, then the index is currently in the backfilling phase. Backfilling occurs only when a new global secondary index is added to the table. It is the process by which DynamoDB populates the new index with data from the table. (This attribute does not appear for indexes that were created during a <code>CreateTable</code> operation.) </p> <p> You can delete an index that is being created during the <code>Backfilling</code> phase when <code>IndexStatus</code> is set to CREATING and <code>Backfilling</code> is true. You can\'t delete the index that is being created when <code>IndexStatus</code> is set to CREATING and <code>Backfilling</code> is false. (This attribute does not appear for indexes that were created during a <code>CreateTable</code> operation.)</p> </li> <li> <p> <code>IndexName</code> - The name of the global secondary index.</p> </li> <li> <p> <code>IndexSizeBytes</code> - The total size of the global secondary index, in bytes. DynamoDB updates this value approximately every six hours. Recent changes might not be reflected in this value. </p> </li> <li> <p> <code>IndexStatus</code> - The current status of the global secondary index:</p> <ul> <li> <p> <code>CREATING</code> - The index is being created.</p> </li> <li> <p> <code>UPDATING</code> - The index is being updated.</p> </li> <li> <p> <code>DELETING</code> - The index is being deleted.</p> </li> <li> <p> <code>ACTIVE</code> - The index is ready for use.</p> </li> </ul> </li> <li> <p> <code>ItemCount</code> - The number of items in the global secondary index. DynamoDB updates this value approximately every six hours. Recent changes might not be reflected in this value. </p> </li> <li> <p> <code>KeySchema</code> - Specifies the complete index key schema. The attribute names in the key schema must be between 1 and 255 characters (inclusive). The key schema must begin with the same partition key as the table.</p> </li> <li> <p> <code>Projection</code> - Specifies attributes that are copied (projected) from the table into the index. These are in addition to the primary key attributes and index key attributes, which are automatically projected. Each attribute specification is composed of:</p> <ul> <li> <p> <code>ProjectionType</code> - One of the following:</p> <ul> <li> <p> <code>KEYS_ONLY</code> - Only the index and primary keys are projected into the index.</p> </li> <li> <p> <code>INCLUDE</code> - In addition to the attributes described in <code>KEYS_ONLY</code>, the secondary index will include other non-key attributes that you specify.</p> </li> <li> <p> <code>ALL</code> - All of the table attributes are projected into the index.</p> </li> </ul> </li> <li> <p> <code>NonKeyAttributes</code> - A list of one or more non-key attribute names that are projected into the secondary index. The total count of attributes provided in <code>NonKeyAttributes</code>, summed across all of the secondary indexes, must not exceed 20. If you project the same attribute into two different indexes, this counts as two distinct attributes when determining the total.</p> </li> </ul> </li> <li> <p> <code>ProvisionedThroughput</code> - The provisioned throughput settings for the global secondary index, consisting of read and write capacity units, along with data about increases and decreases. </p> </li> </ul> <p>If the table is in the <code>DELETING</code> state, no information about indexes will be returned.</p>', ], ], 'GlobalSecondaryIndexInfo' => [ 'base' => '<p>Represents the properties of a global secondary index for the table when the backup was created.</p>', 'refs' => [ 'GlobalSecondaryIndexes$member' => NULL, ], ], 'GlobalSecondaryIndexList' => [ 'base' => NULL, 'refs' => [ 'CreateTableInput$GlobalSecondaryIndexes' => '<p>One or more global secondary indexes (the maximum is 20) to be created on the table. Each global secondary index in the array includes the following:</p> <ul> <li> <p> <code>IndexName</code> - The name of the global secondary index. Must be unique only for this table.</p> <p/> </li> <li> <p> <code>KeySchema</code> - Specifies the key schema for the global secondary index.</p> </li> <li> <p> <code>Projection</code> - Specifies attributes that are copied (projected) from the table into the index. These are in addition to the primary key attributes and index key attributes, which are automatically projected. Each attribute specification is composed of:</p> <ul> <li> <p> <code>ProjectionType</code> - One of the following:</p> <ul> <li> <p> <code>KEYS_ONLY</code> - Only the index and primary keys are projected into the index.</p> </li> <li> <p> <code>INCLUDE</code> - Only the specified table attributes are projected into the index. The list of projected attributes is in <code>NonKeyAttributes</code>.</p> </li> <li> <p> <code>ALL</code> - All of the table attributes are projected into the index.</p> </li> </ul> </li> <li> <p> <code>NonKeyAttributes</code> - A list of one or more non-key attribute names that are projected into the secondary index. The total count of attributes provided in <code>NonKeyAttributes</code>, summed across all of the secondary indexes, must not exceed 100. If you project the same attribute into two different indexes, this counts as two distinct attributes when determining the total.</p> </li> </ul> </li> <li> <p> <code>ProvisionedThroughput</code> - The provisioned throughput settings for the global secondary index, consisting of read and write capacity units.</p> </li> </ul>', 'RestoreTableFromBackupInput$GlobalSecondaryIndexOverride' => '<p>List of global secondary indexes for the restored table. The indexes provided should match existing secondary indexes. You can choose to exclude some or all of the indexes at the time of restore.</p>', 'RestoreTableToPointInTimeInput$GlobalSecondaryIndexOverride' => '<p>List of global secondary indexes for the restored table. The indexes provided should match existing secondary indexes. You can choose to exclude some or all of the indexes at the time of restore.</p>', ], ], 'GlobalSecondaryIndexUpdate' => [ 'base' => '<p>Represents one of the following:</p> <ul> <li> <p>A new global secondary index to be added to an existing table.</p> </li> <li> <p>New provisioned throughput parameters for an existing global secondary index.</p> </li> <li> <p>An existing global secondary index to be removed from an existing table.</p> </li> </ul>', 'refs' => [ 'GlobalSecondaryIndexUpdateList$member' => NULL, ], ], 'GlobalSecondaryIndexUpdateList' => [ 'base' => NULL, 'refs' => [ 'UpdateTableInput$GlobalSecondaryIndexUpdates' => '<p>An array of one or more global secondary indexes for the table. For each index in the array, you can request one action:</p> <ul> <li> <p> <code>Create</code> - add a new global secondary index to the table.</p> </li> <li> <p> <code>Update</code> - modify the provisioned throughput settings of an existing global secondary index.</p> </li> <li> <p> <code>Delete</code> - remove a global secondary index from the table.</p> </li> </ul> <p>You can create or delete only one global secondary index per <code>UpdateTable</code> operation.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/GSI.OnlineOps.html">Managing Global Secondary Indexes</a> in the <i>Amazon DynamoDB Developer Guide</i>. </p>', ], ], 'GlobalSecondaryIndexes' => [ 'base' => NULL, 'refs' => [ 'SourceTableFeatureDetails$GlobalSecondaryIndexes' => '<p>Represents the GSI properties for the table when the backup was created. It includes the IndexName, KeySchema, Projection, and ProvisionedThroughput for the GSIs on the table at the time of backup. </p>', ], ], 'GlobalTable' => [ 'base' => '<p>Represents the properties of a global table.</p>', 'refs' => [ 'GlobalTableList$member' => NULL, ], ], 'GlobalTableAlreadyExistsException' => [ 'base' => '<p>The specified global table already exists.</p>', 'refs' => [], ], 'GlobalTableArnString' => [ 'base' => NULL, 'refs' => [ 'GlobalTableDescription$GlobalTableArn' => '<p>The unique identifier of the global table.</p>', ], ], 'GlobalTableDescription' => [ 'base' => '<p>Contains details about the global table.</p>', 'refs' => [ 'CreateGlobalTableOutput$GlobalTableDescription' => '<p>Contains the details of the global table.</p>', 'DescribeGlobalTableOutput$GlobalTableDescription' => '<p>Contains the details of the global table.</p>', 'UpdateGlobalTableOutput$GlobalTableDescription' => '<p>Contains the details of the global table.</p>', ], ], 'GlobalTableGlobalSecondaryIndexSettingsUpdate' => [ 'base' => '<p>Represents the settings of a global secondary index for a global table that will be modified.</p>', 'refs' => [ 'GlobalTableGlobalSecondaryIndexSettingsUpdateList$member' => NULL, ], ], 'GlobalTableGlobalSecondaryIndexSettingsUpdateList' => [ 'base' => NULL, 'refs' => [ 'UpdateGlobalTableSettingsInput$GlobalTableGlobalSecondaryIndexSettingsUpdate' => '<p>Represents the settings of a global secondary index for a global table that will be modified.</p>', ], ], 'GlobalTableList' => [ 'base' => NULL, 'refs' => [ 'ListGlobalTablesOutput$GlobalTables' => '<p>List of global table names.</p>', ], ], 'GlobalTableNotFoundException' => [ 'base' => '<p>The specified global table does not exist.</p>', 'refs' => [], ], 'GlobalTableStatus' => [ 'base' => NULL, 'refs' => [ 'GlobalTableDescription$GlobalTableStatus' => '<p>The current state of the global table:</p> <ul> <li> <p> <code>CREATING</code> - The global table is being created.</p> </li> <li> <p> <code>UPDATING</code> - The global table is being updated.</p> </li> <li> <p> <code>DELETING</code> - The global table is being deleted.</p> </li> <li> <p> <code>ACTIVE</code> - The global table is ready for use.</p> </li> </ul>', ], ], 'IdempotentParameterMismatchException' => [ 'base' => '<p>DynamoDB rejected the request because you retried a request with a different payload but with an idempotent token that was already used.</p>', 'refs' => [], ], 'IndexName' => [ 'base' => NULL, 'refs' => [ 'ContributorInsightsSummary$IndexName' => '<p>Name of the index associated with the summary, if any.</p>', 'CreateGlobalSecondaryIndexAction$IndexName' => '<p>The name of the global secondary index to be created.</p>', 'DeleteGlobalSecondaryIndexAction$IndexName' => '<p>The name of the global secondary index to be deleted.</p>', 'DescribeContributorInsightsInput$IndexName' => '<p>The name of the global secondary index to describe, if applicable.</p>', 'DescribeContributorInsightsOutput$IndexName' => '<p>The name of the global secondary index being described.</p>', 'GlobalSecondaryIndex$IndexName' => '<p>The name of the global secondary index. The name must be unique among all other indexes on this table.</p>', 'GlobalSecondaryIndexAutoScalingUpdate$IndexName' => '<p>The name of the global secondary index.</p>', 'GlobalSecondaryIndexDescription$IndexName' => '<p>The name of the global secondary index.</p>', 'GlobalSecondaryIndexInfo$IndexName' => '<p>The name of the global secondary index.</p>', 'GlobalTableGlobalSecondaryIndexSettingsUpdate$IndexName' => '<p>The name of the global secondary index. The name must be unique among all other indexes on this table.</p>', 'LocalSecondaryIndex$IndexName' => '<p>The name of the local secondary index. The name must be unique among all other indexes on this table.</p>', 'LocalSecondaryIndexDescription$IndexName' => '<p>Represents the name of the local secondary index.</p>', 'LocalSecondaryIndexInfo$IndexName' => '<p>Represents the name of the local secondary index.</p>', 'QueryInput$IndexName' => '<p>The name of an index to query. This index can be any local secondary index or global secondary index on the table. Note that if you use the <code>IndexName</code> parameter, you must also provide <code>TableName.</code> </p>', 'ReplicaGlobalSecondaryIndex$IndexName' => '<p>The name of the global secondary index.</p>', 'ReplicaGlobalSecondaryIndexAutoScalingDescription$IndexName' => '<p>The name of the global secondary index.</p>', 'ReplicaGlobalSecondaryIndexAutoScalingUpdate$IndexName' => '<p>The name of the global secondary index.</p>', 'ReplicaGlobalSecondaryIndexDescription$IndexName' => '<p>The name of the global secondary index.</p>', 'ReplicaGlobalSecondaryIndexSettingsDescription$IndexName' => '<p>The name of the global secondary index. The name must be unique among all other indexes on this table.</p>', 'ReplicaGlobalSecondaryIndexSettingsUpdate$IndexName' => '<p>The name of the global secondary index. The name must be unique among all other indexes on this table.</p>', 'ScanInput$IndexName' => '<p>The name of a secondary index to scan. This index can be any local secondary index or global secondary index. Note that if you use the <code>IndexName</code> parameter, you must also provide <code>TableName</code>.</p>', 'SecondaryIndexesCapacityMap$key' => NULL, 'UpdateContributorInsightsInput$IndexName' => '<p>The global secondary index name, if applicable.</p>', 'UpdateContributorInsightsOutput$IndexName' => '<p>The name of the global secondary index, if applicable.</p>', 'UpdateGlobalSecondaryIndexAction$IndexName' => '<p>The name of the global secondary index to be updated.</p>', ], ], 'IndexNotFoundException' => [ 'base' => '<p>The operation tried to access a nonexistent index.</p>', 'refs' => [], ], 'IndexStatus' => [ 'base' => NULL, 'refs' => [ 'GlobalSecondaryIndexDescription$IndexStatus' => '<p>The current state of the global secondary index:</p> <ul> <li> <p> <code>CREATING</code> - The index is being created.</p> </li> <li> <p> <code>UPDATING</code> - The index is being updated.</p> </li> <li> <p> <code>DELETING</code> - The index is being deleted.</p> </li> <li> <p> <code>ACTIVE</code> - The index is ready for use.</p> </li> </ul>', 'ReplicaGlobalSecondaryIndexAutoScalingDescription$IndexStatus' => '<p>The current state of the replica global secondary index:</p> <ul> <li> <p> <code>CREATING</code> - The index is being created.</p> </li> <li> <p> <code>UPDATING</code> - The index is being updated.</p> </li> <li> <p> <code>DELETING</code> - The index is being deleted.</p> </li> <li> <p> <code>ACTIVE</code> - The index is ready for use.</p> </li> </ul>', 'ReplicaGlobalSecondaryIndexSettingsDescription$IndexStatus' => '<p> The current status of the global secondary index:</p> <ul> <li> <p> <code>CREATING</code> - The global secondary index is being created.</p> </li> <li> <p> <code>UPDATING</code> - The global secondary index is being updated.</p> </li> <li> <p> <code>DELETING</code> - The global secondary index is being deleted.</p> </li> <li> <p> <code>ACTIVE</code> - The global secondary index is ready for use.</p> </li> </ul>', ], ], 'Integer' => [ 'base' => NULL, 'refs' => [ 'QueryOutput$Count' => '<p>The number of items in the response.</p> <p>If you used a <code>QueryFilter</code> in the request, then <code>Count</code> is the number of items returned after the filter was applied, and <code>ScannedCount</code> is the number of matching items before the filter was applied.</p> <p>If you did not use a filter in the request, then <code>Count</code> and <code>ScannedCount</code> are the same.</p>', 'QueryOutput$ScannedCount' => '<p>The number of items evaluated, before any <code>QueryFilter</code> is applied. A high <code>ScannedCount</code> value with few, or no, <code>Count</code> results indicates an inefficient <code>Query</code> operation. For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/QueryAndScan.html#Count">Count and ScannedCount</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p> <p>If you did not use a filter in the request, then <code>ScannedCount</code> is the same as <code>Count</code>.</p>', 'ScanOutput$Count' => '<p>The number of items in the response.</p> <p>If you set <code>ScanFilter</code> in the request, then <code>Count</code> is the number of items returned after the filter was applied, and <code>ScannedCount</code> is the number of matching items before the filter was applied.</p> <p>If you did not use a filter in the request, then <code>Count</code> is the same as <code>ScannedCount</code>.</p>', 'ScanOutput$ScannedCount' => '<p>The number of items evaluated, before any <code>ScanFilter</code> is applied. A high <code>ScannedCount</code> value with few, or no, <code>Count</code> results indicates an inefficient <code>Scan</code> operation. For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/QueryAndScan.html#Count">Count and ScannedCount</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p> <p>If you did not use a filter in the request, then <code>ScannedCount</code> is the same as <code>Count</code>.</p>', ], ], 'IntegerObject' => [ 'base' => NULL, 'refs' => [ 'AutoScalingTargetTrackingScalingPolicyConfigurationDescription$ScaleInCooldown' => '<p>The amount of time, in seconds, after a scale in activity completes before another scale in activity can start. The cooldown period is used to block subsequent scale in requests until it has expired. You should scale in conservatively to protect your application\'s availability. However, if another alarm triggers a scale out policy during the cooldown period after a scale-in, application auto scaling scales out your scalable target immediately. </p>', 'AutoScalingTargetTrackingScalingPolicyConfigurationDescription$ScaleOutCooldown' => '<p>The amount of time, in seconds, after a scale out activity completes before another scale out activity can start. While the cooldown period is in effect, the capacity that has been added by the previous scale out event that initiated the cooldown is calculated as part of the desired capacity for the next scale out. You should continuously (but not excessively) scale out.</p>', 'AutoScalingTargetTrackingScalingPolicyConfigurationUpdate$ScaleInCooldown' => '<p>The amount of time, in seconds, after a scale in activity completes before another scale in activity can start. The cooldown period is used to block subsequent scale in requests until it has expired. You should scale in conservatively to protect your application\'s availability. However, if another alarm triggers a scale out policy during the cooldown period after a scale-in, application auto scaling scales out your scalable target immediately. </p>', 'AutoScalingTargetTrackingScalingPolicyConfigurationUpdate$ScaleOutCooldown' => '<p>The amount of time, in seconds, after a scale out activity completes before another scale out activity can start. While the cooldown period is in effect, the capacity that has been added by the previous scale out event that initiated the cooldown is calculated as part of the desired capacity for the next scale out. You should continuously (but not excessively) scale out.</p>', ], ], 'InternalServerError' => [ 'base' => '<p>An error occurred on the server side.</p>', 'refs' => [], ], 'InvalidExportTimeException' => [ 'base' => '<p>The specified <code>ExportTime</code> is outside of the point in time recovery window.</p>', 'refs' => [], ], 'InvalidRestoreTimeException' => [ 'base' => '<p>An invalid restore time was specified. RestoreDateTime must be between EarliestRestorableDateTime and LatestRestorableDateTime.</p>', 'refs' => [], ], 'ItemCollectionKeyAttributeMap' => [ 'base' => NULL, 'refs' => [ 'ItemCollectionMetrics$ItemCollectionKey' => '<p>The partition key value of the item collection. This value is the same as the partition key value of the item.</p>', ], ], 'ItemCollectionMetrics' => [ 'base' => '<p>Information about item collections, if any, that were affected by the operation. <code>ItemCollectionMetrics</code> is only returned if the request asked for it. If the table does not have any local secondary indexes, this information is not returned in the response.</p>', 'refs' => [ 'DeleteItemOutput$ItemCollectionMetrics' => '<p>Information about item collections, if any, that were affected by the <code>DeleteItem</code> operation. <code>ItemCollectionMetrics</code> is only returned if the <code>ReturnItemCollectionMetrics</code> parameter was specified. If the table does not have any local secondary indexes, this information is not returned in the response.</p> <p>Each <code>ItemCollectionMetrics</code> element consists of:</p> <ul> <li> <p> <code>ItemCollectionKey</code> - The partition key value of the item collection. This is the same as the partition key value of the item itself.</p> </li> <li> <p> <code>SizeEstimateRangeGB</code> - An estimate of item collection size, in gigabytes. This value is a two-element array containing a lower bound and an upper bound for the estimate. The estimate includes the size of all the items in the table, plus the size of all attributes projected into all of the local secondary indexes on that table. Use this estimate to measure whether a local secondary index is approaching its size limit.</p> <p>The estimate is subject to change over time; therefore, do not rely on the precision or accuracy of the estimate.</p> </li> </ul>', 'ItemCollectionMetricsMultiple$member' => NULL, 'PutItemOutput$ItemCollectionMetrics' => '<p>Information about item collections, if any, that were affected by the <code>PutItem</code> operation. <code>ItemCollectionMetrics</code> is only returned if the <code>ReturnItemCollectionMetrics</code> parameter was specified. If the table does not have any local secondary indexes, this information is not returned in the response.</p> <p>Each <code>ItemCollectionMetrics</code> element consists of:</p> <ul> <li> <p> <code>ItemCollectionKey</code> - The partition key value of the item collection. This is the same as the partition key value of the item itself.</p> </li> <li> <p> <code>SizeEstimateRangeGB</code> - An estimate of item collection size, in gigabytes. This value is a two-element array containing a lower bound and an upper bound for the estimate. The estimate includes the size of all the items in the table, plus the size of all attributes projected into all of the local secondary indexes on that table. Use this estimate to measure whether a local secondary index is approaching its size limit.</p> <p>The estimate is subject to change over time; therefore, do not rely on the precision or accuracy of the estimate.</p> </li> </ul>', 'UpdateItemOutput$ItemCollectionMetrics' => '<p>Information about item collections, if any, that were affected by the <code>UpdateItem</code> operation. <code>ItemCollectionMetrics</code> is only returned if the <code>ReturnItemCollectionMetrics</code> parameter was specified. If the table does not have any local secondary indexes, this information is not returned in the response.</p> <p>Each <code>ItemCollectionMetrics</code> element consists of:</p> <ul> <li> <p> <code>ItemCollectionKey</code> - The partition key value of the item collection. This is the same as the partition key value of the item itself.</p> </li> <li> <p> <code>SizeEstimateRangeGB</code> - An estimate of item collection size, in gigabytes. This value is a two-element array containing a lower bound and an upper bound for the estimate. The estimate includes the size of all the items in the table, plus the size of all attributes projected into all of the local secondary indexes on that table. Use this estimate to measure whether a local secondary index is approaching its size limit.</p> <p>The estimate is subject to change over time; therefore, do not rely on the precision or accuracy of the estimate.</p> </li> </ul>', ], ], 'ItemCollectionMetricsMultiple' => [ 'base' => NULL, 'refs' => [ 'ItemCollectionMetricsPerTable$value' => NULL, ], ], 'ItemCollectionMetricsPerTable' => [ 'base' => NULL, 'refs' => [ 'BatchWriteItemOutput$ItemCollectionMetrics' => '<p>A list of tables that were processed by <code>BatchWriteItem</code> and, for each table, information about any item collections that were affected by individual <code>DeleteItem</code> or <code>PutItem</code> operations.</p> <p>Each entry consists of the following subelements:</p> <ul> <li> <p> <code>ItemCollectionKey</code> - The partition key value of the item collection. This is the same as the partition key value of the item.</p> </li> <li> <p> <code>SizeEstimateRangeGB</code> - An estimate of item collection size, expressed in GB. This is a two-element array containing a lower bound and an upper bound for the estimate. The estimate includes the size of all the items in the table, plus the size of all attributes projected into all of the local secondary indexes on the table. Use this estimate to measure whether a local secondary index is approaching its size limit.</p> <p>The estimate is subject to change over time; therefore, do not rely on the precision or accuracy of the estimate.</p> </li> </ul>', 'TransactWriteItemsOutput$ItemCollectionMetrics' => '<p>A list of tables that were processed by <code>TransactWriteItems</code> and, for each table, information about any item collections that were affected by individual <code>UpdateItem</code>, <code>PutItem</code>, or <code>DeleteItem</code> operations. </p>', ], ], 'ItemCollectionSizeEstimateBound' => [ 'base' => NULL, 'refs' => [ 'ItemCollectionSizeEstimateRange$member' => NULL, ], ], 'ItemCollectionSizeEstimateRange' => [ 'base' => NULL, 'refs' => [ 'ItemCollectionMetrics$SizeEstimateRangeGB' => '<p>An estimate of item collection size, in gigabytes. This value is a two-element array containing a lower bound and an upper bound for the estimate. The estimate includes the size of all the items in the table, plus the size of all attributes projected into all of the local secondary indexes on that table. Use this estimate to measure whether a local secondary index is approaching its size limit.</p> <p>The estimate is subject to change over time; therefore, do not rely on the precision or accuracy of the estimate.</p>', ], ], 'ItemCollectionSizeLimitExceededException' => [ 'base' => '<p>An item collection is too large. This exception is only returned for tables that have one or more local secondary indexes.</p>', 'refs' => [], ], 'ItemCount' => [ 'base' => NULL, 'refs' => [ 'ExportDescription$ItemCount' => '<p>The number of items exported.</p>', 'SourceTableDetails$ItemCount' => '<p>Number of items in the table. Note that this is an approximate value. </p>', ], ], 'ItemList' => [ 'base' => NULL, 'refs' => [ 'BatchGetResponseMap$value' => NULL, 'ExecuteStatementOutput$Items' => '<p>If a read operation was used, this property will contain the result of the read operation; a map of attribute names and their values. For the write operations this value will be empty.</p>', 'QueryOutput$Items' => '<p>An array of item attributes that match the query criteria. Each element in this array consists of an attribute name and the value for that attribute.</p>', 'ScanOutput$Items' => '<p>An array of item attributes that match the scan criteria. Each element in this array consists of an attribute name and the value for that attribute.</p>', ], ], 'ItemResponse' => [ 'base' => '<p>Details for the requested item.</p>', 'refs' => [ 'ItemResponseList$member' => NULL, ], ], 'ItemResponseList' => [ 'base' => NULL, 'refs' => [ 'ExecuteTransactionOutput$Responses' => '<p>The response to a PartiQL transaction.</p>', 'TransactGetItemsOutput$Responses' => '<p>An ordered array of up to 25 <code>ItemResponse</code> objects, each of which corresponds to the <code>TransactGetItem</code> object in the same position in the <i>TransactItems</i> array. Each <code>ItemResponse</code> object contains a Map of the name-value pairs that are the projected attributes of the requested item.</p> <p>If a requested item could not be retrieved, the corresponding <code>ItemResponse</code> object is Null, or if the requested item has no projected attributes, the corresponding <code>ItemResponse</code> object is an empty Map. </p>', ], ], 'KMSMasterKeyArn' => [ 'base' => NULL, 'refs' => [ 'SSEDescription$KMSMasterKeyArn' => '<p>The KMS key ARN used for the KMS encryption.</p>', ], ], 'KMSMasterKeyId' => [ 'base' => NULL, 'refs' => [ 'CreateReplicationGroupMemberAction$KMSMasterKeyId' => '<p>The KMS key that should be used for KMS encryption in the new replica. To specify a key, use its key ID, Amazon Resource Name (ARN), alias name, or alias ARN. Note that you should only provide this parameter if the key is different from the default DynamoDB KMS key <code>alias/aws/dynamodb</code>.</p>', 'ReplicaDescription$KMSMasterKeyId' => '<p>The KMS key of the replica that will be used for KMS encryption.</p>', 'SSESpecification$KMSMasterKeyId' => '<p>The KMS key that should be used for the KMS encryption. To specify a key, use its key ID, Amazon Resource Name (ARN), alias name, or alias ARN. Note that you should only provide this parameter if the key is different from the default DynamoDB key <code>alias/aws/dynamodb</code>.</p>', 'UpdateReplicationGroupMemberAction$KMSMasterKeyId' => '<p>The KMS key of the replica that should be used for KMS encryption. To specify a key, use its key ID, Amazon Resource Name (ARN), alias name, or alias ARN. Note that you should only provide this parameter if the key is different from the default DynamoDB KMS key <code>alias/aws/dynamodb</code>.</p>', ], ], 'Key' => [ 'base' => NULL, 'refs' => [ 'ConditionCheck$Key' => '<p>The primary key of the item to be checked. Each element consists of an attribute name and a value for that attribute.</p>', 'Delete$Key' => '<p>The primary key of the item to be deleted. Each element consists of an attribute name and a value for that attribute.</p>', 'DeleteItemInput$Key' => '<p>A map of attribute names to <code>AttributeValue</code> objects, representing the primary key of the item to delete.</p> <p>For the primary key, you must provide all of the attributes. For example, with a simple primary key, you only need to provide a value for the partition key. For a composite primary key, you must provide values for both the partition key and the sort key.</p>', 'DeleteRequest$Key' => '<p>A map of attribute name to attribute values, representing the primary key of the item to delete. All of the table\'s primary key attributes must be specified, and their data types must match those of the table\'s key schema.</p>', 'ExecuteStatementOutput$LastEvaluatedKey' => '<p>The primary key of the item where the operation stopped, inclusive of the previous result set. Use this value to start a new operation, excluding this value in the new request. If <code>LastEvaluatedKey</code> is empty, then the "last page" of results has been processed and there is no more data to be retrieved. If <code>LastEvaluatedKey</code> is not empty, it does not necessarily mean that there is more data in the result set. The only way to know when you have reached the end of the result set is when <code>LastEvaluatedKey</code> is empty. </p>', 'Get$Key' => '<p>A map of attribute names to <code>AttributeValue</code> objects that specifies the primary key of the item to retrieve.</p>', 'GetItemInput$Key' => '<p>A map of attribute names to <code>AttributeValue</code> objects, representing the primary key of the item to retrieve.</p> <p>For the primary key, you must provide all of the attributes. For example, with a simple primary key, you only need to provide a value for the partition key. For a composite primary key, you must provide values for both the partition key and the sort key.</p>', 'KeyList$member' => NULL, 'QueryInput$ExclusiveStartKey' => '<p>The primary key of the first item that this operation will evaluate. Use the value that was returned for <code>LastEvaluatedKey</code> in the previous operation.</p> <p>The data type for <code>ExclusiveStartKey</code> must be String, Number, or Binary. No set data types are allowed.</p>', 'QueryOutput$LastEvaluatedKey' => '<p>The primary key of the item where the operation stopped, inclusive of the previous result set. Use this value to start a new operation, excluding this value in the new request.</p> <p>If <code>LastEvaluatedKey</code> is empty, then the "last page" of results has been processed and there is no more data to be retrieved.</p> <p>If <code>LastEvaluatedKey</code> is not empty, it does not necessarily mean that there is more data in the result set. The only way to know when you have reached the end of the result set is when <code>LastEvaluatedKey</code> is empty.</p>', 'ScanInput$ExclusiveStartKey' => '<p>The primary key of the first item that this operation will evaluate. Use the value that was returned for <code>LastEvaluatedKey</code> in the previous operation.</p> <p>The data type for <code>ExclusiveStartKey</code> must be String, Number or Binary. No set data types are allowed.</p> <p>In a parallel scan, a <code>Scan</code> request that includes <code>ExclusiveStartKey</code> must specify the same segment whose previous <code>Scan</code> returned the corresponding value of <code>LastEvaluatedKey</code>.</p>', 'ScanOutput$LastEvaluatedKey' => '<p>The primary key of the item where the operation stopped, inclusive of the previous result set. Use this value to start a new operation, excluding this value in the new request.</p> <p>If <code>LastEvaluatedKey</code> is empty, then the "last page" of results has been processed and there is no more data to be retrieved.</p> <p>If <code>LastEvaluatedKey</code> is not empty, it does not necessarily mean that there is more data in the result set. The only way to know when you have reached the end of the result set is when <code>LastEvaluatedKey</code> is empty.</p>', 'Update$Key' => '<p>The primary key of the item to be updated. Each element consists of an attribute name and a value for that attribute.</p>', 'UpdateItemInput$Key' => '<p>The primary key of the item to be updated. Each element consists of an attribute name and a value for that attribute.</p> <p>For the primary key, you must provide all of the attributes. For example, with a simple primary key, you only need to provide a value for the partition key. For a composite primary key, you must provide values for both the partition key and the sort key.</p>', ], ], 'KeyConditions' => [ 'base' => NULL, 'refs' => [ 'QueryInput$KeyConditions' => '<p>This is a legacy parameter. Use <code>KeyConditionExpression</code> instead. For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.KeyConditions.html">KeyConditions</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>', ], ], 'KeyExpression' => [ 'base' => NULL, 'refs' => [ 'QueryInput$KeyConditionExpression' => '<p>The condition that specifies the key values for items to be retrieved by the <code>Query</code> action.</p> <p>The condition must perform an equality test on a single partition key value.</p> <p>The condition can optionally perform one of several comparison tests on a single sort key value. This allows <code>Query</code> to retrieve one item with a given partition key value and sort key value, or several items that have the same partition key value but different sort key values.</p> <p>The partition key equality test is required, and must be specified in the following format:</p> <p> <code>partitionKeyName</code> <i>=</i> <code>:partitionkeyval</code> </p> <p>If you also want to provide a condition for the sort key, it must be combined using <code>AND</code> with the condition for the sort key. Following is an example, using the <b>=</b> comparison operator for the sort key:</p> <p> <code>partitionKeyName</code> <code>=</code> <code>:partitionkeyval</code> <code>AND</code> <code>sortKeyName</code> <code>=</code> <code>:sortkeyval</code> </p> <p>Valid comparisons for the sort key condition are as follows:</p> <ul> <li> <p> <code>sortKeyName</code> <code>=</code> <code>:sortkeyval</code> - true if the sort key value is equal to <code>:sortkeyval</code>.</p> </li> <li> <p> <code>sortKeyName</code> <code>&lt;</code> <code>:sortkeyval</code> - true if the sort key value is less than <code>:sortkeyval</code>.</p> </li> <li> <p> <code>sortKeyName</code> <code>&lt;=</code> <code>:sortkeyval</code> - true if the sort key value is less than or equal to <code>:sortkeyval</code>.</p> </li> <li> <p> <code>sortKeyName</code> <code>&gt;</code> <code>:sortkeyval</code> - true if the sort key value is greater than <code>:sortkeyval</code>.</p> </li> <li> <p> <code>sortKeyName</code> <code>&gt;= </code> <code>:sortkeyval</code> - true if the sort key value is greater than or equal to <code>:sortkeyval</code>.</p> </li> <li> <p> <code>sortKeyName</code> <code>BETWEEN</code> <code>:sortkeyval1</code> <code>AND</code> <code>:sortkeyval2</code> - true if the sort key value is greater than or equal to <code>:sortkeyval1</code>, and less than or equal to <code>:sortkeyval2</code>.</p> </li> <li> <p> <code>begins_with (</code> <code>sortKeyName</code>, <code>:sortkeyval</code> <code>)</code> - true if the sort key value begins with a particular operand. (You cannot use this function with a sort key that is of type Number.) Note that the function name <code>begins_with</code> is case-sensitive.</p> </li> </ul> <p>Use the <code>ExpressionAttributeValues</code> parameter to replace tokens such as <code>:partitionval</code> and <code>:sortval</code> with actual values at runtime.</p> <p>You can optionally use the <code>ExpressionAttributeNames</code> parameter to replace the names of the partition key and sort key with placeholder tokens. This option might be necessary if an attribute name conflicts with a DynamoDB reserved word. For example, the following <code>KeyConditionExpression</code> parameter causes an error because <i>Size</i> is a reserved word:</p> <ul> <li> <p> <code>Size = :myval</code> </p> </li> </ul> <p>To work around this, define a placeholder (such a <code>#S</code>) to represent the attribute name <i>Size</i>. <code>KeyConditionExpression</code> then is as follows:</p> <ul> <li> <p> <code>#S = :myval</code> </p> </li> </ul> <p>For a list of reserved words, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ReservedWords.html">Reserved Words</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p> <p>For more information on <code>ExpressionAttributeNames</code> and <code>ExpressionAttributeValues</code>, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ExpressionPlaceholders.html">Using Placeholders for Attribute Names and Values</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>', ], ], 'KeyList' => [ 'base' => NULL, 'refs' => [ 'KeysAndAttributes$Keys' => '<p>The primary key attribute values that define the items and the attributes associated with the items.</p>', ], ], 'KeySchema' => [ 'base' => NULL, 'refs' => [ 'CreateGlobalSecondaryIndexAction$KeySchema' => '<p>The key schema for the global secondary index.</p>', 'CreateTableInput$KeySchema' => '<p>Specifies the attributes that make up the primary key for a table or an index. The attributes in <code>KeySchema</code> must also be defined in the <code>AttributeDefinitions</code> array. For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/DataModel.html">Data Model</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p> <p>Each <code>KeySchemaElement</code> in the array is composed of:</p> <ul> <li> <p> <code>AttributeName</code> - The name of this key attribute.</p> </li> <li> <p> <code>KeyType</code> - The role that the key attribute will assume:</p> <ul> <li> <p> <code>HASH</code> - partition key</p> </li> <li> <p> <code>RANGE</code> - sort key</p> </li> </ul> </li> </ul> <note> <p>The partition key of an item is also known as its <i>hash attribute</i>. The term "hash attribute" derives from the DynamoDB usage of an internal hash function to evenly distribute data items across partitions, based on their partition key values.</p> <p>The sort key of an item is also known as its <i>range attribute</i>. The term "range attribute" derives from the way DynamoDB stores items with the same partition key physically close together, in sorted order by the sort key value.</p> </note> <p>For a simple primary key (partition key), you must provide exactly one element with a <code>KeyType</code> of <code>HASH</code>.</p> <p>For a composite primary key (partition key and sort key), you must provide exactly two elements, in this order: The first element must have a <code>KeyType</code> of <code>HASH</code>, and the second element must have a <code>KeyType</code> of <code>RANGE</code>.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/WorkingWithTables.html#WorkingWithTables.primary.key">Working with Tables</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>', 'GlobalSecondaryIndex$KeySchema' => '<p>The complete key schema for a global secondary index, which consists of one or more pairs of attribute names and key types:</p> <ul> <li> <p> <code>HASH</code> - partition key</p> </li> <li> <p> <code>RANGE</code> - sort key</p> </li> </ul> <note> <p>The partition key of an item is also known as its <i>hash attribute</i>. The term "hash attribute" derives from DynamoDB\'s usage of an internal hash function to evenly distribute data items across partitions, based on their partition key values.</p> <p>The sort key of an item is also known as its <i>range attribute</i>. The term "range attribute" derives from the way DynamoDB stores items with the same partition key physically close together, in sorted order by the sort key value.</p> </note>', 'GlobalSecondaryIndexDescription$KeySchema' => '<p>The complete key schema for a global secondary index, which consists of one or more pairs of attribute names and key types:</p> <ul> <li> <p> <code>HASH</code> - partition key</p> </li> <li> <p> <code>RANGE</code> - sort key</p> </li> </ul> <note> <p>The partition key of an item is also known as its <i>hash attribute</i>. The term "hash attribute" derives from DynamoDB\'s usage of an internal hash function to evenly distribute data items across partitions, based on their partition key values.</p> <p>The sort key of an item is also known as its <i>range attribute</i>. The term "range attribute" derives from the way DynamoDB stores items with the same partition key physically close together, in sorted order by the sort key value.</p> </note>', 'GlobalSecondaryIndexInfo$KeySchema' => '<p>The complete key schema for a global secondary index, which consists of one or more pairs of attribute names and key types:</p> <ul> <li> <p> <code>HASH</code> - partition key</p> </li> <li> <p> <code>RANGE</code> - sort key</p> </li> </ul> <note> <p>The partition key of an item is also known as its <i>hash attribute</i>. The term "hash attribute" derives from DynamoDB\'s usage of an internal hash function to evenly distribute data items across partitions, based on their partition key values.</p> <p>The sort key of an item is also known as its <i>range attribute</i>. The term "range attribute" derives from the way DynamoDB stores items with the same partition key physically close together, in sorted order by the sort key value.</p> </note>', 'LocalSecondaryIndex$KeySchema' => '<p>The complete key schema for the local secondary index, consisting of one or more pairs of attribute names and key types:</p> <ul> <li> <p> <code>HASH</code> - partition key</p> </li> <li> <p> <code>RANGE</code> - sort key</p> </li> </ul> <note> <p>The partition key of an item is also known as its <i>hash attribute</i>. The term "hash attribute" derives from DynamoDB\'s usage of an internal hash function to evenly distribute data items across partitions, based on their partition key values.</p> <p>The sort key of an item is also known as its <i>range attribute</i>. The term "range attribute" derives from the way DynamoDB stores items with the same partition key physically close together, in sorted order by the sort key value.</p> </note>', 'LocalSecondaryIndexDescription$KeySchema' => '<p>The complete key schema for the local secondary index, consisting of one or more pairs of attribute names and key types:</p> <ul> <li> <p> <code>HASH</code> - partition key</p> </li> <li> <p> <code>RANGE</code> - sort key</p> </li> </ul> <note> <p>The partition key of an item is also known as its <i>hash attribute</i>. The term "hash attribute" derives from DynamoDB\'s usage of an internal hash function to evenly distribute data items across partitions, based on their partition key values.</p> <p>The sort key of an item is also known as its <i>range attribute</i>. The term "range attribute" derives from the way DynamoDB stores items with the same partition key physically close together, in sorted order by the sort key value.</p> </note>', 'LocalSecondaryIndexInfo$KeySchema' => '<p>The complete key schema for a local secondary index, which consists of one or more pairs of attribute names and key types:</p> <ul> <li> <p> <code>HASH</code> - partition key</p> </li> <li> <p> <code>RANGE</code> - sort key</p> </li> </ul> <note> <p>The partition key of an item is also known as its <i>hash attribute</i>. The term "hash attribute" derives from DynamoDB\'s usage of an internal hash function to evenly distribute data items across partitions, based on their partition key values.</p> <p>The sort key of an item is also known as its <i>range attribute</i>. The term "range attribute" derives from the way DynamoDB stores items with the same partition key physically close together, in sorted order by the sort key value.</p> </note>', 'SourceTableDetails$KeySchema' => '<p>Schema of the table. </p>', 'TableDescription$KeySchema' => '<p>The primary key structure for the table. Each <code>KeySchemaElement</code> consists of:</p> <ul> <li> <p> <code>AttributeName</code> - The name of the attribute.</p> </li> <li> <p> <code>KeyType</code> - The role of the attribute:</p> <ul> <li> <p> <code>HASH</code> - partition key</p> </li> <li> <p> <code>RANGE</code> - sort key</p> </li> </ul> <note> <p>The partition key of an item is also known as its <i>hash attribute</i>. The term "hash attribute" derives from DynamoDB\'s usage of an internal hash function to evenly distribute data items across partitions, based on their partition key values.</p> <p>The sort key of an item is also known as its <i>range attribute</i>. The term "range attribute" derives from the way DynamoDB stores items with the same partition key physically close together, in sorted order by the sort key value.</p> </note> </li> </ul> <p>For more information about primary keys, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/DataModel.html#DataModelPrimaryKey">Primary Key</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>', ], ], 'KeySchemaAttributeName' => [ 'base' => NULL, 'refs' => [ 'AttributeDefinition$AttributeName' => '<p>A name for the attribute.</p>', 'KeySchemaElement$AttributeName' => '<p>The name of a key attribute.</p>', ], ], 'KeySchemaElement' => [ 'base' => '<p>Represents <i>a single element</i> of a key schema. A key schema specifies the attributes that make up the primary key of a table, or the key attributes of an index.</p> <p>A <code>KeySchemaElement</code> represents exactly one attribute of the primary key. For example, a simple primary key would be represented by one <code>KeySchemaElement</code> (for the partition key). A composite primary key would require one <code>KeySchemaElement</code> for the partition key, and another <code>KeySchemaElement</code> for the sort key.</p> <p>A <code>KeySchemaElement</code> must be a scalar, top-level attribute (not a nested attribute). The data type must be one of String, Number, or Binary. The attribute cannot be nested within a List or a Map.</p>', 'refs' => [ 'KeySchema$member' => NULL, ], ], 'KeyType' => [ 'base' => NULL, 'refs' => [ 'KeySchemaElement$KeyType' => '<p>The role that this key attribute will assume:</p> <ul> <li> <p> <code>HASH</code> - partition key</p> </li> <li> <p> <code>RANGE</code> - sort key</p> </li> </ul> <note> <p>The partition key of an item is also known as its <i>hash attribute</i>. The term "hash attribute" derives from DynamoDB\'s usage of an internal hash function to evenly distribute data items across partitions, based on their partition key values.</p> <p>The sort key of an item is also known as its <i>range attribute</i>. The term "range attribute" derives from the way DynamoDB stores items with the same partition key physically close together, in sorted order by the sort key value.</p> </note>', ], ], 'KeysAndAttributes' => [ 'base' => '<p>Represents a set of primary keys and, for each key, the attributes to retrieve from the table.</p> <p>For each primary key, you must provide <i>all</i> of the key attributes. For example, with a simple primary key, you only need to provide the partition key. For a composite primary key, you must provide <i>both</i> the partition key and the sort key.</p>', 'refs' => [ 'BatchGetRequestMap$value' => NULL, ], ], 'KinesisDataStreamDestination' => [ 'base' => '<p>Describes a Kinesis data stream destination.</p>', 'refs' => [ 'KinesisDataStreamDestinations$member' => NULL, ], ], 'KinesisDataStreamDestinations' => [ 'base' => NULL, 'refs' => [ 'DescribeKinesisStreamingDestinationOutput$KinesisDataStreamDestinations' => '<p>The list of replica structures for the table being described.</p>', ], ], 'KinesisStreamingDestinationInput' => [ 'base' => NULL, 'refs' => [], ], 'KinesisStreamingDestinationOutput' => [ 'base' => NULL, 'refs' => [], ], 'LastUpdateDateTime' => [ 'base' => NULL, 'refs' => [ 'DescribeContributorInsightsOutput$LastUpdateDateTime' => '<p>Timestamp of the last time the status was changed.</p>', ], ], 'LimitExceededException' => [ 'base' => '<p>There is no limit to the number of daily on-demand backups that can be taken. </p> <p>Up to 50 simultaneous table operations are allowed per account. These operations include <code>CreateTable</code>, <code>UpdateTable</code>, <code>DeleteTable</code>,<code>UpdateTimeToLive</code>, <code>RestoreTableFromBackup</code>, and <code>RestoreTableToPointInTime</code>. </p> <p>The only exception is when you are creating a table with one or more secondary indexes. You can have up to 25 such requests running at a time; however, if the table or index specifications are complex, DynamoDB might temporarily reduce the number of concurrent operations.</p> <p>There is a soft account quota of 256 tables.</p>', 'refs' => [], ], 'ListAttributeValue' => [ 'base' => NULL, 'refs' => [ 'AttributeValue$L' => '<p>An attribute of type List. For example:</p> <p> <code>"L": [ {"S": "Cookies"} , {"S": "Coffee"}, {"N", "3.14159"}]</code> </p>', ], ], 'ListBackupsInput' => [ 'base' => NULL, 'refs' => [], ], 'ListBackupsOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListContributorInsightsInput' => [ 'base' => NULL, 'refs' => [], ], 'ListContributorInsightsLimit' => [ 'base' => NULL, 'refs' => [ 'ListContributorInsightsInput$MaxResults' => '<p>Maximum number of results to return per page.</p>', ], ], 'ListContributorInsightsOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListExportsInput' => [ 'base' => NULL, 'refs' => [], ], 'ListExportsMaxLimit' => [ 'base' => NULL, 'refs' => [ 'ListExportsInput$MaxResults' => '<p>Maximum number of results to return per page.</p>', ], ], 'ListExportsOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListGlobalTablesInput' => [ 'base' => NULL, 'refs' => [], ], 'ListGlobalTablesOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListTablesInput' => [ 'base' => '<p>Represents the input of a <code>ListTables</code> operation.</p>', 'refs' => [], ], 'ListTablesInputLimit' => [ 'base' => NULL, 'refs' => [ 'ListTablesInput$Limit' => '<p>A maximum number of table names to return. If this parameter is not specified, the limit is 100.</p>', ], ], 'ListTablesOutput' => [ 'base' => '<p>Represents the output of a <code>ListTables</code> operation.</p>', 'refs' => [], ], 'ListTagsOfResourceInput' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsOfResourceOutput' => [ 'base' => NULL, 'refs' => [], ], 'LocalSecondaryIndex' => [ 'base' => '<p>Represents the properties of a local secondary index.</p>', 'refs' => [ 'LocalSecondaryIndexList$member' => NULL, ], ], 'LocalSecondaryIndexDescription' => [ 'base' => '<p>Represents the properties of a local secondary index.</p>', 'refs' => [ 'LocalSecondaryIndexDescriptionList$member' => NULL, ], ], 'LocalSecondaryIndexDescriptionList' => [ 'base' => NULL, 'refs' => [ 'TableDescription$LocalSecondaryIndexes' => '<p>Represents one or more local secondary indexes on the table. Each index is scoped to a given partition key value. Tables with one or more local secondary indexes are subject to an item collection size limit, where the amount of data within a given item collection cannot exceed 10 GB. Each element is composed of:</p> <ul> <li> <p> <code>IndexName</code> - The name of the local secondary index.</p> </li> <li> <p> <code>KeySchema</code> - Specifies the complete index key schema. The attribute names in the key schema must be between 1 and 255 characters (inclusive). The key schema must begin with the same partition key as the table.</p> </li> <li> <p> <code>Projection</code> - Specifies attributes that are copied (projected) from the table into the index. These are in addition to the primary key attributes and index key attributes, which are automatically projected. Each attribute specification is composed of:</p> <ul> <li> <p> <code>ProjectionType</code> - One of the following:</p> <ul> <li> <p> <code>KEYS_ONLY</code> - Only the index and primary keys are projected into the index.</p> </li> <li> <p> <code>INCLUDE</code> - Only the specified table attributes are projected into the index. The list of projected attributes is in <code>NonKeyAttributes</code>.</p> </li> <li> <p> <code>ALL</code> - All of the table attributes are projected into the index.</p> </li> </ul> </li> <li> <p> <code>NonKeyAttributes</code> - A list of one or more non-key attribute names that are projected into the secondary index. The total count of attributes provided in <code>NonKeyAttributes</code>, summed across all of the secondary indexes, must not exceed 20. If you project the same attribute into two different indexes, this counts as two distinct attributes when determining the total.</p> </li> </ul> </li> <li> <p> <code>IndexSizeBytes</code> - Represents the total size of the index, in bytes. DynamoDB updates this value approximately every six hours. Recent changes might not be reflected in this value.</p> </li> <li> <p> <code>ItemCount</code> - Represents the number of items in the index. DynamoDB updates this value approximately every six hours. Recent changes might not be reflected in this value.</p> </li> </ul> <p>If the table is in the <code>DELETING</code> state, no information about indexes will be returned.</p>', ], ], 'LocalSecondaryIndexInfo' => [ 'base' => '<p>Represents the properties of a local secondary index for the table when the backup was created.</p>', 'refs' => [ 'LocalSecondaryIndexes$member' => NULL, ], ], 'LocalSecondaryIndexList' => [ 'base' => NULL, 'refs' => [ 'CreateTableInput$LocalSecondaryIndexes' => '<p>One or more local secondary indexes (the maximum is 5) to be created on the table. Each index is scoped to a given partition key value. There is a 10 GB size limit per partition key value; otherwise, the size of a local secondary index is unconstrained.</p> <p>Each local secondary index in the array includes the following:</p> <ul> <li> <p> <code>IndexName</code> - The name of the local secondary index. Must be unique only for this table.</p> <p/> </li> <li> <p> <code>KeySchema</code> - Specifies the key schema for the local secondary index. The key schema must begin with the same partition key as the table.</p> </li> <li> <p> <code>Projection</code> - Specifies attributes that are copied (projected) from the table into the index. These are in addition to the primary key attributes and index key attributes, which are automatically projected. Each attribute specification is composed of:</p> <ul> <li> <p> <code>ProjectionType</code> - One of the following:</p> <ul> <li> <p> <code>KEYS_ONLY</code> - Only the index and primary keys are projected into the index.</p> </li> <li> <p> <code>INCLUDE</code> - Only the specified table attributes are projected into the index. The list of projected attributes is in <code>NonKeyAttributes</code>.</p> </li> <li> <p> <code>ALL</code> - All of the table attributes are projected into the index.</p> </li> </ul> </li> <li> <p> <code>NonKeyAttributes</code> - A list of one or more non-key attribute names that are projected into the secondary index. The total count of attributes provided in <code>NonKeyAttributes</code>, summed across all of the secondary indexes, must not exceed 100. If you project the same attribute into two different indexes, this counts as two distinct attributes when determining the total.</p> </li> </ul> </li> </ul>', 'RestoreTableFromBackupInput$LocalSecondaryIndexOverride' => '<p>List of local secondary indexes for the restored table. The indexes provided should match existing secondary indexes. You can choose to exclude some or all of the indexes at the time of restore.</p>', 'RestoreTableToPointInTimeInput$LocalSecondaryIndexOverride' => '<p>List of local secondary indexes for the restored table. The indexes provided should match existing secondary indexes. You can choose to exclude some or all of the indexes at the time of restore.</p>', ], ], 'LocalSecondaryIndexes' => [ 'base' => NULL, 'refs' => [ 'SourceTableFeatureDetails$LocalSecondaryIndexes' => '<p>Represents the LSI properties for the table when the backup was created. It includes the IndexName, KeySchema and Projection for the LSIs on the table at the time of backup. </p>', ], ], 'Long' => [ 'base' => NULL, 'refs' => [ 'Endpoint$CachePeriodInMinutes' => '<p>Endpoint cache time to live (TTL) value.</p>', 'GlobalSecondaryIndexDescription$IndexSizeBytes' => '<p>The total size of the specified index, in bytes. DynamoDB updates this value approximately every six hours. Recent changes might not be reflected in this value.</p>', 'GlobalSecondaryIndexDescription$ItemCount' => '<p>The number of items in the specified index. DynamoDB updates this value approximately every six hours. Recent changes might not be reflected in this value.</p>', 'LocalSecondaryIndexDescription$IndexSizeBytes' => '<p>The total size of the specified index, in bytes. DynamoDB updates this value approximately every six hours. Recent changes might not be reflected in this value.</p>', 'LocalSecondaryIndexDescription$ItemCount' => '<p>The number of items in the specified index. DynamoDB updates this value approximately every six hours. Recent changes might not be reflected in this value.</p>', 'SourceTableDetails$TableSizeBytes' => '<p>Size of the table in bytes. Note that this is an approximate value.</p>', 'TableDescription$TableSizeBytes' => '<p>The total size of the specified table, in bytes. DynamoDB updates this value approximately every six hours. Recent changes might not be reflected in this value.</p>', 'TableDescription$ItemCount' => '<p>The number of items in the specified table. DynamoDB updates this value approximately every six hours. Recent changes might not be reflected in this value.</p>', ], ], 'MapAttributeValue' => [ 'base' => NULL, 'refs' => [ 'AttributeValue$M' => '<p>An attribute of type Map. For example:</p> <p> <code>"M": {"Name": {"S": "Joe"}, "Age": {"N": "35"}}</code> </p>', ], ], 'NextTokenString' => [ 'base' => NULL, 'refs' => [ 'ListContributorInsightsInput$NextToken' => '<p>A token to for the desired page, if there is one.</p>', 'ListContributorInsightsOutput$NextToken' => '<p>A token to go to the next page if there is one.</p>', 'ListTagsOfResourceInput$NextToken' => '<p>An optional string that, if supplied, must be copied from the output of a previous call to ListTagOfResource. When provided in this manner, this API fetches the next page of results.</p>', 'ListTagsOfResourceOutput$NextToken' => '<p>If this value is returned, there are additional results to be displayed. To retrieve them, call ListTagsOfResource again, with NextToken set to this value.</p>', ], ], 'NonKeyAttributeName' => [ 'base' => NULL, 'refs' => [ 'NonKeyAttributeNameList$member' => NULL, ], ], 'NonKeyAttributeNameList' => [ 'base' => NULL, 'refs' => [ 'Projection$NonKeyAttributes' => '<p>Represents the non-key attribute names which will be projected into the index.</p> <p>For local secondary indexes, the total count of <code>NonKeyAttributes</code> summed across all of the local secondary indexes, must not exceed 20. If you project the same attribute into two different indexes, this counts as two distinct attributes when determining the total.</p>', ], ], 'NonNegativeLongObject' => [ 'base' => NULL, 'refs' => [ 'ProvisionedThroughputDescription$ReadCapacityUnits' => '<p>The maximum number of strongly consistent reads consumed per second before DynamoDB returns a <code>ThrottlingException</code>. Eventually consistent reads require less effort than strongly consistent reads, so a setting of 50 <code>ReadCapacityUnits</code> per second provides 100 eventually consistent <code>ReadCapacityUnits</code> per second.</p>', 'ProvisionedThroughputDescription$WriteCapacityUnits' => '<p>The maximum number of writes consumed per second before DynamoDB returns a <code>ThrottlingException</code>.</p>', 'ReplicaSettingsDescription$ReplicaProvisionedReadCapacityUnits' => '<p>The maximum number of strongly consistent reads consumed per second before DynamoDB returns a <code>ThrottlingException</code>. For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/WorkingWithTables.html#ProvisionedThroughput">Specifying Read and Write Requirements</a> in the <i>Amazon DynamoDB Developer Guide</i>. </p>', 'ReplicaSettingsDescription$ReplicaProvisionedWriteCapacityUnits' => '<p>The maximum number of writes consumed per second before DynamoDB returns a <code>ThrottlingException</code>. For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/WorkingWithTables.html#ProvisionedThroughput">Specifying Read and Write Requirements</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>', ], ], 'NullAttributeValue' => [ 'base' => NULL, 'refs' => [ 'AttributeValue$NULL' => '<p>An attribute of type Null. For example:</p> <p> <code>"NULL": true</code> </p>', ], ], 'NumberAttributeValue' => [ 'base' => NULL, 'refs' => [ 'AttributeValue$N' => '<p>An attribute of type Number. For example:</p> <p> <code>"N": "123.45"</code> </p> <p>Numbers are sent across the network to DynamoDB as strings, to maximize compatibility across languages and libraries. However, DynamoDB treats them as number type attributes for mathematical operations.</p>', 'NumberSetAttributeValue$member' => NULL, ], ], 'NumberSetAttributeValue' => [ 'base' => NULL, 'refs' => [ 'AttributeValue$NS' => '<p>An attribute of type Number Set. For example:</p> <p> <code>"NS": ["42.2", "-19", "7.5", "3.14"]</code> </p> <p>Numbers are sent across the network to DynamoDB as strings, to maximize compatibility across languages and libraries. However, DynamoDB treats them as number type attributes for mathematical operations.</p>', ], ], 'ParameterizedStatement' => [ 'base' => '<p> Represents a PartiQL statment that uses parameters. </p>', 'refs' => [ 'ParameterizedStatements$member' => NULL, ], ], 'ParameterizedStatements' => [ 'base' => NULL, 'refs' => [ 'ExecuteTransactionInput$TransactStatements' => '<p>The list of PartiQL statements representing the transaction to run.</p>', ], ], 'PartiQLBatchRequest' => [ 'base' => NULL, 'refs' => [ 'BatchExecuteStatementInput$Statements' => '<p>The list of PartiQL statements representing the batch to run.</p>', ], ], 'PartiQLBatchResponse' => [ 'base' => NULL, 'refs' => [ 'BatchExecuteStatementOutput$Responses' => '<p>The response to each PartiQL statement in the batch.</p>', ], ], 'PartiQLNextToken' => [ 'base' => NULL, 'refs' => [ 'ExecuteStatementInput$NextToken' => '<p>Set this value to get remaining results, if <code>NextToken</code> was returned in the statement response.</p>', 'ExecuteStatementOutput$NextToken' => '<p>If the response of a read request exceeds the response payload limit DynamoDB will set this value in the response. If set, you can use that this value in the subsequent request to get the remaining results.</p>', ], ], 'PartiQLStatement' => [ 'base' => NULL, 'refs' => [ 'BatchStatementRequest$Statement' => '<p> A valid PartiQL statement. </p>', 'ExecuteStatementInput$Statement' => '<p>The PartiQL statement representing the operation to run.</p>', 'ParameterizedStatement$Statement' => '<p> A PartiQL statment that uses parameters. </p>', ], ], 'PointInTimeRecoveryDescription' => [ 'base' => '<p>The description of the point in time settings applied to the table.</p>', 'refs' => [ 'ContinuousBackupsDescription$PointInTimeRecoveryDescription' => '<p>The description of the point in time recovery settings applied to the table.</p>', ], ], 'PointInTimeRecoverySpecification' => [ 'base' => '<p>Represents the settings used to enable point in time recovery.</p>', 'refs' => [ 'UpdateContinuousBackupsInput$PointInTimeRecoverySpecification' => '<p>Represents the settings used to enable point in time recovery.</p>', ], ], 'PointInTimeRecoveryStatus' => [ 'base' => NULL, 'refs' => [ 'PointInTimeRecoveryDescription$PointInTimeRecoveryStatus' => '<p>The current state of point in time recovery:</p> <ul> <li> <p> <code>ENABLED</code> - Point in time recovery is enabled.</p> </li> <li> <p> <code>DISABLED</code> - Point in time recovery is disabled.</p> </li> </ul>', ], ], 'PointInTimeRecoveryUnavailableException' => [ 'base' => '<p>Point in time recovery has not yet been enabled for this source table.</p>', 'refs' => [], ], 'PositiveIntegerObject' => [ 'base' => NULL, 'refs' => [ 'ExecuteStatementInput$Limit' => '<p>The maximum number of items to evaluate (not necessarily the number of matching items). If DynamoDB processes the number of items up to the limit while processing the results, it stops the operation and returns the matching values up to that point, along with a key in <code>LastEvaluatedKey</code> to apply in a subsequent operation so you can pick up where you left off. Also, if the processed dataset size exceeds 1 MB before DynamoDB reaches this limit, it stops the operation and returns the matching values up to the limit, and a key in <code>LastEvaluatedKey</code> to apply in a subsequent operation to continue the operation. </p>', 'ListGlobalTablesInput$Limit' => '<p>The maximum number of table names to return, if the parameter is not specified DynamoDB defaults to 100.</p> <p>If the number of global tables DynamoDB finds reaches this limit, it stops the operation and returns the table names collected up to that point, with a table name in the <code>LastEvaluatedGlobalTableName</code> to apply in a subsequent operation to the <code>ExclusiveStartGlobalTableName</code> parameter.</p>', 'QueryInput$Limit' => '<p>The maximum number of items to evaluate (not necessarily the number of matching items). If DynamoDB processes the number of items up to the limit while processing the results, it stops the operation and returns the matching values up to that point, and a key in <code>LastEvaluatedKey</code> to apply in a subsequent operation, so that you can pick up where you left off. Also, if the processed dataset size exceeds 1 MB before DynamoDB reaches this limit, it stops the operation and returns the matching values up to the limit, and a key in <code>LastEvaluatedKey</code> to apply in a subsequent operation to continue the operation. For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/QueryAndScan.html">Query and Scan</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>', 'ScanInput$Limit' => '<p>The maximum number of items to evaluate (not necessarily the number of matching items). If DynamoDB processes the number of items up to the limit while processing the results, it stops the operation and returns the matching values up to that point, and a key in <code>LastEvaluatedKey</code> to apply in a subsequent operation, so that you can pick up where you left off. Also, if the processed dataset size exceeds 1 MB before DynamoDB reaches this limit, it stops the operation and returns the matching values up to the limit, and a key in <code>LastEvaluatedKey</code> to apply in a subsequent operation to continue the operation. For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/QueryAndScan.html">Working with Queries</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>', ], ], 'PositiveLongObject' => [ 'base' => NULL, 'refs' => [ 'AutoScalingSettingsDescription$MinimumUnits' => '<p>The minimum capacity units that a global table or global secondary index should be scaled down to.</p>', 'AutoScalingSettingsDescription$MaximumUnits' => '<p>The maximum capacity units that a global table or global secondary index should be scaled up to.</p>', 'AutoScalingSettingsUpdate$MinimumUnits' => '<p>The minimum capacity units that a global table or global secondary index should be scaled down to.</p>', 'AutoScalingSettingsUpdate$MaximumUnits' => '<p>The maximum capacity units that a global table or global secondary index should be scaled up to.</p>', 'DescribeLimitsOutput$AccountMaxReadCapacityUnits' => '<p>The maximum total read capacity units that your account allows you to provision across all of your tables in this Region.</p>', 'DescribeLimitsOutput$AccountMaxWriteCapacityUnits' => '<p>The maximum total write capacity units that your account allows you to provision across all of your tables in this Region.</p>', 'DescribeLimitsOutput$TableMaxReadCapacityUnits' => '<p>The maximum read capacity units that your account allows you to provision for a new table that you are creating in this Region, including the read capacity units provisioned for its global secondary indexes (GSIs).</p>', 'DescribeLimitsOutput$TableMaxWriteCapacityUnits' => '<p>The maximum write capacity units that your account allows you to provision for a new table that you are creating in this Region, including the write capacity units provisioned for its global secondary indexes (GSIs).</p>', 'GlobalTableGlobalSecondaryIndexSettingsUpdate$ProvisionedWriteCapacityUnits' => '<p>The maximum number of writes consumed per second before DynamoDB returns a <code>ThrottlingException.</code> </p>', 'ProvisionedThroughput$ReadCapacityUnits' => '<p>The maximum number of strongly consistent reads consumed per second before DynamoDB returns a <code>ThrottlingException</code>. For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/WorkingWithTables.html#ProvisionedThroughput">Specifying Read and Write Requirements</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p> <p>If read/write capacity mode is <code>PAY_PER_REQUEST</code> the value is set to 0.</p>', 'ProvisionedThroughput$WriteCapacityUnits' => '<p>The maximum number of writes consumed per second before DynamoDB returns a <code>ThrottlingException</code>. For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/WorkingWithTables.html#ProvisionedThroughput">Specifying Read and Write Requirements</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p> <p>If read/write capacity mode is <code>PAY_PER_REQUEST</code> the value is set to 0.</p>', 'ProvisionedThroughputDescription$NumberOfDecreasesToday' => '<p>The number of provisioned throughput decreases for this table during this UTC calendar day. For current maximums on provisioned throughput decreases, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Limits.html">Service, Account, and Table Quotas</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>', 'ProvisionedThroughputOverride$ReadCapacityUnits' => '<p>Replica-specific read capacity units. If not specified, uses the source table\'s read capacity settings.</p>', 'ReplicaGlobalSecondaryIndexSettingsDescription$ProvisionedReadCapacityUnits' => '<p>The maximum number of strongly consistent reads consumed per second before DynamoDB returns a <code>ThrottlingException</code>.</p>', 'ReplicaGlobalSecondaryIndexSettingsDescription$ProvisionedWriteCapacityUnits' => '<p>The maximum number of writes consumed per second before DynamoDB returns a <code>ThrottlingException</code>.</p>', 'ReplicaGlobalSecondaryIndexSettingsUpdate$ProvisionedReadCapacityUnits' => '<p>The maximum number of strongly consistent reads consumed per second before DynamoDB returns a <code>ThrottlingException</code>.</p>', 'ReplicaSettingsUpdate$ReplicaProvisionedReadCapacityUnits' => '<p>The maximum number of strongly consistent reads consumed per second before DynamoDB returns a <code>ThrottlingException</code>. For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/WorkingWithTables.html#ProvisionedThroughput">Specifying Read and Write Requirements</a> in the <i>Amazon DynamoDB Developer Guide</i>. </p>', 'UpdateGlobalTableSettingsInput$GlobalTableProvisionedWriteCapacityUnits' => '<p>The maximum number of writes consumed per second before DynamoDB returns a <code>ThrottlingException.</code> </p>', ], ], 'PreparedStatementParameters' => [ 'base' => NULL, 'refs' => [ 'BatchStatementRequest$Parameters' => '<p> The parameters associated with a PartiQL statement in the batch request. </p>', 'ExecuteStatementInput$Parameters' => '<p>The parameters for the PartiQL statement, if any.</p>', 'ParameterizedStatement$Parameters' => '<p> The parameter values. </p>', ], ], 'Projection' => [ 'base' => '<p>Represents attributes that are copied (projected) from the table into an index. These are in addition to the primary key attributes and index key attributes, which are automatically projected.</p>', 'refs' => [ 'CreateGlobalSecondaryIndexAction$Projection' => '<p>Represents attributes that are copied (projected) from the table into an index. These are in addition to the primary key attributes and index key attributes, which are automatically projected.</p>', 'GlobalSecondaryIndex$Projection' => '<p>Represents attributes that are copied (projected) from the table into the global secondary index. These are in addition to the primary key attributes and index key attributes, which are automatically projected. </p>', 'GlobalSecondaryIndexDescription$Projection' => '<p>Represents attributes that are copied (projected) from the table into the global secondary index. These are in addition to the primary key attributes and index key attributes, which are automatically projected. </p>', 'GlobalSecondaryIndexInfo$Projection' => '<p>Represents attributes that are copied (projected) from the table into the global secondary index. These are in addition to the primary key attributes and index key attributes, which are automatically projected. </p>', 'LocalSecondaryIndex$Projection' => '<p>Represents attributes that are copied (projected) from the table into the local secondary index. These are in addition to the primary key attributes and index key attributes, which are automatically projected. </p>', 'LocalSecondaryIndexDescription$Projection' => '<p>Represents attributes that are copied (projected) from the table into the global secondary index. These are in addition to the primary key attributes and index key attributes, which are automatically projected. </p>', 'LocalSecondaryIndexInfo$Projection' => '<p>Represents attributes that are copied (projected) from the table into the global secondary index. These are in addition to the primary key attributes and index key attributes, which are automatically projected. </p>', ], ], 'ProjectionExpression' => [ 'base' => NULL, 'refs' => [ 'Get$ProjectionExpression' => '<p>A string that identifies one or more attributes of the specified item to retrieve from the table. The attributes in the expression must be separated by commas. If no attribute names are specified, then all attributes of the specified item are returned. If any of the requested attributes are not found, they do not appear in the result.</p>', 'GetItemInput$ProjectionExpression' => '<p>A string that identifies one or more attributes to retrieve from the table. These attributes can include scalars, sets, or elements of a JSON document. The attributes in the expression must be separated by commas.</p> <p>If no attribute names are specified, then all attributes are returned. If any of the requested attributes are not found, they do not appear in the result.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html">Specifying Item Attributes</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>', 'KeysAndAttributes$ProjectionExpression' => '<p>A string that identifies one or more attributes to retrieve from the table. These attributes can include scalars, sets, or elements of a JSON document. The attributes in the <code>ProjectionExpression</code> must be separated by commas.</p> <p>If no attribute names are specified, then all attributes will be returned. If any of the requested attributes are not found, they will not appear in the result.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html">Accessing Item Attributes</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>', 'QueryInput$ProjectionExpression' => '<p>A string that identifies one or more attributes to retrieve from the table. These attributes can include scalars, sets, or elements of a JSON document. The attributes in the expression must be separated by commas.</p> <p>If no attribute names are specified, then all attributes will be returned. If any of the requested attributes are not found, they will not appear in the result.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html">Accessing Item Attributes</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>', 'ScanInput$ProjectionExpression' => '<p>A string that identifies one or more attributes to retrieve from the specified table or index. These attributes can include scalars, sets, or elements of a JSON document. The attributes in the expression must be separated by commas.</p> <p>If no attribute names are specified, then all attributes will be returned. If any of the requested attributes are not found, they will not appear in the result.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html">Specifying Item Attributes</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>', ], ], 'ProjectionType' => [ 'base' => NULL, 'refs' => [ 'Projection$ProjectionType' => '<p>The set of attributes that are projected into the index:</p> <ul> <li> <p> <code>KEYS_ONLY</code> - Only the index and primary keys are projected into the index.</p> </li> <li> <p> <code>INCLUDE</code> - In addition to the attributes described in <code>KEYS_ONLY</code>, the secondary index will include other non-key attributes that you specify.</p> </li> <li> <p> <code>ALL</code> - All of the table attributes are projected into the index.</p> </li> </ul>', ], ], 'ProvisionedThroughput' => [ 'base' => '<p>Represents the provisioned throughput settings for a specified table or index. The settings can be modified using the <code>UpdateTable</code> operation.</p> <p>For current minimum and maximum provisioned throughput values, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Limits.html">Service, Account, and Table Quotas</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>', 'refs' => [ 'CreateGlobalSecondaryIndexAction$ProvisionedThroughput' => '<p>Represents the provisioned throughput settings for the specified global secondary index.</p> <p>For current minimum and maximum provisioned throughput values, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Limits.html">Service, Account, and Table Quotas</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>', 'CreateTableInput$ProvisionedThroughput' => '<p>Represents the provisioned throughput settings for a specified table or index. The settings can be modified using the <code>UpdateTable</code> operation.</p> <p> If you set BillingMode as <code>PROVISIONED</code>, you must specify this property. If you set BillingMode as <code>PAY_PER_REQUEST</code>, you cannot specify this property.</p> <p>For current minimum and maximum provisioned throughput values, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Limits.html">Service, Account, and Table Quotas</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>', 'GlobalSecondaryIndex$ProvisionedThroughput' => '<p>Represents the provisioned throughput settings for the specified global secondary index.</p> <p>For current minimum and maximum provisioned throughput values, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Limits.html">Service, Account, and Table Quotas</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>', 'GlobalSecondaryIndexInfo$ProvisionedThroughput' => '<p>Represents the provisioned throughput settings for the specified global secondary index. </p>', 'RestoreTableFromBackupInput$ProvisionedThroughputOverride' => '<p>Provisioned throughput settings for the restored table.</p>', 'RestoreTableToPointInTimeInput$ProvisionedThroughputOverride' => '<p>Provisioned throughput settings for the restored table.</p>', 'SourceTableDetails$ProvisionedThroughput' => '<p>Read IOPs and Write IOPS on the table when the backup was created.</p>', 'UpdateGlobalSecondaryIndexAction$ProvisionedThroughput' => '<p>Represents the provisioned throughput settings for the specified global secondary index.</p> <p>For current minimum and maximum provisioned throughput values, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Limits.html">Service, Account, and Table Quotas</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>', 'UpdateTableInput$ProvisionedThroughput' => '<p>The new provisioned throughput settings for the specified table or index.</p>', ], ], 'ProvisionedThroughputDescription' => [ 'base' => '<p>Represents the provisioned throughput settings for the table, consisting of read and write capacity units, along with data about increases and decreases.</p>', 'refs' => [ 'GlobalSecondaryIndexDescription$ProvisionedThroughput' => '<p>Represents the provisioned throughput settings for the specified global secondary index.</p> <p>For current minimum and maximum provisioned throughput values, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Limits.html">Service, Account, and Table Quotas</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>', 'TableDescription$ProvisionedThroughput' => '<p>The provisioned throughput settings for the table, consisting of read and write capacity units, along with data about increases and decreases.</p>', ], ], 'ProvisionedThroughputExceededException' => [ 'base' => '<p>Your request rate is too high. The Amazon Web Services SDKs for DynamoDB automatically retry requests that receive this exception. Your request is eventually successful, unless your retry queue is too large to finish. Reduce the frequency of requests and use exponential backoff. For more information, go to <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Programming.Errors.html#Programming.Errors.RetryAndBackoff">Error Retries and Exponential Backoff</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>', 'refs' => [], ], 'ProvisionedThroughputOverride' => [ 'base' => '<p>Replica-specific provisioned throughput settings. If not specified, uses the source table\'s provisioned throughput settings.</p>', 'refs' => [ 'CreateReplicationGroupMemberAction$ProvisionedThroughputOverride' => '<p>Replica-specific provisioned throughput. If not specified, uses the source table\'s provisioned throughput settings.</p>', 'ReplicaDescription$ProvisionedThroughputOverride' => '<p>Replica-specific provisioned throughput. If not described, uses the source table\'s provisioned throughput settings.</p>', 'ReplicaGlobalSecondaryIndex$ProvisionedThroughputOverride' => '<p>Replica table GSI-specific provisioned throughput. If not specified, uses the source table GSI\'s read capacity settings.</p>', 'ReplicaGlobalSecondaryIndexDescription$ProvisionedThroughputOverride' => '<p>If not described, uses the source table GSI\'s read capacity settings.</p>', 'UpdateReplicationGroupMemberAction$ProvisionedThroughputOverride' => '<p>Replica-specific provisioned throughput. If not specified, uses the source table\'s provisioned throughput settings.</p>', ], ], 'Put' => [ 'base' => '<p>Represents a request to perform a <code>PutItem</code> operation.</p>', 'refs' => [ 'TransactWriteItem$Put' => '<p>A request to perform a <code>PutItem</code> operation.</p>', ], ], 'PutItemInput' => [ 'base' => '<p>Represents the input of a <code>PutItem</code> operation.</p>', 'refs' => [], ], 'PutItemInputAttributeMap' => [ 'base' => NULL, 'refs' => [ 'Put$Item' => '<p>A map of attribute name to attribute values, representing the primary key of the item to be written by <code>PutItem</code>. All of the table\'s primary key attributes must be specified, and their data types must match those of the table\'s key schema. If any attributes are present in the item that are part of an index key schema for the table, their types must match the index key schema. </p>', 'PutItemInput$Item' => '<p>A map of attribute name/value pairs, one for each attribute. Only the primary key attributes are required; you can optionally provide other attribute name-value pairs for the item.</p> <p>You must provide all of the attributes for the primary key. For example, with a simple primary key, you only need to provide a value for the partition key. For a composite primary key, you must provide both values for both the partition key and the sort key.</p> <p>If you specify any attributes that are part of an index key, then the data types for those attributes must match those of the schema in the table\'s attribute definition.</p> <p>Empty String and Binary attribute values are allowed. Attribute values of type String and Binary must have a length greater than zero if the attribute is used as a key attribute for a table or index.</p> <p>For more information about primary keys, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.CoreComponents.html#HowItWorks.CoreComponents.PrimaryKey">Primary Key</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p> <p>Each element in the <code>Item</code> map is an <code>AttributeValue</code> object.</p>', 'PutRequest$Item' => '<p>A map of attribute name to attribute values, representing the primary key of an item to be processed by <code>PutItem</code>. All of the table\'s primary key attributes must be specified, and their data types must match those of the table\'s key schema. If any attributes are present in the item that are part of an index key schema for the table, their types must match the index key schema.</p>', ], ], 'PutItemOutput' => [ 'base' => '<p>Represents the output of a <code>PutItem</code> operation.</p>', 'refs' => [], ], 'PutRequest' => [ 'base' => '<p>Represents a request to perform a <code>PutItem</code> operation on an item.</p>', 'refs' => [ 'WriteRequest$PutRequest' => '<p>A request to perform a <code>PutItem</code> operation.</p>', ], ], 'QueryInput' => [ 'base' => '<p>Represents the input of a <code>Query</code> operation.</p>', 'refs' => [], ], 'QueryOutput' => [ 'base' => '<p>Represents the output of a <code>Query</code> operation.</p>', 'refs' => [], ], 'RegionName' => [ 'base' => NULL, 'refs' => [ 'CreateReplicaAction$RegionName' => '<p>The Region of the replica to be added.</p>', 'CreateReplicationGroupMemberAction$RegionName' => '<p>The Region where the new replica will be created.</p>', 'DeleteReplicaAction$RegionName' => '<p>The Region of the replica to be removed.</p>', 'DeleteReplicationGroupMemberAction$RegionName' => '<p>The Region where the replica exists.</p>', 'ListGlobalTablesInput$RegionName' => '<p>Lists the global tables in a specific Region.</p>', 'Replica$RegionName' => '<p>The Region where the replica needs to be created.</p>', 'ReplicaAutoScalingDescription$RegionName' => '<p>The Region where the replica exists.</p>', 'ReplicaAutoScalingUpdate$RegionName' => '<p>The Region where the replica exists.</p>', 'ReplicaDescription$RegionName' => '<p>The name of the Region.</p>', 'ReplicaSettingsDescription$RegionName' => '<p>The Region name of the replica.</p>', 'ReplicaSettingsUpdate$RegionName' => '<p>The Region of the replica to be added.</p>', 'UpdateReplicationGroupMemberAction$RegionName' => '<p>The Region where the replica exists.</p>', ], ], 'Replica' => [ 'base' => '<p>Represents the properties of a replica.</p>', 'refs' => [ 'ReplicaList$member' => NULL, ], ], 'ReplicaAlreadyExistsException' => [ 'base' => '<p>The specified replica is already part of the global table.</p>', 'refs' => [], ], 'ReplicaAutoScalingDescription' => [ 'base' => '<p>Represents the auto scaling settings of the replica.</p>', 'refs' => [ 'ReplicaAutoScalingDescriptionList$member' => NULL, ], ], 'ReplicaAutoScalingDescriptionList' => [ 'base' => NULL, 'refs' => [ 'TableAutoScalingDescription$Replicas' => '<p>Represents replicas of the global table.</p>', ], ], 'ReplicaAutoScalingUpdate' => [ 'base' => '<p>Represents the auto scaling settings of a replica that will be modified.</p>', 'refs' => [ 'ReplicaAutoScalingUpdateList$member' => NULL, ], ], 'ReplicaAutoScalingUpdateList' => [ 'base' => NULL, 'refs' => [ 'UpdateTableReplicaAutoScalingInput$ReplicaUpdates' => '<p>Represents the auto scaling settings of replicas of the table that will be modified.</p>', ], ], 'ReplicaDescription' => [ 'base' => '<p>Contains the details of the replica.</p>', 'refs' => [ 'ReplicaDescriptionList$member' => NULL, ], ], 'ReplicaDescriptionList' => [ 'base' => NULL, 'refs' => [ 'GlobalTableDescription$ReplicationGroup' => '<p>The Regions where the global table has replicas.</p>', 'TableDescription$Replicas' => '<p>Represents replicas of the table.</p>', ], ], 'ReplicaGlobalSecondaryIndex' => [ 'base' => '<p>Represents the properties of a replica global secondary index.</p>', 'refs' => [ 'ReplicaGlobalSecondaryIndexList$member' => NULL, ], ], 'ReplicaGlobalSecondaryIndexAutoScalingDescription' => [ 'base' => '<p>Represents the auto scaling configuration for a replica global secondary index.</p>', 'refs' => [ 'ReplicaGlobalSecondaryIndexAutoScalingDescriptionList$member' => NULL, ], ], 'ReplicaGlobalSecondaryIndexAutoScalingDescriptionList' => [ 'base' => NULL, 'refs' => [ 'ReplicaAutoScalingDescription$GlobalSecondaryIndexes' => '<p>Replica-specific global secondary index auto scaling settings.</p>', ], ], 'ReplicaGlobalSecondaryIndexAutoScalingUpdate' => [ 'base' => '<p>Represents the auto scaling settings of a global secondary index for a replica that will be modified.</p>', 'refs' => [ 'ReplicaGlobalSecondaryIndexAutoScalingUpdateList$member' => NULL, ], ], 'ReplicaGlobalSecondaryIndexAutoScalingUpdateList' => [ 'base' => NULL, 'refs' => [ 'ReplicaAutoScalingUpdate$ReplicaGlobalSecondaryIndexUpdates' => '<p>Represents the auto scaling settings of global secondary indexes that will be modified.</p>', ], ], 'ReplicaGlobalSecondaryIndexDescription' => [ 'base' => '<p>Represents the properties of a replica global secondary index.</p>', 'refs' => [ 'ReplicaGlobalSecondaryIndexDescriptionList$member' => NULL, ], ], 'ReplicaGlobalSecondaryIndexDescriptionList' => [ 'base' => NULL, 'refs' => [ 'ReplicaDescription$GlobalSecondaryIndexes' => '<p>Replica-specific global secondary index settings.</p>', ], ], 'ReplicaGlobalSecondaryIndexList' => [ 'base' => NULL, 'refs' => [ 'CreateReplicationGroupMemberAction$GlobalSecondaryIndexes' => '<p>Replica-specific global secondary index settings.</p>', 'UpdateReplicationGroupMemberAction$GlobalSecondaryIndexes' => '<p>Replica-specific global secondary index settings.</p>', ], ], 'ReplicaGlobalSecondaryIndexSettingsDescription' => [ 'base' => '<p>Represents the properties of a global secondary index.</p>', 'refs' => [ 'ReplicaGlobalSecondaryIndexSettingsDescriptionList$member' => NULL, ], ], 'ReplicaGlobalSecondaryIndexSettingsDescriptionList' => [ 'base' => NULL, 'refs' => [ 'ReplicaSettingsDescription$ReplicaGlobalSecondaryIndexSettings' => '<p>Replica global secondary index settings for the global table.</p>', ], ], 'ReplicaGlobalSecondaryIndexSettingsUpdate' => [ 'base' => '<p>Represents the settings of a global secondary index for a global table that will be modified.</p>', 'refs' => [ 'ReplicaGlobalSecondaryIndexSettingsUpdateList$member' => NULL, ], ], 'ReplicaGlobalSecondaryIndexSettingsUpdateList' => [ 'base' => NULL, 'refs' => [ 'ReplicaSettingsUpdate$ReplicaGlobalSecondaryIndexSettingsUpdate' => '<p>Represents the settings of a global secondary index for a global table that will be modified.</p>', ], ], 'ReplicaList' => [ 'base' => NULL, 'refs' => [ 'CreateGlobalTableInput$ReplicationGroup' => '<p>The Regions where the global table needs to be created.</p>', 'GlobalTable$ReplicationGroup' => '<p>The Regions where the global table has replicas.</p>', ], ], 'ReplicaNotFoundException' => [ 'base' => '<p>The specified replica is no longer part of the global table.</p>', 'refs' => [], ], 'ReplicaSettingsDescription' => [ 'base' => '<p>Represents the properties of a replica.</p>', 'refs' => [ 'ReplicaSettingsDescriptionList$member' => NULL, ], ], 'ReplicaSettingsDescriptionList' => [ 'base' => NULL, 'refs' => [ 'DescribeGlobalTableSettingsOutput$ReplicaSettings' => '<p>The Region-specific settings for the global table.</p>', 'UpdateGlobalTableSettingsOutput$ReplicaSettings' => '<p>The Region-specific settings for the global table.</p>', ], ], 'ReplicaSettingsUpdate' => [ 'base' => '<p>Represents the settings for a global table in a Region that will be modified.</p>', 'refs' => [ 'ReplicaSettingsUpdateList$member' => NULL, ], ], 'ReplicaSettingsUpdateList' => [ 'base' => NULL, 'refs' => [ 'UpdateGlobalTableSettingsInput$ReplicaSettingsUpdate' => '<p>Represents the settings for a global table in a Region that will be modified.</p>', ], ], 'ReplicaStatus' => [ 'base' => NULL, 'refs' => [ 'ReplicaAutoScalingDescription$ReplicaStatus' => '<p>The current state of the replica:</p> <ul> <li> <p> <code>CREATING</code> - The replica is being created.</p> </li> <li> <p> <code>UPDATING</code> - The replica is being updated.</p> </li> <li> <p> <code>DELETING</code> - The replica is being deleted.</p> </li> <li> <p> <code>ACTIVE</code> - The replica is ready for use.</p> </li> </ul>', 'ReplicaDescription$ReplicaStatus' => '<p>The current state of the replica:</p> <ul> <li> <p> <code>CREATING</code> - The replica is being created.</p> </li> <li> <p> <code>UPDATING</code> - The replica is being updated.</p> </li> <li> <p> <code>DELETING</code> - The replica is being deleted.</p> </li> <li> <p> <code>ACTIVE</code> - The replica is ready for use.</p> </li> <li> <p> <code>REGION_DISABLED</code> - The replica is inaccessible because the Amazon Web Services Region has been disabled.</p> <note> <p>If the Amazon Web Services Region remains inaccessible for more than 20 hours, DynamoDB will remove this replica from the replication group. The replica will not be deleted and replication will stop from and to this region.</p> </note> </li> <li> <p> <code>INACCESSIBLE_ENCRYPTION_CREDENTIALS </code> - The KMS key used to encrypt the table is inaccessible.</p> <note> <p>If the KMS key remains inaccessible for more than 20 hours, DynamoDB will remove this replica from the replication group. The replica will not be deleted and replication will stop from and to this region.</p> </note> </li> </ul>', 'ReplicaSettingsDescription$ReplicaStatus' => '<p>The current state of the Region:</p> <ul> <li> <p> <code>CREATING</code> - The Region is being created.</p> </li> <li> <p> <code>UPDATING</code> - The Region is being updated.</p> </li> <li> <p> <code>DELETING</code> - The Region is being deleted.</p> </li> <li> <p> <code>ACTIVE</code> - The Region is ready for use.</p> </li> </ul>', ], ], 'ReplicaStatusDescription' => [ 'base' => NULL, 'refs' => [ 'ReplicaDescription$ReplicaStatusDescription' => '<p>Detailed information about the replica status.</p>', ], ], 'ReplicaStatusPercentProgress' => [ 'base' => NULL, 'refs' => [ 'ReplicaDescription$ReplicaStatusPercentProgress' => '<p>Specifies the progress of a Create, Update, or Delete action on the replica as a percentage.</p>', ], ], 'ReplicaUpdate' => [ 'base' => '<p>Represents one of the following:</p> <ul> <li> <p>A new replica to be added to an existing global table.</p> </li> <li> <p>New parameters for an existing replica.</p> </li> <li> <p>An existing replica to be removed from an existing global table.</p> </li> </ul>', 'refs' => [ 'ReplicaUpdateList$member' => NULL, ], ], 'ReplicaUpdateList' => [ 'base' => NULL, 'refs' => [ 'UpdateGlobalTableInput$ReplicaUpdates' => '<p>A list of Regions that should be added or removed from the global table.</p>', ], ], 'ReplicationGroupUpdate' => [ 'base' => '<p>Represents one of the following:</p> <ul> <li> <p>A new replica to be added to an existing regional table or global table. This request invokes the <code>CreateTableReplica</code> action in the destination Region.</p> </li> <li> <p>New parameters for an existing replica. This request invokes the <code>UpdateTable</code> action in the destination Region.</p> </li> <li> <p>An existing replica to be deleted. The request invokes the <code>DeleteTableReplica</code> action in the destination Region, deleting the replica and all if its items in the destination Region.</p> </li> </ul>', 'refs' => [ 'ReplicationGroupUpdateList$member' => NULL, ], ], 'ReplicationGroupUpdateList' => [ 'base' => NULL, 'refs' => [ 'UpdateTableInput$ReplicaUpdates' => '<p>A list of replica update actions (create, delete, or update) for the table.</p> <note> <p>This property only applies to <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/globaltables.V2.html">Version 2019.11.21</a> of global tables.</p> </note>', ], ], 'RequestLimitExceeded' => [ 'base' => '<p>Throughput exceeds the current throughput quota for your account. Please contact <a href="https://aws.amazon.com/support">Amazon Web Services Support</a> to request a quota increase.</p>', 'refs' => [], ], 'ResourceArnString' => [ 'base' => NULL, 'refs' => [ 'ListTagsOfResourceInput$ResourceArn' => '<p>The Amazon DynamoDB resource with tags to be listed. This value is an Amazon Resource Name (ARN).</p>', 'TagResourceInput$ResourceArn' => '<p>Identifies the Amazon DynamoDB resource to which tags should be added. This value is an Amazon Resource Name (ARN).</p>', 'UntagResourceInput$ResourceArn' => '<p>The DynamoDB resource that the tags will be removed from. This value is an Amazon Resource Name (ARN).</p>', ], ], 'ResourceInUseException' => [ 'base' => '<p>The operation conflicts with the resource\'s availability. For example, you attempted to recreate an existing table, or tried to delete a table currently in the <code>CREATING</code> state.</p>', 'refs' => [], ], 'ResourceNotFoundException' => [ 'base' => '<p>The operation tried to access a nonexistent table or index. The resource might not be specified correctly, or its status might not be <code>ACTIVE</code>.</p>', 'refs' => [], ], 'RestoreInProgress' => [ 'base' => NULL, 'refs' => [ 'RestoreSummary$RestoreInProgress' => '<p>Indicates if a restore is in progress or not.</p>', ], ], 'RestoreSummary' => [ 'base' => '<p>Contains details for the restore.</p>', 'refs' => [ 'TableDescription$RestoreSummary' => '<p>Contains details for the restore.</p>', ], ], 'RestoreTableFromBackupInput' => [ 'base' => NULL, 'refs' => [], ], 'RestoreTableFromBackupOutput' => [ 'base' => NULL, 'refs' => [], ], 'RestoreTableToPointInTimeInput' => [ 'base' => NULL, 'refs' => [], ], 'RestoreTableToPointInTimeOutput' => [ 'base' => NULL, 'refs' => [], ], 'ReturnConsumedCapacity' => [ 'base' => '<p>Determines the level of detail about either provisioned or on-demand throughput consumption that is returned in the response:</p> <ul> <li> <p> <code>INDEXES</code> - The response includes the aggregate <code>ConsumedCapacity</code> for the operation, together with <code>ConsumedCapacity</code> for each table and secondary index that was accessed.</p> <p>Note that some operations, such as <code>GetItem</code> and <code>BatchGetItem</code>, do not access any indexes at all. In these cases, specifying <code>INDEXES</code> will only return <code>ConsumedCapacity</code> information for table(s).</p> </li> <li> <p> <code>TOTAL</code> - The response includes only the aggregate <code>ConsumedCapacity</code> for the operation.</p> </li> <li> <p> <code>NONE</code> - No <code>ConsumedCapacity</code> details are included in the response.</p> </li> </ul>', 'refs' => [ 'BatchExecuteStatementInput$ReturnConsumedCapacity' => NULL, 'BatchGetItemInput$ReturnConsumedCapacity' => NULL, 'BatchWriteItemInput$ReturnConsumedCapacity' => NULL, 'DeleteItemInput$ReturnConsumedCapacity' => NULL, 'ExecuteStatementInput$ReturnConsumedCapacity' => NULL, 'ExecuteTransactionInput$ReturnConsumedCapacity' => '<p>Determines the level of detail about either provisioned or on-demand throughput consumption that is returned in the response. For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_TransactGetItems.html">TransactGetItems</a> and <a href="https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_TransactWriteItems.html">TransactWriteItems</a>.</p>', 'GetItemInput$ReturnConsumedCapacity' => NULL, 'PutItemInput$ReturnConsumedCapacity' => NULL, 'QueryInput$ReturnConsumedCapacity' => NULL, 'ScanInput$ReturnConsumedCapacity' => NULL, 'TransactGetItemsInput$ReturnConsumedCapacity' => '<p>A value of <code>TOTAL</code> causes consumed capacity information to be returned, and a value of <code>NONE</code> prevents that information from being returned. No other value is valid.</p>', 'TransactWriteItemsInput$ReturnConsumedCapacity' => NULL, 'UpdateItemInput$ReturnConsumedCapacity' => NULL, ], ], 'ReturnItemCollectionMetrics' => [ 'base' => NULL, 'refs' => [ 'BatchWriteItemInput$ReturnItemCollectionMetrics' => '<p>Determines whether item collection metrics are returned. If set to <code>SIZE</code>, the response includes statistics about item collections, if any, that were modified during the operation are returned in the response. If set to <code>NONE</code> (the default), no statistics are returned.</p>', 'DeleteItemInput$ReturnItemCollectionMetrics' => '<p>Determines whether item collection metrics are returned. If set to <code>SIZE</code>, the response includes statistics about item collections, if any, that were modified during the operation are returned in the response. If set to <code>NONE</code> (the default), no statistics are returned.</p>', 'PutItemInput$ReturnItemCollectionMetrics' => '<p>Determines whether item collection metrics are returned. If set to <code>SIZE</code>, the response includes statistics about item collections, if any, that were modified during the operation are returned in the response. If set to <code>NONE</code> (the default), no statistics are returned.</p>', 'TransactWriteItemsInput$ReturnItemCollectionMetrics' => '<p>Determines whether item collection metrics are returned. If set to <code>SIZE</code>, the response includes statistics about item collections (if any), that were modified during the operation and are returned in the response. If set to <code>NONE</code> (the default), no statistics are returned. </p>', 'UpdateItemInput$ReturnItemCollectionMetrics' => '<p>Determines whether item collection metrics are returned. If set to <code>SIZE</code>, the response includes statistics about item collections, if any, that were modified during the operation are returned in the response. If set to <code>NONE</code> (the default), no statistics are returned.</p>', ], ], 'ReturnValue' => [ 'base' => NULL, 'refs' => [ 'DeleteItemInput$ReturnValues' => '<p>Use <code>ReturnValues</code> if you want to get the item attributes as they appeared before they were deleted. For <code>DeleteItem</code>, the valid values are:</p> <ul> <li> <p> <code>NONE</code> - If <code>ReturnValues</code> is not specified, or if its value is <code>NONE</code>, then nothing is returned. (This setting is the default for <code>ReturnValues</code>.)</p> </li> <li> <p> <code>ALL_OLD</code> - The content of the old item is returned.</p> </li> </ul> <note> <p>The <code>ReturnValues</code> parameter is used by several DynamoDB operations; however, <code>DeleteItem</code> does not recognize any values other than <code>NONE</code> or <code>ALL_OLD</code>.</p> </note>', 'PutItemInput$ReturnValues' => '<p>Use <code>ReturnValues</code> if you want to get the item attributes as they appeared before they were updated with the <code>PutItem</code> request. For <code>PutItem</code>, the valid values are:</p> <ul> <li> <p> <code>NONE</code> - If <code>ReturnValues</code> is not specified, or if its value is <code>NONE</code>, then nothing is returned. (This setting is the default for <code>ReturnValues</code>.)</p> </li> <li> <p> <code>ALL_OLD</code> - If <code>PutItem</code> overwrote an attribute name-value pair, then the content of the old item is returned.</p> </li> </ul> <p>The values returned are strongly consistent.</p> <note> <p>The <code>ReturnValues</code> parameter is used by several DynamoDB operations; however, <code>PutItem</code> does not recognize any values other than <code>NONE</code> or <code>ALL_OLD</code>.</p> </note>', 'UpdateItemInput$ReturnValues' => '<p>Use <code>ReturnValues</code> if you want to get the item attributes as they appear before or after they are updated. For <code>UpdateItem</code>, the valid values are:</p> <ul> <li> <p> <code>NONE</code> - If <code>ReturnValues</code> is not specified, or if its value is <code>NONE</code>, then nothing is returned. (This setting is the default for <code>ReturnValues</code>.)</p> </li> <li> <p> <code>ALL_OLD</code> - Returns all of the attributes of the item, as they appeared before the UpdateItem operation.</p> </li> <li> <p> <code>UPDATED_OLD</code> - Returns only the updated attributes, as they appeared before the UpdateItem operation.</p> </li> <li> <p> <code>ALL_NEW</code> - Returns all of the attributes of the item, as they appear after the UpdateItem operation.</p> </li> <li> <p> <code>UPDATED_NEW</code> - Returns only the updated attributes, as they appear after the UpdateItem operation.</p> </li> </ul> <p>There is no additional cost associated with requesting a return value aside from the small network and processing overhead of receiving a larger response. No read capacity units are consumed.</p> <p>The values returned are strongly consistent.</p>', ], ], 'ReturnValuesOnConditionCheckFailure' => [ 'base' => NULL, 'refs' => [ 'ConditionCheck$ReturnValuesOnConditionCheckFailure' => '<p>Use <code>ReturnValuesOnConditionCheckFailure</code> to get the item attributes if the <code>ConditionCheck</code> condition fails. For <code>ReturnValuesOnConditionCheckFailure</code>, the valid values are: NONE and ALL_OLD.</p>', 'Delete$ReturnValuesOnConditionCheckFailure' => '<p>Use <code>ReturnValuesOnConditionCheckFailure</code> to get the item attributes if the <code>Delete</code> condition fails. For <code>ReturnValuesOnConditionCheckFailure</code>, the valid values are: NONE and ALL_OLD.</p>', 'Put$ReturnValuesOnConditionCheckFailure' => '<p>Use <code>ReturnValuesOnConditionCheckFailure</code> to get the item attributes if the <code>Put</code> condition fails. For <code>ReturnValuesOnConditionCheckFailure</code>, the valid values are: NONE and ALL_OLD.</p>', 'Update$ReturnValuesOnConditionCheckFailure' => '<p>Use <code>ReturnValuesOnConditionCheckFailure</code> to get the item attributes if the <code>Update</code> condition fails. For <code>ReturnValuesOnConditionCheckFailure</code>, the valid values are: NONE, ALL_OLD, UPDATED_OLD, ALL_NEW, UPDATED_NEW.</p>', ], ], 'S3Bucket' => [ 'base' => NULL, 'refs' => [ 'ExportDescription$S3Bucket' => '<p>The name of the Amazon S3 bucket containing the export.</p>', 'ExportTableToPointInTimeInput$S3Bucket' => '<p>The name of the Amazon S3 bucket to export the snapshot to.</p>', ], ], 'S3BucketOwner' => [ 'base' => NULL, 'refs' => [ 'ExportDescription$S3BucketOwner' => '<p>The ID of the Amazon Web Services account that owns the bucket containing the export.</p>', 'ExportTableToPointInTimeInput$S3BucketOwner' => '<p>The ID of the Amazon Web Services account that owns the bucket the export will be stored in.</p>', ], ], 'S3Prefix' => [ 'base' => NULL, 'refs' => [ 'ExportDescription$S3Prefix' => '<p>The Amazon S3 bucket prefix used as the file name and path of the exported snapshot.</p>', 'ExportTableToPointInTimeInput$S3Prefix' => '<p>The Amazon S3 bucket prefix to use as the file name and path of the exported snapshot.</p>', ], ], 'S3SseAlgorithm' => [ 'base' => NULL, 'refs' => [ 'ExportDescription$S3SseAlgorithm' => '<p>Type of encryption used on the bucket where export data is stored. Valid values for <code>S3SseAlgorithm</code> are:</p> <ul> <li> <p> <code>AES256</code> - server-side encryption with Amazon S3 managed keys</p> </li> <li> <p> <code>KMS</code> - server-side encryption with KMS managed keys</p> </li> </ul>', 'ExportTableToPointInTimeInput$S3SseAlgorithm' => '<p>Type of encryption used on the bucket where export data will be stored. Valid values for <code>S3SseAlgorithm</code> are:</p> <ul> <li> <p> <code>AES256</code> - server-side encryption with Amazon S3 managed keys</p> </li> <li> <p> <code>KMS</code> - server-side encryption with KMS managed keys</p> </li> </ul>', ], ], 'S3SseKmsKeyId' => [ 'base' => NULL, 'refs' => [ 'ExportDescription$S3SseKmsKeyId' => '<p>The ID of the KMS managed key used to encrypt the S3 bucket where export data is stored (if applicable).</p>', 'ExportTableToPointInTimeInput$S3SseKmsKeyId' => '<p>The ID of the KMS managed key used to encrypt the S3 bucket where export data will be stored (if applicable).</p>', ], ], 'SSEDescription' => [ 'base' => '<p>The description of the server-side encryption status on the specified table.</p>', 'refs' => [ 'SourceTableFeatureDetails$SSEDescription' => '<p>The description of the server-side encryption status on the table when the backup was created.</p>', 'TableDescription$SSEDescription' => '<p>The description of the server-side encryption status on the specified table.</p>', ], ], 'SSEEnabled' => [ 'base' => NULL, 'refs' => [ 'SSESpecification$Enabled' => '<p>Indicates whether server-side encryption is done using an Amazon Web Services managed key or an Amazon Web Services owned key. If enabled (true), server-side encryption type is set to <code>KMS</code> and an Amazon Web Services managed key is used (KMS charges apply). If disabled (false) or not specified, server-side encryption is set to Amazon Web Services owned key.</p>', ], ], 'SSESpecification' => [ 'base' => '<p>Represents the settings used to enable server-side encryption.</p>', 'refs' => [ 'CreateTableInput$SSESpecification' => '<p>Represents the settings used to enable server-side encryption.</p>', 'RestoreTableFromBackupInput$SSESpecificationOverride' => '<p>The new server-side encryption settings for the restored table.</p>', 'RestoreTableToPointInTimeInput$SSESpecificationOverride' => '<p>The new server-side encryption settings for the restored table.</p>', 'UpdateTableInput$SSESpecification' => '<p>The new server-side encryption settings for the specified table.</p>', ], ], 'SSEStatus' => [ 'base' => NULL, 'refs' => [ 'SSEDescription$Status' => '<p>Represents the current state of server-side encryption. The only supported values are:</p> <ul> <li> <p> <code>ENABLED</code> - Server-side encryption is enabled.</p> </li> <li> <p> <code>UPDATING</code> - Server-side encryption is being updated.</p> </li> </ul>', ], ], 'SSEType' => [ 'base' => NULL, 'refs' => [ 'SSEDescription$SSEType' => '<p>Server-side encryption type. The only supported value is:</p> <ul> <li> <p> <code>KMS</code> - Server-side encryption that uses Key Management Service. The key is stored in your account and is managed by KMS (KMS charges apply).</p> </li> </ul>', 'SSESpecification$SSEType' => '<p>Server-side encryption type. The only supported value is:</p> <ul> <li> <p> <code>KMS</code> - Server-side encryption that uses Key Management Service. The key is stored in your account and is managed by KMS (KMS charges apply).</p> </li> </ul>', ], ], 'ScalarAttributeType' => [ 'base' => NULL, 'refs' => [ 'AttributeDefinition$AttributeType' => '<p>The data type for the attribute, where:</p> <ul> <li> <p> <code>S</code> - the attribute is of type String</p> </li> <li> <p> <code>N</code> - the attribute is of type Number</p> </li> <li> <p> <code>B</code> - the attribute is of type Binary</p> </li> </ul>', ], ], 'ScanInput' => [ 'base' => '<p>Represents the input of a <code>Scan</code> operation.</p>', 'refs' => [], ], 'ScanOutput' => [ 'base' => '<p>Represents the output of a <code>Scan</code> operation.</p>', 'refs' => [], ], 'ScanSegment' => [ 'base' => NULL, 'refs' => [ 'ScanInput$Segment' => '<p>For a parallel <code>Scan</code> request, <code>Segment</code> identifies an individual segment to be scanned by an application worker.</p> <p>Segment IDs are zero-based, so the first segment is always 0. For example, if you want to use four application threads to scan a table or an index, then the first thread specifies a <code>Segment</code> value of 0, the second thread specifies 1, and so on.</p> <p>The value of <code>LastEvaluatedKey</code> returned from a parallel <code>Scan</code> request must be used as <code>ExclusiveStartKey</code> with the same segment ID in a subsequent <code>Scan</code> operation.</p> <p>The value for <code>Segment</code> must be greater than or equal to 0, and less than the value provided for <code>TotalSegments</code>.</p> <p>If you provide <code>Segment</code>, you must also provide <code>TotalSegments</code>.</p>', ], ], 'ScanTotalSegments' => [ 'base' => NULL, 'refs' => [ 'ScanInput$TotalSegments' => '<p>For a parallel <code>Scan</code> request, <code>TotalSegments</code> represents the total number of segments into which the <code>Scan</code> operation will be divided. The value of <code>TotalSegments</code> corresponds to the number of application workers that will perform the parallel scan. For example, if you want to use four application threads to scan a table or an index, specify a <code>TotalSegments</code> value of 4.</p> <p>The value for <code>TotalSegments</code> must be greater than or equal to 1, and less than or equal to 1000000. If you specify a <code>TotalSegments</code> value of 1, the <code>Scan</code> operation will be sequential rather than parallel.</p> <p>If you specify <code>TotalSegments</code>, you must also specify <code>Segment</code>.</p>', ], ], 'SecondaryIndexesCapacityMap' => [ 'base' => NULL, 'refs' => [ 'ConsumedCapacity$LocalSecondaryIndexes' => '<p>The amount of throughput consumed on each local index affected by the operation.</p>', 'ConsumedCapacity$GlobalSecondaryIndexes' => '<p>The amount of throughput consumed on each global index affected by the operation.</p>', ], ], 'Select' => [ 'base' => NULL, 'refs' => [ 'QueryInput$Select' => '<p>The attributes to be returned in the result. You can retrieve all item attributes, specific item attributes, the count of matching items, or in the case of an index, some or all of the attributes projected into the index.</p> <ul> <li> <p> <code>ALL_ATTRIBUTES</code> - Returns all of the item attributes from the specified table or index. If you query a local secondary index, then for each matching item in the index, DynamoDB fetches the entire item from the parent table. If the index is configured to project all item attributes, then all of the data can be obtained from the local secondary index, and no fetching is required.</p> </li> <li> <p> <code>ALL_PROJECTED_ATTRIBUTES</code> - Allowed only when querying an index. Retrieves all attributes that have been projected into the index. If the index is configured to project all attributes, this return value is equivalent to specifying <code>ALL_ATTRIBUTES</code>.</p> </li> <li> <p> <code>COUNT</code> - Returns the number of matching items, rather than the matching items themselves.</p> </li> <li> <p> <code>SPECIFIC_ATTRIBUTES</code> - Returns only the attributes listed in <code>AttributesToGet</code>. This return value is equivalent to specifying <code>AttributesToGet</code> without specifying any value for <code>Select</code>.</p> <p>If you query or scan a local secondary index and request only attributes that are projected into that index, the operation will read only the index and not the table. If any of the requested attributes are not projected into the local secondary index, DynamoDB fetches each of these attributes from the parent table. This extra fetching incurs additional throughput cost and latency.</p> <p>If you query or scan a global secondary index, you can only request attributes that are projected into the index. Global secondary index queries cannot fetch attributes from the parent table.</p> </li> </ul> <p>If neither <code>Select</code> nor <code>AttributesToGet</code> are specified, DynamoDB defaults to <code>ALL_ATTRIBUTES</code> when accessing a table, and <code>ALL_PROJECTED_ATTRIBUTES</code> when accessing an index. You cannot use both <code>Select</code> and <code>AttributesToGet</code> together in a single request, unless the value for <code>Select</code> is <code>SPECIFIC_ATTRIBUTES</code>. (This usage is equivalent to specifying <code>AttributesToGet</code> without any value for <code>Select</code>.)</p> <note> <p>If you use the <code>ProjectionExpression</code> parameter, then the value for <code>Select</code> can only be <code>SPECIFIC_ATTRIBUTES</code>. Any other value for <code>Select</code> will return an error.</p> </note>', 'ScanInput$Select' => '<p>The attributes to be returned in the result. You can retrieve all item attributes, specific item attributes, the count of matching items, or in the case of an index, some or all of the attributes projected into the index.</p> <ul> <li> <p> <code>ALL_ATTRIBUTES</code> - Returns all of the item attributes from the specified table or index. If you query a local secondary index, then for each matching item in the index, DynamoDB fetches the entire item from the parent table. If the index is configured to project all item attributes, then all of the data can be obtained from the local secondary index, and no fetching is required.</p> </li> <li> <p> <code>ALL_PROJECTED_ATTRIBUTES</code> - Allowed only when querying an index. Retrieves all attributes that have been projected into the index. If the index is configured to project all attributes, this return value is equivalent to specifying <code>ALL_ATTRIBUTES</code>.</p> </li> <li> <p> <code>COUNT</code> - Returns the number of matching items, rather than the matching items themselves.</p> </li> <li> <p> <code>SPECIFIC_ATTRIBUTES</code> - Returns only the attributes listed in <code>AttributesToGet</code>. This return value is equivalent to specifying <code>AttributesToGet</code> without specifying any value for <code>Select</code>.</p> <p>If you query or scan a local secondary index and request only attributes that are projected into that index, the operation reads only the index and not the table. If any of the requested attributes are not projected into the local secondary index, DynamoDB fetches each of these attributes from the parent table. This extra fetching incurs additional throughput cost and latency.</p> <p>If you query or scan a global secondary index, you can only request attributes that are projected into the index. Global secondary index queries cannot fetch attributes from the parent table.</p> </li> </ul> <p>If neither <code>Select</code> nor <code>AttributesToGet</code> are specified, DynamoDB defaults to <code>ALL_ATTRIBUTES</code> when accessing a table, and <code>ALL_PROJECTED_ATTRIBUTES</code> when accessing an index. You cannot use both <code>Select</code> and <code>AttributesToGet</code> together in a single request, unless the value for <code>Select</code> is <code>SPECIFIC_ATTRIBUTES</code>. (This usage is equivalent to specifying <code>AttributesToGet</code> without any value for <code>Select</code>.)</p> <note> <p>If you use the <code>ProjectionExpression</code> parameter, then the value for <code>Select</code> can only be <code>SPECIFIC_ATTRIBUTES</code>. Any other value for <code>Select</code> will return an error.</p> </note>', ], ], 'SourceTableDetails' => [ 'base' => '<p>Contains the details of the table when the backup was created. </p>', 'refs' => [ 'BackupDescription$SourceTableDetails' => '<p>Contains the details of the table when the backup was created. </p>', ], ], 'SourceTableFeatureDetails' => [ 'base' => '<p>Contains the details of the features enabled on the table when the backup was created. For example, LSIs, GSIs, streams, TTL. </p>', 'refs' => [ 'BackupDescription$SourceTableFeatureDetails' => '<p>Contains the details of the features enabled on the table when the backup was created. For example, LSIs, GSIs, streams, TTL.</p>', ], ], 'StreamArn' => [ 'base' => NULL, 'refs' => [ 'KinesisDataStreamDestination$StreamArn' => '<p>The ARN for a specific Kinesis data stream.</p>', 'KinesisStreamingDestinationInput$StreamArn' => '<p>The ARN for a Kinesis data stream.</p>', 'KinesisStreamingDestinationOutput$StreamArn' => '<p>The ARN for the specific Kinesis data stream.</p>', 'TableDescription$LatestStreamArn' => '<p>The Amazon Resource Name (ARN) that uniquely identifies the latest stream for this table.</p>', ], ], 'StreamEnabled' => [ 'base' => NULL, 'refs' => [ 'StreamSpecification$StreamEnabled' => '<p>Indicates whether DynamoDB Streams is enabled (true) or disabled (false) on the table.</p>', ], ], 'StreamSpecification' => [ 'base' => '<p>Represents the DynamoDB Streams configuration for a table in DynamoDB.</p>', 'refs' => [ 'CreateTableInput$StreamSpecification' => '<p>The settings for DynamoDB Streams on the table. These settings consist of:</p> <ul> <li> <p> <code>StreamEnabled</code> - Indicates whether DynamoDB Streams is to be enabled (true) or disabled (false).</p> </li> <li> <p> <code>StreamViewType</code> - When an item in the table is modified, <code>StreamViewType</code> determines what information is written to the table\'s stream. Valid values for <code>StreamViewType</code> are:</p> <ul> <li> <p> <code>KEYS_ONLY</code> - Only the key attributes of the modified item are written to the stream.</p> </li> <li> <p> <code>NEW_IMAGE</code> - The entire item, as it appears after it was modified, is written to the stream.</p> </li> <li> <p> <code>OLD_IMAGE</code> - The entire item, as it appeared before it was modified, is written to the stream.</p> </li> <li> <p> <code>NEW_AND_OLD_IMAGES</code> - Both the new and the old item images of the item are written to the stream.</p> </li> </ul> </li> </ul>', 'SourceTableFeatureDetails$StreamDescription' => '<p>Stream settings on the table when the backup was created.</p>', 'TableDescription$StreamSpecification' => '<p>The current DynamoDB Streams configuration for the table.</p>', 'UpdateTableInput$StreamSpecification' => '<p>Represents the DynamoDB Streams configuration for the table.</p> <note> <p>You receive a <code>ResourceInUseException</code> if you try to enable a stream on a table that already has a stream, or if you try to disable a stream on a table that doesn\'t have a stream.</p> </note>', ], ], 'StreamViewType' => [ 'base' => NULL, 'refs' => [ 'StreamSpecification$StreamViewType' => '<p> When an item in the table is modified, <code>StreamViewType</code> determines what information is written to the stream for this table. Valid values for <code>StreamViewType</code> are:</p> <ul> <li> <p> <code>KEYS_ONLY</code> - Only the key attributes of the modified item are written to the stream.</p> </li> <li> <p> <code>NEW_IMAGE</code> - The entire item, as it appears after it was modified, is written to the stream.</p> </li> <li> <p> <code>OLD_IMAGE</code> - The entire item, as it appeared before it was modified, is written to the stream.</p> </li> <li> <p> <code>NEW_AND_OLD_IMAGES</code> - Both the new and the old item images of the item are written to the stream.</p> </li> </ul>', ], ], 'String' => [ 'base' => NULL, 'refs' => [ 'AutoScalingSettingsDescription$AutoScalingRoleArn' => '<p>Role ARN used for configuring the auto scaling policy.</p>', 'BatchStatementError$Message' => '<p> The error message associated with the PartiQL batch resposne. </p>', 'Endpoint$Address' => '<p>IP address of the endpoint.</p>', 'GlobalSecondaryIndexDescription$IndexArn' => '<p>The Amazon Resource Name (ARN) that uniquely identifies the index.</p>', 'KinesisDataStreamDestination$DestinationStatusDescription' => '<p>The human-readable string that corresponds to the replica status.</p>', 'LocalSecondaryIndexDescription$IndexArn' => '<p>The Amazon Resource Name (ARN) that uniquely identifies the index.</p>', 'TableDescription$TableArn' => '<p>The Amazon Resource Name (ARN) that uniquely identifies the table.</p>', 'TableDescription$LatestStreamLabel' => '<p>A timestamp, in ISO 8601 format, for this stream.</p> <p>Note that <code>LatestStreamLabel</code> is not a unique identifier for the stream, because it is possible that a stream from another table might have the same timestamp. However, the combination of the following three elements is guaranteed to be unique:</p> <ul> <li> <p>Amazon Web Services customer ID</p> </li> <li> <p>Table name</p> </li> <li> <p> <code>StreamLabel</code> </p> </li> </ul>', 'TableDescription$GlobalTableVersion' => '<p>Represents the version of <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/GlobalTables.html">global tables</a> in use, if the table is replicated across Amazon Web Services Regions.</p>', ], ], 'StringAttributeValue' => [ 'base' => NULL, 'refs' => [ 'AttributeValue$S' => '<p>An attribute of type String. For example:</p> <p> <code>"S": "Hello"</code> </p>', 'StringSetAttributeValue$member' => NULL, ], ], 'StringSetAttributeValue' => [ 'base' => NULL, 'refs' => [ 'AttributeValue$SS' => '<p>An attribute of type String Set. For example:</p> <p> <code>"SS": ["Giraffe", "Hippo" ,"Zebra"]</code> </p>', ], ], 'TableAlreadyExistsException' => [ 'base' => '<p>A target table with the specified name already exists. </p>', 'refs' => [], ], 'TableArn' => [ 'base' => NULL, 'refs' => [ 'BackupSummary$TableArn' => '<p>ARN associated with the table.</p>', 'ExportDescription$TableArn' => '<p>The Amazon Resource Name (ARN) of the table that was exported.</p>', 'ExportTableToPointInTimeInput$TableArn' => '<p>The Amazon Resource Name (ARN) associated with the table to export.</p>', 'ListExportsInput$TableArn' => '<p>The Amazon Resource Name (ARN) associated with the exported table.</p>', 'RestoreSummary$SourceTableArn' => '<p>The ARN of the source table of the backup that is being restored.</p>', 'RestoreTableToPointInTimeInput$SourceTableArn' => '<p>The DynamoDB table that will be restored. This value is an Amazon Resource Name (ARN).</p>', 'SourceTableDetails$TableArn' => '<p>ARN of the table for which backup was created. </p>', ], ], 'TableAutoScalingDescription' => [ 'base' => '<p>Represents the auto scaling configuration for a global table.</p>', 'refs' => [ 'DescribeTableReplicaAutoScalingOutput$TableAutoScalingDescription' => '<p>Represents the auto scaling properties of the table.</p>', 'UpdateTableReplicaAutoScalingOutput$TableAutoScalingDescription' => '<p>Returns information about the auto scaling settings of a table with replicas.</p>', ], ], 'TableClass' => [ 'base' => NULL, 'refs' => [ 'CreateReplicationGroupMemberAction$TableClassOverride' => '<p>Replica-specific table class. If not specified, uses the source table\'s table class.</p>', 'CreateTableInput$TableClass' => '<p>The table class of the new table. Valid values are <code>STANDARD</code> and <code>STANDARD_INFREQUENT_ACCESS</code>.</p>', 'ReplicaSettingsUpdate$ReplicaTableClass' => '<p>Replica-specific table class. If not specified, uses the source table\'s table class.</p>', 'TableClassSummary$TableClass' => '<p>The table class of the specified table. Valid values are <code>STANDARD</code> and <code>STANDARD_INFREQUENT_ACCESS</code>.</p>', 'UpdateReplicationGroupMemberAction$TableClassOverride' => '<p>Replica-specific table class. If not specified, uses the source table\'s table class.</p>', 'UpdateTableInput$TableClass' => '<p>The table class of the table to be updated. Valid values are <code>STANDARD</code> and <code>STANDARD_INFREQUENT_ACCESS</code>.</p>', ], ], 'TableClassSummary' => [ 'base' => '<p>Contains details of the table class.</p>', 'refs' => [ 'ReplicaDescription$ReplicaTableClassSummary' => NULL, 'ReplicaSettingsDescription$ReplicaTableClassSummary' => NULL, 'TableDescription$TableClassSummary' => '<p>Contains details of the table class.</p>', ], ], 'TableCreationDateTime' => [ 'base' => NULL, 'refs' => [ 'SourceTableDetails$TableCreationDateTime' => '<p>Time when the source table was created. </p>', ], ], 'TableDescription' => [ 'base' => '<p>Represents the properties of a table.</p>', 'refs' => [ 'CreateTableOutput$TableDescription' => '<p>Represents the properties of the table.</p>', 'DeleteTableOutput$TableDescription' => '<p>Represents the properties of a table.</p>', 'DescribeTableOutput$Table' => '<p>The properties of the table.</p>', 'RestoreTableFromBackupOutput$TableDescription' => '<p>The description of the table created from an existing backup.</p>', 'RestoreTableToPointInTimeOutput$TableDescription' => '<p>Represents the properties of a table.</p>', 'UpdateTableOutput$TableDescription' => '<p>Represents the properties of the table.</p>', ], ], 'TableId' => [ 'base' => NULL, 'refs' => [ 'BackupSummary$TableId' => '<p>Unique identifier for the table.</p>', 'ExportDescription$TableId' => '<p>Unique ID of the table that was exported.</p>', 'SourceTableDetails$TableId' => '<p>Unique identifier for the table for which the backup was created. </p>', 'TableDescription$TableId' => '<p>Unique identifier for the table for which the backup was created. </p>', ], ], 'TableInUseException' => [ 'base' => '<p>A target table with the specified name is either being created or deleted. </p>', 'refs' => [], ], 'TableName' => [ 'base' => NULL, 'refs' => [ 'BackupSummary$TableName' => '<p>Name of the table.</p>', 'BatchGetRequestMap$key' => NULL, 'BatchGetResponseMap$key' => NULL, 'BatchStatementResponse$TableName' => '<p> The table name associated with a failed PartiQL batch statement. </p>', 'BatchWriteItemRequestMap$key' => NULL, 'ConditionCheck$TableName' => '<p>Name of the table for the check item request.</p>', 'ConsumedCapacity$TableName' => '<p>The name of the table that was affected by the operation.</p>', 'ContributorInsightsSummary$TableName' => '<p>Name of the table associated with the summary.</p>', 'CreateBackupInput$TableName' => '<p>The name of the table.</p>', 'CreateGlobalTableInput$GlobalTableName' => '<p>The global table name.</p>', 'CreateTableInput$TableName' => '<p>The name of the table to create.</p>', 'Delete$TableName' => '<p>Name of the table in which the item to be deleted resides.</p>', 'DeleteItemInput$TableName' => '<p>The name of the table from which to delete the item.</p>', 'DeleteTableInput$TableName' => '<p>The name of the table to delete.</p>', 'DescribeContinuousBackupsInput$TableName' => '<p>Name of the table for which the customer wants to check the continuous backups and point in time recovery settings.</p>', 'DescribeContributorInsightsInput$TableName' => '<p>The name of the table to describe.</p>', 'DescribeContributorInsightsOutput$TableName' => '<p>The name of the table being described.</p>', 'DescribeGlobalTableInput$GlobalTableName' => '<p>The name of the global table.</p>', 'DescribeGlobalTableSettingsInput$GlobalTableName' => '<p>The name of the global table to describe.</p>', 'DescribeGlobalTableSettingsOutput$GlobalTableName' => '<p>The name of the global table.</p>', 'DescribeKinesisStreamingDestinationInput$TableName' => '<p>The name of the table being described.</p>', 'DescribeKinesisStreamingDestinationOutput$TableName' => '<p>The name of the table being described.</p>', 'DescribeTableInput$TableName' => '<p>The name of the table to describe.</p>', 'DescribeTableReplicaAutoScalingInput$TableName' => '<p>The name of the table.</p>', 'DescribeTimeToLiveInput$TableName' => '<p>The name of the table to be described.</p>', 'Get$TableName' => '<p>The name of the table from which to retrieve the specified item.</p>', 'GetItemInput$TableName' => '<p>The name of the table containing the requested item.</p>', 'GlobalTable$GlobalTableName' => '<p>The global table name.</p>', 'GlobalTableDescription$GlobalTableName' => '<p>The global table name.</p>', 'ItemCollectionMetricsPerTable$key' => NULL, 'KinesisStreamingDestinationInput$TableName' => '<p>The name of the DynamoDB table.</p>', 'KinesisStreamingDestinationOutput$TableName' => '<p>The name of the table being modified.</p>', 'ListBackupsInput$TableName' => '<p>The backups from the table specified by <code>TableName</code> are listed. </p>', 'ListContributorInsightsInput$TableName' => '<p>The name of the table.</p>', 'ListGlobalTablesInput$ExclusiveStartGlobalTableName' => '<p>The first global table name that this operation will evaluate.</p>', 'ListGlobalTablesOutput$LastEvaluatedGlobalTableName' => '<p>Last evaluated global table name.</p>', 'ListTablesInput$ExclusiveStartTableName' => '<p>The first table name that this operation will evaluate. Use the value that was returned for <code>LastEvaluatedTableName</code> in a previous operation, so that you can obtain the next page of results.</p>', 'ListTablesOutput$LastEvaluatedTableName' => '<p>The name of the last table in the current page of results. Use this value as the <code>ExclusiveStartTableName</code> in a new request to obtain the next page of results, until all the table names are returned.</p> <p>If you do not receive a <code>LastEvaluatedTableName</code> value in the response, this means that there are no more table names to be retrieved.</p>', 'Put$TableName' => '<p>Name of the table in which to write the item.</p>', 'PutItemInput$TableName' => '<p>The name of the table to contain the item.</p>', 'QueryInput$TableName' => '<p>The name of the table containing the requested items.</p>', 'RestoreTableFromBackupInput$TargetTableName' => '<p>The name of the new table to which the backup must be restored.</p>', 'RestoreTableToPointInTimeInput$SourceTableName' => '<p>Name of the source table that is being restored.</p>', 'RestoreTableToPointInTimeInput$TargetTableName' => '<p>The name of the new table to which it must be restored to.</p>', 'ScanInput$TableName' => '<p>The name of the table containing the requested items; or, if you provide <code>IndexName</code>, the name of the table to which that index belongs.</p>', 'SourceTableDetails$TableName' => '<p>The name of the table for which the backup was created. </p>', 'TableAutoScalingDescription$TableName' => '<p>The name of the table.</p>', 'TableDescription$TableName' => '<p>The name of the table.</p>', 'TableNameList$member' => NULL, 'Update$TableName' => '<p>Name of the table for the <code>UpdateItem</code> request.</p>', 'UpdateContinuousBackupsInput$TableName' => '<p>The name of the table.</p>', 'UpdateContributorInsightsInput$TableName' => '<p>The name of the table.</p>', 'UpdateContributorInsightsOutput$TableName' => '<p>The name of the table.</p>', 'UpdateGlobalTableInput$GlobalTableName' => '<p>The global table name.</p>', 'UpdateGlobalTableSettingsInput$GlobalTableName' => '<p>The name of the global table</p>', 'UpdateGlobalTableSettingsOutput$GlobalTableName' => '<p>The name of the global table.</p>', 'UpdateItemInput$TableName' => '<p>The name of the table containing the item to update.</p>', 'UpdateTableInput$TableName' => '<p>The name of the table to be updated.</p>', 'UpdateTableReplicaAutoScalingInput$TableName' => '<p>The name of the global table to be updated.</p>', 'UpdateTimeToLiveInput$TableName' => '<p>The name of the table to be configured.</p>', ], ], 'TableNameList' => [ 'base' => NULL, 'refs' => [ 'ListTablesOutput$TableNames' => '<p>The names of the tables associated with the current account at the current endpoint. The maximum size of this array is 100.</p> <p>If <code>LastEvaluatedTableName</code> also appears in the output, you can use this value as the <code>ExclusiveStartTableName</code> parameter in a subsequent <code>ListTables</code> request and obtain the next page of results.</p>', ], ], 'TableNotFoundException' => [ 'base' => '<p>A source table with the name <code>TableName</code> does not currently exist within the subscriber\'s account.</p>', 'refs' => [], ], 'TableStatus' => [ 'base' => NULL, 'refs' => [ 'TableAutoScalingDescription$TableStatus' => '<p>The current state of the table:</p> <ul> <li> <p> <code>CREATING</code> - The table is being created.</p> </li> <li> <p> <code>UPDATING</code> - The table is being updated.</p> </li> <li> <p> <code>DELETING</code> - The table is being deleted.</p> </li> <li> <p> <code>ACTIVE</code> - The table is ready for use.</p> </li> </ul>', 'TableDescription$TableStatus' => '<p>The current state of the table:</p> <ul> <li> <p> <code>CREATING</code> - The table is being created.</p> </li> <li> <p> <code>UPDATING</code> - The table is being updated.</p> </li> <li> <p> <code>DELETING</code> - The table is being deleted.</p> </li> <li> <p> <code>ACTIVE</code> - The table is ready for use.</p> </li> <li> <p> <code>INACCESSIBLE_ENCRYPTION_CREDENTIALS</code> - The KMS key used to encrypt the table in inaccessible. Table operations may fail due to failure to use the KMS key. DynamoDB will initiate the table archival process when a table\'s KMS key remains inaccessible for more than seven days. </p> </li> <li> <p> <code>ARCHIVING</code> - The table is being archived. Operations are not allowed until archival is complete. </p> </li> <li> <p> <code>ARCHIVED</code> - The table has been archived. See the ArchivalReason for more information. </p> </li> </ul>', ], ], 'Tag' => [ 'base' => '<p>Describes a tag. A tag is a key-value pair. You can add up to 50 tags to a single DynamoDB table. </p> <p>Amazon Web Services-assigned tag names and values are automatically assigned the <code>aws:</code> prefix, which the user cannot assign. Amazon Web Services-assigned tag names do not count towards the tag limit of 50. User-assigned tag names have the prefix <code>user:</code> in the Cost Allocation Report. You cannot backdate the application of a tag.</p> <p>For an overview on tagging DynamoDB resources, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Tagging.html">Tagging for DynamoDB</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>', 'refs' => [ 'TagList$member' => NULL, ], ], 'TagKeyList' => [ 'base' => NULL, 'refs' => [ 'UntagResourceInput$TagKeys' => '<p>A list of tag keys. Existing tags of the resource whose keys are members of this list will be removed from the DynamoDB resource.</p>', ], ], 'TagKeyString' => [ 'base' => NULL, 'refs' => [ 'Tag$Key' => '<p>The key of the tag. Tag keys are case sensitive. Each DynamoDB table can only have up to one tag with the same key. If you try to add an existing tag (same key), the existing tag value will be updated to the new value.</p>', 'TagKeyList$member' => NULL, ], ], 'TagList' => [ 'base' => NULL, 'refs' => [ 'CreateTableInput$Tags' => '<p>A list of key-value pairs to label the table. For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Tagging.html">Tagging for DynamoDB</a>.</p>', 'ListTagsOfResourceOutput$Tags' => '<p>The tags currently associated with the Amazon DynamoDB resource.</p>', 'TagResourceInput$Tags' => '<p>The tags to be assigned to the Amazon DynamoDB resource.</p>', ], ], 'TagResourceInput' => [ 'base' => NULL, 'refs' => [], ], 'TagValueString' => [ 'base' => NULL, 'refs' => [ 'Tag$Value' => '<p>The value of the tag. Tag values are case-sensitive and can be null.</p>', ], ], 'TimeRangeLowerBound' => [ 'base' => NULL, 'refs' => [ 'ListBackupsInput$TimeRangeLowerBound' => '<p>Only backups created after this time are listed. <code>TimeRangeLowerBound</code> is inclusive.</p>', ], ], 'TimeRangeUpperBound' => [ 'base' => NULL, 'refs' => [ 'ListBackupsInput$TimeRangeUpperBound' => '<p>Only backups created before this time are listed. <code>TimeRangeUpperBound</code> is exclusive. </p>', ], ], 'TimeToLiveAttributeName' => [ 'base' => NULL, 'refs' => [ 'TimeToLiveDescription$AttributeName' => '<p> The name of the TTL attribute for items in the table.</p>', 'TimeToLiveSpecification$AttributeName' => '<p>The name of the TTL attribute used to store the expiration time for items in the table.</p>', ], ], 'TimeToLiveDescription' => [ 'base' => '<p>The description of the Time to Live (TTL) status on the specified table. </p>', 'refs' => [ 'DescribeTimeToLiveOutput$TimeToLiveDescription' => '<p/>', 'SourceTableFeatureDetails$TimeToLiveDescription' => '<p>Time to Live settings on the table when the backup was created.</p>', ], ], 'TimeToLiveEnabled' => [ 'base' => NULL, 'refs' => [ 'TimeToLiveSpecification$Enabled' => '<p>Indicates whether TTL is to be enabled (true) or disabled (false) on the table.</p>', ], ], 'TimeToLiveSpecification' => [ 'base' => '<p>Represents the settings used to enable or disable Time to Live (TTL) for the specified table.</p>', 'refs' => [ 'UpdateTimeToLiveInput$TimeToLiveSpecification' => '<p>Represents the settings used to enable or disable Time to Live for the specified table.</p>', 'UpdateTimeToLiveOutput$TimeToLiveSpecification' => '<p>Represents the output of an <code>UpdateTimeToLive</code> operation.</p>', ], ], 'TimeToLiveStatus' => [ 'base' => NULL, 'refs' => [ 'TimeToLiveDescription$TimeToLiveStatus' => '<p> The TTL status for the table.</p>', ], ], 'TransactGetItem' => [ 'base' => '<p>Specifies an item to be retrieved as part of the transaction.</p>', 'refs' => [ 'TransactGetItemList$member' => NULL, ], ], 'TransactGetItemList' => [ 'base' => NULL, 'refs' => [ 'TransactGetItemsInput$TransactItems' => '<p>An ordered array of up to 25 <code>TransactGetItem</code> objects, each of which contains a <code>Get</code> structure.</p>', ], ], 'TransactGetItemsInput' => [ 'base' => NULL, 'refs' => [], ], 'TransactGetItemsOutput' => [ 'base' => NULL, 'refs' => [], ], 'TransactWriteItem' => [ 'base' => '<p>A list of requests that can perform update, put, delete, or check operations on multiple items in one or more tables atomically.</p>', 'refs' => [ 'TransactWriteItemList$member' => NULL, ], ], 'TransactWriteItemList' => [ 'base' => NULL, 'refs' => [ 'TransactWriteItemsInput$TransactItems' => '<p>An ordered array of up to 25 <code>TransactWriteItem</code> objects, each of which contains a <code>ConditionCheck</code>, <code>Put</code>, <code>Update</code>, or <code>Delete</code> object. These can operate on items in different tables, but the tables must reside in the same Amazon Web Services account and Region, and no two of them can operate on the same item. </p>', ], ], 'TransactWriteItemsInput' => [ 'base' => NULL, 'refs' => [], ], 'TransactWriteItemsOutput' => [ 'base' => NULL, 'refs' => [], ], 'TransactionCanceledException' => [ 'base' => '<p>The entire transaction request was canceled.</p> <p>DynamoDB cancels a <code>TransactWriteItems</code> request under the following circumstances:</p> <ul> <li> <p>A condition in one of the condition expressions is not met.</p> </li> <li> <p>A table in the <code>TransactWriteItems</code> request is in a different account or region.</p> </li> <li> <p>More than one action in the <code>TransactWriteItems</code> operation targets the same item.</p> </li> <li> <p>There is insufficient provisioned capacity for the transaction to be completed.</p> </li> <li> <p>An item size becomes too large (larger than 400 KB), or a local secondary index (LSI) becomes too large, or a similar validation error occurs because of changes made by the transaction.</p> </li> <li> <p>There is a user error, such as an invalid data format.</p> </li> </ul> <p>DynamoDB cancels a <code>TransactGetItems</code> request under the following circumstances:</p> <ul> <li> <p>There is an ongoing <code>TransactGetItems</code> operation that conflicts with a concurrent <code>PutItem</code>, <code>UpdateItem</code>, <code>DeleteItem</code> or <code>TransactWriteItems</code> request. In this case the <code>TransactGetItems</code> operation fails with a <code>TransactionCanceledException</code>.</p> </li> <li> <p>A table in the <code>TransactGetItems</code> request is in a different account or region.</p> </li> <li> <p>There is insufficient provisioned capacity for the transaction to be completed.</p> </li> <li> <p>There is a user error, such as an invalid data format.</p> </li> </ul> <note> <p>If using Java, DynamoDB lists the cancellation reasons on the <code>CancellationReasons</code> property. This property is not set for other languages. Transaction cancellation reasons are ordered in the order of requested items, if an item has no error it will have <code>NONE</code> code and <code>Null</code> message.</p> </note> <p>Cancellation reason codes and possible error messages:</p> <ul> <li> <p>No Errors:</p> <ul> <li> <p>Code: <code>NONE</code> </p> </li> <li> <p>Message: <code>null</code> </p> </li> </ul> </li> <li> <p>Conditional Check Failed:</p> <ul> <li> <p>Code: <code>ConditionalCheckFailed</code> </p> </li> <li> <p>Message: The conditional request failed. </p> </li> </ul> </li> <li> <p>Item Collection Size Limit Exceeded:</p> <ul> <li> <p>Code: <code>ItemCollectionSizeLimitExceeded</code> </p> </li> <li> <p>Message: Collection size exceeded.</p> </li> </ul> </li> <li> <p>Transaction Conflict:</p> <ul> <li> <p>Code: <code>TransactionConflict</code> </p> </li> <li> <p>Message: Transaction is ongoing for the item.</p> </li> </ul> </li> <li> <p>Provisioned Throughput Exceeded:</p> <ul> <li> <p>Code: <code>ProvisionedThroughputExceeded</code> </p> </li> <li> <p>Messages:</p> <ul> <li> <p>The level of configured provisioned throughput for the table was exceeded. Consider increasing your provisioning level with the UpdateTable API.</p> <note> <p>This Message is received when provisioned throughput is exceeded is on a provisioned DynamoDB table.</p> </note> </li> <li> <p>The level of configured provisioned throughput for one or more global secondary indexes of the table was exceeded. Consider increasing your provisioning level for the under-provisioned global secondary indexes with the UpdateTable API.</p> <note> <p>This message is returned when provisioned throughput is exceeded is on a provisioned GSI.</p> </note> </li> </ul> </li> </ul> </li> <li> <p>Throttling Error:</p> <ul> <li> <p>Code: <code>ThrottlingError</code> </p> </li> <li> <p>Messages: </p> <ul> <li> <p>Throughput exceeds the current capacity of your table or index. DynamoDB is automatically scaling your table or index so please try again shortly. If exceptions persist, check if you have a hot key: https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/bp-partition-key-design.html.</p> <note> <p>This message is returned when writes get throttled on an On-Demand table as DynamoDB is automatically scaling the table.</p> </note> </li> <li> <p>Throughput exceeds the current capacity for one or more global secondary indexes. DynamoDB is automatically scaling your index so please try again shortly.</p> <note> <p>This message is returned when when writes get throttled on an On-Demand GSI as DynamoDB is automatically scaling the GSI.</p> </note> </li> </ul> </li> </ul> </li> <li> <p>Validation Error:</p> <ul> <li> <p>Code: <code>ValidationError</code> </p> </li> <li> <p>Messages: </p> <ul> <li> <p>One or more parameter values were invalid.</p> </li> <li> <p>The update expression attempted to update the secondary index key beyond allowed size limits.</p> </li> <li> <p>The update expression attempted to update the secondary index key to unsupported type.</p> </li> <li> <p>An operand in the update expression has an incorrect data type.</p> </li> <li> <p>Item size to update has exceeded the maximum allowed size.</p> </li> <li> <p>Number overflow. Attempting to store a number with magnitude larger than supported range.</p> </li> <li> <p>Type mismatch for attribute to update.</p> </li> <li> <p>Nesting Levels have exceeded supported limits.</p> </li> <li> <p>The document path provided in the update expression is invalid for update.</p> </li> <li> <p>The provided expression refers to an attribute that does not exist in the item.</p> </li> </ul> </li> </ul> </li> </ul>', 'refs' => [], ], 'TransactionConflictException' => [ 'base' => '<p>Operation was rejected because there is an ongoing transaction for the item.</p>', 'refs' => [], ], 'TransactionInProgressException' => [ 'base' => '<p>The transaction with the given request token is already in progress.</p>', 'refs' => [], ], 'UntagResourceInput' => [ 'base' => NULL, 'refs' => [], ], 'Update' => [ 'base' => '<p>Represents a request to perform an <code>UpdateItem</code> operation.</p>', 'refs' => [ 'TransactWriteItem$Update' => '<p>A request to perform an <code>UpdateItem</code> operation.</p>', ], ], 'UpdateContinuousBackupsInput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateContinuousBackupsOutput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateContributorInsightsInput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateContributorInsightsOutput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateExpression' => [ 'base' => NULL, 'refs' => [ 'Update$UpdateExpression' => '<p>An expression that defines one or more attributes to be updated, the action to be performed on them, and new value(s) for them.</p>', 'UpdateItemInput$UpdateExpression' => '<p>An expression that defines one or more attributes to be updated, the action to be performed on them, and new values for them.</p> <p>The following action values are available for <code>UpdateExpression</code>.</p> <ul> <li> <p> <code>SET</code> - Adds one or more attributes and values to an item. If any of these attributes already exist, they are replaced by the new values. You can also use <code>SET</code> to add or subtract from an attribute that is of type Number. For example: <code>SET myNum = myNum + :val</code> </p> <p> <code>SET</code> supports the following functions:</p> <ul> <li> <p> <code>if_not_exists (path, operand)</code> - if the item does not contain an attribute at the specified path, then <code>if_not_exists</code> evaluates to operand; otherwise, it evaluates to path. You can use this function to avoid overwriting an attribute that may already be present in the item.</p> </li> <li> <p> <code>list_append (operand, operand)</code> - evaluates to a list with a new element added to it. You can append the new element to the start or the end of the list by reversing the order of the operands.</p> </li> </ul> <p>These function names are case-sensitive.</p> </li> <li> <p> <code>REMOVE</code> - Removes one or more attributes from an item.</p> </li> <li> <p> <code>ADD</code> - Adds the specified value to the item, if the attribute does not already exist. If the attribute does exist, then the behavior of <code>ADD</code> depends on the data type of the attribute:</p> <ul> <li> <p>If the existing attribute is a number, and if <code>Value</code> is also a number, then <code>Value</code> is mathematically added to the existing attribute. If <code>Value</code> is a negative number, then it is subtracted from the existing attribute.</p> <note> <p>If you use <code>ADD</code> to increment or decrement a number value for an item that doesn\'t exist before the update, DynamoDB uses <code>0</code> as the initial value.</p> <p>Similarly, if you use <code>ADD</code> for an existing item to increment or decrement an attribute value that doesn\'t exist before the update, DynamoDB uses <code>0</code> as the initial value. For example, suppose that the item you want to update doesn\'t have an attribute named <code>itemcount</code>, but you decide to <code>ADD</code> the number <code>3</code> to this attribute anyway. DynamoDB will create the <code>itemcount</code> attribute, set its initial value to <code>0</code>, and finally add <code>3</code> to it. The result will be a new <code>itemcount</code> attribute in the item, with a value of <code>3</code>.</p> </note> </li> <li> <p>If the existing data type is a set and if <code>Value</code> is also a set, then <code>Value</code> is added to the existing set. For example, if the attribute value is the set <code>[1,2]</code>, and the <code>ADD</code> action specified <code>[3]</code>, then the final attribute value is <code>[1,2,3]</code>. An error occurs if an <code>ADD</code> action is specified for a set attribute and the attribute type specified does not match the existing set type. </p> <p>Both sets must have the same primitive data type. For example, if the existing data type is a set of strings, the <code>Value</code> must also be a set of strings.</p> </li> </ul> <important> <p>The <code>ADD</code> action only supports Number and set data types. In addition, <code>ADD</code> can only be used on top-level attributes, not nested attributes.</p> </important> </li> <li> <p> <code>DELETE</code> - Deletes an element from a set.</p> <p>If a set of values is specified, then those values are subtracted from the old set. For example, if the attribute value was the set <code>[a,b,c]</code> and the <code>DELETE</code> action specifies <code>[a,c]</code>, then the final attribute value is <code>[b]</code>. Specifying an empty set is an error.</p> <important> <p>The <code>DELETE</code> action only supports set data types. In addition, <code>DELETE</code> can only be used on top-level attributes, not nested attributes.</p> </important> </li> </ul> <p>You can have many actions in a single expression, such as the following: <code>SET a=:value1, b=:value2 DELETE :value3, :value4, :value5</code> </p> <p>For more information on update expressions, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.Modifying.html">Modifying Items and Attributes</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>', ], ], 'UpdateGlobalSecondaryIndexAction' => [ 'base' => '<p>Represents the new provisioned throughput settings to be applied to a global secondary index.</p>', 'refs' => [ 'GlobalSecondaryIndexUpdate$Update' => '<p>The name of an existing global secondary index, along with new provisioned throughput settings to be applied to that index.</p>', ], ], 'UpdateGlobalTableInput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateGlobalTableOutput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateGlobalTableSettingsInput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateGlobalTableSettingsOutput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateItemInput' => [ 'base' => '<p>Represents the input of an <code>UpdateItem</code> operation.</p>', 'refs' => [], ], 'UpdateItemOutput' => [ 'base' => '<p>Represents the output of an <code>UpdateItem</code> operation.</p>', 'refs' => [], ], 'UpdateReplicationGroupMemberAction' => [ 'base' => '<p>Represents a replica to be modified.</p>', 'refs' => [ 'ReplicationGroupUpdate$Update' => '<p>The parameters required for updating a replica for the table.</p>', ], ], 'UpdateTableInput' => [ 'base' => '<p>Represents the input of an <code>UpdateTable</code> operation.</p>', 'refs' => [], ], 'UpdateTableOutput' => [ 'base' => '<p>Represents the output of an <code>UpdateTable</code> operation.</p>', 'refs' => [], ], 'UpdateTableReplicaAutoScalingInput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateTableReplicaAutoScalingOutput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateTimeToLiveInput' => [ 'base' => '<p>Represents the input of an <code>UpdateTimeToLive</code> operation.</p>', 'refs' => [], ], 'UpdateTimeToLiveOutput' => [ 'base' => NULL, 'refs' => [], ], 'WriteRequest' => [ 'base' => '<p>Represents an operation to perform - either <code>DeleteItem</code> or <code>PutItem</code>. You can only request one of these operations, not both, in a single <code>WriteRequest</code>. If you do need to perform both of these operations, you need to provide two separate <code>WriteRequest</code> objects.</p>', 'refs' => [ 'WriteRequests$member' => NULL, ], ], 'WriteRequests' => [ 'base' => NULL, 'refs' => [ 'BatchWriteItemRequestMap$value' => NULL, ], ], ],];
