<?php
// This file was auto-generated from sdk-root/src/data/connectparticipant/2018-09-07/docs-2.json
return [ 'version' => '2.0', 'service' => '<p>Amazon Connect is a cloud-based contact center solution that makes it easy to set up and manage a customer contact center and provide reliable customer engagement at any scale.</p> <p>Amazon Connect enables customer contacts through voice or chat.</p> <p>The APIs described here are used by chat participants, such as agents and customers.</p>', 'operations' => [ 'CompleteAttachmentUpload' => '<p>Allows you to confirm that the attachment has been uploaded using the pre-signed URL provided in StartAttachmentUpload API. </p> <p>The Amazon Connect Participant Service APIs do not use <a href="https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html">Signature Version 4 authentication</a>.</p>', 'CreateParticipantConnection' => '<p>Creates the participant\'s connection. Note that ParticipantToken is used for invoking this API instead of ConnectionToken.</p> <p>The participant token is valid for the lifetime of the participant – until they are part of a contact.</p> <p>The response URL for <code>WEBSOCKET</code> Type has a connect expiry timeout of 100s. Clients must manually connect to the returned websocket URL and subscribe to the desired topic. </p> <p>For chat, you need to publish the following on the established websocket connection:</p> <p> <code>{"topic":"aws/subscribe","content":{"topics":["aws/chat"]}}</code> </p> <p>Upon websocket URL expiry, as specified in the response ConnectionExpiry parameter, clients need to call this API again to obtain a new websocket URL and perform the same steps as before.</p> <p> <b>Message streaming support</b>: This API can also be used together with the <a href="https://docs.aws.amazon.com/connect/latest/APIReference/API_StartContactStreaming.html">StartContactStreaming</a> API to create a participant connection for chat contacts that are not using a websocket. For more information about message streaming, <a href="https://docs.aws.amazon.com/connect/latest/adminguide/chat-message-streaming.html">Enable real-time chat message streaming</a> in the <i>Amazon Connect Administrator Guide</i>.</p> <p> <b>Feature specifications</b>: For information about feature specifications, such as the allowed number of open websocket connections per participant, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html#feature-limits">Feature specifications</a> in the <i>Amazon Connect Administrator Guide</i>. </p> <note> <p>The Amazon Connect Participant Service APIs do not use <a href="https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html">Signature Version 4 authentication</a>.</p> </note>', 'DisconnectParticipant' => '<p>Disconnects a participant. Note that ConnectionToken is used for invoking this API instead of ParticipantToken.</p> <p>The Amazon Connect Participant Service APIs do not use <a href="https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html">Signature Version 4 authentication</a>.</p>', 'GetAttachment' => '<p>Provides a pre-signed URL for download of a completed attachment. This is an asynchronous API for use with active contacts.</p> <p>The Amazon Connect Participant Service APIs do not use <a href="https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html">Signature Version 4 authentication</a>.</p>', 'GetTranscript' => '<p>Retrieves a transcript of the session, including details about any attachments. Note that ConnectionToken is used for invoking this API instead of ParticipantToken.</p> <p>The Amazon Connect Participant Service APIs do not use <a href="https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html">Signature Version 4 authentication</a>.</p>', 'SendEvent' => '<p>Sends an event. Note that ConnectionToken is used for invoking this API instead of ParticipantToken.</p> <p>The Amazon Connect Participant Service APIs do not use <a href="https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html">Signature Version 4 authentication</a>.</p>', 'SendMessage' => '<p>Sends a message. Note that ConnectionToken is used for invoking this API instead of ParticipantToken.</p> <p>The Amazon Connect Participant Service APIs do not use <a href="https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html">Signature Version 4 authentication</a>.</p>', 'StartAttachmentUpload' => '<p>Provides a pre-signed Amazon S3 URL in response for uploading the file directly to S3.</p> <p>The Amazon Connect Participant Service APIs do not use <a href="https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html">Signature Version 4 authentication</a>.</p>', ], 'shapes' => [ 'AccessDeniedException' => [ 'base' => '<p>You do not have sufficient access to perform this action.</p>', 'refs' => [], ], 'ArtifactId' => [ 'base' => NULL, 'refs' => [ 'AttachmentIdList$member' => NULL, 'AttachmentItem$AttachmentId' => '<p>A unique identifier for the attachment.</p>', 'GetAttachmentRequest$AttachmentId' => '<p>A unique identifier for the attachment.</p>', 'StartAttachmentUploadResponse$AttachmentId' => '<p>A unique identifier for the attachment.</p>', ], ], 'ArtifactStatus' => [ 'base' => NULL, 'refs' => [ 'AttachmentItem$Status' => '<p>Status of the attachment.</p>', ], ], 'AttachmentIdList' => [ 'base' => NULL, 'refs' => [ 'CompleteAttachmentUploadRequest$AttachmentIds' => '<p>A list of unique identifiers for the attachments.</p>', ], ], 'AttachmentItem' => [ 'base' => '<p>The case-insensitive input to indicate standard MIME type that describes the format of the file that will be uploaded.</p>', 'refs' => [ 'Attachments$member' => NULL, ], ], 'AttachmentName' => [ 'base' => NULL, 'refs' => [ 'AttachmentItem$AttachmentName' => '<p>A case-sensitive name of the attachment being uploaded.</p>', 'StartAttachmentUploadRequest$AttachmentName' => '<p>A case-sensitive name of the attachment being uploaded.</p>', ], ], 'AttachmentSizeInBytes' => [ 'base' => NULL, 'refs' => [ 'StartAttachmentUploadRequest$AttachmentSizeInBytes' => '<p>The size of the attachment in bytes.</p>', ], ], 'Attachments' => [ 'base' => NULL, 'refs' => [ 'Item$Attachments' => '<p>Provides information about the attachments.</p>', ], ], 'Bool' => [ 'base' => NULL, 'refs' => [ 'CreateParticipantConnectionRequest$ConnectParticipant' => '<p>Amazon Connect Participant is used to mark the participant as connected for message streaming.</p>', ], ], 'ChatContent' => [ 'base' => NULL, 'refs' => [ 'Item$Content' => '<p>The content of the message or event.</p>', 'SendEventRequest$Content' => '<p>The content of the event to be sent (for example, message text). This is not yet supported.</p>', 'SendMessageRequest$Content' => '<p>The content of the message.</p>', ], ], 'ChatContentType' => [ 'base' => NULL, 'refs' => [ 'Item$ContentType' => '<p>The type of content of the item.</p>', 'SendEventRequest$ContentType' => '<p>The content type of the request. Supported types are:</p> <ul> <li> <p>application/vnd.amazonaws.connect.event.typing</p> </li> <li> <p>application/vnd.amazonaws.connect.event.connection.acknowledged</p> </li> </ul>', 'SendMessageRequest$ContentType' => '<p>The type of the content. Supported types are text/plain.</p>', ], ], 'ChatItemId' => [ 'base' => NULL, 'refs' => [ 'Item$Id' => '<p>The ID of the item.</p>', 'SendEventResponse$Id' => '<p>The ID of the response.</p>', 'SendMessageResponse$Id' => '<p>The ID of the message.</p>', 'StartPosition$Id' => '<p>The ID of the message or event where to start. </p>', ], ], 'ChatItemType' => [ 'base' => NULL, 'refs' => [ 'Item$Type' => '<p>Type of the item: message or event. </p>', ], ], 'ClientToken' => [ 'base' => NULL, 'refs' => [ 'DisconnectParticipantRequest$ClientToken' => '<p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>', 'SendEventRequest$ClientToken' => '<p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>', 'SendMessageRequest$ClientToken' => '<p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>', ], ], 'CompleteAttachmentUploadRequest' => [ 'base' => NULL, 'refs' => [], ], 'CompleteAttachmentUploadResponse' => [ 'base' => NULL, 'refs' => [], ], 'ConflictException' => [ 'base' => '<p>An attachment with that identifier is already being uploaded.</p>', 'refs' => [], ], 'ConnectionCredentials' => [ 'base' => '<p>Connection credentials. </p>', 'refs' => [ 'CreateParticipantConnectionResponse$ConnectionCredentials' => '<p>Creates the participant\'s connection credentials. The authentication token associated with the participant\'s connection.</p>', ], ], 'ConnectionType' => [ 'base' => NULL, 'refs' => [ 'ConnectionTypeList$member' => NULL, ], ], 'ConnectionTypeList' => [ 'base' => NULL, 'refs' => [ 'CreateParticipantConnectionRequest$Type' => '<p>Type of connection information required.</p>', ], ], 'ContactId' => [ 'base' => NULL, 'refs' => [ 'GetTranscriptRequest$ContactId' => '<p>The contactId from the current contact chain for which transcript is needed.</p>', 'GetTranscriptResponse$InitialContactId' => '<p>The initial contact ID for the contact. </p>', ], ], 'ContentType' => [ 'base' => NULL, 'refs' => [ 'AttachmentItem$ContentType' => '<p>Describes the MIME file type of the attachment. For a list of supported file types, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html#feature-limits">Feature specifications</a> in the <i>Amazon Connect Administrator Guide</i>.</p>', 'StartAttachmentUploadRequest$ContentType' => '<p>Describes the MIME file type of the attachment. For a list of supported file types, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html#feature-limits">Feature specifications</a> in the <i>Amazon Connect Administrator Guide</i>.</p>', ], ], 'CreateParticipantConnectionRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateParticipantConnectionResponse' => [ 'base' => NULL, 'refs' => [], ], 'DisconnectParticipantRequest' => [ 'base' => NULL, 'refs' => [], ], 'DisconnectParticipantResponse' => [ 'base' => NULL, 'refs' => [], ], 'DisplayName' => [ 'base' => NULL, 'refs' => [ 'Item$DisplayName' => '<p>The chat display name of the sender.</p>', ], ], 'GetAttachmentRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetAttachmentResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetTranscriptRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetTranscriptResponse' => [ 'base' => NULL, 'refs' => [], ], 'ISO8601Datetime' => [ 'base' => NULL, 'refs' => [ 'ConnectionCredentials$Expiry' => '<p>The expiration of the token.</p> <p>It\'s specified in ISO 8601 format: yyyy-MM-ddThh:mm:ss.SSSZ. For example, 2019-11-08T02:41:28.172Z.</p>', 'GetAttachmentResponse$UrlExpiry' => '<p>The expiration time of the URL in ISO timestamp. It\'s specified in ISO 8601 format: yyyy-MM-ddThh:mm:ss.SSSZ. For example, 2019-11-08T02:41:28.172Z.</p>', 'UploadMetadata$UrlExpiry' => '<p>The expiration time of the URL in ISO timestamp. It\'s specified in ISO 8601 format: yyyy-MM-ddThh:mm:ss.SSSZ. For example, 2019-11-08T02:41:28.172Z.</p>', 'Websocket$ConnectionExpiry' => '<p>The URL expiration timestamp in ISO date format.</p> <p>It\'s specified in ISO 8601 format: yyyy-MM-ddThh:mm:ss.SSSZ. For example, 2019-11-08T02:41:28.172Z.</p>', ], ], 'Instant' => [ 'base' => NULL, 'refs' => [ 'Item$AbsoluteTime' => '<p>The time when the message or event was sent.</p> <p>It\'s specified in ISO 8601 format: yyyy-MM-ddThh:mm:ss.SSSZ. For example, 2019-11-08T02:41:28.172Z.</p>', 'SendEventResponse$AbsoluteTime' => '<p>The time when the event was sent.</p> <p>It\'s specified in ISO 8601 format: yyyy-MM-ddThh:mm:ss.SSSZ. For example, 2019-11-08T02:41:28.172Z.</p>', 'SendMessageResponse$AbsoluteTime' => '<p>The time when the message was sent.</p> <p>It\'s specified in ISO 8601 format: yyyy-MM-ddThh:mm:ss.SSSZ. For example, 2019-11-08T02:41:28.172Z.</p>', 'StartPosition$AbsoluteTime' => '<p>The time in ISO format where to start.</p> <p>It\'s specified in ISO 8601 format: yyyy-MM-ddThh:mm:ss.SSSZ. For example, 2019-11-08T02:41:28.172Z.</p>', ], ], 'InternalServerException' => [ 'base' => '<p>This exception occurs when there is an internal failure in the Amazon Connect service.</p>', 'refs' => [], ], 'Item' => [ 'base' => '<p>An item - message or event - that has been sent. </p>', 'refs' => [ 'Transcript$member' => NULL, ], ], 'MaxResults' => [ 'base' => NULL, 'refs' => [ 'GetTranscriptRequest$MaxResults' => '<p>The maximum number of results to return in the page. Default: 10. </p>', ], ], 'Message' => [ 'base' => NULL, 'refs' => [ 'AccessDeniedException$Message' => NULL, 'InternalServerException$Message' => NULL, 'ServiceQuotaExceededException$Message' => NULL, 'ThrottlingException$Message' => NULL, ], ], 'MostRecent' => [ 'base' => NULL, 'refs' => [ 'StartPosition$MostRecent' => '<p>The start position of the most recent message where you want to start. </p>', ], ], 'NextToken' => [ 'base' => NULL, 'refs' => [ 'GetTranscriptRequest$NextToken' => '<p>The pagination token. Use the value returned previously in the next subsequent request to retrieve the next set of results.</p>', 'GetTranscriptResponse$NextToken' => '<p>The pagination token. Use the value returned previously in the next subsequent request to retrieve the next set of results.</p>', ], ], 'NonEmptyClientToken' => [ 'base' => NULL, 'refs' => [ 'CompleteAttachmentUploadRequest$ClientToken' => '<p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>', 'StartAttachmentUploadRequest$ClientToken' => '<p>A unique case sensitive identifier to support idempotency of request.</p>', ], ], 'ParticipantId' => [ 'base' => NULL, 'refs' => [ 'Item$ParticipantId' => '<p>The ID of the sender in the session.</p>', ], ], 'ParticipantRole' => [ 'base' => NULL, 'refs' => [ 'Item$ParticipantRole' => '<p>The role of the sender. For example, is it a customer, agent, or system.</p>', ], ], 'ParticipantToken' => [ 'base' => NULL, 'refs' => [ 'CompleteAttachmentUploadRequest$ConnectionToken' => '<p>The authentication token associated with the participant\'s connection.</p>', 'ConnectionCredentials$ConnectionToken' => '<p>The connection token.</p>', 'CreateParticipantConnectionRequest$ParticipantToken' => '<p>This is a header parameter.</p> <p>The ParticipantToken as obtained from <a href="https://docs.aws.amazon.com/connect/latest/APIReference/API_StartChatContact.html">StartChatContact</a> API response.</p>', 'DisconnectParticipantRequest$ConnectionToken' => '<p>The authentication token associated with the participant\'s connection.</p>', 'GetAttachmentRequest$ConnectionToken' => '<p>The authentication token associated with the participant\'s connection.</p>', 'GetTranscriptRequest$ConnectionToken' => '<p>The authentication token associated with the participant\'s connection.</p>', 'SendEventRequest$ConnectionToken' => '<p>The authentication token associated with the participant\'s connection.</p>', 'SendMessageRequest$ConnectionToken' => '<p>The authentication token associated with the connection.</p>', 'StartAttachmentUploadRequest$ConnectionToken' => '<p>The authentication token associated with the participant\'s connection.</p>', ], ], 'PreSignedAttachmentUrl' => [ 'base' => NULL, 'refs' => [ 'GetAttachmentResponse$Url' => '<p>This is the pre-signed URL that can be used for uploading the file to Amazon S3 when used in response to <a href="https://docs.aws.amazon.com/connect-participant/latest/APIReference/API_StartAttachmentUpload.html">StartAttachmentUpload</a>.</p>', ], ], 'PreSignedConnectionUrl' => [ 'base' => NULL, 'refs' => [ 'Websocket$Url' => '<p>The URL of the websocket.</p>', ], ], 'Reason' => [ 'base' => NULL, 'refs' => [ 'ConflictException$Message' => NULL, 'ValidationException$Message' => NULL, ], ], 'ScanDirection' => [ 'base' => NULL, 'refs' => [ 'GetTranscriptRequest$ScanDirection' => '<p>The direction from StartPosition from which to retrieve message. Default: BACKWARD when no StartPosition is provided, FORWARD with StartPosition. </p>', ], ], 'SendEventRequest' => [ 'base' => NULL, 'refs' => [], ], 'SendEventResponse' => [ 'base' => NULL, 'refs' => [], ], 'SendMessageRequest' => [ 'base' => NULL, 'refs' => [], ], 'SendMessageResponse' => [ 'base' => NULL, 'refs' => [], ], 'ServiceQuotaExceededException' => [ 'base' => '<p>The number of attachments per contact exceeds the quota.</p>', 'refs' => [], ], 'SortKey' => [ 'base' => NULL, 'refs' => [ 'GetTranscriptRequest$SortOrder' => '<p>The sort order for the records. Default: DESCENDING.</p>', ], ], 'StartAttachmentUploadRequest' => [ 'base' => NULL, 'refs' => [], ], 'StartAttachmentUploadResponse' => [ 'base' => NULL, 'refs' => [], ], 'StartPosition' => [ 'base' => '<p>A filtering option for where to start. For example, if you sent 100 messages, start with message 50. </p>', 'refs' => [ 'GetTranscriptRequest$StartPosition' => '<p>A filtering option for where to start.</p>', ], ], 'ThrottlingException' => [ 'base' => '<p>The request was denied due to request throttling.</p>', 'refs' => [], ], 'Transcript' => [ 'base' => NULL, 'refs' => [ 'GetTranscriptResponse$Transcript' => '<p>The list of messages in the session.</p>', ], ], 'UploadMetadata' => [ 'base' => '<p>Fields to be used while uploading the attachment.</p>', 'refs' => [ 'StartAttachmentUploadResponse$UploadMetadata' => '<p>Fields to be used while uploading the attachment.</p>', ], ], 'UploadMetadataSignedHeaders' => [ 'base' => NULL, 'refs' => [ 'UploadMetadata$HeadersToInclude' => '<p>The headers to be provided while uploading the file to the URL.</p>', ], ], 'UploadMetadataSignedHeadersKey' => [ 'base' => NULL, 'refs' => [ 'UploadMetadataSignedHeaders$key' => NULL, ], ], 'UploadMetadataSignedHeadersValue' => [ 'base' => NULL, 'refs' => [ 'UploadMetadataSignedHeaders$value' => NULL, ], ], 'UploadMetadataUrl' => [ 'base' => NULL, 'refs' => [ 'UploadMetadata$Url' => '<p>This is the pre-signed URL that can be used for uploading the file to Amazon S3 when used in response to <a href="https://docs.aws.amazon.com/connect-participant/latest/APIReference/API_StartAttachmentUpload.html">StartAttachmentUpload</a>.</p>', ], ], 'ValidationException' => [ 'base' => '<p>The input fails to satisfy the constraints specified by Amazon Connect.</p>', 'refs' => [], ], 'Websocket' => [ 'base' => '<p>The websocket for the participant\'s connection.</p>', 'refs' => [ 'CreateParticipantConnectionResponse$Websocket' => '<p>Creates the participant\'s websocket connection.</p>', ], ], ],];
