<?php
// This file was auto-generated from sdk-root/src/data/config/2014-11-12/docs-2.json
return [ 'version' => '2.0', 'service' => '<fullname>Config</fullname> <p>Config provides a way to keep track of the configurations of all the Amazon Web Services resources associated with your Amazon Web Services account. You can use Config to get the current and historical configurations of each Amazon Web Services resource and also to get information about the relationship between the resources. An Amazon Web Services resource can be an Amazon Compute Cloud (Amazon EC2) instance, an Elastic Block Store (EBS) volume, an elastic network Interface (ENI), or a security group. For a complete list of resources currently supported by Config, see <a href="https://docs.aws.amazon.com/config/latest/developerguide/resource-config-reference.html#supported-resources">Supported Amazon Web Services resources</a>.</p> <p>You can access and manage Config through the Amazon Web Services Management Console, the Amazon Web Services Command Line Interface (Amazon Web Services CLI), the Config API, or the Amazon Web Services SDKs for Config. This reference guide contains documentation for the Config API and the Amazon Web Services CLI commands that you can use to manage Config. The Config API uses the Signature Version 4 protocol for signing requests. For more information about how to sign a request with this protocol, see <a href="https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html">Signature Version 4 Signing Process</a>. For detailed information about Config features and their associated actions or commands, as well as how to work with Amazon Web Services Management Console, see <a href="https://docs.aws.amazon.com/config/latest/developerguide/WhatIsConfig.html">What Is Config</a> in the <i>Config Developer Guide</i>.</p>', 'operations' => [ 'BatchGetAggregateResourceConfig' => '<p>Returns the current configuration items for resources that are present in your Config aggregator. The operation also returns a list of resources that are not processed in the current request. If there are no unprocessed resources, the operation returns an empty <code>unprocessedResourceIdentifiers</code> list. </p> <note> <ul> <li> <p>The API does not return results for deleted resources.</p> </li> <li> <p> The API does not return tags and relationships.</p> </li> </ul> </note>', 'BatchGetResourceConfig' => '<p>Returns the <code>BaseConfigurationItem</code> for one or more requested resources. The operation also returns a list of resources that are not processed in the current request. If there are no unprocessed resources, the operation returns an empty unprocessedResourceKeys list. </p> <note> <ul> <li> <p>The API does not return results for deleted resources.</p> </li> <li> <p> The API does not return any tags for the requested resources. This information is filtered out of the supplementaryConfiguration section of the API response.</p> </li> </ul> </note>', 'DeleteAggregationAuthorization' => '<p>Deletes the authorization granted to the specified configuration aggregator account in a specified region.</p>', 'DeleteConfigRule' => '<p>Deletes the specified Config rule and all of its evaluation results.</p> <p>Config sets the state of a rule to <code>DELETING</code> until the deletion is complete. You cannot update a rule while it is in this state. If you make a <code>PutConfigRule</code> or <code>DeleteConfigRule</code> request for the rule, you will receive a <code>ResourceInUseException</code>.</p> <p>You can check the state of a rule by using the <code>DescribeConfigRules</code> request.</p>', 'DeleteConfigurationAggregator' => '<p>Deletes the specified configuration aggregator and the aggregated data associated with the aggregator.</p>', 'DeleteConfigurationRecorder' => '<p>Deletes the configuration recorder.</p> <p>After the configuration recorder is deleted, Config will not record resource configuration changes until you create a new configuration recorder.</p> <p>This action does not delete the configuration information that was previously recorded. You will be able to access the previously recorded information by using the <code>GetResourceConfigHistory</code> action, but you will not be able to access this information in the Config console until you create a new configuration recorder.</p>', 'DeleteConformancePack' => '<p>Deletes the specified conformance pack and all the Config rules, remediation actions, and all evaluation results within that conformance pack.</p> <p>Config sets the conformance pack to <code>DELETE_IN_PROGRESS</code> until the deletion is complete. You cannot update a conformance pack while it is in this state.</p>', 'DeleteDeliveryChannel' => '<p>Deletes the delivery channel.</p> <p>Before you can delete the delivery channel, you must stop the configuration recorder by using the <a>StopConfigurationRecorder</a> action.</p>', 'DeleteEvaluationResults' => '<p>Deletes the evaluation results for the specified Config rule. You can specify one Config rule per request. After you delete the evaluation results, you can call the <a>StartConfigRulesEvaluation</a> API to start evaluating your Amazon Web Services resources against the rule.</p>', 'DeleteOrganizationConfigRule' => '<p>Deletes the specified organization Config rule and all of its evaluation results from all member accounts in that organization. </p> <p>Only a master account and a delegated administrator account can delete an organization Config rule. When calling this API with a delegated administrator, you must ensure Organizations <code>ListDelegatedAdministrator</code> permissions are added.</p> <p>Config sets the state of a rule to DELETE_IN_PROGRESS until the deletion is complete. You cannot update a rule while it is in this state.</p>', 'DeleteOrganizationConformancePack' => '<p>Deletes the specified organization conformance pack and all of the Config rules and remediation actions from all member accounts in that organization. </p> <p> Only a master account or a delegated administrator account can delete an organization conformance pack. When calling this API with a delegated administrator, you must ensure Organizations <code>ListDelegatedAdministrator</code> permissions are added.</p> <p>Config sets the state of a conformance pack to DELETE_IN_PROGRESS until the deletion is complete. You cannot update a conformance pack while it is in this state. </p>', 'DeletePendingAggregationRequest' => '<p>Deletes pending authorization requests for a specified aggregator account in a specified region.</p>', 'DeleteRemediationConfiguration' => '<p>Deletes the remediation configuration.</p>', 'DeleteRemediationExceptions' => '<p>Deletes one or more remediation exceptions mentioned in the resource keys.</p> <note> <p>Config generates a remediation exception when a problem occurs executing a remediation action to a specific resource. Remediation exceptions blocks auto-remediation until the exception is cleared.</p> </note>', 'DeleteResourceConfig' => '<p>Records the configuration state for a custom resource that has been deleted. This API records a new ConfigurationItem with a ResourceDeleted status. You can retrieve the ConfigurationItems recorded for this resource in your Config History. </p>', 'DeleteRetentionConfiguration' => '<p>Deletes the retention configuration.</p>', 'DeleteStoredQuery' => '<p>Deletes the stored query for a single Amazon Web Services account and a single Amazon Web Services Region.</p>', 'DeliverConfigSnapshot' => '<p>Schedules delivery of a configuration snapshot to the Amazon S3 bucket in the specified delivery channel. After the delivery has started, Config sends the following notifications using an Amazon SNS topic that you have specified.</p> <ul> <li> <p>Notification of the start of the delivery.</p> </li> <li> <p>Notification of the completion of the delivery, if the delivery was successfully completed.</p> </li> <li> <p>Notification of delivery failure, if the delivery failed.</p> </li> </ul>', 'DescribeAggregateComplianceByConfigRules' => '<p>Returns a list of compliant and noncompliant rules with the number of resources for compliant and noncompliant rules. Does not display rules that do not have compliance results. </p> <note> <p>The results can return an empty result page, but if you have a <code>nextToken</code>, the results are displayed on the next page.</p> </note>', 'DescribeAggregateComplianceByConformancePacks' => '<p>Returns a list of the conformance packs and their associated compliance status with the count of compliant and noncompliant Config rules within each conformance pack. Also returns the total rule count which includes compliant rules, noncompliant rules, and rules that cannot be evaluated due to insufficient data.</p> <note> <p>The results can return an empty result page, but if you have a <code>nextToken</code>, the results are displayed on the next page.</p> </note>', 'DescribeAggregationAuthorizations' => '<p>Returns a list of authorizations granted to various aggregator accounts and regions.</p>', 'DescribeComplianceByConfigRule' => '<p>Indicates whether the specified Config rules are compliant. If a rule is noncompliant, this action returns the number of Amazon Web Services resources that do not comply with the rule.</p> <p>A rule is compliant if all of the evaluated resources comply with it. It is noncompliant if any of these resources do not comply.</p> <p>If Config has no current evaluation results for the rule, it returns <code>INSUFFICIENT_DATA</code>. This result might indicate one of the following conditions:</p> <ul> <li> <p>Config has never invoked an evaluation for the rule. To check whether it has, use the <code>DescribeConfigRuleEvaluationStatus</code> action to get the <code>LastSuccessfulInvocationTime</code> and <code>LastFailedInvocationTime</code>.</p> </li> <li> <p>The rule\'s Lambda function is failing to send evaluation results to Config. Verify that the role you assigned to your configuration recorder includes the <code>config:PutEvaluations</code> permission. If the rule is a custom rule, verify that the Lambda execution role includes the <code>config:PutEvaluations</code> permission.</p> </li> <li> <p>The rule\'s Lambda function has returned <code>NOT_APPLICABLE</code> for all evaluation results. This can occur if the resources were deleted or removed from the rule\'s scope.</p> </li> </ul>', 'DescribeComplianceByResource' => '<p>Indicates whether the specified Amazon Web Services resources are compliant. If a resource is noncompliant, this action returns the number of Config rules that the resource does not comply with.</p> <p>A resource is compliant if it complies with all the Config rules that evaluate it. It is noncompliant if it does not comply with one or more of these rules.</p> <p>If Config has no current evaluation results for the resource, it returns <code>INSUFFICIENT_DATA</code>. This result might indicate one of the following conditions about the rules that evaluate the resource:</p> <ul> <li> <p>Config has never invoked an evaluation for the rule. To check whether it has, use the <code>DescribeConfigRuleEvaluationStatus</code> action to get the <code>LastSuccessfulInvocationTime</code> and <code>LastFailedInvocationTime</code>.</p> </li> <li> <p>The rule\'s Lambda function is failing to send evaluation results to Config. Verify that the role that you assigned to your configuration recorder includes the <code>config:PutEvaluations</code> permission. If the rule is a custom rule, verify that the Lambda execution role includes the <code>config:PutEvaluations</code> permission.</p> </li> <li> <p>The rule\'s Lambda function has returned <code>NOT_APPLICABLE</code> for all evaluation results. This can occur if the resources were deleted or removed from the rule\'s scope.</p> </li> </ul>', 'DescribeConfigRuleEvaluationStatus' => '<p>Returns status information for each of your Config managed rules. The status includes information such as the last time Config invoked the rule, the last time Config failed to invoke the rule, and the related error for the last failure.</p>', 'DescribeConfigRules' => '<p>Returns details about your Config rules.</p>', 'DescribeConfigurationAggregatorSourcesStatus' => '<p>Returns status information for sources within an aggregator. The status includes information about the last time Config verified authorization between the source account and an aggregator account. In case of a failure, the status contains the related error code or message. </p>', 'DescribeConfigurationAggregators' => '<p>Returns the details of one or more configuration aggregators. If the configuration aggregator is not specified, this action returns the details for all the configuration aggregators associated with the account. </p>', 'DescribeConfigurationRecorderStatus' => '<p>Returns the current status of the specified configuration recorder. If a configuration recorder is not specified, this action returns the status of all configuration recorders associated with the account.</p> <note> <p>Currently, you can specify only one configuration recorder per region in your account.</p> </note>', 'DescribeConfigurationRecorders' => '<p>Returns the details for the specified configuration recorders. If the configuration recorder is not specified, this action returns the details for all configuration recorders associated with the account.</p> <note> <p>Currently, you can specify only one configuration recorder per region in your account.</p> </note>', 'DescribeConformancePackCompliance' => '<p>Returns compliance details for each rule in that conformance pack.</p> <note> <p>You must provide exact rule names.</p> </note>', 'DescribeConformancePackStatus' => '<p>Provides one or more conformance packs deployment status.</p> <note> <p>If there are no conformance packs then you will see an empty result.</p> </note>', 'DescribeConformancePacks' => '<p>Returns a list of one or more conformance packs.</p>', 'DescribeDeliveryChannelStatus' => '<p>Returns the current status of the specified delivery channel. If a delivery channel is not specified, this action returns the current status of all delivery channels associated with the account.</p> <note> <p>Currently, you can specify only one delivery channel per region in your account.</p> </note>', 'DescribeDeliveryChannels' => '<p>Returns details about the specified delivery channel. If a delivery channel is not specified, this action returns the details of all delivery channels associated with the account.</p> <note> <p>Currently, you can specify only one delivery channel per region in your account.</p> </note>', 'DescribeOrganizationConfigRuleStatuses' => '<p>Provides organization Config rule deployment status for an organization.</p> <note> <p>The status is not considered successful until organization Config rule is successfully deployed in all the member accounts with an exception of excluded accounts.</p> <p>When you specify the limit and the next token, you receive a paginated response. Limit and next token are not applicable if you specify organization Config rule names. It is only applicable, when you request all the organization Config rules.</p> </note>', 'DescribeOrganizationConfigRules' => '<p>Returns a list of organization Config rules. </p> <note> <p>When you specify the limit and the next token, you receive a paginated response. Limit and next token are not applicable if you specify organization Config rule names. It is only applicable, when you request all the organization Config rules.</p> </note>', 'DescribeOrganizationConformancePackStatuses' => '<p>Provides organization conformance pack deployment status for an organization. </p> <note> <p>The status is not considered successful until organization conformance pack is successfully deployed in all the member accounts with an exception of excluded accounts.</p> <p>When you specify the limit and the next token, you receive a paginated response. Limit and next token are not applicable if you specify organization conformance pack names. They are only applicable, when you request all the organization conformance packs.</p> </note>', 'DescribeOrganizationConformancePacks' => '<p>Returns a list of organization conformance packs. </p> <note> <p>When you specify the limit and the next token, you receive a paginated response. </p> <p>Limit and next token are not applicable if you specify organization conformance packs names. They are only applicable, when you request all the organization conformance packs. </p> </note>', 'DescribePendingAggregationRequests' => '<p>Returns a list of all pending aggregation requests.</p>', 'DescribeRemediationConfigurations' => '<p>Returns the details of one or more remediation configurations.</p>', 'DescribeRemediationExceptions' => '<p>Returns the details of one or more remediation exceptions. A detailed view of a remediation exception for a set of resources that includes an explanation of an exception and the time when the exception will be deleted. When you specify the limit and the next token, you receive a paginated response. </p> <note> <p>Config generates a remediation exception when a problem occurs executing a remediation action to a specific resource. Remediation exceptions blocks auto-remediation until the exception is cleared.</p> <p>When you specify the limit and the next token, you receive a paginated response. </p> <p>Limit and next token are not applicable if you request resources in batch. It is only applicable, when you request all resources.</p> </note>', 'DescribeRemediationExecutionStatus' => '<p>Provides a detailed view of a Remediation Execution for a set of resources including state, timestamps for when steps for the remediation execution occur, and any error messages for steps that have failed. When you specify the limit and the next token, you receive a paginated response.</p>', 'DescribeRetentionConfigurations' => '<p>Returns the details of one or more retention configurations. If the retention configuration name is not specified, this action returns the details for all the retention configurations for that account.</p> <note> <p>Currently, Config supports only one retention configuration per region in your account.</p> </note>', 'GetAggregateComplianceDetailsByConfigRule' => '<p>Returns the evaluation results for the specified Config rule for a specific resource in a rule. The results indicate which Amazon Web Services resources were evaluated by the rule, when each resource was last evaluated, and whether each resource complies with the rule. </p> <note> <p>The results can return an empty result page. But if you have a <code>nextToken</code>, the results are displayed on the next page.</p> </note>', 'GetAggregateConfigRuleComplianceSummary' => '<p>Returns the number of compliant and noncompliant rules for one or more accounts and regions in an aggregator.</p> <note> <p>The results can return an empty result page, but if you have a nextToken, the results are displayed on the next page.</p> </note>', 'GetAggregateConformancePackComplianceSummary' => '<p>Returns the count of compliant and noncompliant conformance packs across all Amazon Web Services accounts and Amazon Web Services Regions in an aggregator. You can filter based on Amazon Web Services account ID or Amazon Web Services Region.</p> <note> <p>The results can return an empty result page, but if you have a nextToken, the results are displayed on the next page.</p> </note>', 'GetAggregateDiscoveredResourceCounts' => '<p>Returns the resource counts across accounts and regions that are present in your Config aggregator. You can request the resource counts by providing filters and GroupByKey.</p> <p>For example, if the input contains accountID 12345678910 and region us-east-1 in filters, the API returns the count of resources in account ID 12345678910 and region us-east-1. If the input contains ACCOUNT_ID as a GroupByKey, the API returns resource counts for all source accounts that are present in your aggregator.</p>', 'GetAggregateResourceConfig' => '<p>Returns configuration item that is aggregated for your specific resource in a specific source account and region.</p>', 'GetComplianceDetailsByConfigRule' => '<p>Returns the evaluation results for the specified Config rule. The results indicate which Amazon Web Services resources were evaluated by the rule, when each resource was last evaluated, and whether each resource complies with the rule.</p>', 'GetComplianceDetailsByResource' => '<p>Returns the evaluation results for the specified Amazon Web Services resource. The results indicate which Config rules were used to evaluate the resource, when each rule was last used, and whether the resource complies with each rule.</p>', 'GetComplianceSummaryByConfigRule' => '<p>Returns the number of Config rules that are compliant and noncompliant, up to a maximum of 25 for each.</p>', 'GetComplianceSummaryByResourceType' => '<p>Returns the number of resources that are compliant and the number that are noncompliant. You can specify one or more resource types to get these numbers for each resource type. The maximum number returned is 100.</p>', 'GetConformancePackComplianceDetails' => '<p>Returns compliance details of a conformance pack for all Amazon Web Services resources that are monitered by conformance pack.</p>', 'GetConformancePackComplianceSummary' => '<p>Returns compliance details for the conformance pack based on the cumulative compliance results of all the rules in that conformance pack.</p>', 'GetCustomRulePolicy' => '<p>Returns the policy definition containing the logic for your Config Custom Policy rule.</p>', 'GetDiscoveredResourceCounts' => '<p>Returns the resource types, the number of each resource type, and the total number of resources that Config is recording in this region for your Amazon Web Services account. </p> <p class="title"> <b>Example</b> </p> <ol> <li> <p>Config is recording three resource types in the US East (Ohio) Region for your account: 25 EC2 instances, 20 IAM users, and 15 S3 buckets.</p> </li> <li> <p>You make a call to the <code>GetDiscoveredResourceCounts</code> action and specify that you want all resource types. </p> </li> <li> <p>Config returns the following:</p> <ul> <li> <p>The resource types (EC2 instances, IAM users, and S3 buckets).</p> </li> <li> <p>The number of each resource type (25, 20, and 15).</p> </li> <li> <p>The total number of all resources (60).</p> </li> </ul> </li> </ol> <p>The response is paginated. By default, Config lists 100 <a>ResourceCount</a> objects on each page. You can customize this number with the <code>limit</code> parameter. The response includes a <code>nextToken</code> string. To get the next page of results, run the request again and specify the string for the <code>nextToken</code> parameter.</p> <note> <p>If you make a call to the <a>GetDiscoveredResourceCounts</a> action, you might not immediately receive resource counts in the following situations:</p> <ul> <li> <p>You are a new Config customer.</p> </li> <li> <p>You just enabled resource recording.</p> </li> </ul> <p>It might take a few minutes for Config to record and count your resources. Wait a few minutes and then retry the <a>GetDiscoveredResourceCounts</a> action. </p> </note>', 'GetOrganizationConfigRuleDetailedStatus' => '<p>Returns detailed status for each member account within an organization for a given organization Config rule.</p>', 'GetOrganizationConformancePackDetailedStatus' => '<p>Returns detailed status for each member account within an organization for a given organization conformance pack.</p>', 'GetOrganizationCustomRulePolicy' => '<p>Returns the policy definition containing the logic for your organization Config Custom Policy rule.</p>', 'GetResourceConfigHistory' => '<p>Returns a list of <code>ConfigurationItems</code> for the specified resource. The list contains details about each state of the resource during the specified time interval. If you specified a retention period to retain your <code>ConfigurationItems</code> between a minimum of 30 days and a maximum of 7 years (2557 days), Config returns the <code>ConfigurationItems</code> for the specified retention period. </p> <p>The response is paginated. By default, Config returns a limit of 10 configuration items per page. You can customize this number with the <code>limit</code> parameter. The response includes a <code>nextToken</code> string. To get the next page of results, run the request again and specify the string for the <code>nextToken</code> parameter.</p> <note> <p>Each call to the API is limited to span a duration of seven days. It is likely that the number of records returned is smaller than the specified <code>limit</code>. In such cases, you can make another call, using the <code>nextToken</code>.</p> </note>', 'GetStoredQuery' => '<p>Returns the details of a specific stored query.</p>', 'ListAggregateDiscoveredResources' => '<p>Accepts a resource type and returns a list of resource identifiers that are aggregated for a specific resource type across accounts and regions. A resource identifier includes the resource type, ID, (if available) the custom resource name, source account, and source region. You can narrow the results to include only resources that have specific resource IDs, or a resource name, or source account ID, or source region.</p> <p>For example, if the input consists of accountID 12345678910 and the region is us-east-1 for resource type <code>AWS::EC2::Instance</code> then the API returns all the EC2 instance identifiers of accountID 12345678910 and region us-east-1.</p>', 'ListDiscoveredResources' => '<p>Accepts a resource type and returns a list of resource identifiers for the resources of that type. A resource identifier includes the resource type, ID, and (if available) the custom resource name. The results consist of resources that Config has discovered, including those that Config is not currently recording. You can narrow the results to include only resources that have specific resource IDs or a resource name.</p> <note> <p>You can specify either resource IDs or a resource name, but not both, in the same request.</p> </note> <p>The response is paginated. By default, Config lists 100 resource identifiers on each page. You can customize this number with the <code>limit</code> parameter. The response includes a <code>nextToken</code> string. To get the next page of results, run the request again and specify the string for the <code>nextToken</code> parameter.</p>', 'ListStoredQueries' => '<p>Lists the stored queries for a single Amazon Web Services account and a single Amazon Web Services Region. The default is 100. </p>', 'ListTagsForResource' => '<p>List the tags for Config resource.</p>', 'PutAggregationAuthorization' => '<p>Authorizes the aggregator account and region to collect data from the source account and region. </p>', 'PutConfigRule' => '<p>Adds or updates an Config rule for evaluating whether your Amazon Web Services resources comply with your desired configurations.</p> <p>You can use this action for Config custom rules and Config managed rules. A Config custom rule is a rule that you develop and maintain. An Config managed rule is a customizable, predefined rule that Config provides.</p> <p>If you are adding a new Config custom rule, you must first create the Lambda function that the rule invokes to evaluate your resources. When you use the <code>PutConfigRule</code> action to add the rule to Config, you must specify the Amazon Resource Name (ARN) that Lambda assigns to the function. Specify the ARN for the <code>SourceIdentifier</code> key. This key is part of the <code>Source</code> object, which is part of the <code>ConfigRule</code> object. </p> <p>If you are adding an Config managed rule, specify the rule\'s identifier for the <code>SourceIdentifier</code> key. To reference Config managed rule identifiers, see <a href="https://docs.aws.amazon.com/config/latest/developerguide/evaluate-config_use-managed-rules.html">About Config managed rules</a>.</p> <p>For any new rule that you add, specify the <code>ConfigRuleName</code> in the <code>ConfigRule</code> object. Do not specify the <code>ConfigRuleArn</code> or the <code>ConfigRuleId</code>. These values are generated by Config for new rules.</p> <p>If you are updating a rule that you added previously, you can specify the rule by <code>ConfigRuleName</code>, <code>ConfigRuleId</code>, or <code>ConfigRuleArn</code> in the <code>ConfigRule</code> data type that you use in this request.</p> <p>The maximum number of rules that Config supports is 150.</p> <p>For information about requesting a rule limit increase, see <a href="http://docs.aws.amazon.com/general/latest/gr/aws_service_limits.html#limits_config">Config Limits</a> in the <i>Amazon Web Services General Reference Guide</i>.</p> <p>For more information about developing and using Config rules, see <a href="https://docs.aws.amazon.com/config/latest/developerguide/evaluate-config.html">Evaluating Amazon Web Services resource Configurations with Config</a> in the <i>Config Developer Guide</i>.</p>', 'PutConfigurationAggregator' => '<p>Creates and updates the configuration aggregator with the selected source accounts and regions. The source account can be individual account(s) or an organization.</p> <p> <code>accountIds</code> that are passed will be replaced with existing accounts. If you want to add additional accounts into the aggregator, call <code>DescribeConfigurationAggregators</code> to get the previous accounts and then append new ones.</p> <note> <p>Config should be enabled in source accounts and regions you want to aggregate.</p> <p>If your source type is an organization, you must be signed in to the management account or a registered delegated administrator and all the features must be enabled in your organization. If the caller is a management account, Config calls <code>EnableAwsServiceAccess</code> API to enable integration between Config and Organizations. If the caller is a registered delegated administrator, Config calls <code>ListDelegatedAdministrators</code> API to verify whether the caller is a valid delegated administrator.</p> <p>To register a delegated administrator, see <a href="https://docs.aws.amazon.com/config/latest/developerguide/set-up-aggregator-cli.html#register-a-delegated-administrator-cli">Register a Delegated Administrator</a> in the Config developer guide. </p> </note>', 'PutConfigurationRecorder' => '<p>Creates a new configuration recorder to record the selected resource configurations.</p> <p>You can use this action to change the role <code>roleARN</code> or the <code>recordingGroup</code> of an existing recorder. To change the role, call the action on the existing configuration recorder and specify a role.</p> <note> <p>Currently, you can specify only one configuration recorder per region in your account.</p> <p>If <code>ConfigurationRecorder</code> does not have the <b>recordingGroup</b> parameter specified, the default is to record all supported resource types.</p> </note>', 'PutConformancePack' => '<p>Creates or updates a conformance pack. A conformance pack is a collection of Config rules that can be easily deployed in an account and a region and across Amazon Web Services Organization.</p> <p>This API creates a service linked role <code>AWSServiceRoleForConfigConforms</code> in your account. The service linked role is created only when the role does not exist in your account. </p> <note> <p>You must specify either the <code>TemplateS3Uri</code> or the <code>TemplateBody</code> parameter, but not both. If you provide both Config uses the <code>TemplateS3Uri</code> parameter and ignores the <code>TemplateBody</code> parameter.</p> </note>', 'PutDeliveryChannel' => '<p>Creates a delivery channel object to deliver configuration information to an Amazon S3 bucket and Amazon SNS topic.</p> <p>Before you can create a delivery channel, you must create a configuration recorder.</p> <p>You can use this action to change the Amazon S3 bucket or an Amazon SNS topic of the existing delivery channel. To change the Amazon S3 bucket or an Amazon SNS topic, call this action and specify the changed values for the S3 bucket and the SNS topic. If you specify a different value for either the S3 bucket or the SNS topic, this action will keep the existing value for the parameter that is not changed.</p> <note> <p>You can have only one delivery channel per region in your account.</p> </note>', 'PutEvaluations' => '<p>Used by an Lambda function to deliver evaluation results to Config. This action is required in every Lambda function that is invoked by an Config rule.</p>', 'PutExternalEvaluation' => '<p>Add or updates the evaluations for process checks. This API checks if the rule is a process check when the name of the Config rule is provided.</p>', 'PutOrganizationConfigRule' => '<p>Adds or updates organization Config rule for your entire organization evaluating whether your Amazon Web Services resources comply with your desired configurations.</p> <p> Only a master account and a delegated administrator can create or update an organization Config rule. When calling this API with a delegated administrator, you must ensure Organizations <code>ListDelegatedAdministrator</code> permissions are added. </p> <p>This API enables organization service access through the <code>EnableAWSServiceAccess</code> action and creates a service linked role <code>AWSServiceRoleForConfigMultiAccountSetup</code> in the master or delegated administrator account of your organization. The service linked role is created only when the role does not exist in the caller account. Config verifies the existence of role with <code>GetRole</code> action.</p> <p>To use this API with delegated administrator, register a delegated administrator by calling Amazon Web Services Organization <code>register-delegated-administrator</code> for <code>config-multiaccountsetup.amazonaws.com</code>. </p> <p>You can use this action to create both Config custom rules and Config managed rules. If you are adding a new Config custom rule, you must first create Lambda function in the master account or a delegated administrator that the rule invokes to evaluate your resources. You also need to create an IAM role in the managed-account that can be assumed by the Lambda function. When you use the <code>PutOrganizationConfigRule</code> action to add the rule to Config, you must specify the Amazon Resource Name (ARN) that Lambda assigns to the function. If you are adding an Config managed rule, specify the rule\'s identifier for the <code>RuleIdentifier</code> key.</p> <p>The maximum number of organization Config rules that Config supports is 150 and 3 delegated administrator per organization. </p> <note> <p>Prerequisite: Ensure you call <code>EnableAllFeatures</code> API to enable all features in an organization.</p> <p>Specify either <code>OrganizationCustomRuleMetadata</code> or <code>OrganizationManagedRuleMetadata</code>.</p> </note>', 'PutOrganizationConformancePack' => '<p>Deploys conformance packs across member accounts in an Amazon Web Services Organization.</p> <p>Only a master account and a delegated administrator can call this API. When calling this API with a delegated administrator, you must ensure Organizations <code>ListDelegatedAdministrator</code> permissions are added.</p> <p>This API enables organization service access for <code>config-multiaccountsetup.amazonaws.com</code> through the <code>EnableAWSServiceAccess</code> action and creates a service linked role <code>AWSServiceRoleForConfigMultiAccountSetup</code> in the master or delegated administrator account of your organization. The service linked role is created only when the role does not exist in the caller account. To use this API with delegated administrator, register a delegated administrator by calling Amazon Web Services Organization <code>register-delegate-admin</code> for <code>config-multiaccountsetup.amazonaws.com</code>.</p> <note> <p>Prerequisite: Ensure you call <code>EnableAllFeatures</code> API to enable all features in an organization.</p> <p>You must specify either the <code>TemplateS3Uri</code> or the <code>TemplateBody</code> parameter, but not both. If you provide both Config uses the <code>TemplateS3Uri</code> parameter and ignores the <code>TemplateBody</code> parameter.</p> <p>Config sets the state of a conformance pack to CREATE_IN_PROGRESS and UPDATE_IN_PROGRESS until the conformance pack is created or updated. You cannot update a conformance pack while it is in this state.</p> <p>You can create 50 conformance packs with 25 Config rules in each pack and 3 delegated administrator per organization. </p> </note>', 'PutRemediationConfigurations' => '<p>Adds or updates the remediation configuration with a specific Config rule with the selected target or action. The API creates the <code>RemediationConfiguration</code> object for the Config rule. The Config rule must already exist for you to add a remediation configuration. The target (SSM document) must exist and have permissions to use the target. </p> <note> <p>If you make backward incompatible changes to the SSM document, you must call this again to ensure the remediations can run.</p> <p>This API does not support adding remediation configurations for service-linked Config Rules such as Organization Config rules, the rules deployed by conformance packs, and rules deployed by Amazon Web Services Security Hub.</p> </note>', 'PutRemediationExceptions' => '<p>A remediation exception is when a specific resource is no longer considered for auto-remediation. This API adds a new exception or updates an existing exception for a specific resource with a specific Config rule. </p> <note> <p>Config generates a remediation exception when a problem occurs executing a remediation action to a specific resource. Remediation exceptions blocks auto-remediation until the exception is cleared.</p> </note>', 'PutResourceConfig' => '<p>Records the configuration state for the resource provided in the request. The configuration state of a resource is represented in Config as Configuration Items. Once this API records the configuration item, you can retrieve the list of configuration items for the custom resource type using existing Config APIs. </p> <note> <p>The custom resource type must be registered with CloudFormation. This API accepts the configuration item registered with CloudFormation.</p> <p>When you call this API, Config only stores configuration state of the resource provided in the request. This API does not change or remediate the configuration of the resource. </p> <p>Write-only schema properites are not recorded as part of the published configuration item.</p> </note>', 'PutRetentionConfiguration' => '<p>Creates and updates the retention configuration with details about retention period (number of days) that Config stores your historical information. The API creates the <code>RetentionConfiguration</code> object and names the object as <b>default</b>. When you have a <code>RetentionConfiguration</code> object named <b>default</b>, calling the API modifies the default object. </p> <note> <p>Currently, Config supports only one retention configuration per region in your account.</p> </note>', 'PutStoredQuery' => '<p>Saves a new query or updates an existing saved query. The <code>QueryName</code> must be unique for a single Amazon Web Services account and a single Amazon Web Services Region. You can create upto 300 queries in a single Amazon Web Services account and a single Amazon Web Services Region.</p>', 'SelectAggregateResourceConfig' => '<p>Accepts a structured query language (SQL) SELECT command and an aggregator to query configuration state of Amazon Web Services resources across multiple accounts and regions, performs the corresponding search, and returns resource configurations matching the properties.</p> <p>For more information about query components, see the <a href="https://docs.aws.amazon.com/config/latest/developerguide/query-components.html"> <b>Query Components</b> </a> section in the Config Developer Guide.</p> <note> <p>If you run an aggregation query (i.e., using <code>GROUP BY</code> or using aggregate functions such as <code>COUNT</code>; e.g., <code>SELECT resourceId, COUNT(*) WHERE resourceType = \'AWS::IAM::Role\' GROUP BY resourceId</code>) and do not specify the <code>MaxResults</code> or the <code>Limit</code> query parameters, the default page size is set to 500.</p> <p>If you run a non-aggregation query (i.e., not using <code>GROUP BY</code> or aggregate function; e.g., <code>SELECT * WHERE resourceType = \'AWS::IAM::Role\'</code>) and do not specify the <code>MaxResults</code> or the <code>Limit</code> query parameters, the default page size is set to 25.</p> </note>', 'SelectResourceConfig' => '<p>Accepts a structured query language (SQL) <code>SELECT</code> command, performs the corresponding search, and returns resource configurations matching the properties.</p> <p>For more information about query components, see the <a href="https://docs.aws.amazon.com/config/latest/developerguide/query-components.html"> <b>Query Components</b> </a> section in the Config Developer Guide.</p>', 'StartConfigRulesEvaluation' => '<p>Runs an on-demand evaluation for the specified Config rules against the last known configuration state of the resources. Use <code>StartConfigRulesEvaluation</code> when you want to test that a rule you updated is working as expected. <code>StartConfigRulesEvaluation</code> does not re-record the latest configuration state for your resources. It re-runs an evaluation against the last known state of your resources. </p> <p>You can specify up to 25 Config rules per request. </p> <p>An existing <code>StartConfigRulesEvaluation</code> call for the specified rules must complete before you can call the API again. If you chose to have Config stream to an Amazon SNS topic, you will receive a <code>ConfigRuleEvaluationStarted</code> notification when the evaluation starts.</p> <note> <p>You don\'t need to call the <code>StartConfigRulesEvaluation</code> API to run an evaluation for a new rule. When you create a rule, Config evaluates your resources against the rule automatically. </p> </note> <p>The <code>StartConfigRulesEvaluation</code> API is useful if you want to run on-demand evaluations, such as the following example:</p> <ol> <li> <p>You have a custom rule that evaluates your IAM resources every 24 hours.</p> </li> <li> <p>You update your Lambda function to add additional conditions to your rule.</p> </li> <li> <p>Instead of waiting for the next periodic evaluation, you call the <code>StartConfigRulesEvaluation</code> API.</p> </li> <li> <p>Config invokes your Lambda function and evaluates your IAM resources.</p> </li> <li> <p>Your custom rule will still run periodic evaluations every 24 hours.</p> </li> </ol>', 'StartConfigurationRecorder' => '<p>Starts recording configurations of the Amazon Web Services resources you have selected to record in your Amazon Web Services account.</p> <p>You must have created at least one delivery channel to successfully start the configuration recorder.</p>', 'StartRemediationExecution' => '<p>Runs an on-demand remediation for the specified Config rules against the last known remediation configuration. It runs an execution against the current state of your resources. Remediation execution is asynchronous.</p> <p>You can specify up to 100 resource keys per request. An existing StartRemediationExecution call for the specified resource keys must complete before you can call the API again.</p>', 'StopConfigurationRecorder' => '<p>Stops recording configurations of the Amazon Web Services resources you have selected to record in your Amazon Web Services account.</p>', 'TagResource' => '<p>Associates the specified tags to a resource with the specified resourceArn. If existing tags on a resource are not specified in the request parameters, they are not changed. When a resource is deleted, the tags associated with that resource are deleted as well.</p>', 'UntagResource' => '<p>Deletes specified tags from a resource.</p>', ], 'shapes' => [ 'ARN' => [ 'base' => NULL, 'refs' => [ 'BaseConfigurationItem$arn' => '<p>The Amazon Resource Name (ARN) of the resource.</p>', 'ConfigurationItem$arn' => '<p>Amazon Resource Name (ARN) associated with the resource.</p>', ], ], 'AccountAggregationSource' => [ 'base' => '<p>A collection of accounts and regions.</p>', 'refs' => [ 'AccountAggregationSourceList$member' => NULL, ], ], 'AccountAggregationSourceAccountList' => [ 'base' => NULL, 'refs' => [ 'AccountAggregationSource$AccountIds' => '<p>The 12-digit account ID of the account being aggregated. </p>', ], ], 'AccountAggregationSourceList' => [ 'base' => NULL, 'refs' => [ 'ConfigurationAggregator$AccountAggregationSources' => '<p>Provides a list of source accounts and regions to be aggregated.</p>', 'PutConfigurationAggregatorRequest$AccountAggregationSources' => '<p>A list of AccountAggregationSource object. </p>', ], ], 'AccountId' => [ 'base' => NULL, 'refs' => [ 'AccountAggregationSourceAccountList$member' => NULL, 'AggregateComplianceByConfigRule$AccountId' => '<p>The 12-digit account ID of the source account.</p>', 'AggregateComplianceByConformancePack$AccountId' => '<p>The 12-digit Amazon Web Services account ID of the source account.</p>', 'AggregateConformancePackComplianceFilters$AccountId' => '<p>The 12-digit Amazon Web Services account ID of the source account.</p>', 'AggregateConformancePackComplianceSummaryFilters$AccountId' => '<p>The 12-digit Amazon Web Services account ID of the source account.</p>', 'AggregateEvaluationResult$AccountId' => '<p>The 12-digit account ID of the source account.</p>', 'AggregateResourceIdentifier$SourceAccountId' => '<p>The 12-digit account ID of the source account.</p>', 'AggregationAuthorization$AuthorizedAccountId' => '<p>The 12-digit account ID of the account authorized to aggregate data.</p>', 'BaseConfigurationItem$accountId' => '<p>The 12-digit Amazon Web Services account ID associated with the resource.</p>', 'ConfigRuleComplianceFilters$AccountId' => '<p>The 12-digit account ID of the source account. </p>', 'ConfigRuleComplianceSummaryFilters$AccountId' => '<p>The 12-digit account ID of the source account.</p>', 'ConfigurationItem$accountId' => '<p>The 12-digit Amazon Web Services account ID associated with the resource.</p>', 'DebugLogDeliveryAccounts$member' => NULL, 'DeleteAggregationAuthorizationRequest$AuthorizedAccountId' => '<p>The 12-digit account ID of the account authorized to aggregate data.</p>', 'DeletePendingAggregationRequestRequest$RequesterAccountId' => '<p>The 12-digit account ID of the account requesting to aggregate data.</p>', 'ExcludedAccounts$member' => NULL, 'GetAggregateComplianceDetailsByConfigRuleRequest$AccountId' => '<p>The 12-digit account ID of the source account.</p>', 'MemberAccountStatus$AccountId' => '<p>The 12-digit account ID of a member account.</p>', 'OrganizationConformancePackDetailedStatus$AccountId' => '<p>The 12-digit account ID of a member account.</p>', 'OrganizationResourceDetailedStatusFilters$AccountId' => '<p>The 12-digit account ID of the member account within an organization.</p>', 'PendingAggregationRequest$RequesterAccountId' => '<p>The 12-digit account ID of the account requesting to aggregate data.</p>', 'PutAggregationAuthorizationRequest$AuthorizedAccountId' => '<p>The 12-digit account ID of the account authorized to aggregate data.</p>', 'ResourceCountFilters$AccountId' => '<p>The 12-digit ID of the account.</p>', 'ResourceFilters$AccountId' => '<p>The 12-digit source account ID.</p>', 'StatusDetailFilters$AccountId' => '<p>The 12-digit account ID of the member account within an organization.</p>', ], ], 'AggregateComplianceByConfigRule' => [ 'base' => '<p>Indicates whether an Config rule is compliant based on account ID, region, compliance, and rule name.</p> <p>A rule is compliant if all of the resources that the rule evaluated comply with it. It is noncompliant if any of these resources do not comply.</p>', 'refs' => [ 'AggregateComplianceByConfigRuleList$member' => NULL, ], ], 'AggregateComplianceByConfigRuleList' => [ 'base' => NULL, 'refs' => [ 'DescribeAggregateComplianceByConfigRulesResponse$AggregateComplianceByConfigRules' => '<p>Returns a list of AggregateComplianceByConfigRule object.</p>', ], ], 'AggregateComplianceByConformancePack' => [ 'base' => '<p>Provides aggregate compliance of the conformance pack. Indicates whether a conformance pack is compliant based on the name of the conformance pack, account ID, and region.</p> <p>A conformance pack is compliant if all of the rules in a conformance packs are compliant. It is noncompliant if any of the rules are not compliant. The compliance status of a conformance pack is INSUFFICIENT_DATA only if all rules within a conformance pack cannot be evaluated due to insufficient data. If some of the rules in a conformance pack are compliant but the compliance status of other rules in that same conformance pack is INSUFFICIENT_DATA, the conformance pack shows compliant.</p>', 'refs' => [ 'AggregateComplianceByConformancePackList$member' => NULL, ], ], 'AggregateComplianceByConformancePackList' => [ 'base' => NULL, 'refs' => [ 'DescribeAggregateComplianceByConformancePacksResponse$AggregateComplianceByConformancePacks' => '<p>Returns the <code>AggregateComplianceByConformancePack</code> object.</p>', ], ], 'AggregateComplianceCount' => [ 'base' => '<p>Returns the number of compliant and noncompliant rules for one or more accounts and regions in an aggregator.</p>', 'refs' => [ 'AggregateComplianceCountList$member' => NULL, ], ], 'AggregateComplianceCountList' => [ 'base' => NULL, 'refs' => [ 'GetAggregateConfigRuleComplianceSummaryResponse$AggregateComplianceCounts' => '<p>Returns a list of AggregateComplianceCounts object.</p>', ], ], 'AggregateConformancePackCompliance' => [ 'base' => '<p>Provides the number of compliant and noncompliant rules within a conformance pack. Also provides the compliance status of the conformance pack and the total rule count which includes compliant rules, noncompliant rules, and rules that cannot be evaluated due to insufficient data.</p> <p>A conformance pack is compliant if all of the rules in a conformance packs are compliant. It is noncompliant if any of the rules are not compliant. The compliance status of a conformance pack is INSUFFICIENT_DATA only if all rules within a conformance pack cannot be evaluated due to insufficient data. If some of the rules in a conformance pack are compliant but the compliance status of other rules in that same conformance pack is INSUFFICIENT_DATA, the conformance pack shows compliant.</p>', 'refs' => [ 'AggregateComplianceByConformancePack$Compliance' => '<p>The compliance status of the conformance pack.</p>', ], ], 'AggregateConformancePackComplianceCount' => [ 'base' => '<p>The number of conformance packs that are compliant and noncompliant.</p>', 'refs' => [ 'AggregateConformancePackComplianceSummary$ComplianceSummary' => '<p>Returns an <code>AggregateConformancePackComplianceCount</code> object. </p>', ], ], 'AggregateConformancePackComplianceFilters' => [ 'base' => '<p>Filters the conformance packs based on an account ID, region, compliance type, and the name of the conformance pack.</p>', 'refs' => [ 'DescribeAggregateComplianceByConformancePacksRequest$Filters' => '<p>Filters the result by <code>AggregateConformancePackComplianceFilters</code> object.</p>', ], ], 'AggregateConformancePackComplianceSummary' => [ 'base' => '<p>Provides a summary of compliance based on either account ID or region. </p>', 'refs' => [ 'AggregateConformancePackComplianceSummaryList$member' => NULL, ], ], 'AggregateConformancePackComplianceSummaryFilters' => [ 'base' => '<p>Filters the results based on account ID and region. </p>', 'refs' => [ 'GetAggregateConformancePackComplianceSummaryRequest$Filters' => '<p>Filters the results based on the <code>AggregateConformancePackComplianceSummaryFilters</code> object.</p>', ], ], 'AggregateConformancePackComplianceSummaryGroupKey' => [ 'base' => NULL, 'refs' => [ 'GetAggregateConformancePackComplianceSummaryRequest$GroupByKey' => '<p>Groups the result based on Amazon Web Services account ID or Amazon Web Services Region.</p>', ], ], 'AggregateConformancePackComplianceSummaryList' => [ 'base' => NULL, 'refs' => [ 'GetAggregateConformancePackComplianceSummaryResponse$AggregateConformancePackComplianceSummaries' => '<p>Returns a list of <code>AggregateConformancePackComplianceSummary</code> object.</p>', ], ], 'AggregateEvaluationResult' => [ 'base' => '<p>The details of an Config evaluation for an account ID and region in an aggregator. Provides the Amazon Web Services resource that was evaluated, the compliance of the resource, related time stamps, and supplementary information. </p>', 'refs' => [ 'AggregateEvaluationResultList$member' => NULL, ], ], 'AggregateEvaluationResultList' => [ 'base' => NULL, 'refs' => [ 'GetAggregateComplianceDetailsByConfigRuleResponse$AggregateEvaluationResults' => '<p>Returns an AggregateEvaluationResults object.</p>', ], ], 'AggregateResourceIdentifier' => [ 'base' => '<p>The details that identify a resource that is collected by Config aggregator, including the resource type, ID, (if available) the custom resource name, the source account, and source region.</p>', 'refs' => [ 'DiscoveredResourceIdentifierList$member' => NULL, 'GetAggregateResourceConfigRequest$ResourceIdentifier' => '<p>An object that identifies aggregate resource.</p>', 'ResourceIdentifiersList$member' => NULL, 'UnprocessedResourceIdentifierList$member' => NULL, ], ], 'AggregatedSourceStatus' => [ 'base' => '<p>The current sync status between the source and the aggregator account.</p>', 'refs' => [ 'AggregatedSourceStatusList$member' => NULL, ], ], 'AggregatedSourceStatusList' => [ 'base' => NULL, 'refs' => [ 'DescribeConfigurationAggregatorSourcesStatusResponse$AggregatedSourceStatusList' => '<p>Returns an AggregatedSourceStatus object. </p>', ], ], 'AggregatedSourceStatusType' => [ 'base' => NULL, 'refs' => [ 'AggregatedSourceStatus$LastUpdateStatus' => '<p>Filters the last updated status type.</p> <ul> <li> <p>Valid value FAILED indicates errors while moving data.</p> </li> <li> <p>Valid value SUCCEEDED indicates the data was successfully moved.</p> </li> <li> <p>Valid value OUTDATED indicates the data is not the most recent.</p> </li> </ul>', 'AggregatedSourceStatusTypeList$member' => NULL, ], ], 'AggregatedSourceStatusTypeList' => [ 'base' => NULL, 'refs' => [ 'DescribeConfigurationAggregatorSourcesStatusRequest$UpdateStatus' => '<p>Filters the status type.</p> <ul> <li> <p>Valid value FAILED indicates errors while moving data.</p> </li> <li> <p>Valid value SUCCEEDED indicates the data was successfully moved.</p> </li> <li> <p>Valid value OUTDATED indicates the data is not the most recent.</p> </li> </ul>', ], ], 'AggregatedSourceType' => [ 'base' => NULL, 'refs' => [ 'AggregatedSourceStatus$SourceType' => '<p>The source account or an organization.</p>', ], ], 'AggregationAuthorization' => [ 'base' => '<p>An object that represents the authorizations granted to aggregator accounts and regions.</p>', 'refs' => [ 'AggregationAuthorizationList$member' => NULL, 'PutAggregationAuthorizationResponse$AggregationAuthorization' => '<p>Returns an AggregationAuthorization object. </p>', ], ], 'AggregationAuthorizationList' => [ 'base' => NULL, 'refs' => [ 'DescribeAggregationAuthorizationsResponse$AggregationAuthorizations' => '<p>Returns a list of authorizations granted to various aggregator accounts and regions.</p>', ], ], 'AggregatorRegionList' => [ 'base' => NULL, 'refs' => [ 'AccountAggregationSource$AwsRegions' => '<p>The source regions being aggregated.</p>', 'OrganizationAggregationSource$AwsRegions' => '<p>The source regions being aggregated.</p>', ], ], 'AllSupported' => [ 'base' => NULL, 'refs' => [ 'RecordingGroup$allSupported' => '<p>Specifies whether Config records configuration changes for every supported type of regional resource.</p> <p>If you set this option to <code>true</code>, when Config adds support for a new type of regional resource, it starts recording resources of that type automatically.</p> <p>If you set this option to <code>true</code>, you cannot enumerate a list of <code>resourceTypes</code>.</p>', ], ], 'AmazonResourceName' => [ 'base' => NULL, 'refs' => [ 'ListTagsForResourceRequest$ResourceArn' => '<p>The Amazon Resource Name (ARN) that identifies the resource for which to list the tags. Currently, the supported resources are <code>ConfigRule</code>, <code>ConfigurationAggregator</code> and <code>AggregatorAuthorization</code>.</p>', 'TagResourceRequest$ResourceArn' => '<p>The Amazon Resource Name (ARN) that identifies the resource for which to list the tags. Currently, the supported resources are <code>ConfigRule</code>, <code>ConfigurationAggregator</code> and <code>AggregatorAuthorization</code>.</p>', 'UntagResourceRequest$ResourceArn' => '<p>The Amazon Resource Name (ARN) that identifies the resource for which to list the tags. Currently, the supported resources are <code>ConfigRule</code>, <code>ConfigurationAggregator</code> and <code>AggregatorAuthorization</code>.</p>', ], ], 'Annotation' => [ 'base' => NULL, 'refs' => [ 'ConformancePackEvaluationResult$Annotation' => '<p>Supplementary information about how the evaluation determined the compliance. </p>', ], ], 'AutoRemediationAttemptSeconds' => [ 'base' => NULL, 'refs' => [ 'RemediationConfiguration$RetryAttemptSeconds' => '<p>Maximum time in seconds that Config runs auto-remediation. If you do not select a number, the default is 60 seconds. </p> <p>For example, if you specify RetryAttemptSeconds as 50 seconds and MaximumAutomaticAttempts as 5, Config will run auto-remediations 5 times within 50 seconds before throwing an exception.</p>', ], ], 'AutoRemediationAttempts' => [ 'base' => NULL, 'refs' => [ 'RemediationConfiguration$MaximumAutomaticAttempts' => '<p>The maximum number of failed attempts for auto-remediation. If you do not select a number, the default is 5.</p> <p>For example, if you specify MaximumAutomaticAttempts as 5 with RetryAttemptSeconds as 50 seconds, Config will put a RemediationException on your behalf for the failing resource after the 5th failed attempt within 50 seconds.</p>', ], ], 'AvailabilityZone' => [ 'base' => NULL, 'refs' => [ 'BaseConfigurationItem$availabilityZone' => '<p>The Availability Zone associated with the resource.</p>', 'ConfigurationItem$availabilityZone' => '<p>The Availability Zone associated with the resource.</p>', ], ], 'AwsRegion' => [ 'base' => NULL, 'refs' => [ 'AggregateComplianceByConfigRule$AwsRegion' => '<p>The source region from where the data is aggregated.</p>', 'AggregateComplianceByConformancePack$AwsRegion' => '<p>The source Amazon Web Services Region from where the data is aggregated.</p>', 'AggregateConformancePackComplianceFilters$AwsRegion' => '<p>The source Amazon Web Services Region from where the data is aggregated.</p>', 'AggregateConformancePackComplianceSummaryFilters$AwsRegion' => '<p>The source Amazon Web Services Region from where the data is aggregated.</p>', 'AggregateEvaluationResult$AwsRegion' => '<p>The source region from where the data is aggregated.</p>', 'AggregateResourceIdentifier$SourceRegion' => '<p>The source region where data is aggregated.</p>', 'AggregatedSourceStatus$AwsRegion' => '<p>The region authorized to collect aggregated data.</p>', 'AggregationAuthorization$AuthorizedAwsRegion' => '<p>The region authorized to collect aggregated data.</p>', 'BaseConfigurationItem$awsRegion' => '<p>The region where the resource resides.</p>', 'ConfigRuleComplianceFilters$AwsRegion' => '<p>The source region where the data is aggregated. </p>', 'ConfigRuleComplianceSummaryFilters$AwsRegion' => '<p>The source region where the data is aggregated.</p>', 'ConfigurationItem$awsRegion' => '<p>The region where the resource resides.</p>', 'DeleteAggregationAuthorizationRequest$AuthorizedAwsRegion' => '<p>The region authorized to collect aggregated data.</p>', 'DeletePendingAggregationRequestRequest$RequesterAwsRegion' => '<p>The region requesting to aggregate data.</p>', 'GetAggregateComplianceDetailsByConfigRuleRequest$AwsRegion' => '<p>The source region from where the data is aggregated.</p>', 'PendingAggregationRequest$RequesterAwsRegion' => '<p>The region requesting to aggregate data. </p>', 'PutAggregationAuthorizationRequest$AuthorizedAwsRegion' => '<p>The region authorized to collect aggregated data.</p>', 'ResourceCountFilters$Region' => '<p>The region where the account is located.</p>', 'ResourceFilters$Region' => '<p>The source region.</p>', ], ], 'BaseConfigurationItem' => [ 'base' => '<p>The detailed configuration of a specified resource.</p>', 'refs' => [ 'BaseConfigurationItems$member' => NULL, ], ], 'BaseConfigurationItems' => [ 'base' => NULL, 'refs' => [ 'BatchGetAggregateResourceConfigResponse$BaseConfigurationItems' => '<p>A list that contains the current configuration of one or more resources.</p>', 'BatchGetResourceConfigResponse$baseConfigurationItems' => '<p>A list that contains the current configuration of one or more resources.</p>', ], ], 'BaseResourceId' => [ 'base' => NULL, 'refs' => [ 'ComplianceByResource$ResourceId' => '<p>The ID of the Amazon Web Services resource that was evaluated.</p>', 'DescribeComplianceByResourceRequest$ResourceId' => '<p>The ID of the Amazon Web Services resource for which you want compliance information. You can specify only one resource ID. If you specify a resource ID, you must also specify a type for <code>ResourceType</code>.</p>', 'Evaluation$ComplianceResourceId' => '<p>The ID of the Amazon Web Services resource that was evaluated.</p>', 'EvaluationResultQualifier$ResourceId' => '<p>The ID of the evaluated Amazon Web Services resource.</p>', 'ExternalEvaluation$ComplianceResourceId' => '<p>The evaluated compliance resource ID. Config accepts only Amazon Web Services account ID.</p>', 'GetComplianceDetailsByResourceRequest$ResourceId' => '<p>The ID of the Amazon Web Services resource for which you want compliance information.</p>', 'Scope$ComplianceResourceId' => '<p>The ID of the only Amazon Web Services resource that you want to trigger an evaluation for the rule. If you specify a resource ID, you must specify one resource type for <code>ComplianceResourceTypes</code>.</p>', ], ], 'BatchGetAggregateResourceConfigRequest' => [ 'base' => NULL, 'refs' => [], ], 'BatchGetAggregateResourceConfigResponse' => [ 'base' => NULL, 'refs' => [], ], 'BatchGetResourceConfigRequest' => [ 'base' => NULL, 'refs' => [], ], 'BatchGetResourceConfigResponse' => [ 'base' => NULL, 'refs' => [], ], 'Boolean' => [ 'base' => NULL, 'refs' => [ 'AccountAggregationSource$AllAwsRegions' => '<p>If true, aggregate existing Config regions and future regions.</p>', 'ComplianceContributorCount$CapExceeded' => '<p>Indicates whether the maximum count is reached.</p>', 'ConfigRuleEvaluationStatus$FirstEvaluationStarted' => '<p>Indicates whether Config has evaluated your resources against the rule at least once.</p> <ul> <li> <p> <code>true</code> - Config has evaluated your Amazon Web Services resources against the rule at least once.</p> </li> <li> <p> <code>false</code> - Config has not finished evaluating your Amazon Web Services resources against the rule at least once.</p> </li> </ul>', 'ConfigurationRecorderStatus$recording' => '<p>Specifies whether or not the recorder is currently recording.</p>', 'CustomPolicyDetails$EnableDebugLogDelivery' => '<p>The boolean expression for enabling debug logging for your Config Custom Policy rule. The default value is <code>false</code>.</p>', 'ListDiscoveredResourcesRequest$includeDeletedResources' => '<p>Specifies whether Config includes deleted resources in the results. By default, deleted resources are not included.</p>', 'OrganizationAggregationSource$AllAwsRegions' => '<p>If true, aggregate existing Config regions and future regions.</p>', 'PutEvaluationsRequest$TestMode' => '<p>Use this parameter to specify a test run for <code>PutEvaluations</code>. You can verify whether your Lambda function will deliver evaluation results to Config. No updates occur to your existing evaluations, and evaluation results are not sent to Config.</p> <note> <p>When <code>TestMode</code> is <code>true</code>, <code>PutEvaluations</code> doesn\'t require a valid value for the <code>ResultToken</code> parameter, but the value cannot be null.</p> </note>', 'RemediationConfiguration$Automatic' => '<p>The remediation is triggered automatically.</p>', ], ], 'ChannelName' => [ 'base' => NULL, 'refs' => [ 'DeleteDeliveryChannelRequest$DeliveryChannelName' => '<p>The name of the delivery channel to delete.</p>', 'DeliverConfigSnapshotRequest$deliveryChannelName' => '<p>The name of the delivery channel through which the snapshot is delivered.</p>', 'DeliveryChannel$name' => '<p>The name of the delivery channel. By default, Config assigns the name "default" when creating the delivery channel. To change the delivery channel name, you must use the DeleteDeliveryChannel action to delete your current delivery channel, and then you must use the PutDeliveryChannel command to create a delivery channel that has the desired name.</p>', 'DeliveryChannelNameList$member' => NULL, ], ], 'ChronologicalOrder' => [ 'base' => NULL, 'refs' => [ 'GetResourceConfigHistoryRequest$chronologicalOrder' => '<p>The chronological order for configuration items listed. By default, the results are listed in reverse chronological order.</p>', ], ], 'Compliance' => [ 'base' => '<p>Indicates whether an Amazon Web Services resource or Config rule is compliant and provides the number of contributors that affect the compliance.</p>', 'refs' => [ 'AggregateComplianceByConfigRule$Compliance' => '<p>Indicates whether an Amazon Web Services resource or Config rule is compliant and provides the number of contributors that affect the compliance.</p>', 'ComplianceByConfigRule$Compliance' => '<p>Indicates whether the Config rule is compliant.</p>', 'ComplianceByResource$Compliance' => '<p>Indicates whether the Amazon Web Services resource complies with all of the Config rules that evaluated it.</p>', ], ], 'ComplianceByConfigRule' => [ 'base' => '<p>Indicates whether an Config rule is compliant. A rule is compliant if all of the resources that the rule evaluated comply with it. A rule is noncompliant if any of these resources do not comply.</p>', 'refs' => [ 'ComplianceByConfigRules$member' => NULL, ], ], 'ComplianceByConfigRules' => [ 'base' => NULL, 'refs' => [ 'DescribeComplianceByConfigRuleResponse$ComplianceByConfigRules' => '<p>Indicates whether each of the specified Config rules is compliant.</p>', ], ], 'ComplianceByResource' => [ 'base' => '<p>Indicates whether an Amazon Web Services resource that is evaluated according to one or more Config rules is compliant. A resource is compliant if it complies with all of the rules that evaluate it. A resource is noncompliant if it does not comply with one or more of these rules.</p>', 'refs' => [ 'ComplianceByResources$member' => NULL, ], ], 'ComplianceByResources' => [ 'base' => NULL, 'refs' => [ 'DescribeComplianceByResourceResponse$ComplianceByResources' => '<p>Indicates whether the specified Amazon Web Services resource complies with all of the Config rules that evaluate it.</p>', ], ], 'ComplianceContributorCount' => [ 'base' => '<p>The number of Amazon Web Services resources or Config rules responsible for the current compliance of the item, up to a maximum number.</p>', 'refs' => [ 'Compliance$ComplianceContributorCount' => '<p>The number of Amazon Web Services resources or Config rules that cause a result of <code>NON_COMPLIANT</code>, up to a maximum number.</p>', 'ComplianceSummary$CompliantResourceCount' => '<p>The number of Config rules or Amazon Web Services resources that are compliant, up to a maximum of 25 for rules and 100 for resources.</p>', 'ComplianceSummary$NonCompliantResourceCount' => '<p>The number of Config rules or Amazon Web Services resources that are noncompliant, up to a maximum of 25 for rules and 100 for resources.</p>', ], ], 'ComplianceResourceTypes' => [ 'base' => NULL, 'refs' => [ 'Scope$ComplianceResourceTypes' => '<p>The resource types of only those Amazon Web Services resources that you want to trigger an evaluation for the rule. You can only specify one type if you also specify a resource ID for <code>ComplianceResourceId</code>.</p>', ], ], 'ComplianceSummariesByResourceType' => [ 'base' => NULL, 'refs' => [ 'GetComplianceSummaryByResourceTypeResponse$ComplianceSummariesByResourceType' => '<p>The number of resources that are compliant and the number that are noncompliant. If one or more resource types were provided with the request, the numbers are returned for each resource type. The maximum number returned is 100.</p>', ], ], 'ComplianceSummary' => [ 'base' => '<p>The number of Config rules or Amazon Web Services resources that are compliant and noncompliant.</p>', 'refs' => [ 'AggregateComplianceCount$ComplianceSummary' => '<p>The number of compliant and noncompliant Config rules.</p>', 'ComplianceSummaryByResourceType$ComplianceSummary' => '<p>The number of Amazon Web Services resources that are compliant or noncompliant, up to a maximum of 100 for each.</p>', 'GetComplianceSummaryByConfigRuleResponse$ComplianceSummary' => '<p>The number of Config rules that are compliant and the number that are noncompliant, up to a maximum of 25 for each.</p>', ], ], 'ComplianceSummaryByResourceType' => [ 'base' => '<p>The number of Amazon Web Services resources of a specific type that are compliant or noncompliant, up to a maximum of 100 for each.</p>', 'refs' => [ 'ComplianceSummariesByResourceType$member' => NULL, ], ], 'ComplianceType' => [ 'base' => NULL, 'refs' => [ 'AggregateEvaluationResult$ComplianceType' => '<p>The resource compliance status.</p> <p>For the <code>AggregationEvaluationResult</code> data type, Config supports only the <code>COMPLIANT</code> and <code>NON_COMPLIANT</code>. Config does not support the <code>NOT_APPLICABLE</code> and <code>INSUFFICIENT_DATA</code> value.</p>', 'Compliance$ComplianceType' => '<p>Indicates whether an Amazon Web Services resource or Config rule is compliant.</p> <p>A resource is compliant if it complies with all of the Config rules that evaluate it. A resource is noncompliant if it does not comply with one or more of these rules.</p> <p>A rule is compliant if all of the resources that the rule evaluates comply with it. A rule is noncompliant if any of these resources do not comply.</p> <p>Config returns the <code>INSUFFICIENT_DATA</code> value when no evaluation results are available for the Amazon Web Services resource or Config rule.</p> <p>For the <code>Compliance</code> data type, Config supports only <code>COMPLIANT</code>, <code>NON_COMPLIANT</code>, and <code>INSUFFICIENT_DATA</code> values. Config does not support the <code>NOT_APPLICABLE</code> value for the <code>Compliance</code> data type.</p>', 'ComplianceTypes$member' => NULL, 'ConfigRuleComplianceFilters$ComplianceType' => '<p>The rule compliance status.</p> <p>For the <code>ConfigRuleComplianceFilters</code> data type, Config supports only <code>COMPLIANT</code> and <code>NON_COMPLIANT</code>. Config does not support the <code>NOT_APPLICABLE</code> and the <code>INSUFFICIENT_DATA</code> values.</p>', 'Evaluation$ComplianceType' => '<p>Indicates whether the Amazon Web Services resource complies with the Config rule that it was evaluated against.</p> <p>For the <code>Evaluation</code> data type, Config supports only the <code>COMPLIANT</code>, <code>NON_COMPLIANT</code>, and <code>NOT_APPLICABLE</code> values. Config does not support the <code>INSUFFICIENT_DATA</code> value for this data type.</p> <p>Similarly, Config does not accept <code>INSUFFICIENT_DATA</code> as the value for <code>ComplianceType</code> from a <code>PutEvaluations</code> request. For example, an Lambda function for a custom Config rule cannot pass an <code>INSUFFICIENT_DATA</code> value to Config.</p>', 'EvaluationResult$ComplianceType' => '<p>Indicates whether the Amazon Web Services resource complies with the Config rule that evaluated it.</p> <p>For the <code>EvaluationResult</code> data type, Config supports only the <code>COMPLIANT</code>, <code>NON_COMPLIANT</code>, and <code>NOT_APPLICABLE</code> values. Config does not support the <code>INSUFFICIENT_DATA</code> value for the <code>EvaluationResult</code> data type.</p>', 'ExternalEvaluation$ComplianceType' => '<p>The compliance of the Amazon Web Services resource. The valid values are <code>COMPLIANT, NON_COMPLIANT, </code> and <code>NOT_APPLICABLE</code>.</p>', 'GetAggregateComplianceDetailsByConfigRuleRequest$ComplianceType' => '<p>The resource compliance status.</p> <note> <p>For the <code>GetAggregateComplianceDetailsByConfigRuleRequest</code> data type, Config supports only the <code>COMPLIANT</code> and <code>NON_COMPLIANT</code>. Config does not support the <code>NOT_APPLICABLE</code> and <code>INSUFFICIENT_DATA</code> values.</p> </note>', ], ], 'ComplianceTypes' => [ 'base' => NULL, 'refs' => [ 'DescribeComplianceByConfigRuleRequest$ComplianceTypes' => '<p>Filters the results by compliance.</p> <p>The allowed values are <code>COMPLIANT</code> and <code>NON_COMPLIANT</code>.</p>', 'DescribeComplianceByResourceRequest$ComplianceTypes' => '<p>Filters the results by compliance.</p> <p>The allowed values are <code>COMPLIANT</code>, <code>NON_COMPLIANT</code>, and <code>INSUFFICIENT_DATA</code>.</p>', 'GetComplianceDetailsByConfigRuleRequest$ComplianceTypes' => '<p>Filters the results by compliance.</p> <p>The allowed values are <code>COMPLIANT</code>, <code>NON_COMPLIANT</code>, and <code>NOT_APPLICABLE</code>.</p>', 'GetComplianceDetailsByResourceRequest$ComplianceTypes' => '<p>Filters the results by compliance.</p> <p>The allowed values are <code>COMPLIANT</code>, <code>NON_COMPLIANT</code>, and <code>NOT_APPLICABLE</code>.</p>', ], ], 'ConfigExportDeliveryInfo' => [ 'base' => '<p>Provides status of the delivery of the snapshot or the configuration history to the specified Amazon S3 bucket. Also provides the status of notifications about the Amazon S3 delivery to the specified Amazon SNS topic.</p>', 'refs' => [ 'DeliveryChannelStatus$configSnapshotDeliveryInfo' => '<p>A list containing the status of the delivery of the snapshot to the specified Amazon S3 bucket.</p>', 'DeliveryChannelStatus$configHistoryDeliveryInfo' => '<p>A list that contains the status of the delivery of the configuration history to the specified Amazon S3 bucket.</p>', ], ], 'ConfigRule' => [ 'base' => '<p>An Config rule represents an Lambda function that you create for a custom rule or a predefined function for an Config managed rule. The function evaluates configuration items to assess whether your Amazon Web Services resources comply with your desired configurations. This function can run when Config detects a configuration change to an Amazon Web Services resource and at a periodic frequency that you choose (for example, every 24 hours).</p> <note> <p>You can use the Amazon Web Services CLI and Amazon Web Services SDKs if you want to create a rule that triggers evaluations for your resources when Config delivers the configuration snapshot. For more information, see <a>ConfigSnapshotDeliveryProperties</a>.</p> </note> <p>For more information about developing and using Config rules, see <a href="https://docs.aws.amazon.com/config/latest/developerguide/evaluate-config.html">Evaluating Amazon Web Services resource Configurations with Config</a> in the <i>Config Developer Guide</i>.</p>', 'refs' => [ 'ConfigRules$member' => NULL, 'PutConfigRuleRequest$ConfigRule' => '<p>The rule that you want to add to your account.</p>', ], ], 'ConfigRuleComplianceFilters' => [ 'base' => '<p>Filters the compliance results based on account ID, region, compliance type, and rule name.</p>', 'refs' => [ 'DescribeAggregateComplianceByConfigRulesRequest$Filters' => '<p>Filters the results by ConfigRuleComplianceFilters object. </p>', ], ], 'ConfigRuleComplianceSummaryFilters' => [ 'base' => '<p>Filters the results based on the account IDs and regions.</p>', 'refs' => [ 'GetAggregateConfigRuleComplianceSummaryRequest$Filters' => '<p>Filters the results based on the ConfigRuleComplianceSummaryFilters object.</p>', ], ], 'ConfigRuleComplianceSummaryGroupKey' => [ 'base' => NULL, 'refs' => [ 'GetAggregateConfigRuleComplianceSummaryRequest$GroupByKey' => '<p>Groups the result based on ACCOUNT_ID or AWS_REGION.</p>', ], ], 'ConfigRuleEvaluationStatus' => [ 'base' => '<p>Status information for your Config Managed rules and Config Custom Policy rules. The status includes information such as the last time the rule ran, the last time it failed, and the related error for the last failure.</p> <p>This action does not return status information about Config Custom Lambda rules.</p>', 'refs' => [ 'ConfigRuleEvaluationStatusList$member' => NULL, ], ], 'ConfigRuleEvaluationStatusList' => [ 'base' => NULL, 'refs' => [ 'DescribeConfigRuleEvaluationStatusResponse$ConfigRulesEvaluationStatus' => '<p>Status information about your Config managed rules.</p>', ], ], 'ConfigRuleName' => [ 'base' => NULL, 'refs' => [ 'AggregateComplianceByConfigRule$ConfigRuleName' => '<p>The name of the Config rule.</p>', 'ConfigRule$ConfigRuleName' => '<p>The name that you assign to the Config rule. The name is required if you are adding a new rule.</p>', 'ConfigRuleComplianceFilters$ConfigRuleName' => '<p>The name of the Config rule.</p>', 'ConfigRuleEvaluationStatus$ConfigRuleName' => '<p>The name of the Config rule.</p>', 'ConfigRuleNames$member' => NULL, 'ConformancePackRuleCompliance$ConfigRuleName' => '<p>Name of the Config rule.</p>', 'DeleteConfigRuleRequest$ConfigRuleName' => '<p>The name of the Config rule that you want to delete.</p>', 'DeleteRemediationConfigurationRequest$ConfigRuleName' => '<p>The name of the Config rule for which you want to delete remediation configuration.</p>', 'DeleteRemediationExceptionsRequest$ConfigRuleName' => '<p>The name of the Config rule for which you want to delete remediation exception configuration.</p>', 'DescribeRemediationExceptionsRequest$ConfigRuleName' => '<p>The name of the Config rule.</p>', 'DescribeRemediationExecutionStatusRequest$ConfigRuleName' => '<p>A list of Config rule names.</p>', 'EvaluationResultQualifier$ConfigRuleName' => '<p>The name of the Config rule that was used in the evaluation.</p>', 'GetAggregateComplianceDetailsByConfigRuleRequest$ConfigRuleName' => '<p>The name of the Config rule for which you want compliance information.</p>', 'GetCustomRulePolicyRequest$ConfigRuleName' => '<p>The name of your Config Custom Policy rule.</p>', 'PutExternalEvaluationRequest$ConfigRuleName' => '<p>The name of the Config rule.</p>', 'PutRemediationExceptionsRequest$ConfigRuleName' => '<p>The name of the Config rule for which you want to create remediation exception.</p>', 'ReevaluateConfigRuleNames$member' => NULL, 'RemediationConfiguration$ConfigRuleName' => '<p>The name of the Config rule.</p>', 'RemediationException$ConfigRuleName' => '<p>The name of the Config rule.</p>', 'StartRemediationExecutionRequest$ConfigRuleName' => '<p>The list of names of Config rules that you want to run remediation execution for.</p>', ], ], 'ConfigRuleNames' => [ 'base' => NULL, 'refs' => [ 'DescribeComplianceByConfigRuleRequest$ConfigRuleNames' => '<p>Specify one or more Config rule names to filter the results by rule.</p>', 'DescribeConfigRuleEvaluationStatusRequest$ConfigRuleNames' => '<p>The name of the Config managed rules for which you want status information. If you do not specify any names, Config returns status information for all Config managed rules that you use.</p>', 'DescribeConfigRulesRequest$ConfigRuleNames' => '<p>The names of the Config rules for which you want details. If you do not specify any names, Config returns details for all your rules.</p>', 'DescribeRemediationConfigurationsRequest$ConfigRuleNames' => '<p>A list of Config rule names of remediation configurations for which you want details. </p>', ], ], 'ConfigRuleState' => [ 'base' => NULL, 'refs' => [ 'ConfigRule$ConfigRuleState' => '<p>Indicates whether the Config rule is active or is currently being deleted by Config. It can also indicate the evaluation status for the Config rule.</p> <p>Config sets the state of the rule to <code>EVALUATING</code> temporarily after you use the <code>StartConfigRulesEvaluation</code> request to evaluate your resources against the Config rule.</p> <p>Config sets the state of the rule to <code>DELETING_RESULTS</code> temporarily after you use the <code>DeleteEvaluationResults</code> request to delete the current evaluation results for the Config rule.</p> <p>Config temporarily sets the state of a rule to <code>DELETING</code> after you use the <code>DeleteConfigRule</code> request to delete the rule. After Config deletes the rule, the rule and all of its evaluations are erased and are no longer available.</p>', ], ], 'ConfigRules' => [ 'base' => NULL, 'refs' => [ 'DescribeConfigRulesResponse$ConfigRules' => '<p>The details about your Config rules.</p>', ], ], 'ConfigSnapshotDeliveryProperties' => [ 'base' => '<p>Provides options for how often Config delivers configuration snapshots to the Amazon S3 bucket in your delivery channel.</p> <p>The frequency for a rule that triggers evaluations for your resources when Config delivers the configuration snapshot is set by one of two values, depending on which is less frequent:</p> <ul> <li> <p>The value for the <code>deliveryFrequency</code> parameter within the delivery channel configuration, which sets how often Config delivers configuration snapshots. This value also sets how often Config invokes evaluations for Config rules.</p> </li> <li> <p>The value for the <code>MaximumExecutionFrequency</code> parameter, which sets the maximum frequency with which Config invokes evaluations for the rule. For more information, see <a>ConfigRule</a>.</p> </li> </ul> <p>If the <code>deliveryFrequency</code> value is less frequent than the <code>MaximumExecutionFrequency</code> value for a rule, Config invokes the rule only as often as the <code>deliveryFrequency</code> value.</p> <ol> <li> <p>For example, you want your rule to run evaluations when Config delivers the configuration snapshot.</p> </li> <li> <p>You specify the <code>MaximumExecutionFrequency</code> value for <code>Six_Hours</code>. </p> </li> <li> <p>You then specify the delivery channel <code>deliveryFrequency</code> value for <code>TwentyFour_Hours</code>.</p> </li> <li> <p>Because the value for <code>deliveryFrequency</code> is less frequent than <code>MaximumExecutionFrequency</code>, Config invokes evaluations for the rule every 24 hours. </p> </li> </ol> <p>You should set the <code>MaximumExecutionFrequency</code> value to be at least as frequent as the <code>deliveryFrequency</code> value. You can view the <code>deliveryFrequency</code> value by using the <code>DescribeDeliveryChannnels</code> action.</p> <p>To update the <code>deliveryFrequency</code> with which Config delivers your configuration snapshots, use the <code>PutDeliveryChannel</code> action.</p>', 'refs' => [ 'DeliveryChannel$configSnapshotDeliveryProperties' => '<p>The options for how often Config delivers configuration snapshots to the Amazon S3 bucket.</p>', ], ], 'ConfigStreamDeliveryInfo' => [ 'base' => '<p>A list that contains the status of the delivery of the configuration stream notification to the Amazon SNS topic.</p>', 'refs' => [ 'DeliveryChannelStatus$configStreamDeliveryInfo' => '<p>A list containing the status of the delivery of the configuration stream notification to the specified Amazon SNS topic.</p>', ], ], 'Configuration' => [ 'base' => NULL, 'refs' => [ 'BaseConfigurationItem$configuration' => '<p>The description of the resource configuration.</p>', 'ConfigurationItem$configuration' => '<p>The description of the resource configuration.</p>', 'PutResourceConfigRequest$Configuration' => '<p>The configuration object of the resource in valid JSON format. It must match the schema registered with CloudFormation.</p> <note> <p>The configuration JSON must not exceed 64 KB.</p> </note>', ], ], 'ConfigurationAggregator' => [ 'base' => '<p>The details about the configuration aggregator, including information about source accounts, regions, and metadata of the aggregator. </p>', 'refs' => [ 'ConfigurationAggregatorList$member' => NULL, 'PutConfigurationAggregatorResponse$ConfigurationAggregator' => '<p>Returns a ConfigurationAggregator object.</p>', ], ], 'ConfigurationAggregatorArn' => [ 'base' => NULL, 'refs' => [ 'ConfigurationAggregator$ConfigurationAggregatorArn' => '<p>The Amazon Resource Name (ARN) of the aggregator.</p>', ], ], 'ConfigurationAggregatorList' => [ 'base' => NULL, 'refs' => [ 'DescribeConfigurationAggregatorsResponse$ConfigurationAggregators' => '<p>Returns a ConfigurationAggregators object.</p>', ], ], 'ConfigurationAggregatorName' => [ 'base' => NULL, 'refs' => [ 'BatchGetAggregateResourceConfigRequest$ConfigurationAggregatorName' => '<p>The name of the configuration aggregator.</p>', 'ConfigurationAggregator$ConfigurationAggregatorName' => '<p>The name of the aggregator.</p>', 'ConfigurationAggregatorNameList$member' => NULL, 'DeleteConfigurationAggregatorRequest$ConfigurationAggregatorName' => '<p>The name of the configuration aggregator.</p>', 'DescribeAggregateComplianceByConfigRulesRequest$ConfigurationAggregatorName' => '<p>The name of the configuration aggregator.</p>', 'DescribeAggregateComplianceByConformancePacksRequest$ConfigurationAggregatorName' => '<p>The name of the configuration aggregator.</p>', 'DescribeConfigurationAggregatorSourcesStatusRequest$ConfigurationAggregatorName' => '<p>The name of the configuration aggregator.</p>', 'GetAggregateComplianceDetailsByConfigRuleRequest$ConfigurationAggregatorName' => '<p>The name of the configuration aggregator.</p>', 'GetAggregateConfigRuleComplianceSummaryRequest$ConfigurationAggregatorName' => '<p>The name of the configuration aggregator.</p>', 'GetAggregateConformancePackComplianceSummaryRequest$ConfigurationAggregatorName' => '<p>The name of the configuration aggregator.</p>', 'GetAggregateDiscoveredResourceCountsRequest$ConfigurationAggregatorName' => '<p>The name of the configuration aggregator.</p>', 'GetAggregateResourceConfigRequest$ConfigurationAggregatorName' => '<p>The name of the configuration aggregator.</p>', 'ListAggregateDiscoveredResourcesRequest$ConfigurationAggregatorName' => '<p>The name of the configuration aggregator. </p>', 'PutConfigurationAggregatorRequest$ConfigurationAggregatorName' => '<p>The name of the configuration aggregator.</p>', 'SelectAggregateResourceConfigRequest$ConfigurationAggregatorName' => '<p>The name of the configuration aggregator.</p>', ], ], 'ConfigurationAggregatorNameList' => [ 'base' => NULL, 'refs' => [ 'DescribeConfigurationAggregatorsRequest$ConfigurationAggregatorNames' => '<p>The name of the configuration aggregators.</p>', ], ], 'ConfigurationItem' => [ 'base' => '<p>A list that contains detailed configurations of a specified resource.</p>', 'refs' => [ 'ConfigurationItemList$member' => NULL, 'GetAggregateResourceConfigResponse$ConfigurationItem' => '<p>Returns a <code>ConfigurationItem</code> object.</p>', ], ], 'ConfigurationItemCaptureTime' => [ 'base' => NULL, 'refs' => [ 'BaseConfigurationItem$configurationItemCaptureTime' => '<p>The time when the configuration recording was initiated.</p>', 'ConfigurationItem$configurationItemCaptureTime' => '<p>The time when the configuration recording was initiated.</p>', ], ], 'ConfigurationItemList' => [ 'base' => NULL, 'refs' => [ 'GetResourceConfigHistoryResponse$configurationItems' => '<p>A list that contains the configuration history of one or more resources.</p>', ], ], 'ConfigurationItemMD5Hash' => [ 'base' => NULL, 'refs' => [ 'ConfigurationItem$configurationItemMD5Hash' => '<p>Unique MD5 hash that represents the configuration item\'s state.</p> <p>You can use MD5 hash to compare the states of two or more configuration items that are associated with the same resource.</p>', ], ], 'ConfigurationItemStatus' => [ 'base' => NULL, 'refs' => [ 'BaseConfigurationItem$configurationItemStatus' => '<p>The configuration item status. The valid values are:</p> <ul> <li> <p>OK – The resource configuration has been updated</p> </li> <li> <p>ResourceDiscovered – The resource was newly discovered</p> </li> <li> <p>ResourceNotRecorded – The resource was discovered but its configuration was not recorded since the recorder excludes the recording of resources of this type</p> </li> <li> <p>ResourceDeleted – The resource was deleted</p> </li> <li> <p>ResourceDeletedNotRecorded – The resource was deleted but its configuration was not recorded since the recorder excludes the recording of resources of this type</p> </li> </ul> <note> <p>The CIs do not incur any cost.</p> </note>', 'ConfigurationItem$configurationItemStatus' => '<p>The configuration item status. The valid values are:</p> <ul> <li> <p>OK – The resource configuration has been updated</p> </li> <li> <p>ResourceDiscovered – The resource was newly discovered</p> </li> <li> <p>ResourceNotRecorded – The resource was discovered but its configuration was not recorded since the recorder excludes the recording of resources of this type</p> </li> <li> <p>ResourceDeleted – The resource was deleted</p> </li> <li> <p>ResourceDeletedNotRecorded – The resource was deleted but its configuration was not recorded since the recorder excludes the recording of resources of this type</p> </li> </ul> <note> <p>The CIs do not incur any cost.</p> </note>', ], ], 'ConfigurationRecorder' => [ 'base' => '<p>An object that represents the recording of configuration changes of an Amazon Web Services resource.</p>', 'refs' => [ 'ConfigurationRecorderList$member' => NULL, 'PutConfigurationRecorderRequest$ConfigurationRecorder' => '<p>The configuration recorder object that records each configuration change made to the resources.</p>', ], ], 'ConfigurationRecorderList' => [ 'base' => NULL, 'refs' => [ 'DescribeConfigurationRecordersResponse$ConfigurationRecorders' => '<p>A list that contains the descriptions of the specified configuration recorders.</p>', ], ], 'ConfigurationRecorderNameList' => [ 'base' => NULL, 'refs' => [ 'DescribeConfigurationRecorderStatusRequest$ConfigurationRecorderNames' => '<p>The name(s) of the configuration recorder. If the name is not specified, the action returns the current status of all the configuration recorders associated with the account.</p>', 'DescribeConfigurationRecordersRequest$ConfigurationRecorderNames' => '<p>A list of configuration recorder names.</p>', ], ], 'ConfigurationRecorderStatus' => [ 'base' => '<p>The current status of the configuration recorder.</p>', 'refs' => [ 'ConfigurationRecorderStatusList$member' => NULL, ], ], 'ConfigurationRecorderStatusList' => [ 'base' => NULL, 'refs' => [ 'DescribeConfigurationRecorderStatusResponse$ConfigurationRecordersStatus' => '<p>A list that contains status of the specified recorders.</p>', ], ], 'ConfigurationStateId' => [ 'base' => NULL, 'refs' => [ 'BaseConfigurationItem$configurationStateId' => '<p>An identifier that indicates the ordering of the configuration items of a resource.</p>', 'ConfigurationItem$configurationStateId' => '<p>An identifier that indicates the ordering of the configuration items of a resource.</p>', ], ], 'ConformancePackArn' => [ 'base' => NULL, 'refs' => [ 'ConformancePackDetail$ConformancePackArn' => '<p>Amazon Resource Name (ARN) of the conformance pack.</p>', 'ConformancePackStatusDetail$ConformancePackArn' => '<p>Amazon Resource Name (ARN) of comformance pack.</p>', 'PutConformancePackResponse$ConformancePackArn' => '<p>ARN of the conformance pack.</p>', ], ], 'ConformancePackComplianceFilters' => [ 'base' => '<p>Filters the conformance pack by compliance types and Config rule names.</p>', 'refs' => [ 'DescribeConformancePackComplianceRequest$Filters' => '<p>A <code>ConformancePackComplianceFilters</code> object.</p>', ], ], 'ConformancePackComplianceResourceIds' => [ 'base' => NULL, 'refs' => [ 'ConformancePackEvaluationFilters$ResourceIds' => '<p>Filters the results by resource IDs.</p> <note> <p>This is valid only when you provide resource type. If there is no resource type, you will see an error.</p> </note>', ], ], 'ConformancePackComplianceSummary' => [ 'base' => '<p>Summary includes the name and status of the conformance pack.</p>', 'refs' => [ 'ConformancePackComplianceSummaryList$member' => NULL, ], ], 'ConformancePackComplianceSummaryList' => [ 'base' => NULL, 'refs' => [ 'GetConformancePackComplianceSummaryResponse$ConformancePackComplianceSummaryList' => '<p>A list of <code>ConformancePackComplianceSummary</code> objects. </p>', ], ], 'ConformancePackComplianceType' => [ 'base' => NULL, 'refs' => [ 'AggregateConformancePackCompliance$ComplianceType' => '<p>The compliance status of the conformance pack.</p>', 'AggregateConformancePackComplianceFilters$ComplianceType' => '<p>The compliance status of the conformance pack.</p>', 'ConformancePackComplianceFilters$ComplianceType' => '<p>Filters the results by compliance.</p> <p>The allowed values are <code>COMPLIANT</code> and <code>NON_COMPLIANT</code>. <code>INSUFFICIENT_DATA</code> is not supported.</p>', 'ConformancePackComplianceSummary$ConformancePackComplianceStatus' => '<p>The status of the conformance pack. The allowed values are <code>COMPLIANT</code>, <code>NON_COMPLIANT</code> and <code>INSUFFICIENT_DATA</code>.</p>', 'ConformancePackEvaluationFilters$ComplianceType' => '<p>Filters the results by compliance.</p> <p>The allowed values are <code>COMPLIANT</code> and <code>NON_COMPLIANT</code>. <code>INSUFFICIENT_DATA</code> is not supported.</p>', 'ConformancePackEvaluationResult$ComplianceType' => '<p>The compliance type. The allowed values are <code>COMPLIANT</code> and <code>NON_COMPLIANT</code>. <code>INSUFFICIENT_DATA</code> is not supported.</p>', 'ConformancePackRuleCompliance$ComplianceType' => '<p>Compliance of the Config rule.</p> <p>The allowed values are <code>COMPLIANT</code>, <code>NON_COMPLIANT</code>, and <code>INSUFFICIENT_DATA</code>.</p>', ], ], 'ConformancePackConfigRuleNames' => [ 'base' => NULL, 'refs' => [ 'ConformancePackComplianceFilters$ConfigRuleNames' => '<p>Filters the results by Config rule names.</p>', 'ConformancePackEvaluationFilters$ConfigRuleNames' => '<p>Filters the results by Config rule names.</p>', ], ], 'ConformancePackDetail' => [ 'base' => '<p>Returns details of a conformance pack. A conformance pack is a collection of Config rules and remediation actions that can be easily deployed in an account and a region.</p>', 'refs' => [ 'ConformancePackDetailList$member' => NULL, ], ], 'ConformancePackDetailList' => [ 'base' => NULL, 'refs' => [ 'DescribeConformancePacksResponse$ConformancePackDetails' => '<p>Returns a list of <code>ConformancePackDetail</code> objects.</p>', ], ], 'ConformancePackEvaluationFilters' => [ 'base' => '<p>Filters a conformance pack by Config rule names, compliance types, Amazon Web Services resource types, and resource IDs.</p>', 'refs' => [ 'GetConformancePackComplianceDetailsRequest$Filters' => '<p>A <code>ConformancePackEvaluationFilters</code> object.</p>', ], ], 'ConformancePackEvaluationResult' => [ 'base' => '<p>The details of a conformance pack evaluation. Provides Config rule and Amazon Web Services resource type that was evaluated, the compliance of the conformance pack, related time stamps, and supplementary information. </p>', 'refs' => [ 'ConformancePackRuleEvaluationResultsList$member' => NULL, ], ], 'ConformancePackId' => [ 'base' => NULL, 'refs' => [ 'ConformancePackDetail$ConformancePackId' => '<p>ID of the conformance pack.</p>', 'ConformancePackStatusDetail$ConformancePackId' => '<p>ID of the conformance pack.</p>', ], ], 'ConformancePackInputParameter' => [ 'base' => '<p>Input parameters in the form of key-value pairs for the conformance pack, both of which you define. Keys can have a maximum character length of 255 characters, and values can have a maximum length of 4096 characters.</p>', 'refs' => [ 'ConformancePackInputParameters$member' => NULL, ], ], 'ConformancePackInputParameters' => [ 'base' => NULL, 'refs' => [ 'ConformancePackDetail$ConformancePackInputParameters' => '<p>A list of <code>ConformancePackInputParameter</code> objects.</p>', 'OrganizationConformancePack$ConformancePackInputParameters' => '<p>A list of <code>ConformancePackInputParameter</code> objects.</p>', 'PutConformancePackRequest$ConformancePackInputParameters' => '<p>A list of <code>ConformancePackInputParameter</code> objects.</p>', 'PutOrganizationConformancePackRequest$ConformancePackInputParameters' => '<p>A list of <code>ConformancePackInputParameter</code> objects.</p>', ], ], 'ConformancePackName' => [ 'base' => NULL, 'refs' => [ 'AggregateComplianceByConformancePack$ConformancePackName' => '<p>The name of the conformance pack.</p>', 'AggregateConformancePackComplianceFilters$ConformancePackName' => '<p>The name of the conformance pack.</p>', 'ConformancePackComplianceSummary$ConformancePackName' => '<p>The name of the conformance pack name.</p>', 'ConformancePackDetail$ConformancePackName' => '<p>Name of the conformance pack.</p>', 'ConformancePackNamesList$member' => NULL, 'ConformancePackNamesToSummarizeList$member' => NULL, 'ConformancePackStatusDetail$ConformancePackName' => '<p>Name of the conformance pack.</p>', 'DeleteConformancePackRequest$ConformancePackName' => '<p>Name of the conformance pack you want to delete.</p>', 'DescribeConformancePackComplianceRequest$ConformancePackName' => '<p>Name of the conformance pack.</p>', 'DescribeConformancePackComplianceResponse$ConformancePackName' => '<p>Name of the conformance pack.</p>', 'GetConformancePackComplianceDetailsRequest$ConformancePackName' => '<p>Name of the conformance pack.</p>', 'GetConformancePackComplianceDetailsResponse$ConformancePackName' => '<p>Name of the conformance pack.</p>', 'PutConformancePackRequest$ConformancePackName' => '<p>Name of the conformance pack you want to create.</p>', ], ], 'ConformancePackNamesList' => [ 'base' => NULL, 'refs' => [ 'DescribeConformancePackStatusRequest$ConformancePackNames' => '<p>Comma-separated list of conformance pack names.</p>', 'DescribeConformancePacksRequest$ConformancePackNames' => '<p>Comma-separated list of conformance pack names for which you want details. If you do not specify any names, Config returns details for all your conformance packs. </p>', ], ], 'ConformancePackNamesToSummarizeList' => [ 'base' => NULL, 'refs' => [ 'GetConformancePackComplianceSummaryRequest$ConformancePackNames' => '<p>Names of conformance packs.</p>', ], ], 'ConformancePackRuleCompliance' => [ 'base' => '<p>Compliance information of one or more Config rules within a conformance pack. You can filter using Config rule names and compliance types.</p>', 'refs' => [ 'ConformancePackRuleComplianceList$member' => NULL, ], ], 'ConformancePackRuleComplianceList' => [ 'base' => NULL, 'refs' => [ 'DescribeConformancePackComplianceResponse$ConformancePackRuleComplianceList' => '<p>Returns a list of <code>ConformancePackRuleCompliance</code> objects.</p>', ], ], 'ConformancePackRuleEvaluationResultsList' => [ 'base' => NULL, 'refs' => [ 'GetConformancePackComplianceDetailsResponse$ConformancePackRuleEvaluationResults' => '<p>Returns a list of <code>ConformancePackEvaluationResult</code> objects.</p>', ], ], 'ConformancePackState' => [ 'base' => NULL, 'refs' => [ 'ConformancePackStatusDetail$ConformancePackState' => '<p>Indicates deployment status of conformance pack.</p> <p>Config sets the state of the conformance pack to:</p> <ul> <li> <p>CREATE_IN_PROGRESS when a conformance pack creation is in progress for an account.</p> </li> <li> <p>CREATE_COMPLETE when a conformance pack has been successfully created in your account.</p> </li> <li> <p>CREATE_FAILED when a conformance pack creation failed in your account.</p> </li> <li> <p>DELETE_IN_PROGRESS when a conformance pack deletion is in progress. </p> </li> <li> <p>DELETE_FAILED when a conformance pack deletion failed in your account.</p> </li> </ul>', ], ], 'ConformancePackStatusDetail' => [ 'base' => '<p>Status details of a conformance pack.</p>', 'refs' => [ 'ConformancePackStatusDetailsList$member' => NULL, ], ], 'ConformancePackStatusDetailsList' => [ 'base' => NULL, 'refs' => [ 'DescribeConformancePackStatusResponse$ConformancePackStatusDetails' => '<p>A list of <code>ConformancePackStatusDetail</code> objects.</p>', ], ], 'ConformancePackStatusReason' => [ 'base' => NULL, 'refs' => [ 'ConformancePackStatusDetail$ConformancePackStatusReason' => '<p>The reason of conformance pack creation failure.</p>', ], ], 'ConformancePackTemplateValidationException' => [ 'base' => '<p>You have specified a template that is not valid or supported.</p>', 'refs' => [], ], 'ControlsList' => [ 'base' => NULL, 'refs' => [ 'ConformancePackRuleCompliance$Controls' => '<p>Controls for the conformance pack. A control is a process to prevent or detect problems while meeting objectives. A control can align with a specific compliance regime or map to internal controls defined by an organization.</p>', ], ], 'CosmosPageLimit' => [ 'base' => NULL, 'refs' => [ 'DescribeOrganizationConfigRuleStatusesRequest$Limit' => '<p>The maximum number of <code>OrganizationConfigRuleStatuses</code> returned on each page. If you do no specify a number, Config uses the default. The default is 100.</p>', 'DescribeOrganizationConfigRulesRequest$Limit' => '<p>The maximum number of organization Config rules returned on each page. If you do no specify a number, Config uses the default. The default is 100.</p>', 'DescribeOrganizationConformancePackStatusesRequest$Limit' => '<p>The maximum number of OrganizationConformancePackStatuses returned on each page. If you do no specify a number, Config uses the default. The default is 100. </p>', 'DescribeOrganizationConformancePacksRequest$Limit' => '<p>The maximum number of organization config packs returned on each page. If you do no specify a number, Config uses the default. The default is 100.</p>', 'GetOrganizationConfigRuleDetailedStatusRequest$Limit' => '<p>The maximum number of <code>OrganizationConfigRuleDetailedStatus</code> returned on each page. If you do not specify a number, Config uses the default. The default is 100.</p>', 'GetOrganizationConformancePackDetailedStatusRequest$Limit' => '<p>The maximum number of <code>OrganizationConformancePackDetailedStatuses</code> returned on each page. If you do not specify a number, Config uses the default. The default is 100. </p>', ], ], 'CustomPolicyDetails' => [ 'base' => '<p>Provides the runtime system, policy definition, and whether debug logging enabled. You can specify the following CustomPolicyDetails parameter values only for Config Custom Policy rules.</p>', 'refs' => [ 'Source$CustomPolicyDetails' => '<p>Provides the runtime system, policy definition, and whether debug logging is enabled. Required when owner is set to <code>CUSTOM_POLICY</code>.</p>', ], ], 'Date' => [ 'base' => NULL, 'refs' => [ 'AggregateEvaluationResult$ResultRecordedTime' => '<p>The time when Config recorded the aggregate evaluation result.</p>', 'AggregateEvaluationResult$ConfigRuleInvokedTime' => '<p>The time when the Config rule evaluated the Amazon Web Services resource.</p>', 'AggregatedSourceStatus$LastUpdateTime' => '<p>The time of the last update.</p>', 'AggregationAuthorization$CreationTime' => '<p>The time stamp when the aggregation authorization was created.</p>', 'ComplianceSummary$ComplianceSummaryTimestamp' => '<p>The time that Config created the compliance summary.</p>', 'ConfigExportDeliveryInfo$lastAttemptTime' => '<p>The time of the last attempted delivery.</p>', 'ConfigExportDeliveryInfo$lastSuccessfulTime' => '<p>The time of the last successful delivery.</p>', 'ConfigExportDeliveryInfo$nextDeliveryTime' => '<p>The time that the next delivery occurs.</p>', 'ConfigRuleEvaluationStatus$LastSuccessfulInvocationTime' => '<p>The time that Config last successfully invoked the Config rule to evaluate your Amazon Web Services resources.</p>', 'ConfigRuleEvaluationStatus$LastFailedInvocationTime' => '<p>The time that Config last failed to invoke the Config rule to evaluate your Amazon Web Services resources.</p>', 'ConfigRuleEvaluationStatus$LastSuccessfulEvaluationTime' => '<p>The time that Config last successfully evaluated your Amazon Web Services resources against the rule.</p>', 'ConfigRuleEvaluationStatus$LastFailedEvaluationTime' => '<p>The time that Config last failed to evaluate your Amazon Web Services resources against the rule.</p>', 'ConfigRuleEvaluationStatus$FirstActivatedTime' => '<p>The time that you first activated the Config rule.</p>', 'ConfigRuleEvaluationStatus$LastDeactivatedTime' => '<p>The time that you last turned off the Config rule.</p>', 'ConfigRuleEvaluationStatus$LastDebugLogDeliveryTime' => '<p>The time Config last attempted to deliver a debug log for your Config Custom Policy rules.</p>', 'ConfigStreamDeliveryInfo$lastStatusChangeTime' => '<p>The time from the last status change.</p>', 'ConfigurationAggregator$CreationTime' => '<p>The time stamp when the configuration aggregator was created.</p>', 'ConfigurationAggregator$LastUpdatedTime' => '<p>The time of the last update.</p>', 'ConfigurationRecorderStatus$lastStartTime' => '<p>The time the recorder was last started.</p>', 'ConfigurationRecorderStatus$lastStopTime' => '<p>The time the recorder was last stopped.</p>', 'ConfigurationRecorderStatus$lastStatusChangeTime' => '<p>The time when the status was last changed.</p>', 'ConformancePackDetail$LastUpdateRequestedTime' => '<p>Last time when conformation pack update was requested. </p>', 'ConformancePackEvaluationResult$ConfigRuleInvokedTime' => '<p>The time when Config rule evaluated Amazon Web Services resource.</p>', 'ConformancePackEvaluationResult$ResultRecordedTime' => '<p>The time when Config recorded the evaluation result. </p>', 'ConformancePackStatusDetail$LastUpdateRequestedTime' => '<p>Last time when conformation pack creation and update was requested.</p>', 'ConformancePackStatusDetail$LastUpdateCompletedTime' => '<p>Last time when conformation pack creation and update was successful.</p>', 'EvaluationResult$ResultRecordedTime' => '<p>The time when Config recorded the evaluation result.</p>', 'EvaluationResult$ConfigRuleInvokedTime' => '<p>The time when the Config rule evaluated the Amazon Web Services resource.</p>', 'EvaluationResultIdentifier$OrderingTimestamp' => '<p>The time of the event that triggered the evaluation of your Amazon Web Services resources. The time can indicate when Config delivered a configuration item change notification, or it can indicate when Config delivered the configuration snapshot, depending on which event triggered the evaluation.</p>', 'MemberAccountStatus$LastUpdateTime' => '<p>The timestamp of the last status update.</p>', 'OrganizationConfigRule$LastUpdateTime' => '<p>The timestamp of the last update.</p>', 'OrganizationConfigRuleStatus$LastUpdateTime' => '<p>The timestamp of the last update.</p>', 'OrganizationConformancePack$LastUpdateTime' => '<p>Last time when organization conformation pack was updated.</p>', 'OrganizationConformancePackDetailedStatus$LastUpdateTime' => '<p>The timestamp of the last status update.</p>', 'OrganizationConformancePackStatus$LastUpdateTime' => '<p>The timestamp of the last update.</p>', 'PutRemediationExceptionsRequest$ExpirationTime' => '<p>The exception is automatically deleted after the expiration date.</p>', 'RemediationException$ExpirationTime' => '<p>The time when the remediation exception will be deleted.</p>', 'RemediationExecutionStatus$InvocationTime' => '<p>Start time when the remediation was executed.</p>', 'RemediationExecutionStatus$LastUpdatedTime' => '<p>The time when the remediation execution was last updated.</p>', 'RemediationExecutionStep$StartTime' => '<p>The time when the step started.</p>', 'RemediationExecutionStep$StopTime' => '<p>The time when the step stopped.</p>', ], ], 'DebugLogDeliveryAccounts' => [ 'base' => NULL, 'refs' => [ 'OrganizationCustomPolicyRuleMetadata$DebugLogDeliveryAccounts' => '<p>A list of accounts that you can enable debug logging for your organization Config Custom Policy rule. List is null when debug logging is enabled for all accounts.</p>', 'OrganizationCustomPolicyRuleMetadataNoPolicy$DebugLogDeliveryAccounts' => '<p>A list of accounts that you can enable debug logging for your organization Config Custom Policy rule. List is null when debug logging is enabled for all accounts.</p>', ], ], 'DeleteAggregationAuthorizationRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteConfigRuleRequest' => [ 'base' => '<p/>', 'refs' => [], ], 'DeleteConfigurationAggregatorRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteConfigurationRecorderRequest' => [ 'base' => '<p>The request object for the <code>DeleteConfigurationRecorder</code> action.</p>', 'refs' => [], ], 'DeleteConformancePackRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteDeliveryChannelRequest' => [ 'base' => '<p>The input for the <a>DeleteDeliveryChannel</a> action. The action accepts the following data, in JSON format. </p>', 'refs' => [], ], 'DeleteEvaluationResultsRequest' => [ 'base' => '<p/>', 'refs' => [], ], 'DeleteEvaluationResultsResponse' => [ 'base' => '<p>The output when you delete the evaluation results for the specified Config rule.</p>', 'refs' => [], ], 'DeleteOrganizationConfigRuleRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteOrganizationConformancePackRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeletePendingAggregationRequestRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteRemediationConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteRemediationConfigurationResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteRemediationExceptionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteRemediationExceptionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteResourceConfigRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteRetentionConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteStoredQueryRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteStoredQueryResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeliverConfigSnapshotRequest' => [ 'base' => '<p>The input for the <a>DeliverConfigSnapshot</a> action.</p>', 'refs' => [], ], 'DeliverConfigSnapshotResponse' => [ 'base' => '<p>The output for the <a>DeliverConfigSnapshot</a> action, in JSON format.</p>', 'refs' => [], ], 'DeliveryChannel' => [ 'base' => '<p>The channel through which Config delivers notifications and updated configuration states.</p>', 'refs' => [ 'DeliveryChannelList$member' => NULL, 'PutDeliveryChannelRequest$DeliveryChannel' => '<p>The configuration delivery channel object that delivers the configuration information to an Amazon S3 bucket and to an Amazon SNS topic.</p>', ], ], 'DeliveryChannelList' => [ 'base' => NULL, 'refs' => [ 'DescribeDeliveryChannelsResponse$DeliveryChannels' => '<p>A list that contains the descriptions of the specified delivery channel.</p>', ], ], 'DeliveryChannelNameList' => [ 'base' => NULL, 'refs' => [ 'DescribeDeliveryChannelStatusRequest$DeliveryChannelNames' => '<p>A list of delivery channel names.</p>', 'DescribeDeliveryChannelsRequest$DeliveryChannelNames' => '<p>A list of delivery channel names.</p>', ], ], 'DeliveryChannelStatus' => [ 'base' => '<p>The status of a specified delivery channel.</p> <p>Valid values: <code>Success</code> | <code>Failure</code> </p>', 'refs' => [ 'DeliveryChannelStatusList$member' => NULL, ], ], 'DeliveryChannelStatusList' => [ 'base' => NULL, 'refs' => [ 'DescribeDeliveryChannelStatusResponse$DeliveryChannelsStatus' => '<p>A list that contains the status of a specified delivery channel.</p>', ], ], 'DeliveryS3Bucket' => [ 'base' => NULL, 'refs' => [ 'ConformancePackDetail$DeliveryS3Bucket' => '<p>The name of the Amazon S3 bucket where Config stores conformance pack templates. </p> <note> <p>This field is optional.</p> </note>', 'OrganizationConformancePack$DeliveryS3Bucket' => '<p>The name of the Amazon S3 bucket where Config stores conformance pack templates. </p> <note> <p>This field is optional.</p> </note>', 'PutConformancePackRequest$DeliveryS3Bucket' => '<p>The name of the Amazon S3 bucket where Config stores conformance pack templates.</p> <note> <p>This field is optional.</p> </note>', 'PutOrganizationConformancePackRequest$DeliveryS3Bucket' => '<p>The name of the Amazon S3 bucket where Config stores conformance pack templates.</p> <note> <p>This field is optional. If used, it must be prefixed with <code>awsconfigconforms</code>.</p> </note>', ], ], 'DeliveryS3KeyPrefix' => [ 'base' => NULL, 'refs' => [ 'ConformancePackDetail$DeliveryS3KeyPrefix' => '<p>The prefix for the Amazon S3 bucket.</p> <note> <p>This field is optional.</p> </note>', 'OrganizationConformancePack$DeliveryS3KeyPrefix' => '<p>Any folder structure you want to add to an Amazon S3 bucket.</p> <note> <p>This field is optional.</p> </note>', 'PutConformancePackRequest$DeliveryS3KeyPrefix' => '<p>The prefix for the Amazon S3 bucket. </p> <note> <p>This field is optional.</p> </note>', 'PutOrganizationConformancePackRequest$DeliveryS3KeyPrefix' => '<p>The prefix for the Amazon S3 bucket.</p> <note> <p>This field is optional.</p> </note>', ], ], 'DeliveryStatus' => [ 'base' => NULL, 'refs' => [ 'ConfigExportDeliveryInfo$lastStatus' => '<p>Status of the last attempted delivery.</p>', 'ConfigStreamDeliveryInfo$lastStatus' => '<p>Status of the last attempted delivery.</p> <p> <b>Note</b> Providing an SNS topic on a <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_DeliveryChannel.html">DeliveryChannel</a> for Config is optional. If the SNS delivery is turned off, the last status will be <b>Not_Applicable</b>.</p>', ], ], 'DescribeAggregateComplianceByConfigRulesRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAggregateComplianceByConfigRulesResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAggregateComplianceByConformancePacksRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAggregateComplianceByConformancePacksResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAggregationAuthorizationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAggregationAuthorizationsResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeComplianceByConfigRuleRequest' => [ 'base' => '<p/>', 'refs' => [], ], 'DescribeComplianceByConfigRuleResponse' => [ 'base' => '<p/>', 'refs' => [], ], 'DescribeComplianceByResourceRequest' => [ 'base' => '<p/>', 'refs' => [], ], 'DescribeComplianceByResourceResponse' => [ 'base' => '<p/>', 'refs' => [], ], 'DescribeConfigRuleEvaluationStatusRequest' => [ 'base' => '<p/>', 'refs' => [], ], 'DescribeConfigRuleEvaluationStatusResponse' => [ 'base' => '<p/>', 'refs' => [], ], 'DescribeConfigRulesRequest' => [ 'base' => '<p/>', 'refs' => [], ], 'DescribeConfigRulesResponse' => [ 'base' => '<p/>', 'refs' => [], ], 'DescribeConfigurationAggregatorSourcesStatusRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeConfigurationAggregatorSourcesStatusResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeConfigurationAggregatorsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeConfigurationAggregatorsResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeConfigurationRecorderStatusRequest' => [ 'base' => '<p>The input for the <a>DescribeConfigurationRecorderStatus</a> action.</p>', 'refs' => [], ], 'DescribeConfigurationRecorderStatusResponse' => [ 'base' => '<p>The output for the <a>DescribeConfigurationRecorderStatus</a> action, in JSON format.</p>', 'refs' => [], ], 'DescribeConfigurationRecordersRequest' => [ 'base' => '<p>The input for the <a>DescribeConfigurationRecorders</a> action.</p>', 'refs' => [], ], 'DescribeConfigurationRecordersResponse' => [ 'base' => '<p>The output for the <a>DescribeConfigurationRecorders</a> action.</p>', 'refs' => [], ], 'DescribeConformancePackComplianceLimit' => [ 'base' => NULL, 'refs' => [ 'DescribeConformancePackComplianceRequest$Limit' => '<p>The maximum number of Config rules within a conformance pack are returned on each page.</p>', ], ], 'DescribeConformancePackComplianceRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeConformancePackComplianceResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeConformancePackStatusRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeConformancePackStatusResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeConformancePacksRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeConformancePacksResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeDeliveryChannelStatusRequest' => [ 'base' => '<p>The input for the <a>DeliveryChannelStatus</a> action.</p>', 'refs' => [], ], 'DescribeDeliveryChannelStatusResponse' => [ 'base' => '<p>The output for the <a>DescribeDeliveryChannelStatus</a> action.</p>', 'refs' => [], ], 'DescribeDeliveryChannelsRequest' => [ 'base' => '<p>The input for the <a>DescribeDeliveryChannels</a> action.</p>', 'refs' => [], ], 'DescribeDeliveryChannelsResponse' => [ 'base' => '<p>The output for the <a>DescribeDeliveryChannels</a> action.</p>', 'refs' => [], ], 'DescribeOrganizationConfigRuleStatusesRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeOrganizationConfigRuleStatusesResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeOrganizationConfigRulesRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeOrganizationConfigRulesResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeOrganizationConformancePackStatusesRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeOrganizationConformancePackStatusesResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeOrganizationConformancePacksRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeOrganizationConformancePacksResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribePendingAggregationRequestsLimit' => [ 'base' => NULL, 'refs' => [ 'DescribePendingAggregationRequestsRequest$Limit' => '<p>The maximum number of evaluation results returned on each page. The default is maximum. If you specify 0, Config uses the default.</p>', ], ], 'DescribePendingAggregationRequestsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribePendingAggregationRequestsResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeRemediationConfigurationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeRemediationConfigurationsResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeRemediationExceptionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeRemediationExceptionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeRemediationExecutionStatusRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeRemediationExecutionStatusResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeRetentionConfigurationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeRetentionConfigurationsResponse' => [ 'base' => NULL, 'refs' => [], ], 'DiscoveredResourceIdentifierList' => [ 'base' => NULL, 'refs' => [ 'ListAggregateDiscoveredResourcesResponse$ResourceIdentifiers' => '<p>Returns a list of <code>ResourceIdentifiers</code> objects.</p>', ], ], 'EarlierTime' => [ 'base' => NULL, 'refs' => [ 'GetResourceConfigHistoryRequest$earlierTime' => '<p>The time stamp that indicates an earlier time. If not specified, the action returns paginated results that contain configuration items that start when the first configuration item was recorded.</p>', ], ], 'EmptiableStringWithCharLimit256' => [ 'base' => NULL, 'refs' => [ 'ConfigRule$Description' => '<p>The description that you provide for the Config rule.</p>', ], ], 'ErrorMessage' => [ 'base' => NULL, 'refs' => [ 'ResourceConcurrentModificationException$message' => NULL, ], ], 'Evaluation' => [ 'base' => '<p>Identifies an Amazon Web Services resource and indicates whether it complies with the Config rule that it was evaluated against.</p>', 'refs' => [ 'Evaluations$member' => NULL, ], ], 'EvaluationResult' => [ 'base' => '<p>The details of an Config evaluation. Provides the Amazon Web Services resource that was evaluated, the compliance of the resource, related time stamps, and supplementary information.</p>', 'refs' => [ 'EvaluationResults$member' => NULL, ], ], 'EvaluationResultIdentifier' => [ 'base' => '<p>Uniquely identifies an evaluation result.</p>', 'refs' => [ 'AggregateEvaluationResult$EvaluationResultIdentifier' => '<p>Uniquely identifies the evaluation result.</p>', 'ConformancePackEvaluationResult$EvaluationResultIdentifier' => NULL, 'EvaluationResult$EvaluationResultIdentifier' => '<p>Uniquely identifies the evaluation result.</p>', ], ], 'EvaluationResultQualifier' => [ 'base' => '<p>Identifies an Config rule that evaluated an Amazon Web Services resource, and provides the type and ID of the resource that the rule evaluated.</p>', 'refs' => [ 'EvaluationResultIdentifier$EvaluationResultQualifier' => '<p>Identifies an Config rule used to evaluate an Amazon Web Services resource, and provides the type and ID of the evaluated resource.</p>', ], ], 'EvaluationResults' => [ 'base' => NULL, 'refs' => [ 'GetComplianceDetailsByConfigRuleResponse$EvaluationResults' => '<p>Indicates whether the Amazon Web Services resource complies with the specified Config rule.</p>', 'GetComplianceDetailsByResourceResponse$EvaluationResults' => '<p>Indicates whether the specified Amazon Web Services resource complies each Config rule.</p>', ], ], 'Evaluations' => [ 'base' => NULL, 'refs' => [ 'PutEvaluationsRequest$Evaluations' => '<p>The assessments that the Lambda function performs. Each evaluation identifies an Amazon Web Services resource and indicates whether it complies with the Config rule that invokes the Lambda function.</p>', 'PutEvaluationsResponse$FailedEvaluations' => '<p>Requests that failed because of a client or server error.</p>', ], ], 'EventSource' => [ 'base' => NULL, 'refs' => [ 'SourceDetail$EventSource' => '<p>The source of the event, such as an Amazon Web Services service, that triggers Config to evaluate your Amazon Web Services resources.</p>', ], ], 'ExcludedAccounts' => [ 'base' => NULL, 'refs' => [ 'OrganizationConfigRule$ExcludedAccounts' => '<p>A comma-separated list of accounts excluded from organization Config rule.</p>', 'OrganizationConformancePack$ExcludedAccounts' => '<p>A comma-separated list of accounts excluded from organization conformance pack.</p>', 'PutOrganizationConfigRuleRequest$ExcludedAccounts' => '<p>A comma-separated list of accounts that you want to exclude from an organization Config rule.</p>', 'PutOrganizationConformancePackRequest$ExcludedAccounts' => '<p>A list of Amazon Web Services accounts to be excluded from an organization conformance pack while deploying a conformance pack.</p>', ], ], 'ExecutionControls' => [ 'base' => '<p>The controls that Config uses for executing remediations.</p>', 'refs' => [ 'RemediationConfiguration$ExecutionControls' => '<p>An ExecutionControls object.</p>', ], ], 'Expression' => [ 'base' => NULL, 'refs' => [ 'SelectAggregateResourceConfigRequest$Expression' => '<p>The SQL query SELECT command. </p>', 'SelectResourceConfigRequest$Expression' => '<p>The SQL query <code>SELECT</code> command.</p>', ], ], 'ExternalEvaluation' => [ 'base' => '<p>Identifies an Amazon Web Services resource and indicates whether it complies with the Config rule that it was evaluated against.</p>', 'refs' => [ 'PutExternalEvaluationRequest$ExternalEvaluation' => '<p>An <code>ExternalEvaluation</code> object that provides details about compliance.</p>', ], ], 'FailedDeleteRemediationExceptionsBatch' => [ 'base' => '<p>List of each of the failed delete remediation exceptions with specific reasons.</p>', 'refs' => [ 'FailedDeleteRemediationExceptionsBatches$member' => NULL, ], ], 'FailedDeleteRemediationExceptionsBatches' => [ 'base' => NULL, 'refs' => [ 'DeleteRemediationExceptionsResponse$FailedBatches' => '<p>Returns a list of failed delete remediation exceptions batch objects. Each object in the batch consists of a list of failed items and failure messages.</p>', ], ], 'FailedRemediationBatch' => [ 'base' => '<p>List of each of the failed remediations with specific reasons.</p>', 'refs' => [ 'FailedRemediationBatches$member' => NULL, ], ], 'FailedRemediationBatches' => [ 'base' => NULL, 'refs' => [ 'PutRemediationConfigurationsResponse$FailedBatches' => '<p>Returns a list of failed remediation batch objects.</p>', ], ], 'FailedRemediationExceptionBatch' => [ 'base' => '<p>List of each of the failed remediation exceptions with specific reasons.</p>', 'refs' => [ 'FailedRemediationExceptionBatches$member' => NULL, ], ], 'FailedRemediationExceptionBatches' => [ 'base' => NULL, 'refs' => [ 'PutRemediationExceptionsResponse$FailedBatches' => '<p>Returns a list of failed remediation exceptions batch objects. Each object in the batch consists of a list of failed items and failure messages.</p>', ], ], 'FieldInfo' => [ 'base' => '<p>Details about the fields such as name of the field.</p>', 'refs' => [ 'FieldInfoList$member' => NULL, ], ], 'FieldInfoList' => [ 'base' => NULL, 'refs' => [ 'QueryInfo$SelectFields' => '<p>Returns a <code>FieldInfo</code> object.</p>', ], ], 'FieldName' => [ 'base' => NULL, 'refs' => [ 'FieldInfo$Name' => '<p>Name of the field.</p>', ], ], 'GetAggregateComplianceDetailsByConfigRuleRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetAggregateComplianceDetailsByConfigRuleResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetAggregateConfigRuleComplianceSummaryRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetAggregateConfigRuleComplianceSummaryResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetAggregateConformancePackComplianceSummaryRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetAggregateConformancePackComplianceSummaryResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetAggregateDiscoveredResourceCountsRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetAggregateDiscoveredResourceCountsResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetAggregateResourceConfigRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetAggregateResourceConfigResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetComplianceDetailsByConfigRuleRequest' => [ 'base' => '<p/>', 'refs' => [], ], 'GetComplianceDetailsByConfigRuleResponse' => [ 'base' => '<p/>', 'refs' => [], ], 'GetComplianceDetailsByResourceRequest' => [ 'base' => '<p/>', 'refs' => [], ], 'GetComplianceDetailsByResourceResponse' => [ 'base' => '<p/>', 'refs' => [], ], 'GetComplianceSummaryByConfigRuleResponse' => [ 'base' => '<p/>', 'refs' => [], ], 'GetComplianceSummaryByResourceTypeRequest' => [ 'base' => '<p/>', 'refs' => [], ], 'GetComplianceSummaryByResourceTypeResponse' => [ 'base' => '<p/>', 'refs' => [], ], 'GetConformancePackComplianceDetailsLimit' => [ 'base' => NULL, 'refs' => [ 'GetConformancePackComplianceDetailsRequest$Limit' => '<p>The maximum number of evaluation results returned on each page. If you do no specify a number, Config uses the default. The default is 100.</p>', ], ], 'GetConformancePackComplianceDetailsRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetConformancePackComplianceDetailsResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetConformancePackComplianceSummaryRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetConformancePackComplianceSummaryResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetCustomRulePolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetCustomRulePolicyResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetDiscoveredResourceCountsRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetDiscoveredResourceCountsResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetOrganizationConfigRuleDetailedStatusRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetOrganizationConfigRuleDetailedStatusResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetOrganizationConformancePackDetailedStatusRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetOrganizationConformancePackDetailedStatusResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetOrganizationCustomRulePolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetOrganizationCustomRulePolicyResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetResourceConfigHistoryRequest' => [ 'base' => '<p>The input for the <a>GetResourceConfigHistory</a> action.</p>', 'refs' => [], ], 'GetResourceConfigHistoryResponse' => [ 'base' => '<p>The output for the <a>GetResourceConfigHistory</a> action.</p>', 'refs' => [], ], 'GetStoredQueryRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetStoredQueryResponse' => [ 'base' => NULL, 'refs' => [], ], 'GroupByAPILimit' => [ 'base' => NULL, 'refs' => [ 'DescribeAggregateComplianceByConfigRulesRequest$Limit' => '<p>The maximum number of evaluation results returned on each page. The default is maximum. If you specify 0, Config uses the default.</p>', 'GetAggregateConfigRuleComplianceSummaryRequest$Limit' => '<p>The maximum number of evaluation results returned on each page. The default is 1000. You cannot specify a number greater than 1000. If you specify 0, Config uses the default.</p>', 'GetAggregateDiscoveredResourceCountsRequest$Limit' => '<p>The maximum number of <a>GroupedResourceCount</a> objects returned on each page. The default is 1000. You cannot specify a number greater than 1000. If you specify 0, Config uses the default.</p>', ], ], 'GroupedResourceCount' => [ 'base' => '<p>The count of resources that are grouped by the group name.</p>', 'refs' => [ 'GroupedResourceCountList$member' => NULL, ], ], 'GroupedResourceCountList' => [ 'base' => NULL, 'refs' => [ 'GetAggregateDiscoveredResourceCountsResponse$GroupedResourceCounts' => '<p>Returns a list of GroupedResourceCount objects.</p>', ], ], 'IncludeGlobalResourceTypes' => [ 'base' => NULL, 'refs' => [ 'RecordingGroup$includeGlobalResourceTypes' => '<p>Specifies whether Config includes all supported types of global resources (for example, IAM resources) with the resources that it records.</p> <p>Before you can set this option to <code>true</code>, you must set the <code>allSupported</code> option to <code>true</code>.</p> <p>If you set this option to <code>true</code>, when Config adds support for a new type of global resource, it starts recording resources of that type automatically.</p> <p>The configuration details for any global resource are the same in all regions. To prevent duplicate configuration items, you should consider customizing Config in only one region to record global resources.</p>', ], ], 'InsufficientDeliveryPolicyException' => [ 'base' => '<p>Your Amazon S3 bucket policy does not permit Config to write to it.</p>', 'refs' => [], ], 'InsufficientPermissionsException' => [ 'base' => '<p>Indicates one of the following errors:</p> <ul> <li> <p>For PutConfigRule, the rule cannot be created because the IAM role assigned to Config lacks permissions to perform the config:Put* action.</p> </li> <li> <p>For PutConfigRule, the Lambda function cannot be invoked. Check the function ARN, and check the function\'s permissions.</p> </li> <li> <p>For PutOrganizationConfigRule, organization Config rule cannot be created because you do not have permissions to call IAM <code>GetRole</code> action or create a service linked role.</p> </li> <li> <p>For PutConformancePack and PutOrganizationConformancePack, a conformance pack cannot be created because you do not have permissions: </p> <ul> <li> <p>To call IAM <code>GetRole</code> action or create a service linked role.</p> </li> <li> <p>To read Amazon S3 bucket.</p> </li> </ul> </li> </ul>', 'refs' => [], ], 'Integer' => [ 'base' => NULL, 'refs' => [ 'AggregateConformancePackCompliance$CompliantRuleCount' => '<p>The number of compliant Config Rules.</p>', 'AggregateConformancePackCompliance$NonCompliantRuleCount' => '<p>The number of noncompliant Config Rules.</p>', 'AggregateConformancePackCompliance$TotalRuleCount' => '<p>Total number of compliant rules, noncompliant rules, and the rules that do not have any applicable resources to evaluate upon resulting in insufficient data.</p>', 'AggregateConformancePackComplianceCount$CompliantConformancePackCount' => '<p>Number of compliant conformance packs.</p>', 'AggregateConformancePackComplianceCount$NonCompliantConformancePackCount' => '<p>Number of noncompliant conformance packs.</p>', 'ComplianceContributorCount$CappedCount' => '<p>The number of Amazon Web Services resources or Config rules responsible for the current compliance of the item.</p>', ], ], 'InvalidConfigurationRecorderNameException' => [ 'base' => '<p>You have provided a configuration recorder name that is not valid.</p>', 'refs' => [], ], 'InvalidDeliveryChannelNameException' => [ 'base' => '<p>The specified delivery channel name is not valid.</p>', 'refs' => [], ], 'InvalidExpressionException' => [ 'base' => '<p>The syntax of the query is incorrect.</p>', 'refs' => [], ], 'InvalidLimitException' => [ 'base' => '<p>The specified limit is outside the allowable range.</p>', 'refs' => [], ], 'InvalidNextTokenException' => [ 'base' => '<p>The specified next token is invalid. Specify the <code>nextToken</code> string that was returned in the previous response to get the next page of results.</p>', 'refs' => [], ], 'InvalidParameterValueException' => [ 'base' => '<p>One or more of the specified parameters are invalid. Verify that your parameters are valid and try again.</p>', 'refs' => [], ], 'InvalidRecordingGroupException' => [ 'base' => '<p>Config throws an exception if the recording group does not contain a valid list of resource types. Invalid values might also be incorrectly formatted.</p>', 'refs' => [], ], 'InvalidResultTokenException' => [ 'base' => '<p>The specified <code>ResultToken</code> is invalid.</p>', 'refs' => [], ], 'InvalidRoleException' => [ 'base' => '<p>You have provided a null or empty role ARN.</p>', 'refs' => [], ], 'InvalidS3KeyPrefixException' => [ 'base' => '<p>The specified Amazon S3 key prefix is not valid.</p>', 'refs' => [], ], 'InvalidS3KmsKeyArnException' => [ 'base' => '<p>The specified Amazon KMS Key ARN is not valid.</p>', 'refs' => [], ], 'InvalidSNSTopicARNException' => [ 'base' => '<p>The specified Amazon SNS topic does not exist.</p>', 'refs' => [], ], 'InvalidTimeRangeException' => [ 'base' => '<p>The specified time range is not valid. The earlier time is not chronologically before the later time.</p>', 'refs' => [], ], 'LastDeliveryChannelDeleteFailedException' => [ 'base' => '<p>You cannot delete the delivery channel you specified because the configuration recorder is running.</p>', 'refs' => [], ], 'LaterTime' => [ 'base' => NULL, 'refs' => [ 'GetResourceConfigHistoryRequest$laterTime' => '<p>The time stamp that indicates a later time. If not specified, current time is taken.</p>', ], ], 'Limit' => [ 'base' => NULL, 'refs' => [ 'DescribeAggregateComplianceByConformancePacksRequest$Limit' => '<p>The maximum number of conformance packs compliance details returned on each page. The default is maximum. If you specify 0, Config uses the default. </p>', 'DescribeAggregationAuthorizationsRequest$Limit' => '<p>The maximum number of AggregationAuthorizations returned on each page. The default is maximum. If you specify 0, Config uses the default.</p>', 'DescribeComplianceByResourceRequest$Limit' => '<p>The maximum number of evaluation results returned on each page. The default is 10. You cannot specify a number greater than 100. If you specify 0, Config uses the default.</p>', 'DescribeConfigurationAggregatorSourcesStatusRequest$Limit' => '<p>The maximum number of AggregatorSourceStatus returned on each page. The default is maximum. If you specify 0, Config uses the default.</p>', 'DescribeConfigurationAggregatorsRequest$Limit' => '<p>The maximum number of configuration aggregators returned on each page. The default is maximum. If you specify 0, Config uses the default.</p>', 'DescribeRemediationExceptionsRequest$Limit' => '<p>The maximum number of RemediationExceptionResourceKey returned on each page. The default is 25. If you specify 0, Config uses the default.</p>', 'DescribeRemediationExecutionStatusRequest$Limit' => '<p>The maximum number of RemediationExecutionStatuses returned on each page. The default is maximum. If you specify 0, Config uses the default. </p>', 'GetAggregateComplianceDetailsByConfigRuleRequest$Limit' => '<p>The maximum number of evaluation results returned on each page. The default is 50. You cannot specify a number greater than 100. If you specify 0, Config uses the default.</p>', 'GetAggregateConformancePackComplianceSummaryRequest$Limit' => '<p>The maximum number of results returned on each page. The default is maximum. If you specify 0, Config uses the default.</p>', 'GetComplianceDetailsByConfigRuleRequest$Limit' => '<p>The maximum number of evaluation results returned on each page. The default is 10. You cannot specify a number greater than 100. If you specify 0, Config uses the default.</p>', 'GetDiscoveredResourceCountsRequest$limit' => '<p>The maximum number of <a>ResourceCount</a> objects returned on each page. The default is 100. You cannot specify a number greater than 100. If you specify 0, Config uses the default.</p>', 'GetResourceConfigHistoryRequest$limit' => '<p>The maximum number of configuration items returned on each page. The default is 10. You cannot specify a number greater than 100. If you specify 0, Config uses the default.</p>', 'ListAggregateDiscoveredResourcesRequest$Limit' => '<p>The maximum number of resource identifiers returned on each page. You cannot specify a number greater than 100. If you specify 0, Config uses the default.</p>', 'ListDiscoveredResourcesRequest$limit' => '<p>The maximum number of resource identifiers returned on each page. The default is 100. You cannot specify a number greater than 100. If you specify 0, Config uses the default.</p>', 'ListStoredQueriesRequest$MaxResults' => '<p>The maximum number of results to be returned with a single call.</p>', 'ListTagsForResourceRequest$Limit' => '<p>The maximum number of tags returned on each page. The limit maximum is 50. You cannot specify a number greater than 50. If you specify 0, Config uses the default. </p>', 'SelectAggregateResourceConfigRequest$Limit' => '<p>The maximum number of query results returned on each page. </p>', 'SelectAggregateResourceConfigRequest$MaxResults' => '<p>The maximum number of query results returned on each page. Config also allows the Limit request parameter.</p>', 'SelectResourceConfigRequest$Limit' => '<p>The maximum number of query results returned on each page. </p>', ], ], 'LimitExceededException' => [ 'base' => '<p>For <code>StartConfigRulesEvaluation</code> API, this exception is thrown if an evaluation is in progress or if you call the <a>StartConfigRulesEvaluation</a> API more than once per minute.</p> <p>For <code>PutConfigurationAggregator</code> API, this exception is thrown if the number of accounts and aggregators exceeds the limit.</p>', 'refs' => [], ], 'ListAggregateDiscoveredResourcesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListAggregateDiscoveredResourcesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListDiscoveredResourcesRequest' => [ 'base' => '<p/>', 'refs' => [], ], 'ListDiscoveredResourcesResponse' => [ 'base' => '<p/>', 'refs' => [], ], 'ListStoredQueriesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListStoredQueriesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'Long' => [ 'base' => NULL, 'refs' => [ 'GetAggregateDiscoveredResourceCountsResponse$TotalDiscoveredResources' => '<p>The total number of resources that are present in an aggregator with the filters that you provide.</p>', 'GetDiscoveredResourceCountsResponse$totalDiscoveredResources' => '<p>The total number of resources that Config is recording in the region for your account. If you specify resource types in the request, Config returns only the total number of resources for those resource types.</p> <p class="title"> <b>Example</b> </p> <ol> <li> <p>Config is recording three resource types in the US East (Ohio) Region for your account: 25 EC2 instances, 20 IAM users, and 15 S3 buckets, for a total of 60 resources.</p> </li> <li> <p>You make a call to the <code>GetDiscoveredResourceCounts</code> action and specify the resource type, <code>"AWS::EC2::Instances"</code>, in the request.</p> </li> <li> <p>Config returns 25 for <code>totalDiscoveredResources</code>.</p> </li> </ol>', 'GroupedResourceCount$ResourceCount' => '<p>The number of resources in the group.</p>', 'ResourceCount$count' => '<p>The number of resources.</p>', ], ], 'MaxActiveResourcesExceededException' => [ 'base' => '<p>You have reached the limit (100,000) of active custom resource types in your account. Delete unused resources using <code>DeleteResourceConfig</code>.</p>', 'refs' => [], ], 'MaxNumberOfConfigRulesExceededException' => [ 'base' => '<p>Failed to add the Config rule because the account already contains the maximum number of 150 rules. Consider deleting any deactivated rules before you add new rules.</p>', 'refs' => [], ], 'MaxNumberOfConfigurationRecordersExceededException' => [ 'base' => '<p>You have reached the limit of the number of recorders you can create.</p>', 'refs' => [], ], 'MaxNumberOfConformancePacksExceededException' => [ 'base' => '<p>You have reached the limit (6) of the number of conformance packs in an account (6 conformance pack with 25 Config rules per pack).</p>', 'refs' => [], ], 'MaxNumberOfDeliveryChannelsExceededException' => [ 'base' => '<p>You have reached the limit of the number of delivery channels you can create.</p>', 'refs' => [], ], 'MaxNumberOfOrganizationConfigRulesExceededException' => [ 'base' => '<p>You have reached the limit of the number of organization Config rules you can create.</p>', 'refs' => [], ], 'MaxNumberOfOrganizationConformancePacksExceededException' => [ 'base' => '<p>You have reached the limit (6) of the number of organization conformance packs in an account (6 conformance pack with 25 Config rules per pack per account).</p>', 'refs' => [], ], 'MaxNumberOfRetentionConfigurationsExceededException' => [ 'base' => '<p>Failed to add the retention configuration because a retention configuration with that name already exists.</p>', 'refs' => [], ], 'MaximumExecutionFrequency' => [ 'base' => NULL, 'refs' => [ 'ConfigRule$MaximumExecutionFrequency' => '<p>The maximum frequency with which Config runs evaluations for a rule. You can specify a value for <code>MaximumExecutionFrequency</code> when:</p> <ul> <li> <p>You are using an Config managed rule that is triggered at a periodic frequency.</p> </li> <li> <p>Your custom rule is triggered when Config delivers the configuration snapshot. For more information, see <a>ConfigSnapshotDeliveryProperties</a>.</p> </li> </ul> <note> <p>By default, rules with a periodic trigger are evaluated every 24 hours. To change the frequency, specify a valid value for the <code>MaximumExecutionFrequency</code> parameter.</p> </note>', 'ConfigSnapshotDeliveryProperties$deliveryFrequency' => '<p>The frequency with which Config delivers configuration snapshots.</p>', 'OrganizationCustomPolicyRuleMetadata$MaximumExecutionFrequency' => '<p>The maximum frequency with which Config runs evaluations for a rule. Your Config Custom Policy rule is triggered when Config delivers the configuration snapshot. For more information, see <a>ConfigSnapshotDeliveryProperties</a>.</p>', 'OrganizationCustomPolicyRuleMetadataNoPolicy$MaximumExecutionFrequency' => '<p>The maximum frequency with which Config runs evaluations for a rule. Your Config Custom Policy rule is triggered when Config delivers the configuration snapshot. For more information, see <a>ConfigSnapshotDeliveryProperties</a>.</p>', 'OrganizationCustomRuleMetadata$MaximumExecutionFrequency' => '<p>The maximum frequency with which Config runs evaluations for a rule. Your custom rule is triggered when Config delivers the configuration snapshot. For more information, see <a>ConfigSnapshotDeliveryProperties</a>.</p> <note> <p>By default, rules with a periodic trigger are evaluated every 24 hours. To change the frequency, specify a valid value for the <code>MaximumExecutionFrequency</code> parameter.</p> </note>', 'OrganizationManagedRuleMetadata$MaximumExecutionFrequency' => '<p>The maximum frequency with which Config runs evaluations for a rule. You are using an Config managed rule that is triggered at a periodic frequency.</p> <note> <p>By default, rules with a periodic trigger are evaluated every 24 hours. To change the frequency, specify a valid value for the <code>MaximumExecutionFrequency</code> parameter.</p> </note>', 'SourceDetail$MaximumExecutionFrequency' => '<p>The frequency at which you want Config to run evaluations for a custom rule with a periodic trigger. If you specify a value for <code>MaximumExecutionFrequency</code>, then <code>MessageType</code> must use the <code>ScheduledNotification</code> value.</p> <note> <p>By default, rules with a periodic trigger are evaluated every 24 hours. To change the frequency, specify a valid value for the <code>MaximumExecutionFrequency</code> parameter.</p> <p>Based on the valid value you choose, Config runs evaluations once for each valid value. For example, if you choose <code>Three_Hours</code>, Config runs evaluations once every three hours. In this case, <code>Three_Hours</code> is the frequency of this rule. </p> </note>', ], ], 'MemberAccountRuleStatus' => [ 'base' => NULL, 'refs' => [ 'MemberAccountStatus$MemberAccountRuleStatus' => '<p>Indicates deployment status for Config rule in the member account. When master account calls <code>PutOrganizationConfigRule</code> action for the first time, Config rule status is created in the member account. When master account calls <code>PutOrganizationConfigRule</code> action for the second time, Config rule status is updated in the member account. Config rule status is deleted when the master account deletes <code>OrganizationConfigRule</code> and disables service access for <code>config-multiaccountsetup.amazonaws.com</code>. </p> <p> Config sets the state of the rule to:</p> <ul> <li> <p> <code>CREATE_SUCCESSFUL</code> when Config rule has been created in the member account. </p> </li> <li> <p> <code>CREATE_IN_PROGRESS</code> when Config rule is being created in the member account.</p> </li> <li> <p> <code>CREATE_FAILED</code> when Config rule creation has failed in the member account.</p> </li> <li> <p> <code>DELETE_FAILED</code> when Config rule deletion has failed in the member account.</p> </li> <li> <p> <code>DELETE_IN_PROGRESS</code> when Config rule is being deleted in the member account.</p> </li> <li> <p> <code>DELETE_SUCCESSFUL</code> when Config rule has been deleted in the member account. </p> </li> <li> <p> <code>UPDATE_SUCCESSFUL</code> when Config rule has been updated in the member account.</p> </li> <li> <p> <code>UPDATE_IN_PROGRESS</code> when Config rule is being updated in the member account.</p> </li> <li> <p> <code>UPDATE_FAILED</code> when Config rule deletion has failed in the member account.</p> </li> </ul>', 'StatusDetailFilters$MemberAccountRuleStatus' => '<p>Indicates deployment status for Config rule in the member account. When master account calls <code>PutOrganizationConfigRule</code> action for the first time, Config rule status is created in the member account. When master account calls <code>PutOrganizationConfigRule</code> action for the second time, Config rule status is updated in the member account. Config rule status is deleted when the master account deletes <code>OrganizationConfigRule</code> and disables service access for <code>config-multiaccountsetup.amazonaws.com</code>. </p> <p>Config sets the state of the rule to:</p> <ul> <li> <p> <code>CREATE_SUCCESSFUL</code> when Config rule has been created in the member account.</p> </li> <li> <p> <code>CREATE_IN_PROGRESS</code> when Config rule is being created in the member account.</p> </li> <li> <p> <code>CREATE_FAILED</code> when Config rule creation has failed in the member account.</p> </li> <li> <p> <code>DELETE_FAILED</code> when Config rule deletion has failed in the member account.</p> </li> <li> <p> <code>DELETE_IN_PROGRESS</code> when Config rule is being deleted in the member account.</p> </li> <li> <p> <code>DELETE_SUCCESSFUL</code> when Config rule has been deleted in the member account.</p> </li> <li> <p> <code>UPDATE_SUCCESSFUL</code> when Config rule has been updated in the member account.</p> </li> <li> <p> <code>UPDATE_IN_PROGRESS</code> when Config rule is being updated in the member account.</p> </li> <li> <p> <code>UPDATE_FAILED</code> when Config rule deletion has failed in the member account.</p> </li> </ul>', ], ], 'MemberAccountStatus' => [ 'base' => '<p>Organization Config rule creation or deletion status in each member account. This includes the name of the rule, the status, error code and error message when the rule creation or deletion failed.</p>', 'refs' => [ 'OrganizationConfigRuleDetailedStatus$member' => NULL, ], ], 'MessageType' => [ 'base' => NULL, 'refs' => [ 'SourceDetail$MessageType' => '<p>The type of notification that triggers Config to run an evaluation for a rule. You can specify the following notification types:</p> <ul> <li> <p> <code>ConfigurationItemChangeNotification</code> - Triggers an evaluation when Config delivers a configuration item as a result of a resource change.</p> </li> <li> <p> <code>OversizedConfigurationItemChangeNotification</code> - Triggers an evaluation when Config delivers an oversized configuration item. Config may generate this notification type when a resource changes and the notification exceeds the maximum size allowed by Amazon SNS.</p> </li> <li> <p> <code>ScheduledNotification</code> - Triggers a periodic evaluation at the frequency specified for <code>MaximumExecutionFrequency</code>.</p> </li> <li> <p> <code>ConfigurationSnapshotDeliveryCompleted</code> - Triggers a periodic evaluation when Config delivers a configuration snapshot.</p> </li> </ul> <p>If you want your custom rule to be triggered by configuration changes, specify two SourceDetail objects, one for <code>ConfigurationItemChangeNotification</code> and one for <code>OversizedConfigurationItemChangeNotification</code>.</p>', ], ], 'Name' => [ 'base' => NULL, 'refs' => [ 'Tags$key' => NULL, ], ], 'NextToken' => [ 'base' => NULL, 'refs' => [ 'DescribeAggregateComplianceByConfigRulesRequest$NextToken' => '<p>The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a paginated response.</p>', 'DescribeAggregateComplianceByConfigRulesResponse$NextToken' => '<p>The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a paginated response.</p>', 'DescribeAggregateComplianceByConformancePacksRequest$NextToken' => '<p>The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a paginated response.</p>', 'DescribeAggregateComplianceByConformancePacksResponse$NextToken' => '<p>The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a paginated response.</p>', 'DescribeComplianceByResourceRequest$NextToken' => '<p>The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a paginated response.</p>', 'DescribeComplianceByResourceResponse$NextToken' => '<p>The string that you use in a subsequent request to get the next page of results in a paginated response.</p>', 'DescribeConformancePackComplianceRequest$NextToken' => '<p>The <code>nextToken</code> string returned in a previous request that you use to request the next page of results in a paginated response.</p>', 'DescribeConformancePackComplianceResponse$NextToken' => '<p>The <code>nextToken</code> string returned in a previous request that you use to request the next page of results in a paginated response.</p>', 'DescribeConformancePackStatusRequest$NextToken' => '<p>The <code>nextToken</code> string returned in a previous request that you use to request the next page of results in a paginated response.</p>', 'DescribeConformancePackStatusResponse$NextToken' => '<p>The <code>nextToken</code> string returned in a previous request that you use to request the next page of results in a paginated response.</p>', 'DescribeConformancePacksRequest$NextToken' => '<p>The <code>nextToken</code> string returned in a previous request that you use to request the next page of results in a paginated response.</p>', 'DescribeConformancePacksResponse$NextToken' => '<p>The <code>nextToken</code> string returned in a previous request that you use to request the next page of results in a paginated response.</p>', 'DescribeRetentionConfigurationsRequest$NextToken' => '<p>The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a paginated response. </p>', 'DescribeRetentionConfigurationsResponse$NextToken' => '<p>The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a paginated response. </p>', 'GetAggregateComplianceDetailsByConfigRuleRequest$NextToken' => '<p>The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a paginated response.</p>', 'GetAggregateComplianceDetailsByConfigRuleResponse$NextToken' => '<p>The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a paginated response.</p>', 'GetAggregateConfigRuleComplianceSummaryRequest$NextToken' => '<p>The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a paginated response.</p>', 'GetAggregateConfigRuleComplianceSummaryResponse$NextToken' => '<p>The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a paginated response.</p>', 'GetAggregateConformancePackComplianceSummaryRequest$NextToken' => '<p>The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a paginated response.</p>', 'GetAggregateConformancePackComplianceSummaryResponse$NextToken' => '<p>The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a paginated response.</p>', 'GetAggregateDiscoveredResourceCountsRequest$NextToken' => '<p>The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a paginated response. </p>', 'GetAggregateDiscoveredResourceCountsResponse$NextToken' => '<p>The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a paginated response.</p>', 'GetComplianceDetailsByConfigRuleRequest$NextToken' => '<p>The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a paginated response.</p>', 'GetComplianceDetailsByConfigRuleResponse$NextToken' => '<p>The string that you use in a subsequent request to get the next page of results in a paginated response.</p>', 'GetConformancePackComplianceDetailsRequest$NextToken' => '<p>The <code>nextToken</code> string returned in a previous request that you use to request the next page of results in a paginated response.</p>', 'GetConformancePackComplianceDetailsResponse$NextToken' => '<p>The <code>nextToken</code> string returned in a previous request that you use to request the next page of results in a paginated response.</p>', 'GetConformancePackComplianceSummaryRequest$NextToken' => '<p>The nextToken string returned on a previous page that you use to get the next page of results in a paginated response.</p>', 'GetConformancePackComplianceSummaryResponse$NextToken' => '<p>The nextToken string returned on a previous page that you use to get the next page of results in a paginated response.</p>', 'GetDiscoveredResourceCountsRequest$nextToken' => '<p>The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a paginated response.</p>', 'GetDiscoveredResourceCountsResponse$nextToken' => '<p>The string that you use in a subsequent request to get the next page of results in a paginated response.</p>', 'GetResourceConfigHistoryRequest$nextToken' => '<p>The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a paginated response.</p>', 'GetResourceConfigHistoryResponse$nextToken' => '<p>The string that you use in a subsequent request to get the next page of results in a paginated response.</p>', 'ListAggregateDiscoveredResourcesRequest$NextToken' => '<p>The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a paginated response.</p>', 'ListAggregateDiscoveredResourcesResponse$NextToken' => '<p>The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a paginated response.</p>', 'ListDiscoveredResourcesRequest$nextToken' => '<p>The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a paginated response.</p>', 'ListDiscoveredResourcesResponse$nextToken' => '<p>The string that you use in a subsequent request to get the next page of results in a paginated response.</p>', 'ListTagsForResourceRequest$NextToken' => '<p>The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a paginated response. </p>', 'ListTagsForResourceResponse$NextToken' => '<p>The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a paginated response. </p>', 'SelectAggregateResourceConfigRequest$NextToken' => '<p>The nextToken string returned in a previous request that you use to request the next page of results in a paginated response. </p>', 'SelectAggregateResourceConfigResponse$NextToken' => '<p>The nextToken string returned in a previous request that you use to request the next page of results in a paginated response. </p>', 'SelectResourceConfigRequest$NextToken' => '<p>The <code>nextToken</code> string returned in a previous request that you use to request the next page of results in a paginated response. </p>', 'SelectResourceConfigResponse$NextToken' => '<p>The <code>nextToken</code> string returned in a previous request that you use to request the next page of results in a paginated response. </p>', ], ], 'NoAvailableConfigurationRecorderException' => [ 'base' => '<p>There are no configuration recorders available to provide the role needed to describe your resources. Create a configuration recorder.</p>', 'refs' => [], ], 'NoAvailableDeliveryChannelException' => [ 'base' => '<p>There is no delivery channel available to record configurations.</p>', 'refs' => [], ], 'NoAvailableOrganizationException' => [ 'base' => '<p>Organization is no longer available.</p>', 'refs' => [], ], 'NoRunningConfigurationRecorderException' => [ 'base' => '<p>There is no configuration recorder running.</p>', 'refs' => [], ], 'NoSuchBucketException' => [ 'base' => '<p>The specified Amazon S3 bucket does not exist.</p>', 'refs' => [], ], 'NoSuchConfigRuleException' => [ 'base' => '<p>The Config rule in the request is not valid. Verify that the rule is an Config Custom Policy rule, that the rule name is correct, and that valid Amazon Resouce Names (ARNs) are used before trying again.</p>', 'refs' => [], ], 'NoSuchConfigRuleInConformancePackException' => [ 'base' => '<p>Config rule that you passed in the filter does not exist.</p>', 'refs' => [], ], 'NoSuchConfigurationAggregatorException' => [ 'base' => '<p>You have specified a configuration aggregator that does not exist.</p>', 'refs' => [], ], 'NoSuchConfigurationRecorderException' => [ 'base' => '<p>You have specified a configuration recorder that does not exist.</p>', 'refs' => [], ], 'NoSuchConformancePackException' => [ 'base' => '<p>You specified one or more conformance packs that do not exist.</p>', 'refs' => [], ], 'NoSuchDeliveryChannelException' => [ 'base' => '<p>You have specified a delivery channel that does not exist.</p>', 'refs' => [], ], 'NoSuchOrganizationConfigRuleException' => [ 'base' => '<p>The Config rule in the request is not valid. Verify that the rule is an organization Config Custom Policy rule, that the rule name is correct, and that valid Amazon Resouce Names (ARNs) are used before trying again.</p>', 'refs' => [], ], 'NoSuchOrganizationConformancePackException' => [ 'base' => '<p>Config organization conformance pack that you passed in the filter does not exist.</p> <p>For DeleteOrganizationConformancePack, you tried to delete an organization conformance pack that does not exist.</p>', 'refs' => [], ], 'NoSuchRemediationConfigurationException' => [ 'base' => '<p>You specified an Config rule without a remediation configuration.</p>', 'refs' => [], ], 'NoSuchRemediationExceptionException' => [ 'base' => '<p>You tried to delete a remediation exception that does not exist.</p>', 'refs' => [], ], 'NoSuchRetentionConfigurationException' => [ 'base' => '<p>You have specified a retention configuration that does not exist.</p>', 'refs' => [], ], 'OrderingTimestamp' => [ 'base' => NULL, 'refs' => [ 'Evaluation$OrderingTimestamp' => '<p>The time of the event in Config that triggered the evaluation. For event-based evaluations, the time indicates when Config created the configuration item that triggered the evaluation. For periodic evaluations, the time indicates when Config triggered the evaluation at the frequency that you specified (for example, every 24 hours).</p>', 'ExternalEvaluation$OrderingTimestamp' => '<p>The time when the compliance was recorded. </p>', ], ], 'OrganizationAccessDeniedException' => [ 'base' => '<p>For <code>PutConfigurationAggregator</code> API, you can see this exception for the following reasons:</p> <ul> <li> <p>No permission to call <code>EnableAWSServiceAccess</code> API</p> </li> <li> <p>The configuration aggregator cannot be updated because your Amazon Web Services Organization management account or the delegated administrator role changed. Delete this aggregator and create a new one with the current Amazon Web Services Organization.</p> </li> <li> <p>The configuration aggregator is associated with a previous Amazon Web Services Organization and Config cannot aggregate data with current Amazon Web Services Organization. Delete this aggregator and create a new one with the current Amazon Web Services Organization.</p> </li> <li> <p>You are not a registered delegated administrator for Config with permissions to call <code>ListDelegatedAdministrators</code> API. Ensure that the management account registers delagated administrator for Config service principle name before the delegated administrator creates an aggregator.</p> </li> </ul> <p>For all <code>OrganizationConfigRule</code> and <code>OrganizationConformancePack</code> APIs, Config throws an exception if APIs are called from member accounts. All APIs must be called from organization master account.</p>', 'refs' => [], ], 'OrganizationAggregationSource' => [ 'base' => '<p>This object contains regions to set up the aggregator and an IAM role to retrieve organization details.</p>', 'refs' => [ 'ConfigurationAggregator$OrganizationAggregationSource' => '<p>Provides an organization and list of regions to be aggregated.</p>', 'PutConfigurationAggregatorRequest$OrganizationAggregationSource' => '<p>An OrganizationAggregationSource object.</p>', ], ], 'OrganizationAllFeaturesNotEnabledException' => [ 'base' => '<p>Config resource cannot be created because your organization does not have all features enabled.</p>', 'refs' => [], ], 'OrganizationConfigRule' => [ 'base' => '<p>An organization Config rule that has information about Config rules that Config creates in member accounts.</p>', 'refs' => [ 'OrganizationConfigRules$member' => NULL, ], ], 'OrganizationConfigRuleDetailedStatus' => [ 'base' => NULL, 'refs' => [ 'GetOrganizationConfigRuleDetailedStatusResponse$OrganizationConfigRuleDetailedStatus' => '<p>A list of <code>MemberAccountStatus</code> objects.</p>', ], ], 'OrganizationConfigRuleName' => [ 'base' => NULL, 'refs' => [ 'DeleteOrganizationConfigRuleRequest$OrganizationConfigRuleName' => '<p>The name of organization Config rule that you want to delete.</p>', 'GetOrganizationConfigRuleDetailedStatusRequest$OrganizationConfigRuleName' => '<p>The name of your organization Config rule for which you want status details for member accounts.</p>', 'GetOrganizationCustomRulePolicyRequest$OrganizationConfigRuleName' => '<p>The name of your organization Config Custom Policy rule. </p>', 'OrganizationConfigRule$OrganizationConfigRuleName' => '<p>The name that you assign to organization Config rule.</p>', 'OrganizationConfigRuleStatus$OrganizationConfigRuleName' => '<p>The name that you assign to organization Config rule.</p>', 'PutOrganizationConfigRuleRequest$OrganizationConfigRuleName' => '<p>The name that you assign to an organization Config rule.</p>', ], ], 'OrganizationConfigRuleNames' => [ 'base' => NULL, 'refs' => [ 'DescribeOrganizationConfigRuleStatusesRequest$OrganizationConfigRuleNames' => '<p>The names of organization Config rules for which you want status details. If you do not specify any names, Config returns details for all your organization Config rules.</p>', 'DescribeOrganizationConfigRulesRequest$OrganizationConfigRuleNames' => '<p>The names of organization Config rules for which you want details. If you do not specify any names, Config returns details for all your organization Config rules.</p>', ], ], 'OrganizationConfigRuleStatus' => [ 'base' => '<p>Returns the status for an organization Config rule in an organization.</p>', 'refs' => [ 'OrganizationConfigRuleStatuses$member' => NULL, ], ], 'OrganizationConfigRuleStatuses' => [ 'base' => NULL, 'refs' => [ 'DescribeOrganizationConfigRuleStatusesResponse$OrganizationConfigRuleStatuses' => '<p>A list of <code>OrganizationConfigRuleStatus</code> objects.</p>', ], ], 'OrganizationConfigRuleTriggerType' => [ 'base' => NULL, 'refs' => [ 'OrganizationConfigRuleTriggerTypes$member' => NULL, ], ], 'OrganizationConfigRuleTriggerTypeNoSN' => [ 'base' => NULL, 'refs' => [ 'OrganizationConfigRuleTriggerTypeNoSNs$member' => NULL, ], ], 'OrganizationConfigRuleTriggerTypeNoSNs' => [ 'base' => NULL, 'refs' => [ 'OrganizationCustomPolicyRuleMetadata$OrganizationConfigRuleTriggerTypes' => '<p>The type of notification that initiates Config to run an evaluation for a rule. For Config Custom Policy rules, Config supports change-initiated notification types:</p> <ul> <li> <p> <code>ConfigurationItemChangeNotification</code> - Initiates an evaluation when Config delivers a configuration item as a result of a resource change.</p> </li> <li> <p> <code>OversizedConfigurationItemChangeNotification</code> - Initiates an evaluation when Config delivers an oversized configuration item. Config may generate this notification type when a resource changes and the notification exceeds the maximum size allowed by Amazon SNS.</p> </li> </ul>', 'OrganizationCustomPolicyRuleMetadataNoPolicy$OrganizationConfigRuleTriggerTypes' => '<p>The type of notification that triggers Config to run an evaluation for a rule. For Config Custom Policy rules, Config supports change triggered notification types:</p> <ul> <li> <p> <code>ConfigurationItemChangeNotification</code> - Triggers an evaluation when Config delivers a configuration item as a result of a resource change.</p> </li> <li> <p> <code>OversizedConfigurationItemChangeNotification</code> - Triggers an evaluation when Config delivers an oversized configuration item. Config may generate this notification type when a resource changes and the notification exceeds the maximum size allowed by Amazon SNS.</p> </li> </ul>', ], ], 'OrganizationConfigRuleTriggerTypes' => [ 'base' => NULL, 'refs' => [ 'OrganizationCustomRuleMetadata$OrganizationConfigRuleTriggerTypes' => '<p>The type of notification that triggers Config to run an evaluation for a rule. You can specify the following notification types:</p> <ul> <li> <p> <code>ConfigurationItemChangeNotification</code> - Triggers an evaluation when Config delivers a configuration item as a result of a resource change.</p> </li> <li> <p> <code>OversizedConfigurationItemChangeNotification</code> - Triggers an evaluation when Config delivers an oversized configuration item. Config may generate this notification type when a resource changes and the notification exceeds the maximum size allowed by Amazon SNS.</p> </li> <li> <p> <code>ScheduledNotification</code> - Triggers a periodic evaluation at the frequency specified for <code>MaximumExecutionFrequency</code>.</p> </li> </ul>', ], ], 'OrganizationConfigRules' => [ 'base' => NULL, 'refs' => [ 'DescribeOrganizationConfigRulesResponse$OrganizationConfigRules' => '<p>Returns a list of <code>OrganizationConfigRule</code> objects.</p>', ], ], 'OrganizationConformancePack' => [ 'base' => '<p>An organization conformance pack that has information about conformance packs that Config creates in member accounts. </p>', 'refs' => [ 'OrganizationConformancePacks$member' => NULL, ], ], 'OrganizationConformancePackDetailedStatus' => [ 'base' => '<p>Organization conformance pack creation or deletion status in each member account. This includes the name of the conformance pack, the status, error code and error message when the conformance pack creation or deletion failed. </p>', 'refs' => [ 'OrganizationConformancePackDetailedStatuses$member' => NULL, ], ], 'OrganizationConformancePackDetailedStatuses' => [ 'base' => NULL, 'refs' => [ 'GetOrganizationConformancePackDetailedStatusResponse$OrganizationConformancePackDetailedStatuses' => '<p>A list of <code>OrganizationConformancePackDetailedStatus</code> objects. </p>', ], ], 'OrganizationConformancePackName' => [ 'base' => NULL, 'refs' => [ 'DeleteOrganizationConformancePackRequest$OrganizationConformancePackName' => '<p>The name of organization conformance pack that you want to delete.</p>', 'GetOrganizationConformancePackDetailedStatusRequest$OrganizationConformancePackName' => '<p>The name of organization conformance pack for which you want status details for member accounts.</p>', 'OrganizationConformancePack$OrganizationConformancePackName' => '<p>The name you assign to an organization conformance pack.</p>', 'OrganizationConformancePackNames$member' => NULL, 'OrganizationConformancePackStatus$OrganizationConformancePackName' => '<p>The name that you assign to organization conformance pack.</p>', 'PutOrganizationConformancePackRequest$OrganizationConformancePackName' => '<p>Name of the organization conformance pack you want to create.</p>', ], ], 'OrganizationConformancePackNames' => [ 'base' => NULL, 'refs' => [ 'DescribeOrganizationConformancePackStatusesRequest$OrganizationConformancePackNames' => '<p>The names of organization conformance packs for which you want status details. If you do not specify any names, Config returns details for all your organization conformance packs. </p>', 'DescribeOrganizationConformancePacksRequest$OrganizationConformancePackNames' => '<p>The name that you assign to an organization conformance pack.</p>', ], ], 'OrganizationConformancePackStatus' => [ 'base' => '<p>Returns the status for an organization conformance pack in an organization.</p>', 'refs' => [ 'OrganizationConformancePackStatuses$member' => NULL, ], ], 'OrganizationConformancePackStatuses' => [ 'base' => NULL, 'refs' => [ 'DescribeOrganizationConformancePackStatusesResponse$OrganizationConformancePackStatuses' => '<p>A list of <code>OrganizationConformancePackStatus</code> objects. </p>', ], ], 'OrganizationConformancePackTemplateValidationException' => [ 'base' => '<p>You have specified a template that is not valid or supported.</p>', 'refs' => [], ], 'OrganizationConformancePacks' => [ 'base' => NULL, 'refs' => [ 'DescribeOrganizationConformancePacksResponse$OrganizationConformancePacks' => '<p>Returns a list of OrganizationConformancePacks objects.</p>', ], ], 'OrganizationCustomPolicyRuleMetadata' => [ 'base' => '<p>An object that specifies metadata for your organization\'s Config Custom Policy rule. The metadata includes the runtime system in use, which accounts have debug logging enabled, and other custom rule metadata, such as resource type, resource ID of Amazon Web Services resource, and organization trigger types that initiate Config to evaluate Amazon Web Services resources against a rule.</p>', 'refs' => [ 'PutOrganizationConfigRuleRequest$OrganizationCustomPolicyRuleMetadata' => '<p>An object that specifies metadata for your organization\'s Config Custom Policy rule. The metadata includes the runtime system in use, which accounts have debug logging enabled, and other custom rule metadata, such as resource type, resource ID of Amazon Web Services resource, and organization trigger types that initiate Config to evaluate Amazon Web Services resources against a rule.</p>', ], ], 'OrganizationCustomPolicyRuleMetadataNoPolicy' => [ 'base' => '<p>An object that specifies metadata for your organization Config Custom Policy rule including the runtime system in use, which accounts have debug logging enabled, and other custom rule metadata such as resource type, resource ID of Amazon Web Services resource, and organization trigger types that trigger Config to evaluate Amazon Web Services resources against a rule.</p>', 'refs' => [ 'OrganizationConfigRule$OrganizationCustomPolicyRuleMetadata' => '<p>An object that specifies metadata for your organization\'s Config Custom Policy rule. The metadata includes the runtime system in use, which accounts have debug logging enabled, and other custom rule metadata, such as resource type, resource ID of Amazon Web Services resource, and organization trigger types that initiate Config to evaluate Amazon Web Services resources against a rule.</p>', ], ], 'OrganizationCustomRuleMetadata' => [ 'base' => '<p>An object that specifies organization custom rule metadata such as resource type, resource ID of Amazon Web Services resource, Lambda function ARN, and organization trigger types that trigger Config to evaluate your Amazon Web Services resources against a rule. It also provides the frequency with which you want Config to run evaluations for the rule if the trigger type is periodic.</p>', 'refs' => [ 'OrganizationConfigRule$OrganizationCustomRuleMetadata' => '<p>An <code>OrganizationCustomRuleMetadata</code> object.</p>', 'PutOrganizationConfigRuleRequest$OrganizationCustomRuleMetadata' => '<p>An <code>OrganizationCustomRuleMetadata</code> object.</p>', ], ], 'OrganizationManagedRuleMetadata' => [ 'base' => '<p>An object that specifies organization managed rule metadata such as resource type and ID of Amazon Web Services resource along with the rule identifier. It also provides the frequency with which you want Config to run evaluations for the rule if the trigger type is periodic.</p>', 'refs' => [ 'OrganizationConfigRule$OrganizationManagedRuleMetadata' => '<p>An <code>OrganizationManagedRuleMetadata</code> object.</p>', 'PutOrganizationConfigRuleRequest$OrganizationManagedRuleMetadata' => '<p>An <code>OrganizationManagedRuleMetadata</code> object. </p>', ], ], 'OrganizationResourceDetailedStatus' => [ 'base' => NULL, 'refs' => [ 'OrganizationConformancePackDetailedStatus$Status' => '<p>Indicates deployment status for conformance pack in a member account. When master account calls <code>PutOrganizationConformancePack</code> action for the first time, conformance pack status is created in the member account. When master account calls <code>PutOrganizationConformancePack</code> action for the second time, conformance pack status is updated in the member account. Conformance pack status is deleted when the master account deletes <code>OrganizationConformancePack</code> and disables service access for <code>config-multiaccountsetup.amazonaws.com</code>. </p> <p> Config sets the state of the conformance pack to:</p> <ul> <li> <p> <code>CREATE_SUCCESSFUL</code> when conformance pack has been created in the member account. </p> </li> <li> <p> <code>CREATE_IN_PROGRESS</code> when conformance pack is being created in the member account.</p> </li> <li> <p> <code>CREATE_FAILED</code> when conformance pack creation has failed in the member account.</p> </li> <li> <p> <code>DELETE_FAILED</code> when conformance pack deletion has failed in the member account.</p> </li> <li> <p> <code>DELETE_IN_PROGRESS</code> when conformance pack is being deleted in the member account.</p> </li> <li> <p> <code>DELETE_SUCCESSFUL</code> when conformance pack has been deleted in the member account. </p> </li> <li> <p> <code>UPDATE_SUCCESSFUL</code> when conformance pack has been updated in the member account.</p> </li> <li> <p> <code>UPDATE_IN_PROGRESS</code> when conformance pack is being updated in the member account.</p> </li> <li> <p> <code>UPDATE_FAILED</code> when conformance pack deletion has failed in the member account.</p> </li> </ul>', 'OrganizationResourceDetailedStatusFilters$Status' => '<p>Indicates deployment status for conformance pack in a member account. When master account calls <code>PutOrganizationConformancePack</code> action for the first time, conformance pack status is created in the member account. When master account calls <code>PutOrganizationConformancePack</code> action for the second time, conformance pack status is updated in the member account. Conformance pack status is deleted when the master account deletes <code>OrganizationConformancePack</code> and disables service access for <code>config-multiaccountsetup.amazonaws.com</code>. </p> <p> Config sets the state of the conformance pack to:</p> <ul> <li> <p> <code>CREATE_SUCCESSFUL</code> when conformance pack has been created in the member account. </p> </li> <li> <p> <code>CREATE_IN_PROGRESS</code> when conformance pack is being created in the member account.</p> </li> <li> <p> <code>CREATE_FAILED</code> when conformance pack creation has failed in the member account.</p> </li> <li> <p> <code>DELETE_FAILED</code> when conformance pack deletion has failed in the member account.</p> </li> <li> <p> <code>DELETE_IN_PROGRESS</code> when conformance pack is being deleted in the member account.</p> </li> <li> <p> <code>DELETE_SUCCESSFUL</code> when conformance pack has been deleted in the member account. </p> </li> <li> <p> <code>UPDATE_SUCCESSFUL</code> when conformance pack has been updated in the member account.</p> </li> <li> <p> <code>UPDATE_IN_PROGRESS</code> when conformance pack is being updated in the member account.</p> </li> <li> <p> <code>UPDATE_FAILED</code> when conformance pack deletion has failed in the member account.</p> </li> </ul>', ], ], 'OrganizationResourceDetailedStatusFilters' => [ 'base' => '<p>Status filter object to filter results based on specific member account ID or status type for an organization conformance pack.</p>', 'refs' => [ 'GetOrganizationConformancePackDetailedStatusRequest$Filters' => '<p>An <code>OrganizationResourceDetailedStatusFilters</code> object.</p>', ], ], 'OrganizationResourceStatus' => [ 'base' => NULL, 'refs' => [ 'OrganizationConformancePackStatus$Status' => '<p>Indicates deployment status of an organization conformance pack. When master account calls PutOrganizationConformancePack for the first time, conformance pack status is created in all the member accounts. When master account calls PutOrganizationConformancePack for the second time, conformance pack status is updated in all the member accounts. Additionally, conformance pack status is updated when one or more member accounts join or leave an organization. Conformance pack status is deleted when the master account deletes OrganizationConformancePack in all the member accounts and disables service access for <code>config-multiaccountsetup.amazonaws.com</code>.</p> <p>Config sets the state of the conformance pack to:</p> <ul> <li> <p> <code>CREATE_SUCCESSFUL</code> when an organization conformance pack has been successfully created in all the member accounts. </p> </li> <li> <p> <code>CREATE_IN_PROGRESS</code> when an organization conformance pack creation is in progress.</p> </li> <li> <p> <code>CREATE_FAILED</code> when an organization conformance pack creation failed in one or more member accounts within that organization.</p> </li> <li> <p> <code>DELETE_FAILED</code> when an organization conformance pack deletion failed in one or more member accounts within that organization.</p> </li> <li> <p> <code>DELETE_IN_PROGRESS</code> when an organization conformance pack deletion is in progress.</p> </li> <li> <p> <code>DELETE_SUCCESSFUL</code> when an organization conformance pack has been successfully deleted from all the member accounts.</p> </li> <li> <p> <code>UPDATE_SUCCESSFUL</code> when an organization conformance pack has been successfully updated in all the member accounts.</p> </li> <li> <p> <code>UPDATE_IN_PROGRESS</code> when an organization conformance pack update is in progress.</p> </li> <li> <p> <code>UPDATE_FAILED</code> when an organization conformance pack update failed in one or more member accounts within that organization.</p> </li> </ul>', ], ], 'OrganizationRuleStatus' => [ 'base' => NULL, 'refs' => [ 'OrganizationConfigRuleStatus$OrganizationRuleStatus' => '<p>Indicates deployment status of an organization Config rule. When master account calls PutOrganizationConfigRule action for the first time, Config rule status is created in all the member accounts. When master account calls PutOrganizationConfigRule action for the second time, Config rule status is updated in all the member accounts. Additionally, Config rule status is updated when one or more member accounts join or leave an organization. Config rule status is deleted when the master account deletes OrganizationConfigRule in all the member accounts and disables service access for <code>config-multiaccountsetup.amazonaws.com</code>.</p> <p>Config sets the state of the rule to:</p> <ul> <li> <p> <code>CREATE_SUCCESSFUL</code> when an organization Config rule has been successfully created in all the member accounts. </p> </li> <li> <p> <code>CREATE_IN_PROGRESS</code> when an organization Config rule creation is in progress.</p> </li> <li> <p> <code>CREATE_FAILED</code> when an organization Config rule creation failed in one or more member accounts within that organization.</p> </li> <li> <p> <code>DELETE_FAILED</code> when an organization Config rule deletion failed in one or more member accounts within that organization.</p> </li> <li> <p> <code>DELETE_IN_PROGRESS</code> when an organization Config rule deletion is in progress.</p> </li> <li> <p> <code>DELETE_SUCCESSFUL</code> when an organization Config rule has been successfully deleted from all the member accounts.</p> </li> <li> <p> <code>UPDATE_SUCCESSFUL</code> when an organization Config rule has been successfully updated in all the member accounts.</p> </li> <li> <p> <code>UPDATE_IN_PROGRESS</code> when an organization Config rule update is in progress.</p> </li> <li> <p> <code>UPDATE_FAILED</code> when an organization Config rule update failed in one or more member accounts within that organization.</p> </li> </ul>', ], ], 'OversizedConfigurationItemException' => [ 'base' => '<p>The configuration item size is outside the allowable range.</p>', 'refs' => [], ], 'Owner' => [ 'base' => NULL, 'refs' => [ 'Source$Owner' => '<p>Indicates whether Amazon Web Services or the customer owns and manages the Config rule.</p> <p>Config Managed Rules are predefined rules owned by Amazon Web Services. For more information, see <a href="https://docs.aws.amazon.com/config/latest/developerguide/evaluate-config_use-managed-rules.html">Config Managed Rules</a> in the Config developer guide.</p> <p>Config Custom Rules are rules that you can develop either with Guard (<code>CUSTOM_POLICY</code>) or Lambda (<code>CUSTOM_LAMBDA</code>). For more information, see <a href="https://docs.aws.amazon.com/config/latest/developerguide/evaluate-config_develop-rules.html">Config Custom Rules </a> in the Config developer guide.</p>', ], ], 'PageSizeLimit' => [ 'base' => NULL, 'refs' => [ 'DescribeConformancePackStatusRequest$Limit' => '<p>The maximum number of conformance packs status returned on each page.</p>', 'DescribeConformancePacksRequest$Limit' => '<p>The maximum number of conformance packs returned on each page.</p>', 'GetConformancePackComplianceSummaryRequest$Limit' => '<p>The maximum number of conformance packs returned on each page.</p>', ], ], 'ParameterName' => [ 'base' => NULL, 'refs' => [ 'ConformancePackInputParameter$ParameterName' => '<p>One part of a key-value pair.</p>', ], ], 'ParameterValue' => [ 'base' => NULL, 'refs' => [ 'ConformancePackInputParameter$ParameterValue' => '<p>Another part of the key-value pair. </p>', ], ], 'PendingAggregationRequest' => [ 'base' => '<p>An object that represents the account ID and region of an aggregator account that is requesting authorization but is not yet authorized.</p>', 'refs' => [ 'PendingAggregationRequestList$member' => NULL, ], ], 'PendingAggregationRequestList' => [ 'base' => NULL, 'refs' => [ 'DescribePendingAggregationRequestsResponse$PendingAggregationRequests' => '<p>Returns a PendingAggregationRequests object.</p>', ], ], 'Percentage' => [ 'base' => NULL, 'refs' => [ 'SsmControls$ConcurrentExecutionRatePercentage' => '<p>The maximum percentage of remediation actions allowed to run in parallel on the non-compliant resources for that specific rule. You can specify a percentage, such as 10%. The default value is 10. </p>', 'SsmControls$ErrorPercentage' => '<p>The percentage of errors that are allowed before SSM stops running automations on non-compliant resources for that specific rule. You can specify a percentage of errors, for example 10%. If you do not specifiy a percentage, the default is 50%. For example, if you set the ErrorPercentage to 40% for 10 non-compliant resources, then SSM stops running the automations when the fifth error is received. </p>', ], ], 'PolicyRuntime' => [ 'base' => NULL, 'refs' => [ 'CustomPolicyDetails$PolicyRuntime' => '<p>The runtime system for your Config Custom Policy rule. Guard is a policy-as-code language that allows you to write policies that are enforced by Config Custom Policy rules. For more information about Guard, see the <a href="https://github.com/aws-cloudformation/cloudformation-guard">Guard GitHub Repository</a>.</p>', 'OrganizationCustomPolicyRuleMetadata$PolicyRuntime' => '<p>The runtime system for your organization Config Custom Policy rules. Guard is a policy-as-code language that allows you to write policies that are enforced by Config Custom Policy rules. For more information about Guard, see the <a href="https://github.com/aws-cloudformation/cloudformation-guard">Guard GitHub Repository</a>.</p>', 'OrganizationCustomPolicyRuleMetadataNoPolicy$PolicyRuntime' => '<p>The runtime system for your organization Config Custom Policy rules. Guard is a policy-as-code language that allows you to write policies that are enforced by Config Custom Policy rules. For more information about Guard, see the <a href="https://github.com/aws-cloudformation/cloudformation-guard">Guard GitHub Repository</a>.</p>', ], ], 'PolicyText' => [ 'base' => NULL, 'refs' => [ 'CustomPolicyDetails$PolicyText' => '<p>The policy definition containing the logic for your Config Custom Policy rule.</p>', 'GetCustomRulePolicyResponse$PolicyText' => '<p>The policy definition containing the logic for your Config Custom Policy rule.</p>', 'GetOrganizationCustomRulePolicyResponse$PolicyText' => '<p>The policy definition containing the logic for your organization Config Custom Policy rule.</p>', 'OrganizationCustomPolicyRuleMetadata$PolicyText' => '<p>The policy definition containing the logic for your organization Config Custom Policy rule.</p>', ], ], 'PutAggregationAuthorizationRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutAggregationAuthorizationResponse' => [ 'base' => NULL, 'refs' => [], ], 'PutConfigRuleRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutConfigurationAggregatorRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutConfigurationAggregatorResponse' => [ 'base' => NULL, 'refs' => [], ], 'PutConfigurationRecorderRequest' => [ 'base' => '<p>The input for the <a>PutConfigurationRecorder</a> action.</p>', 'refs' => [], ], 'PutConformancePackRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutConformancePackResponse' => [ 'base' => NULL, 'refs' => [], ], 'PutDeliveryChannelRequest' => [ 'base' => '<p>The input for the <a>PutDeliveryChannel</a> action.</p>', 'refs' => [], ], 'PutEvaluationsRequest' => [ 'base' => '<p/>', 'refs' => [], ], 'PutEvaluationsResponse' => [ 'base' => '<p/>', 'refs' => [], ], 'PutExternalEvaluationRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutExternalEvaluationResponse' => [ 'base' => NULL, 'refs' => [], ], 'PutOrganizationConfigRuleRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutOrganizationConfigRuleResponse' => [ 'base' => NULL, 'refs' => [], ], 'PutOrganizationConformancePackRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutOrganizationConformancePackResponse' => [ 'base' => NULL, 'refs' => [], ], 'PutRemediationConfigurationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutRemediationConfigurationsResponse' => [ 'base' => NULL, 'refs' => [], ], 'PutRemediationExceptionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutRemediationExceptionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'PutResourceConfigRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutRetentionConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutRetentionConfigurationResponse' => [ 'base' => NULL, 'refs' => [], ], 'PutStoredQueryRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutStoredQueryResponse' => [ 'base' => NULL, 'refs' => [], ], 'QueryArn' => [ 'base' => NULL, 'refs' => [ 'PutStoredQueryResponse$QueryArn' => '<p>Amazon Resource Name (ARN) of the query. For example, arn:partition:service:region:account-id:resource-type/resource-name/resource-id.</p>', 'StoredQuery$QueryArn' => '<p>Amazon Resource Name (ARN) of the query. For example, arn:partition:service:region:account-id:resource-type/resource-name/resource-id.</p>', 'StoredQueryMetadata$QueryArn' => '<p>Amazon Resource Name (ARN) of the query. For example, arn:partition:service:region:account-id:resource-type/resource-name/resource-id.</p>', ], ], 'QueryDescription' => [ 'base' => NULL, 'refs' => [ 'StoredQuery$Description' => '<p>A unique description for the query.</p>', 'StoredQueryMetadata$Description' => '<p>A unique description for the query.</p>', ], ], 'QueryExpression' => [ 'base' => NULL, 'refs' => [ 'StoredQuery$Expression' => '<p>The expression of the query. For example, <code>SELECT resourceId, resourceType, supplementaryConfiguration.BucketVersioningConfiguration.status WHERE resourceType = \'AWS::S3::Bucket\' AND supplementaryConfiguration.BucketVersioningConfiguration.status = \'Off\'.</code> </p>', ], ], 'QueryId' => [ 'base' => NULL, 'refs' => [ 'StoredQuery$QueryId' => '<p>The ID of the query.</p>', 'StoredQueryMetadata$QueryId' => '<p>The ID of the query. </p>', ], ], 'QueryInfo' => [ 'base' => '<p>Details about the query.</p>', 'refs' => [ 'SelectAggregateResourceConfigResponse$QueryInfo' => NULL, 'SelectResourceConfigResponse$QueryInfo' => '<p>Returns the <code>QueryInfo</code> object.</p>', ], ], 'QueryName' => [ 'base' => NULL, 'refs' => [ 'DeleteStoredQueryRequest$QueryName' => '<p>The name of the query that you want to delete.</p>', 'GetStoredQueryRequest$QueryName' => '<p>The name of the query.</p>', 'StoredQuery$QueryName' => '<p>The name of the query.</p>', 'StoredQueryMetadata$QueryName' => '<p>The name of the query.</p>', ], ], 'RecorderName' => [ 'base' => NULL, 'refs' => [ 'ConfigurationRecorder$name' => '<p>The name of the recorder. By default, Config automatically assigns the name "default" when creating the configuration recorder. You cannot change the assigned name.</p>', 'ConfigurationRecorderNameList$member' => NULL, 'DeleteConfigurationRecorderRequest$ConfigurationRecorderName' => '<p>The name of the configuration recorder to be deleted. You can retrieve the name of your configuration recorder by using the <code>DescribeConfigurationRecorders</code> action.</p>', 'StartConfigurationRecorderRequest$ConfigurationRecorderName' => '<p>The name of the recorder object that records each configuration change made to the resources.</p>', 'StopConfigurationRecorderRequest$ConfigurationRecorderName' => '<p>The name of the recorder object that records each configuration change made to the resources.</p>', ], ], 'RecorderStatus' => [ 'base' => NULL, 'refs' => [ 'ConfigurationRecorderStatus$lastStatus' => '<p>The last (previous) status of the recorder.</p>', ], ], 'RecordingGroup' => [ 'base' => '<p>Specifies the types of Amazon Web Services resource for which Config records configuration changes.</p> <p>In the recording group, you specify whether all supported types or specific types of resources are recorded.</p> <p>By default, Config records configuration changes for all supported types of regional resources that Config discovers in the region in which it is running. Regional resources are tied to a region and can be used only in that region. Examples of regional resources are EC2 instances and EBS volumes.</p> <p>You can also have Config record configuration changes for supported types of global resources (for example, IAM resources). Global resources are not tied to an individual region and can be used in all regions.</p> <important> <p>The configuration details for any global resource are the same in all regions. If you customize Config in multiple regions to record global resources, it will create multiple configuration items each time a global resource changes: one configuration item for each region. These configuration items will contain identical data. To prevent duplicate configuration items, you should consider customizing Config in only one region to record global resources, unless you want the configuration items to be available in multiple regions.</p> </important> <p>If you don\'t want Config to record all resources, you can specify which types of resources it will record with the <code>resourceTypes</code> parameter.</p> <p>For a list of supported resource types, see <a href="https://docs.aws.amazon.com/config/latest/developerguide/resource-config-reference.html#supported-resources">Supported Resource Types</a>.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/config/latest/developerguide/select-resources.html">Selecting Which Resources Config Records</a>.</p>', 'refs' => [ 'ConfigurationRecorder$recordingGroup' => '<p>Specifies the types of Amazon Web Services resources for which Config records configuration changes.</p>', ], ], 'ReevaluateConfigRuleNames' => [ 'base' => NULL, 'refs' => [ 'StartConfigRulesEvaluationRequest$ConfigRuleNames' => '<p>The list of names of Config rules that you want to run evaluations for.</p>', ], ], 'RelatedEvent' => [ 'base' => NULL, 'refs' => [ 'RelatedEventList$member' => NULL, ], ], 'RelatedEventList' => [ 'base' => NULL, 'refs' => [ 'ConfigurationItem$relatedEvents' => '<p>A list of CloudTrail event IDs.</p> <p>A populated field indicates that the current configuration was initiated by the events recorded in the CloudTrail log. For more information about CloudTrail, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/what_is_cloud_trail_top_level.html">What Is CloudTrail</a>.</p> <p>An empty field indicates that the current configuration was not initiated by any event. As of Version 1.3, the relatedEvents field is empty. You can access the <a href="https://docs.aws.amazon.com/awscloudtrail/latest/APIReference/API_LookupEvents.html">LookupEvents API</a> in the <i>CloudTrail API Reference</i> to retrieve the events for the resource.</p>', ], ], 'Relationship' => [ 'base' => '<p>The relationship of the related resource to the main resource.</p>', 'refs' => [ 'RelationshipList$member' => NULL, ], ], 'RelationshipList' => [ 'base' => NULL, 'refs' => [ 'ConfigurationItem$relationships' => '<p>A list of related Amazon Web Services resources.</p>', ], ], 'RelationshipName' => [ 'base' => NULL, 'refs' => [ 'Relationship$relationshipName' => '<p>The type of relationship with the related resource.</p>', ], ], 'RemediationConfiguration' => [ 'base' => '<p>An object that represents the details about the remediation configuration that includes the remediation action, parameters, and data to execute the action.</p>', 'refs' => [ 'RemediationConfigurations$member' => NULL, ], ], 'RemediationConfigurations' => [ 'base' => NULL, 'refs' => [ 'DescribeRemediationConfigurationsResponse$RemediationConfigurations' => '<p>Returns a remediation configuration object.</p>', 'FailedRemediationBatch$FailedItems' => '<p>Returns remediation configurations of the failed items.</p>', 'PutRemediationConfigurationsRequest$RemediationConfigurations' => '<p>A list of remediation configuration objects.</p>', ], ], 'RemediationException' => [ 'base' => '<p>An object that represents the details about the remediation exception. The details include the rule name, an explanation of an exception, the time when the exception will be deleted, the resource ID, and resource type. </p>', 'refs' => [ 'RemediationExceptions$member' => NULL, ], ], 'RemediationExceptionResourceKey' => [ 'base' => '<p>The details that identify a resource within Config, including the resource type and resource ID. </p>', 'refs' => [ 'RemediationExceptionResourceKeys$member' => NULL, ], ], 'RemediationExceptionResourceKeys' => [ 'base' => NULL, 'refs' => [ 'DeleteRemediationExceptionsRequest$ResourceKeys' => '<p>An exception list of resource exception keys to be processed with the current request. Config adds exception for each resource key. For example, Config adds 3 exceptions for 3 resource keys. </p>', 'DescribeRemediationExceptionsRequest$ResourceKeys' => '<p>An exception list of resource exception keys to be processed with the current request. Config adds exception for each resource key. For example, Config adds 3 exceptions for 3 resource keys. </p>', 'FailedDeleteRemediationExceptionsBatch$FailedItems' => '<p>Returns remediation exception resource key object of the failed items.</p>', 'PutRemediationExceptionsRequest$ResourceKeys' => '<p>An exception list of resource exception keys to be processed with the current request. Config adds exception for each resource key. For example, Config adds 3 exceptions for 3 resource keys. </p>', ], ], 'RemediationExceptions' => [ 'base' => NULL, 'refs' => [ 'DescribeRemediationExceptionsResponse$RemediationExceptions' => '<p>Returns a list of remediation exception objects.</p>', 'FailedRemediationExceptionBatch$FailedItems' => '<p>Returns remediation exception resource key object of the failed items.</p>', ], ], 'RemediationExecutionState' => [ 'base' => NULL, 'refs' => [ 'RemediationExecutionStatus$State' => '<p>ENUM of the values.</p>', ], ], 'RemediationExecutionStatus' => [ 'base' => '<p>Provides details of the current status of the invoked remediation action for that resource.</p>', 'refs' => [ 'RemediationExecutionStatuses$member' => NULL, ], ], 'RemediationExecutionStatuses' => [ 'base' => NULL, 'refs' => [ 'DescribeRemediationExecutionStatusResponse$RemediationExecutionStatuses' => '<p>Returns a list of remediation execution statuses objects.</p>', ], ], 'RemediationExecutionStep' => [ 'base' => '<p>Name of the step from the SSM document.</p>', 'refs' => [ 'RemediationExecutionSteps$member' => NULL, ], ], 'RemediationExecutionStepState' => [ 'base' => NULL, 'refs' => [ 'RemediationExecutionStep$State' => '<p>The valid status of the step.</p>', ], ], 'RemediationExecutionSteps' => [ 'base' => NULL, 'refs' => [ 'RemediationExecutionStatus$StepDetails' => '<p>Details of every step.</p>', ], ], 'RemediationInProgressException' => [ 'base' => '<p>Remediation action is in progress. You can either cancel execution in Amazon Web Services Systems Manager or wait and try again later. </p>', 'refs' => [], ], 'RemediationParameterValue' => [ 'base' => '<p>The value is either a dynamic (resource) value or a static value. You must select either a dynamic value or a static value.</p>', 'refs' => [ 'RemediationParameters$value' => NULL, ], ], 'RemediationParameters' => [ 'base' => NULL, 'refs' => [ 'RemediationConfiguration$Parameters' => '<p>An object of the RemediationParameterValue.</p>', ], ], 'RemediationTargetType' => [ 'base' => NULL, 'refs' => [ 'RemediationConfiguration$TargetType' => '<p>The type of the target. Target executes remediation. For example, SSM document.</p>', ], ], 'ResourceConcurrentModificationException' => [ 'base' => '<p>Two users are trying to modify the same query at the same time. Wait for a moment and try again.</p>', 'refs' => [], ], 'ResourceCount' => [ 'base' => '<p>An object that contains the resource type and the number of resources.</p>', 'refs' => [ 'ResourceCounts$member' => NULL, ], ], 'ResourceCountFilters' => [ 'base' => '<p>Filters the resource count based on account ID, region, and resource type.</p>', 'refs' => [ 'GetAggregateDiscoveredResourceCountsRequest$Filters' => '<p>Filters the results based on the <code>ResourceCountFilters</code> object.</p>', ], ], 'ResourceCountGroupKey' => [ 'base' => NULL, 'refs' => [ 'GetAggregateDiscoveredResourceCountsRequest$GroupByKey' => '<p>The key to group the resource counts.</p>', ], ], 'ResourceCounts' => [ 'base' => NULL, 'refs' => [ 'GetDiscoveredResourceCountsResponse$resourceCounts' => '<p>The list of <code>ResourceCount</code> objects. Each object is listed in descending order by the number of resources.</p>', ], ], 'ResourceCreationTime' => [ 'base' => NULL, 'refs' => [ 'BaseConfigurationItem$resourceCreationTime' => '<p>The time stamp when the resource was created.</p>', 'ConfigurationItem$resourceCreationTime' => '<p>The time stamp when the resource was created.</p>', ], ], 'ResourceDeletionTime' => [ 'base' => NULL, 'refs' => [ 'ResourceIdentifier$resourceDeletionTime' => '<p>The time that the resource was deleted.</p>', ], ], 'ResourceFilters' => [ 'base' => '<p>Filters the results by resource account ID, region, resource ID, and resource name.</p>', 'refs' => [ 'ListAggregateDiscoveredResourcesRequest$Filters' => '<p>Filters the results based on the <code>ResourceFilters</code> object.</p>', ], ], 'ResourceId' => [ 'base' => NULL, 'refs' => [ 'AggregateResourceIdentifier$ResourceId' => '<p>The ID of the Amazon Web Services resource.</p>', 'BaseConfigurationItem$resourceId' => '<p>The ID of the resource (for example., sg-xxxxxx).</p>', 'ConfigurationItem$resourceId' => '<p>The ID of the resource (for example, <code>sg-xxxxxx</code>).</p>', 'DeleteResourceConfigRequest$ResourceId' => '<p>Unique identifier of the resource.</p>', 'GetResourceConfigHistoryRequest$resourceId' => '<p>The ID of the resource (for example., <code>sg-xxxxxx</code>).</p>', 'PutResourceConfigRequest$ResourceId' => '<p>Unique identifier of the resource.</p>', 'Relationship$resourceId' => '<p>The ID of the related resource (for example, <code>sg-xxxxxx</code>).</p>', 'ResourceFilters$ResourceId' => '<p>The ID of the resource.</p>', 'ResourceIdList$member' => NULL, 'ResourceIdentifier$resourceId' => '<p>The ID of the resource (for example, <code>sg-xxxxxx</code>).</p>', 'ResourceKey$resourceId' => '<p>The ID of the resource (for example., sg-xxxxxx). </p>', ], ], 'ResourceIdList' => [ 'base' => NULL, 'refs' => [ 'ListDiscoveredResourcesRequest$resourceIds' => '<p>The IDs of only those resources that you want Config to list in the response. If you do not specify this parameter, Config lists all resources of the specified type that it has discovered.</p>', ], ], 'ResourceIdentifier' => [ 'base' => '<p>The details that identify a resource that is discovered by Config, including the resource type, ID, and (if available) the custom resource name.</p>', 'refs' => [ 'ResourceIdentifierList$member' => NULL, ], ], 'ResourceIdentifierList' => [ 'base' => NULL, 'refs' => [ 'ListDiscoveredResourcesResponse$resourceIdentifiers' => '<p>The details that identify a resource that is discovered by Config, including the resource type, ID, and (if available) the custom resource name.</p>', ], ], 'ResourceIdentifiersList' => [ 'base' => NULL, 'refs' => [ 'BatchGetAggregateResourceConfigRequest$ResourceIdentifiers' => '<p>A list of aggregate ResourceIdentifiers objects. </p>', ], ], 'ResourceInUseException' => [ 'base' => '<p>You see this exception in the following cases: </p> <ul> <li> <p>For DeleteConfigRule, Config is deleting this rule. Try your request again later.</p> </li> <li> <p>For DeleteConfigRule, the rule is deleting your evaluation results. Try your request again later.</p> </li> <li> <p>For DeleteConfigRule, a remediation action is associated with the rule and Config cannot delete this rule. Delete the remediation action associated with the rule before deleting the rule and try your request again later.</p> </li> <li> <p>For PutConfigOrganizationRule, organization Config rule deletion is in progress. Try your request again later.</p> </li> <li> <p>For DeleteOrganizationConfigRule, organization Config rule creation is in progress. Try your request again later.</p> </li> <li> <p>For PutConformancePack and PutOrganizationConformancePack, a conformance pack creation, update, and deletion is in progress. Try your request again later.</p> </li> <li> <p>For DeleteConformancePack, a conformance pack creation, update, and deletion is in progress. Try your request again later.</p> </li> </ul>', 'refs' => [], ], 'ResourceKey' => [ 'base' => '<p>The details that identify a resource within Config, including the resource type and resource ID.</p>', 'refs' => [ 'RemediationExecutionStatus$ResourceKey' => NULL, 'ResourceKeys$member' => NULL, ], ], 'ResourceKeys' => [ 'base' => NULL, 'refs' => [ 'BatchGetResourceConfigRequest$resourceKeys' => '<p>A list of resource keys to be processed with the current request. Each element in the list consists of the resource type and resource ID.</p>', 'BatchGetResourceConfigResponse$unprocessedResourceKeys' => '<p>A list of resource keys that were not processed with the current response. The unprocessesResourceKeys value is in the same form as ResourceKeys, so the value can be directly provided to a subsequent BatchGetResourceConfig operation. If there are no unprocessed resource keys, the response contains an empty unprocessedResourceKeys list. </p>', 'DescribeRemediationExecutionStatusRequest$ResourceKeys' => '<p>A list of resource keys to be processed with the current request. Each element in the list consists of the resource type and resource ID. </p>', 'StartRemediationExecutionRequest$ResourceKeys' => '<p>A list of resource keys to be processed with the current request. Each element in the list consists of the resource type and resource ID. </p>', 'StartRemediationExecutionResponse$FailedItems' => '<p>For resources that have failed to start execution, the API returns a resource key object.</p>', ], ], 'ResourceName' => [ 'base' => NULL, 'refs' => [ 'AggregateResourceIdentifier$ResourceName' => '<p>The name of the Amazon Web Services resource.</p>', 'BaseConfigurationItem$resourceName' => '<p>The custom name of the resource, if available.</p>', 'ConfigurationItem$resourceName' => '<p>The custom name of the resource, if available.</p>', 'ListDiscoveredResourcesRequest$resourceName' => '<p>The custom name of only those resources that you want Config to list in the response. If you do not specify this parameter, Config lists all resources of the specified type that it has discovered.</p>', 'PutResourceConfigRequest$ResourceName' => '<p>Name of the resource.</p>', 'Relationship$resourceName' => '<p>The custom name of the related resource, if available.</p>', 'ResourceFilters$ResourceName' => '<p>The name of the resource.</p>', 'ResourceIdentifier$resourceName' => '<p>The custom name of the resource (if available).</p>', ], ], 'ResourceNotDiscoveredException' => [ 'base' => '<p>You have specified a resource that is either unknown or has not been discovered.</p>', 'refs' => [], ], 'ResourceNotFoundException' => [ 'base' => '<p>You have specified a resource that does not exist.</p>', 'refs' => [], ], 'ResourceType' => [ 'base' => NULL, 'refs' => [ 'AggregateResourceIdentifier$ResourceType' => '<p>The type of the Amazon Web Services resource.</p>', 'BaseConfigurationItem$resourceType' => '<p>The type of Amazon Web Services resource.</p>', 'ConfigurationItem$resourceType' => '<p>The type of Amazon Web Services resource.</p>', 'GetResourceConfigHistoryRequest$resourceType' => '<p>The resource type.</p>', 'ListAggregateDiscoveredResourcesRequest$ResourceType' => '<p>The type of resources that you want Config to list in the response.</p>', 'ListDiscoveredResourcesRequest$resourceType' => '<p>The type of resources that you want Config to list in the response.</p>', 'Relationship$resourceType' => '<p>The resource type of the related resource.</p>', 'ResourceCount$resourceType' => '<p>The resource type (for example, <code>"AWS::EC2::Instance"</code>).</p>', 'ResourceCountFilters$ResourceType' => '<p>The type of the Amazon Web Services resource.</p>', 'ResourceIdentifier$resourceType' => '<p>The type of resource.</p>', 'ResourceKey$resourceType' => '<p>The resource type.</p>', 'ResourceTypeList$member' => NULL, ], ], 'ResourceTypeList' => [ 'base' => NULL, 'refs' => [ 'RecordingGroup$resourceTypes' => '<p>A comma-separated list that specifies the types of Amazon Web Services resources for which Config records configuration changes (for example, <code>AWS::EC2::Instance</code> or <code>AWS::CloudTrail::Trail</code>).</p> <p>To record all configuration changes, you must set the <code>allSupported</code> option to <code>true</code>.</p> <p>If you set this option to <code>false</code>, when Config adds support for a new type of resource, it will not record resources of that type unless you manually add that type to your recording group.</p> <p>For a list of valid <code>resourceTypes</code> values, see the <b>resourceType Value</b> column in <a href="https://docs.aws.amazon.com/config/latest/developerguide/resource-config-reference.html#supported-resources">Supported Amazon Web Services resource Types</a>.</p>', ], ], 'ResourceTypeString' => [ 'base' => NULL, 'refs' => [ 'DeleteResourceConfigRequest$ResourceType' => '<p>The type of the resource.</p>', 'PutResourceConfigRequest$ResourceType' => '<p>The type of the resource. The custom resource type must be registered with CloudFormation. </p> <note> <p>You cannot use the organization names “amzn”, “amazon”, “alexa”, “custom” with custom resource types. It is the first part of the ResourceType up to the first ::.</p> </note>', ], ], 'ResourceTypes' => [ 'base' => NULL, 'refs' => [ 'GetComplianceSummaryByResourceTypeRequest$ResourceTypes' => '<p>Specify one or more resource types to get the number of resources that are compliant and the number that are noncompliant for each resource type.</p> <p>For this request, you can specify an Amazon Web Services resource type such as <code>AWS::EC2::Instance</code>. You can specify that the resource type is an Amazon Web Services account by specifying <code>AWS::::Account</code>.</p>', 'GetDiscoveredResourceCountsRequest$resourceTypes' => '<p>The comma-separated list that specifies the resource types that you want Config to return (for example, <code>"AWS::EC2::Instance"</code>, <code>"AWS::IAM::User"</code>).</p> <p>If a value for <code>resourceTypes</code> is not specified, Config returns all resource types that Config is recording in the region for your account.</p> <note> <p>If the configuration recorder is turned off, Config returns an empty list of <a>ResourceCount</a> objects. If the configuration recorder is not recording a specific resource type (for example, S3 buckets), that resource type is not returned in the list of <a>ResourceCount</a> objects.</p> </note>', ], ], 'ResourceTypesScope' => [ 'base' => NULL, 'refs' => [ 'OrganizationCustomPolicyRuleMetadata$ResourceTypesScope' => '<p>The type of the Amazon Web Services resource that was evaluated.</p>', 'OrganizationCustomPolicyRuleMetadataNoPolicy$ResourceTypesScope' => '<p>The type of the Amazon Web Services resource that was evaluated.</p>', 'OrganizationCustomRuleMetadata$ResourceTypesScope' => '<p>The type of the Amazon Web Services resource that was evaluated.</p>', 'OrganizationManagedRuleMetadata$ResourceTypesScope' => '<p>The type of the Amazon Web Services resource that was evaluated.</p>', ], ], 'ResourceValue' => [ 'base' => '<p>The dynamic value of the resource.</p>', 'refs' => [ 'RemediationParameterValue$ResourceValue' => '<p>The value is dynamic and changes at run-time.</p>', ], ], 'ResourceValueType' => [ 'base' => NULL, 'refs' => [ 'ResourceValue$Value' => '<p>The value is a resource ID.</p>', ], ], 'Results' => [ 'base' => NULL, 'refs' => [ 'SelectAggregateResourceConfigResponse$Results' => '<p>Returns the results for the SQL query.</p>', 'SelectResourceConfigResponse$Results' => '<p>Returns the results for the SQL query.</p>', ], ], 'RetentionConfiguration' => [ 'base' => '<p>An object with the name of the retention configuration and the retention period in days. The object stores the configuration for data retention in Config.</p>', 'refs' => [ 'PutRetentionConfigurationResponse$RetentionConfiguration' => '<p>Returns a retention configuration object.</p>', 'RetentionConfigurationList$member' => NULL, ], ], 'RetentionConfigurationList' => [ 'base' => NULL, 'refs' => [ 'DescribeRetentionConfigurationsResponse$RetentionConfigurations' => '<p>Returns a retention configuration object.</p>', ], ], 'RetentionConfigurationName' => [ 'base' => NULL, 'refs' => [ 'DeleteRetentionConfigurationRequest$RetentionConfigurationName' => '<p>The name of the retention configuration to delete.</p>', 'RetentionConfiguration$Name' => '<p>The name of the retention configuration object.</p>', 'RetentionConfigurationNameList$member' => NULL, ], ], 'RetentionConfigurationNameList' => [ 'base' => NULL, 'refs' => [ 'DescribeRetentionConfigurationsRequest$RetentionConfigurationNames' => '<p>A list of names of retention configurations for which you want details. If you do not specify a name, Config returns details for all the retention configurations for that account.</p> <note> <p>Currently, Config supports only one retention configuration per region in your account.</p> </note>', ], ], 'RetentionPeriodInDays' => [ 'base' => NULL, 'refs' => [ 'PutRetentionConfigurationRequest$RetentionPeriodInDays' => '<p>Number of days Config stores your historical information.</p> <note> <p>Currently, only applicable to the configuration item history.</p> </note>', 'RetentionConfiguration$RetentionPeriodInDays' => '<p>Number of days Config stores your historical information.</p> <note> <p>Currently, only applicable to the configuration item history.</p> </note>', ], ], 'RuleLimit' => [ 'base' => NULL, 'refs' => [ 'DescribeConfigRuleEvaluationStatusRequest$Limit' => '<p>The number of rule evaluation results that you want returned.</p> <p>This parameter is required if the rule limit for your account is more than the default of 150 rules.</p> <p>For information about requesting a rule limit increase, see <a href="http://docs.aws.amazon.com/general/latest/gr/aws_service_limits.html#limits_config">Config Limits</a> in the <i>Amazon Web Services General Reference Guide</i>.</p>', ], ], 'SchemaVersionId' => [ 'base' => NULL, 'refs' => [ 'PutResourceConfigRequest$SchemaVersionId' => '<p>Version of the schema registered for the ResourceType in CloudFormation.</p>', ], ], 'Scope' => [ 'base' => '<p>Defines which resources trigger an evaluation for an Config rule. The scope can include one or more resource types, a combination of a tag key and value, or a combination of one resource type and one resource ID. Specify a scope to constrain which resources trigger an evaluation for a rule. Otherwise, evaluations for the rule are triggered when any resource in your recording group changes in configuration.</p>', 'refs' => [ 'ConfigRule$Scope' => '<p>Defines which resources can trigger an evaluation for the rule. The scope can include one or more resource types, a combination of one resource type and one resource ID, or a combination of a tag key and value. Specify a scope to constrain the resources that can trigger an evaluation for the rule. If you do not specify a scope, evaluations are triggered when any resource in the recording group changes.</p> <note> <p>The scope can be empty. </p> </note>', ], ], 'SelectAggregateResourceConfigRequest' => [ 'base' => NULL, 'refs' => [], ], 'SelectAggregateResourceConfigResponse' => [ 'base' => NULL, 'refs' => [], ], 'SelectResourceConfigRequest' => [ 'base' => NULL, 'refs' => [], ], 'SelectResourceConfigResponse' => [ 'base' => NULL, 'refs' => [], ], 'Source' => [ 'base' => '<p>Provides the CustomPolicyDetails, the rule owner (Amazon Web Services or customer), the rule identifier, and the events that cause the evaluation of your Amazon Web Services resources.</p>', 'refs' => [ 'ConfigRule$Source' => '<p>Provides the rule owner (Amazon Web Services or customer), the rule identifier, and the notifications that cause the function to evaluate your Amazon Web Services resources.</p>', ], ], 'SourceDetail' => [ 'base' => '<p>Provides the source and the message types that trigger Config to evaluate your Amazon Web Services resources against a rule. It also provides the frequency with which you want Config to run evaluations for the rule if the trigger type is periodic. You can specify the parameter values for <code>SourceDetail</code> only for custom rules. </p>', 'refs' => [ 'SourceDetails$member' => NULL, ], ], 'SourceDetails' => [ 'base' => NULL, 'refs' => [ 'Source$SourceDetails' => '<p>Provides the source and the message types that cause Config to evaluate your Amazon Web Services resources against a rule. It also provides the frequency with which you want Config to run evaluations for the rule if the trigger type is periodic.</p> <p>If the owner is set to <code>CUSTOM_POLICY</code>, the only acceptable values for the Config rule trigger message type are <code>ConfigurationItemChangeNotification</code> and <code>OversizedConfigurationItemChangeNotification</code>.</p>', ], ], 'SsmControls' => [ 'base' => '<p>Amazon Web Services Systems Manager (SSM) specific remediation controls.</p>', 'refs' => [ 'ExecutionControls$SsmControls' => '<p>A SsmControls object.</p>', ], ], 'StackArn' => [ 'base' => NULL, 'refs' => [ 'ConformancePackStatusDetail$StackArn' => '<p>Amazon Resource Name (ARN) of CloudFormation stack. </p>', ], ], 'StartConfigRulesEvaluationRequest' => [ 'base' => '<p/>', 'refs' => [], ], 'StartConfigRulesEvaluationResponse' => [ 'base' => '<p>The output when you start the evaluation for the specified Config rule.</p>', 'refs' => [], ], 'StartConfigurationRecorderRequest' => [ 'base' => '<p>The input for the <a>StartConfigurationRecorder</a> action.</p>', 'refs' => [], ], 'StartRemediationExecutionRequest' => [ 'base' => NULL, 'refs' => [], ], 'StartRemediationExecutionResponse' => [ 'base' => NULL, 'refs' => [], ], 'StaticParameterValues' => [ 'base' => NULL, 'refs' => [ 'StaticValue$Values' => '<p>A list of values. For example, the ARN of the assumed role. </p>', ], ], 'StaticValue' => [ 'base' => '<p>The static value of the resource.</p>', 'refs' => [ 'RemediationParameterValue$StaticValue' => '<p>The value is static and does not change at run-time.</p>', ], ], 'StatusDetailFilters' => [ 'base' => '<p>Status filter object to filter results based on specific member account ID or status type for an organization Config rule. </p>', 'refs' => [ 'GetOrganizationConfigRuleDetailedStatusRequest$Filters' => '<p>A <code>StatusDetailFilters</code> object.</p>', ], ], 'StopConfigurationRecorderRequest' => [ 'base' => '<p>The input for the <a>StopConfigurationRecorder</a> action.</p>', 'refs' => [], ], 'StoredQuery' => [ 'base' => '<p>Provides the details of a stored query.</p>', 'refs' => [ 'GetStoredQueryResponse$StoredQuery' => '<p>Returns a <code>StoredQuery</code> object.</p>', 'PutStoredQueryRequest$StoredQuery' => '<p>A list of <code>StoredQuery</code> objects. The mandatory fields are <code>QueryName</code> and <code>Expression</code>.</p> <note> <p>When you are creating a query, you must provide a query name and an expression. When you are updating a query, you must provide a query name but updating the description is optional.</p> </note>', ], ], 'StoredQueryMetadata' => [ 'base' => '<p>Returns details of a specific query. </p>', 'refs' => [ 'StoredQueryMetadataList$member' => NULL, ], ], 'StoredQueryMetadataList' => [ 'base' => NULL, 'refs' => [ 'ListStoredQueriesResponse$StoredQueryMetadata' => '<p>A list of <code>StoredQueryMetadata</code> objects.</p>', ], ], 'String' => [ 'base' => NULL, 'refs' => [ 'AggregatedSourceStatus$SourceId' => '<p>The source account ID or an organization.</p>', 'AggregatedSourceStatus$LastErrorCode' => '<p>The error code that Config returned when the source account aggregation last failed.</p>', 'AggregatedSourceStatus$LastErrorMessage' => '<p>The message indicating that the source account aggregation failed due to an error.</p>', 'AggregationAuthorization$AggregationAuthorizationArn' => '<p>The Amazon Resource Name (ARN) of the aggregation object.</p>', 'AggregatorRegionList$member' => NULL, 'ConfigExportDeliveryInfo$lastErrorCode' => '<p>The error code from the last attempted delivery.</p>', 'ConfigExportDeliveryInfo$lastErrorMessage' => '<p>The error message from the last attempted delivery.</p>', 'ConfigRuleEvaluationStatus$ConfigRuleArn' => '<p>The Amazon Resource Name (ARN) of the Config rule.</p>', 'ConfigRuleEvaluationStatus$ConfigRuleId' => '<p>The ID of the Config rule.</p>', 'ConfigRuleEvaluationStatus$LastErrorCode' => '<p>The error code that Config returned when the rule last failed.</p>', 'ConfigRuleEvaluationStatus$LastErrorMessage' => '<p>The error message that Config returned when the rule last failed.</p>', 'ConfigRuleEvaluationStatus$LastDebugLogDeliveryStatus' => '<p>The status of the last attempted delivery of a debug log for your Config Custom Policy rules. Either <code>Successful</code> or <code>Failed</code>.</p>', 'ConfigRuleEvaluationStatus$LastDebugLogDeliveryStatusReason' => '<p>The reason Config was not able to deliver a debug log. This is for the last failed attempt to retrieve a debug log for your Config Custom Policy rules.</p>', 'ConfigStreamDeliveryInfo$lastErrorCode' => '<p>The error code from the last attempted delivery.</p>', 'ConfigStreamDeliveryInfo$lastErrorMessage' => '<p>The error message from the last attempted delivery.</p>', 'ConfigurationRecorder$roleARN' => '<p>Amazon Resource Name (ARN) of the IAM role used to describe the Amazon Web Services resources associated with the account.</p>', 'ConfigurationRecorderStatus$name' => '<p>The name of the configuration recorder.</p>', 'ConfigurationRecorderStatus$lastErrorCode' => '<p>The error code indicating that the recording failed.</p>', 'ConfigurationRecorderStatus$lastErrorMessage' => '<p>The message indicating that the recording failed due to an error.</p>', 'DeleteRemediationConfigurationRequest$ResourceType' => '<p>The type of a resource.</p>', 'DeliverConfigSnapshotResponse$configSnapshotId' => '<p>The ID of the snapshot that is being created.</p>', 'DeliveryChannel$s3BucketName' => '<p>The name of the Amazon S3 bucket to which Config delivers configuration snapshots and configuration history files.</p> <p>If you specify a bucket that belongs to another Amazon Web Services account, that bucket must have policies that grant access permissions to Config. For more information, see <a href="https://docs.aws.amazon.com/config/latest/developerguide/s3-bucket-policy.html">Permissions for the Amazon S3 Bucket</a> in the Config Developer Guide.</p>', 'DeliveryChannel$s3KeyPrefix' => '<p>The prefix for the specified Amazon S3 bucket.</p>', 'DeliveryChannel$s3KmsKeyArn' => '<p>The Amazon Resource Name (ARN) of the Key Management Service (KMS ) KMS key (KMS key) used to encrypt objects delivered by Config. Must belong to the same Region as the destination S3 bucket.</p>', 'DeliveryChannel$snsTopicARN' => '<p>The Amazon Resource Name (ARN) of the Amazon SNS topic to which Config sends notifications about configuration changes.</p> <p>If you choose a topic from another account, the topic must have policies that grant access permissions to Config. For more information, see <a href="https://docs.aws.amazon.com/config/latest/developerguide/sns-topic-policy.html">Permissions for the Amazon SNS Topic</a> in the Config Developer Guide.</p>', 'DeliveryChannelStatus$name' => '<p>The name of the delivery channel.</p>', 'DescribeAggregationAuthorizationsRequest$NextToken' => '<p>The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a paginated response.</p>', 'DescribeAggregationAuthorizationsResponse$NextToken' => '<p>The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a paginated response.</p>', 'DescribeComplianceByConfigRuleRequest$NextToken' => '<p>The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a paginated response.</p>', 'DescribeComplianceByConfigRuleResponse$NextToken' => '<p>The string that you use in a subsequent request to get the next page of results in a paginated response.</p>', 'DescribeConfigRuleEvaluationStatusRequest$NextToken' => '<p>The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a paginated response.</p>', 'DescribeConfigRuleEvaluationStatusResponse$NextToken' => '<p>The string that you use in a subsequent request to get the next page of results in a paginated response.</p>', 'DescribeConfigRulesRequest$NextToken' => '<p>The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a paginated response.</p>', 'DescribeConfigRulesResponse$NextToken' => '<p>The string that you use in a subsequent request to get the next page of results in a paginated response.</p>', 'DescribeConfigurationAggregatorSourcesStatusRequest$NextToken' => '<p>The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a paginated response.</p>', 'DescribeConfigurationAggregatorSourcesStatusResponse$NextToken' => '<p>The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a paginated response.</p>', 'DescribeConfigurationAggregatorsRequest$NextToken' => '<p>The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a paginated response.</p>', 'DescribeConfigurationAggregatorsResponse$NextToken' => '<p>The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a paginated response.</p>', 'DescribeOrganizationConfigRuleStatusesRequest$NextToken' => '<p>The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a paginated response. </p>', 'DescribeOrganizationConfigRuleStatusesResponse$NextToken' => '<p>The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a paginated response. </p>', 'DescribeOrganizationConfigRulesRequest$NextToken' => '<p>The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a paginated response. </p>', 'DescribeOrganizationConfigRulesResponse$NextToken' => '<p>The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a paginated response. </p>', 'DescribeOrganizationConformancePackStatusesRequest$NextToken' => '<p>The nextToken string returned on a previous page that you use to get the next page of results in a paginated response. </p>', 'DescribeOrganizationConformancePackStatusesResponse$NextToken' => '<p>The nextToken string returned on a previous page that you use to get the next page of results in a paginated response. </p>', 'DescribeOrganizationConformancePacksRequest$NextToken' => '<p>The nextToken string returned on a previous page that you use to get the next page of results in a paginated response.</p>', 'DescribeOrganizationConformancePacksResponse$NextToken' => '<p>The nextToken string returned on a previous page that you use to get the next page of results in a paginated response.</p>', 'DescribePendingAggregationRequestsRequest$NextToken' => '<p>The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a paginated response.</p>', 'DescribePendingAggregationRequestsResponse$NextToken' => '<p>The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a paginated response.</p>', 'DescribeRemediationExceptionsRequest$NextToken' => '<p>The <code>nextToken</code> string returned in a previous request that you use to request the next page of results in a paginated response.</p>', 'DescribeRemediationExceptionsResponse$NextToken' => '<p>The <code>nextToken</code> string returned in a previous request that you use to request the next page of results in a paginated response.</p>', 'DescribeRemediationExecutionStatusRequest$NextToken' => '<p>The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a paginated response.</p>', 'DescribeRemediationExecutionStatusResponse$NextToken' => '<p>The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a paginated response.</p>', 'EvaluationResult$ResultToken' => '<p>An encrypted token that associates an evaluation with an Config rule. The token identifies the rule, the Amazon Web Services resource being evaluated, and the event that triggered the evaluation.</p>', 'FailedDeleteRemediationExceptionsBatch$FailureMessage' => '<p>Returns a failure message for delete remediation exception. For example, Config creates an exception due to an internal error.</p>', 'FailedRemediationBatch$FailureMessage' => '<p>Returns a failure message. For example, the resource is already compliant.</p>', 'FailedRemediationExceptionBatch$FailureMessage' => '<p>Returns a failure message. For example, the auto-remediation has failed.</p>', 'GetComplianceDetailsByResourceRequest$NextToken' => '<p>The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a paginated response.</p>', 'GetComplianceDetailsByResourceResponse$NextToken' => '<p>The string that you use in a subsequent request to get the next page of results in a paginated response.</p>', 'GetOrganizationConfigRuleDetailedStatusRequest$NextToken' => '<p>The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a paginated response. </p>', 'GetOrganizationConfigRuleDetailedStatusResponse$NextToken' => '<p>The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a paginated response. </p>', 'GetOrganizationConformancePackDetailedStatusRequest$NextToken' => '<p>The nextToken string returned on a previous page that you use to get the next page of results in a paginated response. </p>', 'GetOrganizationConformancePackDetailedStatusResponse$NextToken' => '<p>The nextToken string returned on a previous page that you use to get the next page of results in a paginated response. </p>', 'ListStoredQueriesRequest$NextToken' => '<p>The nextToken string returned in a previous request that you use to request the next page of results in a paginated response.</p>', 'ListStoredQueriesResponse$NextToken' => '<p>If the previous paginated request didn\'t return all of the remaining results, the response object\'s <code>NextToken</code> parameter value is set to a token. To retrieve the next set of results, call this action again and assign that token to the request object\'s <code>NextToken</code> parameter. If there are no remaining results, the previous response object\'s <code>NextToken</code> parameter is set to <code>null</code>. </p>', 'MemberAccountStatus$ErrorCode' => '<p>An error code that is returned when Config rule creation or deletion failed in the member account.</p>', 'MemberAccountStatus$ErrorMessage' => '<p>An error message indicating that Config rule account creation or deletion has failed due to an error in the member account.</p>', 'OrganizationAggregationSource$RoleArn' => '<p>ARN of the IAM role used to retrieve Amazon Web Services Organization details associated with the aggregator account.</p>', 'OrganizationConfigRuleStatus$ErrorCode' => '<p>An error code that is returned when organization Config rule creation or deletion has failed.</p>', 'OrganizationConfigRuleStatus$ErrorMessage' => '<p>An error message indicating that organization Config rule creation or deletion failed due to an error.</p>', 'OrganizationConformancePackDetailedStatus$ErrorCode' => '<p>An error code that is returned when conformance pack creation or deletion failed in the member account. </p>', 'OrganizationConformancePackDetailedStatus$ErrorMessage' => '<p>An error message indicating that conformance pack account creation or deletion has failed due to an error in the member account. </p>', 'OrganizationConformancePackStatus$ErrorCode' => '<p>An error code that is returned when organization conformance pack creation or deletion has failed in a member account. </p>', 'OrganizationConformancePackStatus$ErrorMessage' => '<p>An error message indicating that organization conformance pack creation or deletion failed due to an error. </p>', 'PutEvaluationsRequest$ResultToken' => '<p>An encrypted token that associates an evaluation with an Config rule. Identifies the rule and the event that triggered the evaluation.</p>', 'RemediationConfiguration$TargetVersion' => '<p>Version of the target. For example, version of the SSM document.</p> <note> <p>If you make backward incompatible changes to the SSM document, you must call PutRemediationConfiguration API again to ensure the remediations can run.</p> </note>', 'RemediationConfiguration$ResourceType' => '<p>The type of a resource. </p>', 'RemediationExecutionStep$Name' => '<p>The details of the step.</p>', 'RemediationExecutionStep$ErrorMessage' => '<p>An error message if the step was interrupted during execution.</p>', 'Results$member' => NULL, 'StartRemediationExecutionResponse$FailureMessage' => '<p>Returns a failure message. For example, the resource is already compliant.</p>', ], ], 'StringWithCharLimit1024' => [ 'base' => NULL, 'refs' => [ 'ConfigRule$InputParameters' => '<p>A string, in JSON format, that is passed to the Config rule Lambda function.</p>', 'PutRemediationExceptionsRequest$Message' => '<p>The message contains an explanation of the exception.</p>', 'RemediationConfiguration$Arn' => '<p>Amazon Resource Name (ARN) of remediation configuration.</p>', 'RemediationConfiguration$CreatedByService' => '<p>Name of the service that owns the service linked rule, if applicable.</p>', 'RemediationException$ResourceId' => '<p>The ID of the resource (for example., sg-xxxxxx).</p>', 'RemediationException$Message' => '<p>An explanation of an remediation exception.</p>', 'RemediationExceptionResourceKey$ResourceId' => '<p>The ID of the resource (for example., sg-xxxxxx).</p>', ], ], 'StringWithCharLimit128' => [ 'base' => NULL, 'refs' => [ 'ControlsList$member' => NULL, 'OrganizationCustomPolicyRuleMetadata$TagKeyScope' => '<p>One part of a key-value pair that make up a tag. A key is a general label that acts like a category for more specific tag values.</p>', 'OrganizationCustomPolicyRuleMetadataNoPolicy$TagKeyScope' => '<p>One part of a key-value pair that make up a tag. A key is a general label that acts like a category for more specific tag values.</p>', 'OrganizationCustomRuleMetadata$TagKeyScope' => '<p>One part of a key-value pair that make up a tag. A key is a general label that acts like a category for more specific tag values. </p>', 'OrganizationManagedRuleMetadata$TagKeyScope' => '<p>One part of a key-value pair that make up a tag. A key is a general label that acts like a category for more specific tag values. </p>', 'Scope$TagKey' => '<p>The tag key that is applied to only those Amazon Web Services resources that you want to trigger an evaluation for the rule.</p>', ], ], 'StringWithCharLimit2048' => [ 'base' => NULL, 'refs' => [ 'OrganizationCustomPolicyRuleMetadata$InputParameters' => '<p>A string, in JSON format, that is passed to your organization Config Custom Policy rule.</p>', 'OrganizationCustomPolicyRuleMetadataNoPolicy$InputParameters' => '<p>A string, in JSON format, that is passed to your organization Config Custom Policy rule.</p>', 'OrganizationCustomRuleMetadata$InputParameters' => '<p>A string, in JSON format, that is passed to your organization Config rule Lambda function.</p>', 'OrganizationManagedRuleMetadata$InputParameters' => '<p>A string, in JSON format, that is passed to your organization Config rule Lambda function.</p>', ], ], 'StringWithCharLimit256' => [ 'base' => NULL, 'refs' => [ 'AggregateComplianceCount$GroupName' => '<p>The 12-digit account ID or region based on the GroupByKey value.</p>', 'AggregateConformancePackComplianceSummary$GroupName' => '<p>Groups the result based on Amazon Web Services account ID or Amazon Web Services Region.</p>', 'AggregateEvaluationResult$Annotation' => '<p>Supplementary information about how the agrregate evaluation determined the compliance.</p>', 'ComplianceByResource$ResourceType' => '<p>The type of the Amazon Web Services resource that was evaluated.</p>', 'ComplianceResourceTypes$member' => NULL, 'ComplianceSummaryByResourceType$ResourceType' => '<p>The type of Amazon Web Services resource.</p>', 'ConfigRule$ConfigRuleArn' => '<p>The Amazon Resource Name (ARN) of the Config rule.</p>', 'ConfigRule$CreatedBy' => '<p>Service principal name of the service that created the rule.</p> <note> <p>The field is populated only if the service linked rule is created by a service. The field is empty if you create your own rule.</p> </note>', 'ConfigurationAggregator$CreatedBy' => '<p>Amazon Web Services service that created the configuration aggregator.</p>', 'ConformancePackComplianceResourceIds$member' => NULL, 'ConformancePackDetail$CreatedBy' => '<p>Amazon Web Services service that created the conformance pack.</p>', 'ConformancePackEvaluationFilters$ResourceType' => '<p>Filters the results by the resource type (for example, <code>"AWS::EC2::Instance"</code>). </p>', 'DescribeComplianceByResourceRequest$ResourceType' => '<p>The types of Amazon Web Services resources for which you want compliance information (for example, <code>AWS::EC2::Instance</code>). For this action, you can specify that the resource type is an Amazon Web Services account by specifying <code>AWS::::Account</code>.</p>', 'Evaluation$ComplianceResourceType' => '<p>The type of Amazon Web Services resource that was evaluated.</p>', 'Evaluation$Annotation' => '<p>Supplementary information about how the evaluation determined the compliance.</p>', 'EvaluationResult$Annotation' => '<p>Supplementary information about how the evaluation determined the compliance.</p>', 'EvaluationResultQualifier$ResourceType' => '<p>The type of Amazon Web Services resource that was evaluated.</p>', 'ExternalEvaluation$ComplianceResourceType' => '<p>The evaluated compliance resource type. Config accepts <code>AWS::::Account</code> resource type.</p>', 'ExternalEvaluation$Annotation' => '<p>Supplementary information about the reason of compliance. For example, this task was completed on a specific date.</p>', 'GetAggregateConfigRuleComplianceSummaryResponse$GroupByKey' => '<p>Groups the result based on ACCOUNT_ID or AWS_REGION.</p>', 'GetAggregateConformancePackComplianceSummaryResponse$GroupByKey' => '<p>Groups the result based on Amazon Web Services account ID or Amazon Web Services Region.</p>', 'GetAggregateDiscoveredResourceCountsResponse$GroupByKey' => '<p>The key passed into the request object. If <code>GroupByKey</code> is not provided, the result will be empty.</p>', 'GetComplianceDetailsByResourceRequest$ResourceType' => '<p>The type of the Amazon Web Services resource for which you want compliance information.</p>', 'GroupedResourceCount$GroupName' => '<p>The name of the group that can be region, account ID, or resource type. For example, region1, region2 if the region was chosen as <code>GroupByKey</code>.</p>', 'OrganizationConfigRule$OrganizationConfigRuleArn' => '<p>Amazon Resource Name (ARN) of organization Config rule.</p>', 'OrganizationConformancePack$OrganizationConformancePackArn' => '<p>Amazon Resource Name (ARN) of organization conformance pack.</p>', 'OrganizationConformancePackDetailedStatus$ConformancePackName' => '<p>The name of conformance pack deployed in the member account.</p>', 'OrganizationCustomPolicyRuleMetadata$TagValueScope' => '<p>The optional part of a key-value pair that make up a tag. A value acts as a descriptor within a tag category (key).</p>', 'OrganizationCustomPolicyRuleMetadataNoPolicy$TagValueScope' => '<p>The optional part of a key-value pair that make up a tag. A value acts as a descriptor within a tag category (key).</p>', 'OrganizationCustomRuleMetadata$LambdaFunctionArn' => '<p>The lambda function ARN.</p>', 'OrganizationCustomRuleMetadata$TagValueScope' => '<p>The optional part of a key-value pair that make up a tag. A value acts as a descriptor within a tag category (key). </p>', 'OrganizationManagedRuleMetadata$RuleIdentifier' => '<p>For organization config managed rules, a predefined identifier from a list. For example, <code>IAM_PASSWORD_POLICY</code> is a managed rule. To reference a managed rule, see <a href="https://docs.aws.amazon.com/config/latest/developerguide/evaluate-config_use-managed-rules.html">Using Config managed rules</a>.</p>', 'OrganizationManagedRuleMetadata$TagValueScope' => '<p>The optional part of a key-value pair that make up a tag. A value acts as a descriptor within a tag category (key).</p>', 'PutOrganizationConfigRuleResponse$OrganizationConfigRuleArn' => '<p>The Amazon Resource Name (ARN) of an organization Config rule.</p>', 'PutOrganizationConformancePackResponse$OrganizationConformancePackArn' => '<p>ARN of the organization conformance pack.</p>', 'RemediationConfiguration$TargetId' => '<p>Target ID is the name of the public document.</p>', 'RemediationException$ResourceType' => '<p>The type of a resource.</p>', 'RemediationExceptionResourceKey$ResourceType' => '<p>The type of a resource.</p>', 'RemediationParameters$key' => NULL, 'ResourceTypes$member' => NULL, 'ResourceTypesScope$member' => NULL, 'Scope$TagValue' => '<p>The tag value applied to only those Amazon Web Services resources that you want to trigger an evaluation for the rule. If you specify a value for <code>TagValue</code>, you must also specify a value for <code>TagKey</code>.</p>', 'Source$SourceIdentifier' => '<p>For Config Managed rules, a predefined identifier from a list. For example, <code>IAM_PASSWORD_POLICY</code> is a managed rule. To reference a managed rule, see <a href="https://docs.aws.amazon.com/config/latest/developerguide/managed-rules-by-aws-config.html">List of Config Managed Rules</a>.</p> <p>For Config Custom Lambda rules, the identifier is the Amazon Resource Name (ARN) of the rule\'s Lambda function, such as <code>arn:aws:lambda:us-east-2:123456789012:function:custom_rule_name</code>.</p> <p>For Config Custom Policy rules, this field will be ignored.</p>', 'StaticParameterValues$member' => NULL, ], ], 'StringWithCharLimit256Min0' => [ 'base' => NULL, 'refs' => [ 'OrganizationCustomPolicyRuleMetadata$Description' => '<p>The description that you provide for your organization Config Custom Policy rule.</p>', 'OrganizationCustomPolicyRuleMetadataNoPolicy$Description' => '<p>The description that you provide for your organization Config Custom Policy rule.</p>', 'OrganizationCustomRuleMetadata$Description' => '<p>The description that you provide for your organization Config rule.</p>', 'OrganizationManagedRuleMetadata$Description' => '<p>The description that you provide for your organization Config rule.</p>', ], ], 'StringWithCharLimit64' => [ 'base' => NULL, 'refs' => [ 'ComplianceByConfigRule$ConfigRuleName' => '<p>The name of the Config rule.</p>', 'ConfigRule$ConfigRuleId' => '<p>The ID of the Config rule.</p>', 'ConformancePackConfigRuleNames$member' => NULL, 'DeleteEvaluationResultsRequest$ConfigRuleName' => '<p>The name of the Config rule for which you want to delete the evaluation results.</p>', 'GetComplianceDetailsByConfigRuleRequest$ConfigRuleName' => '<p>The name of the Config rule for which you want compliance information.</p>', 'MemberAccountStatus$ConfigRuleName' => '<p>The name of Config rule deployed in the member account.</p>', 'OrganizationConfigRuleNames$member' => NULL, ], ], 'StringWithCharLimit768' => [ 'base' => NULL, 'refs' => [ 'OrganizationCustomPolicyRuleMetadata$ResourceIdScope' => '<p>The ID of the Amazon Web Services resource that was evaluated.</p>', 'OrganizationCustomPolicyRuleMetadataNoPolicy$ResourceIdScope' => '<p>The ID of the Amazon Web Services resource that was evaluated.</p>', 'OrganizationCustomRuleMetadata$ResourceIdScope' => '<p>The ID of the Amazon Web Services resource that was evaluated.</p>', 'OrganizationManagedRuleMetadata$ResourceIdScope' => '<p>The ID of the Amazon Web Services resource that was evaluated.</p>', ], ], 'SupplementaryConfiguration' => [ 'base' => NULL, 'refs' => [ 'BaseConfigurationItem$supplementaryConfiguration' => '<p>Configuration attributes that Config returns for certain resource types to supplement the information returned for the configuration parameter.</p>', 'ConfigurationItem$supplementaryConfiguration' => '<p>Configuration attributes that Config returns for certain resource types to supplement the information returned for the <code>configuration</code> parameter.</p>', ], ], 'SupplementaryConfigurationName' => [ 'base' => NULL, 'refs' => [ 'SupplementaryConfiguration$key' => NULL, ], ], 'SupplementaryConfigurationValue' => [ 'base' => NULL, 'refs' => [ 'SupplementaryConfiguration$value' => NULL, ], ], 'Tag' => [ 'base' => '<p>The tags for the resource. The metadata that you apply to a resource to help you categorize and organize them. Each tag consists of a key and an optional value, both of which you define. Tag keys can have a maximum character length of 128 characters, and tag values can have a maximum length of 256 characters.</p>', 'refs' => [ 'TagList$member' => NULL, 'TagsList$member' => NULL, ], ], 'TagKey' => [ 'base' => NULL, 'refs' => [ 'Tag$Key' => '<p>One part of a key-value pair that make up a tag. A key is a general label that acts like a category for more specific tag values.</p>', 'TagKeyList$member' => NULL, ], ], 'TagKeyList' => [ 'base' => NULL, 'refs' => [ 'UntagResourceRequest$TagKeys' => '<p>The keys of the tags to be removed.</p>', ], ], 'TagList' => [ 'base' => NULL, 'refs' => [ 'ListTagsForResourceResponse$Tags' => '<p>The tags for the resource.</p>', 'TagResourceRequest$Tags' => '<p>An array of tag object.</p>', ], ], 'TagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'TagValue' => [ 'base' => NULL, 'refs' => [ 'Tag$Value' => '<p>The optional part of a key-value pair that make up a tag. A value acts as a descriptor within a tag category (key).</p>', ], ], 'Tags' => [ 'base' => NULL, 'refs' => [ 'ConfigurationItem$tags' => '<p>A mapping of key value tags associated with the resource.</p>', 'PutResourceConfigRequest$Tags' => '<p>Tags associated with the resource.</p>', ], ], 'TagsList' => [ 'base' => NULL, 'refs' => [ 'PutAggregationAuthorizationRequest$Tags' => '<p>An array of tag object.</p>', 'PutConfigRuleRequest$Tags' => '<p>An array of tag object.</p>', 'PutConfigurationAggregatorRequest$Tags' => '<p>An array of tag object.</p>', 'PutStoredQueryRequest$Tags' => '<p>A list of <code>Tags</code> object.</p>', ], ], 'TemplateBody' => [ 'base' => NULL, 'refs' => [ 'PutConformancePackRequest$TemplateBody' => '<p>A string containing full conformance pack template body. Structure containing the template body with a minimum length of 1 byte and a maximum length of 51,200 bytes.</p> <note> <p>You can only use a YAML template with two resource types: Config rule (<code>AWS::Config::ConfigRule</code>) and a remediation action (<code>AWS::Config::RemediationConfiguration</code>).</p> </note>', 'PutOrganizationConformancePackRequest$TemplateBody' => '<p>A string containing full conformance pack template body. Structure containing the template body with a minimum length of 1 byte and a maximum length of 51,200 bytes.</p>', ], ], 'TemplateS3Uri' => [ 'base' => NULL, 'refs' => [ 'PutConformancePackRequest$TemplateS3Uri' => '<p>Location of file containing the template body (<code>s3://bucketname/prefix</code>). The uri must point to the conformance pack template (max size: 300 KB) that is located in an Amazon S3 bucket in the same region as the conformance pack. </p> <note> <p>You must have access to read Amazon S3 bucket.</p> </note>', 'PutOrganizationConformancePackRequest$TemplateS3Uri' => '<p>Location of file containing the template body. The uri must point to the conformance pack template (max size: 300 KB).</p> <note> <p>You must have access to read Amazon S3 bucket.</p> </note>', ], ], 'TooManyTagsException' => [ 'base' => '<p>You have reached the limit of the number of tags you can use. You have more than 50 tags.</p>', 'refs' => [], ], 'UnprocessedResourceIdentifierList' => [ 'base' => NULL, 'refs' => [ 'BatchGetAggregateResourceConfigResponse$UnprocessedResourceIdentifiers' => '<p>A list of resource identifiers that were not processed with current scope. The list is empty if all the resources are processed.</p>', ], ], 'UntagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'ValidationException' => [ 'base' => '<p>The requested action is not valid.</p> <p>For PutStoredQuery, you will see this exception if there are missing required fields or if the input value fails the validation, or if you are trying to create more than 300 queries.</p> <p>For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this exception if there are missing required fields or if the input value fails the validation.</p>', 'refs' => [], ], 'Value' => [ 'base' => NULL, 'refs' => [ 'Tags$value' => NULL, ], ], 'Version' => [ 'base' => NULL, 'refs' => [ 'BaseConfigurationItem$version' => '<p>The version number of the resource configuration.</p>', 'ConfigurationItem$version' => '<p>The version number of the resource configuration.</p>', ], ], ],];
