<?php
// This file was auto-generated from sdk-root/src/data/codecommit/2015-04-13/docs-2.json
return [ 'version' => '2.0', 'service' => '<fullname>AWS CodeCommit</fullname> <p>This is the <i>AWS CodeCommit API Reference</i>. This reference provides descriptions of the operations and data types for AWS CodeCommit API along with usage examples.</p> <p>You can use the AWS CodeCommit API to work with the following objects:</p> <p>Repositories, by calling the following:</p> <ul> <li> <p> <a>BatchGetRepositories</a>, which returns information about one or more repositories associated with your AWS account.</p> </li> <li> <p> <a>CreateRepository</a>, which creates an AWS CodeCommit repository.</p> </li> <li> <p> <a>DeleteRepository</a>, which deletes an AWS CodeCommit repository.</p> </li> <li> <p> <a>GetRepository</a>, which returns information about a specified repository.</p> </li> <li> <p> <a>ListRepositories</a>, which lists all AWS CodeCommit repositories associated with your AWS account.</p> </li> <li> <p> <a>UpdateRepositoryDescription</a>, which sets or updates the description of the repository.</p> </li> <li> <p> <a>UpdateRepositoryName</a>, which changes the name of the repository. If you change the name of a repository, no other users of that repository can access it until you send them the new HTTPS or SSH URL to use.</p> </li> </ul> <p>Branches, by calling the following:</p> <ul> <li> <p> <a>CreateBranch</a>, which creates a branch in a specified repository.</p> </li> <li> <p> <a>DeleteBranch</a>, which deletes the specified branch in a repository unless it is the default branch.</p> </li> <li> <p> <a>GetBranch</a>, which returns information about a specified branch.</p> </li> <li> <p> <a>ListBranches</a>, which lists all branches for a specified repository.</p> </li> <li> <p> <a>UpdateDefaultBranch</a>, which changes the default branch for a repository.</p> </li> </ul> <p>Files, by calling the following:</p> <ul> <li> <p> <a>DeleteFile</a>, which deletes the content of a specified file from a specified branch.</p> </li> <li> <p> <a>GetBlob</a>, which returns the base-64 encoded content of an individual Git blob object in a repository.</p> </li> <li> <p> <a>GetFile</a>, which returns the base-64 encoded content of a specified file.</p> </li> <li> <p> <a>GetFolder</a>, which returns the contents of a specified folder or directory.</p> </li> <li> <p> <a>PutFile</a>, which adds or modifies a single file in a specified repository and branch.</p> </li> </ul> <p>Commits, by calling the following:</p> <ul> <li> <p> <a>BatchGetCommits</a>, which returns information about one or more commits in a repository.</p> </li> <li> <p> <a>CreateCommit</a>, which creates a commit for changes to a repository.</p> </li> <li> <p> <a>GetCommit</a>, which returns information about a commit, including commit messages and author and committer information.</p> </li> <li> <p> <a>GetDifferences</a>, which returns information about the differences in a valid commit specifier (such as a branch, tag, HEAD, commit ID, or other fully qualified reference).</p> </li> </ul> <p>Merges, by calling the following:</p> <ul> <li> <p> <a>BatchDescribeMergeConflicts</a>, which returns information about conflicts in a merge between commits in a repository.</p> </li> <li> <p> <a>CreateUnreferencedMergeCommit</a>, which creates an unreferenced commit between two branches or commits for the purpose of comparing them and identifying any potential conflicts.</p> </li> <li> <p> <a>DescribeMergeConflicts</a>, which returns information about merge conflicts between the base, source, and destination versions of a file in a potential merge.</p> </li> <li> <p> <a>GetMergeCommit</a>, which returns information about the merge between a source and destination commit. </p> </li> <li> <p> <a>GetMergeConflicts</a>, which returns information about merge conflicts between the source and destination branch in a pull request.</p> </li> <li> <p> <a>GetMergeOptions</a>, which returns information about the available merge options between two branches or commit specifiers.</p> </li> <li> <p> <a>MergeBranchesByFastForward</a>, which merges two branches using the fast-forward merge option.</p> </li> <li> <p> <a>MergeBranchesBySquash</a>, which merges two branches using the squash merge option.</p> </li> <li> <p> <a>MergeBranchesByThreeWay</a>, which merges two branches using the three-way merge option.</p> </li> </ul> <p>Pull requests, by calling the following:</p> <ul> <li> <p> <a>CreatePullRequest</a>, which creates a pull request in a specified repository.</p> </li> <li> <p> <a>CreatePullRequestApprovalRule</a>, which creates an approval rule for a specified pull request.</p> </li> <li> <p> <a>DeletePullRequestApprovalRule</a>, which deletes an approval rule for a specified pull request.</p> </li> <li> <p> <a>DescribePullRequestEvents</a>, which returns information about one or more pull request events.</p> </li> <li> <p> <a>EvaluatePullRequestApprovalRules</a>, which evaluates whether a pull request has met all the conditions specified in its associated approval rules.</p> </li> <li> <p> <a>GetCommentsForPullRequest</a>, which returns information about comments on a specified pull request.</p> </li> <li> <p> <a>GetPullRequest</a>, which returns information about a specified pull request.</p> </li> <li> <p> <a>GetPullRequestApprovalStates</a>, which returns information about the approval states for a specified pull request.</p> </li> <li> <p> <a>GetPullRequestOverrideState</a>, which returns information about whether approval rules have been set aside (overriden) for a pull request, and if so, the Amazon Resource Name (ARN) of the user or identity that overrode the rules and their requirements for the pull request.</p> </li> <li> <p> <a>ListPullRequests</a>, which lists all pull requests for a repository.</p> </li> <li> <p> <a>MergePullRequestByFastForward</a>, which merges the source destination branch of a pull request into the specified destination branch for that pull request using the fast-forward merge option.</p> </li> <li> <p> <a>MergePullRequestBySquash</a>, which merges the source destination branch of a pull request into the specified destination branch for that pull request using the squash merge option.</p> </li> <li> <p> <a>MergePullRequestByThreeWay</a>. which merges the source destination branch of a pull request into the specified destination branch for that pull request using the three-way merge option.</p> </li> <li> <p> <a>OverridePullRequestApprovalRules</a>, which sets aside all approval rule requirements for a pull request.</p> </li> <li> <p> <a>PostCommentForPullRequest</a>, which posts a comment to a pull request at the specified line, file, or request.</p> </li> <li> <p> <a>UpdatePullRequestApprovalRuleContent</a>, which updates the structure of an approval rule for a pull request.</p> </li> <li> <p> <a>UpdatePullRequestApprovalState</a>, which updates the state of an approval on a pull request.</p> </li> <li> <p> <a>UpdatePullRequestDescription</a>, which updates the description of a pull request.</p> </li> <li> <p> <a>UpdatePullRequestStatus</a>, which updates the status of a pull request.</p> </li> <li> <p> <a>UpdatePullRequestTitle</a>, which updates the title of a pull request.</p> </li> </ul> <p>Approval rule templates, by calling the following:</p> <ul> <li> <p> <a>AssociateApprovalRuleTemplateWithRepository</a>, which associates a template with a specified repository. After the template is associated with a repository, AWS CodeCommit creates approval rules that match the template conditions on every pull request created in the specified repository.</p> </li> <li> <p> <a>BatchAssociateApprovalRuleTemplateWithRepositories</a>, which associates a template with one or more specified repositories. After the template is associated with a repository, AWS CodeCommit creates approval rules that match the template conditions on every pull request created in the specified repositories.</p> </li> <li> <p> <a>BatchDisassociateApprovalRuleTemplateFromRepositories</a>, which removes the association between a template and specified repositories so that approval rules based on the template are not automatically created when pull requests are created in those repositories.</p> </li> <li> <p> <a>CreateApprovalRuleTemplate</a>, which creates a template for approval rules that can then be associated with one or more repositories in your AWS account.</p> </li> <li> <p> <a>DeleteApprovalRuleTemplate</a>, which deletes the specified template. It does not remove approval rules on pull requests already created with the template.</p> </li> <li> <p> <a>DisassociateApprovalRuleTemplateFromRepository</a>, which removes the association between a template and a repository so that approval rules based on the template are not automatically created when pull requests are created in the specified repository.</p> </li> <li> <p> <a>GetApprovalRuleTemplate</a>, which returns information about an approval rule template.</p> </li> <li> <p> <a>ListApprovalRuleTemplates</a>, which lists all approval rule templates in the AWS Region in your AWS account.</p> </li> <li> <p> <a>ListAssociatedApprovalRuleTemplatesForRepository</a>, which lists all approval rule templates that are associated with a specified repository.</p> </li> <li> <p> <a>ListRepositoriesForApprovalRuleTemplate</a>, which lists all repositories associated with the specified approval rule template.</p> </li> <li> <p> <a>UpdateApprovalRuleTemplateDescription</a>, which updates the description of an approval rule template.</p> </li> <li> <p> <a>UpdateApprovalRuleTemplateName</a>, which updates the name of an approval rule template.</p> </li> <li> <p> <a>UpdateApprovalRuleTemplateContent</a>, which updates the content of an approval rule template.</p> </li> </ul> <p>Comments in a repository, by calling the following:</p> <ul> <li> <p> <a>DeleteCommentContent</a>, which deletes the content of a comment on a commit in a repository.</p> </li> <li> <p> <a>GetComment</a>, which returns information about a comment on a commit.</p> </li> <li> <p> <a>GetCommentReactions</a>, which returns information about emoji reactions to comments.</p> </li> <li> <p> <a>GetCommentsForComparedCommit</a>, which returns information about comments on the comparison between two commit specifiers in a repository.</p> </li> <li> <p> <a>PostCommentForComparedCommit</a>, which creates a comment on the comparison between two commit specifiers in a repository.</p> </li> <li> <p> <a>PostCommentReply</a>, which creates a reply to a comment.</p> </li> <li> <p> <a>PutCommentReaction</a>, which creates or updates an emoji reaction to a comment.</p> </li> <li> <p> <a>UpdateComment</a>, which updates the content of a comment on a commit in a repository.</p> </li> </ul> <p>Tags used to tag resources in AWS CodeCommit (not Git tags), by calling the following:</p> <ul> <li> <p> <a>ListTagsForResource</a>, which gets information about AWS tags for a specified Amazon Resource Name (ARN) in AWS CodeCommit.</p> </li> <li> <p> <a>TagResource</a>, which adds or updates tags for a resource in AWS CodeCommit.</p> </li> <li> <p> <a>UntagResource</a>, which removes tags for a resource in AWS CodeCommit.</p> </li> </ul> <p>Triggers, by calling the following:</p> <ul> <li> <p> <a>GetRepositoryTriggers</a>, which returns information about triggers configured for a repository.</p> </li> <li> <p> <a>PutRepositoryTriggers</a>, which replaces all triggers for a repository and can be used to create or delete triggers.</p> </li> <li> <p> <a>TestRepositoryTriggers</a>, which tests the functionality of a repository trigger by sending data to the trigger target.</p> </li> </ul> <p>For information about how to use AWS CodeCommit, see the <a href="https://docs.aws.amazon.com/codecommit/latest/userguide/welcome.html">AWS CodeCommit User Guide</a>.</p>', 'operations' => [ 'AssociateApprovalRuleTemplateWithRepository' => '<p>Creates an association between an approval rule template and a specified repository. Then, the next time a pull request is created in the repository where the destination reference (if specified) matches the destination reference (branch) for the pull request, an approval rule that matches the template conditions is automatically created for that pull request. If no destination references are specified in the template, an approval rule that matches the template contents is created for all pull requests in that repository.</p>', 'BatchAssociateApprovalRuleTemplateWithRepositories' => '<p>Creates an association between an approval rule template and one or more specified repositories. </p>', 'BatchDescribeMergeConflicts' => '<p>Returns information about one or more merge conflicts in the attempted merge of two commit specifiers using the squash or three-way merge strategy.</p>', 'BatchDisassociateApprovalRuleTemplateFromRepositories' => '<p>Removes the association between an approval rule template and one or more specified repositories. </p>', 'BatchGetCommits' => '<p>Returns information about the contents of one or more commits in a repository.</p>', 'BatchGetRepositories' => '<p>Returns information about one or more repositories.</p> <note> <p>The description field for a repository accepts all HTML characters and all valid Unicode characters. Applications that do not HTML-encode the description and display it in a webpage can expose users to potentially malicious code. Make sure that you HTML-encode the description field in any application that uses this API to display the repository description on a webpage.</p> </note>', 'CreateApprovalRuleTemplate' => '<p>Creates a template for approval rules that can then be associated with one or more repositories in your AWS account. When you associate a template with a repository, AWS CodeCommit creates an approval rule that matches the conditions of the template for all pull requests that meet the conditions of the template. For more information, see <a>AssociateApprovalRuleTemplateWithRepository</a>.</p>', 'CreateBranch' => '<p>Creates a branch in a repository and points the branch to a commit.</p> <note> <p>Calling the create branch operation does not set a repository\'s default branch. To do this, call the update default branch operation.</p> </note>', 'CreateCommit' => '<p>Creates a commit for a repository on the tip of a specified branch.</p>', 'CreatePullRequest' => '<p>Creates a pull request in the specified repository.</p>', 'CreatePullRequestApprovalRule' => '<p>Creates an approval rule for a pull request.</p>', 'CreateRepository' => '<p>Creates a new, empty repository.</p>', 'CreateUnreferencedMergeCommit' => '<p>Creates an unreferenced commit that represents the result of merging two branches using a specified merge strategy. This can help you determine the outcome of a potential merge. This API cannot be used with the fast-forward merge strategy because that strategy does not create a merge commit.</p> <note> <p>This unreferenced merge commit can only be accessed using the GetCommit API or through git commands such as git fetch. To retrieve this commit, you must specify its commit ID or otherwise reference it.</p> </note>', 'DeleteApprovalRuleTemplate' => '<p>Deletes a specified approval rule template. Deleting a template does not remove approval rules on pull requests already created with the template.</p>', 'DeleteBranch' => '<p>Deletes a branch from a repository, unless that branch is the default branch for the repository. </p>', 'DeleteCommentContent' => '<p>Deletes the content of a comment made on a change, file, or commit in a repository.</p>', 'DeleteFile' => '<p>Deletes a specified file from a specified branch. A commit is created on the branch that contains the revision. The file still exists in the commits earlier to the commit that contains the deletion.</p>', 'DeletePullRequestApprovalRule' => '<p>Deletes an approval rule from a specified pull request. Approval rules can be deleted from a pull request only if the pull request is open, and if the approval rule was created specifically for a pull request and not generated from an approval rule template associated with the repository where the pull request was created. You cannot delete an approval rule from a merged or closed pull request.</p>', 'DeleteRepository' => '<p>Deletes a repository. If a specified repository was already deleted, a null repository ID is returned.</p> <important> <p>Deleting a repository also deletes all associated objects and metadata. After a repository is deleted, all future push calls to the deleted repository fail.</p> </important>', 'DescribeMergeConflicts' => '<p>Returns information about one or more merge conflicts in the attempted merge of two commit specifiers using the squash or three-way merge strategy. If the merge option for the attempted merge is specified as FAST_FORWARD_MERGE, an exception is thrown.</p>', 'DescribePullRequestEvents' => '<p>Returns information about one or more pull request events.</p>', 'DisassociateApprovalRuleTemplateFromRepository' => '<p>Removes the association between a template and a repository so that approval rules based on the template are not automatically created when pull requests are created in the specified repository. This does not delete any approval rules previously created for pull requests through the template association.</p>', 'EvaluatePullRequestApprovalRules' => '<p>Evaluates whether a pull request has met all the conditions specified in its associated approval rules.</p>', 'GetApprovalRuleTemplate' => '<p>Returns information about a specified approval rule template.</p>', 'GetBlob' => '<p>Returns the base-64 encoded content of an individual blob in a repository.</p>', 'GetBranch' => '<p>Returns information about a repository branch, including its name and the last commit ID.</p>', 'GetComment' => '<p>Returns the content of a comment made on a change, file, or commit in a repository. </p> <note> <p>Reaction counts might include numbers from user identities who were deleted after the reaction was made. For a count of reactions from active identities, use GetCommentReactions.</p> </note>', 'GetCommentReactions' => '<p>Returns information about reactions to a specified comment ID. Reactions from users who have been deleted will not be included in the count.</p>', 'GetCommentsForComparedCommit' => '<p>Returns information about comments made on the comparison between two commits.</p> <note> <p>Reaction counts might include numbers from user identities who were deleted after the reaction was made. For a count of reactions from active identities, use GetCommentReactions.</p> </note>', 'GetCommentsForPullRequest' => '<p>Returns comments made on a pull request.</p> <note> <p>Reaction counts might include numbers from user identities who were deleted after the reaction was made. For a count of reactions from active identities, use GetCommentReactions.</p> </note>', 'GetCommit' => '<p>Returns information about a commit, including commit message and committer information.</p>', 'GetDifferences' => '<p>Returns information about the differences in a valid commit specifier (such as a branch, tag, HEAD, commit ID, or other fully qualified reference). Results can be limited to a specified path.</p>', 'GetFile' => '<p>Returns the base-64 encoded contents of a specified file and its metadata.</p>', 'GetFolder' => '<p>Returns the contents of a specified folder in a repository.</p>', 'GetMergeCommit' => '<p>Returns information about a specified merge commit.</p>', 'GetMergeConflicts' => '<p>Returns information about merge conflicts between the before and after commit IDs for a pull request in a repository.</p>', 'GetMergeOptions' => '<p>Returns information about the merge options available for merging two specified branches. For details about why a merge option is not available, use GetMergeConflicts or DescribeMergeConflicts.</p>', 'GetPullRequest' => '<p>Gets information about a pull request in a specified repository.</p>', 'GetPullRequestApprovalStates' => '<p>Gets information about the approval states for a specified pull request. Approval states only apply to pull requests that have one or more approval rules applied to them.</p>', 'GetPullRequestOverrideState' => '<p>Returns information about whether approval rules have been set aside (overridden) for a pull request, and if so, the Amazon Resource Name (ARN) of the user or identity that overrode the rules and their requirements for the pull request.</p>', 'GetRepository' => '<p>Returns information about a repository.</p> <note> <p>The description field for a repository accepts all HTML characters and all valid Unicode characters. Applications that do not HTML-encode the description and display it in a webpage can expose users to potentially malicious code. Make sure that you HTML-encode the description field in any application that uses this API to display the repository description on a webpage.</p> </note>', 'GetRepositoryTriggers' => '<p>Gets information about triggers configured for a repository.</p>', 'ListApprovalRuleTemplates' => '<p>Lists all approval rule templates in the specified AWS Region in your AWS account. If an AWS Region is not specified, the AWS Region where you are signed in is used.</p>', 'ListAssociatedApprovalRuleTemplatesForRepository' => '<p>Lists all approval rule templates that are associated with a specified repository.</p>', 'ListBranches' => '<p>Gets information about one or more branches in a repository.</p>', 'ListPullRequests' => '<p>Returns a list of pull requests for a specified repository. The return list can be refined by pull request status or pull request author ARN.</p>', 'ListRepositories' => '<p>Gets information about one or more repositories.</p>', 'ListRepositoriesForApprovalRuleTemplate' => '<p>Lists all repositories associated with the specified approval rule template.</p>', 'ListTagsForResource' => '<p>Gets information about AWS tags for a specified Amazon Resource Name (ARN) in AWS CodeCommit. For a list of valid resources in AWS CodeCommit, see <a href="https://docs.aws.amazon.com/codecommit/latest/userguide/auth-and-access-control-iam-access-control-identity-based.html#arn-formats">CodeCommit Resources and Operations</a> in the<i> AWS CodeCommit User Guide</i>.</p>', 'MergeBranchesByFastForward' => '<p>Merges two branches using the fast-forward merge strategy.</p>', 'MergeBranchesBySquash' => '<p>Merges two branches using the squash merge strategy.</p>', 'MergeBranchesByThreeWay' => '<p>Merges two specified branches using the three-way merge strategy.</p>', 'MergePullRequestByFastForward' => '<p>Attempts to merge the source commit of a pull request into the specified destination branch for that pull request at the specified commit using the fast-forward merge strategy. If the merge is successful, it closes the pull request.</p>', 'MergePullRequestBySquash' => '<p>Attempts to merge the source commit of a pull request into the specified destination branch for that pull request at the specified commit using the squash merge strategy. If the merge is successful, it closes the pull request.</p>', 'MergePullRequestByThreeWay' => '<p>Attempts to merge the source commit of a pull request into the specified destination branch for that pull request at the specified commit using the three-way merge strategy. If the merge is successful, it closes the pull request.</p>', 'OverridePullRequestApprovalRules' => '<p>Sets aside (overrides) all approval rule requirements for a specified pull request.</p>', 'PostCommentForComparedCommit' => '<p>Posts a comment on the comparison between two commits.</p>', 'PostCommentForPullRequest' => '<p>Posts a comment on a pull request.</p>', 'PostCommentReply' => '<p>Posts a comment in reply to an existing comment on a comparison between commits or a pull request.</p>', 'PutCommentReaction' => '<p>Adds or updates a reaction to a specified comment for the user whose identity is used to make the request. You can only add or update a reaction for yourself. You cannot add, modify, or delete a reaction for another user.</p>', 'PutFile' => '<p>Adds or updates a file in a branch in an AWS CodeCommit repository, and generates a commit for the addition in the specified branch.</p>', 'PutRepositoryTriggers' => '<p>Replaces all triggers for a repository. Used to create or delete triggers.</p>', 'TagResource' => '<p>Adds or updates tags for a resource in AWS CodeCommit. For a list of valid resources in AWS CodeCommit, see <a href="https://docs.aws.amazon.com/codecommit/latest/userguide/auth-and-access-control-iam-access-control-identity-based.html#arn-formats">CodeCommit Resources and Operations</a> in the <i>AWS CodeCommit User Guide</i>.</p>', 'TestRepositoryTriggers' => '<p>Tests the functionality of repository triggers by sending information to the trigger target. If real data is available in the repository, the test sends data from the last commit. If no data is available, sample data is generated.</p>', 'UntagResource' => '<p>Removes tags for a resource in AWS CodeCommit. For a list of valid resources in AWS CodeCommit, see <a href="https://docs.aws.amazon.com/codecommit/latest/userguide/auth-and-access-control-iam-access-control-identity-based.html#arn-formats">CodeCommit Resources and Operations</a> in the <i>AWS CodeCommit User Guide</i>.</p>', 'UpdateApprovalRuleTemplateContent' => '<p>Updates the content of an approval rule template. You can change the number of required approvals, the membership of the approval rule, and whether an approval pool is defined.</p>', 'UpdateApprovalRuleTemplateDescription' => '<p>Updates the description for a specified approval rule template.</p>', 'UpdateApprovalRuleTemplateName' => '<p>Updates the name of a specified approval rule template.</p>', 'UpdateComment' => '<p>Replaces the contents of a comment.</p>', 'UpdateDefaultBranch' => '<p>Sets or changes the default branch name for the specified repository.</p> <note> <p>If you use this operation to change the default branch name to the current default branch name, a success message is returned even though the default branch did not change.</p> </note>', 'UpdatePullRequestApprovalRuleContent' => '<p>Updates the structure of an approval rule created specifically for a pull request. For example, you can change the number of required approvers and the approval pool for approvers. </p>', 'UpdatePullRequestApprovalState' => '<p>Updates the state of a user\'s approval on a pull request. The user is derived from the signed-in account when the request is made.</p>', 'UpdatePullRequestDescription' => '<p>Replaces the contents of the description of a pull request.</p>', 'UpdatePullRequestStatus' => '<p>Updates the status of a pull request. </p>', 'UpdatePullRequestTitle' => '<p>Replaces the title of a pull request.</p>', 'UpdateRepositoryDescription' => '<p>Sets or changes the comment or description for a repository.</p> <note> <p>The description field for a repository accepts all HTML characters and all valid Unicode characters. Applications that do not HTML-encode the description and display it in a webpage can expose users to potentially malicious code. Make sure that you HTML-encode the description field in any application that uses this API to display the repository description on a webpage.</p> </note>', 'UpdateRepositoryName' => '<p>Renames a repository. The repository name must be unique across the calling AWS account. Repository names are limited to 100 alphanumeric, dash, and underscore characters, and cannot include certain characters. The suffix .git is prohibited. For more information about the limits on repository names, see <a href="https://docs.aws.amazon.com/codecommit/latest/userguide/limits.html">Limits</a> in the AWS CodeCommit User Guide.</p>', ], 'shapes' => [ 'AccountId' => [ 'base' => NULL, 'refs' => [ 'RepositoryMetadata$accountId' => '<p>The ID of the AWS account associated with the repository.</p>', ], ], 'ActorDoesNotExistException' => [ 'base' => '<p>The specified Amazon Resource Name (ARN) does not exist in the AWS account.</p>', 'refs' => [], ], 'AdditionalData' => [ 'base' => NULL, 'refs' => [ 'Commit$additionalData' => '<p>Any other data associated with the specified commit.</p>', ], ], 'Approval' => [ 'base' => '<p>Returns information about a specific approval on a pull request.</p>', 'refs' => [ 'ApprovalList$member' => NULL, ], ], 'ApprovalList' => [ 'base' => NULL, 'refs' => [ 'GetPullRequestApprovalStatesOutput$approvals' => '<p>Information about users who have approved the pull request.</p>', ], ], 'ApprovalRule' => [ 'base' => '<p>Returns information about an approval rule.</p>', 'refs' => [ 'ApprovalRulesList$member' => NULL, 'CreatePullRequestApprovalRuleOutput$approvalRule' => '<p>Information about the created approval rule.</p>', 'UpdatePullRequestApprovalRuleContentOutput$approvalRule' => '<p>Information about the updated approval rule.</p>', ], ], 'ApprovalRuleContent' => [ 'base' => NULL, 'refs' => [ 'ApprovalRule$approvalRuleContent' => '<p>The content of the approval rule.</p>', 'ApprovalRuleEventMetadata$approvalRuleContent' => '<p>The content of the approval rule.</p>', 'CreatePullRequestApprovalRuleInput$approvalRuleContent' => '<p>The content of the approval rule, including the number of approvals needed and the structure of an approval pool defined for approvals, if any. For more information about approval pools, see the AWS CodeCommit User Guide.</p> <note> <p>When you create the content of the approval rule, you can specify approvers in an approval pool in one of two ways:</p> <ul> <li> <p> <b>CodeCommitApprovers</b>: This option only requires an AWS account and a resource. It can be used for both IAM users and federated access users whose name matches the provided resource name. This is a very powerful option that offers a great deal of flexibility. For example, if you specify the AWS account <i>123456789012</i> and <i>Mary_Major</i>, all of the following would be counted as approvals coming from that user:</p> <ul> <li> <p>An IAM user in the account (arn:aws:iam::<i>123456789012</i>:user/<i>Mary_Major</i>)</p> </li> <li> <p>A federated user identified in IAM as Mary_Major (arn:aws:sts::<i>123456789012</i>:federated-user/<i>Mary_Major</i>)</p> </li> </ul> <p>This option does not recognize an active session of someone assuming the role of CodeCommitReview with a role session name of <i>Mary_Major</i> (arn:aws:sts::<i>123456789012</i>:assumed-role/CodeCommitReview/<i>Mary_Major</i>) unless you include a wildcard (*Mary_Major).</p> </li> <li> <p> <b>Fully qualified ARN</b>: This option allows you to specify the fully qualified Amazon Resource Name (ARN) of the IAM user or role. </p> </li> </ul> <p>For more information about IAM ARNs, wildcards, and formats, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html">IAM Identifiers</a> in the <i>IAM User Guide</i>.</p> </note>', 'UpdatePullRequestApprovalRuleContentInput$newRuleContent' => '<p>The updated content for the approval rule.</p> <note> <p>When you update the content of the approval rule, you can specify approvers in an approval pool in one of two ways:</p> <ul> <li> <p> <b>CodeCommitApprovers</b>: This option only requires an AWS account and a resource. It can be used for both IAM users and federated access users whose name matches the provided resource name. This is a very powerful option that offers a great deal of flexibility. For example, if you specify the AWS account <i>123456789012</i> and <i>Mary_Major</i>, all of the following are counted as approvals coming from that user:</p> <ul> <li> <p>An IAM user in the account (arn:aws:iam::<i>123456789012</i>:user/<i>Mary_Major</i>)</p> </li> <li> <p>A federated user identified in IAM as Mary_Major (arn:aws:sts::<i>123456789012</i>:federated-user/<i>Mary_Major</i>)</p> </li> </ul> <p>This option does not recognize an active session of someone assuming the role of CodeCommitReview with a role session name of <i>Mary_Major</i> (arn:aws:sts::<i>123456789012</i>:assumed-role/CodeCommitReview/<i>Mary_Major</i>) unless you include a wildcard (*Mary_Major).</p> </li> <li> <p> <b>Fully qualified ARN</b>: This option allows you to specify the fully qualified Amazon Resource Name (ARN) of the IAM user or role. </p> </li> </ul> <p>For more information about IAM ARNs, wildcards, and formats, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html">IAM Identifiers</a> in the <i>IAM User Guide</i>.</p> </note>', ], ], 'ApprovalRuleContentRequiredException' => [ 'base' => '<p>The content for the approval rule is empty. You must provide some content for an approval rule. The content cannot be null.</p>', 'refs' => [], ], 'ApprovalRuleDoesNotExistException' => [ 'base' => '<p>The specified approval rule does not exist.</p>', 'refs' => [], ], 'ApprovalRuleEventMetadata' => [ 'base' => '<p>Returns information about an event for an approval rule.</p>', 'refs' => [ 'PullRequestEvent$approvalRuleEventMetadata' => '<p>Information about a pull request event.</p>', ], ], 'ApprovalRuleId' => [ 'base' => NULL, 'refs' => [ 'ApprovalRule$approvalRuleId' => '<p>The system-generated ID of the approval rule.</p>', 'ApprovalRuleEventMetadata$approvalRuleId' => '<p>The system-generated ID of the approval rule.</p>', 'DeletePullRequestApprovalRuleOutput$approvalRuleId' => '<p>The ID of the deleted approval rule. </p> <note> <p>If the approval rule was deleted in an earlier API call, the response is 200 OK without content.</p> </note>', ], ], 'ApprovalRuleName' => [ 'base' => NULL, 'refs' => [ 'ApprovalRule$approvalRuleName' => '<p>The name of the approval rule.</p>', 'ApprovalRuleEventMetadata$approvalRuleName' => '<p>The name of the approval rule.</p>', 'ApprovalRulesNotSatisfiedList$member' => NULL, 'ApprovalRulesSatisfiedList$member' => NULL, 'CreatePullRequestApprovalRuleInput$approvalRuleName' => '<p>The name for the approval rule.</p>', 'DeletePullRequestApprovalRuleInput$approvalRuleName' => '<p>The name of the approval rule you want to delete.</p>', 'UpdatePullRequestApprovalRuleContentInput$approvalRuleName' => '<p>The name of the approval rule you want to update.</p>', ], ], 'ApprovalRuleNameAlreadyExistsException' => [ 'base' => '<p>An approval rule with that name already exists. Approval rule names must be unique within the scope of a pull request.</p>', 'refs' => [], ], 'ApprovalRuleNameRequiredException' => [ 'base' => '<p>An approval rule name is required, but was not specified.</p>', 'refs' => [], ], 'ApprovalRuleOverriddenEventMetadata' => [ 'base' => '<p>Returns information about an override event for approval rules for a pull request.</p>', 'refs' => [ 'PullRequestEvent$approvalRuleOverriddenEventMetadata' => '<p>Information about an approval rule override event for a pull request.</p>', ], ], 'ApprovalRuleTemplate' => [ 'base' => '<p>Returns information about an approval rule template.</p>', 'refs' => [ 'CreateApprovalRuleTemplateOutput$approvalRuleTemplate' => '<p>The content and structure of the created approval rule template.</p>', 'GetApprovalRuleTemplateOutput$approvalRuleTemplate' => '<p>The content and structure of the approval rule template.</p>', 'UpdateApprovalRuleTemplateContentOutput$approvalRuleTemplate' => NULL, 'UpdateApprovalRuleTemplateDescriptionOutput$approvalRuleTemplate' => '<p>The structure and content of the updated approval rule template.</p>', 'UpdateApprovalRuleTemplateNameOutput$approvalRuleTemplate' => '<p>The structure and content of the updated approval rule template.</p>', ], ], 'ApprovalRuleTemplateContent' => [ 'base' => NULL, 'refs' => [ 'ApprovalRuleTemplate$approvalRuleTemplateContent' => '<p>The content of the approval rule template.</p>', 'CreateApprovalRuleTemplateInput$approvalRuleTemplateContent' => '<p>The content of the approval rule that is created on pull requests in associated repositories. If you specify one or more destination references (branches), approval rules are created in an associated repository only if their destination references (branches) match those specified in the template.</p> <note> <p>When you create the content of the approval rule template, you can specify approvers in an approval pool in one of two ways:</p> <ul> <li> <p> <b>CodeCommitApprovers</b>: This option only requires an AWS account and a resource. It can be used for both IAM users and federated access users whose name matches the provided resource name. This is a very powerful option that offers a great deal of flexibility. For example, if you specify the AWS account <i>123456789012</i> and <i>Mary_Major</i>, all of the following are counted as approvals coming from that user:</p> <ul> <li> <p>An IAM user in the account (arn:aws:iam::<i>123456789012</i>:user/<i>Mary_Major</i>)</p> </li> <li> <p>A federated user identified in IAM as Mary_Major (arn:aws:sts::<i>123456789012</i>:federated-user/<i>Mary_Major</i>)</p> </li> </ul> <p>This option does not recognize an active session of someone assuming the role of CodeCommitReview with a role session name of <i>Mary_Major</i> (arn:aws:sts::<i>123456789012</i>:assumed-role/CodeCommitReview/<i>Mary_Major</i>) unless you include a wildcard (*Mary_Major).</p> </li> <li> <p> <b>Fully qualified ARN</b>: This option allows you to specify the fully qualified Amazon Resource Name (ARN) of the IAM user or role. </p> </li> </ul> <p>For more information about IAM ARNs, wildcards, and formats, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html">IAM Identifiers</a> in the <i>IAM User Guide</i>.</p> </note>', 'UpdateApprovalRuleTemplateContentInput$newRuleContent' => '<p>The content that replaces the existing content of the rule. Content statements must be complete. You cannot provide only the changes.</p>', ], ], 'ApprovalRuleTemplateContentRequiredException' => [ 'base' => '<p>The content for the approval rule template is empty. You must provide some content for an approval rule template. The content cannot be null.</p>', 'refs' => [], ], 'ApprovalRuleTemplateDescription' => [ 'base' => NULL, 'refs' => [ 'ApprovalRuleTemplate$approvalRuleTemplateDescription' => '<p>The description of the approval rule template.</p>', 'CreateApprovalRuleTemplateInput$approvalRuleTemplateDescription' => '<p>The description of the approval rule template. Consider providing a description that explains what this template does and when it might be appropriate to associate it with repositories.</p>', 'UpdateApprovalRuleTemplateDescriptionInput$approvalRuleTemplateDescription' => '<p>The updated description of the approval rule template.</p>', ], ], 'ApprovalRuleTemplateDoesNotExistException' => [ 'base' => '<p>The specified approval rule template does not exist. Verify that the name is correct and that you are signed in to the AWS Region where the template was created, and then try again.</p>', 'refs' => [], ], 'ApprovalRuleTemplateId' => [ 'base' => NULL, 'refs' => [ 'ApprovalRuleTemplate$approvalRuleTemplateId' => '<p>The system-generated ID of the approval rule template.</p>', 'DeleteApprovalRuleTemplateOutput$approvalRuleTemplateId' => '<p>The system-generated ID of the deleted approval rule template. If the template has been previously deleted, the only response is a 200 OK.</p>', 'OriginApprovalRuleTemplate$approvalRuleTemplateId' => '<p>The ID of the template that created the approval rule.</p>', ], ], 'ApprovalRuleTemplateInUseException' => [ 'base' => '<p>The approval rule template is associated with one or more repositories. You cannot delete a template that is associated with a repository. Remove all associations, and then try again.</p>', 'refs' => [], ], 'ApprovalRuleTemplateName' => [ 'base' => NULL, 'refs' => [ 'ApprovalRuleTemplate$approvalRuleTemplateName' => '<p>The name of the approval rule template.</p>', 'ApprovalRuleTemplateNameList$member' => NULL, 'AssociateApprovalRuleTemplateWithRepositoryInput$approvalRuleTemplateName' => '<p>The name for the approval rule template. </p>', 'BatchAssociateApprovalRuleTemplateWithRepositoriesInput$approvalRuleTemplateName' => '<p>The name of the template you want to associate with one or more repositories.</p>', 'BatchDisassociateApprovalRuleTemplateFromRepositoriesInput$approvalRuleTemplateName' => '<p>The name of the template that you want to disassociate from one or more repositories.</p>', 'CreateApprovalRuleTemplateInput$approvalRuleTemplateName' => '<p>The name of the approval rule template. Provide descriptive names, because this name is applied to the approval rules created automatically in associated repositories.</p>', 'DeleteApprovalRuleTemplateInput$approvalRuleTemplateName' => '<p>The name of the approval rule template to delete.</p>', 'DisassociateApprovalRuleTemplateFromRepositoryInput$approvalRuleTemplateName' => '<p>The name of the approval rule template to disassociate from a specified repository.</p>', 'GetApprovalRuleTemplateInput$approvalRuleTemplateName' => '<p>The name of the approval rule template for which you want to get information.</p>', 'ListRepositoriesForApprovalRuleTemplateInput$approvalRuleTemplateName' => '<p>The name of the approval rule template for which you want to list repositories that are associated with that template.</p>', 'OriginApprovalRuleTemplate$approvalRuleTemplateName' => '<p>The name of the template that created the approval rule.</p>', 'UpdateApprovalRuleTemplateContentInput$approvalRuleTemplateName' => '<p>The name of the approval rule template where you want to update the content of the rule. </p>', 'UpdateApprovalRuleTemplateDescriptionInput$approvalRuleTemplateName' => '<p>The name of the template for which you want to update the description.</p>', 'UpdateApprovalRuleTemplateNameInput$oldApprovalRuleTemplateName' => '<p>The current name of the approval rule template.</p>', 'UpdateApprovalRuleTemplateNameInput$newApprovalRuleTemplateName' => '<p>The new name you want to apply to the approval rule template.</p>', ], ], 'ApprovalRuleTemplateNameAlreadyExistsException' => [ 'base' => '<p>You cannot create an approval rule template with that name because a template with that name already exists in this AWS Region for your AWS account. Approval rule template names must be unique.</p>', 'refs' => [], ], 'ApprovalRuleTemplateNameList' => [ 'base' => NULL, 'refs' => [ 'ListApprovalRuleTemplatesOutput$approvalRuleTemplateNames' => '<p>The names of all the approval rule templates found in the AWS Region for your AWS account.</p>', 'ListAssociatedApprovalRuleTemplatesForRepositoryOutput$approvalRuleTemplateNames' => '<p>The names of all approval rule templates associated with the repository.</p>', ], ], 'ApprovalRuleTemplateNameRequiredException' => [ 'base' => '<p>An approval rule template name is required, but was not specified.</p>', 'refs' => [], ], 'ApprovalRulesList' => [ 'base' => NULL, 'refs' => [ 'PullRequest$approvalRules' => '<p>The approval rules applied to the pull request.</p>', ], ], 'ApprovalRulesNotSatisfiedList' => [ 'base' => NULL, 'refs' => [ 'Evaluation$approvalRulesNotSatisfied' => '<p>The names of the approval rules that have not had their conditions met.</p>', ], ], 'ApprovalRulesSatisfiedList' => [ 'base' => NULL, 'refs' => [ 'Evaluation$approvalRulesSatisfied' => '<p>The names of the approval rules that have had their conditions met.</p>', ], ], 'ApprovalState' => [ 'base' => NULL, 'refs' => [ 'Approval$approvalState' => '<p>The state of the approval, APPROVE or REVOKE. REVOKE states are not stored.</p>', 'ApprovalStateChangedEventMetadata$approvalStatus' => '<p>The approval status for the pull request.</p>', 'UpdatePullRequestApprovalStateInput$approvalState' => '<p>The approval state to associate with the user on the pull request.</p>', ], ], 'ApprovalStateChangedEventMetadata' => [ 'base' => '<p>Returns information about a change in the approval state for a pull request.</p>', 'refs' => [ 'PullRequestEvent$approvalStateChangedEventMetadata' => '<p>Information about an approval state change for a pull request.</p>', ], ], 'ApprovalStateRequiredException' => [ 'base' => '<p>An approval state is required, but was not specified.</p>', 'refs' => [], ], 'Approved' => [ 'base' => NULL, 'refs' => [ 'Evaluation$approved' => '<p>Whether the state of the pull request is approved.</p>', ], ], 'Arn' => [ 'base' => NULL, 'refs' => [ 'Approval$userArn' => '<p>The Amazon Resource Name (ARN) of the user.</p>', 'ApprovalRule$lastModifiedUser' => '<p>The Amazon Resource Name (ARN) of the user who made the most recent changes to the approval rule.</p>', 'ApprovalRuleTemplate$lastModifiedUser' => '<p>The Amazon Resource Name (ARN) of the user who made the most recent changes to the approval rule template.</p>', 'Comment$authorArn' => '<p>The Amazon Resource Name (ARN) of the person who posted the comment.</p>', 'DescribePullRequestEventsInput$actorArn' => '<p>The Amazon Resource Name (ARN) of the user whose actions resulted in the event. Examples include updating the pull request with more commits or changing the status of a pull request.</p>', 'GetCommentReactionsInput$reactionUserArn' => '<p>Optional. The Amazon Resource Name (ARN) of the user or identity for which you want to get reaction information.</p>', 'GetPullRequestOverrideStateOutput$overrider' => '<p>The Amazon Resource Name (ARN) of the user or identity that overrode the rules and their requirements for the pull request.</p>', 'ListPullRequestsInput$authorArn' => '<p>Optional. The Amazon Resource Name (ARN) of the user who created the pull request. If used, this filters the results to pull requests created by that user.</p>', 'MergeMetadata$mergedBy' => '<p>The Amazon Resource Name (ARN) of the user who merged the branches.</p>', 'PullRequest$authorArn' => '<p>The Amazon Resource Name (ARN) of the user who created the pull request.</p>', 'PullRequestEvent$actorArn' => '<p>The Amazon Resource Name (ARN) of the user whose actions resulted in the event. Examples include updating the pull request with more commits or changing the status of a pull request.</p>', 'ReactionUsersList$member' => NULL, 'RepositoryMetadata$Arn' => '<p>The Amazon Resource Name (ARN) of the repository.</p>', 'RepositoryTrigger$destinationArn' => '<p>The ARN of the resource that is the target for a trigger (for example, the ARN of a topic in Amazon SNS).</p>', ], ], 'AssociateApprovalRuleTemplateWithRepositoryInput' => [ 'base' => NULL, 'refs' => [], ], 'AuthorDoesNotExistException' => [ 'base' => '<p>The specified Amazon Resource Name (ARN) does not exist in the AWS account.</p>', 'refs' => [], ], 'BatchAssociateApprovalRuleTemplateWithRepositoriesError' => [ 'base' => '<p>Returns information about errors in a BatchAssociateApprovalRuleTemplateWithRepositories operation.</p>', 'refs' => [ 'BatchAssociateApprovalRuleTemplateWithRepositoriesErrorsList$member' => NULL, ], ], 'BatchAssociateApprovalRuleTemplateWithRepositoriesErrorsList' => [ 'base' => NULL, 'refs' => [ 'BatchAssociateApprovalRuleTemplateWithRepositoriesOutput$errors' => '<p>A list of any errors that might have occurred while attempting to create the association between the template and the repositories.</p>', ], ], 'BatchAssociateApprovalRuleTemplateWithRepositoriesInput' => [ 'base' => NULL, 'refs' => [], ], 'BatchAssociateApprovalRuleTemplateWithRepositoriesOutput' => [ 'base' => NULL, 'refs' => [], ], 'BatchDescribeMergeConflictsError' => [ 'base' => '<p>Returns information about errors in a BatchDescribeMergeConflicts operation.</p>', 'refs' => [ 'BatchDescribeMergeConflictsErrors$member' => NULL, ], ], 'BatchDescribeMergeConflictsErrors' => [ 'base' => NULL, 'refs' => [ 'BatchDescribeMergeConflictsOutput$errors' => '<p>A list of any errors returned while describing the merge conflicts for each file.</p>', ], ], 'BatchDescribeMergeConflictsInput' => [ 'base' => NULL, 'refs' => [], ], 'BatchDescribeMergeConflictsOutput' => [ 'base' => NULL, 'refs' => [], ], 'BatchDisassociateApprovalRuleTemplateFromRepositoriesError' => [ 'base' => '<p>Returns information about errors in a BatchDisassociateApprovalRuleTemplateFromRepositories operation.</p>', 'refs' => [ 'BatchDisassociateApprovalRuleTemplateFromRepositoriesErrorsList$member' => NULL, ], ], 'BatchDisassociateApprovalRuleTemplateFromRepositoriesErrorsList' => [ 'base' => NULL, 'refs' => [ 'BatchDisassociateApprovalRuleTemplateFromRepositoriesOutput$errors' => '<p>A list of any errors that might have occurred while attempting to remove the association between the template and the repositories.</p>', ], ], 'BatchDisassociateApprovalRuleTemplateFromRepositoriesInput' => [ 'base' => NULL, 'refs' => [], ], 'BatchDisassociateApprovalRuleTemplateFromRepositoriesOutput' => [ 'base' => NULL, 'refs' => [], ], 'BatchGetCommitsError' => [ 'base' => '<p>Returns information about errors in a BatchGetCommits operation.</p>', 'refs' => [ 'BatchGetCommitsErrorsList$member' => NULL, ], ], 'BatchGetCommitsErrorsList' => [ 'base' => NULL, 'refs' => [ 'BatchGetCommitsOutput$errors' => '<p>Returns any commit IDs for which information could not be found. For example, if one of the commit IDs was a shortened SHA ID or that commit was not found in the specified repository, the ID returns an error object with more information.</p>', ], ], 'BatchGetCommitsInput' => [ 'base' => NULL, 'refs' => [], ], 'BatchGetCommitsOutput' => [ 'base' => NULL, 'refs' => [], ], 'BatchGetRepositoriesInput' => [ 'base' => '<p>Represents the input of a batch get repositories operation.</p>', 'refs' => [], ], 'BatchGetRepositoriesOutput' => [ 'base' => '<p>Represents the output of a batch get repositories operation.</p>', 'refs' => [], ], 'BeforeCommitIdAndAfterCommitIdAreSameException' => [ 'base' => '<p>The before commit ID and the after commit ID are the same, which is not valid. The before commit ID and the after commit ID must be different commit IDs.</p>', 'refs' => [], ], 'BlobIdDoesNotExistException' => [ 'base' => '<p>The specified blob does not exist.</p>', 'refs' => [], ], 'BlobIdRequiredException' => [ 'base' => '<p>A blob ID is required, but was not specified.</p>', 'refs' => [], ], 'BlobMetadata' => [ 'base' => '<p>Returns information about a specific Git blob object.</p>', 'refs' => [ 'Difference$beforeBlob' => '<p>Information about a <code>beforeBlob</code> data type object, including the ID, the file mode permission code, and the path.</p>', 'Difference$afterBlob' => '<p>Information about an <code>afterBlob</code> data type object, including the ID, the file mode permission code, and the path.</p>', ], ], 'BranchDoesNotExistException' => [ 'base' => '<p>The specified branch does not exist.</p>', 'refs' => [], ], 'BranchInfo' => [ 'base' => '<p>Returns information about a branch.</p>', 'refs' => [ 'DeleteBranchOutput$deletedBranch' => '<p>Information about the branch deleted by the operation, including the branch name and the commit ID that was the tip of the branch.</p>', 'GetBranchOutput$branch' => '<p>The name of the branch.</p>', ], ], 'BranchName' => [ 'base' => NULL, 'refs' => [ 'BranchInfo$branchName' => '<p>The name of the branch.</p>', 'BranchNameList$member' => NULL, 'CreateBranchInput$branchName' => '<p>The name of the new branch to create.</p>', 'CreateCommitInput$branchName' => '<p>The name of the branch where you create the commit.</p>', 'DeleteBranchInput$branchName' => '<p>The name of the branch to delete.</p>', 'DeleteFileInput$branchName' => '<p>The name of the branch where the commit that deletes the file is made.</p>', 'GetBranchInput$branchName' => '<p>The name of the branch for which you want to retrieve information.</p>', 'MergeBranchesByFastForwardInput$targetBranch' => '<p>The branch where the merge is applied.</p>', 'MergeBranchesBySquashInput$targetBranch' => '<p>The branch where the merge is applied. </p>', 'MergeBranchesByThreeWayInput$targetBranch' => '<p>The branch where the merge is applied. </p>', 'PutFileInput$branchName' => '<p>The name of the branch where you want to add or update the file. If this is an empty repository, this branch is created.</p>', 'RepositoryMetadata$defaultBranch' => '<p>The repository\'s default branch name.</p>', 'UpdateDefaultBranchInput$defaultBranchName' => '<p>The name of the branch to set as the default.</p>', ], ], 'BranchNameExistsException' => [ 'base' => '<p>Cannot create the branch with the specified name because the commit conflicts with an existing branch with the same name. Branch names must be unique.</p>', 'refs' => [], ], 'BranchNameIsTagNameException' => [ 'base' => '<p>The specified branch name is not valid because it is a tag name. Enter the name of a branch in the repository. For a list of valid branch names, use <a>ListBranches</a>.</p>', 'refs' => [], ], 'BranchNameList' => [ 'base' => NULL, 'refs' => [ 'ListBranchesOutput$branches' => '<p>The list of branch names.</p>', 'RepositoryTrigger$branches' => '<p>The branches to be included in the trigger configuration. If you specify an empty array, the trigger applies to all branches.</p> <note> <p>Although no content is required in the array, you must include the array itself.</p> </note>', ], ], 'BranchNameRequiredException' => [ 'base' => '<p>A branch name is required, but was not specified.</p>', 'refs' => [], ], 'CallerReactions' => [ 'base' => NULL, 'refs' => [ 'Comment$callerReactions' => '<p>The emoji reactions to a comment, if any, submitted by the user whose credentials are associated with the call to the API.</p>', ], ], 'CannotDeleteApprovalRuleFromTemplateException' => [ 'base' => '<p>The approval rule cannot be deleted from the pull request because it was created by an approval rule template and applied to the pull request automatically.</p>', 'refs' => [], ], 'CannotModifyApprovalRuleFromTemplateException' => [ 'base' => '<p>The approval rule cannot be modified for the pull request because it was created by an approval rule template and applied to the pull request automatically.</p>', 'refs' => [], ], 'CapitalBoolean' => [ 'base' => NULL, 'refs' => [ 'IsBinaryFile$source' => '<p>The binary or non-binary status of file in the source of a merge or pull request.</p>', 'IsBinaryFile$destination' => '<p>The binary or non-binary status of a file in the destination of a merge or pull request.</p>', 'IsBinaryFile$base' => '<p>The binary or non-binary status of a file in the base of a merge or pull request.</p>', ], ], 'ChangeTypeEnum' => [ 'base' => NULL, 'refs' => [ 'Difference$changeType' => '<p>Whether the change type of the difference is an addition (A), deletion (D), or modification (M).</p>', 'MergeOperations$source' => '<p>The operation (add, modify, or delete) on a file in the source of a merge or pull request.</p>', 'MergeOperations$destination' => '<p>The operation on a file in the destination of a merge or pull request.</p>', ], ], 'ClientRequestToken' => [ 'base' => NULL, 'refs' => [ 'Comment$clientRequestToken' => '<p>A unique, client-generated idempotency token that, when provided in a request, ensures the request cannot be repeated with a changed parameter. If a request is received with the same parameters and a token is included, the request returns information about the initial request that used that token.</p>', 'CreatePullRequestInput$clientRequestToken' => '<p>A unique, client-generated idempotency token that, when provided in a request, ensures the request cannot be repeated with a changed parameter. If a request is received with the same parameters and a token is included, the request returns information about the initial request that used that token.</p> <note> <p>The AWS SDKs prepopulate client request tokens. If you are using an AWS SDK, an idempotency token is created for you.</p> </note>', 'PostCommentForComparedCommitInput$clientRequestToken' => '<p>A unique, client-generated idempotency token that, when provided in a request, ensures the request cannot be repeated with a changed parameter. If a request is received with the same parameters and a token is included, the request returns information about the initial request that used that token.</p>', 'PostCommentForPullRequestInput$clientRequestToken' => '<p>A unique, client-generated idempotency token that, when provided in a request, ensures the request cannot be repeated with a changed parameter. If a request is received with the same parameters and a token is included, the request returns information about the initial request that used that token.</p>', 'PostCommentReplyInput$clientRequestToken' => '<p>A unique, client-generated idempotency token that, when provided in a request, ensures the request cannot be repeated with a changed parameter. If a request is received with the same parameters and a token is included, the request returns information about the initial request that used that token.</p>', 'PullRequest$clientRequestToken' => '<p>A unique, client-generated idempotency token that, when provided in a request, ensures the request cannot be repeated with a changed parameter. If a request is received with the same parameters and a token is included, the request returns information about the initial request that used that token.</p>', ], ], 'ClientRequestTokenRequiredException' => [ 'base' => '<p>A client request token is required. A client request token is an unique, client-generated idempotency token that, when provided in a request, ensures the request cannot be repeated with a changed parameter. If a request is received with the same parameters and a token is included, the request returns information about the initial request that used that token.</p>', 'refs' => [], ], 'CloneUrlHttp' => [ 'base' => NULL, 'refs' => [ 'RepositoryMetadata$cloneUrlHttp' => '<p>The URL to use for cloning the repository over HTTPS.</p>', ], ], 'CloneUrlSsh' => [ 'base' => NULL, 'refs' => [ 'RepositoryMetadata$cloneUrlSsh' => '<p>The URL to use for cloning the repository over SSH.</p>', ], ], 'Comment' => [ 'base' => '<p>Returns information about a specific comment.</p>', 'refs' => [ 'Comments$member' => NULL, 'DeleteCommentContentOutput$comment' => '<p>Information about the comment you just deleted.</p>', 'GetCommentOutput$comment' => '<p>The contents of the comment.</p>', 'PostCommentForComparedCommitOutput$comment' => '<p>The content of the comment you posted.</p>', 'PostCommentForPullRequestOutput$comment' => '<p>The content of the comment you posted.</p>', 'PostCommentReplyOutput$comment' => '<p>Information about the reply to a comment.</p>', 'UpdateCommentOutput$comment' => '<p>Information about the updated comment.</p>', ], ], 'CommentContentRequiredException' => [ 'base' => '<p>The comment is empty. You must provide some content for a comment. The content cannot be null.</p>', 'refs' => [], ], 'CommentContentSizeLimitExceededException' => [ 'base' => '<p>The comment is too large. Comments are limited to 1,000 characters.</p>', 'refs' => [], ], 'CommentDeletedException' => [ 'base' => '<p>This comment has already been deleted. You cannot edit or delete a deleted comment.</p>', 'refs' => [], ], 'CommentDoesNotExistException' => [ 'base' => '<p>No comment exists with the provided ID. Verify that you have used the correct ID, and then try again.</p>', 'refs' => [], ], 'CommentId' => [ 'base' => NULL, 'refs' => [ 'Comment$commentId' => '<p>The system-generated comment ID.</p>', 'Comment$inReplyTo' => '<p>The ID of the comment for which this comment is a reply, if any.</p>', 'DeleteCommentContentInput$commentId' => '<p>The unique, system-generated ID of the comment. To get this ID, use <a>GetCommentsForComparedCommit</a> or <a>GetCommentsForPullRequest</a>.</p>', 'GetCommentInput$commentId' => '<p>The unique, system-generated ID of the comment. To get this ID, use <a>GetCommentsForComparedCommit</a> or <a>GetCommentsForPullRequest</a>.</p>', 'GetCommentReactionsInput$commentId' => '<p>The ID of the comment for which you want to get reactions information.</p>', 'PostCommentReplyInput$inReplyTo' => '<p>The system-generated ID of the comment to which you want to reply. To get this ID, use <a>GetCommentsForComparedCommit</a> or <a>GetCommentsForPullRequest</a>.</p>', 'PutCommentReactionInput$commentId' => '<p>The ID of the comment to which you want to add or update a reaction.</p>', 'UpdateCommentInput$commentId' => '<p>The system-generated ID of the comment you want to update. To get this ID, use <a>GetCommentsForComparedCommit</a> or <a>GetCommentsForPullRequest</a>.</p>', ], ], 'CommentIdRequiredException' => [ 'base' => '<p>The comment ID is missing or null. A comment ID is required.</p>', 'refs' => [], ], 'CommentNotCreatedByCallerException' => [ 'base' => '<p>You cannot modify or delete this comment. Only comment authors can modify or delete their comments.</p>', 'refs' => [], ], 'Comments' => [ 'base' => NULL, 'refs' => [ 'CommentsForComparedCommit$comments' => '<p>An array of comment objects. Each comment object contains information about a comment on the comparison between commits.</p>', 'CommentsForPullRequest$comments' => '<p>An array of comment objects. Each comment object contains information about a comment on the pull request.</p>', ], ], 'CommentsForComparedCommit' => [ 'base' => '<p>Returns information about comments on the comparison between two commits.</p>', 'refs' => [ 'CommentsForComparedCommitData$member' => NULL, ], ], 'CommentsForComparedCommitData' => [ 'base' => NULL, 'refs' => [ 'GetCommentsForComparedCommitOutput$commentsForComparedCommitData' => '<p>A list of comment objects on the compared commit.</p>', ], ], 'CommentsForPullRequest' => [ 'base' => '<p>Returns information about comments on a pull request.</p>', 'refs' => [ 'CommentsForPullRequestData$member' => NULL, ], ], 'CommentsForPullRequestData' => [ 'base' => NULL, 'refs' => [ 'GetCommentsForPullRequestOutput$commentsForPullRequestData' => '<p>An array of comment objects on the pull request.</p>', ], ], 'Commit' => [ 'base' => '<p>Returns information about a specific commit.</p>', 'refs' => [ 'CommitObjectsList$member' => NULL, 'GetCommitOutput$commit' => '<p>A commit data type object that contains information about the specified commit.</p>', ], ], 'CommitDoesNotExistException' => [ 'base' => '<p>The specified commit does not exist or no commit was specified, and the specified repository has no default branch.</p>', 'refs' => [], ], 'CommitId' => [ 'base' => NULL, 'refs' => [ 'BranchInfo$commitId' => '<p>The ID of the last commit made to the branch.</p>', 'CommentsForComparedCommit$beforeCommitId' => '<p>The full commit ID of the commit used to establish the before of the comparison.</p>', 'CommentsForComparedCommit$afterCommitId' => '<p>The full commit ID of the commit used to establish the after of the comparison.</p>', 'CommentsForPullRequest$beforeCommitId' => '<p>The full commit ID of the commit that was the tip of the destination branch when the pull request was created. This commit is superceded by the after commit in the source branch when and if you merge the source branch into the destination branch.</p>', 'CommentsForPullRequest$afterCommitId' => '<p>The full commit ID of the commit that was the tip of the source branch at the time the comment was made. </p>', 'CreateBranchInput$commitId' => '<p>The ID of the commit to point the new branch to.</p>', 'CreateCommitInput$parentCommitId' => '<p>The ID of the commit that is the parent of the commit you create. Not required if this is an empty repository.</p>', 'DeleteFileInput$parentCommitId' => '<p>The ID of the commit that is the tip of the branch where you want to create the commit that deletes the file. This must be the HEAD commit for the branch. The commit that deletes the file is created from this commit ID.</p>', 'GetCommentsForComparedCommitInput$beforeCommitId' => '<p>To establish the directionality of the comparison, the full commit ID of the before commit.</p>', 'GetCommentsForComparedCommitInput$afterCommitId' => '<p>To establish the directionality of the comparison, the full commit ID of the after commit.</p>', 'GetCommentsForPullRequestInput$beforeCommitId' => '<p>The full commit ID of the commit in the destination branch that was the tip of the branch at the time the pull request was created.</p>', 'GetCommentsForPullRequestInput$afterCommitId' => '<p>The full commit ID of the commit in the source branch that was the tip of the branch at the time the comment was made.</p>', 'MergeMetadata$mergeCommitId' => '<p>The commit ID for the merge commit, if any.</p>', 'PostCommentForComparedCommitInput$beforeCommitId' => '<p>To establish the directionality of the comparison, the full commit ID of the before commit. Required for commenting on any commit unless that commit is the initial commit.</p>', 'PostCommentForComparedCommitInput$afterCommitId' => '<p>To establish the directionality of the comparison, the full commit ID of the after commit.</p>', 'PostCommentForComparedCommitOutput$beforeCommitId' => '<p>In the directionality you established, the full commit ID of the before commit.</p>', 'PostCommentForComparedCommitOutput$afterCommitId' => '<p>In the directionality you established, the full commit ID of the after commit.</p>', 'PostCommentForPullRequestInput$beforeCommitId' => '<p>The full commit ID of the commit in the destination branch that was the tip of the branch at the time the pull request was created.</p>', 'PostCommentForPullRequestInput$afterCommitId' => '<p>The full commit ID of the commit in the source branch that is the current tip of the branch for the pull request when you post the comment.</p>', 'PostCommentForPullRequestOutput$beforeCommitId' => '<p>The full commit ID of the commit in the source branch used to create the pull request, or in the case of an updated pull request, the full commit ID of the commit used to update the pull request.</p>', 'PostCommentForPullRequestOutput$afterCommitId' => '<p>The full commit ID of the commit in the destination branch where the pull request is merged.</p>', 'PullRequestCreatedEventMetadata$sourceCommitId' => '<p>The commit ID on the source branch used when the pull request was created.</p>', 'PullRequestCreatedEventMetadata$destinationCommitId' => '<p>The commit ID of the tip of the branch specified as the destination branch when the pull request was created.</p>', 'PullRequestCreatedEventMetadata$mergeBase' => '<p>The commit ID of the most recent commit that the source branch and the destination branch have in common.</p>', 'PullRequestSourceReferenceUpdatedEventMetadata$beforeCommitId' => '<p>The full commit ID of the commit in the destination branch that was the tip of the branch at the time the pull request was updated.</p>', 'PullRequestSourceReferenceUpdatedEventMetadata$afterCommitId' => '<p>The full commit ID of the commit in the source branch that was the tip of the branch at the time the pull request was updated.</p>', 'PullRequestSourceReferenceUpdatedEventMetadata$mergeBase' => '<p>The commit ID of the most recent commit that the source branch and the destination branch have in common.</p>', 'PullRequestTarget$destinationCommit' => '<p>The full commit ID that is the tip of the destination branch. This is the commit where the pull request was or will be merged.</p>', 'PullRequestTarget$sourceCommit' => '<p>The full commit ID of the tip of the source branch used to create the pull request. If the pull request branch is updated by a push while the pull request is open, the commit ID changes to reflect the new tip of the branch.</p>', 'PullRequestTarget$mergeBase' => '<p>The commit ID of the most recent commit that the source branch and the destination branch have in common.</p>', 'PutFileInput$parentCommitId' => '<p>The full commit ID of the head commit in the branch where you want to add or update the file. If this is an empty repository, no commit ID is required. If this is not an empty repository, a commit ID is required. </p> <p>The commit ID must match the ID of the head commit at the time of the operation. Otherwise, an error occurs, and the file is not added or updated.</p>', ], ], 'CommitIdDoesNotExistException' => [ 'base' => '<p>The specified commit ID does not exist.</p>', 'refs' => [], ], 'CommitIdRequiredException' => [ 'base' => '<p>A commit ID was not specified.</p>', 'refs' => [], ], 'CommitIdsInputList' => [ 'base' => NULL, 'refs' => [ 'BatchGetCommitsInput$commitIds' => '<p>The full commit IDs of the commits to get information about.</p> <note> <p>You must supply the full SHA IDs of each commit. You cannot use shortened SHA IDs.</p> </note>', ], ], 'CommitIdsLimitExceededException' => [ 'base' => '<p>The maximum number of allowed commit IDs in a batch request is 100. Verify that your batch requests contains no more than 100 commit IDs, and then try again.</p>', 'refs' => [], ], 'CommitIdsListRequiredException' => [ 'base' => '<p>A list of commit IDs is required, but was either not specified or the list was empty.</p>', 'refs' => [], ], 'CommitMessageLengthExceededException' => [ 'base' => '<p>The commit message is too long. Provide a shorter string. </p>', 'refs' => [], ], 'CommitName' => [ 'base' => NULL, 'refs' => [ 'BatchDescribeMergeConflictsInput$destinationCommitSpecifier' => '<p>The branch, tag, HEAD, or other fully qualified reference used to identify a commit (for example, a branch name or a full commit ID).</p>', 'BatchDescribeMergeConflictsInput$sourceCommitSpecifier' => '<p>The branch, tag, HEAD, or other fully qualified reference used to identify a commit (for example, a branch name or a full commit ID).</p>', 'CreateUnreferencedMergeCommitInput$sourceCommitSpecifier' => '<p>The branch, tag, HEAD, or other fully qualified reference used to identify a commit (for example, a branch name or a full commit ID).</p>', 'CreateUnreferencedMergeCommitInput$destinationCommitSpecifier' => '<p>The branch, tag, HEAD, or other fully qualified reference used to identify a commit (for example, a branch name or a full commit ID).</p>', 'DescribeMergeConflictsInput$destinationCommitSpecifier' => '<p>The branch, tag, HEAD, or other fully qualified reference used to identify a commit (for example, a branch name or a full commit ID).</p>', 'DescribeMergeConflictsInput$sourceCommitSpecifier' => '<p>The branch, tag, HEAD, or other fully qualified reference used to identify a commit (for example, a branch name or a full commit ID).</p>', 'GetDifferencesInput$beforeCommitSpecifier' => '<p>The branch, tag, HEAD, or other fully qualified reference used to identify a commit (for example, the full commit ID). Optional. If not specified, all changes before the <code>afterCommitSpecifier</code> value are shown. If you do not use <code>beforeCommitSpecifier</code> in your request, consider limiting the results with <code>maxResults</code>.</p>', 'GetDifferencesInput$afterCommitSpecifier' => '<p>The branch, tag, HEAD, or other fully qualified reference used to identify a commit.</p>', 'GetFileInput$commitSpecifier' => '<p>The fully quaified reference that identifies the commit that contains the file. For example, you can specify a full commit ID, a tag, a branch name, or a reference such as refs/heads/master. If none is provided, the head commit is used.</p>', 'GetFolderInput$commitSpecifier' => '<p>A fully qualified reference used to identify a commit that contains the version of the folder\'s content to return. A fully qualified reference can be a commit ID, branch name, tag, or reference such as HEAD. If no specifier is provided, the folder content is returned as it exists in the HEAD commit.</p>', 'GetMergeCommitInput$sourceCommitSpecifier' => '<p>The branch, tag, HEAD, or other fully qualified reference used to identify a commit (for example, a branch name or a full commit ID).</p>', 'GetMergeCommitInput$destinationCommitSpecifier' => '<p>The branch, tag, HEAD, or other fully qualified reference used to identify a commit (for example, a branch name or a full commit ID).</p>', 'GetMergeConflictsInput$destinationCommitSpecifier' => '<p>The branch, tag, HEAD, or other fully qualified reference used to identify a commit (for example, a branch name or a full commit ID).</p>', 'GetMergeConflictsInput$sourceCommitSpecifier' => '<p>The branch, tag, HEAD, or other fully qualified reference used to identify a commit (for example, a branch name or a full commit ID).</p>', 'GetMergeOptionsInput$sourceCommitSpecifier' => '<p>The branch, tag, HEAD, or other fully qualified reference used to identify a commit (for example, a branch name or a full commit ID).</p>', 'GetMergeOptionsInput$destinationCommitSpecifier' => '<p>The branch, tag, HEAD, or other fully qualified reference used to identify a commit (for example, a branch name or a full commit ID).</p>', 'MergeBranchesByFastForwardInput$sourceCommitSpecifier' => '<p>The branch, tag, HEAD, or other fully qualified reference used to identify a commit (for example, a branch name or a full commit ID).</p>', 'MergeBranchesByFastForwardInput$destinationCommitSpecifier' => '<p>The branch, tag, HEAD, or other fully qualified reference used to identify a commit (for example, a branch name or a full commit ID).</p>', 'MergeBranchesBySquashInput$sourceCommitSpecifier' => '<p>The branch, tag, HEAD, or other fully qualified reference used to identify a commit (for example, a branch name or a full commit ID).</p>', 'MergeBranchesBySquashInput$destinationCommitSpecifier' => '<p>The branch, tag, HEAD, or other fully qualified reference used to identify a commit (for example, a branch name or a full commit ID).</p>', 'MergeBranchesByThreeWayInput$sourceCommitSpecifier' => '<p>The branch, tag, HEAD, or other fully qualified reference used to identify a commit (for example, a branch name or a full commit ID).</p>', 'MergeBranchesByThreeWayInput$destinationCommitSpecifier' => '<p>The branch, tag, HEAD, or other fully qualified reference used to identify a commit (for example, a branch name or a full commit ID).</p>', ], ], 'CommitObjectsList' => [ 'base' => NULL, 'refs' => [ 'BatchGetCommitsOutput$commits' => '<p>An array of commit data type objects, each of which contains information about a specified commit.</p>', ], ], 'CommitRequiredException' => [ 'base' => '<p>A commit was not specified.</p>', 'refs' => [], ], 'ConcurrentReferenceUpdateException' => [ 'base' => '<p>The merge cannot be completed because the target branch has been modified. Another user might have modified the target branch while the merge was in progress. Wait a few minutes, and then try again.</p>', 'refs' => [], ], 'Conflict' => [ 'base' => '<p>Information about conflicts in a merge operation.</p>', 'refs' => [ 'Conflicts$member' => NULL, ], ], 'ConflictDetailLevelTypeEnum' => [ 'base' => NULL, 'refs' => [ 'BatchDescribeMergeConflictsInput$conflictDetailLevel' => '<p>The level of conflict detail to use. If unspecified, the default FILE_LEVEL is used, which returns a not-mergeable result if the same file has differences in both branches. If LINE_LEVEL is specified, a conflict is considered not mergeable if the same file in both branches has differences on the same line.</p>', 'CreateUnreferencedMergeCommitInput$conflictDetailLevel' => '<p>The level of conflict detail to use. If unspecified, the default FILE_LEVEL is used, which returns a not-mergeable result if the same file has differences in both branches. If LINE_LEVEL is specified, a conflict is considered not mergeable if the same file in both branches has differences on the same line.</p>', 'DescribeMergeConflictsInput$conflictDetailLevel' => '<p>The level of conflict detail to use. If unspecified, the default FILE_LEVEL is used, which returns a not-mergeable result if the same file has differences in both branches. If LINE_LEVEL is specified, a conflict is considered not mergeable if the same file in both branches has differences on the same line.</p>', 'GetMergeCommitInput$conflictDetailLevel' => '<p>The level of conflict detail to use. If unspecified, the default FILE_LEVEL is used, which returns a not-mergeable result if the same file has differences in both branches. If LINE_LEVEL is specified, a conflict is considered not mergeable if the same file in both branches has differences on the same line.</p>', 'GetMergeConflictsInput$conflictDetailLevel' => '<p>The level of conflict detail to use. If unspecified, the default FILE_LEVEL is used, which returns a not-mergeable result if the same file has differences in both branches. If LINE_LEVEL is specified, a conflict is considered not mergeable if the same file in both branches has differences on the same line.</p>', 'GetMergeOptionsInput$conflictDetailLevel' => '<p>The level of conflict detail to use. If unspecified, the default FILE_LEVEL is used, which returns a not-mergeable result if the same file has differences in both branches. If LINE_LEVEL is specified, a conflict is considered not mergeable if the same file in both branches has differences on the same line.</p>', 'MergeBranchesBySquashInput$conflictDetailLevel' => '<p>The level of conflict detail to use. If unspecified, the default FILE_LEVEL is used, which returns a not-mergeable result if the same file has differences in both branches. If LINE_LEVEL is specified, a conflict is considered not mergeable if the same file in both branches has differences on the same line.</p>', 'MergeBranchesByThreeWayInput$conflictDetailLevel' => '<p>The level of conflict detail to use. If unspecified, the default FILE_LEVEL is used, which returns a not-mergeable result if the same file has differences in both branches. If LINE_LEVEL is specified, a conflict is considered not mergeable if the same file in both branches has differences on the same line.</p>', 'MergePullRequestBySquashInput$conflictDetailLevel' => '<p>The level of conflict detail to use. If unspecified, the default FILE_LEVEL is used, which returns a not-mergeable result if the same file has differences in both branches. If LINE_LEVEL is specified, a conflict is considered not mergeable if the same file in both branches has differences on the same line.</p>', 'MergePullRequestByThreeWayInput$conflictDetailLevel' => '<p>The level of conflict detail to use. If unspecified, the default FILE_LEVEL is used, which returns a not-mergeable result if the same file has differences in both branches. If LINE_LEVEL is specified, a conflict is considered not mergeable if the same file in both branches has differences on the same line.</p>', ], ], 'ConflictMetadata' => [ 'base' => '<p>Information about the metadata for a conflict in a merge operation.</p>', 'refs' => [ 'Conflict$conflictMetadata' => '<p>Metadata about a conflict in a merge operation.</p>', 'ConflictMetadataList$member' => NULL, 'DescribeMergeConflictsOutput$conflictMetadata' => '<p>Contains metadata about the conflicts found in the merge.</p>', ], ], 'ConflictMetadataList' => [ 'base' => NULL, 'refs' => [ 'GetMergeConflictsOutput$conflictMetadataList' => '<p>A list of metadata for any conflicting files. If the specified merge strategy is FAST_FORWARD_MERGE, this list is always empty.</p>', ], ], 'ConflictResolution' => [ 'base' => '<p>If AUTOMERGE is the conflict resolution strategy, a list of inputs to use when resolving conflicts during a merge.</p>', 'refs' => [ 'CreateUnreferencedMergeCommitInput$conflictResolution' => '<p>If AUTOMERGE is the conflict resolution strategy, a list of inputs to use when resolving conflicts during a merge.</p>', 'MergeBranchesBySquashInput$conflictResolution' => '<p>If AUTOMERGE is the conflict resolution strategy, a list of inputs to use when resolving conflicts during a merge.</p>', 'MergeBranchesByThreeWayInput$conflictResolution' => '<p>If AUTOMERGE is the conflict resolution strategy, a list of inputs to use when resolving conflicts during a merge.</p>', 'MergePullRequestBySquashInput$conflictResolution' => '<p>If AUTOMERGE is the conflict resolution strategy, a list of inputs to use when resolving conflicts during a merge.</p>', 'MergePullRequestByThreeWayInput$conflictResolution' => '<p>If AUTOMERGE is the conflict resolution strategy, a list of inputs to use when resolving conflicts during a merge.</p>', ], ], 'ConflictResolutionStrategyTypeEnum' => [ 'base' => NULL, 'refs' => [ 'BatchDescribeMergeConflictsInput$conflictResolutionStrategy' => '<p>Specifies which branch to use when resolving conflicts, or whether to attempt automatically merging two versions of a file. The default is NONE, which requires any conflicts to be resolved manually before the merge operation is successful.</p>', 'CreateUnreferencedMergeCommitInput$conflictResolutionStrategy' => '<p>Specifies which branch to use when resolving conflicts, or whether to attempt automatically merging two versions of a file. The default is NONE, which requires any conflicts to be resolved manually before the merge operation is successful.</p>', 'DescribeMergeConflictsInput$conflictResolutionStrategy' => '<p>Specifies which branch to use when resolving conflicts, or whether to attempt automatically merging two versions of a file. The default is NONE, which requires any conflicts to be resolved manually before the merge operation is successful.</p>', 'GetMergeCommitInput$conflictResolutionStrategy' => '<p>Specifies which branch to use when resolving conflicts, or whether to attempt automatically merging two versions of a file. The default is NONE, which requires any conflicts to be resolved manually before the merge operation is successful.</p>', 'GetMergeConflictsInput$conflictResolutionStrategy' => '<p>Specifies which branch to use when resolving conflicts, or whether to attempt automatically merging two versions of a file. The default is NONE, which requires any conflicts to be resolved manually before the merge operation is successful.</p>', 'GetMergeOptionsInput$conflictResolutionStrategy' => '<p>Specifies which branch to use when resolving conflicts, or whether to attempt automatically merging two versions of a file. The default is NONE, which requires any conflicts to be resolved manually before the merge operation is successful.</p>', 'MergeBranchesBySquashInput$conflictResolutionStrategy' => '<p>Specifies which branch to use when resolving conflicts, or whether to attempt automatically merging two versions of a file. The default is NONE, which requires any conflicts to be resolved manually before the merge operation is successful.</p>', 'MergeBranchesByThreeWayInput$conflictResolutionStrategy' => '<p>Specifies which branch to use when resolving conflicts, or whether to attempt automatically merging two versions of a file. The default is NONE, which requires any conflicts to be resolved manually before the merge operation is successful.</p>', 'MergePullRequestBySquashInput$conflictResolutionStrategy' => '<p>Specifies which branch to use when resolving conflicts, or whether to attempt automatically merging two versions of a file. The default is NONE, which requires any conflicts to be resolved manually before the merge operation is successful.</p>', 'MergePullRequestByThreeWayInput$conflictResolutionStrategy' => '<p>Specifies which branch to use when resolving conflicts, or whether to attempt automatically merging two versions of a file. The default is NONE, which requires any conflicts to be resolved manually before the merge operation is successful.</p>', ], ], 'Conflicts' => [ 'base' => NULL, 'refs' => [ 'BatchDescribeMergeConflictsOutput$conflicts' => '<p>A list of conflicts for each file, including the conflict metadata and the hunks of the differences between the files.</p>', ], ], 'Content' => [ 'base' => NULL, 'refs' => [ 'Comment$content' => '<p>The content of the comment.</p>', 'PostCommentForComparedCommitInput$content' => '<p>The content of the comment you want to make.</p>', 'PostCommentForPullRequestInput$content' => '<p>The content of your comment on the change.</p>', 'PostCommentReplyInput$content' => '<p>The contents of your reply to a comment.</p>', 'UpdateCommentInput$content' => '<p>The updated content to replace the existing content of the comment.</p>', ], ], 'Count' => [ 'base' => NULL, 'refs' => [ 'ReactionCountsMap$value' => NULL, 'ReactionForComment$reactionsFromDeletedUsersCount' => '<p>A numerical count of users who reacted with the specified emoji whose identities have been subsequently deleted from IAM. While these IAM users or roles no longer exist, the reactions might still appear in total reaction counts.</p>', ], ], 'CreateApprovalRuleTemplateInput' => [ 'base' => NULL, 'refs' => [], ], 'CreateApprovalRuleTemplateOutput' => [ 'base' => NULL, 'refs' => [], ], 'CreateBranchInput' => [ 'base' => '<p>Represents the input of a create branch operation.</p>', 'refs' => [], ], 'CreateCommitInput' => [ 'base' => NULL, 'refs' => [], ], 'CreateCommitOutput' => [ 'base' => NULL, 'refs' => [], ], 'CreatePullRequestApprovalRuleInput' => [ 'base' => NULL, 'refs' => [], ], 'CreatePullRequestApprovalRuleOutput' => [ 'base' => NULL, 'refs' => [], ], 'CreatePullRequestInput' => [ 'base' => NULL, 'refs' => [], ], 'CreatePullRequestOutput' => [ 'base' => NULL, 'refs' => [], ], 'CreateRepositoryInput' => [ 'base' => '<p>Represents the input of a create repository operation.</p>', 'refs' => [], ], 'CreateRepositoryOutput' => [ 'base' => '<p>Represents the output of a create repository operation.</p>', 'refs' => [], ], 'CreateUnreferencedMergeCommitInput' => [ 'base' => NULL, 'refs' => [], ], 'CreateUnreferencedMergeCommitOutput' => [ 'base' => NULL, 'refs' => [], ], 'CreationDate' => [ 'base' => NULL, 'refs' => [ 'ApprovalRule$creationDate' => '<p>The date the approval rule was created, in timestamp format.</p>', 'ApprovalRuleTemplate$creationDate' => '<p>The date the approval rule template was created, in timestamp format.</p>', 'Comment$creationDate' => '<p>The date and time the comment was created, in timestamp format.</p>', 'PullRequest$creationDate' => '<p>The date and time the pull request was originally created, in timestamp format.</p>', 'RepositoryMetadata$creationDate' => '<p>The date and time the repository was created, in timestamp format.</p>', ], ], 'Date' => [ 'base' => NULL, 'refs' => [ 'UserInfo$date' => '<p>The date when the specified commit was commited, in timestamp format with GMT offset.</p>', ], ], 'DefaultBranchCannotBeDeletedException' => [ 'base' => '<p>The specified branch is the default branch for the repository, and cannot be deleted. To delete this branch, you must first set another branch as the default branch.</p>', 'refs' => [], ], 'DeleteApprovalRuleTemplateInput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteApprovalRuleTemplateOutput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteBranchInput' => [ 'base' => '<p>Represents the input of a delete branch operation.</p>', 'refs' => [], ], 'DeleteBranchOutput' => [ 'base' => '<p>Represents the output of a delete branch operation.</p>', 'refs' => [], ], 'DeleteCommentContentInput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteCommentContentOutput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteFileEntries' => [ 'base' => NULL, 'refs' => [ 'ConflictResolution$deleteFiles' => '<p>Files to be deleted as part of the merge conflict resolution.</p>', 'CreateCommitInput$deleteFiles' => '<p>The files to delete in this commit. These files still exist in earlier commits.</p>', ], ], 'DeleteFileEntry' => [ 'base' => '<p>A file that is deleted as part of a commit.</p>', 'refs' => [ 'DeleteFileEntries$member' => NULL, ], ], 'DeleteFileInput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteFileOutput' => [ 'base' => NULL, 'refs' => [], ], 'DeletePullRequestApprovalRuleInput' => [ 'base' => NULL, 'refs' => [], ], 'DeletePullRequestApprovalRuleOutput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteRepositoryInput' => [ 'base' => '<p>Represents the input of a delete repository operation.</p>', 'refs' => [], ], 'DeleteRepositoryOutput' => [ 'base' => '<p>Represents the output of a delete repository operation.</p>', 'refs' => [], ], 'DescribeMergeConflictsInput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeMergeConflictsOutput' => [ 'base' => NULL, 'refs' => [], ], 'DescribePullRequestEventsInput' => [ 'base' => NULL, 'refs' => [], ], 'DescribePullRequestEventsOutput' => [ 'base' => NULL, 'refs' => [], ], 'Description' => [ 'base' => NULL, 'refs' => [ 'CreatePullRequestInput$description' => '<p>A description of the pull request.</p>', 'PullRequest$description' => '<p>The user-defined description of the pull request. This description can be used to clarify what should be reviewed and other details of the request.</p>', 'UpdatePullRequestDescriptionInput$description' => '<p>The updated content of the description for the pull request. This content replaces the existing description.</p>', ], ], 'Difference' => [ 'base' => '<p>Returns information about a set of differences for a commit specifier.</p>', 'refs' => [ 'DifferenceList$member' => NULL, ], ], 'DifferenceList' => [ 'base' => NULL, 'refs' => [ 'GetDifferencesOutput$differences' => '<p>A data type object that contains information about the differences, including whether the difference is added, modified, or deleted (A, D, M).</p>', ], ], 'DirectoryNameConflictsWithFileNameException' => [ 'base' => '<p>A file cannot be added to the repository because the specified path name has the same name as a file that already exists in this repository. Either provide a different name for the file, or specify a different path for the file.</p>', 'refs' => [], ], 'DisassociateApprovalRuleTemplateFromRepositoryInput' => [ 'base' => NULL, 'refs' => [], ], 'Email' => [ 'base' => NULL, 'refs' => [ 'CreateCommitInput$email' => '<p>The email address of the person who created the commit.</p>', 'CreateUnreferencedMergeCommitInput$email' => '<p>The email address for the person who created the unreferenced commit.</p>', 'DeleteFileInput$email' => '<p>The email address for the commit that deletes the file. If no email address is specified, the email address is left blank.</p>', 'MergeBranchesBySquashInput$email' => '<p>The email address of the person merging the branches. This information is used in the commit information for the merge.</p>', 'MergeBranchesByThreeWayInput$email' => '<p>The email address of the person merging the branches. This information is used in the commit information for the merge.</p>', 'MergePullRequestBySquashInput$email' => '<p>The email address of the person merging the branches. This information is used in the commit information for the merge.</p>', 'MergePullRequestByThreeWayInput$email' => '<p>The email address of the person merging the branches. This information is used in the commit information for the merge.</p>', 'PutFileInput$email' => '<p>An email address for the person adding or updating the file.</p>', 'UserInfo$email' => '<p>The email address associated with the user who made the commit, if any.</p>', ], ], 'EncryptionIntegrityChecksFailedException' => [ 'base' => '<p>An encryption integrity check failed.</p>', 'refs' => [], ], 'EncryptionKeyAccessDeniedException' => [ 'base' => '<p>An encryption key could not be accessed.</p>', 'refs' => [], ], 'EncryptionKeyDisabledException' => [ 'base' => '<p>The encryption key is disabled.</p>', 'refs' => [], ], 'EncryptionKeyNotFoundException' => [ 'base' => '<p>No encryption key was found.</p>', 'refs' => [], ], 'EncryptionKeyUnavailableException' => [ 'base' => '<p>The encryption key is not available.</p>', 'refs' => [], ], 'ErrorCode' => [ 'base' => NULL, 'refs' => [ 'BatchAssociateApprovalRuleTemplateWithRepositoriesError$errorCode' => '<p>An error code that specifies whether the repository name was not valid or not found.</p>', 'BatchDisassociateApprovalRuleTemplateFromRepositoriesError$errorCode' => '<p>An error code that specifies whether the repository name was not valid or not found.</p>', 'BatchGetCommitsError$errorCode' => '<p>An error code that specifies whether the commit ID was not valid or not found.</p>', ], ], 'ErrorMessage' => [ 'base' => NULL, 'refs' => [ 'BatchAssociateApprovalRuleTemplateWithRepositoriesError$errorMessage' => '<p>An error message that provides details about why the repository name was not found or not valid.</p>', 'BatchDisassociateApprovalRuleTemplateFromRepositoriesError$errorMessage' => '<p>An error message that provides details about why the repository name was either not found or not valid.</p>', 'BatchGetCommitsError$errorMessage' => '<p>An error message that provides detail about why the commit ID either was not found or was not valid.</p>', ], ], 'EvaluatePullRequestApprovalRulesInput' => [ 'base' => NULL, 'refs' => [], ], 'EvaluatePullRequestApprovalRulesOutput' => [ 'base' => NULL, 'refs' => [], ], 'Evaluation' => [ 'base' => '<p>Returns information about the approval rules applied to a pull request and whether conditions have been met.</p>', 'refs' => [ 'EvaluatePullRequestApprovalRulesOutput$evaluation' => '<p>The result of the evaluation, including the names of the rules whose conditions have been met (if any), the names of the rules whose conditions have not been met (if any), whether the pull request is in the approved state, and whether the pull request approval rule has been set aside by an override. </p>', ], ], 'EventDate' => [ 'base' => NULL, 'refs' => [ 'PullRequestEvent$eventDate' => '<p>The day and time of the pull request event, in timestamp format.</p>', ], ], 'ExceptionName' => [ 'base' => NULL, 'refs' => [ 'BatchDescribeMergeConflictsError$exceptionName' => '<p>The name of the exception.</p>', ], ], 'File' => [ 'base' => '<p>Returns information about a file in a repository.</p>', 'refs' => [ 'FileList$member' => NULL, ], ], 'FileContent' => [ 'base' => NULL, 'refs' => [ 'GetFileOutput$fileContent' => '<p>The base-64 encoded binary data object that represents the content of the file.</p>', 'PutFileEntry$fileContent' => '<p>The content of the file, if a source file is not specified.</p>', 'PutFileInput$fileContent' => '<p>The content of the file, in binary object format. </p>', 'ReplaceContentEntry$content' => '<p>The base-64 encoded content to use when the replacement type is USE_NEW_CONTENT.</p>', ], ], 'FileContentAndSourceFileSpecifiedException' => [ 'base' => '<p>The commit cannot be created because both a source file and file content have been specified for the same file. You cannot provide both. Either specify a source file or provide the file content directly.</p>', 'refs' => [], ], 'FileContentRequiredException' => [ 'base' => '<p>The file cannot be added because it is empty. Empty files cannot be added to the repository with this API.</p>', 'refs' => [], ], 'FileContentSizeLimitExceededException' => [ 'base' => '<p>The file cannot be added because it is too large. The maximum file size is 6 MB, and the combined file content change size is 7 MB. Consider making these changes using a Git client.</p>', 'refs' => [], ], 'FileDoesNotExistException' => [ 'base' => '<p>The specified file does not exist. Verify that you have used the correct file name, full path, and extension.</p>', 'refs' => [], ], 'FileEntryRequiredException' => [ 'base' => '<p>The commit cannot be created because no files have been specified as added, updated, or changed (PutFile or DeleteFile) for the commit.</p>', 'refs' => [], ], 'FileList' => [ 'base' => NULL, 'refs' => [ 'GetFolderOutput$files' => '<p>The list of files in the specified folder, if any.</p>', ], ], 'FileMetadata' => [ 'base' => '<p>A file to be added, updated, or deleted as part of a commit.</p>', 'refs' => [ 'FilesMetadata$member' => NULL, ], ], 'FileModeRequiredException' => [ 'base' => '<p>The commit cannot be created because no file mode has been specified. A file mode is required to update mode permissions for a file.</p>', 'refs' => [], ], 'FileModeTypeEnum' => [ 'base' => NULL, 'refs' => [ 'File$fileMode' => '<p>The extrapolated file mode permissions for the file. Valid values include EXECUTABLE and NORMAL.</p>', 'FileMetadata$fileMode' => '<p>The extrapolated file mode permissions for the file. Valid values include EXECUTABLE and NORMAL.</p>', 'FileModes$source' => '<p>The file mode of a file in the source of a merge or pull request.</p>', 'FileModes$destination' => '<p>The file mode of a file in the destination of a merge or pull request.</p>', 'FileModes$base' => '<p>The file mode of a file in the base of a merge or pull request.</p>', 'GetFileOutput$fileMode' => '<p>The extrapolated file mode permissions of the blob. Valid values include strings such as EXECUTABLE and not numeric values.</p> <note> <p>The file mode permissions returned by this API are not the standard file mode permission values, such as 100644, but rather extrapolated values. See the supported return values.</p> </note>', 'PutFileEntry$fileMode' => '<p>The extrapolated file mode permissions for the file. Valid values include EXECUTABLE and NORMAL.</p>', 'PutFileInput$fileMode' => '<p>The file mode permissions of the blob. Valid file mode permissions are listed here.</p>', 'ReplaceContentEntry$fileMode' => '<p>The file mode to apply during conflict resoltion.</p>', 'SetFileModeEntry$fileMode' => '<p>The file mode for the file.</p>', 'SymbolicLink$fileMode' => '<p>The file mode permissions of the blob that cotains information about the symbolic link.</p>', ], ], 'FileModes' => [ 'base' => '<p>Information about file modes in a merge or pull request.</p>', 'refs' => [ 'ConflictMetadata$fileModes' => '<p>The file modes of the file in the source, destination, and base of the merge.</p>', ], ], 'FileNameConflictsWithDirectoryNameException' => [ 'base' => '<p>A file cannot be added to the repository because the specified file name has the same name as a directory in this repository. Either provide another name for the file, or add the file in a directory that does not match the file name.</p>', 'refs' => [], ], 'FilePathConflictsWithSubmodulePathException' => [ 'base' => '<p>The commit cannot be created because a specified file path points to a submodule. Verify that the destination files have valid file paths that do not point to a submodule.</p>', 'refs' => [], ], 'FilePaths' => [ 'base' => NULL, 'refs' => [ 'BatchDescribeMergeConflictsInput$filePaths' => '<p>The path of the target files used to describe the conflicts. If not specified, the default is all conflict files.</p>', ], ], 'FileSize' => [ 'base' => NULL, 'refs' => [ 'FileSizes$source' => '<p>The size of a file in the source of a merge or pull request.</p>', 'FileSizes$destination' => '<p>The size of a file in the destination of a merge or pull request.</p>', 'FileSizes$base' => '<p>The size of a file in the base of a merge or pull request.</p>', ], ], 'FileSizes' => [ 'base' => '<p>Information about the size of files in a merge or pull request.</p>', 'refs' => [ 'ConflictMetadata$fileSizes' => '<p>The file sizes of the file in the source, destination, and base of the merge.</p>', ], ], 'FileTooLargeException' => [ 'base' => '<p>The specified file exceeds the file size limit for AWS CodeCommit. For more information about limits in AWS CodeCommit, see <a href="https://docs.aws.amazon.com/codecommit/latest/userguide/limits.html">AWS CodeCommit User Guide</a>.</p>', 'refs' => [], ], 'FilesMetadata' => [ 'base' => NULL, 'refs' => [ 'CreateCommitOutput$filesAdded' => '<p>The files added as part of the committed file changes.</p>', 'CreateCommitOutput$filesUpdated' => '<p>The files updated as part of the commited file changes.</p>', 'CreateCommitOutput$filesDeleted' => '<p>The files deleted as part of the committed file changes.</p>', ], ], 'Folder' => [ 'base' => '<p>Returns information about a folder in a repository.</p>', 'refs' => [ 'FolderList$member' => NULL, ], ], 'FolderContentSizeLimitExceededException' => [ 'base' => '<p>The commit cannot be created because at least one of the overall changes in the commit results in a folder whose contents exceed the limit of 6 MB. Either reduce the number and size of your changes, or split the changes across multiple folders.</p>', 'refs' => [], ], 'FolderDoesNotExistException' => [ 'base' => '<p>The specified folder does not exist. Either the folder name is not correct, or you did not enter the full path to the folder.</p>', 'refs' => [], ], 'FolderList' => [ 'base' => NULL, 'refs' => [ 'GetFolderOutput$subFolders' => '<p>The list of folders that exist under the specified folder, if any.</p>', ], ], 'GetApprovalRuleTemplateInput' => [ 'base' => NULL, 'refs' => [], ], 'GetApprovalRuleTemplateOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetBlobInput' => [ 'base' => '<p>Represents the input of a get blob operation.</p>', 'refs' => [], ], 'GetBlobOutput' => [ 'base' => '<p>Represents the output of a get blob operation.</p>', 'refs' => [], ], 'GetBranchInput' => [ 'base' => '<p>Represents the input of a get branch operation.</p>', 'refs' => [], ], 'GetBranchOutput' => [ 'base' => '<p>Represents the output of a get branch operation.</p>', 'refs' => [], ], 'GetCommentInput' => [ 'base' => NULL, 'refs' => [], ], 'GetCommentOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetCommentReactionsInput' => [ 'base' => NULL, 'refs' => [], ], 'GetCommentReactionsOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetCommentsForComparedCommitInput' => [ 'base' => NULL, 'refs' => [], ], 'GetCommentsForComparedCommitOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetCommentsForPullRequestInput' => [ 'base' => NULL, 'refs' => [], ], 'GetCommentsForPullRequestOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetCommitInput' => [ 'base' => '<p>Represents the input of a get commit operation.</p>', 'refs' => [], ], 'GetCommitOutput' => [ 'base' => '<p>Represents the output of a get commit operation.</p>', 'refs' => [], ], 'GetDifferencesInput' => [ 'base' => NULL, 'refs' => [], ], 'GetDifferencesOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetFileInput' => [ 'base' => NULL, 'refs' => [], ], 'GetFileOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetFolderInput' => [ 'base' => NULL, 'refs' => [], ], 'GetFolderOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetMergeCommitInput' => [ 'base' => NULL, 'refs' => [], ], 'GetMergeCommitOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetMergeConflictsInput' => [ 'base' => NULL, 'refs' => [], ], 'GetMergeConflictsOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetMergeOptionsInput' => [ 'base' => NULL, 'refs' => [], ], 'GetMergeOptionsOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetPullRequestApprovalStatesInput' => [ 'base' => NULL, 'refs' => [], ], 'GetPullRequestApprovalStatesOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetPullRequestInput' => [ 'base' => NULL, 'refs' => [], ], 'GetPullRequestOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetPullRequestOverrideStateInput' => [ 'base' => NULL, 'refs' => [], ], 'GetPullRequestOverrideStateOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetRepositoryInput' => [ 'base' => '<p>Represents the input of a get repository operation.</p>', 'refs' => [], ], 'GetRepositoryOutput' => [ 'base' => '<p>Represents the output of a get repository operation.</p>', 'refs' => [], ], 'GetRepositoryTriggersInput' => [ 'base' => '<p>Represents the input of a get repository triggers operation.</p>', 'refs' => [], ], 'GetRepositoryTriggersOutput' => [ 'base' => '<p>Represents the output of a get repository triggers operation.</p>', 'refs' => [], ], 'HunkContent' => [ 'base' => NULL, 'refs' => [ 'MergeHunkDetail$hunkContent' => '<p>The base-64 encoded content of the hunk merged region that might contain a conflict.</p>', ], ], 'IdempotencyParameterMismatchException' => [ 'base' => '<p>The client request token is not valid. Either the token is not in a valid format, or the token has been used in a previous request and cannot be reused.</p>', 'refs' => [], ], 'InvalidActorArnException' => [ 'base' => '<p>The Amazon Resource Name (ARN) is not valid. Make sure that you have provided the full ARN for the user who initiated the change for the pull request, and then try again.</p>', 'refs' => [], ], 'InvalidApprovalRuleContentException' => [ 'base' => '<p>The content for the approval rule is not valid.</p>', 'refs' => [], ], 'InvalidApprovalRuleNameException' => [ 'base' => '<p>The name for the approval rule is not valid.</p>', 'refs' => [], ], 'InvalidApprovalRuleTemplateContentException' => [ 'base' => '<p>The content of the approval rule template is not valid.</p>', 'refs' => [], ], 'InvalidApprovalRuleTemplateDescriptionException' => [ 'base' => '<p>The description for the approval rule template is not valid because it exceeds the maximum characters allowed for a description. For more information about limits in AWS CodeCommit, see <a href="https://docs.aws.amazon.com/codecommit/latest/userguide/limits.html">AWS CodeCommit User Guide</a>.</p>', 'refs' => [], ], 'InvalidApprovalRuleTemplateNameException' => [ 'base' => '<p>The name of the approval rule template is not valid. Template names must be between 1 and 100 valid characters in length. For more information about limits in AWS CodeCommit, see <a href="https://docs.aws.amazon.com/codecommit/latest/userguide/limits.html">AWS CodeCommit User Guide</a>.</p>', 'refs' => [], ], 'InvalidApprovalStateException' => [ 'base' => '<p>The state for the approval is not valid. Valid values include APPROVE and REVOKE. </p>', 'refs' => [], ], 'InvalidAuthorArnException' => [ 'base' => '<p>The Amazon Resource Name (ARN) is not valid. Make sure that you have provided the full ARN for the author of the pull request, and then try again.</p>', 'refs' => [], ], 'InvalidBlobIdException' => [ 'base' => '<p>The specified blob is not valid.</p>', 'refs' => [], ], 'InvalidBranchNameException' => [ 'base' => '<p>The specified reference name is not valid.</p>', 'refs' => [], ], 'InvalidClientRequestTokenException' => [ 'base' => '<p>The client request token is not valid.</p>', 'refs' => [], ], 'InvalidCommentIdException' => [ 'base' => '<p>The comment ID is not in a valid format. Make sure that you have provided the full comment ID.</p>', 'refs' => [], ], 'InvalidCommitException' => [ 'base' => '<p>The specified commit is not valid.</p>', 'refs' => [], ], 'InvalidCommitIdException' => [ 'base' => '<p>The specified commit ID is not valid.</p>', 'refs' => [], ], 'InvalidConflictDetailLevelException' => [ 'base' => '<p>The specified conflict detail level is not valid.</p>', 'refs' => [], ], 'InvalidConflictResolutionException' => [ 'base' => '<p>The specified conflict resolution list is not valid.</p>', 'refs' => [], ], 'InvalidConflictResolutionStrategyException' => [ 'base' => '<p>The specified conflict resolution strategy is not valid.</p>', 'refs' => [], ], 'InvalidContinuationTokenException' => [ 'base' => '<p>The specified continuation token is not valid.</p>', 'refs' => [], ], 'InvalidDeletionParameterException' => [ 'base' => '<p>The specified deletion parameter is not valid.</p>', 'refs' => [], ], 'InvalidDescriptionException' => [ 'base' => '<p>The pull request description is not valid. Descriptions cannot be more than 1,000 characters.</p>', 'refs' => [], ], 'InvalidDestinationCommitSpecifierException' => [ 'base' => '<p>The destination commit specifier is not valid. You must provide a valid branch name, tag, or full commit ID. </p>', 'refs' => [], ], 'InvalidEmailException' => [ 'base' => '<p>The specified email address either contains one or more characters that are not allowed, or it exceeds the maximum number of characters allowed for an email address.</p>', 'refs' => [], ], 'InvalidFileLocationException' => [ 'base' => '<p>The location of the file is not valid. Make sure that you include the file name and extension.</p>', 'refs' => [], ], 'InvalidFileModeException' => [ 'base' => '<p>The specified file mode permission is not valid. For a list of valid file mode permissions, see <a>PutFile</a>. </p>', 'refs' => [], ], 'InvalidFilePositionException' => [ 'base' => '<p>The position is not valid. Make sure that the line number exists in the version of the file you want to comment on.</p>', 'refs' => [], ], 'InvalidMaxConflictFilesException' => [ 'base' => '<p>The specified value for the number of conflict files to return is not valid.</p>', 'refs' => [], ], 'InvalidMaxMergeHunksException' => [ 'base' => '<p>The specified value for the number of merge hunks to return is not valid.</p>', 'refs' => [], ], 'InvalidMaxResultsException' => [ 'base' => '<p>The specified number of maximum results is not valid.</p>', 'refs' => [], ], 'InvalidMergeOptionException' => [ 'base' => '<p>The specified merge option is not valid for this operation. Not all merge strategies are supported for all operations.</p>', 'refs' => [], ], 'InvalidOrderException' => [ 'base' => '<p>The specified sort order is not valid.</p>', 'refs' => [], ], 'InvalidOverrideStatusException' => [ 'base' => '<p>The override status is not valid. Valid statuses are OVERRIDE and REVOKE.</p>', 'refs' => [], ], 'InvalidParentCommitIdException' => [ 'base' => '<p>The parent commit ID is not valid. The commit ID cannot be empty, and must match the head commit ID for the branch of the repository where you want to add or update a file.</p>', 'refs' => [], ], 'InvalidPathException' => [ 'base' => '<p>The specified path is not valid.</p>', 'refs' => [], ], 'InvalidPullRequestEventTypeException' => [ 'base' => '<p>The pull request event type is not valid. </p>', 'refs' => [], ], 'InvalidPullRequestIdException' => [ 'base' => '<p>The pull request ID is not valid. Make sure that you have provided the full ID and that the pull request is in the specified repository, and then try again.</p>', 'refs' => [], ], 'InvalidPullRequestStatusException' => [ 'base' => '<p>The pull request status is not valid. The only valid values are <code>OPEN</code> and <code>CLOSED</code>.</p>', 'refs' => [], ], 'InvalidPullRequestStatusUpdateException' => [ 'base' => '<p>The pull request status update is not valid. The only valid update is from <code>OPEN</code> to <code>CLOSED</code>.</p>', 'refs' => [], ], 'InvalidReactionUserArnException' => [ 'base' => '<p>The Amazon Resource Name (ARN) of the user or identity is not valid.</p>', 'refs' => [], ], 'InvalidReactionValueException' => [ 'base' => '<p>The value of the reaction is not valid. For more information, see the <a href="https://docs.aws.amazon.com/codecommit/latest/userguide/welcome.html">AWS CodeCommit User Guide</a>.</p>', 'refs' => [], ], 'InvalidReferenceNameException' => [ 'base' => '<p>The specified reference name format is not valid. Reference names must conform to the Git references format (for example, refs/heads/master). For more information, see <a href="https://git-scm.com/book/en/v2/Git-Internals-Git-References">Git Internals - Git References</a> or consult your Git documentation.</p>', 'refs' => [], ], 'InvalidRelativeFileVersionEnumException' => [ 'base' => '<p>Either the enum is not in a valid format, or the specified file version enum is not valid in respect to the current file version.</p>', 'refs' => [], ], 'InvalidReplacementContentException' => [ 'base' => '<p>Automerge was specified for resolving the conflict, but the replacement type is not valid or content is missing. </p>', 'refs' => [], ], 'InvalidReplacementTypeException' => [ 'base' => '<p>Automerge was specified for resolving the conflict, but the specified replacement type is not valid.</p>', 'refs' => [], ], 'InvalidRepositoryDescriptionException' => [ 'base' => '<p>The specified repository description is not valid.</p>', 'refs' => [], ], 'InvalidRepositoryNameException' => [ 'base' => '<p>A specified repository name is not valid.</p> <note> <p>This exception occurs only when a specified repository name is not valid. Other exceptions occur when a required repository parameter is missing, or when a specified repository does not exist.</p> </note>', 'refs' => [], ], 'InvalidRepositoryTriggerBranchNameException' => [ 'base' => '<p>One or more branch names specified for the trigger is not valid.</p>', 'refs' => [], ], 'InvalidRepositoryTriggerCustomDataException' => [ 'base' => '<p>The custom data provided for the trigger is not valid.</p>', 'refs' => [], ], 'InvalidRepositoryTriggerDestinationArnException' => [ 'base' => '<p>The Amazon Resource Name (ARN) for the trigger is not valid for the specified destination. The most common reason for this error is that the ARN does not meet the requirements for the service type.</p>', 'refs' => [], ], 'InvalidRepositoryTriggerEventsException' => [ 'base' => '<p>One or more events specified for the trigger is not valid. Check to make sure that all events specified match the requirements for allowed events.</p>', 'refs' => [], ], 'InvalidRepositoryTriggerNameException' => [ 'base' => '<p>The name of the trigger is not valid.</p>', 'refs' => [], ], 'InvalidRepositoryTriggerRegionException' => [ 'base' => '<p>The AWS Region for the trigger target does not match the AWS Region for the repository. Triggers must be created in the same Region as the target for the trigger.</p>', 'refs' => [], ], 'InvalidResourceArnException' => [ 'base' => '<p>The value for the resource ARN is not valid. For more information about resources in AWS CodeCommit, see <a href="https://docs.aws.amazon.com/codecommit/latest/userguide/auth-and-access-control-iam-access-control-identity-based.html#arn-formats">CodeCommit Resources and Operations</a> in the AWS CodeCommit User Guide.</p>', 'refs' => [], ], 'InvalidRevisionIdException' => [ 'base' => '<p>The revision ID is not valid. Use GetPullRequest to determine the value.</p>', 'refs' => [], ], 'InvalidRuleContentSha256Exception' => [ 'base' => '<p>The SHA-256 hash signature for the rule content is not valid.</p>', 'refs' => [], ], 'InvalidSortByException' => [ 'base' => '<p>The specified sort by value is not valid.</p>', 'refs' => [], ], 'InvalidSourceCommitSpecifierException' => [ 'base' => '<p>The source commit specifier is not valid. You must provide a valid branch name, tag, or full commit ID.</p>', 'refs' => [], ], 'InvalidSystemTagUsageException' => [ 'base' => '<p>The specified tag is not valid. Key names cannot be prefixed with aws:.</p>', 'refs' => [], ], 'InvalidTagKeysListException' => [ 'base' => '<p>The list of tags is not valid.</p>', 'refs' => [], ], 'InvalidTagsMapException' => [ 'base' => '<p>The map of tags is not valid.</p>', 'refs' => [], ], 'InvalidTargetBranchException' => [ 'base' => '<p>The specified target branch is not valid.</p>', 'refs' => [], ], 'InvalidTargetException' => [ 'base' => '<p>The target for the pull request is not valid. A target must contain the full values for the repository name, source branch, and destination branch for the pull request.</p>', 'refs' => [], ], 'InvalidTargetsException' => [ 'base' => '<p>The targets for the pull request is not valid or not in a valid format. Targets are a list of target objects. Each target object must contain the full values for the repository name, source branch, and destination branch for a pull request.</p>', 'refs' => [], ], 'InvalidTitleException' => [ 'base' => '<p>The title of the pull request is not valid. Pull request titles cannot exceed 100 characters in length.</p>', 'refs' => [], ], 'IsBinaryFile' => [ 'base' => '<p>Information about whether a file is binary or textual in a merge or pull request operation.</p>', 'refs' => [ 'ConflictMetadata$isBinaryFile' => '<p>A boolean value (true or false) indicating whether the file is binary or textual in the source, destination, and base of the merge.</p>', ], ], 'IsCommentDeleted' => [ 'base' => NULL, 'refs' => [ 'Comment$deleted' => '<p>A Boolean value indicating whether the comment has been deleted.</p>', ], ], 'IsContentConflict' => [ 'base' => NULL, 'refs' => [ 'ConflictMetadata$contentConflict' => '<p>A boolean value indicating whether there are conflicts in the content of a file.</p>', ], ], 'IsFileModeConflict' => [ 'base' => NULL, 'refs' => [ 'ConflictMetadata$fileModeConflict' => '<p>A boolean value indicating whether there are conflicts in the file mode of a file.</p>', ], ], 'IsHunkConflict' => [ 'base' => NULL, 'refs' => [ 'MergeHunk$isConflict' => '<p>A Boolean value indicating whether a combination of hunks contains a conflict. Conflicts occur when the same file or the same lines in a file were modified in both the source and destination of a merge or pull request. Valid values include true, false, and null. True when the hunk represents a conflict and one or more files contains a line conflict. File mode conflicts in a merge do not set this to true.</p>', ], ], 'IsMergeable' => [ 'base' => NULL, 'refs' => [ 'GetMergeConflictsOutput$mergeable' => '<p>A Boolean value that indicates whether the code is mergeable by the specified merge option.</p>', ], ], 'IsMerged' => [ 'base' => NULL, 'refs' => [ 'MergeMetadata$isMerged' => '<p>A Boolean value indicating whether the merge has been made.</p>', ], ], 'IsMove' => [ 'base' => NULL, 'refs' => [ 'SourceFileSpecifier$isMove' => '<p>Whether to remove the source file from the parent commit.</p>', ], ], 'IsObjectTypeConflict' => [ 'base' => NULL, 'refs' => [ 'ConflictMetadata$objectTypeConflict' => '<p>A boolean value (true or false) indicating whether there are conflicts between the branches in the object type of a file, folder, or submodule.</p>', ], ], 'KeepEmptyFolders' => [ 'base' => NULL, 'refs' => [ 'CreateCommitInput$keepEmptyFolders' => '<p>If the commit contains deletions, whether to keep a folder or folder structure if the changes leave the folders empty. If true, a ..gitkeep file is created for empty folders. The default is false.</p>', 'CreateUnreferencedMergeCommitInput$keepEmptyFolders' => '<p>If the commit contains deletions, whether to keep a folder or folder structure if the changes leave the folders empty. If this is specified as true, a .gitkeep file is created for empty folders. The default is false.</p>', 'DeleteFileInput$keepEmptyFolders' => '<p>If a file is the only object in the folder or directory, specifies whether to delete the folder or directory that contains the file. By default, empty folders are deleted. This includes empty folders that are part of the directory structure. For example, if the path to a file is dir1/dir2/dir3/dir4, and dir2 and dir3 are empty, deleting the last file in dir4 also deletes the empty folders dir4, dir3, and dir2.</p>', 'MergeBranchesBySquashInput$keepEmptyFolders' => '<p>If the commit contains deletions, whether to keep a folder or folder structure if the changes leave the folders empty. If this is specified as true, a .gitkeep file is created for empty folders. The default is false.</p>', 'MergeBranchesByThreeWayInput$keepEmptyFolders' => '<p>If the commit contains deletions, whether to keep a folder or folder structure if the changes leave the folders empty. If true, a .gitkeep file is created for empty folders. The default is false.</p>', 'MergePullRequestBySquashInput$keepEmptyFolders' => '<p>If the commit contains deletions, whether to keep a folder or folder structure if the changes leave the folders empty. If true, a .gitkeep file is created for empty folders. The default is false.</p>', 'MergePullRequestByThreeWayInput$keepEmptyFolders' => '<p>If the commit contains deletions, whether to keep a folder or folder structure if the changes leave the folders empty. If true, a .gitkeep file is created for empty folders. The default is false.</p>', ], ], 'LastModifiedDate' => [ 'base' => NULL, 'refs' => [ 'ApprovalRule$lastModifiedDate' => '<p>The date the approval rule was most recently changed, in timestamp format.</p>', 'ApprovalRuleTemplate$lastModifiedDate' => '<p>The date the approval rule template was most recently changed, in timestamp format.</p>', 'Comment$lastModifiedDate' => '<p>The date and time the comment was most recently modified, in timestamp format.</p>', 'PullRequest$lastActivityDate' => '<p>The day and time of the last user or system activity on the pull request, in timestamp format.</p>', 'RepositoryMetadata$lastModifiedDate' => '<p>The date and time the repository was last modified, in timestamp format.</p>', ], ], 'Limit' => [ 'base' => NULL, 'refs' => [ 'GetDifferencesInput$MaxResults' => '<p>A non-zero, non-negative integer used to limit the number of returned results.</p>', ], ], 'LineNumber' => [ 'base' => NULL, 'refs' => [ 'MergeHunkDetail$startLine' => '<p>The start position of the hunk in the merge result.</p>', 'MergeHunkDetail$endLine' => '<p>The end position of the hunk in the merge result.</p>', ], ], 'ListApprovalRuleTemplatesInput' => [ 'base' => NULL, 'refs' => [], ], 'ListApprovalRuleTemplatesOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListAssociatedApprovalRuleTemplatesForRepositoryInput' => [ 'base' => NULL, 'refs' => [], ], 'ListAssociatedApprovalRuleTemplatesForRepositoryOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListBranchesInput' => [ 'base' => '<p>Represents the input of a list branches operation.</p>', 'refs' => [], ], 'ListBranchesOutput' => [ 'base' => '<p>Represents the output of a list branches operation.</p>', 'refs' => [], ], 'ListPullRequestsInput' => [ 'base' => NULL, 'refs' => [], ], 'ListPullRequestsOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListRepositoriesForApprovalRuleTemplateInput' => [ 'base' => NULL, 'refs' => [], ], 'ListRepositoriesForApprovalRuleTemplateOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListRepositoriesInput' => [ 'base' => '<p>Represents the input of a list repositories operation.</p>', 'refs' => [], ], 'ListRepositoriesOutput' => [ 'base' => '<p>Represents the output of a list repositories operation.</p>', 'refs' => [], ], 'ListTagsForResourceInput' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceOutput' => [ 'base' => NULL, 'refs' => [], ], 'Location' => [ 'base' => '<p>Returns information about the location of a change or comment in the comparison between two commits or a pull request.</p>', 'refs' => [ 'CommentsForComparedCommit$location' => '<p>Location information about the comment on the comparison, including the file name, line number, and whether the version of the file where the comment was made is BEFORE or AFTER.</p>', 'CommentsForPullRequest$location' => '<p>Location information about the comment on the pull request, including the file name, line number, and whether the version of the file where the comment was made is BEFORE (destination branch) or AFTER (source branch).</p>', 'PostCommentForComparedCommitInput$location' => '<p>The location of the comparison where you want to comment.</p>', 'PostCommentForComparedCommitOutput$location' => '<p>The location of the comment in the comparison between the two commits.</p>', 'PostCommentForPullRequestInput$location' => '<p>The location of the change where you want to post your comment. If no location is provided, the comment is posted as a general comment on the pull request difference between the before commit ID and the after commit ID.</p>', 'PostCommentForPullRequestOutput$location' => '<p>The location of the change where you posted your comment.</p>', ], ], 'ManualMergeRequiredException' => [ 'base' => '<p>The pull request cannot be merged automatically into the destination branch. You must manually merge the branches and resolve any conflicts.</p>', 'refs' => [], ], 'MaxResults' => [ 'base' => NULL, 'refs' => [ 'BatchDescribeMergeConflictsInput$maxMergeHunks' => '<p>The maximum number of merge hunks to include in the output.</p>', 'BatchDescribeMergeConflictsInput$maxConflictFiles' => '<p>The maximum number of files to include in the output.</p>', 'DescribeMergeConflictsInput$maxMergeHunks' => '<p>The maximum number of merge hunks to include in the output.</p>', 'DescribePullRequestEventsInput$maxResults' => '<p>A non-zero, non-negative integer used to limit the number of returned results. The default is 100 events, which is also the maximum number of events that can be returned in a result.</p>', 'GetCommentReactionsInput$maxResults' => '<p>A non-zero, non-negative integer used to limit the number of returned results. The default is the same as the allowed maximum, 1,000.</p>', 'GetCommentsForComparedCommitInput$maxResults' => '<p>A non-zero, non-negative integer used to limit the number of returned results. The default is 100 comments, but you can configure up to 500.</p>', 'GetCommentsForPullRequestInput$maxResults' => '<p>A non-zero, non-negative integer used to limit the number of returned results. The default is 100 comments. You can return up to 500 comments with a single request.</p>', 'GetMergeConflictsInput$maxConflictFiles' => '<p>The maximum number of files to include in the output.</p>', 'ListApprovalRuleTemplatesInput$maxResults' => '<p>A non-zero, non-negative integer used to limit the number of returned results.</p>', 'ListAssociatedApprovalRuleTemplatesForRepositoryInput$maxResults' => '<p>A non-zero, non-negative integer used to limit the number of returned results.</p>', 'ListPullRequestsInput$maxResults' => '<p>A non-zero, non-negative integer used to limit the number of returned results.</p>', 'ListRepositoriesForApprovalRuleTemplateInput$maxResults' => '<p>A non-zero, non-negative integer used to limit the number of returned results.</p>', ], ], 'MaximumBranchesExceededException' => [ 'base' => '<p>The number of branches for the trigger was exceeded.</p>', 'refs' => [], ], 'MaximumConflictResolutionEntriesExceededException' => [ 'base' => '<p>The number of allowed conflict resolution entries was exceeded.</p>', 'refs' => [], ], 'MaximumFileContentToLoadExceededException' => [ 'base' => '<p>The number of files to load exceeds the allowed limit.</p>', 'refs' => [], ], 'MaximumFileEntriesExceededException' => [ 'base' => '<p>The number of specified files to change as part of this commit exceeds the maximum number of files that can be changed in a single commit. Consider using a Git client for these changes.</p>', 'refs' => [], ], 'MaximumItemsToCompareExceededException' => [ 'base' => '<p>The number of items to compare between the source or destination branches and the merge base has exceeded the maximum allowed.</p>', 'refs' => [], ], 'MaximumNumberOfApprovalsExceededException' => [ 'base' => '<p>The number of approvals required for the approval rule exceeds the maximum number allowed.</p>', 'refs' => [], ], 'MaximumOpenPullRequestsExceededException' => [ 'base' => '<p>You cannot create the pull request because the repository has too many open pull requests. The maximum number of open pull requests for a repository is 1,000. Close one or more open pull requests, and then try again.</p>', 'refs' => [], ], 'MaximumRepositoryNamesExceededException' => [ 'base' => '<p>The maximum number of allowed repository names was exceeded. Currently, this number is 100.</p>', 'refs' => [], ], 'MaximumRepositoryTriggersExceededException' => [ 'base' => '<p>The number of triggers allowed for the repository was exceeded.</p>', 'refs' => [], ], 'MaximumRuleTemplatesAssociatedWithRepositoryException' => [ 'base' => '<p>The maximum number of approval rule templates for a repository has been exceeded. You cannot associate more than 25 approval rule templates with a repository.</p>', 'refs' => [], ], 'MergeBranchesByFastForwardInput' => [ 'base' => NULL, 'refs' => [], ], 'MergeBranchesByFastForwardOutput' => [ 'base' => NULL, 'refs' => [], ], 'MergeBranchesBySquashInput' => [ 'base' => NULL, 'refs' => [], ], 'MergeBranchesBySquashOutput' => [ 'base' => NULL, 'refs' => [], ], 'MergeBranchesByThreeWayInput' => [ 'base' => NULL, 'refs' => [], ], 'MergeBranchesByThreeWayOutput' => [ 'base' => NULL, 'refs' => [], ], 'MergeHunk' => [ 'base' => '<p>Information about merge hunks in a merge or pull request operation.</p>', 'refs' => [ 'MergeHunks$member' => NULL, ], ], 'MergeHunkDetail' => [ 'base' => '<p>Information about the details of a merge hunk that contains a conflict in a merge or pull request operation.</p>', 'refs' => [ 'MergeHunk$source' => '<p>Information about the merge hunk in the source of a merge or pull request.</p>', 'MergeHunk$destination' => '<p>Information about the merge hunk in the destination of a merge or pull request.</p>', 'MergeHunk$base' => '<p>Information about the merge hunk in the base of a merge or pull request.</p>', ], ], 'MergeHunks' => [ 'base' => NULL, 'refs' => [ 'Conflict$mergeHunks' => '<p>A list of hunks that contain the differences between files or lines causing the conflict.</p>', 'DescribeMergeConflictsOutput$mergeHunks' => '<p>A list of merge hunks of the differences between the files or lines.</p>', ], ], 'MergeMetadata' => [ 'base' => '<p>Returns information about a merge or potential merge between a source reference and a destination reference in a pull request.</p>', 'refs' => [ 'PullRequestMergedStateChangedEventMetadata$mergeMetadata' => '<p>Information about the merge state change event.</p>', 'PullRequestTarget$mergeMetadata' => '<p>Returns metadata about the state of the merge, including whether the merge has been made.</p>', ], ], 'MergeOperations' => [ 'base' => '<p>Information about the file operation conflicts in a merge operation.</p>', 'refs' => [ 'ConflictMetadata$mergeOperations' => '<p>Whether an add, modify, or delete operation caused the conflict between the source and destination of the merge.</p>', ], ], 'MergeOptionRequiredException' => [ 'base' => '<p>A merge option or stategy is required, and none was provided.</p>', 'refs' => [], ], 'MergeOptionTypeEnum' => [ 'base' => NULL, 'refs' => [ 'BatchDescribeMergeConflictsInput$mergeOption' => '<p>The merge option or strategy you want to use to merge the code.</p>', 'CreateUnreferencedMergeCommitInput$mergeOption' => '<p>The merge option or strategy you want to use to merge the code.</p>', 'DescribeMergeConflictsInput$mergeOption' => '<p>The merge option or strategy you want to use to merge the code.</p>', 'GetMergeConflictsInput$mergeOption' => '<p>The merge option or strategy you want to use to merge the code. </p>', 'MergeMetadata$mergeOption' => '<p>The merge strategy used in the merge.</p>', 'MergeOptions$member' => NULL, ], ], 'MergeOptions' => [ 'base' => NULL, 'refs' => [ 'GetMergeOptionsOutput$mergeOptions' => '<p>The merge option or strategy used to merge the code.</p>', ], ], 'MergePullRequestByFastForwardInput' => [ 'base' => NULL, 'refs' => [], ], 'MergePullRequestByFastForwardOutput' => [ 'base' => NULL, 'refs' => [], ], 'MergePullRequestBySquashInput' => [ 'base' => NULL, 'refs' => [], ], 'MergePullRequestBySquashOutput' => [ 'base' => NULL, 'refs' => [], ], 'MergePullRequestByThreeWayInput' => [ 'base' => NULL, 'refs' => [], ], 'MergePullRequestByThreeWayOutput' => [ 'base' => NULL, 'refs' => [], ], 'Message' => [ 'base' => NULL, 'refs' => [ 'BatchDescribeMergeConflictsError$message' => '<p>The message provided by the exception.</p>', 'Commit$message' => '<p>The commit message associated with the specified commit.</p>', 'CreateCommitInput$commitMessage' => '<p>The commit message you want to include in the commit. Commit messages are limited to 256 KB. If no message is specified, a default message is used.</p>', 'CreateUnreferencedMergeCommitInput$commitMessage' => '<p>The commit message for the unreferenced commit.</p>', 'DeleteFileInput$commitMessage' => '<p>The commit message you want to include as part of deleting the file. Commit messages are limited to 256 KB. If no message is specified, a default message is used.</p>', 'MergeBranchesBySquashInput$commitMessage' => '<p>The commit message for the merge.</p>', 'MergeBranchesByThreeWayInput$commitMessage' => '<p>The commit message to include in the commit information for the merge.</p>', 'MergePullRequestBySquashInput$commitMessage' => '<p>The commit message to include in the commit information for the merge.</p>', 'MergePullRequestByThreeWayInput$commitMessage' => '<p>The commit message to include in the commit information for the merge.</p>', 'PutFileInput$commitMessage' => '<p>A message about why this file was added or updated. Although it is optional, a message makes the commit history for your repository more useful.</p>', ], ], 'Mode' => [ 'base' => NULL, 'refs' => [ 'BlobMetadata$mode' => '<p>The file mode permissions of the blob. File mode permission codes include:</p> <ul> <li> <p> <code>100644</code> indicates read/write</p> </li> <li> <p> <code>100755</code> indicates read/write/execute</p> </li> <li> <p> <code>160000</code> indicates a submodule</p> </li> <li> <p> <code>120000</code> indicates a symlink</p> </li> </ul>', ], ], 'MultipleConflictResolutionEntriesException' => [ 'base' => '<p>More than one conflict resolution entries exists for the conflict. A conflict can have only one conflict resolution entry.</p>', 'refs' => [], ], 'MultipleRepositoriesInPullRequestException' => [ 'base' => '<p>You cannot include more than one repository in a pull request. Make sure you have specified only one repository name in your request, and then try again.</p>', 'refs' => [], ], 'Name' => [ 'base' => NULL, 'refs' => [ 'CreateCommitInput$authorName' => '<p>The name of the author who created the commit. This information is used as both the author and committer for the commit.</p>', 'CreateUnreferencedMergeCommitInput$authorName' => '<p>The name of the author who created the unreferenced commit. This information is used as both the author and committer for the commit.</p>', 'DeleteFileInput$name' => '<p>The name of the author of the commit that deletes the file. If no name is specified, the user\'s ARN is used as the author name and committer name.</p>', 'MergeBranchesBySquashInput$authorName' => '<p>The name of the author who created the commit. This information is used as both the author and committer for the commit.</p>', 'MergeBranchesByThreeWayInput$authorName' => '<p>The name of the author who created the commit. This information is used as both the author and committer for the commit.</p>', 'MergePullRequestBySquashInput$authorName' => '<p>The name of the author who created the commit. This information is used as both the author and committer for the commit.</p>', 'MergePullRequestByThreeWayInput$authorName' => '<p>The name of the author who created the commit. This information is used as both the author and committer for the commit.</p>', 'PutFileInput$name' => '<p>The name of the person adding or updating the file. Although it is optional, a name makes the commit history for your repository more useful.</p>', 'UserInfo$name' => '<p>The name of the user who made the specified commit.</p>', ], ], 'NameLengthExceededException' => [ 'base' => '<p>The user name is not valid because it has exceeded the character limit for author names. </p>', 'refs' => [], ], 'NextToken' => [ 'base' => NULL, 'refs' => [ 'BatchDescribeMergeConflictsInput$nextToken' => '<p>An enumeration token that, when provided in a request, returns the next batch of the results.</p>', 'BatchDescribeMergeConflictsOutput$nextToken' => '<p>An enumeration token that can be used in a request to return the next batch of the results.</p>', 'DescribeMergeConflictsInput$nextToken' => '<p>An enumeration token that, when provided in a request, returns the next batch of the results.</p>', 'DescribeMergeConflictsOutput$nextToken' => '<p>An enumeration token that can be used in a request to return the next batch of the results.</p>', 'DescribePullRequestEventsInput$nextToken' => '<p>An enumeration token that, when provided in a request, returns the next batch of the results.</p>', 'DescribePullRequestEventsOutput$nextToken' => '<p>An enumeration token that can be used in a request to return the next batch of the results.</p>', 'GetCommentReactionsInput$nextToken' => '<p>An enumeration token that, when provided in a request, returns the next batch of the results. </p>', 'GetCommentReactionsOutput$nextToken' => '<p>An enumeration token that can be used in a request to return the next batch of the results.</p>', 'GetCommentsForComparedCommitInput$nextToken' => '<p>An enumeration token that when provided in a request, returns the next batch of the results. </p>', 'GetCommentsForComparedCommitOutput$nextToken' => '<p>An enumeration token that can be used in a request to return the next batch of the results.</p>', 'GetCommentsForPullRequestInput$nextToken' => '<p>An enumeration token that, when provided in a request, returns the next batch of the results.</p>', 'GetCommentsForPullRequestOutput$nextToken' => '<p>An enumeration token that can be used in a request to return the next batch of the results.</p>', 'GetDifferencesInput$NextToken' => '<p>An enumeration token that, when provided in a request, returns the next batch of the results.</p>', 'GetDifferencesOutput$NextToken' => '<p>An enumeration token that can be used in a request to return the next batch of the results.</p>', 'GetMergeConflictsInput$nextToken' => '<p>An enumeration token that, when provided in a request, returns the next batch of the results.</p>', 'GetMergeConflictsOutput$nextToken' => '<p>An enumeration token that can be used in a request to return the next batch of the results.</p>', 'ListApprovalRuleTemplatesInput$nextToken' => '<p>An enumeration token that, when provided in a request, returns the next batch of the results.</p>', 'ListApprovalRuleTemplatesOutput$nextToken' => '<p>An enumeration token that allows the operation to batch the next results of the operation.</p>', 'ListAssociatedApprovalRuleTemplatesForRepositoryInput$nextToken' => '<p>An enumeration token that, when provided in a request, returns the next batch of the results.</p>', 'ListAssociatedApprovalRuleTemplatesForRepositoryOutput$nextToken' => '<p>An enumeration token that allows the operation to batch the next results of the operation.</p>', 'ListBranchesInput$nextToken' => '<p>An enumeration token that allows the operation to batch the results.</p>', 'ListBranchesOutput$nextToken' => '<p>An enumeration token that returns the batch of the results.</p>', 'ListPullRequestsInput$nextToken' => '<p>An enumeration token that, when provided in a request, returns the next batch of the results.</p>', 'ListPullRequestsOutput$nextToken' => '<p>An enumeration token that allows the operation to batch the next results of the operation.</p>', 'ListRepositoriesForApprovalRuleTemplateInput$nextToken' => '<p>An enumeration token that, when provided in a request, returns the next batch of the results.</p>', 'ListRepositoriesForApprovalRuleTemplateOutput$nextToken' => '<p>An enumeration token that allows the operation to batch the next results of the operation.</p>', 'ListRepositoriesInput$nextToken' => '<p>An enumeration token that allows the operation to batch the results of the operation. Batch sizes are 1,000 for list repository operations. When the client sends the token back to AWS CodeCommit, another page of 1,000 records is retrieved.</p>', 'ListRepositoriesOutput$nextToken' => '<p>An enumeration token that allows the operation to batch the results of the operation. Batch sizes are 1,000 for list repository operations. When the client sends the token back to AWS CodeCommit, another page of 1,000 records is retrieved.</p>', 'ListTagsForResourceInput$nextToken' => '<p>An enumeration token that, when provided in a request, returns the next batch of the results.</p>', 'ListTagsForResourceOutput$nextToken' => '<p>An enumeration token that allows the operation to batch the next results of the operation.</p>', ], ], 'NoChangeException' => [ 'base' => '<p>The commit cannot be created because no changes will be made to the repository as a result of this commit. A commit must contain at least one change.</p>', 'refs' => [], ], 'NumberOfConflicts' => [ 'base' => NULL, 'refs' => [ 'ConflictMetadata$numberOfConflicts' => '<p>The number of conflicts, including both hunk conflicts and metadata conflicts.</p>', ], ], 'NumberOfRuleTemplatesExceededException' => [ 'base' => '<p>The maximum number of approval rule templates has been exceeded for this AWS Region. </p>', 'refs' => [], ], 'NumberOfRulesExceededException' => [ 'base' => '<p>The approval rule cannot be added. The pull request has the maximum number of approval rules associated with it.</p>', 'refs' => [], ], 'ObjectId' => [ 'base' => NULL, 'refs' => [ 'BatchDescribeMergeConflictsOutput$destinationCommitId' => '<p>The commit ID of the destination commit specifier that was used in the merge evaluation.</p>', 'BatchDescribeMergeConflictsOutput$sourceCommitId' => '<p>The commit ID of the source commit specifier that was used in the merge evaluation.</p>', 'BatchDescribeMergeConflictsOutput$baseCommitId' => '<p>The commit ID of the merge base.</p>', 'BatchGetCommitsError$commitId' => '<p>A commit ID that either could not be found or was not in a valid format.</p>', 'BlobMetadata$blobId' => '<p>The full ID of the blob.</p>', 'CommentsForComparedCommit$beforeBlobId' => '<p>The full blob ID of the commit used to establish the before of the comparison.</p>', 'CommentsForComparedCommit$afterBlobId' => '<p>The full blob ID of the commit used to establish the after of the comparison.</p>', 'CommentsForPullRequest$beforeBlobId' => '<p>The full blob ID of the file on which you want to comment on the destination commit.</p>', 'CommentsForPullRequest$afterBlobId' => '<p>The full blob ID of the file on which you want to comment on the source commit.</p>', 'Commit$commitId' => '<p>The full SHA ID of the specified commit. </p>', 'Commit$treeId' => '<p>Tree information for the specified commit.</p>', 'CommitIdsInputList$member' => NULL, 'CreateCommitOutput$commitId' => '<p>The full commit ID of the commit that contains your committed file changes.</p>', 'CreateCommitOutput$treeId' => '<p>The full SHA-1 pointer of the tree information for the commit that contains the commited file changes.</p>', 'CreateUnreferencedMergeCommitOutput$commitId' => '<p>The full commit ID of the commit that contains your merge results.</p>', 'CreateUnreferencedMergeCommitOutput$treeId' => '<p>The full SHA-1 pointer of the tree information for the commit that contains the merge results.</p>', 'DeleteFileOutput$commitId' => '<p>The full commit ID of the commit that contains the change that deletes the file.</p>', 'DeleteFileOutput$blobId' => '<p>The blob ID removed from the tree as part of deleting the file.</p>', 'DeleteFileOutput$treeId' => '<p>The full SHA-1 pointer of the tree information for the commit that contains the delete file change.</p>', 'DescribeMergeConflictsOutput$destinationCommitId' => '<p>The commit ID of the destination commit specifier that was used in the merge evaluation.</p>', 'DescribeMergeConflictsOutput$sourceCommitId' => '<p>The commit ID of the source commit specifier that was used in the merge evaluation.</p>', 'DescribeMergeConflictsOutput$baseCommitId' => '<p>The commit ID of the merge base.</p>', 'File$blobId' => '<p>The blob ID that contains the file information.</p>', 'FileMetadata$blobId' => '<p>The blob ID that contains the file information.</p>', 'Folder$treeId' => '<p>The full SHA-1 pointer of the tree information for the commit that contains the folder.</p>', 'GetBlobInput$blobId' => '<p>The ID of the blob, which is its SHA-1 pointer.</p>', 'GetCommitInput$commitId' => '<p>The commit ID. Commit IDs are the full SHA ID of the commit.</p>', 'GetFileOutput$commitId' => '<p>The full commit ID of the commit that contains the content returned by GetFile.</p>', 'GetFileOutput$blobId' => '<p>The blob ID of the object that represents the file content.</p>', 'GetFolderOutput$commitId' => '<p>The full commit ID used as a reference for the returned version of the folder content.</p>', 'GetFolderOutput$treeId' => '<p>The full SHA-1 pointer of the tree information for the commit that contains the folder.</p>', 'GetMergeCommitOutput$sourceCommitId' => '<p>The commit ID of the source commit specifier that was used in the merge evaluation.</p>', 'GetMergeCommitOutput$destinationCommitId' => '<p>The commit ID of the destination commit specifier that was used in the merge evaluation.</p>', 'GetMergeCommitOutput$baseCommitId' => '<p>The commit ID of the merge base.</p>', 'GetMergeCommitOutput$mergedCommitId' => '<p>The commit ID for the merge commit created when the source branch was merged into the destination branch. If the fast-forward merge strategy was used, there is no merge commit.</p>', 'GetMergeConflictsOutput$destinationCommitId' => '<p>The commit ID of the destination commit specifier that was used in the merge evaluation.</p>', 'GetMergeConflictsOutput$sourceCommitId' => '<p>The commit ID of the source commit specifier that was used in the merge evaluation.</p>', 'GetMergeConflictsOutput$baseCommitId' => '<p>The commit ID of the merge base.</p>', 'GetMergeOptionsOutput$sourceCommitId' => '<p>The commit ID of the source commit specifier that was used in the merge evaluation.</p>', 'GetMergeOptionsOutput$destinationCommitId' => '<p>The commit ID of the destination commit specifier that was used in the merge evaluation.</p>', 'GetMergeOptionsOutput$baseCommitId' => '<p>The commit ID of the merge base.</p>', 'MergeBranchesByFastForwardOutput$commitId' => '<p>The commit ID of the merge in the destination or target branch.</p>', 'MergeBranchesByFastForwardOutput$treeId' => '<p>The tree ID of the merge in the destination or target branch.</p>', 'MergeBranchesBySquashOutput$commitId' => '<p>The commit ID of the merge in the destination or target branch.</p>', 'MergeBranchesBySquashOutput$treeId' => '<p>The tree ID of the merge in the destination or target branch.</p>', 'MergeBranchesByThreeWayOutput$commitId' => '<p>The commit ID of the merge in the destination or target branch.</p>', 'MergeBranchesByThreeWayOutput$treeId' => '<p>The tree ID of the merge in the destination or target branch.</p>', 'MergePullRequestByFastForwardInput$sourceCommitId' => '<p>The full commit ID of the original or updated commit in the pull request source branch. Pass this value if you want an exception thrown if the current commit ID of the tip of the source branch does not match this commit ID.</p>', 'MergePullRequestBySquashInput$sourceCommitId' => '<p>The full commit ID of the original or updated commit in the pull request source branch. Pass this value if you want an exception thrown if the current commit ID of the tip of the source branch does not match this commit ID.</p>', 'MergePullRequestByThreeWayInput$sourceCommitId' => '<p>The full commit ID of the original or updated commit in the pull request source branch. Pass this value if you want an exception thrown if the current commit ID of the tip of the source branch does not match this commit ID.</p>', 'ParentList$member' => NULL, 'PostCommentForComparedCommitOutput$beforeBlobId' => '<p>In the directionality you established, the blob ID of the before blob.</p>', 'PostCommentForComparedCommitOutput$afterBlobId' => '<p>In the directionality you established, the blob ID of the after blob.</p>', 'PostCommentForPullRequestOutput$beforeBlobId' => '<p>In the directionality of the pull request, the blob ID of the before blob.</p>', 'PostCommentForPullRequestOutput$afterBlobId' => '<p>In the directionality of the pull request, the blob ID of the after blob.</p>', 'PutFileOutput$commitId' => '<p>The full SHA ID of the commit that contains this file change.</p>', 'PutFileOutput$blobId' => '<p>The ID of the blob, which is its SHA-1 pointer.</p>', 'PutFileOutput$treeId' => '<p>The full SHA-1 pointer of the tree information for the commit that contains this file change.</p>', 'SubModule$commitId' => '<p>The commit ID that contains the reference to the submodule.</p>', 'SymbolicLink$blobId' => '<p>The blob ID that contains the information about the symbolic link.</p>', ], ], 'ObjectSize' => [ 'base' => NULL, 'refs' => [ 'GetFileOutput$fileSize' => '<p>The size of the contents of the file, in bytes.</p>', ], ], 'ObjectTypeEnum' => [ 'base' => NULL, 'refs' => [ 'ObjectTypes$source' => '<p>The type of the object in the source branch.</p>', 'ObjectTypes$destination' => '<p>The type of the object in the destination branch.</p>', 'ObjectTypes$base' => '<p>The type of the object in the base commit of the merge.</p>', ], ], 'ObjectTypes' => [ 'base' => '<p>Information about the type of an object in a merge operation.</p>', 'refs' => [ 'ConflictMetadata$objectTypes' => '<p>Information about any object type conflicts in a merge operation.</p>', ], ], 'OrderEnum' => [ 'base' => NULL, 'refs' => [ 'ListRepositoriesInput$order' => '<p>The order in which to sort the results of a list repositories operation.</p>', ], ], 'OriginApprovalRuleTemplate' => [ 'base' => '<p>Returns information about the template that created the approval rule for a pull request.</p>', 'refs' => [ 'ApprovalRule$originApprovalRuleTemplate' => '<p>The approval rule template used to create the rule.</p>', ], ], 'Overridden' => [ 'base' => NULL, 'refs' => [ 'Evaluation$overridden' => '<p>Whether the approval rule requirements for the pull request have been overridden and no longer need to be met.</p>', 'GetPullRequestOverrideStateOutput$overridden' => '<p>A Boolean value that indicates whether a pull request has had its rules set aside (TRUE) or whether all approval rules still apply (FALSE).</p>', ], ], 'OverrideAlreadySetException' => [ 'base' => '<p>The pull request has already had its approval rules set to override.</p>', 'refs' => [], ], 'OverridePullRequestApprovalRulesInput' => [ 'base' => NULL, 'refs' => [], ], 'OverrideStatus' => [ 'base' => NULL, 'refs' => [ 'ApprovalRuleOverriddenEventMetadata$overrideStatus' => '<p>The status of the override event.</p>', 'OverridePullRequestApprovalRulesInput$overrideStatus' => '<p>Whether you want to set aside approval rule requirements for the pull request (OVERRIDE) or revoke a previous override and apply approval rule requirements (REVOKE). REVOKE status is not stored.</p>', ], ], 'OverrideStatusRequiredException' => [ 'base' => '<p>An override status is required, but no value was provided. Valid values include OVERRIDE and REVOKE.</p>', 'refs' => [], ], 'ParentCommitDoesNotExistException' => [ 'base' => '<p>The parent commit ID is not valid because it does not exist. The specified parent commit ID does not exist in the specified branch of the repository.</p>', 'refs' => [], ], 'ParentCommitIdOutdatedException' => [ 'base' => '<p>The file could not be added because the provided parent commit ID is not the current tip of the specified branch. To view the full commit ID of the current head of the branch, use <a>GetBranch</a>.</p>', 'refs' => [], ], 'ParentCommitIdRequiredException' => [ 'base' => '<p>A parent commit ID is required. To view the full commit ID of a branch in a repository, use <a>GetBranch</a> or a Git command (for example, git pull or git log).</p>', 'refs' => [], ], 'ParentList' => [ 'base' => NULL, 'refs' => [ 'Commit$parents' => '<p>A list of parent commits for the specified commit. Each parent commit ID is the full commit ID.</p>', ], ], 'Path' => [ 'base' => NULL, 'refs' => [ 'BatchDescribeMergeConflictsError$filePath' => '<p>The path to the file.</p>', 'BlobMetadata$path' => '<p>The path to the blob and associated file name, if any.</p>', 'ConflictMetadata$filePath' => '<p>The path of the file that contains conflicts.</p>', 'DeleteFileEntry$filePath' => '<p>The full path of the file to be deleted, including the name of the file.</p>', 'DeleteFileInput$filePath' => '<p>The fully qualified path to the file that to be deleted, including the full name and extension of that file. For example, /examples/file.md is a fully qualified path to a file named file.md in a folder named examples.</p>', 'DeleteFileOutput$filePath' => '<p>The fully qualified path to the file to be deleted, including the full name and extension of that file.</p>', 'DescribeMergeConflictsInput$filePath' => '<p>The path of the target files used to describe the conflicts. </p>', 'File$absolutePath' => '<p>The fully qualified path to the file in the repository.</p>', 'File$relativePath' => '<p>The relative path of the file from the folder where the query originated.</p>', 'FileMetadata$absolutePath' => '<p>The full path to the file to be added or updated, including the name of the file.</p>', 'FilePaths$member' => NULL, 'Folder$absolutePath' => '<p>The fully qualified path of the folder in the repository.</p>', 'Folder$relativePath' => '<p>The relative path of the specified folder from the folder where the query originated.</p>', 'GetDifferencesInput$beforePath' => '<p>The file path in which to check for differences. Limits the results to this path. Can also be used to specify the previous name of a directory or folder. If <code>beforePath</code> and <code>afterPath</code> are not specified, differences are shown for all paths.</p>', 'GetDifferencesInput$afterPath' => '<p>The file path in which to check differences. Limits the results to this path. Can also be used to specify the changed name of a directory or folder, if it has changed. If not specified, differences are shown for all paths.</p>', 'GetFileInput$filePath' => '<p>The fully qualified path to the file, including the full name and extension of the file. For example, /examples/file.md is the fully qualified path to a file named file.md in a folder named examples.</p>', 'GetFileOutput$filePath' => '<p>The fully qualified path to the specified file. Returns the name and extension of the file.</p>', 'GetFolderInput$folderPath' => '<p>The fully qualified path to the folder whose contents are returned, including the folder name. For example, /examples is a fully-qualified path to a folder named examples that was created off of the root directory (/) of a repository. </p>', 'GetFolderOutput$folderPath' => '<p>The fully qualified path of the folder whose contents are returned.</p>', 'Location$filePath' => '<p>The name of the file being compared, including its extension and subdirectory, if any.</p>', 'PutFileEntry$filePath' => '<p>The full path to the file in the repository, including the name of the file.</p>', 'PutFileInput$filePath' => '<p>The name of the file you want to add or update, including the relative path to the file in the repository.</p> <note> <p>If the path does not currently exist in the repository, the path is created as part of adding the file.</p> </note>', 'ReplaceContentEntry$filePath' => '<p>The path of the conflicting file.</p>', 'SetFileModeEntry$filePath' => '<p>The full path to the file, including the name of the file.</p>', 'SourceFileSpecifier$filePath' => '<p>The full path to the file, including the name of the file.</p>', 'SubModule$absolutePath' => '<p>The fully qualified path to the folder that contains the reference to the submodule.</p>', 'SubModule$relativePath' => '<p>The relative path of the submodule from the folder where the query originated.</p>', 'SymbolicLink$absolutePath' => '<p>The fully qualified path to the folder that contains the symbolic link.</p>', 'SymbolicLink$relativePath' => '<p>The relative path of the symbolic link from the folder where the query originated.</p>', ], ], 'PathDoesNotExistException' => [ 'base' => '<p>The specified path does not exist.</p>', 'refs' => [], ], 'PathRequiredException' => [ 'base' => '<p>The folderPath for a location cannot be null.</p>', 'refs' => [], ], 'Position' => [ 'base' => NULL, 'refs' => [ 'Location$filePosition' => '<p>The position of a change in a compared file, in line number format.</p>', ], ], 'PostCommentForComparedCommitInput' => [ 'base' => NULL, 'refs' => [], ], 'PostCommentForComparedCommitOutput' => [ 'base' => NULL, 'refs' => [], ], 'PostCommentForPullRequestInput' => [ 'base' => NULL, 'refs' => [], ], 'PostCommentForPullRequestOutput' => [ 'base' => NULL, 'refs' => [], ], 'PostCommentReplyInput' => [ 'base' => NULL, 'refs' => [], ], 'PostCommentReplyOutput' => [ 'base' => NULL, 'refs' => [], ], 'PullRequest' => [ 'base' => '<p>Returns information about a pull request.</p>', 'refs' => [ 'CreatePullRequestOutput$pullRequest' => '<p>Information about the newly created pull request.</p>', 'GetPullRequestOutput$pullRequest' => '<p>Information about the specified pull request.</p>', 'MergePullRequestByFastForwardOutput$pullRequest' => '<p>Information about the specified pull request, including the merge.</p>', 'MergePullRequestBySquashOutput$pullRequest' => NULL, 'MergePullRequestByThreeWayOutput$pullRequest' => NULL, 'UpdatePullRequestDescriptionOutput$pullRequest' => '<p>Information about the updated pull request.</p>', 'UpdatePullRequestStatusOutput$pullRequest' => '<p>Information about the pull request.</p>', 'UpdatePullRequestTitleOutput$pullRequest' => '<p>Information about the updated pull request.</p>', ], ], 'PullRequestAlreadyClosedException' => [ 'base' => '<p>The pull request status cannot be updated because it is already closed.</p>', 'refs' => [], ], 'PullRequestApprovalRulesNotSatisfiedException' => [ 'base' => '<p>The pull request cannot be merged because one or more approval rules applied to the pull request have conditions that have not been met.</p>', 'refs' => [], ], 'PullRequestCannotBeApprovedByAuthorException' => [ 'base' => '<p>The approval cannot be applied because the user approving the pull request matches the user who created the pull request. You cannot approve a pull request that you created.</p>', 'refs' => [], ], 'PullRequestCreatedEventMetadata' => [ 'base' => '<p>Metadata about the pull request that is used when comparing the pull request source with its destination.</p>', 'refs' => [ 'PullRequestEvent$pullRequestCreatedEventMetadata' => '<p>Information about the source and destination branches for the pull request.</p>', ], ], 'PullRequestDoesNotExistException' => [ 'base' => '<p>The pull request ID could not be found. Make sure that you have specified the correct repository name and pull request ID, and then try again.</p>', 'refs' => [], ], 'PullRequestEvent' => [ 'base' => '<p>Returns information about a pull request event.</p>', 'refs' => [ 'PullRequestEventList$member' => NULL, ], ], 'PullRequestEventList' => [ 'base' => NULL, 'refs' => [ 'DescribePullRequestEventsOutput$pullRequestEvents' => '<p>Information about the pull request events.</p>', ], ], 'PullRequestEventType' => [ 'base' => NULL, 'refs' => [ 'DescribePullRequestEventsInput$pullRequestEventType' => '<p>Optional. The pull request event type about which you want to return information.</p>', 'PullRequestEvent$pullRequestEventType' => '<p>The type of the pull request event (for example, a status change event (PULL_REQUEST_STATUS_CHANGED) or update event (PULL_REQUEST_SOURCE_REFERENCE_UPDATED)).</p>', ], ], 'PullRequestId' => [ 'base' => NULL, 'refs' => [ 'CommentsForPullRequest$pullRequestId' => '<p>The system-generated ID of the pull request.</p>', 'CreatePullRequestApprovalRuleInput$pullRequestId' => '<p>The system-generated ID of the pull request for which you want to create the approval rule.</p>', 'DeletePullRequestApprovalRuleInput$pullRequestId' => '<p>The system-generated ID of the pull request that contains the approval rule you want to delete.</p>', 'DescribePullRequestEventsInput$pullRequestId' => '<p>The system-generated ID of the pull request. To get this ID, use <a>ListPullRequests</a>.</p>', 'EvaluatePullRequestApprovalRulesInput$pullRequestId' => '<p>The system-generated ID of the pull request you want to evaluate.</p>', 'GetCommentsForPullRequestInput$pullRequestId' => '<p>The system-generated ID of the pull request. To get this ID, use <a>ListPullRequests</a>.</p>', 'GetPullRequestApprovalStatesInput$pullRequestId' => '<p>The system-generated ID for the pull request.</p>', 'GetPullRequestInput$pullRequestId' => '<p>The system-generated ID of the pull request. To get this ID, use <a>ListPullRequests</a>.</p>', 'GetPullRequestOverrideStateInput$pullRequestId' => '<p>The ID of the pull request for which you want to get information about whether approval rules have been set aside (overridden).</p>', 'MergePullRequestByFastForwardInput$pullRequestId' => '<p>The system-generated ID of the pull request. To get this ID, use <a>ListPullRequests</a>.</p>', 'MergePullRequestBySquashInput$pullRequestId' => '<p>The system-generated ID of the pull request. To get this ID, use <a>ListPullRequests</a>.</p>', 'MergePullRequestByThreeWayInput$pullRequestId' => '<p>The system-generated ID of the pull request. To get this ID, use <a>ListPullRequests</a>.</p>', 'OverridePullRequestApprovalRulesInput$pullRequestId' => '<p>The system-generated ID of the pull request for which you want to override all approval rule requirements. To get this information, use <a>GetPullRequest</a>.</p>', 'PostCommentForPullRequestInput$pullRequestId' => '<p>The system-generated ID of the pull request. To get this ID, use <a>ListPullRequests</a>.</p>', 'PostCommentForPullRequestOutput$pullRequestId' => '<p>The system-generated ID of the pull request. </p>', 'PullRequest$pullRequestId' => '<p>The system-generated ID of the pull request. </p>', 'PullRequestEvent$pullRequestId' => '<p>The system-generated ID of the pull request.</p>', 'PullRequestIdList$member' => NULL, 'UpdatePullRequestApprovalRuleContentInput$pullRequestId' => '<p>The system-generated ID of the pull request.</p>', 'UpdatePullRequestApprovalStateInput$pullRequestId' => '<p>The system-generated ID of the pull request.</p>', 'UpdatePullRequestDescriptionInput$pullRequestId' => '<p>The system-generated ID of the pull request. To get this ID, use <a>ListPullRequests</a>.</p>', 'UpdatePullRequestStatusInput$pullRequestId' => '<p>The system-generated ID of the pull request. To get this ID, use <a>ListPullRequests</a>.</p>', 'UpdatePullRequestTitleInput$pullRequestId' => '<p>The system-generated ID of the pull request. To get this ID, use <a>ListPullRequests</a>.</p>', ], ], 'PullRequestIdList' => [ 'base' => NULL, 'refs' => [ 'ListPullRequestsOutput$pullRequestIds' => '<p>The system-generated IDs of the pull requests.</p>', ], ], 'PullRequestIdRequiredException' => [ 'base' => '<p>A pull request ID is required, but none was provided.</p>', 'refs' => [], ], 'PullRequestMergedStateChangedEventMetadata' => [ 'base' => '<p>Returns information about the change in the merge state for a pull request event. </p>', 'refs' => [ 'PullRequestEvent$pullRequestMergedStateChangedEventMetadata' => '<p>Information about the change in mergability state for the pull request event.</p>', ], ], 'PullRequestSourceReferenceUpdatedEventMetadata' => [ 'base' => '<p>Information about an update to the source branch of a pull request.</p>', 'refs' => [ 'PullRequestEvent$pullRequestSourceReferenceUpdatedEventMetadata' => '<p>Information about the updated source branch for the pull request event. </p>', ], ], 'PullRequestStatusChangedEventMetadata' => [ 'base' => '<p>Information about a change to the status of a pull request.</p>', 'refs' => [ 'PullRequestEvent$pullRequestStatusChangedEventMetadata' => '<p>Information about the change in status for the pull request event.</p>', ], ], 'PullRequestStatusEnum' => [ 'base' => NULL, 'refs' => [ 'ListPullRequestsInput$pullRequestStatus' => '<p>Optional. The status of the pull request. If used, this refines the results to the pull requests that match the specified status.</p>', 'PullRequest$pullRequestStatus' => '<p>The status of the pull request. Pull request status can only change from <code>OPEN</code> to <code>CLOSED</code>.</p>', 'PullRequestStatusChangedEventMetadata$pullRequestStatus' => '<p>The changed status of the pull request.</p>', 'UpdatePullRequestStatusInput$pullRequestStatus' => '<p>The status of the pull request. The only valid operations are to update the status from <code>OPEN</code> to <code>OPEN</code>, <code>OPEN</code> to <code>CLOSED</code> or from <code>CLOSED</code> to <code>CLOSED</code>.</p>', ], ], 'PullRequestStatusRequiredException' => [ 'base' => '<p>A pull request status is required, but none was provided.</p>', 'refs' => [], ], 'PullRequestTarget' => [ 'base' => '<p>Returns information about a pull request target.</p>', 'refs' => [ 'PullRequestTargetList$member' => NULL, ], ], 'PullRequestTargetList' => [ 'base' => NULL, 'refs' => [ 'PullRequest$pullRequestTargets' => '<p>The targets of the pull request, including the source branch and destination branch for the pull request.</p>', ], ], 'PutCommentReactionInput' => [ 'base' => NULL, 'refs' => [], ], 'PutFileEntries' => [ 'base' => NULL, 'refs' => [ 'CreateCommitInput$putFiles' => '<p>The files to add or update in this commit.</p>', ], ], 'PutFileEntry' => [ 'base' => '<p>Information about a file added or updated as part of a commit.</p>', 'refs' => [ 'PutFileEntries$member' => NULL, ], ], 'PutFileEntryConflictException' => [ 'base' => '<p>The commit cannot be created because one or more files specified in the commit reference both a file and a folder.</p>', 'refs' => [], ], 'PutFileInput' => [ 'base' => NULL, 'refs' => [], ], 'PutFileOutput' => [ 'base' => NULL, 'refs' => [], ], 'PutRepositoryTriggersInput' => [ 'base' => '<p>Represents the input of a put repository triggers operation.</p>', 'refs' => [], ], 'PutRepositoryTriggersOutput' => [ 'base' => '<p>Represents the output of a put repository triggers operation.</p>', 'refs' => [], ], 'ReactionCountsMap' => [ 'base' => NULL, 'refs' => [ 'Comment$reactionCounts' => '<p>A string to integer map that represents the number of individual users who have responded to a comment with the specified reactions.</p>', ], ], 'ReactionEmoji' => [ 'base' => NULL, 'refs' => [ 'ReactionValueFormats$emoji' => '<p>The Emoji Version 1.0 graphic of the reaction. These graphics are interpreted slightly differently on different operating systems.</p>', ], ], 'ReactionForComment' => [ 'base' => '<p>Information about the reaction values provided by users on a comment.</p>', 'refs' => [ 'ReactionsForCommentList$member' => NULL, ], ], 'ReactionLimitExceededException' => [ 'base' => '<p>The number of reactions has been exceeded. Reactions are limited to one reaction per user for each individual comment ID.</p>', 'refs' => [], ], 'ReactionShortCode' => [ 'base' => NULL, 'refs' => [ 'ReactionValueFormats$shortCode' => '<p>The emoji short code for the reaction. Short codes are interpreted slightly differently on different operating systems. </p>', ], ], 'ReactionUnicode' => [ 'base' => NULL, 'refs' => [ 'ReactionValueFormats$unicode' => '<p>The Unicode codepoint for the reaction.</p>', ], ], 'ReactionUsersList' => [ 'base' => NULL, 'refs' => [ 'ReactionForComment$reactionUsers' => '<p>The Amazon Resource Names (ARNs) of users who have provided reactions to the comment.</p>', ], ], 'ReactionValue' => [ 'base' => NULL, 'refs' => [ 'CallerReactions$member' => NULL, 'PutCommentReactionInput$reactionValue' => '<p>The emoji reaction you want to add or update. To remove a reaction, provide a value of blank or null. You can also provide the value of none. For information about emoji reaction values supported in AWS CodeCommit, see the <a href="https://docs.aws.amazon.com/codecommit/latest/userguide/how-to-commit-comment.html#emoji-reaction-table">AWS CodeCommit User Guide</a>.</p>', 'ReactionCountsMap$key' => NULL, ], ], 'ReactionValueFormats' => [ 'base' => '<p>Information about the values for reactions to a comment. AWS CodeCommit supports a limited set of reactions.</p>', 'refs' => [ 'ReactionForComment$reaction' => '<p>The reaction for a specified comment.</p>', ], ], 'ReactionValueRequiredException' => [ 'base' => '<p>A reaction value is required. </p>', 'refs' => [], ], 'ReactionsForCommentList' => [ 'base' => NULL, 'refs' => [ 'GetCommentReactionsOutput$reactionsForComment' => '<p>An array of reactions to the specified comment.</p>', ], ], 'ReferenceDoesNotExistException' => [ 'base' => '<p>The specified reference does not exist. You must provide a full commit ID.</p>', 'refs' => [], ], 'ReferenceName' => [ 'base' => NULL, 'refs' => [ 'PullRequestMergedStateChangedEventMetadata$destinationReference' => '<p>The name of the branch that the pull request is merged into.</p>', 'PullRequestTarget$sourceReference' => '<p>The branch of the repository that contains the changes for the pull request. Also known as the source branch.</p>', 'PullRequestTarget$destinationReference' => '<p>The branch of the repository where the pull request changes are merged. Also known as the destination branch. </p>', 'Target$sourceReference' => '<p>The branch of the repository that contains the changes for the pull request. Also known as the source branch.</p>', 'Target$destinationReference' => '<p>The branch of the repository where the pull request changes are merged. Also known as the destination branch.</p>', ], ], 'ReferenceNameRequiredException' => [ 'base' => '<p>A reference name is required, but none was provided.</p>', 'refs' => [], ], 'ReferenceTypeNotSupportedException' => [ 'base' => '<p>The specified reference is not a supported type. </p>', 'refs' => [], ], 'RelativeFileVersionEnum' => [ 'base' => NULL, 'refs' => [ 'Location$relativeFileVersion' => '<p>In a comparison of commits or a pull request, whether the change is in the before or after of that comparison.</p>', ], ], 'ReplaceContentEntries' => [ 'base' => NULL, 'refs' => [ 'ConflictResolution$replaceContents' => '<p>Files to have content replaced as part of the merge conflict resolution.</p>', ], ], 'ReplaceContentEntry' => [ 'base' => '<p>Information about a replacement content entry in the conflict of a merge or pull request operation.</p>', 'refs' => [ 'ReplaceContentEntries$member' => NULL, ], ], 'ReplacementContentRequiredException' => [ 'base' => '<p>USE_NEW_CONTENT was specified, but no replacement content has been provided.</p>', 'refs' => [], ], 'ReplacementTypeEnum' => [ 'base' => NULL, 'refs' => [ 'ReplaceContentEntry$replacementType' => '<p>The replacement type to use when determining how to resolve the conflict.</p>', ], ], 'ReplacementTypeRequiredException' => [ 'base' => '<p>A replacement type is required.</p>', 'refs' => [], ], 'RepositoryDescription' => [ 'base' => NULL, 'refs' => [ 'CreateRepositoryInput$repositoryDescription' => '<p>A comment or description about the new repository.</p> <note> <p>The description field for a repository accepts all HTML characters and all valid Unicode characters. Applications that do not HTML-encode the description and display it in a webpage can expose users to potentially malicious code. Make sure that you HTML-encode the description field in any application that uses this API to display the repository description on a webpage.</p> </note>', 'RepositoryMetadata$repositoryDescription' => '<p>A comment or description about the repository.</p>', 'UpdateRepositoryDescriptionInput$repositoryDescription' => '<p>The new comment or description for the specified repository. Repository descriptions are limited to 1,000 characters.</p>', ], ], 'RepositoryDoesNotExistException' => [ 'base' => '<p>The specified repository does not exist.</p>', 'refs' => [], ], 'RepositoryId' => [ 'base' => NULL, 'refs' => [ 'DeleteRepositoryOutput$repositoryId' => '<p>The ID of the repository that was deleted.</p>', 'RepositoryMetadata$repositoryId' => '<p>The ID of the repository.</p>', 'RepositoryNameIdPair$repositoryId' => '<p>The ID associated with the repository.</p>', ], ], 'RepositoryLimitExceededException' => [ 'base' => '<p>A repository resource limit was exceeded.</p>', 'refs' => [], ], 'RepositoryMetadata' => [ 'base' => '<p>Information about a repository.</p>', 'refs' => [ 'CreateRepositoryOutput$repositoryMetadata' => '<p>Information about the newly created repository.</p>', 'GetRepositoryOutput$repositoryMetadata' => '<p>Information about the repository.</p>', 'RepositoryMetadataList$member' => NULL, ], ], 'RepositoryMetadataList' => [ 'base' => NULL, 'refs' => [ 'BatchGetRepositoriesOutput$repositories' => '<p>A list of repositories returned by the batch get repositories operation.</p>', ], ], 'RepositoryName' => [ 'base' => NULL, 'refs' => [ 'AssociateApprovalRuleTemplateWithRepositoryInput$repositoryName' => '<p>The name of the repository that you want to associate with the template.</p>', 'BatchAssociateApprovalRuleTemplateWithRepositoriesError$repositoryName' => '<p>The name of the repository where the association was not made.</p>', 'BatchDescribeMergeConflictsInput$repositoryName' => '<p>The name of the repository that contains the merge conflicts you want to review.</p>', 'BatchDisassociateApprovalRuleTemplateFromRepositoriesError$repositoryName' => '<p>The name of the repository where the association with the template was not able to be removed.</p>', 'BatchGetCommitsInput$repositoryName' => '<p>The name of the repository that contains the commits.</p>', 'CommentsForComparedCommit$repositoryName' => '<p>The name of the repository that contains the compared commits.</p>', 'CommentsForPullRequest$repositoryName' => '<p>The name of the repository that contains the pull request.</p>', 'CreateBranchInput$repositoryName' => '<p>The name of the repository in which you want to create the new branch.</p>', 'CreateCommitInput$repositoryName' => '<p>The name of the repository where you create the commit.</p>', 'CreateRepositoryInput$repositoryName' => '<p>The name of the new repository to be created.</p> <note> <p>The repository name must be unique across the calling AWS account. Repository names are limited to 100 alphanumeric, dash, and underscore characters, and cannot include certain characters. For more information about the limits on repository names, see <a href="https://docs.aws.amazon.com/codecommit/latest/userguide/limits.html">Limits</a> in the <i>AWS CodeCommit User Guide</i>. The suffix .git is prohibited.</p> </note>', 'CreateUnreferencedMergeCommitInput$repositoryName' => '<p>The name of the repository where you want to create the unreferenced merge commit.</p>', 'DeleteBranchInput$repositoryName' => '<p>The name of the repository that contains the branch to be deleted.</p>', 'DeleteFileInput$repositoryName' => '<p>The name of the repository that contains the file to delete.</p>', 'DeleteRepositoryInput$repositoryName' => '<p>The name of the repository to delete.</p>', 'DescribeMergeConflictsInput$repositoryName' => '<p>The name of the repository where you want to get information about a merge conflict.</p>', 'DisassociateApprovalRuleTemplateFromRepositoryInput$repositoryName' => '<p>The name of the repository you want to disassociate from the template.</p>', 'GetBlobInput$repositoryName' => '<p>The name of the repository that contains the blob.</p>', 'GetBranchInput$repositoryName' => '<p>The name of the repository that contains the branch for which you want to retrieve information.</p>', 'GetCommentsForComparedCommitInput$repositoryName' => '<p>The name of the repository where you want to compare commits.</p>', 'GetCommentsForPullRequestInput$repositoryName' => '<p>The name of the repository that contains the pull request.</p>', 'GetCommitInput$repositoryName' => '<p>The name of the repository to which the commit was made.</p>', 'GetDifferencesInput$repositoryName' => '<p>The name of the repository where you want to get differences.</p>', 'GetFileInput$repositoryName' => '<p>The name of the repository that contains the file.</p>', 'GetFolderInput$repositoryName' => '<p>The name of the repository.</p>', 'GetMergeCommitInput$repositoryName' => '<p>The name of the repository that contains the merge commit about which you want to get information.</p>', 'GetMergeConflictsInput$repositoryName' => '<p>The name of the repository where the pull request was created.</p>', 'GetMergeOptionsInput$repositoryName' => '<p>The name of the repository that contains the commits about which you want to get merge options.</p>', 'GetRepositoryInput$repositoryName' => '<p>The name of the repository to get information about.</p>', 'GetRepositoryTriggersInput$repositoryName' => '<p>The name of the repository for which the trigger is configured.</p>', 'ListAssociatedApprovalRuleTemplatesForRepositoryInput$repositoryName' => '<p>The name of the repository for which you want to list all associated approval rule templates.</p>', 'ListBranchesInput$repositoryName' => '<p>The name of the repository that contains the branches.</p>', 'ListPullRequestsInput$repositoryName' => '<p>The name of the repository for which you want to list pull requests.</p>', 'MergeBranchesByFastForwardInput$repositoryName' => '<p>The name of the repository where you want to merge two branches.</p>', 'MergeBranchesBySquashInput$repositoryName' => '<p>The name of the repository where you want to merge two branches.</p>', 'MergeBranchesByThreeWayInput$repositoryName' => '<p>The name of the repository where you want to merge two branches.</p>', 'MergePullRequestByFastForwardInput$repositoryName' => '<p>The name of the repository where the pull request was created.</p>', 'MergePullRequestBySquashInput$repositoryName' => '<p>The name of the repository where the pull request was created.</p>', 'MergePullRequestByThreeWayInput$repositoryName' => '<p>The name of the repository where the pull request was created.</p>', 'PostCommentForComparedCommitInput$repositoryName' => '<p>The name of the repository where you want to post a comment on the comparison between commits.</p>', 'PostCommentForComparedCommitOutput$repositoryName' => '<p>The name of the repository where you posted a comment on the comparison between commits.</p>', 'PostCommentForPullRequestInput$repositoryName' => '<p>The name of the repository where you want to post a comment on a pull request.</p>', 'PostCommentForPullRequestOutput$repositoryName' => '<p>The name of the repository where you posted a comment on a pull request.</p>', 'PullRequestCreatedEventMetadata$repositoryName' => '<p>The name of the repository where the pull request was created.</p>', 'PullRequestMergedStateChangedEventMetadata$repositoryName' => '<p>The name of the repository where the pull request was created.</p>', 'PullRequestSourceReferenceUpdatedEventMetadata$repositoryName' => '<p>The name of the repository where the pull request was updated.</p>', 'PullRequestTarget$repositoryName' => '<p>The name of the repository that contains the pull request source and destination branches.</p>', 'PutFileInput$repositoryName' => '<p>The name of the repository where you want to add or update the file.</p>', 'PutRepositoryTriggersInput$repositoryName' => '<p>The name of the repository where you want to create or update the trigger.</p>', 'RepositoryMetadata$repositoryName' => '<p>The repository\'s name.</p>', 'RepositoryNameIdPair$repositoryName' => '<p>The name associated with the repository.</p>', 'RepositoryNameList$member' => NULL, 'RepositoryNotFoundList$member' => NULL, 'Target$repositoryName' => '<p>The name of the repository that contains the pull request.</p>', 'TestRepositoryTriggersInput$repositoryName' => '<p>The name of the repository in which to test the triggers.</p>', 'UpdateDefaultBranchInput$repositoryName' => '<p>The name of the repository to set or change the default branch for.</p>', 'UpdateRepositoryDescriptionInput$repositoryName' => '<p>The name of the repository to set or change the comment or description for.</p>', 'UpdateRepositoryNameInput$oldName' => '<p>The current name of the repository.</p>', 'UpdateRepositoryNameInput$newName' => '<p>The new name for the repository.</p>', ], ], 'RepositoryNameExistsException' => [ 'base' => '<p>The specified repository name already exists.</p>', 'refs' => [], ], 'RepositoryNameIdPair' => [ 'base' => '<p>Information about a repository name and ID.</p>', 'refs' => [ 'RepositoryNameIdPairList$member' => NULL, ], ], 'RepositoryNameIdPairList' => [ 'base' => NULL, 'refs' => [ 'ListRepositoriesOutput$repositories' => '<p>Lists the repositories called by the list repositories operation.</p>', ], ], 'RepositoryNameList' => [ 'base' => NULL, 'refs' => [ 'BatchAssociateApprovalRuleTemplateWithRepositoriesInput$repositoryNames' => '<p>The names of the repositories you want to associate with the template.</p> <note> <p>The length constraint limit is for each string in the array. The array itself can be empty.</p> </note>', 'BatchAssociateApprovalRuleTemplateWithRepositoriesOutput$associatedRepositoryNames' => '<p>A list of names of the repositories that have been associated with the template.</p>', 'BatchDisassociateApprovalRuleTemplateFromRepositoriesInput$repositoryNames' => '<p>The repository names that you want to disassociate from the approval rule template.</p> <note> <p>The length constraint limit is for each string in the array. The array itself can be empty.</p> </note>', 'BatchDisassociateApprovalRuleTemplateFromRepositoriesOutput$disassociatedRepositoryNames' => '<p>A list of repository names that have had their association with the template removed.</p>', 'BatchGetRepositoriesInput$repositoryNames' => '<p>The names of the repositories to get information about.</p> <note> <p>The length constraint limit is for each string in the array. The array itself can be empty.</p> </note>', 'ListRepositoriesForApprovalRuleTemplateOutput$repositoryNames' => '<p>A list of repository names that are associated with the specified approval rule template.</p>', ], ], 'RepositoryNameRequiredException' => [ 'base' => '<p>A repository name is required, but was not specified.</p>', 'refs' => [], ], 'RepositoryNamesRequiredException' => [ 'base' => '<p>At least one repository name object is required, but was not specified.</p>', 'refs' => [], ], 'RepositoryNotAssociatedWithPullRequestException' => [ 'base' => '<p>The repository does not contain any pull requests with that pull request ID. Use GetPullRequest to verify the correct repository name for the pull request ID.</p>', 'refs' => [], ], 'RepositoryNotFoundList' => [ 'base' => NULL, 'refs' => [ 'BatchGetRepositoriesOutput$repositoriesNotFound' => '<p>Returns a list of repository names for which information could not be found.</p>', ], ], 'RepositoryTrigger' => [ 'base' => '<p>Information about a trigger for a repository.</p>', 'refs' => [ 'RepositoryTriggersList$member' => NULL, ], ], 'RepositoryTriggerBranchNameListRequiredException' => [ 'base' => '<p>At least one branch name is required, but was not specified in the trigger configuration.</p>', 'refs' => [], ], 'RepositoryTriggerCustomData' => [ 'base' => NULL, 'refs' => [ 'RepositoryTrigger$customData' => '<p>Any custom data associated with the trigger to be included in the information sent to the target of the trigger.</p>', ], ], 'RepositoryTriggerDestinationArnRequiredException' => [ 'base' => '<p>A destination ARN for the target service for the trigger is required, but was not specified.</p>', 'refs' => [], ], 'RepositoryTriggerEventEnum' => [ 'base' => NULL, 'refs' => [ 'RepositoryTriggerEventList$member' => NULL, ], ], 'RepositoryTriggerEventList' => [ 'base' => NULL, 'refs' => [ 'RepositoryTrigger$events' => '<p>The repository events that cause the trigger to run actions in another service, such as sending a notification through Amazon SNS. </p> <note> <p>The valid value "all" cannot be used with any other values.</p> </note>', ], ], 'RepositoryTriggerEventsListRequiredException' => [ 'base' => '<p>At least one event for the trigger is required, but was not specified.</p>', 'refs' => [], ], 'RepositoryTriggerExecutionFailure' => [ 'base' => '<p>A trigger failed to run.</p>', 'refs' => [ 'RepositoryTriggerExecutionFailureList$member' => NULL, ], ], 'RepositoryTriggerExecutionFailureList' => [ 'base' => NULL, 'refs' => [ 'TestRepositoryTriggersOutput$failedExecutions' => '<p>The list of triggers that were not tested. This list provides the names of the triggers that could not be tested, separated by commas.</p>', ], ], 'RepositoryTriggerExecutionFailureMessage' => [ 'base' => NULL, 'refs' => [ 'RepositoryTriggerExecutionFailure$failureMessage' => '<p>Message information about the trigger that did not run.</p>', ], ], 'RepositoryTriggerName' => [ 'base' => NULL, 'refs' => [ 'RepositoryTrigger$name' => '<p>The name of the trigger.</p>', 'RepositoryTriggerExecutionFailure$trigger' => '<p>The name of the trigger that did not run.</p>', 'RepositoryTriggerNameList$member' => NULL, ], ], 'RepositoryTriggerNameList' => [ 'base' => NULL, 'refs' => [ 'TestRepositoryTriggersOutput$successfulExecutions' => '<p>The list of triggers that were successfully tested. This list provides the names of the triggers that were successfully tested, separated by commas.</p>', ], ], 'RepositoryTriggerNameRequiredException' => [ 'base' => '<p>A name for the trigger is required, but was not specified.</p>', 'refs' => [], ], 'RepositoryTriggersConfigurationId' => [ 'base' => NULL, 'refs' => [ 'GetRepositoryTriggersOutput$configurationId' => '<p>The system-generated unique ID for the trigger.</p>', 'PutRepositoryTriggersOutput$configurationId' => '<p>The system-generated unique ID for the create or update operation.</p>', ], ], 'RepositoryTriggersList' => [ 'base' => NULL, 'refs' => [ 'GetRepositoryTriggersOutput$triggers' => '<p>The JSON block of configuration information for each trigger.</p>', 'PutRepositoryTriggersInput$triggers' => '<p>The JSON block of configuration information for each trigger.</p>', 'TestRepositoryTriggersInput$triggers' => '<p>The list of triggers to test.</p>', ], ], 'RepositoryTriggersListRequiredException' => [ 'base' => '<p>The list of triggers for the repository is required, but was not specified.</p>', 'refs' => [], ], 'ResourceArn' => [ 'base' => NULL, 'refs' => [ 'ListTagsForResourceInput$resourceArn' => '<p>The Amazon Resource Name (ARN) of the resource for which you want to get information about tags, if any.</p>', 'TagResourceInput$resourceArn' => '<p>The Amazon Resource Name (ARN) of the resource to which you want to add or update tags.</p>', 'UntagResourceInput$resourceArn' => '<p>The Amazon Resource Name (ARN) of the resource to which you want to remove tags.</p>', ], ], 'ResourceArnRequiredException' => [ 'base' => '<p>A valid Amazon Resource Name (ARN) for an AWS CodeCommit resource is required. For a list of valid resources in AWS CodeCommit, see <a href="https://docs.aws.amazon.com/codecommit/latest/userguide/auth-and-access-control-iam-access-control-identity-based.html#arn-formats">CodeCommit Resources and Operations</a> in the AWS CodeCommit User Guide.</p>', 'refs' => [], ], 'RestrictedSourceFileException' => [ 'base' => '<p>The commit cannot be created because one of the changes specifies copying or moving a .gitkeep file.</p>', 'refs' => [], ], 'RevisionId' => [ 'base' => NULL, 'refs' => [ 'ApprovalRuleOverriddenEventMetadata$revisionId' => '<p>The revision ID of the pull request when the override event occurred.</p>', 'ApprovalStateChangedEventMetadata$revisionId' => '<p>The revision ID of the pull request when the approval state changed.</p>', 'EvaluatePullRequestApprovalRulesInput$revisionId' => '<p>The system-generated ID for the pull request revision. To retrieve the most recent revision ID for a pull request, use <a>GetPullRequest</a>.</p>', 'GetPullRequestApprovalStatesInput$revisionId' => '<p>The system-generated ID for the pull request revision.</p>', 'GetPullRequestOverrideStateInput$revisionId' => '<p>The system-generated ID of the revision for the pull request. To retrieve the most recent revision ID, use <a>GetPullRequest</a>.</p>', 'OverridePullRequestApprovalRulesInput$revisionId' => '<p>The system-generated ID of the most recent revision of the pull request. You cannot override approval rules for anything but the most recent revision of a pull request. To get the revision ID, use GetPullRequest.</p>', 'PullRequest$revisionId' => '<p>The system-generated revision ID for the pull request.</p>', 'UpdatePullRequestApprovalStateInput$revisionId' => '<p>The system-generated ID of the revision.</p>', ], ], 'RevisionIdRequiredException' => [ 'base' => '<p>A revision ID is required, but was not provided.</p>', 'refs' => [], ], 'RevisionNotCurrentException' => [ 'base' => '<p>The revision ID provided in the request does not match the current revision ID. Use GetPullRequest to retrieve the current revision ID.</p>', 'refs' => [], ], 'RuleContentSha256' => [ 'base' => NULL, 'refs' => [ 'ApprovalRule$ruleContentSha256' => '<p>The SHA-256 hash signature for the content of the approval rule.</p>', 'ApprovalRuleTemplate$ruleContentSha256' => '<p>The SHA-256 hash signature for the content of the approval rule template.</p>', 'UpdateApprovalRuleTemplateContentInput$existingRuleContentSha256' => '<p>The SHA-256 hash signature for the content of the approval rule. You can retrieve this information by using <a>GetPullRequest</a>.</p>', 'UpdatePullRequestApprovalRuleContentInput$existingRuleContentSha256' => '<p>The SHA-256 hash signature for the content of the approval rule. You can retrieve this information by using <a>GetPullRequest</a>.</p>', ], ], 'SameFileContentException' => [ 'base' => '<p>The file was not added or updated because the content of the file is exactly the same as the content of that file in the repository and branch that you specified.</p>', 'refs' => [], ], 'SamePathRequestException' => [ 'base' => '<p>The commit cannot be created because one or more changes in this commit duplicate actions in the same file path. For example, you cannot make the same delete request to the same file in the same file path twice, or make a delete request and a move request to the same file as part of the same commit.</p>', 'refs' => [], ], 'SetFileModeEntries' => [ 'base' => NULL, 'refs' => [ 'ConflictResolution$setFileModes' => '<p>File modes that are set as part of the merge conflict resolution.</p>', 'CreateCommitInput$setFileModes' => '<p>The file modes to update for files in this commit.</p>', ], ], 'SetFileModeEntry' => [ 'base' => '<p>Information about the file mode changes.</p>', 'refs' => [ 'SetFileModeEntries$member' => NULL, ], ], 'SortByEnum' => [ 'base' => NULL, 'refs' => [ 'ListRepositoriesInput$sortBy' => '<p>The criteria used to sort the results of a list repositories operation.</p>', ], ], 'SourceAndDestinationAreSameException' => [ 'base' => '<p>The source branch and destination branch for the pull request are the same. You must specify different branches for the source and destination.</p>', 'refs' => [], ], 'SourceFileOrContentRequiredException' => [ 'base' => '<p>The commit cannot be created because no source files or file content have been specified for the commit.</p>', 'refs' => [], ], 'SourceFileSpecifier' => [ 'base' => '<p>Information about a source file that is part of changes made in a commit.</p>', 'refs' => [ 'PutFileEntry$sourceFile' => '<p>The name and full path of the file that contains the changes you want to make as part of the commit, if you are not providing the file content directly.</p>', ], ], 'SubModule' => [ 'base' => '<p>Returns information about a submodule reference in a repository folder.</p>', 'refs' => [ 'SubModuleList$member' => NULL, ], ], 'SubModuleList' => [ 'base' => NULL, 'refs' => [ 'GetFolderOutput$subModules' => '<p>The list of submodules in the specified folder, if any.</p>', ], ], 'SymbolicLink' => [ 'base' => '<p>Returns information about a symbolic link in a repository folder.</p>', 'refs' => [ 'SymbolicLinkList$member' => NULL, ], ], 'SymbolicLinkList' => [ 'base' => NULL, 'refs' => [ 'GetFolderOutput$symbolicLinks' => '<p>The list of symbolic links to other files and folders in the specified folder, if any.</p>', ], ], 'TagKey' => [ 'base' => NULL, 'refs' => [ 'TagKeysList$member' => NULL, 'TagsMap$key' => NULL, ], ], 'TagKeysList' => [ 'base' => NULL, 'refs' => [ 'UntagResourceInput$tagKeys' => '<p>The tag key for each tag that you want to remove from the resource.</p>', ], ], 'TagKeysListRequiredException' => [ 'base' => '<p>A list of tag keys is required. The list cannot be empty or null.</p>', 'refs' => [], ], 'TagPolicyException' => [ 'base' => '<p>The tag policy is not valid.</p>', 'refs' => [], ], 'TagResourceInput' => [ 'base' => NULL, 'refs' => [], ], 'TagValue' => [ 'base' => NULL, 'refs' => [ 'TagsMap$value' => NULL, ], ], 'TagsMap' => [ 'base' => NULL, 'refs' => [ 'CreateRepositoryInput$tags' => '<p>One or more tag key-value pairs to use when tagging this repository.</p>', 'ListTagsForResourceOutput$tags' => '<p>A list of tag key and value pairs associated with the specified resource.</p>', 'TagResourceInput$tags' => '<p>The key-value pair to use when tagging this repository.</p>', ], ], 'TagsMapRequiredException' => [ 'base' => '<p>A map of tags is required.</p>', 'refs' => [], ], 'Target' => [ 'base' => '<p>Returns information about a target for a pull request.</p>', 'refs' => [ 'TargetList$member' => NULL, ], ], 'TargetList' => [ 'base' => NULL, 'refs' => [ 'CreatePullRequestInput$targets' => '<p>The targets for the pull request, including the source of the code to be reviewed (the source branch) and the destination where the creator of the pull request intends the code to be merged after the pull request is closed (the destination branch).</p>', ], ], 'TargetRequiredException' => [ 'base' => '<p>A pull request target is required. It cannot be empty or null. A pull request target must contain the full values for the repository name, source branch, and destination branch for the pull request.</p>', 'refs' => [], ], 'TargetsRequiredException' => [ 'base' => '<p>An array of target objects is required. It cannot be empty or null.</p>', 'refs' => [], ], 'TestRepositoryTriggersInput' => [ 'base' => '<p>Represents the input of a test repository triggers operation.</p>', 'refs' => [], ], 'TestRepositoryTriggersOutput' => [ 'base' => '<p>Represents the output of a test repository triggers operation.</p>', 'refs' => [], ], 'TipOfSourceReferenceIsDifferentException' => [ 'base' => '<p>The tip of the source branch in the destination repository does not match the tip of the source branch specified in your request. The pull request might have been updated. Make sure that you have the latest changes.</p>', 'refs' => [], ], 'TipsDivergenceExceededException' => [ 'base' => '<p>The divergence between the tips of the provided commit specifiers is too great to determine whether there might be any merge conflicts. Locally compare the specifiers using <code>git diff</code> or a diff tool.</p>', 'refs' => [], ], 'Title' => [ 'base' => NULL, 'refs' => [ 'CreatePullRequestInput$title' => '<p>The title of the pull request. This title is used to identify the pull request to other users in the repository.</p>', 'PullRequest$title' => '<p>The user-defined title of the pull request. This title is displayed in the list of pull requests to other repository users.</p>', 'UpdatePullRequestTitleInput$title' => '<p>The updated title of the pull request. This replaces the existing title.</p>', ], ], 'TitleRequiredException' => [ 'base' => '<p>A pull request title is required. It cannot be empty or null.</p>', 'refs' => [], ], 'TooManyTagsException' => [ 'base' => '<p>The maximum number of tags for an AWS CodeCommit resource has been exceeded.</p>', 'refs' => [], ], 'UntagResourceInput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateApprovalRuleTemplateContentInput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateApprovalRuleTemplateContentOutput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateApprovalRuleTemplateDescriptionInput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateApprovalRuleTemplateDescriptionOutput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateApprovalRuleTemplateNameInput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateApprovalRuleTemplateNameOutput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateCommentInput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateCommentOutput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateDefaultBranchInput' => [ 'base' => '<p>Represents the input of an update default branch operation.</p>', 'refs' => [], ], 'UpdatePullRequestApprovalRuleContentInput' => [ 'base' => NULL, 'refs' => [], ], 'UpdatePullRequestApprovalRuleContentOutput' => [ 'base' => NULL, 'refs' => [], ], 'UpdatePullRequestApprovalStateInput' => [ 'base' => NULL, 'refs' => [], ], 'UpdatePullRequestDescriptionInput' => [ 'base' => NULL, 'refs' => [], ], 'UpdatePullRequestDescriptionOutput' => [ 'base' => NULL, 'refs' => [], ], 'UpdatePullRequestStatusInput' => [ 'base' => NULL, 'refs' => [], ], 'UpdatePullRequestStatusOutput' => [ 'base' => NULL, 'refs' => [], ], 'UpdatePullRequestTitleInput' => [ 'base' => NULL, 'refs' => [], ], 'UpdatePullRequestTitleOutput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateRepositoryDescriptionInput' => [ 'base' => '<p>Represents the input of an update repository description operation.</p>', 'refs' => [], ], 'UpdateRepositoryNameInput' => [ 'base' => '<p>Represents the input of an update repository description operation.</p>', 'refs' => [], ], 'UserInfo' => [ 'base' => '<p>Information about the user who made a specified commit.</p>', 'refs' => [ 'Commit$author' => '<p>Information about the author of the specified commit. Information includes the date in timestamp format with GMT offset, the name of the author, and the email address for the author, as configured in Git.</p>', 'Commit$committer' => '<p>Information about the person who committed the specified commit, also known as the committer. Information includes the date in timestamp format with GMT offset, the name of the committer, and the email address for the committer, as configured in Git.</p> <p>For more information about the difference between an author and a committer in Git, see <a href="http://git-scm.com/book/ch2-3.html">Viewing the Commit History</a> in Pro Git by Scott Chacon and Ben Straub.</p>', ], ], 'blob' => [ 'base' => NULL, 'refs' => [ 'GetBlobOutput$content' => '<p>The content of the blob, usually a file.</p>', ], ], ],];
