<?php
// This file was auto-generated from sdk-root/src/data/cloudcontrol/2021-09-30/docs-2.json
return [ 'version' => '2.0', 'service' => '<p>For more information about Amazon Web Services Cloud Control API, see the <a href="https://docs.aws.amazon.com/cloudcontrolapi/latest/userguide/what-is-cloudcontrolapi.html">Amazon Web Services Cloud Control API User Guide</a>.</p>', 'operations' => [ 'CancelResourceRequest' => '<p>Cancels the specified resource operation request. For more information, see <a href="https://docs.aws.amazon.com/cloudcontrolapi/latest/userguide/resource-operations-manage-requests.html#resource-operations-manage-requests-cancel">Canceling resource operation requests</a> in the <i>Amazon Web Services Cloud Control API User Guide</i>.</p> <p>Only resource operations requests with a status of <code>PENDING</code> or <code>IN_PROGRESS</code> can be canceled.</p>', 'CreateResource' => '<p>Creates the specified resource. For more information, see <a href="https://docs.aws.amazon.com/cloudcontrolapi/latest/userguide/resource-operations-create.html">Creating a resource</a> in the <i>Amazon Web Services Cloud Control API User Guide</i>.</p> <p>After you have initiated a resource creation request, you can monitor the progress of your request by calling <a href="https://docs.aws.amazon.com/cloudcontrolapi/latest/APIReference/API_GetResourceRequestStatus.html">GetResourceRequestStatus</a> using the <code>RequestToken</code> of the <code>ProgressEvent</code> type returned by <code>CreateResource</code>.</p>', 'DeleteResource' => '<p>Deletes the specified resource. For details, see <a href="https://docs.aws.amazon.com/cloudcontrolapi/latest/userguide/resource-operations-delete.html">Deleting a resource</a> in the <i>Amazon Web Services Cloud Control API User Guide</i>.</p> <p>After you have initiated a resource deletion request, you can monitor the progress of your request by calling <a href="https://docs.aws.amazon.com/cloudcontrolapi/latest/APIReference/API_GetResourceRequestStatus.html">GetResourceRequestStatus</a> using the <code>RequestToken</code> of the <code>ProgressEvent</code> returned by <code>DeleteResource</code>.</p>', 'GetResource' => '<p>Returns information about the current state of the specified resource. For details, see <a href="https://docs.aws.amazon.com/cloudcontrolapi/latest/userguide/resource-operations-read.html">Reading a resource\'s current state</a>.</p> <p>You can use this action to return information about an existing resource in your account and Amazon Web Services Region, whether those resources were provisioned using Cloud Control API.</p>', 'GetResourceRequestStatus' => '<p>Returns the current status of a resource operation request. For more information, see <a href="https://docs.aws.amazon.com/cloudcontrolapi/latest/userguide/resource-operations-manage-requests.html#resource-operations-manage-requests-track">Tracking the progress of resource operation requests</a> in the <i>Amazon Web Services Cloud Control API User Guide</i>.</p>', 'ListResourceRequests' => '<p>Returns existing resource operation requests. This includes requests of all status types. For more information, see <a href="https://docs.aws.amazon.com/cloudcontrolapi/latest/userguide/resource-operations-manage-requests.html#resource-operations-manage-requests-list">Listing active resource operation requests</a> in the <i>Amazon Web Services Cloud Control API User Guide</i>.</p> <note> <p>Resource operation requests expire after 7 days.</p> </note>', 'ListResources' => '<p>Returns information about the specified resources. For more information, see <a href="https://docs.aws.amazon.com/cloudcontrolapi/latest/userguide/resource-operations-list.html">Discovering resources</a> in the <i>Amazon Web Services Cloud Control API User Guide</i>.</p> <p>You can use this action to return information about existing resources in your account and Amazon Web Services Region, whether those resources were provisioned using Cloud Control API.</p>', 'UpdateResource' => '<p>Updates the specified property values in the resource.</p> <p>You specify your resource property updates as a list of patch operations contained in a JSON patch document that adheres to the <a href="https://datatracker.ietf.org/doc/html/rfc6902"> <i>RFC 6902 - JavaScript Object Notation (JSON) Patch</i> </a> standard.</p> <p>For details on how Cloud Control API performs resource update operations, see <a href="https://docs.aws.amazon.com/cloudcontrolapi/latest/userguide/resource-operations-update.html">Updating a resource</a> in the <i>Amazon Web Services Cloud Control API User Guide</i>.</p> <p>After you have initiated a resource update request, you can monitor the progress of your request by calling <a href="https://docs.aws.amazon.com/cloudcontrolapi/latest/APIReference/API_GetResourceRequestStatus.html">GetResourceRequestStatus</a> using the <code>RequestToken</code> of the <code>ProgressEvent</code> returned by <code>UpdateResource</code>.</p> <p>For more information about the properties of a specific resource, refer to the related topic for the resource in the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html">Resource and property types reference</a> in the <i>CloudFormation Users Guide</i>.</p>', ], 'shapes' => [ 'AlreadyExistsException' => [ 'base' => '<p>The resource with the name requested already exists.</p>', 'refs' => [], ], 'CancelResourceRequestInput' => [ 'base' => NULL, 'refs' => [], ], 'CancelResourceRequestOutput' => [ 'base' => NULL, 'refs' => [], ], 'ClientToken' => [ 'base' => NULL, 'refs' => [ 'CreateResourceInput$ClientToken' => '<p>A unique identifier to ensure the idempotency of the resource request. As a best practice, specify this token to ensure idempotency, so that Amazon Web Services Cloud Control API can accurately distinguish between request retries and new resource requests. You might retry a resource request to ensure that it was successfully received.</p> <p>A client token is valid for 36 hours once used. After that, a resource request with the same client token is treated as a new request.</p> <p>If you do not specify a client token, one is generated for inclusion in the request.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/cloudcontrolapi/latest/userguide/resource-operations.html#resource-operations-idempotency">Ensuring resource operation requests are unique</a> in the <i>Amazon Web Services Cloud Control API User Guide</i>.</p>', 'DeleteResourceInput$ClientToken' => '<p>A unique identifier to ensure the idempotency of the resource request. As a best practice, specify this token to ensure idempotency, so that Amazon Web Services Cloud Control API can accurately distinguish between request retries and new resource requests. You might retry a resource request to ensure that it was successfully received.</p> <p>A client token is valid for 36 hours once used. After that, a resource request with the same client token is treated as a new request.</p> <p>If you do not specify a client token, one is generated for inclusion in the request.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/cloudcontrolapi/latest/userguide/resource-operations.html#resource-operations-idempotency">Ensuring resource operation requests are unique</a> in the <i>Amazon Web Services Cloud Control API User Guide</i>.</p>', 'UpdateResourceInput$ClientToken' => '<p>A unique identifier to ensure the idempotency of the resource request. As a best practice, specify this token to ensure idempotency, so that Amazon Web Services Cloud Control API can accurately distinguish between request retries and new resource requests. You might retry a resource request to ensure that it was successfully received.</p> <p>A client token is valid for 36 hours once used. After that, a resource request with the same client token is treated as a new request.</p> <p>If you do not specify a client token, one is generated for inclusion in the request.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/cloudcontrolapi/latest/userguide/resource-operations.html#resource-operations-idempotency">Ensuring resource operation requests are unique</a> in the <i>Amazon Web Services Cloud Control API User Guide</i>.</p>', ], ], 'ClientTokenConflictException' => [ 'base' => '<p>The specified client token has already been used in another resource request.</p> <p>It\'s best practice for client tokens to be unique for each resource operation request. However, client token expire after 36 hours.</p>', 'refs' => [], ], 'ConcurrentModificationException' => [ 'base' => '<p>The resource is currently being modified by another operation.</p>', 'refs' => [], ], 'ConcurrentOperationException' => [ 'base' => '<p>Another resource operation is currently being performed on this resource.</p>', 'refs' => [], ], 'CreateResourceInput' => [ 'base' => NULL, 'refs' => [], ], 'CreateResourceOutput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteResourceInput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteResourceOutput' => [ 'base' => NULL, 'refs' => [], ], 'ErrorMessage' => [ 'base' => NULL, 'refs' => [ 'AlreadyExistsException$Message' => NULL, 'ClientTokenConflictException$Message' => NULL, 'ConcurrentModificationException$Message' => NULL, 'ConcurrentOperationException$Message' => NULL, 'GeneralServiceException$Message' => NULL, 'HandlerFailureException$Message' => NULL, 'HandlerInternalFailureException$Message' => NULL, 'InvalidCredentialsException$Message' => NULL, 'InvalidRequestException$Message' => NULL, 'NetworkFailureException$Message' => NULL, 'NotStabilizedException$Message' => NULL, 'NotUpdatableException$Message' => NULL, 'PrivateTypeException$Message' => NULL, 'RequestTokenNotFoundException$Message' => NULL, 'ResourceConflictException$Message' => NULL, 'ResourceNotFoundException$Message' => NULL, 'ServiceInternalErrorException$Message' => NULL, 'ServiceLimitExceededException$Message' => NULL, 'ThrottlingException$Message' => NULL, 'TypeNotFoundException$Message' => NULL, 'UnsupportedActionException$Message' => NULL, ], ], 'GeneralServiceException' => [ 'base' => '<p>The resource handler has returned that the downstream service generated an error that doesn\'t map to any other handler error code.</p>', 'refs' => [], ], 'GetResourceInput' => [ 'base' => NULL, 'refs' => [], ], 'GetResourceOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetResourceRequestStatusInput' => [ 'base' => NULL, 'refs' => [], ], 'GetResourceRequestStatusOutput' => [ 'base' => NULL, 'refs' => [], ], 'HandlerErrorCode' => [ 'base' => NULL, 'refs' => [ 'ProgressEvent$ErrorCode' => '<p>For requests with a status of <code>FAILED</code>, the associated error code.</p> <p>For error code definitions, see <a href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/resource-type-test-contract-errors.html">Handler error codes</a> in the <i>CloudFormation Command Line Interface User Guide for Extension Development</i>.</p>', ], ], 'HandlerFailureException' => [ 'base' => '<p>The resource handler has failed without a returning a more specific error code. This can include timeouts.</p>', 'refs' => [], ], 'HandlerInternalFailureException' => [ 'base' => '<p>The resource handler has returned that an unexpected error occurred within the resource handler.</p>', 'refs' => [], ], 'HandlerNextToken' => [ 'base' => NULL, 'refs' => [ 'ListResourcesInput$NextToken' => '<p>If the previous paginated request didn\'t return all of the remaining results, the response object\'s <code>NextToken</code> parameter value is set to a token. To retrieve the next set of results, call this action again and assign that token to the request object\'s <code>NextToken</code> parameter. If there are no remaining results, the previous response object\'s <code>NextToken</code> parameter is set to <code>null</code>.</p>', 'ListResourcesOutput$NextToken' => '<p>If the request doesn\'t return all of the remaining results, <code>NextToken</code> is set to a token. To retrieve the next set of results, call <code>ListResources</code> again and assign that token to the request object\'s <code>NextToken</code> parameter. If the request returns all results, <code>NextToken</code> is set to null.</p>', ], ], 'Identifier' => [ 'base' => NULL, 'refs' => [ 'DeleteResourceInput$Identifier' => '<p>The identifier for the resource.</p> <p>You can specify the primary identifier, or any secondary identifier defined for the resource type in its resource schema. You can only specify one identifier. Primary identifiers can be specified as a string or JSON; secondary identifiers must be specified as JSON.</p> <p>For compound primary identifiers (that is, one that consists of multiple resource properties strung together), to specify the primary identifier as a string, list the property values <i>in the order they are specified</i> in the primary identifier definition, separated by <code>|</code>.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/cloudcontrolapi/latest/userguide/resource-identifier.html">Identifying resources</a> in the <i>Amazon Web Services Cloud Control API User Guide</i>.</p>', 'GetResourceInput$Identifier' => '<p>The identifier for the resource.</p> <p>You can specify the primary identifier, or any secondary identifier defined for the resource type in its resource schema. You can only specify one identifier. Primary identifiers can be specified as a string or JSON; secondary identifiers must be specified as JSON.</p> <p>For compound primary identifiers (that is, one that consists of multiple resource properties strung together), to specify the primary identifier as a string, list the property values <i>in the order they are specified</i> in the primary identifier definition, separated by <code>|</code>.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/cloudcontrolapi/latest/userguide/resource-identifier.html">Identifying resources</a> in the <i>Amazon Web Services Cloud Control API User Guide</i>.</p>', 'ProgressEvent$Identifier' => '<p>The primary identifier for the resource.</p> <note> <p>In some cases, the resource identifier may be available before the resource operation has reached a status of <code>SUCCESS</code>.</p> </note>', 'ResourceDescription$Identifier' => '<p>The primary identifier for the resource.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/cloudcontrolapi/latest/userguide/resource-identifier.html">Identifying resources</a> in the <i>Amazon Web Services Cloud Control API User Guide</i>.</p>', 'UpdateResourceInput$Identifier' => '<p>The identifier for the resource.</p> <p>You can specify the primary identifier, or any secondary identifier defined for the resource type in its resource schema. You can only specify one identifier. Primary identifiers can be specified as a string or JSON; secondary identifiers must be specified as JSON.</p> <p>For compound primary identifiers (that is, one that consists of multiple resource properties strung together), to specify the primary identifier as a string, list the property values <i>in the order they are specified</i> in the primary identifier definition, separated by <code>|</code>.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/cloudcontrolapi/latest/userguide/resource-identifier.html">Identifying resources</a> in the <i>Amazon Web Services Cloud Control API User Guide</i>.</p>', ], ], 'InvalidCredentialsException' => [ 'base' => '<p>The resource handler has returned that the credentials provided by the user are invalid.</p>', 'refs' => [], ], 'InvalidRequestException' => [ 'base' => '<p>The resource handler has returned that invalid input from the user has generated a generic exception.</p>', 'refs' => [], ], 'ListResourceRequestsInput' => [ 'base' => NULL, 'refs' => [], ], 'ListResourceRequestsOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListResourcesInput' => [ 'base' => NULL, 'refs' => [], ], 'ListResourcesOutput' => [ 'base' => NULL, 'refs' => [], ], 'MaxResults' => [ 'base' => NULL, 'refs' => [ 'ListResourceRequestsInput$MaxResults' => '<p>The maximum number of results to be returned with a single call. If the number of available results exceeds this maximum, the response includes a <code>NextToken</code> value that you can assign to the <code>NextToken</code> request parameter to get the next set of results.</p> <p>The default is <code>20</code>.</p>', 'ListResourcesInput$MaxResults' => '<p>Reserved.</p>', ], ], 'NetworkFailureException' => [ 'base' => '<p>The resource handler has returned that the request couldn\'t be completed due to networking issues, such as a failure to receive a response from the server.</p>', 'refs' => [], ], 'NextToken' => [ 'base' => NULL, 'refs' => [ 'ListResourceRequestsInput$NextToken' => '<p>If the previous paginated request didn\'t return all of the remaining results, the response object\'s <code>NextToken</code> parameter value is set to a token. To retrieve the next set of results, call this action again and assign that token to the request object\'s <code>NextToken</code> parameter. If there are no remaining results, the previous response object\'s <code>NextToken</code> parameter is set to <code>null</code>.</p>', 'ListResourceRequestsOutput$NextToken' => '<p>If the request doesn\'t return all of the remaining results, <code>NextToken</code> is set to a token. To retrieve the next set of results, call <code>ListResources</code> again and assign that token to the request object\'s <code>NextToken</code> parameter. If the request returns all results, <code>NextToken</code> is set to null.</p>', ], ], 'NotStabilizedException' => [ 'base' => '<p>The resource handler has returned that the downstream resource failed to complete all of its ready-state checks.</p>', 'refs' => [], ], 'NotUpdatableException' => [ 'base' => '<p>One or more properties included in this resource operation are defined as create-only, and therefore can\'t be updated.</p>', 'refs' => [], ], 'Operation' => [ 'base' => NULL, 'refs' => [ 'Operations$member' => NULL, 'ProgressEvent$Operation' => '<p>The resource operation type.</p>', ], ], 'OperationStatus' => [ 'base' => NULL, 'refs' => [ 'OperationStatuses$member' => NULL, 'ProgressEvent$OperationStatus' => '<p>The current status of the resource operation request.</p> <ul> <li> <p> <code>PENDING</code>: The resource operation hasn\'t yet started.</p> </li> <li> <p> <code>IN_PROGRESS</code>: The resource operation is currently in progress.</p> </li> <li> <p> <code>SUCCESS</code>: The resource operation has successfully completed.</p> </li> <li> <p> <code>FAILED</code>: The resource operation has failed. Refer to the error code and status message for more information.</p> </li> <li> <p> <code>CANCEL_IN_PROGRESS</code>: The resource operation is in the process of being canceled.</p> </li> <li> <p> <code>CANCEL_COMPLETE</code>: The resource operation has been canceled.</p> </li> </ul>', ], ], 'OperationStatuses' => [ 'base' => NULL, 'refs' => [ 'ResourceRequestStatusFilter$OperationStatuses' => '<p>The operation statuses to include in the filter.</p> <ul> <li> <p> <code>PENDING</code>: The operation has been requested, but not yet initiated.</p> </li> <li> <p> <code>IN_PROGRESS</code>: The operation is in progress.</p> </li> <li> <p> <code>SUCCESS</code>: The operation completed.</p> </li> <li> <p> <code>FAILED</code>: The operation failed.</p> </li> <li> <p> <code>CANCEL_IN_PROGRESS</code>: The operation is in the process of being canceled.</p> </li> <li> <p> <code>CANCEL_COMPLETE</code>: The operation has been canceled.</p> </li> </ul>', ], ], 'Operations' => [ 'base' => NULL, 'refs' => [ 'ResourceRequestStatusFilter$Operations' => '<p>The operation types to include in the filter.</p>', ], ], 'PatchDocument' => [ 'base' => NULL, 'refs' => [ 'UpdateResourceInput$PatchDocument' => '<p>A JavaScript Object Notation (JSON) document listing the patch operations that represent the updates to apply to the current resource properties. For details, see <a href="https://docs.aws.amazon.com/cloudcontrolapi/latest/userguide/resource-operations-update.html#resource-operations-update-patch">Composing the patch document</a> in the <i>Amazon Web Services Cloud Control API User Guide</i>.</p>', ], ], 'PrivateTypeException' => [ 'base' => '<p>Cloud Control API hasn\'t received a valid response from the resource handler, due to a configuration error. This includes issues such as the resource handler returning an invalid response, or timing out.</p>', 'refs' => [], ], 'ProgressEvent' => [ 'base' => '<p>Represents the current status of a resource operation request. For more information, see <a href="https://docs.aws.amazon.com/cloudcontrolapi/latest/userguide/resource-operations-manage-requests.html">Managing resource operation requests</a> in the <i>Amazon Web Services Cloud Control API User Guide</i>.</p>', 'refs' => [ 'CancelResourceRequestOutput$ProgressEvent' => NULL, 'CreateResourceOutput$ProgressEvent' => '<p>Represents the current status of the resource creation request.</p> <p>After you have initiated a resource creation request, you can monitor the progress of your request by calling <a href="https://docs.aws.amazon.com/cloudcontrolapi/latest/APIReference/API_GetResourceRequestStatus.html">GetResourceRequestStatus</a> using the <code>RequestToken</code> of the <code>ProgressEvent</code> returned by <code>CreateResource</code>.</p>', 'DeleteResourceOutput$ProgressEvent' => '<p>Represents the current status of the resource deletion request.</p> <p>After you have initiated a resource deletion request, you can monitor the progress of your request by calling <a href="https://docs.aws.amazon.com/cloudcontrolapi/latest/APIReference/API_GetResourceRequestStatus.html">GetResourceRequestStatus</a> using the <code>RequestToken</code> of the <code>ProgressEvent</code> returned by <code>DeleteResource</code>.</p>', 'GetResourceRequestStatusOutput$ProgressEvent' => '<p>Represents the current status of the resource operation request.</p>', 'ResourceRequestStatusSummaries$member' => NULL, 'UpdateResourceOutput$ProgressEvent' => '<p>Represents the current status of the resource update request.</p> <p>Use the <code>RequestToken</code> of the <code>ProgressEvent</code> with <a href="https://docs.aws.amazon.com/cloudcontrolapi/latest/APIReference/API_GetResourceRequestStatus.html">GetResourceRequestStatus</a> to return the current status of a resource operation request.</p>', ], ], 'Properties' => [ 'base' => NULL, 'refs' => [ 'CreateResourceInput$DesiredState' => '<p>Structured data format representing the desired state of the resource, consisting of that resource\'s properties and their desired values.</p> <note> <p>Cloud Control API currently supports JSON as a structured data format.</p> </note> <p>Specify the desired state as one of the following:</p> <ul> <li> <p>A JSON blob</p> </li> <li> <p>A local path containing the desired state in JSON data format</p> </li> </ul> <p>For more information, see <a href="https://docs.aws.amazon.com/cloudcontrolapi/latest/userguide/resource-operations-create.html#resource-operations-create-desiredstate">Composing the desired state of the resource</a> in the <i>Amazon Web Services Cloud Control API User Guide</i>.</p> <p>For more information about the properties of a specific resource, refer to the related topic for the resource in the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html">Resource and property types reference</a> in the <i>CloudFormation Users Guide</i>.</p>', 'ListResourcesInput$ResourceModel' => '<p>The resource model to use to select the resources to return.</p>', 'ProgressEvent$ResourceModel' => '<p>A JSON string containing the resource model, consisting of each resource property and its current value.</p>', 'ResourceDescription$Properties' => '<p>A list of the resource properties and their current values.</p>', ], ], 'RequestToken' => [ 'base' => NULL, 'refs' => [ 'CancelResourceRequestInput$RequestToken' => '<p>The <code>RequestToken</code> of the <code>ProgressEvent</code> object returned by the resource operation request.</p>', 'GetResourceRequestStatusInput$RequestToken' => '<p>A unique token used to track the progress of the resource operation request.</p> <p>Request tokens are included in the <code>ProgressEvent</code> type returned by a resource operation request.</p>', 'ProgressEvent$RequestToken' => '<p>The unique token representing this resource operation request.</p> <p>Use the <code>RequestToken</code> with <a href="https://docs.aws.amazon.com/cloudcontrolapi/latest/APIReference/API_GetResourceRequestStatus.html">GetResourceRequestStatus</a> to return the current status of a resource operation request.</p>', ], ], 'RequestTokenNotFoundException' => [ 'base' => '<p>A resource operation with the specified request token can\'t be found.</p>', 'refs' => [], ], 'ResourceConflictException' => [ 'base' => '<p>The resource is temporarily unavailable to be acted upon. For example, if the resource is currently undergoing an operation and can\'t be acted upon until that operation is finished.</p>', 'refs' => [], ], 'ResourceDescription' => [ 'base' => '<p>Represents information about a provisioned resource.</p>', 'refs' => [ 'GetResourceOutput$ResourceDescription' => NULL, 'ResourceDescriptions$member' => NULL, ], ], 'ResourceDescriptions' => [ 'base' => NULL, 'refs' => [ 'ListResourcesOutput$ResourceDescriptions' => '<p>Information about the specified resources, including primary identifier and resource model.</p>', ], ], 'ResourceNotFoundException' => [ 'base' => '<p>A resource with the specified identifier can\'t be found.</p>', 'refs' => [], ], 'ResourceRequestStatusFilter' => [ 'base' => '<p>The filter criteria to use in determining the requests returned.</p>', 'refs' => [ 'ListResourceRequestsInput$ResourceRequestStatusFilter' => '<p>The filter criteria to apply to the requests returned.</p>', ], ], 'ResourceRequestStatusSummaries' => [ 'base' => NULL, 'refs' => [ 'ListResourceRequestsOutput$ResourceRequestStatusSummaries' => '<p>The requests that match the specified filter criteria.</p>', ], ], 'RoleArn' => [ 'base' => NULL, 'refs' => [ 'CreateResourceInput$RoleArn' => '<p>The Amazon Resource Name (ARN) of the Identity and Access Management (IAM) role for Cloud Control API to use when performing this resource operation. The role specified must have the permissions required for this operation. The necessary permissions for each event handler are defined in the <code> <a href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/resource-type-schema.html#schema-properties-handlers">handlers</a> </code> section of the <a href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/resource-type-schema.html">resource type definition schema</a>.</p> <p>If you do not specify a role, Cloud Control API uses a temporary session created using your Amazon Web Services user credentials.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/cloudcontrolapi/latest/userguide/resource-operations.html#resource-operations-permissions">Specifying credentials</a> in the <i>Amazon Web Services Cloud Control API User Guide</i>.</p>', 'DeleteResourceInput$RoleArn' => '<p>The Amazon Resource Name (ARN) of the Identity and Access Management (IAM) role for Cloud Control API to use when performing this resource operation. The role specified must have the permissions required for this operation. The necessary permissions for each event handler are defined in the <code> <a href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/resource-type-schema.html#schema-properties-handlers">handlers</a> </code> section of the <a href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/resource-type-schema.html">resource type definition schema</a>.</p> <p>If you do not specify a role, Cloud Control API uses a temporary session created using your Amazon Web Services user credentials.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/cloudcontrolapi/latest/userguide/resource-operations.html#resource-operations-permissions">Specifying credentials</a> in the <i>Amazon Web Services Cloud Control API User Guide</i>.</p>', 'GetResourceInput$RoleArn' => '<p>The Amazon Resource Name (ARN) of the Identity and Access Management (IAM) role for Cloud Control API to use when performing this resource operation. The role specified must have the permissions required for this operation. The necessary permissions for each event handler are defined in the <code> <a href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/resource-type-schema.html#schema-properties-handlers">handlers</a> </code> section of the <a href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/resource-type-schema.html">resource type definition schema</a>.</p> <p>If you do not specify a role, Cloud Control API uses a temporary session created using your Amazon Web Services user credentials.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/cloudcontrolapi/latest/userguide/resource-operations.html#resource-operations-permissions">Specifying credentials</a> in the <i>Amazon Web Services Cloud Control API User Guide</i>.</p>', 'ListResourcesInput$RoleArn' => '<p>The Amazon Resource Name (ARN) of the Identity and Access Management (IAM) role for Cloud Control API to use when performing this resource operation. The role specified must have the permissions required for this operation. The necessary permissions for each event handler are defined in the <code> <a href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/resource-type-schema.html#schema-properties-handlers">handlers</a> </code> section of the <a href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/resource-type-schema.html">resource type definition schema</a>.</p> <p>If you do not specify a role, Cloud Control API uses a temporary session created using your Amazon Web Services user credentials.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/cloudcontrolapi/latest/userguide/resource-operations.html#resource-operations-permissions">Specifying credentials</a> in the <i>Amazon Web Services Cloud Control API User Guide</i>.</p>', 'UpdateResourceInput$RoleArn' => '<p>The Amazon Resource Name (ARN) of the Identity and Access Management (IAM) role for Cloud Control API to use when performing this resource operation. The role specified must have the permissions required for this operation. The necessary permissions for each event handler are defined in the <code> <a href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/resource-type-schema.html#schema-properties-handlers">handlers</a> </code> section of the <a href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/resource-type-schema.html">resource type definition schema</a>.</p> <p>If you do not specify a role, Cloud Control API uses a temporary session created using your Amazon Web Services user credentials.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/cloudcontrolapi/latest/userguide/resource-operations.html#resource-operations-permissions">Specifying credentials</a> in the <i>Amazon Web Services Cloud Control API User Guide</i>.</p>', ], ], 'ServiceInternalErrorException' => [ 'base' => '<p>The resource handler has returned that the downstream service returned an internal error, typically with a <code>5XX HTTP</code> status code.</p>', 'refs' => [], ], 'ServiceLimitExceededException' => [ 'base' => '<p>The resource handler has returned that a non-transient resource limit was reached on the service side.</p>', 'refs' => [], ], 'StatusMessage' => [ 'base' => NULL, 'refs' => [ 'ProgressEvent$StatusMessage' => '<p>Any message explaining the current status.</p>', ], ], 'ThrottlingException' => [ 'base' => '<p>The request was denied due to request throttling.</p>', 'refs' => [], ], 'Timestamp' => [ 'base' => NULL, 'refs' => [ 'ProgressEvent$EventTime' => '<p>When the resource operation request was initiated.</p>', 'ProgressEvent$RetryAfter' => '<p>When to next request the status of this resource operation request.</p>', ], ], 'TypeName' => [ 'base' => NULL, 'refs' => [ 'CreateResourceInput$TypeName' => '<p>The name of the resource type.</p>', 'DeleteResourceInput$TypeName' => '<p>The name of the resource type.</p>', 'GetResourceInput$TypeName' => '<p>The name of the resource type.</p>', 'GetResourceOutput$TypeName' => '<p>The name of the resource type.</p>', 'ListResourcesInput$TypeName' => '<p>The name of the resource type.</p>', 'ListResourcesOutput$TypeName' => '<p>The name of the resource type.</p>', 'ProgressEvent$TypeName' => '<p>The name of the resource type used in the operation.</p>', 'UpdateResourceInput$TypeName' => '<p>The name of the resource type.</p>', ], ], 'TypeNotFoundException' => [ 'base' => '<p>The specified extension doesn\'t exist in the CloudFormation registry.</p>', 'refs' => [], ], 'TypeVersionId' => [ 'base' => NULL, 'refs' => [ 'CreateResourceInput$TypeVersionId' => '<p>For private resource types, the type version to use in this resource operation. If you do not specify a resource version, CloudFormation uses the default version.</p>', 'DeleteResourceInput$TypeVersionId' => '<p>For private resource types, the type version to use in this resource operation. If you do not specify a resource version, CloudFormation uses the default version.</p>', 'GetResourceInput$TypeVersionId' => '<p>For private resource types, the type version to use in this resource operation. If you do not specify a resource version, CloudFormation uses the default version.</p>', 'ListResourcesInput$TypeVersionId' => '<p>For private resource types, the type version to use in this resource operation. If you do not specify a resource version, CloudFormation uses the default version.</p>', 'UpdateResourceInput$TypeVersionId' => '<p>For private resource types, the type version to use in this resource operation. If you do not specify a resource version, CloudFormation uses the default version.</p>', ], ], 'UnsupportedActionException' => [ 'base' => '<p>The specified resource doesn\'t support this resource operation.</p>', 'refs' => [], ], 'UpdateResourceInput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateResourceOutput' => [ 'base' => NULL, 'refs' => [], ], ],];
