<?php
// This file was auto-generated from sdk-root/src/data/transfer/2018-11-05/docs-2.json
return [ 'version' => '2.0', 'service' => '<p>Amazon Web Services Transfer Family is a fully managed service that enables the transfer of files over the File Transfer Protocol (FTP), File Transfer Protocol over SSL (FTPS), or Secure Shell (SSH) File Transfer Protocol (SFTP) directly into and out of Amazon Simple Storage Service (Amazon S3). Amazon Web Services helps you seamlessly migrate your file transfer workflows to Amazon Web Services Transfer Family by integrating with existing authentication systems, and providing DNS routing with Amazon Route 53 so nothing changes for your customers and partners, or their applications. With your data in Amazon S3, you can use it with Amazon Web Services services for processing, analytics, machine learning, and archiving. Getting started with Amazon Web Services Transfer Family is easy since there is no infrastructure to buy and set up.</p>', 'operations' => [ 'CreateAccess' => '<p>Used by administrators to choose which groups in the directory should have access to upload and download files over the enabled protocols using Amazon Web Services Transfer Family. For example, a Microsoft Active Directory might contain 50,000 users, but only a small fraction might need the ability to transfer files to the server. An administrator can use <code>CreateAccess</code> to limit the access to the correct set of users who need this ability.</p>', 'CreateServer' => '<p>Instantiates an auto-scaling virtual server based on the selected file transfer protocol in Amazon Web Services. When you make updates to your file transfer protocol-enabled server or when you work with users, use the service-generated <code>ServerId</code> property that is assigned to the newly created server.</p>', 'CreateUser' => '<p>Creates a user and associates them with an existing file transfer protocol-enabled server. You can only create and associate users with servers that have the <code>IdentityProviderType</code> set to <code>SERVICE_MANAGED</code>. Using parameters for <code>CreateUser</code>, you can specify the user name, set the home directory, store the user\'s public key, and assign the user\'s Amazon Web Services Identity and Access Management (IAM) role. You can also optionally add a session policy, and assign metadata with tags that can be used to group and search for users.</p>', 'CreateWorkflow' => '<p> Allows you to create a workflow with specified steps and step details the workflow invokes after file transfer completes. After creating a workflow, you can associate the workflow created with any transfer servers by specifying the <code>workflow-details</code> field in <code>CreateServer</code> and <code>UpdateServer</code> operations. </p>', 'DeleteAccess' => '<p>Allows you to delete the access specified in the <code>ServerID</code> and <code>ExternalID</code> parameters.</p>', 'DeleteServer' => '<p>Deletes the file transfer protocol-enabled server that you specify.</p> <p>No response returns from this operation.</p>', 'DeleteSshPublicKey' => '<p>Deletes a user\'s Secure Shell (SSH) public key.</p>', 'DeleteUser' => '<p>Deletes the user belonging to a file transfer protocol-enabled server you specify.</p> <p>No response returns from this operation.</p> <note> <p>When you delete a user from a server, the user\'s information is lost.</p> </note>', 'DeleteWorkflow' => '<p>Deletes the specified workflow.</p>', 'DescribeAccess' => '<p>Describes the access that is assigned to the specific file transfer protocol-enabled server, as identified by its <code>ServerId</code> property and its <code>ExternalID</code>.</p> <p>The response from this call returns the properties of the access that is associated with the <code>ServerId</code> value that was specified.</p>', 'DescribeExecution' => '<p>You can use <code>DescribeExecution</code> to check the details of the execution of the specified workflow.</p>', 'DescribeSecurityPolicy' => '<p>Describes the security policy that is attached to your file transfer protocol-enabled server. The response contains a description of the security policy\'s properties. For more information about security policies, see <a href="https://docs.aws.amazon.com/transfer/latest/userguide/security-policies.html">Working with security policies</a>.</p>', 'DescribeServer' => '<p>Describes a file transfer protocol-enabled server that you specify by passing the <code>ServerId</code> parameter.</p> <p>The response contains a description of a server\'s properties. When you set <code>EndpointType</code> to VPC, the response will contain the <code>EndpointDetails</code>.</p>', 'DescribeUser' => '<p>Describes the user assigned to the specific file transfer protocol-enabled server, as identified by its <code>ServerId</code> property.</p> <p>The response from this call returns the properties of the user associated with the <code>ServerId</code> value that was specified.</p>', 'DescribeWorkflow' => '<p>Describes the specified workflow.</p>', 'ImportSshPublicKey' => '<p>Adds a Secure Shell (SSH) public key to a user account identified by a <code>UserName</code> value assigned to the specific file transfer protocol-enabled server, identified by <code>ServerId</code>.</p> <p>The response returns the <code>UserName</code> value, the <code>ServerId</code> value, and the name of the <code>SshPublicKeyId</code>.</p>', 'ListAccesses' => '<p>Lists the details for all the accesses you have on your server.</p>', 'ListExecutions' => '<p>Lists all executions for the specified workflow.</p>', 'ListSecurityPolicies' => '<p>Lists the security policies that are attached to your file transfer protocol-enabled servers.</p>', 'ListServers' => '<p>Lists the file transfer protocol-enabled servers that are associated with your Amazon Web Services account.</p>', 'ListTagsForResource' => '<p>Lists all of the tags associated with the Amazon Resource Name (ARN) that you specify. The resource can be a user, server, or role.</p>', 'ListUsers' => '<p>Lists the users for a file transfer protocol-enabled server that you specify by passing the <code>ServerId</code> parameter.</p>', 'ListWorkflows' => '<p>Lists all of your workflows.</p>', 'SendWorkflowStepState' => '<p>Sends a callback for asynchronous custom steps.</p> <p> The <code>ExecutionId</code>, <code>WorkflowId</code>, and <code>Token</code> are passed to the target resource during execution of a custom step of a workflow. You must include those with their callback as well as providing a status. </p>', 'StartServer' => '<p>Changes the state of a file transfer protocol-enabled server from <code>OFFLINE</code> to <code>ONLINE</code>. It has no impact on a server that is already <code>ONLINE</code>. An <code>ONLINE</code> server can accept and process file transfer jobs.</p> <p>The state of <code>STARTING</code> indicates that the server is in an intermediate state, either not fully able to respond, or not fully online. The values of <code>START_FAILED</code> can indicate an error condition.</p> <p>No response is returned from this call.</p>', 'StopServer' => '<p>Changes the state of a file transfer protocol-enabled server from <code>ONLINE</code> to <code>OFFLINE</code>. An <code>OFFLINE</code> server cannot accept and process file transfer jobs. Information tied to your server, such as server and user properties, are not affected by stopping your server.</p> <note> <p>Stopping the server will not reduce or impact your file transfer protocol endpoint billing; you must delete the server to stop being billed.</p> </note> <p>The state of <code>STOPPING</code> indicates that the server is in an intermediate state, either not fully able to respond, or not fully offline. The values of <code>STOP_FAILED</code> can indicate an error condition.</p> <p>No response is returned from this call.</p>', 'TagResource' => '<p>Attaches a key-value pair to a resource, as identified by its Amazon Resource Name (ARN). Resources are users, servers, roles, and other entities.</p> <p>There is no response returned from this call.</p>', 'TestIdentityProvider' => '<p>If the <code>IdentityProviderType</code> of a file transfer protocol-enabled server is <code>AWS_DIRECTORY_SERVICE</code> or <code>API_Gateway</code>, tests whether your identity provider is set up successfully. We highly recommend that you call this operation to test your authentication method as soon as you create your server. By doing so, you can troubleshoot issues with the identity provider integration to ensure that your users can successfully use the service.</p> <p> The <code>ServerId</code> and <code>UserName</code> parameters are required. The <code>ServerProtocol</code>, <code>SourceIp</code>, and <code>UserPassword</code> are all optional. </p> <note> <p> You cannot use <code>TestIdentityProvider</code> if the <code>IdentityProviderType</code> of your server is <code>SERVICE_MANAGED</code>. </p> </note> <ul> <li> <p> If you provide any incorrect values for any parameters, the <code>Response</code> field is empty. </p> </li> <li> <p> If you provide a server ID for a server that uses service-managed users, you get an error: </p> <p> <code> An error occurred (InvalidRequestException) when calling the TestIdentityProvider operation: s-<i>server-ID</i> not configured for external auth </code> </p> </li> <li> <p> If you enter a Server ID for the <code>--server-id</code> parameter that does not identify an actual Transfer server, you receive the following error: </p> <p> <code>An error occurred (ResourceNotFoundException) when calling the TestIdentityProvider operation: Unknown server</code> </p> </li> </ul>', 'UntagResource' => '<p>Detaches a key-value pair from a resource, as identified by its Amazon Resource Name (ARN). Resources are users, servers, roles, and other entities.</p> <p>No response is returned from this call.</p>', 'UpdateAccess' => '<p>Allows you to update parameters for the access specified in the <code>ServerID</code> and <code>ExternalID</code> parameters.</p>', 'UpdateServer' => '<p>Updates the file transfer protocol-enabled server\'s properties after that server has been created.</p> <p>The <code>UpdateServer</code> call returns the <code>ServerId</code> of the server you updated.</p>', 'UpdateUser' => '<p>Assigns new properties to a user. Parameters you pass modify any or all of the following: the home directory, role, and policy for the <code>UserName</code> and <code>ServerId</code> you specify.</p> <p>The response returns the <code>ServerId</code> and the <code>UserName</code> for the updated user.</p>', ], 'shapes' => [ 'AccessDeniedException' => [ 'base' => '<p>You do not have sufficient access to perform this action.</p>', 'refs' => [], ], 'AddressAllocationId' => [ 'base' => NULL, 'refs' => [ 'AddressAllocationIds$member' => NULL, ], ], 'AddressAllocationIds' => [ 'base' => NULL, 'refs' => [ 'EndpointDetails$AddressAllocationIds' => '<p>A list of address allocation IDs that are required to attach an Elastic IP address to your server\'s endpoint.</p> <note> <p>This property can only be set when <code>EndpointType</code> is set to <code>VPC</code> and it is only valid in the <code>UpdateServer</code> API.</p> </note>', ], ], 'Arn' => [ 'base' => NULL, 'refs' => [ 'DescribedServer$Arn' => '<p>Specifies the unique Amazon Resource Name (ARN) of the server.</p>', 'DescribedUser$Arn' => '<p>Specifies the unique Amazon Resource Name (ARN) for the user that was requested to be described.</p>', 'DescribedWorkflow$Arn' => '<p>Specifies the unique Amazon Resource Name (ARN) for the workflow.</p>', 'ListTagsForResourceRequest$Arn' => '<p>Requests the tags associated with a particular Amazon Resource Name (ARN). An ARN is an identifier for a specific Amazon Web Services resource, such as a server, user, or role.</p>', 'ListTagsForResourceResponse$Arn' => '<p>The ARN you specified to list the tags of.</p>', 'ListedServer$Arn' => '<p>Specifies the unique Amazon Resource Name (ARN) for a server to be listed.</p>', 'ListedUser$Arn' => '<p>Provides the unique Amazon Resource Name (ARN) for the user that you want to learn about.</p>', 'ListedWorkflow$Arn' => '<p>Specifies the unique Amazon Resource Name (ARN) for the workflow.</p>', 'TagResourceRequest$Arn' => '<p>An Amazon Resource Name (ARN) for a specific Amazon Web Services resource, such as a server, user, or role.</p>', 'UntagResourceRequest$Arn' => '<p>The value of the resource that will have the tag removed. An Amazon Resource Name (ARN) is an identifier for a specific Amazon Web Services resource, such as a server, user, or role.</p>', ], ], 'CallbackToken' => [ 'base' => NULL, 'refs' => [ 'SendWorkflowStepStateRequest$Token' => '<p>Used to distinguish between multiple callbacks for multiple Lambda steps within the same execution.</p>', ], ], 'Certificate' => [ 'base' => NULL, 'refs' => [ 'CreateServerRequest$Certificate' => '<p>The Amazon Resource Name (ARN) of the Amazon Web Services Certificate Manager (ACM) certificate. Required when <code>Protocols</code> is set to <code>FTPS</code>.</p> <p>To request a new public certificate, see <a href="https://docs.aws.amazon.com/acm/latest/userguide/gs-acm-request-public.html">Request a public certificate</a> in the <i> Amazon Web Services Certificate Manager User Guide</i>.</p> <p>To import an existing certificate into ACM, see <a href="https://docs.aws.amazon.com/acm/latest/userguide/import-certificate.html">Importing certificates into ACM</a> in the <i> Amazon Web Services Certificate Manager User Guide</i>.</p> <p>To request a private certificate to use FTPS through private IP addresses, see <a href="https://docs.aws.amazon.com/acm/latest/userguide/gs-acm-request-private.html">Request a private certificate</a> in the <i> Amazon Web Services Certificate Manager User Guide</i>.</p> <p>Certificates with the following cryptographic algorithms and key sizes are supported:</p> <ul> <li> <p>2048-bit RSA (RSA_2048)</p> </li> <li> <p>4096-bit RSA (RSA_4096)</p> </li> <li> <p>Elliptic Prime Curve 256 bit (EC_prime256v1)</p> </li> <li> <p>Elliptic Prime Curve 384 bit (EC_secp384r1)</p> </li> <li> <p>Elliptic Prime Curve 521 bit (EC_secp521r1)</p> </li> </ul> <note> <p>The certificate must be a valid SSL/TLS X.509 version 3 certificate with FQDN or IP address specified and information about the issuer.</p> </note>', 'DescribedServer$Certificate' => '<p>Specifies the ARN of the Amazon Web ServicesCertificate Manager (ACM) certificate. Required when <code>Protocols</code> is set to <code>FTPS</code>.</p>', 'UpdateServerRequest$Certificate' => '<p>The Amazon Resource Name (ARN) of the Amazon Web ServicesCertificate Manager (ACM) certificate. Required when <code>Protocols</code> is set to <code>FTPS</code>.</p> <p>To request a new public certificate, see <a href="https://docs.aws.amazon.com/acm/latest/userguide/gs-acm-request-public.html">Request a public certificate</a> in the <i> Amazon Web ServicesCertificate Manager User Guide</i>.</p> <p>To import an existing certificate into ACM, see <a href="https://docs.aws.amazon.com/acm/latest/userguide/import-certificate.html">Importing certificates into ACM</a> in the <i> Amazon Web ServicesCertificate Manager User Guide</i>.</p> <p>To request a private certificate to use FTPS through private IP addresses, see <a href="https://docs.aws.amazon.com/acm/latest/userguide/gs-acm-request-private.html">Request a private certificate</a> in the <i> Amazon Web ServicesCertificate Manager User Guide</i>.</p> <p>Certificates with the following cryptographic algorithms and key sizes are supported:</p> <ul> <li> <p>2048-bit RSA (RSA_2048)</p> </li> <li> <p>4096-bit RSA (RSA_4096)</p> </li> <li> <p>Elliptic Prime Curve 256 bit (EC_prime256v1)</p> </li> <li> <p>Elliptic Prime Curve 384 bit (EC_secp384r1)</p> </li> <li> <p>Elliptic Prime Curve 521 bit (EC_secp521r1)</p> </li> </ul> <note> <p>The certificate must be a valid SSL/TLS X.509 version 3 certificate with FQDN or IP address specified and information about the issuer.</p> </note>', ], ], 'ConflictException' => [ 'base' => '<p>This exception is thrown when the <code>UpdateServer</code> is called for a file transfer protocol-enabled server that has VPC as the endpoint type and the server\'s <code>VpcEndpointID</code> is not in the available state.</p>', 'refs' => [], ], 'CopyStepDetails' => [ 'base' => '<p>Each step type has its own <code>StepDetails</code> structure.</p>', 'refs' => [ 'WorkflowStep$CopyStepDetails' => '<p>Details for a step that performs a file copy.</p> <p> Consists of the following values: </p> <ul> <li> <p>A description</p> </li> <li> <p>An S3 location for the destination of the file copy.</p> </li> <li> <p>A flag that indicates whether or not to overwrite an existing file of the same name. The default is <code>FALSE</code>.</p> </li> </ul>', ], ], 'CreateAccessRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateAccessResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateServerRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateServerResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateUserRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateUserResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateWorkflowRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateWorkflowResponse' => [ 'base' => NULL, 'refs' => [], ], 'CustomStepDetails' => [ 'base' => '<p>Each step type has its own <code>StepDetails</code> structure.</p>', 'refs' => [ 'WorkflowStep$CustomStepDetails' => '<p>Details for a step that invokes a lambda function.</p> <p> Consists of the lambda function name, target, and timeout (in seconds). </p>', ], ], 'CustomStepStatus' => [ 'base' => NULL, 'refs' => [ 'SendWorkflowStepStateRequest$Status' => '<p>Indicates whether the specified step succeeded or failed.</p>', ], ], 'CustomStepTarget' => [ 'base' => NULL, 'refs' => [ 'CustomStepDetails$Target' => '<p>The ARN for the lambda function that is being called.</p>', ], ], 'CustomStepTimeoutSeconds' => [ 'base' => NULL, 'refs' => [ 'CustomStepDetails$TimeoutSeconds' => '<p>Timeout, in seconds, for the step.</p>', ], ], 'DateImported' => [ 'base' => NULL, 'refs' => [ 'SshPublicKey$DateImported' => '<p>Specifies the date that the public key was added to the user account.</p>', ], ], 'DeleteAccessRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteServerRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteSshPublicKeyRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteStepDetails' => [ 'base' => '<p>The name of the step, used to identify the delete step.</p>', 'refs' => [ 'WorkflowStep$DeleteStepDetails' => '<p>Details for a step that deletes the file.</p>', ], ], 'DeleteUserRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteWorkflowRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAccessRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAccessResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeExecutionRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeExecutionResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeSecurityPolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeSecurityPolicyResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeServerRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeServerResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeUserRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeUserResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeWorkflowRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeWorkflowResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribedAccess' => [ 'base' => '<p>Describes the properties of the access that was specified.</p>', 'refs' => [ 'DescribeAccessResponse$Access' => '<p>The external ID of the server that the access is attached to.</p>', ], ], 'DescribedExecution' => [ 'base' => '<p>The details for an execution object.</p>', 'refs' => [ 'DescribeExecutionResponse$Execution' => '<p>The structure that contains the details of the workflow\' execution.</p>', ], ], 'DescribedSecurityPolicy' => [ 'base' => '<p>Describes the properties of a security policy that was specified. For more information about security policies, see <a href="https://docs.aws.amazon.com/transfer/latest/userguide/security-policies.html">Working with security policies</a>.</p>', 'refs' => [ 'DescribeSecurityPolicyResponse$SecurityPolicy' => '<p>An array containing the properties of the security policy.</p>', ], ], 'DescribedServer' => [ 'base' => '<p>Describes the properties of a file transfer protocol-enabled server that was specified.</p>', 'refs' => [ 'DescribeServerResponse$Server' => '<p>An array containing the properties of a server with the <code>ServerID</code> you specified.</p>', ], ], 'DescribedUser' => [ 'base' => '<p>Describes the properties of a user that was specified.</p>', 'refs' => [ 'DescribeUserResponse$User' => '<p>An array containing the properties of the user account for the <code>ServerID</code> value that you specified.</p>', ], ], 'DescribedWorkflow' => [ 'base' => '<p>Describes the properties of the specified workflow</p>', 'refs' => [ 'DescribeWorkflowResponse$Workflow' => '<p>The structure that contains the details of the workflow.</p>', ], ], 'DirectoryId' => [ 'base' => NULL, 'refs' => [ 'IdentityProviderDetails$DirectoryId' => '<p>The identifier of the Amazon Web ServicesDirectory Service directory that you want to stop sharing.</p>', ], ], 'Domain' => [ 'base' => NULL, 'refs' => [ 'CreateServerRequest$Domain' => '<p>The domain of the storage system that is used for file transfers. There are two domains available: Amazon Simple Storage Service (Amazon S3) and Amazon Elastic File System (Amazon EFS). The default value is S3.</p> <note> <p>After the server is created, the domain cannot be changed.</p> </note>', 'DescribedServer$Domain' => '<p>Specifies the domain of the storage system that is used for file transfers.</p>', 'ListedServer$Domain' => '<p>Specifies the domain of the storage system that is used for file transfers.</p>', ], ], 'EfsFileLocation' => [ 'base' => '<p>Reserved for future use.</p> <p> </p>', 'refs' => [ 'FileLocation$EfsFileLocation' => '<p>Specifies the Amazon EFS ID and the path for the file being used.</p>', 'InputFileLocation$EfsFileLocation' => '<p>Reserved for future use.</p>', ], ], 'EfsFileSystemId' => [ 'base' => NULL, 'refs' => [ 'EfsFileLocation$FileSystemId' => '<p>The ID of the file system, assigned by Amazon EFS.</p>', ], ], 'EfsPath' => [ 'base' => NULL, 'refs' => [ 'EfsFileLocation$Path' => '<p>The pathname for the folder being used by a workflow.</p>', ], ], 'EndpointDetails' => [ 'base' => '<p>The virtual private cloud (VPC) endpoint settings that are configured for your file transfer protocol-enabled server. With a VPC endpoint, you can restrict access to your server and resources only within your VPC. To control incoming internet traffic, invoke the <code>UpdateServer</code> API and attach an Elastic IP address to your server\'s endpoint.</p> <note> <p> After May 19, 2021, you won\'t be able to create a server using <code>EndpointType=VPC_ENDPOINT</code> in your Amazon Web Servicesaccount if your account hasn\'t already done so before May 19, 2021. If you have already created servers with <code>EndpointType=VPC_ENDPOINT</code> in your Amazon Web Servicesaccount on or before May 19, 2021, you will not be affected. After this date, use <code>EndpointType</code>=<code>VPC</code>.</p> <p>For more information, see https://docs.aws.amazon.com/transfer/latest/userguide/create-server-in-vpc.html#deprecate-vpc-endpoint.</p> </note>', 'refs' => [ 'CreateServerRequest$EndpointDetails' => '<p>The virtual private cloud (VPC) endpoint settings that are configured for your server. When you host your endpoint within your VPC, you can make it accessible only to resources within your VPC, or you can attach Elastic IP addresses and make it accessible to clients over the internet. Your VPC\'s default security groups are automatically assigned to your endpoint.</p>', 'DescribedServer$EndpointDetails' => '<p>The virtual private cloud (VPC) endpoint settings that are configured for your server. When you host your endpoint within your VPC, you can make it accessible only to resources within your VPC, or you can attach Elastic IP addresses and make it accessible to clients over the internet. Your VPC\'s default security groups are automatically assigned to your endpoint.</p>', 'UpdateServerRequest$EndpointDetails' => '<p>The virtual private cloud (VPC) endpoint settings that are configured for your server. When you host your endpoint within your VPC, you can make it accessible only to resources within your VPC, or you can attach Elastic IP addresses and make it accessible to clients over the internet. Your VPC\'s default security groups are automatically assigned to your endpoint.</p>', ], ], 'EndpointType' => [ 'base' => NULL, 'refs' => [ 'CreateServerRequest$EndpointType' => '<p>The type of endpoint that you want your server to use. You can choose to make your server\'s endpoint publicly accessible (PUBLIC) or host it inside your VPC. With an endpoint that is hosted in a VPC, you can restrict access to your server and resources only within your VPC or choose to make it internet facing by attaching Elastic IP addresses directly to it.</p> <note> <p> After May 19, 2021, you won\'t be able to create a server using <code>EndpointType=VPC_ENDPOINT</code> in your Amazon Web Services account if your account hasn\'t already done so before May 19, 2021. If you have already created servers with <code>EndpointType=VPC_ENDPOINT</code> in your Amazon Web Services account on or before May 19, 2021, you will not be affected. After this date, use <code>EndpointType</code>=<code>VPC</code>.</p> <p>For more information, see https://docs.aws.amazon.com/transfer/latest/userguide/create-server-in-vpc.html#deprecate-vpc-endpoint.</p> <p>It is recommended that you use <code>VPC</code> as the <code>EndpointType</code>. With this endpoint type, you have the option to directly associate up to three Elastic IPv4 addresses (BYO IP included) with your server\'s endpoint and use VPC security groups to restrict traffic by the client\'s public IP address. This is not possible with <code>EndpointType</code> set to <code>VPC_ENDPOINT</code>.</p> </note>', 'DescribedServer$EndpointType' => '<p>Defines the type of endpoint that your server is connected to. If your server is connected to a VPC endpoint, your server isn\'t accessible over the public internet.</p>', 'ListedServer$EndpointType' => '<p>Specifies the type of VPC endpoint that your server is connected to. If your server is connected to a VPC endpoint, your server isn\'t accessible over the public internet.</p>', 'UpdateServerRequest$EndpointType' => '<p>The type of endpoint that you want your server to use. You can choose to make your server\'s endpoint publicly accessible (PUBLIC) or host it inside your VPC. With an endpoint that is hosted in a VPC, you can restrict access to your server and resources only within your VPC or choose to make it internet facing by attaching Elastic IP addresses directly to it.</p> <note> <p> After May 19, 2021, you won\'t be able to create a server using <code>EndpointType=VPC_ENDPOINT</code> in your Amazon Web Servicesaccount if your account hasn\'t already done so before May 19, 2021. If you have already created servers with <code>EndpointType=VPC_ENDPOINT</code> in your Amazon Web Servicesaccount on or before May 19, 2021, you will not be affected. After this date, use <code>EndpointType</code>=<code>VPC</code>.</p> <p>For more information, see https://docs.aws.amazon.com/transfer/latest/userguide/create-server-in-vpc.html#deprecate-vpc-endpoint.</p> <p>It is recommended that you use <code>VPC</code> as the <code>EndpointType</code>. With this endpoint type, you have the option to directly associate up to three Elastic IPv4 addresses (BYO IP included) with your server\'s endpoint and use VPC security groups to restrict traffic by the client\'s public IP address. This is not possible with <code>EndpointType</code> set to <code>VPC_ENDPOINT</code>.</p> </note>', ], ], 'ExecutionError' => [ 'base' => '<p>Specifies the error message and type, for an error that occurs during the execution of the workflow.</p>', 'refs' => [ 'ExecutionStepResult$Error' => '<p>Specifies the details for an error, if it occurred during execution of the specified workfow step.</p>', ], ], 'ExecutionErrorMessage' => [ 'base' => NULL, 'refs' => [ 'ExecutionError$Message' => '<p>Specifies the descriptive message that corresponds to the <code>ErrorType</code>.</p>', ], ], 'ExecutionErrorType' => [ 'base' => NULL, 'refs' => [ 'ExecutionError$Type' => '<p>Specifies the error type: currently, the only valid value is <code>PERMISSION_DENIED</code>, which occurs if your policy does not contain the correct permissions to complete one or more of the steps in the workflow.</p>', ], ], 'ExecutionId' => [ 'base' => NULL, 'refs' => [ 'DescribeExecutionRequest$ExecutionId' => '<p>A unique identifier for the execution of a workflow.</p>', 'DescribedExecution$ExecutionId' => '<p>A unique identifier for the execution of a workflow.</p>', 'ListedExecution$ExecutionId' => '<p>A unique identifier for the execution of a workflow.</p>', 'SendWorkflowStepStateRequest$ExecutionId' => '<p>A unique identifier for the execution of a workflow.</p>', ], ], 'ExecutionResults' => [ 'base' => '<p>Specifies the steps in the workflow, as well as the steps to execute in case of any errors during workflow execution.</p>', 'refs' => [ 'DescribedExecution$Results' => '<p>A structure that describes the execution results. This includes a list of the steps along with the details of each step, error type and message (if any), and the <code>OnExceptionSteps</code> structure.</p>', ], ], 'ExecutionStatus' => [ 'base' => NULL, 'refs' => [ 'DescribedExecution$Status' => '<p>The status is one of the execution. Can be in progress, completed, exception encountered, or handling the exception. </p>', 'ListedExecution$Status' => '<p>The status is one of the execution. Can be in progress, completed, exception encountered, or handling the exception.</p>', ], ], 'ExecutionStepResult' => [ 'base' => '<p>Specifies the following details for the step: error (if any), outputs (if any), and the step type.</p>', 'refs' => [ 'ExecutionStepResults$member' => NULL, ], ], 'ExecutionStepResults' => [ 'base' => NULL, 'refs' => [ 'ExecutionResults$Steps' => '<p>Specifies the details for the steps that are in the specified workflow.</p>', 'ExecutionResults$OnExceptionSteps' => '<p>Specifies the steps (actions) to take if errors are encountered during execution of the workflow.</p>', ], ], 'ExternalId' => [ 'base' => NULL, 'refs' => [ 'CreateAccessRequest$ExternalId' => '<p>A unique identifier that is required to identify specific groups within your directory. The users of the group that you associate have access to your Amazon S3 or Amazon EFS resources over the enabled protocols using Amazon Web Services Transfer Family. If you know the group name, you can view the SID values by running the following command using Windows PowerShell.</p> <p> <code>Get-ADGroup -Filter {samAccountName -like "<i>YourGroupName</i>*"} -Properties * | Select SamAccountName,ObjectSid</code> </p> <p>In that command, replace <i>YourGroupName</i> with the name of your Active Directory group.</p> <p>The regex used to validate this parameter is a string of characters consisting of uppercase and lowercase alphanumeric characters with no spaces. You can also include underscores or any of the following characters: =,.@:/-</p>', 'CreateAccessResponse$ExternalId' => '<p>The external ID of the group whose users have access to your Amazon S3 or Amazon EFS resources over the enabled protocols using Amazon Web Services Transfer Family.</p>', 'DeleteAccessRequest$ExternalId' => '<p>A unique identifier that is required to identify specific groups within your directory. The users of the group that you associate have access to your Amazon S3 or Amazon EFS resources over the enabled protocols using Amazon Web Services Transfer Family. If you know the group name, you can view the SID values by running the following command using Windows PowerShell.</p> <p> <code>Get-ADGroup -Filter {samAccountName -like "<i>YourGroupName</i>*"} -Properties * | Select SamAccountName,ObjectSid</code> </p> <p>In that command, replace <i>YourGroupName</i> with the name of your Active Directory group.</p> <p>The regex used to validate this parameter is a string of characters consisting of uppercase and lowercase alphanumeric characters with no spaces. You can also include underscores or any of the following characters: =,.@:/-</p>', 'DescribeAccessRequest$ExternalId' => '<p>A unique identifier that is required to identify specific groups within your directory. The users of the group that you associate have access to your Amazon S3 or Amazon EFS resources over the enabled protocols using Amazon Web Services Transfer Family. If you know the group name, you can view the SID values by running the following command using Windows PowerShell.</p> <p> <code>Get-ADGroup -Filter {samAccountName -like "<i>YourGroupName</i>*"} -Properties * | Select SamAccountName,ObjectSid</code> </p> <p>In that command, replace <i>YourGroupName</i> with the name of your Active Directory group.</p> <p>The regex used to validate this parameter is a string of characters consisting of uppercase and lowercase alphanumeric characters with no spaces. You can also include underscores or any of the following characters: =,.@:/-</p>', 'DescribedAccess$ExternalId' => '<p>A unique identifier that is required to identify specific groups within your directory. The users of the group that you associate have access to your Amazon S3 or Amazon EFS resources over the enabled protocols using Amazon Web Services Transfer Family. If you know the group name, you can view the SID values by running the following command using Windows PowerShell.</p> <p> <code>Get-ADGroup -Filter {samAccountName -like "<i>YourGroupName</i>*"} -Properties * | Select SamAccountName,ObjectSid</code> </p> <p>In that command, replace <i>YourGroupName</i> with the name of your Active Directory group.</p> <p>The regex used to validate this parameter is a string of characters consisting of uppercase and lowercase alphanumeric characters with no spaces. You can also include underscores or any of the following characters: =,.@:/-</p>', 'ListedAccess$ExternalId' => '<p>A unique identifier that is required to identify specific groups within your directory. The users of the group that you associate have access to your Amazon S3 or Amazon EFS resources over the enabled protocols using Amazon Web Services Transfer Family. If you know the group name, you can view the SID values by running the following command using Windows PowerShell.</p> <p> <code>Get-ADGroup -Filter {samAccountName -like "<i>YourGroupName</i>*"} -Properties * | Select SamAccountName,ObjectSid</code> </p> <p>In that command, replace <i>YourGroupName</i> with the name of your Active Directory group.</p> <p>The regex used to validate this parameter is a string of characters consisting of uppercase and lowercase alphanumeric characters with no spaces. You can also include underscores or any of the following characters: =,.@:/-</p>', 'UpdateAccessRequest$ExternalId' => '<p>A unique identifier that is required to identify specific groups within your directory. The users of the group that you associate have access to your Amazon S3 or Amazon EFS resources over the enabled protocols using Amazon Web Services Transfer Family. If you know the group name, you can view the SID values by running the following command using Windows PowerShell.</p> <p> <code>Get-ADGroup -Filter {samAccountName -like "<i>YourGroupName</i>*"} -Properties * | Select SamAccountName,ObjectSid</code> </p> <p>In that command, replace <i>YourGroupName</i> with the name of your Active Directory group.</p> <p>The regex used to validate this parameter is a string of characters consisting of uppercase and lowercase alphanumeric characters with no spaces. You can also include underscores or any of the following characters: =,.@:/-</p>', 'UpdateAccessResponse$ExternalId' => '<p>The external ID of the group whose users have access to your Amazon S3 or Amazon EFS resources over the enabled protocols using Amazon Web ServicesTransfer Family.</p>', ], ], 'FileLocation' => [ 'base' => '<p>Specifies the Amazon S3 or EFS file details to be used in the step.</p>', 'refs' => [ 'DescribedExecution$InitialFileLocation' => '<p>A structure that describes the Amazon S3 or EFS file location. This is the file location when the execution begins: if the file is being copied, this is the initial (as opposed to destination) file location.</p>', 'ListedExecution$InitialFileLocation' => '<p>A structure that describes the Amazon S3 or EFS file location. This is the file location when the execution begins: if the file is being copied, this is the initial (as opposed to destination) file location.</p>', ], ], 'Fips' => [ 'base' => NULL, 'refs' => [ 'DescribedSecurityPolicy$Fips' => '<p>Specifies whether this policy enables Federal Information Processing Standards (FIPS).</p>', ], ], 'Function' => [ 'base' => NULL, 'refs' => [ 'IdentityProviderDetails$Function' => '<p>The ARN for a lambda function to use for the Identity provider.</p>', ], ], 'HomeDirectory' => [ 'base' => NULL, 'refs' => [ 'CreateAccessRequest$HomeDirectory' => '<p>The landing directory (folder) for a user when they log in to the server using the client.</p> <p>A <code>HomeDirectory</code> example is <code>/bucket_name/home/mydirectory</code>.</p>', 'CreateUserRequest$HomeDirectory' => '<p>The landing directory (folder) for a user when they log in to the server using the client.</p> <p>A <code>HomeDirectory</code> example is <code>/bucket_name/home/mydirectory</code>.</p>', 'DescribedAccess$HomeDirectory' => '<p>The landing directory (folder) for a user when they log in to the server using the client.</p> <p>A <code>HomeDirectory</code> example is <code>/bucket_name/home/mydirectory</code>.</p>', 'DescribedUser$HomeDirectory' => '<p>The landing directory (folder) for a user when they log in to the server using the client.</p> <p>A <code>HomeDirectory</code> example is <code>/bucket_name/home/mydirectory</code>.</p>', 'ListedAccess$HomeDirectory' => '<p>The landing directory (folder) for a user when they log in to the server using the client.</p> <p>A <code>HomeDirectory</code> example is <code>/bucket_name/home/mydirectory</code>.</p>', 'ListedUser$HomeDirectory' => '<p>The landing directory (folder) for a user when they log in to the server using the client.</p> <p>A <code>HomeDirectory</code> example is <code>/bucket_name/home/mydirectory</code>.</p>', 'UpdateAccessRequest$HomeDirectory' => '<p>The landing directory (folder) for a user when they log in to the server using the client.</p> <p>A <code>HomeDirectory</code> example is <code>/bucket_name/home/mydirectory</code>.</p>', 'UpdateUserRequest$HomeDirectory' => '<p>The landing directory (folder) for a user when they log in to the server using the client.</p> <p>A <code>HomeDirectory</code> example is <code>/bucket_name/home/mydirectory</code>.</p>', ], ], 'HomeDirectoryMapEntry' => [ 'base' => '<p>Represents an object that contains entries and targets for <code>HomeDirectoryMappings</code>.</p> <p>The following is an <code>Entry</code> and <code>Target</code> pair example for <code>chroot</code>.</p> <p> <code>[ { "Entry:": "/", "Target": "/bucket_name/home/mydirectory" } ]</code> </p> <note> <p>If the target of a logical directory entry does not exist in Amazon S3 or EFS, the entry is ignored. As a workaround, you can use the Amazon S3 API or EFS API to create 0 byte objects as place holders for your directory. If using the CLI, use the <code>s3api</code> or <code>efsapi</code> call instead of <code>s3</code> or <code>efs</code> so you can use the put-object operation. For example, you use the following: <code>aws s3api put-object --bucket bucketname --key path/to/folder/</code>. Make sure that the end of the key name ends in a <code>/</code> for it to be considered a folder.</p> </note>', 'refs' => [ 'HomeDirectoryMappings$member' => NULL, ], ], 'HomeDirectoryMappings' => [ 'base' => NULL, 'refs' => [ 'CreateAccessRequest$HomeDirectoryMappings' => '<p>Logical directory mappings that specify what Amazon S3 or Amazon EFS paths and keys should be visible to your user and how you want to make them visible. You must specify the <code>Entry</code> and <code>Target</code> pair, where <code>Entry</code> shows how the path is made visible and <code>Target</code> is the actual Amazon S3 or Amazon EFS path. If you only specify a target, it is displayed as is. You also must ensure that your Amazon Web Services Identity and Access Management (IAM) role provides access to paths in <code>Target</code>. This value can only be set when <code>HomeDirectoryType</code> is set to <i>LOGICAL</i>.</p> <p>The following is an <code>Entry</code> and <code>Target</code> pair example.</p> <p> <code>[ { "Entry": "/directory1", "Target": "/bucket_name/home/mydirectory" } ]</code> </p> <p>In most cases, you can use this value instead of the session policy to lock down your user to the designated home directory ("<code>chroot</code>"). To do this, you can set <code>Entry</code> to <code>/</code> and set <code>Target</code> to the <code>HomeDirectory</code> parameter value.</p> <p>The following is an <code>Entry</code> and <code>Target</code> pair example for <code>chroot</code>.</p> <p> <code>[ { "Entry:": "/", "Target": "/bucket_name/home/mydirectory" } ]</code> </p> <note> <p>If the target of a logical directory entry does not exist in Amazon S3 or EFS, the entry is ignored. As a workaround, you can use the Amazon S3 API or EFS API to create 0 byte objects as place holders for your directory. If using the CLI, use the <code>s3api</code> or <code>efsapi</code> call instead of <code>s3</code> or <code>efs</code> so you can use the put-object operation. For example, you use the following: <code>aws s3api put-object --bucket bucketname --key path/to/folder/</code>. Make sure that the end of the key name ends in a <code>/</code> for it to be considered a folder.</p> </note>', 'CreateUserRequest$HomeDirectoryMappings' => '<p>Logical directory mappings that specify what Amazon S3 or Amazon EFS paths and keys should be visible to your user and how you want to make them visible. You must specify the <code>Entry</code> and <code>Target</code> pair, where <code>Entry</code> shows how the path is made visible and <code>Target</code> is the actual Amazon S3 or Amazon EFS path. If you only specify a target, it is displayed as is. You also must ensure that your Amazon Web Services Identity and Access Management (IAM) role provides access to paths in <code>Target</code>. This value can only be set when <code>HomeDirectoryType</code> is set to <i>LOGICAL</i>.</p> <p>The following is an <code>Entry</code> and <code>Target</code> pair example.</p> <p> <code>[ { "Entry": "/directory1", "Target": "/bucket_name/home/mydirectory" } ]</code> </p> <p>In most cases, you can use this value instead of the session policy to lock your user down to the designated home directory ("<code>chroot</code>"). To do this, you can set <code>Entry</code> to <code>/</code> and set <code>Target</code> to the HomeDirectory parameter value.</p> <p>The following is an <code>Entry</code> and <code>Target</code> pair example for <code>chroot</code>.</p> <p> <code>[ { "Entry:": "/", "Target": "/bucket_name/home/mydirectory" } ]</code> </p> <note> <p>If the target of a logical directory entry does not exist in Amazon S3 or EFS, the entry is ignored. As a workaround, you can use the Amazon S3 API or EFS API to create 0 byte objects as place holders for your directory. If using the CLI, use the <code>s3api</code> or <code>efsapi</code> call instead of <code>s3</code> or <code>efs</code> so you can use the put-object operation. For example, you use the following: <code>aws s3api put-object --bucket bucketname --key path/to/folder/</code>. Make sure that the end of the key name ends in a <code>/</code> for it to be considered a folder.</p> </note>', 'DescribedAccess$HomeDirectoryMappings' => '<p>Logical directory mappings that specify what Amazon S3 or Amazon EFS paths and keys should be visible to your user and how you want to make them visible. You must specify the <code>Entry</code> and <code>Target</code> pair, where <code>Entry</code> shows how the path is made visible and <code>Target</code> is the actual Amazon S3 or Amazon EFS path. If you only specify a target, it is displayed as is. You also must ensure that your Amazon Web Services Identity and Access Management (IAM) role provides access to paths in <code>Target</code>. This value can only be set when <code>HomeDirectoryType</code> is set to <i>LOGICAL</i>.</p> <p>In most cases, you can use this value instead of the session policy to lock down the associated access to the designated home directory ("<code>chroot</code>"). To do this, you can set <code>Entry</code> to \'/\' and set <code>Target</code> to the <code>HomeDirectory</code> parameter value.</p>', 'DescribedUser$HomeDirectoryMappings' => '<p>Logical directory mappings that specify what Amazon S3 or Amazon EFS paths and keys should be visible to your user and how you want to make them visible. You must specify the <code>Entry</code> and <code>Target</code> pair, where <code>Entry</code> shows how the path is made visible and <code>Target</code> is the actual Amazon S3 or Amazon EFS path. If you only specify a target, it is displayed as is. You also must ensure that your Amazon Web Services Identity and Access Management (IAM) role provides access to paths in <code>Target</code>. This value can only be set when <code>HomeDirectoryType</code> is set to <i>LOGICAL</i>.</p> <p>In most cases, you can use this value instead of the session policy to lock your user down to the designated home directory ("<code>chroot</code>"). To do this, you can set <code>Entry</code> to \'/\' and set <code>Target</code> to the HomeDirectory parameter value.</p>', 'UpdateAccessRequest$HomeDirectoryMappings' => '<p>Logical directory mappings that specify what Amazon S3 or Amazon EFS paths and keys should be visible to your user and how you want to make them visible. You must specify the <code>Entry</code> and <code>Target</code> pair, where <code>Entry</code> shows how the path is made visible and <code>Target</code> is the actual Amazon S3 or Amazon EFS path. If you only specify a target, it is displayed as is. You also must ensure that your Amazon Web Services Identity and Access Management (IAM) role provides access to paths in <code>Target</code>. This value can only be set when <code>HomeDirectoryType</code> is set to <i>LOGICAL</i>.</p> <p>The following is an <code>Entry</code> and <code>Target</code> pair example.</p> <p> <code>[ { "Entry": "/directory1", "Target": "/bucket_name/home/mydirectory" } ]</code> </p> <p>In most cases, you can use this value instead of the session policy to lock down your user to the designated home directory ("<code>chroot</code>"). To do this, you can set <code>Entry</code> to <code>/</code> and set <code>Target</code> to the <code>HomeDirectory</code> parameter value.</p> <p>The following is an <code>Entry</code> and <code>Target</code> pair example for <code>chroot</code>.</p> <p> <code>[ { "Entry:": "/", "Target": "/bucket_name/home/mydirectory" } ]</code> </p> <note> <p>If the target of a logical directory entry does not exist in Amazon S3 or EFS, the entry is ignored. As a workaround, you can use the Amazon S3 API or EFS API to create 0 byte objects as place holders for your directory. If using the CLI, use the <code>s3api</code> or <code>efsapi</code> call instead of <code>s3</code> or <code>efs</code> so you can use the put-object operation. For example, you use the following: <code>aws s3api put-object --bucket bucketname --key path/to/folder/</code>. Make sure that the end of the key name ends in a <code>/</code> for it to be considered a folder.</p> </note>', 'UpdateUserRequest$HomeDirectoryMappings' => '<p>Logical directory mappings that specify what Amazon S3 or Amazon EFS paths and keys should be visible to your user and how you want to make them visible. You must specify the <code>Entry</code> and <code>Target</code> pair, where <code>Entry</code> shows how the path is made visible and <code>Target</code> is the actual Amazon S3 or Amazon EFS path. If you only specify a target, it is displayed as is. You also must ensure that your Amazon Web Services Identity and Access Management (IAM) role provides access to paths in <code>Target</code>. This value can only be set when <code>HomeDirectoryType</code> is set to <i>LOGICAL</i>.</p> <p>The following is an <code>Entry</code> and <code>Target</code> pair example.</p> <p> <code>[ { "Entry": "/directory1", "Target": "/bucket_name/home/mydirectory" } ]</code> </p> <p>In most cases, you can use this value instead of the session policy to lock down your user to the designated home directory ("<code>chroot</code>"). To do this, you can set <code>Entry</code> to \'/\' and set <code>Target</code> to the HomeDirectory parameter value.</p> <p>The following is an <code>Entry</code> and <code>Target</code> pair example for <code>chroot</code>.</p> <p> <code>[ { "Entry:": "/", "Target": "/bucket_name/home/mydirectory" } ]</code> </p> <note> <p>If the target of a logical directory entry does not exist in Amazon S3 or EFS, the entry is ignored. As a workaround, you can use the Amazon S3 API or EFS API to create 0 byte objects as place holders for your directory. If using the CLI, use the <code>s3api</code> or <code>efsapi</code> call instead of <code>s3</code> or <code>efs</code> so you can use the put-object operation. For example, you use the following: <code>aws s3api put-object --bucket bucketname --key path/to/folder/</code>. Make sure that the end of the key name ends in a <code>/</code> for it to be considered a folder.</p> </note>', ], ], 'HomeDirectoryType' => [ 'base' => NULL, 'refs' => [ 'CreateAccessRequest$HomeDirectoryType' => '<p>The type of landing directory (folder) you want your users\' home directory to be when they log into the server. If you set it to <code>PATH</code>, the user will see the absolute Amazon S3 bucket or EFS paths as is in their file transfer protocol clients. If you set it <code>LOGICAL</code>, you need to provide mappings in the <code>HomeDirectoryMappings</code> for how you want to make Amazon S3 or EFS paths visible to your users.</p>', 'CreateUserRequest$HomeDirectoryType' => '<p>The type of landing directory (folder) you want your users\' home directory to be when they log into the server. If you set it to <code>PATH</code>, the user will see the absolute Amazon S3 bucket or EFS paths as is in their file transfer protocol clients. If you set it <code>LOGICAL</code>, you need to provide mappings in the <code>HomeDirectoryMappings</code> for how you want to make Amazon S3 or EFS paths visible to your users.</p>', 'DescribedAccess$HomeDirectoryType' => '<p>The type of landing directory (folder) you want your users\' home directory to be when they log into the server. If you set it to <code>PATH</code>, the user will see the absolute Amazon S3 bucket or EFS paths as is in their file transfer protocol clients. If you set it <code>LOGICAL</code>, you need to provide mappings in the <code>HomeDirectoryMappings</code> for how you want to make Amazon S3 or EFS paths visible to your users.</p>', 'DescribedUser$HomeDirectoryType' => '<p>The type of landing directory (folder) you want your users\' home directory to be when they log into the server. If you set it to <code>PATH</code>, the user will see the absolute Amazon S3 bucket or EFS paths as is in their file transfer protocol clients. If you set it <code>LOGICAL</code>, you need to provide mappings in the <code>HomeDirectoryMappings</code> for how you want to make Amazon S3 or EFS paths visible to your users.</p>', 'ListedAccess$HomeDirectoryType' => '<p>The type of landing directory (folder) you want your users\' home directory to be when they log into the server. If you set it to <code>PATH</code>, the user will see the absolute Amazon S3 bucket or EFS paths as is in their file transfer protocol clients. If you set it <code>LOGICAL</code>, you need to provide mappings in the <code>HomeDirectoryMappings</code> for how you want to make Amazon S3 or EFS paths visible to your users.</p>', 'ListedUser$HomeDirectoryType' => '<p>The type of landing directory (folder) you want your users\' home directory to be when they log into the server. If you set it to <code>PATH</code>, the user will see the absolute Amazon S3 bucket or EFS paths as is in their file transfer protocol clients. If you set it <code>LOGICAL</code>, you need to provide mappings in the <code>HomeDirectoryMappings</code> for how you want to make Amazon S3 or EFS paths visible to your users.</p>', 'UpdateAccessRequest$HomeDirectoryType' => '<p>The type of landing directory (folder) you want your users\' home directory to be when they log into the server. If you set it to <code>PATH</code>, the user will see the absolute Amazon S3 bucket or EFS paths as is in their file transfer protocol clients. If you set it <code>LOGICAL</code>, you need to provide mappings in the <code>HomeDirectoryMappings</code> for how you want to make Amazon S3 or EFS paths visible to your users.</p>', 'UpdateUserRequest$HomeDirectoryType' => '<p>The type of landing directory (folder) you want your users\' home directory to be when they log into the server. If you set it to <code>PATH</code>, the user will see the absolute Amazon S3 bucket or EFS paths as is in their file transfer protocol clients. If you set it <code>LOGICAL</code>, you need to provide mappings in the <code>HomeDirectoryMappings</code> for how you want to make Amazon S3 or EFS paths visible to your users.</p>', ], ], 'HostKey' => [ 'base' => NULL, 'refs' => [ 'CreateServerRequest$HostKey' => '<p>The RSA private key as generated by the <code>ssh-keygen -N "" -m PEM -f my-new-server-key</code> command.</p> <important> <p>If you aren\'t planning to migrate existing users from an existing SFTP-enabled server to a new server, don\'t update the host key. Accidentally changing a server\'s host key can be disruptive.</p> </important> <p>For more information, see <a href="https://docs.aws.amazon.com/transfer/latest/userguide/edit-server-config.html#configuring-servers-change-host-key">Change the host key for your SFTP-enabled server</a> in the <i>Amazon Web Services Transfer Family User Guide</i>.</p>', 'UpdateServerRequest$HostKey' => '<p>The RSA private key as generated by <code>ssh-keygen -N "" -m PEM -f my-new-server-key</code>.</p> <important> <p>If you aren\'t planning to migrate existing users from an existing server to a new server, don\'t update the host key. Accidentally changing a server\'s host key can be disruptive.</p> </important> <p>For more information, see <a href="https://docs.aws.amazon.com/transfer/latest/userguide/edit-server-config.html#configuring-servers-change-host-key">Change the host key for your SFTP-enabled server</a> in the <i>Amazon Web ServicesTransfer Family User Guide</i>.</p>', ], ], 'HostKeyFingerprint' => [ 'base' => NULL, 'refs' => [ 'DescribedServer$HostKeyFingerprint' => '<p>Specifies the Base64-encoded SHA256 fingerprint of the server\'s host key. This value is equivalent to the output of the <code>ssh-keygen -l -f my-new-server-key</code> command.</p>', ], ], 'IdentityProviderDetails' => [ 'base' => '<p>Returns information related to the type of user authentication that is in use for a file transfer protocol-enabled server\'s users. A server can have only one method of authentication.</p>', 'refs' => [ 'CreateServerRequest$IdentityProviderDetails' => '<p>Required when <code>IdentityProviderType</code> is set to <code>AWS_DIRECTORY_SERVICE</code> or <code>API_GATEWAY</code>. Accepts an array containing all of the information required to use a directory in <code>AWS_DIRECTORY_SERVICE</code> or invoke a customer-supplied authentication API, including the API Gateway URL. Not required when <code>IdentityProviderType</code> is set to <code>SERVICE_MANAGED</code>.</p>', 'DescribedServer$IdentityProviderDetails' => '<p>Specifies information to call a customer-supplied authentication API. This field is not populated when the <code>IdentityProviderType</code> of a server is <code>AWS_DIRECTORY_SERVICE</code> or <code>SERVICE_MANAGED</code>.</p>', 'UpdateServerRequest$IdentityProviderDetails' => '<p>An array containing all of the information required to call a customer\'s authentication API method.</p>', ], ], 'IdentityProviderType' => [ 'base' => '<p>Returns information related to the type of user authentication that is in use for a file transfer protocol-enabled server\'s users. For <code>AWS_DIRECTORY_SERVICE</code> or <code>SERVICE_MANAGED</code> authentication, the Secure Shell (SSH) public keys are stored with a user on the server instance. For <code>API_GATEWAY</code> authentication, your custom authentication method is implemented by using an API call. The server can have only one method of authentication.</p>', 'refs' => [ 'CreateServerRequest$IdentityProviderType' => '<p>Specifies the mode of authentication for a server. The default value is <code>SERVICE_MANAGED</code>, which allows you to store and access user credentials within the Amazon Web Services Transfer Family service.</p> <p>Use <code>AWS_DIRECTORY_SERVICE</code> to provide access to Active Directory groups in Amazon Web Services Managed Active Directory or Microsoft Active Directory in your on-premises environment or in Amazon Web Services using AD Connectors. This option also requires you to provide a Directory ID using the <code>IdentityProviderDetails</code> parameter.</p> <p>Use the <code>API_GATEWAY</code> value to integrate with an identity provider of your choosing. The <code>API_GATEWAY</code> setting requires you to provide an API Gateway endpoint URL to call for authentication using the <code>IdentityProviderDetails</code> parameter.</p> <p>Use the <code>LAMBDA</code> value to directly use a Lambda function as your identity provider. If you choose this value, you must specify the ARN for the lambda function in the <code>Function</code> parameter for the <code>IdentityProviderDetails</code> data type.</p>', 'DescribedServer$IdentityProviderType' => '<p>Specifies the mode of authentication for a server. The default value is <code>SERVICE_MANAGED</code>, which allows you to store and access user credentials within the Amazon Web Services Transfer Family service.</p> <p>Use <code>AWS_DIRECTORY_SERVICE</code> to provide access to Active Directory groups in Amazon Web Services Managed Active Directory or Microsoft Active Directory in your on-premises environment or in Amazon Web Services using AD Connectors. This option also requires you to provide a Directory ID using the <code>IdentityProviderDetails</code> parameter.</p> <p>Use the <code>API_GATEWAY</code> value to integrate with an identity provider of your choosing. The <code>API_GATEWAY</code> setting requires you to provide an API Gateway endpoint URL to call for authentication using the <code>IdentityProviderDetails</code> parameter.</p> <p>Use the <code>LAMBDA</code> value to directly use a Lambda function as your identity provider. If you choose this value, you must specify the ARN for the lambda function in the <code>Function</code> parameter for the <code>IdentityProviderDetails</code> data type.</p>', 'ListedServer$IdentityProviderType' => '<p>Specifies the mode of authentication for a server. The default value is <code>SERVICE_MANAGED</code>, which allows you to store and access user credentials within the Amazon Web Services Transfer Family service.</p> <p>Use <code>AWS_DIRECTORY_SERVICE</code> to provide access to Active Directory groups in Amazon Web Services Managed Active Directory or Microsoft Active Directory in your on-premises environment or in Amazon Web Services using AD Connectors. This option also requires you to provide a Directory ID using the <code>IdentityProviderDetails</code> parameter.</p> <p>Use the <code>API_GATEWAY</code> value to integrate with an identity provider of your choosing. The <code>API_GATEWAY</code> setting requires you to provide an API Gateway endpoint URL to call for authentication using the <code>IdentityProviderDetails</code> parameter.</p> <p>Use the <code>LAMBDA</code> value to directly use a Lambda function as your identity provider. If you choose this value, you must specify the ARN for the lambda function in the <code>Function</code> parameter for the <code>IdentityProviderDetails</code> data type.</p>', ], ], 'ImportSshPublicKeyRequest' => [ 'base' => NULL, 'refs' => [], ], 'ImportSshPublicKeyResponse' => [ 'base' => '<p>Identifies the user, the server they belong to, and the identifier of the SSH public key associated with that user. A user can have more than one key on each server that they are associated with.</p>', 'refs' => [], ], 'InputFileLocation' => [ 'base' => '<p>Specifies the location for the file being copied. Only applicable for the Copy type of workflow steps.</p>', 'refs' => [ 'CopyStepDetails$DestinationFileLocation' => NULL, ], ], 'InternalServiceError' => [ 'base' => '<p>This exception is thrown when an error occurs in the Amazon Web ServicesTransfer Family service.</p>', 'refs' => [], ], 'InvalidNextTokenException' => [ 'base' => '<p>The <code>NextToken</code> parameter that was passed is invalid.</p>', 'refs' => [], ], 'InvalidRequestException' => [ 'base' => '<p>This exception is thrown when the client submits a malformed request.</p>', 'refs' => [], ], 'ListAccessesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListAccessesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListExecutionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListExecutionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListSecurityPoliciesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListSecurityPoliciesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListServersRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListServersResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListUsersRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListUsersResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListWorkflowsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListWorkflowsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListedAccess' => [ 'base' => '<p>Lists the properties for one or more specified associated accesses.</p>', 'refs' => [ 'ListedAccesses$member' => NULL, ], ], 'ListedAccesses' => [ 'base' => NULL, 'refs' => [ 'ListAccessesResponse$Accesses' => '<p>Returns the accesses and their properties for the <code>ServerId</code> value that you specify.</p>', ], ], 'ListedExecution' => [ 'base' => '<p>Returns properties of the execution that is specified.</p>', 'refs' => [ 'ListedExecutions$member' => NULL, ], ], 'ListedExecutions' => [ 'base' => NULL, 'refs' => [ 'ListExecutionsResponse$Executions' => '<p>Returns the details for each execution.</p> <ul> <li> <p> <b>NextToken</b>: returned from a call to several APIs, you can use pass it to a subsequent command to continue listing additional executions.</p> </li> <li> <p> <b>StartTime</b>: timestamp indicating when the execution began.</p> </li> <li> <p> <b>Executions</b>: details of the execution, including the execution ID, initial file location, and Service metadata.</p> </li> <li> <p> <b>Status</b>: one of the following values: <code>IN_PROGRESS</code>, <code>COMPLETED</code>, <code>EXCEPTION</code>, <code>HANDLING_EXEPTION</code>. </p> </li> </ul>', ], ], 'ListedServer' => [ 'base' => '<p>Returns properties of a file transfer protocol-enabled server that was specified.</p>', 'refs' => [ 'ListedServers$member' => NULL, ], ], 'ListedServers' => [ 'base' => NULL, 'refs' => [ 'ListServersResponse$Servers' => '<p>An array of servers that were listed.</p>', ], ], 'ListedUser' => [ 'base' => '<p>Returns properties of the user that you specify.</p>', 'refs' => [ 'ListedUsers$member' => NULL, ], ], 'ListedUsers' => [ 'base' => NULL, 'refs' => [ 'ListUsersResponse$Users' => '<p>Returns the user accounts and their properties for the <code>ServerId</code> value that you specify.</p>', ], ], 'ListedWorkflow' => [ 'base' => '<p>Contains the ID, text description, and Amazon Resource Name (ARN) for the workflow.</p>', 'refs' => [ 'ListedWorkflows$member' => NULL, ], ], 'ListedWorkflows' => [ 'base' => NULL, 'refs' => [ 'ListWorkflowsResponse$Workflows' => '<p>Returns the <code>Arn</code>, <code>WorkflowId</code>, and <code>Description</code> for each workflow.</p>', ], ], 'LogGroupName' => [ 'base' => NULL, 'refs' => [ 'LoggingConfiguration$LogGroupName' => '<p>The name of the CloudWatch logging group for the Amazon Web Services Transfer server to which this workflow belongs.</p>', ], ], 'LoggingConfiguration' => [ 'base' => '<p>Consists of the logging role and the log group name.</p>', 'refs' => [ 'DescribedExecution$LoggingConfiguration' => '<p>The IAM logging role associated with the execution.</p>', ], ], 'MapEntry' => [ 'base' => NULL, 'refs' => [ 'HomeDirectoryMapEntry$Entry' => '<p>Represents an entry for <code>HomeDirectoryMappings</code>.</p>', ], ], 'MapTarget' => [ 'base' => NULL, 'refs' => [ 'HomeDirectoryMapEntry$Target' => '<p>Represents the map target that is used in a <code>HomeDirectorymapEntry</code>.</p>', ], ], 'MaxResults' => [ 'base' => NULL, 'refs' => [ 'ListAccessesRequest$MaxResults' => '<p>Specifies the maximum number of access SIDs to return.</p>', 'ListExecutionsRequest$MaxResults' => '<p>Specifies the aximum number of executions to return.</p>', 'ListSecurityPoliciesRequest$MaxResults' => '<p>Specifies the number of security policies to return as a response to the <code>ListSecurityPolicies</code> query.</p>', 'ListServersRequest$MaxResults' => '<p>Specifies the number of servers to return as a response to the <code>ListServers</code> query.</p>', 'ListTagsForResourceRequest$MaxResults' => '<p>Specifies the number of tags to return as a response to the <code>ListTagsForResource</code> request.</p>', 'ListUsersRequest$MaxResults' => '<p>Specifies the number of users to return as a response to the <code>ListUsers</code> request.</p>', 'ListWorkflowsRequest$MaxResults' => '<p>Specifies the maximum number of workflows to return.</p>', ], ], 'Message' => [ 'base' => NULL, 'refs' => [ 'ConflictException$Message' => NULL, 'InternalServiceError$Message' => NULL, 'InvalidNextTokenException$Message' => NULL, 'InvalidRequestException$Message' => NULL, 'ResourceExistsException$Message' => NULL, 'ResourceNotFoundException$Message' => NULL, 'TestIdentityProviderResponse$Message' => '<p>A message that indicates whether the test was successful or not.</p>', ], ], 'NextToken' => [ 'base' => NULL, 'refs' => [ 'ListAccessesRequest$NextToken' => '<p>When you can get additional results from the <code>ListAccesses</code> call, a <code>NextToken</code> parameter is returned in the output. You can then pass in a subsequent command to the <code>NextToken</code> parameter to continue listing additional accesses.</p>', 'ListAccessesResponse$NextToken' => '<p>When you can get additional results from the <code>ListAccesses</code> call, a <code>NextToken</code> parameter is returned in the output. You can then pass in a subsequent command to the <code>NextToken</code> parameter to continue listing additional accesses.</p>', 'ListExecutionsRequest$NextToken' => '<p> <code>ListExecutions</code> returns the <code>NextToken</code> parameter in the output. You can then pass the <code>NextToken</code> parameter in a subsequent command to continue listing additional executions.</p> <p> This is useful for pagination, for instance. If you have 100 executions for a workflow, you might only want to list first 10. If so, callthe API by specifing the <code>max-results</code>: </p> <p> <code>aws transfer list-executions --max-results 10</code> </p> <p> This returns details for the first 10 executions, as well as the pointer (<code>NextToken</code>) to the eleventh execution. You can now call the API again, suppling the <code>NextToken</code> value you received: </p> <p> <code>aws transfer list-executions --max-results 10 --next-token $somePointerReturnedFromPreviousListResult</code> </p> <p> This call returns the next 10 executions, the 11th through the 20th. You can then repeat the call until the details for all 100 executions have been returned. </p>', 'ListExecutionsResponse$NextToken' => '<p> <code>ListExecutions</code> returns the <code>NextToken</code> parameter in the output. You can then pass the <code>NextToken</code> parameter in a subsequent command to continue listing additional executions.</p>', 'ListSecurityPoliciesRequest$NextToken' => '<p>When additional results are obtained from the <code>ListSecurityPolicies</code> command, a <code>NextToken</code> parameter is returned in the output. You can then pass the <code>NextToken</code> parameter in a subsequent command to continue listing additional security policies.</p>', 'ListSecurityPoliciesResponse$NextToken' => '<p>When you can get additional results from the <code>ListSecurityPolicies</code> operation, a <code>NextToken</code> parameter is returned in the output. In a following command, you can pass in the <code>NextToken</code> parameter to continue listing security policies.</p>', 'ListServersRequest$NextToken' => '<p>When additional results are obtained from the <code>ListServers</code> command, a <code>NextToken</code> parameter is returned in the output. You can then pass the <code>NextToken</code> parameter in a subsequent command to continue listing additional servers.</p>', 'ListServersResponse$NextToken' => '<p>When you can get additional results from the <code>ListServers</code> operation, a <code>NextToken</code> parameter is returned in the output. In a following command, you can pass in the <code>NextToken</code> parameter to continue listing additional servers.</p>', 'ListTagsForResourceRequest$NextToken' => '<p>When you request additional results from the <code>ListTagsForResource</code> operation, a <code>NextToken</code> parameter is returned in the input. You can then pass in a subsequent command to the <code>NextToken</code> parameter to continue listing additional tags.</p>', 'ListTagsForResourceResponse$NextToken' => '<p>When you can get additional results from the <code>ListTagsForResource</code> call, a <code>NextToken</code> parameter is returned in the output. You can then pass in a subsequent command to the <code>NextToken</code> parameter to continue listing additional tags.</p>', 'ListUsersRequest$NextToken' => '<p>When you can get additional results from the <code>ListUsers</code> call, a <code>NextToken</code> parameter is returned in the output. You can then pass in a subsequent command to the <code>NextToken</code> parameter to continue listing additional users.</p>', 'ListUsersResponse$NextToken' => '<p>When you can get additional results from the <code>ListUsers</code> call, a <code>NextToken</code> parameter is returned in the output. You can then pass in a subsequent command to the <code>NextToken</code> parameter to continue listing additional users.</p>', 'ListWorkflowsRequest$NextToken' => '<p> <code>ListWorkflows</code> returns the <code>NextToken</code> parameter in the output. You can then pass the <code>NextToken</code> parameter in a subsequent command to continue listing additional workflows.</p>', 'ListWorkflowsResponse$NextToken' => '<p> <code>ListWorkflows</code> returns the <code>NextToken</code> parameter in the output. You can then pass the <code>NextToken</code> parameter in a subsequent command to continue listing additional workflows.</p>', ], ], 'NullableRole' => [ 'base' => NULL, 'refs' => [ 'UpdateServerRequest$LoggingRole' => '<p>Specifies the Amazon Resource Name (ARN) of the Amazon Web Services Identity and Access Management (IAM) role that allows a server to turn on Amazon CloudWatch logging for Amazon S3 or Amazon EFS events. When set, user activity can be viewed in your CloudWatch logs.</p>', ], ], 'OnUploadWorkflowDetails' => [ 'base' => NULL, 'refs' => [ 'WorkflowDetails$OnUpload' => '<p>A trigger that starts a workflow: the workflow begins to execute after a file is uploaded.</p>', ], ], 'OverwriteExisting' => [ 'base' => NULL, 'refs' => [ 'CopyStepDetails$OverwriteExisting' => '<p>A flag that indicates whether or not to overwrite an existing file of the same name. The default is <code>FALSE</code>.</p>', ], ], 'PassiveIp' => [ 'base' => NULL, 'refs' => [ 'ProtocolDetails$PassiveIp' => '<p> Indicates passive mode, for FTP and FTPS protocols. Enter a single dotted-quad IPv4 address, such as the external IP address of a firewall, router, or load balancer. For example: </p> <p> <code> aws transfer update-server --protocol-details PassiveIp=<i>0.0.0.0</i> </code> </p> <p>Replace <code> <i>0.0.0.0</i> </code> in the example above with the actual IP address you want to use.</p> <note> <p> If you change the <code>PassiveIp</code> value, you must stop and then restart your Transfer server for the change to take effect. For details on using Passive IP (PASV) in a NAT environment, see <a href="http://aws.amazon.com/blogs/storage/configuring-your-ftps-server-behind-a-firewall-or-nat-with-aws-transfer-family/">Configuring your FTPS server behind a firewall or NAT with Amazon Web Services Transfer Family</a>. </p> </note>', ], ], 'Policy' => [ 'base' => NULL, 'refs' => [ 'CreateAccessRequest$Policy' => '<p>A session policy for your user so that you can use the same IAM role across multiple users. This policy scopes down user access to portions of their Amazon S3 bucket. Variables that you can use inside this policy include <code>${Transfer:UserName}</code>, <code>${Transfer:HomeDirectory}</code>, and <code>${Transfer:HomeBucket}</code>.</p> <note> <p>This only applies when the domain of <code>ServerId</code> is S3. EFS does not use session policies.</p> <p>For session policies, Amazon Web Services Transfer Family stores the policy as a JSON blob, instead of the Amazon Resource Name (ARN) of the policy. You save the policy as a JSON blob and pass it in the <code>Policy</code> argument.</p> <p>For an example of a session policy, see <a href="https://docs.aws.amazon.com/transfer/latest/userguide/session-policy.html">Example session policy</a>.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/STS/latest/APIReference/API_AssumeRole.html">AssumeRole</a> in the <i>Amazon Web Services Security Token Service API Reference</i>.</p> </note>', 'CreateUserRequest$Policy' => '<p>A session policy for your user so that you can use the same IAM role across multiple users. This policy scopes down user access to portions of their Amazon S3 bucket. Variables that you can use inside this policy include <code>${Transfer:UserName}</code>, <code>${Transfer:HomeDirectory}</code>, and <code>${Transfer:HomeBucket}</code>.</p> <note> <p>This only applies when the domain of <code>ServerId</code> is S3. EFS does not use session policies.</p> <p>For session policies, Amazon Web Services Transfer Family stores the policy as a JSON blob, instead of the Amazon Resource Name (ARN) of the policy. You save the policy as a JSON blob and pass it in the <code>Policy</code> argument.</p> <p>For an example of a session policy, see <a href="https://docs.aws.amazon.com/transfer/latest/userguide/session-policy.html">Example session policy</a>.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/STS/latest/APIReference/API_AssumeRole.html">AssumeRole</a> in the <i>Amazon Web Services Security Token Service API Reference</i>.</p> </note>', 'DescribedAccess$Policy' => '<p>A session policy for your user so that you can use the same IAM role across multiple users. This policy scopes down user access to portions of their Amazon S3 bucket. Variables that you can use inside this policy include <code>${Transfer:UserName}</code>, <code>${Transfer:HomeDirectory}</code>, and <code>${Transfer:HomeBucket}</code>.</p>', 'DescribedUser$Policy' => '<p>A session policy for your user so that you can use the same IAM role across multiple users. This policy scopes down user access to portions of their Amazon S3 bucket. Variables that you can use inside this policy include <code>${Transfer:UserName}</code>, <code>${Transfer:HomeDirectory}</code>, and <code>${Transfer:HomeBucket}</code>.</p>', 'UpdateAccessRequest$Policy' => '<p>A session policy for your user so that you can use the same IAM role across multiple users. This policy scopes down user access to portions of their Amazon S3 bucket. Variables that you can use inside this policy include <code>${Transfer:UserName}</code>, <code>${Transfer:HomeDirectory}</code>, and <code>${Transfer:HomeBucket}</code>.</p> <note> <p>This only applies when the domain of <code>ServerId</code> is S3. EFS does not use session policies.</p> <p>For session policies, Amazon Web Services Transfer Family stores the policy as a JSON blob, instead of the Amazon Resource Name (ARN) of the policy. You save the policy as a JSON blob and pass it in the <code>Policy</code> argument.</p> <p>For an example of a session policy, see <a href="https://docs.aws.amazon.com/transfer/latest/userguide/session-policy.html">Example session policy</a>.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/STS/latest/APIReference/API_AssumeRole.html">AssumeRole</a> in the <i>Amazon Web ServicesSecurity Token Service API Reference</i>.</p> </note>', 'UpdateUserRequest$Policy' => '<p>A session policy for your user so that you can use the same IAM role across multiple users. This policy scopes down user access to portions of their Amazon S3 bucket. Variables that you can use inside this policy include <code>${Transfer:UserName}</code>, <code>${Transfer:HomeDirectory}</code>, and <code>${Transfer:HomeBucket}</code>.</p> <note> <p>This only applies when the domain of <code>ServerId</code> is S3. EFS does not use session policies.</p> <p>For session policies, Amazon Web Services Transfer Family stores the policy as a JSON blob, instead of the Amazon Resource Name (ARN) of the policy. You save the policy as a JSON blob and pass it in the <code>Policy</code> argument.</p> <p>For an example of a session policy, see <a href="https://docs.aws.amazon.com/transfer/latest/userguide/session-policy">Creating a session policy</a>.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/STS/latest/APIReference/API_AssumeRole.html">AssumeRole</a> in the <i>Amazon Web Services Security Token Service API Reference</i>.</p> </note>', ], ], 'PosixId' => [ 'base' => NULL, 'refs' => [ 'PosixProfile$Uid' => '<p>The POSIX user ID used for all EFS operations by this user.</p>', 'PosixProfile$Gid' => '<p>The POSIX group ID used for all EFS operations by this user.</p>', 'SecondaryGids$member' => NULL, ], ], 'PosixProfile' => [ 'base' => '<p>The full POSIX identity, including user ID (<code>Uid</code>), group ID (<code>Gid</code>), and any secondary groups IDs (<code>SecondaryGids</code>), that controls your users\' access to your Amazon EFS file systems. The POSIX permissions that are set on files and directories in your file system determine the level of access your users get when transferring files into and out of your Amazon EFS file systems.</p>', 'refs' => [ 'CreateAccessRequest$PosixProfile' => NULL, 'CreateUserRequest$PosixProfile' => '<p>Specifies the full POSIX identity, including user ID (<code>Uid</code>), group ID (<code>Gid</code>), and any secondary groups IDs (<code>SecondaryGids</code>), that controls your users\' access to your Amazon EFS file systems. The POSIX permissions that are set on files and directories in Amazon EFS determine the level of access your users get when transferring files into and out of your Amazon EFS file systems.</p>', 'DescribedAccess$PosixProfile' => NULL, 'DescribedExecution$PosixProfile' => NULL, 'DescribedUser$PosixProfile' => '<p>Specifies the full POSIX identity, including user ID (<code>Uid</code>), group ID (<code>Gid</code>), and any secondary groups IDs (<code>SecondaryGids</code>), that controls your users\' access to your Amazon Elastic File System (Amazon EFS) file systems. The POSIX permissions that are set on files and directories in your file system determine the level of access your users get when transferring files into and out of your Amazon EFS file systems.</p>', 'UpdateAccessRequest$PosixProfile' => NULL, 'UpdateUserRequest$PosixProfile' => '<p>Specifies the full POSIX identity, including user ID (<code>Uid</code>), group ID (<code>Gid</code>), and any secondary groups IDs (<code>SecondaryGids</code>), that controls your users\' access to your Amazon Elastic File Systems (Amazon EFS). The POSIX permissions that are set on files and directories in your file system determines the level of access your users get when transferring files into and out of your Amazon EFS file systems.</p>', ], ], 'Protocol' => [ 'base' => NULL, 'refs' => [ 'Protocols$member' => NULL, 'TestIdentityProviderRequest$ServerProtocol' => '<p>The type of file transfer protocol to be tested.</p> <p>The available protocols are:</p> <ul> <li> <p>Secure Shell (SSH) File Transfer Protocol (SFTP)</p> </li> <li> <p>File Transfer Protocol Secure (FTPS)</p> </li> <li> <p>File Transfer Protocol (FTP)</p> </li> </ul>', ], ], 'ProtocolDetails' => [ 'base' => '<p> The protocol settings that are configured for your server. </p> <note> <p> This type is only valid in the <code>UpdateServer</code> API. </p> </note>', 'refs' => [ 'DescribedServer$ProtocolDetails' => '<p> The protocol settings that are configured for your server. </p> <p> Use the <code>PassiveIp</code> parameter to indicate passive mode. Enter a single dotted-quad IPv4 address, such as the external IP address of a firewall, router, or load balancer. </p>', 'UpdateServerRequest$ProtocolDetails' => '<p> The protocol settings that are configured for your server. </p> <p> Use the <code>PassiveIp</code> parameter to indicate passive mode (for FTP and FTPS protocols). Enter a single dotted-quad IPv4 address, such as the external IP address of a firewall, router, or load balancer. </p>', ], ], 'Protocols' => [ 'base' => NULL, 'refs' => [ 'CreateServerRequest$Protocols' => '<p>Specifies the file transfer protocol or protocols over which your file transfer protocol client can connect to your server\'s endpoint. The available protocols are:</p> <ul> <li> <p> <code>SFTP</code> (Secure Shell (SSH) File Transfer Protocol): File transfer over SSH</p> </li> <li> <p> <code>FTPS</code> (File Transfer Protocol Secure): File transfer with TLS encryption</p> </li> <li> <p> <code>FTP</code> (File Transfer Protocol): Unencrypted file transfer</p> </li> </ul> <note> <p>If you select <code>FTPS</code>, you must choose a certificate stored in Amazon Web Services Certificate Manager (ACM) which is used to identify your server when clients connect to it over FTPS.</p> <p>If <code>Protocol</code> includes either <code>FTP</code> or <code>FTPS</code>, then the <code>EndpointType</code> must be <code>VPC</code> and the <code>IdentityProviderType</code> must be <code>AWS_DIRECTORY_SERVICE</code> or <code>API_GATEWAY</code>.</p> <p>If <code>Protocol</code> includes <code>FTP</code>, then <code>AddressAllocationIds</code> cannot be associated.</p> <p>If <code>Protocol</code> is set only to <code>SFTP</code>, the <code>EndpointType</code> can be set to <code>PUBLIC</code> and the <code>IdentityProviderType</code> can be set to <code>SERVICE_MANAGED</code>.</p> </note>', 'DescribedServer$Protocols' => '<p>Specifies the file transfer protocol or protocols over which your file transfer protocol client can connect to your server\'s endpoint. The available protocols are:</p> <ul> <li> <p> <code>SFTP</code> (Secure Shell (SSH) File Transfer Protocol): File transfer over SSH</p> </li> <li> <p> <code>FTPS</code> (File Transfer Protocol Secure): File transfer with TLS encryption</p> </li> <li> <p> <code>FTP</code> (File Transfer Protocol): Unencrypted file transfer</p> </li> </ul>', 'UpdateServerRequest$Protocols' => '<p>Specifies the file transfer protocol or protocols over which your file transfer protocol client can connect to your server\'s endpoint. The available protocols are:</p> <ul> <li> <p>Secure Shell (SSH) File Transfer Protocol (SFTP): File transfer over SSH</p> </li> <li> <p>File Transfer Protocol Secure (FTPS): File transfer with TLS encryption</p> </li> <li> <p>File Transfer Protocol (FTP): Unencrypted file transfer</p> </li> </ul> <note> <p>If you select <code>FTPS</code>, you must choose a certificate stored in Amazon Web ServicesCertificate Manager (ACM) which will be used to identify your server when clients connect to it over FTPS.</p> <p>If <code>Protocol</code> includes either <code>FTP</code> or <code>FTPS</code>, then the <code>EndpointType</code> must be <code>VPC</code> and the <code>IdentityProviderType</code> must be <code>AWS_DIRECTORY_SERVICE</code> or <code>API_GATEWAY</code>.</p> <p>If <code>Protocol</code> includes <code>FTP</code>, then <code>AddressAllocationIds</code> cannot be associated.</p> <p>If <code>Protocol</code> is set only to <code>SFTP</code>, the <code>EndpointType</code> can be set to <code>PUBLIC</code> and the <code>IdentityProviderType</code> can be set to <code>SERVICE_MANAGED</code>.</p> </note>', ], ], 'Resource' => [ 'base' => NULL, 'refs' => [ 'ResourceExistsException$Resource' => NULL, 'ResourceNotFoundException$Resource' => NULL, ], ], 'ResourceExistsException' => [ 'base' => '<p>The requested resource does not exist.</p>', 'refs' => [], ], 'ResourceNotFoundException' => [ 'base' => '<p>This exception is thrown when a resource is not found by the Amazon Web ServicesTransfer Family service.</p>', 'refs' => [], ], 'ResourceType' => [ 'base' => NULL, 'refs' => [ 'ResourceExistsException$ResourceType' => NULL, 'ResourceNotFoundException$ResourceType' => NULL, ], ], 'Response' => [ 'base' => NULL, 'refs' => [ 'TestIdentityProviderResponse$Response' => '<p>The response that is returned from your API Gateway.</p>', ], ], 'RetryAfterSeconds' => [ 'base' => NULL, 'refs' => [ 'ThrottlingException$RetryAfterSeconds' => NULL, ], ], 'Role' => [ 'base' => NULL, 'refs' => [ 'CreateAccessRequest$Role' => '<p>Specifies the Amazon Resource Name (ARN) of the IAM role that controls your users\' access to your Amazon S3 bucket or EFS file system. The policies attached to this role determine the level of access that you want to provide your users when transferring files into and out of your Amazon S3 bucket or EFS file system. The IAM role should also contain a trust relationship that allows the server to access your resources when servicing your users\' transfer requests.</p>', 'CreateServerRequest$LoggingRole' => '<p>Specifies the Amazon Resource Name (ARN) of the Amazon Web Services Identity and Access Management (IAM) role that allows a server to turn on Amazon CloudWatch logging for Amazon S3 or Amazon EFS events. When set, user activity can be viewed in your CloudWatch logs.</p>', 'CreateUserRequest$Role' => '<p>Specifies the Amazon Resource Name (ARN) of the IAM role that controls your users\' access to your Amazon S3 bucket or EFS file system. The policies attached to this role determine the level of access that you want to provide your users when transferring files into and out of your Amazon S3 bucket or EFS file system. The IAM role should also contain a trust relationship that allows the server to access your resources when servicing your users\' transfer requests.</p>', 'DescribedAccess$Role' => '<p>Specifies the Amazon Resource Name (ARN) of the IAM role that controls your users\' access to your Amazon S3 bucket or EFS file system. The policies attached to this role determine the level of access that you want to provide your users when transferring files into and out of your Amazon S3 bucket or EFS file system. The IAM role should also contain a trust relationship that allows the server to access your resources when servicing your users\' transfer requests.</p>', 'DescribedExecution$ExecutionRole' => '<p>The IAM role associated with the execution.</p>', 'DescribedServer$LoggingRole' => '<p>Specifies the Amazon Resource Name (ARN) of the Amazon Web Services Identity and Access Management (IAM) role that allows a server to turn on Amazon CloudWatch logging for Amazon S3 or Amazon EFS events. When set, user activity can be viewed in your CloudWatch logs.</p>', 'DescribedUser$Role' => '<p>Specifies the Amazon Resource Name (ARN) of the IAM role that controls your users\' access to your Amazon S3 bucket or EFS file system. The policies attached to this role determine the level of access that you want to provide your users when transferring files into and out of your Amazon S3 bucket or EFS file system. The IAM role should also contain a trust relationship that allows the server to access your resources when servicing your users\' transfer requests.</p>', 'IdentityProviderDetails$InvocationRole' => '<p>Provides the type of <code>InvocationRole</code> used to authenticate the user account.</p>', 'ListedAccess$Role' => '<p>Specifies the Amazon Resource Name (ARN) of the IAM role that controls your users\' access to your Amazon S3 bucket or EFS file system. The policies attached to this role determine the level of access that you want to provide your users when transferring files into and out of your Amazon S3 bucket or EFS file system. The IAM role should also contain a trust relationship that allows the server to access your resources when servicing your users\' transfer requests.</p>', 'ListedServer$LoggingRole' => '<p>Specifies the Amazon Resource Name (ARN) of the Amazon Web Services Identity and Access Management (IAM) role that allows a server to turn on Amazon CloudWatch logging for Amazon S3 or Amazon EFS events. When set, user activity can be viewed in your CloudWatch logs.</p>', 'ListedUser$Role' => '<p>Specifies the Amazon Resource Name (ARN) of the IAM role that controls your users\' access to your Amazon S3 bucket or EFS file system. The policies attached to this role determine the level of access that you want to provide your users when transferring files into and out of your Amazon S3 bucket or EFS file system. The IAM role should also contain a trust relationship that allows the server to access your resources when servicing your users\' transfer requests.</p> <note> <p>The IAM role that controls your users\' access to your Amazon S3 bucket for servers with <code>Domain=S3</code>, or your EFS file system for servers with <code>Domain=EFS</code>. </p> <p>The policies attached to this role determine the level of access you want to provide your users when transferring files into and out of your S3 buckets or EFS file systems.</p> </note>', 'LoggingConfiguration$LoggingRole' => '<p>Specifies the Amazon Resource Name (ARN) of the Amazon Web Services Identity and Access Management (IAM) role that allows a server to turn on Amazon CloudWatch logging for Amazon S3 or Amazon EFS events. When set, user activity can be viewed in your CloudWatch logs.</p>', 'UpdateAccessRequest$Role' => '<p>Specifies the Amazon Resource Name (ARN) of the IAM role that controls your users\' access to your Amazon S3 bucket or EFS file system. The policies attached to this role determine the level of access that you want to provide your users when transferring files into and out of your Amazon S3 bucket or EFS file system. The IAM role should also contain a trust relationship that allows the server to access your resources when servicing your users\' transfer requests.</p>', 'UpdateUserRequest$Role' => '<p>Specifies the Amazon Resource Name (ARN) of the IAM role that controls your users\' access to your Amazon S3 bucket or EFS file system. The policies attached to this role determine the level of access that you want to provide your users when transferring files into and out of your Amazon S3 bucket or EFS file system. The IAM role should also contain a trust relationship that allows the server to access your resources when servicing your users\' transfer requests.</p>', 'WorkflowDetail$ExecutionRole' => '<p>Includes the necessary permissions for S3, EFS, and Lambda operations that Transfer can assume, so that all workflow steps can operate on the required resources</p>', ], ], 'S3Bucket' => [ 'base' => NULL, 'refs' => [ 'S3FileLocation$Bucket' => '<p>Specifies the S3 bucket that contains the file being used.</p>', 'S3InputFileLocation$Bucket' => '<p>Specifies the S3 bucket for the customer input file.</p>', ], ], 'S3Etag' => [ 'base' => NULL, 'refs' => [ 'S3FileLocation$Etag' => '<p>The entity tag is a hash of the object. The ETag reflects changes only to the contents of an object, not its metadata.</p>', ], ], 'S3FileLocation' => [ 'base' => '<p>Specifies the details for the file location for the file being used in the workflow. Only applicable if you are using S3 storage.</p>', 'refs' => [ 'FileLocation$S3FileLocation' => '<p>Specifies the S3 details for the file being used, such as bucket, Etag, and so forth.</p>', ], ], 'S3InputFileLocation' => [ 'base' => '<p>Specifies the customer input S3 file location. If it is used inside <code>copyStepDetails.DestinationFileLocation</code>, it should be the S3 copy destination.</p> <p> You need to provide the bucket and key. The key can represent either a path or a file. This is determined by whether or not you end the key value with the forward slash (/) character. If the final character is "/", then your file is copied to the folder, and its name does not change. If, rather, the final character is alphanumeric, your uploaded file is renamed to the path value. In this case, if a file with that name already exists, it is overwritten. </p> <p>For example, if your path is <code>shared-files/bob/</code>, your uploaded files are copied to the <code>shared-files/bob/</code>, folder. If your path is <code>shared-files/today</code>, each uploaded file is copied to the <code>shared-files</code> folder and named <code>today</code>: each upload overwrites the previous version of the <i>bob</i> file.</p>', 'refs' => [ 'InputFileLocation$S3FileLocation' => '<p>Specifies the details for the S3 file being copied.</p>', ], ], 'S3Key' => [ 'base' => NULL, 'refs' => [ 'S3FileLocation$Key' => '<p>The name assigned to the file when it was created in S3. You use the object key to retrieve the object.</p>', 'S3InputFileLocation$Key' => '<p>The name assigned to the file when it was created in S3. You use the object key to retrieve the object.</p>', ], ], 'S3Tag' => [ 'base' => '<p>Specifies the key-value pair that are assigned to a file during the execution of a Tagging step.</p>', 'refs' => [ 'S3Tags$member' => NULL, ], ], 'S3TagKey' => [ 'base' => NULL, 'refs' => [ 'S3Tag$Key' => '<p>The name assigned to the tag that you create.</p>', ], ], 'S3TagValue' => [ 'base' => NULL, 'refs' => [ 'S3Tag$Value' => '<p>The value that corresponds to the key.</p>', ], ], 'S3Tags' => [ 'base' => NULL, 'refs' => [ 'TagStepDetails$Tags' => '<p>Array that contains from 1 to 10 key/value pairs.</p>', ], ], 'S3VersionId' => [ 'base' => NULL, 'refs' => [ 'S3FileLocation$VersionId' => '<p>Specifies the file version.</p>', ], ], 'SecondaryGids' => [ 'base' => NULL, 'refs' => [ 'PosixProfile$SecondaryGids' => '<p>The secondary POSIX group IDs used for all EFS operations by this user.</p>', ], ], 'SecurityGroupId' => [ 'base' => NULL, 'refs' => [ 'SecurityGroupIds$member' => NULL, ], ], 'SecurityGroupIds' => [ 'base' => NULL, 'refs' => [ 'EndpointDetails$SecurityGroupIds' => '<p>A list of security groups IDs that are available to attach to your server\'s endpoint.</p> <note> <p>This property can only be set when <code>EndpointType</code> is set to <code>VPC</code>.</p> <p>You can edit the <code>SecurityGroupIds</code> property in the <a href="https://docs.aws.amazon.com/transfer/latest/userguide/API_UpdateServer.html">UpdateServer</a> API only if you are changing the <code>EndpointType</code> from <code>PUBLIC</code> or <code>VPC_ENDPOINT</code> to <code>VPC</code>. To change security groups associated with your server\'s VPC endpoint after creation, use the Amazon EC2 <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyVpcEndpoint.html">ModifyVpcEndpoint</a> API.</p> </note>', ], ], 'SecurityPolicyName' => [ 'base' => NULL, 'refs' => [ 'CreateServerRequest$SecurityPolicyName' => '<p>Specifies the name of the security policy that is attached to the server.</p>', 'DescribeSecurityPolicyRequest$SecurityPolicyName' => '<p>Specifies the name of the security policy that is attached to the server.</p>', 'DescribedSecurityPolicy$SecurityPolicyName' => '<p>Specifies the name of the security policy that is attached to the server.</p>', 'DescribedServer$SecurityPolicyName' => '<p>Specifies the name of the security policy that is attached to the server.</p>', 'SecurityPolicyNames$member' => NULL, 'UpdateServerRequest$SecurityPolicyName' => '<p>Specifies the name of the security policy that is attached to the server.</p>', ], ], 'SecurityPolicyNames' => [ 'base' => NULL, 'refs' => [ 'ListSecurityPoliciesResponse$SecurityPolicyNames' => '<p>An array of security policies that were listed.</p>', ], ], 'SecurityPolicyOption' => [ 'base' => NULL, 'refs' => [ 'SecurityPolicyOptions$member' => NULL, ], ], 'SecurityPolicyOptions' => [ 'base' => NULL, 'refs' => [ 'DescribedSecurityPolicy$SshCiphers' => '<p>Specifies the enabled Secure Shell (SSH) cipher encryption algorithms in the security policy that is attached to the server.</p>', 'DescribedSecurityPolicy$SshKexs' => '<p>Specifies the enabled SSH key exchange (KEX) encryption algorithms in the security policy that is attached to the server.</p>', 'DescribedSecurityPolicy$SshMacs' => '<p>Specifies the enabled SSH message authentication code (MAC) encryption algorithms in the security policy that is attached to the server.</p>', 'DescribedSecurityPolicy$TlsCiphers' => '<p>Specifies the enabled Transport Layer Security (TLS) cipher encryption algorithms in the security policy that is attached to the server.</p>', ], ], 'SendWorkflowStepStateRequest' => [ 'base' => NULL, 'refs' => [], ], 'SendWorkflowStepStateResponse' => [ 'base' => NULL, 'refs' => [], ], 'ServerId' => [ 'base' => NULL, 'refs' => [ 'CreateAccessRequest$ServerId' => '<p>A system-assigned unique identifier for a server instance. This is the specific server that you added your user to.</p>', 'CreateAccessResponse$ServerId' => '<p>The ID of the server that the user is attached to.</p>', 'CreateServerResponse$ServerId' => '<p>The service-assigned ID of the server that is created.</p>', 'CreateUserRequest$ServerId' => '<p>A system-assigned unique identifier for a server instance. This is the specific server that you added your user to.</p>', 'CreateUserResponse$ServerId' => '<p>The ID of the server that the user is attached to.</p>', 'DeleteAccessRequest$ServerId' => '<p>A system-assigned unique identifier for a server that has this user assigned.</p>', 'DeleteServerRequest$ServerId' => '<p>A unique system-assigned identifier for a server instance.</p>', 'DeleteSshPublicKeyRequest$ServerId' => '<p>A system-assigned unique identifier for a file transfer protocol-enabled server instance that has the user assigned to it.</p>', 'DeleteUserRequest$ServerId' => '<p>A system-assigned unique identifier for a server instance that has the user assigned to it.</p>', 'DescribeAccessRequest$ServerId' => '<p>A system-assigned unique identifier for a server that has this access assigned.</p>', 'DescribeAccessResponse$ServerId' => '<p>A system-assigned unique identifier for a server that has this access assigned.</p>', 'DescribeServerRequest$ServerId' => '<p>A system-assigned unique identifier for a server.</p>', 'DescribeUserRequest$ServerId' => '<p>A system-assigned unique identifier for a server that has this user assigned.</p>', 'DescribeUserResponse$ServerId' => '<p>A system-assigned unique identifier for a server that has this user assigned.</p>', 'DescribedServer$ServerId' => '<p>Specifies the unique system-assigned identifier for a server that you instantiate.</p>', 'ImportSshPublicKeyRequest$ServerId' => '<p>A system-assigned unique identifier for a server.</p>', 'ImportSshPublicKeyResponse$ServerId' => '<p>A system-assigned unique identifier for a server.</p>', 'ListAccessesRequest$ServerId' => '<p>A system-assigned unique identifier for a server that has users assigned to it.</p>', 'ListAccessesResponse$ServerId' => '<p>A system-assigned unique identifier for a server that has users assigned to it.</p>', 'ListUsersRequest$ServerId' => '<p>A system-assigned unique identifier for a server that has users assigned to it.</p>', 'ListUsersResponse$ServerId' => '<p>A system-assigned unique identifier for a server that the users are assigned to.</p>', 'ListedServer$ServerId' => '<p>Specifies the unique system assigned identifier for the servers that were listed.</p>', 'StartServerRequest$ServerId' => '<p>A system-assigned unique identifier for a server that you start.</p>', 'StopServerRequest$ServerId' => '<p>A system-assigned unique identifier for a server that you stopped.</p>', 'TestIdentityProviderRequest$ServerId' => '<p>A system-assigned identifier for a specific server. That server\'s user authentication method is tested with a user name and password.</p>', 'UpdateAccessRequest$ServerId' => '<p>A system-assigned unique identifier for a server instance. This is the specific server that you added your user to.</p>', 'UpdateAccessResponse$ServerId' => '<p>The ID of the server that the user is attached to.</p>', 'UpdateServerRequest$ServerId' => '<p>A system-assigned unique identifier for a server instance that the user account is assigned to.</p>', 'UpdateServerResponse$ServerId' => '<p>A system-assigned unique identifier for a server that the user account is assigned to.</p>', 'UpdateUserRequest$ServerId' => '<p>A system-assigned unique identifier for a server instance that the user account is assigned to.</p>', 'UpdateUserResponse$ServerId' => '<p>A system-assigned unique identifier for a server instance that the user account is assigned to.</p>', 'UserDetails$ServerId' => '<p>The system-assigned unique identifier for a Transfer server instance. </p>', ], ], 'ServiceErrorMessage' => [ 'base' => NULL, 'refs' => [ 'AccessDeniedException$Message' => NULL, 'ServiceUnavailableException$Message' => NULL, ], ], 'ServiceMetadata' => [ 'base' => '<p>A container object for the session details associated with a workflow.</p>', 'refs' => [ 'DescribedExecution$ServiceMetadata' => '<p>A container object for the session details associated with a workflow.</p>', 'ListedExecution$ServiceMetadata' => '<p>A container object for the session details associated with a workflow.</p>', ], ], 'ServiceUnavailableException' => [ 'base' => '<p>The request has failed because the Amazon Web ServicesTransfer Family service is not available.</p>', 'refs' => [], ], 'SessionId' => [ 'base' => NULL, 'refs' => [ 'UserDetails$SessionId' => '<p>The system-assigned unique identifier for a session that corresponds to the workflow.</p>', ], ], 'SourceIp' => [ 'base' => NULL, 'refs' => [ 'TestIdentityProviderRequest$SourceIp' => '<p>The source IP address of the user account to be tested.</p>', ], ], 'SshPublicKey' => [ 'base' => '<p>Provides information about the public Secure Shell (SSH) key that is associated with a user account for the specific file transfer protocol-enabled server (as identified by <code>ServerId</code>). The information returned includes the date the key was imported, the public key contents, and the public key ID. A user can store more than one SSH public key associated with their user name on a specific server.</p>', 'refs' => [ 'SshPublicKeys$member' => NULL, ], ], 'SshPublicKeyBody' => [ 'base' => NULL, 'refs' => [ 'CreateUserRequest$SshPublicKeyBody' => '<p>The public portion of the Secure Shell (SSH) key used to authenticate the user to the server.</p>', 'ImportSshPublicKeyRequest$SshPublicKeyBody' => '<p>The public key portion of an SSH key pair.</p>', 'SshPublicKey$SshPublicKeyBody' => '<p>Specifies the content of the SSH public key as specified by the <code>PublicKeyId</code>.</p>', ], ], 'SshPublicKeyCount' => [ 'base' => NULL, 'refs' => [ 'ListedUser$SshPublicKeyCount' => '<p>Specifies the number of SSH public keys stored for the user you specified.</p>', ], ], 'SshPublicKeyId' => [ 'base' => NULL, 'refs' => [ 'DeleteSshPublicKeyRequest$SshPublicKeyId' => '<p>A unique identifier used to reference your user\'s specific SSH key.</p>', 'ImportSshPublicKeyResponse$SshPublicKeyId' => '<p>The name given to a public key by the system that was imported.</p>', 'SshPublicKey$SshPublicKeyId' => '<p>Specifies the <code>SshPublicKeyId</code> parameter contains the identifier of the public key.</p>', ], ], 'SshPublicKeys' => [ 'base' => NULL, 'refs' => [ 'DescribedUser$SshPublicKeys' => '<p>Specifies the public key portion of the Secure Shell (SSH) keys stored for the described user.</p>', ], ], 'StartServerRequest' => [ 'base' => NULL, 'refs' => [], ], 'State' => [ 'base' => '<p>Describes the condition of a file transfer protocol-enabled server with respect to its ability to perform file operations. There are six possible states: <code>OFFLINE</code>, <code>ONLINE</code>, <code>STARTING</code>, <code>STOPPING</code>, <code>START_FAILED</code>, and <code>STOP_FAILED</code>.</p> <p> <code>OFFLINE</code> indicates that the server exists, but that it is not available for file operations. <code>ONLINE</code> indicates that the server is available to perform file operations. <code>STARTING</code> indicates that the server\'s was instantiated, but the server is not yet available to perform file operations. Under normal conditions, it can take a couple of minutes for the server to be completely operational. Both <code>START_FAILED</code> and <code>STOP_FAILED</code> are error conditions.</p>', 'refs' => [ 'DescribedServer$State' => '<p>Specifies the condition of a server for the server that was described. A value of <code>ONLINE</code> indicates that the server can accept jobs and transfer files. A <code>State</code> value of <code>OFFLINE</code> means that the server cannot perform file transfer operations.</p> <p>The states of <code>STARTING</code> and <code>STOPPING</code> indicate that the server is in an intermediate state, either not fully able to respond, or not fully offline. The values of <code>START_FAILED</code> or <code>STOP_FAILED</code> can indicate an error condition.</p>', 'ListedServer$State' => '<p>Specifies the condition of a server for the server that was described. A value of <code>ONLINE</code> indicates that the server can accept jobs and transfer files. A <code>State</code> value of <code>OFFLINE</code> means that the server cannot perform file transfer operations.</p> <p>The states of <code>STARTING</code> and <code>STOPPING</code> indicate that the server is in an intermediate state, either not fully able to respond, or not fully offline. The values of <code>START_FAILED</code> or <code>STOP_FAILED</code> can indicate an error condition.</p>', ], ], 'StatusCode' => [ 'base' => NULL, 'refs' => [ 'TestIdentityProviderResponse$StatusCode' => '<p>The HTTP status code that is the response from your API Gateway.</p>', ], ], 'StepResultOutputsJson' => [ 'base' => NULL, 'refs' => [ 'ExecutionStepResult$Outputs' => '<p>The values for the key/value pair applied as a tag to the file. Only applicable if the step type is <code>TAG</code>.</p>', ], ], 'StopServerRequest' => [ 'base' => NULL, 'refs' => [], ], 'SubnetId' => [ 'base' => NULL, 'refs' => [ 'SubnetIds$member' => NULL, ], ], 'SubnetIds' => [ 'base' => NULL, 'refs' => [ 'EndpointDetails$SubnetIds' => '<p>A list of subnet IDs that are required to host your server endpoint in your VPC.</p> <note> <p>This property can only be set when <code>EndpointType</code> is set to <code>VPC</code>.</p> </note>', ], ], 'Tag' => [ 'base' => '<p>Creates a key-value pair for a specific resource. Tags are metadata that you can use to search for and group a resource for various purposes. You can apply tags to servers, users, and roles. A tag key can take more than one value. For example, to group servers for accounting purposes, you might create a tag called <code>Group</code> and assign the values <code>Research</code> and <code>Accounting</code> to that group.</p>', 'refs' => [ 'Tags$member' => NULL, ], ], 'TagKey' => [ 'base' => NULL, 'refs' => [ 'Tag$Key' => '<p>The name assigned to the tag that you create.</p>', 'TagKeys$member' => NULL, ], ], 'TagKeys' => [ 'base' => NULL, 'refs' => [ 'UntagResourceRequest$TagKeys' => '<p>TagKeys are key-value pairs assigned to ARNs that can be used to group and search for resources by type. This metadata can be attached to resources for any purpose.</p>', ], ], 'TagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'TagStepDetails' => [ 'base' => '<p>Each step type has its own <code>StepDetails</code> structure.</p> <p>The key/value pairs used to tag a file during the execution of a workflow step.</p>', 'refs' => [ 'WorkflowStep$TagStepDetails' => '<p>Details for a step that creates one or more tags.</p> <p>You specify one or more tags: each tag contains a key/value pair.</p>', ], ], 'TagValue' => [ 'base' => NULL, 'refs' => [ 'Tag$Value' => '<p>Contains one or more values that you assigned to the key name you create.</p>', ], ], 'Tags' => [ 'base' => NULL, 'refs' => [ 'CreateServerRequest$Tags' => '<p>Key-value pairs that can be used to group and search for servers.</p>', 'CreateUserRequest$Tags' => '<p>Key-value pairs that can be used to group and search for users. Tags are metadata attached to users for any purpose.</p>', 'CreateWorkflowRequest$Tags' => '<p>Key-value pairs that can be used to group and search for workflows. Tags are metadata attached to workflows for any purpose.</p>', 'DescribedServer$Tags' => '<p>Specifies the key-value pairs that you can use to search for and group servers that were assigned to the server that was described.</p>', 'DescribedUser$Tags' => '<p>Specifies the key-value pairs for the user requested. Tag can be used to search for and group users for a variety of purposes.</p>', 'DescribedWorkflow$Tags' => '<p>Key-value pairs that can be used to group and search for workflows. Tags are metadata attached to workflows for any purpose.</p>', 'ListTagsForResourceResponse$Tags' => '<p>Key-value pairs that are assigned to a resource, usually for the purpose of grouping and searching for items. Tags are metadata that you define.</p>', 'TagResourceRequest$Tags' => '<p>Key-value pairs assigned to ARNs that you can use to group and search for resources by type. You can attach this metadata to user accounts for any purpose.</p>', ], ], 'TestIdentityProviderRequest' => [ 'base' => NULL, 'refs' => [], ], 'TestIdentityProviderResponse' => [ 'base' => NULL, 'refs' => [], ], 'ThrottlingException' => [ 'base' => '<p>The request was denied due to request throttling.</p> <p> HTTP Status Code: 400</p>', 'refs' => [], ], 'UntagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateAccessRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateAccessResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateServerRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateServerResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateUserRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateUserResponse' => [ 'base' => '<p> <code>UpdateUserResponse</code> returns the user name and identifier for the request to update a user\'s properties.</p>', 'refs' => [], ], 'Url' => [ 'base' => NULL, 'refs' => [ 'IdentityProviderDetails$Url' => '<p>Provides the location of the service endpoint used to authenticate users.</p>', 'TestIdentityProviderResponse$Url' => '<p>The endpoint of the service used to authenticate a user.</p>', ], ], 'UserCount' => [ 'base' => NULL, 'refs' => [ 'DescribedServer$UserCount' => '<p>Specifies the number of users that are assigned to a server you specified with the <code>ServerId</code>.</p>', 'ListedServer$UserCount' => '<p>Specifies the number of users that are assigned to a server you specified with the <code>ServerId</code>.</p>', ], ], 'UserDetails' => [ 'base' => '<p>Specifies the user name, server ID, and session ID for a workflow.</p>', 'refs' => [ 'ServiceMetadata$UserDetails' => '<p>The Server ID (<code>ServerId</code>), Session ID (<code>SessionId</code>) and user (<code>UserName</code>) make up the <code>UserDetails</code>.</p>', ], ], 'UserName' => [ 'base' => NULL, 'refs' => [ 'CreateUserRequest$UserName' => '<p>A unique string that identifies a user and is associated with a <code>ServerId</code>. This user name must be a minimum of 3 and a maximum of 100 characters long. The following are valid characters: a-z, A-Z, 0-9, underscore \'_\', hyphen \'-\', period \'.\', and at sign \'@\'. The user name can\'t start with a hyphen, period, or at sign.</p>', 'CreateUserResponse$UserName' => '<p>A unique string that identifies a user account associated with a server.</p>', 'DeleteSshPublicKeyRequest$UserName' => '<p>A unique string that identifies a user whose public key is being deleted.</p>', 'DeleteUserRequest$UserName' => '<p>A unique string that identifies a user that is being deleted from a server.</p>', 'DescribeUserRequest$UserName' => '<p>The name of the user assigned to one or more servers. User names are part of the sign-in credentials to use the Amazon Web Services Transfer Family service and perform file transfer tasks.</p>', 'DescribedUser$UserName' => '<p>Specifies the name of the user that was requested to be described. User names are used for authentication purposes. This is the string that will be used by your user when they log in to your server.</p>', 'ImportSshPublicKeyRequest$UserName' => '<p>The name of the user account that is assigned to one or more servers.</p>', 'ImportSshPublicKeyResponse$UserName' => '<p>A user name assigned to the <code>ServerID</code> value that you specified.</p>', 'ListedUser$UserName' => '<p>Specifies the name of the user whose ARN was specified. User names are used for authentication purposes.</p>', 'TestIdentityProviderRequest$UserName' => '<p>The name of the user account to be tested.</p>', 'UpdateUserRequest$UserName' => '<p>A unique string that identifies a user and is associated with a server as specified by the <code>ServerId</code>. This user name must be a minimum of 3 and a maximum of 100 characters long. The following are valid characters: a-z, A-Z, 0-9, underscore \'_\', hyphen \'-\', period \'.\', and at sign \'@\'. The user name can\'t start with a hyphen, period, or at sign.</p>', 'UpdateUserResponse$UserName' => '<p>The unique identifier for a user that is assigned to a server instance that was specified in the request.</p>', 'UserDetails$UserName' => '<p>A unique string that identifies a user account associated with a server.</p>', ], ], 'UserPassword' => [ 'base' => NULL, 'refs' => [ 'TestIdentityProviderRequest$UserPassword' => '<p>The password of the user account to be tested.</p>', ], ], 'VpcEndpointId' => [ 'base' => NULL, 'refs' => [ 'EndpointDetails$VpcEndpointId' => '<p>The ID of the VPC endpoint.</p> <note> <p>This property can only be set when <code>EndpointType</code> is set to <code>VPC_ENDPOINT</code>.</p> <p>For more information, see https://docs.aws.amazon.com/transfer/latest/userguide/create-server-in-vpc.html#deprecate-vpc-endpoint.</p> </note>', ], ], 'VpcId' => [ 'base' => NULL, 'refs' => [ 'EndpointDetails$VpcId' => '<p>The VPC ID of the VPC in which a server\'s endpoint will be hosted.</p> <note> <p>This property can only be set when <code>EndpointType</code> is set to <code>VPC</code>.</p> </note>', ], ], 'WorkflowDescription' => [ 'base' => NULL, 'refs' => [ 'CreateWorkflowRequest$Description' => '<p>A textual description for the workflow.</p>', 'DescribedWorkflow$Description' => '<p>Specifies the text description for the workflow.</p>', 'ListedWorkflow$Description' => '<p>Specifies the text description for the workflow.</p>', ], ], 'WorkflowDetail' => [ 'base' => '<p>Specifies the workflow ID for the workflow to assign and the execution role used for executing the workflow.</p>', 'refs' => [ 'OnUploadWorkflowDetails$member' => NULL, ], ], 'WorkflowDetails' => [ 'base' => '<p>Container for the <code>WorkflowDetail</code> data type. It is used by actions that trigger a workflow to begin execution.</p>', 'refs' => [ 'CreateServerRequest$WorkflowDetails' => '<p>Specifies the workflow ID for the workflow to assign and the execution role used for executing the workflow.</p>', 'DescribedServer$WorkflowDetails' => '<p>Specifies the workflow ID for the workflow to assign and the execution role used for executing the workflow.</p>', 'UpdateServerRequest$WorkflowDetails' => '<p>Specifies the workflow ID for the workflow to assign and the execution role used for executing the workflow.</p>', ], ], 'WorkflowId' => [ 'base' => NULL, 'refs' => [ 'CreateWorkflowResponse$WorkflowId' => '<p>A unique identifier for the workflow.</p>', 'DeleteWorkflowRequest$WorkflowId' => '<p>A unique identifier for the workflow.</p>', 'DescribeExecutionRequest$WorkflowId' => '<p>A unique identifier for the workflow.</p>', 'DescribeExecutionResponse$WorkflowId' => '<p>A unique identifier for the workflow.</p>', 'DescribeWorkflowRequest$WorkflowId' => '<p>A unique identifier for the workflow.</p>', 'DescribedWorkflow$WorkflowId' => '<p>A unique identifier for the workflow.</p>', 'ListExecutionsRequest$WorkflowId' => '<p>A unique identifier for the workflow.</p>', 'ListExecutionsResponse$WorkflowId' => '<p>A unique identifier for the workflow.</p>', 'ListedWorkflow$WorkflowId' => '<p>A unique identifier for the workflow.</p>', 'SendWorkflowStepStateRequest$WorkflowId' => '<p>A unique identifier for the workflow.</p>', 'WorkflowDetail$WorkflowId' => '<p>A unique identifier for the workflow.</p>', ], ], 'WorkflowStep' => [ 'base' => '<p>The basic building block of a workflow.</p>', 'refs' => [ 'WorkflowSteps$member' => NULL, ], ], 'WorkflowStepName' => [ 'base' => NULL, 'refs' => [ 'CopyStepDetails$Name' => '<p>The name of the step, used as an identifier.</p>', 'CustomStepDetails$Name' => '<p>The name of the step, used as an identifier.</p>', 'DeleteStepDetails$Name' => '<p>The name of the step, used as an identifier.</p>', 'TagStepDetails$Name' => '<p>The name of the step, used as an identifier.</p>', ], ], 'WorkflowStepType' => [ 'base' => NULL, 'refs' => [ 'ExecutionStepResult$StepType' => '<p>One of the available step types.</p> <ul> <li> <p> <i>Copy</i>: copy the file to another location</p> </li> <li> <p> <i>Custom</i>: custom step with a lambda target</p> </li> <li> <p> <i>Delete</i>: delete the file</p> </li> <li> <p> <i>Tag</i>: add a tag to the file</p> </li> </ul>', 'WorkflowStep$Type' => '<p> Currently, the following step types are supported. </p> <ul> <li> <p> <i>Copy</i>: copy the file to another location</p> </li> <li> <p> <i>Custom</i>: custom step with a lambda target</p> </li> <li> <p> <i>Delete</i>: delete the file</p> </li> <li> <p> <i>Tag</i>: add a tag to the file</p> </li> </ul>', ], ], 'WorkflowSteps' => [ 'base' => NULL, 'refs' => [ 'CreateWorkflowRequest$Steps' => '<p>Specifies the details for the steps that are in the specified workflow.</p> <p> The <code>TYPE</code> specifies which of the following actions is being taken for this step. </p> <ul> <li> <p> <i>Copy</i>: copy the file to another location</p> </li> <li> <p> <i>Custom</i>: custom step with a lambda target</p> </li> <li> <p> <i>Delete</i>: delete the file</p> </li> <li> <p> <i>Tag</i>: add a tag to the file</p> </li> </ul> <note> <p> Currently, copying and tagging are supported only on S3. </p> </note> <p> For file location, you specify either the S3 bucket and key, or the EFS filesystem ID and path. </p>', 'CreateWorkflowRequest$OnExceptionSteps' => '<p>Specifies the steps (actions) to take if errors are encountered during execution of the workflow.</p> <note> <p>For custom steps, the lambda function needs to send <code>FAILURE</code> to the call back API to kick off the exception steps. Additionally, if the lambda does not send <code>SUCCESS</code> before it times out, the exception steps are executed.</p> </note>', 'DescribedWorkflow$Steps' => '<p>Specifies the details for the steps that are in the specified workflow.</p>', 'DescribedWorkflow$OnExceptionSteps' => '<p>Specifies the steps (actions) to take if errors are encountered during execution of the workflow.</p>', ], ], ],];
