<?php
// This file was auto-generated from sdk-root/src/data/secretsmanager/2017-10-17/docs-2.json
return [ 'version' => '2.0', 'service' => '<fullname>Amazon Web Services Secrets Manager</fullname> <p>Amazon Web Services Secrets Manager provides a service to enable you to store, manage, and retrieve, secrets.</p> <p>This guide provides descriptions of the Secrets Manager API. For more information about using this service, see the <a href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/introduction.html">Amazon Web Services Secrets Manager User Guide</a>.</p> <p> <b>API Version</b> </p> <p>This version of the Secrets Manager API Reference documents the Secrets Manager API version 2017-10-17.</p> <note> <p>As an alternative to using the API, you can use one of the Amazon Web Services SDKs, which consist of libraries and sample code for various programming languages and platforms such as Java, Ruby, .NET, iOS, and Android. The SDKs provide a convenient way to create programmatic access to Amazon Web Services Secrets Manager. For example, the SDKs provide cryptographically signing requests, managing errors, and retrying requests automatically. For more information about the Amazon Web Services SDKs, including downloading and installing them, see <a href="http://aws.amazon.com/tools/">Tools for Amazon Web Services</a>.</p> </note> <p>We recommend you use the Amazon Web Services SDKs to make programmatic API calls to Secrets Manager. However, you also can use the Secrets Manager HTTP Query API to make direct calls to the Secrets Manager web service. To learn more about the Secrets Manager HTTP Query API, see <a href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/query-requests.html">Making Query Requests</a> in the <i>Amazon Web Services Secrets Manager User Guide</i>. </p> <p>Secrets Manager API supports GET and POST requests for all actions, and doesn\'t require you to use GET for some actions and POST for others. However, GET requests are subject to the limitation size of a URL. Therefore, for operations that require larger sizes, use a POST request.</p> <p> <b>Support and Feedback for Amazon Web Services Secrets Manager</b> </p> <p>We welcome your feedback. Send your comments to <a href="mailto:awssecretsmanager-feedback@amazon.com">awssecretsmanager-feedback@amazon.com</a>, or post your feedback and questions in the <a href="http://forums.aws.amazon.com/forum.jspa?forumID=296">Amazon Web Services Secrets Manager Discussion Forum</a>. For more information about the Amazon Web Services Discussion Forums, see <a href="http://forums.aws.amazon.com/help.jspa">Forums Help</a>.</p> <p> <b>How examples are presented</b> </p> <p>The JSON that Amazon Web Services Secrets Manager expects as your request parameters and the service returns as a response to HTTP query requests contain single, long strings without line breaks or white space formatting. The JSON shown in the examples displays the code formatted with both line breaks and white space to improve readability. When example input parameters can also cause long strings extending beyond the screen, you can insert line breaks to enhance readability. You should always submit the input as a single JSON text string.</p> <p> <b>Logging API Requests</b> </p> <p>Amazon Web Services Secrets Manager supports Amazon Web Services CloudTrail, a service that records Amazon Web Services API calls for your Amazon Web Services account and delivers log files to an Amazon S3 bucket. By using information that\'s collected by Amazon Web Services CloudTrail, you can determine the requests successfully made to Secrets Manager, who made the request, when it was made, and so on. For more about Amazon Web Services Secrets Manager and support for Amazon Web Services CloudTrail, see <a href="http://docs.aws.amazon.com/secretsmanager/latest/userguide/monitoring.html#monitoring_cloudtrail">Logging Amazon Web Services Secrets Manager Events with Amazon Web Services CloudTrail</a> in the <i>Amazon Web Services Secrets Manager User Guide</i>. To learn more about CloudTrail, including enabling it and find your log files, see the <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/what_is_cloud_trail_top_level.html">Amazon Web Services CloudTrail User Guide</a>.</p>', 'operations' => [ 'CancelRotateSecret' => '<p>Disables automatic scheduled rotation and cancels the rotation of a secret if currently in progress.</p> <p>To re-enable scheduled rotation, call <a>RotateSecret</a> with <code>AutomaticallyRotateAfterDays</code> set to a value greater than 0. This immediately rotates your secret and then enables the automatic schedule.</p> <note> <p>If you cancel a rotation while in progress, it can leave the <code>VersionStage</code> labels in an unexpected state. Depending on the step of the rotation in progress, you might need to remove the staging label <code>AWSPENDING</code> from the partially created version, specified by the <code>VersionId</code> response value. You should also evaluate the partially rotated new version to see if it should be deleted, which you can do by removing all staging labels from the new version <code>VersionStage</code> field.</p> </note> <p>To successfully start a rotation, the staging label <code>AWSPENDING</code> must be in one of the following states:</p> <ul> <li> <p>Not attached to any version at all</p> </li> <li> <p>Attached to the same version as the staging label <code>AWSCURRENT</code> </p> </li> </ul> <p>If the staging label <code>AWSPENDING</code> attached to a different version than the version with <code>AWSCURRENT</code> then the attempt to rotate fails.</p> <p> <b>Minimum permissions</b> </p> <p>To run this command, you must have the following permissions:</p> <ul> <li> <p>secretsmanager:CancelRotateSecret</p> </li> </ul> <p> <b>Related operations</b> </p> <ul> <li> <p>To configure rotation for a secret or to manually trigger a rotation, use <a>RotateSecret</a>.</p> </li> <li> <p>To get the rotation configuration details for a secret, use <a>DescribeSecret</a>.</p> </li> <li> <p>To list all of the currently available secrets, use <a>ListSecrets</a>.</p> </li> <li> <p>To list all of the versions currently associated with a secret, use <a>ListSecretVersionIds</a>.</p> </li> </ul>', 'CreateSecret' => '<p>Creates a new secret. A secret in Secrets Manager consists of both the protected secret data and the important information needed to manage the secret.</p> <p>Secrets Manager stores the encrypted secret data in one of a collection of "versions" associated with the secret. Each version contains a copy of the encrypted secret data. Each version is associated with one or more "staging labels" that identify where the version is in the rotation cycle. The <code>SecretVersionsToStages</code> field of the secret contains the mapping of staging labels to the active versions of the secret. Versions without a staging label are considered deprecated and not included in the list.</p> <p>You provide the secret data to be encrypted by putting text in either the <code>SecretString</code> parameter or binary data in the <code>SecretBinary</code> parameter, but not both. If you include <code>SecretString</code> or <code>SecretBinary</code> then Secrets Manager also creates an initial secret version and automatically attaches the staging label <code>AWSCURRENT</code> to the new version.</p> <note> <ul> <li> <p>If you call an operation to encrypt or decrypt the <code>SecretString</code> or <code>SecretBinary</code> for a secret in the same account as the calling user and that secret doesn\'t specify a Amazon Web Services KMS encryption key, Secrets Manager uses the account\'s default Amazon Web Services managed customer master key (CMK) with the alias <code>aws/secretsmanager</code>. If this key doesn\'t already exist in your account then Secrets Manager creates it for you automatically. All users and roles in the same Amazon Web Services account automatically have access to use the default CMK. Note that if an Secrets Manager API call results in Amazon Web Services creating the account\'s Amazon Web Services-managed CMK, it can result in a one-time significant delay in returning the result.</p> </li> <li> <p>If the secret resides in a different Amazon Web Services account from the credentials calling an API that requires encryption or decryption of the secret value then you must create and use a custom Amazon Web Services KMS CMK because you can\'t access the default CMK for the account using credentials from a different Amazon Web Services account. Store the ARN of the CMK in the secret when you create the secret or when you update it by including it in the <code>KMSKeyId</code>. If you call an API that must encrypt or decrypt <code>SecretString</code> or <code>SecretBinary</code> using credentials from a different account then the Amazon Web Services KMS key policy must grant cross-account access to that other account\'s user or role for both the kms:GenerateDataKey and kms:Decrypt operations.</p> </li> </ul> </note> <p> </p> <p> <b>Minimum permissions</b> </p> <p>To run this command, you must have the following permissions:</p> <ul> <li> <p>secretsmanager:CreateSecret</p> </li> <li> <p>kms:GenerateDataKey - needed only if you use a customer-managed Amazon Web Services KMS key to encrypt the secret. You do not need this permission to use the account default Amazon Web Services managed CMK for Secrets Manager.</p> </li> <li> <p>kms:Decrypt - needed only if you use a customer-managed Amazon Web Services KMS key to encrypt the secret. You do not need this permission to use the account default Amazon Web Services managed CMK for Secrets Manager.</p> </li> <li> <p>secretsmanager:TagResource - needed only if you include the <code>Tags</code> parameter. </p> </li> </ul> <p> <b>Related operations</b> </p> <ul> <li> <p>To delete a secret, use <a>DeleteSecret</a>.</p> </li> <li> <p>To modify an existing secret, use <a>UpdateSecret</a>.</p> </li> <li> <p>To create a new version of a secret, use <a>PutSecretValue</a>.</p> </li> <li> <p>To retrieve the encrypted secure string and secure binary values, use <a>GetSecretValue</a>.</p> </li> <li> <p>To retrieve all other details for a secret, use <a>DescribeSecret</a>. This does not include the encrypted secure string and secure binary values.</p> </li> <li> <p>To retrieve the list of secret versions associated with the current secret, use <a>DescribeSecret</a> and examine the <code>SecretVersionsToStages</code> response value.</p> </li> </ul>', 'DeleteResourcePolicy' => '<p>Deletes the resource-based permission policy attached to the secret.</p> <p> <b>Minimum permissions</b> </p> <p>To run this command, you must have the following permissions:</p> <ul> <li> <p>secretsmanager:DeleteResourcePolicy</p> </li> </ul> <p> <b>Related operations</b> </p> <ul> <li> <p>To attach a resource policy to a secret, use <a>PutResourcePolicy</a>.</p> </li> <li> <p>To retrieve the current resource-based policy attached to a secret, use <a>GetResourcePolicy</a>.</p> </li> <li> <p>To list all of the currently available secrets, use <a>ListSecrets</a>.</p> </li> </ul>', 'DeleteSecret' => '<p>Deletes an entire secret and all of the versions. You can optionally include a recovery window during which you can restore the secret. If you don\'t specify a recovery window value, the operation defaults to 30 days. Secrets Manager attaches a <code>DeletionDate</code> stamp to the secret that specifies the end of the recovery window. At the end of the recovery window, Secrets Manager deletes the secret permanently.</p> <p>At any time before recovery window ends, you can use <a>RestoreSecret</a> to remove the <code>DeletionDate</code> and cancel the deletion of the secret.</p> <p>You cannot access the encrypted secret information in any secret scheduled for deletion. If you need to access that information, you must cancel the deletion with <a>RestoreSecret</a> and then retrieve the information.</p> <note> <ul> <li> <p>There is no explicit operation to delete a version of a secret. Instead, remove all staging labels from the <code>VersionStage</code> field of a version. That marks the version as deprecated and allows Secrets Manager to delete it as needed. Versions without any staging labels do not show up in <a>ListSecretVersionIds</a> unless you specify <code>IncludeDeprecated</code>.</p> </li> <li> <p>The permanent secret deletion at the end of the waiting period is performed as a background task with low priority. There is no guarantee of a specific time after the recovery window for the actual delete operation to occur.</p> </li> </ul> </note> <p> <b>Minimum permissions</b> </p> <p>To run this command, you must have the following permissions:</p> <ul> <li> <p>secretsmanager:DeleteSecret</p> </li> </ul> <p> <b>Related operations</b> </p> <ul> <li> <p>To create a secret, use <a>CreateSecret</a>.</p> </li> <li> <p>To cancel deletion of a version of a secret before the recovery window has expired, use <a>RestoreSecret</a>.</p> </li> </ul>', 'DescribeSecret' => '<p>Retrieves the details of a secret. It does not include the encrypted fields. Secrets Manager only returns fields populated with a value in the response. </p> <p> <b>Minimum permissions</b> </p> <p>To run this command, you must have the following permissions:</p> <ul> <li> <p>secretsmanager:DescribeSecret</p> </li> </ul> <p> <b>Related operations</b> </p> <ul> <li> <p>To create a secret, use <a>CreateSecret</a>.</p> </li> <li> <p>To modify a secret, use <a>UpdateSecret</a>.</p> </li> <li> <p>To retrieve the encrypted secret information in a version of the secret, use <a>GetSecretValue</a>.</p> </li> <li> <p>To list all of the secrets in the Amazon Web Services account, use <a>ListSecrets</a>.</p> </li> </ul>', 'GetRandomPassword' => '<p>Generates a random password of the specified complexity. This operation is intended for use in the Lambda rotation function. Per best practice, we recommend that you specify the maximum length and include every character type that the system you are generating a password for can support.</p> <p> <b>Minimum permissions</b> </p> <p>To run this command, you must have the following permissions:</p> <ul> <li> <p>secretsmanager:GetRandomPassword</p> </li> </ul>', 'GetResourcePolicy' => '<p>Retrieves the JSON text of the resource-based policy document attached to the specified secret. The JSON request string input and response output displays formatted code with white space and line breaks for better readability. Submit your input as a single line JSON string.</p> <p> <b>Minimum permissions</b> </p> <p>To run this command, you must have the following permissions:</p> <ul> <li> <p>secretsmanager:GetResourcePolicy</p> </li> </ul> <p> <b>Related operations</b> </p> <ul> <li> <p>To attach a resource policy to a secret, use <a>PutResourcePolicy</a>.</p> </li> <li> <p>To delete the resource-based policy attached to a secret, use <a>DeleteResourcePolicy</a>.</p> </li> <li> <p>To list all of the currently available secrets, use <a>ListSecrets</a>.</p> </li> </ul>', 'GetSecretValue' => '<p>Retrieves the contents of the encrypted fields <code>SecretString</code> or <code>SecretBinary</code> from the specified version of a secret, whichever contains content.</p> <p> <b>Minimum permissions</b> </p> <p>To run this command, you must have the following permissions:</p> <ul> <li> <p>secretsmanager:GetSecretValue</p> </li> <li> <p>kms:Decrypt - required only if you use a customer-managed Amazon Web Services KMS key to encrypt the secret. You do not need this permission to use the account\'s default Amazon Web Services managed CMK for Secrets Manager.</p> </li> </ul> <p> <b>Related operations</b> </p> <ul> <li> <p>To create a new version of the secret with different encrypted information, use <a>PutSecretValue</a>.</p> </li> <li> <p>To retrieve the non-encrypted details for the secret, use <a>DescribeSecret</a>.</p> </li> </ul>', 'ListSecretVersionIds' => '<p>Lists all of the versions attached to the specified secret. The output does not include the <code>SecretString</code> or <code>SecretBinary</code> fields. By default, the list includes only versions that have at least one staging label in <code>VersionStage</code> attached.</p> <note> <p>Always check the <code>NextToken</code> response parameter when calling any of the <code>List*</code> operations. These operations can occasionally return an empty or shorter than expected list of results even when there more results become available. When this happens, the <code>NextToken</code> response parameter contains a value to pass to the next call to the same API to request the next part of the list.</p> </note> <p> <b>Minimum permissions</b> </p> <p>To run this command, you must have the following permissions:</p> <ul> <li> <p>secretsmanager:ListSecretVersionIds</p> </li> </ul> <p> <b>Related operations</b> </p> <ul> <li> <p>To list the secrets in an account, use <a>ListSecrets</a>.</p> </li> </ul>', 'ListSecrets' => '<p>Lists all of the secrets that are stored by Secrets Manager in the Amazon Web Services account. To list the versions currently stored for a specific secret, use <a>ListSecretVersionIds</a>. The encrypted fields <code>SecretString</code> and <code>SecretBinary</code> are not included in the output. To get that information, call the <a>GetSecretValue</a> operation.</p> <note> <p>Always check the <code>NextToken</code> response parameter when calling any of the <code>List*</code> operations. These operations can occasionally return an empty or shorter than expected list of results even when there more results become available. When this happens, the <code>NextToken</code> response parameter contains a value to pass to the next call to the same API to request the next part of the list.</p> </note> <p> <b>Minimum permissions</b> </p> <p>To run this command, you must have the following permissions:</p> <ul> <li> <p>secretsmanager:ListSecrets</p> </li> </ul> <p> <b>Related operations</b> </p> <ul> <li> <p>To list the versions attached to a secret, use <a>ListSecretVersionIds</a>.</p> </li> </ul>', 'PutResourcePolicy' => '<p>Attaches the contents of the specified resource-based permission policy to a secret. A resource-based policy is optional. Alternatively, you can use IAM identity-based policies that specify the secret\'s Amazon Resource Name (ARN) in the policy statement\'s <code>Resources</code> element. You can also use a combination of both identity-based and resource-based policies. The affected users and roles receive the permissions that are permitted by all of the relevant policies. For more information, see <a href="http://docs.aws.amazon.com/secretsmanager/latest/userguide/auth-and-access_resource-based-policies.html">Using Resource-Based Policies for Amazon Web Services Secrets Manager</a>. For the complete description of the Amazon Web Services policy syntax and grammar, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies.html">IAM JSON Policy Reference</a> in the <i>IAM User Guide</i>.</p> <p> <b>Minimum permissions</b> </p> <p>To run this command, you must have the following permissions:</p> <ul> <li> <p>secretsmanager:PutResourcePolicy</p> </li> </ul> <p> <b>Related operations</b> </p> <ul> <li> <p>To retrieve the resource policy attached to a secret, use <a>GetResourcePolicy</a>.</p> </li> <li> <p>To delete the resource-based policy attached to a secret, use <a>DeleteResourcePolicy</a>.</p> </li> <li> <p>To list all of the currently available secrets, use <a>ListSecrets</a>.</p> </li> </ul>', 'PutSecretValue' => '<p>Stores a new encrypted secret value in the specified secret. To do this, the operation creates a new version and attaches it to the secret. The version can contain a new <code>SecretString</code> value or a new <code>SecretBinary</code> value. You can also specify the staging labels that are initially attached to the new version.</p> <p>We recommend you avoid calling <code>PutSecretValue</code> at a sustained rate of more than once every 10 minutes. When you update the secret value, Secrets Manager creates a new version of the secret. Secrets Manager removes outdated versions when there are more than 100, but it does not remove versions created less than 24 hours ago. If you call <code>PutSecretValue</code> more than once every 10 minutes, you create more versions than Secrets Manager removes, and you will reach the quota for secret versions.</p> <ul> <li> <p>If this operation creates the first version for the secret then Secrets Manager automatically attaches the staging label <code>AWSCURRENT</code> to the new version.</p> </li> <li> <p>If you do not specify a value for VersionStages then Secrets Manager automatically moves the staging label <code>AWSCURRENT</code> to this new version.</p> </li> <li> <p>If this operation moves the staging label <code>AWSCURRENT</code> from another version to this version, then Secrets Manager also automatically moves the staging label <code>AWSPREVIOUS</code> to the version that <code>AWSCURRENT</code> was removed from.</p> </li> <li> <p>This operation is idempotent. If a version with a <code>VersionId</code> with the same value as the <code>ClientRequestToken</code> parameter already exists and you specify the same secret data, the operation succeeds but does nothing. However, if the secret data is different, then the operation fails because you cannot modify an existing version; you can only create new ones.</p> </li> </ul> <note> <ul> <li> <p>If you call an operation to encrypt or decrypt the <code>SecretString</code> or <code>SecretBinary</code> for a secret in the same account as the calling user and that secret doesn\'t specify a Amazon Web Services KMS encryption key, Secrets Manager uses the account\'s default Amazon Web Services managed customer master key (CMK) with the alias <code>aws/secretsmanager</code>. If this key doesn\'t already exist in your account then Secrets Manager creates it for you automatically. All users and roles in the same Amazon Web Services account automatically have access to use the default CMK. Note that if an Secrets Manager API call results in Amazon Web Services creating the account\'s Amazon Web Services-managed CMK, it can result in a one-time significant delay in returning the result.</p> </li> <li> <p>If the secret resides in a different Amazon Web Services account from the credentials calling an API that requires encryption or decryption of the secret value then you must create and use a custom Amazon Web Services KMS CMK because you can\'t access the default CMK for the account using credentials from a different Amazon Web Services account. Store the ARN of the CMK in the secret when you create the secret or when you update it by including it in the <code>KMSKeyId</code>. If you call an API that must encrypt or decrypt <code>SecretString</code> or <code>SecretBinary</code> using credentials from a different account then the Amazon Web Services KMS key policy must grant cross-account access to that other account\'s user or role for both the kms:GenerateDataKey and kms:Decrypt operations.</p> </li> </ul> </note> <p> <b>Minimum permissions</b> </p> <p>To run this command, you must have the following permissions:</p> <ul> <li> <p>secretsmanager:PutSecretValue</p> </li> <li> <p>kms:GenerateDataKey - needed only if you use a customer-managed Amazon Web Services KMS key to encrypt the secret. You do not need this permission to use the account\'s default Amazon Web Services managed CMK for Secrets Manager.</p> </li> </ul> <p> <b>Related operations</b> </p> <ul> <li> <p>To retrieve the encrypted value you store in the version of a secret, use <a>GetSecretValue</a>.</p> </li> <li> <p>To create a secret, use <a>CreateSecret</a>.</p> </li> <li> <p>To get the details for a secret, use <a>DescribeSecret</a>.</p> </li> <li> <p>To list the versions attached to a secret, use <a>ListSecretVersionIds</a>.</p> </li> </ul>', 'RemoveRegionsFromReplication' => '<p>Remove regions from replication.</p>', 'ReplicateSecretToRegions' => '<p>Converts an existing secret to a multi-Region secret and begins replication the secret to a list of new regions. </p>', 'RestoreSecret' => '<p>Cancels the scheduled deletion of a secret by removing the <code>DeletedDate</code> time stamp. This makes the secret accessible to query once again.</p> <p> <b>Minimum permissions</b> </p> <p>To run this command, you must have the following permissions:</p> <ul> <li> <p>secretsmanager:RestoreSecret</p> </li> </ul> <p> <b>Related operations</b> </p> <ul> <li> <p>To delete a secret, use <a>DeleteSecret</a>.</p> </li> </ul>', 'RotateSecret' => '<p>Configures and starts the asynchronous process of rotating this secret. If you include the configuration parameters, the operation sets those values for the secret and then immediately starts a rotation. If you do not include the configuration parameters, the operation starts a rotation with the values already stored in the secret. After the rotation completes, the protected service and its clients all use the new version of the secret. </p> <p>This required configuration information includes the ARN of an Amazon Web Services Lambda function and optionally, the time between scheduled rotations. The Lambda rotation function creates a new version of the secret and creates or updates the credentials on the protected service to match. After testing the new credentials, the function marks the new secret with the staging label <code>AWSCURRENT</code> so that your clients all immediately begin to use the new version. For more information about rotating secrets and how to configure a Lambda function to rotate the secrets for your protected service, see <a href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/rotating-secrets.html">Rotating Secrets in Amazon Web Services Secrets Manager</a> in the <i>Amazon Web Services Secrets Manager User Guide</i>.</p> <p>Secrets Manager schedules the next rotation when the previous one completes. Secrets Manager schedules the date by adding the rotation interval (number of days) to the actual date of the last rotation. The service chooses the hour within that 24-hour date window randomly. The minute is also chosen somewhat randomly, but weighted towards the top of the hour and influenced by a variety of factors that help distribute load.</p> <p>The rotation function must end with the versions of the secret in one of two states:</p> <ul> <li> <p>The <code>AWSPENDING</code> and <code>AWSCURRENT</code> staging labels are attached to the same version of the secret, or</p> </li> <li> <p>The <code>AWSPENDING</code> staging label is not attached to any version of the secret.</p> </li> </ul> <p>If the <code>AWSPENDING</code> staging label is present but not attached to the same version as <code>AWSCURRENT</code> then any later invocation of <code>RotateSecret</code> assumes that a previous rotation request is still in progress and returns an error.</p> <p> <b>Minimum permissions</b> </p> <p>To run this command, you must have the following permissions:</p> <ul> <li> <p>secretsmanager:RotateSecret</p> </li> <li> <p>lambda:InvokeFunction (on the function specified in the secret\'s metadata)</p> </li> </ul> <p> <b>Related operations</b> </p> <ul> <li> <p>To list the secrets in your account, use <a>ListSecrets</a>.</p> </li> <li> <p>To get the details for a version of a secret, use <a>DescribeSecret</a>.</p> </li> <li> <p>To create a new version of a secret, use <a>CreateSecret</a>.</p> </li> <li> <p>To attach staging labels to or remove staging labels from a version of a secret, use <a>UpdateSecretVersionStage</a>.</p> </li> </ul>', 'StopReplicationToReplica' => '<p>Removes the secret from replication and promotes the secret to a regional secret in the replica Region.</p>', 'TagResource' => '<p>Attaches one or more tags, each consisting of a key name and a value, to the specified secret. Tags are part of the secret\'s overall metadata, and are not associated with any specific version of the secret. This operation only appends tags to the existing list of tags. To remove tags, you must use <a>UntagResource</a>.</p> <p>The following basic restrictions apply to tags:</p> <ul> <li> <p>Maximum number of tags per secret—50</p> </li> <li> <p>Maximum key length—127 Unicode characters in UTF-8</p> </li> <li> <p>Maximum value length—255 Unicode characters in UTF-8</p> </li> <li> <p>Tag keys and values are case sensitive.</p> </li> <li> <p>Do not use the <code>aws:</code> prefix in your tag names or values because Amazon Web Services reserves it for Amazon Web Services use. You can\'t edit or delete tag names or values with this prefix. Tags with this prefix do not count against your tags per secret limit.</p> </li> <li> <p>If you use your tagging schema across multiple services and resources, remember other services might have restrictions on allowed characters. Generally allowed characters: letters, spaces, and numbers representable in UTF-8, plus the following special characters: + - = . _ : / @.</p> </li> </ul> <important> <p>If you use tags as part of your security strategy, then adding or removing a tag can change permissions. If successfully completing this operation would result in you losing your permissions for this secret, then the operation is blocked and returns an Access Denied error.</p> </important> <p> <b>Minimum permissions</b> </p> <p>To run this command, you must have the following permissions:</p> <ul> <li> <p>secretsmanager:TagResource</p> </li> </ul> <p> <b>Related operations</b> </p> <ul> <li> <p>To remove one or more tags from the collection attached to a secret, use <a>UntagResource</a>.</p> </li> <li> <p>To view the list of tags attached to a secret, use <a>DescribeSecret</a>.</p> </li> </ul>', 'UntagResource' => '<p>Removes one or more tags from the specified secret.</p> <p>This operation is idempotent. If a requested tag is not attached to the secret, no error is returned and the secret metadata is unchanged.</p> <important> <p>If you use tags as part of your security strategy, then removing a tag can change permissions. If successfully completing this operation would result in you losing your permissions for this secret, then the operation is blocked and returns an Access Denied error.</p> </important> <p> <b>Minimum permissions</b> </p> <p>To run this command, you must have the following permissions:</p> <ul> <li> <p>secretsmanager:UntagResource</p> </li> </ul> <p> <b>Related operations</b> </p> <ul> <li> <p>To add one or more tags to the collection attached to a secret, use <a>TagResource</a>.</p> </li> <li> <p>To view the list of tags attached to a secret, use <a>DescribeSecret</a>.</p> </li> </ul>', 'UpdateSecret' => '<p>Modifies many of the details of the specified secret. </p> <p>To change the secret value, you can also use <a>PutSecretValue</a>.</p> <p>To change the rotation configuration of a secret, use <a>RotateSecret</a> instead.</p> <p>We recommend you avoid calling <code>UpdateSecret</code> at a sustained rate of more than once every 10 minutes. When you call <code>UpdateSecret</code> to update the secret value, Secrets Manager creates a new version of the secret. Secrets Manager removes outdated versions when there are more than 100, but it does not remove versions created less than 24 hours ago. If you update the secret value more than once every 10 minutes, you create more versions than Secrets Manager removes, and you will reach the quota for secret versions.</p> <note> <p>The Secrets Manager console uses only the <code>SecretString</code> parameter and therefore limits you to encrypting and storing only a text string. To encrypt and store binary data as part of the version of a secret, you must use either the Amazon Web Services CLI or one of the Amazon Web Services SDKs.</p> </note> <ul> <li> <p>If a version with a <code>VersionId</code> with the same value as the <code>ClientRequestToken</code> parameter already exists, the operation results in an error. You cannot modify an existing version, you can only create a new version.</p> </li> <li> <p>If you include <code>SecretString</code> or <code>SecretBinary</code> to create a new secret version, Secrets Manager automatically attaches the staging label <code>AWSCURRENT</code> to the new version. </p> </li> </ul> <note> <ul> <li> <p>If you call an operation to encrypt or decrypt the <code>SecretString</code> or <code>SecretBinary</code> for a secret in the same account as the calling user and that secret doesn\'t specify a Amazon Web Services KMS encryption key, Secrets Manager uses the account\'s default Amazon Web Services managed customer master key (CMK) with the alias <code>aws/secretsmanager</code>. If this key doesn\'t already exist in your account then Secrets Manager creates it for you automatically. All users and roles in the same Amazon Web Services account automatically have access to use the default CMK. Note that if an Secrets Manager API call results in Amazon Web Services creating the account\'s Amazon Web Services-managed CMK, it can result in a one-time significant delay in returning the result.</p> </li> <li> <p>If the secret resides in a different Amazon Web Services account from the credentials calling an API that requires encryption or decryption of the secret value then you must create and use a custom Amazon Web Services KMS CMK because you can\'t access the default CMK for the account using credentials from a different Amazon Web Services account. Store the ARN of the CMK in the secret when you create the secret or when you update it by including it in the <code>KMSKeyId</code>. If you call an API that must encrypt or decrypt <code>SecretString</code> or <code>SecretBinary</code> using credentials from a different account then the Amazon Web Services KMS key policy must grant cross-account access to that other account\'s user or role for both the kms:GenerateDataKey and kms:Decrypt operations.</p> </li> </ul> </note> <p> <b>Minimum permissions</b> </p> <p>To run this command, you must have the following permissions:</p> <ul> <li> <p>secretsmanager:UpdateSecret</p> </li> <li> <p>kms:GenerateDataKey - needed only if you use a custom Amazon Web Services KMS key to encrypt the secret. You do not need this permission to use the account\'s Amazon Web Services managed CMK for Secrets Manager.</p> </li> <li> <p>kms:Decrypt - needed only if you use a custom Amazon Web Services KMS key to encrypt the secret. You do not need this permission to use the account\'s Amazon Web Services managed CMK for Secrets Manager.</p> </li> </ul> <p> <b>Related operations</b> </p> <ul> <li> <p>To create a new secret, use <a>CreateSecret</a>.</p> </li> <li> <p>To add only a new version to an existing secret, use <a>PutSecretValue</a>.</p> </li> <li> <p>To get the details for a secret, use <a>DescribeSecret</a>.</p> </li> <li> <p>To list the versions contained in a secret, use <a>ListSecretVersionIds</a>.</p> </li> </ul>', 'UpdateSecretVersionStage' => '<p>Modifies the staging labels attached to a version of a secret. Staging labels are used to track a version as it progresses through the secret rotation process. You can attach a staging label to only one version of a secret at a time. If a staging label to be added is already attached to another version, then it is moved--removed from the other version first and then attached to this one. For more information about staging labels, see <a href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/terms-concepts.html#term_staging-label">Staging Labels</a> in the <i>Amazon Web Services Secrets Manager User Guide</i>. </p> <p>The staging labels that you specify in the <code>VersionStage</code> parameter are added to the existing list of staging labels--they don\'t replace it.</p> <p>You can move the <code>AWSCURRENT</code> staging label to this version by including it in this call.</p> <note> <p>Whenever you move <code>AWSCURRENT</code>, Secrets Manager automatically moves the label <code>AWSPREVIOUS</code> to the version that <code>AWSCURRENT</code> was removed from.</p> </note> <p>If this action results in the last label being removed from a version, then the version is considered to be \'deprecated\' and can be deleted by Secrets Manager.</p> <p> <b>Minimum permissions</b> </p> <p>To run this command, you must have the following permissions:</p> <ul> <li> <p>secretsmanager:UpdateSecretVersionStage</p> </li> </ul> <p> <b>Related operations</b> </p> <ul> <li> <p>To get the list of staging labels that are currently associated with a version of a secret, use <code> <a>DescribeSecret</a> </code> and examine the <code>SecretVersionsToStages</code> response value. </p> </li> </ul>', 'ValidateResourcePolicy' => '<p>Validates that the resource policy does not grant a wide range of IAM principals access to your secret. The JSON request string input and response output displays formatted code with white space and line breaks for better readability. Submit your input as a single line JSON string. A resource-based policy is optional for secrets.</p> <p>The API performs three checks when validating the secret:</p> <ul> <li> <p>Sends a call to <a href="https://aws.amazon.com/blogs/security/protect-sensitive-data-in-the-cloud-with-automated-reasoning-zelkova/">Zelkova</a>, an automated reasoning engine, to ensure your Resource Policy does not allow broad access to your secret.</p> </li> <li> <p>Checks for correct syntax in a policy.</p> </li> <li> <p>Verifies the policy does not lock out a caller.</p> </li> </ul> <p> <b>Minimum Permissions</b> </p> <p>You must have the permissions required to access the following APIs:</p> <ul> <li> <p> <code>secretsmanager:PutResourcePolicy</code> </p> </li> <li> <p> <code>secretsmanager:ValidateResourcePolicy</code> </p> </li> </ul>', ], 'shapes' => [ 'AddReplicaRegionListType' => [ 'base' => NULL, 'refs' => [ 'CreateSecretRequest$AddReplicaRegions' => '<p>(Optional) Add a list of regions to replicate secrets. Secrets Manager replicates the KMSKeyID objects to the list of regions specified in the parameter.</p>', 'ReplicateSecretToRegionsRequest$AddReplicaRegions' => '<p>Add Regions to replicate the secret.</p>', ], ], 'AutomaticallyRotateAfterDaysType' => [ 'base' => NULL, 'refs' => [ 'RotationRulesType$AutomaticallyAfterDays' => '<p>Specifies the number of days between automatic scheduled rotations of the secret.</p> <p>Secrets Manager schedules the next rotation when the previous one is complete. Secrets Manager schedules the date by adding the rotation interval (number of days) to the actual date of the last rotation. The service chooses the hour within that 24-hour date window randomly. The minute is also chosen somewhat randomly, but weighted towards the top of the hour and influenced by a variety of factors that help distribute load.</p>', ], ], 'BooleanType' => [ 'base' => NULL, 'refs' => [ 'CreateSecretRequest$ForceOverwriteReplicaSecret' => '<p>(Optional) If set, the replication overwrites a secret with the same name in the destination region.</p>', 'DeleteSecretRequest$ForceDeleteWithoutRecovery' => '<p>(Optional) Specifies that the secret is to be deleted without any recovery window. You can\'t use both this parameter and the <code>RecoveryWindowInDays</code> parameter in the same API call.</p> <p>An asynchronous background process performs the actual deletion, so there can be a short delay before the operation completes. If you write code to delete and then immediately recreate a secret with the same name, ensure that your code includes appropriate back off and retry logic.</p> <important> <p>Use this parameter with caution. This parameter causes the operation to skip the normal waiting period before the permanent deletion that Amazon Web Services would normally impose with the <code>RecoveryWindowInDays</code> parameter. If you delete a secret with the <code>ForceDeleteWithouRecovery</code> parameter, then you have no opportunity to recover the secret. You lose the secret permanently.</p> </important> <important> <p>If you use this parameter and include a previously deleted or nonexistent secret, the operation does not return the error <code>ResourceNotFoundException</code> in order to correctly handle retries.</p> </important>', 'ListSecretVersionIdsRequest$IncludeDeprecated' => '<p>(Optional) Specifies that you want the results to include versions that do not have any staging labels attached to them. Such versions are considered deprecated and are subject to deletion by Secrets Manager as needed.</p>', 'PutResourcePolicyRequest$BlockPublicPolicy' => '<p>(Optional) If you set the parameter, <code>BlockPublicPolicy</code> to true, then you block resource-based policies that allow broad access to the secret.</p>', 'ReplicateSecretToRegionsRequest$ForceOverwriteReplicaSecret' => '<p>(Optional) If set, Secrets Manager replication overwrites a secret with the same name in the destination region.</p>', 'ValidateResourcePolicyResponse$PolicyValidationPassed' => '<p>Returns a message stating that your Reource Policy passed validation. </p>', ], ], 'CancelRotateSecretRequest' => [ 'base' => NULL, 'refs' => [], ], 'CancelRotateSecretResponse' => [ 'base' => NULL, 'refs' => [], ], 'ClientRequestTokenType' => [ 'base' => NULL, 'refs' => [ 'CreateSecretRequest$ClientRequestToken' => '<p>(Optional) If you include <code>SecretString</code> or <code>SecretBinary</code>, then an initial version is created as part of the secret, and this parameter specifies a unique identifier for the new version. </p> <note> <p>If you use the Amazon Web Services CLI or one of the Amazon Web Services SDK to call this operation, then you can leave this parameter empty. The CLI or SDK generates a random UUID for you and includes it as the value for this parameter in the request. If you don\'t use the SDK and instead generate a raw HTTP request to the Secrets Manager service endpoint, then you must generate a <code>ClientRequestToken</code> yourself for the new version and include the value in the request.</p> </note> <p>This value helps ensure idempotency. Secrets Manager uses this value to prevent the accidental creation of duplicate versions if there are failures and retries during a rotation. We recommend that you generate a <a href="https://wikipedia.org/wiki/Universally_unique_identifier">UUID-type</a> value to ensure uniqueness of your versions within the specified secret. </p> <ul> <li> <p>If the <code>ClientRequestToken</code> value isn\'t already associated with a version of the secret then a new version of the secret is created. </p> </li> <li> <p>If a version with this value already exists and the version <code>SecretString</code> and <code>SecretBinary</code> values are the same as those in the request, then the request is ignored.</p> </li> <li> <p>If a version with this value already exists and that version\'s <code>SecretString</code> and <code>SecretBinary</code> values are different from those in the request, then the request fails because you cannot modify an existing version. Instead, use <a>PutSecretValue</a> to create a new version.</p> </li> </ul> <p>This value becomes the <code>VersionId</code> of the new version.</p>', 'PutSecretValueRequest$ClientRequestToken' => '<p>(Optional) Specifies a unique identifier for the new version of the secret. </p> <note> <p>If you use the Amazon Web Services CLI or one of the Amazon Web Services SDK to call this operation, then you can leave this parameter empty. The CLI or SDK generates a random UUID for you and includes that in the request. If you don\'t use the SDK and instead generate a raw HTTP request to the Secrets Manager service endpoint, then you must generate a <code>ClientRequestToken</code> yourself for new versions and include that value in the request. </p> </note> <p>This value helps ensure idempotency. Secrets Manager uses this value to prevent the accidental creation of duplicate versions if there are failures and retries during the Lambda rotation function\'s processing. We recommend that you generate a <a href="https://wikipedia.org/wiki/Universally_unique_identifier">UUID-type</a> value to ensure uniqueness within the specified secret. </p> <ul> <li> <p>If the <code>ClientRequestToken</code> value isn\'t already associated with a version of the secret then a new version of the secret is created. </p> </li> <li> <p>If a version with this value already exists and that version\'s <code>SecretString</code> or <code>SecretBinary</code> values are the same as those in the request then the request is ignored (the operation is idempotent). </p> </li> <li> <p>If a version with this value already exists and the version of the <code>SecretString</code> and <code>SecretBinary</code> values are different from those in the request then the request fails because you cannot modify an existing secret version. You can only create new versions to store new secret values.</p> </li> </ul> <p>This value becomes the <code>VersionId</code> of the new version.</p>', 'RotateSecretRequest$ClientRequestToken' => '<p>(Optional) Specifies a unique identifier for the new version of the secret that helps ensure idempotency. </p> <p>If you use the Amazon Web Services CLI or one of the Amazon Web Services SDK to call this operation, then you can leave this parameter empty. The CLI or SDK generates a random UUID for you and includes that in the request for this parameter. If you don\'t use the SDK and instead generate a raw HTTP request to the Secrets Manager service endpoint, then you must generate a <code>ClientRequestToken</code> yourself for new versions and include that value in the request.</p> <p>You only need to specify your own value if you implement your own retry logic and want to ensure that a given secret is not created twice. We recommend that you generate a <a href="https://wikipedia.org/wiki/Universally_unique_identifier">UUID-type</a> value to ensure uniqueness within the specified secret. </p> <p>Secrets Manager uses this value to prevent the accidental creation of duplicate versions if there are failures and retries during the function\'s processing. This value becomes the <code>VersionId</code> of the new version.</p>', 'UpdateSecretRequest$ClientRequestToken' => '<p>(Optional) If you want to add a new version to the secret, this parameter specifies a unique identifier for the new version that helps ensure idempotency. </p> <p>If you use the Amazon Web Services CLI or one of the Amazon Web Services SDK to call this operation, then you can leave this parameter empty. The CLI or SDK generates a random UUID for you and includes that in the request. If you don\'t use the SDK and instead generate a raw HTTP request to the Secrets Manager service endpoint, then you must generate a <code>ClientRequestToken</code> yourself for new versions and include that value in the request.</p> <p>You typically only need to interact with this value if you implement your own retry logic and want to ensure that a given secret is not created twice. We recommend that you generate a <a href="https://wikipedia.org/wiki/Universally_unique_identifier">UUID-type</a> value to ensure uniqueness within the specified secret. </p> <p>Secrets Manager uses this value to prevent the accidental creation of duplicate versions if there are failures and retries during the Lambda rotation function\'s processing.</p> <ul> <li> <p>If the <code>ClientRequestToken</code> value isn\'t already associated with a version of the secret then a new version of the secret is created. </p> </li> <li> <p>If a version with this value already exists and that version\'s <code>SecretString</code> and <code>SecretBinary</code> values are the same as those in the request then the request is ignored (the operation is idempotent). </p> </li> <li> <p>If a version with this value already exists and that version\'s <code>SecretString</code> and <code>SecretBinary</code> values are different from the request then an error occurs because you cannot modify an existing secret value.</p> </li> </ul> <p>This value becomes the <code>VersionId</code> of the new version.</p>', ], ], 'CreateSecretRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateSecretResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreatedDateType' => [ 'base' => NULL, 'refs' => [ 'GetSecretValueResponse$CreatedDate' => '<p>The date and time that this version of the secret was created.</p>', 'SecretVersionsListEntry$CreatedDate' => '<p>The date and time this version of the secret was created.</p>', ], ], 'DecryptionFailure' => [ 'base' => '<p>Secrets Manager can\'t decrypt the protected secret text using the provided KMS key. </p>', 'refs' => [], ], 'DeleteResourcePolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteResourcePolicyResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteSecretRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteSecretResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeletedDateType' => [ 'base' => NULL, 'refs' => [ 'DescribeSecretResponse$DeletedDate' => '<p>This value exists if the secret is scheduled for deletion. Some time after the specified date and time, Secrets Manager deletes the secret and all of its versions.</p> <p>If a secret is scheduled for deletion, then its details, including the encrypted secret information, is not accessible. To cancel a scheduled deletion and restore access, use <a>RestoreSecret</a>.</p>', 'SecretListEntry$DeletedDate' => '<p>The date and time the deletion of the secret occurred. Not present on active secrets. The secret can be recovered until the number of days in the recovery window has passed, as specified in the <code>RecoveryWindowInDays</code> parameter of the <a>DeleteSecret</a> operation.</p>', ], ], 'DeletionDateType' => [ 'base' => NULL, 'refs' => [ 'DeleteSecretResponse$DeletionDate' => '<p>The date and time after which this secret can be deleted by Secrets Manager and can no longer be restored. This value is the date and time of the delete request plus the number of days specified in <code>RecoveryWindowInDays</code>.</p>', ], ], 'DescribeSecretRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeSecretResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescriptionType' => [ 'base' => NULL, 'refs' => [ 'CreateSecretRequest$Description' => '<p>(Optional) Specifies a user-provided description of the secret.</p>', 'DescribeSecretResponse$Description' => '<p>The user-provided description of the secret.</p>', 'SecretListEntry$Description' => '<p>The user-provided description of the secret.</p>', 'UpdateSecretRequest$Description' => '<p>(Optional) Specifies an updated user-provided description of the secret.</p>', ], ], 'EncryptionFailure' => [ 'base' => '<p>Secrets Manager can\'t encrypt the protected secret text using the provided KMS key. Check that the customer master key (CMK) is available, enabled, and not in an invalid state. For more information, see <a href="http://docs.aws.amazon.com/kms/latest/developerguide/key-state.html">How Key State Affects Use of a Customer Master Key</a>.</p>', 'refs' => [], ], 'ErrorMessage' => [ 'base' => NULL, 'refs' => [ 'DecryptionFailure$Message' => NULL, 'EncryptionFailure$Message' => NULL, 'InternalServiceError$Message' => NULL, 'InvalidNextTokenException$Message' => NULL, 'InvalidParameterException$Message' => NULL, 'InvalidRequestException$Message' => NULL, 'LimitExceededException$Message' => NULL, 'MalformedPolicyDocumentException$Message' => NULL, 'PreconditionNotMetException$Message' => NULL, 'PublicPolicyException$Message' => NULL, 'ResourceExistsException$Message' => NULL, 'ResourceNotFoundException$Message' => NULL, 'ValidationErrorsEntry$ErrorMessage' => '<p>Displays error messages if validation encounters problems during validation of the resource policy.</p>', ], ], 'ExcludeCharactersType' => [ 'base' => NULL, 'refs' => [ 'GetRandomPasswordRequest$ExcludeCharacters' => '<p>A string that includes characters that should not be included in the generated password. The default is that all characters from the included sets can be used.</p>', ], ], 'ExcludeLowercaseType' => [ 'base' => NULL, 'refs' => [ 'GetRandomPasswordRequest$ExcludeLowercase' => '<p>Specifies that the generated password should not include lowercase letters. The default if you do not include this switch parameter is that lowercase letters can be included.</p>', ], ], 'ExcludeNumbersType' => [ 'base' => NULL, 'refs' => [ 'GetRandomPasswordRequest$ExcludeNumbers' => '<p>Specifies that the generated password should not include digits. The default if you do not include this switch parameter is that digits can be included.</p>', ], ], 'ExcludePunctuationType' => [ 'base' => NULL, 'refs' => [ 'GetRandomPasswordRequest$ExcludePunctuation' => '<p>Specifies that the generated password should not include punctuation characters. The default if you do not include this switch parameter is that punctuation characters can be included.</p> <p>The following are the punctuation characters that <i>can</i> be included in the generated password if you don\'t explicitly exclude them with <code>ExcludeCharacters</code> or <code>ExcludePunctuation</code>:</p> <p> <code>! " # $ % &amp; \' ( ) * + , - . / : ; &lt; = &gt; ? @ [ \\ ] ^ _ ` { | } ~</code> </p>', ], ], 'ExcludeUppercaseType' => [ 'base' => NULL, 'refs' => [ 'GetRandomPasswordRequest$ExcludeUppercase' => '<p>Specifies that the generated password should not include uppercase letters. The default if you do not include this switch parameter is that uppercase letters can be included.</p>', ], ], 'Filter' => [ 'base' => '<p>Allows you to add filters when you use the search function in Secrets Manager.</p>', 'refs' => [ 'FiltersListType$member' => NULL, ], ], 'FilterNameStringType' => [ 'base' => NULL, 'refs' => [ 'Filter$Key' => '<p>Filters your list of secrets by a specific key.</p>', ], ], 'FilterValueStringType' => [ 'base' => NULL, 'refs' => [ 'FilterValuesStringList$member' => NULL, ], ], 'FilterValuesStringList' => [ 'base' => NULL, 'refs' => [ 'Filter$Values' => '<p>Filters your list of secrets by a specific value.</p> <p>You can prefix your search value with an exclamation mark (<code>!</code>) in order to perform negation filters. </p>', ], ], 'FiltersListType' => [ 'base' => NULL, 'refs' => [ 'ListSecretsRequest$Filters' => '<p>Lists the secret request filters.</p>', ], ], 'GetRandomPasswordRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetRandomPasswordResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetResourcePolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetResourcePolicyResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetSecretValueRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetSecretValueResponse' => [ 'base' => NULL, 'refs' => [], ], 'IncludeSpaceType' => [ 'base' => NULL, 'refs' => [ 'GetRandomPasswordRequest$IncludeSpace' => '<p>Specifies that the generated password can include the space character. The default if you do not include this switch parameter is that the space character is not included.</p>', ], ], 'InternalServiceError' => [ 'base' => '<p>An error occurred on the server side.</p>', 'refs' => [], ], 'InvalidNextTokenException' => [ 'base' => '<p>You provided an invalid <code>NextToken</code> value.</p>', 'refs' => [], ], 'InvalidParameterException' => [ 'base' => '<p>You provided an invalid value for a parameter.</p>', 'refs' => [], ], 'InvalidRequestException' => [ 'base' => '<p>You provided a parameter value that is not valid for the current state of the resource.</p> <p>Possible causes:</p> <ul> <li> <p>You tried to perform the operation on a secret that\'s currently marked deleted.</p> </li> <li> <p>You tried to enable rotation on a secret that doesn\'t already have a Lambda function ARN configured and you didn\'t include such an ARN as a parameter in this call. </p> </li> </ul>', 'refs' => [], ], 'KmsKeyIdListType' => [ 'base' => NULL, 'refs' => [ 'SecretVersionsListEntry$KmsKeyIds' => '<p>The KMS keys used to encrypt the secret version.</p>', ], ], 'KmsKeyIdType' => [ 'base' => NULL, 'refs' => [ 'CreateSecretRequest$KmsKeyId' => '<p>(Optional) Specifies the ARN, Key ID, or alias of the Amazon Web Services KMS customer master key (CMK) to be used to encrypt the <code>SecretString</code> or <code>SecretBinary</code> values in the versions stored in this secret.</p> <p>You can specify any of the supported ways to identify a Amazon Web Services KMS key ID. If you need to reference a CMK in a different account, you can use only the key ARN or the alias ARN.</p> <p>If you don\'t specify this value, then Secrets Manager defaults to using the Amazon Web Services account\'s default CMK (the one named <code>aws/secretsmanager</code>). If a Amazon Web Services KMS CMK with that name doesn\'t yet exist, then Secrets Manager creates it for you automatically the first time it needs to encrypt a version\'s <code>SecretString</code> or <code>SecretBinary</code> fields.</p> <important> <p>You can use the account default CMK to encrypt and decrypt only if you call this operation using credentials from the same account that owns the secret. If the secret resides in a different account, then you must create a custom CMK and specify the ARN in this field. </p> </important>', 'DescribeSecretResponse$KmsKeyId' => '<p>The ARN or alias of the Amazon Web Services KMS customer master key (CMK) that\'s used to encrypt the <code>SecretString</code> or <code>SecretBinary</code> fields in each version of the secret. If you don\'t provide a key, then Secrets Manager defaults to encrypting the secret fields with the default Amazon Web Services KMS CMK (the one named <code>awssecretsmanager</code>) for this account.</p>', 'KmsKeyIdListType$member' => NULL, 'ReplicaRegionType$KmsKeyId' => '<p>Can be an <code>ARN</code>, <code>Key ID</code>, or <code>Alias</code>. </p>', 'ReplicationStatusType$KmsKeyId' => '<p>Can be an <code>ARN</code>, <code>Key ID</code>, or <code>Alias</code>. </p>', 'SecretListEntry$KmsKeyId' => '<p>The ARN or alias of the Amazon Web Services KMS customer master key (CMK) used to encrypt the <code>SecretString</code> and <code>SecretBinary</code> fields in each version of the secret. If you don\'t provide a key, then Secrets Manager defaults to encrypting the secret fields with the default KMS CMK, the key named <code>awssecretsmanager</code>, for this account.</p>', 'UpdateSecretRequest$KmsKeyId' => '<p>(Optional) Specifies an updated ARN or alias of the Amazon Web Services KMS customer master key (CMK) that Secrets Manager uses to encrypt the protected text in new versions of this secret as well as any existing versions of this secret that have the staging labels AWSCURRENT, AWSPENDING, or AWSPREVIOUS. For more information about staging labels, see <a href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/terms-concepts.html#term_staging-label">Staging Labels</a> in the <i>Amazon Web Services Secrets Manager User Guide</i>.</p> <important> <p>You can only use the account\'s default CMK to encrypt and decrypt if you call this operation using credentials from the same account that owns the secret. If the secret is in a different account, then you must create a custom CMK and provide the ARN of that CMK in this field. The user making the call must have permissions to both the secret and the CMK in their respective accounts.</p> </important>', ], ], 'LastAccessedDateType' => [ 'base' => NULL, 'refs' => [ 'DescribeSecretResponse$LastAccessedDate' => '<p>The last date that this secret was accessed. This value is truncated to midnight of the date and therefore shows only the date, not the time.</p>', 'ReplicationStatusType$LastAccessedDate' => '<p>The date that you last accessed the secret in the Region. </p>', 'SecretListEntry$LastAccessedDate' => '<p>The last date that this secret was accessed. This value is truncated to midnight of the date and therefore shows only the date, not the time.</p>', 'SecretVersionsListEntry$LastAccessedDate' => '<p>The date that this version of the secret was last accessed. Note that the resolution of this field is at the date level and does not include the time.</p>', ], ], 'LastChangedDateType' => [ 'base' => NULL, 'refs' => [ 'DescribeSecretResponse$LastChangedDate' => '<p>The last date and time that this secret was modified in any way.</p>', 'SecretListEntry$LastChangedDate' => '<p>The last date and time that this secret was modified in any way.</p>', ], ], 'LastRotatedDateType' => [ 'base' => NULL, 'refs' => [ 'DescribeSecretResponse$LastRotatedDate' => '<p>The last date and time that the rotation process for this secret was invoked.</p> <p>The most recent date and time that the Secrets Manager rotation process successfully completed. If the secret doesn\'t rotate, Secrets Manager returns a null value.</p>', 'SecretListEntry$LastRotatedDate' => '<p>The most recent date and time that the Secrets Manager rotation process was successfully completed. This value is null if the secret hasn\'t ever rotated.</p>', ], ], 'LimitExceededException' => [ 'base' => '<p>The request failed because it would exceed one of the Secrets Manager internal limits.</p>', 'refs' => [], ], 'ListSecretVersionIdsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListSecretVersionIdsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListSecretsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListSecretsResponse' => [ 'base' => NULL, 'refs' => [], ], 'MalformedPolicyDocumentException' => [ 'base' => '<p>You provided a resource-based policy with syntax errors.</p>', 'refs' => [], ], 'MaxResultsType' => [ 'base' => NULL, 'refs' => [ 'ListSecretVersionIdsRequest$MaxResults' => '<p>(Optional) Limits the number of results you want to include in the response. If you don\'t include this parameter, it defaults to a value that\'s specific to the operation. If additional items exist beyond the maximum you specify, the <code>NextToken</code> response element is present and has a value (isn\'t null). Include that value as the <code>NextToken</code> request parameter in the next call to the operation to get the next part of the results. Note that Secrets Manager might return fewer results than the maximum even when there are more results available. You should check <code>NextToken</code> after every operation to ensure that you receive all of the results.</p>', 'ListSecretsRequest$MaxResults' => '<p>(Optional) Limits the number of results you want to include in the response. If you don\'t include this parameter, it defaults to a value that\'s specific to the operation. If additional items exist beyond the maximum you specify, the <code>NextToken</code> response element is present and has a value (isn\'t null). Include that value as the <code>NextToken</code> request parameter in the next call to the operation to get the next part of the results. Note that Secrets Manager might return fewer results than the maximum even when there are more results available. You should check <code>NextToken</code> after every operation to ensure that you receive all of the results.</p>', ], ], 'NameType' => [ 'base' => NULL, 'refs' => [ 'CreateSecretRequest$Name' => '<p>Specifies the friendly name of the new secret.</p> <p>The secret name must be ASCII letters, digits, or the following characters : /_+=.@-</p> <note> <p>Do not end your secret name with a hyphen followed by six characters. If you do so, you risk confusion and unexpected results when searching for a secret by partial ARN. Secrets Manager automatically adds a hyphen and six random characters at the end of the ARN.</p> </note>', 'DeleteResourcePolicyResponse$Name' => '<p>The friendly name of the secret that the resource-based policy was deleted for.</p>', 'GetResourcePolicyResponse$Name' => '<p>The friendly name of the secret that the resource-based policy was retrieved for.</p>', 'PutResourcePolicyResponse$Name' => '<p>The friendly name of the secret retrieved by the resource-based policy.</p>', 'ValidationErrorsEntry$CheckName' => '<p>Checks the name of the policy.</p>', ], ], 'NextTokenType' => [ 'base' => NULL, 'refs' => [ 'ListSecretVersionIdsRequest$NextToken' => '<p>(Optional) Use this parameter in a request if you receive a <code>NextToken</code> response in a previous request indicating there\'s more output available. In a subsequent call, set it to the value of the previous call <code>NextToken</code> response to indicate where the output should continue from.</p>', 'ListSecretVersionIdsResponse$NextToken' => '<p>If present in the response, this value indicates that there\'s more output available than included in the current response. This can occur even when the response includes no values at all, such as when you ask for a filtered view of a very long list. Use this value in the <code>NextToken</code> request parameter in a subsequent call to the operation to continue processing and get the next part of the output. You should repeat this until the <code>NextToken</code> response element comes back empty (as <code>null</code>).</p>', 'ListSecretsRequest$NextToken' => '<p>(Optional) Use this parameter in a request if you receive a <code>NextToken</code> response in a previous request indicating there\'s more output available. In a subsequent call, set it to the value of the previous call <code>NextToken</code> response to indicate where the output should continue from.</p>', 'ListSecretsResponse$NextToken' => '<p>If present in the response, this value indicates that there\'s more output available than included in the current response. This can occur even when the response includes no values at all, such as when you ask for a filtered view of a very long list. Use this value in the <code>NextToken</code> request parameter in a subsequent call to the operation to continue processing and get the next part of the output. You should repeat this until the <code>NextToken</code> response element comes back empty (as <code>null</code>).</p>', ], ], 'NonEmptyResourcePolicyType' => [ 'base' => NULL, 'refs' => [ 'GetResourcePolicyResponse$ResourcePolicy' => '<p>A JSON-formatted string that describes the permissions that are associated with the attached secret. These permissions are combined with any permissions that are associated with the user or role that attempts to access this secret. The combined permissions specify who can access the secret and what actions they can perform. For more information, see <a href="http://docs.aws.amazon.com/secretsmanager/latest/userguide/auth-and-access.html">Authentication and Access Control for Amazon Web Services Secrets Manager</a> in the <i>Amazon Web Services Secrets Manager User Guide</i>.</p>', 'PutResourcePolicyRequest$ResourcePolicy' => '<p>A JSON-formatted string constructed according to the grammar and syntax for an Amazon Web Services resource-based policy. The policy in the string identifies who can access or manage this secret and its versions. For information on how to format a JSON parameter for the various command line tool environments, see <a href="http://docs.aws.amazon.com/cli/latest/userguide/cli-using-param.html#cli-using-param-json">Using JSON for Parameters</a> in the <i>CLI User Guide</i>.</p>', 'ValidateResourcePolicyRequest$ResourcePolicy' => '<p>A JSON-formatted string constructed according to the grammar and syntax for an Amazon Web Services resource-based policy. The policy in the string identifies who can access or manage this secret and its versions. For information on how to format a JSON parameter for the various command line tool environments, see <a href="http://docs.aws.amazon.com/cli/latest/userguide/cli-using-param.html#cli-using-param-json">Using JSON for Parameters</a> in the <i>CLI User Guide</i>.publi</p>', ], ], 'OwningServiceType' => [ 'base' => NULL, 'refs' => [ 'DescribeSecretResponse$OwningService' => '<p>Returns the name of the service that created this secret.</p>', 'SecretListEntry$OwningService' => '<p>Returns the name of the service that created the secret.</p>', ], ], 'PasswordLengthType' => [ 'base' => NULL, 'refs' => [ 'GetRandomPasswordRequest$PasswordLength' => '<p>The desired length of the generated password. The default value if you do not include this parameter is 32 characters.</p>', ], ], 'PreconditionNotMetException' => [ 'base' => '<p>The request failed because you did not complete all the prerequisite steps.</p>', 'refs' => [], ], 'PublicPolicyException' => [ 'base' => '<p>The BlockPublicPolicy parameter is set to true and the resource policy did not prevent broad access to the secret.</p>', 'refs' => [], ], 'PutResourcePolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutResourcePolicyResponse' => [ 'base' => NULL, 'refs' => [], ], 'PutSecretValueRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutSecretValueResponse' => [ 'base' => NULL, 'refs' => [], ], 'RandomPasswordType' => [ 'base' => NULL, 'refs' => [ 'GetRandomPasswordResponse$RandomPassword' => '<p>A string with the generated password.</p>', ], ], 'RecoveryWindowInDaysType' => [ 'base' => NULL, 'refs' => [ 'DeleteSecretRequest$RecoveryWindowInDays' => '<p>(Optional) Specifies the number of days that Secrets Manager waits before Secrets Manager can delete the secret. You can\'t use both this parameter and the <code>ForceDeleteWithoutRecovery</code> parameter in the same API call.</p> <p>This value can range from 7 to 30 days with a default value of 30.</p>', ], ], 'RegionType' => [ 'base' => NULL, 'refs' => [ 'DescribeSecretResponse$PrimaryRegion' => '<p>Specifies the primary region for secret replication. </p>', 'RemoveReplicaRegionListType$member' => NULL, 'ReplicaRegionType$Region' => '<p>Describes a single instance of Region objects.</p>', 'ReplicationStatusType$Region' => '<p>The Region where replication occurs.</p>', 'SecretListEntry$PrimaryRegion' => '<p>The Region where Secrets Manager originated the secret.</p>', ], ], 'RemoveRegionsFromReplicationRequest' => [ 'base' => NULL, 'refs' => [], ], 'RemoveRegionsFromReplicationResponse' => [ 'base' => NULL, 'refs' => [], ], 'RemoveReplicaRegionListType' => [ 'base' => NULL, 'refs' => [ 'RemoveRegionsFromReplicationRequest$RemoveReplicaRegions' => '<p>Remove replication from specific Regions.</p>', ], ], 'ReplicaRegionType' => [ 'base' => '<p>(Optional) Custom type consisting of a <code>Region</code> (required) and the <code>KmsKeyId</code> which can be an <code>ARN</code>, <code>Key ID</code>, or <code>Alias</code>.</p>', 'refs' => [ 'AddReplicaRegionListType$member' => NULL, ], ], 'ReplicateSecretToRegionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ReplicateSecretToRegionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ReplicationStatusListType' => [ 'base' => NULL, 'refs' => [ 'CreateSecretResponse$ReplicationStatus' => '<p>Describes a list of replication status objects as <code>InProgress</code>, <code>Failed</code> or <code>InSync</code>.</p>', 'DescribeSecretResponse$ReplicationStatus' => '<p>Describes a list of replication status objects as <code>InProgress</code>, <code>Failed</code> or <code>InSync</code>.<code>P</code> </p>', 'RemoveRegionsFromReplicationResponse$ReplicationStatus' => '<p>Describes the remaining replication status after you remove regions from the replication list.</p>', 'ReplicateSecretToRegionsResponse$ReplicationStatus' => '<p>Describes the secret replication status as <code>PENDING</code>, <code>SUCCESS</code> or <code>FAIL</code>.</p>', ], ], 'ReplicationStatusType' => [ 'base' => '<p>A replication object consisting of a <code>RegionReplicationStatus</code> object and includes a Region, KMSKeyId, status, and status message.</p>', 'refs' => [ 'ReplicationStatusListType$member' => NULL, ], ], 'RequireEachIncludedTypeType' => [ 'base' => NULL, 'refs' => [ 'GetRandomPasswordRequest$RequireEachIncludedType' => '<p>A boolean value that specifies whether the generated password must include at least one of every allowed character type. The default value is <code>True</code> and the operation requires at least one of every character type.</p>', ], ], 'ResourceExistsException' => [ 'base' => '<p>A resource with the ID you requested already exists.</p>', 'refs' => [], ], 'ResourceNotFoundException' => [ 'base' => '<p>We can\'t find the resource that you asked for.</p>', 'refs' => [], ], 'RestoreSecretRequest' => [ 'base' => NULL, 'refs' => [], ], 'RestoreSecretResponse' => [ 'base' => NULL, 'refs' => [], ], 'RotateSecretRequest' => [ 'base' => NULL, 'refs' => [], ], 'RotateSecretResponse' => [ 'base' => NULL, 'refs' => [], ], 'RotationEnabledType' => [ 'base' => NULL, 'refs' => [ 'DescribeSecretResponse$RotationEnabled' => '<p>Specifies whether automatic rotation is enabled for this secret.</p> <p>To enable rotation, use <a>RotateSecret</a> with <code>AutomaticallyRotateAfterDays</code> set to a value greater than 0. To disable rotation, use <a>CancelRotateSecret</a>.</p>', 'SecretListEntry$RotationEnabled' => '<p>Indicates whether automatic, scheduled rotation is enabled for this secret.</p>', ], ], 'RotationLambdaARNType' => [ 'base' => NULL, 'refs' => [ 'DescribeSecretResponse$RotationLambdaARN' => '<p>The ARN of a Lambda function that\'s invoked by Secrets Manager to rotate the secret either automatically per the schedule or manually by a call to <code>RotateSecret</code>.</p>', 'RotateSecretRequest$RotationLambdaARN' => '<p>(Optional) Specifies the ARN of the Lambda function that can rotate the secret.</p>', 'SecretListEntry$RotationLambdaARN' => '<p>The ARN of an Amazon Web Services Lambda function invoked by Secrets Manager to rotate and expire the secret either automatically per the schedule or manually by a call to <a>RotateSecret</a>.</p>', ], ], 'RotationRulesType' => [ 'base' => '<p>A structure that defines the rotation configuration for the secret.</p>', 'refs' => [ 'DescribeSecretResponse$RotationRules' => '<p>A structure with the rotation configuration for this secret. This field is only populated if rotation is configured.</p>', 'RotateSecretRequest$RotationRules' => '<p>A structure that defines the rotation configuration for this secret.</p>', 'SecretListEntry$RotationRules' => '<p>A structure that defines the rotation configuration for the secret.</p>', ], ], 'SecretARNType' => [ 'base' => NULL, 'refs' => [ 'CancelRotateSecretResponse$ARN' => '<p>The ARN of the secret for which rotation was canceled.</p>', 'CreateSecretResponse$ARN' => '<p>The Amazon Resource Name (ARN) of the secret that you just created.</p> <note> <p>Secrets Manager automatically adds several random characters to the name at the end of the ARN when you initially create a secret. This affects only the ARN and not the actual friendly name. This ensures that if you create a new secret with the same name as an old secret that you previously deleted, then users with access to the old secret <i>don\'t</i> automatically get access to the new secret because the ARNs are different.</p> </note>', 'DeleteResourcePolicyResponse$ARN' => '<p>The ARN of the secret that the resource-based policy was deleted for.</p>', 'DeleteSecretResponse$ARN' => '<p>The ARN of the secret that is now scheduled for deletion.</p>', 'DescribeSecretResponse$ARN' => '<p>The ARN of the secret.</p>', 'GetResourcePolicyResponse$ARN' => '<p>The ARN of the secret that the resource-based policy was retrieved for.</p>', 'GetSecretValueResponse$ARN' => '<p>The ARN of the secret.</p>', 'ListSecretVersionIdsResponse$ARN' => '<p>The Amazon Resource Name (ARN) for the secret.</p> <note> <p>Secrets Manager automatically adds several random characters to the name at the end of the ARN when you initially create a secret. This affects only the ARN and not the actual friendly name. This ensures that if you create a new secret with the same name as an old secret that you previously deleted, then users with access to the old secret <i>don\'t</i> automatically get access to the new secret because the ARNs are different.</p> </note>', 'PutResourcePolicyResponse$ARN' => '<p>The ARN of the secret retrieved by the resource-based policy.</p>', 'PutSecretValueResponse$ARN' => '<p>The Amazon Resource Name (ARN) for the secret for which you just created a version.</p>', 'RemoveRegionsFromReplicationResponse$ARN' => '<p>The secret <code>ARN</code> removed from replication regions.</p>', 'ReplicateSecretToRegionsResponse$ARN' => '<p>Replicate a secret based on the <code>ReplicaRegionType</code>&gt; consisting of a Region(required) and a KMSKeyId (optional) which can be the ARN, KeyID, or Alias. </p>', 'RestoreSecretResponse$ARN' => '<p>The ARN of the secret that was restored.</p>', 'RotateSecretResponse$ARN' => '<p>The ARN of the secret.</p>', 'SecretListEntry$ARN' => '<p>The Amazon Resource Name (ARN) of the secret.</p> <p>For more information about ARNs in Secrets Manager, see <a href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/reference_iam-permissions.html#iam-resources">Policy Resources</a> in the <i>Amazon Web Services Secrets Manager User Guide</i>.</p>', 'StopReplicationToReplicaResponse$ARN' => '<p>Response <code>StopReplicationToReplica</code> of a secret, based on the <code>ARN,</code>.</p>', 'UpdateSecretResponse$ARN' => '<p>The ARN of the secret that was updated.</p> <note> <p>Secrets Manager automatically adds several random characters to the name at the end of the ARN when you initially create a secret. This affects only the ARN and not the actual friendly name. This ensures that if you create a new secret with the same name as an old secret that you previously deleted, then users with access to the old secret <i>don\'t</i> automatically get access to the new secret because the ARNs are different.</p> </note>', 'UpdateSecretVersionStageResponse$ARN' => '<p>The ARN of the secret with the modified staging label.</p>', ], ], 'SecretBinaryType' => [ 'base' => NULL, 'refs' => [ 'CreateSecretRequest$SecretBinary' => '<p>(Optional) Specifies binary data that you want to encrypt and store in the new version of the secret. To use this parameter in the command-line tools, we recommend that you store your binary data in a file and then use the appropriate technique for your tool to pass the contents of the file as a parameter.</p> <p>Either <code>SecretString</code> or <code>SecretBinary</code> must have a value, but not both. They cannot both be empty.</p> <p>This parameter is not available using the Secrets Manager console. It can be accessed only by using the Amazon Web Services CLI or one of the Amazon Web Services SDKs.</p>', 'GetSecretValueResponse$SecretBinary' => '<p>The decrypted part of the protected secret information that was originally provided as binary data in the form of a byte array. The response parameter represents the binary data as a <a href="https://tools.ietf.org/html/rfc4648#section-4">base64-encoded</a> string.</p> <p>This parameter is not used if the secret is created by the Secrets Manager console.</p> <p>If you store custom information in this field of the secret, then you must code your Lambda rotation function to parse and interpret whatever you store in the <code>SecretString</code> or <code>SecretBinary</code> fields.</p>', 'PutSecretValueRequest$SecretBinary' => '<p>(Optional) Specifies binary data that you want to encrypt and store in the new version of the secret. To use this parameter in the command-line tools, we recommend that you store your binary data in a file and then use the appropriate technique for your tool to pass the contents of the file as a parameter. Either <code>SecretBinary</code> or <code>SecretString</code> must have a value, but not both. They cannot both be empty.</p> <p>This parameter is not accessible if the secret using the Secrets Manager console.</p> <p/>', 'UpdateSecretRequest$SecretBinary' => '<p>(Optional) Specifies updated binary data that you want to encrypt and store in the new version of the secret. To use this parameter in the command-line tools, we recommend that you store your binary data in a file and then use the appropriate technique for your tool to pass the contents of the file as a parameter. Either <code>SecretBinary</code> or <code>SecretString</code> must have a value, but not both. They cannot both be empty.</p> <p>This parameter is not accessible using the Secrets Manager console.</p>', ], ], 'SecretIdType' => [ 'base' => NULL, 'refs' => [ 'CancelRotateSecretRequest$SecretId' => '<p>Specifies the secret to cancel a rotation request. You can specify either the Amazon Resource Name (ARN) or the friendly name of the secret.</p> <p>For an ARN, we recommend that you specify a complete ARN rather than a partial ARN.</p>', 'DeleteResourcePolicyRequest$SecretId' => '<p>Specifies the secret that you want to delete the attached resource-based policy for. You can specify either the Amazon Resource Name (ARN) or the friendly name of the secret.</p> <p>For an ARN, we recommend that you specify a complete ARN rather than a partial ARN.</p>', 'DeleteSecretRequest$SecretId' => '<p>Specifies the secret to delete. You can specify either the Amazon Resource Name (ARN) or the friendly name of the secret.</p> <p>For an ARN, we recommend that you specify a complete ARN rather than a partial ARN.</p>', 'DescribeSecretRequest$SecretId' => '<p>The identifier of the secret whose details you want to retrieve. You can specify either the Amazon Resource Name (ARN) or the friendly name of the secret.</p> <p>For an ARN, we recommend that you specify a complete ARN rather than a partial ARN.</p>', 'GetResourcePolicyRequest$SecretId' => '<p>Specifies the secret that you want to retrieve the attached resource-based policy for. You can specify either the Amazon Resource Name (ARN) or the friendly name of the secret.</p> <p>For an ARN, we recommend that you specify a complete ARN rather than a partial ARN.</p>', 'GetSecretValueRequest$SecretId' => '<p>Specifies the secret containing the version that you want to retrieve. You can specify either the Amazon Resource Name (ARN) or the friendly name of the secret.</p> <p>For an ARN, we recommend that you specify a complete ARN rather than a partial ARN.</p>', 'ListSecretVersionIdsRequest$SecretId' => '<p>The identifier for the secret containing the versions you want to list. You can specify either the Amazon Resource Name (ARN) or the friendly name of the secret.</p> <p>For an ARN, we recommend that you specify a complete ARN rather than a partial ARN.</p>', 'PutResourcePolicyRequest$SecretId' => '<p>Specifies the secret that you want to attach the resource-based policy. You can specify either the ARN or the friendly name of the secret.</p> <p>For an ARN, we recommend that you specify a complete ARN rather than a partial ARN.</p>', 'PutSecretValueRequest$SecretId' => '<p>Specifies the secret to which you want to add a new version. You can specify either the Amazon Resource Name (ARN) or the friendly name of the secret. The secret must already exist.</p> <p>For an ARN, we recommend that you specify a complete ARN rather than a partial ARN.</p>', 'RemoveRegionsFromReplicationRequest$SecretId' => '<p>Remove a secret by <code>SecretId</code> from replica Regions.</p>', 'ReplicateSecretToRegionsRequest$SecretId' => '<p>Use the <code>Secret Id</code> to replicate a secret to regions.</p>', 'RestoreSecretRequest$SecretId' => '<p>Specifies the secret that you want to restore from a previously scheduled deletion. You can specify either the Amazon Resource Name (ARN) or the friendly name of the secret.</p> <p>For an ARN, we recommend that you specify a complete ARN rather than a partial ARN.</p>', 'RotateSecretRequest$SecretId' => '<p>Specifies the secret that you want to rotate. You can specify either the Amazon Resource Name (ARN) or the friendly name of the secret.</p> <p>For an ARN, we recommend that you specify a complete ARN rather than a partial ARN.</p>', 'StopReplicationToReplicaRequest$SecretId' => '<p>Response to <code>StopReplicationToReplica</code> of a secret, based on the <code>SecretId</code>.</p>', 'TagResourceRequest$SecretId' => '<p>The identifier for the secret that you want to attach tags to. You can specify either the Amazon Resource Name (ARN) or the friendly name of the secret.</p> <p>For an ARN, we recommend that you specify a complete ARN rather than a partial ARN.</p>', 'UntagResourceRequest$SecretId' => '<p>The identifier for the secret that you want to remove tags from. You can specify either the Amazon Resource Name (ARN) or the friendly name of the secret.</p> <p>For an ARN, we recommend that you specify a complete ARN rather than a partial ARN.</p>', 'UpdateSecretRequest$SecretId' => '<p>Specifies the secret that you want to modify or to which you want to add a new version. You can specify either the Amazon Resource Name (ARN) or the friendly name of the secret.</p> <p>For an ARN, we recommend that you specify a complete ARN rather than a partial ARN.</p>', 'UpdateSecretVersionStageRequest$SecretId' => '<p>Specifies the secret with the version with the list of staging labels you want to modify. You can specify either the Amazon Resource Name (ARN) or the friendly name of the secret.</p> <p>For an ARN, we recommend that you specify a complete ARN rather than a partial ARN.</p>', 'ValidateResourcePolicyRequest$SecretId' => '<p> (Optional) The identifier of the secret with the resource-based policy you want to validate. You can specify either the Amazon Resource Name (ARN) or the friendly name of the secret.</p> <p>For an ARN, we recommend that you specify a complete ARN rather than a partial ARN.</p>', ], ], 'SecretListEntry' => [ 'base' => '<p>A structure that contains the details about a secret. It does not include the encrypted <code>SecretString</code> and <code>SecretBinary</code> values. To get those values, use the <a>GetSecretValue</a> operation.</p>', 'refs' => [ 'SecretListType$member' => NULL, ], ], 'SecretListType' => [ 'base' => NULL, 'refs' => [ 'ListSecretsResponse$SecretList' => '<p>A list of the secrets in the account.</p>', ], ], 'SecretNameType' => [ 'base' => NULL, 'refs' => [ 'CancelRotateSecretResponse$Name' => '<p>The friendly name of the secret for which rotation was canceled.</p>', 'CreateSecretResponse$Name' => '<p>The friendly name of the secret that you just created.</p>', 'DeleteSecretResponse$Name' => '<p>The friendly name of the secret currently scheduled for deletion.</p>', 'DescribeSecretResponse$Name' => '<p>The user-provided friendly name of the secret.</p>', 'GetSecretValueResponse$Name' => '<p>The friendly name of the secret.</p>', 'ListSecretVersionIdsResponse$Name' => '<p>The friendly name of the secret.</p>', 'PutSecretValueResponse$Name' => '<p>The friendly name of the secret for which you just created or updated a version.</p>', 'RestoreSecretResponse$Name' => '<p>The friendly name of the secret that was restored.</p>', 'RotateSecretResponse$Name' => '<p>The friendly name of the secret.</p>', 'SecretListEntry$Name' => '<p>The friendly name of the secret. You can use forward slashes in the name to represent a path hierarchy. For example, <code>/prod/databases/dbserver1</code> could represent the secret for a server named <code>dbserver1</code> in the folder <code>databases</code> in the folder <code>prod</code>. </p>', 'UpdateSecretResponse$Name' => '<p>The friendly name of the secret that was updated.</p>', 'UpdateSecretVersionStageResponse$Name' => '<p>The friendly name of the secret with the modified staging label.</p>', ], ], 'SecretStringType' => [ 'base' => NULL, 'refs' => [ 'CreateSecretRequest$SecretString' => '<p>(Optional) Specifies text data that you want to encrypt and store in this new version of the secret.</p> <p>Either <code>SecretString</code> or <code>SecretBinary</code> must have a value, but not both. They cannot both be empty.</p> <p>If you create a secret by using the Secrets Manager console then Secrets Manager puts the protected secret text in only the <code>SecretString</code> parameter. The Secrets Manager console stores the information as a JSON structure of key/value pairs that the Lambda rotation function knows how to parse.</p> <p>For storing multiple values, we recommend that you use a JSON text string argument and specify key/value pairs. For more information, see <a href="https://docs.aws.amazon.com/cli/latest/userguide/cli-usage-parameters.html">Specifying parameter values for the Amazon Web Services CLI</a> in the Amazon Web Services CLI User Guide.</p>', 'GetSecretValueResponse$SecretString' => '<p>The decrypted part of the protected secret information that was originally provided as a string.</p> <p>If you create this secret by using the Secrets Manager console then only the <code>SecretString</code> parameter contains data. Secrets Manager stores the information as a JSON structure of key/value pairs that the Lambda rotation function knows how to parse.</p> <p>If you store custom information in the secret by using the <a>CreateSecret</a>, <a>UpdateSecret</a>, or <a>PutSecretValue</a> API operations instead of the Secrets Manager console, or by using the <b>Other secret type</b> in the console, then you must code your Lambda rotation function to parse and interpret those values.</p>', 'PutSecretValueRequest$SecretString' => '<p>(Optional) Specifies text data that you want to encrypt and store in this new version of the secret. Either <code>SecretString</code> or <code>SecretBinary</code> must have a value, but not both. They cannot both be empty.</p> <p>If you create this secret by using the Secrets Manager console then Secrets Manager puts the protected secret text in only the <code>SecretString</code> parameter. The Secrets Manager console stores the information as a JSON structure of key/value pairs that the default Lambda rotation function knows how to parse.</p> <p>For storing multiple values, we recommend that you use a JSON text string argument and specify key/value pairs. For more information, see <a href="https://docs.aws.amazon.com/cli/latest/userguide/cli-usage-parameters.html">Specifying parameter values for the Amazon Web Services CLI</a> in the Amazon Web Services CLI User Guide.</p>', 'UpdateSecretRequest$SecretString' => '<p>(Optional) Specifies updated text data that you want to encrypt and store in this new version of the secret. Either <code>SecretBinary</code> or <code>SecretString</code> must have a value, but not both. They cannot both be empty.</p> <p>If you create this secret by using the Secrets Manager console then Secrets Manager puts the protected secret text in only the <code>SecretString</code> parameter. The Secrets Manager console stores the information as a JSON structure of key/value pairs that the default Lambda rotation function knows how to parse.</p> <p>For storing multiple values, we recommend that you use a JSON text string argument and specify key/value pairs. For more information, see <a href="https://docs.aws.amazon.com/cli/latest/userguide/cli-usage-parameters.html">Specifying parameter values for the Amazon Web Services CLI</a> in the Amazon Web Services CLI User Guide.</p>', ], ], 'SecretVersionIdType' => [ 'base' => NULL, 'refs' => [ 'CancelRotateSecretResponse$VersionId' => '<p>The unique identifier of the version of the secret created during the rotation. This version might not be complete, and should be evaluated for possible deletion. At the very least, you should remove the <code>VersionStage</code> value <code>AWSPENDING</code> to enable this version to be deleted. Failing to clean up a cancelled rotation can block you from successfully starting future rotations.</p>', 'CreateSecretResponse$VersionId' => '<p>The unique identifier associated with the version of the secret you just created.</p>', 'GetSecretValueRequest$VersionId' => '<p>Specifies the unique identifier of the version of the secret that you want to retrieve. If you specify both this parameter and <code>VersionStage</code>, the two parameters must refer to the same secret version. If you don\'t specify either a <code>VersionStage</code> or <code>VersionId</code> then the default is to perform the operation on the version with the <code>VersionStage</code> value of <code>AWSCURRENT</code>.</p> <p>This value is typically a <a href="https://wikipedia.org/wiki/Universally_unique_identifier">UUID-type</a> value with 32 hexadecimal digits.</p>', 'GetSecretValueResponse$VersionId' => '<p>The unique identifier of this version of the secret.</p>', 'PutSecretValueResponse$VersionId' => '<p>The unique identifier of the version of the secret you just created or updated.</p>', 'RotateSecretResponse$VersionId' => '<p>The ID of the new version of the secret created by the rotation started by this request.</p>', 'SecretVersionsListEntry$VersionId' => '<p>The unique version identifier of this version of the secret.</p>', 'SecretVersionsToStagesMapType$key' => NULL, 'UpdateSecretResponse$VersionId' => '<p>If a new version of the secret was created by this operation, then <code>VersionId</code> contains the unique identifier of the new version.</p>', 'UpdateSecretVersionStageRequest$RemoveFromVersionId' => '<p>Specifies the secret version ID of the version that the staging label is to be removed from. If the staging label you are trying to attach to one version is already attached to a different version, then you must include this parameter and specify the version that the label is to be removed from. If the label is attached and you either do not specify this parameter, or the version ID does not match, then the operation fails.</p>', 'UpdateSecretVersionStageRequest$MoveToVersionId' => '<p>(Optional) The secret version ID that you want to add the staging label. If you want to remove a label from a version, then do not specify this parameter.</p> <p>If the staging label is already attached to a different version of the secret, then you must also specify the <code>RemoveFromVersionId</code> parameter. </p>', ], ], 'SecretVersionStageType' => [ 'base' => NULL, 'refs' => [ 'GetSecretValueRequest$VersionStage' => '<p>Specifies the secret version that you want to retrieve by the staging label attached to the version.</p> <p>Staging labels are used to keep track of different versions during the rotation process. If you specify both this parameter and <code>VersionId</code>, the two parameters must refer to the same secret version . If you don\'t specify either a <code>VersionStage</code> or <code>VersionId</code>, then the default is to perform the operation on the version with the <code>VersionStage</code> value of <code>AWSCURRENT</code>.</p>', 'SecretVersionStagesType$member' => NULL, 'UpdateSecretVersionStageRequest$VersionStage' => '<p>The staging label to add to this version.</p>', ], ], 'SecretVersionStagesType' => [ 'base' => NULL, 'refs' => [ 'GetSecretValueResponse$VersionStages' => '<p>A list of all of the staging labels currently attached to this version of the secret.</p>', 'PutSecretValueRequest$VersionStages' => '<p>(Optional) Specifies a list of staging labels that are attached to this version of the secret. These staging labels are used to track the versions through the rotation process by the Lambda rotation function.</p> <p>A staging label must be unique to a single version of the secret. If you specify a staging label that\'s already associated with a different version of the same secret then that staging label is automatically removed from the other version and attached to this version.</p> <p>If you do not specify a value for <code>VersionStages</code> then Secrets Manager automatically moves the staging label <code>AWSCURRENT</code> to this new version.</p>', 'PutSecretValueResponse$VersionStages' => '<p>The list of staging labels that are currently attached to this version of the secret. Staging labels are used to track a version as it progresses through the secret rotation process.</p>', 'SecretVersionsListEntry$VersionStages' => '<p>An array of staging labels that are currently associated with this version of the secret.</p>', 'SecretVersionsToStagesMapType$value' => NULL, ], ], 'SecretVersionsListEntry' => [ 'base' => '<p>A structure that contains information about one version of a secret.</p>', 'refs' => [ 'SecretVersionsListType$member' => NULL, ], ], 'SecretVersionsListType' => [ 'base' => NULL, 'refs' => [ 'ListSecretVersionIdsResponse$Versions' => '<p>The list of the currently available versions of the specified secret.</p>', ], ], 'SecretVersionsToStagesMapType' => [ 'base' => NULL, 'refs' => [ 'DescribeSecretResponse$VersionIdsToStages' => '<p>A list of all of the currently assigned <code>VersionStage</code> staging labels and the <code>VersionId</code> that each is attached to. Staging labels are used to keep track of the different versions during the rotation process.</p> <note> <p>A version that does not have any staging labels attached is considered deprecated and subject to deletion. Such versions are not included in this list.</p> </note>', 'SecretListEntry$SecretVersionsToStages' => '<p>A list of all of the currently assigned <code>SecretVersionStage</code> staging labels and the <code>SecretVersionId</code> attached to each one. Staging labels are used to keep track of the different versions during the rotation process.</p> <note> <p>A version that does not have any <code>SecretVersionStage</code> is considered deprecated and subject to deletion. Such versions are not included in this list.</p> </note>', ], ], 'SortOrderType' => [ 'base' => NULL, 'refs' => [ 'ListSecretsRequest$SortOrder' => '<p>Lists secrets in the requested order. </p>', ], ], 'StatusMessageType' => [ 'base' => NULL, 'refs' => [ 'ReplicationStatusType$StatusMessage' => '<p>Status message such as "<i>Secret with this name already exists in this region</i>".</p>', ], ], 'StatusType' => [ 'base' => NULL, 'refs' => [ 'ReplicationStatusType$Status' => '<p>The status can be <code>InProgress</code>, <code>Failed</code>, or <code>InSync</code>.</p>', ], ], 'StopReplicationToReplicaRequest' => [ 'base' => NULL, 'refs' => [], ], 'StopReplicationToReplicaResponse' => [ 'base' => NULL, 'refs' => [], ], 'Tag' => [ 'base' => '<p>A structure that contains information about a tag.</p>', 'refs' => [ 'TagListType$member' => NULL, ], ], 'TagKeyListType' => [ 'base' => NULL, 'refs' => [ 'UntagResourceRequest$TagKeys' => '<p>A list of tag key names to remove from the secret. You don\'t specify the value. Both the key and its associated value are removed.</p> <p>This parameter to the API requires a JSON text string argument.</p> <p>For storing multiple values, we recommend that you use a JSON text string argument and specify key/value pairs. For more information, see <a href="https://docs.aws.amazon.com/cli/latest/userguide/cli-usage-parameters.html">Specifying parameter values for the Amazon Web Services CLI</a> in the Amazon Web Services CLI User Guide.</p>', ], ], 'TagKeyType' => [ 'base' => NULL, 'refs' => [ 'Tag$Key' => '<p>The key identifier, or name, of the tag.</p>', 'TagKeyListType$member' => NULL, ], ], 'TagListType' => [ 'base' => NULL, 'refs' => [ 'CreateSecretRequest$Tags' => '<p>(Optional) Specifies a list of user-defined tags that are attached to the secret. Each tag is a "Key" and "Value" pair of strings. This operation only appends tags to the existing list of tags. To remove tags, you must use <a>UntagResource</a>.</p> <important> <ul> <li> <p>Secrets Manager tag key names are case sensitive. A tag with the key "ABC" is a different tag from one with key "abc".</p> </li> <li> <p>If you check tags in IAM policy <code>Condition</code> elements as part of your security strategy, then adding or removing a tag can change permissions. If the successful completion of this operation would result in you losing your permissions for this secret, then this operation is blocked and returns an <code>Access Denied</code> error.</p> </li> </ul> </important> <p>This parameter requires a JSON text string argument. For information on how to format a JSON parameter for the various command line tool environments, see <a href="https://docs.aws.amazon.com/cli/latest/userguide/cli-using-param.html#cli-using-param-json">Using JSON for Parameters</a> in the <i>CLI User Guide</i>. For example:</p> <p> <code>[{"Key":"CostCenter","Value":"12345"},{"Key":"environment","Value":"production"}]</code> </p> <p>If your command-line tool or SDK requires quotation marks around the parameter, you should use single quotes to avoid confusion with the double quotes required in the JSON text. </p> <p>The following basic restrictions apply to tags:</p> <ul> <li> <p>Maximum number of tags per secret—50</p> </li> <li> <p>Maximum key length—127 Unicode characters in UTF-8</p> </li> <li> <p>Maximum value length—255 Unicode characters in UTF-8</p> </li> <li> <p>Tag keys and values are case sensitive.</p> </li> <li> <p>Do not use the <code>aws:</code> prefix in your tag names or values because Amazon Web Services reserves it for Amazon Web Services use. You can\'t edit or delete tag names or values with this prefix. Tags with this prefix do not count against your tags per secret limit.</p> </li> <li> <p>If you use your tagging schema across multiple services and resources, remember other services might have restrictions on allowed characters. Generally allowed characters: letters, spaces, and numbers representable in UTF-8, plus the following special characters: + - = . _ : / @.</p> </li> </ul>', 'DescribeSecretResponse$Tags' => '<p>The list of user-defined tags that are associated with the secret. To add tags to a secret, use <a>TagResource</a>. To remove tags, use <a>UntagResource</a>.</p>', 'SecretListEntry$Tags' => '<p>The list of user-defined tags associated with the secret. To add tags to a secret, use <a>TagResource</a>. To remove tags, use <a>UntagResource</a>.</p>', 'TagResourceRequest$Tags' => '<p>The tags to attach to the secret. Each element in the list consists of a <code>Key</code> and a <code>Value</code>.</p> <p>This parameter to the API requires a JSON text string argument.</p> <p>For storing multiple values, we recommend that you use a JSON text string argument and specify key/value pairs. For more information, see <a href="https://docs.aws.amazon.com/cli/latest/userguide/cli-usage-parameters.html">Specifying parameter values for the Amazon Web Services CLI</a> in the Amazon Web Services CLI User Guide.</p>', ], ], 'TagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'TagValueType' => [ 'base' => NULL, 'refs' => [ 'Tag$Value' => '<p>The string value associated with the key of the tag.</p>', ], ], 'TimestampType' => [ 'base' => NULL, 'refs' => [ 'DescribeSecretResponse$CreatedDate' => '<p>The date you created the secret.</p>', 'SecretListEntry$CreatedDate' => '<p>The date and time when a secret was created.</p>', ], ], 'UntagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateSecretRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateSecretResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateSecretVersionStageRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateSecretVersionStageResponse' => [ 'base' => NULL, 'refs' => [], ], 'ValidateResourcePolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'ValidateResourcePolicyResponse' => [ 'base' => NULL, 'refs' => [], ], 'ValidationErrorsEntry' => [ 'base' => '<p>Displays errors that occurred during validation of the resource policy.</p>', 'refs' => [ 'ValidationErrorsType$member' => NULL, ], ], 'ValidationErrorsType' => [ 'base' => NULL, 'refs' => [ 'ValidateResourcePolicyResponse$ValidationErrors' => '<p>Returns an error message if your policy doesn\'t pass validatation.</p>', ], ], ],];
