<?php
// This file was auto-generated from sdk-root/src/data/nimble/2020-08-01/docs-2.json
return [ 'version' => '2.0', 'service' => '<p>Welcome to the Amazon Nimble Studio API reference. This API reference provides methods, schema, resources, parameters, and more to help you get the most out of Nimble Studio.</p> <p>Nimble Studio is a virtual studio that empowers visual effects, animation, and interactive content teams to create content securely within a scalable, private cloud service.</p>', 'operations' => [ 'AcceptEulas' => '<p>Accept EULAs.</p>', 'CreateLaunchProfile' => '<p>Create a launch profile.</p>', 'CreateStreamingImage' => '<p>Creates a streaming image resource in a studio.</p>', 'CreateStreamingSession' => '<p>Creates a streaming session in a studio.</p> <p>After invoking this operation, you must poll GetStreamingSession until the streaming session is in state READY.</p>', 'CreateStreamingSessionStream' => '<p>Creates a streaming session stream for a streaming session.</p> <p>After invoking this API, invoke GetStreamingSessionStream with the returned streamId to poll the resource until it is in state READY.</p>', 'CreateStudio' => '<p>Create a new Studio.</p> <p>When creating a Studio, two IAM roles must be provided: the admin role and the user Role. These roles are assumed by your users when they log in to the Nimble Studio portal.</p> <p>The user role must have the AmazonNimbleStudio-StudioUser managed policy attached for the portal to function properly.</p> <p>The Admin Role must have the AmazonNimbleStudio-StudioAdmin managed policy attached for the portal to function properly.</p> <p>You may optionally specify a KMS key in the StudioEncryptionConfiguration.</p> <p>In Nimble Studio, resource names, descriptions, initialization scripts, and other data you provide are always encrypted at rest using an KMS key. By default, this key is owned by Amazon Web Services and managed on your behalf. You may provide your own KMS key when calling CreateStudio to encrypt this data using a key you own and manage.</p> <p>When providing an KMS key during studio creation, Nimble Studio creates KMS grants in your account to provide your studio user and admin roles access to these KMS keys.</p> <p>If you delete this grant, the studio will no longer be accessible to your portal users.</p> <p>If you delete the studio KMS key, your studio will no longer be accessible.</p>', 'CreateStudioComponent' => '<p>Creates a studio component resource.</p>', 'DeleteLaunchProfile' => '<p>Permanently delete a launch profile.</p>', 'DeleteLaunchProfileMember' => '<p>Delete a user from launch profile membership.</p>', 'DeleteStreamingImage' => '<p>Delete streaming image.</p>', 'DeleteStreamingSession' => '<p>Deletes streaming session resource.</p> <p>After invoking this operation, use GetStreamingSession to poll the resource until it transitions to a DELETED state.</p> <p>A streaming session will count against your streaming session quota until it is marked DELETED.</p>', 'DeleteStudio' => '<p>Delete a studio resource.</p>', 'DeleteStudioComponent' => '<p>Deletes a studio component resource.</p>', 'DeleteStudioMember' => '<p>Delete a user from studio membership.</p>', 'GetEula' => '<p>Get Eula.</p>', 'GetLaunchProfile' => '<p>Get a launch profile.</p>', 'GetLaunchProfileDetails' => '<p>Launch profile details include the launch profile resource and summary information of resources that are used by, or available to, the launch profile. This includes the name and description of all studio components used by the launch profiles, and the name and description of streaming images that can be used with this launch profile.</p>', 'GetLaunchProfileInitialization' => '<p>Get a launch profile initialization.</p>', 'GetLaunchProfileMember' => '<p>Get a user persona in launch profile membership.</p>', 'GetStreamingImage' => '<p>Get streaming image.</p>', 'GetStreamingSession' => '<p>Gets StreamingSession resource.</p> <p>anvoke this operation to poll for a streaming session state while creating or deleting a session.</p>', 'GetStreamingSessionStream' => '<p>Gets a StreamingSessionStream for a streaming session.</p> <p>Invoke this operation to poll the resource after invoking CreateStreamingSessionStream.</p> <p>After the StreamingSessionStream changes to the state READY, the url property will contain a stream to be used with the DCV streaming client.</p>', 'GetStudio' => '<p>Get a Studio resource.</p>', 'GetStudioComponent' => '<p>Gets a studio component resource.</p>', 'GetStudioMember' => '<p>Get a user\'s membership in a studio.</p>', 'ListEulaAcceptances' => '<p>List Eula Acceptances.</p>', 'ListEulas' => '<p>List Eulas.</p>', 'ListLaunchProfileMembers' => '<p>Get all users in a given launch profile membership.</p>', 'ListLaunchProfiles' => '<p>List all the launch profiles a studio.</p>', 'ListStreamingImages' => '<p>List the streaming image resources available to this studio.</p> <p>This list will contain both images provided by Amazon Web Services, as well as streaming images that you have created in your studio.</p>', 'ListStreamingSessions' => '<p>Lists the streaming image resources in a studio.</p>', 'ListStudioComponents' => '<p>Lists the StudioComponents in a studio.</p>', 'ListStudioMembers' => '<p>Get all users in a given studio membership.</p>', 'ListStudios' => '<p>List studios in your Amazon Web Services account in the requested Amazon Web Services Region.</p>', 'ListTagsForResource' => '<p>Gets the tags for a resource, given its Amazon Resource Names (ARN).</p> <p>This operation supports ARNs for all resource types in Nimble Studio that support tags, including studio, studio component, launch profile, streaming image, and streaming session. All resources that can be tagged will contain an ARN property, so you do not have to create this ARN yourself.</p>', 'PutLaunchProfileMembers' => '<p>Add/update users with given persona to launch profile membership.</p>', 'PutStudioMembers' => '<p>Add/update users with given persona to studio membership.</p>', 'StartStreamingSession' => '<p> Transitions sessions from the STOPPED state into the READY state. The START_IN_PROGRESS state is the intermediate state between the STOPPED and READY states.</p>', 'StartStudioSSOConfigurationRepair' => '<p>Repairs the Amazon Web Services SSO configuration for a given studio.</p> <p>If the studio has a valid Amazon Web Services SSO configuration currently associated with it, this operation will fail with a validation error.</p> <p>If the studio does not have a valid Amazon Web Services SSO configuration currently associated with it, then a new Amazon Web Services SSO application is created for the studio and the studio is changed to the READY state.</p> <p>After the Amazon Web Services SSO application is repaired, you must use the Amazon Nimble Studio console to add administrators and users to your studio.</p>', 'StopStreamingSession' => '<p>Transitions sessions from the READY state into the STOPPED state. The STOP_IN_PROGRESS state is the intermediate state between the READY and STOPPED states.</p>', 'TagResource' => '<p>Creates tags for a resource, given its ARN.</p>', 'UntagResource' => '<p>Deletes the tags for a resource.</p>', 'UpdateLaunchProfile' => '<p>Update a launch profile.</p>', 'UpdateLaunchProfileMember' => '<p>Update a user persona in launch profile membership.</p>', 'UpdateStreamingImage' => '<p>Update streaming image.</p>', 'UpdateStudio' => '<p>Update a Studio resource.</p> <p>Currently, this operation only supports updating the displayName of your studio.</p>', 'UpdateStudioComponent' => '<p>Updates a studio component resource.</p>', ], 'shapes' => [ 'AcceptEulasRequest' => [ 'base' => '<zonbook></zonbook><xhtml></xhtml>', 'refs' => [], ], 'AcceptEulasResponse' => [ 'base' => '<zonbook></zonbook><xhtml></xhtml>', 'refs' => [], ], 'AccessDeniedException' => [ 'base' => '<p>You are not authorized to perform this operation. Check your IAM policies, and ensure that you are using the correct access keys.</p>', 'refs' => [], ], 'ActiveDirectoryComputerAttribute' => [ 'base' => '<p>An LDAP attribute of an Active Directory computer account, in the form of a name:value pair.</p>', 'refs' => [ 'ActiveDirectoryComputerAttributeList$member' => NULL, ], ], 'ActiveDirectoryComputerAttributeList' => [ 'base' => '<p>A collection of LDAP attributes to apply to Active Directory computer accounts that are created for streaming sessions.</p>', 'refs' => [ 'ActiveDirectoryConfiguration$computerAttributes' => '<p>A collection of custom attributes for an Active Directory computer.</p>', 'LaunchProfileInitializationActiveDirectory$computerAttributes' => '<p>A collection of custom attributes for an Active Directory computer.</p>', ], ], 'ActiveDirectoryComputerAttributeName' => [ 'base' => '<p>The name for the LDAP attribute.</p>', 'refs' => [ 'ActiveDirectoryComputerAttribute$name' => '<p>The name for the LDAP attribute.</p>', ], ], 'ActiveDirectoryComputerAttributeValue' => [ 'base' => '<p>The value for the LDAP attribute.</p>', 'refs' => [ 'ActiveDirectoryComputerAttribute$value' => '<p>The value for the LDAP attribute.</p>', ], ], 'ActiveDirectoryConfiguration' => [ 'base' => '<p>The configuration for a Microsoft Active Directory (Microsoft AD) studio resource.</p>', 'refs' => [ 'StudioComponentConfiguration$activeDirectoryConfiguration' => '<p>The configuration for a Microsoft Active Directory (Microsoft AD) studio resource.</p>', ], ], 'ActiveDirectoryDnsIpAddress' => [ 'base' => '<zonbook></zonbook><xhtml></xhtml>', 'refs' => [ 'ActiveDirectoryDnsIpAddressList$member' => NULL, ], ], 'ActiveDirectoryDnsIpAddressList' => [ 'base' => '<zonbook></zonbook><xhtml></xhtml>', 'refs' => [ 'LaunchProfileInitializationActiveDirectory$dnsIpAddresses' => '<p>The DNS IP address.</p>', ], ], 'ActiveDirectoryOrganizationalUnitDistinguishedName' => [ 'base' => '<p>The fully-qualified distinguished name of the organizational unit to place the computer account in.</p>', 'refs' => [ 'ActiveDirectoryConfiguration$organizationalUnitDistinguishedName' => '<p>The distinguished name (DN) and organizational unit (OU) of an Active Directory computer.</p>', 'LaunchProfileInitializationActiveDirectory$organizationalUnitDistinguishedName' => '<p>The name for the organizational unit distinguished name.</p>', ], ], 'ClientToken' => [ 'base' => NULL, 'refs' => [ 'AcceptEulasRequest$clientToken' => '<p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t specify a client token, the AWS SDK automatically generates a client token and uses it for the request to ensure idempotency.</p>', 'CreateLaunchProfileRequest$clientToken' => '<p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t specify a client token, the AWS SDK automatically generates a client token and uses it for the request to ensure idempotency.</p>', 'CreateStreamingImageRequest$clientToken' => '<p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t specify a client token, the AWS SDK automatically generates a client token and uses it for the request to ensure idempotency.</p>', 'CreateStreamingSessionRequest$clientToken' => '<p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t specify a client token, the AWS SDK automatically generates a client token and uses it for the request to ensure idempotency.</p>', 'CreateStreamingSessionStreamRequest$clientToken' => '<p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t specify a client token, the AWS SDK automatically generates a client token and uses it for the request to ensure idempotency.</p>', 'CreateStudioComponentRequest$clientToken' => '<p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t specify a client token, the AWS SDK automatically generates a client token and uses it for the request to ensure idempotency.</p>', 'CreateStudioRequest$clientToken' => '<p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t specify a client token, the AWS SDK automatically generates a client token and uses it for the request to ensure idempotency.</p>', 'DeleteLaunchProfileMemberRequest$clientToken' => '<p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t specify a client token, the AWS SDK automatically generates a client token and uses it for the request to ensure idempotency.</p>', 'DeleteLaunchProfileRequest$clientToken' => '<p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t specify a client token, the AWS SDK automatically generates a client token and uses it for the request to ensure idempotency.</p>', 'DeleteStreamingImageRequest$clientToken' => '<p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t specify a client token, the AWS SDK automatically generates a client token and uses it for the request to ensure idempotency.</p>', 'DeleteStreamingSessionRequest$clientToken' => '<p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t specify a client token, the AWS SDK automatically generates a client token and uses it for the request to ensure idempotency.</p>', 'DeleteStudioComponentRequest$clientToken' => '<p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t specify a client token, the AWS SDK automatically generates a client token and uses it for the request to ensure idempotency.</p>', 'DeleteStudioMemberRequest$clientToken' => '<p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t specify a client token, the AWS SDK automatically generates a client token and uses it for the request to ensure idempotency.</p>', 'DeleteStudioRequest$clientToken' => '<p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t specify a client token, the AWS SDK automatically generates a client token and uses it for the request to ensure idempotency.</p>', 'PutLaunchProfileMembersRequest$clientToken' => '<p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t specify a client token, the AWS SDK automatically generates a client token and uses it for the request to ensure idempotency.</p>', 'PutStudioMembersRequest$clientToken' => '<p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t specify a client token, the AWS SDK automatically generates a client token and uses it for the request to ensure idempotency.</p>', 'StartStreamingSessionRequest$clientToken' => '<p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t specify a client token, the AWS SDK automatically generates a client token and uses it for the request to ensure idempotency.</p>', 'StartStudioSSOConfigurationRepairRequest$clientToken' => '<p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t specify a client token, the AWS SDK automatically generates a client token and uses it for the request to ensure idempotency.</p>', 'StopStreamingSessionRequest$clientToken' => '<p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t specify a client token, the AWS SDK automatically generates a client token and uses it for the request to ensure idempotency.</p>', 'UpdateLaunchProfileMemberRequest$clientToken' => '<p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t specify a client token, the AWS SDK automatically generates a client token and uses it for the request to ensure idempotency.</p>', 'UpdateLaunchProfileRequest$clientToken' => '<p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t specify a client token, the AWS SDK automatically generates a client token and uses it for the request to ensure idempotency.</p>', 'UpdateStreamingImageRequest$clientToken' => '<p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t specify a client token, the AWS SDK automatically generates a client token and uses it for the request to ensure idempotency.</p>', 'UpdateStudioComponentRequest$clientToken' => '<p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t specify a client token, the AWS SDK automatically generates a client token and uses it for the request to ensure idempotency.</p>', 'UpdateStudioRequest$clientToken' => '<p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t specify a client token, the AWS SDK automatically generates a client token and uses it for the request to ensure idempotency.</p>', ], ], 'ComputeFarmConfiguration' => [ 'base' => '<p>The configuration for a render farm that is associated with a studio resource.</p>', 'refs' => [ 'StudioComponentConfiguration$computeFarmConfiguration' => '<p>The configuration for a render farm that is associated with a studio resource.</p>', ], ], 'ConflictException' => [ 'base' => '<p>Another operation is in progress. </p>', 'refs' => [], ], 'CreateLaunchProfileRequest' => [ 'base' => '<zonbook></zonbook><xhtml></xhtml>', 'refs' => [], ], 'CreateLaunchProfileResponse' => [ 'base' => '<zonbook></zonbook><xhtml></xhtml>', 'refs' => [], ], 'CreateStreamingImageRequest' => [ 'base' => '<zonbook></zonbook><xhtml></xhtml>', 'refs' => [], ], 'CreateStreamingImageResponse' => [ 'base' => '<zonbook></zonbook><xhtml></xhtml>', 'refs' => [], ], 'CreateStreamingSessionRequest' => [ 'base' => '<zonbook></zonbook><xhtml></xhtml>', 'refs' => [], ], 'CreateStreamingSessionResponse' => [ 'base' => '<zonbook></zonbook><xhtml></xhtml>', 'refs' => [], ], 'CreateStreamingSessionStreamRequest' => [ 'base' => '<zonbook></zonbook><xhtml></xhtml>', 'refs' => [], ], 'CreateStreamingSessionStreamResponse' => [ 'base' => '<zonbook></zonbook><xhtml></xhtml>', 'refs' => [], ], 'CreateStudioComponentRequest' => [ 'base' => '<zonbook></zonbook><xhtml></xhtml>', 'refs' => [], ], 'CreateStudioComponentResponse' => [ 'base' => '<p/>', 'refs' => [], ], 'CreateStudioRequest' => [ 'base' => '<zonbook></zonbook><xhtml></xhtml>', 'refs' => [], ], 'CreateStudioResponse' => [ 'base' => '<zonbook></zonbook><xhtml></xhtml>', 'refs' => [], ], 'DeleteLaunchProfileMemberRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteLaunchProfileMemberResponse' => [ 'base' => '<zonbook></zonbook><xhtml></xhtml>', 'refs' => [], ], 'DeleteLaunchProfileRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteLaunchProfileResponse' => [ 'base' => '<zonbook></zonbook><xhtml></xhtml>', 'refs' => [], ], 'DeleteStreamingImageRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteStreamingImageResponse' => [ 'base' => '<zonbook></zonbook><xhtml></xhtml>', 'refs' => [], ], 'DeleteStreamingSessionRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteStreamingSessionResponse' => [ 'base' => '<zonbook></zonbook><xhtml></xhtml>', 'refs' => [], ], 'DeleteStudioComponentRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteStudioComponentResponse' => [ 'base' => '<zonbook></zonbook><xhtml></xhtml>', 'refs' => [], ], 'DeleteStudioMemberRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteStudioMemberResponse' => [ 'base' => '<zonbook></zonbook><xhtml></xhtml>', 'refs' => [], ], 'DeleteStudioRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteStudioResponse' => [ 'base' => '<zonbook></zonbook><xhtml></xhtml>', 'refs' => [], ], 'DirectoryId' => [ 'base' => '<zonbook></zonbook><xhtml></xhtml>', 'refs' => [ 'ActiveDirectoryConfiguration$directoryId' => '<p>The directory ID of the Directory Service for Microsoft Active Directory to access using this studio component.</p>', 'LaunchProfileInitializationActiveDirectory$directoryId' => '<p>The directory ID of the Directory Service for Microsoft Active Directory to access using this launch profile.</p>', ], ], 'EC2ImageId' => [ 'base' => '<zonbook></zonbook><xhtml></xhtml>', 'refs' => [ 'CreateStreamingImageRequest$ec2ImageId' => '<p>The ID of an EC2 machine image with which to create this streaming image.</p>', 'StreamingImage$ec2ImageId' => '<p>The ID of an EC2 machine image with which to create the streaming image.</p>', ], ], 'EC2SubnetId' => [ 'base' => '<zonbook></zonbook><xhtml></xhtml>', 'refs' => [ 'EC2SubnetIdList$member' => NULL, ], ], 'EC2SubnetIdList' => [ 'base' => '<zonbook></zonbook><xhtml></xhtml>', 'refs' => [ 'CreateLaunchProfileRequest$ec2SubnetIds' => '<p>Specifies the IDs of the EC2 subnets where streaming sessions will be accessible from. These subnets must support the specified instance types. </p>', 'LaunchProfile$ec2SubnetIds' => '<p>Unique identifiers for a collection of EC2 subnets.</p>', ], ], 'Eula' => [ 'base' => '<p>Represents a EULA resource.</p>', 'refs' => [ 'EulaList$member' => NULL, 'GetEulaResponse$eula' => '<p>The EULA.</p>', ], ], 'EulaAcceptance' => [ 'base' => '<p>The acceptance of a EULA, required to use Amazon-provided streaming images.</p>', 'refs' => [ 'EulaAcceptanceList$member' => NULL, ], ], 'EulaAcceptanceId' => [ 'base' => '<p>The EULA acceptance ID.</p>', 'refs' => [ 'EulaAcceptance$eulaAcceptanceId' => '<p>The EULA acceptance ID.</p>', ], ], 'EulaAcceptanceList' => [ 'base' => '<zonbook></zonbook><xhtml></xhtml>', 'refs' => [ 'AcceptEulasResponse$eulaAcceptances' => '<p>A collection of EULA acceptances.</p>', 'ListEulaAcceptancesResponse$eulaAcceptances' => '<p>A collection of EULA acceptances.</p>', ], ], 'EulaId' => [ 'base' => '<p>Represents a EULA resource.</p>', 'refs' => [ 'Eula$eulaId' => '<p>The EULA ID.</p>', 'EulaAcceptance$eulaId' => '<p>The EULA ID.</p>', ], ], 'EulaIdList' => [ 'base' => '<zonbook></zonbook><xhtml></xhtml>', 'refs' => [ 'AcceptEulasRequest$eulaIds' => '<p>The EULA ID.</p>', 'StreamingImage$eulaIds' => '<p>The list of EULAs that must be accepted before a Streaming Session can be started using this streaming image.</p>', ], ], 'EulaList' => [ 'base' => '<zonbook></zonbook><xhtml></xhtml>', 'refs' => [ 'ListEulasResponse$eulas' => '<p>A collection of EULA resources.</p>', ], ], 'EulaName' => [ 'base' => '<zonbook></zonbook><xhtml></xhtml>', 'refs' => [ 'Eula$name' => '<p>The name for the EULA.</p>', ], ], 'ExceptionContext' => [ 'base' => '<p>ExceptionContext is a set of key-value pairs that provide you with more information about the error that occurred. For example, when the service returns a 404 ResourceNotFound error, ExceptionContext will contain the key `resourceId` with the value of resource that was not found.</p> <p>ExceptionContext enables scripts and other programmatic clients to provide for better error handling.</p>', 'refs' => [ 'AccessDeniedException$context' => '<p>The exception context.</p>', 'ConflictException$context' => '<p>The exception context.</p>', 'InternalServerErrorException$context' => '<p>The exception context.</p>', 'ResourceNotFoundException$context' => '<p>The exception context.</p>', 'ServiceQuotaExceededException$context' => '<p>The exception context.</p>', 'ThrottlingException$context' => '<p>The exception context.</p>', 'ValidationException$context' => '<p>The exception context.</p>', ], ], 'GetEulaRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetEulaResponse' => [ 'base' => '<zonbook></zonbook><xhtml></xhtml>', 'refs' => [], ], 'GetLaunchProfileDetailsRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetLaunchProfileDetailsResponse' => [ 'base' => '<zonbook></zonbook><xhtml></xhtml>', 'refs' => [], ], 'GetLaunchProfileInitializationRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetLaunchProfileInitializationResponse' => [ 'base' => '<zonbook></zonbook><xhtml></xhtml>', 'refs' => [], ], 'GetLaunchProfileMemberRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetLaunchProfileMemberResponse' => [ 'base' => '<zonbook></zonbook><xhtml></xhtml>', 'refs' => [], ], 'GetLaunchProfileRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetLaunchProfileResponse' => [ 'base' => '<zonbook></zonbook><xhtml></xhtml>', 'refs' => [], ], 'GetStreamingImageRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetStreamingImageResponse' => [ 'base' => '<zonbook></zonbook><xhtml></xhtml>', 'refs' => [], ], 'GetStreamingSessionRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetStreamingSessionResponse' => [ 'base' => '<zonbook></zonbook><xhtml></xhtml>', 'refs' => [], ], 'GetStreamingSessionStreamRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetStreamingSessionStreamResponse' => [ 'base' => '<zonbook></zonbook><xhtml></xhtml>', 'refs' => [], ], 'GetStudioComponentRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetStudioComponentResponse' => [ 'base' => '<zonbook></zonbook><xhtml></xhtml>', 'refs' => [], ], 'GetStudioMemberRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetStudioMemberResponse' => [ 'base' => '<zonbook></zonbook><xhtml></xhtml>', 'refs' => [], ], 'GetStudioRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetStudioResponse' => [ 'base' => '<zonbook></zonbook><xhtml></xhtml>', 'refs' => [], ], 'InternalServerErrorException' => [ 'base' => '<p>An internal error has occurred. Please retry your request.</p>', 'refs' => [], ], 'LaunchProfile' => [ 'base' => '<p>A launch profile controls your artist workforce’s access to studio components, like compute farms, shared file systems, managed file systems, and license server configurations, as well as instance types and Amazon Machine Images (AMIs). </p> <pre><code> &lt;p&gt;Studio administrators create launch profiles in the Nimble Studio console. Artists can use their launch profiles to launch an instance from the Nimble Studio portal. Each user’s launch profile defines how they can launch a streaming session. By default, studio admins can use all launch profiles.&lt;/p&gt; </code></pre>', 'refs' => [ 'CreateLaunchProfileResponse$launchProfile' => '<p>The launch profile.</p>', 'DeleteLaunchProfileResponse$launchProfile' => '<p>The launch profile.</p>', 'GetLaunchProfileDetailsResponse$launchProfile' => '<p>The launch profile.</p>', 'GetLaunchProfileResponse$launchProfile' => '<p>The launch profile.</p>', 'LaunchProfileList$member' => NULL, 'UpdateLaunchProfileResponse$launchProfile' => '<p>The launch profile.</p>', ], ], 'LaunchProfileDescription' => [ 'base' => '<p>A human-readable description of the launch profile.</p>', 'refs' => [ 'CreateLaunchProfileRequest$description' => '<p>The description.</p>', 'LaunchProfile$description' => '<p>A human-readable description of the launch profile.</p>', 'UpdateLaunchProfileRequest$description' => '<p>The description.</p>', ], ], 'LaunchProfileId' => [ 'base' => '<zonbook></zonbook><xhtml></xhtml>', 'refs' => [ 'LaunchProfile$launchProfileId' => '<p>The launch profile ID.</p>', 'LaunchProfileInitialization$launchProfileId' => '<p>The launch profile ID.</p>', ], ], 'LaunchProfileInitialization' => [ 'base' => '<p>A Launch Profile Initialization contains information required for a workstation or server to connect to a launch profile</p> <p>This includes scripts, endpoints, security groups, subnets, and other configuration.</p>', 'refs' => [ 'GetLaunchProfileInitializationResponse$launchProfileInitialization' => '<p>The launch profile initialization.</p>', ], ], 'LaunchProfileInitializationActiveDirectory' => [ 'base' => '<p/>', 'refs' => [ 'LaunchProfileInitialization$activeDirectory' => '<p>A LaunchProfileInitializationActiveDirectory resource.</p>', ], ], 'LaunchProfileInitializationScript' => [ 'base' => '<p/>', 'refs' => [ 'LaunchProfileInitializationScriptList$member' => NULL, ], ], 'LaunchProfileInitializationScriptList' => [ 'base' => '<zonbook></zonbook><xhtml></xhtml>', 'refs' => [ 'LaunchProfileInitialization$systemInitializationScripts' => '<p>The system initializtion scripts.</p>', 'LaunchProfileInitialization$userInitializationScripts' => '<p>The user initializtion scripts.</p>', ], ], 'LaunchProfileList' => [ 'base' => '<zonbook></zonbook><xhtml></xhtml>', 'refs' => [ 'ListLaunchProfilesResponse$launchProfiles' => '<p>A collection of launch profiles.</p>', ], ], 'LaunchProfileMembership' => [ 'base' => '<p/>', 'refs' => [ 'GetLaunchProfileMemberResponse$member' => '<p>The member.</p>', 'LaunchProfileMembershipList$member' => NULL, 'UpdateLaunchProfileMemberResponse$member' => '<p>The updated member. </p>', ], ], 'LaunchProfileMembershipList' => [ 'base' => '<p/>', 'refs' => [ 'ListLaunchProfileMembersResponse$members' => '<p>A list of members.</p>', ], ], 'LaunchProfileName' => [ 'base' => '<zonbook></zonbook><xhtml></xhtml>', 'refs' => [ 'CreateLaunchProfileRequest$name' => '<p>The name for the launch profile.</p>', 'LaunchProfile$name' => '<p>A friendly name for the launch profile.</p>', 'LaunchProfileInitialization$name' => '<p>The name for the launch profile.</p>', 'UpdateLaunchProfileRequest$name' => '<p>The name for the launch profile.</p>', ], ], 'LaunchProfilePersona' => [ 'base' => '<zonbook></zonbook><xhtml></xhtml>', 'refs' => [ 'LaunchProfileMembership$persona' => '<p>The persona.</p>', 'NewLaunchProfileMember$persona' => '<p>The persona.</p>', 'UpdateLaunchProfileMemberRequest$persona' => '<p>The persona.</p>', ], ], 'LaunchProfilePlatform' => [ 'base' => '<zonbook></zonbook><xhtml></xhtml>', 'refs' => [ 'LaunchProfileInitialization$platform' => '<p>The platform of the launch platform, either WINDOWS or LINUX.</p>', 'StudioComponentInitializationScript$platform' => '<p>The platform of the initialization script, either WINDOWS or LINUX.</p>', ], ], 'LaunchProfileProtocolVersion' => [ 'base' => '<p>The version number of the protocol that is used by the launch profile. The only valid version is "2021-03-31".</p>', 'refs' => [ 'LaunchProfileInitialization$launchProfileProtocolVersion' => '<p>The version number of the protocol that is used by the launch profile. The only valid version is "2021-03-31".</p>', 'LaunchProfileProtocolVersionList$member' => NULL, 'StudioComponentInitializationScript$launchProfileProtocolVersion' => '<p>The version number of the protocol that is used by the launch profile. The only valid version is "2021-03-31".</p>', ], ], 'LaunchProfileProtocolVersionList' => [ 'base' => '<zonbook></zonbook><xhtml></xhtml>', 'refs' => [ 'CreateLaunchProfileRequest$launchProfileProtocolVersions' => '<p>The version number of the protocol that is used by the launch profile. The only valid version is "2021-03-31".</p>', 'LaunchProfile$launchProfileProtocolVersions' => '<p>The version number of the protocol that is used by the launch profile. The only valid version is "2021-03-31".</p>', 'UpdateLaunchProfileRequest$launchProfileProtocolVersions' => '<p>The version number of the protocol that is used by the launch profile. The only valid version is "2021-03-31".</p>', ], ], 'LaunchProfileSecurityGroupIdList' => [ 'base' => '<zonbook></zonbook><xhtml></xhtml>', 'refs' => [ 'LaunchProfileInitialization$ec2SecurityGroupIds' => '<p>The EC2 security groups that control access to the studio component.</p>', ], ], 'LaunchProfileState' => [ 'base' => '<zonbook></zonbook><xhtml></xhtml>', 'refs' => [ 'LaunchProfile$state' => '<p>The current state.</p>', ], ], 'LaunchProfileStatusCode' => [ 'base' => '<zonbook></zonbook><xhtml></xhtml>', 'refs' => [ 'LaunchProfile$statusCode' => '<p>The status code.</p>', ], ], 'LaunchProfileStudioComponentIdList' => [ 'base' => '<zonbook></zonbook><xhtml></xhtml>', 'refs' => [ 'CreateLaunchProfileRequest$studioComponentIds' => '<p>Unique identifiers for a collection of studio components that can be used with this launch profile.</p>', 'LaunchProfile$studioComponentIds' => '<p>Unique identifiers for a collection of studio components that can be used with this launch profile.</p>', 'UpdateLaunchProfileRequest$studioComponentIds' => '<p>Unique identifiers for a collection of studio components that can be used with this launch profile.</p>', ], ], 'LaunchPurpose' => [ 'base' => '<p>The launch purpose.</p>', 'refs' => [ 'LaunchProfileInitialization$launchPurpose' => '<p>The launch purpose.</p>', ], ], 'LicenseServiceConfiguration' => [ 'base' => '<p>The configuration for a license service that is associated with a studio resource.</p>', 'refs' => [ 'StudioComponentConfiguration$licenseServiceConfiguration' => '<p>The configuration for a license service that is associated with a studio resource.</p>', ], ], 'LinuxMountPoint' => [ 'base' => '<zonbook></zonbook><xhtml></xhtml>', 'refs' => [ 'SharedFileSystemConfiguration$linuxMountPoint' => '<p>The mount location for a shared file system on a Linux virtual workstation.</p>', ], ], 'ListEulaAcceptancesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListEulaAcceptancesResponse' => [ 'base' => '<p/>', 'refs' => [], ], 'ListEulasRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListEulasResponse' => [ 'base' => '<zonbook></zonbook><xhtml></xhtml>', 'refs' => [], ], 'ListLaunchProfileMembersRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListLaunchProfileMembersResponse' => [ 'base' => '<zonbook></zonbook><xhtml></xhtml>', 'refs' => [], ], 'ListLaunchProfilesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListLaunchProfilesResponse' => [ 'base' => '<zonbook></zonbook><xhtml></xhtml>', 'refs' => [], ], 'ListStreamingImagesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListStreamingImagesResponse' => [ 'base' => '<zonbook></zonbook><xhtml></xhtml>', 'refs' => [], ], 'ListStreamingSessionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListStreamingSessionsResponse' => [ 'base' => '<zonbook></zonbook><xhtml></xhtml>', 'refs' => [], ], 'ListStudioComponentsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListStudioComponentsResponse' => [ 'base' => '<zonbook></zonbook><xhtml></xhtml>', 'refs' => [], ], 'ListStudioMembersRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListStudioMembersResponse' => [ 'base' => '<zonbook></zonbook><xhtml></xhtml>', 'refs' => [], ], 'ListStudiosRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListStudiosResponse' => [ 'base' => '<zonbook></zonbook><xhtml></xhtml>', 'refs' => [], ], 'ListTagsForResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceResponse' => [ 'base' => '<zonbook></zonbook><xhtml></xhtml>', 'refs' => [], ], 'MaxResults' => [ 'base' => NULL, 'refs' => [ 'ListLaunchProfileMembersRequest$maxResults' => '<p>The max number of results to return in the response.</p>', 'ListLaunchProfilesRequest$maxResults' => '<p>The max number of results to return in the response.</p>', 'ListStudioComponentsRequest$maxResults' => '<p>The max number of results to return in the response.</p>', 'ListStudioMembersRequest$maxResults' => '<p>The max number of results to return in the response.</p>', ], ], 'NewLaunchProfileMember' => [ 'base' => '<p/>', 'refs' => [ 'NewLaunchProfileMemberList$member' => NULL, ], ], 'NewLaunchProfileMemberList' => [ 'base' => '<zonbook></zonbook><xhtml></xhtml>', 'refs' => [ 'PutLaunchProfileMembersRequest$members' => '<p>A list of members.</p>', ], ], 'NewStudioMember' => [ 'base' => '<p/>', 'refs' => [ 'NewStudioMemberList$member' => NULL, ], ], 'NewStudioMemberList' => [ 'base' => '<zonbook></zonbook><xhtml></xhtml>', 'refs' => [ 'PutStudioMembersRequest$members' => '<p>A list of members.</p>', ], ], 'PutLaunchProfileMembersRequest' => [ 'base' => '<zonbook></zonbook><xhtml></xhtml>', 'refs' => [], ], 'PutLaunchProfileMembersResponse' => [ 'base' => NULL, 'refs' => [], ], 'PutStudioMembersRequest' => [ 'base' => '<zonbook></zonbook><xhtml></xhtml>', 'refs' => [], ], 'PutStudioMembersResponse' => [ 'base' => '<zonbook></zonbook><xhtml></xhtml>', 'refs' => [], ], 'Region' => [ 'base' => '<zonbook></zonbook><xhtml></xhtml>', 'refs' => [ 'Studio$homeRegion' => '<p>The Amazon Web Services Region where the studio resource is located.</p>', ], ], 'ResourceNotFoundException' => [ 'base' => '<p>The specified resource could not be found.</p>', 'refs' => [], ], 'ScriptParameterKey' => [ 'base' => '<p>A script parameter key.</p>', 'refs' => [ 'ScriptParameterKeyValue$key' => '<p>A script parameter key.</p>', ], ], 'ScriptParameterKeyValue' => [ 'base' => '<p>A parameter for a studio component script, in the form of a key:value pair.</p>', 'refs' => [ 'StudioComponentScriptParameterKeyValueList$member' => NULL, ], ], 'ScriptParameterValue' => [ 'base' => '<p>A script parameter value.</p>', 'refs' => [ 'ScriptParameterKeyValue$value' => '<p>A script parameter value.</p>', ], ], 'SecurityGroupId' => [ 'base' => '<zonbook></zonbook><xhtml></xhtml>', 'refs' => [ 'LaunchProfileSecurityGroupIdList$member' => NULL, 'StudioComponentSecurityGroupIdList$member' => NULL, ], ], 'ServiceQuotaExceededException' => [ 'base' => '<p>Your current quota does not allow you to perform the request action. You can request increases for some quotas, and other quotas cannot be increased.</p> <p>Please use AWS Service Quotas to request an increase. </p>', 'refs' => [], ], 'SharedFileSystemConfiguration' => [ 'base' => '<p>The configuration for a shared file storage system that is associated with a studio resource.</p>', 'refs' => [ 'StudioComponentConfiguration$sharedFileSystemConfiguration' => '<p>The configuration for a shared file storage system that is associated with a studio resource.</p>', ], ], 'StartStreamingSessionRequest' => [ 'base' => NULL, 'refs' => [], ], 'StartStreamingSessionResponse' => [ 'base' => NULL, 'refs' => [], ], 'StartStudioSSOConfigurationRepairRequest' => [ 'base' => NULL, 'refs' => [], ], 'StartStudioSSOConfigurationRepairResponse' => [ 'base' => '<zonbook></zonbook><xhtml></xhtml>', 'refs' => [], ], 'StopStreamingSessionRequest' => [ 'base' => NULL, 'refs' => [], ], 'StopStreamingSessionResponse' => [ 'base' => NULL, 'refs' => [], ], 'StreamConfiguration' => [ 'base' => '<p>A configuration for a streaming session.</p>', 'refs' => [ 'LaunchProfile$streamConfiguration' => '<p>A configuration for a streaming session.</p>', ], ], 'StreamConfigurationCreate' => [ 'base' => '<p>Configuration for streaming workstations created using this launch profile.</p>', 'refs' => [ 'CreateLaunchProfileRequest$streamConfiguration' => '<p>A configuration for a streaming session.</p>', 'UpdateLaunchProfileRequest$streamConfiguration' => '<p>A configuration for a streaming session.</p>', ], ], 'StreamConfigurationMaxSessionLengthInMinutes' => [ 'base' => '<zonbook></zonbook><xhtml></xhtml>', 'refs' => [ 'StreamConfiguration$maxSessionLengthInMinutes' => '<p>The length of time, in minutes, that a streaming session can be active before it is stopped or terminated. After this point, Nimble Studio automatically terminates or stops the session. The default length of time is 690 minutes, and the maximum length of time is 30 days.</p>', 'StreamConfigurationCreate$maxSessionLengthInMinutes' => '<p>The length of time, in minutes, that a streaming session can be active before it is stopped or terminated. After this point, Nimble Studio automatically terminates or stops the session. The default length of time is 690 minutes, and the maximum length of time is 30 days.</p>', ], ], 'StreamConfigurationMaxStoppedSessionLengthInMinutes' => [ 'base' => NULL, 'refs' => [ 'StreamConfiguration$maxStoppedSessionLengthInMinutes' => '<p>Integer that determines if you can start and stop your sessions and how long a session can stay in the STOPPED state. The default value is 0. The maximum value is 5760.</p> <p>If the value is missing or set to 0, your sessions can’t be stopped. If you then call StopStreamingSession, the session fails. If the time that a session stays in the READY state exceeds the maxSessionLengthInMinutes value, the session will automatically be terminated by AWS (instead of stopped).</p> <p>If the value is set to a positive number, the session can be stopped. You can call StopStreamingSession to stop sessions in the READY state. If the time that a session stays in the READY state exceeds the maxSessionLengthInMinutes value, the session will automatically be stopped by AWS (instead of terminated).</p>', 'StreamConfigurationCreate$maxStoppedSessionLengthInMinutes' => '<p>The length of time, in minutes, that a streaming session can be active before it is stopped or terminated. After this point, Nimble Studio automatically terminates or stops the session. The default length of time is 690 minutes, and the maximum length of time is 30 days.</p>', ], ], 'StreamingClipboardMode' => [ 'base' => '<zonbook></zonbook><xhtml></xhtml>', 'refs' => [ 'StreamConfiguration$clipboardMode' => '<p>Enable or disable the use of the system clipboard to copy and paste between the streaming session and streaming client.</p>', 'StreamConfigurationCreate$clipboardMode' => '<p>Enable or disable the use of the system clipboard to copy and paste between the streaming session and streaming client.</p>', ], ], 'StreamingImage' => [ 'base' => '<p>Represents a streaming image resource.</p> <p>Streaming images are used by studio users to select which operating system and software they want to use in a Nimble Studio streaming session.</p> <p>Amazon provides a number of streaming images that include popular 3rd-party software.</p> <p>You can create your own streaming images using an Amazon Elastic Compute Cloud (Amazon EC2) machine image that you create for this purpose. You can also include software that your users require.</p>', 'refs' => [ 'CreateStreamingImageResponse$streamingImage' => '<p>The streaming image.</p>', 'DeleteStreamingImageResponse$streamingImage' => '<p>The streaming image.</p>', 'GetStreamingImageResponse$streamingImage' => '<p>The streaming image.</p>', 'StreamingImageList$member' => NULL, 'UpdateStreamingImageResponse$streamingImage' => '<p/>', ], ], 'StreamingImageEncryptionConfiguration' => [ 'base' => '<p>Specifies how a streaming image is encrypted.</p>', 'refs' => [ 'StreamingImage$encryptionConfiguration' => '<p>The encryption configuration.</p>', ], ], 'StreamingImageEncryptionConfigurationKeyArn' => [ 'base' => '<zonbook></zonbook><xhtml></xhtml>', 'refs' => [ 'StreamingImageEncryptionConfiguration$keyArn' => '<p>The ARN for a KMS key that is used to encrypt studio data.</p>', ], ], 'StreamingImageEncryptionConfigurationKeyType' => [ 'base' => '<p/>', 'refs' => [ 'StreamingImageEncryptionConfiguration$keyType' => '<p>The type of KMS key that is used to encrypt studio data.</p>', ], ], 'StreamingImageId' => [ 'base' => '<zonbook></zonbook><xhtml></xhtml>', 'refs' => [ 'CreateStreamingSessionRequest$streamingImageId' => '<p>The ID of the streaming image.</p>', 'StreamingImage$streamingImageId' => '<p>The ID of the streaming image.</p>', 'StreamingImageIdList$member' => NULL, 'StreamingSession$streamingImageId' => '<p>The ID of the streaming image.</p>', ], ], 'StreamingImageIdList' => [ 'base' => '<p>A list of streaming image IDs that users can select from when launching a streaming session with this launch profile.</p>', 'refs' => [ 'StreamConfiguration$streamingImageIds' => '<p>The streaming images that users can select from when launching a streaming session with this launch profile.</p>', 'StreamConfigurationCreate$streamingImageIds' => '<p>The streaming images that users can select from when launching a streaming session with this launch profile.</p>', ], ], 'StreamingImageList' => [ 'base' => '<zonbook></zonbook><xhtml></xhtml>', 'refs' => [ 'GetLaunchProfileDetailsResponse$streamingImages' => '<p>A collection of streaming images.</p>', 'ListStreamingImagesResponse$streamingImages' => '<p>A collection of streaming images.</p>', ], ], 'StreamingImageOwner' => [ 'base' => '<p>StreamingImageOwner is the owner of a particular streaming image.</p> <p>This string is either the studioId that contains the streaming image, or the word \'AMAZON\' for images provided by Nimble Studio.</p>', 'refs' => [ 'StreamingImage$owner' => '<p>The owner of the streaming image, either the studioId that contains the streaming image, or \'amazon\' for images that are provided by Amazon Nimble Studio.</p>', ], ], 'StreamingImagePlatform' => [ 'base' => '<p>The platform of this Streaming Image, either WINDOWS or LINUX.</p>', 'refs' => [ 'StreamingImage$platform' => '<p>The platform of the streaming image, either WINDOWS or LINUX.</p>', ], ], 'StreamingImageState' => [ 'base' => '<zonbook></zonbook><xhtml></xhtml>', 'refs' => [ 'StreamingImage$state' => '<p>The current state.</p>', ], ], 'StreamingImageStatusCode' => [ 'base' => '<p>The status code.</p>', 'refs' => [ 'StreamingImage$statusCode' => '<p>The status code.</p>', ], ], 'StreamingInstanceType' => [ 'base' => '<zonbook></zonbook><xhtml></xhtml>', 'refs' => [ 'CreateStreamingSessionRequest$ec2InstanceType' => '<p>The EC2 Instance type used for the streaming session.</p>', 'StreamingInstanceTypeList$member' => NULL, ], ], 'StreamingInstanceTypeList' => [ 'base' => '<p>The EC2 instance types that users can select from when launching a streaming session with this launch profile.</p>', 'refs' => [ 'StreamConfiguration$ec2InstanceTypes' => '<p>The EC2 instance types that users can select from when launching a streaming session with this launch profile.</p>', 'StreamConfigurationCreate$ec2InstanceTypes' => '<p>The EC2 instance types that users can select from when launching a streaming session with this launch profile.</p>', ], ], 'StreamingSession' => [ 'base' => '<p>A streaming session is a virtual workstation created using a particular launch profile.</p>', 'refs' => [ 'CreateStreamingSessionResponse$session' => '<p>The session.</p>', 'DeleteStreamingSessionResponse$session' => '<p>The session.</p>', 'GetStreamingSessionResponse$session' => '<p>The session.</p>', 'StartStreamingSessionResponse$session' => NULL, 'StopStreamingSessionResponse$session' => NULL, 'StreamingSessionList$member' => NULL, ], ], 'StreamingSessionId' => [ 'base' => '<zonbook></zonbook><xhtml></xhtml>', 'refs' => [ 'StreamingSession$sessionId' => '<p>The session ID.</p>', ], ], 'StreamingSessionList' => [ 'base' => '<zonbook></zonbook><xhtml></xhtml>', 'refs' => [ 'ListStreamingSessionsResponse$sessions' => '<p>A collection of streaming sessions.</p>', ], ], 'StreamingSessionState' => [ 'base' => '<p>The streaming session state.</p>', 'refs' => [ 'StreamingSession$state' => '<p>The current state.</p>', ], ], 'StreamingSessionStatusCode' => [ 'base' => '<zonbook></zonbook><xhtml></xhtml>', 'refs' => [ 'StreamingSession$statusCode' => '<p>The status code.</p>', ], ], 'StreamingSessionStream' => [ 'base' => '<p>A stream is an active connection to a streaming session, enabling a studio user to control the streaming session using a compatible client. Streaming session streams are compatible with the NICE DCV web client, included in the Nimble Studio portal, or the NICE DCV desktop client.</p>', 'refs' => [ 'CreateStreamingSessionStreamResponse$stream' => '<p>The stream.</p>', 'GetStreamingSessionStreamResponse$stream' => '<p>The stream.</p>', ], ], 'StreamingSessionStreamExpirationInSeconds' => [ 'base' => '<zonbook></zonbook><xhtml></xhtml>', 'refs' => [ 'CreateStreamingSessionStreamRequest$expirationInSeconds' => '<p>The expiration time in seconds.</p>', ], ], 'StreamingSessionStreamState' => [ 'base' => '<zonbook></zonbook><xhtml></xhtml>', 'refs' => [ 'StreamingSessionStream$state' => '<p>The current state.</p>', ], ], 'StreamingSessionStreamStatusCode' => [ 'base' => '<zonbook></zonbook><xhtml></xhtml>', 'refs' => [ 'StreamingSessionStream$statusCode' => '<p>The streaming session stream status code.</p>', ], ], 'String' => [ 'base' => NULL, 'refs' => [ 'AcceptEulasRequest$studioId' => '<p>A collection of EULA IDs.</p>', 'AccessDeniedException$code' => '<p>A more specific error code.</p>', 'AccessDeniedException$message' => '<p>A human-readable description of the error.</p>', 'ComputeFarmConfiguration$activeDirectoryUser' => '<p>The name of an Active Directory user that is used on ComputeFarm worker instances.</p>', 'ConflictException$code' => '<p>A more specific error code.</p>', 'ConflictException$message' => '<p>A human-readable description of the error.</p>', 'CreateLaunchProfileRequest$studioId' => '<p>The studio ID. </p>', 'CreateStreamingImageRequest$studioId' => '<p>The studio ID. </p>', 'CreateStreamingSessionRequest$launchProfileId' => '<p>The launch profile ID.</p>', 'CreateStreamingSessionRequest$ownedBy' => '<p>The user ID of the user that owns the streaming session.</p>', 'CreateStreamingSessionRequest$studioId' => '<p>The studio ID. </p>', 'CreateStreamingSessionStreamRequest$sessionId' => '<p>The streaming session ID.</p>', 'CreateStreamingSessionStreamRequest$studioId' => '<p>The studio ID. </p>', 'CreateStudioComponentRequest$studioId' => '<p>The studio ID. </p>', 'CreateStudioRequest$adminRoleArn' => '<p>The IAM role that Studio Admins will assume when logging in to the Nimble Studio portal.</p>', 'CreateStudioRequest$userRoleArn' => '<p>The IAM role that Studio Users will assume when logging in to the Nimble Studio portal.</p>', 'DeleteLaunchProfileMemberRequest$launchProfileId' => '<p>The Launch Profile ID.</p>', 'DeleteLaunchProfileMemberRequest$principalId' => '<p>The principal ID. This currently supports a Amazon Web Services SSO UserId. </p>', 'DeleteLaunchProfileMemberRequest$studioId' => '<p>The studio ID. </p>', 'DeleteLaunchProfileRequest$launchProfileId' => '<p>The Launch Profile ID.</p>', 'DeleteLaunchProfileRequest$studioId' => '<p>The studio ID. </p>', 'DeleteStreamingImageRequest$streamingImageId' => '<p>The streaming image ID.</p>', 'DeleteStreamingImageRequest$studioId' => '<p>The studio ID. </p>', 'DeleteStreamingSessionRequest$sessionId' => '<p>The streaming session ID.</p>', 'DeleteStreamingSessionRequest$studioId' => '<p>The studio ID. </p>', 'DeleteStudioComponentRequest$studioComponentId' => '<p>The studio component ID.</p>', 'DeleteStudioComponentRequest$studioId' => '<p>The studio ID. </p>', 'DeleteStudioMemberRequest$principalId' => '<p>The principal ID. This currently supports a Amazon Web Services SSO UserId. </p>', 'DeleteStudioMemberRequest$studioId' => '<p>The studio ID. </p>', 'DeleteStudioRequest$studioId' => '<p>The studio ID. </p>', 'Eula$content' => '<p>The EULA content.</p>', 'EulaAcceptance$acceptedBy' => '<p>The ID of the person who accepted the EULA.</p>', 'EulaAcceptance$accepteeId' => '<p>The ID of the acceptee.</p>', 'EulaIdList$member' => NULL, 'ExceptionContext$key' => NULL, 'ExceptionContext$value' => NULL, 'GetEulaRequest$eulaId' => '<p>The EULA ID.</p>', 'GetLaunchProfileDetailsRequest$launchProfileId' => '<p>The Launch Profile ID.</p>', 'GetLaunchProfileDetailsRequest$studioId' => '<p>The studio ID. </p>', 'GetLaunchProfileInitializationRequest$launchProfileId' => '<p>The Launch Profile ID.</p>', 'GetLaunchProfileInitializationRequest$launchPurpose' => '<p>The launch purpose.</p>', 'GetLaunchProfileInitializationRequest$platform' => '<p>The platform where this Launch Profile will be used, either WINDOWS or LINUX.</p>', 'GetLaunchProfileInitializationRequest$studioId' => '<p>The studio ID. </p>', 'GetLaunchProfileMemberRequest$launchProfileId' => '<p>The Launch Profile ID.</p>', 'GetLaunchProfileMemberRequest$principalId' => '<p>The principal ID. This currently supports a Amazon Web Services SSO UserId. </p>', 'GetLaunchProfileMemberRequest$studioId' => '<p>The studio ID. </p>', 'GetLaunchProfileRequest$launchProfileId' => '<p>The Launch Profile ID.</p>', 'GetLaunchProfileRequest$studioId' => '<p>The studio ID. </p>', 'GetStreamingImageRequest$streamingImageId' => '<p>The streaming image ID.</p>', 'GetStreamingImageRequest$studioId' => '<p>The studio ID. </p>', 'GetStreamingSessionRequest$sessionId' => '<p>The streaming session ID.</p>', 'GetStreamingSessionRequest$studioId' => '<p>The studio ID. </p>', 'GetStreamingSessionStreamRequest$sessionId' => '<p>The streaming session ID.</p>', 'GetStreamingSessionStreamRequest$streamId' => '<p>The streaming session stream ID.</p>', 'GetStreamingSessionStreamRequest$studioId' => '<p>The studio ID. </p>', 'GetStudioComponentRequest$studioComponentId' => '<p>The studio component ID.</p>', 'GetStudioComponentRequest$studioId' => '<p>The studio ID. </p>', 'GetStudioMemberRequest$principalId' => '<p>The principal ID. This currently supports a Amazon Web Services SSO UserId. </p>', 'GetStudioMemberRequest$studioId' => '<p>The studio ID. </p>', 'GetStudioRequest$studioId' => '<p>The studio ID. </p>', 'InternalServerErrorException$code' => '<p>A more specific error code.</p>', 'InternalServerErrorException$message' => '<p>A human-readable description of the error.</p>', 'LaunchProfile$arn' => '<p>The ARN of the resource.</p>', 'LaunchProfile$createdBy' => '<p>The user ID of the user that created the launch profile.</p>', 'LaunchProfile$statusMessage' => '<p>The status message for the launch profile.</p>', 'LaunchProfile$updatedBy' => '<p>The user ID of the user that most recently updated the resource.</p>', 'LaunchProfileInitializationActiveDirectory$directoryName' => '<p>The directory name.</p>', 'LaunchProfileMembership$identityStoreId' => '<p>The ID of the identity store.</p>', 'LaunchProfileMembership$principalId' => '<p>The principal ID.</p>', 'LaunchProfileMembership$sid' => '<p>The Active Directory Security Identifier for this user, if available.</p>', 'LaunchProfileStudioComponentIdList$member' => NULL, 'ListEulaAcceptancesRequest$nextToken' => '<p>The token to request the next page of results. </p>', 'ListEulaAcceptancesRequest$studioId' => '<p>The studio ID. </p>', 'ListEulaAcceptancesResponse$nextToken' => '<p>The token for the next set of results, or null if there are no more results.</p>', 'ListEulasRequest$nextToken' => '<p>The token to request the next page of results. </p>', 'ListEulasResponse$nextToken' => '<p>The token for the next set of results, or null if there are no more results.</p>', 'ListLaunchProfileMembersRequest$launchProfileId' => '<p>The Launch Profile ID.</p>', 'ListLaunchProfileMembersRequest$nextToken' => '<p>The token to request the next page of results. </p>', 'ListLaunchProfileMembersRequest$studioId' => '<p>The studio ID. </p>', 'ListLaunchProfileMembersResponse$nextToken' => '<p>The token for the next set of results, or null if there are no more results.</p>', 'ListLaunchProfilesRequest$nextToken' => '<p>The token to request the next page of results. </p>', 'ListLaunchProfilesRequest$principalId' => '<p>The principal ID. This currently supports a Amazon Web Services SSO UserId. </p>', 'ListLaunchProfilesRequest$studioId' => '<p>The studio ID. </p>', 'ListLaunchProfilesResponse$nextToken' => '<p>The token for the next set of results, or null if there are no more results.</p>', 'ListStreamingImagesRequest$nextToken' => '<p>The token to request the next page of results. </p>', 'ListStreamingImagesRequest$owner' => '<p>Filter this request to streaming images with the given owner</p>', 'ListStreamingImagesRequest$studioId' => '<p>The studio ID. </p>', 'ListStreamingImagesResponse$nextToken' => '<p>The token for the next set of results, or null if there are no more results.</p>', 'ListStreamingSessionsRequest$createdBy' => '<p>Filters the request to streaming sessions created by the given user.</p>', 'ListStreamingSessionsRequest$nextToken' => '<p>The token to request the next page of results. </p>', 'ListStreamingSessionsRequest$ownedBy' => '<p>Filters the request to streaming session owned by the given user</p>', 'ListStreamingSessionsRequest$sessionIds' => '<p>Filters the request to only the provided session IDs.</p>', 'ListStreamingSessionsRequest$studioId' => '<p>The studio ID. </p>', 'ListStreamingSessionsResponse$nextToken' => '<p>The token for the next set of results, or null if there are no more results.</p>', 'ListStudioComponentsRequest$nextToken' => '<p>The token to request the next page of results. </p>', 'ListStudioComponentsRequest$studioId' => '<p>The studio ID. </p>', 'ListStudioComponentsResponse$nextToken' => '<p>The token for the next set of results, or null if there are no more results.</p>', 'ListStudioMembersRequest$nextToken' => '<p>The token to request the next page of results. </p>', 'ListStudioMembersRequest$studioId' => '<p>The studio ID. </p>', 'ListStudioMembersResponse$nextToken' => '<p>The token for the next set of results, or null if there are no more results.</p>', 'ListStudiosRequest$nextToken' => '<p>The token to request the next page of results. </p>', 'ListStudiosResponse$nextToken' => '<p>The token for the next set of results, or null if there are no more results.</p>', 'ListTagsForResourceRequest$resourceArn' => '<p>The Amazon Resource Name (ARN) of the resource for which you want to list tags.</p>', 'NewLaunchProfileMember$principalId' => '<p>The principal ID.</p>', 'NewStudioMember$principalId' => '<p>The principal ID.</p>', 'PutLaunchProfileMembersRequest$identityStoreId' => '<p>The ID of the identity store.</p>', 'PutLaunchProfileMembersRequest$launchProfileId' => '<p>The Launch Profile ID.</p>', 'PutLaunchProfileMembersRequest$studioId' => '<p>The studio ID. </p>', 'PutStudioMembersRequest$identityStoreId' => '<p>The ID of the identity store.</p>', 'PutStudioMembersRequest$studioId' => '<p>The studio ID. </p>', 'ResourceNotFoundException$code' => '<p>A more specific error code.</p>', 'ResourceNotFoundException$message' => '<p>A human-readable description of the error.</p>', 'ServiceQuotaExceededException$code' => '<p>A more specific error code.</p>', 'ServiceQuotaExceededException$message' => '<p>A human-readable description of the error.</p>', 'SharedFileSystemConfiguration$fileSystemId' => '<p>The unique identifier for a file system.</p>', 'StartStreamingSessionRequest$sessionId' => '<p>The streaming session ID for the StartStreamingSessionRequest.</p>', 'StartStreamingSessionRequest$studioId' => '<p>The studio ID for the StartStreamingSessionRequest.</p>', 'StartStudioSSOConfigurationRepairRequest$studioId' => '<p>The studio ID. </p>', 'StopStreamingSessionRequest$sessionId' => '<p>The streaming session ID for the StopStreamingSessionRequest.</p>', 'StopStreamingSessionRequest$studioId' => '<p>The studioId for the StopStreamingSessionRequest.</p>', 'StreamingImage$arn' => '<p>The ARN of the resource.</p>', 'StreamingImage$statusMessage' => '<p>The status message for the streaming image.</p>', 'StreamingSession$arn' => '<p>The ARN of the resource.</p>', 'StreamingSession$createdBy' => '<p>The user ID of the user that created the streaming session.</p>', 'StreamingSession$ec2InstanceType' => '<p>The EC2 Instance type used for the streaming session.</p>', 'StreamingSession$launchProfileId' => '<p>The ID of the launch profile used to control access from the streaming session.</p>', 'StreamingSession$ownedBy' => '<p>The user ID of the user that owns the streaming session.</p>', 'StreamingSession$startedBy' => '<p>The user ID of the user that started the streaming session.</p>', 'StreamingSession$statusMessage' => '<p>The status message for the streaming session.</p>', 'StreamingSession$stoppedBy' => '<p>The user ID of the user that stopped the streaming session.</p>', 'StreamingSession$updatedBy' => '<p>The user ID of the user that most recently updated the resource.</p>', 'StreamingSessionStream$createdBy' => '<p>The user ID of the user that created the streaming session stream.</p>', 'StreamingSessionStream$ownedBy' => '<p>The user ID of the user that owns the streaming session.</p>', 'StreamingSessionStream$streamId' => '<p>The stream ID.</p>', 'StringList$member' => NULL, 'Studio$adminRoleArn' => '<p>The IAM role that studio admins assume when logging in to the Nimble Studio portal.</p>', 'Studio$arn' => '<p>The Amazon Resource Name (ARN) that is assigned to a studio resource and uniquely identifies it. ARNs are unique across all Regions.</p>', 'Studio$ssoClientId' => '<p>The Amazon Web Services SSO application client ID used to integrate with Amazon Web Services SSO to enable Amazon Web Services SSO users to log in to Nimble Studio portal.</p>', 'Studio$statusMessage' => '<p>Additional detail on the studio state.</p>', 'Studio$studioId' => '<p>The unique identifier for a studio resource. In Nimble Studio, all other resources are contained in a studio resource.</p>', 'Studio$studioUrl' => '<p>The address of the web page for the studio.</p>', 'Studio$userRoleArn' => '<p>The IAM role that studio users assume when logging in to the Nimble Studio portal.</p>', 'StudioComponent$arn' => '<p>The ARN of the resource.</p>', 'StudioComponent$createdBy' => '<p>The user ID of the user that created the studio component.</p>', 'StudioComponent$statusMessage' => '<p>The status message for the studio component.</p>', 'StudioComponent$updatedBy' => '<p>The user ID of the user that most recently updated the resource.</p>', 'StudioComponentSummary$createdBy' => '<p>The user ID of the user that created the studio component.</p>', 'StudioComponentSummary$updatedBy' => '<p>The user ID of the user that most recently updated the resource.</p>', 'StudioMembership$identityStoreId' => '<p>The ID of the identity store.</p>', 'StudioMembership$principalId' => '<p>The principal ID.</p>', 'StudioMembership$sid' => '<p>The Active Directory Security Identifier for this user, if available.</p>', 'TagResourceRequest$resourceArn' => '<p> The Amazon Resource Name (ARN) of the resource you want to add tags to. </p>', 'Tags$key' => NULL, 'Tags$value' => NULL, 'ThrottlingException$code' => '<p>A more specific error code.</p>', 'ThrottlingException$message' => '<p>A human-readable description of the error.</p>', 'UntagResourceRequest$resourceArn' => '<p>Identifies the Amazon Resource Name(ARN) key from which you are removing tags. </p>', 'UpdateLaunchProfileMemberRequest$launchProfileId' => '<p>The Launch Profile ID.</p>', 'UpdateLaunchProfileMemberRequest$principalId' => '<p>The principal ID. This currently supports a Amazon Web Services SSO UserId. </p>', 'UpdateLaunchProfileMemberRequest$studioId' => '<p>The studio ID. </p>', 'UpdateLaunchProfileRequest$launchProfileId' => '<p>The Launch Profile ID.</p>', 'UpdateLaunchProfileRequest$studioId' => '<p>The studio ID. </p>', 'UpdateStreamingImageRequest$streamingImageId' => '<p>The streaming image ID.</p>', 'UpdateStreamingImageRequest$studioId' => '<p>The studio ID. </p>', 'UpdateStudioComponentRequest$studioComponentId' => '<p>The studio component ID.</p>', 'UpdateStudioComponentRequest$studioId' => '<p>The studio ID. </p>', 'UpdateStudioRequest$adminRoleArn' => '<p>The IAM role that Studio Admins will assume when logging in to the Nimble Studio portal.</p>', 'UpdateStudioRequest$studioId' => '<p>The studio ID. </p>', 'UpdateStudioRequest$userRoleArn' => '<p>The IAM role that Studio Users will assume when logging in to the Nimble Studio portal.</p>', 'ValidationException$code' => '<p>A more specific error code.</p>', 'ValidationException$message' => '<p>A human-readable description of the error.</p>', ], ], 'StringList' => [ 'base' => NULL, 'refs' => [ 'GetLaunchProfileInitializationRequest$launchProfileProtocolVersions' => '<p>The launch profile protocol versions supported by the client.</p>', 'ListEulaAcceptancesRequest$eulaIds' => '<p>The list of EULA IDs that have been previously accepted.</p>', 'ListEulasRequest$eulaIds' => '<p>The list of EULA IDs that should be returned</p>', 'ListLaunchProfilesRequest$states' => '<p>Filter this request to launch profiles in any of the given states.</p>', 'ListStudioComponentsRequest$states' => '<p>Filters the request to studio components that are in one of the given states. </p>', 'ListStudioComponentsRequest$types' => '<p>Filters the request to studio components that are of one of the given types.</p>', 'UntagResourceRequest$tagKeys' => '<p>One or more tag keys. Specify only the tag keys, not the tag values.</p>', ], ], 'Studio' => [ 'base' => '<p>Represents a studio resource.</p> <p>A studio is the core resource used with Nimble Studio. You must create a studio first, before any other resource type can be created. All other resources you create and manage in Nimble Studio are contained within a studio.</p> <p>When creating a studio, you must provides two IAM roles for use with the Nimble Studio portal. These roles are assumed by your users when they log in to the Nimble Studio portal via Amazon Web Services SSO and your identity source.</p> <p>The user role must have the AmazonNimbleStudio-StudioUser managed policy attached for the portal to function properly.</p> <p>The admin role must have the AmazonNimbleStudio-StudioAdmin managed policy attached for the portal to function properly.</p> <p>Your studio roles must trust the identity.nimble.amazonaws.com service principal to function properly.</p>', 'refs' => [ 'CreateStudioResponse$studio' => '<p>Information about a studio.</p>', 'DeleteStudioResponse$studio' => '<p>Information about a studio.</p>', 'GetStudioResponse$studio' => '<p>Information about a studio.</p>', 'StartStudioSSOConfigurationRepairResponse$studio' => '<p>Information about a studio.</p>', 'StudioList$member' => NULL, 'UpdateStudioResponse$studio' => '<p>Information about a studio.</p>', ], ], 'StudioComponent' => [ 'base' => '<p>A studio component represents a network resource to be used by a studio\'s users and workflows. A typical studio contains studio components for each of the following: render farm, Active Directory, licensing, and file system.</p> <p>Access to a studio component is managed by specifying security groups for the resource, as well as its endpoint.</p> <p>A studio component also has a set of initialization scripts that are returned by <code>GetLaunchProfileInitialization</code>. These initialization scripts run on streaming sessions when they start. They provide users with flexibility in controlling how the studio resources are configured on a streaming session.</p>', 'refs' => [ 'CreateStudioComponentResponse$studioComponent' => '<p>Information about the studio component.</p>', 'DeleteStudioComponentResponse$studioComponent' => '<p>Information about the studio component.</p>', 'GetStudioComponentResponse$studioComponent' => '<p>Information about the studio component.</p>', 'StudioComponentList$member' => NULL, 'UpdateStudioComponentResponse$studioComponent' => '<p>Information about the studio component.</p>', ], ], 'StudioComponentConfiguration' => [ 'base' => '<p>The configuration of the studio component, based on component type.</p>', 'refs' => [ 'CreateStudioComponentRequest$configuration' => '<p>The configuration of the studio component, based on component type.</p>', 'StudioComponent$configuration' => '<p>The configuration of the studio component, based on component type.</p>', 'UpdateStudioComponentRequest$configuration' => '<p>The configuration of the studio component, based on component type.</p>', ], ], 'StudioComponentDescription' => [ 'base' => '<zonbook></zonbook><xhtml></xhtml>', 'refs' => [ 'CreateStudioComponentRequest$description' => '<p>The description.</p>', 'StudioComponent$description' => '<p>A human-readable description for the studio component resource.</p>', 'StudioComponentSummary$description' => '<p>The description.</p>', 'UpdateStudioComponentRequest$description' => '<p>The description.</p>', ], ], 'StudioComponentId' => [ 'base' => '<zonbook></zonbook><xhtml></xhtml>', 'refs' => [ 'LaunchProfileInitializationActiveDirectory$studioComponentId' => '<p>The unique identifier for a studio component resource.</p>', 'LaunchProfileInitializationScript$studioComponentId' => '<p>The unique identifier for a studio component resource.</p>', 'StudioComponent$studioComponentId' => '<p>The unique identifier for a studio component resource.</p>', 'StudioComponentSummary$studioComponentId' => '<p>The unique identifier for a studio component resource.</p>', ], ], 'StudioComponentInitializationScript' => [ 'base' => '<p>Initialization scripts for studio components.</p>', 'refs' => [ 'StudioComponentInitializationScriptList$member' => NULL, ], ], 'StudioComponentInitializationScriptContent' => [ 'base' => '<zonbook></zonbook><xhtml></xhtml>', 'refs' => [ 'LaunchProfileInitializationScript$script' => '<p>The initialization script.</p>', 'StudioComponentInitializationScript$script' => '<p>The initialization script.</p>', ], ], 'StudioComponentInitializationScriptList' => [ 'base' => '<zonbook></zonbook><xhtml></xhtml>', 'refs' => [ 'CreateStudioComponentRequest$initializationScripts' => '<p>Initialization scripts for studio components.</p>', 'StudioComponent$initializationScripts' => '<p>Initialization scripts for studio components.</p>', 'UpdateStudioComponentRequest$initializationScripts' => '<p>Initialization scripts for studio components.</p>', ], ], 'StudioComponentInitializationScriptRunContext' => [ 'base' => '<zonbook></zonbook><xhtml></xhtml>', 'refs' => [ 'StudioComponentInitializationScript$runContext' => '<p>The method to use when running the initialization script.</p>', ], ], 'StudioComponentList' => [ 'base' => '<zonbook></zonbook><xhtml></xhtml>', 'refs' => [ 'ListStudioComponentsResponse$studioComponents' => '<p>A collection of studio components.</p>', ], ], 'StudioComponentName' => [ 'base' => '<zonbook></zonbook><xhtml></xhtml>', 'refs' => [ 'CreateStudioComponentRequest$name' => '<p>The name for the studio component.</p>', 'LaunchProfileInitializationActiveDirectory$studioComponentName' => '<p>The name for the studio component.</p>', 'LaunchProfileInitializationScript$studioComponentName' => '<p>The name for the studio component.</p>', 'StudioComponent$name' => '<p>A friendly name for the studio component resource.</p>', 'StudioComponentSummary$name' => '<p>The name for the studio component.</p>', 'UpdateStudioComponentRequest$name' => '<p>The name for the studio component.</p>', ], ], 'StudioComponentScriptParameterKeyValueList' => [ 'base' => '<zonbook></zonbook><xhtml></xhtml>', 'refs' => [ 'CreateStudioComponentRequest$scriptParameters' => '<p>Parameters for the studio component scripts.</p>', 'StudioComponent$scriptParameters' => '<p>Parameters for the studio component scripts.</p>', 'UpdateStudioComponentRequest$scriptParameters' => '<p>Parameters for the studio component scripts.</p>', ], ], 'StudioComponentSecurityGroupIdList' => [ 'base' => '<zonbook></zonbook><xhtml></xhtml>', 'refs' => [ 'CreateStudioComponentRequest$ec2SecurityGroupIds' => '<p>The EC2 security groups that control access to the studio component.</p>', 'StudioComponent$ec2SecurityGroupIds' => '<p>The EC2 security groups that control access to the studio component.</p>', 'UpdateStudioComponentRequest$ec2SecurityGroupIds' => '<p>The EC2 security groups that control access to the studio component.</p>', ], ], 'StudioComponentState' => [ 'base' => '<p>The current state of the studio component resource.</p> <p>While a studio component is being created, modified, or deleted, its state will equal "CREATE_IN_PROGRESS", "UPDATE_IN_PROGRESS", or "DELETE_IN_PROGRESS"</p> <p>These are called \'transition states\'.</p> <p>No modifications may be made to the studio component while it is in a transition state.</p> <p>If creation of the resource fails, the state will change to `CREATE_FAILED`. The resource StatusCode and StatusMessage will provide more information of why creation failed. The resource in this state will automatically be deleted from your account after a period of time.</p> <p>If updating the resource fails, the state will change to `UPDATE_FAILED`. The resource StatusCode and StatusMessage will provide more information of why the update failed. The resource will be returned to the state it was in when the update request was invoked.</p> <p>If deleting the resource fails, the state will change to `DELETE_FAILED`. The resource StatusCode and StatusMessage will provide more information of why the update failed. The resource will be returned to the state it was in when the update request was invoked. After the resource is deleted successfully, it will change to the "DELETED" state. The resource will no longer count against service quotas and cannot be used or acted upon any futher. It will be removed from your account after a period of time.</p>', 'refs' => [ 'StudioComponent$state' => '<p>The current state.</p>', ], ], 'StudioComponentStatusCode' => [ 'base' => '<p>The current status of the studio component resource.</p> <p>When the resource is in the \'READY\' state, the status code signals what the last mutation made to the resource was.</p> <p>When the resource is in a CREATE_FAILED/UPDATE_FAILED/DELETE_FAILED state, the status code signals what went wrong and why the mutation failed.</p>', 'refs' => [ 'StudioComponent$statusCode' => '<p>The status code.</p>', ], ], 'StudioComponentSubtype' => [ 'base' => '<zonbook></zonbook><xhtml></xhtml>', 'refs' => [ 'CreateStudioComponentRequest$subtype' => '<p>The specific subtype of a studio component.</p>', 'StudioComponent$subtype' => '<p>The specific subtype of a studio component.</p>', 'StudioComponentSummary$subtype' => '<p>The specific subtype of a studio component.</p>', 'UpdateStudioComponentRequest$subtype' => '<p>The specific subtype of a studio component.</p>', ], ], 'StudioComponentSummary' => [ 'base' => '<p/>', 'refs' => [ 'StudioComponentSummaryList$member' => NULL, ], ], 'StudioComponentSummaryList' => [ 'base' => '<zonbook></zonbook><xhtml></xhtml>', 'refs' => [ 'GetLaunchProfileDetailsResponse$studioComponentSummaries' => '<p>A collection of studio component summaries.</p>', ], ], 'StudioComponentType' => [ 'base' => '<zonbook></zonbook><xhtml></xhtml>', 'refs' => [ 'CreateStudioComponentRequest$type' => '<p>The type of the studio component.</p>', 'StudioComponent$type' => '<p>The type of the studio component.</p>', 'StudioComponentSummary$type' => '<p>The type of the studio component.</p>', 'UpdateStudioComponentRequest$type' => '<p>The type of the studio component.</p>', ], ], 'StudioEncryptionConfiguration' => [ 'base' => '<p>Configuration of the encryption method that is used for the studio.</p>', 'refs' => [ 'CreateStudioRequest$studioEncryptionConfiguration' => '<p>The studio encryption configuration.</p>', 'Studio$studioEncryptionConfiguration' => '<p>Configuration of the encryption method that is used for the studio.</p>', ], ], 'StudioEncryptionConfigurationKeyArn' => [ 'base' => '<p>The Amazon Resource Name (ARN) for a KMS key that is used to encrypt studio data.</p>', 'refs' => [ 'StudioEncryptionConfiguration$keyArn' => '<p>The ARN for a KMS key that is used to encrypt studio data.</p>', ], ], 'StudioEncryptionConfigurationKeyType' => [ 'base' => '<p>The type of KMS key that is used to encrypt studio data.</p>', 'refs' => [ 'StudioEncryptionConfiguration$keyType' => '<p>The type of KMS key that is used to encrypt studio data.</p>', ], ], 'StudioList' => [ 'base' => '<zonbook></zonbook><xhtml></xhtml>', 'refs' => [ 'ListStudiosResponse$studios' => '<p>A collection of studios.</p>', ], ], 'StudioMembership' => [ 'base' => '<p>A studio member is an association of a user from your studio identity source to elevated permissions that they are granted in the studio.</p> <p>When you add a user to your studio using the Nimble Studio console, they are given access to the studio\'s AWS SSO application and are given access to log in to the Nimble Studio portal. These users have the permissions provided by the studio\'s user IAM role and do not appear in the studio membership collection. Only studio admins appear in studio membership.</p> <p>When you add a user to studio membership with the persona ADMIN, upon logging in to the Nimble Studio portal, they are granted permissions specified by the Studio\'s Admin IAM role.</p>', 'refs' => [ 'GetStudioMemberResponse$member' => '<p>The member.</p>', 'StudioMembershipList$member' => NULL, ], ], 'StudioMembershipList' => [ 'base' => '<zonbook></zonbook><xhtml></xhtml>', 'refs' => [ 'ListStudioMembersResponse$members' => '<p>A list of members.</p>', ], ], 'StudioName' => [ 'base' => '<zonbook></zonbook><xhtml></xhtml>', 'refs' => [ 'CreateStudioRequest$studioName' => '<p>The studio name that is used in the URL of the Nimble Studio portal when accessed by Nimble Studio users.</p>', 'Studio$studioName' => '<p>The name of the studio, as included in the URL when accessing it in the Nimble Studio portal.</p>', ], ], 'StudioPersona' => [ 'base' => '<zonbook></zonbook><xhtml></xhtml>', 'refs' => [ 'NewStudioMember$persona' => '<p>The persona.</p>', 'StudioMembership$persona' => '<p>The persona.</p>', ], ], 'StudioState' => [ 'base' => '<zonbook></zonbook><xhtml></xhtml>', 'refs' => [ 'Studio$state' => '<p>The current state of the studio resource.</p>', ], ], 'StudioStatusCode' => [ 'base' => '<p>The status code.</p>', 'refs' => [ 'Studio$statusCode' => '<p>Status codes that provide additional detail on the studio state.</p>', ], ], 'SyntheticComputeFarmConfigurationString' => [ 'base' => NULL, 'refs' => [ 'ComputeFarmConfiguration$endpoint' => '<p>The endpoint of the ComputeFarm that is accessed by the studio component resource.</p>', ], ], 'SyntheticCreateStreamingImageRequestStreamingImageDescription' => [ 'base' => '<p>The description.</p>', 'refs' => [ 'CreateStreamingImageRequest$description' => '<p>A human-readable description of the streaming image.</p>', ], ], 'SyntheticCreateStreamingImageRequestStreamingImageName' => [ 'base' => '<p>A friendly name for a streaming image resource.</p>', 'refs' => [ 'CreateStreamingImageRequest$name' => '<p>A friendly name for a streaming image resource.</p>', ], ], 'SyntheticCreateStudioRequestStudioDisplayName' => [ 'base' => '<zonbook></zonbook><xhtml></xhtml>', 'refs' => [ 'CreateStudioRequest$displayName' => '<p>A friendly name for the studio.</p>', ], ], 'SyntheticLicenseServiceConfigurationString' => [ 'base' => NULL, 'refs' => [ 'LicenseServiceConfiguration$endpoint' => '<p>The endpoint of the license service that is accessed by the studio component resource.</p>', ], ], 'SyntheticSharedFileSystemConfigurationString' => [ 'base' => NULL, 'refs' => [ 'SharedFileSystemConfiguration$endpoint' => '<p>The endpoint of the shared file system that is accessed by the studio component resource.</p>', 'SharedFileSystemConfiguration$shareName' => '<p>The name of the file share.</p>', ], ], 'SyntheticStreamingImageStreamingImageDescription' => [ 'base' => '<p>The description.</p>', 'refs' => [ 'StreamingImage$description' => '<p>A human-readable description of the streaming image.</p>', ], ], 'SyntheticStreamingImageStreamingImageName' => [ 'base' => '<p>A friendly name for a streaming image resource.</p>', 'refs' => [ 'StreamingImage$name' => '<p>A friendly name for a streaming image resource.</p>', ], ], 'SyntheticStreamingSessionStreamString' => [ 'base' => NULL, 'refs' => [ 'StreamingSessionStream$url' => '<p>The URL to connect to this stream using the DCV client.</p>', ], ], 'SyntheticStudioStudioDisplayName' => [ 'base' => '<zonbook></zonbook><xhtml></xhtml>', 'refs' => [ 'Studio$displayName' => '<p>A friendly name for the studio.</p>', ], ], 'SyntheticUpdateStreamingImageRequestStreamingImageDescription' => [ 'base' => '<p>The description.</p>', 'refs' => [ 'UpdateStreamingImageRequest$description' => '<p>The description.</p>', ], ], 'SyntheticUpdateStreamingImageRequestStreamingImageName' => [ 'base' => '<p>A friendly name for a streaming image resource.</p>', 'refs' => [ 'UpdateStreamingImageRequest$name' => '<p>The name for the streaming image.</p>', ], ], 'SyntheticUpdateStudioRequestStudioDisplayName' => [ 'base' => '<zonbook></zonbook><xhtml></xhtml>', 'refs' => [ 'UpdateStudioRequest$displayName' => '<p>A friendly name for the studio.</p>', ], ], 'TagResourceRequest' => [ 'base' => '<p/>', 'refs' => [], ], 'TagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'Tags' => [ 'base' => '<zonbook></zonbook><xhtml></xhtml>', 'refs' => [ 'CreateLaunchProfileRequest$tags' => '<p>A collection of labels, in the form of key:value pairs, that apply to this resource.</p>', 'CreateStreamingImageRequest$tags' => '<p>A collection of labels, in the form of key:value pairs, that apply to this resource.</p>', 'CreateStreamingSessionRequest$tags' => '<p>A collection of labels, in the form of key:value pairs, that apply to this resource.</p>', 'CreateStudioComponentRequest$tags' => '<p>A collection of labels, in the form of key:value pairs, that apply to this resource.</p>', 'CreateStudioRequest$tags' => '<p>A collection of labels, in the form of key:value pairs, that apply to this resource.</p>', 'LaunchProfile$tags' => '<p>A collection of labels, in the form of key:value pairs, that apply to this resource.</p>', 'ListTagsForResourceResponse$tags' => '<p>A collection of labels, in the form of key:value pairs, that apply to this resource.</p>', 'StreamingImage$tags' => '<p>A collection of labels, in the form of key:value pairs, that apply to this resource.</p>', 'StreamingSession$tags' => '<p>A collection of labels, in the form of key:value pairs, that apply to this resource.</p>', 'Studio$tags' => '<p>A collection of labels, in the form of key:value pairs, that apply to this resource.</p>', 'StudioComponent$tags' => '<p>A collection of labels, in the form of key:value pairs, that apply to this resource.</p>', 'TagResourceRequest$tags' => '<p>A collection of labels, in the form of key:value pairs, that apply to this resource.</p>', ], ], 'ThrottlingException' => [ 'base' => '<p>The request throughput limit was exceeded.</p>', 'refs' => [], ], 'Timestamp' => [ 'base' => '<zonbook></zonbook><xhtml></xhtml>', 'refs' => [ 'Eula$createdAt' => '<p>The Unix epoch timestamp in seconds for when the resource was created.</p>', 'Eula$updatedAt' => '<p>The Unix epoch timestamp in seconds for when the resource was updated.</p>', 'EulaAcceptance$acceptedAt' => '<p>The Unix epoch timestamp in seconds for when the EULA was accepted.</p>', 'LaunchProfile$createdAt' => '<p>The Unix epoch timestamp in seconds for when the resource was created.</p>', 'LaunchProfile$updatedAt' => '<p>The Unix epoch timestamp in seconds for when the resource was updated.</p>', 'StreamingSession$createdAt' => '<p>The Unix epoch timestamp in seconds for when the resource was created.</p>', 'StreamingSession$startedAt' => '<p>The time the session entered START_IN_PROGRESS state.</p>', 'StreamingSession$stopAt' => '<p>The time the streaming session will automatically be stopped if the user doesn’t stop the session themselves. </p>', 'StreamingSession$stoppedAt' => '<p>The time the session entered STOP_IN_PROGRESS state.</p>', 'StreamingSession$terminateAt' => '<p>The time the streaming session will automatically terminate if not terminated by the user.</p>', 'StreamingSession$updatedAt' => '<p>The Unix epoch timestamp in seconds for when the resource was updated.</p>', 'StreamingSessionStream$createdAt' => '<p>The Unix epoch timestamp in seconds for when the resource was created.</p>', 'StreamingSessionStream$expiresAt' => '<p>The Unix epoch timestamp in seconds for when the resource expires.</p>', 'Studio$createdAt' => '<p>The Unix epoch timestamp in seconds for when the resource was created.</p>', 'Studio$updatedAt' => '<p>The Unix epoch timestamp in seconds for when the resource was updated.</p>', 'StudioComponent$createdAt' => '<p>The Unix epoch timestamp in seconds for when the resource was created.</p>', 'StudioComponent$updatedAt' => '<p>The Unix epoch timestamp in seconds for when the resource was updated.</p>', 'StudioComponentSummary$createdAt' => '<p>The Unix epoch timestamp in seconds for when the resource was created.</p>', 'StudioComponentSummary$updatedAt' => '<p>The Unix epoch timestamp in seconds for when the resource was updated.</p>', ], ], 'UntagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'UntagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateLaunchProfileMemberRequest' => [ 'base' => '<p/>', 'refs' => [], ], 'UpdateLaunchProfileMemberResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateLaunchProfileRequest' => [ 'base' => '<zonbook></zonbook><xhtml></xhtml>', 'refs' => [], ], 'UpdateLaunchProfileResponse' => [ 'base' => '<zonbook></zonbook><xhtml></xhtml>', 'refs' => [], ], 'UpdateStreamingImageRequest' => [ 'base' => '<zonbook></zonbook><xhtml></xhtml>', 'refs' => [], ], 'UpdateStreamingImageResponse' => [ 'base' => '<p/>', 'refs' => [], ], 'UpdateStudioComponentRequest' => [ 'base' => '<zonbook></zonbook><xhtml></xhtml>', 'refs' => [], ], 'UpdateStudioComponentResponse' => [ 'base' => '<zonbook></zonbook><xhtml></xhtml>', 'refs' => [], ], 'UpdateStudioRequest' => [ 'base' => '<zonbook></zonbook><xhtml></xhtml>', 'refs' => [], ], 'UpdateStudioResponse' => [ 'base' => '<zonbook></zonbook><xhtml></xhtml>', 'refs' => [], ], 'ValidationException' => [ 'base' => '<p>One of the parameters in the request is invalid.</p>', 'refs' => [], ], 'WindowsMountDrive' => [ 'base' => '<zonbook></zonbook><xhtml></xhtml>', 'refs' => [ 'SharedFileSystemConfiguration$windowsMountDrive' => '<p>The mount location for a shared file system on a Windows virtual workstation.</p>', ], ], ],];
