<?php
// This file was auto-generated from sdk-root/src/data/networkmanager/2019-07-05/docs-2.json
return [ 'version' => '2.0', 'service' => '<p>Transit Gateway Network Manager (Network Manager) enables you to create a global network, in which you can monitor your Amazon Web Services and on-premises networks that are built around transit gateways.</p>', 'operations' => [ 'AssociateCustomerGateway' => '<p>Associates a customer gateway with a device and optionally, with a link. If you specify a link, it must be associated with the specified device. </p> <p>You can only associate customer gateways that are connected to a VPN attachment on a transit gateway. The transit gateway must be registered in your global network. When you register a transit gateway, customer gateways that are connected to the transit gateway are automatically included in the global network. To list customer gateways that are connected to a transit gateway, use the <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeVpnConnections.html">DescribeVpnConnections</a> EC2 API and filter by <code>transit-gateway-id</code>.</p> <p>You cannot associate a customer gateway with more than one device and link. </p>', 'AssociateLink' => '<p>Associates a link to a device. A device can be associated to multiple links and a link can be associated to multiple devices. The device and link must be in the same global network and the same site.</p>', 'AssociateTransitGatewayConnectPeer' => '<p>Associates a transit gateway Connect peer with a device, and optionally, with a link. If you specify a link, it must be associated with the specified device. </p> <p>You can only associate transit gateway Connect peers that have been created on a transit gateway that\'s registered in your global network.</p> <p>You cannot associate a transit gateway Connect peer with more than one device and link. </p>', 'CreateConnection' => '<p>Creates a connection between two devices. The devices can be a physical or virtual appliance that connects to a third-party appliance in a VPC, or a physical appliance that connects to another physical appliance in an on-premises network.</p>', 'CreateDevice' => '<p>Creates a new device in a global network. If you specify both a site ID and a location, the location of the site is used for visualization in the Network Manager console.</p>', 'CreateGlobalNetwork' => '<p>Creates a new, empty global network.</p>', 'CreateLink' => '<p>Creates a new link for a specified site.</p>', 'CreateSite' => '<p>Creates a new site in a global network.</p>', 'DeleteConnection' => '<p>Deletes the specified connection in your global network.</p>', 'DeleteDevice' => '<p>Deletes an existing device. You must first disassociate the device from any links and customer gateways.</p>', 'DeleteGlobalNetwork' => '<p>Deletes an existing global network. You must first delete all global network objects (devices, links, and sites) and deregister all transit gateways.</p>', 'DeleteLink' => '<p>Deletes an existing link. You must first disassociate the link from any devices and customer gateways.</p>', 'DeleteSite' => '<p>Deletes an existing site. The site cannot be associated with any device or link.</p>', 'DeregisterTransitGateway' => '<p>Deregisters a transit gateway from your global network. This action does not delete your transit gateway, or modify any of its attachments. This action removes any customer gateway associations.</p>', 'DescribeGlobalNetworks' => '<p>Describes one or more global networks. By default, all global networks are described. To describe the objects in your global network, you must use the appropriate <code>Get*</code> action. For example, to list the transit gateways in your global network, use <a>GetTransitGatewayRegistrations</a>.</p>', 'DisassociateCustomerGateway' => '<p>Disassociates a customer gateway from a device and a link.</p>', 'DisassociateLink' => '<p>Disassociates an existing device from a link. You must first disassociate any customer gateways that are associated with the link.</p>', 'DisassociateTransitGatewayConnectPeer' => '<p>Disassociates a transit gateway Connect peer from a device and link.</p>', 'GetConnections' => '<p>Gets information about one or more of your connections in a global network.</p>', 'GetCustomerGatewayAssociations' => '<p>Gets the association information for customer gateways that are associated with devices and links in your global network.</p>', 'GetDevices' => '<p>Gets information about one or more of your devices in a global network.</p>', 'GetLinkAssociations' => '<p>Gets the link associations for a device or a link. Either the device ID or the link ID must be specified.</p>', 'GetLinks' => '<p>Gets information about one or more links in a specified global network.</p> <p>If you specify the site ID, you cannot specify the type or provider in the same request. You can specify the type and provider in the same request.</p>', 'GetNetworkResourceCounts' => '<p>Gets the count of network resources, by resource type, for the specified global network.</p>', 'GetNetworkResourceRelationships' => '<p>Gets the network resource relationships for the specified global network.</p>', 'GetNetworkResources' => '<p>Describes the network resources for the specified global network.</p> <p>The results include information from the corresponding Describe call for the resource, minus any sensitive information such as pre-shared keys.</p>', 'GetNetworkRoutes' => '<p>Gets the network routes of the specified global network.</p>', 'GetNetworkTelemetry' => '<p>Gets the network telemetry of the specified global network.</p>', 'GetRouteAnalysis' => '<p>Gets information about the specified route analysis.</p>', 'GetSites' => '<p>Gets information about one or more of your sites in a global network.</p>', 'GetTransitGatewayConnectPeerAssociations' => '<p>Gets information about one or more of your transit gateway Connect peer associations in a global network.</p>', 'GetTransitGatewayRegistrations' => '<p>Gets information about the transit gateway registrations in a specified global network.</p>', 'ListTagsForResource' => '<p>Lists the tags for a specified resource.</p>', 'RegisterTransitGateway' => '<p>Registers a transit gateway in your global network. The transit gateway can be in any Amazon Web Services Region, but it must be owned by the same Amazon Web Services account that owns the global network. You cannot register a transit gateway in more than one global network.</p>', 'StartRouteAnalysis' => '<p>Starts analyzing the routing path between the specified source and destination. For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/tgw/route-analyzer.html">Route Analyzer</a>.</p>', 'TagResource' => '<p>Tags a specified resource.</p>', 'UntagResource' => '<p>Removes tags from a specified resource.</p>', 'UpdateConnection' => '<p>Updates the information for an existing connection. To remove information for any of the parameters, specify an empty string.</p>', 'UpdateDevice' => '<p>Updates the details for an existing device. To remove information for any of the parameters, specify an empty string.</p>', 'UpdateGlobalNetwork' => '<p>Updates an existing global network. To remove information for any of the parameters, specify an empty string.</p>', 'UpdateLink' => '<p>Updates the details for an existing link. To remove information for any of the parameters, specify an empty string.</p>', 'UpdateNetworkResourceMetadata' => '<p>Updates the resource metadata for the specified global network.</p>', 'UpdateSite' => '<p>Updates the information for an existing site. To remove information for any of the parameters, specify an empty string.</p>', ], 'shapes' => [ 'AWSLocation' => [ 'base' => '<p>Specifies a location in Amazon Web Services.</p>', 'refs' => [ 'CreateDeviceRequest$AWSLocation' => '<p>The Amazon Web Services location of the device, if applicable. For an on-premises device, you can omit this parameter.</p>', 'Device$AWSLocation' => '<p>The Amazon Web Services location of the device.</p>', 'UpdateDeviceRequest$AWSLocation' => '<p>The Amazon Web Services location of the device, if applicable. For an on-premises device, you can omit this parameter.</p>', ], ], 'AccessDeniedException' => [ 'base' => '<p>You do not have sufficient access to perform this action.</p>', 'refs' => [], ], 'AssociateCustomerGatewayRequest' => [ 'base' => NULL, 'refs' => [], ], 'AssociateCustomerGatewayResponse' => [ 'base' => NULL, 'refs' => [], ], 'AssociateLinkRequest' => [ 'base' => NULL, 'refs' => [], ], 'AssociateLinkResponse' => [ 'base' => NULL, 'refs' => [], ], 'AssociateTransitGatewayConnectPeerRequest' => [ 'base' => NULL, 'refs' => [], ], 'AssociateTransitGatewayConnectPeerResponse' => [ 'base' => NULL, 'refs' => [], ], 'Bandwidth' => [ 'base' => '<p>Describes bandwidth information.</p>', 'refs' => [ 'CreateLinkRequest$Bandwidth' => '<p> The upload speed and download speed in Mbps. </p>', 'Link$Bandwidth' => '<p>The bandwidth for the link.</p>', 'UpdateLinkRequest$Bandwidth' => '<p>The upload and download speed in Mbps. </p>', ], ], 'Boolean' => [ 'base' => NULL, 'refs' => [ 'NetworkResourceSummary$IsMiddlebox' => '<p>Indicates whether this is a middlebox appliance.</p>', 'RouteAnalysis$IncludeReturnPath' => '<p>Indicates whether to analyze the return path. The return path is not analyzed if the forward path analysis does not succeed.</p>', 'RouteAnalysis$UseMiddleboxes' => '<p>Indicates whether to include the location of middlebox appliances in the route analysis.</p>', 'StartRouteAnalysisRequest$IncludeReturnPath' => '<p>Indicates whether to analyze the return path. The default is <code>false</code>.</p>', 'StartRouteAnalysisRequest$UseMiddleboxes' => '<p>Indicates whether to include the location of middlebox appliances in the route analysis. The default is <code>false</code>.</p>', ], ], 'ConflictException' => [ 'base' => '<p>There was a conflict processing the request. Updating or deleting the resource can cause an inconsistent state.</p>', 'refs' => [], ], 'Connection' => [ 'base' => '<p>Describes a connection.</p>', 'refs' => [ 'ConnectionList$member' => NULL, 'CreateConnectionResponse$Connection' => '<p>Information about the connection.</p>', 'DeleteConnectionResponse$Connection' => '<p>Information about the connection.</p>', 'UpdateConnectionResponse$Connection' => '<p>Information about the connection.</p>', ], ], 'ConnectionHealth' => [ 'base' => '<p>Describes connection health.</p>', 'refs' => [ 'NetworkTelemetry$Health' => '<p>The connection health.</p>', ], ], 'ConnectionList' => [ 'base' => NULL, 'refs' => [ 'GetConnectionsResponse$Connections' => '<p>Information about the connections.</p>', ], ], 'ConnectionState' => [ 'base' => NULL, 'refs' => [ 'Connection$State' => '<p>The state of the connection.</p>', ], ], 'ConnectionStatus' => [ 'base' => NULL, 'refs' => [ 'ConnectionHealth$Status' => '<p>The connection status.</p>', ], ], 'ConnectionType' => [ 'base' => NULL, 'refs' => [ 'ConnectionHealth$Type' => '<p>The connection type.</p>', ], ], 'CreateConnectionRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateConnectionResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateDeviceRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateDeviceResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateGlobalNetworkRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateGlobalNetworkResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateLinkRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateLinkResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateSiteRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateSiteResponse' => [ 'base' => NULL, 'refs' => [], ], 'CustomerGatewayAssociation' => [ 'base' => '<p>Describes the association between a customer gateway, a device, and a link.</p>', 'refs' => [ 'AssociateCustomerGatewayResponse$CustomerGatewayAssociation' => '<p>The customer gateway association.</p>', 'CustomerGatewayAssociationList$member' => NULL, 'DisassociateCustomerGatewayResponse$CustomerGatewayAssociation' => '<p>Information about the customer gateway association.</p>', ], ], 'CustomerGatewayAssociationList' => [ 'base' => NULL, 'refs' => [ 'GetCustomerGatewayAssociationsResponse$CustomerGatewayAssociations' => '<p>The customer gateway associations.</p>', ], ], 'CustomerGatewayAssociationState' => [ 'base' => NULL, 'refs' => [ 'CustomerGatewayAssociation$State' => '<p>The association state.</p>', ], ], 'DateTime' => [ 'base' => NULL, 'refs' => [ 'Connection$CreatedAt' => '<p>The date and time that the connection was created.</p>', 'ConnectionHealth$Timestamp' => '<p>The time the status was last updated.</p>', 'Device$CreatedAt' => '<p>The date and time that the site was created.</p>', 'GetNetworkRoutesResponse$RouteTableTimestamp' => '<p>The route table creation time.</p>', 'GlobalNetwork$CreatedAt' => '<p>The date and time that the global network was created.</p>', 'Link$CreatedAt' => '<p>The date and time that the link was created.</p>', 'NetworkResource$DefinitionTimestamp' => '<p>The time that the resource definition was retrieved.</p>', 'RouteAnalysis$StartTimestamp' => '<p>The time that the analysis started.</p>', 'Site$CreatedAt' => '<p>The date and time that the site was created.</p>', ], ], 'DeleteConnectionRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteConnectionResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteDeviceRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteDeviceResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteGlobalNetworkRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteGlobalNetworkResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteLinkRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteLinkResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteSiteRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteSiteResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeregisterTransitGatewayRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeregisterTransitGatewayResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeGlobalNetworksRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeGlobalNetworksResponse' => [ 'base' => NULL, 'refs' => [], ], 'Device' => [ 'base' => '<p>Describes a device.</p>', 'refs' => [ 'CreateDeviceResponse$Device' => '<p>Information about the device.</p>', 'DeleteDeviceResponse$Device' => '<p>Information about the device.</p>', 'DeviceList$member' => NULL, 'UpdateDeviceResponse$Device' => '<p>Information about the device.</p>', ], ], 'DeviceList' => [ 'base' => NULL, 'refs' => [ 'GetDevicesResponse$Devices' => '<p>The devices.</p>', ], ], 'DeviceState' => [ 'base' => NULL, 'refs' => [ 'Device$State' => '<p>The device state.</p>', ], ], 'DisassociateCustomerGatewayRequest' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateCustomerGatewayResponse' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateLinkRequest' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateLinkResponse' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateTransitGatewayConnectPeerRequest' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateTransitGatewayConnectPeerResponse' => [ 'base' => NULL, 'refs' => [], ], 'ExceptionContextKey' => [ 'base' => NULL, 'refs' => [ 'ExceptionContextMap$key' => NULL, ], ], 'ExceptionContextMap' => [ 'base' => NULL, 'refs' => [ 'ResourceNotFoundException$Context' => NULL, ], ], 'ExceptionContextValue' => [ 'base' => NULL, 'refs' => [ 'ExceptionContextMap$value' => NULL, ], ], 'FilterMap' => [ 'base' => NULL, 'refs' => [ 'GetNetworkRoutesRequest$DestinationFilters' => '<p>Filter by route table destination. Possible Values: TRANSIT_GATEWAY_ATTACHMENT_ID, RESOURCE_ID, or RESOURCE_TYPE.</p>', ], ], 'FilterName' => [ 'base' => NULL, 'refs' => [ 'FilterMap$key' => NULL, ], ], 'FilterValue' => [ 'base' => NULL, 'refs' => [ 'FilterValues$member' => NULL, ], ], 'FilterValues' => [ 'base' => NULL, 'refs' => [ 'FilterMap$value' => NULL, ], ], 'GetConnectionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetConnectionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetCustomerGatewayAssociationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetCustomerGatewayAssociationsResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetDevicesRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetDevicesResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetLinkAssociationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetLinkAssociationsResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetLinksRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetLinksResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetNetworkResourceCountsRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetNetworkResourceCountsResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetNetworkResourceRelationshipsRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetNetworkResourceRelationshipsResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetNetworkResourcesRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetNetworkResourcesResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetNetworkRoutesRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetNetworkRoutesResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetNetworkTelemetryRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetNetworkTelemetryResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetRouteAnalysisRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetRouteAnalysisResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetSitesRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetSitesResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetTransitGatewayConnectPeerAssociationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetTransitGatewayConnectPeerAssociationsResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetTransitGatewayRegistrationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetTransitGatewayRegistrationsResponse' => [ 'base' => NULL, 'refs' => [], ], 'GlobalNetwork' => [ 'base' => '<p>Describes a global network.</p>', 'refs' => [ 'CreateGlobalNetworkResponse$GlobalNetwork' => '<p>Information about the global network object.</p>', 'DeleteGlobalNetworkResponse$GlobalNetwork' => '<p>Information about the global network.</p>', 'GlobalNetworkList$member' => NULL, 'UpdateGlobalNetworkResponse$GlobalNetwork' => '<p>Information about the global network object.</p>', ], ], 'GlobalNetworkList' => [ 'base' => NULL, 'refs' => [ 'DescribeGlobalNetworksResponse$GlobalNetworks' => '<p>Information about the global networks.</p>', ], ], 'GlobalNetworkState' => [ 'base' => NULL, 'refs' => [ 'GlobalNetwork$State' => '<p>The state of the global network.</p>', ], ], 'Integer' => [ 'base' => NULL, 'refs' => [ 'Bandwidth$UploadSpeed' => '<p>Upload speed in Mbps.</p>', 'Bandwidth$DownloadSpeed' => '<p>Download speed in Mbps.</p>', 'NetworkResourceCount$Count' => '<p>The resource count.</p>', 'PathComponent$Sequence' => '<p>The sequence number in the path. The destination is 0.</p>', ], ], 'InternalServerException' => [ 'base' => '<p>The request has failed due to an internal error.</p>', 'refs' => [], ], 'Link' => [ 'base' => '<p>Describes a link.</p>', 'refs' => [ 'CreateLinkResponse$Link' => '<p>Information about the link.</p>', 'DeleteLinkResponse$Link' => '<p>Information about the link.</p>', 'LinkList$member' => NULL, 'UpdateLinkResponse$Link' => '<p>Information about the link.</p>', ], ], 'LinkAssociation' => [ 'base' => '<p>Describes the association between a device and a link.</p>', 'refs' => [ 'AssociateLinkResponse$LinkAssociation' => '<p>The link association.</p>', 'DisassociateLinkResponse$LinkAssociation' => '<p>Information about the link association.</p>', 'LinkAssociationList$member' => NULL, ], ], 'LinkAssociationList' => [ 'base' => NULL, 'refs' => [ 'GetLinkAssociationsResponse$LinkAssociations' => '<p>The link associations.</p>', ], ], 'LinkAssociationState' => [ 'base' => NULL, 'refs' => [ 'LinkAssociation$LinkAssociationState' => '<p>The state of the association.</p>', ], ], 'LinkList' => [ 'base' => NULL, 'refs' => [ 'GetLinksResponse$Links' => '<p>The links.</p>', ], ], 'LinkState' => [ 'base' => NULL, 'refs' => [ 'Link$State' => '<p>The state of the link.</p>', ], ], 'ListTagsForResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'Location' => [ 'base' => '<p>Describes a location.</p>', 'refs' => [ 'CreateDeviceRequest$Location' => '<p>The location of the device.</p>', 'CreateSiteRequest$Location' => '<p>The site location. This information is used for visualization in the Network Manager console. If you specify the address, the latitude and longitude are automatically calculated.</p> <ul> <li> <p> <code>Address</code>: The physical address of the site.</p> </li> <li> <p> <code>Latitude</code>: The latitude of the site. </p> </li> <li> <p> <code>Longitude</code>: The longitude of the site.</p> </li> </ul>', 'Device$Location' => '<p>The site location.</p>', 'Site$Location' => '<p>The location of the site.</p>', 'UpdateDeviceRequest$Location' => NULL, 'UpdateSiteRequest$Location' => '<p>The site location:</p> <ul> <li> <p> <code>Address</code>: The physical address of the site.</p> </li> <li> <p> <code>Latitude</code>: The latitude of the site. </p> </li> <li> <p> <code>Longitude</code>: The longitude of the site.</p> </li> </ul>', ], ], 'MaxResults' => [ 'base' => NULL, 'refs' => [ 'DescribeGlobalNetworksRequest$MaxResults' => '<p>The maximum number of results to return.</p>', 'GetConnectionsRequest$MaxResults' => '<p>The maximum number of results to return.</p>', 'GetCustomerGatewayAssociationsRequest$MaxResults' => '<p>The maximum number of results to return.</p>', 'GetDevicesRequest$MaxResults' => '<p>The maximum number of results to return.</p>', 'GetLinkAssociationsRequest$MaxResults' => '<p>The maximum number of results to return.</p>', 'GetLinksRequest$MaxResults' => '<p>The maximum number of results to return.</p>', 'GetNetworkResourceCountsRequest$MaxResults' => '<p>The maximum number of results to return.</p>', 'GetNetworkResourceRelationshipsRequest$MaxResults' => '<p>The maximum number of results to return.</p>', 'GetNetworkResourcesRequest$MaxResults' => '<p>The maximum number of results to return.</p>', 'GetNetworkTelemetryRequest$MaxResults' => '<p>The maximum number of results to return.</p>', 'GetSitesRequest$MaxResults' => '<p>The maximum number of results to return.</p>', 'GetTransitGatewayConnectPeerAssociationsRequest$MaxResults' => '<p>The maximum number of results to return.</p>', 'GetTransitGatewayRegistrationsRequest$MaxResults' => '<p>The maximum number of results to return.</p>', ], ], 'NetworkResource' => [ 'base' => '<p>Describes a network resource.</p>', 'refs' => [ 'NetworkResourceList$member' => NULL, ], ], 'NetworkResourceCount' => [ 'base' => '<p>Describes a resource count.</p>', 'refs' => [ 'NetworkResourceCountList$member' => NULL, ], ], 'NetworkResourceCountList' => [ 'base' => NULL, 'refs' => [ 'GetNetworkResourceCountsResponse$NetworkResourceCounts' => '<p>The count of resources.</p>', ], ], 'NetworkResourceList' => [ 'base' => NULL, 'refs' => [ 'GetNetworkResourcesResponse$NetworkResources' => '<p>The network resources.</p>', ], ], 'NetworkResourceMetadataKey' => [ 'base' => NULL, 'refs' => [ 'NetworkResourceMetadataMap$key' => NULL, ], ], 'NetworkResourceMetadataMap' => [ 'base' => NULL, 'refs' => [ 'NetworkResource$Metadata' => '<p>The resource metadata.</p>', 'UpdateNetworkResourceMetadataRequest$Metadata' => '<p>The resource metadata.</p>', 'UpdateNetworkResourceMetadataResponse$Metadata' => '<p>The updated resource metadata.</p>', ], ], 'NetworkResourceMetadataValue' => [ 'base' => NULL, 'refs' => [ 'NetworkResourceMetadataMap$value' => NULL, ], ], 'NetworkResourceSummary' => [ 'base' => '<p>Describes a network resource.</p>', 'refs' => [ 'PathComponent$Resource' => '<p>The resource.</p>', ], ], 'NetworkRoute' => [ 'base' => '<p>Describes a network route.</p>', 'refs' => [ 'NetworkRouteList$member' => NULL, ], ], 'NetworkRouteDestination' => [ 'base' => '<p>Describes the destination of a network route.</p>', 'refs' => [ 'NetworkRouteDestinationList$member' => NULL, ], ], 'NetworkRouteDestinationList' => [ 'base' => NULL, 'refs' => [ 'NetworkRoute$Destinations' => '<p>The destinations.</p>', ], ], 'NetworkRouteList' => [ 'base' => NULL, 'refs' => [ 'GetNetworkRoutesResponse$NetworkRoutes' => '<p>The network routes.</p>', ], ], 'NetworkTelemetry' => [ 'base' => '<p>Describes the telemetry information for a resource.</p>', 'refs' => [ 'NetworkTelemetryList$member' => NULL, ], ], 'NetworkTelemetryList' => [ 'base' => NULL, 'refs' => [ 'GetNetworkTelemetryResponse$NetworkTelemetry' => '<p>The network telemetry.</p>', ], ], 'PathComponent' => [ 'base' => '<p>Describes a path component.</p>', 'refs' => [ 'PathComponentList$member' => NULL, ], ], 'PathComponentList' => [ 'base' => NULL, 'refs' => [ 'RouteAnalysisPath$Path' => '<p>The route analysis path.</p>', ], ], 'ReasonContextKey' => [ 'base' => NULL, 'refs' => [ 'ReasonContextMap$key' => NULL, ], ], 'ReasonContextMap' => [ 'base' => NULL, 'refs' => [ 'RouteAnalysisCompletion$ReasonContext' => '<p>Additional information about the path. Available only if a connection is not found.</p>', ], ], 'ReasonContextValue' => [ 'base' => NULL, 'refs' => [ 'ReasonContextMap$value' => NULL, ], ], 'RegisterTransitGatewayRequest' => [ 'base' => NULL, 'refs' => [], ], 'RegisterTransitGatewayResponse' => [ 'base' => NULL, 'refs' => [], ], 'Relationship' => [ 'base' => '<p>Describes a resource relationship.</p>', 'refs' => [ 'RelationshipList$member' => NULL, ], ], 'RelationshipList' => [ 'base' => NULL, 'refs' => [ 'GetNetworkResourceRelationshipsResponse$Relationships' => '<p>The resource relationships.</p>', ], ], 'ResourceARN' => [ 'base' => NULL, 'refs' => [ 'ListTagsForResourceRequest$ResourceArn' => '<p>The Amazon Resource Name (ARN) of the resource.</p>', 'TagResourceRequest$ResourceArn' => '<p>The Amazon Resource Name (ARN) of the resource.</p>', 'UntagResourceRequest$ResourceArn' => '<p>The Amazon Resource Name (ARN) of the resource.</p>', ], ], 'ResourceNotFoundException' => [ 'base' => '<p>The specified resource could not be found.</p>', 'refs' => [], ], 'RetryAfterSeconds' => [ 'base' => NULL, 'refs' => [ 'InternalServerException$RetryAfterSeconds' => '<p>Indicates when to retry the request.</p>', 'ThrottlingException$RetryAfterSeconds' => '<p>Indicates when to retry the request.</p>', ], ], 'RouteAnalysis' => [ 'base' => '<p>Describes a route analysis.</p>', 'refs' => [ 'GetRouteAnalysisResponse$RouteAnalysis' => '<p>The route analysis.</p>', 'StartRouteAnalysisResponse$RouteAnalysis' => '<p>The route analysis.</p>', ], ], 'RouteAnalysisCompletion' => [ 'base' => '<p>Describes the status of an analysis at completion.</p>', 'refs' => [ 'RouteAnalysisPath$CompletionStatus' => '<p>The status of the analysis at completion.</p>', ], ], 'RouteAnalysisCompletionReasonCode' => [ 'base' => NULL, 'refs' => [ 'RouteAnalysisCompletion$ReasonCode' => '<p>The reason code. Available only if a connection is not found.</p> <ul> <li> <p> <code>BLACKHOLE_ROUTE_FOR_DESTINATION_FOUND</code> - Found a black hole route with the destination CIDR block.</p> </li> <li> <p> <code>CYCLIC_PATH_DETECTED</code> - Found the same resource multiple times while traversing the path.</p> </li> <li> <p> <code>INACTIVE_ROUTE_FOR_DESTINATION_FOUND</code> - Found an inactive route with the destination CIDR block.</p> </li> <li> <p> <code>MAX_HOPS_EXCEEDED</code> - Analysis exceeded 64 hops without finding the destination.</p> </li> <li> <p> <code>ROUTE_NOT_FOUND</code> - Cannot find a route table with the destination CIDR block.</p> </li> <li> <p> <code>TGW_ATTACH_ARN_NO_MATCH</code> - Found an attachment, but not with the correct destination ARN.</p> </li> <li> <p> <code>TGW_ATTACH_NOT_FOUND</code> - Cannot find an attachment.</p> </li> <li> <p> <code>TGW_ATTACH_NOT_IN_TGW</code> - Found an attachment, but not to the correct transit gateway.</p> </li> <li> <p> <code>TGW_ATTACH_STABLE_ROUTE_TABLE_NOT_FOUND</code> - The state of the route table association is not associated.</p> </li> </ul>', ], ], 'RouteAnalysisCompletionResultCode' => [ 'base' => NULL, 'refs' => [ 'RouteAnalysisCompletion$ResultCode' => '<p>The result of the analysis. If the status is <code>NOT_CONNECTED</code>, check the reason code.</p>', ], ], 'RouteAnalysisEndpointOptions' => [ 'base' => '<p>Describes a source or a destination.</p>', 'refs' => [ 'RouteAnalysis$Source' => '<p>The source.</p>', 'RouteAnalysis$Destination' => '<p>The destination.</p>', ], ], 'RouteAnalysisEndpointOptionsSpecification' => [ 'base' => '<p>Describes a source or a destination.</p>', 'refs' => [ 'StartRouteAnalysisRequest$Source' => '<p>The source from which traffic originates.</p>', 'StartRouteAnalysisRequest$Destination' => '<p>The destination.</p>', ], ], 'RouteAnalysisPath' => [ 'base' => '<p>Describes a route analysis path.</p>', 'refs' => [ 'RouteAnalysis$ForwardPath' => '<p>The forward path.</p>', 'RouteAnalysis$ReturnPath' => '<p>The return path.</p>', ], ], 'RouteAnalysisStatus' => [ 'base' => NULL, 'refs' => [ 'RouteAnalysis$Status' => '<p>The status of the route analysis.</p>', ], ], 'RouteState' => [ 'base' => NULL, 'refs' => [ 'NetworkRoute$State' => '<p>The route state. The possible values are <code>active</code> and <code>blackhole</code>.</p>', 'RouteStateList$member' => NULL, ], ], 'RouteStateList' => [ 'base' => NULL, 'refs' => [ 'GetNetworkRoutesRequest$States' => '<p>The route states.</p>', ], ], 'RouteTableIdentifier' => [ 'base' => '<p>Describes a route table.</p>', 'refs' => [ 'GetNetworkRoutesRequest$RouteTableIdentifier' => '<p>The ID of the route table.</p>', ], ], 'RouteTableType' => [ 'base' => NULL, 'refs' => [ 'GetNetworkRoutesResponse$RouteTableType' => '<p>The route table type.</p>', ], ], 'RouteType' => [ 'base' => NULL, 'refs' => [ 'NetworkRoute$Type' => '<p>The route type. The possible values are <code>propagated</code> and <code>static</code>.</p>', 'RouteTypeList$member' => NULL, ], ], 'RouteTypeList' => [ 'base' => NULL, 'refs' => [ 'GetNetworkRoutesRequest$Types' => '<p>The route types.</p>', ], ], 'ServiceQuotaExceededException' => [ 'base' => '<p>A service limit was exceeded.</p>', 'refs' => [], ], 'Site' => [ 'base' => '<p>Describes a site.</p>', 'refs' => [ 'CreateSiteResponse$Site' => '<p>Information about the site.</p>', 'DeleteSiteResponse$Site' => '<p>Information about the site.</p>', 'SiteList$member' => NULL, 'UpdateSiteResponse$Site' => '<p>Information about the site.</p>', ], ], 'SiteList' => [ 'base' => NULL, 'refs' => [ 'GetSitesResponse$Sites' => '<p>The sites.</p>', ], ], 'SiteState' => [ 'base' => NULL, 'refs' => [ 'Site$State' => '<p>The state of the site.</p>', ], ], 'StartRouteAnalysisRequest' => [ 'base' => NULL, 'refs' => [], ], 'StartRouteAnalysisResponse' => [ 'base' => NULL, 'refs' => [], ], 'String' => [ 'base' => NULL, 'refs' => [ 'AWSLocation$Zone' => '<p>The Zone that the device is located in. Specify the ID of an Availability Zone, Local Zone, Wavelength Zone, or an Outpost.</p>', 'AWSLocation$SubnetArn' => '<p>The Amazon Resource Name (ARN) of the subnet that the device is located in.</p>', 'AccessDeniedException$Message' => NULL, 'AssociateCustomerGatewayRequest$CustomerGatewayArn' => '<p>The Amazon Resource Name (ARN) of the customer gateway.</p>', 'AssociateCustomerGatewayRequest$GlobalNetworkId' => '<p>The ID of the global network.</p>', 'AssociateCustomerGatewayRequest$DeviceId' => '<p>The ID of the device.</p>', 'AssociateCustomerGatewayRequest$LinkId' => '<p>The ID of the link.</p>', 'AssociateLinkRequest$GlobalNetworkId' => '<p>The ID of the global network.</p>', 'AssociateLinkRequest$DeviceId' => '<p>The ID of the device.</p>', 'AssociateLinkRequest$LinkId' => '<p>The ID of the link.</p>', 'AssociateTransitGatewayConnectPeerRequest$GlobalNetworkId' => '<p>The ID of the global network.</p>', 'AssociateTransitGatewayConnectPeerRequest$TransitGatewayConnectPeerArn' => '<p>The Amazon Resource Name (ARN) of the Connect peer.</p>', 'AssociateTransitGatewayConnectPeerRequest$DeviceId' => '<p>The ID of the device.</p>', 'AssociateTransitGatewayConnectPeerRequest$LinkId' => '<p>The ID of the link.</p>', 'ConflictException$Message' => NULL, 'ConflictException$ResourceId' => '<p>The ID of the resource.</p>', 'ConflictException$ResourceType' => '<p>The resource type.</p>', 'Connection$ConnectionId' => '<p>The ID of the connection.</p>', 'Connection$ConnectionArn' => '<p>The Amazon Resource Name (ARN) of the connection.</p>', 'Connection$GlobalNetworkId' => '<p>The ID of the global network.</p>', 'Connection$DeviceId' => '<p>The ID of the first device in the connection.</p>', 'Connection$ConnectedDeviceId' => '<p>The ID of the second device in the connection.</p>', 'Connection$LinkId' => '<p>The ID of the link for the first device in the connection.</p>', 'Connection$ConnectedLinkId' => '<p>The ID of the link for the second device in the connection.</p>', 'Connection$Description' => '<p>The description of the connection.</p>', 'CreateConnectionRequest$GlobalNetworkId' => '<p>The ID of the global network.</p>', 'CreateConnectionRequest$DeviceId' => '<p>The ID of the first device in the connection.</p>', 'CreateConnectionRequest$ConnectedDeviceId' => '<p>The ID of the second device in the connection.</p>', 'CreateConnectionRequest$LinkId' => '<p>The ID of the link for the first device.</p>', 'CreateConnectionRequest$ConnectedLinkId' => '<p>The ID of the link for the second device.</p>', 'CreateConnectionRequest$Description' => '<p>A description of the connection.</p> <p>Length Constraints: Maximum length of 256 characters.</p>', 'CreateDeviceRequest$GlobalNetworkId' => '<p>The ID of the global network.</p>', 'CreateDeviceRequest$Description' => '<p>A description of the device.</p> <p>Constraints: Maximum length of 256 characters.</p>', 'CreateDeviceRequest$Type' => '<p>The type of the device.</p>', 'CreateDeviceRequest$Vendor' => '<p>The vendor of the device.</p> <p>Constraints: Maximum length of 128 characters.</p>', 'CreateDeviceRequest$Model' => '<p>The model of the device.</p> <p>Constraints: Maximum length of 128 characters.</p>', 'CreateDeviceRequest$SerialNumber' => '<p>The serial number of the device.</p> <p>Constraints: Maximum length of 128 characters.</p>', 'CreateDeviceRequest$SiteId' => '<p>The ID of the site.</p>', 'CreateGlobalNetworkRequest$Description' => '<p>A description of the global network.</p> <p>Constraints: Maximum length of 256 characters.</p>', 'CreateLinkRequest$GlobalNetworkId' => '<p>The ID of the global network.</p>', 'CreateLinkRequest$Description' => '<p>A description of the link.</p> <p>Constraints: Maximum length of 256 characters.</p>', 'CreateLinkRequest$Type' => '<p>The type of the link.</p> <p>Constraints: Maximum length of 128 characters. Cannot include the following characters: | \\ ^</p>', 'CreateLinkRequest$Provider' => '<p>The provider of the link.</p> <p>Constraints: Maximum length of 128 characters. Cannot include the following characters: | \\ ^</p>', 'CreateLinkRequest$SiteId' => '<p>The ID of the site.</p>', 'CreateSiteRequest$GlobalNetworkId' => '<p>The ID of the global network.</p>', 'CreateSiteRequest$Description' => '<p>A description of your site.</p> <p>Constraints: Maximum length of 256 characters.</p>', 'CustomerGatewayAssociation$CustomerGatewayArn' => '<p>The Amazon Resource Name (ARN) of the customer gateway.</p>', 'CustomerGatewayAssociation$GlobalNetworkId' => '<p>The ID of the global network.</p>', 'CustomerGatewayAssociation$DeviceId' => '<p>The ID of the device.</p>', 'CustomerGatewayAssociation$LinkId' => '<p>The ID of the link.</p>', 'DeleteConnectionRequest$GlobalNetworkId' => '<p>The ID of the global network.</p>', 'DeleteConnectionRequest$ConnectionId' => '<p>The ID of the connection.</p>', 'DeleteDeviceRequest$GlobalNetworkId' => '<p>The ID of the global network.</p>', 'DeleteDeviceRequest$DeviceId' => '<p>The ID of the device.</p>', 'DeleteGlobalNetworkRequest$GlobalNetworkId' => '<p>The ID of the global network.</p>', 'DeleteLinkRequest$GlobalNetworkId' => '<p>The ID of the global network.</p>', 'DeleteLinkRequest$LinkId' => '<p>The ID of the link.</p>', 'DeleteSiteRequest$GlobalNetworkId' => '<p>The ID of the global network.</p>', 'DeleteSiteRequest$SiteId' => '<p>The ID of the site.</p>', 'DeregisterTransitGatewayRequest$GlobalNetworkId' => '<p>The ID of the global network.</p>', 'DeregisterTransitGatewayRequest$TransitGatewayArn' => '<p>The Amazon Resource Name (ARN) of the transit gateway.</p>', 'DescribeGlobalNetworksRequest$NextToken' => '<p>The token for the next page of results.</p>', 'DescribeGlobalNetworksResponse$NextToken' => '<p>The token for the next page of results.</p>', 'Device$DeviceId' => '<p>The ID of the device.</p>', 'Device$DeviceArn' => '<p>The Amazon Resource Name (ARN) of the device.</p>', 'Device$GlobalNetworkId' => '<p>The ID of the global network.</p>', 'Device$Description' => '<p>The description of the device.</p>', 'Device$Type' => '<p>The device type.</p>', 'Device$Vendor' => '<p>The device vendor.</p>', 'Device$Model' => '<p>The device model.</p>', 'Device$SerialNumber' => '<p>The device serial number.</p>', 'Device$SiteId' => '<p>The site ID.</p>', 'DisassociateCustomerGatewayRequest$GlobalNetworkId' => '<p>The ID of the global network.</p>', 'DisassociateCustomerGatewayRequest$CustomerGatewayArn' => '<p>The Amazon Resource Name (ARN) of the customer gateway.</p>', 'DisassociateLinkRequest$GlobalNetworkId' => '<p>The ID of the global network.</p>', 'DisassociateLinkRequest$DeviceId' => '<p>The ID of the device.</p>', 'DisassociateLinkRequest$LinkId' => '<p>The ID of the link.</p>', 'DisassociateTransitGatewayConnectPeerRequest$GlobalNetworkId' => '<p>The ID of the global network.</p>', 'DisassociateTransitGatewayConnectPeerRequest$TransitGatewayConnectPeerArn' => '<p>The Amazon Resource Name (ARN) of the transit gateway Connect peer.</p>', 'GetConnectionsRequest$GlobalNetworkId' => '<p>The ID of the global network.</p>', 'GetConnectionsRequest$DeviceId' => '<p>The ID of the device.</p>', 'GetConnectionsRequest$NextToken' => '<p>The token for the next page of results.</p>', 'GetConnectionsResponse$NextToken' => '<p>The token to use for the next page of results.</p>', 'GetCustomerGatewayAssociationsRequest$GlobalNetworkId' => '<p>The ID of the global network.</p>', 'GetCustomerGatewayAssociationsRequest$NextToken' => '<p>The token for the next page of results.</p>', 'GetCustomerGatewayAssociationsResponse$NextToken' => '<p>The token for the next page of results.</p>', 'GetDevicesRequest$GlobalNetworkId' => '<p>The ID of the global network.</p>', 'GetDevicesRequest$SiteId' => '<p>The ID of the site.</p>', 'GetDevicesRequest$NextToken' => '<p>The token for the next page of results.</p>', 'GetDevicesResponse$NextToken' => '<p>The token for the next page of results.</p>', 'GetLinkAssociationsRequest$GlobalNetworkId' => '<p>The ID of the global network.</p>', 'GetLinkAssociationsRequest$DeviceId' => '<p>The ID of the device.</p>', 'GetLinkAssociationsRequest$LinkId' => '<p>The ID of the link.</p>', 'GetLinkAssociationsRequest$NextToken' => '<p>The token for the next page of results.</p>', 'GetLinkAssociationsResponse$NextToken' => '<p>The token for the next page of results.</p>', 'GetLinksRequest$GlobalNetworkId' => '<p>The ID of the global network.</p>', 'GetLinksRequest$SiteId' => '<p>The ID of the site.</p>', 'GetLinksRequest$Type' => '<p>The link type.</p>', 'GetLinksRequest$Provider' => '<p>The link provider.</p>', 'GetLinksRequest$NextToken' => '<p>The token for the next page of results.</p>', 'GetLinksResponse$NextToken' => '<p>The token for the next page of results.</p>', 'GetNetworkResourceCountsRequest$GlobalNetworkId' => '<p>The ID of the global network.</p>', 'GetNetworkResourceCountsRequest$ResourceType' => '<p>The resource type.</p> <p>The following are the supported resource types for Direct Connect:</p> <ul> <li> <p> <code>dxcon</code> </p> </li> <li> <p> <code>dx-gateway</code> </p> </li> <li> <p> <code>dx-vif</code> </p> </li> </ul> <p>The following are the supported resource types for Network Manager:</p> <ul> <li> <p> <code>connection</code> </p> </li> <li> <p> <code>device</code> </p> </li> <li> <p> <code>link</code> </p> </li> <li> <p> <code>site</code> </p> </li> </ul> <p>The following are the supported resource types for Amazon VPC:</p> <ul> <li> <p> <code>customer-gateway</code> </p> </li> <li> <p> <code>transit-gateway</code> </p> </li> <li> <p> <code>transit-gateway-attachment</code> </p> </li> <li> <p> <code>transit-gateway-connect-peer</code> </p> </li> <li> <p> <code>transit-gateway-route-table</code> </p> </li> <li> <p> <code>vpn-connection</code> </p> </li> </ul>', 'GetNetworkResourceCountsRequest$NextToken' => '<p>The token for the next page of results.</p>', 'GetNetworkResourceCountsResponse$NextToken' => '<p>The token for the next page of results.</p>', 'GetNetworkResourceRelationshipsRequest$GlobalNetworkId' => '<p>The ID of the global network.</p>', 'GetNetworkResourceRelationshipsRequest$RegisteredGatewayArn' => '<p>The ARN of the registered gateway.</p>', 'GetNetworkResourceRelationshipsRequest$AwsRegion' => '<p>The Amazon Web Services Region.</p>', 'GetNetworkResourceRelationshipsRequest$AccountId' => '<p>The Amazon Web Services account ID.</p>', 'GetNetworkResourceRelationshipsRequest$ResourceType' => '<p>The resource type.</p> <p>The following are the supported resource types for Direct Connect:</p> <ul> <li> <p> <code>dxcon</code> </p> </li> <li> <p> <code>dx-gateway</code> </p> </li> <li> <p> <code>dx-vif</code> </p> </li> </ul> <p>The following are the supported resource types for Network Manager:</p> <ul> <li> <p> <code>connection</code> </p> </li> <li> <p> <code>device</code> </p> </li> <li> <p> <code>link</code> </p> </li> <li> <p> <code>site</code> </p> </li> </ul> <p>The following are the supported resource types for Amazon VPC:</p> <ul> <li> <p> <code>customer-gateway</code> </p> </li> <li> <p> <code>transit-gateway</code> </p> </li> <li> <p> <code>transit-gateway-attachment</code> </p> </li> <li> <p> <code>transit-gateway-connect-peer</code> </p> </li> <li> <p> <code>transit-gateway-route-table</code> </p> </li> <li> <p> <code>vpn-connection</code> </p> </li> </ul>', 'GetNetworkResourceRelationshipsRequest$ResourceArn' => '<p>The ARN of the gateway.</p>', 'GetNetworkResourceRelationshipsRequest$NextToken' => '<p>The token for the next page of results.</p>', 'GetNetworkResourceRelationshipsResponse$NextToken' => '<p>The token for the next page of results.</p>', 'GetNetworkResourcesRequest$GlobalNetworkId' => '<p>The ID of the global network.</p>', 'GetNetworkResourcesRequest$RegisteredGatewayArn' => '<p>The ARN of the gateway.</p>', 'GetNetworkResourcesRequest$AwsRegion' => '<p>The Amazon Web Services Region.</p>', 'GetNetworkResourcesRequest$AccountId' => '<p>The Amazon Web Services account ID.</p>', 'GetNetworkResourcesRequest$ResourceType' => '<p>The resource type.</p> <p>The following are the supported resource types for Direct Connect:</p> <ul> <li> <p> <code>dxcon</code> - The definition model is <a href="https://docs.aws.amazon.com/directconnect/latest/APIReference/API_Connection.html">Connection</a>.</p> </li> <li> <p> <code>dx-gateway</code> - The definition model is <a href="https://docs.aws.amazon.com/directconnect/latest/APIReference/API_DirectConnectGateway.html">DirectConnectGateway</a>.</p> </li> <li> <p> <code>dx-vif</code> - The definition model is <a href="https://docs.aws.amazon.com/directconnect/latest/APIReference/API_VirtualInterface.html">VirtualInterface</a>.</p> </li> </ul> <p>The following are the supported resource types for Network Manager:</p> <ul> <li> <p> <code>connection</code> - The definition model is <a href="https://docs.aws.amazon.com/networkmanager/latest/APIReference/API_Connection.html">Connection</a>.</p> </li> <li> <p> <code>device</code> - The definition model is <a href="https://docs.aws.amazon.com/networkmanager/latest/APIReference/API_Device.html">Device</a>.</p> </li> <li> <p> <code>link</code> - The definition model is <a href="https://docs.aws.amazon.com/networkmanager/latest/APIReference/API_Link.html">Link</a>.</p> </li> <li> <p> <code>site</code> - The definition model is <a href="https://docs.aws.amazon.com/networkmanager/latest/APIReference/API_Site.html">Site</a>.</p> </li> </ul> <p>The following are the supported resource types for Amazon VPC:</p> <ul> <li> <p> <code>customer-gateway</code> - The definition model is <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CustomerGateway.html">CustomerGateway</a>.</p> </li> <li> <p> <code>transit-gateway</code> - The definition model is <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_TransitGateway.html">TransitGateway</a>.</p> </li> <li> <p> <code>transit-gateway-attachment</code> - The definition model is <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_TransitGatewayAttachment.html">TransitGatewayAttachment</a>.</p> </li> <li> <p> <code>transit-gateway-connect-peer</code> - The definition model is <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_TransitGatewayConnectPeer.html">TransitGatewayConnectPeer</a>.</p> </li> <li> <p> <code>transit-gateway-route-table</code> - The definition model is <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_TransitGatewayRouteTable.html">TransitGatewayRouteTable</a>.</p> </li> <li> <p> <code>vpn-connection</code> - The definition model is <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_VpnConnection.html">VpnConnection</a>.</p> </li> </ul>', 'GetNetworkResourcesRequest$ResourceArn' => '<p>The ARN of the resource.</p>', 'GetNetworkResourcesRequest$NextToken' => '<p>The token for the next page of results.</p>', 'GetNetworkResourcesResponse$NextToken' => '<p>The token for the next page of results.</p>', 'GetNetworkRoutesRequest$GlobalNetworkId' => '<p>The ID of the global network.</p>', 'GetNetworkRoutesResponse$RouteTableArn' => '<p>The ARN of the route table.</p>', 'GetNetworkTelemetryRequest$GlobalNetworkId' => '<p>The ID of the global network.</p>', 'GetNetworkTelemetryRequest$RegisteredGatewayArn' => '<p>The ARN of the gateway.</p>', 'GetNetworkTelemetryRequest$AwsRegion' => '<p>The Amazon Web Services Region.</p>', 'GetNetworkTelemetryRequest$AccountId' => '<p>The Amazon Web Services account ID.</p>', 'GetNetworkTelemetryRequest$ResourceType' => '<p>The resource type.</p> <p>The following are the supported resource types for Direct Connect:</p> <ul> <li> <p> <code>dxcon</code> </p> </li> <li> <p> <code>dx-gateway</code> </p> </li> <li> <p> <code>dx-vif</code> </p> </li> </ul> <p>The following are the supported resource types for Network Manager:</p> <ul> <li> <p> <code>connection</code> </p> </li> <li> <p> <code>device</code> </p> </li> <li> <p> <code>link</code> </p> </li> <li> <p> <code>site</code> </p> </li> </ul> <p>The following are the supported resource types for Amazon VPC:</p> <ul> <li> <p> <code>customer-gateway</code> </p> </li> <li> <p> <code>transit-gateway</code> </p> </li> <li> <p> <code>transit-gateway-attachment</code> </p> </li> <li> <p> <code>transit-gateway-connect-peer</code> </p> </li> <li> <p> <code>transit-gateway-route-table</code> </p> </li> <li> <p> <code>vpn-connection</code> </p> </li> </ul>', 'GetNetworkTelemetryRequest$ResourceArn' => '<p>The ARN of the resource.</p>', 'GetNetworkTelemetryRequest$NextToken' => '<p>The token for the next page of results.</p>', 'GetNetworkTelemetryResponse$NextToken' => '<p>The token for the next page of results.</p>', 'GetRouteAnalysisRequest$GlobalNetworkId' => '<p>The ID of the global network.</p>', 'GetRouteAnalysisRequest$RouteAnalysisId' => '<p>The ID of the route analysis.</p>', 'GetSitesRequest$GlobalNetworkId' => '<p>The ID of the global network.</p>', 'GetSitesRequest$NextToken' => '<p>The token for the next page of results.</p>', 'GetSitesResponse$NextToken' => '<p>The token for the next page of results.</p>', 'GetTransitGatewayConnectPeerAssociationsRequest$GlobalNetworkId' => '<p>The ID of the global network.</p>', 'GetTransitGatewayConnectPeerAssociationsRequest$NextToken' => '<p>The token for the next page of results.</p>', 'GetTransitGatewayConnectPeerAssociationsResponse$NextToken' => '<p>The token to use for the next page of results.</p>', 'GetTransitGatewayRegistrationsRequest$GlobalNetworkId' => '<p>The ID of the global network.</p>', 'GetTransitGatewayRegistrationsRequest$NextToken' => '<p>The token for the next page of results.</p>', 'GetTransitGatewayRegistrationsResponse$NextToken' => '<p>The token for the next page of results.</p>', 'GlobalNetwork$GlobalNetworkId' => '<p>The ID of the global network.</p>', 'GlobalNetwork$GlobalNetworkArn' => '<p>The Amazon Resource Name (ARN) of the global network.</p>', 'GlobalNetwork$Description' => '<p>The description of the global network.</p>', 'InternalServerException$Message' => NULL, 'Link$LinkId' => '<p>The ID of the link.</p>', 'Link$LinkArn' => '<p>The Amazon Resource Name (ARN) of the link.</p>', 'Link$GlobalNetworkId' => '<p>The ID of the global network.</p>', 'Link$SiteId' => '<p>The ID of the site.</p>', 'Link$Description' => '<p>The description of the link.</p>', 'Link$Type' => '<p>The type of the link.</p>', 'Link$Provider' => '<p>The provider of the link.</p>', 'LinkAssociation$GlobalNetworkId' => '<p>The ID of the global network.</p>', 'LinkAssociation$DeviceId' => '<p>The device ID for the link association.</p>', 'LinkAssociation$LinkId' => '<p>The ID of the link.</p>', 'Location$Address' => '<p>The physical address.</p>', 'Location$Latitude' => '<p>The latitude.</p>', 'Location$Longitude' => '<p>The longitude.</p>', 'NetworkResource$RegisteredGatewayArn' => '<p>The ARN of the gateway.</p>', 'NetworkResource$AwsRegion' => '<p>The Amazon Web Services Region.</p>', 'NetworkResource$AccountId' => '<p>The Amazon Web Services account ID.</p>', 'NetworkResource$ResourceType' => '<p>The resource type.</p> <p>The following are the supported resource types for Direct Connect:</p> <ul> <li> <p> <code>dxcon</code> </p> </li> <li> <p> <code>dx-gateway</code> </p> </li> <li> <p> <code>dx-vif</code> </p> </li> </ul> <p>The following are the supported resource types for Network Manager:</p> <ul> <li> <p> <code>connection</code> </p> </li> <li> <p> <code>device</code> </p> </li> <li> <p> <code>link</code> </p> </li> <li> <p> <code>site</code> </p> </li> </ul> <p>The following are the supported resource types for Amazon VPC:</p> <ul> <li> <p> <code>customer-gateway</code> </p> </li> <li> <p> <code>transit-gateway</code> </p> </li> <li> <p> <code>transit-gateway-attachment</code> </p> </li> <li> <p> <code>transit-gateway-connect-peer</code> </p> </li> <li> <p> <code>transit-gateway-route-table</code> </p> </li> <li> <p> <code>vpn-connection</code> </p> </li> </ul>', 'NetworkResource$ResourceId' => '<p>The ID of the resource.</p>', 'NetworkResource$ResourceArn' => '<p>The ARN of the resource.</p>', 'NetworkResource$Definition' => '<p>Information about the resource, in JSON format. Network Manager gets this information by describing the resource using its Describe API call.</p>', 'NetworkResourceCount$ResourceType' => '<p>The resource type.</p>', 'NetworkResourceSummary$RegisteredGatewayArn' => '<p>The ARN of the gateway.</p>', 'NetworkResourceSummary$ResourceArn' => '<p>The ARN of the resource.</p>', 'NetworkResourceSummary$ResourceType' => '<p>The resource type.</p>', 'NetworkResourceSummary$Definition' => '<p>Information about the resource, in JSON format. Network Manager gets this information by describing the resource using its Describe API call.</p>', 'NetworkResourceSummary$NameTag' => '<p>The value for the Name tag.</p>', 'NetworkRoute$DestinationCidrBlock' => '<p>A unique identifier for the route, such as a CIDR block.</p>', 'NetworkRoute$PrefixListId' => '<p>The ID of the prefix list.</p>', 'NetworkRouteDestination$TransitGatewayAttachmentId' => '<p>The ID of the transit gateway attachment.</p>', 'NetworkRouteDestination$ResourceType' => '<p>The resource type.</p>', 'NetworkRouteDestination$ResourceId' => '<p>The ID of the resource.</p>', 'NetworkTelemetry$RegisteredGatewayArn' => '<p>The ARN of the gateway.</p>', 'NetworkTelemetry$AwsRegion' => '<p>The Amazon Web Services Region.</p>', 'NetworkTelemetry$AccountId' => '<p>The Amazon Web Services account ID.</p>', 'NetworkTelemetry$ResourceType' => '<p>The resource type.</p>', 'NetworkTelemetry$ResourceId' => '<p>The ID of the resource.</p>', 'NetworkTelemetry$ResourceArn' => '<p>The ARN of the resource.</p>', 'NetworkTelemetry$Address' => '<p>The address.</p>', 'PathComponent$DestinationCidrBlock' => '<p>The destination CIDR block in the route table.</p>', 'RegisterTransitGatewayRequest$GlobalNetworkId' => '<p>The ID of the global network.</p>', 'RegisterTransitGatewayRequest$TransitGatewayArn' => '<p>The Amazon Resource Name (ARN) of the transit gateway.</p>', 'Relationship$From' => '<p>The ARN of the resource.</p>', 'Relationship$To' => '<p>The ARN of the resource.</p>', 'ResourceNotFoundException$Message' => NULL, 'ResourceNotFoundException$ResourceId' => '<p>The ID of the resource.</p>', 'ResourceNotFoundException$ResourceType' => '<p>The resource type.</p>', 'RouteAnalysis$GlobalNetworkId' => '<p>The ID of the global network.</p>', 'RouteAnalysis$OwnerAccountId' => '<p>The ID of the AWS account that created the route analysis.</p>', 'RouteAnalysis$RouteAnalysisId' => '<p>The ID of the route analysis.</p>', 'RouteAnalysisEndpointOptions$TransitGatewayAttachmentArn' => '<p>The ARN of the transit gateway attachment.</p>', 'RouteAnalysisEndpointOptions$TransitGatewayArn' => '<p>The ARN of the transit gateway.</p>', 'RouteAnalysisEndpointOptions$IpAddress' => '<p>The IP address.</p>', 'RouteAnalysisEndpointOptionsSpecification$TransitGatewayAttachmentArn' => '<p>The ARN of the transit gateway attachment.</p>', 'RouteAnalysisEndpointOptionsSpecification$IpAddress' => '<p>The IP address.</p>', 'RouteTableIdentifier$TransitGatewayRouteTableArn' => '<p>The ARN of the transit gateway route table.</p>', 'ServiceQuotaExceededException$Message' => '<p>The error message.</p>', 'ServiceQuotaExceededException$ResourceId' => '<p>The ID of the resource.</p>', 'ServiceQuotaExceededException$ResourceType' => '<p>The resource type.</p>', 'ServiceQuotaExceededException$LimitCode' => '<p>The limit code.</p>', 'ServiceQuotaExceededException$ServiceCode' => '<p>The service code.</p>', 'Site$SiteId' => '<p>The ID of the site.</p>', 'Site$SiteArn' => '<p>The Amazon Resource Name (ARN) of the site.</p>', 'Site$GlobalNetworkId' => '<p>The ID of the global network.</p>', 'Site$Description' => '<p>The description of the site.</p>', 'StartRouteAnalysisRequest$GlobalNetworkId' => '<p>The ID of the global network.</p>', 'StringList$member' => NULL, 'ThrottlingException$Message' => NULL, 'TransitGatewayConnectPeerAssociation$TransitGatewayConnectPeerArn' => '<p>The Amazon Resource Name (ARN) of the transit gateway Connect peer.</p>', 'TransitGatewayConnectPeerAssociation$GlobalNetworkId' => '<p>The ID of the global network.</p>', 'TransitGatewayConnectPeerAssociation$DeviceId' => '<p>The ID of the device.</p>', 'TransitGatewayConnectPeerAssociation$LinkId' => '<p>The ID of the link.</p>', 'TransitGatewayRegistration$GlobalNetworkId' => '<p>The ID of the global network.</p>', 'TransitGatewayRegistration$TransitGatewayArn' => '<p>The Amazon Resource Name (ARN) of the transit gateway.</p>', 'TransitGatewayRegistrationStateReason$Message' => '<p>The message for the state reason.</p>', 'UpdateConnectionRequest$GlobalNetworkId' => '<p>The ID of the global network.</p>', 'UpdateConnectionRequest$ConnectionId' => '<p>The ID of the connection.</p>', 'UpdateConnectionRequest$LinkId' => '<p>The ID of the link for the first device in the connection.</p>', 'UpdateConnectionRequest$ConnectedLinkId' => '<p>The ID of the link for the second device in the connection.</p>', 'UpdateConnectionRequest$Description' => '<p>A description of the connection.</p> <p>Length Constraints: Maximum length of 256 characters.</p>', 'UpdateDeviceRequest$GlobalNetworkId' => '<p>The ID of the global network.</p>', 'UpdateDeviceRequest$DeviceId' => '<p>The ID of the device.</p>', 'UpdateDeviceRequest$Description' => '<p>A description of the device.</p> <p>Constraints: Maximum length of 256 characters.</p>', 'UpdateDeviceRequest$Type' => '<p>The type of the device.</p>', 'UpdateDeviceRequest$Vendor' => '<p>The vendor of the device.</p> <p>Constraints: Maximum length of 128 characters.</p>', 'UpdateDeviceRequest$Model' => '<p>The model of the device.</p> <p>Constraints: Maximum length of 128 characters.</p>', 'UpdateDeviceRequest$SerialNumber' => '<p>The serial number of the device.</p> <p>Constraints: Maximum length of 128 characters.</p>', 'UpdateDeviceRequest$SiteId' => '<p>The ID of the site.</p>', 'UpdateGlobalNetworkRequest$GlobalNetworkId' => '<p>The ID of your global network.</p>', 'UpdateGlobalNetworkRequest$Description' => '<p>A description of the global network.</p> <p>Constraints: Maximum length of 256 characters.</p>', 'UpdateLinkRequest$GlobalNetworkId' => '<p>The ID of the global network.</p>', 'UpdateLinkRequest$LinkId' => '<p>The ID of the link.</p>', 'UpdateLinkRequest$Description' => '<p>A description of the link.</p> <p>Constraints: Maximum length of 256 characters.</p>', 'UpdateLinkRequest$Type' => '<p>The type of the link.</p> <p>Constraints: Maximum length of 128 characters.</p>', 'UpdateLinkRequest$Provider' => '<p>The provider of the link.</p> <p>Constraints: Maximum length of 128 characters.</p>', 'UpdateNetworkResourceMetadataRequest$GlobalNetworkId' => '<p>The ID of the global network.</p>', 'UpdateNetworkResourceMetadataRequest$ResourceArn' => '<p>The ARN of the resource.</p>', 'UpdateNetworkResourceMetadataResponse$ResourceArn' => '<p>The ARN of the resource.</p>', 'UpdateSiteRequest$GlobalNetworkId' => '<p>The ID of the global network.</p>', 'UpdateSiteRequest$SiteId' => '<p>The ID of your site.</p>', 'UpdateSiteRequest$Description' => '<p>A description of your site.</p> <p>Constraints: Maximum length of 256 characters.</p>', 'ValidationException$Message' => NULL, 'ValidationExceptionField$Name' => '<p>The name of the field.</p>', 'ValidationExceptionField$Message' => '<p>The message for the field.</p>', ], ], 'StringList' => [ 'base' => NULL, 'refs' => [ 'DescribeGlobalNetworksRequest$GlobalNetworkIds' => '<p>The IDs of one or more global networks. The maximum is 10.</p>', 'GetConnectionsRequest$ConnectionIds' => '<p>One or more connection IDs.</p>', 'GetCustomerGatewayAssociationsRequest$CustomerGatewayArns' => '<p>One or more customer gateway Amazon Resource Names (ARNs). The maximum is 10.</p>', 'GetDevicesRequest$DeviceIds' => '<p>One or more device IDs. The maximum is 10.</p>', 'GetLinksRequest$LinkIds' => '<p>One or more link IDs. The maximum is 10.</p>', 'GetNetworkRoutesRequest$ExactCidrMatches' => '<p>An exact CIDR block.</p>', 'GetNetworkRoutesRequest$LongestPrefixMatches' => '<p>The most specific route that matches the traffic (longest prefix match).</p>', 'GetNetworkRoutesRequest$SubnetOfMatches' => '<p>The routes with a subnet that match the specified CIDR filter.</p>', 'GetNetworkRoutesRequest$SupernetOfMatches' => '<p>The routes with a CIDR that encompasses the CIDR filter. Example: If you specify 10.0.1.0/30, then the result returns 10.0.1.0/29.</p>', 'GetNetworkRoutesRequest$PrefixListIds' => '<p>The IDs of the prefix lists.</p>', 'GetSitesRequest$SiteIds' => '<p>One or more site IDs. The maximum is 10.</p>', 'GetTransitGatewayConnectPeerAssociationsRequest$TransitGatewayConnectPeerArns' => '<p>One or more transit gateway Connect peer Amazon Resource Names (ARNs).</p>', 'GetTransitGatewayRegistrationsRequest$TransitGatewayArns' => '<p>The Amazon Resource Names (ARNs) of one or more transit gateways. The maximum is 10.</p>', ], ], 'Tag' => [ 'base' => '<p>Describes a tag.</p>', 'refs' => [ 'TagList$member' => NULL, ], ], 'TagKey' => [ 'base' => NULL, 'refs' => [ 'Tag$Key' => '<p>The tag key.</p> <p>Constraints: Maximum length of 128 characters.</p>', 'TagKeyList$member' => NULL, ], ], 'TagKeyList' => [ 'base' => NULL, 'refs' => [ 'UntagResourceRequest$TagKeys' => '<p>The tag keys to remove from the specified resource.</p>', ], ], 'TagList' => [ 'base' => NULL, 'refs' => [ 'Connection$Tags' => '<p>The tags for the connection.</p>', 'CreateConnectionRequest$Tags' => '<p>The tags to apply to the resource during creation.</p>', 'CreateDeviceRequest$Tags' => '<p>The tags to apply to the resource during creation.</p>', 'CreateGlobalNetworkRequest$Tags' => '<p>The tags to apply to the resource during creation.</p>', 'CreateLinkRequest$Tags' => '<p>The tags to apply to the resource during creation.</p>', 'CreateSiteRequest$Tags' => '<p>The tags to apply to the resource during creation.</p>', 'Device$Tags' => '<p>The tags for the device.</p>', 'GlobalNetwork$Tags' => '<p>The tags for the global network.</p>', 'Link$Tags' => '<p>The tags for the link.</p>', 'ListTagsForResourceResponse$TagList' => '<p>The list of tags.</p>', 'NetworkResource$Tags' => '<p>The tags.</p>', 'Site$Tags' => '<p>The tags for the site.</p>', 'TagResourceRequest$Tags' => '<p>The tags to apply to the specified resource.</p>', ], ], 'TagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'TagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'TagValue' => [ 'base' => NULL, 'refs' => [ 'Tag$Value' => '<p>The tag value.</p> <p>Constraints: Maximum length of 256 characters.</p>', ], ], 'ThrottlingException' => [ 'base' => '<p>The request was denied due to request throttling.</p>', 'refs' => [], ], 'TransitGatewayConnectPeerAssociation' => [ 'base' => '<p>Describes a transit gateway Connect peer association.</p>', 'refs' => [ 'AssociateTransitGatewayConnectPeerResponse$TransitGatewayConnectPeerAssociation' => '<p>The transit gateway Connect peer association.</p>', 'DisassociateTransitGatewayConnectPeerResponse$TransitGatewayConnectPeerAssociation' => '<p>The transit gateway Connect peer association.</p>', 'TransitGatewayConnectPeerAssociationList$member' => NULL, ], ], 'TransitGatewayConnectPeerAssociationList' => [ 'base' => NULL, 'refs' => [ 'GetTransitGatewayConnectPeerAssociationsResponse$TransitGatewayConnectPeerAssociations' => '<p>Information about the transit gateway Connect peer associations.</p>', ], ], 'TransitGatewayConnectPeerAssociationState' => [ 'base' => NULL, 'refs' => [ 'TransitGatewayConnectPeerAssociation$State' => '<p>The state of the association.</p>', ], ], 'TransitGatewayRegistration' => [ 'base' => '<p>Describes the registration of a transit gateway to a global network.</p>', 'refs' => [ 'DeregisterTransitGatewayResponse$TransitGatewayRegistration' => '<p>The transit gateway registration information.</p>', 'RegisterTransitGatewayResponse$TransitGatewayRegistration' => '<p>Information about the transit gateway registration.</p>', 'TransitGatewayRegistrationList$member' => NULL, ], ], 'TransitGatewayRegistrationList' => [ 'base' => NULL, 'refs' => [ 'GetTransitGatewayRegistrationsResponse$TransitGatewayRegistrations' => '<p>The transit gateway registrations.</p>', ], ], 'TransitGatewayRegistrationState' => [ 'base' => NULL, 'refs' => [ 'TransitGatewayRegistrationStateReason$Code' => '<p>The code for the state reason.</p>', ], ], 'TransitGatewayRegistrationStateReason' => [ 'base' => '<p>Describes the status of a transit gateway registration.</p>', 'refs' => [ 'TransitGatewayRegistration$State' => '<p>The state of the transit gateway registration.</p>', ], ], 'UntagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'UntagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateConnectionRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateConnectionResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateDeviceRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateDeviceResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateGlobalNetworkRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateGlobalNetworkResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateLinkRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateLinkResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateNetworkResourceMetadataRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateNetworkResourceMetadataResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateSiteRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateSiteResponse' => [ 'base' => NULL, 'refs' => [], ], 'ValidationException' => [ 'base' => '<p>The input fails to satisfy the constraints.</p>', 'refs' => [], ], 'ValidationExceptionField' => [ 'base' => '<p>Describes a validation exception for a field.</p>', 'refs' => [ 'ValidationExceptionFieldList$member' => NULL, ], ], 'ValidationExceptionFieldList' => [ 'base' => NULL, 'refs' => [ 'ValidationException$Fields' => '<p>The fields that caused the error, if applicable.</p>', ], ], 'ValidationExceptionReason' => [ 'base' => NULL, 'refs' => [ 'ValidationException$Reason' => '<p>The reason for the error.</p>', ], ], ],];
