<?php
// This file was auto-generated from sdk-root/src/data/mwaa/2020-07-01/docs-2.json
return [ 'version' => '2.0', 'service' => '<p><fullname>Amazon Managed Workflows for Apache Airflow</fullname> <p>This section contains the Amazon Managed Workflows for Apache Airflow (MWAA) API reference documentation. For more information, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/what-is-mwaa.html">What Is Amazon MWAA?</a>.</p></p>', 'operations' => [ 'CreateCliToken' => '<p>Create a CLI token to use Airflow CLI.</p>', 'CreateEnvironment' => '<p>Creates an Amazon Managed Workflows for Apache Airflow (MWAA) environment.</p>', 'CreateWebLoginToken' => '<p>Create a JWT token to be used to login to Airflow Web UI with claims based Authentication.</p>', 'DeleteEnvironment' => '<p>Deletes an Amazon Managed Workflows for Apache Airflow (MWAA) environment.</p>', 'GetEnvironment' => '<p>Retrieves the details of an Amazon Managed Workflows for Apache Airflow (MWAA) environment.</p>', 'ListEnvironments' => '<p>Lists the Amazon Managed Workflows for Apache Airflow (MWAA) environments.</p>', 'ListTagsForResource' => '<p>Lists the key-value tag pairs associated to the Amazon Managed Workflows for Apache Airflow (MWAA) environment. For example, <code>"Environment": "Staging"</code>. </p>', 'PublishMetrics' => '<p>An operation for publishing metrics from the customers to the Ops plane.</p>', 'TagResource' => '<p>Associates key-value tag pairs to your Amazon Managed Workflows for Apache Airflow (MWAA) environment. </p>', 'UntagResource' => '<p>Removes key-value tag pairs associated to your Amazon Managed Workflows for Apache Airflow (MWAA) environment. For example, <code>"Environment": "Staging"</code>.</p>', 'UpdateEnvironment' => '<p>Updates an Amazon Managed Workflows for Apache Airflow (MWAA) environment.</p>', ], 'shapes' => [ 'AccessDeniedException' => [ 'base' => '<p>Access to the Airflow Web UI or CLI has been Denied. Please follow the MWAA user guide to setup permissions to access the Web UI and CLI functionality.</p>', 'refs' => [], ], 'AirflowConfigurationOptions' => [ 'base' => NULL, 'refs' => [ 'Environment$AirflowConfigurationOptions' => '<p>A list of key-value pairs containing the Apache Airflow configuration options attached to your environment. To learn more, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-env-variables.html">Apache Airflow configuration options</a>.</p>', ], ], 'AirflowVersion' => [ 'base' => NULL, 'refs' => [ 'CreateEnvironmentInput$AirflowVersion' => '<p>The Apache Airflow version for your environment. For example, <code>v1.10.12</code>. If no value is specified, defaults to the latest version. Valid values: <code>v1.10.12</code>.</p>', 'Environment$AirflowVersion' => '<p>The Apache Airflow version on your environment. For example, <code>v1.10.12</code>.</p>', 'UpdateEnvironmentInput$AirflowVersion' => '<p>The Apache Airflow version for your environment. For example, <code>v1.10.12</code>. If no value is specified, defaults to the latest version. Valid values: <code>v1.10.12</code>.</p>', ], ], 'CloudWatchLogGroupArn' => [ 'base' => NULL, 'refs' => [ 'ModuleLoggingConfiguration$CloudWatchLogGroupArn' => '<p>The Amazon Resource Name (ARN) for the CloudWatch Logs group where the Apache Airflow log type (e.g. <code>DagProcessingLogs</code>) is published. For example, <code>arn:aws:logs:us-east-1:123456789012:log-group:airflow-MyMWAAEnvironment-MwaaEnvironment-DAGProcessing:*</code>.</p>', ], ], 'ConfigKey' => [ 'base' => NULL, 'refs' => [ 'AirflowConfigurationOptions$key' => NULL, 'SyntheticCreateEnvironmentInputAirflowConfigurationOptions$key' => NULL, 'SyntheticUpdateEnvironmentInputAirflowConfigurationOptions$key' => NULL, ], ], 'ConfigValue' => [ 'base' => NULL, 'refs' => [ 'AirflowConfigurationOptions$value' => NULL, 'SyntheticCreateEnvironmentInputAirflowConfigurationOptions$value' => NULL, 'SyntheticUpdateEnvironmentInputAirflowConfigurationOptions$value' => NULL, ], ], 'CreateCliTokenRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateCliTokenResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateEnvironmentInput' => [ 'base' => '<p>This section contains the Amazon Managed Workflows for Apache Airflow (MWAA) API reference documentation to create an environment. For more information, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/get-started.html">Get started with Amazon Managed Workflows for Apache Airflow</a>.</p>', 'refs' => [], ], 'CreateEnvironmentOutput' => [ 'base' => NULL, 'refs' => [], ], 'CreateWebLoginTokenRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateWebLoginTokenResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreatedAt' => [ 'base' => NULL, 'refs' => [ 'Environment$CreatedAt' => '<p>The day and time the environment was created.</p>', ], ], 'DeleteEnvironmentInput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteEnvironmentOutput' => [ 'base' => NULL, 'refs' => [], ], 'Dimension' => [ 'base' => '<p>Internal only API.</p>', 'refs' => [ 'Dimensions$member' => NULL, ], ], 'Dimensions' => [ 'base' => NULL, 'refs' => [ 'MetricDatum$Dimensions' => '<p>Internal only API.</p>', ], ], 'Double' => [ 'base' => NULL, 'refs' => [ 'MetricDatum$Value' => '<p>Internal only API.</p>', 'StatisticSet$Maximum' => '<p>Internal only API.</p>', 'StatisticSet$Minimum' => '<p>Internal only API.</p>', 'StatisticSet$Sum' => '<p>Internal only API.</p>', ], ], 'Environment' => [ 'base' => '<p>The Amazon Managed Workflows for Apache Airflow (MWAA) environment.</p>', 'refs' => [ 'GetEnvironmentOutput$Environment' => '<p>An object containing all available details about the environment.</p>', ], ], 'EnvironmentArn' => [ 'base' => NULL, 'refs' => [ 'CreateEnvironmentOutput$Arn' => '<p>The Amazon Resource Name (ARN) returned in the response for the environment.</p>', 'Environment$Arn' => '<p>The Amazon Resource Name (ARN) of the Amazon MWAA environment.</p>', 'ListTagsForResourceInput$ResourceArn' => '<p>The Amazon Resource Name (ARN) of the Amazon MWAA environment. For example, <code>arn:aws:airflow:us-east-1:123456789012:environment/MyMWAAEnvironment</code>.</p>', 'TagResourceInput$ResourceArn' => '<p>The Amazon Resource Name (ARN) of the Amazon MWAA environment. For example, <code>arn:aws:airflow:us-east-1:123456789012:environment/MyMWAAEnvironment</code>.</p>', 'UntagResourceInput$ResourceArn' => '<p>The Amazon Resource Name (ARN) of the Amazon MWAA environment. For example, <code>arn:aws:airflow:us-east-1:123456789012:environment/MyMWAAEnvironment</code>.</p>', 'UpdateEnvironmentOutput$Arn' => '<p>The Amazon Resource Name (ARN) of the Amazon MWAA environment. For example, <code>arn:aws:airflow:us-east-1:123456789012:environment/MyMWAAEnvironment</code>.</p>', ], ], 'EnvironmentClass' => [ 'base' => NULL, 'refs' => [ 'CreateEnvironmentInput$EnvironmentClass' => '<p>The environment class type. Valid values: <code>mw1.small</code>, <code>mw1.medium</code>, <code>mw1.large</code>. To learn more, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/environment-class.html">Amazon MWAA environment class</a>.</p>', 'Environment$EnvironmentClass' => '<p>The environment class type. Valid values: <code>mw1.small</code>, <code>mw1.medium</code>, <code>mw1.large</code>. To learn more, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/environment-class.html">Amazon MWAA environment class</a>.</p>', 'UpdateEnvironmentInput$EnvironmentClass' => '<p>The environment class type. Valid values: <code>mw1.small</code>, <code>mw1.medium</code>, <code>mw1.large</code>. To learn more, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/environment-class.html">Amazon MWAA environment class</a>.</p>', ], ], 'EnvironmentList' => [ 'base' => NULL, 'refs' => [ 'ListEnvironmentsOutput$Environments' => '<p>Returns the list of Amazon MWAA environments.</p>', ], ], 'EnvironmentName' => [ 'base' => NULL, 'refs' => [ 'CreateCliTokenRequest$Name' => '<p>Create a CLI token request for a MWAA environment.</p>', 'CreateEnvironmentInput$Name' => '<p>The name of the Amazon MWAA environment. For example, <code>MyMWAAEnvironment</code>.</p>', 'CreateWebLoginTokenRequest$Name' => '<p>Create an Airflow Web UI login token request for a MWAA environment.</p>', 'DeleteEnvironmentInput$Name' => '<p>The name of the Amazon MWAA environment. For example, <code>MyMWAAEnvironment</code>.</p>', 'Environment$Name' => '<p>The name of the Amazon MWAA environment. For example, <code>MyMWAAEnvironment</code>.</p>', 'EnvironmentList$member' => NULL, 'GetEnvironmentInput$Name' => '<p>The name of the Amazon MWAA environment. For example, <code>MyMWAAEnvironment</code>.</p>', 'PublishMetricsInput$EnvironmentName' => '<p>Publishes environment metric data to Amazon CloudWatch.</p>', 'UpdateEnvironmentInput$Name' => '<p>The name of your Amazon MWAA environment. For example, <code>MyMWAAEnvironment</code>.</p>', ], ], 'EnvironmentStatus' => [ 'base' => NULL, 'refs' => [ 'Environment$Status' => '<p>The status of the Amazon MWAA environment. Valid values:</p> <ul> <li> <p> <code>CREATING</code> - Indicates the request to create the environment is in progress.</p> </li> <li> <p> <code>CREATE_FAILED</code> - Indicates the request to create the environment failed, and the environment could not be created.</p> </li> <li> <p> <code>AVAILABLE</code> - Indicates the request was successful and the environment is ready to use.</p> </li> <li> <p> <code>UPDATING</code> - Indicates the request to update the environment is in progress.</p> </li> <li> <p> <code>DELETING</code> - Indicates the request to delete the environment is in progress.</p> </li> <li> <p> <code>DELETED</code> - Indicates the request to delete the environment is complete, and the environment has been deleted.</p> </li> <li> <p> <code>UNAVAILABLE</code> - Indicates the request failed, but the environment was unable to rollback and is not in a stable state.</p> </li> <li> <p> <code>UPDATE_FAILED</code> - Indicates the request to update the environment failed, and the environment has rolled back successfully and is ready to use.</p> </li> </ul> <p>We recommend reviewing our troubleshooting guide for a list of common errors and their solutions. To learn more, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/troubleshooting.html">Amazon MWAA troubleshooting</a>.</p>', ], ], 'ErrorCode' => [ 'base' => NULL, 'refs' => [ 'UpdateError$ErrorCode' => '<p>The error code that corresponds to the error with the last update.</p>', ], ], 'ErrorMessage' => [ 'base' => NULL, 'refs' => [ 'UpdateError$ErrorMessage' => '<p>The error message that corresponds to the error code.</p>', ], ], 'GetEnvironmentInput' => [ 'base' => NULL, 'refs' => [], ], 'GetEnvironmentOutput' => [ 'base' => NULL, 'refs' => [], ], 'Hostname' => [ 'base' => NULL, 'refs' => [ 'CreateCliTokenResponse$WebServerHostname' => '<p>Create an Airflow CLI login token response for the provided webserver hostname.</p>', 'CreateWebLoginTokenResponse$WebServerHostname' => '<p>Create an Airflow Web UI login token response for the provided webserver hostname.</p>', ], ], 'IamRoleArn' => [ 'base' => NULL, 'refs' => [ 'CreateEnvironmentInput$ExecutionRoleArn' => '<p>The Amazon Resource Name (ARN) of the execution role for your environment. An execution role is an AWS Identity and Access Management (IAM) role that grants MWAA permission to access AWS services and resources used by your environment. For example, <code>arn:aws:iam::123456789:role/my-execution-role</code>. To learn more, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/mwaa-create-role.html">Amazon MWAA Execution role</a>.</p>', 'Environment$ExecutionRoleArn' => '<p>The Amazon Resource Name (ARN) of the execution role in IAM that allows MWAA to access AWS resources in your environment. For example, <code>arn:aws:iam::123456789:role/my-execution-role</code>. To learn more, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/mwaa-create-role.html">Amazon MWAA Execution role</a>.</p>', 'Environment$ServiceRoleArn' => '<p>The Amazon Resource Name (ARN) for the service-linked role of the environment. To learn more, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/mwaa-slr.html">Amazon MWAA Service-linked role</a>.</p>', 'UpdateEnvironmentInput$ExecutionRoleArn' => '<p>The Amazon Resource Name (ARN) of the execution role in IAM that allows MWAA to access AWS resources in your environment. For example, <code>arn:aws:iam::123456789:role/my-execution-role</code>. To learn more, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/mwaa-create-role.html">Amazon MWAA Execution role</a>.</p>', ], ], 'Integer' => [ 'base' => NULL, 'refs' => [ 'StatisticSet$SampleCount' => '<p>Internal only API.</p>', ], ], 'InternalServerException' => [ 'base' => '<p>InternalServerException: An internal error has occurred.</p>', 'refs' => [], ], 'KmsKey' => [ 'base' => NULL, 'refs' => [ 'CreateEnvironmentInput$KmsKey' => '<p>The AWS Key Management Service (KMS) key to encrypt the data in your environment. You can use an AWS owned CMK, or a Customer managed CMK (advanced). To learn more, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/get-started.html">Get started with Amazon Managed Workflows for Apache Airflow</a>.</p>', 'Environment$KmsKey' => '<p>The Key Management Service (KMS) encryption key used to encrypt the data in your environment.</p>', ], ], 'LastUpdate' => [ 'base' => '<p>The status of the last update on the environment, and any errors that were encountered.</p>', 'refs' => [ 'Environment$LastUpdate' => NULL, ], ], 'ListEnvironmentsInput' => [ 'base' => NULL, 'refs' => [], ], 'ListEnvironmentsInputMaxResultsInteger' => [ 'base' => NULL, 'refs' => [ 'ListEnvironmentsInput$MaxResults' => '<p>The maximum number of results to retrieve per page. For example, <code>5</code> environments per page.</p>', ], ], 'ListEnvironmentsOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceInput' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceOutput' => [ 'base' => NULL, 'refs' => [], ], 'LoggingConfiguration' => [ 'base' => '<p>Defines the Apache Airflow logs to send to CloudWatch Logs: <code>DagProcessingLogs</code>, <code>SchedulerLogs</code>, <code>TaskLogs</code>, <code>WebserverLogs</code>, <code>WorkerLogs</code>.</p>', 'refs' => [ 'Environment$LoggingConfiguration' => '<p>The Apache Airflow logs being sent to CloudWatch Logs: <code>DagProcessingLogs</code>, <code>SchedulerLogs</code>, <code>TaskLogs</code>, <code>WebserverLogs</code>, <code>WorkerLogs</code>.</p>', ], ], 'LoggingConfigurationInput' => [ 'base' => '<p>Defines the Apache Airflow logs to send to CloudWatch Logs: <code>DagProcessingLogs</code>, <code>SchedulerLogs</code>, <code>TaskLogs</code>, <code>WebserverLogs</code>, <code>WorkerLogs</code>.</p>', 'refs' => [ 'CreateEnvironmentInput$LoggingConfiguration' => '<p>Defines the Apache Airflow logs to send to CloudWatch Logs: <code>DagProcessingLogs</code>, <code>SchedulerLogs</code>, <code>TaskLogs</code>, <code>WebserverLogs</code>, <code>WorkerLogs</code>.</p>', 'UpdateEnvironmentInput$LoggingConfiguration' => '<p>Defines the Apache Airflow logs to send to CloudWatch Logs: <code>DagProcessingLogs</code>, <code>SchedulerLogs</code>, <code>TaskLogs</code>, <code>WebserverLogs</code>, <code>WorkerLogs</code>.</p>', ], ], 'LoggingEnabled' => [ 'base' => NULL, 'refs' => [ 'ModuleLoggingConfiguration$Enabled' => '<p>Indicates whether to enable the Apache Airflow log type (e.g. <code>DagProcessingLogs</code>) in CloudWatch Logs.</p>', 'ModuleLoggingConfigurationInput$Enabled' => '<p>Indicates whether to enable the Apache Airflow log type (e.g. <code>DagProcessingLogs</code>) in CloudWatch Logs.</p>', ], ], 'LoggingLevel' => [ 'base' => NULL, 'refs' => [ 'ModuleLoggingConfiguration$LogLevel' => '<p>Defines the Apache Airflow logs to send for the log type (e.g. <code>DagProcessingLogs</code>) to CloudWatch Logs. Valid values: <code>CRITICAL</code>, <code>ERROR</code>, <code>WARNING</code>, <code>INFO</code>.</p>', 'ModuleLoggingConfigurationInput$LogLevel' => '<p>Defines the Apache Airflow logs to send for the log type (e.g. <code>DagProcessingLogs</code>) to CloudWatch Logs. Valid values: <code>CRITICAL</code>, <code>ERROR</code>, <code>WARNING</code>, <code>INFO</code>.</p>', ], ], 'MaxWorkers' => [ 'base' => NULL, 'refs' => [ 'CreateEnvironmentInput$MaxWorkers' => '<p>The maximum number of workers that you want to run in your environment. MWAA scales the number of Apache Airflow workers up to the number you specify in the <code>MaxWorkers</code> field. For example, <code>20</code>. When there are no more tasks running, and no more in the queue, MWAA disposes of the extra workers leaving the one worker that is included with your environment, or the number you specify in <code>MinWorkers</code>.</p>', 'Environment$MaxWorkers' => '<p>The maximum number of workers that run in your environment. For example, <code>20</code>.</p>', 'UpdateEnvironmentInput$MaxWorkers' => '<p>The maximum number of workers that you want to run in your environment. MWAA scales the number of Apache Airflow workers up to the number you specify in the <code>MaxWorkers</code> field. For example, <code>20</code>. When there are no more tasks running, and no more in the queue, MWAA disposes of the extra workers leaving the one worker that is included with your environment, or the number you specify in <code>MinWorkers</code>.</p>', ], ], 'MetricData' => [ 'base' => NULL, 'refs' => [ 'PublishMetricsInput$MetricData' => '<p>Publishes metric data points to Amazon CloudWatch. CloudWatch associates the data points with the specified metrica.</p>', ], ], 'MetricDatum' => [ 'base' => '<p>Internal only API.</p>', 'refs' => [ 'MetricData$member' => NULL, ], ], 'MinWorkers' => [ 'base' => NULL, 'refs' => [ 'CreateEnvironmentInput$MinWorkers' => '<p>The minimum number of workers that you want to run in your environment. MWAA scales the number of Apache Airflow workers up to the number you specify in the <code>MaxWorkers</code> field. When there are no more tasks running, and no more in the queue, MWAA disposes of the extra workers leaving the worker count you specify in the <code>MinWorkers</code> field. For example, <code>2</code>.</p>', 'Environment$MinWorkers' => '<p>The minimum number of workers that run in your environment. For example, <code>2</code>.</p>', 'UpdateEnvironmentInput$MinWorkers' => '<p>The minimum number of workers that you want to run in your environment. MWAA scales the number of Apache Airflow workers up to the number you specify in the <code>MaxWorkers</code> field. When there are no more tasks running, and no more in the queue, MWAA disposes of the extra workers leaving the worker count you specify in the <code>MinWorkers</code> field. For example, <code>2</code>.</p>', ], ], 'ModuleLoggingConfiguration' => [ 'base' => '<p>Defines the type of logs to send for the Apache Airflow log type (e.g. <code>DagProcessingLogs</code>). Valid values: <code>CloudWatchLogGroupArn</code>, <code>Enabled</code>, <code>LogLevel</code>.</p>', 'refs' => [ 'LoggingConfiguration$DagProcessingLogs' => NULL, 'LoggingConfiguration$SchedulerLogs' => NULL, 'LoggingConfiguration$TaskLogs' => NULL, 'LoggingConfiguration$WebserverLogs' => NULL, 'LoggingConfiguration$WorkerLogs' => NULL, ], ], 'ModuleLoggingConfigurationInput' => [ 'base' => '<p>Defines the type of logs to send for the Apache Airflow log type (e.g. <code>DagProcessingLogs</code>). Valid values: <code>CloudWatchLogGroupArn</code>, <code>Enabled</code>, <code>LogLevel</code>.</p>', 'refs' => [ 'LoggingConfigurationInput$DagProcessingLogs' => NULL, 'LoggingConfigurationInput$SchedulerLogs' => NULL, 'LoggingConfigurationInput$TaskLogs' => NULL, 'LoggingConfigurationInput$WebserverLogs' => NULL, 'LoggingConfigurationInput$WorkerLogs' => NULL, ], ], 'NetworkConfiguration' => [ 'base' => '<p>The VPC networking components used to secure and enable network traffic between the AWS resources for your environment. To learn more, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/networking-about.html">About networking on Amazon MWAA</a>.</p>', 'refs' => [ 'CreateEnvironmentInput$NetworkConfiguration' => '<p>The VPC networking components used to secure and enable network traffic between the AWS resources for your environment. To learn more, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/networking-about.html">About networking on Amazon MWAA</a>.</p>', 'Environment$NetworkConfiguration' => NULL, ], ], 'NextToken' => [ 'base' => NULL, 'refs' => [ 'ListEnvironmentsInput$NextToken' => '<p>Retrieves the next page of the results.</p>', 'ListEnvironmentsOutput$NextToken' => '<p>Retrieves the next page of the results.</p>', ], ], 'PublishMetricsInput' => [ 'base' => NULL, 'refs' => [], ], 'PublishMetricsOutput' => [ 'base' => NULL, 'refs' => [], ], 'RelativePath' => [ 'base' => NULL, 'refs' => [ 'CreateEnvironmentInput$DagS3Path' => '<p>The relative path to the DAGs folder on your Amazon S3 bucket. For example, <code>dags</code>. To learn more, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-dag-folder.html">Adding or updating DAGs</a>.</p>', 'CreateEnvironmentInput$PluginsS3Path' => '<p>The relative path to the <code>plugins.zip</code> file on your Amazon S3 bucket. For example, <code>plugins.zip</code>. If specified, then the plugins.zip version is required. To learn more, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-dag-import-plugins.html">Installing custom plugins</a>.</p>', 'CreateEnvironmentInput$RequirementsS3Path' => '<p>The relative path to the <code>requirements.txt</code> file on your Amazon S3 bucket. For example, <code>requirements.txt</code>. If specified, then a file version is required. To learn more, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/working-dags-dependencies.html">Installing Python dependencies</a>.</p>', 'Environment$DagS3Path' => '<p>The relative path to the DAGs folder on your Amazon S3 bucket. For example, <code>dags</code>. To learn more, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-dag-folder.html">Adding or updating DAGs</a>.</p>', 'Environment$PluginsS3Path' => '<p>The relative path to the <code>plugins.zip</code> file on your Amazon S3 bucket. For example, <code>plugins.zip</code>. To learn more, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-dag-import-plugins.html">Installing custom plugins</a>.</p>', 'Environment$RequirementsS3Path' => '<p>The relative path to the <code>requirements.txt</code> file on your Amazon S3 bucket. For example, <code>requirements.txt</code>. To learn more, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/working-dags-dependencies.html">Installing Python dependencies</a>.</p>', 'UpdateEnvironmentInput$DagS3Path' => '<p>The relative path to the DAGs folder on your Amazon S3 bucket. For example, <code>dags</code>. To learn more, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-dag-folder.html">Adding or updating DAGs</a>.</p>', 'UpdateEnvironmentInput$PluginsS3Path' => '<p>The relative path to the <code>plugins.zip</code> file on your Amazon S3 bucket. For example, <code>plugins.zip</code>. If specified, then the plugins.zip version is required. To learn more, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-dag-import-plugins.html">Installing custom plugins</a>.</p>', 'UpdateEnvironmentInput$RequirementsS3Path' => '<p>The relative path to the <code>requirements.txt</code> file on your Amazon S3 bucket. For example, <code>requirements.txt</code>. If specified, then a file version is required. To learn more, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/working-dags-dependencies.html">Installing Python dependencies</a>.</p>', ], ], 'ResourceNotFoundException' => [ 'base' => '<p>ResourceNotFoundException: The resource is not available.</p>', 'refs' => [], ], 'S3BucketArn' => [ 'base' => NULL, 'refs' => [ 'CreateEnvironmentInput$SourceBucketArn' => '<p>The Amazon Resource Name (ARN) of the Amazon S3 bucket where your DAG code and supporting files are stored. For example, <code>arn:aws:s3:::my-airflow-bucket-unique-name</code>. To learn more, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/mwaa-s3-bucket.html">Create an Amazon S3 bucket for Amazon MWAA</a>.</p>', 'Environment$SourceBucketArn' => '<p>The Amazon Resource Name (ARN) of the Amazon S3 bucket where your DAG code and supporting files are stored. For example, <code>arn:aws:s3:::my-airflow-bucket-unique-name</code>. To learn more, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/mwaa-s3-bucket.html">Create an Amazon S3 bucket for Amazon MWAA</a>.</p>', 'UpdateEnvironmentInput$SourceBucketArn' => '<p>The Amazon Resource Name (ARN) of the Amazon S3 bucket where your DAG code and supporting files are stored. For example, <code>arn:aws:s3:::my-airflow-bucket-unique-name</code>. To learn more, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/mwaa-s3-bucket.html">Create an Amazon S3 bucket for Amazon MWAA</a>.</p>', ], ], 'S3ObjectVersion' => [ 'base' => NULL, 'refs' => [ 'CreateEnvironmentInput$PluginsS3ObjectVersion' => '<p>The version of the plugins.zip file on your Amazon S3 bucket. A version must be specified each time a plugins.zip file is updated. To learn more, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/versioning-workflows.html">How S3 Versioning works</a>.</p>', 'CreateEnvironmentInput$RequirementsS3ObjectVersion' => '<p>The version of the requirements.txt file on your Amazon S3 bucket. A version must be specified each time a requirements.txt file is updated. To learn more, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/versioning-workflows.html">How S3 Versioning works</a>.</p>', 'Environment$PluginsS3ObjectVersion' => '<p>The version of the plugins.zip file on your Amazon S3 bucket. To learn more, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-dag-import-plugins.html">Installing custom plugins</a>.</p>', 'Environment$RequirementsS3ObjectVersion' => '<p>The version of the requirements.txt file on your Amazon S3 bucket. To learn more, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/working-dags-dependencies.html">Installing Python dependencies</a>.</p>', 'UpdateEnvironmentInput$PluginsS3ObjectVersion' => '<p>The version of the plugins.zip file on your Amazon S3 bucket. A version must be specified each time a plugins.zip file is updated. To learn more, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/versioning-workflows.html">How S3 Versioning works</a>.</p>', 'UpdateEnvironmentInput$RequirementsS3ObjectVersion' => '<p>The version of the requirements.txt file on your Amazon S3 bucket. A version must be specified each time a requirements.txt file is updated. To learn more, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/versioning-workflows.html">How S3 Versioning works</a>.</p>', ], ], 'Schedulers' => [ 'base' => NULL, 'refs' => [ 'CreateEnvironmentInput$Schedulers' => '<p>The number of Apache Airflow schedulers to run in your environment.</p>', 'Environment$Schedulers' => '<p>The number of Apache Airflow schedulers that run in your Amazon MWAA environment.</p>', 'UpdateEnvironmentInput$Schedulers' => '<p>The number of Apache Airflow schedulers to run in your Amazon MWAA environment.</p>', ], ], 'SecurityGroupId' => [ 'base' => NULL, 'refs' => [ 'SecurityGroupList$member' => NULL, ], ], 'SecurityGroupList' => [ 'base' => NULL, 'refs' => [ 'NetworkConfiguration$SecurityGroupIds' => '<p>A list of 1 or more security group IDs. Accepts up to 5 security group IDs. A security group must be attached to the same VPC as the subnets. To learn more, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/vpc-security.html">Security in your VPC on Amazon MWAA</a>.</p>', 'UpdateNetworkConfigurationInput$SecurityGroupIds' => '<p>A list of 1 or more security group IDs. Accepts up to 5 security group IDs. A security group must be attached to the same VPC as the subnets. To learn more, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/vpc-security.html">Security in your VPC on Amazon MWAA</a>.</p>', ], ], 'StatisticSet' => [ 'base' => '<p>Internal only API.</p>', 'refs' => [ 'MetricDatum$StatisticValues' => '<p>Internal only API.</p>', ], ], 'String' => [ 'base' => NULL, 'refs' => [ 'AccessDeniedException$Message' => NULL, 'Dimension$Name' => '<p>Internal only API.</p>', 'Dimension$Value' => '<p>Internal only API.</p>', 'InternalServerException$message' => NULL, 'MetricDatum$MetricName' => '<p>Internal only API.</p>', 'ResourceNotFoundException$message' => NULL, 'ValidationException$message' => NULL, ], ], 'SubnetId' => [ 'base' => NULL, 'refs' => [ 'SubnetList$member' => NULL, ], ], 'SubnetList' => [ 'base' => NULL, 'refs' => [ 'NetworkConfiguration$SubnetIds' => '<p>A list of 2 subnet IDs. <b>Required</b> to create an environment. Must be private subnets in two different availability zones. A subnet must be attached to the same VPC as the security group.</p>', ], ], 'SyntheticCreateCliTokenResponseToken' => [ 'base' => NULL, 'refs' => [ 'CreateCliTokenResponse$CliToken' => '<p>Create an Airflow CLI login token response for the provided JWT token.</p>', ], ], 'SyntheticCreateEnvironmentInputAirflowConfigurationOptions' => [ 'base' => NULL, 'refs' => [ 'CreateEnvironmentInput$AirflowConfigurationOptions' => '<p>A list of key-value pairs containing the Apache Airflow configuration options you want to attach to your environment. To learn more, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-env-variables.html">Apache Airflow configuration options</a>.</p>', ], ], 'SyntheticCreateWebLoginTokenResponseToken' => [ 'base' => NULL, 'refs' => [ 'CreateWebLoginTokenResponse$WebToken' => '<p>Create an Airflow Web UI login token response for the provided JWT token.</p>', ], ], 'SyntheticUpdateEnvironmentInputAirflowConfigurationOptions' => [ 'base' => NULL, 'refs' => [ 'UpdateEnvironmentInput$AirflowConfigurationOptions' => '<p>A list of key-value pairs containing the Apache Airflow configuration options you want to attach to your environment. To learn more, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-env-variables.html">Apache Airflow configuration options</a>.</p>', ], ], 'TagKey' => [ 'base' => NULL, 'refs' => [ 'TagKeyList$member' => NULL, 'TagMap$key' => NULL, ], ], 'TagKeyList' => [ 'base' => NULL, 'refs' => [ 'UntagResourceInput$tagKeys' => '<p>The key-value tag pair you want to remove. For example, <code>"Environment": "Staging"</code>. </p>', ], ], 'TagMap' => [ 'base' => NULL, 'refs' => [ 'CreateEnvironmentInput$Tags' => '<p>The key-value tag pairs you want to associate to your environment. For example, <code>"Environment": "Staging"</code>. To learn more, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging AWS resources</a>.</p>', 'Environment$Tags' => '<p>The key-value tag pairs associated to your environment. For example, <code>"Environment": "Staging"</code>. To learn more, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging AWS resources</a>.</p>', 'ListTagsForResourceOutput$Tags' => '<p>The key-value tag pairs associated to your environment. To learn more, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging AWS resources</a>.</p>', 'TagResourceInput$Tags' => '<p>The key-value tag pairs you want to associate to your environment. For example, <code>"Environment": "Staging"</code>. To learn more, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging AWS resources</a>.</p>', ], ], 'TagResourceInput' => [ 'base' => NULL, 'refs' => [], ], 'TagResourceOutput' => [ 'base' => NULL, 'refs' => [], ], 'TagValue' => [ 'base' => NULL, 'refs' => [ 'TagMap$value' => NULL, ], ], 'Timestamp' => [ 'base' => NULL, 'refs' => [ 'MetricDatum$Timestamp' => '<p>Internal only API.</p>', ], ], 'Unit' => [ 'base' => '<p>Unit</p>', 'refs' => [ 'MetricDatum$Unit' => NULL, ], ], 'UntagResourceInput' => [ 'base' => NULL, 'refs' => [], ], 'UntagResourceOutput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateCreatedAt' => [ 'base' => NULL, 'refs' => [ 'LastUpdate$CreatedAt' => '<p>The day and time of the last update on the environment.</p>', ], ], 'UpdateEnvironmentInput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateEnvironmentOutput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateError' => [ 'base' => '<p>An object containing the error encountered with the last update: <code>ErrorCode</code>, <code>ErrorMessage</code>.</p>', 'refs' => [ 'LastUpdate$Error' => '<p>The error that was encountered during the last update of the environment.</p>', ], ], 'UpdateNetworkConfigurationInput' => [ 'base' => '<p>The VPC networking components used to secure and enable network traffic between the AWS resources for your environment. To learn more, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/networking-about.html">About networking on Amazon MWAA</a>.</p>', 'refs' => [ 'UpdateEnvironmentInput$NetworkConfiguration' => '<p>The VPC networking components used to secure and enable network traffic between the AWS resources for your environment. To learn more, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/networking-about.html">About networking on Amazon MWAA</a>.</p>', ], ], 'UpdateStatus' => [ 'base' => NULL, 'refs' => [ 'LastUpdate$Status' => '<p>The status of the last update on the environment. Valid values: <code>SUCCESS</code>, <code>PENDING</code>, <code>FAILED</code>.</p>', ], ], 'ValidationException' => [ 'base' => '<p>ValidationException: The provided input is not valid.</p>', 'refs' => [], ], 'WebserverAccessMode' => [ 'base' => NULL, 'refs' => [ 'CreateEnvironmentInput$WebserverAccessMode' => '<p>The Apache Airflow <i>Web server</i> access mode. To learn more, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-networking.html">Apache Airflow access modes</a>.</p>', 'Environment$WebserverAccessMode' => '<p>The Apache Airflow <i>Web server</i> access mode. To learn more, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-networking.html">Apache Airflow access modes</a>.</p>', 'UpdateEnvironmentInput$WebserverAccessMode' => '<p>The Apache Airflow <i>Web server</i> access mode. To learn more, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-networking.html">Apache Airflow access modes</a>.</p>', ], ], 'WebserverUrl' => [ 'base' => NULL, 'refs' => [ 'Environment$WebserverUrl' => '<p>The Apache Airflow <i>Web server</i> host name for the Amazon MWAA environment. To learn more, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/access-airflow-ui.html">Accessing the Apache Airflow UI</a>.</p>', ], ], 'WeeklyMaintenanceWindowStart' => [ 'base' => NULL, 'refs' => [ 'CreateEnvironmentInput$WeeklyMaintenanceWindowStart' => '<p>The day and time of the week to start weekly maintenance updates of your environment in the following format: <code>DAY:HH:MM</code>. For example: <code>TUE:03:30</code>. You can specify a start time in 30 minute increments only. Supported input includes the following:</p> <ul> <li> <p>MON|TUE|WED|THU|FRI|SAT|SUN:([01]\\\\d|2[0-3]):(00|30)</p> </li> </ul>', 'Environment$WeeklyMaintenanceWindowStart' => '<p>The day and time of the week that weekly maintenance updates are scheduled. For example: <code>TUE:03:30</code>.</p>', 'UpdateEnvironmentInput$WeeklyMaintenanceWindowStart' => '<p>The day and time of the week to start weekly maintenance updates of your environment in the following format: <code>DAY:HH:MM</code>. For example: <code>TUE:03:30</code>. You can specify a start time in 30 minute increments only. Supported input includes the following:</p> <ul> <li> <p>MON|TUE|WED|THU|FRI|SAT|SUN:([01]\\\\d|2[0-3]):(00|30)</p> </li> </ul>', ], ], ],];
