<?php
// This file was auto-generated from sdk-root/src/data/lookoutvision/2020-11-20/docs-2.json
return [ 'version' => '2.0', 'service' => '<p>This is the Amazon Lookout for Vision API Reference. It provides descriptions of actions, data types, common parameters, and common errors.</p> <p>Amazon Lookout for Vision enables you to find visual defects in industrial products, accurately and at scale. It uses computer vision to identify missing components in an industrial product, damage to vehicles or structures, irregularities in production lines, and even minuscule defects in silicon wafers — or any other physical item where quality is important such as a missing capacitor on printed circuit boards.</p>', 'operations' => [ 'CreateDataset' => '<p>Creates a new dataset in an Amazon Lookout for Vision project. <code>CreateDataset</code> can create a training or a test dataset from a valid dataset source (<code>DatasetSource</code>).</p> <p>If you want a single dataset project, specify <code>train</code> for the value of <code>DatasetType</code>.</p> <p>To have a project with separate training and test datasets, call <code>CreateDataset</code> twice. On the first call, specify <code>train</code> for the value of <code>DatasetType</code>. On the second call, specify <code>test</code> for the value of <code>DatasetType</code>. </p> <p>This operation requires permissions to perform the <code>lookoutvision:CreateDataset</code> operation.</p>', 'CreateModel' => '<p>Creates a new version of a model within an an Amazon Lookout for Vision project. <code>CreateModel</code> is an asynchronous operation in which Amazon Lookout for Vision trains, tests, and evaluates a new version of a model. </p> <p>To get the current status, check the <code>Status</code> field returned in the response from <a>DescribeModel</a>.</p> <p>If the project has a single dataset, Amazon Lookout for Vision internally splits the dataset to create a training and a test dataset. If the project has a training and a test dataset, Lookout for Vision uses the respective datasets to train and test the model. </p> <p>After training completes, the evaluation metrics are stored at the location specified in <code>OutputConfig</code>. </p> <p>This operation requires permissions to perform the <code>lookoutvision:CreateModel</code> operation. If you want to tag your model, you also require permission to the <code>lookoutvision:TagResource</code> operation.</p>', 'CreateProject' => '<p>Creates an empty Amazon Lookout for Vision project. After you create the project, add a dataset by calling <a>CreateDataset</a>.</p> <p>This operation requires permissions to perform the <code>lookoutvision:CreateProject</code> operation.</p>', 'DeleteDataset' => '<p>Deletes an existing Amazon Lookout for Vision <code>dataset</code>. </p> <p>If your the project has a single dataset, you must create a new dataset before you can create a model.</p> <p>If you project has a training dataset and a test dataset consider the following. </p> <ul> <li> <p>If you delete the test dataset, your project reverts to a single dataset project. If you then train the model, Amazon Lookout for Vision internally splits the remaining dataset into a training and test dataset.</p> </li> <li> <p>If you delete the training dataset, you must create a training dataset before you can create a model.</p> </li> </ul> <p>This operation requires permissions to perform the <code>lookoutvision:DeleteDataset</code> operation.</p>', 'DeleteModel' => '<p>Deletes an Amazon Lookout for Vision model. You can\'t delete a running model. To stop a running model, use the <a>StopModel</a> operation.</p> <p>It might take a few seconds to delete a model. To determine if a model has been deleted, call <a>ListProjects</a> and check if the version of the model (<code>ModelVersion</code>) is in the <code>Models</code> array. </p> <p>This operation requires permissions to perform the <code>lookoutvision:DeleteModel</code> operation.</p>', 'DeleteProject' => '<p>Deletes an Amazon Lookout for Vision project.</p> <p>To delete a project, you must first delete each version of the model associated with the project. To delete a model use the <a>DeleteModel</a> operation.</p> <p>You also have to delete the dataset(s) associated with the model. For more information, see <a>DeleteDataset</a>. The images referenced by the training and test datasets aren\'t deleted. </p> <p>This operation requires permissions to perform the <code>lookoutvision:DeleteProject</code> operation.</p>', 'DescribeDataset' => '<p>Describe an Amazon Lookout for Vision dataset.</p> <p>This operation requires permissions to perform the <code>lookoutvision:DescribeDataset</code> operation.</p>', 'DescribeModel' => '<p>Describes a version of an Amazon Lookout for Vision model.</p> <p>This operation requires permissions to perform the <code>lookoutvision:DescribeModel</code> operation.</p>', 'DescribeProject' => '<p>Describes an Amazon Lookout for Vision project.</p> <p>This operation requires permissions to perform the <code>lookoutvision:DescribeProject</code> operation.</p>', 'DetectAnomalies' => '<p>Detects anomalies in an image that you supply. </p> <p>The response from <code>DetectAnomalies</code> includes a boolean prediction that the image contains one or more anomalies and a confidence value for the prediction.</p> <note> <p>Before calling <code>DetectAnomalies</code>, you must first start your model with the <a>StartModel</a> operation. You are charged for the amount of time, in minutes, that a model runs and for the number of anomaly detection units that your model uses. If you are not using a model, use the <a>StopModel</a> operation to stop your model. </p> </note> <p>This operation requires permissions to perform the <code>lookoutvision:DetectAnomalies</code> operation.</p>', 'ListDatasetEntries' => '<p>Lists the JSON Lines within a dataset. An Amazon Lookout for Vision JSON Line contains the anomaly information for a single image, including the image location and the assigned label.</p> <p>This operation requires permissions to perform the <code>lookoutvision:ListDatasetEntries</code> operation.</p>', 'ListModels' => '<p>Lists the versions of a model in an Amazon Lookout for Vision project.</p> <p>This operation requires permissions to perform the <code>lookoutvision:ListModels</code> operation.</p>', 'ListProjects' => '<p>Lists the Amazon Lookout for Vision projects in your AWS account.</p> <p>This operation requires permissions to perform the <code>lookoutvision:ListProjects</code> operation.</p>', 'ListTagsForResource' => '<p>Returns a list of tags attached to the specified Amazon Lookout for Vision model.</p> <p>This operation requires permissions to perform the <code>lookoutvision:ListTagsForResource</code> operation.</p>', 'StartModel' => '<p>Starts the running of the version of an Amazon Lookout for Vision model. Starting a model takes a while to complete. To check the current state of the model, use <a>DescribeModel</a>.</p> <p>A model is ready to use when its status is <code>HOSTED</code>.</p> <p>Once the model is running, you can detect custom labels in new images by calling <a>DetectAnomalies</a>.</p> <note> <p>You are charged for the amount of time that the model is running. To stop a running model, call <a>StopModel</a>.</p> </note> <p>This operation requires permissions to perform the <code>lookoutvision:StartModel</code> operation.</p>', 'StopModel' => '<p>Stops the hosting of a running model. The operation might take a while to complete. To check the current status, call <a>DescribeModel</a>. </p> <p>After the model hosting stops, the <code>Status</code> of the model is <code>TRAINED</code>.</p> <p>This operation requires permissions to perform the <code>lookoutvision:StopModel</code> operation.</p>', 'TagResource' => '<p>Adds one or more key-value tags to an Amazon Lookout for Vision model. For more information, see <i>Tagging a model</i> in the <i>Amazon Lookout for Vision Developer Guide</i>. </p> <p>This operation requires permissions to perform the <code>lookoutvision:TagResource</code> operation.</p>', 'UntagResource' => '<p>Removes one or more tags from an Amazon Lookout for Vision model. For more information, see <i>Tagging a model</i> in the <i>Amazon Lookout for Vision Developer Guide</i>. </p> <p>This operation requires permissions to perform the <code>lookoutvision:UntagResource</code> operation.</p>', 'UpdateDatasetEntries' => '<p>Adds one or more JSON Line entries to a dataset. A JSON Line includes information about an image used for training or testing an Amazon Lookout for Vision model. The following is an example JSON Line.</p> <p>Updating a dataset might take a while to complete. To check the current status, call <a>DescribeDataset</a> and check the <code>Status</code> field in the response.</p> <p>This operation requires permissions to perform the <code>lookoutvision:UpdateDatasetEntries</code> operation.</p>', ], 'shapes' => [ 'AccessDeniedException' => [ 'base' => '<p>You are not authorized to perform the action.</p>', 'refs' => [], ], 'AnomalyClassFilter' => [ 'base' => NULL, 'refs' => [ 'ListDatasetEntriesRequest$AnomalyClass' => '<p>Specify <code>normal</code> to include only normal images. Specify <code>anomaly</code> to only include anomalous entries. If you don\'t specify a value, Amazon Lookout for Vision returns normal and anomalous images.</p>', ], ], 'Boolean' => [ 'base' => NULL, 'refs' => [ 'DetectAnomalyResult$IsAnomalous' => '<p>True if the image contains an anomaly, otherwise false.</p>', ], ], 'ClientToken' => [ 'base' => NULL, 'refs' => [ 'CreateDatasetRequest$ClientToken' => '<p>ClientToken is an idempotency token that ensures a call to <code>CreateDataset</code> completes only once. You choose the value to pass. For example, An issue, such as an network outage, might prevent you from getting a response from <code>CreateDataset</code>. In this case, safely retry your call to <code>CreateDataset</code> by using the same <code>ClientToken</code> parameter value. An error occurs if the other input parameters are not the same as in the first request. Using a different value for <code>ClientToken</code> is considered a new call to <code>CreateDataset</code>. An idempotency token is active for 8 hours. </p>', 'CreateModelRequest$ClientToken' => '<p>ClientToken is an idempotency token that ensures a call to <code>CreateModel</code> completes only once. You choose the value to pass. For example, An issue, such as an network outage, might prevent you from getting a response from <code>CreateModel</code>. In this case, safely retry your call to <code>CreateModel</code> by using the same <code>ClientToken</code> parameter value. An error occurs if the other input parameters are not the same as in the first request. Using a different value for <code>ClientToken</code> is considered a new call to <code>CreateModel</code>. An idempotency token is active for 8 hours.</p>', 'CreateProjectRequest$ClientToken' => '<p>ClientToken is an idempotency token that ensures a call to <code>CreateProject</code> completes only once. You choose the value to pass. For example, An issue, such as an network outage, might prevent you from getting a response from <code>CreateProject</code>. In this case, safely retry your call to <code>CreateProject</code> by using the same <code>ClientToken</code> parameter value. An error occurs if the other input parameters are not the same as in the first request. Using a different value for <code>ClientToken</code> is considered a new call to <code>CreateProject</code>. An idempotency token is active for 8 hours.</p>', 'DeleteDatasetRequest$ClientToken' => '<p>ClientToken is an idempotency token that ensures a call to <code>DeleteDataset</code> completes only once. You choose the value to pass. For example, An issue, such as an network outage, might prevent you from getting a response from <code>DeleteDataset</code>. In this case, safely retry your call to <code>DeleteDataset</code> by using the same <code>ClientToken</code> parameter value. An error occurs if the other input parameters are not the same as in the first request. Using a different value for <code>ClientToken</code> is considered a new call to <code>DeleteDataset</code>. An idempotency token is active for 8 hours.</p>', 'DeleteModelRequest$ClientToken' => '<p>ClientToken is an idempotency token that ensures a call to <code>DeleteModel</code> completes only once. You choose the value to pass. For example, An issue, such as an network outage, might prevent you from getting a response from <code>DeleteModel</code>. In this case, safely retry your call to <code>DeleteModel</code> by using the same <code>ClientToken</code> parameter value. An error occurs if the other input parameters are not the same as in the first request. Using a different value for <code>ClientToken</code> is considered a new call to <code>DeleteModel</code>. An idempotency token is active for 8 hours.</p>', 'DeleteProjectRequest$ClientToken' => '<p>ClientToken is an idempotency token that ensures a call to <code>DeleteProject</code> completes only once. You choose the value to pass. For example, An issue, such as an network outage, might prevent you from getting a response from <code>DeleteProject</code>. In this case, safely retry your call to <code>DeleteProject</code> by using the same <code>ClientToken</code> parameter value. An error occurs if the other input parameters are not the same as in the first request. Using a different value for <code>ClientToken</code> is considered a new call to <code>DeleteProject</code>. An idempotency token is active for 8 hours.</p>', 'StartModelRequest$ClientToken' => '<p>ClientToken is an idempotency token that ensures a call to <code>StartModel</code> completes only once. You choose the value to pass. For example, An issue, such as an network outage, might prevent you from getting a response from <code>StartModel</code>. In this case, safely retry your call to <code>StartModel</code> by using the same <code>ClientToken</code> parameter value. An error occurs if the other input parameters are not the same as in the first request. Using a different value for <code>ClientToken</code> is considered a new call to <code>StartModel</code>. An idempotency token is active for 8 hours. </p>', 'StopModelRequest$ClientToken' => '<p>ClientToken is an idempotency token that ensures a call to <code>StopModel</code> completes only once. You choose the value to pass. For example, An issue, such as an network outage, might prevent you from getting a response from <code>StopModel</code>. In this case, safely retry your call to <code>StopModel</code> by using the same <code>ClientToken</code> parameter value. An error occurs if the other input parameters are not the same as in the first request. Using a different value for <code>ClientToken</code> is considered a new call to <code>StopModel</code>. An idempotency token is active for 8 hours. </p>', 'UpdateDatasetEntriesRequest$ClientToken' => '<p>ClientToken is an idempotency token that ensures a call to <code>UpdateDatasetEntries</code> completes only once. You choose the value to pass. For example, An issue, such as an network outage, might prevent you from getting a response from <code>UpdateDatasetEntries</code>. In this case, safely retry your call to <code>UpdateDatasetEntries</code> by using the same <code>ClientToken</code> parameter value. An error occurs if the other input parameters are not the same as in the first request. Using a different value for <code>ClientToken</code> is considered a new call to <code>UpdateDatasetEntries</code>. An idempotency token is active for 8 hours. </p>', ], ], 'ConflictException' => [ 'base' => '<p>The update or deletion of a resource caused an inconsistent state.</p>', 'refs' => [], ], 'ContentType' => [ 'base' => NULL, 'refs' => [ 'DetectAnomaliesRequest$ContentType' => '<p>The type of the image passed in <code>Body</code>. Valid values are <code>image/png</code> (PNG format images) and <code>image/jpeg</code> (JPG format images). </p>', ], ], 'CreateDatasetRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateDatasetResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateModelRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateModelResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateProjectRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateProjectResponse' => [ 'base' => NULL, 'refs' => [], ], 'DatasetChanges' => [ 'base' => NULL, 'refs' => [ 'UpdateDatasetEntriesRequest$Changes' => '<p>The entries to add to the dataset.</p>', ], ], 'DatasetDescription' => [ 'base' => '<p>The description for a dataset. For more information, see <a>DescribeDataset</a>.</p>', 'refs' => [ 'DescribeDatasetResponse$DatasetDescription' => '<p>The description of the requested dataset. </p>', ], ], 'DatasetEntry' => [ 'base' => NULL, 'refs' => [ 'DatasetEntryList$member' => NULL, ], ], 'DatasetEntryList' => [ 'base' => NULL, 'refs' => [ 'ListDatasetEntriesResponse$DatasetEntries' => '<p>A list of the entries (JSON Lines) within the dataset.</p>', ], ], 'DatasetGroundTruthManifest' => [ 'base' => '<p>Location information about a manifest file. You can use a manifest file to create a dataset.</p>', 'refs' => [ 'DatasetSource$GroundTruthManifest' => '<p>Location information for the manifest file.</p>', ], ], 'DatasetImageStats' => [ 'base' => '<p>Statistics about the images in a dataset.</p>', 'refs' => [ 'DatasetDescription$ImageStats' => '<p/>', ], ], 'DatasetMetadata' => [ 'base' => '<p>Sumary information for an Amazon Lookout for Vision dataset.</p>', 'refs' => [ 'CreateDatasetResponse$DatasetMetadata' => '<p>Information about the dataset.</p>', 'DatasetMetadataList$member' => NULL, ], ], 'DatasetMetadataList' => [ 'base' => NULL, 'refs' => [ 'ProjectDescription$Datasets' => '<p>A list of datasets in the project.</p>', ], ], 'DatasetSource' => [ 'base' => '<p>Information about the location of a manifest file that Amazon Lookout for Vision uses to to create a dataset.</p>', 'refs' => [ 'CreateDatasetRequest$DatasetSource' => '<p>The location of the manifest file that Amazon Lookout for Vision uses to create the dataset.</p> <p>If you don\'t specify <code>DatasetSource</code>, an empty dataset is created and the operation synchronously returns. Later, you can add JSON Lines by calling <a>UpdateDatasetEntries</a>. </p> <p>If you specify a value for <code>DataSource</code>, the manifest at the S3 location is validated and used to create the dataset. The call to <code>CreateDataset</code> is asynchronous and might take a while to complete. To find out the current status, Check the value of <code>Status</code> returned in a call to <a>DescribeDataset</a>.</p>', ], ], 'DatasetStatus' => [ 'base' => NULL, 'refs' => [ 'DatasetDescription$Status' => '<p>The status of the dataset.</p>', 'DatasetMetadata$Status' => '<p>The status for the dataset.</p>', 'UpdateDatasetEntriesResponse$Status' => '<p>The status of the dataset update.</p>', ], ], 'DatasetStatusMessage' => [ 'base' => NULL, 'refs' => [ 'DatasetDescription$StatusMessage' => '<p>The status message for the dataset. </p>', 'DatasetMetadata$StatusMessage' => '<p>The status message for the dataset.</p>', ], ], 'DatasetType' => [ 'base' => NULL, 'refs' => [ 'CreateDatasetRequest$DatasetType' => '<p>The type of the dataset. Specify <code>train</code> for a training dataset. Specify <code>test</code> for a test dataset.</p>', 'DatasetDescription$DatasetType' => '<p>The type of the dataset. The value <code>train</code> represents a training dataset or single dataset project. The value <code>test</code> represents a test dataset.</p>', 'DatasetMetadata$DatasetType' => '<p>The type of the dataset.</p>', 'DeleteDatasetRequest$DatasetType' => '<p>The type of the dataset to delete. Specify <code>train</code> to delete the training dataset. Specify <code>test</code> to delete the test dataset. To delete the dataset in a single dataset project, specify <code>train</code>.</p>', 'DescribeDatasetRequest$DatasetType' => '<p>The type of the dataset to describe. Specify <code>train</code> to describe the training dataset. Specify <code>test</code> to describe the test dataset. If you have a single dataset project, specify <code>train</code> </p>', 'ListDatasetEntriesRequest$DatasetType' => '<p>The type of the dataset that you want to list. Specify <code>train</code> to list the training dataset. Specify <code>test</code> to list the test dataset. If you have a single dataset project, specify <code>train</code>.</p>', 'UpdateDatasetEntriesRequest$DatasetType' => '<p>The type of the dataset that you want to update. Specify <code>train</code> to update the training dataset. Specify <code>test</code> to update the test dataset. If you have a single dataset project, specify <code>train</code>.</p>', ], ], 'DateTime' => [ 'base' => NULL, 'refs' => [ 'DatasetDescription$CreationTimestamp' => '<p>The Unix timestamp for the time and date that the dataset was created.</p>', 'DatasetDescription$LastUpdatedTimestamp' => '<p>The Unix timestamp for the date and time that the dataset was last updated.</p>', 'DatasetMetadata$CreationTimestamp' => '<p>The Unix timestamp for the date and time that the dataset was created. </p>', 'ListDatasetEntriesRequest$BeforeCreationDate' => '<p>Only includes entries before the specified date in the response. For example, <code>2020-06-23T00:00:00</code>.</p>', 'ListDatasetEntriesRequest$AfterCreationDate' => '<p>Only includes entries after the specified date in the response. For example, <code>2020-06-23T00:00:00</code>.</p>', 'ModelDescription$CreationTimestamp' => '<p>The unix timestamp for the date and time that the model was created. </p>', 'ModelDescription$EvaluationEndTimestamp' => '<p>The unix timestamp for the date and time that the evaluation ended. </p>', 'ModelMetadata$CreationTimestamp' => '<p>The unix timestamp for the date and time that the model was created. </p>', 'ProjectDescription$CreationTimestamp' => '<p>The unix timestamp for the date and time that the project was created. </p>', 'ProjectMetadata$CreationTimestamp' => '<p>The unix timestamp for the date and time that the project was created. </p>', ], ], 'DeleteDatasetRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteDatasetResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteModelRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteModelResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteProjectRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteProjectResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeDatasetRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeDatasetResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeModelRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeModelResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeProjectRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeProjectResponse' => [ 'base' => NULL, 'refs' => [], ], 'DetectAnomaliesRequest' => [ 'base' => NULL, 'refs' => [], ], 'DetectAnomaliesResponse' => [ 'base' => NULL, 'refs' => [], ], 'DetectAnomalyResult' => [ 'base' => '<p>The prediction results from a call to <a>DetectAnomalies</a>.</p>', 'refs' => [ 'DetectAnomaliesResponse$DetectAnomalyResult' => '<p>The results of the <code>DetectAnomalies</code> operation.</p>', ], ], 'ExceptionString' => [ 'base' => NULL, 'refs' => [ 'AccessDeniedException$Message' => NULL, 'ConflictException$Message' => NULL, 'ConflictException$ResourceId' => '<p>The ID of the resource.</p>', 'InternalServerException$Message' => NULL, 'ResourceNotFoundException$Message' => NULL, 'ResourceNotFoundException$ResourceId' => '<p>The ID of the resource.</p>', 'ServiceQuotaExceededException$Message' => NULL, 'ServiceQuotaExceededException$ResourceId' => '<p>The ID of the resource.</p>', 'ServiceQuotaExceededException$QuotaCode' => '<p>The quota code. </p>', 'ServiceQuotaExceededException$ServiceCode' => '<p>The service code. </p>', 'ThrottlingException$Message' => NULL, 'ThrottlingException$QuotaCode' => '<p>The quota code. </p>', 'ThrottlingException$ServiceCode' => '<p>The service code. </p>', 'ValidationException$Message' => NULL, ], ], 'Float' => [ 'base' => NULL, 'refs' => [ 'DetectAnomalyResult$Confidence' => '<p>The confidence that Amazon Lookout for Vision has in the accuracy of the prediction.</p>', 'ModelPerformance$F1Score' => '<p>The overall F1 score metric for the trained model.</p>', 'ModelPerformance$Recall' => '<p>The overall recall metric value for the trained model. </p>', 'ModelPerformance$Precision' => '<p>The overall precision metric value for the trained model.</p>', ], ], 'ImageSource' => [ 'base' => '<p>The source for an image.</p>', 'refs' => [ 'DetectAnomalyResult$Source' => '<p>The source of the image that was analyzed. <code>direct</code> means that the images was supplied from the local computer. No other values are supported.</p>', ], ], 'ImageSourceType' => [ 'base' => NULL, 'refs' => [ 'ImageSource$Type' => '<p>The type of the image.</p>', ], ], 'InferenceUnits' => [ 'base' => NULL, 'refs' => [ 'StartModelRequest$MinInferenceUnits' => '<p>The minimum number of inference units to use. A single inference unit represents 1 hour of processing and can support up to 5 Transaction Pers Second (TPS). Use a higher number to increase the TPS throughput of your model. You are charged for the number of inference units that you use. </p>', ], ], 'InputS3Object' => [ 'base' => '<p>Amazon S3 Location information for an input manifest file. </p>', 'refs' => [ 'DatasetGroundTruthManifest$S3Object' => '<p>The S3 bucket location for the manifest file.</p>', ], ], 'Integer' => [ 'base' => NULL, 'refs' => [ 'DatasetImageStats$Total' => '<p>The total number of images in the dataset.</p>', 'DatasetImageStats$Labeled' => '<p>The total number of labeled images.</p>', 'DatasetImageStats$Normal' => '<p>The total number of images labeled as normal.</p>', 'DatasetImageStats$Anomaly' => '<p>the total number of images labeled as an anomaly.</p>', ], ], 'InternalServerException' => [ 'base' => '<p>Amazon Lookout for Vision experienced a service issue. Try your call again.</p>', 'refs' => [], ], 'IsLabeled' => [ 'base' => NULL, 'refs' => [ 'ListDatasetEntriesRequest$Labeled' => '<p>Specify <code>true</code> to include labeled entries, otherwise specify <code>false</code>. If you don\'t specify a value, Lookout for Vision returns all entries.</p>', ], ], 'KmsKeyId' => [ 'base' => NULL, 'refs' => [ 'CreateModelRequest$KmsKeyId' => '<p>The identifier for your AWS Key Management Service (AWS KMS) customer master key (CMK). The key is used to encrypt training and test images copied into the service for model training. Your source images are unaffected. If this parameter is not specified, the copied images are encrypted by a key that AWS owns and manages.</p>', 'ModelDescription$KmsKeyId' => '<p>The identifer for the AWS Key Management Service (AWS KMS) key that was used to encrypt the model during training.</p>', ], ], 'ListDatasetEntriesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListDatasetEntriesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListModelsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListModelsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListProjectsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListProjectsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'ModelArn' => [ 'base' => NULL, 'refs' => [ 'DeleteModelResponse$ModelArn' => '<p>The Amazon Resource Name (ARN) of the model that was deleted.</p>', 'ModelDescription$ModelArn' => '<p>The Amazon Resource Name (ARN) of the model.</p>', 'ModelMetadata$ModelArn' => '<p>The Amazon Resource Name (ARN) of the model.</p>', ], ], 'ModelDescription' => [ 'base' => '<p>Describes an Amazon Lookout for Vision model.</p>', 'refs' => [ 'DescribeModelResponse$ModelDescription' => '<p>Contains the description of the model.</p>', ], ], 'ModelDescriptionMessage' => [ 'base' => NULL, 'refs' => [ 'CreateModelRequest$Description' => '<p>A description for the version of the model.</p>', 'ModelDescription$Description' => '<p>The description for the model.</p>', 'ModelMetadata$Description' => '<p>The description for the model.</p>', ], ], 'ModelHostingStatus' => [ 'base' => NULL, 'refs' => [ 'StartModelResponse$Status' => '<p>The current running status of the model.</p>', 'StopModelResponse$Status' => '<p>The status of the model.</p>', ], ], 'ModelMetadata' => [ 'base' => '<p>Describes an Amazon Lookout for Vision model.</p>', 'refs' => [ 'CreateModelResponse$ModelMetadata' => '<p>The response from a call to <code>CreateModel</code>.</p>', 'ModelMetadataList$member' => NULL, ], ], 'ModelMetadataList' => [ 'base' => NULL, 'refs' => [ 'ListModelsResponse$Models' => '<p>A list of model versions in the specified project. </p>', ], ], 'ModelPerformance' => [ 'base' => '<p>Information about the evaluation performance of a trained model. </p>', 'refs' => [ 'ModelDescription$Performance' => '<p>Performance metrics for the model. Created during training.</p>', 'ModelMetadata$Performance' => '<p>Performance metrics for the model. Not available until training has successfully completed.</p>', ], ], 'ModelStatus' => [ 'base' => NULL, 'refs' => [ 'ModelDescription$Status' => '<p>The status of the model.</p>', 'ModelMetadata$Status' => '<p>The status of the model.</p>', ], ], 'ModelStatusMessage' => [ 'base' => NULL, 'refs' => [ 'ModelDescription$StatusMessage' => '<p>The status message for the model.</p>', 'ModelMetadata$StatusMessage' => '<p>The status message for the model.</p>', ], ], 'ModelVersion' => [ 'base' => NULL, 'refs' => [ 'DeleteModelRequest$ModelVersion' => '<p>The version of the model that you want to delete.</p>', 'DescribeModelRequest$ModelVersion' => '<p>The version of the model that you want to describe.</p>', 'DetectAnomaliesRequest$ModelVersion' => '<p>The version of the model that you want to use.</p>', 'ModelDescription$ModelVersion' => '<p>The version of the model</p>', 'ModelMetadata$ModelVersion' => '<p>The version of the model.</p>', 'StartModelRequest$ModelVersion' => '<p>The version of the model that you want to start.</p>', 'StopModelRequest$ModelVersion' => '<p>The version of the model that you want to stop.</p>', ], ], 'OutputConfig' => [ 'base' => '<p>The S3 location where Amazon Lookout for Vision saves model training files.</p>', 'refs' => [ 'CreateModelRequest$OutputConfig' => '<p>The location where Amazon Lookout for Vision saves the training results.</p>', 'ModelDescription$OutputConfig' => '<p>The S3 location where Amazon Lookout for Vision saves model training files.</p>', ], ], 'OutputS3Object' => [ 'base' => '<p>The S3 location where Amazon Lookout for Vision saves training output.</p>', 'refs' => [ 'ModelDescription$EvaluationManifest' => '<p>The S3 location where Amazon Lookout for Vision saves the manifest file that was used to test the trained model and generate the performance scores.</p>', 'ModelDescription$EvaluationResult' => '<p>The S3 location where Amazon Lookout for Vision saves the performance metrics.</p>', ], ], 'PageSize' => [ 'base' => NULL, 'refs' => [ 'ListDatasetEntriesRequest$MaxResults' => '<p>The maximum number of results to return per paginated call. The largest value you can specify is 100. If you specify a value greater than 100, a ValidationException error occurs. The default value is 100.</p>', 'ListModelsRequest$MaxResults' => '<p>The maximum number of results to return per paginated call. The largest value you can specify is 100. If you specify a value greater than 100, a ValidationException error occurs. The default value is 100.</p>', 'ListProjectsRequest$MaxResults' => '<p>The maximum number of results to return per paginated call. The largest value you can specify is 100. If you specify a value greater than 100, a ValidationException error occurs. The default value is 100.</p>', ], ], 'PaginationToken' => [ 'base' => NULL, 'refs' => [ 'ListDatasetEntriesRequest$NextToken' => '<p>If the previous response was incomplete (because there is more data to retrieve), Amazon Lookout for Vision returns a pagination token in the response. You can use this pagination token to retrieve the next set of dataset entries.</p>', 'ListDatasetEntriesResponse$NextToken' => '<p>If the response is truncated, Amazon Lookout for Vision returns this token that you can use in the subsequent request to retrieve the next set ofdataset entries.</p>', 'ListModelsRequest$NextToken' => '<p>If the previous response was incomplete (because there is more data to retrieve), Amazon Lookout for Vision returns a pagination token in the response. You can use this pagination token to retrieve the next set of models.</p>', 'ListModelsResponse$NextToken' => '<p>If the response is truncated, Amazon Lookout for Vision returns this token that you can use in the subsequent request to retrieve the next set of models. </p>', 'ListProjectsRequest$NextToken' => '<p>If the previous response was incomplete (because there is more data to retrieve), Amazon Lookout for Vision returns a pagination token in the response. You can use this pagination token to retrieve the next set of projects.</p>', 'ListProjectsResponse$NextToken' => '<p>If the response is truncated, Amazon Lookout for Vision returns this token that you can use in the subsequent request to retrieve the next set of projects.</p>', ], ], 'ProjectArn' => [ 'base' => NULL, 'refs' => [ 'DeleteProjectResponse$ProjectArn' => '<p>The Amazon Resource Name (ARN) of the project that was deleted.</p>', 'ProjectDescription$ProjectArn' => '<p>The Amazon Resource Name (ARN) of the project.</p>', 'ProjectMetadata$ProjectArn' => '<p>The Amazon Resource Name (ARN) of the project.</p>', ], ], 'ProjectDescription' => [ 'base' => '<p>Describe an Amazon Lookout for Vision project. For more information, see <a>DescribeProject</a>.</p>', 'refs' => [ 'DescribeProjectResponse$ProjectDescription' => '<p>The description of the project.</p>', ], ], 'ProjectMetadata' => [ 'base' => '<p>Metadata about an Amazon Lookout for Vision project.</p>', 'refs' => [ 'CreateProjectResponse$ProjectMetadata' => '<p>Information about the project.</p>', 'ProjectMetadataList$member' => NULL, ], ], 'ProjectMetadataList' => [ 'base' => NULL, 'refs' => [ 'ListProjectsResponse$Projects' => '<p>A list of projects in your AWS account.</p>', ], ], 'ProjectName' => [ 'base' => NULL, 'refs' => [ 'CreateDatasetRequest$ProjectName' => '<p>The name of the project in which you want to create a dataset.</p>', 'CreateModelRequest$ProjectName' => '<p>The name of the project in which you want to create a model version.</p>', 'CreateProjectRequest$ProjectName' => '<p>The name for the project.</p>', 'DatasetDescription$ProjectName' => '<p>The name of the project that contains the dataset.</p>', 'DeleteDatasetRequest$ProjectName' => '<p>The name of the project that contains the dataset that you want to delete.</p>', 'DeleteModelRequest$ProjectName' => '<p>The name of the project that contains the model that you want to delete.</p>', 'DeleteProjectRequest$ProjectName' => '<p>The name of the project to delete.</p>', 'DescribeDatasetRequest$ProjectName' => '<p>The name of the project that contains the dataset that you want to describe.</p>', 'DescribeModelRequest$ProjectName' => '<p>The project that contains the version of a model that you want to describe.</p>', 'DescribeProjectRequest$ProjectName' => '<p>The name of the project that you want to describe.</p>', 'DetectAnomaliesRequest$ProjectName' => '<p>The name of the project that contains the model version that you want to use.</p>', 'ListDatasetEntriesRequest$ProjectName' => '<p>The name of the project that contains the dataset that you want to list.</p>', 'ListModelsRequest$ProjectName' => '<p>The name of the project that contains the model versions that you want to list.</p>', 'ProjectDescription$ProjectName' => '<p>The name of the project.</p>', 'ProjectMetadata$ProjectName' => '<p>The name of the project.</p>', 'StartModelRequest$ProjectName' => '<p>The name of the project that contains the model that you want to start.</p>', 'StopModelRequest$ProjectName' => '<p>The name of the project that contains the model that you want to stop.</p>', 'UpdateDatasetEntriesRequest$ProjectName' => '<p>The name of the project that contains the dataset that you want to update.</p>', ], ], 'QueryString' => [ 'base' => NULL, 'refs' => [ 'ListDatasetEntriesRequest$SourceRefContains' => '<p>Perform a "contains" search on the values of the <code>source-ref</code> key within the dataset. For example a value of "IMG_17" returns all JSON Lines where the <code>source-ref</code> key value matches <i>*IMG_17*</i>.</p>', ], ], 'ResourceNotFoundException' => [ 'base' => '<p>The resource could not be found.</p>', 'refs' => [], ], 'ResourceType' => [ 'base' => NULL, 'refs' => [ 'ConflictException$ResourceType' => '<p>The type of the resource.</p>', 'ResourceNotFoundException$ResourceType' => '<p>The type of the resource.</p>', 'ServiceQuotaExceededException$ResourceType' => '<p>The type of the resource.</p>', ], ], 'RetryAfterSeconds' => [ 'base' => NULL, 'refs' => [ 'InternalServerException$RetryAfterSeconds' => '<p>The period of time, in seconds, before the operation can be retried.</p>', 'ThrottlingException$RetryAfterSeconds' => '<p>The period of time, in seconds, before the operation can be retried. </p>', ], ], 'S3BucketName' => [ 'base' => NULL, 'refs' => [ 'InputS3Object$Bucket' => '<p>The Amazon S3 bucket that contains the manifest.</p>', 'OutputS3Object$Bucket' => '<p>The bucket that contains the training output.</p>', 'S3Location$Bucket' => '<p>The S3 bucket that contains the training output.</p>', ], ], 'S3KeyPrefix' => [ 'base' => NULL, 'refs' => [ 'S3Location$Prefix' => '<p>The path of the folder, within the S3 bucket, that contains the training output.</p>', ], ], 'S3Location' => [ 'base' => '<p>Information about the location training output.</p>', 'refs' => [ 'OutputConfig$S3Location' => '<p>The S3 location for the output.</p>', ], ], 'S3ObjectKey' => [ 'base' => NULL, 'refs' => [ 'InputS3Object$Key' => '<p>The name and location of the manifest file withiin the bucket.</p>', 'OutputS3Object$Key' => '<p>The location of the training output in the bucket.</p>', ], ], 'S3ObjectVersion' => [ 'base' => NULL, 'refs' => [ 'InputS3Object$VersionId' => '<p>The version ID of the bucket.</p>', ], ], 'ServiceQuotaExceededException' => [ 'base' => '<p>A service quota was exceeded the allowed limit. For more information, see Limits in Amazon Lookout for Vision in the Amazon Lookout for Vision Developer Guide. </p>', 'refs' => [], ], 'StartModelRequest' => [ 'base' => NULL, 'refs' => [], ], 'StartModelResponse' => [ 'base' => NULL, 'refs' => [], ], 'StopModelRequest' => [ 'base' => NULL, 'refs' => [], ], 'StopModelResponse' => [ 'base' => NULL, 'refs' => [], ], 'Stream' => [ 'base' => NULL, 'refs' => [ 'DetectAnomaliesRequest$Body' => '<p>The unencrypted image bytes that you want to analyze. </p>', ], ], 'Tag' => [ 'base' => '<p>A key and value pair that is attached to the specified Amazon Lookout for Vision model.</p>', 'refs' => [ 'TagList$member' => NULL, ], ], 'TagArn' => [ 'base' => NULL, 'refs' => [ 'ListTagsForResourceRequest$ResourceArn' => '<p>The Amazon Resource Name (ARN) of the model for which you want to list tags. </p>', 'TagResourceRequest$ResourceArn' => '<p>The Amazon Resource Name (ARN) of the model to assign the tags.</p>', 'UntagResourceRequest$ResourceArn' => '<p>The Amazon Resource Name (ARN) of the model from which you want to remove tags. </p>', ], ], 'TagKey' => [ 'base' => NULL, 'refs' => [ 'Tag$Key' => '<p>The key of the tag that is attached to the specified model.</p>', 'TagKeyList$member' => NULL, ], ], 'TagKeyList' => [ 'base' => NULL, 'refs' => [ 'UntagResourceRequest$TagKeys' => '<p>A list of the keys of the tags that you want to remove.</p>', ], ], 'TagList' => [ 'base' => NULL, 'refs' => [ 'CreateModelRequest$Tags' => '<p>A set of tags (key-value pairs) that you want to attach to the model.</p>', 'ListTagsForResourceResponse$Tags' => '<p>A map of tag keys and values attached to the specified model.</p>', 'TagResourceRequest$Tags' => '<p>The key-value tags to assign to the model.</p>', ], ], 'TagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'TagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'TagValue' => [ 'base' => NULL, 'refs' => [ 'Tag$Value' => '<p>The value of the tag that is attached to the specified model.</p>', ], ], 'ThrottlingException' => [ 'base' => '<p>Amazon Lookout for Vision is temporarily unable to process the request. Try your call again.</p>', 'refs' => [], ], 'UntagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'UntagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateDatasetEntriesRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateDatasetEntriesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ValidationException' => [ 'base' => '<p>An input validation error occured. For example, invalid characters in a project name, or if a pagination token is invalid.</p>', 'refs' => [], ], ],];
