<?php
// This file was auto-generated from sdk-root/src/data/eventbridge/2015-10-07/docs-2.json
return [ 'version' => '2.0', 'service' => '<p>Amazon EventBridge helps you to respond to state changes in your Amazon Web Services resources. When your resources change state, they automatically send events to an event stream. You can create rules that match selected events in the stream and route them to targets to take action. You can also use rules to take action on a predetermined schedule. For example, you can configure rules to:</p> <ul> <li> <p>Automatically invoke an Lambda function to update DNS entries when an event notifies you that Amazon EC2 instance enters the running state.</p> </li> <li> <p>Direct specific API records from CloudTrail to an Amazon Kinesis data stream for detailed analysis of potential security or availability risks.</p> </li> <li> <p>Periodically invoke a built-in target to create a snapshot of an Amazon EBS volume.</p> </li> </ul> <p>For more information about the features of Amazon EventBridge, see the <a href="https://docs.aws.amazon.com/eventbridge/latest/userguide">Amazon EventBridge User Guide</a>.</p>', 'operations' => [ 'ActivateEventSource' => '<p>Activates a partner event source that has been deactivated. Once activated, your matching event bus will start receiving events from the event source.</p>', 'CancelReplay' => '<p>Cancels the specified replay.</p>', 'CreateApiDestination' => '<p>Creates an API destination, which is an HTTP invocation endpoint configured as a target for events.</p>', 'CreateArchive' => '<p>Creates an archive of events with the specified settings. When you create an archive, incoming events might not immediately start being sent to the archive. Allow a short period of time for changes to take effect. If you do not specify a pattern to filter events sent to the archive, all events are sent to the archive except replayed events. Replayed events are not sent to an archive.</p>', 'CreateConnection' => '<p>Creates a connection. A connection defines the authorization type and credentials to use for authorization with an API destination HTTP endpoint.</p>', 'CreateEventBus' => '<p>Creates a new event bus within your account. This can be a custom event bus which you can use to receive events from your custom applications and services, or it can be a partner event bus which can be matched to a partner event source.</p>', 'CreatePartnerEventSource' => '<p>Called by an SaaS partner to create a partner event source. This operation is not used by Amazon Web Services customers.</p> <p>Each partner event source can be used by one Amazon Web Services account to create a matching partner event bus in that Amazon Web Services account. A SaaS partner must create one partner event source for each Amazon Web Services account that wants to receive those event types. </p> <p>A partner event source creates events based on resources within the SaaS partner\'s service or application.</p> <p>An Amazon Web Services account that creates a partner event bus that matches the partner event source can use that event bus to receive events from the partner, and then process them using Amazon Web Services Events rules and targets.</p> <p>Partner event source names follow this format:</p> <p> <code> <i>partner_name</i>/<i>event_namespace</i>/<i>event_name</i> </code> </p> <p> <i>partner_name</i> is determined during partner registration and identifies the partner to Amazon Web Services customers. <i>event_namespace</i> is determined by the partner and is a way for the partner to categorize their events. <i>event_name</i> is determined by the partner, and should uniquely identify an event-generating resource within the partner system. The combination of <i>event_namespace</i> and <i>event_name</i> should help Amazon Web Services customers decide whether to create an event bus to receive these events.</p>', 'DeactivateEventSource' => '<p>You can use this operation to temporarily stop receiving events from the specified partner event source. The matching event bus is not deleted. </p> <p>When you deactivate a partner event source, the source goes into PENDING state. If it remains in PENDING state for more than two weeks, it is deleted.</p> <p>To activate a deactivated partner event source, use <a href="https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_ActivateEventSource.html">ActivateEventSource</a>.</p>', 'DeauthorizeConnection' => '<p>Removes all authorization parameters from the connection. This lets you remove the secret from the connection so you can reuse it without having to create a new connection.</p>', 'DeleteApiDestination' => '<p>Deletes the specified API destination.</p>', 'DeleteArchive' => '<p>Deletes the specified archive.</p>', 'DeleteConnection' => '<p>Deletes a connection.</p>', 'DeleteEventBus' => '<p>Deletes the specified custom event bus or partner event bus. All rules associated with this event bus need to be deleted. You can\'t delete your account\'s default event bus.</p>', 'DeletePartnerEventSource' => '<p>This operation is used by SaaS partners to delete a partner event source. This operation is not used by Amazon Web Services customers.</p> <p>When you delete an event source, the status of the corresponding partner event bus in the Amazon Web Services customer account becomes DELETED.</p> <p/>', 'DeleteRule' => '<p>Deletes the specified rule.</p> <p>Before you can delete the rule, you must remove all targets, using <a href="https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_RemoveTargets.html">RemoveTargets</a>.</p> <p>When you delete a rule, incoming events might continue to match to the deleted rule. Allow a short period of time for changes to take effect.</p> <p>If you call delete rule multiple times for the same rule, all calls will succeed. When you call delete rule for a non-existent custom eventbus, <code>ResourceNotFoundException</code> is returned.</p> <p>Managed rules are rules created and managed by another Amazon Web Services service on your behalf. These rules are created by those other Amazon Web Services services to support functionality in those services. You can delete these rules using the <code>Force</code> option, but you should do so only if you are sure the other service is not still using that rule.</p>', 'DescribeApiDestination' => '<p>Retrieves details about an API destination.</p>', 'DescribeArchive' => '<p>Retrieves details about an archive.</p>', 'DescribeConnection' => '<p>Retrieves details about a connection.</p>', 'DescribeEventBus' => '<p>Displays details about an event bus in your account. This can include the external Amazon Web Services accounts that are permitted to write events to your default event bus, and the associated policy. For custom event buses and partner event buses, it displays the name, ARN, policy, state, and creation time.</p> <p> To enable your account to receive events from other accounts on its default event bus, use <a href="https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_PutPermission.html">PutPermission</a>.</p> <p>For more information about partner event buses, see <a href="https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_CreateEventBus.html">CreateEventBus</a>.</p>', 'DescribeEventSource' => '<p>This operation lists details about a partner event source that is shared with your account.</p>', 'DescribePartnerEventSource' => '<p>An SaaS partner can use this operation to list details about a partner event source that they have created. Amazon Web Services customers do not use this operation. Instead, Amazon Web Services customers can use <a href="https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_DescribeEventSource.html">DescribeEventSource</a> to see details about a partner event source that is shared with them.</p>', 'DescribeReplay' => '<p>Retrieves details about a replay. Use <code>DescribeReplay</code> to determine the progress of a running replay. A replay processes events to replay based on the time in the event, and replays them using 1 minute intervals. If you use <code>StartReplay</code> and specify an <code>EventStartTime</code> and an <code>EventEndTime</code> that covers a 20 minute time range, the events are replayed from the first minute of that 20 minute range first. Then the events from the second minute are replayed. You can use <code>DescribeReplay</code> to determine the progress of a replay. The value returned for <code>EventLastReplayedTime</code> indicates the time within the specified time range associated with the last event replayed.</p>', 'DescribeRule' => '<p>Describes the specified rule.</p> <p>DescribeRule does not list the targets of a rule. To see the targets associated with a rule, use <a href="https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_ListTargetsByRule.html">ListTargetsByRule</a>.</p>', 'DisableRule' => '<p>Disables the specified rule. A disabled rule won\'t match any events, and won\'t self-trigger if it has a schedule expression.</p> <p>When you disable a rule, incoming events might continue to match to the disabled rule. Allow a short period of time for changes to take effect.</p>', 'EnableRule' => '<p>Enables the specified rule. If the rule does not exist, the operation fails.</p> <p>When you enable a rule, incoming events might not immediately start matching to a newly enabled rule. Allow a short period of time for changes to take effect.</p>', 'ListApiDestinations' => '<p>Retrieves a list of API destination in the account in the current Region.</p>', 'ListArchives' => '<p>Lists your archives. You can either list all the archives or you can provide a prefix to match to the archive names. Filter parameters are exclusive.</p>', 'ListConnections' => '<p>Retrieves a list of connections from the account.</p>', 'ListEventBuses' => '<p>Lists all the event buses in your account, including the default event bus, custom event buses, and partner event buses.</p>', 'ListEventSources' => '<p>You can use this to see all the partner event sources that have been shared with your Amazon Web Services account. For more information about partner event sources, see <a href="https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_CreateEventBus.html">CreateEventBus</a>.</p>', 'ListPartnerEventSourceAccounts' => '<p>An SaaS partner can use this operation to display the Amazon Web Services account ID that a particular partner event source name is associated with. This operation is not used by Amazon Web Services customers.</p>', 'ListPartnerEventSources' => '<p>An SaaS partner can use this operation to list all the partner event source names that they have created. This operation is not used by Amazon Web Services customers.</p>', 'ListReplays' => '<p>Lists your replays. You can either list all the replays or you can provide a prefix to match to the replay names. Filter parameters are exclusive.</p>', 'ListRuleNamesByTarget' => '<p>Lists the rules for the specified target. You can see which of the rules in Amazon EventBridge can invoke a specific target in your account.</p>', 'ListRules' => '<p>Lists your Amazon EventBridge rules. You can either list all the rules or you can provide a prefix to match to the rule names.</p> <p>ListRules does not list the targets of a rule. To see the targets associated with a rule, use <a href="https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_ListTargetsByRule.html">ListTargetsByRule</a>.</p>', 'ListTagsForResource' => '<p>Displays the tags associated with an EventBridge resource. In EventBridge, rules and event buses can be tagged.</p>', 'ListTargetsByRule' => '<p>Lists the targets assigned to the specified rule.</p>', 'PutEvents' => '<p>Sends custom events to Amazon EventBridge so that they can be matched to rules.</p>', 'PutPartnerEvents' => '<p>This is used by SaaS partners to write events to a customer\'s partner event bus. Amazon Web Services customers do not use this operation.</p>', 'PutPermission' => '<p>Running <code>PutPermission</code> permits the specified Amazon Web Services account or Amazon Web Services organization to put events to the specified <i>event bus</i>. Amazon EventBridge (CloudWatch Events) rules in your account are triggered by these events arriving to an event bus in your account. </p> <p>For another account to send events to your account, that external account must have an EventBridge rule with your account\'s event bus as a target.</p> <p>To enable multiple Amazon Web Services accounts to put events to your event bus, run <code>PutPermission</code> once for each of these accounts. Or, if all the accounts are members of the same Amazon Web Services organization, you can run <code>PutPermission</code> once specifying <code>Principal</code> as "*" and specifying the Amazon Web Services organization ID in <code>Condition</code>, to grant permissions to all accounts in that organization.</p> <p>If you grant permissions using an organization, then accounts in that organization must specify a <code>RoleArn</code> with proper permissions when they use <code>PutTarget</code> to add your account\'s event bus as a target. For more information, see <a href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eventbridge-cross-account-event-delivery.html">Sending and Receiving Events Between Amazon Web Services Accounts</a> in the <i>Amazon EventBridge User Guide</i>.</p> <p>The permission policy on the event bus cannot exceed 10 KB in size.</p>', 'PutRule' => '<p>Creates or updates the specified rule. Rules are enabled by default, or based on value of the state. You can disable a rule using <a href="https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_DisableRule.html">DisableRule</a>.</p> <p>A single rule watches for events from a single event bus. Events generated by Amazon Web Services services go to your account\'s default event bus. Events generated by SaaS partner services or applications go to the matching partner event bus. If you have custom applications or services, you can specify whether their events go to your default event bus or a custom event bus that you have created. For more information, see <a href="https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_CreateEventBus.html">CreateEventBus</a>.</p> <p>If you are updating an existing rule, the rule is replaced with what you specify in this <code>PutRule</code> command. If you omit arguments in <code>PutRule</code>, the old values for those arguments are not kept. Instead, they are replaced with null values.</p> <p>When you create or update a rule, incoming events might not immediately start matching to new or updated rules. Allow a short period of time for changes to take effect.</p> <p>A rule must contain at least an EventPattern or ScheduleExpression. Rules with EventPatterns are triggered when a matching event is observed. Rules with ScheduleExpressions self-trigger based on the given schedule. A rule can have both an EventPattern and a ScheduleExpression, in which case the rule triggers on matching events as well as on a schedule.</p> <p>When you initially create a rule, you can optionally assign one or more tags to the rule. Tags can help you organize and categorize your resources. You can also use them to scope user permissions, by granting a user permission to access or change only rules with certain tag values. To use the <code>PutRule</code> operation and assign tags, you must have both the <code>events:PutRule</code> and <code>events:TagResource</code> permissions.</p> <p>If you are updating an existing rule, any tags you specify in the <code>PutRule</code> operation are ignored. To update the tags of an existing rule, use <a href="https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_TagResource.html">TagResource</a> and <a href="https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_UntagResource.html">UntagResource</a>.</p> <p>Most services in Amazon Web Services treat : or / as the same character in Amazon Resource Names (ARNs). However, EventBridge uses an exact match in event patterns and rules. Be sure to use the correct ARN characters when creating event patterns so that they match the ARN syntax in the event you want to match.</p> <p>In EventBridge, it is possible to create rules that lead to infinite loops, where a rule is fired repeatedly. For example, a rule might detect that ACLs have changed on an S3 bucket, and trigger software to change them to the desired state. If the rule is not written carefully, the subsequent change to the ACLs fires the rule again, creating an infinite loop.</p> <p>To prevent this, write the rules so that the triggered actions do not re-fire the same rule. For example, your rule could fire only if ACLs are found to be in a bad state, instead of after any change. </p> <p>An infinite loop can quickly cause higher than expected charges. We recommend that you use budgeting, which alerts you when charges exceed your specified limit. For more information, see <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/budgets-managing-costs.html">Managing Your Costs with Budgets</a>.</p>', 'PutTargets' => '<p>Adds the specified targets to the specified rule, or updates the targets if they are already associated with the rule.</p> <p>Targets are the resources that are invoked when a rule is triggered.</p> <p>You can configure the following as targets for Events:</p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-api-destinations.html">API destination</a> </p> </li> <li> <p>Amazon API Gateway REST API endpoints</p> </li> <li> <p>API Gateway</p> </li> <li> <p>Batch job queue</p> </li> <li> <p>CloudWatch Logs group</p> </li> <li> <p>CodeBuild project</p> </li> <li> <p>CodePipeline</p> </li> <li> <p>Amazon EC2 <code>CreateSnapshot</code> API call</p> </li> <li> <p>Amazon EC2 <code>RebootInstances</code> API call</p> </li> <li> <p>Amazon EC2 <code>StopInstances</code> API call</p> </li> <li> <p>Amazon EC2 <code>TerminateInstances</code> API call</p> </li> <li> <p>Amazon ECS tasks</p> </li> <li> <p>Event bus in a different Amazon Web Services account or Region.</p> <p>You can use an event bus in the US East (N. Virginia) us-east-1, US West (Oregon) us-west-2, or Europe (Ireland) eu-west-1 Regions as a target for a rule.</p> </li> <li> <p>Firehose delivery stream (Kinesis Data Firehose)</p> </li> <li> <p>Inspector assessment template (Amazon Inspector)</p> </li> <li> <p>Kinesis stream (Kinesis Data Stream)</p> </li> <li> <p>Lambda function</p> </li> <li> <p>Redshift clusters (Data API statement execution)</p> </li> <li> <p>Amazon SNS topic</p> </li> <li> <p>Amazon SQS queues (includes FIFO queues</p> </li> <li> <p>SSM Automation</p> </li> <li> <p>SSM OpsItem</p> </li> <li> <p>SSM Run Command</p> </li> <li> <p>Step Functions state machines</p> </li> </ul> <p>Creating rules with built-in targets is supported only in the Amazon Web Services Management Console. The built-in targets are <code>EC2 CreateSnapshot API call</code>, <code>EC2 RebootInstances API call</code>, <code>EC2 StopInstances API call</code>, and <code>EC2 TerminateInstances API call</code>. </p> <p>For some target types, <code>PutTargets</code> provides target-specific parameters. If the target is a Kinesis data stream, you can optionally specify which shard the event goes to by using the <code>KinesisParameters</code> argument. To invoke a command on multiple EC2 instances with one rule, you can use the <code>RunCommandParameters</code> field.</p> <p>To be able to make API calls against the resources that you own, Amazon EventBridge needs the appropriate permissions. For Lambda and Amazon SNS resources, EventBridge relies on resource-based policies. For EC2 instances, Kinesis Data Streams, Step Functions state machines and API Gateway REST APIs, EventBridge relies on IAM roles that you specify in the <code>RoleARN</code> argument in <code>PutTargets</code>. For more information, see <a href="https://docs.aws.amazon.com/eventbridge/latest/userguide/auth-and-access-control-eventbridge.html">Authentication and Access Control</a> in the <i>Amazon EventBridge User Guide</i>.</p> <p>If another Amazon Web Services account is in the same region and has granted you permission (using <code>PutPermission</code>), you can send events to that account. Set that account\'s event bus as a target of the rules in your account. To send the matched events to the other account, specify that account\'s event bus as the <code>Arn</code> value when you run <code>PutTargets</code>. If your account sends events to another account, your account is charged for each sent event. Each event sent to another account is charged as a custom event. The account receiving the event is not charged. For more information, see <a href="http://aws.amazon.com/eventbridge/pricing/">Amazon EventBridge Pricing</a>.</p> <note> <p> <code>Input</code>, <code>InputPath</code>, and <code>InputTransformer</code> are not available with <code>PutTarget</code> if the target is an event bus of a different Amazon Web Services account.</p> </note> <p>If you are setting the event bus of another account as the target, and that account granted permission to your account through an organization instead of directly by the account ID, then you must specify a <code>RoleArn</code> with proper permissions in the <code>Target</code> structure. For more information, see <a href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eventbridge-cross-account-event-delivery.html">Sending and Receiving Events Between Amazon Web Services Accounts</a> in the <i>Amazon EventBridge User Guide</i>.</p> <p>For more information about enabling cross-account events, see <a href="https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_PutPermission.html">PutPermission</a>.</p> <p> <b>Input</b>, <b>InputPath</b>, and <b>InputTransformer</b> are mutually exclusive and optional parameters of a target. When a rule is triggered due to a matched event:</p> <ul> <li> <p>If none of the following arguments are specified for a target, then the entire event is passed to the target in JSON format (unless the target is Amazon EC2 Run Command or Amazon ECS task, in which case nothing from the event is passed to the target).</p> </li> <li> <p>If <b>Input</b> is specified in the form of valid JSON, then the matched event is overridden with this constant.</p> </li> <li> <p>If <b>InputPath</b> is specified in the form of JSONPath (for example, <code>$.detail</code>), then only the part of the event specified in the path is passed to the target (for example, only the detail part of the event is passed).</p> </li> <li> <p>If <b>InputTransformer</b> is specified, then one or more specified JSONPaths are extracted from the event and used as values in a template that you specify as the input to the target.</p> </li> </ul> <p>When you specify <code>InputPath</code> or <code>InputTransformer</code>, you must use JSON dot notation, not bracket notation.</p> <p>When you add targets to a rule and the associated rule triggers soon after, new or updated targets might not be immediately invoked. Allow a short period of time for changes to take effect.</p> <p>This action can partially fail if too many requests are made at the same time. If that happens, <code>FailedEntryCount</code> is non-zero in the response and each entry in <code>FailedEntries</code> provides the ID of the failed target and the error code.</p>', 'RemovePermission' => '<p>Revokes the permission of another Amazon Web Services account to be able to put events to the specified event bus. Specify the account to revoke by the <code>StatementId</code> value that you associated with the account when you granted it permission with <code>PutPermission</code>. You can find the <code>StatementId</code> by using <a href="https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_DescribeEventBus.html">DescribeEventBus</a>.</p>', 'RemoveTargets' => '<p>Removes the specified targets from the specified rule. When the rule is triggered, those targets are no longer be invoked.</p> <p>When you remove a target, when the associated rule triggers, removed targets might continue to be invoked. Allow a short period of time for changes to take effect.</p> <p>This action can partially fail if too many requests are made at the same time. If that happens, <code>FailedEntryCount</code> is non-zero in the response and each entry in <code>FailedEntries</code> provides the ID of the failed target and the error code.</p>', 'StartReplay' => '<p>Starts the specified replay. Events are not necessarily replayed in the exact same order that they were added to the archive. A replay processes events to replay based on the time in the event, and replays them using 1 minute intervals. If you specify an <code>EventStartTime</code> and an <code>EventEndTime</code> that covers a 20 minute time range, the events are replayed from the first minute of that 20 minute range first. Then the events from the second minute are replayed. You can use <code>DescribeReplay</code> to determine the progress of a replay. The value returned for <code>EventLastReplayedTime</code> indicates the time within the specified time range associated with the last event replayed.</p>', 'TagResource' => '<p>Assigns one or more tags (key-value pairs) to the specified EventBridge resource. Tags can help you organize and categorize your resources. You can also use them to scope user permissions by granting a user permission to access or change only resources with certain tag values. In EventBridge, rules and event buses can be tagged.</p> <p>Tags don\'t have any semantic meaning to Amazon Web Services and are interpreted strictly as strings of characters.</p> <p>You can use the <code>TagResource</code> action with a resource that already has tags. If you specify a new tag key, this tag is appended to the list of tags associated with the resource. If you specify a tag key that is already associated with the resource, the new tag value that you specify replaces the previous value for that tag.</p> <p>You can associate as many as 50 tags with a resource.</p>', 'TestEventPattern' => '<p>Tests whether the specified event pattern matches the provided event.</p> <p>Most services in Amazon Web Services treat : or / as the same character in Amazon Resource Names (ARNs). However, EventBridge uses an exact match in event patterns and rules. Be sure to use the correct ARN characters when creating event patterns so that they match the ARN syntax in the event you want to match.</p>', 'UntagResource' => '<p>Removes one or more tags from the specified EventBridge resource. In Amazon EventBridge (CloudWatch Events), rules and event buses can be tagged.</p>', 'UpdateApiDestination' => '<p>Updates an API destination.</p>', 'UpdateArchive' => '<p>Updates the specified archive.</p>', 'UpdateConnection' => '<p>Updates settings for a connection.</p>', ], 'shapes' => [ 'AccountId' => [ 'base' => NULL, 'refs' => [ 'CreatePartnerEventSourceRequest$Account' => '<p>The Amazon Web Services account ID that is permitted to create a matching partner event bus for this partner event source.</p>', 'DeletePartnerEventSourceRequest$Account' => '<p>The Amazon Web Services account ID of the Amazon Web Services customer that the event source was created for.</p>', 'PartnerEventSourceAccount$Account' => '<p>The Amazon Web Services account ID that the partner event source was offered to.</p>', ], ], 'Action' => [ 'base' => NULL, 'refs' => [ 'PutPermissionRequest$Action' => '<p>The action that you are enabling the other account to perform.</p>', ], ], 'ActivateEventSourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'ApiDestination' => [ 'base' => '<p>Contains details about an API destination.</p>', 'refs' => [ 'ApiDestinationResponseList$member' => NULL, ], ], 'ApiDestinationArn' => [ 'base' => NULL, 'refs' => [ 'ApiDestination$ApiDestinationArn' => '<p>The ARN of the API destination.</p>', 'CreateApiDestinationResponse$ApiDestinationArn' => '<p>The ARN of the API destination that was created by the request.</p>', 'DescribeApiDestinationResponse$ApiDestinationArn' => '<p>The ARN of the API destination retrieved.</p>', 'UpdateApiDestinationResponse$ApiDestinationArn' => '<p>The ARN of the API destination that was updated.</p>', ], ], 'ApiDestinationDescription' => [ 'base' => NULL, 'refs' => [ 'CreateApiDestinationRequest$Description' => '<p>A description for the API destination to create.</p>', 'DescribeApiDestinationResponse$Description' => '<p>The description for the API destination retrieved.</p>', 'UpdateApiDestinationRequest$Description' => '<p>The name of the API destination to update.</p>', ], ], 'ApiDestinationHttpMethod' => [ 'base' => NULL, 'refs' => [ 'ApiDestination$HttpMethod' => '<p>The method to use to connect to the HTTP endpoint.</p>', 'CreateApiDestinationRequest$HttpMethod' => '<p>The method to use for the request to the HTTP invocation endpoint.</p>', 'DescribeApiDestinationResponse$HttpMethod' => '<p>The method to use to connect to the HTTP endpoint.</p>', 'UpdateApiDestinationRequest$HttpMethod' => '<p>The method to use for the API destination.</p>', ], ], 'ApiDestinationInvocationRateLimitPerSecond' => [ 'base' => NULL, 'refs' => [ 'ApiDestination$InvocationRateLimitPerSecond' => '<p>The maximum number of invocations per second to send to the HTTP endpoint.</p>', 'CreateApiDestinationRequest$InvocationRateLimitPerSecond' => '<p>The maximum number of requests per second to send to the HTTP invocation endpoint.</p>', 'DescribeApiDestinationResponse$InvocationRateLimitPerSecond' => '<p>The maximum number of invocations per second to specified for the API destination. Note that if you set the invocation rate maximum to a value lower the rate necessary to send all events received on to the destination HTTP endpoint, some events may not be delivered within the 24-hour retry window. If you plan to set the rate lower than the rate necessary to deliver all events, consider using a dead-letter queue to catch events that are not delivered within 24 hours.</p>', 'UpdateApiDestinationRequest$InvocationRateLimitPerSecond' => '<p>The maximum number of invocations per second to send to the API destination.</p>', ], ], 'ApiDestinationName' => [ 'base' => NULL, 'refs' => [ 'ApiDestination$Name' => '<p>The name of the API destination.</p>', 'CreateApiDestinationRequest$Name' => '<p>The name for the API destination to create.</p>', 'DeleteApiDestinationRequest$Name' => '<p>The name of the destination to delete.</p>', 'DescribeApiDestinationRequest$Name' => '<p>The name of the API destination to retrieve.</p>', 'DescribeApiDestinationResponse$Name' => '<p>The name of the API destination retrieved.</p>', 'ListApiDestinationsRequest$NamePrefix' => '<p>A name prefix to filter results returned. Only API destinations with a name that starts with the prefix are returned.</p>', 'UpdateApiDestinationRequest$Name' => '<p>The name of the API destination to update.</p>', ], ], 'ApiDestinationResponseList' => [ 'base' => NULL, 'refs' => [ 'ListApiDestinationsResponse$ApiDestinations' => '<p>An array of <code>ApiDestination</code> objects that include information about an API destination.</p>', ], ], 'ApiDestinationState' => [ 'base' => NULL, 'refs' => [ 'ApiDestination$ApiDestinationState' => '<p>The state of the API destination.</p>', 'CreateApiDestinationResponse$ApiDestinationState' => '<p>The state of the API destination that was created by the request.</p>', 'DescribeApiDestinationResponse$ApiDestinationState' => '<p>The state of the API destination retrieved.</p>', 'UpdateApiDestinationResponse$ApiDestinationState' => '<p>The state of the API destination that was updated.</p>', ], ], 'Archive' => [ 'base' => '<p>An <code>Archive</code> object that contains details about an archive.</p>', 'refs' => [ 'ArchiveResponseList$member' => NULL, ], ], 'ArchiveArn' => [ 'base' => NULL, 'refs' => [ 'CreateArchiveResponse$ArchiveArn' => '<p>The ARN of the archive that was created.</p>', 'DescribeArchiveResponse$ArchiveArn' => '<p>The ARN of the archive.</p>', 'UpdateArchiveResponse$ArchiveArn' => '<p>The ARN of the archive.</p>', ], ], 'ArchiveDescription' => [ 'base' => NULL, 'refs' => [ 'CreateArchiveRequest$Description' => '<p>A description for the archive.</p>', 'DescribeArchiveResponse$Description' => '<p>The description of the archive.</p>', 'UpdateArchiveRequest$Description' => '<p>The description for the archive.</p>', ], ], 'ArchiveName' => [ 'base' => NULL, 'refs' => [ 'Archive$ArchiveName' => '<p>The name of the archive.</p>', 'CreateArchiveRequest$ArchiveName' => '<p>The name for the archive to create.</p>', 'DeleteArchiveRequest$ArchiveName' => '<p>The name of the archive to delete.</p>', 'DescribeArchiveRequest$ArchiveName' => '<p>The name of the archive to retrieve.</p>', 'DescribeArchiveResponse$ArchiveName' => '<p>The name of the archive.</p>', 'ListArchivesRequest$NamePrefix' => '<p>A name prefix to filter the archives returned. Only archives with name that match the prefix are returned.</p>', 'UpdateArchiveRequest$ArchiveName' => '<p>The name of the archive to update.</p>', ], ], 'ArchiveResponseList' => [ 'base' => NULL, 'refs' => [ 'ListArchivesResponse$Archives' => '<p>An array of <code>Archive</code> objects that include details about an archive.</p>', ], ], 'ArchiveState' => [ 'base' => NULL, 'refs' => [ 'Archive$State' => '<p>The current state of the archive.</p>', 'CreateArchiveResponse$State' => '<p>The state of the archive that was created.</p>', 'DescribeArchiveResponse$State' => '<p>The state of the archive.</p>', 'ListArchivesRequest$State' => '<p>The state of the archive.</p>', 'UpdateArchiveResponse$State' => '<p>The state of the archive.</p>', ], ], 'ArchiveStateReason' => [ 'base' => NULL, 'refs' => [ 'Archive$StateReason' => '<p>A description for the reason that the archive is in the current state.</p>', 'CreateArchiveResponse$StateReason' => '<p>The reason that the archive is in the state.</p>', 'DescribeArchiveResponse$StateReason' => '<p>The reason that the archive is in the state.</p>', 'UpdateArchiveResponse$StateReason' => '<p>The reason that the archive is in the current state.</p>', ], ], 'Arn' => [ 'base' => NULL, 'refs' => [ 'Archive$EventSourceArn' => '<p>The ARN of the event bus associated with the archive. Only events from this event bus are sent to the archive.</p>', 'CreateArchiveRequest$EventSourceArn' => '<p>The ARN of the event bus that sends events to the archive.</p>', 'DescribeArchiveResponse$EventSourceArn' => '<p>The ARN of the event source associated with the archive.</p>', 'DescribeReplayResponse$EventSourceArn' => '<p>The ARN of the archive events were replayed from.</p>', 'EcsParameters$TaskDefinitionArn' => '<p>The ARN of the task definition to use if the event target is an Amazon ECS task. </p>', 'ListArchivesRequest$EventSourceArn' => '<p>The ARN of the event source associated with the archive.</p>', 'ListReplaysRequest$EventSourceArn' => '<p>The ARN of the archive from which the events are replayed.</p>', 'ListTagsForResourceRequest$ResourceARN' => '<p>The ARN of the EventBridge resource for which you want to view tags.</p>', 'Replay$EventSourceArn' => '<p>The ARN of the archive to replay event from.</p>', 'ReplayDestination$Arn' => '<p>The ARN of the event bus to replay event to. You can replay events only to the event bus specified to create the archive.</p>', 'ReplayDestinationFilters$member' => NULL, 'StartReplayRequest$EventSourceArn' => '<p>The ARN of the archive to replay events from.</p>', 'TagResourceRequest$ResourceARN' => '<p>The ARN of the EventBridge resource that you\'re adding tags to.</p>', 'UntagResourceRequest$ResourceARN' => '<p>The ARN of the EventBridge resource from which you are removing tags.</p>', ], ], 'AssignPublicIp' => [ 'base' => NULL, 'refs' => [ 'AwsVpcConfiguration$AssignPublicIp' => '<p>Specifies whether the task\'s elastic network interface receives a public IP address. You can specify <code>ENABLED</code> only when <code>LaunchType</code> in <code>EcsParameters</code> is set to <code>FARGATE</code>.</p>', ], ], 'AuthHeaderParameters' => [ 'base' => NULL, 'refs' => [ 'ConnectionApiKeyAuthResponseParameters$ApiKeyName' => '<p>The name of the header to use for the <code>APIKeyValue</code> used for authorization.</p>', 'ConnectionBasicAuthResponseParameters$Username' => '<p>The user name to use for Basic authorization.</p>', 'ConnectionOAuthClientResponseParameters$ClientID' => '<p>The client ID associated with the response to the connection request.</p>', 'CreateConnectionApiKeyAuthRequestParameters$ApiKeyName' => '<p>The name of the API key to use for authorization.</p>', 'CreateConnectionApiKeyAuthRequestParameters$ApiKeyValue' => '<p>The value for the API key to use for authorization.</p>', 'CreateConnectionBasicAuthRequestParameters$Username' => '<p>The user name to use for Basic authorization.</p>', 'CreateConnectionBasicAuthRequestParameters$Password' => '<p>The password associated with the user name to use for Basic authorization.</p>', 'CreateConnectionOAuthClientRequestParameters$ClientID' => '<p>The client ID to use for OAuth authorization for the connection.</p>', 'CreateConnectionOAuthClientRequestParameters$ClientSecret' => '<p>The client secret associated with the client ID to use for OAuth authorization for the connection.</p>', 'UpdateConnectionApiKeyAuthRequestParameters$ApiKeyName' => '<p>The name of the API key to use for authorization.</p>', 'UpdateConnectionApiKeyAuthRequestParameters$ApiKeyValue' => '<p>The value associated with teh API key to use for authorization.</p>', 'UpdateConnectionBasicAuthRequestParameters$Username' => '<p>The user name to use for Basic authorization.</p>', 'UpdateConnectionBasicAuthRequestParameters$Password' => '<p>The password associated with the user name to use for Basic authorization.</p>', 'UpdateConnectionOAuthClientRequestParameters$ClientID' => '<p>The client ID to use for OAuth authorization.</p>', 'UpdateConnectionOAuthClientRequestParameters$ClientSecret' => '<p>The client secret assciated with the client ID to use for OAuth authorization.</p>', ], ], 'AwsVpcConfiguration' => [ 'base' => '<p>This structure specifies the VPC subnets and security groups for the task, and whether a public IP address is to be used. This structure is relevant only for ECS tasks that use the <code>awsvpc</code> network mode.</p>', 'refs' => [ 'NetworkConfiguration$awsvpcConfiguration' => '<p>Use this structure to specify the VPC subnets and security groups for the task, and whether a public IP address is to be used. This structure is relevant only for ECS tasks that use the <code>awsvpc</code> network mode.</p>', ], ], 'BatchArrayProperties' => [ 'base' => '<p>The array properties for the submitted job, such as the size of the array. The array size can be between 2 and 10,000. If you specify array properties for a job, it becomes an array job. This parameter is used only if the target is an Batch job.</p>', 'refs' => [ 'BatchParameters$ArrayProperties' => '<p>The array properties for the submitted job, such as the size of the array. The array size can be between 2 and 10,000. If you specify array properties for a job, it becomes an array job. This parameter is used only if the target is an Batch job.</p>', ], ], 'BatchParameters' => [ 'base' => '<p>The custom parameters to be used when the target is an Batch job.</p>', 'refs' => [ 'Target$BatchParameters' => '<p>If the event target is an Batch job, this contains the job definition, job name, and other parameters. For more information, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/jobs.html">Jobs</a> in the <i>Batch User Guide</i>.</p>', ], ], 'BatchRetryStrategy' => [ 'base' => '<p>The retry strategy to use for failed jobs, if the target is an Batch job. If you specify a retry strategy here, it overrides the retry strategy defined in the job definition.</p>', 'refs' => [ 'BatchParameters$RetryStrategy' => '<p>The retry strategy to use for failed jobs, if the target is an Batch job. The retry strategy is the number of times to retry the failed job execution. Valid values are 1–10. When you specify a retry strategy here, it overrides the retry strategy defined in the job definition.</p>', ], ], 'Boolean' => [ 'base' => NULL, 'refs' => [ 'ConnectionBodyParameter$IsValueSecret' => '<p>Specified whether the value is secret.</p>', 'ConnectionHeaderParameter$IsValueSecret' => '<p>Specified whether the value is a secret.</p>', 'ConnectionQueryStringParameter$IsValueSecret' => '<p>Specifies whether the value is secret.</p>', 'DeleteRuleRequest$Force' => '<p>If this is a managed rule, created by an Amazon Web Services service on your behalf, you must specify <code>Force</code> as <code>True</code> to delete the rule. This parameter is ignored for rules that are not managed rules. You can check whether a rule is a managed rule by using <code>DescribeRule</code> or <code>ListRules</code> and checking the <code>ManagedBy</code> field of the response.</p>', 'EcsParameters$EnableECSManagedTags' => '<p>Specifies whether to enable Amazon ECS managed tags for the task. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-using-tags.html">Tagging Your Amazon ECS Resources</a> in the Amazon Elastic Container Service Developer Guide. </p>', 'EcsParameters$EnableExecuteCommand' => '<p>Whether or not to enable the execute command functionality for the containers in this task. If true, this enables execute command functionality on all containers in the task.</p>', 'RedshiftDataParameters$WithEvent' => '<p>Indicates whether to send an event back to EventBridge after the SQL statement runs.</p>', 'RemovePermissionRequest$RemoveAllPermissions' => '<p>Specifies whether to remove all permissions.</p>', 'RemoveTargetsRequest$Force' => '<p>If this is a managed rule, created by an Amazon Web Services service on your behalf, you must specify <code>Force</code> as <code>True</code> to remove targets. This parameter is ignored for rules that are not managed rules. You can check whether a rule is a managed rule by using <code>DescribeRule</code> or <code>ListRules</code> and checking the <code>ManagedBy</code> field of the response.</p>', 'TestEventPatternResponse$Result' => '<p>Indicates whether the event matches the event pattern.</p>', ], ], 'CancelReplayRequest' => [ 'base' => NULL, 'refs' => [], ], 'CancelReplayResponse' => [ 'base' => NULL, 'refs' => [], ], 'CapacityProvider' => [ 'base' => NULL, 'refs' => [ 'CapacityProviderStrategyItem$capacityProvider' => '<p>The short name of the capacity provider.</p>', ], ], 'CapacityProviderStrategy' => [ 'base' => NULL, 'refs' => [ 'EcsParameters$CapacityProviderStrategy' => '<p>The capacity provider strategy to use for the task.</p> <p>If a <code>capacityProviderStrategy</code> is specified, the <code>launchType</code> parameter must be omitted. If no <code>capacityProviderStrategy</code> or launchType is specified, the <code>defaultCapacityProviderStrategy</code> for the cluster is used. </p>', ], ], 'CapacityProviderStrategyItem' => [ 'base' => '<p>The details of a capacity provider strategy. To learn more, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_CapacityProviderStrategyItem.html">CapacityProviderStrategyItem</a> in the Amazon ECS API Reference.</p>', 'refs' => [ 'CapacityProviderStrategy$member' => NULL, ], ], 'CapacityProviderStrategyItemBase' => [ 'base' => NULL, 'refs' => [ 'CapacityProviderStrategyItem$base' => '<p>The base value designates how many tasks, at a minimum, to run on the specified capacity provider. Only one capacity provider in a capacity provider strategy can have a base defined. If no value is specified, the default value of 0 is used. </p>', ], ], 'CapacityProviderStrategyItemWeight' => [ 'base' => NULL, 'refs' => [ 'CapacityProviderStrategyItem$weight' => '<p>The weight value designates the relative percentage of the total number of tasks launched that should use the specified capacity provider. The weight value is taken into consideration after the base value, if defined, is satisfied.</p>', ], ], 'ConcurrentModificationException' => [ 'base' => '<p>There is concurrent modification on a rule, target, archive, or replay.</p>', 'refs' => [], ], 'Condition' => [ 'base' => '<p>A JSON string which you can use to limit the event bus permissions you are granting to only accounts that fulfill the condition. Currently, the only supported condition is membership in a certain Amazon Web Services organization. The string must contain <code>Type</code>, <code>Key</code>, and <code>Value</code> fields. The <code>Value</code> field specifies the ID of the Amazon Web Services organization. Following is an example value for <code>Condition</code>:</p> <p> <code>\'{"Type" : "StringEquals", "Key": "aws:PrincipalOrgID", "Value": "o-1234567890"}\'</code> </p>', 'refs' => [ 'PutPermissionRequest$Condition' => '<p>This parameter enables you to limit the permission to accounts that fulfill a certain condition, such as being a member of a certain Amazon Web Services organization. For more information about Amazon Web Services Organizations, see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_introduction.html">What Is Amazon Web Services Organizations</a> in the <i>Amazon Web Services Organizations User Guide</i>.</p> <p>If you specify <code>Condition</code> with an Amazon Web Services organization ID, and specify "*" as the value for <code>Principal</code>, you grant permission to all the accounts in the named organization.</p> <p>The <code>Condition</code> is a JSON string which must contain <code>Type</code>, <code>Key</code>, and <code>Value</code> fields.</p>', ], ], 'Connection' => [ 'base' => '<p>Contains information about a connection.</p>', 'refs' => [ 'ConnectionResponseList$member' => NULL, ], ], 'ConnectionApiKeyAuthResponseParameters' => [ 'base' => '<p>Contains the authorization parameters for the connection if API Key is specified as the authorization type.</p>', 'refs' => [ 'ConnectionAuthResponseParameters$ApiKeyAuthParameters' => '<p>The API Key parameters to use for authorization.</p>', ], ], 'ConnectionArn' => [ 'base' => NULL, 'refs' => [ 'ApiDestination$ConnectionArn' => '<p>The ARN of the connection specified for the API destination.</p>', 'Connection$ConnectionArn' => '<p>The ARN of the connection.</p>', 'CreateApiDestinationRequest$ConnectionArn' => '<p>The ARN of the connection to use for the API destination. The destination endpoint must support the authorization type specified for the connection.</p>', 'CreateConnectionResponse$ConnectionArn' => '<p>The ARN of the connection that was created by the request.</p>', 'DeauthorizeConnectionResponse$ConnectionArn' => '<p>The ARN of the connection that authorization was removed from.</p>', 'DeleteConnectionResponse$ConnectionArn' => '<p>The ARN of the connection that was deleted.</p>', 'DescribeApiDestinationResponse$ConnectionArn' => '<p>The ARN of the connection specified for the API destination retrieved.</p>', 'DescribeConnectionResponse$ConnectionArn' => '<p>The ARN of the connection retrieved.</p>', 'ListApiDestinationsRequest$ConnectionArn' => '<p>The ARN of the connection specified for the API destination.</p>', 'UpdateApiDestinationRequest$ConnectionArn' => '<p>The ARN of the connection to use for the API destination.</p>', 'UpdateConnectionResponse$ConnectionArn' => '<p>The ARN of the connection that was updated.</p>', ], ], 'ConnectionAuthResponseParameters' => [ 'base' => '<p>Contains the authorization parameters to use for the connection.</p>', 'refs' => [ 'DescribeConnectionResponse$AuthParameters' => '<p>The parameters to use for authorization for the connection.</p>', ], ], 'ConnectionAuthorizationType' => [ 'base' => NULL, 'refs' => [ 'Connection$AuthorizationType' => '<p>The authorization type specified for the connection.</p>', 'CreateConnectionRequest$AuthorizationType' => '<p>The type of authorization to use for the connection.</p>', 'DescribeConnectionResponse$AuthorizationType' => '<p>The type of authorization specified for the connection.</p>', 'UpdateConnectionRequest$AuthorizationType' => '<p>The type of authorization to use for the connection.</p>', ], ], 'ConnectionBasicAuthResponseParameters' => [ 'base' => '<p>Contains the authorization parameters for the connection if Basic is specified as the authorization type.</p>', 'refs' => [ 'ConnectionAuthResponseParameters$BasicAuthParameters' => '<p>The authorization parameters for Basic authorization.</p>', ], ], 'ConnectionBodyParameter' => [ 'base' => '<p>Additional parameter included in the body. You can include up to 100 additional body parameters per request. An event payload cannot exceed 64 KB.</p>', 'refs' => [ 'ConnectionBodyParametersList$member' => NULL, ], ], 'ConnectionBodyParametersList' => [ 'base' => NULL, 'refs' => [ 'ConnectionHttpParameters$BodyParameters' => '<p>Contains additional body string parameters for the connection.</p>', ], ], 'ConnectionDescription' => [ 'base' => NULL, 'refs' => [ 'CreateConnectionRequest$Description' => '<p>A description for the connection to create.</p>', 'DescribeConnectionResponse$Description' => '<p>The description for the connection retrieved.</p>', 'UpdateConnectionRequest$Description' => '<p>A description for the connection.</p>', ], ], 'ConnectionHeaderParameter' => [ 'base' => '<p>Additional parameter included in the header. You can include up to 100 additional header parameters per request. An event payload cannot exceed 64 KB.</p>', 'refs' => [ 'ConnectionHeaderParametersList$member' => NULL, ], ], 'ConnectionHeaderParametersList' => [ 'base' => NULL, 'refs' => [ 'ConnectionHttpParameters$HeaderParameters' => '<p>Contains additional header parameters for the connection.</p>', ], ], 'ConnectionHttpParameters' => [ 'base' => '<p>Contains additional parameters for the connection.</p>', 'refs' => [ 'ConnectionAuthResponseParameters$InvocationHttpParameters' => '<p>Additional parameters for the connection that are passed through with every invocation to the HTTP endpoint.</p>', 'ConnectionOAuthResponseParameters$OAuthHttpParameters' => '<p>The additional HTTP parameters used for the OAuth authorization request.</p>', 'CreateConnectionAuthRequestParameters$InvocationHttpParameters' => '<p>A <code>ConnectionHttpParameters</code> object that contains the API key authorization parameters to use for the connection. Note that if you include additional parameters for the target of a rule via <code>HttpParameters</code>, including query strings, the parameters added for the connection take precedence.</p>', 'CreateConnectionOAuthRequestParameters$OAuthHttpParameters' => '<p>A <code>ConnectionHttpParameters</code> object that contains details about the additional parameters to use for the connection.</p>', 'UpdateConnectionAuthRequestParameters$InvocationHttpParameters' => '<p>A <code>ConnectionHttpParameters</code> object that contains the additional parameters to use for the connection.</p>', 'UpdateConnectionOAuthRequestParameters$OAuthHttpParameters' => '<p>The additional HTTP parameters used for the OAuth authorization request.</p>', ], ], 'ConnectionName' => [ 'base' => NULL, 'refs' => [ 'Connection$Name' => '<p>The name of the connection.</p>', 'CreateConnectionRequest$Name' => '<p>The name for the connection to create.</p>', 'DeauthorizeConnectionRequest$Name' => '<p>The name of the connection to remove authorization from.</p>', 'DeleteConnectionRequest$Name' => '<p>The name of the connection to delete.</p>', 'DescribeConnectionRequest$Name' => '<p>The name of the connection to retrieve.</p>', 'DescribeConnectionResponse$Name' => '<p>The name of the connection retrieved.</p>', 'ListConnectionsRequest$NamePrefix' => '<p>A name prefix to filter results returned. Only connections with a name that starts with the prefix are returned.</p>', 'UpdateConnectionRequest$Name' => '<p>The name of the connection to update.</p>', ], ], 'ConnectionOAuthClientResponseParameters' => [ 'base' => '<p>Contains the client response parameters for the connection when OAuth is specified as the authorization type.</p>', 'refs' => [ 'ConnectionOAuthResponseParameters$ClientParameters' => '<p>A <code>ConnectionOAuthClientResponseParameters</code> object that contains details about the client parameters returned when OAuth is specified as the authorization type.</p>', ], ], 'ConnectionOAuthHttpMethod' => [ 'base' => NULL, 'refs' => [ 'ConnectionOAuthResponseParameters$HttpMethod' => '<p>The method used to connect to the HTTP endpoint.</p>', 'CreateConnectionOAuthRequestParameters$HttpMethod' => '<p>The method to use for the authorization request.</p>', 'UpdateConnectionOAuthRequestParameters$HttpMethod' => '<p>The method used to connect to the HTTP endpoint.</p>', ], ], 'ConnectionOAuthResponseParameters' => [ 'base' => '<p>Contains the response parameters when OAuth is specified as the authorization type.</p>', 'refs' => [ 'ConnectionAuthResponseParameters$OAuthParameters' => '<p>The OAuth parameters to use for authorization.</p>', ], ], 'ConnectionQueryStringParameter' => [ 'base' => '<p>Additional query string parameter for the connection. You can include up to 100 additional query string parameters per request. Each additional parameter counts towards the event payload size, which cannot exceed 64 KB.</p>', 'refs' => [ 'ConnectionQueryStringParametersList$member' => NULL, ], ], 'ConnectionQueryStringParametersList' => [ 'base' => NULL, 'refs' => [ 'ConnectionHttpParameters$QueryStringParameters' => '<p>Contains additional query string parameters for the connection.</p>', ], ], 'ConnectionResponseList' => [ 'base' => NULL, 'refs' => [ 'ListConnectionsResponse$Connections' => '<p>An array of connections objects that include details about the connections.</p>', ], ], 'ConnectionState' => [ 'base' => NULL, 'refs' => [ 'Connection$ConnectionState' => '<p>The state of the connection.</p>', 'CreateConnectionResponse$ConnectionState' => '<p>The state of the connection that was created by the request.</p>', 'DeauthorizeConnectionResponse$ConnectionState' => '<p>The state of the connection.</p>', 'DeleteConnectionResponse$ConnectionState' => '<p>The state of the connection before it was deleted.</p>', 'DescribeConnectionResponse$ConnectionState' => '<p>The state of the connection retrieved.</p>', 'ListConnectionsRequest$ConnectionState' => '<p>The state of the connection.</p>', 'UpdateConnectionResponse$ConnectionState' => '<p>The state of the connection that was updated.</p>', ], ], 'ConnectionStateReason' => [ 'base' => NULL, 'refs' => [ 'Connection$StateReason' => '<p>The reason that the connection is in the connection state.</p>', 'DescribeConnectionResponse$StateReason' => '<p>The reason that the connection is in the current connection state.</p>', ], ], 'CreateApiDestinationRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateApiDestinationResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateArchiveRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateArchiveResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateConnectionApiKeyAuthRequestParameters' => [ 'base' => '<p>Contains the API key authorization parameters for the connection.</p>', 'refs' => [ 'CreateConnectionAuthRequestParameters$ApiKeyAuthParameters' => '<p>A <code>CreateConnectionApiKeyAuthRequestParameters</code> object that contains the API key authorization parameters to use for the connection.</p>', ], ], 'CreateConnectionAuthRequestParameters' => [ 'base' => '<p>Contains the authorization parameters for the connection.</p>', 'refs' => [ 'CreateConnectionRequest$AuthParameters' => '<p>A <code>CreateConnectionAuthRequestParameters</code> object that contains the authorization parameters to use to authorize with the endpoint. </p>', ], ], 'CreateConnectionBasicAuthRequestParameters' => [ 'base' => '<p>Contains the Basic authorization parameters to use for the connection.</p>', 'refs' => [ 'CreateConnectionAuthRequestParameters$BasicAuthParameters' => '<p>A <code>CreateConnectionBasicAuthRequestParameters</code> object that contains the Basic authorization parameters to use for the connection.</p>', ], ], 'CreateConnectionOAuthClientRequestParameters' => [ 'base' => '<p>Contains the Basic authorization parameters to use for the connection.</p>', 'refs' => [ 'CreateConnectionOAuthRequestParameters$ClientParameters' => '<p>A <code>CreateConnectionOAuthClientRequestParameters</code> object that contains the client parameters for OAuth authorization.</p>', ], ], 'CreateConnectionOAuthRequestParameters' => [ 'base' => '<p>Contains the OAuth authorization parameters to use for the connection.</p>', 'refs' => [ 'CreateConnectionAuthRequestParameters$OAuthParameters' => '<p>A <code>CreateConnectionOAuthRequestParameters</code> object that contains the OAuth authorization parameters to use for the connection.</p>', ], ], 'CreateConnectionRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateConnectionResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateEventBusRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateEventBusResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreatePartnerEventSourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreatePartnerEventSourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreatedBy' => [ 'base' => NULL, 'refs' => [ 'DescribeRuleResponse$CreatedBy' => '<p>The account ID of the user that created the rule. If you use <code>PutRule</code> to put a rule on an event bus in another account, the other account is the owner of the rule, and the rule ARN includes the account ID for that account. However, the value for <code>CreatedBy</code> is the account ID as the account that created the rule in the other account.</p>', ], ], 'Database' => [ 'base' => NULL, 'refs' => [ 'RedshiftDataParameters$Database' => '<p>The name of the database. Required when authenticating using temporary credentials.</p>', ], ], 'DbUser' => [ 'base' => NULL, 'refs' => [ 'RedshiftDataParameters$DbUser' => '<p>The database user name. Required when authenticating using temporary credentials.</p>', ], ], 'DeactivateEventSourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeadLetterConfig' => [ 'base' => '<p>A <code>DeadLetterConfig</code> object that contains information about a dead-letter queue configuration.</p>', 'refs' => [ 'Target$DeadLetterConfig' => '<p>The <code>DeadLetterConfig</code> that defines the target queue to send dead-letter queue events to.</p>', ], ], 'DeauthorizeConnectionRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeauthorizeConnectionResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteApiDestinationRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteApiDestinationResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteArchiveRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteArchiveResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteConnectionRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteConnectionResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteEventBusRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeletePartnerEventSourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteRuleRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeApiDestinationRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeApiDestinationResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeArchiveRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeArchiveResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeConnectionRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeConnectionResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeEventBusRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeEventBusResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeEventSourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeEventSourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribePartnerEventSourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribePartnerEventSourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeReplayRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeReplayResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeRuleRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeRuleResponse' => [ 'base' => NULL, 'refs' => [], ], 'DisableRuleRequest' => [ 'base' => NULL, 'refs' => [], ], 'EcsParameters' => [ 'base' => '<p>The custom parameters to be used when the target is an Amazon ECS task.</p>', 'refs' => [ 'Target$EcsParameters' => '<p>Contains the Amazon ECS task definition and task count to be used, if the event target is an Amazon ECS task. For more information about Amazon ECS tasks, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task_defintions.html">Task Definitions </a> in the <i>Amazon EC2 Container Service Developer Guide</i>.</p>', ], ], 'EnableRuleRequest' => [ 'base' => NULL, 'refs' => [], ], 'ErrorCode' => [ 'base' => NULL, 'refs' => [ 'PutEventsResultEntry$ErrorCode' => '<p>The error code that indicates why the event submission failed.</p>', 'PutPartnerEventsResultEntry$ErrorCode' => '<p>The error code that indicates why the event submission failed.</p>', 'PutTargetsResultEntry$ErrorCode' => '<p>The error code that indicates why the target addition failed. If the value is <code>ConcurrentModificationException</code>, too many requests were made at the same time.</p>', 'RemoveTargetsResultEntry$ErrorCode' => '<p>The error code that indicates why the target removal failed. If the value is <code>ConcurrentModificationException</code>, too many requests were made at the same time.</p>', ], ], 'ErrorMessage' => [ 'base' => NULL, 'refs' => [ 'PutEventsResultEntry$ErrorMessage' => '<p>The error message that explains why the event submission failed.</p>', 'PutPartnerEventsResultEntry$ErrorMessage' => '<p>The error message that explains why the event submission failed.</p>', 'PutTargetsResultEntry$ErrorMessage' => '<p>The error message that explains why the target addition failed.</p>', 'RemoveTargetsResultEntry$ErrorMessage' => '<p>The error message that explains why the target removal failed.</p>', ], ], 'EventBus' => [ 'base' => '<p>An event bus receives events from a source and routes them to rules associated with that event bus. Your account\'s default event bus receives events from Amazon Web Services services. A custom event bus can receive events from your custom applications and services. A partner event bus receives events from an event source created by an SaaS partner. These events come from the partners services or applications.</p>', 'refs' => [ 'EventBusList$member' => NULL, ], ], 'EventBusList' => [ 'base' => NULL, 'refs' => [ 'ListEventBusesResponse$EventBuses' => '<p>This list of event buses.</p>', ], ], 'EventBusName' => [ 'base' => NULL, 'refs' => [ 'CreateEventBusRequest$Name' => '<p>The name of the new event bus. </p> <p>Event bus names cannot contain the / character. You can\'t use the name <code>default</code> for a custom event bus, as this name is already used for your account\'s default event bus.</p> <p>If this is a partner event bus, the name must exactly match the name of the partner event source that this event bus is matched to.</p>', 'DeleteEventBusRequest$Name' => '<p>The name of the event bus to delete.</p>', 'DescribeRuleResponse$EventBusName' => '<p>The name of the event bus associated with the rule.</p>', 'ListEventBusesRequest$NamePrefix' => '<p>Specifying this limits the results to only those event buses with names that start with the specified prefix.</p>', 'Rule$EventBusName' => '<p>The name or ARN of the event bus associated with the rule. If you omit this, the default event bus is used.</p>', ], ], 'EventBusNameOrArn' => [ 'base' => NULL, 'refs' => [ 'DeleteRuleRequest$EventBusName' => '<p>The name or ARN of the event bus associated with the rule. If you omit this, the default event bus is used.</p>', 'DescribeEventBusRequest$Name' => '<p>The name or ARN of the event bus to show details for. If you omit this, the default event bus is displayed.</p>', 'DescribeRuleRequest$EventBusName' => '<p>The name or ARN of the event bus associated with the rule. If you omit this, the default event bus is used.</p>', 'DisableRuleRequest$EventBusName' => '<p>The name or ARN of the event bus associated with the rule. If you omit this, the default event bus is used.</p>', 'EnableRuleRequest$EventBusName' => '<p>The name or ARN of the event bus associated with the rule. If you omit this, the default event bus is used.</p>', 'ListRuleNamesByTargetRequest$EventBusName' => '<p>The name or ARN of the event bus to list rules for. If you omit this, the default event bus is used.</p>', 'ListRulesRequest$EventBusName' => '<p>The name or ARN of the event bus to list the rules for. If you omit this, the default event bus is used.</p>', 'ListTargetsByRuleRequest$EventBusName' => '<p>The name or ARN of the event bus associated with the rule. If you omit this, the default event bus is used.</p>', 'PutRuleRequest$EventBusName' => '<p>The name or ARN of the event bus to associate with this rule. If you omit this, the default event bus is used.</p>', 'PutTargetsRequest$EventBusName' => '<p>The name or ARN of the event bus associated with the rule. If you omit this, the default event bus is used.</p>', 'RemoveTargetsRequest$EventBusName' => '<p>The name or ARN of the event bus associated with the rule. If you omit this, the default event bus is used.</p>', ], ], 'EventId' => [ 'base' => NULL, 'refs' => [ 'PutEventsResultEntry$EventId' => '<p>The ID of the event.</p>', 'PutPartnerEventsResultEntry$EventId' => '<p>The ID of the event.</p>', ], ], 'EventPattern' => [ 'base' => NULL, 'refs' => [ 'CreateArchiveRequest$EventPattern' => '<p>An event pattern to use to filter events sent to the archive.</p>', 'DescribeArchiveResponse$EventPattern' => '<p>The event pattern used to filter events sent to the archive.</p>', 'DescribeRuleResponse$EventPattern' => '<p>The event pattern. For more information, see <a href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eventbridge-and-event-patterns.html">Events and Event Patterns</a> in the <i>Amazon EventBridge User Guide</i>.</p>', 'PutRuleRequest$EventPattern' => '<p>The event pattern. For more information, see <a href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eventbridge-and-event-patterns.html">Events and Event Patterns</a> in the <i>Amazon EventBridge User Guide</i>.</p>', 'Rule$EventPattern' => '<p>The event pattern of the rule. For more information, see <a href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eventbridge-and-event-patterns.html">Events and Event Patterns</a> in the <i>Amazon EventBridge User Guide</i>.</p>', 'TestEventPatternRequest$EventPattern' => '<p>The event pattern. For more information, see <a href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eventbridge-and-event-patterns.html">Events and Event Patterns</a> in the <i>Amazon EventBridge User Guide</i>.</p>', 'UpdateArchiveRequest$EventPattern' => '<p>The event pattern to use to filter events sent to the archive.</p>', ], ], 'EventResource' => [ 'base' => NULL, 'refs' => [ 'EventResourceList$member' => NULL, ], ], 'EventResourceList' => [ 'base' => NULL, 'refs' => [ 'PutEventsRequestEntry$Resources' => '<p>Amazon Web Services resources, identified by Amazon Resource Name (ARN), which the event primarily concerns. Any number, including zero, may be present.</p>', 'PutPartnerEventsRequestEntry$Resources' => '<p>Amazon Web Services resources, identified by Amazon Resource Name (ARN), which the event primarily concerns. Any number, including zero, may be present.</p>', ], ], 'EventSource' => [ 'base' => '<p>A partner event source is created by an SaaS partner. If a customer creates a partner event bus that matches this event source, that Amazon Web Services account can receive events from the partner\'s applications or services.</p>', 'refs' => [ 'EventSourceList$member' => NULL, ], ], 'EventSourceList' => [ 'base' => NULL, 'refs' => [ 'ListEventSourcesResponse$EventSources' => '<p>The list of event sources.</p>', ], ], 'EventSourceName' => [ 'base' => NULL, 'refs' => [ 'ActivateEventSourceRequest$Name' => '<p>The name of the partner event source to activate.</p>', 'CreateEventBusRequest$EventSourceName' => '<p>If you are creating a partner event bus, this specifies the partner event source that the new event bus will be matched with.</p>', 'CreatePartnerEventSourceRequest$Name' => '<p>The name of the partner event source. This name must be unique and must be in the format <code> <i>partner_name</i>/<i>event_namespace</i>/<i>event_name</i> </code>. The Amazon Web Services account that wants to use this partner event source must create a partner event bus with a name that matches the name of the partner event source.</p>', 'DeactivateEventSourceRequest$Name' => '<p>The name of the partner event source to deactivate.</p>', 'DeletePartnerEventSourceRequest$Name' => '<p>The name of the event source to delete.</p>', 'DescribeEventSourceRequest$Name' => '<p>The name of the partner event source to display the details of.</p>', 'DescribePartnerEventSourceRequest$Name' => '<p>The name of the event source to display.</p>', 'ListPartnerEventSourceAccountsRequest$EventSourceName' => '<p>The name of the partner event source to display account information about.</p>', 'PutPartnerEventsRequestEntry$Source' => '<p>The event source that is generating the entry.</p>', ], ], 'EventSourceNamePrefix' => [ 'base' => NULL, 'refs' => [ 'ListEventSourcesRequest$NamePrefix' => '<p>Specifying this limits the results to only those partner event sources with names that start with the specified prefix.</p>', ], ], 'EventSourceState' => [ 'base' => NULL, 'refs' => [ 'DescribeEventSourceResponse$State' => '<p>The state of the event source. If it is ACTIVE, you have already created a matching event bus for this event source, and that event bus is active. If it is PENDING, either you haven\'t yet created a matching event bus, or that event bus is deactivated. If it is DELETED, you have created a matching event bus, but the event source has since been deleted.</p>', 'EventSource$State' => '<p>The state of the event source. If it is ACTIVE, you have already created a matching event bus for this event source, and that event bus is active. If it is PENDING, either you haven\'t yet created a matching event bus, or that event bus is deactivated. If it is DELETED, you have created a matching event bus, but the event source has since been deleted.</p>', 'PartnerEventSourceAccount$State' => '<p>The state of the event source. If it is ACTIVE, you have already created a matching event bus for this event source, and that event bus is active. If it is PENDING, either you haven\'t yet created a matching event bus, or that event bus is deactivated. If it is DELETED, you have created a matching event bus, but the event source has since been deleted.</p>', ], ], 'EventTime' => [ 'base' => NULL, 'refs' => [ 'PutEventsRequestEntry$Time' => '<p>The time stamp of the event, per <a href="https://www.rfc-editor.org/rfc/rfc3339.txt">RFC3339</a>. If no time stamp is provided, the time stamp of the <a href="https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_PutEvents.html">PutEvents</a> call is used.</p>', 'PutPartnerEventsRequestEntry$Time' => '<p>The date and time of the event.</p>', ], ], 'HeaderKey' => [ 'base' => NULL, 'refs' => [ 'ConnectionHeaderParameter$Key' => '<p>The key for the parameter.</p>', 'HeaderParametersMap$key' => NULL, ], ], 'HeaderParametersMap' => [ 'base' => NULL, 'refs' => [ 'HttpParameters$HeaderParameters' => '<p>The headers that need to be sent as part of request invoking the API Gateway REST API or EventBridge ApiDestination.</p>', ], ], 'HeaderValue' => [ 'base' => NULL, 'refs' => [ 'ConnectionHeaderParameter$Value' => '<p>The value associated with the key.</p>', 'HeaderParametersMap$value' => NULL, ], ], 'HttpParameters' => [ 'base' => '<p>These are custom parameter to be used when the target is an API Gateway REST APIs or EventBridge ApiDestinations. In the latter case, these are merged with any InvocationParameters specified on the Connection, with any values from the Connection taking precedence.</p>', 'refs' => [ 'Target$HttpParameters' => '<p>Contains the HTTP parameters to use when the target is a API Gateway REST endpoint or EventBridge ApiDestination.</p> <p>If you specify an API Gateway REST API or EventBridge ApiDestination as a target, you can use this parameter to specify headers, path parameters, and query string keys/values as part of your target invoking request. If you\'re using ApiDestinations, the corresponding Connection can also have these values configured. In case of any conflicting keys, values from the Connection take precedence.</p>', ], ], 'HttpsEndpoint' => [ 'base' => NULL, 'refs' => [ 'ApiDestination$InvocationEndpoint' => '<p>The URL to the endpoint for the API destination.</p>', 'ConnectionOAuthResponseParameters$AuthorizationEndpoint' => '<p>The URL to the HTTP endpoint that authorized the request.</p>', 'CreateApiDestinationRequest$InvocationEndpoint' => '<p>The URL to the HTTP invocation endpoint for the API destination.</p>', 'CreateConnectionOAuthRequestParameters$AuthorizationEndpoint' => '<p>The URL to the authorization endpoint when OAuth is specified as the authorization type.</p>', 'DescribeApiDestinationResponse$InvocationEndpoint' => '<p>The URL to use to connect to the HTTP endpoint.</p>', 'UpdateApiDestinationRequest$InvocationEndpoint' => '<p>The URL to the endpoint to use for the API destination.</p>', 'UpdateConnectionOAuthRequestParameters$AuthorizationEndpoint' => '<p>The URL to the authorization endpoint when OAuth is specified as the authorization type.</p>', ], ], 'IllegalStatusException' => [ 'base' => '<p>An error occurred because a replay can be canceled only when the state is Running or Starting.</p>', 'refs' => [], ], 'InputTransformer' => [ 'base' => '<p>Contains the parameters needed for you to provide custom input to a target based on one or more pieces of data extracted from the event.</p>', 'refs' => [ 'Target$InputTransformer' => '<p>Settings to enable you to provide custom input to a target based on certain event data. You can extract one or more key-value pairs from the event and then use that data to send customized input to the target.</p>', ], ], 'InputTransformerPathKey' => [ 'base' => NULL, 'refs' => [ 'TransformerPaths$key' => NULL, ], ], 'Integer' => [ 'base' => NULL, 'refs' => [ 'BatchArrayProperties$Size' => '<p>The size of the array, if this is an array batch job. Valid values are integers between 2 and 10,000.</p>', 'BatchRetryStrategy$Attempts' => '<p>The number of times to attempt to retry, if the job fails. Valid values are 1–10.</p>', 'PutEventsResponse$FailedEntryCount' => '<p>The number of failed entries.</p>', 'PutPartnerEventsResponse$FailedEntryCount' => '<p>The number of events from this operation that could not be written to the partner event bus.</p>', 'PutTargetsResponse$FailedEntryCount' => '<p>The number of failed entries.</p>', 'RemoveTargetsResponse$FailedEntryCount' => '<p>The number of failed entries.</p>', ], ], 'InternalException' => [ 'base' => '<p>This exception occurs due to unexpected causes.</p>', 'refs' => [], ], 'InvalidEventPatternException' => [ 'base' => '<p>The event pattern is not valid.</p>', 'refs' => [], ], 'InvalidStateException' => [ 'base' => '<p>The specified state is not a valid state for an event source.</p>', 'refs' => [], ], 'KinesisParameters' => [ 'base' => '<p>This object enables you to specify a JSON path to extract from the event and use as the partition key for the Amazon Kinesis data stream, so that you can control the shard to which the event goes. If you do not include this parameter, the default is to use the <code>eventId</code> as the partition key.</p>', 'refs' => [ 'Target$KinesisParameters' => '<p>The custom parameter you can use to control the shard assignment, when the target is a Kinesis data stream. If you do not include this parameter, the default is to use the <code>eventId</code> as the partition key.</p>', ], ], 'LaunchType' => [ 'base' => NULL, 'refs' => [ 'EcsParameters$LaunchType' => '<p>Specifies the launch type on which your task is running. The launch type that you specify here must match one of the launch type (compatibilities) of the target task. The <code>FARGATE</code> value is supported only in the Regions where Fargate witt Amazon ECS is supported. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/AWS-Fargate.html">Fargate on Amazon ECS</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>', ], ], 'LimitExceededException' => [ 'base' => '<p>The request failed because it attempted to create resource beyond the allowed service quota.</p>', 'refs' => [], ], 'LimitMax100' => [ 'base' => NULL, 'refs' => [ 'ListApiDestinationsRequest$Limit' => '<p>The maximum number of API destinations to include in the response.</p>', 'ListArchivesRequest$Limit' => '<p>The maximum number of results to return.</p>', 'ListConnectionsRequest$Limit' => '<p>The maximum number of connections to return.</p>', 'ListEventBusesRequest$Limit' => '<p>Specifying this limits the number of results returned by this operation. The operation also returns a NextToken which you can use in a subsequent operation to retrieve the next set of results.</p>', 'ListEventSourcesRequest$Limit' => '<p>Specifying this limits the number of results returned by this operation. The operation also returns a NextToken which you can use in a subsequent operation to retrieve the next set of results.</p>', 'ListPartnerEventSourceAccountsRequest$Limit' => '<p>Specifying this limits the number of results returned by this operation. The operation also returns a NextToken which you can use in a subsequent operation to retrieve the next set of results.</p>', 'ListPartnerEventSourcesRequest$Limit' => '<p>pecifying this limits the number of results returned by this operation. The operation also returns a NextToken which you can use in a subsequent operation to retrieve the next set of results.</p>', 'ListReplaysRequest$Limit' => '<p>The maximum number of replays to retrieve.</p>', 'ListRuleNamesByTargetRequest$Limit' => '<p>The maximum number of results to return.</p>', 'ListRulesRequest$Limit' => '<p>The maximum number of results to return.</p>', 'ListTargetsByRuleRequest$Limit' => '<p>The maximum number of results to return.</p>', ], ], 'LimitMin1' => [ 'base' => NULL, 'refs' => [ 'EcsParameters$TaskCount' => '<p>The number of tasks to create based on <code>TaskDefinition</code>. The default is 1.</p>', ], ], 'ListApiDestinationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListApiDestinationsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListArchivesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListArchivesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListConnectionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListConnectionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListEventBusesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListEventBusesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListEventSourcesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListEventSourcesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListPartnerEventSourceAccountsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListPartnerEventSourceAccountsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListPartnerEventSourcesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListPartnerEventSourcesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListReplaysRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListReplaysResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListRuleNamesByTargetRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListRuleNamesByTargetResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListRulesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListRulesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTargetsByRuleRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTargetsByRuleResponse' => [ 'base' => NULL, 'refs' => [], ], 'Long' => [ 'base' => NULL, 'refs' => [ 'Archive$SizeBytes' => '<p>The size of the archive, in bytes.</p>', 'Archive$EventCount' => '<p>The number of events in the archive.</p>', 'DescribeArchiveResponse$SizeBytes' => '<p>The size of the archive in bytes.</p>', 'DescribeArchiveResponse$EventCount' => '<p>The number of events in the archive.</p>', ], ], 'ManagedBy' => [ 'base' => NULL, 'refs' => [ 'DescribeRuleResponse$ManagedBy' => '<p>If this is a managed rule, created by an Amazon Web Services service on your behalf, this field displays the principal name of the Amazon Web Services service that created the rule.</p>', 'Rule$ManagedBy' => '<p>If the rule was created on behalf of your account by an Amazon Web Services service, this field displays the principal name of the service that created the rule.</p>', ], ], 'ManagedRuleException' => [ 'base' => '<p>This rule was created by an Amazon Web Services service on behalf of your account. It is managed by that service. If you see this error in response to <code>DeleteRule</code> or <code>RemoveTargets</code>, you can use the <code>Force</code> parameter in those calls to delete the rule or remove targets from the rule. You cannot modify these managed rules by using <code>DisableRule</code>, <code>EnableRule</code>, <code>PutTargets</code>, <code>PutRule</code>, <code>TagResource</code>, or <code>UntagResource</code>. </p>', 'refs' => [], ], 'MaximumEventAgeInSeconds' => [ 'base' => NULL, 'refs' => [ 'RetryPolicy$MaximumEventAgeInSeconds' => '<p>The maximum amount of time, in seconds, to continue to make retry attempts.</p>', ], ], 'MaximumRetryAttempts' => [ 'base' => NULL, 'refs' => [ 'RetryPolicy$MaximumRetryAttempts' => '<p>The maximum number of retry attempts to make before the request fails. Retry attempts continue until either the maximum number of attempts is made or until the duration of the <code>MaximumEventAgeInSeconds</code> is met.</p>', ], ], 'MessageGroupId' => [ 'base' => NULL, 'refs' => [ 'SqsParameters$MessageGroupId' => '<p>The FIFO message group ID to use as the target.</p>', ], ], 'NetworkConfiguration' => [ 'base' => '<p>This structure specifies the network configuration for an ECS task.</p>', 'refs' => [ 'EcsParameters$NetworkConfiguration' => '<p>Use this structure if the Amazon ECS task uses the <code>awsvpc</code> network mode. This structure specifies the VPC subnets and security groups associated with the task, and whether a public IP address is to be used. This structure is required if <code>LaunchType</code> is <code>FARGATE</code> because the <code>awsvpc</code> mode is required for Fargate tasks.</p> <p>If you specify <code>NetworkConfiguration</code> when the target ECS task does not use the <code>awsvpc</code> network mode, the task fails.</p>', ], ], 'NextToken' => [ 'base' => NULL, 'refs' => [ 'ListApiDestinationsRequest$NextToken' => '<p>The token returned by a previous call to retrieve the next set of results.</p>', 'ListApiDestinationsResponse$NextToken' => '<p>A token you can use in a subsequent request to retrieve the next set of results.</p>', 'ListArchivesRequest$NextToken' => '<p>The token returned by a previous call to retrieve the next set of results.</p>', 'ListArchivesResponse$NextToken' => '<p>The token returned by a previous call to retrieve the next set of results.</p>', 'ListConnectionsRequest$NextToken' => '<p>The token returned by a previous call to retrieve the next set of results.</p>', 'ListConnectionsResponse$NextToken' => '<p>A token you can use in a subsequent request to retrieve the next set of results.</p>', 'ListEventBusesRequest$NextToken' => '<p>The token returned by a previous call to retrieve the next set of results.</p>', 'ListEventBusesResponse$NextToken' => '<p>A token you can use in a subsequent operation to retrieve the next set of results.</p>', 'ListEventSourcesRequest$NextToken' => '<p>The token returned by a previous call to retrieve the next set of results.</p>', 'ListEventSourcesResponse$NextToken' => '<p>A token you can use in a subsequent operation to retrieve the next set of results.</p>', 'ListPartnerEventSourceAccountsRequest$NextToken' => '<p>The token returned by a previous call to this operation. Specifying this retrieves the next set of results.</p>', 'ListPartnerEventSourceAccountsResponse$NextToken' => '<p>A token you can use in a subsequent operation to retrieve the next set of results.</p>', 'ListPartnerEventSourcesRequest$NextToken' => '<p>The token returned by a previous call to this operation. Specifying this retrieves the next set of results.</p>', 'ListPartnerEventSourcesResponse$NextToken' => '<p>A token you can use in a subsequent operation to retrieve the next set of results.</p>', 'ListReplaysRequest$NextToken' => '<p>The token returned by a previous call to retrieve the next set of results.</p>', 'ListReplaysResponse$NextToken' => '<p>The token returned by a previous call to retrieve the next set of results.</p>', 'ListRuleNamesByTargetRequest$NextToken' => '<p>The token returned by a previous call to retrieve the next set of results.</p>', 'ListRuleNamesByTargetResponse$NextToken' => '<p>Indicates whether there are additional results to retrieve. If there are no more results, the value is null.</p>', 'ListRulesRequest$NextToken' => '<p>The token returned by a previous call to retrieve the next set of results.</p>', 'ListRulesResponse$NextToken' => '<p>Indicates whether there are additional results to retrieve. If there are no more results, the value is null.</p>', 'ListTargetsByRuleRequest$NextToken' => '<p>The token returned by a previous call to retrieve the next set of results.</p>', 'ListTargetsByRuleResponse$NextToken' => '<p>Indicates whether there are additional results to retrieve. If there are no more results, the value is null.</p>', ], ], 'NonPartnerEventBusName' => [ 'base' => NULL, 'refs' => [ 'PutPermissionRequest$EventBusName' => '<p>The name of the event bus associated with the rule. If you omit this, the default event bus is used.</p>', 'RemovePermissionRequest$EventBusName' => '<p>The name of the event bus to revoke permissions for. If you omit this, the default event bus is used.</p>', ], ], 'NonPartnerEventBusNameOrArn' => [ 'base' => NULL, 'refs' => [ 'PutEventsRequestEntry$EventBusName' => '<p>The name or ARN of the event bus to receive the event. Only the rules that are associated with this event bus are used to match the event. If you omit this, the default event bus is used.</p>', ], ], 'OperationDisabledException' => [ 'base' => '<p>The operation you are attempting is not available in this region.</p>', 'refs' => [], ], 'PartnerEventSource' => [ 'base' => '<p>A partner event source is created by an SaaS partner. If a customer creates a partner event bus that matches this event source, that Amazon Web Services account can receive events from the partner\'s applications or services.</p>', 'refs' => [ 'PartnerEventSourceList$member' => NULL, ], ], 'PartnerEventSourceAccount' => [ 'base' => '<p>The Amazon Web Services account that a partner event source has been offered to.</p>', 'refs' => [ 'PartnerEventSourceAccountList$member' => NULL, ], ], 'PartnerEventSourceAccountList' => [ 'base' => NULL, 'refs' => [ 'ListPartnerEventSourceAccountsResponse$PartnerEventSourceAccounts' => '<p>The list of partner event sources returned by the operation.</p>', ], ], 'PartnerEventSourceList' => [ 'base' => NULL, 'refs' => [ 'ListPartnerEventSourcesResponse$PartnerEventSources' => '<p>The list of partner event sources returned by the operation.</p>', ], ], 'PartnerEventSourceNamePrefix' => [ 'base' => NULL, 'refs' => [ 'ListPartnerEventSourcesRequest$NamePrefix' => '<p>If you specify this, the results are limited to only those partner event sources that start with the string you specify.</p>', ], ], 'PathParameter' => [ 'base' => NULL, 'refs' => [ 'PathParameterList$member' => NULL, ], ], 'PathParameterList' => [ 'base' => NULL, 'refs' => [ 'HttpParameters$PathParameterValues' => '<p>The path parameter values to be used to populate API Gateway REST API or EventBridge ApiDestination path wildcards ("*").</p>', ], ], 'PlacementConstraint' => [ 'base' => '<p>An object representing a constraint on task placement. To learn more, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-placement-constraints.html">Task Placement Constraints</a> in the Amazon Elastic Container Service Developer Guide.</p>', 'refs' => [ 'PlacementConstraints$member' => NULL, ], ], 'PlacementConstraintExpression' => [ 'base' => NULL, 'refs' => [ 'PlacementConstraint$expression' => '<p>A cluster query language expression to apply to the constraint. You cannot specify an expression if the constraint type is <code>distinctInstance</code>. To learn more, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/cluster-query-language.html">Cluster Query Language</a> in the Amazon Elastic Container Service Developer Guide. </p>', ], ], 'PlacementConstraintType' => [ 'base' => NULL, 'refs' => [ 'PlacementConstraint$type' => '<p>The type of constraint. Use distinctInstance to ensure that each task in a particular group is running on a different container instance. Use memberOf to restrict the selection to a group of valid candidates. </p>', ], ], 'PlacementConstraints' => [ 'base' => NULL, 'refs' => [ 'EcsParameters$PlacementConstraints' => '<p>An array of placement constraint objects to use for the task. You can specify up to 10 constraints per task (including constraints in the task definition and those specified at runtime).</p>', ], ], 'PlacementStrategies' => [ 'base' => NULL, 'refs' => [ 'EcsParameters$PlacementStrategy' => '<p>The placement strategy objects to use for the task. You can specify a maximum of five strategy rules per task. </p>', ], ], 'PlacementStrategy' => [ 'base' => '<p>The task placement strategy for a task or service. To learn more, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-placement-strategies.html">Task Placement Strategies</a> in the Amazon Elastic Container Service Service Developer Guide.</p>', 'refs' => [ 'PlacementStrategies$member' => NULL, ], ], 'PlacementStrategyField' => [ 'base' => NULL, 'refs' => [ 'PlacementStrategy$field' => '<p>The field to apply the placement strategy against. For the spread placement strategy, valid values are instanceId (or host, which has the same effect), or any platform or custom attribute that is applied to a container instance, such as attribute:ecs.availability-zone. For the binpack placement strategy, valid values are cpu and memory. For the random placement strategy, this field is not used. </p>', ], ], 'PlacementStrategyType' => [ 'base' => NULL, 'refs' => [ 'PlacementStrategy$type' => '<p>The type of placement strategy. The random placement strategy randomly places tasks on available candidates. The spread placement strategy spreads placement across available candidates evenly based on the field parameter. The binpack strategy places tasks on available candidates that have the least available amount of the resource that is specified with the field parameter. For example, if you binpack on memory, a task is placed on the instance with the least amount of remaining memory (but still enough to run the task). </p>', ], ], 'PolicyLengthExceededException' => [ 'base' => '<p>The event bus policy is too long. For more information, see the limits.</p>', 'refs' => [], ], 'Principal' => [ 'base' => NULL, 'refs' => [ 'PutPermissionRequest$Principal' => '<p>The 12-digit Amazon Web Services account ID that you are permitting to put events to your default event bus. Specify "*" to permit any account to put events to your default event bus.</p> <p>If you specify "*" without specifying <code>Condition</code>, avoid creating rules that may match undesirable events. To create more secure rules, make sure that the event pattern for each rule contains an <code>account</code> field with a specific account ID from which to receive events. Rules with an account field do not match any events sent from other accounts.</p>', ], ], 'PropagateTags' => [ 'base' => NULL, 'refs' => [ 'EcsParameters$PropagateTags' => '<p>Specifies whether to propagate the tags from the task definition to the task. If no value is specified, the tags are not propagated. Tags can only be propagated to the task during task creation. To add tags to a task after task creation, use the TagResource API action. </p>', ], ], 'PutEventsRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutEventsRequestEntry' => [ 'base' => '<p>Represents an event to be submitted.</p>', 'refs' => [ 'PutEventsRequestEntryList$member' => NULL, ], ], 'PutEventsRequestEntryList' => [ 'base' => NULL, 'refs' => [ 'PutEventsRequest$Entries' => '<p>The entry that defines an event in your system. You can specify several parameters for the entry such as the source and type of the event, resources associated with the event, and so on.</p>', ], ], 'PutEventsResponse' => [ 'base' => NULL, 'refs' => [], ], 'PutEventsResultEntry' => [ 'base' => '<p>Represents an event that failed to be submitted.</p>', 'refs' => [ 'PutEventsResultEntryList$member' => NULL, ], ], 'PutEventsResultEntryList' => [ 'base' => NULL, 'refs' => [ 'PutEventsResponse$Entries' => '<p>The successfully and unsuccessfully ingested events results. If the ingestion was successful, the entry has the event ID in it. Otherwise, you can use the error code and error message to identify the problem with the entry.</p>', ], ], 'PutPartnerEventsRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutPartnerEventsRequestEntry' => [ 'base' => '<p>The details about an event generated by an SaaS partner.</p>', 'refs' => [ 'PutPartnerEventsRequestEntryList$member' => NULL, ], ], 'PutPartnerEventsRequestEntryList' => [ 'base' => NULL, 'refs' => [ 'PutPartnerEventsRequest$Entries' => '<p>The list of events to write to the event bus.</p>', ], ], 'PutPartnerEventsResponse' => [ 'base' => NULL, 'refs' => [], ], 'PutPartnerEventsResultEntry' => [ 'base' => '<p>Represents an event that a partner tried to generate, but failed.</p>', 'refs' => [ 'PutPartnerEventsResultEntryList$member' => NULL, ], ], 'PutPartnerEventsResultEntryList' => [ 'base' => NULL, 'refs' => [ 'PutPartnerEventsResponse$Entries' => '<p>The list of events from this operation that were successfully written to the partner event bus.</p>', ], ], 'PutPermissionRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutRuleRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutRuleResponse' => [ 'base' => NULL, 'refs' => [], ], 'PutTargetsRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutTargetsResponse' => [ 'base' => NULL, 'refs' => [], ], 'PutTargetsResultEntry' => [ 'base' => '<p>Represents a target that failed to be added to a rule.</p>', 'refs' => [ 'PutTargetsResultEntryList$member' => NULL, ], ], 'PutTargetsResultEntryList' => [ 'base' => NULL, 'refs' => [ 'PutTargetsResponse$FailedEntries' => '<p>The failed target entries.</p>', ], ], 'QueryStringKey' => [ 'base' => NULL, 'refs' => [ 'ConnectionQueryStringParameter$Key' => '<p>The key for a query string parameter.</p>', 'QueryStringParametersMap$key' => NULL, ], ], 'QueryStringParametersMap' => [ 'base' => NULL, 'refs' => [ 'HttpParameters$QueryStringParameters' => '<p>The query string keys/values that need to be sent as part of request invoking the API Gateway REST API or EventBridge ApiDestination.</p>', ], ], 'QueryStringValue' => [ 'base' => NULL, 'refs' => [ 'ConnectionQueryStringParameter$Value' => '<p>The value associated with the key for the query string parameter.</p>', 'QueryStringParametersMap$value' => NULL, ], ], 'RedshiftDataParameters' => [ 'base' => '<p>These are custom parameters to be used when the target is a Amazon Redshift cluster to invoke the Amazon Redshift Data API ExecuteStatement based on EventBridge events.</p>', 'refs' => [ 'Target$RedshiftDataParameters' => '<p>Contains the Amazon Redshift Data API parameters to use when the target is a Amazon Redshift cluster.</p> <p>If you specify a Amazon Redshift Cluster as a Target, you can use this to specify parameters to invoke the Amazon Redshift Data API ExecuteStatement based on EventBridge events.</p>', ], ], 'RedshiftSecretManagerArn' => [ 'base' => NULL, 'refs' => [ 'RedshiftDataParameters$SecretManagerArn' => '<p>The name or ARN of the secret that enables access to the database. Required when authenticating using Amazon Web Services Secrets Manager.</p>', ], ], 'ReferenceId' => [ 'base' => NULL, 'refs' => [ 'EcsParameters$ReferenceId' => '<p>The reference ID to use for the task.</p>', ], ], 'RemovePermissionRequest' => [ 'base' => NULL, 'refs' => [], ], 'RemoveTargetsRequest' => [ 'base' => NULL, 'refs' => [], ], 'RemoveTargetsResponse' => [ 'base' => NULL, 'refs' => [], ], 'RemoveTargetsResultEntry' => [ 'base' => '<p>Represents a target that failed to be removed from a rule.</p>', 'refs' => [ 'RemoveTargetsResultEntryList$member' => NULL, ], ], 'RemoveTargetsResultEntryList' => [ 'base' => NULL, 'refs' => [ 'RemoveTargetsResponse$FailedEntries' => '<p>The failed target entries.</p>', ], ], 'Replay' => [ 'base' => '<p>A <code>Replay</code> object that contains details about a replay.</p>', 'refs' => [ 'ReplayList$member' => NULL, ], ], 'ReplayArn' => [ 'base' => NULL, 'refs' => [ 'CancelReplayResponse$ReplayArn' => '<p>The ARN of the replay to cancel.</p>', 'DescribeReplayResponse$ReplayArn' => '<p>The ARN of the replay.</p>', 'StartReplayResponse$ReplayArn' => '<p>The ARN of the replay.</p>', ], ], 'ReplayDescription' => [ 'base' => NULL, 'refs' => [ 'DescribeReplayResponse$Description' => '<p>The description of the replay.</p>', 'StartReplayRequest$Description' => '<p>A description for the replay to start.</p>', ], ], 'ReplayDestination' => [ 'base' => '<p>A <code>ReplayDestination</code> object that contains details about a replay.</p>', 'refs' => [ 'DescribeReplayResponse$Destination' => '<p>A <code>ReplayDestination</code> object that contains details about the replay.</p>', 'StartReplayRequest$Destination' => '<p>A <code>ReplayDestination</code> object that includes details about the destination for the replay.</p>', ], ], 'ReplayDestinationFilters' => [ 'base' => NULL, 'refs' => [ 'ReplayDestination$FilterArns' => '<p>A list of ARNs for rules to replay events to.</p>', ], ], 'ReplayList' => [ 'base' => NULL, 'refs' => [ 'ListReplaysResponse$Replays' => '<p>An array of <code>Replay</code> objects that contain information about the replay.</p>', ], ], 'ReplayName' => [ 'base' => NULL, 'refs' => [ 'CancelReplayRequest$ReplayName' => '<p>The name of the replay to cancel.</p>', 'DescribeReplayRequest$ReplayName' => '<p>The name of the replay to retrieve.</p>', 'DescribeReplayResponse$ReplayName' => '<p>The name of the replay.</p>', 'ListReplaysRequest$NamePrefix' => '<p>A name prefix to filter the replays returned. Only replays with name that match the prefix are returned.</p>', 'Replay$ReplayName' => '<p>The name of the replay.</p>', 'StartReplayRequest$ReplayName' => '<p>The name of the replay to start.</p>', ], ], 'ReplayState' => [ 'base' => NULL, 'refs' => [ 'CancelReplayResponse$State' => '<p>The current state of the replay.</p>', 'DescribeReplayResponse$State' => '<p>The current state of the replay.</p>', 'ListReplaysRequest$State' => '<p>The state of the replay.</p>', 'Replay$State' => '<p>The current state of the replay.</p>', 'StartReplayResponse$State' => '<p>The state of the replay.</p>', ], ], 'ReplayStateReason' => [ 'base' => NULL, 'refs' => [ 'CancelReplayResponse$StateReason' => '<p>The reason that the replay is in the current state.</p>', 'DescribeReplayResponse$StateReason' => '<p>The reason that the replay is in the current state.</p>', 'Replay$StateReason' => '<p>A description of why the replay is in the current state.</p>', 'StartReplayResponse$StateReason' => '<p>The reason that the replay is in the state.</p>', ], ], 'ResourceAlreadyExistsException' => [ 'base' => '<p>The resource you are trying to create already exists.</p>', 'refs' => [], ], 'ResourceArn' => [ 'base' => NULL, 'refs' => [ 'DeadLetterConfig$Arn' => '<p>The ARN of the SQS queue specified as the target for the dead-letter queue.</p>', ], ], 'ResourceNotFoundException' => [ 'base' => '<p>An entity that you specified does not exist.</p>', 'refs' => [], ], 'RetentionDays' => [ 'base' => NULL, 'refs' => [ 'Archive$RetentionDays' => '<p>The number of days to retain events in the archive before they are deleted.</p>', 'CreateArchiveRequest$RetentionDays' => '<p>The number of days to retain events for. Default value is 0. If set to 0, events are retained indefinitely</p>', 'DescribeArchiveResponse$RetentionDays' => '<p>The number of days to retain events for in the archive.</p>', 'UpdateArchiveRequest$RetentionDays' => '<p>The number of days to retain events in the archive.</p>', ], ], 'RetryPolicy' => [ 'base' => '<p>A <code>RetryPolicy</code> object that includes information about the retry policy settings.</p>', 'refs' => [ 'Target$RetryPolicy' => '<p>The <code>RetryPolicy</code> object that contains the retry policy configuration to use for the dead-letter queue.</p>', ], ], 'RoleArn' => [ 'base' => NULL, 'refs' => [ 'DescribeRuleResponse$RoleArn' => '<p>The Amazon Resource Name (ARN) of the IAM role associated with the rule.</p>', 'PutRuleRequest$RoleArn' => '<p>The Amazon Resource Name (ARN) of the IAM role associated with the rule.</p> <p>If you\'re setting an event bus in another account as the target and that account granted permission to your account through an organization instead of directly by the account ID, you must specify a <code>RoleArn</code> with proper permissions in the <code>Target</code> structure, instead of here in this parameter.</p>', 'Rule$RoleArn' => '<p>The Amazon Resource Name (ARN) of the role that is used for target invocation.</p> <p>If you\'re setting an event bus in another account as the target and that account granted permission to your account through an organization instead of directly by the account ID, you must specify a <code>RoleArn</code> with proper permissions in the <code>Target</code> structure, instead of here in this parameter.</p>', 'Target$RoleArn' => '<p>The Amazon Resource Name (ARN) of the IAM role to be used for this target when the rule is triggered. If one rule triggers multiple targets, you can use a different IAM role for each target.</p>', ], ], 'Rule' => [ 'base' => '<p>Contains information about a rule in Amazon EventBridge.</p>', 'refs' => [ 'RuleResponseList$member' => NULL, ], ], 'RuleArn' => [ 'base' => NULL, 'refs' => [ 'DescribeRuleResponse$Arn' => '<p>The Amazon Resource Name (ARN) of the rule.</p>', 'PutRuleResponse$RuleArn' => '<p>The Amazon Resource Name (ARN) of the rule.</p>', 'Rule$Arn' => '<p>The Amazon Resource Name (ARN) of the rule.</p>', ], ], 'RuleDescription' => [ 'base' => NULL, 'refs' => [ 'DescribeRuleResponse$Description' => '<p>The description of the rule.</p>', 'PutRuleRequest$Description' => '<p>A description of the rule.</p>', 'Rule$Description' => '<p>The description of the rule.</p>', ], ], 'RuleName' => [ 'base' => NULL, 'refs' => [ 'DeleteRuleRequest$Name' => '<p>The name of the rule.</p>', 'DescribeRuleRequest$Name' => '<p>The name of the rule.</p>', 'DescribeRuleResponse$Name' => '<p>The name of the rule.</p>', 'DisableRuleRequest$Name' => '<p>The name of the rule.</p>', 'EnableRuleRequest$Name' => '<p>The name of the rule.</p>', 'ListRulesRequest$NamePrefix' => '<p>The prefix matching the rule name.</p>', 'ListTargetsByRuleRequest$Rule' => '<p>The name of the rule.</p>', 'PutRuleRequest$Name' => '<p>The name of the rule that you are creating or updating.</p>', 'PutTargetsRequest$Rule' => '<p>The name of the rule.</p>', 'RemoveTargetsRequest$Rule' => '<p>The name of the rule.</p>', 'Rule$Name' => '<p>The name of the rule.</p>', 'RuleNameList$member' => NULL, ], ], 'RuleNameList' => [ 'base' => NULL, 'refs' => [ 'ListRuleNamesByTargetResponse$RuleNames' => '<p>The names of the rules that can invoke the given target.</p>', ], ], 'RuleResponseList' => [ 'base' => NULL, 'refs' => [ 'ListRulesResponse$Rules' => '<p>The rules that match the specified criteria.</p>', ], ], 'RuleState' => [ 'base' => NULL, 'refs' => [ 'DescribeRuleResponse$State' => '<p>Specifies whether the rule is enabled or disabled.</p>', 'PutRuleRequest$State' => '<p>Indicates whether the rule is enabled or disabled.</p>', 'Rule$State' => '<p>The state of the rule.</p>', ], ], 'RunCommandParameters' => [ 'base' => '<p>This parameter contains the criteria (either InstanceIds or a tag) used to specify which EC2 instances are to be sent the command. </p>', 'refs' => [ 'Target$RunCommandParameters' => '<p>Parameters used when you are using the rule to invoke Amazon EC2 Run Command.</p>', ], ], 'RunCommandTarget' => [ 'base' => '<p>Information about the EC2 instances that are to be sent the command, specified as key-value pairs. Each <code>RunCommandTarget</code> block can include only one key, but this key may specify multiple values.</p>', 'refs' => [ 'RunCommandTargets$member' => NULL, ], ], 'RunCommandTargetKey' => [ 'base' => NULL, 'refs' => [ 'RunCommandTarget$Key' => '<p>Can be either <code>tag:</code> <i>tag-key</i> or <code>InstanceIds</code>.</p>', ], ], 'RunCommandTargetValue' => [ 'base' => NULL, 'refs' => [ 'RunCommandTargetValues$member' => NULL, ], ], 'RunCommandTargetValues' => [ 'base' => NULL, 'refs' => [ 'RunCommandTarget$Values' => '<p>If <code>Key</code> is <code>tag:</code> <i>tag-key</i>, <code>Values</code> is a list of tag values. If <code>Key</code> is <code>InstanceIds</code>, <code>Values</code> is a list of Amazon EC2 instance IDs.</p>', ], ], 'RunCommandTargets' => [ 'base' => NULL, 'refs' => [ 'RunCommandParameters$RunCommandTargets' => '<p>Currently, we support including only one RunCommandTarget block, which specifies either an array of InstanceIds or a tag.</p>', ], ], 'SageMakerPipelineParameter' => [ 'base' => '<p>Name/Value pair of a parameter to start execution of a SageMaker Model Building Pipeline.</p>', 'refs' => [ 'SageMakerPipelineParameterList$member' => NULL, ], ], 'SageMakerPipelineParameterList' => [ 'base' => NULL, 'refs' => [ 'SageMakerPipelineParameters$PipelineParameterList' => '<p>List of Parameter names and values for SageMaker Model Building Pipeline execution.</p>', ], ], 'SageMakerPipelineParameterName' => [ 'base' => NULL, 'refs' => [ 'SageMakerPipelineParameter$Name' => '<p>Name of parameter to start execution of a SageMaker Model Building Pipeline.</p>', ], ], 'SageMakerPipelineParameterValue' => [ 'base' => NULL, 'refs' => [ 'SageMakerPipelineParameter$Value' => '<p>Value of parameter to start execution of a SageMaker Model Building Pipeline.</p>', ], ], 'SageMakerPipelineParameters' => [ 'base' => '<p>These are custom parameters to use when the target is a SageMaker Model Building Pipeline that starts based on EventBridge events.</p>', 'refs' => [ 'Target$SageMakerPipelineParameters' => '<p>Contains the SageMaker Model Building Pipeline parameters to start execution of a SageMaker Model Building Pipeline.</p> <p>If you specify a SageMaker Model Building Pipeline as a target, you can use this to specify parameters to start a pipeline execution based on EventBridge events.</p>', ], ], 'ScheduleExpression' => [ 'base' => NULL, 'refs' => [ 'DescribeRuleResponse$ScheduleExpression' => '<p>The scheduling expression. For example, "cron(0 20 * * ? *)", "rate(5 minutes)".</p>', 'PutRuleRequest$ScheduleExpression' => '<p>The scheduling expression. For example, "cron(0 20 * * ? *)" or "rate(5 minutes)".</p>', 'Rule$ScheduleExpression' => '<p>The scheduling expression. For example, "cron(0 20 * * ? *)", "rate(5 minutes)". For more information, see <a href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-create-rule-schedule.html">Creating an Amazon EventBridge rule that runs on a schedule</a>.</p>', ], ], 'SecretsManagerSecretArn' => [ 'base' => NULL, 'refs' => [ 'DescribeConnectionResponse$SecretArn' => '<p>The ARN of the secret created from the authorization parameters specified for the connection.</p>', ], ], 'Sql' => [ 'base' => NULL, 'refs' => [ 'RedshiftDataParameters$Sql' => '<p>The SQL statement text to run.</p>', ], ], 'SqsParameters' => [ 'base' => '<p>This structure includes the custom parameter to be used when the target is an SQS FIFO queue.</p>', 'refs' => [ 'Target$SqsParameters' => '<p>Contains the message group ID to use when the target is a FIFO queue.</p> <p>If you specify an SQS FIFO queue as a target, the queue must have content-based deduplication enabled.</p>', ], ], 'StartReplayRequest' => [ 'base' => NULL, 'refs' => [], ], 'StartReplayResponse' => [ 'base' => NULL, 'refs' => [], ], 'StatementId' => [ 'base' => NULL, 'refs' => [ 'PutPermissionRequest$StatementId' => '<p>An identifier string for the external account that you are granting permissions to. If you later want to revoke the permission for this external account, specify this <code>StatementId</code> when you run <a href="https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_RemovePermission.html">RemovePermission</a>.</p>', 'RemovePermissionRequest$StatementId' => '<p>The statement ID corresponding to the account that is no longer allowed to put events to the default event bus.</p>', ], ], 'StatementName' => [ 'base' => NULL, 'refs' => [ 'RedshiftDataParameters$StatementName' => '<p>The name of the SQL statement. You can name the SQL statement when you create it to identify the query.</p>', ], ], 'String' => [ 'base' => NULL, 'refs' => [ 'BatchParameters$JobDefinition' => '<p>The ARN or name of the job definition to use if the event target is an Batch job. This job definition must already exist.</p>', 'BatchParameters$JobName' => '<p>The name to use for this execution of the job, if the target is an Batch job.</p>', 'Condition$Type' => '<p>Specifies the type of condition. Currently the only supported value is <code>StringEquals</code>.</p>', 'Condition$Key' => '<p>Specifies the key for the condition. Currently the only supported key is <code>aws:PrincipalOrgID</code>.</p>', 'Condition$Value' => '<p>Specifies the value for the key. Currently, this must be the ID of the organization.</p>', 'ConnectionBodyParameter$Key' => '<p>The key for the parameter.</p>', 'ConnectionBodyParameter$Value' => '<p>The value associated with the key.</p>', 'CreateEventBusResponse$EventBusArn' => '<p>The ARN of the new event bus.</p>', 'CreatePartnerEventSourceResponse$EventSourceArn' => '<p>The ARN of the partner event source.</p>', 'DescribeEventBusResponse$Name' => '<p>The name of the event bus. Currently, this is always <code>default</code>.</p>', 'DescribeEventBusResponse$Arn' => '<p>The Amazon Resource Name (ARN) of the account permitted to write events to the current account.</p>', 'DescribeEventBusResponse$Policy' => '<p>The policy that enables the external account to send events to your account.</p>', 'DescribeEventSourceResponse$Arn' => '<p>The ARN of the partner event source.</p>', 'DescribeEventSourceResponse$CreatedBy' => '<p>The name of the SaaS partner that created the event source.</p>', 'DescribeEventSourceResponse$Name' => '<p>The name of the partner event source.</p>', 'DescribePartnerEventSourceResponse$Arn' => '<p>The ARN of the event source.</p>', 'DescribePartnerEventSourceResponse$Name' => '<p>The name of the event source.</p>', 'EcsParameters$PlatformVersion' => '<p>Specifies the platform version for the task. Specify only the numeric portion of the platform version, such as <code>1.1.0</code>.</p> <p>This structure is used only if <code>LaunchType</code> is <code>FARGATE</code>. For more information about valid platform versions, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/platform_versions.html">Fargate Platform Versions</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>', 'EcsParameters$Group' => '<p>Specifies an ECS task group for the task. The maximum length is 255 characters.</p>', 'EventBus$Name' => '<p>The name of the event bus.</p>', 'EventBus$Arn' => '<p>The ARN of the event bus.</p>', 'EventBus$Policy' => '<p>The permissions policy of the event bus, describing which other Amazon Web Services accounts can write events to this event bus.</p>', 'EventSource$Arn' => '<p>The ARN of the event source.</p>', 'EventSource$CreatedBy' => '<p>The name of the partner that created the event source.</p>', 'EventSource$Name' => '<p>The name of the event source.</p>', 'PartnerEventSource$Arn' => '<p>The ARN of the partner event source.</p>', 'PartnerEventSource$Name' => '<p>The name of the partner event source.</p>', 'PutEventsRequestEntry$Source' => '<p>The source of the event.</p>', 'PutEventsRequestEntry$DetailType' => '<p>Free-form string used to decide what fields to expect in the event detail.</p>', 'PutEventsRequestEntry$Detail' => '<p>A valid JSON string. There is no other schema imposed. The JSON string may contain fields and nested subobjects.</p>', 'PutPartnerEventsRequestEntry$DetailType' => '<p>A free-form string used to decide what fields to expect in the event detail.</p>', 'PutPartnerEventsRequestEntry$Detail' => '<p>A valid JSON string. There is no other schema imposed. The JSON string may contain fields and nested subobjects.</p>', 'PutPermissionRequest$Policy' => '<p>A JSON string that describes the permission policy statement. You can include a <code>Policy</code> parameter in the request instead of using the <code>StatementId</code>, <code>Action</code>, <code>Principal</code>, or <code>Condition</code> parameters.</p>', 'StringList$member' => NULL, 'TestEventPatternRequest$Event' => '<p>The event, in JSON format, to test against the event pattern. The JSON must follow the format specified in <a href="https://docs.aws.amazon.com/eventbridge/latest/userguide/aws-events.html">Amazon Web Services Events</a>, and the following fields are mandatory:</p> <ul> <li> <p> <code>id</code> </p> </li> <li> <p> <code>account</code> </p> </li> <li> <p> <code>source</code> </p> </li> <li> <p> <code>time</code> </p> </li> <li> <p> <code>region</code> </p> </li> <li> <p> <code>resources</code> </p> </li> <li> <p> <code>detail-type</code> </p> </li> </ul>', ], ], 'StringList' => [ 'base' => NULL, 'refs' => [ 'AwsVpcConfiguration$Subnets' => '<p>Specifies the subnets associated with the task. These subnets must all be in the same VPC. You can specify as many as 16 subnets.</p>', 'AwsVpcConfiguration$SecurityGroups' => '<p>Specifies the security groups associated with the task. These security groups must all be in the same VPC. You can specify as many as five security groups. If you do not specify a security group, the default security group for the VPC is used.</p>', ], ], 'Tag' => [ 'base' => '<p>A key-value pair associated with an Amazon Web Services resource. In EventBridge, rules and event buses support tagging.</p>', 'refs' => [ 'TagList$member' => NULL, ], ], 'TagKey' => [ 'base' => NULL, 'refs' => [ 'Tag$Key' => '<p>A string you can use to assign a value. The combination of tag keys and values can help you organize and categorize your resources.</p>', 'TagKeyList$member' => NULL, ], ], 'TagKeyList' => [ 'base' => NULL, 'refs' => [ 'UntagResourceRequest$TagKeys' => '<p>The list of tag keys to remove from the resource.</p>', ], ], 'TagList' => [ 'base' => NULL, 'refs' => [ 'CreateEventBusRequest$Tags' => '<p>Tags to associate with the event bus.</p>', 'EcsParameters$Tags' => '<p>The metadata that you apply to the task to help you categorize and organize them. Each tag consists of a key and an optional value, both of which you define. To learn more, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_RunTask.html#ECS-RunTask-request-tags">RunTask</a> in the Amazon ECS API Reference.</p>', 'ListTagsForResourceResponse$Tags' => '<p>The list of tag keys and values associated with the resource you specified</p>', 'PutRuleRequest$Tags' => '<p>The list of key-value pairs to associate with the rule.</p>', 'TagResourceRequest$Tags' => '<p>The list of key-value pairs to associate with the resource.</p>', ], ], 'TagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'TagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'TagValue' => [ 'base' => NULL, 'refs' => [ 'Tag$Value' => '<p>The value for the specified tag key.</p>', ], ], 'Target' => [ 'base' => '<p>Targets are the resources to be invoked when a rule is triggered. For a complete list of services and resources that can be set as a target, see <a href="https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_PutTargets.html">PutTargets</a>.</p> <p>If you are setting the event bus of another account as the target, and that account granted permission to your account through an organization instead of directly by the account ID, then you must specify a <code>RoleArn</code> with proper permissions in the <code>Target</code> structure. For more information, see <a href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eventbridge-cross-account-event-delivery.html">Sending and Receiving Events Between Amazon Web Services Accounts</a> in the <i>Amazon EventBridge User Guide</i>.</p>', 'refs' => [ 'TargetList$member' => NULL, ], ], 'TargetArn' => [ 'base' => NULL, 'refs' => [ 'ListRuleNamesByTargetRequest$TargetArn' => '<p>The Amazon Resource Name (ARN) of the target resource.</p>', 'Target$Arn' => '<p>The Amazon Resource Name (ARN) of the target.</p>', ], ], 'TargetId' => [ 'base' => NULL, 'refs' => [ 'PutTargetsResultEntry$TargetId' => '<p>The ID of the target.</p>', 'RemoveTargetsResultEntry$TargetId' => '<p>The ID of the target.</p>', 'Target$Id' => '<p>The ID of the target. We recommend using a memorable and unique string.</p>', 'TargetIdList$member' => NULL, ], ], 'TargetIdList' => [ 'base' => NULL, 'refs' => [ 'RemoveTargetsRequest$Ids' => '<p>The IDs of the targets to remove from the rule.</p>', ], ], 'TargetInput' => [ 'base' => NULL, 'refs' => [ 'Target$Input' => '<p>Valid JSON text passed to the target. In this case, nothing from the event itself is passed to the target. For more information, see <a href="http://www.rfc-editor.org/rfc/rfc7159.txt">The JavaScript Object Notation (JSON) Data Interchange Format</a>.</p>', ], ], 'TargetInputPath' => [ 'base' => NULL, 'refs' => [ 'Target$InputPath' => '<p>The value of the JSONPath that is used for extracting part of the matched event when passing it to the target. You must use JSON dot notation, not bracket notation. For more information about JSON paths, see <a href="http://goessner.net/articles/JsonPath/">JSONPath</a>.</p>', 'TransformerPaths$value' => NULL, ], ], 'TargetList' => [ 'base' => NULL, 'refs' => [ 'ListTargetsByRuleResponse$Targets' => '<p>The targets assigned to the rule.</p>', 'PutTargetsRequest$Targets' => '<p>The targets to update or add to the rule.</p>', ], ], 'TargetPartitionKeyPath' => [ 'base' => NULL, 'refs' => [ 'KinesisParameters$PartitionKeyPath' => '<p>The JSON path to be extracted from the event and used as the partition key. For more information, see <a href="https://docs.aws.amazon.com/streams/latest/dev/key-concepts.html#partition-key">Amazon Kinesis Streams Key Concepts</a> in the <i>Amazon Kinesis Streams Developer Guide</i>.</p>', ], ], 'TestEventPatternRequest' => [ 'base' => NULL, 'refs' => [], ], 'TestEventPatternResponse' => [ 'base' => NULL, 'refs' => [], ], 'Timestamp' => [ 'base' => NULL, 'refs' => [ 'ApiDestination$CreationTime' => '<p>A time stamp for the time that the API destination was created.</p>', 'ApiDestination$LastModifiedTime' => '<p>A time stamp for the time that the API destination was last modified.</p>', 'Archive$CreationTime' => '<p>The time stamp for the time that the archive was created.</p>', 'Connection$CreationTime' => '<p>A time stamp for the time that the connection was created.</p>', 'Connection$LastModifiedTime' => '<p>A time stamp for the time that the connection was last modified.</p>', 'Connection$LastAuthorizedTime' => '<p>A time stamp for the time that the connection was last authorized.</p>', 'CreateApiDestinationResponse$CreationTime' => '<p>A time stamp indicating the time that the API destination was created.</p>', 'CreateApiDestinationResponse$LastModifiedTime' => '<p>A time stamp indicating the time that the API destination was last modified.</p>', 'CreateArchiveResponse$CreationTime' => '<p>The time at which the archive was created.</p>', 'CreateConnectionResponse$CreationTime' => '<p>A time stamp for the time that the connection was created.</p>', 'CreateConnectionResponse$LastModifiedTime' => '<p>A time stamp for the time that the connection was last updated.</p>', 'DeauthorizeConnectionResponse$CreationTime' => '<p>A time stamp for the time that the connection was created.</p>', 'DeauthorizeConnectionResponse$LastModifiedTime' => '<p>A time stamp for the time that the connection was last updated.</p>', 'DeauthorizeConnectionResponse$LastAuthorizedTime' => '<p>A time stamp for the time that the connection was last authorized.</p>', 'DeleteConnectionResponse$CreationTime' => '<p>A time stamp for the time that the connection was created.</p>', 'DeleteConnectionResponse$LastModifiedTime' => '<p>A time stamp for the time that the connection was last modified before it was deleted.</p>', 'DeleteConnectionResponse$LastAuthorizedTime' => '<p>A time stamp for the time that the connection was last authorized before it wa deleted.</p>', 'DescribeApiDestinationResponse$CreationTime' => '<p>A time stamp for the time that the API destination was created.</p>', 'DescribeApiDestinationResponse$LastModifiedTime' => '<p>A time stamp for the time that the API destination was last modified.</p>', 'DescribeArchiveResponse$CreationTime' => '<p>The time at which the archive was created.</p>', 'DescribeConnectionResponse$CreationTime' => '<p>A time stamp for the time that the connection was created.</p>', 'DescribeConnectionResponse$LastModifiedTime' => '<p>A time stamp for the time that the connection was last modified.</p>', 'DescribeConnectionResponse$LastAuthorizedTime' => '<p>A time stamp for the time that the connection was last authorized.</p>', 'DescribeEventSourceResponse$CreationTime' => '<p>The date and time that the event source was created.</p>', 'DescribeEventSourceResponse$ExpirationTime' => '<p>The date and time that the event source will expire if you do not create a matching event bus.</p>', 'DescribeReplayResponse$EventStartTime' => '<p>The time stamp of the first event that was last replayed from the archive.</p>', 'DescribeReplayResponse$EventEndTime' => '<p>The time stamp for the last event that was replayed from the archive.</p>', 'DescribeReplayResponse$EventLastReplayedTime' => '<p>The time that the event was last replayed.</p>', 'DescribeReplayResponse$ReplayStartTime' => '<p>A time stamp for the time that the replay started.</p>', 'DescribeReplayResponse$ReplayEndTime' => '<p>A time stamp for the time that the replay stopped.</p>', 'EventSource$CreationTime' => '<p>The date and time the event source was created.</p>', 'EventSource$ExpirationTime' => '<p>The date and time that the event source will expire, if the Amazon Web Services account doesn\'t create a matching event bus for it.</p>', 'PartnerEventSourceAccount$CreationTime' => '<p>The date and time the event source was created.</p>', 'PartnerEventSourceAccount$ExpirationTime' => '<p>The date and time that the event source will expire, if the Amazon Web Services account doesn\'t create a matching event bus for it.</p>', 'Replay$EventStartTime' => '<p>A time stamp for the time to start replaying events. This is determined by the time in the event as described in <a href="https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_PutEventsRequestEntry.html#eventbridge-Type-PutEventsRequestEntry-Time">Time</a>.</p>', 'Replay$EventEndTime' => '<p>A time stamp for the time to start replaying events. Any event with a creation time prior to the <code>EventEndTime</code> specified is replayed.</p>', 'Replay$EventLastReplayedTime' => '<p>A time stamp for the time that the last event was replayed.</p>', 'Replay$ReplayStartTime' => '<p>A time stamp for the time that the replay started.</p>', 'Replay$ReplayEndTime' => '<p>A time stamp for the time that the replay completed.</p>', 'StartReplayRequest$EventStartTime' => '<p>A time stamp for the time to start replaying events. Only events that occurred between the <code>EventStartTime</code> and <code>EventEndTime</code> are replayed.</p>', 'StartReplayRequest$EventEndTime' => '<p>A time stamp for the time to stop replaying events. Only events that occurred between the <code>EventStartTime</code> and <code>EventEndTime</code> are replayed.</p>', 'StartReplayResponse$ReplayStartTime' => '<p>The time at which the replay started.</p>', 'UpdateApiDestinationResponse$CreationTime' => '<p>A time stamp for the time that the API destination was created.</p>', 'UpdateApiDestinationResponse$LastModifiedTime' => '<p>A time stamp for the time that the API destination was last modified.</p>', 'UpdateArchiveResponse$CreationTime' => '<p>The time at which the archive was updated.</p>', 'UpdateConnectionResponse$CreationTime' => '<p>A time stamp for the time that the connection was created.</p>', 'UpdateConnectionResponse$LastModifiedTime' => '<p>A time stamp for the time that the connection was last modified.</p>', 'UpdateConnectionResponse$LastAuthorizedTime' => '<p>A time stamp for the time that the connection was last authorized.</p>', ], ], 'TraceHeader' => [ 'base' => NULL, 'refs' => [ 'PutEventsRequestEntry$TraceHeader' => '<p>An X-Ray trade header, which is an http header (X-Amzn-Trace-Id) that contains the trace-id associated with the event.</p> <p>To learn more about X-Ray trace headers, see <a href="https://docs.aws.amazon.com/xray/latest/devguide/xray-concepts.html#xray-concepts-tracingheader">Tracing header</a> in the X-Ray Developer Guide.</p>', ], ], 'TransformerInput' => [ 'base' => NULL, 'refs' => [ 'InputTransformer$InputTemplate' => '<p>Input template where you specify placeholders that will be filled with the values of the keys from <code>InputPathsMap</code> to customize the data sent to the target. Enclose each <code>InputPathsMaps</code> value in brackets: &lt;<i>value</i>&gt; The InputTemplate must be valid JSON.</p> <p>If <code>InputTemplate</code> is a JSON object (surrounded by curly braces), the following restrictions apply:</p> <ul> <li> <p>The placeholder cannot be used as an object key.</p> </li> </ul> <p>The following example shows the syntax for using <code>InputPathsMap</code> and <code>InputTemplate</code>.</p> <p> <code> "InputTransformer":</code> </p> <p> <code>{</code> </p> <p> <code>"InputPathsMap": {"instance": "$.detail.instance","status": "$.detail.status"},</code> </p> <p> <code>"InputTemplate": "&lt;instance&gt; is in state &lt;status&gt;"</code> </p> <p> <code>}</code> </p> <p>To have the <code>InputTemplate</code> include quote marks within a JSON string, escape each quote marks with a slash, as in the following example:</p> <p> <code> "InputTransformer":</code> </p> <p> <code>{</code> </p> <p> <code>"InputPathsMap": {"instance": "$.detail.instance","status": "$.detail.status"},</code> </p> <p> <code>"InputTemplate": "&lt;instance&gt; is in state \\"&lt;status&gt;\\""</code> </p> <p> <code>}</code> </p> <p>The <code>InputTemplate</code> can also be valid JSON with varibles in quotes or out, as in the following example:</p> <p> <code> "InputTransformer":</code> </p> <p> <code>{</code> </p> <p> <code>"InputPathsMap": {"instance": "$.detail.instance","status": "$.detail.status"},</code> </p> <p> <code>"InputTemplate": \'{"myInstance": &lt;instance&gt;,"myStatus": "&lt;instance&gt; is in state \\"&lt;status&gt;\\""}\'</code> </p> <p> <code>}</code> </p>', ], ], 'TransformerPaths' => [ 'base' => NULL, 'refs' => [ 'InputTransformer$InputPathsMap' => '<p>Map of JSON paths to be extracted from the event. You can then insert these in the template in <code>InputTemplate</code> to produce the output you want to be sent to the target.</p> <p> <code>InputPathsMap</code> is an array key-value pairs, where each value is a valid JSON path. You can have as many as 100 key-value pairs. You must use JSON dot notation, not bracket notation.</p> <p>The keys cannot start with "Amazon Web Services." </p>', ], ], 'UntagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'UntagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateApiDestinationRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateApiDestinationResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateArchiveRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateArchiveResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateConnectionApiKeyAuthRequestParameters' => [ 'base' => '<p>Contains the API key authorization parameters to use to update the connection.</p>', 'refs' => [ 'UpdateConnectionAuthRequestParameters$ApiKeyAuthParameters' => '<p>A <code>UpdateConnectionApiKeyAuthRequestParameters</code> object that contains the authorization parameters for API key authorization.</p>', ], ], 'UpdateConnectionAuthRequestParameters' => [ 'base' => '<p>Contains the additional parameters to use for the connection.</p>', 'refs' => [ 'UpdateConnectionRequest$AuthParameters' => '<p>The authorization parameters to use for the connection.</p>', ], ], 'UpdateConnectionBasicAuthRequestParameters' => [ 'base' => '<p>Contains the Basic authorization parameters for the connection.</p>', 'refs' => [ 'UpdateConnectionAuthRequestParameters$BasicAuthParameters' => '<p>A <code>UpdateConnectionBasicAuthRequestParameters</code> object that contains the authorization parameters for Basic authorization.</p>', ], ], 'UpdateConnectionOAuthClientRequestParameters' => [ 'base' => '<p>Contains the OAuth authorization parameters to use for the connection.</p>', 'refs' => [ 'UpdateConnectionOAuthRequestParameters$ClientParameters' => '<p>A <code>UpdateConnectionOAuthClientRequestParameters</code> object that contains the client parameters to use for the connection when OAuth is specified as the authorization type.</p>', ], ], 'UpdateConnectionOAuthRequestParameters' => [ 'base' => '<p>Contains the OAuth request parameters to use for the connection.</p>', 'refs' => [ 'UpdateConnectionAuthRequestParameters$OAuthParameters' => '<p>A <code>UpdateConnectionOAuthRequestParameters</code> object that contains the authorization parameters for OAuth authorization.</p>', ], ], 'UpdateConnectionRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateConnectionResponse' => [ 'base' => NULL, 'refs' => [], ], ],];
