<?php
// This file was auto-generated from sdk-root/src/data/cloudtrail/2013-11-01/docs-2.json
return [ 'version' => '2.0', 'service' => '<fullname>CloudTrail</fullname> <p>This is the CloudTrail API Reference. It provides descriptions of actions, data types, common parameters, and common errors for CloudTrail.</p> <p>CloudTrail is a web service that records Amazon Web Services API calls for your Amazon Web Services account and delivers log files to an Amazon S3 bucket. The recorded information includes the identity of the user, the start time of the Amazon Web Services API call, the source IP address, the request parameters, and the response elements returned by the service.</p> <note> <p>As an alternative to the API, you can use one of the Amazon Web Services SDKs, which consist of libraries and sample code for various programming languages and platforms (Java, Ruby, .NET, iOS, Android, etc.). The SDKs provide programmatic access to CloudTrail. For example, the SDKs handle cryptographically signing requests, managing errors, and retrying requests automatically. For more information about the Amazon Web Services SDKs, including how to download and install them, see <a href="http://aws.amazon.com/tools/">Tools to Build on Amazon Web Services</a>.</p> </note> <p>See the <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-user-guide.html">CloudTrail User Guide</a> for information about the data that is included with each Amazon Web Services API call listed in the log files.</p>', 'operations' => [ 'AddTags' => '<p>Adds one or more tags to a trail, up to a limit of 50. Overwrites an existing tag\'s value when a new value is specified for an existing tag key. Tag key names must be unique for a trail; you cannot have two keys with the same name but different values. If you specify a key without a value, the tag will be created with the specified key and a value of null. You can tag a trail that applies to all Amazon Web Services Regions only from the Region in which the trail was created (also known as its home region).</p>', 'CreateTrail' => '<p>Creates a trail that specifies the settings for delivery of log data to an Amazon S3 bucket. </p>', 'DeleteTrail' => '<p>Deletes a trail. This operation must be called from the region in which the trail was created. <code>DeleteTrail</code> cannot be called on the shadow trails (replicated trails in other regions) of a trail that is enabled in all regions.</p>', 'DescribeTrails' => '<p>Retrieves settings for one or more trails associated with the current region for your account.</p>', 'GetEventSelectors' => '<p>Describes the settings for the event selectors that you configured for your trail. The information returned for your event selectors includes the following:</p> <ul> <li> <p>If your event selector includes read-only events, write-only events, or all events. This applies to both management events and data events.</p> </li> <li> <p>If your event selector includes management events.</p> </li> <li> <p>If your event selector includes data events, the resources on which you are logging data events.</p> </li> </ul> <p>For more information, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-management-and-data-events-with-cloudtrail.html">Logging Data and Management Events for Trails </a> in the <i>CloudTrail User Guide</i>.</p>', 'GetInsightSelectors' => '<p>Describes the settings for the Insights event selectors that you configured for your trail. <code>GetInsightSelectors</code> shows if CloudTrail Insights event logging is enabled on the trail, and if it is, which insight types are enabled. If you run <code>GetInsightSelectors</code> on a trail that does not have Insights events enabled, the operation throws the exception <code>InsightNotEnabledException</code> </p> <p>For more information, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-insights-events-with-cloudtrail.html">Logging CloudTrail Insights Events for Trails </a> in the <i>CloudTrail User Guide</i>.</p>', 'GetTrail' => '<p>Returns settings information for a specified trail.</p>', 'GetTrailStatus' => '<p>Returns a JSON-formatted list of information about the specified trail. Fields include information on delivery errors, Amazon SNS and Amazon S3 errors, and start and stop logging times for each trail. This operation returns trail status from a single region. To return trail status from all regions, you must call the operation on each region.</p>', 'ListPublicKeys' => '<p>Returns all public keys whose private keys were used to sign the digest files within the specified time range. The public key is needed to validate digest files that were signed with its corresponding private key.</p> <note> <p>CloudTrail uses different private and public key pairs per region. Each digest file is signed with a private key unique to its region. When you validate a digest file from a specific region, you must look in the same region for its corresponding public key.</p> </note>', 'ListTags' => '<p>Lists the tags for the trail in the current region.</p>', 'ListTrails' => '<p>Lists trails that are in the current account.</p>', 'LookupEvents' => '<p>Looks up <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-concepts.html#cloudtrail-concepts-management-events">management events</a> or <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-concepts.html#cloudtrail-concepts-insights-events">CloudTrail Insights events</a> that are captured by CloudTrail. You can look up events that occurred in a region within the last 90 days. Lookup supports the following attributes for management events:</p> <ul> <li> <p>Amazon Web Services access key</p> </li> <li> <p>Event ID</p> </li> <li> <p>Event name</p> </li> <li> <p>Event source</p> </li> <li> <p>Read only</p> </li> <li> <p>Resource name</p> </li> <li> <p>Resource type</p> </li> <li> <p>User name</p> </li> </ul> <p>Lookup supports the following attributes for Insights events:</p> <ul> <li> <p>Event ID</p> </li> <li> <p>Event name</p> </li> <li> <p>Event source</p> </li> </ul> <p>All attributes are optional. The default number of results returned is 50, with a maximum of 50 possible. The response includes a token that you can use to get the next page of results.</p> <important> <p>The rate of lookup requests is limited to two per second, per account, per region. If this limit is exceeded, a throttling error occurs.</p> </important>', 'PutEventSelectors' => '<p>Configures an event selector or advanced event selectors for your trail. Use event selectors or advanced event selectors to specify management and data event settings for your trail. By default, trails created without specific event selectors are configured to log all read and write management events, and no data events.</p> <p>When an event occurs in your account, CloudTrail evaluates the event selectors or advanced event selectors in all trails. For each trail, if the event matches any event selector, the trail processes and logs the event. If the event doesn\'t match any event selector, the trail doesn\'t log the event.</p> <p>Example</p> <ol> <li> <p>You create an event selector for a trail and specify that you want write-only events.</p> </li> <li> <p>The EC2 <code>GetConsoleOutput</code> and <code>RunInstances</code> API operations occur in your account.</p> </li> <li> <p>CloudTrail evaluates whether the events match your event selectors.</p> </li> <li> <p>The <code>RunInstances</code> is a write-only event and it matches your event selector. The trail logs the event.</p> </li> <li> <p>The <code>GetConsoleOutput</code> is a read-only event that doesn\'t match your event selector. The trail doesn\'t log the event. </p> </li> </ol> <p>The <code>PutEventSelectors</code> operation must be called from the region in which the trail was created; otherwise, an <code>InvalidHomeRegionException</code> exception is thrown.</p> <p>You can configure up to five event selectors for each trail. For more information, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-management-and-data-events-with-cloudtrail.html">Logging data and management events for trails </a> and <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/WhatIsCloudTrail-Limits.html">Quotas in CloudTrail</a> in the <i>CloudTrail User Guide</i>.</p> <p>You can add advanced event selectors, and conditions for your advanced event selectors, up to a maximum of 500 values for all conditions and selectors on a trail. You can use either <code>AdvancedEventSelectors</code> or <code>EventSelectors</code>, but not both. If you apply <code>AdvancedEventSelectors</code> to a trail, any existing <code>EventSelectors</code> are overwritten. For more information about advanced event selectors, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-data-events-with-cloudtrail.html">Logging data events for trails</a> in the <i>CloudTrail User Guide</i>.</p>', 'PutInsightSelectors' => '<p>Lets you enable Insights event logging by specifying the Insights selectors that you want to enable on an existing trail. You also use <code>PutInsightSelectors</code> to turn off Insights event logging, by passing an empty list of insight types. The valid Insights event type in this release is <code>ApiCallRateInsight</code>.</p>', 'RemoveTags' => '<p>Removes the specified tags from a trail.</p>', 'StartLogging' => '<p>Starts the recording of Amazon Web Services API calls and log file delivery for a trail. For a trail that is enabled in all regions, this operation must be called from the region in which the trail was created. This operation cannot be called on the shadow trails (replicated trails in other regions) of a trail that is enabled in all regions.</p>', 'StopLogging' => '<p>Suspends the recording of Amazon Web Services API calls and log file delivery for the specified trail. Under most circumstances, there is no need to use this action. You can update a trail without stopping it first. This action is the only way to stop recording. For a trail enabled in all regions, this operation must be called from the region in which the trail was created, or an <code>InvalidHomeRegionException</code> will occur. This operation cannot be called on the shadow trails (replicated trails in other regions) of a trail enabled in all regions.</p>', 'UpdateTrail' => '<p>Updates trail settings that control what events you are logging, and how to handle log files. Changes to a trail do not require stopping the CloudTrail service. Use this action to designate an existing bucket for log delivery. If the existing bucket has previously been a target for CloudTrail log files, an IAM policy exists for the bucket. <code>UpdateTrail</code> must be called from the region in which the trail was created; otherwise, an <code>InvalidHomeRegionException</code> is thrown.</p>', ], 'shapes' => [ 'AddTagsRequest' => [ 'base' => '<p>Specifies the tags to add to a trail.</p>', 'refs' => [], ], 'AddTagsResponse' => [ 'base' => '<p>Returns the objects or data if successful. Otherwise, returns an error.</p>', 'refs' => [], ], 'AdvancedEventSelector' => [ 'base' => '<p>Advanced event selectors let you create fine-grained selectors for the following CloudTrail event record ﬁelds. They help you control costs by logging only those events that are important to you. For more information about advanced event selectors, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-data-events-with-cloudtrail.html">Logging data events for trails</a> in the <i>CloudTrail User Guide</i>.</p> <ul> <li> <p> <code>readOnly</code> </p> </li> <li> <p> <code>eventSource</code> </p> </li> <li> <p> <code>eventName</code> </p> </li> <li> <p> <code>eventCategory</code> </p> </li> <li> <p> <code>resources.type</code> </p> </li> <li> <p> <code>resources.ARN</code> </p> </li> </ul> <p>You cannot apply both event selectors and advanced event selectors to a trail.</p>', 'refs' => [ 'AdvancedEventSelectors$member' => NULL, ], ], 'AdvancedEventSelectors' => [ 'base' => NULL, 'refs' => [ 'GetEventSelectorsResponse$AdvancedEventSelectors' => '<p> The advanced event selectors that are configured for the trail. </p>', 'PutEventSelectorsRequest$AdvancedEventSelectors' => '<p> Specifies the settings for advanced event selectors. You can add advanced event selectors, and conditions for your advanced event selectors, up to a maximum of 500 values for all conditions and selectors on a trail. You can use either <code>AdvancedEventSelectors</code> or <code>EventSelectors</code>, but not both. If you apply <code>AdvancedEventSelectors</code> to a trail, any existing <code>EventSelectors</code> are overwritten. For more information about advanced event selectors, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-data-events-with-cloudtrail.html">Logging data events for trails</a> in the <i>CloudTrail User Guide</i>. </p>', 'PutEventSelectorsResponse$AdvancedEventSelectors' => '<p>Specifies the advanced event selectors configured for your trail.</p>', ], ], 'AdvancedFieldSelector' => [ 'base' => '<p>A single selector statement in an advanced event selector.</p>', 'refs' => [ 'AdvancedFieldSelectors$member' => NULL, ], ], 'AdvancedFieldSelectors' => [ 'base' => NULL, 'refs' => [ 'AdvancedEventSelector$FieldSelectors' => '<p>Contains all selector statements in an advanced event selector.</p>', ], ], 'Boolean' => [ 'base' => NULL, 'refs' => [ 'CreateTrailRequest$IncludeGlobalServiceEvents' => '<p>Specifies whether the trail is publishing events from global services such as IAM to the log files.</p>', 'CreateTrailRequest$IsMultiRegionTrail' => '<p>Specifies whether the trail is created in the current region or in all regions. The default is false, which creates a trail only in the region where you are signed in. As a best practice, consider creating trails that log events in all regions.</p>', 'CreateTrailRequest$EnableLogFileValidation' => '<p>Specifies whether log file integrity validation is enabled. The default is false.</p> <note> <p>When you disable log file integrity validation, the chain of digest files is broken after one hour. CloudTrail does not create digest files for log files that were delivered during a period in which log file integrity validation was disabled. For example, if you enable log file integrity validation at noon on January 1, disable it at noon on January 2, and re-enable it at noon on January 10, digest files will not be created for the log files delivered from noon on January 2 to noon on January 10. The same applies whenever you stop CloudTrail logging or delete a trail.</p> </note>', 'CreateTrailRequest$IsOrganizationTrail' => '<p>Specifies whether the trail is created for all accounts in an organization in Organizations, or only for the current Amazon Web Services account. The default is false, and cannot be true unless the call is made on behalf of an Amazon Web Services account that is the management account for an organization in Organizations.</p>', 'CreateTrailResponse$IncludeGlobalServiceEvents' => '<p>Specifies whether the trail is publishing events from global services such as IAM to the log files.</p>', 'CreateTrailResponse$IsMultiRegionTrail' => '<p>Specifies whether the trail exists in one region or in all regions.</p>', 'CreateTrailResponse$LogFileValidationEnabled' => '<p>Specifies whether log file integrity validation is enabled.</p>', 'CreateTrailResponse$IsOrganizationTrail' => '<p>Specifies whether the trail is an organization trail.</p>', 'DescribeTrailsRequest$includeShadowTrails' => '<p>Specifies whether to include shadow trails in the response. A shadow trail is the replication in a region of a trail that was created in a different region, or in the case of an organization trail, the replication of an organization trail in member accounts. If you do not include shadow trails, organization trails in a member account and region replication trails will not be returned. The default is true.</p>', 'EventSelector$IncludeManagementEvents' => '<p>Specify if you want your event selector to include management events for your trail.</p> <p> For more information, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-management-and-data-events-with-cloudtrail.html#logging-management-events">Management Events</a> in the <i>CloudTrail User Guide</i>.</p> <p>By default, the value is <code>true</code>.</p> <p>The first copy of management events is free. You are charged for additional copies of management events that you are logging on any subsequent trail in the same region. For more information about CloudTrail pricing, see <a href="http://aws.amazon.com/cloudtrail/pricing/">CloudTrail Pricing</a>.</p>', 'GetTrailStatusResponse$IsLogging' => '<p>Whether the CloudTrail trail is currently logging Amazon Web Services API calls.</p>', 'Trail$IncludeGlobalServiceEvents' => '<p>Set to <b>True</b> to include Amazon Web Services API calls from Amazon Web Services global services such as IAM. Otherwise, <b>False</b>.</p>', 'Trail$IsMultiRegionTrail' => '<p>Specifies whether the trail exists only in one region or exists in all regions.</p>', 'Trail$LogFileValidationEnabled' => '<p>Specifies whether log file validation is enabled.</p>', 'Trail$HasCustomEventSelectors' => '<p>Specifies if the trail has custom event selectors.</p>', 'Trail$HasInsightSelectors' => '<p>Specifies whether a trail has insight types specified in an <code>InsightSelector</code> list.</p>', 'Trail$IsOrganizationTrail' => '<p>Specifies whether the trail is an organization trail.</p>', 'UpdateTrailRequest$IncludeGlobalServiceEvents' => '<p>Specifies whether the trail is publishing events from global services such as IAM to the log files.</p>', 'UpdateTrailRequest$IsMultiRegionTrail' => '<p>Specifies whether the trail applies only to the current region or to all regions. The default is false. If the trail exists only in the current region and this value is set to true, shadow trails (replications of the trail) will be created in the other regions. If the trail exists in all regions and this value is set to false, the trail will remain in the region where it was created, and its shadow trails in other regions will be deleted. As a best practice, consider using trails that log events in all regions.</p>', 'UpdateTrailRequest$EnableLogFileValidation' => '<p>Specifies whether log file validation is enabled. The default is false.</p> <note> <p>When you disable log file integrity validation, the chain of digest files is broken after one hour. CloudTrail does not create digest files for log files that were delivered during a period in which log file integrity validation was disabled. For example, if you enable log file integrity validation at noon on January 1, disable it at noon on January 2, and re-enable it at noon on January 10, digest files will not be created for the log files delivered from noon on January 2 to noon on January 10. The same applies whenever you stop CloudTrail logging or delete a trail.</p> </note>', 'UpdateTrailRequest$IsOrganizationTrail' => '<p>Specifies whether the trail is applied to all accounts in an organization in Organizations, or only for the current Amazon Web Services account. The default is false, and cannot be true unless the call is made on behalf of an Amazon Web Services account that is the management account for an organization in Organizations. If the trail is not an organization trail and this is set to <code>true</code>, the trail will be created in all Amazon Web Services accounts that belong to the organization. If the trail is an organization trail and this is set to <code>false</code>, the trail will remain in the current Amazon Web Services account but be deleted from all member accounts in the organization.</p>', 'UpdateTrailResponse$IncludeGlobalServiceEvents' => '<p>Specifies whether the trail is publishing events from global services such as IAM to the log files.</p>', 'UpdateTrailResponse$IsMultiRegionTrail' => '<p>Specifies whether the trail exists in one region or in all regions.</p>', 'UpdateTrailResponse$LogFileValidationEnabled' => '<p>Specifies whether log file integrity validation is enabled.</p>', 'UpdateTrailResponse$IsOrganizationTrail' => '<p>Specifies whether the trail is an organization trail.</p>', ], ], 'ByteBuffer' => [ 'base' => NULL, 'refs' => [ 'PublicKey$Value' => '<p>The DER encoded public key value in PKCS#1 format.</p>', ], ], 'CloudTrailARNInvalidException' => [ 'base' => '<p>This exception is thrown when an operation is called with a trail ARN that is not valid. The following is the format of a trail ARN.</p> <p> <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code> </p>', 'refs' => [], ], 'CloudTrailAccessNotEnabledException' => [ 'base' => '<p>This exception is thrown when trusted access has not been enabled between CloudTrail and Organizations. For more information, see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_integrate_services.html">Enabling Trusted Access with Other Amazon Web Services Services</a> and <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/creating-an-organizational-trail-prepare.html">Prepare For Creating a Trail For Your Organization</a>. </p>', 'refs' => [], ], 'CloudTrailInvalidClientTokenIdException' => [ 'base' => '<p>This exception is thrown when a call results in the <code>InvalidClientTokenId</code> error code. This can occur when you are creating or updating a trail to send notifications to an Amazon SNS topic that is in a suspended Amazon Web Services account.</p>', 'refs' => [], ], 'CloudWatchLogsDeliveryUnavailableException' => [ 'base' => '<p>Cannot set a CloudWatch Logs delivery for this region.</p>', 'refs' => [], ], 'ConflictException' => [ 'base' => '<p>This exception is thrown when the specified resource is not ready for an operation. This can occur when you try to run an operation on a trail before CloudTrail has time to fully load the trail. If this exception occurs, wait a few minutes, and then try the operation again.</p>', 'refs' => [], ], 'CreateTrailRequest' => [ 'base' => '<p>Specifies the settings for each trail.</p>', 'refs' => [], ], 'CreateTrailResponse' => [ 'base' => '<p>Returns the objects or data listed below if successful. Otherwise, returns an error.</p>', 'refs' => [], ], 'DataResource' => [ 'base' => '<p>The Amazon S3 buckets, Lambda functions, or Amazon DynamoDB tables that you specify in your event selectors for your trail to log data events. Data events provide information about the resource operations performed on or within a resource itself. These are also known as data plane operations. You can specify up to 250 data resources for a trail.</p> <note> <p>The total number of allowed data resources is 250. This number can be distributed between 1 and 5 event selectors, but the total cannot exceed 250 across all selectors.</p> <p>If you are using advanced event selectors, the maximum total number of values for all conditions, across all advanced event selectors for the trail, is 500.</p> </note> <p>The following example demonstrates how logging works when you configure logging of all data events for an S3 bucket named <code>bucket-1</code>. In this example, the CloudTrail user specified an empty prefix, and the option to log both <code>Read</code> and <code>Write</code> data events.</p> <ol> <li> <p>A user uploads an image file to <code>bucket-1</code>.</p> </li> <li> <p>The <code>PutObject</code> API operation is an Amazon S3 object-level API. It is recorded as a data event in CloudTrail. Because the CloudTrail user specified an S3 bucket with an empty prefix, events that occur on any object in that bucket are logged. The trail processes and logs the event.</p> </li> <li> <p>A user uploads an object to an Amazon S3 bucket named <code>arn:aws:s3:::bucket-2</code>.</p> </li> <li> <p>The <code>PutObject</code> API operation occurred for an object in an S3 bucket that the CloudTrail user didn\'t specify for the trail. The trail doesn’t log the event.</p> </li> </ol> <p>The following example demonstrates how logging works when you configure logging of Lambda data events for a Lambda function named <i>MyLambdaFunction</i>, but not for all Lambda functions.</p> <ol> <li> <p>A user runs a script that includes a call to the <i>MyLambdaFunction</i> function and the <i>MyOtherLambdaFunction</i> function.</p> </li> <li> <p>The <code>Invoke</code> API operation on <i>MyLambdaFunction</i> is an Lambda API. It is recorded as a data event in CloudTrail. Because the CloudTrail user specified logging data events for <i>MyLambdaFunction</i>, any invocations of that function are logged. The trail processes and logs the event.</p> </li> <li> <p>The <code>Invoke</code> API operation on <i>MyOtherLambdaFunction</i> is an Lambda API. Because the CloudTrail user did not specify logging data events for all Lambda functions, the <code>Invoke</code> operation for <i>MyOtherLambdaFunction</i> does not match the function specified for the trail. The trail doesn’t log the event. </p> </li> </ol>', 'refs' => [ 'DataResources$member' => NULL, ], ], 'DataResourceValues' => [ 'base' => NULL, 'refs' => [ 'DataResource$Values' => '<p>An array of Amazon Resource Name (ARN) strings or partial ARN strings for the specified objects.</p> <ul> <li> <p>To log data events for all objects in all S3 buckets in your Amazon Web Services account, specify the prefix as <code>arn:aws:s3:::</code>.</p> <note> <p>This also enables logging of data event activity performed by any user or role in your Amazon Web Services account, even if that activity is performed on a bucket that belongs to another Amazon Web Services account.</p> </note> </li> <li> <p>To log data events for all objects in an S3 bucket, specify the bucket and an empty object prefix such as <code>arn:aws:s3:::bucket-1/</code>. The trail logs data events for all objects in this S3 bucket.</p> </li> <li> <p>To log data events for specific objects, specify the S3 bucket and object prefix such as <code>arn:aws:s3:::bucket-1/example-images</code>. The trail logs data events for objects in this S3 bucket that match the prefix.</p> </li> <li> <p>To log data events for all Lambda functions in your Amazon Web Services account, specify the prefix as <code>arn:aws:lambda</code>.</p> <note> <p>This also enables logging of <code>Invoke</code> activity performed by any user or role in your Amazon Web Services account, even if that activity is performed on a function that belongs to another Amazon Web Services account. </p> </note> </li> <li> <p>To log data events for a specific Lambda function, specify the function ARN.</p> <note> <p>Lambda function ARNs are exact. For example, if you specify a function ARN <i>arn:aws:lambda:us-west-2:111111111111:function:helloworld</i>, data events will only be logged for <i>arn:aws:lambda:us-west-2:111111111111:function:helloworld</i>. They will not be logged for <i>arn:aws:lambda:us-west-2:111111111111:function:helloworld2</i>.</p> </note> </li> <li> <p>To log data events for all DynamoDB tables in your Amazon Web Services account, specify the prefix as <code>arn:aws:dynamodb</code>.</p> </li> </ul>', ], ], 'DataResources' => [ 'base' => NULL, 'refs' => [ 'EventSelector$DataResources' => '<p>CloudTrail supports data event logging for Amazon S3 objects, Lambda functions, and Amazon DynamoDB tables with basic event selectors. You can specify up to 250 resources for an individual event selector, but the total number of data resources cannot exceed 250 across all event selectors in a trail. This limit does not apply if you configure resource logging for all data events.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-management-and-data-events-with-cloudtrail.html#logging-data-events">Data Events</a> and <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/WhatIsCloudTrail-Limits.html">Limits in CloudTrail</a> in the <i>CloudTrail User Guide</i>.</p>', ], ], 'Date' => [ 'base' => NULL, 'refs' => [ 'Event$EventTime' => '<p>The date and time of the event returned.</p>', 'GetTrailStatusResponse$LatestDeliveryTime' => '<p>Specifies the date and time that CloudTrail last delivered log files to an account\'s Amazon S3 bucket.</p>', 'GetTrailStatusResponse$LatestNotificationTime' => '<p>Specifies the date and time of the most recent Amazon SNS notification that CloudTrail has written a new log file to an account\'s Amazon S3 bucket.</p>', 'GetTrailStatusResponse$StartLoggingTime' => '<p>Specifies the most recent date and time when CloudTrail started recording API calls for an Amazon Web Services account.</p>', 'GetTrailStatusResponse$StopLoggingTime' => '<p>Specifies the most recent date and time when CloudTrail stopped recording API calls for an Amazon Web Services account.</p>', 'GetTrailStatusResponse$LatestCloudWatchLogsDeliveryTime' => '<p>Displays the most recent date and time when CloudTrail delivered logs to CloudWatch Logs.</p>', 'GetTrailStatusResponse$LatestDigestDeliveryTime' => '<p>Specifies the date and time that CloudTrail last delivered a digest file to an account\'s Amazon S3 bucket.</p>', 'ListPublicKeysRequest$StartTime' => '<p>Optionally specifies, in UTC, the start of the time range to look up public keys for CloudTrail digest files. If not specified, the current time is used, and the current public key is returned.</p>', 'ListPublicKeysRequest$EndTime' => '<p>Optionally specifies, in UTC, the end of the time range to look up public keys for CloudTrail digest files. If not specified, the current time is used.</p>', 'LookupEventsRequest$StartTime' => '<p>Specifies that only events that occur after or at the specified time are returned. If the specified start time is after the specified end time, an error is returned.</p>', 'LookupEventsRequest$EndTime' => '<p>Specifies that only events that occur before or at the specified time are returned. If the specified end time is before the specified start time, an error is returned.</p>', 'PublicKey$ValidityStartTime' => '<p>The starting time of validity of the public key.</p>', 'PublicKey$ValidityEndTime' => '<p>The ending time of validity of the public key.</p>', ], ], 'DeleteTrailRequest' => [ 'base' => '<p>The request that specifies the name of a trail to delete.</p>', 'refs' => [], ], 'DeleteTrailResponse' => [ 'base' => '<p>Returns the objects or data listed below if successful. Otherwise, returns an error.</p>', 'refs' => [], ], 'DescribeTrailsRequest' => [ 'base' => '<p>Returns information about the trail.</p>', 'refs' => [], ], 'DescribeTrailsResponse' => [ 'base' => '<p>Returns the objects or data listed below if successful. Otherwise, returns an error.</p>', 'refs' => [], ], 'Event' => [ 'base' => '<p>Contains information about an event that was returned by a lookup request. The result includes a representation of a CloudTrail event.</p>', 'refs' => [ 'EventsList$member' => NULL, ], ], 'EventCategory' => [ 'base' => NULL, 'refs' => [ 'LookupEventsRequest$EventCategory' => '<p>Specifies the event category. If you do not specify an event category, events of the category are not returned in the response. For example, if you do not specify <code>insight</code> as the value of <code>EventCategory</code>, no Insights events are returned.</p>', ], ], 'EventSelector' => [ 'base' => '<p>Use event selectors to further specify the management and data event settings for your trail. By default, trails created without specific event selectors will be configured to log all read and write management events, and no data events. When an event occurs in your account, CloudTrail evaluates the event selector for all trails. For each trail, if the event matches any event selector, the trail processes and logs the event. If the event doesn\'t match any event selector, the trail doesn\'t log the event.</p> <p>You can configure up to five event selectors for a trail.</p> <p>You cannot apply both event selectors and advanced event selectors to a trail.</p>', 'refs' => [ 'EventSelectors$member' => NULL, ], ], 'EventSelectors' => [ 'base' => NULL, 'refs' => [ 'GetEventSelectorsResponse$EventSelectors' => '<p>The event selectors that are configured for the trail.</p>', 'PutEventSelectorsRequest$EventSelectors' => '<p>Specifies the settings for your event selectors. You can configure up to five event selectors for a trail. You can use either <code>EventSelectors</code> or <code>AdvancedEventSelectors</code> in a <code>PutEventSelectors</code> request, but not both. If you apply <code>EventSelectors</code> to a trail, any existing <code>AdvancedEventSelectors</code> are overwritten.</p>', 'PutEventSelectorsResponse$EventSelectors' => '<p>Specifies the event selectors configured for your trail.</p>', ], ], 'EventsList' => [ 'base' => NULL, 'refs' => [ 'LookupEventsResponse$Events' => '<p>A list of events returned based on the lookup attributes specified and the CloudTrail event. The events list is sorted by time. The most recent event is listed first.</p>', ], ], 'ExcludeManagementEventSources' => [ 'base' => NULL, 'refs' => [ 'EventSelector$ExcludeManagementEventSources' => '<p>An optional list of service event sources from which you do not want management events to be logged on your trail. In this release, the list can be empty (disables the filter), or it can filter out Key Management Service or Amazon RDS Data API events by containing <code>kms.amazonaws.com</code> or <code>rdsdata.amazonaws.com</code>. By default, <code>ExcludeManagementEventSources</code> is empty, and KMS and Amazon RDS Data API events are logged to your trail.</p>', ], ], 'GetEventSelectorsRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetEventSelectorsResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetInsightSelectorsRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetInsightSelectorsResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetTrailRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetTrailResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetTrailStatusRequest' => [ 'base' => '<p>The name of a trail about which you want the current status.</p>', 'refs' => [], ], 'GetTrailStatusResponse' => [ 'base' => '<p>Returns the objects or data listed below if successful. Otherwise, returns an error.</p>', 'refs' => [], ], 'InsightNotEnabledException' => [ 'base' => '<p>If you run <code>GetInsightSelectors</code> on a trail that does not have Insights events enabled, the operation throws the exception <code>InsightNotEnabledException</code>.</p>', 'refs' => [], ], 'InsightSelector' => [ 'base' => '<p>A JSON string that contains a list of insight types that are logged on a trail.</p>', 'refs' => [ 'InsightSelectors$member' => NULL, ], ], 'InsightSelectors' => [ 'base' => NULL, 'refs' => [ 'GetInsightSelectorsResponse$InsightSelectors' => '<p>A JSON string that contains the insight types you want to log on a trail. In this release, only <code>ApiCallRateInsight</code> is supported as an insight type.</p>', 'PutInsightSelectorsRequest$InsightSelectors' => '<p>A JSON string that contains the Insights types that you want to log on a trail. The valid Insights type in this release is <code>ApiCallRateInsight</code>.</p>', 'PutInsightSelectorsResponse$InsightSelectors' => '<p>A JSON string that contains the Insights event types that you want to log on a trail. The valid Insights type in this release is <code>ApiCallRateInsight</code>.</p>', ], ], 'InsightType' => [ 'base' => NULL, 'refs' => [ 'InsightSelector$InsightType' => '<p>The type of Insights events to log on a trail. The valid Insights type in this release is <code>ApiCallRateInsight</code>.</p>', ], ], 'InsufficientDependencyServiceAccessPermissionException' => [ 'base' => '<p>This exception is thrown when the IAM user or role that is used to create the organization trail is lacking one or more required permissions for creating an organization trail in a required service. For more information, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/creating-an-organizational-trail-prepare.html">Prepare For Creating a Trail For Your Organization</a>.</p>', 'refs' => [], ], 'InsufficientEncryptionPolicyException' => [ 'base' => '<p>This exception is thrown when the policy on the S3 bucket or KMS key is not sufficient.</p>', 'refs' => [], ], 'InsufficientS3BucketPolicyException' => [ 'base' => '<p>This exception is thrown when the policy on the S3 bucket is not sufficient.</p>', 'refs' => [], ], 'InsufficientSnsTopicPolicyException' => [ 'base' => '<p>This exception is thrown when the policy on the Amazon SNS topic is not sufficient.</p>', 'refs' => [], ], 'InvalidCloudWatchLogsLogGroupArnException' => [ 'base' => '<p>This exception is thrown when the provided CloudWatch Logs log group is not valid.</p>', 'refs' => [], ], 'InvalidCloudWatchLogsRoleArnException' => [ 'base' => '<p>This exception is thrown when the provided role is not valid.</p>', 'refs' => [], ], 'InvalidEventCategoryException' => [ 'base' => '<p>Occurs if an event category that is not valid is specified as a value of <code>EventCategory</code>.</p>', 'refs' => [], ], 'InvalidEventSelectorsException' => [ 'base' => '<p>This exception is thrown when the <code>PutEventSelectors</code> operation is called with a number of event selectors, advanced event selectors, or data resources that is not valid. The combination of event selectors or advanced event selectors and data resources is not valid. A trail can have up to 5 event selectors. If a trail uses advanced event selectors, a maximum of 500 total values for all conditions in all advanced event selectors is allowed. A trail is limited to 250 data resources. These data resources can be distributed across event selectors, but the overall total cannot exceed 250.</p> <p>You can:</p> <ul> <li> <p>Specify a valid number of event selectors (1 to 5) for a trail.</p> </li> <li> <p>Specify a valid number of data resources (1 to 250) for an event selector. The limit of number of resources on an individual event selector is configurable up to 250. However, this upper limit is allowed only if the total number of data resources does not exceed 250 across all event selectors for a trail.</p> </li> <li> <p>Specify up to 500 values for all conditions in all advanced event selectors for a trail.</p> </li> <li> <p>Specify a valid value for a parameter. For example, specifying the <code>ReadWriteType</code> parameter with a value of <code>read-only</code> is not valid.</p> </li> </ul>', 'refs' => [], ], 'InvalidHomeRegionException' => [ 'base' => '<p>This exception is thrown when an operation is called on a trail from a region other than the region in which the trail was created.</p>', 'refs' => [], ], 'InvalidInsightSelectorsException' => [ 'base' => '<p>The formatting or syntax of the <code>InsightSelectors</code> JSON statement in your <code>PutInsightSelectors</code> or <code>GetInsightSelectors</code> request is not valid, or the specified insight type in the <code>InsightSelectors</code> statement is not a valid insight type.</p>', 'refs' => [], ], 'InvalidKmsKeyIdException' => [ 'base' => '<p>This exception is thrown when the KMS key ARN is not valid.</p>', 'refs' => [], ], 'InvalidLookupAttributesException' => [ 'base' => '<p>Occurs when a lookup attribute is specified that is not valid.</p>', 'refs' => [], ], 'InvalidMaxResultsException' => [ 'base' => '<p>This exception is thrown if the limit specified is not valid.</p>', 'refs' => [], ], 'InvalidNextTokenException' => [ 'base' => '<p>A token that is not valid, or a token that was previously used in a request with different parameters. This exception is thrown if the token is not valid.</p>', 'refs' => [], ], 'InvalidParameterCombinationException' => [ 'base' => '<p>This exception is thrown when the combination of parameters provided is not valid.</p>', 'refs' => [], ], 'InvalidS3BucketNameException' => [ 'base' => '<p>This exception is thrown when the provided S3 bucket name is not valid.</p>', 'refs' => [], ], 'InvalidS3PrefixException' => [ 'base' => '<p>This exception is thrown when the provided S3 prefix is not valid.</p>', 'refs' => [], ], 'InvalidSnsTopicNameException' => [ 'base' => '<p>This exception is thrown when the provided SNS topic name is not valid.</p>', 'refs' => [], ], 'InvalidTagParameterException' => [ 'base' => '<p>This exception is thrown when the specified tag key or values are not valid. It can also occur if there are duplicate tags or too many tags on the resource.</p>', 'refs' => [], ], 'InvalidTimeRangeException' => [ 'base' => '<p>Occurs if the timestamp values are not valid. Either the start time occurs after the end time, or the time range is outside the range of possible values.</p>', 'refs' => [], ], 'InvalidTokenException' => [ 'base' => '<p>Reserved for future use.</p>', 'refs' => [], ], 'InvalidTrailNameException' => [ 'base' => '<p>This exception is thrown when the provided trail name is not valid. Trail names must meet the following requirements:</p> <ul> <li> <p>Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores (_), or dashes (-)</p> </li> <li> <p>Start with a letter or number, and end with a letter or number</p> </li> <li> <p>Be between 3 and 128 characters</p> </li> <li> <p>Have no adjacent periods, underscores or dashes. Names like <code>my-_namespace</code> and <code>my--namespace</code> are not valid.</p> </li> <li> <p>Not be in IP address format (for example, 192.168.5.4)</p> </li> </ul>', 'refs' => [], ], 'KmsException' => [ 'base' => '<p>This exception is thrown when there is an issue with the specified KMS key and the trail can’t be updated.</p>', 'refs' => [], ], 'KmsKeyDisabledException' => [ 'base' => '<p>This exception is no longer in use.</p>', 'refs' => [], ], 'KmsKeyNotFoundException' => [ 'base' => '<p>This exception is thrown when the KMS key does not exist, when the S3 bucket and the KMS key are not in the same region, or when the KMS key associated with the Amazon SNS topic either does not exist or is not in the same region.</p>', 'refs' => [], ], 'ListPublicKeysRequest' => [ 'base' => '<p>Requests the public keys for a specified time range.</p>', 'refs' => [], ], 'ListPublicKeysResponse' => [ 'base' => '<p>Returns the objects or data listed below if successful. Otherwise, returns an error.</p>', 'refs' => [], ], 'ListTagsRequest' => [ 'base' => '<p>Specifies a list of trail tags to return.</p>', 'refs' => [], ], 'ListTagsResponse' => [ 'base' => '<p>Returns the objects or data listed below if successful. Otherwise, returns an error.</p>', 'refs' => [], ], 'ListTrailsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTrailsResponse' => [ 'base' => NULL, 'refs' => [], ], 'LookupAttribute' => [ 'base' => '<p>Specifies an attribute and value that filter the events returned.</p>', 'refs' => [ 'LookupAttributesList$member' => NULL, ], ], 'LookupAttributeKey' => [ 'base' => NULL, 'refs' => [ 'LookupAttribute$AttributeKey' => '<p>Specifies an attribute on which to filter the events returned.</p>', ], ], 'LookupAttributesList' => [ 'base' => NULL, 'refs' => [ 'LookupEventsRequest$LookupAttributes' => '<p>Contains a list of lookup attributes. Currently the list can contain only one item.</p>', ], ], 'LookupEventsRequest' => [ 'base' => '<p>Contains a request for LookupEvents.</p>', 'refs' => [], ], 'LookupEventsResponse' => [ 'base' => '<p>Contains a response to a LookupEvents action.</p>', 'refs' => [], ], 'MaxResults' => [ 'base' => NULL, 'refs' => [ 'LookupEventsRequest$MaxResults' => '<p>The number of events to return. Possible values are 1 through 50. The default is 50.</p>', ], ], 'MaximumNumberOfTrailsExceededException' => [ 'base' => '<p>This exception is thrown when the maximum number of trails is reached.</p>', 'refs' => [], ], 'NextToken' => [ 'base' => NULL, 'refs' => [ 'LookupEventsRequest$NextToken' => '<p>The token to use to get the next page of results after a previous API call. This token must be passed in with the same parameters that were specified in the the original call. For example, if the original call specified an AttributeKey of \'Username\' with a value of \'root\', the call with NextToken should include those same parameters.</p>', 'LookupEventsResponse$NextToken' => '<p>The token to use to get the next page of results after a previous API call. If the token does not appear, there are no more results to return. The token must be passed in with the same parameters as the previous call. For example, if the original call specified an AttributeKey of \'Username\' with a value of \'root\', the call with NextToken should include those same parameters.</p>', ], ], 'NotOrganizationMasterAccountException' => [ 'base' => '<p>This exception is thrown when the Amazon Web Services account making the request to create or update an organization trail is not the management account for an organization in Organizations. For more information, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/creating-an-organizational-trail-prepare.html">Prepare For Creating a Trail For Your Organization</a>.</p>', 'refs' => [], ], 'OperationNotPermittedException' => [ 'base' => '<p>This exception is thrown when the requested operation is not permitted.</p>', 'refs' => [], ], 'Operator' => [ 'base' => NULL, 'refs' => [ 'AdvancedFieldSelector$Equals' => '<p> An operator that includes events that match the exact value of the event record field specified as the value of <code>Field</code>. This is the only valid operator that you can use with the <code>readOnly</code>, <code>eventCategory</code>, and <code>resources.type</code> fields.</p>', 'AdvancedFieldSelector$StartsWith' => '<p>An operator that includes events that match the first few characters of the event record field specified as the value of <code>Field</code>.</p>', 'AdvancedFieldSelector$EndsWith' => '<p>An operator that includes events that match the last few characters of the event record field specified as the value of <code>Field</code>.</p>', 'AdvancedFieldSelector$NotEquals' => '<p> An operator that excludes events that match the exact value of the event record field specified as the value of <code>Field</code>. </p>', 'AdvancedFieldSelector$NotStartsWith' => '<p> An operator that excludes events that match the first few characters of the event record field specified as the value of <code>Field</code>. </p>', 'AdvancedFieldSelector$NotEndsWith' => '<p> An operator that excludes events that match the last few characters of the event record field specified as the value of <code>Field</code>. </p>', ], ], 'OperatorValue' => [ 'base' => NULL, 'refs' => [ 'Operator$member' => NULL, ], ], 'OrganizationNotInAllFeaturesModeException' => [ 'base' => '<p>This exception is thrown when Organizations is not configured to support all features. All features must be enabled in Organizations to support creating an organization trail. For more information, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/creating-an-organizational-trail-prepare.html">Prepare For Creating a Trail For Your Organization</a>.</p>', 'refs' => [], ], 'OrganizationsNotInUseException' => [ 'base' => '<p>This exception is thrown when the request is made from an Amazon Web Services account that is not a member of an organization. To make this request, sign in using the credentials of an account that belongs to an organization.</p>', 'refs' => [], ], 'PublicKey' => [ 'base' => '<p>Contains information about a returned public key.</p>', 'refs' => [ 'PublicKeyList$member' => NULL, ], ], 'PublicKeyList' => [ 'base' => NULL, 'refs' => [ 'ListPublicKeysResponse$PublicKeyList' => '<p>Contains an array of PublicKey objects.</p> <note> <p>The returned public keys may have validity time ranges that overlap.</p> </note>', ], ], 'PutEventSelectorsRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutEventSelectorsResponse' => [ 'base' => NULL, 'refs' => [], ], 'PutInsightSelectorsRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutInsightSelectorsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ReadWriteType' => [ 'base' => NULL, 'refs' => [ 'EventSelector$ReadWriteType' => '<p>Specify if you want your trail to log read-only events, write-only events, or all. For example, the EC2 <code>GetConsoleOutput</code> is a read-only API operation and <code>RunInstances</code> is a write-only API operation.</p> <p> By default, the value is <code>All</code>.</p>', ], ], 'RemoveTagsRequest' => [ 'base' => '<p>Specifies the tags to remove from a trail.</p>', 'refs' => [], ], 'RemoveTagsResponse' => [ 'base' => '<p>Returns the objects or data listed below if successful. Otherwise, returns an error.</p>', 'refs' => [], ], 'Resource' => [ 'base' => '<p>Specifies the type and name of a resource referenced by an event.</p>', 'refs' => [ 'ResourceList$member' => NULL, ], ], 'ResourceIdList' => [ 'base' => NULL, 'refs' => [ 'ListTagsRequest$ResourceIdList' => '<p>Specifies a list of trail ARNs whose tags will be listed. The list has a limit of 20 ARNs. The following is the format of a trail ARN.</p> <p> <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code> </p>', ], ], 'ResourceList' => [ 'base' => '<p>A list of resources referenced by the event returned.</p>', 'refs' => [ 'Event$Resources' => '<p>A list of resources referenced by the event returned.</p>', ], ], 'ResourceNotFoundException' => [ 'base' => '<p>This exception is thrown when the specified resource is not found.</p>', 'refs' => [], ], 'ResourceTag' => [ 'base' => '<p>A resource tag.</p>', 'refs' => [ 'ResourceTagList$member' => NULL, ], ], 'ResourceTagList' => [ 'base' => NULL, 'refs' => [ 'ListTagsResponse$ResourceTagList' => '<p>A list of resource tags.</p>', ], ], 'ResourceTypeNotSupportedException' => [ 'base' => '<p>This exception is thrown when the specified resource type is not supported by CloudTrail.</p>', 'refs' => [], ], 'S3BucketDoesNotExistException' => [ 'base' => '<p>This exception is thrown when the specified S3 bucket does not exist.</p>', 'refs' => [], ], 'SelectorField' => [ 'base' => NULL, 'refs' => [ 'AdvancedFieldSelector$Field' => '<p> A field in an event record on which to filter events to be logged. Supported fields include <code>readOnly</code>, <code>eventCategory</code>, <code>eventSource</code> (for management events), <code>eventName</code>, <code>resources.type</code>, and <code>resources.ARN</code>. </p> <ul> <li> <p> <b> <code>readOnly</code> </b> - Optional. Can be set to <code>Equals</code> a value of <code>true</code> or <code>false</code>. A value of <code>false</code> logs both <code>read</code> and <code>write</code> events.</p> </li> <li> <p> <b> <code>eventSource</code> </b> - For filtering management events only. This can be set only to <code>NotEquals</code> <code>kms.amazonaws.com</code>.</p> </li> <li> <p> <b> <code>eventName</code> </b> - Can use any operator. You can use it to ﬁlter in or ﬁlter out any data event logged to CloudTrail, such as <code>PutBucket</code> or <code>GetSnapshotBlock</code>. You can have multiple values for this ﬁeld, separated by commas.</p> </li> <li> <p> <b> <code>eventCategory</code> </b> - This is required. It must be set to <code>Equals</code>, and the value must be <code>Management</code> or <code>Data</code>.</p> </li> <li> <p> <b> <code>resources.type</code> </b> - This ﬁeld is required. <code>resources.type</code> can only use the <code>Equals</code> operator, and the value can be one of the following:</p> <ul> <li> <p> <code>AWS::S3::Object</code> </p> </li> <li> <p> <code>AWS::Lambda::Function</code> </p> </li> <li> <p> <code>AWS::DynamoDB::Table</code> </p> </li> <li> <p> <code>AWS::S3Outposts::Object</code> </p> </li> <li> <p> <code>AWS::ManagedBlockchain::Node</code> </p> </li> <li> <p> <code>AWS::S3ObjectLambda::AccessPoint</code> </p> </li> <li> <p> <code>AWS::EC2::Snapshot</code> </p> </li> <li> <p> <code>AWS::S3::AccessPoint</code> </p> </li> <li> <p> <code>AWS::DynamoDB::Stream</code> </p> </li> </ul> <p> You can have only one <code>resources.type</code> ﬁeld per selector. To log data events on more than one resource type, add another selector.</p> </li> <li> <p> <b> <code>resources.ARN</code> </b> - You can use any operator with <code>resources.ARN</code>, but if you use <code>Equals</code> or <code>NotEquals</code>, the value must exactly match the ARN of a valid resource of the type you\'ve speciﬁed in the template as the value of resources.type. For example, if resources.type equals <code>AWS::S3::Object</code>, the ARN must be in one of the following formats. To log all data events for all objects in a specific S3 bucket, use the <code>StartsWith</code> operator, and include only the bucket ARN as the matching value.</p> <p>The trailing slash is intentional; do not exclude it. Replace the text between less than and greater than symbols (&lt;&gt;) with resource-specific information. </p> <ul> <li> <p> <code>arn:&lt;partition&gt;:s3:::&lt;bucket_name&gt;/</code> </p> </li> <li> <p> <code>arn:&lt;partition&gt;:s3:::&lt;bucket_name&gt;/&lt;object_path&gt;/</code> </p> </li> </ul> <p>When <code>resources.type</code> equals <code>AWS::S3::AccessPoint</code>, and the operator is set to <code>Equals</code> or <code>NotEquals</code>, the ARN must be in one of the following formats. To log events on all objects in an S3 access point, we recommend that you use only the access point ARN, don’t include the object path, and use the <code>StartsWith</code> or <code>NotStartsWith</code> operators.</p> <ul> <li> <p> <code>arn:&lt;partition&gt;:s3:&lt;region&gt;:&lt;account_ID&gt;:accesspoint/&lt;access_point_name&gt;</code> </p> </li> <li> <p> <code>arn:&lt;partition&gt;:s3:&lt;region&gt;:&lt;account_ID&gt;:accesspoint/&lt;access_point_name&gt;/object/&lt;object_path&gt;</code> </p> </li> </ul> <p>When resources.type equals <code>AWS::Lambda::Function</code>, and the operator is set to <code>Equals</code> or <code>NotEquals</code>, the ARN must be in the following format:</p> <ul> <li> <p> <code>arn:&lt;partition&gt;:lambda:&lt;region&gt;:&lt;account_ID&gt;:function:&lt;function_name&gt;</code> </p> </li> </ul> <p>When resources.type equals <code>AWS::DynamoDB::Table</code>, and the operator is set to <code>Equals</code> or <code>NotEquals</code>, the ARN must be in the following format:</p> <ul> <li> <p> <code>arn:&lt;partition&gt;:dynamodb:&lt;region&gt;:&lt;account_ID&gt;:table/&lt;table_name&gt;</code> </p> </li> </ul> <p>When <code>resources.type</code> equals <code>AWS::S3Outposts::Object</code>, and the operator is set to <code>Equals</code> or <code>NotEquals</code>, the ARN must be in the following format:</p> <ul> <li> <p> <code>arn:&lt;partition&gt;:s3-outposts:&lt;region&gt;:&lt;account_ID&gt;:&lt;object_path&gt;</code> </p> </li> </ul> <p>When <code>resources.type</code> equals <code>AWS::ManagedBlockchain::Node</code>, and the operator is set to <code>Equals</code> or <code>NotEquals</code>, the ARN must be in the following format:</p> <ul> <li> <p> <code>arn:&lt;partition&gt;:managedblockchain:&lt;region&gt;:&lt;account_ID&gt;:nodes/&lt;node_ID&gt;</code> </p> </li> </ul> <p>When <code>resources.type</code> equals <code>AWS::S3ObjectLambda::AccessPoint</code>, and the operator is set to <code>Equals</code> or <code>NotEquals</code>, the ARN must be in the following format:</p> <ul> <li> <p> <code>arn:&lt;partition&gt;:s3-object-lambda:&lt;region&gt;:&lt;account_ID&gt;:accesspoint/&lt;access_point_name&gt;</code> </p> </li> </ul> <p>When <code>resources.type</code> equals <code>AWS::EC2::Snapshot</code>, and the operator is set to <code>Equals</code> or <code>NotEquals</code>, the ARN must be in the following format:</p> <ul> <li> <p> <code>arn:&lt;partition&gt;:ec2:&lt;region&gt;::snapshot/&lt;snapshot_ID&gt;</code> </p> </li> </ul> <p>When <code>resources.type</code> equals <code>AWS::DynamoDB::Stream</code>, and the operator is set to <code>Equals</code> or <code>NotEquals</code>, the ARN must be in the following format:</p> <ul> <li> <p> <code>arn:&lt;partition&gt;:dynamodb:&lt;region&gt;:&lt;account_ID&gt;:table/&lt;table_name&gt;/stream/&lt;date_time&gt;</code> </p> </li> </ul> </li> </ul>', ], ], 'SelectorName' => [ 'base' => NULL, 'refs' => [ 'AdvancedEventSelector$Name' => '<p>An optional, descriptive name for an advanced event selector, such as "Log data events for only two S3 buckets".</p>', ], ], 'StartLoggingRequest' => [ 'base' => '<p>The request to CloudTrail to start logging Amazon Web Services API calls for an account.</p>', 'refs' => [], ], 'StartLoggingResponse' => [ 'base' => '<p>Returns the objects or data listed below if successful. Otherwise, returns an error.</p>', 'refs' => [], ], 'StopLoggingRequest' => [ 'base' => '<p>Passes the request to CloudTrail to stop logging Amazon Web Services API calls for the specified account.</p>', 'refs' => [], ], 'StopLoggingResponse' => [ 'base' => '<p>Returns the objects or data listed below if successful. Otherwise, returns an error.</p>', 'refs' => [], ], 'String' => [ 'base' => NULL, 'refs' => [ 'AddTagsRequest$ResourceId' => '<p>Specifies the ARN of the trail to which one or more tags will be added. The format of a trail ARN is:</p> <p> <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code> </p>', 'CreateTrailRequest$Name' => '<p>Specifies the name of the trail. The name must meet the following requirements:</p> <ul> <li> <p>Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores (_), or dashes (-)</p> </li> <li> <p>Start with a letter or number, and end with a letter or number</p> </li> <li> <p>Be between 3 and 128 characters</p> </li> <li> <p>Have no adjacent periods, underscores or dashes. Names like <code>my-_namespace</code> and <code>my--namespace</code> are not valid.</p> </li> <li> <p>Not be in IP address format (for example, 192.168.5.4)</p> </li> </ul>', 'CreateTrailRequest$S3BucketName' => '<p>Specifies the name of the Amazon S3 bucket designated for publishing log files. See <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/create_trail_naming_policy.html">Amazon S3 Bucket Naming Requirements</a>.</p>', 'CreateTrailRequest$S3KeyPrefix' => '<p>Specifies the Amazon S3 key prefix that comes after the name of the bucket you have designated for log file delivery. For more information, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-find-log-files.html">Finding Your CloudTrail Log Files</a>. The maximum length is 200 characters.</p>', 'CreateTrailRequest$SnsTopicName' => '<p>Specifies the name of the Amazon SNS topic defined for notification of log file delivery. The maximum length is 256 characters.</p>', 'CreateTrailRequest$CloudWatchLogsLogGroupArn' => '<p>Specifies a log group name using an Amazon Resource Name (ARN), a unique identifier that represents the log group to which CloudTrail logs will be delivered. Not required unless you specify <code>CloudWatchLogsRoleArn</code>.</p>', 'CreateTrailRequest$CloudWatchLogsRoleArn' => '<p>Specifies the role for the CloudWatch Logs endpoint to assume to write to a user\'s log group.</p>', 'CreateTrailRequest$KmsKeyId' => '<p>Specifies the KMS key ID to use to encrypt the logs delivered by CloudTrail. The value can be an alias name prefixed by "alias/", a fully specified ARN to an alias, a fully specified ARN to a key, or a globally unique identifier.</p> <p>CloudTrail also supports KMS multi-Region keys. For more information about multi-Region keys, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/multi-region-keys-overview.html">Using multi-Region keys</a> in the <i>Key Management Service Developer Guide</i>.</p> <p>Examples:</p> <ul> <li> <p>alias/MyAliasName</p> </li> <li> <p>arn:aws:kms:us-east-2:123456789012:alias/MyAliasName</p> </li> <li> <p>arn:aws:kms:us-east-2:123456789012:key/12345678-1234-1234-1234-123456789012</p> </li> <li> <p>12345678-1234-1234-1234-123456789012</p> </li> </ul>', 'CreateTrailResponse$Name' => '<p>Specifies the name of the trail.</p>', 'CreateTrailResponse$S3BucketName' => '<p>Specifies the name of the Amazon S3 bucket designated for publishing log files.</p>', 'CreateTrailResponse$S3KeyPrefix' => '<p>Specifies the Amazon S3 key prefix that comes after the name of the bucket you have designated for log file delivery. For more information, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-find-log-files.html">Finding Your CloudTrail Log Files</a>.</p>', 'CreateTrailResponse$SnsTopicName' => '<p>This field is no longer in use. Use SnsTopicARN.</p>', 'CreateTrailResponse$SnsTopicARN' => '<p>Specifies the ARN of the Amazon SNS topic that CloudTrail uses to send notifications when log files are delivered. The format of a topic ARN is:</p> <p> <code>arn:aws:sns:us-east-2:123456789012:MyTopic</code> </p>', 'CreateTrailResponse$TrailARN' => '<p>Specifies the ARN of the trail that was created. The format of a trail ARN is:</p> <p> <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code> </p>', 'CreateTrailResponse$CloudWatchLogsLogGroupArn' => '<p>Specifies the Amazon Resource Name (ARN) of the log group to which CloudTrail logs will be delivered.</p>', 'CreateTrailResponse$CloudWatchLogsRoleArn' => '<p>Specifies the role for the CloudWatch Logs endpoint to assume to write to a user\'s log group.</p>', 'CreateTrailResponse$KmsKeyId' => '<p>Specifies the KMS key ID that encrypts the logs delivered by CloudTrail. The value is a fully specified ARN to a KMS key in the following format.</p> <p> <code>arn:aws:kms:us-east-2:123456789012:key/12345678-1234-1234-1234-123456789012</code> </p>', 'DataResource$Type' => '<p>The resource type in which you want to log data events. You can specify the following <i>basic</i> event selector resource types:</p> <ul> <li> <p> <code>AWS::S3::Object</code> </p> </li> <li> <p> <code>AWS::Lambda::Function</code> </p> </li> <li> <p> <code>AWS::DynamoDB::Table</code> </p> </li> </ul> <p>The following resource types are also availble through <i>advanced</i> event selectors. Basic event selector resource types are valid in advanced event selectors, but advanced event selector resource types are not valid in basic event selectors. For more information, see <a>AdvancedFieldSelector$Field</a>.</p> <ul> <li> <p> <code>AWS::S3Outposts::Object</code> </p> </li> <li> <p> <code>AWS::ManagedBlockchain::Node</code> </p> </li> <li> <p> <code>AWS::S3ObjectLambda::AccessPoint</code> </p> </li> <li> <p> <code>AWS::EC2::Snapshot</code> </p> </li> <li> <p> <code>AWS::S3::AccessPoint</code> </p> </li> <li> <p> <code>AWS::DynamoDB::Stream</code> </p> </li> </ul>', 'DataResourceValues$member' => NULL, 'DeleteTrailRequest$Name' => '<p>Specifies the name or the CloudTrail ARN of the trail to be deleted. The following is the format of a trail ARN. <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code> </p>', 'Event$EventId' => '<p>The CloudTrail ID of the event returned.</p>', 'Event$EventName' => '<p>The name of the event returned.</p>', 'Event$ReadOnly' => '<p>Information about whether the event is a write event or a read event. </p>', 'Event$AccessKeyId' => '<p>The Amazon Web Services access key ID that was used to sign the request. If the request was made with temporary security credentials, this is the access key ID of the temporary credentials.</p>', 'Event$EventSource' => '<p>The Amazon Web Services service to which the request was made.</p>', 'Event$Username' => '<p>A user name or role name of the requester that called the API in the event returned.</p>', 'Event$CloudTrailEvent' => '<p>A JSON string that contains a representation of the event returned.</p>', 'ExcludeManagementEventSources$member' => NULL, 'GetEventSelectorsRequest$TrailName' => '<p>Specifies the name of the trail or trail ARN. If you specify a trail name, the string must meet the following requirements:</p> <ul> <li> <p>Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores (_), or dashes (-)</p> </li> <li> <p>Start with a letter or number, and end with a letter or number</p> </li> <li> <p>Be between 3 and 128 characters</p> </li> <li> <p>Have no adjacent periods, underscores or dashes. Names like <code>my-_namespace</code> and <code>my--namespace</code> are not valid.</p> </li> <li> <p>Not be in IP address format (for example, 192.168.5.4)</p> </li> </ul> <p>If you specify a trail ARN, it must be in the format:</p> <p> <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code> </p>', 'GetEventSelectorsResponse$TrailARN' => '<p>The specified trail ARN that has the event selectors.</p>', 'GetInsightSelectorsRequest$TrailName' => '<p>Specifies the name of the trail or trail ARN. If you specify a trail name, the string must meet the following requirements:</p> <ul> <li> <p>Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores (_), or dashes (-)</p> </li> <li> <p>Start with a letter or number, and end with a letter or number</p> </li> <li> <p>Be between 3 and 128 characters</p> </li> <li> <p>Have no adjacent periods, underscores or dashes. Names like <code>my-_namespace</code> and <code>my--namespace</code> are not valid.</p> </li> <li> <p>Not be in IP address format (for example, 192.168.5.4)</p> </li> </ul> <p>If you specify a trail ARN, it must be in the format:</p> <p> <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code> </p>', 'GetInsightSelectorsResponse$TrailARN' => '<p>The Amazon Resource Name (ARN) of a trail for which you want to get Insights selectors.</p>', 'GetTrailRequest$Name' => '<p>The name or the Amazon Resource Name (ARN) of the trail for which you want to retrieve settings information.</p>', 'GetTrailStatusRequest$Name' => '<p>Specifies the name or the CloudTrail ARN of the trail for which you are requesting status. To get the status of a shadow trail (a replication of the trail in another region), you must specify its ARN. The following is the format of a trail ARN.</p> <p> <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code> </p>', 'GetTrailStatusResponse$LatestDeliveryError' => '<p>Displays any Amazon S3 error that CloudTrail encountered when attempting to deliver log files to the designated bucket. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/ErrorResponses.html">Error Responses</a> in the Amazon S3 API Reference. </p> <note> <p>This error occurs only when there is a problem with the destination S3 bucket, and does not occur for requests that time out. To resolve the issue, create a new bucket, and then call <code>UpdateTrail</code> to specify the new bucket; or fix the existing objects so that CloudTrail can again write to the bucket.</p> </note>', 'GetTrailStatusResponse$LatestNotificationError' => '<p>Displays any Amazon SNS error that CloudTrail encountered when attempting to send a notification. For more information about Amazon SNS errors, see the <a href="https://docs.aws.amazon.com/sns/latest/dg/welcome.html">Amazon SNS Developer Guide</a>. </p>', 'GetTrailStatusResponse$LatestCloudWatchLogsDeliveryError' => '<p>Displays any CloudWatch Logs error that CloudTrail encountered when attempting to deliver logs to CloudWatch Logs.</p>', 'GetTrailStatusResponse$LatestDigestDeliveryError' => '<p>Displays any Amazon S3 error that CloudTrail encountered when attempting to deliver a digest file to the designated bucket. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/ErrorResponses.html">Error Responses</a> in the Amazon S3 API Reference. </p> <note> <p>This error occurs only when there is a problem with the destination S3 bucket, and does not occur for requests that time out. To resolve the issue, create a new bucket, and then call <code>UpdateTrail</code> to specify the new bucket; or fix the existing objects so that CloudTrail can again write to the bucket.</p> </note>', 'GetTrailStatusResponse$LatestDeliveryAttemptTime' => '<p>This field is no longer in use.</p>', 'GetTrailStatusResponse$LatestNotificationAttemptTime' => '<p>This field is no longer in use.</p>', 'GetTrailStatusResponse$LatestNotificationAttemptSucceeded' => '<p>This field is no longer in use.</p>', 'GetTrailStatusResponse$LatestDeliveryAttemptSucceeded' => '<p>This field is no longer in use.</p>', 'GetTrailStatusResponse$TimeLoggingStarted' => '<p>This field is no longer in use.</p>', 'GetTrailStatusResponse$TimeLoggingStopped' => '<p>This field is no longer in use.</p>', 'ListPublicKeysRequest$NextToken' => '<p>Reserved for future use.</p>', 'ListPublicKeysResponse$NextToken' => '<p>Reserved for future use.</p>', 'ListTagsRequest$NextToken' => '<p>Reserved for future use.</p>', 'ListTagsResponse$NextToken' => '<p>Reserved for future use.</p>', 'ListTrailsRequest$NextToken' => '<p>The token to use to get the next page of results after a previous API call. This token must be passed in with the same parameters that were specified in the the original call. For example, if the original call specified an AttributeKey of \'Username\' with a value of \'root\', the call with NextToken should include those same parameters.</p>', 'ListTrailsResponse$NextToken' => '<p>The token to use to get the next page of results after a previous API call. If the token does not appear, there are no more results to return. The token must be passed in with the same parameters as the previous call. For example, if the original call specified an AttributeKey of \'Username\' with a value of \'root\', the call with NextToken should include those same parameters.</p>', 'LookupAttribute$AttributeValue' => '<p>Specifies a value for the specified AttributeKey.</p>', 'PublicKey$Fingerprint' => '<p>The fingerprint of the public key.</p>', 'PutEventSelectorsRequest$TrailName' => '<p>Specifies the name of the trail or trail ARN. If you specify a trail name, the string must meet the following requirements:</p> <ul> <li> <p>Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores (_), or dashes (-)</p> </li> <li> <p>Start with a letter or number, and end with a letter or number</p> </li> <li> <p>Be between 3 and 128 characters</p> </li> <li> <p>Have no adjacent periods, underscores or dashes. Names like <code>my-_namespace</code> and <code>my--namespace</code> are not valid.</p> </li> <li> <p>Not be in IP address format (for example, 192.168.5.4)</p> </li> </ul> <p>If you specify a trail ARN, it must be in the following format.</p> <p> <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code> </p>', 'PutEventSelectorsResponse$TrailARN' => '<p>Specifies the ARN of the trail that was updated with event selectors. The following is the format of a trail ARN.</p> <p> <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code> </p>', 'PutInsightSelectorsRequest$TrailName' => '<p>The name of the CloudTrail trail for which you want to change or add Insights selectors.</p>', 'PutInsightSelectorsResponse$TrailARN' => '<p>The Amazon Resource Name (ARN) of a trail for which you want to change or add Insights selectors.</p>', 'RemoveTagsRequest$ResourceId' => '<p>Specifies the ARN of the trail from which tags should be removed. The format of a trail ARN is:</p> <p> <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code> </p>', 'Resource$ResourceType' => '<p>The type of a resource referenced by the event returned. When the resource type cannot be determined, null is returned. Some examples of resource types are: <b>Instance</b> for EC2, <b>Trail</b> for CloudTrail, <b>DBInstance</b> for Amazon RDS, and <b>AccessKey</b> for IAM. To learn more about how to look up and filter events by the resource types supported for a service, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/view-cloudtrail-events-console.html#filtering-cloudtrail-events">Filtering CloudTrail Events</a>.</p>', 'Resource$ResourceName' => '<p>The name of the resource referenced by the event returned. These are user-created names whose values will depend on the environment. For example, the resource name might be "auto-scaling-test-group" for an Auto Scaling Group or "i-1234567" for an EC2 Instance.</p>', 'ResourceIdList$member' => NULL, 'ResourceTag$ResourceId' => '<p>Specifies the ARN of the resource.</p>', 'StartLoggingRequest$Name' => '<p>Specifies the name or the CloudTrail ARN of the trail for which CloudTrail logs Amazon Web Services API calls. The following is the format of a trail ARN.</p> <p> <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code> </p>', 'StopLoggingRequest$Name' => '<p>Specifies the name or the CloudTrail ARN of the trail for which CloudTrail will stop logging Amazon Web Services API calls. The following is the format of a trail ARN.</p> <p> <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code> </p>', 'Tag$Key' => '<p>The key in a key-value pair. The key must be must be no longer than 128 Unicode characters. The key must be unique for the resource to which it applies.</p>', 'Tag$Value' => '<p>The value in a key-value pair of a tag. The value must be no longer than 256 Unicode characters.</p>', 'Trail$Name' => '<p>Name of the trail set by calling <a>CreateTrail</a>. The maximum length is 128 characters.</p>', 'Trail$S3BucketName' => '<p>Name of the Amazon S3 bucket into which CloudTrail delivers your trail files. See <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/create_trail_naming_policy.html">Amazon S3 Bucket Naming Requirements</a>.</p>', 'Trail$S3KeyPrefix' => '<p>Specifies the Amazon S3 key prefix that comes after the name of the bucket you have designated for log file delivery. For more information, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-find-log-files.html">Finding Your CloudTrail Log Files</a>. The maximum length is 200 characters.</p>', 'Trail$SnsTopicName' => '<p>This field is no longer in use. Use SnsTopicARN.</p>', 'Trail$SnsTopicARN' => '<p>Specifies the ARN of the Amazon SNS topic that CloudTrail uses to send notifications when log files are delivered. The following is the format of a topic ARN.</p> <p> <code>arn:aws:sns:us-east-2:123456789012:MyTopic</code> </p>', 'Trail$HomeRegion' => '<p>The region in which the trail was created.</p>', 'Trail$TrailARN' => '<p>Specifies the ARN of the trail. The following is the format of a trail ARN.</p> <p> <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code> </p>', 'Trail$CloudWatchLogsLogGroupArn' => '<p>Specifies an Amazon Resource Name (ARN), a unique identifier that represents the log group to which CloudTrail logs will be delivered.</p>', 'Trail$CloudWatchLogsRoleArn' => '<p>Specifies the role for the CloudWatch Logs endpoint to assume to write to a user\'s log group.</p>', 'Trail$KmsKeyId' => '<p>Specifies the KMS key ID that encrypts the logs delivered by CloudTrail. The value is a fully specified ARN to a KMS key in the following format.</p> <p> <code>arn:aws:kms:us-east-2:123456789012:key/12345678-1234-1234-1234-123456789012</code> </p>', 'TrailInfo$TrailARN' => '<p>The ARN of a trail.</p>', 'TrailInfo$Name' => '<p>The name of a trail.</p>', 'TrailInfo$HomeRegion' => '<p>The Amazon Web Services Region in which a trail was created.</p>', 'TrailNameList$member' => NULL, 'UpdateTrailRequest$Name' => '<p>Specifies the name of the trail or trail ARN. If <code>Name</code> is a trail name, the string must meet the following requirements:</p> <ul> <li> <p>Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores (_), or dashes (-)</p> </li> <li> <p>Start with a letter or number, and end with a letter or number</p> </li> <li> <p>Be between 3 and 128 characters</p> </li> <li> <p>Have no adjacent periods, underscores or dashes. Names like <code>my-_namespace</code> and <code>my--namespace</code> are not valid.</p> </li> <li> <p>Not be in IP address format (for example, 192.168.5.4)</p> </li> </ul> <p>If <code>Name</code> is a trail ARN, it must be in the following format.</p> <p> <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code> </p>', 'UpdateTrailRequest$S3BucketName' => '<p>Specifies the name of the Amazon S3 bucket designated for publishing log files. See <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/create_trail_naming_policy.html">Amazon S3 Bucket Naming Requirements</a>.</p>', 'UpdateTrailRequest$S3KeyPrefix' => '<p>Specifies the Amazon S3 key prefix that comes after the name of the bucket you have designated for log file delivery. For more information, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-find-log-files.html">Finding Your CloudTrail Log Files</a>. The maximum length is 200 characters.</p>', 'UpdateTrailRequest$SnsTopicName' => '<p>Specifies the name of the Amazon SNS topic defined for notification of log file delivery. The maximum length is 256 characters.</p>', 'UpdateTrailRequest$CloudWatchLogsLogGroupArn' => '<p>Specifies a log group name using an Amazon Resource Name (ARN), a unique identifier that represents the log group to which CloudTrail logs are delivered. Not required unless you specify <code>CloudWatchLogsRoleArn</code>.</p>', 'UpdateTrailRequest$CloudWatchLogsRoleArn' => '<p>Specifies the role for the CloudWatch Logs endpoint to assume to write to a user\'s log group.</p>', 'UpdateTrailRequest$KmsKeyId' => '<p>Specifies the KMS key ID to use to encrypt the logs delivered by CloudTrail. The value can be an alias name prefixed by "alias/", a fully specified ARN to an alias, a fully specified ARN to a key, or a globally unique identifier.</p> <p>CloudTrail also supports KMS multi-Region keys. For more information about multi-Region keys, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/multi-region-keys-overview.html">Using multi-Region keys</a> in the <i>Key Management Service Developer Guide</i>.</p> <p>Examples:</p> <ul> <li> <p>alias/MyAliasName</p> </li> <li> <p>arn:aws:kms:us-east-2:123456789012:alias/MyAliasName</p> </li> <li> <p>arn:aws:kms:us-east-2:123456789012:key/12345678-1234-1234-1234-123456789012</p> </li> <li> <p>12345678-1234-1234-1234-123456789012</p> </li> </ul>', 'UpdateTrailResponse$Name' => '<p>Specifies the name of the trail.</p>', 'UpdateTrailResponse$S3BucketName' => '<p>Specifies the name of the Amazon S3 bucket designated for publishing log files.</p>', 'UpdateTrailResponse$S3KeyPrefix' => '<p>Specifies the Amazon S3 key prefix that comes after the name of the bucket you have designated for log file delivery. For more information, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-find-log-files.html">Finding Your IAM Log Files</a>.</p>', 'UpdateTrailResponse$SnsTopicName' => '<p>This field is no longer in use. Use <a>UpdateTrailResponse$SnsTopicARN</a>.</p>', 'UpdateTrailResponse$SnsTopicARN' => '<p>Specifies the ARN of the Amazon SNS topic that CloudTrail uses to send notifications when log files are delivered. The following is the format of a topic ARN.</p> <p> <code>arn:aws:sns:us-east-2:123456789012:MyTopic</code> </p>', 'UpdateTrailResponse$TrailARN' => '<p>Specifies the ARN of the trail that was updated. The following is the format of a trail ARN.</p> <p> <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code> </p>', 'UpdateTrailResponse$CloudWatchLogsLogGroupArn' => '<p>Specifies the Amazon Resource Name (ARN) of the log group to which CloudTrail logs are delivered.</p>', 'UpdateTrailResponse$CloudWatchLogsRoleArn' => '<p>Specifies the role for the CloudWatch Logs endpoint to assume to write to a user\'s log group.</p>', 'UpdateTrailResponse$KmsKeyId' => '<p>Specifies the KMS key ID that encrypts the logs delivered by CloudTrail. The value is a fully specified ARN to a KMS key in the following format.</p> <p> <code>arn:aws:kms:us-east-2:123456789012:key/12345678-1234-1234-1234-123456789012</code> </p>', ], ], 'Tag' => [ 'base' => '<p>A custom key-value pair associated with a resource such as a CloudTrail trail.</p>', 'refs' => [ 'TagsList$member' => NULL, ], ], 'TagsLimitExceededException' => [ 'base' => '<p>The number of tags per trail has exceeded the permitted amount. Currently, the limit is 50.</p>', 'refs' => [], ], 'TagsList' => [ 'base' => '<p>A list of tags.</p>', 'refs' => [ 'AddTagsRequest$TagsList' => '<p>Contains a list of tags, up to a limit of 50</p>', 'CreateTrailRequest$TagsList' => NULL, 'RemoveTagsRequest$TagsList' => '<p>Specifies a list of tags to be removed.</p>', 'ResourceTag$TagsList' => '<p>A list of tags.</p>', ], ], 'Trail' => [ 'base' => '<p>The settings for a trail.</p>', 'refs' => [ 'GetTrailResponse$Trail' => NULL, 'TrailList$member' => NULL, ], ], 'TrailAlreadyExistsException' => [ 'base' => '<p>This exception is thrown when the specified trail already exists.</p>', 'refs' => [], ], 'TrailInfo' => [ 'base' => '<p>Information about a CloudTrail trail, including the trail\'s name, home region, and Amazon Resource Name (ARN).</p>', 'refs' => [ 'Trails$member' => NULL, ], ], 'TrailList' => [ 'base' => NULL, 'refs' => [ 'DescribeTrailsResponse$trailList' => '<p>The list of trail objects. Trail objects with string values are only returned if values for the objects exist in a trail\'s configuration. For example, <code>SNSTopicName</code> and <code>SNSTopicARN</code> are only returned in results if a trail is configured to send SNS notifications. Similarly, <code>KMSKeyId</code> only appears in results if a trail\'s log files are encrypted with KMS customer managed keys.</p>', ], ], 'TrailNameList' => [ 'base' => NULL, 'refs' => [ 'DescribeTrailsRequest$trailNameList' => '<p>Specifies a list of trail names, trail ARNs, or both, of the trails to describe. The format of a trail ARN is:</p> <p> <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code> </p> <p>If an empty list is specified, information for the trail in the current region is returned.</p> <ul> <li> <p>If an empty list is specified and <code>IncludeShadowTrails</code> is false, then information for all trails in the current region is returned.</p> </li> <li> <p>If an empty list is specified and IncludeShadowTrails is null or true, then information for all trails in the current region and any associated shadow trails in other regions is returned.</p> </li> </ul> <note> <p>If one or more trail names are specified, information is returned only if the names match the names of trails belonging only to the current region. To return information about a trail in another region, you must specify its trail ARN.</p> </note>', ], ], 'TrailNotFoundException' => [ 'base' => '<p>This exception is thrown when the trail with the given name is not found.</p>', 'refs' => [], ], 'TrailNotProvidedException' => [ 'base' => '<p>This exception is no longer in use.</p>', 'refs' => [], ], 'Trails' => [ 'base' => NULL, 'refs' => [ 'ListTrailsResponse$Trails' => '<p>Returns the name, ARN, and home region of trails in the current account.</p>', ], ], 'UnsupportedOperationException' => [ 'base' => '<p>This exception is thrown when the requested operation is not supported.</p>', 'refs' => [], ], 'UpdateTrailRequest' => [ 'base' => '<p>Specifies settings to update for the trail.</p>', 'refs' => [], ], 'UpdateTrailResponse' => [ 'base' => '<p>Returns the objects or data listed below if successful. Otherwise, returns an error.</p>', 'refs' => [], ], ],];
