<?php
// This file was auto-generated from sdk-root/src/data/chime-sdk-messaging/2021-05-15/docs-2.json
return [ 'version' => '2.0', 'service' => '<p>The Amazon Chime SDK Messaging APIs in this section allow software developers to send and receive messages in custom messaging applications. These APIs depend on the frameworks provided by the Amazon Chime SDK Identity APIs. For more information about the messaging APIs, see <a href="https://docs.aws.amazon.com/chime/latest/APIReference/API_Operations_Amazon_Chime_SDK_Messaging">Amazon Chime SDK messaging</a> </p>', 'operations' => [ 'AssociateChannelFlow' => '<p>Associates a channel flow with a channel. Once associated, all messages to that channel go through channel flow processors. To stop processing, use the <code>DisassociateChannelFlow</code> API.</p> <note> <p>Only administrators or channel moderators can associate a channel flow. The <code>x-amz-chime-bearer</code> request header is mandatory. Use the <code>AppInstanceUserArn</code> of the user that makes the API call as the value in the header.</p> </note>', 'BatchCreateChannelMembership' => '<p>Adds a specified number of users to a channel. </p>', 'ChannelFlowCallback' => '<p>Calls back Chime SDK Messaging with a processing response message. This should be invoked from the processor Lambda. This is a developer API.</p> <p>You can return one of the following processing responses:</p> <ul> <li> <p>Update message content or metadata</p> </li> <li> <p>Deny a message</p> </li> <li> <p>Make no changes to the message</p> </li> </ul>', 'CreateChannel' => '<p>Creates a channel to which you can add users and send messages.</p> <p> <b>Restriction</b>: You can\'t change a channel\'s privacy.</p> <note> <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the <code>AppInstanceUserArn</code> of the user that makes the API call as the value in the header.</p> </note>', 'CreateChannelBan' => '<p>Permanently bans a member from a channel. Moderators can\'t add banned members to a channel. To undo a ban, you first have to <code>DeleteChannelBan</code>, and then <code>CreateChannelMembership</code>. Bans are cleaned up when you delete users or channels.</p> <p>If you ban a user who is already part of a channel, that user is automatically kicked from the channel.</p> <note> <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the <code>AppInstanceUserArn</code> of the user that makes the API call as the value in the header.</p> </note>', 'CreateChannelFlow' => '<p>Creates a channel flow, a container for processors. Processors are AWS Lambda functions that perform actions on chat messages, such as stripping out profanity. You can associate channel flows with channels, and the processors in the channel flow then take action on all messages sent to that channel. This is a developer API.</p> <p>Channel flows process the following items:</p> <ol> <li> <p>New and updated messages</p> </li> <li> <p>Persistent and non-persistent messages</p> </li> <li> <p>The Standard message type</p> </li> </ol> <note> <p>Channel flows don\'t process Control or System messages. For more information about the message types provided by Chime SDK Messaging, refer to <a href="https://docs.aws.amazon.com/chime/latest/dg/using-the-messaging-sdk.html#msg-types">Message types</a> in the <i>Amazon Chime developer guide</i>.</p> </note>', 'CreateChannelMembership' => '<p>Adds a user to a channel. The <code>InvitedBy</code> field in <code>ChannelMembership</code> is derived from the request header. A channel member can:</p> <ul> <li> <p>List messages</p> </li> <li> <p>Send messages</p> </li> <li> <p>Receive messages</p> </li> <li> <p>Edit their own messages</p> </li> <li> <p>Leave the channel</p> </li> </ul> <p>Privacy settings impact this action as follows:</p> <ul> <li> <p>Public Channels: You do not need to be a member to list messages, but you must be a member to send messages.</p> </li> <li> <p>Private Channels: You must be a member to list or send messages.</p> </li> </ul> <note> <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the <code>AppInstanceUserArn</code> of the user that makes the API call as the value in the header.</p> </note>', 'CreateChannelModerator' => '<p>Creates a new <code>ChannelModerator</code>. A channel moderator can:</p> <ul> <li> <p>Add and remove other members of the channel.</p> </li> <li> <p>Add and remove other moderators of the channel.</p> </li> <li> <p>Add and remove user bans for the channel.</p> </li> <li> <p>Redact messages in the channel.</p> </li> <li> <p>List messages in the channel.</p> </li> </ul> <note> <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the <code>AppInstanceUserArn</code> of the user that makes the API call as the value in the header.</p> </note>', 'DeleteChannel' => '<p>Immediately makes a channel and its memberships inaccessible and marks them for deletion. This is an irreversible process.</p> <note> <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the <code>AppInstanceUserArn</code> of the user that makes the API call as the value in the header.</p> </note>', 'DeleteChannelBan' => '<p>Removes a user from a channel\'s ban list.</p> <note> <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the <code>AppInstanceUserArn</code> of the user that makes the API call as the value in the header.</p> </note>', 'DeleteChannelFlow' => '<p>Deletes a channel flow, an irreversible process. This is a developer API.</p> <note> <p> This API works only when the channel flow is not associated with any channel. To get a list of all channels that a channel flow is associated with, use the <code>ListChannelsAssociatedWithChannelFlow</code> API. Use the <code>DisassociateChannelFlow</code> API to disassociate a channel flow from all channels. </p> </note>', 'DeleteChannelMembership' => '<p>Removes a member from a channel.</p> <note> <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the <code>AppInstanceUserArn</code> of the user that makes the API call as the value in the header.</p> </note>', 'DeleteChannelMessage' => '<p>Deletes a channel message. Only admins can perform this action. Deletion makes messages inaccessible immediately. A background process deletes any revisions created by <code>UpdateChannelMessage</code>.</p> <note> <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the <code>AppInstanceUserArn</code> of the user that makes the API call as the value in the header.</p> </note>', 'DeleteChannelModerator' => '<p>Deletes a channel moderator.</p> <note> <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the <code>AppInstanceUserArn</code> of the user that makes the API call as the value in the header.</p> </note>', 'DescribeChannel' => '<p>Returns the full details of a channel in an Amazon Chime <code>AppInstance</code>.</p> <note> <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the <code>AppInstanceUserArn</code> of the user that makes the API call as the value in the header.</p> </note>', 'DescribeChannelBan' => '<p>Returns the full details of a channel ban.</p> <note> <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the <code>AppInstanceUserArn</code> of the user that makes the API call as the value in the header.</p> </note>', 'DescribeChannelFlow' => '<p>Returns the full details of a channel flow in an Amazon Chime <code>AppInstance</code>. This is a developer API.</p>', 'DescribeChannelMembership' => '<p>Returns the full details of a user\'s channel membership.</p> <note> <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the <code>AppInstanceUserArn</code> of the user that makes the API call as the value in the header.</p> </note>', 'DescribeChannelMembershipForAppInstanceUser' => '<p> Returns the details of a channel based on the membership of the specified <code>AppInstanceUser</code>.</p> <note> <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the <code>AppInstanceUserArn</code> of the user that makes the API call as the value in the header.</p> </note>', 'DescribeChannelModeratedByAppInstanceUser' => '<p>Returns the full details of a channel moderated by the specified <code>AppInstanceUser</code>.</p> <note> <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the <code>AppInstanceUserArn</code> of the user that makes the API call as the value in the header.</p> </note>', 'DescribeChannelModerator' => '<p>Returns the full details of a single ChannelModerator.</p> <note> <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the <code>AppInstanceUserArn</code> of the user that makes the API call as the value in the header.</p> </note>', 'DisassociateChannelFlow' => '<p>Disassociates a channel flow from all its channels. Once disassociated, all messages to that channel stop going through the channel flow processor.</p> <note> <p>Only administrators or channel moderators can disassociate a channel flow. The <code>x-amz-chime-bearer</code> request header is mandatory. Use the <code>AppInstanceUserArn</code> of the user that makes the API call as the value in the header.</p> </note>', 'GetChannelMembershipPreferences' => '<p>Gets the membership preferences of an <code>AppInstanceUser</code> for the specified channel. The <code>AppInstanceUser</code> must be a member of the channel. Only the <code>AppInstanceUser</code> who owns the membership can retrieve preferences. Users in the <code>AppInstanceAdmin</code> and channel moderator roles can\'t retrieve preferences for other users. Banned users can\'t retrieve membership preferences for the channel from which they are banned.</p>', 'GetChannelMessage' => '<p>Gets the full details of a channel message.</p> <note> <p>The x-amz-chime-bearer request header is mandatory. Use the <code>AppInstanceUserArn</code> of the user that makes the API call as the value in the header.</p> </note>', 'GetChannelMessageStatus' => '<p>Gets message status for a specified <code>messageId</code>. Use this API to determine the intermediate status of messages going through channel flow processing. The API provides an alternative to retrieving message status if the event was not received because a client wasn\'t connected to a websocket. </p> <p>Messages can have any one of these statuses.</p> <dl> <dt>SENT</dt> <dd> <p>Message processed successfully</p> </dd> <dt>PENDING</dt> <dd> <p>Ongoing processing</p> </dd> <dt>FAILED</dt> <dd> <p>Processing failed</p> </dd> <dt>DENIED</dt> <dd> <p>Messasge denied by the processor</p> </dd> </dl> <note> <ul> <li> <p>This API does not return statuses for denied messages, because we don\'t store them once the processor denies them. </p> </li> <li> <p>Only the message sender can invoke this API.</p> </li> <li> <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the <code>AppInstanceUserArn</code> of the user that makes the API call as the value in the header</p> </li> </ul> </note>', 'GetMessagingSessionEndpoint' => '<p>The details of the endpoint for the messaging session.</p>', 'ListChannelBans' => '<p>Lists all the users banned from a particular channel.</p> <note> <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the <code>AppInstanceUserArn</code> of the user that makes the API call as the value in the header.</p> </note>', 'ListChannelFlows' => '<p>Returns a paginated lists of all the channel flows created under a single Chime. This is a developer API.</p>', 'ListChannelMemberships' => '<p>Lists all channel memberships in a channel.</p> <note> <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the <code>AppInstanceUserArn</code> of the user that makes the API call as the value in the header.</p> </note> <p>If you want to list the channels to which a specific app instance user belongs, see the <a href="https://docs.aws.amazon.com/chime/latest/APIReference/API_messaging-chime_ListChannelMembershipsForAppInstanceUser.html">ListChannelMembershipsForAppInstanceUser</a> API.</p>', 'ListChannelMembershipsForAppInstanceUser' => '<p> Lists all channels that a particular <code>AppInstanceUser</code> is a part of. Only an <code>AppInstanceAdmin</code> can call the API with a user ARN that is not their own. </p> <note> <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the <code>AppInstanceUserArn</code> of the user that makes the API call as the value in the header.</p> </note>', 'ListChannelMessages' => '<p>List all the messages in a channel. Returns a paginated list of <code>ChannelMessages</code>. By default, sorted by creation timestamp in descending order.</p> <note> <p>Redacted messages appear in the results as empty, since they are only redacted, not deleted. Deleted messages do not appear in the results. This action always returns the latest version of an edited message.</p> <p>Also, the x-amz-chime-bearer request header is mandatory. Use the <code>AppInstanceUserArn</code> of the user that makes the API call as the value in the header.</p> </note>', 'ListChannelModerators' => '<p>Lists all the moderators for a channel.</p> <note> <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the <code>AppInstanceUserArn</code> of the user that makes the API call as the value in the header.</p> </note>', 'ListChannels' => '<p>Lists all Channels created under a single Chime App as a paginated list. You can specify filters to narrow results.</p> <p class="title"> <b>Functionality &amp; restrictions</b> </p> <ul> <li> <p>Use privacy = <code>PUBLIC</code> to retrieve all public channels in the account.</p> </li> <li> <p>Only an <code>AppInstanceAdmin</code> can set privacy = <code>PRIVATE</code> to list the private channels in an account.</p> </li> </ul> <note> <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the <code>AppInstanceUserArn</code> of the user that makes the API call as the value in the header.</p> </note>', 'ListChannelsAssociatedWithChannelFlow' => '<p>Lists all channels associated with a specified channel flow. You can associate a channel flow with multiple channels, but you can only associate a channel with one channel flow. This is a developer API.</p>', 'ListChannelsModeratedByAppInstanceUser' => '<p>A list of the channels moderated by an <code>AppInstanceUser</code>.</p> <note> <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the <code>AppInstanceUserArn</code> of the user that makes the API call as the value in the header.</p> </note>', 'ListTagsForResource' => '<p>Lists the tags applied to an Amazon Chime SDK messaging resource.</p>', 'PutChannelMembershipPreferences' => '<p>Sets the membership preferences of an <code>AppInstanceUser</code> for the specified channel. The <code>AppInstanceUser</code> must be a member of the channel. Only the <code>AppInstanceUser</code> who owns the membership can set preferences. Users in the <code>AppInstanceAdmin</code> and channel moderator roles can\'t set preferences for other users. Banned users can\'t set membership preferences for the channel from which they are banned.</p>', 'RedactChannelMessage' => '<p>Redacts message content, but not metadata. The message exists in the back end, but the action returns null content, and the state shows as redacted.</p> <note> <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the <code>AppInstanceUserArn</code> of the user that makes the API call as the value in the header.</p> </note>', 'SendChannelMessage' => '<p>Sends a message to a particular channel that the member is a part of.</p> <note> <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the <code>AppInstanceUserArn</code> of the user that makes the API call as the value in the header.</p> <p>Also, <code>STANDARD</code> messages can contain 4KB of data and the 1KB of metadata. <code>CONTROL</code> messages can contain 30 bytes of data and no metadata.</p> </note>', 'TagResource' => '<p>Applies the specified tags to the specified Amazon Chime SDK messaging resource.</p>', 'UntagResource' => '<p>Removes the specified tags from the specified Amazon Chime SDK messaging resource.</p>', 'UpdateChannel' => '<p>Update a channel\'s attributes.</p> <p> <b>Restriction</b>: You can\'t change a channel\'s privacy. </p> <note> <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the <code>AppInstanceUserArn</code> of the user that makes the API call as the value in the header.</p> </note>', 'UpdateChannelFlow' => '<p>Updates channel flow attributes. This is a developer API.</p>', 'UpdateChannelMessage' => '<p>Updates the content of a message.</p> <note> <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the <code>AppInstanceUserArn</code> of the user that makes the API call as the value in the header.</p> </note>', 'UpdateChannelReadMarker' => '<p>The details of the time when a user last read messages in a channel.</p> <note> <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the <code>AppInstanceUserArn</code> of the user that makes the API call as the value in the header.</p> </note>', ], 'shapes' => [ 'AllowNotifications' => [ 'base' => NULL, 'refs' => [ 'PushNotificationPreferences$AllowNotifications' => '<p>Enum value that indicates which push notifications to send to the requested member of a channel. <code>ALL</code> sends all push notifications, <code>NONE</code> sends no push notifications, <code>FILTERED</code> sends only filtered push notifications. </p>', ], ], 'AppInstanceUserMembershipSummary' => [ 'base' => '<p>Summary of the membership details of an <code>AppInstanceUser</code>.</p>', 'refs' => [ 'ChannelMembershipForAppInstanceUserSummary$AppInstanceUserMembershipSummary' => '<p>Returns the channel membership data for an <code>AppInstance</code>.</p>', ], ], 'AssociateChannelFlowRequest' => [ 'base' => NULL, 'refs' => [], ], 'BadRequestException' => [ 'base' => '<p>The input parameters don\'t match the service\'s restrictions.</p>', 'refs' => [], ], 'BatchChannelMemberships' => [ 'base' => '<p>The membership information, including member ARNs, the channel ARN, and membership types.</p>', 'refs' => [ 'BatchCreateChannelMembershipResponse$BatchChannelMemberships' => '<p>The list of channel memberships in the response.</p>', ], ], 'BatchCreateChannelMembershipError' => [ 'base' => '<p>A list of failed member ARNs, error codes, and error messages.</p>', 'refs' => [ 'BatchCreateChannelMembershipErrors$member' => NULL, ], ], 'BatchCreateChannelMembershipErrors' => [ 'base' => NULL, 'refs' => [ 'BatchCreateChannelMembershipResponse$Errors' => '<p>If the action fails for one or more of the memberships in the request, a list of the memberships is returned, along with error codes and error messages.</p>', ], ], 'BatchCreateChannelMembershipRequest' => [ 'base' => NULL, 'refs' => [], ], 'BatchCreateChannelMembershipResponse' => [ 'base' => NULL, 'refs' => [], ], 'CallbackIdType' => [ 'base' => NULL, 'refs' => [ 'ChannelFlowCallbackRequest$CallbackId' => '<p>The identifier passed to the processor by the service when invoked. Use the identifier to call back the service.</p>', 'ChannelFlowCallbackResponse$CallbackId' => '<p>The call back ID passed in the request.</p>', ], ], 'Channel' => [ 'base' => '<p>The details of a channel.</p>', 'refs' => [ 'DescribeChannelResponse$Channel' => '<p>The channel details.</p>', ], ], 'ChannelAssociatedWithFlowSummary' => [ 'base' => '<p>Summary of details of a channel associated with channel flow.</p>', 'refs' => [ 'ChannelAssociatedWithFlowSummaryList$member' => NULL, ], ], 'ChannelAssociatedWithFlowSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListChannelsAssociatedWithChannelFlowResponse$Channels' => '<p>The information about each channel.</p>', ], ], 'ChannelBan' => [ 'base' => '<p>The details of a channel ban.</p>', 'refs' => [ 'DescribeChannelBanResponse$ChannelBan' => '<p>The details of the ban.</p>', ], ], 'ChannelBanSummary' => [ 'base' => '<p>Summary of the details of a <code>ChannelBan</code>.</p>', 'refs' => [ 'ChannelBanSummaryList$member' => NULL, ], ], 'ChannelBanSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListChannelBansResponse$ChannelBans' => '<p>The information for each requested ban.</p>', ], ], 'ChannelFlow' => [ 'base' => '<p>The details of a channel flow.</p>', 'refs' => [ 'DescribeChannelFlowResponse$ChannelFlow' => '<p>The channel flow details.</p>', ], ], 'ChannelFlowCallbackRequest' => [ 'base' => NULL, 'refs' => [], ], 'ChannelFlowCallbackResponse' => [ 'base' => NULL, 'refs' => [], ], 'ChannelFlowExecutionOrder' => [ 'base' => NULL, 'refs' => [ 'Processor$ExecutionOrder' => '<p>The sequence in which processors run. If you have multiple processors in a channel flow, message processing goes through each processor in the sequence. The value determines the sequence. At this point, we support only 1 processor within a flow.</p>', ], ], 'ChannelFlowSummary' => [ 'base' => '<p>Summary of details of a channel flow.</p>', 'refs' => [ 'ChannelFlowSummaryList$member' => NULL, ], ], 'ChannelFlowSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListChannelFlowsResponse$ChannelFlows' => '<p>The information about each channel flow.</p>', ], ], 'ChannelMembership' => [ 'base' => '<p>The details of a channel member.</p>', 'refs' => [ 'DescribeChannelMembershipResponse$ChannelMembership' => '<p>The details of the membership.</p>', ], ], 'ChannelMembershipForAppInstanceUserSummary' => [ 'base' => '<p>Summary of the channel membership details of an <code>AppInstanceUser</code>.</p>', 'refs' => [ 'ChannelMembershipForAppInstanceUserSummaryList$member' => NULL, 'DescribeChannelMembershipForAppInstanceUserResponse$ChannelMembership' => '<p>The channel to which a user belongs.</p>', ], ], 'ChannelMembershipForAppInstanceUserSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListChannelMembershipsForAppInstanceUserResponse$ChannelMemberships' => '<p>The token passed by previous API calls until all requested users are returned.</p>', ], ], 'ChannelMembershipPreferences' => [ 'base' => '<p>The channel membership preferences for an <code>AppInstanceUser</code>.</p>', 'refs' => [ 'GetChannelMembershipPreferencesResponse$Preferences' => '<p>The channel membership preferences for an <code>AppInstanceUser</code> .</p>', 'PutChannelMembershipPreferencesRequest$Preferences' => '<p>The channel membership preferences of an <code>AppInstanceUser</code> .</p>', 'PutChannelMembershipPreferencesResponse$Preferences' => '<p>The ARN and metadata of the member being added.</p>', ], ], 'ChannelMembershipSummary' => [ 'base' => '<p>Summary of the details of a <code>ChannelMembership</code>.</p>', 'refs' => [ 'ChannelMembershipSummaryList$member' => NULL, ], ], 'ChannelMembershipSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListChannelMembershipsResponse$ChannelMemberships' => '<p>The information for the requested channel memberships.</p>', ], ], 'ChannelMembershipType' => [ 'base' => NULL, 'refs' => [ 'AppInstanceUserMembershipSummary$Type' => '<p>The type of <code>ChannelMembership</code>.</p>', 'BatchChannelMemberships$Type' => '<p>The membership types set for the channel users.</p>', 'BatchCreateChannelMembershipRequest$Type' => '<p>The membership type of a user, <code>DEFAULT</code> or <code>HIDDEN</code>. Default members are always returned as part of <code>ListChannelMemberships</code>. Hidden members are only returned if the type filter in <code>ListChannelMemberships</code> equals <code>HIDDEN</code>. Otherwise hidden members are not returned. This is only supported by moderators.</p>', 'ChannelMembership$Type' => '<p>The membership type set for the channel member.</p>', 'CreateChannelMembershipRequest$Type' => '<p>The membership type of a user, <code>DEFAULT</code> or <code>HIDDEN</code>. Default members are always returned as part of <code>ListChannelMemberships</code>. Hidden members are only returned if the type filter in <code>ListChannelMemberships</code> equals <code>HIDDEN</code>. Otherwise hidden members are not returned. This is only supported by moderators.</p>', 'ListChannelMembershipsRequest$Type' => '<p>The membership type of a user, <code>DEFAULT</code> or <code>HIDDEN</code>. Default members are always returned as part of <code>ListChannelMemberships</code>. Hidden members are only returned if the type filter in <code>ListChannelMemberships</code> equals <code>HIDDEN</code>. Otherwise hidden members are not returned.</p>', ], ], 'ChannelMessage' => [ 'base' => '<p>The details of a message in a channel.</p>', 'refs' => [ 'GetChannelMessageResponse$ChannelMessage' => '<p>The details of and content in the message.</p>', ], ], 'ChannelMessageCallback' => [ 'base' => '<p>Stores information about a callback.</p>', 'refs' => [ 'ChannelFlowCallbackRequest$ChannelMessage' => '<p>Stores information about the processed message.</p>', ], ], 'ChannelMessagePersistenceType' => [ 'base' => NULL, 'refs' => [ 'ChannelMessage$Persistence' => '<p>The persistence setting for a channel message.</p>', 'SendChannelMessageRequest$Persistence' => '<p>Boolean that controls whether the message is persisted on the back end. Required.</p>', ], ], 'ChannelMessageStatus' => [ 'base' => NULL, 'refs' => [ 'ChannelMessageStatusStructure$Value' => '<p>The message status value.</p>', ], ], 'ChannelMessageStatusStructure' => [ 'base' => '<p>Stores information about a message status.</p>', 'refs' => [ 'ChannelMessage$Status' => '<p>The status of the channel message.</p>', 'ChannelMessageSummary$Status' => '<p>The message status. The status value is <code>SENT</code> for messages sent to a channel without a channel flow. For channels associated with channel flow, the value determines the processing stage.</p>', 'GetChannelMessageStatusResponse$Status' => '<p>The message status and details.</p>', 'SendChannelMessageResponse$Status' => '<p>The status of the channel message.</p>', 'UpdateChannelMessageResponse$Status' => '<p>The status of the message update.</p>', ], ], 'ChannelMessageSummary' => [ 'base' => '<p>Summary of the messages in a <code>Channel</code>.</p>', 'refs' => [ 'ChannelMessageSummaryList$member' => NULL, ], ], 'ChannelMessageSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListChannelMessagesResponse$ChannelMessages' => '<p>The information about, and content of, each requested message.</p>', ], ], 'ChannelMessageType' => [ 'base' => NULL, 'refs' => [ 'ChannelMessage$Type' => '<p>The message type.</p>', 'ChannelMessageSummary$Type' => '<p>The type of message.</p>', 'SendChannelMessageRequest$Type' => '<p>The type of message, <code>STANDARD</code> or <code>CONTROL</code>.</p>', ], ], 'ChannelMode' => [ 'base' => NULL, 'refs' => [ 'Channel$Mode' => '<p>The mode of the channel.</p>', 'ChannelAssociatedWithFlowSummary$Mode' => '<p>The mode of the channel.</p>', 'ChannelSummary$Mode' => '<p>The mode of the channel.</p>', 'CreateChannelRequest$Mode' => '<p>The channel mode: <code>UNRESTRICTED</code> or <code>RESTRICTED</code>. Administrators, moderators, and channel members can add themselves and other members to unrestricted channels. Only administrators and moderators can add members to restricted channels.</p>', 'UpdateChannelRequest$Mode' => '<p>The mode of the update request.</p>', ], ], 'ChannelModeratedByAppInstanceUserSummary' => [ 'base' => '<p>Summary of the details of a moderated channel.</p>', 'refs' => [ 'ChannelModeratedByAppInstanceUserSummaryList$member' => NULL, 'DescribeChannelModeratedByAppInstanceUserResponse$Channel' => '<p>The moderated channel.</p>', ], ], 'ChannelModeratedByAppInstanceUserSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListChannelsModeratedByAppInstanceUserResponse$Channels' => '<p>The moderated channels in the request.</p>', ], ], 'ChannelModerator' => [ 'base' => '<p>The details of a channel moderator.</p>', 'refs' => [ 'DescribeChannelModeratorResponse$ChannelModerator' => '<p>The details of the channel moderator.</p>', ], ], 'ChannelModeratorSummary' => [ 'base' => '<p>Summary of the details of a <code>ChannelModerator</code>.</p>', 'refs' => [ 'ChannelModeratorSummaryList$member' => NULL, ], ], 'ChannelModeratorSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListChannelModeratorsResponse$ChannelModerators' => '<p>The information about and names of each moderator.</p>', ], ], 'ChannelPrivacy' => [ 'base' => NULL, 'refs' => [ 'Channel$Privacy' => '<p>The channel\'s privacy setting.</p>', 'ChannelAssociatedWithFlowSummary$Privacy' => '<p>The channel\'s privacy setting.</p>', 'ChannelSummary$Privacy' => '<p>The privacy setting of the channel.</p>', 'CreateChannelRequest$Privacy' => '<p>The channel\'s privacy level: <code>PUBLIC</code> or <code>PRIVATE</code>. Private channels aren\'t discoverable by users outside the channel. Public channels are discoverable by anyone in the <code>AppInstance</code>.</p>', 'ListChannelsRequest$Privacy' => '<p>The privacy setting. <code>PUBLIC</code> retrieves all the public channels. <code>PRIVATE</code> retrieves private channels. Only an <code>AppInstanceAdmin</code> can retrieve private channels. </p>', ], ], 'ChannelSummary' => [ 'base' => '<p>Summary of the details of a <code>Channel</code>.</p>', 'refs' => [ 'ChannelMembershipForAppInstanceUserSummary$ChannelSummary' => '<p>Returns the channel data for an <code>AppInstance</code>.</p>', 'ChannelModeratedByAppInstanceUserSummary$ChannelSummary' => '<p>Summary of the details of a <code>Channel</code>.</p>', 'ChannelSummaryList$member' => NULL, ], ], 'ChannelSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListChannelsResponse$Channels' => '<p>The information about each channel.</p>', ], ], 'ChimeArn' => [ 'base' => NULL, 'refs' => [ 'AssociateChannelFlowRequest$ChannelArn' => '<p>The ARN of the channel.</p>', 'AssociateChannelFlowRequest$ChannelFlowArn' => '<p>The ARN of the channel flow.</p>', 'AssociateChannelFlowRequest$ChimeBearer' => '<p>The <code>AppInstanceUserArn</code> of the user making the API call.</p>', 'BatchChannelMemberships$ChannelArn' => '<p>The ARN of the channel to which you\'re adding users.</p>', 'BatchCreateChannelMembershipError$MemberArn' => '<p>The <code>AppInstanceUserArn</code> of the member that the service couldn\'t add.</p>', 'BatchCreateChannelMembershipRequest$ChannelArn' => '<p>The ARN of the channel to which you\'re adding users.</p>', 'BatchCreateChannelMembershipRequest$ChimeBearer' => '<p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>', 'Channel$ChannelArn' => '<p>The ARN of a channel.</p>', 'Channel$ChannelFlowArn' => '<p>The ARN of the channel flow.</p>', 'ChannelAssociatedWithFlowSummary$ChannelArn' => '<p>The ARN of the channel.</p>', 'ChannelBan$ChannelArn' => '<p>The ARN of the channel from which a member is being banned.</p>', 'ChannelFlow$ChannelFlowArn' => '<p>The ARN of the channel flow.</p>', 'ChannelFlowCallbackRequest$ChannelArn' => '<p>The ARN of the channel.</p>', 'ChannelFlowCallbackResponse$ChannelArn' => '<p>The ARN of the channel.</p>', 'ChannelFlowSummary$ChannelFlowArn' => '<p>The ARN of the channel flow.</p>', 'ChannelMembership$ChannelArn' => '<p>The ARN of the member\'s channel.</p>', 'ChannelMessage$ChannelArn' => '<p>The ARN of the channel.</p>', 'ChannelModerator$ChannelArn' => '<p>The ARN of the moderator\'s channel.</p>', 'ChannelSummary$ChannelArn' => '<p>The ARN of the channel.</p>', 'CreateChannelBanRequest$ChannelArn' => '<p>The ARN of the ban request.</p>', 'CreateChannelBanRequest$MemberArn' => '<p>The <code>AppInstanceUserArn</code> of the member being banned.</p>', 'CreateChannelBanRequest$ChimeBearer' => '<p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>', 'CreateChannelBanResponse$ChannelArn' => '<p>The ARN of the response to the ban request.</p>', 'CreateChannelFlowRequest$AppInstanceArn' => '<p>The ARN of the channel flow request.</p>', 'CreateChannelFlowResponse$ChannelFlowArn' => '<p>The ARN of the channel flow.</p>', 'CreateChannelMembershipRequest$ChannelArn' => '<p>The ARN of the channel to which you\'re adding users.</p>', 'CreateChannelMembershipRequest$MemberArn' => '<p>The <code>AppInstanceUserArn</code> of the member you want to add to the channel.</p>', 'CreateChannelMembershipRequest$ChimeBearer' => '<p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>', 'CreateChannelMembershipResponse$ChannelArn' => '<p>The ARN of the channel.</p>', 'CreateChannelModeratorRequest$ChannelArn' => '<p>The ARN of the channel.</p>', 'CreateChannelModeratorRequest$ChannelModeratorArn' => '<p>The <code>AppInstanceUserArn</code> of the moderator.</p>', 'CreateChannelModeratorRequest$ChimeBearer' => '<p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>', 'CreateChannelModeratorResponse$ChannelArn' => '<p>The ARN of the channel.</p>', 'CreateChannelRequest$AppInstanceArn' => '<p>The ARN of the channel request.</p>', 'CreateChannelRequest$ChimeBearer' => '<p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>', 'CreateChannelResponse$ChannelArn' => '<p>The ARN of the channel.</p>', 'DeleteChannelBanRequest$ChannelArn' => '<p>The ARN of the channel from which the <code>AppInstanceUser</code> was banned.</p>', 'DeleteChannelBanRequest$MemberArn' => '<p>The ARN of the <code>AppInstanceUser</code> that you want to reinstate.</p>', 'DeleteChannelBanRequest$ChimeBearer' => '<p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>', 'DeleteChannelFlowRequest$ChannelFlowArn' => '<p>The ARN of the channel flow.</p>', 'DeleteChannelMembershipRequest$ChannelArn' => '<p>The ARN of the channel from which you want to remove the user.</p>', 'DeleteChannelMembershipRequest$MemberArn' => '<p>The <code>AppInstanceUserArn</code> of the member that you\'re removing from the channel.</p>', 'DeleteChannelMembershipRequest$ChimeBearer' => '<p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>', 'DeleteChannelMessageRequest$ChannelArn' => '<p>The ARN of the channel.</p>', 'DeleteChannelMessageRequest$ChimeBearer' => '<p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>', 'DeleteChannelModeratorRequest$ChannelArn' => '<p>The ARN of the channel.</p>', 'DeleteChannelModeratorRequest$ChannelModeratorArn' => '<p>The <code>AppInstanceUserArn</code> of the moderator being deleted.</p>', 'DeleteChannelModeratorRequest$ChimeBearer' => '<p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>', 'DeleteChannelRequest$ChannelArn' => '<p>The ARN of the channel being deleted.</p>', 'DeleteChannelRequest$ChimeBearer' => '<p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>', 'DescribeChannelBanRequest$ChannelArn' => '<p>The ARN of the channel from which the user is banned.</p>', 'DescribeChannelBanRequest$MemberArn' => '<p>The <code>AppInstanceUserArn</code> of the member being banned.</p>', 'DescribeChannelBanRequest$ChimeBearer' => '<p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>', 'DescribeChannelFlowRequest$ChannelFlowArn' => '<p>The ARN of the channel flow.</p>', 'DescribeChannelMembershipForAppInstanceUserRequest$ChannelArn' => '<p>The ARN of the channel to which the user belongs.</p>', 'DescribeChannelMembershipForAppInstanceUserRequest$AppInstanceUserArn' => '<p>The ARN of the user in a channel.</p>', 'DescribeChannelMembershipForAppInstanceUserRequest$ChimeBearer' => '<p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>', 'DescribeChannelMembershipRequest$ChannelArn' => '<p>The ARN of the channel.</p>', 'DescribeChannelMembershipRequest$MemberArn' => '<p>The <code>AppInstanceUserArn</code> of the member.</p>', 'DescribeChannelMembershipRequest$ChimeBearer' => '<p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>', 'DescribeChannelModeratedByAppInstanceUserRequest$ChannelArn' => '<p>The ARN of the moderated channel.</p>', 'DescribeChannelModeratedByAppInstanceUserRequest$AppInstanceUserArn' => '<p>The ARN of the <code>AppInstanceUser</code> in the moderated channel.</p>', 'DescribeChannelModeratedByAppInstanceUserRequest$ChimeBearer' => '<p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>', 'DescribeChannelModeratorRequest$ChannelArn' => '<p>The ARN of the channel.</p>', 'DescribeChannelModeratorRequest$ChannelModeratorArn' => '<p>The <code>AppInstanceUserArn</code> of the channel moderator.</p>', 'DescribeChannelModeratorRequest$ChimeBearer' => '<p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>', 'DescribeChannelRequest$ChannelArn' => '<p>The ARN of the channel.</p>', 'DescribeChannelRequest$ChimeBearer' => '<p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>', 'DisassociateChannelFlowRequest$ChannelArn' => '<p>The ARN of the channel.</p>', 'DisassociateChannelFlowRequest$ChannelFlowArn' => '<p>The ARN of the channel flow.</p>', 'DisassociateChannelFlowRequest$ChimeBearer' => '<p>The <code>AppInstanceUserArn</code> of the user making the API call.</p>', 'GetChannelMembershipPreferencesRequest$ChannelArn' => '<p>The ARN of the channel.</p>', 'GetChannelMembershipPreferencesRequest$MemberArn' => '<p>The <code>AppInstanceUserArn</code> of the member retrieving the preferences.</p>', 'GetChannelMembershipPreferencesRequest$ChimeBearer' => '<p>The <code>AppInstanceUserARN</code> of the user making the API call.</p>', 'GetChannelMembershipPreferencesResponse$ChannelArn' => '<p>The ARN of the channel.</p>', 'GetChannelMessageRequest$ChannelArn' => '<p>The ARN of the channel.</p>', 'GetChannelMessageRequest$ChimeBearer' => '<p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>', 'GetChannelMessageStatusRequest$ChannelArn' => '<p>The ARN of the channel</p>', 'GetChannelMessageStatusRequest$ChimeBearer' => '<p>The <code>AppInstanceUserArn</code> of the user making the API call.</p>', 'Identity$Arn' => '<p>The ARN in an Identity.</p>', 'ListChannelBansRequest$ChannelArn' => '<p>The ARN of the channel.</p>', 'ListChannelBansRequest$ChimeBearer' => '<p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>', 'ListChannelBansResponse$ChannelArn' => '<p>The ARN of the channel.</p>', 'ListChannelFlowsRequest$AppInstanceArn' => '<p>The ARN of the app instance.</p>', 'ListChannelMembershipsForAppInstanceUserRequest$AppInstanceUserArn' => '<p>The ARN of the <code>AppInstanceUser</code>s</p>', 'ListChannelMembershipsForAppInstanceUserRequest$ChimeBearer' => '<p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>', 'ListChannelMembershipsRequest$ChannelArn' => '<p>The maximum number of channel memberships that you want returned.</p>', 'ListChannelMembershipsRequest$ChimeBearer' => '<p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>', 'ListChannelMembershipsResponse$ChannelArn' => '<p>The ARN of the channel.</p>', 'ListChannelMessagesRequest$ChannelArn' => '<p>The ARN of the channel.</p>', 'ListChannelMessagesRequest$ChimeBearer' => '<p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>', 'ListChannelMessagesResponse$ChannelArn' => '<p>The ARN of the channel containing the requested messages.</p>', 'ListChannelModeratorsRequest$ChannelArn' => '<p>The ARN of the channel.</p>', 'ListChannelModeratorsRequest$ChimeBearer' => '<p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>', 'ListChannelModeratorsResponse$ChannelArn' => '<p>The ARN of the channel.</p>', 'ListChannelsAssociatedWithChannelFlowRequest$ChannelFlowArn' => '<p>The ARN of the channel flow.</p>', 'ListChannelsModeratedByAppInstanceUserRequest$AppInstanceUserArn' => '<p>The ARN of the user in the moderated channel.</p>', 'ListChannelsModeratedByAppInstanceUserRequest$ChimeBearer' => '<p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>', 'ListChannelsRequest$AppInstanceArn' => '<p>The ARN of the <code>AppInstance</code>.</p>', 'ListChannelsRequest$ChimeBearer' => '<p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>', 'ListTagsForResourceRequest$ResourceARN' => '<p>The ARN of the resource.</p>', 'MemberArns$member' => NULL, 'PutChannelMembershipPreferencesRequest$ChannelArn' => '<p>The ARN of the channel.</p>', 'PutChannelMembershipPreferencesRequest$MemberArn' => '<p>The <code>AppInstanceUserArn</code> of the member setting the preferences.</p>', 'PutChannelMembershipPreferencesRequest$ChimeBearer' => '<p>The <code>AppInstanceUserARN</code> of the user making the API call.</p>', 'PutChannelMembershipPreferencesResponse$ChannelArn' => '<p>The ARN of the channel.</p>', 'RedactChannelMessageRequest$ChannelArn' => '<p>The ARN of the channel containing the messages that you want to redact.</p>', 'RedactChannelMessageRequest$ChimeBearer' => '<p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>', 'RedactChannelMessageResponse$ChannelArn' => '<p>The ARN of the channel containing the messages that you want to redact.</p>', 'SendChannelMessageRequest$ChannelArn' => '<p>The ARN of the channel.</p>', 'SendChannelMessageRequest$ChimeBearer' => '<p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>', 'SendChannelMessageResponse$ChannelArn' => '<p>The ARN of the channel.</p>', 'TagResourceRequest$ResourceARN' => '<p>The resource ARN.</p>', 'UntagResourceRequest$ResourceARN' => '<p>The resource ARN.</p>', 'UpdateChannelFlowRequest$ChannelFlowArn' => '<p>The ARN of the channel flow.</p>', 'UpdateChannelFlowResponse$ChannelFlowArn' => '<p>The ARN of the channel flow.</p>', 'UpdateChannelMessageRequest$ChannelArn' => '<p>The ARN of the channel.</p>', 'UpdateChannelMessageRequest$ChimeBearer' => '<p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>', 'UpdateChannelMessageResponse$ChannelArn' => '<p>The ARN of the channel.</p>', 'UpdateChannelReadMarkerRequest$ChannelArn' => '<p>The ARN of the channel.</p>', 'UpdateChannelReadMarkerRequest$ChimeBearer' => '<p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>', 'UpdateChannelReadMarkerResponse$ChannelArn' => '<p>The ARN of the channel.</p>', 'UpdateChannelRequest$ChannelArn' => '<p>The ARN of the channel.</p>', 'UpdateChannelRequest$ChimeBearer' => '<p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>', 'UpdateChannelResponse$ChannelArn' => '<p>The ARN of the channel.</p>', ], ], 'ClientRequestToken' => [ 'base' => NULL, 'refs' => [ 'CreateChannelFlowRequest$ClientRequestToken' => '<p>The client token for the request. An Idempotency token.</p>', 'CreateChannelRequest$ClientRequestToken' => '<p>The client token for the request. An <code>Idempotency</code> token.</p>', 'SendChannelMessageRequest$ClientRequestToken' => '<p>The <code>Idempotency</code> token for each client request.</p>', ], ], 'ConflictException' => [ 'base' => '<p>The request could not be processed because of conflict in the current state of the resource.</p>', 'refs' => [], ], 'Content' => [ 'base' => NULL, 'refs' => [ 'ChannelMessage$Content' => '<p>The message content.</p>', 'ChannelMessageSummary$Content' => '<p>The content of the message.</p>', 'UpdateChannelMessageRequest$Content' => '<p>The content of the message being updated.</p>', ], ], 'CreateChannelBanRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateChannelBanResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateChannelFlowRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateChannelFlowResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateChannelMembershipRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateChannelMembershipResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateChannelModeratorRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateChannelModeratorResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateChannelRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateChannelResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteChannelBanRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteChannelFlowRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteChannelMembershipRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteChannelMessageRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteChannelModeratorRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteChannelRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeChannelBanRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeChannelBanResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeChannelFlowRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeChannelFlowResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeChannelMembershipForAppInstanceUserRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeChannelMembershipForAppInstanceUserResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeChannelMembershipRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeChannelMembershipResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeChannelModeratedByAppInstanceUserRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeChannelModeratedByAppInstanceUserResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeChannelModeratorRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeChannelModeratorResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeChannelRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeChannelResponse' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateChannelFlowRequest' => [ 'base' => NULL, 'refs' => [], ], 'ErrorCode' => [ 'base' => NULL, 'refs' => [ 'BadRequestException$Code' => NULL, 'BatchCreateChannelMembershipError$ErrorCode' => '<p>The error code.</p>', 'ConflictException$Code' => NULL, 'ForbiddenException$Code' => NULL, 'NotFoundException$Code' => NULL, 'ResourceLimitExceededException$Code' => NULL, 'ServiceFailureException$Code' => NULL, 'ServiceUnavailableException$Code' => NULL, 'ThrottledClientException$Code' => NULL, 'UnauthorizedClientException$Code' => NULL, ], ], 'FallbackAction' => [ 'base' => NULL, 'refs' => [ 'Processor$FallbackAction' => '<p>Determines whether to continue with message processing or stop it in cases where communication with a processor fails. If a processor has a fallback action of <code>ABORT</code> and communication with it fails, the processor sets the message status to <code>FAILED</code> and does not send the message to any recipients. Note that if the last processor in the channel flow sequence has a fallback action of <code>CONTINUE</code> and communication with the processor fails, then the message is considered processed and sent to recipients of the channel.</p>', ], ], 'FilterRule' => [ 'base' => NULL, 'refs' => [ 'PushNotificationPreferences$FilterRule' => '<p>The simple JSON object used to send a subset of a push notification to the requsted member.</p>', ], ], 'ForbiddenException' => [ 'base' => '<p>The client is permanently forbidden from making the request.</p>', 'refs' => [], ], 'GetChannelMembershipPreferencesRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetChannelMembershipPreferencesResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetChannelMessageRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetChannelMessageResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetChannelMessageStatusRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetChannelMessageStatusResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetMessagingSessionEndpointRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetMessagingSessionEndpointResponse' => [ 'base' => NULL, 'refs' => [], ], 'Identity' => [ 'base' => '<p>The details of a user.</p>', 'refs' => [ 'BatchChannelMemberships$InvitedBy' => '<p>The identifier of the member who invited another member.</p>', 'Channel$CreatedBy' => '<p>The <code>AppInstanceUser</code> who created the channel.</p>', 'ChannelBan$Member' => '<p>The member being banned from the channel.</p>', 'ChannelBan$CreatedBy' => '<p>The <code>AppInstanceUser</code> who created the ban.</p>', 'ChannelBanSummary$Member' => '<p>The member being banned from a channel.</p>', 'ChannelMembership$InvitedBy' => '<p>The identifier of the member who invited another member.</p>', 'ChannelMembership$Member' => '<p>The data of the channel member.</p>', 'ChannelMembershipSummary$Member' => '<p>A member\'s summary data.</p>', 'ChannelMessage$Sender' => '<p>The message sender.</p>', 'ChannelMessageSummary$Sender' => '<p>The message sender.</p>', 'ChannelModerator$Moderator' => '<p>The moderator\'s data.</p>', 'ChannelModerator$CreatedBy' => '<p>The <code>AppInstanceUser</code> who created the moderator.</p>', 'ChannelModeratorSummary$Moderator' => '<p>The data for a moderator.</p>', 'CreateChannelBanResponse$Member' => '<p>The <code>ChannelArn</code> and <code>BannedIdentity</code> of the member in the ban response.</p>', 'CreateChannelMembershipResponse$Member' => '<p>The ARN and metadata of the member being added.</p>', 'CreateChannelModeratorResponse$ChannelModerator' => '<p>The ARNs of the channel and the moderator.</p>', 'GetChannelMembershipPreferencesResponse$Member' => NULL, 'Members$member' => NULL, 'PutChannelMembershipPreferencesResponse$Member' => NULL, ], ], 'InvocationType' => [ 'base' => NULL, 'refs' => [ 'LambdaConfiguration$InvocationType' => '<p>Controls how the Lambda function is invoked.</p>', ], ], 'LambdaConfiguration' => [ 'base' => '<p>Stores metadata about a Lambda processor.</p>', 'refs' => [ 'ProcessorConfiguration$Lambda' => '<p>Indicates that the processor is of type Lambda.</p>', ], ], 'LambdaFunctionArn' => [ 'base' => NULL, 'refs' => [ 'LambdaConfiguration$ResourceArn' => '<p>The ARN of the Lambda message processing function.</p>', ], ], 'ListChannelBansRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListChannelBansResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListChannelFlowsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListChannelFlowsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListChannelMembershipsForAppInstanceUserRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListChannelMembershipsForAppInstanceUserResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListChannelMembershipsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListChannelMembershipsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListChannelMessagesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListChannelMessagesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListChannelModeratorsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListChannelModeratorsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListChannelsAssociatedWithChannelFlowRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListChannelsAssociatedWithChannelFlowResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListChannelsModeratedByAppInstanceUserRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListChannelsModeratedByAppInstanceUserResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListChannelsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListChannelsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'MaxResults' => [ 'base' => NULL, 'refs' => [ 'ListChannelBansRequest$MaxResults' => '<p>The maximum number of bans that you want returned.</p>', 'ListChannelFlowsRequest$MaxResults' => '<p>The maximum number of channel flows that you want to return.</p>', 'ListChannelMembershipsForAppInstanceUserRequest$MaxResults' => '<p>The maximum number of users that you want returned.</p>', 'ListChannelMembershipsRequest$MaxResults' => '<p>The maximum number of channel memberships that you want returned.</p>', 'ListChannelMessagesRequest$MaxResults' => '<p>The maximum number of messages that you want returned.</p>', 'ListChannelModeratorsRequest$MaxResults' => '<p>The maximum number of moderators that you want returned.</p>', 'ListChannelsAssociatedWithChannelFlowRequest$MaxResults' => '<p>The maximum number of channels that you want to return.</p>', 'ListChannelsModeratedByAppInstanceUserRequest$MaxResults' => '<p>The maximum number of channels in the request.</p>', 'ListChannelsRequest$MaxResults' => '<p>The maximum number of channels that you want to return.</p>', ], ], 'MemberArns' => [ 'base' => NULL, 'refs' => [ 'BatchCreateChannelMembershipRequest$MemberArns' => '<p>The <code>AppInstanceUserArn</code>s of the members you want to add to the channel.</p>', ], ], 'Members' => [ 'base' => NULL, 'refs' => [ 'BatchChannelMemberships$Members' => '<p>The users successfully added to the request.</p>', ], ], 'MessageAttributeMap' => [ 'base' => NULL, 'refs' => [ 'ChannelMessage$MessageAttributes' => '<p>The attributes for the message, used for message filtering along with a <code>FilterRule</code> defined in the <code>PushNotificationPreferences</code>.</p>', 'ChannelMessageSummary$MessageAttributes' => '<p>The message attribues listed in a the summary of a channel message.</p>', 'SendChannelMessageRequest$MessageAttributes' => '<p>The attributes for the message, used for message filtering along with a <code>FilterRule</code> defined in the <code>PushNotificationPreferences</code>.</p>', ], ], 'MessageAttributeName' => [ 'base' => NULL, 'refs' => [ 'MessageAttributeMap$key' => NULL, ], ], 'MessageAttributeStringValue' => [ 'base' => NULL, 'refs' => [ 'MessageAttributeStringValues$member' => NULL, ], ], 'MessageAttributeStringValues' => [ 'base' => NULL, 'refs' => [ 'MessageAttributeValue$StringValues' => '<p>The strings in a message attribute value.</p>', ], ], 'MessageAttributeValue' => [ 'base' => '<p>A list of message attribute values.</p>', 'refs' => [ 'MessageAttributeMap$value' => NULL, ], ], 'MessageId' => [ 'base' => NULL, 'refs' => [ 'ChannelMessage$MessageId' => '<p>The ID of a message.</p>', 'ChannelMessageCallback$MessageId' => '<p>The message ID.</p>', 'ChannelMessageSummary$MessageId' => '<p>The ID of the message.</p>', 'DeleteChannelMessageRequest$MessageId' => '<p>The ID of the message being deleted.</p>', 'GetChannelMessageRequest$MessageId' => '<p>The ID of the message.</p>', 'GetChannelMessageStatusRequest$MessageId' => '<p>The ID of the message.</p>', 'RedactChannelMessageRequest$MessageId' => '<p>The ID of the message being redacted.</p>', 'RedactChannelMessageResponse$MessageId' => '<p>The ID of the message being redacted.</p>', 'SendChannelMessageResponse$MessageId' => '<p>The ID string assigned to each message.</p>', 'UpdateChannelMessageRequest$MessageId' => '<p>The ID string of the message being updated.</p>', 'UpdateChannelMessageResponse$MessageId' => '<p>The ID string of the message being updated.</p>', ], ], 'MessagingSessionEndpoint' => [ 'base' => '<p>The websocket endpoint used to connect to Amazon Chime SDK messaging.</p>', 'refs' => [ 'GetMessagingSessionEndpointResponse$Endpoint' => '<p>The endpoint returned in the response.</p>', ], ], 'Metadata' => [ 'base' => NULL, 'refs' => [ 'Channel$Metadata' => '<p>The channel\'s metadata.</p>', 'ChannelAssociatedWithFlowSummary$Metadata' => '<p>The channel\'s metadata.</p>', 'ChannelMessage$Metadata' => '<p>The message metadata.</p>', 'ChannelMessageCallback$Metadata' => '<p>The message metadata.</p>', 'ChannelMessageSummary$Metadata' => '<p>The metadata of the message.</p>', 'ChannelSummary$Metadata' => '<p>The metadata of the channel.</p>', 'CreateChannelRequest$Metadata' => '<p>The metadata of the creation request. Limited to 1KB and UTF-8.</p>', 'SendChannelMessageRequest$Metadata' => '<p>The optional metadata for each message.</p>', 'UpdateChannelMessageRequest$Metadata' => '<p>The metadata of the message being updated.</p>', 'UpdateChannelRequest$Metadata' => '<p>The metadata for the update request.</p>', ], ], 'NextToken' => [ 'base' => NULL, 'refs' => [ 'ListChannelBansRequest$NextToken' => '<p>The token passed by previous API calls until all requested bans are returned.</p>', 'ListChannelBansResponse$NextToken' => '<p>The token passed by previous API calls until all requested bans are returned.</p>', 'ListChannelFlowsRequest$NextToken' => '<p>The token passed by previous API calls until all requested channel flows are returned.</p>', 'ListChannelFlowsResponse$NextToken' => '<p>The token passed by previous API calls until all requested channels are returned.</p>', 'ListChannelMembershipsForAppInstanceUserRequest$NextToken' => '<p>The token returned from previous API requests until the number of channel memberships is reached.</p>', 'ListChannelMembershipsForAppInstanceUserResponse$NextToken' => '<p>The token passed by previous API calls until all requested users are returned.</p>', 'ListChannelMembershipsRequest$NextToken' => '<p>The token passed by previous API calls until all requested channel memberships are returned.</p>', 'ListChannelMembershipsResponse$NextToken' => '<p>The token passed by previous API calls until all requested channel memberships are returned.</p>', 'ListChannelMessagesRequest$NextToken' => '<p>The token passed by previous API calls until all requested messages are returned.</p>', 'ListChannelMessagesResponse$NextToken' => '<p>The token passed by previous API calls until all requested messages are returned.</p>', 'ListChannelModeratorsRequest$NextToken' => '<p>The token passed by previous API calls until all requested moderators are returned.</p>', 'ListChannelModeratorsResponse$NextToken' => '<p>The token passed by previous API calls until all requested moderators are returned.</p>', 'ListChannelsAssociatedWithChannelFlowRequest$NextToken' => '<p>The token passed by previous API calls until all requested channels are returned.</p>', 'ListChannelsAssociatedWithChannelFlowResponse$NextToken' => '<p>The token passed by previous API calls until all requested channels are returned.</p>', 'ListChannelsModeratedByAppInstanceUserRequest$NextToken' => '<p>The token returned from previous API requests until the number of channels moderated by the user is reached.</p>', 'ListChannelsModeratedByAppInstanceUserResponse$NextToken' => '<p>The token returned from previous API requests until the number of channels moderated by the user is reached.</p>', 'ListChannelsRequest$NextToken' => '<p>The token passed by previous API calls until all requested channels are returned.</p>', 'ListChannelsResponse$NextToken' => '<p>The token returned from previous API requests until the number of channels is reached.</p>', ], ], 'NonEmptyContent' => [ 'base' => NULL, 'refs' => [ 'ChannelMessageCallback$Content' => '<p>The message content.</p>', 'SendChannelMessageRequest$Content' => '<p>The content of the message.</p>', ], ], 'NonEmptyResourceName' => [ 'base' => NULL, 'refs' => [ 'Channel$Name' => '<p>The name of a channel.</p>', 'ChannelAssociatedWithFlowSummary$Name' => '<p>The name of the channel flow.</p>', 'ChannelFlow$Name' => '<p>The name of the channel flow.</p>', 'ChannelFlowSummary$Name' => '<p>The name of the channel flow.</p>', 'ChannelSummary$Name' => '<p>The name of the channel.</p>', 'CreateChannelFlowRequest$Name' => '<p>The name of the channel flow.</p>', 'CreateChannelRequest$Name' => '<p>The name of the channel.</p>', 'Processor$Name' => '<p>The name of the channel flow.</p>', 'UpdateChannelFlowRequest$Name' => '<p>The name of the channel flow.</p>', 'UpdateChannelRequest$Name' => '<p>The name of the channel.</p>', ], ], 'NonNullableBoolean' => [ 'base' => NULL, 'refs' => [ 'ChannelFlowCallbackRequest$DeleteResource' => '<p>When a processor determines that a message needs to be <code>DENIED</code>, pass this parameter with a value of true.</p>', 'ChannelMessage$Redacted' => '<p>Hides the content of a message.</p>', 'ChannelMessageSummary$Redacted' => '<p>Indicates whether a message was redacted.</p>', ], ], 'NotFoundException' => [ 'base' => '<p>One or more of the resources in the request does not exist in the system.</p>', 'refs' => [], ], 'Processor' => [ 'base' => '<p>The information about a processor in a channel flow.</p>', 'refs' => [ 'ProcessorList$member' => NULL, ], ], 'ProcessorConfiguration' => [ 'base' => '<p>A processor\'s metadata.</p>', 'refs' => [ 'Processor$Configuration' => '<p>The information about the type of processor and its identifier.</p>', ], ], 'ProcessorList' => [ 'base' => NULL, 'refs' => [ 'ChannelFlow$Processors' => '<p>Information about the processor Lambda functions.</p>', 'ChannelFlowSummary$Processors' => '<p>Information about the processor Lambda functions.</p>', 'CreateChannelFlowRequest$Processors' => '<p>Information about the processor Lambda functions.</p>', 'UpdateChannelFlowRequest$Processors' => '<p>Information about the processor Lambda functions </p>', ], ], 'PushNotificationBody' => [ 'base' => NULL, 'refs' => [ 'PushNotificationConfiguration$Body' => '<p>The body of the push notification.</p>', ], ], 'PushNotificationConfiguration' => [ 'base' => '<p>The push notification configuration of the message.</p>', 'refs' => [ 'SendChannelMessageRequest$PushNotification' => '<p>The push notification configuration of the message.</p>', ], ], 'PushNotificationPreferences' => [ 'base' => '<p>The channel membership preferences for push notification.</p>', 'refs' => [ 'ChannelMembershipPreferences$PushNotifications' => '<p>The push notification configuration of a message.</p>', ], ], 'PushNotificationTitle' => [ 'base' => NULL, 'refs' => [ 'PushNotificationConfiguration$Title' => '<p>The title of the push notification.</p>', ], ], 'PushNotificationType' => [ 'base' => NULL, 'refs' => [ 'PushNotificationConfiguration$Type' => '<p>Enum value that indicates the type of the push notification for a message. <code>DEFAULT</code>: Normal mobile push notification. <code>VOIP</code>: VOIP mobile push notification.</p>', ], ], 'PutChannelMembershipPreferencesRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutChannelMembershipPreferencesResponse' => [ 'base' => NULL, 'refs' => [], ], 'RedactChannelMessageRequest' => [ 'base' => NULL, 'refs' => [], ], 'RedactChannelMessageResponse' => [ 'base' => NULL, 'refs' => [], ], 'ResourceLimitExceededException' => [ 'base' => '<p>The request exceeds the resource limit.</p>', 'refs' => [], ], 'ResourceName' => [ 'base' => NULL, 'refs' => [ 'Identity$Name' => '<p>The name in an Identity.</p>', ], ], 'SendChannelMessageRequest' => [ 'base' => NULL, 'refs' => [], ], 'SendChannelMessageResponse' => [ 'base' => NULL, 'refs' => [], ], 'ServiceFailureException' => [ 'base' => '<p>The service encountered an unexpected error.</p>', 'refs' => [], ], 'ServiceUnavailableException' => [ 'base' => '<p>The service is currently unavailable.</p>', 'refs' => [], ], 'SortOrder' => [ 'base' => NULL, 'refs' => [ 'ListChannelMessagesRequest$SortOrder' => '<p>The order in which you want messages sorted. Default is Descending, based on time created.</p>', ], ], 'StatusDetail' => [ 'base' => NULL, 'refs' => [ 'ChannelMessageStatusStructure$Detail' => '<p>Contains more details about the messasge status.</p>', ], ], 'String' => [ 'base' => NULL, 'refs' => [ 'BadRequestException$Message' => NULL, 'BatchCreateChannelMembershipError$ErrorMessage' => '<p>The error message.</p>', 'ConflictException$Message' => NULL, 'ForbiddenException$Message' => NULL, 'NotFoundException$Message' => NULL, 'ResourceLimitExceededException$Message' => NULL, 'ServiceFailureException$Message' => NULL, 'ServiceUnavailableException$Message' => NULL, 'ThrottledClientException$Message' => NULL, 'UnauthorizedClientException$Message' => NULL, ], ], 'Tag' => [ 'base' => '<p>A tag object containing a key-value pair.</p>', 'refs' => [ 'TagList$member' => NULL, ], ], 'TagKey' => [ 'base' => NULL, 'refs' => [ 'Tag$Key' => '<p>The key in a tag.</p>', 'TagKeyList$member' => NULL, ], ], 'TagKeyList' => [ 'base' => NULL, 'refs' => [ 'UntagResourceRequest$TagKeys' => '<p>The tag keys.</p>', ], ], 'TagList' => [ 'base' => NULL, 'refs' => [ 'CreateChannelFlowRequest$Tags' => '<p>The tags for the creation request.</p>', 'CreateChannelRequest$Tags' => '<p>The tags for the creation request.</p>', 'ListTagsForResourceResponse$Tags' => '<p>The tag key-value pairs.</p>', 'TagResourceRequest$Tags' => '<p>The tag key-value pairs.</p>', ], ], 'TagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'TagValue' => [ 'base' => NULL, 'refs' => [ 'Tag$Value' => '<p>The value in a tag.</p>', ], ], 'ThrottledClientException' => [ 'base' => '<p>The client exceeded its request rate limit.</p>', 'refs' => [], ], 'Timestamp' => [ 'base' => NULL, 'refs' => [ 'AppInstanceUserMembershipSummary$ReadMarkerTimestamp' => '<p>The time at which a message was last read.</p>', 'Channel$CreatedTimestamp' => '<p>The time at which the <code>AppInstanceUser</code> created the channel.</p>', 'Channel$LastMessageTimestamp' => '<p>The time at which a member sent the last message in the channel.</p>', 'Channel$LastUpdatedTimestamp' => '<p>The time at which a channel was last updated.</p>', 'ChannelBan$CreatedTimestamp' => '<p>The time at which the ban was created.</p>', 'ChannelFlow$CreatedTimestamp' => '<p>The time at which the channel flow was created.</p>', 'ChannelFlow$LastUpdatedTimestamp' => '<p>The time at which a channel flow was updated.</p>', 'ChannelMembership$CreatedTimestamp' => '<p>The time at which the channel membership was created.</p>', 'ChannelMembership$LastUpdatedTimestamp' => '<p>The time at which a channel membership was last updated.</p>', 'ChannelMessage$CreatedTimestamp' => '<p>The time at which the message was created.</p>', 'ChannelMessage$LastEditedTimestamp' => '<p>The time at which a message was edited.</p>', 'ChannelMessage$LastUpdatedTimestamp' => '<p>The time at which a message was updated.</p>', 'ChannelMessageSummary$CreatedTimestamp' => '<p>The time at which the message summary was created.</p>', 'ChannelMessageSummary$LastUpdatedTimestamp' => '<p>The time at which a message was last updated.</p>', 'ChannelMessageSummary$LastEditedTimestamp' => '<p>The time at which a message was last edited.</p>', 'ChannelModerator$CreatedTimestamp' => '<p>The time at which the moderator was created.</p>', 'ChannelSummary$LastMessageTimestamp' => '<p>The time at which the last message in a channel was sent.</p>', 'ListChannelMessagesRequest$NotBefore' => '<p>The initial or starting time stamp for your requested messages.</p>', 'ListChannelMessagesRequest$NotAfter' => '<p>The final or ending time stamp for your requested messages.</p>', ], ], 'UnauthorizedClientException' => [ 'base' => '<p>The client is not currently authorized to make the request.</p>', 'refs' => [], ], 'UntagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateChannelFlowRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateChannelFlowResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateChannelMessageRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateChannelMessageResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateChannelReadMarkerRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateChannelReadMarkerResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateChannelRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateChannelResponse' => [ 'base' => NULL, 'refs' => [], ], 'UrlType' => [ 'base' => NULL, 'refs' => [ 'MessagingSessionEndpoint$Url' => '<p>The endpoint to which you establish a websocket connection.</p>', ], ], ],];
