<?php
// This file was auto-generated from sdk-root/src/data/backup/2018-11-15/docs-2.json
return [ 'version' => '2.0', 'service' => '<fullname>Backup</fullname> <p>Backup is a unified backup service designed to protect Amazon Web Services services and their associated data. Backup simplifies the creation, migration, restoration, and deletion of backups, while also providing reporting and auditing.</p>', 'operations' => [ 'CreateBackupPlan' => '<p>Creates a backup plan using a backup plan name and backup rules. A backup plan is a document that contains information that Backup uses to schedule tasks that create recovery points for resources.</p> <p>If you call <code>CreateBackupPlan</code> with a plan that already exists, you receive an <code>AlreadyExistsException</code> exception.</p>', 'CreateBackupSelection' => '<p>Creates a JSON document that specifies a set of resources to assign to a backup plan. Resources can be included by specifying patterns for a <code>ListOfTags</code> and selected <code>Resources</code>. </p> <p>For example, consider the following patterns:</p> <ul> <li> <p> <code>Resources: "arn:aws:ec2:region:account-id:volume/volume-id"</code> </p> </li> <li> <p> <code>ConditionKey:"department"</code> </p> <p> <code>ConditionValue:"finance"</code> </p> <p> <code>ConditionType:"StringEquals"</code> </p> </li> <li> <p> <code>ConditionKey:"importance"</code> </p> <p> <code>ConditionValue:"critical"</code> </p> <p> <code>ConditionType:"StringEquals"</code> </p> </li> </ul> <p>Using these patterns would back up all Amazon Elastic Block Store (Amazon EBS) volumes that are tagged as <code>"department=finance"</code>, <code>"importance=critical"</code>, in addition to an EBS volume with the specified volume ID.</p> <p>Resources and conditions are additive in that all resources that match the pattern are selected. This shouldn\'t be confused with a logical AND, where all conditions must match. The matching patterns are logically put together using the OR operator. In other words, all patterns that match are selected for backup.</p>', 'CreateBackupVault' => '<p>Creates a logical container where backups are stored. A <code>CreateBackupVault</code> request includes a name, optionally one or more resource tags, an encryption key, and a request ID.</p> <note> <p>Do not include sensitive data, such as passport numbers, in the name of a backup vault.</p> </note>', 'CreateFramework' => '<p>Creates a framework with one or more controls. A framework is a collection of controls that you can use to evaluate your backup practices. By using pre-built customizable controls to define your policies, you can evaluate whether your backup practices comply with your policies and which resources are not yet in compliance.</p>', 'CreateReportPlan' => '<p>Creates a report plan. A report plan is a document that contains information about the contents of the report and where Backup will deliver it.</p> <p>If you call <code>CreateReportPlan</code> with a plan that already exists, you receive an <code>AlreadyExistsException</code> exception.</p>', 'DeleteBackupPlan' => '<p>Deletes a backup plan. A backup plan can only be deleted after all associated selections of resources have been deleted. Deleting a backup plan deletes the current version of a backup plan. Previous versions, if any, will still exist.</p>', 'DeleteBackupSelection' => '<p>Deletes the resource selection associated with a backup plan that is specified by the <code>SelectionId</code>.</p>', 'DeleteBackupVault' => '<p>Deletes the backup vault identified by its name. A vault can be deleted only if it is empty.</p>', 'DeleteBackupVaultAccessPolicy' => '<p>Deletes the policy document that manages permissions on a backup vault.</p>', 'DeleteBackupVaultLockConfiguration' => '<p>Deletes Backup Vault Lock from a backup vault specified by a backup vault name.</p> <p>If the Vault Lock configuration is immutable, then you cannot delete Vault Lock using API operations, and you will receive an <code>InvalidRequestException</code> if you attempt to do so. For more information, see <a href="https://docs.aws.amazon.com/aws-backup/latest/devguide/vault-lock.html">Vault Lock</a> in the <i>Backup Developer Guide</i>.</p>', 'DeleteBackupVaultNotifications' => '<p>Deletes event notifications for the specified backup vault.</p>', 'DeleteFramework' => '<p>Deletes the framework specified by a framework name.</p>', 'DeleteRecoveryPoint' => '<p>Deletes the recovery point specified by a recovery point ID.</p> <p>If the recovery point ID belongs to a continuous backup, calling this endpoint deletes the existing continuous backup and stops future continuous backup.</p>', 'DeleteReportPlan' => '<p>Deletes the report plan specified by a report plan name.</p>', 'DescribeBackupJob' => '<p>Returns backup job details for the specified <code>BackupJobId</code>.</p>', 'DescribeBackupVault' => '<p>Returns metadata about a backup vault specified by its name.</p>', 'DescribeCopyJob' => '<p>Returns metadata associated with creating a copy of a resource.</p>', 'DescribeFramework' => '<p>Returns the framework details for the specified <code>FrameworkName</code>.</p>', 'DescribeGlobalSettings' => '<p>Describes whether the Amazon Web Services account is opted in to cross-account backup. Returns an error if the account is not a member of an Organizations organization. Example: <code>describe-global-settings --region us-west-2</code> </p>', 'DescribeProtectedResource' => '<p>Returns information about a saved resource, including the last time it was backed up, its Amazon Resource Name (ARN), and the Amazon Web Services service type of the saved resource.</p>', 'DescribeRecoveryPoint' => '<p>Returns metadata associated with a recovery point, including ID, status, encryption, and lifecycle.</p>', 'DescribeRegionSettings' => '<p>Returns the current service opt-in settings for the Region. If service opt-in is enabled for a service, Backup tries to protect that service\'s resources in this Region, when the resource is included in an on-demand backup or scheduled backup plan. Otherwise, Backup does not try to protect that service\'s resources in this Region.</p>', 'DescribeReportJob' => '<p>Returns the details associated with creating a report as specified by its <code>ReportJobId</code>.</p>', 'DescribeReportPlan' => '<p>Returns a list of all report plans for an Amazon Web Services account and Amazon Web Services Region.</p>', 'DescribeRestoreJob' => '<p>Returns metadata associated with a restore job that is specified by a job ID.</p>', 'DisassociateRecoveryPoint' => '<p>Deletes the specified continuous backup recovery point from Backup and releases control of that continuous backup to the source service, such as Amazon RDS. The source service will continue to create and retain continuous backups using the lifecycle that you specified in your original backup plan.</p> <p>Does not support snapshot backup recovery points.</p>', 'ExportBackupPlanTemplate' => '<p>Returns the backup plan that is specified by the plan ID as a backup template.</p>', 'GetBackupPlan' => '<p>Returns <code>BackupPlan</code> details for the specified <code>BackupPlanId</code>. The details are the body of a backup plan in JSON format, in addition to plan metadata.</p>', 'GetBackupPlanFromJSON' => '<p>Returns a valid JSON document specifying a backup plan or an error.</p>', 'GetBackupPlanFromTemplate' => '<p>Returns the template specified by its <code>templateId</code> as a backup plan.</p>', 'GetBackupSelection' => '<p>Returns selection metadata and a document in JSON format that specifies a list of resources that are associated with a backup plan.</p>', 'GetBackupVaultAccessPolicy' => '<p>Returns the access policy document that is associated with the named backup vault.</p>', 'GetBackupVaultNotifications' => '<p>Returns event notifications for the specified backup vault.</p>', 'GetRecoveryPointRestoreMetadata' => '<p>Returns a set of metadata key-value pairs that were used to create the backup.</p>', 'GetSupportedResourceTypes' => '<p>Returns the Amazon Web Services resource types supported by Backup.</p>', 'ListBackupJobs' => '<p>Returns a list of existing backup jobs for an authenticated account for the last 30 days. For a longer period of time, consider using these <a href="https://docs.aws.amazon.com/aws-backup/latest/devguide/monitoring.html">monitoring tools</a>.</p>', 'ListBackupPlanTemplates' => '<p>Returns metadata of your saved backup plan templates, including the template ID, name, and the creation and deletion dates.</p>', 'ListBackupPlanVersions' => '<p>Returns version metadata of your backup plans, including Amazon Resource Names (ARNs), backup plan IDs, creation and deletion dates, plan names, and version IDs.</p>', 'ListBackupPlans' => '<p>Returns a list of all active backup plans for an authenticated account. The list contains information such as Amazon Resource Names (ARNs), plan IDs, creation and deletion dates, version IDs, plan names, and creator request IDs.</p>', 'ListBackupSelections' => '<p>Returns an array containing metadata of the resources associated with the target backup plan.</p>', 'ListBackupVaults' => '<p>Returns a list of recovery point storage containers along with information about them.</p>', 'ListCopyJobs' => '<p>Returns metadata about your copy jobs.</p>', 'ListFrameworks' => '<p>Returns a list of all frameworks for an Amazon Web Services account and Amazon Web Services Region.</p>', 'ListProtectedResources' => '<p>Returns an array of resources successfully backed up by Backup, including the time the resource was saved, an Amazon Resource Name (ARN) of the resource, and a resource type.</p>', 'ListRecoveryPointsByBackupVault' => '<p>Returns detailed information about the recovery points stored in a backup vault.</p>', 'ListRecoveryPointsByResource' => '<p>Returns detailed information about all the recovery points of the type specified by a resource Amazon Resource Name (ARN).</p> <note> <p>For Amazon EFS and Amazon EC2, this action only lists recovery points created by Backup.</p> </note>', 'ListReportJobs' => '<p>Returns details about your report jobs.</p>', 'ListReportPlans' => '<p>Returns a list of your report plans. For detailed information about a single report plan, use <code>DescribeReportPlan</code>.</p>', 'ListRestoreJobs' => '<p>Returns a list of jobs that Backup initiated to restore a saved resource, including details about the recovery process.</p>', 'ListTags' => '<p>Returns a list of key-value pairs assigned to a target recovery point, backup plan, or backup vault.</p> <note> <p> <code>ListTags</code> are currently only supported with Amazon EFS backups.</p> </note>', 'PutBackupVaultAccessPolicy' => '<p>Sets a resource-based policy that is used to manage access permissions on the target backup vault. Requires a backup vault name and an access policy document in JSON format.</p>', 'PutBackupVaultLockConfiguration' => '<p>Applies Backup Vault Lock to a backup vault, preventing attempts to delete any recovery point stored in or created in a backup vault. Vault Lock also prevents attempts to update the lifecycle policy that controls the retention period of any recovery point currently stored in a backup vault. If specified, Vault Lock enforces a minimum and maximum retention period for future backup and copy jobs that target a backup vault.</p>', 'PutBackupVaultNotifications' => '<p>Turns on notifications on a backup vault for the specified topic and events.</p>', 'StartBackupJob' => '<p>Starts an on-demand backup job for the specified resource.</p>', 'StartCopyJob' => '<p>Starts a job to create a one-time copy of the specified resource.</p> <p>Does not support continuous backups.</p>', 'StartReportJob' => '<p>Starts an on-demand report job for the specified report plan.</p>', 'StartRestoreJob' => '<p>Recovers the saved resource identified by an Amazon Resource Name (ARN).</p>', 'StopBackupJob' => '<p>Attempts to cancel a job to create a one-time backup of a resource.</p>', 'TagResource' => '<p>Assigns a set of key-value pairs to a recovery point, backup plan, or backup vault identified by an Amazon Resource Name (ARN).</p>', 'UntagResource' => '<p>Removes a set of key-value pairs from a recovery point, backup plan, or backup vault identified by an Amazon Resource Name (ARN)</p>', 'UpdateBackupPlan' => '<p>Updates an existing backup plan identified by its <code>backupPlanId</code> with the input document in JSON format. The new version is uniquely identified by a <code>VersionId</code>.</p>', 'UpdateFramework' => '<p>Updates an existing framework identified by its <code>FrameworkName</code> with the input document in JSON format.</p>', 'UpdateGlobalSettings' => '<p>Updates whether the Amazon Web Services account is opted in to cross-account backup. Returns an error if the account is not an Organizations management account. Use the <code>DescribeGlobalSettings</code> API to determine the current settings.</p>', 'UpdateRecoveryPointLifecycle' => '<p>Sets the transition lifecycle of a recovery point.</p> <p>The lifecycle defines when a protected resource is transitioned to cold storage and when it expires. Backup transitions and expires backups automatically according to the lifecycle that you define.</p> <p>Backups transitioned to cold storage must be stored in cold storage for a minimum of 90 days. Therefore, the “expire after days” setting must be 90 days greater than the “transition to cold after days” setting. The “transition to cold after days” setting cannot be changed after a backup has been transitioned to cold.</p> <p>Only Amazon EFS file system backups can be transitioned to cold storage.</p> <p>Does not support continuous backups.</p>', 'UpdateRegionSettings' => '<p>Updates the current service opt-in settings for the Region. If service-opt-in is enabled for a service, Backup tries to protect that service\'s resources in this Region, when the resource is included in an on-demand backup or scheduled backup plan. Otherwise, Backup does not try to protect that service\'s resources in this Region. Use the <code>DescribeRegionSettings</code> API to determine the resource types that are supported.</p>', 'UpdateReportPlan' => '<p>Updates an existing report plan identified by its <code>ReportPlanName</code> with the input document in JSON format.</p>', ], 'shapes' => [ 'ARN' => [ 'base' => NULL, 'refs' => [ 'BackupJob$BackupVaultArn' => '<p>An Amazon Resource Name (ARN) that uniquely identifies a backup vault; for example, <code>arn:aws:backup:us-east-1:123456789012:vault:aBackupVault</code>.</p>', 'BackupJob$RecoveryPointArn' => '<p>An ARN that uniquely identifies a recovery point; for example, <code>arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45</code>.</p>', 'BackupJob$ResourceArn' => '<p>An ARN that uniquely identifies a resource. The format of the ARN depends on the resource type.</p>', 'BackupPlansListMember$BackupPlanArn' => '<p>An Amazon Resource Name (ARN) that uniquely identifies a backup plan; for example, <code>arn:aws:backup:us-east-1:123456789012:plan:8F81F553-3A74-4A3F-B93D-B3360DC80C50</code>.</p>', 'BackupVaultListMember$BackupVaultArn' => '<p>An Amazon Resource Name (ARN) that uniquely identifies a backup vault; for example, <code>arn:aws:backup:us-east-1:123456789012:vault:aBackupVault</code>.</p>', 'BackupVaultListMember$EncryptionKeyArn' => '<p>The server-side encryption key that is used to protect your backups; for example, <code>arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code>.</p>', 'CopyAction$DestinationBackupVaultArn' => '<p>An Amazon Resource Name (ARN) that uniquely identifies the destination backup vault for the copied backup. For example, <code>arn:aws:backup:us-east-1:123456789012:vault:aBackupVault</code>.</p>', 'CopyJob$SourceBackupVaultArn' => '<p>An Amazon Resource Name (ARN) that uniquely identifies a source copy vault; for example, <code>arn:aws:backup:us-east-1:123456789012:vault:aBackupVault</code>. </p>', 'CopyJob$SourceRecoveryPointArn' => '<p>An ARN that uniquely identifies a source recovery point; for example, <code>arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45</code>.</p>', 'CopyJob$DestinationBackupVaultArn' => '<p>An Amazon Resource Name (ARN) that uniquely identifies a destination copy vault; for example, <code>arn:aws:backup:us-east-1:123456789012:vault:aBackupVault</code>.</p>', 'CopyJob$DestinationRecoveryPointArn' => '<p>An ARN that uniquely identifies a destination recovery point; for example, <code>arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45</code>.</p>', 'CopyJob$ResourceArn' => '<p>The Amazon Web Services resource to be copied; for example, an Amazon Elastic Block Store (Amazon EBS) volume or an Amazon Relational Database Service (Amazon RDS) database.</p>', 'CreateBackupPlanOutput$BackupPlanArn' => '<p>An Amazon Resource Name (ARN) that uniquely identifies a backup plan; for example, <code>arn:aws:backup:us-east-1:123456789012:plan:8F81F553-3A74-4A3F-B93D-B3360DC80C50</code>.</p>', 'CreateBackupVaultInput$EncryptionKeyArn' => '<p>The server-side encryption key that is used to protect your backups; for example, <code>arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code>.</p>', 'CreateBackupVaultOutput$BackupVaultArn' => '<p>An Amazon Resource Name (ARN) that uniquely identifies a backup vault; for example, <code>arn:aws:backup:us-east-1:123456789012:vault:aBackupVault</code>.</p>', 'CreateFrameworkOutput$FrameworkArn' => '<p>An Amazon Resource Name (ARN) that uniquely identifies a resource. The format of the ARN depends on the resource type.</p>', 'CreateReportPlanOutput$ReportPlanArn' => '<p>An Amazon Resource Name (ARN) that uniquely identifies a resource. The format of the ARN depends on the resource type.</p>', 'DeleteBackupPlanOutput$BackupPlanArn' => '<p>An Amazon Resource Name (ARN) that uniquely identifies a backup plan; for example, <code>arn:aws:backup:us-east-1:123456789012:plan:8F81F553-3A74-4A3F-B93D-B3360DC80C50</code>.</p>', 'DeleteRecoveryPointInput$RecoveryPointArn' => '<p>An Amazon Resource Name (ARN) that uniquely identifies a recovery point; for example, <code>arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45</code>.</p>', 'DescribeBackupJobOutput$BackupVaultArn' => '<p>An Amazon Resource Name (ARN) that uniquely identifies a backup vault; for example, <code>arn:aws:backup:us-east-1:123456789012:vault:aBackupVault</code>.</p>', 'DescribeBackupJobOutput$RecoveryPointArn' => '<p>An ARN that uniquely identifies a recovery point; for example, <code>arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45</code>.</p>', 'DescribeBackupJobOutput$ResourceArn' => '<p>An ARN that uniquely identifies a saved resource. The format of the ARN depends on the resource type.</p>', 'DescribeBackupVaultOutput$BackupVaultArn' => '<p>An Amazon Resource Name (ARN) that uniquely identifies a backup vault; for example, <code>arn:aws:backup:us-east-1:123456789012:vault:aBackupVault</code>.</p>', 'DescribeBackupVaultOutput$EncryptionKeyArn' => '<p>The server-side encryption key that is used to protect your backups; for example, <code>arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code>.</p>', 'DescribeFrameworkOutput$FrameworkArn' => '<p>An Amazon Resource Name (ARN) that uniquely identifies a resource. The format of the ARN depends on the resource type.</p>', 'DescribeProtectedResourceInput$ResourceArn' => '<p>An Amazon Resource Name (ARN) that uniquely identifies a resource. The format of the ARN depends on the resource type.</p>', 'DescribeProtectedResourceOutput$ResourceArn' => '<p>An ARN that uniquely identifies a resource. The format of the ARN depends on the resource type.</p>', 'DescribeRecoveryPointInput$RecoveryPointArn' => '<p>An Amazon Resource Name (ARN) that uniquely identifies a recovery point; for example, <code>arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45</code>.</p>', 'DescribeRecoveryPointOutput$RecoveryPointArn' => '<p>An ARN that uniquely identifies a recovery point; for example, <code>arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45</code>.</p>', 'DescribeRecoveryPointOutput$BackupVaultArn' => '<p>An ARN that uniquely identifies a backup vault; for example, <code>arn:aws:backup:us-east-1:123456789012:vault:aBackupVault</code>.</p>', 'DescribeRecoveryPointOutput$SourceBackupVaultArn' => '<p>An Amazon Resource Name (ARN) that uniquely identifies the source vault where the resource was originally backed up in; for example, <code>arn:aws:backup:us-east-1:123456789012:vault:BackupVault</code>. If the recovery is restored to the same Amazon Web Services account or Region, this value will be <code>null</code>.</p>', 'DescribeRecoveryPointOutput$ResourceArn' => '<p>An ARN that uniquely identifies a saved resource. The format of the ARN depends on the resource type.</p>', 'DescribeRecoveryPointOutput$EncryptionKeyArn' => '<p>The server-side encryption key used to protect your backups; for example, <code>arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code>.</p>', 'DescribeRestoreJobOutput$RecoveryPointArn' => '<p>An ARN that uniquely identifies a recovery point; for example, <code>arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45</code>.</p>', 'DescribeRestoreJobOutput$CreatedResourceArn' => '<p>An Amazon Resource Name (ARN) that uniquely identifies a resource whose recovery point is being restored. The format of the ARN depends on the resource type of the backed-up resource.</p>', 'DisassociateRecoveryPointInput$RecoveryPointArn' => '<p>An Amazon Resource Name (ARN) that uniquely identifies an Backup recovery point.</p>', 'Framework$FrameworkArn' => '<p>An Amazon Resource Name (ARN) that uniquely identifies a resource. The format of the ARN depends on the resource type.</p>', 'GetBackupPlanOutput$BackupPlanArn' => '<p>An Amazon Resource Name (ARN) that uniquely identifies a backup plan; for example, <code>arn:aws:backup:us-east-1:123456789012:plan:8F81F553-3A74-4A3F-B93D-B3360DC80C50</code>.</p>', 'GetBackupVaultAccessPolicyOutput$BackupVaultArn' => '<p>An Amazon Resource Name (ARN) that uniquely identifies a backup vault; for example, <code>arn:aws:backup:us-east-1:123456789012:vault:aBackupVault</code>.</p>', 'GetBackupVaultNotificationsOutput$BackupVaultArn' => '<p>An Amazon Resource Name (ARN) that uniquely identifies a backup vault; for example, <code>arn:aws:backup:us-east-1:123456789012:vault:aBackupVault</code>.</p>', 'GetBackupVaultNotificationsOutput$SNSTopicArn' => '<p>An ARN that uniquely identifies an Amazon Simple Notification Service (Amazon SNS) topic; for example, <code>arn:aws:sns:us-west-2:111122223333:MyTopic</code>.</p>', 'GetRecoveryPointRestoreMetadataInput$RecoveryPointArn' => '<p>An Amazon Resource Name (ARN) that uniquely identifies a recovery point; for example, <code>arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45</code>.</p>', 'GetRecoveryPointRestoreMetadataOutput$BackupVaultArn' => '<p>An ARN that uniquely identifies a backup vault; for example, <code>arn:aws:backup:us-east-1:123456789012:vault:aBackupVault</code>.</p>', 'GetRecoveryPointRestoreMetadataOutput$RecoveryPointArn' => '<p>An ARN that uniquely identifies a recovery point; for example, <code>arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45</code>.</p>', 'ListBackupJobsInput$ByResourceArn' => '<p>Returns only backup jobs that match the specified resource Amazon Resource Name (ARN).</p>', 'ListCopyJobsInput$ByResourceArn' => '<p>Returns only copy jobs that match the specified resource Amazon Resource Name (ARN). </p>', 'ListRecoveryPointsByBackupVaultInput$ByResourceArn' => '<p>Returns only recovery points that match the specified resource Amazon Resource Name (ARN).</p>', 'ListRecoveryPointsByResourceInput$ResourceArn' => '<p>An ARN that uniquely identifies a resource. The format of the ARN depends on the resource type.</p>', 'ListTagsInput$ResourceArn' => '<p>An Amazon Resource Name (ARN) that uniquely identifies a resource. The format of the ARN depends on the type of resource. Valid targets for <code>ListTags</code> are recovery points, backup plans, and backup vaults.</p>', 'ProtectedResource$ResourceArn' => '<p>An Amazon Resource Name (ARN) that uniquely identifies a resource. The format of the ARN depends on the resource type.</p>', 'PutBackupVaultNotificationsInput$SNSTopicArn' => '<p>The Amazon Resource Name (ARN) that specifies the topic for a backup vault’s events; for example, <code>arn:aws:sns:us-west-2:111122223333:MyVaultTopic</code>.</p>', 'RecoveryPointByBackupVault$RecoveryPointArn' => '<p>An Amazon Resource Name (ARN) that uniquely identifies a recovery point; for example, <code>arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45</code>.</p>', 'RecoveryPointByBackupVault$BackupVaultArn' => '<p>An ARN that uniquely identifies a backup vault; for example, <code>arn:aws:backup:us-east-1:123456789012:vault:aBackupVault</code>.</p>', 'RecoveryPointByBackupVault$SourceBackupVaultArn' => '<p>The backup vault where the recovery point was originally copied from. If the recovery point is restored to the same account this value will be <code>null</code>.</p>', 'RecoveryPointByBackupVault$ResourceArn' => '<p>An ARN that uniquely identifies a resource. The format of the ARN depends on the resource type.</p>', 'RecoveryPointByBackupVault$EncryptionKeyArn' => '<p>The server-side encryption key that is used to protect your backups; for example, <code>arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code>.</p>', 'RecoveryPointByResource$RecoveryPointArn' => '<p>An Amazon Resource Name (ARN) that uniquely identifies a recovery point; for example, <code>arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45</code>.</p>', 'RecoveryPointByResource$EncryptionKeyArn' => '<p>The server-side encryption key that is used to protect your backups; for example, <code>arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code>.</p>', 'RecoveryPointCreator$BackupPlanArn' => '<p>An Amazon Resource Name (ARN) that uniquely identifies a backup plan; for example, <code>arn:aws:backup:us-east-1:123456789012:plan:8F81F553-3A74-4A3F-B93D-B3360DC80C50</code>.</p>', 'ReportJob$ReportPlanArn' => '<p>An Amazon Resource Name (ARN) that uniquely identifies a resource. The format of the ARN depends on the resource type.</p>', 'ReportPlan$ReportPlanArn' => '<p>An Amazon Resource Name (ARN) that uniquely identifies a resource. The format of the ARN depends on the resource type.</p>', 'ResourceArns$member' => NULL, 'ResourceTypeList$member' => NULL, 'RestoreJobsListMember$RecoveryPointArn' => '<p>An ARN that uniquely identifies a recovery point; for example, <code>arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45</code>.</p>', 'RestoreJobsListMember$CreatedResourceArn' => '<p>An Amazon Resource Name (ARN) that uniquely identifies a resource. The format of the ARN depends on the resource type.</p>', 'StartBackupJobInput$ResourceArn' => '<p>An Amazon Resource Name (ARN) that uniquely identifies a resource. The format of the ARN depends on the resource type.</p>', 'StartBackupJobOutput$RecoveryPointArn' => '<p>An ARN that uniquely identifies a recovery point; for example, <code>arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45</code>.</p>', 'StartCopyJobInput$RecoveryPointArn' => '<p>An ARN that uniquely identifies a recovery point to use for the copy job; for example, arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45. </p>', 'StartCopyJobInput$DestinationBackupVaultArn' => '<p>An Amazon Resource Name (ARN) that uniquely identifies a destination backup vault to copy to; for example, <code>arn:aws:backup:us-east-1:123456789012:vault:aBackupVault</code>.</p>', 'StartRestoreJobInput$RecoveryPointArn' => '<p>An ARN that uniquely identifies a recovery point; for example, <code>arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45</code>.</p>', 'TagResourceInput$ResourceArn' => '<p>An ARN that uniquely identifies a resource. The format of the ARN depends on the type of the tagged resource.</p>', 'UntagResourceInput$ResourceArn' => '<p>An ARN that uniquely identifies a resource. The format of the ARN depends on the type of the tagged resource.</p>', 'UpdateBackupPlanOutput$BackupPlanArn' => '<p>An Amazon Resource Name (ARN) that uniquely identifies a backup plan; for example, <code>arn:aws:backup:us-east-1:123456789012:plan:8F81F553-3A74-4A3F-B93D-B3360DC80C50</code>.</p>', 'UpdateFrameworkOutput$FrameworkArn' => '<p>An Amazon Resource Name (ARN) that uniquely identifies a resource. The format of the ARN depends on the resource type.</p>', 'UpdateRecoveryPointLifecycleInput$RecoveryPointArn' => '<p>An Amazon Resource Name (ARN) that uniquely identifies a recovery point; for example, <code>arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45</code>.</p>', 'UpdateRecoveryPointLifecycleOutput$BackupVaultArn' => '<p>An ARN that uniquely identifies a backup vault; for example, <code>arn:aws:backup:us-east-1:123456789012:vault:aBackupVault</code>.</p>', 'UpdateRecoveryPointLifecycleOutput$RecoveryPointArn' => '<p>An Amazon Resource Name (ARN) that uniquely identifies a recovery point; for example, <code>arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45</code>.</p>', 'UpdateReportPlanOutput$ReportPlanArn' => '<p>An Amazon Resource Name (ARN) that uniquely identifies a resource. The format of the ARN depends on the resource type.</p>', ], ], 'AccountId' => [ 'base' => NULL, 'refs' => [ 'BackupJob$AccountId' => '<p>The account ID that owns the backup job.</p>', 'CopyJob$AccountId' => '<p>The account ID that owns the copy job.</p>', 'DescribeBackupJobOutput$AccountId' => '<p>Returns the account ID that owns the backup job.</p>', 'DescribeRestoreJobOutput$AccountId' => '<p>Returns the account ID that owns the restore job.</p>', 'ListBackupJobsInput$ByAccountId' => '<p>The account ID to list the jobs from. Returns only backup jobs associated with the specified account ID.</p> <p>If used from an Organizations management account, passing <code>*</code> returns all jobs across the organization.</p>', 'ListCopyJobsInput$ByAccountId' => '<p>The account ID to list the jobs from. Returns only copy jobs associated with the specified account ID.</p>', 'ListRestoreJobsInput$ByAccountId' => '<p>The account ID to list the jobs from. Returns only restore jobs associated with the specified account ID.</p>', 'RestoreJobsListMember$AccountId' => '<p>The account ID that owns the restore job.</p>', ], ], 'AdvancedBackupSetting' => [ 'base' => '<p>A list of backup options for each resource type.</p>', 'refs' => [ 'AdvancedBackupSettings$member' => NULL, ], ], 'AdvancedBackupSettings' => [ 'base' => NULL, 'refs' => [ 'BackupPlan$AdvancedBackupSettings' => '<p>Contains a list of <code>BackupOptions</code> for each resource type.</p>', 'BackupPlanInput$AdvancedBackupSettings' => '<p>Specifies a list of <code>BackupOptions</code> for each resource type. These settings are only available for Windows Volume Shadow Copy Service (VSS) backup jobs.</p>', 'BackupPlansListMember$AdvancedBackupSettings' => '<p>Contains a list of <code>BackupOptions</code> for a resource type.</p>', 'CreateBackupPlanOutput$AdvancedBackupSettings' => '<p>A list of <code>BackupOptions</code> settings for a resource type. This option is only available for Windows Volume Shadow Copy Service (VSS) backup jobs.</p>', 'GetBackupPlanOutput$AdvancedBackupSettings' => '<p>Contains a list of <code>BackupOptions</code> for each resource type. The list is populated only if the advanced option is set for the backup plan.</p>', 'UpdateBackupPlanOutput$AdvancedBackupSettings' => '<p>Contains a list of <code>BackupOptions</code> for each resource type.</p>', ], ], 'AlreadyExistsException' => [ 'base' => '<p>The required resource already exists.</p>', 'refs' => [], ], 'BackupJob' => [ 'base' => '<p>Contains detailed information about a backup job.</p>', 'refs' => [ 'BackupJobsList$member' => NULL, ], ], 'BackupJobState' => [ 'base' => NULL, 'refs' => [ 'BackupJob$State' => '<p>The current state of a resource recovery point.</p>', 'DescribeBackupJobOutput$State' => '<p>The current state of a resource recovery point.</p>', 'ListBackupJobsInput$ByState' => '<p>Returns only backup jobs that are in the specified state.</p>', ], ], 'BackupJobsList' => [ 'base' => NULL, 'refs' => [ 'ListBackupJobsOutput$BackupJobs' => '<p>An array of structures containing metadata about your backup jobs returned in JSON format.</p>', ], ], 'BackupOptionKey' => [ 'base' => NULL, 'refs' => [ 'BackupOptions$key' => NULL, ], ], 'BackupOptionValue' => [ 'base' => NULL, 'refs' => [ 'BackupOptions$value' => NULL, ], ], 'BackupOptions' => [ 'base' => NULL, 'refs' => [ 'AdvancedBackupSetting$BackupOptions' => '<p>Specifies the backup option for a selected resource. This option is only available for Windows VSS backup jobs.</p> <p>Valid values: </p> <p>Set to <code>"WindowsVSS":"enabled"</code> to enable the <code>WindowsVSS</code> backup option and create a Windows VSS backup. </p> <p>Set to <code>"WindowsVSS":"disabled"</code> to create a regular backup. The <code>WindowsVSS</code> option is not enabled by default.</p> <p>If you specify an invalid option, you get an <code>InvalidParameterValueException</code> exception.</p> <p>For more information about Windows VSS backups, see <a href="https://docs.aws.amazon.com/aws-backup/latest/devguide/windows-backups.html">Creating a VSS-Enabled Windows Backup</a>.</p>', 'BackupJob$BackupOptions' => '<p>Specifies the backup option for a selected resource. This option is only available for Windows Volume Shadow Copy Service (VSS) backup jobs.</p> <p>Valid values: Set to <code>"WindowsVSS":"enabled"</code> to enable the <code>WindowsVSS</code> backup option and create a Windows VSS backup. Set to <code>"WindowsVSS":"disabled"</code> to create a regular backup. If you specify an invalid option, you get an <code>InvalidParameterValueException</code> exception.</p>', 'DescribeBackupJobOutput$BackupOptions' => '<p>Represents the options specified as part of backup plan or on-demand backup job.</p>', 'StartBackupJobInput$BackupOptions' => '<p>Specifies the backup option for a selected resource. This option is only available for Windows Volume Shadow Copy Service (VSS) backup jobs.</p> <p>Valid values: Set to <code>"WindowsVSS":"enabled"</code> to enable the <code>WindowsVSS</code> backup option and create a Windows VSS backup. Set to <code>"WindowsVSS""disabled"</code> to create a regular backup. The <code>WindowsVSS</code> option is not enabled by default.</p>', ], ], 'BackupPlan' => [ 'base' => '<p>Contains an optional backup plan display name and an array of <code>BackupRule</code> objects, each of which specifies a backup rule. Each rule in a backup plan is a separate scheduled task and can back up a different selection of Amazon Web Services resources.</p>', 'refs' => [ 'GetBackupPlanFromJSONOutput$BackupPlan' => '<p>Specifies the body of a backup plan. Includes a <code>BackupPlanName</code> and one or more sets of <code>Rules</code>.</p>', 'GetBackupPlanFromTemplateOutput$BackupPlanDocument' => '<p>Returns the body of a backup plan based on the target template, including the name, rules, and backup vault of the plan.</p>', 'GetBackupPlanOutput$BackupPlan' => '<p>Specifies the body of a backup plan. Includes a <code>BackupPlanName</code> and one or more sets of <code>Rules</code>.</p>', ], ], 'BackupPlanInput' => [ 'base' => '<p>Contains an optional backup plan display name and an array of <code>BackupRule</code> objects, each of which specifies a backup rule. Each rule in a backup plan is a separate scheduled task. </p>', 'refs' => [ 'CreateBackupPlanInput$BackupPlan' => '<p>Specifies the body of a backup plan. Includes a <code>BackupPlanName</code> and one or more sets of <code>Rules</code>.</p>', 'UpdateBackupPlanInput$BackupPlan' => '<p>Specifies the body of a backup plan. Includes a <code>BackupPlanName</code> and one or more sets of <code>Rules</code>.</p>', ], ], 'BackupPlanName' => [ 'base' => NULL, 'refs' => [ 'BackupPlan$BackupPlanName' => '<p>The display name of a backup plan.</p>', 'BackupPlanInput$BackupPlanName' => '<p>The optional display name of a backup plan.</p>', 'BackupPlansListMember$BackupPlanName' => '<p>The display name of a saved backup plan.</p>', ], ], 'BackupPlanTemplatesList' => [ 'base' => NULL, 'refs' => [ 'ListBackupPlanTemplatesOutput$BackupPlanTemplatesList' => '<p>An array of template list items containing metadata about your saved templates.</p>', ], ], 'BackupPlanTemplatesListMember' => [ 'base' => '<p>An object specifying metadata associated with a backup plan template.</p>', 'refs' => [ 'BackupPlanTemplatesList$member' => NULL, ], ], 'BackupPlanVersionsList' => [ 'base' => NULL, 'refs' => [ 'ListBackupPlanVersionsOutput$BackupPlanVersionsList' => '<p>An array of version list items containing metadata about your backup plans.</p>', ], ], 'BackupPlansList' => [ 'base' => NULL, 'refs' => [ 'ListBackupPlansOutput$BackupPlansList' => '<p>An array of backup plan list items containing metadata about your saved backup plans.</p>', ], ], 'BackupPlansListMember' => [ 'base' => '<p>Contains metadata about a backup plan.</p>', 'refs' => [ 'BackupPlanVersionsList$member' => NULL, 'BackupPlansList$member' => NULL, ], ], 'BackupRule' => [ 'base' => '<p>Specifies a scheduled task used to back up a selection of resources.</p>', 'refs' => [ 'BackupRules$member' => NULL, ], ], 'BackupRuleInput' => [ 'base' => '<p>Specifies a scheduled task used to back up a selection of resources.</p>', 'refs' => [ 'BackupRulesInput$member' => NULL, ], ], 'BackupRuleName' => [ 'base' => NULL, 'refs' => [ 'BackupRule$RuleName' => '<p>An optional display name for a backup rule.</p>', 'BackupRuleInput$RuleName' => '<p>An optional display name for a backup rule.</p>', ], ], 'BackupRules' => [ 'base' => NULL, 'refs' => [ 'BackupPlan$Rules' => '<p>An array of <code>BackupRule</code> objects, each of which specifies a scheduled task that is used to back up a selection of resources. </p>', ], ], 'BackupRulesInput' => [ 'base' => NULL, 'refs' => [ 'BackupPlanInput$Rules' => '<p>An array of <code>BackupRule</code> objects, each of which specifies a scheduled task that is used to back up a selection of resources.</p>', ], ], 'BackupSelection' => [ 'base' => '<p>Used to specify a set of resources to a backup plan.</p>', 'refs' => [ 'CreateBackupSelectionInput$BackupSelection' => '<p>Specifies the body of a request to assign a set of resources to a backup plan.</p>', 'GetBackupSelectionOutput$BackupSelection' => '<p>Specifies the body of a request to assign a set of resources to a backup plan.</p>', ], ], 'BackupSelectionName' => [ 'base' => NULL, 'refs' => [ 'BackupSelection$SelectionName' => '<p>The display name of a resource selection document.</p>', 'BackupSelectionsListMember$SelectionName' => '<p>The display name of a resource selection document.</p>', ], ], 'BackupSelectionsList' => [ 'base' => NULL, 'refs' => [ 'ListBackupSelectionsOutput$BackupSelectionsList' => '<p>An array of backup selection list items containing metadata about each resource in the list.</p>', ], ], 'BackupSelectionsListMember' => [ 'base' => '<p>Contains metadata about a <code>BackupSelection</code> object.</p>', 'refs' => [ 'BackupSelectionsList$member' => NULL, ], ], 'BackupVaultEvent' => [ 'base' => NULL, 'refs' => [ 'BackupVaultEvents$member' => NULL, ], ], 'BackupVaultEvents' => [ 'base' => NULL, 'refs' => [ 'GetBackupVaultNotificationsOutput$BackupVaultEvents' => '<p>An array of events that indicate the status of jobs to back up resources to the backup vault.</p>', 'PutBackupVaultNotificationsInput$BackupVaultEvents' => '<p>An array of events that indicate the status of jobs to back up resources to the backup vault.</p> <note> <p>The following events are supported:</p> <p> <code>BACKUP_JOB_STARTED</code>, <code>BACKUP_JOB_COMPLETED</code>,</p> <p> <code>COPY_JOB_STARTED</code>, <code>COPY_JOB_SUCCESSFUL</code>, <code>COPY_JOB_FAILED</code>,</p> <p> <code>RESTORE_JOB_STARTED</code>, <code>RESTORE_JOB_COMPLETED</code>, and <code>RECOVERY_POINT_MODIFIED</code>.</p> <p>To find failed backup jobs, use <code>BACKUP_JOB_COMPLETED</code> and filter using event metadata.</p> <p>Other events in the following list are deprecated.</p> </note>', ], ], 'BackupVaultList' => [ 'base' => NULL, 'refs' => [ 'ListBackupVaultsOutput$BackupVaultList' => '<p>An array of backup vault list members containing vault metadata, including Amazon Resource Name (ARN), display name, creation date, number of saved recovery points, and encryption information if the resources saved in the backup vault are encrypted.</p>', ], ], 'BackupVaultListMember' => [ 'base' => '<p>Contains metadata about a backup vault.</p>', 'refs' => [ 'BackupVaultList$member' => NULL, ], ], 'BackupVaultName' => [ 'base' => NULL, 'refs' => [ 'BackupJob$BackupVaultName' => '<p>The name of a logical container where backups are stored. Backup vaults are identified by names that are unique to the account used to create them and the Amazon Web Services Region where they are created. They consist of lowercase letters, numbers, and hyphens.</p>', 'BackupRule$TargetBackupVaultName' => '<p>The name of a logical container where backups are stored. Backup vaults are identified by names that are unique to the account used to create them and the Amazon Web Services Region where they are created. They consist of lowercase letters, numbers, and hyphens.</p>', 'BackupRuleInput$TargetBackupVaultName' => '<p>The name of a logical container where backups are stored. Backup vaults are identified by names that are unique to the account used to create them and the Amazon Web Services Region where they are created. They consist of lowercase letters, numbers, and hyphens.</p>', 'BackupVaultListMember$BackupVaultName' => '<p>The name of a logical container where backups are stored. Backup vaults are identified by names that are unique to the account used to create them and the Amazon Web Services Region where they are created. They consist of lowercase letters, numbers, and hyphens.</p>', 'CreateBackupVaultInput$BackupVaultName' => '<p>The name of a logical container where backups are stored. Backup vaults are identified by names that are unique to the account used to create them and the Amazon Web Services Region where they are created. They consist of letters, numbers, and hyphens.</p>', 'CreateBackupVaultOutput$BackupVaultName' => '<p>The name of a logical container where backups are stored. Backup vaults are identified by names that are unique to the account used to create them and the Region where they are created. They consist of lowercase letters, numbers, and hyphens.</p>', 'DeleteBackupVaultAccessPolicyInput$BackupVaultName' => '<p>The name of a logical container where backups are stored. Backup vaults are identified by names that are unique to the account used to create them and the Amazon Web Services Region where they are created. They consist of lowercase letters, numbers, and hyphens.</p>', 'DeleteBackupVaultLockConfigurationInput$BackupVaultName' => '<p>The name of the backup vault from which to delete Backup Vault Lock.</p>', 'DeleteBackupVaultNotificationsInput$BackupVaultName' => '<p>The name of a logical container where backups are stored. Backup vaults are identified by names that are unique to the account used to create them and the Region where they are created. They consist of lowercase letters, numbers, and hyphens.</p>', 'DeleteRecoveryPointInput$BackupVaultName' => '<p>The name of a logical container where backups are stored. Backup vaults are identified by names that are unique to the account used to create them and the Amazon Web Services Region where they are created. They consist of lowercase letters, numbers, and hyphens.</p>', 'DescribeBackupJobOutput$BackupVaultName' => '<p>The name of a logical container where backups are stored. Backup vaults are identified by names that are unique to the account used to create them and the Amazon Web Services Region where they are created. They consist of lowercase letters, numbers, and hyphens.</p>', 'DescribeRecoveryPointInput$BackupVaultName' => '<p>The name of a logical container where backups are stored. Backup vaults are identified by names that are unique to the account used to create them and the Amazon Web Services Region where they are created. They consist of lowercase letters, numbers, and hyphens.</p>', 'DescribeRecoveryPointOutput$BackupVaultName' => '<p>The name of a logical container where backups are stored. Backup vaults are identified by names that are unique to the account used to create them and the Region where they are created. They consist of lowercase letters, numbers, and hyphens.</p>', 'DisassociateRecoveryPointInput$BackupVaultName' => '<p>The unique name of an Backup vault.</p>', 'GetBackupVaultAccessPolicyInput$BackupVaultName' => '<p>The name of a logical container where backups are stored. Backup vaults are identified by names that are unique to the account used to create them and the Amazon Web Services Region where they are created. They consist of lowercase letters, numbers, and hyphens.</p>', 'GetBackupVaultAccessPolicyOutput$BackupVaultName' => '<p>The name of a logical container where backups are stored. Backup vaults are identified by names that are unique to the account used to create them and the Region where they are created. They consist of lowercase letters, numbers, and hyphens.</p>', 'GetBackupVaultNotificationsInput$BackupVaultName' => '<p>The name of a logical container where backups are stored. Backup vaults are identified by names that are unique to the account used to create them and the Amazon Web Services Region where they are created. They consist of lowercase letters, numbers, and hyphens.</p>', 'GetBackupVaultNotificationsOutput$BackupVaultName' => '<p>The name of a logical container where backups are stored. Backup vaults are identified by names that are unique to the account used to create them and the Region where they are created. They consist of lowercase letters, numbers, and hyphens.</p>', 'GetRecoveryPointRestoreMetadataInput$BackupVaultName' => '<p>The name of a logical container where backups are stored. Backup vaults are identified by names that are unique to the account used to create them and the Amazon Web Services Region where they are created. They consist of lowercase letters, numbers, and hyphens.</p>', 'ListBackupJobsInput$ByBackupVaultName' => '<p>Returns only backup jobs that will be stored in the specified backup vault. Backup vaults are identified by names that are unique to the account used to create them and the Amazon Web Services Region where they are created. They consist of lowercase letters, numbers, and hyphens.</p>', 'ListRecoveryPointsByBackupVaultInput$BackupVaultName' => '<p>The name of a logical container where backups are stored. Backup vaults are identified by names that are unique to the account used to create them and the Amazon Web Services Region where they are created. They consist of lowercase letters, numbers, and hyphens.</p> <note> <p>Backup vault name might not be available when a supported service creates the backup.</p> </note>', 'PutBackupVaultAccessPolicyInput$BackupVaultName' => '<p>The name of a logical container where backups are stored. Backup vaults are identified by names that are unique to the account used to create them and the Amazon Web Services Region where they are created. They consist of lowercase letters, numbers, and hyphens.</p>', 'PutBackupVaultLockConfigurationInput$BackupVaultName' => '<p>The Backup Vault Lock configuration that specifies the name of the backup vault it protects.</p>', 'PutBackupVaultNotificationsInput$BackupVaultName' => '<p>The name of a logical container where backups are stored. Backup vaults are identified by names that are unique to the account used to create them and the Amazon Web Services Region where they are created. They consist of lowercase letters, numbers, and hyphens.</p>', 'RecoveryPointByBackupVault$BackupVaultName' => '<p>The name of a logical container where backups are stored. Backup vaults are identified by names that are unique to the account used to create them and the Amazon Web Services Region where they are created. They consist of lowercase letters, numbers, and hyphens.</p>', 'RecoveryPointByResource$BackupVaultName' => '<p>The name of a logical container where backups are stored. Backup vaults are identified by names that are unique to the account used to create them and the Amazon Web Services Region where they are created. They consist of lowercase letters, numbers, and hyphens.</p>', 'StartBackupJobInput$BackupVaultName' => '<p>The name of a logical container where backups are stored. Backup vaults are identified by names that are unique to the account used to create them and the Amazon Web Services Region where they are created. They consist of lowercase letters, numbers, and hyphens.</p>', 'StartCopyJobInput$SourceBackupVaultName' => '<p>The name of a logical source container where backups are stored. Backup vaults are identified by names that are unique to the account used to create them and the Amazon Web Services Region where they are created. They consist of lowercase letters, numbers, and hyphens.</p>', 'UpdateRecoveryPointLifecycleInput$BackupVaultName' => '<p>The name of a logical container where backups are stored. Backup vaults are identified by names that are unique to the account used to create them and the Amazon Web Services Region where they are created. They consist of lowercase letters, numbers, and hyphens.</p>', ], ], 'Boolean' => [ 'base' => NULL, 'refs' => [ 'BackupRule$EnableContinuousBackup' => '<p>Specifies whether Backup creates continuous backups. True causes Backup to create continuous backups capable of point-in-time restore (PITR). False (or not specified) causes Backup to create snapshot backups.</p>', 'BackupRuleInput$EnableContinuousBackup' => '<p>Specifies whether Backup creates continuous backups. True causes Backup to create continuous backups capable of point-in-time restore (PITR). False (or not specified) causes Backup to create snapshot backups.</p>', 'BackupVaultListMember$Locked' => '<p>A Boolean value that indicates whether Backup Vault Lock applies to the selected backup vault. If <code>true</code>, Vault Lock prevents delete and update operations on the recovery points in the selected vault.</p>', 'DescribeBackupVaultOutput$Locked' => '<p>A Boolean that indicates whether Backup Vault Lock is currently protecting the backup vault. <code>True</code> means that Vault Lock causes delete or update operations on the recovery points stored in the vault to fail.</p>', 'ListBackupPlansInput$IncludeDeleted' => '<p>A Boolean value with a default value of <code>FALSE</code> that returns deleted backup plans when set to <code>TRUE</code>.</p>', ], ], 'CalculatedLifecycle' => [ 'base' => '<p>Contains <code>DeleteAt</code> and <code>MoveToColdStorageAt</code> timestamps, which are used to specify a lifecycle for a recovery point.</p> <p>The lifecycle defines when a protected resource is transitioned to cold storage and when it expires. Backup transitions and expires backups automatically according to the lifecycle that you define.</p> <p>Backups transitioned to cold storage must be stored in cold storage for a minimum of 90 days. Therefore, the “expire after days” setting must be 90 days greater than the “transition to cold after days” setting. The “transition to cold after days” setting cannot be changed after a backup has been transitioned to cold.</p> <p>Only Amazon EFS file system backups can be transitioned to cold storage.</p>', 'refs' => [ 'DescribeRecoveryPointOutput$CalculatedLifecycle' => '<p>A <code>CalculatedLifecycle</code> object containing <code>DeleteAt</code> and <code>MoveToColdStorageAt</code> timestamps.</p>', 'RecoveryPointByBackupVault$CalculatedLifecycle' => '<p>A <code>CalculatedLifecycle</code> object containing <code>DeleteAt</code> and <code>MoveToColdStorageAt</code> timestamps.</p>', 'UpdateRecoveryPointLifecycleOutput$CalculatedLifecycle' => '<p>A <code>CalculatedLifecycle</code> object containing <code>DeleteAt</code> and <code>MoveToColdStorageAt</code> timestamps.</p>', ], ], 'ComplianceResourceIdList' => [ 'base' => NULL, 'refs' => [ 'ControlScope$ComplianceResourceIds' => '<p>The ID of the only Amazon Web Services resource that you want your control scope to contain.</p>', ], ], 'Condition' => [ 'base' => '<p>Contains an array of triplets made up of a condition type (such as <code>StringEquals</code>), a key, and a value. Conditions are used to filter resources in a selection that is assigned to a backup plan.</p>', 'refs' => [ 'ListOfTags$member' => NULL, ], ], 'ConditionKey' => [ 'base' => NULL, 'refs' => [ 'Condition$ConditionKey' => '<p>The key in a key-value pair. For example, in <code>"ec2:ResourceTag/Department": "accounting"</code>, <code>"ec2:ResourceTag/Department"</code> is the key.</p>', 'ConditionParameter$ConditionKey' => NULL, ], ], 'ConditionParameter' => [ 'base' => NULL, 'refs' => [ 'ConditionParameters$member' => NULL, ], ], 'ConditionParameters' => [ 'base' => NULL, 'refs' => [ 'Conditions$StringEquals' => NULL, 'Conditions$StringNotEquals' => NULL, 'Conditions$StringLike' => NULL, 'Conditions$StringNotLike' => NULL, ], ], 'ConditionType' => [ 'base' => NULL, 'refs' => [ 'Condition$ConditionType' => '<p>An operation, such as <code>StringEquals</code>, that is applied to a key-value pair used to filter resources in a selection.</p>', ], ], 'ConditionValue' => [ 'base' => NULL, 'refs' => [ 'Condition$ConditionValue' => '<p>The value in a key-value pair. For example, in <code>"ec2:ResourceTag/Department": "accounting"</code>, <code>"accounting"</code> is the value.</p>', 'ConditionParameter$ConditionValue' => NULL, ], ], 'Conditions' => [ 'base' => NULL, 'refs' => [ 'BackupSelection$Conditions' => NULL, ], ], 'ConflictException' => [ 'base' => '<p>Backup can\'t perform the action that you requested until it finishes performing a previous action. Try again later.</p>', 'refs' => [], ], 'ControlInputParameter' => [ 'base' => '<p>A list of parameters for a control. A control can have zero, one, or more than one parameter. An example of a control with two parameters is: "backup plan frequency is at least <code>daily</code> and the retention period is at least <code>1 year</code>". The first parameter is <code>daily</code>. The second parameter is <code>1 year</code>.</p>', 'refs' => [ 'ControlInputParameters$member' => NULL, ], ], 'ControlInputParameters' => [ 'base' => NULL, 'refs' => [ 'FrameworkControl$ControlInputParameters' => '<p>A list of <code>ParameterName</code> and <code>ParameterValue</code> pairs.</p>', ], ], 'ControlName' => [ 'base' => NULL, 'refs' => [ 'FrameworkControl$ControlName' => '<p>The name of a control. This name is between 1 and 256 characters.</p>', ], ], 'ControlScope' => [ 'base' => '<p>A framework consists of one or more controls. Each control has its own control scope. The control scope defines what the control will evaluate. Three examples of control scopes are: a specific backup plan, all backup plans with a specific tag, or all backup plans.</p> <note> <p>To set a control scope that includes all of a particular resource, leave the <code>ControlScope</code> empty or do not pass it when calling <code>CreateFramework</code>.</p> </note>', 'refs' => [ 'FrameworkControl$ControlScope' => '<p>The scope of a control. The control scope defines what the control will evaluate. Three examples of control scopes are: a specific backup plan, all backup plans with a specific tag, or all backup plans. For more information, see <code>ControlScope</code>.</p>', ], ], 'CopyAction' => [ 'base' => '<p>The details of the copy operation.</p>', 'refs' => [ 'CopyActions$member' => NULL, ], ], 'CopyActions' => [ 'base' => NULL, 'refs' => [ 'BackupRule$CopyActions' => '<p>An array of <code>CopyAction</code> objects, which contains the details of the copy operation.</p>', 'BackupRuleInput$CopyActions' => '<p>An array of <code>CopyAction</code> objects, which contains the details of the copy operation.</p>', ], ], 'CopyJob' => [ 'base' => '<p>Contains detailed information about a copy job.</p>', 'refs' => [ 'CopyJobsList$member' => NULL, 'DescribeCopyJobOutput$CopyJob' => '<p>Contains detailed information about a copy job.</p>', ], ], 'CopyJobState' => [ 'base' => NULL, 'refs' => [ 'CopyJob$State' => '<p>The current state of a copy job.</p>', 'ListCopyJobsInput$ByState' => '<p>Returns only copy jobs that are in the specified state.</p>', ], ], 'CopyJobsList' => [ 'base' => NULL, 'refs' => [ 'ListCopyJobsOutput$CopyJobs' => '<p>An array of structures containing metadata about your copy jobs returned in JSON format. </p>', ], ], 'CreateBackupPlanInput' => [ 'base' => NULL, 'refs' => [], ], 'CreateBackupPlanOutput' => [ 'base' => NULL, 'refs' => [], ], 'CreateBackupSelectionInput' => [ 'base' => NULL, 'refs' => [], ], 'CreateBackupSelectionOutput' => [ 'base' => NULL, 'refs' => [], ], 'CreateBackupVaultInput' => [ 'base' => NULL, 'refs' => [], ], 'CreateBackupVaultOutput' => [ 'base' => NULL, 'refs' => [], ], 'CreateFrameworkInput' => [ 'base' => NULL, 'refs' => [], ], 'CreateFrameworkOutput' => [ 'base' => NULL, 'refs' => [], ], 'CreateReportPlanInput' => [ 'base' => NULL, 'refs' => [], ], 'CreateReportPlanOutput' => [ 'base' => NULL, 'refs' => [], ], 'CronExpression' => [ 'base' => NULL, 'refs' => [ 'BackupRule$ScheduleExpression' => '<p>A cron expression in UTC specifying when Backup initiates a backup job. For more information about cron expressions, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/ScheduledEvents.html">Schedule Expressions for Rules</a> in the <i>Amazon CloudWatch Events User Guide.</i>. Prior to specifying a value for this parameter, we recommend testing your cron expression using one of the many available cron generator and testing tools.</p>', 'BackupRuleInput$ScheduleExpression' => '<p>A CRON expression in UTC specifying when Backup initiates a backup job.</p>', ], ], 'DeleteBackupPlanInput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteBackupPlanOutput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteBackupSelectionInput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteBackupVaultAccessPolicyInput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteBackupVaultInput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteBackupVaultLockConfigurationInput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteBackupVaultNotificationsInput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteFrameworkInput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteRecoveryPointInput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteReportPlanInput' => [ 'base' => NULL, 'refs' => [], ], 'DependencyFailureException' => [ 'base' => '<p>A dependent Amazon Web Services service or resource returned an error to the Backup service, and the action cannot be completed.</p>', 'refs' => [], ], 'DescribeBackupJobInput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeBackupJobOutput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeBackupVaultInput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeBackupVaultOutput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeCopyJobInput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeCopyJobOutput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeFrameworkInput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeFrameworkOutput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeGlobalSettingsInput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeGlobalSettingsOutput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeProtectedResourceInput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeProtectedResourceOutput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeRecoveryPointInput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeRecoveryPointOutput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeRegionSettingsInput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeRegionSettingsOutput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeReportJobInput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeReportJobOutput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeReportPlanInput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeReportPlanOutput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeRestoreJobInput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeRestoreJobOutput' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateRecoveryPointInput' => [ 'base' => NULL, 'refs' => [], ], 'ExportBackupPlanTemplateInput' => [ 'base' => NULL, 'refs' => [], ], 'ExportBackupPlanTemplateOutput' => [ 'base' => NULL, 'refs' => [], ], 'FormatList' => [ 'base' => NULL, 'refs' => [ 'ReportDeliveryChannel$Formats' => '<p>A list of the format of your reports: <code>CSV</code>, <code>JSON</code>, or both. If not specified, the default format is <code>CSV</code>.</p>', ], ], 'Framework' => [ 'base' => '<p>Contains detailed information about a framework. Frameworks contain controls, which evaluate and report on your backup events and resources. Frameworks generate daily compliance results.</p>', 'refs' => [ 'FrameworkList$member' => NULL, ], ], 'FrameworkControl' => [ 'base' => '<p>Contains detailed information about all of the controls of a framework. Each framework must contain at least one control.</p>', 'refs' => [ 'FrameworkControls$member' => NULL, ], ], 'FrameworkControls' => [ 'base' => NULL, 'refs' => [ 'CreateFrameworkInput$FrameworkControls' => '<p>A list of the controls that make up the framework. Each control in the list has a name, input parameters, and scope.</p>', 'DescribeFrameworkOutput$FrameworkControls' => '<p>A list of the controls that make up the framework. Each control in the list has a name, input parameters, and scope.</p>', 'UpdateFrameworkInput$FrameworkControls' => '<p>A list of the controls that make up the framework. Each control in the list has a name, input parameters, and scope.</p>', ], ], 'FrameworkDescription' => [ 'base' => NULL, 'refs' => [ 'CreateFrameworkInput$FrameworkDescription' => '<p>An optional description of the framework with a maximum of 1,024 characters.</p>', 'DescribeFrameworkOutput$FrameworkDescription' => '<p>An optional description of the framework.</p>', 'Framework$FrameworkDescription' => '<p>An optional description of the framework with a maximum 1,024 characters.</p>', 'UpdateFrameworkInput$FrameworkDescription' => '<p>An optional description of the framework with a maximum 1,024 characters.</p>', ], ], 'FrameworkList' => [ 'base' => NULL, 'refs' => [ 'ListFrameworksOutput$Frameworks' => '<p>A list of frameworks with details for each framework, including the framework name, Amazon Resource Name (ARN), description, number of controls, creation time, and deployment status.</p>', ], ], 'FrameworkName' => [ 'base' => NULL, 'refs' => [ 'CreateFrameworkInput$FrameworkName' => '<p>The unique name of the framework. The name must be between 1 and 256 characters, starting with a letter, and consisting of letters (a-z, A-Z), numbers (0-9), and underscores (_).</p>', 'CreateFrameworkOutput$FrameworkName' => '<p>The unique name of the framework. The name must be between 1 and 256 characters, starting with a letter, and consisting of letters (a-z, A-Z), numbers (0-9), and underscores (_).</p>', 'DeleteFrameworkInput$FrameworkName' => '<p>The unique name of a framework.</p>', 'DescribeFrameworkInput$FrameworkName' => '<p>The unique name of a framework.</p>', 'DescribeFrameworkOutput$FrameworkName' => '<p>The unique name of a framework.</p>', 'Framework$FrameworkName' => '<p>The unique name of a framework. This name is between 1 and 256 characters, starting with a letter, and consisting of letters (a-z, A-Z), numbers (0-9), and underscores (_).</p>', 'UpdateFrameworkInput$FrameworkName' => '<p>The unique name of a framework. This name is between 1 and 256 characters, starting with a letter, and consisting of letters (a-z, A-Z), numbers (0-9), and underscores (_).</p>', 'UpdateFrameworkOutput$FrameworkName' => '<p>The unique name of a framework. This name is between 1 and 256 characters, starting with a letter, and consisting of letters (a-z, A-Z), numbers (0-9), and underscores (_).</p>', ], ], 'GetBackupPlanFromJSONInput' => [ 'base' => NULL, 'refs' => [], ], 'GetBackupPlanFromJSONOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetBackupPlanFromTemplateInput' => [ 'base' => NULL, 'refs' => [], ], 'GetBackupPlanFromTemplateOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetBackupPlanInput' => [ 'base' => NULL, 'refs' => [], ], 'GetBackupPlanOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetBackupSelectionInput' => [ 'base' => NULL, 'refs' => [], ], 'GetBackupSelectionOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetBackupVaultAccessPolicyInput' => [ 'base' => NULL, 'refs' => [], ], 'GetBackupVaultAccessPolicyOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetBackupVaultNotificationsInput' => [ 'base' => NULL, 'refs' => [], ], 'GetBackupVaultNotificationsOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetRecoveryPointRestoreMetadataInput' => [ 'base' => NULL, 'refs' => [], ], 'GetRecoveryPointRestoreMetadataOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetSupportedResourceTypesOutput' => [ 'base' => NULL, 'refs' => [], ], 'GlobalSettings' => [ 'base' => NULL, 'refs' => [ 'DescribeGlobalSettingsOutput$GlobalSettings' => '<p>The status of the flag <code>isCrossAccountBackupEnabled</code>.</p>', 'UpdateGlobalSettingsInput$GlobalSettings' => '<p>A value for <code>isCrossAccountBackupEnabled</code> and a Region. Example: <code>update-global-settings --global-settings isCrossAccountBackupEnabled=false --region us-west-2</code>.</p>', ], ], 'GlobalSettingsName' => [ 'base' => NULL, 'refs' => [ 'GlobalSettings$key' => NULL, ], ], 'GlobalSettingsValue' => [ 'base' => NULL, 'refs' => [ 'GlobalSettings$value' => NULL, ], ], 'IAMPolicy' => [ 'base' => NULL, 'refs' => [ 'GetBackupVaultAccessPolicyOutput$Policy' => '<p>The backup vault access policy document in JSON format.</p>', 'PutBackupVaultAccessPolicyInput$Policy' => '<p>The backup vault access policy document in JSON format.</p>', ], ], 'IAMRoleArn' => [ 'base' => NULL, 'refs' => [ 'BackupJob$IamRoleArn' => '<p>Specifies the IAM role ARN used to create the target recovery point. IAM roles other than the default role must include either <code>AWSBackup</code> or <code>AwsBackup</code> in the role name. For example, <code>arn:aws:iam::123456789012:role/AWSBackupRDSAccess</code>. Role names without those strings lack permissions to perform backup jobs.</p>', 'BackupSelection$IamRoleArn' => '<p>The ARN of the IAM role that Backup uses to authenticate when backing up the target resource; for example, <code>arn:aws:iam::123456789012:role/S3Access</code>.</p>', 'BackupSelectionsListMember$IamRoleArn' => '<p>Specifies the IAM role Amazon Resource Name (ARN) to create the target recovery point; for example, <code>arn:aws:iam::123456789012:role/S3Access</code>.</p>', 'CopyJob$IamRoleArn' => '<p>Specifies the IAM role ARN used to copy the target recovery point; for example, <code>arn:aws:iam::123456789012:role/S3Access</code>.</p>', 'DescribeBackupJobOutput$IamRoleArn' => '<p>Specifies the IAM role ARN used to create the target recovery point; for example, <code>arn:aws:iam::123456789012:role/S3Access</code>.</p>', 'DescribeRecoveryPointOutput$IamRoleArn' => '<p>Specifies the IAM role ARN used to create the target recovery point; for example, <code>arn:aws:iam::123456789012:role/S3Access</code>.</p>', 'DescribeRestoreJobOutput$IamRoleArn' => '<p>Specifies the IAM role ARN used to create the target recovery point; for example, <code>arn:aws:iam::123456789012:role/S3Access</code>.</p>', 'RecoveryPointByBackupVault$IamRoleArn' => '<p>Specifies the IAM role ARN used to create the target recovery point; for example, <code>arn:aws:iam::123456789012:role/S3Access</code>.</p>', 'RestoreJobsListMember$IamRoleArn' => '<p>Specifies the IAM role ARN used to create the target recovery point; for example, <code>arn:aws:iam::123456789012:role/S3Access</code>.</p>', 'StartBackupJobInput$IamRoleArn' => '<p>Specifies the IAM role ARN used to create the target recovery point; for example, <code>arn:aws:iam::123456789012:role/S3Access</code>.</p>', 'StartCopyJobInput$IamRoleArn' => '<p>Specifies the IAM role ARN used to copy the target recovery point; for example, <code>arn:aws:iam::123456789012:role/S3Access</code>.</p>', 'StartRestoreJobInput$IamRoleArn' => '<p>The Amazon Resource Name (ARN) of the IAM role that Backup uses to create the target recovery point; for example, <code>arn:aws:iam::123456789012:role/S3Access</code>.</p>', ], ], 'InvalidParameterValueException' => [ 'base' => '<p>Indicates that something is wrong with a parameter\'s value. For example, the value is out of range.</p>', 'refs' => [], ], 'InvalidRequestException' => [ 'base' => '<p>Indicates that something is wrong with the input to the request. For example, a parameter is of the wrong type.</p>', 'refs' => [], ], 'InvalidResourceStateException' => [ 'base' => '<p>Backup is already performing an action on this recovery point. It can\'t perform the action you requested until the first action finishes. Try again later.</p>', 'refs' => [], ], 'IsEnabled' => [ 'base' => NULL, 'refs' => [ 'ResourceTypeOptInPreference$value' => NULL, ], ], 'Lifecycle' => [ 'base' => '<p>Contains an array of <code>Transition</code> objects specifying how long in days before a recovery point transitions to cold storage or is deleted.</p> <p>Backups transitioned to cold storage must be stored in cold storage for a minimum of 90 days. Therefore, on the console, the “expire after days” setting must be 90 days greater than the “transition to cold after days” setting. The “transition to cold after days” setting cannot be changed after a backup has been transitioned to cold.</p> <p>Only Amazon EFS file system backups can be transitioned to cold storage.</p>', 'refs' => [ 'BackupRule$Lifecycle' => '<p>The lifecycle defines when a protected resource is transitioned to cold storage and when it expires. Backup transitions and expires backups automatically according to the lifecycle that you define. </p> <p>Backups transitioned to cold storage must be stored in cold storage for a minimum of 90 days. Therefore, the “expire after days” setting must be 90 days greater than the “transition to cold after days” setting. The “transition to cold after days” setting cannot be changed after a backup has been transitioned to cold. </p> <p>Only Amazon EFS file system backups can be transitioned to cold storage.</p>', 'BackupRuleInput$Lifecycle' => '<p>The lifecycle defines when a protected resource is transitioned to cold storage and when it expires. Backup will transition and expire backups automatically according to the lifecycle that you define. </p> <p>Backups transitioned to cold storage must be stored in cold storage for a minimum of 90 days. Therefore, the “expire after days” setting must be 90 days greater than the “transition to cold after days” setting. The “transition to cold after days” setting cannot be changed after a backup has been transitioned to cold. </p> <p>Only Amazon EFS file system backups can be transitioned to cold storage.</p>', 'CopyAction$Lifecycle' => NULL, 'DescribeRecoveryPointOutput$Lifecycle' => '<p>The lifecycle defines when a protected resource is transitioned to cold storage and when it expires. Backup transitions and expires backups automatically according to the lifecycle that you define. </p> <p>Backups that are transitioned to cold storage must be stored in cold storage for a minimum of 90 days. Therefore, the “expire after days” setting must be 90 days greater than the “transition to cold after days” setting. The “transition to cold after days” setting cannot be changed after a backup has been transitioned to cold. </p> <p>Only Amazon EFS file system backups can be transitioned to cold storage.</p>', 'RecoveryPointByBackupVault$Lifecycle' => '<p>The lifecycle defines when a protected resource is transitioned to cold storage and when it expires. Backup transitions and expires backups automatically according to the lifecycle that you define. </p> <p>Backups transitioned to cold storage must be stored in cold storage for a minimum of 90 days. Therefore, the “expire after days” setting must be 90 days greater than the “transition to cold after days” setting. The “transition to cold after days” setting cannot be changed after a backup has been transitioned to cold. </p> <p>Only Amazon EFS file system backups can be transitioned to cold storage.</p>', 'StartBackupJobInput$Lifecycle' => '<p>The lifecycle defines when a protected resource is transitioned to cold storage and when it expires. Backup will transition and expire backups automatically according to the lifecycle that you define. </p> <p>Backups transitioned to cold storage must be stored in cold storage for a minimum of 90 days. Therefore, the “expire after days” setting must be 90 days greater than the “transition to cold after days” setting. The “transition to cold after days” setting cannot be changed after a backup has been transitioned to cold. </p> <p>Only Amazon EFS file system backups can be transitioned to cold storage.</p>', 'StartCopyJobInput$Lifecycle' => NULL, 'UpdateRecoveryPointLifecycleInput$Lifecycle' => '<p>The lifecycle defines when a protected resource is transitioned to cold storage and when it expires. Backup transitions and expires backups automatically according to the lifecycle that you define. </p> <p>Backups transitioned to cold storage must be stored in cold storage for a minimum of 90 days. Therefore, the “expire after days” setting must be 90 days greater than the “transition to cold after days” setting. The “transition to cold after days” setting cannot be changed after a backup has been transitioned to cold. </p>', 'UpdateRecoveryPointLifecycleOutput$Lifecycle' => '<p>The lifecycle defines when a protected resource is transitioned to cold storage and when it expires. Backup transitions and expires backups automatically according to the lifecycle that you define. </p> <p>Backups transitioned to cold storage must be stored in cold storage for a minimum of 90 days. Therefore, the “expire after days” setting must be 90 days greater than the “transition to cold after days” setting. The “transition to cold after days” setting cannot be changed after a backup has been transitioned to cold. </p> <p>Only Amazon EFS file system backups can be transitioned to cold storage.</p>', ], ], 'LimitExceededException' => [ 'base' => '<p>A limit in the request has been exceeded; for example, a maximum number of items allowed in a request.</p>', 'refs' => [], ], 'ListBackupJobsInput' => [ 'base' => NULL, 'refs' => [], ], 'ListBackupJobsOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListBackupPlanTemplatesInput' => [ 'base' => NULL, 'refs' => [], ], 'ListBackupPlanTemplatesOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListBackupPlanVersionsInput' => [ 'base' => NULL, 'refs' => [], ], 'ListBackupPlanVersionsOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListBackupPlansInput' => [ 'base' => NULL, 'refs' => [], ], 'ListBackupPlansOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListBackupSelectionsInput' => [ 'base' => NULL, 'refs' => [], ], 'ListBackupSelectionsOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListBackupVaultsInput' => [ 'base' => NULL, 'refs' => [], ], 'ListBackupVaultsOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListCopyJobsInput' => [ 'base' => NULL, 'refs' => [], ], 'ListCopyJobsOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListFrameworksInput' => [ 'base' => NULL, 'refs' => [], ], 'ListFrameworksOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListOfTags' => [ 'base' => NULL, 'refs' => [ 'BackupSelection$ListOfTags' => '<p>An array of conditions used to specify a set of resources to assign to a backup plan; for example, <code>"StringEquals": {"ec2:ResourceTag/Department": "accounting"</code>. Assigns the backup plan to every resource with at least one matching tag.</p>', ], ], 'ListProtectedResourcesInput' => [ 'base' => NULL, 'refs' => [], ], 'ListProtectedResourcesOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListRecoveryPointsByBackupVaultInput' => [ 'base' => NULL, 'refs' => [], ], 'ListRecoveryPointsByBackupVaultOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListRecoveryPointsByResourceInput' => [ 'base' => NULL, 'refs' => [], ], 'ListRecoveryPointsByResourceOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListReportJobsInput' => [ 'base' => NULL, 'refs' => [], ], 'ListReportJobsOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListReportPlansInput' => [ 'base' => NULL, 'refs' => [], ], 'ListReportPlansOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListRestoreJobsInput' => [ 'base' => NULL, 'refs' => [], ], 'ListRestoreJobsOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsInput' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsOutput' => [ 'base' => NULL, 'refs' => [], ], 'Long' => [ 'base' => NULL, 'refs' => [ 'BackupJob$BackupSizeInBytes' => '<p>The size, in bytes, of a backup.</p>', 'BackupJob$BytesTransferred' => '<p>The size in bytes transferred to a backup vault at the time that the job status was queried.</p>', 'BackupVaultListMember$MinRetentionDays' => '<p>The Backup Vault Lock setting that specifies the minimum retention period that the vault retains its recovery points. If this parameter is not specified, Vault Lock does not enforce a minimum retention period.</p> <p>If specified, any backup or copy job to the vault must have a lifecycle policy with a retention period equal to or longer than the minimum retention period. If the job\'s retention period is shorter than that minimum retention period, then the vault fails the backup or copy job, and you should either modify your lifecycle settings or use a different vault. Recovery points already stored in the vault prior to Vault Lock are not affected.</p>', 'BackupVaultListMember$MaxRetentionDays' => '<p>The Backup Vault Lock setting that specifies the maximum retention period that the vault retains its recovery points. If this parameter is not specified, Vault Lock does not enforce a maximum retention period on the recovery points in the vault (allowing indefinite storage).</p> <p>If specified, any backup or copy job to the vault must have a lifecycle policy with a retention period equal to or shorter than the maximum retention period. If the job\'s retention period is longer than that maximum retention period, then the vault fails the backup or copy job, and you should either modify your lifecycle settings or use a different vault. Recovery points already stored in the vault prior to Vault Lock are not affected.</p>', 'CopyJob$BackupSizeInBytes' => '<p>The size, in bytes, of a copy job.</p>', 'DescribeBackupJobOutput$BackupSizeInBytes' => '<p>The size, in bytes, of a backup.</p>', 'DescribeBackupJobOutput$BytesTransferred' => '<p>The size in bytes transferred to a backup vault at the time that the job status was queried.</p>', 'DescribeBackupVaultOutput$MinRetentionDays' => '<p>The Backup Vault Lock setting that specifies the minimum retention period that the vault retains its recovery points. If this parameter is not specified, Vault Lock does not enforce a minimum retention period.</p> <p>If specified, any backup or copy job to the vault must have a lifecycle policy with a retention period equal to or longer than the minimum retention period. If the job\'s retention period is shorter than that minimum retention period, then the vault fails the backup or copy job, and you should either modify your lifecycle settings or use a different vault. Recovery points already stored in the vault prior to Vault Lock are not affected.</p>', 'DescribeBackupVaultOutput$MaxRetentionDays' => '<p>The Backup Vault Lock setting that specifies the maximum retention period that the vault retains its recovery points. If this parameter is not specified, Vault Lock does not enforce a maximum retention period on the recovery points in the vault (allowing indefinite storage).</p> <p>If specified, any backup or copy job to the vault must have a lifecycle policy with a retention period equal to or shorter than the maximum retention period. If the job\'s retention period is longer than that maximum retention period, then the vault fails the backup or copy job, and you should either modify your lifecycle settings or use a different vault. Recovery points already stored in the vault prior to Vault Lock are not affected.</p>', 'DescribeRecoveryPointOutput$BackupSizeInBytes' => '<p>The size, in bytes, of a backup.</p>', 'DescribeRestoreJobOutput$BackupSizeInBytes' => '<p>The size, in bytes, of the restored resource.</p>', 'DescribeRestoreJobOutput$ExpectedCompletionTimeMinutes' => '<p>The amount of time in minutes that a job restoring a recovery point is expected to take.</p>', 'Lifecycle$MoveToColdStorageAfterDays' => '<p>Specifies the number of days after creation that a recovery point is moved to cold storage.</p>', 'Lifecycle$DeleteAfterDays' => '<p>Specifies the number of days after creation that a recovery point is deleted. Must be greater than 90 days plus <code>MoveToColdStorageAfterDays</code>.</p>', 'PutBackupVaultLockConfigurationInput$MinRetentionDays' => '<p>The Backup Vault Lock configuration that specifies the minimum retention period that the vault retains its recovery points. This setting can be useful if, for example, your organization\'s policies require you to retain certain data for at least seven years (2555 days).</p> <p>If this parameter is not specified, Vault Lock will not enforce a minimum retention period.</p> <p>If this parameter is specified, any backup or copy job to the vault must have a lifecycle policy with a retention period equal to or longer than the minimum retention period. If the job\'s retention period is shorter than that minimum retention period, then the vault fails that backup or copy job, and you should either modify your lifecycle settings or use a different vault. Recovery points already saved in the vault prior to Vault Lock are not affected.</p>', 'PutBackupVaultLockConfigurationInput$MaxRetentionDays' => '<p>The Backup Vault Lock configuration that specifies the maximum retention period that the vault retains its recovery points. This setting can be useful if, for example, your organization\'s policies require you to destroy certain data after retaining it for four years (1460 days).</p> <p>If this parameter is not included, Vault Lock does not enforce a maximum retention period on the recovery points in the vault. If this parameter is included without a value, Vault Lock will not enforce a maximum retention period.</p> <p>If this parameter is specified, any backup or copy job to the vault must have a lifecycle policy with a retention period equal to or shorter than the maximum retention period. If the job\'s retention period is longer than that maximum retention period, then the vault fails the backup or copy job, and you should either modify your lifecycle settings or use a different vault. Recovery points already saved in the vault prior to Vault Lock are not affected.</p>', 'PutBackupVaultLockConfigurationInput$ChangeableForDays' => '<p>The Backup Vault Lock configuration that specifies the number of days before the lock date. For example, setting <code>ChangeableForDays</code> to 30 on Jan. 1, 2022 at 8pm UTC will set the lock date to Jan. 31, 2022 at 8pm UTC.</p> <p>Backup enforces a 72-hour cooling-off period before Vault Lock takes effect and becomes immutable. Therefore, you must set <code>ChangeableForDays</code> to 3 or greater.</p> <p>Before the lock date, you can delete Vault Lock from the vault using <code>DeleteBackupVaultLockConfiguration</code> or change the Vault Lock configuration using <code>PutBackupVaultLockConfiguration</code>. On and after the lock date, the Vault Lock becomes immutable and cannot be changed or deleted.</p> <p>If this parameter is not specified, you can delete Vault Lock from the vault using <code>DeleteBackupVaultLockConfiguration</code> or change the Vault Lock configuration using <code>PutBackupVaultLockConfiguration</code> at any time.</p>', 'RecoveryPointByBackupVault$BackupSizeInBytes' => '<p>The size, in bytes, of a backup.</p>', 'RecoveryPointByResource$BackupSizeBytes' => '<p>The size, in bytes, of a backup.</p>', 'RestoreJobsListMember$BackupSizeInBytes' => '<p>The size, in bytes, of the restored resource.</p>', 'RestoreJobsListMember$ExpectedCompletionTimeMinutes' => '<p>The amount of time in minutes that a job restoring a recovery point is expected to take.</p>', ], ], 'MaxFrameworkInputs' => [ 'base' => NULL, 'refs' => [ 'ListFrameworksInput$MaxResults' => '<p>The number of desired results from 1 to 1000. Optional. If unspecified, the query will return 1 MB of data.</p>', ], ], 'MaxResults' => [ 'base' => NULL, 'refs' => [ 'ListBackupJobsInput$MaxResults' => '<p>The maximum number of items to be returned.</p>', 'ListBackupPlanTemplatesInput$MaxResults' => '<p>The maximum number of items to be returned.</p>', 'ListBackupPlanVersionsInput$MaxResults' => '<p>The maximum number of items to be returned.</p>', 'ListBackupPlansInput$MaxResults' => '<p>The maximum number of items to be returned.</p>', 'ListBackupSelectionsInput$MaxResults' => '<p>The maximum number of items to be returned.</p>', 'ListBackupVaultsInput$MaxResults' => '<p>The maximum number of items to be returned.</p>', 'ListCopyJobsInput$MaxResults' => '<p>The maximum number of items to be returned.</p>', 'ListProtectedResourcesInput$MaxResults' => '<p>The maximum number of items to be returned.</p>', 'ListRecoveryPointsByBackupVaultInput$MaxResults' => '<p>The maximum number of items to be returned.</p>', 'ListRecoveryPointsByResourceInput$MaxResults' => '<p>The maximum number of items to be returned.</p> <note> <p>Amazon RDS requires a value of at least 20.</p> </note>', 'ListReportJobsInput$MaxResults' => '<p>The number of desired results from 1 to 1000. Optional. If unspecified, the query will return 1 MB of data.</p>', 'ListReportPlansInput$MaxResults' => '<p>The number of desired results from 1 to 1000. Optional. If unspecified, the query will return 1 MB of data.</p>', 'ListRestoreJobsInput$MaxResults' => '<p>The maximum number of items to be returned.</p>', 'ListTagsInput$MaxResults' => '<p>The maximum number of items to be returned.</p>', ], ], 'Metadata' => [ 'base' => NULL, 'refs' => [ 'GetRecoveryPointRestoreMetadataOutput$RestoreMetadata' => '<p>The set of metadata key-value pairs that describe the original configuration of the backed-up resource. These values vary depending on the service that is being restored.</p>', 'StartRestoreJobInput$Metadata' => '<p>A set of metadata key-value pairs. Contains information, such as a resource name, required to restore a recovery point.</p> <p> You can get configuration metadata about a resource at the time it was backed up by calling <code>GetRecoveryPointRestoreMetadata</code>. However, values in addition to those provided by <code>GetRecoveryPointRestoreMetadata</code> might be required to restore a resource. For example, you might need to provide a new resource name if the original already exists.</p> <p>You need to specify specific metadata to restore an Amazon Elastic File System (Amazon EFS) instance:</p> <ul> <li> <p> <code>file-system-id</code>: The ID of the Amazon EFS file system that is backed up by Backup. Returned in <code>GetRecoveryPointRestoreMetadata</code>.</p> </li> <li> <p> <code>Encrypted</code>: A Boolean value that, if true, specifies that the file system is encrypted. If <code>KmsKeyId</code> is specified, <code>Encrypted</code> must be set to <code>true</code>.</p> </li> <li> <p> <code>KmsKeyId</code>: Specifies the Amazon Web Services KMS key that is used to encrypt the restored file system. You can specify a key from another Amazon Web Services account provided that key it is properly shared with your account via Amazon Web Services KMS.</p> </li> <li> <p> <code>PerformanceMode</code>: Specifies the throughput mode of the file system.</p> </li> <li> <p> <code>CreationToken</code>: A user-supplied value that ensures the uniqueness (idempotency) of the request.</p> </li> <li> <p> <code>newFileSystem</code>: A Boolean value that, if true, specifies that the recovery point is restored to a new Amazon EFS file system.</p> </li> <li> <p> <code>ItemsToRestore</code>: An array of one to five strings where each string is a file path. Use <code>ItemsToRestore</code> to restore specific files or directories rather than the entire file system. This parameter is optional. For example, <code>"itemsToRestore":"[\\"/my.test\\"]"</code>.</p> </li> </ul>', ], ], 'MetadataKey' => [ 'base' => NULL, 'refs' => [ 'Metadata$key' => NULL, ], ], 'MetadataValue' => [ 'base' => NULL, 'refs' => [ 'Metadata$value' => NULL, ], ], 'MissingParameterValueException' => [ 'base' => '<p>Indicates that a required parameter is missing.</p>', 'refs' => [], ], 'ParameterName' => [ 'base' => NULL, 'refs' => [ 'ControlInputParameter$ParameterName' => '<p>The name of a parameter, for example, <code>BackupPlanFrequency</code>.</p>', ], ], 'ParameterValue' => [ 'base' => NULL, 'refs' => [ 'ControlInputParameter$ParameterValue' => '<p>The value of parameter, for example, <code>hourly</code>.</p>', ], ], 'ProtectedResource' => [ 'base' => '<p>A structure that contains information about a backed-up resource.</p>', 'refs' => [ 'ProtectedResourcesList$member' => NULL, ], ], 'ProtectedResourcesList' => [ 'base' => NULL, 'refs' => [ 'ListProtectedResourcesOutput$Results' => '<p>An array of resources successfully backed up by Backup including the time the resource was saved, an Amazon Resource Name (ARN) of the resource, and a resource type.</p>', ], ], 'PutBackupVaultAccessPolicyInput' => [ 'base' => NULL, 'refs' => [], ], 'PutBackupVaultLockConfigurationInput' => [ 'base' => NULL, 'refs' => [], ], 'PutBackupVaultNotificationsInput' => [ 'base' => NULL, 'refs' => [], ], 'RecoveryPointByBackupVault' => [ 'base' => '<p>Contains detailed information about the recovery points stored in a backup vault.</p>', 'refs' => [ 'RecoveryPointByBackupVaultList$member' => NULL, ], ], 'RecoveryPointByBackupVaultList' => [ 'base' => NULL, 'refs' => [ 'ListRecoveryPointsByBackupVaultOutput$RecoveryPoints' => '<p>An array of objects that contain detailed information about recovery points saved in a backup vault.</p>', ], ], 'RecoveryPointByResource' => [ 'base' => '<p>Contains detailed information about a saved recovery point.</p>', 'refs' => [ 'RecoveryPointByResourceList$member' => NULL, ], ], 'RecoveryPointByResourceList' => [ 'base' => NULL, 'refs' => [ 'ListRecoveryPointsByResourceOutput$RecoveryPoints' => '<p>An array of objects that contain detailed information about recovery points of the specified resource type.</p> <note> <p>Only Amazon EFS and Amazon EC2 recovery points return BackupVaultName.</p> </note>', ], ], 'RecoveryPointCreator' => [ 'base' => '<p>Contains information about the backup plan and rule that Backup used to initiate the recovery point backup.</p>', 'refs' => [ 'BackupJob$CreatedBy' => '<p>Contains identifying information about the creation of a backup job, including the <code>BackupPlanArn</code>, <code>BackupPlanId</code>, <code>BackupPlanVersion</code>, and <code>BackupRuleId</code> of the backup plan used to create it.</p>', 'CopyJob$CreatedBy' => NULL, 'DescribeBackupJobOutput$CreatedBy' => '<p>Contains identifying information about the creation of a backup job, including the <code>BackupPlanArn</code>, <code>BackupPlanId</code>, <code>BackupPlanVersion</code>, and <code>BackupRuleId</code> of the backup plan that is used to create it.</p>', 'DescribeRecoveryPointOutput$CreatedBy' => '<p>Contains identifying information about the creation of a recovery point, including the <code>BackupPlanArn</code>, <code>BackupPlanId</code>, <code>BackupPlanVersion</code>, and <code>BackupRuleId</code> of the backup plan used to create it.</p>', 'RecoveryPointByBackupVault$CreatedBy' => '<p>Contains identifying information about the creation of a recovery point, including the <code>BackupPlanArn</code>, <code>BackupPlanId</code>, <code>BackupPlanVersion</code>, and <code>BackupRuleId</code> of the backup plan that is used to create it.</p>', ], ], 'RecoveryPointStatus' => [ 'base' => NULL, 'refs' => [ 'DescribeRecoveryPointOutput$Status' => '<p>A status code specifying the state of the recovery point.</p> <p> <code>PARTIAL</code> status indicates Backup could not create the recovery point before the backup window closed. To increase your backup plan window using the API, see <a href="https://docs.aws.amazon.com/aws-backup/latest/devguide/API_UpdateBackupPlan.html">UpdateBackupPlan</a>. You can also increase your backup plan window using the Console by choosing and editing your backup plan.</p> <p> <code>EXPIRED</code> status indicates that the recovery point has exceeded its retention period, but Backup lacks permission or is otherwise unable to delete it. To manually delete these recovery points, see <a href="https://docs.aws.amazon.com/aws-backup/latest/devguide/gs-cleanup-resources.html#cleanup-backups"> Step 3: Delete the recovery points</a> in the <i>Clean up resources</i> section of <i>Getting started</i>.</p>', 'RecoveryPointByBackupVault$Status' => '<p>A status code specifying the state of the recovery point.</p>', 'RecoveryPointByResource$Status' => '<p>A status code specifying the state of the recovery point.</p>', ], ], 'ReportDeliveryChannel' => [ 'base' => '<p>Contains information from your report plan about where to deliver your reports, specifically your Amazon S3 bucket name, S3 key prefix, and the formats of your reports.</p>', 'refs' => [ 'CreateReportPlanInput$ReportDeliveryChannel' => '<p>A structure that contains information about where and how to deliver your reports, specifically your Amazon S3 bucket name, S3 key prefix, and the formats of your reports.</p>', 'ReportPlan$ReportDeliveryChannel' => '<p>Contains information about where and how to deliver your reports, specifically your Amazon S3 bucket name, S3 key prefix, and the formats of your reports.</p>', 'UpdateReportPlanInput$ReportDeliveryChannel' => '<p>A structure that contains information about where to deliver your reports, specifically your Amazon S3 bucket name, S3 key prefix, and the formats of your reports.</p>', ], ], 'ReportDestination' => [ 'base' => '<p>Contains information from your report job about your report destination.</p>', 'refs' => [ 'ReportJob$ReportDestination' => '<p>The S3 bucket name and S3 keys for the destination where the report job publishes the report.</p>', ], ], 'ReportJob' => [ 'base' => '<p>Contains detailed information about a report job. A report job compiles a report based on a report plan and publishes it to Amazon S3.</p>', 'refs' => [ 'DescribeReportJobOutput$ReportJob' => '<p>A list of information about a report job, including its completion and creation times, report destination, unique report job ID, Amazon Resource Name (ARN), report template, status, and status message.</p>', 'ReportJobList$member' => NULL, ], ], 'ReportJobId' => [ 'base' => NULL, 'refs' => [ 'DescribeReportJobInput$ReportJobId' => '<p>The identifier of the report job. A unique, randomly generated, Unicode, UTF-8 encoded string that is at most 1,024 bytes long. The report job ID cannot be edited.</p>', 'ReportJob$ReportJobId' => '<p>The identifier for a report job. A unique, randomly generated, Unicode, UTF-8 encoded string that is at most 1,024 bytes long. Report job IDs cannot be edited.</p>', 'StartReportJobOutput$ReportJobId' => '<p>The identifier of the report job. A unique, randomly generated, Unicode, UTF-8 encoded string that is at most 1,024 bytes long. The report job ID cannot be edited.</p>', ], ], 'ReportJobList' => [ 'base' => NULL, 'refs' => [ 'ListReportJobsOutput$ReportJobs' => '<p>Details about your report jobs in JSON format.</p>', ], ], 'ReportPlan' => [ 'base' => '<p>Contains detailed information about a report plan.</p>', 'refs' => [ 'DescribeReportPlanOutput$ReportPlan' => '<p>Returns details about the report plan that is specified by its name. These details include the report plan\'s Amazon Resource Name (ARN), description, settings, delivery channel, deployment status, creation time, and last attempted and successful run times.</p>', 'ReportPlanList$member' => NULL, ], ], 'ReportPlanDescription' => [ 'base' => NULL, 'refs' => [ 'CreateReportPlanInput$ReportPlanDescription' => '<p>An optional description of the report plan with a maximum of 1,024 characters.</p>', 'ReportPlan$ReportPlanDescription' => '<p>An optional description of the report plan with a maximum 1,024 characters.</p>', 'UpdateReportPlanInput$ReportPlanDescription' => '<p>An optional description of the report plan with a maximum 1,024 characters.</p>', ], ], 'ReportPlanList' => [ 'base' => NULL, 'refs' => [ 'ListReportPlansOutput$ReportPlans' => '<p>A list of your report plans with detailed information for each plan. This information includes the Amazon Resource Name (ARN), report plan name, description, settings, delivery channel, deployment status, creation time, and last times the report plan attempted to and successfully ran.</p>', ], ], 'ReportPlanName' => [ 'base' => NULL, 'refs' => [ 'CreateReportPlanInput$ReportPlanName' => '<p>The unique name of the report plan. The name must be between 1 and 256 characters, starting with a letter, and consisting of letters (a-z, A-Z), numbers (0-9), and underscores (_).</p>', 'CreateReportPlanOutput$ReportPlanName' => '<p>The unique name of the report plan.</p>', 'DeleteReportPlanInput$ReportPlanName' => '<p>The unique name of a report plan.</p>', 'DescribeReportPlanInput$ReportPlanName' => '<p>The unique name of a report plan.</p>', 'ListReportJobsInput$ByReportPlanName' => '<p>Returns only report jobs with the specified report plan name.</p>', 'ReportPlan$ReportPlanName' => '<p>The unique name of the report plan. This name is between 1 and 256 characters starting with a letter, and consisting of letters (a-z, A-Z), numbers (0-9), and underscores (_).</p>', 'StartReportJobInput$ReportPlanName' => '<p>The unique name of a report plan.</p>', 'UpdateReportPlanInput$ReportPlanName' => '<p>The unique name of the report plan. This name is between 1 and 256 characters, starting with a letter, and consisting of letters (a-z, A-Z), numbers (0-9), and underscores (_).</p>', 'UpdateReportPlanOutput$ReportPlanName' => '<p>The unique name of the report plan.</p>', ], ], 'ReportSetting' => [ 'base' => '<p>Contains detailed information about a report setting.</p>', 'refs' => [ 'CreateReportPlanInput$ReportSetting' => '<p>Identifies the report template for the report. Reports are built using a report template. The report templates are:</p> <p> <code>RESOURCE_COMPLIANCE_REPORT | CONTROL_COMPLIANCE_REPORT | BACKUP_JOB_REPORT | COPY_JOB_REPORT | RESTORE_JOB_REPORT</code> </p> <p>If the report template is <code>RESOURCE_COMPLIANCE_REPORT</code> or <code>CONTROL_COMPLIANCE_REPORT</code>, this API resource also describes the report coverage by Amazon Web Services Regions and frameworks.</p>', 'ReportPlan$ReportSetting' => '<p>Identifies the report template for the report. Reports are built using a report template. The report templates are:</p> <p> <code>RESOURCE_COMPLIANCE_REPORT | CONTROL_COMPLIANCE_REPORT | BACKUP_JOB_REPORT | COPY_JOB_REPORT | RESTORE_JOB_REPORT</code> </p> <p>If the report template is <code>RESOURCE_COMPLIANCE_REPORT</code> or <code>CONTROL_COMPLIANCE_REPORT</code>, this API resource also describes the report coverage by Amazon Web Services Regions and frameworks.</p>', 'UpdateReportPlanInput$ReportSetting' => '<p>Identifies the report template for the report. Reports are built using a report template. The report templates are:</p> <p> <code>RESOURCE_COMPLIANCE_REPORT | CONTROL_COMPLIANCE_REPORT | BACKUP_JOB_REPORT | COPY_JOB_REPORT | RESTORE_JOB_REPORT</code> </p> <p>If the report template is <code>RESOURCE_COMPLIANCE_REPORT</code> or <code>CONTROL_COMPLIANCE_REPORT</code>, this API resource also describes the report coverage by Amazon Web Services Regions and frameworks.</p>', ], ], 'ResourceArns' => [ 'base' => NULL, 'refs' => [ 'BackupSelection$Resources' => '<p>An array of strings that contain Amazon Resource Names (ARNs) of resources to assign to a backup plan.</p>', 'BackupSelection$NotResources' => NULL, ], ], 'ResourceNotFoundException' => [ 'base' => '<p>A resource that is required for the action doesn\'t exist.</p>', 'refs' => [], ], 'ResourceType' => [ 'base' => NULL, 'refs' => [ 'AdvancedBackupSetting$ResourceType' => '<p>Specifies an object containing resource type and backup options. The only supported resource type is Amazon EC2 instances with Windows Volume Shadow Copy Service (VSS). For a CloudFormation example, see the <a href="https://docs.aws.amazon.com/aws-backup/latest/devguide/integrate-cloudformation-with-aws-backup.html">sample CloudFormation template to enable Windows VSS</a> in the <i>Backup User Guide</i>.</p> <p>Valid values: <code>EC2</code>.</p>', 'BackupJob$ResourceType' => '<p>The type of Amazon Web Services resource to be backed up; for example, an Amazon Elastic Block Store (Amazon EBS) volume or an Amazon Relational Database Service (Amazon RDS) database. For Windows Volume Shadow Copy Service (VSS) backups, the only supported resource type is Amazon EC2.</p>', 'CopyJob$ResourceType' => '<p>The type of Amazon Web Services resource to be copied; for example, an Amazon Elastic Block Store (Amazon EBS) volume or an Amazon Relational Database Service (Amazon RDS) database.</p>', 'DescribeBackupJobOutput$ResourceType' => '<p>The type of Amazon Web Services resource to be backed up; for example, an Amazon Elastic Block Store (Amazon EBS) volume or an Amazon Relational Database Service (Amazon RDS) database.</p>', 'DescribeProtectedResourceOutput$ResourceType' => '<p>The type of Amazon Web Services resource saved as a recovery point; for example, an Amazon EBS volume or an Amazon RDS database.</p>', 'DescribeRecoveryPointOutput$ResourceType' => '<p>The type of Amazon Web Services resource to save as a recovery point; for example, an Amazon Elastic Block Store (Amazon EBS) volume or an Amazon Relational Database Service (Amazon RDS) database.</p>', 'DescribeRestoreJobOutput$ResourceType' => '<p>Returns metadata associated with a restore job listed by resource type.</p>', 'ListBackupJobsInput$ByResourceType' => '<p>Returns only backup jobs for the specified resources:</p> <ul> <li> <p> <code>DynamoDB</code> for Amazon DynamoDB</p> </li> <li> <p> <code>EBS</code> for Amazon Elastic Block Store</p> </li> <li> <p> <code>EC2</code> for Amazon Elastic Compute Cloud</p> </li> <li> <p> <code>EFS</code> for Amazon Elastic File System</p> </li> <li> <p> <code>RDS</code> for Amazon Relational Database Service</p> </li> <li> <p> <code>Aurora</code> for Amazon Aurora</p> </li> <li> <p> <code>Storage Gateway</code> for Storage Gateway</p> </li> </ul>', 'ListCopyJobsInput$ByResourceType' => '<p>Returns only backup jobs for the specified resources:</p> <ul> <li> <p> <code>DynamoDB</code> for Amazon DynamoDB</p> </li> <li> <p> <code>EBS</code> for Amazon Elastic Block Store</p> </li> <li> <p> <code>EC2</code> for Amazon Elastic Compute Cloud</p> </li> <li> <p> <code>EFS</code> for Amazon Elastic File System</p> </li> <li> <p> <code>RDS</code> for Amazon Relational Database Service</p> </li> <li> <p> <code>Aurora</code> for Amazon Aurora</p> </li> <li> <p> <code>Storage Gateway</code> for Storage Gateway</p> </li> </ul>', 'ListRecoveryPointsByBackupVaultInput$ByResourceType' => '<p>Returns only recovery points that match the specified resource type.</p>', 'ProtectedResource$ResourceType' => '<p>The type of Amazon Web Services resource; for example, an Amazon Elastic Block Store (Amazon EBS) volume or an Amazon Relational Database Service (Amazon RDS) database. For Windows Volume Shadow Copy Service (VSS) backups, the only supported resource type is Amazon EC2.</p>', 'RecoveryPointByBackupVault$ResourceType' => '<p>The type of Amazon Web Services resource saved as a recovery point; for example, an Amazon Elastic Block Store (Amazon EBS) volume or an Amazon Relational Database Service (Amazon RDS) database. For Windows Volume Shadow Copy Service (VSS) backups, the only supported resource type is Amazon EC2.</p>', 'ResourceTypeOptInPreference$key' => NULL, 'ResourceTypes$member' => NULL, 'RestoreJobsListMember$ResourceType' => '<p>The resource type of the listed restore jobs; for example, an Amazon Elastic Block Store (Amazon EBS) volume or an Amazon Relational Database Service (Amazon RDS) database. For Windows Volume Shadow Copy Service (VSS) backups, the only supported resource type is Amazon EC2.</p>', 'StartRestoreJobInput$ResourceType' => '<p>Starts a job to restore a recovery point for one of the following resources:</p> <ul> <li> <p> <code>DynamoDB</code> for Amazon DynamoDB</p> </li> <li> <p> <code>EBS</code> for Amazon Elastic Block Store</p> </li> <li> <p> <code>EC2</code> for Amazon Elastic Compute Cloud</p> </li> <li> <p> <code>EFS</code> for Amazon Elastic File System</p> </li> <li> <p> <code>RDS</code> for Amazon Relational Database Service</p> </li> <li> <p> <code>Aurora</code> for Amazon Aurora</p> </li> <li> <p> <code>Storage Gateway</code> for Storage Gateway</p> </li> </ul>', ], ], 'ResourceTypeList' => [ 'base' => NULL, 'refs' => [ 'ControlScope$ComplianceResourceTypes' => '<p>Describes whether the control scope includes one or more types of resources, such as <code>EFS</code> or <code>RDS</code>.</p>', ], ], 'ResourceTypeOptInPreference' => [ 'base' => NULL, 'refs' => [ 'DescribeRegionSettingsOutput$ResourceTypeOptInPreference' => '<p>Returns a list of all services along with the opt-in preferences in the Region.</p>', 'UpdateRegionSettingsInput$ResourceTypeOptInPreference' => '<p>Updates the list of services along with the opt-in preferences for the Region.</p>', ], ], 'ResourceTypes' => [ 'base' => NULL, 'refs' => [ 'GetSupportedResourceTypesOutput$ResourceTypes' => '<p>Contains a string with the supported Amazon Web Services resource types:</p> <ul> <li> <p> <code>Aurora</code> for Amazon Aurora</p> </li> <li> <p> <code>DynamoDB</code> for Amazon DynamoDB</p> </li> <li> <p> <code>EBS</code> for Amazon Elastic Block Store</p> </li> <li> <p> <code>EC2</code> for Amazon Elastic Compute Cloud</p> </li> <li> <p> <code>EFS</code> for Amazon Elastic File System</p> </li> <li> <p> <code>FSX</code> for Amazon FSx</p> </li> <li> <p> <code>RDS</code> for Amazon Relational Database Service</p> </li> <li> <p> <code>Storage Gateway</code> for Storage Gateway</p> </li> </ul>', ], ], 'RestoreJobId' => [ 'base' => NULL, 'refs' => [ 'DescribeRestoreJobInput$RestoreJobId' => '<p>Uniquely identifies the job that restores a recovery point.</p>', 'StartRestoreJobOutput$RestoreJobId' => '<p>Uniquely identifies the job that restores a recovery point.</p>', ], ], 'RestoreJobStatus' => [ 'base' => NULL, 'refs' => [ 'DescribeRestoreJobOutput$Status' => '<p>Status code specifying the state of the job that is initiated by Backup to restore a recovery point.</p>', 'ListRestoreJobsInput$ByStatus' => '<p>Returns only restore jobs associated with the specified job status.</p>', 'RestoreJobsListMember$Status' => '<p>A status code specifying the state of the job initiated by Backup to restore a recovery point.</p>', ], ], 'RestoreJobsList' => [ 'base' => NULL, 'refs' => [ 'ListRestoreJobsOutput$RestoreJobs' => '<p>An array of objects that contain detailed information about jobs to restore saved resources.</p>', ], ], 'RestoreJobsListMember' => [ 'base' => '<p>Contains metadata about a restore job.</p>', 'refs' => [ 'RestoreJobsList$member' => NULL, ], ], 'ServiceUnavailableException' => [ 'base' => '<p>The request failed due to a temporary failure of the server.</p>', 'refs' => [], ], 'StartBackupJobInput' => [ 'base' => NULL, 'refs' => [], ], 'StartBackupJobOutput' => [ 'base' => NULL, 'refs' => [], ], 'StartCopyJobInput' => [ 'base' => NULL, 'refs' => [], ], 'StartCopyJobOutput' => [ 'base' => NULL, 'refs' => [], ], 'StartReportJobInput' => [ 'base' => NULL, 'refs' => [], ], 'StartReportJobOutput' => [ 'base' => NULL, 'refs' => [], ], 'StartRestoreJobInput' => [ 'base' => NULL, 'refs' => [], ], 'StartRestoreJobOutput' => [ 'base' => NULL, 'refs' => [], ], 'StopBackupJobInput' => [ 'base' => NULL, 'refs' => [], ], 'StorageClass' => [ 'base' => NULL, 'refs' => [ 'DescribeRecoveryPointOutput$StorageClass' => '<p>Specifies the storage class of the recovery point. Valid values are <code>WARM</code> or <code>COLD</code>.</p>', ], ], 'TagKey' => [ 'base' => NULL, 'refs' => [ 'Tags$key' => NULL, ], ], 'TagKeyList' => [ 'base' => NULL, 'refs' => [ 'UntagResourceInput$TagKeyList' => '<p>A list of keys to identify which key-value tags to remove from a resource.</p>', ], ], 'TagResourceInput' => [ 'base' => NULL, 'refs' => [], ], 'TagValue' => [ 'base' => NULL, 'refs' => [ 'Tags$value' => NULL, ], ], 'Tags' => [ 'base' => NULL, 'refs' => [ 'BackupRule$RecoveryPointTags' => '<p>An array of key-value pair strings that are assigned to resources that are associated with this rule when restored from backup.</p>', 'BackupRuleInput$RecoveryPointTags' => '<p>To help organize your resources, you can assign your own metadata to the resources that you create. Each tag is a key-value pair.</p>', 'CreateBackupPlanInput$BackupPlanTags' => '<p>To help organize your resources, you can assign your own metadata to the resources that you create. Each tag is a key-value pair. The specified tags are assigned to all backups created with this plan.</p>', 'CreateBackupVaultInput$BackupVaultTags' => '<p>Metadata that you can assign to help organize the resources that you create. Each tag is a key-value pair.</p>', 'ListTagsOutput$Tags' => '<p>To help organize your resources, you can assign your own metadata to the resources you create. Each tag is a key-value pair.</p>', 'StartBackupJobInput$RecoveryPointTags' => '<p>To help organize your resources, you can assign your own metadata to the resources that you create. Each tag is a key-value pair.</p>', 'TagResourceInput$Tags' => '<p>Key-value pairs that are used to help organize your resources. You can assign your own metadata to the resources you create.</p>', ], ], 'UntagResourceInput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateBackupPlanInput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateBackupPlanOutput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateFrameworkInput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateFrameworkOutput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateGlobalSettingsInput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateRecoveryPointLifecycleInput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateRecoveryPointLifecycleOutput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateRegionSettingsInput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateReportPlanInput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateReportPlanOutput' => [ 'base' => NULL, 'refs' => [], ], 'WindowMinutes' => [ 'base' => NULL, 'refs' => [ 'BackupRule$StartWindowMinutes' => '<p>A value in minutes after a backup is scheduled before a job will be canceled if it doesn\'t start successfully. This value is optional.</p>', 'BackupRule$CompletionWindowMinutes' => '<p>A value in minutes after a backup job is successfully started before it must be completed or it will be canceled by Backup. This value is optional.</p>', 'BackupRuleInput$StartWindowMinutes' => '<p>A value in minutes after a backup is scheduled before a job will be canceled if it doesn\'t start successfully. This value is optional.</p>', 'BackupRuleInput$CompletionWindowMinutes' => '<p>A value in minutes after a backup job is successfully started before it must be completed or it will be canceled by Backup. This value is optional.</p>', 'StartBackupJobInput$StartWindowMinutes' => '<p>A value in minutes after a backup is scheduled before a job will be canceled if it doesn\'t start successfully. This value is optional, and the default is 8 hours.</p>', 'StartBackupJobInput$CompleteWindowMinutes' => '<p>A value in minutes during which a successfully started backup must complete, or else AWS Backup will cancel the job. This value is optional. This value begins counting down from when the backup was scheduled. It does not add additional time for <code>StartWindowMinutes</code>, or if the backup started later than scheduled.</p>', ], ], 'boolean' => [ 'base' => NULL, 'refs' => [ 'DescribeRecoveryPointOutput$IsEncrypted' => '<p>A Boolean value that is returned as <code>TRUE</code> if the specified recovery point is encrypted, or <code>FALSE</code> if the recovery point is not encrypted.</p>', 'RecoveryPointByBackupVault$IsEncrypted' => '<p>A Boolean value that is returned as <code>TRUE</code> if the specified recovery point is encrypted, or <code>FALSE</code> if the recovery point is not encrypted.</p>', ], ], 'integer' => [ 'base' => NULL, 'refs' => [ 'Framework$NumberOfControls' => '<p>The number of controls contained by the framework.</p>', 'ReportSetting$NumberOfFrameworks' => '<p>The number of frameworks a report covers.</p>', ], ], 'long' => [ 'base' => NULL, 'refs' => [ 'BackupVaultListMember$NumberOfRecoveryPoints' => '<p>The number of recovery points that are stored in a backup vault.</p>', 'DescribeBackupVaultOutput$NumberOfRecoveryPoints' => '<p>The number of recovery points that are stored in a backup vault.</p>', ], ], 'string' => [ 'base' => NULL, 'refs' => [ 'AlreadyExistsException$Code' => NULL, 'AlreadyExistsException$Message' => NULL, 'AlreadyExistsException$CreatorRequestId' => '<p/>', 'AlreadyExistsException$Arn' => '<p/>', 'AlreadyExistsException$Type' => '<p/>', 'AlreadyExistsException$Context' => '<p/>', 'BackupJob$BackupJobId' => '<p>Uniquely identifies a request to Backup to back up a resource.</p>', 'BackupJob$StatusMessage' => '<p>A detailed message explaining the status of the job to back up a resource.</p>', 'BackupJob$PercentDone' => '<p>Contains an estimated percentage complete of a job at the time the job status was queried.</p>', 'BackupJob$BackupType' => '<p>Represents the type of backup for a backup job.</p>', 'BackupPlanTemplatesListMember$BackupPlanTemplateId' => '<p>Uniquely identifies a stored backup plan template.</p>', 'BackupPlanTemplatesListMember$BackupPlanTemplateName' => '<p>The optional display name of a backup plan template.</p>', 'BackupPlansListMember$BackupPlanId' => '<p>Uniquely identifies a backup plan.</p>', 'BackupPlansListMember$VersionId' => '<p>Unique, randomly generated, Unicode, UTF-8 encoded strings that are at most 1,024 bytes long. Version IDs cannot be edited.</p>', 'BackupPlansListMember$CreatorRequestId' => '<p>A unique string that identifies the request and allows failed requests to be retried without the risk of running the operation twice.</p>', 'BackupRule$RuleId' => '<p>Uniquely identifies a rule that is used to schedule the backup of a selection of resources.</p>', 'BackupSelectionsListMember$SelectionId' => '<p>Uniquely identifies a request to assign a set of resources to a backup plan.</p>', 'BackupSelectionsListMember$BackupPlanId' => '<p>Uniquely identifies a backup plan.</p>', 'BackupSelectionsListMember$CreatorRequestId' => '<p>A unique string that identifies the request and allows failed requests to be retried without the risk of running the operation twice.</p>', 'BackupVaultListMember$CreatorRequestId' => '<p>A unique string that identifies the request and allows failed requests to be retried without the risk of running the operation twice.</p>', 'ComplianceResourceIdList$member' => NULL, 'ConflictException$Code' => NULL, 'ConflictException$Message' => NULL, 'ConflictException$Type' => '<p/>', 'ConflictException$Context' => '<p/>', 'CopyJob$CopyJobId' => '<p>Uniquely identifies a copy job.</p>', 'CopyJob$StatusMessage' => '<p>A detailed message explaining the status of the job to copy a resource.</p>', 'CreateBackupPlanInput$CreatorRequestId' => '<p>Identifies the request and allows failed requests to be retried without the risk of running the operation twice. If the request includes a <code>CreatorRequestId</code> that matches an existing backup plan, that plan is returned. This parameter is optional.</p>', 'CreateBackupPlanOutput$BackupPlanId' => '<p>Uniquely identifies a backup plan.</p>', 'CreateBackupPlanOutput$VersionId' => '<p>Unique, randomly generated, Unicode, UTF-8 encoded strings that are at most 1,024 bytes long. They cannot be edited.</p>', 'CreateBackupSelectionInput$BackupPlanId' => '<p>Uniquely identifies the backup plan to be associated with the selection of resources.</p>', 'CreateBackupSelectionInput$CreatorRequestId' => '<p>A unique string that identifies the request and allows failed requests to be retried without the risk of running the operation twice.</p>', 'CreateBackupSelectionOutput$SelectionId' => '<p>Uniquely identifies the body of a request to assign a set of resources to a backup plan.</p>', 'CreateBackupSelectionOutput$BackupPlanId' => '<p>Uniquely identifies a backup plan.</p>', 'CreateBackupVaultInput$CreatorRequestId' => '<p>A unique string that identifies the request and allows failed requests to be retried without the risk of running the operation twice.</p>', 'CreateFrameworkInput$IdempotencyToken' => '<p>A customer-chosen string that you can use to distinguish between otherwise identical calls to <code>CreateFrameworkInput</code>. Retrying a successful request with the same idempotency token results in a success message with no action taken.</p>', 'CreateReportPlanInput$IdempotencyToken' => '<p>A customer-chosen string that you can use to distinguish between otherwise identical calls to <code>CreateReportPlanInput</code>. Retrying a successful request with the same idempotency token results in a success message with no action taken.</p>', 'DeleteBackupPlanInput$BackupPlanId' => '<p>Uniquely identifies a backup plan.</p>', 'DeleteBackupPlanOutput$BackupPlanId' => '<p>Uniquely identifies a backup plan.</p>', 'DeleteBackupPlanOutput$VersionId' => '<p>Unique, randomly generated, Unicode, UTF-8 encoded strings that are at most 1,024 bytes long. Version IDs cannot be edited.</p>', 'DeleteBackupSelectionInput$BackupPlanId' => '<p>Uniquely identifies a backup plan.</p>', 'DeleteBackupSelectionInput$SelectionId' => '<p>Uniquely identifies the body of a request to assign a set of resources to a backup plan.</p>', 'DeleteBackupVaultInput$BackupVaultName' => '<p>The name of a logical container where backups are stored. Backup vaults are identified by names that are unique to the account used to create them and the Amazon Web Services Region where they are created. They consist of lowercase letters, numbers, and hyphens.</p>', 'DependencyFailureException$Code' => NULL, 'DependencyFailureException$Message' => NULL, 'DependencyFailureException$Type' => '<p/>', 'DependencyFailureException$Context' => '<p/>', 'DescribeBackupJobInput$BackupJobId' => '<p>Uniquely identifies a request to Backup to back up a resource.</p>', 'DescribeBackupJobOutput$BackupJobId' => '<p>Uniquely identifies a request to Backup to back up a resource.</p>', 'DescribeBackupJobOutput$StatusMessage' => '<p>A detailed message explaining the status of the job to back up a resource.</p>', 'DescribeBackupJobOutput$PercentDone' => '<p>Contains an estimated percentage that is complete of a job at the time the job status was queried.</p>', 'DescribeBackupJobOutput$BackupType' => '<p>Represents the actual backup type selected for a backup job. For example, if a successful Windows Volume Shadow Copy Service (VSS) backup was taken, <code>BackupType</code> returns <code>"WindowsVSS"</code>. If <code>BackupType</code> is empty, then the backup type was a regular backup.</p>', 'DescribeBackupVaultInput$BackupVaultName' => '<p>The name of a logical container where backups are stored. Backup vaults are identified by names that are unique to the account used to create them and the Amazon Web Services Region where they are created. They consist of lowercase letters, numbers, and hyphens.</p>', 'DescribeBackupVaultOutput$BackupVaultName' => '<p>The name of a logical container where backups are stored. Backup vaults are identified by names that are unique to the account used to create them and the Region where they are created. They consist of lowercase letters, numbers, and hyphens.</p>', 'DescribeBackupVaultOutput$CreatorRequestId' => '<p>A unique string that identifies the request and allows failed requests to be retried without the risk of running the operation twice.</p>', 'DescribeCopyJobInput$CopyJobId' => '<p>Uniquely identifies a copy job.</p>', 'DescribeFrameworkOutput$DeploymentStatus' => '<p>The deployment status of a framework. The statuses are:</p> <p> <code>CREATE_IN_PROGRESS | UPDATE_IN_PROGRESS | DELETE_IN_PROGRESS | COMPLETED | FAILED</code> </p>', 'DescribeFrameworkOutput$FrameworkStatus' => '<p>A framework consists of one or more controls. Each control governs a resource, such as backup plans, backup selections, backup vaults, or recovery points. You can also turn Config recording on or off for each resource. The statuses are:</p> <ul> <li> <p> <code>ACTIVE</code> when recording is turned on for all resources governed by the framework.</p> </li> <li> <p> <code>PARTIALLY_ACTIVE</code> when recording is turned off for at least one resource governed by the framework.</p> </li> <li> <p> <code>INACTIVE</code> when recording is turned off for all resources governed by the framework.</p> </li> <li> <p> <code>UNAVAILABLE</code> when Backup is unable to validate recording status at this time.</p> </li> </ul>', 'DescribeFrameworkOutput$IdempotencyToken' => '<p>A customer-chosen string that you can use to distinguish between otherwise identical calls to <code>DescribeFrameworkOutput</code>. Retrying a successful request with the same idempotency token results in a success message with no action taken.</p>', 'DescribeRecoveryPointOutput$StatusMessage' => '<p>A status message explaining the reason for the recovery point deletion failure.</p>', 'DescribeRestoreJobOutput$RestoreJobId' => '<p>Uniquely identifies the job that restores a recovery point.</p>', 'DescribeRestoreJobOutput$StatusMessage' => '<p>A message showing the status of a job to restore a recovery point.</p>', 'DescribeRestoreJobOutput$PercentDone' => '<p>Contains an estimated percentage that is complete of a job at the time the job status was queried.</p>', 'ExportBackupPlanTemplateInput$BackupPlanId' => '<p>Uniquely identifies a backup plan.</p>', 'ExportBackupPlanTemplateOutput$BackupPlanTemplateJson' => '<p>The body of a backup plan template in JSON format.</p> <note> <p>This is a signed JSON document that cannot be modified before being passed to <code>GetBackupPlanFromJSON.</code> </p> </note>', 'FormatList$member' => NULL, 'Framework$DeploymentStatus' => '<p>The deployment status of a framework. The statuses are:</p> <p> <code>CREATE_IN_PROGRESS | UPDATE_IN_PROGRESS | DELETE_IN_PROGRESS | COMPLETED | FAILED</code> </p>', 'GetBackupPlanFromJSONInput$BackupPlanTemplateJson' => '<p>A customer-supplied backup plan document in JSON format.</p>', 'GetBackupPlanFromTemplateInput$BackupPlanTemplateId' => '<p>Uniquely identifies a stored backup plan template.</p>', 'GetBackupPlanInput$BackupPlanId' => '<p>Uniquely identifies a backup plan.</p>', 'GetBackupPlanInput$VersionId' => '<p>Unique, randomly generated, Unicode, UTF-8 encoded strings that are at most 1,024 bytes long. Version IDs cannot be edited.</p>', 'GetBackupPlanOutput$BackupPlanId' => '<p>Uniquely identifies a backup plan.</p>', 'GetBackupPlanOutput$VersionId' => '<p>Unique, randomly generated, Unicode, UTF-8 encoded strings that are at most 1,024 bytes long. Version IDs cannot be edited.</p>', 'GetBackupPlanOutput$CreatorRequestId' => '<p>A unique string that identifies the request and allows failed requests to be retried without the risk of running the operation twice.</p>', 'GetBackupSelectionInput$BackupPlanId' => '<p>Uniquely identifies a backup plan.</p>', 'GetBackupSelectionInput$SelectionId' => '<p>Uniquely identifies the body of a request to assign a set of resources to a backup plan.</p>', 'GetBackupSelectionOutput$SelectionId' => '<p>Uniquely identifies the body of a request to assign a set of resources to a backup plan.</p>', 'GetBackupSelectionOutput$BackupPlanId' => '<p>Uniquely identifies a backup plan.</p>', 'GetBackupSelectionOutput$CreatorRequestId' => '<p>A unique string that identifies the request and allows failed requests to be retried without the risk of running the operation twice.</p>', 'InvalidParameterValueException$Code' => NULL, 'InvalidParameterValueException$Message' => NULL, 'InvalidParameterValueException$Type' => '<p/>', 'InvalidParameterValueException$Context' => '<p/>', 'InvalidRequestException$Code' => NULL, 'InvalidRequestException$Message' => NULL, 'InvalidRequestException$Type' => '<p/>', 'InvalidRequestException$Context' => '<p/>', 'InvalidResourceStateException$Code' => NULL, 'InvalidResourceStateException$Message' => NULL, 'InvalidResourceStateException$Type' => '<p/>', 'InvalidResourceStateException$Context' => '<p/>', 'LimitExceededException$Code' => NULL, 'LimitExceededException$Message' => NULL, 'LimitExceededException$Type' => '<p/>', 'LimitExceededException$Context' => '<p/>', 'ListBackupJobsInput$NextToken' => '<p>The next item following a partial list of returned items. For example, if a request is made to return <code>maxResults</code> number of items, <code>NextToken</code> allows you to return more items in your list starting at the location pointed to by the next token.</p>', 'ListBackupJobsOutput$NextToken' => '<p>The next item following a partial list of returned items. For example, if a request is made to return <code>maxResults</code> number of items, <code>NextToken</code> allows you to return more items in your list starting at the location pointed to by the next token.</p>', 'ListBackupPlanTemplatesInput$NextToken' => '<p>The next item following a partial list of returned items. For example, if a request is made to return <code>maxResults</code> number of items, <code>NextToken</code> allows you to return more items in your list starting at the location pointed to by the next token.</p>', 'ListBackupPlanTemplatesOutput$NextToken' => '<p>The next item following a partial list of returned items. For example, if a request is made to return <code>maxResults</code> number of items, <code>NextToken</code> allows you to return more items in your list starting at the location pointed to by the next token.</p>', 'ListBackupPlanVersionsInput$BackupPlanId' => '<p>Uniquely identifies a backup plan.</p>', 'ListBackupPlanVersionsInput$NextToken' => '<p>The next item following a partial list of returned items. For example, if a request is made to return <code>maxResults</code> number of items, <code>NextToken</code> allows you to return more items in your list starting at the location pointed to by the next token.</p>', 'ListBackupPlanVersionsOutput$NextToken' => '<p>The next item following a partial list of returned items. For example, if a request is made to return <code>maxResults</code> number of items, <code>NextToken</code> allows you to return more items in your list starting at the location pointed to by the next token.</p>', 'ListBackupPlansInput$NextToken' => '<p>The next item following a partial list of returned items. For example, if a request is made to return <code>maxResults</code> number of items, <code>NextToken</code> allows you to return more items in your list starting at the location pointed to by the next token.</p>', 'ListBackupPlansOutput$NextToken' => '<p>The next item following a partial list of returned items. For example, if a request is made to return <code>maxResults</code> number of items, <code>NextToken</code> allows you to return more items in your list starting at the location pointed to by the next token.</p>', 'ListBackupSelectionsInput$BackupPlanId' => '<p>Uniquely identifies a backup plan.</p>', 'ListBackupSelectionsInput$NextToken' => '<p>The next item following a partial list of returned items. For example, if a request is made to return <code>maxResults</code> number of items, <code>NextToken</code> allows you to return more items in your list starting at the location pointed to by the next token.</p>', 'ListBackupSelectionsOutput$NextToken' => '<p>The next item following a partial list of returned items. For example, if a request is made to return <code>maxResults</code> number of items, <code>NextToken</code> allows you to return more items in your list starting at the location pointed to by the next token.</p>', 'ListBackupVaultsInput$NextToken' => '<p>The next item following a partial list of returned items. For example, if a request is made to return <code>maxResults</code> number of items, <code>NextToken</code> allows you to return more items in your list starting at the location pointed to by the next token.</p>', 'ListBackupVaultsOutput$NextToken' => '<p>The next item following a partial list of returned items. For example, if a request is made to return <code>maxResults</code> number of items, <code>NextToken</code> allows you to return more items in your list starting at the location pointed to by the next token.</p>', 'ListCopyJobsInput$NextToken' => '<p>The next item following a partial list of returned items. For example, if a request is made to return maxResults number of items, NextToken allows you to return more items in your list starting at the location pointed to by the next token. </p>', 'ListCopyJobsInput$ByDestinationVaultArn' => '<p>An Amazon Resource Name (ARN) that uniquely identifies a source backup vault to copy from; for example, <code>arn:aws:backup:us-east-1:123456789012:vault:aBackupVault</code>. </p>', 'ListCopyJobsOutput$NextToken' => '<p>The next item following a partial list of returned items. For example, if a request is made to return maxResults number of items, NextToken allows you to return more items in your list starting at the location pointed to by the next token. </p>', 'ListFrameworksInput$NextToken' => '<p>An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list.</p>', 'ListFrameworksOutput$NextToken' => '<p>An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list.</p>', 'ListProtectedResourcesInput$NextToken' => '<p>The next item following a partial list of returned items. For example, if a request is made to return <code>maxResults</code> number of items, <code>NextToken</code> allows you to return more items in your list starting at the location pointed to by the next token.</p>', 'ListProtectedResourcesOutput$NextToken' => '<p>The next item following a partial list of returned items. For example, if a request is made to return <code>maxResults</code> number of items, <code>NextToken</code> allows you to return more items in your list starting at the location pointed to by the next token.</p>', 'ListRecoveryPointsByBackupVaultInput$NextToken' => '<p>The next item following a partial list of returned items. For example, if a request is made to return <code>maxResults</code> number of items, <code>NextToken</code> allows you to return more items in your list starting at the location pointed to by the next token.</p>', 'ListRecoveryPointsByBackupVaultInput$ByBackupPlanId' => '<p>Returns only recovery points that match the specified backup plan ID.</p>', 'ListRecoveryPointsByBackupVaultOutput$NextToken' => '<p>The next item following a partial list of returned items. For example, if a request is made to return <code>maxResults</code> number of items, <code>NextToken</code> allows you to return more items in your list starting at the location pointed to by the next token.</p>', 'ListRecoveryPointsByResourceInput$NextToken' => '<p>The next item following a partial list of returned items. For example, if a request is made to return <code>maxResults</code> number of items, <code>NextToken</code> allows you to return more items in your list starting at the location pointed to by the next token.</p>', 'ListRecoveryPointsByResourceOutput$NextToken' => '<p>The next item following a partial list of returned items. For example, if a request is made to return <code>maxResults</code> number of items, <code>NextToken</code> allows you to return more items in your list starting at the location pointed to by the next token.</p>', 'ListReportJobsInput$ByStatus' => '<p>Returns only report jobs that are in the specified status. The statuses are:</p> <p> <code>CREATED | RUNNING | COMPLETED | FAILED</code> </p>', 'ListReportJobsInput$NextToken' => '<p>An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list.</p>', 'ListReportJobsOutput$NextToken' => '<p>An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list.</p>', 'ListReportPlansInput$NextToken' => '<p>An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list.</p>', 'ListReportPlansOutput$NextToken' => '<p>An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list.</p>', 'ListRestoreJobsInput$NextToken' => '<p>The next item following a partial list of returned items. For example, if a request is made to return <code>maxResults</code> number of items, <code>NextToken</code> allows you to return more items in your list starting at the location pointed to by the next token.</p>', 'ListRestoreJobsOutput$NextToken' => '<p>The next item following a partial list of returned items. For example, if a request is made to return <code>maxResults</code> number of items, <code>NextToken</code> allows you to return more items in your list starting at the location pointed to by the next token.</p>', 'ListTagsInput$NextToken' => '<p>The next item following a partial list of returned items. For example, if a request is made to return <code>maxResults</code> number of items, <code>NextToken</code> allows you to return more items in your list starting at the location pointed to by the next token.</p>', 'ListTagsOutput$NextToken' => '<p>The next item following a partial list of returned items. For example, if a request is made to return <code>maxResults</code> number of items, <code>NextToken</code> allows you to return more items in your list starting at the location pointed to by the next token.</p>', 'MissingParameterValueException$Code' => NULL, 'MissingParameterValueException$Message' => NULL, 'MissingParameterValueException$Type' => '<p/>', 'MissingParameterValueException$Context' => '<p/>', 'RecoveryPointByBackupVault$StatusMessage' => '<p>A message explaining the reason of the recovery point deletion failure.</p>', 'RecoveryPointByResource$StatusMessage' => '<p>A message explaining the reason of the recovery point deletion failure.</p>', 'RecoveryPointCreator$BackupPlanId' => '<p>Uniquely identifies a backup plan.</p>', 'RecoveryPointCreator$BackupPlanVersion' => '<p>Version IDs are unique, randomly generated, Unicode, UTF-8 encoded strings that are at most 1,024 bytes long. They cannot be edited.</p>', 'RecoveryPointCreator$BackupRuleId' => '<p>Uniquely identifies a rule used to schedule the backup of a selection of resources.</p>', 'ReportDeliveryChannel$S3BucketName' => '<p>The unique name of the S3 bucket that receives your reports.</p>', 'ReportDeliveryChannel$S3KeyPrefix' => '<p>The prefix for where Backup Audit Manager delivers your reports to Amazon S3. The prefix is this part of the following path: s3://your-bucket-name/<code>prefix</code>/Backup/us-west-2/year/month/day/report-name. If not specified, there is no prefix.</p>', 'ReportDestination$S3BucketName' => '<p>The unique name of the Amazon S3 bucket that receives your reports.</p>', 'ReportJob$ReportTemplate' => '<p>Identifies the report template for the report. Reports are built using a report template. The report templates are: </p> <p> <code>RESOURCE_COMPLIANCE_REPORT | CONTROL_COMPLIANCE_REPORT | BACKUP_JOB_REPORT | COPY_JOB_REPORT | RESTORE_JOB_REPORT</code> </p>', 'ReportJob$Status' => '<p>The status of a report job. The statuses are:</p> <p> <code>CREATED | RUNNING | COMPLETED | FAILED</code> </p> <p> <code>COMPLETED</code> means that the report is available for your review at your designated destination. If the status is <code>FAILED</code>, review the <code>StatusMessage</code> for the reason.</p>', 'ReportJob$StatusMessage' => '<p>A message explaining the status of the report job.</p>', 'ReportPlan$DeploymentStatus' => '<p>The deployment status of a report plan. The statuses are:</p> <p> <code>CREATE_IN_PROGRESS | UPDATE_IN_PROGRESS | DELETE_IN_PROGRESS | COMPLETED</code> </p>', 'ReportSetting$ReportTemplate' => '<p>Identifies the report template for the report. Reports are built using a report template. The report templates are:</p> <p> <code>RESOURCE_COMPLIANCE_REPORT | CONTROL_COMPLIANCE_REPORT | BACKUP_JOB_REPORT | COPY_JOB_REPORT | RESTORE_JOB_REPORT</code> </p>', 'ResourceNotFoundException$Code' => NULL, 'ResourceNotFoundException$Message' => NULL, 'ResourceNotFoundException$Type' => '<p/>', 'ResourceNotFoundException$Context' => '<p/>', 'RestoreJobsListMember$RestoreJobId' => '<p>Uniquely identifies the job that restores a recovery point.</p>', 'RestoreJobsListMember$StatusMessage' => '<p>A detailed message explaining the status of the job to restore a recovery point.</p>', 'RestoreJobsListMember$PercentDone' => '<p>Contains an estimated percentage complete of a job at the time the job status was queried.</p>', 'ServiceUnavailableException$Code' => NULL, 'ServiceUnavailableException$Message' => NULL, 'ServiceUnavailableException$Type' => '<p/>', 'ServiceUnavailableException$Context' => '<p/>', 'StartBackupJobInput$IdempotencyToken' => '<p>A customer-chosen string that you can use to distinguish between otherwise identical calls to <code>StartBackupJob</code>. Retrying a successful request with the same idempotency token results in a success message with no action taken.</p>', 'StartBackupJobOutput$BackupJobId' => '<p>Uniquely identifies a request to Backup to back up a resource.</p>', 'StartCopyJobInput$IdempotencyToken' => '<p>A customer-chosen string that you can use to distinguish between otherwise identical calls to <code>StartCopyJob</code>. Retrying a successful request with the same idempotency token results in a success message with no action taken.</p>', 'StartCopyJobOutput$CopyJobId' => '<p>Uniquely identifies a copy job.</p>', 'StartReportJobInput$IdempotencyToken' => '<p>A customer-chosen string that you can use to distinguish between otherwise identical calls to <code>StartReportJobInput</code>. Retrying a successful request with the same idempotency token results in a success message with no action taken.</p>', 'StartRestoreJobInput$IdempotencyToken' => '<p>A customer-chosen string that you can use to distinguish between otherwise identical calls to <code>StartRestoreJob</code>. Retrying a successful request with the same idempotency token results in a success message with no action taken.</p>', 'StopBackupJobInput$BackupJobId' => '<p>Uniquely identifies a request to Backup to back up a resource.</p>', 'TagKeyList$member' => NULL, 'UpdateBackupPlanInput$BackupPlanId' => '<p>Uniquely identifies a backup plan.</p>', 'UpdateBackupPlanOutput$BackupPlanId' => '<p>Uniquely identifies a backup plan.</p>', 'UpdateBackupPlanOutput$VersionId' => '<p>Unique, randomly generated, Unicode, UTF-8 encoded strings that are at most 1,024 bytes long. Version Ids cannot be edited.</p>', 'UpdateFrameworkInput$IdempotencyToken' => '<p>A customer-chosen string that you can use to distinguish between otherwise identical calls to <code>UpdateFrameworkInput</code>. Retrying a successful request with the same idempotency token results in a success message with no action taken.</p>', 'UpdateReportPlanInput$IdempotencyToken' => '<p>A customer-chosen string that you can use to distinguish between otherwise identical calls to <code>UpdateReportPlanInput</code>. Retrying a successful request with the same idempotency token results in a success message with no action taken.</p>', 'stringList$member' => NULL, 'stringMap$key' => NULL, 'stringMap$value' => NULL, ], ], 'stringList' => [ 'base' => NULL, 'refs' => [ 'ReportDestination$S3Keys' => '<p>The object key that uniquely identifies your reports in your S3 bucket.</p>', 'ReportSetting$FrameworkArns' => '<p>The Amazon Resource Names (ARNs) of the frameworks a report covers.</p>', ], ], 'stringMap' => [ 'base' => NULL, 'refs' => [ 'ControlScope$Tags' => '<p>Describes whether the control scope includes resources with one or more tags. Each tag is a key-value pair.</p>', 'CreateFrameworkInput$FrameworkTags' => '<p>Metadata that you can assign to help organize the frameworks that you create. Each tag is a key-value pair.</p>', 'CreateReportPlanInput$ReportPlanTags' => '<p>Metadata that you can assign to help organize the report plans that you create. Each tag is a key-value pair.</p>', ], ], 'timestamp' => [ 'base' => NULL, 'refs' => [ 'BackupJob$CreationDate' => '<p>The date and time a backup job is created, in Unix format and Coordinated Universal Time (UTC). The value of <code>CreationDate</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>', 'BackupJob$CompletionDate' => '<p>The date and time a job to create a backup job is completed, in Unix format and Coordinated Universal Time (UTC). The value of <code>CompletionDate</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>', 'BackupJob$ExpectedCompletionDate' => '<p>The date and time a job to back up resources is expected to be completed, in Unix format and Coordinated Universal Time (UTC). The value of <code>ExpectedCompletionDate</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>', 'BackupJob$StartBy' => '<p>Specifies the time in Unix format and Coordinated Universal Time (UTC) when a backup job must be started before it is canceled. The value is calculated by adding the start window to the scheduled time. So if the scheduled time were 6:00 PM and the start window is 2 hours, the <code>StartBy</code> time would be 8:00 PM on the date specified. The value of <code>StartBy</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>', 'BackupPlansListMember$CreationDate' => '<p>The date and time a resource backup plan is created, in Unix format and Coordinated Universal Time (UTC). The value of <code>CreationDate</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>', 'BackupPlansListMember$DeletionDate' => '<p>The date and time a backup plan is deleted, in Unix format and Coordinated Universal Time (UTC). The value of <code>DeletionDate</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>', 'BackupPlansListMember$LastExecutionDate' => '<p>The last time a job to back up resources was run with this rule. A date and time, in Unix format and Coordinated Universal Time (UTC). The value of <code>LastExecutionDate</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>', 'BackupSelectionsListMember$CreationDate' => '<p>The date and time a backup plan is created, in Unix format and Coordinated Universal Time (UTC). The value of <code>CreationDate</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>', 'BackupVaultListMember$CreationDate' => '<p>The date and time a resource backup is created, in Unix format and Coordinated Universal Time (UTC). The value of <code>CreationDate</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>', 'BackupVaultListMember$LockDate' => '<p>The date and time when Backup Vault Lock configuration becomes immutable, meaning it cannot be changed or deleted.</p> <p>If you applied Vault Lock to your vault without specifying a lock date, you can change your Vault Lock settings, or delete Vault Lock from the vault entirely, at any time.</p> <p>This value is in Unix format, Coordinated Universal Time (UTC), and accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>', 'CalculatedLifecycle$MoveToColdStorageAt' => '<p>A timestamp that specifies when to transition a recovery point to cold storage.</p>', 'CalculatedLifecycle$DeleteAt' => '<p>A timestamp that specifies when to delete a recovery point.</p>', 'CopyJob$CreationDate' => '<p>The date and time a copy job is created, in Unix format and Coordinated Universal Time (UTC). The value of <code>CreationDate</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>', 'CopyJob$CompletionDate' => '<p>The date and time a copy job is completed, in Unix format and Coordinated Universal Time (UTC). The value of <code>CompletionDate</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>', 'CreateBackupPlanOutput$CreationDate' => '<p>The date and time that a backup plan is created, in Unix format and Coordinated Universal Time (UTC). The value of <code>CreationDate</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>', 'CreateBackupSelectionOutput$CreationDate' => '<p>The date and time a backup selection is created, in Unix format and Coordinated Universal Time (UTC). The value of <code>CreationDate</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>', 'CreateBackupVaultOutput$CreationDate' => '<p>The date and time a backup vault is created, in Unix format and Coordinated Universal Time (UTC). The value of <code>CreationDate</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>', 'CreateReportPlanOutput$CreationTime' => '<p>The date and time a backup vault is created, in Unix format and Coordinated Universal Time (UTC). The value of <code>CreationTime</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>', 'DeleteBackupPlanOutput$DeletionDate' => '<p>The date and time a backup plan is deleted, in Unix format and Coordinated Universal Time (UTC). The value of <code>DeletionDate</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>', 'DescribeBackupJobOutput$CreationDate' => '<p>The date and time that a backup job is created, in Unix format and Coordinated Universal Time (UTC). The value of <code>CreationDate</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>', 'DescribeBackupJobOutput$CompletionDate' => '<p>The date and time that a job to create a backup job is completed, in Unix format and Coordinated Universal Time (UTC). The value of <code>CompletionDate</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>', 'DescribeBackupJobOutput$ExpectedCompletionDate' => '<p>The date and time that a job to back up resources is expected to be completed, in Unix format and Coordinated Universal Time (UTC). The value of <code>ExpectedCompletionDate</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>', 'DescribeBackupJobOutput$StartBy' => '<p>Specifies the time in Unix format and Coordinated Universal Time (UTC) when a backup job must be started before it is canceled. The value is calculated by adding the start window to the scheduled time. So if the scheduled time were 6:00 PM and the start window is 2 hours, the <code>StartBy</code> time would be 8:00 PM on the date specified. The value of <code>StartBy</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>', 'DescribeBackupVaultOutput$CreationDate' => '<p>The date and time that a backup vault is created, in Unix format and Coordinated Universal Time (UTC). The value of <code>CreationDate</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>', 'DescribeBackupVaultOutput$LockDate' => '<p>The date and time when Backup Vault Lock configuration cannot be changed or deleted.</p> <p>If you applied Vault Lock to your vault without specifying a lock date, you can change any of your Vault Lock settings, or delete Vault Lock from the vault entirely, at any time.</p> <p>This value is in Unix format, Coordinated Universal Time (UTC), and accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>', 'DescribeFrameworkOutput$CreationTime' => '<p>The date and time that a framework is created, in Unix format and Coordinated Universal Time (UTC). The value of <code>CreationTime</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>', 'DescribeGlobalSettingsOutput$LastUpdateTime' => '<p>The date and time that the flag <code>isCrossAccountBackupEnabled</code> was last updated. This update is in Unix format and Coordinated Universal Time (UTC). The value of <code>LastUpdateTime</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>', 'DescribeProtectedResourceOutput$LastBackupTime' => '<p>The date and time that a resource was last backed up, in Unix format and Coordinated Universal Time (UTC). The value of <code>LastBackupTime</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>', 'DescribeRecoveryPointOutput$CreationDate' => '<p>The date and time that a recovery point is created, in Unix format and Coordinated Universal Time (UTC). The value of <code>CreationDate</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>', 'DescribeRecoveryPointOutput$CompletionDate' => '<p>The date and time that a job to create a recovery point is completed, in Unix format and Coordinated Universal Time (UTC). The value of <code>CompletionDate</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>', 'DescribeRecoveryPointOutput$LastRestoreTime' => '<p>The date and time that a recovery point was last restored, in Unix format and Coordinated Universal Time (UTC). The value of <code>LastRestoreTime</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>', 'DescribeRestoreJobOutput$CreationDate' => '<p>The date and time that a restore job is created, in Unix format and Coordinated Universal Time (UTC). The value of <code>CreationDate</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>', 'DescribeRestoreJobOutput$CompletionDate' => '<p>The date and time that a job to restore a recovery point is completed, in Unix format and Coordinated Universal Time (UTC). The value of <code>CompletionDate</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>', 'Framework$CreationTime' => '<p>The date and time that a framework is created, in Unix format and Coordinated Universal Time (UTC). The value of <code>CreationTime</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>', 'GetBackupPlanOutput$CreationDate' => '<p>The date and time that a backup plan is created, in Unix format and Coordinated Universal Time (UTC). The value of <code>CreationDate</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>', 'GetBackupPlanOutput$DeletionDate' => '<p>The date and time that a backup plan is deleted, in Unix format and Coordinated Universal Time (UTC). The value of <code>DeletionDate</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>', 'GetBackupPlanOutput$LastExecutionDate' => '<p>The last time a job to back up resources was run with this backup plan. A date and time, in Unix format and Coordinated Universal Time (UTC). The value of <code>LastExecutionDate</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>', 'GetBackupSelectionOutput$CreationDate' => '<p>The date and time a backup selection is created, in Unix format and Coordinated Universal Time (UTC). The value of <code>CreationDate</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>', 'ListBackupJobsInput$ByCreatedBefore' => '<p>Returns only backup jobs that were created before the specified date.</p>', 'ListBackupJobsInput$ByCreatedAfter' => '<p>Returns only backup jobs that were created after the specified date.</p>', 'ListCopyJobsInput$ByCreatedBefore' => '<p>Returns only copy jobs that were created before the specified date.</p>', 'ListCopyJobsInput$ByCreatedAfter' => '<p>Returns only copy jobs that were created after the specified date.</p>', 'ListRecoveryPointsByBackupVaultInput$ByCreatedBefore' => '<p>Returns only recovery points that were created before the specified timestamp.</p>', 'ListRecoveryPointsByBackupVaultInput$ByCreatedAfter' => '<p>Returns only recovery points that were created after the specified timestamp.</p>', 'ListReportJobsInput$ByCreationBefore' => '<p>Returns only report jobs that were created before the date and time specified in Unix format and Coordinated Universal Time (UTC). For example, the value 1516925490 represents Friday, January 26, 2018 12:11:30 AM.</p>', 'ListReportJobsInput$ByCreationAfter' => '<p>Returns only report jobs that were created after the date and time specified in Unix format and Coordinated Universal Time (UTC). For example, the value 1516925490 represents Friday, January 26, 2018 12:11:30 AM.</p>', 'ListRestoreJobsInput$ByCreatedBefore' => '<p>Returns only restore jobs that were created before the specified date.</p>', 'ListRestoreJobsInput$ByCreatedAfter' => '<p>Returns only restore jobs that were created after the specified date.</p>', 'ProtectedResource$LastBackupTime' => '<p>The date and time a resource was last backed up, in Unix format and Coordinated Universal Time (UTC). The value of <code>LastBackupTime</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>', 'RecoveryPointByBackupVault$CreationDate' => '<p>The date and time a recovery point is created, in Unix format and Coordinated Universal Time (UTC). The value of <code>CreationDate</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>', 'RecoveryPointByBackupVault$CompletionDate' => '<p>The date and time a job to restore a recovery point is completed, in Unix format and Coordinated Universal Time (UTC). The value of <code>CompletionDate</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>', 'RecoveryPointByBackupVault$LastRestoreTime' => '<p>The date and time a recovery point was last restored, in Unix format and Coordinated Universal Time (UTC). The value of <code>LastRestoreTime</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>', 'RecoveryPointByResource$CreationDate' => '<p>The date and time a recovery point is created, in Unix format and Coordinated Universal Time (UTC). The value of <code>CreationDate</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>', 'ReportJob$CreationTime' => '<p>The date and time that a report job is created, in Unix format and Coordinated Universal Time (UTC). The value of <code>CreationTime</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>', 'ReportJob$CompletionTime' => '<p>The date and time that a report job is completed, in Unix format and Coordinated Universal Time (UTC). The value of <code>CompletionTime</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>', 'ReportPlan$CreationTime' => '<p>The date and time that a report plan is created, in Unix format and Coordinated Universal Time (UTC). The value of <code>CreationTime</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>', 'ReportPlan$LastAttemptedExecutionTime' => '<p>The date and time that a report job associated with this report plan last attempted to run, in Unix format and Coordinated Universal Time (UTC). The value of <code>LastAttemptedExecutionTime</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>', 'ReportPlan$LastSuccessfulExecutionTime' => '<p>The date and time that a report job associated with this report plan last successfully ran, in Unix format and Coordinated Universal Time (UTC). The value of <code>LastSuccessfulExecutionTime</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>', 'RestoreJobsListMember$CreationDate' => '<p>The date and time a restore job is created, in Unix format and Coordinated Universal Time (UTC). The value of <code>CreationDate</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>', 'RestoreJobsListMember$CompletionDate' => '<p>The date and time a job to restore a recovery point is completed, in Unix format and Coordinated Universal Time (UTC). The value of <code>CompletionDate</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>', 'StartBackupJobOutput$CreationDate' => '<p>The date and time that a backup job is created, in Unix format and Coordinated Universal Time (UTC). The value of <code>CreationDate</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>', 'StartCopyJobOutput$CreationDate' => '<p>The date and time that a copy job is created, in Unix format and Coordinated Universal Time (UTC). The value of <code>CreationDate</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>', 'UpdateBackupPlanOutput$CreationDate' => '<p>The date and time a backup plan is created, in Unix format and Coordinated Universal Time (UTC). The value of <code>CreationDate</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>', 'UpdateFrameworkOutput$CreationTime' => '<p>The date and time that a framework is created, in Unix format and Coordinated Universal Time (UTC). The value of <code>CreationTime</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>', 'UpdateReportPlanOutput$CreationTime' => '<p>The date and time that a report plan is created, in Unix format and Coordinated Universal Time (UTC). The value of <code>CreationTime</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>', ], ], ],];
