<?php
// This file was auto-generated from sdk-root/src/data/pinpoint-sms-voice-v2/2022-03-31/docs-2.json
return [ 'version' => '2.0', 'service' => '<p>Welcome to the <i>Amazon Pinpoint SMS and Voice, version 2 API Reference</i>. This guide provides information about Amazon Pinpoint SMS and Voice, version 2 API resources, including supported HTTP methods, parameters, and schemas.</p> <p>Amazon Pinpoint is an Amazon Web Services service that you can use to engage with your recipients across multiple messaging channels. The Amazon Pinpoint SMS and Voice, version 2 API provides programmatic access to options that are unique to the SMS and voice channels and supplements the resources provided by the Amazon Pinpoint API.</p> <p>If you\'re new to Amazon Pinpoint, it\'s also helpful to review the <a href="https://docs.aws.amazon.com/pinpoint/latest/developerguide/welcome.html"> Amazon Pinpoint Developer Guide</a>. The <i>Amazon Pinpoint Developer Guide</i> provides tutorials, code samples, and procedures that demonstrate how to use Amazon Pinpoint features programmatically and how to integrate Amazon Pinpoint functionality into mobile apps and other types of applications. The guide also provides key information, such as Amazon Pinpoint integration with other Amazon Web Services services, and the quotas that apply to use of the service.</p>', 'operations' => [ 'AssociateOriginationIdentity' => '<p>Associates the specified origination identity with a pool.</p> <p>If the origination identity is a phone number and is already associated with another pool, an Error is returned. A sender ID can be associated with multiple pools.</p> <p>If the origination identity configuration doesn\'t match the pool\'s configuration, an Error is returned.</p>', 'CreateConfigurationSet' => '<p>Creates a new configuration set. After you create the configuration set, you can add one or more event destinations to it.</p> <p>A configuration set is a set of rules that you apply to the SMS and voice messages that you send.</p> <p>When you send a message, you can optionally specify a single configuration set.</p>', 'CreateEventDestination' => '<p>Creates a new event destination in a configuration set.</p> <p>An event destination is a location where you send message events. The event options are Amazon CloudWatch, Amazon Kinesis Data Firehose, or Amazon SNS. For example, when a message is delivered successfully, you can send information about that event to an event destination, or send notifications to endpoints that are subscribed to an Amazon SNS topic.</p> <p>Each configuration set can contain between 0 and 5 event destinations. Each event destination can contain a reference to a single destination, such as a CloudWatch or Kinesis Data Firehose destination.</p>', 'CreateOptOutList' => '<p>Creates a new opt-out list.</p> <p>If the opt-out list name already exists, an Error is returned.</p> <p>An opt-out list is a list of phone numbers that are opted out, meaning you can\'t send SMS or voice messages to them. If end user replies with the keyword "STOP," an entry for the phone number is added to the opt-out list. In addition to STOP, your recipients can use any supported opt-out keyword, such as CANCEL or OPTOUT. For a list of supported opt-out keywords, see <a href="https://docs.aws.amazon.com/pinpoint/latest/userguide/channels-sms-manage.html#channels-sms-manage-optout"> SMS opt out </a> in the <i>Amazon Pinpoint User Guide</i>.</p>', 'CreatePool' => '<p>Creates a new pool and associates the specified origination identity to the pool. A pool can include one or more phone numbers and SenderIds that are associated with your Amazon Web Services account.</p> <p>The new pool inherits its configuration from the specified origination identity. This includes keywords, message type, opt-out list, two-way configuration, and self-managed opt-out configuration. Deletion protection isn\'t inherited from the origination identity and defaults to false.</p> <p>If the origination identity is a phone number and is already associated with another pool, an Error is returned. A sender ID can be associated with multiple pools.</p>', 'DeleteConfigurationSet' => '<p>Deletes an existing configuration set.</p> <p>A configuration set is a set of rules that you apply to voice and SMS messages that you send. In a configuration set, you can specify a destination for specific types of events related to voice and SMS messages. </p>', 'DeleteDefaultMessageType' => '<p>Deletes an existing default message type on a configuration set.</p> <p> A message type is a type of messages that you plan to send. If you send account-related messages or time-sensitive messages such as one-time passcodes, choose <b>Transactional</b>. If you plan to send messages that contain marketing material or other promotional content, choose <b>Promotional</b>. This setting applies to your entire Amazon Web Services account. </p>', 'DeleteDefaultSenderId' => '<p>Deletes an existing default sender ID on a configuration set.</p> <p>A default sender ID is the identity that appears on recipients\' devices when they receive SMS messages. Support for sender ID capabilities varies by country or region.</p>', 'DeleteEventDestination' => '<p>Deletes an existing event destination.</p> <p>An event destination is a location where you send response information about the messages that you send. For example, when a message is delivered successfully, you can send information about that event to an Amazon CloudWatch destination, or send notifications to endpoints that are subscribed to an Amazon SNS topic.</p>', 'DeleteKeyword' => '<p>Deletes an existing keyword from an origination phone number or pool.</p> <p>A keyword is a word that you can search for on a particular phone number or pool. It is also a specific word or phrase that an end user can send to your number to elicit a response, such as an informational message or a special offer. When your number receives a message that begins with a keyword, Amazon Pinpoint responds with a customizable message.</p> <p>Keywords "HELP" and "STOP" can\'t be deleted or modified.</p>', 'DeleteOptOutList' => '<p>Deletes an existing opt-out list. All opted out phone numbers in the opt-out list are deleted.</p> <p>If the specified opt-out list name doesn\'t exist or is in-use by an origination phone number or pool, an Error is returned.</p>', 'DeleteOptedOutNumber' => '<p>Deletes an existing opted out destination phone number from the specified opt-out list.</p> <p>Each destination phone number can only be deleted once every 30 days.</p> <p>If the specified destination phone number doesn\'t exist or if the opt-out list doesn\'t exist, an Error is returned.</p>', 'DeletePool' => '<p>Deletes an existing pool. Deleting a pool disassociates all origination identities from that pool.</p> <p>If the pool status isn\'t active or if deletion protection is enabled, an Error is returned.</p> <p>A pool is a collection of phone numbers and SenderIds. A pool can include one or more phone numbers and SenderIds that are associated with your Amazon Web Services account.</p>', 'DeleteTextMessageSpendLimitOverride' => '<p>Deletes an account-level monthly spending limit override for sending text messages. Deleting a spend limit override will set the <code>EnforcedLimit</code> to equal the <code>MaxLimit</code>, which is controlled by Amazon Web Services. For more information on spend limits (quotas) see <a href="https://docs.aws.amazon.com/pinpoint/latest/developerguide/quotas.html">Amazon Pinpoint quotas </a> in the <i>Amazon Pinpoint Developer Guide</i>.</p>', 'DeleteVoiceMessageSpendLimitOverride' => '<p>Deletes an account level monthly spend limit override for sending voice messages. Deleting a spend limit override sets the <code>EnforcedLimit</code> equal to the <code>MaxLimit</code>, which is controlled by Amazon Web Services. For more information on spending limits (quotas) see <a href="https://docs.aws.amazon.com/pinpoint/latest/developerguide/quotas.html">Amazon Pinpoint quotas</a> in the <i>Amazon Pinpoint Developer Guide</i>.</p>', 'DescribeAccountAttributes' => '<p>Describes attributes of your Amazon Web Services account. The supported account attributes include account tier, which indicates whether your account is in the sandbox or production environment. When you\'re ready to move your account out of the sandbox, create an Amazon Web Services Support case for a service limit increase request.</p> <p>New Amazon Pinpoint accounts are placed into an SMS or voice sandbox. The sandbox protects both Amazon Web Services end recipients and SMS or voice recipients from fraud and abuse. </p>', 'DescribeAccountLimits' => '<p>Describes the current Amazon Pinpoint SMS Voice V2 resource quotas for your account. The description for a quota includes the quota name, current usage toward that quota, and the quota\'s maximum value.</p> <p>When you establish an Amazon Web Services account, the account has initial quotas on the maximum number of configuration sets, opt-out lists, phone numbers, and pools that you can create in a given Region. For more information see <a href="https://docs.aws.amazon.com/pinpoint/latest/developerguide/quotas.html"> Amazon Pinpoint quotas </a> in the <i>Amazon Pinpoint Developer Guide</i>.</p>', 'DescribeConfigurationSets' => '<p>Describes the specified configuration sets or all in your account.</p> <p>If you specify configuration set names, the output includes information for only the specified configuration sets. If you specify filters, the output includes information for only those configuration sets that meet the filter criteria. If you don\'t specify configuration set names or filters, the output includes information for all configuration sets.</p> <p>If you specify a configuration set name that isn\'t valid, an error is returned.</p>', 'DescribeKeywords' => '<p>Describes the specified keywords or all keywords on your origination phone number or pool.</p> <p>A keyword is a word that you can search for on a particular phone number or pool. It is also a specific word or phrase that an end user can send to your number to elicit a response, such as an informational message or a special offer. When your number receives a message that begins with a keyword, Amazon Pinpoint responds with a customizable message.</p> <p>If you specify a keyword that isn\'t valid, an Error is returned.</p>', 'DescribeOptOutLists' => '<p>Describes the specified opt-out list or all opt-out lists in your account.</p> <p>If you specify opt-out list names, the output includes information for only the specified opt-out lists. Opt-out lists include only those that meet the filter criteria. If you don\'t specify opt-out list names or filters, the output includes information for all opt-out lists.</p> <p>If you specify an opt-out list name that isn\'t valid, an Error is returned.</p>', 'DescribeOptedOutNumbers' => '<p>Describes the specified opted out destination numbers or all opted out destination numbers in an opt-out list.</p> <p>If you specify opted out numbers, the output includes information for only the specified opted out numbers. If you specify filters, the output includes information for only those opted out numbers that meet the filter criteria. If you don\'t specify opted out numbers or filters, the output includes information for all opted out destination numbers in your opt-out list.</p> <p>If you specify an opted out number that isn\'t valid, an Error is returned.</p>', 'DescribePhoneNumbers' => '<p>Describes the specified origination phone number, or all the phone numbers in your account.</p> <p>If you specify phone number IDs, the output includes information for only the specified phone numbers. If you specify filters, the output includes information for only those phone numbers that meet the filter criteria. If you don\'t specify phone number IDs or filters, the output includes information for all phone numbers.</p> <p>If you specify a phone number ID that isn\'t valid, an Error is returned.</p>', 'DescribePools' => '<p>Retrieves the specified pools or all pools associated with your Amazon Web Services account.</p> <p>If you specify pool IDs, the output includes information for only the specified pools. If you specify filters, the output includes information for only those pools that meet the filter criteria. If you don\'t specify pool IDs or filters, the output includes information for all pools.</p> <p>If you specify a pool ID that isn\'t valid, an Error is returned.</p> <p>A pool is a collection of phone numbers and SenderIds. A pool can include one or more phone numbers and SenderIds that are associated with your Amazon Web Services account.</p>', 'DescribeSenderIds' => '<p>Describes the specified SenderIds or all SenderIds associated with your Amazon Web Services account.</p> <p>If you specify SenderIds, the output includes information for only the specified SenderIds. If you specify filters, the output includes information for only those SenderIds that meet the filter criteria. If you don\'t specify SenderIds or filters, the output includes information for all SenderIds.</p> <p>f you specify a sender ID that isn\'t valid, an Error is returned.</p>', 'DescribeSpendLimits' => '<p>Describes the current Amazon Pinpoint monthly spend limits for sending voice and text messages.</p> <p>When you establish an Amazon Web Services account, the account has initial monthly spend limit in a given Region. For more information on increasing your monthly spend limit, see <a href="https://docs.aws.amazon.com/pinpoint/latest/userguide/channels-sms-awssupport-spend-threshold.html"> Requesting increases to your monthly SMS spending quota for Amazon Pinpoint </a> in the <i>Amazon Pinpoint User Guide</i>.</p>', 'DisassociateOriginationIdentity' => '<p>Removes the specified origination identity from an existing pool.</p> <p>If the origination identity isn\'t associated with the specified pool, an Error is returned.</p>', 'ListPoolOriginationIdentities' => '<p>Lists all associated origination identities in your pool.</p> <p>If you specify filters, the output includes information for only those origination identities that meet the filter criteria.</p>', 'ListTagsForResource' => '<p>List all tags associated with a resource.</p>', 'PutKeyword' => '<p>Creates or updates a keyword configuration on an origination phone number or pool.</p> <p> A keyword is a word that you can search for on a particular phone number or pool. It is also a specific word or phrase that an end user can send to your number to elicit a response, such as an informational message or a special offer. When your number receives a message that begins with a keyword, Amazon Pinpoint responds with a customizable message.</p> <p>If you specify a keyword that isn\'t valid, an Error is returned.</p>', 'PutOptedOutNumber' => '<p>Creates an opted out destination phone number in the opt-out list.</p> <p>If the destination phone number isn\'t valid or if the specified opt-out list doesn\'t exist, an Error is returned.</p>', 'ReleasePhoneNumber' => '<p>Releases an existing origination phone number in your account. Once released, a phone number is no longer available for sending messages.</p> <p>If the origination phone number has deletion protection enabled or is associated with a pool, an Error is returned.</p>', 'RequestPhoneNumber' => '<p>Request an origination phone number for use in your account. For more information on phone number request see <a href="https://docs.aws.amazon.com/pinpoint/latest/userguide/settings-sms-request-number.html"> Requesting a number </a> in the <i>Amazon Pinpoint User Guide</i>.</p>', 'SendTextMessage' => '<p>Creates a new text message and sends it to a recipient\'s phone number.</p> <p>SMS throughput limits are measured in Message Parts per Second (MPS). Your MPS limit depends on the destination country of your messages, as well as the type of phone number (origination number) that you use to send the message. For more information, see <a href="https://docs.aws.amazon.com/pinpoint/latest/userguide/channels-sms-limitations-mps.html">Message Parts per Second (MPS) limits</a> in the <i>Amazon Pinpoint User Guide</i>.</p>', 'SendVoiceMessage' => '<p>Allows you to send a request that sends a text message through Amazon Pinpoint. This operation uses <a href="http://aws.amazon.com/polly/">Amazon Polly</a> to convert a text script into a voice message.</p>', 'SetDefaultMessageType' => '<p>Sets the default message type on a configuration set.</p> <p>Choose the category of SMS messages that you plan to send from this account. If you send account-related messages or time-sensitive messages such as one-time passcodes, choose <b>Transactional</b>. If you plan to send messages that contain marketing material or other promotional content, choose <b>Promotional</b>. This setting applies to your entire Amazon Web Services account.</p>', 'SetDefaultSenderId' => '<p>Sets default sender ID on a configuration set.</p> <p>When sending a text message to a destination country that supports sender IDs, the default sender ID on the configuration set specified will be used if no dedicated origination phone numbers or registered sender IDs are available in your account.</p>', 'SetTextMessageSpendLimitOverride' => '<p>Sets an account level monthly spend limit override for sending text messages. The requested spend limit must be less than or equal to the <code>MaxLimit</code>, which is set by Amazon Web Services. </p>', 'SetVoiceMessageSpendLimitOverride' => '<p>Sets an account level monthly spend limit override for sending voice messages. The requested spend limit must be less than or equal to the <code>MaxLimit</code>, which is set by Amazon Web Services. </p>', 'TagResource' => '<p>Adds or overwrites only the specified tags for the specified Amazon Pinpoint SMS Voice, version 2 resource. When you specify an existing tag key, the value is overwritten with the new value. Each resource can have a maximum of 50 tags. Each tag consists of a key and an optional value. Tag keys must be unique per resource. For more information about tags, see <a href="https://docs.aws.amazon.com/pinpoint/latest/developerguide/tagging-resources.html"> Tagging Amazon Pinpoint resources</a> in the <i>Amazon Pinpoint Developer Guide</i>.</p>', 'UntagResource' => '<p>Removes the association of the specified tags from an Amazon Pinpoint SMS Voice V2 resource. For more information on tags see <a href="https://docs.aws.amazon.com/pinpoint/latest/developerguide/tagging-resources.html"> Tagging Amazon Pinpoint resources</a> in the <i>Amazon Pinpoint Developer Guide</i>. </p>', 'UpdateEventDestination' => '<p>Updates an existing event destination in a configuration set. You can update the IAM role ARN for CloudWatch Logs and Kinesis Data Firehose. You can also enable or disable the event destination.</p> <p>You may want to update an event destination to change its matching event types or updating the destination resource ARN. You can\'t change an event destination\'s type between CloudWatch Logs, Kinesis Data Firehose, and Amazon SNS.</p>', 'UpdatePhoneNumber' => '<p>Updates the configuration of an existing origination phone number. You can update the opt-out list, enable or disable two-way messaging, change the TwoWayChannelArn, enable or disable self-managed opt-outs, and enable or disable deletion protection.</p> <p>If the origination phone number is associated with a pool, an Error is returned.</p>', 'UpdatePool' => '<p>Updates the configuration of an existing pool. You can update the opt-out list, enable or disable two-way messaging, change the <code>TwoWayChannelArn</code>, enable or disable self-managed opt-outs, enable or disable deletion protection, and enable or disable shared routes.</p>', ], 'shapes' => [ 'AccessDeniedException' => [ 'base' => '<p>The request was denied because you don\'t have sufficient permissions to access the resource.</p>', 'refs' => [], ], 'AccessDeniedExceptionReason' => [ 'base' => NULL, 'refs' => [ 'AccessDeniedException$Reason' => '<p>The reason for the exception.</p>', ], ], 'AccountAttribute' => [ 'base' => '<p>Displays the attributes associated with a single Amazon Web Services account.</p>', 'refs' => [ 'AccountAttributeList$member' => NULL, ], ], 'AccountAttributeList' => [ 'base' => NULL, 'refs' => [ 'DescribeAccountAttributesResult$AccountAttributes' => '<p>An array of AccountAttributes objects.</p>', ], ], 'AccountAttributeName' => [ 'base' => NULL, 'refs' => [ 'AccountAttribute$Name' => '<p>The name of the account attribute.</p>', ], ], 'AccountLimit' => [ 'base' => '<p>The current resource quotas associated with an Amazon Web Services account.</p>', 'refs' => [ 'AccountLimitList$member' => NULL, ], ], 'AccountLimitList' => [ 'base' => NULL, 'refs' => [ 'DescribeAccountLimitsResult$AccountLimits' => '<p>An array of AccountLimit objects that show the current spend limits.</p>', ], ], 'AccountLimitName' => [ 'base' => NULL, 'refs' => [ 'AccountLimit$Name' => '<p>The name of the attribute to apply the account limit to.</p>', ], ], 'AmazonResourceName' => [ 'base' => NULL, 'refs' => [ 'ListTagsForResourceRequest$ResourceArn' => '<p>The Amazon Resource Name (ARN) of the resource to query for.</p>', 'ListTagsForResourceResult$ResourceArn' => '<p>The ARN of the resource.</p>', 'TagResourceRequest$ResourceArn' => '<p>The Amazon Resource Name (ARN) of the resource.</p>', 'UntagResourceRequest$ResourceArn' => '<p>The Amazon Resource Name (ARN) of the resource.</p>', ], ], 'AssociateOriginationIdentityRequest' => [ 'base' => NULL, 'refs' => [], ], 'AssociateOriginationIdentityResult' => [ 'base' => NULL, 'refs' => [], ], 'Boolean' => [ 'base' => NULL, 'refs' => [ 'CreatePoolRequest$DeletionProtectionEnabled' => '<p>By default this is set to false. When set to true the pool can\'t be deleted. You can change this value using the <a>UpdatePool</a> action.</p>', 'EventDestination$Enabled' => '<p>When set to true events will be logged.</p>', 'RequestPhoneNumberRequest$DeletionProtectionEnabled' => '<p>By default this is set to false. When set to true the phone number can\'t be deleted.</p>', 'UpdateEventDestinationRequest$Enabled' => '<p>When set to true logging is enabled.</p>', 'UpdatePhoneNumberRequest$TwoWayEnabled' => '<p>By default this is set to false. When set to true you can receive incoming text messages from your end recipients.</p>', 'UpdatePhoneNumberRequest$SelfManagedOptOutsEnabled' => '<p>By default this is set to false. When an end recipient sends a message that begins with HELP or STOP to one of your dedicated numbers, Amazon Pinpoint automatically replies with a customizable message and adds the end recipient to the OptOutList. When set to true you\'re responsible for responding to HELP and STOP requests. You\'re also responsible for tracking and honoring opt-out requests.</p>', 'UpdatePhoneNumberRequest$DeletionProtectionEnabled' => '<p>By default this is set to false. When set to true the phone number can\'t be deleted. </p>', 'UpdatePoolRequest$TwoWayEnabled' => '<p>By default this is set to false. When set to true you can receive incoming text messages from your end recipients.</p>', 'UpdatePoolRequest$SelfManagedOptOutsEnabled' => '<p>By default this is set to false. When an end recipient sends a message that begins with HELP or STOP to one of your dedicated numbers, Amazon Pinpoint automatically replies with a customizable message and adds the end recipient to the OptOutList. When set to true you\'re responsible for responding to HELP and STOP requests. You\'re also responsible for tracking and honoring opt-out requests.</p>', 'UpdatePoolRequest$SharedRoutesEnabled' => '<p>Indicates whether shared routes are enabled for the pool.</p>', 'UpdatePoolRequest$DeletionProtectionEnabled' => '<p>When set to true the pool can\'t be deleted.</p>', ], ], 'ClientToken' => [ 'base' => NULL, 'refs' => [ 'AssociateOriginationIdentityRequest$ClientToken' => '<p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don\'t specify a client token, a randomly generated token is used for the request to ensure idempotency.</p>', 'CreateConfigurationSetRequest$ClientToken' => '<p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don\'t specify a client token, a randomly generated token is used for the request to ensure idempotency.</p>', 'CreateEventDestinationRequest$ClientToken' => '<p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don\'t specify a client token, a randomly generated token is used for the request to ensure idempotency.</p>', 'CreateOptOutListRequest$ClientToken' => '<p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don\'t specify a client token, a randomly generated token is used for the request to ensure idempotency.</p>', 'CreatePoolRequest$ClientToken' => '<p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don\'t specify a client token, a randomly generated token is used for the request to ensure idempotency.</p>', 'DisassociateOriginationIdentityRequest$ClientToken' => '<p>Unique, case-sensitive identifier you provide to ensure the idempotency of the request. If you don\'t specify a client token, a randomly generated token is used for the request to ensure idempotency.</p>', 'RequestPhoneNumberRequest$ClientToken' => '<p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don\'t specify a client token, a randomly generated token is used for the request to ensure idempotency.</p>', ], ], 'CloudWatchLogsDestination' => [ 'base' => '<p>Contains the destination configuration to use when publishing message sending events. </p>', 'refs' => [ 'CreateEventDestinationRequest$CloudWatchLogsDestination' => '<p>An object that contains information about an event destination for logging to Amazon CloudWatch logs.</p>', 'EventDestination$CloudWatchLogsDestination' => '<p>An object that contains information about an event destination that sends logging events to Amazon CloudWatch logs.</p>', 'UpdateEventDestinationRequest$CloudWatchLogsDestination' => '<p>An object that contains information about an event destination that sends data to CloudWatch Logs.</p>', ], ], 'ConfigurationSetFilter' => [ 'base' => '<p>The information for configuration sets that meet a specified criteria.</p>', 'refs' => [ 'ConfigurationSetFilterList$member' => NULL, ], ], 'ConfigurationSetFilterList' => [ 'base' => NULL, 'refs' => [ 'DescribeConfigurationSetsRequest$Filters' => '<p>An array of filters to apply to the results that are returned.</p>', ], ], 'ConfigurationSetFilterName' => [ 'base' => NULL, 'refs' => [ 'ConfigurationSetFilter$Name' => '<p>The name of the attribute to filter on.</p>', ], ], 'ConfigurationSetInformation' => [ 'base' => '<p>Information related to a given configuration set in your Amazon Web Services account.</p>', 'refs' => [ 'ConfigurationSetInformationList$member' => NULL, ], ], 'ConfigurationSetInformationList' => [ 'base' => NULL, 'refs' => [ 'DescribeConfigurationSetsResult$ConfigurationSets' => '<p>An array of ConfigurationSets objects.</p>', ], ], 'ConfigurationSetName' => [ 'base' => NULL, 'refs' => [ 'ConfigurationSetInformation$ConfigurationSetName' => '<p>The name of the ConfigurationSet.</p>', 'CreateConfigurationSetRequest$ConfigurationSetName' => '<p>The name to use for the new configuration set.</p>', 'CreateConfigurationSetResult$ConfigurationSetName' => '<p>The name of the new configuration set.</p>', 'CreateEventDestinationResult$ConfigurationSetName' => '<p>The name of the configuration set.</p>', 'DeleteConfigurationSetResult$ConfigurationSetName' => '<p>The name of the deleted configuration set.</p>', 'DeleteDefaultMessageTypeResult$ConfigurationSetName' => '<p>The name of the configuration set.</p>', 'DeleteDefaultSenderIdResult$ConfigurationSetName' => '<p>The name of the configuration set.</p>', 'DeleteEventDestinationResult$ConfigurationSetName' => '<p>The name of the configuration set the event destination was deleted from.</p>', 'SetDefaultMessageTypeResult$ConfigurationSetName' => '<p>The name of the configuration set that was updated.</p>', 'SetDefaultSenderIdResult$ConfigurationSetName' => '<p>The name of the configuration set that was updated.</p>', 'UpdateEventDestinationResult$ConfigurationSetName' => '<p>The name of the configuration set.</p>', ], ], 'ConfigurationSetNameList' => [ 'base' => NULL, 'refs' => [ 'DescribeConfigurationSetsRequest$ConfigurationSetNames' => '<p>An array of strings. Each element can be either a ConfigurationSetName or ConfigurationSetArn.</p>', ], ], 'ConfigurationSetNameOrArn' => [ 'base' => NULL, 'refs' => [ 'ConfigurationSetNameList$member' => NULL, 'CreateEventDestinationRequest$ConfigurationSetName' => '<p>Either the name of the configuration set or the configuration set ARN to apply event logging to. The ConfigurateSetName and ConfigurationSetArn can be found using the <a>DescribeConfigurationSets</a> action.</p>', 'DeleteConfigurationSetRequest$ConfigurationSetName' => '<p>The name of the configuration set or the configuration set ARN that you want to delete. The ConfigurationSetName and ConfigurationSetArn can be found using the <a>DescribeConfigurationSets</a> action.</p>', 'DeleteDefaultMessageTypeRequest$ConfigurationSetName' => '<p>The name of the configuration set or the configuration set Amazon Resource Name (ARN) to delete the default message type from. The ConfigurationSetName and ConfigurationSetArn can be found using the <a>DescribeConfigurationSets</a> action.</p>', 'DeleteDefaultSenderIdRequest$ConfigurationSetName' => '<p>The name of the configuration set or the configuration set Amazon Resource Name (ARN) to delete the default sender ID from. The ConfigurationSetName and ConfigurationSetArn can be found using the <a>DescribeConfigurationSets</a> action.</p>', 'DeleteEventDestinationRequest$ConfigurationSetName' => '<p>The name of the configuration set or the configuration set\'s Amazon Resource Name (ARN) to remove the event destination from. The ConfigurateSetName and ConfigurationSetArn can be found using the <a>DescribeConfigurationSets</a> action.</p>', 'SendTextMessageRequest$ConfigurationSetName' => '<p>The name of the configuration set to use. This can be either the ConfigurationSetName or ConfigurationSetArn.</p>', 'SendVoiceMessageRequest$ConfigurationSetName' => '<p>The name of the configuration set to use. This can be either the ConfigurationSetName or ConfigurationSetArn.</p>', 'SetDefaultMessageTypeRequest$ConfigurationSetName' => '<p>The configuration set to update with a new default message type. This field can be the ConsigurationSetName or ConfigurationSetArn.</p>', 'SetDefaultSenderIdRequest$ConfigurationSetName' => '<p>The configuration set to updated with a new default SenderId. This field can be the ConsigurationSetName or ConfigurationSetArn.</p>', 'UpdateEventDestinationRequest$ConfigurationSetName' => '<p>The configuration set to update with the new event destination. Valid values for this can be the ConfigurationSetName or ConfigurationSetArn.</p>', ], ], 'ConflictException' => [ 'base' => '<p>Your request has conflicting operations. This can occur if you\'re trying to perform more than one operation on the same resource at the same time or it could be that the requested action isn\'t valid for the current state or configuration of the resource.</p>', 'refs' => [], ], 'ConflictExceptionReason' => [ 'base' => NULL, 'refs' => [ 'ConflictException$Reason' => '<p>The reason for the exception.</p>', ], ], 'ContextKey' => [ 'base' => NULL, 'refs' => [ 'ContextMap$key' => NULL, ], ], 'ContextMap' => [ 'base' => NULL, 'refs' => [ 'SendTextMessageRequest$Context' => '<p>You can specify custom data in this field. If you do, that data is logged to the event destination.</p>', 'SendVoiceMessageRequest$Context' => '<p>You can specify custom data in this field. If you do, that data is logged to the event destination.</p>', ], ], 'ContextValue' => [ 'base' => NULL, 'refs' => [ 'ContextMap$value' => NULL, ], ], 'CreateConfigurationSetRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateConfigurationSetResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateEventDestinationRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateEventDestinationResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateOptOutListRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateOptOutListResult' => [ 'base' => NULL, 'refs' => [], ], 'CreatePoolRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreatePoolResult' => [ 'base' => NULL, 'refs' => [], ], 'DeleteConfigurationSetRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteConfigurationSetResult' => [ 'base' => NULL, 'refs' => [], ], 'DeleteDefaultMessageTypeRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteDefaultMessageTypeResult' => [ 'base' => NULL, 'refs' => [], ], 'DeleteDefaultSenderIdRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteDefaultSenderIdResult' => [ 'base' => NULL, 'refs' => [], ], 'DeleteEventDestinationRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteEventDestinationResult' => [ 'base' => NULL, 'refs' => [], ], 'DeleteKeywordRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteKeywordResult' => [ 'base' => NULL, 'refs' => [], ], 'DeleteOptOutListRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteOptOutListResult' => [ 'base' => NULL, 'refs' => [], ], 'DeleteOptedOutNumberRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteOptedOutNumberResult' => [ 'base' => NULL, 'refs' => [], ], 'DeletePoolRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeletePoolResult' => [ 'base' => NULL, 'refs' => [], ], 'DeleteTextMessageSpendLimitOverrideRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteTextMessageSpendLimitOverrideResult' => [ 'base' => NULL, 'refs' => [], ], 'DeleteVoiceMessageSpendLimitOverrideRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteVoiceMessageSpendLimitOverrideResult' => [ 'base' => NULL, 'refs' => [], ], 'DeliveryStreamArn' => [ 'base' => NULL, 'refs' => [ 'KinesisFirehoseDestination$DeliveryStreamArn' => '<p>The Amazon Resource Name (ARN) of the delivery stream.</p>', ], ], 'DescribeAccountAttributesRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAccountAttributesResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAccountLimitsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAccountLimitsResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeConfigurationSetsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeConfigurationSetsResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeKeywordsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeKeywordsResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeOptOutListsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeOptOutListsResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeOptedOutNumbersRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeOptedOutNumbersResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribePhoneNumbersRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribePhoneNumbersResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribePoolsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribePoolsResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeSenderIdsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeSenderIdsResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeSpendLimitsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeSpendLimitsResult' => [ 'base' => NULL, 'refs' => [], ], 'DestinationCountryParameterKey' => [ 'base' => NULL, 'refs' => [ 'DestinationCountryParameters$key' => NULL, ], ], 'DestinationCountryParameterValue' => [ 'base' => NULL, 'refs' => [ 'DestinationCountryParameters$value' => NULL, ], ], 'DestinationCountryParameters' => [ 'base' => NULL, 'refs' => [ 'SendTextMessageRequest$DestinationCountryParameters' => '<p>This field is used for any country-specific registration requirements. Currently, this setting is only used when you send messages to recipients in India using a sender ID. For more information see <a href="https://docs.aws.amazon.com/pinpoint/latest/userguide/channels-sms-senderid-india.html">Special requirements for sending SMS messages to recipients in India</a>. </p>', ], ], 'DisassociateOriginationIdentityRequest' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateOriginationIdentityResult' => [ 'base' => NULL, 'refs' => [], ], 'EventDestination' => [ 'base' => '<p>Contains information about an event destination.</p> <p>Event destinations are associated with configuration sets, which enable you to publish message sending events to Amazon CloudWatch, Amazon Kinesis Data Firehose, or Amazon SNS.</p>', 'refs' => [ 'CreateEventDestinationResult$EventDestination' => '<p>The details of the destination where events are logged.</p>', 'DeleteEventDestinationResult$EventDestination' => '<p>The event destination object that was deleted.</p>', 'EventDestinationList$member' => NULL, 'UpdateEventDestinationResult$EventDestination' => '<p>An EventDestination object containing the details of where events will be logged. </p>', ], ], 'EventDestinationList' => [ 'base' => NULL, 'refs' => [ 'ConfigurationSetInformation$EventDestinations' => '<p>An array of EventDestination objects that describe any events to log and where to log them.</p>', 'DeleteConfigurationSetResult$EventDestinations' => '<p>An array of any EventDestination objects that were associated with the deleted configuration set.</p>', ], ], 'EventDestinationName' => [ 'base' => NULL, 'refs' => [ 'CreateEventDestinationRequest$EventDestinationName' => '<p>The name that identifies the event destination.</p>', 'DeleteEventDestinationRequest$EventDestinationName' => '<p>The name of the event destination to delete.</p>', 'EventDestination$EventDestinationName' => '<p>The name of the EventDestination.</p>', 'UpdateEventDestinationRequest$EventDestinationName' => '<p>The name to use for the event destination.</p>', ], ], 'EventType' => [ 'base' => NULL, 'refs' => [ 'EventTypeList$member' => NULL, ], ], 'EventTypeList' => [ 'base' => NULL, 'refs' => [ 'CreateEventDestinationRequest$MatchingEventTypes' => '<p>An array of event types that determine which events to log. If "ALL" is used, then Amazon Pinpoint logs every event type.</p>', 'EventDestination$MatchingEventTypes' => '<p>An array of event types that determine which events to log.</p>', 'UpdateEventDestinationRequest$MatchingEventTypes' => '<p>An array of event types that determine which events to log.</p>', ], ], 'FilterValue' => [ 'base' => NULL, 'refs' => [ 'FilterValueList$member' => NULL, ], ], 'FilterValueList' => [ 'base' => NULL, 'refs' => [ 'ConfigurationSetFilter$Values' => '<p>An array values to filter for.</p>', 'KeywordFilter$Values' => '<p>An array values to filter for.</p>', 'OptedOutFilter$Values' => '<p>An array of values to filter for.</p>', 'PhoneNumberFilter$Values' => '<p>An array values to filter for.</p>', 'PoolFilter$Values' => '<p>An array values to filter for.</p>', 'PoolOriginationIdentitiesFilter$Values' => '<p>An array values to filter for.</p>', 'SenderIdFilter$Values' => '<p>An array of values to filter for.</p>', ], ], 'IamRoleArn' => [ 'base' => NULL, 'refs' => [ 'CloudWatchLogsDestination$IamRoleArn' => '<p>The Amazon Resource Name (ARN) of an Amazon Identity and Access Management (IAM) role that is able to write event data to an Amazon CloudWatch destination.</p>', 'KinesisFirehoseDestination$IamRoleArn' => '<p>The ARN of an Amazon Identity and Access Management (IAM) role that is able to write event data to an Amazon Firehose destination.</p>', ], ], 'InternalServerException' => [ 'base' => '<p>The API encountered an unexpected error and couldn\'t complete the request. You might be able to successfully issue the request again in the future.</p>', 'refs' => [], ], 'IsoCountryCode' => [ 'base' => NULL, 'refs' => [ 'AssociateOriginationIdentityRequest$IsoCountryCode' => '<p>The new two-character code, in ISO 3166-1 alpha-2 format, for the country or region of the origination identity.</p>', 'AssociateOriginationIdentityResult$IsoCountryCode' => '<p>The two-character code, in ISO 3166-1 alpha-2 format, for the country or region. </p>', 'CreatePoolRequest$IsoCountryCode' => '<p>The new two-character code, in ISO 3166-1 alpha-2 format, for the country or region of the new pool.</p>', 'DisassociateOriginationIdentityRequest$IsoCountryCode' => '<p>The two-character code, in ISO 3166-1 alpha-2 format, for the country or region. </p>', 'DisassociateOriginationIdentityResult$IsoCountryCode' => '<p>The two-character code, in ISO 3166-1 alpha-2 format, for the country or region.</p>', 'OriginationIdentityMetadata$IsoCountryCode' => '<p>The two-character code, in ISO 3166-1 alpha-2 format, for the country or region. </p>', 'PhoneNumberInformation$IsoCountryCode' => '<p>The two-character code, in ISO 3166-1 alpha-2 format, for the country or region. </p>', 'ReleasePhoneNumberResult$IsoCountryCode' => '<p>The two-character code, in ISO 3166-1 alpha-2 format, for the country or region.</p>', 'RequestPhoneNumberRequest$IsoCountryCode' => '<p>The two-character code, in ISO 3166-1 alpha-2 format, for the country or region. </p>', 'RequestPhoneNumberResult$IsoCountryCode' => '<p>The two-character code, in ISO 3166-1 alpha-2 format, for the country or region. </p>', 'SenderIdAndCountry$IsoCountryCode' => '<p>The two-character code, in ISO 3166-1 alpha-2 format, for the country or region. </p>', 'SenderIdInformation$IsoCountryCode' => '<p>The two-character code, in ISO 3166-1 alpha-2 format, for the country or region. </p>', 'UpdatePhoneNumberResult$IsoCountryCode' => '<p>The two-character code, in ISO 3166-1 alpha-2 format, for the country or region. </p>', ], ], 'Keyword' => [ 'base' => NULL, 'refs' => [ 'DeleteKeywordRequest$Keyword' => '<p>The keyword to delete.</p>', 'DeleteKeywordResult$Keyword' => '<p>The keyword that was deleted.</p>', 'KeywordInformation$Keyword' => '<p>The keyword as a string.</p>', 'KeywordList$member' => NULL, 'PutKeywordRequest$Keyword' => '<p>The new keyword to add.</p>', 'PutKeywordResult$Keyword' => '<p>The keyword that was added.</p>', 'SendTextMessageRequest$Keyword' => '<p>When you register a short code in the US, you must specify a program name. If you don’t have a US short code, omit this attribute.</p>', ], ], 'KeywordAction' => [ 'base' => NULL, 'refs' => [ 'DeleteKeywordResult$KeywordAction' => '<p>The action that was associated with the deleted keyword.</p>', 'KeywordInformation$KeywordAction' => '<p>The action to perform for the keyword.</p>', 'PutKeywordRequest$KeywordAction' => '<p>The action to perform for the new keyword when it is received.</p>', 'PutKeywordResult$KeywordAction' => '<p>The action to perform when the keyword is used.</p>', ], ], 'KeywordFilter' => [ 'base' => '<p>The information for keywords that meet a specified criteria.</p>', 'refs' => [ 'KeywordFilterList$member' => NULL, ], ], 'KeywordFilterList' => [ 'base' => NULL, 'refs' => [ 'DescribeKeywordsRequest$Filters' => '<p>An array of keyword filters to filter the results.</p>', ], ], 'KeywordFilterName' => [ 'base' => NULL, 'refs' => [ 'KeywordFilter$Name' => '<p>The name of the attribute to filter on.</p>', ], ], 'KeywordInformation' => [ 'base' => '<p>The information for all keywords in a pool.</p>', 'refs' => [ 'KeywordInformationList$member' => NULL, ], ], 'KeywordInformationList' => [ 'base' => NULL, 'refs' => [ 'DescribeKeywordsResult$Keywords' => '<p>An array of KeywordInformation objects that contain the results.</p>', ], ], 'KeywordList' => [ 'base' => NULL, 'refs' => [ 'DescribeKeywordsRequest$Keywords' => '<p>An array of keywords to search for.</p>', ], ], 'KeywordMessage' => [ 'base' => NULL, 'refs' => [ 'DeleteKeywordResult$KeywordMessage' => '<p>The message that was associated with the deleted keyword.</p>', 'KeywordInformation$KeywordMessage' => '<p>A custom message that can be used with the keyword.</p>', 'PutKeywordRequest$KeywordMessage' => '<p>The message associated with the keyword.</p> <ul> <li> <p>AUTOMATIC_RESPONSE: A message is sent to the recipient.</p> </li> <li> <p>OPT_OUT: Keeps the recipient from receiving future messages.</p> </li> <li> <p>OPT_IN: The recipient wants to receive future messages.</p> </li> </ul>', 'PutKeywordResult$KeywordMessage' => '<p>The message associated with the keyword.</p>', ], ], 'KinesisFirehoseDestination' => [ 'base' => '<p>Contains the delivery stream Amazon Resource Name (ARN), and the ARN of the Identity and Access Management (IAM) role associated with an Kinesis Data Firehose event destination.</p> <p>Event destinations, such as Kinesis Data Firehose, are associated with configuration sets, which enable you to publish message sending events.</p>', 'refs' => [ 'CreateEventDestinationRequest$KinesisFirehoseDestination' => '<p>An object that contains information about an event destination for logging to Amazon Kinesis Data Firehose.</p>', 'EventDestination$KinesisFirehoseDestination' => '<p>An object that contains information about an event destination for logging to Amazon Kinesis Data Firehose.</p>', 'UpdateEventDestinationRequest$KinesisFirehoseDestination' => '<p>An object that contains information about an event destination for logging to Kinesis Data Firehose.</p>', ], ], 'ListPoolOriginationIdentitiesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListPoolOriginationIdentitiesResult' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceResult' => [ 'base' => NULL, 'refs' => [], ], 'LogGroupArn' => [ 'base' => NULL, 'refs' => [ 'CloudWatchLogsDestination$LogGroupArn' => '<p>The name of the Amazon CloudWatch log group that you want to record events in. </p>', ], ], 'MaxPrice' => [ 'base' => NULL, 'refs' => [ 'SendTextMessageRequest$MaxPrice' => '<p>The maximum amount that you want to spend, in US dollars, per each text message part. A text message can contain multiple parts.</p>', 'SendVoiceMessageRequest$MaxPricePerMinute' => '<p>The maximum amount to spend per voice message, in US dollars.</p>', ], ], 'MaxResults' => [ 'base' => NULL, 'refs' => [ 'DescribeAccountAttributesRequest$MaxResults' => '<p>The maximum number of results to return per each request.</p>', 'DescribeAccountLimitsRequest$MaxResults' => '<p>The maximum number of results to return per each request.</p>', 'DescribeConfigurationSetsRequest$MaxResults' => '<p>The maximum number of results to return per each request.</p>', 'DescribeKeywordsRequest$MaxResults' => '<p>The maximum number of results to return per each request.</p>', 'DescribeOptOutListsRequest$MaxResults' => '<p>The maximum number of results to return per each request.</p>', 'DescribeOptedOutNumbersRequest$MaxResults' => '<p>The maximum number of results to return per each request.</p>', 'DescribePhoneNumbersRequest$MaxResults' => '<p>The maximum number of results to return per each request.</p>', 'DescribePoolsRequest$MaxResults' => '<p>The maximum number of results to return per each request.</p>', 'DescribeSenderIdsRequest$MaxResults' => '<p>The maximum number of results to return per each request.</p>', 'DescribeSpendLimitsRequest$MaxResults' => '<p>The maximum number of results to return per each request.</p>', 'ListPoolOriginationIdentitiesRequest$MaxResults' => '<p>The maximum number of results to return per each request.</p>', ], ], 'MessageType' => [ 'base' => NULL, 'refs' => [ 'ConfigurationSetInformation$DefaultMessageType' => '<p>The type of message. Valid values are TRANSACTIONAL for messages that are critical or time-sensitive and PROMOTIONAL for messages that aren\'t critical or time-sensitive.</p>', 'CreatePoolRequest$MessageType' => '<p>The type of message. Valid values are TRANSACTIONAL for messages that are critical or time-sensitive and PROMOTIONAL for messages that aren\'t critical or time-sensitive.</p>', 'CreatePoolResult$MessageType' => '<p>The type of message for the pool to use.</p>', 'DeleteConfigurationSetResult$DefaultMessageType' => '<p>The default message type of the configuration set that was deleted.</p>', 'DeleteDefaultMessageTypeResult$MessageType' => '<p>The current message type for the configuration set.</p>', 'DeletePoolResult$MessageType' => '<p>The message type that was associated with the deleted pool.</p>', 'MessageTypeList$member' => NULL, 'PhoneNumberInformation$MessageType' => '<p>The type of message. Valid values are TRANSACTIONAL for messages that are critical or time-sensitive and PROMOTIONAL for messages that aren\'t critical or time-sensitive.</p>', 'PoolInformation$MessageType' => '<p>The type of message. Valid values are TRANSACTIONAL for messages that are critical or time-sensitive and PROMOTIONAL for messages that aren\'t critical or time-sensitive.</p>', 'ReleasePhoneNumberResult$MessageType' => '<p>The message type that was associated with the phone number.</p>', 'RequestPhoneNumberRequest$MessageType' => '<p>The type of message. Valid values are TRANSACTIONAL for messages that are critical or time-sensitive and PROMOTIONAL for messages that aren\'t critical or time-sensitive.</p>', 'RequestPhoneNumberResult$MessageType' => '<p>The type of message. Valid values are TRANSACTIONAL for messages that are critical or time-sensitive and PROMOTIONAL for messages that aren\'t critical or time-sensitive.</p>', 'SendTextMessageRequest$MessageType' => '<p>The type of message. Valid values are TRANSACTIONAL for messages that are critical or time-sensitive and PROMOTIONAL for messages that aren\'t critical or time-sensitive.</p>', 'SetDefaultMessageTypeRequest$MessageType' => '<p>The type of message. Valid values are TRANSACTIONAL for messages that are critical or time-sensitive and PROMOTIONAL for messages that aren\'t critical or time-sensitive.</p>', 'SetDefaultMessageTypeResult$MessageType' => '<p>The new default message type of the configuration set.</p>', 'UpdatePhoneNumberResult$MessageType' => '<p>The type of message. Valid values are TRANSACTIONAL for messages that are critical or time-sensitive and PROMOTIONAL for messages that aren\'t critical or time-sensitive.</p>', 'UpdatePoolResult$MessageType' => '<p>The type of message for the pool to use.</p>', ], ], 'MessageTypeList' => [ 'base' => NULL, 'refs' => [ 'SenderIdInformation$MessageTypes' => '<p>The type of message. Valid values are TRANSACTIONAL for messages that are critical or time-sensitive and PROMOTIONAL for messages that aren\'t critical or time-sensitive.</p>', ], ], 'MonthlyLimit' => [ 'base' => NULL, 'refs' => [ 'DeleteTextMessageSpendLimitOverrideResult$MonthlyLimit' => '<p>The current monthly limit, in US dollars.</p>', 'DeleteVoiceMessageSpendLimitOverrideResult$MonthlyLimit' => '<p>The current monthly limit, in US dollars.</p>', 'SetTextMessageSpendLimitOverrideRequest$MonthlyLimit' => '<p>The new monthly limit to enforce on text messages.</p>', 'SetTextMessageSpendLimitOverrideResult$MonthlyLimit' => '<p>The current monthly limit to enforce on sending text messages.</p>', 'SetVoiceMessageSpendLimitOverrideRequest$MonthlyLimit' => '<p>The new monthly limit to enforce on voice messages.</p>', 'SetVoiceMessageSpendLimitOverrideResult$MonthlyLimit' => '<p>The current monthly limit to enforce on sending voice messages.</p>', ], ], 'NextToken' => [ 'base' => NULL, 'refs' => [ 'DescribeAccountAttributesRequest$NextToken' => '<p>The token to be used for the next set of paginated results. You don\'t need to supply a value for this field in the initial request.</p>', 'DescribeAccountAttributesResult$NextToken' => '<p>The token to be used for the next set of paginated results. If this field is empty then there are no more results.</p>', 'DescribeAccountLimitsRequest$NextToken' => '<p>The token to be used for the next set of paginated results. You don\'t need to supply a value for this field in the initial request.</p>', 'DescribeAccountLimitsResult$NextToken' => '<p>The token to be used for the next set of paginated results. If this field is empty then there are no more results.</p>', 'DescribeConfigurationSetsRequest$NextToken' => '<p>The token to be used for the next set of paginated results. You don\'t need to supply a value for this field in the initial request.</p>', 'DescribeConfigurationSetsResult$NextToken' => '<p>The token to be used for the next set of paginated results. If this field is empty then there are no more results.</p>', 'DescribeKeywordsRequest$NextToken' => '<p>The token to be used for the next set of paginated results. You don\'t need to supply a value for this field in the initial request.</p>', 'DescribeKeywordsResult$NextToken' => '<p>The token to be used for the next set of paginated results. If this field is empty then there are no more results.</p>', 'DescribeOptOutListsRequest$NextToken' => '<p>The token to be used for the next set of paginated results. You don\'t need to supply a value for this field in the initial request.</p>', 'DescribeOptOutListsResult$NextToken' => '<p>The token to be used for the next set of paginated results. If this field is empty then there are no more results.</p>', 'DescribeOptedOutNumbersRequest$NextToken' => '<p>The token to be used for the next set of paginated results. You don\'t need to supply a value for this field in the initial request.</p>', 'DescribeOptedOutNumbersResult$NextToken' => '<p>The token to be used for the next set of paginated results. If this field is empty then there are no more results.</p>', 'DescribePhoneNumbersRequest$NextToken' => '<p>The token to be used for the next set of paginated results. You don\'t need to supply a value for this field in the initial request.</p>', 'DescribePhoneNumbersResult$NextToken' => '<p>The token to be used for the next set of paginated results. If this field is empty then there are no more results.</p>', 'DescribePoolsRequest$NextToken' => '<p>The token to be used for the next set of paginated results. You don\'t need to supply a value for this field in the initial request.</p>', 'DescribePoolsResult$NextToken' => '<p>The token to be used for the next set of paginated results. If this field is empty then there are no more results.</p>', 'DescribeSenderIdsRequest$NextToken' => '<p>The token to be used for the next set of paginated results. You don\'t need to supply a value for this field in the initial request.</p>', 'DescribeSenderIdsResult$NextToken' => '<p>The token to be used for the next set of paginated results. If this field is empty then there are no more results.</p>', 'DescribeSpendLimitsRequest$NextToken' => '<p>The token to be used for the next set of paginated results. You don\'t need to supply a value for this field in the initial request.</p>', 'DescribeSpendLimitsResult$NextToken' => '<p>The token to be used for the next set of paginated results. If this field is empty then there are no more results.</p>', 'ListPoolOriginationIdentitiesRequest$NextToken' => '<p>The token to be used for the next set of paginated results. You don\'t need to supply a value for this field in the initial request.</p>', 'ListPoolOriginationIdentitiesResult$NextToken' => '<p>The token to be used for the next set of paginated results. If this field is empty then there are no more results.</p>', ], ], 'NonEmptyTagList' => [ 'base' => NULL, 'refs' => [ 'TagResourceRequest$Tags' => '<p>An array of key and value pair tags that are associated with the resource.</p>', ], ], 'NumberCapability' => [ 'base' => NULL, 'refs' => [ 'NumberCapabilityList$member' => NULL, ], ], 'NumberCapabilityList' => [ 'base' => NULL, 'refs' => [ 'OriginationIdentityMetadata$NumberCapabilities' => '<p>Describes if the origination identity can be used for text messages, voice calls or both.</p>', 'PhoneNumberInformation$NumberCapabilities' => '<p>Describes if the origination identity can be used for text messages, voice calls or both.</p>', 'ReleasePhoneNumberResult$NumberCapabilities' => '<p>Specifies if the number could be used for text messages, voice, or both.</p>', 'RequestPhoneNumberRequest$NumberCapabilities' => '<p>Indicates if the phone number will be used for text messages, voice messages, or both. </p>', 'RequestPhoneNumberResult$NumberCapabilities' => '<p>Indicates if the phone number will be used for text messages, voice messages or both. </p>', 'UpdatePhoneNumberResult$NumberCapabilities' => '<p>Specifies if the number could be used for text messages, voice or both.</p>', ], ], 'NumberStatus' => [ 'base' => NULL, 'refs' => [ 'PhoneNumberInformation$Status' => '<p>The current status of the phone number.</p>', 'ReleasePhoneNumberResult$Status' => '<p>The current status of the request.</p>', 'RequestPhoneNumberResult$Status' => '<p>The current status of the request.</p>', 'UpdatePhoneNumberResult$Status' => '<p>The current status of the request.</p>', ], ], 'NumberType' => [ 'base' => NULL, 'refs' => [ 'PhoneNumberInformation$NumberType' => '<p>The type of phone number.</p>', 'ReleasePhoneNumberResult$NumberType' => '<p>The type of number that was released.</p>', 'UpdatePhoneNumberResult$NumberType' => '<p>The type of number that was requested.</p>', ], ], 'OptOutListInformation' => [ 'base' => '<p>The information for all OptOutList in an Amazon Web Services account.</p>', 'refs' => [ 'OptOutListInformationList$member' => NULL, ], ], 'OptOutListInformationList' => [ 'base' => NULL, 'refs' => [ 'DescribeOptOutListsResult$OptOutLists' => '<p>An array of OptOutListInformation objects that contain the details for the requested OptOutLists.</p>', ], ], 'OptOutListName' => [ 'base' => NULL, 'refs' => [ 'CreateOptOutListRequest$OptOutListName' => '<p>The name of the new OptOutList.</p>', 'CreateOptOutListResult$OptOutListName' => '<p>The name of the new OptOutList.</p>', 'CreatePoolResult$OptOutListName' => '<p>The name of the OptOutList associated with the pool.</p>', 'DeleteOptOutListResult$OptOutListName' => '<p>The name of the OptOutList that was removed.</p>', 'DeleteOptedOutNumberResult$OptOutListName' => '<p>The OptOutListName that the phone number was removed from.</p>', 'DeletePoolResult$OptOutListName' => '<p>The name of the OptOutList that was associated with the deleted pool.</p>', 'DescribeOptedOutNumbersResult$OptOutListName' => '<p>The name of the OptOutList.</p>', 'OptOutListInformation$OptOutListName' => '<p>The name of the OptOutList.</p>', 'PhoneNumberInformation$OptOutListName' => '<p>The name of the OptOutList associated with the phone number.</p>', 'PoolInformation$OptOutListName' => '<p>The name of the OptOutList associated with the pool.</p>', 'PutOptedOutNumberResult$OptOutListName' => '<p>The OptOutListName that the phone number was removed from.</p>', 'ReleasePhoneNumberResult$OptOutListName' => '<p>The name of the OptOutList that was associated with the phone number.</p>', 'RequestPhoneNumberResult$OptOutListName' => '<p>The name of the OptOutList that is associated with the requested phone number.</p>', 'UpdatePhoneNumberResult$OptOutListName' => '<p>The name of the OptOutList associated with the phone number.</p>', 'UpdatePoolResult$OptOutListName' => '<p>The name of the OptOutList associated with the pool.</p>', ], ], 'OptOutListNameList' => [ 'base' => NULL, 'refs' => [ 'DescribeOptOutListsRequest$OptOutListNames' => '<p>The OptOutLists to show the details of. This is an array of strings that can be either the OptOutListName or OptOutListArn.</p>', ], ], 'OptOutListNameOrArn' => [ 'base' => NULL, 'refs' => [ 'DeleteOptOutListRequest$OptOutListName' => '<p>The OptOutListName or OptOutListArn of the OptOutList to delete. You can use <a>DescribeOptOutLists</a> to find the values for OptOutListName and OptOutListArn.</p>', 'DeleteOptedOutNumberRequest$OptOutListName' => '<p>The OptOutListName or OptOutListArn to remove the phone number from.</p>', 'DescribeOptedOutNumbersRequest$OptOutListName' => '<p>The OptOutListName or OptOutListArn of the OptOutList. You can use <a>DescribeOptOutLists</a> to find the values for OptOutListName and OptOutListArn.</p>', 'OptOutListNameList$member' => NULL, 'PutOptedOutNumberRequest$OptOutListName' => '<p>The OptOutListName or OptOutListArn to add the phone number to.</p>', 'RequestPhoneNumberRequest$OptOutListName' => '<p>The name of the OptOutList to associate with the phone number. You can use the OutOutListName or OptPutListArn.</p>', 'UpdatePhoneNumberRequest$OptOutListName' => '<p>The OptOutList to add the phone number to. Valid values for this field can be either the OutOutListName or OutOutListArn.</p>', 'UpdatePoolRequest$OptOutListName' => '<p>The OptOutList to associate with the pool. Valid values are either OptOutListName or OptOutListArn.</p>', ], ], 'OptedOutFilter' => [ 'base' => '<p>The information for opted out numbers that meet a specified criteria.</p>', 'refs' => [ 'OptedOutFilterList$member' => NULL, ], ], 'OptedOutFilterList' => [ 'base' => NULL, 'refs' => [ 'DescribeOptedOutNumbersRequest$Filters' => '<p>An array of OptedOutFilter objects to filter the results on.</p>', ], ], 'OptedOutFilterName' => [ 'base' => NULL, 'refs' => [ 'OptedOutFilter$Name' => '<p>The name of the attribute to filter on.</p>', ], ], 'OptedOutNumberInformation' => [ 'base' => '<p>The information for an opted out number in an Amazon Web Services account.</p>', 'refs' => [ 'OptedOutNumberInformationList$member' => NULL, ], ], 'OptedOutNumberInformationList' => [ 'base' => NULL, 'refs' => [ 'DescribeOptedOutNumbersResult$OptedOutNumbers' => '<p>An array of OptedOutNumbersInformation objects that provide information about the requested OptedOutNumbers.</p>', ], ], 'OptedOutNumberList' => [ 'base' => NULL, 'refs' => [ 'DescribeOptedOutNumbersRequest$OptedOutNumbers' => '<p>An array of phone numbers to search for in the OptOutList.</p>', ], ], 'OriginationIdentityMetadata' => [ 'base' => '<p>The metadata for an origination identity associated with a pool.</p>', 'refs' => [ 'OriginationIdentityMetadataList$member' => NULL, ], ], 'OriginationIdentityMetadataList' => [ 'base' => NULL, 'refs' => [ 'ListPoolOriginationIdentitiesResult$OriginationIdentities' => '<p>An array of any OriginationIdentityMetadata objects.</p>', ], ], 'PhoneNumber' => [ 'base' => NULL, 'refs' => [ 'DeleteOptedOutNumberRequest$OptedOutNumber' => '<p>The phone number, in E.164 format, to remove from the OptOutList.</p>', 'DeleteOptedOutNumberResult$OptedOutNumber' => '<p>The phone number that was removed from the OptOutList.</p>', 'OptedOutNumberInformation$OptedOutNumber' => '<p>The phone number that is opted out.</p>', 'OptedOutNumberList$member' => NULL, 'PhoneNumberInformation$PhoneNumber' => '<p>The phone number in E.164 format.</p>', 'PutOptedOutNumberRequest$OptedOutNumber' => '<p>The phone number to add to the OptOutList in E.164 format.</p>', 'PutOptedOutNumberResult$OptedOutNumber' => '<p>The phone number that was added to the OptOutList.</p>', 'ReleasePhoneNumberResult$PhoneNumber' => '<p>The phone number that was released.</p>', 'RequestPhoneNumberResult$PhoneNumber' => '<p>The new phone number that was requested.</p>', 'SendTextMessageRequest$DestinationPhoneNumber' => '<p>The destination phone number in E.164 format.</p>', 'SendVoiceMessageRequest$DestinationPhoneNumber' => '<p>The destination phone number in E.164 format.</p>', 'UpdatePhoneNumberResult$PhoneNumber' => '<p>The phone number that was updated.</p>', ], ], 'PhoneNumberFilter' => [ 'base' => '<p>The information for a phone number that meets a specified criteria.</p>', 'refs' => [ 'PhoneNumberFilterList$member' => NULL, ], ], 'PhoneNumberFilterList' => [ 'base' => NULL, 'refs' => [ 'DescribePhoneNumbersRequest$Filters' => '<p>An array of PhoneNumberFilter objects to filter the results.</p>', ], ], 'PhoneNumberFilterName' => [ 'base' => NULL, 'refs' => [ 'PhoneNumberFilter$Name' => '<p>The name of the attribute to filter on.</p>', ], ], 'PhoneNumberIdList' => [ 'base' => NULL, 'refs' => [ 'DescribePhoneNumbersRequest$PhoneNumberIds' => '<p>The unique identifier of phone numbers to find information about. This is an array of strings that can be either the PhoneNumberId or PhoneNumberArn.</p>', ], ], 'PhoneNumberIdOrArn' => [ 'base' => NULL, 'refs' => [ 'PhoneNumberIdList$member' => NULL, 'ReleasePhoneNumberRequest$PhoneNumberId' => '<p>The PhoneNumberId or PhoneNumberArn of the phone number to release. You can use <a>DescribePhoneNumbers</a> to get the values for PhoneNumberId and PhoneNumberArn.</p>', 'UpdatePhoneNumberRequest$PhoneNumberId' => '<p>The unique identifier of the phone number. Valid values for this field can be either the PhoneNumberId or PhoneNumberArn.</p>', ], ], 'PhoneNumberInformation' => [ 'base' => '<p>The information for a phone number in an Amazon Web Services account.</p>', 'refs' => [ 'PhoneNumberInformationList$member' => NULL, ], ], 'PhoneNumberInformationList' => [ 'base' => NULL, 'refs' => [ 'DescribePhoneNumbersResult$PhoneNumbers' => '<p>An array of PhoneNumberInformation objects that contain the details for the requested phone numbers.</p>', ], ], 'PhoneOrPoolIdOrArn' => [ 'base' => NULL, 'refs' => [ 'DeleteKeywordRequest$OriginationIdentity' => '<p>The origination identity to use such as a PhoneNumberId, PhoneNumberArn, PoolId or PoolArn. You can use <a>DescribePhoneNumbers</a> to find the values for PhoneNumberId and PhoneNumberArn and <a>DescribePools</a> to find the values of PoolId and PoolArn.</p>', 'DescribeKeywordsRequest$OriginationIdentity' => '<p>The origination identity to use such as a PhoneNumberId, PhoneNumberArn, SenderId or SenderIdArn. You can use <a>DescribePhoneNumbers</a> to find the values for PhoneNumberId and PhoneNumberArn while <a>DescribeSenderIds</a> can be used to get the values for SenderId and SenderIdArn.</p>', 'PutKeywordRequest$OriginationIdentity' => '<p>The origination identity to use such as a PhoneNumberId, PhoneNumberArn, SenderId or SenderIdArn. You can use <a>DescribePhoneNumbers</a> get the values for PhoneNumberId and PhoneNumberArn while <a>DescribeSenderIds</a> can be used to get the values for SenderId and SenderIdArn.</p>', ], ], 'PhoneOrSenderIdOrArn' => [ 'base' => NULL, 'refs' => [ 'AssociateOriginationIdentityRequest$OriginationIdentity' => '<p>The origination identity to use, such as PhoneNumberId, PhoneNumberArn, SenderId, or SenderIdArn. You can use <a>DescribePhoneNumbers</a> to find the values for PhoneNumberId and PhoneNumberArn, while <a>DescribeSenderIds</a> can be used to get the values for SenderId and SenderIdArn.</p>', 'CreatePoolRequest$OriginationIdentity' => '<p>The origination identity to use such as a PhoneNumberId, PhoneNumberArn, SenderId or SenderIdArn. You can use <a>DescribePhoneNumbers</a> to find the values for PhoneNumberId and PhoneNumberArn while <a>DescribeSenderIds</a> can be used to get the values for SenderId and SenderIdArn.</p>', 'DisassociateOriginationIdentityRequest$OriginationIdentity' => '<p>The origination identity to use such as a PhoneNumberId, PhoneNumberArn, SenderId or SenderIdArn. You can use <a>DescribePhoneNumbers</a> find the values for PhoneNumberId and PhoneNumberArn, or use <a>DescribeSenderIds</a> to get the values for SenderId and SenderIdArn.</p>', ], ], 'PoolFilter' => [ 'base' => '<p>The information for a pool that meets a specified criteria.</p>', 'refs' => [ 'PoolFilterList$member' => NULL, ], ], 'PoolFilterList' => [ 'base' => NULL, 'refs' => [ 'DescribePoolsRequest$Filters' => '<p>An array of PoolFilter objects to filter the results.</p>', ], ], 'PoolFilterName' => [ 'base' => NULL, 'refs' => [ 'PoolFilter$Name' => '<p>The name of the attribute to filter on.</p>', ], ], 'PoolIdList' => [ 'base' => NULL, 'refs' => [ 'DescribePoolsRequest$PoolIds' => '<p>The unique identifier of pools to find. This is an array of strings that can be either the PoolId or PoolArn.</p>', ], ], 'PoolIdOrArn' => [ 'base' => NULL, 'refs' => [ 'AssociateOriginationIdentityRequest$PoolId' => '<p>The pool to update with the new Identity. This value can be either the PoolId or PoolArn, and you can find these values using <a>DescribePools</a>.</p>', 'DeletePoolRequest$PoolId' => '<p>The PoolId or PoolArn of the pool to delete. You can use <a>DescribePools</a> to find the values for PoolId and PoolArn .</p>', 'DisassociateOriginationIdentityRequest$PoolId' => '<p>The unique identifier for the pool to disassociate with the origination identity. This value can be either the PoolId or PoolArn.</p>', 'ListPoolOriginationIdentitiesRequest$PoolId' => '<p>The unique identifier for the pool. This value can be either the PoolId or PoolArn.</p>', 'PoolIdList$member' => NULL, 'RequestPhoneNumberRequest$PoolId' => '<p>The pool to associated with the phone number. You can use the PoolId or PoolArn. </p>', 'UpdatePoolRequest$PoolId' => '<p>The unique identifier of the pool to update. Valid values are either the PoolId or PoolArn.</p>', ], ], 'PoolInformation' => [ 'base' => '<p>The information for a pool in an Amazon Web Services account.</p>', 'refs' => [ 'PoolInformationList$member' => NULL, ], ], 'PoolInformationList' => [ 'base' => NULL, 'refs' => [ 'DescribePoolsResult$Pools' => '<p>An array of PoolInformation objects that contain the details for the requested pools. </p>', ], ], 'PoolOriginationIdentitiesFilter' => [ 'base' => '<p>Information about origination identities associated with a pool that meets a specified criteria.</p>', 'refs' => [ 'PoolOriginationIdentitiesFilterList$member' => NULL, ], ], 'PoolOriginationIdentitiesFilterList' => [ 'base' => NULL, 'refs' => [ 'ListPoolOriginationIdentitiesRequest$Filters' => '<p>An array of PoolOriginationIdentitiesFilter objects to filter the results..</p>', ], ], 'PoolOriginationIdentitiesFilterName' => [ 'base' => NULL, 'refs' => [ 'PoolOriginationIdentitiesFilter$Name' => '<p>The name of the attribute to filter on.</p>', ], ], 'PoolStatus' => [ 'base' => NULL, 'refs' => [ 'CreatePoolResult$Status' => '<p>The current status of the pool.</p> <ul> <li> <p>CREATING: The pool is currently being created and isn\'t yet available for use.</p> </li> <li> <p>ACTIVE: The pool is active and available for use.</p> </li> <li> <p>DELETING: The pool is being deleted.</p> </li> </ul>', 'DeletePoolResult$Status' => '<p>The current status of the pool.</p> <ul> <li> <p>CREATING: The pool is currently being created and isn\'t yet available for use.</p> </li> <li> <p>ACTIVE: The pool is active and available for use.</p> </li> <li> <p>DELETING: The pool is being deleted.</p> </li> </ul>', 'PoolInformation$Status' => '<p>The current status of the pool.</p>', 'UpdatePoolResult$Status' => '<p>The current status of the pool update request.</p>', ], ], 'PrimitiveBoolean' => [ 'base' => NULL, 'refs' => [ 'CreatePoolResult$TwoWayEnabled' => '<p>By default this is set to false. When set to true you can receive incoming text messages from your end recipients.</p>', 'CreatePoolResult$SelfManagedOptOutsEnabled' => '<p>By default this is set to false. When an end recipient sends a message that begins with HELP or STOP to one of your dedicated numbers, Amazon Pinpoint automatically replies with a customizable message and adds the end recipient to the OptOutList. When set to true you\'re responsible for responding to HELP and STOP requests. You\'re also responsible for tracking and honoring opt-out requests.</p>', 'CreatePoolResult$SharedRoutesEnabled' => '<p>Indicates whether shared routes are enabled for the pool.</p>', 'CreatePoolResult$DeletionProtectionEnabled' => '<p>When set to true deletion protection is enabled. By default this is set to false. </p>', 'DeleteOptedOutNumberResult$EndUserOptedOut' => '<p>This is true if it was the end user who requested their phone number be removed. </p>', 'DeletePoolResult$TwoWayEnabled' => '<p>By default this is set to false. When set to true you can receive incoming text messages from your end recipients.</p>', 'DeletePoolResult$SelfManagedOptOutsEnabled' => '<p>By default this is set to false. When an end recipient sends a message that begins with HELP or STOP to one of your dedicated numbers, Amazon Pinpoint automatically replies with a customizable message and adds the end recipient to the OptOutList. When set to true you\'re responsible for responding to HELP and STOP requests. You\'re also responsible for tracking and honoring opt-out requests.</p>', 'DeletePoolResult$SharedRoutesEnabled' => '<p>Indicates whether shared routes are enabled for the pool.</p>', 'OptedOutNumberInformation$EndUserOptedOut' => '<p>This is set to true if it was the end recipient that opted out.</p>', 'PhoneNumberInformation$TwoWayEnabled' => '<p>By default this is set to false. When set to true you can receive incoming text messages from your end recipients using the TwoWayChannelArn.</p>', 'PhoneNumberInformation$SelfManagedOptOutsEnabled' => '<p>When set to false an end recipient sends a message that begins with HELP or STOP to one of your dedicated numbers, Amazon Pinpoint automatically replies with a customizable message and adds the end recipient to the OptOutList. When set to true you\'re responsible for responding to HELP and STOP requests. You\'re also responsible for tracking and honoring opt-out request. For more information see <a href="https://docs.aws.amazon.com/pinpoint/latest/userguide/settings-sms-managing.html#settings-account-sms-self-managed-opt-out">Self-managed opt-outs</a> </p>', 'PhoneNumberInformation$DeletionProtectionEnabled' => '<p>When set to true the phone number can\'t be deleted.</p>', 'PoolInformation$TwoWayEnabled' => '<p>When set to true you can receive incoming text messages from your end recipients using the TwoWayChannelArn.</p>', 'PoolInformation$SelfManagedOptOutsEnabled' => '<p>When set to false, an end recipient sends a message that begins with HELP or STOP to one of your dedicated numbers, Amazon Pinpoint automatically replies with a customizable message and adds the end recipient to the OptOutList. When set to true you\'re responsible for responding to HELP and STOP requests. You\'re also responsible for tracking and honoring opt-out requests. For more information see <a href="https://docs.aws.amazon.com/pinpoint/latest/userguide/settings-sms-managing.html#settings-account-sms-self-managed-opt-out">Self-managed opt-outs</a> </p>', 'PoolInformation$SharedRoutesEnabled' => '<p>Allows you to enable shared routes on your pool.</p> <p>By default, this is set to <code>False</code>. If you set this value to <code>True</code>, your messages are sent using phone numbers or sender IDs (depending on the country) that are shared with other Amazon Pinpoint users. In some countries, such as the United States, senders aren\'t allowed to use shared routes and must use a dedicated phone number or short code.</p>', 'PoolInformation$DeletionProtectionEnabled' => '<p>When set to true the pool can\'t be deleted.</p>', 'PutOptedOutNumberResult$EndUserOptedOut' => '<p>This is true if it was the end user who requested their phone number be removed. </p>', 'ReleasePhoneNumberResult$TwoWayEnabled' => '<p>By default this is set to false. When set to true you can receive incoming text messages from your end recipients.</p>', 'ReleasePhoneNumberResult$SelfManagedOptOutsEnabled' => '<p>By default this is set to false. When an end recipient sends a message that begins with HELP or STOP to one of your dedicated numbers, Amazon Pinpoint automatically replies with a customizable message and adds the end recipient to the OptOutList. When set to true you\'re responsible for responding to HELP and STOP requests. You\'re also responsible for tracking and honoring opt-out requests.</p>', 'RequestPhoneNumberResult$TwoWayEnabled' => '<p>By default this is set to false. When set to true you can receive incoming text messages from your end recipients.</p>', 'RequestPhoneNumberResult$SelfManagedOptOutsEnabled' => '<p>By default this is set to false. When an end recipient sends a message that begins with HELP or STOP to one of your dedicated numbers, Amazon Pinpoint automatically replies with a customizable message and adds the end recipient to the OptOutList. When set to true you\'re responsible for responding to HELP and STOP requests. You\'re also responsible for tracking and honoring opt-out requests.</p>', 'RequestPhoneNumberResult$DeletionProtectionEnabled' => '<p>By default this is set to false. When set to true the phone number can\'t be deleted. </p>', 'SendTextMessageRequest$DryRun' => '<p>When set to true, the message is checked and validated, but isn\'t sent to the end recipient.</p>', 'SendVoiceMessageRequest$DryRun' => '<p>When set to true, the message is checked and validated, but isn\'t sent to the end recipient.</p>', 'SpendLimit$Overridden' => '<p>When set to <code>True</code>, the value that has been specified in the <code>EnforcedLimit</code> is used to determine the maximum amount in US dollars that can be spent to send messages each month, in US dollars.</p>', 'UpdatePhoneNumberResult$TwoWayEnabled' => '<p>By default this is set to false. When set to true you can receive incoming text messages from your end recipients.</p>', 'UpdatePhoneNumberResult$SelfManagedOptOutsEnabled' => '<p>This is true if self managed opt-out are enabled.</p>', 'UpdatePhoneNumberResult$DeletionProtectionEnabled' => '<p>When set to true the phone number can\'t be deleted.</p>', 'UpdatePoolResult$TwoWayEnabled' => '<p>By default this is set to false. When set to true you can receive incoming text messages from your end recipients.</p>', 'UpdatePoolResult$SelfManagedOptOutsEnabled' => '<p>When an end recipient sends a message that begins with HELP or STOP to one of your dedicated numbers, Amazon Pinpoint automatically replies with a customizable message and adds the end recipient to the OptOutList. When set to true you\'re responsible for responding to HELP and STOP requests. You\'re also responsible for tracking and honoring opt-out requests.</p>', 'UpdatePoolResult$SharedRoutesEnabled' => '<p>Indicates whether shared routes are enabled for the pool.</p>', 'UpdatePoolResult$DeletionProtectionEnabled' => '<p>When set to true the pool can\'t be deleted.</p>', ], ], 'PrimitiveLong' => [ 'base' => NULL, 'refs' => [ 'AccountLimit$Used' => '<p>The current amount that has been spent, in US dollars.</p>', 'AccountLimit$Max' => '<p>The Amazon Web Services set limit for that resource type, in US dollars.</p>', 'SpendLimit$EnforcedLimit' => '<p>The maximum amount of money, in US dollars, that you want to be able to spend sending messages each month. This value has to be less than or equal to the amount in <code>MaxLimit</code>. To use this custom limit, <code>Overridden</code> must be set to true.</p>', 'SpendLimit$MaxLimit' => '<p> The maximum amount of money that you are able to spend to send messages each month, in US dollars.</p>', ], ], 'PutKeywordRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutKeywordResult' => [ 'base' => NULL, 'refs' => [], ], 'PutOptedOutNumberRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutOptedOutNumberResult' => [ 'base' => NULL, 'refs' => [], ], 'RegistrationId' => [ 'base' => NULL, 'refs' => [ 'RequestPhoneNumberRequest$RegistrationId' => '<p>Use this field to attach your phone number for an external registration process.</p>', ], ], 'ReleasePhoneNumberRequest' => [ 'base' => NULL, 'refs' => [], ], 'ReleasePhoneNumberResult' => [ 'base' => NULL, 'refs' => [], ], 'RequestPhoneNumberRequest' => [ 'base' => NULL, 'refs' => [], ], 'RequestPhoneNumberResult' => [ 'base' => NULL, 'refs' => [], ], 'RequestableNumberType' => [ 'base' => NULL, 'refs' => [ 'RequestPhoneNumberRequest$NumberType' => '<p>The type of phone number to request.</p>', 'RequestPhoneNumberResult$NumberType' => '<p>The type of number that was released.</p>', ], ], 'ResourceNotFoundException' => [ 'base' => '<p>A requested resource couldn\'t be found.</p>', 'refs' => [], ], 'ResourceType' => [ 'base' => NULL, 'refs' => [ 'ConflictException$ResourceType' => '<p>The type of resource that caused the exception.</p>', 'ResourceNotFoundException$ResourceType' => '<p>The type of resource that caused the exception.</p>', ], ], 'SendTextMessageRequest' => [ 'base' => NULL, 'refs' => [], ], 'SendTextMessageResult' => [ 'base' => NULL, 'refs' => [], ], 'SendVoiceMessageRequest' => [ 'base' => NULL, 'refs' => [], ], 'SendVoiceMessageResult' => [ 'base' => NULL, 'refs' => [], ], 'SenderId' => [ 'base' => NULL, 'refs' => [ 'ConfigurationSetInformation$DefaultSenderId' => '<p>The default sender ID used by the ConfigurationSet.</p>', 'DeleteConfigurationSetResult$DefaultSenderId' => '<p>The default Sender ID of the configuration set that was deleted.</p>', 'DeleteDefaultSenderIdResult$SenderId' => '<p>The current sender ID for the configuration set.</p>', 'SenderIdInformation$SenderId' => '<p>The alphanumeric sender ID in a specific country that you\'d like to describe.</p>', 'SetDefaultSenderIdRequest$SenderId' => '<p>The current sender ID for the configuration set. When sending a text message to a destination country which supports SenderIds, the default sender ID on the configuration set specified on <a>SendTextMessage</a> will be used if no dedicated origination phone numbers or registered SenderIds are available in your account, instead of a generic sender ID, such as \'NOTICE\'.</p>', 'SetDefaultSenderIdResult$SenderId' => '<p>The default sender ID to set for the ConfigurationSet.</p>', ], ], 'SenderIdAndCountry' => [ 'base' => '<p> The alphanumeric sender ID in a specific country that you want to describe. For more information on sender IDs see <a href="https://docs.aws.amazon.com/pinpoint/latest/userguide/channels-sms-awssupport-sender-id.html">Requesting sender IDs for SMS messaging with Amazon Pinpoint </a> in the <i>Amazon Pinpoint User Guide</i>.</p>', 'refs' => [ 'SenderIdList$member' => NULL, ], ], 'SenderIdFilter' => [ 'base' => '<p>The information for a sender ID that meets a specified criteria.</p>', 'refs' => [ 'SenderIdFilterList$member' => NULL, ], ], 'SenderIdFilterList' => [ 'base' => NULL, 'refs' => [ 'DescribeSenderIdsRequest$Filters' => '<p>An array of SenderIdFilter objects to filter the results.</p>', ], ], 'SenderIdFilterName' => [ 'base' => NULL, 'refs' => [ 'SenderIdFilter$Name' => '<p>The name of the attribute to filter on.</p>', ], ], 'SenderIdInformation' => [ 'base' => '<p>The information for all SenderIds in an Amazon Web Services account.</p>', 'refs' => [ 'SenderIdInformationList$member' => NULL, ], ], 'SenderIdInformationList' => [ 'base' => NULL, 'refs' => [ 'DescribeSenderIdsResult$SenderIds' => '<p>An array of SernderIdInformation objects that contain the details for the requested SenderIds.</p>', ], ], 'SenderIdList' => [ 'base' => NULL, 'refs' => [ 'DescribeSenderIdsRequest$SenderIds' => '<p>An array of SenderIdAndCountry objects to search for.</p>', ], ], 'SenderIdOrArn' => [ 'base' => NULL, 'refs' => [ 'SenderIdAndCountry$SenderId' => '<p>The unique identifier of the sender.</p>', ], ], 'ServiceQuotaExceededException' => [ 'base' => '<p>The request would cause a service quota to be exceeded.</p>', 'refs' => [], ], 'ServiceQuotaExceededExceptionReason' => [ 'base' => NULL, 'refs' => [ 'ServiceQuotaExceededException$Reason' => '<p>The reason for the exception.</p>', ], ], 'SetDefaultMessageTypeRequest' => [ 'base' => NULL, 'refs' => [], ], 'SetDefaultMessageTypeResult' => [ 'base' => NULL, 'refs' => [], ], 'SetDefaultSenderIdRequest' => [ 'base' => NULL, 'refs' => [], ], 'SetDefaultSenderIdResult' => [ 'base' => NULL, 'refs' => [], ], 'SetTextMessageSpendLimitOverrideRequest' => [ 'base' => NULL, 'refs' => [], ], 'SetTextMessageSpendLimitOverrideResult' => [ 'base' => NULL, 'refs' => [], ], 'SetVoiceMessageSpendLimitOverrideRequest' => [ 'base' => NULL, 'refs' => [], ], 'SetVoiceMessageSpendLimitOverrideResult' => [ 'base' => NULL, 'refs' => [], ], 'SnsDestination' => [ 'base' => '<p>An object that defines an Amazon SNS destination for events. You can use Amazon SNS to send notification when certain events occur.</p>', 'refs' => [ 'CreateEventDestinationRequest$SnsDestination' => '<p>An object that contains information about an event destination for logging to Amazon SNS.</p>', 'EventDestination$SnsDestination' => '<p>An object that contains information about an event destination that sends logging events to Amazon SNS.</p>', 'UpdateEventDestinationRequest$SnsDestination' => '<p>An object that contains information about an event destination that sends data to Amazon SNS.</p>', ], ], 'SnsTopicArn' => [ 'base' => NULL, 'refs' => [ 'SnsDestination$TopicArn' => '<p>The Amazon Resource Name (ARN) of the Amazon SNS topic that you want to publish events to.</p>', ], ], 'SpendLimit' => [ 'base' => '<p>Describes the current Amazon Pinpoint monthly spend limits for sending voice and text messages. For more information on increasing your monthly spend limit, see <a href="https://docs.aws.amazon.com/pinpoint/latest/userguide/channels-sms-awssupport-spend-threshold.html"> Requesting increases to your monthly SMS spending quota for Amazon Pinpoint </a> in the <i>Amazon Pinpoint User Guide</i>. </p>', 'refs' => [ 'SpendLimitList$member' => NULL, ], ], 'SpendLimitList' => [ 'base' => NULL, 'refs' => [ 'DescribeSpendLimitsResult$SpendLimits' => '<p>An array of SpendLimit objects that contain the details for the requested spend limits.</p>', ], ], 'SpendLimitName' => [ 'base' => NULL, 'refs' => [ 'SpendLimit$Name' => '<p>The name for the SpendLimit.</p>', ], ], 'String' => [ 'base' => NULL, 'refs' => [ 'AccessDeniedException$Message' => NULL, 'AccountAttribute$Value' => '<p>The value associated with the account attribute name.</p>', 'AssociateOriginationIdentityResult$PoolArn' => '<p>The Amazon Resource Name (ARN) of the pool that is now associated with the origination identity.</p>', 'AssociateOriginationIdentityResult$PoolId' => '<p>The PoolId of the pool that is now associated with the origination identity.</p>', 'AssociateOriginationIdentityResult$OriginationIdentityArn' => '<p>The PhoneNumberArn or SenderIdArn of the origination identity.</p>', 'AssociateOriginationIdentityResult$OriginationIdentity' => '<p>The PhoneNumberId or SenderId of the origination identity.</p>', 'ConfigurationSetInformation$ConfigurationSetArn' => '<p>The Resource Name (ARN) of the ConfigurationSet.</p>', 'ConflictException$Message' => NULL, 'ConflictException$ResourceId' => '<p>The unique identifier of the request.</p>', 'CreateConfigurationSetResult$ConfigurationSetArn' => '<p>The Amazon Resource Name (ARN) of the newly created configuration set.</p>', 'CreateEventDestinationResult$ConfigurationSetArn' => '<p>The ARN of the configuration set.</p>', 'CreateOptOutListResult$OptOutListArn' => '<p>The Amazon Resource Name (ARN) for the OptOutList.</p>', 'CreatePoolResult$PoolArn' => '<p>The Amazon Resource Name (ARN) for the pool.</p>', 'CreatePoolResult$PoolId' => '<p>The unique identifier for the pool.</p>', 'DeleteConfigurationSetResult$ConfigurationSetArn' => '<p>The Amazon Resource Name (ARN) of the deleted configuration set.</p>', 'DeleteDefaultMessageTypeResult$ConfigurationSetArn' => '<p>The Amazon Resource Name (ARN) of the configuration set.</p>', 'DeleteDefaultSenderIdResult$ConfigurationSetArn' => '<p>The Amazon Resource Name (ARN) of the configuration set.</p>', 'DeleteEventDestinationResult$ConfigurationSetArn' => '<p>The Amazon Resource Name (ARN) of the configuration set.</p>', 'DeleteKeywordResult$OriginationIdentityArn' => '<p>The PhoneNumberArn or PoolArn that the keyword was associated with.</p>', 'DeleteKeywordResult$OriginationIdentity' => '<p>The PhoneNumberId or PoolId that the keyword was associated with.</p>', 'DeleteOptOutListResult$OptOutListArn' => '<p>The Amazon Resource Name (ARN) of the OptOutList that was removed.</p>', 'DeleteOptedOutNumberResult$OptOutListArn' => '<p>The OptOutListArn that the phone number was removed from.</p>', 'DeletePoolResult$PoolArn' => '<p>The Amazon Resource Name (ARN) of the pool that was deleted.</p>', 'DeletePoolResult$PoolId' => '<p>The PoolId of the pool that was deleted.</p>', 'DescribeKeywordsResult$OriginationIdentityArn' => '<p>The PhoneNumberArn or PoolArn that is associated with the OriginationIdentity. </p>', 'DescribeKeywordsResult$OriginationIdentity' => '<p>The PhoneNumberId or PoolId that is associated with the OriginationIdentity.</p>', 'DescribeOptedOutNumbersResult$OptOutListArn' => '<p>The Amazon Resource Name (ARN) of the OptOutList.</p>', 'DisassociateOriginationIdentityResult$PoolArn' => '<p>The Amazon Resource Name (ARN) of the pool.</p>', 'DisassociateOriginationIdentityResult$PoolId' => '<p>The PoolId of the pool no longer associated with the origination identity.</p>', 'DisassociateOriginationIdentityResult$OriginationIdentityArn' => '<p>The PhoneNumberArn or SenderIdArn of the origination identity.</p>', 'DisassociateOriginationIdentityResult$OriginationIdentity' => '<p>The PhoneNumberId or SenderId of the origination identity.</p>', 'InternalServerException$Message' => NULL, 'InternalServerException$RequestId' => '<p>The unique identifier of the request.</p>', 'ListPoolOriginationIdentitiesResult$PoolArn' => '<p>The Amazon Resource Name (ARN) for the pool.</p>', 'ListPoolOriginationIdentitiesResult$PoolId' => '<p>The unique PoolId of the pool.</p>', 'OptOutListInformation$OptOutListArn' => '<p>The Amazon Resource Name (ARN) of the OptOutList.</p>', 'OriginationIdentityMetadata$OriginationIdentityArn' => '<p>The Amazon Resource Name (ARN) associated with the origination identity.</p>', 'OriginationIdentityMetadata$OriginationIdentity' => '<p>The unique identifier of the origination identity.</p>', 'PhoneNumberInformation$PhoneNumberArn' => '<p>The Amazon Resource Name (ARN) associated with the phone number.</p>', 'PhoneNumberInformation$PhoneNumberId' => '<p>The unique identifier for the phone number.</p>', 'PhoneNumberInformation$MonthlyLeasingPrice' => '<p>The price, in US dollars, to lease the phone number.</p>', 'PhoneNumberInformation$PoolId' => '<p>The unique identifier of the pool associated with the phone number.</p>', 'PoolInformation$PoolArn' => '<p>The Amazon Resource Name (ARN) for the pool.</p>', 'PoolInformation$PoolId' => '<p>The unique identifier for the pool.</p>', 'PutKeywordResult$OriginationIdentityArn' => '<p>The PhoneNumberArn or PoolArn that the keyword was associated with.</p>', 'PutKeywordResult$OriginationIdentity' => '<p>The PhoneNumberId or PoolId that the keyword was associated with.</p>', 'PutOptedOutNumberResult$OptOutListArn' => '<p>The OptOutListArn that the phone number was removed from.</p>', 'ReleasePhoneNumberResult$PhoneNumberArn' => '<p>The PhoneNumberArn of the phone number that was released.</p>', 'ReleasePhoneNumberResult$PhoneNumberId' => '<p>The PhoneNumberId of the phone number that was released.</p>', 'ReleasePhoneNumberResult$MonthlyLeasingPrice' => '<p>The monthly price of the phone number, in US dollars.</p>', 'RequestPhoneNumberResult$PhoneNumberArn' => '<p>The Amazon Resource Name (ARN) of the requested phone number.</p>', 'RequestPhoneNumberResult$PhoneNumberId' => '<p>The unique identifier of the new phone number.</p>', 'RequestPhoneNumberResult$MonthlyLeasingPrice' => '<p>The monthly price, in US dollars, to lease the phone number.</p>', 'RequestPhoneNumberResult$PoolId' => '<p>The unique identifier of the pool associated with the phone number </p>', 'ResourceNotFoundException$Message' => NULL, 'ResourceNotFoundException$ResourceId' => '<p>The unique identifier of the resource.</p>', 'SendTextMessageResult$MessageId' => '<p>The unique identifier for the message.</p>', 'SendVoiceMessageResult$MessageId' => '<p>The unique identifier for the message.</p>', 'SenderIdInformation$SenderIdArn' => '<p>The Amazon Resource Name (ARN) associated with the SenderId.</p>', 'SenderIdInformation$MonthlyLeasingPrice' => '<p>The monthly leasing price, in US dollars.</p>', 'ServiceQuotaExceededException$Message' => NULL, 'SetDefaultMessageTypeResult$ConfigurationSetArn' => '<p>The Amazon Resource Name (ARN) of the updated configuration set.</p>', 'SetDefaultSenderIdResult$ConfigurationSetArn' => '<p>The Amazon Resource Name (ARN) of the updated configuration set.</p>', 'ThrottlingException$Message' => NULL, 'UpdateEventDestinationResult$ConfigurationSetArn' => '<p>The Amazon Resource Name (ARN) for the ConfigurationSet that was updated.</p>', 'UpdatePhoneNumberResult$PhoneNumberArn' => '<p>The Amazon Resource Name (ARN) of the updated phone number.</p>', 'UpdatePhoneNumberResult$PhoneNumberId' => '<p>The unique identifier of the phone number.</p>', 'UpdatePhoneNumberResult$MonthlyLeasingPrice' => '<p>The monthly leasing price of the phone number, in US dollars.</p>', 'UpdatePoolResult$PoolArn' => '<p>The ARN of the pool.</p>', 'UpdatePoolResult$PoolId' => '<p>The unique identifier of the pool.</p>', 'ValidationException$Message' => NULL, 'ValidationExceptionField$Name' => '<p>The name of the field.</p>', 'ValidationExceptionField$Message' => '<p>The message associated with the validation exception with information to help determine its cause.</p>', ], ], 'Tag' => [ 'base' => '<p>The list of tags to be added to the specified topic.</p>', 'refs' => [ 'NonEmptyTagList$member' => NULL, 'TagList$member' => NULL, ], ], 'TagKey' => [ 'base' => NULL, 'refs' => [ 'Tag$Key' => '<p>The key identifier, or name, of the tag.</p>', 'TagKeyList$member' => NULL, ], ], 'TagKeyList' => [ 'base' => NULL, 'refs' => [ 'UntagResourceRequest$TagKeys' => '<p>An array of tag key values to unassociate with the resource.</p>', ], ], 'TagList' => [ 'base' => NULL, 'refs' => [ 'CreateConfigurationSetRequest$Tags' => '<p>An array of key and value pair tags that\'s associated with the new configuration set. </p>', 'CreateConfigurationSetResult$Tags' => '<p>An array of key and value pair tags that\'s associated with the configuration set.</p>', 'CreateOptOutListRequest$Tags' => '<p>An array of tags (key and value pairs) to associate with the new OptOutList.</p>', 'CreateOptOutListResult$Tags' => '<p>An array of tags (key and value pairs) associated with the new OptOutList.</p>', 'CreatePoolRequest$Tags' => '<p>An array of tags (key and value pairs) associated with the pool.</p>', 'CreatePoolResult$Tags' => '<p>An array of tags (key and value pairs) associated with the pool.</p>', 'ListTagsForResourceResult$Tags' => '<p>An array of key and value pair tags that are associated with the resource.</p>', 'RequestPhoneNumberRequest$Tags' => '<p>An array of tags (key and value pairs) associate with the requested phone number. </p>', 'RequestPhoneNumberResult$Tags' => '<p>An array of key and value pair tags that are associated with the phone number.</p>', ], ], 'TagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'TagResourceResult' => [ 'base' => NULL, 'refs' => [], ], 'TagValue' => [ 'base' => NULL, 'refs' => [ 'Tag$Value' => '<p>The string value associated with the key of the tag.</p>', ], ], 'TextMessageBody' => [ 'base' => NULL, 'refs' => [ 'SendTextMessageRequest$MessageBody' => '<p>The body of the text message.</p>', ], ], 'TextMessageOriginationIdentity' => [ 'base' => NULL, 'refs' => [ 'SendTextMessageRequest$OriginationIdentity' => '<p>The origination identity of the message. This can be either the PhoneNumber, PhoneNumberId, PhoneNumberArn, SenderId, SenderIdArn, PoolId, or PoolArn.</p>', ], ], 'ThrottlingException' => [ 'base' => '<p>An error that occurred because too many requests were sent during a certain amount of time.</p>', 'refs' => [], ], 'TimeToLive' => [ 'base' => NULL, 'refs' => [ 'SendTextMessageRequest$TimeToLive' => '<p>How long the text message is valid for. By default this is 72 hours.</p>', 'SendVoiceMessageRequest$TimeToLive' => '<p>How long the voice message is valid for. By default this is 72 hours.</p>', ], ], 'Timestamp' => [ 'base' => NULL, 'refs' => [ 'ConfigurationSetInformation$CreatedTimestamp' => '<p>The time when the ConfigurationSet was created, in <a href="https://www.epochconverter.com/">UNIX epoch time</a> format.</p>', 'CreateConfigurationSetResult$CreatedTimestamp' => '<p>The time when the configuration set was created, in <a href="https://www.epochconverter.com/">UNIX epoch time</a> format.</p>', 'CreateOptOutListResult$CreatedTimestamp' => '<p>The time when the pool was created, in <a href="https://www.epochconverter.com/">UNIX epoch time</a> format.</p>', 'CreatePoolResult$CreatedTimestamp' => '<p>The time when the pool was created, in <a href="https://www.epochconverter.com/">UNIX epoch time</a> format.</p>', 'DeleteConfigurationSetResult$CreatedTimestamp' => '<p>The time that the deleted configuration set was created in <a href="https://www.epochconverter.com/">UNIX epoch time</a> format.</p>', 'DeleteOptOutListResult$CreatedTimestamp' => '<p>The time when the OptOutList was created, in <a href="https://www.epochconverter.com/">UNIX epoch time</a> format.</p>', 'DeleteOptedOutNumberResult$OptedOutTimestamp' => '<p>The time that the number was removed at, in <a href="https://www.epochconverter.com/">UNIX epoch time</a> format.</p>', 'DeletePoolResult$CreatedTimestamp' => '<p>The time when the pool was created, in <a href="https://www.epochconverter.com/">UNIX epoch time</a> format.</p>', 'OptOutListInformation$CreatedTimestamp' => '<p>The time when the OutOutList was created, in <a href="https://www.epochconverter.com/">UNIX epoch time</a> format.</p>', 'OptedOutNumberInformation$OptedOutTimestamp' => '<p>The time that the op tout occurred, in <a href="https://www.epochconverter.com/">UNIX epoch time</a> format.</p>', 'PhoneNumberInformation$CreatedTimestamp' => '<p>The time when the phone number was created, in <a href="https://www.epochconverter.com/">UNIX epoch time</a> format.</p>', 'PoolInformation$CreatedTimestamp' => '<p>The time when the pool was created, in <a href="https://www.epochconverter.com/">UNIX epoch time</a> format.</p>', 'PutOptedOutNumberResult$OptedOutTimestamp' => '<p>The time that the phone number was added to the OptOutList, in <a href="https://www.epochconverter.com/">UNIX epoch time</a> format.</p>', 'ReleasePhoneNumberResult$CreatedTimestamp' => '<p>The time when the phone number was created, in <a href="https://www.epochconverter.com/">UNIX epoch time</a> format.</p>', 'RequestPhoneNumberResult$CreatedTimestamp' => '<p>The time when the phone number was created, in <a href="https://www.epochconverter.com/">UNIX epoch time</a> format.</p>', 'UpdatePhoneNumberResult$CreatedTimestamp' => '<p>The time when the phone number was created, in <a href="https://www.epochconverter.com/">UNIX epoch time</a> format.</p>', 'UpdatePoolResult$CreatedTimestamp' => '<p>The time when the pool was created, in <a href="https://www.epochconverter.com/">UNIX epoch time</a> format.</p>', ], ], 'TwoWayChannelArn' => [ 'base' => NULL, 'refs' => [ 'CreatePoolResult$TwoWayChannelArn' => '<p>The Amazon Resource Name (ARN) of the two way channel.</p>', 'DeletePoolResult$TwoWayChannelArn' => '<p>The Amazon Resource Name (ARN) of the TwoWayChannel.</p>', 'PhoneNumberInformation$TwoWayChannelArn' => '<p>The Amazon Resource Name (ARN) of the two way channel.</p>', 'PoolInformation$TwoWayChannelArn' => '<p>The Amazon Resource Name (ARN) of the two way channel.</p>', 'ReleasePhoneNumberResult$TwoWayChannelArn' => '<p>The Amazon Resource Name (ARN) of the TwoWayChannel.</p>', 'RequestPhoneNumberResult$TwoWayChannelArn' => '<p>The ARN used to identify the two way channel.</p>', 'UpdatePhoneNumberRequest$TwoWayChannelArn' => '<p>The Amazon Resource Name (ARN) of the two way channel.</p>', 'UpdatePhoneNumberResult$TwoWayChannelArn' => '<p>The Amazon Resource Name (ARN) of the two way channel.</p>', 'UpdatePoolRequest$TwoWayChannelArn' => '<p>The Amazon Resource Name (ARN) of the two way channel.</p>', 'UpdatePoolResult$TwoWayChannelArn' => '<p>The Amazon Resource Name (ARN) of the two way channel.</p>', ], ], 'UntagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'UntagResourceResult' => [ 'base' => NULL, 'refs' => [], ], 'UpdateEventDestinationRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateEventDestinationResult' => [ 'base' => NULL, 'refs' => [], ], 'UpdatePhoneNumberRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdatePhoneNumberResult' => [ 'base' => NULL, 'refs' => [], ], 'UpdatePoolRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdatePoolResult' => [ 'base' => NULL, 'refs' => [], ], 'ValidationException' => [ 'base' => '<p>A validation exception for a field.</p>', 'refs' => [], ], 'ValidationExceptionField' => [ 'base' => '<p>The field associated with the validation exception.</p>', 'refs' => [ 'ValidationExceptionFieldList$member' => NULL, ], ], 'ValidationExceptionFieldList' => [ 'base' => NULL, 'refs' => [ 'ValidationException$Fields' => '<p>The field that failed validation.</p>', ], ], 'ValidationExceptionReason' => [ 'base' => NULL, 'refs' => [ 'ValidationException$Reason' => '<p>The reason for the exception.</p>', ], ], 'VoiceId' => [ 'base' => NULL, 'refs' => [ 'SendVoiceMessageRequest$VoiceId' => '<p>The voice for the <a href="https://docs.aws.amazon.com/polly/latest/dg/what-is.html">Amazon Polly</a> service to use. By default this is set to "MATTHEW".</p>', ], ], 'VoiceMessageBody' => [ 'base' => NULL, 'refs' => [ 'SendVoiceMessageRequest$MessageBody' => '<p>The text to convert to a voice message.</p>', ], ], 'VoiceMessageBodyTextType' => [ 'base' => NULL, 'refs' => [ 'SendVoiceMessageRequest$MessageBodyTextType' => '<p>Specifies if the MessageBody field contains text or <a href="https://docs.aws.amazon.com/polly/latest/dg/what-is.html">speech synthesis markup language (SSML)</a>.</p> <ul> <li> <p>TEXT: This is the default value. When used the maximum character limit is 3000.</p> </li> <li> <p>SSML: When used the maximum character limit is 6000 including SSML tagging.</p> </li> </ul>', ], ], 'VoiceMessageOriginationIdentity' => [ 'base' => NULL, 'refs' => [ 'SendVoiceMessageRequest$OriginationIdentity' => '<p>The origination identity to use for the voice call. This can be the PhoneNumber, PhoneNumberId, PhoneNumberArn, PoolId, or PoolArn.</p>', ], ], ],];
