<?php
// This file was auto-generated from sdk-root/src/data/lakeformation/2017-03-31/docs-2.json
return [ 'version' => '2.0', 'service' => '<fullname>Lake Formation</fullname> <p>Defines the public endpoint for the Lake Formation service.</p>', 'operations' => [ 'AddLFTagsToResource' => '<p>Attaches one or more LF-tags to an existing resource.</p>', 'BatchGrantPermissions' => '<p>Batch operation to grant permissions to the principal.</p>', 'BatchRevokePermissions' => '<p>Batch operation to revoke permissions from the principal.</p>', 'CancelTransaction' => '<p>Attempts to cancel the specified transaction. Returns an exception if the transaction was previously committed.</p>', 'CommitTransaction' => '<p>Attempts to commit the specified transaction. Returns an exception if the transaction was previously aborted. This API action is idempotent if called multiple times for the same transaction.</p>', 'CreateDataCellsFilter' => '<p>Creates a data cell filter to allow one to grant access to certain columns on certain rows.</p>', 'CreateLFTag' => '<p>Creates an LF-tag with the specified name and values.</p>', 'DeleteDataCellsFilter' => '<p>Deletes a data cell filter.</p>', 'DeleteLFTag' => '<p>Deletes the specified LF-tag key name. If the attribute key does not exist or the LF-tag does not exist, then the operation will not do anything. If the attribute key exists, then the operation checks if any resources are tagged with this attribute key, if yes, the API throws a 400 Exception with the message "Delete not allowed" as the LF-tag key is still attached with resources. You can consider untagging resources with this LF-tag key.</p>', 'DeleteObjectsOnCancel' => '<p>For a specific governed table, provides a list of Amazon S3 objects that will be written during the current transaction and that can be automatically deleted if the transaction is canceled. Without this call, no Amazon S3 objects are automatically deleted when a transaction cancels. </p> <p> The Glue ETL library function <code>write_dynamic_frame.from_catalog()</code> includes an option to automatically call <code>DeleteObjectsOnCancel</code> before writes. For more information, see <a href="https://docs.aws.amazon.com/lake-formation/latest/dg/transactions-data-operations.html#rolling-back-writes">Rolling Back Amazon S3 Writes</a>. </p>', 'DeregisterResource' => '<p>Deregisters the resource as managed by the Data Catalog.</p> <p>When you deregister a path, Lake Formation removes the path from the inline policy attached to your service-linked role.</p>', 'DescribeResource' => '<p>Retrieves the current data access role for the given resource registered in Lake Formation.</p>', 'DescribeTransaction' => '<p>Returns the details of a single transaction.</p>', 'ExtendTransaction' => '<p>Indicates to the service that the specified transaction is still active and should not be treated as idle and aborted.</p> <p>Write transactions that remain idle for a long period are automatically aborted unless explicitly extended.</p>', 'GetDataLakeSettings' => '<p>Retrieves the list of the data lake administrators of a Lake Formation-managed data lake. </p>', 'GetEffectivePermissionsForPath' => '<p>Returns the Lake Formation permissions for a specified table or database resource located at a path in Amazon S3. <code>GetEffectivePermissionsForPath</code> will not return databases and tables if the catalog is encrypted.</p>', 'GetLFTag' => '<p>Returns an LF-tag definition.</p>', 'GetQueryState' => '<p>Returns the state of a query previously submitted. Clients are expected to poll <code>GetQueryState</code> to monitor the current state of the planning before retrieving the work units. A query state is only visible to the principal that made the initial call to <code>StartQueryPlanning</code>.</p>', 'GetQueryStatistics' => '<p>Retrieves statistics on the planning and execution of a query.</p>', 'GetResourceLFTags' => '<p>Returns the LF-tags applied to a resource.</p>', 'GetTableObjects' => '<p>Returns the set of Amazon S3 objects that make up the specified governed table. A transaction ID or timestamp can be specified for time-travel queries.</p>', 'GetTemporaryGluePartitionCredentials' => '<p>This API is identical to <code>GetTemporaryTableCredentials</code> except that this is used when the target Data Catalog resource is of type Partition. Lake Formation restricts the permission of the vended credentials with the same scope down policy which restricts access to a single Amazon S3 prefix.</p>', 'GetTemporaryGlueTableCredentials' => '<p>Allows a caller in a secure environment to assume a role with permission to access Amazon S3. In order to vend such credentials, Lake Formation assumes the role associated with a registered location, for example an Amazon S3 bucket, with a scope down policy which restricts the access to a single prefix.</p>', 'GetWorkUnitResults' => '<p>Returns the work units resulting from the query. Work units can be executed in any order and in parallel. </p>', 'GetWorkUnits' => '<p>Retrieves the work units generated by the <code>StartQueryPlanning</code> operation.</p>', 'GrantPermissions' => '<p>Grants permissions to the principal to access metadata in the Data Catalog and data organized in underlying data storage such as Amazon S3.</p> <p>For information about permissions, see <a href="https://docs-aws.amazon.com/lake-formation/latest/dg/security-data-access.html">Security and Access Control to Metadata and Data</a>.</p>', 'ListDataCellsFilter' => '<p>Lists all the data cell filters on a table.</p>', 'ListLFTags' => '<p>Lists LF-tags that the requester has permission to view. </p>', 'ListPermissions' => '<p>Returns a list of the principal permissions on the resource, filtered by the permissions of the caller. For example, if you are granted an ALTER permission, you are able to see only the principal permissions for ALTER.</p> <p>This operation returns only those permissions that have been explicitly granted.</p> <p>For information about permissions, see <a href="https://docs-aws.amazon.com/lake-formation/latest/dg/security-data-access.html">Security and Access Control to Metadata and Data</a>.</p>', 'ListResources' => '<p>Lists the resources registered to be managed by the Data Catalog.</p>', 'ListTableStorageOptimizers' => '<p>Returns the configuration of all storage optimizers associated with a specified table.</p>', 'ListTransactions' => '<p>Returns metadata about transactions and their status. To prevent the response from growing indefinitely, only uncommitted transactions and those available for time-travel queries are returned.</p> <p>This operation can help you identify uncommitted transactions or to get information about transactions.</p>', 'PutDataLakeSettings' => '<p>Sets the list of data lake administrators who have admin privileges on all resources managed by Lake Formation. For more information on admin privileges, see <a href="https://docs.aws.amazon.com/lake-formation/latest/dg/lake-formation-permissions.html">Granting Lake Formation Permissions</a>.</p> <p>This API replaces the current list of data lake admins with the new list being passed. To add an admin, fetch the current list and add the new admin to that list and pass that list in this API.</p>', 'RegisterResource' => '<p>Registers the resource as managed by the Data Catalog.</p> <p>To add or update data, Lake Formation needs read/write access to the chosen Amazon S3 path. Choose a role that you know has permission to do this, or choose the AWSServiceRoleForLakeFormationDataAccess service-linked role. When you register the first Amazon S3 path, the service-linked role and a new inline policy are created on your behalf. Lake Formation adds the first path to the inline policy and attaches it to the service-linked role. When you register subsequent paths, Lake Formation adds the path to the existing policy.</p> <p>The following request registers a new location and gives Lake Formation permission to use the service-linked role to access that location.</p> <p> <code>ResourceArn = arn:aws:s3:::my-bucket UseServiceLinkedRole = true</code> </p> <p>If <code>UseServiceLinkedRole</code> is not set to true, you must provide or set the <code>RoleArn</code>:</p> <p> <code>arn:aws:iam::12345:role/my-data-access-role</code> </p>', 'RemoveLFTagsFromResource' => '<p>Removes an LF-tag from the resource. Only database, table, or tableWithColumns resource are allowed. To tag columns, use the column inclusion list in <code>tableWithColumns</code> to specify column input.</p>', 'RevokePermissions' => '<p>Revokes permissions to the principal to access metadata in the Data Catalog and data organized in underlying data storage such as Amazon S3.</p>', 'SearchDatabasesByLFTags' => '<p>This operation allows a search on <code>DATABASE</code> resources by <code>TagCondition</code>. This operation is used by admins who want to grant user permissions on certain <code>TagConditions</code>. Before making a grant, the admin can use <code>SearchDatabasesByTags</code> to find all resources where the given <code>TagConditions</code> are valid to verify whether the returned resources can be shared.</p>', 'SearchTablesByLFTags' => '<p>This operation allows a search on <code>TABLE</code> resources by <code>LFTag</code>s. This will be used by admins who want to grant user permissions on certain LF-tags. Before making a grant, the admin can use <code>SearchTablesByLFTags</code> to find all resources where the given <code>LFTag</code>s are valid to verify whether the returned resources can be shared.</p>', 'StartQueryPlanning' => '<p>Submits a request to process a query statement.</p> <p>This operation generates work units that can be retrieved with the <code>GetWorkUnits</code> operation as soon as the query state is WORKUNITS_AVAILABLE or FINISHED.</p>', 'StartTransaction' => '<p>Starts a new transaction and returns its transaction ID. Transaction IDs are opaque objects that you can use to identify a transaction.</p>', 'UpdateLFTag' => '<p>Updates the list of possible values for the specified LF-tag key. If the LF-tag does not exist, the operation throws an EntityNotFoundException. The values in the delete key values will be deleted from list of possible values. If any value in the delete key values is attached to a resource, then API errors out with a 400 Exception - "Update not allowed". Untag the attribute before deleting the LF-tag key\'s value. </p>', 'UpdateResource' => '<p>Updates the data access role used for vending access to the given (registered) resource in Lake Formation. </p>', 'UpdateTableObjects' => '<p>Updates the manifest of Amazon S3 objects that make up the specified governed table.</p>', 'UpdateTableStorageOptimizer' => '<p>Updates the configuration of the storage optimizers for a table.</p>', ], 'shapes' => [ 'AccessDeniedException' => [ 'base' => '<p>Access to a resource was denied.</p>', 'refs' => [], ], 'AccessKeyIdString' => [ 'base' => NULL, 'refs' => [ 'GetTemporaryGluePartitionCredentialsResponse$AccessKeyId' => '<p>The access key ID for the temporary credentials.</p>', 'GetTemporaryGlueTableCredentialsResponse$AccessKeyId' => '<p>The access key ID for the temporary credentials.</p>', ], ], 'AddLFTagsToResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'AddLFTagsToResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'AddObjectInput' => [ 'base' => '<p>A new object to add to the governed table.</p>', 'refs' => [ 'WriteOperation$AddObject' => '<p>A new object to add to the governed table.</p>', ], ], 'AllRowsWildcard' => [ 'base' => '<p>A structure that you pass to indicate you want all rows in a filter. </p>', 'refs' => [ 'RowFilter$AllRowsWildcard' => '<p>A wildcard for all rows.</p>', ], ], 'AlreadyExistsException' => [ 'base' => '<p>A resource to be created or added already exists.</p>', 'refs' => [], ], 'AuditContext' => [ 'base' => '<p>A structure used to include auditing information on the privileged API. </p>', 'refs' => [ 'GetTemporaryGluePartitionCredentialsRequest$AuditContext' => '<p>A structure representing context to access a resource (column names, query ID, etc).</p>', 'GetTemporaryGlueTableCredentialsRequest$AuditContext' => '<p>A structure representing context to access a resource (column names, query ID, etc).</p>', ], ], 'AuditContextString' => [ 'base' => NULL, 'refs' => [ 'AuditContext$AdditionalAuditContext' => '<p>The filter engine can populate the \'AdditionalAuditContext\' information with the request ID for you to track. This information will be displayed in CloudTrail log in your account.</p>', ], ], 'AuthorizedSessionTagValueList' => [ 'base' => NULL, 'refs' => [ 'DataLakeSettings$AuthorizedSessionTagValueList' => '<p>Lake Formation relies on a privileged process secured by Amazon EMR or the third party integrator to tag the user\'s role while assuming it. Lake Formation will publish the acceptable key-value pair, for example key = "LakeFormationTrustedCaller" and value = "TRUE" and the third party integrator must properly tag the temporary security credentials that will be used to call Lake Formation\'s administrative APIs.</p>', ], ], 'BatchGrantPermissionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'BatchGrantPermissionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'BatchPermissionsFailureEntry' => [ 'base' => '<p>A list of failures when performing a batch grant or batch revoke operation.</p>', 'refs' => [ 'BatchPermissionsFailureList$member' => NULL, ], ], 'BatchPermissionsFailureList' => [ 'base' => NULL, 'refs' => [ 'BatchGrantPermissionsResponse$Failures' => '<p>A list of failures to grant permissions to the resources.</p>', 'BatchRevokePermissionsResponse$Failures' => '<p>A list of failures to revoke permissions to the resources.</p>', ], ], 'BatchPermissionsRequestEntry' => [ 'base' => '<p>A permission to a resource granted by batch operation to the principal.</p>', 'refs' => [ 'BatchPermissionsFailureEntry$RequestEntry' => '<p>An identifier for an entry of the batch request.</p>', 'BatchPermissionsRequestEntryList$member' => NULL, ], ], 'BatchPermissionsRequestEntryList' => [ 'base' => NULL, 'refs' => [ 'BatchGrantPermissionsRequest$Entries' => '<p>A list of up to 20 entries for resource permissions to be granted by batch operation to the principal.</p>', 'BatchRevokePermissionsRequest$Entries' => '<p>A list of up to 20 entries for resource permissions to be revoked by batch operation to the principal.</p>', ], ], 'BatchRevokePermissionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'BatchRevokePermissionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'BooleanNullable' => [ 'base' => NULL, 'refs' => [ 'GetResourceLFTagsRequest$ShowAssignedLFTags' => '<p>Indicates whether to show the assigned LF-tags.</p>', ], ], 'CancelTransactionRequest' => [ 'base' => NULL, 'refs' => [], ], 'CancelTransactionResponse' => [ 'base' => NULL, 'refs' => [], ], 'CatalogIdString' => [ 'base' => NULL, 'refs' => [ 'AddLFTagsToResourceRequest$CatalogId' => '<p>The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your Lake Formation environment. </p>', 'BatchGrantPermissionsRequest$CatalogId' => '<p>The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your Lake Formation environment. </p>', 'BatchRevokePermissionsRequest$CatalogId' => '<p>The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your Lake Formation environment. </p>', 'CreateLFTagRequest$CatalogId' => '<p>The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your Lake Formation environment. </p>', 'DataCellsFilter$TableCatalogId' => '<p>The ID of the catalog to which the table belongs.</p>', 'DataCellsFilterResource$TableCatalogId' => '<p>The ID of the catalog to which the table belongs.</p>', 'DataLocationResource$CatalogId' => '<p>The identifier for the Data Catalog where the location is registered with Lake Formation. By default, it is the account ID of the caller.</p>', 'DatabaseResource$CatalogId' => '<p>The identifier for the Data Catalog. By default, it is the account ID of the caller.</p>', 'DeleteDataCellsFilterRequest$TableCatalogId' => '<p>The ID of the catalog to which the table belongs.</p>', 'DeleteLFTagRequest$CatalogId' => '<p>The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your Lake Formation environment. </p>', 'DeleteObjectsOnCancelRequest$CatalogId' => '<p>The Glue data catalog that contains the governed table. Defaults to the current account ID.</p>', 'GetDataLakeSettingsRequest$CatalogId' => '<p>The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your Lake Formation environment. </p>', 'GetEffectivePermissionsForPathRequest$CatalogId' => '<p>The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your Lake Formation environment. </p>', 'GetLFTagRequest$CatalogId' => '<p>The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your Lake Formation environment. </p>', 'GetLFTagResponse$CatalogId' => '<p>The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your Lake Formation environment. </p>', 'GetResourceLFTagsRequest$CatalogId' => '<p>The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your Lake Formation environment. </p>', 'GetTableObjectsRequest$CatalogId' => '<p>The catalog containing the governed table. Defaults to the caller’s account.</p>', 'GrantPermissionsRequest$CatalogId' => '<p>The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your Lake Formation environment. </p>', 'LFTagKeyResource$CatalogId' => '<p>The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your Lake Formation environment. </p>', 'LFTagPair$CatalogId' => '<p>The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your Lake Formation environment. </p>', 'LFTagPolicyResource$CatalogId' => '<p>The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your Lake Formation environment. </p>', 'ListLFTagsRequest$CatalogId' => '<p>The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your Lake Formation environment. </p>', 'ListPermissionsRequest$CatalogId' => '<p>The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your Lake Formation environment. </p>', 'ListTableStorageOptimizersRequest$CatalogId' => '<p>The Catalog ID of the table.</p>', 'ListTransactionsRequest$CatalogId' => '<p>The catalog for which to list transactions. Defaults to the account ID of the caller.</p>', 'PutDataLakeSettingsRequest$CatalogId' => '<p>The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your Lake Formation environment. </p>', 'QueryPlanningContext$CatalogId' => '<p>The ID of the Data Catalog where the partition in question resides. If none is provided, the Amazon Web Services account ID is used by default.</p>', 'RemoveLFTagsFromResourceRequest$CatalogId' => '<p>The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your Lake Formation environment. </p>', 'RevokePermissionsRequest$CatalogId' => '<p>The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your Lake Formation environment. </p>', 'SearchDatabasesByLFTagsRequest$CatalogId' => '<p>The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your Lake Formation environment. </p>', 'SearchTablesByLFTagsRequest$CatalogId' => '<p>The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your Lake Formation environment. </p>', 'TableResource$CatalogId' => '<p>The identifier for the Data Catalog. By default, it is the account ID of the caller.</p>', 'TableWithColumnsResource$CatalogId' => '<p>The identifier for the Data Catalog. By default, it is the account ID of the caller.</p>', 'TrustedResourceOwners$member' => NULL, 'UpdateLFTagRequest$CatalogId' => '<p>The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your Lake Formation environment. </p>', 'UpdateTableObjectsRequest$CatalogId' => '<p>The catalog containing the governed table to update. Defaults to the caller’s account ID.</p>', 'UpdateTableStorageOptimizerRequest$CatalogId' => '<p>The Catalog ID of the table.</p>', ], ], 'CatalogResource' => [ 'base' => '<p>A structure for the catalog object.</p>', 'refs' => [ 'Resource$Catalog' => '<p>The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your Lake Formation environment. </p>', ], ], 'ColumnLFTag' => [ 'base' => '<p>A structure containing the name of a column resource and the LF-tags attached to it.</p>', 'refs' => [ 'ColumnLFTagsList$member' => NULL, ], ], 'ColumnLFTagsList' => [ 'base' => NULL, 'refs' => [ 'GetResourceLFTagsResponse$LFTagsOnColumns' => '<p>A list of LF-tags applied to a column resource.</p>', 'TaggedTable$LFTagsOnColumns' => '<p>A list of LF-tags attached to columns in the table.</p>', ], ], 'ColumnNames' => [ 'base' => NULL, 'refs' => [ 'ColumnWildcard$ExcludedColumnNames' => '<p>Excludes column names. Any column with this name will be excluded.</p>', 'DataCellsFilter$ColumnNames' => '<p>A list of column names.</p>', 'TableWithColumnsResource$ColumnNames' => '<p>The list of column names for the table. At least one of <code>ColumnNames</code> or <code>ColumnWildcard</code> is required.</p>', ], ], 'ColumnWildcard' => [ 'base' => '<p>A wildcard object, consisting of an optional list of excluded column names or indexes.</p>', 'refs' => [ 'DataCellsFilter$ColumnWildcard' => '<p>A wildcard with exclusions.</p> <p>You must specify either a <code>ColumnNames</code> list or the <code>ColumnWildCard</code>. </p>', 'TableWithColumnsResource$ColumnWildcard' => '<p>A wildcard specified by a <code>ColumnWildcard</code> object. At least one of <code>ColumnNames</code> or <code>ColumnWildcard</code> is required.</p>', ], ], 'CommitTransactionRequest' => [ 'base' => NULL, 'refs' => [], ], 'CommitTransactionResponse' => [ 'base' => NULL, 'refs' => [], ], 'ComparisonOperator' => [ 'base' => NULL, 'refs' => [ 'FilterCondition$ComparisonOperator' => '<p>The comparison operator used in the filter condition.</p>', ], ], 'ConcurrentModificationException' => [ 'base' => '<p>Two processes are trying to modify a resource simultaneously.</p>', 'refs' => [], ], 'CreateDataCellsFilterRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateDataCellsFilterResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateLFTagRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateLFTagResponse' => [ 'base' => NULL, 'refs' => [], ], 'CredentialTimeoutDurationSecondInteger' => [ 'base' => NULL, 'refs' => [ 'GetTemporaryGluePartitionCredentialsRequest$DurationSeconds' => '<p>The time period, between 900 and 21,600 seconds, for the timeout of the temporary credentials.</p>', 'GetTemporaryGlueTableCredentialsRequest$DurationSeconds' => '<p>The time period, between 900 and 21,600 seconds, for the timeout of the temporary credentials.</p>', ], ], 'DataCellsFilter' => [ 'base' => '<p>A structure that describes certain columns on certain rows.</p>', 'refs' => [ 'CreateDataCellsFilterRequest$TableData' => '<p>A <code>DataCellsFilter</code> structure containing information about the data cells filter.</p>', 'DataCellsFilterList$member' => NULL, ], ], 'DataCellsFilterList' => [ 'base' => NULL, 'refs' => [ 'ListDataCellsFilterResponse$DataCellsFilters' => '<p>A list of <code>DataCellFilter</code> structures.</p>', ], ], 'DataCellsFilterResource' => [ 'base' => '<p>A structure for a data cells filter resource. </p>', 'refs' => [ 'Resource$DataCellsFilter' => '<p>A data cell filter.</p>', ], ], 'DataLakePrincipal' => [ 'base' => '<p>The Lake Formation principal. Supported principals are IAM users or IAM roles.</p>', 'refs' => [ 'BatchPermissionsRequestEntry$Principal' => '<p>The principal to be granted a permission.</p>', 'DataLakePrincipalList$member' => NULL, 'GrantPermissionsRequest$Principal' => '<p>The principal to be granted the permissions on the resource. Supported principals are IAM users or IAM roles, and they are defined by their principal type and their ARN.</p> <p>Note that if you define a resource with a particular ARN, then later delete, and recreate a resource with that same ARN, the resource maintains the permissions already granted. </p>', 'ListPermissionsRequest$Principal' => '<p>Specifies a principal to filter the permissions returned.</p>', 'PrincipalPermissions$Principal' => '<p>The principal who is granted permissions.</p>', 'PrincipalResourcePermissions$Principal' => '<p>The Data Lake principal to be granted or revoked permissions.</p>', 'RevokePermissionsRequest$Principal' => '<p>The principal to be revoked permissions on the resource.</p>', ], ], 'DataLakePrincipalList' => [ 'base' => NULL, 'refs' => [ 'DataLakeSettings$DataLakeAdmins' => '<p>A list of Lake Formation principals. Supported principals are IAM users or IAM roles.</p>', 'DataLakeSettings$ExternalDataFilteringAllowList' => '<p>A list of the account IDs of Amazon Web Services accounts with Amazon EMR clusters that are to perform data filtering.&gt;</p>', ], ], 'DataLakePrincipalString' => [ 'base' => NULL, 'refs' => [ 'DataLakePrincipal$DataLakePrincipalIdentifier' => '<p>An identifier for the Lake Formation principal.</p>', ], ], 'DataLakeResourceType' => [ 'base' => NULL, 'refs' => [ 'ListPermissionsRequest$ResourceType' => '<p>Specifies a resource type to filter the permissions returned.</p>', ], ], 'DataLakeSettings' => [ 'base' => '<p>A structure representing a list of Lake Formation principals designated as data lake administrators and lists of principal permission entries for default create database and default create table permissions.</p>', 'refs' => [ 'GetDataLakeSettingsResponse$DataLakeSettings' => '<p>A structure representing a list of Lake Formation principals designated as data lake administrators.</p>', 'PutDataLakeSettingsRequest$DataLakeSettings' => '<p>A structure representing a list of Lake Formation principals designated as data lake administrators.</p>', ], ], 'DataLocationResource' => [ 'base' => '<p>A structure for a data location object where permissions are granted or revoked. </p>', 'refs' => [ 'Resource$DataLocation' => '<p>The location of an Amazon S3 path where permissions are granted or revoked. </p>', ], ], 'DatabaseLFTagsList' => [ 'base' => NULL, 'refs' => [ 'SearchDatabasesByLFTagsResponse$DatabaseList' => '<p>A list of databases that meet the LF-tag conditions.</p>', ], ], 'DatabaseResource' => [ 'base' => '<p>A structure for the database object.</p>', 'refs' => [ 'Resource$Database' => '<p>The database for the resource. Unique to the Data Catalog. A database is a set of associated table definitions organized into a logical group. You can Grant and Revoke database permissions to a principal. </p>', 'TaggedDatabase$Database' => '<p>A database that has LF-tags attached to it.</p>', ], ], 'DateTime' => [ 'base' => NULL, 'refs' => [ 'GetQueryStatisticsResponse$QuerySubmissionTime' => '<p>The time that the query was submitted.</p>', ], ], 'DeleteDataCellsFilterRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteDataCellsFilterResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteLFTagRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteLFTagResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteObjectInput' => [ 'base' => '<p>An object to delete from the governed table.</p>', 'refs' => [ 'WriteOperation$DeleteObject' => '<p>An object to delete from the governed table.</p>', ], ], 'DeleteObjectsOnCancelRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteObjectsOnCancelResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeregisterResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeregisterResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeTransactionRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeTransactionResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescriptionString' => [ 'base' => NULL, 'refs' => [ 'ErrorDetail$ErrorMessage' => '<p>A message describing the error.</p>', ], ], 'DetailsMap' => [ 'base' => '<p>A structure containing the additional details to be returned in the <code>AdditionalDetails</code> attribute of <code>PrincipalResourcePermissions</code>.</p> <p>If a catalog resource is shared through Resource Access Manager (RAM), then there will exist a corresponding RAM resource share ARN.</p>', 'refs' => [ 'PrincipalResourcePermissions$AdditionalDetails' => '<p>This attribute can be used to return any additional details of <code>PrincipalResourcePermissions</code>. Currently returns only as a RAM resource share ARN.</p>', ], ], 'ETagString' => [ 'base' => NULL, 'refs' => [ 'AddObjectInput$ETag' => '<p>The Amazon S3 ETag of the object. Returned by <code>GetTableObjects</code> for validation and used to identify changes to the underlying data.</p>', 'DeleteObjectInput$ETag' => '<p>The Amazon S3 ETag of the object. Returned by <code>GetTableObjects</code> for validation and used to identify changes to the underlying data.</p>', 'TableObject$ETag' => '<p>The Amazon S3 ETag of the object. Returned by <code>GetTableObjects</code> for validation and used to identify changes to the underlying data.</p>', 'VirtualObject$ETag' => '<p>The ETag of the Amazon S3 object.</p>', ], ], 'EntityNotFoundException' => [ 'base' => '<p>A specified entity does not exist</p>', 'refs' => [], ], 'ErrorDetail' => [ 'base' => '<p>Contains details about an error.</p>', 'refs' => [ 'BatchPermissionsFailureEntry$Error' => '<p>An error message that applies to the failure of the entry.</p>', 'LFTagError$Error' => '<p>An error that occurred with the attachment or detachment of the LF-tag.</p>', ], ], 'ErrorMessageString' => [ 'base' => NULL, 'refs' => [ 'GetQueryStateResponse$Error' => '<p>An error message when the operation fails.</p>', ], ], 'ExecutionStatistics' => [ 'base' => '<p>Statistics related to the processing of a query statement.</p>', 'refs' => [ 'GetQueryStatisticsResponse$ExecutionStatistics' => '<p>An <code>ExecutionStatistics</code> structure containing execution statistics.</p>', ], ], 'ExpirationTimestamp' => [ 'base' => NULL, 'refs' => [ 'GetTemporaryGluePartitionCredentialsResponse$Expiration' => '<p>The date and time when the temporary credentials expire.</p>', 'GetTemporaryGlueTableCredentialsResponse$Expiration' => '<p>The date and time when the temporary credentials expire.</p>', ], ], 'ExpiredException' => [ 'base' => '<p>Contains details about an error where the query request expired.</p>', 'refs' => [], ], 'Expression' => [ 'base' => NULL, 'refs' => [ 'LFTagPolicyResource$Expression' => '<p>A list of LF-tag conditions that apply to the resource\'s LF-tag policy.</p>', 'SearchDatabasesByLFTagsRequest$Expression' => '<p>A list of conditions (<code>LFTag</code> structures) to search for in database resources.</p>', 'SearchTablesByLFTagsRequest$Expression' => '<p>A list of conditions (<code>LFTag</code> structures) to search for in table resources.</p>', ], ], 'ExtendTransactionRequest' => [ 'base' => NULL, 'refs' => [], ], 'ExtendTransactionResponse' => [ 'base' => NULL, 'refs' => [], ], 'FieldNameString' => [ 'base' => NULL, 'refs' => [ 'FilterCondition$Field' => '<p>The field to filter in the filter condition.</p>', ], ], 'FilterCondition' => [ 'base' => '<p>This structure describes the filtering of columns in a table based on a filter condition.</p>', 'refs' => [ 'FilterConditionList$member' => NULL, ], ], 'FilterConditionList' => [ 'base' => NULL, 'refs' => [ 'ListResourcesRequest$FilterConditionList' => '<p>Any applicable row-level and/or column-level filtering conditions for the resources.</p>', ], ], 'GetDataLakeSettingsRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetDataLakeSettingsResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetEffectivePermissionsForPathRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetEffectivePermissionsForPathResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetLFTagRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetLFTagResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetQueryStateRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetQueryStateRequestQueryIdString' => [ 'base' => NULL, 'refs' => [ 'GetQueryStateRequest$QueryId' => '<p>The ID of the plan query operation.</p>', ], ], 'GetQueryStateResponse' => [ 'base' => '<p>A structure for the output.</p>', 'refs' => [], ], 'GetQueryStatisticsRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetQueryStatisticsRequestQueryIdString' => [ 'base' => NULL, 'refs' => [ 'GetQueryStatisticsRequest$QueryId' => '<p>The ID of the plan query operation.</p>', ], ], 'GetQueryStatisticsResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetResourceLFTagsRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetResourceLFTagsResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetTableObjectsRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetTableObjectsResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetTemporaryGluePartitionCredentialsRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetTemporaryGluePartitionCredentialsResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetTemporaryGlueTableCredentialsRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetTemporaryGlueTableCredentialsResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetWorkUnitResultsRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetWorkUnitResultsRequestQueryIdString' => [ 'base' => NULL, 'refs' => [ 'GetWorkUnitResultsRequest$QueryId' => '<p>The ID of the plan query operation for which to get results.</p>', ], ], 'GetWorkUnitResultsRequestWorkUnitIdLong' => [ 'base' => NULL, 'refs' => [ 'GetWorkUnitResultsRequest$WorkUnitId' => '<p>The work unit ID for which to get results. Value generated by enumerating <code>WorkUnitIdMin</code> to <code>WorkUnitIdMax</code> (inclusive) from the <code>WorkUnitRange</code> in the output of <code>GetWorkUnits</code>.</p>', ], ], 'GetWorkUnitResultsResponse' => [ 'base' => '<p>A structure for the output.</p>', 'refs' => [], ], 'GetWorkUnitsRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetWorkUnitsRequestQueryIdString' => [ 'base' => NULL, 'refs' => [ 'GetWorkUnitsRequest$QueryId' => '<p>The ID of the plan query operation.</p>', ], ], 'GetWorkUnitsResponse' => [ 'base' => '<p>A structure for the output.</p>', 'refs' => [], ], 'GlueEncryptionException' => [ 'base' => '<p>An encryption operation failed.</p>', 'refs' => [], ], 'GrantPermissionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'GrantPermissionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'IAMRoleArn' => [ 'base' => NULL, 'refs' => [ 'RegisterResourceRequest$RoleArn' => '<p>The identifier for the role that registers the resource.</p>', 'ResourceInfo$RoleArn' => '<p>The IAM role that registered a resource.</p>', 'UpdateResourceRequest$RoleArn' => '<p>The new role to use for the given resource registered in Lake Formation.</p>', ], ], 'Identifier' => [ 'base' => NULL, 'refs' => [ 'BatchPermissionsRequestEntry$Id' => '<p>A unique identifier for the batch permissions request entry.</p>', ], ], 'Integer' => [ 'base' => NULL, 'refs' => [ 'GetWorkUnitsRequest$PageSize' => '<p>The size of each page to get in the Amazon Web Services service call. This does not affect the number of items returned in the command\'s output. Setting a smaller page size results in more calls to the Amazon Web Services service, retrieving fewer items in each call. This can help prevent the Amazon Web Services service calls from timing out.</p>', ], ], 'InternalServiceException' => [ 'base' => '<p>An internal service error occurred.</p>', 'refs' => [], ], 'InvalidInputException' => [ 'base' => '<p>The input provided was not valid.</p>', 'refs' => [], ], 'LFTag' => [ 'base' => '<p>A structure that allows an admin to grant user permissions on certain conditions. For example, granting a role access to all columns that do not have the LF-tag \'PII\' in tables that have the LF-tag \'Prod\'.</p>', 'refs' => [ 'Expression$member' => NULL, ], ], 'LFTagError' => [ 'base' => '<p>A structure containing an error related to a <code>TagResource</code> or <code>UnTagResource</code> operation.</p>', 'refs' => [ 'LFTagErrors$member' => NULL, ], ], 'LFTagErrors' => [ 'base' => NULL, 'refs' => [ 'AddLFTagsToResourceResponse$Failures' => '<p>A list of failures to tag the resource.</p>', 'RemoveLFTagsFromResourceResponse$Failures' => '<p>A list of failures to untag a resource.</p>', ], ], 'LFTagKey' => [ 'base' => NULL, 'refs' => [ 'CreateLFTagRequest$TagKey' => '<p>The key-name for the LF-tag.</p>', 'DeleteLFTagRequest$TagKey' => '<p>The key-name for the LF-tag to delete.</p>', 'GetLFTagRequest$TagKey' => '<p>The key-name for the LF-tag.</p>', 'GetLFTagResponse$TagKey' => '<p>The key-name for the LF-tag.</p>', 'LFTag$TagKey' => '<p>The key-name for the LF-tag.</p>', 'LFTagPair$TagKey' => '<p>The key-name for the LF-tag.</p>', 'UpdateLFTagRequest$TagKey' => '<p>The key-name for the LF-tag for which to add or delete values.</p>', ], ], 'LFTagKeyResource' => [ 'base' => '<p>A structure containing an LF-tag key and values for a resource.</p>', 'refs' => [ 'Resource$LFTag' => '<p>The LF-tag key and values attached to a resource.</p>', ], ], 'LFTagPair' => [ 'base' => '<p>A structure containing an LF-tag key-value pair.</p>', 'refs' => [ 'LFTagError$LFTag' => '<p>The key-name of the LF-tag.</p>', 'LFTagsList$member' => NULL, ], ], 'LFTagPolicyResource' => [ 'base' => '<p>A structure containing a list of LF-tag conditions that apply to a resource\'s LF-tag policy.</p>', 'refs' => [ 'Resource$LFTagPolicy' => '<p>A list of LF-tag conditions that define a resource\'s LF-tag policy.</p>', ], ], 'LFTagValue' => [ 'base' => NULL, 'refs' => [ 'TagValueList$member' => NULL, ], ], 'LFTagsList' => [ 'base' => NULL, 'refs' => [ 'AddLFTagsToResourceRequest$LFTags' => '<p>The LF-tags to attach to the resource.</p>', 'ColumnLFTag$LFTags' => '<p>The LF-tags attached to a column resource.</p>', 'GetResourceLFTagsResponse$LFTagOnDatabase' => '<p>A list of LF-tags applied to a database resource.</p>', 'GetResourceLFTagsResponse$LFTagsOnTable' => '<p>A list of LF-tags applied to a table resource.</p>', 'ListLFTagsResponse$LFTags' => '<p>A list of LF-tags that the requested has permission to view.</p>', 'RemoveLFTagsFromResourceRequest$LFTags' => '<p>The LF-tags to be removed from the resource.</p>', 'TaggedDatabase$LFTags' => '<p>A list of LF-tags attached to the database.</p>', 'TaggedTable$LFTagOnDatabase' => '<p>A list of LF-tags attached to the database where the table resides.</p>', 'TaggedTable$LFTagsOnTable' => '<p>A list of LF-tags attached to the table.</p>', ], ], 'LastModifiedTimestamp' => [ 'base' => NULL, 'refs' => [ 'ResourceInfo$LastModified' => '<p>The date and time the resource was last modified.</p>', ], ], 'ListDataCellsFilterRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListDataCellsFilterResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListLFTagsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListLFTagsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListPermissionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListPermissionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListResourcesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListResourcesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTableStorageOptimizersRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTableStorageOptimizersResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTransactionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTransactionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'MessageString' => [ 'base' => NULL, 'refs' => [ 'AccessDeniedException$Message' => '<p>A message describing the problem.</p>', 'AlreadyExistsException$Message' => '<p>A message describing the problem.</p>', 'ConcurrentModificationException$Message' => '<p>A message describing the problem.</p>', 'EntityNotFoundException$Message' => '<p>A message describing the problem.</p>', 'ExpiredException$Message' => '<p>A message describing the error.</p>', 'GlueEncryptionException$Message' => '<p>A message describing the problem.</p>', 'InternalServiceException$Message' => '<p>A message describing the problem.</p>', 'InvalidInputException$Message' => '<p>A message describing the problem.</p>', 'OperationTimeoutException$Message' => '<p>A message describing the problem.</p>', 'PermissionTypeMismatchException$Message' => '<p>A message describing the problem.</p>', 'ResourceNotReadyException$Message' => '<p>A message describing the error.</p>', 'ResourceNumberLimitExceededException$Message' => '<p>A message describing the problem.</p>', 'StatisticsNotReadyYetException$Message' => '<p>A message describing the error.</p>', 'StorageOptimizer$ErrorMessage' => '<p>A message that contains information about any error (if present).</p> <p>When an acceleration result has an enabled status, the error message is empty.</p> <p>When an acceleration result has a disabled status, the message describes an error or simply indicates "disabled by the user".</p>', 'StorageOptimizer$Warnings' => '<p>A message that contains information about any warnings (if present).</p>', 'StorageOptimizer$LastRunDetails' => '<p>When an acceleration result has an enabled status, contains the details of the last job run.</p>', 'ThrottledException$Message' => '<p>A message describing the error.</p>', 'TransactionCanceledException$Message' => '<p>A message describing the error.</p>', 'TransactionCommitInProgressException$Message' => '<p>A message describing the error.</p>', 'TransactionCommittedException$Message' => '<p>A message describing the error.</p>', 'WorkUnitsNotReadyYetException$Message' => '<p>A message describing the error.</p>', ], ], 'NameString' => [ 'base' => NULL, 'refs' => [ 'AuthorizedSessionTagValueList$member' => NULL, 'ColumnLFTag$Name' => '<p>The name of a column resource.</p>', 'ColumnNames$member' => NULL, 'DataCellsFilter$DatabaseName' => '<p>A database in the Glue Data Catalog.</p>', 'DataCellsFilter$TableName' => '<p>A table in the database.</p>', 'DataCellsFilter$Name' => '<p>The name given by the user to the data filter cell.</p>', 'DataCellsFilterResource$DatabaseName' => '<p>A database in the Glue Data Catalog.</p>', 'DataCellsFilterResource$TableName' => '<p>The name of the table.</p>', 'DataCellsFilterResource$Name' => '<p>The name of the data cells filter. </p>', 'DatabaseResource$Name' => '<p>The name of the database resource. Unique to the Data Catalog.</p>', 'DeleteDataCellsFilterRequest$DatabaseName' => '<p>A database in the Glue Data Catalog.</p>', 'DeleteDataCellsFilterRequest$TableName' => '<p>A table in the database.</p>', 'DeleteDataCellsFilterRequest$Name' => '<p>The name given by the user to the data filter cell.</p>', 'DeleteObjectsOnCancelRequest$DatabaseName' => '<p>The database that contains the governed table.</p>', 'DeleteObjectsOnCancelRequest$TableName' => '<p>The name of the governed table.</p>', 'ErrorDetail$ErrorCode' => '<p>The code associated with this error.</p>', 'GetTableObjectsRequest$DatabaseName' => '<p>The database containing the governed table.</p>', 'GetTableObjectsRequest$TableName' => '<p>The governed table for which to retrieve objects.</p>', 'LFTagKeyResource$TagKey' => '<p>The key-name for the LF-tag.</p>', 'ListTableStorageOptimizersRequest$DatabaseName' => '<p>Name of the database where the table is present.</p>', 'ListTableStorageOptimizersRequest$TableName' => '<p>Name of the table.</p>', 'TableResource$DatabaseName' => '<p>The name of the database for the table. Unique to a Data Catalog. A database is a set of associated table definitions organized into a logical group. You can Grant and Revoke database privileges to a principal. </p>', 'TableResource$Name' => '<p>The name of the table.</p>', 'TableWithColumnsResource$DatabaseName' => '<p>The name of the database for the table with columns resource. Unique to the Data Catalog. A database is a set of associated table definitions organized into a logical group. You can Grant and Revoke database privileges to a principal. </p>', 'TableWithColumnsResource$Name' => '<p>The name of the table resource. A table is a metadata definition that represents your data. You can Grant and Revoke table privileges to a principal. </p>', 'UpdateTableObjectsRequest$DatabaseName' => '<p>The database containing the governed table to update.</p>', 'UpdateTableObjectsRequest$TableName' => '<p>The governed table to update.</p>', 'UpdateTableStorageOptimizerRequest$DatabaseName' => '<p>Name of the database where the table is present.</p>', 'UpdateTableStorageOptimizerRequest$TableName' => '<p>Name of the table for which to enable the storage optimizer.</p>', ], ], 'NullableBoolean' => [ 'base' => NULL, 'refs' => [ 'DataLakeSettings$AllowExternalDataFiltering' => '<p>Whether to allow Amazon EMR clusters to access data managed by Lake Formation. </p> <p>If true, you allow Amazon EMR clusters to access data in Amazon S3 locations that are registered with Lake Formation.</p> <p>If false or null, no Amazon EMR clusters will be able to access data in Amazon S3 locations that are registered with Lake Formation.</p> <p>For more information, see <a href="https://docs-aws.amazon.com/lake-formation/latest/dg/getting-started-setup.html#emr-switch">(Optional) Allow Data Filtering on Amazon EMR</a>.</p>', 'RegisterResourceRequest$UseServiceLinkedRole' => '<p>Designates an Identity and Access Management (IAM) service-linked role by registering this role with the Data Catalog. A service-linked role is a unique type of IAM role that is linked directly to Lake Formation.</p> <p>For more information, see <a href="https://docs-aws.amazon.com/lake-formation/latest/dg/service-linked-roles.html">Using Service-Linked Roles for Lake Formation</a>.</p>', ], ], 'NumberOfBytes' => [ 'base' => NULL, 'refs' => [ 'ExecutionStatistics$DataScannedBytes' => '<p>The amount of data that was scanned in bytes.</p>', 'PlanningStatistics$EstimatedDataToScanBytes' => '<p>An estimate of the data that was scanned in bytes.</p>', ], ], 'NumberOfItems' => [ 'base' => NULL, 'refs' => [ 'ExecutionStatistics$WorkUnitsExecutedCount' => '<p>The number of work units executed.</p>', 'PlanningStatistics$WorkUnitsGeneratedCount' => '<p>The number of work units generated.</p>', ], ], 'NumberOfMilliseconds' => [ 'base' => NULL, 'refs' => [ 'ExecutionStatistics$AverageExecutionTimeMillis' => '<p>The average time the request took to be executed.</p>', 'PlanningStatistics$PlanningTimeMillis' => '<p>The time that it took to process the request.</p>', 'PlanningStatistics$QueueTimeMillis' => '<p>The time the request was in queue to be processed.</p>', ], ], 'ObjectSize' => [ 'base' => NULL, 'refs' => [ 'AddObjectInput$Size' => '<p>The size of the Amazon S3 object in bytes.</p>', 'TableObject$Size' => '<p>The size of the Amazon S3 object in bytes.</p>', ], ], 'OperationTimeoutException' => [ 'base' => '<p>The operation timed out.</p>', 'refs' => [], ], 'OptimizerType' => [ 'base' => NULL, 'refs' => [ 'ListTableStorageOptimizersRequest$StorageOptimizerType' => '<p>The specific type of storage optimizers to list. The supported value is <code>compaction</code>.</p>', 'StorageOptimizer$StorageOptimizerType' => '<p>The specific type of storage optimizer. The supported value is <code>compaction</code>.</p>', 'StorageOptimizerConfigMap$key' => NULL, ], ], 'PageSize' => [ 'base' => NULL, 'refs' => [ 'GetEffectivePermissionsForPathRequest$MaxResults' => '<p>The maximum number of results to return.</p>', 'GetTableObjectsRequest$MaxResults' => '<p>Specifies how many values to return in a page.</p>', 'ListDataCellsFilterRequest$MaxResults' => '<p>The maximum size of the response.</p>', 'ListLFTagsRequest$MaxResults' => '<p>The maximum number of results to return.</p>', 'ListPermissionsRequest$MaxResults' => '<p>The maximum number of results to return.</p>', 'ListResourcesRequest$MaxResults' => '<p>The maximum number of resource results.</p>', 'ListTableStorageOptimizersRequest$MaxResults' => '<p>The number of storage optimizers to return on each call.</p>', 'ListTransactionsRequest$MaxResults' => '<p>The maximum number of transactions to return in a single call.</p>', 'SearchDatabasesByLFTagsRequest$MaxResults' => '<p>The maximum number of results to return.</p>', 'SearchTablesByLFTagsRequest$MaxResults' => '<p>The maximum number of results to return.</p>', ], ], 'PartitionObjects' => [ 'base' => '<p>A structure containing a list of partition values and table objects.</p>', 'refs' => [ 'PartitionedTableObjectsList$member' => NULL, ], ], 'PartitionValueList' => [ 'base' => '<p>Contains a list of values defining partitions.</p>', 'refs' => [ 'GetTemporaryGluePartitionCredentialsRequest$Partition' => '<p>A list of partition values identifying a single partition.</p>', ], ], 'PartitionValueString' => [ 'base' => NULL, 'refs' => [ 'PartitionValuesList$member' => NULL, ], ], 'PartitionValuesList' => [ 'base' => NULL, 'refs' => [ 'AddObjectInput$PartitionValues' => '<p>A list of partition values for the object. A value must be specified for each partition key associated with the table.</p> <p>The supported data types are integer, long, date(yyyy-MM-dd), timestamp(yyyy-MM-dd HH:mm:ssXXX or yyyy-MM-dd HH:mm:ss"), string and decimal.</p>', 'DeleteObjectInput$PartitionValues' => '<p>A list of partition values for the object. A value must be specified for each partition key associated with the governed table.</p>', 'PartitionObjects$PartitionValues' => '<p>A list of partition values.</p>', ], ], 'PartitionedTableObjectsList' => [ 'base' => NULL, 'refs' => [ 'GetTableObjectsResponse$Objects' => '<p>A list of objects organized by partition keys.</p>', ], ], 'Permission' => [ 'base' => NULL, 'refs' => [ 'PermissionList$member' => NULL, ], ], 'PermissionList' => [ 'base' => NULL, 'refs' => [ 'BatchPermissionsRequestEntry$Permissions' => '<p>The permissions to be granted.</p>', 'BatchPermissionsRequestEntry$PermissionsWithGrantOption' => '<p>Indicates if the option to pass permissions is granted.</p>', 'GetTemporaryGluePartitionCredentialsRequest$Permissions' => '<p>Filters the request based on the user having been granted a list of specified permissions on the requested resource(s).</p>', 'GetTemporaryGlueTableCredentialsRequest$Permissions' => '<p>Filters the request based on the user having been granted a list of specified permissions on the requested resource(s).</p>', 'GrantPermissionsRequest$Permissions' => '<p>The permissions granted to the principal on the resource. Lake Formation defines privileges to grant and revoke access to metadata in the Data Catalog and data organized in underlying data storage such as Amazon S3. Lake Formation requires that each principal be authorized to perform a specific task on Lake Formation resources. </p>', 'GrantPermissionsRequest$PermissionsWithGrantOption' => '<p>Indicates a list of the granted permissions that the principal may pass to other users. These permissions may only be a subset of the permissions granted in the <code>Privileges</code>.</p>', 'PrincipalPermissions$Permissions' => '<p>The permissions that are granted to the principal.</p>', 'PrincipalResourcePermissions$Permissions' => '<p>The permissions to be granted or revoked on the resource.</p>', 'PrincipalResourcePermissions$PermissionsWithGrantOption' => '<p>Indicates whether to grant the ability to grant permissions (as a subset of permissions granted).</p>', 'RevokePermissionsRequest$Permissions' => '<p>The permissions revoked to the principal on the resource. For information about permissions, see <a href="https://docs-aws.amazon.com/lake-formation/latest/dg/security-data-access.html">Security and Access Control to Metadata and Data</a>.</p>', 'RevokePermissionsRequest$PermissionsWithGrantOption' => '<p>Indicates a list of permissions for which to revoke the grant option allowing the principal to pass permissions to other principals.</p>', ], ], 'PermissionType' => [ 'base' => NULL, 'refs' => [ 'PermissionTypeList$member' => NULL, ], ], 'PermissionTypeList' => [ 'base' => NULL, 'refs' => [ 'GetTemporaryGluePartitionCredentialsRequest$SupportedPermissionTypes' => '<p>A list of supported permission types for the partition. Valid values are <code>COLUMN_PERMISSION</code> and <code>CELL_FILTER_PERMISSION</code>.</p>', 'GetTemporaryGlueTableCredentialsRequest$SupportedPermissionTypes' => '<p>A list of supported permission types for the table. Valid values are <code>COLUMN_PERMISSION</code> and <code>CELL_FILTER_PERMISSION</code>.</p>', ], ], 'PermissionTypeMismatchException' => [ 'base' => '<p>The engine does not support filtering data based on the enforced permissions. For example, if you call the <code>GetTemporaryGlueTableCredentials</code> operation with <code>SupportedPermissionType</code> equal to <code>ColumnPermission</code>, but cell-level permissions exist on the table, this exception is thrown.</p>', 'refs' => [], ], 'PlanningStatistics' => [ 'base' => '<p>Statistics related to the processing of a query statement.</p>', 'refs' => [ 'GetQueryStatisticsResponse$PlanningStatistics' => '<p>A <code>PlanningStatistics</code> structure containing query planning statistics.</p>', ], ], 'PredicateString' => [ 'base' => NULL, 'refs' => [ 'GetTableObjectsRequest$PartitionPredicate' => '<p>A predicate to filter the objects returned based on the partition keys defined in the governed table.</p> <ul> <li> <p>The comparison operators supported are: =, &gt;, &lt;, &gt;=, &lt;=</p> </li> <li> <p>The logical operators supported are: AND</p> </li> <li> <p>The data types supported are integer, long, date(yyyy-MM-dd), timestamp(yyyy-MM-dd HH:mm:ssXXX or yyyy-MM-dd HH:mm:ss"), string and decimal.</p> </li> </ul>', 'RowFilter$FilterExpression' => '<p>A filter expression.</p>', ], ], 'PrincipalPermissions' => [ 'base' => '<p>Permissions granted to a principal.</p>', 'refs' => [ 'PrincipalPermissionsList$member' => NULL, ], ], 'PrincipalPermissionsList' => [ 'base' => NULL, 'refs' => [ 'DataLakeSettings$CreateDatabaseDefaultPermissions' => '<p>Specifies whether access control on newly created database is managed by Lake Formation permissions or exclusively by IAM permissions. You can override this default setting when you create a database.</p> <p>A null value indicates access control by Lake Formation permissions. A value that assigns ALL to IAM_ALLOWED_PRINCIPALS indicates access control by IAM permissions. This is referred to as the setting "Use only IAM access control," and is for backward compatibility with the Glue permission model implemented by IAM permissions.</p> <p>The only permitted values are an empty array or an array that contains a single JSON object that grants ALL to IAM_ALLOWED_PRINCIPALS.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/lake-formation/latest/dg/change-settings.html">Changing the Default Security Settings for Your Data Lake</a>.</p>', 'DataLakeSettings$CreateTableDefaultPermissions' => '<p>Specifies whether access control on newly created table is managed by Lake Formation permissions or exclusively by IAM permissions.</p> <p>A null value indicates access control by Lake Formation permissions. A value that assigns ALL to IAM_ALLOWED_PRINCIPALS indicates access control by IAM permissions. This is referred to as the setting "Use only IAM access control," and is for backward compatibility with the Glue permission model implemented by IAM permissions.</p> <p>The only permitted values are an empty array or an array that contains a single JSON object that grants ALL to IAM_ALLOWED_PRINCIPALS.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/lake-formation/latest/dg/change-settings.html">Changing the Default Security Settings for Your Data Lake</a>.</p>', ], ], 'PrincipalResourcePermissions' => [ 'base' => '<p>The permissions granted or revoked on a resource.</p>', 'refs' => [ 'PrincipalResourcePermissionsList$member' => NULL, ], ], 'PrincipalResourcePermissionsList' => [ 'base' => NULL, 'refs' => [ 'GetEffectivePermissionsForPathResponse$Permissions' => '<p>A list of the permissions for the specified table or database resource located at the path in Amazon S3.</p>', 'ListPermissionsResponse$PrincipalResourcePermissions' => '<p>A list of principals and their permissions on the resource for the specified principal and resource types.</p>', ], ], 'PutDataLakeSettingsRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutDataLakeSettingsResponse' => [ 'base' => NULL, 'refs' => [], ], 'QueryIdString' => [ 'base' => NULL, 'refs' => [ 'GetWorkUnitsResponse$QueryId' => '<p>The ID of the plan query operation.</p>', 'StartQueryPlanningResponse$QueryId' => '<p>The ID of the plan query operation can be used to fetch the actual work unit descriptors that are produced as the result of the operation. The ID is also used to get the query state and as an input to the <code>Execute</code> operation.</p>', ], ], 'QueryParameterMap' => [ 'base' => NULL, 'refs' => [ 'QueryPlanningContext$QueryParameters' => '<p>A map consisting of key-value pairs.</p>', ], ], 'QueryPlanningContext' => [ 'base' => '<p>A structure containing information about the query plan.</p>', 'refs' => [ 'StartQueryPlanningRequest$QueryPlanningContext' => '<p>A structure containing information about the query plan.</p>', ], ], 'QueryPlanningContextDatabaseNameString' => [ 'base' => NULL, 'refs' => [ 'QueryPlanningContext$DatabaseName' => '<p>The database containing the table.</p>', ], ], 'QueryStateString' => [ 'base' => NULL, 'refs' => [ 'GetQueryStateResponse$State' => '<p>The state of a query previously submitted. The possible states are:</p> <ul> <li> <p>PENDING: the query is pending.</p> </li> <li> <p>WORKUNITS_AVAILABLE: some work units are ready for retrieval and execution.</p> </li> <li> <p>FINISHED: the query planning finished successfully, and all work units are ready for retrieval and execution.</p> </li> <li> <p>ERROR: an error occurred with the query, such as an invalid query ID or a backend error.</p> </li> </ul>', ], ], 'RAMResourceShareArn' => [ 'base' => NULL, 'refs' => [ 'ResourceShareList$member' => NULL, ], ], 'RegisterResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'RegisterResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'RemoveLFTagsFromResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'RemoveLFTagsFromResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'Resource' => [ 'base' => '<p>A structure for the resource.</p>', 'refs' => [ 'AddLFTagsToResourceRequest$Resource' => '<p>The database, table, or column resource to which to attach an LF-tag.</p>', 'BatchPermissionsRequestEntry$Resource' => '<p>The resource to which the principal is to be granted a permission.</p>', 'GetResourceLFTagsRequest$Resource' => '<p>The database, table, or column resource for which you want to return LF-tags.</p>', 'GrantPermissionsRequest$Resource' => '<p>The resource to which permissions are to be granted. Resources in Lake Formation are the Data Catalog, databases, and tables.</p>', 'ListPermissionsRequest$Resource' => '<p>A resource where you will get a list of the principal permissions.</p> <p>This operation does not support getting privileges on a table with columns. Instead, call this operation on the table, and the operation returns the table and the table w columns.</p>', 'PrincipalResourcePermissions$Resource' => '<p>The resource where permissions are to be granted or revoked.</p>', 'RemoveLFTagsFromResourceRequest$Resource' => '<p>The database, table, or column resource where you want to remove an LF-tag.</p>', 'RevokePermissionsRequest$Resource' => '<p>The resource to which permissions are to be revoked.</p>', ], ], 'ResourceArnString' => [ 'base' => NULL, 'refs' => [ 'DataLocationResource$ResourceArn' => '<p>The Amazon Resource Name (ARN) that uniquely identifies the data location resource.</p>', 'DeregisterResourceRequest$ResourceArn' => '<p>The Amazon Resource Name (ARN) of the resource that you want to deregister.</p>', 'DescribeResourceRequest$ResourceArn' => '<p>The resource ARN.</p>', 'GetEffectivePermissionsForPathRequest$ResourceArn' => '<p>The Amazon Resource Name (ARN) of the resource for which you want to get permissions.</p>', 'GetTemporaryGluePartitionCredentialsRequest$TableArn' => '<p>The ARN of the partitions\' table.</p>', 'GetTemporaryGlueTableCredentialsRequest$TableArn' => '<p>The ARN identifying a table in the Data Catalog for the temporary credentials request.</p>', 'RegisterResourceRequest$ResourceArn' => '<p>The Amazon Resource Name (ARN) of the resource that you want to register.</p>', 'ResourceInfo$ResourceArn' => '<p>The Amazon Resource Name (ARN) of the resource.</p>', 'UpdateResourceRequest$ResourceArn' => '<p>The resource ARN.</p>', ], ], 'ResourceInfo' => [ 'base' => '<p>A structure containing information about an Lake Formation resource.</p>', 'refs' => [ 'DescribeResourceResponse$ResourceInfo' => '<p>A structure containing information about an Lake Formation resource.</p>', 'ResourceInfoList$member' => NULL, ], ], 'ResourceInfoList' => [ 'base' => NULL, 'refs' => [ 'ListResourcesResponse$ResourceInfoList' => '<p>A summary of the data lake resources.</p>', ], ], 'ResourceNotReadyException' => [ 'base' => '<p>Contains details about an error related to a resource which is not ready for a transaction.</p>', 'refs' => [], ], 'ResourceNumberLimitExceededException' => [ 'base' => '<p>A resource numerical limit was exceeded.</p>', 'refs' => [], ], 'ResourceShareList' => [ 'base' => NULL, 'refs' => [ 'DetailsMap$ResourceShare' => '<p>A resource share ARN for a catalog resource shared through RAM.</p>', ], ], 'ResourceShareType' => [ 'base' => NULL, 'refs' => [ 'ListLFTagsRequest$ResourceShareType' => '<p>If resource share type is <code>ALL</code>, returns both in-account LF-tags and shared LF-tags that the requester has permission to view. If resource share type is <code>FOREIGN</code>, returns all share LF-tags that the requester can view. If no resource share type is passed, lists LF-tags in the given catalog ID that the requester has permission to view.</p>', ], ], 'ResourceType' => [ 'base' => NULL, 'refs' => [ 'LFTagPolicyResource$ResourceType' => '<p>The resource type for which the LF-tag policy applies.</p>', ], ], 'Result' => [ 'base' => NULL, 'refs' => [ 'UpdateTableStorageOptimizerResponse$Result' => '<p>A response indicating the success of failure of the operation.</p>', ], ], 'ResultStream' => [ 'base' => NULL, 'refs' => [ 'GetWorkUnitResultsResponse$ResultStream' => '<p>Rows returned from the <code>GetWorkUnitResults</code> operation as a stream of Apache Arrow v1.0 messages.</p>', ], ], 'RevokePermissionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'RevokePermissionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'RowFilter' => [ 'base' => '<p>A PartiQL predicate.</p>', 'refs' => [ 'DataCellsFilter$RowFilter' => '<p>A PartiQL predicate.</p>', ], ], 'SearchDatabasesByLFTagsRequest' => [ 'base' => NULL, 'refs' => [], ], 'SearchDatabasesByLFTagsResponse' => [ 'base' => NULL, 'refs' => [], ], 'SearchTablesByLFTagsRequest' => [ 'base' => NULL, 'refs' => [], ], 'SearchTablesByLFTagsResponse' => [ 'base' => NULL, 'refs' => [], ], 'SecretAccessKeyString' => [ 'base' => NULL, 'refs' => [ 'GetTemporaryGluePartitionCredentialsResponse$SecretAccessKey' => '<p>The secret key for the temporary credentials.</p>', 'GetTemporaryGlueTableCredentialsResponse$SecretAccessKey' => '<p>The secret key for the temporary credentials.</p>', ], ], 'SessionTokenString' => [ 'base' => NULL, 'refs' => [ 'GetTemporaryGluePartitionCredentialsResponse$SessionToken' => '<p>The session token for the temporary credentials.</p>', 'GetTemporaryGlueTableCredentialsResponse$SessionToken' => '<p>The session token for the temporary credentials.</p>', ], ], 'StartQueryPlanningRequest' => [ 'base' => NULL, 'refs' => [], ], 'StartQueryPlanningResponse' => [ 'base' => '<p>A structure for the output.</p>', 'refs' => [], ], 'StartTransactionRequest' => [ 'base' => NULL, 'refs' => [], ], 'StartTransactionResponse' => [ 'base' => NULL, 'refs' => [], ], 'StatisticsNotReadyYetException' => [ 'base' => '<p>Contains details about an error related to statistics not being ready.</p>', 'refs' => [], ], 'StorageOptimizer' => [ 'base' => '<p>A structure describing the configuration and details of a storage optimizer.</p>', 'refs' => [ 'StorageOptimizerList$member' => NULL, ], ], 'StorageOptimizerConfig' => [ 'base' => NULL, 'refs' => [ 'StorageOptimizer$Config' => '<p>A map of the storage optimizer configuration. Currently contains only one key-value pair: <code>is_enabled</code> indicates true or false for acceleration.</p>', 'StorageOptimizerConfigMap$value' => NULL, ], ], 'StorageOptimizerConfigKey' => [ 'base' => NULL, 'refs' => [ 'StorageOptimizerConfig$key' => NULL, ], ], 'StorageOptimizerConfigMap' => [ 'base' => NULL, 'refs' => [ 'UpdateTableStorageOptimizerRequest$StorageOptimizerConfig' => '<p>Name of the table for which to enable the storage optimizer.</p>', ], ], 'StorageOptimizerConfigValue' => [ 'base' => NULL, 'refs' => [ 'StorageOptimizerConfig$value' => NULL, ], ], 'StorageOptimizerList' => [ 'base' => NULL, 'refs' => [ 'ListTableStorageOptimizersResponse$StorageOptimizerList' => '<p>A list of the storage optimizers associated with a table.</p>', ], ], 'String' => [ 'base' => NULL, 'refs' => [ 'QueryParameterMap$key' => NULL, 'QueryParameterMap$value' => NULL, ], ], 'StringValue' => [ 'base' => NULL, 'refs' => [ 'StringValueList$member' => NULL, ], ], 'StringValueList' => [ 'base' => NULL, 'refs' => [ 'FilterCondition$StringValueList' => '<p>A string with values used in evaluating the filter condition.</p>', ], ], 'SyntheticGetWorkUnitResultsRequestWorkUnitTokenString' => [ 'base' => NULL, 'refs' => [ 'GetWorkUnitResultsRequest$WorkUnitToken' => '<p>A work token used to query the execution service. Token output from <code>GetWorkUnits</code>.</p>', ], ], 'SyntheticStartQueryPlanningRequestQueryString' => [ 'base' => NULL, 'refs' => [ 'StartQueryPlanningRequest$QueryString' => '<p>A PartiQL query statement used as an input to the planner service.</p>', ], ], 'TableLFTagsList' => [ 'base' => NULL, 'refs' => [ 'SearchTablesByLFTagsResponse$TableList' => '<p>A list of tables that meet the LF-tag conditions.</p>', ], ], 'TableObject' => [ 'base' => '<p>Specifies the details of a governed table.</p>', 'refs' => [ 'TableObjectList$member' => NULL, ], ], 'TableObjectList' => [ 'base' => NULL, 'refs' => [ 'PartitionObjects$Objects' => '<p>A list of table objects</p>', ], ], 'TableResource' => [ 'base' => '<p>A structure for the table object. A table is a metadata definition that represents your data. You can Grant and Revoke table privileges to a principal. </p>', 'refs' => [ 'ListDataCellsFilterRequest$Table' => '<p>A table in the Glue Data Catalog.</p>', 'Resource$Table' => '<p>The table for the resource. A table is a metadata definition that represents your data. You can Grant and Revoke table privileges to a principal. </p>', 'TaggedTable$Table' => '<p>A table that has LF-tags attached to it.</p>', ], ], 'TableWildcard' => [ 'base' => '<p>A wildcard object representing every table under a database.</p>', 'refs' => [ 'TableResource$TableWildcard' => '<p>A wildcard object representing every table under a database.</p> <p>At least one of <code>TableResource$Name</code> or <code>TableResource$TableWildcard</code> is required.</p>', ], ], 'TableWithColumnsResource' => [ 'base' => '<p>A structure for a table with columns object. This object is only used when granting a SELECT permission.</p> <p>This object must take a value for at least one of <code>ColumnsNames</code>, <code>ColumnsIndexes</code>, or <code>ColumnsWildcard</code>.</p>', 'refs' => [ 'Resource$TableWithColumns' => '<p>The table with columns for the resource. A principal with permissions to this resource can select metadata from the columns of a table in the Data Catalog and the underlying data in Amazon S3.</p>', ], ], 'TagValueList' => [ 'base' => NULL, 'refs' => [ 'CreateLFTagRequest$TagValues' => '<p>A list of possible values an attribute can take.</p>', 'GetLFTagResponse$TagValues' => '<p>A list of possible values an attribute can take.</p>', 'LFTag$TagValues' => '<p>A list of possible values an attribute can take.</p>', 'LFTagKeyResource$TagValues' => '<p>A list of possible values an attribute can take.</p>', 'LFTagPair$TagValues' => '<p>A list of possible values an attribute can take.</p>', 'UpdateLFTagRequest$TagValuesToDelete' => '<p>A list of LF-tag values to delete from the LF-tag.</p>', 'UpdateLFTagRequest$TagValuesToAdd' => '<p>A list of LF-tag values to add from the LF-tag.</p>', ], ], 'TaggedDatabase' => [ 'base' => '<p>A structure describing a database resource with LF-tags.</p>', 'refs' => [ 'DatabaseLFTagsList$member' => NULL, ], ], 'TaggedTable' => [ 'base' => '<p>A structure describing a table resource with LF-tags.</p>', 'refs' => [ 'TableLFTagsList$member' => NULL, ], ], 'ThrottledException' => [ 'base' => '<p>Contains details about an error where the query request was throttled.</p>', 'refs' => [], ], 'Timestamp' => [ 'base' => NULL, 'refs' => [ 'GetTableObjectsRequest$QueryAsOfTime' => '<p>The time as of when to read the governed table contents. If not set, the most recent transaction commit time is used. Cannot be specified along with <code>TransactionId</code>.</p>', 'QueryPlanningContext$QueryAsOfTime' => '<p>The time as of when to read the table contents. If not set, the most recent transaction commit time will be used. Cannot be specified along with <code>TransactionId</code>.</p>', 'TransactionDescription$TransactionStartTime' => '<p>The time when the transaction started.</p>', 'TransactionDescription$TransactionEndTime' => '<p>The time when the transaction committed or aborted, if it is not currently active.</p>', ], ], 'Token' => [ 'base' => NULL, 'refs' => [ 'GetEffectivePermissionsForPathRequest$NextToken' => '<p>A continuation token, if this is not the first call to retrieve this list.</p>', 'GetEffectivePermissionsForPathResponse$NextToken' => '<p>A continuation token, if this is not the first call to retrieve this list.</p>', 'GetWorkUnitsRequest$NextToken' => '<p>A continuation token, if this is a continuation call.</p>', 'GetWorkUnitsResponse$NextToken' => '<p>A continuation token for paginating the returned list of tokens, returned if the current segment of the list is not the last.</p>', 'ListDataCellsFilterRequest$NextToken' => '<p>A continuation token, if this is a continuation call.</p>', 'ListDataCellsFilterResponse$NextToken' => '<p>A continuation token, if not all requested data cell filters have been returned.</p>', 'ListLFTagsRequest$NextToken' => '<p>A continuation token, if this is not the first call to retrieve this list.</p>', 'ListLFTagsResponse$NextToken' => '<p>A continuation token, present if the current list segment is not the last.</p>', 'ListPermissionsRequest$NextToken' => '<p>A continuation token, if this is not the first call to retrieve this list.</p>', 'ListPermissionsResponse$NextToken' => '<p>A continuation token, if this is not the first call to retrieve this list.</p>', 'ListResourcesRequest$NextToken' => '<p>A continuation token, if this is not the first call to retrieve these resources.</p>', 'ListResourcesResponse$NextToken' => '<p>A continuation token, if this is not the first call to retrieve these resources.</p>', 'ListTableStorageOptimizersRequest$NextToken' => '<p>A continuation token, if this is a continuation call.</p>', 'ListTableStorageOptimizersResponse$NextToken' => '<p>A continuation token for paginating the returned list of tokens, returned if the current segment of the list is not the last.</p>', 'SearchDatabasesByLFTagsRequest$NextToken' => '<p>A continuation token, if this is not the first call to retrieve this list.</p>', 'SearchDatabasesByLFTagsResponse$NextToken' => '<p>A continuation token, present if the current list segment is not the last.</p>', 'SearchTablesByLFTagsRequest$NextToken' => '<p>A continuation token, if this is not the first call to retrieve this list.</p>', 'SearchTablesByLFTagsResponse$NextToken' => '<p>A continuation token, present if the current list segment is not the last.</p>', ], ], 'TokenString' => [ 'base' => NULL, 'refs' => [ 'GetTableObjectsRequest$NextToken' => '<p>A continuation token if this is not the first call to retrieve these objects.</p>', 'GetTableObjectsResponse$NextToken' => '<p>A continuation token indicating whether additional data is available.</p>', 'ListTransactionsRequest$NextToken' => '<p>A continuation token if this is not the first call to retrieve transactions.</p>', 'ListTransactionsResponse$NextToken' => '<p>A continuation token indicating whether additional data is available.</p>', ], ], 'TransactionCanceledException' => [ 'base' => '<p>Contains details about an error related to a transaction that was cancelled.</p>', 'refs' => [], ], 'TransactionCommitInProgressException' => [ 'base' => '<p>Contains details about an error related to a transaction commit that was in progress.</p>', 'refs' => [], ], 'TransactionCommittedException' => [ 'base' => '<p>Contains details about an error where the specified transaction has already been committed and cannot be used for <code>UpdateTableObjects</code>.</p>', 'refs' => [], ], 'TransactionDescription' => [ 'base' => '<p>A structure that contains information about a transaction.</p>', 'refs' => [ 'DescribeTransactionResponse$TransactionDescription' => '<p>Returns a <code>TransactionDescription</code> object containing information about the transaction.</p>', 'TransactionDescriptionList$member' => NULL, ], ], 'TransactionDescriptionList' => [ 'base' => NULL, 'refs' => [ 'ListTransactionsResponse$Transactions' => '<p>A list of transactions. The record for each transaction is a <code>TransactionDescription</code> object.</p>', ], ], 'TransactionIdString' => [ 'base' => NULL, 'refs' => [ 'CancelTransactionRequest$TransactionId' => '<p>The transaction to cancel.</p>', 'CommitTransactionRequest$TransactionId' => '<p>The transaction to commit.</p>', 'DeleteObjectsOnCancelRequest$TransactionId' => '<p>ID of the transaction that the writes occur in.</p>', 'DescribeTransactionRequest$TransactionId' => '<p>The transaction for which to return status.</p>', 'ExtendTransactionRequest$TransactionId' => '<p>The transaction to extend.</p>', 'GetTableObjectsRequest$TransactionId' => '<p>The transaction ID at which to read the governed table contents. If this transaction has aborted, an error is returned. If not set, defaults to the most recent committed transaction. Cannot be specified along with <code>QueryAsOfTime</code>.</p>', 'QueryPlanningContext$TransactionId' => '<p>The transaction ID at which to read the table contents. If this transaction is not committed, the read will be treated as part of that transaction and will see its writes. If this transaction has aborted, an error will be returned. If not set, defaults to the most recent committed transaction. Cannot be specified along with <code>QueryAsOfTime</code>.</p>', 'StartTransactionResponse$TransactionId' => '<p>An opaque identifier for the transaction.</p>', 'TransactionDescription$TransactionId' => '<p>The ID of the transaction.</p>', 'UpdateTableObjectsRequest$TransactionId' => '<p>The transaction at which to do the write.</p>', ], ], 'TransactionStatus' => [ 'base' => NULL, 'refs' => [ 'CommitTransactionResponse$TransactionStatus' => '<p>The status of the transaction.</p>', 'TransactionDescription$TransactionStatus' => '<p>A status of ACTIVE, COMMITTED, or ABORTED.</p>', ], ], 'TransactionStatusFilter' => [ 'base' => NULL, 'refs' => [ 'ListTransactionsRequest$StatusFilter' => '<p> A filter indicating the status of transactions to return. Options are ALL | COMPLETED | COMMITTED | ABORTED | ACTIVE. The default is <code>ALL</code>.</p>', ], ], 'TransactionType' => [ 'base' => NULL, 'refs' => [ 'StartTransactionRequest$TransactionType' => '<p>Indicates whether this transaction should be read only or read and write. Writes made using a read-only transaction ID will be rejected. Read-only transactions do not need to be committed. </p>', ], ], 'TrueFalseString' => [ 'base' => NULL, 'refs' => [ 'ListPermissionsRequest$IncludeRelated' => '<p>Indicates that related permissions should be included in the results.</p>', ], ], 'TrustedResourceOwners' => [ 'base' => NULL, 'refs' => [ 'DataLakeSettings$TrustedResourceOwners' => '<p>A list of the resource-owning account IDs that the caller\'s account can use to share their user access details (user ARNs). The user ARNs can be logged in the resource owner\'s CloudTrail log.</p> <p>You may want to specify this property when you are in a high-trust boundary, such as the same team or company. </p>', ], ], 'URI' => [ 'base' => NULL, 'refs' => [ 'AddObjectInput$Uri' => '<p>The Amazon S3 location of the object.</p>', 'DeleteObjectInput$Uri' => '<p>The Amazon S3 location of the object to delete.</p>', 'TableObject$Uri' => '<p>The Amazon S3 location of the object.</p>', 'VirtualObject$Uri' => '<p>The path to the Amazon S3 object. Must start with s3://</p>', ], ], 'UpdateLFTagRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateLFTagResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateTableObjectsRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateTableObjectsResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateTableStorageOptimizerRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateTableStorageOptimizerResponse' => [ 'base' => NULL, 'refs' => [], ], 'ValueString' => [ 'base' => NULL, 'refs' => [ 'ValueStringList$member' => NULL, ], ], 'ValueStringList' => [ 'base' => NULL, 'refs' => [ 'PartitionValueList$Values' => '<p>The list of partition values.</p>', ], ], 'VirtualObject' => [ 'base' => '<p>An object that defines an Amazon S3 object to be deleted if a transaction cancels, provided that <code>VirtualPut</code> was called before writing the object.</p>', 'refs' => [ 'VirtualObjectList$member' => NULL, ], ], 'VirtualObjectList' => [ 'base' => NULL, 'refs' => [ 'DeleteObjectsOnCancelRequest$Objects' => '<p>A list of VirtualObject structures, which indicates the Amazon S3 objects to be deleted if the transaction cancels.</p>', ], ], 'WorkUnitIdLong' => [ 'base' => NULL, 'refs' => [ 'WorkUnitRange$WorkUnitIdMax' => '<p>Defines the maximum work unit ID in the range. The maximum value is inclusive.</p>', 'WorkUnitRange$WorkUnitIdMin' => '<p>Defines the minimum work unit ID in the range.</p>', ], ], 'WorkUnitRange' => [ 'base' => '<p>Defines the valid range of work unit IDs for querying the execution service.</p>', 'refs' => [ 'WorkUnitRangeList$member' => NULL, ], ], 'WorkUnitRangeList' => [ 'base' => NULL, 'refs' => [ 'GetWorkUnitsResponse$WorkUnitRanges' => '<p>A <code>WorkUnitRangeList</code> object that specifies the valid range of work unit IDs for querying the execution service.</p>', ], ], 'WorkUnitTokenString' => [ 'base' => NULL, 'refs' => [ 'WorkUnitRange$WorkUnitToken' => '<p>A work token used to query the execution service.</p>', ], ], 'WorkUnitsNotReadyYetException' => [ 'base' => '<p>Contains details about an error related to work units not being ready.</p>', 'refs' => [], ], 'WriteOperation' => [ 'base' => '<p>Defines an object to add to or delete from a governed table.</p>', 'refs' => [ 'WriteOperationList$member' => NULL, ], ], 'WriteOperationList' => [ 'base' => NULL, 'refs' => [ 'UpdateTableObjectsRequest$WriteOperations' => '<p>A list of <code>WriteOperation</code> objects that define an object to add to or delete from the manifest for a governed table.</p>', ], ], ],];
