<?php
// This file was auto-generated from sdk-root/src/data/ecr/2015-09-21/docs-2.json
return [ 'version' => '2.0', 'service' => '<fullname>Amazon Elastic Container Registry</fullname> <p>Amazon Elastic Container Registry (Amazon ECR) is a managed container image registry service. Customers can use the familiar Docker CLI, or their preferred client, to push, pull, and manage images. Amazon ECR provides a secure, scalable, and reliable registry for your Docker or Open Container Initiative (OCI) images. Amazon ECR supports private repositories with resource-based permissions using IAM so that specific users or Amazon EC2 instances can access repositories and images.</p> <p>Amazon ECR has service endpoints in each supported Region. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/ecr.html">Amazon ECR endpoints</a> in the <i>Amazon Web Services General Reference</i>.</p>', 'operations' => [ 'BatchCheckLayerAvailability' => '<p>Checks the availability of one or more image layers in a repository.</p> <p>When an image is pushed to a repository, each image layer is checked to verify if it has been uploaded before. If it has been uploaded, then the image layer is skipped.</p> <note> <p>This operation is used by the Amazon ECR proxy and is not generally used by customers for pulling and pushing images. In most cases, you should use the <code>docker</code> CLI to pull, tag, and push images.</p> </note>', 'BatchDeleteImage' => '<p>Deletes a list of specified images within a repository. Images are specified with either an <code>imageTag</code> or <code>imageDigest</code>.</p> <p>You can remove a tag from an image by specifying the image\'s tag in your request. When you remove the last tag from an image, the image is deleted from your repository.</p> <p>You can completely delete an image (and all of its tags) by specifying the image\'s digest in your request.</p>', 'BatchGetImage' => '<p>Gets detailed information for an image. Images are specified with either an <code>imageTag</code> or <code>imageDigest</code>.</p> <p>When an image is pulled, the BatchGetImage API is called once to retrieve the image manifest.</p>', 'BatchGetRepositoryScanningConfiguration' => '<p>Gets the scanning configuration for one or more repositories.</p>', 'CompleteLayerUpload' => '<p>Informs Amazon ECR that the image layer upload has completed for a specified registry, repository name, and upload ID. You can optionally provide a <code>sha256</code> digest of the image layer for data validation purposes.</p> <p>When an image is pushed, the CompleteLayerUpload API is called once per each new image layer to verify that the upload has completed.</p> <note> <p>This operation is used by the Amazon ECR proxy and is not generally used by customers for pulling and pushing images. In most cases, you should use the <code>docker</code> CLI to pull, tag, and push images.</p> </note>', 'CreatePullThroughCacheRule' => '<p>Creates a pull through cache rule. A pull through cache rule provides a way to cache images from an external public registry in your Amazon ECR private registry.</p>', 'CreateRepository' => '<p>Creates a repository. For more information, see <a href="https://docs.aws.amazon.com/AmazonECR/latest/userguide/Repositories.html">Amazon ECR repositories</a> in the <i>Amazon Elastic Container Registry User Guide</i>.</p>', 'DeleteLifecyclePolicy' => '<p>Deletes the lifecycle policy associated with the specified repository.</p>', 'DeletePullThroughCacheRule' => '<p>Deletes a pull through cache rule.</p>', 'DeleteRegistryPolicy' => '<p>Deletes the registry permissions policy.</p>', 'DeleteRepository' => '<p>Deletes a repository. If the repository contains images, you must either delete all images in the repository or use the <code>force</code> option to delete the repository.</p>', 'DeleteRepositoryPolicy' => '<p>Deletes the repository policy associated with the specified repository.</p>', 'DescribeImageReplicationStatus' => '<p>Returns the replication status for a specified image.</p>', 'DescribeImageScanFindings' => '<p>Returns the scan findings for the specified image.</p>', 'DescribeImages' => '<p>Returns metadata about the images in a repository.</p> <note> <p>Beginning with Docker version 1.9, the Docker client compresses image layers before pushing them to a V2 Docker registry. The output of the <code>docker images</code> command shows the uncompressed image size, so it may return a larger image size than the image sizes returned by <a>DescribeImages</a>.</p> </note>', 'DescribePullThroughCacheRules' => '<p>Returns the pull through cache rules for a registry.</p>', 'DescribeRegistry' => '<p>Describes the settings for a registry. The replication configuration for a repository can be created or updated with the <a>PutReplicationConfiguration</a> API action.</p>', 'DescribeRepositories' => '<p>Describes image repositories in a registry.</p>', 'GetAuthorizationToken' => '<p>Retrieves an authorization token. An authorization token represents your IAM authentication credentials and can be used to access any Amazon ECR registry that your IAM principal has access to. The authorization token is valid for 12 hours.</p> <p>The <code>authorizationToken</code> returned is a base64 encoded string that can be decoded and used in a <code>docker login</code> command to authenticate to a registry. The CLI offers an <code>get-login-password</code> command that simplifies the login process. For more information, see <a href="https://docs.aws.amazon.com/AmazonECR/latest/userguide/Registries.html#registry_auth">Registry authentication</a> in the <i>Amazon Elastic Container Registry User Guide</i>.</p>', 'GetDownloadUrlForLayer' => '<p>Retrieves the pre-signed Amazon S3 download URL corresponding to an image layer. You can only get URLs for image layers that are referenced in an image.</p> <p>When an image is pulled, the GetDownloadUrlForLayer API is called once per image layer that is not already cached.</p> <note> <p>This operation is used by the Amazon ECR proxy and is not generally used by customers for pulling and pushing images. In most cases, you should use the <code>docker</code> CLI to pull, tag, and push images.</p> </note>', 'GetLifecyclePolicy' => '<p>Retrieves the lifecycle policy for the specified repository.</p>', 'GetLifecyclePolicyPreview' => '<p>Retrieves the results of the lifecycle policy preview request for the specified repository.</p>', 'GetRegistryPolicy' => '<p>Retrieves the permissions policy for a registry.</p>', 'GetRegistryScanningConfiguration' => '<p>Retrieves the scanning configuration for a registry.</p>', 'GetRepositoryPolicy' => '<p>Retrieves the repository policy for the specified repository.</p>', 'InitiateLayerUpload' => '<p>Notifies Amazon ECR that you intend to upload an image layer.</p> <p>When an image is pushed, the InitiateLayerUpload API is called once per image layer that has not already been uploaded. Whether or not an image layer has been uploaded is determined by the BatchCheckLayerAvailability API action.</p> <note> <p>This operation is used by the Amazon ECR proxy and is not generally used by customers for pulling and pushing images. In most cases, you should use the <code>docker</code> CLI to pull, tag, and push images.</p> </note>', 'ListImages' => '<p>Lists all the image IDs for the specified repository.</p> <p>You can filter images based on whether or not they are tagged by using the <code>tagStatus</code> filter and specifying either <code>TAGGED</code>, <code>UNTAGGED</code> or <code>ANY</code>. For example, you can filter your results to return only <code>UNTAGGED</code> images and then pipe that result to a <a>BatchDeleteImage</a> operation to delete them. Or, you can filter your results to return only <code>TAGGED</code> images to list all of the tags in your repository.</p>', 'ListTagsForResource' => '<p>List the tags for an Amazon ECR resource.</p>', 'PutImage' => '<p>Creates or updates the image manifest and tags associated with an image.</p> <p>When an image is pushed and all new image layers have been uploaded, the PutImage API is called once to create or update the image manifest and the tags associated with the image.</p> <note> <p>This operation is used by the Amazon ECR proxy and is not generally used by customers for pulling and pushing images. In most cases, you should use the <code>docker</code> CLI to pull, tag, and push images.</p> </note>', 'PutImageScanningConfiguration' => '<important> <p>The <code>PutImageScanningConfiguration</code> API is being deprecated, in favor of specifying the image scanning configuration at the registry level. For more information, see <a>PutRegistryScanningConfiguration</a>.</p> </important> <p>Updates the image scanning configuration for the specified repository.</p>', 'PutImageTagMutability' => '<p>Updates the image tag mutability settings for the specified repository. For more information, see <a href="https://docs.aws.amazon.com/AmazonECR/latest/userguide/image-tag-mutability.html">Image tag mutability</a> in the <i>Amazon Elastic Container Registry User Guide</i>.</p>', 'PutLifecyclePolicy' => '<p>Creates or updates the lifecycle policy for the specified repository. For more information, see <a href="https://docs.aws.amazon.com/AmazonECR/latest/userguide/LifecyclePolicies.html">Lifecycle policy template</a>.</p>', 'PutRegistryPolicy' => '<p>Creates or updates the permissions policy for your registry.</p> <p>A registry policy is used to specify permissions for another Amazon Web Services account and is used when configuring cross-account replication. For more information, see <a href="https://docs.aws.amazon.com/AmazonECR/latest/userguide/registry-permissions.html">Registry permissions</a> in the <i>Amazon Elastic Container Registry User Guide</i>.</p>', 'PutRegistryScanningConfiguration' => '<p>Creates or updates the scanning configuration for your private registry.</p>', 'PutReplicationConfiguration' => '<p>Creates or updates the replication configuration for a registry. The existing replication configuration for a repository can be retrieved with the <a>DescribeRegistry</a> API action. The first time the PutReplicationConfiguration API is called, a service-linked IAM role is created in your account for the replication process. For more information, see <a href="https://docs.aws.amazon.com/AmazonECR/latest/userguide/using-service-linked-roles.html">Using service-linked roles for Amazon ECR</a> in the <i>Amazon Elastic Container Registry User Guide</i>.</p> <note> <p>When configuring cross-account replication, the destination account must grant the source account permission to replicate. This permission is controlled using a registry permissions policy. For more information, see <a>PutRegistryPolicy</a>.</p> </note>', 'SetRepositoryPolicy' => '<p>Applies a repository policy to the specified repository to control access permissions. For more information, see <a href="https://docs.aws.amazon.com/AmazonECR/latest/userguide/repository-policies.html">Amazon ECR Repository policies</a> in the <i>Amazon Elastic Container Registry User Guide</i>.</p>', 'StartImageScan' => '<p>Starts an image vulnerability scan. An image scan can only be started once per 24 hours on an individual image. This limit includes if an image was scanned on initial push. For more information, see <a href="https://docs.aws.amazon.com/AmazonECR/latest/userguide/image-scanning.html">Image scanning</a> in the <i>Amazon Elastic Container Registry User Guide</i>.</p>', 'StartLifecyclePolicyPreview' => '<p>Starts a preview of a lifecycle policy for the specified repository. This allows you to see the results before associating the lifecycle policy with the repository.</p>', 'TagResource' => '<p>Adds specified tags to a resource with the specified ARN. Existing tags on a resource are not changed if they are not specified in the request parameters.</p>', 'UntagResource' => '<p>Deletes specified tags from a resource.</p>', 'UploadLayerPart' => '<p>Uploads an image layer part to Amazon ECR.</p> <p>When an image is pushed, each new image layer is uploaded in parts. The maximum size of each image layer part can be 20971520 bytes (or about 20MB). The UploadLayerPart API is called once per each new image layer part.</p> <note> <p>This operation is used by the Amazon ECR proxy and is not generally used by customers for pulling and pushing images. In most cases, you should use the <code>docker</code> CLI to pull, tag, and push images.</p> </note>', ], 'shapes' => [ 'Arch' => [ 'base' => NULL, 'refs' => [ 'AwsEcrContainerImageDetails$architecture' => '<p>The architecture of the Amazon ECR container image.</p>', 'VulnerablePackage$arch' => '<p>The architecture of the vulnerable package.</p>', ], ], 'Arn' => [ 'base' => NULL, 'refs' => [ 'ListTagsForResourceRequest$resourceArn' => '<p>The Amazon Resource Name (ARN) that identifies the resource for which to list the tags. Currently, the only supported resource is an Amazon ECR repository.</p>', 'Repository$repositoryArn' => '<p>The Amazon Resource Name (ARN) that identifies the repository. The ARN contains the <code>arn:aws:ecr</code> namespace, followed by the region of the repository, Amazon Web Services account ID of the repository owner, repository namespace, and repository name. For example, <code>arn:aws:ecr:region:012345678910:repository/test</code>.</p>', 'RepositoryScanningConfiguration$repositoryArn' => '<p>The ARN of the repository.</p>', 'TagResourceRequest$resourceArn' => '<p>The Amazon Resource Name (ARN) of the the resource to which to add tags. Currently, the only supported resource is an Amazon ECR repository.</p>', 'UntagResourceRequest$resourceArn' => '<p>The Amazon Resource Name (ARN) of the resource from which to remove tags. Currently, the only supported resource is an Amazon ECR repository.</p>', ], ], 'Attribute' => [ 'base' => '<p>This data type is used in the <a>ImageScanFinding</a> data type.</p>', 'refs' => [ 'AttributeList$member' => NULL, ], ], 'AttributeKey' => [ 'base' => NULL, 'refs' => [ 'Attribute$key' => '<p>The attribute key.</p>', ], ], 'AttributeList' => [ 'base' => NULL, 'refs' => [ 'ImageScanFinding$attributes' => '<p>A collection of attributes of the host from which the finding is generated.</p>', ], ], 'AttributeValue' => [ 'base' => NULL, 'refs' => [ 'Attribute$value' => '<p>The value assigned to the attribute key.</p>', ], ], 'Author' => [ 'base' => NULL, 'refs' => [ 'AwsEcrContainerImageDetails$author' => '<p>The image author of the Amazon ECR container image.</p>', ], ], 'AuthorizationData' => [ 'base' => '<p>An object representing authorization data for an Amazon ECR registry.</p>', 'refs' => [ 'AuthorizationDataList$member' => NULL, ], ], 'AuthorizationDataList' => [ 'base' => NULL, 'refs' => [ 'GetAuthorizationTokenResponse$authorizationData' => '<p>A list of authorization token data objects that correspond to the <code>registryIds</code> values in the request.</p>', ], ], 'AwsEcrContainerImageDetails' => [ 'base' => '<p>The image details of the Amazon ECR container image.</p>', 'refs' => [ 'ResourceDetails$awsEcrContainerImage' => '<p>An object that contains details about the Amazon ECR container image involved in the finding.</p>', ], ], 'Base64' => [ 'base' => NULL, 'refs' => [ 'AuthorizationData$authorizationToken' => '<p>A base64-encoded string that contains authorization data for the specified Amazon ECR registry. When the string is decoded, it is presented in the format <code>user:password</code> for private registry authentication using <code>docker login</code>.</p>', ], ], 'BaseScore' => [ 'base' => NULL, 'refs' => [ 'CvssScore$baseScore' => '<p>The base CVSS score used for the finding.</p>', ], ], 'BatchCheckLayerAvailabilityRequest' => [ 'base' => NULL, 'refs' => [], ], 'BatchCheckLayerAvailabilityResponse' => [ 'base' => NULL, 'refs' => [], ], 'BatchDeleteImageRequest' => [ 'base' => '<p>Deletes specified images within a specified repository. Images are specified with either the <code>imageTag</code> or <code>imageDigest</code>.</p>', 'refs' => [], ], 'BatchDeleteImageResponse' => [ 'base' => NULL, 'refs' => [], ], 'BatchGetImageRequest' => [ 'base' => NULL, 'refs' => [], ], 'BatchGetImageResponse' => [ 'base' => NULL, 'refs' => [], ], 'BatchGetRepositoryScanningConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'BatchGetRepositoryScanningConfigurationResponse' => [ 'base' => NULL, 'refs' => [], ], 'BatchedOperationLayerDigest' => [ 'base' => NULL, 'refs' => [ 'BatchedOperationLayerDigestList$member' => NULL, 'LayerFailure$layerDigest' => '<p>The layer digest associated with the failure.</p>', ], ], 'BatchedOperationLayerDigestList' => [ 'base' => NULL, 'refs' => [ 'BatchCheckLayerAvailabilityRequest$layerDigests' => '<p>The digests of the image layers to check.</p>', ], ], 'CompleteLayerUploadRequest' => [ 'base' => NULL, 'refs' => [], ], 'CompleteLayerUploadResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreatePullThroughCacheRuleRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreatePullThroughCacheRuleResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateRepositoryRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateRepositoryResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreationTimestamp' => [ 'base' => NULL, 'refs' => [ 'CreatePullThroughCacheRuleResponse$createdAt' => '<p>The date and time, in JavaScript date format, when the pull through cache rule was created.</p>', 'DeletePullThroughCacheRuleResponse$createdAt' => '<p>The timestamp associated with the pull through cache rule.</p>', 'PullThroughCacheRule$createdAt' => '<p>The date and time the pull through cache was created.</p>', 'Repository$createdAt' => '<p>The date and time, in JavaScript date format, when the repository was created.</p>', ], ], 'CvssScore' => [ 'base' => '<p>The CVSS score for a finding.</p>', 'refs' => [ 'CvssScoreList$member' => NULL, ], ], 'CvssScoreAdjustment' => [ 'base' => '<p>Details on adjustments Amazon Inspector made to the CVSS score for a finding.</p>', 'refs' => [ 'CvssScoreAdjustmentList$member' => NULL, ], ], 'CvssScoreAdjustmentList' => [ 'base' => NULL, 'refs' => [ 'CvssScoreDetails$adjustments' => '<p>An object that contains details about adjustment Amazon Inspector made to the CVSS score.</p>', ], ], 'CvssScoreDetails' => [ 'base' => '<p>Information about the CVSS score.</p>', 'refs' => [ 'ScoreDetails$cvss' => '<p>An object that contains details about the CVSS score given to a finding.</p>', ], ], 'CvssScoreList' => [ 'base' => NULL, 'refs' => [ 'PackageVulnerabilityDetails$cvss' => '<p>An object that contains details about the CVSS score of a finding.</p>', ], ], 'Date' => [ 'base' => NULL, 'refs' => [ 'AwsEcrContainerImageDetails$pushedAt' => '<p>The date and time the Amazon ECR container image was pushed.</p>', 'EnhancedImageScanFinding$firstObservedAt' => '<p>The date and time that the finding was first observed.</p>', 'EnhancedImageScanFinding$lastObservedAt' => '<p>The date and time that the finding was last observed.</p>', 'EnhancedImageScanFinding$updatedAt' => '<p>The date and time the finding was last updated at.</p>', 'PackageVulnerabilityDetails$vendorCreatedAt' => '<p>The date and time that this vulnerability was first added to the vendor\'s database.</p>', 'PackageVulnerabilityDetails$vendorUpdatedAt' => '<p>The date and time the vendor last updated this vulnerability in their database.</p>', ], ], 'DeleteLifecyclePolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteLifecyclePolicyResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeletePullThroughCacheRuleRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeletePullThroughCacheRuleResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteRegistryPolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteRegistryPolicyResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteRepositoryPolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteRepositoryPolicyResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteRepositoryRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteRepositoryResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeImageReplicationStatusRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeImageReplicationStatusResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeImageScanFindingsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeImageScanFindingsResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeImagesFilter' => [ 'base' => '<p>An object representing a filter on a <a>DescribeImages</a> operation.</p>', 'refs' => [ 'DescribeImagesRequest$filter' => '<p>The filter key and value with which to filter your <code>DescribeImages</code> results.</p>', ], ], 'DescribeImagesRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeImagesResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribePullThroughCacheRulesRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribePullThroughCacheRulesResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeRegistryRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeRegistryResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeRepositoriesRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeRepositoriesResponse' => [ 'base' => NULL, 'refs' => [], ], 'EmptyUploadException' => [ 'base' => '<p>The specified layer upload does not contain any layer parts.</p>', 'refs' => [], ], 'EncryptionConfiguration' => [ 'base' => '<p>The encryption configuration for the repository. This determines how the contents of your repository are encrypted at rest.</p> <p>By default, when no encryption configuration is set or the <code>AES256</code> encryption type is used, Amazon ECR uses server-side encryption with Amazon S3-managed encryption keys which encrypts your data at rest using an AES-256 encryption algorithm. This does not require any action on your part.</p> <p>For more control over the encryption of the contents of your repository, you can use server-side encryption with Key Management Service key stored in Key Management Service (KMS) to encrypt your images. For more information, see <a href="https://docs.aws.amazon.com/AmazonECR/latest/userguide/encryption-at-rest.html">Amazon ECR encryption at rest</a> in the <i>Amazon Elastic Container Registry User Guide</i>.</p>', 'refs' => [ 'CreateRepositoryRequest$encryptionConfiguration' => '<p>The encryption configuration for the repository. This determines how the contents of your repository are encrypted at rest.</p>', 'Repository$encryptionConfiguration' => '<p>The encryption configuration for the repository. This determines how the contents of your repository are encrypted at rest.</p>', ], ], 'EncryptionType' => [ 'base' => NULL, 'refs' => [ 'EncryptionConfiguration$encryptionType' => '<p>The encryption type to use.</p> <p>If you use the <code>KMS</code> encryption type, the contents of the repository will be encrypted using server-side encryption with Key Management Service key stored in KMS. When you use KMS to encrypt your data, you can either use the default Amazon Web Services managed KMS key for Amazon ECR, or specify your own KMS key, which you already created. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingKMSEncryption.html">Protecting data using server-side encryption with an KMS key stored in Key Management Service (SSE-KMS)</a> in the <i>Amazon Simple Storage Service Console Developer Guide</i>.</p> <p>If you use the <code>AES256</code> encryption type, Amazon ECR uses server-side encryption with Amazon S3-managed encryption keys which encrypts the images in the repository using an AES-256 encryption algorithm. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingServerSideEncryption.html">Protecting data using server-side encryption with Amazon S3-managed encryption keys (SSE-S3)</a> in the <i>Amazon Simple Storage Service Console Developer Guide</i>.</p>', ], ], 'EnhancedImageScanFinding' => [ 'base' => '<p>The details of an enhanced image scan. This is returned when enhanced scanning is enabled for your private registry.</p>', 'refs' => [ 'EnhancedImageScanFindingList$member' => NULL, ], ], 'EnhancedImageScanFindingList' => [ 'base' => NULL, 'refs' => [ 'ImageScanFindings$enhancedFindings' => '<p>Details about the enhanced scan findings from Amazon Inspector.</p>', ], ], 'Epoch' => [ 'base' => NULL, 'refs' => [ 'VulnerablePackage$epoch' => '<p>The epoch of the vulnerable package.</p>', ], ], 'EvaluationTimestamp' => [ 'base' => NULL, 'refs' => [ 'DeleteLifecyclePolicyResponse$lastEvaluatedAt' => '<p>The time stamp of the last time that the lifecycle policy was run.</p>', 'GetLifecyclePolicyResponse$lastEvaluatedAt' => '<p>The time stamp of the last time that the lifecycle policy was run.</p>', ], ], 'ExceptionMessage' => [ 'base' => NULL, 'refs' => [ 'EmptyUploadException$message' => '<p>The error message associated with the exception.</p>', 'ImageAlreadyExistsException$message' => '<p>The error message associated with the exception.</p>', 'ImageDigestDoesNotMatchException$message' => NULL, 'ImageNotFoundException$message' => NULL, 'ImageTagAlreadyExistsException$message' => NULL, 'InvalidLayerException$message' => '<p>The error message associated with the exception.</p>', 'InvalidLayerPartException$message' => '<p>The error message associated with the exception.</p>', 'InvalidParameterException$message' => '<p>The error message associated with the exception.</p>', 'InvalidTagParameterException$message' => NULL, 'KmsException$message' => NULL, 'LayerAlreadyExistsException$message' => '<p>The error message associated with the exception.</p>', 'LayerInaccessibleException$message' => '<p>The error message associated with the exception.</p>', 'LayerPartTooSmallException$message' => '<p>The error message associated with the exception.</p>', 'LayersNotFoundException$message' => '<p>The error message associated with the exception.</p>', 'LifecyclePolicyNotFoundException$message' => NULL, 'LifecyclePolicyPreviewInProgressException$message' => NULL, 'LifecyclePolicyPreviewNotFoundException$message' => NULL, 'LimitExceededException$message' => '<p>The error message associated with the exception.</p>', 'PullThroughCacheRuleAlreadyExistsException$message' => NULL, 'PullThroughCacheRuleNotFoundException$message' => NULL, 'ReferencedImagesNotFoundException$message' => NULL, 'RegistryPolicyNotFoundException$message' => NULL, 'RepositoryAlreadyExistsException$message' => '<p>The error message associated with the exception.</p>', 'RepositoryNotEmptyException$message' => '<p>The error message associated with the exception.</p>', 'RepositoryNotFoundException$message' => '<p>The error message associated with the exception.</p>', 'RepositoryPolicyNotFoundException$message' => '<p>The error message associated with the exception.</p>', 'ScanNotFoundException$message' => NULL, 'ServerException$message' => '<p>The error message associated with the exception.</p>', 'TooManyTagsException$message' => NULL, 'UnsupportedImageTypeException$message' => NULL, 'UnsupportedUpstreamRegistryException$message' => NULL, 'UploadNotFoundException$message' => '<p>The error message associated with the exception.</p>', 'ValidationException$message' => NULL, ], ], 'ExpirationTimestamp' => [ 'base' => NULL, 'refs' => [ 'AuthorizationData$expiresAt' => '<p>The Unix time in seconds and milliseconds when the authorization token expires. Authorization tokens are valid for 12 hours.</p>', ], ], 'FilePath' => [ 'base' => NULL, 'refs' => [ 'VulnerablePackage$filePath' => '<p>The file path of the vulnerable package.</p>', ], ], 'FindingArn' => [ 'base' => NULL, 'refs' => [ 'EnhancedImageScanFinding$findingArn' => '<p>The Amazon Resource Number (ARN) of the finding.</p>', ], ], 'FindingDescription' => [ 'base' => NULL, 'refs' => [ 'EnhancedImageScanFinding$description' => '<p>The description of the finding.</p>', 'ImageScanFinding$description' => '<p>The description of the finding.</p>', ], ], 'FindingName' => [ 'base' => NULL, 'refs' => [ 'ImageScanFinding$name' => '<p>The name associated with the finding, usually a CVE number.</p>', ], ], 'FindingSeverity' => [ 'base' => NULL, 'refs' => [ 'FindingSeverityCounts$key' => NULL, 'ImageScanFinding$severity' => '<p>The finding severity.</p>', ], ], 'FindingSeverityCounts' => [ 'base' => NULL, 'refs' => [ 'ImageScanFindings$findingSeverityCounts' => '<p>The image vulnerability counts, sorted by severity.</p>', 'ImageScanFindingsSummary$findingSeverityCounts' => '<p>The image vulnerability counts, sorted by severity.</p>', ], ], 'ForceFlag' => [ 'base' => NULL, 'refs' => [ 'DeleteRepositoryRequest$force' => '<p> If a repository contains images, forces the deletion.</p>', 'SetRepositoryPolicyRequest$force' => '<p>If the policy you are attempting to set on a repository policy would prevent you from setting another policy in the future, you must force the <a>SetRepositoryPolicy</a> operation. This is intended to prevent accidental repository lock outs.</p>', ], ], 'GetAuthorizationTokenRegistryIdList' => [ 'base' => NULL, 'refs' => [ 'GetAuthorizationTokenRequest$registryIds' => '<p>A list of Amazon Web Services account IDs that are associated with the registries for which to get AuthorizationData objects. If you do not specify a registry, the default registry is assumed.</p>', ], ], 'GetAuthorizationTokenRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetAuthorizationTokenResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetDownloadUrlForLayerRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetDownloadUrlForLayerResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetLifecyclePolicyPreviewRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetLifecyclePolicyPreviewResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetLifecyclePolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetLifecyclePolicyResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetRegistryPolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetRegistryPolicyResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetRegistryScanningConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetRegistryScanningConfigurationResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetRepositoryPolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetRepositoryPolicyResponse' => [ 'base' => NULL, 'refs' => [], ], 'Image' => [ 'base' => '<p>An object representing an Amazon ECR image.</p>', 'refs' => [ 'ImageList$member' => NULL, 'PutImageResponse$image' => '<p>Details of the image uploaded.</p>', ], ], 'ImageActionType' => [ 'base' => NULL, 'refs' => [ 'LifecyclePolicyRuleAction$type' => '<p>The type of action to be taken.</p>', ], ], 'ImageAlreadyExistsException' => [ 'base' => '<p>The specified image has already been pushed, and there were no changes to the manifest or image tag after the last push.</p>', 'refs' => [], ], 'ImageCount' => [ 'base' => NULL, 'refs' => [ 'LifecyclePolicyPreviewSummary$expiringImageTotalCount' => '<p>The number of expiring images.</p>', ], ], 'ImageDetail' => [ 'base' => '<p>An object that describes an image returned by a <a>DescribeImages</a> operation.</p>', 'refs' => [ 'ImageDetailList$member' => NULL, ], ], 'ImageDetailList' => [ 'base' => NULL, 'refs' => [ 'DescribeImagesResponse$imageDetails' => '<p>A list of <a>ImageDetail</a> objects that contain data about the image.</p>', ], ], 'ImageDigest' => [ 'base' => NULL, 'refs' => [ 'AwsEcrContainerImageDetails$imageHash' => '<p>The image hash of the Amazon ECR container image.</p>', 'ImageDetail$imageDigest' => '<p>The <code>sha256</code> digest of the image manifest.</p>', 'ImageIdentifier$imageDigest' => '<p>The <code>sha256</code> digest of the image manifest.</p>', 'LifecyclePolicyPreviewResult$imageDigest' => '<p>The <code>sha256</code> digest of the image manifest.</p>', 'PutImageRequest$imageDigest' => '<p>The image digest of the image manifest corresponding to the image.</p>', ], ], 'ImageDigestDoesNotMatchException' => [ 'base' => '<p>The specified image digest does not match the digest that Amazon ECR calculated for the image.</p>', 'refs' => [], ], 'ImageFailure' => [ 'base' => '<p>An object representing an Amazon ECR image failure.</p>', 'refs' => [ 'ImageFailureList$member' => NULL, ], ], 'ImageFailureCode' => [ 'base' => NULL, 'refs' => [ 'ImageFailure$failureCode' => '<p>The code associated with the failure.</p>', ], ], 'ImageFailureList' => [ 'base' => NULL, 'refs' => [ 'BatchDeleteImageResponse$failures' => '<p>Any failures associated with the call.</p>', 'BatchGetImageResponse$failures' => '<p>Any failures associated with the call.</p>', ], ], 'ImageFailureReason' => [ 'base' => NULL, 'refs' => [ 'ImageFailure$failureReason' => '<p>The reason for the failure.</p>', ], ], 'ImageIdentifier' => [ 'base' => '<p>An object with identifying information for an image in an Amazon ECR repository.</p>', 'refs' => [ 'DescribeImageReplicationStatusRequest$imageId' => NULL, 'DescribeImageReplicationStatusResponse$imageId' => NULL, 'DescribeImageScanFindingsRequest$imageId' => NULL, 'DescribeImageScanFindingsResponse$imageId' => NULL, 'Image$imageId' => '<p>An object containing the image tag and image digest associated with an image.</p>', 'ImageFailure$imageId' => '<p>The image ID associated with the failure.</p>', 'ImageIdentifierList$member' => NULL, 'StartImageScanRequest$imageId' => NULL, 'StartImageScanResponse$imageId' => NULL, ], ], 'ImageIdentifierList' => [ 'base' => NULL, 'refs' => [ 'BatchDeleteImageRequest$imageIds' => '<p>A list of image ID references that correspond to images to delete. The format of the <code>imageIds</code> reference is <code>imageTag=tag</code> or <code>imageDigest=digest</code>.</p>', 'BatchDeleteImageResponse$imageIds' => '<p>The image IDs of the deleted images.</p>', 'BatchGetImageRequest$imageIds' => '<p>A list of image ID references that correspond to images to describe. The format of the <code>imageIds</code> reference is <code>imageTag=tag</code> or <code>imageDigest=digest</code>.</p>', 'DescribeImagesRequest$imageIds' => '<p>The list of image IDs for the requested repository.</p>', 'GetLifecyclePolicyPreviewRequest$imageIds' => '<p>The list of imageIDs to be included.</p>', 'ListImagesResponse$imageIds' => '<p>The list of image IDs for the requested repository.</p>', ], ], 'ImageList' => [ 'base' => NULL, 'refs' => [ 'BatchGetImageResponse$images' => '<p>A list of image objects corresponding to the image references in the request.</p>', ], ], 'ImageManifest' => [ 'base' => NULL, 'refs' => [ 'Image$imageManifest' => '<p>The image manifest associated with the image.</p>', 'PutImageRequest$imageManifest' => '<p>The image manifest corresponding to the image to be uploaded.</p>', ], ], 'ImageNotFoundException' => [ 'base' => '<p>The image requested does not exist in the specified repository.</p>', 'refs' => [], ], 'ImageReplicationStatus' => [ 'base' => '<p>The status of the replication process for an image.</p>', 'refs' => [ 'ImageReplicationStatusList$member' => NULL, ], ], 'ImageReplicationStatusList' => [ 'base' => NULL, 'refs' => [ 'DescribeImageReplicationStatusResponse$replicationStatuses' => '<p>The replication status details for the images in the specified repository.</p>', ], ], 'ImageScanFinding' => [ 'base' => '<p>Contains information about an image scan finding.</p>', 'refs' => [ 'ImageScanFindingList$member' => NULL, ], ], 'ImageScanFindingList' => [ 'base' => NULL, 'refs' => [ 'ImageScanFindings$findings' => '<p>The findings from the image scan.</p>', ], ], 'ImageScanFindings' => [ 'base' => '<p>The details of an image scan.</p>', 'refs' => [ 'DescribeImageScanFindingsResponse$imageScanFindings' => '<p>The information contained in the image scan findings.</p>', ], ], 'ImageScanFindingsSummary' => [ 'base' => '<p>A summary of the last completed image scan.</p>', 'refs' => [ 'ImageDetail$imageScanFindingsSummary' => '<p>A summary of the last completed image scan.</p>', ], ], 'ImageScanStatus' => [ 'base' => '<p>The current status of an image scan.</p>', 'refs' => [ 'DescribeImageScanFindingsResponse$imageScanStatus' => '<p>The current state of the scan.</p>', 'ImageDetail$imageScanStatus' => '<p>The current state of the scan.</p>', 'StartImageScanResponse$imageScanStatus' => '<p>The current state of the scan.</p>', ], ], 'ImageScanningConfiguration' => [ 'base' => '<p>The image scanning configuration for a repository.</p>', 'refs' => [ 'CreateRepositoryRequest$imageScanningConfiguration' => '<p>The image scanning configuration for the repository. This determines whether images are scanned for known vulnerabilities after being pushed to the repository.</p>', 'PutImageScanningConfigurationRequest$imageScanningConfiguration' => '<p>The image scanning configuration for the repository. This setting determines whether images are scanned for known vulnerabilities after being pushed to the repository.</p>', 'PutImageScanningConfigurationResponse$imageScanningConfiguration' => '<p>The image scanning configuration setting for the repository.</p>', 'Repository$imageScanningConfiguration' => NULL, ], ], 'ImageSizeInBytes' => [ 'base' => NULL, 'refs' => [ 'ImageDetail$imageSizeInBytes' => '<p>The size, in bytes, of the image in the repository.</p> <p>If the image is a manifest list, this will be the max size of all manifests in the list.</p> <note> <p>Beginning with Docker version 1.9, the Docker client compresses image layers before pushing them to a V2 Docker registry. The output of the <code>docker images</code> command shows the uncompressed image size, so it may return a larger image size than the image sizes returned by <a>DescribeImages</a>.</p> </note>', ], ], 'ImageTag' => [ 'base' => NULL, 'refs' => [ 'ImageIdentifier$imageTag' => '<p>The tag used for the image.</p>', 'ImageTagList$member' => NULL, 'ImageTagsList$member' => NULL, 'PutImageRequest$imageTag' => '<p>The tag to associate with the image. This parameter is required for images that use the Docker Image Manifest V2 Schema 2 or Open Container Initiative (OCI) formats.</p>', ], ], 'ImageTagAlreadyExistsException' => [ 'base' => '<p>The specified image is tagged with a tag that already exists. The repository is configured for tag immutability.</p>', 'refs' => [], ], 'ImageTagList' => [ 'base' => NULL, 'refs' => [ 'ImageDetail$imageTags' => '<p>The list of tags associated with this image.</p>', 'LifecyclePolicyPreviewResult$imageTags' => '<p>The list of tags associated with this image.</p>', ], ], 'ImageTagMutability' => [ 'base' => NULL, 'refs' => [ 'CreateRepositoryRequest$imageTagMutability' => '<p>The tag mutability setting for the repository. If this parameter is omitted, the default setting of <code>MUTABLE</code> will be used which will allow image tags to be overwritten. If <code>IMMUTABLE</code> is specified, all image tags within the repository will be immutable which will prevent them from being overwritten.</p>', 'PutImageTagMutabilityRequest$imageTagMutability' => '<p>The tag mutability setting for the repository. If <code>MUTABLE</code> is specified, image tags can be overwritten. If <code>IMMUTABLE</code> is specified, all image tags within the repository will be immutable which will prevent them from being overwritten.</p>', 'PutImageTagMutabilityResponse$imageTagMutability' => '<p>The image tag mutability setting for the repository.</p>', 'Repository$imageTagMutability' => '<p>The tag mutability setting for the repository.</p>', ], ], 'ImageTagsList' => [ 'base' => NULL, 'refs' => [ 'AwsEcrContainerImageDetails$imageTags' => '<p>The image tags attached to the Amazon ECR container image.</p>', ], ], 'InitiateLayerUploadRequest' => [ 'base' => NULL, 'refs' => [], ], 'InitiateLayerUploadResponse' => [ 'base' => NULL, 'refs' => [], ], 'InvalidLayerException' => [ 'base' => '<p>The layer digest calculation performed by Amazon ECR upon receipt of the image layer does not match the digest specified.</p>', 'refs' => [], ], 'InvalidLayerPartException' => [ 'base' => '<p>The layer part size is not valid, or the first byte specified is not consecutive to the last byte of a previous layer part upload.</p>', 'refs' => [], ], 'InvalidParameterException' => [ 'base' => '<p>The specified parameter is invalid. Review the available parameters for the API request.</p>', 'refs' => [], ], 'InvalidTagParameterException' => [ 'base' => '<p>An invalid parameter has been specified. Tag keys can have a maximum character length of 128 characters, and tag values can have a maximum length of 256 characters.</p>', 'refs' => [], ], 'KmsError' => [ 'base' => NULL, 'refs' => [ 'KmsException$kmsError' => '<p>The error code returned by KMS.</p>', ], ], 'KmsException' => [ 'base' => '<p>The operation failed due to a KMS exception.</p>', 'refs' => [], ], 'KmsKey' => [ 'base' => NULL, 'refs' => [ 'EncryptionConfiguration$kmsKey' => '<p>If you use the <code>KMS</code> encryption type, specify the KMS key to use for encryption. The alias, key ID, or full ARN of the KMS key can be specified. The key must exist in the same Region as the repository. If no key is specified, the default Amazon Web Services managed KMS key for Amazon ECR will be used.</p>', ], ], 'Layer' => [ 'base' => '<p>An object representing an Amazon ECR image layer.</p>', 'refs' => [ 'LayerList$member' => NULL, ], ], 'LayerAlreadyExistsException' => [ 'base' => '<p>The image layer already exists in the associated repository.</p>', 'refs' => [], ], 'LayerAvailability' => [ 'base' => NULL, 'refs' => [ 'Layer$layerAvailability' => '<p>The availability status of the image layer.</p>', ], ], 'LayerDigest' => [ 'base' => NULL, 'refs' => [ 'CompleteLayerUploadResponse$layerDigest' => '<p>The <code>sha256</code> digest of the image layer.</p>', 'GetDownloadUrlForLayerRequest$layerDigest' => '<p>The digest of the image layer to download.</p>', 'GetDownloadUrlForLayerResponse$layerDigest' => '<p>The digest of the image layer to download.</p>', 'Layer$layerDigest' => '<p>The <code>sha256</code> digest of the image layer.</p>', 'LayerDigestList$member' => NULL, ], ], 'LayerDigestList' => [ 'base' => NULL, 'refs' => [ 'CompleteLayerUploadRequest$layerDigests' => '<p>The <code>sha256</code> digest of the image layer.</p>', ], ], 'LayerFailure' => [ 'base' => '<p>An object representing an Amazon ECR image layer failure.</p>', 'refs' => [ 'LayerFailureList$member' => NULL, ], ], 'LayerFailureCode' => [ 'base' => NULL, 'refs' => [ 'LayerFailure$failureCode' => '<p>The failure code associated with the failure.</p>', ], ], 'LayerFailureList' => [ 'base' => NULL, 'refs' => [ 'BatchCheckLayerAvailabilityResponse$failures' => '<p>Any failures associated with the call.</p>', ], ], 'LayerFailureReason' => [ 'base' => NULL, 'refs' => [ 'LayerFailure$failureReason' => '<p>The reason for the failure.</p>', ], ], 'LayerInaccessibleException' => [ 'base' => '<p>The specified layer is not available because it is not associated with an image. Unassociated image layers may be cleaned up at any time.</p>', 'refs' => [], ], 'LayerList' => [ 'base' => NULL, 'refs' => [ 'BatchCheckLayerAvailabilityResponse$layers' => '<p>A list of image layer objects corresponding to the image layer references in the request.</p>', ], ], 'LayerPartBlob' => [ 'base' => NULL, 'refs' => [ 'UploadLayerPartRequest$layerPartBlob' => '<p>The base64-encoded layer part payload.</p>', ], ], 'LayerPartTooSmallException' => [ 'base' => '<p>Layer parts must be at least 5 MiB in size.</p>', 'refs' => [], ], 'LayerSizeInBytes' => [ 'base' => NULL, 'refs' => [ 'Layer$layerSize' => '<p>The size, in bytes, of the image layer.</p>', ], ], 'LayersNotFoundException' => [ 'base' => '<p>The specified layers could not be found, or the specified layer is not valid for this repository.</p>', 'refs' => [], ], 'LifecyclePolicyNotFoundException' => [ 'base' => '<p>The lifecycle policy could not be found, and no policy is set to the repository.</p>', 'refs' => [], ], 'LifecyclePolicyPreviewFilter' => [ 'base' => '<p>The filter for the lifecycle policy preview.</p>', 'refs' => [ 'GetLifecyclePolicyPreviewRequest$filter' => '<p>An optional parameter that filters results based on image tag status and all tags, if tagged.</p>', ], ], 'LifecyclePolicyPreviewInProgressException' => [ 'base' => '<p>The previous lifecycle policy preview request has not completed. Wait and try again.</p>', 'refs' => [], ], 'LifecyclePolicyPreviewNotFoundException' => [ 'base' => '<p>There is no dry run for this repository.</p>', 'refs' => [], ], 'LifecyclePolicyPreviewResult' => [ 'base' => '<p>The result of the lifecycle policy preview.</p>', 'refs' => [ 'LifecyclePolicyPreviewResultList$member' => NULL, ], ], 'LifecyclePolicyPreviewResultList' => [ 'base' => NULL, 'refs' => [ 'GetLifecyclePolicyPreviewResponse$previewResults' => '<p>The results of the lifecycle policy preview request.</p>', ], ], 'LifecyclePolicyPreviewStatus' => [ 'base' => NULL, 'refs' => [ 'GetLifecyclePolicyPreviewResponse$status' => '<p>The status of the lifecycle policy preview request.</p>', 'StartLifecyclePolicyPreviewResponse$status' => '<p>The status of the lifecycle policy preview request.</p>', ], ], 'LifecyclePolicyPreviewSummary' => [ 'base' => '<p>The summary of the lifecycle policy preview request.</p>', 'refs' => [ 'GetLifecyclePolicyPreviewResponse$summary' => '<p>The list of images that is returned as a result of the action.</p>', ], ], 'LifecyclePolicyRuleAction' => [ 'base' => '<p>The type of action to be taken.</p>', 'refs' => [ 'LifecyclePolicyPreviewResult$action' => '<p>The type of action to be taken.</p>', ], ], 'LifecyclePolicyRulePriority' => [ 'base' => NULL, 'refs' => [ 'LifecyclePolicyPreviewResult$appliedRulePriority' => '<p>The priority of the applied rule.</p>', ], ], 'LifecyclePolicyText' => [ 'base' => NULL, 'refs' => [ 'DeleteLifecyclePolicyResponse$lifecyclePolicyText' => '<p>The JSON lifecycle policy text.</p>', 'GetLifecyclePolicyPreviewResponse$lifecyclePolicyText' => '<p>The JSON lifecycle policy text.</p>', 'GetLifecyclePolicyResponse$lifecyclePolicyText' => '<p>The JSON lifecycle policy text.</p>', 'PutLifecyclePolicyRequest$lifecyclePolicyText' => '<p>The JSON repository policy text to apply to the repository.</p>', 'PutLifecyclePolicyResponse$lifecyclePolicyText' => '<p>The JSON repository policy text.</p>', 'StartLifecyclePolicyPreviewRequest$lifecyclePolicyText' => '<p>The policy to be evaluated against. If you do not specify a policy, the current policy for the repository is used.</p>', 'StartLifecyclePolicyPreviewResponse$lifecyclePolicyText' => '<p>The JSON repository policy text.</p>', ], ], 'LifecyclePreviewMaxResults' => [ 'base' => NULL, 'refs' => [ 'GetLifecyclePolicyPreviewRequest$maxResults' => '<p>The maximum number of repository results returned by <code>GetLifecyclePolicyPreviewRequest</code> in&#x2028; paginated output. When this parameter is used, <code>GetLifecyclePolicyPreviewRequest</code> only returns&#x2028; <code>maxResults</code> results in a single page along with a <code>nextToken</code>&#x2028; response element. The remaining results of the initial request can be seen by sending&#x2028; another <code>GetLifecyclePolicyPreviewRequest</code> request with the returned <code>nextToken</code>&#x2028; value. This value can be between 1 and 1000. If this&#x2028; parameter is not used, then <code>GetLifecyclePolicyPreviewRequest</code> returns up to&#x2028; 100 results and a <code>nextToken</code> value, if&#x2028; applicable. This option cannot be used when you specify images with <code>imageIds</code>.</p>', ], ], 'LimitExceededException' => [ 'base' => '<p>The operation did not succeed because it would have exceeded a service limit for your account. For more information, see <a href="https://docs.aws.amazon.com/AmazonECR/latest/userguide/service-quotas.html">Amazon ECR service quotas</a> in the Amazon Elastic Container Registry User Guide.</p>', 'refs' => [], ], 'ListImagesFilter' => [ 'base' => '<p>An object representing a filter on a <a>ListImages</a> operation.</p>', 'refs' => [ 'ListImagesRequest$filter' => '<p>The filter key and value with which to filter your <code>ListImages</code> results.</p>', ], ], 'ListImagesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListImagesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'MaxResults' => [ 'base' => NULL, 'refs' => [ 'DescribeImageScanFindingsRequest$maxResults' => '<p>The maximum number of image scan results returned by <code>DescribeImageScanFindings</code> in paginated output. When this parameter is used, <code>DescribeImageScanFindings</code> only returns <code>maxResults</code> results in a single page along with a <code>nextToken</code> response element. The remaining results of the initial request can be seen by sending another <code>DescribeImageScanFindings</code> request with the returned <code>nextToken</code> value. This value can be between 1 and 1000. If this parameter is not used, then <code>DescribeImageScanFindings</code> returns up to 100 results and a <code>nextToken</code> value, if applicable.</p>', 'DescribeImagesRequest$maxResults' => '<p>The maximum number of repository results returned by <code>DescribeImages</code> in paginated output. When this parameter is used, <code>DescribeImages</code> only returns <code>maxResults</code> results in a single page along with a <code>nextToken</code> response element. The remaining results of the initial request can be seen by sending another <code>DescribeImages</code> request with the returned <code>nextToken</code> value. This value can be between 1 and 1000. If this parameter is not used, then <code>DescribeImages</code> returns up to 100 results and a <code>nextToken</code> value, if applicable. This option cannot be used when you specify images with <code>imageIds</code>.</p>', 'DescribePullThroughCacheRulesRequest$maxResults' => '<p>The maximum number of pull through cache rules returned by <code>DescribePullThroughCacheRulesRequest</code> in paginated output. When this parameter is used, <code>DescribePullThroughCacheRulesRequest</code> only returns <code>maxResults</code> results in a single page along with a <code>nextToken</code> response element. The remaining results of the initial request can be seen by sending another <code>DescribePullThroughCacheRulesRequest</code> request with the returned <code>nextToken</code> value. This value can be between 1 and 1000. If this parameter is not used, then <code>DescribePullThroughCacheRulesRequest</code> returns up to 100 results and a <code>nextToken</code> value, if applicable.</p>', 'DescribeRepositoriesRequest$maxResults' => '<p>The maximum number of repository results returned by <code>DescribeRepositories</code> in paginated output. When this parameter is used, <code>DescribeRepositories</code> only returns <code>maxResults</code> results in a single page along with a <code>nextToken</code> response element. The remaining results of the initial request can be seen by sending another <code>DescribeRepositories</code> request with the returned <code>nextToken</code> value. This value can be between 1 and 1000. If this parameter is not used, then <code>DescribeRepositories</code> returns up to 100 results and a <code>nextToken</code> value, if applicable. This option cannot be used when you specify repositories with <code>repositoryNames</code>.</p>', 'ListImagesRequest$maxResults' => '<p>The maximum number of image results returned by <code>ListImages</code> in paginated output. When this parameter is used, <code>ListImages</code> only returns <code>maxResults</code> results in a single page along with a <code>nextToken</code> response element. The remaining results of the initial request can be seen by sending another <code>ListImages</code> request with the returned <code>nextToken</code> value. This value can be between 1 and 1000. If this parameter is not used, then <code>ListImages</code> returns up to 100 results and a <code>nextToken</code> value, if applicable.</p>', ], ], 'MediaType' => [ 'base' => NULL, 'refs' => [ 'Image$imageManifestMediaType' => '<p>The manifest media type of the image.</p>', 'ImageDetail$imageManifestMediaType' => '<p>The media type of the image manifest.</p>', 'ImageDetail$artifactMediaType' => '<p>The artifact media type of the image.</p>', 'Layer$mediaType' => '<p>The media type of the layer, such as <code>application/vnd.docker.image.rootfs.diff.tar.gzip</code> or <code>application/vnd.oci.image.layer.v1.tar+gzip</code>.</p>', 'MediaTypeList$member' => NULL, 'PutImageRequest$imageManifestMediaType' => '<p>The media type of the image manifest. If you push an image manifest that does not contain the <code>mediaType</code> field, you must specify the <code>imageManifestMediaType</code> in the request.</p>', ], ], 'MediaTypeList' => [ 'base' => NULL, 'refs' => [ 'BatchGetImageRequest$acceptedMediaTypes' => '<p>The accepted media types for the request.</p> <p>Valid values: <code>application/vnd.docker.distribution.manifest.v1+json</code> | <code>application/vnd.docker.distribution.manifest.v2+json</code> | <code>application/vnd.oci.image.manifest.v1+json</code> </p>', ], ], 'Metric' => [ 'base' => NULL, 'refs' => [ 'CvssScoreAdjustment$metric' => '<p>The metric used to adjust the CVSS score.</p>', ], ], 'NextToken' => [ 'base' => NULL, 'refs' => [ 'DescribeImageScanFindingsRequest$nextToken' => '<p>The <code>nextToken</code> value returned from a previous paginated <code>DescribeImageScanFindings</code> request where <code>maxResults</code> was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the <code>nextToken</code> value. This value is null when there are no more results to return.</p>', 'DescribeImageScanFindingsResponse$nextToken' => '<p>The <code>nextToken</code> value to include in a future <code>DescribeImageScanFindings</code> request. When the results of a <code>DescribeImageScanFindings</code> request exceed <code>maxResults</code>, this value can be used to retrieve the next page of results. This value is null when there are no more results to return.</p>', 'DescribeImagesRequest$nextToken' => '<p>The <code>nextToken</code> value returned from a previous paginated <code>DescribeImages</code> request where <code>maxResults</code> was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the <code>nextToken</code> value. This value is <code>null</code> when there are no more results to return. This option cannot be used when you specify images with <code>imageIds</code>.</p>', 'DescribeImagesResponse$nextToken' => '<p>The <code>nextToken</code> value to include in a future <code>DescribeImages</code> request. When the results of a <code>DescribeImages</code> request exceed <code>maxResults</code>, this value can be used to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>', 'DescribePullThroughCacheRulesRequest$nextToken' => '<p>The <code>nextToken</code> value returned from a previous paginated <code>DescribePullThroughCacheRulesRequest</code> request where <code>maxResults</code> was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the <code>nextToken</code> value. This value is null when there are no more results to return.</p>', 'DescribePullThroughCacheRulesResponse$nextToken' => '<p>The <code>nextToken</code> value to include in a future <code>DescribePullThroughCacheRulesRequest</code> request. When the results of a <code>DescribePullThroughCacheRulesRequest</code> request exceed <code>maxResults</code>, this value can be used to retrieve the next page of results. This value is null when there are no more results to return.</p>', 'DescribeRepositoriesRequest$nextToken' => '<p>The <code>nextToken</code> value returned from a previous paginated <code>DescribeRepositories</code> request where <code>maxResults</code> was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the <code>nextToken</code> value. This value is <code>null</code> when there are no more results to return. This option cannot be used when you specify repositories with <code>repositoryNames</code>.</p> <note> <p>This token should be treated as an opaque identifier that is only used to retrieve the next items in a list and not for other programmatic purposes.</p> </note>', 'DescribeRepositoriesResponse$nextToken' => '<p>The <code>nextToken</code> value to include in a future <code>DescribeRepositories</code> request. When the results of a <code>DescribeRepositories</code> request exceed <code>maxResults</code>, this value can be used to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>', 'GetLifecyclePolicyPreviewRequest$nextToken' => '<p>The <code>nextToken</code> value returned from a previous paginated&#x2028; <code>GetLifecyclePolicyPreviewRequest</code> request where <code>maxResults</code> was used and the&#x2028; results exceeded the value of that parameter. Pagination continues from the end of the&#x2028; previous results that returned the <code>nextToken</code> value. This value is&#x2028; <code>null</code> when there are no more results to return. This option cannot be used when you specify images with <code>imageIds</code>.</p>', 'GetLifecyclePolicyPreviewResponse$nextToken' => '<p>The <code>nextToken</code> value to include in a future <code>GetLifecyclePolicyPreview</code> request. When the results of a <code>GetLifecyclePolicyPreview</code> request exceed <code>maxResults</code>, this value can be used to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>', 'ListImagesRequest$nextToken' => '<p>The <code>nextToken</code> value returned from a previous paginated <code>ListImages</code> request where <code>maxResults</code> was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the <code>nextToken</code> value. This value is <code>null</code> when there are no more results to return.</p> <note> <p>This token should be treated as an opaque identifier that is only used to retrieve the next items in a list and not for other programmatic purposes.</p> </note>', 'ListImagesResponse$nextToken' => '<p>The <code>nextToken</code> value to include in a future <code>ListImages</code> request. When the results of a <code>ListImages</code> request exceed <code>maxResults</code>, this value can be used to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>', ], ], 'PackageManager' => [ 'base' => NULL, 'refs' => [ 'VulnerablePackage$packageManager' => '<p>The package manager of the vulnerable package.</p>', ], ], 'PackageVulnerabilityDetails' => [ 'base' => '<p>Information about a package vulnerability finding.</p>', 'refs' => [ 'EnhancedImageScanFinding$packageVulnerabilityDetails' => '<p>An object that contains the details of a package vulnerability finding.</p>', ], ], 'PartSize' => [ 'base' => NULL, 'refs' => [ 'InitiateLayerUploadResponse$partSize' => '<p>The size, in bytes, that Amazon ECR expects future layer part uploads to be.</p>', 'InvalidLayerPartException$lastValidByteReceived' => '<p>The last valid byte received from the layer part upload that is associated with the exception.</p>', 'UploadLayerPartRequest$partFirstByte' => '<p>The position of the first byte of the layer part witin the overall image layer.</p>', 'UploadLayerPartRequest$partLastByte' => '<p>The position of the last byte of the layer part within the overall image layer.</p>', 'UploadLayerPartResponse$lastByteReceived' => '<p>The integer value of the last byte received in the request.</p>', ], ], 'Platform' => [ 'base' => NULL, 'refs' => [ 'AwsEcrContainerImageDetails$platform' => '<p>The platform of the Amazon ECR container image.</p>', ], ], 'ProxyEndpoint' => [ 'base' => NULL, 'refs' => [ 'AuthorizationData$proxyEndpoint' => '<p>The registry URL to use for this authorization token in a <code>docker login</code> command. The Amazon ECR registry URL format is <code>https://aws_account_id.dkr.ecr.region.amazonaws.com</code>. For example, <code>https://012345678910.dkr.ecr.us-east-1.amazonaws.com</code>.. </p>', ], ], 'PullThroughCacheRule' => [ 'base' => '<p>The details of a pull through cache rule.</p>', 'refs' => [ 'PullThroughCacheRuleList$member' => NULL, ], ], 'PullThroughCacheRuleAlreadyExistsException' => [ 'base' => '<p>A pull through cache rule with these settings already exists for the private registry.</p>', 'refs' => [], ], 'PullThroughCacheRuleList' => [ 'base' => NULL, 'refs' => [ 'DescribePullThroughCacheRulesResponse$pullThroughCacheRules' => '<p>The details of the pull through cache rules.</p>', ], ], 'PullThroughCacheRuleNotFoundException' => [ 'base' => '<p>The pull through cache rule was not found. Specify a valid pull through cache rule and try again.</p>', 'refs' => [], ], 'PullThroughCacheRuleRepositoryPrefix' => [ 'base' => NULL, 'refs' => [ 'CreatePullThroughCacheRuleRequest$ecrRepositoryPrefix' => '<p>The repository name prefix to use when caching images from the source registry.</p>', 'CreatePullThroughCacheRuleResponse$ecrRepositoryPrefix' => '<p>The Amazon ECR repository prefix associated with the pull through cache rule.</p>', 'DeletePullThroughCacheRuleRequest$ecrRepositoryPrefix' => '<p>The Amazon ECR repository prefix associated with the pull through cache rule to delete.</p>', 'DeletePullThroughCacheRuleResponse$ecrRepositoryPrefix' => '<p>The Amazon ECR repository prefix associated with the request.</p>', 'PullThroughCacheRule$ecrRepositoryPrefix' => '<p>The Amazon ECR repository prefix associated with the pull through cache rule.</p>', 'PullThroughCacheRuleRepositoryPrefixList$member' => NULL, ], ], 'PullThroughCacheRuleRepositoryPrefixList' => [ 'base' => NULL, 'refs' => [ 'DescribePullThroughCacheRulesRequest$ecrRepositoryPrefixes' => '<p>The Amazon ECR repository prefixes associated with the pull through cache rules to return. If no repository prefix value is specified, all pull through cache rules are returned.</p>', ], ], 'PushTimestamp' => [ 'base' => NULL, 'refs' => [ 'ImageDetail$imagePushedAt' => '<p>The date and time, expressed in standard JavaScript date format, at which the current image was pushed to the repository. </p>', 'LifecyclePolicyPreviewResult$imagePushedAt' => '<p>The date and time, expressed in standard JavaScript date format, at which the current image was pushed to the repository.</p>', ], ], 'PutImageRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutImageResponse' => [ 'base' => NULL, 'refs' => [], ], 'PutImageScanningConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutImageScanningConfigurationResponse' => [ 'base' => NULL, 'refs' => [], ], 'PutImageTagMutabilityRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutImageTagMutabilityResponse' => [ 'base' => NULL, 'refs' => [], ], 'PutLifecyclePolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutLifecyclePolicyResponse' => [ 'base' => NULL, 'refs' => [], ], 'PutRegistryPolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutRegistryPolicyResponse' => [ 'base' => NULL, 'refs' => [], ], 'PutRegistryScanningConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutRegistryScanningConfigurationResponse' => [ 'base' => NULL, 'refs' => [], ], 'PutReplicationConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutReplicationConfigurationResponse' => [ 'base' => NULL, 'refs' => [], ], 'Reason' => [ 'base' => NULL, 'refs' => [ 'CvssScoreAdjustment$reason' => '<p>The reason the CVSS score has been adjustment.</p>', ], ], 'Recommendation' => [ 'base' => '<p>Details about the recommended course of action to remediate the finding.</p>', 'refs' => [ 'Remediation$recommendation' => '<p>An object that contains information about the recommended course of action to remediate the finding.</p>', ], ], 'RecommendationText' => [ 'base' => NULL, 'refs' => [ 'Recommendation$text' => '<p>The recommended course of action to remediate the finding.</p>', ], ], 'RecordedPullTimestamp' => [ 'base' => NULL, 'refs' => [ 'ImageDetail$lastRecordedPullTime' => '<p>The date and time, expressed in standard JavaScript date format, when Amazon ECR recorded the last image pull.</p> <note> <p>Amazon ECR refreshes the last image pull timestamp at least once every 24 hours. For example, if you pull an image once a day then the <code>lastRecordedPullTime</code> timestamp will indicate the exact time that the image was last pulled. However, if you pull an image once an hour, because Amazon ECR refreshes the <code>lastRecordedPullTime</code> timestamp at least once every 24 hours, the result may not be the exact time that the image was last pulled.</p> </note>', ], ], 'ReferenceUrlsList' => [ 'base' => NULL, 'refs' => [ 'PackageVulnerabilityDetails$referenceUrls' => '<p>One or more URLs that contain details about this vulnerability type.</p>', ], ], 'ReferencedImagesNotFoundException' => [ 'base' => '<p>The manifest list is referencing an image that does not exist.</p>', 'refs' => [], ], 'Region' => [ 'base' => NULL, 'refs' => [ 'ImageReplicationStatus$region' => '<p>The destination Region for the image replication.</p>', 'ReplicationDestination$region' => '<p>The Region to replicate to.</p>', ], ], 'RegistryId' => [ 'base' => NULL, 'refs' => [ 'AwsEcrContainerImageDetails$registry' => '<p>The registry the Amazon ECR container image belongs to.</p>', 'BatchCheckLayerAvailabilityRequest$registryId' => '<p>The Amazon Web Services account ID associated with the registry that contains the image layers to check. If you do not specify a registry, the default registry is assumed.</p>', 'BatchDeleteImageRequest$registryId' => '<p>The Amazon Web Services account ID associated with the registry that contains the image to delete. If you do not specify a registry, the default registry is assumed.</p>', 'BatchGetImageRequest$registryId' => '<p>The Amazon Web Services account ID associated with the registry that contains the images to describe. If you do not specify a registry, the default registry is assumed.</p>', 'CompleteLayerUploadRequest$registryId' => '<p>The Amazon Web Services account ID associated with the registry to which to upload layers. If you do not specify a registry, the default registry is assumed.</p>', 'CompleteLayerUploadResponse$registryId' => '<p>The registry ID associated with the request.</p>', 'CreatePullThroughCacheRuleRequest$registryId' => '<p>The Amazon Web Services account ID associated with the registry to create the pull through cache rule for. If you do not specify a registry, the default registry is assumed.</p>', 'CreatePullThroughCacheRuleResponse$registryId' => '<p>The registry ID associated with the request.</p>', 'CreateRepositoryRequest$registryId' => '<p>The Amazon Web Services account ID associated with the registry to create the repository. If you do not specify a registry, the default registry is assumed.</p>', 'DeleteLifecyclePolicyRequest$registryId' => '<p>The Amazon Web Services account ID associated with the registry that contains the repository. If you do not specify a registry, the default registry is assumed.</p>', 'DeleteLifecyclePolicyResponse$registryId' => '<p>The registry ID associated with the request.</p>', 'DeletePullThroughCacheRuleRequest$registryId' => '<p>The Amazon Web Services account ID associated with the registry that contains the pull through cache rule. If you do not specify a registry, the default registry is assumed.</p>', 'DeletePullThroughCacheRuleResponse$registryId' => '<p>The registry ID associated with the request.</p>', 'DeleteRegistryPolicyResponse$registryId' => '<p>The registry ID associated with the request.</p>', 'DeleteRepositoryPolicyRequest$registryId' => '<p>The Amazon Web Services account ID associated with the registry that contains the repository policy to delete. If you do not specify a registry, the default registry is assumed.</p>', 'DeleteRepositoryPolicyResponse$registryId' => '<p>The registry ID associated with the request.</p>', 'DeleteRepositoryRequest$registryId' => '<p>The Amazon Web Services account ID associated with the registry that contains the repository to delete. If you do not specify a registry, the default registry is assumed.</p>', 'DescribeImageReplicationStatusRequest$registryId' => '<p>The Amazon Web Services account ID associated with the registry. If you do not specify a registry, the default registry is assumed.</p>', 'DescribeImageScanFindingsRequest$registryId' => '<p>The Amazon Web Services account ID associated with the registry that contains the repository in which to describe the image scan findings for. If you do not specify a registry, the default registry is assumed.</p>', 'DescribeImageScanFindingsResponse$registryId' => '<p>The registry ID associated with the request.</p>', 'DescribeImagesRequest$registryId' => '<p>The Amazon Web Services account ID associated with the registry that contains the repository in which to describe images. If you do not specify a registry, the default registry is assumed.</p>', 'DescribePullThroughCacheRulesRequest$registryId' => '<p>The Amazon Web Services account ID associated with the registry to return the pull through cache rules for. If you do not specify a registry, the default registry is assumed.</p>', 'DescribeRegistryResponse$registryId' => '<p>The ID of the registry.</p>', 'DescribeRepositoriesRequest$registryId' => '<p>The Amazon Web Services account ID associated with the registry that contains the repositories to be described. If you do not specify a registry, the default registry is assumed.</p>', 'EnhancedImageScanFinding$awsAccountId' => '<p>The Amazon Web Services account ID associated with the image.</p>', 'GetAuthorizationTokenRegistryIdList$member' => NULL, 'GetDownloadUrlForLayerRequest$registryId' => '<p>The Amazon Web Services account ID associated with the registry that contains the image layer to download. If you do not specify a registry, the default registry is assumed.</p>', 'GetLifecyclePolicyPreviewRequest$registryId' => '<p>The Amazon Web Services account ID associated with the registry that contains the repository. If you do not specify a registry, the default registry is assumed.</p>', 'GetLifecyclePolicyPreviewResponse$registryId' => '<p>The registry ID associated with the request.</p>', 'GetLifecyclePolicyRequest$registryId' => '<p>The Amazon Web Services account ID associated with the registry that contains the repository. If you do not specify a registry, the default registry is assumed.</p>', 'GetLifecyclePolicyResponse$registryId' => '<p>The registry ID associated with the request.</p>', 'GetRegistryPolicyResponse$registryId' => '<p>The ID of the registry.</p>', 'GetRegistryScanningConfigurationResponse$registryId' => '<p>The ID of the registry.</p>', 'GetRepositoryPolicyRequest$registryId' => '<p>The Amazon Web Services account ID associated with the registry that contains the repository. If you do not specify a registry, the default registry is assumed.</p>', 'GetRepositoryPolicyResponse$registryId' => '<p>The registry ID associated with the request.</p>', 'Image$registryId' => '<p>The Amazon Web Services account ID associated with the registry containing the image.</p>', 'ImageDetail$registryId' => '<p>The Amazon Web Services account ID associated with the registry to which this image belongs.</p>', 'ImageReplicationStatus$registryId' => '<p>The Amazon Web Services account ID associated with the registry to which the image belongs.</p>', 'InitiateLayerUploadRequest$registryId' => '<p>The Amazon Web Services account ID associated with the registry to which you intend to upload layers. If you do not specify a registry, the default registry is assumed.</p>', 'InvalidLayerPartException$registryId' => '<p>The registry ID associated with the exception.</p>', 'ListImagesRequest$registryId' => '<p>The Amazon Web Services account ID associated with the registry that contains the repository in which to list images. If you do not specify a registry, the default registry is assumed.</p>', 'PullThroughCacheRule$registryId' => '<p>The Amazon Web Services account ID associated with the registry the pull through cache rule is associated with.</p>', 'PutImageRequest$registryId' => '<p>The Amazon Web Services account ID associated with the registry that contains the repository in which to put the image. If you do not specify a registry, the default registry is assumed.</p>', 'PutImageScanningConfigurationRequest$registryId' => '<p>The Amazon Web Services account ID associated with the registry that contains the repository in which to update the image scanning configuration setting. If you do not specify a registry, the default registry is assumed.</p>', 'PutImageScanningConfigurationResponse$registryId' => '<p>The registry ID associated with the request.</p>', 'PutImageTagMutabilityRequest$registryId' => '<p>The Amazon Web Services account ID associated with the registry that contains the repository in which to update the image tag mutability settings. If you do not specify a registry, the default registry is assumed.</p>', 'PutImageTagMutabilityResponse$registryId' => '<p>The registry ID associated with the request.</p>', 'PutLifecyclePolicyRequest$registryId' => '<p>The Amazon Web Services account ID associated with the registry that contains the repository. If you do&#x2028; not specify a registry, the default registry is assumed.</p>', 'PutLifecyclePolicyResponse$registryId' => '<p>The registry ID associated with the request.</p>', 'PutRegistryPolicyResponse$registryId' => '<p>The registry ID.</p>', 'ReplicationDestination$registryId' => '<p>The Amazon Web Services account ID of the Amazon ECR private registry to replicate to. When configuring cross-Region replication within your own registry, specify your own account ID.</p>', 'Repository$registryId' => '<p>The Amazon Web Services account ID associated with the registry that contains the repository.</p>', 'SetRepositoryPolicyRequest$registryId' => '<p>The Amazon Web Services account ID associated with the registry that contains the repository. If you do not specify a registry, the default registry is assumed.</p>', 'SetRepositoryPolicyResponse$registryId' => '<p>The registry ID associated with the request.</p>', 'StartImageScanRequest$registryId' => '<p>The Amazon Web Services account ID associated with the registry that contains the repository in which to start an image scan request. If you do not specify a registry, the default registry is assumed.</p>', 'StartImageScanResponse$registryId' => '<p>The registry ID associated with the request.</p>', 'StartLifecyclePolicyPreviewRequest$registryId' => '<p>The Amazon Web Services account ID associated with the registry that contains the repository. If you do not specify a registry, the default registry is assumed.</p>', 'StartLifecyclePolicyPreviewResponse$registryId' => '<p>The registry ID associated with the request.</p>', 'UploadLayerPartRequest$registryId' => '<p>The Amazon Web Services account ID associated with the registry to which you are uploading layer parts. If you do not specify a registry, the default registry is assumed.</p>', 'UploadLayerPartResponse$registryId' => '<p>The registry ID associated with the request.</p>', ], ], 'RegistryPolicyNotFoundException' => [ 'base' => '<p>The registry doesn\'t have an associated registry policy.</p>', 'refs' => [], ], 'RegistryPolicyText' => [ 'base' => NULL, 'refs' => [ 'DeleteRegistryPolicyResponse$policyText' => '<p>The contents of the registry permissions policy that was deleted.</p>', 'GetRegistryPolicyResponse$policyText' => '<p>The JSON text of the permissions policy for a registry.</p>', 'PutRegistryPolicyRequest$policyText' => '<p>The JSON policy text to apply to your registry. The policy text follows the same format as IAM policy text. For more information, see <a href="https://docs.aws.amazon.com/AmazonECR/latest/userguide/registry-permissions.html">Registry permissions</a> in the <i>Amazon Elastic Container Registry User Guide</i>.</p>', 'PutRegistryPolicyResponse$policyText' => '<p>The JSON policy text for your registry.</p>', ], ], 'RegistryScanningConfiguration' => [ 'base' => '<p>The scanning configuration for a private registry.</p>', 'refs' => [ 'GetRegistryScanningConfigurationResponse$scanningConfiguration' => '<p>The scanning configuration for the registry.</p>', 'PutRegistryScanningConfigurationResponse$registryScanningConfiguration' => '<p>The scanning configuration for your registry.</p>', ], ], 'RegistryScanningRule' => [ 'base' => '<p>The details of a scanning rule for a private registry.</p>', 'refs' => [ 'RegistryScanningRuleList$member' => NULL, ], ], 'RegistryScanningRuleList' => [ 'base' => NULL, 'refs' => [ 'PutRegistryScanningConfigurationRequest$rules' => '<p>The scanning rules to use for the registry. A scanning rule is used to determine which repository filters are used and at what frequency scanning will occur.</p>', 'RegistryScanningConfiguration$rules' => '<p>The scanning rules associated with the registry.</p>', ], ], 'RelatedVulnerabilitiesList' => [ 'base' => NULL, 'refs' => [ 'PackageVulnerabilityDetails$relatedVulnerabilities' => '<p>One or more vulnerabilities related to the one identified in this finding.</p>', ], ], 'RelatedVulnerability' => [ 'base' => NULL, 'refs' => [ 'RelatedVulnerabilitiesList$member' => NULL, ], ], 'Release' => [ 'base' => NULL, 'refs' => [ 'VulnerablePackage$release' => '<p>The release of the vulnerable package.</p>', ], ], 'Remediation' => [ 'base' => '<p>Information on how to remediate a finding.</p>', 'refs' => [ 'EnhancedImageScanFinding$remediation' => '<p>An object that contains the details about how to remediate a finding.</p>', ], ], 'ReplicationConfiguration' => [ 'base' => '<p>The replication configuration for a registry.</p>', 'refs' => [ 'DescribeRegistryResponse$replicationConfiguration' => '<p>The replication configuration for the registry.</p>', 'PutReplicationConfigurationRequest$replicationConfiguration' => '<p>An object representing the replication configuration for a registry.</p>', 'PutReplicationConfigurationResponse$replicationConfiguration' => '<p>The contents of the replication configuration for the registry.</p>', ], ], 'ReplicationDestination' => [ 'base' => '<p>An array of objects representing the destination for a replication rule.</p>', 'refs' => [ 'ReplicationDestinationList$member' => NULL, ], ], 'ReplicationDestinationList' => [ 'base' => NULL, 'refs' => [ 'ReplicationRule$destinations' => '<p>An array of objects representing the destination for a replication rule.</p>', ], ], 'ReplicationError' => [ 'base' => NULL, 'refs' => [ 'ImageReplicationStatus$failureCode' => '<p>The failure code for a replication that has failed.</p>', ], ], 'ReplicationRule' => [ 'base' => '<p>An array of objects representing the replication destinations and repository filters for a replication configuration.</p>', 'refs' => [ 'ReplicationRuleList$member' => NULL, ], ], 'ReplicationRuleList' => [ 'base' => NULL, 'refs' => [ 'ReplicationConfiguration$rules' => '<p>An array of objects representing the replication destinations and repository filters for a replication configuration.</p>', ], ], 'ReplicationStatus' => [ 'base' => NULL, 'refs' => [ 'ImageReplicationStatus$status' => '<p>The image replication status.</p>', ], ], 'Repository' => [ 'base' => '<p>An object representing a repository.</p>', 'refs' => [ 'CreateRepositoryResponse$repository' => '<p>The repository that was created.</p>', 'DeleteRepositoryResponse$repository' => '<p>The repository that was deleted.</p>', 'RepositoryList$member' => NULL, ], ], 'RepositoryAlreadyExistsException' => [ 'base' => '<p>The specified repository already exists in the specified registry.</p>', 'refs' => [], ], 'RepositoryFilter' => [ 'base' => '<p>The filter settings used with image replication. Specifying a repository filter to a replication rule provides a method for controlling which repositories in a private registry are replicated. If no repository filter is specified, all images in the repository are replicated.</p>', 'refs' => [ 'RepositoryFilterList$member' => NULL, ], ], 'RepositoryFilterList' => [ 'base' => NULL, 'refs' => [ 'ReplicationRule$repositoryFilters' => '<p>An array of objects representing the filters for a replication rule. Specifying a repository filter for a replication rule provides a method for controlling which repositories in a private registry are replicated.</p>', ], ], 'RepositoryFilterType' => [ 'base' => NULL, 'refs' => [ 'RepositoryFilter$filterType' => '<p>The repository filter type. The only supported value is <code>PREFIX_MATCH</code>, which is a repository name prefix specified with the <code>filter</code> parameter.</p>', ], ], 'RepositoryFilterValue' => [ 'base' => NULL, 'refs' => [ 'RepositoryFilter$filter' => '<p>The repository filter details. When the <code>PREFIX_MATCH</code> filter type is specified, this value is required and should be the repository name prefix to configure replication for.</p>', ], ], 'RepositoryList' => [ 'base' => NULL, 'refs' => [ 'DescribeRepositoriesResponse$repositories' => '<p>A list of repository objects corresponding to valid repositories.</p>', ], ], 'RepositoryName' => [ 'base' => NULL, 'refs' => [ 'AwsEcrContainerImageDetails$repositoryName' => '<p>The name of the repository the Amazon ECR container image resides in.</p>', 'BatchCheckLayerAvailabilityRequest$repositoryName' => '<p>The name of the repository that is associated with the image layers to check.</p>', 'BatchDeleteImageRequest$repositoryName' => '<p>The repository that contains the image to delete.</p>', 'BatchGetImageRequest$repositoryName' => '<p>The repository that contains the images to describe.</p>', 'CompleteLayerUploadRequest$repositoryName' => '<p>The name of the repository to associate with the image layer.</p>', 'CompleteLayerUploadResponse$repositoryName' => '<p>The repository name associated with the request.</p>', 'CreateRepositoryRequest$repositoryName' => '<p>The name to use for the repository. The repository name may be specified on its own (such as <code>nginx-web-app</code>) or it can be prepended with a namespace to group the repository into a category (such as <code>project-a/nginx-web-app</code>).</p>', 'DeleteLifecyclePolicyRequest$repositoryName' => '<p>The name of the repository.</p>', 'DeleteLifecyclePolicyResponse$repositoryName' => '<p>The repository name associated with the request.</p>', 'DeleteRepositoryPolicyRequest$repositoryName' => '<p>The name of the repository that is associated with the repository policy to delete.</p>', 'DeleteRepositoryPolicyResponse$repositoryName' => '<p>The repository name associated with the request.</p>', 'DeleteRepositoryRequest$repositoryName' => '<p>The name of the repository to delete.</p>', 'DescribeImageReplicationStatusRequest$repositoryName' => '<p>The name of the repository that the image is in.</p>', 'DescribeImageReplicationStatusResponse$repositoryName' => '<p>The repository name associated with the request.</p>', 'DescribeImageScanFindingsRequest$repositoryName' => '<p>The repository for the image for which to describe the scan findings.</p>', 'DescribeImageScanFindingsResponse$repositoryName' => '<p>The repository name associated with the request.</p>', 'DescribeImagesRequest$repositoryName' => '<p>The repository that contains the images to describe.</p>', 'GetDownloadUrlForLayerRequest$repositoryName' => '<p>The name of the repository that is associated with the image layer to download.</p>', 'GetLifecyclePolicyPreviewRequest$repositoryName' => '<p>The name of the repository.</p>', 'GetLifecyclePolicyPreviewResponse$repositoryName' => '<p>The repository name associated with the request.</p>', 'GetLifecyclePolicyRequest$repositoryName' => '<p>The name of the repository.</p>', 'GetLifecyclePolicyResponse$repositoryName' => '<p>The repository name associated with the request.</p>', 'GetRepositoryPolicyRequest$repositoryName' => '<p>The name of the repository with the policy to retrieve.</p>', 'GetRepositoryPolicyResponse$repositoryName' => '<p>The repository name associated with the request.</p>', 'Image$repositoryName' => '<p>The name of the repository associated with the image.</p>', 'ImageDetail$repositoryName' => '<p>The name of the repository to which this image belongs.</p>', 'InitiateLayerUploadRequest$repositoryName' => '<p>The name of the repository to which you intend to upload layers.</p>', 'InvalidLayerPartException$repositoryName' => '<p>The repository name associated with the exception.</p>', 'ListImagesRequest$repositoryName' => '<p>The repository with image IDs to be listed.</p>', 'PutImageRequest$repositoryName' => '<p>The name of the repository in which to put the image.</p>', 'PutImageScanningConfigurationRequest$repositoryName' => '<p>The name of the repository in which to update the image scanning configuration setting.</p>', 'PutImageScanningConfigurationResponse$repositoryName' => '<p>The repository name associated with the request.</p>', 'PutImageTagMutabilityRequest$repositoryName' => '<p>The name of the repository in which to update the image tag mutability settings.</p>', 'PutImageTagMutabilityResponse$repositoryName' => '<p>The repository name associated with the request.</p>', 'PutLifecyclePolicyRequest$repositoryName' => '<p>The name of the repository to receive the policy.</p>', 'PutLifecyclePolicyResponse$repositoryName' => '<p>The repository name associated with the request.</p>', 'Repository$repositoryName' => '<p>The name of the repository.</p>', 'RepositoryNameList$member' => NULL, 'RepositoryScanningConfiguration$repositoryName' => '<p>The name of the repository.</p>', 'RepositoryScanningConfigurationFailure$repositoryName' => '<p>The name of the repository.</p>', 'ScanningConfigurationRepositoryNameList$member' => NULL, 'SetRepositoryPolicyRequest$repositoryName' => '<p>The name of the repository to receive the policy.</p>', 'SetRepositoryPolicyResponse$repositoryName' => '<p>The repository name associated with the request.</p>', 'StartImageScanRequest$repositoryName' => '<p>The name of the repository that contains the images to scan.</p>', 'StartImageScanResponse$repositoryName' => '<p>The repository name associated with the request.</p>', 'StartLifecyclePolicyPreviewRequest$repositoryName' => '<p>The name of the repository to be evaluated.</p>', 'StartLifecyclePolicyPreviewResponse$repositoryName' => '<p>The repository name associated with the request.</p>', 'UploadLayerPartRequest$repositoryName' => '<p>The name of the repository to which you are uploading layer parts.</p>', 'UploadLayerPartResponse$repositoryName' => '<p>The repository name associated with the request.</p>', ], ], 'RepositoryNameList' => [ 'base' => NULL, 'refs' => [ 'DescribeRepositoriesRequest$repositoryNames' => '<p>A list of repositories to describe. If this parameter is omitted, then all repositories in a registry are described.</p>', ], ], 'RepositoryNotEmptyException' => [ 'base' => '<p>The specified repository contains images. To delete a repository that contains images, you must force the deletion with the <code>force</code> parameter.</p>', 'refs' => [], ], 'RepositoryNotFoundException' => [ 'base' => '<p>The specified repository could not be found. Check the spelling of the specified repository and ensure that you are performing operations on the correct registry.</p>', 'refs' => [], ], 'RepositoryPolicyNotFoundException' => [ 'base' => '<p>The specified repository and registry combination does not have an associated repository policy.</p>', 'refs' => [], ], 'RepositoryPolicyText' => [ 'base' => NULL, 'refs' => [ 'DeleteRepositoryPolicyResponse$policyText' => '<p>The JSON repository policy that was deleted from the repository.</p>', 'GetRepositoryPolicyResponse$policyText' => '<p>The JSON repository policy text associated with the repository.</p>', 'SetRepositoryPolicyRequest$policyText' => '<p>The JSON repository policy text to apply to the repository. For more information, see <a href="https://docs.aws.amazon.com/AmazonECR/latest/userguide/repository-policy-examples.html">Amazon ECR repository policies</a> in the <i>Amazon Elastic Container Registry User Guide</i>.</p>', 'SetRepositoryPolicyResponse$policyText' => '<p>The JSON repository policy text applied to the repository.</p>', ], ], 'RepositoryScanningConfiguration' => [ 'base' => '<p>The details of the scanning configuration for a repository.</p>', 'refs' => [ 'RepositoryScanningConfigurationList$member' => NULL, ], ], 'RepositoryScanningConfigurationFailure' => [ 'base' => '<p>The details about any failures associated with the scanning configuration of a repository.</p>', 'refs' => [ 'RepositoryScanningConfigurationFailureList$member' => NULL, ], ], 'RepositoryScanningConfigurationFailureList' => [ 'base' => NULL, 'refs' => [ 'BatchGetRepositoryScanningConfigurationResponse$failures' => '<p>Any failures associated with the call.</p>', ], ], 'RepositoryScanningConfigurationList' => [ 'base' => NULL, 'refs' => [ 'BatchGetRepositoryScanningConfigurationResponse$scanningConfigurations' => '<p>The scanning configuration for the requested repositories.</p>', ], ], 'Resource' => [ 'base' => '<p>Details about the resource involved in a finding.</p>', 'refs' => [ 'ResourceList$member' => NULL, ], ], 'ResourceDetails' => [ 'base' => '<p>Contains details about the resource involved in the finding.</p>', 'refs' => [ 'Resource$details' => '<p>An object that contains details about the resource involved in a finding.</p>', ], ], 'ResourceId' => [ 'base' => NULL, 'refs' => [ 'Resource$id' => '<p>The ID of the resource.</p>', ], ], 'ResourceList' => [ 'base' => NULL, 'refs' => [ 'EnhancedImageScanFinding$resources' => '<p>Contains information on the resources involved in a finding.</p>', ], ], 'ScanFrequency' => [ 'base' => NULL, 'refs' => [ 'RegistryScanningRule$scanFrequency' => '<p>The frequency that scans are performed at for a private registry. When the <code>ENHANCED</code> scan type is specified, the supported scan frequencies are <code>CONTINUOUS_SCAN</code> and <code>SCAN_ON_PUSH</code>. When the <code>BASIC</code> scan type is specified, the <code>SCAN_ON_PUSH</code> and <code>MANUAL</code> scan frequencies are supported.</p>', 'RepositoryScanningConfiguration$scanFrequency' => '<p>The scan frequency for the repository.</p>', ], ], 'ScanNotFoundException' => [ 'base' => '<p>The specified image scan could not be found. Ensure that image scanning is enabled on the repository and try again.</p>', 'refs' => [], ], 'ScanOnPushFlag' => [ 'base' => NULL, 'refs' => [ 'ImageScanningConfiguration$scanOnPush' => '<p>The setting that determines whether images are scanned after being pushed to a repository. If set to <code>true</code>, images will be scanned after being pushed. If this parameter is not specified, it will default to <code>false</code> and images will not be scanned unless a scan is manually started with the <a href="https://docs.aws.amazon.com/AmazonECR/latest/APIReference/API_StartImageScan.html">API_StartImageScan</a> API.</p>', 'RepositoryScanningConfiguration$scanOnPush' => '<p>Whether or not scan on push is configured for the repository.</p>', ], ], 'ScanStatus' => [ 'base' => NULL, 'refs' => [ 'ImageScanStatus$status' => '<p>The current state of an image scan.</p>', ], ], 'ScanStatusDescription' => [ 'base' => NULL, 'refs' => [ 'ImageScanStatus$description' => '<p>The description of the image scan status.</p>', ], ], 'ScanTimestamp' => [ 'base' => NULL, 'refs' => [ 'ImageScanFindings$imageScanCompletedAt' => '<p>The time of the last completed image scan.</p>', 'ImageScanFindingsSummary$imageScanCompletedAt' => '<p>The time of the last completed image scan.</p>', ], ], 'ScanType' => [ 'base' => NULL, 'refs' => [ 'PutRegistryScanningConfigurationRequest$scanType' => '<p>The scanning type to set for the registry.</p> <p>When a registry scanning configuration is not defined, by default the <code>BASIC</code> scan type is used. When basic scanning is used, you may specify filters to determine which individual repositories, or all repositories, are scanned when new images are pushed to those repositories. Alternatively, you can do manual scans of images with basic scanning.</p> <p>When the <code>ENHANCED</code> scan type is set, Amazon Inspector provides automated vulnerability scanning. You may choose between continuous scanning or scan on push and you may specify filters to determine which individual repositories, or all repositories, are scanned.</p>', 'RegistryScanningConfiguration$scanType' => '<p>The type of scanning configured for the registry.</p>', ], ], 'ScanningConfigurationFailureCode' => [ 'base' => NULL, 'refs' => [ 'RepositoryScanningConfigurationFailure$failureCode' => '<p>The failure code.</p>', ], ], 'ScanningConfigurationFailureReason' => [ 'base' => NULL, 'refs' => [ 'RepositoryScanningConfigurationFailure$failureReason' => '<p>The reason for the failure.</p>', ], ], 'ScanningConfigurationRepositoryNameList' => [ 'base' => NULL, 'refs' => [ 'BatchGetRepositoryScanningConfigurationRequest$repositoryNames' => '<p>One or more repository names to get the scanning configuration for.</p>', ], ], 'ScanningRepositoryFilter' => [ 'base' => '<p>The details of a scanning repository filter. For more information on how to use filters, see <a href="https://docs.aws.amazon.com/AmazonECR/latest/userguide/image-scanning.html#image-scanning-filters">Using filters</a> in the <i>Amazon Elastic Container Registry User Guide</i>.</p>', 'refs' => [ 'ScanningRepositoryFilterList$member' => NULL, ], ], 'ScanningRepositoryFilterList' => [ 'base' => NULL, 'refs' => [ 'RegistryScanningRule$repositoryFilters' => '<p>The repository filters associated with the scanning configuration for a private registry.</p>', 'RepositoryScanningConfiguration$appliedScanFilters' => '<p>The scan filters applied to the repository.</p>', ], ], 'ScanningRepositoryFilterType' => [ 'base' => NULL, 'refs' => [ 'ScanningRepositoryFilter$filterType' => '<p>The type associated with the filter.</p>', ], ], 'ScanningRepositoryFilterValue' => [ 'base' => NULL, 'refs' => [ 'ScanningRepositoryFilter$filter' => '<p>The filter to use when scanning.</p>', ], ], 'Score' => [ 'base' => NULL, 'refs' => [ 'CvssScoreDetails$score' => '<p>The CVSS score.</p>', 'EnhancedImageScanFinding$score' => '<p>The Amazon Inspector score given to the finding.</p>', ], ], 'ScoreDetails' => [ 'base' => '<p>Information about the Amazon Inspector score given to a finding.</p>', 'refs' => [ 'EnhancedImageScanFinding$scoreDetails' => '<p>An object that contains details of the Amazon Inspector score.</p>', ], ], 'ScoringVector' => [ 'base' => NULL, 'refs' => [ 'CvssScore$scoringVector' => '<p>The vector string of the CVSS score.</p>', 'CvssScoreDetails$scoringVector' => '<p>The vector for the CVSS score.</p>', ], ], 'ServerException' => [ 'base' => '<p>These errors are usually caused by a server-side issue.</p>', 'refs' => [], ], 'SetRepositoryPolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'SetRepositoryPolicyResponse' => [ 'base' => NULL, 'refs' => [], ], 'Severity' => [ 'base' => NULL, 'refs' => [ 'EnhancedImageScanFinding$severity' => '<p>The severity of the finding.</p>', 'PackageVulnerabilityDetails$vendorSeverity' => '<p>The severity the vendor has given to this vulnerability type.</p>', ], ], 'SeverityCount' => [ 'base' => NULL, 'refs' => [ 'FindingSeverityCounts$value' => NULL, ], ], 'Source' => [ 'base' => NULL, 'refs' => [ 'CvssScore$source' => '<p>The source of the CVSS score.</p>', 'CvssScoreDetails$scoreSource' => '<p>The source for the CVSS score.</p>', 'PackageVulnerabilityDetails$source' => '<p>The source of the vulnerability information.</p>', ], ], 'SourceLayerHash' => [ 'base' => NULL, 'refs' => [ 'VulnerablePackage$sourceLayerHash' => '<p>The source layer hash of the vulnerable package.</p>', ], ], 'StartImageScanRequest' => [ 'base' => NULL, 'refs' => [], ], 'StartImageScanResponse' => [ 'base' => NULL, 'refs' => [], ], 'StartLifecyclePolicyPreviewRequest' => [ 'base' => NULL, 'refs' => [], ], 'StartLifecyclePolicyPreviewResponse' => [ 'base' => NULL, 'refs' => [], ], 'Status' => [ 'base' => NULL, 'refs' => [ 'EnhancedImageScanFinding$status' => '<p>The status of the finding.</p>', ], ], 'Tag' => [ 'base' => '<p>The metadata to apply to a resource to help you categorize and organize them. Each tag consists of a key and a value, both of which you define. Tag keys can have a maximum character length of 128 characters, and tag values can have a maximum length of 256 characters.</p>', 'refs' => [ 'TagList$member' => NULL, ], ], 'TagKey' => [ 'base' => NULL, 'refs' => [ 'Tag$Key' => '<p>One part of a key-value pair that make up a tag. A <code>key</code> is a general label that acts like a category for more specific tag values.</p>', 'TagKeyList$member' => NULL, 'Tags$key' => NULL, ], ], 'TagKeyList' => [ 'base' => NULL, 'refs' => [ 'UntagResourceRequest$tagKeys' => '<p>The keys of the tags to be removed.</p>', ], ], 'TagList' => [ 'base' => NULL, 'refs' => [ 'CreateRepositoryRequest$tags' => '<p>The metadata that you apply to the repository to help you categorize and organize them. Each tag consists of a key and an optional value, both of which you define. Tag keys can have a maximum character length of 128 characters, and tag values can have a maximum length of 256 characters.</p>', 'ListTagsForResourceResponse$tags' => '<p>The tags for the resource.</p>', 'TagResourceRequest$tags' => '<p>The tags to add to the resource. A tag is an array of key-value pairs. Tag keys can have a maximum character length of 128 characters, and tag values can have a maximum length of 256 characters.</p>', ], ], 'TagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'TagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'TagStatus' => [ 'base' => NULL, 'refs' => [ 'DescribeImagesFilter$tagStatus' => '<p>The tag status with which to filter your <a>DescribeImages</a> results. You can filter results based on whether they are <code>TAGGED</code> or <code>UNTAGGED</code>.</p>', 'LifecyclePolicyPreviewFilter$tagStatus' => '<p>The tag status of the image.</p>', 'ListImagesFilter$tagStatus' => '<p>The tag status with which to filter your <a>ListImages</a> results. You can filter results based on whether they are <code>TAGGED</code> or <code>UNTAGGED</code>.</p>', ], ], 'TagValue' => [ 'base' => NULL, 'refs' => [ 'Tag$Value' => '<p>A <code>value</code> acts as a descriptor within a tag category (key).</p>', 'Tags$value' => NULL, ], ], 'Tags' => [ 'base' => NULL, 'refs' => [ 'Resource$tags' => '<p>The tags attached to the resource.</p>', ], ], 'Title' => [ 'base' => NULL, 'refs' => [ 'EnhancedImageScanFinding$title' => '<p>The title of the finding.</p>', ], ], 'TooManyTagsException' => [ 'base' => '<p>The list of tags on the repository is over the limit. The maximum number of tags that can be applied to a repository is 50.</p>', 'refs' => [], ], 'Type' => [ 'base' => NULL, 'refs' => [ 'EnhancedImageScanFinding$type' => '<p>The type of the finding.</p>', 'Resource$type' => '<p>The type of resource.</p>', ], ], 'UnsupportedImageTypeException' => [ 'base' => '<p>The image is of a type that cannot be scanned.</p>', 'refs' => [], ], 'UnsupportedUpstreamRegistryException' => [ 'base' => '<p>The specified upstream registry isn\'t supported.</p>', 'refs' => [], ], 'UntagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'UntagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'UploadId' => [ 'base' => NULL, 'refs' => [ 'CompleteLayerUploadRequest$uploadId' => '<p>The upload ID from a previous <a>InitiateLayerUpload</a> operation to associate with the image layer.</p>', 'CompleteLayerUploadResponse$uploadId' => '<p>The upload ID associated with the layer.</p>', 'InitiateLayerUploadResponse$uploadId' => '<p>The upload ID for the layer upload. This parameter is passed to further <a>UploadLayerPart</a> and <a>CompleteLayerUpload</a> operations.</p>', 'InvalidLayerPartException$uploadId' => '<p>The upload ID associated with the exception.</p>', 'UploadLayerPartRequest$uploadId' => '<p>The upload ID from a previous <a>InitiateLayerUpload</a> operation to associate with the layer part upload.</p>', 'UploadLayerPartResponse$uploadId' => '<p>The upload ID associated with the request.</p>', ], ], 'UploadLayerPartRequest' => [ 'base' => NULL, 'refs' => [], ], 'UploadLayerPartResponse' => [ 'base' => NULL, 'refs' => [], ], 'UploadNotFoundException' => [ 'base' => '<p>The upload could not be found, or the specified upload ID is not valid for this repository.</p>', 'refs' => [], ], 'Url' => [ 'base' => NULL, 'refs' => [ 'CreatePullThroughCacheRuleRequest$upstreamRegistryUrl' => '<p>The registry URL of the upstream public registry to use as the source for the pull through cache rule.</p>', 'CreatePullThroughCacheRuleResponse$upstreamRegistryUrl' => '<p>The upstream registry URL associated with the pull through cache rule.</p>', 'DeletePullThroughCacheRuleResponse$upstreamRegistryUrl' => '<p>The upstream registry URL associated with the pull through cache rule.</p>', 'GetDownloadUrlForLayerResponse$downloadUrl' => '<p>The pre-signed Amazon S3 download URL for the requested layer.</p>', 'ImageScanFinding$uri' => '<p>A link containing additional details about the security vulnerability.</p>', 'PackageVulnerabilityDetails$sourceUrl' => '<p>A URL to the source of the vulnerability information.</p>', 'PullThroughCacheRule$upstreamRegistryUrl' => '<p>The upstream registry URL associated with the pull through cache rule.</p>', 'Recommendation$url' => '<p>The URL address to the CVE remediation recommendations.</p>', 'ReferenceUrlsList$member' => NULL, 'Repository$repositoryUri' => '<p>The URI for the repository. You can use this URI for container image <code>push</code> and <code>pull</code> operations.</p>', ], ], 'ValidationException' => [ 'base' => '<p>There was an exception validating this request.</p>', 'refs' => [], ], 'Version' => [ 'base' => NULL, 'refs' => [ 'CvssScore$version' => '<p>The version of CVSS used for the score.</p>', 'CvssScoreDetails$version' => '<p>The CVSS version used in scoring.</p>', 'VulnerablePackage$version' => '<p>The version of the vulnerable package.</p>', ], ], 'VulnerabilityId' => [ 'base' => NULL, 'refs' => [ 'PackageVulnerabilityDetails$vulnerabilityId' => '<p>The ID given to this vulnerability.</p>', ], ], 'VulnerabilitySourceUpdateTimestamp' => [ 'base' => NULL, 'refs' => [ 'ImageScanFindings$vulnerabilitySourceUpdatedAt' => '<p>The time when the vulnerability data was last scanned.</p>', 'ImageScanFindingsSummary$vulnerabilitySourceUpdatedAt' => '<p>The time when the vulnerability data was last scanned.</p>', ], ], 'VulnerablePackage' => [ 'base' => '<p>Information on the vulnerable package identified by a finding.</p>', 'refs' => [ 'VulnerablePackagesList$member' => NULL, ], ], 'VulnerablePackageName' => [ 'base' => NULL, 'refs' => [ 'VulnerablePackage$name' => '<p>The name of the vulnerable package.</p>', ], ], 'VulnerablePackagesList' => [ 'base' => NULL, 'refs' => [ 'PackageVulnerabilityDetails$vulnerablePackages' => '<p>The packages impacted by this vulnerability.</p>', ], ], ],];
