<?php
// This file was auto-generated from sdk-root/src/data/autoscaling/2011-01-01/docs-2.json
return [ 'version' => '2.0', 'service' => '<fullname>Amazon EC2 Auto Scaling</fullname> <p>Amazon EC2 Auto Scaling is designed to automatically launch or terminate EC2 instances based on user-defined scaling policies, scheduled actions, and health checks.</p> <p>For more information about Amazon EC2 Auto Scaling, see the <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/what-is-amazon-ec2-auto-scaling.html">Amazon EC2 Auto Scaling User Guide</a>. For information about granting IAM users required permissions for calls to Amazon EC2 Auto Scaling, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/APIReference/ec2-auto-scaling-api-permissions.html">Granting IAM users required permissions for Amazon EC2 Auto Scaling resources</a> in the <i>Amazon EC2 Auto Scaling API Reference</i>.</p>', 'operations' => [ 'AttachInstances' => '<p>Attaches one or more EC2 instances to the specified Auto Scaling group.</p> <p>When you attach instances, Amazon EC2 Auto Scaling increases the desired capacity of the group by the number of instances being attached. If the number of instances being attached plus the desired capacity of the group exceeds the maximum size of the group, the operation fails.</p> <p>If there is a Classic Load Balancer attached to your Auto Scaling group, the instances are also registered with the load balancer. If there are target groups attached to your Auto Scaling group, the instances are also registered with the target groups.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/attach-instance-asg.html">Attach EC2 instances to your Auto Scaling group</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>', 'AttachLoadBalancerTargetGroups' => '<p>Attaches one or more target groups to the specified Auto Scaling group.</p> <p>This operation is used with the following load balancer types: </p> <ul> <li> <p> Application Load Balancer - Operates at the application layer (layer 7) and supports HTTP and HTTPS. </p> </li> <li> <p> Network Load Balancer - Operates at the transport layer (layer 4) and supports TCP, TLS, and UDP. </p> </li> <li> <p> Gateway Load Balancer - Operates at the network layer (layer 3).</p> </li> </ul> <p>To describe the target groups for an Auto Scaling group, call the <a>DescribeLoadBalancerTargetGroups</a> API. To detach the target group from the Auto Scaling group, call the <a>DetachLoadBalancerTargetGroups</a> API.</p> <p>This operation is additive and does not detach existing target groups or Classic Load Balancers from the Auto Scaling group.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/autoscaling-load-balancer.html">Elastic Load Balancing and Amazon EC2 Auto Scaling</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>. </p>', 'AttachLoadBalancers' => '<note> <p>To attach an Application Load Balancer, Network Load Balancer, or Gateway Load Balancer, use the <a>AttachLoadBalancerTargetGroups</a> API operation instead.</p> </note> <p>Attaches one or more Classic Load Balancers to the specified Auto Scaling group. Amazon EC2 Auto Scaling registers the running instances with these Classic Load Balancers.</p> <p>To describe the load balancers for an Auto Scaling group, call the <a>DescribeLoadBalancers</a> API. To detach the load balancer from the Auto Scaling group, call the <a>DetachLoadBalancers</a> API.</p> <p>This operation is additive and does not detach existing Classic Load Balancers or target groups from the Auto Scaling group.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/autoscaling-load-balancer.html">Elastic Load Balancing and Amazon EC2 Auto Scaling</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>. </p>', 'BatchDeleteScheduledAction' => '<p>Deletes one or more scheduled actions for the specified Auto Scaling group.</p>', 'BatchPutScheduledUpdateGroupAction' => '<p>Creates or updates one or more scheduled scaling actions for an Auto Scaling group.</p>', 'CancelInstanceRefresh' => '<p>Cancels an instance refresh operation in progress. Cancellation does not roll back any replacements that have already been completed, but it prevents new replacements from being started. </p> <p>This operation is part of the <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-instance-refresh.html">instance refresh feature</a> in Amazon EC2 Auto Scaling, which helps you update instances in your Auto Scaling group after you make configuration changes.</p>', 'CompleteLifecycleAction' => '<p>Completes the lifecycle action for the specified token or instance with the specified result.</p> <p>This step is a part of the procedure for adding a lifecycle hook to an Auto Scaling group:</p> <ol> <li> <p>(Optional) Create a launch template or launch configuration with a user data script that runs while an instance is in a wait state due to a lifecycle hook.</p> </li> <li> <p>(Optional) Create a Lambda function and a rule that allows Amazon EventBridge to invoke your Lambda function when an instance is put into a wait state due to a lifecycle hook.</p> </li> <li> <p>(Optional) Create a notification target and an IAM role. The target can be either an Amazon SQS queue or an Amazon SNS topic. The role allows Amazon EC2 Auto Scaling to publish lifecycle notifications to the target.</p> </li> <li> <p>Create the lifecycle hook. Specify whether the hook is used when the instances launch or terminate.</p> </li> <li> <p>If you need more time, record the lifecycle action heartbeat to keep the instance in a wait state.</p> </li> <li> <p> <b>If you finish before the timeout period ends, send a callback by using the <a>CompleteLifecycleAction</a> API call.</b> </p> </li> </ol> <p>For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/lifecycle-hooks.html">Amazon EC2 Auto Scaling lifecycle hooks</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>', 'CreateAutoScalingGroup' => '<p> <b>We strongly recommend using a launch template when calling this operation to ensure full functionality for Amazon EC2 Auto Scaling and Amazon EC2.</b> </p> <p>Creates an Auto Scaling group with the specified name and attributes. </p> <p>If you exceed your maximum limit of Auto Scaling groups, the call fails. To query this limit, call the <a>DescribeAccountLimits</a> API. For information about updating this limit, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-account-limits.html">Amazon EC2 Auto Scaling service quotas</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p> <p>For introductory exercises for creating an Auto Scaling group, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/GettingStartedTutorial.html">Getting started with Amazon EC2 Auto Scaling</a> and <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-register-lbs-with-asg.html">Tutorial: Set up a scaled and load-balanced application</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/AutoScalingGroup.html">Auto Scaling groups</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p> <p>Every Auto Scaling group has three size parameters (<code>DesiredCapacity</code>, <code>MaxSize</code>, and <code>MinSize</code>). Usually, you set these sizes based on a specific number of instances. However, if you configure a mixed instances policy that defines weights for the instance types, you must specify these sizes with the same units that you use for weighting instances.</p>', 'CreateLaunchConfiguration' => '<p>Creates a launch configuration.</p> <p>If you exceed your maximum limit of launch configurations, the call fails. To query this limit, call the <a>DescribeAccountLimits</a> API. For information about updating this limit, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-account-limits.html">Amazon EC2 Auto Scaling service quotas</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/LaunchConfiguration.html">Launch configurations</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>', 'CreateOrUpdateTags' => '<p>Creates or updates tags for the specified Auto Scaling group.</p> <p>When you specify a tag with a key that already exists, the operation overwrites the previous tag definition, and you do not get an error message.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/autoscaling-tagging.html">Tagging Auto Scaling groups and instances</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>', 'DeleteAutoScalingGroup' => '<p>Deletes the specified Auto Scaling group.</p> <p>If the group has instances or scaling activities in progress, you must specify the option to force the deletion in order for it to succeed.</p> <p>If the group has policies, deleting the group deletes the policies, the underlying alarm actions, and any alarm that no longer has an associated action.</p> <p>To remove instances from the Auto Scaling group before deleting it, call the <a>DetachInstances</a> API with the list of instances and the option to decrement the desired capacity. This ensures that Amazon EC2 Auto Scaling does not launch replacement instances.</p> <p>To terminate all instances before deleting the Auto Scaling group, call the <a>UpdateAutoScalingGroup</a> API and set the minimum size and desired capacity of the Auto Scaling group to zero.</p>', 'DeleteLaunchConfiguration' => '<p>Deletes the specified launch configuration.</p> <p>The launch configuration must not be attached to an Auto Scaling group. When this call completes, the launch configuration is no longer available for use.</p>', 'DeleteLifecycleHook' => '<p>Deletes the specified lifecycle hook.</p> <p>If there are any outstanding lifecycle actions, they are completed first (<code>ABANDON</code> for launching instances, <code>CONTINUE</code> for terminating instances).</p>', 'DeleteNotificationConfiguration' => '<p>Deletes the specified notification.</p>', 'DeletePolicy' => '<p>Deletes the specified scaling policy.</p> <p>Deleting either a step scaling policy or a simple scaling policy deletes the underlying alarm action, but does not delete the alarm, even if it no longer has an associated action.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/deleting-scaling-policy.html">Deleting a scaling policy</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>', 'DeleteScheduledAction' => '<p>Deletes the specified scheduled action.</p>', 'DeleteTags' => '<p>Deletes the specified tags.</p>', 'DeleteWarmPool' => '<p>Deletes the warm pool for the specified Auto Scaling group.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-warm-pools.html">Warm pools for Amazon EC2 Auto Scaling</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>', 'DescribeAccountLimits' => '<p>Describes the current Amazon EC2 Auto Scaling resource quotas for your account.</p> <p>When you establish an Amazon Web Services account, the account has initial quotas on the maximum number of Auto Scaling groups and launch configurations that you can create in a given Region. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-account-limits.html">Amazon EC2 Auto Scaling service quotas</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>', 'DescribeAdjustmentTypes' => '<p>Describes the available adjustment types for step scaling and simple scaling policies.</p> <p>The following adjustment types are supported:</p> <ul> <li> <p> <code>ChangeInCapacity</code> </p> </li> <li> <p> <code>ExactCapacity</code> </p> </li> <li> <p> <code>PercentChangeInCapacity</code> </p> </li> </ul>', 'DescribeAutoScalingGroups' => '<p>Gets information about the Auto Scaling groups in the account and Region.</p> <p>If you specify Auto Scaling group names, the output includes information for only the specified Auto Scaling groups. If you specify filters, the output includes information for only those Auto Scaling groups that meet the filter criteria. If you do not specify group names or filters, the output includes information for all Auto Scaling groups. </p> <p>This operation also returns information about instances in Auto Scaling groups. To retrieve information about the instances in a warm pool, you must call the <a>DescribeWarmPool</a> API. </p>', 'DescribeAutoScalingInstances' => '<p>Gets information about the Auto Scaling instances in the account and Region.</p>', 'DescribeAutoScalingNotificationTypes' => '<p>Describes the notification types that are supported by Amazon EC2 Auto Scaling.</p>', 'DescribeInstanceRefreshes' => '<p>Gets information about the instance refreshes for the specified Auto Scaling group.</p> <p>This operation is part of the <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-instance-refresh.html">instance refresh feature</a> in Amazon EC2 Auto Scaling, which helps you update instances in your Auto Scaling group after you make configuration changes.</p> <p>To help you determine the status of an instance refresh, this operation returns information about the instance refreshes you previously initiated, including their status, end time, the percentage of the instance refresh that is complete, and the number of instances remaining to update before the instance refresh is complete.</p> <p>The following are the possible statuses: </p> <ul> <li> <p> <code>Pending</code> - The request was created, but the operation has not started.</p> </li> <li> <p> <code>InProgress</code> - The operation is in progress.</p> </li> <li> <p> <code>Successful</code> - The operation completed successfully.</p> </li> <li> <p> <code>Failed</code> - The operation failed to complete. You can troubleshoot using the status reason and the scaling activities. </p> </li> <li> <p> <code>Cancelling</code> - An ongoing operation is being cancelled. Cancellation does not roll back any replacements that have already been completed, but it prevents new replacements from being started. </p> </li> <li> <p> <code>Cancelled</code> - The operation is cancelled. </p> </li> </ul>', 'DescribeLaunchConfigurations' => '<p>Gets information about the launch configurations in the account and Region.</p>', 'DescribeLifecycleHookTypes' => '<p>Describes the available types of lifecycle hooks.</p> <p>The following hook types are supported:</p> <ul> <li> <p> <code>autoscaling:EC2_INSTANCE_LAUNCHING</code> </p> </li> <li> <p> <code>autoscaling:EC2_INSTANCE_TERMINATING</code> </p> </li> </ul>', 'DescribeLifecycleHooks' => '<p>Gets information about the lifecycle hooks for the specified Auto Scaling group.</p>', 'DescribeLoadBalancerTargetGroups' => '<p>Gets information about the load balancer target groups for the specified Auto Scaling group.</p> <p>To determine the availability of registered instances, use the <code>State</code> element in the response. When you attach a target group to an Auto Scaling group, the initial <code>State</code> value is <code>Adding</code>. The state transitions to <code>Added</code> after all Auto Scaling instances are registered with the target group. If Elastic Load Balancing health checks are enabled for the Auto Scaling group, the state transitions to <code>InService</code> after at least one Auto Scaling instance passes the health check. When the target group is in the <code>InService</code> state, Amazon EC2 Auto Scaling can terminate and replace any instances that are reported as unhealthy. If no registered instances pass the health checks, the target group doesn\'t enter the <code>InService</code> state. </p> <p>Target groups also have an <code>InService</code> state if you attach them in the <a>CreateAutoScalingGroup</a> API call. If your target group state is <code>InService</code>, but it is not working properly, check the scaling activities by calling <a>DescribeScalingActivities</a> and take any corrective actions necessary.</p> <p>For help with failed health checks, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ts-as-healthchecks.html">Troubleshooting Amazon EC2 Auto Scaling: Health checks</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/autoscaling-load-balancer.html">Elastic Load Balancing and Amazon EC2 Auto Scaling</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>. </p>', 'DescribeLoadBalancers' => '<p>Gets information about the load balancers for the specified Auto Scaling group.</p> <p>This operation describes only Classic Load Balancers. If you have Application Load Balancers, Network Load Balancers, or Gateway Load Balancers, use the <a>DescribeLoadBalancerTargetGroups</a> API instead.</p> <p>To determine the availability of registered instances, use the <code>State</code> element in the response. When you attach a load balancer to an Auto Scaling group, the initial <code>State</code> value is <code>Adding</code>. The state transitions to <code>Added</code> after all Auto Scaling instances are registered with the load balancer. If Elastic Load Balancing health checks are enabled for the Auto Scaling group, the state transitions to <code>InService</code> after at least one Auto Scaling instance passes the health check. When the load balancer is in the <code>InService</code> state, Amazon EC2 Auto Scaling can terminate and replace any instances that are reported as unhealthy. If no registered instances pass the health checks, the load balancer doesn\'t enter the <code>InService</code> state. </p> <p>Load balancers also have an <code>InService</code> state if you attach them in the <a>CreateAutoScalingGroup</a> API call. If your load balancer state is <code>InService</code>, but it is not working properly, check the scaling activities by calling <a>DescribeScalingActivities</a> and take any corrective actions necessary.</p> <p>For help with failed health checks, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ts-as-healthchecks.html">Troubleshooting Amazon EC2 Auto Scaling: Health checks</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/autoscaling-load-balancer.html">Elastic Load Balancing and Amazon EC2 Auto Scaling</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>. </p>', 'DescribeMetricCollectionTypes' => '<p>Describes the available CloudWatch metrics for Amazon EC2 Auto Scaling.</p> <p>The <code>GroupStandbyInstances</code> metric is not returned by default. You must explicitly request this metric when calling the <a>EnableMetricsCollection</a> API.</p>', 'DescribeNotificationConfigurations' => '<p>Gets information about the Amazon SNS notifications that are configured for one or more Auto Scaling groups.</p>', 'DescribePolicies' => '<p>Gets information about the scaling policies in the account and Region.</p>', 'DescribeScalingActivities' => '<p>Gets information about the scaling activities in the account and Region.</p> <p>When scaling events occur, you see a record of the scaling activity in the scaling activities. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-verify-scaling-activity.html">Verifying a scaling activity for an Auto Scaling group</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p> <p>If the scaling event succeeds, the value of the <code>StatusCode</code> element in the response is <code>Successful</code>. If an attempt to launch instances failed, the <code>StatusCode</code> value is <code>Failed</code> or <code>Cancelled</code> and the <code>StatusMessage</code> element in the response indicates the cause of the failure. For help interpreting the <code>StatusMessage</code>, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/CHAP_Troubleshooting.html">Troubleshooting Amazon EC2 Auto Scaling</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>. </p>', 'DescribeScalingProcessTypes' => '<p>Describes the scaling process types for use with the <a>ResumeProcesses</a> and <a>SuspendProcesses</a> APIs.</p>', 'DescribeScheduledActions' => '<p>Gets information about the scheduled actions that haven\'t run or that have not reached their end time.</p> <p>To describe the scaling activities for scheduled actions that have already run, call the <a>DescribeScalingActivities</a> API.</p>', 'DescribeTags' => '<p>Describes the specified tags.</p> <p>You can use filters to limit the results. For example, you can query for the tags for a specific Auto Scaling group. You can specify multiple values for a filter. A tag must match at least one of the specified values for it to be included in the results.</p> <p>You can also specify multiple filters. The result includes information for a particular tag only if it matches all the filters. If there\'s no match, no special message is returned.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/autoscaling-tagging.html">Tagging Auto Scaling groups and instances</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>', 'DescribeTerminationPolicyTypes' => '<p>Describes the termination policies supported by Amazon EC2 Auto Scaling.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-instance-termination.html">Controlling which Auto Scaling instances terminate during scale in</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>', 'DescribeWarmPool' => '<p>Gets information about a warm pool and its instances.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-warm-pools.html">Warm pools for Amazon EC2 Auto Scaling</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>', 'DetachInstances' => '<p>Removes one or more instances from the specified Auto Scaling group.</p> <p>After the instances are detached, you can manage them independent of the Auto Scaling group.</p> <p>If you do not specify the option to decrement the desired capacity, Amazon EC2 Auto Scaling launches instances to replace the ones that are detached.</p> <p>If there is a Classic Load Balancer attached to the Auto Scaling group, the instances are deregistered from the load balancer. If there are target groups attached to the Auto Scaling group, the instances are deregistered from the target groups.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/detach-instance-asg.html">Detach EC2 instances from your Auto Scaling group</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>', 'DetachLoadBalancerTargetGroups' => '<p>Detaches one or more target groups from the specified Auto Scaling group.</p>', 'DetachLoadBalancers' => '<p>Detaches one or more Classic Load Balancers from the specified Auto Scaling group.</p> <p>This operation detaches only Classic Load Balancers. If you have Application Load Balancers, Network Load Balancers, or Gateway Load Balancers, use the <a>DetachLoadBalancerTargetGroups</a> API instead.</p> <p>When you detach a load balancer, it enters the <code>Removing</code> state while deregistering the instances in the group. When all instances are deregistered, then you can no longer describe the load balancer using the <a>DescribeLoadBalancers</a> API call. The instances remain running.</p>', 'DisableMetricsCollection' => '<p>Disables group metrics for the specified Auto Scaling group.</p>', 'EnableMetricsCollection' => '<p>Enables group metrics for the specified Auto Scaling group. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-instance-monitoring.html">Monitoring CloudWatch metrics for your Auto Scaling groups and instances</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>', 'EnterStandby' => '<p>Moves the specified instances into the standby state.</p> <p>If you choose to decrement the desired capacity of the Auto Scaling group, the instances can enter standby as long as the desired capacity of the Auto Scaling group after the instances are placed into standby is equal to or greater than the minimum capacity of the group.</p> <p>If you choose not to decrement the desired capacity of the Auto Scaling group, the Auto Scaling group launches new instances to replace the instances on standby.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-enter-exit-standby.html">Temporarily removing instances from your Auto Scaling group</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>', 'ExecutePolicy' => '<p>Executes the specified policy. This can be useful for testing the design of your scaling policy.</p>', 'ExitStandby' => '<p>Moves the specified instances out of the standby state.</p> <p>After you put the instances back in service, the desired capacity is incremented.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-enter-exit-standby.html">Temporarily removing instances from your Auto Scaling group</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>', 'GetPredictiveScalingForecast' => '<p>Retrieves the forecast data for a predictive scaling policy.</p> <p>Load forecasts are predictions of the hourly load values using historical load data from CloudWatch and an analysis of historical trends. Capacity forecasts are represented as predicted values for the minimum capacity that is needed on an hourly basis, based on the hourly load forecast.</p> <p>A minimum of 24 hours of data is required to create the initial forecasts. However, having a full 14 days of historical data results in more accurate forecasts.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-predictive-scaling.html">Predictive scaling for Amazon EC2 Auto Scaling</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>', 'PutLifecycleHook' => '<p>Creates or updates a lifecycle hook for the specified Auto Scaling group.</p> <p>Lifecycle hooks let you create solutions that are aware of events in the Auto Scaling instance lifecycle, and then perform a custom action on instances when the corresponding lifecycle event occurs.</p> <p>This step is a part of the procedure for adding a lifecycle hook to an Auto Scaling group:</p> <ol> <li> <p>(Optional) Create a launch template or launch configuration with a user data script that runs while an instance is in a wait state due to a lifecycle hook.</p> </li> <li> <p>(Optional) Create a Lambda function and a rule that allows Amazon EventBridge to invoke your Lambda function when an instance is put into a wait state due to a lifecycle hook.</p> </li> <li> <p>(Optional) Create a notification target and an IAM role. The target can be either an Amazon SQS queue or an Amazon SNS topic. The role allows Amazon EC2 Auto Scaling to publish lifecycle notifications to the target.</p> </li> <li> <p> <b>Create the lifecycle hook. Specify whether the hook is used when the instances launch or terminate.</b> </p> </li> <li> <p>If you need more time, record the lifecycle action heartbeat to keep the instance in a wait state using the <a>RecordLifecycleActionHeartbeat</a> API call.</p> </li> <li> <p>If you finish before the timeout period ends, send a callback by using the <a>CompleteLifecycleAction</a> API call.</p> </li> </ol> <p>For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/lifecycle-hooks.html">Amazon EC2 Auto Scaling lifecycle hooks</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p> <p>If you exceed your maximum limit of lifecycle hooks, which by default is 50 per Auto Scaling group, the call fails.</p> <p>You can view the lifecycle hooks for an Auto Scaling group using the <a>DescribeLifecycleHooks</a> API call. If you are no longer using a lifecycle hook, you can delete it by calling the <a>DeleteLifecycleHook</a> API.</p>', 'PutNotificationConfiguration' => '<p>Configures an Auto Scaling group to send notifications when specified events take place. Subscribers to the specified topic can have messages delivered to an endpoint such as a web server or an email address.</p> <p>This configuration overwrites any existing configuration.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ASGettingNotifications.html">Getting Amazon SNS notifications when your Auto Scaling group scales</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p> <p>If you exceed your maximum limit of SNS topics, which is 10 per Auto Scaling group, the call fails.</p>', 'PutScalingPolicy' => '<p>Creates or updates a scaling policy for an Auto Scaling group. Scaling policies are used to scale an Auto Scaling group based on configurable metrics. If no policies are defined, the dynamic scaling and predictive scaling features are not used. </p> <p>For more information about using dynamic scaling, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-scaling-target-tracking.html">Target tracking scaling policies</a> and <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-scaling-simple-step.html">Step and simple scaling policies</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p> <p>For more information about using predictive scaling, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-predictive-scaling.html">Predictive scaling for Amazon EC2 Auto Scaling</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p> <p>You can view the scaling policies for an Auto Scaling group using the <a>DescribePolicies</a> API call. If you are no longer using a scaling policy, you can delete it by calling the <a>DeletePolicy</a> API.</p>', 'PutScheduledUpdateGroupAction' => '<p>Creates or updates a scheduled scaling action for an Auto Scaling group.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/schedule_time.html">Scheduled scaling</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p> <p>You can view the scheduled actions for an Auto Scaling group using the <a>DescribeScheduledActions</a> API call. If you are no longer using a scheduled action, you can delete it by calling the <a>DeleteScheduledAction</a> API.</p>', 'PutWarmPool' => '<p>Creates or updates a warm pool for the specified Auto Scaling group. A warm pool is a pool of pre-initialized EC2 instances that sits alongside the Auto Scaling group. Whenever your application needs to scale out, the Auto Scaling group can draw on the warm pool to meet its new desired capacity. For more information and example configurations, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-warm-pools.html">Warm pools for Amazon EC2 Auto Scaling</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p> <p>This operation must be called from the Region in which the Auto Scaling group was created. This operation cannot be called on an Auto Scaling group that has a mixed instances policy or a launch template or launch configuration that requests Spot Instances.</p> <p>You can view the instances in the warm pool using the <a>DescribeWarmPool</a> API call. If you are no longer using a warm pool, you can delete it by calling the <a>DeleteWarmPool</a> API.</p>', 'RecordLifecycleActionHeartbeat' => '<p>Records a heartbeat for the lifecycle action associated with the specified token or instance. This extends the timeout by the length of time defined using the <a>PutLifecycleHook</a> API call.</p> <p>This step is a part of the procedure for adding a lifecycle hook to an Auto Scaling group:</p> <ol> <li> <p>(Optional) Create a launch template or launch configuration with a user data script that runs while an instance is in a wait state due to a lifecycle hook.</p> </li> <li> <p>(Optional) Create a Lambda function and a rule that allows Amazon EventBridge to invoke your Lambda function when an instance is put into a wait state due to a lifecycle hook.</p> </li> <li> <p>(Optional) Create a notification target and an IAM role. The target can be either an Amazon SQS queue or an Amazon SNS topic. The role allows Amazon EC2 Auto Scaling to publish lifecycle notifications to the target.</p> </li> <li> <p>Create the lifecycle hook. Specify whether the hook is used when the instances launch or terminate.</p> </li> <li> <p> <b>If you need more time, record the lifecycle action heartbeat to keep the instance in a wait state.</b> </p> </li> <li> <p>If you finish before the timeout period ends, send a callback by using the <a>CompleteLifecycleAction</a> API call.</p> </li> </ol> <p>For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/lifecycle-hooks.html">Amazon EC2 Auto Scaling lifecycle hooks</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>', 'ResumeProcesses' => '<p>Resumes the specified suspended auto scaling processes, or all suspended process, for the specified Auto Scaling group.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-suspend-resume-processes.html">Suspending and resuming scaling processes</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>', 'SetDesiredCapacity' => '<p>Sets the size of the specified Auto Scaling group.</p> <p>If a scale-in activity occurs as a result of a new <code>DesiredCapacity</code> value that is lower than the current size of the group, the Auto Scaling group uses its termination policy to determine which instances to terminate. </p> <p>For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-manual-scaling.html">Manual scaling</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>', 'SetInstanceHealth' => '<p>Sets the health status of the specified instance.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/healthcheck.html">Health checks for Auto Scaling instances</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>', 'SetInstanceProtection' => '<p>Updates the instance protection settings of the specified instances. This operation cannot be called on instances in a warm pool.</p> <p>For more information about preventing instances that are part of an Auto Scaling group from terminating on scale in, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-instance-protection.html">Using instance scale-in protection</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p> <p>If you exceed your maximum limit of instance IDs, which is 50 per Auto Scaling group, the call fails.</p>', 'StartInstanceRefresh' => '<p>Starts a new instance refresh operation. An instance refresh performs a rolling replacement of all or some instances in an Auto Scaling group. Each instance is terminated first and then replaced, which temporarily reduces the capacity available within your Auto Scaling group.</p> <p>This operation is part of the <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-instance-refresh.html">instance refresh feature</a> in Amazon EC2 Auto Scaling, which helps you update instances in your Auto Scaling group. This feature is helpful, for example, when you have a new AMI or a new user data script. You just need to create a new launch template that specifies the new AMI or user data script. Then start an instance refresh to immediately begin the process of updating instances in the group. </p> <p>If the call succeeds, it creates a new instance refresh request with a unique ID that you can use to track its progress. To query its status, call the <a>DescribeInstanceRefreshes</a> API. To describe the instance refreshes that have already run, call the <a>DescribeInstanceRefreshes</a> API. To cancel an instance refresh operation in progress, use the <a>CancelInstanceRefresh</a> API. </p>', 'SuspendProcesses' => '<p>Suspends the specified auto scaling processes, or all processes, for the specified Auto Scaling group.</p> <p>If you suspend either the <code>Launch</code> or <code>Terminate</code> process types, it can prevent other process types from functioning properly. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-suspend-resume-processes.html">Suspending and resuming scaling processes</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p> <p>To resume processes that have been suspended, call the <a>ResumeProcesses</a> API.</p>', 'TerminateInstanceInAutoScalingGroup' => '<p>Terminates the specified instance and optionally adjusts the desired group size. This operation cannot be called on instances in a warm pool.</p> <p>This call simply makes a termination request. The instance is not terminated immediately. When an instance is terminated, the instance status changes to <code>terminated</code>. You can\'t connect to or start an instance after you\'ve terminated it.</p> <p>If you do not specify the option to decrement the desired capacity, Amazon EC2 Auto Scaling launches instances to replace the ones that are terminated. </p> <p>By default, Amazon EC2 Auto Scaling balances instances across all Availability Zones. If you decrement the desired capacity, your Auto Scaling group can become unbalanced between Availability Zones. Amazon EC2 Auto Scaling tries to rebalance the group, and rebalancing might terminate instances in other zones. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/auto-scaling-benefits.html#AutoScalingBehavior.InstanceUsage">Rebalancing activities</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>', 'UpdateAutoScalingGroup' => '<p> <b>We strongly recommend that all Auto Scaling groups use launch templates to ensure full functionality for Amazon EC2 Auto Scaling and Amazon EC2.</b> </p> <p>Updates the configuration for the specified Auto Scaling group.</p> <p>To update an Auto Scaling group, specify the name of the group and the parameter that you want to change. Any parameters that you don\'t specify are not changed by this update request. The new settings take effect on any scaling activities after this call returns. </p> <p>If you associate a new launch configuration or template with an Auto Scaling group, all new instances will get the updated configuration. Existing instances continue to run with the configuration that they were originally launched with. When you update a group to specify a mixed instances policy instead of a launch configuration or template, existing instances may be replaced to match the new purchasing options that you specified in the policy. For example, if the group currently has 100% On-Demand capacity and the policy specifies 50% Spot capacity, this means that half of your instances will be gradually terminated and relaunched as Spot Instances. When replacing instances, Amazon EC2 Auto Scaling launches new instances before terminating the old ones, so that updating your group does not compromise the performance or availability of your application.</p> <p>Note the following about changing <code>DesiredCapacity</code>, <code>MaxSize</code>, or <code>MinSize</code>:</p> <ul> <li> <p>If a scale-in activity occurs as a result of a new <code>DesiredCapacity</code> value that is lower than the current size of the group, the Auto Scaling group uses its termination policy to determine which instances to terminate.</p> </li> <li> <p>If you specify a new value for <code>MinSize</code> without specifying a value for <code>DesiredCapacity</code>, and the new <code>MinSize</code> is larger than the current size of the group, this sets the group\'s <code>DesiredCapacity</code> to the new <code>MinSize</code> value.</p> </li> <li> <p>If you specify a new value for <code>MaxSize</code> without specifying a value for <code>DesiredCapacity</code>, and the new <code>MaxSize</code> is smaller than the current size of the group, this sets the group\'s <code>DesiredCapacity</code> to the new <code>MaxSize</code> value.</p> </li> </ul> <p>To see which parameters have been set, call the <a>DescribeAutoScalingGroups</a> API. To view the scaling policies for an Auto Scaling group, call the <a>DescribePolicies</a> API. If the group has scaling policies, you can update them by calling the <a>PutScalingPolicy</a> API.</p>', ], 'shapes' => [ 'AcceleratorCountRequest' => [ 'base' => '<p>Specifies the minimum and maximum for the <code>AcceleratorCount</code> object when you specify <a>InstanceRequirements</a> for an Auto Scaling group.</p>', 'refs' => [ 'InstanceRequirements$AcceleratorCount' => '<p>The minimum and maximum number of accelerators (GPUs, FPGAs, or Amazon Web Services Inferentia chips) for an instance type.</p> <p>To exclude accelerator-enabled instance types, set <code>Max</code> to <code>0</code>.</p> <p>Default: No minimum or maximum</p>', ], ], 'AcceleratorManufacturer' => [ 'base' => NULL, 'refs' => [ 'AcceleratorManufacturers$member' => NULL, ], ], 'AcceleratorManufacturers' => [ 'base' => NULL, 'refs' => [ 'InstanceRequirements$AcceleratorManufacturers' => '<p>Indicates whether instance types must have accelerators by specific manufacturers.</p> <ul> <li> <p>For instance types with NVIDIA devices, specify <code>nvidia</code>.</p> </li> <li> <p>For instance types with AMD devices, specify <code>amd</code>.</p> </li> <li> <p>For instance types with Amazon Web Services devices, specify <code>amazon-web-services</code>.</p> </li> <li> <p>For instance types with Xilinx devices, specify <code>xilinx</code>.</p> </li> </ul> <p>Default: Any manufacturer</p>', ], ], 'AcceleratorName' => [ 'base' => NULL, 'refs' => [ 'AcceleratorNames$member' => NULL, ], ], 'AcceleratorNames' => [ 'base' => NULL, 'refs' => [ 'InstanceRequirements$AcceleratorNames' => '<p>Lists the accelerators that must be on an instance type.</p> <ul> <li> <p>For instance types with NVIDIA A100 GPUs, specify <code>a100</code>.</p> </li> <li> <p>For instance types with NVIDIA V100 GPUs, specify <code>v100</code>.</p> </li> <li> <p>For instance types with NVIDIA K80 GPUs, specify <code>k80</code>.</p> </li> <li> <p>For instance types with NVIDIA T4 GPUs, specify <code>t4</code>.</p> </li> <li> <p>For instance types with NVIDIA M60 GPUs, specify <code>m60</code>.</p> </li> <li> <p>For instance types with AMD Radeon Pro V520 GPUs, specify <code>radeon-pro-v520</code>.</p> </li> <li> <p>For instance types with Xilinx VU9P FPGAs, specify <code>vu9p</code>.</p> </li> </ul> <p>Default: Any accelerator</p>', ], ], 'AcceleratorTotalMemoryMiBRequest' => [ 'base' => '<p>Specifies the minimum and maximum for the <code>AcceleratorTotalMemoryMiB</code> object when you specify <a>InstanceRequirements</a> for an Auto Scaling group.</p>', 'refs' => [ 'InstanceRequirements$AcceleratorTotalMemoryMiB' => '<p>The minimum and maximum total memory size for the accelerators on an instance type, in MiB.</p> <p>Default: No minimum or maximum</p>', ], ], 'AcceleratorType' => [ 'base' => NULL, 'refs' => [ 'AcceleratorTypes$member' => NULL, ], ], 'AcceleratorTypes' => [ 'base' => NULL, 'refs' => [ 'InstanceRequirements$AcceleratorTypes' => '<p>Lists the accelerator types that must be on an instance type.</p> <ul> <li> <p>For instance types with GPU accelerators, specify <code>gpu</code>.</p> </li> <li> <p>For instance types with FPGA accelerators, specify <code>fpga</code>.</p> </li> <li> <p>For instance types with inference accelerators, specify <code>inference</code>.</p> </li> </ul> <p>Default: Any accelerator type</p>', ], ], 'ActiveInstanceRefreshNotFoundFault' => [ 'base' => '<p>The request failed because an active instance refresh for the specified Auto Scaling group was not found. </p>', 'refs' => [], ], 'Activities' => [ 'base' => NULL, 'refs' => [ 'ActivitiesType$Activities' => '<p>The scaling activities. Activities are sorted by start time. Activities still in progress are described first.</p>', 'DetachInstancesAnswer$Activities' => '<p>The activities related to detaching the instances from the Auto Scaling group.</p>', 'EnterStandbyAnswer$Activities' => '<p>The activities related to moving instances into <code>Standby</code> mode.</p>', 'ExitStandbyAnswer$Activities' => '<p>The activities related to moving instances out of <code>Standby</code> mode.</p>', ], ], 'ActivitiesType' => [ 'base' => NULL, 'refs' => [], ], 'Activity' => [ 'base' => '<p>Describes scaling activity, which is a long-running process that represents a change to your Auto Scaling group, such as changing its size or replacing an instance.</p>', 'refs' => [ 'Activities$member' => NULL, 'ActivityType$Activity' => '<p>A scaling activity.</p>', ], ], 'ActivityIds' => [ 'base' => NULL, 'refs' => [ 'DescribeScalingActivitiesType$ActivityIds' => '<p>The activity IDs of the desired scaling activities. If you omit this parameter, all activities for the past six weeks are described. If unknown activities are requested, they are ignored with no error. If you specify an Auto Scaling group, the results are limited to that group.</p> <p>Array Members: Maximum number of 50 IDs.</p>', ], ], 'ActivityType' => [ 'base' => NULL, 'refs' => [], ], 'AdjustmentType' => [ 'base' => '<p>Describes a policy adjustment type.</p>', 'refs' => [ 'AdjustmentTypes$member' => NULL, ], ], 'AdjustmentTypes' => [ 'base' => NULL, 'refs' => [ 'DescribeAdjustmentTypesAnswer$AdjustmentTypes' => '<p>The policy adjustment types.</p>', ], ], 'Alarm' => [ 'base' => '<p>Describes an alarm.</p>', 'refs' => [ 'Alarms$member' => NULL, ], ], 'Alarms' => [ 'base' => NULL, 'refs' => [ 'PolicyARNType$Alarms' => '<p>The CloudWatch alarms created for the target tracking scaling policy.</p>', 'ScalingPolicy$Alarms' => '<p>The CloudWatch alarms related to the policy.</p>', ], ], 'AlreadyExistsFault' => [ 'base' => '<p>You already have an Auto Scaling group or launch configuration with this name.</p>', 'refs' => [], ], 'AsciiStringMaxLen255' => [ 'base' => NULL, 'refs' => [ 'CompleteLifecycleActionType$LifecycleHookName' => '<p>The name of the lifecycle hook.</p>', 'DeleteLifecycleHookType$LifecycleHookName' => '<p>The name of the lifecycle hook.</p>', 'LifecycleHook$LifecycleHookName' => '<p>The name of the lifecycle hook.</p>', 'LifecycleHookNames$member' => NULL, 'LifecycleHookSpecification$LifecycleHookName' => '<p>The name of the lifecycle hook.</p>', 'PutLifecycleHookType$LifecycleHookName' => '<p>The name of the lifecycle hook.</p>', 'RecordLifecycleActionHeartbeatType$LifecycleHookName' => '<p>The name of the lifecycle hook.</p>', ], ], 'AssociatePublicIpAddress' => [ 'base' => NULL, 'refs' => [ 'CreateLaunchConfigurationType$AssociatePublicIpAddress' => '<p>For Auto Scaling groups that are running in a virtual private cloud (VPC), specifies whether to assign a public IP address to the group\'s instances. If you specify <code>true</code>, each instance in the Auto Scaling group receives a unique public IP address. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-in-vpc.html">Launching Auto Scaling instances in a VPC</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p> <p>If you specify this parameter, you must specify at least one subnet for <code>VPCZoneIdentifier</code> when you create your group.</p> <note> <p>If the instance is launched into a default subnet, the default is to assign a public IP address, unless you disabled the option to assign a public IP address on the subnet. If the instance is launched into a nondefault subnet, the default is not to assign a public IP address, unless you enabled the option to assign a public IP address on the subnet.</p> </note>', 'LaunchConfiguration$AssociatePublicIpAddress' => '<p>For Auto Scaling groups that are running in a VPC, specifies whether to assign a public IP address to the group\'s instances. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-in-vpc.html">Launching Auto Scaling instances in a VPC</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>', ], ], 'AttachInstancesQuery' => [ 'base' => NULL, 'refs' => [], ], 'AttachLoadBalancerTargetGroupsResultType' => [ 'base' => NULL, 'refs' => [], ], 'AttachLoadBalancerTargetGroupsType' => [ 'base' => NULL, 'refs' => [], ], 'AttachLoadBalancersResultType' => [ 'base' => NULL, 'refs' => [], ], 'AttachLoadBalancersType' => [ 'base' => NULL, 'refs' => [], ], 'AutoScalingGroup' => [ 'base' => '<p>Describes an Auto Scaling group.</p>', 'refs' => [ 'AutoScalingGroups$member' => NULL, ], ], 'AutoScalingGroupDesiredCapacity' => [ 'base' => NULL, 'refs' => [ 'AutoScalingGroup$DesiredCapacity' => '<p>The desired size of the group.</p>', 'CreateAutoScalingGroupType$DesiredCapacity' => '<p>The desired capacity is the initial capacity of the Auto Scaling group at the time of its creation and the capacity it attempts to maintain. It can scale beyond this capacity if you configure auto scaling. This number must be greater than or equal to the minimum size of the group and less than or equal to the maximum size of the group. If you do not specify a desired capacity, the default is the minimum size of the group.</p>', 'PutScheduledUpdateGroupActionType$DesiredCapacity' => '<p>The desired capacity is the initial capacity of the Auto Scaling group after the scheduled action runs and the capacity it attempts to maintain. It can scale beyond this capacity if you add more scaling conditions. </p>', 'ScheduledUpdateGroupAction$DesiredCapacity' => '<p>The desired capacity is the initial capacity of the Auto Scaling group after the scheduled action runs and the capacity it attempts to maintain.</p>', 'ScheduledUpdateGroupActionRequest$DesiredCapacity' => '<p>The desired capacity is the initial capacity of the Auto Scaling group after the scheduled action runs and the capacity it attempts to maintain.</p>', 'SetDesiredCapacityType$DesiredCapacity' => '<p>The desired capacity is the initial capacity of the Auto Scaling group after this operation completes and the capacity it attempts to maintain.</p>', 'UpdateAutoScalingGroupType$DesiredCapacity' => '<p>The desired capacity is the initial capacity of the Auto Scaling group after this operation completes and the capacity it attempts to maintain. This number must be greater than or equal to the minimum size of the group and less than or equal to the maximum size of the group.</p>', ], ], 'AutoScalingGroupMaxSize' => [ 'base' => NULL, 'refs' => [ 'AutoScalingGroup$MaxSize' => '<p>The maximum size of the group.</p>', 'CreateAutoScalingGroupType$MaxSize' => '<p>The maximum size of the group.</p> <note> <p>With a mixed instances policy that uses instance weighting, Amazon EC2 Auto Scaling may need to go above <code>MaxSize</code> to meet your capacity requirements. In this event, Amazon EC2 Auto Scaling will never go above <code>MaxSize</code> by more than your largest instance weight (weights that define how many units each instance contributes to the desired capacity of the group).</p> </note>', 'PutScheduledUpdateGroupActionType$MaxSize' => '<p>The maximum size of the Auto Scaling group.</p>', 'ScheduledUpdateGroupAction$MaxSize' => '<p>The maximum size of the Auto Scaling group.</p>', 'ScheduledUpdateGroupActionRequest$MaxSize' => '<p>The maximum size of the Auto Scaling group.</p>', 'UpdateAutoScalingGroupType$MaxSize' => '<p>The maximum size of the Auto Scaling group.</p> <note> <p>With a mixed instances policy that uses instance weighting, Amazon EC2 Auto Scaling may need to go above <code>MaxSize</code> to meet your capacity requirements. In this event, Amazon EC2 Auto Scaling will never go above <code>MaxSize</code> by more than your largest instance weight (weights that define how many units each instance contributes to the desired capacity of the group).</p> </note>', ], ], 'AutoScalingGroupMinSize' => [ 'base' => NULL, 'refs' => [ 'AutoScalingGroup$MinSize' => '<p>The minimum size of the group.</p>', 'CreateAutoScalingGroupType$MinSize' => '<p>The minimum size of the group.</p>', 'PutScheduledUpdateGroupActionType$MinSize' => '<p>The minimum size of the Auto Scaling group.</p>', 'ScheduledUpdateGroupAction$MinSize' => '<p>The minimum size of the Auto Scaling group.</p>', 'ScheduledUpdateGroupActionRequest$MinSize' => '<p>The minimum size of the Auto Scaling group.</p>', 'UpdateAutoScalingGroupType$MinSize' => '<p>The minimum size of the Auto Scaling group.</p>', ], ], 'AutoScalingGroupNames' => [ 'base' => NULL, 'refs' => [ 'AutoScalingGroupNamesType$AutoScalingGroupNames' => '<p>The names of the Auto Scaling groups. By default, you can only specify up to 50 names. You can optionally increase this limit using the <code>MaxRecords</code> parameter.</p> <p>If you omit this parameter, all Auto Scaling groups are described.</p>', 'DescribeNotificationConfigurationsType$AutoScalingGroupNames' => '<p>The name of the Auto Scaling group.</p>', ], ], 'AutoScalingGroupNamesType' => [ 'base' => NULL, 'refs' => [], ], 'AutoScalingGroupPredictedCapacity' => [ 'base' => NULL, 'refs' => [ 'AutoScalingGroup$PredictedCapacity' => '<p>The predicted capacity of the group when it has a predictive scaling policy.</p>', ], ], 'AutoScalingGroupState' => [ 'base' => NULL, 'refs' => [ 'Activity$AutoScalingGroupState' => '<p>The state of the Auto Scaling group, which is either <code>InService</code> or <code>Deleted</code>.</p>', ], ], 'AutoScalingGroups' => [ 'base' => NULL, 'refs' => [ 'AutoScalingGroupsType$AutoScalingGroups' => '<p>The groups.</p>', ], ], 'AutoScalingGroupsType' => [ 'base' => NULL, 'refs' => [], ], 'AutoScalingInstanceDetails' => [ 'base' => '<p>Describes an EC2 instance associated with an Auto Scaling group.</p>', 'refs' => [ 'AutoScalingInstances$member' => NULL, ], ], 'AutoScalingInstances' => [ 'base' => NULL, 'refs' => [ 'AutoScalingInstancesType$AutoScalingInstances' => '<p>The instances.</p>', ], ], 'AutoScalingInstancesType' => [ 'base' => NULL, 'refs' => [], ], 'AutoScalingNotificationTypes' => [ 'base' => NULL, 'refs' => [ 'DescribeAutoScalingNotificationTypesAnswer$AutoScalingNotificationTypes' => '<p>The notification types.</p>', 'DescribeLifecycleHookTypesAnswer$LifecycleHookTypes' => '<p>The lifecycle hook types.</p>', 'PutNotificationConfigurationType$NotificationTypes' => '<p>The type of event that causes the notification to be sent. To query the notification types supported by Amazon EC2 Auto Scaling, call the <a>DescribeAutoScalingNotificationTypes</a> API.</p>', ], ], 'AvailabilityZones' => [ 'base' => NULL, 'refs' => [ 'AutoScalingGroup$AvailabilityZones' => '<p>One or more Availability Zones for the group.</p>', 'CreateAutoScalingGroupType$AvailabilityZones' => '<p>A list of Availability Zones where instances in the Auto Scaling group can be created. This parameter is optional if you specify one or more subnets for <code>VPCZoneIdentifier</code>.</p> <p>Conditional: If your account supports EC2-Classic and VPC, this parameter is required to launch instances into EC2-Classic.</p>', 'UpdateAutoScalingGroupType$AvailabilityZones' => '<p>One or more Availability Zones for the group.</p>', ], ], 'BareMetal' => [ 'base' => NULL, 'refs' => [ 'InstanceRequirements$BareMetal' => '<p>Indicates whether bare metal instance types are included, excluded, or required.</p> <p>Default: <code>excluded</code> </p>', ], ], 'BaselineEbsBandwidthMbpsRequest' => [ 'base' => '<p>Specifies the minimum and maximum for the <code>BaselineEbsBandwidthMbps</code> object when you specify <a>InstanceRequirements</a> for an Auto Scaling group.</p>', 'refs' => [ 'InstanceRequirements$BaselineEbsBandwidthMbps' => '<p>The minimum and maximum baseline bandwidth performance for an instance type, in Mbps. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-optimized.html">Amazon EBS–optimized instances</a> in the <i>Amazon EC2 User Guide for Linux Instances</i>.</p> <p>Default: No minimum or maximum</p>', ], ], 'BatchDeleteScheduledActionAnswer' => [ 'base' => NULL, 'refs' => [], ], 'BatchDeleteScheduledActionType' => [ 'base' => NULL, 'refs' => [], ], 'BatchPutScheduledUpdateGroupActionAnswer' => [ 'base' => NULL, 'refs' => [], ], 'BatchPutScheduledUpdateGroupActionType' => [ 'base' => NULL, 'refs' => [], ], 'BlockDeviceEbsDeleteOnTermination' => [ 'base' => NULL, 'refs' => [ 'Ebs$DeleteOnTermination' => '<p>Indicates whether the volume is deleted on instance termination. For Amazon EC2 Auto Scaling, the default value is <code>true</code>.</p>', ], ], 'BlockDeviceEbsEncrypted' => [ 'base' => NULL, 'refs' => [ 'Ebs$Encrypted' => '<p>Specifies whether the volume should be encrypted. Encrypted EBS volumes can only be attached to instances that support Amazon EBS encryption. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html#EBSEncryption_supported_instances">Supported instance types</a>. If your AMI uses encrypted volumes, you can also only launch it on supported instance types.</p> <note> <p>If you are creating a volume from a snapshot, you cannot create an unencrypted volume from an encrypted snapshot. Also, you cannot specify a KMS key ID when using a launch configuration.</p> <p>If you enable encryption by default, the EBS volumes that you create are always encrypted, either using the Amazon Web Services managed KMS key or a customer-managed KMS key, regardless of whether the snapshot was encrypted. </p> <p>For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-data-protection.html#encryption">Using Amazon Web Services KMS keys to encrypt Amazon EBS volumes</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p> </note>', ], ], 'BlockDeviceEbsIops' => [ 'base' => NULL, 'refs' => [ 'Ebs$Iops' => '<p>The number of input/output (I/O) operations per second (IOPS) to provision for the volume. For <code>gp3</code> and <code>io1</code> volumes, this represents the number of IOPS that are provisioned for the volume. For <code>gp2</code> volumes, this represents the baseline performance of the volume and the rate at which the volume accumulates I/O credits for bursting. </p> <p>The following are the supported values for each volume type: </p> <ul> <li> <p> <code>gp3</code>: 3,000-16,000 IOPS</p> </li> <li> <p> <code>io1</code>: 100-64,000 IOPS</p> </li> </ul> <p>For <code>io1</code> volumes, we guarantee 64,000 IOPS only for <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html#ec2-nitro-instances">Instances built on the Nitro System</a>. Other instance families guarantee performance up to 32,000 IOPS. </p> <p> <code>Iops</code> is supported when the volume type is <code>gp3</code> or <code>io1</code> and required only when the volume type is <code>io1</code>. (Not used with <code>standard</code>, <code>gp2</code>, <code>st1</code>, or <code>sc1</code> volumes.) </p>', ], ], 'BlockDeviceEbsThroughput' => [ 'base' => NULL, 'refs' => [ 'Ebs$Throughput' => '<p>The throughput (MiBps) to provision for a <code>gp3</code> volume.</p>', ], ], 'BlockDeviceEbsVolumeSize' => [ 'base' => NULL, 'refs' => [ 'Ebs$VolumeSize' => '<p>The volume size, in GiBs. The following are the supported volumes sizes for each volume type: </p> <ul> <li> <p> <code>gp2</code> and <code>gp3</code>: 1-16,384</p> </li> <li> <p> <code>io1</code>: 4-16,384</p> </li> <li> <p> <code>st1</code> and <code>sc1</code>: 125-16,384</p> </li> <li> <p> <code>standard</code>: 1-1,024</p> </li> </ul> <p>You must specify either a <code>SnapshotId</code> or a <code>VolumeSize</code>. If you specify both <code>SnapshotId</code> and <code>VolumeSize</code>, the volume size must be equal or greater than the size of the snapshot.</p>', ], ], 'BlockDeviceEbsVolumeType' => [ 'base' => NULL, 'refs' => [ 'Ebs$VolumeType' => '<p>The volume type. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSVolumeTypes.html">Amazon EBS volume types</a> in the <i>Amazon EC2 User Guide for Linux Instances</i>.</p> <p>Valid Values: <code>standard</code> | <code>io1</code> | <code>gp2</code> | <code>st1</code> | <code>sc1</code> | <code>gp3</code> </p>', ], ], 'BlockDeviceMapping' => [ 'base' => '<p>Describes a block device mapping.</p>', 'refs' => [ 'BlockDeviceMappings$member' => NULL, ], ], 'BlockDeviceMappings' => [ 'base' => NULL, 'refs' => [ 'CreateLaunchConfigurationType$BlockDeviceMappings' => '<p>A block device mapping, which specifies the block devices for the instance. You can specify virtual devices and EBS volumes. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/block-device-mapping-concepts.html">Block Device Mapping</a> in the <i>Amazon EC2 User Guide for Linux Instances</i>.</p>', 'LaunchConfiguration$BlockDeviceMappings' => '<p>A block device mapping, which specifies the block devices for the instance. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/block-device-mapping-concepts.html">Block Device Mapping</a> in the <i>Amazon EC2 User Guide for Linux Instances</i>.</p>', ], ], 'BurstablePerformance' => [ 'base' => NULL, 'refs' => [ 'InstanceRequirements$BurstablePerformance' => '<p>Indicates whether burstable performance instance types are included, excluded, or required. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/burstable-performance-instances.html">Burstable performance instances</a> in the <i>Amazon EC2 User Guide for Linux Instances</i>.</p> <p>Default: <code>excluded</code> </p>', ], ], 'CancelInstanceRefreshAnswer' => [ 'base' => NULL, 'refs' => [], ], 'CancelInstanceRefreshType' => [ 'base' => NULL, 'refs' => [], ], 'CapacityForecast' => [ 'base' => '<p>A <code>GetPredictiveScalingForecast</code> call returns the capacity forecast for a predictive scaling policy. This structure includes the data points for that capacity forecast, along with the timestamps of those data points. </p>', 'refs' => [ 'GetPredictiveScalingForecastAnswer$CapacityForecast' => '<p>The capacity forecast.</p>', ], ], 'CapacityRebalanceEnabled' => [ 'base' => NULL, 'refs' => [ 'AutoScalingGroup$CapacityRebalance' => '<p>Indicates whether Capacity Rebalancing is enabled.</p>', 'CreateAutoScalingGroupType$CapacityRebalance' => '<p>Indicates whether Capacity Rebalancing is enabled. Otherwise, Capacity Rebalancing is disabled. When you turn on Capacity Rebalancing, Amazon EC2 Auto Scaling attempts to launch a Spot Instance whenever Amazon EC2 notifies that a Spot Instance is at an elevated risk of interruption. After launching a new instance, it then terminates an old instance. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-capacity-rebalancing.html">Amazon EC2 Auto Scaling Capacity Rebalancing</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>', 'UpdateAutoScalingGroupType$CapacityRebalance' => '<p>Enables or disables Capacity Rebalancing. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-capacity-rebalancing.html">Amazon EC2 Auto Scaling Capacity Rebalancing</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>', ], ], 'CheckpointDelay' => [ 'base' => NULL, 'refs' => [ 'RefreshPreferences$CheckpointDelay' => '<p>The amount of time, in seconds, to wait after a checkpoint before continuing. This property is optional, but if you specify a value for it, you must also specify a value for <code>CheckpointPercentages</code>. If you specify a value for <code>CheckpointPercentages</code> and not for <code>CheckpointDelay</code>, the <code>CheckpointDelay</code> defaults to <code>3600</code> (1 hour). </p>', ], ], 'CheckpointPercentages' => [ 'base' => NULL, 'refs' => [ 'RefreshPreferences$CheckpointPercentages' => '<p>Threshold values for each checkpoint in ascending order. Each number must be unique. To replace all instances in the Auto Scaling group, the last number in the array must be <code>100</code>.</p> <p>For usage examples, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-adding-checkpoints-instance-refresh.html">Adding checkpoints to an instance refresh</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>', ], ], 'ClassicLinkVPCSecurityGroups' => [ 'base' => NULL, 'refs' => [ 'CreateLaunchConfigurationType$ClassicLinkVPCSecurityGroups' => '<p>The IDs of one or more security groups for the specified ClassicLink-enabled VPC. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/vpc-classiclink.html">ClassicLink</a> in the <i>Amazon EC2 User Guide for Linux Instances</i> and <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-in-vpc.html#as-ClassicLink">Linking EC2-Classic instances to a VPC</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p> <p>If you specify the <code>ClassicLinkVPCId</code> parameter, you must specify this parameter.</p>', 'LaunchConfiguration$ClassicLinkVPCSecurityGroups' => '<p>The IDs of one or more security groups for the VPC specified in <code>ClassicLinkVPCId</code>.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/vpc-classiclink.html">ClassicLink</a> in the <i>Amazon EC2 User Guide for Linux Instances</i> and <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-in-vpc.html#as-ClassicLink">Linking EC2-Classic instances to a VPC</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>', ], ], 'CompleteLifecycleActionAnswer' => [ 'base' => NULL, 'refs' => [], ], 'CompleteLifecycleActionType' => [ 'base' => NULL, 'refs' => [], ], 'Context' => [ 'base' => NULL, 'refs' => [ 'AutoScalingGroup$Context' => '<p>Reserved.</p>', 'CreateAutoScalingGroupType$Context' => '<p>Reserved.</p>', 'UpdateAutoScalingGroupType$Context' => '<p>Reserved.</p>', ], ], 'Cooldown' => [ 'base' => NULL, 'refs' => [ 'AutoScalingGroup$DefaultCooldown' => '<p>The duration of the default cooldown period, in seconds.</p>', 'CreateAutoScalingGroupType$DefaultCooldown' => '<p>The amount of time, in seconds, after a scaling activity completes before another scaling activity can start. The default value is <code>300</code>. This setting applies when using simple scaling policies, but not when using other scaling policies or scheduled scaling. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/Cooldown.html">Scaling cooldowns for Amazon EC2 Auto Scaling</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>', 'PutScalingPolicyType$Cooldown' => '<p>The duration of the policy\'s cooldown period, in seconds. When a cooldown period is specified here, it overrides the default cooldown period defined for the Auto Scaling group.</p> <p>Valid only if the policy type is <code>SimpleScaling</code>. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/Cooldown.html">Scaling cooldowns for Amazon EC2 Auto Scaling</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>', 'ScalingPolicy$Cooldown' => '<p>The duration of the policy\'s cooldown period, in seconds.</p>', 'UpdateAutoScalingGroupType$DefaultCooldown' => '<p>The amount of time, in seconds, after a scaling activity completes before another scaling activity can start. The default value is <code>300</code>. This setting applies when using simple scaling policies, but not when using other scaling policies or scheduled scaling. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/Cooldown.html">Scaling cooldowns for Amazon EC2 Auto Scaling</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>', ], ], 'CpuManufacturer' => [ 'base' => NULL, 'refs' => [ 'CpuManufacturers$member' => NULL, ], ], 'CpuManufacturers' => [ 'base' => NULL, 'refs' => [ 'InstanceRequirements$CpuManufacturers' => '<p>Lists which specific CPU manufacturers to include.</p> <ul> <li> <p>For instance types with Intel CPUs, specify <code>intel</code>.</p> </li> <li> <p>For instance types with AMD CPUs, specify <code>amd</code>.</p> </li> <li> <p>For instance types with Amazon Web Services CPUs, specify <code>amazon-web-services</code>.</p> </li> </ul> <note> <p>Don\'t confuse the CPU hardware manufacturer with the CPU hardware architecture. Instances will be launched with a compatible CPU architecture based on the Amazon Machine Image (AMI) that you specify in your launch template. </p> </note> <p>Default: Any manufacturer</p>', ], ], 'CreateAutoScalingGroupType' => [ 'base' => NULL, 'refs' => [], ], 'CreateLaunchConfigurationType' => [ 'base' => NULL, 'refs' => [], ], 'CreateOrUpdateTagsType' => [ 'base' => NULL, 'refs' => [], ], 'CustomizedMetricSpecification' => [ 'base' => '<p>Represents a CloudWatch metric of your choosing for a target tracking scaling policy to use with Amazon EC2 Auto Scaling.</p> <p>To create your customized metric specification:</p> <ul> <li> <p>Add values for each required parameter from CloudWatch. You can use an existing metric, or a new metric that you create. To use your own metric, you must first publish the metric to CloudWatch. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/publishingMetrics.html">Publish custom metrics</a> in the <i>Amazon CloudWatch User Guide</i>.</p> </li> <li> <p>Choose a metric that changes proportionally with capacity. The value of the metric should increase or decrease in inverse proportion to the number of capacity units. That is, the value of the metric should decrease when capacity increases.</p> </li> </ul> <p>For more information about the CloudWatch terminology below, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/cloudwatch_concepts.html">Amazon CloudWatch concepts</a>.</p> <note> <p>Each individual service provides information about the metrics, namespace, and dimensions they use. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/aws-services-cloudwatch-metrics.html">Amazon Web Services services that publish CloudWatch metrics</a> in the <i>Amazon CloudWatch User Guide</i>.</p> </note>', 'refs' => [ 'TargetTrackingConfiguration$CustomizedMetricSpecification' => '<p>A customized metric. You must specify either a predefined metric or a customized metric.</p>', ], ], 'DeleteAutoScalingGroupType' => [ 'base' => NULL, 'refs' => [], ], 'DeleteLifecycleHookAnswer' => [ 'base' => NULL, 'refs' => [], ], 'DeleteLifecycleHookType' => [ 'base' => NULL, 'refs' => [], ], 'DeleteNotificationConfigurationType' => [ 'base' => NULL, 'refs' => [], ], 'DeletePolicyType' => [ 'base' => NULL, 'refs' => [], ], 'DeleteScheduledActionType' => [ 'base' => NULL, 'refs' => [], ], 'DeleteTagsType' => [ 'base' => NULL, 'refs' => [], ], 'DeleteWarmPoolAnswer' => [ 'base' => NULL, 'refs' => [], ], 'DeleteWarmPoolType' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAccountLimitsAnswer' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAdjustmentTypesAnswer' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAutoScalingInstancesType' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAutoScalingNotificationTypesAnswer' => [ 'base' => NULL, 'refs' => [], ], 'DescribeInstanceRefreshesAnswer' => [ 'base' => NULL, 'refs' => [], ], 'DescribeInstanceRefreshesType' => [ 'base' => NULL, 'refs' => [], ], 'DescribeLifecycleHookTypesAnswer' => [ 'base' => NULL, 'refs' => [], ], 'DescribeLifecycleHooksAnswer' => [ 'base' => NULL, 'refs' => [], ], 'DescribeLifecycleHooksType' => [ 'base' => NULL, 'refs' => [], ], 'DescribeLoadBalancerTargetGroupsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeLoadBalancerTargetGroupsResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeLoadBalancersRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeLoadBalancersResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeMetricCollectionTypesAnswer' => [ 'base' => NULL, 'refs' => [], ], 'DescribeNotificationConfigurationsAnswer' => [ 'base' => NULL, 'refs' => [], ], 'DescribeNotificationConfigurationsType' => [ 'base' => NULL, 'refs' => [], ], 'DescribePoliciesType' => [ 'base' => NULL, 'refs' => [], ], 'DescribeScalingActivitiesType' => [ 'base' => NULL, 'refs' => [], ], 'DescribeScheduledActionsType' => [ 'base' => NULL, 'refs' => [], ], 'DescribeTagsType' => [ 'base' => NULL, 'refs' => [], ], 'DescribeTerminationPolicyTypesAnswer' => [ 'base' => NULL, 'refs' => [], ], 'DescribeWarmPoolAnswer' => [ 'base' => NULL, 'refs' => [], ], 'DescribeWarmPoolType' => [ 'base' => NULL, 'refs' => [], ], 'DesiredConfiguration' => [ 'base' => '<p>Describes the desired configuration for an instance refresh. </p> <p>If you specify a desired configuration, you must specify either a <code>LaunchTemplate</code> or a <code>MixedInstancesPolicy</code>. </p>', 'refs' => [ 'InstanceRefresh$DesiredConfiguration' => '<p>Describes the specific update you want to deploy.</p>', 'StartInstanceRefreshType$DesiredConfiguration' => '<p>The desired configuration. For example, the desired configuration can specify a new launch template or a new version of the current launch template.</p> <p>Once the instance refresh succeeds, Amazon EC2 Auto Scaling updates the settings of the Auto Scaling group to reflect the new desired configuration. </p> <note> <p>When you specify a new launch template or a new version of the current launch template for your desired configuration, consider enabling the <code>SkipMatching</code> property in preferences. If it\'s enabled, Amazon EC2 Auto Scaling skips replacing instances that already use the specified launch template and version. This can help you reduce the number of replacements that are required to apply updates. </p> </note>', ], ], 'DetachInstancesAnswer' => [ 'base' => NULL, 'refs' => [], ], 'DetachInstancesQuery' => [ 'base' => NULL, 'refs' => [], ], 'DetachLoadBalancerTargetGroupsResultType' => [ 'base' => NULL, 'refs' => [], ], 'DetachLoadBalancerTargetGroupsType' => [ 'base' => NULL, 'refs' => [], ], 'DetachLoadBalancersResultType' => [ 'base' => NULL, 'refs' => [], ], 'DetachLoadBalancersType' => [ 'base' => NULL, 'refs' => [], ], 'DisableMetricsCollectionQuery' => [ 'base' => NULL, 'refs' => [], ], 'DisableScaleIn' => [ 'base' => NULL, 'refs' => [ 'TargetTrackingConfiguration$DisableScaleIn' => '<p>Indicates whether scaling in by the target tracking scaling policy is disabled. If scaling in is disabled, the target tracking scaling policy doesn\'t remove instances from the Auto Scaling group. Otherwise, the target tracking scaling policy can remove instances from the Auto Scaling group. The default is <code>false</code>.</p>', ], ], 'Ebs' => [ 'base' => '<p>Describes information used to set up an Amazon EBS volume specified in a block device mapping.</p>', 'refs' => [ 'BlockDeviceMapping$Ebs' => '<p>Parameters used to automatically set up EBS volumes when an instance is launched.</p> <p>You can specify either <code>VirtualName</code> or <code>Ebs</code>, but not both.</p>', ], ], 'EbsOptimized' => [ 'base' => NULL, 'refs' => [ 'CreateLaunchConfigurationType$EbsOptimized' => '<p>Specifies whether the launch configuration is optimized for EBS I/O (<code>true</code>) or not (<code>false</code>). The optimization provides dedicated throughput to Amazon EBS and an optimized configuration stack to provide optimal I/O performance. This optimization is not available with all instance types. Additional fees are incurred when you enable EBS optimization for an instance type that is not EBS-optimized by default. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSOptimized.html">Amazon EBS-optimized instances</a> in the <i>Amazon EC2 User Guide for Linux Instances</i>.</p> <p>The default value is <code>false</code>.</p>', 'LaunchConfiguration$EbsOptimized' => '<p>Specifies whether the launch configuration is optimized for EBS I/O (<code>true</code>) or not (<code>false</code>). For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSOptimized.html">Amazon EBS-Optimized Instances</a> in the <i>Amazon EC2 User Guide for Linux Instances</i>.</p>', ], ], 'EnableMetricsCollectionQuery' => [ 'base' => NULL, 'refs' => [], ], 'EnabledMetric' => [ 'base' => '<p>Describes an enabled metric.</p>', 'refs' => [ 'EnabledMetrics$member' => NULL, ], ], 'EnabledMetrics' => [ 'base' => NULL, 'refs' => [ 'AutoScalingGroup$EnabledMetrics' => '<p>The metrics enabled for the group.</p>', ], ], 'EnterStandbyAnswer' => [ 'base' => NULL, 'refs' => [], ], 'EnterStandbyQuery' => [ 'base' => NULL, 'refs' => [], ], 'EstimatedInstanceWarmup' => [ 'base' => NULL, 'refs' => [ 'PutScalingPolicyType$EstimatedInstanceWarmup' => '<p>The estimated time, in seconds, until a newly launched instance can contribute to the CloudWatch metrics. If not provided, the default is to use the value from the default cooldown period for the Auto Scaling group.</p> <p>Valid only if the policy type is <code>TargetTrackingScaling</code> or <code>StepScaling</code>.</p>', 'ScalingPolicy$EstimatedInstanceWarmup' => '<p>The estimated time, in seconds, until a newly launched instance can contribute to the CloudWatch metrics.</p>', ], ], 'ExcludedInstance' => [ 'base' => NULL, 'refs' => [ 'ExcludedInstanceTypes$member' => NULL, ], ], 'ExcludedInstanceTypes' => [ 'base' => NULL, 'refs' => [ 'InstanceRequirements$ExcludedInstanceTypes' => '<p>Lists which instance types to exclude. You can use strings with one or more wild cards, represented by an asterisk (<code>*</code>). The following are examples: <code>c5*</code>, <code>m5a.*</code>, <code>r*</code>, <code>*3*</code>. </p> <p>For example, if you specify <code>c5*</code>, you are excluding the entire C5 instance family, which includes all C5a and C5n instance types. If you specify <code>m5a.*</code>, you are excluding all the M5a instance types, but not the M5n instance types.</p> <p>Default: No excluded instance types</p>', ], ], 'ExecutePolicyType' => [ 'base' => NULL, 'refs' => [], ], 'ExitStandbyAnswer' => [ 'base' => NULL, 'refs' => [], ], 'ExitStandbyQuery' => [ 'base' => NULL, 'refs' => [], ], 'FailedScheduledUpdateGroupActionRequest' => [ 'base' => '<p>Describes a scheduled action that could not be created, updated, or deleted.</p>', 'refs' => [ 'FailedScheduledUpdateGroupActionRequests$member' => NULL, ], ], 'FailedScheduledUpdateGroupActionRequests' => [ 'base' => NULL, 'refs' => [ 'BatchDeleteScheduledActionAnswer$FailedScheduledActions' => '<p>The names of the scheduled actions that could not be deleted, including an error message.</p>', 'BatchPutScheduledUpdateGroupActionAnswer$FailedScheduledUpdateGroupActions' => '<p>The names of the scheduled actions that could not be created or updated, including an error message.</p>', ], ], 'Filter' => [ 'base' => '<p>Describes a filter that is used to return a more specific list of results from a describe operation.</p> <p>If you specify multiple filters, the filters are automatically logically joined with an <code>AND</code>, and the request returns only the results that match all of the specified filters. </p> <p>For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/autoscaling-tagging.html">Tagging Auto Scaling groups and instances</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>', 'refs' => [ 'Filters$member' => NULL, ], ], 'Filters' => [ 'base' => NULL, 'refs' => [ 'AutoScalingGroupNamesType$Filters' => '<p>One or more filters to limit the results based on specific tags. </p>', 'DescribeTagsType$Filters' => '<p>One or more filters to scope the tags to return. The maximum number of filters per filter type (for example, <code>auto-scaling-group</code>) is 1000.</p>', ], ], 'ForceDelete' => [ 'base' => NULL, 'refs' => [ 'DeleteAutoScalingGroupType$ForceDelete' => '<p>Specifies that the group is to be deleted along with all instances associated with the group, without waiting for all instances to be terminated. This parameter also deletes any outstanding lifecycle actions associated with the group.</p>', 'DeleteWarmPoolType$ForceDelete' => '<p>Specifies that the warm pool is to be deleted along with all of its associated instances, without waiting for all instances to be terminated. This parameter also deletes any outstanding lifecycle actions associated with the warm pool instances.</p>', ], ], 'GetPredictiveScalingForecastAnswer' => [ 'base' => NULL, 'refs' => [], ], 'GetPredictiveScalingForecastType' => [ 'base' => NULL, 'refs' => [], ], 'GlobalTimeout' => [ 'base' => NULL, 'refs' => [ 'LifecycleHook$GlobalTimeout' => '<p>The maximum time, in seconds, that an instance can remain in a <code>Pending:Wait</code> or <code>Terminating:Wait</code> state. The maximum is 172800 seconds (48 hours) or 100 times <code>HeartbeatTimeout</code>, whichever is smaller.</p>', ], ], 'HealthCheckGracePeriod' => [ 'base' => NULL, 'refs' => [ 'AutoScalingGroup$HealthCheckGracePeriod' => '<p>The amount of time, in seconds, that Amazon EC2 Auto Scaling waits before checking the health status of an EC2 instance that has come into service and marking it unhealthy due to a failed health check.</p>', 'CreateAutoScalingGroupType$HealthCheckGracePeriod' => '<p>The amount of time, in seconds, that Amazon EC2 Auto Scaling waits before checking the health status of an EC2 instance that has come into service and marking it unhealthy due to a failed health check. The default value is <code>0</code>. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/healthcheck.html#health-check-grace-period">Health check grace period</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p> <p>Required if you are adding an <code>ELB</code> health check.</p>', 'UpdateAutoScalingGroupType$HealthCheckGracePeriod' => '<p>The amount of time, in seconds, that Amazon EC2 Auto Scaling waits before checking the health status of an EC2 instance that has come into service and marking it unhealthy due to a failed health check. The default value is <code>0</code>. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/healthcheck.html#health-check-grace-period">Health check grace period</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p> <p>Required if you are adding an <code>ELB</code> health check.</p>', ], ], 'HeartbeatTimeout' => [ 'base' => NULL, 'refs' => [ 'LifecycleHook$HeartbeatTimeout' => '<p>The maximum time, in seconds, that can elapse before the lifecycle hook times out. If the lifecycle hook times out, Amazon EC2 Auto Scaling performs the action that you specified in the <code>DefaultResult</code> parameter.</p>', 'LifecycleHookSpecification$HeartbeatTimeout' => '<p>The maximum time, in seconds, that can elapse before the lifecycle hook times out.</p> <p>If the lifecycle hook times out, Amazon EC2 Auto Scaling performs the action that you specified in the <code>DefaultResult</code> parameter. You can prevent the lifecycle hook from timing out by calling <a>RecordLifecycleActionHeartbeat</a>.</p>', 'PutLifecycleHookType$HeartbeatTimeout' => '<p>The maximum time, in seconds, that can elapse before the lifecycle hook times out. The range is from <code>30</code> to <code>7200</code> seconds. The default value is <code>3600</code> seconds (1 hour).</p> <p>If the lifecycle hook times out, Amazon EC2 Auto Scaling performs the action that you specified in the <code>DefaultResult</code> parameter. You can prevent the lifecycle hook from timing out by calling the <a>RecordLifecycleActionHeartbeat</a> API.</p>', ], ], 'HonorCooldown' => [ 'base' => NULL, 'refs' => [ 'ExecutePolicyType$HonorCooldown' => '<p>Indicates whether Amazon EC2 Auto Scaling waits for the cooldown period to complete before executing the policy.</p> <p>Valid only if the policy type is <code>SimpleScaling</code>. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/Cooldown.html">Scaling cooldowns for Amazon EC2 Auto Scaling</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>', 'SetDesiredCapacityType$HonorCooldown' => '<p>Indicates whether Amazon EC2 Auto Scaling waits for the cooldown period to complete before initiating a scaling activity to set your Auto Scaling group to its new capacity. By default, Amazon EC2 Auto Scaling does not honor the cooldown period during manual scaling activities.</p>', ], ], 'IncludeDeletedGroups' => [ 'base' => NULL, 'refs' => [ 'DescribeScalingActivitiesType$IncludeDeletedGroups' => '<p>Indicates whether to include scaling activity from deleted Auto Scaling groups.</p>', ], ], 'Instance' => [ 'base' => '<p>Describes an EC2 instance.</p>', 'refs' => [ 'Instances$member' => NULL, ], ], 'InstanceGeneration' => [ 'base' => NULL, 'refs' => [ 'InstanceGenerations$member' => NULL, ], ], 'InstanceGenerations' => [ 'base' => NULL, 'refs' => [ 'InstanceRequirements$InstanceGenerations' => '<p>Indicates whether current or previous generation instance types are included.</p> <ul> <li> <p>For current generation instance types, specify <code>current</code>. The current generation includes EC2 instance types currently recommended for use. This typically includes the latest two to three generations in each instance family. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Instance types</a> in the <i>Amazon EC2 User Guide for Linux Instances</i>.</p> </li> <li> <p>For previous generation instance types, specify <code>previous</code>.</p> </li> </ul> <p>Default: Any current or previous generation</p>', ], ], 'InstanceIds' => [ 'base' => NULL, 'refs' => [ 'AttachInstancesQuery$InstanceIds' => '<p>The IDs of the instances. You can specify up to 20 instances.</p>', 'DescribeAutoScalingInstancesType$InstanceIds' => '<p>The IDs of the instances. If you omit this parameter, all Auto Scaling instances are described. If you specify an ID that does not exist, it is ignored with no error.</p> <p>Array Members: Maximum number of 50 items.</p>', 'DetachInstancesQuery$InstanceIds' => '<p>The IDs of the instances. You can specify up to 20 instances.</p>', 'EnterStandbyQuery$InstanceIds' => '<p>The IDs of the instances. You can specify up to 20 instances.</p>', 'ExitStandbyQuery$InstanceIds' => '<p>The IDs of the instances. You can specify up to 20 instances.</p>', 'SetInstanceProtectionQuery$InstanceIds' => '<p>One or more instance IDs. You can specify up to 50 instances.</p>', ], ], 'InstanceMetadataEndpointState' => [ 'base' => NULL, 'refs' => [ 'InstanceMetadataOptions$HttpEndpoint' => '<p>This parameter enables or disables the HTTP metadata endpoint on your instances. If the parameter is not specified, the default state is <code>enabled</code>.</p> <note> <p>If you specify a value of <code>disabled</code>, you will not be able to access your instance metadata. </p> </note>', ], ], 'InstanceMetadataHttpPutResponseHopLimit' => [ 'base' => NULL, 'refs' => [ 'InstanceMetadataOptions$HttpPutResponseHopLimit' => '<p>The desired HTTP PUT response hop limit for instance metadata requests. The larger the number, the further instance metadata requests can travel.</p> <p>Default: 1</p>', ], ], 'InstanceMetadataHttpTokensState' => [ 'base' => NULL, 'refs' => [ 'InstanceMetadataOptions$HttpTokens' => '<p>The state of token usage for your instance metadata requests. If the parameter is not specified in the request, the default state is <code>optional</code>.</p> <p>If the state is <code>optional</code>, you can choose to retrieve instance metadata with or without a signed token header on your request. If you retrieve the IAM role credentials without a token, the version 1.0 role credentials are returned. If you retrieve the IAM role credentials using a valid signed token, the version 2.0 role credentials are returned.</p> <p>If the state is <code>required</code>, you must send a signed token header with any instance metadata retrieval requests. In this state, retrieving the IAM role credentials always returns the version 2.0 credentials; the version 1.0 credentials are not available.</p>', ], ], 'InstanceMetadataOptions' => [ 'base' => '<p>The metadata options for the instances. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/create-launch-config.html#launch-configurations-imds">Configuring the Instance Metadata Options</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>', 'refs' => [ 'CreateLaunchConfigurationType$MetadataOptions' => '<p>The metadata options for the instances. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/create-launch-config.html#launch-configurations-imds">Configuring the Instance Metadata Options</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>', 'LaunchConfiguration$MetadataOptions' => '<p>The metadata options for the instances. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/create-launch-config.html#launch-configurations-imds">Configuring the Instance Metadata Options</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>', ], ], 'InstanceMonitoring' => [ 'base' => '<p>Describes whether detailed monitoring is enabled for the Auto Scaling instances.</p>', 'refs' => [ 'CreateLaunchConfigurationType$InstanceMonitoring' => '<p>Controls whether instances in this group are launched with detailed (<code>true</code>) or basic (<code>false</code>) monitoring.</p> <p>The default value is <code>true</code> (enabled).</p> <important> <p>When detailed monitoring is enabled, Amazon CloudWatch generates metrics every minute and your account is charged a fee. When you disable detailed monitoring, CloudWatch generates metrics every 5 minutes. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/latest/userguide/enable-as-instance-metrics.html">Configure Monitoring for Auto Scaling Instances</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p> </important>', 'LaunchConfiguration$InstanceMonitoring' => '<p>Controls whether instances in this group are launched with detailed (<code>true</code>) or basic (<code>false</code>) monitoring.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/autoscaling/latest/userguide/enable-as-instance-metrics.html">Configure Monitoring for Auto Scaling Instances</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>', ], ], 'InstanceProtected' => [ 'base' => NULL, 'refs' => [ 'AutoScalingGroup$NewInstancesProtectedFromScaleIn' => '<p>Indicates whether newly launched instances are protected from termination by Amazon EC2 Auto Scaling when scaling in.</p>', 'AutoScalingInstanceDetails$ProtectedFromScaleIn' => '<p>Indicates whether the instance is protected from termination by Amazon EC2 Auto Scaling when scaling in.</p>', 'CreateAutoScalingGroupType$NewInstancesProtectedFromScaleIn' => '<p>Indicates whether newly launched instances are protected from termination by Amazon EC2 Auto Scaling when scaling in. For more information about preventing instances from terminating on scale in, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-instance-protection.html">Using instance scale-in protection</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>', 'Instance$ProtectedFromScaleIn' => '<p>Indicates whether the instance is protected from termination by Amazon EC2 Auto Scaling when scaling in.</p>', 'UpdateAutoScalingGroupType$NewInstancesProtectedFromScaleIn' => '<p>Indicates whether newly launched instances are protected from termination by Amazon EC2 Auto Scaling when scaling in. For more information about preventing instances from terminating on scale in, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-instance-protection.html">Using instance scale-in protection</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>', ], ], 'InstanceRefresh' => [ 'base' => '<p>Describes an instance refresh for an Auto Scaling group. </p>', 'refs' => [ 'InstanceRefreshes$member' => NULL, ], ], 'InstanceRefreshIds' => [ 'base' => NULL, 'refs' => [ 'DescribeInstanceRefreshesType$InstanceRefreshIds' => '<p>One or more instance refresh IDs.</p>', ], ], 'InstanceRefreshInProgressFault' => [ 'base' => '<p>The request failed because an active instance refresh operation already exists for the specified Auto Scaling group.</p>', 'refs' => [], ], 'InstanceRefreshLivePoolProgress' => [ 'base' => '<p>Reports the progress of an instance refresh on instances that are in the Auto Scaling group.</p>', 'refs' => [ 'InstanceRefreshProgressDetails$LivePoolProgress' => '<p>Indicates the progress of an instance refresh on instances that are in the Auto Scaling group.</p>', ], ], 'InstanceRefreshProgressDetails' => [ 'base' => '<p>Reports the progress of an instance refresh on an Auto Scaling group that has a warm pool. This includes separate details for instances in the warm pool and instances in the Auto Scaling group (the live pool).</p>', 'refs' => [ 'InstanceRefresh$ProgressDetails' => '<p>Additional progress details for an Auto Scaling group that has a warm pool.</p>', ], ], 'InstanceRefreshStatus' => [ 'base' => NULL, 'refs' => [ 'InstanceRefresh$Status' => '<p>The current status for the instance refresh operation:</p> <ul> <li> <p> <code>Pending</code> - The request was created, but the operation has not started.</p> </li> <li> <p> <code>InProgress</code> - The operation is in progress.</p> </li> <li> <p> <code>Successful</code> - The operation completed successfully.</p> </li> <li> <p> <code>Failed</code> - The operation failed to complete. You can troubleshoot using the status reason and the scaling activities. </p> </li> <li> <p> <code>Cancelling</code> - An ongoing operation is being cancelled. Cancellation does not roll back any replacements that have already been completed, but it prevents new replacements from being started. </p> </li> <li> <p> <code>Cancelled</code> - The operation is cancelled. </p> </li> </ul>', ], ], 'InstanceRefreshWarmPoolProgress' => [ 'base' => '<p>Reports the progress of an instance refresh on instances that are in the warm pool.</p>', 'refs' => [ 'InstanceRefreshProgressDetails$WarmPoolProgress' => '<p>Indicates the progress of an instance refresh on instances that are in the warm pool.</p>', ], ], 'InstanceRefreshes' => [ 'base' => NULL, 'refs' => [ 'DescribeInstanceRefreshesAnswer$InstanceRefreshes' => '<p>The instance refreshes for the specified group.</p>', ], ], 'InstanceRequirements' => [ 'base' => '<p>When you specify multiple parameters, you get instance types that satisfy all of the specified parameters. If you specify multiple values for a parameter, you get instance types that satisfy any of the specified values.</p> <p>Represents requirements for the types of instances that can be launched. You must specify <code>VCpuCount</code> and <code>MemoryMiB</code>, but all other parameters are optional. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/create-asg-instance-type-requirements.html">Creating an Auto Scaling group using attribute-based instance type selection</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>', 'refs' => [ 'LaunchTemplateOverrides$InstanceRequirements' => '<p>The instance requirements. When you specify instance requirements, Amazon EC2 Auto Scaling finds instance types that satisfy your requirements, and then uses your On-Demand and Spot allocation strategies to launch instances from these instance types, in the same way as when you specify a list of specific instance types. </p>', ], ], 'InstanceReusePolicy' => [ 'base' => '<p>Describes an instance reuse policy for a warm pool. </p> <p>For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-warm-pools.html">Warm pools for Amazon EC2 Auto Scaling</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>', 'refs' => [ 'PutWarmPoolType$InstanceReusePolicy' => '<p>Indicates whether instances in the Auto Scaling group can be returned to the warm pool on scale in. The default is to terminate instances in the Auto Scaling group when the group scales in.</p>', 'WarmPoolConfiguration$InstanceReusePolicy' => '<p>The instance reuse policy.</p>', ], ], 'Instances' => [ 'base' => NULL, 'refs' => [ 'AutoScalingGroup$Instances' => '<p>The EC2 instances associated with the group.</p>', 'DescribeWarmPoolAnswer$Instances' => '<p>The instances that are currently in the warm pool.</p>', ], ], 'InstancesDistribution' => [ 'base' => '<p>Describes an instances distribution for an Auto Scaling group.</p>', 'refs' => [ 'MixedInstancesPolicy$InstancesDistribution' => '<p>Specifies the instances distribution.</p>', ], ], 'InstancesToUpdate' => [ 'base' => NULL, 'refs' => [ 'InstanceRefresh$InstancesToUpdate' => '<p>The number of instances remaining to update before the instance refresh is complete.</p>', 'InstanceRefreshLivePoolProgress$InstancesToUpdate' => '<p>The number of instances remaining to update.</p>', 'InstanceRefreshWarmPoolProgress$InstancesToUpdate' => '<p>The number of instances remaining to update.</p>', ], ], 'IntPercent' => [ 'base' => NULL, 'refs' => [ 'InstanceRefresh$PercentageComplete' => '<p>The percentage of the instance refresh that is complete. For each instance replacement, Amazon EC2 Auto Scaling tracks the instance\'s health status and warm-up time. When the instance\'s health status changes to healthy and the specified warm-up time passes, the instance is considered updated and is added to the percentage complete.</p>', 'InstanceRefreshLivePoolProgress$PercentageComplete' => '<p>The percentage of instances in the Auto Scaling group that have been replaced. For each instance replacement, Amazon EC2 Auto Scaling tracks the instance\'s health status and warm-up time. When the instance\'s health status changes to healthy and the specified warm-up time passes, the instance is considered updated and is added to the percentage complete.</p>', 'InstanceRefreshWarmPoolProgress$PercentageComplete' => '<p>The percentage of instances in the warm pool that have been replaced. For each instance replacement, Amazon EC2 Auto Scaling tracks the instance\'s health status and warm-up time. When the instance\'s health status changes to healthy and the specified warm-up time passes, the instance is considered updated and is added to the percentage complete.</p>', 'RefreshPreferences$MinHealthyPercentage' => '<p>The amount of capacity in the Auto Scaling group that must remain healthy during an instance refresh to allow the operation to continue. The value is expressed as a percentage of the desired capacity of the Auto Scaling group (rounded up to the nearest integer). The default is <code>90</code>.</p> <p>Setting the minimum healthy percentage to 100 percent limits the rate of replacement to one instance at a time. In contrast, setting it to 0 percent has the effect of replacing all instances at the same time. </p>', ], ], 'InvalidNextToken' => [ 'base' => '<p>The <code>NextToken</code> value is not valid.</p>', 'refs' => [], ], 'LaunchConfiguration' => [ 'base' => '<p>Describes a launch configuration.</p>', 'refs' => [ 'LaunchConfigurations$member' => NULL, ], ], 'LaunchConfigurationNameType' => [ 'base' => NULL, 'refs' => [], ], 'LaunchConfigurationNames' => [ 'base' => NULL, 'refs' => [ 'LaunchConfigurationNamesType$LaunchConfigurationNames' => '<p>The launch configuration names. If you omit this parameter, all launch configurations are described.</p> <p>Array Members: Maximum number of 50 items.</p>', ], ], 'LaunchConfigurationNamesType' => [ 'base' => NULL, 'refs' => [], ], 'LaunchConfigurations' => [ 'base' => NULL, 'refs' => [ 'LaunchConfigurationsType$LaunchConfigurations' => '<p>The launch configurations.</p>', ], ], 'LaunchConfigurationsType' => [ 'base' => NULL, 'refs' => [], ], 'LaunchTemplate' => [ 'base' => '<p>Describes a launch template and overrides. You specify these properties as part of a mixed instances policy. </p>', 'refs' => [ 'MixedInstancesPolicy$LaunchTemplate' => '<p>Specifies the launch template to use and the instance types (overrides) that are used to launch EC2 instances to fulfill On-Demand and Spot capacities. Required when creating a mixed instances policy.</p>', ], ], 'LaunchTemplateName' => [ 'base' => NULL, 'refs' => [ 'LaunchTemplateSpecification$LaunchTemplateName' => '<p>The name of the launch template. To get the template name, use the Amazon EC2 <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeLaunchTemplates.html">DescribeLaunchTemplates</a> API operation. New launch templates can be created using the Amazon EC2 <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateLaunchTemplate.html">CreateLaunchTemplate</a> API. </p> <p>Conditional: You must specify either a <code>LaunchTemplateId</code> or a <code>LaunchTemplateName</code>.</p>', ], ], 'LaunchTemplateOverrides' => [ 'base' => '<p>Describes an override for a launch template. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-configuring-overrides.html">Configuring overrides</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>. </p>', 'refs' => [ 'Overrides$member' => NULL, ], ], 'LaunchTemplateSpecification' => [ 'base' => '<p>Describes the launch template and the version of the launch template that Amazon EC2 Auto Scaling uses to launch Amazon EC2 instances. For more information about launch templates, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/LaunchTemplates.html">Launch templates</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>', 'refs' => [ 'AutoScalingGroup$LaunchTemplate' => '<p>The launch template for the group.</p>', 'AutoScalingInstanceDetails$LaunchTemplate' => '<p>The launch template for the instance.</p>', 'CreateAutoScalingGroupType$LaunchTemplate' => '<p>Parameters used to specify the launch template and version to use to launch instances. </p> <p>Conditional: You must specify either a launch template (<code>LaunchTemplate</code> or <code>MixedInstancesPolicy</code>) or a launch configuration (<code>LaunchConfigurationName</code> or <code>InstanceId</code>).</p> <note> <p>The launch template that is specified must be configured for use with an Auto Scaling group. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/create-launch-template.html">Creating a launch template for an Auto Scaling group</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p> </note>', 'DesiredConfiguration$LaunchTemplate' => NULL, 'Instance$LaunchTemplate' => '<p>The launch template for the instance.</p>', 'LaunchTemplate$LaunchTemplateSpecification' => '<p>The launch template to use.</p>', 'LaunchTemplateOverrides$LaunchTemplateSpecification' => '<p>Provides a launch template for the specified instance type or instance requirements. For example, some instance types might require a launch template with a different AMI. If not provided, Amazon EC2 Auto Scaling uses the launch template that\'s defined for your mixed instances policy. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-mixed-instances-groups-launch-template-overrides.html">Specifying a different launch template for an instance type</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>. </p>', 'UpdateAutoScalingGroupType$LaunchTemplate' => '<p>The launch template and version to use to specify the updates. If you specify <code>LaunchTemplate</code> in your update request, you can\'t specify <code>LaunchConfigurationName</code> or <code>MixedInstancesPolicy</code>.</p>', ], ], 'LifecycleActionResult' => [ 'base' => NULL, 'refs' => [ 'CompleteLifecycleActionType$LifecycleActionResult' => '<p>The action for the group to take. This parameter can be either <code>CONTINUE</code> or <code>ABANDON</code>.</p>', 'LifecycleHook$DefaultResult' => '<p>Defines the action the Auto Scaling group should take when the lifecycle hook timeout elapses or if an unexpected failure occurs. The possible values are <code>CONTINUE</code> and <code>ABANDON</code>.</p>', 'LifecycleHookSpecification$DefaultResult' => '<p>Defines the action the Auto Scaling group should take when the lifecycle hook timeout elapses or if an unexpected failure occurs. The valid values are <code>CONTINUE</code> and <code>ABANDON</code>. The default value is <code>ABANDON</code>.</p>', 'PutLifecycleHookType$DefaultResult' => '<p>Defines the action the Auto Scaling group should take when the lifecycle hook timeout elapses or if an unexpected failure occurs. This parameter can be either <code>CONTINUE</code> or <code>ABANDON</code>. The default value is <code>ABANDON</code>.</p>', ], ], 'LifecycleActionToken' => [ 'base' => NULL, 'refs' => [ 'CompleteLifecycleActionType$LifecycleActionToken' => '<p>A universally unique identifier (UUID) that identifies a specific lifecycle action associated with an instance. Amazon EC2 Auto Scaling sends this token to the notification target you specified when you created the lifecycle hook.</p>', 'RecordLifecycleActionHeartbeatType$LifecycleActionToken' => '<p>A token that uniquely identifies a specific lifecycle action associated with an instance. Amazon EC2 Auto Scaling sends this token to the notification target that you specified when you created the lifecycle hook.</p>', ], ], 'LifecycleHook' => [ 'base' => '<p>Describes a lifecycle hook. A lifecycle hook lets you create solutions that are aware of events in the Auto Scaling instance lifecycle, and then perform a custom action on instances when the corresponding lifecycle event occurs.</p>', 'refs' => [ 'LifecycleHooks$member' => NULL, ], ], 'LifecycleHookNames' => [ 'base' => NULL, 'refs' => [ 'DescribeLifecycleHooksType$LifecycleHookNames' => '<p>The names of one or more lifecycle hooks. If you omit this parameter, all lifecycle hooks are described.</p>', ], ], 'LifecycleHookSpecification' => [ 'base' => '<p>Describes information used to specify a lifecycle hook for an Auto Scaling group.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/lifecycle-hooks.html">Amazon EC2 Auto Scaling lifecycle hooks</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>', 'refs' => [ 'LifecycleHookSpecifications$member' => NULL, ], ], 'LifecycleHookSpecifications' => [ 'base' => NULL, 'refs' => [ 'CreateAutoScalingGroupType$LifecycleHookSpecificationList' => '<p>One or more lifecycle hooks for the group, which specify actions to perform when Amazon EC2 Auto Scaling launches or terminates instances.</p>', ], ], 'LifecycleHooks' => [ 'base' => NULL, 'refs' => [ 'DescribeLifecycleHooksAnswer$LifecycleHooks' => '<p>The lifecycle hooks for the specified group.</p>', ], ], 'LifecycleState' => [ 'base' => NULL, 'refs' => [ 'Instance$LifecycleState' => '<p>A description of the current lifecycle state. The <code>Quarantined</code> state is not used. For information about lifecycle states, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/AutoScalingGroupLifecycle.html">Instance lifecycle</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>. </p>', ], ], 'LifecycleTransition' => [ 'base' => NULL, 'refs' => [ 'LifecycleHook$LifecycleTransition' => '<p>The state of the EC2 instance to which to attach the lifecycle hook. The following are possible values:</p> <ul> <li> <p>autoscaling:EC2_INSTANCE_LAUNCHING</p> </li> <li> <p>autoscaling:EC2_INSTANCE_TERMINATING</p> </li> </ul>', 'LifecycleHookSpecification$LifecycleTransition' => '<p>The state of the EC2 instance to which you want to attach the lifecycle hook. The valid values are:</p> <ul> <li> <p>autoscaling:EC2_INSTANCE_LAUNCHING</p> </li> <li> <p>autoscaling:EC2_INSTANCE_TERMINATING</p> </li> </ul>', 'PutLifecycleHookType$LifecycleTransition' => '<p>The instance state to which you want to attach the lifecycle hook. The valid values are:</p> <ul> <li> <p>autoscaling:EC2_INSTANCE_LAUNCHING</p> </li> <li> <p>autoscaling:EC2_INSTANCE_TERMINATING</p> </li> </ul> <p>Required for new lifecycle hooks, but optional when updating existing hooks.</p>', ], ], 'LimitExceededFault' => [ 'base' => '<p>You have already reached a limit for your Amazon EC2 Auto Scaling resources (for example, Auto Scaling groups, launch configurations, or lifecycle hooks). For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_DescribeAccountLimits.html">DescribeAccountLimits</a> in the <i>Amazon EC2 Auto Scaling API Reference</i>.</p>', 'refs' => [], ], 'LoadBalancerNames' => [ 'base' => NULL, 'refs' => [ 'AttachLoadBalancersType$LoadBalancerNames' => '<p>The names of the load balancers. You can specify up to 10 load balancers.</p>', 'AutoScalingGroup$LoadBalancerNames' => '<p>One or more load balancers associated with the group.</p>', 'CreateAutoScalingGroupType$LoadBalancerNames' => '<p>A list of Classic Load Balancers associated with this Auto Scaling group. For Application Load Balancers, Network Load Balancers, and Gateway Load Balancers, specify the <code>TargetGroupARNs</code> property instead.</p>', 'DetachLoadBalancersType$LoadBalancerNames' => '<p>The names of the load balancers. You can specify up to 10 load balancers.</p>', ], ], 'LoadBalancerState' => [ 'base' => '<p>Describes the state of a Classic Load Balancer.</p>', 'refs' => [ 'LoadBalancerStates$member' => NULL, ], ], 'LoadBalancerStates' => [ 'base' => NULL, 'refs' => [ 'DescribeLoadBalancersResponse$LoadBalancers' => '<p>The load balancers.</p>', ], ], 'LoadBalancerTargetGroupState' => [ 'base' => '<p>Describes the state of a target group.</p>', 'refs' => [ 'LoadBalancerTargetGroupStates$member' => NULL, ], ], 'LoadBalancerTargetGroupStates' => [ 'base' => NULL, 'refs' => [ 'DescribeLoadBalancerTargetGroupsResponse$LoadBalancerTargetGroups' => '<p>Information about the target groups.</p>', ], ], 'LoadForecast' => [ 'base' => '<p>A <code>GetPredictiveScalingForecast</code> call returns the load forecast for a predictive scaling policy. This structure includes the data points for that load forecast, along with the timestamps of those data points and the metric specification. </p>', 'refs' => [ 'LoadForecasts$member' => NULL, ], ], 'LoadForecasts' => [ 'base' => NULL, 'refs' => [ 'GetPredictiveScalingForecastAnswer$LoadForecast' => '<p>The load forecast.</p>', ], ], 'LocalStorage' => [ 'base' => NULL, 'refs' => [ 'InstanceRequirements$LocalStorage' => '<p>Indicates whether instance types with instance store volumes are included, excluded, or required. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/InstanceStorage.html">Amazon EC2 instance store</a> in the <i>Amazon EC2 User Guide for Linux Instances</i>.</p> <p>Default: <code>included</code> </p>', ], ], 'LocalStorageType' => [ 'base' => NULL, 'refs' => [ 'LocalStorageTypes$member' => NULL, ], ], 'LocalStorageTypes' => [ 'base' => NULL, 'refs' => [ 'InstanceRequirements$LocalStorageTypes' => '<p>Indicates the type of local storage that is required.</p> <ul> <li> <p>For instance types with hard disk drive (HDD) storage, specify <code>hdd</code>.</p> </li> <li> <p>For instance types with solid state drive (SSD) storage, specify <code>sdd</code>.</p> </li> </ul> <p>Default: Any local storage type</p>', ], ], 'MaxGroupPreparedCapacity' => [ 'base' => NULL, 'refs' => [ 'PutWarmPoolType$MaxGroupPreparedCapacity' => '<p>Specifies the maximum number of instances that are allowed to be in the warm pool or in any state except <code>Terminated</code> for the Auto Scaling group. This is an optional property. Specify it only if you do not want the warm pool size to be determined by the difference between the group\'s maximum capacity and its desired capacity. </p> <important> <p>If a value for <code>MaxGroupPreparedCapacity</code> is not specified, Amazon EC2 Auto Scaling launches and maintains the difference between the group\'s maximum capacity and its desired capacity. If you specify a value for <code>MaxGroupPreparedCapacity</code>, Amazon EC2 Auto Scaling uses the difference between the <code>MaxGroupPreparedCapacity</code> and the desired capacity instead. </p> <p>The size of the warm pool is dynamic. Only when <code>MaxGroupPreparedCapacity</code> and <code>MinSize</code> are set to the same value does the warm pool have an absolute size.</p> </important> <p>If the desired capacity of the Auto Scaling group is higher than the <code>MaxGroupPreparedCapacity</code>, the capacity of the warm pool is 0, unless you specify a value for <code>MinSize</code>. To remove a value that you previously set, include the property but specify -1 for the value. </p>', 'WarmPoolConfiguration$MaxGroupPreparedCapacity' => '<p>The maximum number of instances that are allowed to be in the warm pool or in any state except <code>Terminated</code> for the Auto Scaling group.</p>', ], ], 'MaxInstanceLifetime' => [ 'base' => NULL, 'refs' => [ 'AutoScalingGroup$MaxInstanceLifetime' => '<p>The maximum amount of time, in seconds, that an instance can be in service.</p> <p>Valid Range: Minimum value of 0.</p>', 'CreateAutoScalingGroupType$MaxInstanceLifetime' => '<p>The maximum amount of time, in seconds, that an instance can be in service. The default is null. If specified, the value must be either 0 or a number equal to or greater than 86,400 seconds (1 day). For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-max-instance-lifetime.html">Replacing Auto Scaling instances based on maximum instance lifetime</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>', 'UpdateAutoScalingGroupType$MaxInstanceLifetime' => '<p>The maximum amount of time, in seconds, that an instance can be in service. The default is null. If specified, the value must be either 0 or a number equal to or greater than 86,400 seconds (1 day). To clear a previously set value, specify a new value of 0. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-max-instance-lifetime.html">Replacing Auto Scaling instances based on maximum instance lifetime</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>', ], ], 'MaxNumberOfAutoScalingGroups' => [ 'base' => NULL, 'refs' => [ 'DescribeAccountLimitsAnswer$MaxNumberOfAutoScalingGroups' => '<p>The maximum number of groups allowed for your account. The default is 200 groups per Region.</p>', ], ], 'MaxNumberOfLaunchConfigurations' => [ 'base' => NULL, 'refs' => [ 'DescribeAccountLimitsAnswer$MaxNumberOfLaunchConfigurations' => '<p>The maximum number of launch configurations allowed for your account. The default is 200 launch configurations per Region.</p>', ], ], 'MaxRecords' => [ 'base' => NULL, 'refs' => [ 'AutoScalingGroupNamesType$MaxRecords' => '<p>The maximum number of items to return with this call. The default value is <code>50</code> and the maximum value is <code>100</code>.</p>', 'DescribeAutoScalingInstancesType$MaxRecords' => '<p>The maximum number of items to return with this call. The default value is <code>50</code> and the maximum value is <code>50</code>.</p>', 'DescribeInstanceRefreshesType$MaxRecords' => '<p>The maximum number of items to return with this call. The default value is <code>50</code> and the maximum value is <code>100</code>.</p>', 'DescribeLoadBalancerTargetGroupsRequest$MaxRecords' => '<p>The maximum number of items to return with this call. The default value is <code>100</code> and the maximum value is <code>100</code>.</p>', 'DescribeLoadBalancersRequest$MaxRecords' => '<p>The maximum number of items to return with this call. The default value is <code>100</code> and the maximum value is <code>100</code>.</p>', 'DescribeNotificationConfigurationsType$MaxRecords' => '<p>The maximum number of items to return with this call. The default value is <code>50</code> and the maximum value is <code>100</code>.</p>', 'DescribePoliciesType$MaxRecords' => '<p>The maximum number of items to be returned with each call. The default value is <code>50</code> and the maximum value is <code>100</code>.</p>', 'DescribeScalingActivitiesType$MaxRecords' => '<p>The maximum number of items to return with this call. The default value is <code>100</code> and the maximum value is <code>100</code>.</p>', 'DescribeScheduledActionsType$MaxRecords' => '<p>The maximum number of items to return with this call. The default value is <code>50</code> and the maximum value is <code>100</code>.</p>', 'DescribeTagsType$MaxRecords' => '<p>The maximum number of items to return with this call. The default value is <code>50</code> and the maximum value is <code>100</code>.</p>', 'DescribeWarmPoolType$MaxRecords' => '<p>The maximum number of instances to return with this call. The maximum value is <code>50</code>.</p>', 'LaunchConfigurationNamesType$MaxRecords' => '<p>The maximum number of items to return with this call. The default value is <code>50</code> and the maximum value is <code>100</code>.</p>', ], ], 'MemoryGiBPerVCpuRequest' => [ 'base' => '<p>Specifies the minimum and maximum for the <code>MemoryGiBPerVCpu</code> object when you specify <a>InstanceRequirements</a> for an Auto Scaling group.</p>', 'refs' => [ 'InstanceRequirements$MemoryGiBPerVCpu' => '<p>The minimum and maximum amount of memory per vCPU for an instance type, in GiB.</p> <p>Default: No minimum or maximum</p>', ], ], 'MemoryMiBRequest' => [ 'base' => '<p>Specifies the minimum and maximum for the <code>MemoryMiB</code> object when you specify <a>InstanceRequirements</a> for an Auto Scaling group.</p>', 'refs' => [ 'InstanceRequirements$MemoryMiB' => '<p>The minimum and maximum instance memory size for an instance type, in MiB.</p>', ], ], 'Metric' => [ 'base' => '<p>Represents a specific metric. </p>', 'refs' => [ 'MetricStat$Metric' => '<p>The CloudWatch metric to return, including the metric name, namespace, and dimensions. To get the exact metric name, namespace, and dimensions, inspect the <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_Metric.html">Metric</a> object that is returned by a call to <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_ListMetrics.html">ListMetrics</a>.</p>', ], ], 'MetricCollectionType' => [ 'base' => '<p>Describes a metric.</p>', 'refs' => [ 'MetricCollectionTypes$member' => NULL, ], ], 'MetricCollectionTypes' => [ 'base' => NULL, 'refs' => [ 'DescribeMetricCollectionTypesAnswer$Metrics' => '<p>One or more metrics.</p>', ], ], 'MetricDataQueries' => [ 'base' => NULL, 'refs' => [ 'PredictiveScalingCustomizedCapacityMetric$MetricDataQueries' => '<p>One or more metric data queries to provide the data points for a capacity metric. Use multiple metric data queries only if you are performing a math expression on returned data. </p>', 'PredictiveScalingCustomizedLoadMetric$MetricDataQueries' => '<p>One or more metric data queries to provide the data points for a load metric. Use multiple metric data queries only if you are performing a math expression on returned data. </p>', 'PredictiveScalingCustomizedScalingMetric$MetricDataQueries' => '<p>One or more metric data queries to provide the data points for a scaling metric. Use multiple metric data queries only if you are performing a math expression on returned data. </p>', ], ], 'MetricDataQuery' => [ 'base' => '<p>The metric data to return. Also defines whether this call is returning data for one metric only, or whether it is performing a math expression on the values of returned metric statistics to create a new time series. A time series is a series of data points, each of which is associated with a timestamp.</p> <p>For more information and examples, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/predictive-scaling-customized-metric-specification.html">Advanced predictive scaling policy configurations using custom metrics</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>', 'refs' => [ 'MetricDataQueries$member' => NULL, ], ], 'MetricDimension' => [ 'base' => '<p>Describes the dimension of a metric.</p>', 'refs' => [ 'MetricDimensions$member' => NULL, ], ], 'MetricDimensionName' => [ 'base' => NULL, 'refs' => [ 'MetricDimension$Name' => '<p>The name of the dimension.</p>', ], ], 'MetricDimensionValue' => [ 'base' => NULL, 'refs' => [ 'MetricDimension$Value' => '<p>The value of the dimension.</p>', ], ], 'MetricDimensions' => [ 'base' => NULL, 'refs' => [ 'CustomizedMetricSpecification$Dimensions' => '<p>The dimensions of the metric.</p> <p>Conditional: If you published your metric with dimensions, you must specify the same dimensions in your scaling policy.</p>', 'Metric$Dimensions' => '<p>The dimensions for the metric. For the list of available dimensions, see the Amazon Web Services documentation available from the table in <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/aws-services-cloudwatch-metrics.html">Amazon Web Services services that publish CloudWatch metrics </a> in the <i>Amazon CloudWatch User Guide</i>. </p> <p>Conditional: If you published your metric with dimensions, you must specify the same dimensions in your scaling policy.</p>', ], ], 'MetricGranularityType' => [ 'base' => '<p>Describes a granularity of a metric.</p>', 'refs' => [ 'MetricGranularityTypes$member' => NULL, ], ], 'MetricGranularityTypes' => [ 'base' => NULL, 'refs' => [ 'DescribeMetricCollectionTypesAnswer$Granularities' => '<p>The granularities for the metrics.</p>', ], ], 'MetricName' => [ 'base' => NULL, 'refs' => [ 'CustomizedMetricSpecification$MetricName' => '<p>The name of the metric. To get the exact metric name, namespace, and dimensions, inspect the <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_Metric.html">Metric</a> object that is returned by a call to <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_ListMetrics.html">ListMetrics</a>.</p>', 'Metric$MetricName' => '<p>The name of the metric.</p>', ], ], 'MetricNamespace' => [ 'base' => NULL, 'refs' => [ 'CustomizedMetricSpecification$Namespace' => '<p>The namespace of the metric.</p>', 'Metric$Namespace' => '<p>The namespace of the metric. For more information, see the table in <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/aws-services-cloudwatch-metrics.html">Amazon Web Services services that publish CloudWatch metrics </a> in the <i>Amazon CloudWatch User Guide</i>.</p>', ], ], 'MetricScale' => [ 'base' => NULL, 'refs' => [ 'ExecutePolicyType$MetricValue' => '<p>The metric value to compare to <code>BreachThreshold</code>. This enables you to execute a policy of type <code>StepScaling</code> and determine which step adjustment to use. For example, if the breach threshold is 50 and you want to use a step adjustment with a lower bound of 0 and an upper bound of 10, you can set the metric value to 59.</p> <p>If you specify a metric value that doesn\'t correspond to a step adjustment for the policy, the call returns an error.</p> <p>Required if the policy type is <code>StepScaling</code> and not supported otherwise.</p>', 'ExecutePolicyType$BreachThreshold' => '<p>The breach threshold for the alarm.</p> <p>Required if the policy type is <code>StepScaling</code> and not supported otherwise.</p>', 'PredictiveScalingForecastValues$member' => NULL, 'PredictiveScalingMetricSpecification$TargetValue' => '<p>Specifies the target utilization.</p> <note> <p>Some metrics are based on a count instead of a percentage, such as the request count for an Application Load Balancer or the number of messages in an SQS queue. If the scaling policy specifies one of these metrics, specify the target utilization as the optimal average request or message count per instance during any one-minute interval. </p> </note>', 'StepAdjustment$MetricIntervalLowerBound' => '<p>The lower bound for the difference between the alarm threshold and the CloudWatch metric. If the metric value is above the breach threshold, the lower bound is inclusive (the metric must be greater than or equal to the threshold plus the lower bound). Otherwise, it is exclusive (the metric must be greater than the threshold plus the lower bound). A null value indicates negative infinity.</p>', 'StepAdjustment$MetricIntervalUpperBound' => '<p>The upper bound for the difference between the alarm threshold and the CloudWatch metric. If the metric value is above the breach threshold, the upper bound is exclusive (the metric must be less than the threshold plus the upper bound). Otherwise, it is inclusive (the metric must be less than or equal to the threshold plus the upper bound). A null value indicates positive infinity.</p> <p>The upper bound must be greater than the lower bound.</p>', 'TargetTrackingConfiguration$TargetValue' => '<p>The target value for the metric.</p> <note> <p>Some metrics are based on a count instead of a percentage, such as the request count for an Application Load Balancer or the number of messages in an SQS queue. If the scaling policy specifies one of these metrics, specify the target utilization as the optimal average request or message count per instance during any one-minute interval. </p> </note>', ], ], 'MetricStat' => [ 'base' => '<p>This structure defines the CloudWatch metric to return, along with the statistic, period, and unit.</p> <p>For more information about the CloudWatch terminology below, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/cloudwatch_concepts.html">Amazon CloudWatch concepts</a> in the <i>Amazon CloudWatch User Guide</i>.</p>', 'refs' => [ 'MetricDataQuery$MetricStat' => '<p>Information about the metric data to return.</p> <p>Conditional: Within each <code>MetricDataQuery</code> object, you must specify either <code>Expression</code> or <code>MetricStat</code>, but not both.</p>', ], ], 'MetricStatistic' => [ 'base' => NULL, 'refs' => [ 'CustomizedMetricSpecification$Statistic' => '<p>The statistic of the metric.</p>', ], ], 'MetricType' => [ 'base' => NULL, 'refs' => [ 'PredefinedMetricSpecification$PredefinedMetricType' => '<p>The metric type. The following predefined metrics are available:</p> <ul> <li> <p> <code>ASGAverageCPUUtilization</code> - Average CPU utilization of the Auto Scaling group.</p> </li> <li> <p> <code>ASGAverageNetworkIn</code> - Average number of bytes received (per instance per minute) for the Auto Scaling group.</p> </li> <li> <p> <code>ASGAverageNetworkOut</code> - Average number of bytes sent out (per instance per minute) for the Auto Scaling group.</p> </li> <li> <p> <code>ALBRequestCountPerTarget</code> - Average Application Load Balancer request count (per target per minute) for your Auto Scaling group.</p> </li> </ul>', ], ], 'MetricUnit' => [ 'base' => NULL, 'refs' => [ 'CustomizedMetricSpecification$Unit' => '<p>The unit of the metric. For a complete list of the units that CloudWatch supports, see the <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_MetricDatum.html">MetricDatum</a> data type in the <i>Amazon CloudWatch API Reference</i>.</p>', 'MetricStat$Unit' => '<p>The unit to use for the returned data points. For a complete list of the units that CloudWatch supports, see the <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_MetricDatum.html">MetricDatum</a> data type in the <i>Amazon CloudWatch API Reference</i>.</p>', ], ], 'Metrics' => [ 'base' => NULL, 'refs' => [ 'DisableMetricsCollectionQuery$Metrics' => '<p>Specifies one or more of the following metrics:</p> <ul> <li> <p> <code>GroupMinSize</code> </p> </li> <li> <p> <code>GroupMaxSize</code> </p> </li> <li> <p> <code>GroupDesiredCapacity</code> </p> </li> <li> <p> <code>GroupInServiceInstances</code> </p> </li> <li> <p> <code>GroupPendingInstances</code> </p> </li> <li> <p> <code>GroupStandbyInstances</code> </p> </li> <li> <p> <code>GroupTerminatingInstances</code> </p> </li> <li> <p> <code>GroupTotalInstances</code> </p> </li> <li> <p> <code>GroupInServiceCapacity</code> </p> </li> <li> <p> <code>GroupPendingCapacity</code> </p> </li> <li> <p> <code>GroupStandbyCapacity</code> </p> </li> <li> <p> <code>GroupTerminatingCapacity</code> </p> </li> <li> <p> <code>GroupTotalCapacity</code> </p> </li> <li> <p> <code>WarmPoolDesiredCapacity</code> </p> </li> <li> <p> <code>WarmPoolWarmedCapacity</code> </p> </li> <li> <p> <code>WarmPoolPendingCapacity</code> </p> </li> <li> <p> <code>WarmPoolTerminatingCapacity</code> </p> </li> <li> <p> <code>WarmPoolTotalCapacity</code> </p> </li> <li> <p> <code>GroupAndWarmPoolDesiredCapacity</code> </p> </li> <li> <p> <code>GroupAndWarmPoolTotalCapacity</code> </p> </li> </ul> <p>If you omit this parameter, all metrics are disabled. </p>', 'EnableMetricsCollectionQuery$Metrics' => '<p>Specifies which group-level metrics to start collecting. You can specify one or more of the following metrics:</p> <ul> <li> <p> <code>GroupMinSize</code> </p> </li> <li> <p> <code>GroupMaxSize</code> </p> </li> <li> <p> <code>GroupDesiredCapacity</code> </p> </li> <li> <p> <code>GroupInServiceInstances</code> </p> </li> <li> <p> <code>GroupPendingInstances</code> </p> </li> <li> <p> <code>GroupStandbyInstances</code> </p> </li> <li> <p> <code>GroupTerminatingInstances</code> </p> </li> <li> <p> <code>GroupTotalInstances</code> </p> </li> </ul> <p>The instance weighting feature supports the following additional metrics: </p> <ul> <li> <p> <code>GroupInServiceCapacity</code> </p> </li> <li> <p> <code>GroupPendingCapacity</code> </p> </li> <li> <p> <code>GroupStandbyCapacity</code> </p> </li> <li> <p> <code>GroupTerminatingCapacity</code> </p> </li> <li> <p> <code>GroupTotalCapacity</code> </p> </li> </ul> <p>The warm pools feature supports the following additional metrics: </p> <ul> <li> <p> <code>WarmPoolDesiredCapacity</code> </p> </li> <li> <p> <code>WarmPoolWarmedCapacity</code> </p> </li> <li> <p> <code>WarmPoolPendingCapacity</code> </p> </li> <li> <p> <code>WarmPoolTerminatingCapacity</code> </p> </li> <li> <p> <code>WarmPoolTotalCapacity</code> </p> </li> <li> <p> <code>GroupAndWarmPoolDesiredCapacity</code> </p> </li> <li> <p> <code>GroupAndWarmPoolTotalCapacity</code> </p> </li> </ul> <p>If you omit this parameter, all metrics are enabled. </p>', ], ], 'MinAdjustmentMagnitude' => [ 'base' => NULL, 'refs' => [ 'PutScalingPolicyType$MinAdjustmentMagnitude' => '<p>The minimum value to scale by when the adjustment type is <code>PercentChangeInCapacity</code>. For example, suppose that you create a step scaling policy to scale out an Auto Scaling group by 25 percent and you specify a <code>MinAdjustmentMagnitude</code> of 2. If the group has 4 instances and the scaling policy is performed, 25 percent of 4 is 1. However, because you specified a <code>MinAdjustmentMagnitude</code> of 2, Amazon EC2 Auto Scaling scales out the group by 2 instances.</p> <p>Valid only if the policy type is <code>StepScaling</code> or <code>SimpleScaling</code>. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-scaling-simple-step.html#as-scaling-adjustment">Scaling adjustment types</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p> <note> <p>Some Auto Scaling groups use instance weights. In this case, set the <code>MinAdjustmentMagnitude</code> to a value that is at least as large as your largest instance weight.</p> </note>', 'ScalingPolicy$MinAdjustmentMagnitude' => '<p>The minimum value to scale by when the adjustment type is <code>PercentChangeInCapacity</code>. </p>', ], ], 'MinAdjustmentStep' => [ 'base' => NULL, 'refs' => [ 'PutScalingPolicyType$MinAdjustmentStep' => '<p>Available for backward compatibility. Use <code>MinAdjustmentMagnitude</code> instead.</p>', 'ScalingPolicy$MinAdjustmentStep' => '<p>Available for backward compatibility. Use <code>MinAdjustmentMagnitude</code> instead.</p>', ], ], 'MixedInstanceSpotPrice' => [ 'base' => NULL, 'refs' => [ 'InstancesDistribution$SpotMaxPrice' => '<p>The maximum price per unit hour that you are willing to pay for a Spot Instance. If you keep the value at its default (unspecified), Amazon EC2 Auto Scaling uses the On-Demand price as the maximum Spot price. To remove a value that you previously set, include the property but specify an empty string ("") for the value.</p>', ], ], 'MixedInstancesPolicy' => [ 'base' => '<p>Describes a mixed instances policy. A mixed instances policy contains the instance types that Amazon EC2 Auto Scaling can launch and other information that Amazon EC2 Auto Scaling can use to launch instances and help optimize your costs. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-mixed-instances-groups.html">Auto Scaling groups with multiple instance types and purchase options</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>', 'refs' => [ 'AutoScalingGroup$MixedInstancesPolicy' => '<p>The mixed instances policy for the group.</p>', 'CreateAutoScalingGroupType$MixedInstancesPolicy' => '<p>An embedded object that specifies a mixed instances policy.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-mixed-instances-groups.html">Auto Scaling groups with multiple instance types and purchase options</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>', 'DesiredConfiguration$MixedInstancesPolicy' => NULL, 'UpdateAutoScalingGroupType$MixedInstancesPolicy' => '<p>An embedded object that specifies a mixed instances policy. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-mixed-instances-groups.html">Auto Scaling groups with multiple instance types and purchase options</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>', ], ], 'MonitoringEnabled' => [ 'base' => NULL, 'refs' => [ 'InstanceMonitoring$Enabled' => '<p>If <code>true</code>, detailed monitoring is enabled. Otherwise, basic monitoring is enabled.</p>', ], ], 'NetworkInterfaceCountRequest' => [ 'base' => '<p>Specifies the minimum and maximum for the <code>NetworkInterfaceCount</code> object when you specify <a>InstanceRequirements</a> for an Auto Scaling group.</p>', 'refs' => [ 'InstanceRequirements$NetworkInterfaceCount' => '<p>The minimum and maximum number of network interfaces for an instance type.</p> <p>Default: No minimum or maximum</p>', ], ], 'NoDevice' => [ 'base' => NULL, 'refs' => [ 'BlockDeviceMapping$NoDevice' => '<p>Setting this value to <code>true</code> suppresses the specified device included in the block device mapping of the AMI.</p> <p>If <code>NoDevice</code> is <code>true</code> for the root device, instances might fail the EC2 health check. In that case, Amazon EC2 Auto Scaling launches replacement instances.</p> <p>If you specify <code>NoDevice</code>, you cannot specify <code>Ebs</code>.</p>', ], ], 'NonZeroIntPercent' => [ 'base' => NULL, 'refs' => [ 'CheckpointPercentages$member' => NULL, ], ], 'NotificationConfiguration' => [ 'base' => '<p>Describes a notification.</p>', 'refs' => [ 'NotificationConfigurations$member' => NULL, ], ], 'NotificationConfigurations' => [ 'base' => NULL, 'refs' => [ 'DescribeNotificationConfigurationsAnswer$NotificationConfigurations' => '<p>The notification configurations.</p>', ], ], 'NotificationTargetResourceName' => [ 'base' => NULL, 'refs' => [ 'LifecycleHook$NotificationTargetARN' => '<p>The ARN of the target that Amazon EC2 Auto Scaling sends notifications to when an instance is in the transition state for the lifecycle hook. The notification target can be either an SQS queue or an SNS topic.</p>', 'LifecycleHookSpecification$NotificationTargetARN' => '<p>The ARN of the target that Amazon EC2 Auto Scaling sends notifications to when an instance is in the transition state for the lifecycle hook. The notification target can be either an SQS queue or an SNS topic.</p>', 'PutLifecycleHookType$NotificationTargetARN' => '<p>The ARN of the notification target that Amazon EC2 Auto Scaling uses to notify you when an instance is in the transition state for the lifecycle hook. This target can be either an SQS queue or an SNS topic.</p> <p>If you specify an empty string, this overrides the current ARN.</p> <p>This operation uses the JSON format when sending notifications to an Amazon SQS queue, and an email key-value pair format when sending notifications to an Amazon SNS topic.</p> <p>When you specify a notification target, Amazon EC2 Auto Scaling sends it a test message. Test messages contain the following additional key-value pair: <code>"Event": "autoscaling:TEST_NOTIFICATION"</code>.</p>', ], ], 'NullableBoolean' => [ 'base' => NULL, 'refs' => [ 'InstanceRequirements$RequireHibernateSupport' => '<p>Indicates whether instance types must provide On-Demand Instance hibernation support.</p> <p>Default: <code>false</code> </p>', ], ], 'NullablePositiveDouble' => [ 'base' => NULL, 'refs' => [ 'MemoryGiBPerVCpuRequest$Min' => '<p>The memory minimum in GiB.</p>', 'MemoryGiBPerVCpuRequest$Max' => '<p>The memory maximum in GiB.</p>', 'TotalLocalStorageGBRequest$Min' => '<p>The storage minimum in GB.</p>', 'TotalLocalStorageGBRequest$Max' => '<p>The storage maximum in GB.</p>', ], ], 'NullablePositiveInteger' => [ 'base' => NULL, 'refs' => [ 'AcceleratorCountRequest$Min' => '<p>The minimum value.</p>', 'AcceleratorCountRequest$Max' => '<p>The maximum value.</p>', 'AcceleratorTotalMemoryMiBRequest$Min' => '<p>The memory minimum in MiB.</p>', 'AcceleratorTotalMemoryMiBRequest$Max' => '<p>The memory maximum in MiB.</p>', 'BaselineEbsBandwidthMbpsRequest$Min' => '<p>The minimum value in Mbps.</p>', 'BaselineEbsBandwidthMbpsRequest$Max' => '<p>The maximum value in Mbps.</p>', 'InstanceRequirements$SpotMaxPricePercentageOverLowestPrice' => '<p>The price protection threshold for Spot Instances. This is the maximum you’ll pay for a Spot Instance, expressed as a percentage higher than the cheapest M, C, or R instance type with your specified attributes. When Amazon EC2 Auto Scaling selects instance types with your attributes, we will exclude instance types whose price is higher than your threshold. The parameter accepts an integer, which Amazon EC2 Auto Scaling interprets as a percentage. To turn off price protection, specify a high value, such as <code>999999</code>. </p> <p>If you set <code>DesiredCapacityType</code> to <code>vcpu</code> or <code>memory-mib</code>, the price protection threshold is applied based on the per vCPU or per memory price instead of the per instance price. </p> <p>Default: <code>100</code> </p>', 'InstanceRequirements$OnDemandMaxPricePercentageOverLowestPrice' => '<p>The price protection threshold for On-Demand Instances. This is the maximum you’ll pay for an On-Demand Instance, expressed as a percentage higher than the cheapest M, C, or R instance type with your specified attributes. When Amazon EC2 Auto Scaling selects instance types with your attributes, we will exclude instance types whose price is higher than your threshold. The parameter accepts an integer, which Amazon EC2 Auto Scaling interprets as a percentage. To turn off price protection, specify a high value, such as <code>999999</code>. </p> <p>If you set <code>DesiredCapacityType</code> to <code>vcpu</code> or <code>memory-mib</code>, the price protection threshold is applied based on the per vCPU or per memory price instead of the per instance price. </p> <p>Default: <code>20</code> </p>', 'MemoryMiBRequest$Min' => '<p>The memory minimum in MiB.</p>', 'MemoryMiBRequest$Max' => '<p>The memory maximum in MiB.</p>', 'NetworkInterfaceCountRequest$Min' => '<p>The minimum number of network interfaces.</p>', 'NetworkInterfaceCountRequest$Max' => '<p>The maximum number of network interfaces.</p>', 'VCpuCountRequest$Min' => '<p>The minimum number of vCPUs.</p>', 'VCpuCountRequest$Max' => '<p>The maximum number of vCPUs.</p>', ], ], 'NumberOfAutoScalingGroups' => [ 'base' => NULL, 'refs' => [ 'DescribeAccountLimitsAnswer$NumberOfAutoScalingGroups' => '<p>The current number of groups for your account.</p>', ], ], 'NumberOfLaunchConfigurations' => [ 'base' => NULL, 'refs' => [ 'DescribeAccountLimitsAnswer$NumberOfLaunchConfigurations' => '<p>The current number of launch configurations for your account.</p>', ], ], 'OnDemandBaseCapacity' => [ 'base' => NULL, 'refs' => [ 'InstancesDistribution$OnDemandBaseCapacity' => '<p>The minimum amount of the Auto Scaling group\'s capacity that must be fulfilled by On-Demand Instances. This base portion is launched first as your group scales.</p> <p>If you specify weights for the instance types in the overrides, the base capacity is measured in the same unit of measurement as the instance types. If you specify <a>InstanceRequirements</a> in the overrides, the base capacity is measured in the same unit of measurement as your group\'s desired capacity.</p> <p>Default: <code>0</code> </p>', ], ], 'OnDemandPercentageAboveBaseCapacity' => [ 'base' => NULL, 'refs' => [ 'InstancesDistribution$OnDemandPercentageAboveBaseCapacity' => '<p>Controls the percentages of On-Demand Instances and Spot Instances for your additional capacity beyond <code>OnDemandBaseCapacity</code>. Expressed as a number (for example, 20 specifies 20% On-Demand Instances, 80% Spot Instances). If set to 100, only On-Demand Instances are used.</p> <p>Default: <code>100</code> </p>', ], ], 'Overrides' => [ 'base' => NULL, 'refs' => [ 'LaunchTemplate$Overrides' => '<p>Any properties that you specify override the same properties in the launch template. If not provided, Amazon EC2 Auto Scaling uses the instance type or instance type requirements specified in the launch template when it launches an instance.</p> <p>The overrides can include either one or more instance types or a set of instance requirements, but not both.</p>', ], ], 'PoliciesType' => [ 'base' => NULL, 'refs' => [], ], 'PolicyARNType' => [ 'base' => '<p>Contains the output of PutScalingPolicy.</p>', 'refs' => [], ], 'PolicyIncrement' => [ 'base' => NULL, 'refs' => [ 'PutScalingPolicyType$ScalingAdjustment' => '<p>The amount by which to scale, based on the specified adjustment type. A positive value adds to the current capacity while a negative number removes from the current capacity. For exact capacity, you must specify a positive value.</p> <p>Required if the policy type is <code>SimpleScaling</code>. (Not used with any other policy type.) </p>', 'ScalingPolicy$ScalingAdjustment' => '<p>The amount by which to scale, based on the specified adjustment type. A positive value adds to the current capacity while a negative number removes from the current capacity.</p>', 'StepAdjustment$ScalingAdjustment' => '<p>The amount by which to scale, based on the specified adjustment type. A positive value adds to the current capacity while a negative number removes from the current capacity.</p>', ], ], 'PolicyNames' => [ 'base' => NULL, 'refs' => [ 'DescribePoliciesType$PolicyNames' => '<p>The names of one or more policies. If you omit this parameter, all policies are described. If a group name is provided, the results are limited to that group. If you specify an unknown policy name, it is ignored with no error.</p> <p>Array Members: Maximum number of 50 items.</p>', ], ], 'PolicyTypes' => [ 'base' => NULL, 'refs' => [ 'DescribePoliciesType$PolicyTypes' => '<p>One or more policy types. The valid values are <code>SimpleScaling</code>, <code>StepScaling</code>, <code>TargetTrackingScaling</code>, and <code>PredictiveScaling</code>.</p>', ], ], 'PredefinedLoadMetricType' => [ 'base' => NULL, 'refs' => [ 'PredictiveScalingPredefinedLoadMetric$PredefinedMetricType' => '<p>The metric type.</p>', ], ], 'PredefinedMetricPairType' => [ 'base' => NULL, 'refs' => [ 'PredictiveScalingPredefinedMetricPair$PredefinedMetricType' => '<p>Indicates which metrics to use. There are two different types of metrics for each metric type: one is a load metric and one is a scaling metric. For example, if the metric type is <code>ASGCPUUtilization</code>, the Auto Scaling group\'s total CPU metric is used as the load metric, and the average CPU metric is used for the scaling metric.</p>', ], ], 'PredefinedMetricSpecification' => [ 'base' => '<p>Represents a predefined metric for a target tracking scaling policy to use with Amazon EC2 Auto Scaling.</p>', 'refs' => [ 'TargetTrackingConfiguration$PredefinedMetricSpecification' => '<p>A predefined metric. You must specify either a predefined metric or a customized metric.</p>', ], ], 'PredefinedScalingMetricType' => [ 'base' => NULL, 'refs' => [ 'PredictiveScalingPredefinedScalingMetric$PredefinedMetricType' => '<p>The metric type.</p>', ], ], 'PredictiveScalingConfiguration' => [ 'base' => '<p>Represents a predictive scaling policy configuration to use with Amazon EC2 Auto Scaling.</p>', 'refs' => [ 'PutScalingPolicyType$PredictiveScalingConfiguration' => '<p>A predictive scaling policy. Provides support for predefined and custom metrics.</p> <p>Predefined metrics include CPU utilization, network in/out, and the Application Load Balancer request count.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_PredictiveScalingConfiguration.html">PredictiveScalingConfiguration</a> in the <i>Amazon EC2 Auto Scaling API Reference</i>.</p> <p>Required if the policy type is <code>PredictiveScaling</code>.</p>', 'ScalingPolicy$PredictiveScalingConfiguration' => '<p>A predictive scaling policy.</p>', ], ], 'PredictiveScalingCustomizedCapacityMetric' => [ 'base' => '<p>Describes a customized capacity metric for a predictive scaling policy.</p>', 'refs' => [ 'PredictiveScalingMetricSpecification$CustomizedCapacityMetricSpecification' => '<p>The customized capacity metric specification.</p>', ], ], 'PredictiveScalingCustomizedLoadMetric' => [ 'base' => '<p>Describes a custom load metric for a predictive scaling policy.</p>', 'refs' => [ 'PredictiveScalingMetricSpecification$CustomizedLoadMetricSpecification' => '<p>The customized load metric specification.</p>', ], ], 'PredictiveScalingCustomizedScalingMetric' => [ 'base' => '<p>Describes a custom scaling metric for a predictive scaling policy.</p>', 'refs' => [ 'PredictiveScalingMetricSpecification$CustomizedScalingMetricSpecification' => '<p>The customized scaling metric specification.</p>', ], ], 'PredictiveScalingForecastTimestamps' => [ 'base' => NULL, 'refs' => [ 'CapacityForecast$Timestamps' => '<p>The timestamps for the data points, in UTC format.</p>', 'LoadForecast$Timestamps' => '<p>The timestamps for the data points, in UTC format.</p>', ], ], 'PredictiveScalingForecastValues' => [ 'base' => NULL, 'refs' => [ 'CapacityForecast$Values' => '<p>The values of the data points.</p>', 'LoadForecast$Values' => '<p>The values of the data points.</p>', ], ], 'PredictiveScalingMaxCapacityBreachBehavior' => [ 'base' => NULL, 'refs' => [ 'PredictiveScalingConfiguration$MaxCapacityBreachBehavior' => '<p>Defines the behavior that should be applied if the forecast capacity approaches or exceeds the maximum capacity of the Auto Scaling group. Defaults to <code>HonorMaxCapacity</code> if not specified.</p> <p>The following are possible values:</p> <ul> <li> <p> <code>HonorMaxCapacity</code> - Amazon EC2 Auto Scaling cannot scale out capacity higher than the maximum capacity. The maximum capacity is enforced as a hard limit. </p> </li> <li> <p> <code>IncreaseMaxCapacity</code> - Amazon EC2 Auto Scaling can scale out capacity higher than the maximum capacity when the forecast capacity is close to or exceeds the maximum capacity. The upper limit is determined by the forecasted capacity and the value for <code>MaxCapacityBuffer</code>.</p> </li> </ul>', ], ], 'PredictiveScalingMaxCapacityBuffer' => [ 'base' => NULL, 'refs' => [ 'PredictiveScalingConfiguration$MaxCapacityBuffer' => '<p>The size of the capacity buffer to use when the forecast capacity is close to or exceeds the maximum capacity. The value is specified as a percentage relative to the forecast capacity. For example, if the buffer is 10, this means a 10 percent buffer, such that if the forecast capacity is 50, and the maximum capacity is 40, then the effective maximum capacity is 55.</p> <p>If set to 0, Amazon EC2 Auto Scaling may scale capacity higher than the maximum capacity to equal but not exceed forecast capacity. </p> <p>Required if the <code>MaxCapacityBreachBehavior</code> property is set to <code>IncreaseMaxCapacity</code>, and cannot be used otherwise.</p>', ], ], 'PredictiveScalingMetricSpecification' => [ 'base' => '<p>This structure specifies the metrics and target utilization settings for a predictive scaling policy. </p> <p>You must specify either a metric pair, or a load metric and a scaling metric individually. Specifying a metric pair instead of individual metrics provides a simpler way to configure metrics for a scaling policy. You choose the metric pair, and the policy automatically knows the correct sum and average statistics to use for the load metric and the scaling metric.</p> <p>Example</p> <ul> <li> <p>You create a predictive scaling policy and specify <code>ALBRequestCount</code> as the value for the metric pair and <code>1000.0</code> as the target value. For this type of metric, you must provide the metric dimension for the corresponding target group, so you also provide a resource label for the Application Load Balancer target group that is attached to your Auto Scaling group.</p> </li> <li> <p>The number of requests the target group receives per minute provides the load metric, and the request count averaged between the members of the target group provides the scaling metric. In CloudWatch, this refers to the <code>RequestCount</code> and <code>RequestCountPerTarget</code> metrics, respectively.</p> </li> <li> <p>For optimal use of predictive scaling, you adhere to the best practice of using a dynamic scaling policy to automatically scale between the minimum capacity and maximum capacity in response to real-time changes in resource utilization.</p> </li> <li> <p>Amazon EC2 Auto Scaling consumes data points for the load metric over the last 14 days and creates an hourly load forecast for predictive scaling. (A minimum of 24 hours of data is required.)</p> </li> <li> <p>After creating the load forecast, Amazon EC2 Auto Scaling determines when to reduce or increase the capacity of your Auto Scaling group in each hour of the forecast period so that the average number of requests received by each instance is as close to 1000 requests per minute as possible at all times.</p> </li> </ul> <p>For information about using custom metrics with predictive scaling, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/predictive-scaling-customized-metric-specification.html">Advanced predictive scaling policy configurations using custom metrics</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>', 'refs' => [ 'LoadForecast$MetricSpecification' => '<p>The metric specification for the load forecast.</p>', 'PredictiveScalingMetricSpecifications$member' => NULL, ], ], 'PredictiveScalingMetricSpecifications' => [ 'base' => NULL, 'refs' => [ 'PredictiveScalingConfiguration$MetricSpecifications' => '<p>This structure includes the metrics and target utilization to use for predictive scaling. </p> <p>This is an array, but we currently only support a single metric specification. That is, you can specify a target value and a single metric pair, or a target value and one scaling metric and one load metric.</p>', ], ], 'PredictiveScalingMode' => [ 'base' => NULL, 'refs' => [ 'PredictiveScalingConfiguration$Mode' => '<p>The predictive scaling mode. Defaults to <code>ForecastOnly</code> if not specified.</p>', ], ], 'PredictiveScalingPredefinedLoadMetric' => [ 'base' => '<p>Describes a load metric for a predictive scaling policy.</p> <p>When returned in the output of <code>DescribePolicies</code>, it indicates that a predictive scaling policy uses individually specified load and scaling metrics instead of a metric pair.</p>', 'refs' => [ 'PredictiveScalingMetricSpecification$PredefinedLoadMetricSpecification' => '<p>The predefined load metric specification.</p>', ], ], 'PredictiveScalingPredefinedMetricPair' => [ 'base' => '<p>Represents a metric pair for a predictive scaling policy. </p>', 'refs' => [ 'PredictiveScalingMetricSpecification$PredefinedMetricPairSpecification' => '<p>The predefined metric pair specification from which Amazon EC2 Auto Scaling determines the appropriate scaling metric and load metric to use.</p>', ], ], 'PredictiveScalingPredefinedScalingMetric' => [ 'base' => '<p>Describes a scaling metric for a predictive scaling policy.</p> <p>When returned in the output of <code>DescribePolicies</code>, it indicates that a predictive scaling policy uses individually specified load and scaling metrics instead of a metric pair.</p>', 'refs' => [ 'PredictiveScalingMetricSpecification$PredefinedScalingMetricSpecification' => '<p>The predefined scaling metric specification.</p>', ], ], 'PredictiveScalingSchedulingBufferTime' => [ 'base' => NULL, 'refs' => [ 'PredictiveScalingConfiguration$SchedulingBufferTime' => '<p>The amount of time, in seconds, by which the instance launch time can be advanced. For example, the forecast says to add capacity at 10:00 AM, and you choose to pre-launch instances by 5 minutes. In that case, the instances will be launched at 9:55 AM. The intention is to give resources time to be provisioned. It can take a few minutes to launch an EC2 instance. The actual amount of time required depends on several factors, such as the size of the instance and whether there are startup scripts to complete. </p> <p>The value must be less than the forecast interval duration of 3600 seconds (60 minutes). Defaults to 300 seconds if not specified. </p>', ], ], 'ProcessNames' => [ 'base' => NULL, 'refs' => [ 'ScalingProcessQuery$ScalingProcesses' => '<p>One or more of the following processes:</p> <ul> <li> <p> <code>Launch</code> </p> </li> <li> <p> <code>Terminate</code> </p> </li> <li> <p> <code>AddToLoadBalancer</code> </p> </li> <li> <p> <code>AlarmNotification</code> </p> </li> <li> <p> <code>AZRebalance</code> </p> </li> <li> <p> <code>HealthCheck</code> </p> </li> <li> <p> <code>InstanceRefresh</code> </p> </li> <li> <p> <code>ReplaceUnhealthy</code> </p> </li> <li> <p> <code>ScheduledActions</code> </p> </li> </ul> <p>If you omit this parameter, all processes are specified.</p>', ], ], 'ProcessType' => [ 'base' => '<p>Describes a process type.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-suspend-resume-processes.html#process-types">Scaling processes</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>', 'refs' => [ 'Processes$member' => NULL, ], ], 'Processes' => [ 'base' => NULL, 'refs' => [ 'ProcessesType$Processes' => '<p>The names of the process types.</p>', ], ], 'ProcessesType' => [ 'base' => NULL, 'refs' => [], ], 'Progress' => [ 'base' => NULL, 'refs' => [ 'Activity$Progress' => '<p>A value between 0 and 100 that indicates the progress of the activity.</p>', ], ], 'PropagateAtLaunch' => [ 'base' => NULL, 'refs' => [ 'Tag$PropagateAtLaunch' => '<p>Determines whether the tag is added to new instances as they are launched in the group.</p>', 'TagDescription$PropagateAtLaunch' => '<p>Determines whether the tag is added to new instances as they are launched in the group.</p>', ], ], 'ProtectedFromScaleIn' => [ 'base' => NULL, 'refs' => [ 'SetInstanceProtectionQuery$ProtectedFromScaleIn' => '<p>Indicates whether the instance is protected from termination by Amazon EC2 Auto Scaling when scaling in.</p>', ], ], 'PutLifecycleHookAnswer' => [ 'base' => NULL, 'refs' => [], ], 'PutLifecycleHookType' => [ 'base' => NULL, 'refs' => [], ], 'PutNotificationConfigurationType' => [ 'base' => NULL, 'refs' => [], ], 'PutScalingPolicyType' => [ 'base' => NULL, 'refs' => [], ], 'PutScheduledUpdateGroupActionType' => [ 'base' => NULL, 'refs' => [], ], 'PutWarmPoolAnswer' => [ 'base' => NULL, 'refs' => [], ], 'PutWarmPoolType' => [ 'base' => NULL, 'refs' => [], ], 'RecordLifecycleActionHeartbeatAnswer' => [ 'base' => NULL, 'refs' => [], ], 'RecordLifecycleActionHeartbeatType' => [ 'base' => NULL, 'refs' => [], ], 'RefreshInstanceWarmup' => [ 'base' => NULL, 'refs' => [ 'RefreshPreferences$InstanceWarmup' => '<p>The number of seconds until a newly launched instance is configured and ready to use. During this time, Amazon EC2 Auto Scaling does not immediately move on to the next replacement. The default is to use the value for the health check grace period defined for the group.</p>', ], ], 'RefreshPreferences' => [ 'base' => '<p>Describes the preferences for an instance refresh.</p>', 'refs' => [ 'InstanceRefresh$Preferences' => NULL, 'StartInstanceRefreshType$Preferences' => '<p>Set of preferences associated with the instance refresh request. If not provided, the default values are used.</p>', ], ], 'RefreshStrategy' => [ 'base' => NULL, 'refs' => [ 'StartInstanceRefreshType$Strategy' => '<p>The strategy to use for the instance refresh. The only valid value is <code>Rolling</code>.</p> <p>A rolling update helps you update your instances gradually. A rolling update can fail due to failed health checks or if instances are on standby or are protected from scale in. If the rolling update process fails, any instances that are replaced are not rolled back to their previous configuration. </p>', ], ], 'ResourceContentionFault' => [ 'base' => '<p>You already have a pending update to an Amazon EC2 Auto Scaling resource (for example, an Auto Scaling group, instance, or load balancer).</p>', 'refs' => [], ], 'ResourceInUseFault' => [ 'base' => '<p>The operation can\'t be performed because the resource is in use.</p>', 'refs' => [], ], 'ResourceName' => [ 'base' => NULL, 'refs' => [ 'Activity$AutoScalingGroupARN' => '<p>The Amazon Resource Name (ARN) of the Auto Scaling group.</p>', 'Alarm$AlarmARN' => '<p>The Amazon Resource Name (ARN) of the alarm.</p>', 'AutoScalingGroup$AutoScalingGroupARN' => '<p>The Amazon Resource Name (ARN) of the Auto Scaling group.</p>', 'AutoScalingGroup$ServiceLinkedRoleARN' => '<p>The Amazon Resource Name (ARN) of the service-linked role that the Auto Scaling group uses to call other Amazon Web Services on your behalf.</p>', 'CompleteLifecycleActionType$AutoScalingGroupName' => '<p>The name of the Auto Scaling group.</p>', 'CreateAutoScalingGroupType$ServiceLinkedRoleARN' => '<p>The Amazon Resource Name (ARN) of the service-linked role that the Auto Scaling group uses to call other Amazon Web Services on your behalf. By default, Amazon EC2 Auto Scaling uses a service-linked role named <code>AWSServiceRoleForAutoScaling</code>, which it creates if it does not exist. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/autoscaling-service-linked-role.html">Service-linked roles</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>', 'DeletePolicyType$PolicyName' => '<p>The name or Amazon Resource Name (ARN) of the policy.</p>', 'ExecutePolicyType$PolicyName' => '<p>The name or ARN of the policy.</p>', 'LaunchConfiguration$LaunchConfigurationARN' => '<p>The Amazon Resource Name (ARN) of the launch configuration.</p>', 'PolicyARNType$PolicyARN' => '<p>The Amazon Resource Name (ARN) of the policy.</p>', 'PolicyNames$member' => NULL, 'RecordLifecycleActionHeartbeatType$AutoScalingGroupName' => '<p>The name of the Auto Scaling group.</p>', 'ScalingPolicy$PolicyARN' => '<p>The Amazon Resource Name (ARN) of the policy.</p>', 'ScheduledUpdateGroupAction$ScheduledActionARN' => '<p>The Amazon Resource Name (ARN) of the scheduled action.</p>', 'UpdateAutoScalingGroupType$ServiceLinkedRoleARN' => '<p>The Amazon Resource Name (ARN) of the service-linked role that the Auto Scaling group uses to call other Amazon Web Services on your behalf. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/autoscaling-service-linked-role.html">Service-linked roles</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>', ], ], 'ReturnData' => [ 'base' => NULL, 'refs' => [ 'MetricDataQuery$ReturnData' => '<p>Indicates whether to return the timestamps and raw data values of this metric. </p> <p>If you use any math expressions, specify <code>true</code> for this value for only the final math expression that the metric specification is based on. You must specify <code>false</code> for <code>ReturnData</code> for all the other metrics and expressions used in the metric specification.</p> <p>If you are only retrieving metrics and not performing any math expressions, do not specify anything for <code>ReturnData</code>. This sets it to its default (<code>true</code>).</p>', ], ], 'ReuseOnScaleIn' => [ 'base' => NULL, 'refs' => [ 'InstanceReusePolicy$ReuseOnScaleIn' => '<p>Specifies whether instances in the Auto Scaling group can be returned to the warm pool on scale in. </p>', ], ], 'ScalingActivityInProgressFault' => [ 'base' => '<p>The operation can\'t be performed because there are scaling activities in progress.</p>', 'refs' => [], ], 'ScalingActivityStatusCode' => [ 'base' => NULL, 'refs' => [ 'Activity$StatusCode' => '<p>The current status of the activity.</p>', ], ], 'ScalingPolicies' => [ 'base' => NULL, 'refs' => [ 'PoliciesType$ScalingPolicies' => '<p>The scaling policies.</p>', ], ], 'ScalingPolicy' => [ 'base' => '<p>Describes a scaling policy.</p>', 'refs' => [ 'ScalingPolicies$member' => NULL, ], ], 'ScalingPolicyEnabled' => [ 'base' => NULL, 'refs' => [ 'PutScalingPolicyType$Enabled' => '<p>Indicates whether the scaling policy is enabled or disabled. The default is enabled. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-enable-disable-scaling-policy.html">Disabling a scaling policy for an Auto Scaling group</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>', 'ScalingPolicy$Enabled' => '<p>Indicates whether the policy is enabled (<code>true</code>) or disabled (<code>false</code>).</p>', ], ], 'ScalingProcessQuery' => [ 'base' => NULL, 'refs' => [], ], 'ScheduledActionNames' => [ 'base' => NULL, 'refs' => [ 'BatchDeleteScheduledActionType$ScheduledActionNames' => '<p>The names of the scheduled actions to delete. The maximum number allowed is 50. </p>', 'DescribeScheduledActionsType$ScheduledActionNames' => '<p>The names of one or more scheduled actions. If you omit this parameter, all scheduled actions are described. If you specify an unknown scheduled action, it is ignored with no error.</p> <p>Array Members: Maximum number of 50 actions.</p>', ], ], 'ScheduledActionsType' => [ 'base' => NULL, 'refs' => [], ], 'ScheduledUpdateGroupAction' => [ 'base' => '<p>Describes a scheduled scaling action.</p>', 'refs' => [ 'ScheduledUpdateGroupActions$member' => NULL, ], ], 'ScheduledUpdateGroupActionRequest' => [ 'base' => '<p>Describes information used for one or more scheduled scaling action updates in a <a>BatchPutScheduledUpdateGroupAction</a> operation.</p>', 'refs' => [ 'ScheduledUpdateGroupActionRequests$member' => NULL, ], ], 'ScheduledUpdateGroupActionRequests' => [ 'base' => NULL, 'refs' => [ 'BatchPutScheduledUpdateGroupActionType$ScheduledUpdateGroupActions' => '<p>One or more scheduled actions. The maximum number allowed is 50.</p>', ], ], 'ScheduledUpdateGroupActions' => [ 'base' => NULL, 'refs' => [ 'ScheduledActionsType$ScheduledUpdateGroupActions' => '<p>The scheduled actions.</p>', ], ], 'SecurityGroups' => [ 'base' => NULL, 'refs' => [ 'CreateLaunchConfigurationType$SecurityGroups' => '<p>A list that contains the security groups to assign to the instances in the Auto Scaling group.</p> <p>[EC2-VPC] Specify the security group IDs. For more information, see <a href="https://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_SecurityGroups.html">Security Groups for Your VPC</a> in the <i>Amazon Virtual Private Cloud User Guide</i>.</p> <p>[EC2-Classic] Specify either the security group names or the security group IDs. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-network-security.html">Amazon EC2 Security Groups</a> in the <i>Amazon EC2 User Guide for Linux Instances</i>.</p>', 'LaunchConfiguration$SecurityGroups' => '<p>A list that contains the security groups to assign to the instances in the Auto Scaling group. For more information, see <a href="https://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_SecurityGroups.html">Security Groups for Your VPC</a> in the <i>Amazon Virtual Private Cloud User Guide</i>.</p>', ], ], 'ServiceLinkedRoleFailure' => [ 'base' => '<p>The service-linked role is not yet ready for use.</p>', 'refs' => [], ], 'SetDesiredCapacityType' => [ 'base' => NULL, 'refs' => [], ], 'SetInstanceHealthQuery' => [ 'base' => NULL, 'refs' => [], ], 'SetInstanceProtectionAnswer' => [ 'base' => NULL, 'refs' => [], ], 'SetInstanceProtectionQuery' => [ 'base' => NULL, 'refs' => [], ], 'ShouldDecrementDesiredCapacity' => [ 'base' => NULL, 'refs' => [ 'DetachInstancesQuery$ShouldDecrementDesiredCapacity' => '<p>Indicates whether the Auto Scaling group decrements the desired capacity value by the number of instances detached.</p>', 'EnterStandbyQuery$ShouldDecrementDesiredCapacity' => '<p>Indicates whether to decrement the desired capacity of the Auto Scaling group by the number of instances moved to <code>Standby</code> mode.</p>', 'TerminateInstanceInAutoScalingGroupType$ShouldDecrementDesiredCapacity' => '<p>Indicates whether terminating the instance also decrements the size of the Auto Scaling group.</p>', ], ], 'ShouldRespectGracePeriod' => [ 'base' => NULL, 'refs' => [ 'SetInstanceHealthQuery$ShouldRespectGracePeriod' => '<p>If the Auto Scaling group of the specified instance has a <code>HealthCheckGracePeriod</code> specified for the group, by default, this call respects the grace period. Set this to <code>False</code>, to have the call not respect the grace period associated with the group.</p> <p>For more information about the health check grace period, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_CreateAutoScalingGroup.html">CreateAutoScalingGroup</a> in the <i>Amazon EC2 Auto Scaling API Reference</i>.</p>', ], ], 'SkipMatching' => [ 'base' => NULL, 'refs' => [ 'RefreshPreferences$SkipMatching' => '<p>A boolean value that indicates whether skip matching is enabled. If true, then Amazon EC2 Auto Scaling skips replacing instances that match the desired configuration. If no desired configuration is specified, then it skips replacing instances that have the same configuration that is already set on the group. The default is <code>false</code>.</p>', ], ], 'SpotInstancePools' => [ 'base' => NULL, 'refs' => [ 'InstancesDistribution$SpotInstancePools' => '<p>The number of Spot Instance pools across which to allocate your Spot Instances. The Spot pools are determined from the different instance types in the overrides. Valid only when the Spot allocation strategy is <code>lowest-price</code>. Value must be in the range of 1–20.</p> <p>Default: <code>2</code> </p>', ], ], 'SpotPrice' => [ 'base' => NULL, 'refs' => [ 'CreateLaunchConfigurationType$SpotPrice' => '<p>The maximum hourly price to be paid for any Spot Instance launched to fulfill the request. Spot Instances are launched when the price you specify exceeds the current Spot price. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-launch-spot-instances.html">Requesting Spot Instances</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p> <note> <p>When you change your maximum price by creating a new launch configuration, running instances will continue to run as long as the maximum price for those running instances is higher than the current Spot price.</p> </note>', 'LaunchConfiguration$SpotPrice' => '<p>The maximum hourly price to be paid for any Spot Instance launched to fulfill the request. Spot Instances are launched when the price you specify exceeds the current Spot price. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-launch-spot-instances.html">Requesting Spot Instances</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>', ], ], 'StartInstanceRefreshAnswer' => [ 'base' => NULL, 'refs' => [], ], 'StartInstanceRefreshType' => [ 'base' => NULL, 'refs' => [], ], 'StepAdjustment' => [ 'base' => '<p>Describes information used to create a step adjustment for a step scaling policy.</p> <p>For the following examples, suppose that you have an alarm with a breach threshold of 50:</p> <ul> <li> <p>To trigger the adjustment when the metric is greater than or equal to 50 and less than 60, specify a lower bound of 0 and an upper bound of 10.</p> </li> <li> <p>To trigger the adjustment when the metric is greater than 40 and less than or equal to 50, specify a lower bound of -10 and an upper bound of 0.</p> </li> </ul> <p>There are a few rules for the step adjustments for your step policy:</p> <ul> <li> <p>The ranges of your step adjustments can\'t overlap or have a gap.</p> </li> <li> <p>At most, one step adjustment can have a null lower bound. If one step adjustment has a negative lower bound, then there must be a step adjustment with a null lower bound.</p> </li> <li> <p>At most, one step adjustment can have a null upper bound. If one step adjustment has a positive upper bound, then there must be a step adjustment with a null upper bound.</p> </li> <li> <p>The upper and lower bound can\'t be null in the same step adjustment.</p> </li> </ul> <p>For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-scaling-simple-step.html#as-scaling-steps">Step adjustments</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>', 'refs' => [ 'StepAdjustments$member' => NULL, ], ], 'StepAdjustments' => [ 'base' => NULL, 'refs' => [ 'PutScalingPolicyType$StepAdjustments' => '<p>A set of adjustments that enable you to scale based on the size of the alarm breach.</p> <p>Required if the policy type is <code>StepScaling</code>. (Not used with any other policy type.) </p>', 'ScalingPolicy$StepAdjustments' => '<p>A set of adjustments that enable you to scale based on the size of the alarm breach.</p>', ], ], 'SuspendedProcess' => [ 'base' => '<p>Describes an auto scaling process that has been suspended.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-suspend-resume-processes.html#process-types">Scaling processes</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>', 'refs' => [ 'SuspendedProcesses$member' => NULL, ], ], 'SuspendedProcesses' => [ 'base' => NULL, 'refs' => [ 'AutoScalingGroup$SuspendedProcesses' => '<p>The suspended processes associated with the group.</p>', ], ], 'Tag' => [ 'base' => '<p>Describes a tag for an Auto Scaling group.</p>', 'refs' => [ 'Tags$member' => NULL, ], ], 'TagDescription' => [ 'base' => '<p>Describes a tag for an Auto Scaling group.</p>', 'refs' => [ 'TagDescriptionList$member' => NULL, ], ], 'TagDescriptionList' => [ 'base' => NULL, 'refs' => [ 'AutoScalingGroup$Tags' => '<p>The tags for the group.</p>', 'TagsType$Tags' => '<p>One or more tags.</p>', ], ], 'TagKey' => [ 'base' => NULL, 'refs' => [ 'Tag$Key' => '<p>The tag key.</p>', 'TagDescription$Key' => '<p>The tag key.</p>', ], ], 'TagValue' => [ 'base' => NULL, 'refs' => [ 'Tag$Value' => '<p>The tag value.</p>', 'TagDescription$Value' => '<p>The tag value.</p>', ], ], 'Tags' => [ 'base' => NULL, 'refs' => [ 'CreateAutoScalingGroupType$Tags' => '<p>One or more tags. You can tag your Auto Scaling group and propagate the tags to the Amazon EC2 instances it launches. Tags are not propagated to Amazon EBS volumes. To add tags to Amazon EBS volumes, specify the tags in a launch template but use caution. If the launch template specifies an instance tag with a key that is also specified for the Auto Scaling group, Amazon EC2 Auto Scaling overrides the value of that instance tag with the value specified by the Auto Scaling group. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/autoscaling-tagging.html">Tagging Auto Scaling groups and instances</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>', 'CreateOrUpdateTagsType$Tags' => '<p>One or more tags.</p>', 'DeleteTagsType$Tags' => '<p>One or more tags.</p>', ], ], 'TagsType' => [ 'base' => NULL, 'refs' => [], ], 'TargetGroupARNs' => [ 'base' => NULL, 'refs' => [ 'AttachLoadBalancerTargetGroupsType$TargetGroupARNs' => '<p>The Amazon Resource Names (ARN) of the target groups. You can specify up to 10 target groups. To get the ARN of a target group, use the Elastic Load Balancing <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeTargetGroups.html">DescribeTargetGroups</a> API operation.</p>', 'AutoScalingGroup$TargetGroupARNs' => '<p>The Amazon Resource Names (ARN) of the target groups for your load balancer.</p>', 'CreateAutoScalingGroupType$TargetGroupARNs' => '<p>The Amazon Resource Names (ARN) of the target groups to associate with the Auto Scaling group. Instances are registered as targets in a target group, and traffic is routed to the target group. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/autoscaling-load-balancer.html">Elastic Load Balancing and Amazon EC2 Auto Scaling</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>', 'DetachLoadBalancerTargetGroupsType$TargetGroupARNs' => '<p>The Amazon Resource Names (ARN) of the target groups. You can specify up to 10 target groups.</p>', ], ], 'TargetTrackingConfiguration' => [ 'base' => '<p>Represents a target tracking scaling policy configuration to use with Amazon EC2 Auto Scaling.</p>', 'refs' => [ 'PutScalingPolicyType$TargetTrackingConfiguration' => '<p>A target tracking scaling policy. Provides support for predefined or custom metrics.</p> <p>The following predefined metrics are available:</p> <ul> <li> <p> <code>ASGAverageCPUUtilization</code> </p> </li> <li> <p> <code>ASGAverageNetworkIn</code> </p> </li> <li> <p> <code>ASGAverageNetworkOut</code> </p> </li> <li> <p> <code>ALBRequestCountPerTarget</code> </p> </li> </ul> <p>If you specify <code>ALBRequestCountPerTarget</code> for the metric, you must specify the <code>ResourceLabel</code> parameter with the <code>PredefinedMetricSpecification</code>.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_TargetTrackingConfiguration.html">TargetTrackingConfiguration</a> in the <i>Amazon EC2 Auto Scaling API Reference</i>.</p> <p>Required if the policy type is <code>TargetTrackingScaling</code>.</p>', 'ScalingPolicy$TargetTrackingConfiguration' => '<p>A target tracking scaling policy.</p>', ], ], 'TerminateInstanceInAutoScalingGroupType' => [ 'base' => NULL, 'refs' => [], ], 'TerminationPolicies' => [ 'base' => NULL, 'refs' => [ 'AutoScalingGroup$TerminationPolicies' => '<p>The termination policies for the group.</p>', 'CreateAutoScalingGroupType$TerminationPolicies' => '<p>A policy or a list of policies that are used to select the instance to terminate. These policies are executed in the order that you list them. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-instance-termination.html">Controlling which Auto Scaling instances terminate during scale in</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>', 'DescribeTerminationPolicyTypesAnswer$TerminationPolicyTypes' => '<p>The termination policies supported by Amazon EC2 Auto Scaling: <code>OldestInstance</code>, <code>OldestLaunchConfiguration</code>, <code>NewestInstance</code>, <code>ClosestToNextInstanceHour</code>, <code>Default</code>, <code>OldestLaunchTemplate</code>, and <code>AllocationStrategy</code>.</p>', 'UpdateAutoScalingGroupType$TerminationPolicies' => '<p>A policy or a list of policies that are used to select the instances to terminate. The policies are executed in the order that you list them. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-instance-termination.html">Controlling which Auto Scaling instances terminate during scale in</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>', ], ], 'TimestampType' => [ 'base' => NULL, 'refs' => [ 'Activity$StartTime' => '<p>The start time of the activity.</p>', 'Activity$EndTime' => '<p>The end time of the activity.</p>', 'AutoScalingGroup$CreatedTime' => '<p>The date and time the group was created.</p>', 'DescribeScheduledActionsType$StartTime' => '<p>The earliest scheduled start time to return. If scheduled action names are provided, this parameter is ignored.</p>', 'DescribeScheduledActionsType$EndTime' => '<p>The latest scheduled start time to return. If scheduled action names are provided, this parameter is ignored.</p>', 'GetPredictiveScalingForecastAnswer$UpdateTime' => '<p>The time the forecast was made.</p>', 'GetPredictiveScalingForecastType$StartTime' => '<p>The inclusive start time of the time range for the forecast data to get. At most, the date and time can be one year before the current date and time.</p>', 'GetPredictiveScalingForecastType$EndTime' => '<p>The exclusive end time of the time range for the forecast data to get. The maximum time duration between the start and end time is 30 days. </p> <p>Although this parameter can accept a date and time that is more than two days in the future, the availability of forecast data has limits. Amazon EC2 Auto Scaling only issues forecasts for periods of two days in advance.</p>', 'InstanceRefresh$StartTime' => '<p>The date and time at which the instance refresh began.</p>', 'InstanceRefresh$EndTime' => '<p>The date and time at which the instance refresh ended.</p>', 'LaunchConfiguration$CreatedTime' => '<p>The creation date and time for the launch configuration.</p>', 'PredictiveScalingForecastTimestamps$member' => NULL, 'PutScheduledUpdateGroupActionType$Time' => '<p>This parameter is no longer used.</p>', 'PutScheduledUpdateGroupActionType$StartTime' => '<p>The date and time for this action to start, in YYYY-MM-DDThh:mm:ssZ format in UTC/GMT only and in quotes (for example, <code>"2019-06-01T00:00:00Z"</code>).</p> <p>If you specify <code>Recurrence</code> and <code>StartTime</code>, Amazon EC2 Auto Scaling performs the action at this time, and then performs the action based on the specified recurrence.</p> <p>If you try to schedule your action in the past, Amazon EC2 Auto Scaling returns an error message.</p>', 'PutScheduledUpdateGroupActionType$EndTime' => '<p>The date and time for the recurring schedule to end, in UTC.</p>', 'ScheduledUpdateGroupAction$Time' => '<p>This parameter is no longer used.</p>', 'ScheduledUpdateGroupAction$StartTime' => '<p>The date and time in UTC for this action to start. For example, <code>"2019-06-01T00:00:00Z"</code>. </p>', 'ScheduledUpdateGroupAction$EndTime' => '<p>The date and time in UTC for the recurring schedule to end. For example, <code>"2019-06-01T00:00:00Z"</code>. </p>', 'ScheduledUpdateGroupActionRequest$StartTime' => '<p>The date and time for the action to start, in YYYY-MM-DDThh:mm:ssZ format in UTC/GMT only and in quotes (for example, <code>"2019-06-01T00:00:00Z"</code>).</p> <p>If you specify <code>Recurrence</code> and <code>StartTime</code>, Amazon EC2 Auto Scaling performs the action at this time, and then performs the action based on the specified recurrence.</p> <p>If you try to schedule the action in the past, Amazon EC2 Auto Scaling returns an error message.</p>', 'ScheduledUpdateGroupActionRequest$EndTime' => '<p>The date and time for the recurring schedule to end, in UTC.</p>', ], ], 'TotalLocalStorageGBRequest' => [ 'base' => '<p>Specifies the minimum and maximum for the <code>TotalLocalStorageGB</code> object when you specify <a>InstanceRequirements</a> for an Auto Scaling group.</p>', 'refs' => [ 'InstanceRequirements$TotalLocalStorageGB' => '<p>The minimum and maximum total local storage size for an instance type, in GB.</p> <p>Default: No minimum or maximum</p>', ], ], 'UpdateAutoScalingGroupType' => [ 'base' => NULL, 'refs' => [], ], 'VCpuCountRequest' => [ 'base' => '<p>Specifies the minimum and maximum for the <code>VCpuCount</code> object when you specify <a>InstanceRequirements</a> for an Auto Scaling group.</p>', 'refs' => [ 'InstanceRequirements$VCpuCount' => '<p>The minimum and maximum number of vCPUs for an instance type.</p>', ], ], 'Values' => [ 'base' => NULL, 'refs' => [ 'Filter$Values' => '<p>One or more filter values. Filter values are case-sensitive. </p> <p>If you specify multiple values for a filter, the values are automatically logically joined with an <code>OR</code>, and the request returns all results that match any of the specified values. For example, specify "tag:environment" for the filter name and "production,development" for the filter values to find Auto Scaling groups with the tag "environment=production" or "environment=development".</p>', ], ], 'WarmPoolConfiguration' => [ 'base' => '<p>Describes a warm pool configuration. </p>', 'refs' => [ 'AutoScalingGroup$WarmPoolConfiguration' => '<p>The warm pool for the group.</p>', 'DescribeWarmPoolAnswer$WarmPoolConfiguration' => '<p>The warm pool configuration details. </p>', ], ], 'WarmPoolMinSize' => [ 'base' => NULL, 'refs' => [ 'PutWarmPoolType$MinSize' => '<p>Specifies the minimum number of instances to maintain in the warm pool. This helps you to ensure that there is always a certain number of warmed instances available to handle traffic spikes. Defaults to 0 if not specified.</p>', 'WarmPoolConfiguration$MinSize' => '<p>The minimum number of instances to maintain in the warm pool.</p>', ], ], 'WarmPoolSize' => [ 'base' => NULL, 'refs' => [ 'AutoScalingGroup$WarmPoolSize' => '<p>The current size of the warm pool.</p>', ], ], 'WarmPoolState' => [ 'base' => NULL, 'refs' => [ 'PutWarmPoolType$PoolState' => '<p>Sets the instance state to transition to after the lifecycle actions are complete. Default is <code>Stopped</code>.</p>', 'WarmPoolConfiguration$PoolState' => '<p>The instance state to transition to after the lifecycle actions are complete.</p>', ], ], 'WarmPoolStatus' => [ 'base' => NULL, 'refs' => [ 'WarmPoolConfiguration$Status' => '<p>The status of a warm pool that is marked for deletion.</p>', ], ], 'XmlString' => [ 'base' => NULL, 'refs' => [ 'ActivitiesType$NextToken' => '<p>A string that indicates that the response contains more items than can be returned in a single response. To receive additional items, specify this string for the <code>NextToken</code> value when requesting the next set of items. This value is null when there are no more items to return.</p>', 'Activity$ActivityId' => '<p>The ID of the activity.</p>', 'Activity$Description' => '<p>A friendly, more verbose description of the activity.</p>', 'Activity$Details' => '<p>The details about the activity.</p>', 'ActivityIds$member' => NULL, 'AutoScalingGroupNamesType$NextToken' => '<p>The token for the next set of items to return. (You received this token from a previous call.)</p>', 'AutoScalingGroupsType$NextToken' => '<p>A string that indicates that the response contains more items than can be returned in a single response. To receive additional items, specify this string for the <code>NextToken</code> value when requesting the next set of items. This value is null when there are no more items to return.</p>', 'AutoScalingInstancesType$NextToken' => '<p>A string that indicates that the response contains more items than can be returned in a single response. To receive additional items, specify this string for the <code>NextToken</code> value when requesting the next set of items. This value is null when there are no more items to return.</p>', 'DescribeAutoScalingInstancesType$NextToken' => '<p>The token for the next set of items to return. (You received this token from a previous call.)</p>', 'DescribeInstanceRefreshesAnswer$NextToken' => '<p>A string that indicates that the response contains more items than can be returned in a single response. To receive additional items, specify this string for the <code>NextToken</code> value when requesting the next set of items. This value is null when there are no more items to return.</p>', 'DescribeInstanceRefreshesType$NextToken' => '<p>The token for the next set of items to return. (You received this token from a previous call.)</p>', 'DescribeLoadBalancerTargetGroupsRequest$NextToken' => '<p>The token for the next set of items to return. (You received this token from a previous call.)</p>', 'DescribeLoadBalancerTargetGroupsResponse$NextToken' => '<p>A string that indicates that the response contains more items than can be returned in a single response. To receive additional items, specify this string for the <code>NextToken</code> value when requesting the next set of items. This value is null when there are no more items to return.</p>', 'DescribeLoadBalancersRequest$NextToken' => '<p>The token for the next set of items to return. (You received this token from a previous call.)</p>', 'DescribeLoadBalancersResponse$NextToken' => '<p>A string that indicates that the response contains more items than can be returned in a single response. To receive additional items, specify this string for the <code>NextToken</code> value when requesting the next set of items. This value is null when there are no more items to return.</p>', 'DescribeNotificationConfigurationsAnswer$NextToken' => '<p>A string that indicates that the response contains more items than can be returned in a single response. To receive additional items, specify this string for the <code>NextToken</code> value when requesting the next set of items. This value is null when there are no more items to return.</p>', 'DescribeNotificationConfigurationsType$NextToken' => '<p>The token for the next set of items to return. (You received this token from a previous call.)</p>', 'DescribePoliciesType$NextToken' => '<p>The token for the next set of items to return. (You received this token from a previous call.)</p>', 'DescribeScalingActivitiesType$NextToken' => '<p>The token for the next set of items to return. (You received this token from a previous call.)</p>', 'DescribeScheduledActionsType$NextToken' => '<p>The token for the next set of items to return. (You received this token from a previous call.)</p>', 'DescribeTagsType$NextToken' => '<p>The token for the next set of items to return. (You received this token from a previous call.)</p>', 'DescribeWarmPoolAnswer$NextToken' => '<p>The token for the next set of items to return. (You received this token from a previous call.)</p>', 'DescribeWarmPoolType$NextToken' => '<p>The token for the next set of instances to return. (You received this token from a previous call.)</p>', 'FailedScheduledUpdateGroupActionRequest$ErrorMessage' => '<p>The error message accompanying the error code.</p>', 'Filter$Name' => '<p>The name of the filter.</p> <p>The valid values for <code>Name</code> depend on which API operation you\'re using with the filter (<a>DescribeAutoScalingGroups</a> or <a>DescribeTags</a>).</p> <p> <b>DescribeAutoScalingGroups</b> </p> <p>Valid values for <code>Name</code> include the following: </p> <ul> <li> <p> <code>tag-key</code> - Accepts tag keys. The results only include information about the Auto Scaling groups associated with these tag keys. </p> </li> <li> <p> <code>tag-value</code> - Accepts tag values. The results only include information about the Auto Scaling groups associated with these tag values. </p> </li> <li> <p> <code>tag:&lt;key&gt;</code> - Accepts the key/value combination of the tag. Use the tag key in the filter name and the tag value as the filter value. The results only include information about the Auto Scaling groups associated with the specified key/value combination. </p> </li> </ul> <p> <b>DescribeTags</b> </p> <p>Valid values for <code>Name</code> include the following: </p> <ul> <li> <p> <code>auto-scaling-group</code> - Accepts the names of Auto Scaling groups. The results only include information about the tags associated with these Auto Scaling groups. </p> </li> <li> <p> <code>key</code> - Accepts tag keys. The results only include information about the tags associated with these tag keys. </p> </li> <li> <p> <code>value</code> - Accepts tag values. The results only include information about the tags associated with these tag values. </p> </li> <li> <p> <code>propagate-at-launch</code> - Accepts a Boolean value, which specifies whether tags propagate to instances at launch. The results only include information about the tags associated with the specified Boolean value. </p> </li> </ul>', 'InstancesDistribution$OnDemandAllocationStrategy' => '<p>The order of the launch template overrides to use in fulfilling On-Demand capacity. </p> <p>If you specify <code>lowest-price</code>, Amazon EC2 Auto Scaling uses price to determine the order, launching the lowest price first. </p> <p>If you specify <code>prioritized</code>, Amazon EC2 Auto Scaling uses the priority that you assigned to each launch template override, launching the highest priority first. If all your On-Demand capacity cannot be fulfilled using your highest priority instance, then Amazon EC2 Auto Scaling launches the remaining capacity using the second priority instance type, and so on.</p> <p>Default: <code>lowest-price</code> for Auto Scaling groups that specify <a>InstanceRequirements</a> in the overrides and <code>prioritized</code> for Auto Scaling groups that don\'t.</p>', 'InstancesDistribution$SpotAllocationStrategy' => '<p>Indicates how to allocate instances across Spot Instance pools. </p> <p>If the allocation strategy is <code>lowest-price</code>, the Auto Scaling group launches instances using the Spot pools with the lowest price, and evenly allocates your instances across the number of Spot pools that you specify. </p> <p>If the allocation strategy is <code>capacity-optimized</code> (recommended), the Auto Scaling group launches instances using Spot pools that are optimally chosen based on the available Spot capacity. Alternatively, you can use <code>capacity-optimized-prioritized</code> and set the order of instance types in the list of launch template overrides from highest to lowest priority (from first to last in the list). Amazon EC2 Auto Scaling honors the instance type priorities on a best-effort basis but optimizes for capacity first. </p> <p>Default: <code>lowest-price</code> </p>', 'LaunchConfigurationNamesType$NextToken' => '<p>The token for the next set of items to return. (You received this token from a previous call.)</p>', 'LaunchConfigurationsType$NextToken' => '<p>A string that indicates that the response contains more items than can be returned in a single response. To receive additional items, specify this string for the <code>NextToken</code> value when requesting the next set of items. This value is null when there are no more items to return.</p>', 'PoliciesType$NextToken' => '<p>A string that indicates that the response contains more items than can be returned in a single response. To receive additional items, specify this string for the <code>NextToken</code> value when requesting the next set of items. This value is null when there are no more items to return.</p>', 'ScheduledActionsType$NextToken' => '<p>A string that indicates that the response contains more items than can be returned in a single response. To receive additional items, specify this string for the <code>NextToken</code> value when requesting the next set of items. This value is null when there are no more items to return.</p>', 'SecurityGroups$member' => NULL, 'Tag$ResourceId' => '<p>The name of the Auto Scaling group.</p>', 'Tag$ResourceType' => '<p>The type of resource. The only supported value is <code>auto-scaling-group</code>.</p>', 'TagDescription$ResourceId' => '<p>The name of the group.</p>', 'TagDescription$ResourceType' => '<p>The type of resource. The only supported value is <code>auto-scaling-group</code>.</p>', 'TagsType$NextToken' => '<p>A string that indicates that the response contains more items than can be returned in a single response. To receive additional items, specify this string for the <code>NextToken</code> value when requesting the next set of items. This value is null when there are no more items to return.</p>', 'Values$member' => NULL, ], ], 'XmlStringMaxLen1023' => [ 'base' => NULL, 'refs' => [ 'Activity$Cause' => '<p>The reason the activity began.</p>', 'InstanceRefresh$StatusReason' => '<p>Provides more details about the current status of the instance refresh. </p>', 'LifecycleHook$NotificationMetadata' => '<p>Additional information that is included any time Amazon EC2 Auto Scaling sends a message to the notification target.</p>', 'LifecycleHookSpecification$NotificationMetadata' => '<p>Additional information that you want to include any time Amazon EC2 Auto Scaling sends a message to the notification target.</p>', 'MetricDataQuery$Expression' => '<p>The math expression to perform on the returned data, if this object is performing a math expression. This expression can use the <code>Id</code> of the other metrics to refer to those metrics, and can also use the <code>Id</code> of other expressions to use the result of those expressions. </p> <p>Conditional: Within each <code>MetricDataQuery</code> object, you must specify either <code>Expression</code> or <code>MetricStat</code>, but not both.</p>', 'PredefinedMetricSpecification$ResourceLabel' => '<p>A label that uniquely identifies a specific Application Load Balancer target group from which to determine the average request count served by your Auto Scaling group. You can\'t specify a resource label unless the target group is attached to the Auto Scaling group.</p> <p>You create the resource label by appending the final portion of the load balancer ARN and the final portion of the target group ARN into a single value, separated by a forward slash (/). The format of the resource label is:</p> <p> <code>app/my-alb/778d41231b141a0f/targetgroup/my-alb-target-group/943f017f100becff</code>.</p> <p>Where:</p> <ul> <li> <p>app/&lt;load-balancer-name&gt;/&lt;load-balancer-id&gt; is the final portion of the load balancer ARN</p> </li> <li> <p>targetgroup/&lt;target-group-name&gt;/&lt;target-group-id&gt; is the final portion of the target group ARN.</p> </li> </ul> <p>To find the ARN for an Application Load Balancer, use the <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeLoadBalancers.html">DescribeLoadBalancers</a> API operation. To find the ARN for the target group, use the <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeTargetGroups.html">DescribeTargetGroups</a> API operation.</p>', 'PredictiveScalingPredefinedLoadMetric$ResourceLabel' => '<p>A label that uniquely identifies a specific Application Load Balancer target group from which to determine the request count served by your Auto Scaling group. You can\'t specify a resource label unless the target group is attached to the Auto Scaling group.</p> <p>You create the resource label by appending the final portion of the load balancer ARN and the final portion of the target group ARN into a single value, separated by a forward slash (/). The format of the resource label is:</p> <p> <code>app/my-alb/778d41231b141a0f/targetgroup/my-alb-target-group/943f017f100becff</code>.</p> <p>Where:</p> <ul> <li> <p>app/&lt;load-balancer-name&gt;/&lt;load-balancer-id&gt; is the final portion of the load balancer ARN</p> </li> <li> <p>targetgroup/&lt;target-group-name&gt;/&lt;target-group-id&gt; is the final portion of the target group ARN.</p> </li> </ul> <p>To find the ARN for an Application Load Balancer, use the <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeLoadBalancers.html">DescribeLoadBalancers</a> API operation. To find the ARN for the target group, use the <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeTargetGroups.html">DescribeTargetGroups</a> API operation.</p>', 'PredictiveScalingPredefinedMetricPair$ResourceLabel' => '<p>A label that uniquely identifies a specific Application Load Balancer target group from which to determine the total and average request count served by your Auto Scaling group. You can\'t specify a resource label unless the target group is attached to the Auto Scaling group.</p> <p>You create the resource label by appending the final portion of the load balancer ARN and the final portion of the target group ARN into a single value, separated by a forward slash (/). The format of the resource label is:</p> <p> <code>app/my-alb/778d41231b141a0f/targetgroup/my-alb-target-group/943f017f100becff</code>.</p> <p>Where:</p> <ul> <li> <p>app/&lt;load-balancer-name&gt;/&lt;load-balancer-id&gt; is the final portion of the load balancer ARN</p> </li> <li> <p>targetgroup/&lt;target-group-name&gt;/&lt;target-group-id&gt; is the final portion of the target group ARN.</p> </li> </ul> <p>To find the ARN for an Application Load Balancer, use the <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeLoadBalancers.html">DescribeLoadBalancers</a> API operation. To find the ARN for the target group, use the <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeTargetGroups.html">DescribeTargetGroups</a> API operation.</p>', 'PredictiveScalingPredefinedScalingMetric$ResourceLabel' => '<p>A label that uniquely identifies a specific Application Load Balancer target group from which to determine the average request count served by your Auto Scaling group. You can\'t specify a resource label unless the target group is attached to the Auto Scaling group.</p> <p>You create the resource label by appending the final portion of the load balancer ARN and the final portion of the target group ARN into a single value, separated by a forward slash (/). The format of the resource label is:</p> <p> <code>app/my-alb/778d41231b141a0f/targetgroup/my-alb-target-group/943f017f100becff</code>.</p> <p>Where:</p> <ul> <li> <p>app/&lt;load-balancer-name&gt;/&lt;load-balancer-id&gt; is the final portion of the load balancer ARN</p> </li> <li> <p>targetgroup/&lt;target-group-name&gt;/&lt;target-group-id&gt; is the final portion of the target group ARN.</p> </li> </ul> <p>To find the ARN for an Application Load Balancer, use the <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeLoadBalancers.html">DescribeLoadBalancers</a> API operation. To find the ARN for the target group, use the <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeTargetGroups.html">DescribeTargetGroups</a> API operation.</p>', 'PutLifecycleHookType$NotificationMetadata' => '<p>Additional information that you want to include any time Amazon EC2 Auto Scaling sends a message to the notification target.</p>', ], ], 'XmlStringMaxLen1600' => [ 'base' => NULL, 'refs' => [ 'CreateLaunchConfigurationType$IamInstanceProfile' => '<p>The name or the Amazon Resource Name (ARN) of the instance profile associated with the IAM role for the instance. The instance profile contains the IAM role.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/us-iam-role.html">IAM role for applications that run on Amazon EC2 instances</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>', 'LaunchConfiguration$IamInstanceProfile' => '<p>The name or the Amazon Resource Name (ARN) of the instance profile associated with the IAM role for the instance. The instance profile contains the IAM role. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/us-iam-role.html">IAM role for applications that run on Amazon EC2 instances</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>', 'TerminationPolicies$member' => NULL, ], ], 'XmlStringMaxLen19' => [ 'base' => NULL, 'refs' => [ 'AutoScalingInstanceDetails$InstanceId' => '<p>The ID of the instance.</p>', 'CompleteLifecycleActionType$InstanceId' => '<p>The ID of the instance.</p>', 'CreateAutoScalingGroupType$InstanceId' => '<p>The ID of the instance used to base the launch configuration on. If specified, Amazon EC2 Auto Scaling uses the configuration values from the specified instance to create a new launch configuration. To get the instance ID, use the Amazon EC2 <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeInstances.html">DescribeInstances</a> API operation. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/create-asg-from-instance.html">Creating an Auto Scaling group using an EC2 instance</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>', 'CreateLaunchConfigurationType$InstanceId' => '<p>The ID of the instance to use to create the launch configuration. The new launch configuration derives attributes from the instance, except for the block device mapping.</p> <p>To create a launch configuration with a block device mapping or override any other instance attributes, specify them as part of the same request.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/create-lc-with-instanceID.html">Creating a launch configuration using an EC2 instance</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p> <p>If you do not specify <code>InstanceId</code>, you must specify both <code>ImageId</code> and <code>InstanceType</code>.</p>', 'Instance$InstanceId' => '<p>The ID of the instance.</p>', 'InstanceIds$member' => NULL, 'RecordLifecycleActionHeartbeatType$InstanceId' => '<p>The ID of the instance.</p>', 'SetInstanceHealthQuery$InstanceId' => '<p>The ID of the instance.</p>', 'TerminateInstanceInAutoScalingGroupType$InstanceId' => '<p>The ID of the instance.</p>', ], ], 'XmlStringMaxLen2047' => [ 'base' => NULL, 'refs' => [ 'AutoScalingGroup$VPCZoneIdentifier' => '<p>One or more subnet IDs, if applicable, separated by commas.</p>', 'CreateAutoScalingGroupType$VPCZoneIdentifier' => '<p>A comma-separated list of subnet IDs for a virtual private cloud (VPC) where instances in the Auto Scaling group can be created. If you specify <code>VPCZoneIdentifier</code> with <code>AvailabilityZones</code>, the subnets that you specify for this parameter must reside in those Availability Zones.</p> <p>Conditional: If your account supports EC2-Classic and VPC, this parameter is required to launch instances into a VPC.</p>', 'UpdateAutoScalingGroupType$VPCZoneIdentifier' => '<p>A comma-separated list of subnet IDs for a virtual private cloud (VPC). If you specify <code>VPCZoneIdentifier</code> with <code>AvailabilityZones</code>, the subnets that you specify for this parameter must reside in those Availability Zones.</p>', ], ], 'XmlStringMaxLen255' => [ 'base' => NULL, 'refs' => [ 'ActiveInstanceRefreshNotFoundFault$message' => NULL, 'Activity$AutoScalingGroupName' => '<p>The name of the Auto Scaling group.</p>', 'Activity$StatusMessage' => '<p>A friendly, more verbose description of the activity status.</p>', 'AdjustmentType$AdjustmentType' => '<p>The policy adjustment type. The valid values are <code>ChangeInCapacity</code>, <code>ExactCapacity</code>, and <code>PercentChangeInCapacity</code>.</p>', 'Alarm$AlarmName' => '<p>The name of the alarm.</p>', 'AlreadyExistsFault$message' => '<p/>', 'AttachInstancesQuery$AutoScalingGroupName' => '<p>The name of the Auto Scaling group.</p>', 'AttachLoadBalancerTargetGroupsType$AutoScalingGroupName' => '<p>The name of the Auto Scaling group.</p>', 'AttachLoadBalancersType$AutoScalingGroupName' => '<p>The name of the Auto Scaling group.</p>', 'AutoScalingGroup$AutoScalingGroupName' => '<p>The name of the Auto Scaling group.</p>', 'AutoScalingGroup$LaunchConfigurationName' => '<p>The name of the associated launch configuration.</p>', 'AutoScalingGroup$PlacementGroup' => '<p>The name of the placement group into which to launch your instances, if any.</p>', 'AutoScalingGroup$Status' => '<p>The current state of the group when the <a>DeleteAutoScalingGroup</a> operation is in progress.</p>', 'AutoScalingGroup$DesiredCapacityType' => '<p>The unit of measurement for the value specified for desired capacity. Amazon EC2 Auto Scaling supports <code>DesiredCapacityType</code> for attribute-based instance type selection only. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/create-asg-instance-type-requirements.html">Creating an Auto Scaling group using attribute-based instance type selection</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p> <p>By default, Amazon EC2 Auto Scaling specifies <code>units</code>, which translates into number of instances.</p> <p>Valid values: <code>units</code> | <code>vcpu</code> | <code>memory-mib</code> </p>', 'AutoScalingGroupNames$member' => NULL, 'AutoScalingInstanceDetails$InstanceType' => '<p>The instance type of the EC2 instance.</p>', 'AutoScalingInstanceDetails$AutoScalingGroupName' => '<p>The name of the Auto Scaling group for the instance.</p>', 'AutoScalingInstanceDetails$AvailabilityZone' => '<p>The Availability Zone for the instance.</p>', 'AutoScalingInstanceDetails$LaunchConfigurationName' => '<p>The launch configuration used to launch the instance. This value is not available if you attached the instance to the Auto Scaling group.</p>', 'AutoScalingNotificationTypes$member' => NULL, 'AvailabilityZones$member' => NULL, 'BatchDeleteScheduledActionType$AutoScalingGroupName' => '<p>The name of the Auto Scaling group.</p>', 'BatchPutScheduledUpdateGroupActionType$AutoScalingGroupName' => '<p>The name of the Auto Scaling group.</p>', 'BlockDeviceMapping$VirtualName' => '<p>The name of the virtual device (for example, <code>ephemeral0</code>).</p> <p>You can specify either <code>VirtualName</code> or <code>Ebs</code>, but not both.</p>', 'BlockDeviceMapping$DeviceName' => '<p>The device name exposed to the EC2 instance (for example, <code>/dev/sdh</code> or <code>xvdh</code>). For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/device_naming.html">Device Naming on Linux Instances</a> in the <i>Amazon EC2 User Guide for Linux Instances</i>.</p>', 'CancelInstanceRefreshAnswer$InstanceRefreshId' => '<p>The instance refresh ID.</p>', 'CancelInstanceRefreshType$AutoScalingGroupName' => '<p>The name of the Auto Scaling group.</p>', 'ClassicLinkVPCSecurityGroups$member' => NULL, 'CreateAutoScalingGroupType$AutoScalingGroupName' => '<p>The name of the Auto Scaling group. This name must be unique per Region per account.</p>', 'CreateAutoScalingGroupType$LaunchConfigurationName' => '<p>The name of the launch configuration to use to launch instances. </p> <p>Conditional: You must specify either a launch template (<code>LaunchTemplate</code> or <code>MixedInstancesPolicy</code>) or a launch configuration (<code>LaunchConfigurationName</code> or <code>InstanceId</code>).</p>', 'CreateAutoScalingGroupType$PlacementGroup' => '<p>The name of an existing placement group into which to launch your instances, if any. A placement group is a logical grouping of instances within a single Availability Zone. You cannot specify multiple Availability Zones and a placement group. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/placement-groups.html">Placement Groups</a> in the <i>Amazon EC2 User Guide for Linux Instances</i>.</p>', 'CreateAutoScalingGroupType$DesiredCapacityType' => '<p>The unit of measurement for the value specified for desired capacity. Amazon EC2 Auto Scaling supports <code>DesiredCapacityType</code> for attribute-based instance type selection only. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/create-asg-instance-type-requirements.html">Creating an Auto Scaling group using attribute-based instance type selection</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p> <p>By default, Amazon EC2 Auto Scaling specifies <code>units</code>, which translates into number of instances.</p> <p>Valid values: <code>units</code> | <code>vcpu</code> | <code>memory-mib</code> </p>', 'CreateLaunchConfigurationType$LaunchConfigurationName' => '<p>The name of the launch configuration. This name must be unique per Region per account.</p>', 'CreateLaunchConfigurationType$ImageId' => '<p>The ID of the Amazon Machine Image (AMI) that was assigned during registration. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/finding-an-ami.html">Finding an AMI</a> in the <i>Amazon EC2 User Guide for Linux Instances</i>.</p> <p>If you do not specify <code>InstanceId</code>, you must specify <code>ImageId</code>.</p>', 'CreateLaunchConfigurationType$KeyName' => '<p>The name of the key pair. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-key-pairs.html">Amazon EC2 Key Pairs</a> in the <i>Amazon EC2 User Guide for Linux Instances</i>.</p>', 'CreateLaunchConfigurationType$ClassicLinkVPCId' => '<p>The ID of a ClassicLink-enabled VPC to link your EC2-Classic instances to. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/vpc-classiclink.html">ClassicLink</a> in the <i>Amazon EC2 User Guide for Linux Instances</i> and <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-in-vpc.html#as-ClassicLink">Linking EC2-Classic instances to a VPC</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p> <p>This parameter can only be used if you are launching EC2-Classic instances.</p>', 'CreateLaunchConfigurationType$InstanceType' => '<p>Specifies the instance type of the EC2 instance.</p> <p>For information about available instance types, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html#AvailableInstanceTypes">Available Instance Types</a> in the <i>Amazon EC2 User Guide for Linux Instances</i>.</p> <p>If you do not specify <code>InstanceId</code>, you must specify <code>InstanceType</code>.</p>', 'CreateLaunchConfigurationType$KernelId' => '<p>The ID of the kernel associated with the AMI.</p>', 'CreateLaunchConfigurationType$RamdiskId' => '<p>The ID of the RAM disk to select.</p>', 'DeleteAutoScalingGroupType$AutoScalingGroupName' => '<p>The name of the Auto Scaling group.</p>', 'DeleteLifecycleHookType$AutoScalingGroupName' => '<p>The name of the Auto Scaling group.</p>', 'DeleteNotificationConfigurationType$AutoScalingGroupName' => '<p>The name of the Auto Scaling group.</p>', 'DeleteNotificationConfigurationType$TopicARN' => '<p>The Amazon Resource Name (ARN) of the Amazon SNS topic.</p>', 'DeletePolicyType$AutoScalingGroupName' => '<p>The name of the Auto Scaling group.</p>', 'DeleteScheduledActionType$AutoScalingGroupName' => '<p>The name of the Auto Scaling group.</p>', 'DeleteScheduledActionType$ScheduledActionName' => '<p>The name of the action to delete.</p>', 'DeleteWarmPoolType$AutoScalingGroupName' => '<p>The name of the Auto Scaling group.</p>', 'DescribeInstanceRefreshesType$AutoScalingGroupName' => '<p>The name of the Auto Scaling group.</p>', 'DescribeLifecycleHooksType$AutoScalingGroupName' => '<p>The name of the Auto Scaling group.</p>', 'DescribeLoadBalancerTargetGroupsRequest$AutoScalingGroupName' => '<p>The name of the Auto Scaling group.</p>', 'DescribeLoadBalancersRequest$AutoScalingGroupName' => '<p>The name of the Auto Scaling group.</p>', 'DescribePoliciesType$AutoScalingGroupName' => '<p>The name of the Auto Scaling group.</p>', 'DescribeScalingActivitiesType$AutoScalingGroupName' => '<p>The name of the Auto Scaling group.</p>', 'DescribeScheduledActionsType$AutoScalingGroupName' => '<p>The name of the Auto Scaling group.</p>', 'DescribeWarmPoolType$AutoScalingGroupName' => '<p>The name of the Auto Scaling group.</p>', 'DetachInstancesQuery$AutoScalingGroupName' => '<p>The name of the Auto Scaling group.</p>', 'DetachLoadBalancerTargetGroupsType$AutoScalingGroupName' => '<p>The name of the Auto Scaling group.</p>', 'DetachLoadBalancersType$AutoScalingGroupName' => '<p>The name of the Auto Scaling group.</p>', 'DisableMetricsCollectionQuery$AutoScalingGroupName' => '<p>The name of the Auto Scaling group.</p>', 'Ebs$SnapshotId' => '<p>The snapshot ID of the volume to use.</p> <p>You must specify either a <code>VolumeSize</code> or a <code>SnapshotId</code>.</p>', 'EnableMetricsCollectionQuery$AutoScalingGroupName' => '<p>The name of the Auto Scaling group.</p>', 'EnableMetricsCollectionQuery$Granularity' => '<p>The granularity to associate with the metrics to collect. The only valid value is <code>1Minute</code>.</p>', 'EnabledMetric$Metric' => '<p>One of the following metrics:</p> <ul> <li> <p> <code>GroupMinSize</code> </p> </li> <li> <p> <code>GroupMaxSize</code> </p> </li> <li> <p> <code>GroupDesiredCapacity</code> </p> </li> <li> <p> <code>GroupInServiceInstances</code> </p> </li> <li> <p> <code>GroupPendingInstances</code> </p> </li> <li> <p> <code>GroupStandbyInstances</code> </p> </li> <li> <p> <code>GroupTerminatingInstances</code> </p> </li> <li> <p> <code>GroupTotalInstances</code> </p> </li> <li> <p> <code>GroupInServiceCapacity</code> </p> </li> <li> <p> <code>GroupPendingCapacity</code> </p> </li> <li> <p> <code>GroupStandbyCapacity</code> </p> </li> <li> <p> <code>GroupTerminatingCapacity</code> </p> </li> <li> <p> <code>GroupTotalCapacity</code> </p> </li> <li> <p> <code>WarmPoolDesiredCapacity</code> </p> </li> <li> <p> <code>WarmPoolWarmedCapacity</code> </p> </li> <li> <p> <code>WarmPoolPendingCapacity</code> </p> </li> <li> <p> <code>WarmPoolTerminatingCapacity</code> </p> </li> <li> <p> <code>WarmPoolTotalCapacity</code> </p> </li> <li> <p> <code>GroupAndWarmPoolDesiredCapacity</code> </p> </li> <li> <p> <code>GroupAndWarmPoolTotalCapacity</code> </p> </li> </ul>', 'EnabledMetric$Granularity' => '<p>The granularity of the metric. The only valid value is <code>1Minute</code>.</p>', 'EnterStandbyQuery$AutoScalingGroupName' => '<p>The name of the Auto Scaling group.</p>', 'ExecutePolicyType$AutoScalingGroupName' => '<p>The name of the Auto Scaling group.</p>', 'ExitStandbyQuery$AutoScalingGroupName' => '<p>The name of the Auto Scaling group.</p>', 'FailedScheduledUpdateGroupActionRequest$ScheduledActionName' => '<p>The name of the scheduled action.</p>', 'GetPredictiveScalingForecastType$AutoScalingGroupName' => '<p>The name of the Auto Scaling group.</p>', 'GetPredictiveScalingForecastType$PolicyName' => '<p>The name of the policy.</p>', 'Instance$InstanceType' => '<p>The instance type of the EC2 instance.</p>', 'Instance$AvailabilityZone' => '<p>The Availability Zone in which the instance is running.</p>', 'Instance$LaunchConfigurationName' => '<p>The launch configuration associated with the instance.</p>', 'InstanceRefresh$InstanceRefreshId' => '<p>The instance refresh ID.</p>', 'InstanceRefresh$AutoScalingGroupName' => '<p>The name of the Auto Scaling group.</p>', 'InstanceRefreshIds$member' => NULL, 'InstanceRefreshInProgressFault$message' => NULL, 'InvalidNextToken$message' => '<p/>', 'LaunchConfiguration$LaunchConfigurationName' => '<p>The name of the launch configuration.</p>', 'LaunchConfiguration$ImageId' => '<p>The ID of the Amazon Machine Image (AMI) to use to launch your EC2 instances. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/finding-an-ami.html">Finding an AMI</a> in the <i>Amazon EC2 User Guide for Linux Instances</i>.</p>', 'LaunchConfiguration$KeyName' => '<p>The name of the key pair.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-key-pairs.html">Amazon EC2 Key Pairs</a> in the <i>Amazon EC2 User Guide for Linux Instances</i>.</p>', 'LaunchConfiguration$ClassicLinkVPCId' => '<p>The ID of a ClassicLink-enabled VPC to link your EC2-Classic instances to. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/vpc-classiclink.html">ClassicLink</a> in the <i>Amazon EC2 User Guide for Linux Instances</i> and <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-in-vpc.html#as-ClassicLink">Linking EC2-Classic instances to a VPC</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>', 'LaunchConfiguration$InstanceType' => '<p>The instance type for the instances.</p> <p>For information about available instance types, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html#AvailableInstanceTypes">Available Instance Types</a> in the <i>Amazon EC2 User Guide for Linux Instances</i>.</p>', 'LaunchConfiguration$KernelId' => '<p>The ID of the kernel associated with the AMI.</p>', 'LaunchConfiguration$RamdiskId' => '<p>The ID of the RAM disk associated with the AMI.</p>', 'LaunchConfigurationNameType$LaunchConfigurationName' => '<p>The name of the launch configuration.</p>', 'LaunchConfigurationNames$member' => NULL, 'LaunchTemplateOverrides$InstanceType' => '<p>The instance type, such as <code>m3.xlarge</code>. You must use an instance type that is supported in your requested Region and Availability Zones. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Instance types</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>', 'LaunchTemplateSpecification$LaunchTemplateId' => '<p>The ID of the launch template. To get the template ID, use the Amazon EC2 <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeLaunchTemplates.html">DescribeLaunchTemplates</a> API operation. New launch templates can be created using the Amazon EC2 <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateLaunchTemplate.html">CreateLaunchTemplate</a> API. </p> <p>Conditional: You must specify either a <code>LaunchTemplateId</code> or a <code>LaunchTemplateName</code>.</p>', 'LaunchTemplateSpecification$Version' => '<p>The version number, <code>$Latest</code>, or <code>$Default</code>. To get the version number, use the Amazon EC2 <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeLaunchTemplateVersions.html">DescribeLaunchTemplateVersions</a> API operation. New launch template versions can be created using the Amazon EC2 <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateLaunchTemplateVersion.html">CreateLaunchTemplateVersion</a> API. If the value is <code>$Latest</code>, Amazon EC2 Auto Scaling selects the latest version of the launch template when launching instances. If the value is <code>$Default</code>, Amazon EC2 Auto Scaling selects the default version of the launch template when launching instances. The default value is <code>$Default</code>.</p>', 'LifecycleHook$AutoScalingGroupName' => '<p>The name of the Auto Scaling group for the lifecycle hook.</p>', 'LifecycleHook$RoleARN' => '<p>The ARN of the IAM role that allows the Auto Scaling group to publish to the specified notification target (an Amazon SNS topic or an Amazon SQS queue).</p>', 'LifecycleHookSpecification$RoleARN' => '<p>The ARN of the IAM role that allows the Auto Scaling group to publish to the specified notification target.</p> <p>Valid only if the notification target is an Amazon SNS topic or an Amazon SQS queue. Required for new lifecycle hooks, but optional when updating existing hooks.</p>', 'LimitExceededFault$message' => '<p/>', 'LoadBalancerNames$member' => NULL, 'LoadBalancerState$LoadBalancerName' => '<p>The name of the load balancer.</p>', 'LoadBalancerState$State' => '<p>One of the following load balancer states:</p> <ul> <li> <p> <code>Adding</code> - The Auto Scaling instances are being registered with the load balancer.</p> </li> <li> <p> <code>Added</code> - All Auto Scaling instances are registered with the load balancer.</p> </li> <li> <p> <code>InService</code> - At least one Auto Scaling instance passed an <code>ELB</code> health check.</p> </li> <li> <p> <code>Removing</code> - The Auto Scaling instances are being deregistered from the load balancer. If connection draining is enabled, Elastic Load Balancing waits for in-flight requests to complete before deregistering the instances.</p> </li> <li> <p> <code>Removed</code> - All Auto Scaling instances are deregistered from the load balancer.</p> </li> </ul>', 'LoadBalancerTargetGroupState$State' => '<p>The state of the target group.</p> <ul> <li> <p> <code>Adding</code> - The Auto Scaling instances are being registered with the target group.</p> </li> <li> <p> <code>Added</code> - All Auto Scaling instances are registered with the target group.</p> </li> <li> <p> <code>InService</code> - At least one Auto Scaling instance passed an <code>ELB</code> health check.</p> </li> <li> <p> <code>Removing</code> - The Auto Scaling instances are being deregistered from the target group. If connection draining is enabled, Elastic Load Balancing waits for in-flight requests to complete before deregistering the instances.</p> </li> <li> <p> <code>Removed</code> - All Auto Scaling instances are deregistered from the target group.</p> </li> </ul>', 'MetricCollectionType$Metric' => '<p>One of the following metrics:</p> <ul> <li> <p> <code>GroupMinSize</code> </p> </li> <li> <p> <code>GroupMaxSize</code> </p> </li> <li> <p> <code>GroupDesiredCapacity</code> </p> </li> <li> <p> <code>GroupInServiceInstances</code> </p> </li> <li> <p> <code>GroupPendingInstances</code> </p> </li> <li> <p> <code>GroupStandbyInstances</code> </p> </li> <li> <p> <code>GroupTerminatingInstances</code> </p> </li> <li> <p> <code>GroupTotalInstances</code> </p> </li> <li> <p> <code>GroupInServiceCapacity</code> </p> </li> <li> <p> <code>GroupPendingCapacity</code> </p> </li> <li> <p> <code>GroupStandbyCapacity</code> </p> </li> <li> <p> <code>GroupTerminatingCapacity</code> </p> </li> <li> <p> <code>GroupTotalCapacity</code> </p> </li> <li> <p> <code>WarmPoolDesiredCapacity</code> </p> </li> <li> <p> <code>WarmPoolWarmedCapacity</code> </p> </li> <li> <p> <code>WarmPoolPendingCapacity</code> </p> </li> <li> <p> <code>WarmPoolTerminatingCapacity</code> </p> </li> <li> <p> <code>WarmPoolTotalCapacity</code> </p> </li> <li> <p> <code>GroupAndWarmPoolDesiredCapacity</code> </p> </li> <li> <p> <code>GroupAndWarmPoolTotalCapacity</code> </p> </li> </ul>', 'MetricDataQuery$Id' => '<p>A short name that identifies the object\'s results in the response. This name must be unique among all <code>MetricDataQuery</code> objects specified for a single scaling policy. If you are performing math expressions on this set of data, this name represents that data and can serve as a variable in the mathematical expression. The valid characters are letters, numbers, and underscores. The first character must be a lowercase letter. </p>', 'MetricGranularityType$Granularity' => '<p>The granularity. The only valid value is <code>1Minute</code>.</p>', 'Metrics$member' => NULL, 'NotificationConfiguration$AutoScalingGroupName' => '<p>The name of the Auto Scaling group.</p>', 'NotificationConfiguration$TopicARN' => '<p>The Amazon Resource Name (ARN) of the Amazon SNS topic.</p>', 'NotificationConfiguration$NotificationType' => '<p>One of the following event notification types:</p> <ul> <li> <p> <code>autoscaling:EC2_INSTANCE_LAUNCH</code> </p> </li> <li> <p> <code>autoscaling:EC2_INSTANCE_LAUNCH_ERROR</code> </p> </li> <li> <p> <code>autoscaling:EC2_INSTANCE_TERMINATE</code> </p> </li> <li> <p> <code>autoscaling:EC2_INSTANCE_TERMINATE_ERROR</code> </p> </li> <li> <p> <code>autoscaling:TEST_NOTIFICATION</code> </p> </li> </ul>', 'ProcessNames$member' => NULL, 'ProcessType$ProcessName' => '<p>One of the following processes:</p> <ul> <li> <p> <code>Launch</code> </p> </li> <li> <p> <code>Terminate</code> </p> </li> <li> <p> <code>AddToLoadBalancer</code> </p> </li> <li> <p> <code>AlarmNotification</code> </p> </li> <li> <p> <code>AZRebalance</code> </p> </li> <li> <p> <code>HealthCheck</code> </p> </li> <li> <p> <code>InstanceRefresh</code> </p> </li> <li> <p> <code>ReplaceUnhealthy</code> </p> </li> <li> <p> <code>ScheduledActions</code> </p> </li> </ul>', 'PutLifecycleHookType$AutoScalingGroupName' => '<p>The name of the Auto Scaling group.</p>', 'PutLifecycleHookType$RoleARN' => '<p>The ARN of the IAM role that allows the Auto Scaling group to publish to the specified notification target.</p> <p>Valid only if the notification target is an Amazon SNS topic or an Amazon SQS queue. Required for new lifecycle hooks, but optional when updating existing hooks.</p>', 'PutNotificationConfigurationType$AutoScalingGroupName' => '<p>The name of the Auto Scaling group.</p>', 'PutNotificationConfigurationType$TopicARN' => '<p>The Amazon Resource Name (ARN) of the Amazon SNS topic.</p>', 'PutScalingPolicyType$AutoScalingGroupName' => '<p>The name of the Auto Scaling group.</p>', 'PutScalingPolicyType$PolicyName' => '<p>The name of the policy.</p>', 'PutScalingPolicyType$AdjustmentType' => '<p>Specifies how the scaling adjustment is interpreted (for example, an absolute number or a percentage). The valid values are <code>ChangeInCapacity</code>, <code>ExactCapacity</code>, and <code>PercentChangeInCapacity</code>.</p> <p>Required if the policy type is <code>StepScaling</code> or <code>SimpleScaling</code>. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-scaling-simple-step.html#as-scaling-adjustment">Scaling adjustment types</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>', 'PutScheduledUpdateGroupActionType$AutoScalingGroupName' => '<p>The name of the Auto Scaling group.</p>', 'PutScheduledUpdateGroupActionType$ScheduledActionName' => '<p>The name of this scaling action.</p>', 'PutScheduledUpdateGroupActionType$Recurrence' => '<p>The recurring schedule for this action. This format consists of five fields separated by white spaces: [Minute] [Hour] [Day_of_Month] [Month_of_Year] [Day_of_Week]. The value must be in quotes (for example, <code>"30 0 1 1,6,12 *"</code>). For more information about this format, see <a href="http://crontab.org">Crontab</a>.</p> <p>When <code>StartTime</code> and <code>EndTime</code> are specified with <code>Recurrence</code>, they form the boundaries of when the recurring action starts and stops.</p> <p>Cron expressions use Universal Coordinated Time (UTC) by default.</p>', 'PutScheduledUpdateGroupActionType$TimeZone' => '<p>Specifies the time zone for a cron expression. If a time zone is not provided, UTC is used by default. </p> <p>Valid values are the canonical names of the IANA time zones, derived from the IANA Time Zone Database (such as <code>Etc/GMT+9</code> or <code>Pacific/Tahiti</code>). For more information, see <a href="https://en.wikipedia.org/wiki/List_of_tz_database_time_zones">https://en.wikipedia.org/wiki/List_of_tz_database_time_zones</a>.</p>', 'PutWarmPoolType$AutoScalingGroupName' => '<p>The name of the Auto Scaling group.</p>', 'ResourceContentionFault$message' => '<p/>', 'ResourceInUseFault$message' => '<p/>', 'ScalingActivityInProgressFault$message' => '<p/>', 'ScalingPolicy$AutoScalingGroupName' => '<p>The name of the Auto Scaling group.</p>', 'ScalingPolicy$PolicyName' => '<p>The name of the scaling policy.</p>', 'ScalingPolicy$AdjustmentType' => '<p>Specifies how the scaling adjustment is interpreted (for example, an absolute number or a percentage). The valid values are <code>ChangeInCapacity</code>, <code>ExactCapacity</code>, and <code>PercentChangeInCapacity</code>.</p>', 'ScalingProcessQuery$AutoScalingGroupName' => '<p>The name of the Auto Scaling group.</p>', 'ScheduledActionNames$member' => NULL, 'ScheduledUpdateGroupAction$AutoScalingGroupName' => '<p>The name of the Auto Scaling group.</p>', 'ScheduledUpdateGroupAction$ScheduledActionName' => '<p>The name of the scheduled action.</p>', 'ScheduledUpdateGroupAction$Recurrence' => '<p>The recurring schedule for the action, in Unix cron syntax format.</p> <p>When <code>StartTime</code> and <code>EndTime</code> are specified with <code>Recurrence</code>, they form the boundaries of when the recurring action starts and stops.</p>', 'ScheduledUpdateGroupAction$TimeZone' => '<p>The time zone for the cron expression.</p>', 'ScheduledUpdateGroupActionRequest$ScheduledActionName' => '<p>The name of the scaling action.</p>', 'ScheduledUpdateGroupActionRequest$Recurrence' => '<p>The recurring schedule for the action, in Unix cron syntax format. This format consists of five fields separated by white spaces: [Minute] [Hour] [Day_of_Month] [Month_of_Year] [Day_of_Week]. The value must be in quotes (for example, <code>"30 0 1 1,6,12 *"</code>). For more information about this format, see <a href="http://crontab.org">Crontab</a>.</p> <p>When <code>StartTime</code> and <code>EndTime</code> are specified with <code>Recurrence</code>, they form the boundaries of when the recurring action starts and stops.</p> <p>Cron expressions use Universal Coordinated Time (UTC) by default.</p>', 'ScheduledUpdateGroupActionRequest$TimeZone' => '<p>Specifies the time zone for a cron expression. If a time zone is not provided, UTC is used by default. </p> <p>Valid values are the canonical names of the IANA time zones, derived from the IANA Time Zone Database (such as <code>Etc/GMT+9</code> or <code>Pacific/Tahiti</code>). For more information, see <a href="https://en.wikipedia.org/wiki/List_of_tz_database_time_zones">https://en.wikipedia.org/wiki/List_of_tz_database_time_zones</a>.</p>', 'ServiceLinkedRoleFailure$message' => NULL, 'SetDesiredCapacityType$AutoScalingGroupName' => '<p>The name of the Auto Scaling group.</p>', 'SetInstanceProtectionQuery$AutoScalingGroupName' => '<p>The name of the Auto Scaling group.</p>', 'StartInstanceRefreshAnswer$InstanceRefreshId' => '<p>A unique ID for tracking the progress of the request.</p>', 'StartInstanceRefreshType$AutoScalingGroupName' => '<p>The name of the Auto Scaling group.</p>', 'SuspendedProcess$ProcessName' => '<p>The name of the suspended process.</p>', 'SuspendedProcess$SuspensionReason' => '<p>The reason that the process was suspended.</p>', 'UpdateAutoScalingGroupType$AutoScalingGroupName' => '<p>The name of the Auto Scaling group.</p>', 'UpdateAutoScalingGroupType$LaunchConfigurationName' => '<p>The name of the launch configuration. If you specify <code>LaunchConfigurationName</code> in your update request, you can\'t specify <code>LaunchTemplate</code> or <code>MixedInstancesPolicy</code>.</p>', 'UpdateAutoScalingGroupType$PlacementGroup' => '<p>The name of an existing placement group into which to launch your instances, if any. A placement group is a logical grouping of instances within a single Availability Zone. You cannot specify multiple Availability Zones and a placement group. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/placement-groups.html">Placement Groups</a> in the <i>Amazon EC2 User Guide for Linux Instances</i>.</p>', 'UpdateAutoScalingGroupType$DesiredCapacityType' => '<p>The unit of measurement for the value specified for desired capacity. Amazon EC2 Auto Scaling supports <code>DesiredCapacityType</code> for attribute-based instance type selection only. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/create-asg-instance-type-requirements.html">Creating an Auto Scaling group using attribute-based instance type selection</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p> <p>By default, Amazon EC2 Auto Scaling specifies <code>units</code>, which translates into number of instances.</p> <p>Valid values: <code>units</code> | <code>vcpu</code> | <code>memory-mib</code> </p>', ], ], 'XmlStringMaxLen32' => [ 'base' => NULL, 'refs' => [ 'AutoScalingGroup$HealthCheckType' => '<p>The service to use for the health checks. The valid values are <code>EC2</code> and <code>ELB</code>. If you configure an Auto Scaling group to use <code>ELB</code> health checks, it considers the instance unhealthy if it fails either the EC2 status checks or the load balancer health checks.</p>', 'AutoScalingInstanceDetails$LifecycleState' => '<p>The lifecycle state for the instance. The <code>Quarantined</code> state is not used. For information about lifecycle states, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/AutoScalingGroupLifecycle.html">Instance lifecycle</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>. </p> <p>Valid Values: <code>Pending</code> | <code>Pending:Wait</code> | <code>Pending:Proceed</code> | <code>Quarantined</code> | <code>InService</code> | <code>Terminating</code> | <code>Terminating:Wait</code> | <code>Terminating:Proceed</code> | <code>Terminated</code> | <code>Detaching</code> | <code>Detached</code> | <code>EnteringStandby</code> | <code>Standby</code> | <code>Warmed:Pending</code> | <code>Warmed:Pending:Wait</code> | <code>Warmed:Pending:Proceed</code> | <code>Warmed:Terminating</code> | <code>Warmed:Terminating:Wait</code> | <code>Warmed:Terminating:Proceed</code> | <code>Warmed:Terminated</code> | <code>Warmed:Stopped</code> | <code>Warmed:Running</code> </p>', 'AutoScalingInstanceDetails$HealthStatus' => '<p>The last reported health status of this instance. "Healthy" means that the instance is healthy and should remain in service. "Unhealthy" means that the instance is unhealthy and Amazon EC2 Auto Scaling should terminate and replace it.</p>', 'AutoScalingInstanceDetails$WeightedCapacity' => '<p>The number of capacity units contributed by the instance based on its instance type.</p> <p>Valid Range: Minimum value of 1. Maximum value of 999.</p>', 'CreateAutoScalingGroupType$HealthCheckType' => '<p>The service to use for the health checks. The valid values are <code>EC2</code> (default) and <code>ELB</code>. If you configure an Auto Scaling group to use load balancer (ELB) health checks, it considers the instance unhealthy if it fails either the EC2 status checks or the load balancer health checks. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/healthcheck.html">Health checks for Auto Scaling instances</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>', 'Instance$HealthStatus' => '<p>The last reported health status of the instance. "Healthy" means that the instance is healthy and should remain in service. "Unhealthy" means that the instance is unhealthy and that Amazon EC2 Auto Scaling should terminate and replace it.</p>', 'Instance$WeightedCapacity' => '<p>The number of capacity units contributed by the instance based on its instance type.</p> <p>Valid Range: Minimum value of 1. Maximum value of 999.</p>', 'LaunchTemplateOverrides$WeightedCapacity' => '<p>The number of capacity units provided by the instance type specified in <code>InstanceType</code> in terms of virtual CPUs, memory, storage, throughput, or other relative performance characteristic. When a Spot or On-Demand Instance is launched, the capacity units count toward the desired capacity. Amazon EC2 Auto Scaling launches instances until the desired capacity is totally fulfilled, even if this results in an overage. For example, if there are two units remaining to fulfill capacity, and Amazon EC2 Auto Scaling can only launch an instance with a <code>WeightedCapacity</code> of five units, the instance is launched, and the desired capacity is exceeded by three units. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-mixed-instances-groups-instance-weighting.html">Configuring instance weighting for Amazon EC2 Auto Scaling</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>. Value must be in the range of 1–999.</p>', 'PutScalingPolicyType$MetricAggregationType' => '<p>The aggregation type for the CloudWatch metrics. The valid values are <code>Minimum</code>, <code>Maximum</code>, and <code>Average</code>. If the aggregation type is null, the value is treated as <code>Average</code>.</p> <p>Valid only if the policy type is <code>StepScaling</code>.</p>', 'ScalingPolicy$MetricAggregationType' => '<p>The aggregation type for the CloudWatch metrics. The valid values are <code>Minimum</code>, <code>Maximum</code>, and <code>Average</code>.</p>', 'SetInstanceHealthQuery$HealthStatus' => '<p>The health status of the instance. Set to <code>Healthy</code> to have the instance remain in service. Set to <code>Unhealthy</code> to have the instance be out of service. Amazon EC2 Auto Scaling terminates and replaces the unhealthy instance.</p>', 'UpdateAutoScalingGroupType$HealthCheckType' => '<p>The service to use for the health checks. The valid values are <code>EC2</code> and <code>ELB</code>. If you configure an Auto Scaling group to use <code>ELB</code> health checks, it considers the instance unhealthy if it fails either the EC2 status checks or the load balancer health checks.</p>', ], ], 'XmlStringMaxLen511' => [ 'base' => NULL, 'refs' => [ 'LoadBalancerTargetGroupState$LoadBalancerTargetGroupARN' => '<p>The Amazon Resource Name (ARN) of the target group.</p>', 'TargetGroupARNs$member' => NULL, ], ], 'XmlStringMaxLen64' => [ 'base' => NULL, 'refs' => [ 'CreateLaunchConfigurationType$PlacementTenancy' => '<p>The tenancy of the instance. An instance with <code>dedicated</code> tenancy runs on isolated, single-tenant hardware and can only be launched into a VPC.</p> <p>To launch dedicated instances into a shared tenancy VPC (a VPC with the instance placement tenancy attribute set to <code>default</code>), you must set the value of this parameter to <code>dedicated</code>.</p> <p>If you specify <code>PlacementTenancy</code>, you must specify at least one subnet for <code>VPCZoneIdentifier</code> when you create your group.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/auto-scaling-dedicated-instances.html">Configuring instance tenancy with Amazon EC2 Auto Scaling</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p> <p>Valid Values: <code>default</code> | <code>dedicated</code> </p>', 'FailedScheduledUpdateGroupActionRequest$ErrorCode' => '<p>The error code.</p>', 'LaunchConfiguration$PlacementTenancy' => '<p>The tenancy of the instance, either <code>default</code> or <code>dedicated</code>. An instance with <code>dedicated</code> tenancy runs on isolated, single-tenant hardware and can only be launched into a VPC.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/auto-scaling-dedicated-instances.html">Configuring instance tenancy with Amazon EC2 Auto Scaling</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>', 'PolicyTypes$member' => NULL, 'PutScalingPolicyType$PolicyType' => '<p>One of the following policy types: </p> <ul> <li> <p> <code>TargetTrackingScaling</code> </p> </li> <li> <p> <code>StepScaling</code> </p> </li> <li> <p> <code>SimpleScaling</code> (default)</p> </li> <li> <p> <code>PredictiveScaling</code> </p> </li> </ul>', 'ScalingPolicy$PolicyType' => '<p>One of the following policy types: </p> <ul> <li> <p> <code>TargetTrackingScaling</code> </p> </li> <li> <p> <code>StepScaling</code> </p> </li> <li> <p> <code>SimpleScaling</code> (default)</p> </li> <li> <p> <code>PredictiveScaling</code> </p> </li> </ul> <p>For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-scaling-target-tracking.html">Target tracking scaling policies</a> and <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-scaling-simple-step.html">Step and simple scaling policies</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>', ], ], 'XmlStringMetricLabel' => [ 'base' => NULL, 'refs' => [ 'MetricDataQuery$Label' => '<p>A human-readable label for this metric or expression. This is especially useful if this is a math expression, so that you know what the value represents.</p>', ], ], 'XmlStringMetricStat' => [ 'base' => NULL, 'refs' => [ 'MetricStat$Stat' => '<p>The statistic to return. It can include any CloudWatch statistic or extended statistic. For a list of valid values, see the table in <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/cloudwatch_concepts.html#Statistic">Statistics</a> in the <i>Amazon CloudWatch User Guide</i>.</p> <p>The most commonly used metrics for predictive scaling are <code>Average</code> and <code>Sum</code>.</p>', ], ], 'XmlStringUserData' => [ 'base' => NULL, 'refs' => [ 'CreateLaunchConfigurationType$UserData' => '<p>The user data to make available to the launched EC2 instances. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-metadata.html">Instance metadata and user data</a> (Linux) and <a href="https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/ec2-instance-metadata.html">Instance metadata and user data</a> (Windows). If you are using a command line tool, base64-encoding is performed for you, and you can load the text from a file. Otherwise, you must provide base64-encoded text. User data is limited to 16 KB.</p>', 'LaunchConfiguration$UserData' => '<p>The user data to make available to the launched EC2 instances. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-metadata.html">Instance metadata and user data</a> (Linux) and <a href="https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/ec2-instance-metadata.html">Instance metadata and user data</a> (Windows). If you are using a command line tool, base64-encoding is performed for you, and you can load the text from a file. Otherwise, you must provide base64-encoded text. User data is limited to 16 KB.</p>', ], ], ],];
