<?php
// This file was auto-generated from sdk-root/src/data/shield/2016-06-02/docs-2.json
return [ 'version' => '2.0', 'service' => '<fullname>Shield Advanced</fullname> <p>This is the <i>Shield Advanced API Reference</i>. This guide is for developers who need detailed information about the Shield Advanced API actions, data types, and errors. For detailed information about WAF and Shield Advanced features and an overview of how to use the WAF and Shield Advanced APIs, see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/">WAF and Shield Developer Guide</a>.</p>', 'operations' => [ 'AssociateDRTLogBucket' => '<p>Authorizes the Shield Response Team (SRT) to access the specified Amazon S3 bucket containing log data such as Application Load Balancer access logs, CloudFront logs, or logs from third party sources. You can associate up to 10 Amazon S3 buckets with your subscription.</p> <p>To use the services of the SRT and make an <code>AssociateDRTLogBucket</code> request, you must be subscribed to the <a href="https://aws.amazon.com/premiumsupport/business-support/">Business Support plan</a> or the <a href="https://aws.amazon.com/premiumsupport/enterprise-support/">Enterprise Support plan</a>.</p>', 'AssociateDRTRole' => '<p>Authorizes the Shield Response Team (SRT) using the specified role, to access your Amazon Web Services account to assist with DDoS attack mitigation during potential attacks. This enables the SRT to inspect your WAF configuration and create or update WAF rules and web ACLs.</p> <p>You can associate only one <code>RoleArn</code> with your subscription. If you submit an <code>AssociateDRTRole</code> request for an account that already has an associated role, the new <code>RoleArn</code> will replace the existing <code>RoleArn</code>. </p> <p>Prior to making the <code>AssociateDRTRole</code> request, you must attach the <a href="https://console.aws.amazon.com/iam/home?#/policies/arn:aws:iam::aws:policy/service-role/AWSShieldDRTAccessPolicy">AWSShieldDRTAccessPolicy</a> managed policy to the role you will specify in the request. For more information see <a href=" https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_manage-attach-detach.html">Attaching and Detaching IAM Policies</a>. The role must also trust the service principal <code> drt.shield.amazonaws.com</code>. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_principal.html">IAM JSON Policy Elements: Principal</a>.</p> <p>The SRT will have access only to your WAF and Shield resources. By submitting this request, you authorize the SRT to inspect your WAF and Shield configuration and create and update WAF rules and web ACLs on your behalf. The SRT takes these actions only if explicitly authorized by you.</p> <p>You must have the <code>iam:PassRole</code> permission to make an <code>AssociateDRTRole</code> request. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_use_passrole.html">Granting a User Permissions to Pass a Role to an Amazon Web Services Service</a>. </p> <p>To use the services of the SRT and make an <code>AssociateDRTRole</code> request, you must be subscribed to the <a href="https://aws.amazon.com/premiumsupport/business-support/">Business Support plan</a> or the <a href="https://aws.amazon.com/premiumsupport/enterprise-support/">Enterprise Support plan</a>.</p>', 'AssociateHealthCheck' => '<p>Adds health-based detection to the Shield Advanced protection for a resource. Shield Advanced health-based detection uses the health of your Amazon Web Services resource to improve responsiveness and accuracy in attack detection and mitigation. </p> <p>You define the health check in Route 53 and then associate it with your Shield Advanced protection. For more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/ddos-overview.html#ddos-advanced-health-check-option">Shield Advanced Health-Based Detection</a> in the <i>WAF Developer Guide</i>. </p>', 'AssociateProactiveEngagementDetails' => '<p>Initializes proactive engagement and sets the list of contacts for the Shield Response Team (SRT) to use. You must provide at least one phone number in the emergency contact list. </p> <p>After you have initialized proactive engagement using this call, to disable or enable proactive engagement, use the calls <code>DisableProactiveEngagement</code> and <code>EnableProactiveEngagement</code>. </p> <note> <p>This call defines the list of email addresses and phone numbers that the SRT can use to contact you for escalations to the SRT and to initiate proactive customer support.</p> <p>The contacts that you provide in the request replace any contacts that were already defined. If you already have contacts defined and want to use them, retrieve the list using <code>DescribeEmergencyContactSettings</code> and then provide it to this call. </p> </note>', 'CreateProtection' => '<p>Enables Shield Advanced for a specific Amazon Web Services resource. The resource can be an Amazon CloudFront distribution, Elastic Load Balancing load balancer, Global Accelerator accelerator, Elastic IP Address, or an Amazon Route 53 hosted zone.</p> <p>You can add protection to only a single resource with each CreateProtection request. If you want to add protection to multiple resources at once, use the <a href="https://console.aws.amazon.com/waf/">WAF console</a>. For more information see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/getting-started-ddos.html">Getting Started with Shield Advanced</a> and <a href="https://docs.aws.amazon.com/waf/latest/developerguide/configure-new-protection.html">Add Shield Advanced Protection to more Amazon Web Services Resources</a>.</p>', 'CreateProtectionGroup' => '<p>Creates a grouping of protected resources so they can be handled as a collective. This resource grouping improves the accuracy of detection and reduces false positives. </p>', 'CreateSubscription' => '<p>Activates Shield Advanced for an account.</p> <p>When you initally create a subscription, your subscription is set to be automatically renewed at the end of the existing subscription period. You can change this by submitting an <code>UpdateSubscription</code> request. </p>', 'DeleteProtection' => '<p>Deletes an Shield Advanced <a>Protection</a>.</p>', 'DeleteProtectionGroup' => '<p>Removes the specified protection group.</p>', 'DeleteSubscription' => '<p>Removes Shield Advanced from an account. Shield Advanced requires a 1-year subscription commitment. You cannot delete a subscription prior to the completion of that commitment. </p>', 'DescribeAttack' => '<p>Describes the details of a DDoS attack. </p>', 'DescribeAttackStatistics' => '<p>Provides information about the number and type of attacks Shield has detected in the last year for all resources that belong to your account, regardless of whether you\'ve defined Shield protections for them. This operation is available to Shield customers as well as to Shield Advanced customers.</p> <p>The operation returns data for the time range of midnight UTC, one year ago, to midnight UTC, today. For example, if the current time is <code>2020-10-26 15:39:32 PDT</code>, equal to <code>2020-10-26 22:39:32 UTC</code>, then the time range for the attack data returned is from <code>2019-10-26 00:00:00 UTC</code> to <code>2020-10-26 00:00:00 UTC</code>. </p> <p>The time range indicates the period covered by the attack statistics data items.</p>', 'DescribeDRTAccess' => '<p>Returns the current role and list of Amazon S3 log buckets used by the Shield Response Team (SRT) to access your Amazon Web Services account while assisting with attack mitigation.</p>', 'DescribeEmergencyContactSettings' => '<p>A list of email addresses and phone numbers that the Shield Response Team (SRT) can use to contact you if you have proactive engagement enabled, for escalations to the SRT and to initiate proactive customer support.</p>', 'DescribeProtection' => '<p>Lists the details of a <a>Protection</a> object.</p>', 'DescribeProtectionGroup' => '<p>Returns the specification for the specified protection group.</p>', 'DescribeSubscription' => '<p>Provides details about the Shield Advanced subscription for an account.</p>', 'DisableProactiveEngagement' => '<p>Removes authorization from the Shield Response Team (SRT) to notify contacts about escalations to the SRT and to initiate proactive customer support.</p>', 'DisassociateDRTLogBucket' => '<p>Removes the Shield Response Team\'s (SRT) access to the specified Amazon S3 bucket containing the logs that you shared previously.</p> <p>To make a <code>DisassociateDRTLogBucket</code> request, you must be subscribed to the <a href="https://aws.amazon.com/premiumsupport/business-support/">Business Support plan</a> or the <a href="https://aws.amazon.com/premiumsupport/enterprise-support/">Enterprise Support plan</a>. However, if you are not subscribed to one of these support plans, but had been previously and had granted the SRT access to your account, you can submit a <code>DisassociateDRTLogBucket</code> request to remove this access.</p>', 'DisassociateDRTRole' => '<p>Removes the Shield Response Team\'s (SRT) access to your Amazon Web Services account.</p> <p>To make a <code>DisassociateDRTRole</code> request, you must be subscribed to the <a href="https://aws.amazon.com/premiumsupport/business-support/">Business Support plan</a> or the <a href="https://aws.amazon.com/premiumsupport/enterprise-support/">Enterprise Support plan</a>. However, if you are not subscribed to one of these support plans, but had been previously and had granted the SRT access to your account, you can submit a <code>DisassociateDRTRole</code> request to remove this access.</p>', 'DisassociateHealthCheck' => '<p>Removes health-based detection from the Shield Advanced protection for a resource. Shield Advanced health-based detection uses the health of your Amazon Web Services resource to improve responsiveness and accuracy in attack detection and mitigation. </p> <p>You define the health check in Route 53 and then associate or disassociate it with your Shield Advanced protection. For more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/ddos-overview.html#ddos-advanced-health-check-option">Shield Advanced Health-Based Detection</a> in the <i>WAF Developer Guide</i>. </p>', 'EnableProactiveEngagement' => '<p>Authorizes the Shield Response Team (SRT) to use email and phone to notify contacts about escalations to the SRT and to initiate proactive customer support.</p>', 'GetSubscriptionState' => '<p>Returns the <code>SubscriptionState</code>, either <code>Active</code> or <code>Inactive</code>.</p>', 'ListAttacks' => '<p>Returns all ongoing DDoS attacks or all DDoS attacks during a specified time period.</p>', 'ListProtectionGroups' => '<p>Retrieves the <a>ProtectionGroup</a> objects for the account.</p>', 'ListProtections' => '<p>Lists all <a>Protection</a> objects for the account.</p>', 'ListResourcesInProtectionGroup' => '<p>Retrieves the resources that are included in the protection group. </p>', 'ListTagsForResource' => '<p>Gets information about Amazon Web Services tags for a specified Amazon Resource Name (ARN) in Shield.</p>', 'TagResource' => '<p>Adds or updates tags for a resource in Shield.</p>', 'UntagResource' => '<p>Removes tags from a resource in Shield.</p>', 'UpdateEmergencyContactSettings' => '<p>Updates the details of the list of email addresses and phone numbers that the Shield Response Team (SRT) can use to contact you if you have proactive engagement enabled, for escalations to the SRT and to initiate proactive customer support.</p>', 'UpdateProtectionGroup' => '<p>Updates an existing protection group. A protection group is a grouping of protected resources so they can be handled as a collective. This resource grouping improves the accuracy of detection and reduces false positives. </p>', 'UpdateSubscription' => '<p>Updates the details of an existing subscription. Only enter values for parameters you want to change. Empty parameters are not updated.</p>', ], 'shapes' => [ 'AccessDeniedException' => [ 'base' => '<p>Exception that indicates the specified <code>AttackId</code> does not exist, or the requester does not have the appropriate permissions to access the <code>AttackId</code>.</p>', 'refs' => [], ], 'AccessDeniedForDependencyException' => [ 'base' => '<p>In order to grant the necessary access to the Shield Response Team (SRT) the user submitting the request must have the <code>iam:PassRole</code> permission. This error indicates the user did not have the appropriate permissions. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_use_passrole.html">Granting a User Permissions to Pass a Role to an Amazon Web Services Service</a>. </p>', 'refs' => [], ], 'AssociateDRTLogBucketRequest' => [ 'base' => NULL, 'refs' => [], ], 'AssociateDRTLogBucketResponse' => [ 'base' => NULL, 'refs' => [], ], 'AssociateDRTRoleRequest' => [ 'base' => NULL, 'refs' => [], ], 'AssociateDRTRoleResponse' => [ 'base' => NULL, 'refs' => [], ], 'AssociateHealthCheckRequest' => [ 'base' => NULL, 'refs' => [], ], 'AssociateHealthCheckResponse' => [ 'base' => NULL, 'refs' => [], ], 'AssociateProactiveEngagementDetailsRequest' => [ 'base' => NULL, 'refs' => [], ], 'AssociateProactiveEngagementDetailsResponse' => [ 'base' => NULL, 'refs' => [], ], 'AttackDetail' => [ 'base' => '<p>The details of a DDoS attack.</p>', 'refs' => [ 'DescribeAttackResponse$Attack' => '<p>The attack that is described.</p>', ], ], 'AttackId' => [ 'base' => NULL, 'refs' => [ 'AttackDetail$AttackId' => '<p>The unique identifier (ID) of the attack.</p>', 'DescribeAttackRequest$AttackId' => '<p>The unique identifier (ID) for the attack that to be described.</p>', ], ], 'AttackLayer' => [ 'base' => NULL, 'refs' => [ 'AttackProperty$AttackLayer' => '<p>The type of Shield event that was observed. <code>NETWORK</code> indicates layer 3 and layer 4 events and <code>APPLICATION</code> indicates layer 7 events.</p> <p>For infrastructure layer events (L3 and L4 events) after January 25, 2021, you can view metrics for top contributors in Amazon CloudWatch metrics. For more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/monitoring-cloudwatch.html#set-ddos-alarms">Shield metrics and alarms</a> in the <i>WAF Developer Guide</i>. </p>', ], ], 'AttackProperties' => [ 'base' => NULL, 'refs' => [ 'AttackDetail$AttackProperties' => '<p>The array of objects that provide details of the Shield event. </p> <p>For infrastructure layer events (L3 and L4 events) after January 25, 2021, you can view metrics for top contributors in Amazon CloudWatch metrics. For more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/monitoring-cloudwatch.html#set-ddos-alarms">Shield metrics and alarms</a> in the <i>WAF Developer Guide</i>. </p>', ], ], 'AttackProperty' => [ 'base' => '<p>Details of a Shield event. This is provided as part of an <a>AttackDetail</a>.</p>', 'refs' => [ 'AttackProperties$member' => NULL, ], ], 'AttackPropertyIdentifier' => [ 'base' => NULL, 'refs' => [ 'AttackProperty$AttackPropertyIdentifier' => '<p>Defines the Shield event property information that is provided. The <code>WORDPRESS_PINGBACK_REFLECTOR</code> and <code>WORDPRESS_PINGBACK_SOURCE</code> values are valid only for WordPress reflective pingback events.</p>', ], ], 'AttackStatisticsDataItem' => [ 'base' => '<p>A single attack statistics data record. This is returned by <a>DescribeAttackStatistics</a> along with a time range indicating the time period that the attack statistics apply to. </p>', 'refs' => [ 'AttackStatisticsDataList$member' => NULL, ], ], 'AttackStatisticsDataList' => [ 'base' => NULL, 'refs' => [ 'DescribeAttackStatisticsResponse$DataItems' => '<p>The data that describes the attacks detected during the time period.</p>', ], ], 'AttackSummaries' => [ 'base' => NULL, 'refs' => [ 'ListAttacksResponse$AttackSummaries' => '<p>The attack information for the specified time range.</p>', ], ], 'AttackSummary' => [ 'base' => '<p>Summarizes all DDoS attacks for a specified time period.</p>', 'refs' => [ 'AttackSummaries$member' => NULL, ], ], 'AttackTimestamp' => [ 'base' => NULL, 'refs' => [ 'AttackDetail$StartTime' => '<p>The time the attack started, in Unix time in seconds. For more information see <a href="http://docs.aws.amazon.com/cli/latest/userguide/cli-using-param.html#parameter-types">timestamp</a>.</p>', 'AttackDetail$EndTime' => '<p>The time the attack ended, in Unix time in seconds. For more information see <a href="http://docs.aws.amazon.com/cli/latest/userguide/cli-using-param.html#parameter-types">timestamp</a>.</p>', 'AttackSummary$StartTime' => '<p>The start time of the attack, in Unix time in seconds. For more information see <a href="http://docs.aws.amazon.com/cli/latest/userguide/cli-using-param.html#parameter-types">timestamp</a>.</p>', 'AttackSummary$EndTime' => '<p>The end time of the attack, in Unix time in seconds. For more information see <a href="http://docs.aws.amazon.com/cli/latest/userguide/cli-using-param.html#parameter-types">timestamp</a>.</p>', 'TimeRange$FromInclusive' => '<p>The start time, in Unix time in seconds. For more information see <a href="http://docs.aws.amazon.com/cli/latest/userguide/cli-using-param.html#parameter-types">timestamp</a>.</p>', 'TimeRange$ToExclusive' => '<p>The end time, in Unix time in seconds. For more information see <a href="http://docs.aws.amazon.com/cli/latest/userguide/cli-using-param.html#parameter-types">timestamp</a>.</p>', ], ], 'AttackVectorDescription' => [ 'base' => '<p>Describes the attack.</p>', 'refs' => [ 'AttackVectorDescriptionList$member' => NULL, ], ], 'AttackVectorDescriptionList' => [ 'base' => NULL, 'refs' => [ 'AttackSummary$AttackVectors' => '<p>The list of attacks for a specified time period.</p>', ], ], 'AttackVolume' => [ 'base' => '<p>Information about the volume of attacks during the time period, included in an <a>AttackStatisticsDataItem</a>. If the accompanying <code>AttackCount</code> in the statistics object is zero, this setting might be empty.</p>', 'refs' => [ 'AttackStatisticsDataItem$AttackVolume' => '<p>Information about the volume of attacks during the time period. If the accompanying <code>AttackCount</code> is zero, this setting might be empty.</p>', ], ], 'AttackVolumeStatistics' => [ 'base' => '<p>Statistics objects for the various data types in <a>AttackVolume</a>. </p>', 'refs' => [ 'AttackVolume$BitsPerSecond' => '<p>A statistics object that uses bits per second as the unit. This is included for network level attacks. </p>', 'AttackVolume$PacketsPerSecond' => '<p>A statistics object that uses packets per second as the unit. This is included for network level attacks. </p>', 'AttackVolume$RequestsPerSecond' => '<p>A statistics object that uses requests per second as the unit. This is included for application level attacks, and is only available for accounts that are subscribed to Shield Advanced.</p>', ], ], 'AutoRenew' => [ 'base' => NULL, 'refs' => [ 'Subscription$AutoRenew' => '<p>If <code>ENABLED</code>, the subscription will be automatically renewed at the end of the existing subscription period.</p> <p>When you initally create a subscription, <code>AutoRenew</code> is set to <code>ENABLED</code>. You can change this by submitting an <code>UpdateSubscription</code> request. If the <code>UpdateSubscription</code> request does not included a value for <code>AutoRenew</code>, the existing value for <code>AutoRenew</code> remains unchanged.</p>', 'UpdateSubscriptionRequest$AutoRenew' => '<p>When you initally create a subscription, <code>AutoRenew</code> is set to <code>ENABLED</code>. If <code>ENABLED</code>, the subscription will be automatically renewed at the end of the existing subscription period. You can change this by submitting an <code>UpdateSubscription</code> request. If the <code>UpdateSubscription</code> request does not included a value for <code>AutoRenew</code>, the existing value for <code>AutoRenew</code> remains unchanged.</p>', ], ], 'ContactNotes' => [ 'base' => NULL, 'refs' => [ 'EmergencyContact$ContactNotes' => '<p>Additional notes regarding the contact. </p>', ], ], 'Contributor' => [ 'base' => '<p>A contributor to the attack and their contribution.</p>', 'refs' => [ 'TopContributors$member' => NULL, ], ], 'CreateProtectionGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateProtectionGroupResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateProtectionRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateProtectionResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateSubscriptionRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateSubscriptionResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteProtectionGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteProtectionGroupResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteProtectionRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteProtectionResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteSubscriptionRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteSubscriptionResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAttackRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAttackResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAttackStatisticsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAttackStatisticsResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeDRTAccessRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeDRTAccessResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeEmergencyContactSettingsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeEmergencyContactSettingsResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeProtectionGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeProtectionGroupResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeProtectionRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeProtectionResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeSubscriptionRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeSubscriptionResponse' => [ 'base' => NULL, 'refs' => [], ], 'DisableProactiveEngagementRequest' => [ 'base' => NULL, 'refs' => [], ], 'DisableProactiveEngagementResponse' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateDRTLogBucketRequest' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateDRTLogBucketResponse' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateDRTRoleRequest' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateDRTRoleResponse' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateHealthCheckRequest' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateHealthCheckResponse' => [ 'base' => NULL, 'refs' => [], ], 'Double' => [ 'base' => NULL, 'refs' => [ 'AttackVolumeStatistics$Max' => '<p>The maximum attack volume observed for the given unit.</p>', 'SummarizedCounter$Max' => '<p>The maximum value of the counter for a specified time period.</p>', 'SummarizedCounter$Average' => '<p>The average value of the counter for a specified time period.</p>', 'SummarizedCounter$Sum' => '<p>The total of counter values for a specified time period.</p>', ], ], 'DurationInSeconds' => [ 'base' => NULL, 'refs' => [ 'Subscription$TimeCommitmentInSeconds' => '<p>The length, in seconds, of the Shield Advanced subscription for the account.</p>', ], ], 'EmailAddress' => [ 'base' => NULL, 'refs' => [ 'EmergencyContact$EmailAddress' => '<p>The email address for the contact.</p>', ], ], 'EmergencyContact' => [ 'base' => '<p>Contact information that the SRT can use to contact you if you have proactive engagement enabled, for escalations to the SRT and to initiate proactive customer support.</p>', 'refs' => [ 'EmergencyContactList$member' => NULL, ], ], 'EmergencyContactList' => [ 'base' => NULL, 'refs' => [ 'AssociateProactiveEngagementDetailsRequest$EmergencyContactList' => '<p>A list of email addresses and phone numbers that the Shield Response Team (SRT) can use to contact you for escalations to the SRT and to initiate proactive customer support. </p> <p>To enable proactive engagement, the contact list must include at least one phone number.</p> <note> <p>The contacts that you provide here replace any contacts that were already defined. If you already have contacts defined and want to use them, retrieve the list using <code>DescribeEmergencyContactSettings</code> and then provide it here. </p> </note>', 'DescribeEmergencyContactSettingsResponse$EmergencyContactList' => '<p>A list of email addresses and phone numbers that the Shield Response Team (SRT) can use to contact you if you have proactive engagement enabled, for escalations to the SRT and to initiate proactive customer support.</p>', 'UpdateEmergencyContactSettingsRequest$EmergencyContactList' => '<p>A list of email addresses and phone numbers that the Shield Response Team (SRT) can use to contact you if you have proactive engagement enabled, for escalations to the SRT and to initiate proactive customer support.</p> <p>If you have proactive engagement enabled, the contact list must include at least one phone number.</p>', ], ], 'EnableProactiveEngagementRequest' => [ 'base' => NULL, 'refs' => [], ], 'EnableProactiveEngagementResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetSubscriptionStateRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetSubscriptionStateResponse' => [ 'base' => NULL, 'refs' => [], ], 'HealthCheckArn' => [ 'base' => NULL, 'refs' => [ 'AssociateHealthCheckRequest$HealthCheckArn' => '<p>The Amazon Resource Name (ARN) of the health check to associate with the protection.</p>', 'DisassociateHealthCheckRequest$HealthCheckArn' => '<p>The Amazon Resource Name (ARN) of the health check that is associated with the protection.</p>', ], ], 'HealthCheckId' => [ 'base' => NULL, 'refs' => [ 'HealthCheckIds$member' => NULL, ], ], 'HealthCheckIds' => [ 'base' => NULL, 'refs' => [ 'Protection$HealthCheckIds' => '<p>The unique identifier (ID) for the Route 53 health check that\'s associated with the protection. </p>', ], ], 'Integer' => [ 'base' => NULL, 'refs' => [ 'SummarizedCounter$N' => '<p>The number of counters for a specified time period.</p>', ], ], 'InternalErrorException' => [ 'base' => '<p>Exception that indicates that a problem occurred with the service infrastructure. You can retry the request.</p>', 'refs' => [], ], 'InvalidOperationException' => [ 'base' => '<p>Exception that indicates that the operation would not cause any change to occur.</p>', 'refs' => [], ], 'InvalidPaginationTokenException' => [ 'base' => '<p>Exception that indicates that the NextToken specified in the request is invalid. Submit the request using the NextToken value that was returned in the response.</p>', 'refs' => [], ], 'InvalidParameterException' => [ 'base' => '<p>Exception that indicates that the parameters passed to the API are invalid. If available, this exception includes details in additional properties. </p>', 'refs' => [], ], 'InvalidResourceException' => [ 'base' => '<p>Exception that indicates that the resource is invalid. You might not have access to the resource, or the resource might not exist.</p>', 'refs' => [], ], 'Limit' => [ 'base' => '<p>Specifies how many protections of a given type you can create.</p>', 'refs' => [ 'Limits$member' => NULL, ], ], 'LimitNumber' => [ 'base' => NULL, 'refs' => [ 'LimitsExceededException$Limit' => '<p>The threshold that would be exceeded.</p>', ], ], 'LimitType' => [ 'base' => NULL, 'refs' => [ 'LimitsExceededException$Type' => '<p>The type of limit that would be exceeded.</p>', ], ], 'Limits' => [ 'base' => NULL, 'refs' => [ 'ProtectionLimits$ProtectedResourceTypeLimits' => '<p>The maximum number of resource types that you can specify in a protection.</p>', 'Subscription$Limits' => '<p>Specifies how many protections of a given type you can create.</p>', ], ], 'LimitsExceededException' => [ 'base' => '<p>Exception that indicates that the operation would exceed a limit.</p>', 'refs' => [], ], 'ListAttacksRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListAttacksResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListProtectionGroupsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListProtectionGroupsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListProtectionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListProtectionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListResourcesInProtectionGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListResourcesInProtectionGroupResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'LockedSubscriptionException' => [ 'base' => '<p>You are trying to update a subscription that has not yet completed the 1-year commitment. You can change the <code>AutoRenew</code> parameter during the last 30 days of your subscription. This exception indicates that you are attempting to change <code>AutoRenew</code> prior to that period.</p>', 'refs' => [], ], 'LogBucket' => [ 'base' => NULL, 'refs' => [ 'AssociateDRTLogBucketRequest$LogBucket' => '<p>The Amazon S3 bucket that contains the logs that you want to share.</p>', 'DisassociateDRTLogBucketRequest$LogBucket' => '<p>The Amazon S3 bucket that contains the logs that you want to share.</p>', 'LogBucketList$member' => NULL, ], ], 'LogBucketList' => [ 'base' => NULL, 'refs' => [ 'DescribeDRTAccessResponse$LogBucketList' => '<p>The list of Amazon S3 buckets accessed by the SRT.</p>', ], ], 'Long' => [ 'base' => NULL, 'refs' => [ 'AttackProperty$Total' => '<p>The total contributions made to this Shield event by all contributors.</p>', 'AttackStatisticsDataItem$AttackCount' => '<p>The number of attacks detected during the time period. This is always present, but might be zero. </p>', 'Contributor$Value' => '<p>The contribution of this contributor expressed in <a>Protection</a> units. For example <code>10,000</code>.</p>', 'Limit$Max' => '<p>The maximum number of protections that can be created for the specified <code>Type</code>.</p>', 'ProtectionGroupArbitraryPatternLimits$MaxMembers' => '<p>The maximum number of resources you can specify for a single arbitrary pattern in a protection group.</p>', 'ProtectionGroupLimits$MaxProtectionGroups' => '<p>The maximum number of protection groups that you can have at one time. </p>', ], ], 'MaxResults' => [ 'base' => NULL, 'refs' => [ 'ListAttacksRequest$MaxResults' => '<p>The maximum number of <a>AttackSummary</a> objects to return. If you leave this blank, Shield Advanced returns the first 20 results.</p> <p>This is a maximum value. Shield Advanced might return the results in smaller batches. That is, the number of objects returned could be less than <code>MaxResults</code>, even if there are still more objects yet to return. If there are more objects to return, Shield Advanced returns a value in <code>NextToken</code> that you can use in your next request, to get the next batch of objects.</p>', 'ListProtectionGroupsRequest$MaxResults' => '<p>The maximum number of <a>ProtectionGroup</a> objects to return. If you leave this blank, Shield Advanced returns the first 20 results.</p> <p>This is a maximum value. Shield Advanced might return the results in smaller batches. That is, the number of objects returned could be less than <code>MaxResults</code>, even if there are still more objects yet to return. If there are more objects to return, Shield Advanced returns a value in <code>NextToken</code> that you can use in your next request, to get the next batch of objects.</p>', 'ListProtectionsRequest$MaxResults' => '<p>The maximum number of <a>Protection</a> objects to return. If you leave this blank, Shield Advanced returns the first 20 results.</p> <p>This is a maximum value. Shield Advanced might return the results in smaller batches. That is, the number of objects returned could be less than <code>MaxResults</code>, even if there are still more objects yet to return. If there are more objects to return, Shield Advanced returns a value in <code>NextToken</code> that you can use in your next request, to get the next batch of objects.</p>', 'ListResourcesInProtectionGroupRequest$MaxResults' => '<p>The maximum number of resource ARN objects to return. If you leave this blank, Shield Advanced returns the first 20 results.</p> <p>This is a maximum value. Shield Advanced might return the results in smaller batches. That is, the number of objects returned could be less than <code>MaxResults</code>, even if there are still more objects yet to return. If there are more objects to return, Shield Advanced returns a value in <code>NextToken</code> that you can use in your next request, to get the next batch of objects.</p>', ], ], 'Mitigation' => [ 'base' => '<p>The mitigation applied to a DDoS attack.</p>', 'refs' => [ 'MitigationList$member' => NULL, ], ], 'MitigationList' => [ 'base' => NULL, 'refs' => [ 'AttackDetail$Mitigations' => '<p>List of mitigation actions taken for the attack.</p>', ], ], 'NoAssociatedRoleException' => [ 'base' => '<p>The ARN of the role that you specifed does not exist.</p>', 'refs' => [], ], 'OptimisticLockException' => [ 'base' => '<p>Exception that indicates that the resource state has been modified by another client. Retrieve the resource and then retry your request.</p>', 'refs' => [], ], 'PhoneNumber' => [ 'base' => NULL, 'refs' => [ 'EmergencyContact$PhoneNumber' => '<p>The phone number for the contact.</p>', ], ], 'ProactiveEngagementStatus' => [ 'base' => NULL, 'refs' => [ 'Subscription$ProactiveEngagementStatus' => '<p>If <code>ENABLED</code>, the Shield Response Team (SRT) will use email and phone to notify contacts about escalations to the SRT and to initiate proactive customer support.</p> <p>If <code>PENDING</code>, you have requested proactive engagement and the request is pending. The status changes to <code>ENABLED</code> when your request is fully processed.</p> <p>If <code>DISABLED</code>, the SRT will not proactively notify contacts about escalations or to initiate proactive customer support. </p>', ], ], 'ProtectedResourceType' => [ 'base' => NULL, 'refs' => [ 'CreateProtectionGroupRequest$ResourceType' => '<p>The resource type to include in the protection group. All protected resources of this type are included in the protection group. Newly protected resources of this type are automatically added to the group. You must set this when you set <code>Pattern</code> to <code>BY_RESOURCE_TYPE</code> and you must not set it for any other <code>Pattern</code> setting. </p>', 'ProtectionGroup$ResourceType' => '<p>The resource type to include in the protection group. All protected resources of this type are included in the protection group. You must set this when you set <code>Pattern</code> to <code>BY_RESOURCE_TYPE</code> and you must not set it for any other <code>Pattern</code> setting. </p>', 'UpdateProtectionGroupRequest$ResourceType' => '<p>The resource type to include in the protection group. All protected resources of this type are included in the protection group. You must set this when you set <code>Pattern</code> to <code>BY_RESOURCE_TYPE</code> and you must not set it for any other <code>Pattern</code> setting. </p>', ], ], 'Protection' => [ 'base' => '<p>An object that represents a resource that is under DDoS protection.</p>', 'refs' => [ 'DescribeProtectionResponse$Protection' => '<p>The <a>Protection</a> object that is described.</p>', 'Protections$member' => NULL, ], ], 'ProtectionGroup' => [ 'base' => '<p>A grouping of protected resources that you and Shield Advanced can monitor as a collective. This resource grouping improves the accuracy of detection and reduces false positives. </p>', 'refs' => [ 'DescribeProtectionGroupResponse$ProtectionGroup' => '<p>A grouping of protected resources that you and Shield Advanced can monitor as a collective. This resource grouping improves the accuracy of detection and reduces false positives. </p>', 'ProtectionGroups$member' => NULL, ], ], 'ProtectionGroupAggregation' => [ 'base' => NULL, 'refs' => [ 'CreateProtectionGroupRequest$Aggregation' => '<p>Defines how Shield combines resource data for the group in order to detect, mitigate, and report events.</p> <ul> <li> <p>Sum - Use the total traffic across the group. This is a good choice for most cases. Examples include Elastic IP addresses for EC2 instances that scale manually or automatically.</p> </li> <li> <p>Mean - Use the average of the traffic across the group. This is a good choice for resources that share traffic uniformly. Examples include accelerators and load balancers.</p> </li> <li> <p>Max - Use the highest traffic from each resource. This is useful for resources that don\'t share traffic and for resources that share that traffic in a non-uniform way. Examples include Amazon CloudFront and origin resources for CloudFront distributions.</p> </li> </ul>', 'ProtectionGroup$Aggregation' => '<p>Defines how Shield combines resource data for the group in order to detect, mitigate, and report events.</p> <ul> <li> <p>Sum - Use the total traffic across the group. This is a good choice for most cases. Examples include Elastic IP addresses for EC2 instances that scale manually or automatically.</p> </li> <li> <p>Mean - Use the average of the traffic across the group. This is a good choice for resources that share traffic uniformly. Examples include accelerators and load balancers.</p> </li> <li> <p>Max - Use the highest traffic from each resource. This is useful for resources that don\'t share traffic and for resources that share that traffic in a non-uniform way. Examples include Amazon CloudFront distributions and origin resources for CloudFront distributions.</p> </li> </ul>', 'UpdateProtectionGroupRequest$Aggregation' => '<p>Defines how Shield combines resource data for the group in order to detect, mitigate, and report events.</p> <ul> <li> <p>Sum - Use the total traffic across the group. This is a good choice for most cases. Examples include Elastic IP addresses for EC2 instances that scale manually or automatically.</p> </li> <li> <p>Mean - Use the average of the traffic across the group. This is a good choice for resources that share traffic uniformly. Examples include accelerators and load balancers.</p> </li> <li> <p>Max - Use the highest traffic from each resource. This is useful for resources that don\'t share traffic and for resources that share that traffic in a non-uniform way. Examples include Amazon CloudFront distributions and origin resources for CloudFront distributions.</p> </li> </ul>', ], ], 'ProtectionGroupArbitraryPatternLimits' => [ 'base' => '<p>Limits settings on protection groups with arbitrary pattern type. </p>', 'refs' => [ 'ProtectionGroupPatternTypeLimits$ArbitraryPatternLimits' => '<p>Limits settings on protection groups with arbitrary pattern type. </p>', ], ], 'ProtectionGroupId' => [ 'base' => NULL, 'refs' => [ 'CreateProtectionGroupRequest$ProtectionGroupId' => '<p>The name of the protection group. You use this to identify the protection group in lists and to manage the protection group, for example to update, delete, or describe it. </p>', 'DeleteProtectionGroupRequest$ProtectionGroupId' => '<p>The name of the protection group. You use this to identify the protection group in lists and to manage the protection group, for example to update, delete, or describe it. </p>', 'DescribeProtectionGroupRequest$ProtectionGroupId' => '<p>The name of the protection group. You use this to identify the protection group in lists and to manage the protection group, for example to update, delete, or describe it. </p>', 'ListResourcesInProtectionGroupRequest$ProtectionGroupId' => '<p>The name of the protection group. You use this to identify the protection group in lists and to manage the protection group, for example to update, delete, or describe it. </p>', 'ProtectionGroup$ProtectionGroupId' => '<p>The name of the protection group. You use this to identify the protection group in lists and to manage the protection group, for example to update, delete, or describe it. </p>', 'UpdateProtectionGroupRequest$ProtectionGroupId' => '<p>The name of the protection group. You use this to identify the protection group in lists and to manage the protection group, for example to update, delete, or describe it. </p>', ], ], 'ProtectionGroupLimits' => [ 'base' => '<p>Limits settings on protection groups for your subscription. </p>', 'refs' => [ 'SubscriptionLimits$ProtectionGroupLimits' => '<p>Limits settings on protection groups for your subscription. </p>', ], ], 'ProtectionGroupMembers' => [ 'base' => NULL, 'refs' => [ 'CreateProtectionGroupRequest$Members' => '<p>The Amazon Resource Names (ARNs) of the resources to include in the protection group. You must set this when you set <code>Pattern</code> to <code>ARBITRARY</code> and you must not set it for any other <code>Pattern</code> setting. </p>', 'ProtectionGroup$Members' => '<p>The Amazon Resource Names (ARNs) of the resources to include in the protection group. You must set this when you set <code>Pattern</code> to <code>ARBITRARY</code> and you must not set it for any other <code>Pattern</code> setting. </p>', 'UpdateProtectionGroupRequest$Members' => '<p>The Amazon Resource Names (ARNs) of the resources to include in the protection group. You must set this when you set <code>Pattern</code> to <code>ARBITRARY</code> and you must not set it for any other <code>Pattern</code> setting. </p>', ], ], 'ProtectionGroupPattern' => [ 'base' => NULL, 'refs' => [ 'CreateProtectionGroupRequest$Pattern' => '<p>The criteria to use to choose the protected resources for inclusion in the group. You can include all resources that have protections, provide a list of resource Amazon Resource Names (ARNs), or include all resources of a specified resource type. </p>', 'ProtectionGroup$Pattern' => '<p>The criteria to use to choose the protected resources for inclusion in the group. You can include all resources that have protections, provide a list of resource Amazon Resource Names (ARNs), or include all resources of a specified resource type.</p>', 'UpdateProtectionGroupRequest$Pattern' => '<p>The criteria to use to choose the protected resources for inclusion in the group. You can include all resources that have protections, provide a list of resource Amazon Resource Names (ARNs), or include all resources of a specified resource type.</p>', ], ], 'ProtectionGroupPatternTypeLimits' => [ 'base' => '<p>Limits settings by pattern type in the protection groups for your subscription. </p>', 'refs' => [ 'ProtectionGroupLimits$PatternTypeLimits' => '<p>Limits settings by pattern type in the protection groups for your subscription. </p>', ], ], 'ProtectionGroups' => [ 'base' => NULL, 'refs' => [ 'ListProtectionGroupsResponse$ProtectionGroups' => '<p/>', ], ], 'ProtectionId' => [ 'base' => NULL, 'refs' => [ 'AssociateHealthCheckRequest$ProtectionId' => '<p>The unique identifier (ID) for the <a>Protection</a> object to add the health check association to. </p>', 'CreateProtectionResponse$ProtectionId' => '<p>The unique identifier (ID) for the <a>Protection</a> object that is created.</p>', 'DeleteProtectionRequest$ProtectionId' => '<p>The unique identifier (ID) for the <a>Protection</a> object to be deleted.</p>', 'DescribeProtectionRequest$ProtectionId' => '<p>The unique identifier (ID) for the <a>Protection</a> object that is described. When submitting the <code>DescribeProtection</code> request you must provide either the <code>ResourceArn</code> or the <code>ProtectionID</code>, but not both.</p>', 'DisassociateHealthCheckRequest$ProtectionId' => '<p>The unique identifier (ID) for the <a>Protection</a> object to remove the health check association from. </p>', 'Protection$Id' => '<p>The unique identifier (ID) of the protection.</p>', ], ], 'ProtectionLimits' => [ 'base' => '<p>Limits settings on protections for your subscription. </p>', 'refs' => [ 'SubscriptionLimits$ProtectionLimits' => '<p>Limits settings on protections for your subscription. </p>', ], ], 'ProtectionName' => [ 'base' => NULL, 'refs' => [ 'CreateProtectionRequest$Name' => '<p>Friendly name for the <code>Protection</code> you are creating.</p>', 'Protection$Name' => '<p>The name of the protection. For example, <code>My CloudFront distributions</code>.</p>', ], ], 'Protections' => [ 'base' => NULL, 'refs' => [ 'ListProtectionsResponse$Protections' => '<p>The array of enabled <a>Protection</a> objects.</p>', ], ], 'ResourceAlreadyExistsException' => [ 'base' => '<p>Exception indicating the specified resource already exists. If available, this exception includes details in additional properties. </p>', 'refs' => [], ], 'ResourceArn' => [ 'base' => NULL, 'refs' => [ 'AttackDetail$ResourceArn' => '<p>The ARN (Amazon Resource Name) of the resource that was attacked.</p>', 'CreateProtectionRequest$ResourceArn' => '<p>The ARN (Amazon Resource Name) of the resource to be protected.</p> <p>The ARN should be in one of the following formats:</p> <ul> <li> <p>For an Application Load Balancer: <code>arn:aws:elasticloadbalancing:<i>region</i>:<i>account-id</i>:loadbalancer/app/<i>load-balancer-name</i>/<i>load-balancer-id</i> </code> </p> </li> <li> <p>For an Elastic Load Balancer (Classic Load Balancer): <code>arn:aws:elasticloadbalancing:<i>region</i>:<i>account-id</i>:loadbalancer/<i>load-balancer-name</i> </code> </p> </li> <li> <p>For an Amazon CloudFront distribution: <code>arn:aws:cloudfront::<i>account-id</i>:distribution/<i>distribution-id</i> </code> </p> </li> <li> <p>For an Global Accelerator accelerator: <code>arn:aws:globalaccelerator::<i>account-id</i>:accelerator/<i>accelerator-id</i> </code> </p> </li> <li> <p>For Amazon Route 53: <code>arn:aws:route53:::hostedzone/<i>hosted-zone-id</i> </code> </p> </li> <li> <p>For an Elastic IP address: <code>arn:aws:ec2:<i>region</i>:<i>account-id</i>:eip-allocation/<i>allocation-id</i> </code> </p> </li> </ul>', 'DescribeProtectionRequest$ResourceArn' => '<p>The ARN (Amazon Resource Name) of the Amazon Web Services resource for the <a>Protection</a> object that is described. When submitting the <code>DescribeProtection</code> request you must provide either the <code>ResourceArn</code> or the <code>ProtectionID</code>, but not both.</p>', 'ListTagsForResourceRequest$ResourceARN' => '<p>The Amazon Resource Name (ARN) of the resource to get tags for.</p>', 'Protection$ResourceArn' => '<p>The ARN (Amazon Resource Name) of the Amazon Web Services resource that is protected.</p>', 'Protection$ProtectionArn' => '<p>The ARN (Amazon Resource Name) of the protection.</p>', 'ProtectionGroup$ProtectionGroupArn' => '<p>The ARN (Amazon Resource Name) of the protection group.</p>', 'ProtectionGroupMembers$member' => NULL, 'ResourceArnFilterList$member' => NULL, 'ResourceArnList$member' => NULL, 'Subscription$SubscriptionArn' => '<p>The ARN (Amazon Resource Name) of the subscription.</p>', 'TagResourceRequest$ResourceARN' => '<p>The Amazon Resource Name (ARN) of the resource that you want to add or update tags for.</p>', 'UntagResourceRequest$ResourceARN' => '<p>The Amazon Resource Name (ARN) of the resource that you want to remove tags from.</p>', ], ], 'ResourceArnFilterList' => [ 'base' => NULL, 'refs' => [ 'ListAttacksRequest$ResourceArns' => '<p>The ARN (Amazon Resource Name) of the resource that was attacked. If this is left blank, all applicable resources for this account will be included.</p>', ], ], 'ResourceArnList' => [ 'base' => NULL, 'refs' => [ 'ListResourcesInProtectionGroupResponse$ResourceArns' => '<p>The Amazon Resource Names (ARNs) of the resources that are included in the protection group.</p>', ], ], 'ResourceNotFoundException' => [ 'base' => '<p>Exception indicating the specified resource does not exist. If available, this exception includes details in additional properties. </p>', 'refs' => [], ], 'RoleArn' => [ 'base' => NULL, 'refs' => [ 'AssociateDRTRoleRequest$RoleArn' => '<p>The Amazon Resource Name (ARN) of the role the SRT will use to access your Amazon Web Services account.</p> <p>Prior to making the <code>AssociateDRTRole</code> request, you must attach the <a href="https://console.aws.amazon.com/iam/home?#/policies/arn:aws:iam::aws:policy/service-role/AWSShieldDRTAccessPolicy">AWSShieldDRTAccessPolicy</a> managed policy to this role. For more information see <a href=" https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_manage-attach-detach.html">Attaching and Detaching IAM Policies</a>.</p>', 'DescribeDRTAccessResponse$RoleArn' => '<p>The Amazon Resource Name (ARN) of the role the SRT used to access your Amazon Web Services account.</p>', ], ], 'String' => [ 'base' => NULL, 'refs' => [ 'AttackSummary$AttackId' => '<p>The unique identifier (ID) of the attack.</p>', 'AttackSummary$ResourceArn' => '<p>The ARN (Amazon Resource Name) of the resource that was attacked.</p>', 'AttackVectorDescription$VectorType' => '<p>The attack type. Valid values:</p> <ul> <li> <p>UDP_TRAFFIC</p> </li> <li> <p>UDP_FRAGMENT</p> </li> <li> <p>GENERIC_UDP_REFLECTION</p> </li> <li> <p>DNS_REFLECTION</p> </li> <li> <p>NTP_REFLECTION</p> </li> <li> <p>CHARGEN_REFLECTION</p> </li> <li> <p>SSDP_REFLECTION</p> </li> <li> <p>PORT_MAPPER</p> </li> <li> <p>RIP_REFLECTION</p> </li> <li> <p>SNMP_REFLECTION</p> </li> <li> <p>MSSQL_REFLECTION</p> </li> <li> <p>NET_BIOS_REFLECTION</p> </li> <li> <p>SYN_FLOOD</p> </li> <li> <p>ACK_FLOOD</p> </li> <li> <p>REQUEST_FLOOD</p> </li> <li> <p>HTTP_REFLECTION</p> </li> <li> <p>UDS_REFLECTION</p> </li> <li> <p>MEMCACHED_REFLECTION</p> </li> </ul>', 'Contributor$Name' => '<p>The name of the contributor. This is dependent on the <code>AttackPropertyIdentifier</code>. For example, if the <code>AttackPropertyIdentifier</code> is <code>SOURCE_COUNTRY</code>, the <code>Name</code> could be <code>United States</code>.</p>', 'Limit$Type' => '<p>The type of protection.</p>', 'Mitigation$MitigationName' => '<p>The name of the mitigation taken for this attack.</p>', 'ResourceAlreadyExistsException$resourceType' => '<p>The type of resource that already exists.</p>', 'ResourceNotFoundException$resourceType' => '<p>Type of resource.</p>', 'SubResourceSummary$Id' => '<p>The unique identifier (ID) of the <code>SubResource</code>.</p>', 'SummarizedAttackVector$VectorType' => '<p>The attack type, for example, SNMP reflection or SYN flood.</p>', 'SummarizedCounter$Name' => '<p>The counter name.</p>', 'SummarizedCounter$Unit' => '<p>The unit of the counters.</p>', 'ValidationExceptionField$name' => '<p>The name of the parameter that failed validation.</p>', 'ValidationExceptionField$message' => '<p>The message describing why the parameter failed validation.</p>', ], ], 'SubResourceSummary' => [ 'base' => '<p>The attack information for the specified SubResource.</p>', 'refs' => [ 'SubResourceSummaryList$member' => NULL, ], ], 'SubResourceSummaryList' => [ 'base' => NULL, 'refs' => [ 'AttackDetail$SubResources' => '<p>If applicable, additional detail about the resource being attacked, for example, IP address or URL.</p>', ], ], 'SubResourceType' => [ 'base' => NULL, 'refs' => [ 'SubResourceSummary$Type' => '<p>The <code>SubResource</code> type.</p>', ], ], 'Subscription' => [ 'base' => '<p>Information about the Shield Advanced subscription for an account.</p>', 'refs' => [ 'DescribeSubscriptionResponse$Subscription' => '<p>The Shield Advanced subscription details for an account.</p>', ], ], 'SubscriptionLimits' => [ 'base' => '<p>Limits settings for your subscription. </p>', 'refs' => [ 'Subscription$SubscriptionLimits' => '<p>Limits settings for your subscription. </p>', ], ], 'SubscriptionState' => [ 'base' => NULL, 'refs' => [ 'GetSubscriptionStateResponse$SubscriptionState' => '<p>The status of the subscription.</p>', ], ], 'SummarizedAttackVector' => [ 'base' => '<p>A summary of information about the attack.</p>', 'refs' => [ 'SummarizedAttackVectorList$member' => NULL, ], ], 'SummarizedAttackVectorList' => [ 'base' => NULL, 'refs' => [ 'SubResourceSummary$AttackVectors' => '<p>The list of attack types and associated counters.</p>', ], ], 'SummarizedCounter' => [ 'base' => '<p>The counter that describes a DDoS attack.</p>', 'refs' => [ 'SummarizedCounterList$member' => NULL, ], ], 'SummarizedCounterList' => [ 'base' => NULL, 'refs' => [ 'AttackDetail$AttackCounters' => '<p>List of counters that describe the attack for the specified time period.</p>', 'SubResourceSummary$Counters' => '<p>The counters that describe the details of the attack.</p>', 'SummarizedAttackVector$VectorCounters' => '<p>The list of counters that describe the details of the attack.</p>', ], ], 'Tag' => [ 'base' => '<p>A tag associated with an Amazon Web Services resource. Tags are key:value pairs that you can use to categorize and manage your resources, for purposes like billing or other management. Typically, the tag key represents a category, such as "environment", and the tag value represents a specific value within that category, such as "test," "development," or "production". Or you might set the tag key to "customer" and the value to the customer name or ID. You can specify one or more tags to add to each Amazon Web Services resource, up to 50 tags for a resource.</p>', 'refs' => [ 'TagList$member' => NULL, ], ], 'TagKey' => [ 'base' => NULL, 'refs' => [ 'Tag$Key' => '<p>Part of the key:value pair that defines a tag. You can use a tag key to describe a category of information, such as "customer." Tag keys are case-sensitive.</p>', 'TagKeyList$member' => NULL, ], ], 'TagKeyList' => [ 'base' => NULL, 'refs' => [ 'UntagResourceRequest$TagKeys' => '<p>The tag key for each tag that you want to remove from the resource.</p>', ], ], 'TagList' => [ 'base' => NULL, 'refs' => [ 'CreateProtectionGroupRequest$Tags' => '<p>One or more tag key-value pairs for the protection group.</p>', 'CreateProtectionRequest$Tags' => '<p>One or more tag key-value pairs for the <a>Protection</a> object that is created.</p>', 'ListTagsForResourceResponse$Tags' => '<p>A list of tag key and value pairs associated with the specified resource.</p>', 'TagResourceRequest$Tags' => '<p>The tags that you want to modify or add to the resource.</p>', ], ], 'TagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'TagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'TagValue' => [ 'base' => NULL, 'refs' => [ 'Tag$Value' => '<p>Part of the key:value pair that defines a tag. You can use a tag value to describe a specific value within a category, such as "companyA" or "companyB." Tag values are case-sensitive.</p>', ], ], 'TimeRange' => [ 'base' => '<p>The time range. </p>', 'refs' => [ 'DescribeAttackStatisticsResponse$TimeRange' => NULL, 'ListAttacksRequest$StartTime' => '<p>The start of the time period for the attacks. This is a <code>timestamp</code> type. The sample request above indicates a <code>number</code> type because the default used by WAF is Unix time in seconds. However any valid <a href="http://docs.aws.amazon.com/cli/latest/userguide/cli-using-param.html#parameter-types">timestamp format</a> is allowed. </p>', 'ListAttacksRequest$EndTime' => '<p>The end of the time period for the attacks. This is a <code>timestamp</code> type. The sample request above indicates a <code>number</code> type because the default used by WAF is Unix time in seconds. However any valid <a href="http://docs.aws.amazon.com/cli/latest/userguide/cli-using-param.html#parameter-types">timestamp format</a> is allowed. </p>', ], ], 'Timestamp' => [ 'base' => NULL, 'refs' => [ 'Subscription$StartTime' => '<p>The start time of the subscription, in Unix time in seconds. For more information see <a href="http://docs.aws.amazon.com/cli/latest/userguide/cli-using-param.html#parameter-types">timestamp</a>.</p>', 'Subscription$EndTime' => '<p>The date and time your subscription will end.</p>', ], ], 'Token' => [ 'base' => NULL, 'refs' => [ 'ListAttacksRequest$NextToken' => '<p>The <code>ListAttacksRequest.NextMarker</code> value from a previous call to <code>ListAttacksRequest</code>. Pass null if this is the first call.</p>', 'ListAttacksResponse$NextToken' => '<p>The token returned by a previous call to indicate that there is more data available. If not null, more results are available. Pass this value for the <code>NextMarker</code> parameter in a subsequent call to <code>ListAttacks</code> to retrieve the next set of items.</p> <p>Shield Advanced might return the list of <a>AttackSummary</a> objects in batches smaller than the number specified by MaxResults. If there are more attack summary objects to return, Shield Advanced will always also return a <code>NextToken</code>.</p>', 'ListProtectionGroupsRequest$NextToken' => '<p>The next token value from a previous call to <code>ListProtectionGroups</code>. Pass null if this is the first call.</p>', 'ListProtectionGroupsResponse$NextToken' => '<p>If you specify a value for <code>MaxResults</code> and you have more protection groups than the value of MaxResults, Shield Advanced returns this token that you can use in your next request, to get the next batch of objects. </p>', 'ListProtectionsRequest$NextToken' => '<p>The <code>ListProtectionsRequest.NextToken</code> value from a previous call to <code>ListProtections</code>. Pass null if this is the first call.</p>', 'ListProtectionsResponse$NextToken' => '<p>If you specify a value for <code>MaxResults</code> and you have more Protections than the value of MaxResults, Shield Advanced returns a NextToken value in the response that allows you to list another group of Protections. For the second and subsequent ListProtections requests, specify the value of NextToken from the previous response to get information about another batch of Protections.</p> <p>Shield Advanced might return the list of <a>Protection</a> objects in batches smaller than the number specified by MaxResults. If there are more <a>Protection</a> objects to return, Shield Advanced will always also return a <code>NextToken</code>.</p>', 'ListResourcesInProtectionGroupRequest$NextToken' => '<p>The next token value from a previous call to <code>ListResourcesInProtectionGroup</code>. Pass null if this is the first call.</p>', 'ListResourcesInProtectionGroupResponse$NextToken' => '<p>If you specify a value for <code>MaxResults</code> and you have more resources in the protection group than the value of MaxResults, Shield Advanced returns this token that you can use in your next request, to get the next batch of objects. </p>', ], ], 'TopContributors' => [ 'base' => NULL, 'refs' => [ 'AttackProperty$TopContributors' => '<p>Contributor objects for the top five contributors to a Shield event. </p>', ], ], 'Unit' => [ 'base' => NULL, 'refs' => [ 'AttackProperty$Unit' => '<p>The unit used for the <code>Contributor</code> <code>Value</code> property. </p>', ], ], 'UntagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'UntagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateEmergencyContactSettingsRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateEmergencyContactSettingsResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateProtectionGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateProtectionGroupResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateSubscriptionRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateSubscriptionResponse' => [ 'base' => NULL, 'refs' => [], ], 'ValidationExceptionField' => [ 'base' => '<p>Provides information about a particular parameter passed inside a request that resulted in an exception.</p>', 'refs' => [ 'ValidationExceptionFieldList$member' => NULL, ], ], 'ValidationExceptionFieldList' => [ 'base' => NULL, 'refs' => [ 'InvalidParameterException$fields' => '<p>Fields that caused the exception.</p>', ], ], 'ValidationExceptionReason' => [ 'base' => NULL, 'refs' => [ 'InvalidParameterException$reason' => '<p>Additional information about the exception.</p>', ], ], 'errorMessage' => [ 'base' => NULL, 'refs' => [ 'AccessDeniedException$message' => NULL, 'AccessDeniedForDependencyException$message' => NULL, 'InternalErrorException$message' => NULL, 'InvalidOperationException$message' => NULL, 'InvalidPaginationTokenException$message' => NULL, 'InvalidParameterException$message' => NULL, 'InvalidResourceException$message' => NULL, 'LimitsExceededException$message' => NULL, 'LockedSubscriptionException$message' => NULL, 'NoAssociatedRoleException$message' => NULL, 'OptimisticLockException$message' => NULL, 'ResourceAlreadyExistsException$message' => NULL, 'ResourceNotFoundException$message' => NULL, ], ], ],];
