<?php
// This file was auto-generated from sdk-root/src/data/quicksight/2018-04-01/docs-2.json
return [ 'version' => '2.0', 'service' => '<fullname>Amazon QuickSight API Reference</fullname> <p>Amazon QuickSight is a fully managed, serverless business intelligence service for the Amazon Web Services Cloud that makes it easy to extend data and insights to every user in your organization. This API reference contains documentation for a programming interface that you can use to manage Amazon QuickSight. </p>', 'operations' => [ 'CancelIngestion' => '<p>Cancels an ongoing ingestion of data into SPICE.</p>', 'CreateAccountCustomization' => '<p>Creates Amazon QuickSight customizations the current Amazon Web Services Region;. Currently, you can add a custom default theme by using the <code>CreateAccountCustomization</code> or <code>UpdateAccountCustomization</code> API operation. To further customize Amazon QuickSight by removing Amazon QuickSight sample assets and videos for all new users, see <a href="https://docs.aws.amazon.com/quicksight/latest/user/customizing-quicksight.html">Customizing Amazon QuickSight</a> in the <i>Amazon QuickSight User Guide.</i> </p> <p>You can create customizations for your Amazon Web Services account or, if you specify a namespace, for a Amazon QuickSight namespace instead. Customizations that apply to a namespace always override customizations that apply to an Amazon Web Services account. To find out which customizations apply, use the <code>DescribeAccountCustomization</code> API operation.</p> <p>Before you use the <code>CreateAccountCustomization</code> API operation to add a theme as the namespace default, make sure that you first share the theme with the namespace. If you don\'t share it with the namespace, the theme isn\'t visible to your users even if you make it the default theme. To check if the theme is shared, view the current permissions by using the <code> <a>DescribeThemePermissions</a> </code> API operation. To share the theme, grant permissions by using the <code> <a>UpdateThemePermissions</a> </code> API operation. </p>', 'CreateAnalysis' => '<p>Creates an analysis in Amazon QuickSight.</p>', 'CreateDashboard' => '<p>Creates a dashboard from a template. To first create a template, see the <code> <a>CreateTemplate</a> </code> API operation.</p> <p>A dashboard is an entity in Amazon QuickSight that identifies Amazon QuickSight reports, created from analyses. You can share Amazon QuickSight dashboards. With the right permissions, you can create scheduled email reports from them. If you have the correct permissions, you can create a dashboard from a template that exists in a different Amazon Web Services account.</p>', 'CreateDataSet' => '<p>Creates a dataset.</p>', 'CreateDataSource' => '<p>Creates a data source.</p>', 'CreateFolder' => '<p>Creates an empty shared folder.</p>', 'CreateFolderMembership' => '<p>Adds an asset, such as a dashboard, analysis, or dataset into a folder.</p>', 'CreateGroup' => '<p>Creates an Amazon QuickSight group.</p> <p>The permissions resource is <code>arn:aws:quicksight:us-east-1:<i>&lt;relevant-aws-account-id&gt;</i>:group/default/<i>&lt;group-name&gt;</i> </code>.</p> <p>The response is a group object.</p>', 'CreateGroupMembership' => '<p>Adds an Amazon QuickSight user to an Amazon QuickSight group. </p>', 'CreateIAMPolicyAssignment' => '<p>Creates an assignment with one specified IAMpolicy, identified by its Amazon Resource Name (ARN). This policy assignment is attached to the specified groups or users of Amazon QuickSight. Assignment names are unique per Amazon Web Services account. To avoid overwriting rules in other namespaces, use assignment names that are unique.</p>', 'CreateIngestion' => '<p>Creates and starts a new SPICE ingestion on a dataset</p> <p>Any ingestions operating on tagged datasets inherit the same tags automatically for use in access control. For an example, see <a href="http://aws.amazon.com/premiumsupport/knowledge-center/iam-ec2-resource-tags/">How do I create an IAM policy to control access to Amazon EC2 resources using tags?</a> in the Amazon Web Services Knowledge Center. Tags are visible on the tagged dataset, but not on the ingestion resource.</p>', 'CreateNamespace' => '<p>(Enterprise edition only) Creates a new namespace for you to use with Amazon QuickSight.</p> <p>A namespace allows you to isolate the Amazon QuickSight users and groups that are registered for that namespace. Users that access the namespace can share assets only with other users or groups in the same namespace. They can\'t see users and groups in other namespaces. You can create a namespace after your Amazon Web Services account is subscribed to Amazon QuickSight. The namespace must be unique within the Amazon Web Services account. By default, there is a limit of 100 namespaces per Amazon Web Services account. To increase your limit, create a ticket with Amazon Web Services Support. </p>', 'CreateTemplate' => '<p>Creates a template from an existing Amazon QuickSight analysis or template. You can use the resulting template to create a dashboard.</p> <p>A <i>template</i> is an entity in Amazon QuickSight that encapsulates the metadata required to create an analysis and that you can use to create s dashboard. A template adds a layer of abstraction by using placeholders to replace the dataset associated with the analysis. You can use templates to create dashboards by replacing dataset placeholders with datasets that follow the same schema that was used to create the source analysis and template.</p>', 'CreateTemplateAlias' => '<p>Creates a template alias for a template.</p>', 'CreateTheme' => '<p>Creates a theme.</p> <p>A <i>theme</i> is set of configuration options for color and layout. Themes apply to analyses and dashboards. For more information, see <a href="https://docs.aws.amazon.com/quicksight/latest/user/themes-in-quicksight.html">Using Themes in Amazon QuickSight</a> in the <i>Amazon QuickSight User Guide</i>.</p>', 'CreateThemeAlias' => '<p>Creates a theme alias for a theme.</p>', 'DeleteAccountCustomization' => '<p>Deletes all Amazon QuickSight customizations in this Amazon Web Services Region; for the specified Amazon Web Services account and Amazon QuickSight namespace.</p>', 'DeleteAnalysis' => '<p>Deletes an analysis from Amazon QuickSight. You can optionally include a recovery window during which you can restore the analysis. If you don\'t specify a recovery window value, the operation defaults to 30 days. Amazon QuickSight attaches a <code>DeletionTime</code> stamp to the response that specifies the end of the recovery window. At the end of the recovery window, Amazon QuickSight deletes the analysis permanently.</p> <p>At any time before recovery window ends, you can use the <code>RestoreAnalysis</code> API operation to remove the <code>DeletionTime</code> stamp and cancel the deletion of the analysis. The analysis remains visible in the API until it\'s deleted, so you can describe it but you can\'t make a template from it.</p> <p>An analysis that\'s scheduled for deletion isn\'t accessible in the Amazon QuickSight console. To access it in the console, restore it. Deleting an analysis doesn\'t delete the dashboards that you publish from it.</p>', 'DeleteDashboard' => '<p>Deletes a dashboard.</p>', 'DeleteDataSet' => '<p>Deletes a dataset.</p>', 'DeleteDataSource' => '<p>Deletes the data source permanently. This operation breaks all the datasets that reference the deleted data source.</p>', 'DeleteFolder' => '<p>Deletes an empty folder.</p>', 'DeleteFolderMembership' => '<p>Removes an asset, such as a dashboard, analysis, or dataset, from a folder.</p>', 'DeleteGroup' => '<p>Removes a user group from Amazon QuickSight. </p>', 'DeleteGroupMembership' => '<p>Removes a user from a group so that the user is no longer a member of the group.</p>', 'DeleteIAMPolicyAssignment' => '<p>Deletes an existing IAMpolicy assignment.</p>', 'DeleteNamespace' => '<p>Deletes a namespace and the users and groups that are associated with the namespace. This is an asynchronous process. Assets including dashboards, analyses, datasets and data sources are not deleted. To delete these assets, you use the API operations for the relevant asset. </p>', 'DeleteTemplate' => '<p>Deletes a template.</p>', 'DeleteTemplateAlias' => '<p>Deletes the item that the specified template alias points to. If you provide a specific alias, you delete the version of the template that the alias points to.</p>', 'DeleteTheme' => '<p>Deletes a theme.</p>', 'DeleteThemeAlias' => '<p>Deletes the version of the theme that the specified theme alias points to. If you provide a specific alias, you delete the version of the theme that the alias points to.</p>', 'DeleteUser' => '<p>Deletes the Amazon QuickSight user that is associated with the identity of the Identity and Access Management (IAM) user or role that\'s making the call. The IAM user isn\'t deleted as a result of this call. </p>', 'DeleteUserByPrincipalId' => '<p>Deletes a user identified by its principal ID. </p>', 'DescribeAccountCustomization' => '<p>Describes the customizations associated with the provided Amazon Web Services account and Amazon Amazon QuickSight namespace in an Amazon Web Services Region;. The Amazon QuickSight console evaluates which customizations to apply by running this API operation with the <code>Resolved</code> flag included. </p> <p>To determine what customizations display when you run this command, it can help to visualize the relationship of the entities involved. </p> <ul> <li> <p> <code>Amazon Web Services account</code> - The Amazon Web Services account exists at the top of the hierarchy. It has the potential to use all of the Amazon Web Services Regions; and AWS Services. When you subscribe to Amazon QuickSight, you choose one Amazon Web Services Region; to use as your home Region. That\'s where your free SPICE capacity is located. You can use Amazon QuickSight in any supported Amazon Web Services Region;. </p> </li> <li> <p> <code>Amazon Web Services Region;</code> - In each Amazon Web Services Region; where you sign in to Amazon QuickSight at least once, Amazon QuickSight acts as a separate instance of the same service. If you have a user directory, it resides in us-east-1, which is the US East (N. Virginia). Generally speaking, these users have access to Amazon QuickSight in any Amazon Web Services Region;, unless they are constrained to a namespace. </p> <p>To run the command in a different Amazon Web Services Region;, you change your Region settings. If you\'re using the AWS CLI, you can use one of the following options:</p> <ul> <li> <p>Use <a href="https://docs.aws.amazon.com/cli/latest/userguide/cli-configure-options.html">command line options</a>. </p> </li> <li> <p>Use <a href="https://docs.aws.amazon.com/cli/latest/userguide/cli-configure-profiles.html">named profiles</a>. </p> </li> <li> <p>Run <code>aws configure</code> to change your default Amazon Web Services Region;. Use Enter to key the same settings for your keys. For more information, see <a href="https://docs.aws.amazon.com/cli/latest/userguide/cli-chap-configure.html">Configuring the AWS CLI</a>.</p> </li> </ul> </li> <li> <p> <code>Namespace</code> - A Amazon QuickSight namespace is a partition that contains users and assets (data sources, datasets, dashboards, and so on). To access assets that are in a specific namespace, users and groups must also be part of the same namespace. People who share a namespace are completely isolated from users and assets in other namespaces, even if they are in the same Amazon Web Services account and Amazon Web Services Region;.</p> </li> <li> <p> <code>Applied customizations</code> - Within an Amazon Web Services Region;, a set of Amazon QuickSight customizations can apply to an Amazon Web Services account or to a namespace. Settings that you apply to a namespace override settings that you apply to an Amazon Web Services account. All settings are isolated to a single Amazon Web Services Region;. To apply them in other Amazon Web Services Regions;, run the <code>CreateAccountCustomization</code> command in each Amazon Web Services Region; where you want to apply the same customizations. </p> </li> </ul>', 'DescribeAccountSettings' => '<p>Describes the settings that were used when your Amazon QuickSight subscription was first created in this Amazon Web Services account.</p>', 'DescribeAnalysis' => '<p>Provides a summary of the metadata for an analysis.</p>', 'DescribeAnalysisPermissions' => '<p>Provides the read and write permissions for an analysis.</p>', 'DescribeDashboard' => '<p>Provides a summary for a dashboard.</p>', 'DescribeDashboardPermissions' => '<p>Describes read and write permissions for a dashboard.</p>', 'DescribeDataSet' => '<p>Describes a dataset. </p>', 'DescribeDataSetPermissions' => '<p>Describes the permissions on a dataset.</p> <p>The permissions resource is <code>arn:aws:quicksight:region:aws-account-id:dataset/data-set-id</code>.</p>', 'DescribeDataSource' => '<p>Describes a data source.</p>', 'DescribeDataSourcePermissions' => '<p>Describes the resource permissions for a data source.</p>', 'DescribeFolder' => '<p>Describes a folder.</p>', 'DescribeFolderPermissions' => '<p>Describes permissions for a folder.</p>', 'DescribeFolderResolvedPermissions' => '<p>Describes the folder resolved permissions. Permissions consists of both folder direct permissions and the inherited permissions from the ancestor folders.</p>', 'DescribeGroup' => '<p>Returns an Amazon QuickSight group\'s description and Amazon Resource Name (ARN). </p>', 'DescribeIAMPolicyAssignment' => '<p>Describes an existing IAMpolicy assignment, as specified by the assignment name.</p>', 'DescribeIngestion' => '<p>Describes a SPICE ingestion.</p>', 'DescribeNamespace' => '<p>Describes the current namespace.</p>', 'DescribeTemplate' => '<p>Describes a template\'s metadata.</p>', 'DescribeTemplateAlias' => '<p>Describes the template alias for a template.</p>', 'DescribeTemplatePermissions' => '<p>Describes read and write permissions on a template.</p>', 'DescribeTheme' => '<p>Describes a theme.</p>', 'DescribeThemeAlias' => '<p>Describes the alias for a theme.</p>', 'DescribeThemePermissions' => '<p>Describes the read and write permissions for a theme.</p>', 'DescribeUser' => '<p>Returns information about a user, given the user name. </p>', 'GenerateEmbedUrlForAnonymousUser' => '<p>Generates an embed URL that you can use to embed an Amazon QuickSight dashboard in your website, without having to register any reader users. Before you use this action, make sure that you have configured the dashboards and permissions.</p> <p>The following rules apply to the generated URL:</p> <ul> <li> <p>It contains a temporary bearer token. It is valid for 5 minutes after it is generated. Once redeemed within this period, it cannot be re-used again.</p> </li> <li> <p>The URL validity period should not be confused with the actual session lifetime that can be customized using the <code> <a href="https://docs.aws.amazon.com/quicksight/latest/APIReference/API_GenerateEmbedUrlForAnonymousUser.html#QS-GenerateEmbedUrlForAnonymousUser-request-SessionLifetimeInMinutes">SessionLifetimeInMinutes</a> </code> parameter.</p> <p>The resulting user session is valid for 15 minutes (default) to 10 hours (maximum).</p> </li> <li> <p>You are charged only when the URL is used or there is interaction with Amazon QuickSight.</p> </li> </ul> <p>For more information, see <a href="https://docs.aws.amazon.com/quicksight/latest/user/embedded-analytics.html">Embedded Analytics</a> in the <i>Amazon QuickSight User Guide</i>.</p> <p>For more information about the high-level steps for embedding and for an interactive demo of the ways you can customize embedding, visit the <a href="https://docs.aws.amazon.com/quicksight/latest/user/quicksight-dev-portal.html">Amazon QuickSight Developer Portal</a>.</p>', 'GenerateEmbedUrlForRegisteredUser' => '<p>Generates an embed URL that you can use to embed an Amazon QuickSight experience in your website. This action can be used for any type of user registered in an Amazon QuickSight account. Before you use this action, make sure that you have configured the relevant Amazon QuickSight resource and permissions.</p> <p>The following rules apply to the generated URL:</p> <ul> <li> <p>It contains a temporary bearer token. It is valid for 5 minutes after it is generated. Once redeemed within this period, it cannot be re-used again.</p> </li> <li> <p>The URL validity period should not be confused with the actual session lifetime that can be customized using the <code> <a href="https://docs.aws.amazon.com/quicksight/latest/APIReference/API_GenerateEmbedUrlForRegisteredUser.html#QS-GenerateEmbedUrlForRegisteredUser-request-SessionLifetimeInMinutes">SessionLifetimeInMinutes</a> </code> parameter.</p> <p>The resulting user session is valid for 15 minutes (default) to 10 hours (maximum).</p> </li> <li> <p>You are charged only when the URL is used or there is interaction with Amazon QuickSight.</p> </li> </ul> <p>For more information, see <a href="https://docs.aws.amazon.com/quicksight/latest/user/embedded-analytics.html">Embedded Analytics</a> in the <i>Amazon QuickSight User Guide</i>.</p> <p>For more information about the high-level steps for embedding and for an interactive demo of the ways you can customize embedding, visit the <a href="https://docs.aws.amazon.com/quicksight/latest/user/quicksight-dev-portal.html">Amazon QuickSight Developer Portal</a>.</p>', 'GetDashboardEmbedUrl' => '<p>Generates a session URL and authorization code that you can use to embed an Amazon Amazon QuickSight read-only dashboard in your web server code. Before you use this command, make sure that you have configured the dashboards and permissions. </p> <p>Currently, you can use <code>GetDashboardEmbedURL</code> only from the server, not from the user\'s browser. The following rules apply to the combination of URL and authorization code:</p> <ul> <li> <p>They must be used together.</p> </li> <li> <p>They can be used one time only.</p> </li> <li> <p>They are valid for 5 minutes after you run this command.</p> </li> <li> <p>The resulting user session is valid for 10 hours.</p> </li> </ul> <p>For more information, see <a href="https://docs.aws.amazon.com/quicksight/latest/user/embedded-analytics-deprecated.html">Embedding Analytics Using GetDashboardEmbedUrl</a> in the <i>Amazon QuickSight User Guide</i>.</p> <p>For more information about the high-level steps for embedding and for an interactive demo of the ways you can customize embedding, visit the <a href="https://docs.aws.amazon.com/quicksight/latest/user/quicksight-dev-portal.html">Amazon QuickSight Developer Portal</a>.</p>', 'GetSessionEmbedUrl' => '<p>Generates a session URL and authorization code that you can use to embed the Amazon Amazon QuickSight console in your web server code. Use <code>GetSessionEmbedUrl</code> where you want to provide an authoring portal that allows users to create data sources, datasets, analyses, and dashboards. The users who access an embedded Amazon QuickSight console need belong to the author or admin security cohort. If you want to restrict permissions to some of these features, add a custom permissions profile to the user with the <code> <a>UpdateUser</a> </code> API operation. Use <code> <a>RegisterUser</a> </code> API operation to add a new user with a custom permission profile attached. For more information, see the following sections in the <i>Amazon QuickSight User Guide</i>:</p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/quicksight/latest/user/embedded-analytics.html">Embedding Analytics</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/quicksight/latest/user/customizing-permissions-to-the-quicksight-console.html">Customizing Access to the Amazon QuickSight Console</a> </p> </li> </ul>', 'ListAnalyses' => '<p>Lists Amazon QuickSight analyses that exist in the specified Amazon Web Services account.</p>', 'ListDashboardVersions' => '<p>Lists all the versions of the dashboards in the Amazon QuickSight subscription.</p>', 'ListDashboards' => '<p>Lists dashboards in an Amazon Web Services account.</p>', 'ListDataSets' => '<p>Lists all of the datasets belonging to the current Amazon Web Services account in an Amazon Web Services Region;.</p> <p>The permissions resource is <code>arn:aws:quicksight:region:aws-account-id:dataset/*</code>.</p>', 'ListDataSources' => '<p>Lists data sources in current Amazon Web Services Region; that belong to this Amazon Web Services account.</p>', 'ListFolderMembers' => '<p>List all assets (<code>DASHBOARD</code>, <code>ANALYSIS</code>, and <code>DATASET</code>) in a folder. </p>', 'ListFolders' => '<p>Lists all folders in an account.</p>', 'ListGroupMemberships' => '<p>Lists member users in a group.</p>', 'ListGroups' => '<p>Lists all user groups in Amazon QuickSight. </p>', 'ListIAMPolicyAssignments' => '<p>Lists IAMpolicy assignments in the current Amazon QuickSight account.</p>', 'ListIAMPolicyAssignmentsForUser' => '<p>Lists all the IAMpolicy assignments, including the Amazon Resource Names (ARNs) for the IAM policies assigned to the specified user and group or groups that the user belongs to.</p>', 'ListIngestions' => '<p>Lists the history of SPICE ingestions for a dataset.</p>', 'ListNamespaces' => '<p>Lists the namespaces for the specified Amazon Web Services account.</p>', 'ListTagsForResource' => '<p>Lists the tags assigned to a resource.</p>', 'ListTemplateAliases' => '<p>Lists all the aliases of a template.</p>', 'ListTemplateVersions' => '<p>Lists all the versions of the templates in the current Amazon QuickSight account.</p>', 'ListTemplates' => '<p>Lists all the templates in the current Amazon QuickSight account.</p>', 'ListThemeAliases' => '<p>Lists all the aliases of a theme.</p>', 'ListThemeVersions' => '<p>Lists all the versions of the themes in the current Amazon Web Services account.</p>', 'ListThemes' => '<p>Lists all the themes in the current Amazon Web Services account.</p>', 'ListUserGroups' => '<p>Lists the Amazon QuickSight groups that an Amazon QuickSight user is a member of.</p>', 'ListUsers' => '<p>Returns a list of all of the Amazon QuickSight users belonging to this account. </p>', 'RegisterUser' => '<p>Creates an Amazon QuickSight user, whose identity is associated with the AWS Identity and Access Management (IAM) identity or role specified in the request. </p>', 'RestoreAnalysis' => '<p>Restores an analysis.</p>', 'SearchAnalyses' => '<p>Searches for analyses that belong to the user specified in the filter.</p> <note> <p>This operation is eventually consistent. The results are best effort and may not reflect very recent updates and changes.</p> </note>', 'SearchDashboards' => '<p>Searches for dashboards that belong to a user. </p> <note> <p>This operation is eventually consistent. The results are best effort and may not reflect very recent updates and changes.</p> </note>', 'SearchFolders' => '<p>Searches the subfolders in a folder.</p>', 'TagResource' => '<p>Assigns one or more tags (key-value pairs) to the specified Amazon QuickSight resource. </p> <p>Tags can help you organize and categorize your resources. You can also use them to scope user permissions, by granting a user permission to access or change only resources with certain tag values. You can use the <code>TagResource</code> operation with a resource that already has tags. If you specify a new tag key for the resource, this tag is appended to the list of tags associated with the resource. If you specify a tag key that is already associated with the resource, the new tag value that you specify replaces the previous value for that tag.</p> <p>You can associate as many as 50 tags with a resource. Amazon QuickSight supports tagging on data set, data source, dashboard, and template. </p> <p>Tagging for Amazon QuickSight works in a similar way to tagging for other AWS services, except for the following:</p> <ul> <li> <p>You can\'t use tags to track AWS costs for Amazon QuickSight. This restriction is because Amazon QuickSight costs are based on users and SPICE capacity, which aren\'t taggable resources.</p> </li> <li> <p>Amazon QuickSight doesn\'t currently support the Tag Editor for Resource Groups.</p> </li> </ul>', 'UntagResource' => '<p>Removes a tag or tags from a resource.</p>', 'UpdateAccountCustomization' => '<p>Updates Amazon QuickSight customizations the current Amazon Web Services Region;. Currently, the only customization you can use is a theme.</p> <p>You can use customizations for your Amazon Web Services account or, if you specify a namespace, for a Amazon QuickSight namespace instead. Customizations that apply to a namespace override customizations that apply to an Amazon Web Services account. To find out which customizations apply, use the <code>DescribeAccountCustomization</code> API operation. </p>', 'UpdateAccountSettings' => '<p>Updates the Amazon QuickSight settings in your Amazon Web Services account.</p>', 'UpdateAnalysis' => '<p>Updates an analysis in Amazon QuickSight</p>', 'UpdateAnalysisPermissions' => '<p>Updates the read and write permissions for an analysis.</p>', 'UpdateDashboard' => '<p>Updates a dashboard in an Amazon Web Services account.</p> <note> <p>Updating a Dashboard creates a new dashboard version but does not immediately publish the new version. You can update the published version of a dashboard by using the <a>UpdateDashboardPublishedVersion</a> API operation.</p> </note>', 'UpdateDashboardPermissions' => '<p>Updates read and write permissions on a dashboard.</p>', 'UpdateDashboardPublishedVersion' => '<p>Updates the published version of a dashboard.</p>', 'UpdateDataSet' => '<p>Updates a dataset.</p>', 'UpdateDataSetPermissions' => '<p>Updates the permissions on a dataset.</p> <p>The permissions resource is <code>arn:aws:quicksight:region:aws-account-id:dataset/data-set-id</code>.</p>', 'UpdateDataSource' => '<p>Updates a data source.</p>', 'UpdateDataSourcePermissions' => '<p>Updates the permissions to a data source.</p>', 'UpdateFolder' => '<p>Updates the name of a folder.</p>', 'UpdateFolderPermissions' => '<p>Updates permissions of a folder.</p>', 'UpdateGroup' => '<p>Changes a group description. </p>', 'UpdateIAMPolicyAssignment' => '<p>Updates an existing IAMpolicy assignment. This operation updates only the optional parameter or parameters that are specified in the request. This overwrites all of the users included in <code>Identities</code>. </p>', 'UpdateTemplate' => '<p>Updates a template from an existing Amazon QuickSight analysis or another template.</p>', 'UpdateTemplateAlias' => '<p>Updates the template alias of a template.</p>', 'UpdateTemplatePermissions' => '<p>Updates the resource permissions for a template.</p>', 'UpdateTheme' => '<p>Updates a theme.</p>', 'UpdateThemeAlias' => '<p>Updates an alias of a theme.</p>', 'UpdateThemePermissions' => '<p>Updates the resource permissions for a theme. Permissions apply to the action to grant or revoke permissions on, for example <code>"quicksight:DescribeTheme"</code>.</p> <p>Theme permissions apply in groupings. Valid groupings include the following for the three levels of permissions, which are user, owner, or no permissions: </p> <ul> <li> <p>User</p> <ul> <li> <p> <code>"quicksight:DescribeTheme"</code> </p> </li> <li> <p> <code>"quicksight:DescribeThemeAlias"</code> </p> </li> <li> <p> <code>"quicksight:ListThemeAliases"</code> </p> </li> <li> <p> <code>"quicksight:ListThemeVersions"</code> </p> </li> </ul> </li> <li> <p>Owner</p> <ul> <li> <p> <code>"quicksight:DescribeTheme"</code> </p> </li> <li> <p> <code>"quicksight:DescribeThemeAlias"</code> </p> </li> <li> <p> <code>"quicksight:ListThemeAliases"</code> </p> </li> <li> <p> <code>"quicksight:ListThemeVersions"</code> </p> </li> <li> <p> <code>"quicksight:DeleteTheme"</code> </p> </li> <li> <p> <code>"quicksight:UpdateTheme"</code> </p> </li> <li> <p> <code>"quicksight:CreateThemeAlias"</code> </p> </li> <li> <p> <code>"quicksight:DeleteThemeAlias"</code> </p> </li> <li> <p> <code>"quicksight:UpdateThemeAlias"</code> </p> </li> <li> <p> <code>"quicksight:UpdateThemePermissions"</code> </p> </li> <li> <p> <code>"quicksight:DescribeThemePermissions"</code> </p> </li> </ul> </li> <li> <p>To specify no permissions, omit the permissions list.</p> </li> </ul>', 'UpdateUser' => '<p>Updates an Amazon QuickSight user.</p>', ], 'shapes' => [ 'AccessDeniedException' => [ 'base' => '<p>You don\'t have access to this item. The provided credentials couldn\'t be validated. You might not be authorized to carry out the request. Make sure that your account is authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and that you are using the correct access keys.</p>', 'refs' => [], ], 'AccountCustomization' => [ 'base' => '<p>The Amazon QuickSight customizations associated with your Amazon Web Services account or a Amazon QuickSight namespace in a specific Amazon Web Services Region;.</p>', 'refs' => [ 'CreateAccountCustomizationRequest$AccountCustomization' => '<p>The Amazon QuickSight customizations you\'re adding in the current Amazon Web Services Region;. You can add these to an Amazon Web Services account and a Amazon QuickSight namespace. </p> <p>For example, you can add a default theme by setting <code>AccountCustomization</code> to the midnight theme: <code>"AccountCustomization": { "DefaultTheme": "arn:aws:quicksight::aws:theme/MIDNIGHT" }</code>. Or, you can add a custom theme by specifying <code>"AccountCustomization": { "DefaultTheme": "arn:aws:quicksight:us-west-2:111122223333:theme/bdb844d0-0fe9-4d9d-b520-0fe602d93639" }</code>. </p>', 'CreateAccountCustomizationResponse$AccountCustomization' => '<p>The Amazon QuickSight customizations you\'re adding in the current Amazon Web Services Region;. </p>', 'DescribeAccountCustomizationResponse$AccountCustomization' => '<p>The Amazon QuickSight customizations that exist in the current Amazon Web Services Region;. </p>', 'UpdateAccountCustomizationRequest$AccountCustomization' => '<p>The Amazon QuickSight customizations you\'re updating in the current Amazon Web Services Region;. </p>', 'UpdateAccountCustomizationResponse$AccountCustomization' => '<p>The Amazon QuickSight customizations you\'re updating in the current Amazon Web Services Region;. </p>', ], ], 'AccountSettings' => [ 'base' => '<p>The Amazon QuickSight settings associated with your Amazon Web Services account.</p>', 'refs' => [ 'DescribeAccountSettingsResponse$AccountSettings' => '<p>The Amazon QuickSight settings for this Amazon Web Services account. This information includes the edition of Amazon Amazon QuickSight that you subscribed to (Standard or Enterprise) and the notification email for the Amazon QuickSight subscription. In the Amazon QuickSight console, the Amazon QuickSight subscription is sometimes referred to as a Amazon QuickSight "account" even though it\'s technically not an account by itself. Instead, it\'s a subscription to the Amazon QuickSight service for your Amazon Web Services account. The edition that you subscribe to applies to Amazon QuickSight in every Amazon Web Services Region; where you use it.</p>', ], ], 'ActionList' => [ 'base' => NULL, 'refs' => [ 'ResourcePermission$Actions' => '<p>The IAMaction to grant or revoke permissions on.</p>', ], ], 'ActiveIAMPolicyAssignment' => [ 'base' => '<p>The active Identity and Access Management (IAM) policy assignment.</p>', 'refs' => [ 'ActiveIAMPolicyAssignmentList$member' => NULL, ], ], 'ActiveIAMPolicyAssignmentList' => [ 'base' => NULL, 'refs' => [ 'ListIAMPolicyAssignmentsForUserResponse$ActiveAssignments' => '<p>The active assignments for this user.</p>', ], ], 'AdHocFilteringOption' => [ 'base' => '<p>Ad hoc (one-time) filtering option.</p>', 'refs' => [ 'DashboardPublishOptions$AdHocFilteringOption' => '<p>Ad hoc (one-time) filtering option.</p>', ], ], 'AdditionalDashboardIdList' => [ 'base' => NULL, 'refs' => [ 'GetDashboardEmbedUrlRequest$AdditionalDashboardIds' => '<p>A list of one or more dashboard IDs that you want to add to a session that includes anonymous users. The <code>IdentityType</code> parameter must be set to <code>ANONYMOUS</code> for this to work, because other identity types authenticate as Amazon QuickSight or IAMusers. For example, if you set "<code>--dashboard-id dash_id1 --dashboard-id dash_id2 dash_id3 identity-type ANONYMOUS</code>", the session can access all three dashboards. </p>', ], ], 'AliasName' => [ 'base' => NULL, 'refs' => [ 'CreateTemplateAliasRequest$AliasName' => '<p>The name that you want to give to the template alias that you\'re creating. Don\'t start the alias name with the <code>$</code> character. Alias names that start with <code>$</code> are reserved by Amazon QuickSight. </p>', 'CreateThemeAliasRequest$AliasName' => '<p>The name that you want to give to the theme alias that you are creating. The alias name can\'t begin with a <code>$</code>. Alias names that start with <code>$</code> are reserved by Amazon QuickSight. </p>', 'DeleteTemplateAliasRequest$AliasName' => '<p>The name for the template alias. To delete a specific alias, you delete the version that the alias points to. You can specify the alias name, or specify the latest version of the template by providing the keyword <code>$LATEST</code> in the <code>AliasName</code> parameter. </p>', 'DeleteTemplateAliasResponse$AliasName' => '<p>The name for the template alias.</p>', 'DeleteThemeAliasRequest$AliasName' => '<p>The unique name for the theme alias to delete.</p>', 'DeleteThemeAliasResponse$AliasName' => '<p>The name for the theme alias.</p>', 'DescribeDashboardRequest$AliasName' => '<p>The alias name.</p>', 'DescribeTemplateAliasRequest$AliasName' => '<p>The name of the template alias that you want to describe. If you name a specific alias, you describe the version that the alias points to. You can specify the latest version of the template by providing the keyword <code>$LATEST</code> in the <code>AliasName</code> parameter. The keyword <code>$PUBLISHED</code> doesn\'t apply to templates.</p>', 'DescribeTemplateRequest$AliasName' => '<p>The alias of the template that you want to describe. If you name a specific alias, you describe the version that the alias points to. You can specify the latest version of the template by providing the keyword <code>$LATEST</code> in the <code>AliasName</code> parameter. The keyword <code>$PUBLISHED</code> doesn\'t apply to templates.</p>', 'DescribeThemeAliasRequest$AliasName' => '<p>The name of the theme alias that you want to describe.</p>', 'DescribeThemeRequest$AliasName' => '<p>The alias of the theme that you want to describe. If you name a specific alias, you describe the version that the alias points to. You can specify the latest version of the theme by providing the keyword <code>$LATEST</code> in the <code>AliasName</code> parameter. The keyword <code>$PUBLISHED</code> doesn\'t apply to themes.</p>', 'TemplateAlias$AliasName' => '<p>The display name of the template alias.</p>', 'ThemeAlias$AliasName' => '<p>The display name of the theme alias.</p>', 'UpdateTemplateAliasRequest$AliasName' => '<p>The alias of the template that you want to update. If you name a specific alias, you update the version that the alias points to. You can specify the latest version of the template by providing the keyword <code>$LATEST</code> in the <code>AliasName</code> parameter. The keyword <code>$PUBLISHED</code> doesn\'t apply to templates.</p>', 'UpdateThemeAliasRequest$AliasName' => '<p>The name of the theme alias that you want to update.</p>', ], ], 'AmazonElasticsearchParameters' => [ 'base' => '<p>The parameters for Elasticsearch.</p>', 'refs' => [ 'DataSourceParameters$AmazonElasticsearchParameters' => '<p>The parameters for Elasticsearch.</p>', ], ], 'AmazonOpenSearchParameters' => [ 'base' => NULL, 'refs' => [ 'DataSourceParameters$AmazonOpenSearchParameters' => NULL, ], ], 'Analysis' => [ 'base' => '<p>Metadata structure for an analysis in Amazon QuickSight</p>', 'refs' => [ 'DescribeAnalysisResponse$Analysis' => '<p>A metadata structure that contains summary information for the analysis that you\'re describing.</p>', ], ], 'AnalysisError' => [ 'base' => '<p>Analysis error.</p>', 'refs' => [ 'AnalysisErrorList$member' => NULL, ], ], 'AnalysisErrorList' => [ 'base' => NULL, 'refs' => [ 'Analysis$Errors' => '<p>Errors associated with the analysis.</p>', ], ], 'AnalysisErrorType' => [ 'base' => NULL, 'refs' => [ 'AnalysisError$Type' => '<p>The type of the analysis error.</p>', ], ], 'AnalysisFilterAttribute' => [ 'base' => NULL, 'refs' => [ 'AnalysisSearchFilter$Name' => '<p>The name of the value that you want to use as a filter, for example <code>"Name": "QUICKSIGHT_USER"</code>.</p>', ], ], 'AnalysisName' => [ 'base' => NULL, 'refs' => [ 'Analysis$Name' => '<p>The descriptive name of the analysis.</p>', 'AnalysisSummary$Name' => '<p>The name of the analysis. This name is displayed in the Amazon QuickSight console. </p>', 'CreateAnalysisRequest$Name' => '<p>A descriptive name for the analysis that you\'re creating. This name displays for the analysis in the Amazon QuickSight console. </p>', 'UpdateAnalysisRequest$Name' => '<p>A descriptive name for the analysis that you\'re updating. This name displays for the analysis in the Amazon QuickSight console.</p>', ], ], 'AnalysisSearchFilter' => [ 'base' => '<p>A filter that you apply when searching for one or more analyses.</p>', 'refs' => [ 'AnalysisSearchFilterList$member' => NULL, ], ], 'AnalysisSearchFilterList' => [ 'base' => NULL, 'refs' => [ 'SearchAnalysesRequest$Filters' => '<p>The structure for the search filters that you want to apply to your search. </p>', ], ], 'AnalysisSourceEntity' => [ 'base' => '<p>The source entity of an analysis.</p>', 'refs' => [ 'CreateAnalysisRequest$SourceEntity' => '<p>A source entity to use for the analysis that you\'re creating. This metadata structure contains details that describe a source template and one or more datasets.</p>', 'UpdateAnalysisRequest$SourceEntity' => '<p>A source entity to use for the analysis that you\'re updating. This metadata structure contains details that describe a source template and one or more datasets.</p>', ], ], 'AnalysisSourceTemplate' => [ 'base' => '<p>The source template of an analysis.</p>', 'refs' => [ 'AnalysisSourceEntity$SourceTemplate' => '<p>The source template for the source entity of the analysis.</p>', ], ], 'AnalysisSummary' => [ 'base' => '<p>The summary metadata that describes an analysis.</p>', 'refs' => [ 'AnalysisSummaryList$member' => NULL, ], ], 'AnalysisSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListAnalysesResponse$AnalysisSummaryList' => '<p>Metadata describing each of the analyses that are listed.</p>', 'SearchAnalysesResponse$AnalysisSummaryList' => '<p>Metadata describing the analyses that you searched for.</p>', ], ], 'AnonymousUserDashboardEmbeddingConfiguration' => [ 'base' => '<p>Information about the dashboard that you want to embed.</p>', 'refs' => [ 'AnonymousUserEmbeddingExperienceConfiguration$Dashboard' => '<p>The type of embedding experience. In this case, an Amazon QuickSight dashboard.</p>', ], ], 'AnonymousUserEmbeddingExperienceConfiguration' => [ 'base' => '<p>The type of experience you want to embed. For anonymous users, you can embed an Amazon QuickSight dashboard.</p>', 'refs' => [ 'GenerateEmbedUrlForAnonymousUserRequest$ExperienceConfiguration' => '<p>The configuration of the experience you are embedding.</p>', ], ], 'Arn' => [ 'base' => NULL, 'refs' => [ 'AccountCustomization$DefaultTheme' => '<p>The default theme for this Amazon QuickSight subscription.</p>', 'ActiveIAMPolicyAssignment$PolicyArn' => '<p>The Amazon Resource Name (ARN) of the resource.</p>', 'Analysis$Arn' => '<p>The Amazon Resource Name (ARN) of the analysis.</p>', 'Analysis$ThemeArn' => '<p>The ARN of the theme of the analysis.</p>', 'AnalysisSourceTemplate$Arn' => '<p>The Amazon Resource Name (ARN) of the source template of an analysis.</p>', 'AnalysisSummary$Arn' => '<p>The Amazon Resource Name (ARN) for the analysis.</p>', 'ArnList$member' => NULL, 'CancelIngestionResponse$Arn' => '<p>The Amazon Resource Name (ARN) for the data ingestion.</p>', 'CreateAccountCustomizationResponse$Arn' => '<p>The Amazon Resource Name (ARN) for the customization that you created for this Amazon Web Services account.</p>', 'CreateAnalysisRequest$ThemeArn' => '<p>The ARN for the theme to apply to the analysis that you\'re creating. To see the theme in the Amazon QuickSight console, make sure that you have access to it.</p>', 'CreateAnalysisResponse$Arn' => '<p>The ARN for the analysis.</p>', 'CreateDashboardRequest$ThemeArn' => '<p>The Amazon Resource Name (ARN) of the theme that is being used for this dashboard. If you add a value for this field, it overrides the value that is used in the source entity. The theme ARN must exist in the same Amazon Web Services account where you create the dashboard.</p>', 'CreateDashboardResponse$Arn' => '<p>The ARN of the dashboard.</p>', 'CreateDashboardResponse$VersionArn' => '<p>The ARN of the dashboard, including the version number of the first version that is created.</p>', 'CreateDataSetResponse$Arn' => '<p>The Amazon Resource Name (ARN) of the dataset.</p>', 'CreateDataSetResponse$IngestionArn' => '<p>The ARN for the ingestion, which is triggered as a result of dataset creation if the import mode is SPICE.</p>', 'CreateDataSourceResponse$Arn' => '<p>The Amazon Resource Name (ARN) of the data source.</p>', 'CreateFolderRequest$ParentFolderArn' => '<p>The Amazon Resource Name (ARN) for the parent folder.</p> <p> <code>ParentFolderArn</code> can be null. An empty <code>parentFolderArn</code> creates a root-level folder.</p>', 'CreateFolderResponse$Arn' => '<p>The Amazon Resource Name (ARN) for the newly created folder.</p>', 'CreateIAMPolicyAssignmentRequest$PolicyArn' => '<p>The ARN for the IAMpolicy to apply to the Amazon QuickSight users and groups specified in this assignment.</p>', 'CreateIAMPolicyAssignmentResponse$PolicyArn' => '<p>The ARN for the IAMpolicy that is applied to the Amazon QuickSight users and groups specified in this assignment.</p>', 'CreateIngestionResponse$Arn' => '<p>The Amazon Resource Name (ARN) for the data ingestion.</p>', 'CreateNamespaceResponse$Arn' => '<p>The ARN of the Amazon QuickSight namespace you created. </p>', 'CreateTemplateResponse$Arn' => '<p>The ARN for the template.</p>', 'CreateTemplateResponse$VersionArn' => '<p>The ARN for the template, including the version information of the first version.</p>', 'CreateThemeResponse$Arn' => '<p>The Amazon Resource Name (ARN) for the theme.</p>', 'CreateThemeResponse$VersionArn' => '<p>The Amazon Resource Name (ARN) for the new theme.</p>', 'CustomSql$DataSourceArn' => '<p>The Amazon Resource Name (ARN) of the data source.</p>', 'Dashboard$Arn' => '<p>The Amazon Resource Name (ARN) of the resource.</p>', 'DashboardSourceTemplate$Arn' => '<p>The Amazon Resource Name (ARN) of the resource.</p>', 'DashboardSummary$Arn' => '<p>The Amazon Resource Name (ARN) of the resource.</p>', 'DashboardVersion$Arn' => '<p>The Amazon Resource Name (ARN) of the resource.</p>', 'DashboardVersion$SourceEntityArn' => '<p>Source entity ARN.</p>', 'DashboardVersion$ThemeArn' => '<p>The ARN of the theme associated with a version of the dashboard.</p>', 'DashboardVersionSummary$Arn' => '<p>The Amazon Resource Name (ARN) of the resource.</p>', 'DashboardVersionSummary$SourceEntityArn' => '<p>Source entity ARN.</p>', 'DataSet$Arn' => '<p>The Amazon Resource Name (ARN) of the resource.</p>', 'DataSetArnsList$member' => NULL, 'DataSetReference$DataSetArn' => '<p>Dataset Amazon Resource Name (ARN).</p>', 'DataSetSummary$Arn' => '<p>The Amazon Resource Name (ARN) of the dataset.</p>', 'DataSource$Arn' => '<p>The Amazon Resource Name (ARN) of the data source.</p>', 'DeleteAnalysisResponse$Arn' => '<p>The Amazon Resource Name (ARN) of the deleted analysis.</p>', 'DeleteDashboardResponse$Arn' => '<p>The Secure Socket Layer (SSL) properties that apply for the resource.</p>', 'DeleteDataSetResponse$Arn' => '<p>The Amazon Resource Name (ARN) of the dataset.</p>', 'DeleteDataSourceResponse$Arn' => '<p>The Amazon Resource Name (ARN) of the data source that you deleted.</p>', 'DeleteFolderResponse$Arn' => '<p>The Amazon Resource Name of the deleted folder.</p>', 'DeleteTemplateAliasResponse$Arn' => '<p>The Amazon Resource Name (ARN) of the template you want to delete.</p>', 'DeleteTemplateResponse$Arn' => '<p>The Amazon Resource Name (ARN) of the resource.</p>', 'DeleteThemeAliasResponse$Arn' => '<p>The Amazon Resource Name (ARN) of the theme resource using the deleted alias.</p>', 'DeleteThemeResponse$Arn' => '<p>The Amazon Resource Name (ARN) of the resource.</p>', 'DescribeAccountCustomizationResponse$Arn' => '<p>The Amazon Resource Name (ARN) of the customization that\'s associated with this Amazon Web Services account.</p>', 'DescribeAnalysisPermissionsResponse$AnalysisArn' => '<p>The Amazon Resource Name (ARN) of the analysis whose permissions you\'re describing.</p>', 'DescribeDashboardPermissionsResponse$DashboardArn' => '<p>The Amazon Resource Name (ARN) of the dashboard.</p>', 'DescribeDataSetPermissionsResponse$DataSetArn' => '<p>The Amazon Resource Name (ARN) of the dataset.</p>', 'DescribeDataSourcePermissionsResponse$DataSourceArn' => '<p>The Amazon Resource Name (ARN) of the data source.</p>', 'DescribeFolderPermissionsResponse$Arn' => '<p>The Amazon Resource Name (ARN) for the folder.</p>', 'DescribeFolderResolvedPermissionsResponse$Arn' => '<p>The Amazon Resource Name (ARN).</p>', 'DescribeTemplatePermissionsResponse$TemplateArn' => '<p>The Amazon Resource Name (ARN) of the template.</p>', 'DescribeThemePermissionsResponse$ThemeArn' => '<p>The Amazon Resource Name (ARN) of the theme.</p>', 'Folder$Arn' => '<p>The folder Amazon Resource Name (ARN).</p>', 'FolderSummary$Arn' => '<p>The Amazon Resource Name (ARN).</p>', 'GenerateEmbedUrlForRegisteredUserRequest$UserArn' => '<p>The Amazon Resource Name for the registered user.</p>', 'GetDashboardEmbedUrlRequest$UserArn' => '<p>The Amazon QuickSight user\'s Amazon Resource Name (ARN), for use with <code>QUICKSIGHT</code> identity type. You can use this for any Amazon QuickSight users in your account (readers, authors, or admins) authenticated as one of the following:</p> <ul> <li> <p>Active Directory (AD) users or group members</p> </li> <li> <p>Invited nonfederated users</p> </li> <li> <p>IAMusers and IAMrole-based sessions authenticated through Federated Single Sign-On using SAML, OpenID Connect, or IAMfederation.</p> </li> </ul> <p>Omit this parameter for users in the third group – IAMusers and IAM role-based sessions.</p>', 'GetSessionEmbedUrlRequest$UserArn' => '<p>The Amazon QuickSight user\'s Amazon Resource Name (ARN), for use with <code>QUICKSIGHT</code> identity type. You can use this for any type of Amazon QuickSight users in your account (readers, authors, or admins). They need to be authenticated as one of the following:</p> <ol> <li> <p>Active Directory (AD) users or group members</p> </li> <li> <p>Invited nonfederated users</p> </li> <li> <p>Identity and Access Management (IAM) users and IAM role-based sessions authenticated through Federated Single Sign-On using SAML, OpenID Connect, or IAM federation</p> </li> </ol> <p>Omit this parameter for users in the third group, IAM users and IAM role-based sessions.</p>', 'Group$Arn' => '<p>The Amazon Resource Name (ARN) for the group.</p>', 'GroupMember$Arn' => '<p>The Amazon Resource Name (ARN) for the group member (user).</p>', 'IAMPolicyAssignment$PolicyArn' => '<p>The Amazon Resource Name (ARN) for the IAMpolicy.</p>', 'Ingestion$Arn' => '<p>The Amazon Resource Name (ARN) of the resource.</p>', 'ListTagsForResourceRequest$ResourceArn' => '<p>The Amazon Resource Name (ARN) of the resource that you want a list of tags for.</p>', 'LogicalTableSource$DataSetArn' => '<p>The Amazon Resource Number (ARN) of the parent dataset.</p>', 'MemberIdArnPair$MemberArn' => '<p>The Amazon Resource Name (ARN) of the member.</p>', 'NamespaceInfoV2$Arn' => '<p>The namespace ARN.</p>', 'Path$member' => NULL, 'RelationalTable$DataSourceArn' => '<p>The Amazon Resource Name (ARN) for the data source.</p>', 'RestoreAnalysisResponse$Arn' => '<p>The Amazon Resource Name (ARN) of the analysis that you\'re restoring.</p>', 'RowLevelPermissionDataSet$Arn' => '<p>The Amazon Resource Name (ARN) of the dataset that contains permissions for RLS.</p>', 'S3Source$DataSourceArn' => '<p>The Amazon Resource Name (ARN) for the data source.</p>', 'TagResourceRequest$ResourceArn' => '<p>The Amazon Resource Name (ARN) of the resource that you want to tag.</p>', 'Template$Arn' => '<p>The Amazon Resource Name (ARN) of the template.</p>', 'TemplateAlias$Arn' => '<p>The Amazon Resource Name (ARN) of the template alias.</p>', 'TemplateSourceAnalysis$Arn' => '<p>The Amazon Resource Name (ARN) of the resource.</p>', 'TemplateSourceTemplate$Arn' => '<p>The Amazon Resource Name (ARN) of the resource.</p>', 'TemplateSummary$Arn' => '<p>A summary of a template.</p>', 'TemplateVersion$SourceEntityArn' => '<p>The Amazon Resource Name (ARN) of an analysis or template that was used to create this template.</p>', 'TemplateVersion$ThemeArn' => '<p>The ARN of the theme associated with this version of the template.</p>', 'TemplateVersionSummary$Arn' => '<p>The Amazon Resource Name (ARN) of the template version.</p>', 'Theme$Arn' => '<p>The Amazon Resource Name (ARN) of the theme.</p>', 'ThemeAlias$Arn' => '<p>The Amazon Resource Name (ARN) of the theme alias.</p>', 'ThemeSummary$Arn' => '<p>The Amazon Resource Name (ARN) of the resource.</p>', 'ThemeVersion$Arn' => '<p>The Amazon Resource Name (ARN) of the resource.</p>', 'ThemeVersionSummary$Arn' => '<p>The Amazon Resource Name (ARN) of the theme version.</p>', 'UntagResourceRequest$ResourceArn' => '<p>The Amazon Resource Name (ARN) of the resource that you want to untag.</p>', 'UpdateAccountCustomizationResponse$Arn' => '<p>The Amazon Resource Name (ARN) for the updated customization for this Amazon Web Services account.</p>', 'UpdateAnalysisPermissionsResponse$AnalysisArn' => '<p>The Amazon Resource Name (ARN) of the analysis that you updated.</p>', 'UpdateAnalysisRequest$ThemeArn' => '<p>The Amazon Resource Name (ARN) for the theme to apply to the analysis that you\'re creating. To see the theme in the Amazon QuickSight console, make sure that you have access to it.</p>', 'UpdateAnalysisResponse$Arn' => '<p>The ARN of the analysis that you\'re updating.</p>', 'UpdateDashboardPermissionsResponse$DashboardArn' => '<p>The Amazon Resource Name (ARN) of the dashboard.</p>', 'UpdateDashboardPublishedVersionResponse$DashboardArn' => '<p>The Amazon Resource Name (ARN) of the dashboard.</p>', 'UpdateDashboardRequest$ThemeArn' => '<p>The Amazon Resource Name (ARN) of the theme that is being used for this dashboard. If you add a value for this field, it overrides the value that was originally associated with the entity. The theme ARN must exist in the same Amazon Web Services account where you create the dashboard.</p>', 'UpdateDashboardResponse$Arn' => '<p>The Amazon Resource Name (ARN) of the resource.</p>', 'UpdateDashboardResponse$VersionArn' => '<p>The ARN of the dashboard, including the version number.</p>', 'UpdateDataSetPermissionsResponse$DataSetArn' => '<p>The Amazon Resource Name (ARN) of the dataset.</p>', 'UpdateDataSetResponse$Arn' => '<p>The Amazon Resource Name (ARN) of the dataset.</p>', 'UpdateDataSetResponse$IngestionArn' => '<p>The ARN for the ingestion, which is triggered as a result of dataset creation if the import mode is SPICE.</p>', 'UpdateDataSourcePermissionsResponse$DataSourceArn' => '<p>The Amazon Resource Name (ARN) of the data source.</p>', 'UpdateDataSourceResponse$Arn' => '<p>The Amazon Resource Name (ARN) of the data source.</p>', 'UpdateFolderPermissionsResponse$Arn' => '<p>The Amazon Resource Name (ARN).</p>', 'UpdateFolderResponse$Arn' => '<p>The Amazon Resource Name (ARN).</p>', 'UpdateIAMPolicyAssignmentRequest$PolicyArn' => '<p>The ARN for the IAMpolicy to apply to the Amazon QuickSight users and groups specified in this assignment.</p>', 'UpdateIAMPolicyAssignmentResponse$PolicyArn' => '<p>The ARN for the IAMpolicy applied to the Amazon QuickSight users and groups specified in this assignment.</p>', 'UpdateTemplatePermissionsResponse$TemplateArn' => '<p>The Amazon Resource Name (ARN) of the template.</p>', 'UpdateTemplateResponse$Arn' => '<p>The Amazon Resource Name (ARN) for the template.</p>', 'UpdateTemplateResponse$VersionArn' => '<p>The ARN for the template, including the version information of the first version.</p>', 'UpdateThemePermissionsResponse$ThemeArn' => '<p>The Amazon Resource Name (ARN) of the theme.</p>', 'UpdateThemeResponse$Arn' => '<p>The Amazon Resource Name (ARN) for the theme.</p>', 'UpdateThemeResponse$VersionArn' => '<p>The Amazon Resource Name (ARN) for the new version of the theme.</p>', 'User$Arn' => '<p>The Amazon Resource Name (ARN) for the user.</p>', 'VpcConnectionProperties$VpcConnectionArn' => '<p>The Amazon Resource Name (ARN) for the VPC connection.</p>', ], ], 'ArnList' => [ 'base' => NULL, 'refs' => [ 'GenerateEmbedUrlForAnonymousUserRequest$AuthorizedResourceArns' => '<p>The Amazon Resource Names for the Amazon QuickSight resources that the user is authorized to access during the lifetime of the session. If you choose <code>Dashboard</code> embedding experience, pass the list of dashboard ARNs in the account that you want the user to be able to view.</p>', ], ], 'AssignmentStatus' => [ 'base' => NULL, 'refs' => [ 'CreateIAMPolicyAssignmentRequest$AssignmentStatus' => '<p>The status of the assignment. Possible values are as follows:</p> <ul> <li> <p> <code>ENABLED</code> - Anything specified in this assignment is used when creating the data source.</p> </li> <li> <p> <code>DISABLED</code> - This assignment isn\'t used when creating the data source.</p> </li> <li> <p> <code>DRAFT</code> - This assignment is an unfinished draft and isn\'t used when creating the data source.</p> </li> </ul>', 'CreateIAMPolicyAssignmentResponse$AssignmentStatus' => '<p>The status of the assignment. Possible values are as follows:</p> <ul> <li> <p> <code>ENABLED</code> - Anything specified in this assignment is used when creating the data source.</p> </li> <li> <p> <code>DISABLED</code> - This assignment isn\'t used when creating the data source.</p> </li> <li> <p> <code>DRAFT</code> - This assignment is an unfinished draft and isn\'t used when creating the data source.</p> </li> </ul>', 'IAMPolicyAssignment$AssignmentStatus' => '<p>Assignment status.</p>', 'IAMPolicyAssignmentSummary$AssignmentStatus' => '<p>Assignment status.</p>', 'ListIAMPolicyAssignmentsRequest$AssignmentStatus' => '<p>The status of the assignments.</p>', 'UpdateIAMPolicyAssignmentRequest$AssignmentStatus' => '<p>The status of the assignment. Possible values are as follows:</p> <ul> <li> <p> <code>ENABLED</code> - Anything specified in this assignment is used when creating the data source.</p> </li> <li> <p> <code>DISABLED</code> - This assignment isn\'t used when creating the data source.</p> </li> <li> <p> <code>DRAFT</code> - This assignment is an unfinished draft and isn\'t used when creating the data source.</p> </li> </ul>', 'UpdateIAMPolicyAssignmentResponse$AssignmentStatus' => '<p>The status of the assignment. Possible values are as follows:</p> <ul> <li> <p> <code>ENABLED</code> - Anything specified in this assignment is used when creating the data source.</p> </li> <li> <p> <code>DISABLED</code> - This assignment isn\'t used when creating the data source.</p> </li> <li> <p> <code>DRAFT</code> - This assignment is an unfinished draft and isn\'t used when creating the data source.</p> </li> </ul>', ], ], 'AthenaParameters' => [ 'base' => '<p>Parameters for Amazon Athena.</p>', 'refs' => [ 'DataSourceParameters$AthenaParameters' => '<p>The parameters for Amazon Athena.</p>', ], ], 'AuroraParameters' => [ 'base' => '<p>Parameters for Amazon Aurora.</p>', 'refs' => [ 'DataSourceParameters$AuroraParameters' => '<p>The parameters for Amazon Aurora MySQL.</p>', ], ], 'AuroraPostgreSqlParameters' => [ 'base' => '<p>Parameters for Amazon Aurora PostgreSQL-Compatible Edition.</p>', 'refs' => [ 'DataSourceParameters$AuroraPostgreSqlParameters' => '<p>The parameters for Amazon Aurora.</p>', ], ], 'AwsAccountId' => [ 'base' => NULL, 'refs' => [ 'CancelIngestionRequest$AwsAccountId' => '<p>The Amazon Web Services account ID.</p>', 'CreateAccountCustomizationRequest$AwsAccountId' => '<p>The ID for the Amazon Web Services account that you want to customize Amazon QuickSight for.</p>', 'CreateAccountCustomizationResponse$AwsAccountId' => '<p>The ID for the Amazon Web Services account that you want to customize Amazon QuickSight for.</p>', 'CreateAnalysisRequest$AwsAccountId' => '<p>The ID of the Amazon Web Services account where you are creating an analysis.</p>', 'CreateDashboardRequest$AwsAccountId' => '<p>The ID of the Amazon Web Services account where you want to create the dashboard.</p>', 'CreateDataSetRequest$AwsAccountId' => '<p>The Amazon Web Services account ID.</p>', 'CreateDataSourceRequest$AwsAccountId' => '<p>The Amazon Web Services account ID.</p>', 'CreateFolderMembershipRequest$AwsAccountId' => '<p>The AWS Account ID.</p>', 'CreateFolderRequest$AwsAccountId' => '<p>The AWS Account ID.</p>', 'CreateGroupMembershipRequest$AwsAccountId' => '<p>The ID for the Amazon Web Services account that the group is in. Currently, you use the ID for the Amazon Web Services account that contains your Amazon QuickSight account.</p>', 'CreateGroupRequest$AwsAccountId' => '<p>The ID for the Amazon Web Services account that the group is in. Currently, you use the ID for the Amazon Web Services account that contains your Amazon QuickSight account.</p>', 'CreateIAMPolicyAssignmentRequest$AwsAccountId' => '<p>The ID of the Amazon Web Services account where you want to assign an IAMpolicy to Amazon QuickSight users or groups.</p>', 'CreateIngestionRequest$AwsAccountId' => '<p>The Amazon Web Services account ID.</p>', 'CreateNamespaceRequest$AwsAccountId' => '<p>The ID for the Amazon Web Services account that you want to create the Amazon QuickSight namespace in.</p>', 'CreateTemplateAliasRequest$AwsAccountId' => '<p>The ID of the Amazon Web Services account that contains the template that you creating an alias for.</p>', 'CreateTemplateRequest$AwsAccountId' => '<p>The ID for the Amazon Web Services account that the group is in. You use the ID for the Amazon Web Services account that contains your Amazon QuickSight account.</p>', 'CreateThemeAliasRequest$AwsAccountId' => '<p>The ID of the Amazon Web Services account that contains the theme for the new theme alias.</p>', 'CreateThemeRequest$AwsAccountId' => '<p>The ID of the Amazon Web Services account where you want to store the new theme. </p>', 'DeleteAccountCustomizationRequest$AwsAccountId' => '<p>The ID for the Amazon Web Services account that you want to delete Amazon QuickSight customizations from in this Amazon Web Services Region;.</p>', 'DeleteAnalysisRequest$AwsAccountId' => '<p>The ID of the Amazon Web Services account where you want to delete an analysis.</p>', 'DeleteDashboardRequest$AwsAccountId' => '<p>The ID of the Amazon Web Services account that contains the dashboard that you\'re deleting.</p>', 'DeleteDataSetRequest$AwsAccountId' => '<p>The Amazon Web Services account ID.</p>', 'DeleteDataSourceRequest$AwsAccountId' => '<p>The Amazon Web Services account ID.</p>', 'DeleteFolderMembershipRequest$AwsAccountId' => '<p>The AWS Account ID.</p>', 'DeleteFolderRequest$AwsAccountId' => '<p>The AWS Account ID for the folder.</p>', 'DeleteGroupMembershipRequest$AwsAccountId' => '<p>The ID for the Amazon Web Services account that the group is in. Currently, you use the ID for the Amazon Web Services account that contains your Amazon QuickSight account.</p>', 'DeleteGroupRequest$AwsAccountId' => '<p>The ID for the Amazon Web Services account that the group is in. Currently, you use the ID for the Amazon Web Services account that contains your Amazon QuickSight account.</p>', 'DeleteIAMPolicyAssignmentRequest$AwsAccountId' => '<p>The Amazon Web Services account ID where you want to delete the IAMpolicy assignment.</p>', 'DeleteNamespaceRequest$AwsAccountId' => '<p>The ID for the Amazon Web Services account that you want to delete the Amazon QuickSight namespace from.</p>', 'DeleteTemplateAliasRequest$AwsAccountId' => '<p>The ID of the Amazon Web Services account that contains the item to delete.</p>', 'DeleteTemplateRequest$AwsAccountId' => '<p>The ID of the Amazon Web Services account that contains the template that you\'re deleting.</p>', 'DeleteThemeAliasRequest$AwsAccountId' => '<p>The ID of the Amazon Web Services account that contains the theme alias to delete.</p>', 'DeleteThemeRequest$AwsAccountId' => '<p>The ID of the Amazon Web Services account that contains the theme that you\'re deleting.</p>', 'DeleteUserByPrincipalIdRequest$AwsAccountId' => '<p>The ID for the Amazon Web Services account that the user is in. Currently, you use the ID for the Amazon Web Services account that contains your Amazon QuickSight account.</p>', 'DeleteUserRequest$AwsAccountId' => '<p>The ID for the Amazon Web Services account that the user is in. Currently, you use the ID for the Amazon Web Services account that contains your Amazon QuickSight account.</p>', 'DescribeAccountCustomizationRequest$AwsAccountId' => '<p>The ID for the Amazon Web Services account that you want to describe Amazon QuickSight customizations for.</p>', 'DescribeAccountCustomizationResponse$AwsAccountId' => '<p>The ID for the Amazon Web Services account that you\'re describing.</p>', 'DescribeAccountSettingsRequest$AwsAccountId' => '<p>The ID for the Amazon Web Services account that contains the settings that you want to list.</p>', 'DescribeAnalysisPermissionsRequest$AwsAccountId' => '<p>The ID of the Amazon Web Services account that contains the analysis whose permissions you\'re describing. You must be using the Amazon Web Services account that the analysis is in.</p>', 'DescribeAnalysisRequest$AwsAccountId' => '<p>The ID of the Amazon Web Services account that contains the analysis. You must be using the Amazon Web Services account that the analysis is in.</p>', 'DescribeDashboardPermissionsRequest$AwsAccountId' => '<p>The ID of the Amazon Web Services account that contains the dashboard that you\'re describing permissions for.</p>', 'DescribeDashboardRequest$AwsAccountId' => '<p>The ID of the Amazon Web Services account that contains the dashboard that you\'re describing.</p>', 'DescribeDataSetPermissionsRequest$AwsAccountId' => '<p>The Amazon Web Services account ID.</p>', 'DescribeDataSetRequest$AwsAccountId' => '<p>The Amazon Web Services account ID.</p>', 'DescribeDataSourcePermissionsRequest$AwsAccountId' => '<p>The Amazon Web Services account ID.</p>', 'DescribeDataSourceRequest$AwsAccountId' => '<p>The Amazon Web Services account ID.</p>', 'DescribeFolderPermissionsRequest$AwsAccountId' => '<p>The AWS Account ID.</p>', 'DescribeFolderRequest$AwsAccountId' => '<p>The AWS account ID.</p>', 'DescribeFolderResolvedPermissionsRequest$AwsAccountId' => '<p>The AWS account ID.</p>', 'DescribeGroupRequest$AwsAccountId' => '<p>The ID for the Amazon Web Services account that the group is in. Currently, you use the ID for the Amazon Web Services account that contains your Amazon QuickSight account.</p>', 'DescribeIAMPolicyAssignmentRequest$AwsAccountId' => '<p>The ID of the Amazon Web Services account that contains the assignment that you want to describe.</p>', 'DescribeIngestionRequest$AwsAccountId' => '<p>The Amazon Web Services account ID.</p>', 'DescribeNamespaceRequest$AwsAccountId' => '<p>The ID for the Amazon Web Services account that contains the Amazon QuickSight namespace that you want to describe.</p>', 'DescribeTemplateAliasRequest$AwsAccountId' => '<p>The ID of the Amazon Web Services account that contains the template alias that you\'re describing.</p>', 'DescribeTemplatePermissionsRequest$AwsAccountId' => '<p>The ID of the Amazon Web Services account that contains the template that you\'re describing.</p>', 'DescribeTemplateRequest$AwsAccountId' => '<p>The ID of the Amazon Web Services account that contains the template that you\'re describing.</p>', 'DescribeThemeAliasRequest$AwsAccountId' => '<p>The ID of the Amazon Web Services account that contains the theme alias that you\'re describing.</p>', 'DescribeThemePermissionsRequest$AwsAccountId' => '<p>The ID of the Amazon Web Services account that contains the theme that you\'re describing.</p>', 'DescribeUserRequest$AwsAccountId' => '<p>The ID for the Amazon Web Services account that the user is in. Currently, you use the ID for the Amazon Web Services account that contains your Amazon QuickSight account.</p>', 'GenerateEmbedUrlForAnonymousUserRequest$AwsAccountId' => '<p>The ID for the Amazon Web Services account that contains the dashboard that you\'re embedding.</p>', 'GenerateEmbedUrlForRegisteredUserRequest$AwsAccountId' => '<p>The ID for the Amazon Web Services account that contains the dashboard that you\'re embedding.</p>', 'GetDashboardEmbedUrlRequest$AwsAccountId' => '<p>The ID for the Amazon Web Services account that contains the dashboard that you\'re embedding.</p>', 'GetSessionEmbedUrlRequest$AwsAccountId' => '<p>The ID for the Amazon Web Services account associated with your Amazon QuickSight subscription.</p>', 'IAMPolicyAssignment$AwsAccountId' => '<p>The Amazon Web Services account ID.</p>', 'ListAnalysesRequest$AwsAccountId' => '<p>The ID of the Amazon Web Services account that contains the analyses.</p>', 'ListDashboardVersionsRequest$AwsAccountId' => '<p>The ID of the Amazon Web Services account that contains the dashboard that you\'re listing versions for.</p>', 'ListDashboardsRequest$AwsAccountId' => '<p>The ID of the Amazon Web Services account that contains the dashboards that you\'re listing.</p>', 'ListDataSetsRequest$AwsAccountId' => '<p>The Amazon Web Services account ID.</p>', 'ListDataSourcesRequest$AwsAccountId' => '<p>The Amazon Web Services account ID.</p>', 'ListFolderMembersRequest$AwsAccountId' => '<p>The AWS account ID.</p>', 'ListFoldersRequest$AwsAccountId' => '<p>The AWS account ID.</p>', 'ListGroupMembershipsRequest$AwsAccountId' => '<p>The ID for the Amazon Web Services account that the group is in. Currently, you use the ID for the Amazon Web Services account that contains your Amazon QuickSight account.</p>', 'ListGroupsRequest$AwsAccountId' => '<p>The ID for the Amazon Web Services account that the group is in. Currently, you use the ID for the Amazon Web Services account that contains your Amazon QuickSight account.</p>', 'ListIAMPolicyAssignmentsForUserRequest$AwsAccountId' => '<p>The ID of the Amazon Web Services account that contains the assignments.</p>', 'ListIAMPolicyAssignmentsRequest$AwsAccountId' => '<p>The ID of the Amazon Web Services account that contains these IAMpolicy assignments.</p>', 'ListIngestionsRequest$AwsAccountId' => '<p>The Amazon Web Services account ID.</p>', 'ListNamespacesRequest$AwsAccountId' => '<p>The ID for the Amazon Web Services account that contains the Amazon QuickSight namespaces that you want to list.</p>', 'ListTemplateAliasesRequest$AwsAccountId' => '<p>The ID of the Amazon Web Services account that contains the template aliases that you\'re listing.</p>', 'ListTemplateVersionsRequest$AwsAccountId' => '<p>The ID of the Amazon Web Services account that contains the templates that you\'re listing.</p>', 'ListTemplatesRequest$AwsAccountId' => '<p>The ID of the Amazon Web Services account that contains the templates that you\'re listing.</p>', 'ListThemeAliasesRequest$AwsAccountId' => '<p>The ID of the Amazon Web Services account that contains the theme aliases that you\'re listing.</p>', 'ListThemeVersionsRequest$AwsAccountId' => '<p>The ID of the Amazon Web Services account that contains the themes that you\'re listing.</p>', 'ListThemesRequest$AwsAccountId' => '<p>The ID of the Amazon Web Services account that contains the themes that you\'re listing.</p>', 'ListUserGroupsRequest$AwsAccountId' => '<p>The Amazon Web Services account ID that the user is in. Currently, you use the ID for the Amazon Web Services account that contains your Amazon QuickSight account.</p>', 'ListUsersRequest$AwsAccountId' => '<p>The ID for the Amazon Web Services account that the user is in. Currently, you use the ID for the Amazon Web Services account that contains your Amazon QuickSight account.</p>', 'RegisterUserRequest$AwsAccountId' => '<p>The ID for the Amazon Web Services account that the user is in. Currently, you use the ID for the Amazon Web Services account that contains your Amazon QuickSight account.</p>', 'RestoreAnalysisRequest$AwsAccountId' => '<p>The ID of the Amazon Web Services account that contains the analysis.</p>', 'SearchAnalysesRequest$AwsAccountId' => '<p>The ID of the Amazon Web Services account that contains the analyses that you\'re searching for.</p>', 'SearchDashboardsRequest$AwsAccountId' => '<p>The ID of the Amazon Web Services account that contains the user whose dashboards you\'re searching for. </p>', 'SearchFoldersRequest$AwsAccountId' => '<p>The AWS account ID.</p>', 'UpdateAccountCustomizationRequest$AwsAccountId' => '<p>The ID for the Amazon Web Services account that you want to update Amazon QuickSight customizations for.</p>', 'UpdateAccountCustomizationResponse$AwsAccountId' => '<p>The ID for the Amazon Web Services account that you want to update Amazon QuickSight customizations for.</p>', 'UpdateAccountSettingsRequest$AwsAccountId' => '<p>The ID for the Amazon Web Services account that contains the Amazon QuickSight settings that you want to list.</p>', 'UpdateAnalysisPermissionsRequest$AwsAccountId' => '<p>The ID of the Amazon Web Services account that contains the analysis whose permissions you\'re updating. You must be using the Amazon Web Services account that the analysis is in.</p>', 'UpdateAnalysisRequest$AwsAccountId' => '<p>The ID of the Amazon Web Services account that contains the analysis that you\'re updating.</p>', 'UpdateDashboardPermissionsRequest$AwsAccountId' => '<p>The ID of the Amazon Web Services account that contains the dashboard whose permissions you\'re updating.</p>', 'UpdateDashboardPublishedVersionRequest$AwsAccountId' => '<p>The ID of the Amazon Web Services account that contains the dashboard that you\'re updating.</p>', 'UpdateDashboardRequest$AwsAccountId' => '<p>The ID of the Amazon Web Services account that contains the dashboard that you\'re updating.</p>', 'UpdateDataSetPermissionsRequest$AwsAccountId' => '<p>The Amazon Web Services account ID.</p>', 'UpdateDataSetRequest$AwsAccountId' => '<p>The Amazon Web Services account ID.</p>', 'UpdateDataSourcePermissionsRequest$AwsAccountId' => '<p>The Amazon Web Services account ID.</p>', 'UpdateDataSourceRequest$AwsAccountId' => '<p>The Amazon Web Services account ID.</p>', 'UpdateFolderPermissionsRequest$AwsAccountId' => '<p>The AWS account ID.</p>', 'UpdateFolderRequest$AwsAccountId' => '<p>The AWS account ID.</p>', 'UpdateGroupRequest$AwsAccountId' => '<p>The ID for the Amazon Web Services account that the group is in. Currently, you use the ID for the Amazon Web Services account that contains your Amazon QuickSight account.</p>', 'UpdateIAMPolicyAssignmentRequest$AwsAccountId' => '<p>The ID of the Amazon Web Services account that contains the IAMpolicy assignment. </p>', 'UpdateTemplateAliasRequest$AwsAccountId' => '<p>The ID of the Amazon Web Services account that contains the template alias that you\'re updating.</p>', 'UpdateTemplatePermissionsRequest$AwsAccountId' => '<p>The ID of the Amazon Web Services account that contains the template.</p>', 'UpdateTemplateRequest$AwsAccountId' => '<p>The ID of the Amazon Web Services account that contains the template that you\'re updating.</p>', 'UpdateThemeAliasRequest$AwsAccountId' => '<p>The ID of the Amazon Web Services account that contains the theme alias that you\'re updating.</p>', 'UpdateThemePermissionsRequest$AwsAccountId' => '<p>The ID of the Amazon Web Services account that contains the theme.</p>', 'UpdateThemeRequest$AwsAccountId' => '<p>The ID of the Amazon Web Services account that contains the theme that you\'re updating.</p>', 'UpdateUserRequest$AwsAccountId' => '<p>The ID for the Amazon Web Services account that the user is in. Currently, you use the ID for the Amazon Web Services account that contains your Amazon QuickSight account.</p>', ], ], 'AwsAndAccountId' => [ 'base' => NULL, 'refs' => [ 'DescribeThemeRequest$AwsAccountId' => '<p>The ID of the Amazon Web Services account that contains the theme that you\'re describing.</p>', ], ], 'AwsIotAnalyticsParameters' => [ 'base' => '<p>The parameters for IoT Analytics.</p>', 'refs' => [ 'DataSourceParameters$AwsIotAnalyticsParameters' => '<p>The parameters for IoT Analytics.</p>', ], ], 'Boolean' => [ 'base' => NULL, 'refs' => [ 'DataSetSummary$RowLevelPermissionTagConfigurationApplied' => '<p>Whether or not the row level permission tags are applied.</p>', 'DataSetSummary$ColumnLevelPermissionRulesApplied' => '<p>A value that indicates if the dataset has column level permission configured.</p>', 'DataSetUsageConfiguration$DisableUseAsDirectQuerySource' => '<p>An option that controls whether a child dataset of a direct query can use this dataset as a source.</p>', 'DataSetUsageConfiguration$DisableUseAsImportedSource' => '<p>An option that controls whether a child dataset that\'s stored in QuickSight can use this dataset as a source.</p>', 'GetDashboardEmbedUrlRequest$UndoRedoDisabled' => '<p>Remove the undo/redo button on the embedded dashboard. The default is FALSE, which enables the undo/redo button.</p>', 'GetDashboardEmbedUrlRequest$ResetDisabled' => '<p>Remove the reset button on the embedded dashboard. The default is FALSE, which enables the reset button.</p>', 'GetDashboardEmbedUrlRequest$StatePersistenceEnabled' => '<p>Adds persistence of state for the user session in an embedded dashboard. Persistence applies to the sheet and the parameter settings. These are control settings that the dashboard subscriber (Amazon QuickSight reader) chooses while viewing the dashboard. If this is set to <code>TRUE</code>, the settings are the same when the subscriber reopens the same dashboard URL. The state is stored in Amazon QuickSight, not in a browser cookie. If this is set to FALSE, the state of the user session is not persisted. The default is <code>FALSE</code>.</p>', 'JoinKeyProperties$UniqueKey' => '<p>A value that indicates that a row in a table is uniquely identified by the columns in a join key. This is used by Amazon QuickSight to optimize query performance.</p>', 'SslProperties$DisableSsl' => '<p>A Boolean option to control whether SSL should be disabled.</p>', 'UpdateUserRequest$UnapplyCustomPermissions' => '<p>A flag that you use to indicate that you want to remove all custom permissions from this user. Using this parameter resets the user to the state it was in before a custom permissions profile was applied. This parameter defaults to NULL and it doesn\'t accept any other value.</p>', 'UploadSettings$ContainsHeader' => '<p>Whether the file has a header row, or the files each have a header row.</p>', 'User$Active' => '<p>The active status of user. When you create an Amazon QuickSight user that’s not an IAM user or an Active Directory user, that user is inactive until they sign in and provide a password.</p>', ], ], 'BorderStyle' => [ 'base' => '<p>The display options for tile borders for visuals.</p>', 'refs' => [ 'TileStyle$Border' => '<p>The border around a tile.</p>', ], ], 'CalculatedColumn' => [ 'base' => '<p>A calculated column for a dataset.</p>', 'refs' => [ 'CalculatedColumnList$member' => NULL, ], ], 'CalculatedColumnList' => [ 'base' => NULL, 'refs' => [ 'CreateColumnsOperation$Columns' => '<p>Calculated columns to create.</p>', ], ], 'CancelIngestionRequest' => [ 'base' => NULL, 'refs' => [], ], 'CancelIngestionResponse' => [ 'base' => NULL, 'refs' => [], ], 'CastColumnTypeOperation' => [ 'base' => '<p>A transform operation that casts a column to a different type.</p>', 'refs' => [ 'TransformOperation$CastColumnTypeOperation' => '<p>A transform operation that casts a column to a different type.</p>', ], ], 'Catalog' => [ 'base' => NULL, 'refs' => [ 'PrestoParameters$Catalog' => '<p>Catalog.</p>', ], ], 'ClusterId' => [ 'base' => NULL, 'refs' => [ 'RedshiftParameters$ClusterId' => '<p>Cluster ID. This field can be blank if the <code>Host</code> and <code>Port</code> are provided.</p>', ], ], 'ColorList' => [ 'base' => NULL, 'refs' => [ 'DataColorPalette$Colors' => '<p>The hexadecimal codes for the colors.</p>', 'DataColorPalette$MinMaxGradient' => '<p>The minimum and maximum hexadecimal codes that describe a color gradient. </p>', ], ], 'ColumnDataType' => [ 'base' => NULL, 'refs' => [ 'CastColumnTypeOperation$NewColumnType' => '<p>New column data type.</p>', 'OutputColumn$Type' => '<p>Type.</p>', ], ], 'ColumnDescription' => [ 'base' => '<p>Metadata that contains a description for a column.</p>', 'refs' => [ 'ColumnTag$ColumnDescription' => '<p>A description for a column.</p>', ], ], 'ColumnDescriptiveText' => [ 'base' => NULL, 'refs' => [ 'ColumnDescription$Text' => '<p>The text of a description for a column.</p>', 'OutputColumn$Description' => '<p>A description for a column.</p>', ], ], 'ColumnGroup' => [ 'base' => '<p>Groupings of columns that work together in certain Amazon QuickSight features. This is a variant type structure. For this structure to be valid, only one of the attributes can be non-null.</p>', 'refs' => [ 'ColumnGroupList$member' => NULL, ], ], 'ColumnGroupColumnSchema' => [ 'base' => '<p>A structure describing the name, data type, and geographic role of the columns.</p>', 'refs' => [ 'ColumnGroupColumnSchemaList$member' => NULL, ], ], 'ColumnGroupColumnSchemaList' => [ 'base' => NULL, 'refs' => [ 'ColumnGroupSchema$ColumnGroupColumnSchemaList' => '<p>A structure containing the list of schemas for column group columns.</p>', ], ], 'ColumnGroupList' => [ 'base' => NULL, 'refs' => [ 'CreateDataSetRequest$ColumnGroups' => '<p>Groupings of columns that work together in certain Amazon QuickSight features. Currently, only geospatial hierarchy is supported.</p>', 'DataSet$ColumnGroups' => '<p>Groupings of columns that work together in certain Amazon QuickSight features. Currently, only geospatial hierarchy is supported.</p>', 'UpdateDataSetRequest$ColumnGroups' => '<p>Groupings of columns that work together in certain Amazon QuickSight features. Currently, only geospatial hierarchy is supported.</p>', ], ], 'ColumnGroupName' => [ 'base' => NULL, 'refs' => [ 'GeoSpatialColumnGroup$Name' => '<p>A display name for the hierarchy.</p>', ], ], 'ColumnGroupSchema' => [ 'base' => '<p>The column group schema.</p>', 'refs' => [ 'ColumnGroupSchemaList$member' => NULL, ], ], 'ColumnGroupSchemaList' => [ 'base' => NULL, 'refs' => [ 'DataSetConfiguration$ColumnGroupSchemaList' => '<p>A structure containing the list of column group schemas.</p>', ], ], 'ColumnId' => [ 'base' => NULL, 'refs' => [ 'CalculatedColumn$ColumnId' => '<p>A unique ID to identify a calculated column. During a dataset update, if the column ID of a calculated column matches that of an existing calculated column, Amazon QuickSight preserves the existing calculated column.</p>', ], ], 'ColumnLevelPermissionRule' => [ 'base' => '<p>A rule defined to grant access on one or more restricted columns. Each dataset can have multiple rules. To create a restricted column, you add it to one or more rules. Each rule must contain at least one column and at least one user or group. To be able to see a restricted column, a user or group needs to be added to a rule for that column.</p>', 'refs' => [ 'ColumnLevelPermissionRuleList$member' => NULL, ], ], 'ColumnLevelPermissionRuleList' => [ 'base' => NULL, 'refs' => [ 'CreateDataSetRequest$ColumnLevelPermissionRules' => '<p>A set of one or more definitions of a <code> <a>ColumnLevelPermissionRule</a> </code>.</p>', 'DataSet$ColumnLevelPermissionRules' => '<p>A set of one or more definitions of a <code> <a>ColumnLevelPermissionRule</a> </code>.</p>', 'UpdateDataSetRequest$ColumnLevelPermissionRules' => '<p>A set of one or more definitions of a <code> <a>ColumnLevelPermissionRule</a> </code>.</p>', ], ], 'ColumnList' => [ 'base' => NULL, 'refs' => [ 'GeoSpatialColumnGroup$Columns' => '<p>Columns in this hierarchy.</p>', ], ], 'ColumnName' => [ 'base' => NULL, 'refs' => [ 'CalculatedColumn$ColumnName' => '<p>Column name.</p>', 'CastColumnTypeOperation$ColumnName' => '<p>Column name.</p>', 'ColumnList$member' => NULL, 'InputColumn$Name' => '<p>The name of this column in the underlying data source.</p>', 'OutputColumn$Name' => '<p>A display name for the dataset.</p>', 'RenameColumnOperation$ColumnName' => '<p>The name of the column to be renamed.</p>', 'RenameColumnOperation$NewColumnName' => '<p>The new name for the column.</p>', 'TagColumnOperation$ColumnName' => '<p>The column that this operation acts on.</p>', 'UntagColumnOperation$ColumnName' => '<p>The column that this operation acts on.</p>', ], ], 'ColumnNameList' => [ 'base' => NULL, 'refs' => [ 'ColumnLevelPermissionRule$ColumnNames' => '<p>An array of column names.</p>', ], ], 'ColumnSchema' => [ 'base' => '<p>The column schema.</p>', 'refs' => [ 'ColumnSchemaList$member' => NULL, ], ], 'ColumnSchemaList' => [ 'base' => NULL, 'refs' => [ 'DataSetSchema$ColumnSchemaList' => '<p>A structure containing the list of column schemas.</p>', ], ], 'ColumnTag' => [ 'base' => '<p>A tag for a column in a <a>TagColumnOperation</a> structure. This is a variant type structure. For this structure to be valid, only one of the attributes can be non-null.</p>', 'refs' => [ 'ColumnTagList$member' => NULL, ], ], 'ColumnTagList' => [ 'base' => NULL, 'refs' => [ 'TagColumnOperation$Tags' => '<p>The dataset column tag, currently only used for geospatial type tagging.</p> <note> <p>This is not tags for the Amazon Web Services tagging feature.</p> </note>', ], ], 'ColumnTagName' => [ 'base' => NULL, 'refs' => [ 'ColumnTagNames$member' => NULL, ], ], 'ColumnTagNames' => [ 'base' => NULL, 'refs' => [ 'UntagColumnOperation$TagNames' => '<p>The column tags to remove from this column.</p>', ], ], 'ConcurrentUpdatingException' => [ 'base' => '<p>A resource is already in a state that indicates an operation is happening that must complete before a new update can be applied.</p>', 'refs' => [], ], 'ConflictException' => [ 'base' => '<p>Updating or deleting a resource can cause an inconsistent state.</p>', 'refs' => [], ], 'CopySourceArn' => [ 'base' => NULL, 'refs' => [ 'DataSourceCredentials$CopySourceArn' => '<p>The Amazon Resource Name (ARN) of a data source that has the credential pair that you want to use. When <code>CopySourceArn</code> is not null, the credential pair from the data source in the ARN is used as the credentials for the <code>DataSourceCredentials</code> structure.</p>', ], ], 'CreateAccountCustomizationRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateAccountCustomizationResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateAnalysisRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateAnalysisResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateColumnsOperation' => [ 'base' => '<p>A transform operation that creates calculated columns. Columns created in one such operation form a lexical closure.</p>', 'refs' => [ 'TransformOperation$CreateColumnsOperation' => '<p>An operation that creates calculated columns. Columns created in one such operation form a lexical closure.</p>', ], ], 'CreateDashboardRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateDashboardResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateDataSetRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateDataSetResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateDataSourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateDataSourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateFolderMembershipRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateFolderMembershipResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateFolderRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateFolderResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateGroupMembershipRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateGroupMembershipResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateGroupRequest' => [ 'base' => '<p>The request object for this operation. </p>', 'refs' => [], ], 'CreateGroupResponse' => [ 'base' => '<p>The response object for this operation.</p>', 'refs' => [], ], 'CreateIAMPolicyAssignmentRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateIAMPolicyAssignmentResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateIngestionRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateIngestionResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateNamespaceRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateNamespaceResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateTemplateAliasRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateTemplateAliasResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateTemplateRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateTemplateResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateThemeAliasRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateThemeAliasResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateThemeRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateThemeResponse' => [ 'base' => NULL, 'refs' => [], ], 'CredentialPair' => [ 'base' => '<p>The combination of user name and password that are used as credentials.</p>', 'refs' => [ 'DataSourceCredentials$CredentialPair' => '<p>Credential pair. For more information, see <a>CredentialPair</a>.</p>', ], ], 'CustomSql' => [ 'base' => '<p>A physical table type built from the results of the custom SQL query.</p>', 'refs' => [ 'PhysicalTable$CustomSql' => '<p>A physical table type built from the results of the custom SQL query.</p>', ], ], 'CustomSqlName' => [ 'base' => NULL, 'refs' => [ 'CustomSql$Name' => '<p>A display name for the SQL query result.</p>', ], ], 'Dashboard' => [ 'base' => '<p>Dashboard.</p>', 'refs' => [ 'DescribeDashboardResponse$Dashboard' => '<p>Information about the dashboard.</p>', ], ], 'DashboardBehavior' => [ 'base' => NULL, 'refs' => [ 'AdHocFilteringOption$AvailabilityStatus' => '<p>Availability status.</p>', 'ExportToCSVOption$AvailabilityStatus' => '<p>Availability status.</p>', ], ], 'DashboardError' => [ 'base' => '<p>Dashboard error.</p>', 'refs' => [ 'DashboardErrorList$member' => NULL, ], ], 'DashboardErrorList' => [ 'base' => NULL, 'refs' => [ 'DashboardVersion$Errors' => '<p>Errors associated with this dashboard version.</p>', ], ], 'DashboardErrorType' => [ 'base' => NULL, 'refs' => [ 'DashboardError$Type' => '<p>Type.</p>', ], ], 'DashboardFilterAttribute' => [ 'base' => NULL, 'refs' => [ 'DashboardSearchFilter$Name' => '<p>The name of the value that you want to use as a filter, for example, <code>"Name": "QUICKSIGHT_USER"</code>. </p>', ], ], 'DashboardName' => [ 'base' => NULL, 'refs' => [ 'CreateDashboardRequest$Name' => '<p>The display name of the dashboard.</p>', 'Dashboard$Name' => '<p>A display name for the dashboard.</p>', 'DashboardSummary$Name' => '<p>A display name for the dashboard.</p>', 'UpdateDashboardRequest$Name' => '<p>The display name of the dashboard.</p>', ], ], 'DashboardPublishOptions' => [ 'base' => '<p>Dashboard publish options.</p>', 'refs' => [ 'CreateDashboardRequest$DashboardPublishOptions' => '<p>Options for publishing the dashboard when you create it:</p> <ul> <li> <p> <code>AvailabilityStatus</code> for <code>AdHocFilteringOption</code> - This status can be either <code>ENABLED</code> or <code>DISABLED</code>. When this is set to <code>DISABLED</code>, Amazon QuickSight disables the left filter pane on the published dashboard, which can be used for ad hoc (one-time) filtering. This option is <code>ENABLED</code> by default. </p> </li> <li> <p> <code>AvailabilityStatus</code> for <code>ExportToCSVOption</code> - This status can be either <code>ENABLED</code> or <code>DISABLED</code>. The visual option to export data to .CSV format isn\'t enabled when this is set to <code>DISABLED</code>. This option is <code>ENABLED</code> by default. </p> </li> <li> <p> <code>VisibilityState</code> for <code>SheetControlsOption</code> - This visibility state can be either <code>COLLAPSED</code> or <code>EXPANDED</code>. This option is <code>COLLAPSED</code> by default. </p> </li> </ul>', 'UpdateDashboardRequest$DashboardPublishOptions' => '<p>Options for publishing the dashboard when you create it:</p> <ul> <li> <p> <code>AvailabilityStatus</code> for <code>AdHocFilteringOption</code> - This status can be either <code>ENABLED</code> or <code>DISABLED</code>. When this is set to <code>DISABLED</code>, Amazon QuickSight disables the left filter pane on the published dashboard, which can be used for ad hoc (one-time) filtering. This option is <code>ENABLED</code> by default. </p> </li> <li> <p> <code>AvailabilityStatus</code> for <code>ExportToCSVOption</code> - This status can be either <code>ENABLED</code> or <code>DISABLED</code>. The visual option to export data to .CSV format isn\'t enabled when this is set to <code>DISABLED</code>. This option is <code>ENABLED</code> by default. </p> </li> <li> <p> <code>VisibilityState</code> for <code>SheetControlsOption</code> - This visibility state can be either <code>COLLAPSED</code> or <code>EXPANDED</code>. This option is <code>COLLAPSED</code> by default. </p> </li> </ul>', ], ], 'DashboardSearchFilter' => [ 'base' => '<p>A filter that you apply when searching for dashboards. </p>', 'refs' => [ 'DashboardSearchFilterList$member' => NULL, ], ], 'DashboardSearchFilterList' => [ 'base' => NULL, 'refs' => [ 'SearchDashboardsRequest$Filters' => '<p>The filters to apply to the search. Currently, you can search only by user name, for example, <code>"Filters": [ { "Name": "QUICKSIGHT_USER", "Operator": "StringEquals", "Value": "arn:aws:quicksight:us-east-1:1:user/default/UserName1" } ]</code> </p>', ], ], 'DashboardSourceEntity' => [ 'base' => '<p>Dashboard source entity.</p>', 'refs' => [ 'CreateDashboardRequest$SourceEntity' => '<p>The entity that you are using as a source when you create the dashboard. In <code>SourceEntity</code>, you specify the type of object you\'re using as source. You can only create a dashboard from a template, so you use a <code>SourceTemplate</code> entity. If you need to create a dashboard from an analysis, first convert the analysis to a template by using the <a>CreateTemplate</a> API operation. For <code>SourceTemplate</code>, specify the Amazon Resource Name (ARN) of the source template. The <code>SourceTemplate</code>ARN can contain any Amazon Web Services account and any Amazon QuickSight-supported Amazon Web Services Region;. </p> <p>Use the <code>DataSetReferences</code> entity within <code>SourceTemplate</code> to list the replacement datasets for the placeholders listed in the original. The schema in each dataset must match its placeholder. </p>', 'UpdateDashboardRequest$SourceEntity' => '<p>The entity that you are using as a source when you update the dashboard. In <code>SourceEntity</code>, you specify the type of object you\'re using as source. You can only update a dashboard from a template, so you use a <code>SourceTemplate</code> entity. If you need to update a dashboard from an analysis, first convert the analysis to a template by using the <a>CreateTemplate</a> API operation. For <code>SourceTemplate</code>, specify the Amazon Resource Name (ARN) of the source template. The <code>SourceTemplate</code> ARN can contain any Amazon Web Services account and any Amazon QuickSight-supported Amazon Web Services Region;. </p> <p>Use the <code>DataSetReferences</code> entity within <code>SourceTemplate</code> to list the replacement datasets for the placeholders listed in the original. The schema in each dataset must match its placeholder. </p>', ], ], 'DashboardSourceTemplate' => [ 'base' => '<p>Dashboard source template.</p>', 'refs' => [ 'DashboardSourceEntity$SourceTemplate' => '<p>Source template.</p>', ], ], 'DashboardSummary' => [ 'base' => '<p>Dashboard summary.</p>', 'refs' => [ 'DashboardSummaryList$member' => NULL, ], ], 'DashboardSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListDashboardsResponse$DashboardSummaryList' => '<p>A structure that contains all of the dashboards in your Amazon Web Services account. This structure provides basic information about the dashboards.</p>', 'SearchDashboardsResponse$DashboardSummaryList' => '<p>The list of dashboards owned by the user specified in <code>Filters</code> in your request.</p>', ], ], 'DashboardUIState' => [ 'base' => NULL, 'refs' => [ 'SheetControlsOption$VisibilityState' => '<p>Visibility state.</p>', ], ], 'DashboardVersion' => [ 'base' => '<p>Dashboard version.</p>', 'refs' => [ 'Dashboard$Version' => '<p>Version.</p>', ], ], 'DashboardVersionSummary' => [ 'base' => '<p>Dashboard version summary.</p>', 'refs' => [ 'DashboardVersionSummaryList$member' => NULL, ], ], 'DashboardVersionSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListDashboardVersionsResponse$DashboardVersionSummaryList' => '<p>A structure that contains information about each version of the dashboard.</p>', ], ], 'DataColorPalette' => [ 'base' => '<p>The theme colors that are used for data colors in charts. The colors description is a hexadecimal color code that consists of six alphanumerical characters, prefixed with <code>#</code>, for example #37BFF5. </p>', 'refs' => [ 'ThemeConfiguration$DataColorPalette' => '<p>Color properties that apply to chart data colors.</p>', ], ], 'DataSet' => [ 'base' => '<p>Dataset.</p>', 'refs' => [ 'DescribeDataSetResponse$DataSet' => '<p>Information on the dataset.</p>', ], ], 'DataSetArnsList' => [ 'base' => NULL, 'refs' => [ 'Analysis$DataSetArns' => '<p>The ARNs of the datasets of the analysis.</p>', 'DashboardVersion$DataSetArns' => '<p>The Amazon Resource Numbers (ARNs) for the datasets that are associated with this version of the dashboard.</p>', ], ], 'DataSetConfiguration' => [ 'base' => '<p>Dataset configuration.</p>', 'refs' => [ 'DataSetConfigurationList$member' => NULL, ], ], 'DataSetConfigurationList' => [ 'base' => NULL, 'refs' => [ 'TemplateVersion$DataSetConfigurations' => '<p>Schema of the dataset identified by the placeholder. Any dashboard created from this template should be bound to new datasets matching the same schema described through this API operation.</p>', ], ], 'DataSetImportMode' => [ 'base' => NULL, 'refs' => [ 'CreateDataSetRequest$ImportMode' => '<p>Indicates whether you want to import the data into SPICE.</p>', 'DataSet$ImportMode' => '<p>A value that indicates whether you want to import the data into SPICE.</p>', 'DataSetSummary$ImportMode' => '<p>A value that indicates whether you want to import the data into SPICE.</p>', 'UpdateDataSetRequest$ImportMode' => '<p>Indicates whether you want to import the data into SPICE.</p>', ], ], 'DataSetName' => [ 'base' => NULL, 'refs' => [ 'AwsIotAnalyticsParameters$DataSetName' => '<p>Dataset name.</p>', ], ], 'DataSetReference' => [ 'base' => '<p>Dataset reference.</p>', 'refs' => [ 'DataSetReferenceList$member' => NULL, ], ], 'DataSetReferenceList' => [ 'base' => NULL, 'refs' => [ 'AnalysisSourceTemplate$DataSetReferences' => '<p>The dataset references of the source template of an analysis.</p>', 'DashboardSourceTemplate$DataSetReferences' => '<p>Dataset references.</p>', 'TemplateSourceAnalysis$DataSetReferences' => '<p>A structure containing information about the dataset references used as placeholders in the template.</p>', ], ], 'DataSetSchema' => [ 'base' => '<p>Dataset schema.</p>', 'refs' => [ 'DataSetConfiguration$DataSetSchema' => '<p>Dataset schema.</p>', ], ], 'DataSetSummary' => [ 'base' => '<p>Dataset summary.</p>', 'refs' => [ 'DataSetSummaryList$member' => NULL, ], ], 'DataSetSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListDataSetsResponse$DataSetSummaries' => '<p>The list of dataset summaries.</p>', ], ], 'DataSetUsageConfiguration' => [ 'base' => '<p>The usage configuration to apply to child datasets that reference this dataset as a source.</p>', 'refs' => [ 'CreateDataSetRequest$DataSetUsageConfiguration' => NULL, 'DataSet$DataSetUsageConfiguration' => '<p>The usage configuration to apply to child datasets that reference this dataset as a source.</p>', 'UpdateDataSetRequest$DataSetUsageConfiguration' => NULL, ], ], 'DataSource' => [ 'base' => '<p>The structure of a data source.</p>', 'refs' => [ 'DataSourceList$member' => NULL, 'DescribeDataSourceResponse$DataSource' => '<p>The information on the data source.</p>', ], ], 'DataSourceCredentials' => [ 'base' => '<p>Data source credentials. This is a variant type structure. For this structure to be valid, only one of the attributes can be non-null.</p>', 'refs' => [ 'CreateDataSourceRequest$Credentials' => '<p>The credentials Amazon QuickSight that uses to connect to your underlying source. Currently, only credentials based on user name and password are supported.</p>', 'UpdateDataSourceRequest$Credentials' => '<p>The credentials that Amazon QuickSight that uses to connect to your underlying source. Currently, only credentials based on user name and password are supported.</p>', ], ], 'DataSourceErrorInfo' => [ 'base' => '<p>Error information for the data source creation or update.</p>', 'refs' => [ 'DataSource$ErrorInfo' => '<p>Error information from the last update or the creation of the data source.</p>', ], ], 'DataSourceErrorInfoType' => [ 'base' => NULL, 'refs' => [ 'DataSourceErrorInfo$Type' => '<p>Error type.</p>', ], ], 'DataSourceList' => [ 'base' => NULL, 'refs' => [ 'ListDataSourcesResponse$DataSources' => '<p>A list of data sources.</p>', ], ], 'DataSourceParameters' => [ 'base' => '<p>The parameters that Amazon QuickSight uses to connect to your underlying data source. This is a variant type structure. For this structure to be valid, only one of the attributes can be non-null.</p>', 'refs' => [ 'CreateDataSourceRequest$DataSourceParameters' => '<p>The parameters that Amazon QuickSight uses to connect to your underlying source.</p>', 'DataSource$DataSourceParameters' => '<p>The parameters that Amazon QuickSight uses to connect to your underlying source. This is a variant type structure. For this structure to be valid, only one of the attributes can be non-null.</p>', 'DataSourceParametersList$member' => NULL, 'UpdateDataSourceRequest$DataSourceParameters' => '<p>The parameters that Amazon QuickSight uses to connect to your underlying source.</p>', ], ], 'DataSourceParametersList' => [ 'base' => NULL, 'refs' => [ 'CredentialPair$AlternateDataSourceParameters' => '<p>A set of alternate data source parameters that you want to share for these credentials. The credentials are applied in tandem with the data source parameters when you copy a data source by using a create or update request. The API operation compares the <code>DataSourceParameters</code> structure that\'s in the request with the structures in the <code>AlternateDataSourceParameters</code> allow list. If the structures are an exact match, the request is allowed to use the new data source with the existing credentials. If the <code>AlternateDataSourceParameters</code> list is null, the <code>DataSourceParameters</code> originally used with these <code>Credentials</code> is automatically allowed.</p>', 'DataSource$AlternateDataSourceParameters' => '<p>A set of alternate data source parameters that you want to share for the credentials stored with this data source. The credentials are applied in tandem with the data source parameters when you copy a data source by using a create or update request. The API operation compares the <code>DataSourceParameters</code> structure that\'s in the request with the structures in the <code>AlternateDataSourceParameters</code> allow list. If the structures are an exact match, the request is allowed to use the credentials from this existing data source. If the <code>AlternateDataSourceParameters</code> list is null, the <code>Credentials</code> originally used with this <code>DataSourceParameters</code> are automatically allowed.</p>', ], ], 'DataSourceType' => [ 'base' => NULL, 'refs' => [ 'CreateDataSourceRequest$Type' => '<p>The type of the data source. To return a list of all data sources, use <code>ListDataSources</code>.</p> <p>Use <code>AMAZON_ELASTICSEARCH</code> for Amazon Elasticsearch Service.</p>', 'DataSource$Type' => '<p>The type of the data source. This type indicates which database engine the data source connects to.</p>', ], ], 'Database' => [ 'base' => NULL, 'refs' => [ 'AuroraParameters$Database' => '<p>Database.</p>', 'AuroraPostgreSqlParameters$Database' => '<p>The Amazon Aurora PostgreSQL database to connect to.</p>', 'MariaDbParameters$Database' => '<p>Database.</p>', 'MySqlParameters$Database' => '<p>Database.</p>', 'OracleParameters$Database' => '<p>Database.</p>', 'PostgreSqlParameters$Database' => '<p>Database.</p>', 'RdsParameters$Database' => '<p>Database.</p>', 'RedshiftParameters$Database' => '<p>Database.</p>', 'SnowflakeParameters$Database' => '<p>Database.</p>', 'SqlServerParameters$Database' => '<p>Database.</p>', 'TeradataParameters$Database' => '<p>Database.</p>', ], ], 'DateTimeParameter' => [ 'base' => '<p>A date-time parameter.</p>', 'refs' => [ 'DateTimeParameterList$member' => NULL, ], ], 'DateTimeParameterList' => [ 'base' => NULL, 'refs' => [ 'Parameters$DateTimeParameters' => '<p>The parameters that have a data type of date-time.</p>', ], ], 'DecimalParameter' => [ 'base' => '<p>A decimal parameter.</p>', 'refs' => [ 'DecimalParameterList$member' => NULL, ], ], 'DecimalParameterList' => [ 'base' => NULL, 'refs' => [ 'Parameters$DecimalParameters' => '<p>The parameters that have a data type of decimal.</p>', ], ], 'DeleteAccountCustomizationRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteAccountCustomizationResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteAnalysisRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteAnalysisResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteDashboardRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteDashboardResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteDataSetRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteDataSetResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteDataSourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteDataSourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteFolderMembershipRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteFolderMembershipResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteFolderRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteFolderResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteGroupMembershipRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteGroupMembershipResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteGroupResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteIAMPolicyAssignmentRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteIAMPolicyAssignmentResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteNamespaceRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteNamespaceResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteTemplateAliasRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteTemplateAliasResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteTemplateRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteTemplateResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteThemeAliasRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteThemeAliasResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteThemeRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteThemeResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteUserByPrincipalIdRequest' => [ 'base' => '<p/>', 'refs' => [], ], 'DeleteUserByPrincipalIdResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteUserRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteUserResponse' => [ 'base' => NULL, 'refs' => [], ], 'Delimiter' => [ 'base' => NULL, 'refs' => [ 'UploadSettings$Delimiter' => '<p>The delimiter between values in the file.</p>', ], ], 'DescribeAccountCustomizationRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAccountCustomizationResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAccountSettingsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAccountSettingsResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAnalysisPermissionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAnalysisPermissionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAnalysisRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAnalysisResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeDashboardPermissionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeDashboardPermissionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeDashboardRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeDashboardResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeDataSetPermissionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeDataSetPermissionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeDataSetRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeDataSetResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeDataSourcePermissionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeDataSourcePermissionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeDataSourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeDataSourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeFolderPermissionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeFolderPermissionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeFolderRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeFolderResolvedPermissionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeFolderResolvedPermissionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeFolderResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeGroupResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeIAMPolicyAssignmentRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeIAMPolicyAssignmentResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeIngestionRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeIngestionResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeNamespaceRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeNamespaceResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeTemplateAliasRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeTemplateAliasResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeTemplatePermissionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeTemplatePermissionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeTemplateRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeTemplateResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeThemeAliasRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeThemeAliasResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeThemePermissionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeThemePermissionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeThemeRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeThemeResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeUserRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeUserResponse' => [ 'base' => NULL, 'refs' => [], ], 'Domain' => [ 'base' => NULL, 'refs' => [ 'AmazonElasticsearchParameters$Domain' => '<p>The Elasticsearch domain.</p>', 'AmazonOpenSearchParameters$Domain' => NULL, ], ], 'DomainNotWhitelistedException' => [ 'base' => '<p>The domain specified isn\'t on the allow list. All domains for embedded dashboards must be added to the approved list by an Amazon QuickSight admin.</p>', 'refs' => [], ], 'Double' => [ 'base' => NULL, 'refs' => [ 'DoubleList$member' => NULL, ], ], 'DoubleList' => [ 'base' => NULL, 'refs' => [ 'DecimalParameter$Values' => '<p>The values for the decimal parameter.</p>', ], ], 'Edition' => [ 'base' => NULL, 'refs' => [ 'AccountSettings$Edition' => '<p>The edition of Amazon QuickSight that you\'re currently subscribed to: Enterprise edition or Standard edition.</p>', ], ], 'EmbeddingIdentityType' => [ 'base' => NULL, 'refs' => [ 'GetDashboardEmbedUrlRequest$IdentityType' => '<p>The authentication method that the user uses to sign in.</p>', ], ], 'EmbeddingUrl' => [ 'base' => NULL, 'refs' => [ 'GenerateEmbedUrlForAnonymousUserResponse$EmbedUrl' => '<p>The embed URL for the dashboard.</p>', 'GenerateEmbedUrlForRegisteredUserResponse$EmbedUrl' => '<p>The embed URL for the Amazon QuickSight dashboard or console.</p>', 'GetDashboardEmbedUrlResponse$EmbedUrl' => '<p>A single-use URL that you can put into your server-side webpage to embed your dashboard. This URL is valid for 5 minutes. The API operation provides the URL with an <code>auth_code</code> value that enables one (and only one) sign-on to a user session that is valid for 10 hours. </p>', 'GetSessionEmbedUrlResponse$EmbedUrl' => '<p>A single-use URL that you can put into your server-side web page to embed your Amazon QuickSight session. This URL is valid for 5 minutes. The API operation provides the URL with an <code>auth_code</code> value that enables one (and only one) sign-on to a user session that is valid for 10 hours. </p>', ], ], 'EntryPath' => [ 'base' => NULL, 'refs' => [ 'RegisteredUserQuickSightConsoleEmbeddingConfiguration$InitialPath' => '<p>The initial URL path for the Amazon QuickSight console. <code>InitialPath</code> is required.</p> <p>The entry point URL is constrained to the following paths:</p> <ul> <li> <p> <code>/start</code> </p> </li> <li> <p> <code>/start/analyses</code> </p> </li> <li> <p> <code>/start/dashboards</code> </p> </li> <li> <p> <code>/start/favorites</code> </p> </li> <li> <p> <code>/dashboards/DashboardId</code>. <i>DashboardId</i> is the actual ID key from the Amazon QuickSight console URL of the dashboard.</p> </li> <li> <p> <code>/analyses/AnalysisId</code>. <i>AnalysisId</i> is the actual ID key from the Amazon QuickSight console URL of the analysis.</p> </li> </ul>', ], ], 'EntryPoint' => [ 'base' => NULL, 'refs' => [ 'GetSessionEmbedUrlRequest$EntryPoint' => '<p>The URL you use to access the embedded session. The entry point URL is constrained to the following paths:</p> <ul> <li> <p> <code>/start</code> </p> </li> <li> <p> <code>/start/analyses</code> </p> </li> <li> <p> <code>/start/dashboards</code> </p> </li> <li> <p> <code>/start/favorites</code> </p> </li> <li> <p> <code>/dashboards/<i>DashboardId</i> </code> - where <code>DashboardId</code> is the actual ID key from the Amazon QuickSight console URL of the dashboard</p> </li> <li> <p> <code>/analyses/<i>AnalysisId</i> </code> - where <code>AnalysisId</code> is the actual ID key from the Amazon QuickSight console URL of the analysis</p> </li> </ul>', ], ], 'ErrorInfo' => [ 'base' => '<p>Error information for the SPICE ingestion of a dataset.</p>', 'refs' => [ 'Ingestion$ErrorInfo' => '<p>Error information for this ingestion.</p>', ], ], 'ExceptionResourceType' => [ 'base' => NULL, 'refs' => [ 'LimitExceededException$ResourceType' => '<p>Limit exceeded.</p>', 'ResourceExistsException$ResourceType' => '<p>The resource type for this request.</p>', 'ResourceNotFoundException$ResourceType' => '<p>The resource type for this request.</p>', 'ResourceUnavailableException$ResourceType' => '<p>The resource type for this request.</p>', ], ], 'ExportToCSVOption' => [ 'base' => '<p>Export to .csv option.</p>', 'refs' => [ 'DashboardPublishOptions$ExportToCSVOption' => '<p>Export to .csv option.</p>', ], ], 'Expression' => [ 'base' => NULL, 'refs' => [ 'CalculatedColumn$Expression' => '<p>An expression that defines the calculated column.</p>', 'FilterOperation$ConditionExpression' => '<p>An expression that must evaluate to a Boolean value. Rows for which the expression evaluates to true are kept in the dataset.</p>', ], ], 'FieldFolder' => [ 'base' => '<p>A FieldFolder element is a folder that contains fields and nested subfolders.</p>', 'refs' => [ 'FieldFolderMap$value' => NULL, ], ], 'FieldFolderDescription' => [ 'base' => NULL, 'refs' => [ 'FieldFolder$description' => '<p>The description for a field folder.</p>', ], ], 'FieldFolderMap' => [ 'base' => NULL, 'refs' => [ 'CreateDataSetRequest$FieldFolders' => '<p>The folder that contains fields and nested subfolders for your dataset.</p>', 'DataSet$FieldFolders' => '<p>The folder that contains fields and nested subfolders for your dataset.</p>', 'UpdateDataSetRequest$FieldFolders' => '<p>The folder that contains fields and nested subfolders for your dataset.</p>', ], ], 'FieldFolderPath' => [ 'base' => NULL, 'refs' => [ 'FieldFolderMap$key' => NULL, ], ], 'FileFormat' => [ 'base' => NULL, 'refs' => [ 'UploadSettings$Format' => '<p>File format.</p>', ], ], 'FilterOperation' => [ 'base' => '<p>A transform operation that filters rows based on a condition.</p>', 'refs' => [ 'TransformOperation$FilterOperation' => '<p>An operation that filters rows based on some condition.</p>', ], ], 'FilterOperator' => [ 'base' => NULL, 'refs' => [ 'AnalysisSearchFilter$Operator' => '<p>The comparison operator that you want to use as a filter, for example <code>"Operator": "StringEquals"</code>.</p>', 'DashboardSearchFilter$Operator' => '<p>The comparison operator that you want to use as a filter, for example, <code>"Operator": "StringEquals"</code>.</p>', 'FolderSearchFilter$Operator' => '<p>The comparison operator that you want to use as a filter. For example, <code>"Operator": "StringEquals"</code>.</p>', ], ], 'Folder' => [ 'base' => '<p>A folder.</p>', 'refs' => [ 'DescribeFolderResponse$Folder' => '<p>Information about the folder.</p>', ], ], 'FolderColumnList' => [ 'base' => NULL, 'refs' => [ 'FieldFolder$columns' => '<p>A folder has a list of columns. A column can only be in one folder.</p>', ], ], 'FolderFilterAttribute' => [ 'base' => NULL, 'refs' => [ 'FolderSearchFilter$Name' => '<p>The name of the value that you want to use as a filter. For example, <code>"Name": "PARENT_FOLDER_ARN"</code>.</p>', ], ], 'FolderMember' => [ 'base' => '<p>An asset in a folder, such as a dashboard, analysis, or dataset.</p>', 'refs' => [ 'CreateFolderMembershipResponse$FolderMember' => '<p>Information about the member in the folder.</p>', ], ], 'FolderMemberList' => [ 'base' => NULL, 'refs' => [ 'ListFolderMembersResponse$FolderMemberList' => '<p>A structure that contains all of the folder members (dashboards, analyses, and datasets) in the folder.</p>', ], ], 'FolderName' => [ 'base' => NULL, 'refs' => [ 'CreateFolderRequest$Name' => '<p>The name of the folder.</p>', 'Folder$Name' => '<p>A display name for the folder.</p>', 'FolderSummary$Name' => '<p>The display name of the folder.</p>', 'UpdateFolderRequest$Name' => '<p>The name of the folder.</p>', ], ], 'FolderSearchFilter' => [ 'base' => '<p>Searches a folder by a filter.</p>', 'refs' => [ 'FolderSearchFilterList$member' => NULL, ], ], 'FolderSearchFilterList' => [ 'base' => NULL, 'refs' => [ 'SearchFoldersRequest$Filters' => '<p>The filters to apply to the search. Currently, you can search only by the parent folder ARN. For example, <code>"Filters": [ { "Name": "PARENT_FOLDER_ARN", "Operator": "StringEquals", "Value": "arn:aws:quicksight:us-east-1:1:folder/folderId" } ]</code>.</p>', ], ], 'FolderSummary' => [ 'base' => '<p>A summary of the folder. </p>', 'refs' => [ 'FolderSummaryList$member' => NULL, ], ], 'FolderSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListFoldersResponse$FolderSummaryList' => '<p>A structure that contains all of the folders in your AWS account. This structure provides basic information about the folders.</p>', 'SearchFoldersResponse$FolderSummaryList' => '<p>A structure that contains all of the folders in your AWS account. This structure provides basic information about the folders.</p>', ], ], 'FolderType' => [ 'base' => NULL, 'refs' => [ 'CreateFolderRequest$FolderType' => '<p>The type of folder. By default, <code>folderType</code> is <code>SHARED</code>.</p>', 'Folder$FolderType' => '<p>The type of the folder.</p>', 'FolderSummary$FolderType' => '<p>The type of folder.</p>', ], ], 'GenerateEmbedUrlForAnonymousUserRequest' => [ 'base' => NULL, 'refs' => [], ], 'GenerateEmbedUrlForAnonymousUserResponse' => [ 'base' => NULL, 'refs' => [], ], 'GenerateEmbedUrlForRegisteredUserRequest' => [ 'base' => NULL, 'refs' => [], ], 'GenerateEmbedUrlForRegisteredUserResponse' => [ 'base' => NULL, 'refs' => [], ], 'GeoSpatialColumnGroup' => [ 'base' => '<p>Geospatial column group that denotes a hierarchy.</p>', 'refs' => [ 'ColumnGroup$GeoSpatialColumnGroup' => '<p>Geospatial column group that denotes a hierarchy.</p>', ], ], 'GeoSpatialCountryCode' => [ 'base' => NULL, 'refs' => [ 'GeoSpatialColumnGroup$CountryCode' => '<p>Country code.</p>', ], ], 'GeoSpatialDataRole' => [ 'base' => NULL, 'refs' => [ 'ColumnTag$ColumnGeographicRole' => '<p>A geospatial role for a column.</p>', ], ], 'GetDashboardEmbedUrlRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetDashboardEmbedUrlResponse' => [ 'base' => '<p>Output returned from the <code>GetDashboardEmbedUrl</code> operation.</p>', 'refs' => [], ], 'GetSessionEmbedUrlRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetSessionEmbedUrlResponse' => [ 'base' => NULL, 'refs' => [], ], 'Group' => [ 'base' => '<p>A <i>group</i> in Amazon QuickSight consists of a set of users. You can use groups to make it easier to manage access and security. </p>', 'refs' => [ 'CreateGroupResponse$Group' => '<p>The name of the group.</p>', 'DescribeGroupResponse$Group' => '<p>The name of the group.</p>', 'GroupList$member' => NULL, 'UpdateGroupResponse$Group' => '<p>The name of the group.</p>', ], ], 'GroupDescription' => [ 'base' => NULL, 'refs' => [ 'CreateGroupRequest$Description' => '<p>A description for the group that you want to create.</p>', 'Group$Description' => '<p>The group description.</p>', 'UpdateGroupRequest$Description' => '<p>The description for the group that you want to update.</p>', ], ], 'GroupList' => [ 'base' => NULL, 'refs' => [ 'ListGroupsResponse$GroupList' => '<p>The list of the groups.</p>', 'ListUserGroupsResponse$GroupList' => '<p>The list of groups the user is a member of.</p>', ], ], 'GroupMember' => [ 'base' => '<p>A member of an Amazon QuickSight group. Currently, group members must be users. Groups can\'t be members of another group. .</p>', 'refs' => [ 'CreateGroupMembershipResponse$GroupMember' => '<p>The group member.</p>', 'GroupMemberList$member' => NULL, ], ], 'GroupMemberList' => [ 'base' => NULL, 'refs' => [ 'ListGroupMembershipsResponse$GroupMemberList' => '<p>The list of the members of the group.</p>', ], ], 'GroupMemberName' => [ 'base' => NULL, 'refs' => [ 'CreateGroupMembershipRequest$MemberName' => '<p>The name of the user that you want to add to the group membership.</p>', 'DeleteGroupMembershipRequest$MemberName' => '<p>The name of the user that you want to delete from the group membership.</p>', 'GroupMember$MemberName' => '<p>The name of the group member (user).</p>', ], ], 'GroupName' => [ 'base' => NULL, 'refs' => [ 'CreateGroupMembershipRequest$GroupName' => '<p>The name of the group that you want to add the user to.</p>', 'CreateGroupRequest$GroupName' => '<p>A name for the group that you want to create.</p>', 'DeleteGroupMembershipRequest$GroupName' => '<p>The name of the group that you want to delete the user from.</p>', 'DeleteGroupRequest$GroupName' => '<p>The name of the group that you want to delete.</p>', 'DescribeGroupRequest$GroupName' => '<p>The name of the group that you want to describe.</p>', 'Group$GroupName' => '<p>The name of the group.</p>', 'ListGroupMembershipsRequest$GroupName' => '<p>The name of the group that you want to see a membership list of.</p>', 'UpdateGroupRequest$GroupName' => '<p>The name of the group that you want to update.</p>', ], ], 'GutterStyle' => [ 'base' => '<p>The display options for gutter spacing between tiles on a sheet.</p>', 'refs' => [ 'TileLayoutStyle$Gutter' => '<p>The gutter settings that apply between tiles. </p>', ], ], 'HexColor' => [ 'base' => NULL, 'refs' => [ 'ColorList$member' => NULL, 'DataColorPalette$EmptyFillColor' => '<p>The hexadecimal code of a color that applies to charts where a lack of data is highlighted.</p>', 'UIColorPalette$PrimaryForeground' => '<p>The color of text and other foreground elements that appear over the primary background regions, such as grid lines, borders, table banding, icons, and so on.</p>', 'UIColorPalette$PrimaryBackground' => '<p>The background color that applies to visuals and other high emphasis UI.</p>', 'UIColorPalette$SecondaryForeground' => '<p>The foreground color that applies to any sheet title, sheet control text, or UI that appears over the secondary background.</p>', 'UIColorPalette$SecondaryBackground' => '<p>The background color that applies to the sheet background and sheet controls.</p>', 'UIColorPalette$Accent' => '<p>This color is that applies to selected states and buttons.</p>', 'UIColorPalette$AccentForeground' => '<p>The foreground color that applies to any text or other elements that appear over the accent color.</p>', 'UIColorPalette$Danger' => '<p>The color that applies to error messages.</p>', 'UIColorPalette$DangerForeground' => '<p>The foreground color that applies to any text or other elements that appear over the error color.</p>', 'UIColorPalette$Warning' => '<p>This color that applies to warning and informational messages.</p>', 'UIColorPalette$WarningForeground' => '<p>The foreground color that applies to any text or other elements that appear over the warning color.</p>', 'UIColorPalette$Success' => '<p>The color that applies to success messages, for example the check mark for a successful download.</p>', 'UIColorPalette$SuccessForeground' => '<p>The foreground color that applies to any text or other elements that appear over the success color.</p>', 'UIColorPalette$Dimension' => '<p>The color that applies to the names of fields that are identified as dimensions.</p>', 'UIColorPalette$DimensionForeground' => '<p>The foreground color that applies to any text or other elements that appear over the dimension color.</p>', 'UIColorPalette$Measure' => '<p>The color that applies to the names of fields that are identified as measures.</p>', 'UIColorPalette$MeasureForeground' => '<p>The foreground color that applies to any text or other elements that appear over the measure color.</p>', ], ], 'Host' => [ 'base' => NULL, 'refs' => [ 'AuroraParameters$Host' => '<p>Host.</p>', 'AuroraPostgreSqlParameters$Host' => '<p>The Amazon Aurora PostgreSQL-Compatible host to connect to.</p>', 'MariaDbParameters$Host' => '<p>Host.</p>', 'MySqlParameters$Host' => '<p>Host.</p>', 'OracleParameters$Host' => '<p>An Oracle host.</p>', 'PostgreSqlParameters$Host' => '<p>Host.</p>', 'PrestoParameters$Host' => '<p>Host.</p>', 'RedshiftParameters$Host' => '<p>Host. This field can be blank if <code>ClusterId</code> is provided.</p>', 'SnowflakeParameters$Host' => '<p>Host.</p>', 'SparkParameters$Host' => '<p>Host.</p>', 'SqlServerParameters$Host' => '<p>Host.</p>', 'TeradataParameters$Host' => '<p>Host.</p>', ], ], 'IAMPolicyAssignment' => [ 'base' => '<p>An Identity and Access Management (IAM) policy assignment.</p>', 'refs' => [ 'DescribeIAMPolicyAssignmentResponse$IAMPolicyAssignment' => '<p>Information describing the IAMpolicy assignment.</p>', ], ], 'IAMPolicyAssignmentName' => [ 'base' => NULL, 'refs' => [ 'ActiveIAMPolicyAssignment$AssignmentName' => '<p>A name for the IAMpolicy assignment.</p>', 'CreateIAMPolicyAssignmentRequest$AssignmentName' => '<p>The name of the assignment, also called a rule. It must be unique within an Amazon Web Services account.</p>', 'CreateIAMPolicyAssignmentResponse$AssignmentName' => '<p>The name of the assignment. This name must be unique within the Amazon Web Services account.</p>', 'DeleteIAMPolicyAssignmentRequest$AssignmentName' => '<p>The name of the assignment. </p>', 'DeleteIAMPolicyAssignmentResponse$AssignmentName' => '<p>The name of the assignment. </p>', 'DescribeIAMPolicyAssignmentRequest$AssignmentName' => '<p>The name of the assignment, also called a rule.</p>', 'IAMPolicyAssignment$AssignmentName' => '<p>Assignment name.</p>', 'IAMPolicyAssignmentSummary$AssignmentName' => '<p>Assignment name.</p>', 'UpdateIAMPolicyAssignmentRequest$AssignmentName' => '<p>The name of the assignment, also called a rule. This name must be unique within an Amazon Web Services account.</p>', 'UpdateIAMPolicyAssignmentResponse$AssignmentName' => '<p>The name of the assignment or rule.</p>', ], ], 'IAMPolicyAssignmentSummary' => [ 'base' => '<p>IAMpolicy assignment summary.</p>', 'refs' => [ 'IAMPolicyAssignmentSummaryList$member' => NULL, ], ], 'IAMPolicyAssignmentSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListIAMPolicyAssignmentsResponse$IAMPolicyAssignments' => '<p>Information describing the IAMpolicy assignments.</p>', ], ], 'IdentityMap' => [ 'base' => NULL, 'refs' => [ 'CreateIAMPolicyAssignmentRequest$Identities' => '<p>The Amazon QuickSight users, groups, or both that you want to assign the policy to.</p>', 'CreateIAMPolicyAssignmentResponse$Identities' => '<p>The Amazon QuickSight users, groups, or both that the IAMpolicy is assigned to.</p>', 'IAMPolicyAssignment$Identities' => '<p>Identities.</p>', 'UpdateIAMPolicyAssignmentRequest$Identities' => '<p>The Amazon QuickSight users, groups, or both that you want to assign the policy to.</p>', 'UpdateIAMPolicyAssignmentResponse$Identities' => '<p>The Amazon QuickSight users, groups, or both that the IAMpolicy is assigned to.</p>', ], ], 'IdentityName' => [ 'base' => NULL, 'refs' => [ 'IdentityNameList$member' => NULL, ], ], 'IdentityNameList' => [ 'base' => NULL, 'refs' => [ 'IdentityMap$value' => NULL, ], ], 'IdentityStore' => [ 'base' => NULL, 'refs' => [ 'CreateNamespaceRequest$IdentityStore' => '<p>Specifies the type of your user identity directory. Currently, this supports users with an identity type of <code>QUICKSIGHT</code>.</p>', 'CreateNamespaceResponse$IdentityStore' => '<p>Specifies the type of your user identity directory. Currently, this supports users with an identity type of <code>QUICKSIGHT</code>.</p>', 'NamespaceInfoV2$IdentityStore' => '<p>The identity store used for the namespace.</p>', ], ], 'IdentityType' => [ 'base' => NULL, 'refs' => [ 'RegisterUserRequest$IdentityType' => '<p>Amazon QuickSight supports several ways of managing the identity of users. This parameter accepts two values:</p> <ul> <li> <p> <code>IAM</code>: A user whose identity maps to an existing IAMuser or role. </p> </li> <li> <p> <code>QUICKSIGHT</code>: A user whose identity is owned and managed internally by Amazon QuickSight. </p> </li> </ul>', 'User$IdentityType' => '<p>The type of identity authentication used by the user.</p>', ], ], 'IdentityTypeNotSupportedException' => [ 'base' => '<p>The identity type specified isn\'t supported. Supported identity types include <code>IAM</code> and <code>QUICKSIGHT</code>.</p>', 'refs' => [], ], 'Ingestion' => [ 'base' => '<p>Information about the SPICE ingestion for a dataset.</p>', 'refs' => [ 'DescribeIngestionResponse$Ingestion' => '<p>Information about the ingestion.</p>', 'Ingestions$member' => NULL, ], ], 'IngestionErrorType' => [ 'base' => NULL, 'refs' => [ 'ErrorInfo$Type' => '<p>Error type.</p>', ], ], 'IngestionId' => [ 'base' => NULL, 'refs' => [ 'CancelIngestionRequest$IngestionId' => '<p>An ID for the ingestion.</p>', 'CancelIngestionResponse$IngestionId' => '<p>An ID for the ingestion.</p>', 'CreateIngestionRequest$IngestionId' => '<p>An ID for the ingestion.</p>', 'CreateIngestionResponse$IngestionId' => '<p>An ID for the ingestion.</p>', 'DescribeIngestionRequest$IngestionId' => '<p>An ID for the ingestion.</p>', 'Ingestion$IngestionId' => '<p>Ingestion ID.</p>', ], ], 'IngestionMaxResults' => [ 'base' => NULL, 'refs' => [ 'ListIngestionsRequest$MaxResults' => '<p>The maximum number of results to be returned per request.</p>', ], ], 'IngestionRequestSource' => [ 'base' => NULL, 'refs' => [ 'Ingestion$RequestSource' => '<p>Event source for this ingestion.</p>', ], ], 'IngestionRequestType' => [ 'base' => NULL, 'refs' => [ 'Ingestion$RequestType' => '<p>Type of this ingestion.</p>', ], ], 'IngestionStatus' => [ 'base' => NULL, 'refs' => [ 'CreateIngestionResponse$IngestionStatus' => '<p>The ingestion status.</p>', 'Ingestion$IngestionStatus' => '<p>Ingestion status.</p>', ], ], 'Ingestions' => [ 'base' => NULL, 'refs' => [ 'ListIngestionsResponse$Ingestions' => '<p>A list of the ingestions.</p>', ], ], 'InputColumn' => [ 'base' => '<p>Metadata for a column that is used as the input of a transform operation.</p>', 'refs' => [ 'InputColumnList$member' => NULL, ], ], 'InputColumnDataType' => [ 'base' => NULL, 'refs' => [ 'InputColumn$Type' => '<p>The data type of the column.</p>', ], ], 'InputColumnList' => [ 'base' => NULL, 'refs' => [ 'CustomSql$Columns' => '<p>The column schema from the SQL query result set.</p>', 'RelationalTable$InputColumns' => '<p>The column schema of the table.</p>', 'S3Source$InputColumns' => '<p>A physical table type for an S3 data source.</p> <note> <p>For files that aren\'t JSON, only <code>STRING</code> data types are supported in input columns.</p> </note>', ], ], 'InstanceId' => [ 'base' => NULL, 'refs' => [ 'RdsParameters$InstanceId' => '<p>Instance ID.</p>', ], ], 'IntegerParameter' => [ 'base' => '<p>An integer parameter.</p>', 'refs' => [ 'IntegerParameterList$member' => NULL, ], ], 'IntegerParameterList' => [ 'base' => NULL, 'refs' => [ 'Parameters$IntegerParameters' => '<p>The parameters that have a data type of integer.</p>', ], ], 'InternalFailureException' => [ 'base' => '<p>An internal failure occurred.</p>', 'refs' => [], ], 'InvalidNextTokenException' => [ 'base' => '<p>The <code>NextToken</code> value isn\'t valid.</p>', 'refs' => [], ], 'InvalidParameterValueException' => [ 'base' => '<p>One or more parameters has a value that isn\'t valid.</p>', 'refs' => [], ], 'JiraParameters' => [ 'base' => '<p>The parameters for Jira.</p>', 'refs' => [ 'DataSourceParameters$JiraParameters' => '<p>The parameters for Jira.</p>', ], ], 'JoinInstruction' => [ 'base' => '<p>The instructions associated with a join. </p>', 'refs' => [ 'LogicalTableSource$JoinInstruction' => '<p>Specifies the result of a join of two logical tables.</p>', ], ], 'JoinKeyProperties' => [ 'base' => '<p>Properties associated with the columns participating in a join.</p>', 'refs' => [ 'JoinInstruction$LeftJoinKeyProperties' => '<p>Join key properties of the left operand.</p>', 'JoinInstruction$RightJoinKeyProperties' => '<p>Join key properties of the right operand.</p>', ], ], 'JoinType' => [ 'base' => NULL, 'refs' => [ 'JoinInstruction$Type' => '<p>The type of join that it is.</p>', ], ], 'LimitExceededException' => [ 'base' => '<p>A limit is exceeded.</p>', 'refs' => [], ], 'ListAnalysesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListAnalysesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListDashboardVersionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListDashboardVersionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListDashboardsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListDashboardsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListDataSetsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListDataSetsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListDataSourcesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListDataSourcesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListFolderMembersRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListFolderMembersResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListFoldersRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListFoldersResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListGroupMembershipsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListGroupMembershipsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListGroupsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListGroupsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListIAMPolicyAssignmentsForUserRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListIAMPolicyAssignmentsForUserResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListIAMPolicyAssignmentsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListIAMPolicyAssignmentsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListIngestionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListIngestionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListNamespacesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListNamespacesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTemplateAliasesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTemplateAliasesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTemplateVersionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTemplateVersionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTemplatesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTemplatesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListThemeAliasesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListThemeAliasesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListThemeVersionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListThemeVersionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListThemesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListThemesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListUserGroupsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListUserGroupsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListUsersRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListUsersResponse' => [ 'base' => NULL, 'refs' => [], ], 'LogicalTable' => [ 'base' => '<p>A <i>logical table</i> is a unit that joins and that data transformations operate on. A logical table has a source, which can be either a physical table or result of a join. When a logical table points to a physical table, the logical table acts as a mutable copy of that physical table through transform operations.</p>', 'refs' => [ 'LogicalTableMap$value' => NULL, ], ], 'LogicalTableAlias' => [ 'base' => NULL, 'refs' => [ 'LogicalTable$Alias' => '<p>A display name for the logical table.</p>', ], ], 'LogicalTableId' => [ 'base' => NULL, 'refs' => [ 'JoinInstruction$LeftOperand' => '<p>The operand on the left side of a join.</p>', 'JoinInstruction$RightOperand' => '<p>The operand on the right side of a join.</p>', 'LogicalTableMap$key' => NULL, ], ], 'LogicalTableMap' => [ 'base' => NULL, 'refs' => [ 'CreateDataSetRequest$LogicalTableMap' => '<p>Configures the combination and transformation of the data from the physical tables.</p>', 'DataSet$LogicalTableMap' => '<p>Configures the combination and transformation of the data from the physical tables.</p>', 'UpdateDataSetRequest$LogicalTableMap' => '<p>Configures the combination and transformation of the data from the physical tables.</p>', ], ], 'LogicalTableSource' => [ 'base' => '<p>Information about the source of a logical table. This is a variant type structure. For this structure to be valid, only one of the attributes can be non-null.</p>', 'refs' => [ 'LogicalTable$Source' => '<p>Source of this logical table.</p>', ], ], 'Long' => [ 'base' => NULL, 'refs' => [ 'DataSet$ConsumedSpiceCapacityInBytes' => '<p>The amount of SPICE capacity used by this dataset. This is 0 if the dataset isn\'t imported into SPICE.</p>', 'LongList$member' => NULL, ], ], 'LongList' => [ 'base' => NULL, 'refs' => [ 'IntegerParameter$Values' => '<p>The values for the integer parameter.</p>', ], ], 'ManifestFileLocation' => [ 'base' => '<p>Amazon S3 manifest file location.</p>', 'refs' => [ 'S3Parameters$ManifestFileLocation' => '<p>Location of the Amazon S3 manifest file. This is NULL if the manifest file was uploaded into Amazon QuickSight.</p>', ], ], 'MarginStyle' => [ 'base' => '<p>The display options for margins around the outside edge of sheets.</p>', 'refs' => [ 'TileLayoutStyle$Margin' => '<p>The margin settings that apply around the outside edge of sheets.</p>', ], ], 'MariaDbParameters' => [ 'base' => '<p>The parameters for MariaDB.</p>', 'refs' => [ 'DataSourceParameters$MariaDbParameters' => '<p>The parameters for MariaDB.</p>', ], ], 'MaxResults' => [ 'base' => NULL, 'refs' => [ 'ListAnalysesRequest$MaxResults' => '<p>The maximum number of results to return.</p>', 'ListDashboardVersionsRequest$MaxResults' => '<p>The maximum number of results to be returned per request.</p>', 'ListDashboardsRequest$MaxResults' => '<p>The maximum number of results to be returned per request.</p>', 'ListDataSetsRequest$MaxResults' => '<p>The maximum number of results to be returned per request.</p>', 'ListDataSourcesRequest$MaxResults' => '<p>The maximum number of results to be returned per request.</p>', 'ListFolderMembersRequest$MaxResults' => '<p>The maximum number of results to be returned per request.</p>', 'ListFoldersRequest$MaxResults' => '<p>The maximum number of results to be returned per request.</p>', 'ListGroupMembershipsRequest$MaxResults' => '<p>The maximum number of results to return from this request.</p>', 'ListGroupsRequest$MaxResults' => '<p>The maximum number of results to return.</p>', 'ListIAMPolicyAssignmentsForUserRequest$MaxResults' => '<p>The maximum number of results to be returned per request.</p>', 'ListIAMPolicyAssignmentsRequest$MaxResults' => '<p>The maximum number of results to be returned per request.</p>', 'ListNamespacesRequest$MaxResults' => '<p>The maximum number of results to return.</p>', 'ListTemplateAliasesRequest$MaxResults' => '<p>The maximum number of results to be returned per request.</p>', 'ListTemplateVersionsRequest$MaxResults' => '<p>The maximum number of results to be returned per request.</p>', 'ListTemplatesRequest$MaxResults' => '<p>The maximum number of results to be returned per request.</p>', 'ListThemeAliasesRequest$MaxResults' => '<p>The maximum number of results to be returned per request.</p>', 'ListThemeVersionsRequest$MaxResults' => '<p>The maximum number of results to be returned per request.</p>', 'ListThemesRequest$MaxResults' => '<p>The maximum number of results to be returned per request.</p>', 'ListUserGroupsRequest$MaxResults' => '<p>The maximum number of results to return from this request.</p>', 'ListUsersRequest$MaxResults' => '<p>The maximum number of results to return from this request.</p>', 'SearchAnalysesRequest$MaxResults' => '<p>The maximum number of results to return.</p>', 'SearchDashboardsRequest$MaxResults' => '<p>The maximum number of results to be returned per request.</p>', 'SearchFoldersRequest$MaxResults' => '<p>The maximum number of results to be returned per request.</p>', ], ], 'MemberIdArnPair' => [ 'base' => '<p>An object that consists of the member Amazon Resource Name (ARN) and member ID.</p>', 'refs' => [ 'FolderMemberList$member' => NULL, ], ], 'MemberType' => [ 'base' => NULL, 'refs' => [ 'CreateFolderMembershipRequest$MemberType' => '<p>The type of the member, including <code>DASHBOARD</code>, <code>ANALYSIS</code>, and <code>DATASET</code>.</p>', 'DeleteFolderMembershipRequest$MemberType' => '<p>The type of the member, including <code>DASHBOARD</code>, <code>ANALYSIS</code>, and <code>DATASET</code> </p>', 'FolderMember$MemberType' => '<p>The type of the asset.</p>', ], ], 'MySqlParameters' => [ 'base' => '<p>The parameters for MySQL.</p>', 'refs' => [ 'DataSourceParameters$MySqlParameters' => '<p>The parameters for MySQL.</p>', ], ], 'Namespace' => [ 'base' => NULL, 'refs' => [ 'AccountSettings$DefaultNamespace' => '<p>The default Amazon QuickSight namespace for your Amazon Web Services account. </p>', 'CreateAccountCustomizationRequest$Namespace' => '<p>The Amazon QuickSight namespace that you want to add customizations to.</p>', 'CreateAccountCustomizationResponse$Namespace' => '<p>The namespace associated with the customization you\'re creating. </p>', 'CreateGroupMembershipRequest$Namespace' => '<p>The namespace. Currently, you should set this to <code>default</code>.</p>', 'CreateGroupRequest$Namespace' => '<p>The namespace. Currently, you should set this to <code>default</code>.</p>', 'CreateIAMPolicyAssignmentRequest$Namespace' => '<p>The namespace that contains the assignment.</p>', 'CreateNamespaceRequest$Namespace' => '<p>The name that you want to use to describe the new namespace.</p>', 'CreateNamespaceResponse$Name' => '<p>The name of the new namespace that you created.</p>', 'DeleteAccountCustomizationRequest$Namespace' => '<p>The Amazon QuickSight namespace that you\'re deleting the customizations from.</p>', 'DeleteGroupMembershipRequest$Namespace' => '<p>The namespace. Currently, you should set this to <code>default</code>.</p>', 'DeleteGroupRequest$Namespace' => '<p>The namespace. Currently, you should set this to <code>default</code>.</p>', 'DeleteIAMPolicyAssignmentRequest$Namespace' => '<p>The namespace that contains the assignment.</p>', 'DeleteNamespaceRequest$Namespace' => '<p>The namespace that you want to delete.</p>', 'DeleteUserByPrincipalIdRequest$Namespace' => '<p>The namespace. Currently, you should set this to <code>default</code>.</p>', 'DeleteUserRequest$Namespace' => '<p>The namespace. Currently, you should set this to <code>default</code>.</p>', 'DescribeAccountCustomizationRequest$Namespace' => '<p>The Amazon QuickSight namespace that you want to describe Amazon QuickSight customizations for.</p>', 'DescribeAccountCustomizationResponse$Namespace' => '<p>The Amazon QuickSight namespace that you\'re describing. </p>', 'DescribeGroupRequest$Namespace' => '<p>The namespace. Currently, you should set this to <code>default</code>.</p>', 'DescribeIAMPolicyAssignmentRequest$Namespace' => '<p>The namespace that contains the assignment.</p>', 'DescribeNamespaceRequest$Namespace' => '<p>The namespace that you want to describe.</p>', 'DescribeUserRequest$Namespace' => '<p>The namespace. Currently, you should set this to <code>default</code>.</p>', 'GenerateEmbedUrlForAnonymousUserRequest$Namespace' => '<p>The Amazon QuickSight namespace that the anonymous user virtually belongs to. If you are not using an Amazon QuickSight custom namespace, set this to <code>default</code>.</p>', 'GetDashboardEmbedUrlRequest$Namespace' => '<p>The Amazon QuickSight namespace that contains the dashboard IDs in this request. If you\'re not using a custom namespace, set <code>Namespace = default</code>.</p>', 'ListGroupMembershipsRequest$Namespace' => '<p>The namespace. Currently, you should set this to <code>default</code>.</p>', 'ListGroupsRequest$Namespace' => '<p>The namespace. Currently, you should set this to <code>default</code>.</p>', 'ListIAMPolicyAssignmentsForUserRequest$Namespace' => '<p>The namespace of the assignment.</p>', 'ListIAMPolicyAssignmentsRequest$Namespace' => '<p>The namespace for the assignments.</p>', 'ListUserGroupsRequest$Namespace' => '<p>The namespace. Currently, you should set this to <code>default</code>.</p>', 'ListUsersRequest$Namespace' => '<p>The namespace. Currently, you should set this to <code>default</code>.</p>', 'NamespaceInfoV2$Name' => '<p>The name of the error.</p>', 'RegisterUserRequest$Namespace' => '<p>The namespace. Currently, you should set this to <code>default</code>.</p>', 'RowLevelPermissionDataSet$Namespace' => '<p>The namespace associated with the dataset that contains permissions for RLS.</p>', 'UpdateAccountCustomizationRequest$Namespace' => '<p>The namespace that you want to update Amazon QuickSight customizations for.</p>', 'UpdateAccountCustomizationResponse$Namespace' => '<p>The namespace associated with the customization that you\'re updating.</p>', 'UpdateAccountSettingsRequest$DefaultNamespace' => '<p>The default namespace for this Amazon Web Services account. Currently, the default is <code>default</code>. Identity and Access Management (IAM) users that register for the first time with Amazon QuickSight provide an email that becomes associated with the default namespace.</p>', 'UpdateGroupRequest$Namespace' => '<p>The namespace. Currently, you should set this to <code>default</code>.</p>', 'UpdateIAMPolicyAssignmentRequest$Namespace' => '<p>The namespace of the assignment.</p>', 'UpdateUserRequest$Namespace' => '<p>The namespace. Currently, you should set this to <code>default</code>.</p>', ], ], 'NamespaceError' => [ 'base' => '<p>Errors that occur during namespace creation.</p>', 'refs' => [ 'NamespaceInfoV2$NamespaceError' => '<p>An error that occurred when the namespace was created.</p>', ], ], 'NamespaceErrorType' => [ 'base' => NULL, 'refs' => [ 'NamespaceError$Type' => '<p>The error type.</p>', ], ], 'NamespaceInfoV2' => [ 'base' => '<p>The error type.</p>', 'refs' => [ 'DescribeNamespaceResponse$Namespace' => '<p>The information about the namespace that you\'re describing. The response includes the namespace ARN, name, Amazon Web Services Region;, creation status, and identity store. <code>DescribeNamespace</code> also works for namespaces that are in the process of being created. For incomplete namespaces, this API operation lists the namespace error types and messages associated with the creation process.</p>', 'Namespaces$member' => NULL, ], ], 'NamespaceStatus' => [ 'base' => NULL, 'refs' => [ 'CreateNamespaceResponse$CreationStatus' => '<p>The status of the creation of the namespace. This is an asynchronous process. A status of <code>CREATED</code> means that your namespace is ready to use. If an error occurs, it indicates if the process is <code>retryable</code> or <code>non-retryable</code>. In the case of a non-retryable error, refer to the error message for follow-up tasks.</p>', 'NamespaceInfoV2$CreationStatus' => '<p>The creation status of a namespace that is not yet completely created.</p>', ], ], 'Namespaces' => [ 'base' => NULL, 'refs' => [ 'ListNamespacesResponse$Namespaces' => '<p>The information about the namespaces in this Amazon Web Services account. The response includes the namespace ARN, name, Amazon Web Services Region;, notification email address, creation status, and identity store.</p>', ], ], 'NonEmptyString' => [ 'base' => NULL, 'refs' => [ 'AnalysisError$Message' => '<p>The message associated with the analysis error.</p>', 'DashboardError$Message' => '<p>Message.</p>', 'DataSetReference$DataSetPlaceholder' => '<p>Dataset placeholder.</p>', 'DateTimeParameter$Name' => '<p>A display name for the date-time parameter.</p>', 'DecimalParameter$Name' => '<p>A display name for the decimal parameter.</p>', 'IntegerParameter$Name' => '<p>The name of the integer parameter.</p>', 'Sheet$Name' => '<p>The name of a sheet. This name is displayed on the sheet\'s tab in the Amazon QuickSight console.</p>', 'StringParameter$Name' => '<p>A display name for a string parameter.</p>', 'TemplateError$Message' => '<p>Description of the error type.</p>', 'ThemeError$Message' => '<p>The error message.</p>', ], ], 'OnClause' => [ 'base' => NULL, 'refs' => [ 'JoinInstruction$OnClause' => '<p>The join instructions provided in the <code>ON</code> clause of a join.</p>', ], ], 'OptionalPort' => [ 'base' => NULL, 'refs' => [ 'RedshiftParameters$Port' => '<p>Port. This field can be blank if the <code>ClusterId</code> is provided.</p>', ], ], 'OracleParameters' => [ 'base' => '<p>The parameters for Oracle.</p>', 'refs' => [ 'DataSourceParameters$OracleParameters' => '<p>The parameters for Oracle.</p>', ], ], 'OutputColumn' => [ 'base' => '<p>Output column.</p>', 'refs' => [ 'OutputColumnList$member' => NULL, ], ], 'OutputColumnList' => [ 'base' => NULL, 'refs' => [ 'DataSet$OutputColumns' => '<p>The list of columns after all transforms. These columns are available in templates, analyses, and dashboards.</p>', ], ], 'Parameters' => [ 'base' => '<p>A list of Amazon QuickSight parameters and the list\'s override values.</p>', 'refs' => [ 'CreateAnalysisRequest$Parameters' => '<p>The parameter names and override values that you want to use. An analysis can have any parameter type, and some parameters might accept multiple values. </p>', 'CreateDashboardRequest$Parameters' => '<p>The parameters for the creation of the dashboard, which you want to use to override the default settings. A dashboard can have any type of parameters, and some parameters might accept multiple values. </p>', 'UpdateAnalysisRequest$Parameters' => '<p>The parameter names and override values that you want to use. An analysis can have any parameter type, and some parameters might accept multiple values. </p>', 'UpdateDashboardRequest$Parameters' => '<p>A structure that contains the parameters of the dashboard. These are parameter overrides for a dashboard. A dashboard can have any type of parameters, and some parameters might accept multiple values.</p>', ], ], 'Password' => [ 'base' => NULL, 'refs' => [ 'CredentialPair$Password' => '<p>Password.</p>', ], ], 'Path' => [ 'base' => NULL, 'refs' => [ 'Folder$FolderPath' => '<p>An array of ancestor folder ARN strings.</p>', ], ], 'PhysicalTable' => [ 'base' => '<p>A view of a data source that contains information about the shape of the data in the underlying source. This is a variant type structure. For this structure to be valid, only one of the attributes can be non-null.</p>', 'refs' => [ 'PhysicalTableMap$value' => NULL, ], ], 'PhysicalTableId' => [ 'base' => NULL, 'refs' => [ 'LogicalTableSource$PhysicalTableId' => '<p>Physical table ID.</p>', 'PhysicalTableMap$key' => NULL, ], ], 'PhysicalTableMap' => [ 'base' => NULL, 'refs' => [ 'CreateDataSetRequest$PhysicalTableMap' => '<p>Declares the physical tables that are available in the underlying data sources.</p>', 'DataSet$PhysicalTableMap' => '<p>Declares the physical tables that are available in the underlying data sources.</p>', 'UpdateDataSetRequest$PhysicalTableMap' => '<p>Declares the physical tables that are available in the underlying data sources.</p>', ], ], 'Port' => [ 'base' => NULL, 'refs' => [ 'AuroraParameters$Port' => '<p>Port.</p>', 'AuroraPostgreSqlParameters$Port' => '<p>The port that Amazon Aurora PostgreSQL is listening on.</p>', 'MariaDbParameters$Port' => '<p>Port.</p>', 'MySqlParameters$Port' => '<p>Port.</p>', 'OracleParameters$Port' => '<p>Port.</p>', 'PostgreSqlParameters$Port' => '<p>Port.</p>', 'PrestoParameters$Port' => '<p>Port.</p>', 'SparkParameters$Port' => '<p>Port.</p>', 'SqlServerParameters$Port' => '<p>Port.</p>', 'TeradataParameters$Port' => '<p>Port.</p>', ], ], 'PositiveInteger' => [ 'base' => NULL, 'refs' => [ 'TwitterParameters$MaxRows' => '<p>Maximum number of rows to query Twitter.</p>', 'UploadSettings$StartFromRow' => '<p>A row number to start reading data from.</p>', ], ], 'PostgreSqlParameters' => [ 'base' => '<p>The parameters for PostgreSQL.</p>', 'refs' => [ 'DataSourceParameters$PostgreSqlParameters' => '<p>The parameters for PostgreSQL.</p>', ], ], 'PreconditionNotMetException' => [ 'base' => '<p>One or more preconditions aren\'t met.</p>', 'refs' => [], ], 'PrestoParameters' => [ 'base' => '<p>The parameters for Presto.</p>', 'refs' => [ 'DataSourceParameters$PrestoParameters' => '<p>The parameters for Presto.</p>', ], ], 'Principal' => [ 'base' => NULL, 'refs' => [ 'ResourcePermission$Principal' => '<p>The Amazon Resource Name (ARN) of the principal. This can be one of the following:</p> <ul> <li> <p>The ARN of an Amazon QuickSight user or group associated with a data source or dataset. (This is common.)</p> </li> <li> <p>The ARN of an Amazon QuickSight user, group, or namespace associated with an analysis, dashboard, template, or theme. (This is common.)</p> </li> <li> <p>The ARN of an Amazon Web Services account root: This is an IAMARN rather than a Amazon QuickSight ARN. Use this option only to share resources (templates) across Amazon Web Services accounts. (This is less common.) </p> </li> </ul>', ], ], 'PrincipalList' => [ 'base' => NULL, 'refs' => [ 'ColumnLevelPermissionRule$Principals' => '<p>An array of Amazon Resource Names (ARNs) for Amazon QuickSight users or groups.</p>', ], ], 'ProjectOperation' => [ 'base' => '<p>A transform operation that projects columns. Operations that come after a projection can only refer to projected columns.</p>', 'refs' => [ 'TransformOperation$ProjectOperation' => '<p>An operation that projects columns. Operations that come after a projection can only refer to projected columns.</p>', ], ], 'ProjectedColumnList' => [ 'base' => NULL, 'refs' => [ 'ProjectOperation$ProjectedColumns' => '<p>Projected columns.</p>', ], ], 'Query' => [ 'base' => NULL, 'refs' => [ 'TwitterParameters$Query' => '<p>Twitter query string.</p>', ], ], 'QueueInfo' => [ 'base' => '<p>Information about a queued dataset SPICE ingestion.</p>', 'refs' => [ 'Ingestion$QueueInfo' => NULL, ], ], 'QuickSightUserNotFoundException' => [ 'base' => '<p>The user with the provided name isn\'t found. This error can happen in any operation that requires finding a user based on a provided user name, such as <code>DeleteUser</code>, <code>DescribeUser</code>, and so on.</p>', 'refs' => [], ], 'RdsParameters' => [ 'base' => '<p>The parameters for Amazon RDS.</p>', 'refs' => [ 'DataSourceParameters$RdsParameters' => '<p>The parameters for Amazon RDS.</p>', ], ], 'RecoveryWindowInDays' => [ 'base' => NULL, 'refs' => [ 'DeleteAnalysisRequest$RecoveryWindowInDays' => '<p>A value that specifies the number of days that Amazon QuickSight waits before it deletes the analysis. You can\'t use this parameter with the <code>ForceDeleteWithoutRecovery</code> option in the same API call. The default value is 30.</p>', ], ], 'RedshiftParameters' => [ 'base' => '<p>The parameters for Amazon Redshift. The <code>ClusterId</code> field can be blank if <code>Host</code> and <code>Port</code> are both set. The <code>Host</code> and <code>Port</code> fields can be blank if the <code>ClusterId</code> field is set.</p>', 'refs' => [ 'DataSourceParameters$RedshiftParameters' => '<p>The parameters for Amazon Redshift.</p>', ], ], 'RegisterUserRequest' => [ 'base' => NULL, 'refs' => [], ], 'RegisterUserResponse' => [ 'base' => NULL, 'refs' => [], ], 'RegisteredUserDashboardEmbeddingConfiguration' => [ 'base' => '<p>Information about the dashboard you want to embed.</p>', 'refs' => [ 'RegisteredUserEmbeddingExperienceConfiguration$Dashboard' => '<p>The configuration details for providing a dashboard embedding experience.</p>', ], ], 'RegisteredUserEmbeddingExperienceConfiguration' => [ 'base' => '<p>The type of experience you want to embed. For registered users, you can embed an Amazon QuickSight dashboard or the Amazon QuickSight console.</p> <note> <p>Exactly one of the experience configurations is required. You can choose <code>Dashboard</code> or <code>QuickSightConsole</code>. You cannot choose more than one experience configuraton.</p> </note>', 'refs' => [ 'GenerateEmbedUrlForRegisteredUserRequest$ExperienceConfiguration' => '<p>The experience you are embedding. For registered users, you can embed Amazon QuickSight dashboards or the entire Amazon QuickSight console.</p>', ], ], 'RegisteredUserQuickSightConsoleEmbeddingConfiguration' => [ 'base' => '<p>Information about the Amazon QuickSight console that you want to embed.</p>', 'refs' => [ 'RegisteredUserEmbeddingExperienceConfiguration$QuickSightConsole' => '<p>The configuration details for providing an Amazon QuickSight console embedding experience. This can be used along with custom permissions to restrict access to certain features. For more information, see <a href="https://docs.aws.amazon.com/quicksight/latest/user/customizing-permissions-to-the-quicksight-console.html">Customizing Access to the Amazon QuickSight Console</a> in the <i>Amazon QuickSight User Guide</i>.</p> <p>Use <code>GenerateEmbedUrlForRegisteredUser</code> where you want to provide an authoring portal that allows users to create data sources, datasets, analyses, and dashboards. The users who accesses an embedded Amazon QuickSight console needs to belong to the author or admin security cohort. If you want to restrict permissions to some of these features, add a custom permissions profile to the user with the <code> <a>UpdateUser</a> </code> API operation. Use <code> <a>RegisterUser</a> </code> API operation to add a new user with a custom permission profile attached. For more information, see the following sections in the <i>Amazon QuickSight User Guide</i>:</p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/quicksight/latest/user/embedded-analytics-full-console-for-authenticated-users.html">Embedding the Full Functionality of the Amazon QuickSight Console for Authenticated Users</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/quicksight/latest/user/customizing-permissions-to-the-quicksight-console.html">Customizing Access to the Amazon QuickSight Console</a> </p> </li> </ul> <p>For more information about the high-level steps for embedding and for an interactive demo of the ways you can customize embedding, visit the <a href="https://docs.aws.amazon.com/quicksight/latest/user/quicksight-dev-portal.html">Amazon QuickSight Developer Portal</a>.</p>', ], ], 'RelationalTable' => [ 'base' => '<p>A physical table type for relational data sources.</p>', 'refs' => [ 'PhysicalTable$RelationalTable' => '<p>A physical table type for relational data sources.</p>', ], ], 'RelationalTableCatalog' => [ 'base' => NULL, 'refs' => [ 'RelationalTable$Catalog' => '<p>The catalog associated with a table.</p>', ], ], 'RelationalTableName' => [ 'base' => NULL, 'refs' => [ 'RelationalTable$Name' => '<p>The name of the relational table.</p>', ], ], 'RelationalTableSchema' => [ 'base' => NULL, 'refs' => [ 'RelationalTable$Schema' => '<p>The schema name. This name applies to certain relational database engines.</p>', ], ], 'RenameColumnOperation' => [ 'base' => '<p>A transform operation that renames a column.</p>', 'refs' => [ 'TransformOperation$RenameColumnOperation' => '<p>An operation that renames a column.</p>', ], ], 'ResourceExistsException' => [ 'base' => '<p>The resource specified already exists. </p>', 'refs' => [], ], 'ResourceId' => [ 'base' => NULL, 'refs' => [ 'CreateDataSetRequest$DataSetId' => '<p>An ID for the dataset that you want to create. This ID is unique per Amazon Web Services Region; for each Amazon Web Services account.</p>', 'CreateDataSetResponse$DataSetId' => '<p>The ID for the dataset that you want to create. This ID is unique per Amazon Web Services Region; for each Amazon Web Services account.</p>', 'CreateDataSetResponse$IngestionId' => '<p>The ID of the ingestion, which is triggered as a result of dataset creation if the import mode is SPICE.</p>', 'CreateDataSourceRequest$DataSourceId' => '<p>An ID for the data source. This ID is unique per Amazon Web Services Region; for each Amazon Web Services account. </p>', 'CreateDataSourceResponse$DataSourceId' => '<p>The ID of the data source. This ID is unique per Amazon Web Services Region; for each Amazon Web Services account.</p>', 'DataSet$DataSetId' => '<p>The ID of the dataset.</p>', 'DataSetSummary$DataSetId' => '<p>The ID of the dataset.</p>', 'DataSource$DataSourceId' => '<p>The ID of the data source. This ID is unique per Amazon Web Services Region; for each Amazon Web Services account.</p>', 'DeleteDataSetRequest$DataSetId' => '<p>The ID for the dataset that you want to create. This ID is unique per Amazon Web Services Region; for each Amazon Web Services account.</p>', 'DeleteDataSetResponse$DataSetId' => '<p>The ID for the dataset that you want to create. This ID is unique per Amazon Web Services Region; for each Amazon Web Services account.</p>', 'DeleteDataSourceRequest$DataSourceId' => '<p>The ID of the data source. This ID is unique per Amazon Web Services Region; for each Amazon Web Services account.</p>', 'DeleteDataSourceResponse$DataSourceId' => '<p>The ID of the data source. This ID is unique per Amazon Web Services Region; for each Amazon Web Services account.</p>', 'DescribeDataSetPermissionsRequest$DataSetId' => '<p>The ID for the dataset that you want to create. This ID is unique per Amazon Web Services Region; for each Amazon Web Services account.</p>', 'DescribeDataSetPermissionsResponse$DataSetId' => '<p>The ID for the dataset that you want to create. This ID is unique per Amazon Web Services Region; for each Amazon Web Services account.</p>', 'DescribeDataSetRequest$DataSetId' => '<p>The ID for the dataset that you want to create. This ID is unique per Amazon Web Services Region; for each Amazon Web Services account.</p>', 'DescribeDataSourcePermissionsRequest$DataSourceId' => '<p>The ID of the data source. This ID is unique per Amazon Web Services Region; for each Amazon Web Services account.</p>', 'DescribeDataSourcePermissionsResponse$DataSourceId' => '<p>The ID of the data source. This ID is unique per Amazon Web Services Region; for each Amazon Web Services account.</p>', 'DescribeDataSourceRequest$DataSourceId' => '<p>The ID of the data source. This ID is unique per Amazon Web Services Region; for each Amazon Web Services account.</p>', 'UpdateDataSetPermissionsRequest$DataSetId' => '<p>The ID for the dataset whose permissions you want to update. This ID is unique per Amazon Web Services Region; for each Amazon Web Services account.</p>', 'UpdateDataSetPermissionsResponse$DataSetId' => '<p>The ID for the dataset whose permissions you want to update. This ID is unique per Amazon Web Services Region; for each Amazon Web Services account.</p>', 'UpdateDataSetRequest$DataSetId' => '<p>The ID for the dataset that you want to update. This ID is unique per Amazon Web Services Region; for each Amazon Web Services account.</p>', 'UpdateDataSetResponse$DataSetId' => '<p>The ID for the dataset that you want to create. This ID is unique per Amazon Web Services Region; for each Amazon Web Services account.</p>', 'UpdateDataSetResponse$IngestionId' => '<p>The ID of the ingestion, which is triggered as a result of dataset creation if the import mode is SPICE.</p>', 'UpdateDataSourcePermissionsRequest$DataSourceId' => '<p>The ID of the data source. This ID is unique per Amazon Web Services Region; for each Amazon Web Services account. </p>', 'UpdateDataSourcePermissionsResponse$DataSourceId' => '<p>The ID of the data source. This ID is unique per Amazon Web Services Region; for each Amazon Web Services account.</p>', 'UpdateDataSourceRequest$DataSourceId' => '<p>The ID of the data source. This ID is unique per Amazon Web Services Region; for each Amazon Web Services account. </p>', 'UpdateDataSourceResponse$DataSourceId' => '<p>The ID of the data source. This ID is unique per Amazon Web Services Region; for each Amazon Web Services account.</p>', ], ], 'ResourceName' => [ 'base' => NULL, 'refs' => [ 'CreateDataSetRequest$Name' => '<p>The display name for the dataset.</p>', 'CreateDataSourceRequest$Name' => '<p>A display name for the data source.</p>', 'DataSet$Name' => '<p>A display name for the dataset.</p>', 'DataSetSummary$Name' => '<p>A display name for the dataset.</p>', 'DataSource$Name' => '<p>A display name for the data source.</p>', 'UpdateDataSetRequest$Name' => '<p>The display name for the dataset.</p>', 'UpdateDataSourceRequest$Name' => '<p>A display name for the data source.</p>', ], ], 'ResourceNotFoundException' => [ 'base' => '<p>One or more resources can\'t be found.</p>', 'refs' => [], ], 'ResourcePermission' => [ 'base' => '<p>Permission for the resource.</p>', 'refs' => [ 'ResourcePermissionList$member' => NULL, 'UpdateResourcePermissionList$member' => NULL, ], ], 'ResourcePermissionList' => [ 'base' => NULL, 'refs' => [ 'CreateAnalysisRequest$Permissions' => '<p>A structure that describes the principals and the resource-level permissions on an analysis. You can use the <code>Permissions</code> structure to grant permissions by providing a list of Identity and Access Management (IAM) action information for each principal listed by Amazon Resource Name (ARN). </p> <p>To specify no permissions, omit <code>Permissions</code>.</p>', 'CreateDashboardRequest$Permissions' => '<p>A structure that contains the permissions of the dashboard. You can use this structure for granting permissions by providing a list of IAMaction information for each principal ARN. </p> <p>To specify no permissions, omit the permissions list.</p>', 'CreateDataSetRequest$Permissions' => '<p>A list of resource permissions on the dataset.</p>', 'CreateDataSourceRequest$Permissions' => '<p>A list of resource permissions on the data source.</p>', 'CreateFolderRequest$Permissions' => '<p>A structure that describes the principals and the resource-level permissions of a folder.</p> <p>To specify no permissions, omit <code>Permissions</code>.</p>', 'CreateTemplateRequest$Permissions' => '<p>A list of resource permissions to be set on the template. </p>', 'CreateThemeRequest$Permissions' => '<p>A valid grouping of resource permissions to apply to the new theme. </p>', 'DescribeAnalysisPermissionsResponse$Permissions' => '<p>A structure that describes the principals and the resource-level permissions on an analysis.</p>', 'DescribeDashboardPermissionsResponse$Permissions' => '<p>A structure that contains the permissions for the dashboard.</p>', 'DescribeDataSetPermissionsResponse$Permissions' => '<p>A list of resource permissions on the dataset.</p>', 'DescribeDataSourcePermissionsResponse$Permissions' => '<p>A list of resource permissions on the data source.</p>', 'DescribeFolderPermissionsResponse$Permissions' => '<p>Information about the permissions on the folder.</p>', 'DescribeFolderResolvedPermissionsResponse$Permissions' => '<p>Information about the permissions on the dashboard.</p>', 'DescribeTemplatePermissionsResponse$Permissions' => '<p>A list of resource permissions to be set on the template. </p>', 'DescribeThemePermissionsResponse$Permissions' => '<p>A list of resource permissions set on the theme. </p>', 'UpdateAnalysisPermissionsResponse$Permissions' => '<p>A structure that describes the principals and the resource-level permissions on an analysis.</p>', 'UpdateDashboardPermissionsResponse$Permissions' => '<p>Information about the permissions on the dashboard.</p>', 'UpdateDataSetPermissionsRequest$GrantPermissions' => '<p>The resource permissions that you want to grant to the dataset.</p>', 'UpdateDataSetPermissionsRequest$RevokePermissions' => '<p>The resource permissions that you want to revoke from the dataset.</p>', 'UpdateDataSourcePermissionsRequest$GrantPermissions' => '<p>A list of resource permissions that you want to grant on the data source.</p>', 'UpdateDataSourcePermissionsRequest$RevokePermissions' => '<p>A list of resource permissions that you want to revoke on the data source.</p>', 'UpdateFolderPermissionsRequest$GrantPermissions' => '<p>The permissions that you want to grant on a resource.</p>', 'UpdateFolderPermissionsRequest$RevokePermissions' => '<p>The permissions that you want to revoke from a resource.</p>', 'UpdateFolderPermissionsResponse$Permissions' => '<p>Information about the permissions on the dashboard.</p>', 'UpdateTemplatePermissionsResponse$Permissions' => '<p>A list of resource permissions to be set on the template.</p>', 'UpdateThemePermissionsResponse$Permissions' => '<p>The resulting list of resource permissions for the theme.</p>', ], ], 'ResourceStatus' => [ 'base' => NULL, 'refs' => [ 'Analysis$Status' => '<p>Status associated with the analysis.</p>', 'AnalysisSummary$Status' => '<p>The last known status for the analysis.</p>', 'CreateAnalysisResponse$CreationStatus' => '<p>The status of the creation of the analysis. </p>', 'CreateDashboardResponse$CreationStatus' => '<p>The status of the dashboard creation request.</p>', 'CreateDataSourceResponse$CreationStatus' => '<p>The status of creating the data source.</p>', 'CreateTemplateResponse$CreationStatus' => '<p>The template creation status.</p>', 'CreateThemeResponse$CreationStatus' => '<p>The theme creation status.</p>', 'DashboardVersion$Status' => '<p>The HTTP status of the request.</p>', 'DashboardVersionSummary$Status' => '<p>The HTTP status of the request.</p>', 'DataSource$Status' => '<p>The HTTP status of the request.</p>', 'TemplateVersion$Status' => '<p>The HTTP status of the request.</p>', 'TemplateVersionSummary$Status' => '<p>The status of the template version.</p>', 'ThemeVersion$Status' => '<p>The status of the theme version.</p>', 'ThemeVersionSummary$Status' => '<p>The status of the theme version.</p>', 'UpdateAnalysisResponse$UpdateStatus' => '<p>The update status of the last update that was made to the analysis.</p>', 'UpdateDashboardResponse$CreationStatus' => '<p>The creation status of the request.</p>', 'UpdateDataSourceResponse$UpdateStatus' => '<p>The update status of the data source\'s last update.</p>', 'UpdateTemplateResponse$CreationStatus' => '<p>The creation status of the template.</p>', 'UpdateThemeResponse$CreationStatus' => '<p>The creation status of the theme.</p>', ], ], 'ResourceUnavailableException' => [ 'base' => '<p>This resource is currently unavailable.</p>', 'refs' => [], ], 'RestoreAnalysisRequest' => [ 'base' => NULL, 'refs' => [], ], 'RestoreAnalysisResponse' => [ 'base' => NULL, 'refs' => [], ], 'RestrictiveResourceId' => [ 'base' => NULL, 'refs' => [ 'AdditionalDashboardIdList$member' => NULL, 'Analysis$AnalysisId' => '<p>The ID of the analysis.</p>', 'AnalysisSummary$AnalysisId' => '<p>The ID of the analysis. This ID displays in the URL.</p>', 'AnonymousUserDashboardEmbeddingConfiguration$InitialDashboardId' => '<p>The dashboard ID for the dashboard that you want the user to see first. This ID is included in the output URL. When the URL in response is accessed, Amazon QuickSight renders this dashboard.</p> <p>The Amazon Resource Name (ARN) of this dashboard must be included in the <code>AuthorizedResourceArns</code> parameter. Otherwise, the request will fail with <code>InvalidParameterValueException</code>.</p>', 'CreateAnalysisRequest$AnalysisId' => '<p>The ID for the analysis that you\'re creating. This ID displays in the URL of the analysis.</p>', 'CreateAnalysisResponse$AnalysisId' => '<p>The ID of the analysis.</p>', 'CreateDashboardRequest$DashboardId' => '<p>The ID for the dashboard, also added to the IAMpolicy.</p>', 'CreateDashboardResponse$DashboardId' => '<p>The ID for the dashboard.</p>', 'CreateFolderMembershipRequest$FolderId' => '<p>The folder ID.</p>', 'CreateFolderMembershipRequest$MemberId' => '<p>The ID of the asset (the dashboard, analysis, or dataset).</p>', 'CreateFolderRequest$FolderId' => '<p>The folder ID.</p>', 'CreateFolderResponse$FolderId' => '<p>The folder ID for the newly created folder.</p>', 'CreateTemplateAliasRequest$TemplateId' => '<p>An ID for the template.</p>', 'CreateTemplateRequest$TemplateId' => '<p>An ID for the template that you want to create. This template is unique per Amazon Web Services Region; in each Amazon Web Services account.</p>', 'CreateTemplateResponse$TemplateId' => '<p>The ID of the template.</p>', 'CreateThemeAliasRequest$ThemeId' => '<p>An ID for the theme alias.</p>', 'CreateThemeRequest$ThemeId' => '<p>An ID for the theme that you want to create. The theme ID is unique per Amazon Web Services Region in each Amazon Web Services account.</p>', 'CreateThemeRequest$BaseThemeId' => '<p>The ID of the theme that a custom theme will inherit from. All themes inherit from one of the starting themes defined by Amazon QuickSight. For a list of the starting themes, use <code>ListThemes</code> or choose <b>Themes</b> from within a Amazon QuickSight analysis. </p>', 'CreateThemeResponse$ThemeId' => '<p>The ID of the theme.</p>', 'Dashboard$DashboardId' => '<p>Dashboard ID.</p>', 'DashboardSummary$DashboardId' => '<p>Dashboard ID.</p>', 'DeleteAnalysisRequest$AnalysisId' => '<p>The ID of the analysis that you\'re deleting.</p>', 'DeleteAnalysisResponse$AnalysisId' => '<p>The ID of the deleted analysis.</p>', 'DeleteDashboardRequest$DashboardId' => '<p>The ID for the dashboard.</p>', 'DeleteDashboardResponse$DashboardId' => '<p>The ID of the dashboard.</p>', 'DeleteFolderMembershipRequest$FolderId' => '<p>The Folder ID.</p>', 'DeleteFolderMembershipRequest$MemberId' => '<p>The ID of the asset (the dashboard, analysis, or dataset) that you want to delete.</p>', 'DeleteFolderRequest$FolderId' => '<p>The folder ID.</p>', 'DeleteFolderResponse$FolderId' => '<p>The folder ID.</p>', 'DeleteTemplateAliasRequest$TemplateId' => '<p>The ID for the template that the specified alias is for.</p>', 'DeleteTemplateAliasResponse$TemplateId' => '<p>An ID for the template associated with the deletion.</p>', 'DeleteTemplateRequest$TemplateId' => '<p>An ID for the template you want to delete.</p>', 'DeleteTemplateResponse$TemplateId' => '<p>An ID for the template.</p>', 'DeleteThemeAliasRequest$ThemeId' => '<p>The ID for the theme that the specified alias is for.</p>', 'DeleteThemeAliasResponse$ThemeId' => '<p>An ID for the theme associated with the deletion.</p>', 'DeleteThemeRequest$ThemeId' => '<p>An ID for the theme that you want to delete.</p>', 'DeleteThemeResponse$ThemeId' => '<p>An ID for the theme.</p>', 'DescribeAnalysisPermissionsRequest$AnalysisId' => '<p>The ID of the analysis whose permissions you\'re describing. The ID is part of the analysis URL.</p>', 'DescribeAnalysisPermissionsResponse$AnalysisId' => '<p>The ID of the analysis whose permissions you\'re describing.</p>', 'DescribeAnalysisRequest$AnalysisId' => '<p>The ID of the analysis that you\'re describing. The ID is part of the URL of the analysis.</p>', 'DescribeDashboardPermissionsRequest$DashboardId' => '<p>The ID for the dashboard, also added to the IAMpolicy.</p>', 'DescribeDashboardPermissionsResponse$DashboardId' => '<p>The ID for the dashboard.</p>', 'DescribeDashboardRequest$DashboardId' => '<p>The ID for the dashboard.</p>', 'DescribeFolderPermissionsRequest$FolderId' => '<p>The folder ID.</p>', 'DescribeFolderPermissionsResponse$FolderId' => '<p>The folder ID.</p>', 'DescribeFolderRequest$FolderId' => '<p>The folder ID.</p>', 'DescribeFolderResolvedPermissionsRequest$FolderId' => '<p>The folder ID.</p>', 'DescribeFolderResolvedPermissionsResponse$FolderId' => '<p>The folder ID.</p>', 'DescribeTemplateAliasRequest$TemplateId' => '<p>The ID for the template.</p>', 'DescribeTemplatePermissionsRequest$TemplateId' => '<p>The ID for the template.</p>', 'DescribeTemplatePermissionsResponse$TemplateId' => '<p>The ID for the template.</p>', 'DescribeTemplateRequest$TemplateId' => '<p>The ID for the template.</p>', 'DescribeThemeAliasRequest$ThemeId' => '<p>The ID for the theme.</p>', 'DescribeThemePermissionsRequest$ThemeId' => '<p>The ID for the theme that you want to describe permissions for.</p>', 'DescribeThemePermissionsResponse$ThemeId' => '<p>The ID for the theme.</p>', 'DescribeThemeRequest$ThemeId' => '<p>The ID for the theme.</p>', 'Folder$FolderId' => '<p>The folder ID.</p>', 'FolderMember$MemberId' => '<p>The ID of the asset.</p>', 'FolderSummary$FolderId' => '<p>The folder ID.</p>', 'GetDashboardEmbedUrlRequest$DashboardId' => '<p>The ID for the dashboard, also added to the Identity and Access Management (IAM) policy.</p>', 'ListDashboardVersionsRequest$DashboardId' => '<p>The ID for the dashboard.</p>', 'ListFolderMembersRequest$FolderId' => '<p>The folder ID.</p>', 'ListTemplateAliasesRequest$TemplateId' => '<p>The ID for the template.</p>', 'ListTemplateVersionsRequest$TemplateId' => '<p>The ID for the template.</p>', 'ListThemeAliasesRequest$ThemeId' => '<p>The ID for the theme.</p>', 'ListThemeVersionsRequest$ThemeId' => '<p>The ID for the theme.</p>', 'MemberIdArnPair$MemberId' => '<p>The ID of the member.</p>', 'RegisteredUserDashboardEmbeddingConfiguration$InitialDashboardId' => '<p>The dashboard ID for the dashboard that you want the user to see first. This ID is included in the output URL. When the URL in response is accessed, Amazon QuickSight renders this dashboard if the user has permissions to view it.</p> <p>If the user does not have permission to view this dashboard, they see a permissions error message.</p>', 'RestoreAnalysisRequest$AnalysisId' => '<p>The ID of the analysis that you\'re restoring.</p>', 'RestoreAnalysisResponse$AnalysisId' => '<p>The ID of the analysis that you\'re restoring. </p>', 'Sheet$SheetId' => '<p>The unique identifier associated with a sheet.</p>', 'Template$TemplateId' => '<p>The ID for the template. This is unique per Amazon Web Services Region; for each Amazon Web Services account.</p>', 'TemplateSummary$TemplateId' => '<p>The ID of the template. This ID is unique per Amazon Web Services Region; for each Amazon Web Services account.</p>', 'Theme$ThemeId' => '<p>The identifier that the user gives to the theme.</p>', 'ThemeSummary$ThemeId' => '<p>The ID of the theme. This ID is unique per Amazon Web Services Region; for each Amazon Web Services account.</p>', 'ThemeVersion$BaseThemeId' => '<p>The Amazon QuickSight-defined ID of the theme that a custom theme inherits from. All themes initially inherit from a default Amazon QuickSight theme.</p>', 'UpdateAnalysisPermissionsRequest$AnalysisId' => '<p>The ID of the analysis whose permissions you\'re updating. The ID is part of the analysis URL.</p>', 'UpdateAnalysisPermissionsResponse$AnalysisId' => '<p>The ID of the analysis that you updated permissions for.</p>', 'UpdateAnalysisRequest$AnalysisId' => '<p>The ID for the analysis that you\'re updating. This ID displays in the URL of the analysis.</p>', 'UpdateAnalysisResponse$AnalysisId' => '<p>The ID of the analysis.</p>', 'UpdateDashboardPermissionsRequest$DashboardId' => '<p>The ID for the dashboard.</p>', 'UpdateDashboardPermissionsResponse$DashboardId' => '<p>The ID for the dashboard.</p>', 'UpdateDashboardPublishedVersionRequest$DashboardId' => '<p>The ID for the dashboard.</p>', 'UpdateDashboardPublishedVersionResponse$DashboardId' => '<p>The ID for the dashboard.</p>', 'UpdateDashboardRequest$DashboardId' => '<p>The ID for the dashboard.</p>', 'UpdateDashboardResponse$DashboardId' => '<p>The ID for the dashboard.</p>', 'UpdateFolderPermissionsRequest$FolderId' => '<p>The folder ID.</p>', 'UpdateFolderPermissionsResponse$FolderId' => '<p>The folder ID.</p>', 'UpdateFolderRequest$FolderId' => '<p>The folder ID.</p>', 'UpdateFolderResponse$FolderId' => '<p>The folder ID.</p>', 'UpdateTemplateAliasRequest$TemplateId' => '<p>The ID for the template.</p>', 'UpdateTemplatePermissionsRequest$TemplateId' => '<p>The ID for the template.</p>', 'UpdateTemplatePermissionsResponse$TemplateId' => '<p>The ID for the template.</p>', 'UpdateTemplateRequest$TemplateId' => '<p>The ID for the template.</p>', 'UpdateTemplateResponse$TemplateId' => '<p>The ID for the template.</p>', 'UpdateThemeAliasRequest$ThemeId' => '<p>The ID for the theme.</p>', 'UpdateThemePermissionsRequest$ThemeId' => '<p>The ID for the theme.</p>', 'UpdateThemePermissionsResponse$ThemeId' => '<p>The ID for the theme.</p>', 'UpdateThemeRequest$ThemeId' => '<p>The ID for the theme.</p>', 'UpdateThemeRequest$BaseThemeId' => '<p>The theme ID, defined by Amazon QuickSight, that a custom theme inherits from. All themes initially inherit from a default Amazon QuickSight theme.</p>', 'UpdateThemeResponse$ThemeId' => '<p>The ID for the theme.</p>', ], ], 'RoleName' => [ 'base' => NULL, 'refs' => [ 'RegisterUserRequest$CustomPermissionsName' => '<p>(Enterprise edition only) The name of the custom permissions profile that you want to assign to this user. Customized permissions allows you to control a user\'s access by restricting access the following operations:</p> <ul> <li> <p>Create and update data sources</p> </li> <li> <p>Create and update datasets</p> </li> <li> <p>Create and update email reports</p> </li> <li> <p>Subscribe to email reports</p> </li> </ul> <p>To add custom permissions to an existing user, use <code> <a>UpdateUser</a> </code> instead.</p> <p>A set of custom permissions includes any combination of these restrictions. Currently, you need to create the profile names for custom permission sets by using the Amazon QuickSight console. Then, you use the <code>RegisterUser</code> API operation to assign the named set of permissions to a Amazon QuickSight user. </p> <p>Amazon QuickSight custom permissions are applied through IAMpolicies. Therefore, they override the permissions typically granted by assigning Amazon QuickSight users to one of the default security cohorts in Amazon QuickSight (admin, author, reader).</p> <p>This feature is available only to Amazon QuickSight Enterprise edition subscriptions.</p>', 'UpdateUserRequest$CustomPermissionsName' => '<p>(Enterprise edition only) The name of the custom permissions profile that you want to assign to this user. Customized permissions allows you to control a user\'s access by restricting access the following operations:</p> <ul> <li> <p>Create and update data sources</p> </li> <li> <p>Create and update datasets</p> </li> <li> <p>Create and update email reports</p> </li> <li> <p>Subscribe to email reports</p> </li> </ul> <p>A set of custom permissions includes any combination of these restrictions. Currently, you need to create the profile names for custom permission sets by using the Amazon QuickSight console. Then, you use the <code>RegisterUser</code> API operation to assign the named set of permissions to a Amazon QuickSight user. </p> <p>Amazon QuickSight custom permissions are applied through IAMpolicies. Therefore, they override the permissions typically granted by assigning Amazon QuickSight users to one of the default security cohorts in Amazon QuickSight (admin, author, reader).</p> <p>This feature is available only to Amazon QuickSight Enterprise edition subscriptions.</p>', 'User$CustomPermissionsName' => '<p>The custom permissions profile associated with this user.</p>', ], ], 'RoleSessionName' => [ 'base' => NULL, 'refs' => [ 'RegisterUserRequest$SessionName' => '<p>You need to use this parameter only when you register one or more users using an assumed IAMrole. You don\'t need to provide the session name for other scenarios, for example when you are registering an IAMuser or an Amazon QuickSight user. You can register multiple users using the same IAMrole if each user has a different session name. For more information on assuming IAMroles, see <a href="https://docs.aws.amazon.com/cli/latest/reference/sts/assume-role.html"> <code>assume-role</code> </a> in the <i>AWS CLI Reference.</i> </p>', ], ], 'RowInfo' => [ 'base' => '<p>Information about rows for a data set SPICE ingestion.</p>', 'refs' => [ 'Ingestion$RowInfo' => NULL, ], ], 'RowLevelPermissionDataSet' => [ 'base' => '<p>Information about a dataset that contains permissions for row-level security (RLS). The permissions dataset maps fields to users or groups. For more information, see <a href="https://docs.aws.amazon.com/quicksight/latest/user/restrict-access-to-a-data-set-using-row-level-security.html">Using Row-Level Security (RLS) to Restrict Access to a Dataset</a> in the <i>Amazon QuickSight User Guide</i>.</p> <p>The option to deny permissions by setting <code>PermissionPolicy</code> to <code>DENY_ACCESS</code> is not supported for new RLS datasets.</p>', 'refs' => [ 'CreateDataSetRequest$RowLevelPermissionDataSet' => '<p>The row-level security configuration for the data that you want to create.</p>', 'DataSet$RowLevelPermissionDataSet' => '<p>The row-level security configuration for the dataset.</p>', 'DataSetSummary$RowLevelPermissionDataSet' => '<p>The row-level security configuration for the dataset.</p>', 'UpdateDataSetRequest$RowLevelPermissionDataSet' => '<p>The row-level security configuration for the data you want to create.</p>', ], ], 'RowLevelPermissionFormatVersion' => [ 'base' => NULL, 'refs' => [ 'RowLevelPermissionDataSet$FormatVersion' => '<p>The user or group rules associated with the dataset that contains permissions for RLS.</p> <p>By default, <code>FormatVersion</code> is <code>VERSION_1</code>. When <code>FormatVersion</code> is <code>VERSION_1</code>, <code>UserName</code> and <code>GroupName</code> are required. When <code>FormatVersion</code> is <code>VERSION_2</code>, <code>UserARN</code> and <code>GroupARN</code> are required, and <code>Namespace</code> must not exist.</p>', ], ], 'RowLevelPermissionPolicy' => [ 'base' => NULL, 'refs' => [ 'RowLevelPermissionDataSet$PermissionPolicy' => '<p>The type of permissions to use when interpreting the permissions for RLS. <code>DENY_ACCESS</code> is included for backward compatibility only.</p>', ], ], 'RowLevelPermissionTagConfiguration' => [ 'base' => '<p>The configuration of tags on a dataset to set row-level security. </p>', 'refs' => [ 'CreateDataSetRequest$RowLevelPermissionTagConfiguration' => '<p>The configuration of tags on a dataset to set row-level security. Row-level security tags are currently supported for anonymous embedding only.</p>', 'DataSet$RowLevelPermissionTagConfiguration' => '<p>The element you can use to define tags for row-level security.</p>', 'UpdateDataSetRequest$RowLevelPermissionTagConfiguration' => '<p>The configuration of tags on a dataset to set row-level security. Row-level security tags are currently supported for anonymous embedding only.</p>', ], ], 'RowLevelPermissionTagDelimiter' => [ 'base' => NULL, 'refs' => [ 'RowLevelPermissionTagRule$TagMultiValueDelimiter' => '<p>A string that you want to use to delimit the values when you pass the values at run time. For example, you can delimit the values with a comma.</p>', ], ], 'RowLevelPermissionTagRule' => [ 'base' => '<p>A set of rules associated with a tag.</p>', 'refs' => [ 'RowLevelPermissionTagRuleList$member' => NULL, ], ], 'RowLevelPermissionTagRuleList' => [ 'base' => NULL, 'refs' => [ 'RowLevelPermissionTagConfiguration$TagRules' => '<p>A set of rules associated with row-level security, such as the tag names and columns that they are assigned to.</p>', ], ], 'S3Bucket' => [ 'base' => NULL, 'refs' => [ 'ManifestFileLocation$Bucket' => '<p>Amazon S3 bucket.</p>', ], ], 'S3Key' => [ 'base' => NULL, 'refs' => [ 'ManifestFileLocation$Key' => '<p>Amazon S3 key that identifies an object.</p>', ], ], 'S3Parameters' => [ 'base' => '<p>The parameters for S3.</p>', 'refs' => [ 'DataSourceParameters$S3Parameters' => '<p>The parameters for S3.</p>', ], ], 'S3Source' => [ 'base' => '<p>A physical table type for an S3 data source.</p>', 'refs' => [ 'PhysicalTable$S3Source' => '<p>A physical table type for as S3 data source.</p>', ], ], 'SearchAnalysesRequest' => [ 'base' => NULL, 'refs' => [], ], 'SearchAnalysesResponse' => [ 'base' => NULL, 'refs' => [], ], 'SearchDashboardsRequest' => [ 'base' => NULL, 'refs' => [], ], 'SearchDashboardsResponse' => [ 'base' => NULL, 'refs' => [], ], 'SearchFoldersRequest' => [ 'base' => NULL, 'refs' => [], ], 'SearchFoldersResponse' => [ 'base' => NULL, 'refs' => [], ], 'ServiceNowParameters' => [ 'base' => '<p>The parameters for ServiceNow.</p>', 'refs' => [ 'DataSourceParameters$ServiceNowParameters' => '<p>The parameters for ServiceNow.</p>', ], ], 'SessionLifetimeInMinutes' => [ 'base' => NULL, 'refs' => [ 'GenerateEmbedUrlForAnonymousUserRequest$SessionLifetimeInMinutes' => '<p>How many minutes the session is valid. The session lifetime must be in [15-600] minutes range.</p>', 'GenerateEmbedUrlForRegisteredUserRequest$SessionLifetimeInMinutes' => '<p>How many minutes the session is valid. The session lifetime must be in [15-600] minutes range.</p>', 'GetDashboardEmbedUrlRequest$SessionLifetimeInMinutes' => '<p>How many minutes the session is valid. The session lifetime must be 15-600 minutes.</p>', 'GetSessionEmbedUrlRequest$SessionLifetimeInMinutes' => '<p>How many minutes the session is valid. The session lifetime must be 15-600 minutes.</p>', ], ], 'SessionLifetimeInMinutesInvalidException' => [ 'base' => '<p>The number of minutes specified for the lifetime of a session isn\'t valid. The session lifetime must be 15-600 minutes.</p>', 'refs' => [], ], 'SessionTag' => [ 'base' => '<p>The key-value pair used for the row-level security tags feature.</p>', 'refs' => [ 'SessionTagList$member' => NULL, ], ], 'SessionTagKey' => [ 'base' => NULL, 'refs' => [ 'RowLevelPermissionTagRule$TagKey' => '<p>The unique key for a tag.</p>', 'SessionTag$Key' => '<p>The key for the tag.</p>', ], ], 'SessionTagList' => [ 'base' => NULL, 'refs' => [ 'GenerateEmbedUrlForAnonymousUserRequest$SessionTags' => '<p>The session tags used for row-level security. Before you use this parameter, make sure that you have configured the relevant datasets using the <code>DataSet$RowLevelPermissionTagConfiguration</code> parameter so that session tags can be used to provide row-level security.</p> <p>These are not the tags used for the Amazon Web Services resource tagging feature. For more information, see <a href="https://docs.aws.amazon.com/quicksight/latest/user/quicksight-dev-rls-tags.html">Using Row-Level Security (RLS) with Tags</a>.</p>', ], ], 'SessionTagValue' => [ 'base' => NULL, 'refs' => [ 'RowLevelPermissionTagRule$MatchAllValue' => '<p>A string that you want to use to filter by all the values in a column in the dataset and don’t want to list the values one by one. For example, you can use an asterisk as your match all value.</p>', 'SessionTag$Value' => '<p>The value that you want to assign the tag.</p>', ], ], 'Sheet' => [ 'base' => '<p>A <i>sheet</i>, which is an object that contains a set of visuals that are viewed together on one page in Amazon QuickSight. Every analysis and dashboard contains at least one sheet. Each sheet contains at least one visualization widget, for example a chart, pivot table, or narrative insight. Sheets can be associated with other components, such as controls, filters, and so on.</p>', 'refs' => [ 'SheetList$member' => NULL, ], ], 'SheetControlsOption' => [ 'base' => '<p>Sheet controls option.</p>', 'refs' => [ 'DashboardPublishOptions$SheetControlsOption' => '<p>Sheet controls option.</p>', ], ], 'SheetList' => [ 'base' => NULL, 'refs' => [ 'Analysis$Sheets' => '<p>A list of the associated sheets with the unique identifier and name of each sheet.</p>', 'DashboardVersion$Sheets' => '<p>A list of the associated sheets with the unique identifier and name of each sheet.</p>', 'TemplateVersion$Sheets' => '<p>A list of the associated sheets with the unique identifier and name of each sheet.</p>', ], ], 'SheetStyle' => [ 'base' => '<p>The theme display options for sheets. </p>', 'refs' => [ 'ThemeConfiguration$Sheet' => '<p>Display options related to sheets.</p>', ], ], 'SiteBaseUrl' => [ 'base' => NULL, 'refs' => [ 'JiraParameters$SiteBaseUrl' => '<p>The base URL of the Jira site.</p>', 'ServiceNowParameters$SiteBaseUrl' => '<p>URL of the base site.</p>', ], ], 'SnowflakeParameters' => [ 'base' => '<p>The parameters for Snowflake.</p>', 'refs' => [ 'DataSourceParameters$SnowflakeParameters' => '<p>The parameters for Snowflake.</p>', ], ], 'SparkParameters' => [ 'base' => '<p>The parameters for Spark.</p>', 'refs' => [ 'DataSourceParameters$SparkParameters' => '<p>The parameters for Spark.</p>', ], ], 'SqlQuery' => [ 'base' => NULL, 'refs' => [ 'CustomSql$SqlQuery' => '<p>The SQL query.</p>', ], ], 'SqlServerParameters' => [ 'base' => '<p>The parameters for SQL Server.</p>', 'refs' => [ 'DataSourceParameters$SqlServerParameters' => '<p>The parameters for SQL Server.</p>', ], ], 'SslProperties' => [ 'base' => '<p>Secure Socket Layer (SSL) properties that apply when Amazon QuickSight connects to your underlying data source.</p>', 'refs' => [ 'CreateDataSourceRequest$SslProperties' => '<p>Secure Socket Layer (SSL) properties that apply when Amazon QuickSight connects to your underlying source.</p>', 'DataSource$SslProperties' => '<p>Secure Socket Layer (SSL) properties that apply when Amazon QuickSight connects to your underlying source.</p>', 'UpdateDataSourceRequest$SslProperties' => '<p>Secure Socket Layer (SSL) properties that apply when Amazon QuickSight connects to your underlying source.</p>', ], ], 'Status' => [ 'base' => NULL, 'refs' => [ 'RowLevelPermissionDataSet$Status' => '<p>The status of the row-level security permission dataset. If enabled, the status is <code>ENABLED</code>. If disabled, the status is <code>DISABLED</code>.</p>', 'RowLevelPermissionTagConfiguration$Status' => '<p>The status of row-level security tags. If enabled, the status is <code>ENABLED</code>. If disabled, the status is <code>DISABLED</code>.</p>', ], ], 'StatusCode' => [ 'base' => NULL, 'refs' => [ 'CancelIngestionResponse$Status' => '<p>The HTTP status of the request.</p>', 'CreateAccountCustomizationResponse$Status' => '<p>The HTTP status of the request.</p>', 'CreateAnalysisResponse$Status' => '<p>The HTTP status of the request.</p>', 'CreateDashboardResponse$Status' => '<p>The HTTP status of the request.</p>', 'CreateDataSetResponse$Status' => '<p>The HTTP status of the request.</p>', 'CreateDataSourceResponse$Status' => '<p>The HTTP status of the request.</p>', 'CreateFolderMembershipResponse$Status' => '<p>The status of the folder membership. If succeeded, the status is <code>SC_OK (200)</code>.</p>', 'CreateFolderResponse$Status' => '<p>The status of the newly created folder. If succeeded, the status is <code>SC_OK (200)</code>.</p>', 'CreateGroupMembershipResponse$Status' => '<p>The HTTP status of the request.</p>', 'CreateGroupResponse$Status' => '<p>The HTTP status of the request.</p>', 'CreateIAMPolicyAssignmentResponse$Status' => '<p>The HTTP status of the request.</p>', 'CreateIngestionResponse$Status' => '<p>The HTTP status of the request.</p>', 'CreateNamespaceResponse$Status' => '<p>The HTTP status of the request.</p>', 'CreateTemplateAliasResponse$Status' => '<p>The HTTP status of the request.</p>', 'CreateTemplateResponse$Status' => '<p>The HTTP status of the request.</p>', 'CreateThemeAliasResponse$Status' => '<p>The HTTP status of the request.</p>', 'CreateThemeResponse$Status' => '<p>The HTTP status of the request.</p>', 'DeleteAccountCustomizationResponse$Status' => '<p>The HTTP status of the request.</p>', 'DeleteAnalysisResponse$Status' => '<p>The HTTP status of the request.</p>', 'DeleteDashboardResponse$Status' => '<p>The HTTP status of the request.</p>', 'DeleteDataSetResponse$Status' => '<p>The HTTP status of the request.</p>', 'DeleteDataSourceResponse$Status' => '<p>The HTTP status of the request.</p>', 'DeleteFolderMembershipResponse$Status' => '<p>The status of deleting the asset. If succeeded, the status is <code>SC_OK (200)</code>.</p>', 'DeleteFolderResponse$Status' => '<p>The status of deleting the folder. If succeeded, the status is <code>SC_OK (200)</code>.</p>', 'DeleteGroupMembershipResponse$Status' => '<p>The HTTP status of the request.</p>', 'DeleteGroupResponse$Status' => '<p>The HTTP status of the request.</p>', 'DeleteIAMPolicyAssignmentResponse$Status' => '<p>The HTTP status of the request.</p>', 'DeleteNamespaceResponse$Status' => '<p>The HTTP status of the request.</p>', 'DeleteTemplateAliasResponse$Status' => '<p>The HTTP status of the request.</p>', 'DeleteTemplateResponse$Status' => '<p>The HTTP status of the request.</p>', 'DeleteThemeAliasResponse$Status' => '<p>The HTTP status of the request.</p>', 'DeleteThemeResponse$Status' => '<p>The HTTP status of the request.</p>', 'DeleteUserByPrincipalIdResponse$Status' => '<p>The HTTP status of the request.</p>', 'DeleteUserResponse$Status' => '<p>The HTTP status of the request.</p>', 'DescribeAccountCustomizationResponse$Status' => '<p>The HTTP status of the request.</p>', 'DescribeAccountSettingsResponse$Status' => '<p>The HTTP status of the request.</p>', 'DescribeAnalysisPermissionsResponse$Status' => '<p>The HTTP status of the request.</p>', 'DescribeAnalysisResponse$Status' => '<p>The HTTP status of the request.</p>', 'DescribeDashboardPermissionsResponse$Status' => '<p>The HTTP status of the request.</p>', 'DescribeDashboardResponse$Status' => '<p>The HTTP status of this request.</p>', 'DescribeDataSetPermissionsResponse$Status' => '<p>The HTTP status of the request.</p>', 'DescribeDataSetResponse$Status' => '<p>The HTTP status of the request.</p>', 'DescribeDataSourcePermissionsResponse$Status' => '<p>The HTTP status of the request.</p>', 'DescribeDataSourceResponse$Status' => '<p>The HTTP status of the request.</p>', 'DescribeFolderPermissionsResponse$Status' => '<p>The status. If succeeded, the status is <code>SC_OK</code>.</p>', 'DescribeFolderResolvedPermissionsResponse$Status' => '<p>The status. If succeeded, the status is <code>SC_OK</code> </p>', 'DescribeFolderResponse$Status' => '<p>The status. If succeeded, the status is <code>SC_OK (200)</code>.</p>', 'DescribeGroupResponse$Status' => '<p>The HTTP status of the request.</p>', 'DescribeIAMPolicyAssignmentResponse$Status' => '<p>The HTTP status of the request.</p>', 'DescribeIngestionResponse$Status' => '<p>The HTTP status of the request.</p>', 'DescribeNamespaceResponse$Status' => '<p>The HTTP status of the request.</p>', 'DescribeTemplateAliasResponse$Status' => '<p>The HTTP status of the request.</p>', 'DescribeTemplatePermissionsResponse$Status' => '<p>The HTTP status of the request.</p>', 'DescribeTemplateResponse$Status' => '<p>The HTTP status of the request.</p>', 'DescribeThemeAliasResponse$Status' => '<p>The HTTP status of the request.</p>', 'DescribeThemePermissionsResponse$Status' => '<p>The HTTP status of the request.</p>', 'DescribeThemeResponse$Status' => '<p>The HTTP status of the request.</p>', 'DescribeUserResponse$Status' => '<p>The HTTP status of the request.</p>', 'GenerateEmbedUrlForAnonymousUserResponse$Status' => '<p>The HTTP status of the request.</p>', 'GenerateEmbedUrlForRegisteredUserResponse$Status' => '<p>The HTTP status of the request.</p>', 'GetDashboardEmbedUrlResponse$Status' => '<p>The HTTP status of the request.</p>', 'GetSessionEmbedUrlResponse$Status' => '<p>The HTTP status of the request.</p>', 'ListAnalysesResponse$Status' => '<p>The HTTP status of the request.</p>', 'ListDashboardVersionsResponse$Status' => '<p>The HTTP status of the request.</p>', 'ListDashboardsResponse$Status' => '<p>The HTTP status of the request.</p>', 'ListDataSetsResponse$Status' => '<p>The HTTP status of the request.</p>', 'ListDataSourcesResponse$Status' => '<p>The HTTP status of the request.</p>', 'ListFolderMembersResponse$Status' => '<p>The status. If succeeded, the status is <code>SC_OK</code> </p>', 'ListFoldersResponse$Status' => '<p>The status. If succeeded, the status is <code>SC_OK</code> </p>', 'ListGroupMembershipsResponse$Status' => '<p>The HTTP status of the request.</p>', 'ListGroupsResponse$Status' => '<p>The HTTP status of the request.</p>', 'ListIAMPolicyAssignmentsForUserResponse$Status' => '<p>The HTTP status of the request.</p>', 'ListIAMPolicyAssignmentsResponse$Status' => '<p>The HTTP status of the request.</p>', 'ListIngestionsResponse$Status' => '<p>The HTTP status of the request.</p>', 'ListNamespacesResponse$Status' => '<p>The HTTP status of the request.</p>', 'ListTagsForResourceResponse$Status' => '<p>The HTTP status of the request.</p>', 'ListTemplateAliasesResponse$Status' => '<p>The HTTP status of the request.</p>', 'ListTemplateVersionsResponse$Status' => '<p>The HTTP status of the request.</p>', 'ListTemplatesResponse$Status' => '<p>The HTTP status of the request.</p>', 'ListThemeAliasesResponse$Status' => '<p>The HTTP status of the request.</p>', 'ListThemeVersionsResponse$Status' => '<p>The HTTP status of the request.</p>', 'ListThemesResponse$Status' => '<p>The HTTP status of the request.</p>', 'ListUserGroupsResponse$Status' => '<p>The HTTP status of the request.</p>', 'ListUsersResponse$Status' => '<p>The HTTP status of the request.</p>', 'RegisterUserResponse$Status' => '<p>The HTTP status of the request.</p>', 'RestoreAnalysisResponse$Status' => '<p>The HTTP status of the request.</p>', 'SearchAnalysesResponse$Status' => '<p>The HTTP status of the request.</p>', 'SearchDashboardsResponse$Status' => '<p>The HTTP status of the request.</p>', 'SearchFoldersResponse$Status' => '<p>The status. If succeeded, the status is <code>SC_OK</code>.</p>', 'TagResourceResponse$Status' => '<p>The HTTP status of the request.</p>', 'UntagResourceResponse$Status' => '<p>The HTTP status of the request.</p>', 'UpdateAccountCustomizationResponse$Status' => '<p>The HTTP status of the request.</p>', 'UpdateAccountSettingsResponse$Status' => '<p>The HTTP status of the request.</p>', 'UpdateAnalysisPermissionsResponse$Status' => '<p>The HTTP status of the request.</p>', 'UpdateAnalysisResponse$Status' => '<p>The HTTP status of the request.</p>', 'UpdateDashboardPermissionsResponse$Status' => '<p>The HTTP status of the request.</p>', 'UpdateDashboardPublishedVersionResponse$Status' => '<p>The HTTP status of the request.</p>', 'UpdateDashboardResponse$Status' => '<p>The HTTP status of the request.</p>', 'UpdateDataSetPermissionsResponse$Status' => '<p>The HTTP status of the request.</p>', 'UpdateDataSetResponse$Status' => '<p>The HTTP status of the request.</p>', 'UpdateDataSourcePermissionsResponse$Status' => '<p>The HTTP status of the request.</p>', 'UpdateDataSourceResponse$Status' => '<p>The HTTP status of the request.</p>', 'UpdateFolderPermissionsResponse$Status' => '<p>The status. If succeeded, the status is <code>SC_OK</code>.</p>', 'UpdateFolderResponse$Status' => '<p>The status. If succeeded, the status is <code>SC_OK</code>.</p>', 'UpdateGroupResponse$Status' => '<p>The HTTP status of the request.</p>', 'UpdateIAMPolicyAssignmentResponse$Status' => '<p>The HTTP status of the request.</p>', 'UpdateTemplateAliasResponse$Status' => '<p>The HTTP status of the request.</p>', 'UpdateTemplatePermissionsResponse$Status' => '<p>The HTTP status of the request.</p>', 'UpdateTemplateResponse$Status' => '<p>The HTTP status of the request.</p>', 'UpdateThemeAliasResponse$Status' => '<p>The HTTP status of the request.</p>', 'UpdateThemePermissionsResponse$Status' => '<p>The HTTP status of the request.</p>', 'UpdateThemeResponse$Status' => '<p>The HTTP status of the request.</p>', 'UpdateUserResponse$Status' => '<p>The HTTP status of the request.</p>', ], ], 'String' => [ 'base' => NULL, 'refs' => [ 'AccessDeniedException$Message' => NULL, 'AccessDeniedException$RequestId' => '<p>The Amazon Web Services request ID for this request.</p>', 'AccountSettings$AccountName' => '<p>The "account name" you provided for the Amazon QuickSight subscription in your Amazon Web Services account. You create this name when you sign up for Amazon QuickSight. It is unique in all of Amazon Web Services and it appears only when users sign in.</p>', 'AccountSettings$NotificationEmail' => '<p>The main notification email for your Amazon QuickSight subscription.</p>', 'ActionList$member' => NULL, 'AnalysisSearchFilter$Value' => '<p>The value of the named item, in this case <code>QUICKSIGHT_USER</code>, that you want to use as a filter, for example <code>"Value"</code>. An example is <code>"arn:aws:quicksight:us-east-1:1:user/default/UserName1"</code>.</p>', 'ColumnGroupColumnSchema$Name' => '<p>The name of the column group\'s column schema.</p>', 'ColumnGroupSchema$Name' => '<p>The name of the column group schema.</p>', 'ColumnNameList$member' => NULL, 'ColumnSchema$Name' => '<p>The name of the column schema.</p>', 'ColumnSchema$DataType' => '<p>The data type of the column schema.</p>', 'ColumnSchema$GeographicRole' => '<p>The geographic role of the column schema.</p>', 'ConcurrentUpdatingException$Message' => NULL, 'ConcurrentUpdatingException$RequestId' => NULL, 'ConflictException$Message' => NULL, 'ConflictException$RequestId' => '<p>The Amazon Web Services request ID for this request.</p>', 'CreateAccountCustomizationResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'CreateAnalysisResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'CreateDashboardResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'CreateDataSetResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'CreateDataSourceResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'CreateFolderMembershipResponse$RequestId' => '<p>The request ID.</p>', 'CreateFolderResponse$RequestId' => '<p>The request ID for the newly created folder.</p>', 'CreateGroupMembershipResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'CreateGroupResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'CreateIAMPolicyAssignmentResponse$AssignmentId' => '<p>The ID for the assignment.</p>', 'CreateIAMPolicyAssignmentResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'CreateNamespaceResponse$CapacityRegion' => '<p>The Amazon Web Services Region; that you want to use for the free SPICE capacity for the new namespace. This is set to the region that you run CreateNamespace in. </p>', 'CreateNamespaceResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'CreateTemplateAliasResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'CreateTemplateResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'CreateThemeAliasResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'CreateThemeResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'DashboardSearchFilter$Value' => '<p>The value of the named item, in this case <code>QUICKSIGHT_USER</code>, that you want to use as a filter, for example, <code>"Value": "arn:aws:quicksight:us-east-1:1:user/default/UserName1"</code>. </p>', 'DataSetConfiguration$Placeholder' => '<p>Placeholder.</p>', 'DataSourceErrorInfo$Message' => '<p>Error message.</p>', 'DeleteAccountCustomizationResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'DeleteAnalysisResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'DeleteDashboardResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'DeleteDataSetResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'DeleteDataSourceResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'DeleteFolderMembershipResponse$RequestId' => '<p>The request ID.</p>', 'DeleteFolderResponse$RequestId' => '<p>The request ID.</p>', 'DeleteGroupMembershipResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'DeleteGroupResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'DeleteIAMPolicyAssignmentResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'DeleteNamespaceResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'DeleteTemplateAliasResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'DeleteTemplateResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'DeleteThemeAliasResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'DeleteThemeResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'DeleteUserByPrincipalIdRequest$PrincipalId' => '<p>The principal ID of the user.</p>', 'DeleteUserByPrincipalIdResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'DeleteUserResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'DescribeAccountCustomizationResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'DescribeAccountSettingsResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'DescribeAnalysisPermissionsResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'DescribeAnalysisResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'DescribeDashboardPermissionsResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'DescribeDashboardResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'DescribeDataSetPermissionsResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'DescribeDataSetResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'DescribeDataSourcePermissionsResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'DescribeDataSourceResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'DescribeFolderPermissionsResponse$RequestId' => '<p>The request ID.</p>', 'DescribeFolderResolvedPermissionsResponse$RequestId' => '<p>The request ID.</p>', 'DescribeFolderResponse$RequestId' => '<p>The request ID.</p>', 'DescribeGroupResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'DescribeIAMPolicyAssignmentResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'DescribeNamespaceResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'DescribeTemplateAliasResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'DescribeTemplatePermissionsResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'DescribeTemplateResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'DescribeThemeAliasResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'DescribeThemePermissionsResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'DescribeThemeResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'DescribeUserResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'DomainNotWhitelistedException$Message' => NULL, 'DomainNotWhitelistedException$RequestId' => '<p>The Amazon Web Services request ID for this request.</p>', 'FolderColumnList$member' => NULL, 'FolderSearchFilter$Value' => '<p>The value of the named item (in this example, <code>PARENT_FOLDER_ARN</code>), that you want to use as a filter. For example, <code>"Value": "arn:aws:quicksight:us-east-1:1:folder/folderId"</code>.</p>', 'GenerateEmbedUrlForAnonymousUserResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'GenerateEmbedUrlForRegisteredUserResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'GetDashboardEmbedUrlResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'GetSessionEmbedUrlResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'Group$PrincipalId' => '<p>The principal ID of the group.</p>', 'IAMPolicyAssignment$AssignmentId' => '<p>Assignment ID.</p>', 'IdentityMap$key' => NULL, 'IdentityTypeNotSupportedException$Message' => NULL, 'IdentityTypeNotSupportedException$RequestId' => '<p>The Amazon Web Services request ID for this request.</p>', 'InternalFailureException$Message' => NULL, 'InternalFailureException$RequestId' => '<p>The Amazon Web Services request ID for this request.</p>', 'InvalidNextTokenException$Message' => NULL, 'InvalidNextTokenException$RequestId' => '<p>The Amazon Web Services request ID for this request.</p>', 'InvalidParameterValueException$Message' => NULL, 'InvalidParameterValueException$RequestId' => '<p>The Amazon Web Services request ID for this request.</p>', 'LimitExceededException$Message' => NULL, 'LimitExceededException$RequestId' => '<p>The Amazon Web Services request ID for this request.</p>', 'ListAnalysesRequest$NextToken' => '<p>A pagination token that can be used in a subsequent request.</p>', 'ListAnalysesResponse$NextToken' => '<p>A pagination token that can be used in a subsequent request.</p>', 'ListAnalysesResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'ListDashboardVersionsRequest$NextToken' => '<p>The token for the next set of results, or null if there are no more results.</p>', 'ListDashboardVersionsResponse$NextToken' => '<p>The token for the next set of results, or null if there are no more results.</p>', 'ListDashboardVersionsResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'ListDashboardsRequest$NextToken' => '<p>The token for the next set of results, or null if there are no more results.</p>', 'ListDashboardsResponse$NextToken' => '<p>The token for the next set of results, or null if there are no more results.</p>', 'ListDashboardsResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'ListDataSetsRequest$NextToken' => '<p>The token for the next set of results, or null if there are no more results.</p>', 'ListDataSetsResponse$NextToken' => '<p>The token for the next set of results, or null if there are no more results.</p>', 'ListDataSetsResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'ListDataSourcesRequest$NextToken' => '<p>The token for the next set of results, or null if there are no more results.</p>', 'ListDataSourcesResponse$NextToken' => '<p>The token for the next set of results, or null if there are no more results.</p>', 'ListDataSourcesResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'ListFolderMembersRequest$NextToken' => '<p>The token for the next set of results, or null if there are no more results.</p>', 'ListFolderMembersResponse$NextToken' => '<p>The token for the next set of results, or null if there are no more results.</p>', 'ListFolderMembersResponse$RequestId' => '<p>The request ID.</p>', 'ListFoldersRequest$NextToken' => '<p>The token for the next set of results, or null if there are no more results.</p>', 'ListFoldersResponse$NextToken' => '<p>The token for the next set of results, or null if there are no more results.</p>', 'ListFoldersResponse$RequestId' => '<p>The request ID.</p>', 'ListGroupMembershipsRequest$NextToken' => '<p>A pagination token that can be used in a subsequent request.</p>', 'ListGroupMembershipsResponse$NextToken' => '<p>A pagination token that can be used in a subsequent request.</p>', 'ListGroupMembershipsResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'ListGroupsRequest$NextToken' => '<p>A pagination token that can be used in a subsequent request.</p>', 'ListGroupsResponse$NextToken' => '<p>A pagination token that can be used in a subsequent request.</p>', 'ListGroupsResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'ListIAMPolicyAssignmentsForUserRequest$NextToken' => '<p>The token for the next set of results, or null if there are no more results.</p>', 'ListIAMPolicyAssignmentsForUserResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'ListIAMPolicyAssignmentsForUserResponse$NextToken' => '<p>The token for the next set of results, or null if there are no more results.</p>', 'ListIAMPolicyAssignmentsRequest$NextToken' => '<p>The token for the next set of results, or null if there are no more results.</p>', 'ListIAMPolicyAssignmentsResponse$NextToken' => '<p>The token for the next set of results, or null if there are no more results.</p>', 'ListIAMPolicyAssignmentsResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'ListNamespacesRequest$NextToken' => '<p>A pagination token that can be used in a subsequent request.</p>', 'ListNamespacesResponse$NextToken' => '<p>A pagination token that can be used in a subsequent request.</p>', 'ListNamespacesResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'ListTagsForResourceResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'ListTemplateAliasesRequest$NextToken' => '<p>The token for the next set of results, or null if there are no more results.</p>', 'ListTemplateAliasesResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'ListTemplateAliasesResponse$NextToken' => '<p>The token for the next set of results, or null if there are no more results.</p>', 'ListTemplateVersionsRequest$NextToken' => '<p>The token for the next set of results, or null if there are no more results.</p>', 'ListTemplateVersionsResponse$NextToken' => '<p>The token for the next set of results, or null if there are no more results.</p>', 'ListTemplateVersionsResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'ListTemplatesRequest$NextToken' => '<p>The token for the next set of results, or null if there are no more results.</p>', 'ListTemplatesResponse$NextToken' => '<p>The token for the next set of results, or null if there are no more results.</p>', 'ListTemplatesResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'ListThemeAliasesRequest$NextToken' => '<p>The token for the next set of results, or null if there are no more results.</p>', 'ListThemeAliasesResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'ListThemeAliasesResponse$NextToken' => '<p>The token for the next set of results, or null if there are no more results.</p>', 'ListThemeVersionsRequest$NextToken' => '<p>The token for the next set of results, or null if there are no more results.</p>', 'ListThemeVersionsResponse$NextToken' => '<p>The token for the next set of results, or null if there are no more results.</p>', 'ListThemeVersionsResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'ListThemesRequest$NextToken' => '<p>The token for the next set of results, or null if there are no more results.</p>', 'ListThemesResponse$NextToken' => '<p>The token for the next set of results, or null if there are no more results.</p>', 'ListThemesResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'ListUserGroupsRequest$NextToken' => '<p>A pagination token that can be used in a subsequent request.</p>', 'ListUserGroupsResponse$NextToken' => '<p>A pagination token that can be used in a subsequent request.</p>', 'ListUserGroupsResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'ListUsersRequest$NextToken' => '<p>A pagination token that can be used in a subsequent request.</p>', 'ListUsersResponse$NextToken' => '<p>A pagination token that can be used in a subsequent request.</p>', 'ListUsersResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'NamespaceError$Message' => '<p>The message for the error.</p>', 'NamespaceInfoV2$CapacityRegion' => '<p>The namespace Amazon Web Services Region;.</p>', 'PreconditionNotMetException$Message' => NULL, 'PreconditionNotMetException$RequestId' => '<p>The Amazon Web Services request ID for this request.</p>', 'PrincipalList$member' => NULL, 'ProjectedColumnList$member' => NULL, 'QuickSightUserNotFoundException$Message' => NULL, 'QuickSightUserNotFoundException$RequestId' => '<p>The Amazon Web Services request ID for this request.</p>', 'RegisterUserRequest$Email' => '<p>The email address of the user that you want to register.</p>', 'RegisterUserRequest$IamArn' => '<p>The ARN of the IAMuser or role that you are registering with Amazon QuickSight. </p>', 'RegisterUserRequest$ExternalLoginFederationProviderType' => '<p>The type of supported external login provider that provides identity to let a user federate into Amazon QuickSight with an associated Identity and Access Management(IAM) role. The type of supported external login provider can be one of the following.</p> <ul> <li> <p> <code>COGNITO</code>: Amazon Cognito. The provider URL is cognito-identity.amazonaws.com. When choosing the <code>COGNITO</code> provider type, don’t use the "CustomFederationProviderUrl" parameter which is only needed when the external provider is custom.</p> </li> <li> <p> <code>CUSTOM_OIDC</code>: Custom OpenID Connect (OIDC) provider. When choosing <code>CUSTOM_OIDC</code> type, use the <code>CustomFederationProviderUrl</code> parameter to provide the custom OIDC provider URL.</p> </li> </ul>', 'RegisterUserRequest$CustomFederationProviderUrl' => '<p>The URL of the custom OpenID Connect (OIDC) provider that provides identity to let a user federate into Amazon QuickSight with an associated Identity and Access Management(IAM) role. This parameter should only be used when <code>ExternalLoginFederationProviderType</code> parameter is set to <code>CUSTOM_OIDC</code>.</p>', 'RegisterUserRequest$ExternalLoginId' => '<p>The identity ID for a user in the external login provider.</p>', 'RegisterUserResponse$UserInvitationUrl' => '<p>The URL the user visits to complete registration and provide a password. This is returned only for users with an identity type of <code>QUICKSIGHT</code>.</p>', 'RegisterUserResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'ResourceExistsException$Message' => NULL, 'ResourceExistsException$RequestId' => '<p>The Amazon Web Services request ID for this request.</p>', 'ResourceNotFoundException$Message' => NULL, 'ResourceNotFoundException$RequestId' => '<p>The Amazon Web Services request ID for this request.</p>', 'ResourceUnavailableException$Message' => NULL, 'ResourceUnavailableException$RequestId' => '<p>The Amazon Web Services request ID for this request.</p>', 'RestoreAnalysisResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'RowLevelPermissionTagRule$ColumnName' => '<p>The column name that a tag key is assigned to.</p>', 'SearchAnalysesRequest$NextToken' => '<p>A pagination token that can be used in a subsequent request.</p>', 'SearchAnalysesResponse$NextToken' => '<p>A pagination token that can be used in a subsequent request. </p>', 'SearchAnalysesResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'SearchDashboardsRequest$NextToken' => '<p>The token for the next set of results, or null if there are no more results.</p>', 'SearchDashboardsResponse$NextToken' => '<p>The token for the next set of results, or null if there are no more results.</p>', 'SearchDashboardsResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'SearchFoldersRequest$NextToken' => '<p>The token for the next set of results, or null if there are no more results.</p>', 'SearchFoldersResponse$NextToken' => '<p>The token for the next set of results, or null if there are no more results.</p>', 'SearchFoldersResponse$RequestId' => '<p>The request ID.</p>', 'SessionLifetimeInMinutesInvalidException$Message' => NULL, 'SessionLifetimeInMinutesInvalidException$RequestId' => '<p>The Amazon Web Services request ID for this request.</p>', 'StringList$member' => NULL, 'TagResourceResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'ThrottlingException$Message' => NULL, 'ThrottlingException$RequestId' => '<p>The Amazon Web Services request ID for this request.</p>', 'UnsupportedPricingPlanException$Message' => NULL, 'UnsupportedPricingPlanException$RequestId' => '<p>The Amazon Web Services request ID for this request.</p>', 'UnsupportedUserEditionException$Message' => NULL, 'UnsupportedUserEditionException$RequestId' => '<p>The Amazon Web Services request ID for this request.</p>', 'UntagResourceResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'UpdateAccountCustomizationResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'UpdateAccountSettingsRequest$NotificationEmail' => '<p>The email address that you want Amazon QuickSight to send notifications to regarding your Amazon Web Services account or Amazon QuickSight subscription.</p>', 'UpdateAccountSettingsResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'UpdateAnalysisPermissionsResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'UpdateAnalysisResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'UpdateDashboardPermissionsResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'UpdateDashboardPublishedVersionResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'UpdateDashboardResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'UpdateDataSetPermissionsResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'UpdateDataSetResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'UpdateDataSourcePermissionsResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'UpdateDataSourceResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'UpdateFolderPermissionsResponse$RequestId' => '<p>The request ID.</p>', 'UpdateFolderResponse$RequestId' => '<p>The request ID.</p>', 'UpdateGroupResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'UpdateIAMPolicyAssignmentResponse$AssignmentId' => '<p>The ID of the assignment.</p>', 'UpdateIAMPolicyAssignmentResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'UpdateTemplateAliasResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'UpdateTemplatePermissionsResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'UpdateTemplateResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'UpdateThemeAliasResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'UpdateThemePermissionsResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'UpdateThemeResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'UpdateUserRequest$Email' => '<p>The email address of the user that you want to update.</p>', 'UpdateUserRequest$ExternalLoginFederationProviderType' => '<p>The type of supported external login provider that provides identity to let a user federate into Amazon QuickSight with an associated Identity and Access Management(IAM) role. The type of supported external login provider can be one of the following.</p> <ul> <li> <p> <code>COGNITO</code>: Amazon Cognito. The provider URL is cognito-identity.amazonaws.com. When choosing the <code>COGNITO</code> provider type, don’t use the "CustomFederationProviderUrl" parameter which is only needed when the external provider is custom.</p> </li> <li> <p> <code>CUSTOM_OIDC</code>: Custom OpenID Connect (OIDC) provider. When choosing <code>CUSTOM_OIDC</code> type, use the <code>CustomFederationProviderUrl</code> parameter to provide the custom OIDC provider URL.</p> </li> <li> <p> <code>NONE</code>: This clears all the previously saved external login information for a user. Use <code> <a>DescribeUser</a> </code> API to check the external login information.</p> </li> </ul>', 'UpdateUserRequest$CustomFederationProviderUrl' => '<p>The URL of the custom OpenID Connect (OIDC) provider that provides identity to let a user federate into Amazon QuickSight with an associated Identity and Access Management(IAM) role. This parameter should only be used when <code>ExternalLoginFederationProviderType</code> parameter is set to <code>CUSTOM_OIDC</code>.</p>', 'UpdateUserRequest$ExternalLoginId' => '<p>The identity ID for a user in the external login provider.</p>', 'UpdateUserResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'User$Email' => '<p>The user\'s email address.</p>', 'User$PrincipalId' => '<p>The principal ID of the user.</p>', 'User$ExternalLoginFederationProviderType' => '<p>The type of supported external login provider that provides identity to let the user federate into Amazon QuickSight with an associated IAMrole. The type can be one of the following.</p> <ul> <li> <p> <code>COGNITO</code>: Amazon Cognito. The provider URL is cognito-identity.amazonaws.com.</p> </li> <li> <p> <code>CUSTOM_OIDC</code>: Custom OpenID Connect (OIDC) provider.</p> </li> </ul>', 'User$ExternalLoginFederationProviderUrl' => '<p>The URL of the external login provider.</p>', 'User$ExternalLoginId' => '<p>The identity ID for the user in the external login provider.</p>', ], ], 'StringList' => [ 'base' => NULL, 'refs' => [ 'StringParameter$Values' => '<p>The values of a string parameter.</p>', ], ], 'StringParameter' => [ 'base' => '<p>A string parameter.</p>', 'refs' => [ 'StringParameterList$member' => NULL, ], ], 'StringParameterList' => [ 'base' => NULL, 'refs' => [ 'Parameters$StringParameters' => '<p>The parameters that have a data type of string.</p>', ], ], 'Tag' => [ 'base' => '<p>The key or keys of the key-value pairs for the resource tag or tags assigned to the resource.</p>', 'refs' => [ 'TagList$member' => NULL, ], ], 'TagColumnOperation' => [ 'base' => '<p>A transform operation that tags a column with additional information.</p>', 'refs' => [ 'TransformOperation$TagColumnOperation' => '<p>An operation that tags a column with additional information.</p>', ], ], 'TagKey' => [ 'base' => NULL, 'refs' => [ 'Tag$Key' => '<p>Tag key.</p>', 'TagKeyList$member' => NULL, ], ], 'TagKeyList' => [ 'base' => NULL, 'refs' => [ 'UntagResourceRequest$TagKeys' => '<p>The keys of the key-value pairs for the resource tag or tags assigned to the resource.</p>', ], ], 'TagList' => [ 'base' => NULL, 'refs' => [ 'CreateAccountCustomizationRequest$Tags' => '<p>A list of the tags that you want to attach to this resource.</p>', 'CreateAnalysisRequest$Tags' => '<p>Contains a map of the key-value pairs for the resource tag or tags assigned to the analysis.</p>', 'CreateDashboardRequest$Tags' => '<p>Contains a map of the key-value pairs for the resource tag or tags assigned to the dashboard.</p>', 'CreateDataSetRequest$Tags' => '<p>Contains a map of the key-value pairs for the resource tag or tags assigned to the dataset.</p>', 'CreateDataSourceRequest$Tags' => '<p>Contains a map of the key-value pairs for the resource tag or tags assigned to the data source.</p>', 'CreateFolderRequest$Tags' => '<p>Tags for the folder.</p>', 'CreateNamespaceRequest$Tags' => '<p>The tags that you want to associate with the namespace that you\'re creating.</p>', 'CreateTemplateRequest$Tags' => '<p>Contains a map of the key-value pairs for the resource tag or tags assigned to the resource.</p>', 'CreateThemeRequest$Tags' => '<p>A map of the key-value pairs for the resource tag or tags that you want to add to the resource.</p>', 'ListTagsForResourceResponse$Tags' => '<p>Contains a map of the key-value pairs for the resource tag or tags assigned to the resource.</p>', 'TagResourceRequest$Tags' => '<p>Contains a map of the key-value pairs for the resource tag or tags assigned to the resource.</p>', ], ], 'TagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'TagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'TagValue' => [ 'base' => NULL, 'refs' => [ 'Tag$Value' => '<p>Tag value.</p>', ], ], 'Template' => [ 'base' => '<p>A template object. A <i>template</i> is an entity in Amazon QuickSight that encapsulates the metadata required to create an analysis and that you can use to create a dashboard. A template adds a layer of abstraction by using placeholders to replace the dataset associated with an analysis. You can use templates to create dashboards by replacing dataset placeholders with datasets that follow the same schema that was used to create the source analysis and template.</p> <p>You can share templates across Amazon Web Services accounts by allowing users in other Amazon Web Services accounts to create a template or a dashboard from an existing template.</p>', 'refs' => [ 'DescribeTemplateResponse$Template' => '<p>The template structure for the object you want to describe.</p>', ], ], 'TemplateAlias' => [ 'base' => '<p>The template alias.</p>', 'refs' => [ 'CreateTemplateAliasResponse$TemplateAlias' => '<p>Information about the template alias.</p>', 'DescribeTemplateAliasResponse$TemplateAlias' => '<p>Information about the template alias.</p>', 'TemplateAliasList$member' => NULL, 'UpdateTemplateAliasResponse$TemplateAlias' => '<p>The template alias.</p>', ], ], 'TemplateAliasList' => [ 'base' => NULL, 'refs' => [ 'ListTemplateAliasesResponse$TemplateAliasList' => '<p>A structure containing the list of the template\'s aliases.</p>', ], ], 'TemplateError' => [ 'base' => '<p>List of errors that occurred when the template version creation failed.</p>', 'refs' => [ 'TemplateErrorList$member' => NULL, ], ], 'TemplateErrorList' => [ 'base' => NULL, 'refs' => [ 'TemplateVersion$Errors' => '<p>Errors associated with this template version.</p>', ], ], 'TemplateErrorType' => [ 'base' => NULL, 'refs' => [ 'TemplateError$Type' => '<p>Type of error.</p>', ], ], 'TemplateName' => [ 'base' => NULL, 'refs' => [ 'CreateTemplateRequest$Name' => '<p>A display name for the template.</p>', 'Template$Name' => '<p>The display name of the template.</p>', 'TemplateSummary$Name' => '<p>A display name for the template.</p>', 'UpdateTemplateRequest$Name' => '<p>The name for the template.</p>', ], ], 'TemplateSourceAnalysis' => [ 'base' => '<p>The source analysis of the template.</p>', 'refs' => [ 'TemplateSourceEntity$SourceAnalysis' => '<p>The source analysis, if it is based on an analysis.</p>', ], ], 'TemplateSourceEntity' => [ 'base' => '<p>The source entity of the template.</p>', 'refs' => [ 'CreateTemplateRequest$SourceEntity' => '<p>The entity that you are using as a source when you create the template. In <code>SourceEntity</code>, you specify the type of object you\'re using as source: <code>SourceTemplate</code> for a template or <code>SourceAnalysis</code> for an analysis. Both of these require an Amazon Resource Name (ARN). For <code>SourceTemplate</code>, specify the ARN of the source template. For <code>SourceAnalysis</code>, specify the ARN of the source analysis. The <code>SourceTemplate</code> ARN can contain any Amazon Web Services account and any Amazon QuickSight-supported Amazon Web Services Region;. </p> <p>Use the <code>DataSetReferences</code> entity within <code>SourceTemplate</code> or <code>SourceAnalysis</code> to list the replacement datasets for the placeholders listed in the original. The schema in each dataset must match its placeholder. </p>', 'UpdateTemplateRequest$SourceEntity' => '<p>The entity that you are using as a source when you update the template. In <code>SourceEntity</code>, you specify the type of object you\'re using as source: <code>SourceTemplate</code> for a template or <code>SourceAnalysis</code> for an analysis. Both of these require an Amazon Resource Name (ARN). For <code>SourceTemplate</code>, specify the ARN of the source template. For <code>SourceAnalysis</code>, specify the ARN of the source analysis. The <code>SourceTemplate</code> ARN can contain any Amazon Web Services account and any Amazon QuickSight-supported Amazon Web Services Region;. </p> <p>Use the <code>DataSetReferences</code> entity within <code>SourceTemplate</code> or <code>SourceAnalysis</code> to list the replacement datasets for the placeholders listed in the original. The schema in each dataset must match its placeholder. </p>', ], ], 'TemplateSourceTemplate' => [ 'base' => '<p>The source template of the template.</p>', 'refs' => [ 'TemplateSourceEntity$SourceTemplate' => '<p>The source template, if it is based on an template.</p>', ], ], 'TemplateSummary' => [ 'base' => '<p>The template summary.</p>', 'refs' => [ 'TemplateSummaryList$member' => NULL, ], ], 'TemplateSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListTemplatesResponse$TemplateSummaryList' => '<p>A structure containing information about the templates in the list.</p>', ], ], 'TemplateVersion' => [ 'base' => '<p>A version of a template.</p>', 'refs' => [ 'Template$Version' => '<p>A structure describing the versions of the template.</p>', ], ], 'TemplateVersionSummary' => [ 'base' => '<p>The template version.</p>', 'refs' => [ 'TemplateVersionSummaryList$member' => NULL, ], ], 'TemplateVersionSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListTemplateVersionsResponse$TemplateVersionSummaryList' => '<p>A structure containing a list of all the versions of the specified template.</p>', ], ], 'TeradataParameters' => [ 'base' => '<p>The parameters for Teradata.</p>', 'refs' => [ 'DataSourceParameters$TeradataParameters' => '<p>The parameters for Teradata.</p>', ], ], 'TextQualifier' => [ 'base' => NULL, 'refs' => [ 'UploadSettings$TextQualifier' => '<p>Text qualifier.</p>', ], ], 'Theme' => [ 'base' => '<p>Summary information about a theme.</p>', 'refs' => [ 'DescribeThemeResponse$Theme' => '<p>The information about the theme that you are describing.</p>', ], ], 'ThemeAlias' => [ 'base' => '<p>An alias for a theme.</p>', 'refs' => [ 'CreateThemeAliasResponse$ThemeAlias' => '<p>Information about the theme alias.</p>', 'DescribeThemeAliasResponse$ThemeAlias' => '<p>Information about the theme alias.</p>', 'ThemeAliasList$member' => NULL, 'UpdateThemeAliasResponse$ThemeAlias' => '<p>Information about the theme alias.</p>', ], ], 'ThemeAliasList' => [ 'base' => NULL, 'refs' => [ 'ListThemeAliasesResponse$ThemeAliasList' => '<p>A structure containing the list of the theme\'s aliases.</p>', ], ], 'ThemeConfiguration' => [ 'base' => '<p>The theme configuration. This configuration contains all of the display properties for a theme.</p>', 'refs' => [ 'CreateThemeRequest$Configuration' => '<p>The theme configuration, which contains the theme display properties.</p>', 'ThemeVersion$Configuration' => '<p>The theme configuration, which contains all the theme display properties.</p>', 'UpdateThemeRequest$Configuration' => '<p>The theme configuration, which contains the theme display properties.</p>', ], ], 'ThemeError' => [ 'base' => '<p>Theme error.</p>', 'refs' => [ 'ThemeErrorList$member' => NULL, ], ], 'ThemeErrorList' => [ 'base' => NULL, 'refs' => [ 'ThemeVersion$Errors' => '<p>Errors associated with the theme.</p>', ], ], 'ThemeErrorType' => [ 'base' => NULL, 'refs' => [ 'ThemeError$Type' => '<p>The type of error.</p>', ], ], 'ThemeName' => [ 'base' => NULL, 'refs' => [ 'CreateThemeRequest$Name' => '<p>A display name for the theme.</p>', 'Theme$Name' => '<p>The name that the user gives to the theme.</p>', 'ThemeSummary$Name' => '<p>the display name for the theme.</p>', 'UpdateThemeRequest$Name' => '<p>The name for the theme.</p>', ], ], 'ThemeSummary' => [ 'base' => '<p>The theme summary.</p>', 'refs' => [ 'ThemeSummaryList$member' => NULL, ], ], 'ThemeSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListThemesResponse$ThemeSummaryList' => '<p>Information about the themes in the list.</p>', ], ], 'ThemeType' => [ 'base' => NULL, 'refs' => [ 'ListThemesRequest$Type' => '<p>The type of themes that you want to list. Valid options include the following:</p> <ul> <li> <p> <code>ALL (default)</code>- Display all existing themes.</p> </li> <li> <p> <code>CUSTOM</code> - Display only the themes created by people using Amazon QuickSight.</p> </li> <li> <p> <code>QUICKSIGHT</code> - Display only the starting themes defined by Amazon QuickSight.</p> </li> </ul>', 'Theme$Type' => '<p>The type of theme, based on how it was created. Valid values include: <code>QUICKSIGHT</code> and <code>CUSTOM</code>.</p>', ], ], 'ThemeVersion' => [ 'base' => '<p>A version of a theme.</p>', 'refs' => [ 'Theme$Version' => NULL, ], ], 'ThemeVersionSummary' => [ 'base' => '<p>The theme version.</p>', 'refs' => [ 'ThemeVersionSummaryList$member' => NULL, ], ], 'ThemeVersionSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListThemeVersionsResponse$ThemeVersionSummaryList' => '<p>A structure containing a list of all the versions of the specified theme.</p>', ], ], 'ThrottlingException' => [ 'base' => '<p>Access is throttled.</p>', 'refs' => [], ], 'TileLayoutStyle' => [ 'base' => '<p>The display options for the layout of tiles on a sheet.</p>', 'refs' => [ 'SheetStyle$TileLayout' => '<p>The layout options for tiles.</p>', ], ], 'TileStyle' => [ 'base' => '<p>Display options related to tiles on a sheet.</p>', 'refs' => [ 'SheetStyle$Tile' => '<p>The display options for tiles.</p>', ], ], 'Timestamp' => [ 'base' => NULL, 'refs' => [ 'Analysis$CreatedTime' => '<p>The time that the analysis was created.</p>', 'Analysis$LastUpdatedTime' => '<p>The time that the analysis was last updated.</p>', 'AnalysisSummary$CreatedTime' => '<p>The time that the analysis was created.</p>', 'AnalysisSummary$LastUpdatedTime' => '<p>The time that the analysis was last updated.</p>', 'Dashboard$CreatedTime' => '<p>The time that this dataset was created.</p>', 'Dashboard$LastPublishedTime' => '<p>The last time that this dataset was published.</p>', 'Dashboard$LastUpdatedTime' => '<p>The last time that this dataset was updated.</p>', 'DashboardSummary$CreatedTime' => '<p>The time that this dashboard was created.</p>', 'DashboardSummary$LastUpdatedTime' => '<p>The last time that this dashboard was updated.</p>', 'DashboardSummary$LastPublishedTime' => '<p>The last time that this dashboard was published.</p>', 'DashboardVersion$CreatedTime' => '<p>The time that this dashboard version was created.</p>', 'DashboardVersionSummary$CreatedTime' => '<p>The time that this dashboard version was created.</p>', 'DataSet$CreatedTime' => '<p>The time that this dataset was created.</p>', 'DataSet$LastUpdatedTime' => '<p>The last time that this dataset was updated.</p>', 'DataSetSummary$CreatedTime' => '<p>The time that this dataset was created.</p>', 'DataSetSummary$LastUpdatedTime' => '<p>The last time that this dataset was updated.</p>', 'DataSource$CreatedTime' => '<p>The time that this data source was created.</p>', 'DataSource$LastUpdatedTime' => '<p>The last time that this data source was updated.</p>', 'DeleteAnalysisResponse$DeletionTime' => '<p>The date and time that the analysis is scheduled to be deleted.</p>', 'Folder$CreatedTime' => '<p>The time that the folder was created.</p>', 'Folder$LastUpdatedTime' => '<p>The time that the folder was last updated.</p>', 'FolderSummary$CreatedTime' => '<p>The time that the folder was created.</p>', 'FolderSummary$LastUpdatedTime' => '<p>The time that the folder was last updated.</p>', 'Template$LastUpdatedTime' => '<p>Time when this was last updated.</p>', 'Template$CreatedTime' => '<p>Time when this was created.</p>', 'TemplateSummary$CreatedTime' => '<p>The last time that this template was created.</p>', 'TemplateSummary$LastUpdatedTime' => '<p>The last time that this template was updated.</p>', 'TemplateVersion$CreatedTime' => '<p>The time that this template version was created.</p>', 'TemplateVersionSummary$CreatedTime' => '<p>The time that this template version was created.</p>', 'Theme$CreatedTime' => '<p>The date and time that the theme was created.</p>', 'Theme$LastUpdatedTime' => '<p>The date and time that the theme was last updated.</p>', 'ThemeSummary$CreatedTime' => '<p>The date and time that this theme was created.</p>', 'ThemeSummary$LastUpdatedTime' => '<p>The last date and time that this theme was updated.</p>', 'ThemeVersion$CreatedTime' => '<p>The date and time that this theme version was created.</p>', 'ThemeVersionSummary$CreatedTime' => '<p>The date and time that this theme version was created.</p>', 'TimestampList$member' => NULL, ], ], 'TimestampList' => [ 'base' => NULL, 'refs' => [ 'DateTimeParameter$Values' => '<p>The values for the date-time parameter.</p>', ], ], 'TransformOperation' => [ 'base' => '<p>A data transformation on a logical table. This is a variant type structure. For this structure to be valid, only one of the attributes can be non-null.</p>', 'refs' => [ 'TransformOperationList$member' => NULL, ], ], 'TransformOperationList' => [ 'base' => NULL, 'refs' => [ 'LogicalTable$DataTransforms' => '<p>Transform operations that act on this logical table.</p>', ], ], 'TwitterParameters' => [ 'base' => '<p>The parameters for Twitter.</p>', 'refs' => [ 'DataSourceParameters$TwitterParameters' => '<p>The parameters for Twitter.</p>', ], ], 'TypeCastFormat' => [ 'base' => NULL, 'refs' => [ 'CastColumnTypeOperation$Format' => '<p>When casting a column from string to datetime type, you can supply a string in a format supported by Amazon QuickSight to denote the source data format.</p>', ], ], 'UIColorPalette' => [ 'base' => '<p>The theme colors that apply to UI and to charts, excluding data colors. The colors description is a hexadecimal color code that consists of six alphanumerical characters, prefixed with <code>#</code>, for example #37BFF5. For more information, see <a href="https://docs.aws.amazon.com/quicksight/latest/user/themes-in-quicksight.html">Using Themes in Amazon QuickSight</a> in the <i>Amazon QuickSight User Guide.</i> </p>', 'refs' => [ 'ThemeConfiguration$UIColorPalette' => '<p>Color properties that apply to the UI and to charts, excluding the colors that apply to data. </p>', ], ], 'UnsupportedPricingPlanException' => [ 'base' => '<p>This error indicates that you are calling an embedding operation in Amazon QuickSight without the required pricing plan on your Amazon Web Services account. Before you can use embedding for anonymous users, a Amazon QuickSight administrator needs to add capacity pricing to Amazon QuickSight. You can do this on the <b>Manage Amazon QuickSight</b> page. </p> <p>After capacity pricing is added, you can use the <a>GetDashboardEmbedUrl</a> API operation with the <code>--identity-type ANONYMOUS</code> option.</p>', 'refs' => [], ], 'UnsupportedUserEditionException' => [ 'base' => '<p>This error indicates that you are calling an operation on an Amazon QuickSight subscription where the edition doesn\'t include support for that operation. Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition. Not every operation and capability is available in every edition.</p>', 'refs' => [], ], 'UntagColumnOperation' => [ 'base' => '<p>A transform operation that removes tags associated with a column.</p>', 'refs' => [ 'TransformOperation$UntagColumnOperation' => NULL, ], ], 'UntagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'UntagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateAccountCustomizationRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateAccountCustomizationResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateAccountSettingsRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateAccountSettingsResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateAnalysisPermissionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateAnalysisPermissionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateAnalysisRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateAnalysisResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateDashboardPermissionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateDashboardPermissionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateDashboardPublishedVersionRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateDashboardPublishedVersionResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateDashboardRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateDashboardResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateDataSetPermissionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateDataSetPermissionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateDataSetRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateDataSetResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateDataSourcePermissionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateDataSourcePermissionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateDataSourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateDataSourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateFolderPermissionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateFolderPermissionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateFolderRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateFolderResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateGroupResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateIAMPolicyAssignmentRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateIAMPolicyAssignmentResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateResourcePermissionList' => [ 'base' => NULL, 'refs' => [ 'UpdateAnalysisPermissionsRequest$GrantPermissions' => '<p>A structure that describes the permissions to add and the principal to add them to.</p>', 'UpdateAnalysisPermissionsRequest$RevokePermissions' => '<p>A structure that describes the permissions to remove and the principal to remove them from.</p>', 'UpdateDashboardPermissionsRequest$GrantPermissions' => '<p>The permissions that you want to grant on this resource.</p>', 'UpdateDashboardPermissionsRequest$RevokePermissions' => '<p>The permissions that you want to revoke from this resource.</p>', 'UpdateTemplatePermissionsRequest$GrantPermissions' => '<p>A list of resource permissions to be granted on the template. </p>', 'UpdateTemplatePermissionsRequest$RevokePermissions' => '<p>A list of resource permissions to be revoked from the template. </p>', 'UpdateThemePermissionsRequest$GrantPermissions' => '<p>A list of resource permissions to be granted for the theme.</p>', 'UpdateThemePermissionsRequest$RevokePermissions' => '<p>A list of resource permissions to be revoked from the theme.</p>', ], ], 'UpdateTemplateAliasRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateTemplateAliasResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateTemplatePermissionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateTemplatePermissionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateTemplateRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateTemplateResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateThemeAliasRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateThemeAliasResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateThemePermissionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateThemePermissionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateThemeRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateThemeResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateUserRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateUserResponse' => [ 'base' => NULL, 'refs' => [], ], 'UploadSettings' => [ 'base' => '<p>Information about the format for a source file or files.</p>', 'refs' => [ 'S3Source$UploadSettings' => '<p>Information about the format for the S3 source file or files.</p>', ], ], 'User' => [ 'base' => '<p>A registered user of Amazon QuickSight. </p>', 'refs' => [ 'DescribeUserResponse$User' => '<p>The user name.</p>', 'RegisterUserResponse$User' => '<p>The user\'s user name.</p>', 'UpdateUserResponse$User' => '<p>The Amazon QuickSight user.</p>', 'UserList$member' => NULL, ], ], 'UserList' => [ 'base' => NULL, 'refs' => [ 'ListUsersResponse$UserList' => '<p>The list of users.</p>', ], ], 'UserName' => [ 'base' => NULL, 'refs' => [ 'DeleteUserRequest$UserName' => '<p>The name of the user that you want to delete.</p>', 'DescribeUserRequest$UserName' => '<p>The name of the user that you want to describe.</p>', 'ListIAMPolicyAssignmentsForUserRequest$UserName' => '<p>The name of the user.</p>', 'ListUserGroupsRequest$UserName' => '<p>The Amazon QuickSight user name that you want to list group memberships for.</p>', 'RegisterUserRequest$UserName' => '<p>The Amazon QuickSight user name that you want to create for the user you are registering.</p>', 'UpdateUserRequest$UserName' => '<p>The Amazon QuickSight user name that you want to update.</p>', 'User$UserName' => '<p>The user\'s user name.</p>', ], ], 'UserRole' => [ 'base' => NULL, 'refs' => [ 'RegisterUserRequest$UserRole' => '<p>The Amazon QuickSight role for the user. The user role can be one of the following:</p> <ul> <li> <p> <code>READER</code>: A user who has read-only access to dashboards.</p> </li> <li> <p> <code>AUTHOR</code>: A user who can create data sources, datasets, analyses, and dashboards.</p> </li> <li> <p> <code>ADMIN</code>: A user who is an author, who can also manage Amazon QuickSight settings.</p> </li> <li> <p> <code>RESTRICTED_READER</code>: This role isn\'t currently available for use.</p> </li> <li> <p> <code>RESTRICTED_AUTHOR</code>: This role isn\'t currently available for use.</p> </li> </ul>', 'UpdateUserRequest$Role' => '<p>The Amazon QuickSight role of the user. The role can be one of the following default security cohorts:</p> <ul> <li> <p> <code>READER</code>: A user who has read-only access to dashboards.</p> </li> <li> <p> <code>AUTHOR</code>: A user who can create data sources, datasets, analyses, and dashboards.</p> </li> <li> <p> <code>ADMIN</code>: A user who is an author, who can also manage Amazon QuickSight settings.</p> </li> </ul> <p>The name of the Amazon QuickSight role is invisible to the user except for the console screens dealing with permissions.</p>', 'User$Role' => '<p>The Amazon QuickSight role for the user. The user role can be one of the following:.</p> <ul> <li> <p> <code>READER</code>: A user who has read-only access to dashboards.</p> </li> <li> <p> <code>AUTHOR</code>: A user who can create data sources, datasets, analyses, and dashboards.</p> </li> <li> <p> <code>ADMIN</code>: A user who is an author, who can also manage Amazon Amazon QuickSight settings.</p> </li> <li> <p> <code>RESTRICTED_READER</code>: This role isn\'t currently available for use.</p> </li> <li> <p> <code>RESTRICTED_AUTHOR</code>: This role isn\'t currently available for use.</p> </li> </ul>', ], ], 'Username' => [ 'base' => NULL, 'refs' => [ 'CredentialPair$Username' => '<p>User name.</p>', ], ], 'VersionDescription' => [ 'base' => NULL, 'refs' => [ 'CreateDashboardRequest$VersionDescription' => '<p>A description for the first version of the dashboard being created.</p>', 'CreateTemplateRequest$VersionDescription' => '<p>A description of the current template version being created. This API operation creates the first version of the template. Every time <code>UpdateTemplate</code> is called, a new version is created. Each version of the template maintains a description of the version in the <code>VersionDescription</code> field.</p>', 'CreateThemeRequest$VersionDescription' => '<p>A description of the first version of the theme that you\'re creating. Every time <code>UpdateTheme</code> is called, a new version is created. Each version of the theme has a description of the version in the <code>VersionDescription</code> field.</p>', 'DashboardVersion$Description' => '<p>Description.</p>', 'DashboardVersionSummary$Description' => '<p>Description.</p>', 'TemplateVersion$Description' => '<p>The description of the template.</p>', 'TemplateVersionSummary$Description' => '<p>The description of the template version.</p>', 'ThemeVersion$Description' => '<p>The description of the theme.</p>', 'ThemeVersionSummary$Description' => '<p>The description of the theme version.</p>', 'UpdateDashboardRequest$VersionDescription' => '<p>A description for the first version of the dashboard being created.</p>', 'UpdateTemplateRequest$VersionDescription' => '<p>A description of the current template version that is being updated. Every time you call <code>UpdateTemplate</code>, you create a new version of the template. Each version of the template maintains a description of the version in the <code>VersionDescription</code> field.</p>', 'UpdateThemeRequest$VersionDescription' => '<p>A description of the theme version that you\'re updating Every time that you call <code>UpdateTheme</code>, you create a new version of the theme. Each version of the theme maintains a description of the version in <code>VersionDescription</code>.</p>', ], ], 'VersionNumber' => [ 'base' => NULL, 'refs' => [ 'CreateTemplateAliasRequest$TemplateVersionNumber' => '<p>The version number of the template.</p>', 'CreateThemeAliasRequest$ThemeVersionNumber' => '<p>The version number of the theme.</p>', 'DashboardSummary$PublishedVersionNumber' => '<p>Published version number.</p>', 'DashboardVersion$VersionNumber' => '<p>Version number for this version of the dashboard.</p>', 'DashboardVersionSummary$VersionNumber' => '<p>Version number.</p>', 'DeleteDashboardRequest$VersionNumber' => '<p>The version number of the dashboard. If the version number property is provided, only the specified version of the dashboard is deleted.</p>', 'DeleteTemplateRequest$VersionNumber' => '<p>Specifies the version of the template that you want to delete. If you don\'t provide a version number, <code>DeleteTemplate</code> deletes all versions of the template. </p>', 'DeleteThemeRequest$VersionNumber' => '<p>The version of the theme that you want to delete. </p> <p> <b>Note:</b> If you don\'t provide a version number, you\'re using this call to <code>DeleteTheme</code> to delete all versions of the theme.</p>', 'DescribeDashboardRequest$VersionNumber' => '<p>The version number for the dashboard. If a version number isn\'t passed, the latest published dashboard version is described. </p>', 'DescribeTemplateRequest$VersionNumber' => '<p>(Optional) The number for the version to describe. If a <code>VersionNumber</code> parameter value isn\'t provided, the latest version of the template is described.</p>', 'DescribeThemeRequest$VersionNumber' => '<p>The version number for the version to describe. If a <code>VersionNumber</code> parameter value isn\'t provided, the latest version of the theme is described.</p>', 'TemplateAlias$TemplateVersionNumber' => '<p>The version number of the template alias.</p>', 'TemplateSummary$LatestVersionNumber' => '<p>A structure containing a list of version numbers for the template summary.</p>', 'TemplateVersion$VersionNumber' => '<p>The version number of the template version.</p>', 'TemplateVersionSummary$VersionNumber' => '<p>The version number of the template version.</p>', 'ThemeAlias$ThemeVersionNumber' => '<p>The version number of the theme alias.</p>', 'ThemeSummary$LatestVersionNumber' => '<p>The latest version number for the theme. </p>', 'ThemeVersion$VersionNumber' => '<p>The version number of the theme.</p>', 'ThemeVersionSummary$VersionNumber' => '<p>The version number of the theme version.</p>', 'UpdateDashboardPublishedVersionRequest$VersionNumber' => '<p>The version number of the dashboard.</p>', 'UpdateTemplateAliasRequest$TemplateVersionNumber' => '<p>The version number of the template.</p>', 'UpdateThemeAliasRequest$ThemeVersionNumber' => '<p>The version number of the theme that the alias should reference.</p>', ], ], 'VpcConnectionProperties' => [ 'base' => '<p>VPC connection properties.</p>', 'refs' => [ 'CreateDataSourceRequest$VpcConnectionProperties' => '<p>Use this parameter only when you want Amazon QuickSight to use a VPC connection when connecting to your underlying source.</p>', 'DataSource$VpcConnectionProperties' => '<p>The VPC connection information. You need to use this parameter only when you want Amazon QuickSight to use a VPC connection when connecting to your underlying source.</p>', 'UpdateDataSourceRequest$VpcConnectionProperties' => '<p>Use this parameter only when you want Amazon QuickSight to use a VPC connection when connecting to your underlying source.</p>', ], ], 'Warehouse' => [ 'base' => NULL, 'refs' => [ 'SnowflakeParameters$Warehouse' => '<p>Warehouse.</p>', ], ], 'WorkGroup' => [ 'base' => NULL, 'refs' => [ 'AthenaParameters$WorkGroup' => '<p>The workgroup that Amazon Athena uses.</p>', ], ], 'boolean' => [ 'base' => NULL, 'refs' => [ 'BorderStyle$Show' => '<p>The option to enable display of borders for visuals.</p>', 'DeleteAnalysisRequest$ForceDeleteWithoutRecovery' => '<p>This option defaults to the value <code>NoForceDeleteWithoutRecovery</code>. To immediately delete the analysis, add the <code>ForceDeleteWithoutRecovery</code> option. You can\'t restore an analysis after it\'s deleted. </p>', 'DescribeAccountCustomizationRequest$Resolved' => '<p>The <code>Resolved</code> flag works with the other parameters to determine which view of Amazon QuickSight customizations is returned. You can add this flag to your command to use the same view that Amazon QuickSight uses to identify which customizations to apply to the console. Omit this flag, or set it to <code>no-resolved</code>, to reveal customizations that are configured at different levels. </p>', 'GutterStyle$Show' => '<p>This Boolean value controls whether to display a gutter space between sheet tiles. </p>', 'MarginStyle$Show' => '<p>This Boolean value controls whether to display sheet margins.</p>', ], ], 'long' => [ 'base' => NULL, 'refs' => [ 'Ingestion$IngestionTimeInSeconds' => '<p>The time that this ingestion took, measured in seconds.</p>', 'Ingestion$IngestionSizeInBytes' => '<p>The size of the data ingested, in bytes.</p>', 'RowInfo$RowsIngested' => '<p>The number of rows that were ingested.</p>', 'RowInfo$RowsDropped' => '<p>The number of rows that were not ingested.</p>', ], ], 'string' => [ 'base' => NULL, 'refs' => [ 'CancelIngestionRequest$DataSetId' => '<p>The ID of the dataset used in the ingestion.</p>', 'CancelIngestionResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'CreateIngestionRequest$DataSetId' => '<p>The ID of the dataset used in the ingestion.</p>', 'CreateIngestionResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'DescribeIngestionRequest$DataSetId' => '<p>The ID of the dataset used in the ingestion.</p>', 'DescribeIngestionResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'ErrorInfo$Message' => '<p>Error message.</p>', 'ListIngestionsRequest$DataSetId' => '<p>The ID of the dataset used in the ingestion.</p>', 'ListIngestionsRequest$NextToken' => '<p>The token for the next set of results, or null if there are no more results.</p>', 'ListIngestionsResponse$NextToken' => '<p>The token for the next set of results, or null if there are no more results.</p>', 'ListIngestionsResponse$RequestId' => '<p>The Amazon Web Services request ID for this operation.</p>', 'QueueInfo$WaitingOnIngestion' => '<p>The ID of the queued ingestion.</p>', 'QueueInfo$QueuedIngestion' => '<p>The ID of the ongoing ingestion. The queued ingestion is waiting for the ongoing ingestion to complete.</p>', ], ], 'timestamp' => [ 'base' => NULL, 'refs' => [ 'Ingestion$CreatedTime' => '<p>The time that this ingestion started.</p>', ], ], ],];
