<?php
// This file was auto-generated from sdk-root/src/data/pi/2018-02-27/docs-2.json
return [ 'version' => '2.0', 'service' => '<fullname>Amazon RDS Performance Insights</fullname> <p>Amazon RDS Performance Insights enables you to monitor and explore different dimensions of database load based on data captured from a running DB instance. The guide provides detailed information about Performance Insights data types, parameters and errors.</p> <p>When Performance Insights is enabled, the Amazon RDS Performance Insights API provides visibility into the performance of your DB instance. Amazon CloudWatch provides the authoritative source for AWS service-vended monitoring metrics. Performance Insights offers a domain-specific view of DB load. </p> <p>DB load is measured as Average Active Sessions. Performance Insights provides the data to API consumers as a two-dimensional time-series dataset. The time dimension provides DB load data for each time point in the queried time range. Each time point decomposes overall load in relation to the requested dimensions, measured at that time point. Examples include SQL, Wait event, User, and Host.</p> <ul> <li> <p>To learn more about Performance Insights and Amazon Aurora DB instances, go to the <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_PerfInsights.html">Amazon Aurora User Guide</a>.</p> </li> <li> <p>To learn more about Performance Insights and Amazon RDS DB instances, go to the <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PerfInsights.html">Amazon RDS User Guide</a>.</p> </li> </ul>', 'operations' => [ 'DescribeDimensionKeys' => '<p>For a specific time period, retrieve the top <code>N</code> dimension keys for a metric.</p> <note> <p>Each response element returns a maximum of 500 bytes. For larger elements, such as SQL statements, only the first 500 bytes are returned.</p> </note>', 'GetDimensionKeyDetails' => '<p>Get the attributes of the specified dimension group for a DB instance or data source. For example, if you specify a SQL ID, <code>GetDimensionKeyDetails</code> retrieves the full text of the dimension <code>db.sql.statement</code> associated with this ID. This operation is useful because <code>GetResourceMetrics</code> and <code>DescribeDimensionKeys</code> don\'t support retrieval of large SQL statement text.</p>', 'GetResourceMetrics' => '<p>Retrieve Performance Insights metrics for a set of data sources, over a time period. You can provide specific dimension groups and dimensions, and provide aggregation and filtering criteria for each group.</p> <note> <p>Each response element returns a maximum of 500 bytes. For larger elements, such as SQL statements, only the first 500 bytes are returned.</p> </note>', ], 'shapes' => [ 'DataPoint' => [ 'base' => '<p>A timestamp, and a single numerical value, which together represent a measurement at a particular point in time.</p>', 'refs' => [ 'DataPointsList$member' => NULL, ], ], 'DataPointsList' => [ 'base' => NULL, 'refs' => [ 'MetricKeyDataPoints$DataPoints' => '<p>An array of timestamp-value pairs, representing measurements over a period of time.</p>', ], ], 'DescribeDimensionKeysRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeDimensionKeysResponse' => [ 'base' => NULL, 'refs' => [], ], 'DetailStatus' => [ 'base' => NULL, 'refs' => [ 'DimensionKeyDetail$Status' => '<p>The status of the dimension detail data. Possible values include the following:</p> <ul> <li> <p> <code>AVAILABLE</code> - The dimension detail data is ready to be retrieved.</p> </li> <li> <p> <code>PROCESSING</code> - The dimension detail data isn\'t ready to be retrieved because more processing time is required. If the requested detail data for <code>db.sql.statement</code> has the status <code>PROCESSING</code>, Performance Insights returns the truncated query.</p> </li> <li> <p> <code>UNAVAILABLE</code> - The dimension detail data could not be collected successfully.</p> </li> </ul>', ], ], 'DimensionGroup' => [ 'base' => '<p>A logical grouping of Performance Insights metrics for a related subject area. For example, the <code>db.sql</code> dimension group consists of the following dimensions: <code>db.sql.id</code>, <code>db.sql.db_id</code>, <code>db.sql.statement</code>, and <code>db.sql.tokenized_id</code>.</p> <note> <p>Each response element returns a maximum of 500 bytes. For larger elements, such as SQL statements, only the first 500 bytes are returned.</p> </note>', 'refs' => [ 'DescribeDimensionKeysRequest$GroupBy' => '<p>A specification for how to aggregate the data points from a query result. You must specify a valid dimension group. Performance Insights returns all dimensions within this group, unless you provide the names of specific dimensions within this group. You can also request that Performance Insights return a limited number of values for a dimension.</p>', 'DescribeDimensionKeysRequest$PartitionBy' => '<p>For each dimension specified in <code>GroupBy</code>, specify a secondary dimension to further subdivide the partition keys in the response.</p>', 'MetricQuery$GroupBy' => '<p>A specification for how to aggregate the data points from a query result. You must specify a valid dimension group. Performance Insights will return all of the dimensions within that group, unless you provide the names of specific dimensions within that group. You can also request that Performance Insights return a limited number of values for a dimension.</p>', ], ], 'DimensionKeyDescription' => [ 'base' => '<p>An array of descriptions and aggregated values for each dimension within a dimension group.</p>', 'refs' => [ 'DimensionKeyDescriptionList$member' => NULL, ], ], 'DimensionKeyDescriptionList' => [ 'base' => NULL, 'refs' => [ 'DescribeDimensionKeysResponse$Keys' => '<p>The dimension keys that were requested.</p>', ], ], 'DimensionKeyDetail' => [ 'base' => '<p>An object that describes the details for a specified dimension.</p>', 'refs' => [ 'DimensionKeyDetailList$member' => NULL, ], ], 'DimensionKeyDetailList' => [ 'base' => NULL, 'refs' => [ 'GetDimensionKeyDetailsResponse$Dimensions' => '<p>The details for the requested dimensions.</p>', ], ], 'DimensionMap' => [ 'base' => NULL, 'refs' => [ 'DimensionKeyDescription$Dimensions' => '<p>A map of name-value pairs for the dimensions in the group.</p>', 'ResponsePartitionKey$Dimensions' => '<p>A dimension map that contains the dimension(s) for this partition.</p>', 'ResponseResourceMetricKey$Dimensions' => '<p>The valid dimensions for the metric.</p>', ], ], 'Double' => [ 'base' => NULL, 'refs' => [ 'DataPoint$Value' => '<p>The actual value associated with a particular <code>Timestamp</code>.</p>', 'DimensionKeyDescription$Total' => '<p>The aggregated metric value for the dimension(s), over the requested time range.</p>', 'MetricValuesList$member' => NULL, ], ], 'ErrorString' => [ 'base' => NULL, 'refs' => [ 'InternalServiceError$Message' => NULL, 'InvalidArgumentException$Message' => NULL, 'NotAuthorizedException$Message' => NULL, ], ], 'GetDimensionKeyDetailsRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetDimensionKeyDetailsResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetResourceMetricsRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetResourceMetricsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ISOTimestamp' => [ 'base' => NULL, 'refs' => [ 'DataPoint$Timestamp' => '<p>The time, in epoch format, associated with a particular <code>Value</code>.</p>', 'DescribeDimensionKeysRequest$StartTime' => '<p>The date and time specifying the beginning of the requested time series data. You must specify a <code>StartTime</code> within the past 7 days. The value specified is <i>inclusive</i>, which means that data points equal to or greater than <code>StartTime</code> are returned.</p> <p>The value for <code>StartTime</code> must be earlier than the value for <code>EndTime</code>.</p>', 'DescribeDimensionKeysRequest$EndTime' => '<p>The date and time specifying the end of the requested time series data. The value specified is <i>exclusive</i>, which means that data points less than (but not equal to) <code>EndTime</code> are returned.</p> <p>The value for <code>EndTime</code> must be later than the value for <code>StartTime</code>.</p>', 'DescribeDimensionKeysResponse$AlignedStartTime' => '<p>The start time for the returned dimension keys, after alignment to a granular boundary (as specified by <code>PeriodInSeconds</code>). <code>AlignedStartTime</code> will be less than or equal to the value of the user-specified <code>StartTime</code>.</p>', 'DescribeDimensionKeysResponse$AlignedEndTime' => '<p>The end time for the returned dimension keys, after alignment to a granular boundary (as specified by <code>PeriodInSeconds</code>). <code>AlignedEndTime</code> will be greater than or equal to the value of the user-specified <code>Endtime</code>.</p>', 'GetResourceMetricsRequest$StartTime' => '<p>The date and time specifying the beginning of the requested time series data. You can\'t specify a <code>StartTime</code> that\'s earlier than 7 days ago. The value specified is <i>inclusive</i> - data points equal to or greater than <code>StartTime</code> will be returned.</p> <p>The value for <code>StartTime</code> must be earlier than the value for <code>EndTime</code>.</p>', 'GetResourceMetricsRequest$EndTime' => '<p>The date and time specifying the end of the requested time series data. The value specified is <i>exclusive</i> - data points less than (but not equal to) <code>EndTime</code> will be returned.</p> <p>The value for <code>EndTime</code> must be later than the value for <code>StartTime</code>.</p>', 'GetResourceMetricsResponse$AlignedStartTime' => '<p>The start time for the returned metrics, after alignment to a granular boundary (as specified by <code>PeriodInSeconds</code>). <code>AlignedStartTime</code> will be less than or equal to the value of the user-specified <code>StartTime</code>.</p>', 'GetResourceMetricsResponse$AlignedEndTime' => '<p>The end time for the returned metrics, after alignment to a granular boundary (as specified by <code>PeriodInSeconds</code>). <code>AlignedEndTime</code> will be greater than or equal to the value of the user-specified <code>Endtime</code>.</p>', ], ], 'IdentifierString' => [ 'base' => NULL, 'refs' => [ 'GetDimensionKeyDetailsRequest$Identifier' => '<p>The ID for a data source from which to gather dimension data. This ID must be immutable and unique within an AWS Region. When a DB instance is the data source, specify its <code>DbiResourceId</code> value. For example, specify <code>db-ABCDEFGHIJKLMNOPQRSTU1VW2X</code>. </p>', ], ], 'Integer' => [ 'base' => NULL, 'refs' => [ 'DescribeDimensionKeysRequest$PeriodInSeconds' => '<p>The granularity, in seconds, of the data points returned from Performance Insights. A period can be as short as one second, or as long as one day (86400 seconds). Valid values are:</p> <ul> <li> <p> <code>1</code> (one second)</p> </li> <li> <p> <code>60</code> (one minute)</p> </li> <li> <p> <code>300</code> (five minutes)</p> </li> <li> <p> <code>3600</code> (one hour)</p> </li> <li> <p> <code>86400</code> (twenty-four hours)</p> </li> </ul> <p>If you don\'t specify <code>PeriodInSeconds</code>, then Performance Insights chooses a value for you, with a goal of returning roughly 100-200 data points in the response.</p>', 'GetResourceMetricsRequest$PeriodInSeconds' => '<p>The granularity, in seconds, of the data points returned from Performance Insights. A period can be as short as one second, or as long as one day (86400 seconds). Valid values are:</p> <ul> <li> <p> <code>1</code> (one second)</p> </li> <li> <p> <code>60</code> (one minute)</p> </li> <li> <p> <code>300</code> (five minutes)</p> </li> <li> <p> <code>3600</code> (one hour)</p> </li> <li> <p> <code>86400</code> (twenty-four hours)</p> </li> </ul> <p>If you don\'t specify <code>PeriodInSeconds</code>, then Performance Insights will choose a value for you, with a goal of returning roughly 100-200 data points in the response.</p>', ], ], 'InternalServiceError' => [ 'base' => '<p>The request failed due to an unknown error.</p>', 'refs' => [], ], 'InvalidArgumentException' => [ 'base' => '<p>One of the arguments provided is invalid for this request.</p>', 'refs' => [], ], 'Limit' => [ 'base' => NULL, 'refs' => [ 'DimensionGroup$Limit' => '<p>The maximum number of items to fetch for this dimension group.</p>', ], ], 'MaxResults' => [ 'base' => NULL, 'refs' => [ 'DescribeDimensionKeysRequest$MaxResults' => '<p>The maximum number of items to return in the response. If more items exist than the specified <code>MaxRecords</code> value, a pagination token is included in the response so that the remaining results can be retrieved. </p>', 'GetResourceMetricsRequest$MaxResults' => '<p>The maximum number of items to return in the response. If more items exist than the specified <code>MaxRecords</code> value, a pagination token is included in the response so that the remaining results can be retrieved. </p>', ], ], 'MetricKeyDataPoints' => [ 'base' => '<p>A time-ordered series of data points, corresponding to a dimension of a Performance Insights metric.</p>', 'refs' => [ 'MetricKeyDataPointsList$member' => NULL, ], ], 'MetricKeyDataPointsList' => [ 'base' => NULL, 'refs' => [ 'GetResourceMetricsResponse$MetricList' => '<p>An array of metric results,, where each array element contains all of the data points for a particular dimension.</p>', ], ], 'MetricQuery' => [ 'base' => '<p>A single query to be processed. You must provide the metric to query. If no other parameters are specified, Performance Insights returns all of the data points for that metric. You can optionally request that the data points be aggregated by dimension group ( <code>GroupBy</code>), and return only those data points that match your criteria (<code>Filter</code>).</p>', 'refs' => [ 'MetricQueryList$member' => NULL, ], ], 'MetricQueryFilterMap' => [ 'base' => NULL, 'refs' => [ 'DescribeDimensionKeysRequest$Filter' => '<p>One or more filters to apply in the request. Restrictions:</p> <ul> <li> <p>Any number of filters by the same dimension, as specified in the <code>GroupBy</code> or <code>Partition</code> parameters.</p> </li> <li> <p>A single filter for any other dimension in this dimension group.</p> </li> </ul>', 'MetricQuery$Filter' => '<p>One or more filters to apply in the request. Restrictions:</p> <ul> <li> <p>Any number of filters by the same dimension, as specified in the <code>GroupBy</code> parameter.</p> </li> <li> <p>A single filter for any other dimension in this dimension group.</p> </li> </ul>', ], ], 'MetricQueryList' => [ 'base' => NULL, 'refs' => [ 'GetResourceMetricsRequest$MetricQueries' => '<p>An array of one or more queries to perform. Each query must specify a Performance Insights metric, and can optionally specify aggregation and filtering criteria.</p>', ], ], 'MetricValuesList' => [ 'base' => NULL, 'refs' => [ 'DimensionKeyDescription$Partitions' => '<p>If <code>PartitionBy</code> was specified, <code>PartitionKeys</code> contains the dimensions that were.</p>', ], ], 'NextToken' => [ 'base' => NULL, 'refs' => [ 'DescribeDimensionKeysRequest$NextToken' => '<p>An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the token, up to the value specified by <code>MaxRecords</code>.</p>', 'DescribeDimensionKeysResponse$NextToken' => '<p>An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the token, up to the value specified by <code>MaxRecords</code>.</p>', 'GetResourceMetricsRequest$NextToken' => '<p>An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the token, up to the value specified by <code>MaxRecords</code>.</p>', 'GetResourceMetricsResponse$NextToken' => '<p>An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the token, up to the value specified by <code>MaxRecords</code>.</p>', ], ], 'NotAuthorizedException' => [ 'base' => '<p>The user is not authorized to perform this request.</p>', 'refs' => [], ], 'RequestString' => [ 'base' => NULL, 'refs' => [ 'DescribeDimensionKeysRequest$Identifier' => '<p>An immutable, AWS Region-unique identifier for a data source. Performance Insights gathers metrics from this data source.</p> <p>To use an Amazon RDS instance as a data source, you specify its <code>DbiResourceId</code> value. For example, specify <code>db-FAIHNTYBKTGAUSUZQYPDS2GW4A</code> </p>', 'DescribeDimensionKeysRequest$Metric' => '<p>The name of a Performance Insights metric to be measured.</p> <p>Valid values for <code>Metric</code> are:</p> <ul> <li> <p> <code>db.load.avg</code> - a scaled representation of the number of active sessions for the database engine.</p> </li> <li> <p> <code>db.sampledload.avg</code> - the raw number of active sessions for the database engine.</p> </li> </ul> <p>If the number of active sessions is less than an internal Performance Insights threshold, <code>db.load.avg</code> and <code>db.sampledload.avg</code> are the same value. If the number of active sessions is greater than the internal threshold, Performance Insights samples the active sessions, with <code>db.load.avg</code> showing the scaled values, <code>db.sampledload.avg</code> showing the raw values, and <code>db.sampledload.avg</code> less than <code>db.load.avg</code>. For most use cases, you can query <code>db.load.avg</code> only. </p>', 'DimensionGroup$Group' => '<p>The name of the dimension group. Valid values are:</p> <ul> <li> <p> <code>db</code> - The name of the database to which the client is connected (only Aurora PostgreSQL, RDS PostgreSQL, Aurora MySQL, RDS MySQL, and MariaDB)</p> </li> <li> <p> <code>db.application</code> - The name of the application that is connected to the database (only Aurora PostgreSQL and RDS PostgreSQL)</p> </li> <li> <p> <code>db.host</code> - The host name of the connected client (all engines)</p> </li> <li> <p> <code>db.session_type</code> - The type of the current session (only Aurora PostgreSQL and RDS PostgreSQL)</p> </li> <li> <p> <code>db.sql</code> - The SQL that is currently executing (all engines)</p> </li> <li> <p> <code>db.sql_tokenized</code> - The SQL digest (all engines)</p> </li> <li> <p> <code>db.wait_event</code> - The event for which the database backend is waiting (all engines)</p> </li> <li> <p> <code>db.wait_event_type</code> - The type of event for which the database backend is waiting (all engines)</p> </li> <li> <p> <code>db.user</code> - The user logged in to the database (all engines)</p> </li> </ul>', 'DimensionMap$key' => NULL, 'DimensionMap$value' => NULL, 'GetDimensionKeyDetailsRequest$Group' => '<p>The name of the dimension group. The only valid value is <code>db.sql</code>. Performance Insights searches the specified group for the dimension group ID.</p>', 'GetDimensionKeyDetailsRequest$GroupIdentifier' => '<p>The ID of the dimension group from which to retrieve dimension details. For dimension group <code>db.sql</code>, the group ID is <code>db.sql.id</code>.</p>', 'GetResourceMetricsRequest$Identifier' => '<p>An immutable, AWS Region-unique identifier for a data source. Performance Insights gathers metrics from this data source.</p> <p>To use a DB instance as a data source, specify its <code>DbiResourceId</code> value. For example, specify <code>db-FAIHNTYBKTGAUSUZQYPDS2GW4A</code>.</p>', 'MetricQuery$Metric' => '<p>The name of a Performance Insights metric to be measured.</p> <p>Valid values for <code>Metric</code> are:</p> <ul> <li> <p> <code>db.load.avg</code> - a scaled representation of the number of active sessions for the database engine.</p> </li> <li> <p> <code>db.sampledload.avg</code> - the raw number of active sessions for the database engine.</p> </li> </ul> <p>If the number of active sessions is less than an internal Performance Insights threshold, <code>db.load.avg</code> and <code>db.sampledload.avg</code> are the same value. If the number of active sessions is greater than the internal threshold, Performance Insights samples the active sessions, with <code>db.load.avg</code> showing the scaled values, <code>db.sampledload.avg</code> showing the raw values, and <code>db.sampledload.avg</code> less than <code>db.load.avg</code>. For most use cases, you can query <code>db.load.avg</code> only. </p>', 'MetricQueryFilterMap$key' => NULL, 'MetricQueryFilterMap$value' => NULL, 'RequestStringList$member' => NULL, 'RequestedDimensionList$member' => NULL, ], ], 'RequestStringList' => [ 'base' => NULL, 'refs' => [ 'DimensionGroup$Dimensions' => '<p>A list of specific dimensions from a dimension group. If this parameter is not present, then it signifies that all of the dimensions in the group were requested, or are present in the response.</p> <p>Valid values for elements in the <code>Dimensions</code> array are:</p> <ul> <li> <p> <code>db.application.name</code> - The name of the application that is connected to the database (only Aurora PostgreSQL and RDS PostgreSQL)</p> </li> <li> <p> <code>db.host.id</code> - The host ID of the connected client (all engines)</p> </li> <li> <p> <code>db.host.name</code> - The host name of the connected client (all engines)</p> </li> <li> <p> <code>db.name</code> - The name of the database to which the client is connected (only Aurora PostgreSQL, RDS PostgreSQL, Aurora MySQL, RDS MySQL, and MariaDB)</p> </li> <li> <p> <code>db.session_type.name</code> - The type of the current session (only Aurora PostgreSQL and RDS PostgreSQL)</p> </li> <li> <p> <code>db.sql.id</code> - The SQL ID generated by Performance Insights (all engines)</p> </li> <li> <p> <code>db.sql.db_id</code> - The SQL ID generated by the database (all engines)</p> </li> <li> <p> <code>db.sql.statement</code> - The SQL text that is being executed (all engines)</p> </li> <li> <p> <code>db.sql.tokenized_id</code> </p> </li> <li> <p> <code>db.sql_tokenized.id</code> - The SQL digest ID generated by Performance Insights (all engines)</p> </li> <li> <p> <code>db.sql_tokenized.db_id</code> - SQL digest ID generated by the database (all engines)</p> </li> <li> <p> <code>db.sql_tokenized.statement</code> - The SQL digest text (all engines)</p> </li> <li> <p> <code>db.user.id</code> - The ID of the user logged in to the database (all engines)</p> </li> <li> <p> <code>db.user.name</code> - The name of the user logged in to the database (all engines)</p> </li> <li> <p> <code>db.wait_event.name</code> - The event for which the backend is waiting (all engines)</p> </li> <li> <p> <code>db.wait_event.type</code> - The type of event for which the backend is waiting (all engines)</p> </li> <li> <p> <code>db.wait_event_type.name</code> - The name of the event type for which the backend is waiting (all engines)</p> </li> </ul>', ], ], 'RequestedDimensionList' => [ 'base' => NULL, 'refs' => [ 'GetDimensionKeyDetailsRequest$RequestedDimensions' => '<p>A list of dimensions to retrieve the detail data for within the given dimension group. For the dimension group <code>db.sql</code>, specify either the full dimension name <code>db.sql.statement</code> or the short dimension name <code>statement</code>. If you don\'t specify this parameter, Performance Insights returns all dimension data within the specified dimension group.</p>', ], ], 'ResponsePartitionKey' => [ 'base' => '<p>If <code>PartitionBy</code> was specified in a <code>DescribeDimensionKeys</code> request, the dimensions are returned in an array. Each element in the array specifies one dimension. </p>', 'refs' => [ 'ResponsePartitionKeyList$member' => NULL, ], ], 'ResponsePartitionKeyList' => [ 'base' => NULL, 'refs' => [ 'DescribeDimensionKeysResponse$PartitionKeys' => '<p>If <code>PartitionBy</code> was present in the request, <code>PartitionKeys</code> contains the breakdown of dimension keys by the specified partitions.</p>', ], ], 'ResponseResourceMetricKey' => [ 'base' => '<p>An object describing a Performance Insights metric and one or more dimensions for that metric.</p>', 'refs' => [ 'MetricKeyDataPoints$Key' => '<p>The dimension(s) to which the data points apply.</p>', ], ], 'ServiceType' => [ 'base' => NULL, 'refs' => [ 'DescribeDimensionKeysRequest$ServiceType' => '<p>The AWS service for which Performance Insights will return metrics. The only valid value for <i>ServiceType</i> is <code>RDS</code>.</p>', 'GetDimensionKeyDetailsRequest$ServiceType' => '<p>The AWS service for which Performance Insights returns data. The only valid value is <code>RDS</code>.</p>', 'GetResourceMetricsRequest$ServiceType' => '<p>The AWS service for which Performance Insights returns metrics. The only valid value for <i>ServiceType</i> is <code>RDS</code>.</p>', ], ], 'String' => [ 'base' => NULL, 'refs' => [ 'DimensionKeyDetail$Value' => '<p>The value of the dimension detail data. For the <code>db.sql.statement</code> dimension, this value is either the full or truncated SQL query, depending on the return status.</p>', 'DimensionKeyDetail$Dimension' => '<p>The full name of the dimension. The full name includes the group name and key name. The only valid value is <code>db.sql.statement</code>. </p>', 'GetResourceMetricsResponse$Identifier' => '<p>An immutable, AWS Region-unique identifier for a data source. Performance Insights gathers metrics from this data source.</p> <p>To use a DB instance as a data source, you specify its <code>DbiResourceId</code> value - for example: <code>db-FAIHNTYBKTGAUSUZQYPDS2GW4A</code> </p>', 'ResponseResourceMetricKey$Metric' => '<p>The name of a Performance Insights metric to be measured.</p> <p>Valid values for <code>Metric</code> are:</p> <ul> <li> <p> <code>db.load.avg</code> - a scaled representation of the number of active sessions for the database engine.</p> </li> <li> <p> <code>db.sampledload.avg</code> - the raw number of active sessions for the database engine.</p> </li> </ul> <p>If the number of active sessions is less than an internal Performance Insights threshold, <code>db.load.avg</code> and <code>db.sampledload.avg</code> are the same value. If the number of active sessions is greater than the internal threshold, Performance Insights samples the active sessions, with <code>db.load.avg</code> showing the scaled values, <code>db.sampledload.avg</code> showing the raw values, and <code>db.sampledload.avg</code> less than <code>db.load.avg</code>. For most use cases, you can query <code>db.load.avg</code> only. </p>', ], ], ],];
