<?php
// This file was auto-generated from sdk-root/src/data/logs/2014-03-28/docs-2.json
return [ 'version' => '2.0', 'service' => '<p>You can use Amazon CloudWatch Logs to monitor, store, and access your log files from EC2 instances, CloudTrail, and other sources. You can then retrieve the associated log data from CloudWatch Logs using the CloudWatch console, CloudWatch Logs commands in the Amazon Web Services CLI, CloudWatch Logs API, or CloudWatch Logs SDK.</p> <p>You can use CloudWatch Logs to:</p> <ul> <li> <p> <b>Monitor logs from EC2 instances in real-time</b>: You can use CloudWatch Logs to monitor applications and systems using log data. For example, CloudWatch Logs can track the number of errors that occur in your application logs and send you a notification whenever the rate of errors exceeds a threshold that you specify. CloudWatch Logs uses your log data for monitoring so no code changes are required. For example, you can monitor application logs for specific literal terms (such as "NullReferenceException") or count the number of occurrences of a literal term at a particular position in log data (such as "404" status codes in an Apache access log). When the term you are searching for is found, CloudWatch Logs reports the data to a CloudWatch metric that you specify.</p> </li> <li> <p> <b>Monitor CloudTrail logged events</b>: You can create alarms in CloudWatch and receive notifications of particular API activity as captured by CloudTrail. You can use the notification to perform troubleshooting.</p> </li> <li> <p> <b>Archive log data</b>: You can use CloudWatch Logs to store your log data in highly durable storage. You can change the log retention setting so that any log events older than this setting are automatically deleted. The CloudWatch Logs agent makes it easy to quickly send both rotated and non-rotated log data off of a host and into the log service. You can then access the raw log data when you need it.</p> </li> </ul>', 'operations' => [ 'AssociateKmsKey' => '<p>Associates the specified Key Management Service customer master key (CMK) with the specified log group.</p> <p>Associating an KMS CMK with a log group overrides any existing associations between the log group and a CMK. After a CMK is associated with a log group, all newly ingested data for the log group is encrypted using the CMK. This association is stored as long as the data encrypted with the CMK is still within CloudWatch Logs. This enables CloudWatch Logs to decrypt this data whenever it is requested.</p> <important> <p>CloudWatch Logs supports only symmetric CMKs. Do not use an associate an asymmetric CMK with your log group. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/symmetric-asymmetric.html">Using Symmetric and Asymmetric Keys</a>.</p> </important> <p>It can take up to 5 minutes for this operation to take effect.</p> <p>If you attempt to associate a CMK with a log group but the CMK does not exist or the CMK is disabled, you receive an <code>InvalidParameterException</code> error. </p>', 'CancelExportTask' => '<p>Cancels the specified export task.</p> <p>The task must be in the <code>PENDING</code> or <code>RUNNING</code> state.</p>', 'CreateExportTask' => '<p>Creates an export task, which allows you to efficiently export data from a log group to an Amazon S3 bucket. When you perform a <code>CreateExportTask</code> operation, you must use credentials that have permission to write to the S3 bucket that you specify as the destination.</p> <p>This is an asynchronous call. If all the required information is provided, this operation initiates an export task and responds with the ID of the task. After the task has started, you can use <a href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_DescribeExportTasks.html">DescribeExportTasks</a> to get the status of the export task. Each account can only have one active (<code>RUNNING</code> or <code>PENDING</code>) export task at a time. To cancel an export task, use <a href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_CancelExportTask.html">CancelExportTask</a>.</p> <p>You can export logs from multiple log groups or multiple time ranges to the same S3 bucket. To separate out log data for each export task, you can specify a prefix to be used as the Amazon S3 key prefix for all exported objects.</p> <p>Exporting to S3 buckets that are encrypted with AES-256 is supported. Exporting to S3 buckets encrypted with SSE-KMS is not supported. </p>', 'CreateLogGroup' => '<p>Creates a log group with the specified name. You can create up to 20,000 log groups per account.</p> <p>You must use the following guidelines when naming a log group:</p> <ul> <li> <p>Log group names must be unique within a region for an Amazon Web Services account.</p> </li> <li> <p>Log group names can be between 1 and 512 characters long.</p> </li> <li> <p>Log group names consist of the following characters: a-z, A-Z, 0-9, \'_\' (underscore), \'-\' (hyphen), \'/\' (forward slash), \'.\' (period), and \'#\' (number sign)</p> </li> </ul> <p>When you create a log group, by default the log events in the log group never expire. To set a retention policy so that events expire and are deleted after a specified time, use <a href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_PutRetentionPolicy.html">PutRetentionPolicy</a>.</p> <p>If you associate a Key Management Service customer master key (CMK) with the log group, ingested data is encrypted using the CMK. This association is stored as long as the data encrypted with the CMK is still within CloudWatch Logs. This enables CloudWatch Logs to decrypt this data whenever it is requested.</p> <p>If you attempt to associate a CMK with the log group but the CMK does not exist or the CMK is disabled, you receive an <code>InvalidParameterException</code> error. </p> <important> <p>CloudWatch Logs supports only symmetric CMKs. Do not associate an asymmetric CMK with your log group. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/symmetric-asymmetric.html">Using Symmetric and Asymmetric Keys</a>.</p> </important>', 'CreateLogStream' => '<p>Creates a log stream for the specified log group. A log stream is a sequence of log events that originate from a single source, such as an application instance or a resource that is being monitored.</p> <p>There is no limit on the number of log streams that you can create for a log group. There is a limit of 50 TPS on <code>CreateLogStream</code> operations, after which transactions are throttled.</p> <p>You must use the following guidelines when naming a log stream:</p> <ul> <li> <p>Log stream names must be unique within the log group.</p> </li> <li> <p>Log stream names can be between 1 and 512 characters long.</p> </li> <li> <p>The \':\' (colon) and \'*\' (asterisk) characters are not allowed.</p> </li> </ul>', 'DeleteDestination' => '<p>Deletes the specified destination, and eventually disables all the subscription filters that publish to it. This operation does not delete the physical resource encapsulated by the destination.</p>', 'DeleteLogGroup' => '<p>Deletes the specified log group and permanently deletes all the archived log events associated with the log group.</p>', 'DeleteLogStream' => '<p>Deletes the specified log stream and permanently deletes all the archived log events associated with the log stream.</p>', 'DeleteMetricFilter' => '<p>Deletes the specified metric filter.</p>', 'DeleteQueryDefinition' => '<p>Deletes a saved CloudWatch Logs Insights query definition. A query definition contains details about a saved CloudWatch Logs Insights query.</p> <p>Each <code>DeleteQueryDefinition</code> operation can delete one query definition.</p> <p>You must have the <code>logs:DeleteQueryDefinition</code> permission to be able to perform this operation.</p>', 'DeleteResourcePolicy' => '<p>Deletes a resource policy from this account. This revokes the access of the identities in that policy to put log events to this account.</p>', 'DeleteRetentionPolicy' => '<p>Deletes the specified retention policy.</p> <p>Log events do not expire if they belong to log groups without a retention policy.</p>', 'DeleteSubscriptionFilter' => '<p>Deletes the specified subscription filter.</p>', 'DescribeDestinations' => '<p>Lists all your destinations. The results are ASCII-sorted by destination name.</p>', 'DescribeExportTasks' => '<p>Lists the specified export tasks. You can list all your export tasks or filter the results based on task ID or task status.</p>', 'DescribeLogGroups' => '<p>Lists the specified log groups. You can list all your log groups or filter the results by prefix. The results are ASCII-sorted by log group name.</p> <p>CloudWatch Logs doesn’t support IAM policies that control access to the <code>DescribeLogGroups</code> action by using the <code>aws:ResourceTag/<i>key-name</i> </code> condition key. Other CloudWatch Logs actions do support the use of the <code>aws:ResourceTag/<i>key-name</i> </code> condition key to control access. For more information about using tags to control access, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_tags.html">Controlling access to Amazon Web Services resources using tags</a>.</p>', 'DescribeLogStreams' => '<p>Lists the log streams for the specified log group. You can list all the log streams or filter the results by prefix. You can also control how the results are ordered.</p> <p>This operation has a limit of five transactions per second, after which transactions are throttled.</p>', 'DescribeMetricFilters' => '<p>Lists the specified metric filters. You can list all of the metric filters or filter the results by log name, prefix, metric name, or metric namespace. The results are ASCII-sorted by filter name.</p>', 'DescribeQueries' => '<p>Returns a list of CloudWatch Logs Insights queries that are scheduled, executing, or have been executed recently in this account. You can request all queries or limit it to queries of a specific log group or queries with a certain status.</p>', 'DescribeQueryDefinitions' => '<p>This operation returns a paginated list of your saved CloudWatch Logs Insights query definitions.</p> <p>You can use the <code>queryDefinitionNamePrefix</code> parameter to limit the results to only the query definitions that have names that start with a certain string.</p>', 'DescribeResourcePolicies' => '<p>Lists the resource policies in this account.</p>', 'DescribeSubscriptionFilters' => '<p>Lists the subscription filters for the specified log group. You can list all the subscription filters or filter the results by prefix. The results are ASCII-sorted by filter name.</p>', 'DisassociateKmsKey' => '<p>Disassociates the associated Key Management Service customer master key (CMK) from the specified log group.</p> <p>After the KMS CMK is disassociated from the log group, CloudWatch Logs stops encrypting newly ingested data for the log group. All previously ingested data remains encrypted, and CloudWatch Logs requires permissions for the CMK whenever the encrypted data is requested.</p> <p>Note that it can take up to 5 minutes for this operation to take effect.</p>', 'FilterLogEvents' => '<p>Lists log events from the specified log group. You can list all the log events or filter the results using a filter pattern, a time range, and the name of the log stream.</p> <p>By default, this operation returns as many log events as can fit in 1 MB (up to 10,000 log events) or all the events found within the time range that you specify. If the results include a token, then there are more log events available, and you can get additional results by specifying the token in a subsequent call. This operation can return empty results while there are more log events available through the token.</p> <p>The returned log events are sorted by event timestamp, the timestamp when the event was ingested by CloudWatch Logs, and the ID of the <code>PutLogEvents</code> request.</p>', 'GetLogEvents' => '<p>Lists log events from the specified log stream. You can list all of the log events or filter using a time range.</p> <p>By default, this operation returns as many log events as can fit in a response size of 1MB (up to 10,000 log events). You can get additional log events by specifying one of the tokens in a subsequent call. This operation can return empty results while there are more log events available through the token.</p>', 'GetLogGroupFields' => '<p>Returns a list of the fields that are included in log events in the specified log group, along with the percentage of log events that contain each field. The search is limited to a time period that you specify.</p> <p>In the results, fields that start with @ are fields generated by CloudWatch Logs. For example, <code>@timestamp</code> is the timestamp of each log event. For more information about the fields that are generated by CloudWatch logs, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CWL_AnalyzeLogData-discoverable-fields.html">Supported Logs and Discovered Fields</a>.</p> <p>The response results are sorted by the frequency percentage, starting with the highest percentage.</p>', 'GetLogRecord' => '<p>Retrieves all of the fields and values of a single log event. All fields are retrieved, even if the original query that produced the <code>logRecordPointer</code> retrieved only a subset of fields. Fields are returned as field name/field value pairs.</p> <p>The full unparsed log event is returned within <code>@message</code>.</p>', 'GetQueryResults' => '<p>Returns the results from the specified query.</p> <p>Only the fields requested in the query are returned, along with a <code>@ptr</code> field, which is the identifier for the log record. You can use the value of <code>@ptr</code> in a <a href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_GetLogRecord.html">GetLogRecord</a> operation to get the full log record.</p> <p> <code>GetQueryResults</code> does not start a query execution. To run a query, use <a href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_StartQuery.html">StartQuery</a>.</p> <p>If the value of the <code>Status</code> field in the output is <code>Running</code>, this operation returns only partial results. If you see a value of <code>Scheduled</code> or <code>Running</code> for the status, you can retry the operation later to see the final results. </p>', 'ListTagsLogGroup' => '<p>Lists the tags for the specified log group.</p>', 'PutDestination' => '<p>Creates or updates a destination. This operation is used only to create destinations for cross-account subscriptions.</p> <p>A destination encapsulates a physical resource (such as an Amazon Kinesis stream) and enables you to subscribe to a real-time stream of log events for a different account, ingested using <a href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_PutLogEvents.html">PutLogEvents</a>.</p> <p>Through an access policy, a destination controls what is written to it. By default, <code>PutDestination</code> does not set any access policy with the destination, which means a cross-account user cannot call <a href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_PutSubscriptionFilter.html">PutSubscriptionFilter</a> against this destination. To enable this, the destination owner must call <a href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_PutDestinationPolicy.html">PutDestinationPolicy</a> after <code>PutDestination</code>.</p> <p>To perform a <code>PutDestination</code> operation, you must also have the <code>iam:PassRole</code> permission.</p>', 'PutDestinationPolicy' => '<p>Creates or updates an access policy associated with an existing destination. An access policy is an <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies_overview.html">IAM policy document</a> that is used to authorize claims to register a subscription filter against a given destination.</p> <p>If multiple Amazon Web Services accounts are sending logs to this destination, each sender account must be listed separately in the policy. The policy does not support specifying <code>*</code> as the Principal or the use of the <code>aws:PrincipalOrgId</code> global key.</p>', 'PutLogEvents' => '<p>Uploads a batch of log events to the specified log stream.</p> <p>You must include the sequence token obtained from the response of the previous call. An upload in a newly created log stream does not require a sequence token. You can also get the sequence token in the <code>expectedSequenceToken</code> field from <code>InvalidSequenceTokenException</code>. If you call <code>PutLogEvents</code> twice within a narrow time period using the same value for <code>sequenceToken</code>, both calls might be successful or one might be rejected.</p> <p>The batch of events must satisfy the following constraints:</p> <ul> <li> <p>The maximum batch size is 1,048,576 bytes. This size is calculated as the sum of all event messages in UTF-8, plus 26 bytes for each log event.</p> </li> <li> <p>None of the log events in the batch can be more than 2 hours in the future.</p> </li> <li> <p>None of the log events in the batch can be older than 14 days or older than the retention period of the log group.</p> </li> <li> <p>The log events in the batch must be in chronological order by their timestamp. The timestamp is the time the event occurred, expressed as the number of milliseconds after Jan 1, 1970 00:00:00 UTC. (In Amazon Web Services Tools for PowerShell and the Amazon Web Services SDK for .NET, the timestamp is specified in .NET format: yyyy-mm-ddThh:mm:ss. For example, 2017-09-15T13:45:30.) </p> </li> <li> <p>A batch of log events in a single request cannot span more than 24 hours. Otherwise, the operation fails.</p> </li> <li> <p>The maximum number of log events in a batch is 10,000.</p> </li> <li> <p>There is a quota of 5 requests per second per log stream. Additional requests are throttled. This quota can\'t be changed.</p> </li> </ul> <p>If a call to <code>PutLogEvents</code> returns "UnrecognizedClientException" the most likely cause is an invalid Amazon Web Services access key ID or secret key. </p>', 'PutMetricFilter' => '<p>Creates or updates a metric filter and associates it with the specified log group. Metric filters allow you to configure rules to extract metric data from log events ingested through <a href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_PutLogEvents.html">PutLogEvents</a>.</p> <p>The maximum number of metric filters that can be associated with a log group is 100.</p> <p>When you create a metric filter, you can also optionally assign a unit and dimensions to the metric that is created.</p> <important> <p>Metrics extracted from log events are charged as custom metrics. To prevent unexpected high charges, do not specify high-cardinality fields such as <code>IPAddress</code> or <code>requestID</code> as dimensions. Each different value found for a dimension is treated as a separate metric and accrues charges as a separate custom metric. </p> <p>To help prevent accidental high charges, Amazon disables a metric filter if it generates 1000 different name/value pairs for the dimensions that you have specified within a certain amount of time.</p> <p>You can also set up a billing alarm to alert you if your charges are higher than expected. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/monitor_estimated_charges_with_cloudwatch.html"> Creating a Billing Alarm to Monitor Your Estimated Amazon Web Services Charges</a>. </p> </important>', 'PutQueryDefinition' => '<p>Creates or updates a query definition for CloudWatch Logs Insights. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/AnalyzingLogData.html">Analyzing Log Data with CloudWatch Logs Insights</a>.</p> <p>To update a query definition, specify its <code>queryDefinitionId</code> in your request. The values of <code>name</code>, <code>queryString</code>, and <code>logGroupNames</code> are changed to the values that you specify in your update operation. No current values are retained from the current query definition. For example, if you update a current query definition that includes log groups, and you don\'t specify the <code>logGroupNames</code> parameter in your update operation, the query definition changes to contain no log groups.</p> <p>You must have the <code>logs:PutQueryDefinition</code> permission to be able to perform this operation.</p>', 'PutResourcePolicy' => '<p>Creates or updates a resource policy allowing other Amazon Web Services services to put log events to this account, such as Amazon Route 53. An account can have up to 10 resource policies per Amazon Web Services Region.</p>', 'PutRetentionPolicy' => '<p>Sets the retention of the specified log group. A retention policy allows you to configure the number of days for which to retain log events in the specified log group.</p>', 'PutSubscriptionFilter' => '<p>Creates or updates a subscription filter and associates it with the specified log group. Subscription filters allow you to subscribe to a real-time stream of log events ingested through <a href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_PutLogEvents.html">PutLogEvents</a> and have them delivered to a specific destination. When log events are sent to the receiving service, they are Base64 encoded and compressed with the gzip format.</p> <p>The following destinations are supported for subscription filters:</p> <ul> <li> <p>An Amazon Kinesis stream belonging to the same account as the subscription filter, for same-account delivery.</p> </li> <li> <p>A logical destination that belongs to a different account, for cross-account delivery.</p> </li> <li> <p>An Amazon Kinesis Firehose delivery stream that belongs to the same account as the subscription filter, for same-account delivery.</p> </li> <li> <p>An Lambda function that belongs to the same account as the subscription filter, for same-account delivery.</p> </li> </ul> <p>Each log group can have up to two subscription filters associated with it. If you are updating an existing filter, you must specify the correct name in <code>filterName</code>. </p> <p>To perform a <code>PutSubscriptionFilter</code> operation, you must also have the <code>iam:PassRole</code> permission.</p>', 'StartQuery' => '<p>Schedules a query of a log group using CloudWatch Logs Insights. You specify the log group and time range to query and the query string to use.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CWL_QuerySyntax.html">CloudWatch Logs Insights Query Syntax</a>.</p> <p>Queries time out after 15 minutes of execution. If your queries are timing out, reduce the time range being searched or partition your query into a number of queries.</p>', 'StopQuery' => '<p>Stops a CloudWatch Logs Insights query that is in progress. If the query has already ended, the operation returns an error indicating that the specified query is not running.</p>', 'TagLogGroup' => '<p>Adds or updates the specified tags for the specified log group.</p> <p>To list the tags for a log group, use <a href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_ListTagsLogGroup.html">ListTagsLogGroup</a>. To remove tags, use <a href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_UntagLogGroup.html">UntagLogGroup</a>.</p> <p>For more information about tags, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/Working-with-log-groups-and-streams.html#log-group-tagging">Tag Log Groups in Amazon CloudWatch Logs</a> in the <i>Amazon CloudWatch Logs User Guide</i>.</p> <p>CloudWatch Logs doesn’t support IAM policies that prevent users from assigning specified tags to log groups using the <code>aws:Resource/<i>key-name</i> </code> or <code>aws:TagKeys</code> condition keys. For more information about using tags to control access, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_tags.html">Controlling access to Amazon Web Services resources using tags</a>.</p>', 'TestMetricFilter' => '<p>Tests the filter pattern of a metric filter against a sample of log event messages. You can use this operation to validate the correctness of a metric filter pattern.</p>', 'UntagLogGroup' => '<p>Removes the specified tags from the specified log group.</p> <p>To list the tags for a log group, use <a href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_ListTagsLogGroup.html">ListTagsLogGroup</a>. To add tags, use <a href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_TagLogGroup.html">TagLogGroup</a>.</p> <p>CloudWatch Logs doesn’t support IAM policies that prevent users from assigning specified tags to log groups using the <code>aws:Resource/<i>key-name</i> </code> or <code>aws:TagKeys</code> condition keys. </p>', ], 'shapes' => [ 'AccessPolicy' => [ 'base' => NULL, 'refs' => [ 'Destination$accessPolicy' => '<p>An IAM policy document that governs which Amazon Web Services accounts can create subscription filters against this destination.</p>', 'PutDestinationPolicyRequest$accessPolicy' => '<p>An IAM policy document that authorizes cross-account users to deliver their log events to the associated destination. This can be up to 5120 bytes.</p>', ], ], 'Arn' => [ 'base' => NULL, 'refs' => [ 'Destination$arn' => '<p>The ARN of this destination.</p>', 'LogGroup$arn' => '<p>The Amazon Resource Name (ARN) of the log group.</p>', 'LogStream$arn' => '<p>The Amazon Resource Name (ARN) of the log stream.</p>', ], ], 'AssociateKmsKeyRequest' => [ 'base' => NULL, 'refs' => [], ], 'CancelExportTaskRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateExportTaskRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateExportTaskResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateLogGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateLogStreamRequest' => [ 'base' => NULL, 'refs' => [], ], 'DataAlreadyAcceptedException' => [ 'base' => '<p>The event was already logged.</p>', 'refs' => [], ], 'Days' => [ 'base' => '<p>The number of days to retain the log events in the specified log group. Possible values are: 1, 3, 5, 7, 14, 30, 60, 90, 120, 150, 180, 365, 400, 545, 731, 1827, and 3653.</p> <p>To set a log group to never have log events expire, use <a href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_DeleteRetentionPolicy.html">DeleteRetentionPolicy</a>. </p>', 'refs' => [ 'LogGroup$retentionInDays' => NULL, 'PutRetentionPolicyRequest$retentionInDays' => NULL, ], ], 'DefaultValue' => [ 'base' => NULL, 'refs' => [ 'MetricTransformation$defaultValue' => '<p>(Optional) The value to emit when a filter pattern does not match a log event. This value can be null.</p>', ], ], 'DeleteDestinationRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteLogGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteLogStreamRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteMetricFilterRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteQueryDefinitionRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteQueryDefinitionResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteResourcePolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteRetentionPolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteSubscriptionFilterRequest' => [ 'base' => NULL, 'refs' => [], ], 'Descending' => [ 'base' => NULL, 'refs' => [ 'DescribeLogStreamsRequest$descending' => '<p>If the value is true, results are returned in descending order. If the value is to false, results are returned in ascending order. The default value is false.</p>', ], ], 'DescribeDestinationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeDestinationsResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeExportTasksRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeExportTasksResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeLimit' => [ 'base' => NULL, 'refs' => [ 'DescribeDestinationsRequest$limit' => '<p>The maximum number of items returned. If you don\'t specify a value, the default is up to 50 items.</p>', 'DescribeExportTasksRequest$limit' => '<p>The maximum number of items returned. If you don\'t specify a value, the default is up to 50 items.</p>', 'DescribeLogGroupsRequest$limit' => '<p>The maximum number of items returned. If you don\'t specify a value, the default is up to 50 items.</p>', 'DescribeLogStreamsRequest$limit' => '<p>The maximum number of items returned. If you don\'t specify a value, the default is up to 50 items.</p>', 'DescribeMetricFiltersRequest$limit' => '<p>The maximum number of items returned. If you don\'t specify a value, the default is up to 50 items.</p>', 'DescribeResourcePoliciesRequest$limit' => '<p>The maximum number of resource policies to be displayed with one call of this API.</p>', 'DescribeSubscriptionFiltersRequest$limit' => '<p>The maximum number of items returned. If you don\'t specify a value, the default is up to 50 items.</p>', ], ], 'DescribeLogGroupsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeLogGroupsResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeLogStreamsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeLogStreamsResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeMetricFiltersRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeMetricFiltersResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeQueriesMaxResults' => [ 'base' => NULL, 'refs' => [ 'DescribeQueriesRequest$maxResults' => '<p>Limits the number of returned queries to the specified number.</p>', ], ], 'DescribeQueriesRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeQueriesResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeQueryDefinitionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeQueryDefinitionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeResourcePoliciesRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeResourcePoliciesResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeSubscriptionFiltersRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeSubscriptionFiltersResponse' => [ 'base' => NULL, 'refs' => [], ], 'Destination' => [ 'base' => '<p>Represents a cross-account destination that receives subscription log events.</p>', 'refs' => [ 'Destinations$member' => NULL, 'PutDestinationResponse$destination' => '<p>The destination.</p>', ], ], 'DestinationArn' => [ 'base' => NULL, 'refs' => [ 'PutSubscriptionFilterRequest$destinationArn' => '<p>The ARN of the destination to deliver matching log events to. Currently, the supported destinations are:</p> <ul> <li> <p>An Amazon Kinesis stream belonging to the same account as the subscription filter, for same-account delivery.</p> </li> <li> <p>A logical destination (specified using an ARN) belonging to a different account, for cross-account delivery.</p> <p>If you are setting up a cross-account subscription, the destination must have an IAM policy associated with it that allows the sender to send logs to the destination. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_PutDestinationPolicy.html">PutDestinationPolicy</a>.</p> </li> <li> <p>An Amazon Kinesis Firehose delivery stream belonging to the same account as the subscription filter, for same-account delivery.</p> </li> <li> <p>A Lambda function belonging to the same account as the subscription filter, for same-account delivery.</p> </li> </ul>', 'SubscriptionFilter$destinationArn' => '<p>The Amazon Resource Name (ARN) of the destination.</p>', ], ], 'DestinationName' => [ 'base' => NULL, 'refs' => [ 'DeleteDestinationRequest$destinationName' => '<p>The name of the destination.</p>', 'DescribeDestinationsRequest$DestinationNamePrefix' => '<p>The prefix to match. If you don\'t specify a value, no prefix filter is applied.</p>', 'Destination$destinationName' => '<p>The name of the destination.</p>', 'PutDestinationPolicyRequest$destinationName' => '<p>A name for an existing destination.</p>', 'PutDestinationRequest$destinationName' => '<p>A name for the destination.</p>', ], ], 'Destinations' => [ 'base' => NULL, 'refs' => [ 'DescribeDestinationsResponse$destinations' => '<p>The destinations.</p>', ], ], 'Dimensions' => [ 'base' => NULL, 'refs' => [ 'MetricTransformation$dimensions' => '<p>The fields to use as dimensions for the metric. One metric filter can include as many as three dimensions.</p> <important> <p>Metrics extracted from log events are charged as custom metrics. To prevent unexpected high charges, do not specify high-cardinality fields such as <code>IPAddress</code> or <code>requestID</code> as dimensions. Each different value found for a dimension is treated as a separate metric and accrues charges as a separate custom metric. </p> <p>To help prevent accidental high charges, Amazon disables a metric filter if it generates 1000 different name/value pairs for the dimensions that you have specified within a certain amount of time.</p> <p>You can also set up a billing alarm to alert you if your charges are higher than expected. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/monitor_estimated_charges_with_cloudwatch.html"> Creating a Billing Alarm to Monitor Your Estimated Amazon Web Services Charges</a>. </p> </important>', ], ], 'DimensionsKey' => [ 'base' => NULL, 'refs' => [ 'Dimensions$key' => NULL, ], ], 'DimensionsValue' => [ 'base' => NULL, 'refs' => [ 'Dimensions$value' => NULL, ], ], 'DisassociateKmsKeyRequest' => [ 'base' => NULL, 'refs' => [], ], 'Distribution' => [ 'base' => '<p>The method used to distribute log data to the destination, which can be either random or grouped by log stream.</p>', 'refs' => [ 'PutSubscriptionFilterRequest$distribution' => '<p>The method used to distribute log data to the destination. By default, log data is grouped by log stream, but the grouping can be set to random for a more even distribution. This property is only applicable when the destination is an Amazon Kinesis stream. </p>', 'SubscriptionFilter$distribution' => NULL, ], ], 'EventId' => [ 'base' => NULL, 'refs' => [ 'FilteredLogEvent$eventId' => '<p>The ID of the event.</p>', ], ], 'EventMessage' => [ 'base' => NULL, 'refs' => [ 'FilteredLogEvent$message' => '<p>The data contained in the log event.</p>', 'InputLogEvent$message' => '<p>The raw event message.</p>', 'MetricFilterMatchRecord$eventMessage' => '<p>The raw event data.</p>', 'OutputLogEvent$message' => '<p>The data contained in the log event.</p>', 'TestEventMessages$member' => NULL, ], ], 'EventNumber' => [ 'base' => NULL, 'refs' => [ 'MetricFilterMatchRecord$eventNumber' => '<p>The event number.</p>', ], ], 'EventsLimit' => [ 'base' => NULL, 'refs' => [ 'FilterLogEventsRequest$limit' => '<p>The maximum number of events to return. The default is 10,000 events.</p>', 'GetLogEventsRequest$limit' => '<p>The maximum number of log events returned. If you don\'t specify a value, the maximum is as many log events as can fit in a response size of 1 MB, up to 10,000 log events.</p>', 'StartQueryRequest$limit' => '<p>The maximum number of log events to return in the query. If the query string uses the <code>fields</code> command, only the specified fields and their values are returned. The default is 1000.</p>', ], ], 'ExportDestinationBucket' => [ 'base' => NULL, 'refs' => [ 'CreateExportTaskRequest$destination' => '<p>The name of S3 bucket for the exported log data. The bucket must be in the same Amazon Web Services region.</p>', 'ExportTask$destination' => '<p>The name of the S3 bucket to which the log data was exported.</p>', ], ], 'ExportDestinationPrefix' => [ 'base' => NULL, 'refs' => [ 'CreateExportTaskRequest$destinationPrefix' => '<p>The prefix used as the start of the key for every object exported. If you don\'t specify a value, the default is <code>exportedlogs</code>.</p>', 'ExportTask$destinationPrefix' => '<p>The prefix that was used as the start of Amazon S3 key for every object exported.</p>', ], ], 'ExportTask' => [ 'base' => '<p>Represents an export task.</p>', 'refs' => [ 'ExportTasks$member' => NULL, ], ], 'ExportTaskExecutionInfo' => [ 'base' => '<p>Represents the status of an export task.</p>', 'refs' => [ 'ExportTask$executionInfo' => '<p>Execution information about the export task.</p>', ], ], 'ExportTaskId' => [ 'base' => NULL, 'refs' => [ 'CancelExportTaskRequest$taskId' => '<p>The ID of the export task.</p>', 'CreateExportTaskResponse$taskId' => '<p>The ID of the export task.</p>', 'DescribeExportTasksRequest$taskId' => '<p>The ID of the export task. Specifying a task ID filters the results to zero or one export tasks.</p>', 'ExportTask$taskId' => '<p>The ID of the export task.</p>', ], ], 'ExportTaskName' => [ 'base' => NULL, 'refs' => [ 'CreateExportTaskRequest$taskName' => '<p>The name of the export task.</p>', 'ExportTask$taskName' => '<p>The name of the export task.</p>', ], ], 'ExportTaskStatus' => [ 'base' => '<p>Represents the status of an export task.</p>', 'refs' => [ 'ExportTask$status' => '<p>The status of the export task.</p>', ], ], 'ExportTaskStatusCode' => [ 'base' => NULL, 'refs' => [ 'DescribeExportTasksRequest$statusCode' => '<p>The status code of the export task. Specifying a status code filters the results to zero or more export tasks.</p>', 'ExportTaskStatus$code' => '<p>The status code of the export task.</p>', ], ], 'ExportTaskStatusMessage' => [ 'base' => NULL, 'refs' => [ 'ExportTaskStatus$message' => '<p>The status message related to the status code.</p>', ], ], 'ExportTasks' => [ 'base' => NULL, 'refs' => [ 'DescribeExportTasksResponse$exportTasks' => '<p>The export tasks.</p>', ], ], 'ExtractedValues' => [ 'base' => NULL, 'refs' => [ 'MetricFilterMatchRecord$extractedValues' => '<p>The values extracted from the event data by the filter.</p>', ], ], 'Field' => [ 'base' => NULL, 'refs' => [ 'LogGroupField$name' => '<p>The name of a log field.</p>', 'LogRecord$key' => NULL, 'ResultField$field' => '<p>The log event field.</p>', ], ], 'FilterCount' => [ 'base' => NULL, 'refs' => [ 'LogGroup$metricFilterCount' => '<p>The number of metric filters.</p>', ], ], 'FilterLogEventsRequest' => [ 'base' => NULL, 'refs' => [], ], 'FilterLogEventsResponse' => [ 'base' => NULL, 'refs' => [], ], 'FilterName' => [ 'base' => NULL, 'refs' => [ 'DeleteMetricFilterRequest$filterName' => '<p>The name of the metric filter.</p>', 'DeleteSubscriptionFilterRequest$filterName' => '<p>The name of the subscription filter.</p>', 'DescribeMetricFiltersRequest$filterNamePrefix' => '<p>The prefix to match. CloudWatch Logs uses the value you set here only if you also include the <code>logGroupName</code> parameter in your request.</p>', 'DescribeSubscriptionFiltersRequest$filterNamePrefix' => '<p>The prefix to match. If you don\'t specify a value, no prefix filter is applied.</p>', 'MetricFilter$filterName' => '<p>The name of the metric filter.</p>', 'PutMetricFilterRequest$filterName' => '<p>A name for the metric filter.</p>', 'PutSubscriptionFilterRequest$filterName' => '<p>A name for the subscription filter. If you are updating an existing filter, you must specify the correct name in <code>filterName</code>. To find the name of the filter currently associated with a log group, use <a href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_DescribeSubscriptionFilters.html">DescribeSubscriptionFilters</a>.</p>', 'SubscriptionFilter$filterName' => '<p>The name of the subscription filter.</p>', ], ], 'FilterPattern' => [ 'base' => '<p>A symbolic description of how CloudWatch Logs should interpret the data in each log event. For example, a log event can contain timestamps, IP addresses, strings, and so on. You use the filter pattern to specify what to look for in the log event message.</p>', 'refs' => [ 'FilterLogEventsRequest$filterPattern' => '<p>The filter pattern to use. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/FilterAndPatternSyntax.html">Filter and Pattern Syntax</a>.</p> <p>If not provided, all the events are matched.</p>', 'MetricFilter$filterPattern' => NULL, 'PutMetricFilterRequest$filterPattern' => '<p>A filter pattern for extracting metric data out of ingested log events.</p>', 'PutSubscriptionFilterRequest$filterPattern' => '<p>A filter pattern for subscribing to a filtered stream of log events.</p>', 'SubscriptionFilter$filterPattern' => NULL, 'TestMetricFilterRequest$filterPattern' => NULL, ], ], 'FilteredLogEvent' => [ 'base' => '<p>Represents a matched event.</p>', 'refs' => [ 'FilteredLogEvents$member' => NULL, ], ], 'FilteredLogEvents' => [ 'base' => NULL, 'refs' => [ 'FilterLogEventsResponse$events' => '<p>The matched events.</p>', ], ], 'GetLogEventsRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetLogEventsResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetLogGroupFieldsRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetLogGroupFieldsResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetLogRecordRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetLogRecordResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetQueryResultsRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetQueryResultsResponse' => [ 'base' => NULL, 'refs' => [], ], 'InputLogEvent' => [ 'base' => '<p>Represents a log event, which is a record of activity that was recorded by the application or resource being monitored.</p>', 'refs' => [ 'InputLogEvents$member' => NULL, ], ], 'InputLogEvents' => [ 'base' => NULL, 'refs' => [ 'PutLogEventsRequest$logEvents' => '<p>The log events.</p>', ], ], 'InputLogStreamNames' => [ 'base' => NULL, 'refs' => [ 'FilterLogEventsRequest$logStreamNames' => '<p>Filters the results to only logs from the log streams in this list.</p> <p>If you specify a value for both <code>logStreamNamePrefix</code> and <code>logStreamNames</code>, the action returns an <code>InvalidParameterException</code> error.</p>', ], ], 'Interleaved' => [ 'base' => NULL, 'refs' => [ 'FilterLogEventsRequest$interleaved' => '<p>If the value is true, the operation makes a best effort to provide responses that contain events from multiple log streams within the log group, interleaved in a single response. If the value is false, all the matched log events in the first log stream are searched first, then those in the next log stream, and so on. The default is false.</p> <p> <b>Important:</b> Starting on June 17, 2019, this parameter is ignored and the value is assumed to be true. The response from this operation always interleaves events from multiple log streams within a log group.</p>', ], ], 'InvalidOperationException' => [ 'base' => '<p>The operation is not valid on the specified resource.</p>', 'refs' => [], ], 'InvalidParameterException' => [ 'base' => '<p>A parameter is specified incorrectly.</p>', 'refs' => [], ], 'InvalidSequenceTokenException' => [ 'base' => '<p>The sequence token is not valid. You can get the correct sequence token in the <code>expectedSequenceToken</code> field in the <code>InvalidSequenceTokenException</code> message. </p>', 'refs' => [], ], 'KmsKeyId' => [ 'base' => NULL, 'refs' => [ 'AssociateKmsKeyRequest$kmsKeyId' => '<p>The Amazon Resource Name (ARN) of the CMK to use when encrypting log data. This must be a symmetric CMK. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-kms">Amazon Resource Names - Key Management Service</a> and <a href="https://docs.aws.amazon.com/kms/latest/developerguide/symmetric-asymmetric.html">Using Symmetric and Asymmetric Keys</a>.</p>', 'CreateLogGroupRequest$kmsKeyId' => '<p>The Amazon Resource Name (ARN) of the CMK to use when encrypting log data. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-kms">Amazon Resource Names - Key Management Service</a>.</p>', 'LogGroup$kmsKeyId' => '<p>The Amazon Resource Name (ARN) of the CMK to use when encrypting log data.</p>', ], ], 'LimitExceededException' => [ 'base' => '<p>You have reached the maximum number of resources that can be created.</p>', 'refs' => [], ], 'ListTagsLogGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsLogGroupResponse' => [ 'base' => NULL, 'refs' => [], ], 'LogEventIndex' => [ 'base' => NULL, 'refs' => [ 'RejectedLogEventsInfo$tooNewLogEventStartIndex' => '<p>The log events that are too new.</p>', 'RejectedLogEventsInfo$tooOldLogEventEndIndex' => '<p>The log events that are too old.</p>', 'RejectedLogEventsInfo$expiredLogEventEndIndex' => '<p>The expired log events.</p>', ], ], 'LogGroup' => [ 'base' => '<p>Represents a log group.</p>', 'refs' => [ 'LogGroups$member' => NULL, ], ], 'LogGroupField' => [ 'base' => '<p>The fields contained in log events found by a <code>GetLogGroupFields</code> operation, along with the percentage of queried log events in which each field appears.</p>', 'refs' => [ 'LogGroupFieldList$member' => NULL, ], ], 'LogGroupFieldList' => [ 'base' => NULL, 'refs' => [ 'GetLogGroupFieldsResponse$logGroupFields' => '<p>The array of fields found in the query. Each object in the array contains the name of the field, along with the percentage of time it appeared in the log events that were queried.</p>', ], ], 'LogGroupName' => [ 'base' => NULL, 'refs' => [ 'AssociateKmsKeyRequest$logGroupName' => '<p>The name of the log group.</p>', 'CreateExportTaskRequest$logGroupName' => '<p>The name of the log group.</p>', 'CreateLogGroupRequest$logGroupName' => '<p>The name of the log group.</p>', 'CreateLogStreamRequest$logGroupName' => '<p>The name of the log group.</p>', 'DeleteLogGroupRequest$logGroupName' => '<p>The name of the log group.</p>', 'DeleteLogStreamRequest$logGroupName' => '<p>The name of the log group.</p>', 'DeleteMetricFilterRequest$logGroupName' => '<p>The name of the log group.</p>', 'DeleteRetentionPolicyRequest$logGroupName' => '<p>The name of the log group.</p>', 'DeleteSubscriptionFilterRequest$logGroupName' => '<p>The name of the log group.</p>', 'DescribeLogGroupsRequest$logGroupNamePrefix' => '<p>The prefix to match.</p>', 'DescribeLogStreamsRequest$logGroupName' => '<p>The name of the log group.</p>', 'DescribeMetricFiltersRequest$logGroupName' => '<p>The name of the log group.</p>', 'DescribeQueriesRequest$logGroupName' => '<p>Limits the returned queries to only those for the specified log group.</p>', 'DescribeSubscriptionFiltersRequest$logGroupName' => '<p>The name of the log group.</p>', 'DisassociateKmsKeyRequest$logGroupName' => '<p>The name of the log group.</p>', 'ExportTask$logGroupName' => '<p>The name of the log group from which logs data was exported.</p>', 'FilterLogEventsRequest$logGroupName' => '<p>The name of the log group to search.</p>', 'GetLogEventsRequest$logGroupName' => '<p>The name of the log group.</p>', 'GetLogGroupFieldsRequest$logGroupName' => '<p>The name of the log group to search.</p>', 'ListTagsLogGroupRequest$logGroupName' => '<p>The name of the log group.</p>', 'LogGroup$logGroupName' => '<p>The name of the log group.</p>', 'LogGroupNames$member' => NULL, 'MetricFilter$logGroupName' => '<p>The name of the log group.</p>', 'PutLogEventsRequest$logGroupName' => '<p>The name of the log group.</p>', 'PutMetricFilterRequest$logGroupName' => '<p>The name of the log group.</p>', 'PutRetentionPolicyRequest$logGroupName' => '<p>The name of the log group.</p>', 'PutSubscriptionFilterRequest$logGroupName' => '<p>The name of the log group.</p>', 'QueryInfo$logGroupName' => '<p>The name of the log group scanned by this query.</p>', 'StartQueryRequest$logGroupName' => '<p>The log group on which to perform the query.</p> <p>A <code>StartQuery</code> operation must include a <code>logGroupNames</code> or a <code>logGroupName</code> parameter, but not both.</p>', 'SubscriptionFilter$logGroupName' => '<p>The name of the log group.</p>', 'TagLogGroupRequest$logGroupName' => '<p>The name of the log group.</p>', 'UntagLogGroupRequest$logGroupName' => '<p>The name of the log group.</p>', ], ], 'LogGroupNames' => [ 'base' => NULL, 'refs' => [ 'PutQueryDefinitionRequest$logGroupNames' => '<p>Use this parameter to include specific log groups as part of your query definition.</p> <p>If you are updating a query definition and you omit this parameter, then the updated definition will contain no log groups.</p>', 'QueryDefinition$logGroupNames' => '<p>If this query definition contains a list of log groups that it is limited to, that list appears here.</p>', 'StartQueryRequest$logGroupNames' => '<p>The list of log groups to be queried. You can include up to 20 log groups.</p> <p>A <code>StartQuery</code> operation must include a <code>logGroupNames</code> or a <code>logGroupName</code> parameter, but not both.</p>', ], ], 'LogGroups' => [ 'base' => NULL, 'refs' => [ 'DescribeLogGroupsResponse$logGroups' => '<p>The log groups.</p> <p>If the <code>retentionInDays</code> value if not included for a log group, then that log group is set to have its events never expire.</p>', ], ], 'LogRecord' => [ 'base' => NULL, 'refs' => [ 'GetLogRecordResponse$logRecord' => '<p>The requested log event, as a JSON string.</p>', ], ], 'LogRecordPointer' => [ 'base' => NULL, 'refs' => [ 'GetLogRecordRequest$logRecordPointer' => '<p>The pointer corresponding to the log event record you want to retrieve. You get this from the response of a <code>GetQueryResults</code> operation. In that response, the value of the <code>@ptr</code> field for a log event is the value to use as <code>logRecordPointer</code> to retrieve that complete log event record.</p>', ], ], 'LogStream' => [ 'base' => '<p>Represents a log stream, which is a sequence of log events from a single emitter of logs.</p>', 'refs' => [ 'LogStreams$member' => NULL, ], ], 'LogStreamName' => [ 'base' => NULL, 'refs' => [ 'CreateExportTaskRequest$logStreamNamePrefix' => '<p>Export only log streams that match the provided prefix. If you don\'t specify a value, no prefix filter is applied.</p>', 'CreateLogStreamRequest$logStreamName' => '<p>The name of the log stream.</p>', 'DeleteLogStreamRequest$logStreamName' => '<p>The name of the log stream.</p>', 'DescribeLogStreamsRequest$logStreamNamePrefix' => '<p>The prefix to match.</p> <p>If <code>orderBy</code> is <code>LastEventTime</code>, you cannot specify this parameter.</p>', 'FilterLogEventsRequest$logStreamNamePrefix' => '<p>Filters the results to include only events from log streams that have names starting with this prefix.</p> <p>If you specify a value for both <code>logStreamNamePrefix</code> and <code>logStreamNames</code>, but the value for <code>logStreamNamePrefix</code> does not match any log stream names specified in <code>logStreamNames</code>, the action returns an <code>InvalidParameterException</code> error.</p>', 'FilteredLogEvent$logStreamName' => '<p>The name of the log stream to which this event belongs.</p>', 'GetLogEventsRequest$logStreamName' => '<p>The name of the log stream.</p>', 'InputLogStreamNames$member' => NULL, 'LogStream$logStreamName' => '<p>The name of the log stream.</p>', 'PutLogEventsRequest$logStreamName' => '<p>The name of the log stream.</p>', 'SearchedLogStream$logStreamName' => '<p>The name of the log stream.</p>', ], ], 'LogStreamSearchedCompletely' => [ 'base' => NULL, 'refs' => [ 'SearchedLogStream$searchedCompletely' => '<p>Indicates whether all the events in this log stream were searched.</p>', ], ], 'LogStreams' => [ 'base' => NULL, 'refs' => [ 'DescribeLogStreamsResponse$logStreams' => '<p>The log streams.</p>', ], ], 'MalformedQueryException' => [ 'base' => '<p>The query string is not valid. Details about this error are displayed in a <code>QueryCompileError</code> object. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_QueryCompileError.html">QueryCompileError</a>.</p> <p>For more information about valid query syntax, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CWL_QuerySyntax.html">CloudWatch Logs Insights Query Syntax</a>.</p>', 'refs' => [], ], 'Message' => [ 'base' => NULL, 'refs' => [ 'QueryCompileError$message' => '<p>Reserved.</p>', ], ], 'MetricFilter' => [ 'base' => '<p>Metric filters express how CloudWatch Logs would extract metric observations from ingested log events and transform them into metric data in a CloudWatch metric.</p>', 'refs' => [ 'MetricFilters$member' => NULL, ], ], 'MetricFilterMatchRecord' => [ 'base' => '<p>Represents a matched event.</p>', 'refs' => [ 'MetricFilterMatches$member' => NULL, ], ], 'MetricFilterMatches' => [ 'base' => NULL, 'refs' => [ 'TestMetricFilterResponse$matches' => '<p>The matched events.</p>', ], ], 'MetricFilters' => [ 'base' => NULL, 'refs' => [ 'DescribeMetricFiltersResponse$metricFilters' => '<p>The metric filters.</p>', ], ], 'MetricName' => [ 'base' => '<p>The name of the CloudWatch metric to which the monitored log information should be published. For example, you might publish to a metric named ErrorCount.</p>', 'refs' => [ 'DescribeMetricFiltersRequest$metricName' => '<p>Filters results to include only those with the specified metric name. If you include this parameter in your request, you must also include the <code>metricNamespace</code> parameter.</p>', 'MetricTransformation$metricName' => '<p>The name of the CloudWatch metric.</p>', ], ], 'MetricNamespace' => [ 'base' => NULL, 'refs' => [ 'DescribeMetricFiltersRequest$metricNamespace' => '<p>Filters results to include only those in the specified namespace. If you include this parameter in your request, you must also include the <code>metricName</code> parameter.</p>', 'MetricTransformation$metricNamespace' => '<p>A custom namespace to contain your metric in CloudWatch. Use namespaces to group together metrics that are similar. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/cloudwatch_concepts.html#Namespace">Namespaces</a>.</p>', ], ], 'MetricTransformation' => [ 'base' => '<p>Indicates how to transform ingested log events to metric data in a CloudWatch metric.</p>', 'refs' => [ 'MetricTransformations$member' => NULL, ], ], 'MetricTransformations' => [ 'base' => NULL, 'refs' => [ 'MetricFilter$metricTransformations' => '<p>The metric transformations.</p>', 'PutMetricFilterRequest$metricTransformations' => '<p>A collection of information that defines how metric data gets emitted.</p>', ], ], 'MetricValue' => [ 'base' => '<p>The value to publish to the CloudWatch metric. For example, if you\'re counting the occurrences of a term like "Error", the value is "1" for each occurrence. If you\'re counting the bytes transferred, the value is the value in the log event.</p>', 'refs' => [ 'MetricTransformation$metricValue' => '<p>The value to publish to the CloudWatch metric when a filter pattern matches a log event.</p>', ], ], 'NextToken' => [ 'base' => '<p>The token for the next set of items to return. The token expires after 24 hours.</p>', 'refs' => [ 'DescribeDestinationsRequest$nextToken' => '<p>The token for the next set of items to return. (You received this token from a previous call.)</p>', 'DescribeDestinationsResponse$nextToken' => NULL, 'DescribeExportTasksRequest$nextToken' => '<p>The token for the next set of items to return. (You received this token from a previous call.)</p>', 'DescribeExportTasksResponse$nextToken' => NULL, 'DescribeLogGroupsRequest$nextToken' => '<p>The token for the next set of items to return. (You received this token from a previous call.)</p>', 'DescribeLogGroupsResponse$nextToken' => NULL, 'DescribeLogStreamsRequest$nextToken' => '<p>The token for the next set of items to return. (You received this token from a previous call.)</p>', 'DescribeLogStreamsResponse$nextToken' => NULL, 'DescribeMetricFiltersRequest$nextToken' => '<p>The token for the next set of items to return. (You received this token from a previous call.)</p>', 'DescribeMetricFiltersResponse$nextToken' => NULL, 'DescribeQueriesRequest$nextToken' => NULL, 'DescribeQueriesResponse$nextToken' => NULL, 'DescribeQueryDefinitionsRequest$nextToken' => NULL, 'DescribeQueryDefinitionsResponse$nextToken' => NULL, 'DescribeResourcePoliciesRequest$nextToken' => NULL, 'DescribeResourcePoliciesResponse$nextToken' => NULL, 'DescribeSubscriptionFiltersRequest$nextToken' => '<p>The token for the next set of items to return. (You received this token from a previous call.)</p>', 'DescribeSubscriptionFiltersResponse$nextToken' => NULL, 'FilterLogEventsRequest$nextToken' => '<p>The token for the next set of events to return. (You received this token from a previous call.)</p>', 'FilterLogEventsResponse$nextToken' => '<p>The token to use when requesting the next set of items. The token expires after 24 hours.</p>', 'GetLogEventsRequest$nextToken' => '<p>The token for the next set of items to return. (You received this token from a previous call.)</p>', 'GetLogEventsResponse$nextForwardToken' => '<p>The token for the next set of items in the forward direction. The token expires after 24 hours. If you have reached the end of the stream, it returns the same token you passed in.</p>', 'GetLogEventsResponse$nextBackwardToken' => '<p>The token for the next set of items in the backward direction. The token expires after 24 hours. This token is never null. If you have reached the end of the stream, it returns the same token you passed in.</p>', ], ], 'OperationAbortedException' => [ 'base' => '<p>Multiple requests to update the same resource were in conflict.</p>', 'refs' => [], ], 'OrderBy' => [ 'base' => NULL, 'refs' => [ 'DescribeLogStreamsRequest$orderBy' => '<p>If the value is <code>LogStreamName</code>, the results are ordered by log stream name. If the value is <code>LastEventTime</code>, the results are ordered by the event time. The default value is <code>LogStreamName</code>.</p> <p>If you order the results by event time, you cannot specify the <code>logStreamNamePrefix</code> parameter.</p> <p> <code>lastEventTimestamp</code> represents the time of the most recent log event in the log stream in CloudWatch Logs. This number is expressed as the number of milliseconds after Jan 1, 1970 00:00:00 UTC. <code>lastEventTimestamp</code> updates on an eventual consistency basis. It typically updates in less than an hour from ingestion, but in rare situations might take longer.</p>', ], ], 'OutputLogEvent' => [ 'base' => '<p>Represents a log event.</p>', 'refs' => [ 'OutputLogEvents$member' => NULL, ], ], 'OutputLogEvents' => [ 'base' => NULL, 'refs' => [ 'GetLogEventsResponse$events' => '<p>The events.</p>', ], ], 'Percentage' => [ 'base' => NULL, 'refs' => [ 'LogGroupField$percent' => '<p>The percentage of log events queried that contained the field.</p>', ], ], 'PolicyDocument' => [ 'base' => NULL, 'refs' => [ 'PutResourcePolicyRequest$policyDocument' => '<p>Details of the new policy, including the identity of the principal that is enabled to put logs to this account. This is formatted as a JSON string. This parameter is required.</p> <p>The following example creates a resource policy enabling the Route 53 service to put DNS query logs in to the specified log group. Replace <code>"logArn"</code> with the ARN of your CloudWatch Logs resource, such as a log group or log stream.</p> <p>CloudWatch Logs also supports <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-sourcearn">aws:SourceArn</a> and <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-sourceaccount">aws:SourceAccount</a> condition context keys.</p> <p>In the example resource policy, you would replace the value of <code>SourceArn</code> with the resource making the call from Route 53 to CloudWatch Logs and replace the value of <code>SourceAccount</code> with the Amazon Web Services account ID making that call.</p> <p/> <p> <code>{ "Version": "2012-10-17", "Statement": [ { "Sid": "Route53LogsToCloudWatchLogs", "Effect": "Allow", "Principal": { "Service": [ "route53.amazonaws.com" ] }, "Action": "logs:PutLogEvents", "Resource": "logArn", "Condition": { "ArnLike": { "aws:SourceArn": "myRoute53ResourceArn" }, "StringEquals": { "aws:SourceAccount": "myAwsAccountId" } } } ] }</code> </p>', 'ResourcePolicy$policyDocument' => '<p>The details of the policy.</p>', ], ], 'PolicyName' => [ 'base' => NULL, 'refs' => [ 'DeleteResourcePolicyRequest$policyName' => '<p>The name of the policy to be revoked. This parameter is required.</p>', 'PutResourcePolicyRequest$policyName' => '<p>Name of the new policy. This parameter is required.</p>', 'ResourcePolicy$policyName' => '<p>The name of the resource policy.</p>', ], ], 'PutDestinationPolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutDestinationRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutDestinationResponse' => [ 'base' => NULL, 'refs' => [], ], 'PutLogEventsRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutLogEventsResponse' => [ 'base' => NULL, 'refs' => [], ], 'PutMetricFilterRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutQueryDefinitionRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutQueryDefinitionResponse' => [ 'base' => NULL, 'refs' => [], ], 'PutResourcePolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutResourcePolicyResponse' => [ 'base' => NULL, 'refs' => [], ], 'PutRetentionPolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutSubscriptionFilterRequest' => [ 'base' => NULL, 'refs' => [], ], 'QueryCharOffset' => [ 'base' => NULL, 'refs' => [ 'QueryCompileErrorLocation$startCharOffset' => '<p>Reserved.</p>', 'QueryCompileErrorLocation$endCharOffset' => '<p>Reserved.</p>', ], ], 'QueryCompileError' => [ 'base' => '<p>Reserved.</p>', 'refs' => [ 'MalformedQueryException$queryCompileError' => NULL, ], ], 'QueryCompileErrorLocation' => [ 'base' => '<p>Reserved.</p>', 'refs' => [ 'QueryCompileError$location' => '<p>Reserved.</p>', ], ], 'QueryDefinition' => [ 'base' => '<p>This structure contains details about a saved CloudWatch Logs Insights query definition.</p>', 'refs' => [ 'QueryDefinitionList$member' => NULL, ], ], 'QueryDefinitionList' => [ 'base' => NULL, 'refs' => [ 'DescribeQueryDefinitionsResponse$queryDefinitions' => '<p>The list of query definitions that match your request.</p>', ], ], 'QueryDefinitionName' => [ 'base' => NULL, 'refs' => [ 'DescribeQueryDefinitionsRequest$queryDefinitionNamePrefix' => '<p>Use this parameter to filter your results to only the query definitions that have names that start with the prefix you specify.</p>', 'PutQueryDefinitionRequest$name' => '<p>A name for the query definition. If you are saving a lot of query definitions, we recommend that you name them so that you can easily find the ones you want by using the first part of the name as a filter in the <code>queryDefinitionNamePrefix</code> parameter of <a href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_DescribeQueryDefinitions.html">DescribeQueryDefinitions</a>.</p>', 'QueryDefinition$name' => '<p>The name of the query definition.</p>', ], ], 'QueryDefinitionString' => [ 'base' => NULL, 'refs' => [ 'PutQueryDefinitionRequest$queryString' => '<p>The query string to use for this definition. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CWL_QuerySyntax.html">CloudWatch Logs Insights Query Syntax</a>.</p>', 'QueryDefinition$queryString' => '<p>The query string to use for this definition. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CWL_QuerySyntax.html">CloudWatch Logs Insights Query Syntax</a>.</p>', ], ], 'QueryId' => [ 'base' => NULL, 'refs' => [ 'DeleteQueryDefinitionRequest$queryDefinitionId' => '<p>The ID of the query definition that you want to delete. You can use <a href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_DescribeQueryDefinitions.html">DescribeQueryDefinitions</a> to retrieve the IDs of your saved query definitions.</p>', 'GetQueryResultsRequest$queryId' => '<p>The ID number of the query.</p>', 'PutQueryDefinitionRequest$queryDefinitionId' => '<p>If you are updating a query definition, use this parameter to specify the ID of the query definition that you want to update. You can use <a href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_DescribeQueryDefinitions.html">DescribeQueryDefinitions</a> to retrieve the IDs of your saved query definitions.</p> <p>If you are creating a query definition, do not specify this parameter. CloudWatch generates a unique ID for the new query definition and include it in the response to this operation.</p>', 'PutQueryDefinitionResponse$queryDefinitionId' => '<p>The ID of the query definition.</p>', 'QueryDefinition$queryDefinitionId' => '<p>The unique ID of the query definition.</p>', 'QueryInfo$queryId' => '<p>The unique ID number of this query.</p>', 'StartQueryResponse$queryId' => '<p>The unique ID of the query. </p>', 'StopQueryRequest$queryId' => '<p>The ID number of the query to stop. To find this ID number, use <code>DescribeQueries</code>.</p>', ], ], 'QueryInfo' => [ 'base' => '<p>Information about one CloudWatch Logs Insights query that matches the request in a <code>DescribeQueries</code> operation. </p>', 'refs' => [ 'QueryInfoList$member' => NULL, ], ], 'QueryInfoList' => [ 'base' => NULL, 'refs' => [ 'DescribeQueriesResponse$queries' => '<p>The list of queries that match the request.</p>', ], ], 'QueryListMaxResults' => [ 'base' => NULL, 'refs' => [ 'DescribeQueryDefinitionsRequest$maxResults' => '<p>Limits the number of returned query definitions to the specified number.</p>', ], ], 'QueryResults' => [ 'base' => NULL, 'refs' => [ 'GetQueryResultsResponse$results' => '<p>The log events that matched the query criteria during the most recent time it ran.</p> <p>The <code>results</code> value is an array of arrays. Each log event is one object in the top-level array. Each of these log event objects is an array of <code>field</code>/<code>value</code> pairs.</p>', ], ], 'QueryStatistics' => [ 'base' => '<p>Contains the number of log events scanned by the query, the number of log events that matched the query criteria, and the total number of bytes in the log events that were scanned.</p>', 'refs' => [ 'GetQueryResultsResponse$statistics' => '<p>Includes the number of log events scanned by the query, the number of log events that matched the query criteria, and the total number of bytes in the log events that were scanned. These values reflect the full raw results of the query.</p>', ], ], 'QueryStatus' => [ 'base' => NULL, 'refs' => [ 'DescribeQueriesRequest$status' => '<p>Limits the returned queries to only those that have the specified status. Valid values are <code>Cancelled</code>, <code>Complete</code>, <code>Failed</code>, <code>Running</code>, and <code>Scheduled</code>.</p>', 'GetQueryResultsResponse$status' => '<p>The status of the most recent running of the query. Possible values are <code>Cancelled</code>, <code>Complete</code>, <code>Failed</code>, <code>Running</code>, <code>Scheduled</code>, <code>Timeout</code>, and <code>Unknown</code>.</p> <p>Queries time out after 15 minutes of execution. To avoid having your queries time out, reduce the time range being searched or partition your query into a number of queries.</p>', 'QueryInfo$status' => '<p>The status of this query. Possible values are <code>Cancelled</code>, <code>Complete</code>, <code>Failed</code>, <code>Running</code>, <code>Scheduled</code>, and <code>Unknown</code>.</p>', ], ], 'QueryString' => [ 'base' => NULL, 'refs' => [ 'QueryInfo$queryString' => '<p>The query string used in this query.</p>', 'StartQueryRequest$queryString' => '<p>The query string to use. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CWL_QuerySyntax.html">CloudWatch Logs Insights Query Syntax</a>.</p>', ], ], 'RejectedLogEventsInfo' => [ 'base' => '<p>Represents the rejected events.</p>', 'refs' => [ 'PutLogEventsResponse$rejectedLogEventsInfo' => '<p>The rejected events.</p>', ], ], 'ResourceAlreadyExistsException' => [ 'base' => '<p>The specified resource already exists.</p>', 'refs' => [], ], 'ResourceNotFoundException' => [ 'base' => '<p>The specified resource does not exist.</p>', 'refs' => [], ], 'ResourcePolicies' => [ 'base' => NULL, 'refs' => [ 'DescribeResourcePoliciesResponse$resourcePolicies' => '<p>The resource policies that exist in this account.</p>', ], ], 'ResourcePolicy' => [ 'base' => '<p>A policy enabling one or more entities to put logs to a log group in this account.</p>', 'refs' => [ 'PutResourcePolicyResponse$resourcePolicy' => '<p>The new policy.</p>', 'ResourcePolicies$member' => NULL, ], ], 'ResultField' => [ 'base' => '<p>Contains one field from one log event returned by a CloudWatch Logs Insights query, along with the value of that field.</p> <p>For more information about the fields that are generated by CloudWatch logs, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CWL_AnalyzeLogData-discoverable-fields.html">Supported Logs and Discovered Fields</a>.</p>', 'refs' => [ 'ResultRows$member' => NULL, ], ], 'ResultRows' => [ 'base' => NULL, 'refs' => [ 'QueryResults$member' => NULL, ], ], 'RoleArn' => [ 'base' => NULL, 'refs' => [ 'Destination$roleArn' => '<p>A role for impersonation, used when delivering log events to the target.</p>', 'PutDestinationRequest$roleArn' => '<p>The ARN of an IAM role that grants CloudWatch Logs permissions to call the Amazon Kinesis <code>PutRecord</code> operation on the destination stream.</p>', 'PutSubscriptionFilterRequest$roleArn' => '<p>The ARN of an IAM role that grants CloudWatch Logs permissions to deliver ingested log events to the destination stream. You don\'t need to provide the ARN when you are working with a logical destination for cross-account delivery.</p>', 'SubscriptionFilter$roleArn' => '<p/>', ], ], 'SearchedLogStream' => [ 'base' => '<p>Represents the search status of a log stream.</p>', 'refs' => [ 'SearchedLogStreams$member' => NULL, ], ], 'SearchedLogStreams' => [ 'base' => NULL, 'refs' => [ 'FilterLogEventsResponse$searchedLogStreams' => '<p> <b>IMPORTANT</b> Starting on May 15, 2020, this parameter will be deprecated. This parameter will be an empty list after the deprecation occurs.</p> <p>Indicates which log streams have been searched and whether each has been searched completely.</p>', ], ], 'SequenceToken' => [ 'base' => NULL, 'refs' => [ 'DataAlreadyAcceptedException$expectedSequenceToken' => NULL, 'InvalidSequenceTokenException$expectedSequenceToken' => NULL, 'LogStream$uploadSequenceToken' => '<p>The sequence token.</p>', 'PutLogEventsRequest$sequenceToken' => '<p>The sequence token obtained from the response of the previous <code>PutLogEvents</code> call. An upload in a newly created log stream does not require a sequence token. You can also get the sequence token using <a href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_DescribeLogStreams.html">DescribeLogStreams</a>. If you call <code>PutLogEvents</code> twice within a narrow time period using the same value for <code>sequenceToken</code>, both calls might be successful or one might be rejected.</p>', 'PutLogEventsResponse$nextSequenceToken' => '<p>The next sequence token.</p>', ], ], 'ServiceUnavailableException' => [ 'base' => '<p>The service cannot complete the request.</p>', 'refs' => [], ], 'StandardUnit' => [ 'base' => NULL, 'refs' => [ 'MetricTransformation$unit' => '<p>The unit to assign to the metric. If you omit this, the unit is set as <code>None</code>.</p>', ], ], 'StartFromHead' => [ 'base' => NULL, 'refs' => [ 'GetLogEventsRequest$startFromHead' => '<p>If the value is true, the earliest log events are returned first. If the value is false, the latest log events are returned first. The default value is false.</p> <p>If you are using a previous <code>nextForwardToken</code> value as the <code>nextToken</code> in this operation, you must specify <code>true</code> for <code>startFromHead</code>.</p>', ], ], 'StartQueryRequest' => [ 'base' => NULL, 'refs' => [], ], 'StartQueryResponse' => [ 'base' => NULL, 'refs' => [], ], 'StatsValue' => [ 'base' => NULL, 'refs' => [ 'QueryStatistics$recordsMatched' => '<p>The number of log events that matched the query string.</p>', 'QueryStatistics$recordsScanned' => '<p>The total number of log events scanned during the query.</p>', 'QueryStatistics$bytesScanned' => '<p>The total number of bytes in the log events scanned during the query.</p>', ], ], 'StopQueryRequest' => [ 'base' => NULL, 'refs' => [], ], 'StopQueryResponse' => [ 'base' => NULL, 'refs' => [], ], 'StoredBytes' => [ 'base' => NULL, 'refs' => [ 'LogGroup$storedBytes' => '<p>The number of bytes stored.</p>', 'LogStream$storedBytes' => '<p>The number of bytes stored.</p> <p> <b>Important:</b> On June 17, 2019, this parameter was deprecated for log streams, and is always reported as zero. This change applies only to log streams. The <code>storedBytes</code> parameter for log groups is not affected.</p>', ], ], 'SubscriptionFilter' => [ 'base' => '<p>Represents a subscription filter.</p>', 'refs' => [ 'SubscriptionFilters$member' => NULL, ], ], 'SubscriptionFilters' => [ 'base' => NULL, 'refs' => [ 'DescribeSubscriptionFiltersResponse$subscriptionFilters' => '<p>The subscription filters.</p>', ], ], 'Success' => [ 'base' => NULL, 'refs' => [ 'DeleteQueryDefinitionResponse$success' => '<p>A value of TRUE indicates that the operation succeeded. FALSE indicates that the operation failed.</p>', 'StopQueryResponse$success' => '<p>This is true if the query was stopped by the <code>StopQuery</code> operation.</p>', ], ], 'TagKey' => [ 'base' => NULL, 'refs' => [ 'TagList$member' => NULL, 'Tags$key' => NULL, ], ], 'TagList' => [ 'base' => NULL, 'refs' => [ 'UntagLogGroupRequest$tags' => '<p>The tag keys. The corresponding tags are removed from the log group.</p>', ], ], 'TagLogGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'TagValue' => [ 'base' => NULL, 'refs' => [ 'Tags$value' => NULL, ], ], 'Tags' => [ 'base' => NULL, 'refs' => [ 'CreateLogGroupRequest$tags' => '<p>The key-value pairs to use for the tags.</p> <p>CloudWatch Logs doesn’t support IAM policies that prevent users from assigning specified tags to log groups using the <code>aws:Resource/<i>key-name</i> </code> or <code>aws:TagKeys</code> condition keys. For more information about using tags to control access, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_tags.html">Controlling access to Amazon Web Services resources using tags</a>.</p>', 'ListTagsLogGroupResponse$tags' => '<p>The tags for the log group.</p>', 'TagLogGroupRequest$tags' => '<p>The key-value pairs to use for the tags.</p>', ], ], 'TargetArn' => [ 'base' => NULL, 'refs' => [ 'Destination$targetArn' => '<p>The Amazon Resource Name (ARN) of the physical target where the log events are delivered (for example, a Kinesis stream).</p>', 'PutDestinationRequest$targetArn' => '<p>The ARN of an Amazon Kinesis stream to which to deliver matching log events.</p>', ], ], 'TestEventMessages' => [ 'base' => NULL, 'refs' => [ 'TestMetricFilterRequest$logEventMessages' => '<p>The log event messages to test.</p>', ], ], 'TestMetricFilterRequest' => [ 'base' => NULL, 'refs' => [], ], 'TestMetricFilterResponse' => [ 'base' => NULL, 'refs' => [], ], 'Timestamp' => [ 'base' => NULL, 'refs' => [ 'CreateExportTaskRequest$from' => '<p>The start time of the range for the request, expressed as the number of milliseconds after Jan 1, 1970 00:00:00 UTC. Events with a timestamp earlier than this time are not exported.</p>', 'CreateExportTaskRequest$to' => '<p>The end time of the range for the request, expreswatchlogsdocused as the number of milliseconds after Jan 1, 1970 00:00:00 UTC. Events with a timestamp later than this time are not exported.</p>', 'Destination$creationTime' => '<p>The creation time of the destination, expressed as the number of milliseconds after Jan 1, 1970 00:00:00 UTC.</p>', 'ExportTask$from' => '<p>The start time, expressed as the number of milliseconds after Jan 1, 1970 00:00:00 UTC. Events with a timestamp before this time are not exported.</p>', 'ExportTask$to' => '<p>The end time, expressed as the number of milliseconds after Jan 1, 1970 00:00:00 UTC. Events with a timestamp later than this time are not exported.</p>', 'ExportTaskExecutionInfo$creationTime' => '<p>The creation time of the export task, expressed as the number of milliseconds after Jan 1, 1970 00:00:00 UTC.</p>', 'ExportTaskExecutionInfo$completionTime' => '<p>The completion time of the export task, expressed as the number of milliseconds after Jan 1, 1970 00:00:00 UTC.</p>', 'FilterLogEventsRequest$startTime' => '<p>The start of the time range, expressed as the number of milliseconds after Jan 1, 1970 00:00:00 UTC. Events with a timestamp before this time are not returned.</p>', 'FilterLogEventsRequest$endTime' => '<p>The end of the time range, expressed as the number of milliseconds after Jan 1, 1970 00:00:00 UTC. Events with a timestamp later than this time are not returned.</p>', 'FilteredLogEvent$timestamp' => '<p>The time the event occurred, expressed as the number of milliseconds after Jan 1, 1970 00:00:00 UTC.</p>', 'FilteredLogEvent$ingestionTime' => '<p>The time the event was ingested, expressed as the number of milliseconds after Jan 1, 1970 00:00:00 UTC.</p>', 'GetLogEventsRequest$startTime' => '<p>The start of the time range, expressed as the number of milliseconds after Jan 1, 1970 00:00:00 UTC. Events with a timestamp equal to this time or later than this time are included. Events with a timestamp earlier than this time are not included.</p>', 'GetLogEventsRequest$endTime' => '<p>The end of the time range, expressed as the number of milliseconds after Jan 1, 1970 00:00:00 UTC. Events with a timestamp equal to or later than this time are not included.</p>', 'GetLogGroupFieldsRequest$time' => '<p>The time to set as the center of the query. If you specify <code>time</code>, the 15 minutes before this time are queries. If you omit <code>time</code> the 8 minutes before and 8 minutes after this time are searched.</p> <p>The <code>time</code> value is specified as epoch time, the number of seconds since January 1, 1970, 00:00:00 UTC.</p>', 'InputLogEvent$timestamp' => '<p>The time the event occurred, expressed as the number of milliseconds after Jan 1, 1970 00:00:00 UTC.</p>', 'LogGroup$creationTime' => '<p>The creation time of the log group, expressed as the number of milliseconds after Jan 1, 1970 00:00:00 UTC.</p>', 'LogStream$creationTime' => '<p>The creation time of the stream, expressed as the number of milliseconds after Jan 1, 1970 00:00:00 UTC.</p>', 'LogStream$firstEventTimestamp' => '<p>The time of the first event, expressed as the number of milliseconds after Jan 1, 1970 00:00:00 UTC.</p>', 'LogStream$lastEventTimestamp' => '<p>The time of the most recent log event in the log stream in CloudWatch Logs. This number is expressed as the number of milliseconds after Jan 1, 1970 00:00:00 UTC. The <code>lastEventTime</code> value updates on an eventual consistency basis. It typically updates in less than an hour from ingestion, but in rare situations might take longer.</p>', 'LogStream$lastIngestionTime' => '<p>The ingestion time, expressed as the number of milliseconds after Jan 1, 1970 00:00:00 UTC.</p>', 'MetricFilter$creationTime' => '<p>The creation time of the metric filter, expressed as the number of milliseconds after Jan 1, 1970 00:00:00 UTC.</p>', 'OutputLogEvent$timestamp' => '<p>The time the event occurred, expressed as the number of milliseconds after Jan 1, 1970 00:00:00 UTC.</p>', 'OutputLogEvent$ingestionTime' => '<p>The time the event was ingested, expressed as the number of milliseconds after Jan 1, 1970 00:00:00 UTC.</p>', 'QueryDefinition$lastModified' => '<p>The date that the query definition was most recently modified.</p>', 'QueryInfo$createTime' => '<p>The date and time that this query was created.</p>', 'ResourcePolicy$lastUpdatedTime' => '<p>Timestamp showing when this policy was last updated, expressed as the number of milliseconds after Jan 1, 1970 00:00:00 UTC.</p>', 'StartQueryRequest$startTime' => '<p>The beginning of the time range to query. The range is inclusive, so the specified start time is included in the query. Specified as epoch time, the number of seconds since January 1, 1970, 00:00:00 UTC.</p>', 'StartQueryRequest$endTime' => '<p>The end of the time range to query. The range is inclusive, so the specified end time is included in the query. Specified as epoch time, the number of seconds since January 1, 1970, 00:00:00 UTC.</p>', 'SubscriptionFilter$creationTime' => '<p>The creation time of the subscription filter, expressed as the number of milliseconds after Jan 1, 1970 00:00:00 UTC.</p>', ], ], 'Token' => [ 'base' => NULL, 'refs' => [ 'ExtractedValues$key' => NULL, ], ], 'UnrecognizedClientException' => [ 'base' => '<p>The most likely cause is an invalid Amazon Web Services access key ID or secret key.</p>', 'refs' => [], ], 'UntagLogGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'Value' => [ 'base' => NULL, 'refs' => [ 'ExtractedValues$value' => NULL, 'LogRecord$value' => NULL, 'ResultField$value' => '<p>The value of this field.</p>', ], ], ],];
