<?php
// This file was auto-generated from sdk-root/src/data/lakeformation/2017-03-31/docs-2.json
return [ 'version' => '2.0', 'service' => '<fullname>AWS Lake Formation</fullname> <p>Defines the public endpoint for the AWS Lake Formation service.</p>', 'operations' => [ 'AddLFTagsToResource' => '<p>Attaches one or more tags to an existing resource.</p>', 'BatchGrantPermissions' => '<p>Batch operation to grant permissions to the principal.</p>', 'BatchRevokePermissions' => '<p>Batch operation to revoke permissions from the principal.</p>', 'CreateLFTag' => '<p>Creates a tag with the specified name and values.</p>', 'DeleteLFTag' => '<p>Deletes the specified tag key name. If the attribute key does not exist or the tag does not exist, then the operation will not do anything. If the attribute key exists, then the operation checks if any resources are tagged with this attribute key, if yes, the API throws a 400 Exception with the message "Delete not allowed" as the tag key is still attached with resources. You can consider untagging resources with this tag key.</p>', 'DeregisterResource' => '<p>Deregisters the resource as managed by the Data Catalog.</p> <p>When you deregister a path, Lake Formation removes the path from the inline policy attached to your service-linked role.</p>', 'DescribeResource' => '<p>Retrieves the current data access role for the given resource registered in AWS Lake Formation.</p>', 'GetDataLakeSettings' => '<p>Retrieves the list of the data lake administrators of a Lake Formation-managed data lake. </p>', 'GetEffectivePermissionsForPath' => '<p>Returns the Lake Formation permissions for a specified table or database resource located at a path in Amazon S3. <code>GetEffectivePermissionsForPath</code> will not return databases and tables if the catalog is encrypted.</p>', 'GetLFTag' => '<p>Returns a tag definition.</p>', 'GetResourceLFTags' => '<p>Returns the tags applied to a resource.</p>', 'GrantPermissions' => '<p>Grants permissions to the principal to access metadata in the Data Catalog and data organized in underlying data storage such as Amazon S3.</p> <p>For information about permissions, see <a href="https://docs-aws.amazon.com/lake-formation/latest/dg/security-data-access.html">Security and Access Control to Metadata and Data</a>.</p>', 'ListLFTags' => '<p>Lists tags that the requester has permission to view. </p>', 'ListPermissions' => '<p>Returns a list of the principal permissions on the resource, filtered by the permissions of the caller. For example, if you are granted an ALTER permission, you are able to see only the principal permissions for ALTER.</p> <p>This operation returns only those permissions that have been explicitly granted.</p> <p>For information about permissions, see <a href="https://docs-aws.amazon.com/lake-formation/latest/dg/security-data-access.html">Security and Access Control to Metadata and Data</a>.</p>', 'ListResources' => '<p>Lists the resources registered to be managed by the Data Catalog.</p>', 'PutDataLakeSettings' => '<p>Sets the list of data lake administrators who have admin privileges on all resources managed by Lake Formation. For more information on admin privileges, see <a href="https://docs.aws.amazon.com/lake-formation/latest/dg/lake-formation-permissions.html">Granting Lake Formation Permissions</a>.</p> <p>This API replaces the current list of data lake admins with the new list being passed. To add an admin, fetch the current list and add the new admin to that list and pass that list in this API.</p>', 'RegisterResource' => '<p>Registers the resource as managed by the Data Catalog.</p> <p>To add or update data, Lake Formation needs read/write access to the chosen Amazon S3 path. Choose a role that you know has permission to do this, or choose the AWSServiceRoleForLakeFormationDataAccess service-linked role. When you register the first Amazon S3 path, the service-linked role and a new inline policy are created on your behalf. Lake Formation adds the first path to the inline policy and attaches it to the service-linked role. When you register subsequent paths, Lake Formation adds the path to the existing policy.</p> <p>The following request registers a new location and gives AWS Lake Formation permission to use the service-linked role to access that location.</p> <p> <code>ResourceArn = arn:aws:s3:::my-bucket UseServiceLinkedRole = true</code> </p> <p>If <code>UseServiceLinkedRole</code> is not set to true, you must provide or set the <code>RoleArn</code>:</p> <p> <code>arn:aws:iam::12345:role/my-data-access-role</code> </p>', 'RemoveLFTagsFromResource' => '<p>Removes a tag from the resource. Only database, table, or tableWithColumns resource are allowed. To tag columns, use the column inclusion list in <code>tableWithColumns</code> to specify column input.</p>', 'RevokePermissions' => '<p>Revokes permissions to the principal to access metadata in the Data Catalog and data organized in underlying data storage such as Amazon S3.</p>', 'SearchDatabasesByLFTags' => '<p>This operation allows a search on <code>DATABASE</code> resources by <code>TagCondition</code>. This operation is used by admins who want to grant user permissions on certain <code>TagConditions</code>. Before making a grant, the admin can use <code>SearchDatabasesByTags</code> to find all resources where the given <code>TagConditions</code> are valid to verify whether the returned resources can be shared.</p>', 'SearchTablesByLFTags' => '<p>This operation allows a search on <code>TABLE</code> resources by <code>LFTag</code>s. This will be used by admins who want to grant user permissions on certain LFTags. Before making a grant, the admin can use <code>SearchTablesByLFTags</code> to find all resources where the given <code>LFTag</code>s are valid to verify whether the returned resources can be shared.</p>', 'UpdateLFTag' => '<p>Updates the list of possible values for the specified tag key. If the tag does not exist, the operation throws an EntityNotFoundException. The values in the delete key values will be deleted from list of possible values. If any value in the delete key values is attached to a resource, then API errors out with a 400 Exception - "Update not allowed". Untag the attribute before deleting the tag key\'s value. </p>', 'UpdateResource' => '<p>Updates the data access role used for vending access to the given (registered) resource in AWS Lake Formation. </p>', ], 'shapes' => [ 'AccessDeniedException' => [ 'base' => '<p>Access to a resource was denied.</p>', 'refs' => [], ], 'AddLFTagsToResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'AddLFTagsToResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'AlreadyExistsException' => [ 'base' => '<p>A resource to be created or added already exists.</p>', 'refs' => [], ], 'BatchGrantPermissionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'BatchGrantPermissionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'BatchPermissionsFailureEntry' => [ 'base' => '<p>A list of failures when performing a batch grant or batch revoke operation.</p>', 'refs' => [ 'BatchPermissionsFailureList$member' => NULL, ], ], 'BatchPermissionsFailureList' => [ 'base' => NULL, 'refs' => [ 'BatchGrantPermissionsResponse$Failures' => '<p>A list of failures to grant permissions to the resources.</p>', 'BatchRevokePermissionsResponse$Failures' => '<p>A list of failures to revoke permissions to the resources.</p>', ], ], 'BatchPermissionsRequestEntry' => [ 'base' => '<p>A permission to a resource granted by batch operation to the principal.</p>', 'refs' => [ 'BatchPermissionsFailureEntry$RequestEntry' => '<p>An identifier for an entry of the batch request.</p>', 'BatchPermissionsRequestEntryList$member' => NULL, ], ], 'BatchPermissionsRequestEntryList' => [ 'base' => NULL, 'refs' => [ 'BatchGrantPermissionsRequest$Entries' => '<p>A list of up to 20 entries for resource permissions to be granted by batch operation to the principal.</p>', 'BatchRevokePermissionsRequest$Entries' => '<p>A list of up to 20 entries for resource permissions to be revoked by batch operation to the principal.</p>', ], ], 'BatchRevokePermissionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'BatchRevokePermissionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'BooleanNullable' => [ 'base' => NULL, 'refs' => [ 'GetResourceLFTagsRequest$ShowAssignedLFTags' => '<p>Indicates whether to show the assigned tags.</p>', ], ], 'CatalogIdString' => [ 'base' => NULL, 'refs' => [ 'AddLFTagsToResourceRequest$CatalogId' => '<p>The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your AWS Lake Formation environment. </p>', 'BatchGrantPermissionsRequest$CatalogId' => '<p>The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your AWS Lake Formation environment. </p>', 'BatchRevokePermissionsRequest$CatalogId' => '<p>The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your AWS Lake Formation environment. </p>', 'CreateLFTagRequest$CatalogId' => '<p>The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your AWS Lake Formation environment. </p>', 'DataLocationResource$CatalogId' => '<p>The identifier for the Data Catalog where the location is registered with AWS Lake Formation. By default, it is the account ID of the caller.</p>', 'DatabaseResource$CatalogId' => '<p>The identifier for the Data Catalog. By default, it is the account ID of the caller.</p>', 'DeleteLFTagRequest$CatalogId' => '<p>The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your AWS Lake Formation environment. </p>', 'GetDataLakeSettingsRequest$CatalogId' => '<p>The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your AWS Lake Formation environment. </p>', 'GetEffectivePermissionsForPathRequest$CatalogId' => '<p>The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your AWS Lake Formation environment. </p>', 'GetLFTagRequest$CatalogId' => '<p>The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your AWS Lake Formation environment. </p>', 'GetLFTagResponse$CatalogId' => '<p>The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your AWS Lake Formation environment. </p>', 'GetResourceLFTagsRequest$CatalogId' => '<p>The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your AWS Lake Formation environment. </p>', 'GrantPermissionsRequest$CatalogId' => '<p>The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your AWS Lake Formation environment. </p>', 'LFTagKeyResource$CatalogId' => '<p>The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your AWS Lake Formation environment. </p>', 'LFTagPair$CatalogId' => '<p>The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your AWS Lake Formation environment. </p>', 'LFTagPolicyResource$CatalogId' => '<p>The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your AWS Lake Formation environment. </p>', 'ListLFTagsRequest$CatalogId' => '<p>The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your AWS Lake Formation environment. </p>', 'ListPermissionsRequest$CatalogId' => '<p>The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your AWS Lake Formation environment. </p>', 'PutDataLakeSettingsRequest$CatalogId' => '<p>The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your AWS Lake Formation environment. </p>', 'RemoveLFTagsFromResourceRequest$CatalogId' => '<p>The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your AWS Lake Formation environment. </p>', 'RevokePermissionsRequest$CatalogId' => '<p>The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your AWS Lake Formation environment. </p>', 'SearchDatabasesByLFTagsRequest$CatalogId' => '<p>The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your AWS Lake Formation environment. </p>', 'SearchTablesByLFTagsRequest$CatalogId' => '<p>The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your AWS Lake Formation environment. </p>', 'TableResource$CatalogId' => '<p>The identifier for the Data Catalog. By default, it is the account ID of the caller.</p>', 'TableWithColumnsResource$CatalogId' => '<p>The identifier for the Data Catalog. By default, it is the account ID of the caller.</p>', 'TrustedResourceOwners$member' => NULL, 'UpdateLFTagRequest$CatalogId' => '<p>The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your AWS Lake Formation environment. </p>', ], ], 'CatalogResource' => [ 'base' => '<p>A structure for the catalog object.</p>', 'refs' => [ 'Resource$Catalog' => '<p>The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your AWS Lake Formation environment. </p>', ], ], 'ColumnLFTag' => [ 'base' => '<p>A structure containing the name of a column resource and the tags attached to it.</p>', 'refs' => [ 'ColumnLFTagsList$member' => NULL, ], ], 'ColumnLFTagsList' => [ 'base' => NULL, 'refs' => [ 'GetResourceLFTagsResponse$LFTagsOnColumns' => '<p>A list of tags applied to a column resource.</p>', 'TaggedTable$LFTagsOnColumns' => '<p>A list of tags attached to columns in the table.</p>', ], ], 'ColumnNames' => [ 'base' => NULL, 'refs' => [ 'ColumnWildcard$ExcludedColumnNames' => '<p>Excludes column names. Any column with this name will be excluded.</p>', 'TableWithColumnsResource$ColumnNames' => '<p>The list of column names for the table. At least one of <code>ColumnNames</code> or <code>ColumnWildcard</code> is required.</p>', ], ], 'ColumnWildcard' => [ 'base' => '<p>A wildcard object, consisting of an optional list of excluded column names or indexes.</p>', 'refs' => [ 'TableWithColumnsResource$ColumnWildcard' => '<p>A wildcard specified by a <code>ColumnWildcard</code> object. At least one of <code>ColumnNames</code> or <code>ColumnWildcard</code> is required.</p>', ], ], 'ComparisonOperator' => [ 'base' => NULL, 'refs' => [ 'FilterCondition$ComparisonOperator' => '<p>The comparison operator used in the filter condition.</p>', ], ], 'ConcurrentModificationException' => [ 'base' => '<p>Two processes are trying to modify a resource simultaneously.</p>', 'refs' => [], ], 'CreateLFTagRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateLFTagResponse' => [ 'base' => NULL, 'refs' => [], ], 'DataLakePrincipal' => [ 'base' => '<p>The AWS Lake Formation principal. Supported principals are IAM users or IAM roles.</p>', 'refs' => [ 'BatchPermissionsRequestEntry$Principal' => '<p>The principal to be granted a permission.</p>', 'DataLakePrincipalList$member' => NULL, 'GrantPermissionsRequest$Principal' => '<p>The principal to be granted the permissions on the resource. Supported principals are IAM users or IAM roles, and they are defined by their principal type and their ARN.</p> <p>Note that if you define a resource with a particular ARN, then later delete, and recreate a resource with that same ARN, the resource maintains the permissions already granted. </p>', 'ListPermissionsRequest$Principal' => '<p>Specifies a principal to filter the permissions returned.</p>', 'PrincipalPermissions$Principal' => '<p>The principal who is granted permissions.</p>', 'PrincipalResourcePermissions$Principal' => '<p>The Data Lake principal to be granted or revoked permissions.</p>', 'RevokePermissionsRequest$Principal' => '<p>The principal to be revoked permissions on the resource.</p>', ], ], 'DataLakePrincipalList' => [ 'base' => NULL, 'refs' => [ 'DataLakeSettings$DataLakeAdmins' => '<p>A list of AWS Lake Formation principals. Supported principals are IAM users or IAM roles.</p>', ], ], 'DataLakePrincipalString' => [ 'base' => NULL, 'refs' => [ 'DataLakePrincipal$DataLakePrincipalIdentifier' => '<p>An identifier for the AWS Lake Formation principal.</p>', ], ], 'DataLakeResourceType' => [ 'base' => NULL, 'refs' => [ 'ListPermissionsRequest$ResourceType' => '<p>Specifies a resource type to filter the permissions returned.</p>', ], ], 'DataLakeSettings' => [ 'base' => '<p>A structure representing a list of AWS Lake Formation principals designated as data lake administrators and lists of principal permission entries for default create database and default create table permissions.</p>', 'refs' => [ 'GetDataLakeSettingsResponse$DataLakeSettings' => '<p>A structure representing a list of AWS Lake Formation principals designated as data lake administrators.</p>', 'PutDataLakeSettingsRequest$DataLakeSettings' => '<p>A structure representing a list of AWS Lake Formation principals designated as data lake administrators.</p>', ], ], 'DataLocationResource' => [ 'base' => '<p>A structure for a data location object where permissions are granted or revoked. </p>', 'refs' => [ 'Resource$DataLocation' => '<p>The location of an Amazon S3 path where permissions are granted or revoked. </p>', ], ], 'DatabaseLFTagsList' => [ 'base' => NULL, 'refs' => [ 'SearchDatabasesByLFTagsResponse$DatabaseList' => '<p>A list of databases that meet the tag conditions.</p>', ], ], 'DatabaseResource' => [ 'base' => '<p>A structure for the database object.</p>', 'refs' => [ 'Resource$Database' => '<p>The database for the resource. Unique to the Data Catalog. A database is a set of associated table definitions organized into a logical group. You can Grant and Revoke database permissions to a principal. </p>', 'TaggedDatabase$Database' => '<p>A database that has tags attached to it.</p>', ], ], 'DeleteLFTagRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteLFTagResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeregisterResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeregisterResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescriptionString' => [ 'base' => NULL, 'refs' => [ 'ErrorDetail$ErrorMessage' => '<p>A message describing the error.</p>', ], ], 'DetailsMap' => [ 'base' => '<p>A structure containing the additional details to be returned in the <code>AdditionalDetails</code> attribute of <code>PrincipalResourcePermissions</code>.</p> <p>If a catalog resource is shared through AWS Resource Access Manager (AWS RAM), then there will exist a corresponding RAM resource share ARN.</p>', 'refs' => [ 'PrincipalResourcePermissions$AdditionalDetails' => '<p>This attribute can be used to return any additional details of <code>PrincipalResourcePermissions</code>. Currently returns only as a RAM resource share ARN.</p>', ], ], 'EntityNotFoundException' => [ 'base' => '<p>A specified entity does not exist</p>', 'refs' => [], ], 'ErrorDetail' => [ 'base' => '<p>Contains details about an error.</p>', 'refs' => [ 'BatchPermissionsFailureEntry$Error' => '<p>An error message that applies to the failure of the entry.</p>', 'LFTagError$Error' => '<p>An error that occurred with the attachment or detachment of the tag.</p>', ], ], 'Expression' => [ 'base' => NULL, 'refs' => [ 'LFTagPolicyResource$Expression' => '<p>A list of tag conditions that apply to the resource\'s tag policy.</p>', 'SearchDatabasesByLFTagsRequest$Expression' => '<p>A list of conditions (<code>LFTag</code> structures) to search for in database resources.</p>', 'SearchTablesByLFTagsRequest$Expression' => '<p>A list of conditions (<code>LFTag</code> structures) to search for in table resources.</p>', ], ], 'FieldNameString' => [ 'base' => NULL, 'refs' => [ 'FilterCondition$Field' => '<p>The field to filter in the filter condition.</p>', ], ], 'FilterCondition' => [ 'base' => '<p>This structure describes the filtering of columns in a table based on a filter condition.</p>', 'refs' => [ 'FilterConditionList$member' => NULL, ], ], 'FilterConditionList' => [ 'base' => NULL, 'refs' => [ 'ListResourcesRequest$FilterConditionList' => '<p>Any applicable row-level and/or column-level filtering conditions for the resources.</p>', ], ], 'GetDataLakeSettingsRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetDataLakeSettingsResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetEffectivePermissionsForPathRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetEffectivePermissionsForPathResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetLFTagRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetLFTagResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetResourceLFTagsRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetResourceLFTagsResponse' => [ 'base' => NULL, 'refs' => [], ], 'GlueEncryptionException' => [ 'base' => '<p>An encryption operation failed.</p>', 'refs' => [], ], 'GrantPermissionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'GrantPermissionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'IAMRoleArn' => [ 'base' => NULL, 'refs' => [ 'RegisterResourceRequest$RoleArn' => '<p>The identifier for the role that registers the resource.</p>', 'ResourceInfo$RoleArn' => '<p>The IAM role that registered a resource.</p>', 'UpdateResourceRequest$RoleArn' => '<p>The new role to use for the given resource registered in AWS Lake Formation.</p>', ], ], 'Identifier' => [ 'base' => NULL, 'refs' => [ 'BatchPermissionsRequestEntry$Id' => '<p>A unique identifier for the batch permissions request entry.</p>', ], ], 'InternalServiceException' => [ 'base' => '<p>An internal service error occurred.</p>', 'refs' => [], ], 'InvalidInputException' => [ 'base' => '<p>The input provided was not valid.</p>', 'refs' => [], ], 'LFTag' => [ 'base' => '<p>A structure that allows an admin to grant user permissions on certain conditions. For example, granting a role access to all columns not tagged \'PII\' of tables tagged \'Prod\'.</p>', 'refs' => [ 'Expression$member' => NULL, ], ], 'LFTagError' => [ 'base' => '<p>A structure containing an error related to a <code>TagResource</code> or <code>UnTagResource</code> operation.</p>', 'refs' => [ 'LFTagErrors$member' => NULL, ], ], 'LFTagErrors' => [ 'base' => NULL, 'refs' => [ 'AddLFTagsToResourceResponse$Failures' => '<p>A list of failures to tag the resource.</p>', 'RemoveLFTagsFromResourceResponse$Failures' => '<p>A list of failures to untag a resource.</p>', ], ], 'LFTagKey' => [ 'base' => NULL, 'refs' => [ 'CreateLFTagRequest$TagKey' => '<p>The key-name for the tag.</p>', 'DeleteLFTagRequest$TagKey' => '<p>The key-name for the tag to delete.</p>', 'GetLFTagRequest$TagKey' => '<p>The key-name for the tag.</p>', 'GetLFTagResponse$TagKey' => '<p>The key-name for the tag.</p>', 'LFTag$TagKey' => '<p>The key-name for the tag.</p>', 'LFTagPair$TagKey' => '<p>The key-name for the tag.</p>', 'UpdateLFTagRequest$TagKey' => '<p>The key-name for the tag for which to add or delete values.</p>', ], ], 'LFTagKeyResource' => [ 'base' => '<p>A structure containing a tag key and values for a resource.</p>', 'refs' => [ 'Resource$LFTag' => '<p>The tag key and values attached to a resource.</p>', ], ], 'LFTagPair' => [ 'base' => '<p>A structure containing a tag key-value pair.</p>', 'refs' => [ 'LFTagError$LFTag' => '<p>The key-name of the tag.</p>', 'LFTagsList$member' => NULL, ], ], 'LFTagPolicyResource' => [ 'base' => '<p>A structure containing a list of tag conditions that apply to a resource\'s tag policy.</p>', 'refs' => [ 'Resource$LFTagPolicy' => '<p>A list of tag conditions that define a resource\'s tag policy.</p>', ], ], 'LFTagValue' => [ 'base' => NULL, 'refs' => [ 'TagValueList$member' => NULL, ], ], 'LFTagsList' => [ 'base' => NULL, 'refs' => [ 'AddLFTagsToResourceRequest$LFTags' => '<p>The tags to attach to the resource.</p>', 'ColumnLFTag$LFTags' => '<p>The tags attached to a column resource.</p>', 'GetResourceLFTagsResponse$LFTagOnDatabase' => '<p>A list of tags applied to a database resource.</p>', 'GetResourceLFTagsResponse$LFTagsOnTable' => '<p>A list of tags applied to a table resource.</p>', 'ListLFTagsResponse$LFTags' => '<p>A list of tags that the requested has permission to view.</p>', 'RemoveLFTagsFromResourceRequest$LFTags' => '<p>The tags to be removed from the resource.</p>', 'TaggedDatabase$LFTags' => '<p>A list of tags attached to the database.</p>', 'TaggedTable$LFTagOnDatabase' => '<p>A list of tags attached to the database where the table resides.</p>', 'TaggedTable$LFTagsOnTable' => '<p>A list of tags attached to the table.</p>', ], ], 'LastModifiedTimestamp' => [ 'base' => NULL, 'refs' => [ 'ResourceInfo$LastModified' => '<p>The date and time the resource was last modified.</p>', ], ], 'ListLFTagsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListLFTagsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListPermissionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListPermissionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListResourcesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListResourcesResponse' => [ 'base' => NULL, 'refs' => [], ], 'MessageString' => [ 'base' => NULL, 'refs' => [ 'AccessDeniedException$Message' => '<p>A message describing the problem.</p>', 'AlreadyExistsException$Message' => '<p>A message describing the problem.</p>', 'ConcurrentModificationException$Message' => '<p>A message describing the problem.</p>', 'EntityNotFoundException$Message' => '<p>A message describing the problem.</p>', 'GlueEncryptionException$Message' => '<p>A message describing the problem.</p>', 'InternalServiceException$Message' => '<p>A message describing the problem.</p>', 'InvalidInputException$Message' => '<p>A message describing the problem.</p>', 'OperationTimeoutException$Message' => '<p>A message describing the problem.</p>', 'ResourceNumberLimitExceededException$Message' => '<p>A message describing the problem.</p>', ], ], 'NameString' => [ 'base' => NULL, 'refs' => [ 'ColumnLFTag$Name' => '<p>The name of a column resource.</p>', 'ColumnNames$member' => NULL, 'DatabaseResource$Name' => '<p>The name of the database resource. Unique to the Data Catalog.</p>', 'ErrorDetail$ErrorCode' => '<p>The code associated with this error.</p>', 'LFTagKeyResource$TagKey' => '<p>The key-name for the tag.</p>', 'TableResource$DatabaseName' => '<p>The name of the database for the table. Unique to a Data Catalog. A database is a set of associated table definitions organized into a logical group. You can Grant and Revoke database privileges to a principal. </p>', 'TableResource$Name' => '<p>The name of the table.</p>', 'TableWithColumnsResource$DatabaseName' => '<p>The name of the database for the table with columns resource. Unique to the Data Catalog. A database is a set of associated table definitions organized into a logical group. You can Grant and Revoke database privileges to a principal. </p>', 'TableWithColumnsResource$Name' => '<p>The name of the table resource. A table is a metadata definition that represents your data. You can Grant and Revoke table privileges to a principal. </p>', ], ], 'NullableBoolean' => [ 'base' => NULL, 'refs' => [ 'RegisterResourceRequest$UseServiceLinkedRole' => '<p>Designates an AWS Identity and Access Management (IAM) service-linked role by registering this role with the Data Catalog. A service-linked role is a unique type of IAM role that is linked directly to Lake Formation.</p> <p>For more information, see <a href="https://docs-aws.amazon.com/lake-formation/latest/dg/service-linked-roles.html">Using Service-Linked Roles for Lake Formation</a>.</p>', ], ], 'OperationTimeoutException' => [ 'base' => '<p>The operation timed out.</p>', 'refs' => [], ], 'PageSize' => [ 'base' => NULL, 'refs' => [ 'GetEffectivePermissionsForPathRequest$MaxResults' => '<p>The maximum number of results to return.</p>', 'ListLFTagsRequest$MaxResults' => '<p>The maximum number of results to return.</p>', 'ListPermissionsRequest$MaxResults' => '<p>The maximum number of results to return.</p>', 'ListResourcesRequest$MaxResults' => '<p>The maximum number of resource results.</p>', 'SearchDatabasesByLFTagsRequest$MaxResults' => '<p>The maximum number of results to return.</p>', 'SearchTablesByLFTagsRequest$MaxResults' => '<p>The maximum number of results to return.</p>', ], ], 'Permission' => [ 'base' => NULL, 'refs' => [ 'PermissionList$member' => NULL, ], ], 'PermissionList' => [ 'base' => NULL, 'refs' => [ 'BatchPermissionsRequestEntry$Permissions' => '<p>The permissions to be granted.</p>', 'BatchPermissionsRequestEntry$PermissionsWithGrantOption' => '<p>Indicates if the option to pass permissions is granted.</p>', 'GrantPermissionsRequest$Permissions' => '<p>The permissions granted to the principal on the resource. AWS Lake Formation defines privileges to grant and revoke access to metadata in the Data Catalog and data organized in underlying data storage such as Amazon S3. AWS Lake Formation requires that each principal be authorized to perform a specific task on AWS Lake Formation resources. </p>', 'GrantPermissionsRequest$PermissionsWithGrantOption' => '<p>Indicates a list of the granted permissions that the principal may pass to other users. These permissions may only be a subset of the permissions granted in the <code>Privileges</code>.</p>', 'PrincipalPermissions$Permissions' => '<p>The permissions that are granted to the principal.</p>', 'PrincipalResourcePermissions$Permissions' => '<p>The permissions to be granted or revoked on the resource.</p>', 'PrincipalResourcePermissions$PermissionsWithGrantOption' => '<p>Indicates whether to grant the ability to grant permissions (as a subset of permissions granted).</p>', 'RevokePermissionsRequest$Permissions' => '<p>The permissions revoked to the principal on the resource. For information about permissions, see <a href="https://docs-aws.amazon.com/lake-formation/latest/dg/security-data-access.html">Security and Access Control to Metadata and Data</a>.</p>', 'RevokePermissionsRequest$PermissionsWithGrantOption' => '<p>Indicates a list of permissions for which to revoke the grant option allowing the principal to pass permissions to other principals.</p>', ], ], 'PrincipalPermissions' => [ 'base' => '<p>Permissions granted to a principal.</p>', 'refs' => [ 'PrincipalPermissionsList$member' => NULL, ], ], 'PrincipalPermissionsList' => [ 'base' => NULL, 'refs' => [ 'DataLakeSettings$CreateDatabaseDefaultPermissions' => '<p>A structure representing a list of up to three principal permissions entries for default create database permissions.</p>', 'DataLakeSettings$CreateTableDefaultPermissions' => '<p>A structure representing a list of up to three principal permissions entries for default create table permissions.</p>', ], ], 'PrincipalResourcePermissions' => [ 'base' => '<p>The permissions granted or revoked on a resource.</p>', 'refs' => [ 'PrincipalResourcePermissionsList$member' => NULL, ], ], 'PrincipalResourcePermissionsList' => [ 'base' => NULL, 'refs' => [ 'GetEffectivePermissionsForPathResponse$Permissions' => '<p>A list of the permissions for the specified table or database resource located at the path in Amazon S3.</p>', 'ListPermissionsResponse$PrincipalResourcePermissions' => '<p>A list of principals and their permissions on the resource for the specified principal and resource types.</p>', ], ], 'PutDataLakeSettingsRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutDataLakeSettingsResponse' => [ 'base' => NULL, 'refs' => [], ], 'RAMResourceShareArn' => [ 'base' => NULL, 'refs' => [ 'ResourceShareList$member' => NULL, ], ], 'RegisterResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'RegisterResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'RemoveLFTagsFromResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'RemoveLFTagsFromResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'Resource' => [ 'base' => '<p>A structure for the resource.</p>', 'refs' => [ 'AddLFTagsToResourceRequest$Resource' => '<p>The resource to which to attach a tag.</p>', 'BatchPermissionsRequestEntry$Resource' => '<p>The resource to which the principal is to be granted a permission.</p>', 'GetResourceLFTagsRequest$Resource' => '<p>The resource for which you want to return tags.</p>', 'GrantPermissionsRequest$Resource' => '<p>The resource to which permissions are to be granted. Resources in AWS Lake Formation are the Data Catalog, databases, and tables.</p>', 'ListPermissionsRequest$Resource' => '<p>A resource where you will get a list of the principal permissions.</p> <p>This operation does not support getting privileges on a table with columns. Instead, call this operation on the table, and the operation returns the table and the table w columns.</p>', 'PrincipalResourcePermissions$Resource' => '<p>The resource where permissions are to be granted or revoked.</p>', 'RemoveLFTagsFromResourceRequest$Resource' => '<p>The resource where you want to remove a tag.</p>', 'RevokePermissionsRequest$Resource' => '<p>The resource to which permissions are to be revoked.</p>', ], ], 'ResourceArnString' => [ 'base' => NULL, 'refs' => [ 'DataLocationResource$ResourceArn' => '<p>The Amazon Resource Name (ARN) that uniquely identifies the data location resource.</p>', 'DeregisterResourceRequest$ResourceArn' => '<p>The Amazon Resource Name (ARN) of the resource that you want to deregister.</p>', 'DescribeResourceRequest$ResourceArn' => '<p>The resource ARN.</p>', 'GetEffectivePermissionsForPathRequest$ResourceArn' => '<p>The Amazon Resource Name (ARN) of the resource for which you want to get permissions.</p>', 'RegisterResourceRequest$ResourceArn' => '<p>The Amazon Resource Name (ARN) of the resource that you want to register.</p>', 'ResourceInfo$ResourceArn' => '<p>The Amazon Resource Name (ARN) of the resource.</p>', 'UpdateResourceRequest$ResourceArn' => '<p>The resource ARN.</p>', ], ], 'ResourceInfo' => [ 'base' => '<p>A structure containing information about an AWS Lake Formation resource.</p>', 'refs' => [ 'DescribeResourceResponse$ResourceInfo' => '<p>A structure containing information about an AWS Lake Formation resource.</p>', 'ResourceInfoList$member' => NULL, ], ], 'ResourceInfoList' => [ 'base' => NULL, 'refs' => [ 'ListResourcesResponse$ResourceInfoList' => '<p>A summary of the data lake resources.</p>', ], ], 'ResourceNumberLimitExceededException' => [ 'base' => '<p>A resource numerical limit was exceeded.</p>', 'refs' => [], ], 'ResourceShareList' => [ 'base' => NULL, 'refs' => [ 'DetailsMap$ResourceShare' => '<p>A resource share ARN for a catalog resource shared through AWS Resource Access Manager (AWS RAM).</p>', ], ], 'ResourceShareType' => [ 'base' => NULL, 'refs' => [ 'ListLFTagsRequest$ResourceShareType' => '<p>If resource share type is <code>ALL</code>, returns both in-account tags and shared tags that the requester has permission to view. If resource share type is <code>FOREIGN</code>, returns all share tags that the requester can view. If no resource share type is passed, lists tags in the given catalog ID that the requester has permission to view.</p>', ], ], 'ResourceType' => [ 'base' => NULL, 'refs' => [ 'LFTagPolicyResource$ResourceType' => '<p>The resource type for which the tag policy applies.</p>', ], ], 'RevokePermissionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'RevokePermissionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'SearchDatabasesByLFTagsRequest' => [ 'base' => NULL, 'refs' => [], ], 'SearchDatabasesByLFTagsResponse' => [ 'base' => NULL, 'refs' => [], ], 'SearchTablesByLFTagsRequest' => [ 'base' => NULL, 'refs' => [], ], 'SearchTablesByLFTagsResponse' => [ 'base' => NULL, 'refs' => [], ], 'StringValue' => [ 'base' => NULL, 'refs' => [ 'StringValueList$member' => NULL, ], ], 'StringValueList' => [ 'base' => NULL, 'refs' => [ 'FilterCondition$StringValueList' => '<p>A string with values used in evaluating the filter condition.</p>', ], ], 'TableLFTagsList' => [ 'base' => NULL, 'refs' => [ 'SearchTablesByLFTagsResponse$TableList' => '<p>A list of tables that meet the tag conditions.</p>', ], ], 'TableResource' => [ 'base' => '<p>A structure for the table object. A table is a metadata definition that represents your data. You can Grant and Revoke table privileges to a principal. </p>', 'refs' => [ 'Resource$Table' => '<p>The table for the resource. A table is a metadata definition that represents your data. You can Grant and Revoke table privileges to a principal. </p>', 'TaggedTable$Table' => '<p>A table that has tags attached to it.</p>', ], ], 'TableWildcard' => [ 'base' => '<p>A wildcard object representing every table under a database.</p>', 'refs' => [ 'TableResource$TableWildcard' => '<p>A wildcard object representing every table under a database.</p> <p>At least one of <code>TableResource$Name</code> or <code>TableResource$TableWildcard</code> is required.</p>', ], ], 'TableWithColumnsResource' => [ 'base' => '<p>A structure for a table with columns object. This object is only used when granting a SELECT permission.</p> <p>This object must take a value for at least one of <code>ColumnsNames</code>, <code>ColumnsIndexes</code>, or <code>ColumnsWildcard</code>.</p>', 'refs' => [ 'Resource$TableWithColumns' => '<p>The table with columns for the resource. A principal with permissions to this resource can select metadata from the columns of a table in the Data Catalog and the underlying data in Amazon S3.</p>', ], ], 'TagValueList' => [ 'base' => NULL, 'refs' => [ 'CreateLFTagRequest$TagValues' => '<p>A list of possible values an attribute can take.</p>', 'GetLFTagResponse$TagValues' => '<p>A list of possible values an attribute can take.</p>', 'LFTag$TagValues' => '<p>A list of possible values an attribute can take.</p>', 'LFTagKeyResource$TagValues' => '<p>A list of possible values an attribute can take.</p>', 'LFTagPair$TagValues' => '<p>A list of possible values an attribute can take.</p>', 'UpdateLFTagRequest$TagValuesToDelete' => '<p>A list of tag values to delete from the tag.</p>', 'UpdateLFTagRequest$TagValuesToAdd' => '<p>A list of tag values to add from the tag.</p>', ], ], 'TaggedDatabase' => [ 'base' => '<p>A structure describing a database resource with tags.</p>', 'refs' => [ 'DatabaseLFTagsList$member' => NULL, ], ], 'TaggedTable' => [ 'base' => '<p>A structure describing a table resource with tags.</p>', 'refs' => [ 'TableLFTagsList$member' => NULL, ], ], 'Token' => [ 'base' => NULL, 'refs' => [ 'GetEffectivePermissionsForPathRequest$NextToken' => '<p>A continuation token, if this is not the first call to retrieve this list.</p>', 'GetEffectivePermissionsForPathResponse$NextToken' => '<p>A continuation token, if this is not the first call to retrieve this list.</p>', 'ListLFTagsRequest$NextToken' => '<p>A continuation token, if this is not the first call to retrieve this list.</p>', 'ListLFTagsResponse$NextToken' => '<p>A continuation token, present if the current list segment is not the last.</p>', 'ListPermissionsRequest$NextToken' => '<p>A continuation token, if this is not the first call to retrieve this list.</p>', 'ListPermissionsResponse$NextToken' => '<p>A continuation token, if this is not the first call to retrieve this list.</p>', 'ListResourcesRequest$NextToken' => '<p>A continuation token, if this is not the first call to retrieve these resources.</p>', 'ListResourcesResponse$NextToken' => '<p>A continuation token, if this is not the first call to retrieve these resources.</p>', 'SearchDatabasesByLFTagsRequest$NextToken' => '<p>A continuation token, if this is not the first call to retrieve this list.</p>', 'SearchDatabasesByLFTagsResponse$NextToken' => '<p>A continuation token, present if the current list segment is not the last.</p>', 'SearchTablesByLFTagsRequest$NextToken' => '<p>A continuation token, if this is not the first call to retrieve this list.</p>', 'SearchTablesByLFTagsResponse$NextToken' => '<p>A continuation token, present if the current list segment is not the last.</p>', ], ], 'TrustedResourceOwners' => [ 'base' => NULL, 'refs' => [ 'DataLakeSettings$TrustedResourceOwners' => '<p>A list of the resource-owning account IDs that the caller\'s account can use to share their user access details (user ARNs). The user ARNs can be logged in the resource owner\'s AWS CloudTrail log.</p> <p>You may want to specify this property when you are in a high-trust boundary, such as the same team or company. </p>', ], ], 'UpdateLFTagRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateLFTagResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateResourceResponse' => [ 'base' => NULL, 'refs' => [], ], ],];
