<?php
// This file was auto-generated from sdk-root/src/data/kendra/2019-02-03/docs-2.json
return [ 'version' => '2.0', 'service' => '<p>Amazon Kendra is a service for indexing large document sets.</p>', 'operations' => [ 'BatchDeleteDocument' => '<p>Removes one or more documents from an index. The documents must have been added with the <code>BatchPutDocument</code> operation.</p> <p>The documents are deleted asynchronously. You can see the progress of the deletion by using Amazon Web Services CloudWatch. Any error messages related to the processing of the batch are sent to you CloudWatch log.</p>', 'BatchGetDocumentStatus' => '<p>Returns the indexing status for one or more documents submitted with the <a href="https://docs.aws.amazon.com/kendra/latest/dg/API_BatchPutDocument.html"> BatchPutDocument</a> operation.</p> <p>When you use the <code>BatchPutDocument</code> operation, documents are indexed asynchronously. You can use the <code>BatchGetDocumentStatus</code> operation to get the current status of a list of documents so that you can determine if they have been successfully indexed.</p> <p>You can also use the <code>BatchGetDocumentStatus</code> operation to check the status of the <a href="https://docs.aws.amazon.com/kendra/latest/dg/API_BatchDeleteDocument.html"> BatchDeleteDocument</a> operation. When a document is deleted from the index, Amazon Kendra returns <code>NOT_FOUND</code> as the status.</p>', 'BatchPutDocument' => '<p>Adds one or more documents to an index.</p> <p>The <code>BatchPutDocument</code> operation enables you to ingest inline documents or a set of documents stored in an Amazon S3 bucket. Use this operation to ingest your text and unstructured text into an index, add custom attributes to the documents, and to attach an access control list to the documents added to the index.</p> <p>The documents are indexed asynchronously. You can see the progress of the batch using Amazon Web Services CloudWatch. Any error messages related to processing the batch are sent to your Amazon Web Services CloudWatch log.</p>', 'ClearQuerySuggestions' => '<p>Clears existing query suggestions from an index.</p> <p>This deletes existing suggestions only, not the queries in the query log. After you clear suggestions, Amazon Kendra learns new suggestions based on new queries added to the query log from the time you cleared suggestions. If you do not see any new suggestions, then please allow Amazon Kendra to collect enough queries to learn new suggestions.</p>', 'CreateDataSource' => '<p>Creates a data source that you use to with an Amazon Kendra index. </p> <p>You specify a name, data source connector type and description for your data source. You also specify configuration information such as document metadata (author, source URI, and so on) and user context information.</p> <p> <code>CreateDataSource</code> is a synchronous operation. The operation returns 200 if the data source was successfully created. Otherwise, an exception is raised.</p>', 'CreateFaq' => '<p>Creates an new set of frequently asked question (FAQ) questions and answers.</p>', 'CreateIndex' => '<p>Creates a new Amazon Kendra index. Index creation is an asynchronous operation. To determine if index creation has completed, check the <code>Status</code> field returned from a call to <code>DescribeIndex</code>. The <code>Status</code> field is set to <code>ACTIVE</code> when the index is ready to use.</p> <p>Once the index is active you can index your documents using the <code>BatchPutDocument</code> operation or using one of the supported data sources. </p>', 'CreateQuerySuggestionsBlockList' => '<p>Creates a block list to exlcude certain queries from suggestions.</p> <p>Any query that contains words or phrases specified in the block list is blocked or filtered out from being shown as a suggestion.</p> <p>You need to provide the file location of your block list text file in your S3 bucket. In your text file, enter each block word or phrase on a separate line.</p> <p>For information on the current quota limits for block lists, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/quotas.html">Quotas for Amazon Kendra</a>.</p>', 'CreateThesaurus' => '<p>Creates a thesaurus for an index. The thesaurus contains a list of synonyms in Solr format.</p>', 'DeleteDataSource' => '<p>Deletes an Amazon Kendra data source. An exception is not thrown if the data source is already being deleted. While the data source is being deleted, the <code>Status</code> field returned by a call to the <code>DescribeDataSource</code> operation is set to <code>DELETING</code>. For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/delete-data-source.html">Deleting Data Sources</a>.</p>', 'DeleteFaq' => '<p>Removes an FAQ from an index.</p>', 'DeleteIndex' => '<p>Deletes an existing Amazon Kendra index. An exception is not thrown if the index is already being deleted. While the index is being deleted, the <code>Status</code> field returned by a call to the <code>DescribeIndex</code> operation is set to <code>DELETING</code>.</p>', 'DeletePrincipalMapping' => '<p>Deletes a group so that all users and sub groups that belong to the group can no longer access documents only available to that group.</p> <p>For example, after deleting the group "Summer Interns", all interns who belonged to that group no longer see intern-only documents in their search results.</p> <p>If you want to delete or replace users or sub groups of a group, you need to use the <code>PutPrincipalMapping</code> operation. For example, if a user in the group "Engineering" leaves the engineering team and another user takes their place, you provide an updated list of users or sub groups that belong to the "Engineering" group when calling <code>PutPrincipalMapping</code>. You can update your internal list of users or sub groups and input this list when calling <code>PutPrincipalMapping</code>.</p>', 'DeleteQuerySuggestionsBlockList' => '<p>Deletes a block list used for query suggestions for an index.</p> <p>A deleted block list might not take effect right away. Amazon Kendra needs to refresh the entire suggestions list to add back the queries that were previously blocked.</p>', 'DeleteThesaurus' => '<p>Deletes an existing Amazon Kendra thesaurus. </p>', 'DescribeDataSource' => '<p>Gets information about a Amazon Kendra data source.</p>', 'DescribeFaq' => '<p>Gets information about an FAQ list.</p>', 'DescribeIndex' => '<p>Describes an existing Amazon Kendra index</p>', 'DescribePrincipalMapping' => '<p>Describes the processing of <code>PUT</code> and <code>DELETE</code> actions for mapping users to their groups. This includes information on the status of actions currently processing or yet to be processed, when actions were last updated, when actions were received by Amazon Kendra, the latest action that should process and apply after other actions, and useful error messages if an action could not be processed.</p>', 'DescribeQuerySuggestionsBlockList' => '<p>Describes a block list used for query suggestions for an index.</p> <p>This is used to check the current settings that are applied to a block list.</p>', 'DescribeQuerySuggestionsConfig' => '<p>Describes the settings of query suggestions for an index.</p> <p>This is used to check the current settings applied to query suggestions.</p>', 'DescribeThesaurus' => '<p>Describes an existing Amazon Kendra thesaurus.</p>', 'GetQuerySuggestions' => '<p>Fetches the queries that are suggested to your users.</p>', 'ListDataSourceSyncJobs' => '<p>Gets statistics about synchronizing Amazon Kendra with a data source.</p>', 'ListDataSources' => '<p>Lists the data sources that you have created.</p>', 'ListFaqs' => '<p>Gets a list of FAQ lists associated with an index.</p>', 'ListGroupsOlderThanOrderingId' => '<p>Provides a list of groups that are mapped to users before a given ordering or timestamp identifier.</p>', 'ListIndices' => '<p>Lists the Amazon Kendra indexes that you have created.</p>', 'ListQuerySuggestionsBlockLists' => '<p>Lists the block lists used for query suggestions for an index.</p> <p>For information on the current quota limits for block lists, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/quotas.html">Quotas for Amazon Kendra</a>.</p>', 'ListTagsForResource' => '<p>Gets a list of tags associated with a specified resource. Indexes, FAQs, and data sources can have tags associated with them.</p>', 'ListThesauri' => '<p>Lists the Amazon Kendra thesauri associated with an index.</p>', 'PutPrincipalMapping' => '<p>Maps users to their groups. You can also map sub groups to groups. For example, the group "Company Intellectual Property Teams" includes sub groups "Research" and "Engineering". These sub groups include their own list of users or people who work in these teams. Only users who work in research and engineering, and therefore belong in the intellectual property group, can see top-secret company documents in their search results. </p> <p>You map users to their groups when you want to filter search results for different users based on their group’s access to documents. For more information on filtering search results for different users, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/user-context-filter.html">Filtering on user context</a>.</p> <p>If more than five <code>PUT</code> actions for a group are currently processing, a validation exception is thrown.</p>', 'Query' => '<p>Searches an active index. Use this API to search your documents using query. The <code>Query</code> operation enables to do faceted search and to filter results based on document attributes.</p> <p>It also enables you to provide user context that Amazon Kendra uses to enforce document access control in the search results. </p> <p>Amazon Kendra searches your index for text content and question and answer (FAQ) content. By default the response contains three types of results.</p> <ul> <li> <p>Relevant passages</p> </li> <li> <p>Matching FAQs</p> </li> <li> <p>Relevant documents</p> </li> </ul> <p>You can specify that the query return only one type of result using the <code>QueryResultTypeConfig</code> parameter.</p> <p>Each query returns the 100 most relevant results. </p>', 'StartDataSourceSyncJob' => '<p>Starts a synchronization job for a data source. If a synchronization job is already in progress, Amazon Kendra returns a <code>ResourceInUseException</code> exception.</p>', 'StopDataSourceSyncJob' => '<p>Stops a running synchronization job. You can\'t stop a scheduled synchronization job.</p>', 'SubmitFeedback' => '<p>Enables you to provide feedback to Amazon Kendra to improve the performance of your index. </p>', 'TagResource' => '<p>Adds the specified tag to the specified index, FAQ, or data source resource. If the tag already exists, the existing value is replaced with the new value.</p>', 'UntagResource' => '<p>Removes a tag from an index, FAQ, or a data source.</p>', 'UpdateDataSource' => '<p>Updates an existing Amazon Kendra data source.</p>', 'UpdateIndex' => '<p>Updates an existing Amazon Kendra index.</p>', 'UpdateQuerySuggestionsBlockList' => '<p>Updates a block list used for query suggestions for an index.</p> <p>Updates to a block list might not take effect right away. Amazon Kendra needs to refresh the entire suggestions list to apply any updates to the block list. Other changes not related to the block list apply immediately.</p> <p>If a block list is updating, then you need to wait for the first update to finish before submitting another update.</p> <p>Amazon Kendra supports partial updates, so you only need to provide the fields you want to update.</p>', 'UpdateQuerySuggestionsConfig' => '<p>Updates the settings of query suggestions for an index.</p> <p>Amazon Kendra supports partial updates, so you only need to provide the fields you want to update.</p> <p>If an update is currently processing (i.e. \'happening\'), you need to wait for the update to finish before making another update.</p> <p>Updates to query suggestions settings might not take effect right away. The time for your updated settings to take effect depends on the updates made and the number of search queries in your index.</p> <p>You can still enable/disable query suggestions at any time.</p>', 'UpdateThesaurus' => '<p>Updates a thesaurus file associated with an index.</p>', ], 'shapes' => [ 'AccessControlListConfiguration' => [ 'base' => '<p>Access Control List files for the documents in a data source. For the format of the file, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/s3-acl.html">Access control for S3 data sources</a>.</p>', 'refs' => [ 'S3DataSourceConfiguration$AccessControlListConfiguration' => '<p>Provides the path to the S3 bucket that contains the user context filtering files for the data source. For the format of the file, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/s3-acl.html">Access control for S3 data sources</a>.</p>', ], ], 'AccessDeniedException' => [ 'base' => '<p/>', 'refs' => [], ], 'AclConfiguration' => [ 'base' => '<p>Provides information about the column that should be used for filtering the query response by groups.</p>', 'refs' => [ 'DatabaseConfiguration$AclConfiguration' => '<p>Information about the database column that provides information for user context filtering.</p>', ], ], 'AdditionalResultAttribute' => [ 'base' => '<p>An attribute returned from an index query.</p>', 'refs' => [ 'AdditionalResultAttributeList$member' => NULL, ], ], 'AdditionalResultAttributeList' => [ 'base' => NULL, 'refs' => [ 'QueryResultItem$AdditionalAttributes' => '<p>One or more additional attributes associated with the query result.</p>', ], ], 'AdditionalResultAttributeValue' => [ 'base' => '<p>An attribute returned with a document from a search.</p>', 'refs' => [ 'AdditionalResultAttribute$Value' => '<p>An object that contains the attribute value.</p>', ], ], 'AdditionalResultAttributeValueType' => [ 'base' => NULL, 'refs' => [ 'AdditionalResultAttribute$ValueType' => '<p>The data type of the <code>Value</code> property.</p>', ], ], 'AmazonResourceName' => [ 'base' => NULL, 'refs' => [ 'ListTagsForResourceRequest$ResourceARN' => '<p>The Amazon Resource Name (ARN) of the index, FAQ, or data source to get a list of tags for.</p>', 'TagResourceRequest$ResourceARN' => '<p>The Amazon Resource Name (ARN) of the index, FAQ, or data source to tag.</p>', 'UntagResourceRequest$ResourceARN' => '<p>The Amazon Resource Name (ARN) of the index, FAQ, or data source to remove the tag from.</p>', ], ], 'AttributeFilter' => [ 'base' => '<p>Provides filtering the query results based on document attributes.</p> <p>When you use the <code>AndAllFilters</code> or <code>OrAllFilters</code>, filters you can use 2 layers under the first attribute filter. For example, you can use:</p> <p> <code>&lt;AndAllFilters&gt;</code> </p> <ol> <li> <p> <code> &lt;OrAllFilters&gt;</code> </p> </li> <li> <p> <code> &lt;EqualTo&gt;</code> </p> </li> </ol> <p>If you use more than 2 layers, you receive a <code>ValidationException</code> exception with the message "<code>AttributeFilter</code> cannot have a depth of more than 2."</p> <p>If you use more than 10 attribute filters, you receive a <code>ValidationException</code> exception with the message "<code>AttributeFilter</code> cannot have a length of more than 10".</p>', 'refs' => [ 'AttributeFilter$NotFilter' => '<p>Performs a logical <code>NOT</code> operation on all supplied filters.</p>', 'AttributeFilterList$member' => NULL, 'QueryRequest$AttributeFilter' => '<p>Enables filtered searches based on document attributes. You can only provide one attribute filter; however, the <code>AndAllFilters</code>, <code>NotFilter</code>, and <code>OrAllFilters</code> parameters contain a list of other filters.</p> <p>The <code>AttributeFilter</code> parameter enables you to create a set of filtering rules that a document must satisfy to be included in the query results.</p>', ], ], 'AttributeFilterList' => [ 'base' => NULL, 'refs' => [ 'AttributeFilter$AndAllFilters' => '<p>Performs a logical <code>AND</code> operation on all supplied filters.</p>', 'AttributeFilter$OrAllFilters' => '<p>Performs a logical <code>OR</code> operation on all supplied filters.</p>', ], ], 'AuthenticationConfiguration' => [ 'base' => '<p>Provides the configuration information to connect to websites that require user authentication.</p>', 'refs' => [ 'WebCrawlerConfiguration$AuthenticationConfiguration' => '<p>Provides configuration information required to connect to websites using authentication.</p> <p>You can connect to websites using basic authentication of user name and password.</p> <p>You must provide the website host name and port number. For example, the host name of https://a.example.com/page1.html is "a.example.com" and the port is 443, the standard port for HTTPS. You use a secret in <a href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/intro.html">AWS Secrets Manager</a> to store your authentication credentials.</p>', ], ], 'BasicAuthenticationConfiguration' => [ 'base' => '<p>Provides the configuration information to connect to websites that require basic user authentication.</p>', 'refs' => [ 'BasicAuthenticationConfigurationList$member' => NULL, ], ], 'BasicAuthenticationConfigurationList' => [ 'base' => NULL, 'refs' => [ 'AuthenticationConfiguration$BasicAuthentication' => '<p>The list of configuration information that\'s required to connect to and crawl a website host using basic authentication credentials.</p> <p>The list includes the name and port number of the website host.</p>', ], ], 'BatchDeleteDocumentRequest' => [ 'base' => NULL, 'refs' => [], ], 'BatchDeleteDocumentResponse' => [ 'base' => NULL, 'refs' => [], ], 'BatchDeleteDocumentResponseFailedDocument' => [ 'base' => '<p>Provides information about documents that could not be removed from an index by the <code>BatchDeleteDocument</code> operation.</p>', 'refs' => [ 'BatchDeleteDocumentResponseFailedDocuments$member' => NULL, ], ], 'BatchDeleteDocumentResponseFailedDocuments' => [ 'base' => NULL, 'refs' => [ 'BatchDeleteDocumentResponse$FailedDocuments' => '<p>A list of documents that could not be removed from the index. Each entry contains an error message that indicates why the document couldn\'t be removed from the index.</p>', ], ], 'BatchGetDocumentStatusRequest' => [ 'base' => NULL, 'refs' => [], ], 'BatchGetDocumentStatusResponse' => [ 'base' => NULL, 'refs' => [], ], 'BatchGetDocumentStatusResponseError' => [ 'base' => '<p>Provides a response when the status of a document could not be retrieved.</p>', 'refs' => [ 'BatchGetDocumentStatusResponseErrors$member' => NULL, ], ], 'BatchGetDocumentStatusResponseErrors' => [ 'base' => NULL, 'refs' => [ 'BatchGetDocumentStatusResponse$Errors' => '<p>A list of documents that Amazon Kendra couldn\'t get the status for. The list includes the ID of the document and the reason that the status couldn\'t be found.</p>', ], ], 'BatchPutDocumentRequest' => [ 'base' => NULL, 'refs' => [], ], 'BatchPutDocumentResponse' => [ 'base' => NULL, 'refs' => [], ], 'BatchPutDocumentResponseFailedDocument' => [ 'base' => '<p>Provides information about a document that could not be indexed.</p>', 'refs' => [ 'BatchPutDocumentResponseFailedDocuments$member' => NULL, ], ], 'BatchPutDocumentResponseFailedDocuments' => [ 'base' => NULL, 'refs' => [ 'BatchPutDocumentResponse$FailedDocuments' => '<p>A list of documents that were not added to the index because the document failed a validation check. Each document contains an error message that indicates why the document couldn\'t be added to the index.</p> <p>If there was an error adding a document to an index the error is reported in your Amazon Web Services CloudWatch log. For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/cloudwatch-logs.html">Monitoring Amazon Kendra with Amazon CloudWatch Logs</a> </p>', ], ], 'Blob' => [ 'base' => NULL, 'refs' => [ 'Document$Blob' => '<p>The contents of the document. </p> <p>Documents passed to the <code>Blob</code> parameter must be base64 encoded. Your code might not need to encode the document file bytes if you\'re using an Amazon Web Services SDK to call Amazon Kendra operations. If you are calling the Amazon Kendra endpoint directly using REST, you must base64 encode the contents before sending.</p>', ], ], 'Boolean' => [ 'base' => NULL, 'refs' => [ 'ConfluenceAttachmentConfiguration$CrawlAttachments' => '<p>Indicates whether Amazon Kendra indexes attachments to the pages and blogs in the Confluence data source. </p>', 'ConfluenceSpaceConfiguration$CrawlPersonalSpaces' => '<p>Specifies whether Amazon Kendra should index personal spaces. Users can add restrictions to items in personal spaces. If personal spaces are indexed, queries without user context information may return restricted items from a personal space in their results. For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/user-context-filter.html">Filtering on user context</a>.</p>', 'ConfluenceSpaceConfiguration$CrawlArchivedSpaces' => '<p>Specifies whether Amazon Kendra should index archived spaces.</p>', 'Highlight$TopAnswer' => '<p>Indicates whether the response is the best response. True if this is the best response; otherwise, false.</p>', 'OneDriveConfiguration$DisableLocalGroups' => '<p>A Boolean value that specifies whether local groups are disabled (<code>True</code>) or enabled (<code>False</code>). </p>', 'SalesforceConfiguration$CrawlAttachments' => '<p>Indicates whether Amazon Kendra should index attachments to Salesforce objects.</p>', 'Search$Facetable' => '<p>Indicates that the field can be used to create search facets, a count of results for each value in the field. The default is <code>false</code> .</p>', 'Search$Searchable' => '<p>Determines whether the field is used in the search. If the <code>Searchable</code> field is <code>true</code>, you can use relevance tuning to manually tune how Amazon Kendra weights the field in the search. The default is <code>true</code> for string fields and <code>false</code> for number and date fields.</p>', 'Search$Displayable' => '<p>Determines whether the field is returned in the query response. The default is <code>true</code>.</p>', 'Search$Sortable' => '<p>Determines whether the field can be used to sort the results of a query. If you specify sorting on a field that does not have <code>Sortable</code> set to <code>true</code>, Amazon Kendra returns an exception. The default is <code>false</code>.</p>', 'ServiceNowKnowledgeArticleConfiguration$CrawlAttachments' => '<p>Indicates whether Amazon Kendra should index attachments to knowledge articles.</p>', 'ServiceNowServiceCatalogConfiguration$CrawlAttachments' => '<p>Indicates whether Amazon Kendra should crawl attachments to the service catalog items. </p>', 'SharePointConfiguration$CrawlAttachments' => '<p> <code>TRUE</code> to include attachments to documents stored in your Microsoft SharePoint site in the index; otherwise, <code>FALSE</code>.</p>', 'SharePointConfiguration$UseChangeLog' => '<p>Set to <code>TRUE</code> to use the Microsoft SharePoint change log to determine the documents that need to be updated in the index. Depending on the size of the SharePoint change log, it may take longer for Amazon Kendra to use the change log than it takes it to determine the changed documents using the Amazon Kendra document crawler.</p>', 'SharePointConfiguration$DisableLocalGroups' => '<p>A Boolean value that specifies whether local groups are disabled (<code>True</code>) or enabled (<code>False</code>). </p>', 'WorkDocsConfiguration$CrawlComments' => '<p> <code>TRUE</code> to include comments on documents in your index. Including comments in your index means each comment is a document that can be searched on.</p> <p>The default is set to <code>FALSE</code>.</p>', 'WorkDocsConfiguration$UseChangeLog' => '<p> <code>TRUE</code> to use the change logs to update documents in your index instead of scanning all documents.</p> <p>If you are syncing your Amazon WorkDocs data source with your index for the first time, all documents are scanned. After your first sync, you can use the change logs to update your documents in your index for future syncs.</p> <p>The default is set to <code>FALSE</code>.</p>', ], ], 'CapacityUnitsConfiguration' => [ 'base' => '<p>Specifies capacity units configured for your enterprise edition index. You can add and remove capacity units to tune an index to your requirements.</p>', 'refs' => [ 'DescribeIndexResponse$CapacityUnits' => '<p>For Enterprise edition indexes, you can choose to use additional capacity to meet the needs of your application. This contains the capacity units used for the index. A 0 for the query capacity or the storage capacity indicates that the index is using the default capacity for the index.</p>', 'UpdateIndexRequest$CapacityUnits' => '<p>Sets the number of additional storage and query capacity units that should be used by the index. You can change the capacity of the index up to 5 times per day.</p> <p>If you are using extra storage units, you can\'t reduce the storage capacity below that required to meet the storage needs for your index.</p>', ], ], 'ChangeDetectingColumns' => [ 'base' => NULL, 'refs' => [ 'ColumnConfiguration$ChangeDetectingColumns' => '<p>One to five columns that indicate when a document in the database has changed.</p>', ], ], 'ClaimRegex' => [ 'base' => NULL, 'refs' => [ 'JwtTokenTypeConfiguration$ClaimRegex' => '<p>The regular expression that identifies the claim.</p>', ], ], 'ClearQuerySuggestionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ClickFeedback' => [ 'base' => '<p>Gathers information about when a particular result was clicked by a user. Your application uses the <code>SubmitFeedback</code> operation to provide click information.</p>', 'refs' => [ 'ClickFeedbackList$member' => NULL, ], ], 'ClickFeedbackList' => [ 'base' => NULL, 'refs' => [ 'SubmitFeedbackRequest$ClickFeedbackItems' => '<p>Tells Amazon Kendra that a particular search result link was chosen by the user. </p>', ], ], 'ClientTokenName' => [ 'base' => NULL, 'refs' => [ 'CreateDataSourceRequest$ClientToken' => '<p>A token that you provide to identify the request to create a data source. Multiple calls to the <code>CreateDataSource</code> operation with the same client token will create only one data source.</p>', 'CreateFaqRequest$ClientToken' => '<p>A token that you provide to identify the request to create a FAQ. Multiple calls to the <code>CreateFaqRequest</code> operation with the same client token will create only one FAQ. </p>', 'CreateIndexRequest$ClientToken' => '<p>A token that you provide to identify the request to create an index. Multiple calls to the <code>CreateIndex</code> operation with the same client token will create only one index.</p>', 'CreateQuerySuggestionsBlockListRequest$ClientToken' => '<p>A token that you provide to identify the request to create a query suggestions block list.</p>', 'CreateThesaurusRequest$ClientToken' => '<p>A token that you provide to identify the request to create a thesaurus. Multiple calls to the <code>CreateThesaurus</code> operation with the same client token will create only one index. </p>', ], ], 'ColumnConfiguration' => [ 'base' => '<p>Provides information about how Amazon Kendra should use the columns of a database in an index.</p>', 'refs' => [ 'DatabaseConfiguration$ColumnConfiguration' => '<p>Information about where the index should get the document information from the database.</p>', ], ], 'ColumnName' => [ 'base' => NULL, 'refs' => [ 'AclConfiguration$AllowedGroupsColumnName' => '<p>A list of groups, separated by semi-colons, that filters a query response based on user context. The document is only returned to users that are in one of the groups specified in the <code>UserContext</code> field of the <code>Query</code> operation.</p>', 'ChangeDetectingColumns$member' => NULL, 'ColumnConfiguration$DocumentIdColumnName' => '<p>The column that provides the document\'s unique identifier.</p>', 'ColumnConfiguration$DocumentDataColumnName' => '<p>The column that contains the contents of the document.</p>', 'ColumnConfiguration$DocumentTitleColumnName' => '<p>The column that contains the title of the document.</p>', ], ], 'ConflictException' => [ 'base' => '<p/>', 'refs' => [], ], 'ConfluenceAttachmentConfiguration' => [ 'base' => '<p>Specifies the attachment settings for the Confluence data source. Attachment settings are optional, if you don\'t specify settings attachments, Amazon Kendra won\'t index them.</p>', 'refs' => [ 'ConfluenceConfiguration$AttachmentConfiguration' => '<p>Specifies configuration information for indexing attachments to Confluence blogs and pages.</p>', ], ], 'ConfluenceAttachmentFieldMappingsList' => [ 'base' => NULL, 'refs' => [ 'ConfluenceAttachmentConfiguration$AttachmentFieldMappings' => '<p>Defines how attachment metadata fields should be mapped to index fields. Before you can map a field, you must first create an index field with a matching type using the console or the <code>UpdateIndex</code> operation.</p> <p>If you specify the <code>AttachentFieldMappings</code> parameter, you must specify at least one field mapping.</p>', ], ], 'ConfluenceAttachmentFieldName' => [ 'base' => NULL, 'refs' => [ 'ConfluenceAttachmentToIndexFieldMapping$DataSourceFieldName' => '<p>The name of the field in the data source. </p> <p>You must first create the index field using the <code>UpdateIndex</code> operation. </p>', ], ], 'ConfluenceAttachmentToIndexFieldMapping' => [ 'base' => '<p>Defines the mapping between a field in the Confluence data source to a Amazon Kendra index field.</p> <p>You must first create the index field using the <code>UpdateIndex</code> operation. </p>', 'refs' => [ 'ConfluenceAttachmentFieldMappingsList$member' => NULL, ], ], 'ConfluenceBlogConfiguration' => [ 'base' => '<p>Specifies the blog settings for the Confluence data source. Blogs are always indexed unless filtered from the index by the <code>ExclusionPatterns</code> or <code>InclusionPatterns</code> fields in the <code>ConfluenceConfiguration</code> type.</p>', 'refs' => [ 'ConfluenceConfiguration$BlogConfiguration' => '<p> Specifies configuration information for indexing Confluence blogs.</p>', ], ], 'ConfluenceBlogFieldMappingsList' => [ 'base' => NULL, 'refs' => [ 'ConfluenceBlogConfiguration$BlogFieldMappings' => '<p>Defines how blog metadata fields should be mapped to index fields. Before you can map a field, you must first create an index field with a matching type using the console or the <code>UpdateIndex</code> operation.</p> <p>If you specify the <code>BlogFieldMappings</code> parameter, you must specify at least one field mapping.</p>', ], ], 'ConfluenceBlogFieldName' => [ 'base' => NULL, 'refs' => [ 'ConfluenceBlogToIndexFieldMapping$DataSourceFieldName' => '<p>The name of the field in the data source. </p>', ], ], 'ConfluenceBlogToIndexFieldMapping' => [ 'base' => '<p>Defines the mapping between a blog field in the Confluence data source to a Amazon Kendra index field.</p> <p>You must first create the index field using the <code>UpdateIndex</code> operation. </p>', 'refs' => [ 'ConfluenceBlogFieldMappingsList$member' => NULL, ], ], 'ConfluenceConfiguration' => [ 'base' => '<p>Provides configuration information for data sources that connect to Confluence.</p>', 'refs' => [ 'DataSourceConfiguration$ConfluenceConfiguration' => '<p>Provides configuration information for connecting to a Confluence data source.</p>', ], ], 'ConfluencePageConfiguration' => [ 'base' => '<p>Specifies the page settings for the Confluence data source.</p>', 'refs' => [ 'ConfluenceConfiguration$PageConfiguration' => '<p>Specifies configuration information for indexing Confluence pages.</p>', ], ], 'ConfluencePageFieldMappingsList' => [ 'base' => NULL, 'refs' => [ 'ConfluencePageConfiguration$PageFieldMappings' => '<p>Defines how page metadata fields should be mapped to index fields. Before you can map a field, you must first create an index field with a matching type using the console or the <code>UpdateIndex</code> operation.</p> <p>If you specify the <code>PageFieldMappings</code> parameter, you must specify at least one field mapping.</p>', ], ], 'ConfluencePageFieldName' => [ 'base' => NULL, 'refs' => [ 'ConfluencePageToIndexFieldMapping$DataSourceFieldName' => '<p>The name of the field in the data source. </p>', ], ], 'ConfluencePageToIndexFieldMapping' => [ 'base' => '<p>Defines the mapping between a field in the Confluence data source to a Amazon Kendra index field.</p> <p>You must first create the index field using the <code>UpdateIndex</code> operation. </p>', 'refs' => [ 'ConfluencePageFieldMappingsList$member' => NULL, ], ], 'ConfluenceSpaceConfiguration' => [ 'base' => '<p>Specifies the configuration for indexing Confluence spaces.</p>', 'refs' => [ 'ConfluenceConfiguration$SpaceConfiguration' => '<p>Specifies configuration information for indexing Confluence spaces.</p>', ], ], 'ConfluenceSpaceFieldMappingsList' => [ 'base' => NULL, 'refs' => [ 'ConfluenceSpaceConfiguration$SpaceFieldMappings' => '<p>Defines how space metadata fields should be mapped to index fields. Before you can map a field, you must first create an index field with a matching type using the console or the <code>UpdateIndex</code> operation.</p> <p>If you specify the <code>SpaceFieldMappings</code> parameter, you must specify at least one field mapping.</p>', ], ], 'ConfluenceSpaceFieldName' => [ 'base' => NULL, 'refs' => [ 'ConfluenceSpaceToIndexFieldMapping$DataSourceFieldName' => '<p>The name of the field in the data source. </p>', ], ], 'ConfluenceSpaceIdentifier' => [ 'base' => NULL, 'refs' => [ 'ConfluenceSpaceList$member' => NULL, ], ], 'ConfluenceSpaceList' => [ 'base' => NULL, 'refs' => [ 'ConfluenceSpaceConfiguration$IncludeSpaces' => '<p>A list of space keys for Confluence spaces. If you include a key, the blogs, documents, and attachments in the space are indexed. Spaces that aren\'t in the list aren\'t indexed. A space in the list must exist. Otherwise, Amazon Kendra logs an error when the data source is synchronized. If a space is in both the <code>IncludeSpaces</code> and the <code>ExcludeSpaces</code> list, the space is excluded.</p>', 'ConfluenceSpaceConfiguration$ExcludeSpaces' => '<p>A list of space keys of Confluence spaces. If you include a key, the blogs, documents, and attachments in the space are not indexed. If a space is in both the <code>ExcludeSpaces</code> and the <code>IncludeSpaces</code> list, the space is excluded.</p>', ], ], 'ConfluenceSpaceToIndexFieldMapping' => [ 'base' => '<p>Defines the mapping between a field in the Confluence data source to a Amazon Kendra index field.</p> <p>You must first create the index field using the <code>UpdateIndex</code> operation. </p>', 'refs' => [ 'ConfluenceSpaceFieldMappingsList$member' => NULL, ], ], 'ConfluenceVersion' => [ 'base' => NULL, 'refs' => [ 'ConfluenceConfiguration$Version' => '<p>Specifies the version of the Confluence installation that you are connecting to.</p>', ], ], 'ConnectionConfiguration' => [ 'base' => '<p>Provides the information necessary to connect to a database.</p>', 'refs' => [ 'DatabaseConfiguration$ConnectionConfiguration' => '<p>The information necessary to connect to a database.</p>', ], ], 'ContentType' => [ 'base' => NULL, 'refs' => [ 'Document$ContentType' => '<p>The file type of the document in the <code>Blob</code> field.</p>', ], ], 'CrawlDepth' => [ 'base' => NULL, 'refs' => [ 'WebCrawlerConfiguration$CrawlDepth' => '<p>Specifies the number of levels in a website that you want to crawl.</p> <p>The first level begins from the website seed or starting point URL. For example, if a website has 3 levels – index level (i.e. seed in this example), sections level, and subsections level – and you are only interested in crawling information up to the sections level (i.e. levels 0-1), you can set your depth to 1.</p> <p>The default crawl depth is set to 2.</p>', ], ], 'CreateDataSourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateDataSourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateFaqRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateFaqResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateIndexRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateIndexResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateQuerySuggestionsBlockListRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateQuerySuggestionsBlockListResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateThesaurusRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateThesaurusResponse' => [ 'base' => NULL, 'refs' => [], ], 'DataSourceConfiguration' => [ 'base' => '<p>Configuration information for a Amazon Kendra data source.</p>', 'refs' => [ 'CreateDataSourceRequest$Configuration' => '<p>The connector configuration information that is required to access the repository.</p> <p>You can\'t specify the <code>Configuration</code> parameter when the <code>Type</code> parameter is set to <code>CUSTOM</code>. If you do, you receive a <code>ValidationException</code> exception.</p> <p>The <code>Configuration</code> parameter is required for all other data sources.</p>', 'DescribeDataSourceResponse$Configuration' => '<p>Information that describes where the data source is located and how the data source is configured. The specific information in the description depends on the data source provider.</p>', 'UpdateDataSourceRequest$Configuration' => NULL, ], ], 'DataSourceDateFieldFormat' => [ 'base' => NULL, 'refs' => [ 'ConfluenceAttachmentToIndexFieldMapping$DateFieldFormat' => '<p>The format for date fields in the data source. If the field specified in <code>DataSourceFieldName</code> is a date field you must specify the date format. If the field is not a date field, an exception is thrown.</p>', 'ConfluenceBlogToIndexFieldMapping$DateFieldFormat' => '<p>The format for date fields in the data source. If the field specified in <code>DataSourceFieldName</code> is a date field you must specify the date format. If the field is not a date field, an exception is thrown.</p>', 'ConfluencePageToIndexFieldMapping$DateFieldFormat' => '<p>The format for date fields in the data source. If the field specified in <code>DataSourceFieldName</code> is a date field you must specify the date format. If the field is not a date field, an exception is thrown.</p>', 'ConfluenceSpaceToIndexFieldMapping$DateFieldFormat' => '<p>The format for date fields in the data source. If the field specified in <code>DataSourceFieldName</code> is a date field you must specify the date format. If the field is not a date field, an exception is thrown.</p>', 'DataSourceToIndexFieldMapping$DateFieldFormat' => '<p>The type of data stored in the column or attribute.</p>', ], ], 'DataSourceFieldName' => [ 'base' => NULL, 'refs' => [ 'DataSourceToIndexFieldMapping$DataSourceFieldName' => '<p>The name of the column or attribute in the data source.</p>', 'SalesforceChatterFeedConfiguration$DocumentDataFieldName' => '<p>The name of the column in the Salesforce FeedItem table that contains the content to index. Typically this is the <code>Body</code> column.</p>', 'SalesforceChatterFeedConfiguration$DocumentTitleFieldName' => '<p>The name of the column in the Salesforce FeedItem table that contains the title of the document. This is typically the <code>Title</code> column.</p>', 'SalesforceCustomKnowledgeArticleTypeConfiguration$DocumentDataFieldName' => '<p>The name of the field in the custom knowledge article that contains the document data to index.</p>', 'SalesforceCustomKnowledgeArticleTypeConfiguration$DocumentTitleFieldName' => '<p>The name of the field in the custom knowledge article that contains the document title.</p>', 'SalesforceStandardKnowledgeArticleTypeConfiguration$DocumentDataFieldName' => '<p>The name of the field that contains the document data to index.</p>', 'SalesforceStandardKnowledgeArticleTypeConfiguration$DocumentTitleFieldName' => '<p>The name of the field that contains the document title.</p>', 'SalesforceStandardObjectAttachmentConfiguration$DocumentTitleFieldName' => '<p>The name of the field used for the document title.</p>', 'SalesforceStandardObjectConfiguration$DocumentDataFieldName' => '<p>The name of the field in the standard object table that contains the document contents.</p>', 'SalesforceStandardObjectConfiguration$DocumentTitleFieldName' => '<p>The name of the field in the standard object table that contains the document title.</p>', 'ServiceNowKnowledgeArticleConfiguration$DocumentDataFieldName' => '<p>The name of the ServiceNow field that is mapped to the index document contents field in the Amazon Kendra index.</p>', 'ServiceNowKnowledgeArticleConfiguration$DocumentTitleFieldName' => '<p>The name of the ServiceNow field that is mapped to the index document title field.</p>', 'ServiceNowServiceCatalogConfiguration$DocumentDataFieldName' => '<p>The name of the ServiceNow field that is mapped to the index document contents field in the Amazon Kendra index.</p>', 'ServiceNowServiceCatalogConfiguration$DocumentTitleFieldName' => '<p>The name of the ServiceNow field that is mapped to the index document title field.</p>', 'SharePointConfiguration$DocumentTitleFieldName' => '<p>The Microsoft SharePoint attribute field that contains the title of the document.</p>', ], ], 'DataSourceGroup' => [ 'base' => '<p> Data source information for user context filtering. </p>', 'refs' => [ 'DataSourceGroups$member' => NULL, ], ], 'DataSourceGroups' => [ 'base' => NULL, 'refs' => [ 'UserContext$DataSourceGroups' => '<p>The list of data source groups you want to filter search results based on groups\' access to documents in that data source.</p>', ], ], 'DataSourceId' => [ 'base' => NULL, 'refs' => [ 'CreateDataSourceResponse$Id' => '<p>A unique identifier for the data source.</p>', 'DataSourceGroup$DataSourceId' => '<p>The identifier of the data source group you want to add to your list of data source groups. This is for filtering search results based on the groups\' access to documents in that data source.</p>', 'DataSourceSummary$Id' => '<p>The unique identifier for the data source.</p>', 'DataSourceSyncJobMetricTarget$DataSourceId' => '<p>The ID of the data source that is running the sync job.</p>', 'DeleteDataSourceRequest$Id' => '<p>The unique identifier of the data source to delete.</p>', 'DeletePrincipalMappingRequest$DataSourceId' => '<p>The identifier of the data source you want to delete a group from.</p> <p>This is useful if a group is tied to multiple data sources and you want to delete a group from accessing documents in a certain data source. For example, the groups "Research", "Engineering", and "Sales and Marketing" are all tied to the company\'s documents stored in the data sources Confluence and Salesforce. You want to delete "Research" and "Engineering" groups from Salesforce, so that these groups cannot access customer-related documents stored in Salesforce. Only "Sales and Marketing" should access documents in the Salesforce data source.</p>', 'DescribeDataSourceRequest$Id' => '<p>The unique identifier of the data source to describe.</p>', 'DescribeDataSourceResponse$Id' => '<p>The identifier of the data source.</p>', 'DescribePrincipalMappingRequest$DataSourceId' => '<p>The identifier of the data source to check the processing of <code>PUT</code> and <code>DELETE</code> actions for mapping users to their groups.</p>', 'DescribePrincipalMappingResponse$DataSourceId' => '<p>Shows the identifier of the data source to see information on the processing of <code>PUT</code> and <code>DELETE</code> actions for mapping users to their groups.</p>', 'ListDataSourceSyncJobsRequest$Id' => '<p>The identifier of the data source.</p>', 'ListGroupsOlderThanOrderingIdRequest$DataSourceId' => '<p>The identifier of the data source for getting a list of groups mapped to users before a given ordering timestamp identifier.</p>', 'MemberGroup$DataSourceId' => '<p>The identifier of the data source for the sub group you want to map to a group.</p>', 'Principal$DataSourceId' => '<p>The identifier of the data source the principal should access documents from.</p>', 'PutPrincipalMappingRequest$DataSourceId' => '<p>The identifier of the data source you want to map users to their groups.</p> <p>This is useful if a group is tied to multiple data sources, but you only want the group to access documents of a certain data source. For example, the groups "Research", "Engineering", and "Sales and Marketing" are all tied to the company\'s documents stored in the data sources Confluence and Salesforce. However, "Sales and Marketing" team only needs access to customer-related documents stored in Salesforce.</p>', 'StartDataSourceSyncJobRequest$Id' => '<p>The identifier of the data source to synchronize.</p>', 'StopDataSourceSyncJobRequest$Id' => '<p>The identifier of the data source for which to stop the synchronization jobs.</p>', 'UpdateDataSourceRequest$Id' => '<p>The unique identifier of the data source to update.</p>', ], ], 'DataSourceInclusionsExclusionsStrings' => [ 'base' => NULL, 'refs' => [ 'ConfluenceConfiguration$InclusionPatterns' => '<p>A list of regular expression patterns that apply to a URL on the Confluence server. An inclusion pattern can apply to a blog post, a page, a space, or an attachment. Items that match the patterns are included in the index. Items that don\'t match the pattern are excluded from the index. If an item matches both an inclusion pattern and an exclusion pattern, the item isn\'t included in the index.</p>', 'ConfluenceConfiguration$ExclusionPatterns' => '<p>A list of regular expression patterns that apply to a URL on the Confluence server. An exclusion pattern can apply to a blog post, a page, a space, or an attachment. Items that match the pattern are excluded from the index. Items that don\'t match the pattern are included in the index. If a item matches both an exclusion pattern and an inclusion pattern, the item isn\'t included in the index.</p>', 'GoogleDriveConfiguration$InclusionPatterns' => '<p>A list of regular expression patterns that apply to path on Google Drive. Items that match the pattern are included in the index from both shared drives and users\' My Drives. Items that don\'t match the pattern are excluded from the index. If an item matches both an inclusion pattern and an exclusion pattern, it is excluded from the index.</p>', 'GoogleDriveConfiguration$ExclusionPatterns' => '<p>A list of regular expression patterns that apply to the path on Google Drive. Items that match the pattern are excluded from the index from both shared drives and users\' My Drives. Items that don\'t match the pattern are included in the index. If an item matches both an exclusion pattern and an inclusion pattern, it is excluded from the index.</p>', 'OneDriveConfiguration$InclusionPatterns' => '<p>A list of regular expression patterns. Documents that match the pattern are included in the index. Documents that don\'t match the pattern are excluded from the index. If a document matches both an inclusion pattern and an exclusion pattern, the document is not included in the index. </p> <p>The exclusion pattern is applied to the file name.</p>', 'OneDriveConfiguration$ExclusionPatterns' => '<p>List of regular expressions applied to documents. Items that match the exclusion pattern are not indexed. If you provide both an inclusion pattern and an exclusion pattern, any item that matches the exclusion pattern isn\'t indexed. </p> <p>The exclusion pattern is applied to the file name.</p>', 'S3DataSourceConfiguration$InclusionPrefixes' => '<p>A list of S3 prefixes for the documents that should be included in the index.</p>', 'S3DataSourceConfiguration$InclusionPatterns' => '<p>A list of glob patterns for documents that should be indexed. If a document that matches an inclusion pattern also matches an exclusion pattern, the document is not indexed.</p> <p>Some <a href="https://docs.aws.amazon.com/cli/latest/reference/s3/#use-of-exclude-and-include-filters">examples</a> are:</p> <ul> <li> <p> <i>*.txt</i> will include all text files in a directory (files with the extension .txt).</p> </li> <li> <p> <i>**/*.txt</i> will include all text files in a directory and its subdirectories.</p> </li> <li> <p> <i>*tax*</i> will include all files in a directory that contain \'tax\' in the file name, such as \'tax\', \'taxes\', \'income_tax\'.</p> </li> </ul>', 'S3DataSourceConfiguration$ExclusionPatterns' => '<p>A list of glob patterns for documents that should not be indexed. If a document that matches an inclusion prefix or inclusion pattern also matches an exclusion pattern, the document is not indexed.</p> <p>Some <a href="https://docs.aws.amazon.com/cli/latest/reference/s3/#use-of-exclude-and-include-filters">examples</a> are:</p> <ul> <li> <p> <i>*.png , *.jpg</i> will exclude all PNG and JPEG image files in a directory (files with the extensions .png and .jpg).</p> </li> <li> <p> <i>*internal*</i> will exclude all files in a directory that contain \'internal\' in the file name, such as \'internal\', \'internal_only\', \'company_internal\'.</p> </li> <li> <p> <i>**/*internal*</i> will exclude all internal-related files in a directory and its subdirectories.</p> </li> </ul>', 'SalesforceConfiguration$IncludeAttachmentFilePatterns' => '<p>A list of regular expression patterns. Documents that match the patterns are included in the index. Documents that don\'t match the patterns are excluded from the index. If a document matches both an inclusion pattern and an exclusion pattern, the document is not included in the index.</p> <p>The regex is applied to the name of the attached file.</p>', 'SalesforceConfiguration$ExcludeAttachmentFilePatterns' => '<p>A list of regular expression patterns. Documents that match the patterns are excluded from the index. Documents that don\'t match the patterns are included in the index. If a document matches both an exclusion pattern and an inclusion pattern, the document is not included in the index.</p> <p>The regex is applied to the name of the attached file.</p>', 'ServiceNowKnowledgeArticleConfiguration$IncludeAttachmentFilePatterns' => '<p>List of regular expressions applied to knowledge articles. Items that don\'t match the inclusion pattern are not indexed. The regex is applied to the field specified in the <code>PatternTargetField</code>.</p>', 'ServiceNowKnowledgeArticleConfiguration$ExcludeAttachmentFilePatterns' => '<p>List of regular expressions applied to knowledge articles. Items that don\'t match the inclusion pattern are not indexed. The regex is applied to the field specified in the <code>PatternTargetField</code> </p>', 'ServiceNowServiceCatalogConfiguration$IncludeAttachmentFilePatterns' => '<p>A list of regular expression patterns. Documents that match the patterns are included in the index. Documents that don\'t match the patterns are excluded from the index. If a document matches both an exclusion pattern and an inclusion pattern, the document is not included in the index.</p> <p>The regex is applied to the file name of the attachment.</p>', 'ServiceNowServiceCatalogConfiguration$ExcludeAttachmentFilePatterns' => '<p>A list of regular expression patterns. Documents that match the patterns are excluded from the index. Documents that don\'t match the patterns are included in the index. If a document matches both an exclusion pattern and an inclusion pattern, the document is not included in the index.</p> <p>The regex is applied to the file name of the attachment.</p>', 'SharePointConfiguration$InclusionPatterns' => '<p>A list of regular expression patterns. Documents that match the patterns are included in the index. Documents that don\'t match the patterns are excluded from the index. If a document matches both an inclusion pattern and an exclusion pattern, the document is not included in the index.</p> <p>The regex is applied to the display URL of the SharePoint document.</p>', 'SharePointConfiguration$ExclusionPatterns' => '<p>A list of regular expression patterns. Documents that match the patterns are excluded from the index. Documents that don\'t match the patterns are included in the index. If a document matches both an exclusion pattern and an inclusion pattern, the document is not included in the index.</p> <p>The regex is applied to the display URL of the SharePoint document.</p>', 'WebCrawlerConfiguration$UrlInclusionPatterns' => '<p>The regular expression pattern to include certain URLs to crawl.</p> <p>If there is a regular expression pattern to exclude certain URLs that conflicts with the include pattern, the exclude pattern takes precedence.</p>', 'WebCrawlerConfiguration$UrlExclusionPatterns' => '<p>The regular expression pattern to exclude certain URLs to crawl.</p> <p>If there is a regular expression pattern to include certain URLs that conflicts with the exclude pattern, the exclude pattern takes precedence.</p>', 'WorkDocsConfiguration$InclusionPatterns' => '<p>A list of regular expression patterns to include certain files in your Amazon WorkDocs site repository. Files that match the patterns are included in the index. Files that don\'t match the patterns are excluded from the index. If a file matches both an inclusion pattern and an exclusion pattern, the exclusion pattern takes precedence and the file isn’t included in the index.</p>', 'WorkDocsConfiguration$ExclusionPatterns' => '<p>A list of regular expression patterns to exclude certain files in your Amazon WorkDocs site repository. Files that match the patterns are excluded from the index. Files that don’t match the patterns are included in the index. If a file matches both an inclusion pattern and an exclusion pattern, the exclusion pattern takes precedence and the file isn’t included in the index.</p>', ], ], 'DataSourceInclusionsExclusionsStringsMember' => [ 'base' => NULL, 'refs' => [ 'DataSourceInclusionsExclusionsStrings$member' => NULL, ], ], 'DataSourceName' => [ 'base' => NULL, 'refs' => [ 'CreateDataSourceRequest$Name' => '<p>A unique name for the data source. A data source name can\'t be changed without deleting and recreating the data source.</p>', 'DataSourceSummary$Name' => '<p>The name of the data source.</p>', 'DescribeDataSourceResponse$Name' => '<p>The name that you gave the data source when it was created.</p>', 'UpdateDataSourceRequest$Name' => '<p>The name of the data source to update. The name of the data source can\'t be updated. To rename a data source you must delete the data source and re-create it.</p>', ], ], 'DataSourceStatus' => [ 'base' => NULL, 'refs' => [ 'DataSourceSummary$Status' => '<p>The status of the data source. When the status is <code>ACTIVE</code> the data source is ready to use.</p>', 'DescribeDataSourceResponse$Status' => '<p>The current status of the data source. When the status is <code>ACTIVE</code> the data source is ready to use. When the status is <code>FAILED</code>, the <code>ErrorMessage</code> field contains the reason that the data source failed.</p>', ], ], 'DataSourceSummary' => [ 'base' => '<p>Summary information for a Amazon Kendra data source. Returned in a call to the <code>DescribeDataSource</code> operation.</p>', 'refs' => [ 'DataSourceSummaryList$member' => NULL, ], ], 'DataSourceSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListDataSourcesResponse$SummaryItems' => '<p>An array of summary information for one or more data sources.</p>', ], ], 'DataSourceSyncJob' => [ 'base' => '<p>Provides information about a synchronization job.</p>', 'refs' => [ 'DataSourceSyncJobHistoryList$member' => NULL, ], ], 'DataSourceSyncJobHistoryList' => [ 'base' => NULL, 'refs' => [ 'ListDataSourceSyncJobsResponse$History' => '<p>A history of synchronization jobs for the data source.</p>', ], ], 'DataSourceSyncJobId' => [ 'base' => NULL, 'refs' => [ 'DataSourceSyncJobMetricTarget$DataSourceSyncJobId' => '<p>The ID of the sync job that is running on the data source.</p> <p>If the ID of a sync job is not provided and there is a sync job running, then the ID of this sync job is used and metrics are generated for this sync job.</p> <p>If the ID of a sync job is not provided and there is no sync job running, then no metrics are generated and documents are indexed/deleted at the index level without sync job metrics included.</p>', ], ], 'DataSourceSyncJobMetricTarget' => [ 'base' => '<p>Maps a particular data source sync job to a particular data source.</p>', 'refs' => [ 'BatchDeleteDocumentRequest$DataSourceSyncJobMetricTarget' => NULL, ], ], 'DataSourceSyncJobMetrics' => [ 'base' => '<p>Maps a batch delete document request to a specific data source sync job. This is optional and should only be supplied when documents are deleted by a data source connector.</p>', 'refs' => [ 'DataSourceSyncJob$Metrics' => '<p>Maps a batch delete document request to a specific data source sync job. This is optional and should only be supplied when documents are deleted by a data source connector.</p>', ], ], 'DataSourceSyncJobStatus' => [ 'base' => NULL, 'refs' => [ 'DataSourceSyncJob$Status' => '<p>The execution status of the synchronization job. When the <code>Status</code> field is set to <code>SUCCEEDED</code>, the synchronization job is done. If the status code is set to <code>FAILED</code>, the <code>ErrorCode</code> and <code>ErrorMessage</code> fields give you the reason for the failure.</p>', 'ListDataSourceSyncJobsRequest$StatusFilter' => '<p>When specified, only returns synchronization jobs with the <code>Status</code> field equal to the specified status.</p>', ], ], 'DataSourceToIndexFieldMapping' => [ 'base' => '<p>Maps a column or attribute in the data source to an index field. You must first create the fields in the index using the <code>UpdateIndex</code> operation.</p>', 'refs' => [ 'DataSourceToIndexFieldMappingList$member' => NULL, ], ], 'DataSourceToIndexFieldMappingList' => [ 'base' => NULL, 'refs' => [ 'ColumnConfiguration$FieldMappings' => '<p>An array of objects that map database column names to the corresponding fields in an index. You must first create the fields in the index using the <code>UpdateIndex</code> operation.</p>', 'GoogleDriveConfiguration$FieldMappings' => '<p>Defines mapping between a field in the Google Drive and a Amazon Kendra index field.</p> <p>If you are using the console, you can define index fields when creating the mapping. If you are using the API, you must first create the field using the <code>UpdateIndex</code> operation.</p>', 'OneDriveConfiguration$FieldMappings' => '<p>A list of <code>DataSourceToIndexFieldMapping</code> objects that map Microsoft OneDrive fields to custom fields in the Amazon Kendra index. You must first create the index fields before you map OneDrive fields.</p>', 'SalesforceChatterFeedConfiguration$FieldMappings' => '<p>Maps fields from a Salesforce chatter feed into Amazon Kendra index fields.</p>', 'SalesforceCustomKnowledgeArticleTypeConfiguration$FieldMappings' => '<p>One or more objects that map fields in the custom knowledge article to fields in the Amazon Kendra index.</p>', 'SalesforceStandardKnowledgeArticleTypeConfiguration$FieldMappings' => '<p>One or more objects that map fields in the knowledge article to Amazon Kendra index fields. The index field must exist before you can map a Salesforce field to it.</p>', 'SalesforceStandardObjectAttachmentConfiguration$FieldMappings' => '<p>One or more objects that map fields in attachments to Amazon Kendra index fields.</p>', 'SalesforceStandardObjectConfiguration$FieldMappings' => '<p>One or more objects that map fields in the standard object to Amazon Kendra index fields. The index field must exist before you can map a Salesforce field to it.</p>', 'ServiceNowKnowledgeArticleConfiguration$FieldMappings' => '<p>Mapping between ServiceNow fields and Amazon Kendra index fields. You must create the index field before you map the field.</p>', 'ServiceNowServiceCatalogConfiguration$FieldMappings' => '<p>Mapping between ServiceNow fields and Amazon Kendra index fields. You must create the index field before you map the field.</p>', 'SharePointConfiguration$FieldMappings' => '<p>A list of <code>DataSourceToIndexFieldMapping</code> objects that map Microsoft SharePoint attributes to custom fields in the Amazon Kendra index. You must first create the index fields using the <code>UpdateIndex</code> operation before you map SharePoint attributes. For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping Data Source Fields</a>.</p>', 'WorkDocsConfiguration$FieldMappings' => '<p>A list of <code>DataSourceToIndexFieldMapping</code> objects that map Amazon WorkDocs field names to custom index field names in Amazon Kendra. You must first create the custom index fields using the <code>UpdateIndex</code> operation before you map to Amazon WorkDocs fields. For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping Data Source Fields</a>. The Amazon WorkDocs data source field names need to exist in your Amazon WorkDocs custom metadata.</p>', ], ], 'DataSourceType' => [ 'base' => NULL, 'refs' => [ 'CreateDataSourceRequest$Type' => '<p>The type of repository that contains the data source.</p>', 'DataSourceSummary$Type' => '<p>The type of the data source.</p>', 'DescribeDataSourceResponse$Type' => '<p>The type of the data source.</p>', ], ], 'DataSourceVpcConfiguration' => [ 'base' => '<p>Provides information for connecting to an Amazon VPC.</p>', 'refs' => [ 'ConfluenceConfiguration$VpcConfiguration' => '<p>Specifies the information for connecting to an Amazon VPC.</p>', 'DatabaseConfiguration$VpcConfiguration' => NULL, 'SharePointConfiguration$VpcConfiguration' => NULL, ], ], 'DatabaseConfiguration' => [ 'base' => '<p>Provides the information necessary to connect a database to an index. </p>', 'refs' => [ 'DataSourceConfiguration$DatabaseConfiguration' => '<p>Provides information necessary to create a data source connector for a database.</p>', ], ], 'DatabaseEngineType' => [ 'base' => NULL, 'refs' => [ 'DatabaseConfiguration$DatabaseEngineType' => '<p>The type of database engine that runs the database.</p>', ], ], 'DatabaseHost' => [ 'base' => NULL, 'refs' => [ 'ConnectionConfiguration$DatabaseHost' => '<p>The name of the host for the database. Can be either a string (host.subdomain.domain.tld) or an IPv4 or IPv6 address.</p>', ], ], 'DatabaseName' => [ 'base' => NULL, 'refs' => [ 'ConnectionConfiguration$DatabaseName' => '<p>The name of the database containing the document data.</p>', ], ], 'DatabasePort' => [ 'base' => NULL, 'refs' => [ 'ConnectionConfiguration$DatabasePort' => '<p>The port that the database uses for connections.</p>', ], ], 'DeleteDataSourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteFaqRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteIndexRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeletePrincipalMappingRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteQuerySuggestionsBlockListRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteThesaurusRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeDataSourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeDataSourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeFaqRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeFaqResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeIndexRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeIndexResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribePrincipalMappingRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribePrincipalMappingResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeQuerySuggestionsBlockListRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeQuerySuggestionsBlockListResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeQuerySuggestionsConfigRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeQuerySuggestionsConfigResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeThesaurusRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeThesaurusResponse' => [ 'base' => NULL, 'refs' => [], ], 'Description' => [ 'base' => NULL, 'refs' => [ 'CreateDataSourceRequest$Description' => '<p>A description for the data source.</p>', 'CreateFaqRequest$Description' => '<p>A description of the FAQ.</p>', 'CreateIndexRequest$Description' => '<p>A description for the index.</p>', 'CreateQuerySuggestionsBlockListRequest$Description' => '<p>A user-friendly description for the block list.</p> <p>For example, the description "List of all offensive words that can appear in user queries and need to be blocked from suggestions."</p>', 'CreateThesaurusRequest$Description' => '<p>The description for the new thesaurus.</p>', 'DescribeDataSourceResponse$Description' => '<p>The description of the data source.</p>', 'DescribeFaqResponse$Description' => '<p>The description of the FAQ that you provided when it was created.</p>', 'DescribeIndexResponse$Description' => '<p>The description of the index.</p>', 'DescribeQuerySuggestionsBlockListResponse$Description' => '<p>Shows the description for the block list.</p>', 'DescribeThesaurusResponse$Description' => '<p>The thesaurus description.</p>', 'UpdateDataSourceRequest$Description' => '<p>The new description for the data source.</p>', 'UpdateIndexRequest$Description' => '<p>A new description for the index.</p>', 'UpdateQuerySuggestionsBlockListRequest$Description' => '<p>The description for a block list.</p>', 'UpdateThesaurusRequest$Description' => '<p>The updated description of the thesaurus.</p>', ], ], 'Document' => [ 'base' => '<p>A document in an index.</p>', 'refs' => [ 'DocumentList$member' => NULL, ], ], 'DocumentAttribute' => [ 'base' => '<p>A custom attribute value assigned to a document. </p>', 'refs' => [ 'AttributeFilter$EqualsTo' => '<p>Performs an equals operation on two document attributes.</p>', 'AttributeFilter$ContainsAll' => '<p>Returns true when a document contains all of the specified document attributes. This filter is only applicable to <code>StringListValue</code> metadata.</p>', 'AttributeFilter$ContainsAny' => '<p>Returns true when a document contains any of the specified document attributes. This filter is only applicable to <code>StringListValue</code> metadata.</p>', 'AttributeFilter$GreaterThan' => '<p>Performs a greater than operation on two document attributes. Use with a document attribute of type <code>Integer</code> or <code>Long</code>.</p>', 'AttributeFilter$GreaterThanOrEquals' => '<p>Performs a greater or equals than operation on two document attributes. Use with a document attribute of type <code>Integer</code> or <code>Long</code>.</p>', 'AttributeFilter$LessThan' => '<p>Performs a less than operation on two document attributes. Use with a document attribute of type <code>Integer</code> or <code>Long</code>.</p>', 'AttributeFilter$LessThanOrEquals' => '<p>Performs a less than or equals operation on two document attributes. Use with a document attribute of type <code>Integer</code> or <code>Long</code>.</p>', 'DocumentAttributeList$member' => NULL, ], ], 'DocumentAttributeKey' => [ 'base' => NULL, 'refs' => [ 'DocumentAttribute$Key' => '<p>The identifier for the attribute.</p>', 'DocumentAttributeKeyList$member' => NULL, 'Facet$DocumentAttributeKey' => '<p>The unique key for the document attribute.</p>', 'FacetResult$DocumentAttributeKey' => '<p>The key for the facet values. This is the same as the <code>DocumentAttributeKey</code> provided in the query.</p>', 'SortingConfiguration$DocumentAttributeKey' => '<p>The name of the document attribute used to sort the response. You can use any field that has the <code>Sortable</code> flag set to true.</p> <p>You can also sort by any of the following built-in attributes:</p> <ul> <li> <p>_category</p> </li> <li> <p>_created_at</p> </li> <li> <p>_last_updated_at</p> </li> <li> <p>_version</p> </li> <li> <p>_view_count</p> </li> </ul>', ], ], 'DocumentAttributeKeyList' => [ 'base' => NULL, 'refs' => [ 'QueryRequest$RequestedDocumentAttributes' => '<p>An array of document attributes to include in the response. No other document attributes are included in the response. By default all document attributes are included in the response. </p>', ], ], 'DocumentAttributeList' => [ 'base' => NULL, 'refs' => [ 'Document$Attributes' => '<p>Custom attributes to apply to the document. Use the custom attributes to provide additional information for searching, to provide facets for refining searches, and to provide additional information in the query response.</p>', 'DocumentInfo$Attributes' => '<p>Attributes that identify a specific version of a document to check.</p> <p>The only valid attributes are:</p> <ul> <li> <p>version</p> </li> <li> <p>datasourceId</p> </li> <li> <p>jobExecutionId</p> </li> </ul> <p>The attributes follow these rules:</p> <ul> <li> <p> <code>dataSourceId</code> and <code>jobExecutionId</code> must be used together.</p> </li> <li> <p> <code>version</code> is ignored if <code>dataSourceId</code> and <code>jobExecutionId</code> are not provided.</p> </li> <li> <p>If <code>dataSourceId</code> and <code>jobExecutionId</code> are provided, but <code>version</code> is not, the version defaults to "0".</p> </li> </ul>', 'QueryResultItem$DocumentAttributes' => '<p>An array of document attributes for the document that the query result maps to. For example, the document author (Author) or the source URI (SourceUri) of the document.</p>', ], ], 'DocumentAttributeStringListValue' => [ 'base' => NULL, 'refs' => [ 'DocumentAttributeValue$StringListValue' => '<p>A list of strings. </p>', ], ], 'DocumentAttributeStringValue' => [ 'base' => NULL, 'refs' => [ 'DocumentAttributeValue$StringValue' => '<p>A string, such as "department".</p>', ], ], 'DocumentAttributeValue' => [ 'base' => '<p>The value of a custom document attribute. You can only provide one value for a custom attribute.</p>', 'refs' => [ 'DocumentAttribute$Value' => '<p>The value of the attribute.</p>', 'DocumentAttributeValueCountPair$DocumentAttributeValue' => '<p>The value of the attribute. For example, "HR."</p>', ], ], 'DocumentAttributeValueCountPair' => [ 'base' => '<p>Provides the count of documents that match a particular attribute when doing a faceted search.</p>', 'refs' => [ 'DocumentAttributeValueCountPairList$member' => NULL, ], ], 'DocumentAttributeValueCountPairList' => [ 'base' => NULL, 'refs' => [ 'FacetResult$DocumentAttributeValueCountPairs' => '<p>An array of key/value pairs, where the key is the value of the attribute and the count is the number of documents that share the key value.</p>', ], ], 'DocumentAttributeValueType' => [ 'base' => NULL, 'refs' => [ 'DocumentMetadataConfiguration$Type' => '<p>The data type of the index field. </p>', 'FacetResult$DocumentAttributeValueType' => '<p>The data type of the facet value. This is the same as the type defined for the index field when it was created.</p>', ], ], 'DocumentId' => [ 'base' => NULL, 'refs' => [ 'BatchDeleteDocumentResponseFailedDocument$Id' => '<p>The identifier of the document that couldn\'t be removed from the index.</p>', 'BatchGetDocumentStatusResponseError$DocumentId' => '<p>The unique identifier of the document whose status could not be retrieved.</p>', 'BatchPutDocumentResponseFailedDocument$Id' => '<p>The unique identifier of the document.</p>', 'Document$Id' => '<p>A unique identifier of the document in the index.</p>', 'DocumentIdList$member' => NULL, 'DocumentInfo$DocumentId' => '<p>The unique identifier of the document.</p>', 'QueryResultItem$DocumentId' => '<p>The unique identifier for the document.</p>', 'Status$DocumentId' => '<p>The unique identifier of the document.</p>', ], ], 'DocumentIdList' => [ 'base' => NULL, 'refs' => [ 'BatchDeleteDocumentRequest$DocumentIdList' => '<p>One or more identifiers for documents to delete from the index.</p>', ], ], 'DocumentInfo' => [ 'base' => '<p>Identifies a document for which to retrieve status information</p>', 'refs' => [ 'DocumentInfoList$member' => NULL, ], ], 'DocumentInfoList' => [ 'base' => NULL, 'refs' => [ 'BatchGetDocumentStatusRequest$DocumentInfoList' => '<p>A list of <code>DocumentInfo</code> objects that identify the documents for which to get the status. You identify the documents by their document ID and optional attributes.</p>', ], ], 'DocumentList' => [ 'base' => NULL, 'refs' => [ 'BatchPutDocumentRequest$Documents' => '<p>One or more documents to add to the index.</p> <p>Documents can include custom attributes. For example, \'DataSourceId\' and \'DataSourceSyncJobId\' are custom attributes that provide information on the synchronization of documents running on a data source. Note, \'DataSourceSyncJobId\' could be an optional custom attribute as Amazon Kendra will use the ID of a running sync job.</p> <p>Documents have the following file size limits.</p> <ul> <li> <p>5 MB total size for inline documents</p> </li> <li> <p>50 MB total size for files from an S3 bucket</p> </li> <li> <p>5 MB extracted text for any file</p> </li> </ul> <p>For more information about file size and transaction per second quotas, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/quotas.html">Quotas</a>.</p>', ], ], 'DocumentMetadataBoolean' => [ 'base' => NULL, 'refs' => [ 'Relevance$Freshness' => '<p>Indicates that this field determines how "fresh" a document is. For example, if document 1 was created on November 5, and document 2 was created on October 31, document 1 is "fresher" than document 2. You can only set the <code>Freshness</code> field on one <code>DATE</code> type field. Only applies to <code>DATE</code> fields.</p>', ], ], 'DocumentMetadataConfiguration' => [ 'base' => '<p>Specifies the properties of a custom index field.</p>', 'refs' => [ 'DocumentMetadataConfigurationList$member' => NULL, ], ], 'DocumentMetadataConfigurationList' => [ 'base' => NULL, 'refs' => [ 'DescribeIndexResponse$DocumentMetadataConfigurations' => '<p>Configuration settings for any metadata applied to the documents in the index.</p>', 'UpdateIndexRequest$DocumentMetadataConfigurationUpdates' => '<p>The document metadata to update. </p>', ], ], 'DocumentMetadataConfigurationName' => [ 'base' => NULL, 'refs' => [ 'DocumentMetadataConfiguration$Name' => '<p>The name of the index field.</p>', 'DocumentRelevanceConfiguration$Name' => '<p>The name of the tuning configuration to override document relevance at the index level.</p>', ], ], 'DocumentRelevanceConfiguration' => [ 'base' => '<p>Overrides the document relevance properties of a custom index field.</p>', 'refs' => [ 'DocumentRelevanceOverrideConfigurationList$member' => NULL, ], ], 'DocumentRelevanceOverrideConfigurationList' => [ 'base' => NULL, 'refs' => [ 'QueryRequest$DocumentRelevanceOverrideConfigurations' => '<p>Overrides relevance tuning configurations of fields or attributes set at the index level.</p> <p>If you use this API to override the relevance tuning configured at the index level, but there is no relevance tuning configured at the index level, then Amazon Kendra does not apply any relevance tuning.</p> <p>If there is relevance tuning configured at the index level, but you do not use this API to override any relevance tuning in the index, then Amazon Kendra uses the relevance tuning that is configured at the index level.</p> <p>If there is relevance tuning configured for fields at the index level, but you use this API to override only some of these fields, then for the fields you did not override, the importance is set to 1.</p>', ], ], 'DocumentStatus' => [ 'base' => NULL, 'refs' => [ 'Status$DocumentStatus' => '<p>The current status of a document.</p> <p>If the document was submitted for deletion, the status is <code>NOT_FOUND</code> after the document is deleted.</p>', ], ], 'DocumentStatusList' => [ 'base' => NULL, 'refs' => [ 'BatchGetDocumentStatusResponse$DocumentStatusList' => '<p>The status of documents. The status indicates if the document is waiting to be indexed, is in the process of indexing, has completed indexing, or failed indexing. If a document failed indexing, the status provides the reason why.</p>', ], ], 'DocumentsMetadataConfiguration' => [ 'base' => '<p>Document metadata files that contain information such as the document access control information, source URI, document author, and custom attributes. Each metadata file contains metadata about a single document.</p>', 'refs' => [ 'S3DataSourceConfiguration$DocumentsMetadataConfiguration' => NULL, ], ], 'Duration' => [ 'base' => NULL, 'refs' => [ 'Relevance$Duration' => '<p>Specifies the time period that the boost applies to. For example, to make the boost apply to documents with the field value within the last month, you would use "2628000s". Once the field value is beyond the specified range, the effect of the boost drops off. The higher the importance, the faster the effect drops off. If you don\'t specify a value, the default is 3 months. The value of the field is a numeric string followed by the character "s", for example "86400s" for one day, or "604800s" for one week. </p> <p>Only applies to <code>DATE</code> fields.</p>', ], ], 'ErrorCode' => [ 'base' => NULL, 'refs' => [ 'BatchDeleteDocumentResponseFailedDocument$ErrorCode' => '<p>The error code for why the document couldn\'t be removed from the index.</p>', 'BatchGetDocumentStatusResponseError$ErrorCode' => '<p>Indicates the source of the error.</p>', 'BatchPutDocumentResponseFailedDocument$ErrorCode' => '<p>The type of error that caused the document to fail to be indexed.</p>', 'DataSourceSyncJob$ErrorCode' => '<p>If the <code>Status</code> field is set to <code>FAILED</code>, the <code>ErrorCode</code> field contains a the reason that the synchronization failed.</p>', ], ], 'ErrorMessage' => [ 'base' => NULL, 'refs' => [ 'AccessDeniedException$Message' => NULL, 'BatchDeleteDocumentResponseFailedDocument$ErrorMessage' => '<p>An explanation for why the document couldn\'t be removed from the index.</p>', 'BatchGetDocumentStatusResponseError$ErrorMessage' => '<p>States that the API could not get the status of a document. This could be because the request is not valid or there is a system error.</p>', 'BatchPutDocumentResponseFailedDocument$ErrorMessage' => '<p>A description of the reason why the document could not be indexed.</p>', 'ConflictException$Message' => NULL, 'DataSourceSyncJob$ErrorMessage' => '<p>If the <code>Status</code> field is set to <code>ERROR</code>, the <code>ErrorMessage</code> field contains a description of the error that caused the synchronization to fail.</p>', 'DescribeDataSourceResponse$ErrorMessage' => '<p>When the <code>Status</code> field value is <code>FAILED</code>, the <code>ErrorMessage</code> field contains a description of the error that caused the data source to fail.</p>', 'DescribeFaqResponse$ErrorMessage' => '<p>If the <code>Status</code> field is <code>FAILED</code>, the <code>ErrorMessage</code> field contains the reason why the FAQ failed.</p>', 'DescribeIndexResponse$ErrorMessage' => '<p>When th e<code>Status</code> field value is <code>FAILED</code>, the <code>ErrorMessage</code> field contains a message that explains why.</p>', 'DescribeQuerySuggestionsBlockListResponse$ErrorMessage' => '<p>Shows the error message with details when there are issues in processing the block list.</p>', 'DescribeThesaurusResponse$ErrorMessage' => '<p>When the <code>Status</code> field value is <code>FAILED</code>, the <code>ErrorMessage</code> field provides more information. </p>', 'InternalServerException$Message' => NULL, 'ResourceAlreadyExistException$Message' => NULL, 'ResourceInUseException$Message' => NULL, 'ResourceNotFoundException$Message' => NULL, 'ResourceUnavailableException$Message' => NULL, 'ServiceQuotaExceededException$Message' => NULL, 'ThrottlingException$Message' => NULL, 'ValidationException$Message' => NULL, ], ], 'ExcludeMimeTypesList' => [ 'base' => NULL, 'refs' => [ 'GoogleDriveConfiguration$ExcludeMimeTypes' => '<p>A list of MIME types to exclude from the index. All documents matching the specified MIME type are excluded. </p> <p>For a list of MIME types, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/data-source-google-drive.html">Using a Google Workspace Drive data source</a>.</p>', ], ], 'ExcludeSharedDrivesList' => [ 'base' => NULL, 'refs' => [ 'GoogleDriveConfiguration$ExcludeSharedDrives' => '<p>A list of identifiers or shared drives to exclude from the index. All files and folders stored on the shared drive are excluded.</p>', ], ], 'ExcludeUserAccountsList' => [ 'base' => NULL, 'refs' => [ 'GoogleDriveConfiguration$ExcludeUserAccounts' => '<p>A list of email addresses of the users. Documents owned by these users are excluded from the index. Documents shared with excluded users are indexed unless they are excluded in another way.</p>', ], ], 'Facet' => [ 'base' => '<p>Information about a document attribute</p>', 'refs' => [ 'FacetList$member' => NULL, ], ], 'FacetList' => [ 'base' => NULL, 'refs' => [ 'QueryRequest$Facets' => '<p>An array of documents attributes. Amazon Kendra returns a count for each attribute key specified. You can use this information to help narrow the search for your user.</p>', ], ], 'FacetResult' => [ 'base' => '<p>The facet values for the documents in the response.</p>', 'refs' => [ 'FacetResultList$member' => NULL, ], ], 'FacetResultList' => [ 'base' => NULL, 'refs' => [ 'QueryResult$FacetResults' => '<p>Contains the facet results. A <code>FacetResult</code> contains the counts for each attribute key that was specified in the <code>Facets</code> input parameter.</p>', ], ], 'FailureReason' => [ 'base' => NULL, 'refs' => [ 'GroupOrderingIdSummary$FailureReason' => '<p>The reason an action could not be processed. An action can be a <code>PUT</code> or <code>DELETE</code> action for mapping users to their groups.</p>', ], ], 'FaqFileFormat' => [ 'base' => NULL, 'refs' => [ 'CreateFaqRequest$FileFormat' => '<p>The format of the input file. You can choose between a basic CSV format, a CSV format that includes customs attributes in a header, and a JSON format that includes custom attributes.</p> <p>The format must match the format of the file stored in the S3 bucket identified in the <code>S3Path</code> parameter.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/in-creating-faq.html">Adding questions and answers</a>.</p>', 'DescribeFaqResponse$FileFormat' => '<p>The file format used by the input files for the FAQ.</p>', 'FaqSummary$FileFormat' => '<p>The file type used to create the FAQ. </p>', ], ], 'FaqId' => [ 'base' => NULL, 'refs' => [ 'CreateFaqResponse$Id' => '<p>The unique identifier of the FAQ.</p>', 'DeleteFaqRequest$Id' => '<p>The identifier of the FAQ to remove.</p>', 'DescribeFaqRequest$Id' => '<p>The unique identifier of the FAQ.</p>', 'DescribeFaqResponse$Id' => '<p>The identifier of the FAQ.</p>', 'FaqSummary$Id' => '<p>The unique identifier of the FAQ.</p>', ], ], 'FaqName' => [ 'base' => NULL, 'refs' => [ 'CreateFaqRequest$Name' => '<p>The name that should be associated with the FAQ.</p>', 'DescribeFaqResponse$Name' => '<p>The name that you gave the FAQ when it was created.</p>', 'FaqSummary$Name' => '<p>The name that you assigned the FAQ when you created or updated the FAQ.</p>', ], ], 'FaqStatistics' => [ 'base' => '<p>Provides statistical information about the FAQ questions and answers contained in an index.</p>', 'refs' => [ 'IndexStatistics$FaqStatistics' => '<p>The number of question and answer topics in the index.</p>', ], ], 'FaqStatus' => [ 'base' => NULL, 'refs' => [ 'DescribeFaqResponse$Status' => '<p>The status of the FAQ. It is ready to use when the status is <code>ACTIVE</code>.</p>', 'FaqSummary$Status' => '<p>The current status of the FAQ. When the status is <code>ACTIVE</code> the FAQ is ready for use.</p>', ], ], 'FaqSummary' => [ 'base' => '<p>Provides information about a frequently asked questions and answer contained in an index.</p>', 'refs' => [ 'FaqSummaryItems$member' => NULL, ], ], 'FaqSummaryItems' => [ 'base' => NULL, 'refs' => [ 'ListFaqsResponse$FaqSummaryItems' => '<p>information about the FAQs associated with the specified index.</p>', ], ], 'FeedbackToken' => [ 'base' => NULL, 'refs' => [ 'QueryResultItem$FeedbackToken' => '<p>A token that identifies a particular result from a particular query. Use this token to provide click-through feedback for the result. For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/submitting-feedback.html"> Submitting feedback </a>.</p>', ], ], 'GetQuerySuggestionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetQuerySuggestionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'GoogleDriveConfiguration' => [ 'base' => '<p>Provides configuration information for data sources that connect to Google Drive.</p>', 'refs' => [ 'DataSourceConfiguration$GoogleDriveConfiguration' => '<p>Provides configuration for data sources that connect to Google Drive. </p>', ], ], 'GroupAttributeField' => [ 'base' => NULL, 'refs' => [ 'JwtTokenTypeConfiguration$GroupAttributeField' => '<p>The group attribute field.</p>', ], ], 'GroupId' => [ 'base' => NULL, 'refs' => [ 'DeletePrincipalMappingRequest$GroupId' => '<p>The identifier of the group you want to delete.</p>', 'DescribePrincipalMappingRequest$GroupId' => '<p>The identifier of the group required to check the processing of <code>PUT</code> and <code>DELETE</code> actions for mapping users to their groups.</p>', 'DescribePrincipalMappingResponse$GroupId' => '<p>Shows the identifier of the group to see information on the processing of <code>PUT</code> and <code>DELETE</code> actions for mapping users to their groups.</p>', 'GroupSummary$GroupId' => '<p> The identifier of the group you want group summary information on. </p>', 'MemberGroup$GroupId' => '<p>The identifier of the sub group you want to map to a group.</p>', 'PutPrincipalMappingRequest$GroupId' => '<p>The identifier of the group you want to map its users to.</p>', ], ], 'GroupMembers' => [ 'base' => '<p>A list of users or sub groups that belong to a group. Users and groups are useful for filtering search results to different users based on their group\'s access to documents.</p>', 'refs' => [ 'PutPrincipalMappingRequest$GroupMembers' => '<p>The list that contains your users or sub groups that belong the same group.</p> <p>For example, the group "Company" includes the user "CEO" and the sub groups "Research", "Engineering", and "Sales and Marketing".</p> <p>If you have more than 1000 users and/or sub groups for a single group, you need to provide the path to the S3 file that lists your users and sub groups for a group. Your sub groups can contain more than 1000 users, but the list of sub groups that belong to a group (and/or users) must be no more than 1000.</p>', ], ], 'GroupOrderingIdSummaries' => [ 'base' => NULL, 'refs' => [ 'DescribePrincipalMappingResponse$GroupOrderingIdSummaries' => '<p>Shows the following information on the processing of <code>PUT</code> and <code>DELETE</code> actions for mapping users to their groups:</p> <ul> <li> <p>Status – the status can be either <code>PROCESSING</code>, <code>SUCCEEDED</code>, <code>DELETING</code>, <code>DELETED</code>, or <code>FAILED</code>.</p> </li> <li> <p>Last updated – the last date-time an action was updated.</p> </li> <li> <p>Received – the last date-time an action was received or submitted.</p> </li> <li> <p>Ordering ID – the latest action that should process and apply after other actions.</p> </li> <li> <p>Failure reason – the reason an action could not be processed.</p> </li> </ul>', ], ], 'GroupOrderingIdSummary' => [ 'base' => '<p>Information on the processing of <code>PUT</code> and <code>DELETE</code> actions for mapping users to their groups.</p>', 'refs' => [ 'GroupOrderingIdSummaries$member' => NULL, ], ], 'GroupSummary' => [ 'base' => '<p> Group summary information. </p>', 'refs' => [ 'ListOfGroupSummaries$member' => NULL, ], ], 'Groups' => [ 'base' => NULL, 'refs' => [ 'UserContext$Groups' => '<p>The list of groups you want to filter search results based on the groups\' access to documents.</p>', ], ], 'HierarchicalPrincipal' => [ 'base' => '<p> Information to define the hierarchy for which documents users should have access to. </p>', 'refs' => [ 'HierarchicalPrincipalList$member' => NULL, ], ], 'HierarchicalPrincipalList' => [ 'base' => '<p>A list of <a href="https://docs.aws.amazon.com/kendra/latest/dg/API_Principal.html">principal</a> lists that define the hierarchy for which documents users should have access to. Each hierarchical list specifies which user or group has allow or deny access for each document.</p>', 'refs' => [ 'Document$HierarchicalAccessControlList' => '<p>The list of <a href="https://docs.aws.amazon.com/kendra/latest/dg/API_Principal.html">principal</a> lists that define the hierarchy for which documents users should have access to.</p>', ], ], 'Highlight' => [ 'base' => '<p>Provides information that you can use to highlight a search result so that your users can quickly identify terms in the response.</p>', 'refs' => [ 'HighlightList$member' => NULL, ], ], 'HighlightList' => [ 'base' => NULL, 'refs' => [ 'TextWithHighlights$Highlights' => '<p>The beginning and end of the text that should be highlighted.</p>', ], ], 'HighlightType' => [ 'base' => NULL, 'refs' => [ 'Highlight$Type' => '<p>The highlight type. </p>', ], ], 'Host' => [ 'base' => NULL, 'refs' => [ 'BasicAuthenticationConfiguration$Host' => '<p>The name of the website host you want to connect to using authentication credentials.</p> <p>For example, the host name of https://a.example.com/page1.html is "a.example.com".</p>', 'ProxyConfiguration$Host' => '<p>The name of the website host you want to connect to via a web proxy server.</p> <p>For example, the host name of https://a.example.com/page1.html is "a.example.com".</p>', ], ], 'Importance' => [ 'base' => NULL, 'refs' => [ 'Relevance$Importance' => '<p>The relative importance of the field in the search. Larger numbers provide more of a boost than smaller numbers.</p>', 'ValueImportanceMap$value' => NULL, ], ], 'IndexConfigurationSummary' => [ 'base' => '<p>A summary of information about an index.</p>', 'refs' => [ 'IndexConfigurationSummaryList$member' => NULL, ], ], 'IndexConfigurationSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListIndicesResponse$IndexConfigurationSummaryItems' => '<p>An array of summary information for one or more indexes.</p>', ], ], 'IndexEdition' => [ 'base' => NULL, 'refs' => [ 'CreateIndexRequest$Edition' => '<p>The Amazon Kendra edition to use for the index. Choose <code>DEVELOPER_EDITION</code> for indexes intended for development, testing, or proof of concept. Use <code>ENTERPRISE_EDITION</code> for your production databases. Once you set the edition for an index, it can\'t be changed.</p> <p>The <code>Edition</code> parameter is optional. If you don\'t supply a value, the default is <code>ENTERPRISE_EDITION</code>.</p> <p>For more information on quota limits for enterprise and developer editions, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/quotas.html">Quotas</a>.</p>', 'DescribeIndexResponse$Edition' => '<p>The Amazon Kendra edition used for the index. You decide the edition when you create the index.</p>', 'IndexConfigurationSummary$Edition' => '<p>Indicates whether the index is a enterprise edition index or a developer edition index. </p>', ], ], 'IndexFieldName' => [ 'base' => NULL, 'refs' => [ 'ConfluenceAttachmentToIndexFieldMapping$IndexFieldName' => '<p>The name of the index field to map to the Confluence data source field. The index field type must match the Confluence field type.</p>', 'ConfluenceBlogToIndexFieldMapping$IndexFieldName' => '<p>The name of the index field to map to the Confluence data source field. The index field type must match the Confluence field type.</p>', 'ConfluencePageToIndexFieldMapping$IndexFieldName' => '<p>The name of the index field to map to the Confluence data source field. The index field type must match the Confluence field type.</p>', 'ConfluenceSpaceToIndexFieldMapping$IndexFieldName' => '<p>The name of the index field to map to the Confluence data source field. The index field type must match the Confluence field type.</p>', 'DataSourceToIndexFieldMapping$IndexFieldName' => '<p>The name of the field in the index.</p>', ], ], 'IndexId' => [ 'base' => NULL, 'refs' => [ 'BatchDeleteDocumentRequest$IndexId' => '<p>The identifier of the index that contains the documents to delete.</p>', 'BatchGetDocumentStatusRequest$IndexId' => '<p>The identifier of the index to add documents to. The index ID is returned by the <a href="https://docs.aws.amazon.com/kendra/latest/dg/API_CreateIndex.html"> CreateIndex </a> operation.</p>', 'BatchPutDocumentRequest$IndexId' => '<p>The identifier of the index to add the documents to. You need to create the index first using the <code>CreateIndex</code> operation.</p>', 'ClearQuerySuggestionsRequest$IndexId' => '<p>The identifier of the index you want to clear query suggestions from.</p>', 'CreateDataSourceRequest$IndexId' => '<p>The identifier of the index that should be associated with this data source.</p>', 'CreateFaqRequest$IndexId' => '<p>The identifier of the index that contains the FAQ.</p>', 'CreateIndexResponse$Id' => '<p>The unique identifier of the index. Use this identifier when you query an index, set up a data source, or index a document.</p>', 'CreateQuerySuggestionsBlockListRequest$IndexId' => '<p>The identifier of the index you want to create a query suggestions block list for.</p>', 'CreateThesaurusRequest$IndexId' => '<p>The unique identifier of the index for the new thesaurus. </p>', 'DeleteDataSourceRequest$IndexId' => '<p>The unique identifier of the index associated with the data source.</p>', 'DeleteFaqRequest$IndexId' => '<p>The index to remove the FAQ from.</p>', 'DeleteIndexRequest$Id' => '<p>The identifier of the index to delete.</p>', 'DeletePrincipalMappingRequest$IndexId' => '<p>The identifier of the index you want to delete a group from.</p>', 'DeleteQuerySuggestionsBlockListRequest$IndexId' => '<p>The identifier of the you want to delete a block list from.</p>', 'DeleteThesaurusRequest$IndexId' => '<p>The identifier of the index associated with the thesaurus to delete.</p>', 'DescribeDataSourceRequest$IndexId' => '<p>The identifier of the index that contains the data source.</p>', 'DescribeDataSourceResponse$IndexId' => '<p>The identifier of the index that contains the data source.</p>', 'DescribeFaqRequest$IndexId' => '<p>The identifier of the index that contains the FAQ.</p>', 'DescribeFaqResponse$IndexId' => '<p>The identifier of the index that contains the FAQ.</p>', 'DescribeIndexRequest$Id' => '<p>The name of the index to describe.</p>', 'DescribeIndexResponse$Id' => '<p>The name of the index.</p>', 'DescribePrincipalMappingRequest$IndexId' => '<p>The identifier of the index required to check the processing of <code>PUT</code> and <code>DELETE</code> actions for mapping users to their groups.</p>', 'DescribePrincipalMappingResponse$IndexId' => '<p>Shows the identifier of the index to see information on the processing of <code>PUT</code> and <code>DELETE</code> actions for mapping users to their groups.</p>', 'DescribeQuerySuggestionsBlockListRequest$IndexId' => '<p>The identifier of the index for the block list.</p>', 'DescribeQuerySuggestionsBlockListResponse$IndexId' => '<p>Shows the identifier of the index for the block list.</p>', 'DescribeQuerySuggestionsConfigRequest$IndexId' => '<p>The identifier of the index you want to describe query suggestions settings for.</p>', 'DescribeThesaurusRequest$IndexId' => '<p>The identifier of the index associated with the thesaurus to describe.</p>', 'DescribeThesaurusResponse$IndexId' => '<p>The identifier of the index associated with the thesaurus to describe.</p>', 'GetQuerySuggestionsRequest$IndexId' => '<p>The identifier of the index you want to get query suggestions from.</p>', 'IndexConfigurationSummary$Id' => '<p>A unique identifier for the index. Use this to identify the index when you are using operations such as <code>Query</code>, <code>DescribeIndex</code>, <code>UpdateIndex</code>, and <code>DeleteIndex</code>.</p>', 'ListDataSourceSyncJobsRequest$IndexId' => '<p>The identifier of the index that contains the data source.</p>', 'ListDataSourcesRequest$IndexId' => '<p>The identifier of the index that contains the data source.</p>', 'ListFaqsRequest$IndexId' => '<p>The index that contains the FAQ lists.</p>', 'ListGroupsOlderThanOrderingIdRequest$IndexId' => '<p>The identifier of the index for getting a list of groups mapped to users before a given ordering or timestamp identifier.</p>', 'ListQuerySuggestionsBlockListsRequest$IndexId' => '<p>The identifier of the index for a list of all block lists that exist for that index.</p> <p>For information on the current quota limits for block lists, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/quotas.html">Quotas for Amazon Kendra</a>.</p>', 'ListThesauriRequest$IndexId' => '<p>The identifier of the index associated with the thesaurus to list.</p>', 'PutPrincipalMappingRequest$IndexId' => '<p>The identifier of the index you want to map users to their groups.</p>', 'QueryRequest$IndexId' => '<p>The unique identifier of the index to search. The identifier is returned in the response from the <code>CreateIndex</code> operation.</p>', 'StartDataSourceSyncJobRequest$IndexId' => '<p>The identifier of the index that contains the data source.</p>', 'StopDataSourceSyncJobRequest$IndexId' => '<p>The identifier of the index that contains the data source.</p>', 'SubmitFeedbackRequest$IndexId' => '<p>The identifier of the index that was queried.</p>', 'UpdateDataSourceRequest$IndexId' => '<p>The identifier of the index that contains the data source to update.</p>', 'UpdateIndexRequest$Id' => '<p>The identifier of the index to update.</p>', 'UpdateQuerySuggestionsBlockListRequest$IndexId' => '<p>The identifier of the index for a block list.</p>', 'UpdateQuerySuggestionsConfigRequest$IndexId' => '<p>The identifier of the index you want to update query suggestions settings for.</p>', 'UpdateThesaurusRequest$IndexId' => '<p>The identifier of the index associated with the thesaurus to update.</p>', ], ], 'IndexName' => [ 'base' => NULL, 'refs' => [ 'CreateIndexRequest$Name' => '<p>The name for the new index.</p>', 'DescribeIndexResponse$Name' => '<p>The name of the index.</p>', 'IndexConfigurationSummary$Name' => '<p>The name of the index.</p>', 'UpdateIndexRequest$Name' => '<p>The name of the index to update.</p>', ], ], 'IndexStatistics' => [ 'base' => '<p>Provides information about the number of documents and the number of questions and answers in an index.</p>', 'refs' => [ 'DescribeIndexResponse$IndexStatistics' => '<p>Provides information about the number of FAQ questions and answers and the number of text documents indexed.</p>', ], ], 'IndexStatus' => [ 'base' => NULL, 'refs' => [ 'DescribeIndexResponse$Status' => '<p>The current status of the index. When the value is <code>ACTIVE</code>, the index is ready for use. If the <code>Status</code> field value is <code>FAILED</code>, the <code>ErrorMessage</code> field contains a message that explains why.</p>', 'IndexConfigurationSummary$Status' => '<p>The current status of the index. When the status is <code>ACTIVE</code>, the index is ready to search.</p>', ], ], 'IndexedQuestionAnswersCount' => [ 'base' => NULL, 'refs' => [ 'FaqStatistics$IndexedQuestionAnswersCount' => '<p>The total number of FAQ questions and answers contained in the index.</p>', ], ], 'IndexedTextBytes' => [ 'base' => NULL, 'refs' => [ 'TextDocumentStatistics$IndexedTextBytes' => '<p>The total size, in bytes, of the indexed documents.</p>', ], ], 'IndexedTextDocumentsCount' => [ 'base' => NULL, 'refs' => [ 'TextDocumentStatistics$IndexedTextDocumentsCount' => '<p>The number of text documents indexed.</p>', ], ], 'Integer' => [ 'base' => NULL, 'refs' => [ 'DescribeQuerySuggestionsBlockListResponse$ItemCount' => '<p>Shows the current number of valid, non-empty words or phrases in the block list text file.</p>', 'DescribeQuerySuggestionsConfigResponse$QueryLogLookBackWindowInDays' => '<p>Shows how recent your queries are in your query log time window (in days).</p>', 'DescribeQuerySuggestionsConfigResponse$TotalSuggestionsCount' => '<p>Shows the current total count of query suggestions for an index.</p> <p>This count can change when you update your query suggestions settings, if you filter out certain queries from suggestions using a block list, and as the query log accumulates more queries for Amazon Kendra to learn from.</p>', 'DocumentAttributeValueCountPair$Count' => '<p>The number of documents in the response that have the attribute value for the key.</p>', 'GetQuerySuggestionsRequest$MaxSuggestionsCount' => '<p>The maximum number of query suggestions you want to show to your users.</p>', 'Highlight$BeginOffset' => '<p>The zero-based location in the response string where the highlight starts.</p>', 'Highlight$EndOffset' => '<p>The zero-based location in the response string where the highlight ends.</p>', 'QueryRequest$PageNumber' => '<p>Query results are returned in pages the size of the <code>PageSize</code> parameter. By default, Amazon Kendra returns the first page of results. Use this parameter to get result pages after the first one.</p>', 'QueryRequest$PageSize' => '<p>Sets the number of results that are returned in each page of results. The default page size is 10. The maximum number of results returned is 100. If you ask for more than 100 results, only 100 are returned.</p>', 'QueryResult$TotalNumberOfResults' => '<p>The total number of items found by the search; however, you can only retrieve up to 100 items. For example, if the search found 192 items, you can only retrieve the first 100 of the items.</p>', 'QuerySuggestionsBlockListSummary$ItemCount' => '<p>The number of items in the block list file.</p>', 'SuggestionHighlight$BeginOffset' => '<p>The zero-based location in the response string where the highlight starts.</p>', 'SuggestionHighlight$EndOffset' => '<p>The zero-based location in the response string where the highlight ends.</p>', 'UpdateQuerySuggestionsConfigRequest$QueryLogLookBackWindowInDays' => '<p>How recent your queries are in your query log time window.</p> <p>The time window is the number of days from current day to past days.</p> <p>By default, Amazon Kendra sets this to 180.</p>', ], ], 'InternalServerException' => [ 'base' => '<p/>', 'refs' => [], ], 'Issuer' => [ 'base' => NULL, 'refs' => [ 'JwtTokenTypeConfiguration$Issuer' => '<p>The issuer of the token.</p>', ], ], 'JsonTokenTypeConfiguration' => [ 'base' => '<p>Configuration information for the JSON token type.</p>', 'refs' => [ 'UserTokenConfiguration$JsonTokenTypeConfiguration' => '<p>Information about the JSON token type configuration.</p>', ], ], 'JwtTokenTypeConfiguration' => [ 'base' => '<p>Configuration information for the JWT token type.</p>', 'refs' => [ 'UserTokenConfiguration$JwtTokenTypeConfiguration' => '<p>Information about the JWT token type configuration.</p>', ], ], 'KeyLocation' => [ 'base' => NULL, 'refs' => [ 'JwtTokenTypeConfiguration$KeyLocation' => '<p>The location of the key.</p>', ], ], 'KmsKeyId' => [ 'base' => NULL, 'refs' => [ 'ServerSideEncryptionConfiguration$KmsKeyId' => '<p>The identifier of the KMScustomer master key (CMK). Amazon Kendra doesn\'t support asymmetric CMKs.</p>', ], ], 'ListDataSourceSyncJobsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListDataSourceSyncJobsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListDataSourcesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListDataSourcesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListFaqsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListFaqsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListGroupsOlderThanOrderingIdRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListGroupsOlderThanOrderingIdResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListIndicesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListIndicesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListOfGroupSummaries' => [ 'base' => NULL, 'refs' => [ 'ListGroupsOlderThanOrderingIdResponse$GroupsSummaries' => '<p> Summary information for list of groups that are mapped to users before a given ordering or timestamp identifier. </p>', ], ], 'ListQuerySuggestionsBlockListsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListQuerySuggestionsBlockListsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListThesauriRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListThesauriResponse' => [ 'base' => NULL, 'refs' => [], ], 'Long' => [ 'base' => NULL, 'refs' => [ 'DescribeQuerySuggestionsBlockListResponse$FileSizeBytes' => '<p>Shows the current size of the block list text file in S3.</p>', 'DescribeThesaurusResponse$FileSizeBytes' => '<p>The size of the thesaurus file in bytes.</p>', 'DescribeThesaurusResponse$TermCount' => '<p>The number of unique terms in the thesaurus file. For example, the synonyms <code>a,b,c</code> and <code>a=&gt;d</code>, the term count would be 4. </p>', 'DescribeThesaurusResponse$SynonymRuleCount' => '<p>The number of synonym rules in the thesaurus file.</p>', 'DocumentAttributeValue$LongValue' => '<p>A long integer value.</p>', ], ], 'MaxContentSizePerPageInMegaBytes' => [ 'base' => NULL, 'refs' => [ 'WebCrawlerConfiguration$MaxContentSizePerPageInMegaBytes' => '<p>The maximum size (in MB) of a webpage or attachment to crawl.</p> <p>Files larger than this size (in MB) are skipped/not crawled.</p> <p>The default maximum size of a webpage or attachment is set to 50 MB.</p>', ], ], 'MaxLinksPerPage' => [ 'base' => NULL, 'refs' => [ 'WebCrawlerConfiguration$MaxLinksPerPage' => '<p>The maximum number of URLs on a webpage to include when crawling a website. This number is per webpage.</p> <p>As a website’s webpages are crawled, any URLs the webpages link to are also crawled. URLs on a webpage are crawled in order of appearance.</p> <p>The default maximum links per page is 100.</p>', ], ], 'MaxResultsIntegerForListDataSourceSyncJobsRequest' => [ 'base' => NULL, 'refs' => [ 'ListDataSourceSyncJobsRequest$MaxResults' => '<p>The maximum number of synchronization jobs to return in the response. If there are fewer results in the list, this response contains only the actual results.</p>', ], ], 'MaxResultsIntegerForListDataSourcesRequest' => [ 'base' => NULL, 'refs' => [ 'ListDataSourcesRequest$MaxResults' => '<p>The maximum number of data sources to return.</p>', ], ], 'MaxResultsIntegerForListFaqsRequest' => [ 'base' => NULL, 'refs' => [ 'ListFaqsRequest$MaxResults' => '<p>The maximum number of FAQs to return in the response. If there are fewer results in the list, this response contains only the actual results.</p>', ], ], 'MaxResultsIntegerForListIndicesRequest' => [ 'base' => NULL, 'refs' => [ 'ListIndicesRequest$MaxResults' => '<p>The maximum number of data sources to return.</p>', ], ], 'MaxResultsIntegerForListPrincipalsRequest' => [ 'base' => NULL, 'refs' => [ 'ListGroupsOlderThanOrderingIdRequest$MaxResults' => '<p> The maximum results shown for a list of groups that are mapped to users before a given ordering or timestamp identifier. </p>', ], ], 'MaxResultsIntegerForListQuerySuggestionsBlockLists' => [ 'base' => NULL, 'refs' => [ 'ListQuerySuggestionsBlockListsRequest$MaxResults' => '<p>The maximum number of block lists to return.</p>', ], ], 'MaxResultsIntegerForListThesauriRequest' => [ 'base' => NULL, 'refs' => [ 'ListThesauriRequest$MaxResults' => '<p>The maximum number of thesauri to return.</p>', ], ], 'MaxUrlsPerMinuteCrawlRate' => [ 'base' => NULL, 'refs' => [ 'WebCrawlerConfiguration$MaxUrlsPerMinuteCrawlRate' => '<p>The maximum number of URLs crawled per website host per minute.</p> <p>A minimum of one URL is required.</p> <p>The default maximum number of URLs crawled per website host per minute is 300.</p>', ], ], 'MemberGroup' => [ 'base' => '<p>The sub groups that belong to a group.</p>', 'refs' => [ 'MemberGroups$member' => NULL, ], ], 'MemberGroups' => [ 'base' => NULL, 'refs' => [ 'GroupMembers$MemberGroups' => '<p>A list of sub groups that belong to a group. For example, the sub groups "Research", "Engineering", and "Sales and Marketing" all belong to the group "Company".</p>', ], ], 'MemberUser' => [ 'base' => '<p>The users that belong to a group.</p>', 'refs' => [ 'MemberUsers$member' => NULL, ], ], 'MemberUsers' => [ 'base' => NULL, 'refs' => [ 'GroupMembers$MemberUsers' => '<p>A list of users that belong to a group. For example, a list of interns all belong to the "Interns" group.</p>', ], ], 'MetricValue' => [ 'base' => NULL, 'refs' => [ 'DataSourceSyncJobMetrics$DocumentsAdded' => '<p>The number of documents added from the data source up to now in the data source sync.</p>', 'DataSourceSyncJobMetrics$DocumentsModified' => '<p>The number of documents modified in the data source up to now in the data source sync run.</p>', 'DataSourceSyncJobMetrics$DocumentsDeleted' => '<p>The number of documents deleted from the data source up to now in the data source sync run.</p>', 'DataSourceSyncJobMetrics$DocumentsFailed' => '<p>The number of documents that failed to sync from the data source up to now in the data source sync run.</p>', 'DataSourceSyncJobMetrics$DocumentsScanned' => '<p>The current number of documents crawled by the current sync job in the data source.</p>', ], ], 'MimeType' => [ 'base' => NULL, 'refs' => [ 'ExcludeMimeTypesList$member' => NULL, ], ], 'MinimumNumberOfQueryingUsers' => [ 'base' => NULL, 'refs' => [ 'DescribeQuerySuggestionsConfigResponse$MinimumNumberOfQueryingUsers' => '<p>Shows the minimum number of unique users who must search a query in order for the query to be eligible to suggest to your users.</p>', 'UpdateQuerySuggestionsConfigRequest$MinimumNumberOfQueryingUsers' => '<p>The minimum number of unique users who must search a query in order for the query to be eligible to suggest to your users.</p> <p>Increasing this number might decrease the number of suggestions. However, this ensures a query is searched by many users and is truly popular to suggest to users.</p> <p>How you tune this setting depends on your specific needs.</p>', ], ], 'MinimumQueryCount' => [ 'base' => NULL, 'refs' => [ 'DescribeQuerySuggestionsConfigResponse$MinimumQueryCount' => '<p>Shows the minimum number of times a query must be searched in order for the query to be eligible to suggest to your users.</p>', 'UpdateQuerySuggestionsConfigRequest$MinimumQueryCount' => '<p>The the minimum number of times a query must be searched in order to be eligible to suggest to your users.</p> <p>Decreasing this number increases the number of suggestions. However, this affects the quality of suggestions as it sets a low bar for a query to be considered popular to suggest to users.</p> <p>How you tune this setting depends on your specific needs.</p>', ], ], 'Mode' => [ 'base' => NULL, 'refs' => [ 'DescribeQuerySuggestionsConfigResponse$Mode' => '<p>Shows whether query suggestions are currently in <code>ENABLED</code> mode or <code>LEARN_ONLY</code> mode.</p> <p>By default, Amazon Kendra enables query suggestions.<code>LEARN_ONLY</code> turns off query suggestions for your users. You can change the mode using the <a href="https://docs.aws.amazon.com/kendra/latest/dg/API_UpdateQuerySuggestionsConfig.html">UpdateQuerySuggestionsConfig</a> operation.</p>', 'UpdateQuerySuggestionsConfigRequest$Mode' => '<p>Set the mode to <code>ENABLED</code> or <code>LEARN_ONLY</code>.</p> <p>By default, Amazon Kendra enables query suggestions. <code>LEARN_ONLY</code> mode allows you to turn off query suggestions. You can to update this at any time.</p> <p>In <code>LEARN_ONLY</code> mode, Amazon Kendra continues to learn from new queries to keep suggestions up to date for when you are ready to switch to ENABLED mode again.</p>', ], ], 'NextToken' => [ 'base' => NULL, 'refs' => [ 'ListDataSourceSyncJobsRequest$NextToken' => '<p>If the result of the previous request to <code>GetDataSourceSyncJobHistory</code> was truncated, include the <code>NextToken</code> to fetch the next set of jobs.</p>', 'ListDataSourceSyncJobsResponse$NextToken' => '<p>The <code>GetDataSourceSyncJobHistory</code> operation returns a page of vocabularies at a time. The maximum size of the page is set by the <code>MaxResults</code> parameter. If there are more jobs in the list than the page size, Amazon Kendra returns the NextPage token. Include the token in the next request to the <code>GetDataSourceSyncJobHistory</code> operation to return in the next page of jobs.</p>', 'ListDataSourcesRequest$NextToken' => '<p>If the previous response was incomplete (because there is more data to retrieve), Amazon Kendra returns a pagination token in the response. You can use this pagination token to retrieve the next set of data sources (<code>DataSourceSummaryItems</code>). </p>', 'ListDataSourcesResponse$NextToken' => '<p>If the response is truncated, Amazon Kendra returns this token that you can use in the subsequent request to retrieve the next set of data sources. </p>', 'ListFaqsRequest$NextToken' => '<p>If the result of the previous request to <code>ListFaqs</code> was truncated, include the <code>NextToken</code> to fetch the next set of FAQs.</p>', 'ListFaqsResponse$NextToken' => '<p>The <code>ListFaqs</code> operation returns a page of FAQs at a time. The maximum size of the page is set by the <code>MaxResults</code> parameter. If there are more jobs in the list than the page size, Amazon Kendra returns the <code>NextPage</code> token. Include the token in the next request to the <code>ListFaqs</code> operation to return the next page of FAQs.</p>', 'ListGroupsOlderThanOrderingIdRequest$NextToken' => '<p> The next items in the list of groups that go beyond the maximum. </p>', 'ListGroupsOlderThanOrderingIdResponse$NextToken' => '<p> The next items in the list of groups that go beyond the maximum. </p>', 'ListIndicesRequest$NextToken' => '<p>If the previous response was incomplete (because there is more data to retrieve), Amazon Kendra returns a pagination token in the response. You can use this pagination token to retrieve the next set of indexes (<code>DataSourceSummaryItems</code>). </p>', 'ListIndicesResponse$NextToken' => '<p>If the response is truncated, Amazon Kendra returns this token that you can use in the subsequent request to retrieve the next set of indexes.</p>', 'ListQuerySuggestionsBlockListsRequest$NextToken' => '<p>If the previous response was incomplete (because there is more data to retrieve), Amazon Kendra returns a pagination token in the response. You can use this pagination token to retrieve the next set of block lists (<code>BlockListSummaryItems</code>).</p>', 'ListQuerySuggestionsBlockListsResponse$NextToken' => '<p>If the response is truncated, Amazon Kendra returns this token that you can use in the subsequent request to retrieve the next set of block lists.</p>', 'ListThesauriRequest$NextToken' => '<p>If the previous response was incomplete (because there is more data to retrieve), Amazon Kendra returns a pagination token in the response. You can use this pagination token to retrieve the next set of thesauri (<code>ThesaurusSummaryItems</code>). </p>', 'ListThesauriResponse$NextToken' => '<p>If the response is truncated, Amazon Kendra returns this token that you can use in the subsequent request to retrieve the next set of thesauri. </p>', ], ], 'ObjectBoolean' => [ 'base' => NULL, 'refs' => [ 'DescribeQuerySuggestionsConfigResponse$IncludeQueriesWithoutUserInformation' => '<p>Shows whether Amazon Kendra uses all queries or only uses queries that include user information to generate query suggestions.</p>', 'UpdateQuerySuggestionsConfigRequest$IncludeQueriesWithoutUserInformation' => '<p> <code>TRUE</code> to include queries without user information (i.e. all queries, irrespective of the user), otherwise <code>FALSE</code> to only include queries with user information.</p> <p>If you pass user information to Amazon Kendra along with the queries, you can set this flag to <code>FALSE</code> and instruct Amazon Kendra to only consider queries with user information.</p> <p>If you set to <code>FALSE</code>, Amazon Kendra only considers queries searched at least <code>MinimumQueryCount</code> times across <code>MinimumNumberOfQueryingUsers</code> unique users for suggestions.</p> <p>If you set to <code>TRUE</code>, Amazon Kendra ignores all user information and learns from all queries.</p>', ], ], 'OneDriveConfiguration' => [ 'base' => '<p>Provides configuration information for data sources that connect to OneDrive.</p>', 'refs' => [ 'DataSourceConfiguration$OneDriveConfiguration' => '<p>Provides configuration for data sources that connect to Microsoft OneDrive.</p>', ], ], 'OneDriveUser' => [ 'base' => NULL, 'refs' => [ 'OneDriveUserList$member' => NULL, ], ], 'OneDriveUserList' => [ 'base' => NULL, 'refs' => [ 'OneDriveUsers$OneDriveUserList' => '<p>A list of users whose documents should be indexed. Specify the user names in email format, for example, <code>username@tenantdomain</code>. If you need to index the documents of more than 100 users, use the <code>OneDriveUserS3Path</code> field to specify the location of a file containing a list of users.</p>', ], ], 'OneDriveUsers' => [ 'base' => '<p>User accounts whose documents should be indexed.</p>', 'refs' => [ 'OneDriveConfiguration$OneDriveUsers' => '<p>A list of user accounts whose documents should be indexed.</p>', ], ], 'Order' => [ 'base' => NULL, 'refs' => [ 'Relevance$RankOrder' => '<p>Determines how values should be interpreted.</p> <p>When the <code>RankOrder</code> field is <code>ASCENDING</code>, higher numbers are better. For example, a document with a rating score of 10 is higher ranking than a document with a rating score of 1.</p> <p>When the <code>RankOrder</code> field is <code>DESCENDING</code>, lower numbers are better. For example, in a task tracking application, a priority 1 task is more important than a priority 5 task.</p> <p>Only applies to <code>LONG</code> and <code>DOUBLE</code> fields.</p>', ], ], 'OrganizationId' => [ 'base' => NULL, 'refs' => [ 'WorkDocsConfiguration$OrganizationId' => '<p>The identifier of the directory corresponding to your Amazon WorkDocs site repository.</p> <p>You can find the organization ID in the <a href="https://console.aws.amazon.com/directoryservicev2/">AWS Directory Service</a> by going to <b>Active Directory</b>, then <b>Directories</b>. Your Amazon WorkDocs site directory has an ID, which is the organization ID. You can also set up a new Amazon WorkDocs directory in the AWS Directory Service console and enable a Amazon WorkDocs site for the directory in the Amazon WorkDocs console.</p>', ], ], 'Port' => [ 'base' => NULL, 'refs' => [ 'BasicAuthenticationConfiguration$Port' => '<p>The port number of the website host you want to connect to using authentication credentials.</p> <p>For example, the port for https://a.example.com/page1.html is 443, the standard port for HTTPS.</p>', 'ProxyConfiguration$Port' => '<p>The port number of the website host you want to connect to via a web proxy server. </p> <p>For example, the port for https://a.example.com/page1.html is 443, the standard port for HTTPS.</p>', ], ], 'Principal' => [ 'base' => '<p>Provides user and group information for document access filtering.</p>', 'refs' => [ 'PrincipalList$member' => NULL, ], ], 'PrincipalList' => [ 'base' => NULL, 'refs' => [ 'Document$AccessControlList' => '<p>Information on user and group access rights, which is used for user context filtering.</p>', 'HierarchicalPrincipal$PrincipalList' => '<p>A list of <a href="https://docs.aws.amazon.com/kendra/latest/dg/API_Principal.html">principal</a> lists that define the hierarchy for which documents users should have access to. Each hierarchical list specifies which user or group has allow or deny access for each document.</p>', ], ], 'PrincipalMappingStatus' => [ 'base' => NULL, 'refs' => [ 'GroupOrderingIdSummary$Status' => '<p>The current processing status of actions for mapping users to their groups. The status can be either <code>PROCESSING</code>, <code>SUCCEEDED</code>, <code>DELETING</code>, <code>DELETED</code>, or <code>FAILED</code>.</p>', ], ], 'PrincipalName' => [ 'base' => NULL, 'refs' => [ 'DataSourceGroup$GroupId' => '<p>The identifier of the group you want to add to your list of groups. This is for filtering search results based on the groups\' access to documents.</p>', 'Groups$member' => NULL, 'Principal$Name' => '<p>The name of the user or group.</p>', 'UserContext$UserId' => '<p>The identifier of the user you want to filter search results based on their access to documents.</p>', ], ], 'PrincipalOrderingId' => [ 'base' => NULL, 'refs' => [ 'DeletePrincipalMappingRequest$OrderingId' => '<p>The timestamp identifier you specify to ensure Amazon Kendra does not override the latest <code>DELETE</code> action with previous actions. The highest number ID, which is the ordering ID, is the latest action you want to process and apply on top of other actions with lower number IDs. This prevents previous actions with lower number IDs from possibly overriding the latest action.</p> <p>The ordering ID can be the UNIX time of the last update you made to a group members list. You would then provide this list when calling <code>PutPrincipalMapping</code>. This ensures your <code>DELETE</code> action for that updated group with the latest members list doesn\'t get overwritten by earlier <code>DELETE</code> actions for the same group which are yet to be processed.</p> <p>The default ordering ID is the current UNIX time in milliseconds that the action was received by Amazon Kendra. </p>', 'GroupOrderingIdSummary$OrderingId' => '<p>The order in which actions should complete processing. An action can be a <code>PUT</code> or <code>DELETE</code> action for mapping users to their groups.</p>', 'GroupSummary$OrderingId' => '<p> The timestamp identifier used for the latest <code>PUT</code> or <code>DELETE</code> action. </p>', 'ListGroupsOlderThanOrderingIdRequest$OrderingId' => '<p>The timestamp identifier used for the latest <code>PUT</code> or <code>DELETE</code> action for mapping users to their groups.</p>', 'PutPrincipalMappingRequest$OrderingId' => '<p>The timestamp identifier you specify to ensure Amazon Kendra does not override the latest <code>PUT</code> action with previous actions. The highest number ID, which is the ordering ID, is the latest action you want to process and apply on top of other actions with lower number IDs. This prevents previous actions with lower number IDs from possibly overriding the latest action.</p> <p>The ordering ID can be the UNIX time of the last update you made to a group members list. You would then provide this list when calling <code>PutPrincipalMapping</code>. This ensures your <code>PUT</code> action for that updated group with the latest members list doesn\'t get overwritten by earlier <code>PUT</code> actions for the same group which are yet to be processed.</p> <p>The default ordering ID is the current UNIX time in milliseconds that the action was received by Amazon Kendra.</p>', ], ], 'PrincipalType' => [ 'base' => NULL, 'refs' => [ 'Principal$Type' => '<p>The type of principal.</p>', ], ], 'ProxyConfiguration' => [ 'base' => '<p>Provides the configuration information for a web proxy to connect to website hosts.</p>', 'refs' => [ 'WebCrawlerConfiguration$ProxyConfiguration' => '<p>Provides configuration information required to connect to your internal websites via a web proxy.</p> <p>You must provide the website host name and port number. For example, the host name of https://a.example.com/page1.html is "a.example.com" and the port is 443, the standard port for HTTPS.</p> <p>Web proxy credentials are optional and you can use them to connect to a web proxy server that requires basic authentication. To store web proxy credentials, you use a secret in <a href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/intro.html">AWS Secrets Manager</a>.</p>', ], ], 'PutPrincipalMappingRequest' => [ 'base' => NULL, 'refs' => [], ], 'QueryCapacityUnit' => [ 'base' => NULL, 'refs' => [ 'CapacityUnitsConfiguration$QueryCapacityUnits' => '<p>The amount of extra query capacity for an index and <a href="https://docs.aws.amazon.com/kendra/latest/dg/API_GetQuerySuggestions.html">GetQuerySuggestions</a> capacity.</p> <p>A single extra capacity unit for an index provides 0.1 queries per second or approximately 8,000 queries per day.</p> <p> <code>GetQuerySuggestions</code> capacity is five times the provisioned query capacity for an index, or the base capacity of 2.5 calls per second, whichever is higher. For example, the base capacity for an index is 0.1 queries per second, and <code>GetQuerySuggestions</code> capacity has a base of 2.5 calls per second. If you add another 0.1 queries per second to total 0.2 queries per second for an index, the <code>GetQuerySuggestions</code> capacity is 2.5 calls per second (higher than five times 0.2 queries per second).</p>', ], ], 'QueryId' => [ 'base' => NULL, 'refs' => [ 'QueryResult$QueryId' => '<p>The unique identifier for the search. You use <code>QueryId</code> to identify the search when using the feedback API.</p>', 'SubmitFeedbackRequest$QueryId' => '<p>The identifier of the specific query for which you are submitting feedback. The query ID is returned in the response to the <code>Query</code> operation.</p>', ], ], 'QueryIdentifiersEnclosingOption' => [ 'base' => NULL, 'refs' => [ 'SqlConfiguration$QueryIdentifiersEnclosingOption' => '<p>Determines whether Amazon Kendra encloses SQL identifiers for tables and column names in double quotes (") when making a database query.</p> <p>By default, Amazon Kendra passes SQL identifiers the way that they are entered into the data source configuration. It does not change the case of identifiers or enclose them in quotes.</p> <p>PostgreSQL internally converts uppercase characters to lower case characters in identifiers unless they are quoted. Choosing this option encloses identifiers in quotes so that PostgreSQL does not convert the character\'s case.</p> <p>For MySQL databases, you must enable the <code>ansi_quotes</code> option when you set this field to <code>DOUBLE_QUOTES</code>.</p>', ], ], 'QueryRequest' => [ 'base' => NULL, 'refs' => [], ], 'QueryResult' => [ 'base' => NULL, 'refs' => [], ], 'QueryResultItem' => [ 'base' => '<p>A single query result.</p> <p>A query result contains information about a document returned by the query. This includes the original location of the document, a list of attributes assigned to the document, and relevant text from the document that satisfies the query.</p>', 'refs' => [ 'QueryResultItemList$member' => NULL, ], ], 'QueryResultItemList' => [ 'base' => NULL, 'refs' => [ 'QueryResult$ResultItems' => '<p>The results of the search.</p>', ], ], 'QueryResultType' => [ 'base' => NULL, 'refs' => [ 'QueryRequest$QueryResultTypeFilter' => '<p>Sets the type of query. Only results for the specified query type are returned.</p>', 'QueryResultItem$Type' => '<p>The type of document. </p>', ], ], 'QuerySuggestionsBlockListId' => [ 'base' => NULL, 'refs' => [ 'CreateQuerySuggestionsBlockListResponse$Id' => '<p>The unique identifier of the created block list.</p>', 'DeleteQuerySuggestionsBlockListRequest$Id' => '<p>The unique identifier of the block list that needs to be deleted.</p>', 'DescribeQuerySuggestionsBlockListRequest$Id' => '<p>The unique identifier of the block list.</p>', 'DescribeQuerySuggestionsBlockListResponse$Id' => '<p>Shows the unique identifier of the block list.</p>', 'QuerySuggestionsBlockListSummary$Id' => '<p>The identifier of a block list.</p>', 'UpdateQuerySuggestionsBlockListRequest$Id' => '<p>The unique identifier of a block list.</p>', ], ], 'QuerySuggestionsBlockListName' => [ 'base' => NULL, 'refs' => [ 'CreateQuerySuggestionsBlockListRequest$Name' => '<p>A user friendly name for the block list.</p> <p>For example, the block list named \'offensive-words\' includes all offensive words that could appear in user queries and need to be blocked from suggestions.</p>', 'DescribeQuerySuggestionsBlockListResponse$Name' => '<p>Shows the name of the block list.</p>', 'QuerySuggestionsBlockListSummary$Name' => '<p>The name of the block list.</p>', 'UpdateQuerySuggestionsBlockListRequest$Name' => '<p>The name of a block list.</p>', ], ], 'QuerySuggestionsBlockListStatus' => [ 'base' => NULL, 'refs' => [ 'DescribeQuerySuggestionsBlockListResponse$Status' => '<p>Shows whether the current status of the block list is <code>ACTIVE</code> or <code>INACTIVE</code>.</p>', 'QuerySuggestionsBlockListSummary$Status' => '<p>The status of the block list.</p>', ], ], 'QuerySuggestionsBlockListSummary' => [ 'base' => '<p>Summary information on a query suggestions block list.</p> <p>This includes information on the block list ID, block list name, when the block list was created, when the block list was last updated, and the count of block words/phrases in the block list.</p> <p>For information on the current quota limits for block lists, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/quotas.html">Quotas for Amazon Kendra</a>.</p>', 'refs' => [ 'QuerySuggestionsBlockListSummaryItems$member' => NULL, ], ], 'QuerySuggestionsBlockListSummaryItems' => [ 'base' => NULL, 'refs' => [ 'ListQuerySuggestionsBlockListsResponse$BlockListSummaryItems' => '<p>Summary items for a block list.</p> <p>This includes summary items on the block list ID, block list name, when the block list was created, when the block list was last updated, and the count of block words/phrases in the block list.</p> <p>For information on the current quota limits for block lists, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/quotas.html">Quotas for Amazon Kendra</a>.</p>', ], ], 'QuerySuggestionsId' => [ 'base' => NULL, 'refs' => [ 'GetQuerySuggestionsResponse$QuerySuggestionsId' => '<p>The unique identifier for a list of query suggestions for an index.</p>', ], ], 'QuerySuggestionsStatus' => [ 'base' => NULL, 'refs' => [ 'DescribeQuerySuggestionsConfigResponse$Status' => '<p>Shows whether the status of query suggestions settings is currently Active or Updating.</p> <p>Active means the current settings apply and Updating means your changed settings are in the process of applying.</p>', ], ], 'QueryText' => [ 'base' => NULL, 'refs' => [ 'QueryRequest$QueryText' => '<p>The text to search for.</p>', ], ], 'ReadAccessType' => [ 'base' => NULL, 'refs' => [ 'Principal$Access' => '<p>Whether to allow or deny access to the principal.</p>', ], ], 'Relevance' => [ 'base' => '<p>Provides information for manually tuning the relevance of a field in a search. When a query includes terms that match the field, the results are given a boost in the response based on these tuning parameters.</p>', 'refs' => [ 'DocumentMetadataConfiguration$Relevance' => '<p>Provides manual tuning parameters to determine how the field affects the search results.</p>', 'DocumentRelevanceConfiguration$Relevance' => NULL, ], ], 'RelevanceFeedback' => [ 'base' => '<p>Provides feedback on how relevant a document is to a search. Your application uses the <code>SubmitFeedback</code> operation to provide relevance information.</p>', 'refs' => [ 'RelevanceFeedbackList$member' => NULL, ], ], 'RelevanceFeedbackList' => [ 'base' => NULL, 'refs' => [ 'SubmitFeedbackRequest$RelevanceFeedbackItems' => '<p>Provides Amazon Kendra with relevant or not relevant feedback for whether a particular item was relevant to the search.</p>', ], ], 'RelevanceType' => [ 'base' => NULL, 'refs' => [ 'RelevanceFeedback$RelevanceValue' => '<p>Whether to document was relevant or not relevant to the search.</p>', ], ], 'ResourceAlreadyExistException' => [ 'base' => '<p/>', 'refs' => [], ], 'ResourceInUseException' => [ 'base' => '<p/>', 'refs' => [], ], 'ResourceNotFoundException' => [ 'base' => '<p/>', 'refs' => [], ], 'ResourceUnavailableException' => [ 'base' => '<p/>', 'refs' => [], ], 'ResultId' => [ 'base' => NULL, 'refs' => [ 'ClickFeedback$ResultId' => '<p>The unique identifier of the search result that was clicked.</p>', 'QueryResultItem$Id' => '<p>The unique identifier for the query result.</p>', 'RelevanceFeedback$ResultId' => '<p>The unique identifier of the search result that the user provided relevance feedback for.</p>', 'Suggestion$Id' => '<p>The unique UUID (universally unique identifier) of a single query suggestion.</p>', ], ], 'RoleArn' => [ 'base' => NULL, 'refs' => [ 'BatchPutDocumentRequest$RoleArn' => '<p>The Amazon Resource Name (ARN) of a role that is allowed to run the <code>BatchPutDocument</code> operation. For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/iam-roles.html">IAM Roles for Amazon Kendra</a>.</p>', 'CreateDataSourceRequest$RoleArn' => '<p>The Amazon Resource Name (ARN) of a role with permission to access the data source. For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/iam-roles.html">IAM Roles for Amazon Kendra</a>.</p> <p>You can\'t specify the <code>RoleArn</code> parameter when the <code>Type</code> parameter is set to <code>CUSTOM</code>. If you do, you receive a <code>ValidationException</code> exception.</p> <p>The <code>RoleArn</code> parameter is required for all other data sources.</p>', 'CreateFaqRequest$RoleArn' => '<p>The Amazon Resource Name (ARN) of a role with permission to access the S3 bucket that contains the FAQs. For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/iam-roles.html">IAM Roles for Amazon Kendra</a>.</p>', 'CreateIndexRequest$RoleArn' => '<p>An Identity and Access Management(IAM) role that gives Amazon Kendra permissions to access your Amazon CloudWatch logs and metrics. This is also the role used when you use the <code>BatchPutDocument</code> operation to index documents from an Amazon S3 bucket.</p>', 'CreateQuerySuggestionsBlockListRequest$RoleArn' => '<p>The IAM (Identity and Access Management) role used by Amazon Kendra to access the block list text file in your S3 bucket.</p> <p>You need permissions to the role ARN (Amazon Resource Name). The role needs S3 read permissions to your file in S3 and needs to give STS (Security Token Service) assume role permissions to Amazon Kendra.</p>', 'CreateThesaurusRequest$RoleArn' => '<p>An AWS Identity and Access Management (IAM) role that gives Amazon Kendra permissions to access thesaurus file specified in <code>SourceS3Path</code>. </p>', 'DescribeDataSourceResponse$RoleArn' => '<p>The Amazon Resource Name (ARN) of the role that enables the data source to access its resources.</p>', 'DescribeFaqResponse$RoleArn' => '<p>The Amazon Resource Name (ARN) of the role that provides access to the S3 bucket containing the input files for the FAQ.</p>', 'DescribeIndexResponse$RoleArn' => '<p>The Amazon Resource Name (ARN) of the IAM role that gives Amazon Kendra permission to write to your Amazon Cloudwatch logs.</p>', 'DescribeQuerySuggestionsBlockListResponse$RoleArn' => '<p>Shows the current IAM (Identity and Access Management) role used by Amazon Kendra to access the block list text file in S3.</p> <p>The role needs S3 read permissions to your file in S3 and needs to give STS (Security Token Service) assume role permissions to Amazon Kendra.</p>', 'DescribeThesaurusResponse$RoleArn' => '<p>An AWS Identity and Access Management (IAM) role that gives Amazon Kendra permissions to access thesaurus file specified in <code>SourceS3Path</code>. </p>', 'JwtTokenTypeConfiguration$SecretManagerArn' => '<p>The Amazon Resource Name (arn) of the secret.</p>', 'PutPrincipalMappingRequest$RoleArn' => '<p>The Amazon Resource Name (ARN) of a role that has access to the S3 file that contains your list of users or sub groups that belong to a group.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/iam-roles.html#iam-roles-ds">IAM roles for Amazon Kendra</a>.</p>', 'UpdateDataSourceRequest$RoleArn' => '<p>The Amazon Resource Name (ARN) of the new role to use when the data source is accessing resources on your behalf.</p>', 'UpdateIndexRequest$RoleArn' => '<p>A new IAM role that gives Amazon Kendra permission to access your Amazon CloudWatch logs.</p>', 'UpdateQuerySuggestionsBlockListRequest$RoleArn' => '<p>The IAM (Identity and Access Management) role used to access the block list text file in S3.</p>', 'UpdateThesaurusRequest$RoleArn' => '<p>The updated role ARN of the thesaurus.</p>', ], ], 'S3BucketName' => [ 'base' => NULL, 'refs' => [ 'S3DataSourceConfiguration$BucketName' => '<p>The name of the bucket that contains the documents.</p>', 'S3Path$Bucket' => '<p>The name of the S3 bucket that contains the file.</p>', ], ], 'S3DataSourceConfiguration' => [ 'base' => '<p>Provides configuration information for a data source to index documents in an Amazon S3 bucket.</p>', 'refs' => [ 'DataSourceConfiguration$S3Configuration' => '<p>Provides information to create a data source connector for a document repository in an Amazon S3 bucket.</p>', ], ], 'S3ObjectKey' => [ 'base' => NULL, 'refs' => [ 'AccessControlListConfiguration$KeyPath' => '<p>Path to the Amazon Web Services S3 bucket that contains the ACL files.</p>', 'DocumentsMetadataConfiguration$S3Prefix' => '<p>A prefix used to filter metadata configuration files in the Amazon Web Services S3 bucket. The S3 bucket might contain multiple metadata files. Use <code>S3Prefix</code> to include only the desired metadata files.</p>', 'S3Path$Key' => '<p>The name of the file.</p>', ], ], 'S3Path' => [ 'base' => '<p>Information required to find a specific file in an Amazon S3 bucket.</p>', 'refs' => [ 'CreateFaqRequest$S3Path' => '<p>The S3 location of the FAQ input data.</p>', 'CreateQuerySuggestionsBlockListRequest$SourceS3Path' => '<p>The S3 path to your block list text file in your S3 bucket.</p> <p>Each block word or phrase should be on a separate line in a text file.</p> <p>For information on the current quota limits for block lists, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/quotas.html">Quotas for Amazon Kendra</a>.</p>', 'CreateThesaurusRequest$SourceS3Path' => '<p>The thesaurus file Amazon S3 source path. </p>', 'DescribeFaqResponse$S3Path' => NULL, 'DescribeQuerySuggestionsBlockListResponse$SourceS3Path' => '<p>Shows the current S3 path to your block list text file in your S3 bucket.</p> <p>Each block word or phrase should be on a separate line in a text file.</p> <p>For information on the current quota limits for block lists, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/quotas.html">Quotas for Amazon Kendra</a>.</p>', 'DescribeThesaurusResponse$SourceS3Path' => NULL, 'Document$S3Path' => NULL, 'GroupMembers$S3PathforGroupMembers' => '<p>If you have more than 1000 users and/or sub groups for a single group, you need to provide the path to the S3 file that lists your users and sub groups for a group. Your sub groups can contain more than 1000 users, but the list of sub groups that belong to a group (and/or users) must be no more than 1000.</p>', 'OneDriveUsers$OneDriveUserS3Path' => '<p>The S3 bucket location of a file containing a list of users whose documents should be indexed.</p>', 'SharePointConfiguration$SslCertificateS3Path' => NULL, 'UpdateQuerySuggestionsBlockListRequest$SourceS3Path' => '<p>The S3 path where your block list text file sits in S3.</p> <p>If you update your block list and provide the same path to the block list text file in S3, then Amazon Kendra reloads the file to refresh the block list. Amazon Kendra does not automatically refresh your block list. You need to call the <code>UpdateQuerySuggestionsBlockList</code> API to refresh you block list.</p> <p>If you update your block list, then Amazon Kendra asynchronously refreshes all query suggestions with the latest content in the S3 file. This means changes might not take effect immediately.</p>', 'UpdateThesaurusRequest$SourceS3Path' => NULL, ], ], 'SalesforceChatterFeedConfiguration' => [ 'base' => '<p>Defines configuration for syncing a Salesforce chatter feed. The contents of the object comes from the Salesforce FeedItem table.</p>', 'refs' => [ 'SalesforceConfiguration$ChatterFeedConfiguration' => '<p>Specifies configuration information for Salesforce chatter feeds.</p>', ], ], 'SalesforceChatterFeedIncludeFilterType' => [ 'base' => NULL, 'refs' => [ 'SalesforceChatterFeedIncludeFilterTypes$member' => NULL, ], ], 'SalesforceChatterFeedIncludeFilterTypes' => [ 'base' => NULL, 'refs' => [ 'SalesforceChatterFeedConfiguration$IncludeFilterTypes' => '<p>Filters the documents in the feed based on status of the user. When you specify <code>ACTIVE_USERS</code> only documents from users who have an active account are indexed. When you specify <code>STANDARD_USER</code> only documents for Salesforce standard users are documented. You can specify both.</p>', ], ], 'SalesforceConfiguration' => [ 'base' => '<p>Provides configuration information for connecting to a Salesforce data source.</p>', 'refs' => [ 'DataSourceConfiguration$SalesforceConfiguration' => '<p>Provides configuration information for data sources that connect to a Salesforce site.</p>', ], ], 'SalesforceCustomKnowledgeArticleTypeConfiguration' => [ 'base' => '<p>Provides configuration information for indexing Salesforce custom articles.</p>', 'refs' => [ 'SalesforceCustomKnowledgeArticleTypeConfigurationList$member' => NULL, ], ], 'SalesforceCustomKnowledgeArticleTypeConfigurationList' => [ 'base' => NULL, 'refs' => [ 'SalesforceKnowledgeArticleConfiguration$CustomKnowledgeArticleTypeConfigurations' => '<p>Provides configuration information for custom Salesforce knowledge articles.</p>', ], ], 'SalesforceCustomKnowledgeArticleTypeName' => [ 'base' => NULL, 'refs' => [ 'SalesforceCustomKnowledgeArticleTypeConfiguration$Name' => '<p>The name of the configuration.</p>', ], ], 'SalesforceKnowledgeArticleConfiguration' => [ 'base' => '<p>Specifies configuration information for the knowledge article types that Amazon Kendra indexes. Amazon Kendra indexes standard knowledge articles and the standard fields of knowledge articles, or the custom fields of custom knowledge articles, but not both </p>', 'refs' => [ 'SalesforceConfiguration$KnowledgeArticleConfiguration' => '<p>Specifies configuration information for the knowledge article types that Amazon Kendra indexes. Amazon Kendra indexes standard knowledge articles and the standard fields of knowledge articles, or the custom fields of custom knowledge articles, but not both.</p>', ], ], 'SalesforceKnowledgeArticleState' => [ 'base' => NULL, 'refs' => [ 'SalesforceKnowledgeArticleStateList$member' => NULL, ], ], 'SalesforceKnowledgeArticleStateList' => [ 'base' => NULL, 'refs' => [ 'SalesforceKnowledgeArticleConfiguration$IncludedStates' => '<p>Specifies the document states that should be included when Amazon Kendra indexes knowledge articles. You must specify at least one state.</p>', ], ], 'SalesforceStandardKnowledgeArticleTypeConfiguration' => [ 'base' => '<p>Provides configuration information for standard Salesforce knowledge articles.</p>', 'refs' => [ 'SalesforceKnowledgeArticleConfiguration$StandardKnowledgeArticleTypeConfiguration' => '<p>Provides configuration information for standard Salesforce knowledge articles.</p>', ], ], 'SalesforceStandardObjectAttachmentConfiguration' => [ 'base' => '<p>Provides configuration information for processing attachments to Salesforce standard objects. </p>', 'refs' => [ 'SalesforceConfiguration$StandardObjectAttachmentConfiguration' => '<p>Provides configuration information for processing attachments to Salesforce standard objects. </p>', ], ], 'SalesforceStandardObjectConfiguration' => [ 'base' => '<p>Specifies configuration information for indexing a single standard object.</p>', 'refs' => [ 'SalesforceStandardObjectConfigurationList$member' => NULL, ], ], 'SalesforceStandardObjectConfigurationList' => [ 'base' => NULL, 'refs' => [ 'SalesforceConfiguration$StandardObjectConfigurations' => '<p>Specifies the Salesforce standard objects that Amazon Kendra indexes.</p>', ], ], 'SalesforceStandardObjectName' => [ 'base' => NULL, 'refs' => [ 'SalesforceStandardObjectConfiguration$Name' => '<p>The name of the standard object.</p>', ], ], 'ScanSchedule' => [ 'base' => NULL, 'refs' => [ 'CreateDataSourceRequest$Schedule' => '<p>Sets the frequency that Amazon Kendra will check the documents in your repository and update the index. If you don\'t set a schedule Amazon Kendra will not periodically update the index. You can call the <code>StartDataSourceSyncJob</code> operation to update the index.</p> <p>You can\'t specify the <code>Schedule</code> parameter when the <code>Type</code> parameter is set to <code>CUSTOM</code>. If you do, you receive a <code>ValidationException</code> exception.</p>', 'DescribeDataSourceResponse$Schedule' => '<p>The schedule that Amazon Kendra will update the data source.</p>', 'UpdateDataSourceRequest$Schedule' => '<p>The new update schedule for the data source.</p>', ], ], 'ScoreAttributes' => [ 'base' => '<p>Provides a relative ranking that indicates how confident Amazon Kendra is that the response matches the query.</p>', 'refs' => [ 'QueryResultItem$ScoreAttributes' => '<p>Indicates the confidence that Amazon Kendra has that a result matches the query that you provided. Each result is placed into a bin that indicates the confidence, <code>VERY_HIGH</code>, <code>HIGH</code>, <code>MEDIUM</code> and <code>LOW</code>. You can use the score to determine if a response meets the confidence needed for your application.</p> <p>The field is only set to <code>LOW</code> when the <code>Type</code> field is set to <code>DOCUMENT</code> and Amazon Kendra is not confident that the result matches the query.</p>', ], ], 'ScoreConfidence' => [ 'base' => 'Enumeration for query score confidence.', 'refs' => [ 'ScoreAttributes$ScoreConfidence' => '<p>A relative ranking for how well the response matches the query.</p>', ], ], 'Search' => [ 'base' => '<p>Provides information about how a custom index field is used during a search.</p>', 'refs' => [ 'DocumentMetadataConfiguration$Search' => '<p>Provides information about how the field is used during a search.</p>', ], ], 'SecretArn' => [ 'base' => NULL, 'refs' => [ 'BasicAuthenticationConfiguration$Credentials' => '<p>Your secret ARN, which you can create in <a href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/intro.html">AWS Secrets Manager</a> </p> <p>You use a secret if basic authentication credentials are required to connect to a website. The secret stores your credentials of user name and password.</p>', 'ConfluenceConfiguration$SecretArn' => '<p>The Amazon Resource Name (ARN) of an Secrets Managersecret that contains the key/value pairs required to connect to your Confluence server. The secret must contain a JSON structure with the following keys:</p> <ul> <li> <p>username - The user name or email address of a user with administrative privileges for the Confluence server.</p> </li> <li> <p>password - The password associated with the user logging in to the Confluence server.</p> </li> </ul>', 'ConnectionConfiguration$SecretArn' => '<p>The Amazon Resource Name (ARN) of credentials stored in Secrets Manager. The credentials should be a user/password pair. For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/data-source-database.html">Using a Database Data Source</a>. For more information about Secrets Manager, see <a href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/intro.html"> What Is Secrets Manager</a> in the <i> Secrets Manager </i> user guide.</p>', 'GoogleDriveConfiguration$SecretArn' => '<p>The Amazon Resource Name (ARN) of a Secrets Managersecret that contains the credentials required to connect to Google Drive. For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/data-source-google-drive.html">Using a Google Workspace Drive data source</a>.</p>', 'OneDriveConfiguration$SecretArn' => '<p>The Amazon Resource Name (ARN) of an Secrets Managersecret that contains the user name and password to connect to OneDrive. The user namd should be the application ID for the OneDrive application, and the password is the application key for the OneDrive application.</p>', 'ProxyConfiguration$Credentials' => '<p>Your secret ARN, which you can create in <a href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/intro.html">AWS Secrets Manager</a> </p> <p>The credentials are optional. You use a secret if web proxy credentials are required to connect to a website host. Amazon Kendra currently support basic authentication to connect to a web proxy server. The secret stores your credentials.</p>', 'SalesforceConfiguration$SecretArn' => '<p>The Amazon Resource Name (ARN) of an Secrets Managersecret that contains the key/value pairs required to connect to your Salesforce instance. The secret must contain a JSON structure with the following keys:</p> <ul> <li> <p>authenticationUrl - The OAUTH endpoint that Amazon Kendra connects to get an OAUTH token. </p> </li> <li> <p>consumerKey - The application public key generated when you created your Salesforce application.</p> </li> <li> <p>consumerSecret - The application private key generated when you created your Salesforce application.</p> </li> <li> <p>password - The password associated with the user logging in to the Salesforce instance.</p> </li> <li> <p>securityToken - The token associated with the user account logging in to the Salesforce instance.</p> </li> <li> <p>username - The user name of the user logging in to the Salesforce instance.</p> </li> </ul>', 'ServiceNowConfiguration$SecretArn' => '<p>The Amazon Resource Name (ARN) of the Secrets Manager secret that contains the user name and password required to connect to the ServiceNow instance.</p>', 'SharePointConfiguration$SecretArn' => '<p>The Amazon Resource Name (ARN) of credentials stored in Secrets Manager. The credentials should be a user/password pair. If you use SharePoint Server, you also need to provide the sever domain name as part of the credentials. For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/data-source-sharepoint.html">Using a Microsoft SharePoint Data Source</a>. For more information about Secrets Manager, see <a href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/intro.html"> What Is Secrets Manager</a> in the <i>Secrets Manager </i> user guide.</p>', ], ], 'SecurityGroupIdList' => [ 'base' => NULL, 'refs' => [ 'DataSourceVpcConfiguration$SecurityGroupIds' => '<p>A list of identifiers of security groups within your Amazon VPC. The security groups should enable Amazon Kendra to connect to the data source.</p>', ], ], 'SeedUrl' => [ 'base' => NULL, 'refs' => [ 'SeedUrlList$member' => NULL, ], ], 'SeedUrlConfiguration' => [ 'base' => '<p>Provides the configuration information of the seed or starting point URLs to crawl.</p> <p> <i>When selecting websites to index, you must adhere to the <a href="https://aws.amazon.com/aup/">Amazon Acceptable Use Policy</a> and all other Amazon terms. Remember that you must only use the Amazon Kendra web crawler to index your own webpages, or webpages that you have authorization to index.</i> </p>', 'refs' => [ 'Urls$SeedUrlConfiguration' => '<p>Provides the configuration of the seed or starting point URLs of the websites you want to crawl.</p> <p>You can choose to crawl only the website host names, or the website host names with subdomains, or the website host names with subdomains and other domains that the webpages link to.</p> <p>You can list up to 100 seed URLs.</p>', ], ], 'SeedUrlList' => [ 'base' => NULL, 'refs' => [ 'SeedUrlConfiguration$SeedUrls' => '<p>The list of seed or starting point URLs of the websites you want to crawl.</p> <p>The list can include a maximum of 100 seed URLs.</p>', ], ], 'ServerSideEncryptionConfiguration' => [ 'base' => '<p>Provides the identifier of the KMScustomer master key (CMK) used to encrypt data indexed by Amazon Kendra. Amazon Kendra doesn\'t support asymmetric CMKs.</p>', 'refs' => [ 'CreateIndexRequest$ServerSideEncryptionConfiguration' => '<p>The identifier of the KMScustomer managed key (CMK) to use to encrypt data indexed by Amazon Kendra. Amazon Kendra doesn\'t support asymmetric CMKs.</p>', 'DescribeIndexResponse$ServerSideEncryptionConfiguration' => '<p>The identifier of the KMScustomer master key (CMK) used to encrypt your data. Amazon Kendra doesn\'t support asymmetric CMKs.</p>', ], ], 'ServiceNowAuthenticationType' => [ 'base' => NULL, 'refs' => [ 'ServiceNowConfiguration$AuthenticationType' => '<p>Determines the type of authentication used to connect to the ServiceNow instance. If you choose <code>HTTP_BASIC</code>, Amazon Kendra is authenticated using the user name and password provided in the AWS Secrets Manager secret in the <code>SecretArn</code> field. When you choose <code>OAUTH2</code>, Amazon Kendra is authenticated using the OAuth token and secret provided in the Secrets Manager secret, and the user name and password are used to determine which information Amazon Kendra has access to.</p> <p>When you use <code>OAUTH2</code> authentication, you must generate a token and a client secret using the ServiceNow console. For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/data-source-servicenow.html">Using a ServiceNow data source</a>.</p>', ], ], 'ServiceNowBuildVersionType' => [ 'base' => NULL, 'refs' => [ 'ServiceNowConfiguration$ServiceNowBuildVersion' => '<p>The identifier of the release that the ServiceNow host is running. If the host is not running the <code>LONDON</code> release, use <code>OTHERS</code>.</p>', ], ], 'ServiceNowConfiguration' => [ 'base' => '<p>Provides configuration information required to connect to a ServiceNow data source.</p>', 'refs' => [ 'DataSourceConfiguration$ServiceNowConfiguration' => '<p>Provides configuration for data sources that connect to ServiceNow instances.</p>', ], ], 'ServiceNowHostUrl' => [ 'base' => NULL, 'refs' => [ 'ServiceNowConfiguration$HostUrl' => '<p>The ServiceNow instance that the data source connects to. The host endpoint should look like the following: <code>{instance}.service-now.com.</code> </p>', ], ], 'ServiceNowKnowledgeArticleConfiguration' => [ 'base' => '<p>Provides configuration information for crawling knowledge articles in the ServiceNow site.</p>', 'refs' => [ 'ServiceNowConfiguration$KnowledgeArticleConfiguration' => '<p>Provides configuration information for crawling knowledge articles in the ServiceNow site.</p>', ], ], 'ServiceNowKnowledgeArticleFilterQuery' => [ 'base' => NULL, 'refs' => [ 'ServiceNowKnowledgeArticleConfiguration$FilterQuery' => '<p>A query that selects the knowledge articles to index. The query can return articles from multiple knowledge bases, and the knowledge bases can be public or private.</p> <p>The query string must be one generated by the ServiceNow console. For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/servicenow-query.html">Specifying documents to index with a query</a>. </p>', ], ], 'ServiceNowServiceCatalogConfiguration' => [ 'base' => '<p>Provides configuration information for crawling service catalog items in the ServiceNow site</p>', 'refs' => [ 'ServiceNowConfiguration$ServiceCatalogConfiguration' => '<p>Provides configuration information for crawling service catalogs in the ServiceNow site.</p>', ], ], 'ServiceQuotaExceededException' => [ 'base' => '<p/>', 'refs' => [], ], 'SharePointConfiguration' => [ 'base' => '<p>Provides configuration information for connecting to a Microsoft SharePoint data source.</p>', 'refs' => [ 'DataSourceConfiguration$SharePointConfiguration' => '<p>Provides information necessary to create a data source connector for a Microsoft SharePoint site.</p>', ], ], 'SharePointUrlList' => [ 'base' => NULL, 'refs' => [ 'SharePointConfiguration$Urls' => '<p>The URLs of the Microsoft SharePoint site that contains the documents that should be indexed.</p>', ], ], 'SharePointVersion' => [ 'base' => NULL, 'refs' => [ 'SharePointConfiguration$SharePointVersion' => '<p>The version of Microsoft SharePoint that you are using as a data source.</p>', ], ], 'SharedDriveId' => [ 'base' => NULL, 'refs' => [ 'ExcludeSharedDrivesList$member' => NULL, ], ], 'SiteMap' => [ 'base' => NULL, 'refs' => [ 'SiteMapsList$member' => NULL, ], ], 'SiteMapsConfiguration' => [ 'base' => '<p>Provides the configuration information of the sitemap URLs to crawl.</p> <p> <i>When selecting websites to index, you must adhere to the <a href="https://aws.amazon.com/aup/">Amazon Acceptable Use Policy</a> and all other Amazon terms. Remember that you must only use the Amazon Kendra web crawler to index your own webpages, or webpages that you have authorization to index.</i> </p>', 'refs' => [ 'Urls$SiteMapsConfiguration' => '<p>Provides the configuration of the sitemap URLs of the websites you want to crawl.</p> <p>Only URLs belonging to the same website host names are crawled. You can list up to three sitemap URLs.</p>', ], ], 'SiteMapsList' => [ 'base' => NULL, 'refs' => [ 'SiteMapsConfiguration$SiteMaps' => '<p>The list of sitemap URLs of the websites you want to crawl.</p> <p>The list can include a maximum of three sitemap URLs.</p>', ], ], 'SortOrder' => [ 'base' => NULL, 'refs' => [ 'SortingConfiguration$SortOrder' => '<p>The order that the results should be returned in. In case of ties, the relevance assigned to the result by Amazon Kendra is used as the tie-breaker.</p>', ], ], 'SortingConfiguration' => [ 'base' => '<p>Specifies the document attribute to use to sort the response to a Amazon Kendra query. You can specify a single attribute for sorting. The attribute must have the <code>Sortable</code> flag set to <code>true</code>, otherwise Amazon Kendra returns an exception.</p> <p>You can sort attributes of the following types.</p> <ul> <li> <p>Date value</p> </li> <li> <p>Long value</p> </li> <li> <p>String value</p> </li> </ul> <p>You can\'t sort attributes of the following type.</p> <ul> <li> <p>String list value</p> </li> </ul>', 'refs' => [ 'QueryRequest$SortingConfiguration' => '<p>Provides information that determines how the results of the query are sorted. You can set the field that Amazon Kendra should sort the results on, and specify whether the results should be sorted in ascending or descending order. In the case of ties in sorting the results, the results are sorted by relevance.</p> <p>If you don\'t provide sorting configuration, the results are sorted by the relevance that Amazon Kendra determines for the result.</p>', ], ], 'SqlConfiguration' => [ 'base' => '<p>Provides information that configures Amazon Kendra to use a SQL database.</p>', 'refs' => [ 'DatabaseConfiguration$SqlConfiguration' => '<p>Provides information about how Amazon Kendra uses quote marks around SQL identifiers when querying a database data source.</p>', ], ], 'StartDataSourceSyncJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'StartDataSourceSyncJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'Status' => [ 'base' => '<p>Provides information about the status of documents submitted for indexing.</p>', 'refs' => [ 'DocumentStatusList$member' => NULL, ], ], 'StopDataSourceSyncJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'StorageCapacityUnit' => [ 'base' => NULL, 'refs' => [ 'CapacityUnitsConfiguration$StorageCapacityUnits' => '<p>The amount of extra storage capacity for an index. A single capacity unit provides 30 GB of storage space or 100,000 documents, whichever is reached first.</p>', ], ], 'String' => [ 'base' => NULL, 'refs' => [ 'AdditionalResultAttribute$Key' => '<p>The key that identifies the attribute.</p>', 'DataSourceSyncJob$ExecutionId' => '<p>A unique identifier for the synchronization job.</p>', 'DataSourceSyncJob$DataSourceErrorCode' => '<p>If the reason that the synchronization failed is due to an error with the underlying data source, this field contains a code that identifies the error.</p>', 'DocumentAttributeStringListValue$member' => NULL, 'JsonTokenTypeConfiguration$UserNameAttributeField' => '<p>The user name attribute field.</p>', 'JsonTokenTypeConfiguration$GroupAttributeField' => '<p>The group attribute field.</p>', 'StartDataSourceSyncJobResponse$ExecutionId' => '<p>Identifies a particular synchronization job.</p>', 'Status$FailureCode' => '<p>Indicates the source of the error.</p>', 'Status$FailureReason' => '<p>Provides detailed information about why the document couldn\'t be indexed. Use this information to correct the error before you resubmit the document for indexing.</p>', 'SuggestionTextWithHighlights$Text' => '<p>The query suggestion text to display to the user.</p>', 'TextWithHighlights$Text' => '<p>The text to display to the user.</p>', ], ], 'SubmitFeedbackRequest' => [ 'base' => NULL, 'refs' => [], ], 'SubnetId' => [ 'base' => NULL, 'refs' => [ 'SubnetIdList$member' => NULL, ], ], 'SubnetIdList' => [ 'base' => NULL, 'refs' => [ 'DataSourceVpcConfiguration$SubnetIds' => '<p>A list of identifiers for subnets within your Amazon VPC. The subnets should be able to connect to each other in the VPC, and they should have outgoing access to the Internet through a NAT device.</p>', ], ], 'Suggestion' => [ 'base' => '<p>A single query suggestion.</p>', 'refs' => [ 'SuggestionList$member' => NULL, ], ], 'SuggestionHighlight' => [ 'base' => '<p>The text highlights for a single query suggestion.</p>', 'refs' => [ 'SuggestionHighlightList$member' => NULL, ], ], 'SuggestionHighlightList' => [ 'base' => NULL, 'refs' => [ 'SuggestionTextWithHighlights$Highlights' => '<p>The beginning and end of the query suggestion text that should be highlighted.</p>', ], ], 'SuggestionList' => [ 'base' => NULL, 'refs' => [ 'GetQuerySuggestionsResponse$Suggestions' => '<p>A list of query suggestions for an index.</p>', ], ], 'SuggestionQueryText' => [ 'base' => NULL, 'refs' => [ 'GetQuerySuggestionsRequest$QueryText' => '<p>The text of a user\'s query to generate query suggestions.</p> <p>A query is suggested if the query prefix matches what a user starts to type as their query.</p> <p>Amazon Kendra does not show any suggestions if a user types fewer than two characters or more than 60 characters. A query must also have at least one search result and contain at least one word of more than four characters.</p>', ], ], 'SuggestionTextWithHighlights' => [ 'base' => '<p>Provides text and information about where to highlight the query suggestion text.</p>', 'refs' => [ 'SuggestionValue$Text' => '<p>The <code>SuggestionTextWithHighlights</code> structure that contains the query suggestion text and highlights.</p>', ], ], 'SuggestionValue' => [ 'base' => '<p>The <code>SuggestionTextWithHighlights</code> structure information.</p>', 'refs' => [ 'Suggestion$Value' => '<p>The value for the unique UUID (universally unique identifier) of a single query suggestion.</p> <p>The value is the text string of a suggestion.</p>', ], ], 'TableName' => [ 'base' => NULL, 'refs' => [ 'ConnectionConfiguration$TableName' => '<p>The name of the table that contains the document data.</p>', ], ], 'Tag' => [ 'base' => '<p>A list of key/value pairs that identify an index, FAQ, or data source. Tag keys and values can consist of Unicode letters, digits, white space, and any of the following symbols: _ . : / = + - @.</p>', 'refs' => [ 'TagList$member' => NULL, ], ], 'TagKey' => [ 'base' => NULL, 'refs' => [ 'Tag$Key' => '<p>The key for the tag. Keys are not case sensitive and must be unique for the index, FAQ, or data source.</p>', 'TagKeyList$member' => NULL, ], ], 'TagKeyList' => [ 'base' => NULL, 'refs' => [ 'UntagResourceRequest$TagKeys' => '<p>A list of tag keys to remove from the index, FAQ, or data source. If a tag key does not exist on the resource, it is ignored.</p>', ], ], 'TagList' => [ 'base' => NULL, 'refs' => [ 'CreateDataSourceRequest$Tags' => '<p>A list of key-value pairs that identify the data source. You can use the tags to identify and organize your resources and to control access to resources.</p>', 'CreateFaqRequest$Tags' => '<p>A list of key-value pairs that identify the FAQ. You can use the tags to identify and organize your resources and to control access to resources.</p>', 'CreateIndexRequest$Tags' => '<p>A list of key-value pairs that identify the index. You can use the tags to identify and organize your resources and to control access to resources.</p>', 'CreateQuerySuggestionsBlockListRequest$Tags' => '<p>A tag that you can assign to a block list that categorizes the block list.</p>', 'CreateThesaurusRequest$Tags' => '<p>A list of key-value pairs that identify the thesaurus. You can use the tags to identify and organize your resources and to control access to resources. </p>', 'ListTagsForResourceResponse$Tags' => '<p>A list of tags associated with the index, FAQ, or data source.</p>', 'TagResourceRequest$Tags' => '<p>A list of tag keys to add to the index, FAQ, or data source. If a tag already exists, the existing value is replaced with the new value.</p>', ], ], 'TagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'TagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'TagValue' => [ 'base' => NULL, 'refs' => [ 'Tag$Value' => '<p>The value associated with the tag. The value may be an empty string but it can\'t be null.</p>', ], ], 'TenantDomain' => [ 'base' => NULL, 'refs' => [ 'OneDriveConfiguration$TenantDomain' => '<p>The Azure Active Directory domain of the organization. </p>', ], ], 'TextDocumentStatistics' => [ 'base' => '<p>Provides information about text documents indexed in an index.</p>', 'refs' => [ 'IndexStatistics$TextDocumentStatistics' => '<p>The number of text documents indexed.</p>', ], ], 'TextWithHighlights' => [ 'base' => '<p>Provides text and information about where to highlight the text.</p>', 'refs' => [ 'AdditionalResultAttributeValue$TextWithHighlightsValue' => '<p>The text associated with the attribute and information about the highlight to apply to the text.</p>', 'QueryResultItem$DocumentTitle' => '<p>The title of the document. Contains the text of the title and information for highlighting the relevant terms in the title.</p>', 'QueryResultItem$DocumentExcerpt' => '<p>An extract of the text in the document. Contains information about highlighting the relevant terms in the excerpt.</p>', ], ], 'ThesaurusId' => [ 'base' => NULL, 'refs' => [ 'CreateThesaurusResponse$Id' => '<p>The unique identifier of the thesaurus. </p>', 'DeleteThesaurusRequest$Id' => '<p>The identifier of the thesaurus to delete.</p>', 'DescribeThesaurusRequest$Id' => '<p>The identifier of the thesaurus to describe.</p>', 'DescribeThesaurusResponse$Id' => '<p>The identifier of the thesaurus.</p>', 'ThesaurusSummary$Id' => '<p>The identifier of the thesaurus.</p>', 'UpdateThesaurusRequest$Id' => '<p>The identifier of the thesaurus to update.</p>', ], ], 'ThesaurusName' => [ 'base' => NULL, 'refs' => [ 'CreateThesaurusRequest$Name' => '<p>The name for the new thesaurus.</p>', 'DescribeThesaurusResponse$Name' => '<p>The thesaurus name.</p>', 'ThesaurusSummary$Name' => '<p>The name of the thesaurus.</p>', 'UpdateThesaurusRequest$Name' => '<p>The updated name of the thesaurus.</p>', ], ], 'ThesaurusStatus' => [ 'base' => NULL, 'refs' => [ 'DescribeThesaurusResponse$Status' => '<p>The current status of the thesaurus. When the value is <code>ACTIVE</code>, queries are able to use the thesaurus. If the <code>Status</code> field value is <code>FAILED</code>, the <code>ErrorMessage</code> field provides more information. </p> <p>If the status is <code>ACTIVE_BUT_UPDATE_FAILED</code>, it means that Amazon Kendra could not ingest the new thesaurus file. The old thesaurus file is still active. </p>', 'ThesaurusSummary$Status' => '<p>The status of the thesaurus.</p>', ], ], 'ThesaurusSummary' => [ 'base' => '<p>An array of summary information for one or more thesauruses.</p>', 'refs' => [ 'ThesaurusSummaryItems$member' => NULL, ], ], 'ThesaurusSummaryItems' => [ 'base' => NULL, 'refs' => [ 'ListThesauriResponse$ThesaurusSummaryItems' => '<p>An array of summary information for one or more thesauruses.</p>', ], ], 'ThrottlingException' => [ 'base' => '<p/>', 'refs' => [], ], 'TimeRange' => [ 'base' => '<p>Provides a range of time.</p>', 'refs' => [ 'ListDataSourceSyncJobsRequest$StartTimeFilter' => '<p>When specified, the synchronization jobs returned in the list are limited to jobs between the specified dates. </p>', ], ], 'Timestamp' => [ 'base' => NULL, 'refs' => [ 'ClickFeedback$ClickTime' => '<p>The Unix timestamp of the date and time that the result was clicked.</p>', 'DataSourceSummary$CreatedAt' => '<p>The UNIX datetime that the data source was created.</p>', 'DataSourceSummary$UpdatedAt' => '<p>The UNIX datetime that the data source was lasted updated. </p>', 'DataSourceSyncJob$StartTime' => '<p>The UNIX datetime that the synchronization job was started.</p>', 'DataSourceSyncJob$EndTime' => '<p>The UNIX datetime that the synchronization job was completed.</p>', 'DescribeDataSourceResponse$CreatedAt' => '<p>The Unix timestamp of when the data source was created.</p>', 'DescribeDataSourceResponse$UpdatedAt' => '<p>The Unix timestamp of when the data source was last updated.</p>', 'DescribeFaqResponse$CreatedAt' => '<p>The date and time that the FAQ was created.</p>', 'DescribeFaqResponse$UpdatedAt' => '<p>The date and time that the FAQ was last updated.</p>', 'DescribeIndexResponse$CreatedAt' => '<p>The Unix datetime that the index was created.</p>', 'DescribeIndexResponse$UpdatedAt' => '<p>The Unix datetime that the index was last updated.</p>', 'DescribeQuerySuggestionsBlockListResponse$CreatedAt' => '<p>Shows the date-time a block list for query suggestions was last created.</p>', 'DescribeQuerySuggestionsBlockListResponse$UpdatedAt' => '<p>Shows the date-time a block list for query suggestions was last updated.</p>', 'DescribeQuerySuggestionsConfigResponse$LastSuggestionsBuildTime' => '<p>Shows the date-time query suggestions for an index was last updated.</p>', 'DescribeQuerySuggestionsConfigResponse$LastClearTime' => '<p>Shows the date-time query suggestions for an index was last cleared.</p> <p>After you clear suggestions, Amazon Kendra learns new suggestions based on new queries added to the query log from the time you cleared suggestions. Amazon Kendra only considers re-occurences of a query from the time you cleared suggestions. </p>', 'DescribeThesaurusResponse$CreatedAt' => '<p>The Unix datetime that the thesaurus was created.</p>', 'DescribeThesaurusResponse$UpdatedAt' => '<p>The Unix datetime that the thesaurus was last updated.</p>', 'DocumentAttributeValue$DateValue' => '<p>A date expressed as an ISO 8601 string.</p> <p>It is important for the time zone to be included in the ISO 8601 date-time format. For example, 20120325T123010+01:00 is the ISO 8601 date-time format for March 25th 2012 at 12:30PM (plus 10 seconds) in Central European Time.</p>', 'FaqSummary$CreatedAt' => '<p>The UNIX datetime that the FAQ was added to the index.</p>', 'FaqSummary$UpdatedAt' => '<p>The UNIX datetime that the FAQ was last updated.</p>', 'GroupOrderingIdSummary$LastUpdatedAt' => '<p>The last date-time an action was updated. An action can be a <code>PUT</code> or <code>DELETE</code> action for mapping users to their groups.</p>', 'GroupOrderingIdSummary$ReceivedAt' => '<p>The date-time an action was received by Amazon Kendra. An action can be a <code>PUT</code> or <code>DELETE</code> action for mapping users to their groups.</p>', 'IndexConfigurationSummary$CreatedAt' => '<p>The Unix timestamp when the index was created.</p>', 'IndexConfigurationSummary$UpdatedAt' => '<p>The Unix timestamp when the index was last updated by the <code>UpdateIndex</code> operation.</p>', 'QuerySuggestionsBlockListSummary$CreatedAt' => '<p>The date-time summary information for a query suggestions block list was last created.</p>', 'QuerySuggestionsBlockListSummary$UpdatedAt' => '<p>The date-time the block list was last updated.</p>', 'ThesaurusSummary$CreatedAt' => '<p>The Unix datetime that the thesaurus was created.</p>', 'ThesaurusSummary$UpdatedAt' => '<p>The Unix datetime that the thesaurus was last updated.</p>', 'TimeRange$StartTime' => '<p>The UNIX datetime of the beginning of the time range.</p>', 'TimeRange$EndTime' => '<p>The UNIX datetime of the end of the time range.</p>', ], ], 'Title' => [ 'base' => NULL, 'refs' => [ 'Document$Title' => '<p>The title of the document.</p>', ], ], 'Token' => [ 'base' => NULL, 'refs' => [ 'UserContext$Token' => '<p>The user context token for filtering search results for a user. It must be a JWT or a JSON token.</p>', ], ], 'UntagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'UntagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateDataSourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateIndexRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateQuerySuggestionsBlockListRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateQuerySuggestionsConfigRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateThesaurusRequest' => [ 'base' => NULL, 'refs' => [], ], 'Url' => [ 'base' => NULL, 'refs' => [ 'ConfluenceConfiguration$ServerUrl' => '<p>The URL of your Confluence instance. Use the full URL of the server. For example, <code>https://server.example.com:port/</code>. You can also use an IP address, for example, <code>https://192.168.1.113/</code>.</p>', 'JwtTokenTypeConfiguration$URL' => '<p>The signing key URL.</p>', 'QueryResultItem$DocumentURI' => '<p>The URI of the original location of the document.</p>', 'SalesforceConfiguration$ServerUrl' => '<p>The instance URL for the Salesforce site that you want to index.</p>', 'SharePointUrlList$member' => NULL, ], ], 'Urls' => [ 'base' => '<p>Provides the configuration information of the URLs to crawl.</p> <p> <i>When selecting websites to index, you must adhere to the <a href="https://aws.amazon.com/aup/">Amazon Acceptable Use Policy</a> and all other Amazon terms. Remember that you must only use the Amazon Kendra web crawler to index your own webpages, or webpages that you have authorization to index.</i> </p>', 'refs' => [ 'WebCrawlerConfiguration$Urls' => '<p>Specifies the seed or starting point URLs of the websites or the sitemap URLs of the websites you want to crawl.</p> <p>You can include website subdomains. You can list up to 100 seed URLs and up to three sitemap URLs.</p> <p> <i>When selecting websites to index, you must adhere to the <a href="https://aws.amazon.com/aup/">Amazon Acceptable Use Policy</a> and all other Amazon terms. Remember that you must only use the Amazon Kendra web crawler to index your own webpages, or webpages that you have authorization to index.</i> </p>', ], ], 'UserAccount' => [ 'base' => NULL, 'refs' => [ 'ExcludeUserAccountsList$member' => NULL, ], ], 'UserContext' => [ 'base' => '<p>Provides information about the user context for a Amazon Kendra index.</p> <p>This is used for filtering search results for different users based on their access to documents.</p> <p>You provide one of the following:</p> <ul> <li> <p>User token</p> </li> <li> <p>User ID, the groups the user belongs to, and the data sources the groups can access</p> </li> </ul> <p>If you provide both, an exception is thrown.</p>', 'refs' => [ 'QueryRequest$UserContext' => '<p>The user context token.</p>', ], ], 'UserContextPolicy' => [ 'base' => NULL, 'refs' => [ 'CreateIndexRequest$UserContextPolicy' => '<p>The user context policy.</p> <dl> <dt>ATTRIBUTE_FILTER</dt> <dd> <p>All indexed content is searchable and displayable for all users. If there is an access control list, it is ignored. You can filter on user and group attributes. </p> </dd> <dt>USER_TOKEN</dt> <dd> <p>Enables SSO and token-based user access control. All documents with no access control and all documents accessible to the user will be searchable and displayable. </p> </dd> </dl>', 'DescribeIndexResponse$UserContextPolicy' => '<p>The user context policy for the Amazon Kendra index.</p>', 'UpdateIndexRequest$UserContextPolicy' => '<p>The user user token context policy.</p>', ], ], 'UserId' => [ 'base' => NULL, 'refs' => [ 'MemberUser$UserId' => '<p>The identifier of the user you want to map to a group.</p>', ], ], 'UserNameAttributeField' => [ 'base' => NULL, 'refs' => [ 'JwtTokenTypeConfiguration$UserNameAttributeField' => '<p>The user name attribute field.</p>', ], ], 'UserTokenConfiguration' => [ 'base' => '<p>Provides configuration information for a token configuration.</p>', 'refs' => [ 'UserTokenConfigurationList$member' => NULL, ], ], 'UserTokenConfigurationList' => [ 'base' => NULL, 'refs' => [ 'CreateIndexRequest$UserTokenConfigurations' => '<p>The user token configuration.</p>', 'DescribeIndexResponse$UserTokenConfigurations' => '<p>The user token configuration for the Amazon Kendra index.</p>', 'UpdateIndexRequest$UserTokenConfigurations' => '<p>The user token configuration.</p>', ], ], 'ValidationException' => [ 'base' => '<p/>', 'refs' => [], ], 'ValueImportanceMap' => [ 'base' => NULL, 'refs' => [ 'Relevance$ValueImportanceMap' => '<p>A list of values that should be given a different boost when they appear in the result list. For example, if you are boosting a field called "department," query terms that match the department field are boosted in the result. However, you can add entries from the department field to boost documents with those values higher. </p> <p>For example, you can add entries to the map with names of departments. If you add "HR",5 and "Legal",3 those departments are given special attention when they appear in the metadata of a document. When those terms appear they are given the specified importance instead of the regular importance for the boost.</p>', ], ], 'ValueImportanceMapKey' => [ 'base' => NULL, 'refs' => [ 'ValueImportanceMap$key' => NULL, ], ], 'VisitorId' => [ 'base' => NULL, 'refs' => [ 'QueryRequest$VisitorId' => '<p>Provides an identifier for a specific user. The <code>VisitorId</code> should be a unique identifier, such as a GUID. Don\'t use personally identifiable information, such as the user\'s email address, as the <code>VisitorId</code>.</p>', ], ], 'VpcSecurityGroupId' => [ 'base' => NULL, 'refs' => [ 'SecurityGroupIdList$member' => NULL, ], ], 'WebCrawlerConfiguration' => [ 'base' => '<p>Provides the configuration information required for Amazon Kendra web crawler.</p>', 'refs' => [ 'DataSourceConfiguration$WebCrawlerConfiguration' => NULL, ], ], 'WebCrawlerMode' => [ 'base' => NULL, 'refs' => [ 'SeedUrlConfiguration$WebCrawlerMode' => '<p>You can choose one of the following modes:</p> <ul> <li> <p> <code>HOST_ONLY</code> – crawl only the website host names. For example, if the seed URL is "abc.example.com", then only URLs with host name "abc.example.com" are crawled.</p> </li> <li> <p> <code>SUBDOMAINS</code> – crawl the website host names with subdomains. For example, if the seed URL is "abc.example.com", then "a.abc.example.com" and "b.abc.example.com" are also crawled.</p> </li> <li> <p> <code>EVERYTHING</code> – crawl the website host names with subdomains and other domains that the webpages link to.</p> </li> </ul> <p>The default mode is set to <code>HOST_ONLY</code>.</p>', ], ], 'WorkDocsConfiguration' => [ 'base' => '<p>Provides the configuration information to connect to Amazon WorkDocs as your data source.</p> <p>Amazon WorkDocs connector is available in Oregon, North Virginia, Sydney, Singapore and Ireland regions.</p>', 'refs' => [ 'DataSourceConfiguration$WorkDocsConfiguration' => '<p>Provides the configuration information to connect to WorkDocs as your data source.</p>', ], ], ],];
