<?php
// This file was auto-generated from sdk-root/src/data/compute-optimizer/2019-11-01/docs-2.json
return [ 'version' => '2.0', 'service' => '<p>Compute Optimizer is a service that analyzes the configuration and utilization metrics of your Amazon Web Services compute resources, such as Amazon EC2 instances, Amazon EC2 Auto Scaling groups, Lambda functions, and Amazon EBS volumes. It reports whether your resources are optimal, and generates optimization recommendations to reduce the cost and improve the performance of your workloads. Compute Optimizer also provides recent utilization metric data, in addition to projected utilization metric data for the recommendations, which you can use to evaluate which recommendation provides the best price-performance trade-off. The analysis of your usage patterns can help you decide when to move or resize your running resources, and still meet your performance and capacity requirements. For more information about Compute Optimizer, including the required permissions to use the service, see the <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/">Compute Optimizer User Guide</a>.</p>', 'operations' => [ 'DescribeRecommendationExportJobs' => '<p>Describes recommendation export jobs created in the last seven days.</p> <p>Use the <a>ExportAutoScalingGroupRecommendations</a> or <a>ExportEC2InstanceRecommendations</a> actions to request an export of your recommendations. Then use the <a>DescribeRecommendationExportJobs</a> action to view your export jobs.</p>', 'ExportAutoScalingGroupRecommendations' => '<p>Exports optimization recommendations for Auto Scaling groups.</p> <p>Recommendations are exported in a comma-separated values (.csv) file, and its metadata in a JavaScript Object Notation (JSON) (.json) file, to an existing Amazon Simple Storage Service (Amazon S3) bucket that you specify. For more information, see <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/exporting-recommendations.html">Exporting Recommendations</a> in the <i>Compute Optimizer User Guide</i>.</p> <p>You can have only one Auto Scaling group export job in progress per Amazon Web Services Region.</p>', 'ExportEBSVolumeRecommendations' => '<p>Exports optimization recommendations for Amazon EBS volumes.</p> <p>Recommendations are exported in a comma-separated values (.csv) file, and its metadata in a JavaScript Object Notation (JSON) (.json) file, to an existing Amazon Simple Storage Service (Amazon S3) bucket that you specify. For more information, see <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/exporting-recommendations.html">Exporting Recommendations</a> in the <i>Compute Optimizer User Guide</i>.</p> <p>You can have only one Amazon EBS volume export job in progress per Amazon Web Services Region.</p>', 'ExportEC2InstanceRecommendations' => '<p>Exports optimization recommendations for Amazon EC2 instances.</p> <p>Recommendations are exported in a comma-separated values (.csv) file, and its metadata in a JavaScript Object Notation (JSON) (.json) file, to an existing Amazon Simple Storage Service (Amazon S3) bucket that you specify. For more information, see <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/exporting-recommendations.html">Exporting Recommendations</a> in the <i>Compute Optimizer User Guide</i>.</p> <p>You can have only one Amazon EC2 instance export job in progress per Amazon Web Services Region.</p>', 'ExportLambdaFunctionRecommendations' => '<p>Exports optimization recommendations for Lambda functions.</p> <p>Recommendations are exported in a comma-separated values (.csv) file, and its metadata in a JavaScript Object Notation (JSON) (.json) file, to an existing Amazon Simple Storage Service (Amazon S3) bucket that you specify. For more information, see <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/exporting-recommendations.html">Exporting Recommendations</a> in the <i>Compute Optimizer User Guide</i>.</p> <p>You can have only one Lambda function export job in progress per Amazon Web Services Region.</p>', 'GetAutoScalingGroupRecommendations' => '<p>Returns Auto Scaling group recommendations.</p> <p>Compute Optimizer generates recommendations for Amazon EC2 Auto Scaling groups that meet a specific set of requirements. For more information, see the <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/requirements.html">Supported resources and requirements</a> in the <i>Compute Optimizer User Guide</i>.</p>', 'GetEBSVolumeRecommendations' => '<p>Returns Amazon Elastic Block Store (Amazon EBS) volume recommendations.</p> <p>Compute Optimizer generates recommendations for Amazon EBS volumes that meet a specific set of requirements. For more information, see the <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/requirements.html">Supported resources and requirements</a> in the <i>Compute Optimizer User Guide</i>.</p>', 'GetEC2InstanceRecommendations' => '<p>Returns Amazon EC2 instance recommendations.</p> <p>Compute Optimizer generates recommendations for Amazon Elastic Compute Cloud (Amazon EC2) instances that meet a specific set of requirements. For more information, see the <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/requirements.html">Supported resources and requirements</a> in the <i>Compute Optimizer User Guide</i>.</p>', 'GetEC2RecommendationProjectedMetrics' => '<p>Returns the projected utilization metrics of Amazon EC2 instance recommendations.</p> <note> <p>The <code>Cpu</code> and <code>Memory</code> metrics are the only projected utilization metrics returned when you run this action. Additionally, the <code>Memory</code> metric is returned only for resources that have the unified CloudWatch agent installed on them. For more information, see <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/metrics.html#cw-agent">Enabling Memory Utilization with the CloudWatch Agent</a>.</p> </note>', 'GetEnrollmentStatus' => '<p>Returns the enrollment (opt in) status of an account to the Compute Optimizer service.</p> <p>If the account is the management account of an organization, this action also confirms the enrollment status of member accounts of the organization. Use the <a>GetEnrollmentStatusesForOrganization</a> action to get detailed information about the enrollment status of member accounts of an organization.</p>', 'GetEnrollmentStatusesForOrganization' => '<p>Returns the Compute Optimizer enrollment (opt-in) status of organization member accounts, if your account is an organization management account.</p> <p>To get the enrollment status of standalone accounts, use the <a>GetEnrollmentStatus</a> action.</p>', 'GetLambdaFunctionRecommendations' => '<p>Returns Lambda function recommendations.</p> <p>Compute Optimizer generates recommendations for functions that meet a specific set of requirements. For more information, see the <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/requirements.html">Supported resources and requirements</a> in the <i>Compute Optimizer User Guide</i>.</p>', 'GetRecommendationSummaries' => '<p>Returns the optimization findings for an account.</p> <p>It returns the number of:</p> <ul> <li> <p>Amazon EC2 instances in an account that are <code>Underprovisioned</code>, <code>Overprovisioned</code>, or <code>Optimized</code>.</p> </li> <li> <p>Auto Scaling groups in an account that are <code>NotOptimized</code>, or <code>Optimized</code>.</p> </li> <li> <p>Amazon EBS volumes in an account that are <code>NotOptimized</code>, or <code>Optimized</code>.</p> </li> <li> <p>Lambda functions in an account that are <code>NotOptimized</code>, or <code>Optimized</code>.</p> </li> </ul>', 'UpdateEnrollmentStatus' => '<p>Updates the enrollment (opt in and opt out) status of an account to the Compute Optimizer service.</p> <p>If the account is a management account of an organization, this action can also be used to enroll member accounts of the organization.</p> <p>You must have the appropriate permissions to opt in to Compute Optimizer, to view its recommendations, and to opt out. For more information, see <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/security-iam.html">Controlling access with Amazon Web Services Identity and Access Management</a> in the <i>Compute Optimizer User Guide</i>.</p> <p>When you opt in, Compute Optimizer automatically creates a service-linked role in your account to access its data. For more information, see <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/using-service-linked-roles.html">Using Service-Linked Roles for Compute Optimizer</a> in the <i>Compute Optimizer User Guide</i>.</p>', ], 'shapes' => [ 'AccessDeniedException' => [ 'base' => '<p>You do not have sufficient access to perform this action.</p>', 'refs' => [], ], 'AccountEnrollmentStatus' => [ 'base' => '<p>Describes the enrollment status of an organization\'s member accounts in Compute Optimizer.</p>', 'refs' => [ 'AccountEnrollmentStatuses$member' => NULL, ], ], 'AccountEnrollmentStatuses' => [ 'base' => NULL, 'refs' => [ 'GetEnrollmentStatusesForOrganizationResponse$accountEnrollmentStatuses' => '<p>An array of objects that describe the enrollment statuses of organization member accounts.</p>', ], ], 'AccountId' => [ 'base' => NULL, 'refs' => [ 'AccountEnrollmentStatus$accountId' => '<p>The Amazon Web Services account ID.</p>', 'AccountIds$member' => NULL, 'AutoScalingGroupRecommendation$accountId' => '<p>The Amazon Web Services account ID of the Auto Scaling group.</p>', 'InstanceRecommendation$accountId' => '<p>The Amazon Web Services account ID of the instance.</p>', 'LambdaFunctionRecommendation$accountId' => '<p>The Amazon Web Services account ID of the function.</p>', 'RecommendationSummary$accountId' => '<p>The Amazon Web Services account ID of the recommendation summary.</p>', 'VolumeRecommendation$accountId' => '<p>The Amazon Web Services account ID of the volume.</p>', ], ], 'AccountIds' => [ 'base' => NULL, 'refs' => [ 'ExportAutoScalingGroupRecommendationsRequest$accountIds' => '<p>The IDs of the Amazon Web Services accounts for which to export Auto Scaling group recommendations.</p> <p>If your account is the management account of an organization, use this parameter to specify the member account for which you want to export recommendations.</p> <p>This parameter cannot be specified together with the include member accounts parameter. The parameters are mutually exclusive.</p> <p>Recommendations for member accounts are not included in the export if this parameter, or the include member accounts parameter, is omitted.</p> <p>You can specify multiple account IDs per request.</p>', 'ExportEBSVolumeRecommendationsRequest$accountIds' => '<p>The IDs of the Amazon Web Services accounts for which to export Amazon EBS volume recommendations.</p> <p>If your account is the management account of an organization, use this parameter to specify the member account for which you want to export recommendations.</p> <p>This parameter cannot be specified together with the include member accounts parameter. The parameters are mutually exclusive.</p> <p>Recommendations for member accounts are not included in the export if this parameter, or the include member accounts parameter, is omitted.</p> <p>You can specify multiple account IDs per request.</p>', 'ExportEC2InstanceRecommendationsRequest$accountIds' => '<p>The IDs of the Amazon Web Services accounts for which to export instance recommendations.</p> <p>If your account is the management account of an organization, use this parameter to specify the member account for which you want to export recommendations.</p> <p>This parameter cannot be specified together with the include member accounts parameter. The parameters are mutually exclusive.</p> <p>Recommendations for member accounts are not included in the export if this parameter, or the include member accounts parameter, is omitted.</p> <p>You can specify multiple account IDs per request.</p>', 'ExportLambdaFunctionRecommendationsRequest$accountIds' => '<p>The IDs of the Amazon Web Services accounts for which to export Lambda function recommendations.</p> <p>If your account is the management account of an organization, use this parameter to specify the member account for which you want to export recommendations.</p> <p>This parameter cannot be specified together with the include member accounts parameter. The parameters are mutually exclusive.</p> <p>Recommendations for member accounts are not included in the export if this parameter, or the include member accounts parameter, is omitted.</p> <p>You can specify multiple account IDs per request.</p>', 'GetAutoScalingGroupRecommendationsRequest$accountIds' => '<p>The ID of the Amazon Web Services account for which to return Auto Scaling group recommendations.</p> <p>If your account is the management account of an organization, use this parameter to specify the member account for which you want to return Auto Scaling group recommendations.</p> <p>Only one account ID can be specified per request.</p>', 'GetEBSVolumeRecommendationsRequest$accountIds' => '<p>The ID of the Amazon Web Services account for which to return volume recommendations.</p> <p>If your account is the management account of an organization, use this parameter to specify the member account for which you want to return volume recommendations.</p> <p>Only one account ID can be specified per request.</p>', 'GetEC2InstanceRecommendationsRequest$accountIds' => '<p>The ID of the Amazon Web Services account for which to return instance recommendations.</p> <p>If your account is the management account of an organization, use this parameter to specify the member account for which you want to return instance recommendations.</p> <p>Only one account ID can be specified per request.</p>', 'GetLambdaFunctionRecommendationsRequest$accountIds' => '<p>The ID of the Amazon Web Services account for which to return function recommendations.</p> <p>If your account is the management account of an organization, use this parameter to specify the member account for which you want to return function recommendations.</p> <p>Only one account ID can be specified per request.</p>', 'GetRecommendationSummariesRequest$accountIds' => '<p>The ID of the Amazon Web Services account for which to return recommendation summaries.</p> <p>If your account is the management account of an organization, use this parameter to specify the member account for which you want to return recommendation summaries.</p> <p>Only one account ID can be specified per request.</p>', ], ], 'AutoScalingGroupArn' => [ 'base' => NULL, 'refs' => [ 'AutoScalingGroupArns$member' => NULL, 'AutoScalingGroupRecommendation$autoScalingGroupArn' => '<p>The Amazon Resource Name (ARN) of the Auto Scaling group.</p>', ], ], 'AutoScalingGroupArns' => [ 'base' => NULL, 'refs' => [ 'GetAutoScalingGroupRecommendationsRequest$autoScalingGroupArns' => '<p>The Amazon Resource Name (ARN) of the Auto Scaling groups for which to return recommendations.</p>', ], ], 'AutoScalingGroupConfiguration' => [ 'base' => '<p>Describes the configuration of an Auto Scaling group.</p>', 'refs' => [ 'AutoScalingGroupRecommendation$currentConfiguration' => '<p>An array of objects that describe the current configuration of the Auto Scaling group.</p>', 'AutoScalingGroupRecommendationOption$configuration' => '<p>An array of objects that describe an Auto Scaling group configuration.</p>', ], ], 'AutoScalingGroupName' => [ 'base' => NULL, 'refs' => [ 'AutoScalingGroupRecommendation$autoScalingGroupName' => '<p>The name of the Auto Scaling group.</p>', ], ], 'AutoScalingGroupRecommendation' => [ 'base' => '<p>Describes an Auto Scaling group recommendation.</p>', 'refs' => [ 'AutoScalingGroupRecommendations$member' => NULL, ], ], 'AutoScalingGroupRecommendationOption' => [ 'base' => '<p>Describes a recommendation option for an Auto Scaling group.</p>', 'refs' => [ 'AutoScalingGroupRecommendationOptions$member' => NULL, ], ], 'AutoScalingGroupRecommendationOptions' => [ 'base' => NULL, 'refs' => [ 'AutoScalingGroupRecommendation$recommendationOptions' => '<p>An array of objects that describe the recommendation options for the Auto Scaling group.</p>', ], ], 'AutoScalingGroupRecommendations' => [ 'base' => NULL, 'refs' => [ 'GetAutoScalingGroupRecommendationsResponse$autoScalingGroupRecommendations' => '<p>An array of objects that describe Auto Scaling group recommendations.</p>', ], ], 'Code' => [ 'base' => NULL, 'refs' => [ 'GetRecommendationError$code' => '<p>The error code.</p>', ], ], 'CpuVendorArchitecture' => [ 'base' => NULL, 'refs' => [ 'CpuVendorArchitectures$member' => NULL, ], ], 'CpuVendorArchitectures' => [ 'base' => NULL, 'refs' => [ 'RecommendationPreferences$cpuVendorArchitectures' => '<p>Specifies the CPU vendor and architecture for Amazon EC2 instance and Auto Scaling group recommendations.</p> <p>For example, when you specify <code>AWS_ARM64</code> with:</p> <ul> <li> <p>A <a>GetEC2InstanceRecommendations</a> or <a>GetAutoScalingGroupRecommendations</a> request, Compute Optimizer returns recommendations that consist of Graviton2 instance types only.</p> </li> <li> <p>A <a>GetEC2RecommendationProjectedMetrics</a> request, Compute Optimizer returns projected utilization metrics for Graviton2 instance type recommendations only.</p> </li> <li> <p>A <a>ExportEC2InstanceRecommendations</a> or <a>ExportAutoScalingGroupRecommendations</a> request, Compute Optimizer exports recommendations that consist of Graviton2 instance types only.</p> </li> </ul>', ], ], 'CreationTimestamp' => [ 'base' => NULL, 'refs' => [ 'RecommendationExportJob$creationTimestamp' => '<p>The timestamp of when the export job was created.</p>', ], ], 'CurrentInstanceType' => [ 'base' => NULL, 'refs' => [ 'InstanceRecommendation$currentInstanceType' => '<p>The instance type of the current instance.</p>', ], ], 'DescribeRecommendationExportJobsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeRecommendationExportJobsResponse' => [ 'base' => NULL, 'refs' => [], ], 'DesiredCapacity' => [ 'base' => NULL, 'refs' => [ 'AutoScalingGroupConfiguration$desiredCapacity' => '<p>The desired capacity, or number of instances, for the Auto Scaling group.</p>', ], ], 'DestinationBucket' => [ 'base' => NULL, 'refs' => [ 'S3Destination$bucket' => '<p>The name of the Amazon S3 bucket used as the destination of an export file.</p>', 'S3DestinationConfig$bucket' => '<p>The name of the Amazon S3 bucket to use as the destination for an export job.</p>', ], ], 'DestinationKey' => [ 'base' => NULL, 'refs' => [ 'S3Destination$key' => '<p>The Amazon S3 bucket key of an export file.</p> <p>The key uniquely identifies the object, or export file, in the S3 bucket.</p>', ], ], 'DestinationKeyPrefix' => [ 'base' => NULL, 'refs' => [ 'S3DestinationConfig$keyPrefix' => '<p>The Amazon S3 bucket prefix for an export job.</p>', ], ], 'EBSFilter' => [ 'base' => '<p>Describes a filter that returns a more specific list of Amazon Elastic Block Store (Amazon EBS) volume recommendations. Use this filter with the <a>GetEBSVolumeRecommendations</a> action.</p> <p>You can use <code>LambdaFunctionRecommendationFilter</code> with the <a>GetLambdaFunctionRecommendations</a> action, <code>JobFilter</code> with the <a>DescribeRecommendationExportJobs</a> action, and <code>Filter</code> with the <a>GetAutoScalingGroupRecommendations</a> and <a>GetEC2InstanceRecommendations</a> actions.</p>', 'refs' => [ 'EBSFilters$member' => NULL, ], ], 'EBSFilterName' => [ 'base' => NULL, 'refs' => [ 'EBSFilter$name' => '<p>The name of the filter.</p> <p>Specify <code>Finding</code> to return recommendations with a specific finding classification (for example, <code>NotOptimized</code>).</p>', ], ], 'EBSFilters' => [ 'base' => NULL, 'refs' => [ 'ExportEBSVolumeRecommendationsRequest$filters' => '<p>An array of objects to specify a filter that exports a more specific set of Amazon EBS volume recommendations.</p>', 'GetEBSVolumeRecommendationsRequest$filters' => '<p>An array of objects to specify a filter that returns a more specific list of volume recommendations.</p>', ], ], 'EBSFinding' => [ 'base' => NULL, 'refs' => [ 'VolumeRecommendation$finding' => '<p>The finding classification of the volume.</p> <p>Findings for volumes include:</p> <ul> <li> <p> <b> <code>NotOptimized</code> </b>—A volume is considered not optimized when Compute Optimizer identifies a recommendation that can provide better performance for your workload.</p> </li> <li> <p> <b> <code>Optimized</code> </b>—An volume is considered optimized when Compute Optimizer determines that the volume is correctly provisioned to run your workload based on the chosen volume type. For optimized resources, Compute Optimizer might recommend a new generation volume type.</p> </li> </ul>', ], ], 'EBSMetricName' => [ 'base' => NULL, 'refs' => [ 'EBSUtilizationMetric$name' => '<p>The name of the utilization metric.</p> <p>The following utilization metrics are available:</p> <ul> <li> <p> <code>VolumeReadOpsPerSecond</code> - The completed read operations per second from the volume in a specified period of time.</p> <p>Unit: Count</p> </li> <li> <p> <code>VolumeWriteOpsPerSecond</code> - The completed write operations per second to the volume in a specified period of time.</p> <p>Unit: Count</p> </li> <li> <p> <code>VolumeReadBytesPerSecond</code> - The bytes read per second from the volume in a specified period of time.</p> <p>Unit: Bytes</p> </li> <li> <p> <code>VolumeWriteBytesPerSecond</code> - The bytes written to the volume in a specified period of time.</p> <p>Unit: Bytes</p> </li> </ul>', ], ], 'EBSUtilizationMetric' => [ 'base' => '<p>Describes a utilization metric of an Amazon Elastic Block Store (Amazon EBS) volume.</p> <p>Compare the utilization metric data of your resource against its projected utilization metric data to determine the performance difference between your current resource and the recommended option.</p>', 'refs' => [ 'EBSUtilizationMetrics$member' => NULL, ], ], 'EBSUtilizationMetrics' => [ 'base' => NULL, 'refs' => [ 'VolumeRecommendation$utilizationMetrics' => '<p>An array of objects that describe the utilization metrics of the volume.</p>', ], ], 'EnrollmentFilter' => [ 'base' => '<p>Describes a filter that returns a more specific list of account enrollment statuses. Use this filter with the <a>GetEnrollmentStatusesForOrganization</a> action.</p>', 'refs' => [ 'EnrollmentFilters$member' => NULL, ], ], 'EnrollmentFilterName' => [ 'base' => NULL, 'refs' => [ 'EnrollmentFilter$name' => '<p>The name of the filter.</p> <p>Specify <code>Status</code> to return accounts with a specific enrollment status (for example, <code>Active</code>).</p>', ], ], 'EnrollmentFilters' => [ 'base' => NULL, 'refs' => [ 'GetEnrollmentStatusesForOrganizationRequest$filters' => '<p>An array of objects to specify a filter that returns a more specific list of account enrollment statuses.</p>', ], ], 'ErrorMessage' => [ 'base' => NULL, 'refs' => [ 'AccessDeniedException$message' => NULL, 'InternalServerException$message' => NULL, 'InvalidParameterValueException$message' => NULL, 'LimitExceededException$message' => NULL, 'MissingAuthenticationToken$message' => NULL, 'OptInRequiredException$message' => NULL, 'ResourceNotFoundException$message' => NULL, 'ServiceUnavailableException$message' => NULL, 'ThrottlingException$message' => NULL, ], ], 'ExportAutoScalingGroupRecommendationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ExportAutoScalingGroupRecommendationsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ExportDestination' => [ 'base' => '<p>Describes the destination of the recommendations export and metadata files.</p>', 'refs' => [ 'RecommendationExportJob$destination' => '<p>An object that describes the destination of the export file.</p>', ], ], 'ExportEBSVolumeRecommendationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ExportEBSVolumeRecommendationsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ExportEC2InstanceRecommendationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ExportEC2InstanceRecommendationsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ExportLambdaFunctionRecommendationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ExportLambdaFunctionRecommendationsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ExportableAutoScalingGroupField' => [ 'base' => NULL, 'refs' => [ 'ExportableAutoScalingGroupFields$member' => NULL, ], ], 'ExportableAutoScalingGroupFields' => [ 'base' => NULL, 'refs' => [ 'ExportAutoScalingGroupRecommendationsRequest$fieldsToExport' => '<p>The recommendations data to include in the export file. For more information about the fields that can be exported, see <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/exporting-recommendations.html#exported-files">Exported files</a> in the <i>Compute Optimizer User Guide</i>.</p>', ], ], 'ExportableInstanceField' => [ 'base' => NULL, 'refs' => [ 'ExportableInstanceFields$member' => NULL, ], ], 'ExportableInstanceFields' => [ 'base' => NULL, 'refs' => [ 'ExportEC2InstanceRecommendationsRequest$fieldsToExport' => '<p>The recommendations data to include in the export file. For more information about the fields that can be exported, see <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/exporting-recommendations.html#exported-files">Exported files</a> in the <i>Compute Optimizer User Guide</i>.</p>', ], ], 'ExportableLambdaFunctionField' => [ 'base' => NULL, 'refs' => [ 'ExportableLambdaFunctionFields$member' => NULL, ], ], 'ExportableLambdaFunctionFields' => [ 'base' => NULL, 'refs' => [ 'ExportLambdaFunctionRecommendationsRequest$fieldsToExport' => '<p>The recommendations data to include in the export file. For more information about the fields that can be exported, see <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/exporting-recommendations.html#exported-files">Exported files</a> in the <i>Compute Optimizer User Guide</i>.</p>', ], ], 'ExportableVolumeField' => [ 'base' => NULL, 'refs' => [ 'ExportableVolumeFields$member' => NULL, ], ], 'ExportableVolumeFields' => [ 'base' => NULL, 'refs' => [ 'ExportEBSVolumeRecommendationsRequest$fieldsToExport' => '<p>The recommendations data to include in the export file. For more information about the fields that can be exported, see <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/exporting-recommendations.html#exported-files">Exported files</a> in the <i>Compute Optimizer User Guide</i>.</p>', ], ], 'FailureReason' => [ 'base' => NULL, 'refs' => [ 'RecommendationExportJob$failureReason' => '<p>The reason for an export job failure.</p>', ], ], 'FileFormat' => [ 'base' => NULL, 'refs' => [ 'ExportAutoScalingGroupRecommendationsRequest$fileFormat' => '<p>The format of the export file.</p> <p>The only export file format currently supported is <code>Csv</code>.</p>', 'ExportEBSVolumeRecommendationsRequest$fileFormat' => '<p>The format of the export file.</p> <p>The only export file format currently supported is <code>Csv</code>.</p>', 'ExportEC2InstanceRecommendationsRequest$fileFormat' => '<p>The format of the export file.</p> <p>The only export file format currently supported is <code>Csv</code>.</p>', 'ExportLambdaFunctionRecommendationsRequest$fileFormat' => '<p>The format of the export file.</p> <p>The only export file format currently supported is <code>Csv</code>.</p>', ], ], 'Filter' => [ 'base' => '<p>Describes a filter that returns a more specific list of recommendations. Use this filter with the <a>GetAutoScalingGroupRecommendations</a> and <a>GetEC2InstanceRecommendations</a> actions.</p> <p>You can use <code>EBSFilter</code> with the <a>GetEBSVolumeRecommendations</a> action, <code>LambdaFunctionRecommendationFilter</code> with the <a>GetLambdaFunctionRecommendations</a> action, and <code>JobFilter</code> with the <a>DescribeRecommendationExportJobs</a> action.</p>', 'refs' => [ 'Filters$member' => NULL, ], ], 'FilterName' => [ 'base' => NULL, 'refs' => [ 'Filter$name' => '<p>The name of the filter.</p> <p>Specify <code>Finding</code> to return recommendations with a specific finding classification (for example, <code>Underprovisioned</code>).</p> <p>Specify <code>RecommendationSourceType</code> to return recommendations of a specific resource type (for example, <code>Ec2Instance</code>).</p> <p>Specify <code>FindingReasonCodes</code> to return recommendations with a specific finding reason code (for example, <code>CPUUnderprovisioned</code>).</p>', ], ], 'FilterValue' => [ 'base' => NULL, 'refs' => [ 'FilterValues$member' => NULL, ], ], 'FilterValues' => [ 'base' => NULL, 'refs' => [ 'EBSFilter$values' => '<p>The value of the filter.</p> <p>The valid values are <code>Optimized</code>, or <code>NotOptimized</code>.</p>', 'EnrollmentFilter$values' => '<p>The value of the filter.</p> <p>The valid values are <code>Active</code>, <code>Inactive</code>, <code>Pending</code>, and <code>Failed</code>.</p>', 'Filter$values' => '<p>The value of the filter.</p> <p>The valid values for this parameter are as follows, depending on what you specify for the <code>name</code> parameter and the resource type that you wish to filter results for:</p> <ul> <li> <p>Specify <code>Optimized</code> or <code>NotOptimized</code> if you specify the <code>name</code> parameter as <code>Finding</code> and you want to filter results for Auto Scaling groups.</p> </li> <li> <p>Specify <code>Underprovisioned</code>, <code>Overprovisioned</code>, or <code>Optimized</code> if you specify the <code>name</code> parameter as <code>Finding</code> and you want to filter results for EC2 instances.</p> </li> <li> <p>Specify <code>Ec2Instance</code> or <code>AutoScalingGroup</code> if you specify the <code>name</code> parameter as <code>RecommendationSourceType</code>.</p> </li> <li> <p>Specify one of the following options if you specify the <code>name</code> parameter as <code>FindingReasonCodes</code>:</p> <ul> <li> <p> <b> <code>CPUOverprovisioned</code> </b> — The instance’s CPU configuration can be sized down while still meeting the performance requirements of your workload.</p> </li> <li> <p> <b> <code>CPUUnderprovisioned</code> </b> — The instance’s CPU configuration doesn\'t meet the performance requirements of your workload and there is an alternative instance type that provides better CPU performance.</p> </li> <li> <p> <b> <code>MemoryOverprovisioned</code> </b> — The instance’s memory configuration can be sized down while still meeting the performance requirements of your workload.</p> </li> <li> <p> <b> <code>MemoryUnderprovisioned</code> </b> — The instance’s memory configuration doesn\'t meet the performance requirements of your workload and there is an alternative instance type that provides better memory performance.</p> </li> <li> <p> <b> <code>EBSThroughputOverprovisioned</code> </b> — The instance’s EBS throughput configuration can be sized down while still meeting the performance requirements of your workload.</p> </li> <li> <p> <b> <code>EBSThroughputUnderprovisioned</code> </b> — The instance’s EBS throughput configuration doesn\'t meet the performance requirements of your workload and there is an alternative instance type that provides better EBS throughput performance.</p> </li> <li> <p> <b> <code>EBSIOPSOverprovisioned</code> </b> — The instance’s EBS IOPS configuration can be sized down while still meeting the performance requirements of your workload.</p> </li> <li> <p> <b> <code>EBSIOPSUnderprovisioned</code> </b> — The instance’s EBS IOPS configuration doesn\'t meet the performance requirements of your workload and there is an alternative instance type that provides better EBS IOPS performance.</p> </li> <li> <p> <b> <code>NetworkBandwidthOverprovisioned</code> </b> — The instance’s network bandwidth configuration can be sized down while still meeting the performance requirements of your workload.</p> </li> <li> <p> <b> <code>NetworkBandwidthUnderprovisioned</code> </b> — The instance’s network bandwidth configuration doesn\'t meet the performance requirements of your workload and there is an alternative instance type that provides better network bandwidth performance. This finding reason happens when the <code>NetworkIn</code> or <code>NetworkOut</code> performance of an instance is impacted.</p> </li> <li> <p> <b> <code>NetworkPPSOverprovisioned</code> </b> — The instance’s network PPS (packets per second) configuration can be sized down while still meeting the performance requirements of your workload.</p> </li> <li> <p> <b> <code>NetworkPPSUnderprovisioned</code> </b> — The instance’s network PPS (packets per second) configuration doesn\'t meet the performance requirements of your workload and there is an alternative instance type that provides better network PPS performance.</p> </li> <li> <p> <b> <code>DiskIOPSOverprovisioned</code> </b> — The instance’s disk IOPS configuration can be sized down while still meeting the performance requirements of your workload.</p> </li> <li> <p> <b> <code>DiskIOPSUnderprovisioned</code> </b> — The instance’s disk IOPS configuration doesn\'t meet the performance requirements of your workload and there is an alternative instance type that provides better disk IOPS performance.</p> </li> <li> <p> <b> <code>DiskThroughputOverprovisioned</code> </b> — The instance’s disk throughput configuration can be sized down while still meeting the performance requirements of your workload.</p> </li> <li> <p> <b> <code>DiskThroughputUnderprovisioned</code> </b> — The instance’s disk throughput configuration doesn\'t meet the performance requirements of your workload and there is an alternative instance type that provides better disk throughput performance.</p> </li> </ul> </li> </ul>', 'JobFilter$values' => '<p>The value of the filter.</p> <p>The valid values for this parameter are as follows, depending on what you specify for the <code>name</code> parameter:</p> <ul> <li> <p>Specify <code>Ec2Instance</code> or <code>AutoScalingGroup</code> if you specify the <code>name</code> parameter as <code>ResourceType</code>. There is no filter for EBS volumes because volume recommendations cannot be exported at this time.</p> </li> <li> <p>Specify <code>Queued</code>, <code>InProgress</code>, <code>Complete</code>, or <code>Failed</code> if you specify the <code>name</code> parameter as <code>JobStatus</code>.</p> </li> </ul>', 'LambdaFunctionRecommendationFilter$values' => '<p>The value of the filter.</p> <p>The valid values for this parameter are as follows, depending on what you specify for the <code>name</code> parameter:</p> <ul> <li> <p>Specify <code>Optimized</code>, <code>NotOptimized</code>, or <code>Unavailable</code> if you specify the <code>name</code> parameter as <code>Finding</code>.</p> </li> <li> <p>Specify <code>MemoryOverprovisioned</code>, <code>MemoryUnderprovisioned</code>, <code>InsufficientData</code>, or <code>Inconclusive</code> if you specify the <code>name</code> parameter as <code>FindingReasonCode</code>.</p> </li> </ul>', ], ], 'Filters' => [ 'base' => NULL, 'refs' => [ 'ExportAutoScalingGroupRecommendationsRequest$filters' => '<p>An array of objects to specify a filter that exports a more specific set of Auto Scaling group recommendations.</p>', 'ExportEC2InstanceRecommendationsRequest$filters' => '<p>An array of objects to specify a filter that exports a more specific set of instance recommendations.</p>', 'GetAutoScalingGroupRecommendationsRequest$filters' => '<p>An array of objects to specify a filter that returns a more specific list of Auto Scaling group recommendations.</p>', 'GetEC2InstanceRecommendationsRequest$filters' => '<p>An array of objects to specify a filter that returns a more specific list of instance recommendations.</p>', ], ], 'Finding' => [ 'base' => NULL, 'refs' => [ 'AutoScalingGroupRecommendation$finding' => '<p>The finding classification of the Auto Scaling group.</p> <p>Findings for Auto Scaling groups include:</p> <ul> <li> <p> <b> <code>NotOptimized</code> </b>—An Auto Scaling group is considered not optimized when Compute Optimizer identifies a recommendation that can provide better performance for your workload.</p> </li> <li> <p> <b> <code>Optimized</code> </b>—An Auto Scaling group is considered optimized when Compute Optimizer determines that the group is correctly provisioned to run your workload based on the chosen instance type. For optimized resources, Compute Optimizer might recommend a new generation instance type.</p> </li> </ul>', 'InstanceRecommendation$finding' => '<p>The finding classification of the instance.</p> <p>Findings for instances include:</p> <ul> <li> <p> <b> <code>Underprovisioned</code> </b>—An instance is considered under-provisioned when at least one specification of your instance, such as CPU, memory, or network, does not meet the performance requirements of your workload. Under-provisioned instances may lead to poor application performance.</p> </li> <li> <p> <b> <code>Overprovisioned</code> </b>—An instance is considered over-provisioned when at least one specification of your instance, such as CPU, memory, or network, can be sized down while still meeting the performance requirements of your workload, and no specification is under-provisioned. Over-provisioned instances may lead to unnecessary infrastructure cost.</p> </li> <li> <p> <b> <code>Optimized</code> </b>—An instance is considered optimized when all specifications of your instance, such as CPU, memory, and network, meet the performance requirements of your workload and is not over provisioned. For optimized resources, Compute Optimizer might recommend a new generation instance type.</p> </li> </ul>', 'Summary$name' => '<p>The finding classification of the recommendation.</p>', ], ], 'FindingReasonCode' => [ 'base' => NULL, 'refs' => [ 'ReasonCodeSummary$name' => '<p>The name of the finding reason code.</p>', ], ], 'FunctionArn' => [ 'base' => NULL, 'refs' => [ 'FunctionArns$member' => NULL, 'LambdaFunctionRecommendation$functionArn' => '<p>The Amazon Resource Name (ARN) of the current function.</p>', ], ], 'FunctionArns' => [ 'base' => NULL, 'refs' => [ 'GetLambdaFunctionRecommendationsRequest$functionArns' => '<p>The Amazon Resource Name (ARN) of the functions for which to return recommendations.</p> <p>You can specify a qualified or unqualified ARN. If you specify an unqualified ARN without a function version suffix, Compute Optimizer will return recommendations for the latest (<code>$LATEST</code>) version of the function. If you specify a qualified ARN with a version suffix, Compute Optimizer will return recommendations for the specified function version. For more information about using function versions, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-versions.html#versioning-versions-using">Using versions</a> in the <i>Lambda Developer Guide</i>.</p>', ], ], 'FunctionVersion' => [ 'base' => NULL, 'refs' => [ 'LambdaFunctionRecommendation$functionVersion' => '<p>The version number of the current function.</p>', ], ], 'GetAutoScalingGroupRecommendationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetAutoScalingGroupRecommendationsResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetEBSVolumeRecommendationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetEBSVolumeRecommendationsResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetEC2InstanceRecommendationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetEC2InstanceRecommendationsResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetEC2RecommendationProjectedMetricsRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetEC2RecommendationProjectedMetricsResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetEnrollmentStatusRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetEnrollmentStatusResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetEnrollmentStatusesForOrganizationRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetEnrollmentStatusesForOrganizationResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetLambdaFunctionRecommendationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetLambdaFunctionRecommendationsResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetRecommendationError' => [ 'base' => '<p>Describes an error experienced when getting recommendations.</p> <p>For example, an error is returned if you request recommendations for an unsupported Auto Scaling group, or if you request recommendations for an instance of an unsupported instance family.</p>', 'refs' => [ 'GetRecommendationErrors$member' => NULL, ], ], 'GetRecommendationErrors' => [ 'base' => NULL, 'refs' => [ 'GetAutoScalingGroupRecommendationsResponse$errors' => '<p>An array of objects that describe errors of the request.</p> <p>For example, an error is returned if you request recommendations for an unsupported Auto Scaling group.</p>', 'GetEBSVolumeRecommendationsResponse$errors' => '<p>An array of objects that describe errors of the request.</p> <p>For example, an error is returned if you request recommendations for an unsupported volume.</p>', 'GetEC2InstanceRecommendationsResponse$errors' => '<p>An array of objects that describe errors of the request.</p> <p>For example, an error is returned if you request recommendations for an instance of an unsupported instance family.</p>', ], ], 'GetRecommendationSummariesRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetRecommendationSummariesResponse' => [ 'base' => NULL, 'refs' => [], ], 'Identifier' => [ 'base' => NULL, 'refs' => [ 'GetRecommendationError$identifier' => '<p>The ID of the error.</p>', ], ], 'IncludeMemberAccounts' => [ 'base' => NULL, 'refs' => [ 'ExportAutoScalingGroupRecommendationsRequest$includeMemberAccounts' => '<p>Indicates whether to include recommendations for resources in all member accounts of the organization if your account is the management account of an organization.</p> <p>The member accounts must also be opted in to Compute Optimizer, and trusted access for Compute Optimizer must be enabled in the organization account. For more information, see <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/security-iam.html#trusted-service-access">Compute Optimizer and Amazon Web Services Organizations trusted access</a> in the <i>Compute Optimizer User Guide</i>.</p> <p>Recommendations for member accounts of the organization are not included in the export file if this parameter is omitted.</p> <p>This parameter cannot be specified together with the account IDs parameter. The parameters are mutually exclusive.</p> <p>Recommendations for member accounts are not included in the export if this parameter, or the account IDs parameter, is omitted.</p>', 'ExportEBSVolumeRecommendationsRequest$includeMemberAccounts' => '<p>Indicates whether to include recommendations for resources in all member accounts of the organization if your account is the management account of an organization.</p> <p>The member accounts must also be opted in to Compute Optimizer, and trusted access for Compute Optimizer must be enabled in the organization account. For more information, see <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/security-iam.html#trusted-service-access">Compute Optimizer and Amazon Web Services Organizations trusted access</a> in the <i>Compute Optimizer User Guide</i>.</p> <p>Recommendations for member accounts of the organization are not included in the export file if this parameter is omitted.</p> <p>This parameter cannot be specified together with the account IDs parameter. The parameters are mutually exclusive.</p> <p>Recommendations for member accounts are not included in the export if this parameter, or the account IDs parameter, is omitted.</p>', 'ExportEC2InstanceRecommendationsRequest$includeMemberAccounts' => '<p>Indicates whether to include recommendations for resources in all member accounts of the organization if your account is the management account of an organization.</p> <p>The member accounts must also be opted in to Compute Optimizer, and trusted access for Compute Optimizer must be enabled in the organization account. For more information, see <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/security-iam.html#trusted-service-access">Compute Optimizer and Amazon Web Services Organizations trusted access</a> in the <i>Compute Optimizer User Guide</i>.</p> <p>Recommendations for member accounts of the organization are not included in the export file if this parameter is omitted.</p> <p>Recommendations for member accounts are not included in the export if this parameter, or the account IDs parameter, is omitted.</p>', 'ExportLambdaFunctionRecommendationsRequest$includeMemberAccounts' => '<p>Indicates whether to include recommendations for resources in all member accounts of the organization if your account is the management account of an organization.</p> <p>The member accounts must also be opted in to Compute Optimizer, and trusted access for Compute Optimizer must be enabled in the organization account. For more information, see <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/security-iam.html#trusted-service-access">Compute Optimizer and Amazon Web Services Organizations trusted access</a> in the <i>Compute Optimizer User Guide</i>.</p> <p>Recommendations for member accounts of the organization are not included in the export file if this parameter is omitted.</p> <p>This parameter cannot be specified together with the account IDs parameter. The parameters are mutually exclusive.</p> <p>Recommendations for member accounts are not included in the export if this parameter, or the account IDs parameter, is omitted.</p>', 'UpdateEnrollmentStatusRequest$includeMemberAccounts' => '<p>Indicates whether to enroll member accounts of the organization if the account is the management account of an organization.</p>', ], ], 'InstanceArn' => [ 'base' => NULL, 'refs' => [ 'GetEC2RecommendationProjectedMetricsRequest$instanceArn' => '<p>The Amazon Resource Name (ARN) of the instances for which to return recommendation projected metrics.</p>', 'InstanceArns$member' => NULL, 'InstanceRecommendation$instanceArn' => '<p>The Amazon Resource Name (ARN) of the current instance.</p>', ], ], 'InstanceArns' => [ 'base' => NULL, 'refs' => [ 'GetEC2InstanceRecommendationsRequest$instanceArns' => '<p>The Amazon Resource Name (ARN) of the instances for which to return recommendations.</p>', ], ], 'InstanceName' => [ 'base' => NULL, 'refs' => [ 'InstanceRecommendation$instanceName' => '<p>The name of the current instance.</p>', ], ], 'InstanceRecommendation' => [ 'base' => '<p>Describes an Amazon EC2 instance recommendation.</p>', 'refs' => [ 'InstanceRecommendations$member' => NULL, ], ], 'InstanceRecommendationFindingReasonCode' => [ 'base' => NULL, 'refs' => [ 'InstanceRecommendationFindingReasonCodes$member' => NULL, ], ], 'InstanceRecommendationFindingReasonCodes' => [ 'base' => NULL, 'refs' => [ 'InstanceRecommendation$findingReasonCodes' => '<p>The reason for the finding classification of the instance.</p> <p>Finding reason codes for instances include:</p> <ul> <li> <p> <b> <code>CPUOverprovisioned</code> </b> — The instance’s CPU configuration can be sized down while still meeting the performance requirements of your workload. This is identified by analyzing the <code>CPUUtilization</code> metric of the current instance during the look-back period.</p> </li> <li> <p> <b> <code>CPUUnderprovisioned</code> </b> — The instance’s CPU configuration doesn\'t meet the performance requirements of your workload and there is an alternative instance type that provides better CPU performance. This is identified by analyzing the <code>CPUUtilization</code> metric of the current instance during the look-back period.</p> </li> <li> <p> <b> <code>MemoryOverprovisioned</code> </b> — The instance’s memory configuration can be sized down while still meeting the performance requirements of your workload. This is identified by analyzing the memory utilization metric of the current instance during the look-back period.</p> </li> <li> <p> <b> <code>MemoryUnderprovisioned</code> </b> — The instance’s memory configuration doesn\'t meet the performance requirements of your workload and there is an alternative instance type that provides better memory performance. This is identified by analyzing the memory utilization metric of the current instance during the look-back period.</p> <note> <p>Memory utilization is analyzed only for resources that have the unified CloudWatch agent installed on them. For more information, see <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/metrics.html#cw-agent">Enabling memory utilization with the Amazon CloudWatch Agent</a> in the <i>Compute Optimizer User Guide</i>. On Linux instances, Compute Optimizer analyses the <code>mem_used_percent</code> metric in the <code>CWAgent</code> namespace, or the legacy <code>MemoryUtilization</code> metric in the <code>System/Linux</code> namespace. On Windows instances, Compute Optimizer analyses the <code>Memory % Committed Bytes In Use</code> metric in the <code>CWAgent</code> namespace.</p> </note> </li> <li> <p> <b> <code>EBSThroughputOverprovisioned</code> </b> — The instance’s EBS throughput configuration can be sized down while still meeting the performance requirements of your workload. This is identified by analyzing the <code>VolumeReadOps</code> and <code>VolumeWriteOps</code> metrics of EBS volumes attached to the current instance during the look-back period.</p> </li> <li> <p> <b> <code>EBSThroughputUnderprovisioned</code> </b> — The instance’s EBS throughput configuration doesn\'t meet the performance requirements of your workload and there is an alternative instance type that provides better EBS throughput performance. This is identified by analyzing the <code>VolumeReadOps</code> and <code>VolumeWriteOps</code> metrics of EBS volumes attached to the current instance during the look-back period.</p> </li> <li> <p> <b> <code>EBSIOPSOverprovisioned</code> </b> — The instance’s EBS IOPS configuration can be sized down while still meeting the performance requirements of your workload. This is identified by analyzing the <code>VolumeReadBytes</code> and <code>VolumeWriteBytes</code> metric of EBS volumes attached to the current instance during the look-back period.</p> </li> <li> <p> <b> <code>EBSIOPSUnderprovisioned</code> </b> — The instance’s EBS IOPS configuration doesn\'t meet the performance requirements of your workload and there is an alternative instance type that provides better EBS IOPS performance. This is identified by analyzing the <code>VolumeReadBytes</code> and <code>VolumeWriteBytes</code> metric of EBS volumes attached to the current instance during the look-back period.</p> </li> <li> <p> <b> <code>NetworkBandwidthOverprovisioned</code> </b> — The instance’s network bandwidth configuration can be sized down while still meeting the performance requirements of your workload. This is identified by analyzing the <code>NetworkIn</code> and <code>NetworkOut</code> metrics of the current instance during the look-back period.</p> </li> <li> <p> <b> <code>NetworkBandwidthUnderprovisioned</code> </b> — The instance’s network bandwidth configuration doesn\'t meet the performance requirements of your workload and there is an alternative instance type that provides better network bandwidth performance. This is identified by analyzing the <code>NetworkIn</code> and <code>NetworkOut</code> metrics of the current instance during the look-back period. This finding reason happens when the <code>NetworkIn</code> or <code>NetworkOut</code> performance of an instance is impacted.</p> </li> <li> <p> <b> <code>NetworkPPSOverprovisioned</code> </b> — The instance’s network PPS (packets per second) configuration can be sized down while still meeting the performance requirements of your workload. This is identified by analyzing the <code>NetworkPacketsIn</code> and <code>NetworkPacketsIn</code> metrics of the current instance during the look-back period.</p> </li> <li> <p> <b> <code>NetworkPPSUnderprovisioned</code> </b> — The instance’s network PPS (packets per second) configuration doesn\'t meet the performance requirements of your workload and there is an alternative instance type that provides better network PPS performance. This is identified by analyzing the <code>NetworkPacketsIn</code> and <code>NetworkPacketsIn</code> metrics of the current instance during the look-back period.</p> </li> <li> <p> <b> <code>DiskIOPSOverprovisioned</code> </b> — The instance’s disk IOPS configuration can be sized down while still meeting the performance requirements of your workload. This is identified by analyzing the <code>DiskReadOps</code> and <code>DiskWriteOps</code> metrics of the current instance during the look-back period.</p> </li> <li> <p> <b> <code>DiskIOPSUnderprovisioned</code> </b> — The instance’s disk IOPS configuration doesn\'t meet the performance requirements of your workload and there is an alternative instance type that provides better disk IOPS performance. This is identified by analyzing the <code>DiskReadOps</code> and <code>DiskWriteOps</code> metrics of the current instance during the look-back period.</p> </li> <li> <p> <b> <code>DiskThroughputOverprovisioned</code> </b> — The instance’s disk throughput configuration can be sized down while still meeting the performance requirements of your workload. This is identified by analyzing the <code>DiskReadBytes</code> and <code>DiskWriteBytes</code> metrics of the current instance during the look-back period.</p> </li> <li> <p> <b> <code>DiskThroughputUnderprovisioned</code> </b> — The instance’s disk throughput configuration doesn\'t meet the performance requirements of your workload and there is an alternative instance type that provides better disk throughput performance. This is identified by analyzing the <code>DiskReadBytes</code> and <code>DiskWriteBytes</code> metrics of the current instance during the look-back period.</p> </li> </ul> <note> <p>For more information about instance metrics, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/viewing_metrics_with_cloudwatch.html">List the available CloudWatch metrics for your instances</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>. For more information about EBS volume metrics, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using_cloudwatch_ebs.html">Amazon CloudWatch metrics for Amazon EBS</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p> </note>', ], ], 'InstanceRecommendationOption' => [ 'base' => '<p>Describes a recommendation option for an Amazon EC2 instance.</p>', 'refs' => [ 'RecommendationOptions$member' => NULL, ], ], 'InstanceRecommendations' => [ 'base' => NULL, 'refs' => [ 'GetEC2InstanceRecommendationsResponse$instanceRecommendations' => '<p>An array of objects that describe instance recommendations.</p>', ], ], 'InstanceType' => [ 'base' => NULL, 'refs' => [ 'AutoScalingGroupConfiguration$instanceType' => '<p>The instance type for the Auto Scaling group.</p>', 'InstanceRecommendationOption$instanceType' => '<p>The instance type of the instance recommendation.</p>', ], ], 'InternalServerException' => [ 'base' => '<p>An internal error has occurred. Try your call again.</p>', 'refs' => [], ], 'InvalidParameterValueException' => [ 'base' => '<p>The value supplied for the input parameter is out of range or not valid.</p>', 'refs' => [], ], 'JobFilter' => [ 'base' => '<p>Describes a filter that returns a more specific list of recommendation export jobs. Use this filter with the <a>DescribeRecommendationExportJobs</a> action.</p> <p>You can use <code>EBSFilter</code> with the <a>GetEBSVolumeRecommendations</a> action, <code>LambdaFunctionRecommendationFilter</code> with the <a>GetLambdaFunctionRecommendations</a> action, and <code>Filter</code> with the <a>GetAutoScalingGroupRecommendations</a> and <a>GetEC2InstanceRecommendations</a> actions.</p>', 'refs' => [ 'JobFilters$member' => NULL, ], ], 'JobFilterName' => [ 'base' => NULL, 'refs' => [ 'JobFilter$name' => '<p>The name of the filter.</p> <p>Specify <code>ResourceType</code> to return export jobs of a specific resource type (for example, <code>Ec2Instance</code>).</p> <p>Specify <code>JobStatus</code> to return export jobs with a specific status (e.g, <code>Complete</code>).</p>', ], ], 'JobFilters' => [ 'base' => NULL, 'refs' => [ 'DescribeRecommendationExportJobsRequest$filters' => '<p>An array of objects to specify a filter that returns a more specific list of export jobs.</p>', ], ], 'JobId' => [ 'base' => NULL, 'refs' => [ 'ExportAutoScalingGroupRecommendationsResponse$jobId' => '<p>The identification number of the export job.</p> <p>Use the <a>DescribeRecommendationExportJobs</a> action, and specify the job ID to view the status of an export job.</p>', 'ExportEBSVolumeRecommendationsResponse$jobId' => '<p>The identification number of the export job.</p> <p>Use the <a>DescribeRecommendationExportJobs</a> action, and specify the job ID to view the status of an export job.</p>', 'ExportEC2InstanceRecommendationsResponse$jobId' => '<p>The identification number of the export job.</p> <p>Use the <a>DescribeRecommendationExportJobs</a> action, and specify the job ID to view the status of an export job.</p>', 'ExportLambdaFunctionRecommendationsResponse$jobId' => '<p>The identification number of the export job.</p> <p>Use the <a>DescribeRecommendationExportJobs</a> action, and specify the job ID to view the status of an export job.</p>', 'JobIds$member' => NULL, 'RecommendationExportJob$jobId' => '<p>The identification number of the export job.</p>', ], ], 'JobIds' => [ 'base' => NULL, 'refs' => [ 'DescribeRecommendationExportJobsRequest$jobIds' => '<p>The identification numbers of the export jobs to return.</p> <p>An export job ID is returned when you create an export using the <a>ExportAutoScalingGroupRecommendations</a> or <a>ExportEC2InstanceRecommendations</a> actions.</p> <p>All export jobs created in the last seven days are returned if this parameter is omitted.</p>', ], ], 'JobStatus' => [ 'base' => NULL, 'refs' => [ 'RecommendationExportJob$status' => '<p>The status of the export job.</p>', ], ], 'LambdaFunctionMemoryMetricName' => [ 'base' => NULL, 'refs' => [ 'LambdaFunctionMemoryProjectedMetric$name' => '<p>The name of the projected utilization metric.</p>', ], ], 'LambdaFunctionMemoryMetricStatistic' => [ 'base' => NULL, 'refs' => [ 'LambdaFunctionMemoryProjectedMetric$statistic' => '<p>The statistic of the projected utilization metric.</p>', ], ], 'LambdaFunctionMemoryProjectedMetric' => [ 'base' => '<p>Describes a projected utilization metric of an Lambda function recommendation option.</p>', 'refs' => [ 'LambdaFunctionMemoryProjectedMetrics$member' => NULL, ], ], 'LambdaFunctionMemoryProjectedMetrics' => [ 'base' => NULL, 'refs' => [ 'LambdaFunctionMemoryRecommendationOption$projectedUtilizationMetrics' => '<p>An array of objects that describe the projected utilization metrics of the function recommendation option.</p>', ], ], 'LambdaFunctionMemoryRecommendationOption' => [ 'base' => '<p>Describes a recommendation option for an Lambda function.</p>', 'refs' => [ 'LambdaFunctionMemoryRecommendationOptions$member' => NULL, ], ], 'LambdaFunctionMemoryRecommendationOptions' => [ 'base' => NULL, 'refs' => [ 'LambdaFunctionRecommendation$memorySizeRecommendationOptions' => '<p>An array of objects that describe the memory configuration recommendation options for the function.</p>', ], ], 'LambdaFunctionMetricName' => [ 'base' => NULL, 'refs' => [ 'LambdaFunctionUtilizationMetric$name' => '<p>The name of the utilization metric.</p> <p>The following utilization metrics are available:</p> <ul> <li> <p> <code>Duration</code> - The amount of time that your function code spends processing an event.</p> </li> <li> <p> <code>Memory</code> - The amount of memory used per invocation.</p> </li> </ul>', ], ], 'LambdaFunctionMetricStatistic' => [ 'base' => NULL, 'refs' => [ 'LambdaFunctionUtilizationMetric$statistic' => '<p>The statistic of the utilization metric.</p> <p>The Compute Optimizer API, Command Line Interface (CLI), and SDKs return utilization metrics using only the <code>Maximum</code> statistic, which is the highest value observed during the specified period.</p> <p>The Compute Optimizer console displays graphs for some utilization metrics using the <code>Average</code> statistic, which is the value of <code>Sum</code> / <code>SampleCount</code> during the specified period. For more information, see <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/viewing-recommendations.html">Viewing resource recommendations</a> in the <i>Compute Optimizer User Guide</i>. You can also get averaged utilization metric data for your resources using Amazon CloudWatch. For more information, see the <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/WhatIsCloudWatch.html">Amazon CloudWatch User Guide</a>.</p>', ], ], 'LambdaFunctionRecommendation' => [ 'base' => '<p>Describes an Lambda function recommendation.</p>', 'refs' => [ 'LambdaFunctionRecommendations$member' => NULL, ], ], 'LambdaFunctionRecommendationFilter' => [ 'base' => '<p>Describes a filter that returns a more specific list of Lambda function recommendations. Use this filter with the <a>GetLambdaFunctionRecommendations</a> action.</p> <p>You can use <code>EBSFilter</code> with the <a>GetEBSVolumeRecommendations</a> action, <code>JobFilter</code> with the <a>DescribeRecommendationExportJobs</a> action, and <code>Filter</code> with the <a>GetAutoScalingGroupRecommendations</a> and <a>GetEC2InstanceRecommendations</a> actions.</p>', 'refs' => [ 'LambdaFunctionRecommendationFilters$member' => NULL, ], ], 'LambdaFunctionRecommendationFilterName' => [ 'base' => NULL, 'refs' => [ 'LambdaFunctionRecommendationFilter$name' => '<p>The name of the filter.</p> <p>Specify <code>Finding</code> to return recommendations with a specific finding classification (for example, <code>NotOptimized</code>).</p> <p>Specify <code>FindingReasonCode</code> to return recommendations with a specific finding reason code (for example, <code>MemoryUnderprovisioned</code>).</p>', ], ], 'LambdaFunctionRecommendationFilters' => [ 'base' => NULL, 'refs' => [ 'ExportLambdaFunctionRecommendationsRequest$filters' => '<p>An array of objects to specify a filter that exports a more specific set of Lambda function recommendations.</p>', 'GetLambdaFunctionRecommendationsRequest$filters' => '<p>An array of objects to specify a filter that returns a more specific list of function recommendations.</p>', ], ], 'LambdaFunctionRecommendationFinding' => [ 'base' => NULL, 'refs' => [ 'LambdaFunctionRecommendation$finding' => '<p>The finding classification of the function.</p> <p>Findings for functions include:</p> <ul> <li> <p> <b> <code>Optimized</code> </b> — The function is correctly provisioned to run your workload based on its current configuration and its utilization history. This finding classification does not include finding reason codes.</p> </li> <li> <p> <b> <code>NotOptimized</code> </b> — The function is performing at a higher level (over-provisioned) or at a lower level (under-provisioned) than required for your workload because its current configuration is not optimal. Over-provisioned resources might lead to unnecessary infrastructure cost, and under-provisioned resources might lead to poor application performance. This finding classification can include the <code>MemoryUnderprovisioned</code> and <code>MemoryUnderprovisioned</code> finding reason codes.</p> </li> <li> <p> <b> <code>Unavailable</code> </b> — Compute Optimizer was unable to generate a recommendation for the function. This could be because the function has not accumulated sufficient metric data, or the function does not qualify for a recommendation. This finding classification can include the <code>InsufficientData</code> and <code>Inconclusive</code> finding reason codes.</p> <note> <p>Functions with a finding of unavailable are not returned unless you specify the <code>filter</code> parameter with a value of <code>Unavailable</code> in your <code>GetLambdaFunctionRecommendations</code> request.</p> </note> </li> </ul>', ], ], 'LambdaFunctionRecommendationFindingReasonCode' => [ 'base' => NULL, 'refs' => [ 'LambdaFunctionRecommendationFindingReasonCodes$member' => NULL, ], ], 'LambdaFunctionRecommendationFindingReasonCodes' => [ 'base' => NULL, 'refs' => [ 'LambdaFunctionRecommendation$findingReasonCodes' => '<p>The reason for the finding classification of the function.</p> <note> <p>Functions that have a finding classification of <code>Optimized</code> don\'t have a finding reason code.</p> </note> <p>Finding reason codes for functions include:</p> <ul> <li> <p> <b> <code>MemoryOverprovisioned</code> </b> — The function is over-provisioned when its memory configuration can be sized down while still meeting the performance requirements of your workload. An over-provisioned function might lead to unnecessary infrastructure cost. This finding reason code is part of the <code>NotOptimized</code> finding classification.</p> </li> <li> <p> <b> <code>MemoryUnderprovisioned</code> </b> — The function is under-provisioned when its memory configuration doesn\'t meet the performance requirements of the workload. An under-provisioned function might lead to poor application performance. This finding reason code is part of the <code>NotOptimized</code> finding classification.</p> </li> <li> <p> <b> <code>InsufficientData</code> </b> — The function does not have sufficient metric data for Compute Optimizer to generate a recommendation. For more information, see the <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/requirements.html">Supported resources and requirements</a> in the <i>Compute Optimizer User Guide</i>. This finding reason code is part of the <code>Unavailable</code> finding classification.</p> </li> <li> <p> <b> <code>Inconclusive</code> </b> — The function does not qualify for a recommendation because Compute Optimizer cannot generate a recommendation with a high degree of confidence. This finding reason code is part of the <code>Unavailable</code> finding classification.</p> </li> </ul>', ], ], 'LambdaFunctionRecommendations' => [ 'base' => NULL, 'refs' => [ 'GetLambdaFunctionRecommendationsResponse$lambdaFunctionRecommendations' => '<p>An array of objects that describe function recommendations.</p>', ], ], 'LambdaFunctionUtilizationMetric' => [ 'base' => '<p>Describes a utilization metric of an Lambda function.</p>', 'refs' => [ 'LambdaFunctionUtilizationMetrics$member' => NULL, ], ], 'LambdaFunctionUtilizationMetrics' => [ 'base' => NULL, 'refs' => [ 'LambdaFunctionRecommendation$utilizationMetrics' => '<p>An array of objects that describe the utilization metrics of the function.</p>', ], ], 'LastRefreshTimestamp' => [ 'base' => NULL, 'refs' => [ 'AutoScalingGroupRecommendation$lastRefreshTimestamp' => '<p>The timestamp of when the Auto Scaling group recommendation was last refreshed.</p>', 'InstanceRecommendation$lastRefreshTimestamp' => '<p>The timestamp of when the instance recommendation was last refreshed.</p>', 'LambdaFunctionRecommendation$lastRefreshTimestamp' => '<p>The timestamp of when the function recommendation was last refreshed.</p>', 'VolumeRecommendation$lastRefreshTimestamp' => '<p>The timestamp of when the volume recommendation was last refreshed.</p>', ], ], 'LastUpdatedTimestamp' => [ 'base' => NULL, 'refs' => [ 'AccountEnrollmentStatus$lastUpdatedTimestamp' => '<p>The Unix epoch timestamp, in seconds, of when the account enrollment status was last updated.</p>', 'GetEnrollmentStatusResponse$lastUpdatedTimestamp' => '<p>The Unix epoch timestamp, in seconds, of when the account enrollment status was last updated.</p>', 'RecommendationExportJob$lastUpdatedTimestamp' => '<p>The timestamp of when the export job was last updated.</p>', ], ], 'LimitExceededException' => [ 'base' => '<p>The request exceeds a limit of the service.</p>', 'refs' => [], ], 'LookBackPeriodInDays' => [ 'base' => NULL, 'refs' => [ 'AutoScalingGroupRecommendation$lookBackPeriodInDays' => '<p>The number of days for which utilization metrics were analyzed for the Auto Scaling group.</p>', 'InstanceRecommendation$lookBackPeriodInDays' => '<p>The number of days for which utilization metrics were analyzed for the instance.</p>', 'LambdaFunctionRecommendation$lookbackPeriodInDays' => '<p>The number of days for which utilization metrics were analyzed for the function.</p>', 'VolumeRecommendation$lookBackPeriodInDays' => '<p>The number of days for which utilization metrics were analyzed for the volume.</p>', ], ], 'MaxResults' => [ 'base' => NULL, 'refs' => [ 'DescribeRecommendationExportJobsRequest$maxResults' => '<p>The maximum number of export jobs to return with a single request.</p> <p>To retrieve the remaining results, make another request with the returned <code>nextToken</code> value.</p>', 'GetAutoScalingGroupRecommendationsRequest$maxResults' => '<p>The maximum number of Auto Scaling group recommendations to return with a single request.</p> <p>To retrieve the remaining results, make another request with the returned <code>nextToken</code> value.</p>', 'GetEBSVolumeRecommendationsRequest$maxResults' => '<p>The maximum number of volume recommendations to return with a single request.</p> <p>To retrieve the remaining results, make another request with the returned <code>nextToken</code> value.</p>', 'GetEC2InstanceRecommendationsRequest$maxResults' => '<p>The maximum number of instance recommendations to return with a single request.</p> <p>To retrieve the remaining results, make another request with the returned <code>nextToken</code> value.</p>', 'GetEnrollmentStatusesForOrganizationRequest$maxResults' => '<p>The maximum number of account enrollment statuses to return with a single request. You can specify up to 100 statuses to return with each request.</p> <p>To retrieve the remaining results, make another request with the returned <code>nextToken</code> value.</p>', 'GetLambdaFunctionRecommendationsRequest$maxResults' => '<p>The maximum number of function recommendations to return with a single request.</p> <p>To retrieve the remaining results, make another request with the returned <code>nextToken</code> value.</p>', 'GetRecommendationSummariesRequest$maxResults' => '<p>The maximum number of recommendation summaries to return with a single request.</p> <p>To retrieve the remaining results, make another request with the returned <code>nextToken</code> value.</p>', ], ], 'MaxSize' => [ 'base' => NULL, 'refs' => [ 'AutoScalingGroupConfiguration$maxSize' => '<p>The maximum size, or maximum number of instances, for the Auto Scaling group.</p>', ], ], 'MemberAccountsEnrolled' => [ 'base' => NULL, 'refs' => [ 'GetEnrollmentStatusResponse$memberAccountsEnrolled' => '<p>Confirms the enrollment status of member accounts of the organization, if the account is a management account of an organization.</p>', ], ], 'MemorySize' => [ 'base' => NULL, 'refs' => [ 'LambdaFunctionMemoryRecommendationOption$memorySize' => '<p>The memory size, in MB, of the function recommendation option.</p>', 'LambdaFunctionRecommendation$currentMemorySize' => '<p>The amount of memory, in MB, that\'s allocated to the current function.</p>', ], ], 'Message' => [ 'base' => NULL, 'refs' => [ 'GetRecommendationError$message' => '<p>The message, or reason, for the error.</p>', ], ], 'MetadataKey' => [ 'base' => NULL, 'refs' => [ 'S3Destination$metadataKey' => '<p>The Amazon S3 bucket key of a metadata file.</p> <p>The key uniquely identifies the object, or metadata file, in the S3 bucket.</p>', ], ], 'MetricName' => [ 'base' => NULL, 'refs' => [ 'ProjectedMetric$name' => '<p>The name of the projected utilization metric.</p> <p>The following projected utilization metrics are returned:</p> <ul> <li> <p> <code>Cpu</code> - The projected percentage of allocated EC2 compute units that would be in use on the recommendation option had you used that resource during the analyzed period. This metric identifies the processing power required to run an application on the recommendation option.</p> <p>Depending on the instance type, tools in your operating system can show a lower percentage than CloudWatch when the instance is not allocated a full processor core.</p> <p>Units: Percent</p> </li> <li> <p> <code>Memory</code> - The percentage of memory that would be in use on the recommendation option had you used that resource during the analyzed period. This metric identifies the amount of memory required to run an application on the recommendation option.</p> <p>Units: Percent</p> <note> <p>The <code>Memory</code> metric is returned only for resources that have the unified CloudWatch agent installed on them. For more information, see <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/metrics.html#cw-agent">Enabling Memory Utilization with the CloudWatch Agent</a>.</p> </note> </li> </ul>', 'UtilizationMetric$name' => '<p>The name of the utilization metric.</p> <p>The following utilization metrics are available:</p> <ul> <li> <p> <code>Cpu</code> - The percentage of allocated EC2 compute units that are currently in use on the instance. This metric identifies the processing power required to run an application on the instance.</p> <p>Depending on the instance type, tools in your operating system can show a lower percentage than CloudWatch when the instance is not allocated a full processor core.</p> <p>Units: Percent</p> </li> <li> <p> <code>Memory</code> - The percentage of memory that is currently in use on the instance. This metric identifies the amount of memory required to run an application on the instance.</p> <p>Units: Percent</p> <note> <p>The <code>Memory</code> metric is returned only for resources that have the unified CloudWatch agent installed on them. For more information, see <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/metrics.html#cw-agent">Enabling Memory Utilization with the CloudWatch Agent</a>.</p> </note> </li> <li> <p> <code>EBS_READ_OPS_PER_SECOND</code> - The completed read operations from all EBS volumes attached to the instance in a specified period of time.</p> <p>Unit: Count</p> </li> <li> <p> <code>EBS_WRITE_OPS_PER_SECOND</code> - The completed write operations to all EBS volumes attached to the instance in a specified period of time.</p> <p>Unit: Count</p> </li> <li> <p> <code>EBS_READ_BYTES_PER_SECOND</code> - The bytes read from all EBS volumes attached to the instance in a specified period of time.</p> <p>Unit: Bytes</p> </li> <li> <p> <code>EBS_WRITE_BYTES_PER_SECOND</code> - The bytes written to all EBS volumes attached to the instance in a specified period of time.</p> <p>Unit: Bytes</p> </li> <li> <p> <code>DISK_READ_OPS_PER_SECOND</code> - The completed read operations from all instance store volumes available to the instance in a specified period of time.</p> <p>If there are no instance store volumes, either the value is <code>0</code> or the metric is not reported.</p> </li> <li> <p> <code>DISK_WRITE_OPS_PER_SECOND</code> - The completed write operations from all instance store volumes available to the instance in a specified period of time.</p> <p>If there are no instance store volumes, either the value is <code>0</code> or the metric is not reported.</p> </li> <li> <p> <code>DISK_READ_BYTES_PER_SECOND</code> - The bytes read from all instance store volumes available to the instance. This metric is used to determine the volume of the data the application reads from the disk of the instance. This can be used to determine the speed of the application.</p> <p>If there are no instance store volumes, either the value is <code>0</code> or the metric is not reported.</p> </li> <li> <p> <code>DISK_WRITE_BYTES_PER_SECOND</code> - The bytes written to all instance store volumes available to the instance. This metric is used to determine the volume of the data the application writes onto the disk of the instance. This can be used to determine the speed of the application.</p> <p>If there are no instance store volumes, either the value is <code>0</code> or the metric is not reported.</p> </li> <li> <p> <code>NETWORK_IN_BYTES_PER_SECOND</code> - The number of bytes received by the instance on all network interfaces. This metric identifies the volume of incoming network traffic to a single instance.</p> </li> <li> <p> <code>NETWORK_OUT_BYTES_PER_SECOND</code> - The number of bytes sent out by the instance on all network interfaces. This metric identifies the volume of outgoing network traffic from a single instance.</p> </li> <li> <p> <code>NETWORK_PACKETS_IN_PER_SECOND</code> - The number of packets received by the instance on all network interfaces. This metric identifies the volume of incoming traffic in terms of the number of packets on a single instance.</p> </li> <li> <p> <code>NETWORK_PACKETS_OUT_PER_SECOND</code> - The number of packets sent out by the instance on all network interfaces. This metric identifies the volume of outgoing traffic in terms of the number of packets on a single instance.</p> </li> </ul>', ], ], 'MetricStatistic' => [ 'base' => NULL, 'refs' => [ 'EBSUtilizationMetric$statistic' => '<p>The statistic of the utilization metric.</p> <p>The Compute Optimizer API, Command Line Interface (CLI), and SDKs return utilization metrics using only the <code>Maximum</code> statistic, which is the highest value observed during the specified period.</p> <p>The Compute Optimizer console displays graphs for some utilization metrics using the <code>Average</code> statistic, which is the value of <code>Sum</code> / <code>SampleCount</code> during the specified period. For more information, see <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/viewing-recommendations.html">Viewing resource recommendations</a> in the <i>Compute Optimizer User Guide</i>. You can also get averaged utilization metric data for your resources using Amazon CloudWatch. For more information, see the <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/WhatIsCloudWatch.html">Amazon CloudWatch User Guide</a>.</p>', 'GetEC2RecommendationProjectedMetricsRequest$stat' => '<p>The statistic of the projected metrics.</p>', 'UtilizationMetric$statistic' => '<p>The statistic of the utilization metric.</p> <p>The Compute Optimizer API, Command Line Interface (CLI), and SDKs return utilization metrics using only the <code>Maximum</code> statistic, which is the highest value observed during the specified period.</p> <p>The Compute Optimizer console displays graphs for some utilization metrics using the <code>Average</code> statistic, which is the value of <code>Sum</code> / <code>SampleCount</code> during the specified period. For more information, see <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/viewing-recommendations.html">Viewing resource recommendations</a> in the <i>Compute Optimizer User Guide</i>. You can also get averaged utilization metric data for your resources using Amazon CloudWatch. For more information, see the <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/WhatIsCloudWatch.html">Amazon CloudWatch User Guide</a>.</p>', ], ], 'MetricValue' => [ 'base' => NULL, 'refs' => [ 'EBSUtilizationMetric$value' => '<p>The value of the utilization metric.</p>', 'LambdaFunctionMemoryProjectedMetric$value' => '<p>The values of the projected utilization metrics.</p>', 'LambdaFunctionUtilizationMetric$value' => '<p>The value of the utilization metric.</p>', 'MetricValues$member' => NULL, 'UtilizationMetric$value' => '<p>The value of the utilization metric.</p>', ], ], 'MetricValues' => [ 'base' => NULL, 'refs' => [ 'ProjectedMetric$values' => '<p>The values of the projected utilization metrics.</p>', ], ], 'MinSize' => [ 'base' => NULL, 'refs' => [ 'AutoScalingGroupConfiguration$minSize' => '<p>The minimum size, or minimum number of instances, for the Auto Scaling group.</p>', ], ], 'MissingAuthenticationToken' => [ 'base' => '<p>The request must contain either a valid (registered) Amazon Web Services access key ID or X.509 certificate.</p>', 'refs' => [], ], 'NextToken' => [ 'base' => NULL, 'refs' => [ 'DescribeRecommendationExportJobsRequest$nextToken' => '<p>The token to advance to the next page of export jobs.</p>', 'DescribeRecommendationExportJobsResponse$nextToken' => '<p>The token to use to advance to the next page of export jobs.</p> <p>This value is null when there are no more pages of export jobs to return.</p>', 'GetAutoScalingGroupRecommendationsRequest$nextToken' => '<p>The token to advance to the next page of Auto Scaling group recommendations.</p>', 'GetAutoScalingGroupRecommendationsResponse$nextToken' => '<p>The token to use to advance to the next page of Auto Scaling group recommendations.</p> <p>This value is null when there are no more pages of Auto Scaling group recommendations to return.</p>', 'GetEBSVolumeRecommendationsRequest$nextToken' => '<p>The token to advance to the next page of volume recommendations.</p>', 'GetEBSVolumeRecommendationsResponse$nextToken' => '<p>The token to use to advance to the next page of volume recommendations.</p> <p>This value is null when there are no more pages of volume recommendations to return.</p>', 'GetEC2InstanceRecommendationsRequest$nextToken' => '<p>The token to advance to the next page of instance recommendations.</p>', 'GetEC2InstanceRecommendationsResponse$nextToken' => '<p>The token to use to advance to the next page of instance recommendations.</p> <p>This value is null when there are no more pages of instance recommendations to return.</p>', 'GetEnrollmentStatusesForOrganizationRequest$nextToken' => '<p>The token to advance to the next page of account enrollment statuses.</p>', 'GetEnrollmentStatusesForOrganizationResponse$nextToken' => '<p>The token to use to advance to the next page of account enrollment statuses.</p> <p>This value is null when there are no more pages of account enrollment statuses to return.</p>', 'GetLambdaFunctionRecommendationsRequest$nextToken' => '<p>The token to advance to the next page of function recommendations.</p>', 'GetLambdaFunctionRecommendationsResponse$nextToken' => '<p>The token to use to advance to the next page of function recommendations.</p> <p>This value is null when there are no more pages of function recommendations to return.</p>', 'GetRecommendationSummariesRequest$nextToken' => '<p>The token to advance to the next page of recommendation summaries.</p>', 'GetRecommendationSummariesResponse$nextToken' => '<p>The token to use to advance to the next page of recommendation summaries.</p> <p>This value is null when there are no more pages of recommendation summaries to return.</p>', ], ], 'NumberOfInvocations' => [ 'base' => NULL, 'refs' => [ 'LambdaFunctionRecommendation$numberOfInvocations' => '<p>The number of times your function code was applied during the look-back period.</p>', ], ], 'NumberOfMemberAccountsOptedIn' => [ 'base' => NULL, 'refs' => [ 'GetEnrollmentStatusResponse$numberOfMemberAccountsOptedIn' => '<p>The count of organization member accounts that are opted in to the service, if your account is an organization management account.</p>', ], ], 'OptInRequiredException' => [ 'base' => '<p>The account is not opted in to Compute Optimizer.</p>', 'refs' => [], ], 'PerformanceRisk' => [ 'base' => NULL, 'refs' => [ 'AutoScalingGroupRecommendationOption$performanceRisk' => '<p>The performance risk of the Auto Scaling group configuration recommendation.</p> <p>Performance risk indicates the likelihood of the recommended instance type not meeting the resource needs of your workload. Compute Optimizer calculates an individual performance risk score for each specification of the recommended instance, including CPU, memory, EBS throughput, EBS IOPS, disk throughput, disk IOPS, network throughput, and network PPS. The performance risk of the recommended instance is calculated as the maximum performance risk score across the analyzed resource specifications.</p> <p>The value ranges from <code>0</code> - <code>4</code>, with <code>0</code> meaning that the recommended resource is predicted to always provide enough hardware capability. The higher the performance risk is, the more likely you should validate whether the recommendation will meet the performance requirements of your workload before migrating your resource.</p>', 'InstanceRecommendationOption$performanceRisk' => '<p>The performance risk of the instance recommendation option.</p> <p>Performance risk indicates the likelihood of the recommended instance type not meeting the resource needs of your workload. Compute Optimizer calculates an individual performance risk score for each specification of the recommended instance, including CPU, memory, EBS throughput, EBS IOPS, disk throughput, disk IOPS, network throughput, and network PPS. The performance risk of the recommended instance is calculated as the maximum performance risk score across the analyzed resource specifications.</p> <p>The value ranges from <code>0</code> - <code>4</code>, with <code>0</code> meaning that the recommended resource is predicted to always provide enough hardware capability. The higher the performance risk is, the more likely you should validate whether the recommendation will meet the performance requirements of your workload before migrating your resource.</p>', 'VolumeRecommendationOption$performanceRisk' => '<p>The performance risk of the volume recommendation option.</p> <p>Performance risk is the likelihood of the recommended volume type meeting the performance requirement of your workload.</p> <p>The value ranges from <code>0</code> - <code>4</code>, with <code>0</code> meaning that the recommended resource is predicted to always provide enough hardware capability. The higher the performance risk is, the more likely you should validate whether the recommendation will meet the performance requirements of your workload before migrating your resource.</p>', ], ], 'Period' => [ 'base' => NULL, 'refs' => [ 'GetEC2RecommendationProjectedMetricsRequest$period' => '<p>The granularity, in seconds, of the projected metrics data points.</p>', ], ], 'PlatformDifference' => [ 'base' => NULL, 'refs' => [ 'PlatformDifferences$member' => NULL, ], ], 'PlatformDifferences' => [ 'base' => NULL, 'refs' => [ 'InstanceRecommendationOption$platformDifferences' => '<p>Describes the configuration differences between the current instance and the recommended instance type. You should consider the configuration differences before migrating your workloads from the current instance to the recommended instance type. The <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-resize.html">Change the instance type guide for Linux</a> and <a href="https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/ec2-instance-resize.html">Change the instance type guide for Windows</a> provide general guidance for getting started with an instance migration.</p> <p>Platform differences include:</p> <ul> <li> <p> <b> <code>Hypervisor</code> </b> — The hypervisor of the recommended instance type is different than that of the current instance. For example, the recommended instance type uses a Nitro hypervisor and the current instance uses a Xen hypervisor. The differences that you should consider between these hypervisors are covered in the <a href="http://aws.amazon.com/ec2/faqs/#Nitro_Hypervisor">Nitro Hypervisor</a> section of the Amazon EC2 frequently asked questions. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html#ec2-nitro-instances">Instances built on the Nitro System</a> in the <i>Amazon EC2 User Guide for Linux</i>, or <a href="https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/instance-types.html#ec2-nitro-instances">Instances built on the Nitro System</a> in the <i>Amazon EC2 User Guide for Windows</i>.</p> </li> <li> <p> <b> <code>NetworkInterface</code> </b> — The network interface of the recommended instance type is different than that of the current instance. For example, the recommended instance type supports enhanced networking and the current instance might not. To enable enhanced networking for the recommended instance type, you must install the Elastic Network Adapter (ENA) driver or the Intel 82599 Virtual Function driver. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html#instance-networking-storage">Networking and storage features</a> and <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/enhanced-networking.html">Enhanced networking on Linux</a> in the <i>Amazon EC2 User Guide for Linux</i>, or <a href="https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/instance-types.html#instance-networking-storage">Networking and storage features</a> and <a href="https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/enhanced-networking.html">Enhanced networking on Windows</a> in the <i>Amazon EC2 User Guide for Windows</i>.</p> </li> <li> <p> <b> <code>StorageInterface</code> </b> — The storage interface of the recommended instance type is different than that of the current instance. For example, the recommended instance type uses an NVMe storage interface and the current instance does not. To access NVMe volumes for the recommended instance type, you will need to install or upgrade the NVMe driver. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html#instance-networking-storage">Networking and storage features</a> and <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/nvme-ebs-volumes.html">Amazon EBS and NVMe on Linux instances</a> in the <i>Amazon EC2 User Guide for Linux</i>, or <a href="https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/instance-types.html#instance-networking-storage">Networking and storage features</a> and <a href="https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/nvme-ebs-volumes.html">Amazon EBS and NVMe on Windows instances</a> in the <i>Amazon EC2 User Guide for Windows</i>.</p> </li> <li> <p> <b> <code>InstanceStoreAvailability</code> </b> — The recommended instance type does not support instance store volumes and the current instance does. Before migrating, you might need to back up the data on your instance store volumes if you want to preserve them. For more information, see <a href="https://aws.amazon.com/premiumsupport/knowledge-center/back-up-instance-store-ebs/">How do I back up an instance store volume on my Amazon EC2 instance to Amazon EBS?</a> in the <i>Amazon Web Services Premium Support Knowledge Base</i>. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html#instance-networking-storage">Networking and storage features</a> and <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/InstanceStorage.html">Amazon EC2 instance store</a> in the <i>Amazon EC2 User Guide for Linux</i>, or see <a href="https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/instance-types.html#instance-networking-storage">Networking and storage features</a> and <a href="https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/InstanceStorage.html">Amazon EC2 instance store</a> in the <i>Amazon EC2 User Guide for Windows</i>.</p> </li> <li> <p> <b> <code>VirtualizationType</code> </b> — The recommended instance type uses the hardware virtual machine (HVM) virtualization type and the current instance uses the paravirtual (PV) virtualization type. For more information about the differences between these virtualization types, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/virtualization_types.html">Linux AMI virtualization types</a> in the <i>Amazon EC2 User Guide for Linux</i>, or <a href="https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/windows-ami-version-history.html#virtualization-types">Windows AMI virtualization types</a> in the <i>Amazon EC2 User Guide for Windows</i>.</p> </li> <li> <p> <b> <code>Architecture</code> </b> — The CPU architecture between the recommended instance type and the current instance is different. For example, the recommended instance type might use an Arm CPU architecture and the current instance type might use a different one, such as x86. Before migrating, you should consider recompiling the software on your instance for the new architecture. Alternatively, you might switch to an Amazon Machine Image (AMI) that supports the new architecture. For more information about the CPU architecture for each instance type, see <a href="http://aws.amazon.com/ec2/instance-types/">Amazon EC2 Instance Types</a>.</p> </li> </ul>', ], ], 'ProjectedMetric' => [ 'base' => '<p>Describes a projected utilization metric of a recommendation option, such as an Amazon EC2 instance. This represents the projected utilization of a recommendation option had you used that resource during the analyzed period.</p> <p>Compare the utilization metric data of your resource against its projected utilization metric data to determine the performance difference between your current resource and the recommended option.</p> <note> <p>The <code>Cpu</code> and <code>Memory</code> metrics are the only projected utilization metrics returned when you run the <a>GetEC2RecommendationProjectedMetrics</a> action. Additionally, the <code>Memory</code> metric is returned only for resources that have the unified CloudWatch agent installed on them. For more information, see <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/metrics.html#cw-agent">Enabling Memory Utilization with the CloudWatch Agent</a>.</p> </note>', 'refs' => [ 'ProjectedMetrics$member' => NULL, ], ], 'ProjectedMetrics' => [ 'base' => NULL, 'refs' => [ 'RecommendedOptionProjectedMetric$projectedMetrics' => '<p>An array of objects that describe a projected utilization metric.</p>', ], ], 'ProjectedUtilizationMetrics' => [ 'base' => NULL, 'refs' => [ 'AutoScalingGroupRecommendationOption$projectedUtilizationMetrics' => '<p>An array of objects that describe the projected utilization metrics of the Auto Scaling group recommendation option.</p> <note> <p>The <code>Cpu</code> and <code>Memory</code> metrics are the only projected utilization metrics returned. Additionally, the <code>Memory</code> metric is returned only for resources that have the unified CloudWatch agent installed on them. For more information, see <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/metrics.html#cw-agent">Enabling Memory Utilization with the CloudWatch Agent</a>.</p> </note>', 'InstanceRecommendationOption$projectedUtilizationMetrics' => '<p>An array of objects that describe the projected utilization metrics of the instance recommendation option.</p> <note> <p>The <code>Cpu</code> and <code>Memory</code> metrics are the only projected utilization metrics returned. Additionally, the <code>Memory</code> metric is returned only for resources that have the unified CloudWatch agent installed on them. For more information, see <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/metrics.html#cw-agent">Enabling Memory Utilization with the CloudWatch Agent</a>.</p> </note>', ], ], 'Rank' => [ 'base' => NULL, 'refs' => [ 'AutoScalingGroupRecommendationOption$rank' => '<p>The rank of the Auto Scaling group recommendation option.</p> <p>The top recommendation option is ranked as <code>1</code>.</p>', 'InstanceRecommendationOption$rank' => '<p>The rank of the instance recommendation option.</p> <p>The top recommendation option is ranked as <code>1</code>.</p>', 'LambdaFunctionMemoryRecommendationOption$rank' => '<p>The rank of the function recommendation option.</p> <p>The top recommendation option is ranked as <code>1</code>.</p>', 'RecommendedOptionProjectedMetric$rank' => '<p>The rank of the recommendation option projected metric.</p> <p>The top recommendation option is ranked as <code>1</code>.</p> <p>The projected metric rank correlates to the recommendation option rank. For example, the projected metric ranked as <code>1</code> is related to the recommendation option that is also ranked as <code>1</code> in the same response.</p>', 'VolumeRecommendationOption$rank' => '<p>The rank of the volume recommendation option.</p> <p>The top recommendation option is ranked as <code>1</code>.</p>', ], ], 'ReasonCodeSummaries' => [ 'base' => NULL, 'refs' => [ 'Summary$reasonCodeSummaries' => '<p>An array of objects that summarize a finding reason code.</p>', ], ], 'ReasonCodeSummary' => [ 'base' => '<p>A summary of a finding reason code.</p>', 'refs' => [ 'ReasonCodeSummaries$member' => NULL, ], ], 'RecommendationExportJob' => [ 'base' => '<p>Describes a recommendation export job.</p> <p>Use the <a>DescribeRecommendationExportJobs</a> action to view your recommendation export jobs.</p> <p>Use the <a>ExportAutoScalingGroupRecommendations</a> or <a>ExportEC2InstanceRecommendations</a> actions to request an export of your recommendations.</p>', 'refs' => [ 'RecommendationExportJobs$member' => NULL, ], ], 'RecommendationExportJobs' => [ 'base' => NULL, 'refs' => [ 'DescribeRecommendationExportJobsResponse$recommendationExportJobs' => '<p>An array of objects that describe recommendation export jobs.</p>', ], ], 'RecommendationOptions' => [ 'base' => NULL, 'refs' => [ 'InstanceRecommendation$recommendationOptions' => '<p>An array of objects that describe the recommendation options for the instance.</p>', ], ], 'RecommendationPreferences' => [ 'base' => '<p>Describes preferences for recommendations.</p>', 'refs' => [ 'ExportAutoScalingGroupRecommendationsRequest$recommendationPreferences' => '<p>An object to specify the preferences for the Auto Scaling group recommendations to export.</p>', 'ExportEC2InstanceRecommendationsRequest$recommendationPreferences' => '<p>An object to specify the preferences for the Amazon EC2 instance recommendations to export.</p>', 'GetAutoScalingGroupRecommendationsRequest$recommendationPreferences' => '<p>An object to specify the preferences for the Auto Scaling group recommendations to return in the response.</p>', 'GetEC2InstanceRecommendationsRequest$recommendationPreferences' => '<p>An object to specify the preferences for the Amazon EC2 instance recommendations to return in the response.</p>', 'GetEC2RecommendationProjectedMetricsRequest$recommendationPreferences' => '<p>An object to specify the preferences for the Amazon EC2 recommendation projected metrics to return in the response.</p>', ], ], 'RecommendationSource' => [ 'base' => '<p>Describes the source of a recommendation, such as an Amazon EC2 instance or Auto Scaling group.</p>', 'refs' => [ 'RecommendationSources$member' => NULL, ], ], 'RecommendationSourceArn' => [ 'base' => NULL, 'refs' => [ 'RecommendationSource$recommendationSourceArn' => '<p>The Amazon Resource Name (ARN) of the recommendation source.</p>', ], ], 'RecommendationSourceType' => [ 'base' => NULL, 'refs' => [ 'RecommendationSource$recommendationSourceType' => '<p>The resource type of the recommendation source.</p>', 'RecommendationSummary$recommendationResourceType' => '<p>The resource type of the recommendation.</p>', ], ], 'RecommendationSources' => [ 'base' => NULL, 'refs' => [ 'InstanceRecommendation$recommendationSources' => '<p>An array of objects that describe the source resource of the recommendation.</p>', ], ], 'RecommendationSummaries' => [ 'base' => NULL, 'refs' => [ 'GetRecommendationSummariesResponse$recommendationSummaries' => '<p>An array of objects that summarize a recommendation.</p>', ], ], 'RecommendationSummary' => [ 'base' => '<p>A summary of a recommendation.</p>', 'refs' => [ 'RecommendationSummaries$member' => NULL, ], ], 'RecommendedInstanceType' => [ 'base' => NULL, 'refs' => [ 'RecommendedOptionProjectedMetric$recommendedInstanceType' => '<p>The recommended instance type.</p>', ], ], 'RecommendedOptionProjectedMetric' => [ 'base' => '<p>Describes a projected utilization metric of a recommendation option.</p> <note> <p>The <code>Cpu</code> and <code>Memory</code> metrics are the only projected utilization metrics returned when you run the <a>GetEC2RecommendationProjectedMetrics</a> action. Additionally, the <code>Memory</code> metric is returned only for resources that have the unified CloudWatch agent installed on them. For more information, see <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/metrics.html#cw-agent">Enabling Memory Utilization with the CloudWatch Agent</a>.</p> </note>', 'refs' => [ 'RecommendedOptionProjectedMetrics$member' => NULL, ], ], 'RecommendedOptionProjectedMetrics' => [ 'base' => NULL, 'refs' => [ 'GetEC2RecommendationProjectedMetricsResponse$recommendedOptionProjectedMetrics' => '<p>An array of objects that describes projected metrics.</p>', ], ], 'ResourceNotFoundException' => [ 'base' => '<p>A resource that is required for the action doesn\'t exist.</p>', 'refs' => [], ], 'ResourceType' => [ 'base' => NULL, 'refs' => [ 'RecommendationExportJob$resourceType' => '<p>The resource type of the exported recommendations.</p>', ], ], 'S3Destination' => [ 'base' => '<p>Describes the destination Amazon Simple Storage Service (Amazon S3) bucket name and object keys of a recommendations export file, and its associated metadata file.</p>', 'refs' => [ 'ExportAutoScalingGroupRecommendationsResponse$s3Destination' => '<p>An object that describes the destination Amazon S3 bucket of a recommendations export file.</p>', 'ExportDestination$s3' => '<p>An object that describes the destination Amazon Simple Storage Service (Amazon S3) bucket name and object keys of a recommendations export file, and its associated metadata file.</p>', 'ExportEBSVolumeRecommendationsResponse$s3Destination' => NULL, 'ExportEC2InstanceRecommendationsResponse$s3Destination' => '<p>An object that describes the destination Amazon S3 bucket of a recommendations export file.</p>', 'ExportLambdaFunctionRecommendationsResponse$s3Destination' => NULL, ], ], 'S3DestinationConfig' => [ 'base' => '<p>Describes the destination Amazon Simple Storage Service (Amazon S3) bucket name and key prefix for a recommendations export job.</p> <p>You must create the destination Amazon S3 bucket for your recommendations export before you create the export job. Compute Optimizer does not create the S3 bucket for you. After you create the S3 bucket, ensure that it has the required permission policy to allow Compute Optimizer to write the export file to it. If you plan to specify an object prefix when you create the export job, you must include the object prefix in the policy that you add to the S3 bucket. For more information, see <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/create-s3-bucket-policy-for-compute-optimizer.html">Amazon S3 Bucket Policy for Compute Optimizer</a> in the <i>Compute Optimizer User Guide</i>.</p>', 'refs' => [ 'ExportAutoScalingGroupRecommendationsRequest$s3DestinationConfig' => '<p>An object to specify the destination Amazon Simple Storage Service (Amazon S3) bucket name and key prefix for the export job.</p> <p>You must create the destination Amazon S3 bucket for your recommendations export before you create the export job. Compute Optimizer does not create the S3 bucket for you. After you create the S3 bucket, ensure that it has the required permissions policy to allow Compute Optimizer to write the export file to it. If you plan to specify an object prefix when you create the export job, you must include the object prefix in the policy that you add to the S3 bucket. For more information, see <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/create-s3-bucket-policy-for-compute-optimizer.html">Amazon S3 Bucket Policy for Compute Optimizer</a> in the <i>Compute Optimizer User Guide</i>.</p>', 'ExportEBSVolumeRecommendationsRequest$s3DestinationConfig' => NULL, 'ExportEC2InstanceRecommendationsRequest$s3DestinationConfig' => '<p>An object to specify the destination Amazon Simple Storage Service (Amazon S3) bucket name and key prefix for the export job.</p> <p>You must create the destination Amazon S3 bucket for your recommendations export before you create the export job. Compute Optimizer does not create the S3 bucket for you. After you create the S3 bucket, ensure that it has the required permissions policy policy to allow Compute Optimizer to write the export file to it. If you plan to specify an object prefix when you create the export job, you must include the object prefix in the that you add to the S3 bucket. For more information, see <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/create-s3-bucket-policy-for-compute-optimizer.html">Amazon S3 Bucket Policy for Compute Optimizer</a> in the <i>Compute Optimizer User Guide</i>.</p>', 'ExportLambdaFunctionRecommendationsRequest$s3DestinationConfig' => NULL, ], ], 'ServiceUnavailableException' => [ 'base' => '<p>The request has failed due to a temporary failure of the server.</p>', 'refs' => [], ], 'Status' => [ 'base' => NULL, 'refs' => [ 'AccountEnrollmentStatus$status' => '<p>The account enrollment status.</p>', 'GetEnrollmentStatusResponse$status' => '<p>The enrollment status of the account.</p>', 'UpdateEnrollmentStatusRequest$status' => '<p>The new enrollment status of the account.</p> <p>The following status options are available:</p> <ul> <li> <p> <code>Active</code> - Opts in your account to the Compute Optimizer service. Compute Optimizer begins analyzing the configuration and utilization metrics of your Amazon Web Services resources after you opt in. For more information, see <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/metrics.html">Metrics analyzed by Compute Optimizer</a> in the <i>Compute Optimizer User Guide</i>.</p> </li> <li> <p> <code>Inactive</code> - Opts out your account from the Compute Optimizer service. Your account\'s recommendations and related metrics data will be deleted from Compute Optimizer after you opt out.</p> </li> </ul> <note> <p>The <code>Pending</code> and <code>Failed</code> options cannot be used to update the enrollment status of an account. They are returned in the response of a request to update the enrollment status of an account.</p> </note>', 'UpdateEnrollmentStatusResponse$status' => '<p>The enrollment status of the account.</p>', ], ], 'StatusReason' => [ 'base' => NULL, 'refs' => [ 'AccountEnrollmentStatus$statusReason' => '<p>The reason for the account enrollment status.</p> <p>For example, an account might show a status of <code>Pending</code> because member accounts of an organization require more time to be enrolled in the service.</p>', 'GetEnrollmentStatusResponse$statusReason' => '<p>The reason for the enrollment status of the account.</p> <p>For example, an account might show a status of <code>Pending</code> because member accounts of an organization require more time to be enrolled in the service.</p>', 'UpdateEnrollmentStatusResponse$statusReason' => '<p>The reason for the enrollment status of the account. For example, an account might show a status of <code>Pending</code> because member accounts of an organization require more time to be enrolled in the service.</p>', ], ], 'Summaries' => [ 'base' => NULL, 'refs' => [ 'RecommendationSummary$summaries' => '<p>An array of objects that describe a recommendation summary.</p>', ], ], 'Summary' => [ 'base' => '<p>The summary of a recommendation.</p>', 'refs' => [ 'Summaries$member' => NULL, ], ], 'SummaryValue' => [ 'base' => NULL, 'refs' => [ 'ReasonCodeSummary$value' => '<p>The value of the finding reason code summary.</p>', 'Summary$value' => '<p>The value of the recommendation summary.</p>', ], ], 'ThrottlingException' => [ 'base' => '<p>The request was denied due to request throttling.</p>', 'refs' => [], ], 'Timestamp' => [ 'base' => NULL, 'refs' => [ 'GetEC2RecommendationProjectedMetricsRequest$startTime' => '<p>The timestamp of the first projected metrics data point to return.</p>', 'GetEC2RecommendationProjectedMetricsRequest$endTime' => '<p>The timestamp of the last projected metrics data point to return.</p>', 'Timestamps$member' => NULL, ], ], 'Timestamps' => [ 'base' => NULL, 'refs' => [ 'ProjectedMetric$timestamps' => '<p>The timestamps of the projected utilization metric.</p>', ], ], 'UpdateEnrollmentStatusRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateEnrollmentStatusResponse' => [ 'base' => NULL, 'refs' => [], ], 'UtilizationMetric' => [ 'base' => '<p>Describes a utilization metric of a resource, such as an Amazon EC2 instance.</p> <p>Compare the utilization metric data of your resource against its projected utilization metric data to determine the performance difference between your current resource and the recommended option.</p>', 'refs' => [ 'ProjectedUtilizationMetrics$member' => NULL, 'UtilizationMetrics$member' => NULL, ], ], 'UtilizationMetrics' => [ 'base' => NULL, 'refs' => [ 'AutoScalingGroupRecommendation$utilizationMetrics' => '<p>An array of objects that describe the utilization metrics of the Auto Scaling group.</p>', 'InstanceRecommendation$utilizationMetrics' => '<p>An array of objects that describe the utilization metrics of the instance.</p>', ], ], 'VolumeArn' => [ 'base' => NULL, 'refs' => [ 'VolumeArns$member' => NULL, 'VolumeRecommendation$volumeArn' => '<p>The Amazon Resource Name (ARN) of the current volume.</p>', ], ], 'VolumeArns' => [ 'base' => NULL, 'refs' => [ 'GetEBSVolumeRecommendationsRequest$volumeArns' => '<p>The Amazon Resource Name (ARN) of the volumes for which to return recommendations.</p>', ], ], 'VolumeBaselineIOPS' => [ 'base' => NULL, 'refs' => [ 'VolumeConfiguration$volumeBaselineIOPS' => '<p>The baseline IOPS of the volume.</p>', ], ], 'VolumeBaselineThroughput' => [ 'base' => NULL, 'refs' => [ 'VolumeConfiguration$volumeBaselineThroughput' => '<p>The baseline throughput of the volume.</p>', ], ], 'VolumeBurstIOPS' => [ 'base' => NULL, 'refs' => [ 'VolumeConfiguration$volumeBurstIOPS' => '<p>The burst IOPS of the volume.</p>', ], ], 'VolumeBurstThroughput' => [ 'base' => NULL, 'refs' => [ 'VolumeConfiguration$volumeBurstThroughput' => '<p>The burst throughput of the volume.</p>', ], ], 'VolumeConfiguration' => [ 'base' => '<p>Describes the configuration of an Amazon Elastic Block Store (Amazon EBS) volume.</p>', 'refs' => [ 'VolumeRecommendation$currentConfiguration' => '<p>An array of objects that describe the current configuration of the volume.</p>', 'VolumeRecommendationOption$configuration' => '<p>An array of objects that describe a volume configuration.</p>', ], ], 'VolumeRecommendation' => [ 'base' => '<p>Describes an Amazon Elastic Block Store (Amazon EBS) volume recommendation.</p>', 'refs' => [ 'VolumeRecommendations$member' => NULL, ], ], 'VolumeRecommendationOption' => [ 'base' => '<p>Describes a recommendation option for an Amazon Elastic Block Store (Amazon EBS) instance.</p>', 'refs' => [ 'VolumeRecommendationOptions$member' => NULL, ], ], 'VolumeRecommendationOptions' => [ 'base' => NULL, 'refs' => [ 'VolumeRecommendation$volumeRecommendationOptions' => '<p>An array of objects that describe the recommendation options for the volume.</p>', ], ], 'VolumeRecommendations' => [ 'base' => NULL, 'refs' => [ 'GetEBSVolumeRecommendationsResponse$volumeRecommendations' => '<p>An array of objects that describe volume recommendations.</p>', ], ], 'VolumeSize' => [ 'base' => NULL, 'refs' => [ 'VolumeConfiguration$volumeSize' => '<p>The size of the volume, in GiB.</p>', ], ], 'VolumeType' => [ 'base' => NULL, 'refs' => [ 'VolumeConfiguration$volumeType' => '<p>The volume type.</p> <p>This can be <code>gp2</code> for General Purpose SSD, <code>io1</code> or <code>io2</code> for Provisioned IOPS SSD, <code>st1</code> for Throughput Optimized HDD, <code>sc1</code> for Cold HDD, or <code>standard</code> for Magnetic volumes.</p>', ], ], ],];
