<?php
// This file was auto-generated from sdk-root/src/data/chime-sdk-identity/2021-04-20/docs-2.json
return [ 'version' => '2.0', 'service' => '<p>The Amazon Chime SDK Identity APIs in this section allow software developers to create and manage unique instances of their messaging applications. These APIs provide the overarching framework for creating and sending messages. For more information about the identity APIs, refer to <a href="https://docs.aws.amazon.com/chime/latest/APIReference/API_Operations_Amazon_Chime_SDK_Identity.html">Amazon Chime SDK identity</a>.</p>', 'operations' => [ 'CreateAppInstance' => '<p>Creates an Amazon Chime SDK messaging <code>AppInstance</code> under an AWS account. Only SDK messaging customers use this API. <code>CreateAppInstance</code> supports idempotency behavior as described in the AWS API Standard.</p> <p>identity</p>', 'CreateAppInstanceAdmin' => '<p>Promotes an <code>AppInstanceUser</code> to an <code>AppInstanceAdmin</code>. The promoted user can perform the following actions. </p> <ul> <li> <p> <code>ChannelModerator</code> actions across all channels in the <code>AppInstance</code>.</p> </li> <li> <p> <code>DeleteChannelMessage</code> actions.</p> </li> </ul> <p>Only an <code>AppInstanceUser</code> can be promoted to an <code>AppInstanceAdmin</code> role.</p>', 'CreateAppInstanceUser' => '<p>Creates a user under an Amazon Chime <code>AppInstance</code>. The request consists of a unique <code>appInstanceUserId</code> and <code>Name</code> for that user.</p>', 'DeleteAppInstance' => '<p>Deletes an <code>AppInstance</code> and all associated data asynchronously.</p>', 'DeleteAppInstanceAdmin' => '<p>Demotes an <code>AppInstanceAdmin</code> to an <code>AppInstanceUser</code>. This action does not delete the user.</p>', 'DeleteAppInstanceUser' => '<p>Deletes an <code>AppInstanceUser</code>.</p>', 'DescribeAppInstance' => '<p>Returns the full details of an <code>AppInstance</code>.</p>', 'DescribeAppInstanceAdmin' => '<p>Returns the full details of an <code>AppInstanceAdmin</code>.</p>', 'DescribeAppInstanceUser' => '<p>Returns the full details of an <code>AppInstanceUser</code>.</p>', 'GetAppInstanceRetentionSettings' => '<p>Gets the retention settings for an <code>AppInstance</code>.</p>', 'ListAppInstanceAdmins' => '<p>Returns a list of the administrators in the <code>AppInstance</code>.</p>', 'ListAppInstanceUsers' => '<p>List all <code>AppInstanceUsers</code> created under a single <code>AppInstance</code>.</p>', 'ListAppInstances' => '<p>Lists all Amazon Chime <code>AppInstance</code>s created under a single AWS account.</p>', 'PutAppInstanceRetentionSettings' => '<p>Sets the amount of time in days that a given <code>AppInstance</code> retains data.</p>', 'UpdateAppInstance' => '<p>Updates <code>AppInstance</code> metadata.</p>', 'UpdateAppInstanceUser' => '<p>Updates the details of an <code>AppInstanceUser</code>. You can update names and metadata.</p>', ], 'shapes' => [ 'AppInstance' => [ 'base' => '<p>The details of an <code>AppInstance</code>, an instance of an Amazon Chime SDK messaging application.</p>', 'refs' => [ 'DescribeAppInstanceResponse$AppInstance' => '<p>The ARN, metadata, created and last-updated timestamps, and the name of the <code>AppInstance</code>. All timestamps use epoch milliseconds.</p>', ], ], 'AppInstanceAdmin' => [ 'base' => '<p>The details of an <code>AppInstanceAdmin</code>.</p>', 'refs' => [ 'DescribeAppInstanceAdminResponse$AppInstanceAdmin' => '<p>The ARN and name of the <code>AppInstanceUser</code>, the ARN of the <code>AppInstance</code>, and the created and last-updated timestamps. All timestamps use epoch milliseconds.</p>', ], ], 'AppInstanceAdminList' => [ 'base' => NULL, 'refs' => [ 'ListAppInstanceAdminsResponse$AppInstanceAdmins' => '<p>The information for each administrator.</p>', ], ], 'AppInstanceAdminSummary' => [ 'base' => '<p>Summary of the details of an <code>AppInstanceAdmin</code>.</p>', 'refs' => [ 'AppInstanceAdminList$member' => NULL, ], ], 'AppInstanceList' => [ 'base' => NULL, 'refs' => [ 'ListAppInstancesResponse$AppInstances' => '<p>The information for each <code>AppInstance</code>.</p>', ], ], 'AppInstanceRetentionSettings' => [ 'base' => '<p>The details of the data-retention settings for an <code>AppInstance</code>.</p>', 'refs' => [ 'GetAppInstanceRetentionSettingsResponse$AppInstanceRetentionSettings' => '<p>The retention settings for the <code>AppInstance</code>.</p>', 'PutAppInstanceRetentionSettingsRequest$AppInstanceRetentionSettings' => '<p>The time in days to retain data. Data type: number.</p>', 'PutAppInstanceRetentionSettingsResponse$AppInstanceRetentionSettings' => '<p>The time in days to retain data. Data type: number.</p>', ], ], 'AppInstanceSummary' => [ 'base' => '<p>Summary of the data for an <code>AppInstance</code>.</p>', 'refs' => [ 'AppInstanceList$member' => NULL, ], ], 'AppInstanceUser' => [ 'base' => '<p>The details of an <code>AppInstanceUser</code>.</p>', 'refs' => [ 'DescribeAppInstanceUserResponse$AppInstanceUser' => '<p>The name of the <code>AppInstanceUser</code>.</p>', ], ], 'AppInstanceUserList' => [ 'base' => NULL, 'refs' => [ 'ListAppInstanceUsersResponse$AppInstanceUsers' => '<p>The information for each requested <code>AppInstanceUser</code>.</p>', ], ], 'AppInstanceUserSummary' => [ 'base' => '<p>Summary of the details of an <code>AppInstanceUser</code>.</p>', 'refs' => [ 'AppInstanceUserList$member' => NULL, ], ], 'BadRequestException' => [ 'base' => '<p>The input parameters don\'t match the service\'s restrictions.</p>', 'refs' => [], ], 'ChannelRetentionSettings' => [ 'base' => '<p>The details of the retention settings for a channel.</p>', 'refs' => [ 'AppInstanceRetentionSettings$ChannelRetentionSettings' => '<p>The length of time in days to retain the messages in a channel.</p>', ], ], 'ChimeArn' => [ 'base' => NULL, 'refs' => [ 'AppInstance$AppInstanceArn' => '<p>The ARN of the messaging instance.</p>', 'AppInstanceAdmin$AppInstanceArn' => '<p>The ARN of the <code>AppInstance</code> for which the user is an administrator.</p>', 'AppInstanceSummary$AppInstanceArn' => '<p>The <code>AppInstance</code> ARN.</p>', 'AppInstanceUser$AppInstanceUserArn' => '<p>The ARN of the <code>AppInstanceUser</code>.</p>', 'AppInstanceUserSummary$AppInstanceUserArn' => '<p>The ARN of the <code>AppInstanceUser</code>.</p>', 'CreateAppInstanceAdminRequest$AppInstanceAdminArn' => '<p>The ARN of the administrator of the current <code>AppInstance</code>.</p>', 'CreateAppInstanceAdminRequest$AppInstanceArn' => '<p>The ARN of the <code>AppInstance</code>.</p>', 'CreateAppInstanceAdminResponse$AppInstanceArn' => '<p>The ARN of the of the admin for the <code>AppInstance</code>.</p>', 'CreateAppInstanceResponse$AppInstanceArn' => '<p>The Amazon Resource Number (ARN) of the <code>AppInstance</code>.</p>', 'CreateAppInstanceUserRequest$AppInstanceArn' => '<p>The ARN of the <code>AppInstance</code> request.</p>', 'CreateAppInstanceUserResponse$AppInstanceUserArn' => '<p>The user\'s ARN.</p>', 'DeleteAppInstanceAdminRequest$AppInstanceAdminArn' => '<p>The ARN of the <code>AppInstance</code>\'s administrator.</p>', 'DeleteAppInstanceAdminRequest$AppInstanceArn' => '<p>The ARN of the <code>AppInstance</code>.</p>', 'DeleteAppInstanceRequest$AppInstanceArn' => '<p>The ARN of the <code>AppInstance</code>.</p>', 'DeleteAppInstanceUserRequest$AppInstanceUserArn' => '<p>The ARN of the user request being deleted.</p>', 'DescribeAppInstanceAdminRequest$AppInstanceAdminArn' => '<p>The ARN of the <code>AppInstanceAdmin</code>.</p>', 'DescribeAppInstanceAdminRequest$AppInstanceArn' => '<p>The ARN of the <code>AppInstance</code>.</p>', 'DescribeAppInstanceRequest$AppInstanceArn' => '<p>The ARN of the <code>AppInstance</code>.</p>', 'DescribeAppInstanceUserRequest$AppInstanceUserArn' => '<p>The ARN of the <code>AppInstanceUser</code>.</p>', 'GetAppInstanceRetentionSettingsRequest$AppInstanceArn' => '<p>The ARN of the <code>AppInstance</code>.</p>', 'Identity$Arn' => '<p>The ARN in an Identity.</p>', 'ListAppInstanceAdminsRequest$AppInstanceArn' => '<p>The ARN of the <code>AppInstance</code>.</p>', 'ListAppInstanceAdminsResponse$AppInstanceArn' => '<p>The ARN of the <code>AppInstance</code>.</p>', 'ListAppInstanceUsersRequest$AppInstanceArn' => '<p>The ARN of the <code>AppInstance</code>.</p>', 'ListAppInstanceUsersResponse$AppInstanceArn' => '<p>The ARN of the <code>AppInstance</code>.</p>', 'PutAppInstanceRetentionSettingsRequest$AppInstanceArn' => '<p>The ARN of the <code>AppInstance</code>.</p>', 'UpdateAppInstanceRequest$AppInstanceArn' => '<p>The ARN of the <code>AppInstance</code>.</p>', 'UpdateAppInstanceResponse$AppInstanceArn' => '<p>The ARN of the <code>AppInstance</code>.</p>', 'UpdateAppInstanceUserRequest$AppInstanceUserArn' => '<p>The ARN of the <code>AppInstanceUser</code>.</p>', 'UpdateAppInstanceUserResponse$AppInstanceUserArn' => '<p>The ARN of the <code>AppInstanceUser</code>.</p>', ], ], 'ClientRequestToken' => [ 'base' => NULL, 'refs' => [ 'CreateAppInstanceRequest$ClientRequestToken' => '<p>The <code>ClientRequestToken</code> of the <code>AppInstance</code>.</p>', 'CreateAppInstanceUserRequest$ClientRequestToken' => '<p>The token assigned to the user requesting an <code>AppInstance</code>.</p>', ], ], 'ConflictException' => [ 'base' => '<p>The request could not be processed because of conflict in the current state of the resource.</p>', 'refs' => [], ], 'CreateAppInstanceAdminRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateAppInstanceAdminResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateAppInstanceRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateAppInstanceResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateAppInstanceUserRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateAppInstanceUserResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteAppInstanceAdminRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteAppInstanceRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteAppInstanceUserRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAppInstanceAdminRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAppInstanceAdminResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAppInstanceRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAppInstanceResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAppInstanceUserRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAppInstanceUserResponse' => [ 'base' => NULL, 'refs' => [], ], 'ErrorCode' => [ 'base' => NULL, 'refs' => [ 'BadRequestException$Code' => NULL, 'ConflictException$Code' => NULL, 'ForbiddenException$Code' => NULL, 'ResourceLimitExceededException$Code' => NULL, 'ServiceFailureException$Code' => NULL, 'ServiceUnavailableException$Code' => NULL, 'ThrottledClientException$Code' => NULL, 'UnauthorizedClientException$Code' => NULL, ], ], 'ForbiddenException' => [ 'base' => '<p>The client is permanently forbidden from making the request.</p>', 'refs' => [], ], 'GetAppInstanceRetentionSettingsRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetAppInstanceRetentionSettingsResponse' => [ 'base' => NULL, 'refs' => [], ], 'Identity' => [ 'base' => '<p>The details of a user.</p>', 'refs' => [ 'AppInstanceAdmin$Admin' => '<p>The <code>AppInstanceAdmin</code> data.</p>', 'AppInstanceAdminSummary$Admin' => '<p>The details of the <code>AppInstanceAdmin</code>.</p>', 'CreateAppInstanceAdminResponse$AppInstanceAdmin' => '<p>The name and ARN of the admin for the <code>AppInstance</code>.</p>', ], ], 'ListAppInstanceAdminsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListAppInstanceAdminsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListAppInstanceUsersRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListAppInstanceUsersResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListAppInstancesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListAppInstancesResponse' => [ 'base' => NULL, 'refs' => [], ], 'MaxResults' => [ 'base' => NULL, 'refs' => [ 'ListAppInstanceAdminsRequest$MaxResults' => '<p>The maximum number of administrators that you want to return.</p>', 'ListAppInstanceUsersRequest$MaxResults' => '<p>The maximum number of requests that you want returned.</p>', 'ListAppInstancesRequest$MaxResults' => '<p>The maximum number of <code>AppInstance</code>s that you want to return.</p>', ], ], 'Metadata' => [ 'base' => NULL, 'refs' => [ 'AppInstance$Metadata' => '<p>The metadata of an <code>AppInstance</code>.</p>', 'AppInstanceSummary$Metadata' => '<p>The metadata of the <code>AppInstance</code>.</p>', 'AppInstanceUser$Metadata' => '<p>The metadata of the <code>AppInstanceUser</code>.</p>', 'AppInstanceUserSummary$Metadata' => '<p>The metadata of the <code>AppInstanceUser</code>.</p>', 'CreateAppInstanceRequest$Metadata' => '<p>The metadata of the <code>AppInstance</code>. Limited to a 1KB string in UTF-8.</p>', 'CreateAppInstanceUserRequest$Metadata' => '<p>The request\'s metadata. Limited to a 1KB string in UTF-8.</p>', 'UpdateAppInstanceRequest$Metadata' => '<p>The metadata that you want to change.</p>', 'UpdateAppInstanceUserRequest$Metadata' => '<p>The metadata of the <code>AppInstanceUser</code>.</p>', ], ], 'NextToken' => [ 'base' => NULL, 'refs' => [ 'ListAppInstanceAdminsRequest$NextToken' => '<p>The token returned from previous API requests until the number of administrators is reached.</p>', 'ListAppInstanceAdminsResponse$NextToken' => '<p>The token returned from previous API requests until the number of administrators is reached.</p>', 'ListAppInstanceUsersRequest$NextToken' => '<p>The token passed by previous API calls until all requested users are returned.</p>', 'ListAppInstanceUsersResponse$NextToken' => '<p>The token passed by previous API calls until all requested users are returned.</p>', 'ListAppInstancesRequest$NextToken' => '<p>The token passed by previous API requests until you reach the maximum number of <code>AppInstances</code>.</p>', 'ListAppInstancesResponse$NextToken' => '<p>The token passed by previous API requests until the maximum number of <code>AppInstance</code>s is reached.</p>', ], ], 'NonEmptyResourceName' => [ 'base' => NULL, 'refs' => [ 'AppInstance$Name' => '<p>The name of an <code>AppInstance</code>.</p>', 'AppInstanceSummary$Name' => '<p>The name of the <code>AppInstance</code>.</p>', 'CreateAppInstanceRequest$Name' => '<p>The name of the <code>AppInstance</code>.</p>', 'UpdateAppInstanceRequest$Name' => '<p>The name that you want to change.</p>', ], ], 'PutAppInstanceRetentionSettingsRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutAppInstanceRetentionSettingsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ResourceLimitExceededException' => [ 'base' => '<p>The request exceeds the resource limit.</p>', 'refs' => [], ], 'ResourceName' => [ 'base' => NULL, 'refs' => [ 'Identity$Name' => '<p>The name in an Identity.</p>', ], ], 'RetentionDays' => [ 'base' => NULL, 'refs' => [ 'ChannelRetentionSettings$RetentionDays' => '<p>The time in days to retain the messages in a channel.</p>', ], ], 'ServiceFailureException' => [ 'base' => '<p>The service encountered an unexpected error.</p>', 'refs' => [], ], 'ServiceUnavailableException' => [ 'base' => '<p>The service is currently unavailable.</p>', 'refs' => [], ], 'String' => [ 'base' => NULL, 'refs' => [ 'BadRequestException$Message' => NULL, 'ConflictException$Message' => NULL, 'ForbiddenException$Message' => NULL, 'ResourceLimitExceededException$Message' => NULL, 'ServiceFailureException$Message' => NULL, 'ServiceUnavailableException$Message' => NULL, 'ThrottledClientException$Message' => NULL, 'UnauthorizedClientException$Message' => NULL, ], ], 'Tag' => [ 'base' => '<p>Describes a tag applied to a resource.</p>', 'refs' => [ 'TagList$member' => NULL, ], ], 'TagKey' => [ 'base' => NULL, 'refs' => [ 'Tag$Key' => '<p>The key of the tag.</p>', ], ], 'TagList' => [ 'base' => NULL, 'refs' => [ 'CreateAppInstanceRequest$Tags' => '<p>Tags assigned to the <code>AppInstanceUser</code>.</p>', 'CreateAppInstanceUserRequest$Tags' => '<p>Tags assigned to the <code>AppInstanceUser</code>.</p>', ], ], 'TagValue' => [ 'base' => NULL, 'refs' => [ 'Tag$Value' => '<p>The value of the tag.</p>', ], ], 'ThrottledClientException' => [ 'base' => '<p>The client exceeded its request rate limit.</p>', 'refs' => [], ], 'Timestamp' => [ 'base' => NULL, 'refs' => [ 'AppInstance$CreatedTimestamp' => '<p>The time at which an <code>AppInstance</code> was created. In epoch milliseconds.</p>', 'AppInstance$LastUpdatedTimestamp' => '<p>The time an <code>AppInstance</code> was last updated. In epoch milliseconds.</p>', 'AppInstanceAdmin$CreatedTimestamp' => '<p>The time at which an administrator was created.</p>', 'AppInstanceUser$CreatedTimestamp' => '<p>The time at which the <code>AppInstanceUser</code> was created.</p>', 'AppInstanceUser$LastUpdatedTimestamp' => '<p>The time at which the <code>AppInstanceUser</code> was last updated.</p>', 'GetAppInstanceRetentionSettingsResponse$InitiateDeletionTimestamp' => '<p>The timestamp representing the time at which the specified items are retained, in Epoch Seconds.</p>', 'PutAppInstanceRetentionSettingsResponse$InitiateDeletionTimestamp' => '<p>The time at which the API deletes data.</p>', ], ], 'UnauthorizedClientException' => [ 'base' => '<p>The client is not currently authorized to make the request.</p>', 'refs' => [], ], 'UpdateAppInstanceRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateAppInstanceResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateAppInstanceUserRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateAppInstanceUserResponse' => [ 'base' => NULL, 'refs' => [], ], 'UserId' => [ 'base' => NULL, 'refs' => [ 'CreateAppInstanceUserRequest$AppInstanceUserId' => '<p>The user ID of the <code>AppInstance</code>.</p>', ], ], 'UserName' => [ 'base' => NULL, 'refs' => [ 'AppInstanceUser$Name' => '<p>The name of the <code>AppInstanceUser</code>.</p>', 'AppInstanceUserSummary$Name' => '<p>The name of an <code>AppInstanceUser</code>.</p>', 'CreateAppInstanceUserRequest$Name' => '<p>The user\'s name.</p>', 'UpdateAppInstanceUserRequest$Name' => '<p>The name of the <code>AppInstanceUser</code>.</p>', ], ], ],];
