<?php
// This file was auto-generated from sdk-root/src/data/accessanalyzer/2019-11-01/docs-2.json
return [ 'version' => '2.0', 'service' => '<p>Identity and Access Management Access Analyzer helps identify potential resource-access risks by enabling you to identify any policies that grant access to an external principal. It does this by using logic-based reasoning to analyze resource-based policies in your Amazon Web Services environment. An external principal can be another Amazon Web Services account, a root user, an IAM user or role, a federated user, an Amazon Web Services service, or an anonymous user. You can also use IAM Access Analyzer to preview and validate public and cross-account access to your resources before deploying permissions changes. This guide describes the Identity and Access Management Access Analyzer operations that you can call programmatically. For general information about IAM Access Analyzer, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/what-is-access-analyzer.html">Identity and Access Management Access Analyzer</a> in the <b>IAM User Guide</b>.</p> <p>To start using IAM Access Analyzer, you first need to create an analyzer.</p>', 'operations' => [ 'ApplyArchiveRule' => '<p>Retroactively applies the archive rule to existing findings that meet the archive rule criteria.</p>', 'CancelPolicyGeneration' => '<p>Cancels the requested policy generation.</p>', 'CreateAccessPreview' => '<p>Creates an access preview that allows you to preview IAM Access Analyzer findings for your resource before deploying resource permissions.</p>', 'CreateAnalyzer' => '<p>Creates an analyzer for your account.</p>', 'CreateArchiveRule' => '<p>Creates an archive rule for the specified analyzer. Archive rules automatically archive new findings that meet the criteria you define when you create the rule.</p> <p>To learn about filter keys that you can use to create an archive rule, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access-analyzer-reference-filter-keys.html">IAM Access Analyzer filter keys</a> in the <b>IAM User Guide</b>.</p>', 'DeleteAnalyzer' => '<p>Deletes the specified analyzer. When you delete an analyzer, IAM Access Analyzer is disabled for the account or organization in the current or specific Region. All findings that were generated by the analyzer are deleted. You cannot undo this action.</p>', 'DeleteArchiveRule' => '<p>Deletes the specified archive rule.</p>', 'GetAccessPreview' => '<p>Retrieves information about an access preview for the specified analyzer.</p>', 'GetAnalyzedResource' => '<p>Retrieves information about a resource that was analyzed.</p>', 'GetAnalyzer' => '<p>Retrieves information about the specified analyzer.</p>', 'GetArchiveRule' => '<p>Retrieves information about an archive rule.</p> <p>To learn about filter keys that you can use to create an archive rule, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access-analyzer-reference-filter-keys.html">IAM Access Analyzer filter keys</a> in the <b>IAM User Guide</b>.</p>', 'GetFinding' => '<p>Retrieves information about the specified finding.</p>', 'GetGeneratedPolicy' => '<p>Retrieves the policy that was generated using <code>StartPolicyGeneration</code>. </p>', 'ListAccessPreviewFindings' => '<p>Retrieves a list of access preview findings generated by the specified access preview.</p>', 'ListAccessPreviews' => '<p>Retrieves a list of access previews for the specified analyzer.</p>', 'ListAnalyzedResources' => '<p>Retrieves a list of resources of the specified type that have been analyzed by the specified analyzer..</p>', 'ListAnalyzers' => '<p>Retrieves a list of analyzers.</p>', 'ListArchiveRules' => '<p>Retrieves a list of archive rules created for the specified analyzer.</p>', 'ListFindings' => '<p>Retrieves a list of findings generated by the specified analyzer.</p> <p>To learn about filter keys that you can use to retrieve a list of findings, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access-analyzer-reference-filter-keys.html">IAM Access Analyzer filter keys</a> in the <b>IAM User Guide</b>.</p>', 'ListPolicyGenerations' => '<p>Lists all of the policy generations requested in the last seven days.</p>', 'ListTagsForResource' => '<p>Retrieves a list of tags applied to the specified resource.</p>', 'StartPolicyGeneration' => '<p>Starts the policy generation request.</p>', 'StartResourceScan' => '<p>Immediately starts a scan of the policies applied to the specified resource.</p>', 'TagResource' => '<p>Adds a tag to the specified resource.</p>', 'UntagResource' => '<p>Removes a tag from the specified resource.</p>', 'UpdateArchiveRule' => '<p>Updates the criteria and values for the specified archive rule.</p>', 'UpdateFindings' => '<p>Updates the status for the specified findings.</p>', 'ValidatePolicy' => '<p>Requests the validation of a policy and returns a list of findings. The findings help you identify issues and provide actionable recommendations to resolve the issue and enable you to author functional policies that meet security best practices. </p>', ], 'shapes' => [ 'AccessDeniedException' => [ 'base' => '<p>You do not have sufficient access to perform this action.</p>', 'refs' => [], ], 'AccessPointArn' => [ 'base' => NULL, 'refs' => [ 'S3AccessPointConfigurationsMap$key' => NULL, ], ], 'AccessPointPolicy' => [ 'base' => NULL, 'refs' => [ 'S3AccessPointConfiguration$accessPointPolicy' => '<p>The access point or multi-region access point policy.</p>', ], ], 'AccessPreview' => [ 'base' => '<p>Contains information about an access preview.</p>', 'refs' => [ 'GetAccessPreviewResponse$accessPreview' => '<p>An object that contains information about the access preview.</p>', ], ], 'AccessPreviewFinding' => [ 'base' => '<p>An access preview finding generated by the access preview.</p>', 'refs' => [ 'AccessPreviewFindingsList$member' => NULL, ], ], 'AccessPreviewFindingId' => [ 'base' => NULL, 'refs' => [ 'AccessPreviewFinding$id' => '<p>The ID of the access preview finding. This ID uniquely identifies the element in the list of access preview findings and is not related to the finding ID in Access Analyzer.</p>', ], ], 'AccessPreviewFindingsList' => [ 'base' => NULL, 'refs' => [ 'ListAccessPreviewFindingsResponse$findings' => '<p>A list of access preview findings that match the specified filter criteria.</p>', ], ], 'AccessPreviewId' => [ 'base' => NULL, 'refs' => [ 'AccessPreview$id' => '<p>The unique ID for the access preview.</p>', 'AccessPreviewSummary$id' => '<p>The unique ID for the access preview.</p>', 'CreateAccessPreviewResponse$id' => '<p>The unique ID for the access preview.</p>', 'GetAccessPreviewRequest$accessPreviewId' => '<p>The unique ID for the access preview.</p>', 'ListAccessPreviewFindingsRequest$accessPreviewId' => '<p>The unique ID for the access preview.</p>', ], ], 'AccessPreviewStatus' => [ 'base' => NULL, 'refs' => [ 'AccessPreview$status' => '<p>The status of the access preview.</p> <ul> <li> <p> <code>Creating</code> - The access preview creation is in progress.</p> </li> <li> <p> <code>Completed</code> - The access preview is complete. You can preview findings for external access to the resource.</p> </li> <li> <p> <code>Failed</code> - The access preview creation has failed.</p> </li> </ul>', 'AccessPreviewSummary$status' => '<p>The status of the access preview.</p> <ul> <li> <p> <code>Creating</code> - The access preview creation is in progress.</p> </li> <li> <p> <code>Completed</code> - The access preview is complete and previews the findings for external access to the resource.</p> </li> <li> <p> <code>Failed</code> - The access preview creation has failed.</p> </li> </ul>', ], ], 'AccessPreviewStatusReason' => [ 'base' => '<p>Provides more details about the current status of the access preview. For example, if the creation of the access preview fails, a <code>Failed</code> status is returned. This failure can be due to an internal issue with the analysis or due to an invalid proposed resource configuration.</p>', 'refs' => [ 'AccessPreview$statusReason' => '<p>Provides more details about the current status of the access preview.</p> <p>For example, if the creation of the access preview fails, a <code>Failed</code> status is returned. This failure can be due to an internal issue with the analysis or due to an invalid resource configuration.</p>', 'AccessPreviewSummary$statusReason' => NULL, ], ], 'AccessPreviewStatusReasonCode' => [ 'base' => NULL, 'refs' => [ 'AccessPreviewStatusReason$code' => '<p>The reason code for the current status of the access preview.</p>', ], ], 'AccessPreviewSummary' => [ 'base' => '<p>Contains a summary of information about an access preview.</p>', 'refs' => [ 'AccessPreviewsList$member' => NULL, ], ], 'AccessPreviewsList' => [ 'base' => NULL, 'refs' => [ 'ListAccessPreviewsResponse$accessPreviews' => '<p>A list of access previews retrieved for the analyzer.</p>', ], ], 'AclCanonicalId' => [ 'base' => NULL, 'refs' => [ 'AclGrantee$id' => '<p>The value specified is the canonical user ID of an Amazon Web Services account.</p>', ], ], 'AclGrantee' => [ 'base' => '<p>You specify each grantee as a type-value pair using one of these types. You can specify only one type of grantee. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketAcl.html">PutBucketAcl</a>.</p>', 'refs' => [ 'S3BucketAclGrantConfiguration$grantee' => '<p>The grantee to whom you’re assigning access rights.</p>', ], ], 'AclPermission' => [ 'base' => NULL, 'refs' => [ 'S3BucketAclGrantConfiguration$permission' => '<p>The permissions being granted.</p>', ], ], 'AclUri' => [ 'base' => NULL, 'refs' => [ 'AclGrantee$uri' => '<p>Used for granting permissions to a predefined group.</p>', ], ], 'ActionList' => [ 'base' => NULL, 'refs' => [ 'AccessPreviewFinding$action' => '<p>The action in the analyzed policy statement that an external principal has permission to perform.</p>', 'AnalyzedResource$actions' => '<p>The actions that an external principal is granted permission to use by the policy that generated the finding.</p>', 'Finding$action' => '<p>The action in the analyzed policy statement that an external principal has permission to use.</p>', 'FindingSummary$action' => '<p>The action in the analyzed policy statement that an external principal has permission to use.</p>', ], ], 'AnalyzedResource' => [ 'base' => '<p>Contains details about the analyzed resource.</p>', 'refs' => [ 'GetAnalyzedResourceResponse$resource' => '<p>An <code>AnalyzedResource</code> object that contains information that IAM Access Analyzer found when it analyzed the resource.</p>', ], ], 'AnalyzedResourceSummary' => [ 'base' => '<p>Contains the ARN of the analyzed resource.</p>', 'refs' => [ 'AnalyzedResourcesList$member' => NULL, ], ], 'AnalyzedResourcesList' => [ 'base' => NULL, 'refs' => [ 'ListAnalyzedResourcesResponse$analyzedResources' => '<p>A list of resources that were analyzed.</p>', ], ], 'AnalyzerArn' => [ 'base' => NULL, 'refs' => [ 'AccessPreview$analyzerArn' => '<p>The ARN of the analyzer used to generate the access preview.</p>', 'AccessPreviewSummary$analyzerArn' => '<p>The ARN of the analyzer used to generate the access preview.</p>', 'AnalyzerSummary$arn' => '<p>The ARN of the analyzer.</p>', 'ApplyArchiveRuleRequest$analyzerArn' => '<p>The Amazon resource name (ARN) of the analyzer.</p>', 'CreateAccessPreviewRequest$analyzerArn' => '<p>The <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access-analyzer-getting-started.html#permission-resources">ARN of the account analyzer</a> used to generate the access preview. You can only create an access preview for analyzers with an <code>Account</code> type and <code>Active</code> status.</p>', 'CreateAnalyzerResponse$arn' => '<p>The ARN of the analyzer that was created by the request.</p>', 'GetAccessPreviewRequest$analyzerArn' => '<p>The <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access-analyzer-getting-started.html#permission-resources">ARN of the analyzer</a> used to generate the access preview.</p>', 'GetAnalyzedResourceRequest$analyzerArn' => '<p>The <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access-analyzer-getting-started.html#permission-resources">ARN of the analyzer</a> to retrieve information from.</p>', 'GetFindingRequest$analyzerArn' => '<p>The <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access-analyzer-getting-started.html#permission-resources">ARN of the analyzer</a> that generated the finding.</p>', 'ListAccessPreviewFindingsRequest$analyzerArn' => '<p>The <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access-analyzer-getting-started.html#permission-resources">ARN of the analyzer</a> used to generate the access.</p>', 'ListAccessPreviewsRequest$analyzerArn' => '<p>The <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access-analyzer-getting-started.html#permission-resources">ARN of the analyzer</a> used to generate the access preview.</p>', 'ListAnalyzedResourcesRequest$analyzerArn' => '<p>The <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access-analyzer-getting-started.html#permission-resources">ARN of the analyzer</a> to retrieve a list of analyzed resources from.</p>', 'ListFindingsRequest$analyzerArn' => '<p>The <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access-analyzer-getting-started.html#permission-resources">ARN of the analyzer</a> to retrieve findings from.</p>', 'StartResourceScanRequest$analyzerArn' => '<p>The <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access-analyzer-getting-started.html#permission-resources">ARN of the analyzer</a> to use to scan the policies applied to the specified resource.</p>', 'UpdateFindingsRequest$analyzerArn' => '<p>The <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access-analyzer-getting-started.html#permission-resources">ARN of the analyzer</a> that generated the findings to update.</p>', ], ], 'AnalyzerStatus' => [ 'base' => NULL, 'refs' => [ 'AnalyzerSummary$status' => '<p>The status of the analyzer. An <code>Active</code> analyzer successfully monitors supported resources and generates new findings. The analyzer is <code>Disabled</code> when a user action, such as removing trusted access for Identity and Access Management Access Analyzer from Organizations, causes the analyzer to stop generating new findings. The status is <code>Creating</code> when the analyzer creation is in progress and <code>Failed</code> when the analyzer creation has failed. </p>', ], ], 'AnalyzerSummary' => [ 'base' => '<p>Contains information about the analyzer.</p>', 'refs' => [ 'AnalyzersList$member' => NULL, 'GetAnalyzerResponse$analyzer' => '<p>An <code>AnalyzerSummary</code> object that contains information about the analyzer.</p>', ], ], 'AnalyzersList' => [ 'base' => NULL, 'refs' => [ 'ListAnalyzersResponse$analyzers' => '<p>The analyzers retrieved.</p>', ], ], 'ApplyArchiveRuleRequest' => [ 'base' => '<p>Retroactively applies an archive rule.</p>', 'refs' => [], ], 'ArchiveRuleSummary' => [ 'base' => '<p>Contains information about an archive rule.</p>', 'refs' => [ 'ArchiveRulesList$member' => NULL, 'GetArchiveRuleResponse$archiveRule' => NULL, ], ], 'ArchiveRulesList' => [ 'base' => NULL, 'refs' => [ 'ListArchiveRulesResponse$archiveRules' => '<p>A list of archive rules created for the specified analyzer.</p>', ], ], 'Boolean' => [ 'base' => NULL, 'refs' => [ 'AccessPreviewFinding$isPublic' => '<p>Indicates whether the policy that generated the finding allows public access to the resource.</p>', 'AnalyzedResource$isPublic' => '<p>Indicates whether the policy that generated the finding grants public access to the resource.</p>', 'Criterion$exists' => '<p>An "exists" operator to match for the filter used to create the rule. </p>', 'Finding$isPublic' => '<p>Indicates whether the policy that generated the finding allows public access to the resource.</p>', 'FindingSummary$isPublic' => '<p>Indicates whether the finding reports a resource that has a policy that allows public access.</p>', 'GeneratedPolicyProperties$isComplete' => '<p>This value is set to <code>true</code> if the generated policy contains all possible actions for a service that IAM Access Analyzer identified from the CloudTrail trail that you specified, and <code>false</code> otherwise.</p>', 'GetGeneratedPolicyRequest$includeResourcePlaceholders' => '<p>The level of detail that you want to generate. You can specify whether to generate policies with placeholders for resource ARNs for actions that support resource level granularity in policies.</p> <p>For example, in the resource section of a policy, you can receive a placeholder such as <code>"Resource":"arn:aws:s3:::${BucketName}"</code> instead of <code>"*"</code>.</p>', 'GetGeneratedPolicyRequest$includeServiceLevelTemplate' => '<p>The level of detail that you want to generate. You can specify whether to generate service-level policies. </p> <p>IAM Access Analyzer uses <code>iam:servicelastaccessed</code> to identify services that have been used recently to create this service-level template.</p>', 'S3PublicAccessBlockConfiguration$ignorePublicAcls' => '<p> Specifies whether Amazon S3 should ignore public ACLs for this bucket and objects in this bucket. </p>', 'S3PublicAccessBlockConfiguration$restrictPublicBuckets' => '<p> Specifies whether Amazon S3 should restrict public bucket policies for this bucket. </p>', 'Trail$allRegions' => '<p>Possible values are <code>true</code> or <code>false</code>. If set to <code>true</code>, IAM Access Analyzer retrieves CloudTrail data from all regions to analyze and generate a policy.</p>', 'TrailProperties$allRegions' => '<p>Possible values are <code>true</code> or <code>false</code>. If set to <code>true</code>, IAM Access Analyzer retrieves CloudTrail data from all regions to analyze and generate a policy.</p>', ], ], 'CancelPolicyGenerationRequest' => [ 'base' => NULL, 'refs' => [], ], 'CancelPolicyGenerationResponse' => [ 'base' => NULL, 'refs' => [], ], 'CloudTrailArn' => [ 'base' => NULL, 'refs' => [ 'Trail$cloudTrailArn' => '<p>Specifies the ARN of the trail. The format of a trail ARN is <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code>.</p>', 'TrailProperties$cloudTrailArn' => '<p>Specifies the ARN of the trail. The format of a trail ARN is <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code>.</p>', ], ], 'CloudTrailDetails' => [ 'base' => '<p>Contains information about CloudTrail access.</p>', 'refs' => [ 'StartPolicyGenerationRequest$cloudTrailDetails' => '<p>A <code>CloudTrailDetails</code> object that contains details about a <code>Trail</code> that you want to analyze to generate policies.</p>', ], ], 'CloudTrailProperties' => [ 'base' => '<p>Contains information about CloudTrail access.</p>', 'refs' => [ 'GeneratedPolicyProperties$cloudTrailProperties' => '<p>Lists details about the <code>Trail</code> used to generated policy.</p>', ], ], 'ConditionKeyMap' => [ 'base' => NULL, 'refs' => [ 'AccessPreviewFinding$condition' => '<p>The condition in the analyzed policy statement that resulted in a finding.</p>', 'Finding$condition' => '<p>The condition in the analyzed policy statement that resulted in a finding.</p>', 'FindingSummary$condition' => '<p>The condition in the analyzed policy statement that resulted in a finding.</p>', ], ], 'Configuration' => [ 'base' => '<p>Access control configuration structures for your resource. You specify the configuration as a type-value pair. You can specify only one type of access control configuration.</p>', 'refs' => [ 'ConfigurationsMap$value' => NULL, ], ], 'ConfigurationsMap' => [ 'base' => NULL, 'refs' => [ 'AccessPreview$configurations' => '<p>A map of resource ARNs for the proposed resource configuration.</p>', 'CreateAccessPreviewRequest$configurations' => '<p>Access control configuration for your resource that is used to generate the access preview. The access preview includes findings for external access allowed to the resource with the proposed access control configuration. The configuration must contain exactly one element.</p>', ], ], 'ConfigurationsMapKey' => [ 'base' => NULL, 'refs' => [ 'ConfigurationsMap$key' => NULL, ], ], 'ConflictException' => [ 'base' => '<p>A conflict exception error.</p>', 'refs' => [], ], 'CreateAccessPreviewRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateAccessPreviewResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateAnalyzerRequest' => [ 'base' => '<p>Creates an analyzer.</p>', 'refs' => [], ], 'CreateAnalyzerResponse' => [ 'base' => '<p>The response to the request to create an analyzer.</p>', 'refs' => [], ], 'CreateArchiveRuleRequest' => [ 'base' => '<p>Creates an archive rule.</p>', 'refs' => [], ], 'Criterion' => [ 'base' => '<p>The criteria to use in the filter that defines the archive rule.</p>', 'refs' => [ 'FilterCriteriaMap$value' => NULL, ], ], 'DeleteAnalyzerRequest' => [ 'base' => '<p>Deletes an analyzer.</p>', 'refs' => [], ], 'DeleteArchiveRuleRequest' => [ 'base' => '<p>Deletes an archive rule.</p>', 'refs' => [], ], 'FilterCriteriaMap' => [ 'base' => NULL, 'refs' => [ 'ArchiveRuleSummary$filter' => '<p>A filter used to define the archive rule.</p>', 'CreateArchiveRuleRequest$filter' => '<p>The criteria for the rule.</p>', 'InlineArchiveRule$filter' => '<p>The condition and values for a criterion.</p>', 'ListAccessPreviewFindingsRequest$filter' => '<p>Criteria to filter the returned findings.</p>', 'ListFindingsRequest$filter' => '<p>A filter to match for the findings to return.</p>', 'UpdateArchiveRuleRequest$filter' => '<p>A filter to match for the rules to update. Only rules that match the filter are updated.</p>', ], ], 'Finding' => [ 'base' => '<p>Contains information about a finding.</p>', 'refs' => [ 'GetFindingResponse$finding' => '<p>A <code>finding</code> object that contains finding details.</p>', ], ], 'FindingChangeType' => [ 'base' => NULL, 'refs' => [ 'AccessPreviewFinding$changeType' => '<p>Provides context on how the access preview finding compares to existing access identified in IAM Access Analyzer.</p> <ul> <li> <p> <code>New</code> - The finding is for newly-introduced access.</p> </li> <li> <p> <code>Unchanged</code> - The preview finding is an existing finding that would remain unchanged.</p> </li> <li> <p> <code>Changed</code> - The preview finding is an existing finding with a change in status.</p> </li> </ul> <p>For example, a <code>Changed</code> finding with preview status <code>Resolved</code> and existing status <code>Active</code> indicates the existing <code>Active</code> finding would become <code>Resolved</code> as a result of the proposed permissions change.</p>', ], ], 'FindingId' => [ 'base' => NULL, 'refs' => [ 'AccessPreviewFinding$existingFindingId' => '<p>The existing ID of the finding in IAM Access Analyzer, provided only for existing findings.</p>', 'Finding$id' => '<p>The ID of the finding.</p>', 'FindingIdList$member' => NULL, 'FindingSummary$id' => '<p>The ID of the finding.</p>', 'GetFindingRequest$id' => '<p>The ID of the finding to retrieve.</p>', ], ], 'FindingIdList' => [ 'base' => NULL, 'refs' => [ 'UpdateFindingsRequest$ids' => '<p>The IDs of the findings to update.</p>', ], ], 'FindingSource' => [ 'base' => '<p>The source of the finding. This indicates how the access that generated the finding is granted. It is populated for Amazon S3 bucket findings.</p>', 'refs' => [ 'FindingSourceList$member' => NULL, ], ], 'FindingSourceDetail' => [ 'base' => '<p>Includes details about how the access that generated the finding is granted. This is populated for Amazon S3 bucket findings.</p>', 'refs' => [ 'FindingSource$detail' => '<p>Includes details about how the access that generated the finding is granted. This is populated for Amazon S3 bucket findings.</p>', ], ], 'FindingSourceList' => [ 'base' => NULL, 'refs' => [ 'AccessPreviewFinding$sources' => '<p>The sources of the finding. This indicates how the access that generated the finding is granted. It is populated for Amazon S3 bucket findings.</p>', 'Finding$sources' => '<p>The sources of the finding. This indicates how the access that generated the finding is granted. It is populated for Amazon S3 bucket findings.</p>', 'FindingSummary$sources' => '<p>The sources of the finding. This indicates how the access that generated the finding is granted. It is populated for Amazon S3 bucket findings.</p>', ], ], 'FindingSourceType' => [ 'base' => NULL, 'refs' => [ 'FindingSource$type' => '<p>Indicates the type of access that generated the finding.</p>', ], ], 'FindingStatus' => [ 'base' => NULL, 'refs' => [ 'AccessPreviewFinding$existingFindingStatus' => '<p>The existing status of the finding, provided only for existing findings.</p>', 'AccessPreviewFinding$status' => '<p>The preview status of the finding. This is what the status of the finding would be after permissions deployment. For example, a <code>Changed</code> finding with preview status <code>Resolved</code> and existing status <code>Active</code> indicates the existing <code>Active</code> finding would become <code>Resolved</code> as a result of the proposed permissions change.</p>', 'AnalyzedResource$status' => '<p>The current status of the finding generated from the analyzed resource.</p>', 'Finding$status' => '<p>The current status of the finding.</p>', 'FindingSummary$status' => '<p>The status of the finding.</p>', ], ], 'FindingStatusUpdate' => [ 'base' => NULL, 'refs' => [ 'UpdateFindingsRequest$status' => '<p>The state represents the action to take to update the finding Status. Use <code>ARCHIVE</code> to change an Active finding to an Archived finding. Use <code>ACTIVE</code> to change an Archived finding to an Active finding.</p>', ], ], 'FindingSummary' => [ 'base' => '<p>Contains information about a finding.</p>', 'refs' => [ 'FindingsList$member' => NULL, ], ], 'FindingsList' => [ 'base' => NULL, 'refs' => [ 'ListFindingsResponse$findings' => '<p>A list of findings retrieved from the analyzer that match the filter criteria specified, if any.</p>', ], ], 'GeneratedPolicy' => [ 'base' => '<p>Contains the text for the generated policy.</p>', 'refs' => [ 'GeneratedPolicyList$member' => NULL, ], ], 'GeneratedPolicyList' => [ 'base' => NULL, 'refs' => [ 'GeneratedPolicyResult$generatedPolicies' => '<p>The text to use as the content for the new policy. The policy is created using the <a href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_CreatePolicy.html">CreatePolicy</a> action.</p>', ], ], 'GeneratedPolicyProperties' => [ 'base' => '<p>Contains the generated policy details.</p>', 'refs' => [ 'GeneratedPolicyResult$properties' => '<p>A <code>GeneratedPolicyProperties</code> object that contains properties of the generated policy.</p>', ], ], 'GeneratedPolicyResult' => [ 'base' => '<p>Contains the text for the generated policy and its details.</p>', 'refs' => [ 'GetGeneratedPolicyResponse$generatedPolicyResult' => '<p>A <code>GeneratedPolicyResult</code> object that contains the generated policies and associated details.</p>', ], ], 'GetAccessPreviewRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetAccessPreviewResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetAnalyzedResourceRequest' => [ 'base' => '<p>Retrieves an analyzed resource.</p>', 'refs' => [], ], 'GetAnalyzedResourceResponse' => [ 'base' => '<p>The response to the request.</p>', 'refs' => [], ], 'GetAnalyzerRequest' => [ 'base' => '<p>Retrieves an analyzer.</p>', 'refs' => [], ], 'GetAnalyzerResponse' => [ 'base' => '<p>The response to the request.</p>', 'refs' => [], ], 'GetArchiveRuleRequest' => [ 'base' => '<p>Retrieves an archive rule.</p>', 'refs' => [], ], 'GetArchiveRuleResponse' => [ 'base' => '<p>The response to the request.</p>', 'refs' => [], ], 'GetFindingRequest' => [ 'base' => '<p>Retrieves a finding.</p>', 'refs' => [], ], 'GetFindingResponse' => [ 'base' => '<p>The response to the request.</p>', 'refs' => [], ], 'GetGeneratedPolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetGeneratedPolicyResponse' => [ 'base' => NULL, 'refs' => [], ], 'GranteePrincipal' => [ 'base' => NULL, 'refs' => [ 'KmsGrantConfiguration$granteePrincipal' => '<p>The principal that is given permission to perform the operations that the grant permits.</p>', ], ], 'IamRoleConfiguration' => [ 'base' => '<p>The proposed access control configuration for an IAM role. You can propose a configuration for a new IAM role or an existing IAM role that you own by specifying the trust policy. If the configuration is for a new IAM role, you must specify the trust policy. If the configuration is for an existing IAM role that you own and you do not propose the trust policy, the access preview uses the existing trust policy for the role. The proposed trust policy cannot be an empty string. For more information about role trust policy limits, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_iam-quotas.html">IAM and STS quotas</a>.</p>', 'refs' => [ 'Configuration$iamRole' => '<p>The access control configuration is for an IAM role. </p>', ], ], 'IamTrustPolicy' => [ 'base' => NULL, 'refs' => [ 'IamRoleConfiguration$trustPolicy' => '<p>The proposed trust policy for the IAM role.</p>', ], ], 'InlineArchiveRule' => [ 'base' => '<p>An criterion statement in an archive rule. Each archive rule may have multiple criteria.</p>', 'refs' => [ 'InlineArchiveRulesList$member' => NULL, ], ], 'InlineArchiveRulesList' => [ 'base' => NULL, 'refs' => [ 'CreateAnalyzerRequest$archiveRules' => '<p>Specifies the archive rules to add for the analyzer. Archive rules automatically archive findings that meet the criteria you define for the rule.</p>', ], ], 'Integer' => [ 'base' => NULL, 'refs' => [ 'InternalServerException$retryAfterSeconds' => '<p>The seconds to wait to retry.</p>', 'ListAccessPreviewFindingsRequest$maxResults' => '<p>The maximum number of results to return in the response.</p>', 'ListAccessPreviewsRequest$maxResults' => '<p>The maximum number of results to return in the response.</p>', 'ListAnalyzedResourcesRequest$maxResults' => '<p>The maximum number of results to return in the response.</p>', 'ListAnalyzersRequest$maxResults' => '<p>The maximum number of results to return in the response.</p>', 'ListArchiveRulesRequest$maxResults' => '<p>The maximum number of results to return in the request.</p>', 'ListFindingsRequest$maxResults' => '<p>The maximum number of results to return in the response.</p>', 'PathElement$index' => '<p>Refers to an index in a JSON array.</p>', 'Position$column' => '<p>The column of the position, starting from 0.</p>', 'Position$line' => '<p>The line of the position, starting from 1.</p>', 'Position$offset' => '<p>The offset within the policy that corresponds to the position, starting from 0.</p>', 'Substring$length' => '<p>The length of the substring.</p>', 'Substring$start' => '<p>The start index of the substring, starting from 0.</p>', 'ThrottlingException$retryAfterSeconds' => '<p>The seconds to wait to retry.</p>', 'ValidatePolicyRequest$maxResults' => '<p>The maximum number of results to return in the response.</p>', ], ], 'InternalServerException' => [ 'base' => '<p>Internal server error.</p>', 'refs' => [], ], 'InternetConfiguration' => [ 'base' => '<p>This configuration sets the network origin for the Amazon S3 access point or multi-region access point to <code>Internet</code>.</p>', 'refs' => [ 'NetworkOriginConfiguration$internetConfiguration' => '<p>The configuration for the Amazon S3 access point or multi-region access point with an <code>Internet</code> origin.</p>', ], ], 'IssueCode' => [ 'base' => NULL, 'refs' => [ 'ValidatePolicyFinding$issueCode' => '<p>The issue code provides an identifier of the issue associated with this finding.</p>', ], ], 'IssuingAccount' => [ 'base' => NULL, 'refs' => [ 'KmsGrantConfiguration$issuingAccount' => '<p> The Amazon Web Services account under which the grant was issued. The account is used to propose KMS grants issued by accounts other than the owner of the key.</p>', ], ], 'JobDetails' => [ 'base' => '<p>Contains details about the policy generation request.</p>', 'refs' => [ 'GetGeneratedPolicyResponse$jobDetails' => '<p>A <code>GeneratedPolicyDetails</code> object that contains details about the generated policy.</p>', ], ], 'JobError' => [ 'base' => '<p>Contains the details about the policy generation error.</p>', 'refs' => [ 'JobDetails$jobError' => '<p>The job error for the policy generation request.</p>', ], ], 'JobErrorCode' => [ 'base' => NULL, 'refs' => [ 'JobError$code' => '<p>The job error code.</p>', ], ], 'JobId' => [ 'base' => NULL, 'refs' => [ 'CancelPolicyGenerationRequest$jobId' => '<p>The <code>JobId</code> that is returned by the <code>StartPolicyGeneration</code> operation. The <code>JobId</code> can be used with <code>GetGeneratedPolicy</code> to retrieve the generated policies or used with <code>CancelPolicyGeneration</code> to cancel the policy generation request.</p>', 'GetGeneratedPolicyRequest$jobId' => '<p>The <code>JobId</code> that is returned by the <code>StartPolicyGeneration</code> operation. The <code>JobId</code> can be used with <code>GetGeneratedPolicy</code> to retrieve the generated policies or used with <code>CancelPolicyGeneration</code> to cancel the policy generation request.</p>', 'JobDetails$jobId' => '<p>The <code>JobId</code> that is returned by the <code>StartPolicyGeneration</code> operation. The <code>JobId</code> can be used with <code>GetGeneratedPolicy</code> to retrieve the generated policies or used with <code>CancelPolicyGeneration</code> to cancel the policy generation request.</p>', 'PolicyGeneration$jobId' => '<p>The <code>JobId</code> that is returned by the <code>StartPolicyGeneration</code> operation. The <code>JobId</code> can be used with <code>GetGeneratedPolicy</code> to retrieve the generated policies or used with <code>CancelPolicyGeneration</code> to cancel the policy generation request.</p>', 'StartPolicyGenerationResponse$jobId' => '<p>The <code>JobId</code> that is returned by the <code>StartPolicyGeneration</code> operation. The <code>JobId</code> can be used with <code>GetGeneratedPolicy</code> to retrieve the generated policies or used with <code>CancelPolicyGeneration</code> to cancel the policy generation request.</p>', ], ], 'JobStatus' => [ 'base' => NULL, 'refs' => [ 'JobDetails$status' => '<p>The status of the job request.</p>', 'PolicyGeneration$status' => '<p>The status of the policy generation request.</p>', ], ], 'KmsConstraintsKey' => [ 'base' => NULL, 'refs' => [ 'KmsConstraintsMap$key' => NULL, ], ], 'KmsConstraintsMap' => [ 'base' => NULL, 'refs' => [ 'KmsGrantConstraints$encryptionContextEquals' => '<p>A list of key-value pairs that must match the encryption context in the <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#cryptographic-operations">cryptographic operation</a> request. The grant allows the operation only when the encryption context in the request is the same as the encryption context specified in this constraint.</p>', 'KmsGrantConstraints$encryptionContextSubset' => '<p>A list of key-value pairs that must be included in the encryption context of the <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#cryptographic-operations">cryptographic operation</a> request. The grant allows the cryptographic operation only when the encryption context in the request includes the key-value pairs specified in this constraint, although it can include additional key-value pairs.</p>', ], ], 'KmsConstraintsValue' => [ 'base' => NULL, 'refs' => [ 'KmsConstraintsMap$value' => NULL, ], ], 'KmsGrantConfiguration' => [ 'base' => '<p>A proposed grant configuration for a KMS key. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/APIReference/API_CreateGrant.html">CreateGrant</a>.</p>', 'refs' => [ 'KmsGrantConfigurationsList$member' => NULL, ], ], 'KmsGrantConfigurationsList' => [ 'base' => NULL, 'refs' => [ 'KmsKeyConfiguration$grants' => '<p>A list of proposed grant configurations for the KMS key. If the proposed grant configuration is for an existing key, the access preview uses the proposed list of grant configurations in place of the existing grants. Otherwise, the access preview uses the existing grants for the key.</p>', ], ], 'KmsGrantConstraints' => [ 'base' => '<p>Use this structure to propose allowing <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#cryptographic-operations">cryptographic operations</a> in the grant only when the operation request includes the specified <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#encrypt_context">encryption context</a>. You can specify only one type of encryption context. An empty map is treated as not specified. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/APIReference/API_GrantConstraints.html">GrantConstraints</a>.</p>', 'refs' => [ 'KmsGrantConfiguration$constraints' => '<p>Use this structure to propose allowing <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#cryptographic-operations">cryptographic operations</a> in the grant only when the operation request includes the specified <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#encrypt_context">encryption context</a>.</p>', ], ], 'KmsGrantOperation' => [ 'base' => NULL, 'refs' => [ 'KmsGrantOperationsList$member' => NULL, ], ], 'KmsGrantOperationsList' => [ 'base' => NULL, 'refs' => [ 'KmsGrantConfiguration$operations' => '<p>A list of operations that the grant permits.</p>', ], ], 'KmsKeyConfiguration' => [ 'base' => '<p>Proposed access control configuration for a KMS key. You can propose a configuration for a new KMS key or an existing KMS key that you own by specifying the key policy and KMS grant configuration. If the configuration is for an existing key and you do not specify the key policy, the access preview uses the existing policy for the key. If the access preview is for a new resource and you do not specify the key policy, then the access preview uses the default key policy. The proposed key policy cannot be an empty string. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html#key-policy-default">Default key policy</a>. For more information about key policy limits, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/resource-limits.html">Resource quotas</a>.</p> <p/>', 'refs' => [ 'Configuration$kmsKey' => '<p>The access control configuration is for a KMS key. </p>', ], ], 'KmsKeyPoliciesMap' => [ 'base' => NULL, 'refs' => [ 'KmsKeyConfiguration$keyPolicies' => '<p>Resource policy configuration for the KMS key. The only valid value for the name of the key policy is <code>default</code>. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html#key-policy-default">Default key policy</a>.</p>', ], ], 'KmsKeyPolicy' => [ 'base' => NULL, 'refs' => [ 'KmsKeyPoliciesMap$value' => NULL, ], ], 'LearnMoreLink' => [ 'base' => NULL, 'refs' => [ 'ValidatePolicyFinding$learnMoreLink' => '<p>A link to additional documentation about the type of finding.</p>', ], ], 'ListAccessPreviewFindingsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListAccessPreviewFindingsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListAccessPreviewsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListAccessPreviewsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListAnalyzedResourcesRequest' => [ 'base' => '<p>Retrieves a list of resources that have been analyzed.</p>', 'refs' => [], ], 'ListAnalyzedResourcesResponse' => [ 'base' => '<p>The response to the request.</p>', 'refs' => [], ], 'ListAnalyzersRequest' => [ 'base' => '<p>Retrieves a list of analyzers.</p>', 'refs' => [], ], 'ListAnalyzersResponse' => [ 'base' => '<p>The response to the request.</p>', 'refs' => [], ], 'ListArchiveRulesRequest' => [ 'base' => '<p>Retrieves a list of archive rules created for the specified analyzer.</p>', 'refs' => [], ], 'ListArchiveRulesResponse' => [ 'base' => '<p>The response to the request.</p>', 'refs' => [], ], 'ListFindingsRequest' => [ 'base' => '<p>Retrieves a list of findings generated by the specified analyzer.</p>', 'refs' => [], ], 'ListFindingsResponse' => [ 'base' => '<p>The response to the request.</p>', 'refs' => [], ], 'ListPolicyGenerationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListPolicyGenerationsRequestMaxResultsInteger' => [ 'base' => NULL, 'refs' => [ 'ListPolicyGenerationsRequest$maxResults' => '<p>The maximum number of results to return in the response.</p>', ], ], 'ListPolicyGenerationsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceRequest' => [ 'base' => '<p>Retrieves a list of tags applied to the specified resource.</p>', 'refs' => [], ], 'ListTagsForResourceResponse' => [ 'base' => '<p>The response to the request.</p>', 'refs' => [], ], 'Locale' => [ 'base' => NULL, 'refs' => [ 'ValidatePolicyRequest$locale' => '<p>The locale to use for localizing the findings.</p>', ], ], 'Location' => [ 'base' => '<p>A location in a policy that is represented as a path through the JSON representation and a corresponding span.</p>', 'refs' => [ 'LocationList$member' => NULL, ], ], 'LocationList' => [ 'base' => NULL, 'refs' => [ 'ValidatePolicyFinding$locations' => '<p>The list of locations in the policy document that are related to the finding. The issue code provides a summary of an issue identified by the finding.</p>', ], ], 'Name' => [ 'base' => NULL, 'refs' => [ 'AnalyzerSummary$name' => '<p>The name of the analyzer.</p>', 'ApplyArchiveRuleRequest$ruleName' => '<p>The name of the rule to apply.</p>', 'ArchiveRuleSummary$ruleName' => '<p>The name of the archive rule.</p>', 'CreateAnalyzerRequest$analyzerName' => '<p>The name of the analyzer to create.</p>', 'CreateArchiveRuleRequest$analyzerName' => '<p>The name of the created analyzer.</p>', 'CreateArchiveRuleRequest$ruleName' => '<p>The name of the rule to create.</p>', 'DeleteAnalyzerRequest$analyzerName' => '<p>The name of the analyzer to delete.</p>', 'DeleteArchiveRuleRequest$analyzerName' => '<p>The name of the analyzer that associated with the archive rule to delete.</p>', 'DeleteArchiveRuleRequest$ruleName' => '<p>The name of the rule to delete.</p>', 'GetAnalyzerRequest$analyzerName' => '<p>The name of the analyzer retrieved.</p>', 'GetArchiveRuleRequest$analyzerName' => '<p>The name of the analyzer to retrieve rules from.</p>', 'GetArchiveRuleRequest$ruleName' => '<p>The name of the rule to retrieve.</p>', 'InlineArchiveRule$ruleName' => '<p>The name of the rule.</p>', 'ListArchiveRulesRequest$analyzerName' => '<p>The name of the analyzer to retrieve rules from.</p>', 'UpdateArchiveRuleRequest$analyzerName' => '<p>The name of the analyzer to update the archive rules for.</p>', 'UpdateArchiveRuleRequest$ruleName' => '<p>The name of the rule to update.</p>', ], ], 'NetworkOriginConfiguration' => [ 'base' => '<p>The proposed <code>InternetConfiguration</code> or <code>VpcConfiguration</code> to apply to the Amazon S3 access point. <code>VpcConfiguration</code> does not apply to multi-region access points. You can make the access point accessible from the internet, or you can specify that all requests made through that access point must originate from a specific virtual private cloud (VPC). You can specify only one type of network configuration. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/creating-access-points.html">Creating access points</a>.</p>', 'refs' => [ 'S3AccessPointConfiguration$networkOrigin' => '<p>The proposed <code>Internet</code> and <code>VpcConfiguration</code> to apply to this Amazon S3 access point. <code>VpcConfiguration</code> does not apply to multi-region access points. If the access preview is for a new resource and neither is specified, the access preview uses <code>Internet</code> for the network origin. If the access preview is for an existing resource and neither is specified, the access preview uses the exiting network origin.</p>', ], ], 'OrderBy' => [ 'base' => NULL, 'refs' => [ 'SortCriteria$orderBy' => '<p>The sort order, ascending or descending.</p>', ], ], 'PathElement' => [ 'base' => '<p>A single element in a path through the JSON representation of a policy.</p>', 'refs' => [ 'PathElementList$member' => NULL, ], ], 'PathElementList' => [ 'base' => NULL, 'refs' => [ 'Location$path' => '<p>A path in a policy, represented as a sequence of path elements.</p>', ], ], 'PolicyDocument' => [ 'base' => NULL, 'refs' => [ 'ValidatePolicyRequest$policyDocument' => '<p>The JSON policy document to use as the content for the policy.</p>', ], ], 'PolicyGeneration' => [ 'base' => '<p>Contains details about the policy generation status and properties.</p>', 'refs' => [ 'PolicyGenerationList$member' => NULL, ], ], 'PolicyGenerationDetails' => [ 'base' => '<p>Contains the ARN details about the IAM entity for which the policy is generated.</p>', 'refs' => [ 'StartPolicyGenerationRequest$policyGenerationDetails' => '<p>Contains the ARN of the IAM entity (user or role) for which you are generating a policy.</p>', ], ], 'PolicyGenerationList' => [ 'base' => NULL, 'refs' => [ 'ListPolicyGenerationsResponse$policyGenerations' => '<p>A <code>PolicyGeneration</code> object that contains details about the generated policy.</p>', ], ], 'PolicyName' => [ 'base' => NULL, 'refs' => [ 'KmsKeyPoliciesMap$key' => NULL, ], ], 'PolicyType' => [ 'base' => NULL, 'refs' => [ 'ValidatePolicyRequest$policyType' => '<p>The type of policy to validate. Identity policies grant permissions to IAM principals. Identity policies include managed and inline policies for IAM roles, users, and groups. They also include service-control policies (SCPs) that are attached to an Amazon Web Services organization, organizational unit (OU), or an account.</p> <p>Resource policies grant permissions on Amazon Web Services resources. Resource policies include trust policies for IAM roles and bucket policies for Amazon S3 buckets. You can provide a generic input such as identity policy or resource policy or a specific input such as managed policy or Amazon S3 bucket policy. </p>', ], ], 'Position' => [ 'base' => '<p>A position in a policy.</p>', 'refs' => [ 'Span$end' => '<p>The end position of the span (exclusive).</p>', 'Span$start' => '<p>The start position of the span (inclusive).</p>', ], ], 'PrincipalArn' => [ 'base' => NULL, 'refs' => [ 'GeneratedPolicyProperties$principalArn' => '<p>The ARN of the IAM entity (user or role) for which you are generating a policy.</p>', 'ListPolicyGenerationsRequest$principalArn' => '<p>The ARN of the IAM entity (user or role) for which you are generating a policy. Use this with <code>ListGeneratedPolicies</code> to filter the results to only include results for a specific principal.</p>', 'PolicyGeneration$principalArn' => '<p>The ARN of the IAM entity (user or role) for which you are generating a policy.</p>', 'PolicyGenerationDetails$principalArn' => '<p>The ARN of the IAM entity (user or role) for which you are generating a policy.</p>', ], ], 'PrincipalMap' => [ 'base' => NULL, 'refs' => [ 'AccessPreviewFinding$principal' => '<p>The external principal that has access to a resource within the zone of trust.</p>', 'Finding$principal' => '<p>The external principal that access to a resource within the zone of trust.</p>', 'FindingSummary$principal' => '<p>The external principal that has access to a resource within the zone of trust.</p>', ], ], 'ReasonCode' => [ 'base' => NULL, 'refs' => [ 'StatusReason$code' => '<p>The reason code for the current status of the analyzer.</p>', ], ], 'RegionList' => [ 'base' => NULL, 'refs' => [ 'Trail$regions' => '<p>A list of regions to get CloudTrail data from and analyze to generate a policy.</p>', 'TrailProperties$regions' => '<p>A list of regions to get CloudTrail data from and analyze to generate a policy.</p>', ], ], 'ResourceArn' => [ 'base' => NULL, 'refs' => [ 'AnalyzedResource$resourceArn' => '<p>The ARN of the resource that was analyzed.</p>', 'AnalyzedResourceSummary$resourceArn' => '<p>The ARN of the analyzed resource.</p>', 'GetAnalyzedResourceRequest$resourceArn' => '<p>The ARN of the resource to retrieve information about.</p>', 'StartResourceScanRequest$resourceArn' => '<p>The ARN of the resource to scan.</p>', 'UpdateFindingsRequest$resourceArn' => '<p>The ARN of the resource identified in the finding.</p>', ], ], 'ResourceNotFoundException' => [ 'base' => '<p>The specified resource could not be found.</p>', 'refs' => [], ], 'ResourceType' => [ 'base' => NULL, 'refs' => [ 'AccessPreviewFinding$resourceType' => '<p>The type of the resource that can be accessed in the finding.</p>', 'AnalyzedResource$resourceType' => '<p>The type of the resource that was analyzed.</p>', 'AnalyzedResourceSummary$resourceType' => '<p>The type of resource that was analyzed.</p>', 'Finding$resourceType' => '<p>The type of the resource identified in the finding.</p>', 'FindingSummary$resourceType' => '<p>The type of the resource that the external principal has access to.</p>', 'ListAnalyzedResourcesRequest$resourceType' => '<p>The type of resource.</p>', ], ], 'RetiringPrincipal' => [ 'base' => NULL, 'refs' => [ 'KmsGrantConfiguration$retiringPrincipal' => '<p>The principal that is given permission to retire the grant by using <a href="https://docs.aws.amazon.com/kms/latest/APIReference/API_RetireGrant.html">RetireGrant</a> operation.</p>', ], ], 'RoleArn' => [ 'base' => NULL, 'refs' => [ 'CloudTrailDetails$accessRole' => '<p>The ARN of the service role that IAM Access Analyzer uses to access your CloudTrail trail and service last accessed information.</p>', ], ], 'S3AccessPointConfiguration' => [ 'base' => '<p>The configuration for an Amazon S3 access point or multi-region access point for the bucket. You can propose up to 10 access points or multi-region access points per bucket. If the proposed Amazon S3 access point configuration is for an existing bucket, the access preview uses the proposed access point configuration in place of the existing access points. To propose an access point without a policy, you can provide an empty string as the access point policy. For more information, see <a href="https://docs.aws.amazon.com/https:/docs.aws.amazon.com/AmazonS3/latest/dev/creating-access-points.html">Creating access points</a>. For more information about access point policy limits, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/access-points-restrictions-limitations.html">Access points restrictions and limitations</a>.</p>', 'refs' => [ 'S3AccessPointConfigurationsMap$value' => NULL, ], ], 'S3AccessPointConfigurationsMap' => [ 'base' => NULL, 'refs' => [ 'S3BucketConfiguration$accessPoints' => '<p>The configuration of Amazon S3 access points or multi-region access points for the bucket. You can propose up to 10 new access points per bucket.</p>', ], ], 'S3BucketAclGrantConfiguration' => [ 'base' => '<p>A proposed access control list grant configuration for an Amazon S3 bucket. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#setting-acls">How to Specify an ACL</a>.</p>', 'refs' => [ 'S3BucketAclGrantConfigurationsList$member' => NULL, ], ], 'S3BucketAclGrantConfigurationsList' => [ 'base' => NULL, 'refs' => [ 'S3BucketConfiguration$bucketAclGrants' => '<p>The proposed list of ACL grants for the Amazon S3 bucket. You can propose up to 100 ACL grants per bucket. If the proposed grant configuration is for an existing bucket, the access preview uses the proposed list of grant configurations in place of the existing grants. Otherwise, the access preview uses the existing grants for the bucket.</p>', ], ], 'S3BucketConfiguration' => [ 'base' => '<p>Proposed access control configuration for an Amazon S3 bucket. You can propose a configuration for a new Amazon S3 bucket or an existing Amazon S3 bucket that you own by specifying the Amazon S3 bucket policy, bucket ACLs, bucket BPA settings, Amazon S3 access points, and multi-region access points attached to the bucket. If the configuration is for an existing Amazon S3 bucket and you do not specify the Amazon S3 bucket policy, the access preview uses the existing policy attached to the bucket. If the access preview is for a new resource and you do not specify the Amazon S3 bucket policy, the access preview assumes a bucket without a policy. To propose deletion of an existing bucket policy, you can specify an empty string. For more information about bucket policy limits, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/example-bucket-policies.html">Bucket Policy Examples</a>.</p>', 'refs' => [ 'Configuration$s3Bucket' => '<p>The access control configuration is for an Amazon S3 Bucket. </p>', ], ], 'S3BucketPolicy' => [ 'base' => NULL, 'refs' => [ 'S3BucketConfiguration$bucketPolicy' => '<p>The proposed bucket policy for the Amazon S3 bucket.</p>', ], ], 'S3PublicAccessBlockConfiguration' => [ 'base' => '<p>The <code>PublicAccessBlock</code> configuration to apply to this Amazon S3 bucket. If the proposed configuration is for an existing Amazon S3 bucket and the configuration is not specified, the access preview uses the existing setting. If the proposed configuration is for a new bucket and the configuration is not specified, the access preview uses <code>false</code>. If the proposed configuration is for a new access point or multi-region access point and the access point BPA configuration is not specified, the access preview uses <code>true</code>. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-publicaccessblockconfiguration.html">PublicAccessBlockConfiguration</a>. </p>', 'refs' => [ 'S3AccessPointConfiguration$publicAccessBlock' => '<p>The proposed <code>S3PublicAccessBlock</code> configuration to apply to this Amazon S3 access point or multi-region access point.</p>', 'S3BucketConfiguration$bucketPublicAccessBlock' => '<p>The proposed block public access configuration for the Amazon S3 bucket.</p>', ], ], 'SecretsManagerSecretConfiguration' => [ 'base' => '<p>The configuration for a Secrets Manager secret. For more information, see <a href="https://docs.aws.amazon.com/secretsmanager/latest/apireference/API_CreateSecret.html">CreateSecret</a>.</p> <p>You can propose a configuration for a new secret or an existing secret that you own by specifying the secret policy and optional KMS encryption key. If the configuration is for an existing secret and you do not specify the secret policy, the access preview uses the existing policy for the secret. If the access preview is for a new resource and you do not specify the policy, the access preview assumes a secret without a policy. To propose deletion of an existing policy, you can specify an empty string. If the proposed configuration is for a new secret and you do not specify the KMS key ID, the access preview uses the default CMK of the Amazon Web Services account. If you specify an empty string for the KMS key ID, the access preview uses the default CMK of the Amazon Web Services account. For more information about secret policy limits, see <a href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/reference_limits.html">Quotas for Secrets Manager.</a>.</p>', 'refs' => [ 'Configuration$secretsManagerSecret' => '<p>The access control configuration is for a Secrets Manager secret.</p>', ], ], 'SecretsManagerSecretKmsId' => [ 'base' => NULL, 'refs' => [ 'SecretsManagerSecretConfiguration$kmsKeyId' => '<p>The proposed ARN, key ID, or alias of the KMS customer master key (CMK).</p>', ], ], 'SecretsManagerSecretPolicy' => [ 'base' => NULL, 'refs' => [ 'SecretsManagerSecretConfiguration$secretPolicy' => '<p>The proposed resource policy defining who can access or manage the secret.</p>', ], ], 'ServiceQuotaExceededException' => [ 'base' => '<p>Service quote met error.</p>', 'refs' => [], ], 'SharedViaList' => [ 'base' => NULL, 'refs' => [ 'AnalyzedResource$sharedVia' => '<p>Indicates how the access that generated the finding is granted. This is populated for Amazon S3 bucket findings.</p>', ], ], 'SortCriteria' => [ 'base' => '<p>The criteria used to sort.</p>', 'refs' => [ 'ListFindingsRequest$sort' => '<p>The sort order for the findings returned.</p>', ], ], 'Span' => [ 'base' => '<p>A span in a policy. The span consists of a start position (inclusive) and end position (exclusive).</p>', 'refs' => [ 'Location$span' => '<p>A span in a policy.</p>', ], ], 'SqsQueueConfiguration' => [ 'base' => '<p>The proposed access control configuration for an Amazon SQS queue. You can propose a configuration for a new Amazon SQS queue or an existing Amazon SQS queue that you own by specifying the Amazon SQS policy. If the configuration is for an existing Amazon SQS queue and you do not specify the Amazon SQS policy, the access preview uses the existing Amazon SQS policy for the queue. If the access preview is for a new resource and you do not specify the policy, the access preview assumes an Amazon SQS queue without a policy. To propose deletion of an existing Amazon SQS queue policy, you can specify an empty string for the Amazon SQS policy. For more information about Amazon SQS policy limits, see <a href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/quotas-policies.html">Quotas related to policies</a>.</p>', 'refs' => [ 'Configuration$sqsQueue' => '<p>The access control configuration is for an Amazon SQS queue. </p>', ], ], 'SqsQueuePolicy' => [ 'base' => NULL, 'refs' => [ 'SqsQueueConfiguration$queuePolicy' => '<p> The proposed resource policy for the Amazon SQS queue. </p>', ], ], 'StartPolicyGenerationRequest' => [ 'base' => NULL, 'refs' => [], ], 'StartPolicyGenerationResponse' => [ 'base' => NULL, 'refs' => [], ], 'StartResourceScanRequest' => [ 'base' => '<p>Starts a scan of the policies applied to the specified resource.</p>', 'refs' => [], ], 'StatusReason' => [ 'base' => '<p>Provides more details about the current status of the analyzer. For example, if the creation for the analyzer fails, a <code>Failed</code> status is returned. For an analyzer with organization as the type, this failure can be due to an issue with creating the service-linked roles required in the member accounts of the Amazon Web Services organization.</p>', 'refs' => [ 'AnalyzerSummary$statusReason' => '<p>The <code>statusReason</code> provides more details about the current status of the analyzer. For example, if the creation for the analyzer fails, a <code>Failed</code> status is returned. For an analyzer with organization as the type, this failure can be due to an issue with creating the service-linked roles required in the member accounts of the Amazon Web Services organization.</p>', ], ], 'String' => [ 'base' => NULL, 'refs' => [ 'AccessDeniedException$message' => NULL, 'AccessPreviewFinding$error' => '<p>An error.</p>', 'AccessPreviewFinding$resource' => '<p>The resource that an external principal has access to. This is the resource associated with the access preview.</p>', 'AccessPreviewFinding$resourceOwnerAccount' => '<p>The Amazon Web Services account ID that owns the resource. For most Amazon Web Services resources, the owning account is the account in which the resource was created.</p>', 'ActionList$member' => NULL, 'AnalyzedResource$error' => '<p>An error message.</p>', 'AnalyzedResource$resourceOwnerAccount' => '<p>The Amazon Web Services account ID that owns the resource.</p>', 'AnalyzedResourceSummary$resourceOwnerAccount' => '<p>The Amazon Web Services account ID that owns the resource.</p>', 'AnalyzerSummary$lastResourceAnalyzed' => '<p>The resource that was most recently analyzed by the analyzer.</p>', 'ApplyArchiveRuleRequest$clientToken' => '<p>A client token.</p>', 'ConditionKeyMap$key' => NULL, 'ConditionKeyMap$value' => NULL, 'ConflictException$message' => NULL, 'ConflictException$resourceId' => '<p>The ID of the resource.</p>', 'ConflictException$resourceType' => '<p>The resource type.</p>', 'CreateAccessPreviewRequest$clientToken' => '<p>A client token.</p>', 'CreateAnalyzerRequest$clientToken' => '<p>A client token.</p>', 'CreateArchiveRuleRequest$clientToken' => '<p>A client token.</p>', 'DeleteAnalyzerRequest$clientToken' => '<p>A client token.</p>', 'DeleteArchiveRuleRequest$clientToken' => '<p>A client token.</p>', 'FilterCriteriaMap$key' => NULL, 'Finding$error' => '<p>An error.</p>', 'Finding$resource' => '<p>The resource that an external principal has access to.</p>', 'Finding$resourceOwnerAccount' => '<p>The Amazon Web Services account ID that owns the resource.</p>', 'FindingSourceDetail$accessPointArn' => '<p>The ARN of the access point that generated the finding. The ARN format depends on whether the ARN represents an access point or a multi-region access point.</p>', 'FindingSummary$error' => '<p>The error that resulted in an Error finding.</p>', 'FindingSummary$resource' => '<p>The resource that the external principal has access to.</p>', 'FindingSummary$resourceOwnerAccount' => '<p>The Amazon Web Services account ID that owns the resource.</p>', 'GeneratedPolicy$policy' => '<p>The text to use as the content for the new policy. The policy is created using the <a href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_CreatePolicy.html">CreatePolicy</a> action.</p>', 'InternalServerException$message' => NULL, 'JobError$message' => '<p>Specific information about the error. For example, which service quota was exceeded or which resource was not found.</p>', 'ListTagsForResourceRequest$resourceArn' => '<p>The ARN of the resource to retrieve tags from.</p>', 'PathElement$key' => '<p>Refers to a key in a JSON object.</p>', 'PathElement$value' => '<p>Refers to the value associated with a given key in a JSON object.</p>', 'PrincipalMap$key' => NULL, 'PrincipalMap$value' => NULL, 'RegionList$member' => NULL, 'ResourceNotFoundException$message' => NULL, 'ResourceNotFoundException$resourceId' => '<p>The ID of the resource.</p>', 'ResourceNotFoundException$resourceType' => '<p>The type of the resource.</p>', 'ServiceQuotaExceededException$message' => NULL, 'ServiceQuotaExceededException$resourceId' => '<p>The resource ID.</p>', 'ServiceQuotaExceededException$resourceType' => '<p>The resource type.</p>', 'SharedViaList$member' => NULL, 'SortCriteria$attributeName' => '<p>The name of the attribute to sort on.</p>', 'StartPolicyGenerationRequest$clientToken' => '<p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Idempotency ensures that an API request completes only once. With an idempotent request, if the original request completes successfully, the subsequent retries with the same client token return the result from the original successful request and they have no additional effect.</p> <p>If you do not specify a client token, one is automatically generated by the Amazon Web Services SDK.</p>', 'TagKeys$member' => NULL, 'TagResourceRequest$resourceArn' => '<p>The ARN of the resource to add the tag to.</p>', 'TagsMap$key' => NULL, 'TagsMap$value' => NULL, 'ThrottlingException$message' => NULL, 'UntagResourceRequest$resourceArn' => '<p>The ARN of the resource to remove the tag from.</p>', 'UpdateArchiveRuleRequest$clientToken' => '<p>A client token.</p>', 'UpdateFindingsRequest$clientToken' => '<p>A client token.</p>', 'ValidatePolicyFinding$findingDetails' => '<p>A localized message that explains the finding and provides guidance on how to address it.</p>', 'ValidationException$message' => NULL, 'ValidationExceptionField$message' => '<p>A message about the validation exception.</p>', 'ValidationExceptionField$name' => '<p>The name of the validation exception.</p>', 'ValueList$member' => NULL, ], ], 'Substring' => [ 'base' => '<p>A reference to a substring of a literal string in a JSON document.</p>', 'refs' => [ 'PathElement$substring' => '<p>Refers to a substring of a literal string in a JSON object.</p>', ], ], 'TagKeys' => [ 'base' => NULL, 'refs' => [ 'UntagResourceRequest$tagKeys' => '<p>The key for the tag to add.</p>', ], ], 'TagResourceRequest' => [ 'base' => '<p>Adds a tag to the specified resource.</p>', 'refs' => [], ], 'TagResourceResponse' => [ 'base' => '<p>The response to the request.</p>', 'refs' => [], ], 'TagsMap' => [ 'base' => NULL, 'refs' => [ 'AnalyzerSummary$tags' => '<p>The tags added to the analyzer.</p>', 'CreateAnalyzerRequest$tags' => '<p>The tags to apply to the analyzer.</p>', 'ListTagsForResourceResponse$tags' => '<p>The tags that are applied to the specified resource.</p>', 'TagResourceRequest$tags' => '<p>The tags to add to the resource.</p>', ], ], 'ThrottlingException' => [ 'base' => '<p>Throttling limit exceeded error.</p>', 'refs' => [], ], 'Timestamp' => [ 'base' => NULL, 'refs' => [ 'AccessPreview$createdAt' => '<p>The time at which the access preview was created.</p>', 'AccessPreviewFinding$createdAt' => '<p>The time at which the access preview finding was created.</p>', 'AccessPreviewSummary$createdAt' => '<p>The time at which the access preview was created.</p>', 'AnalyzedResource$analyzedAt' => '<p>The time at which the resource was analyzed.</p>', 'AnalyzedResource$createdAt' => '<p>The time at which the finding was created.</p>', 'AnalyzedResource$updatedAt' => '<p>The time at which the finding was updated.</p>', 'AnalyzerSummary$createdAt' => '<p>A timestamp for the time at which the analyzer was created.</p>', 'AnalyzerSummary$lastResourceAnalyzedAt' => '<p>The time at which the most recently analyzed resource was analyzed.</p>', 'ArchiveRuleSummary$createdAt' => '<p>The time at which the archive rule was created.</p>', 'ArchiveRuleSummary$updatedAt' => '<p>The time at which the archive rule was last updated.</p>', 'CloudTrailDetails$endTime' => '<p>The end of the time range for which IAM Access Analyzer reviews your CloudTrail events. Events with a timestamp after this time are not considered to generate a policy. If this is not included in the request, the default value is the current time.</p>', 'CloudTrailDetails$startTime' => '<p>The start of the time range for which IAM Access Analyzer reviews your CloudTrail events. Events with a timestamp before this time are not considered to generate a policy.</p>', 'CloudTrailProperties$endTime' => '<p>The end of the time range for which IAM Access Analyzer reviews your CloudTrail events. Events with a timestamp after this time are not considered to generate a policy. If this is not included in the request, the default value is the current time.</p>', 'CloudTrailProperties$startTime' => '<p>The start of the time range for which IAM Access Analyzer reviews your CloudTrail events. Events with a timestamp before this time are not considered to generate a policy.</p>', 'Finding$analyzedAt' => '<p>The time at which the resource was analyzed.</p>', 'Finding$createdAt' => '<p>The time at which the finding was generated.</p>', 'Finding$updatedAt' => '<p>The time at which the finding was updated.</p>', 'FindingSummary$analyzedAt' => '<p>The time at which the resource-based policy that generated the finding was analyzed.</p>', 'FindingSummary$createdAt' => '<p>The time at which the finding was created.</p>', 'FindingSummary$updatedAt' => '<p>The time at which the finding was most recently updated.</p>', 'JobDetails$completedOn' => '<p>A timestamp of when the job was completed.</p>', 'JobDetails$startedOn' => '<p>A timestamp of when the job was started.</p>', 'PolicyGeneration$completedOn' => '<p>A timestamp of when the policy generation was completed.</p>', 'PolicyGeneration$startedOn' => '<p>A timestamp of when the policy generation started.</p>', ], ], 'Token' => [ 'base' => NULL, 'refs' => [ 'ListAccessPreviewFindingsRequest$nextToken' => '<p>A token used for pagination of results returned.</p>', 'ListAccessPreviewFindingsResponse$nextToken' => '<p>A token used for pagination of results returned.</p>', 'ListAccessPreviewsRequest$nextToken' => '<p>A token used for pagination of results returned.</p>', 'ListAccessPreviewsResponse$nextToken' => '<p>A token used for pagination of results returned.</p>', 'ListAnalyzedResourcesRequest$nextToken' => '<p>A token used for pagination of results returned.</p>', 'ListAnalyzedResourcesResponse$nextToken' => '<p>A token used for pagination of results returned.</p>', 'ListAnalyzersRequest$nextToken' => '<p>A token used for pagination of results returned.</p>', 'ListAnalyzersResponse$nextToken' => '<p>A token used for pagination of results returned.</p>', 'ListArchiveRulesRequest$nextToken' => '<p>A token used for pagination of results returned.</p>', 'ListArchiveRulesResponse$nextToken' => '<p>A token used for pagination of results returned.</p>', 'ListFindingsRequest$nextToken' => '<p>A token used for pagination of results returned.</p>', 'ListFindingsResponse$nextToken' => '<p>A token used for pagination of results returned.</p>', 'ListPolicyGenerationsRequest$nextToken' => '<p>A token used for pagination of results returned.</p>', 'ListPolicyGenerationsResponse$nextToken' => '<p>A token used for pagination of results returned.</p>', 'ValidatePolicyRequest$nextToken' => '<p>A token used for pagination of results returned.</p>', 'ValidatePolicyResponse$nextToken' => '<p>A token used for pagination of results returned.</p>', ], ], 'Trail' => [ 'base' => '<p>Contains details about the CloudTrail trail being analyzed to generate a policy.</p>', 'refs' => [ 'TrailList$member' => NULL, ], ], 'TrailList' => [ 'base' => NULL, 'refs' => [ 'CloudTrailDetails$trails' => '<p>A <code>Trail</code> object that contains settings for a trail.</p>', ], ], 'TrailProperties' => [ 'base' => '<p>Contains details about the CloudTrail trail being analyzed to generate a policy.</p>', 'refs' => [ 'TrailPropertiesList$member' => NULL, ], ], 'TrailPropertiesList' => [ 'base' => NULL, 'refs' => [ 'CloudTrailProperties$trailProperties' => '<p>A <code>TrailProperties</code> object that contains settings for trail properties.</p>', ], ], 'Type' => [ 'base' => NULL, 'refs' => [ 'AnalyzerSummary$type' => '<p>The type of analyzer, which corresponds to the zone of trust chosen for the analyzer.</p>', 'CreateAnalyzerRequest$type' => '<p>The type of analyzer to create. Only ACCOUNT and ORGANIZATION analyzers are supported. You can create only one analyzer per account per Region. You can create up to 5 analyzers per organization per Region.</p>', 'ListAnalyzersRequest$type' => '<p>The type of analyzer.</p>', ], ], 'UntagResourceRequest' => [ 'base' => '<p>Removes a tag from the specified resource.</p>', 'refs' => [], ], 'UntagResourceResponse' => [ 'base' => '<p>The response to the request.</p>', 'refs' => [], ], 'UpdateArchiveRuleRequest' => [ 'base' => '<p>Updates the specified archive rule.</p>', 'refs' => [], ], 'UpdateFindingsRequest' => [ 'base' => '<p>Updates findings with the new values provided in the request.</p>', 'refs' => [], ], 'ValidatePolicyFinding' => [ 'base' => '<p>A finding in a policy. Each finding is an actionable recommendation that can be used to improve the policy.</p>', 'refs' => [ 'ValidatePolicyFindingList$member' => NULL, ], ], 'ValidatePolicyFindingList' => [ 'base' => NULL, 'refs' => [ 'ValidatePolicyResponse$findings' => '<p>The list of findings in a policy returned by IAM Access Analyzer based on its suite of policy checks.</p>', ], ], 'ValidatePolicyFindingType' => [ 'base' => NULL, 'refs' => [ 'ValidatePolicyFinding$findingType' => '<p>The impact of the finding.</p> <p>Security warnings report when the policy allows access that we consider overly permissive.</p> <p>Errors report when a part of the policy is not functional.</p> <p>Warnings report non-security issues when a policy does not conform to policy writing best practices.</p> <p>Suggestions recommend stylistic improvements in the policy that do not impact access.</p>', ], ], 'ValidatePolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'ValidatePolicyResponse' => [ 'base' => NULL, 'refs' => [], ], 'ValidationException' => [ 'base' => '<p>Validation exception error.</p>', 'refs' => [], ], 'ValidationExceptionField' => [ 'base' => '<p>Contains information about a validation exception.</p>', 'refs' => [ 'ValidationExceptionFieldList$member' => NULL, ], ], 'ValidationExceptionFieldList' => [ 'base' => NULL, 'refs' => [ 'ValidationException$fieldList' => '<p>A list of fields that didn\'t validate.</p>', ], ], 'ValidationExceptionReason' => [ 'base' => NULL, 'refs' => [ 'ValidationException$reason' => '<p>The reason for the exception.</p>', ], ], 'ValueList' => [ 'base' => NULL, 'refs' => [ 'Criterion$contains' => '<p>A "contains" operator to match for the filter used to create the rule.</p>', 'Criterion$eq' => '<p>An "equals" operator to match for the filter used to create the rule.</p>', 'Criterion$neq' => '<p>A "not equals" operator to match for the filter used to create the rule.</p>', ], ], 'VpcConfiguration' => [ 'base' => '<p>The proposed virtual private cloud (VPC) configuration for the Amazon S3 access point. VPC configuration does not apply to multi-region access points. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_VpcConfiguration.html">VpcConfiguration</a>. </p>', 'refs' => [ 'NetworkOriginConfiguration$vpcConfiguration' => NULL, ], ], 'VpcId' => [ 'base' => NULL, 'refs' => [ 'VpcConfiguration$vpcId' => '<p> If this field is specified, this access point will only allow connections from the specified VPC ID. </p>', ], ], ],];
