<?php
// This file was auto-generated from sdk-root/src/data/ivs/2020-07-14/docs-2.json
return [ 'version' => '2.0', 'service' => '<p> <b>Introduction</b> </p> <p>The Amazon Interactive Video Service (IVS) API is REST compatible, using a standard HTTP API and an Amazon Web Services EventBridge event stream for responses. JSON is used for both requests and responses, including errors.</p> <p>The API is an Amazon Web Services regional service. For a list of supported regions and Amazon IVS HTTPS service endpoints, see the <a href="https://docs.aws.amazon.com/general/latest/gr/ivs.html">Amazon IVS page</a> in the <i>Amazon Web Services General Reference</i>.</p> <p> <i> <b>All API request parameters and URLs are case sensitive. </b> </i> </p> <p>For a summary of notable documentation changes in each release, see <a href="https://docs.aws.amazon.com/ivs/latest/userguide/doc-history.html"> Document History</a>.</p> <p> <b>Allowed Header Values</b> </p> <ul> <li> <p> <code> <b>Accept:</b> </code> application/json</p> </li> <li> <p> <code> <b>Accept-Encoding:</b> </code> gzip, deflate</p> </li> <li> <p> <code> <b>Content-Type:</b> </code>application/json</p> </li> </ul> <p> <b>Resources</b> </p> <p>The following resources contain information about your IVS live stream (see <a href="https://docs.aws.amazon.com/ivs/latest/userguide/getting-started.html"> Getting Started with Amazon IVS</a>):</p> <ul> <li> <p>Channel — Stores configuration data related to your live stream. You first create a channel and then use the channel’s stream key to start your live stream. See the Channel endpoints for more information. </p> </li> <li> <p>Stream key — An identifier assigned by Amazon IVS when you create a channel, which is then used to authorize streaming. See the StreamKey endpoints for more information. <i> <b>Treat the stream key like a secret, since it allows anyone to stream to the channel.</b> </i> </p> </li> <li> <p>Playback key pair — Video playback may be restricted using playback-authorization tokens, which use public-key encryption. A playback key pair is the public-private pair of keys used to sign and validate the playback-authorization token. See the PlaybackKeyPair endpoints for more information.</p> </li> <li> <p>Recording configuration — Stores configuration related to recording a live stream and where to store the recorded content. Multiple channels can reference the same recording configuration. See the Recording Configuration endpoints for more information.</p> </li> </ul> <p> <b>Tagging</b> </p> <p>A <i>tag</i> is a metadata label that you assign to an Amazon Web Services resource. A tag comprises a <i>key</i> and a <i>value</i>, both set by you. For example, you might set a tag as <code>topic:nature</code> to label a particular video category. See <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services Resources</a> for more information, including restrictions that apply to tags.</p> <p>Tags can help you identify and organize your Amazon Web Services resources. For example, you can use the same tag for different resources to indicate that they are related. You can also use tags to manage access (see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_tags.html"> Access Tags</a>). </p> <p>The Amazon IVS API has these tag-related endpoints: <a>TagResource</a>, <a>UntagResource</a>, and <a>ListTagsForResource</a>. The following resources support tagging: Channels, Stream Keys, Playback Key Pairs, and Recording Configurations.</p> <p>At most 50 tags can be applied to a resource. </p> <p> <b>Authentication versus Authorization</b> </p> <p>Note the differences between these concepts:</p> <ul> <li> <p> <i>Authentication</i> is about verifying identity. You need to be authenticated to sign Amazon IVS API requests.</p> </li> <li> <p> <i>Authorization</i> is about granting permissions. You need to be authorized to view <a href="https://docs.aws.amazon.com/ivs/latest/userguide/private-channels.html">Amazon IVS private channels</a>. (Private channels are channels that are enabled for "playback authorization.")</p> </li> </ul> <p> <b>Authentication</b> </p> <p>All Amazon IVS API requests must be authenticated with a signature. The Amazon Web Services Command-Line Interface (CLI) and Amazon IVS Player SDKs take care of signing the underlying API calls for you. However, if your application calls the Amazon IVS API directly, it’s your responsibility to sign the requests.</p> <p>You generate a signature using valid Amazon Web Services credentials that have permission to perform the requested action. For example, you must sign PutMetadata requests with a signature generated from an IAM user account that has the <code>ivs:PutMetadata</code> permission.</p> <p>For more information:</p> <ul> <li> <p>Authentication and generating signatures — See <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/sig-v4-authenticating-requests.html">Authenticating Requests (Amazon Web Services Signature Version 4)</a> in the <i>Amazon Web Services General Reference</i>.</p> </li> <li> <p>Managing Amazon IVS permissions — See <a href="https://docs.aws.amazon.com/ivs/latest/userguide/security-iam.html">Identity and Access Management</a> on the Security page of the <i>Amazon IVS User Guide</i>.</p> </li> </ul> <p> <b>Channel Endpoints</b> </p> <ul> <li> <p> <a>CreateChannel</a> — Creates a new channel and an associated stream key to start streaming.</p> </li> <li> <p> <a>GetChannel</a> — Gets the channel configuration for the specified channel ARN (Amazon Resource Name).</p> </li> <li> <p> <a>BatchGetChannel</a> — Performs <a>GetChannel</a> on multiple ARNs simultaneously.</p> </li> <li> <p> <a>ListChannels</a> — Gets summary information about all channels in your account, in the Amazon Web Services region where the API request is processed. This list can be filtered to match a specified name or recording-configuration ARN. Filters are mutually exclusive and cannot be used together. If you try to use both filters, you will get an error (409 Conflict Exception).</p> </li> <li> <p> <a>UpdateChannel</a> — Updates a channel\'s configuration. This does not affect an ongoing stream of this channel. You must stop and restart the stream for the changes to take effect.</p> </li> <li> <p> <a>DeleteChannel</a> — Deletes the specified channel.</p> </li> </ul> <p> <b>StreamKey Endpoints</b> </p> <ul> <li> <p> <a>CreateStreamKey</a> — Creates a stream key, used to initiate a stream, for the specified channel ARN.</p> </li> <li> <p> <a>GetStreamKey</a> — Gets stream key information for the specified ARN.</p> </li> <li> <p> <a>BatchGetStreamKey</a> — Performs <a>GetStreamKey</a> on multiple ARNs simultaneously.</p> </li> <li> <p> <a>ListStreamKeys</a> — Gets summary information about stream keys for the specified channel.</p> </li> <li> <p> <a>DeleteStreamKey</a> — Deletes the stream key for the specified ARN, so it can no longer be used to stream.</p> </li> </ul> <p> <b>Stream Endpoints</b> </p> <ul> <li> <p> <a>GetStream</a> — Gets information about the active (live) stream on a specified channel.</p> </li> <li> <p> <a>GetStreamSession</a> — Gets metadata on a specified stream.</p> </li> <li> <p> <a>ListStreams</a> — Gets summary information about live streams in your account, in the Amazon Web Services region where the API request is processed.</p> </li> <li> <p> <a>ListStreamSessions</a> — Gets a summary of current and previous streams for a specified channel in your account, in the AWS region where the API request is processed.</p> </li> <li> <p> <a>StopStream</a> — Disconnects the incoming RTMPS stream for the specified channel. Can be used in conjunction with <a>DeleteStreamKey</a> to prevent further streaming to a channel.</p> </li> <li> <p> <a>PutMetadata</a> — Inserts metadata into the active stream of the specified channel. At most 5 requests per second per channel are allowed, each with a maximum 1 KB payload. (If 5 TPS is not sufficient for your needs, we recommend batching your data into a single PutMetadata call.) At most 155 requests per second per account are allowed.</p> </li> </ul> <p> <b>PlaybackKeyPair Endpoints</b> </p> <p>For more information, see <a href="https://docs.aws.amazon.com/ivs/latest/userguide/private-channels.html">Setting Up Private Channels</a> in the <i>Amazon IVS User Guide</i>.</p> <ul> <li> <p> <a>ImportPlaybackKeyPair</a> — Imports the public portion of a new key pair and returns its <code>arn</code> and <code>fingerprint</code>. The <code>privateKey</code> can then be used to generate viewer authorization tokens, to grant viewers access to private channels (channels enabled for playback authorization).</p> </li> <li> <p> <a>GetPlaybackKeyPair</a> — Gets a specified playback authorization key pair and returns the <code>arn</code> and <code>fingerprint</code>. The <code>privateKey</code> held by the caller can be used to generate viewer authorization tokens, to grant viewers access to private channels.</p> </li> <li> <p> <a>ListPlaybackKeyPairs</a> — Gets summary information about playback key pairs.</p> </li> <li> <p> <a>DeletePlaybackKeyPair</a> — Deletes a specified authorization key pair. This invalidates future viewer tokens generated using the key pair’s <code>privateKey</code>.</p> </li> </ul> <p> <b>RecordingConfiguration Endpoints</b> </p> <ul> <li> <p> <a>CreateRecordingConfiguration</a> — Creates a new recording configuration, used to enable recording to Amazon S3.</p> </li> <li> <p> <a>GetRecordingConfiguration</a> — Gets the recording-configuration metadata for the specified ARN.</p> </li> <li> <p> <a>ListRecordingConfigurations</a> — Gets summary information about all recording configurations in your account, in the Amazon Web Services region where the API request is processed.</p> </li> <li> <p> <a>DeleteRecordingConfiguration</a> — Deletes the recording configuration for the specified ARN.</p> </li> </ul> <p> <b>Amazon Web Services Tags Endpoints</b> </p> <ul> <li> <p> <a>TagResource</a> — Adds or updates tags for the Amazon Web Services resource with the specified ARN.</p> </li> <li> <p> <a>UntagResource</a> — Removes tags from the resource with the specified ARN.</p> </li> <li> <p> <a>ListTagsForResource</a> — Gets information about Amazon Web Services tags for the specified ARN.</p> </li> </ul>', 'operations' => [ 'BatchGetChannel' => '<p>Performs <a>GetChannel</a> on multiple ARNs simultaneously.</p>', 'BatchGetStreamKey' => '<p>Performs <a>GetStreamKey</a> on multiple ARNs simultaneously.</p>', 'CreateChannel' => '<p>Creates a new channel and an associated stream key to start streaming.</p>', 'CreateRecordingConfiguration' => '<p>Creates a new recording configuration, used to enable recording to Amazon S3.</p> <p> <b>Known issue:</b> In the us-east-1 region, if you use the Amazon Web Services CLI to create a recording configuration, it returns success even if the S3 bucket is in a different region. In this case, the <code>state</code> of the recording configuration is <code>CREATE_FAILED</code> (instead of <code>ACTIVE</code>). (In other regions, the CLI correctly returns failure if the bucket is in a different region.)</p> <p> <b>Workaround:</b> Ensure that your S3 bucket is in the same region as the recording configuration. If you create a recording configuration in a different region as your S3 bucket, delete that recording configuration and create a new one with an S3 bucket from the correct region.</p>', 'CreateStreamKey' => '<p>Creates a stream key, used to initiate a stream, for the specified channel ARN.</p> <p>Note that <a>CreateChannel</a> creates a stream key. If you subsequently use CreateStreamKey on the same channel, it will fail because a stream key already exists and there is a limit of 1 stream key per channel. To reset the stream key on a channel, use <a>DeleteStreamKey</a> and then CreateStreamKey.</p>', 'DeleteChannel' => '<p>Deletes the specified channel and its associated stream keys.</p> <p>If you try to delete a live channel, you will get an error (409 ConflictException). To delete a channel that is live, call <a>StopStream</a>, wait for the Amazon EventBridge "Stream End" event (to verify that the stream\'s state was changed from Live to Offline), then call DeleteChannel. (See <a href="https://docs.aws.amazon.com/ivs/latest/userguide/eventbridge.html"> Using EventBridge with Amazon IVS</a>.) </p>', 'DeletePlaybackKeyPair' => '<p>Deletes a specified authorization key pair. This invalidates future viewer tokens generated using the key pair’s <code>privateKey</code>. For more information, see <a href="https://docs.aws.amazon.com/ivs/latest/userguide/private-channels.html">Setting Up Private Channels</a> in the <i>Amazon IVS User Guide</i>.</p>', 'DeleteRecordingConfiguration' => '<p>Deletes the recording configuration for the specified ARN.</p> <p>If you try to delete a recording configuration that is associated with a channel, you will get an error (409 ConflictException). To avoid this, for all channels that reference the recording configuration, first use <a>UpdateChannel</a> to set the <code>recordingConfigurationArn</code> field to an empty string, then use DeleteRecordingConfiguration.</p>', 'DeleteStreamKey' => '<p>Deletes the stream key for the specified ARN, so it can no longer be used to stream.</p>', 'GetChannel' => '<p>Gets the channel configuration for the specified channel ARN. See also <a>BatchGetChannel</a>.</p>', 'GetPlaybackKeyPair' => '<p>Gets a specified playback authorization key pair and returns the <code>arn</code> and <code>fingerprint</code>. The <code>privateKey</code> held by the caller can be used to generate viewer authorization tokens, to grant viewers access to private channels. For more information, see <a href="https://docs.aws.amazon.com/ivs/latest/userguide/private-channels.html">Setting Up Private Channels</a> in the <i>Amazon IVS User Guide</i>.</p>', 'GetRecordingConfiguration' => '<p>Gets the recording configuration for the specified ARN.</p>', 'GetStream' => '<p>Gets information about the active (live) stream on a specified channel.</p>', 'GetStreamKey' => '<p>Gets stream-key information for a specified ARN.</p>', 'GetStreamSession' => '<p>Gets metadata on a specified stream.</p>', 'ImportPlaybackKeyPair' => '<p>Imports the public portion of a new key pair and returns its <code>arn</code> and <code>fingerprint</code>. The <code>privateKey</code> can then be used to generate viewer authorization tokens, to grant viewers access to private channels. For more information, see <a href="https://docs.aws.amazon.com/ivs/latest/userguide/private-channels.html">Setting Up Private Channels</a> in the <i>Amazon IVS User Guide</i>.</p>', 'ListChannels' => '<p>Gets summary information about all channels in your account, in the Amazon Web Services region where the API request is processed. This list can be filtered to match a specified name or recording-configuration ARN. Filters are mutually exclusive and cannot be used together. If you try to use both filters, you will get an error (409 ConflictException).</p>', 'ListPlaybackKeyPairs' => '<p>Gets summary information about playback key pairs. For more information, see <a href="https://docs.aws.amazon.com/ivs/latest/userguide/private-channels.html">Setting Up Private Channels</a> in the <i>Amazon IVS User Guide</i>.</p>', 'ListRecordingConfigurations' => '<p>Gets summary information about all recording configurations in your account, in the Amazon Web Services region where the API request is processed.</p>', 'ListStreamKeys' => '<p>Gets summary information about stream keys for the specified channel.</p>', 'ListStreamSessions' => '<p>Gets a summary of current and previous streams for a specified channel in your account, in the AWS region where the API request is processed.</p>', 'ListStreams' => '<p>Gets summary information about live streams in your account, in the Amazon Web Services region where the API request is processed.</p>', 'ListTagsForResource' => '<p>Gets information about Amazon Web Services tags for the specified ARN.</p>', 'PutMetadata' => '<p>Inserts metadata into the active stream of the specified channel. At most 5 requests per second per channel are allowed, each with a maximum 1 KB payload. (If 5 TPS is not sufficient for your needs, we recommend batching your data into a single PutMetadata call.) At most 155 requests per second per account are allowed. Also see <a href="https://docs.aws.amazon.com/ivs/latest/userguide/metadata.html">Embedding Metadata within a Video Stream</a> in the <i>Amazon IVS User Guide</i>.</p>', 'StopStream' => '<p>Disconnects the incoming RTMPS stream for the specified channel. Can be used in conjunction with <a>DeleteStreamKey</a> to prevent further streaming to a channel.</p> <note> <p>Many streaming client-software libraries automatically reconnect a dropped RTMPS session, so to stop the stream permanently, you may want to first revoke the <code>streamKey</code> attached to the channel.</p> </note>', 'TagResource' => '<p>Adds or updates tags for the Amazon Web Services resource with the specified ARN.</p>', 'UntagResource' => '<p>Removes tags from the resource with the specified ARN.</p>', 'UpdateChannel' => '<p>Updates a channel\'s configuration. This does not affect an ongoing stream of this channel. You must stop and restart the stream for the changes to take effect.</p>', ], 'shapes' => [ 'AccessDeniedException' => [ 'base' => '<p/>', 'refs' => [], ], 'AudioConfiguration' => [ 'base' => '<p>Object specifying a stream’s audio configuration.</p>', 'refs' => [ 'IngestConfiguration$audio' => '<p>Encoder settings for audio.</p>', ], ], 'BatchError' => [ 'base' => '<p>Error related to a specific channel, specified by its ARN.</p>', 'refs' => [ 'BatchErrors$member' => NULL, ], ], 'BatchErrors' => [ 'base' => NULL, 'refs' => [ 'BatchGetChannelResponse$errors' => '<p>Each error object is related to a specific ARN in the request.</p>', 'BatchGetStreamKeyResponse$errors' => '<p/>', ], ], 'BatchGetChannelRequest' => [ 'base' => NULL, 'refs' => [], ], 'BatchGetChannelResponse' => [ 'base' => NULL, 'refs' => [], ], 'BatchGetStreamKeyRequest' => [ 'base' => NULL, 'refs' => [], ], 'BatchGetStreamKeyResponse' => [ 'base' => NULL, 'refs' => [], ], 'Boolean' => [ 'base' => NULL, 'refs' => [ 'CreateChannelRequest$authorized' => '<p>Whether the channel is private (enabled for playback authorization). Default: <code>false</code>.</p>', 'StreamSessionSummary$hasErrorEvent' => '<p>If <code>true</code>, this stream encountered a quota breach or failure.</p>', 'UpdateChannelRequest$authorized' => '<p>Whether the channel is private (enabled for playback authorization).</p>', ], ], 'Channel' => [ 'base' => '<p>Object specifying a channel.</p>', 'refs' => [ 'Channels$member' => NULL, 'CreateChannelResponse$channel' => '<p/>', 'GetChannelResponse$channel' => '<p/>', 'StreamSession$channel' => '<p>The properties of the channel at the time of going live.</p>', 'UpdateChannelResponse$channel' => NULL, ], ], 'ChannelArn' => [ 'base' => NULL, 'refs' => [ 'Channel$arn' => '<p>Channel ARN.</p>', 'ChannelArnList$member' => NULL, 'ChannelSummary$arn' => '<p>Channel ARN.</p>', 'CreateStreamKeyRequest$channelArn' => '<p>ARN of the channel for which to create the stream key.</p>', 'DeleteChannelRequest$arn' => '<p>ARN of the channel to be deleted.</p>', 'GetChannelRequest$arn' => '<p>ARN of the channel for which the configuration is to be retrieved.</p>', 'GetStreamRequest$channelArn' => '<p>Channel ARN for stream to be accessed.</p>', 'GetStreamSessionRequest$channelArn' => '<p>ARN of the channel resource</p>', 'ListStreamKeysRequest$channelArn' => '<p>Channel ARN used to filter the list.</p>', 'ListStreamSessionsRequest$channelArn' => '<p>Channel ARN used to filter the list.</p>', 'PutMetadataRequest$channelArn' => '<p>ARN of the channel into which metadata is inserted. This channel must have an active stream.</p>', 'StopStreamRequest$channelArn' => '<p>ARN of the channel for which the stream is to be stopped.</p>', 'Stream$channelArn' => '<p>Channel ARN for the stream.</p>', 'StreamKey$channelArn' => '<p>Channel ARN for the stream.</p>', 'StreamKeySummary$channelArn' => '<p>Channel ARN for the stream.</p>', 'StreamSummary$channelArn' => '<p>Channel ARN for the stream.</p>', 'UpdateChannelRequest$arn' => '<p>ARN of the channel to be updated.</p>', ], ], 'ChannelArnList' => [ 'base' => NULL, 'refs' => [ 'BatchGetChannelRequest$arns' => '<p>Array of ARNs, one per channel.</p>', ], ], 'ChannelLatencyMode' => [ 'base' => NULL, 'refs' => [ 'Channel$latencyMode' => '<p>Channel latency mode. Use <code>NORMAL</code> to broadcast and deliver live video up to Full HD. Use <code>LOW</code> for near-real-time interaction with viewers. Default: <code>LOW</code>. (Note: In the Amazon IVS console, <code>LOW</code> and <code>NORMAL</code> correspond to Ultra-low and Standard, respectively.)</p>', 'ChannelSummary$latencyMode' => '<p>Channel latency mode. Use <code>NORMAL</code> to broadcast and deliver live video up to Full HD. Use <code>LOW</code> for near-real-time interaction with viewers. Default: <code>LOW</code>. (Note: In the Amazon IVS console, <code>LOW</code> and <code>NORMAL</code> correspond to Ultra-low and Standard, respectively.)</p>', 'CreateChannelRequest$latencyMode' => '<p>Channel latency mode. Use <code>NORMAL</code> to broadcast and deliver live video up to Full HD. Use <code>LOW</code> for near-real-time interaction with viewers. (Note: In the Amazon IVS console, <code>LOW</code> and <code>NORMAL</code> correspond to Ultra-low and Standard, respectively.) Default: <code>LOW</code>.</p>', 'UpdateChannelRequest$latencyMode' => '<p>Channel latency mode. Use <code>NORMAL</code> to broadcast and deliver live video up to Full HD. Use <code>LOW</code> for near-real-time interaction with viewers. (Note: In the Amazon IVS console, <code>LOW</code> and <code>NORMAL</code> correspond to Ultra-low and Standard, respectively.)</p>', ], ], 'ChannelList' => [ 'base' => NULL, 'refs' => [ 'ListChannelsResponse$channels' => '<p>List of the matching channels.</p>', ], ], 'ChannelName' => [ 'base' => NULL, 'refs' => [ 'Channel$name' => '<p>Channel name.</p>', 'ChannelSummary$name' => '<p>Channel name.</p>', 'CreateChannelRequest$name' => '<p>Channel name.</p>', 'ListChannelsRequest$filterByName' => '<p>Filters the channel list to match the specified name.</p>', 'UpdateChannelRequest$name' => '<p>Channel name.</p>', ], ], 'ChannelNotBroadcasting' => [ 'base' => '<p/>', 'refs' => [], ], 'ChannelRecordingConfigurationArn' => [ 'base' => NULL, 'refs' => [ 'Channel$recordingConfigurationArn' => '<p>Recording-configuration ARN. A value other than an empty string indicates that recording is enabled. Default: "" (empty string, recording is disabled).</p>', 'ChannelSummary$recordingConfigurationArn' => '<p>Recording-configuration ARN. A value other than an empty string indicates that recording is enabled. Default: "" (empty string, recording is disabled).</p>', 'CreateChannelRequest$recordingConfigurationArn' => '<p>Recording-configuration ARN. Default: "" (empty string, recording is disabled).</p>', 'ListChannelsRequest$filterByRecordingConfigurationArn' => '<p>Filters the channel list to match the specified recording-configuration ARN.</p>', 'UpdateChannelRequest$recordingConfigurationArn' => '<p>Recording-configuration ARN. If this is set to an empty string, recording is disabled. A value other than an empty string indicates that recording is enabled</p>', ], ], 'ChannelSummary' => [ 'base' => '<p>Summary information about a channel.</p>', 'refs' => [ 'ChannelList$member' => NULL, ], ], 'ChannelType' => [ 'base' => NULL, 'refs' => [ 'Channel$type' => '<p>Channel type, which determines the allowable resolution and bitrate. <i>If you exceed the allowable resolution or bitrate, the stream probably will disconnect immediately.</i> Default: <code>STANDARD</code>. Valid values:</p> <ul> <li> <p> <code>STANDARD</code>: Multiple qualities are generated from the original input, to automatically give viewers the best experience for their devices and network conditions. Resolution can be up to 1080p and bitrate can be up to 8.5 Mbps. Audio is transcoded only for renditions 360p and below; above that, audio is passed through.</p> </li> <li> <p> <code>BASIC</code>: Amazon IVS delivers the original input to viewers. The viewer’s video-quality choice is limited to the original input. Resolution can be up to 480p and bitrate can be up to 1.5 Mbps.</p> </li> </ul>', 'CreateChannelRequest$type' => '<p>Channel type, which determines the allowable resolution and bitrate. <i>If you exceed the allowable resolution or bitrate, the stream probably will disconnect immediately.</i> Default: <code>STANDARD</code>. Valid values:</p> <ul> <li> <p> <code>STANDARD</code>: Multiple qualities are generated from the original input, to automatically give viewers the best experience for their devices and network conditions. Resolution can be up to 1080p and bitrate can be up to 8.5 Mbps. Audio is transcoded only for renditions 360p and below; above that, audio is passed through.</p> </li> <li> <p> <code>BASIC</code>: Amazon IVS delivers the original input to viewers. The viewer’s video-quality choice is limited to the original input. Resolution can be up to 480p and bitrate can be up to 1.5 Mbps.</p> </li> </ul>', 'UpdateChannelRequest$type' => '<p>Channel type, which determines the allowable resolution and bitrate. <i>If you exceed the allowable resolution or bitrate, the stream probably will disconnect immediately</i>. Valid values:</p> <ul> <li> <p> <code>STANDARD</code>: Multiple qualities are generated from the original input, to automatically give viewers the best experience for their devices and network conditions. Resolution can be up to 1080p and bitrate can be up to 8.5 Mbps. Audio is transcoded only for renditions 360p and below; above that, audio is passed through.</p> </li> <li> <p> <code>BASIC</code>: Amazon IVS delivers the original input to viewers. The viewer’s video-quality choice is limited to the original input. Resolution can be up to 480p and bitrate can be up to 1.5 Mbps.</p> </li> </ul>', ], ], 'Channels' => [ 'base' => NULL, 'refs' => [ 'BatchGetChannelResponse$channels' => '<p/>', ], ], 'ConflictException' => [ 'base' => '<p/>', 'refs' => [], ], 'CreateChannelRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateChannelResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateRecordingConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateRecordingConfigurationResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateStreamKeyRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateStreamKeyResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteChannelRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeletePlaybackKeyPairRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeletePlaybackKeyPairResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteRecordingConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteStreamKeyRequest' => [ 'base' => NULL, 'refs' => [], ], 'DestinationConfiguration' => [ 'base' => '<p>A complex type that describes a location where recorded videos will be stored. Each member represents a type of destination configuration. For recording, you define one and only one type of destination configuration.</p>', 'refs' => [ 'CreateRecordingConfigurationRequest$destinationConfiguration' => '<p>A complex type that contains a destination configuration for where recorded video will be stored.</p>', 'RecordingConfiguration$destinationConfiguration' => '<p>A complex type that contains information about where recorded video will be stored.</p>', 'RecordingConfigurationSummary$destinationConfiguration' => '<p>A complex type that contains information about where recorded video will be stored.</p>', ], ], 'GetChannelRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetChannelResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetPlaybackKeyPairRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetPlaybackKeyPairResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetRecordingConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetRecordingConfigurationResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetStreamKeyRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetStreamKeyResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetStreamRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetStreamResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetStreamSessionRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetStreamSessionResponse' => [ 'base' => NULL, 'refs' => [], ], 'ImportPlaybackKeyPairRequest' => [ 'base' => NULL, 'refs' => [], ], 'ImportPlaybackKeyPairResponse' => [ 'base' => NULL, 'refs' => [], ], 'IngestConfiguration' => [ 'base' => '<p>Object specifying the ingest configuration set up by the broadcaster, usually in an encoder.</p>', 'refs' => [ 'StreamSession$ingestConfiguration' => '<p>The properties of the incoming RTMP stream for the stream.</p>', ], ], 'IngestEndpoint' => [ 'base' => NULL, 'refs' => [ 'Channel$ingestEndpoint' => '<p>Channel ingest endpoint, part of the definition of an ingest server, used when you set up streaming software.</p>', ], ], 'Integer' => [ 'base' => NULL, 'refs' => [ 'AudioConfiguration$channels' => '<p>Number of audio channels.</p>', 'AudioConfiguration$sampleRate' => '<p>Number of audio samples recorded per second.</p>', 'AudioConfiguration$targetBitrate' => '<p>The expected ingest bitrate (bits per second). This is configured in the encoder.</p>', 'VideoConfiguration$targetBitrate' => '<p>The expected ingest bitrate (bits per second). This is configured in the encoder.</p>', 'VideoConfiguration$targetFramerate' => '<p>The expected ingest framerate. This is configured in the encoder.</p>', 'VideoConfiguration$videoHeight' => '<p>Video-resolution height in pixels.</p>', 'VideoConfiguration$videoWidth' => '<p>Video-resolution width in pixels.</p>', ], ], 'InternalServerException' => [ 'base' => '<p/>', 'refs' => [], ], 'IsAuthorized' => [ 'base' => NULL, 'refs' => [ 'Channel$authorized' => '<p>Whether the channel is private (enabled for playback authorization). Default: <code>false</code>.</p>', 'ChannelSummary$authorized' => '<p>Whether the channel is private (enabled for playback authorization). Default: <code>false</code>.</p>', ], ], 'ListChannelsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListChannelsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListPlaybackKeyPairsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListPlaybackKeyPairsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListRecordingConfigurationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListRecordingConfigurationsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListStreamKeysRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListStreamKeysResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListStreamSessionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListStreamSessionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListStreamsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListStreamsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'MaxChannelResults' => [ 'base' => NULL, 'refs' => [ 'ListChannelsRequest$maxResults' => '<p>Maximum number of channels to return. Default: 50.</p>', ], ], 'MaxPlaybackKeyPairResults' => [ 'base' => NULL, 'refs' => [ 'ListPlaybackKeyPairsRequest$maxResults' => '<p>The first key pair to retrieve. This is used for pagination; see the <code>nextToken</code> response field. Default: 50.</p>', ], ], 'MaxRecordingConfigurationResults' => [ 'base' => NULL, 'refs' => [ 'ListRecordingConfigurationsRequest$maxResults' => '<p>Maximum number of recording configurations to return. Default: 50. </p>', ], ], 'MaxStreamKeyResults' => [ 'base' => NULL, 'refs' => [ 'ListStreamKeysRequest$maxResults' => '<p>Maximum number of streamKeys to return. Default: 50.</p>', ], ], 'MaxStreamResults' => [ 'base' => NULL, 'refs' => [ 'ListStreamSessionsRequest$maxResults' => '<p>Maximum number of streams to return. Default: 50.</p>', 'ListStreamsRequest$maxResults' => '<p>Maximum number of streams to return. Default: 50.</p>', ], ], 'PaginationToken' => [ 'base' => NULL, 'refs' => [ 'ListChannelsRequest$nextToken' => '<p>The first channel to retrieve. This is used for pagination; see the <code>nextToken</code> response field.</p>', 'ListChannelsResponse$nextToken' => '<p>If there are more channels than <code>maxResults</code>, use <code>nextToken</code> in the request to get the next set.</p>', 'ListPlaybackKeyPairsRequest$nextToken' => '<p>Maximum number of key pairs to return.</p>', 'ListPlaybackKeyPairsResponse$nextToken' => '<p>If there are more key pairs than <code>maxResults</code>, use <code>nextToken</code> in the request to get the next set.</p>', 'ListRecordingConfigurationsRequest$nextToken' => '<p>The first recording configuration to retrieve. This is used for pagination; see the <code>nextToken</code> response field.</p>', 'ListRecordingConfigurationsResponse$nextToken' => '<p>If there are more recording configurations than <code>maxResults</code>, use <code>nextToken</code> in the request to get the next set.</p>', 'ListStreamKeysRequest$nextToken' => '<p>The first stream key to retrieve. This is used for pagination; see the <code>nextToken</code> response field.</p>', 'ListStreamKeysResponse$nextToken' => '<p>If there are more stream keys than <code>maxResults</code>, use <code>nextToken</code> in the request to get the next set.</p>', 'ListStreamSessionsRequest$nextToken' => '<p>The first stream to retrieve. This is used for pagination; see the <code>nextToken</code> response field.</p>', 'ListStreamSessionsResponse$nextToken' => '<p>If there are more streams than <code>maxResults</code>, use <code>nextToken</code> in the request to get the next set.</p>', 'ListStreamsRequest$nextToken' => '<p>The first stream to retrieve. This is used for pagination; see the <code>nextToken</code> response field.</p>', 'ListStreamsResponse$nextToken' => '<p>If there are more streams than <code>maxResults</code>, use <code>nextToken</code> in the request to get the next set.</p>', ], ], 'PendingVerification' => [ 'base' => '<p/>', 'refs' => [], ], 'PlaybackKeyPair' => [ 'base' => '<p>A key pair used to sign and validate a playback authorization token.</p>', 'refs' => [ 'GetPlaybackKeyPairResponse$keyPair' => '<zonbook></zonbook><xhtml></xhtml>', 'ImportPlaybackKeyPairResponse$keyPair' => '<p/>', ], ], 'PlaybackKeyPairArn' => [ 'base' => NULL, 'refs' => [ 'DeletePlaybackKeyPairRequest$arn' => '<p>ARN of the key pair to be deleted.</p>', 'GetPlaybackKeyPairRequest$arn' => '<p>ARN of the key pair to be returned.</p>', 'PlaybackKeyPair$arn' => '<p>Key-pair ARN.</p>', 'PlaybackKeyPairSummary$arn' => '<p>Key-pair ARN.</p>', ], ], 'PlaybackKeyPairFingerprint' => [ 'base' => NULL, 'refs' => [ 'PlaybackKeyPair$fingerprint' => '<p>Key-pair identifier.</p>', ], ], 'PlaybackKeyPairList' => [ 'base' => NULL, 'refs' => [ 'ListPlaybackKeyPairsResponse$keyPairs' => '<p>List of key pairs.</p>', ], ], 'PlaybackKeyPairName' => [ 'base' => NULL, 'refs' => [ 'ImportPlaybackKeyPairRequest$name' => '<p>Playback-key-pair name. The value does not need to be unique.</p>', 'PlaybackKeyPair$name' => '<p>Playback-key-pair name. The value does not need to be unique.</p>', 'PlaybackKeyPairSummary$name' => '<p>Playback-key-pair name. The value does not need to be unique.</p>', ], ], 'PlaybackKeyPairSummary' => [ 'base' => '<p>Summary information about a playback key pair.</p>', 'refs' => [ 'PlaybackKeyPairList$member' => NULL, ], ], 'PlaybackPublicKeyMaterial' => [ 'base' => NULL, 'refs' => [ 'ImportPlaybackKeyPairRequest$publicKeyMaterial' => '<p>The public portion of a customer-generated key pair.</p>', ], ], 'PlaybackURL' => [ 'base' => NULL, 'refs' => [ 'Channel$playbackUrl' => '<p>Channel playback URL.</p>', 'Stream$playbackUrl' => '<p>URL of the master playlist, required by the video player to play the HLS stream.</p>', ], ], 'PutMetadataRequest' => [ 'base' => NULL, 'refs' => [], ], 'RecordingConfiguration' => [ 'base' => '<p>An object representing a configuration to record a channel stream.</p>', 'refs' => [ 'CreateRecordingConfigurationResponse$recordingConfiguration' => '<zonbook></zonbook><xhtml></xhtml>', 'GetRecordingConfigurationResponse$recordingConfiguration' => '<zonbook></zonbook><xhtml></xhtml>', 'StreamSession$recordingConfiguration' => '<p>The properties of recording the live stream.</p>', ], ], 'RecordingConfigurationArn' => [ 'base' => NULL, 'refs' => [ 'DeleteRecordingConfigurationRequest$arn' => '<p>ARN of the recording configuration to be deleted.</p>', 'GetRecordingConfigurationRequest$arn' => '<p>ARN of the recording configuration to be retrieved.</p>', 'RecordingConfiguration$arn' => '<p>Recording-configuration ARN.</p>', 'RecordingConfigurationSummary$arn' => '<p>Recording-configuration ARN.</p>', ], ], 'RecordingConfigurationList' => [ 'base' => NULL, 'refs' => [ 'ListRecordingConfigurationsResponse$recordingConfigurations' => '<p>List of the matching recording configurations.</p>', ], ], 'RecordingConfigurationName' => [ 'base' => NULL, 'refs' => [ 'CreateRecordingConfigurationRequest$name' => '<p>Recording-configuration name. The value does not need to be unique.</p>', 'RecordingConfiguration$name' => '<p>Recording-configuration name. The value does not need to be unique.</p>', 'RecordingConfigurationSummary$name' => '<p>Recording-configuration name. The value does not need to be unique.</p>', ], ], 'RecordingConfigurationState' => [ 'base' => NULL, 'refs' => [ 'RecordingConfiguration$state' => '<p>Indicates the current state of the recording configuration. When the state is <code>ACTIVE</code>, the configuration is ready for recording a channel stream.</p>', 'RecordingConfigurationSummary$state' => '<p>Indicates the current state of the recording configuration. When the state is <code>ACTIVE</code>, the configuration is ready for recording a channel stream.</p>', ], ], 'RecordingConfigurationSummary' => [ 'base' => '<p>Summary information about a RecordingConfiguration.</p>', 'refs' => [ 'RecordingConfigurationList$member' => NULL, ], ], 'ResourceArn' => [ 'base' => NULL, 'refs' => [ 'BatchError$arn' => '<p>Channel ARN.</p>', 'ListTagsForResourceRequest$resourceArn' => '<p>The ARN of the resource to be retrieved.</p>', 'TagResourceRequest$resourceArn' => '<p>ARN of the resource for which tags are to be added or updated.</p>', 'UntagResourceRequest$resourceArn' => '<p>ARN of the resource for which tags are to be removed.</p>', ], ], 'ResourceNotFoundException' => [ 'base' => '<p/>', 'refs' => [], ], 'S3DestinationBucketName' => [ 'base' => NULL, 'refs' => [ 'S3DestinationConfiguration$bucketName' => '<p>Location (S3 bucket name) where recorded videos will be stored.</p>', ], ], 'S3DestinationConfiguration' => [ 'base' => '<p>A complex type that describes an S3 location where recorded videos will be stored.</p>', 'refs' => [ 'DestinationConfiguration$s3' => '<p>An S3 destination configuration where recorded videos will be stored.</p>', ], ], 'ServiceQuotaExceededException' => [ 'base' => '<p/>', 'refs' => [], ], 'StopStreamRequest' => [ 'base' => NULL, 'refs' => [], ], 'StopStreamResponse' => [ 'base' => NULL, 'refs' => [], ], 'Stream' => [ 'base' => '<p>Specifies a live video stream that has been ingested and distributed.</p>', 'refs' => [ 'GetStreamResponse$stream' => '<p/>', ], ], 'StreamEvent' => [ 'base' => '<p>Object specifying a stream’s events. For a list of events, see <a href="https://docs.aws.amazon.com/ivs/latest/userguide/eventbridge.html">Using Amazon EventBridge with Amazon IVS</a>.</p>', 'refs' => [ 'StreamEvents$member' => NULL, ], ], 'StreamEvents' => [ 'base' => NULL, 'refs' => [ 'StreamSession$truncatedEvents' => '<p>List of Amazon IVS events that the stream encountered. The list is sorted by most recent events and contains up to 500 events. For Amazon IVS events, see <a href="https://docs.aws.amazon.com/ivs/latest/userguide/eventbridge.html">Using Amazon EventBridge with Amazon IVS</a>.</p>', ], ], 'StreamFilters' => [ 'base' => '<p>Object specifying the stream attribute on which to filter.</p>', 'refs' => [ 'ListStreamsRequest$filterBy' => '<p>Filters the stream list to match the specified criterion.</p>', ], ], 'StreamHealth' => [ 'base' => NULL, 'refs' => [ 'Stream$health' => '<p>The stream’s health.</p>', 'StreamFilters$health' => '<p>The stream’s health.</p>', 'StreamSummary$health' => '<p>The stream’s health.</p>', ], ], 'StreamId' => [ 'base' => NULL, 'refs' => [ 'GetStreamSessionRequest$streamId' => '<p>Unique identifier for a live or previously live stream in the specified channel. If no <code>streamId</code> is provided, this returns the most recent stream session for the channel, if it exists.</p>', 'Stream$streamId' => '<p>Unique identifier for a live or previously live stream in the specified channel.</p>', 'StreamSession$streamId' => '<p>Unique identifier for a live or previously live stream in the specified channel.</p>', 'StreamSessionSummary$streamId' => '<p>Unique identifier for a live or previously live stream in the specified channel.</p>', 'StreamSummary$streamId' => '<p>Unique identifier for a live or previously live stream in the specified channel.</p>', ], ], 'StreamKey' => [ 'base' => '<p>Object specifying a stream key.</p>', 'refs' => [ 'CreateChannelResponse$streamKey' => '<p/>', 'CreateStreamKeyResponse$streamKey' => '<p>Stream key used to authenticate an RTMPS stream for ingestion.</p>', 'GetStreamKeyResponse$streamKey' => '<zonbook></zonbook><xhtml></xhtml>', 'StreamKeys$member' => NULL, ], ], 'StreamKeyArn' => [ 'base' => NULL, 'refs' => [ 'DeleteStreamKeyRequest$arn' => '<p>ARN of the stream key to be deleted.</p>', 'GetStreamKeyRequest$arn' => '<p>ARN for the stream key to be retrieved.</p>', 'StreamKey$arn' => '<p>Stream-key ARN.</p>', 'StreamKeyArnList$member' => NULL, 'StreamKeySummary$arn' => '<p>Stream-key ARN.</p>', ], ], 'StreamKeyArnList' => [ 'base' => NULL, 'refs' => [ 'BatchGetStreamKeyRequest$arns' => '<p>Array of ARNs, one per channel.</p>', ], ], 'StreamKeyList' => [ 'base' => NULL, 'refs' => [ 'ListStreamKeysResponse$streamKeys' => '<p>List of stream keys.</p>', ], ], 'StreamKeySummary' => [ 'base' => '<p>Summary information about a stream key.</p>', 'refs' => [ 'StreamKeyList$member' => NULL, ], ], 'StreamKeyValue' => [ 'base' => NULL, 'refs' => [ 'StreamKey$value' => '<p>Stream-key value.</p>', ], ], 'StreamKeys' => [ 'base' => NULL, 'refs' => [ 'BatchGetStreamKeyResponse$streamKeys' => '<p/>', ], ], 'StreamList' => [ 'base' => NULL, 'refs' => [ 'ListStreamsResponse$streams' => '<p>List of streams.</p>', ], ], 'StreamMetadata' => [ 'base' => NULL, 'refs' => [ 'PutMetadataRequest$metadata' => '<p>Metadata to insert into the stream. Maximum: 1 KB per request.</p>', ], ], 'StreamSession' => [ 'base' => '<p>Object that captures the Amazon IVS configuration that the customer provisioned, the ingest configurations that the broadcaster used, and the most recent Amazon IVS stream events it encountered.</p>', 'refs' => [ 'GetStreamSessionResponse$streamSession' => '<p>List of stream details.</p>', ], ], 'StreamSessionList' => [ 'base' => NULL, 'refs' => [ 'ListStreamSessionsResponse$streamSessions' => '<p/>', ], ], 'StreamSessionSummary' => [ 'base' => '<p>Summary information about a stream session.</p>', 'refs' => [ 'StreamSessionList$member' => NULL, ], ], 'StreamStartTime' => [ 'base' => NULL, 'refs' => [ 'Stream$startTime' => '<p>Time of the stream’s start. This is an ISO 8601 timestamp returned as a string.</p>', 'StreamSummary$startTime' => '<p>Time of the stream’s start. This is an ISO 8601 timestamp returned as a string.</p>', ], ], 'StreamState' => [ 'base' => NULL, 'refs' => [ 'Stream$state' => '<p>The stream’s state.</p>', 'StreamSummary$state' => '<p>The stream’s state.</p>', ], ], 'StreamSummary' => [ 'base' => '<p>Summary information about a stream.</p>', 'refs' => [ 'StreamList$member' => NULL, ], ], 'StreamUnavailable' => [ 'base' => '<p/>', 'refs' => [], ], 'StreamViewerCount' => [ 'base' => NULL, 'refs' => [ 'Stream$viewerCount' => '<p>A count of concurrent views of the stream. Typically, a new view appears in <code>viewerCount</code> within 15 seconds of when video playback starts and a view is removed from <code>viewerCount</code> within 1 minute of when video playback ends. A value of -1 indicates that the request timed out; in this case, retry.</p>', 'StreamSummary$viewerCount' => '<p>A count of concurrent views of the stream. Typically, a new view appears in <code>viewerCount</code> within 15 seconds of when video playback starts and a view is removed from <code>viewerCount</code> within 1 minute of when video playback ends. A value of -1 indicates that the request timed out; in this case, retry.</p>', ], ], 'String' => [ 'base' => NULL, 'refs' => [ 'AudioConfiguration$codec' => '<p>Codec used for the audio encoding.</p>', 'StreamEvent$name' => '<p>Name that identifies the stream event within a <code>type</code>.</p>', 'StreamEvent$type' => '<p>Logical group for certain events.</p>', 'VideoConfiguration$avcLevel' => '<p>Indicates the degree of required decoder performance for a profile. Normally this is set automatically by the encoder. For details, see the H.264 specification.</p>', 'VideoConfiguration$avcProfile' => '<p>Indicates to the decoder the requirements for decoding the stream. For definitions of the valid values, see the H.264 specification.</p>', 'VideoConfiguration$codec' => '<p>Codec used for the video encoding.</p>', 'VideoConfiguration$encoder' => '<p>Software or hardware used to encode the video.</p>', ], ], 'TagKey' => [ 'base' => NULL, 'refs' => [ 'TagKeyList$member' => NULL, 'Tags$key' => NULL, ], ], 'TagKeyList' => [ 'base' => NULL, 'refs' => [ 'UntagResourceRequest$tagKeys' => '<p>Array of tags to be removed.</p>', ], ], 'TagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'TagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'TagValue' => [ 'base' => NULL, 'refs' => [ 'Tags$value' => NULL, ], ], 'Tags' => [ 'base' => NULL, 'refs' => [ 'Channel$tags' => '<p>Array of 1-50 maps, each of the form <code>string:string (key:value)</code>.</p>', 'ChannelSummary$tags' => '<p>Array of 1-50 maps, each of the form <code>string:string (key:value)</code>.</p>', 'CreateChannelRequest$tags' => '<p>Array of 1-50 maps, each of the form <code>string:string (key:value)</code>.</p>', 'CreateRecordingConfigurationRequest$tags' => '<p>Array of 1-50 maps, each of the form <code>string:string (key:value)</code>.</p>', 'CreateStreamKeyRequest$tags' => '<p>Array of 1-50 maps, each of the form <code>string:string (key:value)</code>.</p>', 'ImportPlaybackKeyPairRequest$tags' => '<p>Any tags provided with the request are added to the playback key pair tags.</p>', 'ListTagsForResourceResponse$tags' => '<p/>', 'PlaybackKeyPair$tags' => '<p>Array of 1-50 maps, each of the form <code>string:string (key:value)</code>.</p>', 'PlaybackKeyPairSummary$tags' => '<p>Array of 1-50 maps, each of the form <code>string:string (key:value)</code>.</p>', 'RecordingConfiguration$tags' => '<p>Array of 1-50 maps, each of the form <code>string:string (key:value)</code>.</p>', 'RecordingConfigurationSummary$tags' => '<p>Array of 1-50 maps, each of the form <code>string:string (key:value)</code>.</p>', 'StreamKey$tags' => '<p>Array of 1-50 maps, each of the form <code>string:string (key:value)</code>.</p>', 'StreamKeySummary$tags' => '<p>Array of 1-50 maps, each of the form <code>string:string (key:value)</code>.</p>', 'TagResourceRequest$tags' => '<p>Array of tags to be added or updated.</p>', ], ], 'ThrottlingException' => [ 'base' => '<p/>', 'refs' => [], ], 'Time' => [ 'base' => NULL, 'refs' => [ 'StreamEvent$eventTime' => '<p>UTC ISO-8601 formatted timestamp of when the event occurred.</p>', 'StreamSession$endTime' => '<p>UTC ISO-8601 formatted timestamp of when the channel went offline. For live streams, this is <code>NULL</code>.</p>', 'StreamSession$startTime' => '<p>UTC ISO-8601 formatted timestamp of when the channel went live.</p>', 'StreamSessionSummary$endTime' => '<p>UTC ISO-8601 formatted timestamp of when the channel went offline. For live streams, this is <code>NULL</code>.</p>', 'StreamSessionSummary$startTime' => '<p>UTC ISO-8601 formatted timestamp of when the channel went live.</p>', ], ], 'UntagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'UntagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateChannelRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateChannelResponse' => [ 'base' => NULL, 'refs' => [], ], 'ValidationException' => [ 'base' => '<p/>', 'refs' => [], ], 'VideoConfiguration' => [ 'base' => '<p>Object specifying a stream’s video configuration.</p>', 'refs' => [ 'IngestConfiguration$video' => '<p>Encoder settings for video.</p>', ], ], 'errorCode' => [ 'base' => NULL, 'refs' => [ 'BatchError$code' => '<p>Error code.</p>', ], ], 'errorMessage' => [ 'base' => NULL, 'refs' => [ 'AccessDeniedException$exceptionMessage' => '<p>User does not have sufficient access to perform this action.</p>', 'BatchError$message' => '<p>Error message, determined by the application.</p>', 'ChannelNotBroadcasting$exceptionMessage' => '<p>The stream is offline for the given channel ARN.</p>', 'ConflictException$exceptionMessage' => '<p>Updating or deleting a resource can cause an inconsistent state.</p>', 'InternalServerException$exceptionMessage' => '<p>Unexpected error during processing of request.</p>', 'PendingVerification$exceptionMessage' => '<p> Your account is pending verification. </p>', 'ResourceNotFoundException$exceptionMessage' => '<p>Request references a resource which does not exist.</p>', 'ServiceQuotaExceededException$exceptionMessage' => '<p>Request would cause a service quota to be exceeded.</p>', 'StreamUnavailable$exceptionMessage' => '<p>The stream is temporarily unavailable.</p>', 'ThrottlingException$exceptionMessage' => '<p>Request was denied due to request throttling.</p>', 'ValidationException$exceptionMessage' => '<p>The input fails to satisfy the constraints specified by an Amazon Web Services service.</p>', ], ], ],];
