<?php
// This file was auto-generated from sdk-root/src/data/connect/2017-08-08/docs-2.json
return [ 'version' => '2.0', 'service' => '<p>Amazon Connect is a cloud-based contact center solution that you use to set up and manage a customer contact center and provide reliable customer engagement at any scale.</p> <p>Amazon Connect provides metrics and real-time reporting that enable you to optimize contact routing. You can also resolve customer issues more efficiently by getting customers in touch with the appropriate agents.</p> <p>There are limits to the number of Amazon Connect resources that you can create. There are also limits to the number of requests that you can make per second. For more information, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html">Amazon Connect Service Quotas</a> in the <i>Amazon Connect Administrator Guide</i>.</p> <p>You can connect programmatically to an AWS service by using an endpoint. For a list of Amazon Connect endpoints, see <a href="https://docs.aws.amazon.com/general/latest/gr/connect_region.html">Amazon Connect Endpoints</a>.</p> <note> <p>Working with contact flows? Check out the <a href="https://docs.aws.amazon.com/connect/latest/adminguide/flow-language.html">Amazon Connect Flow language</a>.</p> </note>', 'operations' => [ 'AssociateApprovedOrigin' => '<p>This API is in preview release for Amazon Connect and is subject to change.</p> <p>Associates an approved origin to an Amazon Connect instance.</p>', 'AssociateBot' => '<p>This API is in preview release for Amazon Connect and is subject to change.</p> <p>Allows the specified Amazon Connect instance to access the specified Amazon Lex or Amazon Lex V2 bot.</p>', 'AssociateInstanceStorageConfig' => '<p>This API is in preview release for Amazon Connect and is subject to change.</p> <p>Associates a storage resource type for the first time. You can only associate one type of storage configuration in a single call. This means, for example, that you can\'t define an instance with multiple S3 buckets for storing chat transcripts.</p> <p>This API does not create a resource that doesn\'t exist. It only associates it to the instance. Ensure that the resource being specified in the storage configuration, like an S3 bucket, exists when being used for association.</p>', 'AssociateLambdaFunction' => '<p>This API is in preview release for Amazon Connect and is subject to change.</p> <p>Allows the specified Amazon Connect instance to access the specified Lambda function.</p>', 'AssociateLexBot' => '<p>This API is in preview release for Amazon Connect and is subject to change.</p> <p>Allows the specified Amazon Connect instance to access the specified Amazon Lex bot.</p>', 'AssociateQueueQuickConnects' => '<p>This API is in preview release for Amazon Connect and is subject to change.</p> <p>Associates a set of quick connects with a queue.</p>', 'AssociateRoutingProfileQueues' => '<p>Associates a set of queues with a routing profile.</p>', 'AssociateSecurityKey' => '<p>This API is in preview release for Amazon Connect and is subject to change.</p> <p>Associates a security key to the instance.</p>', 'CreateAgentStatus' => '<p>This API is in preview release for Amazon Connect and is subject to change.</p> <p>Creates an agent status for the specified Amazon Connect instance.</p>', 'CreateContactFlow' => '<p>Creates a contact flow for the specified Amazon Connect instance.</p> <p>You can also create and update contact flows using the <a href="https://docs.aws.amazon.com/connect/latest/adminguide/flow-language.html">Amazon Connect Flow language</a>.</p>', 'CreateContactFlowModule' => '<p>Creates a contact flow module for the specified Amazon Connect instance. </p>', 'CreateHoursOfOperation' => '<p>This API is in preview release for Amazon Connect and is subject to change.</p> <p>Creates hours of operation. </p>', 'CreateInstance' => '<p>This API is in preview release for Amazon Connect and is subject to change.</p> <p>Initiates an Amazon Connect instance with all the supported channels enabled. It does not attach any storage, such as Amazon Simple Storage Service (Amazon S3) or Amazon Kinesis. It also does not allow for any configurations on features, such as Contact Lens for Amazon Connect. </p> <p>Amazon Connect enforces a limit on the total number of instances that you can create or delete in 30 days. If you exceed this limit, you will get an error message indicating there has been an excessive number of attempts at creating or deleting instances. You must wait 30 days before you can restart creating and deleting instances in your account.</p>', 'CreateIntegrationAssociation' => '<p>Creates an AWS resource association with an Amazon Connect instance.</p>', 'CreateQueue' => '<p>This API is in preview release for Amazon Connect and is subject to change.</p> <p>Creates a new queue for the specified Amazon Connect instance.</p>', 'CreateQuickConnect' => '<p>Creates a quick connect for the specified Amazon Connect instance.</p>', 'CreateRoutingProfile' => '<p>Creates a new routing profile.</p>', 'CreateSecurityProfile' => '<p>This API is in preview release for Amazon Connect and is subject to change.</p> <p>Creates a security profile.</p>', 'CreateUseCase' => '<p>Creates a use case for an integration association.</p>', 'CreateUser' => '<p>Creates a user account for the specified Amazon Connect instance.</p> <p>For information about how to create user accounts using the Amazon Connect console, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/user-management.html">Add Users</a> in the <i>Amazon Connect Administrator Guide</i>.</p>', 'CreateUserHierarchyGroup' => '<p>Creates a new user hierarchy group.</p>', 'DeleteContactFlow' => '<p>Deletes a contact flow for the specified Amazon Connect instance.</p>', 'DeleteContactFlowModule' => '<p>Deletes the specified contact flow module.</p>', 'DeleteHoursOfOperation' => '<p>This API is in preview release for Amazon Connect and is subject to change.</p> <p>Deletes an hours of operation.</p>', 'DeleteInstance' => '<p>This API is in preview release for Amazon Connect and is subject to change.</p> <p>Deletes the Amazon Connect instance.</p> <p>Amazon Connect enforces a limit on the total number of instances that you can create or delete in 30 days. If you exceed this limit, you will get an error message indicating there has been an excessive number of attempts at creating or deleting instances. You must wait 30 days before you can restart creating and deleting instances in your account.</p>', 'DeleteIntegrationAssociation' => '<p>Deletes an AWS resource association from an Amazon Connect instance. The association must not have any use cases associated with it.</p>', 'DeleteQuickConnect' => '<p>Deletes a quick connect.</p>', 'DeleteSecurityProfile' => '<p>This API is in preview release for Amazon Connect and is subject to change.</p> <p>Deletes a security profile.</p>', 'DeleteUseCase' => '<p>Deletes a use case from an integration association.</p>', 'DeleteUser' => '<p>Deletes a user account from the specified Amazon Connect instance.</p> <p>For information about what happens to a user\'s data when their account is deleted, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/delete-users.html">Delete Users from Your Amazon Connect Instance</a> in the <i>Amazon Connect Administrator Guide</i>.</p>', 'DeleteUserHierarchyGroup' => '<p>Deletes an existing user hierarchy group. It must not be associated with any agents or have any active child groups.</p>', 'DescribeAgentStatus' => '<p>This API is in preview release for Amazon Connect and is subject to change.</p> <p>Describes an agent status.</p>', 'DescribeContact' => '<p>This API is in preview release for Amazon Connect and is subject to change.</p> <p>Describes the specified contact. </p> <important> <p>Contact information remains available in Amazon Connect for 24 months, and then it is deleted.</p> </important>', 'DescribeContactFlow' => '<p>Describes the specified contact flow.</p> <p>You can also create and update contact flows using the <a href="https://docs.aws.amazon.com/connect/latest/adminguide/flow-language.html">Amazon Connect Flow language</a>.</p>', 'DescribeContactFlowModule' => '<p>Describes the specified contact flow module.</p>', 'DescribeHoursOfOperation' => '<p>This API is in preview release for Amazon Connect and is subject to change.</p> <p>Describes the hours of operation.</p>', 'DescribeInstance' => '<p>This API is in preview release for Amazon Connect and is subject to change.</p> <p>Returns the current state of the specified instance identifier. It tracks the instance while it is being created and returns an error status, if applicable. </p> <p>If an instance is not created successfully, the instance status reason field returns details relevant to the reason. The instance in a failed state is returned only for 24 hours after the CreateInstance API was invoked.</p>', 'DescribeInstanceAttribute' => '<p>This API is in preview release for Amazon Connect and is subject to change.</p> <p>Describes the specified instance attribute.</p>', 'DescribeInstanceStorageConfig' => '<p>This API is in preview release for Amazon Connect and is subject to change.</p> <p>Retrieves the current storage configurations for the specified resource type, association ID, and instance ID.</p>', 'DescribeQueue' => '<p>This API is in preview release for Amazon Connect and is subject to change.</p> <p>Describes the specified queue.</p>', 'DescribeQuickConnect' => '<p>Describes the quick connect.</p>', 'DescribeRoutingProfile' => '<p>Describes the specified routing profile.</p>', 'DescribeSecurityProfile' => '<p>This API is in preview release for Amazon Connect and is subject to change.</p> <p>Gets basic information about the security profle.</p>', 'DescribeUser' => '<p>Describes the specified user account. You can find the instance ID in the console (it’s the final part of the ARN). The console does not display the user IDs. Instead, list the users and note the IDs provided in the output.</p>', 'DescribeUserHierarchyGroup' => '<p>Describes the specified hierarchy group.</p>', 'DescribeUserHierarchyStructure' => '<p>Describes the hierarchy structure of the specified Amazon Connect instance.</p>', 'DisassociateApprovedOrigin' => '<p>This API is in preview release for Amazon Connect and is subject to change.</p> <p>Revokes access to integrated applications from Amazon Connect.</p>', 'DisassociateBot' => '<p>This API is in preview release for Amazon Connect and is subject to change.</p> <p>Revokes authorization from the specified instance to access the specified Amazon Lex or Amazon Lex V2 bot. </p>', 'DisassociateInstanceStorageConfig' => '<p>This API is in preview release for Amazon Connect and is subject to change.</p> <p>Removes the storage type configurations for the specified resource type and association ID.</p>', 'DisassociateLambdaFunction' => '<p>This API is in preview release for Amazon Connect and is subject to change.</p> <p>Remove the Lambda function from the dropdown options available in the relevant contact flow blocks.</p>', 'DisassociateLexBot' => '<p>This API is in preview release for Amazon Connect and is subject to change.</p> <p>Revokes authorization from the specified instance to access the specified Amazon Lex bot.</p>', 'DisassociateQueueQuickConnects' => '<p>This API is in preview release for Amazon Connect and is subject to change.</p> <p>Disassociates a set of quick connects from a queue.</p>', 'DisassociateRoutingProfileQueues' => '<p>Disassociates a set of queues from a routing profile.</p>', 'DisassociateSecurityKey' => '<p>This API is in preview release for Amazon Connect and is subject to change.</p> <p>Deletes the specified security key.</p>', 'GetContactAttributes' => '<p>Retrieves the contact attributes for the specified contact.</p>', 'GetCurrentMetricData' => '<p>Gets the real-time metric data from the specified Amazon Connect instance.</p> <p>For a description of each metric, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html">Real-time Metrics Definitions</a> in the <i>Amazon Connect Administrator Guide</i>.</p>', 'GetFederationToken' => '<p>Retrieves a token for federation.</p> <note> <p>This API doesn\'t support root users. If you try to invoke GetFederationToken with root credentials, an error message similar to the following one appears: </p> <p> <code>Provided identity: Principal: .... User: .... cannot be used for federation with Amazon Connect</code> </p> </note>', 'GetMetricData' => '<p>Gets historical metric data from the specified Amazon Connect instance.</p> <p>For a description of each historical metric, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html">Historical Metrics Definitions</a> in the <i>Amazon Connect Administrator Guide</i>.</p>', 'ListAgentStatuses' => '<p>This API is in preview release for Amazon Connect and is subject to change.</p> <p>Lists agent statuses.</p>', 'ListApprovedOrigins' => '<p>This API is in preview release for Amazon Connect and is subject to change.</p> <p>Returns a paginated list of all approved origins associated with the instance.</p>', 'ListBots' => '<p>This API is in preview release for Amazon Connect and is subject to change.</p> <p>For the specified version of Amazon Lex, returns a paginated list of all the Amazon Lex bots currently associated with the instance. </p>', 'ListContactFlowModules' => '<p>Provides information about the contact flow modules for the specified Amazon Connect instance.</p>', 'ListContactFlows' => '<p>Provides information about the contact flows for the specified Amazon Connect instance.</p> <p>You can also create and update contact flows using the <a href="https://docs.aws.amazon.com/connect/latest/adminguide/flow-language.html">Amazon Connect Flow language</a>.</p> <p>For more information about contact flows, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/concepts-contact-flows.html">Contact Flows</a> in the <i>Amazon Connect Administrator Guide</i>.</p>', 'ListContactReferences' => '<p>This API is in preview release for Amazon Connect and is subject to change.</p> <p>For the specified <code>referenceTypes</code>, returns a list of references associated with the contact. </p>', 'ListHoursOfOperations' => '<p>Provides information about the hours of operation for the specified Amazon Connect instance.</p> <p>For more information about hours of operation, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/set-hours-operation.html">Set the Hours of Operation for a Queue</a> in the <i>Amazon Connect Administrator Guide</i>.</p>', 'ListInstanceAttributes' => '<p>This API is in preview release for Amazon Connect and is subject to change.</p> <p>Returns a paginated list of all attribute types for the given instance.</p>', 'ListInstanceStorageConfigs' => '<p>This API is in preview release for Amazon Connect and is subject to change.</p> <p>Returns a paginated list of storage configs for the identified instance and resource type.</p>', 'ListInstances' => '<p>This API is in preview release for Amazon Connect and is subject to change.</p> <p>Return a list of instances which are in active state, creation-in-progress state, and failed state. Instances that aren\'t successfully created (they are in a failed state) are returned only for 24 hours after the CreateInstance API was invoked.</p>', 'ListIntegrationAssociations' => '<p>Provides summary information about the AWS resource associations for the specified Amazon Connect instance.</p>', 'ListLambdaFunctions' => '<p>This API is in preview release for Amazon Connect and is subject to change.</p> <p>Returns a paginated list of all Lambda functions that display in the dropdown options in the relevant contact flow blocks.</p>', 'ListLexBots' => '<p>This API is in preview release for Amazon Connect and is subject to change.</p> <p>Returns a paginated list of all the Amazon Lex bots currently associated with the instance.</p>', 'ListPhoneNumbers' => '<p>Provides information about the phone numbers for the specified Amazon Connect instance. </p> <p>For more information about phone numbers, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/contact-center-phone-number.html">Set Up Phone Numbers for Your Contact Center</a> in the <i>Amazon Connect Administrator Guide</i>.</p>', 'ListPrompts' => '<p>Provides information about the prompts for the specified Amazon Connect instance.</p>', 'ListQueueQuickConnects' => '<p>This API is in preview release for Amazon Connect and is subject to change.</p> <p>Lists the quick connects associated with a queue.</p>', 'ListQueues' => '<p>Provides information about the queues for the specified Amazon Connect instance.</p> <p>If you do not specify a <code>QueueTypes</code> parameter, both standard and agent queues are returned. This might cause an unexpected truncation of results if you have more than 1000 agents and you limit the number of results of the API call in code.</p> <p>For more information about queues, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/concepts-queues-standard-and-agent.html">Queues: Standard and Agent</a> in the <i>Amazon Connect Administrator Guide</i>.</p>', 'ListQuickConnects' => '<p>Provides information about the quick connects for the specified Amazon Connect instance. </p>', 'ListRoutingProfileQueues' => '<p>Lists the queues associated with a routing profile.</p>', 'ListRoutingProfiles' => '<p>Provides summary information about the routing profiles for the specified Amazon Connect instance.</p> <p>For more information about routing profiles, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/concepts-routing.html">Routing Profiles</a> and <a href="https://docs.aws.amazon.com/connect/latest/adminguide/routing-profiles.html">Create a Routing Profile</a> in the <i>Amazon Connect Administrator Guide</i>.</p>', 'ListSecurityKeys' => '<p>This API is in preview release for Amazon Connect and is subject to change.</p> <p>Returns a paginated list of all security keys associated with the instance.</p>', 'ListSecurityProfilePermissions' => '<p>This API is in preview release for Amazon Connect and is subject to change.</p> <p>Lists the permissions granted to a security profile.</p>', 'ListSecurityProfiles' => '<p>Provides summary information about the security profiles for the specified Amazon Connect instance.</p> <p>For more information about security profiles, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/connect-security-profiles.html">Security Profiles</a> in the <i>Amazon Connect Administrator Guide</i>.</p>', 'ListTagsForResource' => '<p>Lists the tags for the specified resource.</p> <p>For sample policies that use tags, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/security_iam_id-based-policy-examples.html">Amazon Connect Identity-Based Policy Examples</a> in the <i>Amazon Connect Administrator Guide</i>.</p>', 'ListUseCases' => '<p>Lists the use cases for the integration association. </p>', 'ListUserHierarchyGroups' => '<p>Provides summary information about the hierarchy groups for the specified Amazon Connect instance.</p> <p>For more information about agent hierarchies, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/agent-hierarchy.html">Set Up Agent Hierarchies</a> in the <i>Amazon Connect Administrator Guide</i>.</p>', 'ListUsers' => '<p>Provides summary information about the users for the specified Amazon Connect instance.</p>', 'ResumeContactRecording' => '<p>When a contact is being recorded, and the recording has been suspended using SuspendContactRecording, this API resumes recording the call.</p> <p>Only voice recordings are supported at this time.</p>', 'StartChatContact' => '<p>Initiates a contact flow to start a new chat for the customer. Response of this API provides a token required to obtain credentials from the <a href="https://docs.aws.amazon.com/connect-participant/latest/APIReference/API_CreateParticipantConnection.html">CreateParticipantConnection</a> API in the Amazon Connect Participant Service.</p> <p>When a new chat contact is successfully created, clients must subscribe to the participant’s connection for the created chat within 5 minutes. This is achieved by invoking <a href="https://docs.aws.amazon.com/connect-participant/latest/APIReference/API_CreateParticipantConnection.html">CreateParticipantConnection</a> with WEBSOCKET and CONNECTION_CREDENTIALS. </p> <p>A 429 error occurs in two situations:</p> <ul> <li> <p>API rate limit is exceeded. API TPS throttling returns a <code>TooManyRequests</code> exception.</p> </li> <li> <p>The <a href="https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html">quota for concurrent active chats</a> is exceeded. Active chat throttling returns a <code>LimitExceededException</code>.</p> </li> </ul> <p>For more information about chat, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/chat.html">Chat</a> in the <i>Amazon Connect Administrator Guide</i>.</p>', 'StartContactRecording' => '<p>Starts recording the contact when the agent joins the call. StartContactRecording is a one-time action. For example, if you use StopContactRecording to stop recording an ongoing call, you can\'t use StartContactRecording to restart it. For scenarios where the recording has started and you want to suspend and resume it, such as when collecting sensitive information (for example, a credit card number), use SuspendContactRecording and ResumeContactRecording.</p> <p>You can use this API to override the recording behavior configured in the <a href="https://docs.aws.amazon.com/connect/latest/adminguide/set-recording-behavior.html">Set recording behavior</a> block.</p> <p>Only voice recordings are supported at this time.</p>', 'StartContactStreaming' => '<p> Initiates real-time message streaming for a new chat contact.</p> <p> For more information about message streaming, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/chat-message-streaming.html">Enable real-time chat message streaming</a> in the <i>Amazon Connect Administrator Guide</i>.</p>', 'StartOutboundVoiceContact' => '<p>Places an outbound call to a contact, and then initiates the contact flow. It performs the actions in the contact flow that\'s specified (in <code>ContactFlowId</code>).</p> <p>Agents do not initiate the outbound API, which means that they do not dial the contact. If the contact flow places an outbound call to a contact, and then puts the contact in queue, the call is then routed to the agent, like any other inbound case.</p> <p>There is a 60-second dialing timeout for this operation. If the call is not connected after 60 seconds, it fails.</p> <note> <p>UK numbers with a 447 prefix are not allowed by default. Before you can dial these UK mobile numbers, you must submit a service quota increase request. For more information, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html">Amazon Connect Service Quotas</a> in the <i>Amazon Connect Administrator Guide</i>. </p> </note> <note> <p>Campaign calls are not allowed by default. Before you can make a call with <code>TrafficType</code> = <code>CAMPAIGN</code>, you must submit a service quota increase request. For more information, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html">Amazon Connect Service Quotas</a> in the <i>Amazon Connect Administrator Guide</i>. </p> </note>', 'StartTaskContact' => '<p>Initiates a contact flow to start a new task.</p>', 'StopContact' => '<p>Ends the specified contact.</p>', 'StopContactRecording' => '<p>Stops recording a call when a contact is being recorded. StopContactRecording is a one-time action. If you use StopContactRecording to stop recording an ongoing call, you can\'t use StartContactRecording to restart it. For scenarios where the recording has started and you want to suspend it for sensitive information (for example, to collect a credit card number), and then restart it, use SuspendContactRecording and ResumeContactRecording.</p> <p>Only voice recordings are supported at this time.</p>', 'StopContactStreaming' => '<p> Ends message streaming on a specified contact. To restart message streaming on that contact, call the <a href="https://docs.aws.amazon.com/connect/latest/APIReference/API_StartContactStreaming.html">StartContactStreaming</a> API. </p>', 'SuspendContactRecording' => '<p>When a contact is being recorded, this API suspends recording the call. For example, you might suspend the call recording while collecting sensitive information, such as a credit card number. Then use ResumeContactRecording to restart recording. </p> <p>The period of time that the recording is suspended is filled with silence in the final recording. </p> <p>Only voice recordings are supported at this time.</p>', 'TagResource' => '<p>Adds the specified tags to the specified resource.</p> <p>The supported resource types are users, routing profiles, queues, quick connects, contact flows, agent status, and hours of operation.</p> <p>For sample policies that use tags, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/security_iam_id-based-policy-examples.html">Amazon Connect Identity-Based Policy Examples</a> in the <i>Amazon Connect Administrator Guide</i>.</p>', 'UntagResource' => '<p>Removes the specified tags from the specified resource.</p>', 'UpdateAgentStatus' => '<p>This API is in preview release for Amazon Connect and is subject to change.</p> <p>Updates agent status.</p>', 'UpdateContact' => '<p>This API is in preview release for Amazon Connect and is subject to change.</p> <p>Adds or updates user-defined contact information associated with the specified contact. At least one field to be updated must be present in the request.</p> <important> <p>You can add or update user-defined contact information for both ongoing and completed contacts.</p> </important>', 'UpdateContactAttributes' => '<p>Creates or updates user-defined contact attributes associated with the specified contact.</p> <p>You can create or update user-defined attributes for both ongoing and completed contacts. For example, while the call is active, you can update the customer\'s name or the reason the customer called. You can add notes about steps that the agent took during the call that display to the next agent that takes the call. You can also update attributes for a contact using data from your CRM application and save the data with the contact in Amazon Connect. You could also flag calls for additional analysis, such as legal review or to identify abusive callers.</p> <p>Contact attributes are available in Amazon Connect for 24 months, and are then deleted. For information about CTR retention and the maximum size of the CTR attributes section, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html#feature-limits">Feature specifications</a> in the <i>Amazon Connect Administrator Guide</i>. </p> <p> <b>Important:</b> You cannot use the operation to update attributes for contacts that occurred prior to the release of the API, which was September 12, 2018. You can update attributes only for contacts that started after the release of the API. If you attempt to update attributes for a contact that occurred prior to the release of the API, a 400 error is returned. This applies also to queued callbacks that were initiated prior to the release of the API but are still active in your instance.</p>', 'UpdateContactFlowContent' => '<p>Updates the specified contact flow.</p> <p>You can also create and update contact flows using the <a href="https://docs.aws.amazon.com/connect/latest/adminguide/flow-language.html">Amazon Connect Flow language</a>.</p>', 'UpdateContactFlowMetadata' => '<p>Updates metadata about specified contact flow.</p>', 'UpdateContactFlowModuleContent' => '<p>Updates specified contact flow module for the specified Amazon Connect instance. </p>', 'UpdateContactFlowModuleMetadata' => '<p>Updates metadata about specified contact flow module.</p>', 'UpdateContactFlowName' => '<p>The name of the contact flow.</p> <p>You can also create and update contact flows using the <a href="https://docs.aws.amazon.com/connect/latest/adminguide/flow-language.html">Amazon Connect Flow language</a>.</p>', 'UpdateContactSchedule' => '<p>Updates the scheduled time of a task contact that is already scheduled.</p>', 'UpdateHoursOfOperation' => '<p>This API is in preview release for Amazon Connect and is subject to change.</p> <p>Updates the hours of operation.</p>', 'UpdateInstanceAttribute' => '<p>This API is in preview release for Amazon Connect and is subject to change.</p> <p>Updates the value for the specified attribute type.</p>', 'UpdateInstanceStorageConfig' => '<p>This API is in preview release for Amazon Connect and is subject to change.</p> <p>Updates an existing configuration for a resource type. This API is idempotent.</p>', 'UpdateQueueHoursOfOperation' => '<p>This API is in preview release for Amazon Connect and is subject to change.</p> <p>Updates the hours of operation for the specified queue.</p>', 'UpdateQueueMaxContacts' => '<p>This API is in preview release for Amazon Connect and is subject to change.</p> <p>Updates the maximum number of contacts allowed in a queue before it is considered full.</p>', 'UpdateQueueName' => '<p>This API is in preview release for Amazon Connect and is subject to change.</p> <p>Updates the name and description of a queue. At least <code>Name</code> or <code>Description</code> must be provided.</p>', 'UpdateQueueOutboundCallerConfig' => '<p>This API is in preview release for Amazon Connect and is subject to change.</p> <p>Updates the outbound caller ID name, number, and outbound whisper flow for a specified queue.</p>', 'UpdateQueueStatus' => '<p>This API is in preview release for Amazon Connect and is subject to change.</p> <p>Updates the status of the queue.</p>', 'UpdateQuickConnectConfig' => '<p>Updates the configuration settings for the specified quick connect.</p>', 'UpdateQuickConnectName' => '<p>Updates the name and description of a quick connect. The request accepts the following data in JSON format. At least <code>Name</code> or <code>Description</code> must be provided.</p>', 'UpdateRoutingProfileConcurrency' => '<p>Updates the channels that agents can handle in the Contact Control Panel (CCP) for a routing profile.</p>', 'UpdateRoutingProfileDefaultOutboundQueue' => '<p>Updates the default outbound queue of a routing profile.</p>', 'UpdateRoutingProfileName' => '<p>Updates the name and description of a routing profile. The request accepts the following data in JSON format. At least <code>Name</code> or <code>Description</code> must be provided.</p>', 'UpdateRoutingProfileQueues' => '<p>Updates the properties associated with a set of queues for a routing profile.</p>', 'UpdateSecurityProfile' => '<p>This API is in preview release for Amazon Connect and is subject to change.</p> <p>Updates a security profile.</p>', 'UpdateUserHierarchy' => '<p>Assigns the specified hierarchy group to the specified user.</p>', 'UpdateUserHierarchyGroupName' => '<p>Updates the name of the user hierarchy group. </p>', 'UpdateUserHierarchyStructure' => '<p>Updates the user hierarchy structure: add, remove, and rename user hierarchy levels.</p>', 'UpdateUserIdentityInfo' => '<p>Updates the identity information for the specified user.</p> <important> <p>We strongly recommend limiting who has the ability to invoke <code>UpdateUserIdentityInfo</code>. Someone with that ability can change the login credentials of other users by changing their email address. This poses a security risk to your organization. They can change the email address of a user to the attacker\'s email address, and then reset the password through email. For more information, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/security-profile-best-practices.html">Best Practices for Security Profiles</a> in the <i>Amazon Connect Administrator Guide</i>.</p> </important>', 'UpdateUserPhoneConfig' => '<p>Updates the phone configuration settings for the specified user.</p>', 'UpdateUserRoutingProfile' => '<p>Assigns the specified routing profile to the specified user.</p>', 'UpdateUserSecurityProfiles' => '<p>Assigns the specified security profiles to the specified user.</p>', ], 'shapes' => [ 'ARN' => [ 'base' => NULL, 'refs' => [ 'AgentStatus$AgentStatusARN' => '<p>The Amazon Resource Name (ARN) of the agent status.</p>', 'AgentStatusSummary$Arn' => '<p>The Amazon Resource Name (ARN) for the agent status.</p>', 'Contact$Arn' => '<p>The Amazon Resource Name (ARN) for the contact.</p>', 'ContactFlow$Arn' => '<p>The Amazon Resource Name (ARN) of the contact flow.</p>', 'ContactFlowModule$Arn' => '<p>The Amazon Resource Name (ARN).</p>', 'ContactFlowModuleSummary$Arn' => '<p>The Amazon Resource Name (ARN) of the contact flow module.</p>', 'ContactFlowSummary$Arn' => '<p>The Amazon Resource Name (ARN) of the contact flow.</p>', 'CreateAgentStatusResponse$AgentStatusARN' => '<p>The Amazon Resource Name (ARN) of the agent status.</p>', 'CreateContactFlowModuleResponse$Arn' => '<p>The Amazon Resource Name (ARN) of the contact flow module.</p>', 'CreateContactFlowResponse$ContactFlowArn' => '<p>The Amazon Resource Name (ARN) of the contact flow.</p>', 'CreateHoursOfOperationResponse$HoursOfOperationArn' => '<p>The Amazon Resource Name (ARN) for the hours of operation.</p>', 'CreateInstanceResponse$Arn' => '<p>The Amazon Resource Name (ARN) of the instance.</p>', 'CreateIntegrationAssociationRequest$IntegrationArn' => '<p>The Amazon Resource Name (ARN) of the integration.</p>', 'CreateIntegrationAssociationResponse$IntegrationAssociationArn' => '<p>The Amazon Resource Name (ARN) for the association.</p>', 'CreateQueueResponse$QueueArn' => '<p>The Amazon Resource Name (ARN) of the queue.</p>', 'CreateQuickConnectResponse$QuickConnectARN' => '<p>The Amazon Resource Name (ARN) for the quick connect. </p>', 'CreateRoutingProfileResponse$RoutingProfileArn' => '<p>The Amazon Resource Name (ARN) of the routing profile.</p>', 'CreateSecurityProfileResponse$SecurityProfileArn' => '<p>The Amazon Resource Name (ARN) for the security profile.</p>', 'CreateUseCaseResponse$UseCaseArn' => '<p>The Amazon Resource Name (ARN) for the use case.</p>', 'CreateUserHierarchyGroupResponse$HierarchyGroupArn' => '<p>The Amazon Resource Name (ARN) of the hierarchy group. </p>', 'CreateUserResponse$UserArn' => '<p>The Amazon Resource Name (ARN) of the user account.</p>', 'HierarchyGroup$Arn' => '<p>The Amazon Resource Name (ARN) of the hierarchy group.</p>', 'HierarchyGroupSummary$Arn' => '<p>The Amazon Resource Name (ARN) of the hierarchy group.</p>', 'HierarchyLevel$Arn' => '<p>The Amazon Resource Name (ARN) of the hierarchy level.</p>', 'HoursOfOperation$HoursOfOperationArn' => '<p>The Amazon Resource Name (ARN) for the hours of operation.</p>', 'HoursOfOperationSummary$Arn' => '<p>The Amazon Resource Name (ARN) of the hours of operation.</p>', 'Instance$Arn' => '<p>The Amazon Resource Name (ARN) of the instance.</p>', 'Instance$ServiceRole' => '<p>The service role of the instance.</p>', 'InstanceSummary$Arn' => '<p>The Amazon Resource Name (ARN) of the instance.</p>', 'InstanceSummary$ServiceRole' => '<p>The service role of the instance.</p>', 'IntegrationAssociationSummary$IntegrationAssociationArn' => '<p>The Amazon Resource Name (ARN) for the AppIntegration association.</p>', 'IntegrationAssociationSummary$IntegrationArn' => '<p>The Amazon Resource Name (ARN) for the AppIntegration.</p>', 'KinesisFirehoseConfig$FirehoseArn' => '<p>The Amazon Resource Name (ARN) of the delivery stream.</p>', 'KinesisStreamConfig$StreamArn' => '<p>The Amazon Resource Name (ARN) of the data stream.</p>', 'ListTagsForResourceRequest$resourceArn' => '<p>The Amazon Resource Name (ARN) of the resource.</p>', 'PhoneNumberSummary$Arn' => '<p>The Amazon Resource Name (ARN) of the phone number.</p>', 'PromptSummary$Arn' => '<p>The Amazon Resource Name (ARN) of the prompt.</p>', 'Queue$QueueArn' => '<p>The Amazon Resource Name (ARN) for the queue.</p>', 'QueueReference$Arn' => '<p>The Amazon Resource Name (ARN) of the queue.</p>', 'QueueSummary$Arn' => '<p>The Amazon Resource Name (ARN) of the queue.</p>', 'QuickConnect$QuickConnectARN' => '<p>The Amazon Resource Name (ARN) of the quick connect.</p>', 'QuickConnectSummary$Arn' => '<p>The Amazon Resource Name (ARN) of the quick connect.</p>', 'ResourceInUseException$ResourceId' => '<p>The identifier for the resource.</p>', 'RoutingProfile$RoutingProfileArn' => '<p>The Amazon Resource Name (ARN) of the routing profile.</p>', 'RoutingProfileQueueConfigSummary$QueueArn' => '<p>The Amazon Resource Name (ARN) of the queue.</p>', 'RoutingProfileSummary$Arn' => '<p>The Amazon Resource Name (ARN) of the routing profile.</p>', 'SecurityProfile$Arn' => '<p>The Amazon Resource Name (ARN) for the secruity profile.</p>', 'SecurityProfileSummary$Arn' => '<p>The Amazon Resource Name (ARN) of the security profile.</p>', 'TagResourceRequest$resourceArn' => '<p>The Amazon Resource Name (ARN) of the resource.</p>', 'UntagResourceRequest$resourceArn' => '<p>The Amazon Resource Name (ARN) of the resource.</p>', 'UseCase$UseCaseArn' => '<p>The Amazon Resource Name (ARN) for the use case.</p>', 'User$Arn' => '<p>The Amazon Resource Name (ARN) of the user account.</p>', 'UserSummary$Arn' => '<p>The Amazon Resource Name (ARN) of the user account.</p>', ], ], 'AccessDeniedException' => [ 'base' => '<p>You do not have sufficient permissions to perform this action.</p>', 'refs' => [], ], 'AfterContactWorkTimeLimit' => [ 'base' => NULL, 'refs' => [ 'UserPhoneConfig$AfterContactWorkTimeLimit' => '<p>The After Call Work (ACW) timeout setting, in seconds.</p>', ], ], 'AgentFirstName' => [ 'base' => NULL, 'refs' => [ 'UserIdentityInfo$FirstName' => '<p>The first name. This is required if you are using Amazon Connect or SAML for identity management.</p>', ], ], 'AgentInfo' => [ 'base' => '<p>Information about the agent who accepted the contact.</p>', 'refs' => [ 'Contact$AgentInfo' => '<p>Information about the agent who accepted the contact.</p>', ], ], 'AgentLastName' => [ 'base' => NULL, 'refs' => [ 'UserIdentityInfo$LastName' => '<p>The last name. This is required if you are using Amazon Connect or SAML for identity management.</p>', ], ], 'AgentResourceId' => [ 'base' => NULL, 'refs' => [ 'AgentInfo$Id' => '<p>The identifier of the agent who accepted the contact.</p>', ], ], 'AgentStatus' => [ 'base' => '<p>Contains information about an agent status.</p>', 'refs' => [ 'DescribeAgentStatusResponse$AgentStatus' => '<p>The agent status.</p>', ], ], 'AgentStatusDescription' => [ 'base' => NULL, 'refs' => [ 'AgentStatus$Description' => '<p>The description of the agent status.</p>', 'CreateAgentStatusRequest$Description' => '<p>The description of the status.</p>', ], ], 'AgentStatusId' => [ 'base' => NULL, 'refs' => [ 'AgentStatus$AgentStatusId' => '<p>The identifier of the agent status.</p>', 'AgentStatusSummary$Id' => '<p>The identifier for an agent status.</p>', 'CreateAgentStatusResponse$AgentStatusId' => '<p>The identifier of the agent status.</p>', 'DescribeAgentStatusRequest$AgentStatusId' => '<p>The identifier for the agent status.</p>', 'UpdateAgentStatusRequest$AgentStatusId' => '<p>The identifier of the agent status.</p>', ], ], 'AgentStatusName' => [ 'base' => NULL, 'refs' => [ 'AgentStatus$Name' => '<p>The name of the agent status.</p>', 'AgentStatusSummary$Name' => '<p>The name of the agent status.</p>', 'CreateAgentStatusRequest$Name' => '<p>The name of the status.</p>', 'UpdateAgentStatusRequest$Name' => '<p>The name of the agent status.</p>', ], ], 'AgentStatusOrderNumber' => [ 'base' => NULL, 'refs' => [ 'AgentStatus$DisplayOrder' => '<p>The display order of the agent status.</p>', 'CreateAgentStatusRequest$DisplayOrder' => '<p>The display order of the status.</p>', 'UpdateAgentStatusRequest$DisplayOrder' => '<p>The display order of the agent status.</p>', ], ], 'AgentStatusState' => [ 'base' => NULL, 'refs' => [ 'AgentStatus$State' => '<p>The state of the agent status.</p>', 'CreateAgentStatusRequest$State' => '<p>The state of the status.</p>', 'UpdateAgentStatusRequest$State' => '<p>The state of the agent status.</p>', ], ], 'AgentStatusSummary' => [ 'base' => '<p>Summary information for an agent status.</p>', 'refs' => [ 'AgentStatusSummaryList$member' => NULL, ], ], 'AgentStatusSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListAgentStatusResponse$AgentStatusSummaryList' => '<p>A summary of agent statuses.</p>', ], ], 'AgentStatusType' => [ 'base' => NULL, 'refs' => [ 'AgentStatus$Type' => '<p>The type of agent status.</p>', 'AgentStatusSummary$Type' => '<p>The type of the agent status.</p>', 'AgentStatusTypes$member' => NULL, ], ], 'AgentStatusTypes' => [ 'base' => NULL, 'refs' => [ 'ListAgentStatusRequest$AgentStatusTypes' => '<p>Available agent status types.</p>', ], ], 'AgentUsername' => [ 'base' => NULL, 'refs' => [ 'CreateUserRequest$Username' => '<p>The user name for the account. For instances not using SAML for identity management, the user name can include up to 20 characters. If you are using SAML for identity management, the user name can include up to 64 characters from [a-zA-Z0-9_-.\\@]+.</p>', 'User$Username' => '<p>The user name assigned to the user account.</p>', 'UserSummary$Username' => '<p>The Amazon Connect user name of the user account.</p>', ], ], 'AliasArn' => [ 'base' => NULL, 'refs' => [ 'LexV2Bot$AliasArn' => '<p>The Amazon Resource Name (ARN) of the Amazon Lex V2 bot.</p>', ], ], 'AnswerMachineDetectionConfig' => [ 'base' => '<p>Configuration of the answering machine detection.</p>', 'refs' => [ 'StartOutboundVoiceContactRequest$AnswerMachineDetectionConfig' => '<p>Configuration of the answering machine detection for this outbound call. </p>', ], ], 'AssociateApprovedOriginRequest' => [ 'base' => NULL, 'refs' => [], ], 'AssociateBotRequest' => [ 'base' => NULL, 'refs' => [], ], 'AssociateInstanceStorageConfigRequest' => [ 'base' => NULL, 'refs' => [], ], 'AssociateInstanceStorageConfigResponse' => [ 'base' => NULL, 'refs' => [], ], 'AssociateLambdaFunctionRequest' => [ 'base' => NULL, 'refs' => [], ], 'AssociateLexBotRequest' => [ 'base' => NULL, 'refs' => [], ], 'AssociateQueueQuickConnectsRequest' => [ 'base' => NULL, 'refs' => [], ], 'AssociateRoutingProfileQueuesRequest' => [ 'base' => NULL, 'refs' => [], ], 'AssociateSecurityKeyRequest' => [ 'base' => NULL, 'refs' => [], ], 'AssociateSecurityKeyResponse' => [ 'base' => NULL, 'refs' => [], ], 'AssociationId' => [ 'base' => NULL, 'refs' => [ 'AssociateInstanceStorageConfigResponse$AssociationId' => '<p>The existing association identifier that uniquely identifies the resource type and storage config for the given instance ID.</p>', 'AssociateSecurityKeyResponse$AssociationId' => '<p>The existing association identifier that uniquely identifies the resource type and storage config for the given instance ID.</p>', 'DescribeInstanceStorageConfigRequest$AssociationId' => '<p>The existing association identifier that uniquely identifies the resource type and storage config for the given instance ID.</p>', 'DisassociateInstanceStorageConfigRequest$AssociationId' => '<p>The existing association identifier that uniquely identifies the resource type and storage config for the given instance ID.</p>', 'DisassociateSecurityKeyRequest$AssociationId' => '<p>The existing association identifier that uniquely identifies the resource type and storage config for the given instance ID.</p>', 'InstanceStorageConfig$AssociationId' => '<p>The existing association identifier that uniquely identifies the resource type and storage config for the given instance ID.</p>', 'SecurityKey$AssociationId' => '<p>The existing association identifier that uniquely identifies the resource type and storage config for the given instance ID.</p>', 'UpdateInstanceStorageConfigRequest$AssociationId' => '<p>The existing association identifier that uniquely identifies the resource type and storage config for the given instance ID.</p>', ], ], 'AttachmentReference' => [ 'base' => '<p>Information about the attachment reference if the <code>referenceType</code> is <code>ATTACHMENT</code>. Otherwise, null.</p>', 'refs' => [ 'ReferenceSummary$Attachment' => '<p>Information about the attachment reference if the <code>referenceType</code> is <code>ATTACHMENT</code>. Otherwise, null.</p>', ], ], 'Attribute' => [ 'base' => '<p>A toggle for an individual feature at the instance level.</p>', 'refs' => [ 'AttributesList$member' => NULL, 'DescribeInstanceAttributeResponse$Attribute' => '<p>The type of attribute.</p>', ], ], 'AttributeName' => [ 'base' => NULL, 'refs' => [ 'Attributes$key' => NULL, ], ], 'AttributeValue' => [ 'base' => NULL, 'refs' => [ 'Attributes$value' => NULL, ], ], 'Attributes' => [ 'base' => NULL, 'refs' => [ 'GetContactAttributesResponse$Attributes' => '<p>Information about the attributes.</p>', 'StartChatContactRequest$Attributes' => '<p>A custom key-value pair using an attribute map. The attributes are standard Amazon Connect attributes. They can be accessed in contact flows just like any other contact attributes. </p> <p>There can be up to 32,768 UTF-8 bytes across all key-value pairs per contact. Attribute keys can include only alphanumeric, dash, and underscore characters.</p>', 'StartOutboundVoiceContactRequest$Attributes' => '<p>A custom key-value pair using an attribute map. The attributes are standard Amazon Connect attributes, and can be accessed in contact flows just like any other contact attributes.</p> <p>There can be up to 32,768 UTF-8 bytes across all key-value pairs per contact. Attribute keys can include only alphanumeric, dash, and underscore characters.</p>', 'StartTaskContactRequest$Attributes' => '<p>A custom key-value pair using an attribute map. The attributes are standard Amazon Connect attributes, and can be accessed in contact flows just like any other contact attributes.</p> <p>There can be up to 32,768 UTF-8 bytes across all key-value pairs per contact. Attribute keys can include only alphanumeric, dash, and underscore characters.</p>', 'UpdateContactAttributesRequest$Attributes' => '<p>The Amazon Connect attributes. These attributes can be accessed in contact flows just like any other contact attributes.</p> <p>You can have up to 32,768 UTF-8 bytes across all attributes for a contact. Attribute keys can include only alphanumeric, dash, and underscore characters.</p>', ], ], 'AttributesList' => [ 'base' => NULL, 'refs' => [ 'ListInstanceAttributesResponse$Attributes' => '<p>The attribute types.</p>', ], ], 'AutoAccept' => [ 'base' => NULL, 'refs' => [ 'UserPhoneConfig$AutoAccept' => '<p>The Auto accept setting.</p>', ], ], 'Boolean' => [ 'base' => NULL, 'refs' => [ 'AnswerMachineDetectionConfig$EnableAnswerMachineDetection' => '<p>The flag to indicate if answer machine detection analysis needs to be performed for a voice call. If set to <code>true</code>, <code>TrafficType</code> must be set as <code>CAMPAIGN</code>. </p>', 'AnswerMachineDetectionConfig$AwaitAnswerMachinePrompt' => '<p>Wait for the answering machine prompt.</p>', 'UpdateAgentStatusRequest$ResetOrderNumber' => '<p>A number indicating the reset order of the agent status.</p>', ], ], 'BotName' => [ 'base' => NULL, 'refs' => [ 'DisassociateLexBotRequest$BotName' => '<p>The name of the Amazon Lex bot. Maximum character limit of 50.</p>', 'LexBot$Name' => '<p>The name of the Amazon Lex bot.</p>', ], ], 'BucketName' => [ 'base' => NULL, 'refs' => [ 'S3Config$BucketName' => '<p>The S3 bucket name.</p>', ], ], 'CampaignId' => [ 'base' => NULL, 'refs' => [ 'StartOutboundVoiceContactRequest$CampaignId' => '<p>The campaign identifier of the outbound communication.</p>', ], ], 'Channel' => [ 'base' => NULL, 'refs' => [ 'Channels$member' => NULL, 'Contact$Channel' => '<p>How the contact reached your contact center.</p>', 'Dimensions$Channel' => '<p>The channel used for grouping and filters.</p>', 'MediaConcurrency$Channel' => '<p>The channels that agents can handle in the Contact Control Panel (CCP).</p>', 'RoutingProfileQueueConfigSummary$Channel' => '<p>The channels this queue supports.</p>', 'RoutingProfileQueueReference$Channel' => '<p>The channels agents can handle in the Contact Control Panel (CCP) for this routing profile.</p>', ], ], 'Channels' => [ 'base' => NULL, 'refs' => [ 'Filters$Channels' => '<p>The channel to use to filter the metrics.</p>', ], ], 'ChatContent' => [ 'base' => NULL, 'refs' => [ 'ChatMessage$Content' => '<p>The content of the chat message.</p>', ], ], 'ChatContentType' => [ 'base' => NULL, 'refs' => [ 'ChatMessage$ContentType' => '<p>The type of the content. Supported types are text and plain.</p>', ], ], 'ChatMessage' => [ 'base' => '<p>A chat message.</p>', 'refs' => [ 'StartChatContactRequest$InitialMessage' => '<p>The initial message to be sent to the newly created chat.</p>', ], ], 'ChatStreamingConfiguration' => [ 'base' => '<p>The streaming configuration, such as the Amazon SNS streaming endpoint.</p>', 'refs' => [ 'StartContactStreamingRequest$ChatStreamingConfiguration' => '<p>The streaming configuration, such as the Amazon SNS streaming endpoint.</p>', ], ], 'ChatStreamingEndpointARN' => [ 'base' => NULL, 'refs' => [ 'ChatStreamingConfiguration$StreamingEndpointArn' => '<p>The Amazon Resource Name (ARN) of the standard Amazon SNS topic. The Amazon Resource Name (ARN) of the streaming endpoint that is used to publish real-time message streaming for chat conversations.</p>', ], ], 'ClientToken' => [ 'base' => NULL, 'refs' => [ 'CreateContactFlowModuleRequest$ClientToken' => '<p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>', 'CreateInstanceRequest$ClientToken' => '<p>The idempotency token.</p>', 'StartChatContactRequest$ClientToken' => '<p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>', 'StartContactStreamingRequest$ClientToken' => '<p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>', 'StartOutboundVoiceContactRequest$ClientToken' => '<p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. The token is valid for 7 days after creation. If a contact is already started, the contact ID is returned. </p>', 'StartTaskContactRequest$ClientToken' => '<p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>', ], ], 'CommonNameLength127' => [ 'base' => NULL, 'refs' => [ 'CreateHoursOfOperationRequest$Name' => '<p>The name of the hours of operation.</p>', 'CreateQueueRequest$Name' => '<p>The name of the queue.</p>', 'HoursOfOperation$Name' => '<p>The name for the hours of operation.</p>', 'Queue$Name' => '<p>The name of the queue.</p>', 'UpdateHoursOfOperationRequest$Name' => '<p>The name of the hours of operation.</p>', 'UpdateQueueNameRequest$Name' => '<p>The name of the queue.</p>', ], ], 'Comparison' => [ 'base' => NULL, 'refs' => [ 'Threshold$Comparison' => '<p>The type of comparison. Only "less than" (LT) comparisons are supported.</p>', ], ], 'Concurrency' => [ 'base' => NULL, 'refs' => [ 'MediaConcurrency$Concurrency' => '<p>The number of contacts an agent can have on a channel simultaneously.</p> <p>Valid Range for <code>VOICE</code>: Minimum value of 1. Maximum value of 1.</p> <p>Valid Range for <code>CHAT</code>: Minimum value of 1. Maximum value of 10.</p> <p>Valid Range for <code>TASK</code>: Minimum value of 1. Maximum value of 10.</p>', ], ], 'Contact' => [ 'base' => '<p>Contains information about a contact.</p>', 'refs' => [ 'DescribeContactResponse$Contact' => '<p>Information about the contact.</p>', ], ], 'ContactFlow' => [ 'base' => '<p>Contains information about a contact flow.</p>', 'refs' => [ 'DescribeContactFlowResponse$ContactFlow' => '<p>Information about the contact flow.</p>', ], ], 'ContactFlowContent' => [ 'base' => NULL, 'refs' => [ 'ContactFlow$Content' => '<p>The content of the contact flow.</p>', 'CreateContactFlowRequest$Content' => '<p>The content of the contact flow. </p>', 'UpdateContactFlowContentRequest$Content' => '<p>The JSON string that represents contact flow’s content. For an example, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/flow-language-example.html">Example contact flow in Amazon Connect Flow language</a> in the <i>Amazon Connect Administrator Guide</i>. </p>', ], ], 'ContactFlowDescription' => [ 'base' => NULL, 'refs' => [ 'ContactFlow$Description' => '<p>The description of the contact flow.</p>', 'CreateContactFlowRequest$Description' => '<p>The description of the contact flow. </p>', 'UpdateContactFlowMetadataRequest$Description' => '<p>The description of the contact flow.</p>', 'UpdateContactFlowNameRequest$Description' => '<p>The description of the contact flow.</p>', ], ], 'ContactFlowId' => [ 'base' => NULL, 'refs' => [ 'ContactFlow$Id' => '<p>The identifier of the contact flow.</p>', 'ContactFlowSummary$Id' => '<p>The identifier of the contact flow.</p>', 'CreateContactFlowResponse$ContactFlowId' => '<p>The identifier of the contact flow.</p>', 'DeleteContactFlowRequest$ContactFlowId' => '<p>The identifier of the contact flow.</p>', 'DescribeContactFlowRequest$ContactFlowId' => '<p>The identifier of the contact flow.</p>', 'OutboundCallerConfig$OutboundFlowId' => '<p>The outbound whisper flow to be used during an outbound call.</p>', 'QueueQuickConnectConfig$ContactFlowId' => '<p>The identifier of the contact flow.</p>', 'StartChatContactRequest$ContactFlowId' => '<p>The identifier of the contact flow for initiating the chat. To see the ContactFlowId in the Amazon Connect console user interface, on the navigation menu go to <b>Routing</b>, <b>Contact Flows</b>. Choose the contact flow. On the contact flow page, under the name of the contact flow, choose <b>Show additional flow information</b>. The ContactFlowId is the last part of the ARN, shown here in bold: </p> <p>arn:aws:connect:us-west-2:xxxxxxxxxxxx:instance/xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx/contact-flow/<b>846ec553-a005-41c0-8341-xxxxxxxxxxxx</b> </p>', 'StartOutboundVoiceContactRequest$ContactFlowId' => '<p>The identifier of the contact flow for the outbound call. To see the ContactFlowId in the Amazon Connect console user interface, on the navigation menu go to <b>Routing</b>, <b>Contact Flows</b>. Choose the contact flow. On the contact flow page, under the name of the contact flow, choose <b>Show additional flow information</b>. The ContactFlowId is the last part of the ARN, shown here in bold: </p> <p>arn:aws:connect:us-west-2:xxxxxxxxxxxx:instance/xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx/contact-flow/<b>846ec553-a005-41c0-8341-xxxxxxxxxxxx</b> </p>', 'StartTaskContactRequest$ContactFlowId' => '<p>The identifier of the contact flow for initiating the tasks. To see the ContactFlowId in the Amazon Connect console user interface, on the navigation menu go to <b>Routing</b>, <b>Contact Flows</b>. Choose the contact flow. On the contact flow page, under the name of the contact flow, choose <b>Show additional flow information</b>. The ContactFlowId is the last part of the ARN, shown here in bold: </p> <p>arn:aws:connect:us-west-2:xxxxxxxxxxxx:instance/xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx/contact-flow/<b>846ec553-a005-41c0-8341-xxxxxxxxxxxx</b> </p>', 'UpdateContactFlowContentRequest$ContactFlowId' => '<p>The identifier of the contact flow.</p>', 'UpdateContactFlowMetadataRequest$ContactFlowId' => '<p>The identifier of the contact flow.</p>', 'UpdateContactFlowNameRequest$ContactFlowId' => '<p>The identifier of the contact flow.</p>', 'UserQuickConnectConfig$ContactFlowId' => '<p>The identifier of the contact flow.</p>', ], ], 'ContactFlowModule' => [ 'base' => '<p>Contains information about a contact flow module.</p>', 'refs' => [ 'DescribeContactFlowModuleResponse$ContactFlowModule' => '<p>Information about the contact flow module.</p>', ], ], 'ContactFlowModuleContent' => [ 'base' => NULL, 'refs' => [ 'ContactFlowModule$Content' => '<p>The content of the contact flow module.</p>', 'CreateContactFlowModuleRequest$Content' => '<p>The content of the contact flow module.</p>', 'UpdateContactFlowModuleContentRequest$Content' => '<p>The content of the contact flow module.</p>', ], ], 'ContactFlowModuleDescription' => [ 'base' => NULL, 'refs' => [ 'ContactFlowModule$Description' => '<p>The description of the contact flow module.</p>', 'CreateContactFlowModuleRequest$Description' => '<p>The description of the contact flow module. </p>', 'UpdateContactFlowModuleMetadataRequest$Description' => '<p>The description of the contact flow module.</p>', ], ], 'ContactFlowModuleId' => [ 'base' => NULL, 'refs' => [ 'ContactFlowModule$Id' => '<p>The identifier of the contact flow module.</p>', 'ContactFlowModuleSummary$Id' => '<p>The identifier of the contact flow module.</p>', 'CreateContactFlowModuleResponse$Id' => '<p>The identifier of the contact flow module.</p>', 'DeleteContactFlowModuleRequest$ContactFlowModuleId' => '<p>The identifier of the contact flow module.</p>', 'DescribeContactFlowModuleRequest$ContactFlowModuleId' => '<p>The identifier of the contact flow module.</p>', 'UpdateContactFlowModuleContentRequest$ContactFlowModuleId' => '<p>The identifier of the contact flow module.</p>', 'UpdateContactFlowModuleMetadataRequest$ContactFlowModuleId' => '<p>The identifier of the contact flow module.</p>', ], ], 'ContactFlowModuleName' => [ 'base' => NULL, 'refs' => [ 'ContactFlowModule$Name' => '<p>The name of the contact flow module.</p>', 'ContactFlowModuleSummary$Name' => '<p>The name of the contact flow module.</p>', 'CreateContactFlowModuleRequest$Name' => '<p>The name of the contact flow module.</p>', 'UpdateContactFlowModuleMetadataRequest$Name' => '<p>The name of the contact flow module.</p>', ], ], 'ContactFlowModuleState' => [ 'base' => NULL, 'refs' => [ 'ContactFlowModule$State' => '<p>The type of contact flow module.</p>', 'ContactFlowModuleSummary$State' => '<p>The type of contact flow module.</p>', 'ListContactFlowModulesRequest$ContactFlowModuleState' => '<p>The state of the contact flow module.</p>', 'UpdateContactFlowModuleMetadataRequest$State' => '<p>The state of contact flow module.</p>', ], ], 'ContactFlowModuleStatus' => [ 'base' => NULL, 'refs' => [ 'ContactFlowModule$Status' => '<p>The status of the contact flow module.</p>', ], ], 'ContactFlowModuleSummary' => [ 'base' => '<p>Contains summary information about a contact flow.</p>', 'refs' => [ 'ContactFlowModulesSummaryList$member' => NULL, ], ], 'ContactFlowModulesSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListContactFlowModulesResponse$ContactFlowModulesSummaryList' => '<p>Information about the contact flow module.</p>', ], ], 'ContactFlowName' => [ 'base' => NULL, 'refs' => [ 'ContactFlow$Name' => '<p>The name of the contact flow.</p>', 'ContactFlowSummary$Name' => '<p>The name of the contact flow.</p>', 'CreateContactFlowRequest$Name' => '<p>The name of the contact flow.</p>', 'UpdateContactFlowMetadataRequest$Name' => '<p>TThe name of the contact flow.</p>', 'UpdateContactFlowNameRequest$Name' => '<p>The name of the contact flow.</p>', ], ], 'ContactFlowNotPublishedException' => [ 'base' => '<p>The contact flow has not been published.</p>', 'refs' => [], ], 'ContactFlowState' => [ 'base' => NULL, 'refs' => [ 'ContactFlow$State' => '<p>The type of contact flow.</p>', 'ContactFlowSummary$ContactFlowState' => '<p>The type of contact flow.</p>', 'UpdateContactFlowMetadataRequest$ContactFlowState' => '<p>The state of contact flow.</p>', ], ], 'ContactFlowSummary' => [ 'base' => '<p>Contains summary information about a contact flow.</p> <p>You can also create and update contact flows using the <a href="https://docs.aws.amazon.com/connect/latest/adminguide/flow-language.html">Amazon Connect Flow language</a>.</p>', 'refs' => [ 'ContactFlowSummaryList$member' => NULL, ], ], 'ContactFlowSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListContactFlowsResponse$ContactFlowSummaryList' => '<p>Information about the contact flows.</p>', ], ], 'ContactFlowType' => [ 'base' => NULL, 'refs' => [ 'ContactFlow$Type' => '<p>The type of the contact flow. For descriptions of the available types, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/create-contact-flow.html#contact-flow-types">Choose a Contact Flow Type</a> in the <i>Amazon Connect Administrator Guide</i>.</p>', 'ContactFlowSummary$ContactFlowType' => '<p>The type of contact flow.</p>', 'ContactFlowTypes$member' => NULL, 'CreateContactFlowRequest$Type' => '<p>The type of the contact flow. For descriptions of the available types, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/create-contact-flow.html#contact-flow-types">Choose a Contact Flow Type</a> in the <i>Amazon Connect Administrator Guide</i>.</p>', ], ], 'ContactFlowTypes' => [ 'base' => NULL, 'refs' => [ 'ListContactFlowsRequest$ContactFlowTypes' => '<p>The type of contact flow.</p>', ], ], 'ContactId' => [ 'base' => NULL, 'refs' => [ 'Contact$Id' => '<p>The identifier for the contact.</p>', 'Contact$InitialContactId' => '<p>If this contact is related to other contacts, this is the ID of the initial contact.</p>', 'Contact$PreviousContactId' => '<p>If this contact is not the first contact, this is the ID of the previous contact.</p>', 'DescribeContactRequest$ContactId' => '<p>The identifier of the contact.</p>', 'GetContactAttributesRequest$InitialContactId' => '<p>The identifier of the initial contact.</p>', 'ListContactReferencesRequest$ContactId' => '<p>The identifier of the initial contact.</p>', 'ResumeContactRecordingRequest$ContactId' => '<p>The identifier of the contact.</p>', 'ResumeContactRecordingRequest$InitialContactId' => '<p>The identifier of the contact. This is the identifier of the contact associated with the first interaction with the contact center.</p>', 'StartChatContactResponse$ContactId' => '<p>The identifier of this contact within the Amazon Connect instance. </p>', 'StartContactRecordingRequest$ContactId' => '<p>The identifier of the contact.</p>', 'StartContactRecordingRequest$InitialContactId' => '<p>The identifier of the contact. This is the identifier of the contact associated with the first interaction with the contact center.</p>', 'StartContactStreamingRequest$ContactId' => '<p>The identifier of the contact. This is the identifier of the contact associated with the first interaction with the contact center.</p>', 'StartOutboundVoiceContactResponse$ContactId' => '<p>The identifier of this contact within the Amazon Connect instance.</p>', 'StartTaskContactRequest$PreviousContactId' => '<p>The identifier of the previous chat, voice, or task contact. </p>', 'StartTaskContactResponse$ContactId' => '<p>The identifier of this contact within the Amazon Connect instance.</p>', 'StopContactRecordingRequest$ContactId' => '<p>The identifier of the contact.</p>', 'StopContactRecordingRequest$InitialContactId' => '<p>The identifier of the contact. This is the identifier of the contact associated with the first interaction with the contact center.</p>', 'StopContactRequest$ContactId' => '<p>The ID of the contact.</p>', 'StopContactStreamingRequest$ContactId' => '<p>The identifier of the contact. This is the identifier of the contact that is associated with the first interaction with the contact center.</p>', 'SuspendContactRecordingRequest$ContactId' => '<p>The identifier of the contact.</p>', 'SuspendContactRecordingRequest$InitialContactId' => '<p>The identifier of the contact. This is the identifier of the contact associated with the first interaction with the contact center.</p>', 'UpdateContactAttributesRequest$InitialContactId' => '<p>The identifier of the contact. This is the identifier of the contact associated with the first interaction with the contact center.</p>', 'UpdateContactRequest$ContactId' => '<p>The identifier of the contact. This is the identifier of the contact associated with the first interaction with your contact center.</p>', 'UpdateContactScheduleRequest$ContactId' => '<p>The identifier of the contact.</p>', ], ], 'ContactInitiationMethod' => [ 'base' => NULL, 'refs' => [ 'Contact$InitiationMethod' => '<p>Indicates how the contact was initiated.</p>', ], ], 'ContactNotFoundException' => [ 'base' => '<p>The contact with the specified ID is not active or does not exist.</p>', 'refs' => [], ], 'ContactReferences' => [ 'base' => NULL, 'refs' => [ 'StartTaskContactRequest$References' => '<p>A formatted URL that is shown to an agent in the Contact Control Panel (CCP).</p>', 'UpdateContactRequest$References' => '<p>A formatted URL that is shown to an agent in the Contact Control Panel (CCP).</p>', ], ], 'CreateAgentStatusRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateAgentStatusResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateContactFlowModuleRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateContactFlowModuleResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateContactFlowRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateContactFlowResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateHoursOfOperationRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateHoursOfOperationResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateInstanceRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateInstanceResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateIntegrationAssociationRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateIntegrationAssociationResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateQueueRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateQueueResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateQuickConnectRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateQuickConnectResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateRoutingProfileRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateRoutingProfileResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateSecurityProfileRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateSecurityProfileResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateUseCaseRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateUseCaseResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateUserHierarchyGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateUserHierarchyGroupResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateUserRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateUserResponse' => [ 'base' => NULL, 'refs' => [], ], 'Credentials' => [ 'base' => '<p>Contains credentials to use for federation.</p>', 'refs' => [ 'GetFederationTokenResponse$Credentials' => '<p>The credentials to use for federation.</p>', ], ], 'CurrentMetric' => [ 'base' => '<p>Contains information about a real-time metric. For a description of each metric, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html">Real-time Metrics Definitions</a> in the <i>Amazon Connect Administrator Guide</i>.</p>', 'refs' => [ 'CurrentMetricData$Metric' => '<p>Information about the metric.</p>', 'CurrentMetrics$member' => NULL, ], ], 'CurrentMetricData' => [ 'base' => '<p>Contains the data for a real-time metric.</p>', 'refs' => [ 'CurrentMetricDataCollections$member' => NULL, ], ], 'CurrentMetricDataCollections' => [ 'base' => NULL, 'refs' => [ 'CurrentMetricResult$Collections' => '<p>The set of metrics.</p>', ], ], 'CurrentMetricName' => [ 'base' => '<p>The current metric names.</p>', 'refs' => [ 'CurrentMetric$Name' => '<p>The name of the metric.</p>', ], ], 'CurrentMetricResult' => [ 'base' => '<p>Contains information about a set of real-time metrics.</p>', 'refs' => [ 'CurrentMetricResults$member' => NULL, ], ], 'CurrentMetricResults' => [ 'base' => NULL, 'refs' => [ 'GetCurrentMetricDataResponse$MetricResults' => '<p>Information about the real-time metrics.</p>', ], ], 'CurrentMetrics' => [ 'base' => NULL, 'refs' => [ 'GetCurrentMetricDataRequest$CurrentMetrics' => '<p>The metrics to retrieve. Specify the name and unit for each metric. The following metrics are available. For a description of all the metrics, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html">Real-time Metrics Definitions</a> in the <i>Amazon Connect Administrator Guide</i>.</p> <dl> <dt>AGENTS_AFTER_CONTACT_WORK</dt> <dd> <p>Unit: COUNT</p> <p>Name in real-time metrics report: <a href="https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#aftercallwork-real-time">ACW</a> </p> </dd> <dt>AGENTS_AVAILABLE</dt> <dd> <p>Unit: COUNT</p> <p>Name in real-time metrics report: <a href="https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#available-real-time">Available</a> </p> </dd> <dt>AGENTS_ERROR</dt> <dd> <p>Unit: COUNT</p> <p>Name in real-time metrics report: <a href="https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#error-real-time">Error</a> </p> </dd> <dt>AGENTS_NON_PRODUCTIVE</dt> <dd> <p>Unit: COUNT</p> <p>Name in real-time metrics report: <a href="https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#non-productive-time-real-time">NPT (Non-Productive Time)</a> </p> </dd> <dt>AGENTS_ON_CALL</dt> <dd> <p>Unit: COUNT</p> <p>Name in real-time metrics report: <a href="https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#on-call-real-time">On contact</a> </p> </dd> <dt>AGENTS_ON_CONTACT</dt> <dd> <p>Unit: COUNT</p> <p>Name in real-time metrics report: <a href="https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#on-call-real-time">On contact</a> </p> </dd> <dt>AGENTS_ONLINE</dt> <dd> <p>Unit: COUNT</p> <p>Name in real-time metrics report: <a href="https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#online-real-time">Online</a> </p> </dd> <dt>AGENTS_STAFFED</dt> <dd> <p>Unit: COUNT</p> <p>Name in real-time metrics report: <a href="https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#staffed-real-time">Staffed</a> </p> </dd> <dt>CONTACTS_IN_QUEUE</dt> <dd> <p>Unit: COUNT</p> <p>Name in real-time metrics report: <a href="https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#in-queue-real-time">In queue</a> </p> </dd> <dt>CONTACTS_SCHEDULED</dt> <dd> <p>Unit: COUNT</p> <p>Name in real-time metrics report: <a href="https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#scheduled-real-time">Scheduled</a> </p> </dd> <dt>OLDEST_CONTACT_AGE</dt> <dd> <p>Unit: SECONDS</p> <p>When you use groupings, Unit says SECONDS and the Value is returned in SECONDS. </p> <p>When you do not use groupings, Unit says SECONDS but the Value is returned in MILLISECONDS. For example, if you get a response like this:</p> <p> <code>{ "Metric": { "Name": "OLDEST_CONTACT_AGE", "Unit": "SECONDS" }, "Value": 24113.0 </code>}</p> <p>The actual OLDEST_CONTACT_AGE is 24 seconds.</p> <p>Name in real-time metrics report: <a href="https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#oldest-real-time">Oldest</a> </p> </dd> <dt>SLOTS_ACTIVE</dt> <dd> <p>Unit: COUNT</p> <p>Name in real-time metrics report: <a href="https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#active-real-time">Active</a> </p> </dd> <dt>SLOTS_AVAILABLE</dt> <dd> <p>Unit: COUNT</p> <p>Name in real-time metrics report: <a href="https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#availability-real-time">Availability</a> </p> </dd> </dl>', ], ], 'Delay' => [ 'base' => NULL, 'refs' => [ 'RoutingProfileQueueConfig$Delay' => '<p>The delay, in seconds, a contact should be in the queue before they are routed to an available agent. For more information, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/concepts-routing-profiles-priority.html">Queues: priority and delay</a> in the <i>Amazon Connect Administrator Guide</i>.</p>', 'RoutingProfileQueueConfigSummary$Delay' => '<p>The delay, in seconds, that a contact should be in the queue before they are routed to an available agent. For more information, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/concepts-routing-profiles-priority.html">Queues: priority and delay</a> in the <i>Amazon Connect Administrator Guide</i>.</p>', ], ], 'DeleteContactFlowModuleRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteContactFlowModuleResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteContactFlowRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteHoursOfOperationRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteInstanceRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteIntegrationAssociationRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteQuickConnectRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteSecurityProfileRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteUseCaseRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteUserHierarchyGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteUserRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAgentStatusRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAgentStatusResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeContactFlowModuleRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeContactFlowModuleResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeContactFlowRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeContactFlowResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeContactRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeContactResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeHoursOfOperationRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeHoursOfOperationResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeInstanceAttributeRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeInstanceAttributeResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeInstanceRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeInstanceResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeInstanceStorageConfigRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeInstanceStorageConfigResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeQueueRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeQueueResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeQuickConnectRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeQuickConnectResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeRoutingProfileRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeRoutingProfileResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeSecurityProfileRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeSecurityProfileResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeUserHierarchyGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeUserHierarchyGroupResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeUserHierarchyStructureRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeUserHierarchyStructureResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeUserRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeUserResponse' => [ 'base' => NULL, 'refs' => [], ], 'Description' => [ 'base' => NULL, 'refs' => [ 'Contact$Description' => '<p>The description of the contact.</p>', 'StartTaskContactRequest$Description' => '<p>A description of the task that is shown to an agent in the Contact Control Panel (CCP).</p>', 'UpdateContactRequest$Description' => '<p>The description of the contact.</p>', ], ], 'DestinationNotAllowedException' => [ 'base' => '<p>Outbound calls to the destination number are not allowed.</p>', 'refs' => [], ], 'Dimensions' => [ 'base' => '<p>Contains information about the dimensions for a set of metrics.</p>', 'refs' => [ 'CurrentMetricResult$Dimensions' => '<p>The dimensions for the metrics.</p>', 'HistoricalMetricResult$Dimensions' => '<p>The dimension for the metrics.</p>', ], ], 'DirectoryAlias' => [ 'base' => NULL, 'refs' => [ 'CreateInstanceRequest$InstanceAlias' => '<p>The name for your instance.</p>', 'Instance$InstanceAlias' => '<p>The alias of instance.</p>', 'InstanceSummary$InstanceAlias' => '<p>The alias of the instance.</p>', ], ], 'DirectoryId' => [ 'base' => NULL, 'refs' => [ 'CreateInstanceRequest$DirectoryId' => '<p>The identifier for the directory.</p>', ], ], 'DirectoryType' => [ 'base' => NULL, 'refs' => [ 'CreateInstanceRequest$IdentityManagementType' => '<p>The type of identity management for your Amazon Connect users.</p>', 'Instance$IdentityManagementType' => '<p>The identity management type.</p>', 'InstanceSummary$IdentityManagementType' => '<p>The identity management type of the instance.</p>', ], ], 'DirectoryUserId' => [ 'base' => NULL, 'refs' => [ 'CreateUserRequest$DirectoryUserId' => '<p>The identifier of the user account in the directory used for identity management. If Amazon Connect cannot access the directory, you can specify this identifier to authenticate users. If you include the identifier, we assume that Amazon Connect cannot access the directory. Otherwise, the identity information is used to authenticate users from your directory.</p> <p>This parameter is required if you are using an existing directory for identity management in Amazon Connect when Amazon Connect cannot access your directory to authenticate users. If you are using SAML for identity management and include this parameter, an error is returned.</p>', 'User$DirectoryUserId' => '<p>The identifier of the user account in the directory used for identity management.</p>', ], ], 'DisassociateApprovedOriginRequest' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateBotRequest' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateInstanceStorageConfigRequest' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateLambdaFunctionRequest' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateLexBotRequest' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateQueueQuickConnectsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateRoutingProfileQueuesRequest' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateSecurityKeyRequest' => [ 'base' => NULL, 'refs' => [], ], 'DisplayName' => [ 'base' => NULL, 'refs' => [ 'ParticipantDetails$DisplayName' => '<p>Display name of the participant.</p>', ], ], 'DuplicateResourceException' => [ 'base' => '<p>A resource with the specified name already exists.</p>', 'refs' => [], ], 'Email' => [ 'base' => NULL, 'refs' => [ 'UserIdentityInfo$Email' => '<p>The email address. If you are using SAML for identity management and include this parameter, an error is returned.</p>', ], ], 'EncryptionConfig' => [ 'base' => '<p>The encryption configuration.</p>', 'refs' => [ 'KinesisVideoStreamConfig$EncryptionConfig' => '<p>The encryption configuration.</p>', 'S3Config$EncryptionConfig' => '<p>The Amazon S3 encryption configuration.</p>', ], ], 'EncryptionType' => [ 'base' => NULL, 'refs' => [ 'EncryptionConfig$EncryptionType' => '<p>The type of encryption.</p>', ], ], 'Filters' => [ 'base' => '<p>Contains the filter to apply when retrieving metrics.</p>', 'refs' => [ 'GetCurrentMetricDataRequest$Filters' => '<p>The queues, up to 100, or channels, to use to filter the metrics returned. Metric data is retrieved only for the resources associated with the queues or channels included in the filter. You can include both queue IDs and queue ARNs in the same request. VOICE, CHAT, and TASK channels are supported.</p>', 'GetMetricDataRequest$Filters' => '<p>The queues, up to 100, or channels, to use to filter the metrics returned. Metric data is retrieved only for the resources associated with the queues or channels included in the filter. You can include both queue IDs and queue ARNs in the same request. VOICE, CHAT, and TASK channels are supported.</p> <note> <p>To filter by <code>Queues</code>, enter the queue ID/ARN, not the name of the queue.</p> </note>', ], ], 'FunctionArn' => [ 'base' => NULL, 'refs' => [ 'AssociateLambdaFunctionRequest$FunctionArn' => '<p>The Amazon Resource Name (ARN) for the Lambda function being associated. Maximum number of characters allowed is 140.</p>', 'DisassociateLambdaFunctionRequest$FunctionArn' => '<p>The Amazon Resource Name (ARN) of the Lambda function being disassociated.</p>', 'FunctionArnsList$member' => NULL, ], ], 'FunctionArnsList' => [ 'base' => NULL, 'refs' => [ 'ListLambdaFunctionsResponse$LambdaFunctions' => '<p>The Lambdafunction ARNs associated with the specified instance.</p>', ], ], 'GetContactAttributesRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetContactAttributesResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetCurrentMetricDataRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetCurrentMetricDataResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetFederationTokenRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetFederationTokenResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetMetricDataRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetMetricDataResponse' => [ 'base' => NULL, 'refs' => [], ], 'Grouping' => [ 'base' => NULL, 'refs' => [ 'Groupings$member' => NULL, ], ], 'Groupings' => [ 'base' => NULL, 'refs' => [ 'GetCurrentMetricDataRequest$Groupings' => '<p>The grouping applied to the metrics returned. For example, when grouped by <code>QUEUE</code>, the metrics returned apply to each queue rather than aggregated for all queues. If you group by <code>CHANNEL</code>, you should include a Channels filter. VOICE, CHAT, and TASK channels are supported.</p> <p>If no <code>Grouping</code> is included in the request, a summary of metrics is returned.</p>', 'GetMetricDataRequest$Groupings' => '<p>The grouping applied to the metrics returned. For example, when results are grouped by queue, the metrics returned are grouped by queue. The values returned apply to the metrics for each queue rather than aggregated for all queues.</p> <p>If no grouping is specified, a summary of metrics for all queues is returned.</p>', ], ], 'HierarchyGroup' => [ 'base' => '<p>Contains information about a hierarchy group.</p>', 'refs' => [ 'DescribeUserHierarchyGroupResponse$HierarchyGroup' => '<p>Information about the hierarchy group.</p>', ], ], 'HierarchyGroupId' => [ 'base' => NULL, 'refs' => [ 'CreateUserHierarchyGroupRequest$ParentGroupId' => '<p>The identifier for the parent hierarchy group. The user hierarchy is created at level one if the parent group ID is null.</p>', 'CreateUserHierarchyGroupResponse$HierarchyGroupId' => '<p>The identifier of the hierarchy group.</p>', 'CreateUserRequest$HierarchyGroupId' => '<p>The identifier of the hierarchy group for the user.</p>', 'DeleteUserHierarchyGroupRequest$HierarchyGroupId' => '<p>The identifier of the hierarchy group.</p>', 'DescribeUserHierarchyGroupRequest$HierarchyGroupId' => '<p>The identifier of the hierarchy group.</p>', 'HierarchyGroup$Id' => '<p>The identifier of the hierarchy group.</p>', 'HierarchyGroupSummary$Id' => '<p>The identifier of the hierarchy group.</p>', 'UpdateUserHierarchyGroupNameRequest$HierarchyGroupId' => '<p>The identifier of the hierarchy group.</p>', 'UpdateUserHierarchyRequest$HierarchyGroupId' => '<p>The identifier of the hierarchy group.</p>', 'User$HierarchyGroupId' => '<p>The identifier of the hierarchy group for the user.</p>', ], ], 'HierarchyGroupName' => [ 'base' => NULL, 'refs' => [ 'CreateUserHierarchyGroupRequest$Name' => '<p>The name of the user hierarchy group. Must not be more than 100 characters.</p>', 'HierarchyGroup$Name' => '<p>The name of the hierarchy group.</p>', 'HierarchyGroupSummary$Name' => '<p>The name of the hierarchy group.</p>', 'UpdateUserHierarchyGroupNameRequest$Name' => '<p>The name of the hierarchy group. Must not be more than 100 characters.</p>', ], ], 'HierarchyGroupSummary' => [ 'base' => '<p>Contains summary information about a hierarchy group.</p>', 'refs' => [ 'HierarchyGroupSummaryList$member' => NULL, 'HierarchyPath$LevelOne' => '<p>Information about level one.</p>', 'HierarchyPath$LevelTwo' => '<p>Information about level two.</p>', 'HierarchyPath$LevelThree' => '<p>Information about level three.</p>', 'HierarchyPath$LevelFour' => '<p>Information about level four.</p>', 'HierarchyPath$LevelFive' => '<p>Information about level five.</p>', ], ], 'HierarchyGroupSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListUserHierarchyGroupsResponse$UserHierarchyGroupSummaryList' => '<p>Information about the hierarchy groups.</p>', ], ], 'HierarchyLevel' => [ 'base' => '<p>Contains information about a hierarchy level.</p>', 'refs' => [ 'HierarchyStructure$LevelOne' => '<p>Information about level one.</p>', 'HierarchyStructure$LevelTwo' => '<p>Information about level two.</p>', 'HierarchyStructure$LevelThree' => '<p>Information about level three.</p>', 'HierarchyStructure$LevelFour' => '<p>Information about level four.</p>', 'HierarchyStructure$LevelFive' => '<p>Information about level five.</p>', ], ], 'HierarchyLevelId' => [ 'base' => NULL, 'refs' => [ 'HierarchyGroup$LevelId' => '<p>The identifier of the level in the hierarchy group.</p>', 'HierarchyLevel$Id' => '<p>The identifier of the hierarchy level.</p>', ], ], 'HierarchyLevelName' => [ 'base' => NULL, 'refs' => [ 'HierarchyLevel$Name' => '<p>The name of the hierarchy level.</p>', 'HierarchyLevelUpdate$Name' => '<p>The name of the user hierarchy level. Must not be more than 50 characters.</p>', ], ], 'HierarchyLevelUpdate' => [ 'base' => '<p>Contains information about the hierarchy level to update.</p>', 'refs' => [ 'HierarchyStructureUpdate$LevelOne' => '<p>The update for level one.</p>', 'HierarchyStructureUpdate$LevelTwo' => '<p>The update for level two.</p>', 'HierarchyStructureUpdate$LevelThree' => '<p>The update for level three.</p>', 'HierarchyStructureUpdate$LevelFour' => '<p>The update for level four.</p>', 'HierarchyStructureUpdate$LevelFive' => '<p>The update for level five.</p>', ], ], 'HierarchyPath' => [ 'base' => '<p>Contains information about the levels of a hierarchy group.</p>', 'refs' => [ 'HierarchyGroup$HierarchyPath' => '<p>Information about the levels in the hierarchy group.</p>', ], ], 'HierarchyStructure' => [ 'base' => '<p>Contains information about a hierarchy structure.</p>', 'refs' => [ 'DescribeUserHierarchyStructureResponse$HierarchyStructure' => '<p>Information about the hierarchy structure.</p>', ], ], 'HierarchyStructureUpdate' => [ 'base' => '<p>Contains information about the level hierarchy to update.</p>', 'refs' => [ 'UpdateUserHierarchyStructureRequest$HierarchyStructure' => '<p>The hierarchy levels to update.</p>', ], ], 'HistoricalMetric' => [ 'base' => '<p>Contains information about a historical metric. For a description of each metric, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html">Historical Metrics Definitions</a> in the <i>Amazon Connect Administrator Guide</i>.</p>', 'refs' => [ 'HistoricalMetricData$Metric' => '<p>Information about the metric.</p>', 'HistoricalMetrics$member' => NULL, ], ], 'HistoricalMetricData' => [ 'base' => '<p>Contains the data for a historical metric.</p>', 'refs' => [ 'HistoricalMetricDataCollections$member' => NULL, ], ], 'HistoricalMetricDataCollections' => [ 'base' => NULL, 'refs' => [ 'HistoricalMetricResult$Collections' => '<p>The set of metrics.</p>', ], ], 'HistoricalMetricName' => [ 'base' => '<p>The historical metric names.</p>', 'refs' => [ 'HistoricalMetric$Name' => '<p>The name of the metric.</p>', ], ], 'HistoricalMetricResult' => [ 'base' => '<p>Contains information about the historical metrics retrieved.</p>', 'refs' => [ 'HistoricalMetricResults$member' => NULL, ], ], 'HistoricalMetricResults' => [ 'base' => NULL, 'refs' => [ 'GetMetricDataResponse$MetricResults' => '<p>Information about the historical metrics.</p> <p>If no grouping is specified, a summary of metric data is returned.</p>', ], ], 'HistoricalMetrics' => [ 'base' => NULL, 'refs' => [ 'GetMetricDataRequest$HistoricalMetrics' => '<p>The metrics to retrieve. Specify the name, unit, and statistic for each metric. The following historical metrics are available. For a description of each metric, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html">Historical Metrics Definitions</a> in the <i>Amazon Connect Administrator Guide</i>.</p> <note> <p>This API does not support a contacts incoming metric (there\'s no CONTACTS_INCOMING metric missing from the documented list). </p> </note> <dl> <dt>ABANDON_TIME</dt> <dd> <p>Unit: SECONDS</p> <p>Statistic: AVG</p> </dd> <dt>AFTER_CONTACT_WORK_TIME</dt> <dd> <p>Unit: SECONDS</p> <p>Statistic: AVG</p> </dd> <dt>API_CONTACTS_HANDLED</dt> <dd> <p>Unit: COUNT</p> <p>Statistic: SUM</p> </dd> <dt>CALLBACK_CONTACTS_HANDLED</dt> <dd> <p>Unit: COUNT</p> <p>Statistic: SUM</p> </dd> <dt>CONTACTS_ABANDONED</dt> <dd> <p>Unit: COUNT</p> <p>Statistic: SUM</p> </dd> <dt>CONTACTS_AGENT_HUNG_UP_FIRST</dt> <dd> <p>Unit: COUNT</p> <p>Statistic: SUM</p> </dd> <dt>CONTACTS_CONSULTED</dt> <dd> <p>Unit: COUNT</p> <p>Statistic: SUM</p> </dd> <dt>CONTACTS_HANDLED</dt> <dd> <p>Unit: COUNT</p> <p>Statistic: SUM</p> </dd> <dt>CONTACTS_HANDLED_INCOMING</dt> <dd> <p>Unit: COUNT</p> <p>Statistic: SUM</p> </dd> <dt>CONTACTS_HANDLED_OUTBOUND</dt> <dd> <p>Unit: COUNT</p> <p>Statistic: SUM</p> </dd> <dt>CONTACTS_HOLD_ABANDONS</dt> <dd> <p>Unit: COUNT</p> <p>Statistic: SUM</p> </dd> <dt>CONTACTS_MISSED</dt> <dd> <p>Unit: COUNT</p> <p>Statistic: SUM</p> </dd> <dt>CONTACTS_QUEUED</dt> <dd> <p>Unit: COUNT</p> <p>Statistic: SUM</p> </dd> <dt>CONTACTS_TRANSFERRED_IN</dt> <dd> <p>Unit: COUNT</p> <p>Statistic: SUM</p> </dd> <dt>CONTACTS_TRANSFERRED_IN_FROM_QUEUE</dt> <dd> <p>Unit: COUNT</p> <p>Statistic: SUM</p> </dd> <dt>CONTACTS_TRANSFERRED_OUT</dt> <dd> <p>Unit: COUNT</p> <p>Statistic: SUM</p> </dd> <dt>CONTACTS_TRANSFERRED_OUT_FROM_QUEUE</dt> <dd> <p>Unit: COUNT</p> <p>Statistic: SUM</p> </dd> <dt>HANDLE_TIME</dt> <dd> <p>Unit: SECONDS</p> <p>Statistic: AVG</p> </dd> <dt>HOLD_TIME</dt> <dd> <p>Unit: SECONDS</p> <p>Statistic: AVG</p> </dd> <dt>INTERACTION_AND_HOLD_TIME</dt> <dd> <p>Unit: SECONDS</p> <p>Statistic: AVG</p> </dd> <dt>INTERACTION_TIME</dt> <dd> <p>Unit: SECONDS</p> <p>Statistic: AVG</p> </dd> <dt>OCCUPANCY</dt> <dd> <p>Unit: PERCENT</p> <p>Statistic: AVG</p> </dd> <dt>QUEUE_ANSWER_TIME</dt> <dd> <p>Unit: SECONDS</p> <p>Statistic: AVG</p> </dd> <dt>QUEUED_TIME</dt> <dd> <p>Unit: SECONDS</p> <p>Statistic: MAX</p> </dd> <dt>SERVICE_LEVEL</dt> <dd> <p>You can include up to 20 SERVICE_LEVEL metrics in a request.</p> <p>Unit: PERCENT</p> <p>Statistic: AVG</p> <p>Threshold: For <code>ThresholdValue</code>, enter any whole number from 1 to 604800 (inclusive), in seconds. For <code>Comparison</code>, you must enter <code>LT</code> (for "Less than"). </p> </dd> </dl>', ], ], 'Hours' => [ 'base' => NULL, 'refs' => [ 'KinesisVideoStreamConfig$RetentionPeriodHours' => '<p>The number of hours data is retained in the stream. Kinesis Video Streams retains the data in a data store that is associated with the stream.</p> <p>The default value is 0, indicating that the stream does not persist data.</p>', ], ], 'Hours24Format' => [ 'base' => NULL, 'refs' => [ 'HoursOfOperationTimeSlice$Hours' => '<p>The hours.</p>', ], ], 'HoursOfOperation' => [ 'base' => '<p>Information about of the hours of operation.</p>', 'refs' => [ 'DescribeHoursOfOperationResponse$HoursOfOperation' => '<p>The hours of operation.</p>', ], ], 'HoursOfOperationConfig' => [ 'base' => '<p>Contains information about the hours of operation.</p>', 'refs' => [ 'HoursOfOperationConfigList$member' => NULL, ], ], 'HoursOfOperationConfigList' => [ 'base' => NULL, 'refs' => [ 'CreateHoursOfOperationRequest$Config' => '<p>Configuration information for the hours of operation: day, start time, and end time.</p>', 'HoursOfOperation$Config' => '<p>Configuration information for the hours of operation.</p>', 'UpdateHoursOfOperationRequest$Config' => '<p>Configuration information of the hours of operation.</p>', ], ], 'HoursOfOperationDays' => [ 'base' => NULL, 'refs' => [ 'HoursOfOperationConfig$Day' => '<p>The day that the hours of operation applies to.</p>', ], ], 'HoursOfOperationDescription' => [ 'base' => NULL, 'refs' => [ 'CreateHoursOfOperationRequest$Description' => '<p>The description of the hours of operation.</p>', 'HoursOfOperation$Description' => '<p>The description for the hours of operation.</p>', ], ], 'HoursOfOperationId' => [ 'base' => NULL, 'refs' => [ 'CreateHoursOfOperationResponse$HoursOfOperationId' => '<p>The identifier for the hours of operation.</p>', 'CreateQueueRequest$HoursOfOperationId' => '<p>The identifier for the hours of operation.</p>', 'DeleteHoursOfOperationRequest$HoursOfOperationId' => '<p>The identifier for the hours of operation.</p>', 'DescribeHoursOfOperationRequest$HoursOfOperationId' => '<p>The identifier for the hours of operation.</p>', 'HoursOfOperation$HoursOfOperationId' => '<p>The identifier for the hours of operation.</p>', 'HoursOfOperationSummary$Id' => '<p>The identifier of the hours of operation.</p>', 'Queue$HoursOfOperationId' => '<p>The identifier for the hours of operation.</p>', 'UpdateHoursOfOperationRequest$HoursOfOperationId' => '<p>The identifier of the hours of operation.</p>', 'UpdateQueueHoursOfOperationRequest$HoursOfOperationId' => '<p>The identifier for the hours of operation.</p>', ], ], 'HoursOfOperationName' => [ 'base' => NULL, 'refs' => [ 'HoursOfOperationSummary$Name' => '<p>The name of the hours of operation.</p>', ], ], 'HoursOfOperationSummary' => [ 'base' => '<p>Contains summary information about hours of operation for a contact center.</p>', 'refs' => [ 'HoursOfOperationSummaryList$member' => NULL, ], ], 'HoursOfOperationSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListHoursOfOperationsResponse$HoursOfOperationSummaryList' => '<p>Information about the hours of operation.</p>', ], ], 'HoursOfOperationTimeSlice' => [ 'base' => '<p>The start time or end time for an hours of operation.</p>', 'refs' => [ 'HoursOfOperationConfig$StartTime' => '<p>The start time that your contact center opens.</p>', 'HoursOfOperationConfig$EndTime' => '<p>The end time that your contact center closes.</p>', ], ], 'IdempotencyException' => [ 'base' => '<p>An entity with the same name already exists.</p>', 'refs' => [], ], 'InboundCallsEnabled' => [ 'base' => NULL, 'refs' => [ 'CreateInstanceRequest$InboundCallsEnabled' => '<p>Your contact center handles incoming contacts.</p>', 'Instance$InboundCallsEnabled' => '<p>Whether inbound calls are enabled.</p>', 'InstanceSummary$InboundCallsEnabled' => '<p>Whether inbound calls are enabled.</p>', ], ], 'Instance' => [ 'base' => '<p>The Amazon Connect instance.</p>', 'refs' => [ 'DescribeInstanceResponse$Instance' => '<p>The name of the instance.</p>', ], ], 'InstanceAttributeType' => [ 'base' => NULL, 'refs' => [ 'Attribute$AttributeType' => '<p>The type of attribute.</p>', 'DescribeInstanceAttributeRequest$AttributeType' => '<p>The type of attribute.</p>', 'UpdateInstanceAttributeRequest$AttributeType' => '<p>The type of attribute.</p> <note> <p>Only allowlisted customers can consume USE_CUSTOM_TTS_VOICES. To access this feature, contact AWS Support for allowlisting.</p> </note>', ], ], 'InstanceAttributeValue' => [ 'base' => NULL, 'refs' => [ 'Attribute$Value' => '<p>The value of the attribute.</p>', 'UpdateInstanceAttributeRequest$Value' => '<p>The value for the attribute. Maximum character limit is 100. </p>', ], ], 'InstanceId' => [ 'base' => NULL, 'refs' => [ 'AssociateApprovedOriginRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>', 'AssociateBotRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>', 'AssociateInstanceStorageConfigRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>', 'AssociateLambdaFunctionRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>', 'AssociateLexBotRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>', 'AssociateQueueQuickConnectsRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>', 'AssociateRoutingProfileQueuesRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>', 'AssociateSecurityKeyRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>', 'CreateAgentStatusRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>', 'CreateContactFlowModuleRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>', 'CreateContactFlowRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance.</p>', 'CreateHoursOfOperationRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>', 'CreateInstanceResponse$Id' => '<p>The identifier for the instance.</p>', 'CreateIntegrationAssociationRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>', 'CreateQueueRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>', 'CreateQuickConnectRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>', 'CreateRoutingProfileRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>', 'CreateSecurityProfileRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>', 'CreateUseCaseRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>', 'CreateUserHierarchyGroupRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>', 'CreateUserRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>', 'DeleteContactFlowModuleRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>', 'DeleteContactFlowRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>', 'DeleteHoursOfOperationRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>', 'DeleteInstanceRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>', 'DeleteIntegrationAssociationRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>', 'DeleteQuickConnectRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>', 'DeleteSecurityProfileRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>', 'DeleteUseCaseRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>', 'DeleteUserHierarchyGroupRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>', 'DeleteUserRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>', 'DescribeAgentStatusRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>', 'DescribeContactFlowModuleRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>', 'DescribeContactFlowRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance.</p>', 'DescribeContactRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>', 'DescribeHoursOfOperationRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>', 'DescribeInstanceAttributeRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>', 'DescribeInstanceRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>', 'DescribeInstanceStorageConfigRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>', 'DescribeQueueRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>', 'DescribeQuickConnectRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>', 'DescribeRoutingProfileRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>', 'DescribeSecurityProfileRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>', 'DescribeUserHierarchyGroupRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>', 'DescribeUserHierarchyStructureRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>', 'DescribeUserRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>', 'DisassociateApprovedOriginRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>', 'DisassociateBotRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>', 'DisassociateInstanceStorageConfigRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>', 'DisassociateLambdaFunctionRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance..</p>', 'DisassociateLexBotRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>', 'DisassociateQueueQuickConnectsRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>', 'DisassociateRoutingProfileQueuesRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>', 'DisassociateSecurityKeyRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>', 'GetContactAttributesRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance.</p>', 'GetCurrentMetricDataRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>', 'GetFederationTokenRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>', 'GetMetricDataRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>', 'Instance$Id' => '<p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>', 'InstanceSummary$Id' => '<p>The identifier of the instance.</p>', 'IntegrationAssociationSummary$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>', 'ListAgentStatusRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>', 'ListApprovedOriginsRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>', 'ListBotsRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>', 'ListContactFlowModulesRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>', 'ListContactFlowsRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>', 'ListContactReferencesRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>', 'ListHoursOfOperationsRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>', 'ListInstanceAttributesRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>', 'ListInstanceStorageConfigsRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>', 'ListIntegrationAssociationsRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>', 'ListLambdaFunctionsRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>', 'ListLexBotsRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>', 'ListPhoneNumbersRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>', 'ListPromptsRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance.</p>', 'ListQueueQuickConnectsRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>', 'ListQueuesRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>', 'ListQuickConnectsRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>', 'ListRoutingProfileQueuesRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>', 'ListRoutingProfilesRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>', 'ListSecurityKeysRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>', 'ListSecurityProfilePermissionsRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>', 'ListSecurityProfilesRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>', 'ListUseCasesRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>', 'ListUserHierarchyGroupsRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>', 'ListUsersRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>', 'ResumeContactRecordingRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>', 'RoutingProfile$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>', 'SecurityProfile$OrganizationResourceId' => '<p>The organization resource identifier for the security profile.</p>', 'StartChatContactRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>', 'StartContactRecordingRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>', 'StartContactStreamingRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>', 'StartOutboundVoiceContactRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>', 'StartTaskContactRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>', 'StopContactRecordingRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>', 'StopContactRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>', 'StopContactStreamingRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>', 'SuspendContactRecordingRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>', 'UpdateAgentStatusRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>', 'UpdateContactAttributesRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>', 'UpdateContactFlowContentRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance.</p>', 'UpdateContactFlowMetadataRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>', 'UpdateContactFlowModuleContentRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>', 'UpdateContactFlowModuleMetadataRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>', 'UpdateContactFlowNameRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance.</p>', 'UpdateContactRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>', 'UpdateContactScheduleRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>', 'UpdateHoursOfOperationRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>', 'UpdateInstanceAttributeRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>', 'UpdateInstanceStorageConfigRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>', 'UpdateQueueHoursOfOperationRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>', 'UpdateQueueMaxContactsRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>', 'UpdateQueueNameRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>', 'UpdateQueueOutboundCallerConfigRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>', 'UpdateQueueStatusRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>', 'UpdateQuickConnectConfigRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>', 'UpdateQuickConnectNameRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>', 'UpdateRoutingProfileConcurrencyRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>', 'UpdateRoutingProfileDefaultOutboundQueueRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>', 'UpdateRoutingProfileNameRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>', 'UpdateRoutingProfileQueuesRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>', 'UpdateSecurityProfileRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>', 'UpdateUserHierarchyGroupNameRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>', 'UpdateUserHierarchyRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>', 'UpdateUserHierarchyStructureRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>', 'UpdateUserIdentityInfoRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>', 'UpdateUserPhoneConfigRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>', 'UpdateUserRoutingProfileRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>', 'UpdateUserSecurityProfilesRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>', ], ], 'InstanceStatus' => [ 'base' => NULL, 'refs' => [ 'Instance$InstanceStatus' => '<p>The state of the instance.</p>', 'InstanceSummary$InstanceStatus' => '<p>The state of the instance.</p>', ], ], 'InstanceStatusReason' => [ 'base' => '<p>Relevant details why the instance was not successfully created.</p>', 'refs' => [ 'Instance$StatusReason' => '<p>Relevant details why the instance was not successfully created. </p>', ], ], 'InstanceStorageConfig' => [ 'base' => '<p>The storage configuration for the instance.</p>', 'refs' => [ 'AssociateInstanceStorageConfigRequest$StorageConfig' => '<p>A valid storage type.</p>', 'DescribeInstanceStorageConfigResponse$StorageConfig' => '<p>A valid storage type.</p>', 'InstanceStorageConfigs$member' => NULL, 'UpdateInstanceStorageConfigRequest$StorageConfig' => NULL, ], ], 'InstanceStorageConfigs' => [ 'base' => NULL, 'refs' => [ 'ListInstanceStorageConfigsResponse$StorageConfigs' => '<p>A valid storage type.</p>', ], ], 'InstanceStorageResourceType' => [ 'base' => NULL, 'refs' => [ 'AssociateInstanceStorageConfigRequest$ResourceType' => '<p>A valid resource type.</p>', 'DescribeInstanceStorageConfigRequest$ResourceType' => '<p>A valid resource type.</p>', 'DisassociateInstanceStorageConfigRequest$ResourceType' => '<p>A valid resource type.</p>', 'ListInstanceStorageConfigsRequest$ResourceType' => '<p>A valid resource type.</p>', 'UpdateInstanceStorageConfigRequest$ResourceType' => '<p>A valid resource type.</p>', ], ], 'InstanceSummary' => [ 'base' => '<p>Information about the instance.</p>', 'refs' => [ 'InstanceSummaryList$member' => NULL, ], ], 'InstanceSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListInstancesResponse$InstanceSummaryList' => '<p>Information about the instances.</p>', ], ], 'IntegrationAssociationId' => [ 'base' => NULL, 'refs' => [ 'CreateIntegrationAssociationResponse$IntegrationAssociationId' => '<p>The identifier for the integration association.</p>', 'CreateUseCaseRequest$IntegrationAssociationId' => '<p>The identifier for the integration association.</p>', 'DeleteIntegrationAssociationRequest$IntegrationAssociationId' => '<p>The identifier for the integration association.</p>', 'DeleteUseCaseRequest$IntegrationAssociationId' => '<p>The identifier for the integration association.</p>', 'IntegrationAssociationSummary$IntegrationAssociationId' => '<p>The identifier for the AppIntegration association.</p>', 'ListUseCasesRequest$IntegrationAssociationId' => '<p>The identifier for the integration association.</p>', ], ], 'IntegrationAssociationSummary' => [ 'base' => '<p>Contains summary information about the associated AppIntegrations.</p>', 'refs' => [ 'IntegrationAssociationSummaryList$member' => NULL, ], ], 'IntegrationAssociationSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListIntegrationAssociationsResponse$IntegrationAssociationSummaryList' => '<p>The associations.</p>', ], ], 'IntegrationType' => [ 'base' => NULL, 'refs' => [ 'CreateIntegrationAssociationRequest$IntegrationType' => '<p>The type of information to be ingested.</p>', 'IntegrationAssociationSummary$IntegrationType' => '<p>The integration type.</p>', 'ListIntegrationAssociationsRequest$IntegrationType' => '<p>The integration type.</p>', ], ], 'InternalServiceException' => [ 'base' => '<p>Request processing failed because of an error or failure with the service.</p>', 'refs' => [], ], 'InvalidContactFlowException' => [ 'base' => '<p>The contact flow is not valid.</p>', 'refs' => [], ], 'InvalidContactFlowModuleException' => [ 'base' => '<p>The problems with the module. Please fix before trying again.</p>', 'refs' => [], ], 'InvalidParameterException' => [ 'base' => '<p>One or more of the specified parameters are not valid.</p>', 'refs' => [], ], 'InvalidRequestException' => [ 'base' => '<p>The request is not valid.</p>', 'refs' => [], ], 'KeyId' => [ 'base' => NULL, 'refs' => [ 'EncryptionConfig$KeyId' => '<p>The full ARN of the encryption key. </p> <note> <p>Be sure to provide the full ARN of the encryption key, not just the ID.</p> </note>', ], ], 'KinesisFirehoseConfig' => [ 'base' => '<p>Configuration information of a Kinesis Data Firehose delivery stream.</p>', 'refs' => [ 'InstanceStorageConfig$KinesisFirehoseConfig' => '<p>The configuration of the Kinesis Firehose delivery stream.</p>', ], ], 'KinesisStreamConfig' => [ 'base' => '<p>Configuration information of a Kinesis data stream.</p>', 'refs' => [ 'InstanceStorageConfig$KinesisStreamConfig' => '<p>The configuration of the Kinesis data stream.</p>', ], ], 'KinesisVideoStreamConfig' => [ 'base' => '<p>Configuration information of a Kinesis video stream.</p>', 'refs' => [ 'InstanceStorageConfig$KinesisVideoStreamConfig' => '<p>The configuration of the Kinesis video stream.</p>', ], ], 'LexBot' => [ 'base' => '<p>Configuration information of an Amazon Lex bot.</p>', 'refs' => [ 'AssociateBotRequest$LexBot' => NULL, 'AssociateLexBotRequest$LexBot' => '<p>The Amazon Lex bot to associate with the instance.</p>', 'DisassociateBotRequest$LexBot' => NULL, 'LexBotConfig$LexBot' => NULL, 'LexBotsList$member' => NULL, ], ], 'LexBotConfig' => [ 'base' => '<p>Configuration information of an Amazon Lex or Amazon Lex V2 bot.</p>', 'refs' => [ 'LexBotConfigList$member' => NULL, ], ], 'LexBotConfigList' => [ 'base' => NULL, 'refs' => [ 'ListBotsResponse$LexBots' => '<p>The names and Regions of the Amazon Lex or Amazon Lex V2 bots associated with the specified instance.</p>', ], ], 'LexBotsList' => [ 'base' => NULL, 'refs' => [ 'ListLexBotsResponse$LexBots' => '<p>The names and Regions of the Amazon Lex bots associated with the specified instance.</p>', ], ], 'LexRegion' => [ 'base' => NULL, 'refs' => [ 'DisassociateLexBotRequest$LexRegion' => '<p>The Region in which the Amazon Lex bot has been created.</p>', 'LexBot$LexRegion' => '<p>The Region that the Amazon Lex bot was created in.</p>', ], ], 'LexV2Bot' => [ 'base' => '<p>Configuration information of an Amazon Lex V2 bot.</p>', 'refs' => [ 'AssociateBotRequest$LexV2Bot' => '<p>The Amazon Lex V2 bot to associate with the instance.</p>', 'DisassociateBotRequest$LexV2Bot' => '<p>The Amazon Lex V2 bot to disassociate from the instance.</p>', 'LexBotConfig$LexV2Bot' => '<p>Configuration information of an Amazon Lex V2 bot.</p>', ], ], 'LexVersion' => [ 'base' => NULL, 'refs' => [ 'ListBotsRequest$LexVersion' => '<p>The version of Amazon Lex or Amazon Lex V2.</p>', ], ], 'LimitExceededException' => [ 'base' => '<p>The allowed limit for the resource has been exceeded.</p>', 'refs' => [], ], 'ListAgentStatusRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListAgentStatusResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListApprovedOriginsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListApprovedOriginsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListBotsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListBotsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListContactFlowModulesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListContactFlowModulesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListContactFlowsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListContactFlowsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListContactReferencesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListContactReferencesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListHoursOfOperationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListHoursOfOperationsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListInstanceAttributesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListInstanceAttributesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListInstanceStorageConfigsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListInstanceStorageConfigsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListInstancesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListInstancesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListIntegrationAssociationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListIntegrationAssociationsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListLambdaFunctionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListLambdaFunctionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListLexBotsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListLexBotsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListPhoneNumbersRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListPhoneNumbersResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListPromptsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListPromptsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListQueueQuickConnectsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListQueueQuickConnectsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListQueuesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListQueuesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListQuickConnectsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListQuickConnectsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListRoutingProfileQueuesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListRoutingProfileQueuesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListRoutingProfilesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListRoutingProfilesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListSecurityKeysRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListSecurityKeysResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListSecurityProfilePermissionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListSecurityProfilePermissionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListSecurityProfilesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListSecurityProfilesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListUseCasesRequest' => [ 'base' => '<p>Provides summary information about the use cases for the specified integration association.</p>', 'refs' => [], ], 'ListUseCasesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListUserHierarchyGroupsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListUserHierarchyGroupsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListUsersRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListUsersResponse' => [ 'base' => NULL, 'refs' => [], ], 'MaxResult10' => [ 'base' => NULL, 'refs' => [ 'ListInstanceStorageConfigsRequest$MaxResults' => '<p>The maximum number of results to return per page.</p>', 'ListInstancesRequest$MaxResults' => '<p>The maximum number of results to return per page.</p>', ], ], 'MaxResult100' => [ 'base' => NULL, 'refs' => [ 'GetCurrentMetricDataRequest$MaxResults' => '<p>The maximum number of results to return per page.</p>', 'GetMetricDataRequest$MaxResults' => '<p>The maximum number of results to return per page.</p>', 'ListIntegrationAssociationsRequest$MaxResults' => '<p>The maximum number of results to return per page.</p>', 'ListQueueQuickConnectsRequest$MaxResults' => '<p>The maximum number of results to return per page.</p>', 'ListRoutingProfileQueuesRequest$MaxResults' => '<p>The maximum number of results to return per page.</p>', 'ListUseCasesRequest$MaxResults' => '<p>The maximum number of results to return per page.</p>', ], ], 'MaxResult1000' => [ 'base' => NULL, 'refs' => [ 'ListAgentStatusRequest$MaxResults' => '<p>The maximum number of results to return per page.</p>', 'ListContactFlowModulesRequest$MaxResults' => '<p>The maximum number of results to return per page.</p>', 'ListContactFlowsRequest$MaxResults' => '<p>The maximum number of results to return per page.</p>', 'ListHoursOfOperationsRequest$MaxResults' => '<p>The maximum number of results to return per page.</p>', 'ListPhoneNumbersRequest$MaxResults' => '<p>The maximum number of results to return per page.</p>', 'ListPromptsRequest$MaxResults' => '<p>The maximum number of results to return per page.</p>', 'ListQueuesRequest$MaxResults' => '<p>The maximum number of results to return per page.</p>', 'ListQuickConnectsRequest$MaxResults' => '<p>The maximum number of results to return per page.</p>', 'ListRoutingProfilesRequest$MaxResults' => '<p>The maximum number of results to return per page.</p>', 'ListSecurityProfilePermissionsRequest$MaxResults' => '<p>The maximum number of results to return per page.</p>', 'ListSecurityProfilesRequest$MaxResults' => '<p>The maximum number of results to return per page.</p>', 'ListUserHierarchyGroupsRequest$MaxResults' => '<p>The maximum number of results to return per page.</p>', 'ListUsersRequest$MaxResults' => '<p>The maximum number of results to return per page.</p>', ], ], 'MaxResult2' => [ 'base' => NULL, 'refs' => [ 'ListSecurityKeysRequest$MaxResults' => '<p>The maximum number of results to return per page.</p>', ], ], 'MaxResult25' => [ 'base' => NULL, 'refs' => [ 'ListApprovedOriginsRequest$MaxResults' => '<p>The maximum number of results to return per page.</p>', 'ListBotsRequest$MaxResults' => '<p>The maximum number of results to return per page.</p>', 'ListLambdaFunctionsRequest$MaxResults' => '<p>The maximum number of results to return per page.</p>', 'ListLexBotsRequest$MaxResults' => '<p>The maximum number of results to return per page. If no value is specified, the default is 10. </p>', ], ], 'MaxResult7' => [ 'base' => NULL, 'refs' => [ 'ListInstanceAttributesRequest$MaxResults' => '<p>The maximum number of results to return per page.</p>', ], ], 'MediaConcurrencies' => [ 'base' => NULL, 'refs' => [ 'CreateRoutingProfileRequest$MediaConcurrencies' => '<p>The channels that agents can handle in the Contact Control Panel (CCP) for this routing profile.</p>', 'RoutingProfile$MediaConcurrencies' => '<p>The channels agents can handle in the Contact Control Panel (CCP) for this routing profile.</p>', 'UpdateRoutingProfileConcurrencyRequest$MediaConcurrencies' => '<p>The channels that agents can handle in the Contact Control Panel (CCP).</p>', ], ], 'MediaConcurrency' => [ 'base' => '<p>Contains information about which channels are supported, and how many contacts an agent can have on a channel simultaneously.</p>', 'refs' => [ 'MediaConcurrencies$member' => NULL, ], ], 'Message' => [ 'base' => NULL, 'refs' => [ 'AccessDeniedException$Message' => NULL, 'ContactFlowNotPublishedException$Message' => NULL, 'ContactNotFoundException$Message' => '<p>The message.</p>', 'DestinationNotAllowedException$Message' => '<p>The message about the outbound calls.</p>', 'DuplicateResourceException$Message' => NULL, 'IdempotencyException$Message' => NULL, 'InternalServiceException$Message' => '<p>The message.</p>', 'InvalidParameterException$Message' => '<p>The message about the parameters.</p>', 'InvalidRequestException$Message' => '<p>The message about the request.</p>', 'LimitExceededException$Message' => '<p>The message about the limit.</p>', 'OutboundContactNotPermittedException$Message' => '<p>The message about the contact.</p>', 'ResourceConflictException$Message' => NULL, 'ResourceInUseException$Message' => NULL, 'ResourceNotFoundException$Message' => '<p>The message about the resource.</p>', 'ServiceQuotaExceededException$Message' => NULL, 'ThrottlingException$Message' => NULL, 'UserNotFoundException$Message' => NULL, ], ], 'MinutesLimit60' => [ 'base' => NULL, 'refs' => [ 'HoursOfOperationTimeSlice$Minutes' => '<p>The minutes.</p>', ], ], 'Name' => [ 'base' => NULL, 'refs' => [ 'Contact$Name' => '<p>The name of the contact.</p>', 'StartTaskContactRequest$Name' => '<p>The name of a task that is shown to an agent in the Contact Control Panel (CCP).</p>', 'UpdateContactRequest$Name' => '<p>The name of the contact.</p>', ], ], 'NextToken' => [ 'base' => NULL, 'refs' => [ 'GetCurrentMetricDataRequest$NextToken' => '<p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p> <p>The token expires after 5 minutes from the time it is created. Subsequent requests that use the token must use the same request parameters as the request that generated the token.</p>', 'GetCurrentMetricDataResponse$NextToken' => '<p>If there are additional results, this is the token for the next set of results.</p> <p>The token expires after 5 minutes from the time it is created. Subsequent requests that use the token must use the same request parameters as the request that generated the token.</p>', 'GetMetricDataRequest$NextToken' => '<p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>', 'GetMetricDataResponse$NextToken' => '<p>If there are additional results, this is the token for the next set of results.</p> <p>The token expires after 5 minutes from the time it is created. Subsequent requests that use the token must use the same request parameters as the request that generated the token.</p>', 'ListAgentStatusRequest$NextToken' => '<p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>', 'ListAgentStatusResponse$NextToken' => '<p>If there are additional results, this is the token for the next set of results.</p>', 'ListApprovedOriginsRequest$NextToken' => '<p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>', 'ListApprovedOriginsResponse$NextToken' => '<p>If there are additional results, this is the token for the next set of results.</p>', 'ListBotsRequest$NextToken' => '<p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>', 'ListBotsResponse$NextToken' => '<p>If there are additional results, this is the token for the next set of results.</p>', 'ListContactFlowModulesRequest$NextToken' => '<p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>', 'ListContactFlowModulesResponse$NextToken' => '<p>If there are additional results, this is the token for the next set of results.</p>', 'ListContactFlowsRequest$NextToken' => '<p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>', 'ListContactFlowsResponse$NextToken' => '<p>If there are additional results, this is the token for the next set of results.</p>', 'ListContactReferencesRequest$NextToken' => '<p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p> <important> <p>This is not expected to be set, because the value returned in the previous response is always null.</p> </important>', 'ListContactReferencesResponse$NextToken' => '<p>If there are additional results, this is the token for the next set of results.</p> <important> <p>This is always returned as null in the response.</p> </important>', 'ListHoursOfOperationsRequest$NextToken' => '<p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>', 'ListHoursOfOperationsResponse$NextToken' => '<p>If there are additional results, this is the token for the next set of results.</p>', 'ListInstanceAttributesRequest$NextToken' => '<p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>', 'ListInstanceAttributesResponse$NextToken' => '<p>If there are additional results, this is the token for the next set of results.</p>', 'ListInstanceStorageConfigsRequest$NextToken' => '<p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>', 'ListInstanceStorageConfigsResponse$NextToken' => '<p>If there are additional results, this is the token for the next set of results.</p>', 'ListInstancesRequest$NextToken' => '<p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>', 'ListInstancesResponse$NextToken' => '<p>If there are additional results, this is the token for the next set of results.</p>', 'ListIntegrationAssociationsRequest$NextToken' => '<p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>', 'ListIntegrationAssociationsResponse$NextToken' => '<p>If there are additional results, this is the token for the next set of results.</p>', 'ListLambdaFunctionsRequest$NextToken' => '<p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>', 'ListLambdaFunctionsResponse$NextToken' => '<p>If there are additional results, this is the token for the next set of results.</p>', 'ListLexBotsRequest$NextToken' => '<p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>', 'ListLexBotsResponse$NextToken' => '<p>If there are additional results, this is the token for the next set of results.</p>', 'ListPhoneNumbersRequest$NextToken' => '<p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>', 'ListPhoneNumbersResponse$NextToken' => '<p>If there are additional results, this is the token for the next set of results.</p>', 'ListPromptsRequest$NextToken' => '<p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>', 'ListPromptsResponse$NextToken' => '<p>If there are additional results, this is the token for the next set of results.</p>', 'ListQueueQuickConnectsRequest$NextToken' => '<p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>', 'ListQueueQuickConnectsResponse$NextToken' => '<p>If there are additional results, this is the token for the next set of results.</p>', 'ListQueuesRequest$NextToken' => '<p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>', 'ListQueuesResponse$NextToken' => '<p>If there are additional results, this is the token for the next set of results.</p>', 'ListQuickConnectsRequest$NextToken' => '<p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>', 'ListQuickConnectsResponse$NextToken' => '<p>If there are additional results, this is the token for the next set of results.</p>', 'ListRoutingProfileQueuesRequest$NextToken' => '<p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>', 'ListRoutingProfileQueuesResponse$NextToken' => '<p>If there are additional results, this is the token for the next set of results.</p>', 'ListRoutingProfilesRequest$NextToken' => '<p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>', 'ListRoutingProfilesResponse$NextToken' => '<p>If there are additional results, this is the token for the next set of results.</p>', 'ListSecurityKeysRequest$NextToken' => '<p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>', 'ListSecurityKeysResponse$NextToken' => '<p>If there are additional results, this is the token for the next set of results.</p>', 'ListSecurityProfilePermissionsRequest$NextToken' => '<p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>', 'ListSecurityProfilePermissionsResponse$NextToken' => '<p>If there are additional results, this is the token for the next set of results.</p>', 'ListSecurityProfilesRequest$NextToken' => '<p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>', 'ListSecurityProfilesResponse$NextToken' => '<p>If there are additional results, this is the token for the next set of results.</p>', 'ListUseCasesRequest$NextToken' => '<p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>', 'ListUseCasesResponse$NextToken' => '<p>If there are additional results, this is the token for the next set of results.</p>', 'ListUserHierarchyGroupsRequest$NextToken' => '<p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>', 'ListUserHierarchyGroupsResponse$NextToken' => '<p>If there are additional results, this is the token for the next set of results.</p>', 'ListUsersRequest$NextToken' => '<p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>', 'ListUsersResponse$NextToken' => '<p>If there are additional results, this is the token for the next set of results.</p>', ], ], 'Origin' => [ 'base' => NULL, 'refs' => [ 'AssociateApprovedOriginRequest$Origin' => '<p>The domain to add to your allow list.</p>', 'DisassociateApprovedOriginRequest$Origin' => '<p>The domain URL of the integrated application.</p>', 'OriginsList$member' => NULL, ], ], 'OriginsList' => [ 'base' => NULL, 'refs' => [ 'ListApprovedOriginsResponse$Origins' => '<p>The approved origins.</p>', ], ], 'OutboundCallerConfig' => [ 'base' => '<p>The outbound caller ID name, number, and outbound whisper flow.</p>', 'refs' => [ 'CreateQueueRequest$OutboundCallerConfig' => '<p>The outbound caller ID name, number, and outbound whisper flow.</p>', 'Queue$OutboundCallerConfig' => '<p>The outbound caller ID name, number, and outbound whisper flow.</p>', 'UpdateQueueOutboundCallerConfigRequest$OutboundCallerConfig' => '<p>The outbound caller ID name, number, and outbound whisper flow.</p>', ], ], 'OutboundCallerIdName' => [ 'base' => NULL, 'refs' => [ 'OutboundCallerConfig$OutboundCallerIdName' => '<p>The caller ID name.</p>', ], ], 'OutboundCallsEnabled' => [ 'base' => NULL, 'refs' => [ 'CreateInstanceRequest$OutboundCallsEnabled' => '<p>Your contact center allows outbound calls.</p>', 'Instance$OutboundCallsEnabled' => '<p>Whether outbound calls are enabled.</p>', 'InstanceSummary$OutboundCallsEnabled' => '<p>Whether outbound calls are enabled.</p>', ], ], 'OutboundContactNotPermittedException' => [ 'base' => '<p>The contact is not permitted.</p>', 'refs' => [], ], 'PEM' => [ 'base' => NULL, 'refs' => [ 'AssociateSecurityKeyRequest$Key' => '<p>A valid security key in PEM format.</p>', 'SecurityKey$Key' => '<p>The key of the security key.</p>', ], ], 'ParticipantDetails' => [ 'base' => '<p>The customer\'s details.</p>', 'refs' => [ 'StartChatContactRequest$ParticipantDetails' => '<p>Information identifying the participant.</p>', ], ], 'ParticipantId' => [ 'base' => NULL, 'refs' => [ 'StartChatContactResponse$ParticipantId' => '<p>The identifier for a chat participant. The participantId for a chat participant is the same throughout the chat lifecycle.</p>', ], ], 'ParticipantToken' => [ 'base' => NULL, 'refs' => [ 'StartChatContactResponse$ParticipantToken' => '<p>The token used by the chat participant to call <a href="https://docs.aws.amazon.com/connect-participant/latest/APIReference/API_CreateParticipantConnection.html">CreateParticipantConnection</a>. The participant token is valid for the lifetime of a chat participant.</p>', ], ], 'Password' => [ 'base' => NULL, 'refs' => [ 'CreateUserRequest$Password' => '<p>The password for the user account. A password is required if you are using Amazon Connect for identity management. Otherwise, it is an error to include a password.</p>', ], ], 'PermissionsList' => [ 'base' => NULL, 'refs' => [ 'CreateSecurityProfileRequest$Permissions' => '<p>Permissions assigned to the security profile.</p>', 'ListSecurityProfilePermissionsResponse$Permissions' => '<p>The permissions granted to the security profile.</p>', 'UpdateSecurityProfileRequest$Permissions' => '<p>The permissions granted to a security profile.</p>', ], ], 'PhoneNumber' => [ 'base' => NULL, 'refs' => [ 'PhoneNumberQuickConnectConfig$PhoneNumber' => '<p>The phone number in E.164 format.</p>', 'PhoneNumberSummary$PhoneNumber' => '<p>The phone number.</p>', 'StartOutboundVoiceContactRequest$DestinationPhoneNumber' => '<p>The phone number of the customer, in E.164 format.</p>', 'StartOutboundVoiceContactRequest$SourcePhoneNumber' => '<p>The phone number associated with the Amazon Connect instance, in E.164 format. If you do not specify a source phone number, you must specify a queue.</p>', 'UserPhoneConfig$DeskPhoneNumber' => '<p>The phone number for the user\'s desk phone.</p>', ], ], 'PhoneNumberCountryCode' => [ 'base' => NULL, 'refs' => [ 'PhoneNumberCountryCodes$member' => NULL, 'PhoneNumberSummary$PhoneNumberCountryCode' => '<p>The ISO country code.</p>', ], ], 'PhoneNumberCountryCodes' => [ 'base' => NULL, 'refs' => [ 'ListPhoneNumbersRequest$PhoneNumberCountryCodes' => '<p>The ISO country code.</p>', ], ], 'PhoneNumberId' => [ 'base' => NULL, 'refs' => [ 'OutboundCallerConfig$OutboundCallerIdNumberId' => '<p>The caller ID number.</p>', 'PhoneNumberSummary$Id' => '<p>The identifier of the phone number.</p>', ], ], 'PhoneNumberQuickConnectConfig' => [ 'base' => '<p>Contains information about a phone number for a quick connect.</p>', 'refs' => [ 'QuickConnectConfig$PhoneConfig' => '<p>The phone configuration. This is required only if QuickConnectType is PHONE_NUMBER.</p>', ], ], 'PhoneNumberSummary' => [ 'base' => '<p>Contains summary information about a phone number for a contact center.</p>', 'refs' => [ 'PhoneNumberSummaryList$member' => NULL, ], ], 'PhoneNumberSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListPhoneNumbersResponse$PhoneNumberSummaryList' => '<p>Information about the phone numbers.</p>', ], ], 'PhoneNumberType' => [ 'base' => NULL, 'refs' => [ 'PhoneNumberSummary$PhoneNumberType' => '<p>The type of phone number.</p>', 'PhoneNumberTypes$member' => NULL, ], ], 'PhoneNumberTypes' => [ 'base' => NULL, 'refs' => [ 'ListPhoneNumbersRequest$PhoneNumberTypes' => '<p>The type of phone number.</p>', ], ], 'PhoneType' => [ 'base' => NULL, 'refs' => [ 'UserPhoneConfig$PhoneType' => '<p>The phone type.</p>', ], ], 'Prefix' => [ 'base' => NULL, 'refs' => [ 'KinesisVideoStreamConfig$Prefix' => '<p>The prefix of the video stream.</p>', 'S3Config$BucketPrefix' => '<p>The S3 bucket prefix.</p>', ], ], 'Priority' => [ 'base' => NULL, 'refs' => [ 'RoutingProfileQueueConfig$Priority' => '<p>The order in which contacts are to be handled for the queue. For more information, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/concepts-routing-profiles-priority.html">Queues: priority and delay</a>.</p>', 'RoutingProfileQueueConfigSummary$Priority' => '<p>The order in which contacts are to be handled for the queue. For more information, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/concepts-routing-profiles-priority.html">Queues: priority and delay</a>.</p>', ], ], 'ProblemDetail' => [ 'base' => '<p>Information about a problem detail.</p>', 'refs' => [ 'Problems$member' => NULL, ], ], 'ProblemMessageString' => [ 'base' => NULL, 'refs' => [ 'ProblemDetail$message' => '<p>The problem detail\'s message.</p>', ], ], 'Problems' => [ 'base' => NULL, 'refs' => [ 'InvalidContactFlowException$problems' => '<p>The problems with the contact flow. Please fix before trying again.</p>', 'InvalidContactFlowModuleException$Problems' => NULL, ], ], 'PromptId' => [ 'base' => NULL, 'refs' => [ 'PromptSummary$Id' => '<p>The identifier of the prompt.</p>', ], ], 'PromptName' => [ 'base' => NULL, 'refs' => [ 'PromptSummary$Name' => '<p>The name of the prompt.</p>', ], ], 'PromptSummary' => [ 'base' => '<p>Contains information about the prompt.</p>', 'refs' => [ 'PromptSummaryList$member' => NULL, ], ], 'PromptSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListPromptsResponse$PromptSummaryList' => '<p>Information about the prompts.</p>', ], ], 'Queue' => [ 'base' => '<p>Contains information about a queue.</p>', 'refs' => [ 'DescribeQueueResponse$Queue' => '<p>The name of the queue.</p>', ], ], 'QueueDescription' => [ 'base' => NULL, 'refs' => [ 'CreateQueueRequest$Description' => '<p>The description of the queue.</p>', 'Queue$Description' => '<p>The description of the queue.</p>', 'UpdateQueueNameRequest$Description' => '<p>The description of the queue.</p>', ], ], 'QueueId' => [ 'base' => NULL, 'refs' => [ 'AssociateQueueQuickConnectsRequest$QueueId' => '<p>The identifier for the queue.</p>', 'CreateQueueResponse$QueueId' => '<p>The identifier for the queue.</p>', 'CreateRoutingProfileRequest$DefaultOutboundQueueId' => '<p>The default outbound queue for the routing profile.</p>', 'DescribeQueueRequest$QueueId' => '<p>The identifier for the queue.</p>', 'DisassociateQueueQuickConnectsRequest$QueueId' => '<p>The identifier for the queue.</p>', 'ListQueueQuickConnectsRequest$QueueId' => '<p>The identifier for the queue.</p>', 'Queue$QueueId' => '<p>The identifier for the queue.</p>', 'QueueInfo$Id' => '<p>The identifier of the agent who accepted the contact.</p>', 'QueueQuickConnectConfig$QueueId' => '<p>The identifier for the queue.</p>', 'QueueReference$Id' => '<p>The identifier of the queue.</p>', 'QueueSummary$Id' => '<p>The identifier of the queue.</p>', 'Queues$member' => NULL, 'RoutingProfile$DefaultOutboundQueueId' => '<p>The identifier of the default outbound queue for this routing profile.</p>', 'RoutingProfileQueueConfigSummary$QueueId' => '<p>The identifier for the queue.</p>', 'RoutingProfileQueueReference$QueueId' => '<p>The identifier for the queue.</p>', 'StartOutboundVoiceContactRequest$QueueId' => '<p>The queue for the call. If you specify a queue, the phone displayed for caller ID is the phone number specified in the queue. If you do not specify a queue, the queue defined in the contact flow is used. If you do not specify a queue, you must specify a source phone number.</p>', 'UpdateQueueHoursOfOperationRequest$QueueId' => '<p>The identifier for the queue.</p>', 'UpdateQueueMaxContactsRequest$QueueId' => '<p>The identifier for the queue.</p>', 'UpdateQueueNameRequest$QueueId' => '<p>The identifier for the queue.</p>', 'UpdateQueueOutboundCallerConfigRequest$QueueId' => '<p>The identifier for the queue.</p>', 'UpdateQueueStatusRequest$QueueId' => '<p>The identifier for the queue.</p>', 'UpdateRoutingProfileDefaultOutboundQueueRequest$DefaultOutboundQueueId' => '<p>The identifier for the default outbound queue.</p>', ], ], 'QueueInfo' => [ 'base' => '<p>If this contact was queued, this contains information about the queue. </p>', 'refs' => [ 'Contact$QueueInfo' => '<p>If this contact was queued, this contains information about the queue. </p>', ], ], 'QueueMaxContacts' => [ 'base' => NULL, 'refs' => [ 'CreateQueueRequest$MaxContacts' => '<p>The maximum number of contacts that can be in the queue before it is considered full.</p>', 'Queue$MaxContacts' => '<p>The maximum number of contacts that can be in the queue before it is considered full.</p>', 'UpdateQueueMaxContactsRequest$MaxContacts' => '<p>The maximum number of contacts that can be in the queue before it is considered full.</p>', ], ], 'QueueName' => [ 'base' => NULL, 'refs' => [ 'QueueSummary$Name' => '<p>The name of the queue.</p>', 'RoutingProfileQueueConfigSummary$QueueName' => '<p>The name of the queue.</p>', ], ], 'QueueQuickConnectConfig' => [ 'base' => '<p>Contains information about a queue for a quick connect. The contact flow must be of type Transfer to Queue.</p>', 'refs' => [ 'QuickConnectConfig$QueueConfig' => '<p>The queue configuration. This is required only if QuickConnectType is QUEUE.</p>', ], ], 'QueueReference' => [ 'base' => '<p>Contains information about a queue resource for which metrics are returned.</p>', 'refs' => [ 'Dimensions$Queue' => '<p>Information about the queue for which metrics are returned.</p>', ], ], 'QueueStatus' => [ 'base' => NULL, 'refs' => [ 'Queue$Status' => '<p>The status of the queue.</p>', 'UpdateQueueStatusRequest$Status' => '<p>The status of the queue.</p>', ], ], 'QueueSummary' => [ 'base' => '<p>Contains summary information about a queue.</p>', 'refs' => [ 'QueueSummaryList$member' => NULL, ], ], 'QueueSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListQueuesResponse$QueueSummaryList' => '<p>Information about the queues.</p>', ], ], 'QueueType' => [ 'base' => NULL, 'refs' => [ 'QueueSummary$QueueType' => '<p>The type of queue.</p>', 'QueueTypes$member' => NULL, ], ], 'QueueTypes' => [ 'base' => NULL, 'refs' => [ 'ListQueuesRequest$QueueTypes' => '<p>The type of queue.</p>', ], ], 'Queues' => [ 'base' => NULL, 'refs' => [ 'Filters$Queues' => '<p>The queues to use to filter the metrics. You can specify up to 100 queues per request.</p>', ], ], 'QuickConnect' => [ 'base' => '<p>Contains information about a quick connect.</p>', 'refs' => [ 'DescribeQuickConnectResponse$QuickConnect' => '<p>Information about the quick connect.</p>', ], ], 'QuickConnectConfig' => [ 'base' => '<p>Contains configuration settings for a quick connect.</p>', 'refs' => [ 'CreateQuickConnectRequest$QuickConnectConfig' => '<p>Configuration settings for the quick connect.</p>', 'QuickConnect$QuickConnectConfig' => '<p>Contains information about the quick connect.</p>', 'UpdateQuickConnectConfigRequest$QuickConnectConfig' => '<p>Information about the configuration settings for the quick connect.</p>', ], ], 'QuickConnectDescription' => [ 'base' => NULL, 'refs' => [ 'CreateQuickConnectRequest$Description' => '<p>The description of the quick connect.</p>', 'QuickConnect$Description' => '<p>The description.</p>', ], ], 'QuickConnectId' => [ 'base' => NULL, 'refs' => [ 'CreateQuickConnectResponse$QuickConnectId' => '<p>The identifier for the quick connect. </p>', 'DeleteQuickConnectRequest$QuickConnectId' => '<p>The identifier for the quick connect.</p>', 'DescribeQuickConnectRequest$QuickConnectId' => '<p>The identifier for the quick connect.</p>', 'QuickConnect$QuickConnectId' => '<p>The identifier for the quick connect.</p>', 'QuickConnectSummary$Id' => '<p>The identifier for the quick connect.</p>', 'QuickConnectsList$member' => NULL, 'UpdateQuickConnectConfigRequest$QuickConnectId' => '<p>The identifier for the quick connect.</p>', 'UpdateQuickConnectNameRequest$QuickConnectId' => '<p>The identifier for the quick connect.</p>', ], ], 'QuickConnectName' => [ 'base' => NULL, 'refs' => [ 'CreateQuickConnectRequest$Name' => '<p>The name of the quick connect.</p>', 'QuickConnect$Name' => '<p>The name of the quick connect.</p>', 'QuickConnectSummary$Name' => '<p>The name of the quick connect.</p>', 'UpdateQuickConnectNameRequest$Name' => '<p>The name of the quick connect.</p>', ], ], 'QuickConnectSummary' => [ 'base' => '<p>Contains summary information about a quick connect.</p>', 'refs' => [ 'QuickConnectSummaryList$member' => NULL, ], ], 'QuickConnectSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListQueueQuickConnectsResponse$QuickConnectSummaryList' => '<p>Information about the quick connects.</p>', 'ListQuickConnectsResponse$QuickConnectSummaryList' => '<p>Information about the quick connects.</p>', ], ], 'QuickConnectType' => [ 'base' => NULL, 'refs' => [ 'QuickConnectConfig$QuickConnectType' => '<p>The type of quick connect. In the Amazon Connect console, when you create a quick connect, you are prompted to assign one of the following types: Agent (USER), External (PHONE_NUMBER), or Queue (QUEUE). </p>', 'QuickConnectSummary$QuickConnectType' => '<p>The type of quick connect. In the Amazon Connect console, when you create a quick connect, you are prompted to assign one of the following types: Agent (USER), External (PHONE_NUMBER), or Queue (QUEUE).</p>', 'QuickConnectTypes$member' => NULL, ], ], 'QuickConnectTypes' => [ 'base' => NULL, 'refs' => [ 'ListQuickConnectsRequest$QuickConnectTypes' => '<p>The type of quick connect. In the Amazon Connect console, when you create a quick connect, you are prompted to assign one of the following types: Agent (USER), External (PHONE_NUMBER), or Queue (QUEUE).</p>', ], ], 'QuickConnectsList' => [ 'base' => NULL, 'refs' => [ 'AssociateQueueQuickConnectsRequest$QuickConnectIds' => '<p>The quick connects to associate with this queue.</p>', 'CreateQueueRequest$QuickConnectIds' => '<p>The quick connects available to agents who are working the queue.</p>', 'DisassociateQueueQuickConnectsRequest$QuickConnectIds' => '<p>The quick connects to disassociate from the queue.</p>', ], ], 'Reference' => [ 'base' => '<p>A link that an agent selects to complete a given task. You can have up to 4,096 UTF-8 bytes across all references for a contact.</p>', 'refs' => [ 'ContactReferences$value' => NULL, ], ], 'ReferenceKey' => [ 'base' => NULL, 'refs' => [ 'AttachmentReference$Name' => '<p>Identifier of the attachment reference.</p>', 'ContactReferences$key' => NULL, 'UrlReference$Name' => '<p>Identifier of the URL reference.</p>', ], ], 'ReferenceStatus' => [ 'base' => NULL, 'refs' => [ 'AttachmentReference$Status' => '<p>Status of an attachment reference type.</p>', ], ], 'ReferenceSummary' => [ 'base' => '<p>Contains summary information about a reference. <code>ReferenceSummary</code> contains only one non null field between the URL and attachment based on the reference type.</p>', 'refs' => [ 'ReferenceSummaryList$member' => NULL, ], ], 'ReferenceSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListContactReferencesResponse$ReferenceSummaryList' => '<p>Information about the contact flows.</p>', ], ], 'ReferenceType' => [ 'base' => NULL, 'refs' => [ 'Reference$Type' => '<p>The type of the reference. Only <code>URL</code> type can be added or updated on a contact.</p>', 'ReferenceTypes$member' => NULL, ], ], 'ReferenceTypes' => [ 'base' => NULL, 'refs' => [ 'ListContactReferencesRequest$ReferenceTypes' => '<p>The type of reference.</p>', ], ], 'ReferenceValue' => [ 'base' => NULL, 'refs' => [ 'AttachmentReference$Value' => '<p>Contains the location path of the attachment reference.</p>', 'Reference$Value' => '<p>A valid value for the reference. For example, for a URL reference, a formatted URL that is displayed to an agent in the Contact Control Panel (CCP).</p>', 'UrlReference$Value' => '<p>A valid URL.</p>', ], ], 'ResourceConflictException' => [ 'base' => '<p>A resource already has that name.</p>', 'refs' => [], ], 'ResourceInUseException' => [ 'base' => '<p>That resource is already in use. Please try another.</p>', 'refs' => [], ], 'ResourceNotFoundException' => [ 'base' => '<p>The specified resource was not found.</p>', 'refs' => [], ], 'ResourceType' => [ 'base' => NULL, 'refs' => [ 'ResourceInUseException$ResourceType' => '<p>The type of resource.</p>', ], ], 'ResumeContactRecordingRequest' => [ 'base' => NULL, 'refs' => [], ], 'ResumeContactRecordingResponse' => [ 'base' => NULL, 'refs' => [], ], 'RoutingProfile' => [ 'base' => '<p>Contains information about a routing profile.</p>', 'refs' => [ 'DescribeRoutingProfileResponse$RoutingProfile' => '<p>The routing profile.</p>', ], ], 'RoutingProfileDescription' => [ 'base' => NULL, 'refs' => [ 'CreateRoutingProfileRequest$Description' => '<p>Description of the routing profile. Must not be more than 250 characters.</p>', 'RoutingProfile$Description' => '<p>The description of the routing profile.</p>', 'UpdateRoutingProfileNameRequest$Description' => '<p>The description of the routing profile. Must not be more than 250 characters.</p>', ], ], 'RoutingProfileId' => [ 'base' => NULL, 'refs' => [ 'AssociateRoutingProfileQueuesRequest$RoutingProfileId' => '<p>The identifier of the routing profile.</p>', 'CreateRoutingProfileResponse$RoutingProfileId' => '<p>The identifier of the routing profile.</p>', 'CreateUserRequest$RoutingProfileId' => '<p>The identifier of the routing profile for the user.</p>', 'DescribeRoutingProfileRequest$RoutingProfileId' => '<p>The identifier of the routing profile.</p>', 'DisassociateRoutingProfileQueuesRequest$RoutingProfileId' => '<p>The identifier of the routing profile.</p>', 'ListRoutingProfileQueuesRequest$RoutingProfileId' => '<p>The identifier of the routing profile.</p>', 'RoutingProfile$RoutingProfileId' => '<p>The identifier of the routing profile.</p>', 'RoutingProfileSummary$Id' => '<p>The identifier of the routing profile.</p>', 'UpdateRoutingProfileConcurrencyRequest$RoutingProfileId' => '<p>The identifier of the routing profile.</p>', 'UpdateRoutingProfileDefaultOutboundQueueRequest$RoutingProfileId' => '<p>The identifier of the routing profile.</p>', 'UpdateRoutingProfileNameRequest$RoutingProfileId' => '<p>The identifier of the routing profile.</p>', 'UpdateRoutingProfileQueuesRequest$RoutingProfileId' => '<p>The identifier of the routing profile.</p>', 'UpdateUserRoutingProfileRequest$RoutingProfileId' => '<p>The identifier of the routing profile for the user.</p>', 'User$RoutingProfileId' => '<p>The identifier of the routing profile for the user.</p>', ], ], 'RoutingProfileName' => [ 'base' => NULL, 'refs' => [ 'CreateRoutingProfileRequest$Name' => '<p>The name of the routing profile. Must not be more than 127 characters.</p>', 'RoutingProfile$Name' => '<p>The name of the routing profile.</p>', 'RoutingProfileSummary$Name' => '<p>The name of the routing profile.</p>', 'UpdateRoutingProfileNameRequest$Name' => '<p>The name of the routing profile. Must not be more than 127 characters.</p>', ], ], 'RoutingProfileQueueConfig' => [ 'base' => '<p>Contains information about the queue and channel for which priority and delay can be set.</p>', 'refs' => [ 'RoutingProfileQueueConfigList$member' => NULL, ], ], 'RoutingProfileQueueConfigList' => [ 'base' => NULL, 'refs' => [ 'AssociateRoutingProfileQueuesRequest$QueueConfigs' => '<p>The queues to associate with this routing profile.</p>', 'CreateRoutingProfileRequest$QueueConfigs' => '<p>The inbound queues associated with the routing profile. If no queue is added, the agent can make only outbound calls.</p>', 'UpdateRoutingProfileQueuesRequest$QueueConfigs' => '<p>The queues to be updated for this routing profile. Queues must first be associated to the routing profile. You can do this using AssociateRoutingProfileQueues.</p>', ], ], 'RoutingProfileQueueConfigSummary' => [ 'base' => '<p>Contains summary information about a routing profile queue.</p>', 'refs' => [ 'RoutingProfileQueueConfigSummaryList$member' => NULL, ], ], 'RoutingProfileQueueConfigSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListRoutingProfileQueuesResponse$RoutingProfileQueueConfigSummaryList' => '<p>Information about the routing profiles.</p>', ], ], 'RoutingProfileQueueReference' => [ 'base' => '<p>Contains the channel and queue identifier for a routing profile.</p>', 'refs' => [ 'RoutingProfileQueueConfig$QueueReference' => '<p>Contains information about a queue resource.</p>', 'RoutingProfileQueueReferenceList$member' => NULL, ], ], 'RoutingProfileQueueReferenceList' => [ 'base' => NULL, 'refs' => [ 'DisassociateRoutingProfileQueuesRequest$QueueReferences' => '<p>The queues to disassociate from this routing profile.</p>', ], ], 'RoutingProfileSummary' => [ 'base' => '<p>Contains summary information about a routing profile.</p>', 'refs' => [ 'RoutingProfileSummaryList$member' => NULL, ], ], 'RoutingProfileSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListRoutingProfilesResponse$RoutingProfileSummaryList' => '<p>Information about the routing profiles.</p>', ], ], 'S3Config' => [ 'base' => '<p>Information about the Amazon Simple Storage Service (Amazon S3) storage type.</p>', 'refs' => [ 'InstanceStorageConfig$S3Config' => '<p>The S3 bucket configuration.</p>', ], ], 'SecurityKey' => [ 'base' => '<p>Configuration information of the security key.</p>', 'refs' => [ 'SecurityKeysList$member' => NULL, ], ], 'SecurityKeysList' => [ 'base' => NULL, 'refs' => [ 'ListSecurityKeysResponse$SecurityKeys' => '<p>The security keys.</p>', ], ], 'SecurityProfile' => [ 'base' => '<p>Contains information about a security profile.</p>', 'refs' => [ 'DescribeSecurityProfileResponse$SecurityProfile' => '<p>The security profile.</p>', ], ], 'SecurityProfileDescription' => [ 'base' => NULL, 'refs' => [ 'CreateSecurityProfileRequest$Description' => '<p>The description of the security profile.</p>', 'SecurityProfile$Description' => '<p>The description of the security profile.</p>', 'UpdateSecurityProfileRequest$Description' => '<p>The description of the security profile.</p>', ], ], 'SecurityProfileId' => [ 'base' => NULL, 'refs' => [ 'CreateSecurityProfileResponse$SecurityProfileId' => '<p>The identifier for the security profle.</p>', 'DeleteSecurityProfileRequest$SecurityProfileId' => '<p>The identifier for the security profle.</p>', 'DescribeSecurityProfileRequest$SecurityProfileId' => '<p>The identifier for the security profle.</p>', 'ListSecurityProfilePermissionsRequest$SecurityProfileId' => '<p>The identifier for the security profle.</p>', 'SecurityProfile$Id' => '<p>The identifier for the security profile.</p>', 'SecurityProfileIds$member' => NULL, 'SecurityProfileSummary$Id' => '<p>The identifier of the security profile.</p>', 'UpdateSecurityProfileRequest$SecurityProfileId' => '<p>The identifier for the security profle.</p>', ], ], 'SecurityProfileIds' => [ 'base' => NULL, 'refs' => [ 'CreateUserRequest$SecurityProfileIds' => '<p>The identifier of the security profile for the user.</p>', 'UpdateUserSecurityProfilesRequest$SecurityProfileIds' => '<p>The identifiers of the security profiles for the user.</p>', 'User$SecurityProfileIds' => '<p>The identifiers of the security profiles for the user.</p>', ], ], 'SecurityProfileName' => [ 'base' => NULL, 'refs' => [ 'CreateSecurityProfileRequest$SecurityProfileName' => '<p>The name of the security profile.</p>', 'SecurityProfile$SecurityProfileName' => '<p>The name for the security profile.</p>', 'SecurityProfileSummary$Name' => '<p>The name of the security profile.</p>', ], ], 'SecurityProfilePermission' => [ 'base' => NULL, 'refs' => [ 'PermissionsList$member' => NULL, ], ], 'SecurityProfileSummary' => [ 'base' => '<p>Contains information about a security profile.</p>', 'refs' => [ 'SecurityProfileSummaryList$member' => NULL, ], ], 'SecurityProfileSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListSecurityProfilesResponse$SecurityProfileSummaryList' => '<p>Information about the security profiles.</p>', ], ], 'SecurityToken' => [ 'base' => NULL, 'refs' => [ 'Credentials$AccessToken' => '<p>An access token generated for a federated user to access Amazon Connect.</p>', 'Credentials$RefreshToken' => '<p>Renews a token generated for a user to access the Amazon Connect instance.</p>', ], ], 'ServiceQuotaExceededException' => [ 'base' => '<p>The service quota has been exceeded.</p>', 'refs' => [], ], 'SourceApplicationName' => [ 'base' => NULL, 'refs' => [ 'CreateIntegrationAssociationRequest$SourceApplicationName' => '<p>The name of the external application. This field is only required for the EVENT integration type.</p>', 'IntegrationAssociationSummary$SourceApplicationName' => '<p>The user-provided, friendly name for the external application.</p>', ], ], 'SourceType' => [ 'base' => NULL, 'refs' => [ 'CreateIntegrationAssociationRequest$SourceType' => '<p>The type of the data source. This field is only required for the EVENT integration type.</p>', 'IntegrationAssociationSummary$SourceType' => '<p>The name of the source.</p>', ], ], 'StartChatContactRequest' => [ 'base' => NULL, 'refs' => [], ], 'StartChatContactResponse' => [ 'base' => NULL, 'refs' => [], ], 'StartContactRecordingRequest' => [ 'base' => NULL, 'refs' => [], ], 'StartContactRecordingResponse' => [ 'base' => NULL, 'refs' => [], ], 'StartContactStreamingRequest' => [ 'base' => NULL, 'refs' => [], ], 'StartContactStreamingResponse' => [ 'base' => NULL, 'refs' => [], ], 'StartOutboundVoiceContactRequest' => [ 'base' => NULL, 'refs' => [], ], 'StartOutboundVoiceContactResponse' => [ 'base' => NULL, 'refs' => [], ], 'StartTaskContactRequest' => [ 'base' => NULL, 'refs' => [], ], 'StartTaskContactResponse' => [ 'base' => NULL, 'refs' => [], ], 'Statistic' => [ 'base' => NULL, 'refs' => [ 'HistoricalMetric$Statistic' => '<p>The statistic for the metric.</p>', ], ], 'StopContactRecordingRequest' => [ 'base' => NULL, 'refs' => [], ], 'StopContactRecordingResponse' => [ 'base' => NULL, 'refs' => [], ], 'StopContactRequest' => [ 'base' => NULL, 'refs' => [], ], 'StopContactResponse' => [ 'base' => NULL, 'refs' => [], ], 'StopContactStreamingRequest' => [ 'base' => NULL, 'refs' => [], ], 'StopContactStreamingResponse' => [ 'base' => NULL, 'refs' => [], ], 'StorageType' => [ 'base' => NULL, 'refs' => [ 'InstanceStorageConfig$StorageType' => '<p>A valid storage type.</p>', ], ], 'StreamingId' => [ 'base' => NULL, 'refs' => [ 'StartContactStreamingResponse$StreamingId' => '<p>The identifier of the streaming configuration enabled. </p>', 'StopContactStreamingRequest$StreamingId' => '<p>The identifier of the streaming configuration enabled. </p>', ], ], 'String' => [ 'base' => NULL, 'refs' => [ 'InstanceStatusReason$Message' => '<p>The message.</p>', ], ], 'SuspendContactRecordingRequest' => [ 'base' => NULL, 'refs' => [], ], 'SuspendContactRecordingResponse' => [ 'base' => NULL, 'refs' => [], ], 'TagKey' => [ 'base' => NULL, 'refs' => [ 'TagKeyList$member' => NULL, 'TagMap$key' => NULL, ], ], 'TagKeyList' => [ 'base' => NULL, 'refs' => [ 'UntagResourceRequest$tagKeys' => '<p>The tag keys.</p>', ], ], 'TagMap' => [ 'base' => NULL, 'refs' => [ 'AgentStatus$Tags' => '<p>The tags used to organize, track, or control access for this resource.</p>', 'ContactFlow$Tags' => '<p>One or more tags.</p>', 'ContactFlowModule$Tags' => '<p>The tags used to organize, track, or control access for this resource.</p>', 'CreateAgentStatusRequest$Tags' => '<p>The tags used to organize, track, or control access for this resource.</p>', 'CreateContactFlowModuleRequest$Tags' => '<p>The tags used to organize, track, or control access for this resource.</p>', 'CreateContactFlowRequest$Tags' => '<p>One or more tags.</p>', 'CreateHoursOfOperationRequest$Tags' => '<p>The tags used to organize, track, or control access for this resource.</p>', 'CreateIntegrationAssociationRequest$Tags' => '<p>The tags used to organize, track, or control access for this resource.</p>', 'CreateQueueRequest$Tags' => '<p>The tags used to organize, track, or control access for this resource.</p>', 'CreateQuickConnectRequest$Tags' => '<p>The tags used to organize, track, or control access for this resource.</p>', 'CreateRoutingProfileRequest$Tags' => '<p>One or more tags.</p>', 'CreateSecurityProfileRequest$Tags' => '<p>The tags used to organize, track, or control access for this resource.</p>', 'CreateUseCaseRequest$Tags' => '<p>The tags used to organize, track, or control access for this resource.</p>', 'CreateUserRequest$Tags' => '<p>One or more tags.</p>', 'HoursOfOperation$Tags' => '<p>The tags used to organize, track, or control access for this resource.</p>', 'ListTagsForResourceResponse$tags' => '<p>Information about the tags.</p>', 'Queue$Tags' => '<p>The tags used to organize, track, or control access for this resource.</p>', 'QuickConnect$Tags' => '<p>The tags used to organize, track, or control access for this resource.</p>', 'RoutingProfile$Tags' => '<p>One or more tags.</p>', 'SecurityProfile$Tags' => '<p>The tags used to organize, track, or control access for this resource.</p>', 'TagResourceRequest$tags' => '<p>One or more tags. For example, { "tags": {"key1":"value1", "key2":"value2"} }.</p>', 'User$Tags' => '<p>The tags.</p>', ], ], 'TagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'TagValue' => [ 'base' => NULL, 'refs' => [ 'TagMap$value' => NULL, ], ], 'Threshold' => [ 'base' => '<p>Contains information about the threshold for service level metrics.</p>', 'refs' => [ 'HistoricalMetric$Threshold' => '<p>The threshold for the metric, used with service level metrics.</p>', ], ], 'ThresholdValue' => [ 'base' => NULL, 'refs' => [ 'Threshold$ThresholdValue' => '<p>The threshold value to compare.</p>', ], ], 'ThrottlingException' => [ 'base' => '<p>The throttling limit has been exceeded.</p>', 'refs' => [], ], 'TimeZone' => [ 'base' => NULL, 'refs' => [ 'CreateHoursOfOperationRequest$TimeZone' => '<p>The time zone of the hours of operation.</p>', 'HoursOfOperation$TimeZone' => '<p>The time zone for the hours of operation.</p>', 'UpdateHoursOfOperationRequest$TimeZone' => '<p>The time zone of the hours of operation.</p>', ], ], 'Timestamp' => [ 'base' => NULL, 'refs' => [ 'Instance$CreatedTime' => '<p>When the instance was created.</p>', 'InstanceSummary$CreatedTime' => '<p>When the instance was created.</p>', 'StartTaskContactRequest$ScheduledTime' => '<p>The timestamp, in Unix Epoch seconds format, at which to start running the inbound contact flow. The scheduled time cannot be in the past. It must be within up to 6 days in future. </p>', 'UpdateContactScheduleRequest$ScheduledTime' => '<p>The timestamp, in Unix Epoch seconds format, at which to start running the inbound contact flow. The scheduled time cannot be in the past. It must be within up to 6 days in future. </p>', ], ], 'TrafficType' => [ 'base' => NULL, 'refs' => [ 'StartOutboundVoiceContactRequest$TrafficType' => '<p>Denotes the class of traffic. Calls with different traffic types are handled differently by Amazon Connect. The default value is <code>GENERAL</code>. Use <code>CAMPAIGN</code> if <code>EnableAnswerMachineDetection</code> is set to <code>true</code>. For all other cases, use <code>GENERAL</code>. </p>', ], ], 'URI' => [ 'base' => NULL, 'refs' => [ 'CreateIntegrationAssociationRequest$SourceApplicationUrl' => '<p>The URL for the external application. This field is only required for the EVENT integration type.</p>', 'IntegrationAssociationSummary$SourceApplicationUrl' => '<p>The URL for the external application.</p>', ], ], 'Unit' => [ 'base' => NULL, 'refs' => [ 'CurrentMetric$Unit' => '<p>The unit for the metric.</p>', 'HistoricalMetric$Unit' => '<p>The unit for the metric.</p>', ], ], 'UntagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateAgentStatusDescription' => [ 'base' => NULL, 'refs' => [ 'UpdateAgentStatusRequest$Description' => '<p>The description of the agent status.</p>', ], ], 'UpdateAgentStatusRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateContactAttributesRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateContactAttributesResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateContactFlowContentRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateContactFlowMetadataRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateContactFlowModuleContentRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateContactFlowModuleContentResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateContactFlowModuleMetadataRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateContactFlowModuleMetadataResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateContactFlowNameRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateContactRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateContactResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateContactScheduleRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateContactScheduleResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateHoursOfOperationDescription' => [ 'base' => NULL, 'refs' => [ 'UpdateHoursOfOperationRequest$Description' => '<p>The description of the hours of operation.</p>', ], ], 'UpdateHoursOfOperationRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateInstanceAttributeRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateInstanceStorageConfigRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateQueueHoursOfOperationRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateQueueMaxContactsRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateQueueNameRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateQueueOutboundCallerConfigRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateQueueStatusRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateQuickConnectConfigRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateQuickConnectDescription' => [ 'base' => NULL, 'refs' => [ 'UpdateQuickConnectNameRequest$Description' => '<p>The description of the quick connect.</p>', ], ], 'UpdateQuickConnectNameRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateRoutingProfileConcurrencyRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateRoutingProfileDefaultOutboundQueueRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateRoutingProfileNameRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateRoutingProfileQueuesRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateSecurityProfileRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateUserHierarchyGroupNameRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateUserHierarchyRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateUserHierarchyStructureRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateUserIdentityInfoRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateUserPhoneConfigRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateUserRoutingProfileRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateUserSecurityProfilesRequest' => [ 'base' => NULL, 'refs' => [], ], 'UrlReference' => [ 'base' => '<p>The URL reference.</p>', 'refs' => [ 'ReferenceSummary$Url' => '<p>Information about the URL reference if the <code>referenceType</code> is <code>URL</code>. Otherwise, null.</p>', ], ], 'UseCase' => [ 'base' => '<p>Contains the use case.</p>', 'refs' => [ 'UseCaseSummaryList$member' => NULL, ], ], 'UseCaseId' => [ 'base' => NULL, 'refs' => [ 'CreateUseCaseResponse$UseCaseId' => '<p>The identifier of the use case.</p>', 'DeleteUseCaseRequest$UseCaseId' => '<p>The identifier for the use case.</p>', 'UseCase$UseCaseId' => '<p>The identifier for the use case.</p>', ], ], 'UseCaseSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListUseCasesResponse$UseCaseSummaryList' => '<p>The use cases.</p>', ], ], 'UseCaseType' => [ 'base' => NULL, 'refs' => [ 'CreateUseCaseRequest$UseCaseType' => '<p>The type of use case to associate to the integration association. Each integration association can have only one of each use case type.</p>', 'UseCase$UseCaseType' => '<p>The type of use case to associate to the integration association. Each integration association can have only one of each use case type.</p>', ], ], 'User' => [ 'base' => '<p>Contains information about a user account for a Amazon Connect instance.</p>', 'refs' => [ 'DescribeUserResponse$User' => '<p>Information about the user account and configuration settings.</p>', ], ], 'UserId' => [ 'base' => NULL, 'refs' => [ 'CreateUserResponse$UserId' => '<p>The identifier of the user account.</p>', 'DeleteUserRequest$UserId' => '<p>The identifier of the user.</p>', 'DescribeUserRequest$UserId' => '<p>The identifier of the user account.</p>', 'UpdateUserHierarchyRequest$UserId' => '<p>The identifier of the user account.</p>', 'UpdateUserIdentityInfoRequest$UserId' => '<p>The identifier of the user account.</p>', 'UpdateUserPhoneConfigRequest$UserId' => '<p>The identifier of the user account.</p>', 'UpdateUserRoutingProfileRequest$UserId' => '<p>The identifier of the user account.</p>', 'UpdateUserSecurityProfilesRequest$UserId' => '<p>The identifier of the user account.</p>', 'User$Id' => '<p>The identifier of the user account.</p>', 'UserQuickConnectConfig$UserId' => '<p>The identifier of the user.</p>', 'UserSummary$Id' => '<p>The identifier of the user account.</p>', ], ], 'UserIdentityInfo' => [ 'base' => '<p>Contains information about the identity of a user.</p>', 'refs' => [ 'CreateUserRequest$IdentityInfo' => '<p>The information about the identity of the user.</p>', 'UpdateUserIdentityInfoRequest$IdentityInfo' => '<p>The identity information for the user.</p>', 'User$IdentityInfo' => '<p>Information about the user identity.</p>', ], ], 'UserNotFoundException' => [ 'base' => '<p>No user with the specified credentials was found in the Amazon Connect instance.</p>', 'refs' => [], ], 'UserPhoneConfig' => [ 'base' => '<p>Contains information about the phone configuration settings for a user.</p>', 'refs' => [ 'CreateUserRequest$PhoneConfig' => '<p>The phone settings for the user.</p>', 'UpdateUserPhoneConfigRequest$PhoneConfig' => '<p>Information about phone configuration settings for the user.</p>', 'User$PhoneConfig' => '<p>Information about the phone configuration for the user.</p>', ], ], 'UserQuickConnectConfig' => [ 'base' => '<p>Contains information about the quick connect configuration settings for a user. The contact flow must be of type Transfer to Agent.</p>', 'refs' => [ 'QuickConnectConfig$UserConfig' => '<p>The user configuration. This is required only if QuickConnectType is USER.</p>', ], ], 'UserSummary' => [ 'base' => '<p>Contains summary information about a user.</p>', 'refs' => [ 'UserSummaryList$member' => NULL, ], ], 'UserSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListUsersResponse$UserSummaryList' => '<p>Information about the users.</p>', ], ], 'Value' => [ 'base' => NULL, 'refs' => [ 'CurrentMetricData$Value' => '<p>The value of the metric.</p>', 'HistoricalMetricData$Value' => '<p>The value of the metric.</p>', ], ], 'VoiceRecordingConfiguration' => [ 'base' => '<p>Contains information about the recording configuration settings.</p>', 'refs' => [ 'StartContactRecordingRequest$VoiceRecordingConfiguration' => '<p>The person being recorded.</p>', ], ], 'VoiceRecordingTrack' => [ 'base' => NULL, 'refs' => [ 'VoiceRecordingConfiguration$VoiceRecordingTrack' => '<p>Identifies which track is being recorded.</p>', ], ], 'timestamp' => [ 'base' => NULL, 'refs' => [ 'AgentInfo$ConnectedToAgentTimestamp' => '<p>The timestamp when the contact was connected to the agent.</p>', 'Contact$InitiationTimestamp' => '<p>The date and time this contact was initiated, in UTC time. For <code>INBOUND</code>, this is when the contact arrived. For <code>OUTBOUND</code>, this is when the agent began dialing. For <code>CALLBACK</code>, this is when the callback contact was created. For <code>TRANSFER</code> and <code>QUEUE_TRANSFER</code>, this is when the transfer was initiated. For <code>API</code>, this is when the request arrived.</p>', 'Contact$DisconnectTimestamp' => '<p>The timestamp when the customer endpoint disconnected from Amazon Connect.</p>', 'Contact$LastUpdateTimestamp' => '<p>The timestamp when contact was last updated.</p>', 'Contact$ScheduledTimestamp' => '<p>The timestamp, in Unix epoch time format, at which to start running the inbound flow. </p>', 'Credentials$AccessTokenExpiration' => '<p>A token generated with an expiration time for the session a user is logged in to Amazon Connect.</p>', 'Credentials$RefreshTokenExpiration' => '<p>Renews the expiration timer for a generated token.</p>', 'GetCurrentMetricDataResponse$DataSnapshotTime' => '<p>The time at which the metrics were retrieved and cached for pagination.</p>', 'GetMetricDataRequest$StartTime' => '<p>The timestamp, in UNIX Epoch time format, at which to start the reporting interval for the retrieval of historical metrics data. The time must be specified using a multiple of 5 minutes, such as 10:05, 10:10, 10:15.</p> <p>The start time cannot be earlier than 24 hours before the time of the request. Historical metrics are available only for 24 hours.</p>', 'GetMetricDataRequest$EndTime' => '<p>The timestamp, in UNIX Epoch time format, at which to end the reporting interval for the retrieval of historical metrics data. The time must be specified using an interval of 5 minutes, such as 11:00, 11:05, 11:10, and must be later than the start time timestamp.</p> <p>The time range between the start and end time must be less than 24 hours.</p>', 'QueueInfo$EnqueueTimestamp' => '<p>The timestamp when the contact was added to the queue.</p>', 'SecurityKey$CreationTime' => '<p>When the security key was created.</p>', ], ], ],];
