<?php
// This file was auto-generated from sdk-root/src/data/athena/2017-05-18/docs-2.json
return [ 'version' => '2.0', 'service' => '<p>Amazon Athena is an interactive query service that lets you use standard SQL to analyze data directly in Amazon S3. You can point Athena at your data in Amazon S3 and run ad-hoc queries and get results in seconds. Athena is serverless, so there is no infrastructure to set up or manage. You pay only for the queries you run. Athena scales automatically—executing queries in parallel—so results are fast, even with large datasets and complex queries. For more information, see <a href="http://docs.aws.amazon.com/athena/latest/ug/what-is.html">What is Amazon Athena</a> in the <i>Amazon Athena User Guide</i>.</p> <p>If you connect to Athena using the JDBC driver, use version 1.1.0 of the driver or later with the Amazon Athena API. Earlier version drivers do not support the API. For more information and to download the driver, see <a href="https://docs.aws.amazon.com/athena/latest/ug/connect-with-jdbc.html">Accessing Amazon Athena with JDBC</a>.</p> <p>For code samples using the Amazon Web Services SDK for Java, see <a href="https://docs.aws.amazon.com/athena/latest/ug/code-samples.html">Examples and Code Samples</a> in the <i>Amazon Athena User Guide</i>.</p>', 'operations' => [ 'BatchGetNamedQuery' => '<p>Returns the details of a single named query or a list of up to 50 queries, which you provide as an array of query ID strings. Requires you to have access to the workgroup in which the queries were saved. Use <a>ListNamedQueriesInput</a> to get the list of named query IDs in the specified workgroup. If information could not be retrieved for a submitted query ID, information about the query ID submitted is listed under <a>UnprocessedNamedQueryId</a>. Named queries differ from executed queries. Use <a>BatchGetQueryExecutionInput</a> to get details about each unique query execution, and <a>ListQueryExecutionsInput</a> to get a list of query execution IDs.</p>', 'BatchGetQueryExecution' => '<p>Returns the details of a single query execution or a list of up to 50 query executions, which you provide as an array of query execution ID strings. Requires you to have access to the workgroup in which the queries ran. To get a list of query execution IDs, use <a>ListQueryExecutionsInput$WorkGroup</a>. Query executions differ from named (saved) queries. Use <a>BatchGetNamedQueryInput</a> to get details about named queries.</p>', 'CreateDataCatalog' => '<p>Creates (registers) a data catalog with the specified name and properties. Catalogs created are visible to all users of the same Amazon Web Services account.</p>', 'CreateNamedQuery' => '<p>Creates a named query in the specified workgroup. Requires that you have access to the workgroup.</p> <p>For code samples using the Amazon Web Services SDK for Java, see <a href="http://docs.aws.amazon.com/athena/latest/ug/code-samples.html">Examples and Code Samples</a> in the <i>Amazon Athena User Guide</i>.</p>', 'CreatePreparedStatement' => '<p>Creates a prepared statement for use with SQL queries in Athena.</p>', 'CreateWorkGroup' => '<p>Creates a workgroup with the specified name.</p>', 'DeleteDataCatalog' => '<p>Deletes a data catalog.</p>', 'DeleteNamedQuery' => '<p>Deletes the named query if you have access to the workgroup in which the query was saved.</p> <p>For code samples using the Amazon Web Services SDK for Java, see <a href="http://docs.aws.amazon.com/athena/latest/ug/code-samples.html">Examples and Code Samples</a> in the <i>Amazon Athena User Guide</i>.</p>', 'DeletePreparedStatement' => '<p>Deletes the prepared statement with the specified name from the specified workgroup.</p>', 'DeleteWorkGroup' => '<p>Deletes the workgroup with the specified name. The primary workgroup cannot be deleted.</p>', 'GetDataCatalog' => '<p>Returns the specified data catalog.</p>', 'GetDatabase' => '<p>Returns a database object for the specified database and data catalog.</p>', 'GetNamedQuery' => '<p>Returns information about a single query. Requires that you have access to the workgroup in which the query was saved.</p>', 'GetPreparedStatement' => '<p>Retrieves the prepared statement with the specified name from the specified workgroup.</p>', 'GetQueryExecution' => '<p>Returns information about a single execution of a query if you have access to the workgroup in which the query ran. Each time a query executes, information about the query execution is saved with a unique ID.</p>', 'GetQueryResults' => '<p>Streams the results of a single query execution specified by <code>QueryExecutionId</code> from the Athena query results location in Amazon S3. For more information, see <a href="https://docs.aws.amazon.com/athena/latest/ug/querying.html">Query Results</a> in the <i>Amazon Athena User Guide</i>. This request does not execute the query but returns results. Use <a>StartQueryExecution</a> to run a query.</p> <p>To stream query results successfully, the IAM principal with permission to call <code>GetQueryResults</code> also must have permissions to the Amazon S3 <code>GetObject</code> action for the Athena query results location.</p> <important> <p>IAM principals with permission to the Amazon S3 <code>GetObject</code> action for the query results location are able to retrieve query results from Amazon S3 even if permission to the <code>GetQueryResults</code> action is denied. To restrict user or role access, ensure that Amazon S3 permissions to the Athena query location are denied.</p> </important>', 'GetTableMetadata' => '<p>Returns table metadata for the specified catalog, database, and table.</p>', 'GetWorkGroup' => '<p>Returns information about the workgroup with the specified name.</p>', 'ListDataCatalogs' => '<p>Lists the data catalogs in the current Amazon Web Services account.</p>', 'ListDatabases' => '<p>Lists the databases in the specified data catalog.</p>', 'ListEngineVersions' => '<p>Returns a list of engine versions that are available to choose from, including the Auto option.</p>', 'ListNamedQueries' => '<p>Provides a list of available query IDs only for queries saved in the specified workgroup. Requires that you have access to the specified workgroup. If a workgroup is not specified, lists the saved queries for the primary workgroup.</p> <p>For code samples using the Amazon Web Services SDK for Java, see <a href="http://docs.aws.amazon.com/athena/latest/ug/code-samples.html">Examples and Code Samples</a> in the <i>Amazon Athena User Guide</i>.</p>', 'ListPreparedStatements' => '<p>Lists the prepared statements in the specfied workgroup.</p>', 'ListQueryExecutions' => '<p>Provides a list of available query execution IDs for the queries in the specified workgroup. If a workgroup is not specified, returns a list of query execution IDs for the primary workgroup. Requires you to have access to the workgroup in which the queries ran.</p> <p>For code samples using the Amazon Web Services SDK for Java, see <a href="http://docs.aws.amazon.com/athena/latest/ug/code-samples.html">Examples and Code Samples</a> in the <i>Amazon Athena User Guide</i>.</p>', 'ListTableMetadata' => '<p>Lists the metadata for the tables in the specified data catalog database.</p>', 'ListTagsForResource' => '<p>Lists the tags associated with an Athena workgroup or data catalog resource.</p>', 'ListWorkGroups' => '<p>Lists available workgroups for the account.</p>', 'StartQueryExecution' => '<p>Runs the SQL query statements contained in the <code>Query</code>. Requires you to have access to the workgroup in which the query ran. Running queries against an external catalog requires <a>GetDataCatalog</a> permission to the catalog. For code samples using the Amazon Web Services SDK for Java, see <a href="http://docs.aws.amazon.com/athena/latest/ug/code-samples.html">Examples and Code Samples</a> in the <i>Amazon Athena User Guide</i>.</p>', 'StopQueryExecution' => '<p>Stops a query execution. Requires you to have access to the workgroup in which the query ran.</p> <p>For code samples using the Amazon Web Services SDK for Java, see <a href="http://docs.aws.amazon.com/athena/latest/ug/code-samples.html">Examples and Code Samples</a> in the <i>Amazon Athena User Guide</i>.</p>', 'TagResource' => '<p>Adds one or more tags to an Athena resource. A tag is a label that you assign to a resource. In Athena, a resource can be a workgroup or data catalog. Each tag consists of a key and an optional value, both of which you define. For example, you can use tags to categorize Athena workgroups or data catalogs by purpose, owner, or environment. Use a consistent set of tag keys to make it easier to search and filter workgroups or data catalogs in your account. For best practices, see <a href="https://aws.amazon.com/answers/account-management/aws-tagging-strategies/">Tagging Best Practices</a>. Tag keys can be from 1 to 128 UTF-8 Unicode characters, and tag values can be from 0 to 256 UTF-8 Unicode characters. Tags can use letters and numbers representable in UTF-8, and the following characters: + - = . _ : / @. Tag keys and values are case-sensitive. Tag keys must be unique per resource. If you specify more than one tag, separate them by commas.</p>', 'UntagResource' => '<p>Removes one or more tags from a data catalog or workgroup resource.</p>', 'UpdateDataCatalog' => '<p>Updates the data catalog that has the specified name.</p>', 'UpdatePreparedStatement' => '<p>Updates a prepared statement.</p>', 'UpdateWorkGroup' => '<p>Updates the workgroup with the specified name. The workgroup\'s name cannot be changed.</p>', ], 'shapes' => [ 'AmazonResourceName' => [ 'base' => NULL, 'refs' => [ 'ListTagsForResourceInput$ResourceARN' => '<p>Lists the tags for the resource with the specified ARN.</p>', 'ResourceNotFoundException$ResourceName' => NULL, 'TagResourceInput$ResourceARN' => '<p>Specifies the ARN of the Athena resource (workgroup or data catalog) to which tags are to be added.</p>', 'UntagResourceInput$ResourceARN' => '<p>Specifies the ARN of the resource from which tags are to be removed.</p>', ], ], 'BatchGetNamedQueryInput' => [ 'base' => NULL, 'refs' => [], ], 'BatchGetNamedQueryOutput' => [ 'base' => NULL, 'refs' => [], ], 'BatchGetQueryExecutionInput' => [ 'base' => NULL, 'refs' => [], ], 'BatchGetQueryExecutionOutput' => [ 'base' => NULL, 'refs' => [], ], 'Boolean' => [ 'base' => NULL, 'refs' => [ 'ColumnInfo$CaseSensitive' => '<p>Indicates whether values in the column are case-sensitive.</p>', ], ], 'BoxedBoolean' => [ 'base' => NULL, 'refs' => [ 'DeleteWorkGroupInput$RecursiveDeleteOption' => '<p>The option to delete the workgroup and its contents even if the workgroup contains any named queries or query executions.</p>', 'ResultConfigurationUpdates$RemoveOutputLocation' => '<p>If set to "true", indicates that the previously-specified query results location (also known as a client-side setting) for queries in this workgroup should be ignored and set to null. If set to "false" or not set, and a value is present in the <code>OutputLocation</code> in <code>ResultConfigurationUpdates</code> (the client-side setting), the <code>OutputLocation</code> in the workgroup\'s <code>ResultConfiguration</code> will be updated with the new value. For more information, see <a href="https://docs.aws.amazon.com/athena/latest/ug/workgroups-settings-override.html">Workgroup Settings Override Client-Side Settings</a>.</p>', 'ResultConfigurationUpdates$RemoveEncryptionConfiguration' => '<p>If set to "true", indicates that the previously-specified encryption configuration (also known as the client-side setting) for queries in this workgroup should be ignored and set to null. If set to "false" or not set, and a value is present in the <code>EncryptionConfiguration</code> in <code>ResultConfigurationUpdates</code> (the client-side setting), the <code>EncryptionConfiguration</code> in the workgroup\'s <code>ResultConfiguration</code> will be updated with the new value. For more information, see <a href="https://docs.aws.amazon.com/athena/latest/ug/workgroups-settings-override.html">Workgroup Settings Override Client-Side Settings</a>.</p>', 'WorkGroupConfiguration$EnforceWorkGroupConfiguration' => '<p>If set to "true", the settings for the workgroup override client-side settings. If set to "false", client-side settings are used. For more information, see <a href="https://docs.aws.amazon.com/athena/latest/ug/workgroups-settings-override.html">Workgroup Settings Override Client-Side Settings</a>.</p>', 'WorkGroupConfiguration$PublishCloudWatchMetricsEnabled' => '<p>Indicates that the Amazon CloudWatch metrics are enabled for the workgroup.</p>', 'WorkGroupConfiguration$RequesterPaysEnabled' => '<p>If set to <code>true</code>, allows members assigned to a workgroup to reference Amazon S3 Requester Pays buckets in queries. If set to <code>false</code>, workgroup members cannot query data from Requester Pays buckets, and queries that retrieve data from Requester Pays buckets cause an error. The default is <code>false</code>. For more information about Requester Pays buckets, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/RequesterPaysBuckets.html">Requester Pays Buckets</a> in the <i>Amazon Simple Storage Service Developer Guide</i>.</p>', 'WorkGroupConfigurationUpdates$EnforceWorkGroupConfiguration' => '<p>If set to "true", the settings for the workgroup override client-side settings. If set to "false" client-side settings are used. For more information, see <a href="https://docs.aws.amazon.com/athena/latest/ug/workgroups-settings-override.html">Workgroup Settings Override Client-Side Settings</a>.</p>', 'WorkGroupConfigurationUpdates$PublishCloudWatchMetricsEnabled' => '<p>Indicates whether this workgroup enables publishing metrics to Amazon CloudWatch.</p>', 'WorkGroupConfigurationUpdates$RemoveBytesScannedCutoffPerQuery' => '<p>Indicates that the data usage control limit per query is removed. <a>WorkGroupConfiguration$BytesScannedCutoffPerQuery</a> </p>', 'WorkGroupConfigurationUpdates$RequesterPaysEnabled' => '<p>If set to <code>true</code>, allows members assigned to a workgroup to specify Amazon S3 Requester Pays buckets in queries. If set to <code>false</code>, workgroup members cannot query data from Requester Pays buckets, and queries that retrieve data from Requester Pays buckets cause an error. The default is <code>false</code>. For more information about Requester Pays buckets, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/RequesterPaysBuckets.html">Requester Pays Buckets</a> in the <i>Amazon Simple Storage Service Developer Guide</i>.</p>', ], ], 'BytesScannedCutoffValue' => [ 'base' => NULL, 'refs' => [ 'WorkGroupConfiguration$BytesScannedCutoffPerQuery' => '<p>The upper data usage limit (cutoff) for the amount of bytes a single query in a workgroup is allowed to scan.</p>', 'WorkGroupConfigurationUpdates$BytesScannedCutoffPerQuery' => '<p>The upper limit (cutoff) for the amount of bytes a single query in a workgroup is allowed to scan.</p>', ], ], 'CatalogNameString' => [ 'base' => NULL, 'refs' => [ 'CreateDataCatalogInput$Name' => '<p>The name of the data catalog to create. The catalog name must be unique for the Amazon Web Services account and can use a maximum of 128 alphanumeric, underscore, at sign, or hyphen characters.</p>', 'DataCatalog$Name' => '<p>The name of the data catalog. The catalog name must be unique for the Amazon Web Services account and can use a maximum of 128 alphanumeric, underscore, at sign, or hyphen characters.</p>', 'DataCatalogSummary$CatalogName' => '<p>The name of the data catalog.</p>', 'DeleteDataCatalogInput$Name' => '<p>The name of the data catalog to delete.</p>', 'GetDataCatalogInput$Name' => '<p>The name of the data catalog to return.</p>', 'GetDatabaseInput$CatalogName' => '<p>The name of the data catalog that contains the database to return.</p>', 'GetTableMetadataInput$CatalogName' => '<p>The name of the data catalog that contains the database and table metadata to return.</p>', 'ListDatabasesInput$CatalogName' => '<p>The name of the data catalog that contains the databases to return.</p>', 'ListTableMetadataInput$CatalogName' => '<p>The name of the data catalog for which table metadata should be returned.</p>', 'QueryExecutionContext$Catalog' => '<p>The name of the data catalog used in the query execution.</p>', 'UpdateDataCatalogInput$Name' => '<p>The name of the data catalog to update. The catalog name must be unique for the Amazon Web Services account and can use a maximum of 128 alphanumeric, underscore, at sign, or hyphen characters.</p>', ], ], 'Column' => [ 'base' => '<p>Contains metadata for a column in a table.</p>', 'refs' => [ 'ColumnList$member' => NULL, ], ], 'ColumnInfo' => [ 'base' => '<p>Information about the columns in a query execution result.</p>', 'refs' => [ 'ColumnInfoList$member' => NULL, ], ], 'ColumnInfoList' => [ 'base' => NULL, 'refs' => [ 'ResultSetMetadata$ColumnInfo' => '<p>Information about the columns returned in a query result metadata.</p>', ], ], 'ColumnList' => [ 'base' => NULL, 'refs' => [ 'TableMetadata$Columns' => '<p>A list of the columns in the table.</p>', 'TableMetadata$PartitionKeys' => '<p>A list of the partition keys in the table.</p>', ], ], 'ColumnNullable' => [ 'base' => NULL, 'refs' => [ 'ColumnInfo$Nullable' => '<p>Indicates the column\'s nullable status.</p>', ], ], 'CommentString' => [ 'base' => NULL, 'refs' => [ 'Column$Comment' => '<p>Optional information about the column.</p>', ], ], 'CreateDataCatalogInput' => [ 'base' => NULL, 'refs' => [], ], 'CreateDataCatalogOutput' => [ 'base' => NULL, 'refs' => [], ], 'CreateNamedQueryInput' => [ 'base' => NULL, 'refs' => [], ], 'CreateNamedQueryOutput' => [ 'base' => NULL, 'refs' => [], ], 'CreatePreparedStatementInput' => [ 'base' => NULL, 'refs' => [], ], 'CreatePreparedStatementOutput' => [ 'base' => NULL, 'refs' => [], ], 'CreateWorkGroupInput' => [ 'base' => NULL, 'refs' => [], ], 'CreateWorkGroupOutput' => [ 'base' => NULL, 'refs' => [], ], 'DataCatalog' => [ 'base' => '<p>Contains information about a data catalog in an Amazon Web Services account.</p>', 'refs' => [ 'GetDataCatalogOutput$DataCatalog' => '<p>The data catalog returned.</p>', ], ], 'DataCatalogSummary' => [ 'base' => '<p>The summary information for the data catalog, which includes its name and type.</p>', 'refs' => [ 'DataCatalogSummaryList$member' => NULL, ], ], 'DataCatalogSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListDataCatalogsOutput$DataCatalogsSummary' => '<p>A summary list of data catalogs.</p>', ], ], 'DataCatalogType' => [ 'base' => NULL, 'refs' => [ 'CreateDataCatalogInput$Type' => '<p>The type of data catalog to create: <code>LAMBDA</code> for a federated catalog, <code>HIVE</code> for an external hive metastore, or <code>GLUE</code> for an Glue Data Catalog.</p>', 'DataCatalog$Type' => '<p>The type of data catalog to create: <code>LAMBDA</code> for a federated catalog, <code>HIVE</code> for an external hive metastore, or <code>GLUE</code> for an Glue Data Catalog.</p>', 'DataCatalogSummary$Type' => '<p>The data catalog type.</p>', 'UpdateDataCatalogInput$Type' => '<p>Specifies the type of data catalog to update. Specify <code>LAMBDA</code> for a federated catalog, <code>HIVE</code> for an external hive metastore, or <code>GLUE</code> for an Glue Data Catalog.</p>', ], ], 'Database' => [ 'base' => '<p>Contains metadata information for a database in a data catalog.</p>', 'refs' => [ 'DatabaseList$member' => NULL, 'GetDatabaseOutput$Database' => '<p>The database returned.</p>', ], ], 'DatabaseList' => [ 'base' => NULL, 'refs' => [ 'ListDatabasesOutput$DatabaseList' => '<p>A list of databases from a data catalog.</p>', ], ], 'DatabaseString' => [ 'base' => NULL, 'refs' => [ 'CreateNamedQueryInput$Database' => '<p>The database to which the query belongs.</p>', 'NamedQuery$Database' => '<p>The database to which the query belongs.</p>', 'QueryExecutionContext$Database' => '<p>The name of the database used in the query execution. The database must exist in the catalog.</p>', ], ], 'Date' => [ 'base' => NULL, 'refs' => [ 'PreparedStatement$LastModifiedTime' => '<p>The last modified time of the prepared statement.</p>', 'PreparedStatementSummary$LastModifiedTime' => '<p>The last modified time of the prepared statement.</p>', 'QueryExecutionStatus$SubmissionDateTime' => '<p>The date and time that the query was submitted.</p>', 'QueryExecutionStatus$CompletionDateTime' => '<p>The date and time that the query completed.</p>', 'WorkGroup$CreationTime' => '<p>The date and time the workgroup was created.</p>', 'WorkGroupSummary$CreationTime' => '<p>The workgroup creation date and time.</p>', ], ], 'Datum' => [ 'base' => '<p>A piece of data (a field in the table).</p>', 'refs' => [ 'datumList$member' => NULL, ], ], 'DeleteDataCatalogInput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteDataCatalogOutput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteNamedQueryInput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteNamedQueryOutput' => [ 'base' => NULL, 'refs' => [], ], 'DeletePreparedStatementInput' => [ 'base' => NULL, 'refs' => [], ], 'DeletePreparedStatementOutput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteWorkGroupInput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteWorkGroupOutput' => [ 'base' => NULL, 'refs' => [], ], 'DescriptionString' => [ 'base' => NULL, 'refs' => [ 'CreateDataCatalogInput$Description' => '<p>A description of the data catalog to be created.</p>', 'CreateNamedQueryInput$Description' => '<p>The query description.</p>', 'CreatePreparedStatementInput$Description' => '<p>The description of the prepared statement.</p>', 'DataCatalog$Description' => '<p>An optional description of the data catalog.</p>', 'Database$Description' => '<p>An optional description of the database.</p>', 'NamedQuery$Description' => '<p>The query description.</p>', 'PreparedStatement$Description' => '<p>The description of the prepared statement.</p>', 'UpdateDataCatalogInput$Description' => '<p>New or modified text that describes the data catalog.</p>', 'UpdatePreparedStatementInput$Description' => '<p>The description of the prepared statement.</p>', ], ], 'EncryptionConfiguration' => [ 'base' => '<p>If query results are encrypted in Amazon S3, indicates the encryption option used (for example, <code>SSE-KMS</code> or <code>CSE-KMS</code>) and key information.</p>', 'refs' => [ 'ResultConfiguration$EncryptionConfiguration' => '<p>If query results are encrypted in Amazon S3, indicates the encryption option used (for example, <code>SSE-KMS</code> or <code>CSE-KMS</code>) and key information. This is a client-side setting. If workgroup settings override client-side settings, then the query uses the encryption configuration that is specified for the workgroup, and also uses the location for storing query results specified in the workgroup. See <a>WorkGroupConfiguration$EnforceWorkGroupConfiguration</a> and <a href="https://docs.aws.amazon.com/athena/latest/ug/workgroups-settings-override.html">Workgroup Settings Override Client-Side Settings</a>.</p>', 'ResultConfigurationUpdates$EncryptionConfiguration' => '<p>The encryption configuration for the query results.</p>', ], ], 'EncryptionOption' => [ 'base' => NULL, 'refs' => [ 'EncryptionConfiguration$EncryptionOption' => '<p>Indicates whether Amazon S3 server-side encryption with Amazon S3-managed keys (<code>SSE-S3</code>), server-side encryption with KMS-managed keys (<code>SSE-KMS</code>), or client-side encryption with KMS-managed keys (CSE-KMS) is used.</p> <p>If a query runs in a workgroup and the workgroup overrides client-side settings, then the workgroup\'s setting for encryption is used. It specifies whether query results must be encrypted, for all queries that run in this workgroup. </p>', ], ], 'EngineVersion' => [ 'base' => '<p>The Athena engine version for running queries.</p>', 'refs' => [ 'EngineVersionsList$member' => NULL, 'QueryExecution$EngineVersion' => '<p>The engine version that executed the query.</p>', 'WorkGroupConfiguration$EngineVersion' => '<p>The engine version that all queries running on the workgroup use. Queries on the <code>AmazonAthenaPreviewFunctionality</code> workgroup run on the preview engine regardless of this setting.</p>', 'WorkGroupConfigurationUpdates$EngineVersion' => '<p>The engine version requested when a workgroup is updated. After the update, all queries on the workgroup run on the requested engine version. If no value was previously set, the default is Auto. Queries on the <code>AmazonAthenaPreviewFunctionality</code> workgroup run on the preview engine regardless of this setting.</p>', 'WorkGroupSummary$EngineVersion' => '<p>The engine version setting for all queries on the workgroup. Queries on the <code>AmazonAthenaPreviewFunctionality</code> workgroup run on the preview engine regardless of this setting.</p>', ], ], 'EngineVersionsList' => [ 'base' => NULL, 'refs' => [ 'ListEngineVersionsOutput$EngineVersions' => '<p>A list of engine versions that are available to choose from.</p>', ], ], 'ErrorCode' => [ 'base' => '<p>The error code returned when the query execution failed to process, or when the processing request for the named query failed.</p>', 'refs' => [ 'InvalidRequestException$AthenaErrorCode' => NULL, 'UnprocessedNamedQueryId$ErrorCode' => '<p>The error code returned when the processing request for the named query failed, if applicable.</p>', 'UnprocessedQueryExecutionId$ErrorCode' => '<p>The error code returned when the query execution failed to process, if applicable.</p>', ], ], 'ErrorMessage' => [ 'base' => NULL, 'refs' => [ 'InternalServerException$Message' => NULL, 'InvalidRequestException$Message' => NULL, 'MetadataException$Message' => NULL, 'ResourceNotFoundException$Message' => NULL, 'TooManyRequestsException$Message' => NULL, 'UnprocessedNamedQueryId$ErrorMessage' => '<p>The error message returned when the processing request for the named query failed, if applicable.</p>', 'UnprocessedQueryExecutionId$ErrorMessage' => '<p>The error message returned when the query execution failed to process, if applicable.</p>', ], ], 'ExpressionString' => [ 'base' => NULL, 'refs' => [ 'ListTableMetadataInput$Expression' => '<p>A regex filter that pattern-matches table names. If no expression is supplied, metadata for all tables are listed.</p>', ], ], 'GetDataCatalogInput' => [ 'base' => NULL, 'refs' => [], ], 'GetDataCatalogOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetDatabaseInput' => [ 'base' => NULL, 'refs' => [], ], 'GetDatabaseOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetNamedQueryInput' => [ 'base' => NULL, 'refs' => [], ], 'GetNamedQueryOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetPreparedStatementInput' => [ 'base' => NULL, 'refs' => [], ], 'GetPreparedStatementOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetQueryExecutionInput' => [ 'base' => NULL, 'refs' => [], ], 'GetQueryExecutionOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetQueryResultsInput' => [ 'base' => NULL, 'refs' => [], ], 'GetQueryResultsOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetTableMetadataInput' => [ 'base' => NULL, 'refs' => [], ], 'GetTableMetadataOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetWorkGroupInput' => [ 'base' => NULL, 'refs' => [], ], 'GetWorkGroupOutput' => [ 'base' => NULL, 'refs' => [], ], 'IdempotencyToken' => [ 'base' => NULL, 'refs' => [ 'CreateNamedQueryInput$ClientRequestToken' => '<p>A unique case-sensitive string used to ensure the request to create the query is idempotent (executes only once). If another <code>CreateNamedQuery</code> request is received, the same response is returned and another query is not created. If a parameter has changed, for example, the <code>QueryString</code>, an error is returned.</p> <important> <p>This token is listed as not required because Amazon Web Services SDKs (for example the Amazon Web Services SDK for Java) auto-generate the token for users. If you are not using the Amazon Web Services SDK or the Amazon Web Services CLI, you must provide this token or the action will fail.</p> </important>', 'StartQueryExecutionInput$ClientRequestToken' => '<p>A unique case-sensitive string used to ensure the request to create the query is idempotent (executes only once). If another <code>StartQueryExecution</code> request is received, the same response is returned and another query is not created. If a parameter has changed, for example, the <code>QueryString</code>, an error is returned.</p> <important> <p>This token is listed as not required because Amazon Web Services SDKs (for example the Amazon Web Services SDK for Java) auto-generate the token for users. If you are not using the Amazon Web Services SDK or the Amazon Web Services CLI, you must provide this token or the action will fail.</p> </important>', ], ], 'Integer' => [ 'base' => NULL, 'refs' => [ 'ColumnInfo$Precision' => '<p>For <code>DECIMAL</code> data types, specifies the total number of digits, up to 38. For performance reasons, we recommend up to 18 digits.</p>', 'ColumnInfo$Scale' => '<p>For <code>DECIMAL</code> data types, specifies the total number of digits in the fractional part of the value. Defaults to 0.</p>', ], ], 'InternalServerException' => [ 'base' => '<p>Indicates a platform issue, which may be due to a transient condition or outage.</p>', 'refs' => [], ], 'InvalidRequestException' => [ 'base' => '<p>Indicates that something is wrong with the input to the request. For example, a required parameter may be missing or out of range.</p>', 'refs' => [], ], 'KeyString' => [ 'base' => NULL, 'refs' => [ 'ParametersMap$key' => NULL, ], ], 'ListDataCatalogsInput' => [ 'base' => NULL, 'refs' => [], ], 'ListDataCatalogsOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListDatabasesInput' => [ 'base' => NULL, 'refs' => [], ], 'ListDatabasesOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListEngineVersionsInput' => [ 'base' => NULL, 'refs' => [], ], 'ListEngineVersionsOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListNamedQueriesInput' => [ 'base' => NULL, 'refs' => [], ], 'ListNamedQueriesOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListPreparedStatementsInput' => [ 'base' => NULL, 'refs' => [], ], 'ListPreparedStatementsOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListQueryExecutionsInput' => [ 'base' => NULL, 'refs' => [], ], 'ListQueryExecutionsOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListTableMetadataInput' => [ 'base' => NULL, 'refs' => [], ], 'ListTableMetadataOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceInput' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListWorkGroupsInput' => [ 'base' => NULL, 'refs' => [], ], 'ListWorkGroupsOutput' => [ 'base' => NULL, 'refs' => [], ], 'Long' => [ 'base' => NULL, 'refs' => [ 'GetQueryResultsOutput$UpdateCount' => '<p>The number of rows inserted with a <code>CREATE TABLE AS SELECT</code> statement. </p>', 'QueryExecutionStatistics$EngineExecutionTimeInMillis' => '<p>The number of milliseconds that the query took to execute.</p>', 'QueryExecutionStatistics$DataScannedInBytes' => '<p>The number of bytes in the data that was queried.</p>', 'QueryExecutionStatistics$TotalExecutionTimeInMillis' => '<p>The number of milliseconds that Athena took to run the query.</p>', 'QueryExecutionStatistics$QueryQueueTimeInMillis' => '<p>The number of milliseconds that the query was in your query queue waiting for resources. Note that if transient errors occur, Athena might automatically add the query back to the queue.</p>', 'QueryExecutionStatistics$QueryPlanningTimeInMillis' => '<p>The number of milliseconds that Athena took to plan the query processing flow. This includes the time spent retrieving table partitions from the data source. Note that because the query engine performs the query planning, query planning time is a subset of engine processing time.</p>', 'QueryExecutionStatistics$ServiceProcessingTimeInMillis' => '<p>The number of milliseconds that Athena took to finalize and publish the query results after the query engine finished running the query.</p>', ], ], 'MaxDataCatalogsCount' => [ 'base' => NULL, 'refs' => [ 'ListDataCatalogsInput$MaxResults' => '<p>Specifies the maximum number of data catalogs to return.</p>', ], ], 'MaxDatabasesCount' => [ 'base' => NULL, 'refs' => [ 'ListDatabasesInput$MaxResults' => '<p>Specifies the maximum number of results to return.</p>', ], ], 'MaxEngineVersionsCount' => [ 'base' => NULL, 'refs' => [ 'ListEngineVersionsInput$MaxResults' => '<p>The maximum number of engine versions to return in this request.</p>', ], ], 'MaxNamedQueriesCount' => [ 'base' => NULL, 'refs' => [ 'ListNamedQueriesInput$MaxResults' => '<p>The maximum number of queries to return in this request.</p>', ], ], 'MaxPreparedStatementsCount' => [ 'base' => NULL, 'refs' => [ 'ListPreparedStatementsInput$MaxResults' => '<p>The maximum number of results to return in this request.</p>', ], ], 'MaxQueryExecutionsCount' => [ 'base' => NULL, 'refs' => [ 'ListQueryExecutionsInput$MaxResults' => '<p>The maximum number of query executions to return in this request.</p>', ], ], 'MaxQueryResults' => [ 'base' => NULL, 'refs' => [ 'GetQueryResultsInput$MaxResults' => '<p>The maximum number of results (rows) to return in this request.</p>', ], ], 'MaxTableMetadataCount' => [ 'base' => NULL, 'refs' => [ 'ListTableMetadataInput$MaxResults' => '<p>Specifies the maximum number of results to return.</p>', ], ], 'MaxTagsCount' => [ 'base' => NULL, 'refs' => [ 'ListTagsForResourceInput$MaxResults' => '<p>The maximum number of results to be returned per request that lists the tags for the resource.</p>', ], ], 'MaxWorkGroupsCount' => [ 'base' => NULL, 'refs' => [ 'ListWorkGroupsInput$MaxResults' => '<p>The maximum number of workgroups to return in this request.</p>', ], ], 'MetadataException' => [ 'base' => '<p>An exception that Athena received when it called a custom metastore. Occurs if the error is not caused by user input (<code>InvalidRequestException</code>) or from the Athena platform (<code>InternalServerException</code>). For example, if a user-created Lambda function is missing permissions, the Lambda <code>4XX</code> exception is returned in a <code>MetadataException</code>.</p>', 'refs' => [], ], 'NameString' => [ 'base' => NULL, 'refs' => [ 'Column$Name' => '<p>The name of the column.</p>', 'CreateNamedQueryInput$Name' => '<p>The query name.</p>', 'Database$Name' => '<p>The name of the database.</p>', 'EngineVersion$SelectedEngineVersion' => '<p>The engine version requested by the user. Possible values are determined by the output of <code>ListEngineVersions</code>, including Auto. The default is Auto.</p>', 'EngineVersion$EffectiveEngineVersion' => '<p>Read only. The engine version on which the query runs. If the user requests a valid engine version other than Auto, the effective engine version is the same as the engine version that the user requested. If the user requests Auto, the effective engine version is chosen by Athena. When a request to update the engine version is made by a <code>CreateWorkGroup</code> or <code>UpdateWorkGroup</code> operation, the <code>EffectiveEngineVersion</code> field is ignored.</p>', 'GetDatabaseInput$DatabaseName' => '<p>The name of the database to return.</p>', 'GetTableMetadataInput$DatabaseName' => '<p>The name of the database that contains the table metadata to return.</p>', 'GetTableMetadataInput$TableName' => '<p>The name of the table for which metadata is returned.</p>', 'ListTableMetadataInput$DatabaseName' => '<p>The name of the database for which table metadata should be returned.</p>', 'NamedQuery$Name' => '<p>The query name.</p>', 'TableMetadata$Name' => '<p>The name of the table.</p>', ], ], 'NamedQuery' => [ 'base' => '<p>A query, where <code>QueryString</code> is the list of SQL query statements that comprise the query.</p>', 'refs' => [ 'GetNamedQueryOutput$NamedQuery' => '<p>Information about the query.</p>', 'NamedQueryList$member' => NULL, ], ], 'NamedQueryId' => [ 'base' => NULL, 'refs' => [ 'CreateNamedQueryOutput$NamedQueryId' => '<p>The unique ID of the query.</p>', 'DeleteNamedQueryInput$NamedQueryId' => '<p>The unique ID of the query to delete.</p>', 'GetNamedQueryInput$NamedQueryId' => '<p>The unique ID of the query. Use <a>ListNamedQueries</a> to get query IDs.</p>', 'NamedQuery$NamedQueryId' => '<p>The unique identifier of the query.</p>', 'NamedQueryIdList$member' => NULL, 'UnprocessedNamedQueryId$NamedQueryId' => '<p>The unique identifier of the named query.</p>', ], ], 'NamedQueryIdList' => [ 'base' => NULL, 'refs' => [ 'BatchGetNamedQueryInput$NamedQueryIds' => '<p>An array of query IDs.</p>', 'ListNamedQueriesOutput$NamedQueryIds' => '<p>The list of unique query IDs.</p>', ], ], 'NamedQueryList' => [ 'base' => NULL, 'refs' => [ 'BatchGetNamedQueryOutput$NamedQueries' => '<p>Information about the named query IDs submitted.</p>', ], ], 'ParametersMap' => [ 'base' => NULL, 'refs' => [ 'CreateDataCatalogInput$Parameters' => '<p>Specifies the Lambda function or functions to use for creating the data catalog. This is a mapping whose values depend on the catalog type. </p> <ul> <li> <p>For the <code>HIVE</code> data catalog type, use the following syntax. The <code>metadata-function</code> parameter is required. <code>The sdk-version</code> parameter is optional and defaults to the currently supported version.</p> <p> <code>metadata-function=<i>lambda_arn</i>, sdk-version=<i>version_number</i> </code> </p> </li> <li> <p>For the <code>LAMBDA</code> data catalog type, use one of the following sets of required parameters, but not both.</p> <ul> <li> <p>If you have one Lambda function that processes metadata and another for reading the actual data, use the following syntax. Both parameters are required.</p> <p> <code>metadata-function=<i>lambda_arn</i>, record-function=<i>lambda_arn</i> </code> </p> </li> <li> <p> If you have a composite Lambda function that processes both metadata and data, use the following syntax to specify your Lambda function.</p> <p> <code>function=<i>lambda_arn</i> </code> </p> </li> </ul> </li> <li> <p>The <code>GLUE</code> type takes a catalog ID parameter and is required. The <code> <i>catalog_id</i> </code> is the account ID of the Amazon Web Services account to which the Glue Data Catalog belongs.</p> <p> <code>catalog-id=<i>catalog_id</i> </code> </p> <ul> <li> <p>The <code>GLUE</code> data catalog type also applies to the default <code>AwsDataCatalog</code> that already exists in your account, of which you can have only one and cannot modify.</p> </li> <li> <p>Queries that specify a Glue Data Catalog other than the default <code>AwsDataCatalog</code> must be run on Athena engine version 2.</p> </li> <li> <p>In Regions where Athena engine version 2 is not available, creating new Glue data catalogs results in an <code>INVALID_INPUT</code> error.</p> </li> </ul> </li> </ul>', 'DataCatalog$Parameters' => '<p>Specifies the Lambda function or functions to use for the data catalog. This is a mapping whose values depend on the catalog type. </p> <ul> <li> <p>For the <code>HIVE</code> data catalog type, use the following syntax. The <code>metadata-function</code> parameter is required. <code>The sdk-version</code> parameter is optional and defaults to the currently supported version.</p> <p> <code>metadata-function=<i>lambda_arn</i>, sdk-version=<i>version_number</i> </code> </p> </li> <li> <p>For the <code>LAMBDA</code> data catalog type, use one of the following sets of required parameters, but not both.</p> <ul> <li> <p>If you have one Lambda function that processes metadata and another for reading the actual data, use the following syntax. Both parameters are required.</p> <p> <code>metadata-function=<i>lambda_arn</i>, record-function=<i>lambda_arn</i> </code> </p> </li> <li> <p> If you have a composite Lambda function that processes both metadata and data, use the following syntax to specify your Lambda function.</p> <p> <code>function=<i>lambda_arn</i> </code> </p> </li> </ul> </li> <li> <p>The <code>GLUE</code> type takes a catalog ID parameter and is required. The <code> <i>catalog_id</i> </code> is the account ID of the Amazon Web Services account to which the Glue catalog belongs.</p> <p> <code>catalog-id=<i>catalog_id</i> </code> </p> <ul> <li> <p>The <code>GLUE</code> data catalog type also applies to the default <code>AwsDataCatalog</code> that already exists in your account, of which you can have only one and cannot modify.</p> </li> <li> <p>Queries that specify a Glue Data Catalog other than the default <code>AwsDataCatalog</code> must be run on Athena engine version 2.</p> </li> </ul> </li> </ul>', 'Database$Parameters' => '<p>A set of custom key/value pairs.</p>', 'TableMetadata$Parameters' => '<p>A set of custom key/value pairs for table properties.</p>', 'UpdateDataCatalogInput$Parameters' => '<p>Specifies the Lambda function or functions to use for updating the data catalog. This is a mapping whose values depend on the catalog type. </p> <ul> <li> <p>For the <code>HIVE</code> data catalog type, use the following syntax. The <code>metadata-function</code> parameter is required. <code>The sdk-version</code> parameter is optional and defaults to the currently supported version.</p> <p> <code>metadata-function=<i>lambda_arn</i>, sdk-version=<i>version_number</i> </code> </p> </li> <li> <p>For the <code>LAMBDA</code> data catalog type, use one of the following sets of required parameters, but not both.</p> <ul> <li> <p>If you have one Lambda function that processes metadata and another for reading the actual data, use the following syntax. Both parameters are required.</p> <p> <code>metadata-function=<i>lambda_arn</i>, record-function=<i>lambda_arn</i> </code> </p> </li> <li> <p> If you have a composite Lambda function that processes both metadata and data, use the following syntax to specify your Lambda function.</p> <p> <code>function=<i>lambda_arn</i> </code> </p> </li> </ul> </li> </ul>', ], ], 'ParametersMapValue' => [ 'base' => NULL, 'refs' => [ 'ParametersMap$value' => NULL, ], ], 'PreparedStatement' => [ 'base' => '<p>A prepared SQL statement for use with Athena.</p>', 'refs' => [ 'GetPreparedStatementOutput$PreparedStatement' => '<p>The name of the prepared statement that was retrieved.</p>', ], ], 'PreparedStatementSummary' => [ 'base' => '<p>The name and last modified time of the prepared statement.</p>', 'refs' => [ 'PreparedStatementsList$member' => NULL, ], ], 'PreparedStatementsList' => [ 'base' => NULL, 'refs' => [ 'ListPreparedStatementsOutput$PreparedStatements' => '<p>The list of prepared statements for the workgroup.</p>', ], ], 'QueryExecution' => [ 'base' => '<p>Information about a single instance of a query execution.</p>', 'refs' => [ 'GetQueryExecutionOutput$QueryExecution' => '<p>Information about the query execution.</p>', 'QueryExecutionList$member' => NULL, ], ], 'QueryExecutionContext' => [ 'base' => '<p>The database and data catalog context in which the query execution occurs.</p>', 'refs' => [ 'QueryExecution$QueryExecutionContext' => '<p>The database in which the query execution occurred.</p>', 'StartQueryExecutionInput$QueryExecutionContext' => '<p>The database within which the query executes.</p>', ], ], 'QueryExecutionId' => [ 'base' => NULL, 'refs' => [ 'GetQueryExecutionInput$QueryExecutionId' => '<p>The unique ID of the query execution.</p>', 'GetQueryResultsInput$QueryExecutionId' => '<p>The unique ID of the query execution.</p>', 'QueryExecution$QueryExecutionId' => '<p>The unique identifier for each query execution.</p>', 'QueryExecutionIdList$member' => NULL, 'StartQueryExecutionOutput$QueryExecutionId' => '<p>The unique ID of the query that ran as a result of this request.</p>', 'StopQueryExecutionInput$QueryExecutionId' => '<p>The unique ID of the query execution to stop.</p>', 'UnprocessedQueryExecutionId$QueryExecutionId' => '<p>The unique identifier of the query execution.</p>', ], ], 'QueryExecutionIdList' => [ 'base' => NULL, 'refs' => [ 'BatchGetQueryExecutionInput$QueryExecutionIds' => '<p>An array of query execution IDs.</p>', 'ListQueryExecutionsOutput$QueryExecutionIds' => '<p>The unique IDs of each query execution as an array of strings.</p>', ], ], 'QueryExecutionList' => [ 'base' => NULL, 'refs' => [ 'BatchGetQueryExecutionOutput$QueryExecutions' => '<p>Information about a query execution.</p>', ], ], 'QueryExecutionState' => [ 'base' => NULL, 'refs' => [ 'QueryExecutionStatus$State' => '<p>The state of query execution. <code>QUEUED</code> indicates that the query has been submitted to the service, and Athena will execute the query as soon as resources are available. <code>RUNNING</code> indicates that the query is in execution phase. <code>SUCCEEDED</code> indicates that the query completed without errors. <code>FAILED</code> indicates that the query experienced an error and did not complete processing. <code>CANCELLED</code> indicates that a user input interrupted query execution.</p> <note> <p>Athena automatically retries your queries in cases of certain transient errors. As a result, you may see the query state transition from <code>RUNNING</code> or <code>FAILED</code> to <code>QUEUED</code>. </p> </note>', ], ], 'QueryExecutionStatistics' => [ 'base' => '<p>The amount of data scanned during the query execution and the amount of time that it took to execute, and the type of statement that was run.</p>', 'refs' => [ 'QueryExecution$Statistics' => '<p>Query execution statistics, such as the amount of data scanned, the amount of time that the query took to process, and the type of statement that was run.</p>', ], ], 'QueryExecutionStatus' => [ 'base' => '<p>The completion date, current state, submission time, and state change reason (if applicable) for the query execution.</p>', 'refs' => [ 'QueryExecution$Status' => '<p>The completion date, current state, submission time, and state change reason (if applicable) for the query execution.</p>', ], ], 'QueryString' => [ 'base' => NULL, 'refs' => [ 'CreateNamedQueryInput$QueryString' => '<p>The contents of the query with all query statements.</p>', 'CreatePreparedStatementInput$QueryStatement' => '<p>The query string for the prepared statement.</p>', 'NamedQuery$QueryString' => '<p>The SQL query statements that comprise the query.</p>', 'PreparedStatement$QueryStatement' => '<p>The query string for the prepared statement.</p>', 'QueryExecution$Query' => '<p>The SQL query statements which the query execution ran.</p>', 'StartQueryExecutionInput$QueryString' => '<p>The SQL query statements to be executed.</p>', 'UpdatePreparedStatementInput$QueryStatement' => '<p>The query string for the prepared statement.</p>', ], ], 'ResourceNotFoundException' => [ 'base' => '<p>A resource, such as a workgroup, was not found.</p>', 'refs' => [], ], 'ResultConfiguration' => [ 'base' => '<p>The location in Amazon S3 where query results are stored and the encryption option, if any, used for query results. These are known as "client-side settings". If workgroup settings override client-side settings, then the query uses the workgroup settings.</p>', 'refs' => [ 'QueryExecution$ResultConfiguration' => '<p>The location in Amazon S3 where query results were stored and the encryption option, if any, used for query results. These are known as "client-side settings". If workgroup settings override client-side settings, then the query uses the location for the query results and the encryption configuration that are specified for the workgroup.</p>', 'StartQueryExecutionInput$ResultConfiguration' => '<p>Specifies information about where and how to save the results of the query execution. If the query runs in a workgroup, then workgroup\'s settings may override query settings. This affects the query results location. The workgroup settings override is specified in EnforceWorkGroupConfiguration (true/false) in the WorkGroupConfiguration. See <a>WorkGroupConfiguration$EnforceWorkGroupConfiguration</a>.</p>', 'WorkGroupConfiguration$ResultConfiguration' => '<p>The configuration for the workgroup, which includes the location in Amazon S3 where query results are stored and the encryption option, if any, used for query results. To run the query, you must specify the query results location using one of the ways: either in the workgroup using this setting, or for individual queries (client-side), using <a>ResultConfiguration$OutputLocation</a>. If none of them is set, Athena issues an error that no output location is provided. For more information, see <a href="https://docs.aws.amazon.com/athena/latest/ug/querying.html">Query Results</a>.</p>', ], ], 'ResultConfigurationUpdates' => [ 'base' => '<p>The information about the updates in the query results, such as output location and encryption configuration for the query results.</p>', 'refs' => [ 'WorkGroupConfigurationUpdates$ResultConfigurationUpdates' => '<p>The result configuration information about the queries in this workgroup that will be updated. Includes the updated results location and an updated option for encrypting query results.</p>', ], ], 'ResultSet' => [ 'base' => '<p>The metadata and rows that comprise a query result set. The metadata describes the column structure and data types. To return a <code>ResultSet</code> object, use <a>GetQueryResults</a>.</p>', 'refs' => [ 'GetQueryResultsOutput$ResultSet' => '<p>The results of the query execution.</p>', ], ], 'ResultSetMetadata' => [ 'base' => '<p>The metadata that describes the column structure and data types of a table of query results. To return a <code>ResultSetMetadata</code> object, use <a>GetQueryResults</a>.</p>', 'refs' => [ 'ResultSet$ResultSetMetadata' => '<p>The metadata that describes the column structure and data types of a table of query results.</p>', ], ], 'Row' => [ 'base' => '<p>The rows that comprise a query result table.</p>', 'refs' => [ 'RowList$member' => NULL, ], ], 'RowList' => [ 'base' => NULL, 'refs' => [ 'ResultSet$Rows' => '<p>The rows in the table.</p>', ], ], 'StartQueryExecutionInput' => [ 'base' => NULL, 'refs' => [], ], 'StartQueryExecutionOutput' => [ 'base' => NULL, 'refs' => [], ], 'StatementName' => [ 'base' => NULL, 'refs' => [ 'CreatePreparedStatementInput$StatementName' => '<p>The name of the prepared statement.</p>', 'DeletePreparedStatementInput$StatementName' => '<p>The name of the prepared statement to delete.</p>', 'GetPreparedStatementInput$StatementName' => '<p>The name of the prepared statement to retrieve.</p>', 'PreparedStatement$StatementName' => '<p>The name of the prepared statement.</p>', 'PreparedStatementSummary$StatementName' => '<p>The name of the prepared statement.</p>', 'UpdatePreparedStatementInput$StatementName' => '<p>The name of the prepared statement.</p>', ], ], 'StatementType' => [ 'base' => NULL, 'refs' => [ 'QueryExecution$StatementType' => '<p>The type of query statement that was run. <code>DDL</code> indicates DDL query statements. <code>DML</code> indicates DML (Data Manipulation Language) query statements, such as <code>CREATE TABLE AS SELECT</code>. <code>UTILITY</code> indicates query statements other than DDL and DML, such as <code>SHOW CREATE TABLE</code>, or <code>DESCRIBE TABLE</code>.</p>', ], ], 'StopQueryExecutionInput' => [ 'base' => NULL, 'refs' => [], ], 'StopQueryExecutionOutput' => [ 'base' => NULL, 'refs' => [], ], 'String' => [ 'base' => NULL, 'refs' => [ 'ColumnInfo$CatalogName' => '<p>The catalog to which the query results belong.</p>', 'ColumnInfo$SchemaName' => '<p>The schema name (database name) to which the query results belong.</p>', 'ColumnInfo$TableName' => '<p>The table name for the query results.</p>', 'ColumnInfo$Name' => '<p>The name of the column.</p>', 'ColumnInfo$Label' => '<p>A column label.</p>', 'ColumnInfo$Type' => '<p>The data type of the column.</p>', 'EncryptionConfiguration$KmsKey' => '<p>For <code>SSE-KMS</code> and <code>CSE-KMS</code>, this is the KMS key ARN or ID.</p>', 'QueryExecutionStatistics$DataManifestLocation' => '<p>The location and file name of a data manifest file. The manifest file is saved to the Athena query results location in Amazon S3. The manifest file tracks files that the query wrote to Amazon S3. If the query fails, the manifest file also tracks files that the query intended to write. The manifest is useful for identifying orphaned files resulting from a failed query. For more information, see <a href="https://docs.aws.amazon.com/athena/latest/ug/querying.html">Working with Query Results, Output Files, and Query History</a> in the <i>Amazon Athena User Guide</i>.</p>', 'QueryExecutionStatus$StateChangeReason' => '<p>Further detail about the status of the query.</p>', 'ResultConfiguration$OutputLocation' => '<p>The location in Amazon S3 where your query results are stored, such as <code>s3://path/to/query/bucket/</code>. To run the query, you must specify the query results location using one of the ways: either for individual queries using either this setting (client-side), or in the workgroup, using <a>WorkGroupConfiguration</a>. If none of them is set, Athena issues an error that no output location is provided. For more information, see <a href="https://docs.aws.amazon.com/athena/latest/ug/querying.html">Query Results</a>. If workgroup settings override client-side settings, then the query uses the settings specified for the workgroup. See <a>WorkGroupConfiguration$EnforceWorkGroupConfiguration</a>.</p>', 'ResultConfigurationUpdates$OutputLocation' => '<p>The location in Amazon S3 where your query results are stored, such as <code>s3://path/to/query/bucket/</code>. For more information, see <a href="https://docs.aws.amazon.com/athena/latest/ug/querying.html">Query Results</a> If workgroup settings override client-side settings, then the query uses the location for the query results and the encryption configuration that are specified for the workgroup. The "workgroup settings override" is specified in <code>EnforceWorkGroupConfiguration</code> (true/false) in the <code>WorkGroupConfiguration</code>. See <a>WorkGroupConfiguration$EnforceWorkGroupConfiguration</a>.</p>', ], ], 'TableMetadata' => [ 'base' => '<p>Contains metadata for a table.</p>', 'refs' => [ 'GetTableMetadataOutput$TableMetadata' => '<p>An object that contains table metadata.</p>', 'TableMetadataList$member' => NULL, ], ], 'TableMetadataList' => [ 'base' => NULL, 'refs' => [ 'ListTableMetadataOutput$TableMetadataList' => '<p>A list of table metadata.</p>', ], ], 'TableTypeString' => [ 'base' => NULL, 'refs' => [ 'TableMetadata$TableType' => '<p>The type of table. In Athena, only <code>EXTERNAL_TABLE</code> is supported.</p>', ], ], 'Tag' => [ 'base' => '<p>A label that you assign to a resource. In Athena, a resource can be a workgroup or data catalog. Each tag consists of a key and an optional value, both of which you define. For example, you can use tags to categorize Athena workgroups or data catalogs by purpose, owner, or environment. Use a consistent set of tag keys to make it easier to search and filter workgroups or data catalogs in your account. For best practices, see <a href="https://aws.amazon.com/answers/account-management/aws-tagging-strategies/">Tagging Best Practices</a>. Tag keys can be from 1 to 128 UTF-8 Unicode characters, and tag values can be from 0 to 256 UTF-8 Unicode characters. Tags can use letters and numbers representable in UTF-8, and the following characters: + - = . _ : / @. Tag keys and values are case-sensitive. Tag keys must be unique per resource. If you specify more than one tag, separate them by commas. </p>', 'refs' => [ 'TagList$member' => NULL, ], ], 'TagKey' => [ 'base' => NULL, 'refs' => [ 'Tag$Key' => '<p>A tag key. The tag key length is from 1 to 128 Unicode characters in UTF-8. You can use letters and numbers representable in UTF-8, and the following characters: + - = . _ : / @. Tag keys are case-sensitive and must be unique per resource. </p>', 'TagKeyList$member' => NULL, ], ], 'TagKeyList' => [ 'base' => NULL, 'refs' => [ 'UntagResourceInput$TagKeys' => '<p>A comma-separated list of one or more tag keys whose tags are to be removed from the specified resource.</p>', ], ], 'TagList' => [ 'base' => NULL, 'refs' => [ 'CreateDataCatalogInput$Tags' => '<p>A list of comma separated tags to add to the data catalog that is created.</p>', 'CreateWorkGroupInput$Tags' => '<p>A list of comma separated tags to add to the workgroup that is created.</p>', 'ListTagsForResourceOutput$Tags' => '<p>The list of tags associated with the specified resource.</p>', 'TagResourceInput$Tags' => '<p>A collection of one or more tags, separated by commas, to be added to an Athena workgroup or data catalog resource.</p>', ], ], 'TagResourceInput' => [ 'base' => NULL, 'refs' => [], ], 'TagResourceOutput' => [ 'base' => NULL, 'refs' => [], ], 'TagValue' => [ 'base' => NULL, 'refs' => [ 'Tag$Value' => '<p>A tag value. The tag value length is from 0 to 256 Unicode characters in UTF-8. You can use letters and numbers representable in UTF-8, and the following characters: + - = . _ : / @. Tag values are case-sensitive. </p>', ], ], 'ThrottleReason' => [ 'base' => '<p>The reason for the query throttling, for example, when it exceeds the concurrent query limit.</p>', 'refs' => [ 'TooManyRequestsException$Reason' => NULL, ], ], 'Timestamp' => [ 'base' => NULL, 'refs' => [ 'TableMetadata$CreateTime' => '<p>The time that the table was created.</p>', 'TableMetadata$LastAccessTime' => '<p>The last time the table was accessed.</p>', ], ], 'Token' => [ 'base' => NULL, 'refs' => [ 'GetQueryResultsInput$NextToken' => '<p>A token generated by the Athena service that specifies where to continue pagination if a previous request was truncated. To obtain the next set of pages, pass in the <code>NextToken</code> from the response object of the previous page call.</p>', 'GetQueryResultsOutput$NextToken' => '<p>A token generated by the Athena service that specifies where to continue pagination if a previous request was truncated. To obtain the next set of pages, pass in the <code>NextToken</code> from the response object of the previous page call.</p>', 'ListDataCatalogsInput$NextToken' => '<p>A token generated by the Athena service that specifies where to continue pagination if a previous request was truncated. To obtain the next set of pages, pass in the NextToken from the response object of the previous page call.</p>', 'ListDataCatalogsOutput$NextToken' => '<p>A token generated by the Athena service that specifies where to continue pagination if a previous request was truncated. To obtain the next set of pages, pass in the NextToken from the response object of the previous page call.</p>', 'ListDatabasesInput$NextToken' => '<p>A token generated by the Athena service that specifies where to continue pagination if a previous request was truncated. To obtain the next set of pages, pass in the <code>NextToken</code> from the response object of the previous page call.</p>', 'ListDatabasesOutput$NextToken' => '<p>A token generated by the Athena service that specifies where to continue pagination if a previous request was truncated. To obtain the next set of pages, pass in the NextToken from the response object of the previous page call.</p>', 'ListEngineVersionsInput$NextToken' => '<p>A token generated by the Athena service that specifies where to continue pagination if a previous request was truncated. To obtain the next set of pages, pass in the <code>NextToken</code> from the response object of the previous page call.</p>', 'ListEngineVersionsOutput$NextToken' => '<p>A token generated by the Athena service that specifies where to continue pagination if a previous request was truncated. To obtain the next set of pages, pass in the <code>NextToken</code> from the response object of the previous page call.</p>', 'ListNamedQueriesInput$NextToken' => '<p>A token generated by the Athena service that specifies where to continue pagination if a previous request was truncated. To obtain the next set of pages, pass in the <code>NextToken</code> from the response object of the previous page call.</p>', 'ListNamedQueriesOutput$NextToken' => '<p>A token generated by the Athena service that specifies where to continue pagination if a previous request was truncated. To obtain the next set of pages, pass in the <code>NextToken</code> from the response object of the previous page call.</p>', 'ListPreparedStatementsInput$NextToken' => '<p>A token generated by the Athena service that specifies where to continue pagination if a previous request was truncated. To obtain the next set of pages, pass in the <code>NextToken</code> from the response object of the previous page call.</p>', 'ListPreparedStatementsOutput$NextToken' => '<p>A token generated by the Athena service that specifies where to continue pagination if a previous request was truncated. To obtain the next set of pages, pass in the <code>NextToken</code> from the response object of the previous page call.</p>', 'ListQueryExecutionsInput$NextToken' => '<p>A token generated by the Athena service that specifies where to continue pagination if a previous request was truncated. To obtain the next set of pages, pass in the <code>NextToken</code> from the response object of the previous page call.</p>', 'ListQueryExecutionsOutput$NextToken' => '<p>A token to be used by the next request if this request is truncated.</p>', 'ListTableMetadataInput$NextToken' => '<p>A token generated by the Athena service that specifies where to continue pagination if a previous request was truncated. To obtain the next set of pages, pass in the NextToken from the response object of the previous page call.</p>', 'ListTableMetadataOutput$NextToken' => '<p>A token generated by the Athena service that specifies where to continue pagination if a previous request was truncated. To obtain the next set of pages, pass in the NextToken from the response object of the previous page call.</p>', 'ListTagsForResourceInput$NextToken' => '<p>The token for the next set of results, or null if there are no additional results for this request, where the request lists the tags for the resource with the specified ARN.</p>', 'ListTagsForResourceOutput$NextToken' => '<p>A token to be used by the next request if this request is truncated.</p>', 'ListWorkGroupsInput$NextToken' => '<p>A token generated by the Athena service that specifies where to continue pagination if a previous request was truncated. To obtain the next set of pages, pass in the <code>NextToken</code> from the response object of the previous page call.</p>', 'ListWorkGroupsOutput$NextToken' => '<p>A token generated by the Athena service that specifies where to continue pagination if a previous request was truncated. To obtain the next set of pages, pass in the <code>NextToken</code> from the response object of the previous page call.</p>', ], ], 'TooManyRequestsException' => [ 'base' => '<p>Indicates that the request was throttled.</p>', 'refs' => [], ], 'TypeString' => [ 'base' => NULL, 'refs' => [ 'Column$Type' => '<p>The data type of the column.</p>', ], ], 'UnprocessedNamedQueryId' => [ 'base' => '<p>Information about a named query ID that could not be processed.</p>', 'refs' => [ 'UnprocessedNamedQueryIdList$member' => NULL, ], ], 'UnprocessedNamedQueryIdList' => [ 'base' => NULL, 'refs' => [ 'BatchGetNamedQueryOutput$UnprocessedNamedQueryIds' => '<p>Information about provided query IDs.</p>', ], ], 'UnprocessedQueryExecutionId' => [ 'base' => '<p>Describes a query execution that failed to process.</p>', 'refs' => [ 'UnprocessedQueryExecutionIdList$member' => NULL, ], ], 'UnprocessedQueryExecutionIdList' => [ 'base' => NULL, 'refs' => [ 'BatchGetQueryExecutionOutput$UnprocessedQueryExecutionIds' => '<p>Information about the query executions that failed to run.</p>', ], ], 'UntagResourceInput' => [ 'base' => NULL, 'refs' => [], ], 'UntagResourceOutput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateDataCatalogInput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateDataCatalogOutput' => [ 'base' => NULL, 'refs' => [], ], 'UpdatePreparedStatementInput' => [ 'base' => NULL, 'refs' => [], ], 'UpdatePreparedStatementOutput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateWorkGroupInput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateWorkGroupOutput' => [ 'base' => NULL, 'refs' => [], ], 'WorkGroup' => [ 'base' => '<p>A workgroup, which contains a name, description, creation time, state, and other configuration, listed under <a>WorkGroup$Configuration</a>. Each workgroup enables you to isolate queries for you or your group of users from other queries in the same account, to configure the query results location and the encryption configuration (known as workgroup settings), to enable sending query metrics to Amazon CloudWatch, and to establish per-query data usage control limits for all queries in a workgroup. The workgroup settings override is specified in <code>EnforceWorkGroupConfiguration</code> (true/false) in the <code>WorkGroupConfiguration</code>. See <a>WorkGroupConfiguration$EnforceWorkGroupConfiguration</a>.</p>', 'refs' => [ 'GetWorkGroupOutput$WorkGroup' => '<p>Information about the workgroup.</p>', ], ], 'WorkGroupConfiguration' => [ 'base' => '<p>The configuration of the workgroup, which includes the location in Amazon S3 where query results are stored, the encryption option, if any, used for query results, whether the Amazon CloudWatch Metrics are enabled for the workgroup and whether workgroup settings override query settings, and the data usage limits for the amount of data scanned per query or per workgroup. The workgroup settings override is specified in <code>EnforceWorkGroupConfiguration</code> (true/false) in the <code>WorkGroupConfiguration</code>. See <a>WorkGroupConfiguration$EnforceWorkGroupConfiguration</a>. </p>', 'refs' => [ 'CreateWorkGroupInput$Configuration' => '<p>The configuration for the workgroup, which includes the location in Amazon S3 where query results are stored, the encryption configuration, if any, used for encrypting query results, whether the Amazon CloudWatch Metrics are enabled for the workgroup, the limit for the amount of bytes scanned (cutoff) per query, if it is specified, and whether workgroup\'s settings (specified with <code>EnforceWorkGroupConfiguration</code>) in the <code>WorkGroupConfiguration</code> override client-side settings. See <a>WorkGroupConfiguration$EnforceWorkGroupConfiguration</a>.</p>', 'WorkGroup$Configuration' => '<p>The configuration of the workgroup, which includes the location in Amazon S3 where query results are stored, the encryption configuration, if any, used for query results; whether the Amazon CloudWatch Metrics are enabled for the workgroup; whether workgroup settings override client-side settings; and the data usage limits for the amount of data scanned per query or per workgroup. The workgroup settings override is specified in <code>EnforceWorkGroupConfiguration</code> (true/false) in the <code>WorkGroupConfiguration</code>. See <a>WorkGroupConfiguration$EnforceWorkGroupConfiguration</a>.</p>', ], ], 'WorkGroupConfigurationUpdates' => [ 'base' => '<p>The configuration information that will be updated for this workgroup, which includes the location in Amazon S3 where query results are stored, the encryption option, if any, used for query results, whether the Amazon CloudWatch Metrics are enabled for the workgroup, whether the workgroup settings override the client-side settings, and the data usage limit for the amount of bytes scanned per query, if it is specified.</p>', 'refs' => [ 'UpdateWorkGroupInput$ConfigurationUpdates' => '<p>The workgroup configuration that will be updated for the given workgroup.</p>', ], ], 'WorkGroupDescriptionString' => [ 'base' => NULL, 'refs' => [ 'CreateWorkGroupInput$Description' => '<p>The workgroup description.</p>', 'UpdateWorkGroupInput$Description' => '<p>The workgroup description.</p>', 'WorkGroup$Description' => '<p>The workgroup description.</p>', 'WorkGroupSummary$Description' => '<p>The workgroup description.</p>', ], ], 'WorkGroupName' => [ 'base' => NULL, 'refs' => [ 'CreateNamedQueryInput$WorkGroup' => '<p>The name of the workgroup in which the named query is being created.</p>', 'CreatePreparedStatementInput$WorkGroup' => '<p>The name of the workgroup to which the prepared statement belongs.</p>', 'CreateWorkGroupInput$Name' => '<p>The workgroup name.</p>', 'DeletePreparedStatementInput$WorkGroup' => '<p>The workgroup to which the statement to be deleted belongs.</p>', 'DeleteWorkGroupInput$WorkGroup' => '<p>The unique name of the workgroup to delete.</p>', 'GetPreparedStatementInput$WorkGroup' => '<p>The workgroup to which the statement to be retrieved belongs.</p>', 'GetWorkGroupInput$WorkGroup' => '<p>The name of the workgroup.</p>', 'ListNamedQueriesInput$WorkGroup' => '<p>The name of the workgroup from which the named queries are being returned. If a workgroup is not specified, the saved queries for the primary workgroup are returned.</p>', 'ListPreparedStatementsInput$WorkGroup' => '<p>The workgroup to list the prepared statements for.</p>', 'ListQueryExecutionsInput$WorkGroup' => '<p>The name of the workgroup from which queries are being returned. If a workgroup is not specified, a list of available query execution IDs for the queries in the primary workgroup is returned.</p>', 'NamedQuery$WorkGroup' => '<p>The name of the workgroup that contains the named query.</p>', 'PreparedStatement$WorkGroupName' => '<p>The name of the workgroup to which the prepared statement belongs.</p>', 'QueryExecution$WorkGroup' => '<p>The name of the workgroup in which the query ran.</p>', 'StartQueryExecutionInput$WorkGroup' => '<p>The name of the workgroup in which the query is being started.</p>', 'UpdatePreparedStatementInput$WorkGroup' => '<p>The workgroup for the prepared statement.</p>', 'UpdateWorkGroupInput$WorkGroup' => '<p>The specified workgroup that will be updated.</p>', 'WorkGroup$Name' => '<p>The workgroup name.</p>', 'WorkGroupSummary$Name' => '<p>The name of the workgroup.</p>', ], ], 'WorkGroupState' => [ 'base' => NULL, 'refs' => [ 'UpdateWorkGroupInput$State' => '<p>The workgroup state that will be updated for the given workgroup.</p>', 'WorkGroup$State' => '<p>The state of the workgroup: ENABLED or DISABLED.</p>', 'WorkGroupSummary$State' => '<p>The state of the workgroup.</p>', ], ], 'WorkGroupSummary' => [ 'base' => '<p>The summary information for the workgroup, which includes its name, state, description, and the date and time it was created.</p>', 'refs' => [ 'WorkGroupsList$member' => NULL, ], ], 'WorkGroupsList' => [ 'base' => NULL, 'refs' => [ 'ListWorkGroupsOutput$WorkGroups' => '<p>A list of <a>WorkGroupSummary</a> objects that include the names, descriptions, creation times, and states for each workgroup.</p>', ], ], 'datumList' => [ 'base' => NULL, 'refs' => [ 'Row$Data' => '<p>The data that populates a row in a query result table.</p>', ], ], 'datumString' => [ 'base' => NULL, 'refs' => [ 'Datum$VarCharValue' => '<p>The value of the datum.</p>', ], ], ],];
