<?php
// This file was auto-generated from sdk-root/src/data/transcribe/2017-10-26/docs-2.json
return [ 'version' => '2.0', 'service' => '<p>Operations and objects for transcribing speech to text.</p>', 'operations' => [ 'CreateCallAnalyticsCategory' => '<p>Creates an analytics category. Amazon Transcribe applies the conditions specified by your analytics categories to your call analytics jobs. For each analytics category, you specify one or more rules. For example, you can specify a rule that the customer sentiment was neutral or negative within that category. If you start a call analytics job, Amazon Transcribe applies the category to the analytics job that you\'ve specified.</p>', 'CreateLanguageModel' => '<p>Creates a new custom language model. Use Amazon S3 prefixes to provide the location of your input files. The time it takes to create your model depends on the size of your training data.</p>', 'CreateMedicalVocabulary' => '<p>Creates a new custom vocabulary that you can use to modify how Amazon Transcribe Medical transcribes your audio file.</p>', 'CreateVocabulary' => '<p>Creates a new custom vocabulary that you can use to change the way Amazon Transcribe handles transcription of an audio file.</p>', 'CreateVocabularyFilter' => '<p>Creates a new vocabulary filter that you can use to filter words, such as profane words, from the output of a transcription job.</p>', 'DeleteCallAnalyticsCategory' => '<p>Deletes a call analytics category using its name.</p>', 'DeleteCallAnalyticsJob' => '<p>Deletes a call analytics job using its name.</p>', 'DeleteLanguageModel' => '<p>Deletes a custom language model using its name.</p>', 'DeleteMedicalTranscriptionJob' => '<p>Deletes a transcription job generated by Amazon Transcribe Medical and any related information.</p>', 'DeleteMedicalVocabulary' => '<p>Deletes a vocabulary from Amazon Transcribe Medical.</p>', 'DeleteTranscriptionJob' => '<p>Deletes a previously submitted transcription job along with any other generated results such as the transcription, models, and so on.</p>', 'DeleteVocabulary' => '<p>Deletes a vocabulary from Amazon Transcribe. </p>', 'DeleteVocabularyFilter' => '<p>Removes a vocabulary filter.</p>', 'DescribeLanguageModel' => '<p>Gets information about a single custom language model. Use this information to see details about the language model in your Amazon Web Services account. You can also see whether the base language model used to create your custom language model has been updated. If Amazon Transcribe has updated the base model, you can create a new custom language model using the updated base model. If the language model wasn\'t created, you can use this operation to understand why Amazon Transcribe couldn\'t create it. </p>', 'GetCallAnalyticsCategory' => '<p>Retrieves information about a call analytics category.</p>', 'GetCallAnalyticsJob' => '<p>Returns information about a call analytics job. To see the status of the job, check the <code>CallAnalyticsJobStatus</code> field. If the status is <code>COMPLETED</code>, the job is finished and you can find the results at the location specified in the <code>TranscriptFileUri</code> field. If you enable personally identifiable information (PII) redaction, the redacted transcript appears in the <code>RedactedTranscriptFileUri</code> field.</p>', 'GetMedicalTranscriptionJob' => '<p>Returns information about a transcription job from Amazon Transcribe Medical. To see the status of the job, check the <code>TranscriptionJobStatus</code> field. If the status is <code>COMPLETED</code>, the job is finished. You find the results of the completed job in the <code>TranscriptFileUri</code> field.</p>', 'GetMedicalVocabulary' => '<p>Retrieves information about a medical vocabulary.</p>', 'GetTranscriptionJob' => '<p>Returns information about a transcription job. To see the status of the job, check the <code>TranscriptionJobStatus</code> field. If the status is <code>COMPLETED</code>, the job is finished and you can find the results at the location specified in the <code>TranscriptFileUri</code> field. If you enable content redaction, the redacted transcript appears in <code>RedactedTranscriptFileUri</code>.</p>', 'GetVocabulary' => '<p>Gets information about a vocabulary. </p>', 'GetVocabularyFilter' => '<p>Returns information about a vocabulary filter.</p>', 'ListCallAnalyticsCategories' => '<p>Provides more information about the call analytics categories that you\'ve created. You can use the information in this list to find a specific category. You can then use the operation to get more information about it.</p>', 'ListCallAnalyticsJobs' => '<p>List call analytics jobs with a specified status or substring that matches their names.</p>', 'ListLanguageModels' => '<p>Provides more information about the custom language models you\'ve created. You can use the information in this list to find a specific custom language model. You can then use the operation to get more information about it.</p>', 'ListMedicalTranscriptionJobs' => '<p>Lists medical transcription jobs with a specified status or substring that matches their names.</p>', 'ListMedicalVocabularies' => '<p>Returns a list of vocabularies that match the specified criteria. If you don\'t enter a value in any of the request parameters, returns the entire list of vocabularies.</p>', 'ListTagsForResource' => '<p>Lists all tags associated with a given transcription job, vocabulary, or resource.</p>', 'ListTranscriptionJobs' => '<p>Lists transcription jobs with the specified status.</p>', 'ListVocabularies' => '<p>Returns a list of vocabularies that match the specified criteria. If no criteria are specified, returns the entire list of vocabularies.</p>', 'ListVocabularyFilters' => '<p>Gets information about vocabulary filters.</p>', 'StartCallAnalyticsJob' => '<p>Starts an asynchronous analytics job that not only transcribes the audio recording of a caller and agent, but also returns additional insights. These insights include how quickly or loudly the caller or agent was speaking. To retrieve additional insights with your analytics jobs, create categories. A category is a way to classify analytics jobs based on attributes, such as a customer\'s sentiment or a particular phrase being used during the call. For more information, see the operation. </p>', 'StartMedicalTranscriptionJob' => '<p>Starts a batch job to transcribe medical speech to text.</p>', 'StartTranscriptionJob' => '<p>Starts an asynchronous job to transcribe speech to text.</p>', 'TagResource' => '<p>Tags a Amazon Transcribe resource with the given list of tags.</p>', 'UntagResource' => '<p>Removes specified tags from a specified Amazon Transcribe resource.</p>', 'UpdateCallAnalyticsCategory' => '<p>Updates the call analytics category with new values. The <code>UpdateCallAnalyticsCategory</code> operation overwrites all of the existing information with the values that you provide in the request. </p>', 'UpdateMedicalVocabulary' => '<p>Updates a vocabulary with new values that you provide in a different text file from the one you used to create the vocabulary. The <code>UpdateMedicalVocabulary</code> operation overwrites all of the existing information with the values that you provide in the request.</p>', 'UpdateVocabulary' => '<p>Updates an existing vocabulary with new values. The <code>UpdateVocabulary</code> operation overwrites all of the existing information with the values that you provide in the request. </p>', 'UpdateVocabularyFilter' => '<p>Updates a vocabulary filter with a new list of filtered words.</p>', ], 'shapes' => [ 'AbsoluteTimeRange' => [ 'base' => '<p>A time range, set in seconds, between two points in the call.</p>', 'refs' => [ 'InterruptionFilter$AbsoluteTimeRange' => '<p>An object you can use to specify a time range (in milliseconds) for when you\'d want to find the interruption. For example, you could search for an interruption between the 30,000 millisecond mark and the 45,000 millisecond mark. You could also specify the time period as the first 15,000 milliseconds or the last 15,000 milliseconds. </p>', 'NonTalkTimeFilter$AbsoluteTimeRange' => '<p>An object you can use to specify a time range (in milliseconds) for when no one is talking. For example, you could specify a time period between the 30,000 millisecond mark and the 45,000 millisecond mark. You could also specify the time period as the first 15,000 milliseconds or the last 15,000 milliseconds.</p>', 'SentimentFilter$AbsoluteTimeRange' => '<p>The time range, measured in seconds, of the sentiment.</p>', 'TranscriptFilter$AbsoluteTimeRange' => '<p>A time range, set in seconds, between two points in the call.</p>', ], ], 'BadRequestException' => [ 'base' => '<p>Your request didn\'t pass one or more validation tests. For example, if the entity that you\'re trying to delete doesn\'t exist or if it is in a non-terminal state (for example, it\'s "in progress"). See the exception <code>Message</code> field for more information.</p>', 'refs' => [], ], 'BaseModelName' => [ 'base' => NULL, 'refs' => [ 'CreateLanguageModelRequest$BaseModelName' => '<p>The Amazon Transcribe standard language model, or base model used to create your custom language model.</p> <p>If you want to use your custom language model to transcribe audio with a sample rate of 16,000 Hz or greater, choose <code>Wideband</code>.</p> <p>If you want to use your custom language model to transcribe audio with a sample rate that is less than 16,000 Hz, choose <code>Narrowband</code>.</p>', 'CreateLanguageModelResponse$BaseModelName' => '<p>The Amazon Transcribe standard language model, or base model you\'ve used to create a custom language model.</p>', 'LanguageModel$BaseModelName' => '<p>The Amazon Transcribe standard language model, or base model used to create the custom language model.</p>', ], ], 'Boolean' => [ 'base' => NULL, 'refs' => [ 'InterruptionFilter$Negate' => '<p>Set to <code>TRUE</code> to look for a time period where there was no interruption.</p>', 'JobExecutionSettings$AllowDeferredExecution' => '<p>Indicates whether a job should be queued by Amazon Transcribe when the concurrent execution limit is exceeded. When the <code>AllowDeferredExecution</code> field is true, jobs are queued and executed when the number of executing jobs falls below the concurrent execution limit. If the field is false, Amazon Transcribe returns a <code>LimitExceededException</code> exception.</p> <p>Note that job queuing is enabled by default for call analytics jobs.</p> <p>If you specify the <code>AllowDeferredExecution</code> field, you must specify the <code>DataAccessRoleArn</code> field.</p>', 'LanguageModel$UpgradeAvailability' => '<p>Whether the base model used for the custom language model is up to date. If this field is <code>true</code> then you are running the most up-to-date version of the base model in your custom language model.</p>', 'MedicalTranscriptionSetting$ShowSpeakerLabels' => '<p>Determines whether the transcription job uses speaker recognition to identify different speakers in the input audio. Speaker recognition labels individual speakers in the audio file. If you set the <code>ShowSpeakerLabels</code> field to true, you must also set the maximum number of speaker labels in the <code>MaxSpeakerLabels</code> field.</p> <p>You can\'t set both <code>ShowSpeakerLabels</code> and <code>ChannelIdentification</code> in the same request. If you set both, your request returns a <code>BadRequestException</code>.</p>', 'MedicalTranscriptionSetting$ChannelIdentification' => '<p>Instructs Amazon Transcribe Medical to process each audio channel separately and then merge the transcription output of each channel into a single transcription.</p> <p>Amazon Transcribe Medical also produces a transcription of each item detected on an audio channel, including the start time and end time of the item and alternative transcriptions of item. The alternative transcriptions also come with confidence scores provided by Amazon Transcribe Medical.</p> <p>You can\'t set both <code>ShowSpeakerLabels</code> and <code>ChannelIdentification</code> in the same request. If you set both, your request returns a <code>BadRequestException</code> </p>', 'MedicalTranscriptionSetting$ShowAlternatives' => '<p>Determines whether alternative transcripts are generated along with the transcript that has the highest confidence. If you set <code>ShowAlternatives</code> field to true, you must also set the maximum number of alternatives to return in the <code>MaxAlternatives</code> field.</p>', 'NonTalkTimeFilter$Negate' => '<p>Set to <code>TRUE</code> to look for a time period when people were talking.</p>', 'SentimentFilter$Negate' => '<p>Set to <code>TRUE</code> to look for sentiments that weren\'t specified in the request. </p>', 'Settings$ShowSpeakerLabels' => '<p>Determines whether the transcription job uses speaker recognition to identify different speakers in the input audio. Speaker recognition labels individual speakers in the audio file. If you set the <code>ShowSpeakerLabels</code> field to true, you must also set the maximum number of speaker labels <code>MaxSpeakerLabels</code> field.</p> <p>You can\'t set both <code>ShowSpeakerLabels</code> and <code>ChannelIdentification</code> in the same request. If you set both, your request returns a <code>BadRequestException</code>.</p>', 'Settings$ChannelIdentification' => '<p>Instructs Amazon Transcribe to process each audio channel separately and then merge the transcription output of each channel into a single transcription. </p> <p>Amazon Transcribe also produces a transcription of each item detected on an audio channel, including the start time and end time of the item and alternative transcriptions of the item including the confidence that Amazon Transcribe has in the transcription.</p> <p>You can\'t set both <code>ShowSpeakerLabels</code> and <code>ChannelIdentification</code> in the same request. If you set both, your request returns a <code>BadRequestException</code>.</p>', 'Settings$ShowAlternatives' => '<p>Determines whether the transcription contains alternative transcriptions. If you set the <code>ShowAlternatives</code> field to true, you must also set the maximum number of alternatives to return in the <code>MaxAlternatives</code> field.</p>', 'StartTranscriptionJobRequest$IdentifyLanguage' => '<p>Set this field to <code>true</code> to enable automatic language identification. Automatic language identification is disabled by default. You receive a <code>BadRequestException</code> error if you enter a value for a <code>LanguageCode</code>.</p>', 'TranscriptFilter$Negate' => '<p>If <code>TRUE</code>, the rule that you specify is applied to everything except for the phrases that you specify.</p>', 'TranscriptionJob$IdentifyLanguage' => '<p>A value that shows if automatic language identification was enabled for a transcription job.</p>', 'TranscriptionJobSummary$IdentifyLanguage' => '<p>Whether automatic language identification was enabled for a transcription job.</p>', ], ], 'CLMLanguageCode' => [ 'base' => NULL, 'refs' => [ 'CreateLanguageModelRequest$LanguageCode' => '<p>The language of the input text you\'re using to train your custom language model.</p>', 'CreateLanguageModelResponse$LanguageCode' => '<p>The language code of the text you\'ve used to create a custom language model.</p>', 'LanguageModel$LanguageCode' => '<p>The language code you used to create your custom language model.</p>', ], ], 'CallAnalyticsJob' => [ 'base' => '<p>Describes an asynchronous analytics job that was created with the <code>StartAnalyticsJob</code> operation.</p>', 'refs' => [ 'GetCallAnalyticsJobResponse$CallAnalyticsJob' => '<p>An object that contains the results of your call analytics job.</p>', 'StartCallAnalyticsJobResponse$CallAnalyticsJob' => '<p>An object containing the details of the asynchronous call analytics job.</p>', ], ], 'CallAnalyticsJobName' => [ 'base' => NULL, 'refs' => [ 'CallAnalyticsJob$CallAnalyticsJobName' => '<p>The name of the call analytics job.</p>', 'CallAnalyticsJobSummary$CallAnalyticsJobName' => '<p>The name of the call analytics job.</p>', 'DeleteCallAnalyticsJobRequest$CallAnalyticsJobName' => '<p>The name of the call analytics job you want to delete.</p>', 'GetCallAnalyticsJobRequest$CallAnalyticsJobName' => '<p>The name of the analytics job you want information about. This value is case sensitive. </p>', 'ListCallAnalyticsJobsRequest$JobNameContains' => '<p>When specified, the jobs returned in the list are limited to jobs whose name contains the specified string.</p>', 'StartCallAnalyticsJobRequest$CallAnalyticsJobName' => '<p>The name of the call analytics job. You can\'t use the string "." or ".." by themselves as the job name. The name must also be unique within an Amazon Web Services account. If you try to create a call analytics job with the same name as a previous call analytics job, you get a <code>ConflictException</code> error.</p>', ], ], 'CallAnalyticsJobSettings' => [ 'base' => '<p>Provides optional settings for the <code>CallAnalyticsJob</code> operation. </p>', 'refs' => [ 'CallAnalyticsJob$Settings' => '<p>Provides information about the settings used to run a transcription job.</p>', 'StartCallAnalyticsJobRequest$Settings' => '<p>A <code>Settings</code> object that provides optional settings for a call analytics job. </p>', ], ], 'CallAnalyticsJobStatus' => [ 'base' => NULL, 'refs' => [ 'CallAnalyticsJob$CallAnalyticsJobStatus' => '<p>The status of the analytics job.</p>', 'CallAnalyticsJobSummary$CallAnalyticsJobStatus' => '<p>The status of the call analytics job.</p>', 'ListCallAnalyticsJobsRequest$Status' => '<p>When specified, returns only call analytics jobs with the specified status. Jobs are ordered by creation date, with the most recent jobs returned first. If you don\'t specify a status, Amazon Transcribe returns all analytics jobs ordered by creation date.</p>', 'ListCallAnalyticsJobsResponse$Status' => '<p>When specified, returns only call analytics jobs with that status. Jobs are ordered by creation date, with the most recent jobs returned first. If you don\'t specify a status, Amazon Transcribe returns all transcription jobs ordered by creation date.</p>', ], ], 'CallAnalyticsJobSummaries' => [ 'base' => NULL, 'refs' => [ 'ListCallAnalyticsJobsResponse$CallAnalyticsJobSummaries' => '<p>A list of objects containing summary information for a transcription job.</p>', ], ], 'CallAnalyticsJobSummary' => [ 'base' => '<p>Provides summary information about a call analytics job.</p>', 'refs' => [ 'CallAnalyticsJobSummaries$member' => NULL, ], ], 'CategoryName' => [ 'base' => NULL, 'refs' => [ 'CategoryProperties$CategoryName' => '<p>The name of the call analytics category.</p>', 'CreateCallAnalyticsCategoryRequest$CategoryName' => '<p>The name that you choose for your category when you create it. </p>', 'DeleteCallAnalyticsCategoryRequest$CategoryName' => '<p>The name of the call analytics category that you\'re choosing to delete. The value is case sensitive. </p>', 'GetCallAnalyticsCategoryRequest$CategoryName' => '<p>The name of the category you want information about. This value is case sensitive.</p>', 'UpdateCallAnalyticsCategoryRequest$CategoryName' => '<p>The name of the analytics category to update. The name is case sensitive. If you try to update a call analytics category with the same name as a previous category you will receive a <code>ConflictException</code> error.</p>', ], ], 'CategoryProperties' => [ 'base' => '<p>An object that contains the rules and additional information about a call analytics category.</p>', 'refs' => [ 'CategoryPropertiesList$member' => NULL, 'CreateCallAnalyticsCategoryResponse$CategoryProperties' => '<p>The rules and associated metadata used to create a category.</p>', 'GetCallAnalyticsCategoryResponse$CategoryProperties' => '<p>The rules you\'ve defined for a category.</p>', 'UpdateCallAnalyticsCategoryResponse$CategoryProperties' => '<p>The attributes describing the analytics category. You can see information such as the rules that you\'ve used to update the category and when the category was originally created. </p>', ], ], 'CategoryPropertiesList' => [ 'base' => NULL, 'refs' => [ 'ListCallAnalyticsCategoriesResponse$Categories' => '<p>A list of objects containing information about analytics categories.</p>', ], ], 'ChannelDefinition' => [ 'base' => '<p>For a call analytics job, an object that indicates the audio channel that belongs to the agent and the audio channel that belongs to the customer.</p>', 'refs' => [ 'ChannelDefinitions$member' => NULL, ], ], 'ChannelDefinitions' => [ 'base' => NULL, 'refs' => [ 'CallAnalyticsJob$ChannelDefinitions' => '<p>Shows numeric values to indicate the channel assigned to the agent\'s audio and the channel assigned to the customer\'s audio. </p>', 'StartCallAnalyticsJobRequest$ChannelDefinitions' => '<p>When you start a call analytics job, you must pass an array that maps the agent and the customer to specific audio channels. The values you can assign to a channel are 0 and 1. The agent and the customer must each have their own channel. You can\'t assign more than one channel to an agent or customer. </p>', ], ], 'ChannelId' => [ 'base' => NULL, 'refs' => [ 'ChannelDefinition$ChannelId' => '<p>A value that indicates the audio channel.</p>', ], ], 'ConflictException' => [ 'base' => '<p>There is already a resource with that name.</p>', 'refs' => [], ], 'ContentRedaction' => [ 'base' => '<p>Settings for content redaction within a transcription job.</p>', 'refs' => [ 'CallAnalyticsJobSettings$ContentRedaction' => NULL, 'StartTranscriptionJobRequest$ContentRedaction' => '<p>An object that contains the request parameters for content redaction.</p>', 'TranscriptionJob$ContentRedaction' => '<p>An object that describes content redaction settings for the transcription job.</p>', 'TranscriptionJobSummary$ContentRedaction' => '<p>The content redaction settings of the transcription job.</p>', ], ], 'CreateCallAnalyticsCategoryRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateCallAnalyticsCategoryResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateLanguageModelRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateLanguageModelResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateMedicalVocabularyRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateMedicalVocabularyResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateVocabularyFilterRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateVocabularyFilterResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateVocabularyRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateVocabularyResponse' => [ 'base' => NULL, 'refs' => [], ], 'DataAccessRoleArn' => [ 'base' => NULL, 'refs' => [ 'CallAnalyticsJob$DataAccessRoleArn' => '<p>The Amazon Resource Number (ARN) that you use to get access to the analytics job.</p>', 'InputDataConfig$DataAccessRoleArn' => '<p>The Amazon Resource Name (ARN) that uniquely identifies the permissions you\'ve given Amazon Transcribe to access your Amazon S3 buckets containing your media files or text data.</p>', 'JobExecutionSettings$DataAccessRoleArn' => '<p>The Amazon Resource Name (ARN) of a role that has access to the S3 bucket that contains the input files. Amazon Transcribe assumes this role to read queued media files. If you have specified an output S3 bucket for the transcription results, this role should have access to the output bucket as well.</p> <p>If you specify the <code>AllowDeferredExecution</code> field, you must specify the <code>DataAccessRoleArn</code> field.</p>', 'StartCallAnalyticsJobRequest$DataAccessRoleArn' => '<p>The Amazon Resource Name (ARN) of a role that has access to the S3 bucket that contains your input files. Amazon Transcribe assumes this role to read queued audio files. If you have specified an output S3 bucket for your transcription results, this role should have access to the output bucket as well.</p>', ], ], 'DateTime' => [ 'base' => NULL, 'refs' => [ 'CallAnalyticsJob$StartTime' => '<p>A timestamp that shows when the analytics job started processing.</p>', 'CallAnalyticsJob$CreationTime' => '<p>A timestamp that shows when the analytics job was created.</p>', 'CallAnalyticsJob$CompletionTime' => '<p>A timestamp that shows when the analytics job was completed.</p>', 'CallAnalyticsJobSummary$CreationTime' => '<p>A timestamp that shows when the call analytics job was created.</p>', 'CallAnalyticsJobSummary$StartTime' => '<p>A timestamp that shows when the job began processing.</p>', 'CallAnalyticsJobSummary$CompletionTime' => '<p>A timestamp that shows when the job was completed.</p>', 'CategoryProperties$CreateTime' => '<p>A timestamp that shows when the call analytics category was created.</p>', 'CategoryProperties$LastUpdateTime' => '<p>A timestamp that shows when the call analytics category was most recently updated.</p>', 'CreateMedicalVocabularyResponse$LastModifiedTime' => '<p>The date and time that you created the vocabulary.</p>', 'CreateVocabularyFilterResponse$LastModifiedTime' => '<p>The date and time that the vocabulary filter was modified.</p>', 'CreateVocabularyResponse$LastModifiedTime' => '<p>The date and time that the vocabulary was created.</p>', 'GetMedicalVocabularyResponse$LastModifiedTime' => '<p>The date and time that the vocabulary was last modified with a text file different from the one that was previously used.</p>', 'GetVocabularyFilterResponse$LastModifiedTime' => '<p>The date and time that the contents of the vocabulary filter were updated.</p>', 'GetVocabularyResponse$LastModifiedTime' => '<p>The date and time that the vocabulary was last modified.</p>', 'LanguageModel$CreateTime' => '<p>The time the custom language model was created.</p>', 'LanguageModel$LastModifiedTime' => '<p>The most recent time the custom language model was modified.</p>', 'MedicalTranscriptionJob$StartTime' => '<p>A timestamp that shows when the job started processing.</p>', 'MedicalTranscriptionJob$CreationTime' => '<p>A timestamp that shows when the job was created.</p>', 'MedicalTranscriptionJob$CompletionTime' => '<p>A timestamp that shows when the job was completed.</p>', 'MedicalTranscriptionJobSummary$CreationTime' => '<p>A timestamp that shows when the medical transcription job was created.</p>', 'MedicalTranscriptionJobSummary$StartTime' => '<p>A timestamp that shows when the job began processing.</p>', 'MedicalTranscriptionJobSummary$CompletionTime' => '<p>A timestamp that shows when the job was completed.</p>', 'TranscriptionJob$StartTime' => '<p>A timestamp that shows when the job started processing.</p>', 'TranscriptionJob$CreationTime' => '<p>A timestamp that shows when the job was created.</p>', 'TranscriptionJob$CompletionTime' => '<p>A timestamp that shows when the job completed.</p>', 'TranscriptionJobSummary$CreationTime' => '<p>A timestamp that shows when the job was created.</p>', 'TranscriptionJobSummary$StartTime' => '<p>A timestamp that shows when the job started processing.</p>', 'TranscriptionJobSummary$CompletionTime' => '<p>A timestamp that shows when the job was completed.</p>', 'UpdateMedicalVocabularyResponse$LastModifiedTime' => '<p>The date and time that the vocabulary was updated.</p>', 'UpdateVocabularyFilterResponse$LastModifiedTime' => '<p>The date and time that the vocabulary filter was updated.</p>', 'UpdateVocabularyResponse$LastModifiedTime' => '<p>The date and time that the vocabulary was updated.</p>', 'VocabularyFilterInfo$LastModifiedTime' => '<p>The date and time that the vocabulary was last updated.</p>', 'VocabularyInfo$LastModifiedTime' => '<p>The date and time that the vocabulary was last modified.</p>', ], ], 'DeleteCallAnalyticsCategoryRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteCallAnalyticsCategoryResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteCallAnalyticsJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteCallAnalyticsJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteLanguageModelRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteMedicalTranscriptionJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteMedicalVocabularyRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteTranscriptionJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteVocabularyFilterRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteVocabularyRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeLanguageModelRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeLanguageModelResponse' => [ 'base' => NULL, 'refs' => [], ], 'FailureReason' => [ 'base' => NULL, 'refs' => [ 'BadRequestException$Message' => NULL, 'CallAnalyticsJob$FailureReason' => '<p>If the <code>AnalyticsJobStatus</code> is <code>FAILED</code>, this field contains information about why the job failed.</p> <p>The <code>FailureReason</code> field can contain one of the following values:</p> <ul> <li> <p> <code>Unsupported media format</code>: The media format specified in the <code>MediaFormat</code> field of the request isn\'t valid. See the description of the <code>MediaFormat</code> field for a list of valid values.</p> </li> <li> <p> <code>The media format provided does not match the detected media format</code>: The media format of the audio file doesn\'t match the format specified in the <code>MediaFormat</code> field in the request. Check the media format of your media file and make sure the two values match.</p> </li> <li> <p> <code>Invalid sample rate for audio file</code>: The sample rate specified in the <code>MediaSampleRateHertz</code> of the request isn\'t valid. The sample rate must be between 8,000 and 48,000 Hertz.</p> </li> <li> <p> <code>The sample rate provided does not match the detected sample rate</code>: The sample rate in the audio file doesn\'t match the sample rate specified in the <code>MediaSampleRateHertz</code> field in the request. Check the sample rate of your media file and make sure that the two values match.</p> </li> <li> <p> <code>Invalid file size: file size too large</code>: The size of your audio file is larger than what Amazon Transcribe Medical can process. For more information, see <i>Guidelines and Quotas</i> in the Amazon Transcribe Medical Guide.</p> </li> <li> <p> <code>Invalid number of channels: number of channels too large</code>: Your audio contains more channels than Amazon Transcribe Medical is configured to process. To request additional channels, see Amazon Transcribe Medical Endpoints and Quotas in the <a href="https://docs.aws.amazon.com/general/latest/gr/Welcome.html">Amazon Web Services General Reference</a>.</p> </li> </ul>', 'CallAnalyticsJobSummary$FailureReason' => '<p>If the <code>CallAnalyticsJobStatus</code> is <code>FAILED</code>, a description of the error.</p>', 'CreateMedicalVocabularyResponse$FailureReason' => '<p>If the <code>VocabularyState</code> field is <code>FAILED</code>, this field contains information about why the job failed.</p>', 'CreateVocabularyResponse$FailureReason' => '<p>If the <code>VocabularyState</code> field is <code>FAILED</code>, this field contains information about why the job failed.</p>', 'GetMedicalVocabularyResponse$FailureReason' => '<p>If the <code>VocabularyState</code> is <code>FAILED</code>, this field contains information about why the job failed.</p>', 'GetVocabularyResponse$FailureReason' => '<p>If the <code>VocabularyState</code> field is <code>FAILED</code>, this field contains information about why the job failed.</p>', 'LanguageModel$FailureReason' => '<p>The reason why the custom language model couldn\'t be created.</p>', 'MedicalTranscriptionJob$FailureReason' => '<p>If the <code>TranscriptionJobStatus</code> field is <code>FAILED</code>, this field contains information about why the job failed.</p> <p>The <code>FailureReason</code> field contains one of the following values:</p> <ul> <li> <p> <code>Unsupported media format</code>- The media format specified in the <code>MediaFormat</code> field of the request isn\'t valid. See the description of the <code>MediaFormat</code> field for a list of valid values.</p> </li> <li> <p> <code>The media format provided does not match the detected media format</code>- The media format of the audio file doesn\'t match the format specified in the <code>MediaFormat</code> field in the request. Check the media format of your media file and make sure the two values match.</p> </li> <li> <p> <code>Invalid sample rate for audio file</code>- The sample rate specified in the <code>MediaSampleRateHertz</code> of the request isn\'t valid. The sample rate must be between 8,000 and 48,000 Hertz.</p> </li> <li> <p> <code>The sample rate provided does not match the detected sample rate</code>- The sample rate in the audio file doesn\'t match the sample rate specified in the <code>MediaSampleRateHertz</code> field in the request. Check the sample rate of your media file and make sure that the two values match.</p> </li> <li> <p> <code>Invalid file size: file size too large</code>- The size of your audio file is larger than what Amazon Transcribe Medical can process. For more information, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/limits-guidelines.html#limits">Guidelines and Quotas</a> in the <i>Amazon Transcribe Medical Guide</i> </p> </li> <li> <p> <code>Invalid number of channels: number of channels too large</code>- Your audio contains more channels than Amazon Transcribe Medical is configured to process. To request additional channels, see <a href="https://docs.aws.amazon.com/general/latest/gr/transcribe-medical.html">Amazon Transcribe Medical Endpoints and Quotas</a> in the <i>Amazon Web Services General Reference</i> </p> </li> </ul>', 'MedicalTranscriptionJobSummary$FailureReason' => '<p>If the <code>TranscriptionJobStatus</code> field is <code>FAILED</code>, a description of the error.</p>', 'TranscriptionJob$FailureReason' => '<p>If the <code>TranscriptionJobStatus</code> field is <code>FAILED</code>, this field contains information about why the job failed.</p> <p>The <code>FailureReason</code> field can contain one of the following values:</p> <ul> <li> <p> <code>Unsupported media format</code> - The media format specified in the <code>MediaFormat</code> field of the request isn\'t valid. See the description of the <code>MediaFormat</code> field for a list of valid values.</p> </li> <li> <p> <code>The media format provided does not match the detected media format</code> - The media format of the audio file doesn\'t match the format specified in the <code>MediaFormat</code> field in the request. Check the media format of your media file and make sure that the two values match.</p> </li> <li> <p> <code>Invalid sample rate for audio file</code> - The sample rate specified in the <code>MediaSampleRateHertz</code> of the request isn\'t valid. The sample rate must be between 8,000 and 48,000 Hertz.</p> </li> <li> <p> <code>The sample rate provided does not match the detected sample rate</code> - The sample rate in the audio file doesn\'t match the sample rate specified in the <code>MediaSampleRateHertz</code> field in the request. Check the sample rate of your media file and make sure that the two values match.</p> </li> <li> <p> <code>Invalid file size: file size too large</code> - The size of your audio file is larger than Amazon Transcribe can process. For more information, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/limits-guidelines.html#limits">Limits</a> in the <i>Amazon Transcribe Developer Guide</i>.</p> </li> <li> <p> <code>Invalid number of channels: number of channels too large</code> - Your audio contains more channels than Amazon Transcribe is configured to process. To request additional channels, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_service_limits.html#limits-amazon-transcribe">Amazon Transcribe Limits</a> in the <i>Amazon Web Services General Reference</i>.</p> </li> </ul>', 'TranscriptionJobSummary$FailureReason' => '<p>If the <code>TranscriptionJobStatus</code> field is <code>FAILED</code>, a description of the error.</p>', ], ], 'GetCallAnalyticsCategoryRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetCallAnalyticsCategoryResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetCallAnalyticsJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetCallAnalyticsJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetMedicalTranscriptionJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetMedicalTranscriptionJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetMedicalVocabularyRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetMedicalVocabularyResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetTranscriptionJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetTranscriptionJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetVocabularyFilterRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetVocabularyFilterResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetVocabularyRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetVocabularyResponse' => [ 'base' => NULL, 'refs' => [], ], 'IdentifiedLanguageScore' => [ 'base' => NULL, 'refs' => [ 'CallAnalyticsJob$IdentifiedLanguageScore' => '<p>A value between zero and one that Amazon Transcribe assigned to the language that it identified in the source audio. This value appears only when you don\'t provide a single language code. Larger values indicate that Amazon Transcribe has higher confidence in the language that it identified</p>', 'TranscriptionJob$IdentifiedLanguageScore' => '<p>A value between zero and one that Amazon Transcribe assigned to the language that it identified in the source audio. Larger values indicate that Amazon Transcribe has higher confidence in the language it identified.</p>', 'TranscriptionJobSummary$IdentifiedLanguageScore' => '<p>A value between zero and one that Amazon Transcribe assigned to the language it identified in the source audio. A higher score indicates that Amazon Transcribe is more confident in the language it identified.</p>', ], ], 'InputDataConfig' => [ 'base' => '<p>The object that contains the Amazon S3 object location and access role required to train and tune your custom language model.</p>', 'refs' => [ 'CreateLanguageModelRequest$InputDataConfig' => '<p>Contains the data access role and the Amazon S3 prefixes to read the required input files to create a custom language model.</p>', 'CreateLanguageModelResponse$InputDataConfig' => '<p>The data access role and Amazon S3 prefixes you\'ve chosen to create your custom language model.</p>', 'LanguageModel$InputDataConfig' => '<p>The data access role and Amazon S3 prefixes for the input files used to train the custom language model.</p>', ], ], 'InternalFailureException' => [ 'base' => '<p>There was an internal error. Check the error message and try your request again.</p>', 'refs' => [], ], 'InterruptionFilter' => [ 'base' => '<p>An object that enables you to configure your category to be applied to call analytics jobs where either the customer or agent was interrupted.</p>', 'refs' => [ 'Rule$InterruptionFilter' => '<p>A condition for a time period when either the customer or agent was interrupting the other person. </p>', ], ], 'JobExecutionSettings' => [ 'base' => '<p>Provides information about when a transcription job should be executed.</p>', 'refs' => [ 'StartTranscriptionJobRequest$JobExecutionSettings' => '<p>Provides information about how a transcription job is executed. Use this field to indicate that the job can be queued for deferred execution if the concurrency limit is reached and there are no slots available to immediately run the job.</p>', 'TranscriptionJob$JobExecutionSettings' => '<p>Provides information about how a transcription job is executed.</p>', ], ], 'KMSEncryptionContextMap' => [ 'base' => NULL, 'refs' => [ 'StartMedicalTranscriptionJobRequest$KMSEncryptionContext' => '<p>A map of plain text, non-secret key:value pairs, known as encryption context pairs, that provide an added layer of security for your data.</p>', 'StartTranscriptionJobRequest$KMSEncryptionContext' => '<p>A map of plain text, non-secret key:value pairs, known as encryption context pairs, that provide an added layer of security for your data.</p>', ], ], 'KMSKeyId' => [ 'base' => NULL, 'refs' => [ 'StartCallAnalyticsJobRequest$OutputEncryptionKMSKeyId' => '<p>The Amazon Resource Name (ARN) of the Amazon Web Services Key Management Service key used to encrypt the output of the call analytics job. The user calling the operation must have permission to use the specified KMS key.</p> <p>You use either of the following to identify an Amazon Web Services KMS key in the current account:</p> <ul> <li> <p>KMS Key ID: "1234abcd-12ab-34cd-56ef-1234567890ab"</p> </li> <li> <p>KMS Key Alias: "alias/ExampleAlias"</p> </li> </ul> <p> You can use either of the following to identify a KMS key in the current account or another account:</p> <ul> <li> <p>Amazon Resource Name (ARN) of a KMS key in the current account or another account: "arn:aws:kms:region:account ID:key/1234abcd-12ab-34cd-56ef1234567890ab"</p> </li> <li> <p>ARN of a KMS Key Alias: "arn:aws:kms:region:account ID:alias/ExampleAlias"</p> </li> </ul> <p>If you don\'t specify an encryption key, the output of the call analytics job is encrypted with the default Amazon S3 key (SSE-S3).</p> <p>If you specify a KMS key to encrypt your output, you must also specify an output location in the <code>OutputLocation</code> parameter. </p>', 'StartMedicalTranscriptionJobRequest$OutputEncryptionKMSKeyId' => '<p>The Amazon Resource Name (ARN) of the Amazon Web Services Key Management Service (KMS) key used to encrypt the output of the transcription job. The user calling the <a>StartMedicalTranscriptionJob</a> operation must have permission to use the specified KMS key.</p> <p>You use either of the following to identify a KMS key in the current account:</p> <ul> <li> <p>KMS Key ID: "1234abcd-12ab-34cd-56ef-1234567890ab"</p> </li> <li> <p>KMS Key Alias: "alias/ExampleAlias"</p> </li> </ul> <p>You can use either of the following to identify a KMS key in the current account or another account:</p> <ul> <li> <p>Amazon Resource Name (ARN) of a KMS key in the current account or another account: "arn:aws:kms:region:account ID:key/1234abcd-12ab-34cd-56ef-1234567890ab"</p> </li> <li> <p>ARN of a KMS Key Alias: "arn:aws:kms:region:account ID:alias/ExampleAlias"</p> </li> </ul> <p>If you don\'t specify an encryption key, the output of the medical transcription job is encrypted with the default Amazon S3 key (SSE-S3).</p> <p>If you specify a KMS key to encrypt your output, you must also specify an output location in the <code>OutputBucketName</code> parameter.</p>', 'StartTranscriptionJobRequest$OutputEncryptionKMSKeyId' => '<p>The Amazon Resource Name (ARN) of the Amazon Web Services Key Management Service (KMS) key used to encrypt the output of the transcription job. The user calling the <code>StartTranscriptionJob</code> operation must have permission to use the specified KMS key.</p> <p>You can use either of the following to identify a KMS key in the current account:</p> <ul> <li> <p>KMS Key ID: "1234abcd-12ab-34cd-56ef-1234567890ab"</p> </li> <li> <p>KMS Key Alias: "alias/ExampleAlias"</p> </li> </ul> <p>You can use either of the following to identify a KMS key in the current account or another account:</p> <ul> <li> <p>Amazon Resource Name (ARN) of a KMS Key: "arn:aws:kms:region:account ID:key/1234abcd-12ab-34cd-56ef-1234567890ab"</p> </li> <li> <p>ARN of a KMS Key Alias: "arn:aws:kms:region:account ID:alias/ExampleAlias"</p> </li> </ul> <p>If you don\'t specify an encryption key, the output of the transcription job is encrypted with the default Amazon S3 key (SSE-S3).</p> <p>If you specify a KMS key to encrypt your output, you must also specify an output location in the <code>OutputBucketName</code> parameter.</p>', ], ], 'LanguageCode' => [ 'base' => NULL, 'refs' => [ 'CallAnalyticsJob$LanguageCode' => '<p>If you know the language spoken between the customer and the agent, specify a language code for this field.</p> <p>If you don\'t know the language, you can leave this field blank, and Amazon Transcribe will use machine learning to automatically identify the language. To improve the accuracy of language identification, you can provide an array containing the possible language codes for the language spoken in your audio. Refer to <a href="https://docs.aws.amazon.com/transcribe/latest/dg/how-it-works.html">Supported languages and language-specific features</a> for additional information.</p>', 'CallAnalyticsJobSummary$LanguageCode' => '<p>The language of the transcript in the source audio file.</p>', 'CreateMedicalVocabularyRequest$LanguageCode' => '<p>The language code for the language used for the entries in your custom vocabulary. The language code of your custom vocabulary must match the language code of your transcription job. US English (en-US) is the only language code available for Amazon Transcribe Medical.</p>', 'CreateMedicalVocabularyResponse$LanguageCode' => '<p>The language code for the entries in your custom vocabulary. US English (en-US) is the only valid language code for Amazon Transcribe Medical.</p>', 'CreateVocabularyFilterRequest$LanguageCode' => '<p>The language code of the words in the vocabulary filter. All words in the filter must be in the same language. The vocabulary filter can only be used with transcription jobs in the specified language.</p>', 'CreateVocabularyFilterResponse$LanguageCode' => '<p>The language code of the words in the collection.</p>', 'CreateVocabularyRequest$LanguageCode' => '<p>The language code of the vocabulary entries. For a list of languages and their corresponding language codes, see <a>transcribe-whatis</a>.</p>', 'CreateVocabularyResponse$LanguageCode' => '<p>The language code of the vocabulary entries.</p>', 'GetMedicalVocabularyResponse$LanguageCode' => '<p>The valid language code for your vocabulary entries.</p>', 'GetVocabularyFilterResponse$LanguageCode' => '<p>The language code of the words in the vocabulary filter.</p>', 'GetVocabularyResponse$LanguageCode' => '<p>The language code of the vocabulary entries.</p>', 'LanguageOptions$member' => NULL, 'MedicalTranscriptionJob$LanguageCode' => '<p>The language code for the language spoken in the source audio file. US English (en-US) is the only supported language for medical transcriptions. Any other value you enter for language code results in a <code>BadRequestException</code> error.</p>', 'MedicalTranscriptionJobSummary$LanguageCode' => '<p>The language of the transcript in the source audio file.</p>', 'StartMedicalTranscriptionJobRequest$LanguageCode' => '<p>The language code for the language spoken in the input media file. US English (en-US) is the valid value for medical transcription jobs. Any other value you enter for language code results in a <code>BadRequestException</code> error.</p>', 'StartTranscriptionJobRequest$LanguageCode' => '<p>The language code for the language used in the input media file.</p> <p>To transcribe speech in Modern Standard Arabic (ar-SA), your audio or video file must be encoded at a sample rate of 16,000 Hz or higher.</p>', 'TranscriptionJob$LanguageCode' => '<p>The language code for the input speech.</p>', 'TranscriptionJobSummary$LanguageCode' => '<p>The language code for the input speech.</p>', 'UpdateMedicalVocabularyRequest$LanguageCode' => '<p>The language code of the language used for the entries in the updated vocabulary. US English (en-US) is the only valid language code in Amazon Transcribe Medical.</p>', 'UpdateMedicalVocabularyResponse$LanguageCode' => '<p>The language code for the language of the text file used to update the custom vocabulary. US English (en-US) is the only language supported in Amazon Transcribe Medical.</p>', 'UpdateVocabularyFilterResponse$LanguageCode' => '<p>The language code of the words in the vocabulary filter.</p>', 'UpdateVocabularyRequest$LanguageCode' => '<p>The language code of the vocabulary entries. For a list of languages and their corresponding language codes, see <a>transcribe-whatis</a>.</p>', 'UpdateVocabularyResponse$LanguageCode' => '<p>The language code of the vocabulary entries.</p>', 'VocabularyFilterInfo$LanguageCode' => '<p>The language code of the words in the vocabulary filter.</p>', 'VocabularyInfo$LanguageCode' => '<p>The language code of the vocabulary entries.</p>', ], ], 'LanguageModel' => [ 'base' => '<p>The structure used to describe a custom language model.</p>', 'refs' => [ 'DescribeLanguageModelResponse$LanguageModel' => '<p>The name of the custom language model you requested more information about.</p>', 'Models$member' => NULL, ], ], 'LanguageOptions' => [ 'base' => NULL, 'refs' => [ 'CallAnalyticsJobSettings$LanguageOptions' => '<p>When you run a call analytics job, you can specify the language spoken in the audio, or you can have Amazon Transcribe identify the language for you.</p> <p>To specify a language, specify an array with one language code. If you don\'t know the language, you can leave this field blank and Amazon Transcribe will use machine learning to identify the language for you. To improve the ability of Amazon Transcribe to correctly identify the language, you can provide an array of the languages that can be present in the audio. Refer to <a href="https://docs.aws.amazon.com/transcribe/latest/dg/how-it-works.html">Supported languages and language-specific features</a> for additional information.</p>', 'StartTranscriptionJobRequest$LanguageOptions' => '<p>An object containing a list of languages that might be present in your collection of audio files. Automatic language identification chooses a language that best matches the source audio from that list.</p> <p>To transcribe speech in Modern Standard Arabic (ar-SA), your audio or video file must be encoded at a sample rate of 16,000 Hz or higher.</p>', 'TranscriptionJob$LanguageOptions' => '<p>An object that shows the optional array of languages inputted for transcription jobs with automatic language identification enabled.</p>', ], ], 'LimitExceededException' => [ 'base' => '<p>Either you have sent too many requests or your input file is too long. Wait before you resend your request, or use a smaller file and resend the request.</p>', 'refs' => [], ], 'ListCallAnalyticsCategoriesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListCallAnalyticsCategoriesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListCallAnalyticsJobsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListCallAnalyticsJobsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListLanguageModelsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListLanguageModelsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListMedicalTranscriptionJobsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListMedicalTranscriptionJobsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListMedicalVocabulariesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListMedicalVocabulariesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTranscriptionJobsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTranscriptionJobsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListVocabulariesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListVocabulariesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListVocabularyFiltersRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListVocabularyFiltersResponse' => [ 'base' => NULL, 'refs' => [], ], 'MaxAlternatives' => [ 'base' => NULL, 'refs' => [ 'MedicalTranscriptionSetting$MaxAlternatives' => '<p>The maximum number of alternatives that you tell the service to return. If you specify the <code>MaxAlternatives</code> field, you must set the <code>ShowAlternatives</code> field to true.</p>', 'Settings$MaxAlternatives' => '<p>The number of alternative transcriptions that the service should return. If you specify the <code>MaxAlternatives</code> field, you must set the <code>ShowAlternatives</code> field to true.</p>', ], ], 'MaxResults' => [ 'base' => NULL, 'refs' => [ 'ListCallAnalyticsCategoriesRequest$MaxResults' => '<p>The maximum number of categories to return in each page of results. If there are fewer results than the value you specify, only the actual results are returned. If you do not specify a value, the default of 5 is used.</p>', 'ListCallAnalyticsJobsRequest$MaxResults' => '<p> The maximum number of call analytics jobs to return in each page of results. If there are fewer results than the value you specify, only the actual results are returned. If you do not specify a value, the default of 5 is used. </p>', 'ListLanguageModelsRequest$MaxResults' => '<p> The maximum number of language models to return in each page of results. If there are fewer results than the value you specify, only the actual results are returned. If you do not specify a value, the default of 5 is used.</p>', 'ListMedicalTranscriptionJobsRequest$MaxResults' => '<p> The maximum number of medical transcription jobs to return in each page of results. If there are fewer results than the value you specify, only the actual results are returned. If you do not specify a value, the default of 5 is used.</p>', 'ListMedicalVocabulariesRequest$MaxResults' => '<p>The maximum number of vocabularies to return in each page of results. If there are fewer results than the value you specify, only the actual results are returned. If you do not specify a value, the default of 5 is used.</p>', 'ListTranscriptionJobsRequest$MaxResults' => '<p>The maximum number of jobs to return in each page of results. If there are fewer results than the value you specify, only the actual results are returned. If you do not specify a value, the default of 5 is used.</p>', 'ListVocabulariesRequest$MaxResults' => '<p>The maximum number of vocabularies to return in each page of results. If there are fewer results than the value you specify, only the actual results are returned. If you do not specify a value, the default of 5 is used.</p>', 'ListVocabularyFiltersRequest$MaxResults' => '<p>The maximum number of filters to return in each page of results. If there are fewer results than the value you specify, only the actual results are returned. If you do not specify a value, the default of 5 is used.</p>', ], ], 'MaxSpeakers' => [ 'base' => NULL, 'refs' => [ 'MedicalTranscriptionSetting$MaxSpeakerLabels' => '<p>The maximum number of speakers to identify in the input audio. If there are more speakers in the audio than this number, multiple speakers are identified as a single speaker. If you specify the <code>MaxSpeakerLabels</code> field, you must set the <code>ShowSpeakerLabels</code> field to true.</p>', 'Settings$MaxSpeakerLabels' => '<p>The maximum number of speakers to identify in the input audio. If there are more speakers in the audio than this number, multiple speakers are identified as a single speaker. If you specify the <code>MaxSpeakerLabels</code> field, you must set the <code>ShowSpeakerLabels</code> field to true.</p>', ], ], 'Media' => [ 'base' => '<p>Describes the input media file in a transcription request.</p>', 'refs' => [ 'CallAnalyticsJob$Media' => NULL, 'MedicalTranscriptionJob$Media' => NULL, 'StartCallAnalyticsJobRequest$Media' => NULL, 'StartMedicalTranscriptionJobRequest$Media' => NULL, 'StartTranscriptionJobRequest$Media' => '<p>An object that describes the input media for a transcription job.</p>', 'TranscriptionJob$Media' => '<p>An object that describes the input media for the transcription job.</p>', ], ], 'MediaFormat' => [ 'base' => NULL, 'refs' => [ 'CallAnalyticsJob$MediaFormat' => '<p>The format of the input audio file. Note: for call analytics jobs, only the following media formats are supported: MP3, MP4, WAV, FLAC, OGG, and WebM. </p>', 'MedicalTranscriptionJob$MediaFormat' => '<p>The format of the input media file.</p>', 'StartMedicalTranscriptionJobRequest$MediaFormat' => '<p>The audio format of the input media file.</p>', 'StartTranscriptionJobRequest$MediaFormat' => '<p>The format of the input media file.</p>', 'TranscriptionJob$MediaFormat' => '<p>The format of the input media file.</p>', ], ], 'MediaSampleRateHertz' => [ 'base' => NULL, 'refs' => [ 'CallAnalyticsJob$MediaSampleRateHertz' => '<p>The sample rate, in Hertz, of the audio.</p>', 'MedicalTranscriptionJob$MediaSampleRateHertz' => '<p>The sample rate, in Hertz, of the source audio containing medical information.</p> <p>If you don\'t specify the sample rate, Amazon Transcribe Medical determines it for you. If you choose to specify the sample rate, it must match the rate detected by Amazon Transcribe Medical. In most cases, you should leave the <code>MedicalMediaSampleHertz</code> blank and let Amazon Transcribe Medical determine the sample rate.</p>', 'StartMedicalTranscriptionJobRequest$MediaSampleRateHertz' => '<p>The sample rate, in Hertz, of the audio track in the input media file.</p> <p>If you do not specify the media sample rate, Amazon Transcribe Medical determines the sample rate. If you specify the sample rate, it must match the rate detected by Amazon Transcribe Medical. In most cases, you should leave the <code>MediaSampleRateHertz</code> field blank and let Amazon Transcribe Medical determine the sample rate.</p>', 'StartTranscriptionJobRequest$MediaSampleRateHertz' => '<p>The sample rate, in Hertz, of the audio track in the input media file. </p> <p>If you do not specify the media sample rate, Amazon Transcribe determines the sample rate. If you specify the sample rate, it must match the sample rate detected by Amazon Transcribe. In most cases, you should leave the <code>MediaSampleRateHertz</code> field blank and let Amazon Transcribe determine the sample rate.</p>', 'TranscriptionJob$MediaSampleRateHertz' => '<p>The sample rate, in Hertz, of the audio track in the input media file. </p>', ], ], 'MedicalContentIdentificationType' => [ 'base' => NULL, 'refs' => [ 'MedicalTranscriptionJob$ContentIdentificationType' => '<p>Shows the type of content that you\'ve configured Amazon Transcribe Medical to identify in a transcription job. If the value is <code>PHI</code>, you\'ve configured the job to identify personal health information (PHI) in the transcription output.</p>', 'MedicalTranscriptionJobSummary$ContentIdentificationType' => '<p>Shows the type of information you\'ve configured Amazon Transcribe Medical to identify in a transcription job. If the value is <code>PHI</code>, you\'ve configured the transcription job to identify personal health information (PHI).</p>', 'StartMedicalTranscriptionJobRequest$ContentIdentificationType' => '<p>You can configure Amazon Transcribe Medical to label content in the transcription output. If you specify <code>PHI</code>, Amazon Transcribe Medical labels the personal health information (PHI) that it identifies in the transcription output.</p>', ], ], 'MedicalTranscript' => [ 'base' => '<p>Identifies the location of a medical transcript.</p>', 'refs' => [ 'MedicalTranscriptionJob$Transcript' => '<p>An object that contains the <code>MedicalTranscript</code>. The <code>MedicalTranscript</code> contains the <code>TranscriptFileUri</code>.</p>', ], ], 'MedicalTranscriptionJob' => [ 'base' => '<p>The data structure that contains the information for a medical transcription job.</p>', 'refs' => [ 'GetMedicalTranscriptionJobResponse$MedicalTranscriptionJob' => '<p>An object that contains the results of the medical transcription job.</p>', 'StartMedicalTranscriptionJobResponse$MedicalTranscriptionJob' => '<p>A batch job submitted to transcribe medical speech to text.</p>', ], ], 'MedicalTranscriptionJobSummaries' => [ 'base' => NULL, 'refs' => [ 'ListMedicalTranscriptionJobsResponse$MedicalTranscriptionJobSummaries' => '<p>A list of objects containing summary information for a transcription job.</p>', ], ], 'MedicalTranscriptionJobSummary' => [ 'base' => '<p>Provides summary information about a transcription job.</p>', 'refs' => [ 'MedicalTranscriptionJobSummaries$member' => NULL, ], ], 'MedicalTranscriptionSetting' => [ 'base' => '<p>Optional settings for the <a>StartMedicalTranscriptionJob</a> operation.</p>', 'refs' => [ 'MedicalTranscriptionJob$Settings' => '<p>Object that contains object.</p>', 'StartMedicalTranscriptionJobRequest$Settings' => '<p>Optional settings for the medical transcription job.</p>', ], ], 'ModelName' => [ 'base' => NULL, 'refs' => [ 'CallAnalyticsJobSettings$LanguageModelName' => '<p>The structure used to describe a custom language model.</p>', 'CreateLanguageModelRequest$ModelName' => '<p>The name you choose for your custom language model when you create it.</p>', 'CreateLanguageModelResponse$ModelName' => '<p>The name you\'ve chosen for your custom language model.</p>', 'DeleteLanguageModelRequest$ModelName' => '<p>The name of the model you\'re choosing to delete.</p>', 'DescribeLanguageModelRequest$ModelName' => '<p>The name of the custom language model you submit to get more information.</p>', 'LanguageModel$ModelName' => '<p>The name of the custom language model.</p>', 'ListLanguageModelsRequest$NameContains' => '<p>When specified, the custom language model names returned contain the substring you\'ve specified.</p>', 'ModelSettings$LanguageModelName' => '<p>The name of your custom language model.</p>', ], ], 'ModelSettings' => [ 'base' => '<p>The object used to call your custom language model to your transcription job.</p>', 'refs' => [ 'StartTranscriptionJobRequest$ModelSettings' => '<p>Choose the custom language model you use for your transcription job in this parameter.</p>', 'TranscriptionJob$ModelSettings' => '<p>An object containing the details of your custom language model.</p>', 'TranscriptionJobSummary$ModelSettings' => NULL, ], ], 'ModelStatus' => [ 'base' => NULL, 'refs' => [ 'CreateLanguageModelResponse$ModelStatus' => '<p>The status of the custom language model. When the status is <code>COMPLETED</code> the model is ready to use.</p>', 'LanguageModel$ModelStatus' => '<p>The creation status of a custom language model. When the status is <code>COMPLETED</code> the model is ready for use.</p>', 'ListLanguageModelsRequest$StatusEquals' => '<p>When specified, returns only custom language models with the specified status. Language models are ordered by creation date, with the newest models first. If you don\'t specify a status, Amazon Transcribe returns all custom language models ordered by date.</p>', ], ], 'Models' => [ 'base' => NULL, 'refs' => [ 'ListLanguageModelsResponse$Models' => '<p>A list of objects containing information about custom language models.</p>', ], ], 'NextToken' => [ 'base' => NULL, 'refs' => [ 'ListCallAnalyticsCategoriesRequest$NextToken' => '<p>When included, <code>NextToken</code>fetches the next set of categories if the result of the previous request was truncated.</p>', 'ListCallAnalyticsCategoriesResponse$NextToken' => '<p>The operation returns a page of jobs at a time. The maximum size of the list is set by the <code>MaxResults</code> parameter. If there are more categories in the list than the page size, Amazon Transcribe returns the <code>NextPage</code> token. Include the token in the next request to the operation to return the next page of analytics categories.</p>', 'ListCallAnalyticsJobsRequest$NextToken' => '<p>If you receive a truncated result in the previous request of , include <code>NextToken</code> to fetch the next set of jobs.</p>', 'ListCallAnalyticsJobsResponse$NextToken' => '<p>The operation returns a page of jobs at a time. The maximum size of the page is set by the <code>MaxResults</code> parameter. If there are more jobs in the list than the page size, Amazon Transcribe returns the <code>NextPage</code> token. Include the token in your next request to the operation to return next page of jobs.</p>', 'ListLanguageModelsRequest$NextToken' => '<p>When included, fetches the next set of jobs if the result of the previous request was truncated.</p>', 'ListLanguageModelsResponse$NextToken' => '<p>The operation returns a page of jobs at a time. The maximum size of the list is set by the MaxResults parameter. If there are more language models in the list than the page size, Amazon Transcribe returns the <code>NextPage</code> token. Include the token in the next request to the operation to return the next page of language models.</p>', 'ListMedicalTranscriptionJobsRequest$NextToken' => '<p>If you a receive a truncated result in the previous request of <code>ListMedicalTranscriptionJobs</code>, include <code>NextToken</code> to fetch the next set of jobs.</p>', 'ListMedicalTranscriptionJobsResponse$NextToken' => '<p>The <code>ListMedicalTranscriptionJobs</code> operation returns a page of jobs at a time. The maximum size of the page is set by the <code>MaxResults</code> parameter. If the number of jobs exceeds what can fit on a page, Amazon Transcribe Medical returns the <code>NextPage</code> token. Include the token in the next request to the <code>ListMedicalTranscriptionJobs</code> operation to return in the next page of jobs.</p>', 'ListMedicalVocabulariesRequest$NextToken' => '<p>If the result of your previous request to <code>ListMedicalVocabularies</code> was truncated, include the <code>NextToken</code> to fetch the next set of vocabularies.</p>', 'ListMedicalVocabulariesResponse$NextToken' => '<p>The <code>ListMedicalVocabularies</code> operation returns a page of vocabularies at a time. You set the maximum number of vocabularies to return on a page with the <code>MaxResults</code> parameter. If there are more jobs in the list will fit on a page, Amazon Transcribe Medical returns the <code>NextPage</code> token. To return the next page of vocabularies, include the token in the next request to the <code>ListMedicalVocabularies</code> operation .</p>', 'ListTranscriptionJobsRequest$NextToken' => '<p>If the result of the previous request to <code>ListTranscriptionJobs</code> is truncated, include the <code>NextToken</code> to fetch the next set of jobs.</p>', 'ListTranscriptionJobsResponse$NextToken' => '<p>The <code>ListTranscriptionJobs</code> operation returns a page of jobs at a time. The maximum size of the page is set by the <code>MaxResults</code> parameter. If there are more jobs in the list than the page size, Amazon Transcribe returns the <code>NextPage</code> token. Include the token in the next request to the <code>ListTranscriptionJobs</code> operation to return in the next page of jobs.</p>', 'ListVocabulariesRequest$NextToken' => '<p>If the result of the previous request to <code>ListVocabularies</code> was truncated, include the <code>NextToken</code> to fetch the next set of jobs.</p>', 'ListVocabulariesResponse$NextToken' => '<p>The <code>ListVocabularies</code> operation returns a page of vocabularies at a time. The maximum size of the page is set in the <code>MaxResults</code> parameter. If there are more jobs in the list than will fit on the page, Amazon Transcribe returns the <code>NextPage</code> token. To return in the next page of jobs, include the token in the next request to the <code>ListVocabularies</code> operation.</p>', 'ListVocabularyFiltersRequest$NextToken' => '<p>If the result of the previous request to <code>ListVocabularyFilters</code> was truncated, include the <code>NextToken</code> to fetch the next set of collections.</p>', 'ListVocabularyFiltersResponse$NextToken' => '<p>The <code>ListVocabularyFilters</code> operation returns a page of collections at a time. The maximum size of the page is set by the <code>MaxResults</code> parameter. If there are more jobs in the list than the page size, Amazon Transcribe returns the <code>NextPage</code> token. Include the token in the next request to the <code>ListVocabularyFilters</code> operation to return in the next page of jobs.</p>', ], ], 'NonEmptyString' => [ 'base' => NULL, 'refs' => [ 'KMSEncryptionContextMap$key' => NULL, 'KMSEncryptionContextMap$value' => NULL, 'StringTargetList$member' => NULL, ], ], 'NonTalkTimeFilter' => [ 'base' => '<p>An object that enables you to configure your category to be applied to call analytics jobs where either the customer or agent was interrupted.</p>', 'refs' => [ 'Rule$NonTalkTimeFilter' => '<p>A condition for a time period when neither the customer nor the agent was talking.</p>', ], ], 'NotFoundException' => [ 'base' => '<p>We can\'t find the requested resource. Check the name and try your request again.</p>', 'refs' => [], ], 'OutputBucketName' => [ 'base' => NULL, 'refs' => [ 'StartMedicalTranscriptionJobRequest$OutputBucketName' => '<p>The Amazon S3 location where the transcription is stored.</p> <p>You must set <code>OutputBucketName</code> for Amazon Transcribe Medical to store the transcription results. Your transcript appears in the S3 location you specify. When you call the <a>GetMedicalTranscriptionJob</a>, the operation returns this location in the <code>TranscriptFileUri</code> field. The S3 bucket must have permissions that allow Amazon Transcribe Medical to put files in the bucket. For more information, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/security_iam_id-based-policy-examples.html#auth-role-iam-user">Permissions Required for IAM User Roles</a>.</p> <p>You can specify an Amazon Web Services Key Management Service (KMS) key to encrypt the output of your transcription using the <code>OutputEncryptionKMSKeyId</code> parameter. If you don\'t specify a KMS key, Amazon Transcribe Medical uses the default Amazon S3 key for server-side encryption of transcripts that are placed in your S3 bucket.</p>', 'StartTranscriptionJobRequest$OutputBucketName' => '<p>The location where the transcription is stored.</p> <p>If you set the <code>OutputBucketName</code>, Amazon Transcribe puts the transcript in the specified S3 bucket. When you call the <a>GetTranscriptionJob</a> operation, the operation returns this location in the <code>TranscriptFileUri</code> field. If you enable content redaction, the redacted transcript appears in <code>RedactedTranscriptFileUri</code>. If you enable content redaction and choose to output an unredacted transcript, that transcript\'s location still appears in the <code>TranscriptFileUri</code>. The S3 bucket must have permissions that allow Amazon Transcribe to put files in the bucket. For more information, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/security_iam_id-based-policy-examples.html#auth-role-iam-user">Permissions Required for IAM User Roles</a>.</p> <p>You can specify an Amazon Web Services Key Management Service (KMS) key to encrypt the output of your transcription using the <code>OutputEncryptionKMSKeyId</code> parameter. If you don\'t specify a KMS key, Amazon Transcribe uses the default Amazon S3 key for server-side encryption of transcripts that are placed in your S3 bucket.</p> <p>If you don\'t set the <code>OutputBucketName</code>, Amazon Transcribe generates a pre-signed URL, a shareable URL that provides secure access to your transcription, and returns it in the <code>TranscriptFileUri</code> field. Use this URL to download the transcription.</p>', ], ], 'OutputKey' => [ 'base' => NULL, 'refs' => [ 'StartMedicalTranscriptionJobRequest$OutputKey' => '<p>You can specify a location in an Amazon S3 bucket to store the output of your medical transcription job.</p> <p>If you don\'t specify an output key, Amazon Transcribe Medical stores the output of your transcription job in the Amazon S3 bucket you specified. By default, the object key is "your-transcription-job-name.json".</p> <p>You can use output keys to specify the Amazon S3 prefix and file name of the transcription output. For example, specifying the Amazon S3 prefix, "folder1/folder2/", as an output key would lead to the output being stored as "folder1/folder2/your-transcription-job-name.json". If you specify "my-other-job-name.json" as the output key, the object key is changed to "my-other-job-name.json". You can use an output key to change both the prefix and the file name, for example "folder/my-other-job-name.json".</p> <p>If you specify an output key, you must also specify an S3 bucket in the <code>OutputBucketName</code> parameter.</p>', 'StartTranscriptionJobRequest$OutputKey' => '<p>You can specify a location in an Amazon S3 bucket to store the output of your transcription job.</p> <p>If you don\'t specify an output key, Amazon Transcribe stores the output of your transcription job in the Amazon S3 bucket you specified. By default, the object key is "your-transcription-job-name.json".</p> <p>You can use output keys to specify the Amazon S3 prefix and file name of the transcription output. For example, specifying the Amazon S3 prefix, "folder1/folder2/", as an output key would lead to the output being stored as "folder1/folder2/your-transcription-job-name.json". If you specify "my-other-job-name.json" as the output key, the object key is changed to "my-other-job-name.json". You can use an output key to change both the prefix and the file name, for example "folder/my-other-job-name.json".</p> <p>If you specify an output key, you must also specify an S3 bucket in the <code>OutputBucketName</code> parameter.</p>', ], ], 'OutputLocationType' => [ 'base' => NULL, 'refs' => [ 'MedicalTranscriptionJobSummary$OutputLocationType' => '<p>Indicates the location of the transcription job\'s output. This field must be the path of an S3 bucket; if you don\'t already have an S3 bucket, one is created based on the path you add.</p>', 'TranscriptionJobSummary$OutputLocationType' => '<p>Indicates the location of the output of the transcription job.</p> <p>If the value is <code>CUSTOMER_BUCKET</code> then the location is the S3 bucket specified in the <code>outputBucketName</code> field when the transcription job was started with the <code>StartTranscriptionJob</code> operation.</p> <p>If the value is <code>SERVICE_BUCKET</code> then the output is stored by Amazon Transcribe and can be retrieved using the URI in the <code>GetTranscriptionJob</code> response\'s <code>TranscriptFileUri</code> field.</p>', ], ], 'ParticipantRole' => [ 'base' => NULL, 'refs' => [ 'ChannelDefinition$ParticipantRole' => '<p>Indicates whether the person speaking on the audio channel is the agent or customer.</p>', 'InterruptionFilter$ParticipantRole' => '<p>Indicates whether the caller or customer was interrupting.</p>', 'SentimentFilter$ParticipantRole' => '<p>A value that determines whether the sentiment belongs to the customer or the agent.</p>', 'TranscriptFilter$ParticipantRole' => '<p>Determines whether the customer or the agent is speaking the phrases that you\'ve specified.</p>', ], ], 'Percentage' => [ 'base' => NULL, 'refs' => [ 'RelativeTimeRange$StartPercentage' => '<p>A value that indicates the percentage of the beginning of the time range. To set a relative time range, you must specify a start percentage and an end percentage. For example, if you specify the following values:</p> <ul> <li> <p>StartPercentage - 10</p> </li> <li> <p>EndPercentage - 50</p> </li> </ul> <p>This looks at the time range starting from 10% of the way into the call to 50% of the way through the call. For a call that lasts 100,000 milliseconds, this example range would apply from the 10,000 millisecond mark to the 50,000 millisecond mark.</p>', 'RelativeTimeRange$EndPercentage' => '<p>A value that indicates the percentage of the end of the time range. To set a relative time range, you must specify a start percentage and an end percentage. For example, if you specify the following values:</p> <ul> <li> <p>StartPercentage - 10</p> </li> <li> <p>EndPercentage - 50</p> </li> </ul> <p>This looks at the time range starting from 10% of the way into the call to 50% of the way through the call. For a call that lasts 100,000 milliseconds, this example range would apply from the 10,000 millisecond mark to the 50,000 millisecond mark.</p>', 'RelativeTimeRange$First' => '<p>A range that takes the portion of the call up to the time in milliseconds set by the value that you\'ve specified. For example, if you specify <code>120000</code>, the time range is set for the first 120,000 milliseconds of the call.</p>', 'RelativeTimeRange$Last' => '<p>A range that takes the portion of the call from the time in milliseconds set by the value that you\'ve specified to the end of the call. For example, if you specify <code>120000</code>, the time range is set for the last 120,000 milliseconds of the call.</p>', ], ], 'Phrase' => [ 'base' => NULL, 'refs' => [ 'Phrases$member' => NULL, ], ], 'Phrases' => [ 'base' => NULL, 'refs' => [ 'CreateVocabularyRequest$Phrases' => '<p>An array of strings that contains the vocabulary entries. </p>', 'UpdateVocabularyRequest$Phrases' => '<p>An array of strings containing the vocabulary entries.</p>', ], ], 'RedactionOutput' => [ 'base' => NULL, 'refs' => [ 'ContentRedaction$RedactionOutput' => '<p>The output transcript file stored in either the default S3 bucket or in a bucket you specify.</p> <p>When you choose <code>redacted</code> Amazon Transcribe outputs only the redacted transcript.</p> <p>When you choose <code>redacted_and_unredacted</code> Amazon Transcribe outputs both the redacted and unredacted transcripts.</p>', ], ], 'RedactionType' => [ 'base' => NULL, 'refs' => [ 'ContentRedaction$RedactionType' => '<p>Request parameter that defines the entities to be redacted. The only accepted value is <code>PII</code>.</p>', ], ], 'RelativeTimeRange' => [ 'base' => '<p>An object that allows percentages to specify the proportion of the call where you would like to apply a filter. For example, you can specify the first half of the call. You can also specify the period of time between halfway through to three-quarters of the way through the call. Because the length of conversation can vary between calls, you can apply relative time ranges across all calls. </p>', 'refs' => [ 'InterruptionFilter$RelativeTimeRange' => '<p>An object that allows percentages to specify the proportion of the call where there was a interruption. For example, you can specify the first half of the call. You can also specify the period of time between halfway through to three-quarters of the way through the call. Because the length of conversation can vary between calls, you can apply relative time ranges across all calls.</p>', 'NonTalkTimeFilter$RelativeTimeRange' => '<p>An object that allows percentages to specify the proportion of the call where there was silence. For example, you can specify the first half of the call. You can also specify the period of time between halfway through to three-quarters of the way through the call. Because the length of conversation can vary between calls, you can apply relative time ranges across all calls.</p>', 'SentimentFilter$RelativeTimeRange' => '<p>The time range, set in percentages, that correspond to proportion of the call.</p>', 'TranscriptFilter$RelativeTimeRange' => '<p>An object that allows percentages to specify the proportion of the call where you would like to apply a filter. For example, you can specify the first half of the call. You can also specify the period of time between halfway through to three-quarters of the way through the call. Because the length of conversation can vary between calls, you can apply relative time ranges across all calls.</p>', ], ], 'Rule' => [ 'base' => '<p>A condition in the call between the customer and the agent that you want to filter for.</p>', 'refs' => [ 'RuleList$member' => NULL, ], ], 'RuleList' => [ 'base' => NULL, 'refs' => [ 'CategoryProperties$Rules' => '<p>The rules used to create a call analytics category.</p>', 'CreateCallAnalyticsCategoryRequest$Rules' => '<p>To create a category, you must specify between 1 and 20 rules. For each rule, you specify a filter to be applied to the attributes of the call. For example, you can specify a sentiment filter to detect if the customer\'s sentiment was negative or neutral. </p>', 'UpdateCallAnalyticsCategoryRequest$Rules' => '<p>The rules used for the updated analytics category. The rules that you provide in this field replace the ones that are currently being used. </p>', ], ], 'SentimentFilter' => [ 'base' => '<p>An object that enables you to specify a particular customer or agent sentiment. If at least 50 percent of the conversation turns (the back-and-forth between two speakers) in a specified time period match the specified sentiment, Amazon Transcribe will consider the sentiment a match.</p>', 'refs' => [ 'Rule$SentimentFilter' => '<p>A condition that is applied to a particular customer sentiment.</p>', ], ], 'SentimentValue' => [ 'base' => NULL, 'refs' => [ 'SentimentValueList$member' => NULL, ], ], 'SentimentValueList' => [ 'base' => NULL, 'refs' => [ 'SentimentFilter$Sentiments' => '<p>An array that enables you to specify sentiments for the customer or agent. You can specify one or more values.</p>', ], ], 'Settings' => [ 'base' => '<p>Provides optional settings for the <code>StartTranscriptionJob</code> operation.</p>', 'refs' => [ 'StartTranscriptionJobRequest$Settings' => '<p>A <code>Settings</code> object that provides optional settings for a transcription job.</p>', 'TranscriptionJob$Settings' => '<p>Optional settings for the transcription job. Use these settings to turn on speaker recognition, to set the maximum number of speakers that should be identified and to specify a custom vocabulary to use when processing the transcription job.</p>', ], ], 'Specialty' => [ 'base' => NULL, 'refs' => [ 'MedicalTranscriptionJob$Specialty' => '<p>The medical specialty of any clinicians providing a dictation or having a conversation. Refer to <a href="https://docs.aws.amazon.com/transcribe/latest/dg/transcribe-medical-conversation.html">Transcribing a medical conversation</a>for a list of supported specialties.</p>', 'MedicalTranscriptionJobSummary$Specialty' => '<p>The medical specialty of the transcription job. Refer to <a href="https://docs.aws.amazon.com/transcribe/latest/dg/transcribe-medical-conversation.html">Transcribing a medical conversation</a>for a list of supported specialties.</p>', 'StartMedicalTranscriptionJobRequest$Specialty' => '<p>The medical specialty of any clinician speaking in the input media.</p>', ], ], 'StartCallAnalyticsJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'StartCallAnalyticsJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'StartMedicalTranscriptionJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'StartMedicalTranscriptionJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'StartTranscriptionJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'StartTranscriptionJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'String' => [ 'base' => NULL, 'refs' => [ 'ConflictException$Message' => NULL, 'InternalFailureException$Message' => NULL, 'LimitExceededException$Message' => NULL, 'NotFoundException$Message' => NULL, ], ], 'StringTargetList' => [ 'base' => NULL, 'refs' => [ 'TranscriptFilter$Targets' => '<p>The phrases that you\'re specifying for the transcript filter to match.</p>', ], ], 'Tag' => [ 'base' => '<p>A key:value pair that adds metadata to a resource used by Amazon Transcribe. For example, a tag with the key:value pair ‘Department’:’Sales’ might be added to a resource to indicate its use by your organization\'s sales department.</p>', 'refs' => [ 'TagList$member' => NULL, ], ], 'TagKey' => [ 'base' => NULL, 'refs' => [ 'Tag$Key' => '<p>The first part of a key:value pair that forms a tag associated with a given resource. For example, in the tag ‘Department’:’Sales’, the key is \'Department\'.</p>', 'TagKeyList$member' => NULL, ], ], 'TagKeyList' => [ 'base' => NULL, 'refs' => [ 'UntagResourceRequest$TagKeys' => '<p>A list of tag keys you want to remove from a specified Amazon Transcribe resource.</p>', ], ], 'TagList' => [ 'base' => NULL, 'refs' => [ 'CreateLanguageModelRequest$Tags' => '<p>Adds one or more tags, each in the form of a key:value pair, to a new language model at the time you create this new model.</p>', 'CreateMedicalVocabularyRequest$Tags' => '<p>Adds one or more tags, each in the form of a key:value pair, to a new medical vocabulary at the time you create this new vocabulary.</p>', 'CreateVocabularyFilterRequest$Tags' => '<p>Adds one or more tags, each in the form of a key:value pair, to a new Amazon Transcribe vocabulary filter at the time you create this new vocabulary filter.</p>', 'CreateVocabularyRequest$Tags' => '<p>Adds one or more tags, each in the form of a key:value pair, to a new Amazon Transcribe vocabulary at the time you create this new vocabulary.</p>', 'ListTagsForResourceResponse$Tags' => '<p>Lists all tags associated with the given transcription job, vocabulary, or resource.</p>', 'MedicalTranscriptionJob$Tags' => '<p>A key:value pair assigned to a given medical transcription job.</p>', 'StartMedicalTranscriptionJobRequest$Tags' => '<p>Add tags to an Amazon Transcribe medical transcription job.</p>', 'StartTranscriptionJobRequest$Tags' => '<p>Add tags to an Amazon Transcribe transcription job.</p>', 'TagResourceRequest$Tags' => '<p>The tags you are assigning to a given Amazon Transcribe resource.</p>', 'TranscriptionJob$Tags' => '<p>A key:value pair assigned to a given transcription job.</p>', ], ], 'TagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'TagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'TagValue' => [ 'base' => NULL, 'refs' => [ 'Tag$Value' => '<p>The second part of a key:value pair that forms a tag associated with a given resource. For example, in the tag ‘Department’:’Sales’, the value is \'Sales\'.</p>', ], ], 'TimestampMilliseconds' => [ 'base' => NULL, 'refs' => [ 'AbsoluteTimeRange$StartTime' => '<p>A value that indicates the beginning of the time range in seconds. To set absolute time range, you must specify a start time and an end time. For example, if you specify the following values:</p> <ul> <li> <p>StartTime - 10000</p> </li> <li> <p>Endtime - 50000</p> </li> </ul> <p>The time range is set between 10,000 milliseconds and 50,000 milliseconds into the call.</p>', 'AbsoluteTimeRange$EndTime' => '<p>A value that indicates the end of the time range in milliseconds. To set absolute time range, you must specify a start time and an end time. For example, if you specify the following values:</p> <ul> <li> <p>StartTime - 10000</p> </li> <li> <p>Endtime - 50000</p> </li> </ul> <p>The time range is set between 10,000 milliseconds and 50,000 milliseconds into the call. </p>', 'AbsoluteTimeRange$First' => '<p>A time range from the beginning of the call to the value that you\'ve specified. For example, if you specify 100000, the time range is set to the first 100,000 milliseconds of the call.</p>', 'AbsoluteTimeRange$Last' => '<p>A time range from the value that you\'ve specified to the end of the call. For example, if you specify 100000, the time range is set to the last 100,000 milliseconds of the call.</p>', 'InterruptionFilter$Threshold' => '<p>The duration of the interruption.</p>', 'NonTalkTimeFilter$Threshold' => '<p>The duration of the period when neither the customer nor agent was talking.</p>', ], ], 'TranscribeArn' => [ 'base' => NULL, 'refs' => [ 'ListTagsForResourceRequest$ResourceArn' => '<p>Lists all tags associated with a given Amazon Resource Name (ARN).</p>', 'ListTagsForResourceResponse$ResourceArn' => '<p>Lists all tags associated with the given Amazon Resource Name (ARN).</p>', 'TagResourceRequest$ResourceArn' => '<p>The Amazon Resource Name (ARN) of the Amazon Transcribe resource you want to tag.</p>', 'UntagResourceRequest$ResourceArn' => '<p>The Amazon Resource Name (ARN) of the Amazon Transcribe resource you want to remove tags from.</p>', ], ], 'Transcript' => [ 'base' => '<p>Identifies the location of a transcription.</p>', 'refs' => [ 'CallAnalyticsJob$Transcript' => NULL, 'TranscriptionJob$Transcript' => '<p>An object that describes the output of the transcription job.</p>', ], ], 'TranscriptFilter' => [ 'base' => '<p>Matches the output of the transcription to either the specific phrases that you specify, or the intent of the phrases that you specify.</p>', 'refs' => [ 'Rule$TranscriptFilter' => '<p>A condition that catches particular words or phrases based on a exact match. For example, if you set the phrase "I want to speak to the manager", only that exact phrase will be returned.</p>', ], ], 'TranscriptFilterType' => [ 'base' => NULL, 'refs' => [ 'TranscriptFilter$TranscriptFilterType' => '<p>Matches the phrase to the transcription output in a word for word fashion. For example, if you specify the phrase "I want to speak to the manager." Amazon Transcribe attempts to match that specific phrase to the transcription.</p>', ], ], 'TranscriptionJob' => [ 'base' => '<p>Describes an asynchronous transcription job that was created with the <code>StartTranscriptionJob</code> operation. </p>', 'refs' => [ 'GetTranscriptionJobResponse$TranscriptionJob' => '<p>An object that contains the results of the transcription job.</p>', 'StartTranscriptionJobResponse$TranscriptionJob' => '<p>An object containing details of the asynchronous transcription job.</p>', ], ], 'TranscriptionJobName' => [ 'base' => NULL, 'refs' => [ 'DeleteMedicalTranscriptionJobRequest$MedicalTranscriptionJobName' => '<p>The name you provide to the <code>DeleteMedicalTranscriptionJob</code> object to delete a transcription job.</p>', 'DeleteTranscriptionJobRequest$TranscriptionJobName' => '<p>The name of the transcription job to be deleted.</p>', 'GetMedicalTranscriptionJobRequest$MedicalTranscriptionJobName' => '<p>The name of the medical transcription job.</p>', 'GetTranscriptionJobRequest$TranscriptionJobName' => '<p>The name of the job.</p>', 'ListMedicalTranscriptionJobsRequest$JobNameContains' => '<p>When specified, the jobs returned in the list are limited to jobs whose name contains the specified string.</p>', 'ListTranscriptionJobsRequest$JobNameContains' => '<p>When specified, the jobs returned in the list are limited to jobs whose name contains the specified string.</p>', 'MedicalTranscriptionJob$MedicalTranscriptionJobName' => '<p>The name for a given medical transcription job.</p>', 'MedicalTranscriptionJobSummary$MedicalTranscriptionJobName' => '<p>The name of a medical transcription job.</p>', 'StartMedicalTranscriptionJobRequest$MedicalTranscriptionJobName' => '<p>The name of the medical transcription job. You can\'t use the strings "<code>.</code>" or "<code>..</code>" by themselves as the job name. The name must also be unique within an Amazon Web Services account. If you try to create a medical transcription job with the same name as a previous medical transcription job, you get a <code>ConflictException</code> error.</p>', 'StartTranscriptionJobRequest$TranscriptionJobName' => '<p>The name of the job. You can\'t use the strings "<code>.</code>" or "<code>..</code>" by themselves as the job name. The name must also be unique within an Amazon Web Services account. If you try to create a transcription job with the same name as a previous transcription job, you get a <code>ConflictException</code> error.</p>', 'TranscriptionJob$TranscriptionJobName' => '<p>The name of the transcription job.</p>', 'TranscriptionJobSummary$TranscriptionJobName' => '<p>The name of the transcription job.</p>', ], ], 'TranscriptionJobStatus' => [ 'base' => NULL, 'refs' => [ 'ListMedicalTranscriptionJobsRequest$Status' => '<p>When specified, returns only medical transcription jobs with the specified status. Jobs are ordered by creation date, with the newest jobs returned first. If you don\'t specify a status, Amazon Transcribe Medical returns all transcription jobs ordered by creation date.</p>', 'ListMedicalTranscriptionJobsResponse$Status' => '<p>The requested status of the medical transcription jobs returned.</p>', 'ListTranscriptionJobsRequest$Status' => '<p>When specified, returns only transcription jobs with the specified status. Jobs are ordered by creation date, with the newest jobs returned first. If you don’t specify a status, Amazon Transcribe returns all transcription jobs ordered by creation date.</p>', 'ListTranscriptionJobsResponse$Status' => '<p>The requested status of the jobs returned.</p>', 'MedicalTranscriptionJob$TranscriptionJobStatus' => '<p>The completion status of a medical transcription job.</p>', 'MedicalTranscriptionJobSummary$TranscriptionJobStatus' => '<p>The status of the medical transcription job.</p>', 'TranscriptionJob$TranscriptionJobStatus' => '<p>The status of the transcription job.</p>', 'TranscriptionJobSummary$TranscriptionJobStatus' => '<p>The status of the transcription job. When the status is <code>COMPLETED</code>, use the <code>GetTranscriptionJob</code> operation to get the results of the transcription.</p>', ], ], 'TranscriptionJobSummaries' => [ 'base' => NULL, 'refs' => [ 'ListTranscriptionJobsResponse$TranscriptionJobSummaries' => '<p>A list of objects containing summary information for a transcription job.</p>', ], ], 'TranscriptionJobSummary' => [ 'base' => '<p>Provides a summary of information about a transcription job.</p>', 'refs' => [ 'TranscriptionJobSummaries$member' => NULL, ], ], 'Type' => [ 'base' => NULL, 'refs' => [ 'MedicalTranscriptionJob$Type' => '<p>The type of speech in the transcription job. <code>CONVERSATION</code> is generally used for patient-physician dialogues. <code>DICTATION</code> is the setting for physicians speaking their notes after seeing a patient. For more information, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/what-is-transcribe-med.html">What is Amazon Transcribe Medical?</a>.</p>', 'MedicalTranscriptionJobSummary$Type' => '<p>The speech of the clinician in the input audio.</p>', 'StartMedicalTranscriptionJobRequest$Type' => '<p>The type of speech in the input audio. <code>CONVERSATION</code> refers to conversations between two or more speakers, e.g., a conversations between doctors and patients. <code>DICTATION</code> refers to single-speaker dictated speech, such as clinical notes.</p>', ], ], 'UntagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'UntagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateCallAnalyticsCategoryRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateCallAnalyticsCategoryResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateMedicalVocabularyRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateMedicalVocabularyResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateVocabularyFilterRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateVocabularyFilterResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateVocabularyRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateVocabularyResponse' => [ 'base' => NULL, 'refs' => [], ], 'Uri' => [ 'base' => NULL, 'refs' => [ 'CreateMedicalVocabularyRequest$VocabularyFileUri' => '<p>The location in Amazon S3 of the text file you use to define your custom vocabulary. The URI must be in the same Amazon Web Services Region as the resource that you\'re calling. Enter information about your <code>VocabularyFileUri</code> in the following format:</p> <p> <code> https://s3.&lt;aws-region&gt;.amazonaws.com/&lt;bucket-name&gt;/&lt;keyprefix&gt;/&lt;objectkey&gt; </code> </p> <p>The following is an example URI for a vocabulary file that is stored in Amazon S3:</p> <p> <code>https://s3.us-east-1.amazonaws.com/AWSDOC-EXAMPLE-BUCKET/vocab.txt</code> </p> <p>For more information about Amazon S3 object names, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingMetadata.html#object-keys">Object Keys</a> in the <i>Amazon S3 Developer Guide</i>.</p> <p>For more information about custom vocabularies, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/how-it-works.html#how-vocabulary-med">Medical Custom Vocabularies</a>.</p>', 'CreateVocabularyFilterRequest$VocabularyFilterFileUri' => '<p>The Amazon S3 location of a text file used as input to create the vocabulary filter. Only use characters from the character set defined for custom vocabularies. For a list of character sets, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/how-vocabulary.html#charsets">Character Sets for Custom Vocabularies</a>.</p> <p>The specified file must be less than 50 KB of UTF-8 characters.</p> <p>If you provide the location of a list of words in the <code>VocabularyFilterFileUri</code> parameter, you can\'t use the <code>Words</code> parameter.</p>', 'CreateVocabularyRequest$VocabularyFileUri' => '<p>The S3 location of the text file that contains the definition of the custom vocabulary. The URI must be in the same region as the API endpoint that you are calling. The general form is:</p> <p>For more information about S3 object names, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingMetadata.html#object-keys">Object Keys</a> in the <i>Amazon S3 Developer Guide</i>.</p> <p>For more information about custom vocabularies, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/how-vocabulary">Custom vocabularies</a>.</p>', 'GetMedicalVocabularyResponse$DownloadUri' => '<p>The location in Amazon S3 where the vocabulary is stored. Use this URI to get the contents of the vocabulary. You can download your vocabulary from the URI for a limited time.</p>', 'GetVocabularyFilterResponse$DownloadUri' => '<p>The URI of the list of words in the vocabulary filter. You can use this URI to get the list of words.</p>', 'GetVocabularyResponse$DownloadUri' => '<p>The S3 location where the vocabulary is stored. Use this URI to get the contents of the vocabulary. The URI is available for a limited time.</p>', 'InputDataConfig$S3Uri' => '<p>The Amazon S3 prefix you specify to access the plain text files that you use to train your custom language model.</p>', 'InputDataConfig$TuningDataS3Uri' => '<p>The Amazon S3 prefix you specify to access the plain text files that you use to tune your custom language model.</p>', 'Media$MediaFileUri' => '<p>The S3 object location of the input media file. The URI must be in the same region as the API endpoint that you are calling. The general form is:</p> <p>For example:</p> <p>For more information about S3 object names, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingMetadata.html#object-keys">Object Keys</a> in the <i>Amazon S3 Developer Guide</i>.</p>', 'Media$RedactedMediaFileUri' => '<p> The S3 object location for your redacted output media file. This is only supported for call analytics jobs.</p>', 'MedicalTranscript$TranscriptFileUri' => '<p>The S3 object location of the medical transcript.</p> <p>Use this URI to access the medical transcript. This URI points to the S3 bucket you created to store the medical transcript.</p>', 'StartCallAnalyticsJobRequest$OutputLocation' => '<p>The Amazon S3 location where the output of the call analytics job is stored. You can provide the following location types to store the output of call analytics job:</p> <ul> <li> <p>s3://DOC-EXAMPLE-BUCKET1</p> <p> If you specify a bucket, Amazon Transcribe saves the output of the analytics job as a JSON file at the root level of the bucket.</p> </li> <li> <p>s3://DOC-EXAMPLE-BUCKET1/folder/</p> <p>f you specify a path, Amazon Transcribe saves the output of the analytics job as s3://DOC-EXAMPLE-BUCKET1/folder/your-transcription-job-name.json</p> <p>If you specify a folder, you must provide a trailing slash.</p> </li> <li> <p>s3://DOC-EXAMPLE-BUCKET1/folder/filename.json</p> <p> If you provide a path that has the filename specified, Amazon Transcribe saves the output of the analytics job as s3://DOC-EXAMPLEBUCKET1/folder/filename.json</p> </li> </ul> <p>You can specify an Amazon Web Services Key Management Service (KMS) key to encrypt the output of our analytics job using the <code>OutputEncryptionKMSKeyId</code> parameter. If you don\'t specify a KMS key, Amazon Transcribe uses the default Amazon S3 key for server-side encryption of the analytics job output that is placed in your S3 bucket.</p>', 'Transcript$TranscriptFileUri' => '<p>The S3 object location of the transcript.</p> <p>Use this URI to access the transcript. If you specified an S3 bucket in the <code>OutputBucketName</code> field when you created the job, this is the URI of that bucket. If you chose to store the transcript in Amazon Transcribe, this is a shareable URL that provides secure access to that location.</p>', 'Transcript$RedactedTranscriptFileUri' => '<p>The S3 object location of the redacted transcript.</p> <p>Use this URI to access the redacted transcript. If you specified an S3 bucket in the <code>OutputBucketName</code> field when you created the job, this is the URI of that bucket. If you chose to store the transcript in Amazon Transcribe, this is a shareable URL that provides secure access to that location.</p>', 'UpdateMedicalVocabularyRequest$VocabularyFileUri' => '<p>The location in Amazon S3 of the text file that contains your custom vocabulary. The URI must be in the same Amazon Web Services Region as the resource that you are calling. The following is the format for a URI:</p> <p> <code> https://s3.&lt;aws-region&gt;.amazonaws.com/&lt;bucket-name&gt;/&lt;keyprefix&gt;/&lt;objectkey&gt; </code> </p> <p>For example:</p> <p> <code>https://s3.us-east-1.amazonaws.com/AWSDOC-EXAMPLE-BUCKET/vocab.txt</code> </p> <p>For more information about Amazon S3 object names, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingMetadata.html#object-keys">Object Keys</a> in the <i>Amazon S3 Developer Guide</i>.</p> <p>For more information about custom vocabularies in Amazon Transcribe Medical, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/how-it-works.html#how-vocabulary">Medical Custom Vocabularies</a>.</p>', 'UpdateVocabularyFilterRequest$VocabularyFilterFileUri' => '<p>The Amazon S3 location of a text file used as input to create the vocabulary filter. Only use characters from the character set defined for custom vocabularies. For a list of character sets, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/how-vocabulary.html#charsets">Character Sets for Custom Vocabularies</a>.</p> <p>The specified file must be less than 50 KB of UTF-8 characters.</p> <p>If you provide the location of a list of words in the <code>VocabularyFilterFileUri</code> parameter, you can\'t use the <code>Words</code> parameter.</p>', 'UpdateVocabularyRequest$VocabularyFileUri' => '<p>The S3 location of the text file that contains the definition of the custom vocabulary. The URI must be in the same region as the API endpoint that you are calling. The general form is </p> <p>For example:</p> <p>For more information about S3 object names, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingMetadata.html#object-keys">Object Keys</a> in the <i>Amazon S3 Developer Guide</i>.</p> <p>For more information about custom vocabularies, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/how-it-works.html#how-vocabulary">Custom Vocabularies</a>.</p>', ], ], 'Vocabularies' => [ 'base' => NULL, 'refs' => [ 'ListMedicalVocabulariesResponse$Vocabularies' => '<p>A list of objects that describe the vocabularies that match your search criteria.</p>', 'ListVocabulariesResponse$Vocabularies' => '<p>A list of objects that describe the vocabularies that match the search criteria in the request.</p>', ], ], 'VocabularyFilterInfo' => [ 'base' => '<p>Provides information about a vocabulary filter.</p>', 'refs' => [ 'VocabularyFilters$member' => NULL, ], ], 'VocabularyFilterMethod' => [ 'base' => NULL, 'refs' => [ 'CallAnalyticsJobSettings$VocabularyFilterMethod' => '<p>Set to mask to remove filtered text from the transcript and replace it with three asterisks ("***") as placeholder text. Set to <code>remove</code> to remove filtered text from the transcript without using placeholder text. Set to <code>tag</code> to mark the word in the transcription output that matches the vocabulary filter. When you set the filter method to <code>tag</code>, the words matching your vocabulary filter are not masked or removed.</p>', 'Settings$VocabularyFilterMethod' => '<p>Set to <code>mask</code> to remove filtered text from the transcript and replace it with three asterisks ("***") as placeholder text. Set to <code>remove</code> to remove filtered text from the transcript without using placeholder text. Set to <code>tag</code> to mark the word in the transcription output that matches the vocabulary filter. When you set the filter method to <code>tag</code>, the words matching your vocabulary filter are not masked or removed.</p>', ], ], 'VocabularyFilterName' => [ 'base' => NULL, 'refs' => [ 'CallAnalyticsJobSettings$VocabularyFilterName' => '<p>The name of the vocabulary filter to use when running a call analytics job. The filter that you specify must have the same language code as the analytics job.</p>', 'CreateVocabularyFilterRequest$VocabularyFilterName' => '<p>The vocabulary filter name. The name must be unique within the account that contains it. If you try to create a vocabulary filter with the same name as another vocabulary filter, you get a <code>ConflictException</code> error.</p>', 'CreateVocabularyFilterResponse$VocabularyFilterName' => '<p>The name of the vocabulary filter.</p>', 'DeleteVocabularyFilterRequest$VocabularyFilterName' => '<p>The name of the vocabulary filter to remove.</p>', 'GetVocabularyFilterRequest$VocabularyFilterName' => '<p>The name of the vocabulary filter for which to return information.</p>', 'GetVocabularyFilterResponse$VocabularyFilterName' => '<p>The name of the vocabulary filter.</p>', 'ListVocabularyFiltersRequest$NameContains' => '<p>Filters the response so that it only contains vocabulary filters whose name contains the specified string.</p>', 'Settings$VocabularyFilterName' => '<p>The name of the vocabulary filter to use when transcribing the audio. The filter that you specify must have the same language code as the transcription job.</p>', 'UpdateVocabularyFilterRequest$VocabularyFilterName' => '<p>The name of the vocabulary filter to update. If you try to update a vocabulary filter with the same name as another vocabulary filter, you get a <code>ConflictException</code> error.</p>', 'UpdateVocabularyFilterResponse$VocabularyFilterName' => '<p>The name of the updated vocabulary filter.</p>', 'VocabularyFilterInfo$VocabularyFilterName' => '<p>The name of the vocabulary filter. The name must be unique in the account that holds the filter.</p>', ], ], 'VocabularyFilters' => [ 'base' => NULL, 'refs' => [ 'ListVocabularyFiltersResponse$VocabularyFilters' => '<p>The list of vocabulary filters. It contains at most <code>MaxResults</code> number of filters. If there are more filters, call the <code>ListVocabularyFilters</code> operation again with the <code>NextToken</code> parameter in the request set to the value of the <code>NextToken</code> field in the response.</p>', ], ], 'VocabularyInfo' => [ 'base' => '<p>Provides information about a custom vocabulary. </p>', 'refs' => [ 'Vocabularies$member' => NULL, ], ], 'VocabularyName' => [ 'base' => NULL, 'refs' => [ 'CallAnalyticsJobSettings$VocabularyName' => '<p>The name of a vocabulary to use when processing the call analytics job.</p>', 'CreateMedicalVocabularyRequest$VocabularyName' => '<p>The name of the custom vocabulary. This case-sensitive name must be unique within an Amazon Web Services account. If you try to create a vocabulary with the same name as a previous vocabulary, you get a <code>ConflictException</code> error.</p>', 'CreateMedicalVocabularyResponse$VocabularyName' => '<p>The name of the vocabulary. The name must be unique within an Amazon Web Services account and is case sensitive.</p>', 'CreateVocabularyRequest$VocabularyName' => '<p>The name of the vocabulary. The name must be unique within an Amazon Web Services account. The name is case sensitive. If you try to create a vocabulary with the same name as a previous vocabulary you will receive a <code>ConflictException</code> error.</p>', 'CreateVocabularyResponse$VocabularyName' => '<p>The name of the vocabulary.</p>', 'DeleteMedicalVocabularyRequest$VocabularyName' => '<p>The name of the vocabulary that you want to delete.</p>', 'DeleteVocabularyRequest$VocabularyName' => '<p>The name of the vocabulary to delete. </p>', 'GetMedicalVocabularyRequest$VocabularyName' => '<p>The name of the vocabulary that you want information about. The value is case sensitive. </p>', 'GetMedicalVocabularyResponse$VocabularyName' => '<p>The name of the vocabulary returned by Amazon Transcribe Medical.</p>', 'GetVocabularyRequest$VocabularyName' => '<p>The name of the vocabulary to return information about. The name is case sensitive.</p>', 'GetVocabularyResponse$VocabularyName' => '<p>The name of the vocabulary to return.</p>', 'ListMedicalVocabulariesRequest$NameContains' => '<p>Returns vocabularies whose names contain the specified string. The search is not case sensitive. <code>ListMedicalVocabularies</code> returns both "<code>vocabularyname</code>" and "<code>VocabularyName</code>".</p>', 'ListVocabulariesRequest$NameContains' => '<p>When specified, the vocabularies returned in the list are limited to vocabularies whose name contains the specified string. The search is not case sensitive, <code>ListVocabularies</code> returns both "vocabularyname" and "VocabularyName" in the response list.</p>', 'MedicalTranscriptionSetting$VocabularyName' => '<p>The name of the vocabulary to use when processing a medical transcription job.</p>', 'Settings$VocabularyName' => '<p>The name of a vocabulary to use when processing the transcription job.</p>', 'UpdateMedicalVocabularyRequest$VocabularyName' => '<p>The name of the vocabulary to update. The name is case sensitive. If you try to update a vocabulary with the same name as a vocabulary you\'ve already made, you get a <code>ConflictException</code> error.</p>', 'UpdateMedicalVocabularyResponse$VocabularyName' => '<p>The name of the updated vocabulary.</p>', 'UpdateVocabularyRequest$VocabularyName' => '<p>The name of the vocabulary to update. The name is case sensitive. If you try to update a vocabulary with the same name as a previous vocabulary you will receive a <code>ConflictException</code> error.</p>', 'UpdateVocabularyResponse$VocabularyName' => '<p>The name of the vocabulary that was updated.</p>', 'VocabularyInfo$VocabularyName' => '<p>The name of the vocabulary.</p>', ], ], 'VocabularyState' => [ 'base' => NULL, 'refs' => [ 'CreateMedicalVocabularyResponse$VocabularyState' => '<p>The processing state of your custom vocabulary in Amazon Transcribe Medical. If the state is <code>READY</code>, you can use the vocabulary in a <code>StartMedicalTranscriptionJob</code> request.</p>', 'CreateVocabularyResponse$VocabularyState' => '<p>The processing state of the vocabulary. When the <code>VocabularyState</code> field contains <code>READY</code> the vocabulary is ready to be used in a <code>StartTranscriptionJob</code> request.</p>', 'GetMedicalVocabularyResponse$VocabularyState' => '<p>The processing state of the vocabulary. If the <code>VocabularyState</code> is <code>READY</code> then you can use it in the <code>StartMedicalTranscriptionJob</code> operation.</p>', 'GetVocabularyResponse$VocabularyState' => '<p>The processing state of the vocabulary.</p>', 'ListMedicalVocabulariesRequest$StateEquals' => '<p>When specified, returns only vocabularies with the <code>VocabularyState</code> equal to the specified vocabulary state. Use this field to see which vocabularies are ready for your medical transcription jobs.</p>', 'ListMedicalVocabulariesResponse$Status' => '<p>The requested vocabulary state.</p>', 'ListVocabulariesRequest$StateEquals' => '<p>When specified, only returns vocabularies with the <code>VocabularyState</code> field equal to the specified state.</p>', 'ListVocabulariesResponse$Status' => '<p>The requested vocabulary state.</p>', 'UpdateMedicalVocabularyResponse$VocabularyState' => '<p>The processing state of the update to the vocabulary. When the <code>VocabularyState</code> field is <code>READY</code>, the vocabulary is ready to be used in a <code>StartMedicalTranscriptionJob</code> request.</p>', 'UpdateVocabularyResponse$VocabularyState' => '<p>The processing state of the vocabulary. When the <code>VocabularyState</code> field contains <code>READY</code> the vocabulary is ready to be used in a <code>StartTranscriptionJob</code> request.</p>', 'VocabularyInfo$VocabularyState' => '<p>The processing state of the vocabulary. If the state is <code>READY</code> you can use the vocabulary in a <code>StartTranscriptionJob</code> request.</p>', ], ], 'Word' => [ 'base' => NULL, 'refs' => [ 'Words$member' => NULL, ], ], 'Words' => [ 'base' => NULL, 'refs' => [ 'CreateVocabularyFilterRequest$Words' => '<p>The words to use in the vocabulary filter. Only use characters from the character set defined for custom vocabularies. For a list of character sets, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/how-vocabulary.html#charsets">Character Sets for Custom Vocabularies</a>.</p> <p>If you provide a list of words in the <code>Words</code> parameter, you can\'t use the <code>VocabularyFilterFileUri</code> parameter.</p>', 'UpdateVocabularyFilterRequest$Words' => '<p>The words to use in the vocabulary filter. Only use characters from the character set defined for custom vocabularies. For a list of character sets, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/how-vocabulary.html#charsets">Character Sets for Custom Vocabularies</a>.</p> <p>If you provide a list of words in the <code>Words</code> parameter, you can\'t use the <code>VocabularyFilterFileUri</code> parameter.</p>', ], ], ],];
