<?php
// This file was auto-generated from sdk-root/src/data/storagegateway/2013-06-30/docs-2.json
return [ 'version' => '2.0', 'service' => '<fullname>Storage Gateway Service</fullname> <p>Storage Gateway is the service that connects an on-premises software appliance with cloud-based storage to provide seamless and secure integration between an organization\'s on-premises IT environment and the Amazon Web Services storage infrastructure. The service enables you to securely upload data to the Cloud for cost effective backup and rapid disaster recovery.</p> <p>Use the following links to get started using the <i>Storage Gateway Service API Reference</i>:</p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/storagegateway/latest/userguide/AWSStorageGatewayAPI.html#AWSStorageGatewayHTTPRequestsHeaders">Storage Gateway required request headers</a>: Describes the required headers that you must send with every POST request to Storage Gateway.</p> </li> <li> <p> <a href="https://docs.aws.amazon.com/storagegateway/latest/userguide/AWSStorageGatewayAPI.html#AWSStorageGatewaySigningRequests">Signing requests</a>: Storage Gateway requires that you authenticate every request you send; this topic describes how sign such a request.</p> </li> <li> <p> <a href="https://docs.aws.amazon.com/storagegateway/latest/userguide/AWSStorageGatewayAPI.html#APIErrorResponses">Error responses</a>: Provides reference information about Storage Gateway errors.</p> </li> <li> <p> <a href="https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_Operations.html">Operations in Storage Gateway</a>: Contains detailed descriptions of all Storage Gateway operations, their request parameters, response elements, possible errors, and examples of requests and responses.</p> </li> <li> <p> <a href="https://docs.aws.amazon.com/general/latest/gr/sg.html">Storage Gateway endpoints and quotas</a>: Provides a list of each Region and the endpoints available for use with Storage Gateway.</p> </li> </ul> <note> <p>Storage Gateway resource IDs are in uppercase. When you use these resource IDs with the Amazon EC2 API, EC2 expects resource IDs in lowercase. You must change your resource ID to lowercase to use it with the EC2 API. For example, in Storage Gateway the ID for a volume might be <code>vol-AA22BB012345DAF670</code>. When you use this ID with the EC2 API, you must change it to <code>vol-aa22bb012345daf670</code>. Otherwise, the EC2 API might not behave as expected.</p> </note> <important> <p>IDs for Storage Gateway volumes and Amazon EBS snapshots created from gateway volumes are changing to a longer format. Starting in December 2016, all new volumes and snapshots will be created with a 17-character string. Starting in April 2016, you will be able to use these longer IDs so you can test your systems with the new format. For more information, see <a href="http://aws.amazon.com/ec2/faqs/#longer-ids">Longer EC2 and EBS resource IDs</a>.</p> <p>For example, a volume Amazon Resource Name (ARN) with the longer volume ID format looks like the following:</p> <p> <code>arn:aws:storagegateway:us-west-2:111122223333:gateway/sgw-12A3456B/volume/vol-1122AABBCCDDEEFFG</code>.</p> <p>A snapshot ID with the longer ID format looks like the following: <code>snap-78e226633445566ee</code>.</p> <p>For more information, see <a href="http://forums.aws.amazon.com/ann.jspa?annID=3557">Announcement: Heads-up – Longer Storage Gateway volume and snapshot IDs coming in 2016</a>.</p> </important>', 'operations' => [ 'ActivateGateway' => '<p>Activates the gateway you previously deployed on your host. In the activation process, you specify information such as the Region that you want to use for storing snapshots or tapes, the time zone for scheduled snapshots the gateway snapshot schedule window, an activation key, and a name for your gateway. The activation process also associates your gateway with your account. For more information, see <a>UpdateGatewayInformation</a>.</p> <note> <p>You must turn on the gateway VM before you can activate your gateway.</p> </note>', 'AddCache' => '<p>Configures one or more gateway local disks as cache for a gateway. This operation is only supported in the cached volume, tape, and file gateway type (see <a href="https://docs.aws.amazon.com/storagegateway/latest/userguide/StorageGatewayConcepts.html">How Storage Gateway works (architecture)</a>.</p> <p>In the request, you specify the gateway Amazon Resource Name (ARN) to which you want to add cache, and one or more disk IDs that you want to configure as cache.</p>', 'AddTagsToResource' => '<p>Adds one or more tags to the specified resource. You use tags to add metadata to resources, which you can use to categorize these resources. For example, you can categorize resources by purpose, owner, environment, or team. Each tag consists of a key and a value, which you define. You can add tags to the following Storage Gateway resources:</p> <ul> <li> <p>Storage gateways of all types</p> </li> <li> <p>Storage volumes</p> </li> <li> <p>Virtual tapes</p> </li> <li> <p>NFS and SMB file shares</p> </li> <li> <p>File System associations</p> </li> </ul> <p>You can create a maximum of 50 tags for each resource. Virtual tapes and storage volumes that are recovered to a new gateway maintain their tags.</p>', 'AddUploadBuffer' => '<p>Configures one or more gateway local disks as upload buffer for a specified gateway. This operation is supported for the stored volume, cached volume, and tape gateway types.</p> <p>In the request, you specify the gateway Amazon Resource Name (ARN) to which you want to add upload buffer, and one or more disk IDs that you want to configure as upload buffer.</p>', 'AddWorkingStorage' => '<p>Configures one or more gateway local disks as working storage for a gateway. This operation is only supported in the stored volume gateway type. This operation is deprecated in cached volume API version 20120630. Use <a>AddUploadBuffer</a> instead.</p> <note> <p>Working storage is also referred to as upload buffer. You can also use the <a>AddUploadBuffer</a> operation to add upload buffer to a stored volume gateway.</p> </note> <p>In the request, you specify the gateway Amazon Resource Name (ARN) to which you want to add working storage, and one or more disk IDs that you want to configure as working storage.</p>', 'AssignTapePool' => '<p>Assigns a tape to a tape pool for archiving. The tape assigned to a pool is archived in the S3 storage class that is associated with the pool. When you use your backup application to eject the tape, the tape is archived directly into the S3 storage class (S3 Glacier or S3 Glacier Deep Archive) that corresponds to the pool.</p> <p>Valid Values: <code>GLACIER</code> | <code>DEEP_ARCHIVE</code> </p>', 'AssociateFileSystem' => '<p>Associate an Amazon FSx file system with the FSx File Gateway. After the association process is complete, the file shares on the Amazon FSx file system are available for access through the gateway. This operation only supports the FSx File Gateway type.</p>', 'AttachVolume' => '<p>Connects a volume to an iSCSI connection and then attaches the volume to the specified gateway. Detaching and attaching a volume enables you to recover your data from one gateway to a different gateway without creating a snapshot. It also makes it easier to move your volumes from an on-premises gateway to a gateway hosted on an Amazon EC2 instance.</p>', 'CancelArchival' => '<p>Cancels archiving of a virtual tape to the virtual tape shelf (VTS) after the archiving process is initiated. This operation is only supported in the tape gateway type.</p>', 'CancelRetrieval' => '<p>Cancels retrieval of a virtual tape from the virtual tape shelf (VTS) to a gateway after the retrieval process is initiated. The virtual tape is returned to the VTS. This operation is only supported in the tape gateway type.</p>', 'CreateCachediSCSIVolume' => '<p>Creates a cached volume on a specified cached volume gateway. This operation is only supported in the cached volume gateway type.</p> <note> <p>Cache storage must be allocated to the gateway before you can create a cached volume. Use the <a>AddCache</a> operation to add cache storage to a gateway.</p> </note> <p>In the request, you must specify the gateway, size of the volume in bytes, the iSCSI target name, an IP address on which to expose the target, and a unique client token. In response, the gateway creates the volume and returns information about it. This information includes the volume Amazon Resource Name (ARN), its size, and the iSCSI target ARN that initiators can use to connect to the volume target.</p> <p>Optionally, you can provide the ARN for an existing volume as the <code>SourceVolumeARN</code> for this cached volume, which creates an exact copy of the existing volume’s latest recovery point. The <code>VolumeSizeInBytes</code> value must be equal to or larger than the size of the copied volume, in bytes.</p>', 'CreateNFSFileShare' => '<p>Creates a Network File System (NFS) file share on an existing S3 File Gateway. In Storage Gateway, a file share is a file system mount point backed by Amazon S3 cloud storage. Storage Gateway exposes file shares using an NFS interface. This operation is only supported for S3 File Gateways.</p> <important> <p>S3 File gateway requires Security Token Service (STS) to be activated to enable you to create a file share. Make sure STS is activated in the Region you are creating your S3 File Gateway in. If STS is not activated in the Region, activate it. For information about how to activate STS, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_enable-regions.html">Activating and deactivating STS in an Region</a> in the <i>Identity and Access Management User Guide</i>.</p> <p>S3 File Gateways do not support creating hard or symbolic links on a file share.</p> </important>', 'CreateSMBFileShare' => '<p>Creates a Server Message Block (SMB) file share on an existing S3 File Gateway. In Storage Gateway, a file share is a file system mount point backed by Amazon S3 cloud storage. Storage Gateway exposes file shares using an SMB interface. This operation is only supported for S3 File Gateways.</p> <important> <p>S3 File Gateways require Security Token Service (STS) to be activated to enable you to create a file share. Make sure that STS is activated in the Region you are creating your S3 File Gateway in. If STS is not activated in this Region, activate it. For information about how to activate STS, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_enable-regions.html">Activating and deactivating STS in an Region</a> in the <i>Identity and Access Management User Guide</i>.</p> <p>File gateways don\'t support creating hard or symbolic links on a file share.</p> </important>', 'CreateSnapshot' => '<p>Initiates a snapshot of a volume.</p> <p>Storage Gateway provides the ability to back up point-in-time snapshots of your data to Amazon Simple Storage (Amazon S3) for durable off-site recovery, and also import the data to an Amazon Elastic Block Store (EBS) volume in Amazon Elastic Compute Cloud (EC2). You can take snapshots of your gateway volume on a scheduled or ad hoc basis. This API enables you to take an ad hoc snapshot. For more information, see <a href="https://docs.aws.amazon.com/storagegateway/latest/userguide/managing-volumes.html#SchedulingSnapshot">Editing a snapshot schedule</a>.</p> <p>In the <code>CreateSnapshot</code> request, you identify the volume by providing its Amazon Resource Name (ARN). You must also provide description for the snapshot. When Storage Gateway takes the snapshot of specified volume, the snapshot and description appears in the Storage Gateway console. In response, Storage Gateway returns you a snapshot ID. You can use this snapshot ID to check the snapshot progress or later use it when you want to create a volume from a snapshot. This operation is only supported in stored and cached volume gateway type.</p> <note> <p>To list or delete a snapshot, you must use the Amazon EC2 API. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeSnapshots.html">DescribeSnapshots</a> or <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeleteSnapshot.html">DeleteSnapshot</a> in the <i>Amazon Elastic Compute Cloud API Reference</i>.</p> </note> <important> <p>Volume and snapshot IDs are changing to a longer length ID format. For more information, see the important note on the <a href="https://docs.aws.amazon.com/storagegateway/latest/APIReference/Welcome.html">Welcome</a> page.</p> </important>', 'CreateSnapshotFromVolumeRecoveryPoint' => '<p>Initiates a snapshot of a gateway from a volume recovery point. This operation is only supported in the cached volume gateway type.</p> <p>A volume recovery point is a point in time at which all data of the volume is consistent and from which you can create a snapshot. To get a list of volume recovery point for cached volume gateway, use <a>ListVolumeRecoveryPoints</a>.</p> <p>In the <code>CreateSnapshotFromVolumeRecoveryPoint</code> request, you identify the volume by providing its Amazon Resource Name (ARN). You must also provide a description for the snapshot. When the gateway takes a snapshot of the specified volume, the snapshot and its description appear in the Storage Gateway console. In response, the gateway returns you a snapshot ID. You can use this snapshot ID to check the snapshot progress or later use it when you want to create a volume from a snapshot.</p> <note> <p>To list or delete a snapshot, you must use the Amazon EC2 API. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeSnapshots.html">DescribeSnapshots</a> or <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeleteSnapshot.html">DeleteSnapshot</a> in the <i>Amazon Elastic Compute Cloud API Reference</i>.</p> </note>', 'CreateStorediSCSIVolume' => '<p>Creates a volume on a specified gateway. This operation is only supported in the stored volume gateway type.</p> <p>The size of the volume to create is inferred from the disk size. You can choose to preserve existing data on the disk, create volume from an existing snapshot, or create an empty volume. If you choose to create an empty gateway volume, then any existing data on the disk is erased.</p> <p>In the request, you must specify the gateway and the disk information on which you are creating the volume. In response, the gateway creates the volume and returns volume information such as the volume Amazon Resource Name (ARN), its size, and the iSCSI target ARN that initiators can use to connect to the volume target.</p>', 'CreateTapePool' => '<p>Creates a new custom tape pool. You can use custom tape pool to enable tape retention lock on tapes that are archived in the custom pool.</p>', 'CreateTapeWithBarcode' => '<p>Creates a virtual tape by using your own barcode. You write data to the virtual tape and then archive the tape. A barcode is unique and cannot be reused if it has already been used on a tape. This applies to barcodes used on deleted tapes. This operation is only supported in the tape gateway type.</p> <note> <p>Cache storage must be allocated to the gateway before you can create a virtual tape. Use the <a>AddCache</a> operation to add cache storage to a gateway.</p> </note>', 'CreateTapes' => '<p>Creates one or more virtual tapes. You write data to the virtual tapes and then archive the tapes. This operation is only supported in the tape gateway type.</p> <note> <p>Cache storage must be allocated to the gateway before you can create virtual tapes. Use the <a>AddCache</a> operation to add cache storage to a gateway.</p> </note>', 'DeleteAutomaticTapeCreationPolicy' => '<p>Deletes the automatic tape creation policy of a gateway. If you delete this policy, new virtual tapes must be created manually. Use the Amazon Resource Name (ARN) of the gateway in your request to remove the policy.</p>', 'DeleteBandwidthRateLimit' => '<p>Deletes the bandwidth rate limits of a gateway. You can delete either the upload and download bandwidth rate limit, or you can delete both. If you delete only one of the limits, the other limit remains unchanged. To specify which gateway to work with, use the Amazon Resource Name (ARN) of the gateway in your request. This operation is supported for the stored volume, cached volume and tape gateway types.</p>', 'DeleteChapCredentials' => '<p>Deletes Challenge-Handshake Authentication Protocol (CHAP) credentials for a specified iSCSI target and initiator pair. This operation is supported in volume and tape gateway types.</p>', 'DeleteFileShare' => '<p>Deletes a file share from an S3 File Gateway. This operation is only supported for S3 File Gateways.</p>', 'DeleteGateway' => '<p>Deletes a gateway. To specify which gateway to delete, use the Amazon Resource Name (ARN) of the gateway in your request. The operation deletes the gateway; however, it does not delete the gateway virtual machine (VM) from your host computer.</p> <p>After you delete a gateway, you cannot reactivate it. Completed snapshots of the gateway volumes are not deleted upon deleting the gateway, however, pending snapshots will not complete. After you delete a gateway, your next step is to remove it from your environment.</p> <important> <p>You no longer pay software charges after the gateway is deleted; however, your existing Amazon EBS snapshots persist and you will continue to be billed for these snapshots. You can choose to remove all remaining Amazon EBS snapshots by canceling your Amazon EC2 subscription.  If you prefer not to cancel your Amazon EC2 subscription, you can delete your snapshots using the Amazon EC2 console. For more information, see the <a href="http://aws.amazon.com/storagegateway">Storage Gateway detail page</a>.</p> </important>', 'DeleteSnapshotSchedule' => '<p>Deletes a snapshot of a volume.</p> <p>You can take snapshots of your gateway volumes on a scheduled or ad hoc basis. This API action enables you to delete a snapshot schedule for a volume. For more information, see <a href="https://docs.aws.amazon.com/storagegateway/latest/userguide/backing-up-volumes.html">Backing up your volumes</a>. In the <code>DeleteSnapshotSchedule</code> request, you identify the volume by providing its Amazon Resource Name (ARN). This operation is only supported in stored and cached volume gateway types.</p> <note> <p>To list or delete a snapshot, you must use the Amazon EC2 API. For more information, go to <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeSnapshots.html">DescribeSnapshots</a> in the <i>Amazon Elastic Compute Cloud API Reference</i>.</p> </note>', 'DeleteTape' => '<p>Deletes the specified virtual tape. This operation is only supported in the tape gateway type.</p>', 'DeleteTapeArchive' => '<p>Deletes the specified virtual tape from the virtual tape shelf (VTS). This operation is only supported in the tape gateway type.</p>', 'DeleteTapePool' => '<p>Delete a custom tape pool. A custom tape pool can only be deleted if there are no tapes in the pool and if there are no automatic tape creation policies that reference the custom tape pool.</p>', 'DeleteVolume' => '<p>Deletes the specified storage volume that you previously created using the <a>CreateCachediSCSIVolume</a> or <a>CreateStorediSCSIVolume</a> API. This operation is only supported in the cached volume and stored volume types. For stored volume gateways, the local disk that was configured as the storage volume is not deleted. You can reuse the local disk to create another storage volume.</p> <p>Before you delete a volume, make sure there are no iSCSI connections to the volume you are deleting. You should also make sure there is no snapshot in progress. You can use the Amazon Elastic Compute Cloud (Amazon EC2) API to query snapshots on the volume you are deleting and check the snapshot status. For more information, go to <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/ApiReference-query-DescribeSnapshots.html">DescribeSnapshots</a> in the <i>Amazon Elastic Compute Cloud API Reference</i>.</p> <p>In the request, you must provide the Amazon Resource Name (ARN) of the storage volume you want to delete.</p>', 'DescribeAvailabilityMonitorTest' => '<p>Returns information about the most recent high availability monitoring test that was performed on the host in a cluster. If a test isn\'t performed, the status and start time in the response would be null.</p>', 'DescribeBandwidthRateLimit' => '<p>Returns the bandwidth rate limits of a gateway. By default, these limits are not set, which means no bandwidth rate limiting is in effect. This operation is supported for the stored volume, cached volume, and tape gateway types.</p> <p>This operation only returns a value for a bandwidth rate limit only if the limit is set. If no limits are set for the gateway, then this operation returns only the gateway ARN in the response body. To specify which gateway to describe, use the Amazon Resource Name (ARN) of the gateway in your request.</p>', 'DescribeBandwidthRateLimitSchedule' => '<p> Returns information about the bandwidth rate limit schedule of a gateway. By default, gateways do not have bandwidth rate limit schedules, which means no bandwidth rate limiting is in effect. This operation is supported only in the volume and tape gateway types. </p> <p>This operation returns information about a gateway\'s bandwidth rate limit schedule. A bandwidth rate limit schedule consists of one or more bandwidth rate limit intervals. A bandwidth rate limit interval defines a period of time on one or more days of the week, during which bandwidth rate limits are specified for uploading, downloading, or both. </p> <p> A bandwidth rate limit interval consists of one or more days of the week, a start hour and minute, an ending hour and minute, and bandwidth rate limits for uploading and downloading </p> <p> If no bandwidth rate limit schedule intervals are set for the gateway, this operation returns an empty response. To specify which gateway to describe, use the Amazon Resource Name (ARN) of the gateway in your request.</p>', 'DescribeCache' => '<p>Returns information about the cache of a gateway. This operation is only supported in the cached volume, tape, and file gateway types.</p> <p>The response includes disk IDs that are configured as cache, and it includes the amount of cache allocated and used.</p>', 'DescribeCachediSCSIVolumes' => '<p>Returns a description of the gateway volumes specified in the request. This operation is only supported in the cached volume gateway types.</p> <p>The list of gateway volumes in the request must be from one gateway. In the response, Storage Gateway returns volume information sorted by volume Amazon Resource Name (ARN).</p>', 'DescribeChapCredentials' => '<p>Returns an array of Challenge-Handshake Authentication Protocol (CHAP) credentials information for a specified iSCSI target, one for each target-initiator pair. This operation is supported in the volume and tape gateway types.</p>', 'DescribeFileSystemAssociations' => '<p>Gets the file system association information. This operation is only supported for FSx File Gateways.</p>', 'DescribeGatewayInformation' => '<p>Returns metadata about a gateway such as its name, network interfaces, configured time zone, and the state (whether the gateway is running or not). To specify which gateway to describe, use the Amazon Resource Name (ARN) of the gateway in your request.</p>', 'DescribeMaintenanceStartTime' => '<p>Returns your gateway\'s weekly maintenance start time including the day and time of the week. Note that values are in terms of the gateway\'s time zone.</p>', 'DescribeNFSFileShares' => '<p>Gets a description for one or more Network File System (NFS) file shares from an S3 File Gateway. This operation is only supported for S3 File Gateways.</p>', 'DescribeSMBFileShares' => '<p>Gets a description for one or more Server Message Block (SMB) file shares from a S3 File Gateway. This operation is only supported for S3 File Gateways.</p>', 'DescribeSMBSettings' => '<p>Gets a description of a Server Message Block (SMB) file share settings from a file gateway. This operation is only supported for file gateways.</p>', 'DescribeSnapshotSchedule' => '<p>Describes the snapshot schedule for the specified gateway volume. The snapshot schedule information includes intervals at which snapshots are automatically initiated on the volume. This operation is only supported in the cached volume and stored volume types.</p>', 'DescribeStorediSCSIVolumes' => '<p>Returns the description of the gateway volumes specified in the request. The list of gateway volumes in the request must be from one gateway. In the response, Storage Gateway returns volume information sorted by volume ARNs. This operation is only supported in stored volume gateway type.</p>', 'DescribeTapeArchives' => '<p>Returns a description of specified virtual tapes in the virtual tape shelf (VTS). This operation is only supported in the tape gateway type.</p> <p>If a specific <code>TapeARN</code> is not specified, Storage Gateway returns a description of all virtual tapes found in the VTS associated with your account.</p>', 'DescribeTapeRecoveryPoints' => '<p>Returns a list of virtual tape recovery points that are available for the specified tape gateway.</p> <p>A recovery point is a point-in-time view of a virtual tape at which all the data on the virtual tape is consistent. If your gateway crashes, virtual tapes that have recovery points can be recovered to a new gateway. This operation is only supported in the tape gateway type.</p>', 'DescribeTapes' => '<p>Returns a description of the specified Amazon Resource Name (ARN) of virtual tapes. If a <code>TapeARN</code> is not specified, returns a description of all virtual tapes associated with the specified gateway. This operation is only supported in the tape gateway type.</p>', 'DescribeUploadBuffer' => '<p>Returns information about the upload buffer of a gateway. This operation is supported for the stored volume, cached volume, and tape gateway types.</p> <p>The response includes disk IDs that are configured as upload buffer space, and it includes the amount of upload buffer space allocated and used.</p>', 'DescribeVTLDevices' => '<p>Returns a description of virtual tape library (VTL) devices for the specified tape gateway. In the response, Storage Gateway returns VTL device information.</p> <p>This operation is only supported in the tape gateway type.</p>', 'DescribeWorkingStorage' => '<p>Returns information about the working storage of a gateway. This operation is only supported in the stored volumes gateway type. This operation is deprecated in cached volumes API version (20120630). Use DescribeUploadBuffer instead.</p> <note> <p>Working storage is also referred to as upload buffer. You can also use the DescribeUploadBuffer operation to add upload buffer to a stored volume gateway.</p> </note> <p>The response includes disk IDs that are configured as working storage, and it includes the amount of working storage allocated and used.</p>', 'DetachVolume' => '<p>Disconnects a volume from an iSCSI connection and then detaches the volume from the specified gateway. Detaching and attaching a volume enables you to recover your data from one gateway to a different gateway without creating a snapshot. It also makes it easier to move your volumes from an on-premises gateway to a gateway hosted on an Amazon EC2 instance. This operation is only supported in the volume gateway type.</p>', 'DisableGateway' => '<p>Disables a tape gateway when the gateway is no longer functioning. For example, if your gateway VM is damaged, you can disable the gateway so you can recover virtual tapes.</p> <p>Use this operation for a tape gateway that is not reachable or not functioning. This operation is only supported in the tape gateway type.</p> <important> <p>After a gateway is disabled, it cannot be enabled.</p> </important>', 'DisassociateFileSystem' => '<p>Disassociates an Amazon FSx file system from the specified gateway. After the disassociation process finishes, the gateway can no longer access the Amazon FSx file system. This operation is only supported in the FSx File Gateway type.</p>', 'JoinDomain' => '<p>Adds a file gateway to an Active Directory domain. This operation is only supported for file gateways that support the SMB file protocol.</p>', 'ListAutomaticTapeCreationPolicies' => '<p>Lists the automatic tape creation policies for a gateway. If there are no automatic tape creation policies for the gateway, it returns an empty list.</p> <p>This operation is only supported for tape gateways.</p>', 'ListFileShares' => '<p>Gets a list of the file shares for a specific S3 File Gateway, or the list of file shares that belong to the calling user account. This operation is only supported for S3 File Gateways.</p>', 'ListFileSystemAssociations' => '<p>Gets a list of <code>FileSystemAssociationSummary</code> objects. Each object contains a summary of a file system association. This operation is only supported for FSx File Gateways.</p>', 'ListGateways' => '<p>Lists gateways owned by an account in an Region specified in the request. The returned list is ordered by gateway Amazon Resource Name (ARN).</p> <p>By default, the operation returns a maximum of 100 gateways. This operation supports pagination that allows you to optionally reduce the number of gateways returned in a response.</p> <p>If you have more gateways than are returned in a response (that is, the response returns only a truncated list of your gateways), the response contains a marker that you can specify in your next request to fetch the next page of gateways.</p>', 'ListLocalDisks' => '<p>Returns a list of the gateway\'s local disks. To specify which gateway to describe, you use the Amazon Resource Name (ARN) of the gateway in the body of the request.</p> <p>The request returns a list of all disks, specifying which are configured as working storage, cache storage, or stored volume or not configured at all. The response includes a <code>DiskStatus</code> field. This field can have a value of present (the disk is available to use), missing (the disk is no longer connected to the gateway), or mismatch (the disk node is occupied by a disk that has incorrect metadata or the disk content is corrupted).</p>', 'ListTagsForResource' => '<p>Lists the tags that have been added to the specified resource. This operation is supported in storage gateways of all types.</p>', 'ListTapePools' => '<p>Lists custom tape pools. You specify custom tape pools to list by specifying one or more custom tape pool Amazon Resource Names (ARNs). If you don\'t specify a custom tape pool ARN, the operation lists all custom tape pools.</p> <p>This operation supports pagination. You can optionally specify the <code>Limit</code> parameter in the body to limit the number of tape pools in the response. If the number of tape pools returned in the response is truncated, the response includes a <code>Marker</code> element that you can use in your subsequent request to retrieve the next set of tape pools.</p>', 'ListTapes' => '<p>Lists virtual tapes in your virtual tape library (VTL) and your virtual tape shelf (VTS). You specify the tapes to list by specifying one or more tape Amazon Resource Names (ARNs). If you don\'t specify a tape ARN, the operation lists all virtual tapes in both your VTL and VTS.</p> <p>This operation supports pagination. By default, the operation returns a maximum of up to 100 tapes. You can optionally specify the <code>Limit</code> parameter in the body to limit the number of tapes in the response. If the number of tapes returned in the response is truncated, the response includes a <code>Marker</code> element that you can use in your subsequent request to retrieve the next set of tapes. This operation is only supported in the tape gateway type.</p>', 'ListVolumeInitiators' => '<p>Lists iSCSI initiators that are connected to a volume. You can use this operation to determine whether a volume is being used or not. This operation is only supported in the cached volume and stored volume gateway types.</p>', 'ListVolumeRecoveryPoints' => '<p>Lists the recovery points for a specified gateway. This operation is only supported in the cached volume gateway type.</p> <p>Each cache volume has one recovery point. A volume recovery point is a point in time at which all data of the volume is consistent and from which you can create a snapshot or clone a new cached volume from a source volume. To create a snapshot from a volume recovery point use the <a>CreateSnapshotFromVolumeRecoveryPoint</a> operation.</p>', 'ListVolumes' => '<p>Lists the iSCSI stored volumes of a gateway. Results are sorted by volume ARN. The response includes only the volume ARNs. If you want additional volume information, use the <a>DescribeStorediSCSIVolumes</a> or the <a>DescribeCachediSCSIVolumes</a> API.</p> <p>The operation supports pagination. By default, the operation returns a maximum of up to 100 volumes. You can optionally specify the <code>Limit</code> field in the body to limit the number of volumes in the response. If the number of volumes returned in the response is truncated, the response includes a Marker field. You can use this Marker value in your subsequent request to retrieve the next set of volumes. This operation is only supported in the cached volume and stored volume gateway types.</p>', 'NotifyWhenUploaded' => '<p>Sends you notification through CloudWatch Events when all files written to your file share have been uploaded to Amazon S3.</p> <p>Storage Gateway can send a notification through Amazon CloudWatch Events when all files written to your file share up to that point in time have been uploaded to Amazon S3. These files include files written to the file share up to the time that you make a request for notification. When the upload is done, Storage Gateway sends you notification through an Amazon CloudWatch Event. You can configure CloudWatch Events to send the notification through event targets such as Amazon SNS or Lambda function. This operation is only supported for S3 File Gateways.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/storagegateway/latest/userguide/monitoring-file-gateway.html#get-upload-notification">Getting file upload notification</a> in the <i>Storage Gateway User Guide</i>.</p>', 'RefreshCache' => '<p>Refreshes the cached inventory of objects for the specified file share. This operation finds objects in the Amazon S3 bucket that were added, removed, or replaced since the gateway last listed the bucket\'s contents and cached the results. This operation does not import files into the S3 File Gateway cache storage. It only updates the cached inventory to reflect changes in the inventory of the objects in the S3 bucket. This operation is only supported in the S3 File Gateway types.</p> <p>You can subscribe to be notified through an Amazon CloudWatch event when your <code>RefreshCache</code> operation completes. For more information, see <a href="https://docs.aws.amazon.com/storagegateway/latest/userguide/monitoring-file-gateway.html#get-notification">Getting notified about file operations</a> in the <i>Storage Gateway User Guide</i>. This operation is Only supported for S3 File Gateways.</p> <p>When this API is called, it only initiates the refresh operation. When the API call completes and returns a success code, it doesn\'t necessarily mean that the file refresh has completed. You should use the refresh-complete notification to determine that the operation has completed before you check for new files on the gateway file share. You can subscribe to be notified through a CloudWatch event when your <code>RefreshCache</code> operation completes.</p> <p>Throttle limit: This API is asynchronous, so the gateway will accept no more than two refreshes at any time. We recommend using the refresh-complete CloudWatch event notification before issuing additional requests. For more information, see <a href="https://docs.aws.amazon.com/storagegateway/latest/userguide/monitoring-file-gateway.html#get-notification">Getting notified about file operations</a> in the <i>Storage Gateway User Guide</i>.</p> <p>If you invoke the RefreshCache API when two requests are already being processed, any new request will cause an <code>InvalidGatewayRequestException</code> error because too many requests were sent to the server.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/storagegateway/latest/userguide/monitoring-file-gateway.html#get-notification">Getting notified about file operations</a> in the <i>Storage Gateway User Guide</i>.</p>', 'RemoveTagsFromResource' => '<p>Removes one or more tags from the specified resource. This operation is supported in storage gateways of all types.</p>', 'ResetCache' => '<p>Resets all cache disks that have encountered an error and makes the disks available for reconfiguration as cache storage. If your cache disk encounters an error, the gateway prevents read and write operations on virtual tapes in the gateway. For example, an error can occur when a disk is corrupted or removed from the gateway. When a cache is reset, the gateway loses its cache storage. At this point, you can reconfigure the disks as cache disks. This operation is only supported in the cached volume and tape types.</p> <important> <p>If the cache disk you are resetting contains data that has not been uploaded to Amazon S3 yet, that data can be lost. After you reset cache disks, there will be no configured cache disks left in the gateway, so you must configure at least one new cache disk for your gateway to function properly.</p> </important>', 'RetrieveTapeArchive' => '<p>Retrieves an archived virtual tape from the virtual tape shelf (VTS) to a tape gateway. Virtual tapes archived in the VTS are not associated with any gateway. However after a tape is retrieved, it is associated with a gateway, even though it is also listed in the VTS, that is, archive. This operation is only supported in the tape gateway type.</p> <p>Once a tape is successfully retrieved to a gateway, it cannot be retrieved again to another gateway. You must archive the tape again before you can retrieve it to another gateway. This operation is only supported in the tape gateway type.</p>', 'RetrieveTapeRecoveryPoint' => '<p>Retrieves the recovery point for the specified virtual tape. This operation is only supported in the tape gateway type.</p> <p>A recovery point is a point in time view of a virtual tape at which all the data on the tape is consistent. If your gateway crashes, virtual tapes that have recovery points can be recovered to a new gateway.</p> <note> <p>The virtual tape can be retrieved to only one gateway. The retrieved tape is read-only. The virtual tape can be retrieved to only a tape gateway. There is no charge for retrieving recovery points.</p> </note>', 'SetLocalConsolePassword' => '<p>Sets the password for your VM local console. When you log in to the local console for the first time, you log in to the VM with the default credentials. We recommend that you set a new password. You don\'t need to know the default password to set a new password.</p>', 'SetSMBGuestPassword' => '<p>Sets the password for the guest user <code>smbguest</code>. The <code>smbguest</code> user is the user when the authentication method for the file share is set to <code>GuestAccess</code>. This operation only supported for S3 File Gateways</p>', 'ShutdownGateway' => '<p>Shuts down a gateway. To specify which gateway to shut down, use the Amazon Resource Name (ARN) of the gateway in the body of your request.</p> <p>The operation shuts down the gateway service component running in the gateway\'s virtual machine (VM) and not the host VM.</p> <note> <p>If you want to shut down the VM, it is recommended that you first shut down the gateway component in the VM to avoid unpredictable conditions.</p> </note> <p>After the gateway is shutdown, you cannot call any other API except <a>StartGateway</a>, <a>DescribeGatewayInformation</a>, and <a>ListGateways</a>. For more information, see <a>ActivateGateway</a>. Your applications cannot read from or write to the gateway\'s storage volumes, and there are no snapshots taken.</p> <note> <p>When you make a shutdown request, you will get a <code>200 OK</code> success response immediately. However, it might take some time for the gateway to shut down. You can call the <a>DescribeGatewayInformation</a> API to check the status. For more information, see <a>ActivateGateway</a>.</p> </note> <p>If do not intend to use the gateway again, you must delete the gateway (using <a>DeleteGateway</a>) to no longer pay software charges associated with the gateway.</p>', 'StartAvailabilityMonitorTest' => '<p>Start a test that verifies that the specified gateway is configured for High Availability monitoring in your host environment. This request only initiates the test and that a successful response only indicates that the test was started. It doesn\'t indicate that the test passed. For the status of the test, invoke the <code>DescribeAvailabilityMonitorTest</code> API.</p> <note> <p>Starting this test will cause your gateway to go offline for a brief period.</p> </note>', 'StartGateway' => '<p>Starts a gateway that you previously shut down (see <a>ShutdownGateway</a>). After the gateway starts, you can then make other API calls, your applications can read from or write to the gateway\'s storage volumes and you will be able to take snapshot backups.</p> <note> <p>When you make a request, you will get a 200 OK success response immediately. However, it might take some time for the gateway to be ready. You should call <a>DescribeGatewayInformation</a> and check the status before making any additional API calls. For more information, see <a>ActivateGateway</a>.</p> </note> <p>To specify which gateway to start, use the Amazon Resource Name (ARN) of the gateway in your request.</p>', 'UpdateAutomaticTapeCreationPolicy' => '<p>Updates the automatic tape creation policy of a gateway. Use this to update the policy with a new set of automatic tape creation rules. This is only supported for tape gateways.</p> <p>By default, there is no automatic tape creation policy.</p> <note> <p>A gateway can have only one automatic tape creation policy.</p> </note>', 'UpdateBandwidthRateLimit' => '<p>Updates the bandwidth rate limits of a gateway. You can update both the upload and download bandwidth rate limit or specify only one of the two. If you don\'t set a bandwidth rate limit, the existing rate limit remains. This operation is supported for the stored volume, cached volume, and tape gateway types.</p> <p>By default, a gateway\'s bandwidth rate limits are not set. If you don\'t set any limit, the gateway does not have any limitations on its bandwidth usage and could potentially use the maximum available bandwidth.</p> <p>To specify which gateway to update, use the Amazon Resource Name (ARN) of the gateway in your request.</p>', 'UpdateBandwidthRateLimitSchedule' => '<p> Updates the bandwidth rate limit schedule for a specified gateway. By default, gateways do not have bandwidth rate limit schedules, which means no bandwidth rate limiting is in effect. Use this to initiate or update a gateway\'s bandwidth rate limit schedule. This operation is supported in the volume and tape gateway types. </p>', 'UpdateChapCredentials' => '<p>Updates the Challenge-Handshake Authentication Protocol (CHAP) credentials for a specified iSCSI target. By default, a gateway does not have CHAP enabled; however, for added security, you might use it. This operation is supported in the volume and tape gateway types.</p> <important> <p>When you update CHAP credentials, all existing connections on the target are closed and initiators must reconnect with the new credentials.</p> </important>', 'UpdateFileSystemAssociation' => '<p>Updates a file system association. This operation is only supported in the FSx File Gateways.</p>', 'UpdateGatewayInformation' => '<p>Updates a gateway\'s metadata, which includes the gateway\'s name and time zone. To specify which gateway to update, use the Amazon Resource Name (ARN) of the gateway in your request.</p> <note> <p>For gateways activated after September 2, 2015, the gateway\'s ARN contains the gateway ID rather than the gateway name. However, changing the name of the gateway has no effect on the gateway\'s ARN.</p> </note>', 'UpdateGatewaySoftwareNow' => '<p>Updates the gateway virtual machine (VM) software. The request immediately triggers the software update.</p> <note> <p>When you make this request, you get a <code>200 OK</code> success response immediately. However, it might take some time for the update to complete. You can call <a>DescribeGatewayInformation</a> to verify the gateway is in the <code>STATE_RUNNING</code> state.</p> </note> <important> <p>A software update forces a system restart of your gateway. You can minimize the chance of any disruption to your applications by increasing your iSCSI Initiators\' timeouts. For more information about increasing iSCSI Initiator timeouts for Windows and Linux, see <a href="https://docs.aws.amazon.com/storagegateway/latest/userguide/ConfiguringiSCSIClientInitiatorWindowsClient.html#CustomizeWindowsiSCSISettings">Customizing your Windows iSCSI settings</a> and <a href="https://docs.aws.amazon.com/storagegateway/latest/userguide/ConfiguringiSCSIClientInitiatorRedHatClient.html#CustomizeLinuxiSCSISettings">Customizing your Linux iSCSI settings</a>, respectively.</p> </important>', 'UpdateMaintenanceStartTime' => '<p>Updates a gateway\'s weekly maintenance start time information, including day and time of the week. The maintenance time is the time in your gateway\'s time zone.</p>', 'UpdateNFSFileShare' => '<p>Updates a Network File System (NFS) file share. This operation is only supported in S3 File Gateways.</p> <note> <p>To leave a file share field unchanged, set the corresponding input field to null.</p> </note> <p>Updates the following file share settings:</p> <ul> <li> <p>Default storage class for your S3 bucket</p> </li> <li> <p>Metadata defaults for your S3 bucket</p> </li> <li> <p>Allowed NFS clients for your file share</p> </li> <li> <p>Squash settings</p> </li> <li> <p>Write status of your file share</p> </li> </ul>', 'UpdateSMBFileShare' => '<p>Updates a Server Message Block (SMB) file share. This operation is only supported for S3 File Gateways.</p> <note> <p>To leave a file share field unchanged, set the corresponding input field to null.</p> </note> <important> <p>File gateways require Security Token Service (STS) to be activated to enable you to create a file share. Make sure that STS is activated in the Region you are creating your file gateway in. If STS is not activated in this Region, activate it. For information about how to activate STS, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_enable-regions.html">Activating and deactivating STS in an Region</a> in the <i>Identity and Access Management User Guide</i>.</p> <p>File gateways don\'t support creating hard or symbolic links on a file share.</p> </important>', 'UpdateSMBFileShareVisibility' => '<p>Controls whether the shares on an S3 File Gateway are visible in a net view or browse list. The operation is only supported for S3 File Gateways.</p>', 'UpdateSMBSecurityStrategy' => '<p>Updates the SMB security strategy on a file gateway. This action is only supported in file gateways.</p> <note> <p>This API is called Security level in the User Guide.</p> <p>A higher security level can affect performance of the gateway.</p> </note>', 'UpdateSnapshotSchedule' => '<p>Updates a snapshot schedule configured for a gateway volume. This operation is only supported in the cached volume and stored volume gateway types.</p> <p>The default snapshot schedule for volume is once every 24 hours, starting at the creation time of the volume. You can use this API to change the snapshot schedule configured for the volume.</p> <p>In the request you must identify the gateway volume whose snapshot schedule you want to update, and the schedule information, including when you want the snapshot to begin on a day and the frequency (in hours) of snapshots.</p>', 'UpdateVTLDeviceType' => '<p>Updates the type of medium changer in a tape gateway. When you activate a tape gateway, you select a medium changer type for the tape gateway. This operation enables you to select a different type of medium changer after a tape gateway is activated. This operation is only supported in the tape gateway type.</p>', ], 'shapes' => [ 'ActivateGatewayInput' => [ 'base' => '<p>A JSON object containing one or more of the following fields:</p> <ul> <li> <p> <a>ActivateGatewayInput$ActivationKey</a> </p> </li> <li> <p> <a>ActivateGatewayInput$GatewayName</a> </p> </li> <li> <p> <a>ActivateGatewayInput$GatewayRegion</a> </p> </li> <li> <p> <a>ActivateGatewayInput$GatewayTimezone</a> </p> </li> <li> <p> <a>ActivateGatewayInput$GatewayType</a> </p> </li> <li> <p> <a>ActivateGatewayInput$MediumChangerType</a> </p> </li> <li> <p> <a>ActivateGatewayInput$TapeDriveType</a> </p> </li> </ul>', 'refs' => [], ], 'ActivateGatewayOutput' => [ 'base' => '<p>Storage Gateway returns the Amazon Resource Name (ARN) of the activated gateway. It is a string made of information such as your account, gateway name, and Region. This ARN is used to reference the gateway in other API operations as well as resource-based authorization.</p> <note> <p>For gateways activated prior to September 02, 2015, the gateway ARN contains the gateway name rather than the gateway ID. Changing the name of the gateway has no effect on the gateway ARN.</p> </note>', 'refs' => [], ], 'ActivationKey' => [ 'base' => NULL, 'refs' => [ 'ActivateGatewayInput$ActivationKey' => '<p>Your gateway activation key. You can obtain the activation key by sending an HTTP GET request with redirects enabled to the gateway IP address (port 80). The redirect URL returned in the response provides you the activation key for your gateway in the query string parameter <code>activationKey</code>. It may also include other activation-related parameters, however, these are merely defaults -- the arguments you pass to the <code>ActivateGateway</code> API call determine the actual configuration of your gateway.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/storagegateway/latest/userguide/get-activation-key.html">Getting activation key</a> in the <i>Storage Gateway User Guide</i>.</p>', ], ], 'ActiveDirectoryStatus' => [ 'base' => NULL, 'refs' => [ 'DescribeSMBSettingsOutput$ActiveDirectoryStatus' => '<p>Indicates the status of a gateway that is a member of the Active Directory domain.</p> <ul> <li> <p> <code>ACCESS_DENIED</code>: Indicates that the <code>JoinDomain</code> operation failed due to an authentication error.</p> </li> <li> <p> <code>DETACHED</code>: Indicates that gateway is not joined to a domain.</p> </li> <li> <p> <code>JOINED</code>: Indicates that the gateway has successfully joined a domain.</p> </li> <li> <p> <code>JOINING</code>: Indicates that a <code>JoinDomain</code> operation is in progress.</p> </li> <li> <p> <code>NETWORK_ERROR</code>: Indicates that <code>JoinDomain</code> operation failed due to a network or connectivity error.</p> </li> <li> <p> <code>TIMEOUT</code>: Indicates that the <code>JoinDomain</code> operation failed because the operation didn\'t complete within the allotted time.</p> </li> <li> <p> <code>UNKNOWN_ERROR</code>: Indicates that the <code>JoinDomain</code> operation failed due to another type of error.</p> </li> </ul>', 'JoinDomainOutput$ActiveDirectoryStatus' => '<p>Indicates the status of the gateway as a member of the Active Directory domain.</p> <ul> <li> <p> <code>ACCESS_DENIED</code>: Indicates that the <code>JoinDomain</code> operation failed due to an authentication error.</p> </li> <li> <p> <code>DETACHED</code>: Indicates that gateway is not joined to a domain.</p> </li> <li> <p> <code>JOINED</code>: Indicates that the gateway has successfully joined a domain.</p> </li> <li> <p> <code>JOINING</code>: Indicates that a <code>JoinDomain</code> operation is in progress.</p> </li> <li> <p> <code>NETWORK_ERROR</code>: Indicates that <code>JoinDomain</code> operation failed due to a network or connectivity error.</p> </li> <li> <p> <code>TIMEOUT</code>: Indicates that the <code>JoinDomain</code> operation failed because the operation didn\'t complete within the allotted time.</p> </li> <li> <p> <code>UNKNOWN_ERROR</code>: Indicates that the <code>JoinDomain</code> operation failed due to another type of error.</p> </li> </ul>', ], ], 'AddCacheInput' => [ 'base' => NULL, 'refs' => [], ], 'AddCacheOutput' => [ 'base' => NULL, 'refs' => [], ], 'AddTagsToResourceInput' => [ 'base' => '<p>AddTagsToResourceInput</p>', 'refs' => [], ], 'AddTagsToResourceOutput' => [ 'base' => '<p>AddTagsToResourceOutput</p>', 'refs' => [], ], 'AddUploadBufferInput' => [ 'base' => NULL, 'refs' => [], ], 'AddUploadBufferOutput' => [ 'base' => NULL, 'refs' => [], ], 'AddWorkingStorageInput' => [ 'base' => '<p>A JSON object containing one or more of the following fields:</p> <ul> <li> <p> <a>AddWorkingStorageInput$DiskIds</a> </p> </li> </ul>', 'refs' => [], ], 'AddWorkingStorageOutput' => [ 'base' => '<p>A JSON object containing the Amazon Resource Name (ARN) of the gateway for which working storage was configured.</p>', 'refs' => [], ], 'AssignTapePoolInput' => [ 'base' => NULL, 'refs' => [], ], 'AssignTapePoolOutput' => [ 'base' => NULL, 'refs' => [], ], 'AssociateFileSystemInput' => [ 'base' => NULL, 'refs' => [], ], 'AssociateFileSystemOutput' => [ 'base' => NULL, 'refs' => [], ], 'AttachVolumeInput' => [ 'base' => '<p>AttachVolumeInput</p>', 'refs' => [], ], 'AttachVolumeOutput' => [ 'base' => '<p>AttachVolumeOutput</p>', 'refs' => [], ], 'AuditDestinationARN' => [ 'base' => NULL, 'refs' => [ 'AssociateFileSystemInput$AuditDestinationARN' => '<p>The Amazon Resource Name (ARN) of the storage used for the audit logs.</p>', 'CreateSMBFileShareInput$AuditDestinationARN' => '<p>The Amazon Resource Name (ARN) of the storage used for audit logs.</p>', 'FileSystemAssociationInfo$AuditDestinationARN' => '<p>The Amazon Resource Name (ARN) of the storage used for the audit logs.</p>', 'SMBFileShareInfo$AuditDestinationARN' => '<p>The Amazon Resource Name (ARN) of the storage used for audit logs.</p>', 'UpdateFileSystemAssociationInput$AuditDestinationARN' => '<p>The Amazon Resource Name (ARN) of the storage used for the audit logs.</p>', 'UpdateSMBFileShareInput$AuditDestinationARN' => '<p>The Amazon Resource Name (ARN) of the storage used for audit logs.</p>', ], ], 'Authentication' => [ 'base' => '<p>The authentication method of the file share. The default is <code>ActiveDirectory</code>.</p> <p>Valid Values: <code>ActiveDirectory</code> | <code>GuestAccess</code> </p>', 'refs' => [ 'CreateSMBFileShareInput$Authentication' => '<p>The authentication method that users use to access the file share. The default is <code>ActiveDirectory</code>.</p> <p>Valid Values: <code>ActiveDirectory</code> | <code>GuestAccess</code> </p>', 'SMBFileShareInfo$Authentication' => NULL, ], ], 'AutomaticTapeCreationPolicyInfo' => [ 'base' => '<p>Information about the gateway\'s automatic tape creation policies, including the automatic tape creation rules and the gateway that is using the policies.</p>', 'refs' => [ 'AutomaticTapeCreationPolicyInfos$member' => NULL, ], ], 'AutomaticTapeCreationPolicyInfos' => [ 'base' => NULL, 'refs' => [ 'ListAutomaticTapeCreationPoliciesOutput$AutomaticTapeCreationPolicyInfos' => '<p>Gets a listing of information about the gateway\'s automatic tape creation policies, including the automatic tape creation rules and the gateway that is using the policies.</p>', ], ], 'AutomaticTapeCreationRule' => [ 'base' => '<p>An automatic tape creation policy consists of automatic tape creation rules where each rule defines when and how to create new tapes. For more information about automatic tape creation, see <a href="https://docs.aws.amazon.com/storagegateway/latest/userguide/GettingStartedCreateTapes.html#CreateTapesAutomatically">Creating Tapes Automatically</a>.</p>', 'refs' => [ 'AutomaticTapeCreationRules$member' => NULL, ], ], 'AutomaticTapeCreationRules' => [ 'base' => NULL, 'refs' => [ 'AutomaticTapeCreationPolicyInfo$AutomaticTapeCreationRules' => '<p>An automatic tape creation policy consists of a list of automatic tape creation rules. This returns the rules that determine when and how to automatically create new tapes.</p>', 'UpdateAutomaticTapeCreationPolicyInput$AutomaticTapeCreationRules' => '<p>An automatic tape creation policy consists of a list of automatic tape creation rules. The rules determine when and how to automatically create new tapes.</p>', ], ], 'AvailabilityMonitorTestStatus' => [ 'base' => NULL, 'refs' => [ 'DescribeAvailabilityMonitorTestOutput$Status' => '<p>The status of the high availability monitoring test. If a test hasn\'t been performed, the value of this field is null.</p>', ], ], 'BandwidthDownloadRateLimit' => [ 'base' => NULL, 'refs' => [ 'BandwidthRateLimitInterval$AverageDownloadRateLimitInBitsPerSec' => '<p> The average download rate limit component of the bandwidth rate limit interval, in bits per second. This field does not appear in the response if the download rate limit is not set. </p>', 'DescribeBandwidthRateLimitOutput$AverageDownloadRateLimitInBitsPerSec' => '<p>The average download bandwidth rate limit in bits per second. This field does not appear in the response if the download rate limit is not set.</p>', 'UpdateBandwidthRateLimitInput$AverageDownloadRateLimitInBitsPerSec' => '<p>The average download bandwidth rate limit in bits per second.</p>', ], ], 'BandwidthRateLimitInterval' => [ 'base' => '<p> Describes a bandwidth rate limit interval for a gateway. A bandwidth rate limit schedule consists of one or more bandwidth rate limit intervals. A bandwidth rate limit interval defines a period of time on one or more days of the week, during which bandwidth rate limits are specified for uploading, downloading, or both. </p>', 'refs' => [ 'BandwidthRateLimitIntervals$member' => NULL, ], ], 'BandwidthRateLimitIntervals' => [ 'base' => NULL, 'refs' => [ 'DescribeBandwidthRateLimitScheduleOutput$BandwidthRateLimitIntervals' => '<p> An array that contains the bandwidth rate limit intervals for a tape or volume gateway. </p>', 'UpdateBandwidthRateLimitScheduleInput$BandwidthRateLimitIntervals' => '<p> An array containing bandwidth rate limit schedule intervals for a gateway. When no bandwidth rate limit intervals have been scheduled, the array is empty. </p>', ], ], 'BandwidthType' => [ 'base' => NULL, 'refs' => [ 'DeleteBandwidthRateLimitInput$BandwidthType' => '<p>One of the BandwidthType values that indicates the gateway bandwidth rate limit to delete.</p> <p>Valid Values: <code>UPLOAD</code> | <code>DOWNLOAD</code> | <code>ALL</code> </p>', ], ], 'BandwidthUploadRateLimit' => [ 'base' => NULL, 'refs' => [ 'BandwidthRateLimitInterval$AverageUploadRateLimitInBitsPerSec' => '<p> The average upload rate limit component of the bandwidth rate limit interval, in bits per second. This field does not appear in the response if the upload rate limit is not set. </p>', 'DescribeBandwidthRateLimitOutput$AverageUploadRateLimitInBitsPerSec' => '<p>The average upload bandwidth rate limit in bits per second. This field does not appear in the response if the upload rate limit is not set.</p>', 'UpdateBandwidthRateLimitInput$AverageUploadRateLimitInBitsPerSec' => '<p>The average upload bandwidth rate limit in bits per second.</p>', ], ], 'Boolean' => [ 'base' => NULL, 'refs' => [ 'CreateCachediSCSIVolumeInput$KMSEncrypted' => '<p>Set to <code>true</code> to use Amazon S3 server-side encryption with your own KMS key, or <code>false</code> to use a key managed by Amazon S3. Optional.</p> <p>Valid Values: <code>true</code> | <code>false</code> </p>', 'CreateNFSFileShareInput$KMSEncrypted' => '<p>Set to <code>true</code> to use Amazon S3 server-side encryption with your own KMS key, or <code>false</code> to use a key managed by Amazon S3. Optional.</p> <p>Valid Values: <code>true</code> | <code>false</code> </p>', 'CreateNFSFileShareInput$ReadOnly' => '<p>A value that sets the write status of a file share. Set this value to <code>true</code> to set the write status to read-only, otherwise set to <code>false</code>.</p> <p>Valid Values: <code>true</code> | <code>false</code> </p>', 'CreateNFSFileShareInput$GuessMIMETypeEnabled' => '<p>A value that enables guessing of the MIME type for uploaded objects based on file extensions. Set this value to <code>true</code> to enable MIME type guessing, otherwise set to <code>false</code>. The default value is <code>true</code>.</p> <p>Valid Values: <code>true</code> | <code>false</code> </p>', 'CreateNFSFileShareInput$RequesterPays' => '<p>A value that sets who pays the cost of the request and the cost associated with data download from the S3 bucket. If this value is set to <code>true</code>, the requester pays the costs; otherwise, the S3 bucket owner pays. However, the S3 bucket owner always pays the cost of storing data.</p> <note> <p> <code>RequesterPays</code> is a configuration for the S3 bucket that backs the file share, so make sure that the configuration on the file share is the same as the S3 bucket configuration.</p> </note> <p>Valid Values: <code>true</code> | <code>false</code> </p>', 'CreateSMBFileShareInput$KMSEncrypted' => '<p>Set to <code>true</code> to use Amazon S3 server-side encryption with your own KMS key, or <code>false</code> to use a key managed by Amazon S3. Optional.</p> <p>Valid Values: <code>true</code> | <code>false</code> </p>', 'CreateSMBFileShareInput$ReadOnly' => '<p>A value that sets the write status of a file share. Set this value to <code>true</code> to set the write status to read-only, otherwise set to <code>false</code>.</p> <p>Valid Values: <code>true</code> | <code>false</code> </p>', 'CreateSMBFileShareInput$GuessMIMETypeEnabled' => '<p>A value that enables guessing of the MIME type for uploaded objects based on file extensions. Set this value to <code>true</code> to enable MIME type guessing, otherwise set to <code>false</code>. The default value is <code>true</code>.</p> <p>Valid Values: <code>true</code> | <code>false</code> </p>', 'CreateSMBFileShareInput$RequesterPays' => '<p>A value that sets who pays the cost of the request and the cost associated with data download from the S3 bucket. If this value is set to <code>true</code>, the requester pays the costs; otherwise, the S3 bucket owner pays. However, the S3 bucket owner always pays the cost of storing data.</p> <note> <p> <code>RequesterPays</code> is a configuration for the S3 bucket that backs the file share, so make sure that the configuration on the file share is the same as the S3 bucket configuration.</p> </note> <p>Valid Values: <code>true</code> | <code>false</code> </p>', 'CreateSMBFileShareInput$SMBACLEnabled' => '<p>Set this value to <code>true</code> to enable access control list (ACL) on the SMB file share. Set it to <code>false</code> to map file and directory permissions to the POSIX permissions.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/storagegateway/latest/userguide/smb-acl.html">Using Microsoft Windows ACLs to control access to an SMB file share</a> in the <i>Storage Gateway User Guide</i>.</p> <p>Valid Values: <code>true</code> | <code>false</code> </p>', 'CreateSMBFileShareInput$AccessBasedEnumeration' => '<p>The files and folders on this share will only be visible to users with read access.</p>', 'CreateSMBFileShareInput$OplocksEnabled' => '<p>Specifies whether opportunistic locking is enabled for the SMB file share.</p> <note> <p>Enabling opportunistic locking on case-sensitive shares is not recommended for workloads that involve access to files with the same name in different case.</p> </note> <p>Valid Values: <code>true</code> | <code>false</code> </p>', 'CreateStorediSCSIVolumeInput$KMSEncrypted' => '<p>Set to <code>true</code> to use Amazon S3 server-side encryption with your own KMS key, or <code>false</code> to use a key managed by Amazon S3. Optional.</p> <p>Valid Values: <code>true</code> | <code>false</code> </p>', 'CreateTapeWithBarcodeInput$KMSEncrypted' => '<p>Set to <code>true</code> to use Amazon S3 server-side encryption with your own KMS key, or <code>false</code> to use a key managed by Amazon S3. Optional.</p> <p>Valid Values: <code>true</code> | <code>false</code> </p>', 'CreateTapesInput$KMSEncrypted' => '<p>Set to <code>true</code> to use Amazon S3 server-side encryption with your own KMS key, or <code>false</code> to use a key managed by Amazon S3. Optional.</p> <p>Valid Values: <code>true</code> | <code>false</code> </p>', 'DescribeSMBSettingsOutput$SMBGuestPasswordSet' => '<p>This value is <code>true</code> if a password for the guest user <code>smbguest</code> is set, otherwise <code>false</code>. Only supported for S3 File Gateways.</p> <p>Valid Values: <code>true</code> | <code>false</code> </p>', 'DescribeSMBSettingsOutput$FileSharesVisible' => '<p>The shares on this gateway appear when listing shares. Only supported for S3 File Gateways. </p>', 'DetachVolumeInput$ForceDetach' => '<p>Set to <code>true</code> to forcibly remove the iSCSI connection of the target volume and detach the volume. The default is <code>false</code>. If this value is set to <code>false</code>, you must manually disconnect the iSCSI connection from the target volume.</p> <p>Valid Values: <code>true</code> | <code>false</code> </p>', 'NFSFileShareInfo$ReadOnly' => '<p>A value that sets the write status of a file share. Set this value to <code>true</code> to set the write status to read-only, otherwise set to <code>false</code>.</p> <p>Valid Values: <code>true</code> | <code>false</code> </p>', 'NFSFileShareInfo$GuessMIMETypeEnabled' => '<p>A value that enables guessing of the MIME type for uploaded objects based on file extensions. Set this value to <code>true</code> to enable MIME type guessing, otherwise set to <code>false</code>. The default value is <code>true</code>.</p> <p>Valid Values: <code>true</code> | <code>false</code> </p>', 'NFSFileShareInfo$RequesterPays' => '<p>A value that sets who pays the cost of the request and the cost associated with data download from the S3 bucket. If this value is set to <code>true</code>, the requester pays the costs; otherwise, the S3 bucket owner pays. However, the S3 bucket owner always pays the cost of storing data.</p> <note> <p> <code>RequesterPays</code> is a configuration for the S3 bucket that backs the file share, so make sure that the configuration on the file share is the same as the S3 bucket configuration.</p> </note> <p>Valid Values: <code>true</code> | <code>false</code> </p>', 'RefreshCacheInput$Recursive' => '<p>A value that specifies whether to recursively refresh folders in the cache. The refresh includes folders that were in the cache the last time the gateway listed the folder\'s contents. If this value set to <code>true</code>, each folder that is listed in <code>FolderList</code> is recursively updated. Otherwise, subfolders listed in <code>FolderList</code> are not refreshed. Only objects that are in folders listed directly under <code>FolderList</code> are found and used for the update. The default is <code>true</code>.</p> <p>Valid Values: <code>true</code> | <code>false</code> </p>', 'SMBFileShareInfo$ReadOnly' => '<p>A value that sets the write status of a file share. Set this value to <code>true</code> to set the write status to read-only, otherwise set to <code>false</code>.</p> <p>Valid Values: <code>true</code> | <code>false</code> </p>', 'SMBFileShareInfo$GuessMIMETypeEnabled' => '<p>A value that enables guessing of the MIME type for uploaded objects based on file extensions. Set this value to <code>true</code> to enable MIME type guessing, otherwise set to <code>false</code>. The default value is <code>true</code>.</p> <p>Valid Values: <code>true</code> | <code>false</code> </p>', 'SMBFileShareInfo$RequesterPays' => '<p>A value that sets who pays the cost of the request and the cost associated with data download from the S3 bucket. If this value is set to <code>true</code>, the requester pays the costs; otherwise, the S3 bucket owner pays. However, the S3 bucket owner always pays the cost of storing data.</p> <note> <p> <code>RequesterPays</code> is a configuration for the S3 bucket that backs the file share, so make sure that the configuration on the file share is the same as the S3 bucket configuration.</p> </note> <p>Valid Values: <code>true</code> | <code>false</code> </p>', 'SMBFileShareInfo$SMBACLEnabled' => '<p>If this value is set to <code>true</code>, it indicates that access control list (ACL) is enabled on the SMB file share. If it is set to <code>false</code>, it indicates that file and directory permissions are mapped to the POSIX permission.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/storagegateway/latest/userguide/smb-acl.html">Using Microsoft Windows ACLs to control access to an SMB file share</a> in the <i>Storage Gateway User Guide</i>.</p>', 'SMBFileShareInfo$AccessBasedEnumeration' => '<p>Indicates whether <code>AccessBasedEnumeration</code> is enabled.</p>', 'SMBFileShareInfo$OplocksEnabled' => '<p>Specifies whether opportunistic locking is enabled for the SMB file share.</p> <note> <p>Enabling opportunistic locking on case-sensitive shares is not recommended for workloads that involve access to files with the same name in different case.</p> </note> <p>Valid Values: <code>true</code> | <code>false</code> </p>', 'UpdateNFSFileShareInput$KMSEncrypted' => '<p>Set to <code>true</code> to use Amazon S3 server-side encryption with your own KMS key, or <code>false</code> to use a key managed by Amazon S3. Optional.</p> <p>Valid Values: <code>true</code> | <code>false</code> </p>', 'UpdateNFSFileShareInput$ReadOnly' => '<p>A value that sets the write status of a file share. Set this value to <code>true</code> to set the write status to read-only, otherwise set to <code>false</code>.</p> <p>Valid Values: <code>true</code> | <code>false</code> </p>', 'UpdateNFSFileShareInput$GuessMIMETypeEnabled' => '<p>A value that enables guessing of the MIME type for uploaded objects based on file extensions. Set this value to <code>true</code> to enable MIME type guessing, otherwise set to <code>false</code>. The default value is <code>true</code>.</p> <p>Valid Values: <code>true</code> | <code>false</code> </p>', 'UpdateNFSFileShareInput$RequesterPays' => '<p>A value that sets who pays the cost of the request and the cost associated with data download from the S3 bucket. If this value is set to <code>true</code>, the requester pays the costs; otherwise, the S3 bucket owner pays. However, the S3 bucket owner always pays the cost of storing data.</p> <note> <p> <code>RequesterPays</code> is a configuration for the S3 bucket that backs the file share, so make sure that the configuration on the file share is the same as the S3 bucket configuration.</p> </note> <p>Valid Values: <code>true</code> | <code>false</code> </p>', 'UpdateSMBFileShareInput$KMSEncrypted' => '<p>Set to <code>true</code> to use Amazon S3 server-side encryption with your own KMS key, or <code>false</code> to use a key managed by Amazon S3. Optional.</p> <p>Valid Values: <code>true</code> | <code>false</code> </p>', 'UpdateSMBFileShareInput$ReadOnly' => '<p>A value that sets the write status of a file share. Set this value to <code>true</code> to set write status to read-only, otherwise set to <code>false</code>.</p> <p>Valid Values: <code>true</code> | <code>false</code> </p>', 'UpdateSMBFileShareInput$GuessMIMETypeEnabled' => '<p>A value that enables guessing of the MIME type for uploaded objects based on file extensions. Set this value to <code>true</code> to enable MIME type guessing, otherwise set to <code>false</code>. The default value is <code>true</code>.</p> <p>Valid Values: <code>true</code> | <code>false</code> </p>', 'UpdateSMBFileShareInput$RequesterPays' => '<p>A value that sets who pays the cost of the request and the cost associated with data download from the S3 bucket. If this value is set to <code>true</code>, the requester pays the costs; otherwise, the S3 bucket owner pays. However, the S3 bucket owner always pays the cost of storing data.</p> <note> <p> <code>RequesterPays</code> is a configuration for the S3 bucket that backs the file share, so make sure that the configuration on the file share is the same as the S3 bucket configuration.</p> </note> <p>Valid Values: <code>true</code> | <code>false</code> </p>', 'UpdateSMBFileShareInput$SMBACLEnabled' => '<p>Set this value to <code>true</code> to enable access control list (ACL) on the SMB file share. Set it to <code>false</code> to map file and directory permissions to the POSIX permissions.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/storagegateway/latest/userguide/smb-acl.html">Using Microsoft Windows ACLs to control access to an SMB file share</a> in the <i>Storage Gateway User Guide</i>.</p> <p>Valid Values: <code>true</code> | <code>false</code> </p>', 'UpdateSMBFileShareInput$AccessBasedEnumeration' => '<p>The files and folders on this share will only be visible to users with read access.</p>', 'UpdateSMBFileShareInput$OplocksEnabled' => '<p>Specifies whether opportunistic locking is enabled for the SMB file share.</p> <note> <p>Enabling opportunistic locking on case-sensitive shares is not recommended for workloads that involve access to files with the same name in different case.</p> </note> <p>Valid Values: <code>true</code> | <code>false</code> </p>', 'UpdateSMBFileShareVisibilityInput$FileSharesVisible' => '<p>The shares on this gateway appear when listing shares.</p>', ], ], 'CacheAttributes' => [ 'base' => '<p>The refresh cache information for the file share or FSx file systems.</p>', 'refs' => [ 'AssociateFileSystemInput$CacheAttributes' => NULL, 'CreateNFSFileShareInput$CacheAttributes' => '<p>Specifies refresh cache information for the file share.</p>', 'CreateSMBFileShareInput$CacheAttributes' => '<p>Specifies refresh cache information for the file share.</p>', 'FileSystemAssociationInfo$CacheAttributes' => NULL, 'NFSFileShareInfo$CacheAttributes' => '<p>Refresh cache information for the file share.</p>', 'SMBFileShareInfo$CacheAttributes' => '<p>Refresh cache information for the file share.</p>', 'UpdateFileSystemAssociationInput$CacheAttributes' => NULL, 'UpdateNFSFileShareInput$CacheAttributes' => '<p>specifies refresh cache information for the file share.</p>', 'UpdateSMBFileShareInput$CacheAttributes' => '<p>Specifies refresh cache information for the file share.</p>', ], ], 'CacheStaleTimeoutInSeconds' => [ 'base' => NULL, 'refs' => [ 'CacheAttributes$CacheStaleTimeoutInSeconds' => '<p>Refreshes a file share\'s cache by using Time To Live (TTL). TTL is the length of time since the last refresh after which access to the directory would cause the file gateway to first refresh that directory\'s contents from the Amazon S3 bucket or Amazon FSx file system. The TTL duration is in seconds.</p> <p>Valid Values:0, 300 to 2,592,000 seconds (5 minutes to 30 days)</p>', ], ], 'CachediSCSIVolume' => [ 'base' => '<p>Describes an iSCSI cached volume.</p>', 'refs' => [ 'CachediSCSIVolumes$member' => NULL, ], ], 'CachediSCSIVolumes' => [ 'base' => NULL, 'refs' => [ 'DescribeCachediSCSIVolumesOutput$CachediSCSIVolumes' => '<p>An array of objects where each object contains metadata about one cached volume.</p>', ], ], 'CancelArchivalInput' => [ 'base' => '<p>CancelArchivalInput</p>', 'refs' => [], ], 'CancelArchivalOutput' => [ 'base' => '<p>CancelArchivalOutput</p>', 'refs' => [], ], 'CancelRetrievalInput' => [ 'base' => '<p>CancelRetrievalInput</p>', 'refs' => [], ], 'CancelRetrievalOutput' => [ 'base' => '<p>CancelRetrievalOutput</p>', 'refs' => [], ], 'CaseSensitivity' => [ 'base' => NULL, 'refs' => [ 'CreateSMBFileShareInput$CaseSensitivity' => '<p>The case of an object name in an Amazon S3 bucket. For <code>ClientSpecified</code>, the client determines the case sensitivity. For <code>CaseSensitive</code>, the gateway determines the case sensitivity. The default value is <code>ClientSpecified</code>.</p>', 'SMBFileShareInfo$CaseSensitivity' => '<p>The case of an object name in an Amazon S3 bucket. For <code>ClientSpecified</code>, the client determines the case sensitivity. For <code>CaseSensitive</code>, the gateway determines the case sensitivity. The default value is <code>ClientSpecified</code>.</p>', 'UpdateSMBFileShareInput$CaseSensitivity' => '<p>The case of an object name in an Amazon S3 bucket. For <code>ClientSpecified</code>, the client determines the case sensitivity. For <code>CaseSensitive</code>, the gateway determines the case sensitivity. The default value is <code>ClientSpecified</code>.</p>', ], ], 'ChapCredentials' => [ 'base' => NULL, 'refs' => [ 'DescribeChapCredentialsOutput$ChapCredentials' => '<p>An array of <a>ChapInfo</a> objects that represent CHAP credentials. Each object in the array contains CHAP credential information for one target-initiator pair. If no CHAP credentials are set, an empty array is returned. CHAP credential information is provided in a JSON object with the following fields:</p> <ul> <li> <p> <b>InitiatorName</b>: The iSCSI initiator that connects to the target.</p> </li> <li> <p> <b>SecretToAuthenticateInitiator</b>: The secret key that the initiator (for example, the Windows client) must provide to participate in mutual CHAP with the target.</p> </li> <li> <p> <b>SecretToAuthenticateTarget</b>: The secret key that the target must provide to participate in mutual CHAP with the initiator (e.g. Windows client).</p> </li> <li> <p> <b>TargetARN</b>: The Amazon Resource Name (ARN) of the storage volume.</p> </li> </ul>', ], ], 'ChapInfo' => [ 'base' => '<p>Describes Challenge-Handshake Authentication Protocol (CHAP) information that supports authentication between your gateway and iSCSI initiators.</p>', 'refs' => [ 'ChapCredentials$member' => NULL, ], ], 'ChapSecret' => [ 'base' => NULL, 'refs' => [ 'ChapInfo$SecretToAuthenticateInitiator' => '<p>The secret key that the initiator (for example, the Windows client) must provide to participate in mutual CHAP with the target.</p>', 'ChapInfo$SecretToAuthenticateTarget' => '<p>The secret key that the target must provide to participate in mutual CHAP with the initiator (e.g., Windows client).</p>', 'UpdateChapCredentialsInput$SecretToAuthenticateInitiator' => '<p>The secret key that the initiator (for example, the Windows client) must provide to participate in mutual CHAP with the target.</p> <note> <p>The secret key must be between 12 and 16 bytes when encoded in UTF-8.</p> </note>', 'UpdateChapCredentialsInput$SecretToAuthenticateTarget' => '<p>The secret key that the target must provide to participate in mutual CHAP with the initiator (e.g. Windows client).</p> <p>Byte constraints: Minimum bytes of 12. Maximum bytes of 16.</p> <note> <p>The secret key must be between 12 and 16 bytes when encoded in UTF-8.</p> </note>', ], ], 'ClientToken' => [ 'base' => NULL, 'refs' => [ 'AssociateFileSystemInput$ClientToken' => '<p>A unique string value that you supply that is used by the FSx File Gateway to ensure idempotent file system association creation.</p>', 'CreateCachediSCSIVolumeInput$ClientToken' => '<p>A unique identifier that you use to retry a request. If you retry a request, use the same <code>ClientToken</code> you specified in the initial request.</p>', 'CreateNFSFileShareInput$ClientToken' => '<p>A unique string value that you supply that is used by S3 File Gateway to ensure idempotent file share creation.</p>', 'CreateSMBFileShareInput$ClientToken' => '<p>A unique string value that you supply that is used by S3 File Gateway to ensure idempotent file share creation.</p>', 'CreateTapesInput$ClientToken' => '<p>A unique identifier that you use to retry a request. If you retry a request, use the same <code>ClientToken</code> you specified in the initial request.</p> <note> <p>Using the same <code>ClientToken</code> prevents creating the tape multiple times.</p> </note>', ], ], 'CloudWatchLogGroupARN' => [ 'base' => NULL, 'refs' => [ 'DescribeGatewayInformationOutput$CloudWatchLogGroupARN' => '<p>The Amazon Resource Name (ARN) of the Amazon CloudWatch log group that is used to monitor events in the gateway.</p>', 'UpdateGatewayInformationInput$CloudWatchLogGroupARN' => '<p>The Amazon Resource Name (ARN) of the Amazon CloudWatch log group that you want to use to monitor and log events in the gateway.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/WhatIsCloudWatchLogs.html">What is Amazon CloudWatch Logs?</a> </p>', ], ], 'CreateCachediSCSIVolumeInput' => [ 'base' => NULL, 'refs' => [], ], 'CreateCachediSCSIVolumeOutput' => [ 'base' => NULL, 'refs' => [], ], 'CreateNFSFileShareInput' => [ 'base' => '<p>CreateNFSFileShareInput</p>', 'refs' => [], ], 'CreateNFSFileShareOutput' => [ 'base' => '<p>CreateNFSFileShareOutput</p>', 'refs' => [], ], 'CreateSMBFileShareInput' => [ 'base' => '<p>CreateSMBFileShareInput</p>', 'refs' => [], ], 'CreateSMBFileShareOutput' => [ 'base' => '<p>CreateSMBFileShareOutput</p>', 'refs' => [], ], 'CreateSnapshotFromVolumeRecoveryPointInput' => [ 'base' => NULL, 'refs' => [], ], 'CreateSnapshotFromVolumeRecoveryPointOutput' => [ 'base' => NULL, 'refs' => [], ], 'CreateSnapshotInput' => [ 'base' => '<p>A JSON object containing one or more of the following fields:</p> <ul> <li> <p> <a>CreateSnapshotInput$SnapshotDescription</a> </p> </li> <li> <p> <a>CreateSnapshotInput$VolumeARN</a> </p> </li> </ul>', 'refs' => [], ], 'CreateSnapshotOutput' => [ 'base' => '<p>A JSON object containing the following fields:</p>', 'refs' => [], ], 'CreateStorediSCSIVolumeInput' => [ 'base' => '<p>A JSON object containing one or more of the following fields:</p> <ul> <li> <p> <a>CreateStorediSCSIVolumeInput$DiskId</a> </p> </li> <li> <p> <a>CreateStorediSCSIVolumeInput$NetworkInterfaceId</a> </p> </li> <li> <p> <a>CreateStorediSCSIVolumeInput$PreserveExistingData</a> </p> </li> <li> <p> <a>CreateStorediSCSIVolumeInput$SnapshotId</a> </p> </li> <li> <p> <a>CreateStorediSCSIVolumeInput$TargetName</a> </p> </li> </ul>', 'refs' => [], ], 'CreateStorediSCSIVolumeOutput' => [ 'base' => '<p>A JSON object containing the following fields:</p>', 'refs' => [], ], 'CreateTapePoolInput' => [ 'base' => NULL, 'refs' => [], ], 'CreateTapePoolOutput' => [ 'base' => NULL, 'refs' => [], ], 'CreateTapeWithBarcodeInput' => [ 'base' => '<p>CreateTapeWithBarcodeInput</p>', 'refs' => [], ], 'CreateTapeWithBarcodeOutput' => [ 'base' => '<p>CreateTapeOutput</p>', 'refs' => [], ], 'CreateTapesInput' => [ 'base' => '<p>CreateTapesInput</p>', 'refs' => [], ], 'CreateTapesOutput' => [ 'base' => '<p>CreateTapeOutput</p>', 'refs' => [], ], 'CreatedDate' => [ 'base' => NULL, 'refs' => [ 'CachediSCSIVolume$CreatedDate' => '<p>The date the volume was created. Volumes created prior to March 28, 2017 don’t have this timestamp.</p>', 'StorediSCSIVolume$CreatedDate' => '<p>The date the volume was created. Volumes created prior to March 28, 2017 don’t have this timestamp.</p>', ], ], 'DNSHostName' => [ 'base' => NULL, 'refs' => [ 'CreateNFSFileShareInput$VPCEndpointDNSName' => '<p>Specifies the DNS name for the VPC endpoint that the NFS file share uses to connect to Amazon S3.</p> <note> <p>This parameter is required for NFS file shares that connect to Amazon S3 through a VPC endpoint, a VPC access point, or an access point alias that points to a VPC access point.</p> </note>', 'CreateSMBFileShareInput$VPCEndpointDNSName' => '<p>Specifies the DNS name for the VPC endpoint that the SMB file share uses to connect to Amazon S3.</p> <note> <p>This parameter is required for SMB file shares that connect to Amazon S3 through a VPC endpoint, a VPC access point, or an access point alias that points to a VPC access point.</p> </note>', 'NFSFileShareInfo$VPCEndpointDNSName' => '<p>Specifies the DNS name for the VPC endpoint that the NFS file share uses to connect to Amazon S3.</p> <note> <p>This parameter is required for NFS file shares that connect to Amazon S3 through a VPC endpoint, a VPC access point, or an access point alias that points to a VPC access point.</p> </note>', 'SMBFileShareInfo$VPCEndpointDNSName' => '<p>Specifies the DNS name for the VPC endpoint that the SMB file share uses to connect to Amazon S3.</p> <note> <p>This parameter is required for SMB file shares that connect to Amazon S3 through a VPC endpoint, a VPC access point, or an access point alias that points to a VPC access point.</p> </note>', ], ], 'DayOfMonth' => [ 'base' => NULL, 'refs' => [ 'DescribeMaintenanceStartTimeOutput$DayOfMonth' => '<p>The day of the month component of the maintenance start time represented as an ordinal number from 1 to 28, where 1 represents the first day of the month and 28 represents the last day of the month.</p>', 'UpdateMaintenanceStartTimeInput$DayOfMonth' => '<p>The day of the month component of the maintenance start time represented as an ordinal number from 1 to 28, where 1 represents the first day of the month and 28 represents the last day of the month.</p>', ], ], 'DayOfWeek' => [ 'base' => NULL, 'refs' => [ 'DaysOfWeek$member' => NULL, 'DescribeMaintenanceStartTimeOutput$DayOfWeek' => '<p>An ordinal number between 0 and 6 that represents the day of the week, where 0 represents Sunday and 6 represents Saturday. The day of week is in the time zone of the gateway.</p>', 'UpdateMaintenanceStartTimeInput$DayOfWeek' => '<p>The day of the week component of the maintenance start time week represented as an ordinal number from 0 to 6, where 0 represents Sunday and 6 Saturday.</p>', ], ], 'DaysOfWeek' => [ 'base' => NULL, 'refs' => [ 'BandwidthRateLimitInterval$DaysOfWeek' => '<p> The days of the week component of the bandwidth rate limit interval, represented as ordinal numbers from 0 to 6, where 0 represents Sunday and 6 represents Saturday. </p>', ], ], 'DeleteAutomaticTapeCreationPolicyInput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteAutomaticTapeCreationPolicyOutput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteBandwidthRateLimitInput' => [ 'base' => '<p>A JSON object containing the following fields:</p> <ul> <li> <p> <a>DeleteBandwidthRateLimitInput$BandwidthType</a> </p> </li> </ul>', 'refs' => [], ], 'DeleteBandwidthRateLimitOutput' => [ 'base' => '<p>A JSON object containing the Amazon Resource Name (ARN) of the gateway whose bandwidth rate information was deleted.</p>', 'refs' => [], ], 'DeleteChapCredentialsInput' => [ 'base' => '<p>A JSON object containing one or more of the following fields:</p> <ul> <li> <p> <a>DeleteChapCredentialsInput$InitiatorName</a> </p> </li> <li> <p> <a>DeleteChapCredentialsInput$TargetARN</a> </p> </li> </ul>', 'refs' => [], ], 'DeleteChapCredentialsOutput' => [ 'base' => '<p>A JSON object containing the following fields:</p>', 'refs' => [], ], 'DeleteFileShareInput' => [ 'base' => '<p>DeleteFileShareInput</p>', 'refs' => [], ], 'DeleteFileShareOutput' => [ 'base' => '<p>DeleteFileShareOutput</p>', 'refs' => [], ], 'DeleteGatewayInput' => [ 'base' => '<p>A JSON object containing the ID of the gateway to delete.</p>', 'refs' => [], ], 'DeleteGatewayOutput' => [ 'base' => '<p>A JSON object containing the ID of the deleted gateway.</p>', 'refs' => [], ], 'DeleteSnapshotScheduleInput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteSnapshotScheduleOutput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteTapeArchiveInput' => [ 'base' => '<p>DeleteTapeArchiveInput</p>', 'refs' => [], ], 'DeleteTapeArchiveOutput' => [ 'base' => '<p>DeleteTapeArchiveOutput</p>', 'refs' => [], ], 'DeleteTapeInput' => [ 'base' => '<p>DeleteTapeInput</p>', 'refs' => [], ], 'DeleteTapeOutput' => [ 'base' => '<p>DeleteTapeOutput</p>', 'refs' => [], ], 'DeleteTapePoolInput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteTapePoolOutput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteVolumeInput' => [ 'base' => '<p>A JSON object containing the <a>DeleteVolumeInput$VolumeARN</a> to delete.</p>', 'refs' => [], ], 'DeleteVolumeOutput' => [ 'base' => '<p>A JSON object containing the Amazon Resource Name (ARN) of the storage volume that was deleted.</p>', 'refs' => [], ], 'DeprecationDate' => [ 'base' => NULL, 'refs' => [ 'DescribeGatewayInformationOutput$DeprecationDate' => '<p>Date after which this gateway will not receive software updates for new features and bug fixes.</p>', ], ], 'DescribeAvailabilityMonitorTestInput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAvailabilityMonitorTestOutput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeBandwidthRateLimitInput' => [ 'base' => '<p>A JSON object containing the Amazon Resource Name (ARN) of the gateway.</p>', 'refs' => [], ], 'DescribeBandwidthRateLimitOutput' => [ 'base' => '<p>A JSON object containing the following fields:</p>', 'refs' => [], ], 'DescribeBandwidthRateLimitScheduleInput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeBandwidthRateLimitScheduleOutput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeCacheInput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeCacheOutput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeCachediSCSIVolumesInput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeCachediSCSIVolumesOutput' => [ 'base' => '<p>A JSON object containing the following fields:</p>', 'refs' => [], ], 'DescribeChapCredentialsInput' => [ 'base' => '<p>A JSON object containing the Amazon Resource Name (ARN) of the iSCSI volume target.</p>', 'refs' => [], ], 'DescribeChapCredentialsOutput' => [ 'base' => '<p>A JSON object containing the following fields:</p>', 'refs' => [], ], 'DescribeFileSystemAssociationsInput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeFileSystemAssociationsOutput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeGatewayInformationInput' => [ 'base' => '<p>A JSON object containing the ID of the gateway.</p>', 'refs' => [], ], 'DescribeGatewayInformationOutput' => [ 'base' => '<p>A JSON object containing the following fields:</p>', 'refs' => [], ], 'DescribeMaintenanceStartTimeInput' => [ 'base' => '<p>A JSON object containing the Amazon Resource Name (ARN) of the gateway.</p>', 'refs' => [], ], 'DescribeMaintenanceStartTimeOutput' => [ 'base' => '<p>A JSON object containing the following fields:</p> <ul> <li> <p> <a>DescribeMaintenanceStartTimeOutput$DayOfMonth</a> </p> </li> <li> <p> <a>DescribeMaintenanceStartTimeOutput$DayOfWeek</a> </p> </li> <li> <p> <a>DescribeMaintenanceStartTimeOutput$HourOfDay</a> </p> </li> <li> <p> <a>DescribeMaintenanceStartTimeOutput$MinuteOfHour</a> </p> </li> <li> <p> <a>DescribeMaintenanceStartTimeOutput$Timezone</a> </p> </li> </ul>', 'refs' => [], ], 'DescribeNFSFileSharesInput' => [ 'base' => '<p>DescribeNFSFileSharesInput</p>', 'refs' => [], ], 'DescribeNFSFileSharesOutput' => [ 'base' => '<p>DescribeNFSFileSharesOutput</p>', 'refs' => [], ], 'DescribeSMBFileSharesInput' => [ 'base' => '<p>DescribeSMBFileSharesInput</p>', 'refs' => [], ], 'DescribeSMBFileSharesOutput' => [ 'base' => '<p>DescribeSMBFileSharesOutput</p>', 'refs' => [], ], 'DescribeSMBSettingsInput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeSMBSettingsOutput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeSnapshotScheduleInput' => [ 'base' => '<p>A JSON object containing the <a>DescribeSnapshotScheduleInput$VolumeARN</a> of the volume.</p>', 'refs' => [], ], 'DescribeSnapshotScheduleOutput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeStorediSCSIVolumesInput' => [ 'base' => '<p>A JSON object containing a list of <a>DescribeStorediSCSIVolumesInput$VolumeARNs</a>.</p>', 'refs' => [], ], 'DescribeStorediSCSIVolumesOutput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeTapeArchivesInput' => [ 'base' => '<p>DescribeTapeArchivesInput</p>', 'refs' => [], ], 'DescribeTapeArchivesOutput' => [ 'base' => '<p>DescribeTapeArchivesOutput</p>', 'refs' => [], ], 'DescribeTapeRecoveryPointsInput' => [ 'base' => '<p>DescribeTapeRecoveryPointsInput</p>', 'refs' => [], ], 'DescribeTapeRecoveryPointsOutput' => [ 'base' => '<p>DescribeTapeRecoveryPointsOutput</p>', 'refs' => [], ], 'DescribeTapesInput' => [ 'base' => '<p>DescribeTapesInput</p>', 'refs' => [], ], 'DescribeTapesOutput' => [ 'base' => '<p>DescribeTapesOutput</p>', 'refs' => [], ], 'DescribeUploadBufferInput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeUploadBufferOutput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeVTLDevicesInput' => [ 'base' => '<p>DescribeVTLDevicesInput</p>', 'refs' => [], ], 'DescribeVTLDevicesOutput' => [ 'base' => '<p>DescribeVTLDevicesOutput</p>', 'refs' => [], ], 'DescribeWorkingStorageInput' => [ 'base' => '<p>A JSON object containing the Amazon Resource Name (ARN) of the gateway.</p>', 'refs' => [], ], 'DescribeWorkingStorageOutput' => [ 'base' => '<p>A JSON object containing the following fields:</p>', 'refs' => [], ], 'Description' => [ 'base' => NULL, 'refs' => [ 'DescribeSnapshotScheduleOutput$Description' => '<p>The snapshot description.</p>', 'UpdateSnapshotScheduleInput$Description' => '<p>Optional description of the snapshot that overwrites the existing description.</p>', ], ], 'DetachVolumeInput' => [ 'base' => '<p>AttachVolumeInput</p>', 'refs' => [], ], 'DetachVolumeOutput' => [ 'base' => '<p>AttachVolumeOutput</p>', 'refs' => [], ], 'DeviceType' => [ 'base' => NULL, 'refs' => [ 'UpdateVTLDeviceTypeInput$DeviceType' => '<p>The type of medium changer you want to select.</p> <p>Valid Values: <code>STK-L700</code> | <code>AWS-Gateway-VTL</code> | <code>IBM-03584L32-0402</code> </p>', ], ], 'DeviceiSCSIAttributes' => [ 'base' => '<p>Lists iSCSI information about a VTL device.</p>', 'refs' => [ 'VTLDevice$DeviceiSCSIAttributes' => '<p>A list of iSCSI information about a VTL device.</p>', ], ], 'DisableGatewayInput' => [ 'base' => '<p>DisableGatewayInput</p>', 'refs' => [], ], 'DisableGatewayOutput' => [ 'base' => '<p>DisableGatewayOutput</p>', 'refs' => [], ], 'DisassociateFileSystemInput' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateFileSystemOutput' => [ 'base' => NULL, 'refs' => [], ], 'Disk' => [ 'base' => '<p>Represents a gateway\'s local disk.</p>', 'refs' => [ 'Disks$member' => NULL, ], ], 'DiskAllocationType' => [ 'base' => '<p>One of the <code>DiskAllocationType</code> enumeration values that identifies how a local disk is used.</p> <p>Valid Values: <code>UPLOAD_BUFFER</code> | <code>CACHE_STORAGE</code> </p>', 'refs' => [ 'Disk$DiskAllocationType' => NULL, ], ], 'DiskAttribute' => [ 'base' => NULL, 'refs' => [ 'DiskAttributeList$member' => NULL, ], ], 'DiskAttributeList' => [ 'base' => '<p>A list of values that represents attributes of a local disk.</p>', 'refs' => [ 'Disk$DiskAttributeList' => NULL, ], ], 'DiskId' => [ 'base' => NULL, 'refs' => [ 'AttachVolumeInput$DiskId' => '<p>The unique device ID or other distinguishing data that identifies the local disk used to create the volume. This value is only required when you are attaching a stored volume.</p>', 'CreateStorediSCSIVolumeInput$DiskId' => '<p>The unique identifier for the gateway local disk that is configured as a stored volume. Use <a href="https://docs.aws.amazon.com/storagegateway/latest/userguide/API_ListLocalDisks.html">ListLocalDisks</a> to list disk IDs for a gateway.</p>', 'Disk$DiskId' => '<p>The unique device ID or other distinguishing data that identifies a local disk.</p>', 'DiskIds$member' => NULL, 'StorediSCSIVolume$VolumeDiskId' => '<p>The ID of the local disk that was specified in the <a>CreateStorediSCSIVolume</a> operation.</p>', ], ], 'DiskIds' => [ 'base' => NULL, 'refs' => [ 'AddCacheInput$DiskIds' => '<p>An array of strings that identify disks that are to be configured as working storage. Each string has a minimum length of 1 and maximum length of 300. You can get the disk IDs from the <a>ListLocalDisks</a> API.</p>', 'AddUploadBufferInput$DiskIds' => '<p>An array of strings that identify disks that are to be configured as working storage. Each string has a minimum length of 1 and maximum length of 300. You can get the disk IDs from the <a>ListLocalDisks</a> API.</p>', 'AddWorkingStorageInput$DiskIds' => '<p>An array of strings that identify disks that are to be configured as working storage. Each string has a minimum length of 1 and maximum length of 300. You can get the disk IDs from the <a>ListLocalDisks</a> API.</p>', 'DescribeCacheOutput$DiskIds' => '<p>An array of strings that identify disks that are to be configured as working storage. Each string has a minimum length of 1 and maximum length of 300. You can get the disk IDs from the <a>ListLocalDisks</a> API.</p>', 'DescribeUploadBufferOutput$DiskIds' => '<p>An array of the gateway\'s local disk IDs that are configured as working storage. Each local disk ID is specified as a string (minimum length of 1 and maximum length of 300). If no local disks are configured as working storage, then the DiskIds array is empty.</p>', 'DescribeWorkingStorageOutput$DiskIds' => '<p>An array of the gateway\'s local disk IDs that are configured as working storage. Each local disk ID is specified as a string (minimum length of 1 and maximum length of 300). If no local disks are configured as working storage, then the DiskIds array is empty.</p>', ], ], 'Disks' => [ 'base' => NULL, 'refs' => [ 'ListLocalDisksOutput$Disks' => '<p>A JSON object containing the following fields:</p> <ul> <li> <p> <a>ListLocalDisksOutput$Disks</a> </p> </li> </ul>', ], ], 'DomainName' => [ 'base' => NULL, 'refs' => [ 'DescribeSMBSettingsOutput$DomainName' => '<p>The name of the domain that the gateway is joined to.</p>', 'JoinDomainInput$DomainName' => '<p>The name of the domain that you want the gateway to join.</p>', ], ], 'DomainUserName' => [ 'base' => NULL, 'refs' => [ 'AssociateFileSystemInput$UserName' => '<p>The user name of the user credential that has permission to access the root share D$ of the Amazon FSx file system. The user account must belong to the Amazon FSx delegated admin user group.</p>', 'JoinDomainInput$UserName' => '<p>Sets the user name of user who has permission to add the gateway to the Active Directory domain. The domain user account should be enabled to join computers to the domain. For example, you can use the domain administrator account or an account with delegated permissions to join computers to the domain.</p>', 'UpdateFileSystemAssociationInput$UserName' => '<p>The user name of the user credential that has permission to access the root share D$ of the Amazon FSx file system. The user account must belong to the Amazon FSx delegated admin user group.</p>', ], ], 'DomainUserPassword' => [ 'base' => NULL, 'refs' => [ 'AssociateFileSystemInput$Password' => '<p>The password of the user credential.</p>', 'JoinDomainInput$Password' => '<p>Sets the password of the user who has permission to add the gateway to the Active Directory domain.</p>', 'UpdateFileSystemAssociationInput$Password' => '<p>The password of the user credential.</p>', ], ], 'DoubleObject' => [ 'base' => NULL, 'refs' => [ 'CachediSCSIVolume$VolumeProgress' => '<p>Represents the percentage complete if the volume is restoring or bootstrapping that represents the percent of data transferred. This field does not appear in the response if the cached volume is not restoring or bootstrapping.</p>', 'StorediSCSIVolume$VolumeProgress' => '<p>Represents the percentage complete if the volume is restoring or bootstrapping that represents the percent of data transferred. This field does not appear in the response if the stored volume is not restoring or bootstrapping.</p>', 'Tape$Progress' => '<p>For archiving virtual tapes, indicates how much data remains to be uploaded before archiving is complete.</p> <p>Range: 0 (not started) to 100 (complete).</p>', ], ], 'Ec2InstanceId' => [ 'base' => NULL, 'refs' => [ 'DescribeGatewayInformationOutput$Ec2InstanceId' => '<p>The ID of the Amazon EC2 instance that was used to launch the gateway.</p>', 'GatewayInfo$Ec2InstanceId' => '<p>The ID of the Amazon EC2 instance that was used to launch the gateway.</p>', ], ], 'Ec2InstanceRegion' => [ 'base' => NULL, 'refs' => [ 'DescribeGatewayInformationOutput$Ec2InstanceRegion' => '<p>The Region where the Amazon EC2 instance is located.</p>', 'GatewayInfo$Ec2InstanceRegion' => '<p>The Region where the Amazon EC2 instance is located.</p>', ], ], 'EndpointNetworkConfiguration' => [ 'base' => '<p>Specifies network configuration information for the gateway associated with the Amazon FSx file system.</p>', 'refs' => [ 'AssociateFileSystemInput$EndpointNetworkConfiguration' => '<p>Specifies the network configuration information for the gateway associated with the Amazon FSx file system.</p> <note> <p>If multiple file systems are associated with this gateway, this parameter\'s <code>IpAddresses</code> field is required.</p> </note>', 'FileSystemAssociationInfo$EndpointNetworkConfiguration' => '<p>Specifies network configuration information for the gateway associated with the Amazon FSx file system.</p> <note> <p>If multiple file systems are associated with this gateway, this parameter\'s <code>IpAddresses</code> field is required.</p> </note>', ], ], 'EndpointType' => [ 'base' => NULL, 'refs' => [ 'DescribeGatewayInformationOutput$EndpointType' => '<p>The type of endpoint for your gateway.</p> <p>Valid Values: <code>STANDARD</code> | <code>FIPS</code> </p>', ], ], 'ErrorCode' => [ 'base' => NULL, 'refs' => [ 'StorageGatewayError$errorCode' => '<p>Additional information about the error.</p>', ], ], 'FileShareARN' => [ 'base' => '<p>The Amazon Resource Name (ARN) of the file share.</p>', 'refs' => [ 'CreateNFSFileShareOutput$FileShareARN' => '<p>The Amazon Resource Name (ARN) of the newly created file share.</p>', 'CreateSMBFileShareOutput$FileShareARN' => '<p>The Amazon Resource Name (ARN) of the newly created file share.</p>', 'DeleteFileShareInput$FileShareARN' => '<p>The Amazon Resource Name (ARN) of the file share to be deleted.</p>', 'DeleteFileShareOutput$FileShareARN' => '<p>The Amazon Resource Name (ARN) of the deleted file share.</p>', 'FileShareARNList$member' => NULL, 'FileShareInfo$FileShareARN' => NULL, 'NFSFileShareInfo$FileShareARN' => NULL, 'NotifyWhenUploadedInput$FileShareARN' => NULL, 'NotifyWhenUploadedOutput$FileShareARN' => NULL, 'RefreshCacheInput$FileShareARN' => '<p>The Amazon Resource Name (ARN) of the file share you want to refresh.</p>', 'RefreshCacheOutput$FileShareARN' => NULL, 'SMBFileShareInfo$FileShareARN' => NULL, 'UpdateNFSFileShareInput$FileShareARN' => '<p>The Amazon Resource Name (ARN) of the file share to be updated.</p>', 'UpdateNFSFileShareOutput$FileShareARN' => '<p>The Amazon Resource Name (ARN) of the updated file share.</p>', 'UpdateSMBFileShareInput$FileShareARN' => '<p>The Amazon Resource Name (ARN) of the SMB file share that you want to update.</p>', 'UpdateSMBFileShareOutput$FileShareARN' => '<p>The Amazon Resource Name (ARN) of the updated SMB file share.</p>', ], ], 'FileShareARNList' => [ 'base' => NULL, 'refs' => [ 'DescribeNFSFileSharesInput$FileShareARNList' => '<p>An array containing the Amazon Resource Name (ARN) of each file share to be described.</p>', 'DescribeSMBFileSharesInput$FileShareARNList' => '<p>An array containing the Amazon Resource Name (ARN) of each file share to be described.</p>', ], ], 'FileShareClientList' => [ 'base' => '<p>The list of clients that are allowed to access the S3 File Gateway. The list must contain either valid IP addresses or valid CIDR blocks.</p>', 'refs' => [ 'CreateNFSFileShareInput$ClientList' => '<p>The list of clients that are allowed to access the S3 File Gateway. The list must contain either valid IP addresses or valid CIDR blocks.</p>', 'NFSFileShareInfo$ClientList' => NULL, 'UpdateNFSFileShareInput$ClientList' => '<p>The list of clients that are allowed to access the S3 File Gateway. The list must contain either valid IP addresses or valid CIDR blocks.</p>', ], ], 'FileShareId' => [ 'base' => '<p>The ID of the file share.</p>', 'refs' => [ 'FileShareInfo$FileShareId' => NULL, 'NFSFileShareInfo$FileShareId' => NULL, 'SMBFileShareInfo$FileShareId' => NULL, ], ], 'FileShareInfo' => [ 'base' => '<p>Describes a file share. Only supported S3 File Gateway.</p>', 'refs' => [ 'FileShareInfoList$member' => NULL, ], ], 'FileShareInfoList' => [ 'base' => NULL, 'refs' => [ 'ListFileSharesOutput$FileShareInfoList' => '<p>An array of information about the S3 File Gateway\'s file shares.</p>', ], ], 'FileShareName' => [ 'base' => NULL, 'refs' => [ 'CreateNFSFileShareInput$FileShareName' => '<p>The name of the file share. Optional.</p> <note> <p> <code>FileShareName</code> must be set if an S3 prefix name is set in <code>LocationARN</code>.</p> </note>', 'CreateSMBFileShareInput$FileShareName' => '<p>The name of the file share. Optional.</p> <note> <p> <code>FileShareName</code> must be set if an S3 prefix name is set in <code>LocationARN</code>.</p> </note>', 'NFSFileShareInfo$FileShareName' => '<p>The name of the file share. Optional.</p> <note> <p> <code>FileShareName</code> must be set if an S3 prefix name is set in <code>LocationARN</code>.</p> </note>', 'SMBFileShareInfo$FileShareName' => '<p>The name of the file share. Optional.</p> <note> <p> <code>FileShareName</code> must be set if an S3 prefix name is set in <code>LocationARN</code>.</p> </note>', 'UpdateNFSFileShareInput$FileShareName' => '<p>The name of the file share. Optional.</p> <note> <p> <code>FileShareName</code> must be set if an S3 prefix name is set in <code>LocationARN</code>.</p> </note>', 'UpdateSMBFileShareInput$FileShareName' => '<p>The name of the file share. Optional.</p> <note> <p> <code>FileShareName</code> must be set if an S3 prefix name is set in <code>LocationARN</code>.</p> </note>', ], ], 'FileShareStatus' => [ 'base' => '<p>The status of the file share.</p> <p>Valid Values: <code>CREATING</code> | <code>UPDATING</code> | <code>AVAILABLE</code> | <code>DELETING</code> </p>', 'refs' => [ 'FileShareInfo$FileShareStatus' => NULL, 'NFSFileShareInfo$FileShareStatus' => NULL, 'SMBFileShareInfo$FileShareStatus' => NULL, ], ], 'FileShareType' => [ 'base' => '<p>The type of the file share.</p>', 'refs' => [ 'FileShareInfo$FileShareType' => NULL, ], ], 'FileSystemAssociationARN' => [ 'base' => NULL, 'refs' => [ 'AssociateFileSystemOutput$FileSystemAssociationARN' => '<p>The ARN of the newly created file system association.</p>', 'DisassociateFileSystemInput$FileSystemAssociationARN' => '<p>The Amazon Resource Name (ARN) of the file system association to be deleted.</p>', 'DisassociateFileSystemOutput$FileSystemAssociationARN' => '<p>The Amazon Resource Name (ARN) of the deleted file system association.</p>', 'FileSystemAssociationARNList$member' => NULL, 'FileSystemAssociationInfo$FileSystemAssociationARN' => '<p>The Amazon Resource Name (ARN) of the file system association.</p>', 'FileSystemAssociationSummary$FileSystemAssociationARN' => '<p>The Amazon Resource Name (ARN) of the file system association.</p>', 'UpdateFileSystemAssociationInput$FileSystemAssociationARN' => '<p>The Amazon Resource Name (ARN) of the file system association that you want to update.</p>', 'UpdateFileSystemAssociationOutput$FileSystemAssociationARN' => '<p>The ARN of the updated file system association.</p>', ], ], 'FileSystemAssociationARNList' => [ 'base' => NULL, 'refs' => [ 'DescribeFileSystemAssociationsInput$FileSystemAssociationARNList' => '<p>An array containing the Amazon Resource Name (ARN) of each file system association to be described.</p>', ], ], 'FileSystemAssociationId' => [ 'base' => NULL, 'refs' => [ 'FileSystemAssociationSummary$FileSystemAssociationId' => '<p>The ID of the file system association.</p>', ], ], 'FileSystemAssociationInfo' => [ 'base' => '<p>Describes the object returned by <code>DescribeFileSystemAssociations</code> that describes a created file system association.</p>', 'refs' => [ 'FileSystemAssociationInfoList$member' => NULL, ], ], 'FileSystemAssociationInfoList' => [ 'base' => NULL, 'refs' => [ 'DescribeFileSystemAssociationsOutput$FileSystemAssociationInfoList' => '<p>An array containing the <code>FileSystemAssociationInfo</code> data type of each file system association to be described. </p>', ], ], 'FileSystemAssociationStatus' => [ 'base' => NULL, 'refs' => [ 'FileSystemAssociationInfo$FileSystemAssociationStatus' => '<p>The status of the file system association. Valid Values: <code>AVAILABLE</code> | <code>CREATING</code> | <code>DELETING</code> | <code>FORCE_DELETING</code> | <code>UPDATING</code> | <code>ERROR</code> </p>', 'FileSystemAssociationSummary$FileSystemAssociationStatus' => '<p>The status of the file share. Valid Values: <code>AVAILABLE</code> | <code>CREATING</code> | <code>DELETING</code> | <code>FORCE_DELETING</code> | <code>UPDATING</code> | <code>ERROR</code> </p>', ], ], 'FileSystemAssociationSummary' => [ 'base' => '<p>Gets the summary returned by <code>ListFileSystemAssociation</code>, which is a summary of a created file system association.</p>', 'refs' => [ 'FileSystemAssociationSummaryList$member' => NULL, ], ], 'FileSystemAssociationSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListFileSystemAssociationsOutput$FileSystemAssociationSummaryList' => '<p>An array of information about the Amazon FSx gateway\'s file system associations.</p>', ], ], 'FileSystemLocationARN' => [ 'base' => NULL, 'refs' => [ 'AssociateFileSystemInput$LocationARN' => '<p>The Amazon Resource Name (ARN) of the Amazon FSx file system to associate with the FSx File Gateway.</p>', 'FileSystemAssociationInfo$LocationARN' => '<p>The ARN of the backend Amazon FSx file system used for storing file data. For information, see <a href="https://docs.aws.amazon.com/fsx/latest/APIReference/API_FileSystem.html">FileSystem</a> in the <i>Amazon FSx API Reference</i>.</p>', ], ], 'Folder' => [ 'base' => NULL, 'refs' => [ 'FolderList$member' => NULL, ], ], 'FolderList' => [ 'base' => NULL, 'refs' => [ 'RefreshCacheInput$FolderList' => '<p>A comma-separated list of the paths of folders to refresh in the cache. The default is [<code>"/"</code>]. The default refreshes objects and folders at the root of the Amazon S3 bucket. If <code>Recursive</code> is set to <code>true</code>, the entire S3 bucket that the file share has access to is refreshed.</p>', ], ], 'GatewayARN' => [ 'base' => '<p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a> operation to return a list of gateways for your account and Region.</p>', 'refs' => [ 'ActivateGatewayOutput$GatewayARN' => NULL, 'AddCacheInput$GatewayARN' => NULL, 'AddCacheOutput$GatewayARN' => NULL, 'AddUploadBufferInput$GatewayARN' => NULL, 'AddUploadBufferOutput$GatewayARN' => NULL, 'AddWorkingStorageInput$GatewayARN' => NULL, 'AddWorkingStorageOutput$GatewayARN' => NULL, 'AssociateFileSystemInput$GatewayARN' => NULL, 'AttachVolumeInput$GatewayARN' => '<p>The Amazon Resource Name (ARN) of the gateway that you want to attach the volume to.</p>', 'AutomaticTapeCreationPolicyInfo$GatewayARN' => NULL, 'CancelArchivalInput$GatewayARN' => NULL, 'CancelRetrievalInput$GatewayARN' => NULL, 'CreateCachediSCSIVolumeInput$GatewayARN' => NULL, 'CreateNFSFileShareInput$GatewayARN' => '<p>The Amazon Resource Name (ARN) of the S3 File Gateway on which you want to create a file share.</p>', 'CreateSMBFileShareInput$GatewayARN' => '<p>The ARN of the S3 File Gateway on which you want to create a file share.</p>', 'CreateStorediSCSIVolumeInput$GatewayARN' => NULL, 'CreateTapeWithBarcodeInput$GatewayARN' => '<p>The unique Amazon Resource Name (ARN) that represents the gateway to associate the virtual tape with. Use the <a>ListGateways</a> operation to return a list of gateways for your account and Region.</p>', 'CreateTapesInput$GatewayARN' => '<p>The unique Amazon Resource Name (ARN) that represents the gateway to associate the virtual tapes with. Use the <a>ListGateways</a> operation to return a list of gateways for your account and Region.</p>', 'DeleteAutomaticTapeCreationPolicyInput$GatewayARN' => NULL, 'DeleteAutomaticTapeCreationPolicyOutput$GatewayARN' => NULL, 'DeleteBandwidthRateLimitInput$GatewayARN' => NULL, 'DeleteBandwidthRateLimitOutput$GatewayARN' => NULL, 'DeleteGatewayInput$GatewayARN' => NULL, 'DeleteGatewayOutput$GatewayARN' => NULL, 'DeleteTapeInput$GatewayARN' => '<p>The unique Amazon Resource Name (ARN) of the gateway that the virtual tape to delete is associated with. Use the <a>ListGateways</a> operation to return a list of gateways for your account and Region.</p>', 'DescribeAvailabilityMonitorTestInput$GatewayARN' => NULL, 'DescribeAvailabilityMonitorTestOutput$GatewayARN' => NULL, 'DescribeBandwidthRateLimitInput$GatewayARN' => NULL, 'DescribeBandwidthRateLimitOutput$GatewayARN' => NULL, 'DescribeBandwidthRateLimitScheduleInput$GatewayARN' => NULL, 'DescribeBandwidthRateLimitScheduleOutput$GatewayARN' => NULL, 'DescribeCacheInput$GatewayARN' => NULL, 'DescribeCacheOutput$GatewayARN' => NULL, 'DescribeGatewayInformationInput$GatewayARN' => NULL, 'DescribeGatewayInformationOutput$GatewayARN' => NULL, 'DescribeMaintenanceStartTimeInput$GatewayARN' => NULL, 'DescribeMaintenanceStartTimeOutput$GatewayARN' => NULL, 'DescribeSMBSettingsInput$GatewayARN' => NULL, 'DescribeSMBSettingsOutput$GatewayARN' => NULL, 'DescribeTapeRecoveryPointsInput$GatewayARN' => NULL, 'DescribeTapeRecoveryPointsOutput$GatewayARN' => NULL, 'DescribeTapesInput$GatewayARN' => NULL, 'DescribeUploadBufferInput$GatewayARN' => NULL, 'DescribeUploadBufferOutput$GatewayARN' => NULL, 'DescribeVTLDevicesInput$GatewayARN' => NULL, 'DescribeVTLDevicesOutput$GatewayARN' => NULL, 'DescribeWorkingStorageInput$GatewayARN' => NULL, 'DescribeWorkingStorageOutput$GatewayARN' => NULL, 'DisableGatewayInput$GatewayARN' => NULL, 'DisableGatewayOutput$GatewayARN' => '<p>The unique Amazon Resource Name (ARN) of the disabled gateway.</p>', 'FileShareInfo$GatewayARN' => NULL, 'FileSystemAssociationInfo$GatewayARN' => NULL, 'FileSystemAssociationSummary$GatewayARN' => NULL, 'GatewayInfo$GatewayARN' => '<p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a> operation to return a list of gateways for your account and Region.</p>', 'JoinDomainInput$GatewayARN' => '<p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Region.</p>', 'JoinDomainOutput$GatewayARN' => '<p>The unique Amazon Resource Name (ARN) of the gateway that joined the domain.</p>', 'ListAutomaticTapeCreationPoliciesInput$GatewayARN' => NULL, 'ListFileSharesInput$GatewayARN' => '<p>The Amazon Resource Name (ARN) of the gateway whose file shares you want to list. If this field is not present, all file shares under your account are listed.</p>', 'ListFileSystemAssociationsInput$GatewayARN' => NULL, 'ListLocalDisksInput$GatewayARN' => NULL, 'ListLocalDisksOutput$GatewayARN' => NULL, 'ListVolumeRecoveryPointsInput$GatewayARN' => NULL, 'ListVolumeRecoveryPointsOutput$GatewayARN' => NULL, 'ListVolumesInput$GatewayARN' => NULL, 'ListVolumesOutput$GatewayARN' => NULL, 'NFSFileShareInfo$GatewayARN' => NULL, 'ResetCacheInput$GatewayARN' => NULL, 'ResetCacheOutput$GatewayARN' => NULL, 'RetrieveTapeArchiveInput$GatewayARN' => '<p>The Amazon Resource Name (ARN) of the gateway you want to retrieve the virtual tape to. Use the <a>ListGateways</a> operation to return a list of gateways for your account and Region.</p> <p>You retrieve archived virtual tapes to only one gateway and the gateway must be a tape gateway.</p>', 'RetrieveTapeRecoveryPointInput$GatewayARN' => NULL, 'SMBFileShareInfo$GatewayARN' => NULL, 'SetLocalConsolePasswordInput$GatewayARN' => NULL, 'SetLocalConsolePasswordOutput$GatewayARN' => NULL, 'SetSMBGuestPasswordInput$GatewayARN' => '<p>The Amazon Resource Name (ARN) of the S3 File Gateway the SMB file share is associated with.</p>', 'SetSMBGuestPasswordOutput$GatewayARN' => NULL, 'ShutdownGatewayInput$GatewayARN' => NULL, 'ShutdownGatewayOutput$GatewayARN' => NULL, 'StartAvailabilityMonitorTestInput$GatewayARN' => NULL, 'StartAvailabilityMonitorTestOutput$GatewayARN' => NULL, 'StartGatewayInput$GatewayARN' => NULL, 'StartGatewayOutput$GatewayARN' => NULL, 'TapeArchive$RetrievedTo' => '<p>The Amazon Resource Name (ARN) of the tape gateway that the virtual tape is being retrieved to.</p> <p>The virtual tape is retrieved from the virtual tape shelf (VTS).</p>', 'TapeInfo$GatewayARN' => '<p>The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a> operation to return a list of gateways for your account and Region.</p>', 'UpdateAutomaticTapeCreationPolicyInput$GatewayARN' => NULL, 'UpdateAutomaticTapeCreationPolicyOutput$GatewayARN' => NULL, 'UpdateBandwidthRateLimitInput$GatewayARN' => NULL, 'UpdateBandwidthRateLimitOutput$GatewayARN' => NULL, 'UpdateBandwidthRateLimitScheduleInput$GatewayARN' => NULL, 'UpdateBandwidthRateLimitScheduleOutput$GatewayARN' => NULL, 'UpdateGatewayInformationInput$GatewayARN' => NULL, 'UpdateGatewayInformationOutput$GatewayARN' => NULL, 'UpdateGatewaySoftwareNowInput$GatewayARN' => NULL, 'UpdateGatewaySoftwareNowOutput$GatewayARN' => NULL, 'UpdateMaintenanceStartTimeInput$GatewayARN' => NULL, 'UpdateMaintenanceStartTimeOutput$GatewayARN' => NULL, 'UpdateSMBFileShareVisibilityInput$GatewayARN' => NULL, 'UpdateSMBFileShareVisibilityOutput$GatewayARN' => NULL, 'UpdateSMBSecurityStrategyInput$GatewayARN' => NULL, 'UpdateSMBSecurityStrategyOutput$GatewayARN' => NULL, 'VolumeInfo$GatewayARN' => NULL, ], ], 'GatewayCapacity' => [ 'base' => NULL, 'refs' => [ 'DescribeGatewayInformationOutput$GatewayCapacity' => '<p>Specifies the size of the gateway\'s metadata cache.</p>', 'SupportedGatewayCapacities$member' => NULL, 'UpdateGatewayInformationInput$GatewayCapacity' => '<p>Specifies the size of the gateway\'s metadata cache.</p>', ], ], 'GatewayId' => [ 'base' => NULL, 'refs' => [ 'DescribeGatewayInformationOutput$GatewayId' => '<p>The unique identifier assigned to your gateway during activation. This ID becomes part of the gateway Amazon Resource Name (ARN), which you use as input for other operations.</p>', 'GatewayInfo$GatewayId' => '<p>The unique identifier assigned to your gateway during activation. This ID becomes part of the gateway Amazon Resource Name (ARN), which you use as input for other operations.</p>', 'VolumeInfo$GatewayId' => '<p>The unique identifier assigned to your gateway during activation. This ID becomes part of the gateway Amazon Resource Name (ARN), which you use as input for other operations.</p> <p>Valid Values: 50 to 500 lowercase letters, numbers, periods (.), and hyphens (-).</p>', ], ], 'GatewayInfo' => [ 'base' => '<p>Describes a gateway object.</p>', 'refs' => [ 'Gateways$member' => NULL, ], ], 'GatewayName' => [ 'base' => '<p>The name you configured for your gateway.</p>', 'refs' => [ 'ActivateGatewayInput$GatewayName' => '<p>The name you configured for your gateway.</p>', 'UpdateGatewayInformationInput$GatewayName' => NULL, ], ], 'GatewayNetworkInterfaces' => [ 'base' => NULL, 'refs' => [ 'DescribeGatewayInformationOutput$GatewayNetworkInterfaces' => '<p>A <a>NetworkInterface</a> array that contains descriptions of the gateway network interfaces.</p>', ], ], 'GatewayOperationalState' => [ 'base' => NULL, 'refs' => [ 'GatewayInfo$GatewayOperationalState' => '<p>The state of the gateway.</p> <p>Valid Values: <code>DISABLED</code> | <code>ACTIVE</code> </p>', ], ], 'GatewayState' => [ 'base' => NULL, 'refs' => [ 'DescribeGatewayInformationOutput$GatewayState' => '<p>A value that indicates the operating state of the gateway.</p>', ], ], 'GatewayTimezone' => [ 'base' => NULL, 'refs' => [ 'ActivateGatewayInput$GatewayTimezone' => '<p>A value that indicates the time zone you want to set for the gateway. The time zone is of the format "GMT-hr:mm" or "GMT+hr:mm". For example, GMT-4:00 indicates the time is 4 hours behind GMT. GMT+2:00 indicates the time is 2 hours ahead of GMT. The time zone is used, for example, for scheduling snapshots and your gateway\'s maintenance schedule.</p>', 'DescribeGatewayInformationOutput$GatewayTimezone' => '<p>A value that indicates the time zone configured for the gateway.</p>', 'DescribeMaintenanceStartTimeOutput$Timezone' => '<p>A value that indicates the time zone that is set for the gateway. The start time and day of week specified should be in the time zone of the gateway.</p>', 'DescribeSnapshotScheduleOutput$Timezone' => '<p>A value that indicates the time zone of the gateway.</p>', 'UpdateGatewayInformationInput$GatewayTimezone' => '<p>A value that indicates the time zone of the gateway.</p>', ], ], 'GatewayType' => [ 'base' => NULL, 'refs' => [ 'ActivateGatewayInput$GatewayType' => '<p>A value that defines the type of gateway to activate. The type specified is critical to all later functions of the gateway and cannot be changed after activation. The default value is <code>CACHED</code>.</p> <p>Valid Values: <code>STORED</code> | <code>CACHED</code> | <code>VTL</code> | <code>FILE_S3</code> | <code>FILE_FSX_SMB|</code> </p>', 'DescribeGatewayInformationOutput$GatewayType' => '<p>The type of the gateway.</p>', 'GatewayInfo$GatewayType' => '<p>The type of the gateway.</p>', ], ], 'Gateways' => [ 'base' => NULL, 'refs' => [ 'ListGatewaysOutput$Gateways' => '<p>An array of <a>GatewayInfo</a> objects.</p>', ], ], 'Host' => [ 'base' => NULL, 'refs' => [ 'Hosts$member' => NULL, ], ], 'HostEnvironment' => [ 'base' => NULL, 'refs' => [ 'DescribeGatewayInformationOutput$HostEnvironment' => '<p>The type of hypervisor environment used by the host.</p>', ], ], 'Hosts' => [ 'base' => NULL, 'refs' => [ 'JoinDomainInput$DomainControllers' => '<p>List of IPv4 addresses, NetBIOS names, or host names of your domain server. If you need to specify the port number include it after the colon (“:”). For example, <code>mydc.mydomain.com:389</code>.</p>', ], ], 'HourOfDay' => [ 'base' => NULL, 'refs' => [ 'BandwidthRateLimitInterval$StartHourOfDay' => '<p> The hour of the day to start the bandwidth rate limit interval. </p>', 'BandwidthRateLimitInterval$EndHourOfDay' => '<p> The hour of the day to end the bandwidth rate limit interval. </p>', 'DescribeMaintenanceStartTimeOutput$HourOfDay' => '<p>The hour component of the maintenance start time represented as <i>hh</i>, where <i>hh</i> is the hour (0 to 23). The hour of the day is in the time zone of the gateway.</p>', 'DescribeSnapshotScheduleOutput$StartAt' => '<p>The hour of the day at which the snapshot schedule begins represented as <i>hh</i>, where <i>hh</i> is the hour (0 to 23). The hour of the day is in the time zone of the gateway.</p>', 'UpdateMaintenanceStartTimeInput$HourOfDay' => '<p>The hour component of the maintenance start time represented as <i>hh</i>, where <i>hh</i> is the hour (00 to 23). The hour of the day is in the time zone of the gateway.</p>', 'UpdateSnapshotScheduleInput$StartAt' => '<p>The hour of the day at which the snapshot schedule begins represented as <i>hh</i>, where <i>hh</i> is the hour (0 to 23). The hour of the day is in the time zone of the gateway.</p>', ], ], 'IPV4Address' => [ 'base' => NULL, 'refs' => [ 'IpAddressList$member' => NULL, ], ], 'IPV4AddressCIDR' => [ 'base' => NULL, 'refs' => [ 'FileShareClientList$member' => NULL, ], ], 'Initiator' => [ 'base' => NULL, 'refs' => [ 'Initiators$member' => NULL, ], ], 'Initiators' => [ 'base' => NULL, 'refs' => [ 'ListVolumeInitiatorsOutput$Initiators' => '<p>The host names and port numbers of all iSCSI initiators that are connected to the gateway.</p>', ], ], 'InternalServerError' => [ 'base' => '<p>An internal server error has occurred during the request. For more information, see the error and message fields.</p>', 'refs' => [], ], 'InvalidGatewayRequestException' => [ 'base' => '<p>An exception occurred because an invalid gateway request was issued to the service. For more information, see the error and message fields.</p>', 'refs' => [], ], 'IpAddressList' => [ 'base' => NULL, 'refs' => [ 'EndpointNetworkConfiguration$IpAddresses' => '<p>A list of gateway IP addresses on which the associated Amazon FSx file system is available.</p> <note> <p>If multiple file systems are associated with this gateway, this field is required.</p> </note>', ], ], 'IqnName' => [ 'base' => NULL, 'refs' => [ 'ChapInfo$InitiatorName' => '<p>The iSCSI initiator that connects to the target.</p>', 'DeleteChapCredentialsInput$InitiatorName' => '<p>The iSCSI initiator that connects to the target.</p>', 'DeleteChapCredentialsOutput$InitiatorName' => '<p>The iSCSI initiator that connects to the target.</p>', 'UpdateChapCredentialsInput$InitiatorName' => '<p>The iSCSI initiator that connects to the target.</p>', 'UpdateChapCredentialsOutput$InitiatorName' => '<p>The iSCSI initiator that connects to the target. This is the same initiator name specified in the request.</p>', ], ], 'JoinDomainInput' => [ 'base' => '<p>JoinDomainInput</p>', 'refs' => [], ], 'JoinDomainOutput' => [ 'base' => '<p>JoinDomainOutput</p>', 'refs' => [], ], 'KMSKey' => [ 'base' => '<p>The Amazon Resource Name (ARN) of a symmetric customer master key (CMK) used for Amazon S3 server-side encryption. Storage Gateway does not support asymmetric CMKs. This value can only be set when <code>KMSEncrypted</code> is <code>true</code>. Optional.</p>', 'refs' => [ 'CachediSCSIVolume$KMSKey' => NULL, 'CreateCachediSCSIVolumeInput$KMSKey' => '<p>The Amazon Resource Name (ARN) of a symmetric customer master key (CMK) used for Amazon S3 server-side encryption. Storage Gateway does not support asymmetric CMKs. This value can only be set when <code>KMSEncrypted</code> is <code>true</code>. Optional.</p>', 'CreateNFSFileShareInput$KMSKey' => '<p>The Amazon Resource Name (ARN) of a symmetric customer master key (CMK) used for Amazon S3 server-side encryption. Storage Gateway does not support asymmetric CMKs. This value can only be set when <code>KMSEncrypted</code> is <code>true</code>. Optional.</p>', 'CreateSMBFileShareInput$KMSKey' => '<p>The Amazon Resource Name (ARN) of a symmetric customer master key (CMK) used for Amazon S3 server-side encryption. Storage Gateway does not support asymmetric CMKs. This value can only be set when <code>KMSEncrypted</code> is <code>true</code>. Optional.</p>', 'CreateStorediSCSIVolumeInput$KMSKey' => '<p>The Amazon Resource Name (ARN) of a symmetric customer master key (CMK) used for Amazon S3 server-side encryption. Storage Gateway does not support asymmetric CMKs. This value can only be set when <code>KMSEncrypted</code> is <code>true</code>. Optional.</p>', 'CreateTapeWithBarcodeInput$KMSKey' => '<p>The Amazon Resource Name (ARN) of a symmetric customer master key (CMK) used for Amazon S3 server-side encryption. Storage Gateway does not support asymmetric CMKs. This value can only be set when <code>KMSEncrypted</code> is <code>true</code>. Optional.</p>', 'CreateTapesInput$KMSKey' => '<p>The Amazon Resource Name (ARN) of a symmetric customer master key (CMK) used for Amazon S3 server-side encryption. Storage Gateway does not support asymmetric CMKs. This value can only be set when <code>KMSEncrypted</code> is <code>true</code>. Optional.</p>', 'NFSFileShareInfo$KMSKey' => NULL, 'SMBFileShareInfo$KMSKey' => NULL, 'StorediSCSIVolume$KMSKey' => NULL, 'Tape$KMSKey' => NULL, 'TapeArchive$KMSKey' => NULL, 'UpdateNFSFileShareInput$KMSKey' => '<p>The Amazon Resource Name (ARN) of a symmetric customer master key (CMK) used for Amazon S3 server-side encryption. Storage Gateway does not support asymmetric CMKs. This value can only be set when <code>KMSEncrypted</code> is <code>true</code>. Optional.</p>', 'UpdateSMBFileShareInput$KMSKey' => '<p>The Amazon Resource Name (ARN) of a symmetric customer master key (CMK) used for Amazon S3 server-side encryption. Storage Gateway does not support asymmetric CMKs. This value can only be set when <code>KMSEncrypted</code> is <code>true</code>. Optional.</p>', ], ], 'LastSoftwareUpdate' => [ 'base' => NULL, 'refs' => [ 'DescribeGatewayInformationOutput$LastSoftwareUpdate' => '<p>The date on which the last software update was applied to the gateway. If the gateway has never been updated, this field does not return a value in the response.</p>', ], ], 'ListAutomaticTapeCreationPoliciesInput' => [ 'base' => NULL, 'refs' => [], ], 'ListAutomaticTapeCreationPoliciesOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListFileSharesInput' => [ 'base' => '<p>ListFileShareInput</p>', 'refs' => [], ], 'ListFileSharesOutput' => [ 'base' => '<p>ListFileShareOutput</p>', 'refs' => [], ], 'ListFileSystemAssociationsInput' => [ 'base' => NULL, 'refs' => [], ], 'ListFileSystemAssociationsOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListGatewaysInput' => [ 'base' => '<p>A JSON object containing zero or more of the following fields:</p> <ul> <li> <p> <a>ListGatewaysInput$Limit</a> </p> </li> <li> <p> <a>ListGatewaysInput$Marker</a> </p> </li> </ul>', 'refs' => [], ], 'ListGatewaysOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListLocalDisksInput' => [ 'base' => '<p>A JSON object containing the Amazon Resource Name (ARN) of the gateway.</p>', 'refs' => [], ], 'ListLocalDisksOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceInput' => [ 'base' => '<p>ListTagsForResourceInput</p>', 'refs' => [], ], 'ListTagsForResourceOutput' => [ 'base' => '<p>ListTagsForResourceOutput</p>', 'refs' => [], ], 'ListTapePoolsInput' => [ 'base' => NULL, 'refs' => [], ], 'ListTapePoolsOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListTapesInput' => [ 'base' => '<p>A JSON object that contains one or more of the following fields:</p> <ul> <li> <p> <a>ListTapesInput$Limit</a> </p> </li> <li> <p> <a>ListTapesInput$Marker</a> </p> </li> <li> <p> <a>ListTapesInput$TapeARNs</a> </p> </li> </ul>', 'refs' => [], ], 'ListTapesOutput' => [ 'base' => '<p>A JSON object containing the following fields:</p> <ul> <li> <p> <a>ListTapesOutput$Marker</a> </p> </li> <li> <p> <a>ListTapesOutput$VolumeInfos</a> </p> </li> </ul>', 'refs' => [], ], 'ListVolumeInitiatorsInput' => [ 'base' => '<p>ListVolumeInitiatorsInput</p>', 'refs' => [], ], 'ListVolumeInitiatorsOutput' => [ 'base' => '<p>ListVolumeInitiatorsOutput</p>', 'refs' => [], ], 'ListVolumeRecoveryPointsInput' => [ 'base' => NULL, 'refs' => [], ], 'ListVolumeRecoveryPointsOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListVolumesInput' => [ 'base' => '<p>A JSON object that contains one or more of the following fields:</p> <ul> <li> <p> <a>ListVolumesInput$Limit</a> </p> </li> <li> <p> <a>ListVolumesInput$Marker</a> </p> </li> </ul>', 'refs' => [], ], 'ListVolumesOutput' => [ 'base' => '<p>A JSON object containing the following fields:</p> <ul> <li> <p> <a>ListVolumesOutput$Marker</a> </p> </li> <li> <p> <a>ListVolumesOutput$VolumeInfos</a> </p> </li> </ul>', 'refs' => [], ], 'LocalConsolePassword' => [ 'base' => NULL, 'refs' => [ 'SetLocalConsolePasswordInput$LocalConsolePassword' => '<p>The password you want to set for your VM local console.</p>', ], ], 'LocationARN' => [ 'base' => '<p>The ARN of the backend storage used for storing file data. A prefix name can be added to the S3 bucket name. It must end with a "/".</p>', 'refs' => [ 'CreateNFSFileShareInput$LocationARN' => '<p>The ARN of the backend storage used for storing file data. A prefix name can be added to the S3 bucket name. It must end with a "/".</p> <note> <p>You can specify a bucket attached to an access point using a complete ARN that includes the bucket region as shown:</p> <p> <code>arn:aws:s3:<i>region</i>:<i>account-id</i>:accesspoint/<i>access-point-name</i> </code> </p> <p>If you specify a bucket attached to an access point, the bucket policy must be configured to delegate access control to the access point. For information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/access-points-policies.html#access-points-delegating-control">Delegating access control to access points</a> in the <i>Amazon S3 User Guide</i>.</p> </note>', 'CreateSMBFileShareInput$LocationARN' => '<p>The ARN of the backend storage used for storing file data. A prefix name can be added to the S3 bucket name. It must end with a "/".</p> <note> <p>You can specify a bucket attached to an access point using a complete ARN that includes the bucket region as shown:</p> <p> <code>arn:aws:s3:<i>region</i>:<i>account-id</i>:accesspoint/<i>access-point-name</i> </code> </p> <p>If you specify a bucket attached to an access point, the bucket policy must be configured to delegate access control to the access point. For information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/access-points-policies.html#access-points-delegating-control">Delegating access control to access points</a> in the <i>Amazon S3 User Guide</i>.</p> </note>', 'NFSFileShareInfo$LocationARN' => NULL, 'SMBFileShareInfo$LocationARN' => NULL, ], ], 'Marker' => [ 'base' => NULL, 'refs' => [ 'DescribeTapeArchivesInput$Marker' => '<p>An opaque string that indicates the position at which to begin describing virtual tapes.</p>', 'DescribeTapeArchivesOutput$Marker' => '<p>An opaque string that indicates the position at which the virtual tapes that were fetched for description ended. Use this marker in your next request to fetch the next set of virtual tapes in the virtual tape shelf (VTS). If there are no more virtual tapes to describe, this field does not appear in the response.</p>', 'DescribeTapeRecoveryPointsInput$Marker' => '<p>An opaque string that indicates the position at which to begin describing the virtual tape recovery points.</p>', 'DescribeTapeRecoveryPointsOutput$Marker' => '<p>An opaque string that indicates the position at which the virtual tape recovery points that were listed for description ended.</p> <p>Use this marker in your next request to list the next set of virtual tape recovery points in the list. If there are no more recovery points to describe, this field does not appear in the response.</p>', 'DescribeTapesInput$Marker' => '<p>A marker value, obtained in a previous call to <code>DescribeTapes</code>. This marker indicates which page of results to retrieve.</p> <p>If not specified, the first page of results is retrieved.</p>', 'DescribeTapesOutput$Marker' => '<p>An opaque string that can be used as part of a subsequent <code>DescribeTapes</code> call to retrieve the next page of results.</p> <p>If a response does not contain a marker, then there are no more results to be retrieved.</p>', 'DescribeVTLDevicesInput$Marker' => '<p>An opaque string that indicates the position at which to begin describing the VTL devices.</p>', 'DescribeVTLDevicesOutput$Marker' => '<p>An opaque string that indicates the position at which the VTL devices that were fetched for description ended. Use the marker in your next request to fetch the next set of VTL devices in the list. If there are no more VTL devices to describe, this field does not appear in the response.</p>', 'ListFileSharesInput$Marker' => '<p>Opaque pagination token returned from a previous ListFileShares operation. If present, <code>Marker</code> specifies where to continue the list from after a previous call to ListFileShares. Optional.</p>', 'ListFileSharesOutput$Marker' => '<p>If the request includes <code>Marker</code>, the response returns that value in this field.</p>', 'ListFileSharesOutput$NextMarker' => '<p>If a value is present, there are more file shares to return. In a subsequent request, use <code>NextMarker</code> as the value for <code>Marker</code> to retrieve the next set of file shares.</p>', 'ListFileSystemAssociationsInput$Marker' => '<p>Opaque pagination token returned from a previous <code>ListFileSystemAssociations</code> operation. If present, <code>Marker</code> specifies where to continue the list from after a previous call to <code>ListFileSystemAssociations</code>. Optional.</p>', 'ListFileSystemAssociationsOutput$Marker' => '<p>If the request includes <code>Marker</code>, the response returns that value in this field.</p>', 'ListFileSystemAssociationsOutput$NextMarker' => '<p>If a value is present, there are more file system associations to return. In a subsequent request, use <code>NextMarker</code> as the value for <code>Marker</code> to retrieve the next set of file system associations.</p>', 'ListGatewaysInput$Marker' => '<p>An opaque string that indicates the position at which to begin the returned list of gateways.</p>', 'ListGatewaysOutput$Marker' => '<p>Use the marker in your next request to fetch the next set of gateways in the list. If there are no more gateways to list, this field does not appear in the response.</p>', 'ListTagsForResourceInput$Marker' => '<p>An opaque string that indicates the position at which to begin returning the list of tags.</p>', 'ListTagsForResourceOutput$Marker' => '<p>An opaque string that indicates the position at which to stop returning the list of tags.</p>', 'ListTapePoolsInput$Marker' => '<p>A string that indicates the position at which to begin the returned list of tape pools.</p>', 'ListTapePoolsOutput$Marker' => '<p>A string that indicates the position at which to begin the returned list of tape pools. Use the marker in your next request to continue pagination of tape pools. If there are no more tape pools to list, this element does not appear in the response body. </p>', 'ListTapesInput$Marker' => '<p>A string that indicates the position at which to begin the returned list of tapes.</p>', 'ListTapesOutput$Marker' => '<p>A string that indicates the position at which to begin returning the next list of tapes. Use the marker in your next request to continue pagination of tapes. If there are no more tapes to list, this element does not appear in the response body.</p>', 'ListVolumesInput$Marker' => '<p>A string that indicates the position at which to begin the returned list of volumes. Obtain the marker from the response of a previous List iSCSI Volumes request.</p>', 'ListVolumesOutput$Marker' => '<p>Use the marker in your next request to continue pagination of iSCSI volumes. If there are no more volumes to list, this field does not appear in the response body.</p>', ], ], 'MediumChangerType' => [ 'base' => NULL, 'refs' => [ 'ActivateGatewayInput$MediumChangerType' => '<p>The value that indicates the type of medium changer to use for tape gateway. This field is optional.</p> <p>Valid Values: <code>STK-L700</code> | <code>AWS-Gateway-VTL</code> | <code>IBM-03584L32-0402</code> </p>', ], ], 'MinimumNumTapes' => [ 'base' => NULL, 'refs' => [ 'AutomaticTapeCreationRule$MinimumNumTapes' => '<p>The minimum number of available virtual tapes that the gateway maintains at all times. If the number of tapes on the gateway goes below this value, the gateway creates as many new tapes as are needed to have <code>MinimumNumTapes</code> on the gateway. For more information about automatic tape creation, see <a href="https://docs.aws.amazon.com/storagegateway/latest/userguide/GettingStartedCreateTapes.html#CreateTapesAutomatically">Creating Tapes Automatically</a>.</p>', ], ], 'MinuteOfHour' => [ 'base' => NULL, 'refs' => [ 'BandwidthRateLimitInterval$StartMinuteOfHour' => '<p> The minute of the hour to start the bandwidth rate limit interval. The interval begins at the start of that minute. To begin an interval exactly at the start of the hour, use the value <code>0</code>. </p>', 'BandwidthRateLimitInterval$EndMinuteOfHour' => '<p> The minute of the hour to end the bandwidth rate limit interval. </p> <important> <p> The bandwidth rate limit interval ends at the end of the minute. To end an interval at the end of an hour, use the value <code>59</code>. </p> </important>', 'DescribeMaintenanceStartTimeOutput$MinuteOfHour' => '<p>The minute component of the maintenance start time represented as <i>mm</i>, where <i>mm</i> is the minute (0 to 59). The minute of the hour is in the time zone of the gateway.</p>', 'UpdateMaintenanceStartTimeInput$MinuteOfHour' => '<p>The minute component of the maintenance start time represented as <i>mm</i>, where <i>mm</i> is the minute (00 to 59). The minute of the hour is in the time zone of the gateway.</p>', ], ], 'NFSFileShareDefaults' => [ 'base' => '<p>Describes Network File System (NFS) file share default values. Files and folders stored as Amazon S3 objects in S3 buckets don\'t, by default, have Unix file permissions assigned to them. Upon discovery in an S3 bucket by Storage Gateway, the S3 objects that represent files and folders are assigned these default Unix permissions. This operation is only supported for S3 File Gateways.</p>', 'refs' => [ 'CreateNFSFileShareInput$NFSFileShareDefaults' => '<p>File share default values. Optional.</p>', 'NFSFileShareInfo$NFSFileShareDefaults' => NULL, 'UpdateNFSFileShareInput$NFSFileShareDefaults' => '<p>The default values for the file share. Optional.</p>', ], ], 'NFSFileShareInfo' => [ 'base' => '<p>The Unix file permissions and ownership information assigned, by default, to native S3 objects when an S3 File Gateway discovers them in S3 buckets. This operation is only supported in S3 File Gateways.</p>', 'refs' => [ 'NFSFileShareInfoList$member' => NULL, ], ], 'NFSFileShareInfoList' => [ 'base' => NULL, 'refs' => [ 'DescribeNFSFileSharesOutput$NFSFileShareInfoList' => '<p>An array containing a description for each requested file share.</p>', ], ], 'NetworkInterface' => [ 'base' => '<p>Describes a gateway\'s network interface.</p>', 'refs' => [ 'GatewayNetworkInterfaces$member' => NULL, ], ], 'NetworkInterfaceId' => [ 'base' => NULL, 'refs' => [ 'AttachVolumeInput$NetworkInterfaceId' => '<p>The network interface of the gateway on which to expose the iSCSI target. Only IPv4 addresses are accepted. Use <a>DescribeGatewayInformation</a> to get a list of the network interfaces available on a gateway.</p> <p>Valid Values: A valid IP address.</p>', 'CreateCachediSCSIVolumeInput$NetworkInterfaceId' => '<p>The network interface of the gateway on which to expose the iSCSI target. Only IPv4 addresses are accepted. Use <a>DescribeGatewayInformation</a> to get a list of the network interfaces available on a gateway.</p> <p>Valid Values: A valid IP address.</p>', 'CreateStorediSCSIVolumeInput$NetworkInterfaceId' => '<p>The network interface of the gateway on which to expose the iSCSI target. Only IPv4 addresses are accepted. Use <a>DescribeGatewayInformation</a> to get a list of the network interfaces available on a gateway.</p> <p>Valid Values: A valid IP address.</p>', 'DeviceiSCSIAttributes$NetworkInterfaceId' => '<p>The network interface identifier of the VTL device.</p>', 'VolumeiSCSIAttributes$NetworkInterfaceId' => '<p>The network interface identifier.</p>', ], ], 'NextUpdateAvailabilityDate' => [ 'base' => NULL, 'refs' => [ 'DescribeGatewayInformationOutput$NextUpdateAvailabilityDate' => '<p>The date on which an update to the gateway is available. This date is in the time zone of the gateway. If the gateway is not available for an update this field is not returned in the response.</p>', ], ], 'NotificationId' => [ 'base' => '<p>The randomly generated ID of the notification that was sent. This ID is in UUID format.</p>', 'refs' => [ 'NotifyWhenUploadedOutput$NotificationId' => NULL, 'RefreshCacheOutput$NotificationId' => NULL, ], ], 'NotificationPolicy' => [ 'base' => NULL, 'refs' => [ 'CreateNFSFileShareInput$NotificationPolicy' => '<p>The notification policy of the file share. <code>SettlingTimeInSeconds</code> controls the number of seconds to wait after the last point in time a client wrote to a file before generating an <code>ObjectUploaded</code> notification. Because clients can make many small writes to files, it\'s best to set this parameter for as long as possible to avoid generating multiple notifications for the same file in a small time period.</p> <note> <p> <code>SettlingTimeInSeconds</code> has no effect on the timing of the object uploading to Amazon S3, only the timing of the notification.</p> </note> <p>The following example sets <code>NotificationPolicy</code> on with <code>SettlingTimeInSeconds</code> set to 60.</p> <p> <code>{\\"Upload\\": {\\"SettlingTimeInSeconds\\": 60}}</code> </p> <p>The following example sets <code>NotificationPolicy</code> off.</p> <p> <code>{}</code> </p>', 'CreateSMBFileShareInput$NotificationPolicy' => '<p>The notification policy of the file share. <code>SettlingTimeInSeconds</code> controls the number of seconds to wait after the last point in time a client wrote to a file before generating an <code>ObjectUploaded</code> notification. Because clients can make many small writes to files, it\'s best to set this parameter for as long as possible to avoid generating multiple notifications for the same file in a small time period.</p> <note> <p> <code>SettlingTimeInSeconds</code> has no effect on the timing of the object uploading to Amazon S3, only the timing of the notification.</p> </note> <p>The following example sets <code>NotificationPolicy</code> on with <code>SettlingTimeInSeconds</code> set to 60.</p> <p> <code>{\\"Upload\\": {\\"SettlingTimeInSeconds\\": 60}}</code> </p> <p>The following example sets <code>NotificationPolicy</code> off.</p> <p> <code>{}</code> </p>', 'NFSFileShareInfo$NotificationPolicy' => '<p>The notification policy of the file share. <code>SettlingTimeInSeconds</code> controls the number of seconds to wait after the last point in time a client wrote to a file before generating an <code>ObjectUploaded</code> notification. Because clients can make many small writes to files, it\'s best to set this parameter for as long as possible to avoid generating multiple notifications for the same file in a small time period.</p> <note> <p> <code>SettlingTimeInSeconds</code> has no effect on the timing of the object uploading to Amazon S3, only the timing of the notification.</p> </note> <p>The following example sets <code>NotificationPolicy</code> on with <code>SettlingTimeInSeconds</code> set to 60.</p> <p> <code>{\\"Upload\\": {\\"SettlingTimeInSeconds\\": 60}}</code> </p> <p>The following example sets <code>NotificationPolicy</code> off.</p> <p> <code>{}</code> </p>', 'SMBFileShareInfo$NotificationPolicy' => '<p>The notification policy of the file share. <code>SettlingTimeInSeconds</code> controls the number of seconds to wait after the last point in time a client wrote to a file before generating an <code>ObjectUploaded</code> notification. Because clients can make many small writes to files, it\'s best to set this parameter for as long as possible to avoid generating multiple notifications for the same file in a small time period.</p> <note> <p> <code>SettlingTimeInSeconds</code> has no effect on the timing of the object uploading to Amazon S3, only the timing of the notification.</p> </note> <p>The following example sets <code>NotificationPolicy</code> on with <code>SettlingTimeInSeconds</code> set to 60.</p> <p> <code>{\\"Upload\\": {\\"SettlingTimeInSeconds\\": 60}}</code> </p> <p>The following example sets <code>NotificationPolicy</code> off.</p> <p> <code>{}</code> </p>', 'UpdateNFSFileShareInput$NotificationPolicy' => '<p>The notification policy of the file share. <code>SettlingTimeInSeconds</code> controls the number of seconds to wait after the last point in time a client wrote to a file before generating an <code>ObjectUploaded</code> notification. Because clients can make many small writes to files, it\'s best to set this parameter for as long as possible to avoid generating multiple notifications for the same file in a small time period.</p> <note> <p> <code>SettlingTimeInSeconds</code> has no effect on the timing of the object uploading to Amazon S3, only the timing of the notification.</p> </note> <p>The following example sets <code>NotificationPolicy</code> on with <code>SettlingTimeInSeconds</code> set to 60.</p> <p> <code>{\\"Upload\\": {\\"SettlingTimeInSeconds\\": 60}}</code> </p> <p>The following example sets <code>NotificationPolicy</code> off.</p> <p> <code>{}</code> </p>', 'UpdateSMBFileShareInput$NotificationPolicy' => '<p>The notification policy of the file share. <code>SettlingTimeInSeconds</code> controls the number of seconds to wait after the last point in time a client wrote to a file before generating an <code>ObjectUploaded</code> notification. Because clients can make many small writes to files, it\'s best to set this parameter for as long as possible to avoid generating multiple notifications for the same file in a small time period.</p> <note> <p> <code>SettlingTimeInSeconds</code> has no effect on the timing of the object uploading to Amazon S3, only the timing of the notification.</p> </note> <p>The following example sets <code>NotificationPolicy</code> on with <code>SettlingTimeInSeconds</code> set to 60.</p> <p> <code>{\\"Upload\\": {\\"SettlingTimeInSeconds\\": 60}}</code> </p> <p>The following example sets <code>NotificationPolicy</code> off.</p> <p> <code>{}</code> </p>', ], ], 'NotifyWhenUploadedInput' => [ 'base' => NULL, 'refs' => [], ], 'NotifyWhenUploadedOutput' => [ 'base' => NULL, 'refs' => [], ], 'NumTapesToCreate' => [ 'base' => NULL, 'refs' => [ 'CreateTapesInput$NumTapesToCreate' => '<p>The number of virtual tapes that you want to create.</p>', ], ], 'ObjectACL' => [ 'base' => '<p>A value that sets the access control list (ACL) permission for objects in the S3 bucket that an S3 File Gateway puts objects into. The default value is <code>private</code>.</p>', 'refs' => [ 'CreateNFSFileShareInput$ObjectACL' => '<p>A value that sets the access control list (ACL) permission for objects in the S3 bucket that a S3 File Gateway puts objects into. The default value is <code>private</code>.</p>', 'CreateSMBFileShareInput$ObjectACL' => '<p>A value that sets the access control list (ACL) permission for objects in the S3 bucket that a S3 File Gateway puts objects into. The default value is <code>private</code>.</p>', 'NFSFileShareInfo$ObjectACL' => NULL, 'SMBFileShareInfo$ObjectACL' => NULL, 'UpdateNFSFileShareInput$ObjectACL' => '<p>A value that sets the access control list (ACL) permission for objects in the S3 bucket that a S3 File Gateway puts objects into. The default value is <code>private</code>.</p>', 'UpdateSMBFileShareInput$ObjectACL' => '<p>A value that sets the access control list (ACL) permission for objects in the S3 bucket that a S3 File Gateway puts objects into. The default value is <code>private</code>.</p>', ], ], 'OrganizationalUnit' => [ 'base' => NULL, 'refs' => [ 'JoinDomainInput$OrganizationalUnit' => '<p>The organizational unit (OU) is a container in an Active Directory that can hold users, groups, computers, and other OUs and this parameter specifies the OU that the gateway will join within the AD domain.</p>', ], ], 'Path' => [ 'base' => '<p>The file share path used by the NFS client to identify the mount point.</p>', 'refs' => [ 'NFSFileShareInfo$Path' => NULL, 'SMBFileShareInfo$Path' => '<p>The file share path used by the SMB client to identify the mount point.</p>', ], ], 'PermissionId' => [ 'base' => NULL, 'refs' => [ 'NFSFileShareDefaults$GroupId' => '<p>The default group ID for the file share (unless the files have another group ID specified). The default value is <code>nfsnobody</code>.</p>', 'NFSFileShareDefaults$OwnerId' => '<p>The default owner ID for files in the file share (unless the files have another owner ID specified). The default value is <code>nfsnobody</code>.</p>', ], ], 'PermissionMode' => [ 'base' => NULL, 'refs' => [ 'NFSFileShareDefaults$FileMode' => '<p>The Unix file mode in the form "nnnn". For example, <code>0666</code> represents the default file mode inside the file share. The default value is <code>0666</code>.</p>', 'NFSFileShareDefaults$DirectoryMode' => '<p>The Unix directory mode in the form "nnnn". For example, <code>0666</code> represents the default access mode for all directories inside the file share. The default value is <code>0777</code>.</p>', ], ], 'PoolARN' => [ 'base' => NULL, 'refs' => [ 'CreateTapePoolOutput$PoolARN' => '<p>The unique Amazon Resource Name (ARN) that represents the custom tape pool. Use the <a>ListTapePools</a> operation to return a list of tape pools for your account and Region.</p>', 'DeleteTapePoolInput$PoolARN' => '<p>The Amazon Resource Name (ARN) of the custom tape pool to delete.</p>', 'DeleteTapePoolOutput$PoolARN' => '<p>The Amazon Resource Name (ARN) of the custom tape pool being deleted.</p>', 'PoolARNs$member' => NULL, 'PoolInfo$PoolARN' => '<p>The Amazon Resource Name (ARN) of the custom tape pool. Use the <a>ListTapePools</a> operation to return a list of custom tape pools for your account and Region.</p>', ], ], 'PoolARNs' => [ 'base' => NULL, 'refs' => [ 'ListTapePoolsInput$PoolARNs' => '<p>The Amazon Resource Name (ARN) of each of the custom tape pools you want to list. If you don\'t specify a custom tape pool ARN, the response lists all custom tape pools. </p>', ], ], 'PoolId' => [ 'base' => NULL, 'refs' => [ 'AssignTapePoolInput$PoolId' => '<p>The ID of the pool that you want to add your tape to for archiving. The tape in this pool is archived in the S3 storage class that is associated with the pool. When you use your backup application to eject the tape, the tape is archived directly into the storage class (S3 Glacier or S3 Glacier Deep Archive) that corresponds to the pool.</p> <p>Valid Values: <code>GLACIER</code> | <code>DEEP_ARCHIVE</code> </p>', 'AutomaticTapeCreationRule$PoolId' => '<p>The ID of the pool that you want to add your tape to for archiving. The tape in this pool is archived in the Amazon S3 storage class that is associated with the pool. When you use your backup application to eject the tape, the tape is archived directly into the storage class (S3 Glacier or S3 Glacier Deep Archive) that corresponds to the pool.</p> <p>Valid Values: <code>GLACIER</code> | <code>DEEP_ARCHIVE</code> </p>', 'CreateTapeWithBarcodeInput$PoolId' => '<p>The ID of the pool that you want to add your tape to for archiving. The tape in this pool is archived in the S3 storage class that is associated with the pool. When you use your backup application to eject the tape, the tape is archived directly into the storage class (S3 Glacier or S3 Deep Archive) that corresponds to the pool.</p> <p>Valid Values: <code>GLACIER</code> | <code>DEEP_ARCHIVE</code> </p>', 'CreateTapesInput$PoolId' => '<p>The ID of the pool that you want to add your tape to for archiving. The tape in this pool is archived in the S3 storage class that is associated with the pool. When you use your backup application to eject the tape, the tape is archived directly into the storage class (S3 Glacier or S3 Glacier Deep Archive) that corresponds to the pool.</p> <p>Valid Values: <code>GLACIER</code> | <code>DEEP_ARCHIVE</code> </p>', 'Tape$PoolId' => '<p>The ID of the pool that contains tapes that will be archived. The tapes in this pool are archived in the S3 storage class that is associated with the pool. When you use your backup application to eject the tape, the tape is archived directly into the storage class (S3 Glacier or S3 Glacier Deep Archive) that corresponds to the pool.</p> <p>Valid Values: <code>GLACIER</code> | <code>DEEP_ARCHIVE</code> </p>', 'TapeArchive$PoolId' => '<p>The ID of the pool that was used to archive the tape. The tapes in this pool are archived in the S3 storage class that is associated with the pool.</p> <p>Valid Values: <code>GLACIER</code> | <code>DEEP_ARCHIVE</code> </p>', 'TapeInfo$PoolId' => '<p>The ID of the pool that you want to add your tape to for archiving. The tape in this pool is archived in the S3 storage class that is associated with the pool. When you use your backup application to eject the tape, the tape is archived directly into the storage class (S3 Glacier or S3 Glacier Deep Archive) that corresponds to the pool.</p> <p>Valid Values: <code>GLACIER</code> | <code>DEEP_ARCHIVE</code> </p>', ], ], 'PoolInfo' => [ 'base' => '<p>Describes a custom tape pool.</p>', 'refs' => [ 'PoolInfos$member' => NULL, ], ], 'PoolInfos' => [ 'base' => NULL, 'refs' => [ 'ListTapePoolsOutput$PoolInfos' => '<p>An array of <code>PoolInfo</code> objects, where each object describes a single custom tape pool. If there are no custom tape pools, the <code>PoolInfos</code> is an empty array. </p>', ], ], 'PoolName' => [ 'base' => NULL, 'refs' => [ 'CreateTapePoolInput$PoolName' => '<p>The name of the new custom tape pool.</p>', 'PoolInfo$PoolName' => '<p>The name of the custom tape pool. <code>PoolName</code> can use all ASCII characters, except \'/\' and \'\\\'.</p>', ], ], 'PoolStatus' => [ 'base' => NULL, 'refs' => [ 'PoolInfo$PoolStatus' => '<p>Status of the custom tape pool. Pool can be <code>ACTIVE</code> or <code>DELETED</code>.</p>', ], ], 'PositiveIntObject' => [ 'base' => NULL, 'refs' => [ 'DescribeTapeArchivesInput$Limit' => '<p>Specifies that the number of virtual tapes described be limited to the specified number.</p>', 'DescribeTapeRecoveryPointsInput$Limit' => '<p>Specifies that the number of virtual tape recovery points that are described be limited to the specified number.</p>', 'DescribeTapesInput$Limit' => '<p>Specifies that the number of virtual tapes described be limited to the specified number.</p> <note> <p>Amazon Web Services may impose its own limit, if this field is not set.</p> </note>', 'DescribeVTLDevicesInput$Limit' => '<p>Specifies that the number of VTL devices described be limited to the specified number.</p>', 'ListFileSharesInput$Limit' => '<p>The maximum number of file shares to return in the response. The value must be an integer with a value greater than zero. Optional.</p>', 'ListFileSystemAssociationsInput$Limit' => '<p>The maximum number of file system associations to return in the response. If present, <code>Limit</code> must be an integer with a value greater than zero. Optional.</p>', 'ListGatewaysInput$Limit' => '<p>Specifies that the list of gateways returned be limited to the specified number of items.</p>', 'ListTagsForResourceInput$Limit' => '<p>Specifies that the list of tags returned be limited to the specified number of items.</p>', 'ListTapePoolsInput$Limit' => '<p>An optional number limit for the tape pools in the list returned by this call.</p>', 'ListTapesInput$Limit' => '<p>An optional number limit for the tapes in the list returned by this call.</p>', 'ListVolumesInput$Limit' => '<p>Specifies that the list of volumes returned be limited to the specified number of items.</p>', 'VolumeiSCSIAttributes$LunNumber' => '<p>The logical disk number.</p>', ], ], 'RecurrenceInHours' => [ 'base' => NULL, 'refs' => [ 'DescribeSnapshotScheduleOutput$RecurrenceInHours' => '<p>The number of hours between snapshots.</p>', 'UpdateSnapshotScheduleInput$RecurrenceInHours' => '<p>Frequency of snapshots. Specify the number of hours between snapshots.</p>', ], ], 'RefreshCacheInput' => [ 'base' => '<p>RefreshCacheInput</p>', 'refs' => [], ], 'RefreshCacheOutput' => [ 'base' => '<p>RefreshCacheOutput</p>', 'refs' => [], ], 'RegionId' => [ 'base' => NULL, 'refs' => [ 'ActivateGatewayInput$GatewayRegion' => '<p>A value that indicates the Region where you want to store your data. The gateway Region specified must be the same Region as the Region in your <code>Host</code> header in the request. For more information about available Regions and endpoints for Storage Gateway, see <a href="https://docs.aws.amazon.com/general/latest/gr/sg.html"> Storage Gateway endpoints and quotas</a> in the <i>Amazon Web Services General Reference</i>.</p> <p>Valid Values: See <a href="https://docs.aws.amazon.com/general/latest/gr/sg.html"> Storage Gateway endpoints and quotas</a> in the <i>Amazon Web Services General Reference</i>. </p>', 'CreateNFSFileShareInput$BucketRegion' => '<p>Specifies the Region of the S3 bucket where the NFS file share stores files.</p> <note> <p>This parameter is required for NFS file shares that connect to Amazon S3 through a VPC endpoint, a VPC access point, or an access point alias that points to a VPC access point.</p> </note>', 'CreateSMBFileShareInput$BucketRegion' => '<p>Specifies the Region of the S3 bucket where the SMB file share stores files.</p> <note> <p>This parameter is required for SMB file shares that connect to Amazon S3 through a VPC endpoint, a VPC access point, or an access point alias that points to a VPC access point.</p> </note>', 'NFSFileShareInfo$BucketRegion' => '<p>Specifies the Region of the S3 bucket where the NFS file share stores files.</p> <note> <p>This parameter is required for NFS file shares that connect to Amazon S3 through a VPC endpoint, a VPC access point, or an access point alias that points to a VPC access point.</p> </note>', 'SMBFileShareInfo$BucketRegion' => '<p>Specifies the Region of the S3 bucket where the SMB file share stores files.</p> <note> <p>This parameter is required for SMB file shares that connect to Amazon S3 through a VPC endpoint, a VPC access point, or an access point alias that points to a VPC access point.</p> </note>', ], ], 'RemoveTagsFromResourceInput' => [ 'base' => '<p>RemoveTagsFromResourceInput</p>', 'refs' => [], ], 'RemoveTagsFromResourceOutput' => [ 'base' => '<p>RemoveTagsFromResourceOutput</p>', 'refs' => [], ], 'ResetCacheInput' => [ 'base' => NULL, 'refs' => [], ], 'ResetCacheOutput' => [ 'base' => NULL, 'refs' => [], ], 'ResourceARN' => [ 'base' => NULL, 'refs' => [ 'AddTagsToResourceInput$ResourceARN' => '<p>The Amazon Resource Name (ARN) of the resource you want to add tags to.</p>', 'AddTagsToResourceOutput$ResourceARN' => '<p>The Amazon Resource Name (ARN) of the resource you want to add tags to.</p>', 'ListTagsForResourceInput$ResourceARN' => '<p>The Amazon Resource Name (ARN) of the resource for which you want to list tags.</p>', 'ListTagsForResourceOutput$ResourceARN' => '<p>The Amazon Resource Name (ARN) of the resource for which you want to list tags.</p>', 'RemoveTagsFromResourceInput$ResourceARN' => '<p>The Amazon Resource Name (ARN) of the resource you want to remove the tags from.</p>', 'RemoveTagsFromResourceOutput$ResourceARN' => '<p>The Amazon Resource Name (ARN) of the resource that the tags were removed from.</p>', ], ], 'RetentionLockTimeInDays' => [ 'base' => NULL, 'refs' => [ 'CreateTapePoolInput$RetentionLockTimeInDays' => '<p>Tape retention lock time is set in days. Tape retention lock can be enabled for up to 100 years (36,500 days).</p>', 'PoolInfo$RetentionLockTimeInDays' => '<p>Tape retention lock time is set in days. Tape retention lock can be enabled for up to 100 years (36,500 days).</p>', ], ], 'RetentionLockType' => [ 'base' => NULL, 'refs' => [ 'CreateTapePoolInput$RetentionLockType' => '<p>Tape retention lock can be configured in two modes. When configured in governance mode, accounts with specific IAM permissions are authorized to remove the tape retention lock from archived virtual tapes. When configured in compliance mode, the tape retention lock cannot be removed by any user, including the root account.</p>', 'PoolInfo$RetentionLockType' => '<p>Tape retention lock type, which can be configured in two modes. When configured in governance mode, accounts with specific IAM permissions are authorized to remove the tape retention lock from archived virtual tapes. When configured in compliance mode, the tape retention lock cannot be removed by any user, including the root account.</p>', ], ], 'RetrieveTapeArchiveInput' => [ 'base' => '<p>RetrieveTapeArchiveInput</p>', 'refs' => [], ], 'RetrieveTapeArchiveOutput' => [ 'base' => '<p>RetrieveTapeArchiveOutput</p>', 'refs' => [], ], 'RetrieveTapeRecoveryPointInput' => [ 'base' => '<p>RetrieveTapeRecoveryPointInput</p>', 'refs' => [], ], 'RetrieveTapeRecoveryPointOutput' => [ 'base' => '<p>RetrieveTapeRecoveryPointOutput</p>', 'refs' => [], ], 'Role' => [ 'base' => '<p>The ARN of the IAM role that an S3 File Gateway assumes when it accesses the underlying storage.</p>', 'refs' => [ 'CreateNFSFileShareInput$Role' => '<p>The ARN of the Identity and Access Management (IAM) role that an S3 File Gateway assumes when it accesses the underlying storage.</p>', 'CreateSMBFileShareInput$Role' => '<p>The ARN of the Identity and Access Management (IAM) role that an S3 File Gateway assumes when it accesses the underlying storage.</p>', 'NFSFileShareInfo$Role' => NULL, 'SMBFileShareInfo$Role' => NULL, ], ], 'SMBFileShareInfo' => [ 'base' => '<p>The Windows file permissions and ownership information assigned, by default, to native S3 objects when S3 File Gateway discovers them in S3 buckets. This operation is only supported for S3 File Gateways.</p>', 'refs' => [ 'SMBFileShareInfoList$member' => NULL, ], ], 'SMBFileShareInfoList' => [ 'base' => NULL, 'refs' => [ 'DescribeSMBFileSharesOutput$SMBFileShareInfoList' => '<p>An array containing a description for each requested file share.</p>', ], ], 'SMBGuestPassword' => [ 'base' => NULL, 'refs' => [ 'SetSMBGuestPasswordInput$Password' => '<p>The password that you want to set for your SMB server.</p>', ], ], 'SMBSecurityStrategy' => [ 'base' => NULL, 'refs' => [ 'DescribeSMBSettingsOutput$SMBSecurityStrategy' => '<p>The type of security strategy that was specified for file gateway.</p> <ul> <li> <p> <code>ClientSpecified</code>: If you use this option, requests are established based on what is negotiated by the client. This option is recommended when you want to maximize compatibility across different clients in your environment. Only supported for S3 File Gateways.</p> </li> <li> <p> <code>MandatorySigning</code>: If you use this option, file gateway only allows connections from SMBv2 or SMBv3 clients that have signing enabled. This option works with SMB clients on Microsoft Windows Vista, Windows Server 2008 or newer.</p> </li> <li> <p> <code>MandatoryEncryption</code>: If you use this option, file gateway only allows connections from SMBv3 clients that have encryption enabled. This option is highly recommended for environments that handle sensitive data. This option works with SMB clients on Microsoft Windows 8, Windows Server 2012 or newer.</p> </li> </ul>', 'UpdateSMBSecurityStrategyInput$SMBSecurityStrategy' => '<p>Specifies the type of security strategy.</p> <p>ClientSpecified: if you use this option, requests are established based on what is negotiated by the client. This option is recommended when you want to maximize compatibility across different clients in your environment. Supported only in S3 File Gateway.</p> <p>MandatorySigning: if you use this option, file gateway only allows connections from SMBv2 or SMBv3 clients that have signing enabled. This option works with SMB clients on Microsoft Windows Vista, Windows Server 2008 or newer.</p> <p>MandatoryEncryption: if you use this option, file gateway only allows connections from SMBv3 clients that have encryption enabled. This option is highly recommended for environments that handle sensitive data. This option works with SMB clients on Microsoft Windows 8, Windows Server 2012 or newer.</p>', ], ], 'ServiceUnavailableError' => [ 'base' => '<p>An internal server error has occurred because the service is unavailable. For more information, see the error and message fields.</p>', 'refs' => [], ], 'SetLocalConsolePasswordInput' => [ 'base' => '<p>SetLocalConsolePasswordInput</p>', 'refs' => [], ], 'SetLocalConsolePasswordOutput' => [ 'base' => NULL, 'refs' => [], ], 'SetSMBGuestPasswordInput' => [ 'base' => '<p>SetSMBGuestPasswordInput</p>', 'refs' => [], ], 'SetSMBGuestPasswordOutput' => [ 'base' => NULL, 'refs' => [], ], 'ShutdownGatewayInput' => [ 'base' => '<p>A JSON object containing the Amazon Resource Name (ARN) of the gateway to shut down.</p>', 'refs' => [], ], 'ShutdownGatewayOutput' => [ 'base' => '<p>A JSON object containing the Amazon Resource Name (ARN) of the gateway that was shut down.</p>', 'refs' => [], ], 'SnapshotDescription' => [ 'base' => NULL, 'refs' => [ 'CreateSnapshotFromVolumeRecoveryPointInput$SnapshotDescription' => '<p>Textual description of the snapshot that appears in the Amazon EC2 console, Elastic Block Store snapshots panel in the <b>Description</b> field, and in the Storage Gateway snapshot <b>Details</b> pane, <b>Description</b> field.</p>', 'CreateSnapshotInput$SnapshotDescription' => '<p>Textual description of the snapshot that appears in the Amazon EC2 console, Elastic Block Store snapshots panel in the <b>Description</b> field, and in the Storage Gateway snapshot <b>Details</b> pane, <b>Description</b> field.</p>', ], ], 'SnapshotId' => [ 'base' => NULL, 'refs' => [ 'CachediSCSIVolume$SourceSnapshotId' => '<p>If the cached volume was created from a snapshot, this field contains the snapshot ID used, e.g., snap-78e22663. Otherwise, this field is not included.</p>', 'CreateCachediSCSIVolumeInput$SnapshotId' => '<p>The snapshot ID (e.g. "snap-1122aabb") of the snapshot to restore as the new cached volume. Specify this field if you want to create the iSCSI storage volume from a snapshot; otherwise, do not include this field. To list snapshots for your account use <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/ApiReference-query-DescribeSnapshots.html">DescribeSnapshots</a> in the <i>Amazon Elastic Compute Cloud API Reference</i>.</p>', 'CreateSnapshotFromVolumeRecoveryPointOutput$SnapshotId' => '<p>The ID of the snapshot.</p>', 'CreateSnapshotOutput$SnapshotId' => '<p>The snapshot ID that is used to refer to the snapshot in future operations such as describing snapshots (Amazon Elastic Compute Cloud API <code>DescribeSnapshots</code>) or creating a volume from a snapshot (<a>CreateStorediSCSIVolume</a>).</p>', 'CreateStorediSCSIVolumeInput$SnapshotId' => '<p>The snapshot ID (e.g., "snap-1122aabb") of the snapshot to restore as the new stored volume. Specify this field if you want to create the iSCSI storage volume from a snapshot; otherwise, do not include this field. To list snapshots for your account use <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/ApiReference-query-DescribeSnapshots.html">DescribeSnapshots</a> in the <i>Amazon Elastic Compute Cloud API Reference</i>.</p>', 'StorediSCSIVolume$SourceSnapshotId' => '<p>If the stored volume was created from a snapshot, this field contains the snapshot ID used, e.g. snap-78e22663. Otherwise, this field is not included.</p>', ], ], 'SoftwareUpdatesEndDate' => [ 'base' => NULL, 'refs' => [ 'DescribeGatewayInformationOutput$SoftwareUpdatesEndDate' => '<p>Date after which this gateway will not receive software updates for new features.</p>', ], ], 'Squash' => [ 'base' => '<p>The user mapped to anonymous user. Valid options are the following:</p> <ul> <li> <p> <code>RootSquash</code>: Only root is mapped to anonymous user.</p> </li> <li> <p> <code>NoSquash</code>: No one is mapped to anonymous user.</p> </li> <li> <p> <code>AllSquash</code>: Everyone is mapped to anonymous user.</p> </li> </ul>', 'refs' => [ 'CreateNFSFileShareInput$Squash' => '<p>A value that maps a user to anonymous user.</p> <p>Valid values are the following:</p> <ul> <li> <p> <code>RootSquash</code>: Only root is mapped to anonymous user.</p> </li> <li> <p> <code>NoSquash</code>: No one is mapped to anonymous user.</p> </li> <li> <p> <code>AllSquash</code>: Everyone is mapped to anonymous user.</p> </li> </ul>', 'NFSFileShareInfo$Squash' => NULL, 'UpdateNFSFileShareInput$Squash' => '<p>The user mapped to anonymous user.</p> <p>Valid values are the following:</p> <ul> <li> <p> <code>RootSquash</code>: Only root is mapped to anonymous user.</p> </li> <li> <p> <code>NoSquash</code>: No one is mapped to anonymous user.</p> </li> <li> <p> <code>AllSquash</code>: Everyone is mapped to anonymous user.</p> </li> </ul>', ], ], 'StartAvailabilityMonitorTestInput' => [ 'base' => NULL, 'refs' => [], ], 'StartAvailabilityMonitorTestOutput' => [ 'base' => NULL, 'refs' => [], ], 'StartGatewayInput' => [ 'base' => '<p>A JSON object containing the Amazon Resource Name (ARN) of the gateway to start.</p>', 'refs' => [], ], 'StartGatewayOutput' => [ 'base' => '<p>A JSON object containing the Amazon Resource Name (ARN) of the gateway that was restarted.</p>', 'refs' => [], ], 'StorageClass' => [ 'base' => '<p/>', 'refs' => [ 'CreateNFSFileShareInput$DefaultStorageClass' => '<p>The default storage class for objects put into an Amazon S3 bucket by the S3 File Gateway. The default value is <code>S3_INTELLIGENT_TIERING</code>. Optional.</p> <p>Valid Values: <code>S3_STANDARD</code> | <code>S3_INTELLIGENT_TIERING</code> | <code>S3_STANDARD_IA</code> | <code>S3_ONEZONE_IA</code> </p>', 'CreateSMBFileShareInput$DefaultStorageClass' => '<p>The default storage class for objects put into an Amazon S3 bucket by the S3 File Gateway. The default value is <code>S3_INTELLIGENT_TIERING</code>. Optional.</p> <p>Valid Values: <code>S3_STANDARD</code> | <code>S3_INTELLIGENT_TIERING</code> | <code>S3_STANDARD_IA</code> | <code>S3_ONEZONE_IA</code> </p>', 'NFSFileShareInfo$DefaultStorageClass' => '<p>The default storage class for objects put into an Amazon S3 bucket by the S3 File Gateway. The default value is <code>S3_INTELLIGENT_TIERING</code>. Optional.</p> <p>Valid Values: <code>S3_STANDARD</code> | <code>S3_INTELLIGENT_TIERING</code> | <code>S3_STANDARD_IA</code> | <code>S3_ONEZONE_IA</code> </p>', 'SMBFileShareInfo$DefaultStorageClass' => '<p>The default storage class for objects put into an Amazon S3 bucket by the S3 File Gateway. The default value is <code>S3_INTELLIGENT_TIERING</code>. Optional.</p> <p>Valid Values: <code>S3_STANDARD</code> | <code>S3_INTELLIGENT_TIERING</code> | <code>S3_STANDARD_IA</code> | <code>S3_ONEZONE_IA</code> </p>', 'UpdateNFSFileShareInput$DefaultStorageClass' => '<p>The default storage class for objects put into an Amazon S3 bucket by the S3 File Gateway. The default value is <code>S3_INTELLIGENT_TIERING</code>. Optional.</p> <p>Valid Values: <code>S3_STANDARD</code> | <code>S3_INTELLIGENT_TIERING</code> | <code>S3_STANDARD_IA</code> | <code>S3_ONEZONE_IA</code> </p>', 'UpdateSMBFileShareInput$DefaultStorageClass' => '<p>The default storage class for objects put into an Amazon S3 bucket by the S3 File Gateway. The default value is <code>S3_INTELLIGENT_TIERING</code>. Optional.</p> <p>Valid Values: <code>S3_STANDARD</code> | <code>S3_INTELLIGENT_TIERING</code> | <code>S3_STANDARD_IA</code> | <code>S3_ONEZONE_IA</code> </p>', ], ], 'StorageGatewayError' => [ 'base' => '<p>Provides additional information about an error that was returned by the service. See the <code>errorCode</code> and <code>errorDetails</code> members for more information about the error.</p>', 'refs' => [ 'InternalServerError$error' => '<p>A <a>StorageGatewayError</a> that provides more information about the cause of the error.</p>', 'InvalidGatewayRequestException$error' => '<p>A <a>StorageGatewayError</a> that provides more detail about the cause of the error.</p>', 'ServiceUnavailableError$error' => '<p>A <a>StorageGatewayError</a> that provides more information about the cause of the error.</p>', ], ], 'StorediSCSIVolume' => [ 'base' => '<p>Describes an iSCSI stored volume.</p>', 'refs' => [ 'StorediSCSIVolumes$member' => NULL, ], ], 'StorediSCSIVolumes' => [ 'base' => NULL, 'refs' => [ 'DescribeStorediSCSIVolumesOutput$StorediSCSIVolumes' => '<p>Describes a single unit of output from <a>DescribeStorediSCSIVolumes</a>. The following fields are returned:</p> <ul> <li> <p> <code>ChapEnabled</code>: Indicates whether mutual CHAP is enabled for the iSCSI target.</p> </li> <li> <p> <code>LunNumber</code>: The logical disk number.</p> </li> <li> <p> <code>NetworkInterfaceId</code>: The network interface ID of the stored volume that initiator use to map the stored volume as an iSCSI target.</p> </li> <li> <p> <code>NetworkInterfacePort</code>: The port used to communicate with iSCSI targets.</p> </li> <li> <p> <code>PreservedExistingData</code>: Indicates when the stored volume was created, existing data on the underlying local disk was preserved.</p> </li> <li> <p> <code>SourceSnapshotId</code>: If the stored volume was created from a snapshot, this field contains the snapshot ID used, e.g. <code>snap-1122aabb</code>. Otherwise, this field is not included.</p> </li> <li> <p> <code>StorediSCSIVolumes</code>: An array of StorediSCSIVolume objects where each object contains metadata about one stored volume.</p> </li> <li> <p> <code>TargetARN</code>: The Amazon Resource Name (ARN) of the volume target.</p> </li> <li> <p> <code>VolumeARN</code>: The Amazon Resource Name (ARN) of the stored volume.</p> </li> <li> <p> <code>VolumeDiskId</code>: The disk ID of the local disk that was specified in the <a>CreateStorediSCSIVolume</a> operation.</p> </li> <li> <p> <code>VolumeId</code>: The unique identifier of the storage volume, e.g. <code>vol-1122AABB</code>.</p> </li> <li> <p> <code>VolumeiSCSIAttributes</code>: An <a>VolumeiSCSIAttributes</a> object that represents a collection of iSCSI attributes for one stored volume.</p> </li> <li> <p> <code>VolumeProgress</code>: Represents the percentage complete if the volume is restoring or bootstrapping that represents the percent of data transferred. This field does not appear in the response if the stored volume is not restoring or bootstrapping.</p> </li> <li> <p> <code>VolumeSizeInBytes</code>: The size of the volume in bytes.</p> </li> <li> <p> <code>VolumeStatus</code>: One of the <code>VolumeStatus</code> values that indicates the state of the volume.</p> </li> <li> <p> <code>VolumeType</code>: One of the enumeration values describing the type of the volume. Currently, only <code>STORED</code> volumes are supported.</p> </li> </ul>', ], ], 'SupportedGatewayCapacities' => [ 'base' => NULL, 'refs' => [ 'DescribeGatewayInformationOutput$SupportedGatewayCapacities' => '<p>A list of the metadata cache sizes that the gateway can support based on its current hardware specifications.</p>', ], ], 'Tag' => [ 'base' => '<p>A key-value pair that helps you manage, filter, and search for your resource. Allowed characters: letters, white space, and numbers, representable in UTF-8, and the following characters: + - = . _ : /.</p>', 'refs' => [ 'Tags$member' => NULL, ], ], 'TagKey' => [ 'base' => NULL, 'refs' => [ 'Tag$Key' => '<p>Tag key. The key can\'t start with aws:.</p>', 'TagKeys$member' => NULL, ], ], 'TagKeys' => [ 'base' => NULL, 'refs' => [ 'RemoveTagsFromResourceInput$TagKeys' => '<p>The keys of the tags you want to remove from the specified resource. A tag is composed of a key-value pair.</p>', ], ], 'TagValue' => [ 'base' => NULL, 'refs' => [ 'Tag$Value' => '<p>Value of the tag key.</p>', ], ], 'Tags' => [ 'base' => NULL, 'refs' => [ 'ActivateGatewayInput$Tags' => '<p>A list of up to 50 tags that you can assign to the gateway. Each tag is a key-value pair.</p> <note> <p>Valid characters for key and value are letters, spaces, and numbers that can be represented in UTF-8 format, and the following special characters: + - = . _ : / @. The maximum length of a tag\'s key is 128 characters, and the maximum length for a tag\'s value is 256 characters.</p> </note>', 'AddTagsToResourceInput$Tags' => '<p>The key-value pair that represents the tag you want to add to the resource. The value can be an empty string.</p> <note> <p>Valid characters for key and value are letters, spaces, and numbers representable in UTF-8 format, and the following special characters: + - = . _ : / @. The maximum length of a tag\'s key is 128 characters, and the maximum length for a tag\'s value is 256.</p> </note>', 'AssociateFileSystemInput$Tags' => '<p>A list of up to 50 tags that can be assigned to the file system association. Each tag is a key-value pair.</p>', 'CreateCachediSCSIVolumeInput$Tags' => '<p>A list of up to 50 tags that you can assign to a cached volume. Each tag is a key-value pair.</p> <note> <p>Valid characters for key and value are letters, spaces, and numbers that you can represent in UTF-8 format, and the following special characters: + - = . _ : / @. The maximum length of a tag\'s key is 128 characters, and the maximum length for a tag\'s value is 256 characters.</p> </note>', 'CreateNFSFileShareInput$Tags' => '<p>A list of up to 50 tags that can be assigned to the NFS file share. Each tag is a key-value pair.</p> <note> <p>Valid characters for key and value are letters, spaces, and numbers representable in UTF-8 format, and the following special characters: + - = . _ : / @. The maximum length of a tag\'s key is 128 characters, and the maximum length for a tag\'s value is 256.</p> </note>', 'CreateSMBFileShareInput$Tags' => '<p>A list of up to 50 tags that can be assigned to the NFS file share. Each tag is a key-value pair.</p> <note> <p>Valid characters for key and value are letters, spaces, and numbers representable in UTF-8 format, and the following special characters: + - = . _ : / @. The maximum length of a tag\'s key is 128 characters, and the maximum length for a tag\'s value is 256.</p> </note>', 'CreateSnapshotFromVolumeRecoveryPointInput$Tags' => '<p>A list of up to 50 tags that can be assigned to a snapshot. Each tag is a key-value pair.</p> <note> <p>Valid characters for key and value are letters, spaces, and numbers representable in UTF-8 format, and the following special characters: + - = . _ : / @. The maximum length of a tag\'s key is 128 characters, and the maximum length for a tag\'s value is 256.</p> </note>', 'CreateSnapshotInput$Tags' => '<p>A list of up to 50 tags that can be assigned to a snapshot. Each tag is a key-value pair.</p> <note> <p>Valid characters for key and value are letters, spaces, and numbers representable in UTF-8 format, and the following special characters: + - = . _ : / @. The maximum length of a tag\'s key is 128 characters, and the maximum length for a tag\'s value is 256.</p> </note>', 'CreateStorediSCSIVolumeInput$Tags' => '<p>A list of up to 50 tags that can be assigned to a stored volume. Each tag is a key-value pair.</p> <note> <p>Valid characters for key and value are letters, spaces, and numbers representable in UTF-8 format, and the following special characters: + - = . _ : / @. The maximum length of a tag\'s key is 128 characters, and the maximum length for a tag\'s value is 256.</p> </note>', 'CreateTapePoolInput$Tags' => '<p>A list of up to 50 tags that can be assigned to tape pool. Each tag is a key-value pair.</p> <note> <p>Valid characters for key and value are letters, spaces, and numbers representable in UTF-8 format, and the following special characters: + - = . _ : / @. The maximum length of a tag\'s key is 128 characters, and the maximum length for a tag\'s value is 256.</p> </note>', 'CreateTapeWithBarcodeInput$Tags' => '<p>A list of up to 50 tags that can be assigned to a virtual tape that has a barcode. Each tag is a key-value pair.</p> <note> <p>Valid characters for key and value are letters, spaces, and numbers representable in UTF-8 format, and the following special characters: + - = . _ : / @. The maximum length of a tag\'s key is 128 characters, and the maximum length for a tag\'s value is 256.</p> </note>', 'CreateTapesInput$Tags' => '<p>A list of up to 50 tags that can be assigned to a virtual tape. Each tag is a key-value pair.</p> <note> <p>Valid characters for key and value are letters, spaces, and numbers representable in UTF-8 format, and the following special characters: + - = . _ : / @. The maximum length of a tag\'s key is 128 characters, and the maximum length for a tag\'s value is 256.</p> </note>', 'DescribeGatewayInformationOutput$Tags' => '<p>A list of up to 50 tags assigned to the gateway, sorted alphabetically by key name. Each tag is a key-value pair. For a gateway with more than 10 tags assigned, you can view all tags using the <code>ListTagsForResource</code> API operation.</p>', 'DescribeSnapshotScheduleOutput$Tags' => '<p>A list of up to 50 tags assigned to the snapshot schedule, sorted alphabetically by key name. Each tag is a key-value pair. For a gateway with more than 10 tags assigned, you can view all tags using the <code>ListTagsForResource</code> API operation.</p>', 'FileSystemAssociationInfo$Tags' => '<p>A list of up to 50 tags assigned to the SMB file share, sorted alphabetically by key name. Each tag is a key-value pair.</p>', 'ListTagsForResourceOutput$Tags' => '<p>An array that contains the tags for the specified resource.</p>', 'NFSFileShareInfo$Tags' => '<p>A list of up to 50 tags assigned to the NFS file share, sorted alphabetically by key name. Each tag is a key-value pair. For a gateway with more than 10 tags assigned, you can view all tags using the <code>ListTagsForResource</code> API operation.</p>', 'SMBFileShareInfo$Tags' => '<p>A list of up to 50 tags assigned to the SMB file share, sorted alphabetically by key name. Each tag is a key-value pair. For a gateway with more than 10 tags assigned, you can view all tags using the <code>ListTagsForResource</code> API operation.</p>', 'UpdateSnapshotScheduleInput$Tags' => '<p>A list of up to 50 tags that can be assigned to a snapshot. Each tag is a key-value pair.</p> <note> <p>Valid characters for key and value are letters, spaces, and numbers representable in UTF-8 format, and the following special characters: + - = . _ : / @. The maximum length of a tag\'s key is 128 characters, and the maximum length for a tag\'s value is 256.</p> </note>', ], ], 'Tape' => [ 'base' => '<p>Describes a virtual tape object.</p>', 'refs' => [ 'Tapes$member' => NULL, ], ], 'TapeARN' => [ 'base' => NULL, 'refs' => [ 'AssignTapePoolInput$TapeARN' => '<p>The unique Amazon Resource Name (ARN) of the virtual tape that you want to add to the tape pool.</p>', 'AssignTapePoolOutput$TapeARN' => '<p>The unique Amazon Resource Names (ARN) of the virtual tape that was added to the tape pool.</p>', 'CancelArchivalInput$TapeARN' => '<p>The Amazon Resource Name (ARN) of the virtual tape you want to cancel archiving for.</p>', 'CancelArchivalOutput$TapeARN' => '<p>The Amazon Resource Name (ARN) of the virtual tape for which archiving was canceled.</p>', 'CancelRetrievalInput$TapeARN' => '<p>The Amazon Resource Name (ARN) of the virtual tape you want to cancel retrieval for.</p>', 'CancelRetrievalOutput$TapeARN' => '<p>The Amazon Resource Name (ARN) of the virtual tape for which retrieval was canceled.</p>', 'CreateTapeWithBarcodeOutput$TapeARN' => '<p>A unique Amazon Resource Name (ARN) that represents the virtual tape that was created.</p>', 'DeleteTapeArchiveInput$TapeARN' => '<p>The Amazon Resource Name (ARN) of the virtual tape to delete from the virtual tape shelf (VTS).</p>', 'DeleteTapeArchiveOutput$TapeARN' => '<p>The Amazon Resource Name (ARN) of the virtual tape that was deleted from the virtual tape shelf (VTS).</p>', 'DeleteTapeInput$TapeARN' => '<p>The Amazon Resource Name (ARN) of the virtual tape to delete.</p>', 'DeleteTapeOutput$TapeARN' => '<p>The Amazon Resource Name (ARN) of the deleted virtual tape.</p>', 'RetrieveTapeArchiveInput$TapeARN' => '<p>The Amazon Resource Name (ARN) of the virtual tape you want to retrieve from the virtual tape shelf (VTS).</p>', 'RetrieveTapeArchiveOutput$TapeARN' => '<p>The Amazon Resource Name (ARN) of the retrieved virtual tape.</p>', 'RetrieveTapeRecoveryPointInput$TapeARN' => '<p>The Amazon Resource Name (ARN) of the virtual tape for which you want to retrieve the recovery point.</p>', 'RetrieveTapeRecoveryPointOutput$TapeARN' => '<p>The Amazon Resource Name (ARN) of the virtual tape for which the recovery point was retrieved.</p>', 'Tape$TapeARN' => '<p>The Amazon Resource Name (ARN) of the virtual tape.</p>', 'TapeARNs$member' => NULL, 'TapeArchive$TapeARN' => '<p>The Amazon Resource Name (ARN) of an archived virtual tape.</p>', 'TapeInfo$TapeARN' => '<p>The Amazon Resource Name (ARN) of a virtual tape.</p>', 'TapeRecoveryPointInfo$TapeARN' => '<p>The Amazon Resource Name (ARN) of the virtual tape.</p>', ], ], 'TapeARNs' => [ 'base' => '<p>The Amazon Resource Name (ARN) of each of the tapes you want to list. If you don\'t specify a tape ARN, the response lists all tapes in both your VTL and VTS.</p>', 'refs' => [ 'CreateTapesOutput$TapeARNs' => '<p>A list of unique Amazon Resource Names (ARNs) that represents the virtual tapes that were created.</p>', 'DescribeTapeArchivesInput$TapeARNs' => '<p>Specifies one or more unique Amazon Resource Names (ARNs) that represent the virtual tapes you want to describe.</p>', 'DescribeTapesInput$TapeARNs' => '<p>Specifies one or more unique Amazon Resource Names (ARNs) that represent the virtual tapes you want to describe. If this parameter is not specified, Tape gateway returns a description of all virtual tapes associated with the specified gateway.</p>', 'ListTapesInput$TapeARNs' => NULL, ], ], 'TapeArchive' => [ 'base' => '<p>Represents a virtual tape that is archived in the virtual tape shelf (VTS).</p>', 'refs' => [ 'TapeArchives$member' => NULL, ], ], 'TapeArchiveStatus' => [ 'base' => NULL, 'refs' => [ 'TapeArchive$TapeStatus' => '<p>The current state of the archived virtual tape.</p>', ], ], 'TapeArchives' => [ 'base' => NULL, 'refs' => [ 'DescribeTapeArchivesOutput$TapeArchives' => '<p>An array of virtual tape objects in the virtual tape shelf (VTS). The description includes of the Amazon Resource Name (ARN) of the virtual tapes. The information returned includes the Amazon Resource Names (ARNs) of the tapes, size of the tapes, status of the tapes, progress of the description, and tape barcode.</p>', ], ], 'TapeBarcode' => [ 'base' => NULL, 'refs' => [ 'CreateTapeWithBarcodeInput$TapeBarcode' => '<p>The barcode that you want to assign to the tape.</p> <note> <p>Barcodes cannot be reused. This includes barcodes used for tapes that have been deleted.</p> </note>', 'Tape$TapeBarcode' => '<p>The barcode that identifies a specific virtual tape.</p>', 'TapeArchive$TapeBarcode' => '<p>The barcode that identifies the archived virtual tape.</p>', 'TapeInfo$TapeBarcode' => '<p>The barcode that identifies a specific virtual tape.</p>', ], ], 'TapeBarcodePrefix' => [ 'base' => NULL, 'refs' => [ 'AutomaticTapeCreationRule$TapeBarcodePrefix' => '<p>A prefix that you append to the barcode of the virtual tape that you are creating. This prefix makes the barcode unique.</p> <note> <p>The prefix must be 1-4 characters in length and must be one of the uppercase letters from A to Z.</p> </note>', 'CreateTapesInput$TapeBarcodePrefix' => '<p>A prefix that you append to the barcode of the virtual tape you are creating. This prefix makes the barcode unique.</p> <note> <p>The prefix must be 1-4 characters in length and must be one of the uppercase letters from A to Z.</p> </note>', ], ], 'TapeDriveType' => [ 'base' => NULL, 'refs' => [ 'ActivateGatewayInput$TapeDriveType' => '<p>The value that indicates the type of tape drive to use for tape gateway. This field is optional.</p> <p>Valid Values: <code>IBM-ULT3580-TD5</code> </p>', ], ], 'TapeInfo' => [ 'base' => '<p>Describes a virtual tape.</p>', 'refs' => [ 'TapeInfos$member' => NULL, ], ], 'TapeInfos' => [ 'base' => '<p>An array of <a>TapeInfo</a> objects, where each object describes a single tape. If there are no tapes in the tape library or VTS, then the <code>TapeInfos</code> is an empty array.</p>', 'refs' => [ 'ListTapesOutput$TapeInfos' => NULL, ], ], 'TapeRecoveryPointInfo' => [ 'base' => '<p>Describes a recovery point.</p>', 'refs' => [ 'TapeRecoveryPointInfos$member' => NULL, ], ], 'TapeRecoveryPointInfos' => [ 'base' => NULL, 'refs' => [ 'DescribeTapeRecoveryPointsOutput$TapeRecoveryPointInfos' => '<p>An array of TapeRecoveryPointInfos that are available for the specified gateway.</p>', ], ], 'TapeRecoveryPointStatus' => [ 'base' => NULL, 'refs' => [ 'TapeRecoveryPointInfo$TapeStatus' => '<p>The status of the virtual tapes.</p>', ], ], 'TapeSize' => [ 'base' => NULL, 'refs' => [ 'AutomaticTapeCreationRule$TapeSizeInBytes' => '<p>The size, in bytes, of the virtual tape capacity.</p>', 'CreateTapeWithBarcodeInput$TapeSizeInBytes' => '<p>The size, in bytes, of the virtual tape that you want to create.</p> <note> <p>The size must be aligned by gigabyte (1024*1024*1024 bytes).</p> </note>', 'CreateTapesInput$TapeSizeInBytes' => '<p>The size, in bytes, of the virtual tapes that you want to create.</p> <note> <p>The size must be aligned by gigabyte (1024*1024*1024 bytes).</p> </note>', 'Tape$TapeSizeInBytes' => '<p>The size, in bytes, of the virtual tape capacity.</p>', 'TapeArchive$TapeSizeInBytes' => '<p>The size, in bytes, of the archived virtual tape.</p>', 'TapeInfo$TapeSizeInBytes' => '<p>The size, in bytes, of a virtual tape.</p>', 'TapeRecoveryPointInfo$TapeSizeInBytes' => '<p>The size, in bytes, of the virtual tapes to recover.</p>', ], ], 'TapeStatus' => [ 'base' => NULL, 'refs' => [ 'Tape$TapeStatus' => '<p>The current state of the virtual tape.</p>', 'TapeInfo$TapeStatus' => '<p>The status of the tape.</p>', ], ], 'TapeStorageClass' => [ 'base' => NULL, 'refs' => [ 'CreateTapePoolInput$StorageClass' => '<p>The storage class that is associated with the new custom pool. When you use your backup application to eject the tape, the tape is archived directly into the storage class (S3 Glacier or S3 Glacier Deep Archive) that corresponds to the pool.</p>', 'PoolInfo$StorageClass' => '<p>The storage class that is associated with the custom pool. When you use your backup application to eject the tape, the tape is archived directly into the storage class (S3 Glacier or S3 Glacier Deep Archive) that corresponds to the pool.</p>', ], ], 'TapeUsage' => [ 'base' => NULL, 'refs' => [ 'Tape$TapeUsedInBytes' => '<p>The size, in bytes, of data stored on the virtual tape.</p> <note> <p>This value is not available for tapes created prior to May 13, 2015.</p> </note>', 'TapeArchive$TapeUsedInBytes' => '<p>The size, in bytes, of data stored on the virtual tape.</p> <note> <p>This value is not available for tapes created prior to May 13, 2015.</p> </note>', ], ], 'Tapes' => [ 'base' => NULL, 'refs' => [ 'DescribeTapesOutput$Tapes' => '<p>An array of virtual tape descriptions.</p>', ], ], 'TargetARN' => [ 'base' => NULL, 'refs' => [ 'AttachVolumeOutput$TargetARN' => '<p>The Amazon Resource Name (ARN) of the volume target, which includes the iSCSI name for the initiator that was used to connect to the target.</p>', 'ChapInfo$TargetARN' => '<p>The Amazon Resource Name (ARN) of the volume.</p> <p>Valid Values: 50 to 500 lowercase letters, numbers, periods (.), and hyphens (-).</p>', 'CreateCachediSCSIVolumeOutput$TargetARN' => '<p>The Amazon Resource Name (ARN) of the volume target, which includes the iSCSI name that initiators can use to connect to the target.</p>', 'CreateStorediSCSIVolumeOutput$TargetARN' => '<p>The Amazon Resource Name (ARN) of the volume target, which includes the iSCSI name that initiators can use to connect to the target.</p>', 'DeleteChapCredentialsInput$TargetARN' => '<p>The Amazon Resource Name (ARN) of the iSCSI volume target. Use the <a>DescribeStorediSCSIVolumes</a> operation to return to retrieve the TargetARN for specified VolumeARN.</p>', 'DeleteChapCredentialsOutput$TargetARN' => '<p>The Amazon Resource Name (ARN) of the target.</p>', 'DescribeChapCredentialsInput$TargetARN' => '<p>The Amazon Resource Name (ARN) of the iSCSI volume target. Use the <a>DescribeStorediSCSIVolumes</a> operation to return to retrieve the TargetARN for specified VolumeARN.</p>', 'DeviceiSCSIAttributes$TargetARN' => '<p>Specifies the unique Amazon Resource Name (ARN) that encodes the iSCSI qualified name(iqn) of a tape drive or media changer target.</p>', 'UpdateChapCredentialsInput$TargetARN' => '<p>The Amazon Resource Name (ARN) of the iSCSI volume target. Use the <a>DescribeStorediSCSIVolumes</a> operation to return the TargetARN for specified VolumeARN.</p>', 'UpdateChapCredentialsOutput$TargetARN' => '<p>The Amazon Resource Name (ARN) of the target. This is the same target specified in the request.</p>', 'VolumeiSCSIAttributes$TargetARN' => '<p>The Amazon Resource Name (ARN) of the volume target.</p>', ], ], 'TargetName' => [ 'base' => NULL, 'refs' => [ 'AttachVolumeInput$TargetName' => '<p>The name of the iSCSI target used by an initiator to connect to a volume and used as a suffix for the target ARN. For example, specifying <code>TargetName</code> as <i>myvolume</i> results in the target ARN of <code>arn:aws:storagegateway:us-east-2:111122223333:gateway/sgw-12A3456B/target/iqn.1997-05.com.amazon:myvolume</code>. The target name must be unique across all volumes on a gateway.</p> <p>If you don\'t specify a value, Storage Gateway uses the value that was previously used for this volume as the new target name.</p>', 'CachediSCSIVolume$TargetName' => '<p>The name of the iSCSI target used by an initiator to connect to a volume and used as a suffix for the target ARN. For example, specifying <code>TargetName</code> as <i>myvolume</i> results in the target ARN of <code>arn:aws:storagegateway:us-east-2:111122223333:gateway/sgw-12A3456B/target/iqn.1997-05.com.amazon:myvolume</code>. The target name must be unique across all volumes on a gateway.</p> <p>If you don\'t specify a value, Storage Gateway uses the value that was previously used for this volume as the new target name.</p>', 'CreateCachediSCSIVolumeInput$TargetName' => '<p>The name of the iSCSI target used by an initiator to connect to a volume and used as a suffix for the target ARN. For example, specifying <code>TargetName</code> as <i>myvolume</i> results in the target ARN of <code>arn:aws:storagegateway:us-east-2:111122223333:gateway/sgw-12A3456B/target/iqn.1997-05.com.amazon:myvolume</code>. The target name must be unique across all volumes on a gateway.</p> <p>If you don\'t specify a value, Storage Gateway uses the value that was previously used for this volume as the new target name.</p>', 'CreateStorediSCSIVolumeInput$TargetName' => '<p>The name of the iSCSI target used by an initiator to connect to a volume and used as a suffix for the target ARN. For example, specifying <code>TargetName</code> as <i>myvolume</i> results in the target ARN of <code>arn:aws:storagegateway:us-east-2:111122223333:gateway/sgw-12A3456B/target/iqn.1997-05.com.amazon:myvolume</code>. The target name must be unique across all volumes on a gateway.</p> <p>If you don\'t specify a value, Storage Gateway uses the value that was previously used for this volume as the new target name.</p>', 'StorediSCSIVolume$TargetName' => '<p>The name of the iSCSI target used by an initiator to connect to a volume and used as a suffix for the target ARN. For example, specifying <code>TargetName</code> as <i>myvolume</i> results in the target ARN of <code>arn:aws:storagegateway:us-east-2:111122223333:gateway/sgw-12A3456B/target/iqn.1997-05.com.amazon:myvolume</code>. The target name must be unique across all volumes on a gateway.</p> <p>If you don\'t specify a value, Storage Gateway uses the value that was previously used for this volume as the new target name.</p>', ], ], 'Time' => [ 'base' => NULL, 'refs' => [ 'DescribeAvailabilityMonitorTestOutput$StartTime' => '<p>The time the high availability monitoring test was started. If a test hasn\'t been performed, the value of this field is null.</p>', 'Tape$TapeCreatedDate' => '<p>The date the virtual tape was created.</p>', 'Tape$RetentionStartDate' => '<p>The date that the tape is first archived with tape retention lock enabled.</p>', 'Tape$PoolEntryDate' => '<p>The date that the tape enters a custom tape pool.</p>', 'TapeArchive$TapeCreatedDate' => '<p>The date the virtual tape was created.</p>', 'TapeArchive$CompletionTime' => '<p>The time that the archiving of the virtual tape was completed.</p> <p>The default timestamp format is in the ISO8601 extended YYYY-MM-DD\'T\'HH:MM:SS\'Z\' format.</p>', 'TapeArchive$RetentionStartDate' => '<p>If the archived tape is subject to tape retention lock, the date that the archived tape started being retained.</p>', 'TapeArchive$PoolEntryDate' => '<p>The time that the tape entered the custom tape pool.</p> <p>The default timestamp format is in the ISO8601 extended YYYY-MM-DD\'T\'HH:MM:SS\'Z\' format.</p>', 'TapeInfo$RetentionStartDate' => '<p>The date that the tape became subject to tape retention lock.</p>', 'TapeInfo$PoolEntryDate' => '<p>The date that the tape entered the custom tape pool with tape retention lock enabled.</p>', 'TapeRecoveryPointInfo$TapeRecoveryPointTime' => '<p>The time when the point-in-time view of the virtual tape was replicated for later recovery.</p> <p>The default timestamp format of the tape recovery point time is in the ISO8601 extended YYYY-MM-DD\'T\'HH:MM:SS\'Z\' format.</p>', ], ], 'TimeoutInSeconds' => [ 'base' => NULL, 'refs' => [ 'JoinDomainInput$TimeoutInSeconds' => '<p>Specifies the time in seconds, in which the <code>JoinDomain</code> operation must complete. The default is 20 seconds.</p>', ], ], 'UpdateAutomaticTapeCreationPolicyInput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateAutomaticTapeCreationPolicyOutput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateBandwidthRateLimitInput' => [ 'base' => '<p>A JSON object containing one or more of the following fields:</p> <ul> <li> <p> <a>UpdateBandwidthRateLimitInput$AverageDownloadRateLimitInBitsPerSec</a> </p> </li> <li> <p> <a>UpdateBandwidthRateLimitInput$AverageUploadRateLimitInBitsPerSec</a> </p> </li> </ul>', 'refs' => [], ], 'UpdateBandwidthRateLimitOutput' => [ 'base' => '<p>A JSON object containing the Amazon Resource Name (ARN) of the gateway whose throttle information was updated.</p>', 'refs' => [], ], 'UpdateBandwidthRateLimitScheduleInput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateBandwidthRateLimitScheduleOutput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateChapCredentialsInput' => [ 'base' => '<p>A JSON object containing one or more of the following fields:</p> <ul> <li> <p> <a>UpdateChapCredentialsInput$InitiatorName</a> </p> </li> <li> <p> <a>UpdateChapCredentialsInput$SecretToAuthenticateInitiator</a> </p> </li> <li> <p> <a>UpdateChapCredentialsInput$SecretToAuthenticateTarget</a> </p> </li> <li> <p> <a>UpdateChapCredentialsInput$TargetARN</a> </p> </li> </ul>', 'refs' => [], ], 'UpdateChapCredentialsOutput' => [ 'base' => '<p>A JSON object containing the following fields:</p>', 'refs' => [], ], 'UpdateFileSystemAssociationInput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateFileSystemAssociationOutput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateGatewayInformationInput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateGatewayInformationOutput' => [ 'base' => '<p>A JSON object containing the Amazon Resource Name (ARN) of the gateway that was updated.</p>', 'refs' => [], ], 'UpdateGatewaySoftwareNowInput' => [ 'base' => '<p>A JSON object containing the Amazon Resource Name (ARN) of the gateway to update.</p>', 'refs' => [], ], 'UpdateGatewaySoftwareNowOutput' => [ 'base' => '<p>A JSON object containing the Amazon Resource Name (ARN) of the gateway that was updated.</p>', 'refs' => [], ], 'UpdateMaintenanceStartTimeInput' => [ 'base' => '<p>A JSON object containing the following fields:</p> <ul> <li> <p> <a>UpdateMaintenanceStartTimeInput$DayOfMonth</a> </p> </li> <li> <p> <a>UpdateMaintenanceStartTimeInput$DayOfWeek</a> </p> </li> <li> <p> <a>UpdateMaintenanceStartTimeInput$HourOfDay</a> </p> </li> <li> <p> <a>UpdateMaintenanceStartTimeInput$MinuteOfHour</a> </p> </li> </ul>', 'refs' => [], ], 'UpdateMaintenanceStartTimeOutput' => [ 'base' => '<p>A JSON object containing the Amazon Resource Name (ARN) of the gateway whose maintenance start time is updated.</p>', 'refs' => [], ], 'UpdateNFSFileShareInput' => [ 'base' => '<p>UpdateNFSFileShareInput</p>', 'refs' => [], ], 'UpdateNFSFileShareOutput' => [ 'base' => '<p>UpdateNFSFileShareOutput</p>', 'refs' => [], ], 'UpdateSMBFileShareInput' => [ 'base' => '<p>UpdateSMBFileShareInput</p>', 'refs' => [], ], 'UpdateSMBFileShareOutput' => [ 'base' => '<p>UpdateSMBFileShareOutput</p>', 'refs' => [], ], 'UpdateSMBFileShareVisibilityInput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateSMBFileShareVisibilityOutput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateSMBSecurityStrategyInput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateSMBSecurityStrategyOutput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateSnapshotScheduleInput' => [ 'base' => '<p>A JSON object containing one or more of the following fields:</p> <ul> <li> <p> <a>UpdateSnapshotScheduleInput$Description</a> </p> </li> <li> <p> <a>UpdateSnapshotScheduleInput$RecurrenceInHours</a> </p> </li> <li> <p> <a>UpdateSnapshotScheduleInput$StartAt</a> </p> </li> <li> <p> <a>UpdateSnapshotScheduleInput$VolumeARN</a> </p> </li> </ul>', 'refs' => [], ], 'UpdateSnapshotScheduleOutput' => [ 'base' => '<p>A JSON object containing the Amazon Resource Name (ARN) of the updated storage volume.</p>', 'refs' => [], ], 'UpdateVTLDeviceTypeInput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateVTLDeviceTypeOutput' => [ 'base' => '<p>UpdateVTLDeviceTypeOutput</p>', 'refs' => [], ], 'UserList' => [ 'base' => NULL, 'refs' => [ 'CreateSMBFileShareInput$AdminUserList' => '<p>A list of users or groups in the Active Directory that will be granted administrator privileges on the file share. These users can do all file operations as the super-user. Acceptable formats include: <code>DOMAIN\\User1</code>, <code>user1</code>, <code>@group1</code>, and <code>@DOMAIN\\group1</code>.</p> <important> <p>Use this option very carefully, because any user in this list can do anything they like on the file share, regardless of file permissions.</p> </important>', 'CreateSMBFileShareInput$ValidUserList' => '<p>A list of users or groups in the Active Directory that are allowed to access the file <a href=""/> share. A group must be prefixed with the @ character. Acceptable formats include: <code>DOMAIN\\User1</code>, <code>user1</code>, <code>@group1</code>, and <code>@DOMAIN\\group1</code>. Can only be set if Authentication is set to <code>ActiveDirectory</code>.</p>', 'CreateSMBFileShareInput$InvalidUserList' => '<p>A list of users or groups in the Active Directory that are not allowed to access the file share. A group must be prefixed with the @ character. Acceptable formats include: <code>DOMAIN\\User1</code>, <code>user1</code>, <code>@group1</code>, and <code>@DOMAIN\\group1</code>. Can only be set if Authentication is set to <code>ActiveDirectory</code>.</p>', 'SMBFileShareInfo$AdminUserList' => '<p>A list of users or groups in the Active Directory that have administrator rights to the file share. A group must be prefixed with the @ character. Acceptable formats include: <code>DOMAIN\\User1</code>, <code>user1</code>, <code>@group1</code>, and <code>@DOMAIN\\group1</code>. Can only be set if Authentication is set to <code>ActiveDirectory</code>.</p>', 'SMBFileShareInfo$ValidUserList' => '<p>A list of users or groups in the Active Directory that are allowed to access the file share. A group must be prefixed with the @ character. Acceptable formats include: <code>DOMAIN\\User1</code>, <code>user1</code>, <code>@group1</code>, and <code>@DOMAIN\\group1</code>. Can only be set if Authentication is set to <code>ActiveDirectory</code>.</p>', 'SMBFileShareInfo$InvalidUserList' => '<p>A list of users or groups in the Active Directory that are not allowed to access the file share. A group must be prefixed with the @ character. Acceptable formats include: <code>DOMAIN\\User1</code>, <code>user1</code>, <code>@group1</code>, and <code>@DOMAIN\\group1</code>. Can only be set if Authentication is set to <code>ActiveDirectory</code>.</p>', 'UpdateSMBFileShareInput$AdminUserList' => '<p>A list of users or groups in the Active Directory that have administrator rights to the file share. A group must be prefixed with the @ character. Acceptable formats include: <code>DOMAIN\\User1</code>, <code>user1</code>, <code>@group1</code>, and <code>@DOMAIN\\group1</code>. Can only be set if Authentication is set to <code>ActiveDirectory</code>.</p>', 'UpdateSMBFileShareInput$ValidUserList' => '<p>A list of users or groups in the Active Directory that are allowed to access the file share. A group must be prefixed with the @ character. Acceptable formats include: <code>DOMAIN\\User1</code>, <code>user1</code>, <code>@group1</code>, and <code>@DOMAIN\\group1</code>. Can only be set if Authentication is set to <code>ActiveDirectory</code>.</p>', 'UpdateSMBFileShareInput$InvalidUserList' => '<p>A list of users or groups in the Active Directory that are not allowed to access the file share. A group must be prefixed with the @ character. Acceptable formats include: <code>DOMAIN\\User1</code>, <code>user1</code>, <code>@group1</code>, and <code>@DOMAIN\\group1</code>. Can only be set if Authentication is set to <code>ActiveDirectory</code>.</p>', ], ], 'UserListUser' => [ 'base' => NULL, 'refs' => [ 'UserList$member' => NULL, ], ], 'VTLDevice' => [ 'base' => '<p>Represents a device object associated with a tape gateway.</p>', 'refs' => [ 'VTLDevices$member' => NULL, ], ], 'VTLDeviceARN' => [ 'base' => NULL, 'refs' => [ 'Tape$VTLDevice' => '<p>The virtual tape library (VTL) device that the virtual tape is associated with.</p>', 'UpdateVTLDeviceTypeInput$VTLDeviceARN' => '<p>The Amazon Resource Name (ARN) of the medium changer you want to select.</p>', 'UpdateVTLDeviceTypeOutput$VTLDeviceARN' => '<p>The Amazon Resource Name (ARN) of the medium changer you have selected.</p>', 'VTLDevice$VTLDeviceARN' => '<p>Specifies the unique Amazon Resource Name (ARN) of the device (tape drive or media changer).</p>', 'VTLDeviceARNs$member' => NULL, ], ], 'VTLDeviceARNs' => [ 'base' => NULL, 'refs' => [ 'DescribeVTLDevicesInput$VTLDeviceARNs' => '<p>An array of strings, where each string represents the Amazon Resource Name (ARN) of a VTL device.</p> <note> <p>All of the specified VTL devices must be from the same gateway. If no VTL devices are specified, the result will contain all devices on the specified gateway.</p> </note>', ], ], 'VTLDeviceProductIdentifier' => [ 'base' => NULL, 'refs' => [ 'VTLDevice$VTLDeviceProductIdentifier' => '<p>Specifies the model number of device that the VTL device emulates.</p>', ], ], 'VTLDeviceType' => [ 'base' => NULL, 'refs' => [ 'VTLDevice$VTLDeviceType' => '<p>Specifies the type of device that the VTL device emulates.</p>', ], ], 'VTLDeviceVendor' => [ 'base' => NULL, 'refs' => [ 'VTLDevice$VTLDeviceVendor' => '<p>Specifies the vendor of the device that the VTL device object emulates.</p>', ], ], 'VTLDevices' => [ 'base' => NULL, 'refs' => [ 'DescribeVTLDevicesOutput$VTLDevices' => '<p>An array of VTL device objects composed of the Amazon Resource Name (ARN) of the VTL devices.</p>', ], ], 'VolumeARN' => [ 'base' => NULL, 'refs' => [ 'AttachVolumeInput$VolumeARN' => '<p>The Amazon Resource Name (ARN) of the volume to attach to the specified gateway.</p>', 'AttachVolumeOutput$VolumeARN' => '<p>The Amazon Resource Name (ARN) of the volume that was attached to the gateway.</p>', 'CachediSCSIVolume$VolumeARN' => '<p>The Amazon Resource Name (ARN) of the storage volume.</p>', 'CreateCachediSCSIVolumeInput$SourceVolumeARN' => '<p>The ARN for an existing volume. Specifying this ARN makes the new volume into an exact copy of the specified existing volume\'s latest recovery point. The <code>VolumeSizeInBytes</code> value for this new volume must be equal to or larger than the size of the existing volume, in bytes.</p>', 'CreateCachediSCSIVolumeOutput$VolumeARN' => '<p>The Amazon Resource Name (ARN) of the configured volume.</p>', 'CreateSnapshotFromVolumeRecoveryPointInput$VolumeARN' => '<p>The Amazon Resource Name (ARN) of the iSCSI volume target. Use the <a>DescribeStorediSCSIVolumes</a> operation to return to retrieve the TargetARN for specified VolumeARN.</p>', 'CreateSnapshotFromVolumeRecoveryPointOutput$VolumeARN' => '<p>The Amazon Resource Name (ARN) of the iSCSI volume target. Use the <a>DescribeStorediSCSIVolumes</a> operation to return to retrieve the TargetARN for specified VolumeARN.</p>', 'CreateSnapshotInput$VolumeARN' => '<p>The Amazon Resource Name (ARN) of the volume. Use the <a>ListVolumes</a> operation to return a list of gateway volumes.</p>', 'CreateSnapshotOutput$VolumeARN' => '<p>The Amazon Resource Name (ARN) of the volume of which the snapshot was taken.</p>', 'CreateStorediSCSIVolumeOutput$VolumeARN' => '<p>The Amazon Resource Name (ARN) of the configured volume.</p>', 'DeleteSnapshotScheduleInput$VolumeARN' => '<p>The volume which snapshot schedule to delete.</p>', 'DeleteSnapshotScheduleOutput$VolumeARN' => '<p>The volume which snapshot schedule was deleted.</p>', 'DeleteVolumeInput$VolumeARN' => '<p>The Amazon Resource Name (ARN) of the volume. Use the <a>ListVolumes</a> operation to return a list of gateway volumes.</p>', 'DeleteVolumeOutput$VolumeARN' => '<p>The Amazon Resource Name (ARN) of the storage volume that was deleted. It is the same ARN you provided in the request.</p>', 'DescribeSnapshotScheduleInput$VolumeARN' => '<p>The Amazon Resource Name (ARN) of the volume. Use the <a>ListVolumes</a> operation to return a list of gateway volumes.</p>', 'DescribeSnapshotScheduleOutput$VolumeARN' => '<p>The Amazon Resource Name (ARN) of the volume that was specified in the request.</p>', 'DetachVolumeInput$VolumeARN' => '<p>The Amazon Resource Name (ARN) of the volume to detach from the gateway.</p>', 'DetachVolumeOutput$VolumeARN' => '<p>The Amazon Resource Name (ARN) of the volume that was detached.</p>', 'ListVolumeInitiatorsInput$VolumeARN' => '<p>The Amazon Resource Name (ARN) of the volume. Use the <a>ListVolumes</a> operation to return a list of gateway volumes for the gateway.</p>', 'StorediSCSIVolume$VolumeARN' => '<p>The Amazon Resource Name (ARN) of the storage volume.</p>', 'UpdateSnapshotScheduleInput$VolumeARN' => '<p>The Amazon Resource Name (ARN) of the volume. Use the <a>ListVolumes</a> operation to return a list of gateway volumes.</p>', 'UpdateSnapshotScheduleOutput$VolumeARN' => '<p>The Amazon Resource Name (ARN) of the volume. Use the <a>ListVolumes</a> operation to return a list of gateway volumes.</p>', 'VolumeARNs$member' => NULL, 'VolumeInfo$VolumeARN' => '<p>The Amazon Resource Name (ARN) for the storage volume. For example, the following is a valid ARN:</p> <p> <code>arn:aws:storagegateway:us-east-2:111122223333:gateway/sgw-12A3456B/volume/vol-1122AABB</code> </p> <p>Valid Values: 50 to 500 lowercase letters, numbers, periods (.), and hyphens (-).</p>', 'VolumeRecoveryPointInfo$VolumeARN' => '<p>The Amazon Resource Name (ARN) of the volume target.</p>', ], ], 'VolumeARNs' => [ 'base' => NULL, 'refs' => [ 'DescribeCachediSCSIVolumesInput$VolumeARNs' => '<p>An array of strings where each string represents the Amazon Resource Name (ARN) of a cached volume. All of the specified cached volumes must be from the same gateway. Use <a>ListVolumes</a> to get volume ARNs for a gateway.</p>', 'DescribeStorediSCSIVolumesInput$VolumeARNs' => '<p>An array of strings where each string represents the Amazon Resource Name (ARN) of a stored volume. All of the specified stored volumes must be from the same gateway. Use <a>ListVolumes</a> to get volume ARNs for a gateway.</p>', ], ], 'VolumeAttachmentStatus' => [ 'base' => NULL, 'refs' => [ 'CachediSCSIVolume$VolumeAttachmentStatus' => '<p>A value that indicates whether a storage volume is attached to or detached from a gateway. For more information, see <a href="https://docs.aws.amazon.com/storagegateway/latest/userguide/managing-volumes.html#attach-detach-volume">Moving your volumes to a different gateway</a>.</p>', 'StorediSCSIVolume$VolumeAttachmentStatus' => '<p>A value that indicates whether a storage volume is attached to, detached from, or is in the process of detaching from a gateway. For more information, see <a href="https://docs.aws.amazon.com/storagegateway/latest/userguide/managing-volumes.html#attach-detach-volume">Moving your volumes to a different gateway</a>.</p>', 'VolumeInfo$VolumeAttachmentStatus' => '<p>One of the VolumeStatus values that indicates the state of the storage volume.</p>', ], ], 'VolumeId' => [ 'base' => NULL, 'refs' => [ 'CachediSCSIVolume$VolumeId' => '<p>The unique identifier of the volume, e.g., vol-AE4B946D.</p>', 'StorediSCSIVolume$VolumeId' => '<p>The unique identifier of the volume, e.g., vol-AE4B946D.</p>', 'VolumeInfo$VolumeId' => '<p>The unique identifier assigned to the volume. This ID becomes part of the volume Amazon Resource Name (ARN), which you use as input for other operations.</p> <p>Valid Values: 50 to 500 lowercase letters, numbers, periods (.), and hyphens (-).</p>', ], ], 'VolumeInfo' => [ 'base' => '<p>Describes a storage volume object.</p>', 'refs' => [ 'VolumeInfos$member' => NULL, ], ], 'VolumeInfos' => [ 'base' => NULL, 'refs' => [ 'ListVolumesOutput$VolumeInfos' => '<p>An array of <a>VolumeInfo</a> objects, where each object describes an iSCSI volume. If no volumes are defined for the gateway, then <code>VolumeInfos</code> is an empty array "[]".</p>', ], ], 'VolumeRecoveryPointInfo' => [ 'base' => '<p>Describes a storage volume recovery point object.</p>', 'refs' => [ 'VolumeRecoveryPointInfos$member' => NULL, ], ], 'VolumeRecoveryPointInfos' => [ 'base' => NULL, 'refs' => [ 'ListVolumeRecoveryPointsOutput$VolumeRecoveryPointInfos' => '<p>An array of <a>VolumeRecoveryPointInfo</a> objects.</p>', ], ], 'VolumeStatus' => [ 'base' => NULL, 'refs' => [ 'CachediSCSIVolume$VolumeStatus' => '<p>One of the VolumeStatus values that indicates the state of the storage volume.</p>', 'StorediSCSIVolume$VolumeStatus' => '<p>One of the VolumeStatus values that indicates the state of the storage volume.</p>', ], ], 'VolumeType' => [ 'base' => NULL, 'refs' => [ 'CachediSCSIVolume$VolumeType' => '<p>One of the VolumeType enumeration values that describes the type of the volume.</p>', 'StorediSCSIVolume$VolumeType' => '<p>One of the VolumeType enumeration values describing the type of the volume.</p>', 'VolumeInfo$VolumeType' => '<p>One of the VolumeType enumeration values describing the type of the volume.</p>', ], ], 'VolumeUsedInBytes' => [ 'base' => NULL, 'refs' => [ 'CachediSCSIVolume$VolumeUsedInBytes' => '<p>The size of the data stored on the volume in bytes. This value is calculated based on the number of blocks that are touched, instead of the actual amount of data written. This value can be useful for sequential write patterns but less accurate for random write patterns. <code>VolumeUsedInBytes</code> is different from the compressed size of the volume, which is the value that is used to calculate your bill.</p> <note> <p>This value is not available for volumes created prior to May 13, 2015, until you store data on the volume.</p> </note>', 'StorediSCSIVolume$VolumeUsedInBytes' => '<p>The size of the data stored on the volume in bytes. This value is calculated based on the number of blocks that are touched, instead of the actual amount of data written. This value can be useful for sequential write patterns but less accurate for random write patterns. <code>VolumeUsedInBytes</code> is different from the compressed size of the volume, which is the value that is used to calculate your bill.</p> <note> <p>This value is not available for volumes created prior to May 13, 2015, until you store data on the volume.</p> </note>', ], ], 'VolumeiSCSIAttributes' => [ 'base' => '<p>Lists iSCSI information about a volume.</p>', 'refs' => [ 'CachediSCSIVolume$VolumeiSCSIAttributes' => '<p>An <a>VolumeiSCSIAttributes</a> object that represents a collection of iSCSI attributes for one stored volume.</p>', 'StorediSCSIVolume$VolumeiSCSIAttributes' => '<p>An <a>VolumeiSCSIAttributes</a> object that represents a collection of iSCSI attributes for one stored volume.</p>', ], ], 'boolean' => [ 'base' => NULL, 'refs' => [ 'AssignTapePoolInput$BypassGovernanceRetention' => '<p>Set permissions to bypass governance retention. If the lock type of the archived tape is <code>Governance</code>, the tape\'s archived age is not older than <code>RetentionLockInDays</code>, and the user does not already have <code>BypassGovernanceRetention</code>, setting this to TRUE enables the user to bypass the retention lock. This parameter is set to true by default for calls from the console.</p> <p>Valid values: <code>TRUE</code> | <code>FALSE</code> </p>', 'AutomaticTapeCreationRule$Worm' => '<p>Set to <code>true</code> to indicate that tapes are to be archived as write-once-read-many (WORM). Set to <code>false</code> when WORM is not enabled for tapes.</p>', 'CreateStorediSCSIVolumeInput$PreserveExistingData' => '<p>Set to <code>true</code> if you want to preserve the data on the local disk. Otherwise, set to <code>false</code> to create an empty volume.</p> <p>Valid Values: <code>true</code> | <code>false</code> </p>', 'CreateTapeWithBarcodeInput$Worm' => '<p>Set to <code>TRUE</code> if the tape you are creating is to be configured as a write-once-read-many (WORM) tape.</p>', 'CreateTapesInput$Worm' => '<p>Set to <code>TRUE</code> if the tape you are creating is to be configured as a write-once-read-many (WORM) tape.</p>', 'DeleteFileShareInput$ForceDelete' => '<p>If this value is set to <code>true</code>, the operation deletes a file share immediately and aborts all data uploads to Amazon Web Services. Otherwise, the file share is not deleted until all data is uploaded to Amazon Web Services. This process aborts the data upload process, and the file share enters the <code>FORCE_DELETING</code> status.</p> <p>Valid Values: <code>true</code> | <code>false</code> </p>', 'DeleteTapeArchiveInput$BypassGovernanceRetention' => '<p>Set to <code>TRUE</code> to delete an archived tape that belongs to a custom pool with tape retention lock. Only archived tapes with tape retention lock set to <code>governance</code> can be deleted. Archived tapes with tape retention lock set to <code>compliance</code> can\'t be deleted.</p>', 'DeleteTapeInput$BypassGovernanceRetention' => '<p>Set to <code>TRUE</code> to delete an archived tape that belongs to a custom pool with tape retention lock. Only archived tapes with tape retention lock set to <code>governance</code> can be deleted. Archived tapes with tape retention lock set to <code>compliance</code> can\'t be deleted.</p>', 'DeviceiSCSIAttributes$ChapEnabled' => '<p>Indicates whether mutual CHAP is enabled for the iSCSI target.</p>', 'DisassociateFileSystemInput$ForceDelete' => '<p>If this value is set to true, the operation disassociates an Amazon FSx file system immediately. It ends all data uploads to the file system, and the file system association enters the <code>FORCE_DELETING</code> status. If this value is set to false, the Amazon FSx file system does not disassociate until all data is uploaded.</p>', 'NFSFileShareInfo$KMSEncrypted' => '<p>Set to <code>true</code> to use Amazon S3 server-side encryption with your own KMS key, or <code>false</code> to use a key managed by Amazon S3. Optional.</p> <p>Valid Values: <code>true</code> | <code>false</code> </p>', 'SMBFileShareInfo$KMSEncrypted' => '<p>Set to <code>true</code> to use Amazon S3 server-side encryption with your own KMS key, or <code>false</code> to use a key managed by Amazon S3. Optional.</p> <p>Valid Values: <code>true</code> | <code>false</code> </p>', 'StorediSCSIVolume$PreservedExistingData' => '<p>Indicates if when the stored volume was created, existing data on the underlying local disk was preserved.</p> <p>Valid Values: <code>true</code> | <code>false</code> </p>', 'Tape$Worm' => '<p>If the tape is archived as write-once-read-many (WORM), this value is <code>true</code>.</p>', 'TapeArchive$Worm' => '<p>Set to <code>true</code> if the archived tape is stored as write-once-read-many (WORM).</p>', 'VolumeiSCSIAttributes$ChapEnabled' => '<p>Indicates whether mutual CHAP is enabled for the iSCSI target.</p>', ], ], 'double' => [ 'base' => NULL, 'refs' => [ 'DescribeCacheOutput$CacheUsedPercentage' => '<p>Percent use of the gateway\'s cache storage. This metric applies only to the gateway-cached volume setup. The sample is taken at the end of the reporting period.</p>', 'DescribeCacheOutput$CacheDirtyPercentage' => '<p>The file share\'s contribution to the overall percentage of the gateway\'s cache that has not been persisted to Amazon Web Services. The sample is taken at the end of the reporting period.</p>', 'DescribeCacheOutput$CacheHitPercentage' => '<p>Percent of application read operations from the file shares that are served from cache. The sample is taken at the end of the reporting period.</p>', 'DescribeCacheOutput$CacheMissPercentage' => '<p>Percent of application read operations from the file shares that are not served from cache. The sample is taken at the end of the reporting period.</p>', ], ], 'errorDetails' => [ 'base' => NULL, 'refs' => [ 'StorageGatewayError$errorDetails' => '<p>Human-readable text that provides detail about the error that occurred.</p>', ], ], 'integer' => [ 'base' => NULL, 'refs' => [ 'DeviceiSCSIAttributes$NetworkInterfacePort' => '<p>The port used to communicate with iSCSI VTL device targets.</p>', 'VolumeiSCSIAttributes$NetworkInterfacePort' => '<p>The port used to communicate with iSCSI targets.</p>', ], ], 'long' => [ 'base' => NULL, 'refs' => [ 'CachediSCSIVolume$VolumeSizeInBytes' => '<p>The size, in bytes, of the volume capacity.</p>', 'CreateCachediSCSIVolumeInput$VolumeSizeInBytes' => '<p>The size of the volume in bytes.</p>', 'CreateStorediSCSIVolumeOutput$VolumeSizeInBytes' => '<p>The size of the volume in bytes.</p>', 'DescribeCacheOutput$CacheAllocatedInBytes' => '<p>The amount of cache in bytes allocated to a gateway.</p>', 'DescribeUploadBufferOutput$UploadBufferUsedInBytes' => '<p>The total number of bytes being used in the gateway\'s upload buffer.</p>', 'DescribeUploadBufferOutput$UploadBufferAllocatedInBytes' => '<p>The total number of bytes allocated in the gateway\'s as upload buffer.</p>', 'DescribeWorkingStorageOutput$WorkingStorageUsedInBytes' => '<p>The total working storage in bytes in use by the gateway. If no working storage is configured for the gateway, this field returns 0.</p>', 'DescribeWorkingStorageOutput$WorkingStorageAllocatedInBytes' => '<p>The total working storage in bytes allocated for the gateway. If no working storage is configured for the gateway, this field returns 0.</p>', 'Disk$DiskSizeInBytes' => '<p>The local disk size in bytes.</p>', 'StorediSCSIVolume$VolumeSizeInBytes' => '<p>The size of the volume in bytes.</p>', 'VolumeInfo$VolumeSizeInBytes' => '<p>The size of the volume in bytes.</p> <p>Valid Values: 50 to 500 lowercase letters, numbers, periods (.), and hyphens (-).</p>', 'VolumeRecoveryPointInfo$VolumeSizeInBytes' => '<p>The size of the volume in bytes.</p>', 'VolumeRecoveryPointInfo$VolumeUsageInBytes' => '<p>The size of the data stored on the volume in bytes.</p> <note> <p>This value is not available for volumes created prior to May 13, 2015, until you store data on the volume.</p> </note>', ], ], 'string' => [ 'base' => NULL, 'refs' => [ 'CreateSnapshotFromVolumeRecoveryPointOutput$VolumeRecoveryPointTime' => '<p>The time the volume was created from the recovery point.</p>', 'DescribeGatewayInformationOutput$GatewayName' => '<p>The name you configured for your gateway.</p>', 'DescribeGatewayInformationOutput$VPCEndpoint' => '<p>The configuration settings for the virtual private cloud (VPC) endpoint for your gateway.</p>', 'Disk$DiskPath' => '<p>The path of a local disk in the gateway virtual machine (VM).</p>', 'Disk$DiskNode' => '<p>The device node of a local disk as assigned by the virtualization environment.</p>', 'Disk$DiskStatus' => '<p>A value that represents the status of a local disk.</p>', 'Disk$DiskAllocationResource' => '<p>The iSCSI qualified name (IQN) that is defined for a disk. This field is not included in the response if the local disk is not defined as an iSCSI target. The format of this field is <i>targetIqn::LUNNumber::region-volumeId</i>.</p>', 'GatewayInfo$GatewayName' => '<p>The name of the gateway.</p>', 'InternalServerError$message' => '<p>A human-readable message describing the error that occurred.</p>', 'InvalidGatewayRequestException$message' => '<p>A human-readable message describing the error that occurred.</p>', 'NetworkInterface$Ipv4Address' => '<p>The Internet Protocol version 4 (IPv4) address of the interface.</p>', 'NetworkInterface$MacAddress' => '<p>The Media Access Control (MAC) address of the interface.</p> <note> <p>This is currently unsupported and will not be returned in output.</p> </note>', 'NetworkInterface$Ipv6Address' => '<p>The Internet Protocol version 6 (IPv6) address of the interface. <i>Currently not supported</i>.</p>', 'ServiceUnavailableError$message' => '<p>A human-readable message describing the error that occurred.</p>', 'UpdateGatewayInformationOutput$GatewayName' => '<p>The name you configured for your gateway.</p>', 'VolumeRecoveryPointInfo$VolumeRecoveryPointTime' => '<p>The time the recovery point was taken.</p>', 'errorDetails$key' => NULL, 'errorDetails$value' => NULL, ], ], ],];
