<?php
// This file was auto-generated from sdk-root/src/data/route53resolver/2018-04-01/docs-2.json
return [ 'version' => '2.0', 'service' => '<p>When you create a VPC using Amazon VPC, you automatically get DNS resolution within the VPC from Route 53 Resolver. By default, Resolver answers DNS queries for VPC domain names such as domain names for EC2 instances or Elastic Load Balancing load balancers. Resolver performs recursive lookups against public name servers for all other domain names.</p> <p>You can also configure DNS resolution between your VPC and your network over a Direct Connect or VPN connection:</p> <p> <b>Forward DNS queries from resolvers on your network to Route 53 Resolver</b> </p> <p>DNS resolvers on your network can forward DNS queries to Resolver in a specified VPC. This allows your DNS resolvers to easily resolve domain names for Amazon Web Services resources such as EC2 instances or records in a Route 53 private hosted zone. For more information, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/resolver.html#resolver-overview-forward-network-to-vpc">How DNS Resolvers on Your Network Forward DNS Queries to Route 53 Resolver</a> in the <i>Amazon Route 53 Developer Guide</i>.</p> <p> <b>Conditionally forward queries from a VPC to resolvers on your network</b> </p> <p>You can configure Resolver to forward queries that it receives from EC2 instances in your VPCs to DNS resolvers on your network. To forward selected queries, you create Resolver rules that specify the domain names for the DNS queries that you want to forward (such as example.com), and the IP addresses of the DNS resolvers on your network that you want to forward the queries to. If a query matches multiple rules (example.com, acme.example.com), Resolver chooses the rule with the most specific match (acme.example.com) and forwards the query to the IP addresses that you specified in that rule. For more information, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/resolver.html#resolver-overview-forward-vpc-to-network">How Route 53 Resolver Forwards DNS Queries from Your VPCs to Your Network</a> in the <i>Amazon Route 53 Developer Guide</i>.</p> <p>Like Amazon VPC, Resolver is Regional. In each Region where you have VPCs, you can choose whether to forward queries from your VPCs to your network (outbound queries), from your network to your VPCs (inbound queries), or both.</p>', 'operations' => [ 'AssociateFirewallRuleGroup' => '<p>Associates a <a>FirewallRuleGroup</a> with a VPC, to provide DNS filtering for the VPC. </p>', 'AssociateResolverEndpointIpAddress' => '<p>Adds IP addresses to an inbound or an outbound Resolver endpoint. If you want to add more than one IP address, submit one <code>AssociateResolverEndpointIpAddress</code> request for each IP address.</p> <p>To remove an IP address from an endpoint, see <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_DisassociateResolverEndpointIpAddress.html">DisassociateResolverEndpointIpAddress</a>. </p>', 'AssociateResolverQueryLogConfig' => '<p>Associates an Amazon VPC with a specified query logging configuration. Route 53 Resolver logs DNS queries that originate in all of the Amazon VPCs that are associated with a specified query logging configuration. To associate more than one VPC with a configuration, submit one <code>AssociateResolverQueryLogConfig</code> request for each VPC.</p> <note> <p>The VPCs that you associate with a query logging configuration must be in the same Region as the configuration.</p> </note> <p>To remove a VPC from a query logging configuration, see <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_DisassociateResolverQueryLogConfig.html">DisassociateResolverQueryLogConfig</a>. </p>', 'AssociateResolverRule' => '<p>Associates a Resolver rule with a VPC. When you associate a rule with a VPC, Resolver forwards all DNS queries for the domain name that is specified in the rule and that originate in the VPC. The queries are forwarded to the IP addresses for the DNS resolvers that are specified in the rule. For more information about rules, see <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_CreateResolverRule.html">CreateResolverRule</a>. </p>', 'CreateFirewallDomainList' => '<p>Creates an empty firewall domain list for use in DNS Firewall rules. You can populate the domains for the new list with a file, using <a>ImportFirewallDomains</a>, or with domain strings, using <a>UpdateFirewallDomains</a>. </p>', 'CreateFirewallRule' => '<p>Creates a single DNS Firewall rule in the specified rule group, using the specified domain list.</p>', 'CreateFirewallRuleGroup' => '<p>Creates an empty DNS Firewall rule group for filtering DNS network traffic in a VPC. You can add rules to the new rule group by calling <a>CreateFirewallRule</a>. </p>', 'CreateResolverEndpoint' => '<p>Creates a Resolver endpoint. There are two types of Resolver endpoints, inbound and outbound:</p> <ul> <li> <p>An <i>inbound Resolver endpoint</i> forwards DNS queries to the DNS service for a VPC from your network.</p> </li> <li> <p>An <i>outbound Resolver endpoint</i> forwards DNS queries from the DNS service for a VPC to your network.</p> </li> </ul>', 'CreateResolverQueryLogConfig' => '<p>Creates a Resolver query logging configuration, which defines where you want Resolver to save DNS query logs that originate in your VPCs. Resolver can log queries only for VPCs that are in the same Region as the query logging configuration.</p> <p>To specify which VPCs you want to log queries for, you use <code>AssociateResolverQueryLogConfig</code>. For more information, see <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_AssociateResolverQueryLogConfig.html">AssociateResolverQueryLogConfig</a>. </p> <p>You can optionally use Resource Access Manager (RAM) to share a query logging configuration with other Amazon Web Services accounts. The other accounts can then associate VPCs with the configuration. The query logs that Resolver creates for a configuration include all DNS queries that originate in all VPCs that are associated with the configuration.</p>', 'CreateResolverRule' => '<p>For DNS queries that originate in your VPCs, specifies which Resolver endpoint the queries pass through, one domain name that you want to forward to your network, and the IP addresses of the DNS resolvers in your network.</p>', 'DeleteFirewallDomainList' => '<p>Deletes the specified domain list. </p>', 'DeleteFirewallRule' => '<p>Deletes the specified firewall rule.</p>', 'DeleteFirewallRuleGroup' => '<p>Deletes the specified firewall rule group. </p>', 'DeleteResolverEndpoint' => '<p>Deletes a Resolver endpoint. The effect of deleting a Resolver endpoint depends on whether it\'s an inbound or an outbound Resolver endpoint:</p> <ul> <li> <p> <b>Inbound</b>: DNS queries from your network are no longer routed to the DNS service for the specified VPC.</p> </li> <li> <p> <b>Outbound</b>: DNS queries from a VPC are no longer routed to your network.</p> </li> </ul>', 'DeleteResolverQueryLogConfig' => '<p>Deletes a query logging configuration. When you delete a configuration, Resolver stops logging DNS queries for all of the Amazon VPCs that are associated with the configuration. This also applies if the query logging configuration is shared with other Amazon Web Services accounts, and the other accounts have associated VPCs with the shared configuration.</p> <p>Before you can delete a query logging configuration, you must first disassociate all VPCs from the configuration. See <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_DisassociateResolverQueryLogConfig.html">DisassociateResolverQueryLogConfig</a>.</p> <p>If you used Resource Access Manager (RAM) to share a query logging configuration with other accounts, you must stop sharing the configuration before you can delete a configuration. The accounts that you shared the configuration with can first disassociate VPCs that they associated with the configuration, but that\'s not necessary. If you stop sharing the configuration, those VPCs are automatically disassociated from the configuration.</p>', 'DeleteResolverRule' => '<p>Deletes a Resolver rule. Before you can delete a Resolver rule, you must disassociate it from all the VPCs that you associated the Resolver rule with. For more information, see <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_DisassociateResolverRule.html">DisassociateResolverRule</a>.</p>', 'DisassociateFirewallRuleGroup' => '<p>Disassociates a <a>FirewallRuleGroup</a> from a VPC, to remove DNS filtering from the VPC. </p>', 'DisassociateResolverEndpointIpAddress' => '<p>Removes IP addresses from an inbound or an outbound Resolver endpoint. If you want to remove more than one IP address, submit one <code>DisassociateResolverEndpointIpAddress</code> request for each IP address.</p> <p>To add an IP address to an endpoint, see <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_AssociateResolverEndpointIpAddress.html">AssociateResolverEndpointIpAddress</a>. </p>', 'DisassociateResolverQueryLogConfig' => '<p>Disassociates a VPC from a query logging configuration.</p> <note> <p>Before you can delete a query logging configuration, you must first disassociate all VPCs from the configuration. If you used Resource Access Manager (RAM) to share a query logging configuration with other accounts, VPCs can be disassociated from the configuration in the following ways:</p> <ul> <li> <p>The accounts that you shared the configuration with can disassociate VPCs from the configuration.</p> </li> <li> <p>You can stop sharing the configuration.</p> </li> </ul> </note>', 'DisassociateResolverRule' => '<p>Removes the association between a specified Resolver rule and a specified VPC.</p> <important> <p>If you disassociate a Resolver rule from a VPC, Resolver stops forwarding DNS queries for the domain name that you specified in the Resolver rule. </p> </important>', 'GetFirewallConfig' => '<p>Retrieves the configuration of the firewall behavior provided by DNS Firewall for a single VPC from Amazon Virtual Private Cloud (Amazon VPC). </p>', 'GetFirewallDomainList' => '<p>Retrieves the specified firewall domain list.</p>', 'GetFirewallRuleGroup' => '<p>Retrieves the specified firewall rule group. </p>', 'GetFirewallRuleGroupAssociation' => '<p>Retrieves a firewall rule group association, which enables DNS filtering for a VPC with one rule group. A VPC can have more than one firewall rule group association, and a rule group can be associated with more than one VPC.</p>', 'GetFirewallRuleGroupPolicy' => '<p>Returns the Identity and Access Management (Amazon Web Services IAM) policy for sharing the specified rule group. You can use the policy to share the rule group using Resource Access Manager (RAM). </p>', 'GetResolverDnssecConfig' => '<p>Gets DNSSEC validation information for a specified resource.</p>', 'GetResolverEndpoint' => '<p>Gets information about a specified Resolver endpoint, such as whether it\'s an inbound or an outbound Resolver endpoint, and the current status of the endpoint.</p>', 'GetResolverQueryLogConfig' => '<p>Gets information about a specified Resolver query logging configuration, such as the number of VPCs that the configuration is logging queries for and the location that logs are sent to. </p>', 'GetResolverQueryLogConfigAssociation' => '<p>Gets information about a specified association between a Resolver query logging configuration and an Amazon VPC. When you associate a VPC with a query logging configuration, Resolver logs DNS queries that originate in that VPC.</p>', 'GetResolverQueryLogConfigPolicy' => '<p>Gets information about a query logging policy. A query logging policy specifies the Resolver query logging operations and resources that you want to allow another Amazon Web Services account to be able to use.</p>', 'GetResolverRule' => '<p>Gets information about a specified Resolver rule, such as the domain name that the rule forwards DNS queries for and the ID of the outbound Resolver endpoint that the rule is associated with.</p>', 'GetResolverRuleAssociation' => '<p>Gets information about an association between a specified Resolver rule and a VPC. You associate a Resolver rule and a VPC using <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_AssociateResolverRule.html">AssociateResolverRule</a>. </p>', 'GetResolverRulePolicy' => '<p>Gets information about the Resolver rule policy for a specified rule. A Resolver rule policy includes the rule that you want to share with another account, the account that you want to share the rule with, and the Resolver operations that you want to allow the account to use. </p>', 'ImportFirewallDomains' => '<p>Imports domain names from a file into a domain list, for use in a DNS firewall rule group. </p> <p>Each domain specification in your domain list must satisfy the following requirements: </p> <ul> <li> <p>It can optionally start with <code>*</code> (asterisk).</p> </li> <li> <p>With the exception of the optional starting asterisk, it must only contain the following characters: <code>A-Z</code>, <code>a-z</code>, <code>0-9</code>, <code>-</code> (hyphen).</p> </li> <li> <p>It must be from 1-255 characters in length. </p> </li> </ul>', 'ListFirewallConfigs' => '<p>Retrieves the firewall configurations that you have defined. DNS Firewall uses the configurations to manage firewall behavior for your VPCs. </p> <p>A single call might return only a partial list of the configurations. For information, see <code>MaxResults</code>. </p>', 'ListFirewallDomainLists' => '<p>Retrieves the firewall domain lists that you have defined. For each firewall domain list, you can retrieve the domains that are defined for a list by calling <a>ListFirewallDomains</a>. </p> <p>A single call to this list operation might return only a partial list of the domain lists. For information, see <code>MaxResults</code>. </p>', 'ListFirewallDomains' => '<p>Retrieves the domains that you have defined for the specified firewall domain list. </p> <p>A single call might return only a partial list of the domains. For information, see <code>MaxResults</code>. </p>', 'ListFirewallRuleGroupAssociations' => '<p>Retrieves the firewall rule group associations that you have defined. Each association enables DNS filtering for a VPC with one rule group. </p> <p>A single call might return only a partial list of the associations. For information, see <code>MaxResults</code>. </p>', 'ListFirewallRuleGroups' => '<p>Retrieves the minimal high-level information for the rule groups that you have defined. </p> <p>A single call might return only a partial list of the rule groups. For information, see <code>MaxResults</code>. </p>', 'ListFirewallRules' => '<p>Retrieves the firewall rules that you have defined for the specified firewall rule group. DNS Firewall uses the rules in a rule group to filter DNS network traffic for a VPC. </p> <p>A single call might return only a partial list of the rules. For information, see <code>MaxResults</code>. </p>', 'ListResolverDnssecConfigs' => '<p>Lists the configurations for DNSSEC validation that are associated with the current Amazon Web Services account.</p>', 'ListResolverEndpointIpAddresses' => '<p>Gets the IP addresses for a specified Resolver endpoint.</p>', 'ListResolverEndpoints' => '<p>Lists all the Resolver endpoints that were created using the current Amazon Web Services account.</p>', 'ListResolverQueryLogConfigAssociations' => '<p>Lists information about associations between Amazon VPCs and query logging configurations.</p>', 'ListResolverQueryLogConfigs' => '<p>Lists information about the specified query logging configurations. Each configuration defines where you want Resolver to save DNS query logs and specifies the VPCs that you want to log queries for.</p>', 'ListResolverRuleAssociations' => '<p>Lists the associations that were created between Resolver rules and VPCs using the current Amazon Web Services account.</p>', 'ListResolverRules' => '<p>Lists the Resolver rules that were created using the current Amazon Web Services account.</p>', 'ListTagsForResource' => '<p>Lists the tags that you associated with the specified resource.</p>', 'PutFirewallRuleGroupPolicy' => '<p>Attaches an Identity and Access Management (Amazon Web Services IAM) policy for sharing the rule group. You can use the policy to share the rule group using Resource Access Manager (RAM). </p>', 'PutResolverQueryLogConfigPolicy' => '<p>Specifies an Amazon Web Services account that you want to share a query logging configuration with, the query logging configuration that you want to share, and the operations that you want the account to be able to perform on the configuration.</p>', 'PutResolverRulePolicy' => '<p>Specifies an Amazon Web Services rule that you want to share with another account, the account that you want to share the rule with, and the operations that you want the account to be able to perform on the rule.</p>', 'TagResource' => '<p>Adds one or more tags to a specified resource.</p>', 'UntagResource' => '<p>Removes one or more tags from a specified resource.</p>', 'UpdateFirewallConfig' => '<p>Updates the configuration of the firewall behavior provided by DNS Firewall for a single VPC from Amazon Virtual Private Cloud (Amazon VPC). </p>', 'UpdateFirewallDomains' => '<p>Updates the firewall domain list from an array of domain specifications. </p>', 'UpdateFirewallRule' => '<p>Updates the specified firewall rule. </p>', 'UpdateFirewallRuleGroupAssociation' => '<p>Changes the association of a <a>FirewallRuleGroup</a> with a VPC. The association enables DNS filtering for the VPC. </p>', 'UpdateResolverDnssecConfig' => '<p>Updates an existing DNSSEC validation configuration. If there is no existing DNSSEC validation configuration, one is created.</p>', 'UpdateResolverEndpoint' => '<p>Updates the name of an inbound or an outbound Resolver endpoint. </p>', 'UpdateResolverRule' => '<p>Updates settings for a specified Resolver rule. <code>ResolverRuleId</code> is required, and all other parameters are optional. If you don\'t specify a parameter, it retains its current value.</p>', ], 'shapes' => [ 'AccessDeniedException' => [ 'base' => '<p>The current account doesn\'t have the IAM permissions required to perform the specified Resolver operation.</p>', 'refs' => [], ], 'AccountId' => [ 'base' => NULL, 'refs' => [ 'FirewallConfig$OwnerId' => '<p>The Amazon Web Services account ID of the owner of the VPC that this firewall configuration applies to.</p>', 'FirewallRuleGroup$OwnerId' => '<p>The Amazon Web Services account ID for the account that created the rule group. When a rule group is shared with your account, this is the account that has shared the rule group with you. </p>', 'FirewallRuleGroupMetadata$OwnerId' => '<p>The Amazon Web Services account ID for the account that created the rule group. When a rule group is shared with your account, this is the account that has shared the rule group with you. </p>', 'ResolverDnssecConfig$OwnerId' => '<p>The owner account ID of the virtual private cloud (VPC) for a configuration for DNSSEC validation.</p>', 'ResolverQueryLogConfig$OwnerId' => '<p>The Amazon Web Services account ID for the account that created the query logging configuration. </p>', 'ResolverRule$OwnerId' => '<p>When a rule is shared with another Amazon Web Services account, the account ID of the account that the rule is shared with.</p>', ], ], 'Action' => [ 'base' => NULL, 'refs' => [ 'CreateFirewallRuleRequest$Action' => '<p>The action that DNS Firewall should take on a DNS query when it matches one of the domains in the rule\'s domain list:</p> <ul> <li> <p> <code>ALLOW</code> - Permit the request to go through.</p> </li> <li> <p> <code>ALERT</code> - Permit the request and send metrics and logs to Cloud Watch.</p> </li> <li> <p> <code>BLOCK</code> - Disallow the request. This option requires additional details in the rule\'s <code>BlockResponse</code>. </p> </li> </ul>', 'FirewallRule$Action' => '<p>The action that DNS Firewall should take on a DNS query when it matches one of the domains in the rule\'s domain list:</p> <ul> <li> <p> <code>ALLOW</code> - Permit the request to go through.</p> </li> <li> <p> <code>ALERT</code> - Permit the request to go through but send an alert to the logs.</p> </li> <li> <p> <code>BLOCK</code> - Disallow the request. If this is specified, additional handling details are provided in the rule\'s <code>BlockResponse</code> setting. </p> </li> </ul>', 'ListFirewallRulesRequest$Action' => '<p>Optional additional filter for the rules to retrieve.</p> <p>The action that DNS Firewall should take on a DNS query when it matches one of the domains in the rule\'s domain list:</p> <ul> <li> <p> <code>ALLOW</code> - Permit the request to go through.</p> </li> <li> <p> <code>ALERT</code> - Permit the request to go through but send an alert to the logs.</p> </li> <li> <p> <code>BLOCK</code> - Disallow the request. If this is specified, additional handling details are provided in the rule\'s <code>BlockResponse</code> setting. </p> </li> </ul>', 'UpdateFirewallRuleRequest$Action' => '<p>The action that DNS Firewall should take on a DNS query when it matches one of the domains in the rule\'s domain list:</p> <ul> <li> <p> <code>ALLOW</code> - Permit the request to go through.</p> </li> <li> <p> <code>ALERT</code> - Permit the request to go through but send an alert to the logs.</p> </li> <li> <p> <code>BLOCK</code> - Disallow the request. This option requires additional details in the rule\'s <code>BlockResponse</code>. </p> </li> </ul>', ], ], 'Arn' => [ 'base' => NULL, 'refs' => [ 'FirewallDomainList$Arn' => '<p>The Amazon Resource Name (ARN) of the firewall domain list.</p>', 'FirewallDomainListMetadata$Arn' => '<p>The Amazon Resource Name (ARN) of the firewall domain list metadata.</p>', 'FirewallRuleGroup$Arn' => '<p>The ARN (Amazon Resource Name) of the rule group.</p>', 'FirewallRuleGroupAssociation$Arn' => '<p>The Amazon Resource Name (ARN) of the firewall rule group association.</p>', 'FirewallRuleGroupMetadata$Arn' => '<p>The ARN (Amazon Resource Name) of the rule group.</p>', 'GetFirewallRuleGroupPolicyRequest$Arn' => '<p>The ARN (Amazon Resource Name) for the rule group.</p>', 'GetResolverQueryLogConfigPolicyRequest$Arn' => '<p>The ARN of the query logging configuration that you want to get the query logging policy for.</p>', 'GetResolverRulePolicyRequest$Arn' => '<p>The ID of the Resolver rule that you want to get the Resolver rule policy for.</p>', 'ListTagsForResourceRequest$ResourceArn' => '<p>The Amazon Resource Name (ARN) for the resource that you want to list tags for.</p>', 'PutFirewallRuleGroupPolicyRequest$Arn' => '<p>The ARN (Amazon Resource Name) for the rule group that you want to share.</p>', 'PutResolverQueryLogConfigPolicyRequest$Arn' => '<p>The Amazon Resource Name (ARN) of the account that you want to share rules with.</p>', 'PutResolverRulePolicyRequest$Arn' => '<p>The Amazon Resource Name (ARN) of the rule that you want to share with another account.</p>', 'ResolverEndpoint$Arn' => '<p>The ARN (Amazon Resource Name) for the Resolver endpoint.</p>', 'ResolverQueryLogConfig$Arn' => '<p>The ARN for the query logging configuration.</p>', 'ResolverRule$Arn' => '<p>The ARN (Amazon Resource Name) for the Resolver rule specified by <code>Id</code>.</p>', 'TagResourceRequest$ResourceArn' => '<p>The Amazon Resource Name (ARN) for the resource that you want to add tags to. To get the ARN for a resource, use the applicable <code>Get</code> or <code>List</code> command: </p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_GetResolverEndpoint.html">GetResolverEndpoint</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_GetResolverRule.html">GetResolverRule</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_GetResolverRuleAssociation.html">GetResolverRuleAssociation</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_ListResolverEndpoints.html">ListResolverEndpoints</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_ListResolverRuleAssociations.html">ListResolverRuleAssociations</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_ListResolverRules.html">ListResolverRules</a> </p> </li> </ul>', 'UntagResourceRequest$ResourceArn' => '<p>The Amazon Resource Name (ARN) for the resource that you want to remove tags from. To get the ARN for a resource, use the applicable <code>Get</code> or <code>List</code> command: </p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_GetResolverEndpoint.html">GetResolverEndpoint</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_GetResolverRule.html">GetResolverRule</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_GetResolverRuleAssociation.html">GetResolverRuleAssociation</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_ListResolverEndpoints.html">ListResolverEndpoints</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_ListResolverRuleAssociations.html">ListResolverRuleAssociations</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_ListResolverRules.html">ListResolverRules</a> </p> </li> </ul>', ], ], 'AssociateFirewallRuleGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'AssociateFirewallRuleGroupResponse' => [ 'base' => NULL, 'refs' => [], ], 'AssociateResolverEndpointIpAddressRequest' => [ 'base' => NULL, 'refs' => [], ], 'AssociateResolverEndpointIpAddressResponse' => [ 'base' => NULL, 'refs' => [], ], 'AssociateResolverQueryLogConfigRequest' => [ 'base' => NULL, 'refs' => [], ], 'AssociateResolverQueryLogConfigResponse' => [ 'base' => NULL, 'refs' => [], ], 'AssociateResolverRuleRequest' => [ 'base' => NULL, 'refs' => [], ], 'AssociateResolverRuleResponse' => [ 'base' => NULL, 'refs' => [], ], 'BlockOverrideDnsType' => [ 'base' => NULL, 'refs' => [ 'CreateFirewallRuleRequest$BlockOverrideDnsType' => '<p>The DNS record\'s type. This determines the format of the record value that you provided in <code>BlockOverrideDomain</code>. Used for the rule action <code>BLOCK</code> with a <code>BlockResponse</code> setting of <code>OVERRIDE</code>.</p> <p>This setting is required if the <code>BlockResponse</code> setting is <code>OVERRIDE</code>.</p>', 'FirewallRule$BlockOverrideDnsType' => '<p>The DNS record\'s type. This determines the format of the record value that you provided in <code>BlockOverrideDomain</code>. Used for the rule action <code>BLOCK</code> with a <code>BlockResponse</code> setting of <code>OVERRIDE</code>.</p>', 'UpdateFirewallRuleRequest$BlockOverrideDnsType' => '<p>The DNS record\'s type. This determines the format of the record value that you provided in <code>BlockOverrideDomain</code>. Used for the rule action <code>BLOCK</code> with a <code>BlockResponse</code> setting of <code>OVERRIDE</code>.</p>', ], ], 'BlockOverrideDomain' => [ 'base' => NULL, 'refs' => [ 'CreateFirewallRuleRequest$BlockOverrideDomain' => '<p>The custom DNS record to send back in response to the query. Used for the rule action <code>BLOCK</code> with a <code>BlockResponse</code> setting of <code>OVERRIDE</code>.</p> <p>This setting is required if the <code>BlockResponse</code> setting is <code>OVERRIDE</code>.</p>', 'FirewallRule$BlockOverrideDomain' => '<p>The custom DNS record to send back in response to the query. Used for the rule action <code>BLOCK</code> with a <code>BlockResponse</code> setting of <code>OVERRIDE</code>.</p>', 'UpdateFirewallRuleRequest$BlockOverrideDomain' => '<p>The custom DNS record to send back in response to the query. Used for the rule action <code>BLOCK</code> with a <code>BlockResponse</code> setting of <code>OVERRIDE</code>.</p>', ], ], 'BlockOverrideTtl' => [ 'base' => NULL, 'refs' => [ 'CreateFirewallRuleRequest$BlockOverrideTtl' => '<p>The recommended amount of time, in seconds, for the DNS resolver or web browser to cache the provided override record. Used for the rule action <code>BLOCK</code> with a <code>BlockResponse</code> setting of <code>OVERRIDE</code>.</p> <p>This setting is required if the <code>BlockResponse</code> setting is <code>OVERRIDE</code>.</p>', 'UpdateFirewallRuleRequest$BlockOverrideTtl' => '<p>The recommended amount of time, in seconds, for the DNS resolver or web browser to cache the provided override record. Used for the rule action <code>BLOCK</code> with a <code>BlockResponse</code> setting of <code>OVERRIDE</code>.</p>', ], ], 'BlockResponse' => [ 'base' => NULL, 'refs' => [ 'CreateFirewallRuleRequest$BlockResponse' => '<p>The way that you want DNS Firewall to block the request, used with the rule action setting <code>BLOCK</code>. </p> <ul> <li> <p> <code>NODATA</code> - Respond indicating that the query was successful, but no response is available for it.</p> </li> <li> <p> <code>NXDOMAIN</code> - Respond indicating that the domain name that\'s in the query doesn\'t exist.</p> </li> <li> <p> <code>OVERRIDE</code> - Provide a custom override in the response. This option requires custom handling details in the rule\'s <code>BlockOverride*</code> settings. </p> </li> </ul> <p>This setting is required if the rule action setting is <code>BLOCK</code>.</p>', 'FirewallRule$BlockResponse' => '<p>The way that you want DNS Firewall to block the request. Used for the rule action setting <code>BLOCK</code>.</p> <ul> <li> <p> <code>NODATA</code> - Respond indicating that the query was successful, but no response is available for it.</p> </li> <li> <p> <code>NXDOMAIN</code> - Respond indicating that the domain name that\'s in the query doesn\'t exist.</p> </li> <li> <p> <code>OVERRIDE</code> - Provide a custom override in the response. This option requires custom handling details in the rule\'s <code>BlockOverride*</code> settings. </p> </li> </ul>', 'UpdateFirewallRuleRequest$BlockResponse' => '<p>The way that you want DNS Firewall to block the request. Used for the rule action setting <code>BLOCK</code>.</p> <ul> <li> <p> <code>NODATA</code> - Respond indicating that the query was successful, but no response is available for it.</p> </li> <li> <p> <code>NXDOMAIN</code> - Respond indicating that the domain name that\'s in the query doesn\'t exist.</p> </li> <li> <p> <code>OVERRIDE</code> - Provide a custom override in the response. This option requires custom handling details in the rule\'s <code>BlockOverride*</code> settings. </p> </li> </ul>', ], ], 'Boolean' => [ 'base' => NULL, 'refs' => [ 'PutFirewallRuleGroupPolicyResponse$ReturnValue' => '<p/>', 'PutResolverQueryLogConfigPolicyResponse$ReturnValue' => '<p>Whether the <code>PutResolverQueryLogConfigPolicy</code> request was successful.</p>', 'PutResolverRulePolicyResponse$ReturnValue' => '<p>Whether the <code>PutResolverRulePolicy</code> request was successful.</p>', ], ], 'ConflictException' => [ 'base' => '<p/>', 'refs' => [], ], 'Count' => [ 'base' => NULL, 'refs' => [ 'ListResolverQueryLogConfigAssociationsResponse$TotalCount' => '<p>The total number of query logging associations that were created by the current account in the specified Region. This count can differ from the number of associations that are returned in a <code>ListResolverQueryLogConfigAssociations</code> response, depending on the values that you specify in the request.</p>', 'ListResolverQueryLogConfigAssociationsResponse$TotalFilteredCount' => '<p>The total number of query logging associations that were created by the current account in the specified Region and that match the filters that were specified in the <code>ListResolverQueryLogConfigAssociations</code> request. For the total number of associations that were created by the current account in the specified Region, see <code>TotalCount</code>.</p>', 'ListResolverQueryLogConfigsResponse$TotalCount' => '<p>The total number of query logging configurations that were created by the current account in the specified Region. This count can differ from the number of query logging configurations that are returned in a <code>ListResolverQueryLogConfigs</code> response, depending on the values that you specify in the request.</p>', 'ListResolverQueryLogConfigsResponse$TotalFilteredCount' => '<p>The total number of query logging configurations that were created by the current account in the specified Region and that match the filters that were specified in the <code>ListResolverQueryLogConfigs</code> request. For the total number of query logging configurations that were created by the current account in the specified Region, see <code>TotalCount</code>.</p>', 'ResolverQueryLogConfig$AssociationCount' => '<p>The number of VPCs that are associated with the query logging configuration.</p>', ], ], 'CreateFirewallDomainListRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateFirewallDomainListResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateFirewallRuleGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateFirewallRuleGroupResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateFirewallRuleRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateFirewallRuleResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateResolverEndpointRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateResolverEndpointResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateResolverQueryLogConfigRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateResolverQueryLogConfigResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateResolverRuleRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateResolverRuleResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreatorRequestId' => [ 'base' => NULL, 'refs' => [ 'AssociateFirewallRuleGroupRequest$CreatorRequestId' => '<p>A unique string that identifies the request and that allows failed requests to be retried without the risk of running the operation twice. <code>CreatorRequestId</code> can be any unique string, for example, a date/time stamp. </p>', 'CreateFirewallDomainListRequest$CreatorRequestId' => '<p>A unique string that identifies the request and that allows you to retry failed requests without the risk of running the operation twice. <code>CreatorRequestId</code> can be any unique string, for example, a date/time stamp. </p>', 'CreateFirewallRuleGroupRequest$CreatorRequestId' => '<p>A unique string defined by you to identify the request. This allows you to retry failed requests without the risk of running the operation twice. This can be any unique string, for example, a timestamp. </p>', 'CreateFirewallRuleRequest$CreatorRequestId' => '<p>A unique string that identifies the request and that allows you to retry failed requests without the risk of running the operation twice. <code>CreatorRequestId</code> can be any unique string, for example, a date/time stamp. </p>', 'CreateResolverEndpointRequest$CreatorRequestId' => '<p>A unique string that identifies the request and that allows failed requests to be retried without the risk of running the operation twice. <code>CreatorRequestId</code> can be any unique string, for example, a date/time stamp. </p>', 'CreateResolverQueryLogConfigRequest$CreatorRequestId' => '<p>A unique string that identifies the request and that allows failed requests to be retried without the risk of running the operation twice. <code>CreatorRequestId</code> can be any unique string, for example, a date/time stamp. </p>', 'CreateResolverRuleRequest$CreatorRequestId' => '<p>A unique string that identifies the request and that allows failed requests to be retried without the risk of running the operation twice. <code>CreatorRequestId</code> can be any unique string, for example, a date/time stamp. </p>', 'FirewallDomainList$CreatorRequestId' => '<p>A unique string defined by you to identify the request. This allows you to retry failed requests without the risk of running the operation twice. This can be any unique string, for example, a timestamp. </p>', 'FirewallDomainListMetadata$CreatorRequestId' => '<p>A unique string defined by you to identify the request. This allows you to retry failed requests without the risk of running the operation twice. This can be any unique string, for example, a timestamp. </p>', 'FirewallRule$CreatorRequestId' => '<p>A unique string defined by you to identify the request. This allows you to retry failed requests without the risk of executing the operation twice. This can be any unique string, for example, a timestamp. </p>', 'FirewallRuleGroup$CreatorRequestId' => '<p>A unique string defined by you to identify the request. This allows you to retry failed requests without the risk of running the operation twice. This can be any unique string, for example, a timestamp. </p>', 'FirewallRuleGroupAssociation$CreatorRequestId' => '<p>A unique string defined by you to identify the request. This allows you to retry failed requests without the risk of running the operation twice. This can be any unique string, for example, a timestamp. </p>', 'FirewallRuleGroupMetadata$CreatorRequestId' => '<p>A unique string defined by you to identify the request. This allows you to retry failed requests without the risk of running the operation twice. This can be any unique string, for example, a timestamp. </p>', 'ResolverEndpoint$CreatorRequestId' => '<p>A unique string that identifies the request that created the Resolver endpoint. The <code>CreatorRequestId</code> allows failed requests to be retried without the risk of running the operation twice.</p>', 'ResolverQueryLogConfig$CreatorRequestId' => '<p>A unique string that identifies the request that created the query logging configuration. The <code>CreatorRequestId</code> allows failed requests to be retried without the risk of running the operation twice.</p>', 'ResolverRule$CreatorRequestId' => '<p>A unique string that you specified when you created the Resolver rule. <code>CreatorRequestId</code> identifies the request and allows failed requests to be retried without the risk of running the operation twice. </p>', ], ], 'DeleteFirewallDomainListRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteFirewallDomainListResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteFirewallRuleGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteFirewallRuleGroupResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteFirewallRuleRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteFirewallRuleResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteResolverEndpointRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteResolverEndpointResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteResolverQueryLogConfigRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteResolverQueryLogConfigResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteResolverRuleRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteResolverRuleResponse' => [ 'base' => NULL, 'refs' => [], ], 'DestinationArn' => [ 'base' => NULL, 'refs' => [ 'CreateResolverQueryLogConfigRequest$DestinationArn' => '<p>The ARN of the resource that you want Resolver to send query logs. You can send query logs to an S3 bucket, a CloudWatch Logs log group, or a Kinesis Data Firehose delivery stream. Examples of valid values include the following:</p> <ul> <li> <p> <b>S3 bucket</b>: </p> <p> <code>arn:aws:s3:::examplebucket</code> </p> <p>You can optionally append a file prefix to the end of the ARN.</p> <p> <code>arn:aws:s3:::examplebucket/development/</code> </p> </li> <li> <p> <b>CloudWatch Logs log group</b>: </p> <p> <code>arn:aws:logs:us-west-1:123456789012:log-group:/mystack-testgroup-12ABC1AB12A1:*</code> </p> </li> <li> <p> <b>Kinesis Data Firehose delivery stream</b>:</p> <p> <code>arn:aws:kinesis:us-east-2:0123456789:stream/my_stream_name</code> </p> </li> </ul>', 'ResolverQueryLogConfig$DestinationArn' => '<p>The ARN of the resource that you want Resolver to send query logs: an Amazon S3 bucket, a CloudWatch Logs log group, or a Kinesis Data Firehose delivery stream.</p>', ], ], 'DisassociateFirewallRuleGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateFirewallRuleGroupResponse' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateResolverEndpointIpAddressRequest' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateResolverEndpointIpAddressResponse' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateResolverQueryLogConfigRequest' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateResolverQueryLogConfigResponse' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateResolverRuleRequest' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateResolverRuleResponse' => [ 'base' => NULL, 'refs' => [], ], 'DomainListFileUrl' => [ 'base' => NULL, 'refs' => [ 'ImportFirewallDomainsRequest$DomainFileUrl' => '<p>The fully qualified URL or URI of the file stored in Amazon Simple Storage Service (Amazon S3) that contains the list of domains to import.</p> <p>The file must be in an S3 bucket that\'s in the same Region as your DNS Firewall. The file must be a text file and must contain a single domain per line.</p>', ], ], 'DomainName' => [ 'base' => NULL, 'refs' => [ 'CreateResolverRuleRequest$DomainName' => '<p>DNS queries for this domain name are forwarded to the IP addresses that you specify in <code>TargetIps</code>. If a query matches multiple Resolver rules (example.com and www.example.com), outbound DNS queries are routed using the Resolver rule that contains the most specific domain name (www.example.com).</p>', 'ResolverRule$DomainName' => '<p>DNS queries for this domain name are forwarded to the IP addresses that are specified in <code>TargetIps</code>. If a query matches multiple Resolver rules (example.com and www.example.com), the query is routed using the Resolver rule that contains the most specific domain name (www.example.com).</p>', ], ], 'ExceptionMessage' => [ 'base' => NULL, 'refs' => [ 'AccessDeniedException$Message' => NULL, 'ConflictException$Message' => NULL, 'InternalServiceErrorException$Message' => NULL, 'InvalidParameterException$Message' => NULL, 'InvalidPolicyDocument$Message' => NULL, 'InvalidRequestException$Message' => NULL, 'InvalidTagException$Message' => NULL, 'ThrottlingException$Message' => NULL, 'UnknownResourceException$Message' => NULL, 'ValidationException$Message' => NULL, ], ], 'Filter' => [ 'base' => '<p>For Resolver list operations (<a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_ListResolverEndpoints.html">ListResolverEndpoints</a>, <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_ListResolverRules.html">ListResolverRules</a>, <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_ListResolverRuleAssociations.html">ListResolverRuleAssociations</a>, <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_ListResolverQueryLogConfigs.html">ListResolverQueryLogConfigs</a>, <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_ListResolverQueryLogConfigAssociations.html">ListResolverQueryLogConfigAssociations</a>), and <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_ListResolverDnssecConfigs.html">ListResolverDnssecConfigs</a>), an optional specification to return a subset of objects.</p> <p>To filter objects, such as Resolver endpoints or Resolver rules, you specify <code>Name</code> and <code>Values</code>. For example, to list only inbound Resolver endpoints, specify <code>Direction</code> for <code>Name</code> and specify <code>INBOUND</code> for <code>Values</code>. </p>', 'refs' => [ 'Filters$member' => NULL, ], ], 'FilterName' => [ 'base' => NULL, 'refs' => [ 'Filter$Name' => '<p>The name of the parameter that you want to use to filter objects.</p> <p>The valid values for <code>Name</code> depend on the action that you\'re including the filter in, <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_ListResolverEndpoints.html">ListResolverEndpoints</a>, <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_ListResolverRules.html">ListResolverRules</a>, <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_ListResolverRuleAssociations.html">ListResolverRuleAssociations</a>, <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_ListResolverQueryLogConfigs.html">ListResolverQueryLogConfigs</a>, or <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_ListResolverQueryLogConfigAssociations.html">ListResolverQueryLogConfigAssociations</a>.</p> <note> <p>In early versions of Resolver, values for <code>Name</code> were listed as uppercase, with underscore (_) delimiters. For example, <code>CreatorRequestId</code> was originally listed as <code>CREATOR_REQUEST_ID</code>. Uppercase values for <code>Name</code> are still supported.</p> </note> <p> <b>ListResolverEndpoints</b> </p> <p>Valid values for <code>Name</code> include the following:</p> <ul> <li> <p> <code>CreatorRequestId</code>: The value that you specified when you created the Resolver endpoint.</p> </li> <li> <p> <code>Direction</code>: Whether you want to return inbound or outbound Resolver endpoints. If you specify <code>DIRECTION</code> for <code>Name</code>, specify <code>INBOUND</code> or <code>OUTBOUND</code> for <code>Values</code>.</p> </li> <li> <p> <code>HostVPCId</code>: The ID of the VPC that inbound DNS queries pass through on the way from your network to your VPCs in a region, or the VPC that outbound queries pass through on the way from your VPCs to your network. In a <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_CreateResolverEndpoint.html">CreateResolverEndpoint</a> request, <code>SubnetId</code> indirectly identifies the VPC. In a <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_GetResolverEndpoint.html">GetResolverEndpoint</a> request, the VPC ID for a Resolver endpoint is returned in the <code>HostVPCId</code> element. </p> </li> <li> <p> <code>IpAddressCount</code>: The number of IP addresses that you have associated with the Resolver endpoint.</p> </li> <li> <p> <code>Name</code>: The name of the Resolver endpoint.</p> </li> <li> <p> <code>SecurityGroupIds</code>: The IDs of the VPC security groups that you specified when you created the Resolver endpoint.</p> </li> <li> <p> <code>Status</code>: The status of the Resolver endpoint. If you specify <code>Status</code> for <code>Name</code>, specify one of the following status codes for <code>Values</code>: <code>CREATING</code>, <code>OPERATIONAL</code>, <code>UPDATING</code>, <code>AUTO_RECOVERING</code>, <code>ACTION_NEEDED</code>, or <code>DELETING</code>. For more information, see <code>Status</code> in <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_ResolverEndpoint.html">ResolverEndpoint</a>.</p> </li> </ul> <p> <b>ListResolverRules</b> </p> <p>Valid values for <code>Name</code> include the following:</p> <ul> <li> <p> <code>CreatorRequestId</code>: The value that you specified when you created the Resolver rule.</p> </li> <li> <p> <code>DomainName</code>: The domain name for which Resolver is forwarding DNS queries to your network. In the value that you specify for <code>Values</code>, include a trailing dot (.) after the domain name. For example, if the domain name is example.com, specify the following value. Note the "." after <code>com</code>:</p> <p> <code>example.com.</code> </p> </li> <li> <p> <code>Name</code>: The name of the Resolver rule.</p> </li> <li> <p> <code>ResolverEndpointId</code>: The ID of the Resolver endpoint that the Resolver rule is associated with.</p> <note> <p>You can filter on the Resolver endpoint only for rules that have a value of <code>FORWARD</code> for <code>RuleType</code>.</p> </note> </li> <li> <p> <code>Status</code>: The status of the Resolver rule. If you specify <code>Status</code> for <code>Name</code>, specify one of the following status codes for <code>Values</code>: <code>COMPLETE</code>, <code>DELETING</code>, <code>UPDATING</code>, or <code>FAILED</code>.</p> </li> <li> <p> <code>Type</code>: The type of the Resolver rule. If you specify <code>TYPE</code> for <code>Name</code>, specify <code>FORWARD</code> or <code>SYSTEM</code> for <code>Values</code>.</p> </li> </ul> <p> <b>ListResolverRuleAssociations</b> </p> <p>Valid values for <code>Name</code> include the following:</p> <ul> <li> <p> <code>Name</code>: The name of the Resolver rule association.</p> </li> <li> <p> <code>ResolverRuleId</code>: The ID of the Resolver rule that is associated with one or more VPCs.</p> </li> <li> <p> <code>Status</code>: The status of the Resolver rule association. If you specify <code>Status</code> for <code>Name</code>, specify one of the following status codes for <code>Values</code>: <code>CREATING</code>, <code>COMPLETE</code>, <code>DELETING</code>, or <code>FAILED</code>.</p> </li> <li> <p> <code>VPCId</code>: The ID of the VPC that the Resolver rule is associated with.</p> </li> </ul> <p> <b>ListResolverQueryLogConfigs</b> </p> <p>Valid values for <code>Name</code> include the following:</p> <ul> <li> <p> <code>Arn</code>: The ARN for the query logging configuration.</p> </li> <li> <p> <code>AssociationCount</code>: The number of VPCs that are associated with the query logging configuration.</p> </li> <li> <p> <code>CreationTime</code>: The date and time that the query logging configuration was created, in Unix time format and Coordinated Universal Time (UTC). </p> </li> <li> <p> <code>CreatorRequestId</code>: A unique string that identifies the request that created the query logging configuration.</p> </li> <li> <p> <code>Destination</code>: The Amazon Web Services service that you want to forward query logs to. Valid values include the following:</p> <ul> <li> <p> <code>S3</code> </p> </li> <li> <p> <code>CloudWatchLogs</code> </p> </li> <li> <p> <code>KinesisFirehose</code> </p> </li> </ul> </li> <li> <p> <code>DestinationArn</code>: The ARN of the location that Resolver is sending query logs to. This value can be the ARN for an S3 bucket, a CloudWatch Logs log group, or a Kinesis Data Firehose delivery stream.</p> </li> <li> <p> <code>Id</code>: The ID of the query logging configuration</p> </li> <li> <p> <code>Name</code>: The name of the query logging configuration</p> </li> <li> <p> <code>OwnerId</code>: The Amazon Web Services account ID for the account that created the query logging configuration.</p> </li> <li> <p> <code>ShareStatus</code>: An indication of whether the query logging configuration is shared with other Amazon Web Services accounts, or was shared with the current account by another Amazon Web Services account. Valid values include: <code>NOT_SHARED</code>, <code>SHARED_WITH_ME</code>, or <code>SHARED_BY_ME</code>.</p> </li> <li> <p> <code>Status</code>: The status of the query logging configuration. If you specify <code>Status</code> for <code>Name</code>, specify the applicable status code for <code>Values</code>: <code>CREATING</code>, <code>CREATED</code>, <code>DELETING</code>, or <code>FAILED</code>. For more information, see <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_ResolverQueryLogConfig.html#Route53Resolver-Type-route53resolver_ResolverQueryLogConfig-Status">Status</a>. </p> </li> </ul> <p> <b>ListResolverQueryLogConfigAssociations</b> </p> <p>Valid values for <code>Name</code> include the following:</p> <ul> <li> <p> <code>CreationTime</code>: The date and time that the VPC was associated with the query logging configuration, in Unix time format and Coordinated Universal Time (UTC).</p> </li> <li> <p> <code>Error</code>: If the value of <code>Status</code> is <code>FAILED</code>, specify the cause: <code>DESTINATION_NOT_FOUND</code> or <code>ACCESS_DENIED</code>.</p> </li> <li> <p> <code>Id</code>: The ID of the query logging association.</p> </li> <li> <p> <code>ResolverQueryLogConfigId</code>: The ID of the query logging configuration that a VPC is associated with.</p> </li> <li> <p> <code>ResourceId</code>: The ID of the Amazon VPC that is associated with the query logging configuration.</p> </li> <li> <p> <code>Status</code>: The status of the query logging association. If you specify <code>Status</code> for <code>Name</code>, specify the applicable status code for <code>Values</code>: <code>CREATING</code>, <code>CREATED</code>, <code>DELETING</code>, or <code>FAILED</code>. For more information, see <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_ResolverQueryLogConfigAssociation.html#Route53Resolver-Type-route53resolver_ResolverQueryLogConfigAssociation-Status">Status</a>. </p> </li> </ul>', ], ], 'FilterValue' => [ 'base' => NULL, 'refs' => [ 'FilterValues$member' => NULL, ], ], 'FilterValues' => [ 'base' => NULL, 'refs' => [ 'Filter$Values' => '<p>When you\'re using a <code>List</code> operation and you want the operation to return a subset of objects, such as Resolver endpoints or Resolver rules, the value of the parameter that you want to use to filter objects. For example, to list only inbound Resolver endpoints, specify <code>Direction</code> for <code>Name</code> and specify <code>INBOUND</code> for <code>Values</code>.</p>', ], ], 'Filters' => [ 'base' => NULL, 'refs' => [ 'ListResolverDnssecConfigsRequest$Filters' => '<p>An optional specification to return a subset of objects.</p>', 'ListResolverEndpointsRequest$Filters' => '<p>An optional specification to return a subset of Resolver endpoints, such as all inbound Resolver endpoints.</p> <note> <p>If you submit a second or subsequent <code>ListResolverEndpoints</code> request and specify the <code>NextToken</code> parameter, you must use the same values for <code>Filters</code>, if any, as in the previous request.</p> </note>', 'ListResolverQueryLogConfigAssociationsRequest$Filters' => '<p>An optional specification to return a subset of query logging associations.</p> <note> <p>If you submit a second or subsequent <code>ListResolverQueryLogConfigAssociations</code> request and specify the <code>NextToken</code> parameter, you must use the same values for <code>Filters</code>, if any, as in the previous request.</p> </note>', 'ListResolverQueryLogConfigsRequest$Filters' => '<p>An optional specification to return a subset of query logging configurations.</p> <note> <p>If you submit a second or subsequent <code>ListResolverQueryLogConfigs</code> request and specify the <code>NextToken</code> parameter, you must use the same values for <code>Filters</code>, if any, as in the previous request.</p> </note>', 'ListResolverRuleAssociationsRequest$Filters' => '<p>An optional specification to return a subset of Resolver rules, such as Resolver rules that are associated with the same VPC ID.</p> <note> <p>If you submit a second or subsequent <code>ListResolverRuleAssociations</code> request and specify the <code>NextToken</code> parameter, you must use the same values for <code>Filters</code>, if any, as in the previous request.</p> </note>', 'ListResolverRulesRequest$Filters' => '<p>An optional specification to return a subset of Resolver rules, such as all Resolver rules that are associated with the same Resolver endpoint.</p> <note> <p>If you submit a second or subsequent <code>ListResolverRules</code> request and specify the <code>NextToken</code> parameter, you must use the same values for <code>Filters</code>, if any, as in the previous request.</p> </note>', ], ], 'FirewallConfig' => [ 'base' => '<p>Configuration of the firewall behavior provided by DNS Firewall for a single VPC from Amazon Virtual Private Cloud (Amazon VPC). </p>', 'refs' => [ 'FirewallConfigList$member' => NULL, 'GetFirewallConfigResponse$FirewallConfig' => '<p>Configuration of the firewall behavior provided by DNS Firewall for a single VPC from AmazonVPC. </p>', 'UpdateFirewallConfigResponse$FirewallConfig' => '<p>Configuration of the firewall behavior provided by DNS Firewall for a single VPC. </p>', ], ], 'FirewallConfigList' => [ 'base' => NULL, 'refs' => [ 'ListFirewallConfigsResponse$FirewallConfigs' => '<p>The configurations for the firewall behavior provided by DNS Firewall for VPCs from Amazon Virtual Private Cloud (Amazon VPC). </p>', ], ], 'FirewallDomainImportOperation' => [ 'base' => NULL, 'refs' => [ 'ImportFirewallDomainsRequest$Operation' => '<p>What you want DNS Firewall to do with the domains that are listed in the file. This must be set to <code>REPLACE</code>, which updates the domain list to exactly match the list in the file. </p>', ], ], 'FirewallDomainList' => [ 'base' => '<p>High-level information about a list of firewall domains for use in a <a>FirewallRule</a>. This is returned by <a>GetFirewallDomainList</a>.</p> <p>To retrieve the domains that are defined for this domain list, call <a>ListFirewallDomains</a>.</p>', 'refs' => [ 'CreateFirewallDomainListResponse$FirewallDomainList' => '<p>The domain list that you just created.</p>', 'DeleteFirewallDomainListResponse$FirewallDomainList' => '<p>The domain list that you just deleted. </p>', 'GetFirewallDomainListResponse$FirewallDomainList' => '<p>The domain list that you requested. </p>', ], ], 'FirewallDomainListMetadata' => [ 'base' => '<p>Minimal high-level information for a firewall domain list. The action <a>ListFirewallDomainLists</a> returns an array of these objects. </p> <p>To retrieve full information for a firewall domain list, call <a>GetFirewallDomainList</a> and <a>ListFirewallDomains</a>.</p>', 'refs' => [ 'FirewallDomainListMetadataList$member' => NULL, ], ], 'FirewallDomainListMetadataList' => [ 'base' => NULL, 'refs' => [ 'ListFirewallDomainListsResponse$FirewallDomainLists' => '<p>A list of the domain lists that you have defined. </p> <p>This might be a partial list of the domain lists that you\'ve defined. For information, see <code>MaxResults</code>. </p>', ], ], 'FirewallDomainListStatus' => [ 'base' => NULL, 'refs' => [ 'FirewallDomainList$Status' => '<p>The status of the domain list. </p>', 'ImportFirewallDomainsResponse$Status' => '<p> </p>', 'UpdateFirewallDomainsResponse$Status' => '<p> </p>', ], ], 'FirewallDomainName' => [ 'base' => NULL, 'refs' => [ 'FirewallDomains$member' => NULL, ], ], 'FirewallDomainUpdateOperation' => [ 'base' => NULL, 'refs' => [ 'UpdateFirewallDomainsRequest$Operation' => '<p>What you want DNS Firewall to do with the domains that you are providing: </p> <ul> <li> <p> <code>ADD</code> - Add the domains to the ones that are already in the domain list. </p> </li> <li> <p> <code>REMOVE</code> - Search the domain list for the domains and remove them from the list.</p> </li> <li> <p> <code>REPLACE</code> - Update the domain list to exactly match the list that you are providing. </p> </li> </ul>', ], ], 'FirewallDomains' => [ 'base' => NULL, 'refs' => [ 'ListFirewallDomainsResponse$Domains' => '<p>A list of the domains in the firewall domain list. </p> <p>This might be a partial list of the domains that you\'ve defined in the domain list. For information, see <code>MaxResults</code>. </p>', 'UpdateFirewallDomainsRequest$Domains' => '<p>A list of domains to use in the update operation.</p> <p>Each domain specification in your domain list must satisfy the following requirements: </p> <ul> <li> <p>It can optionally start with <code>*</code> (asterisk).</p> </li> <li> <p>With the exception of the optional starting asterisk, it must only contain the following characters: <code>A-Z</code>, <code>a-z</code>, <code>0-9</code>, <code>-</code> (hyphen).</p> </li> <li> <p>It must be from 1-255 characters in length. </p> </li> </ul>', ], ], 'FirewallFailOpenStatus' => [ 'base' => NULL, 'refs' => [ 'FirewallConfig$FirewallFailOpen' => '<p>Determines how DNS Firewall operates during failures, for example when all traffic that is sent to DNS Firewall fails to receive a reply. </p> <ul> <li> <p>By default, fail open is disabled, which means the failure mode is closed. This approach favors security over availability. DNS Firewall returns a failure error when it is unable to properly evaluate a query. </p> </li> <li> <p>If you enable this option, the failure mode is open. This approach favors availability over security. DNS Firewall allows queries to proceed if it is unable to properly evaluate them. </p> </li> </ul> <p>This behavior is only enforced for VPCs that have at least one DNS Firewall rule group association. </p>', 'UpdateFirewallConfigRequest$FirewallFailOpen' => '<p>Determines how Route 53 Resolver handles queries during failures, for example when all traffic that is sent to DNS Firewall fails to receive a reply. </p> <ul> <li> <p>By default, fail open is disabled, which means the failure mode is closed. This approach favors security over availability. DNS Firewall blocks queries that it is unable to evaluate properly. </p> </li> <li> <p>If you enable this option, the failure mode is open. This approach favors availability over security. DNS Firewall allows queries to proceed if it is unable to properly evaluate them. </p> </li> </ul> <p>This behavior is only enforced for VPCs that have at least one DNS Firewall rule group association. </p>', ], ], 'FirewallRule' => [ 'base' => '<p>A single firewall rule in a rule group.</p>', 'refs' => [ 'CreateFirewallRuleResponse$FirewallRule' => '<p>The firewall rule that you just created. </p>', 'DeleteFirewallRuleResponse$FirewallRule' => '<p>The specification for the firewall rule that you just deleted.</p>', 'FirewallRules$member' => NULL, 'UpdateFirewallRuleResponse$FirewallRule' => '<p>The firewall rule that you just updated. </p>', ], ], 'FirewallRuleGroup' => [ 'base' => '<p>High-level information for a firewall rule group. A firewall rule group is a collection of rules that DNS Firewall uses to filter DNS network traffic for a VPC. To retrieve the rules for the rule group, call <a>ListFirewallRules</a>.</p>', 'refs' => [ 'CreateFirewallRuleGroupResponse$FirewallRuleGroup' => '<p>A collection of rules used to filter DNS network traffic. </p>', 'DeleteFirewallRuleGroupResponse$FirewallRuleGroup' => '<p>A collection of rules used to filter DNS network traffic. </p>', 'GetFirewallRuleGroupResponse$FirewallRuleGroup' => '<p>A collection of rules used to filter DNS network traffic. </p>', ], ], 'FirewallRuleGroupAssociation' => [ 'base' => '<p>An association between a firewall rule group and a VPC, which enables DNS filtering for the VPC. </p>', 'refs' => [ 'AssociateFirewallRuleGroupResponse$FirewallRuleGroupAssociation' => '<p>The association that you just created. The association has an ID that you can use to identify it in other requests, like update and delete.</p>', 'DisassociateFirewallRuleGroupResponse$FirewallRuleGroupAssociation' => '<p>The firewall rule group association that you just removed. </p>', 'FirewallRuleGroupAssociations$member' => NULL, 'GetFirewallRuleGroupAssociationResponse$FirewallRuleGroupAssociation' => '<p>The association that you requested. </p>', 'UpdateFirewallRuleGroupAssociationResponse$FirewallRuleGroupAssociation' => '<p>The association that you just updated. </p>', ], ], 'FirewallRuleGroupAssociationStatus' => [ 'base' => NULL, 'refs' => [ 'FirewallRuleGroupAssociation$Status' => '<p>The current status of the association.</p>', 'ListFirewallRuleGroupAssociationsRequest$Status' => '<p>The association <code>Status</code> setting that you want DNS Firewall to filter on for the list. If you don\'t specify this, then DNS Firewall returns all associations, regardless of status.</p>', ], ], 'FirewallRuleGroupAssociations' => [ 'base' => NULL, 'refs' => [ 'ListFirewallRuleGroupAssociationsResponse$FirewallRuleGroupAssociations' => '<p>A list of your firewall rule group associations.</p> <p>This might be a partial list of the associations that you have defined. For information, see <code>MaxResults</code>. </p>', ], ], 'FirewallRuleGroupMetadata' => [ 'base' => '<p>Minimal high-level information for a firewall rule group. The action <a>ListFirewallRuleGroups</a> returns an array of these objects. </p> <p>To retrieve full information for a firewall rule group, call <a>GetFirewallRuleGroup</a> and <a>ListFirewallRules</a>.</p>', 'refs' => [ 'FirewallRuleGroupMetadataList$member' => NULL, ], ], 'FirewallRuleGroupMetadataList' => [ 'base' => NULL, 'refs' => [ 'ListFirewallRuleGroupsResponse$FirewallRuleGroups' => '<p>A list of your firewall rule groups.</p> <p>This might be a partial list of the rule groups that you have defined. For information, see <code>MaxResults</code>. </p>', ], ], 'FirewallRuleGroupPolicy' => [ 'base' => NULL, 'refs' => [ 'GetFirewallRuleGroupPolicyResponse$FirewallRuleGroupPolicy' => '<p>The Identity and Access Management (Amazon Web Services IAM) policy for sharing the specified rule group. You can use the policy to share the rule group using Resource Access Manager (RAM). </p>', 'PutFirewallRuleGroupPolicyRequest$FirewallRuleGroupPolicy' => '<p>The Identity and Access Management (Amazon Web Services IAM) policy to attach to the rule group.</p>', ], ], 'FirewallRuleGroupStatus' => [ 'base' => NULL, 'refs' => [ 'FirewallRuleGroup$Status' => '<p>The status of the domain list. </p>', ], ], 'FirewallRules' => [ 'base' => NULL, 'refs' => [ 'ListFirewallRulesResponse$FirewallRules' => '<p>A list of the rules that you have defined. </p> <p>This might be a partial list of the firewall rules that you\'ve defined. For information, see <code>MaxResults</code>. </p>', ], ], 'GetFirewallConfigRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetFirewallConfigResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetFirewallDomainListRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetFirewallDomainListResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetFirewallRuleGroupAssociationRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetFirewallRuleGroupAssociationResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetFirewallRuleGroupPolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetFirewallRuleGroupPolicyResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetFirewallRuleGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetFirewallRuleGroupResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetResolverDnssecConfigRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetResolverDnssecConfigResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetResolverEndpointRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetResolverEndpointResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetResolverQueryLogConfigAssociationRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetResolverQueryLogConfigAssociationResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetResolverQueryLogConfigPolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetResolverQueryLogConfigPolicyResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetResolverQueryLogConfigRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetResolverQueryLogConfigResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetResolverRuleAssociationRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetResolverRuleAssociationResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetResolverRulePolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetResolverRulePolicyResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetResolverRuleRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetResolverRuleResponse' => [ 'base' => NULL, 'refs' => [], ], 'ImportFirewallDomainsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ImportFirewallDomainsResponse' => [ 'base' => NULL, 'refs' => [], ], 'InternalServiceErrorException' => [ 'base' => '<p>We encountered an unknown error. Try again in a few minutes.</p>', 'refs' => [], ], 'InvalidNextTokenException' => [ 'base' => '<p>The value that you specified for <code>NextToken</code> in a <code>List</code> request isn\'t valid.</p>', 'refs' => [], ], 'InvalidParameterException' => [ 'base' => '<p>One or more parameters in this request are not valid.</p>', 'refs' => [], ], 'InvalidPolicyDocument' => [ 'base' => '<p>The specified Resolver rule policy is invalid.</p>', 'refs' => [], ], 'InvalidRequestException' => [ 'base' => '<p>The request is invalid.</p>', 'refs' => [], ], 'InvalidTagException' => [ 'base' => '<p>The specified tag is invalid.</p>', 'refs' => [], ], 'Ip' => [ 'base' => NULL, 'refs' => [ 'IpAddressRequest$Ip' => '<p>The IP address that you want to use for DNS queries.</p>', 'IpAddressResponse$Ip' => '<p>One IP address that the Resolver endpoint uses for DNS queries.</p>', 'IpAddressUpdate$Ip' => '<p>The new IP address.</p>', 'TargetAddress$Ip' => '<p>One IP address that you want to forward DNS queries to. You can specify only IPv4 addresses.</p>', ], ], 'IpAddressCount' => [ 'base' => NULL, 'refs' => [ 'ResolverEndpoint$IpAddressCount' => '<p>The number of IP addresses that the Resolver endpoint can use for DNS queries.</p>', ], ], 'IpAddressRequest' => [ 'base' => '<p>In a <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_CreateResolverEndpoint.html">CreateResolverEndpoint</a> request, the IP address that DNS queries originate from (for outbound endpoints) or that you forward DNS queries to (for inbound endpoints). <code>IpAddressRequest</code> also includes the ID of the subnet that contains the IP address.</p>', 'refs' => [ 'IpAddressesRequest$member' => NULL, ], ], 'IpAddressResponse' => [ 'base' => '<p>In the response to a <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_GetResolverEndpoint.html">GetResolverEndpoint</a> request, information about the IP addresses that the Resolver endpoint uses for DNS queries.</p>', 'refs' => [ 'IpAddressesResponse$member' => NULL, ], ], 'IpAddressStatus' => [ 'base' => NULL, 'refs' => [ 'IpAddressResponse$Status' => '<p>A status code that gives the current status of the request.</p>', ], ], 'IpAddressUpdate' => [ 'base' => '<p>In an <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_UpdateResolverEndpoint.html">UpdateResolverEndpoint</a> request, information about an IP address to update.</p>', 'refs' => [ 'AssociateResolverEndpointIpAddressRequest$IpAddress' => '<p>Either the IPv4 address that you want to add to a Resolver endpoint or a subnet ID. If you specify a subnet ID, Resolver chooses an IP address for you from the available IPs in the specified subnet.</p>', 'DisassociateResolverEndpointIpAddressRequest$IpAddress' => '<p>The IPv4 address that you want to remove from a Resolver endpoint.</p>', ], ], 'IpAddressesRequest' => [ 'base' => NULL, 'refs' => [ 'CreateResolverEndpointRequest$IpAddresses' => '<p>The subnets and IP addresses in your VPC that DNS queries originate from (for outbound endpoints) or that you forward DNS queries to (for inbound endpoints). The subnet ID uniquely identifies a VPC. </p>', ], ], 'IpAddressesResponse' => [ 'base' => NULL, 'refs' => [ 'ListResolverEndpointIpAddressesResponse$IpAddresses' => '<p>Information about the IP addresses in your VPC that DNS queries originate from (for outbound endpoints) or that you forward DNS queries to (for inbound endpoints).</p>', ], ], 'LimitExceededException' => [ 'base' => '<p>The request caused one or more limits to be exceeded.</p>', 'refs' => [], ], 'ListDomainMaxResults' => [ 'base' => NULL, 'refs' => [ 'ListFirewallDomainsRequest$MaxResults' => '<p>The maximum number of objects that you want Resolver to return for this request. If more objects are available, in the response, Resolver provides a <code>NextToken</code> value that you can use in a subsequent call to get the next batch of objects.</p> <p>If you don\'t specify a value for <code>MaxResults</code>, Resolver returns up to 100 objects. </p>', ], ], 'ListFirewallConfigsMaxResult' => [ 'base' => NULL, 'refs' => [ 'ListFirewallConfigsRequest$MaxResults' => '<p>The maximum number of objects that you want Resolver to return for this request. If more objects are available, in the response, Resolver provides a <code>NextToken</code> value that you can use in a subsequent call to get the next batch of objects.</p> <p>If you don\'t specify a value for <code>MaxResults</code>, Resolver returns up to 100 objects. </p>', ], ], 'ListFirewallConfigsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListFirewallConfigsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListFirewallDomainListsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListFirewallDomainListsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListFirewallDomainsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListFirewallDomainsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListFirewallRuleGroupAssociationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListFirewallRuleGroupAssociationsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListFirewallRuleGroupsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListFirewallRuleGroupsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListFirewallRulesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListFirewallRulesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListResolverDnssecConfigsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListResolverDnssecConfigsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListResolverEndpointIpAddressesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListResolverEndpointIpAddressesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListResolverEndpointsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListResolverEndpointsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListResolverQueryLogConfigAssociationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListResolverQueryLogConfigAssociationsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListResolverQueryLogConfigsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListResolverQueryLogConfigsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListResolverRuleAssociationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListResolverRuleAssociationsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListResolverRulesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListResolverRulesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'MaxResults' => [ 'base' => NULL, 'refs' => [ 'ListFirewallDomainListsRequest$MaxResults' => '<p>The maximum number of objects that you want Resolver to return for this request. If more objects are available, in the response, Resolver provides a <code>NextToken</code> value that you can use in a subsequent call to get the next batch of objects.</p> <p>If you don\'t specify a value for <code>MaxResults</code>, Resolver returns up to 100 objects. </p>', 'ListFirewallRuleGroupAssociationsRequest$MaxResults' => '<p>The maximum number of objects that you want Resolver to return for this request. If more objects are available, in the response, Resolver provides a <code>NextToken</code> value that you can use in a subsequent call to get the next batch of objects.</p> <p>If you don\'t specify a value for <code>MaxResults</code>, Resolver returns up to 100 objects. </p>', 'ListFirewallRuleGroupsRequest$MaxResults' => '<p>The maximum number of objects that you want Resolver to return for this request. If more objects are available, in the response, Resolver provides a <code>NextToken</code> value that you can use in a subsequent call to get the next batch of objects.</p> <p>If you don\'t specify a value for <code>MaxResults</code>, Resolver returns up to 100 objects. </p>', 'ListFirewallRulesRequest$MaxResults' => '<p>The maximum number of objects that you want Resolver to return for this request. If more objects are available, in the response, Resolver provides a <code>NextToken</code> value that you can use in a subsequent call to get the next batch of objects.</p> <p>If you don\'t specify a value for <code>MaxResults</code>, Resolver returns up to 100 objects. </p>', 'ListResolverDnssecConfigsRequest$MaxResults' => '<p> <i>Optional</i>: An integer that specifies the maximum number of DNSSEC configuration results that you want Amazon Route 53 to return. If you don\'t specify a value for <code>MaxResults</code>, Route 53 returns up to 100 configuration per page.</p>', 'ListResolverEndpointIpAddressesRequest$MaxResults' => '<p>The maximum number of IP addresses that you want to return in the response to a <code>ListResolverEndpointIpAddresses</code> request. If you don\'t specify a value for <code>MaxResults</code>, Resolver returns up to 100 IP addresses. </p>', 'ListResolverEndpointIpAddressesResponse$MaxResults' => '<p>The value that you specified for <code>MaxResults</code> in the request.</p>', 'ListResolverEndpointsRequest$MaxResults' => '<p>The maximum number of Resolver endpoints that you want to return in the response to a <code>ListResolverEndpoints</code> request. If you don\'t specify a value for <code>MaxResults</code>, Resolver returns up to 100 Resolver endpoints. </p>', 'ListResolverEndpointsResponse$MaxResults' => '<p>The value that you specified for <code>MaxResults</code> in the request.</p>', 'ListResolverQueryLogConfigAssociationsRequest$MaxResults' => '<p>The maximum number of query logging associations that you want to return in the response to a <code>ListResolverQueryLogConfigAssociations</code> request. If you don\'t specify a value for <code>MaxResults</code>, Resolver returns up to 100 query logging associations. </p>', 'ListResolverQueryLogConfigsRequest$MaxResults' => '<p>The maximum number of query logging configurations that you want to return in the response to a <code>ListResolverQueryLogConfigs</code> request. If you don\'t specify a value for <code>MaxResults</code>, Resolver returns up to 100 query logging configurations. </p>', 'ListResolverRuleAssociationsRequest$MaxResults' => '<p>The maximum number of rule associations that you want to return in the response to a <code>ListResolverRuleAssociations</code> request. If you don\'t specify a value for <code>MaxResults</code>, Resolver returns up to 100 rule associations. </p>', 'ListResolverRuleAssociationsResponse$MaxResults' => '<p>The value that you specified for <code>MaxResults</code> in the request.</p>', 'ListResolverRulesRequest$MaxResults' => '<p>The maximum number of Resolver rules that you want to return in the response to a <code>ListResolverRules</code> request. If you don\'t specify a value for <code>MaxResults</code>, Resolver returns up to 100 Resolver rules.</p>', 'ListResolverRulesResponse$MaxResults' => '<p>The value that you specified for <code>MaxResults</code> in the request.</p>', 'ListTagsForResourceRequest$MaxResults' => '<p>The maximum number of tags that you want to return in the response to a <code>ListTagsForResource</code> request. If you don\'t specify a value for <code>MaxResults</code>, Resolver returns up to 100 tags.</p>', ], ], 'MutationProtectionStatus' => [ 'base' => NULL, 'refs' => [ 'AssociateFirewallRuleGroupRequest$MutationProtection' => '<p>If enabled, this setting disallows modification or removal of the association, to help prevent against accidentally altering DNS firewall protections. When you create the association, the default setting is <code>DISABLED</code>. </p>', 'FirewallRuleGroupAssociation$MutationProtection' => '<p>If enabled, this setting disallows modification or removal of the association, to help prevent against accidentally altering DNS firewall protections. </p>', 'UpdateFirewallRuleGroupAssociationRequest$MutationProtection' => '<p>If enabled, this setting disallows modification or removal of the association, to help prevent against accidentally altering DNS firewall protections. </p>', ], ], 'Name' => [ 'base' => NULL, 'refs' => [ 'AssociateFirewallRuleGroupRequest$Name' => '<p>A name that lets you identify the association, to manage and use it.</p>', 'AssociateResolverRuleRequest$Name' => '<p>A name for the association that you\'re creating between a Resolver rule and a VPC.</p>', 'CreateFirewallDomainListRequest$Name' => '<p>A name that lets you identify the domain list to manage and use it.</p>', 'CreateFirewallRuleGroupRequest$Name' => '<p>A name that lets you identify the rule group, to manage and use it.</p>', 'CreateFirewallRuleRequest$Name' => '<p>A name that lets you identify the rule in the rule group.</p>', 'CreateResolverEndpointRequest$Name' => '<p>A friendly name that lets you easily find a configuration in the Resolver dashboard in the Route 53 console.</p>', 'CreateResolverRuleRequest$Name' => '<p>A friendly name that lets you easily find a rule in the Resolver dashboard in the Route 53 console.</p>', 'FirewallDomainList$Name' => '<p>The name of the domain list. </p>', 'FirewallDomainListMetadata$Name' => '<p>The name of the domain list. </p>', 'FirewallRule$Name' => '<p>The name of the rule. </p>', 'FirewallRuleGroup$Name' => '<p>The name of the rule group.</p>', 'FirewallRuleGroupAssociation$Name' => '<p>The name of the association.</p>', 'FirewallRuleGroupMetadata$Name' => '<p>The name of the rule group.</p>', 'ImportFirewallDomainsResponse$Name' => '<p>The name of the domain list. </p>', 'ResolverEndpoint$Name' => '<p>The name that you assigned to the Resolver endpoint when you submitted a <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_CreateResolverEndpoint.html">CreateResolverEndpoint</a> request.</p>', 'ResolverRule$Name' => '<p>The name for the Resolver rule, which you specified when you created the Resolver rule.</p>', 'ResolverRuleAssociation$Name' => '<p>The name of an association between a Resolver rule and a VPC.</p>', 'ResolverRuleConfig$Name' => '<p>The new name for the Resolver rule. The name that you specify appears in the Resolver dashboard in the Route 53 console. </p>', 'UpdateFirewallDomainsResponse$Name' => '<p>The name of the domain list. </p>', 'UpdateFirewallRuleGroupAssociationRequest$Name' => '<p>The name of the rule group association.</p>', 'UpdateFirewallRuleRequest$Name' => '<p>The name of the rule.</p>', 'UpdateResolverEndpointRequest$Name' => '<p>The name of the Resolver endpoint that you want to update.</p>', ], ], 'NextToken' => [ 'base' => NULL, 'refs' => [ 'ListFirewallConfigsRequest$NextToken' => '<p>For the first call to this list request, omit this value.</p> <p>When you request a list of objects, Resolver returns at most the number of objects specified in <code>MaxResults</code>. If more objects are available for retrieval, Resolver returns a <code>NextToken</code> value in the response. To retrieve the next batch of objects, use the token that was returned for the prior request in your next request.</p>', 'ListFirewallConfigsResponse$NextToken' => '<p>If objects are still available for retrieval, Resolver returns this token in the response. To retrieve the next batch of objects, provide this token in your next request.</p>', 'ListFirewallDomainListsRequest$NextToken' => '<p>For the first call to this list request, omit this value.</p> <p>When you request a list of objects, Resolver returns at most the number of objects specified in <code>MaxResults</code>. If more objects are available for retrieval, Resolver returns a <code>NextToken</code> value in the response. To retrieve the next batch of objects, use the token that was returned for the prior request in your next request.</p>', 'ListFirewallDomainListsResponse$NextToken' => '<p>If objects are still available for retrieval, Resolver returns this token in the response. To retrieve the next batch of objects, provide this token in your next request.</p>', 'ListFirewallDomainsRequest$NextToken' => '<p>For the first call to this list request, omit this value.</p> <p>When you request a list of objects, Resolver returns at most the number of objects specified in <code>MaxResults</code>. If more objects are available for retrieval, Resolver returns a <code>NextToken</code> value in the response. To retrieve the next batch of objects, use the token that was returned for the prior request in your next request.</p>', 'ListFirewallDomainsResponse$NextToken' => '<p>If objects are still available for retrieval, Resolver returns this token in the response. To retrieve the next batch of objects, provide this token in your next request.</p>', 'ListFirewallRuleGroupAssociationsRequest$NextToken' => '<p>For the first call to this list request, omit this value.</p> <p>When you request a list of objects, Resolver returns at most the number of objects specified in <code>MaxResults</code>. If more objects are available for retrieval, Resolver returns a <code>NextToken</code> value in the response. To retrieve the next batch of objects, use the token that was returned for the prior request in your next request.</p>', 'ListFirewallRuleGroupAssociationsResponse$NextToken' => '<p>If objects are still available for retrieval, Resolver returns this token in the response. To retrieve the next batch of objects, provide this token in your next request.</p>', 'ListFirewallRuleGroupsRequest$NextToken' => '<p>For the first call to this list request, omit this value.</p> <p>When you request a list of objects, Resolver returns at most the number of objects specified in <code>MaxResults</code>. If more objects are available for retrieval, Resolver returns a <code>NextToken</code> value in the response. To retrieve the next batch of objects, use the token that was returned for the prior request in your next request.</p>', 'ListFirewallRuleGroupsResponse$NextToken' => '<p>If objects are still available for retrieval, Resolver returns this token in the response. To retrieve the next batch of objects, provide this token in your next request.</p>', 'ListFirewallRulesRequest$NextToken' => '<p>For the first call to this list request, omit this value.</p> <p>When you request a list of objects, Resolver returns at most the number of objects specified in <code>MaxResults</code>. If more objects are available for retrieval, Resolver returns a <code>NextToken</code> value in the response. To retrieve the next batch of objects, use the token that was returned for the prior request in your next request.</p>', 'ListFirewallRulesResponse$NextToken' => '<p>If objects are still available for retrieval, Resolver returns this token in the response. To retrieve the next batch of objects, provide this token in your next request.</p>', 'ListResolverDnssecConfigsRequest$NextToken' => '<p>(Optional) If the current Amazon Web Services account has more than <code>MaxResults</code> DNSSEC configurations, use <code>NextToken</code> to get the second and subsequent pages of results.</p> <p>For the first <code>ListResolverDnssecConfigs</code> request, omit this value.</p> <p>For the second and subsequent requests, get the value of <code>NextToken</code> from the previous response and specify that value for <code>NextToken</code> in the request.</p>', 'ListResolverDnssecConfigsResponse$NextToken' => '<p>If a response includes the last of the DNSSEC configurations that are associated with the current Amazon Web Services account, <code>NextToken</code> doesn\'t appear in the response.</p> <p>If a response doesn\'t include the last of the configurations, you can get more configurations by submitting another <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_ListResolverDnssecConfigs.html">ListResolverDnssecConfigs</a> request. Get the value of <code>NextToken</code> that Amazon Route 53 returned in the previous response and include it in <code>NextToken</code> in the next request.</p>', 'ListResolverEndpointIpAddressesRequest$NextToken' => '<p>For the first <code>ListResolverEndpointIpAddresses</code> request, omit this value.</p> <p>If the specified Resolver endpoint has more than <code>MaxResults</code> IP addresses, you can submit another <code>ListResolverEndpointIpAddresses</code> request to get the next group of IP addresses. In the next request, specify the value of <code>NextToken</code> from the previous response. </p>', 'ListResolverEndpointIpAddressesResponse$NextToken' => '<p>If the specified endpoint has more than <code>MaxResults</code> IP addresses, you can submit another <code>ListResolverEndpointIpAddresses</code> request to get the next group of IP addresses. In the next request, specify the value of <code>NextToken</code> from the previous response. </p>', 'ListResolverEndpointsRequest$NextToken' => '<p>For the first <code>ListResolverEndpoints</code> request, omit this value.</p> <p>If you have more than <code>MaxResults</code> Resolver endpoints, you can submit another <code>ListResolverEndpoints</code> request to get the next group of Resolver endpoints. In the next request, specify the value of <code>NextToken</code> from the previous response. </p>', 'ListResolverEndpointsResponse$NextToken' => '<p>If more than <code>MaxResults</code> IP addresses match the specified criteria, you can submit another <code>ListResolverEndpoint</code> request to get the next group of results. In the next request, specify the value of <code>NextToken</code> from the previous response. </p>', 'ListResolverQueryLogConfigAssociationsRequest$NextToken' => '<p>For the first <code>ListResolverQueryLogConfigAssociations</code> request, omit this value.</p> <p>If there are more than <code>MaxResults</code> query logging associations that match the values that you specify for <code>Filters</code>, you can submit another <code>ListResolverQueryLogConfigAssociations</code> request to get the next group of associations. In the next request, specify the value of <code>NextToken</code> from the previous response. </p>', 'ListResolverQueryLogConfigAssociationsResponse$NextToken' => '<p>If there are more than <code>MaxResults</code> query logging associations, you can submit another <code>ListResolverQueryLogConfigAssociations</code> request to get the next group of associations. In the next request, specify the value of <code>NextToken</code> from the previous response. </p>', 'ListResolverQueryLogConfigsRequest$NextToken' => '<p>For the first <code>ListResolverQueryLogConfigs</code> request, omit this value.</p> <p>If there are more than <code>MaxResults</code> query logging configurations that match the values that you specify for <code>Filters</code>, you can submit another <code>ListResolverQueryLogConfigs</code> request to get the next group of configurations. In the next request, specify the value of <code>NextToken</code> from the previous response. </p>', 'ListResolverQueryLogConfigsResponse$NextToken' => '<p>If there are more than <code>MaxResults</code> query logging configurations, you can submit another <code>ListResolverQueryLogConfigs</code> request to get the next group of configurations. In the next request, specify the value of <code>NextToken</code> from the previous response. </p>', 'ListResolverRuleAssociationsRequest$NextToken' => '<p>For the first <code>ListResolverRuleAssociation</code> request, omit this value.</p> <p>If you have more than <code>MaxResults</code> rule associations, you can submit another <code>ListResolverRuleAssociation</code> request to get the next group of rule associations. In the next request, specify the value of <code>NextToken</code> from the previous response. </p>', 'ListResolverRuleAssociationsResponse$NextToken' => '<p>If more than <code>MaxResults</code> rule associations match the specified criteria, you can submit another <code>ListResolverRuleAssociation</code> request to get the next group of results. In the next request, specify the value of <code>NextToken</code> from the previous response. </p>', 'ListResolverRulesRequest$NextToken' => '<p>For the first <code>ListResolverRules</code> request, omit this value.</p> <p>If you have more than <code>MaxResults</code> Resolver rules, you can submit another <code>ListResolverRules</code> request to get the next group of Resolver rules. In the next request, specify the value of <code>NextToken</code> from the previous response. </p>', 'ListResolverRulesResponse$NextToken' => '<p>If more than <code>MaxResults</code> Resolver rules match the specified criteria, you can submit another <code>ListResolverRules</code> request to get the next group of results. In the next request, specify the value of <code>NextToken</code> from the previous response. </p>', 'ListTagsForResourceRequest$NextToken' => '<p>For the first <code>ListTagsForResource</code> request, omit this value.</p> <p>If you have more than <code>MaxResults</code> tags, you can submit another <code>ListTagsForResource</code> request to get the next group of tags for the resource. In the next request, specify the value of <code>NextToken</code> from the previous response. </p>', 'ListTagsForResourceResponse$NextToken' => '<p>If more than <code>MaxResults</code> tags match the specified criteria, you can submit another <code>ListTagsForResource</code> request to get the next group of results. In the next request, specify the value of <code>NextToken</code> from the previous response. </p>', ], ], 'Port' => [ 'base' => NULL, 'refs' => [ 'TargetAddress$Port' => '<p>The port at <code>Ip</code> that you want to forward DNS queries to.</p>', ], ], 'Priority' => [ 'base' => NULL, 'refs' => [ 'AssociateFirewallRuleGroupRequest$Priority' => '<p>The setting that determines the processing order of the rule group among the rule groups that you associate with the specified VPC. DNS Firewall filters VPC traffic starting from the rule group with the lowest numeric priority setting. </p> <p>You must specify a unique priority for each rule group that you associate with a single VPC. To make it easier to insert rule groups later, leave space between the numbers, for example, use 101, 200, and so on. You can change the priority setting for a rule group association after you create it.</p> <p>The allowed values for <code>Priority</code> are between 100 and 9900.</p>', 'CreateFirewallRuleRequest$Priority' => '<p>The setting that determines the processing order of the rule in the rule group. DNS Firewall processes the rules in a rule group by order of priority, starting from the lowest setting.</p> <p>You must specify a unique priority for each rule in a rule group. To make it easier to insert rules later, leave space between the numbers, for example, use 100, 200, and so on. You can change the priority setting for the rules in a rule group at any time.</p>', 'FirewallRule$Priority' => '<p>The priority of the rule in the rule group. This value must be unique within the rule group. DNS Firewall processes the rules in a rule group by order of priority, starting from the lowest setting.</p>', 'FirewallRuleGroupAssociation$Priority' => '<p>The setting that determines the processing order of the rule group among the rule groups that are associated with a single VPC. DNS Firewall filters VPC traffic starting from rule group with the lowest numeric priority setting. </p>', 'ListFirewallRuleGroupAssociationsRequest$Priority' => '<p>The setting that determines the processing order of the rule group among the rule groups that are associated with a single VPC. DNS Firewall filters VPC traffic starting from the rule group with the lowest numeric priority setting. </p>', 'ListFirewallRulesRequest$Priority' => '<p>Optional additional filter for the rules to retrieve.</p> <p>The setting that determines the processing order of the rules in a rule group. DNS Firewall processes the rules in a rule group by order of priority, starting from the lowest setting.</p>', 'UpdateFirewallRuleGroupAssociationRequest$Priority' => '<p>The setting that determines the processing order of the rule group among the rule groups that you associate with the specified VPC. DNS Firewall filters VPC traffic starting from the rule group with the lowest numeric priority setting. </p> <p>You must specify a unique priority for each rule group that you associate with a single VPC. To make it easier to insert rule groups later, leave space between the numbers, for example, use 100, 200, and so on. You can change the priority setting for a rule group association after you create it.</p>', 'UpdateFirewallRuleRequest$Priority' => '<p>The setting that determines the processing order of the rule in the rule group. DNS Firewall processes the rules in a rule group by order of priority, starting from the lowest setting.</p> <p>You must specify a unique priority for each rule in a rule group. To make it easier to insert rules later, leave space between the numbers, for example, use 100, 200, and so on. You can change the priority setting for the rules in a rule group at any time.</p>', ], ], 'PutFirewallRuleGroupPolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutFirewallRuleGroupPolicyResponse' => [ 'base' => NULL, 'refs' => [], ], 'PutResolverQueryLogConfigPolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutResolverQueryLogConfigPolicyResponse' => [ 'base' => '<p>The response to a <code>PutResolverQueryLogConfigPolicy</code> request.</p>', 'refs' => [], ], 'PutResolverRulePolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutResolverRulePolicyResponse' => [ 'base' => '<p>The response to a <code>PutResolverRulePolicy</code> request.</p>', 'refs' => [], ], 'ResolverDNSSECValidationStatus' => [ 'base' => NULL, 'refs' => [ 'ResolverDnssecConfig$ValidationStatus' => '<p>The validation status for a DNSSEC configuration. The status can be one of the following:</p> <ul> <li> <p> <b>ENABLING:</b> DNSSEC validation is being enabled but is not complete.</p> </li> <li> <p> <b>ENABLED:</b> DNSSEC validation is enabled.</p> </li> <li> <p> <b>DISABLING:</b> DNSSEC validation is being disabled but is not complete.</p> </li> <li> <p> <b>DISABLED</b> DNSSEC validation is disabled.</p> </li> </ul>', ], ], 'ResolverDnssecConfig' => [ 'base' => '<p>A complex type that contains information about a configuration for DNSSEC validation.</p>', 'refs' => [ 'GetResolverDnssecConfigResponse$ResolverDNSSECConfig' => '<p>The information about a configuration for DNSSEC validation.</p>', 'ResolverDnssecConfigList$member' => NULL, 'UpdateResolverDnssecConfigResponse$ResolverDNSSECConfig' => '<p>A complex type that contains settings for the specified DNSSEC configuration.</p>', ], ], 'ResolverDnssecConfigList' => [ 'base' => NULL, 'refs' => [ 'ListResolverDnssecConfigsResponse$ResolverDnssecConfigs' => '<p>An array that contains one <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_ResolverDnssecConfig.html">ResolverDnssecConfig</a> element for each configuration for DNSSEC validation that is associated with the current Amazon Web Services account.</p>', ], ], 'ResolverEndpoint' => [ 'base' => '<p>In the response to a <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_CreateResolverEndpoint.html">CreateResolverEndpoint</a>, <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_DeleteResolverEndpoint.html">DeleteResolverEndpoint</a>, <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_GetResolverEndpoint.html">GetResolverEndpoint</a>, <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_ListResolverEndpoints.html">ListResolverEndpoints</a>, or <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_UpdateResolverEndpoint.html">UpdateResolverEndpoint</a> request, a complex type that contains settings for an existing inbound or outbound Resolver endpoint.</p>', 'refs' => [ 'AssociateResolverEndpointIpAddressResponse$ResolverEndpoint' => '<p>The response to an <code>AssociateResolverEndpointIpAddress</code> request.</p>', 'CreateResolverEndpointResponse$ResolverEndpoint' => '<p>Information about the <code>CreateResolverEndpoint</code> request, including the status of the request.</p>', 'DeleteResolverEndpointResponse$ResolverEndpoint' => '<p>Information about the <code>DeleteResolverEndpoint</code> request, including the status of the request.</p>', 'DisassociateResolverEndpointIpAddressResponse$ResolverEndpoint' => '<p>The response to an <code>DisassociateResolverEndpointIpAddress</code> request.</p>', 'GetResolverEndpointResponse$ResolverEndpoint' => '<p>Information about the Resolver endpoint that you specified in a <code>GetResolverEndpoint</code> request.</p>', 'ResolverEndpoints$member' => NULL, 'UpdateResolverEndpointResponse$ResolverEndpoint' => '<p>The response to an <code>UpdateResolverEndpoint</code> request.</p>', ], ], 'ResolverEndpointDirection' => [ 'base' => NULL, 'refs' => [ 'CreateResolverEndpointRequest$Direction' => '<p>Specify the applicable value:</p> <ul> <li> <p> <code>INBOUND</code>: Resolver forwards DNS queries to the DNS service for a VPC from your network</p> </li> <li> <p> <code>OUTBOUND</code>: Resolver forwards DNS queries from the DNS service for a VPC to your network</p> </li> </ul>', 'ResolverEndpoint$Direction' => '<p>Indicates whether the Resolver endpoint allows inbound or outbound DNS queries:</p> <ul> <li> <p> <code>INBOUND</code>: allows DNS queries to your VPC from your network</p> </li> <li> <p> <code>OUTBOUND</code>: allows DNS queries from your VPC to your network</p> </li> </ul>', ], ], 'ResolverEndpointStatus' => [ 'base' => NULL, 'refs' => [ 'ResolverEndpoint$Status' => '<p>A code that specifies the current status of the Resolver endpoint. Valid values include the following:</p> <ul> <li> <p> <code>CREATING</code>: Resolver is creating and configuring one or more Amazon VPC network interfaces for this endpoint.</p> </li> <li> <p> <code>OPERATIONAL</code>: The Amazon VPC network interfaces for this endpoint are correctly configured and able to pass inbound or outbound DNS queries between your network and Resolver.</p> </li> <li> <p> <code>UPDATING</code>: Resolver is associating or disassociating one or more network interfaces with this endpoint.</p> </li> <li> <p> <code>AUTO_RECOVERING</code>: Resolver is trying to recover one or more of the network interfaces that are associated with this endpoint. During the recovery process, the endpoint functions with limited capacity because of the limit on the number of DNS queries per IP address (per network interface). For the current limit, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/DNSLimitations.html#limits-api-entities-resolver">Limits on Route 53 Resolver</a>.</p> </li> <li> <p> <code>ACTION_NEEDED</code>: This endpoint is unhealthy, and Resolver can\'t automatically recover it. To resolve the problem, we recommend that you check each IP address that you associated with the endpoint. For each IP address that isn\'t available, add another IP address and then delete the IP address that isn\'t available. (An endpoint must always include at least two IP addresses.) A status of <code>ACTION_NEEDED</code> can have a variety of causes. Here are two common causes:</p> <ul> <li> <p>One or more of the network interfaces that are associated with the endpoint were deleted using Amazon VPC.</p> </li> <li> <p>The network interface couldn\'t be created for some reason that\'s outside the control of Resolver.</p> </li> </ul> </li> <li> <p> <code>DELETING</code>: Resolver is deleting this endpoint and the associated network interfaces.</p> </li> </ul>', ], ], 'ResolverEndpoints' => [ 'base' => NULL, 'refs' => [ 'ListResolverEndpointsResponse$ResolverEndpoints' => '<p>The Resolver endpoints that were created by using the current Amazon Web Services account, and that match the specified filters, if any.</p>', ], ], 'ResolverQueryLogConfig' => [ 'base' => '<p>In the response to a <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_CreateResolverQueryLogConfig.html">CreateResolverQueryLogConfig</a>, <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_DeleteResolverQueryLogConfig.html">DeleteResolverQueryLogConfig</a>, <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_GetResolverQueryLogConfig.html">GetResolverQueryLogConfig</a>, or <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_ListResolverQueryLogConfigs.html">ListResolverQueryLogConfigs</a> request, a complex type that contains settings for one query logging configuration.</p>', 'refs' => [ 'CreateResolverQueryLogConfigResponse$ResolverQueryLogConfig' => '<p>Information about the <code>CreateResolverQueryLogConfig</code> request, including the status of the request.</p>', 'DeleteResolverQueryLogConfigResponse$ResolverQueryLogConfig' => '<p>Information about the query logging configuration that you deleted, including the status of the request.</p>', 'GetResolverQueryLogConfigResponse$ResolverQueryLogConfig' => '<p>Information about the Resolver query logging configuration that you specified in a <code>GetQueryLogConfig</code> request.</p>', 'ResolverQueryLogConfigList$member' => NULL, ], ], 'ResolverQueryLogConfigAssociation' => [ 'base' => '<p>In the response to an <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_AssociateResolverQueryLogConfig.html">AssociateResolverQueryLogConfig</a>, <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_DisassociateResolverQueryLogConfig.html">DisassociateResolverQueryLogConfig</a>, <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_GetResolverQueryLogConfigAssociation.html">GetResolverQueryLogConfigAssociation</a>, or <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_ListResolverQueryLogConfigAssociations.html">ListResolverQueryLogConfigAssociations</a>, request, a complex type that contains settings for a specified association between an Amazon VPC and a query logging configuration.</p>', 'refs' => [ 'AssociateResolverQueryLogConfigResponse$ResolverQueryLogConfigAssociation' => '<p>A complex type that contains settings for a specified association between an Amazon VPC and a query logging configuration.</p>', 'DisassociateResolverQueryLogConfigResponse$ResolverQueryLogConfigAssociation' => '<p>A complex type that contains settings for the association that you deleted between an Amazon VPC and a query logging configuration.</p>', 'GetResolverQueryLogConfigAssociationResponse$ResolverQueryLogConfigAssociation' => '<p>Information about the Resolver query logging configuration association that you specified in a <code>GetQueryLogConfigAssociation</code> request.</p>', 'ResolverQueryLogConfigAssociationList$member' => NULL, ], ], 'ResolverQueryLogConfigAssociationError' => [ 'base' => NULL, 'refs' => [ 'ResolverQueryLogConfigAssociation$Error' => '<p>If the value of <code>Status</code> is <code>FAILED</code>, the value of <code>Error</code> indicates the cause:</p> <ul> <li> <p> <code>DESTINATION_NOT_FOUND</code>: The specified destination (for example, an Amazon S3 bucket) was deleted.</p> </li> <li> <p> <code>ACCESS_DENIED</code>: Permissions don\'t allow sending logs to the destination.</p> </li> </ul> <p>If the value of <code>Status</code> is a value other than <code>FAILED</code>, <code>Error</code> is null. </p>', ], ], 'ResolverQueryLogConfigAssociationErrorMessage' => [ 'base' => NULL, 'refs' => [ 'ResolverQueryLogConfigAssociation$ErrorMessage' => '<p>Contains additional information about the error. If the value or <code>Error</code> is null, the value of <code>ErrorMessage</code> also is null.</p>', ], ], 'ResolverQueryLogConfigAssociationList' => [ 'base' => NULL, 'refs' => [ 'ListResolverQueryLogConfigAssociationsResponse$ResolverQueryLogConfigAssociations' => '<p>A list that contains one <code>ResolverQueryLogConfigAssociations</code> element for each query logging association that matches the values that you specified for <code>Filter</code>.</p>', ], ], 'ResolverQueryLogConfigAssociationStatus' => [ 'base' => NULL, 'refs' => [ 'ResolverQueryLogConfigAssociation$Status' => '<p>The status of the specified query logging association. Valid values include the following:</p> <ul> <li> <p> <code>CREATING</code>: Resolver is creating an association between an Amazon VPC and a query logging configuration.</p> </li> <li> <p> <code>CREATED</code>: The association between an Amazon VPC and a query logging configuration was successfully created. Resolver is logging queries that originate in the specified VPC.</p> </li> <li> <p> <code>DELETING</code>: Resolver is deleting this query logging association.</p> </li> <li> <p> <code>FAILED</code>: Resolver either couldn\'t create or couldn\'t delete the query logging association.</p> </li> </ul>', ], ], 'ResolverQueryLogConfigList' => [ 'base' => NULL, 'refs' => [ 'ListResolverQueryLogConfigsResponse$ResolverQueryLogConfigs' => '<p>A list that contains one <code>ResolverQueryLogConfig</code> element for each query logging configuration that matches the values that you specified for <code>Filter</code>.</p>', ], ], 'ResolverQueryLogConfigName' => [ 'base' => NULL, 'refs' => [ 'CreateResolverQueryLogConfigRequest$Name' => '<p>The name that you want to give the query logging configuration.</p>', 'ResolverQueryLogConfig$Name' => '<p>The name of the query logging configuration. </p>', ], ], 'ResolverQueryLogConfigPolicy' => [ 'base' => NULL, 'refs' => [ 'GetResolverQueryLogConfigPolicyResponse$ResolverQueryLogConfigPolicy' => '<p>Information about the query logging policy for the query logging configuration that you specified in a <code>GetResolverQueryLogConfigPolicy</code> request.</p>', 'PutResolverQueryLogConfigPolicyRequest$ResolverQueryLogConfigPolicy' => '<p>An Identity and Access Management policy statement that lists the query logging configurations that you want to share with another Amazon Web Services account and the operations that you want the account to be able to perform. You can specify the following operations in the <code>Actions</code> section of the statement:</p> <ul> <li> <p> <code>route53resolver:AssociateResolverQueryLogConfig</code> </p> </li> <li> <p> <code>route53resolver:DisassociateResolverQueryLogConfig</code> </p> </li> <li> <p> <code>route53resolver:ListResolverQueryLogConfigAssociations</code> </p> </li> <li> <p> <code>route53resolver:ListResolverQueryLogConfigs</code> </p> </li> </ul> <p>In the <code>Resource</code> section of the statement, you specify the ARNs for the query logging configurations that you want to share with the account that you specified in <code>Arn</code>. </p>', ], ], 'ResolverQueryLogConfigStatus' => [ 'base' => NULL, 'refs' => [ 'ResolverQueryLogConfig$Status' => '<p>The status of the specified query logging configuration. Valid values include the following:</p> <ul> <li> <p> <code>CREATING</code>: Resolver is creating the query logging configuration.</p> </li> <li> <p> <code>CREATED</code>: The query logging configuration was successfully created. Resolver is logging queries that originate in the specified VPC.</p> </li> <li> <p> <code>DELETING</code>: Resolver is deleting this query logging configuration.</p> </li> <li> <p> <code>FAILED</code>: Resolver can\'t deliver logs to the location that is specified in the query logging configuration. Here are two common causes:</p> <ul> <li> <p>The specified destination (for example, an Amazon S3 bucket) was deleted.</p> </li> <li> <p>Permissions don\'t allow sending logs to the destination.</p> </li> </ul> </li> </ul>', ], ], 'ResolverRule' => [ 'base' => '<p>For queries that originate in your VPC, detailed information about a Resolver rule, which specifies how to route DNS queries out of the VPC. The <code>ResolverRule</code> parameter appears in the response to a <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_CreateResolverRule.html">CreateResolverRule</a>, <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_DeleteResolverRule.html">DeleteResolverRule</a>, <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_GetResolverRule.html">GetResolverRule</a>, <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_ListResolverRules.html">ListResolverRules</a>, or <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_UpdateResolverRule.html">UpdateResolverRule</a> request.</p>', 'refs' => [ 'CreateResolverRuleResponse$ResolverRule' => '<p>Information about the <code>CreateResolverRule</code> request, including the status of the request.</p>', 'DeleteResolverRuleResponse$ResolverRule' => '<p>Information about the <code>DeleteResolverRule</code> request, including the status of the request.</p>', 'GetResolverRuleResponse$ResolverRule' => '<p>Information about the Resolver rule that you specified in a <code>GetResolverRule</code> request.</p>', 'ResolverRules$member' => NULL, 'UpdateResolverRuleResponse$ResolverRule' => '<p>The response to an <code>UpdateResolverRule</code> request.</p>', ], ], 'ResolverRuleAssociation' => [ 'base' => '<p>In the response to an <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_AssociateResolverRule.html">AssociateResolverRule</a>, <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_DisassociateResolverRule.html">DisassociateResolverRule</a>, or <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_ListResolverRuleAssociations.html">ListResolverRuleAssociations</a> request, provides information about an association between a Resolver rule and a VPC. The association determines which DNS queries that originate in the VPC are forwarded to your network. </p>', 'refs' => [ 'AssociateResolverRuleResponse$ResolverRuleAssociation' => '<p>Information about the <code>AssociateResolverRule</code> request, including the status of the request.</p>', 'DisassociateResolverRuleResponse$ResolverRuleAssociation' => '<p>Information about the <code>DisassociateResolverRule</code> request, including the status of the request.</p>', 'GetResolverRuleAssociationResponse$ResolverRuleAssociation' => '<p>Information about the Resolver rule association that you specified in a <code>GetResolverRuleAssociation</code> request.</p>', 'ResolverRuleAssociations$member' => NULL, ], ], 'ResolverRuleAssociationStatus' => [ 'base' => NULL, 'refs' => [ 'ResolverRuleAssociation$Status' => '<p>A code that specifies the current status of the association between a Resolver rule and a VPC.</p>', ], ], 'ResolverRuleAssociations' => [ 'base' => NULL, 'refs' => [ 'ListResolverRuleAssociationsResponse$ResolverRuleAssociations' => '<p>The associations that were created between Resolver rules and VPCs using the current Amazon Web Services account, and that match the specified filters, if any.</p>', ], ], 'ResolverRuleConfig' => [ 'base' => '<p>In an <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_UpdateResolverRule.html">UpdateResolverRule</a> request, information about the changes that you want to make.</p>', 'refs' => [ 'UpdateResolverRuleRequest$Config' => '<p>The new settings for the Resolver rule.</p>', ], ], 'ResolverRulePolicy' => [ 'base' => NULL, 'refs' => [ 'GetResolverRulePolicyResponse$ResolverRulePolicy' => '<p>The Resolver rule policy for the rule that you specified in a <code>GetResolverRulePolicy</code> request.</p>', 'PutResolverRulePolicyRequest$ResolverRulePolicy' => '<p>An Identity and Access Management policy statement that lists the rules that you want to share with another Amazon Web Services account and the operations that you want the account to be able to perform. You can specify the following operations in the <code>Action</code> section of the statement:</p> <ul> <li> <p> <code>route53resolver:GetResolverRule</code> </p> </li> <li> <p> <code>route53resolver:AssociateResolverRule</code> </p> </li> <li> <p> <code>route53resolver:DisassociateResolverRule</code> </p> </li> <li> <p> <code>route53resolver:ListResolverRules</code> </p> </li> <li> <p> <code>route53resolver:ListResolverRuleAssociations</code> </p> </li> </ul> <p>In the <code>Resource</code> section of the statement, specify the ARN for the rule that you want to share with another account. Specify the same ARN that you specified in <code>Arn</code>.</p>', ], ], 'ResolverRuleStatus' => [ 'base' => NULL, 'refs' => [ 'ResolverRule$Status' => '<p>A code that specifies the current status of the Resolver rule.</p>', ], ], 'ResolverRules' => [ 'base' => NULL, 'refs' => [ 'ListResolverRulesResponse$ResolverRules' => '<p>The Resolver rules that were created using the current Amazon Web Services account and that match the specified filters, if any.</p>', ], ], 'ResourceExistsException' => [ 'base' => '<p>The resource that you tried to create already exists.</p>', 'refs' => [], ], 'ResourceId' => [ 'base' => NULL, 'refs' => [ 'AssociateFirewallRuleGroupRequest$FirewallRuleGroupId' => '<p>The unique identifier of the firewall rule group. </p>', 'AssociateFirewallRuleGroupRequest$VpcId' => '<p>The unique identifier of the VPC that you want to associate with the rule group. </p>', 'AssociateResolverEndpointIpAddressRequest$ResolverEndpointId' => '<p>The ID of the Resolver endpoint that you want to associate IP addresses with.</p>', 'AssociateResolverQueryLogConfigRequest$ResolverQueryLogConfigId' => '<p>The ID of the query logging configuration that you want to associate a VPC with.</p>', 'AssociateResolverQueryLogConfigRequest$ResourceId' => '<p>The ID of an Amazon VPC that you want this query logging configuration to log queries for.</p> <note> <p>The VPCs and the query logging configuration must be in the same Region.</p> </note>', 'AssociateResolverRuleRequest$ResolverRuleId' => '<p>The ID of the Resolver rule that you want to associate with the VPC. To list the existing Resolver rules, use <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_ListResolverRules.html">ListResolverRules</a>.</p>', 'AssociateResolverRuleRequest$VPCId' => '<p>The ID of the VPC that you want to associate the Resolver rule with.</p>', 'CreateFirewallRuleRequest$FirewallRuleGroupId' => '<p>The unique identifier of the firewall rule group where you want to create the rule. </p>', 'CreateFirewallRuleRequest$FirewallDomainListId' => '<p>The ID of the domain list that you want to use in the rule. </p>', 'CreateResolverRuleRequest$ResolverEndpointId' => '<p>The ID of the outbound Resolver endpoint that you want to use to route DNS queries to the IP addresses that you specify in <code>TargetIps</code>.</p>', 'DeleteFirewallDomainListRequest$FirewallDomainListId' => '<p>The ID of the domain list that you want to delete. </p>', 'DeleteFirewallRuleGroupRequest$FirewallRuleGroupId' => '<p>The unique identifier of the firewall rule group that you want to delete. </p>', 'DeleteFirewallRuleRequest$FirewallRuleGroupId' => '<p>The unique identifier of the firewall rule group that you want to delete the rule from. </p>', 'DeleteFirewallRuleRequest$FirewallDomainListId' => '<p>The ID of the domain list that\'s used in the rule. </p>', 'DeleteResolverEndpointRequest$ResolverEndpointId' => '<p>The ID of the Resolver endpoint that you want to delete.</p>', 'DeleteResolverQueryLogConfigRequest$ResolverQueryLogConfigId' => '<p>The ID of the query logging configuration that you want to delete.</p>', 'DeleteResolverRuleRequest$ResolverRuleId' => '<p>The ID of the Resolver rule that you want to delete.</p>', 'DisassociateFirewallRuleGroupRequest$FirewallRuleGroupAssociationId' => '<p>The identifier of the <a>FirewallRuleGroupAssociation</a>. </p>', 'DisassociateResolverEndpointIpAddressRequest$ResolverEndpointId' => '<p>The ID of the Resolver endpoint that you want to disassociate an IP address from.</p>', 'DisassociateResolverQueryLogConfigRequest$ResolverQueryLogConfigId' => '<p>The ID of the query logging configuration that you want to disassociate a specified VPC from.</p>', 'DisassociateResolverQueryLogConfigRequest$ResourceId' => '<p>The ID of the Amazon VPC that you want to disassociate from a specified query logging configuration.</p>', 'DisassociateResolverRuleRequest$VPCId' => '<p>The ID of the VPC that you want to disassociate the Resolver rule from.</p>', 'DisassociateResolverRuleRequest$ResolverRuleId' => '<p>The ID of the Resolver rule that you want to disassociate from the specified VPC.</p>', 'FirewallConfig$Id' => '<p>The ID of the firewall configuration.</p>', 'FirewallConfig$ResourceId' => '<p>The ID of the VPC that this firewall configuration applies to.</p>', 'FirewallDomainList$Id' => '<p>The ID of the domain list. </p>', 'FirewallDomainListMetadata$Id' => '<p>The ID of the domain list. </p>', 'FirewallRule$FirewallRuleGroupId' => '<p>The unique identifier of the firewall rule group of the rule. </p>', 'FirewallRule$FirewallDomainListId' => '<p>The ID of the domain list that\'s used in the rule. </p>', 'FirewallRuleGroup$Id' => '<p>The ID of the rule group. </p>', 'FirewallRuleGroupAssociation$Id' => '<p>The identifier for the association.</p>', 'FirewallRuleGroupAssociation$FirewallRuleGroupId' => '<p>The unique identifier of the firewall rule group. </p>', 'FirewallRuleGroupAssociation$VpcId' => '<p>The unique identifier of the VPC that is associated with the rule group. </p>', 'FirewallRuleGroupMetadata$Id' => '<p>The ID of the rule group. </p>', 'GetFirewallConfigRequest$ResourceId' => '<p>The ID of the VPC from Amazon VPC that the configuration is for.</p>', 'GetFirewallDomainListRequest$FirewallDomainListId' => '<p>The ID of the domain list. </p>', 'GetFirewallRuleGroupAssociationRequest$FirewallRuleGroupAssociationId' => '<p>The identifier of the <a>FirewallRuleGroupAssociation</a>. </p>', 'GetFirewallRuleGroupRequest$FirewallRuleGroupId' => '<p>The unique identifier of the firewall rule group. </p>', 'GetResolverDnssecConfigRequest$ResourceId' => '<p>The ID of the virtual private cloud (VPC) for the DNSSEC validation status.</p>', 'GetResolverEndpointRequest$ResolverEndpointId' => '<p>The ID of the Resolver endpoint that you want to get information about.</p>', 'GetResolverQueryLogConfigAssociationRequest$ResolverQueryLogConfigAssociationId' => '<p>The ID of the Resolver query logging configuration association that you want to get information about.</p>', 'GetResolverQueryLogConfigRequest$ResolverQueryLogConfigId' => '<p>The ID of the Resolver query logging configuration that you want to get information about.</p>', 'GetResolverRuleAssociationRequest$ResolverRuleAssociationId' => '<p>The ID of the Resolver rule association that you want to get information about.</p>', 'GetResolverRuleRequest$ResolverRuleId' => '<p>The ID of the Resolver rule that you want to get information about.</p>', 'ImportFirewallDomainsRequest$FirewallDomainListId' => '<p>The ID of the domain list that you want to modify with the import operation.</p>', 'ImportFirewallDomainsResponse$Id' => '<p>The Id of the firewall domain list that DNS Firewall just updated.</p>', 'IpAddressResponse$IpId' => '<p>The ID of one IP address.</p>', 'IpAddressUpdate$IpId' => '<p> <i>Only when removing an IP address from a Resolver endpoint</i>: The ID of the IP address that you want to remove. To get this ID, use <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_GetResolverEndpoint.html">GetResolverEndpoint</a>.</p>', 'ListFirewallDomainsRequest$FirewallDomainListId' => '<p>The ID of the domain list whose domains you want to retrieve. </p>', 'ListFirewallRuleGroupAssociationsRequest$FirewallRuleGroupId' => '<p>The unique identifier of the firewall rule group that you want to retrieve the associations for. Leave this blank to retrieve associations for any rule group. </p>', 'ListFirewallRuleGroupAssociationsRequest$VpcId' => '<p>The unique identifier of the VPC that you want to retrieve the associations for. Leave this blank to retrieve associations for any VPC. </p>', 'ListFirewallRulesRequest$FirewallRuleGroupId' => '<p>The unique identifier of the firewall rule group that you want to retrieve the rules for. </p>', 'ListResolverEndpointIpAddressesRequest$ResolverEndpointId' => '<p>The ID of the Resolver endpoint that you want to get IP addresses for.</p>', 'ResolverDnssecConfig$Id' => '<p>The ID for a configuration for DNSSEC validation.</p>', 'ResolverDnssecConfig$ResourceId' => '<p>The ID of the virtual private cloud (VPC) that you\'re configuring the DNSSEC validation status for.</p>', 'ResolverEndpoint$Id' => '<p>The ID of the Resolver endpoint.</p>', 'ResolverEndpoint$HostVPCId' => '<p>The ID of the VPC that you want to create the Resolver endpoint in.</p>', 'ResolverQueryLogConfig$Id' => '<p>The ID for the query logging configuration.</p>', 'ResolverQueryLogConfigAssociation$Id' => '<p>The ID of the query logging association.</p>', 'ResolverQueryLogConfigAssociation$ResolverQueryLogConfigId' => '<p>The ID of the query logging configuration that a VPC is associated with.</p>', 'ResolverQueryLogConfigAssociation$ResourceId' => '<p>The ID of the Amazon VPC that is associated with the query logging configuration.</p>', 'ResolverRule$Id' => '<p>The ID that Resolver assigned to the Resolver rule when you created it.</p>', 'ResolverRule$ResolverEndpointId' => '<p>The ID of the endpoint that the rule is associated with.</p>', 'ResolverRuleAssociation$Id' => '<p>The ID of the association between a Resolver rule and a VPC. Resolver assigns this value when you submit an <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_AssociateResolverRule.html">AssociateResolverRule</a> request.</p>', 'ResolverRuleAssociation$ResolverRuleId' => '<p>The ID of the Resolver rule that you associated with the VPC that is specified by <code>VPCId</code>.</p>', 'ResolverRuleAssociation$VPCId' => '<p>The ID of the VPC that you associated the Resolver rule with.</p>', 'ResolverRuleConfig$ResolverEndpointId' => '<p>The ID of the new outbound Resolver endpoint that you want to use to route DNS queries to the IP addresses that you specify in <code>TargetIps</code>.</p>', 'SecurityGroupIds$member' => NULL, 'UpdateFirewallConfigRequest$ResourceId' => '<p>The ID of the VPC that the configuration is for.</p>', 'UpdateFirewallDomainsRequest$FirewallDomainListId' => '<p>The ID of the domain list whose domains you want to update. </p>', 'UpdateFirewallDomainsResponse$Id' => '<p>The ID of the firewall domain list that DNS Firewall just updated.</p>', 'UpdateFirewallRuleGroupAssociationRequest$FirewallRuleGroupAssociationId' => '<p>The identifier of the <a>FirewallRuleGroupAssociation</a>. </p>', 'UpdateFirewallRuleRequest$FirewallRuleGroupId' => '<p>The unique identifier of the firewall rule group for the rule. </p>', 'UpdateFirewallRuleRequest$FirewallDomainListId' => '<p>The ID of the domain list to use in the rule. </p>', 'UpdateResolverDnssecConfigRequest$ResourceId' => '<p>The ID of the virtual private cloud (VPC) that you\'re updating the DNSSEC validation status for.</p>', 'UpdateResolverEndpointRequest$ResolverEndpointId' => '<p>The ID of the Resolver endpoint that you want to update.</p>', 'UpdateResolverRuleRequest$ResolverRuleId' => '<p>The ID of the Resolver rule that you want to update.</p>', ], ], 'ResourceInUseException' => [ 'base' => '<p>The resource that you tried to update or delete is currently in use.</p>', 'refs' => [], ], 'ResourceNotFoundException' => [ 'base' => '<p>The specified resource doesn\'t exist.</p>', 'refs' => [], ], 'ResourceUnavailableException' => [ 'base' => '<p>The specified resource isn\'t available.</p>', 'refs' => [], ], 'Rfc3339TimeString' => [ 'base' => NULL, 'refs' => [ 'FirewallDomainList$CreationTime' => '<p>The date and time that the domain list was created, in Unix time format and Coordinated Universal Time (UTC). </p>', 'FirewallDomainList$ModificationTime' => '<p>The date and time that the domain list was last modified, in Unix time format and Coordinated Universal Time (UTC). </p>', 'FirewallRule$CreationTime' => '<p>The date and time that the rule was created, in Unix time format and Coordinated Universal Time (UTC). </p>', 'FirewallRule$ModificationTime' => '<p>The date and time that the rule was last modified, in Unix time format and Coordinated Universal Time (UTC).</p>', 'FirewallRuleGroup$CreationTime' => '<p>The date and time that the rule group was created, in Unix time format and Coordinated Universal Time (UTC). </p>', 'FirewallRuleGroup$ModificationTime' => '<p>The date and time that the rule group was last modified, in Unix time format and Coordinated Universal Time (UTC).</p>', 'FirewallRuleGroupAssociation$CreationTime' => '<p>The date and time that the association was created, in Unix time format and Coordinated Universal Time (UTC). </p>', 'FirewallRuleGroupAssociation$ModificationTime' => '<p>The date and time that the association was last modified, in Unix time format and Coordinated Universal Time (UTC).</p>', 'IpAddressResponse$CreationTime' => '<p>The date and time that the IP address was created, in Unix time format and Coordinated Universal Time (UTC).</p>', 'IpAddressResponse$ModificationTime' => '<p>The date and time that the IP address was last modified, in Unix time format and Coordinated Universal Time (UTC).</p>', 'ResolverEndpoint$CreationTime' => '<p>The date and time that the endpoint was created, in Unix time format and Coordinated Universal Time (UTC).</p>', 'ResolverEndpoint$ModificationTime' => '<p>The date and time that the endpoint was last modified, in Unix time format and Coordinated Universal Time (UTC).</p>', 'ResolverQueryLogConfig$CreationTime' => '<p>The date and time that the query logging configuration was created, in Unix time format and Coordinated Universal Time (UTC).</p>', 'ResolverQueryLogConfigAssociation$CreationTime' => '<p>The date and time that the VPC was associated with the query logging configuration, in Unix time format and Coordinated Universal Time (UTC).</p>', 'ResolverRule$CreationTime' => '<p>The date and time that the Resolver rule was created, in Unix time format and Coordinated Universal Time (UTC).</p>', 'ResolverRule$ModificationTime' => '<p>The date and time that the Resolver rule was last updated, in Unix time format and Coordinated Universal Time (UTC).</p>', ], ], 'RuleTypeOption' => [ 'base' => NULL, 'refs' => [ 'CreateResolverRuleRequest$RuleType' => '<p>When you want to forward DNS queries for specified domain name to resolvers on your network, specify <code>FORWARD</code>.</p> <p>When you have a forwarding rule to forward DNS queries for a domain to your network and you want Resolver to process queries for a subdomain of that domain, specify <code>SYSTEM</code>.</p> <p>For example, to forward DNS queries for example.com to resolvers on your network, you create a rule and specify <code>FORWARD</code> for <code>RuleType</code>. To then have Resolver process queries for apex.example.com, you create a rule and specify <code>SYSTEM</code> for <code>RuleType</code>.</p> <p>Currently, only Resolver can create rules that have a value of <code>RECURSIVE</code> for <code>RuleType</code>.</p>', 'ResolverRule$RuleType' => '<p>When you want to forward DNS queries for specified domain name to resolvers on your network, specify <code>FORWARD</code>.</p> <p>When you have a forwarding rule to forward DNS queries for a domain to your network and you want Resolver to process queries for a subdomain of that domain, specify <code>SYSTEM</code>.</p> <p>For example, to forward DNS queries for example.com to resolvers on your network, you create a rule and specify <code>FORWARD</code> for <code>RuleType</code>. To then have Resolver process queries for apex.example.com, you create a rule and specify <code>SYSTEM</code> for <code>RuleType</code>.</p> <p>Currently, only Resolver can create rules that have a value of <code>RECURSIVE</code> for <code>RuleType</code>.</p>', ], ], 'SecurityGroupIds' => [ 'base' => NULL, 'refs' => [ 'CreateResolverEndpointRequest$SecurityGroupIds' => '<p>The ID of one or more security groups that you want to use to control access to this VPC. The security group that you specify must include one or more inbound rules (for inbound Resolver endpoints) or outbound rules (for outbound Resolver endpoints). Inbound and outbound rules must allow TCP and UDP access. For inbound access, open port 53. For outbound access, open the port that you\'re using for DNS queries on your network.</p>', 'ResolverEndpoint$SecurityGroupIds' => '<p>The ID of one or more security groups that control access to this VPC. The security group must include one or more inbound rules (for inbound endpoints) or outbound rules (for outbound endpoints). Inbound and outbound rules must allow TCP and UDP access. For inbound access, open port 53. For outbound access, open the port that you\'re using for DNS queries on your network.</p>', ], ], 'ServicePrinciple' => [ 'base' => NULL, 'refs' => [ 'FirewallDomainList$ManagedOwnerName' => '<p>The owner of the list, used only for lists that are not managed by you. For example, the managed domain list <code>AWSManagedDomainsMalwareDomainList</code> has the managed owner name <code>Route 53 Resolver DNS Firewall</code>.</p>', 'FirewallDomainListMetadata$ManagedOwnerName' => '<p>The owner of the list, used only for lists that are not managed by you. For example, the managed domain list <code>AWSManagedDomainsMalwareDomainList</code> has the managed owner name <code>Route 53 Resolver DNS Firewall</code>.</p>', 'FirewallRuleGroupAssociation$ManagedOwnerName' => '<p>The owner of the association, used only for associations that are not managed by you. If you use Firewall Manager to manage your DNS Firewalls, then this reports Firewall Manager as the managed owner.</p>', ], ], 'ShareStatus' => [ 'base' => NULL, 'refs' => [ 'FirewallRuleGroup$ShareStatus' => '<p>Whether the rule group is shared with other Amazon Web Services accounts, or was shared with the current account by another Amazon Web Services account. Sharing is configured through Resource Access Manager (RAM).</p>', 'FirewallRuleGroupMetadata$ShareStatus' => '<p>Whether the rule group is shared with other Amazon Web Services accounts, or was shared with the current account by another Amazon Web Services account. Sharing is configured through Resource Access Manager (RAM).</p>', 'ResolverQueryLogConfig$ShareStatus' => '<p>An indication of whether the query logging configuration is shared with other Amazon Web Services accounts, or was shared with the current account by another Amazon Web Services account. Sharing is configured through Resource Access Manager (RAM).</p>', 'ResolverRule$ShareStatus' => '<p>Whether the rule is shared and, if so, whether the current account is sharing the rule with another account, or another account is sharing the rule with the current account.</p>', ], ], 'SortByKey' => [ 'base' => NULL, 'refs' => [ 'ListResolverQueryLogConfigAssociationsRequest$SortBy' => '<p>The element that you want Resolver to sort query logging associations by. </p> <note> <p>If you submit a second or subsequent <code>ListResolverQueryLogConfigAssociations</code> request and specify the <code>NextToken</code> parameter, you must use the same value for <code>SortBy</code>, if any, as in the previous request.</p> </note> <p>Valid values include the following elements:</p> <ul> <li> <p> <code>CreationTime</code>: The ID of the query logging association.</p> </li> <li> <p> <code>Error</code>: If the value of <code>Status</code> is <code>FAILED</code>, the value of <code>Error</code> indicates the cause: </p> <ul> <li> <p> <code>DESTINATION_NOT_FOUND</code>: The specified destination (for example, an Amazon S3 bucket) was deleted.</p> </li> <li> <p> <code>ACCESS_DENIED</code>: Permissions don\'t allow sending logs to the destination.</p> </li> </ul> <p>If <code>Status</code> is a value other than <code>FAILED</code>, <code>ERROR</code> is null.</p> </li> <li> <p> <code>Id</code>: The ID of the query logging association</p> </li> <li> <p> <code>ResolverQueryLogConfigId</code>: The ID of the query logging configuration</p> </li> <li> <p> <code>ResourceId</code>: The ID of the VPC that is associated with the query logging configuration</p> </li> <li> <p> <code>Status</code>: The current status of the configuration. Valid values include the following:</p> <ul> <li> <p> <code>CREATING</code>: Resolver is creating an association between an Amazon VPC and a query logging configuration.</p> </li> <li> <p> <code>CREATED</code>: The association between an Amazon VPC and a query logging configuration was successfully created. Resolver is logging queries that originate in the specified VPC.</p> </li> <li> <p> <code>DELETING</code>: Resolver is deleting this query logging association.</p> </li> <li> <p> <code>FAILED</code>: Resolver either couldn\'t create or couldn\'t delete the query logging association. Here are two common causes:</p> <ul> <li> <p>The specified destination (for example, an Amazon S3 bucket) was deleted.</p> </li> <li> <p>Permissions don\'t allow sending logs to the destination.</p> </li> </ul> </li> </ul> </li> </ul>', 'ListResolverQueryLogConfigsRequest$SortBy' => '<p>The element that you want Resolver to sort query logging configurations by. </p> <note> <p>If you submit a second or subsequent <code>ListResolverQueryLogConfigs</code> request and specify the <code>NextToken</code> parameter, you must use the same value for <code>SortBy</code>, if any, as in the previous request.</p> </note> <p>Valid values include the following elements:</p> <ul> <li> <p> <code>Arn</code>: The ARN of the query logging configuration</p> </li> <li> <p> <code>AssociationCount</code>: The number of VPCs that are associated with the specified configuration </p> </li> <li> <p> <code>CreationTime</code>: The date and time that Resolver returned when the configuration was created</p> </li> <li> <p> <code>CreatorRequestId</code>: The value that was specified for <code>CreatorRequestId</code> when the configuration was created</p> </li> <li> <p> <code>DestinationArn</code>: The location that logs are sent to</p> </li> <li> <p> <code>Id</code>: The ID of the configuration</p> </li> <li> <p> <code>Name</code>: The name of the configuration</p> </li> <li> <p> <code>OwnerId</code>: The Amazon Web Services account number of the account that created the configuration</p> </li> <li> <p> <code>ShareStatus</code>: Whether the configuration is shared with other Amazon Web Services accounts or shared with the current account by another Amazon Web Services account. Sharing is configured through Resource Access Manager (RAM).</p> </li> <li> <p> <code>Status</code>: The current status of the configuration. Valid values include the following:</p> <ul> <li> <p> <code>CREATING</code>: Resolver is creating the query logging configuration.</p> </li> <li> <p> <code>CREATED</code>: The query logging configuration was successfully created. Resolver is logging queries that originate in the specified VPC.</p> </li> <li> <p> <code>DELETING</code>: Resolver is deleting this query logging configuration.</p> </li> <li> <p> <code>FAILED</code>: Resolver either couldn\'t create or couldn\'t delete the query logging configuration. Here are two common causes:</p> <ul> <li> <p>The specified destination (for example, an Amazon S3 bucket) was deleted.</p> </li> <li> <p>Permissions don\'t allow sending logs to the destination.</p> </li> </ul> </li> </ul> </li> </ul>', ], ], 'SortOrder' => [ 'base' => NULL, 'refs' => [ 'ListResolverQueryLogConfigAssociationsRequest$SortOrder' => '<p>If you specified a value for <code>SortBy</code>, the order that you want query logging associations to be listed in, <code>ASCENDING</code> or <code>DESCENDING</code>.</p> <note> <p>If you submit a second or subsequent <code>ListResolverQueryLogConfigAssociations</code> request and specify the <code>NextToken</code> parameter, you must use the same value for <code>SortOrder</code>, if any, as in the previous request.</p> </note>', 'ListResolverQueryLogConfigsRequest$SortOrder' => '<p>If you specified a value for <code>SortBy</code>, the order that you want query logging configurations to be listed in, <code>ASCENDING</code> or <code>DESCENDING</code>.</p> <note> <p>If you submit a second or subsequent <code>ListResolverQueryLogConfigs</code> request and specify the <code>NextToken</code> parameter, you must use the same value for <code>SortOrder</code>, if any, as in the previous request.</p> </note>', ], ], 'StatusMessage' => [ 'base' => NULL, 'refs' => [ 'FirewallDomainList$StatusMessage' => '<p>Additional information about the status of the list, if available.</p>', 'FirewallRuleGroup$StatusMessage' => '<p>Additional information about the status of the rule group, if available.</p>', 'FirewallRuleGroupAssociation$StatusMessage' => '<p>Additional information about the status of the response, if available.</p>', 'ImportFirewallDomainsResponse$StatusMessage' => '<p>Additional information about the status of the list, if available.</p>', 'IpAddressResponse$StatusMessage' => '<p>A message that provides additional information about the status of the request.</p>', 'ResolverEndpoint$StatusMessage' => '<p>A detailed description of the status of the Resolver endpoint.</p>', 'ResolverRule$StatusMessage' => '<p>A detailed description of the status of a Resolver rule.</p>', 'ResolverRuleAssociation$StatusMessage' => '<p>A detailed description of the status of the association between a Resolver rule and a VPC.</p>', 'UpdateFirewallDomainsResponse$StatusMessage' => '<p>Additional information about the status of the list, if available.</p>', ], ], 'String' => [ 'base' => NULL, 'refs' => [ 'InvalidNextTokenException$Message' => NULL, 'InvalidParameterException$FieldName' => '<p>For an <code>InvalidParameterException</code> error, the name of the parameter that\'s invalid.</p>', 'LimitExceededException$Message' => NULL, 'LimitExceededException$ResourceType' => '<p>For a <code>LimitExceededException</code> error, the type of resource that exceeded the current limit.</p>', 'ResourceExistsException$Message' => NULL, 'ResourceExistsException$ResourceType' => '<p>For a <code>ResourceExistsException</code> error, the type of resource that the error applies to.</p>', 'ResourceInUseException$Message' => NULL, 'ResourceInUseException$ResourceType' => '<p>For a <code>ResourceInUseException</code> error, the type of resource that is currently in use.</p>', 'ResourceNotFoundException$Message' => NULL, 'ResourceNotFoundException$ResourceType' => '<p>For a <code>ResourceNotFoundException</code> error, the type of resource that doesn\'t exist.</p>', 'ResourceUnavailableException$Message' => NULL, 'ResourceUnavailableException$ResourceType' => '<p>For a <code>ResourceUnavailableException</code> error, the type of resource that isn\'t available.</p>', ], ], 'SubnetId' => [ 'base' => NULL, 'refs' => [ 'IpAddressRequest$SubnetId' => '<p>The ID of the subnet that contains the IP address. </p>', 'IpAddressResponse$SubnetId' => '<p>The ID of one subnet.</p>', 'IpAddressUpdate$SubnetId' => '<p>The ID of the subnet that includes the IP address that you want to update. To get this ID, use <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_GetResolverEndpoint.html">GetResolverEndpoint</a>.</p>', ], ], 'Tag' => [ 'base' => '<p>One tag that you want to add to the specified resource. A tag consists of a <code>Key</code> (a name for the tag) and a <code>Value</code>.</p>', 'refs' => [ 'TagList$member' => NULL, ], ], 'TagKey' => [ 'base' => NULL, 'refs' => [ 'Tag$Key' => '<p>The name for the tag. For example, if you want to associate Resolver resources with the account IDs of your customers for billing purposes, the value of <code>Key</code> might be <code>account-id</code>.</p>', 'TagKeyList$member' => NULL, ], ], 'TagKeyList' => [ 'base' => NULL, 'refs' => [ 'UntagResourceRequest$TagKeys' => '<p>The tags that you want to remove to the specified resource.</p>', ], ], 'TagList' => [ 'base' => NULL, 'refs' => [ 'AssociateFirewallRuleGroupRequest$Tags' => '<p>A list of the tag keys and values that you want to associate with the rule group association. </p>', 'CreateFirewallDomainListRequest$Tags' => '<p>A list of the tag keys and values that you want to associate with the domain list. </p>', 'CreateFirewallRuleGroupRequest$Tags' => '<p>A list of the tag keys and values that you want to associate with the rule group. </p>', 'CreateResolverEndpointRequest$Tags' => '<p>A list of the tag keys and values that you want to associate with the endpoint.</p>', 'CreateResolverQueryLogConfigRequest$Tags' => '<p>A list of the tag keys and values that you want to associate with the query logging configuration.</p>', 'CreateResolverRuleRequest$Tags' => '<p>A list of the tag keys and values that you want to associate with the endpoint.</p>', 'ListTagsForResourceResponse$Tags' => '<p>The tags that are associated with the resource that you specified in the <code>ListTagsForResource</code> request.</p>', 'TagResourceRequest$Tags' => '<p>The tags that you want to add to the specified resource.</p>', ], ], 'TagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'TagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'TagValue' => [ 'base' => NULL, 'refs' => [ 'Tag$Value' => '<p>The value for the tag. For example, if <code>Key</code> is <code>account-id</code>, then <code>Value</code> might be the ID of the customer account that you\'re creating the resource for.</p>', ], ], 'TargetAddress' => [ 'base' => '<p>In a <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_CreateResolverRule.html">CreateResolverRule</a> request, an array of the IPs that you want to forward DNS queries to.</p>', 'refs' => [ 'TargetList$member' => NULL, ], ], 'TargetList' => [ 'base' => NULL, 'refs' => [ 'CreateResolverRuleRequest$TargetIps' => '<p>The IPs that you want Resolver to forward DNS queries to. You can specify only IPv4 addresses. Separate IP addresses with a space.</p> <p> <code>TargetIps</code> is available only when the value of <code>Rule type</code> is <code>FORWARD</code>.</p>', 'ResolverRule$TargetIps' => '<p>An array that contains the IP addresses and ports that an outbound endpoint forwards DNS queries to. Typically, these are the IP addresses of DNS resolvers on your network. Specify IPv4 addresses. IPv6 is not supported.</p>', 'ResolverRuleConfig$TargetIps' => '<p>For DNS queries that originate in your VPC, the new IP addresses that you want to route outbound DNS queries to.</p>', ], ], 'ThrottlingException' => [ 'base' => '<p>The request was throttled. Try again in a few minutes.</p>', 'refs' => [], ], 'UnknownResourceException' => [ 'base' => '<p>The specified resource doesn\'t exist.</p>', 'refs' => [], ], 'Unsigned' => [ 'base' => NULL, 'refs' => [ 'FirewallDomainList$DomainCount' => '<p>The number of domain names that are specified in the domain list.</p>', 'FirewallRule$BlockOverrideTtl' => '<p>The recommended amount of time, in seconds, for the DNS resolver or web browser to cache the provided override record. Used for the rule action <code>BLOCK</code> with a <code>BlockResponse</code> setting of <code>OVERRIDE</code>.</p>', 'FirewallRuleGroup$RuleCount' => '<p>The number of rules in the rule group.</p>', ], ], 'UntagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'UntagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateFirewallConfigRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateFirewallConfigResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateFirewallDomainsRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateFirewallDomainsResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateFirewallRuleGroupAssociationRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateFirewallRuleGroupAssociationResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateFirewallRuleRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateFirewallRuleResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateResolverDnssecConfigRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateResolverDnssecConfigResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateResolverEndpointRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateResolverEndpointResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateResolverRuleRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateResolverRuleResponse' => [ 'base' => NULL, 'refs' => [], ], 'Validation' => [ 'base' => NULL, 'refs' => [ 'UpdateResolverDnssecConfigRequest$Validation' => '<p>The new value that you are specifying for DNSSEC validation for the VPC. The value can be <code>ENABLE</code> or <code>DISABLE</code>. Be aware that it can take time for a validation status change to be completed.</p>', ], ], 'ValidationException' => [ 'base' => '<p/>', 'refs' => [], ], ],];
