<?php
// This file was auto-generated from sdk-root/src/data/lookoutequipment/2020-12-15/docs-2.json
return [ 'version' => '2.0', 'service' => '<p>Amazon Lookout for Equipment is a machine learning service that uses advanced analytics to identify anomalies in machines from sensor data for use in predictive maintenance. </p>', 'operations' => [ 'CreateDataset' => '<p>Creates a container for a collection of data being ingested for analysis. The dataset contains the metadata describing where the data is and what the data actually looks like. In other words, it contains the location of the data source, the data schema, and other information. A dataset also contains any tags associated with the ingested data. </p>', 'CreateInferenceScheduler' => '<p> Creates a scheduled inference. Scheduling an inference is setting up a continuous real-time inference plan to analyze new measurement data. When setting up the schedule, you provide an S3 bucket location for the input data, assign it a delimiter between separate entries in the data, set an offset delay if desired, and set the frequency of inferencing. You must also provide an S3 bucket location for the output data. </p>', 'CreateModel' => '<p>Creates an ML model for data inference. </p> <p>A machine-learning (ML) model is a mathematical model that finds patterns in your data. In Amazon Lookout for Equipment, the model learns the patterns of normal behavior and detects abnormal behavior that could be potential equipment failure (or maintenance events). The models are made by analyzing normal data and abnormalities in machine behavior that have already occurred.</p> <p>Your model is trained using a portion of the data from your dataset and uses that data to learn patterns of normal behavior and abnormal patterns that lead to equipment failure. Another portion of the data is used to evaluate the model\'s accuracy. </p>', 'DeleteDataset' => '<p> Deletes a dataset and associated artifacts. The operation will check to see if any inference scheduler or data ingestion job is currently using the dataset, and if there isn\'t, the dataset, its metadata, and any associated data stored in S3 will be deleted. This does not affect any models that used this dataset for training and evaluation, but does prevent it from being used in the future. </p>', 'DeleteInferenceScheduler' => '<p>Deletes an inference scheduler that has been set up. Already processed output results are not affected. </p>', 'DeleteModel' => '<p>Deletes an ML model currently available for Amazon Lookout for Equipment. This will prevent it from being used with an inference scheduler, even one that is already set up. </p>', 'DescribeDataIngestionJob' => '<p>Provides information on a specific data ingestion job such as creation time, dataset ARN, status, and so on. </p>', 'DescribeDataset' => '<p>Provides a JSON description of the data that is in each time series dataset, including names, column names, and data types.</p>', 'DescribeInferenceScheduler' => '<p> Specifies information about the inference scheduler being used, including name, model, status, and associated metadata </p>', 'DescribeModel' => '<p>Provides a JSON containing the overall information about a specific ML model, including model name and ARN, dataset, training and evaluation information, status, and so on. </p>', 'ListDataIngestionJobs' => '<p>Provides a list of all data ingestion jobs, including dataset name and ARN, S3 location of the input data, status, and so on. </p>', 'ListDatasets' => '<p>Lists all datasets currently available in your account, filtering on the dataset name. </p>', 'ListInferenceExecutions' => '<p> Lists all inference executions that have been performed by the specified inference scheduler. </p>', 'ListInferenceSchedulers' => '<p>Retrieves a list of all inference schedulers currently available for your account. </p>', 'ListModels' => '<p>Generates a list of all models in the account, including model name and ARN, dataset, and status. </p>', 'ListTagsForResource' => '<p>Lists all the tags for a specified resource, including key and value. </p>', 'StartDataIngestionJob' => '<p>Starts a data ingestion job. Amazon Lookout for Equipment returns the job status. </p>', 'StartInferenceScheduler' => '<p>Starts an inference scheduler. </p>', 'StopInferenceScheduler' => '<p>Stops an inference scheduler. </p>', 'TagResource' => '<p>Associates a given tag to a resource in your account. A tag is a key-value pair which can be added to an Amazon Lookout for Equipment resource as metadata. Tags can be used for organizing your resources as well as helping you to search and filter by tag. Multiple tags can be added to a resource, either when you create it, or later. Up to 50 tags can be associated with each resource. </p>', 'UntagResource' => '<p>Removes a specific tag from a given resource. The tag is specified by its key. </p>', 'UpdateInferenceScheduler' => '<p>Updates an inference scheduler. </p>', ], 'shapes' => [ 'AccessDeniedException' => [ 'base' => '<p>The request could not be completed because you do not have access to the resource. </p>', 'refs' => [], ], 'AmazonResourceArn' => [ 'base' => NULL, 'refs' => [ 'ListTagsForResourceRequest$ResourceArn' => '<p>The Amazon Resource Name (ARN) of the resource (such as the dataset or model) that is the focus of the <code>ListTagsForResource</code> operation. </p>', 'TagResourceRequest$ResourceArn' => '<p>The Amazon Resource Name (ARN) of the specific resource to which the tag should be associated. </p>', 'UntagResourceRequest$ResourceArn' => '<p>The Amazon Resource Name (ARN) of the resource to which the tag is currently associated. </p>', ], ], 'BoundedLengthString' => [ 'base' => NULL, 'refs' => [ 'AccessDeniedException$Message' => NULL, 'ConflictException$Message' => NULL, 'DescribeDataIngestionJobResponse$FailedReason' => '<p>Specifies the reason for failure when a data ingestion job has failed. </p>', 'DescribeModelResponse$FailedReason' => '<p>If the training of the ML model failed, this indicates the reason for that failure. </p>', 'InferenceExecutionSummary$FailedReason' => '<p> Specifies the reason for failure when an inference execution has failed. </p>', 'InternalServerException$Message' => NULL, 'ResourceNotFoundException$Message' => NULL, 'ServiceQuotaExceededException$Message' => NULL, 'ThrottlingException$Message' => NULL, 'ValidationException$Message' => NULL, ], ], 'ComponentTimestampDelimiter' => [ 'base' => NULL, 'refs' => [ 'InferenceInputNameConfiguration$ComponentTimestampDelimiter' => '<p>Indicates the delimiter character used between items in the data. </p>', ], ], 'ConflictException' => [ 'base' => '<p> The request could not be completed due to a conflict with the current state of the target resource. </p>', 'refs' => [], ], 'CreateDatasetRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateDatasetResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateInferenceSchedulerRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateInferenceSchedulerResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateModelRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateModelResponse' => [ 'base' => NULL, 'refs' => [], ], 'DataDelayOffsetInMinutes' => [ 'base' => NULL, 'refs' => [ 'CreateInferenceSchedulerRequest$DataDelayOffsetInMinutes' => '<p>A period of time (in minutes) by which inference on the data is delayed after the data starts. For instance, if you select an offset delay time of five minutes, inference will not begin on the data until the first data measurement after the five minute mark. For example, if five minutes is selected, the inference scheduler will wake up at the configured frequency with the additional five minute delay time to check the customer S3 bucket. The customer can upload data at the same frequency and they don\'t need to stop and restart the scheduler when uploading new data. </p>', 'DescribeInferenceSchedulerResponse$DataDelayOffsetInMinutes' => '<p> A period of time (in minutes) by which inference on the data is delayed after the data starts. For instance, if you select an offset delay time of five minutes, inference will not begin on the data until the first data measurement after the five minute mark. For example, if five minutes is selected, the inference scheduler will wake up at the configured frequency with the additional five minute delay time to check the customer S3 bucket. The customer can upload data at the same frequency and they don\'t need to stop and restart the scheduler when uploading new data.</p>', 'InferenceSchedulerSummary$DataDelayOffsetInMinutes' => '<p>A period of time (in minutes) by which inference on the data is delayed after the data starts. For instance, if an offset delay time of five minutes was selected, inference will not begin on the data until the first data measurement after the five minute mark. For example, if five minutes is selected, the inference scheduler will wake up at the configured frequency with the additional five minute delay time to check the customer S3 bucket. The customer can upload data at the same frequency and they don\'t need to stop and restart the scheduler when uploading new data. </p>', 'UpdateInferenceSchedulerRequest$DataDelayOffsetInMinutes' => '<p> A period of time (in minutes) by which inference on the data is delayed after the data starts. For instance, if you select an offset delay time of five minutes, inference will not begin on the data until the first data measurement after the five minute mark. For example, if five minutes is selected, the inference scheduler will wake up at the configured frequency with the additional five minute delay time to check the customer S3 bucket. The customer can upload data at the same frequency and they don\'t need to stop and restart the scheduler when uploading new data.</p>', ], ], 'DataIngestionJobSummaries' => [ 'base' => NULL, 'refs' => [ 'ListDataIngestionJobsResponse$DataIngestionJobSummaries' => '<p>Specifies information about the specific data ingestion job, including dataset name and status. </p>', ], ], 'DataIngestionJobSummary' => [ 'base' => '<p>Provides information about a specified data ingestion job, including dataset information, data ingestion configuration, and status. </p>', 'refs' => [ 'DataIngestionJobSummaries$member' => NULL, ], ], 'DataPreProcessingConfiguration' => [ 'base' => '<p>The configuration is the <code>TargetSamplingRate</code>, which is the sampling rate of the data after post processing by Amazon Lookout for Equipment. For example, if you provide data that has been collected at a 1 second level and you want the system to resample the data at a 1 minute rate before training, the <code>TargetSamplingRate</code> is 1 minute.</p> <p>When providing a value for the <code>TargetSamplingRate</code>, you must attach the prefix "PT" to the rate you want. The value for a 1 second rate is therefore <i>PT1S</i>, the value for a 15 minute rate is <i>PT15M</i>, and the value for a 1 hour rate is <i>PT1H</i> </p>', 'refs' => [ 'CreateModelRequest$DataPreProcessingConfiguration' => '<p>The configuration is the <code>TargetSamplingRate</code>, which is the sampling rate of the data after post processing by Amazon Lookout for Equipment. For example, if you provide data that has been collected at a 1 second level and you want the system to resample the data at a 1 minute rate before training, the <code>TargetSamplingRate</code> is 1 minute.</p> <p>When providing a value for the <code>TargetSamplingRate</code>, you must attach the prefix "PT" to the rate you want. The value for a 1 second rate is therefore <i>PT1S</i>, the value for a 15 minute rate is <i>PT15M</i>, and the value for a 1 hour rate is <i>PT1H</i> </p>', 'DescribeModelResponse$DataPreProcessingConfiguration' => '<p>The configuration is the <code>TargetSamplingRate</code>, which is the sampling rate of the data after post processing by Amazon Lookout for Equipment. For example, if you provide data that has been collected at a 1 second level and you want the system to resample the data at a 1 minute rate before training, the <code>TargetSamplingRate</code> is 1 minute.</p> <p>When providing a value for the <code>TargetSamplingRate</code>, you must attach the prefix "PT" to the rate you want. The value for a 1 second rate is therefore <i>PT1S</i>, the value for a 15 minute rate is <i>PT15M</i>, and the value for a 1 hour rate is <i>PT1H</i> </p>', ], ], 'DataUploadFrequency' => [ 'base' => NULL, 'refs' => [ 'CreateInferenceSchedulerRequest$DataUploadFrequency' => '<p> How often data is uploaded to the source S3 bucket for the input data. The value chosen is the length of time between data uploads. For instance, if you select 5 minutes, Amazon Lookout for Equipment will upload the real-time data to the source bucket once every 5 minutes. This frequency also determines how often Amazon Lookout for Equipment starts a scheduled inference on your data. In this example, it starts once every 5 minutes. </p>', 'DescribeInferenceSchedulerResponse$DataUploadFrequency' => '<p>Specifies how often data is uploaded to the source S3 bucket for the input data. This value is the length of time between data uploads. For instance, if you select 5 minutes, Amazon Lookout for Equipment will upload the real-time data to the source bucket once every 5 minutes. This frequency also determines how often Amazon Lookout for Equipment starts a scheduled inference on your data. In this example, it starts once every 5 minutes. </p>', 'InferenceSchedulerSummary$DataUploadFrequency' => '<p>How often data is uploaded to the source S3 bucket for the input data. This value is the length of time between data uploads. For instance, if you select 5 minutes, Amazon Lookout for Equipment will upload the real-time data to the source bucket once every 5 minutes. This frequency also determines how often Amazon Lookout for Equipment starts a scheduled inference on your data. In this example, it starts once every 5 minutes. </p>', 'UpdateInferenceSchedulerRequest$DataUploadFrequency' => '<p>How often data is uploaded to the source S3 bucket for the input data. The value chosen is the length of time between data uploads. For instance, if you select 5 minutes, Amazon Lookout for Equipment will upload the real-time data to the source bucket once every 5 minutes. This frequency also determines how often Amazon Lookout for Equipment starts a scheduled inference on your data. In this example, it starts once every 5 minutes. </p>', ], ], 'DatasetArn' => [ 'base' => NULL, 'refs' => [ 'CreateDatasetResponse$DatasetArn' => '<p> The Amazon Resource Name (ARN) of the dataset being created. </p>', 'DataIngestionJobSummary$DatasetArn' => '<p>The Amazon Resource Name (ARN) of the dataset used in the data ingestion job. </p>', 'DatasetSummary$DatasetArn' => '<p>The Amazon Resource Name (ARN) of the specified dataset. </p>', 'DescribeDataIngestionJobResponse$DatasetArn' => '<p>The Amazon Resource Name (ARN) of the dataset being used in the data ingestion job. </p>', 'DescribeDatasetResponse$DatasetArn' => '<p>The Amazon Resource Name (ARN) of the dataset being described. </p>', 'DescribeModelResponse$DatasetArn' => '<p>The Amazon Resouce Name (ARN) of the dataset used to create the ML model being described. </p>', 'ModelSummary$DatasetArn' => '<p> The Amazon Resource Name (ARN) of the dataset used to create the model. </p>', ], ], 'DatasetIdentifier' => [ 'base' => NULL, 'refs' => [ 'CreateModelRequest$DatasetName' => '<p>The name of the dataset for the ML model being created. </p>', 'DeleteDatasetRequest$DatasetName' => '<p>The name of the dataset to be deleted. </p>', 'DescribeDatasetRequest$DatasetName' => '<p>The name of the dataset to be described. </p>', 'StartDataIngestionJobRequest$DatasetName' => '<p>The name of the dataset being used by the data ingestion job. </p>', ], ], 'DatasetName' => [ 'base' => NULL, 'refs' => [ 'CreateDatasetRequest$DatasetName' => '<p>The name of the dataset being created. </p>', 'CreateDatasetResponse$DatasetName' => '<p>The name of the dataset being created. </p>', 'DataIngestionJobSummary$DatasetName' => '<p>The name of the dataset used for the data ingestion job. </p>', 'DatasetSummary$DatasetName' => '<p>The name of the dataset. </p>', 'DescribeDatasetResponse$DatasetName' => '<p>The name of the dataset being described. </p>', 'DescribeModelResponse$DatasetName' => '<p>The name of the dataset being used by the ML being described. </p>', 'ListDataIngestionJobsRequest$DatasetName' => '<p>The name of the dataset being used for the data ingestion job. </p>', 'ListDatasetsRequest$DatasetNameBeginsWith' => '<p>The beginning of the name of the datasets to be listed. </p>', 'ListModelsRequest$DatasetNameBeginsWith' => '<p>The beginning of the name of the dataset of the ML models to be listed. </p>', 'ModelSummary$DatasetName' => '<p>The name of the dataset being used for the ML model. </p>', ], ], 'DatasetSchema' => [ 'base' => '<p>Provides information about the data schema used with the given dataset. </p>', 'refs' => [ 'CreateDatasetRequest$DatasetSchema' => '<p>A JSON description of the data that is in each time series dataset, including names, column names, and data types. </p>', 'CreateModelRequest$DatasetSchema' => '<p>The data schema for the ML model being created. </p>', ], ], 'DatasetStatus' => [ 'base' => NULL, 'refs' => [ 'CreateDatasetResponse$Status' => '<p>Indicates the status of the <code>CreateDataset</code> operation. </p>', 'DatasetSummary$Status' => '<p>Indicates the status of the dataset. </p>', 'DescribeDatasetResponse$Status' => '<p>Indicates the status of the dataset. </p>', ], ], 'DatasetSummaries' => [ 'base' => NULL, 'refs' => [ 'ListDatasetsResponse$DatasetSummaries' => '<p>Provides information about the specified dataset, including creation time, dataset ARN, and status. </p>', ], ], 'DatasetSummary' => [ 'base' => '<p>Contains information about the specific data set, including name, ARN, and status. </p>', 'refs' => [ 'DatasetSummaries$member' => NULL, ], ], 'DeleteDatasetRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteInferenceSchedulerRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteModelRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeDataIngestionJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeDataIngestionJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeDatasetRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeDatasetResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeInferenceSchedulerRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeInferenceSchedulerResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeModelRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeModelResponse' => [ 'base' => NULL, 'refs' => [], ], 'FileNameTimestampFormat' => [ 'base' => NULL, 'refs' => [ 'InferenceInputNameConfiguration$TimestampFormat' => '<p>The format of the timestamp, whether Epoch time, or standard, with or without hyphens (-). </p>', ], ], 'IamRoleArn' => [ 'base' => NULL, 'refs' => [ 'CreateInferenceSchedulerRequest$RoleArn' => '<p>The Amazon Resource Name (ARN) of a role with permission to access the data source being used for the inference. </p>', 'CreateModelRequest$RoleArn' => '<p> The Amazon Resource Name (ARN) of a role with permission to access the data source being used to create the ML model. </p>', 'DescribeDataIngestionJobResponse$RoleArn' => '<p>The Amazon Resource Name (ARN) of an IAM role with permission to access the data source being ingested. </p>', 'DescribeInferenceSchedulerResponse$RoleArn' => '<p> The Amazon Resource Name (ARN) of a role with permission to access the data source for the inference scheduler being described. </p>', 'DescribeModelResponse$RoleArn' => '<p> The Amazon Resource Name (ARN) of a role with permission to access the data source for the ML model being described. </p>', 'StartDataIngestionJobRequest$RoleArn' => '<p> The Amazon Resource Name (ARN) of a role with permission to access the data source for the data ingestion job. </p>', 'UpdateInferenceSchedulerRequest$RoleArn' => '<p> The Amazon Resource Name (ARN) of a role with permission to access the data source for the inference scheduler. </p>', ], ], 'IdempotenceToken' => [ 'base' => NULL, 'refs' => [ 'CreateDatasetRequest$ClientToken' => '<p> A unique identifier for the request. If you do not set the client request token, Amazon Lookout for Equipment generates one. </p>', 'CreateInferenceSchedulerRequest$ClientToken' => '<p> A unique identifier for the request. If you do not set the client request token, Amazon Lookout for Equipment generates one. </p>', 'CreateModelRequest$ClientToken' => '<p>A unique identifier for the request. If you do not set the client request token, Amazon Lookout for Equipment generates one. </p>', 'StartDataIngestionJobRequest$ClientToken' => '<p> A unique identifier for the request. If you do not set the client request token, Amazon Lookout for Equipment generates one. </p>', ], ], 'InferenceExecutionStatus' => [ 'base' => NULL, 'refs' => [ 'InferenceExecutionSummary$Status' => '<p>Indicates the status of the inference execution. </p>', 'ListInferenceExecutionsRequest$Status' => '<p>The status of the inference execution. </p>', ], ], 'InferenceExecutionSummaries' => [ 'base' => NULL, 'refs' => [ 'ListInferenceExecutionsResponse$InferenceExecutionSummaries' => '<p>Provides an array of information about the individual inference executions returned from the <code>ListInferenceExecutions</code> operation, including model used, inference scheduler, data configuration, and so on. </p>', ], ], 'InferenceExecutionSummary' => [ 'base' => '<p>Contains information about the specific inference execution, including input and output data configuration, inference scheduling information, status, and so on. </p>', 'refs' => [ 'InferenceExecutionSummaries$member' => NULL, ], ], 'InferenceInputConfiguration' => [ 'base' => '<p>Specifies configuration information for the input data for the inference, including S3 location of input data.. </p>', 'refs' => [ 'CreateInferenceSchedulerRequest$DataInputConfiguration' => '<p>Specifies configuration information for the input data for the inference scheduler, including delimiter, format, and dataset location. </p>', 'DescribeInferenceSchedulerResponse$DataInputConfiguration' => '<p> Specifies configuration information for the input data for the inference scheduler, including delimiter, format, and dataset location. </p>', 'InferenceExecutionSummary$DataInputConfiguration' => '<p> Specifies configuration information for the input data for the inference scheduler, including delimiter, format, and dataset location. </p>', 'UpdateInferenceSchedulerRequest$DataInputConfiguration' => '<p> Specifies information for the input data for the inference scheduler, including delimiter, format, and dataset location. </p>', ], ], 'InferenceInputNameConfiguration' => [ 'base' => '<p>Specifies configuration information for the input data for the inference, including timestamp format and delimiter. </p>', 'refs' => [ 'InferenceInputConfiguration$InferenceInputNameConfiguration' => '<p>Specifies configuration information for the input data for the inference, including timestamp format and delimiter. </p>', ], ], 'InferenceOutputConfiguration' => [ 'base' => '<p> Specifies configuration information for the output results from for the inference, including KMS key ID and output S3 location. </p>', 'refs' => [ 'CreateInferenceSchedulerRequest$DataOutputConfiguration' => '<p>Specifies configuration information for the output results for the inference scheduler, including the S3 location for the output. </p>', 'DescribeInferenceSchedulerResponse$DataOutputConfiguration' => '<p> Specifies information for the output results for the inference scheduler, including the output S3 location. </p>', 'InferenceExecutionSummary$DataOutputConfiguration' => '<p> Specifies configuration information for the output results from for the inference execution, including the output S3 location. </p>', 'UpdateInferenceSchedulerRequest$DataOutputConfiguration' => '<p> Specifies information for the output results from the inference scheduler, including the output S3 location. </p>', ], ], 'InferenceS3InputConfiguration' => [ 'base' => '<p> Specifies configuration information for the input data for the inference, including input data S3 location. </p>', 'refs' => [ 'InferenceInputConfiguration$S3InputConfiguration' => '<p> Specifies configuration information for the input data for the inference, including S3 location of input data.. </p>', ], ], 'InferenceS3OutputConfiguration' => [ 'base' => '<p> Specifies configuration information for the output results from the inference, including output S3 location. </p>', 'refs' => [ 'InferenceOutputConfiguration$S3OutputConfiguration' => '<p> Specifies configuration information for the output results from for the inference, output S3 location. </p>', ], ], 'InferenceSchedulerArn' => [ 'base' => NULL, 'refs' => [ 'CreateInferenceSchedulerResponse$InferenceSchedulerArn' => '<p>The Amazon Resource Name (ARN) of the inference scheduler being created. </p>', 'DescribeInferenceSchedulerResponse$InferenceSchedulerArn' => '<p>The Amazon Resource Name (ARN) of the inference scheduler being described. </p>', 'InferenceExecutionSummary$InferenceSchedulerArn' => '<p> The Amazon Resource Name (ARN) of the inference scheduler being used for the inference execution. </p>', 'InferenceSchedulerSummary$InferenceSchedulerArn' => '<p> The Amazon Resource Name (ARN) of the inference scheduler. </p>', 'StartInferenceSchedulerResponse$InferenceSchedulerArn' => '<p>The Amazon Resource Name (ARN) of the inference scheduler being started. </p>', 'StopInferenceSchedulerResponse$InferenceSchedulerArn' => '<p>The Amazon Resource Name (ARN) of the inference schedule being stopped. </p>', ], ], 'InferenceSchedulerIdentifier' => [ 'base' => NULL, 'refs' => [ 'DeleteInferenceSchedulerRequest$InferenceSchedulerName' => '<p>The name of the inference scheduler to be deleted. </p>', 'DescribeInferenceSchedulerRequest$InferenceSchedulerName' => '<p>The name of the inference scheduler being described. </p>', 'ListInferenceExecutionsRequest$InferenceSchedulerName' => '<p>The name of the inference scheduler for the inference execution listed. </p>', 'ListInferenceSchedulersRequest$InferenceSchedulerNameBeginsWith' => '<p>The beginning of the name of the inference schedulers to be listed. </p>', 'StartInferenceSchedulerRequest$InferenceSchedulerName' => '<p>The name of the inference scheduler to be started. </p>', 'StopInferenceSchedulerRequest$InferenceSchedulerName' => '<p>The name of the inference scheduler to be stopped. </p>', 'UpdateInferenceSchedulerRequest$InferenceSchedulerName' => '<p>The name of the inference scheduler to be updated. </p>', ], ], 'InferenceSchedulerName' => [ 'base' => NULL, 'refs' => [ 'CreateInferenceSchedulerRequest$InferenceSchedulerName' => '<p>The name of the inference scheduler being created. </p>', 'CreateInferenceSchedulerResponse$InferenceSchedulerName' => '<p>The name of inference scheduler being created. </p>', 'DescribeInferenceSchedulerResponse$InferenceSchedulerName' => '<p>The name of the inference scheduler being described. </p>', 'InferenceExecutionSummary$InferenceSchedulerName' => '<p>The name of the inference scheduler being used for the inference execution. </p>', 'InferenceSchedulerSummary$InferenceSchedulerName' => '<p>The name of the inference scheduler. </p>', 'StartInferenceSchedulerResponse$InferenceSchedulerName' => '<p>The name of the inference scheduler being started. </p>', 'StopInferenceSchedulerResponse$InferenceSchedulerName' => '<p>The name of the inference scheduler being stopped. </p>', ], ], 'InferenceSchedulerStatus' => [ 'base' => NULL, 'refs' => [ 'CreateInferenceSchedulerResponse$Status' => '<p>Indicates the status of the <code>CreateInferenceScheduler</code> operation. </p>', 'DescribeInferenceSchedulerResponse$Status' => '<p>Indicates the status of the inference scheduler. </p>', 'InferenceSchedulerSummary$Status' => '<p>Indicates the status of the inference scheduler. </p>', 'StartInferenceSchedulerResponse$Status' => '<p>Indicates the status of the inference scheduler. </p>', 'StopInferenceSchedulerResponse$Status' => '<p>Indicates the status of the inference scheduler. </p>', ], ], 'InferenceSchedulerSummaries' => [ 'base' => NULL, 'refs' => [ 'ListInferenceSchedulersResponse$InferenceSchedulerSummaries' => '<p>Provides information about the specified inference scheduler, including data upload frequency, model name and ARN, and status. </p>', ], ], 'InferenceSchedulerSummary' => [ 'base' => '<p>Contains information about the specific inference scheduler, including data delay offset, model name and ARN, status, and so on. </p>', 'refs' => [ 'InferenceSchedulerSummaries$member' => NULL, ], ], 'IngestionInputConfiguration' => [ 'base' => '<p> Specifies configuration information for the input data for the data ingestion job, including input data S3 location. </p>', 'refs' => [ 'DataIngestionJobSummary$IngestionInputConfiguration' => '<p> Specifies information for the input data for the data inference job, including data S3 location parameters. </p>', 'DescribeDataIngestionJobResponse$IngestionInputConfiguration' => '<p>Specifies the S3 location configuration for the data input for the data ingestion job. </p>', 'DescribeDatasetResponse$IngestionInputConfiguration' => '<p>Specifies the S3 location configuration for the data input for the data ingestion job. </p>', 'StartDataIngestionJobRequest$IngestionInputConfiguration' => '<p> Specifies information for the input data for the data ingestion job, including dataset S3 location. </p>', ], ], 'IngestionJobId' => [ 'base' => NULL, 'refs' => [ 'DataIngestionJobSummary$JobId' => '<p>Indicates the job ID of the data ingestion job. </p>', 'DescribeDataIngestionJobRequest$JobId' => '<p>The job ID of the data ingestion job. </p>', 'DescribeDataIngestionJobResponse$JobId' => '<p>Indicates the job ID of the data ingestion job. </p>', 'StartDataIngestionJobResponse$JobId' => '<p>Indicates the job ID of the data ingestion job. </p>', ], ], 'IngestionJobStatus' => [ 'base' => NULL, 'refs' => [ 'DataIngestionJobSummary$Status' => '<p>Indicates the status of the data ingestion job. </p>', 'DescribeDataIngestionJobResponse$Status' => '<p>Indicates the status of the <code>DataIngestionJob</code> operation. </p>', 'ListDataIngestionJobsRequest$Status' => '<p>Indicates the status of the data ingestion job. </p>', 'StartDataIngestionJobResponse$Status' => '<p>Indicates the status of the <code>StartDataIngestionJob</code> operation. </p>', ], ], 'IngestionS3InputConfiguration' => [ 'base' => '<p> Specifies S3 configuration information for the input data for the data ingestion job. </p>', 'refs' => [ 'IngestionInputConfiguration$S3InputConfiguration' => '<p>The location information for the S3 bucket used for input data for the data ingestion. </p>', ], ], 'InlineDataSchema' => [ 'base' => NULL, 'refs' => [ 'DatasetSchema$InlineDataSchema' => '<p> </p>', 'DescribeDatasetResponse$Schema' => '<p>A JSON description of the data that is in each time series dataset, including names, column names, and data types. </p>', 'DescribeModelResponse$Schema' => '<p>A JSON description of the data that is in each time series dataset, including names, column names, and data types. </p>', ], ], 'InternalServerException' => [ 'base' => '<p> Processing of the request has failed because of an unknown error, exception or failure. </p>', 'refs' => [], ], 'KmsKeyArn' => [ 'base' => NULL, 'refs' => [ 'DescribeDatasetResponse$ServerSideKmsKeyId' => '<p>Provides the identifier of the KMS key used to encrypt dataset data by Amazon Lookout for Equipment. </p>', 'DescribeInferenceSchedulerResponse$ServerSideKmsKeyId' => '<p>Provides the identifier of the KMS key used to encrypt inference scheduler data by Amazon Lookout for Equipment. </p>', 'DescribeModelResponse$ServerSideKmsKeyId' => '<p>Provides the identifier of the KMS key used to encrypt model data by Amazon Lookout for Equipment. </p>', ], ], 'LabelsInputConfiguration' => [ 'base' => '<p>Contains the configuration information for the S3 location being used to hold label data. </p>', 'refs' => [ 'CreateModelRequest$LabelsInputConfiguration' => '<p>The input configuration for the labels being used for the ML model that\'s being created. </p>', 'DescribeModelResponse$LabelsInputConfiguration' => '<p>Specifies configuration information about the labels input, including its S3 location. </p>', ], ], 'LabelsS3InputConfiguration' => [ 'base' => '<p>The location information (prefix and bucket name) for the s3 location being used for label data. </p>', 'refs' => [ 'LabelsInputConfiguration$S3InputConfiguration' => '<p>Contains location information for the S3 location being used for label data. </p>', ], ], 'ListDataIngestionJobsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListDataIngestionJobsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListDatasetsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListDatasetsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListInferenceExecutionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListInferenceExecutionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListInferenceSchedulersRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListInferenceSchedulersResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListModelsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListModelsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'MaxResults' => [ 'base' => NULL, 'refs' => [ 'ListDataIngestionJobsRequest$MaxResults' => '<p> Specifies the maximum number of data ingestion jobs to list. </p>', 'ListDatasetsRequest$MaxResults' => '<p> Specifies the maximum number of datasets to list. </p>', 'ListInferenceExecutionsRequest$MaxResults' => '<p>Specifies the maximum number of inference executions to list. </p>', 'ListInferenceSchedulersRequest$MaxResults' => '<p> Specifies the maximum number of inference schedulers to list. </p>', 'ListModelsRequest$MaxResults' => '<p> Specifies the maximum number of ML models to list. </p>', ], ], 'ModelArn' => [ 'base' => NULL, 'refs' => [ 'CreateModelResponse$ModelArn' => '<p>The Amazon Resource Name (ARN) of the model being created. </p>', 'DescribeInferenceSchedulerResponse$ModelArn' => '<p>The Amazon Resource Name (ARN) of the ML model of the inference scheduler being described. </p>', 'DescribeModelResponse$ModelArn' => '<p>The Amazon Resource Name (ARN) of the ML model being described. </p>', 'InferenceExecutionSummary$ModelArn' => '<p>The Amazon Resource Name (ARN) of the ML model used for the inference execution. </p>', 'InferenceSchedulerSummary$ModelArn' => '<p> The Amazon Resource Name (ARN) of the ML model used by the inference scheduler. </p>', 'ModelSummary$ModelArn' => '<p> The Amazon Resource Name (ARN) of the ML model. </p>', 'StartInferenceSchedulerResponse$ModelArn' => '<p>The Amazon Resource Name (ARN) of the ML model being used by the inference scheduler. </p>', 'StopInferenceSchedulerResponse$ModelArn' => '<p>The Amazon Resource Name (ARN) of the ML model used by the inference scheduler being stopped. </p>', ], ], 'ModelMetrics' => [ 'base' => NULL, 'refs' => [ 'DescribeModelResponse$ModelMetrics' => '<p>The Model Metrics show an aggregated summary of the model\'s performance within the evaluation time range. This is the JSON content of the metrics created when evaluating the model. </p>', ], ], 'ModelName' => [ 'base' => NULL, 'refs' => [ 'CreateInferenceSchedulerRequest$ModelName' => '<p>The name of the previously trained ML model being used to create the inference scheduler. </p>', 'CreateModelRequest$ModelName' => '<p>The name for the ML model to be created.</p>', 'DeleteModelRequest$ModelName' => '<p>The name of the ML model to be deleted. </p>', 'DescribeInferenceSchedulerResponse$ModelName' => '<p>The name of the ML model of the inference scheduler being described. </p>', 'DescribeModelRequest$ModelName' => '<p>The name of the ML model to be described. </p>', 'DescribeModelResponse$ModelName' => '<p>The name of the ML model being described. </p>', 'InferenceExecutionSummary$ModelName' => '<p>The name of the ML model being used for the inference execution. </p>', 'InferenceSchedulerSummary$ModelName' => '<p>The name of the ML model used for the inference scheduler. </p>', 'ListInferenceSchedulersRequest$ModelName' => '<p>The name of the ML model used by the inference scheduler to be listed. </p>', 'ListModelsRequest$ModelNameBeginsWith' => '<p>The beginning of the name of the ML models being listed. </p>', 'ModelSummary$ModelName' => '<p>The name of the ML model. </p>', 'StartInferenceSchedulerResponse$ModelName' => '<p>The name of the ML model being used by the inference scheduler. </p>', 'StopInferenceSchedulerResponse$ModelName' => '<p>The name of the ML model used by the inference scheduler being stopped. </p>', ], ], 'ModelStatus' => [ 'base' => NULL, 'refs' => [ 'CreateModelResponse$Status' => '<p>Indicates the status of the <code>CreateModel</code> operation. </p>', 'DescribeModelResponse$Status' => '<p>Specifies the current status of the model being described. Status describes the status of the most recent action of the model. </p>', 'ListModelsRequest$Status' => '<p>The status of the ML model. </p>', 'ModelSummary$Status' => '<p>Indicates the status of the ML model. </p>', ], ], 'ModelSummaries' => [ 'base' => NULL, 'refs' => [ 'ListModelsResponse$ModelSummaries' => '<p>Provides information on the specified model, including created time, model and dataset ARNs, and status. </p>', ], ], 'ModelSummary' => [ 'base' => '<p>Provides information about the specified ML model, including dataset and model names and ARNs, as well as status. </p>', 'refs' => [ 'ModelSummaries$member' => NULL, ], ], 'NameOrArn' => [ 'base' => NULL, 'refs' => [ 'CreateDatasetRequest$ServerSideKmsKeyId' => '<p>Provides the identifier of the KMS key used to encrypt dataset data by Amazon Lookout for Equipment. </p>', 'CreateInferenceSchedulerRequest$ServerSideKmsKeyId' => '<p>Provides the identifier of the KMS key used to encrypt inference scheduler data by Amazon Lookout for Equipment. </p>', 'CreateModelRequest$ServerSideKmsKeyId' => '<p>Provides the identifier of the KMS key used to encrypt model data by Amazon Lookout for Equipment. </p>', 'InferenceOutputConfiguration$KmsKeyId' => '<p>The ID number for the AWS KMS key used to encrypt the inference output. </p>', ], ], 'NextToken' => [ 'base' => NULL, 'refs' => [ 'ListDataIngestionJobsRequest$NextToken' => '<p> An opaque pagination token indicating where to continue the listing of data ingestion jobs. </p>', 'ListDataIngestionJobsResponse$NextToken' => '<p> An opaque pagination token indicating where to continue the listing of data ingestion jobs. </p>', 'ListDatasetsRequest$NextToken' => '<p> An opaque pagination token indicating where to continue the listing of datasets. </p>', 'ListDatasetsResponse$NextToken' => '<p> An opaque pagination token indicating where to continue the listing of datasets. </p>', 'ListInferenceExecutionsRequest$NextToken' => '<p>An opaque pagination token indicating where to continue the listing of inference executions.</p>', 'ListInferenceExecutionsResponse$NextToken' => '<p> An opaque pagination token indicating where to continue the listing of inference executions. </p>', 'ListInferenceSchedulersRequest$NextToken' => '<p> An opaque pagination token indicating where to continue the listing of inference schedulers. </p>', 'ListInferenceSchedulersResponse$NextToken' => '<p> An opaque pagination token indicating where to continue the listing of inference schedulers. </p>', 'ListModelsRequest$NextToken' => '<p> An opaque pagination token indicating where to continue the listing of ML models. </p>', 'ListModelsResponse$NextToken' => '<p> An opaque pagination token indicating where to continue the listing of ML models. </p>', ], ], 'OffCondition' => [ 'base' => NULL, 'refs' => [ 'CreateModelRequest$OffCondition' => '<p>Indicates that the asset associated with this sensor has been shut off. As long as this condition is met, Lookout for Equipment will not use data from this asset for training, evaluation, or inference.</p>', 'DescribeModelResponse$OffCondition' => '<p>Indicates that the asset associated with this sensor has been shut off. As long as this condition is met, Lookout for Equipment will not use data from this asset for training, evaluation, or inference.</p>', ], ], 'ResourceNotFoundException' => [ 'base' => '<p> The resource requested could not be found. Verify the resource ID and retry your request. </p>', 'refs' => [], ], 'S3Bucket' => [ 'base' => NULL, 'refs' => [ 'InferenceS3InputConfiguration$Bucket' => '<p>The bucket containing the input dataset for the inference. </p>', 'InferenceS3OutputConfiguration$Bucket' => '<p> The bucket containing the output results from the inference </p>', 'IngestionS3InputConfiguration$Bucket' => '<p>The name of the S3 bucket used for the input data for the data ingestion. </p>', 'LabelsS3InputConfiguration$Bucket' => '<p>The name of the S3 bucket holding the label data. </p>', 'S3Object$Bucket' => '<p>The name of the specific S3 bucket. </p>', ], ], 'S3Key' => [ 'base' => NULL, 'refs' => [ 'S3Object$Key' => '<p>The AWS Key Management Service (AWS KMS) key being used to encrypt the S3 object. Without this key, data in the bucket is not accessible. </p>', ], ], 'S3Object' => [ 'base' => '<p>Contains information about an S3 bucket. </p>', 'refs' => [ 'InferenceExecutionSummary$CustomerResultObject' => '<p> </p>', ], ], 'S3Prefix' => [ 'base' => NULL, 'refs' => [ 'InferenceS3InputConfiguration$Prefix' => '<p>The prefix for the S3 bucket used for the input data for the inference. </p>', 'InferenceS3OutputConfiguration$Prefix' => '<p> The prefix for the S3 bucket used for the output results from the inference. </p>', 'IngestionS3InputConfiguration$Prefix' => '<p>The prefix for the S3 location being used for the input data for the data ingestion. </p>', 'LabelsS3InputConfiguration$Prefix' => '<p> The prefix for the S3 bucket used for the label data. </p>', ], ], 'ServiceQuotaExceededException' => [ 'base' => '<p> Resource limitations have been exceeded. </p>', 'refs' => [], ], 'StartDataIngestionJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'StartDataIngestionJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'StartInferenceSchedulerRequest' => [ 'base' => NULL, 'refs' => [], ], 'StartInferenceSchedulerResponse' => [ 'base' => NULL, 'refs' => [], ], 'StopInferenceSchedulerRequest' => [ 'base' => NULL, 'refs' => [], ], 'StopInferenceSchedulerResponse' => [ 'base' => NULL, 'refs' => [], ], 'Tag' => [ 'base' => '<p>A tag is a key-value pair that can be added to a resource as metadata. </p>', 'refs' => [ 'TagList$member' => NULL, ], ], 'TagKey' => [ 'base' => NULL, 'refs' => [ 'Tag$Key' => '<p>The key for the specified tag. </p>', 'TagKeyList$member' => NULL, ], ], 'TagKeyList' => [ 'base' => NULL, 'refs' => [ 'UntagResourceRequest$TagKeys' => '<p>Specifies the key of the tag to be removed from a specified resource. </p>', ], ], 'TagList' => [ 'base' => NULL, 'refs' => [ 'CreateDatasetRequest$Tags' => '<p>Any tags associated with the ingested data described in the dataset. </p>', 'CreateInferenceSchedulerRequest$Tags' => '<p>Any tags associated with the inference scheduler. </p>', 'CreateModelRequest$Tags' => '<p> Any tags associated with the ML model being created. </p>', 'ListTagsForResourceResponse$Tags' => '<p> Any tags associated with the resource. </p>', 'TagResourceRequest$Tags' => '<p>The tag or tags to be associated with a specific resource. Both the tag key and value are specified. </p>', ], ], 'TagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'TagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'TagValue' => [ 'base' => NULL, 'refs' => [ 'Tag$Value' => '<p>The value for the specified tag. </p>', ], ], 'TargetSamplingRate' => [ 'base' => NULL, 'refs' => [ 'DataPreProcessingConfiguration$TargetSamplingRate' => '<p>The sampling rate of the data after post processing by Amazon Lookout for Equipment. For example, if you provide data that has been collected at a 1 second level and you want the system to resample the data at a 1 minute rate before training, the <code>TargetSamplingRate</code> is 1 minute.</p> <p>When providing a value for the <code>TargetSamplingRate</code>, you must attach the prefix "PT" to the rate you want. The value for a 1 second rate is therefore <i>PT1S</i>, the value for a 15 minute rate is <i>PT15M</i>, and the value for a 1 hour rate is <i>PT1H</i> </p>', ], ], 'ThrottlingException' => [ 'base' => '<p>The request was denied due to request throttling.</p>', 'refs' => [], ], 'TimeZoneOffset' => [ 'base' => NULL, 'refs' => [ 'InferenceInputConfiguration$InputTimeZoneOffset' => '<p>Indicates the difference between your time zone and Greenwich Mean Time (GMT). </p>', ], ], 'Timestamp' => [ 'base' => NULL, 'refs' => [ 'CreateModelRequest$TrainingDataStartTime' => '<p>Indicates the time reference in the dataset that should be used to begin the subset of training data for the ML model. </p>', 'CreateModelRequest$TrainingDataEndTime' => '<p>Indicates the time reference in the dataset that should be used to end the subset of training data for the ML model. </p>', 'CreateModelRequest$EvaluationDataStartTime' => '<p>Indicates the time reference in the dataset that should be used to begin the subset of evaluation data for the ML model. </p>', 'CreateModelRequest$EvaluationDataEndTime' => '<p> Indicates the time reference in the dataset that should be used to end the subset of evaluation data for the ML model. </p>', 'DatasetSummary$CreatedAt' => '<p>The time at which the dataset was created in Amazon Lookout for Equipment. </p>', 'DescribeDataIngestionJobResponse$CreatedAt' => '<p>The time at which the data ingestion job was created. </p>', 'DescribeDatasetResponse$CreatedAt' => '<p>Specifies the time the dataset was created in Amazon Lookout for Equipment. </p>', 'DescribeDatasetResponse$LastUpdatedAt' => '<p>Specifies the time the dataset was last updated, if it was. </p>', 'DescribeInferenceSchedulerResponse$CreatedAt' => '<p>Specifies the time at which the inference scheduler was created. </p>', 'DescribeInferenceSchedulerResponse$UpdatedAt' => '<p>Specifies the time at which the inference scheduler was last updated, if it was. </p>', 'DescribeModelResponse$TrainingDataStartTime' => '<p> Indicates the time reference in the dataset that was used to begin the subset of training data for the ML model. </p>', 'DescribeModelResponse$TrainingDataEndTime' => '<p> Indicates the time reference in the dataset that was used to end the subset of training data for the ML model. </p>', 'DescribeModelResponse$EvaluationDataStartTime' => '<p> Indicates the time reference in the dataset that was used to begin the subset of evaluation data for the ML model. </p>', 'DescribeModelResponse$EvaluationDataEndTime' => '<p> Indicates the time reference in the dataset that was used to end the subset of evaluation data for the ML model. </p>', 'DescribeModelResponse$TrainingExecutionStartTime' => '<p>Indicates the time at which the training of the ML model began. </p>', 'DescribeModelResponse$TrainingExecutionEndTime' => '<p>Indicates the time at which the training of the ML model was completed. </p>', 'DescribeModelResponse$LastUpdatedTime' => '<p>Indicates the last time the ML model was updated. The type of update is not specified. </p>', 'DescribeModelResponse$CreatedAt' => '<p>Indicates the time and date at which the ML model was created. </p>', 'InferenceExecutionSummary$ScheduledStartTime' => '<p>Indicates the start time at which the inference scheduler began the specific inference execution. </p>', 'InferenceExecutionSummary$DataStartTime' => '<p>Indicates the time reference in the dataset at which the inference execution began. </p>', 'InferenceExecutionSummary$DataEndTime' => '<p>Indicates the time reference in the dataset at which the inference execution stopped. </p>', 'ListInferenceExecutionsRequest$DataStartTimeAfter' => '<p>The time reference in the inferenced dataset after which Amazon Lookout for Equipment started the inference execution. </p>', 'ListInferenceExecutionsRequest$DataEndTimeBefore' => '<p>The time reference in the inferenced dataset before which Amazon Lookout for Equipment stopped the inference execution. </p>', 'ModelSummary$CreatedAt' => '<p>The time at which the specific model was created. </p>', ], ], 'UntagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'UntagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateInferenceSchedulerRequest' => [ 'base' => NULL, 'refs' => [], ], 'ValidationException' => [ 'base' => '<p> The input fails to satisfy constraints specified by Amazon Lookout for Equipment or a related AWS service that\'s being utilized. </p>', 'refs' => [], ], ],];
