<?php
// This file was auto-generated from sdk-root/src/data/healthlake/2017-07-01/docs-2.json
return [ 'version' => '2.0', 'service' => '<p>Amazon HealthLake is a HIPAA eligibile service that allows customers to store, transform, query, and analyze their FHIR-formatted data in a consistent fashion in the cloud.</p>', 'operations' => [ 'CreateFHIRDatastore' => '<p>Creates a Data Store that can ingest and export FHIR formatted data.</p>', 'DeleteFHIRDatastore' => '<p>Deletes a Data Store. </p>', 'DescribeFHIRDatastore' => '<p>Gets the properties associated with the FHIR Data Store, including the Data Store ID, Data Store ARN, Data Store name, Data Store status, created at, Data Store type version, and Data Store endpoint.</p>', 'DescribeFHIRExportJob' => '<p>Displays the properties of a FHIR export job, including the ID, ARN, name, and the status of the job.</p>', 'DescribeFHIRImportJob' => '<p>Displays the properties of a FHIR import job, including the ID, ARN, name, and the status of the job. </p>', 'ListFHIRDatastores' => '<p>Lists all FHIR Data Stores that are in the user’s account, regardless of Data Store status.</p>', 'ListFHIRExportJobs' => '<p> Lists all FHIR export jobs associated with an account and their statuses. </p>', 'ListFHIRImportJobs' => '<p> Lists all FHIR import jobs associated with an account and their statuses. </p>', 'ListTagsForResource' => '<p> Returns a list of all existing tags associated with a Data Store. </p>', 'StartFHIRExportJob' => '<p>Begins a FHIR export job.</p>', 'StartFHIRImportJob' => '<p>Begins a FHIR Import job.</p>', 'TagResource' => '<p> Adds a user specifed key and value tag to a Data Store. </p>', 'UntagResource' => '<p> Removes tags from a Data Store. </p>', ], 'shapes' => [ 'AccessDeniedException' => [ 'base' => '<p>Access is denied. Your account is not authorized to perform this operation.</p>', 'refs' => [], ], 'AmazonResourceName' => [ 'base' => NULL, 'refs' => [ 'ListTagsForResourceRequest$ResourceARN' => '<p> The Amazon Resource Name(ARN) of the Data Store for which tags are being added. </p>', 'TagResourceRequest$ResourceARN' => '<p> The Amazon Resource Name(ARN)that gives Amazon HealthLake access to the Data Store which tags are being added to. </p>', 'UntagResourceRequest$ResourceARN' => '<p> "The Amazon Resource Name(ARN) of the Data Store for which tags are being removed </p>', ], ], 'BoundedLengthString' => [ 'base' => NULL, 'refs' => [ 'CreateFHIRDatastoreResponse$DatastoreEndpoint' => '<p>The AWS endpoint for the created Data Store. For preview, only US-east-1 endpoints are supported.</p>', 'DeleteFHIRDatastoreResponse$DatastoreEndpoint' => '<p>The AWS endpoint for the Data Store the user has requested to be deleted.</p>', ], ], 'ClientTokenString' => [ 'base' => NULL, 'refs' => [ 'CreateFHIRDatastoreRequest$ClientToken' => '<p>Optional user provided token used for ensuring idempotency.</p>', 'StartFHIRExportJobRequest$ClientToken' => '<p>An optional user provided token used for ensuring idempotency.</p>', 'StartFHIRImportJobRequest$ClientToken' => '<p>Optional user provided token used for ensuring idempotency.</p>', ], ], 'CmkType' => [ 'base' => NULL, 'refs' => [ 'KmsEncryptionConfig$CmkType' => '<p> The type of customer-managed-key(CMK) used for encyrption. The two types of supported CMKs are customer owned CMKs and AWS owned CMKs. </p>', ], ], 'ConflictException' => [ 'base' => '<p>The Data Store is in a transition state and the user requested action can not be performed.</p>', 'refs' => [], ], 'CreateFHIRDatastoreRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateFHIRDatastoreResponse' => [ 'base' => NULL, 'refs' => [], ], 'DatastoreArn' => [ 'base' => NULL, 'refs' => [ 'CreateFHIRDatastoreResponse$DatastoreArn' => '<p>The datastore ARN is generated during the creation of the Data Store and can be found in the output from the initial Data Store creation call.</p>', 'DatastoreProperties$DatastoreArn' => '<p>The Amazon Resource Name used in the creation of the Data Store.</p>', 'DeleteFHIRDatastoreResponse$DatastoreArn' => '<p>The Amazon Resource Name (ARN) that gives Amazon HealthLake access permission.</p>', ], ], 'DatastoreFilter' => [ 'base' => '<p>The filters applied to Data Store query.</p>', 'refs' => [ 'ListFHIRDatastoresRequest$Filter' => '<p>Lists all filters associated with a FHIR Data Store request.</p>', ], ], 'DatastoreId' => [ 'base' => NULL, 'refs' => [ 'CreateFHIRDatastoreResponse$DatastoreId' => '<p>The AWS-generated Data Store id. This id is in the output from the initial Data Store creation call.</p>', 'DatastoreProperties$DatastoreId' => '<p>The AWS-generated ID number for the Data Store.</p>', 'DeleteFHIRDatastoreRequest$DatastoreId' => '<p> The AWS-generated ID for the Data Store to be deleted.</p>', 'DeleteFHIRDatastoreResponse$DatastoreId' => '<p>The AWS-generated ID for the Data Store to be deleted.</p>', 'DescribeFHIRDatastoreRequest$DatastoreId' => '<p>The AWS-generated Data Store id. This is part of the ‘CreateFHIRDatastore’ output.</p>', 'DescribeFHIRExportJobRequest$DatastoreId' => '<p>The AWS generated ID for the Data Store from which files are being exported from for an export job.</p>', 'DescribeFHIRImportJobRequest$DatastoreId' => '<p>The AWS-generated ID of the Data Store.</p>', 'ExportJobProperties$DatastoreId' => '<p>The AWS generated ID for the Data Store from which files are being exported for an export job.</p>', 'ImportJobProperties$DatastoreId' => '<p>The datastore id used when the Import job was created. </p>', 'ListFHIRExportJobsRequest$DatastoreId' => '<p> This parameter limits the response to the export job with the specified Data Store ID. </p>', 'ListFHIRImportJobsRequest$DatastoreId' => '<p> This parameter limits the response to the import job with the specified Data Store ID. </p>', 'StartFHIRExportJobRequest$DatastoreId' => '<p>The AWS generated ID for the Data Store from which files are being exported for an export job.</p>', 'StartFHIRExportJobResponse$DatastoreId' => '<p>The AWS generated ID for the Data Store from which files are being exported for an export job.</p>', 'StartFHIRImportJobRequest$DatastoreId' => '<p>The AWS-generated Data Store ID.</p>', 'StartFHIRImportJobResponse$DatastoreId' => '<p>The AWS-generated Data Store ID.</p>', ], ], 'DatastoreName' => [ 'base' => NULL, 'refs' => [ 'CreateFHIRDatastoreRequest$DatastoreName' => '<p>The user generated name for the Data Store.</p>', 'DatastoreFilter$DatastoreName' => '<p>Allows the user to filter Data Store results by name.</p>', 'DatastoreProperties$DatastoreName' => '<p>The user-generated name for the Data Store.</p>', ], ], 'DatastoreProperties' => [ 'base' => '<p>Displays the properties of the Data Store, including the ID, Arn, name, and the status of the Data Store.</p>', 'refs' => [ 'DatastorePropertiesList$member' => NULL, 'DescribeFHIRDatastoreResponse$DatastoreProperties' => '<p>All properties associated with a Data Store, including the Data Store ID, Data Store ARN, Data Store name, Data Store status, created at, Data Store type version, and Data Store endpoint.</p>', ], ], 'DatastorePropertiesList' => [ 'base' => NULL, 'refs' => [ 'ListFHIRDatastoresResponse$DatastorePropertiesList' => '<p>All properties associated with the listed Data Stores.</p>', ], ], 'DatastoreStatus' => [ 'base' => NULL, 'refs' => [ 'CreateFHIRDatastoreResponse$DatastoreStatus' => '<p>The status of the FHIR Data Store. Possible statuses are ‘CREATING’, ‘ACTIVE’, ‘DELETING’, ‘DELETED’.</p>', 'DatastoreFilter$DatastoreStatus' => '<p>Allows the user to filter Data Store results by status.</p>', 'DatastoreProperties$DatastoreStatus' => '<p>The status of the Data Store. Possible statuses are \'CREATING\', \'ACTIVE\', \'DELETING\', or \'DELETED\'.</p>', 'DeleteFHIRDatastoreResponse$DatastoreStatus' => '<p>The status of the Data Store that the user has requested to be deleted. </p>', ], ], 'DeleteFHIRDatastoreRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteFHIRDatastoreResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeFHIRDatastoreRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeFHIRDatastoreResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeFHIRExportJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeFHIRExportJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeFHIRImportJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeFHIRImportJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'EncryptionKeyID' => [ 'base' => NULL, 'refs' => [ 'KmsEncryptionConfig$KmsKeyId' => '<p> The KMS encryption key id/alias used to encrypt the Data Store contents at rest. </p>', 'S3Configuration$KmsKeyId' => '<p> The KMS key ID used to access the S3 bucket. </p>', ], ], 'ExportJobProperties' => [ 'base' => '<p>The properties of a FHIR export job, including the ID, ARN, name, and the status of the job.</p>', 'refs' => [ 'DescribeFHIRExportJobResponse$ExportJobProperties' => '<p>Displays the properties of the export job, including the ID, Arn, Name, and the status of the job. </p>', 'ExportJobPropertiesList$member' => NULL, ], ], 'ExportJobPropertiesList' => [ 'base' => NULL, 'refs' => [ 'ListFHIRExportJobsResponse$ExportJobPropertiesList' => '<p> The properties of listed FHIR export jobs, including the ID, ARN, name, and the status of the job. </p>', ], ], 'FHIRVersion' => [ 'base' => NULL, 'refs' => [ 'CreateFHIRDatastoreRequest$DatastoreTypeVersion' => '<p>The FHIR version of the Data Store. The only supported version is R4.</p>', 'DatastoreProperties$DatastoreTypeVersion' => '<p>The FHIR version. Only R4 version data is supported.</p>', ], ], 'IamRoleArn' => [ 'base' => NULL, 'refs' => [ 'ExportJobProperties$DataAccessRoleArn' => '<p>The Amazon Resource Name used during the initiation of the job.</p>', 'ImportJobProperties$DataAccessRoleArn' => '<p>The Amazon Resource Name (ARN) that gives Amazon HealthLake access to your input data.</p>', 'StartFHIRExportJobRequest$DataAccessRoleArn' => '<p>The Amazon Resource Name used during the initiation of the job.</p>', 'StartFHIRImportJobRequest$DataAccessRoleArn' => '<p>The Amazon Resource Name (ARN) that gives Amazon HealthLake access permission.</p>', ], ], 'ImportJobProperties' => [ 'base' => '<p>Displays the properties of the import job, including the ID, Arn, Name, and the status of the Data Store.</p>', 'refs' => [ 'DescribeFHIRImportJobResponse$ImportJobProperties' => '<p>The properties of the Import job request, including the ID, ARN, name, and the status of the job.</p>', 'ImportJobPropertiesList$member' => NULL, ], ], 'ImportJobPropertiesList' => [ 'base' => NULL, 'refs' => [ 'ListFHIRImportJobsResponse$ImportJobPropertiesList' => '<p> The properties of a listed FHIR import jobs, including the ID, ARN, name, and the status of the job. </p>', ], ], 'InputDataConfig' => [ 'base' => '<p> The input properties for an import job.</p>', 'refs' => [ 'ImportJobProperties$InputDataConfig' => '<p>The input data configuration that was supplied when the Import job was created.</p>', 'StartFHIRImportJobRequest$InputDataConfig' => '<p>The input properties of the FHIR Import job in the StartFHIRImport job request.</p>', ], ], 'InternalServerException' => [ 'base' => '<p>Unknown error occurs in the service.</p>', 'refs' => [], ], 'JobId' => [ 'base' => NULL, 'refs' => [ 'DescribeFHIRExportJobRequest$JobId' => '<p>The AWS generated ID for an export job.</p>', 'DescribeFHIRImportJobRequest$JobId' => '<p>The AWS-generated job ID.</p>', 'ExportJobProperties$JobId' => '<p>The AWS generated ID for an export job.</p>', 'ImportJobProperties$JobId' => '<p>The AWS-generated id number for the Import job.</p>', 'StartFHIRExportJobResponse$JobId' => '<p>The AWS generated ID for an export job.</p>', 'StartFHIRImportJobResponse$JobId' => '<p>The AWS-generated job ID.</p>', ], ], 'JobName' => [ 'base' => NULL, 'refs' => [ 'ExportJobProperties$JobName' => '<p>The user generated name for an export job.</p>', 'ImportJobProperties$JobName' => '<p>The user-generated name for an Import job.</p>', 'ListFHIRExportJobsRequest$JobName' => '<p> This parameter limits the response to the export job with the specified job name. </p>', 'ListFHIRImportJobsRequest$JobName' => '<p> This parameter limits the response to the import job with the specified job name. </p>', 'StartFHIRExportJobRequest$JobName' => '<p>The user generated name for an export job.</p>', 'StartFHIRImportJobRequest$JobName' => '<p>The name of the FHIR Import job in the StartFHIRImport job request.</p>', ], ], 'JobStatus' => [ 'base' => NULL, 'refs' => [ 'ExportJobProperties$JobStatus' => '<p>The status of a FHIR export job. Possible statuses are SUBMITTED, IN_PROGRESS, COMPLETED, or FAILED.</p>', 'ImportJobProperties$JobStatus' => '<p>The job status for an Import job. Possible statuses are SUBMITTED, IN_PROGRESS, COMPLETED, FAILED.</p>', 'ListFHIRExportJobsRequest$JobStatus' => '<p> This parameter limits the response to the export jobs with the specified job status. </p>', 'ListFHIRImportJobsRequest$JobStatus' => '<p> This parameter limits the response to the import job with the specified job status. </p>', 'StartFHIRExportJobResponse$JobStatus' => '<p>The status of a FHIR export job. Possible statuses are SUBMITTED, IN_PROGRESS, COMPLETED, or FAILED.</p>', 'StartFHIRImportJobResponse$JobStatus' => '<p>The status of an import job.</p>', ], ], 'KmsEncryptionConfig' => [ 'base' => '<p> The customer-managed-key(CMK) used when creating a Data Store. If a customer owned key is not specified, an AWS owned key will be used for encryption. </p>', 'refs' => [ 'SseConfiguration$KmsEncryptionConfig' => '<p> The KMS encryption configuration used to provide details for data encryption. </p>', ], ], 'ListFHIRDatastoresRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListFHIRDatastoresResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListFHIRExportJobsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListFHIRExportJobsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListFHIRImportJobsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListFHIRImportJobsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'MaxResultsInteger' => [ 'base' => NULL, 'refs' => [ 'ListFHIRDatastoresRequest$MaxResults' => '<p>The maximum number of Data Stores returned in a single page of a ListFHIRDatastoresRequest call.</p>', 'ListFHIRExportJobsRequest$MaxResults' => '<p> This parameter limits the number of results returned for a ListFHIRExportJobs to a maximum quantity specified by the user. </p>', 'ListFHIRImportJobsRequest$MaxResults' => '<p> This parameter limits the number of results returned for a ListFHIRImportJobs to a maximum quantity specified by the user. </p>', ], ], 'Message' => [ 'base' => NULL, 'refs' => [ 'ExportJobProperties$Message' => '<p>An explanation of any errors that may have occurred during the export job.</p>', 'ImportJobProperties$Message' => '<p>An explanation of any errors that may have occurred during the FHIR import job. </p>', ], ], 'NextToken' => [ 'base' => NULL, 'refs' => [ 'ListFHIRDatastoresRequest$NextToken' => '<p>Fetches the next page of Data Stores when results are paginated.</p>', 'ListFHIRDatastoresResponse$NextToken' => '<p>Pagination token that can be used to retrieve the next page of results.</p>', 'ListFHIRExportJobsRequest$NextToken' => '<p> A pagination token used to identify the next page of results to return for a ListFHIRExportJobs query. </p>', 'ListFHIRExportJobsResponse$NextToken' => '<p> A pagination token used to identify the next page of results to return for a ListFHIRExportJobs query. </p>', 'ListFHIRImportJobsRequest$NextToken' => '<p> A pagination token used to identify the next page of results to return for a ListFHIRImportJobs query. </p>', 'ListFHIRImportJobsResponse$NextToken' => '<p> A pagination token used to identify the next page of results to return for a ListFHIRImportJobs query. </p>', ], ], 'OutputDataConfig' => [ 'base' => '<p>The output data configuration that was supplied when the export job was created.</p>', 'refs' => [ 'ExportJobProperties$OutputDataConfig' => '<p>The output data configuration that was supplied when the export job was created.</p>', 'ImportJobProperties$JobOutputDataConfig' => NULL, 'StartFHIRExportJobRequest$OutputDataConfig' => '<p>The output data configuration that was supplied when the export job was created.</p>', 'StartFHIRImportJobRequest$JobOutputDataConfig' => NULL, ], ], 'PreloadDataConfig' => [ 'base' => '<p> The input properties for the preloaded Data Store. Only data preloaded from Synthea is supported.</p>', 'refs' => [ 'CreateFHIRDatastoreRequest$PreloadDataConfig' => '<p>Optional parameter to preload data upon creation of the Data Store. Currently, the only supported preloaded data is synthetic data generated from Synthea.</p>', 'DatastoreProperties$PreloadDataConfig' => '<p>The preloaded data configuration for the Data Store. Only data preloaded from Synthea is supported.</p>', ], ], 'PreloadDataType' => [ 'base' => NULL, 'refs' => [ 'PreloadDataConfig$PreloadDataType' => '<p>The type of preloaded data. Only Synthea preloaded data is supported.</p>', ], ], 'ResourceNotFoundException' => [ 'base' => '<p> The requested Data Store was not found.</p>', 'refs' => [], ], 'S3Configuration' => [ 'base' => '<p> The configuration of the S3 bucket for either an import or export job. This includes assigning permissions for access. </p>', 'refs' => [ 'OutputDataConfig$S3Configuration' => '<p> The output data configuration that was supplied when the export job was created. </p>', ], ], 'S3Uri' => [ 'base' => NULL, 'refs' => [ 'InputDataConfig$S3Uri' => '<p>The S3Uri is the user specified S3 location of the FHIR data to be imported into Amazon HealthLake. </p>', 'S3Configuration$S3Uri' => '<p> The S3Uri is the user specified S3 location of the FHIR data to be imported into Amazon HealthLake. </p>', ], ], 'SseConfiguration' => [ 'base' => '<p> The server-side encryption key configuration for a customer provided encryption key. </p>', 'refs' => [ 'CreateFHIRDatastoreRequest$SseConfiguration' => '<p> The server-side encryption key configuration for a customer provided encryption key specified for creating a Data Store. </p>', 'DatastoreProperties$SseConfiguration' => '<p> The server-side encryption key configuration for a customer provided encryption key (CMK). </p>', ], ], 'StartFHIRExportJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'StartFHIRExportJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'StartFHIRImportJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'StartFHIRImportJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'String' => [ 'base' => NULL, 'refs' => [ 'AccessDeniedException$Message' => NULL, 'ConflictException$Message' => NULL, 'DatastoreProperties$DatastoreEndpoint' => '<p>The AWS endpoint for the Data Store. Each Data Store will have it\'s own endpoint with Data Store ID in the endpoint URL.</p>', 'InternalServerException$Message' => NULL, 'ResourceNotFoundException$Message' => NULL, 'ThrottlingException$Message' => NULL, 'ValidationException$Message' => NULL, ], ], 'Tag' => [ 'base' => '<p> A tag is a label consisting of a user-defined key and value. The form for tags is {"Key", "Value"} </p>', 'refs' => [ 'TagList$member' => NULL, ], ], 'TagKey' => [ 'base' => NULL, 'refs' => [ 'Tag$Key' => '<p> The key portion of a tag. Tag keys are case sensitive. </p>', 'TagKeyList$member' => NULL, ], ], 'TagKeyList' => [ 'base' => NULL, 'refs' => [ 'UntagResourceRequest$TagKeys' => '<p> The keys for the tags to be removed from the Healthlake Data Store. </p>', ], ], 'TagList' => [ 'base' => NULL, 'refs' => [ 'CreateFHIRDatastoreRequest$Tags' => '<p> Resource tags that are applied to a Data Store when it is created. </p>', 'ListTagsForResourceResponse$Tags' => '<p> Returns a list of tags associated with a Data Store. </p>', 'TagResourceRequest$Tags' => '<p> The user specified key and value pair tags being added to a Data Store. </p>', ], ], 'TagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'TagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'TagValue' => [ 'base' => NULL, 'refs' => [ 'Tag$Value' => '<p> The value portion of tag. Tag values are case sensitive. </p>', ], ], 'ThrottlingException' => [ 'base' => '<p>The user has exceeded their maximum number of allowed calls to the given API. </p>', 'refs' => [], ], 'Timestamp' => [ 'base' => NULL, 'refs' => [ 'DatastoreFilter$CreatedBefore' => '<p>A filter that allows the user to set cutoff dates for records. All Data Stores created before the specified date will be included in the results. </p>', 'DatastoreFilter$CreatedAfter' => '<p>A filter that allows the user to set cutoff dates for records. All Data Stores created after the specified date will be included in the results.</p>', 'DatastoreProperties$CreatedAt' => '<p>The time that a Data Store was created. </p>', 'ExportJobProperties$SubmitTime' => '<p>The time an export job was initiated.</p>', 'ExportJobProperties$EndTime' => '<p>The time an export job completed.</p>', 'ImportJobProperties$SubmitTime' => '<p>The time that the Import job was submitted for processing.</p>', 'ImportJobProperties$EndTime' => '<p>The time that the Import job was completed.</p>', 'ListFHIRExportJobsRequest$SubmittedBefore' => '<p> This parameter limits the response to FHIR export jobs submitted before a user specified date. </p>', 'ListFHIRExportJobsRequest$SubmittedAfter' => '<p> This parameter limits the response to FHIR export jobs submitted after a user specified date. </p>', 'ListFHIRImportJobsRequest$SubmittedBefore' => '<p> This parameter limits the response to FHIR import jobs submitted before a user specified date. </p>', 'ListFHIRImportJobsRequest$SubmittedAfter' => '<p> This parameter limits the response to FHIR import jobs submitted after a user specified date. </p>', ], ], 'UntagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'UntagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'ValidationException' => [ 'base' => '<p>The user input parameter was invalid.</p>', 'refs' => [], ], ],];
